#ifndef BROWSER_H
#define BROWSER_H

#include <QtGui>

#if (QT_VERSION >= QT_VERSION_CHECK(5, 0, 0))
# include <QtWebKitWidgets/QGraphicsWebView>
# include <QtWebKitWidgets/QWebFrame>
#else
# include <QGraphicsWebView>
# include <QWebFrame>
# include <QtWebKit/qwebview.h>
#endif

#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QList>

#ifndef QT_NO_OPENSSL
#include <QSslError>
#endif

class QLineEdit;

class HTTPNetworkAccessManager : public QNetworkAccessManager
{
    Q_OBJECT;
public:
    HTTPNetworkAccessManager(QObject *parent, bool ignore_ssl_errors);
protected:
    QNetworkReply* createRequest(Operation op, const QNetworkRequest &req, QIODevice *outgoingData);

protected slots:
#ifndef QT_NO_OPENSSL
    void handleSslErrors(QNetworkReply*, QList<QSslError>);
#endif
private:
    bool m_ignoreSslErrors;
};

class Browser : public QGraphicsWebView
{
Q_OBJECT

public:
    Browser(QGraphicsScene& scene, const QString& initial_url, bool is_video, bool enable_gui, bool enable_tiled_backing_store, const QString& user_agent, bool ignore_ssl_errors);
    virtual ~Browser();

    //setters and getters
    void setScreenshotPath(const QString &value);
    static void emitQuitApp();
    static void emitDumpWebCoreStatistics();
    static void emitClearWebCoreCaches();

Q_SIGNALS:
    void callMethod(QString methodName, QVariantList params);
    void documentLoaded();

public slots:
    void sendCallMethod(QString methodName, QVariantList params);
    void traceWebKit();
    void onDocumentLoaded(bool);

private slots:
    void loadEnteredURL();
    void scaleVideo();
    void quitApp();
    void onAnimate();
    void makeScreenshot();
    void dumpWebCoreStatistics();
    void clearWebCoreCaches();
    void javaScriptWindowObjectCleared();

private:
    static QString constructVideoHtml(const QString& video_url);
    void startAnimation();
    void stopAnimation();
    float interpolate(float start, float end, float percentComplete);
    void loadURL(const QString& url);
    void keyPressEvent( QKeyEvent *event );

    QGraphicsRectItem* m_webFrame;
    QString m_screenshotPath;
    QLineEdit* m_pathEditor;
    QLineEdit* m_urlEditor;
    QTimer m_animTimer;
    QTime m_animTime;
    int m_animLatchTime;
    QRectF m_animStartRect;
    QRectF m_animEndRect;
    QRectF m_largeRect;
    QRectF m_smallRect;
    float m_animDuration;
    float m_animFPS;
    bool m_animLarge;
    bool m_isVideo;
};

#endif // BROWSER_H
