QT_CONFIG_OPTS	:= $(shell echo $(QT_CONFIG_OPTS) | sed "s: -prefix $(PREFIX)::")

# use different paths for build and stage
BUILD_DIR_SUFFIX:= $(shell echo $(BUILD_CONFIG) | sed "s,:,_,g")
STAGE_DIR		:= 
BUILD_DIR		:= $(CURDIR)/default_build$(BUILD_DIR_SUFFIX)
PREFIX			:= $(CURDIR)/default_stage$(BUILD_DIR_SUFFIX)
QT_STAGE_DIR	:= $(STAGE_DIR)$(PREFIX)
QT_CONFIG_OPTS	+= -prefix $(PREFIX)

# and udev
QT_CONFIG_OPTS	:= $(filter-out -no-libudev,$(QT_CONFIG_OPTS))

# enable QtWebEngine
ifneq (,$(findstring qtwebengine,$(BUILD_CONFIG)))
	QT_CONFIG_OPTS	:= $(shell echo $(QT_CONFIG_OPTS) | sed "s: -skip webengine::")
endif

ifneq (,$(findstring eglfs,$(BUILD_CONFIG)))
# on ubuntu you'll need to install: libegl1-mesa-dev libgles2-mesa-dev
	 QT_CONFIG_OPTS	+= -eglfs -opengl es2
endif

ifneq (,$(findstring directfb,$(BUILD_CONFIG)))
# this requires DirectFB 1.7, add following to emulate RNG150: -no-opengl
	QT_CONFIG_OPTS	+= -qpa directfb -directfb
endif

ifneq (,$(findstring no-gui,$(BUILD_CONFIG)))
# GUI less mode
	QT_CONFIG_OPTS	:= $(filter-out -gstreamer,$(QT_CONFIG_OPTS))
	QT_CONFIG_OPTS	:= $(filter-out -icu,$(QT_CONFIG_OPTS))
	QT_CONFIG_OPTS	:= $(filter-out -opengl,$(QT_CONFIG_OPTS))
	QT_CONFIG_OPTS	:= $(filter-out -webrtc,$(QT_CONFIG_OPTS))
	QT_CONFIG_OPTS  += -no-gui -skip webkit -skip webrtc -skip webkit-examples -skip webengine -skip imageformats
else
# bring back xcb
	QT_CONFIG_OPTS	:= $(filter-out -no-xshape,$(QT_CONFIG_OPTS))
	QT_CONFIG_OPTS	:= $(filter-out -no-xcb,$(QT_CONFIG_OPTS))
	QT_CONFIG_OPTS	+= -system-xcb
endif
