/*
 * Copyright (C) 2007-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2008 Matt Lilek. All rights reserved.
 * Copyright (C) 2008-2009 Anthony Ricaud <rik@webkit.org>
 * Copyright (C) 2009-2010 Joseph Pecoraro. All rights reserved.
 * Copyright (C) 2009-2011 Google Inc. All rights reserved.
 * Copyright (C) 2009 280 North Inc. All Rights Reserved.
 * Copyright (C) 2010 Nikita Vasilyev. All rights reserved.
 * Copyright (C) 2011 Brian Grinstead All rights reserved.
 * Copyright (C) 2013 Matt Holden <jftholden@yahoo.com>
 * Copyright (C) 2013 Samsung Electronics. All rights reserved.
 * Copyright (C) 2013 Seokju Kwon (seokju.kwon@gmail.com)
 * Copyright (C) 2013 Adobe Systems Inc. All rights reserved.
 * Copyright (C) 2013-2015 University of Washington. All rights reserved.
 * Copyright (C) 2014-2015 Saam Barati <saambarati1@gmail.com>
 * Copyright (C) 2014 Antoine Quint
 * Copyright (C) 2015 Tobias Reiss <tobi+webkit@basecode.de>
 * Copyright (C) 2015-2016 Devin Rousso <dcrousso+webkit@gmail.com>. All rights reserved.
 * Copyright (C) 2017 Sony Interactive Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
var WebInspector={};WebInspector.Platform={name:InspectorFrontendHost.platform(),isNightlyBuild:false,version:{base:0,release:0,name:""}};(function(){var versionMatch=/ AppleWebKit\/([^ ]+)/.exec(navigator.userAgent);if(versionMatch&&versionMatch[1].indexOf("+")!==-1&&document.styleSheets.length<10)
WebInspector.Platform.isNightlyBuild=true;var osVersionMatch=/ Mac OS X (\d+)_(\d+)/.exec(navigator.appVersion);if(osVersionMatch&&osVersionMatch[1]==="10"){WebInspector.Platform.version.base=10;WebInspector.Platform.version.release=parseInt(osVersionMatch[2]);switch(osVersionMatch[2]){case"12":WebInspector.Platform.version.name="sierra";break;case"11":WebInspector.Platform.version.name="el-capitan";break;case"10":WebInspector.Platform.version.name="yosemite";break;default:WebInspector.Platform.version.name="unknown-mac";break;}}})();class LinkedList
{constructor()
{this.head=new LinkedListNode;this.head.next=this.head.prev=this.head;this.length=0;}
clear()
{this.head.next=this.head.prev=this.head;this.length=0;}
get last()
{return this.head.prev;}
push(item)
{let newNode=new LinkedListNode(item);let last=this.last;let head=this.head;last.next=newNode;newNode.next=head;head.prev=newNode;newNode.prev=last;this.length++;return newNode;}
remove(node)
{if(!node)
return false;node.prev.next=node.next;node.next.prev=node.prev;this.length--;return true;}
forEach(callback)
{let node=this.head;for(let i=0,length=this.length;i<length;i++){node=node.next;let returnValue=callback(node.value,i);if(returnValue===false)
return;}}
toArray()
{let node=this.head;let i=this.length;let result=new Array(i);while(i--){node=node.prev;result[i]=node.value;}
return result;}
toJSON()
{return this.toArray();}}
class LinkedListNode
{constructor(value)
{this.value=value;this.prev=null;this.next=null;}}
class ListMultimap
{constructor()
{this._insertionOrderedEntries=new LinkedList;this._keyMap=new Map;}
get size()
{return this._insertionOrderedEntries.length;}
add(key,value)
{let nodeMap=this._keyMap.get(key);if(!nodeMap){nodeMap=new Map;this._keyMap.set(key,nodeMap);}
let node=nodeMap.get(value);if(!node){node=this._insertionOrderedEntries.push([key,value]);nodeMap.set(value,node);}
return this;}
delete(key,value)
{let nodeMap=this._keyMap.get(key);if(!nodeMap)
return false;let node=nodeMap.get(value);if(!node)
return false;nodeMap.delete(value);this._insertionOrderedEntries.remove(node);return true;}
deleteAll(key)
{let nodeMap=this._keyMap.get(key);if(!nodeMap)
return false;let list=this._insertionOrderedEntries;let didDelete=false;nodeMap.forEach(function(node){list.remove(node);didDelete=true;});this._keyMap.delete(key);return didDelete;}
has(key,value)
{let nodeMap=this._keyMap.get(key);if(!nodeMap)
return false;return nodeMap.has(value);}
clear()
{this._keyMap=new Map;this._insertionOrderedEntries=new LinkedList;}
forEach(callback)
{this._insertionOrderedEntries.forEach(callback);}
toArray()
{return this._insertionOrderedEntries.toArray();}
toJSON()
{return this.toArray();}}
WebInspector.Object=class WebInspectorObject
{constructor()
{this._listeners=null;} 
static addEventListener(eventType,listener,thisObject)
{thisObject=thisObject||null;if(!eventType)
return null;if(!listener)
return null;if(!this._listeners)
this._listeners=new Map();let listenersTable=this._listeners.get(eventType);if(!listenersTable){listenersTable=new ListMultimap();this._listeners.set(eventType,listenersTable);}
listenersTable.add(thisObject,listener);return listener;}
static singleFireEventListener(eventType,listener,thisObject)
{let wrappedCallback=function(){this.removeEventListener(eventType,wrappedCallback,null);listener.apply(thisObject,arguments);}.bind(this);this.addEventListener(eventType,wrappedCallback,null);return wrappedCallback;}
static removeEventListener(eventType,listener,thisObject)
{eventType=eventType||null;listener=listener||null;thisObject=thisObject||null;if(!this._listeners)
return;if(thisObject&&!eventType){this._listeners.forEach(function(listenersTable){let listenerPairs=listenersTable.toArray();for(let i=0,length=listenerPairs.length;i<length;++i){let existingThisObject=listenerPairs[i][0];if(existingThisObject===thisObject)
listenersTable.deleteAll(existingThisObject);}});return;}
let listenersTable=this._listeners.get(eventType);if(!listenersTable||listenersTable.size===0)
return;let didDelete=listenersTable.delete(thisObject,listener);}
static awaitEvent(eventType)
{let wrapper=new WebInspector.WrappedPromise;this.singleFireEventListener(eventType,(event)=>wrapper.resolve(event));return wrapper.promise;}
static hasEventListeners(eventType)
{if(!this._listeners)
return false;let listenersTable=this._listeners.get(eventType);return listenersTable&&listenersTable.size>0;}
static retainedObjectsWithPrototype(proto)
{let results=new Set;if(this._listeners){this._listeners.forEach(function(listenersTable,eventType){listenersTable.forEach(function(pair){let thisObject=pair[0];if(thisObject instanceof proto)
results.add(thisObject);});});}
return results;} 
addEventListener(){return WebInspector.Object.addEventListener.apply(this,arguments);}
singleFireEventListener(){return WebInspector.Object.singleFireEventListener.apply(this,arguments);}
removeEventListener(){return WebInspector.Object.removeEventListener.apply(this,arguments);}
awaitEvent(){return WebInspector.Object.awaitEvent.apply(this,arguments);}
hasEventListeners(){return WebInspector.Object.hasEventListeners.apply(this,arguments);}
retainedObjectsWithPrototype(){return WebInspector.Object.retainedObjectsWithPrototype.apply(this,arguments);}
dispatchEventToListeners(eventType,eventData)
{let event=new WebInspector.Event(this,eventType,eventData);function dispatch(object)
{if(!object||event._stoppedPropagation)
return;let listenerTypesMap=object._listeners;if(!listenerTypesMap||!object.hasOwnProperty("_listeners"))
return;let listenersTable=listenerTypesMap.get(eventType);if(!listenersTable)
return;let listeners=listenersTable.toArray();for(let i=0,length=listeners.length;i<length;++i){let[thisObject,listener]=listeners[i];listener.call(thisObject,event);if(event._stoppedPropagation)
break;}}
dispatch(this);event._stoppedPropagation=false;let constructor=this.constructor;while(constructor){dispatch(constructor);if(!constructor.prototype.__proto__)
break;constructor=constructor.prototype.__proto__.constructor;}
return event.defaultPrevented;}};WebInspector.Event=class Event
{constructor(target,type,data)
{this.target=target;this.type=type;this.data=data;this.defaultPrevented=false;this._stoppedPropagation=false;}
stopPropagation()
{this._stoppedPropagation=true;}
preventDefault()
{this.defaultPrevented=true;}};WebInspector.notifications=new WebInspector.Object;WebInspector.Notification={GlobalModifierKeysDidChange:"global-modifiers-did-change",PageArchiveStarted:"page-archive-started",PageArchiveEnded:"page-archive-ended",ExtraDomainsActivated:"extra-domains-activated",TabTypesChanged:"tab-types-changed",DebugUIEnabledDidChange:"debug-ui-enabled-did-change",VisibilityStateDidChange:"visibility-state-did-change",};WebInspector.roleSelectorForNode=function(node)
{ var title="";var role=node.computedRole();if(role)
title=":role("+role+")";return title;};WebInspector.linkifyAccessibilityNodeReference=function(node)
{if(!node)
return null;var link=WebInspector.linkifyNodeReference(node);var tagIdSelector=link.title;var classSelectorIndex=tagIdSelector.indexOf(".");if(classSelectorIndex>-1)
tagIdSelector=tagIdSelector.substring(0,classSelectorIndex);var roleSelector=WebInspector.roleSelectorForNode(node);link.textContent=tagIdSelector+roleSelector;link.title+=roleSelector;return link;};WebInspector.linkifyNodeReference=function(node,options={})
{let displayName=node.displayName;if(!isNaN(options.maxLength))
displayName=displayName.truncate(options.maxLength);let link=document.createElement("span");link.append(displayName);return WebInspector.linkifyNodeReferenceElement(node,link,Object.shallowMerge(options,{displayName}));};WebInspector.linkifyNodeReferenceElement=function(node,element,options={})
{element.setAttribute("role","link");element.title=options.displayName||node.displayName;let nodeType=node.nodeType();if((nodeType!==Node.DOCUMENT_NODE||node.parentNode)&&nodeType!==Node.TEXT_NODE)
element.classList.add("node-link");element.addEventListener("click",WebInspector.domTreeManager.inspectElement.bind(WebInspector.domTreeManager,node.id));element.addEventListener("mouseover",WebInspector.domTreeManager.highlightDOMNode.bind(WebInspector.domTreeManager,node.id,"all"));element.addEventListener("mouseout",WebInspector.domTreeManager.hideDOMNodeHighlight.bind(WebInspector.domTreeManager));element.addEventListener("contextmenu",(event)=>{let contextMenu=WebInspector.ContextMenu.createFromEvent(event);WebInspector.appendContextMenuItemsForDOMNode(contextMenu,node,options);});return element;};function createSVGElement(tagName)
{return document.createElementNS("http://www.w3.org/2000/svg",tagName);}
WebInspector.cssPath=function(node)
{if(node.nodeType()!==Node.ELEMENT_NODE)
return"";let suffix="";if(node.isPseudoElement()){suffix="::"+node.pseudoType();node=node.parentNode;}
let components=[];while(node){let component=WebInspector.cssPathComponent(node);if(!component)
break;components.push(component);if(component.done)
break;node=node.parentNode;}
components.reverse();return components.map((x)=>x.value).join(" > ")+suffix;};WebInspector.cssPathComponent=function(node)
{if(node.nodeType()!==Node.ELEMENT_NODE)
return null;let nodeName=node.nodeNameInCorrectCase();let lowerNodeName=node.nodeName().toLowerCase();if(lowerNodeName==="body"||lowerNodeName==="head"||lowerNodeName==="html")
return{value:nodeName,done:true};let id=node.getAttribute("id");if(id)
return{value:node.escapedIdSelector,done:true};if(!node.parentNode||node.parentNode.nodeType()===Node.DOCUMENT_NODE)
return{value:nodeName,done:true};

function classNames(node){let classAttribute=node.getAttribute("class");return classAttribute?classAttribute.trim().split(/\s+/):[];}
let nthChildIndex=-1;let hasUniqueTagName=true;let uniqueClasses=new Set(classNames(node));let siblings=node.parentNode.children;let elementIndex=0;for(let sibling of siblings){if(sibling.nodeType()!==Node.ELEMENT_NODE)
continue;elementIndex++;if(sibling===node){nthChildIndex=elementIndex;continue;}
if(sibling.nodeNameInCorrectCase()===nodeName)
hasUniqueTagName=false;if(uniqueClasses.size){let siblingClassNames=classNames(sibling);for(let className of siblingClassNames)
uniqueClasses.delete(className);}}
let selector=nodeName;if(lowerNodeName==="input"&&node.getAttribute("type")&&!uniqueClasses.size)
selector+=`[type="${node.getAttribute("type")}"]`;if(!hasUniqueTagName){if(uniqueClasses.size)
selector+=node.escapedClassSelector;else
selector+=`:nth-child(${nthChildIndex})`;}
return{value:selector,done:false};};WebInspector.xpath=function(node)
{if(node.nodeType()===Node.DOCUMENT_NODE)
return"/";let components=[];while(node){let component=WebInspector.xpathComponent(node);if(!component)
break;components.push(component);if(component.done)
break;node=node.parentNode;}
components.reverse();let prefix=components.length&&components[0].done?"":"/";return prefix+components.map((x)=>x.value).join("/");};WebInspector.xpathComponent=function(node)
{let index=WebInspector.xpathIndex(node);if(index===-1)
return null;let value;switch(node.nodeType()){case Node.DOCUMENT_NODE:return{value:"",done:true};case Node.ELEMENT_NODE:var id=node.getAttribute("id");if(id)
return{value:`//*[@id="${id}"]`,done:true};value=node.localName();break;case Node.ATTRIBUTE_NODE:value=`@${node.nodeName()}`;break;case Node.TEXT_NODE:case Node.CDATA_SECTION_NODE:value="text()";break;case Node.COMMENT_NODE:value="comment()";break;case Node.PROCESSING_INSTRUCTION_NODE:value="processing-instruction()";break;default:value="";break;}
if(index>0)
value+=`[${index}]`;return{value,done:false};};WebInspector.xpathIndex=function(node)
{if(!node.parentNode)
return 0;let siblings=node.parentNode.children;if(siblings.length<=1)
return 0;
 function isSimiliarNode(a,b){if(a===b)
return true;let aType=a.nodeType();let bType=b.nodeType();if(aType===Node.ELEMENT_NODE&&bType===Node.ELEMENT_NODE)
return a.localName()===b.localName();if(aType===Node.CDATA_SECTION_NODE)
return aType===Node.TEXT_NODE;if(bType===Node.CDATA_SECTION_NODE)
return bType===Node.TEXT_NODE;return aType===bType;}
let unique=true;let xPathIndex=-1;let xPathIndexCounter=1;for(let sibling of siblings){if(!isSimiliarNode(node,sibling))
continue;if(node===sibling){xPathIndex=xPathIndexCounter;if(!unique)
return xPathIndex;}else{unique=false;if(xPathIndex!==-1)
return xPathIndex;}
xPathIndexCounter++;}
if(unique)
return 0;return xPathIndex;};WebInspector.EventListener=class EventListener
{constructor(thisObject,fireOnce)
{this._thisObject=thisObject;this._emitter=null;this._callback=null;this._fireOnce=fireOnce;} 
connect(emitter,type,callback,usesCapture)
{var emitterIsValid=emitter&&(emitter instanceof WebInspector.Object||emitter instanceof Node||(typeof emitter.addEventListener==="function"));if(!emitterIsValid||!type||!callback)
return;this._emitter=emitter;this._type=type;this._usesCapture=!!usesCapture;if(emitter instanceof Node)
callback=callback.bind(this._thisObject);if(this._fireOnce){var listener=this;this._callback=function(){listener.disconnect();callback.apply(this,arguments);};}else
this._callback=callback;if(this._emitter instanceof Node)
this._emitter.addEventListener(this._type,this._callback,this._usesCapture);else
this._emitter.addEventListener(this._type,this._callback,this._thisObject);}
disconnect()
{if(!this._emitter||!this._callback)
return;if(this._emitter instanceof Node)
this._emitter.removeEventListener(this._type,this._callback,this._usesCapture);else
this._emitter.removeEventListener(this._type,this._callback,this._thisObject);if(this._fireOnce)
delete this._thisObject;delete this._emitter;delete this._type;delete this._callback;}};
WebInspector.EventListenerSet=class EventListenerSet
{constructor(defaultThisObject,name)
{this.name=name;this._defaultThisObject=defaultThisObject;this._listeners=[];this._installed=false;} 
register(emitter,type,callback,thisObject,usesCapture)
{var emitterIsValid=emitter&&(emitter instanceof WebInspector.Object||emitter instanceof Node||(typeof emitter.addEventListener==="function"));if(!emitterIsValid||!type||!callback)
return;this._listeners.push({listener:new WebInspector.EventListener(thisObject||this._defaultThisObject),emitter,type,callback,usesCapture});}
unregister()
{if(this._installed)
this.uninstall();this._listeners=[];}
install()
{if(this._installed)
return;this._installed=true;for(var data of this._listeners)
data.listener.connect(data.emitter,data.type,data.callback,data.usesCapture);}
uninstall(unregisterListeners)
{if(!this._installed)
return;this._installed=false;for(var data of this._listeners)
data.listener.disconnect();if(unregisterListeners)
this._listeners=[];}};function useSVGSymbol(url,className,title)
{const svgNamespace="http://www.w3.org/2000/svg";const xlinkNamespace="http://www.w3.org/1999/xlink";let svgElement=document.createElementNS(svgNamespace,"svg");svgElement.style.width="100%";svgElement.style.height="100%";
if(!url.includes("#"))
url+="#root";let useElement=document.createElementNS(svgNamespace,"use");useElement.setAttributeNS(xlinkNamespace,"xlink:href",url);svgElement.appendChild(useElement);let wrapper=document.createElement("div");wrapper.appendChild(svgElement);if(className)
wrapper.className=className;if(title)
wrapper.title=title;return wrapper;}
(function(){if(WebInspector.dontLocalizeUserInterface)
return;let localizedStringsURL=InspectorFrontendHost.localizedStringsURL();if(localizedStringsURL)
document.write("<script src=\""+localizedStringsURL+"\"></script>");})();WebInspector.unlocalizedString=function(string)
{
return string;};WebInspector.UIString=function(string,vararg)
{if(WebInspector.dontLocalizeUserInterface)
return string;if(window.localizedStrings&&string in window.localizedStrings)
return window.localizedStrings[string];if(!window.localizedStrings)
console.error(`Attempted to load localized string "${string}" before localizedStrings was initialized.`);if(!this._missingLocalizedStrings)
this._missingLocalizedStrings={};if(!(string in this._missingLocalizedStrings)){console.error("Localized string \""+string+"\" was not found.");this._missingLocalizedStrings[string]=true;}
return"LOCALIZED STRING NOT FOUND";};WebInspector.fileExtensionForURL=function(url)
{var lastPathComponent=parseURL(url).lastPathComponent;if(!lastPathComponent)
return"";var index=lastPathComponent.indexOf(".");if(index===-1)
return"";return lastPathComponent.substr(index+1);};WebInspector.mimeTypeForFileExtension=function(extension)
{const extensionToMIMEType={"html":"text/html","xhtml":"application/xhtml+xml","xml":"text/xml","js":"text/javascript","json":"application/json","clj":"text/x-clojure","coffee":"text/x-coffeescript","ls":"text/x-livescript","ts":"text/typescript","css":"text/css","less":"text/x-less","sass":"text/x-sass","scss":"text/x-scss","bmp":"image/bmp","gif":"image/gif","jpeg":"image/jpeg","jpg":"image/jpeg","pdf":"application/pdf","png":"image/png","tif":"image/tiff","tiff":"image/tiff","svg":"image/svg+xml","txt":"text/plain","xsl":"text/xsl"};return extensionToMIMEType[extension]||null;};WebInspector.fileExtensionForMIMEType=function(mimeType)
{const mimeTypeToExtension={"text/html":"html","application/xhtml+xml":"xhtml","text/xml":"xml","text/javascript":"js","application/json":"json","text/x-clojure":"clj","text/x-coffeescript":"coffee","text/x-livescript":"ls","text/typescript":"ts","text/css":"css","text/x-less":"less","text/x-sass":"sass","text/x-scss":"scss","image/bmp":"bmp","image/gif":"gif","image/jpeg":"jpg","application/pdf":"pdf","image/png":"png","image/tiff":"tiff","image/svg+xml":"svg","text/plain":"txt","text/xsl":"xsl",};let extension=mimeTypeToExtension[mimeType];return extension?`.${extension}`:null;};WebInspector.rangeForNextCSSNameOrValue=function(text,index=0){let from=0;let to=0;let colonIndex=text.indexOf(":");if(index<colonIndex){from=0;to=colonIndex;}else{from=colonIndex+1;to=text.length;}
let substring=text.substring(from,to);from+=substring.match(/^\s*/)[0].length;to-=substring.match(/[\s\;]*$/)[0].length;return{from,to};};function removeURLFragment(url)
{var hashIndex=url.indexOf("#");if(hashIndex>=0)
return url.substring(0,hashIndex);return url;}
function relativePath(path,basePath)
{var pathComponents=path.split("/");var baseComponents=basePath.replace(/\/$/,"").split("/");var finalComponents=[];var index=1;for(;index<pathComponents.length&&index<baseComponents.length;++index){if(pathComponents[index]!==baseComponents[index])
break;}
for(var i=index;i<baseComponents.length;++i)
finalComponents.push("..");for(var i=index;i<pathComponents.length;++i)
finalComponents.push(pathComponents[i]);return finalComponents.join("/");}
function parseSecurityOrigin(securityOrigin)
{securityOrigin=securityOrigin?securityOrigin.trim():"";var match=securityOrigin.match(/^([^:]+):\/\/([^\/:]*)(?::([\d]+))?$/i);if(!match)
return{scheme:null,host:null,port:null};var scheme=match[1].toLowerCase();var host=match[2].toLowerCase();var port=Number(match[3])||null;return{scheme,host,port};}
function parseDataURL(url)
{if(!url.startsWith("data:"))
return null;let match=url.match(/^data:([^;,]*)?(?:;charset=([^;,]*?))?(;base64)?,(.*)$/);if(!match)
return null;let scheme="data";let mimeType=match[1]||"text/plain";let charset=match[2]||"US-ASCII";let base64=!!match[3];let data=decodeURIComponent(match[4]);return{scheme,mimeType,charset,base64,data};}
function parseURL(url)
{url=url?url.trim():"";if(url.startsWith("data:"))
return{scheme:"data",host:null,port:null,path:null,queryString:null,fragment:null,lastPathComponent:null};var match=url.match(/^([^\/:]+):\/\/([^\/#:]*)(?::([\d]+))?(?:(\/[^#]*)?(?:#(.*))?)?$/i);if(!match)
return{scheme:null,host:null,port:null,path:null,queryString:null,fragment:null,lastPathComponent:null};var scheme=match[1].toLowerCase();var host=match[2].toLowerCase();var port=Number(match[3])||null;var wholePath=match[4]||null;var fragment=match[5]||null;var path=wholePath;var queryString=null;if(wholePath){var indexOfQuery=wholePath.indexOf("?");if(indexOfQuery!==-1){path=wholePath.substring(0,indexOfQuery);queryString=wholePath.substring(indexOfQuery+1);}
path=resolveDotsInPath(path);}
var lastPathComponent=null;if(path&&path!=="/"){var endOffset=path[path.length-1]==="/"?1:0;var lastSlashIndex=path.lastIndexOf("/",path.length-1-endOffset);if(lastSlashIndex!==-1)
lastPathComponent=path.substring(lastSlashIndex+1,path.length-endOffset);}
return{scheme,host,port,path,queryString,fragment,lastPathComponent};}
function absoluteURL(partialURL,baseURL)
{partialURL=partialURL?partialURL.trim():"";if(partialURL.startsWith("data:")||partialURL.startsWith("javascript:")||partialURL.startsWith("mailto:"))
return partialURL;if(parseURL(partialURL).scheme)
return partialURL;if(!partialURL)
return baseURL||null;var baseURLComponents=parseURL(baseURL);if(!baseURLComponents.scheme)
return null;if(partialURL[0]==="/"&&partialURL[1]==="/")
return baseURLComponents.scheme+":"+partialURL;if(!baseURLComponents.path)
baseURLComponents.path="/";var baseURLPrefix=baseURLComponents.scheme+"://"+baseURLComponents.host+(baseURLComponents.port?(":"+baseURLComponents.port):"");if(partialURL[0]==="?")
return baseURLPrefix+baseURLComponents.path+partialURL;if(partialURL[0]==="/")
return baseURLPrefix+resolveDotsInPath(partialURL);if(partialURL[0]==="#"){let queryStringComponent=baseURLComponents.queryString?"?"+baseURLComponents.queryString:"";return baseURLPrefix+baseURLComponents.path+queryStringComponent+partialURL;}
var basePath=baseURLComponents.path.substring(0,baseURLComponents.path.lastIndexOf("/"))+"/";return baseURLPrefix+resolveDotsInPath(basePath+partialURL);}
function parseLocationQueryParameters(arrayResult)
{return parseQueryString(window.location.search.substring(1),arrayResult);}
function parseQueryString(queryString,arrayResult)
{if(!queryString)
return arrayResult?[]:{};function decode(string)
{try{return decodeURIComponent(string.replace(/\+/g," "));}catch(e){return string;}}
var parameters=arrayResult?[]:{};var parameterStrings=queryString.split("&");for(var i=0;i<parameterStrings.length;++i){var pair=parameterStrings[i].split("=").map(decode);if(arrayResult)
parameters.push({name:pair[0],value:pair[1]});else
parameters[pair[0]]=pair[1];}
return parameters;}
WebInspector.displayNameForURL=function(url,urlComponents)
{if(url.startsWith("data:"))
return WebInspector.truncateURL(url);if(!urlComponents)
urlComponents=parseURL(url);var displayName;try{displayName=decodeURIComponent(urlComponents.lastPathComponent||"");}catch(e){displayName=urlComponents.lastPathComponent;}
return displayName||WebInspector.displayNameForHost(urlComponents.host)||url;};WebInspector.truncateURL=function(url,multiline=false,dataURIMaxSize=6)
{if(!url.startsWith("data:"))
return url;const dataIndex=url.indexOf(",")+1;let header=url.slice(0,dataIndex);if(multiline)
header+="\n";const data=url.slice(dataIndex);if(data.length<dataURIMaxSize)
return header+data;const firstChunk=data.slice(0,Math.ceil(dataURIMaxSize/2));const ellipsis="\u2026";const middleChunk=multiline?`\n${ellipsis}\n`:ellipsis;const lastChunk=data.slice(-Math.floor(dataURIMaxSize/2));return header+firstChunk+middleChunk+lastChunk;};WebInspector.displayNameForHost=function(host)
{return host;};var emDash="\u2014";var enDash="\u2013";var figureDash="\u2012";var ellipsis="\u2026";var zeroWidthSpace="\u200b";Object.defineProperty(Object,"shallowCopy",{value:function(object)
{var copy={};var keys=Object.keys(object);for(var i=0;i<keys.length;++i)
copy[keys[i]]=object[keys[i]];return copy;}});Object.defineProperty(Object,"shallowEqual",{value:function(a,b)
{if(!(a instanceof Object)||!(b instanceof Object))
return false;if(a===b)
return true;if(Array.isArray(a)&&Array.isArray(b))
return Array.shallowEqual(a,b);if(a.constructor!==b.constructor)
return false;var aKeys=Object.keys(a);var bKeys=Object.keys(b);if(aKeys.length!==bKeys.length)
return false;for(var i=0;i<aKeys.length;++i){if(!(aKeys[i]in b))
return false;
if(a[aKeys[i]]!==b[aKeys[i]])
return false;}
return true;}});Object.defineProperty(Object,"shallowMerge",{value(a,b)
{let result=Object.shallowCopy(a);let keys=Object.keys(b);for(let i=0;i<keys.length;++i){result[keys[i]]=b[keys[i]];}
return result;}});Object.defineProperty(Object.prototype,"valueForCaseInsensitiveKey",{value:function(key)
{if(this.hasOwnProperty(key))
return this[key];var lowerCaseKey=key.toLowerCase();for(var currentKey in this){if(currentKey.toLowerCase()===lowerCaseKey)
return this[currentKey];}
return undefined;}});Object.defineProperty(Map,"fromObject",{value:function(object)
{let map=new Map;for(let key in object)
map.set(key,object[key]);return map;}});Object.defineProperty(Map.prototype,"take",{value:function(key)
{var deletedValue=this.get(key);this.delete(key);return deletedValue;}});Object.defineProperty(Node.prototype,"enclosingNodeOrSelfWithClass",{value:function(className)
{for(var node=this;node&&node!==this.ownerDocument;node=node.parentNode)
if(node.nodeType===Node.ELEMENT_NODE&&node.classList.contains(className))
return node;return null;}});Object.defineProperty(Node.prototype,"enclosingNodeOrSelfWithNodeNameInArray",{value:function(nameArray)
{var lowerCaseNameArray=nameArray.map(function(name){return name.toLowerCase();});for(var node=this;node&&node!==this.ownerDocument;node=node.parentNode){for(var i=0;i<nameArray.length;++i){if(node.nodeName.toLowerCase()===lowerCaseNameArray[i])
return node;}}
return null;}});Object.defineProperty(Node.prototype,"enclosingNodeOrSelfWithNodeName",{value:function(nodeName)
{return this.enclosingNodeOrSelfWithNodeNameInArray([nodeName]);}});Object.defineProperty(Node.prototype,"isAncestor",{value:function(node)
{if(!node)
return false;var currentNode=node.parentNode;while(currentNode){if(this===currentNode)
return true;currentNode=currentNode.parentNode;}
return false;}});Object.defineProperty(Node.prototype,"isDescendant",{value:function(descendant)
{return!!descendant&&descendant.isAncestor(this);}});Object.defineProperty(Node.prototype,"isSelfOrAncestor",{value:function(node)
{return!!node&&(node===this||this.isAncestor(node));}});Object.defineProperty(Node.prototype,"isSelfOrDescendant",{value:function(node)
{return!!node&&(node===this||this.isDescendant(node));}});Object.defineProperty(Node.prototype,"traverseNextNode",{value:function(stayWithin)
{var node=this.firstChild;if(node)
return node;if(stayWithin&&this===stayWithin)
return null;node=this.nextSibling;if(node)
return node;node=this;while(node&&!node.nextSibling&&(!stayWithin||!node.parentNode||node.parentNode!==stayWithin))
node=node.parentNode;if(!node)
return null;return node.nextSibling;}});Object.defineProperty(Node.prototype,"traversePreviousNode",{value:function(stayWithin)
{if(stayWithin&&this===stayWithin)
return null;var node=this.previousSibling;while(node&&node.lastChild)
node=node.lastChild;if(node)
return node;return this.parentNode;}});Object.defineProperty(Node.prototype,"rangeOfWord",{value:function(offset,stopCharacters,stayWithinNode,direction)
{var startNode;var startOffset=0;var endNode;var endOffset=0;if(!stayWithinNode)
stayWithinNode=this;if(!direction||direction==="backward"||direction==="both"){var node=this;while(node){if(node===stayWithinNode){if(!startNode)
startNode=stayWithinNode;break;}
if(node.nodeType===Node.TEXT_NODE){var start=(node===this?(offset-1):(node.nodeValue.length-1));for(var i=start;i>=0;--i){if(stopCharacters.indexOf(node.nodeValue[i])!==-1){startNode=node;startOffset=i+1;break;}}}
if(startNode)
break;node=node.traversePreviousNode(stayWithinNode);}
if(!startNode){startNode=stayWithinNode;startOffset=0;}}else{startNode=this;startOffset=offset;}
if(!direction||direction==="forward"||direction==="both"){node=this;while(node){if(node===stayWithinNode){if(!endNode)
endNode=stayWithinNode;break;}
if(node.nodeType===Node.TEXT_NODE){var start=(node===this?offset:0);for(var i=start;i<node.nodeValue.length;++i){if(stopCharacters.indexOf(node.nodeValue[i])!==-1){endNode=node;endOffset=i;break;}}}
if(endNode)
break;node=node.traverseNextNode(stayWithinNode);}
if(!endNode){endNode=stayWithinNode;endOffset=stayWithinNode.nodeType===Node.TEXT_NODE?stayWithinNode.nodeValue.length:stayWithinNode.childNodes.length;}}else{endNode=this;endOffset=offset;}
var result=this.ownerDocument.createRange();result.setStart(startNode,startOffset);result.setEnd(endNode,endOffset);return result;}});Object.defineProperty(Element.prototype,"realOffsetWidth",{get:function()
{return this.getBoundingClientRect().width;}});Object.defineProperty(Element.prototype,"realOffsetHeight",{get:function()
{return this.getBoundingClientRect().height;}});Object.defineProperty(Element.prototype,"totalOffsetLeft",{get:function()
{return this.getBoundingClientRect().left;}});Object.defineProperty(Element.prototype,"totalOffsetRight",{get:function()
{return this.getBoundingClientRect().right;}});Object.defineProperty(Element.prototype,"totalOffsetTop",{get:function()
{return this.getBoundingClientRect().top;}});Object.defineProperty(Element.prototype,"removeChildren",{value:function()
{if(this.firstChild)
this.textContent="";}});Object.defineProperty(Element.prototype,"isInsertionCaretInside",{value:function()
{var selection=window.getSelection();if(!selection.rangeCount||!selection.isCollapsed)
return false;var selectionRange=selection.getRangeAt(0);return selectionRange.startContainer===this||selectionRange.startContainer.isDescendant(this);}});Object.defineProperty(Element.prototype,"removeMatchingStyleClasses",{value:function(classNameRegex)
{var regex=new RegExp("(^|\\s+)"+classNameRegex+"($|\\s+)");if(regex.test(this.className))
this.className=this.className.replace(regex," ");}});Object.defineProperty(Element.prototype,"createChild",{value:function(elementName,className)
{var element=this.ownerDocument.createElement(elementName);if(className)
element.className=className;this.appendChild(element);return element;}});Object.defineProperty(Element.prototype,"isScrolledToBottom",{value:function()
{ return this.scrollTop+this.clientHeight===this.scrollHeight;}});Object.defineProperty(Element.prototype,"recalculateStyles",{value:function()
{this.ownerDocument.defaultView.getComputedStyle(this);}});Object.defineProperty(DocumentFragment.prototype,"createChild",{value:Element.prototype.createChild});Object.defineProperty(Array,"shallowEqual",{value:function(a,b)
{if(!Array.isArray(a)||!Array.isArray(b))
return false;if(a===b)
return true;let length=a.length;if(length!==b.length)
return false;for(let i=0;i<length;++i){if(a[i]===b[i])
continue;if(!Object.shallowEqual(a[i],b[i]))
return false;}
return true;}});Object.defineProperty(Array.prototype,"lastValue",{get:function()
{if(!this.length)
return undefined;return this[this.length-1];}});Object.defineProperty(Array.prototype,"remove",{value:function(value,onlyFirst)
{for(var i=this.length-1;i>=0;--i){if(this[i]===value){this.splice(i,1);if(onlyFirst)
return;}}}});Object.defineProperty(Array.prototype,"toggleIncludes",{value:function(value,force)
{let exists=this.includes(value);if(exists===!!force)
return;if(exists)
this.remove(value);else
this.push(value);}});Object.defineProperty(Array.prototype,"insertAtIndex",{value:function(value,index)
{this.splice(index,0,value);}});Object.defineProperty(Array.prototype,"keySet",{value:function()
{let keys=Object.create(null);for(var i=0;i<this.length;++i)
keys[this[i]]=true;return keys;}});Object.defineProperty(Array.prototype,"partition",{value:function(callback)
{let positive=[];let negative=[];for(let i=0;i<this.length;++i){let value=this[i];if(callback(value))
positive.push(value);else
negative.push(value);}
return[positive,negative];}});Object.defineProperty(String.prototype,"isLowerCase",{value:function()
{return String(this)===this.toLowerCase();}});Object.defineProperty(String.prototype,"isUpperCase",{value:function()
{return String(this)===this.toUpperCase();}});Object.defineProperty(String.prototype,"trimMiddle",{value:function(maxLength)
{if(this.length<=maxLength)
return this;var leftHalf=maxLength>>1;var rightHalf=maxLength-leftHalf-1;return this.substr(0,leftHalf)+ellipsis+this.substr(this.length-rightHalf,rightHalf);}});Object.defineProperty(String.prototype,"trimEnd",{value:function(maxLength)
{if(this.length<=maxLength)
return this;return this.substr(0,maxLength-1)+ellipsis;}});Object.defineProperty(String.prototype,"truncate",{value:function(maxLength)
{"use strict";if(this.length<=maxLength)
return this;let clipped=this.slice(0,maxLength);let indexOfLastWhitespace=clipped.search(/\s\S*$/);if(indexOfLastWhitespace>Math.floor(maxLength/2))
clipped=clipped.slice(0,indexOfLastWhitespace-1);return clipped+ellipsis;}});Object.defineProperty(String.prototype,"collapseWhitespace",{value:function()
{return this.replace(/[\s\xA0]+/g," ");}});Object.defineProperty(String.prototype,"removeWhitespace",{value:function()
{return this.replace(/[\s\xA0]+/g,"");}});Object.defineProperty(String.prototype,"escapeCharacters",{value:function(chars)
{var foundChar=false;for(var i=0;i<chars.length;++i){if(this.indexOf(chars.charAt(i))!==-1){foundChar=true;break;}}
if(!foundChar)
return this;var result="";for(var i=0;i<this.length;++i){if(chars.indexOf(this.charAt(i))!==-1)
result+="\\";result+=this.charAt(i);}
return result;}});Object.defineProperty(String.prototype,"escapeForRegExp",{value:function()
{return this.escapeCharacters("^[]{}()\\.$*+?|");}});Object.defineProperty(String.prototype,"capitalize",{value:function()
{return this.charAt(0).toUpperCase()+this.slice(1);}});Object.defineProperty(String.prototype,"extendedLocaleCompare",{value(other)
{return this.localeCompare(other,undefined,{numeric:true});}});Object.defineProperty(String,"tokenizeFormatString",{value:function(format)
{var tokens=[];var substitutionIndex=0;function addStringToken(str)
{tokens.push({type:"string",value:str});}
function addSpecifierToken(specifier,precision,substitutionIndex)
{tokens.push({type:"specifier",specifier,precision,substitutionIndex});}
var index=0;for(var precentIndex=format.indexOf("%",index);precentIndex!==-1;precentIndex=format.indexOf("%",index)){addStringToken(format.substring(index,precentIndex));index=precentIndex+1;if(format[index]==="%"){addStringToken("%");++index;continue;}
if(!isNaN(format[index])){var number=parseInt(format.substring(index),10);while(!isNaN(format[index]))
++index;if(number>0&&format[index]==="$"){substitutionIndex=(number-1);++index;}}
const defaultPrecision=6;let precision=defaultPrecision;if(format[index]==="."){++index;precision=parseInt(format.substring(index),10);if(isNaN(precision))
precision=defaultPrecision;while(!isNaN(format[index]))
++index;}
addSpecifierToken(format[index],precision,substitutionIndex);++substitutionIndex;++index;}
addStringToken(format.substring(index));return tokens;}});Object.defineProperty(String.prototype,"hash",{get:function()
{const stringHashingStartValue=0x9e3779b9;var result=stringHashingStartValue;var pendingCharacter=null;for(var i=0;i<this.length;++i){var currentCharacter=this[i].charCodeAt(0);if(pendingCharacter===null){pendingCharacter=currentCharacter;continue;}
result+=pendingCharacter;result=(result<<16)^((currentCharacter<<11)^result);result+=result>>11;pendingCharacter=null;}
if(pendingCharacter!==null){result+=pendingCharacter;result^=result<<11;result+=result>>17;}
result^=result<<3;result+=result>>5;result^=result<<2;result+=result>>15;result^=result<<10;return(0xffffffff+result+1).toString(36);}});Object.defineProperty(String,"standardFormatters",{value:{d:function(substitution)
{return parseInt(substitution).toLocaleString();},f:function(substitution,token)
{let value=parseFloat(substitution);if(isNaN(value))
return NaN;let options={minimumFractionDigits:token.precision,maximumFractionDigits:token.precision,useGrouping:false};return value.toLocaleString(undefined,options);},s:function(substitution)
{return substitution;}}});Object.defineProperty(String,"format",{value:function(format,substitutions,formatters,initialValue,append)
{if(!format||!substitutions||!substitutions.length)
return{formattedResult:append(initialValue,format),unusedSubstitutions:substitutions};function prettyFunctionName()
{return"String.format(\""+format+"\", \""+Array.from(substitutions).join("\", \"")+"\")";}
function warn(msg)
{console.warn(prettyFunctionName()+": "+msg);}
function error(msg)
{console.error(prettyFunctionName()+": "+msg);}
var result=initialValue;var tokens=String.tokenizeFormatString(format);var usedSubstitutionIndexes={};for(var i=0;i<tokens.length;++i){var token=tokens[i];if(token.type==="string"){result=append(result,token.value);continue;}
if(token.type!=="specifier"){error("Unknown token type \""+token.type+"\" found.");continue;}
if(token.substitutionIndex>=substitutions.length){
error("not enough substitution arguments. Had "+substitutions.length+" but needed "+(token.substitutionIndex+1)+", so substitution was skipped.");result=append(result,"%"+(token.precision>-1?token.precision:"")+token.specifier);continue;}
usedSubstitutionIndexes[token.substitutionIndex]=true;if(!(token.specifier in formatters)){warn("unsupported format character \u201C"+token.specifier+"\u201D. Treating as a string.");result=append(result,substitutions[token.substitutionIndex]);continue;}
result=append(result,formatters[token.specifier](substitutions[token.substitutionIndex],token));}
var unusedSubstitutions=[];for(var i=0;i<substitutions.length;++i){if(i in usedSubstitutionIndexes)
continue;unusedSubstitutions.push(substitutions[i]);}
return{formattedResult:result,unusedSubstitutions};}});Object.defineProperty(String.prototype,"format",{value:function()
{return String.format(this,arguments,String.standardFormatters,"",function(a,b){return a+b;}).formattedResult;}});Object.defineProperty(String.prototype,"insertWordBreakCharacters",{value:function()
{return this.replace(/([\/;:\)\]\}&?])/g,"$1\u200b");}});Object.defineProperty(String.prototype,"removeWordBreakCharacters",{value:function()
{return this.replace(/\u200b/g,"");}});Object.defineProperty(String.prototype,"getMatchingIndexes",{value:function(needle)
{var indexesOfNeedle=[];var index=this.indexOf(needle);while(index>=0){indexesOfNeedle.push(index);index=this.indexOf(needle,index+1);}
return indexesOfNeedle;}});Object.defineProperty(String.prototype,"levenshteinDistance",{value:function(s)
{var m=this.length;var n=s.length;var d=new Array(m+1);for(var i=0;i<=m;++i){d[i]=new Array(n+1);d[i][0]=i;}
for(var j=0;j<=n;++j)
d[0][j]=j;for(var j=1;j<=n;++j){for(var i=1;i<=m;++i){if(this[i-1]===s[j-1])
d[i][j]=d[i-1][j-1];else{var deletion=d[i-1][j]+1;var insertion=d[i][j-1]+1;var substitution=d[i-1][j-1]+1;d[i][j]=Math.min(deletion,insertion,substitution);}}}
return d[m][n];}});Object.defineProperty(String.prototype,"toCamelCase",{value:function()
{return this.toLowerCase().replace(/[^\w]+(\w)/g,(match,group)=>group.toUpperCase());}});Object.defineProperty(String.prototype,"hasMatchingEscapedQuotes",{value:function()
{return/^\"(?:[^\"\\]|\\.)*\"$/.test(this) || /^\'(?:[^\'\\]|\\.)*\'$/.test(this);
    }
});

Object.defineProperty(Math, "roundTo",
{
    value: function(num, step)
    {
        return Math.round(num / step) * step;
    }
});

Object.defineProperty(Number, "constrain",
{
    value: function(num, min, max)
    {
        if (max < min)
            return min;

        if (num < min)
            num = min;
        else if (num > max)
            num = max;
        return num;
    }
});

Object.defineProperty(Number, "percentageString",
{
    value: function(fraction, precision = 1)
    {
        return fraction.toLocaleString(undefined, {minimumFractionDigits: precision, style: "percent"});
    }
});

Object.defineProperty(Number, "secondsToMillisecondsString",
{
    value: function(seconds, higherResolution)
    {
        let ms = seconds * 1000;

        if (higherResolution)
            return WebInspector.UIString("%.2fms").format(ms);
        return WebInspector.UIString("%.1fms").format(ms);
    }
});

Object.defineProperty(Number, "secondsToString",
{
    value: function(seconds, higherResolution)
    {
        let ms = seconds * 1000;
        if (!ms)
            return WebInspector.UIString("%.0fms").format(0);

        if (Math.abs(ms) < 10) {
            if (higherResolution)
                return WebInspector.UIString("%.3fms").format(ms);
            return WebInspector.UIString("%.2fms").format(ms);
        }

        if (Math.abs(ms) < 100) {
            if (higherResolution)
                return WebInspector.UIString("%.2fms").format(ms);
            return WebInspector.UIString("%.1fms").format(ms);
        }

        if (Math.abs(ms) < 1000) {
            if (higherResolution)
                return WebInspector.UIString("%.1fms").format(ms);
            return WebInspector.UIString("%.0fms").format(ms);
        }

        // Do not go over seconds when in high resolution mode.
        if (higherResolution || Math.abs(seconds) < 60)
            return WebInspector.UIString("%.2fs").format(seconds);

        let minutes = seconds / 60;
        if (Math.abs(minutes) < 60)
            return WebInspector.UIString("%.1fmin").format(minutes);

        let hours = minutes / 60;
        if (Math.abs(hours) < 24)
            return WebInspector.UIString("%.1fhrs").format(hours);

        let days = hours / 24;
        return WebInspector.UIString("%.1f days").format(days);
    }
});

Object.defineProperty(Number, "bytesToString",
{
    value: function(bytes, higherResolution)
    {
        if (higherResolution === undefined)
            higherResolution = true;

        if (Math.abs(bytes) < 1024)
            return WebInspector.UIString("%.0f B").format(bytes);

        let kilobytes = bytes / 1024;
        if (Math.abs(kilobytes) < 1024) {
            if (higherResolution || Math.abs(kilobytes) < 10)
                return WebInspector.UIString("%.2f KB").format(kilobytes);
            return WebInspector.UIString("%.1f KB").format(kilobytes);
        }

        let megabytes = kilobytes / 1024;
        if (Math.abs(megabytes) < 1024) {
            if (higherResolution || Math.abs(megabytes) < 10)
                return WebInspector.UIString("%.2f MB").format(megabytes);
            return WebInspector.UIString("%.1f MB").format(megabytes);
        }

        let gigabytes = megabytes / 1024;
        if (higherResolution || Math.abs(gigabytes) < 10)
            return WebInspector.UIString("%.2f GB").format(gigabytes);
        return WebInspector.UIString("%.1f GB").format(gigabytes);
    }
});

Object.defineProperty(Number, "abbreviate",
{
    value: function(num)
    {
        if (num < 1000)
            return num.toLocaleString();

        if (num < 1000000)
            return WebInspector.UIString("%.1fK").format(Math.round(num / 100) / 10);

        if (num < 1000000000)
            return WebInspector.UIString("%.1fM").format(Math.round(num / 100000) / 10);

        return WebInspector.UIString("%.1fB").format(Math.round(num / 100000000) / 10);
    }
});

Object.defineProperty(Number.prototype, "maxDecimals",
{
    value(decimals)
    {
        let power = 10 ** decimals;
        return Math.round(this * power) / power;
    }
});

Object.defineProperty(Uint32Array, "isLittleEndian",
{
    value: function()
    {
        if ("_isLittleEndian" in this)
            return this._isLittleEndian;

        var buffer = new ArrayBuffer(4);
        var longData = new Uint32Array(buffer);
        var data = new Uint8Array(buffer);

        longData[0] = 0x0a0b0c0d;

        this._isLittleEndian = data[0] === 0x0d && data[1] === 0x0c && data[2] === 0x0b && data[3] === 0x0a;

        return this._isLittleEndian;
    }
});

function isEmptyObject(object)
{
    for (var property in object)
        return false;
    return true;
}

function isEnterKey(event)
{
    // Check if this is an IME event.
    return event.keyCode !== 229 && event.keyIdentifier === "Enter";
}

function resolveDotsInPath(path)
{
    if (!path)
        return path;

    if (path.indexOf("./") === -1)
        return path;


    var result = [];

    var components = path.split("/");
    for (var i = 0; i < components.length; ++i) {
        var component = components[i];

        // Skip over "./".
        if (component === ".")
            continue;

        // Rewind one component for "../".
        if (component === "..") {
            if (result.length === 1)
                continue;
            result.pop();
            continue;
        }

        result.push(component);
    }

    return result.join("/");
}

function parseMIMEType(fullMimeType)
{
    if (!fullMimeType)
        return {type: fullMimeType, boundary: null, encoding: null};

    var typeParts = fullMimeType.split(/\s*;\s*/);

    var type = typeParts[0];
    var boundary = null;
    var encoding = null;

    for (var i = 1; i < typeParts.length; ++i) {
        var subparts = typeParts[i].split(/\s*=\s*/);
        if (subparts.length !== 2)
            continue;

        if (subparts[0].toLowerCase() === "boundary")
            boundary = subparts[1];
        else if (subparts[0].toLowerCase() === "charset")
            encoding = subparts[1].replace("^\"|\"$","");}
return{type,boundary:boundary||null,encoding:encoding||null};}
function simpleGlobStringToRegExp(globString,regExpFlags)
{if(!globString)
return null;var regexString=globString.escapeCharacters("^[]{}()\\.$+?|");regexString=regexString.replace(/\\\\\*/g,"\\*");var unescapedAsteriskRegex=/(^|[^\\])\*+/g;if(unescapedAsteriskRegex.test(globString)){regexString=regexString.replace(unescapedAsteriskRegex,"$1.*");


regexString="\\b"+regexString+"\\b";}
return new RegExp(regexString,regExpFlags);}
Object.defineProperty(Array.prototype,"lowerBound",{

value:function(object,comparator)
{function defaultComparator(a,b)
{return a-b;}
comparator=comparator||defaultComparator;var l=0;var r=this.length;while(l<r){var m=(l+r)>>1;if(comparator(object,this[m])>0)
l=m+1;else
r=m;}
return r;}});Object.defineProperty(Array.prototype,"upperBound",{

value:function(object,comparator)
{function defaultComparator(a,b)
{return a-b;}
comparator=comparator||defaultComparator;var l=0;var r=this.length;while(l<r){var m=(l+r)>>1;if(comparator(object,this[m])>=0)
l=m+1;else
r=m;}
return r;}});Object.defineProperty(Array.prototype,"binaryIndexOf",{value:function(value,comparator)
{var index=this.lowerBound(value,comparator);return index<this.length&&comparator(value,this[index])===0?index:-1;}});(function(){

const debounceTimeoutSymbol=Symbol("debounce-timeout");const debounceSoonProxySymbol=Symbol("debounce-soon-proxy");Object.defineProperty(Object.prototype,"soon",{get:function()
{if(!this[debounceSoonProxySymbol])
this[debounceSoonProxySymbol]=this.debounce(0);return this[debounceSoonProxySymbol];}});Object.defineProperty(Object.prototype,"debounce",{value:function(delay)
{return new Proxy(this,{get(target,property,receiver){return(...args)=>{let original=target[property];if(original[debounceTimeoutSymbol])
clearTimeout(original[debounceTimeoutSymbol]);let performWork=()=>{original[debounceTimeoutSymbol]=undefined;original.apply(target,args);};original[debounceTimeoutSymbol]=setTimeout(performWork,delay);};}});}});Object.defineProperty(Function.prototype,"cancelDebounce",{value:function()
{if(!this[debounceTimeoutSymbol])
return;clearTimeout(this[debounceTimeoutSymbol]);this[debounceTimeoutSymbol]=undefined;}});const requestAnimationFrameSymbol=Symbol("peform-on-animation-frame");const requestAnimationFrameProxySymbol=Symbol("perform-on-animation-frame-proxy");Object.defineProperty(Object.prototype,"onNextFrame",{get:function()
{if(!this[requestAnimationFrameProxySymbol]){this[requestAnimationFrameProxySymbol]=new Proxy(this,{get(target,property,receiver){return(...args)=>{let original=target[property];if(original[requestAnimationFrameSymbol])
return;let performWork=()=>{original[requestAnimationFrameSymbol]=undefined;original.apply(target,args);};original[requestAnimationFrameSymbol]=requestAnimationFrame(performWork);};}});}
return this[requestAnimationFrameProxySymbol];}});})();function appendWebInspectorSourceURL(string)
{if(string.includes("//# sourceURL"))
return string;return"\n//# sourceURL=__WebInspectorInternal__\n"+string;}
function appendWebInspectorConsoleEvaluationSourceURL(string)
{if(string.includes("//# sourceURL"))
return string;return"\n//# sourceURL=__WebInspectorConsoleEvaluation__\n"+string;}
function isWebInspectorInternalScript(url)
{return url==="__WebInspectorInternal__";}
function isWebInspectorConsoleEvaluationScript(url)
{return url==="__WebInspectorConsoleEvaluation__";}
function isWebKitInjectedScript(url)
{return url&&url.startsWith("__InjectedScript_")&&url.endsWith(".js");}
function isWebKitInternalScript(url)
{if(isWebInspectorConsoleEvaluationScript(url))
return false;if(isWebKitInjectedScript(url))
return true;return url&&url.startsWith("__Web")&&url.endsWith("__");}
function isFunctionStringNativeCode(str)
{return str.endsWith("{\n    [native code]\n}");}
function isTextLikelyMinified(content)
{const autoFormatMaxCharactersToCheck=5000;const autoFormatWhitespaceRatio=0.2;let whitespaceScore=0;let size=Math.min(autoFormatMaxCharactersToCheck,content.length);for(let i=0;i<size;i++){let char=content[i];if(char===" ")
whitespaceScore++;else if(char==="\t")
whitespaceScore+=4;else if(char==="\n")
whitespaceScore+=8;}
let ratio=whitespaceScore/size;return ratio<autoFormatWhitespaceRatio;}
function doubleQuotedString(str)
{return"\""+str.replace(/\\/g,"\\\\").replace(/"/g,"\\\"")+"\"";}
function insertionIndexForObjectInListSortedByFunction(object,list,comparator,insertionIndexAfter)
{if(insertionIndexAfter){return list.upperBound(object,comparator);}else{return list.lowerBound(object,comparator);}}
function insertObjectIntoSortedArray(object,array,comparator)
{array.splice(insertionIndexForObjectInListSortedByFunction(object,array,comparator),0,object);}
function decodeBase64ToBlob(base64Data,mimeType)
{mimeType=mimeType||'';const sliceSize=1024;var byteCharacters=atob(base64Data);var bytesLength=byteCharacters.length;var slicesCount=Math.ceil(bytesLength/sliceSize);var byteArrays=new Array(slicesCount);for(var sliceIndex=0;sliceIndex<slicesCount;++sliceIndex){var begin=sliceIndex*sliceSize;var end=Math.min(begin+sliceSize,bytesLength);var bytes=new Array(end-begin);for(var offset=begin,i=0;offset<end;++i,++offset)
bytes[i]=byteCharacters[offset].charCodeAt(0);byteArrays[sliceIndex]=new Uint8Array(bytes);}
return new Blob(byteArrays,{type:mimeType});}
function timestamp()
{return window.performance?performance.now():Date.now();}
if(!window.handlePromiseException){window.handlePromiseException=function handlePromiseException(error)
{console.error("Uncaught exception in Promise",error);};}
WebInspector.Setting=class Setting extends WebInspector.Object
{constructor(name,defaultValue)
{super();this._name=name;let inspectionLevel=InspectorFrontendHost?InspectorFrontendHost.inspectionLevel():1;let levelString=inspectionLevel>1?"-"+inspectionLevel:"";this._localStorageKey=`com.apple.WebInspector${levelString}.${name}`;this._defaultValue=defaultValue;} 
get name()
{return this._name;}
get value()
{if("_value"in this)
return this._value;this._value=JSON.parse(JSON.stringify(this._defaultValue));if(!window.InspectorTest&&window.localStorage&&this._localStorageKey in window.localStorage){try{this._value=JSON.parse(window.localStorage[this._localStorageKey]);}catch(e){delete window.localStorage[this._localStorageKey];}}
return this._value;}
set value(value)
{if(this._value===value)
return;this._value=value;if(!window.InspectorTest&&window.localStorage){try{if(Object.shallowEqual(this._value,this._defaultValue))
delete window.localStorage[this._localStorageKey];else
window.localStorage[this._localStorageKey]=JSON.stringify(this._value);}catch(e){console.error("Error saving setting with name: "+this._name);}}
this.dispatchEventToListeners(WebInspector.Setting.Event.Changed,this._value,{name:this._name});}
reset()
{this.value=JSON.parse(JSON.stringify(this._defaultValue));}};WebInspector.Setting.Event={Changed:"setting-changed"};WebInspector.settings={autoLogProtocolMessages:new WebInspector.Setting("auto-collect-protocol-messages",false),autoLogTimeStats:new WebInspector.Setting("auto-collect-time-stats",false),enableUncaughtExceptionReporter:new WebInspector.Setting("enable-uncaught-exception-reporter",true),enableLineWrapping:new WebInspector.Setting("enable-line-wrapping",false),indentUnit:new WebInspector.Setting("indent-unit",4),tabSize:new WebInspector.Setting("tab-size",4),indentWithTabs:new WebInspector.Setting("indent-with-tabs",false),showWhitespaceCharacters:new WebInspector.Setting("show-whitespace-characters",false),showInvalidCharacters:new WebInspector.Setting("show-invalid-characters",false),clearLogOnNavigate:new WebInspector.Setting("clear-log-on-navigate",true),clearNetworkOnNavigate:new WebInspector.Setting("clear-network-on-navigate",true),zoomFactor:new WebInspector.Setting("zoom-factor",1),layoutDirection:new WebInspector.Setting("layout-direction-override","system"),stylesShowInlineWarnings:new WebInspector.Setting("styles-show-inline-warning",true),stylesInsertNewline:new WebInspector.Setting("styles-insert-newline",true),stylesSelectOnFirstClick:new WebInspector.Setting("styles-select-on-first-click",true),showScopeChainOnPause:new WebInspector.Setting("show-scope-chain-sidebar",true),showImageGrid:new WebInspector.Setting("show-image-grid",false), experimentalShowCanvasContextsInResources:new WebInspector.Setting("experimental-show-canvas-contexts-in-resources",false),};WebInspector.YieldableTask=class YieldableTask extends WebInspector.Object
{constructor(delegate,items,options={})
{super();let{workInterval,idleInterval}=options;this._workInterval=workInterval||10;this._idleInterval=idleInterval||0;this._delegate=delegate;this._items=items;this._idleTimeoutIdentifier=undefined;this._processing=false;this._processing=false;this._cancelled=false;} 
get processing(){return this._processing;}
get cancelled(){return this._cancelled;}
get idleInterval(){return this._idleInterval;}
get workInterval(){return this._workInterval;}
start()
{if(this._processing)
return;if(this._cancelled)
return;function*createIteratorForProcessingItems()
{let startTime=Date.now();let processedItems=[];for(let item of this._items){if(this._cancelled)
break;this._delegate.yieldableTaskWillProcessItem(this,item);processedItems.push(item);if(this._cancelled)
break;let elapsedTime=Date.now()-startTime;if(elapsedTime>this._workInterval){let returnedItems=processedItems.slice();processedItems=[];this._willYield(returnedItems,elapsedTime);yield;startTime=Date.now();}}

if(processedItems.length)
this._willYield(processedItems,Date.now()-startTime);}
this._processing=true;this._pendingItemsIterator=createIteratorForProcessingItems.call(this);this._processPendingItems();}
cancel()
{if(!this._processing)
return;this._cancelled=true;} 
_processPendingItems()
{if(this._cancelled)
return;if(!this._pendingItemsIterator.next().done){this._idleTimeoutIdentifier=setTimeout(()=>{this._processPendingItems();},this._idleInterval);return;}
this._didFinish();}
_willYield(processedItems,elapsedTime)
{if(typeof this._delegate.yieldableTaskDidYield==="function")
this._delegate.yieldableTaskDidYield(this,processedItems,elapsedTime);}
_didFinish()
{this._processing=false;this._pendingItemsIterator=null;if(this._idleTimeoutIdentifier){clearTimeout(this._idleTimeoutIdentifier);this._idleTimeoutIdentifier=undefined;}
if(typeof this._delegate.yieldableTaskDidFinish==="function")
this._delegate.yieldableTaskDidFinish(this);}};WebInspector.ProtocolTracer=class ProtocolTracer extends WebInspector.Object
{ logStarted()
{}
logFrontendException(message,exception)
{}
logProtocolError(message,error)
{}
logFrontendRequest(message)
{}
logWillHandleResponse(message)
{}
logDidHandleResponse(message,timings=null)
{}
logWillHandleEvent(message)
{}
logDidHandleEvent(message,timings=null)
{}
logFinished()
{}};WebInspector.LoggingProtocolTracer=class LoggingProtocolTracer extends WebInspector.ProtocolTracer
{constructor()
{super();this._dumpMessagesToConsole=false;this._dumpTimingDataToConsole=false;this._logToConsole=window.InspectorTest?InspectorFrontendHost.unbufferedLog.bind(InspectorFrontendHost):console.log.bind(console);} 
set dumpMessagesToConsole(value)
{this._dumpMessagesToConsole=!!value;}
get dumpMessagesToConsole()
{return this._dumpMessagesToConsole;}
set dumpTimingDataToConsole(value)
{this._dumpTimingDataToConsole=!!value;}
get dumpTimingDataToConsole()
{return this._dumpTimingDataToConsole;}
logFrontendException(message,exception)
{this._processEntry({type:"exception",message,exception});}
logProtocolError(message,error)
{this._processEntry({type:"error",message,error});}
logFrontendRequest(message)
{this._processEntry({type:"request",message});}
logWillHandleResponse(message)
{let entry={type:"response",message};this._processEntry(entry);}
logDidHandleResponse(message,timings=null)
{let entry={type:"response",message};if(timings)
entry.timings=Object.shallowCopy(timings);this._processEntry(entry);}
logWillHandleEvent(message)
{let entry={type:"event",message};this._processEntry(entry);}
logDidHandleEvent(message,timings=null)
{let entry={type:"event",message};if(timings)
entry.timings=Object.shallowCopy(timings);this._processEntry(entry);}
_processEntry(entry)
{if(this._dumpTimingDataToConsole&&entry.timings){if(entry.timings.rtt&&entry.timings.dispatch)
this._logToConsole(`time-stats: Handling: ${entry.timings.dispatch || NaN}ms; RTT: ${entry.timings.rtt}ms`);else if(entry.timings.dispatch)
this._logToConsole(`time-stats: Handling: ${entry.timings.dispatch || NaN}ms`);}else if(this._dumpMessagesToConsole&&!entry.timings){this._logToConsole(`${entry.type}: ${JSON.stringify(entry.message)}`);if(entry.exception){this._logToConsole(entry.exception);if(entry.exception.stack)
this._logToConsole(entry.exception.stack);}}}};InspectorBackendClass=class InspectorBackendClass
{constructor()
{this._agents={};this._customTracer=null;this._defaultTracer=new WebInspector.LoggingProtocolTracer;this._activeTracers=[this._defaultTracer];this._workerSupportedDomains=[];WebInspector.settings.autoLogProtocolMessages.addEventListener(WebInspector.Setting.Event.Changed,this._startOrStopAutomaticTracing,this);WebInspector.settings.autoLogTimeStats.addEventListener(WebInspector.Setting.Event.Changed,this._startOrStopAutomaticTracing,this);this._startOrStopAutomaticTracing();this.currentDispatchState={event:null,request:null,response:null,};} 
get workerSupportedDomains(){return this._workerSupportedDomains;}


set dumpInspectorProtocolMessages(value)
{WebInspector.settings.autoLogProtocolMessages.value=value;this._defaultTracer.dumpMessagesToConsole=value;}
get dumpInspectorProtocolMessages()
{return WebInspector.settings.autoLogProtocolMessages.value;}
set dumpInspectorTimeStats(value)
{WebInspector.settings.autoLogTimeStats.value=value;if(!this.dumpInspectorProtocolMessages)
this.dumpInspectorProtocolMessages=true;this._defaultTracer.dumpTimingDataToConsole=value;}
get dumpInspectorTimeStats()
{return WebInspector.settings.autoLogTimeStats.value;}
set customTracer(tracer)
{if(!tracer&&!this._customTracer)
return;if(tracer===this._customTracer)
return;if(tracer===this._defaultTracer)
return;if(this._customTracer)
this._customTracer.logFinished();this._customTracer=tracer;this._activeTracers=[this._defaultTracer];if(this._customTracer){this._customTracer.logStarted();this._activeTracers.push(this._customTracer);}}
get activeTracers()
{return this._activeTracers;}
registerCommand(qualifiedName,callSignature,replySignature)
{var[domainName,commandName]=qualifiedName.split(".");var agent=this._agentForDomain(domainName);agent.addCommand(InspectorBackend.Command.create(agent,qualifiedName,callSignature,replySignature));}
registerEnum(qualifiedName,enumValues)
{var[domainName,enumName]=qualifiedName.split(".");var agent=this._agentForDomain(domainName);agent.addEnum(enumName,enumValues);}
registerEvent(qualifiedName,signature)
{var[domainName,eventName]=qualifiedName.split(".");var agent=this._agentForDomain(domainName);agent.addEvent(new InspectorBackend.Event(eventName,signature));}
registerDomainDispatcher(domainName,dispatcher)
{var agent=this._agentForDomain(domainName);agent.dispatcher=dispatcher;}
dispatch(message)
{InspectorBackend.mainConnection.dispatch(message);}
runAfterPendingDispatches(script)
{InspectorBackend.mainConnection.runAfterPendingDispatches(script);}
activateDomain(domainName,activationDebuggableType)
{if(!activationDebuggableType||InspectorFrontendHost.debuggableType()===activationDebuggableType){var agent=this._agents[domainName];agent.activate();return agent;}
return null;}
workerSupportedDomain(domainName)
{this._workerSupportedDomains.push(domainName);} 
_startOrStopAutomaticTracing()
{this._defaultTracer.dumpMessagesToConsole=this.dumpInspectorProtocolMessages;this._defaultTracer.dumpTimingDataToConsole=this.dumpTimingDataToConsole;}
_agentForDomain(domainName)
{if(this._agents[domainName])
return this._agents[domainName];var agent=new InspectorBackend.Agent(domainName);this._agents[domainName]=agent;return agent;}};InspectorBackend=new InspectorBackendClass;InspectorBackend.Agent=class InspectorBackendAgent
{constructor(domainName)
{this._domainName=domainName;this._connection=InspectorBackend.mainConnection;this._dispatcher=null;this._active=false;
this._events={};} 
get domainName()
{return this._domainName;}
get active()
{return this._active;}
get connection()
{return this._connection;}
set connection(connection)
{this._connection=connection;}
get dispatcher()
{return this._dispatcher;}
set dispatcher(value)
{this._dispatcher=value;}
addEnum(enumName,enumValues)
{this[enumName]=enumValues;}
addCommand(command)
{this[command.commandName]=command;}
addEvent(event)
{this._events[event.eventName]=event;}
getEvent(eventName)
{return this._events[eventName];}
hasEvent(eventName)
{return eventName in this._events;}
hasEventParameter(eventName,eventParameterName)
{let event=this._events[eventName];return event&&event.parameterNames.includes(eventParameterName);}
activate()
{this._active=true;window[this._domainName+"Agent"]=this;}
dispatchEvent(eventName,eventArguments)
{if(!(eventName in this._dispatcher)){console.error("Protocol Error: Attempted to dispatch an unimplemented method '"+this._domainName+"."+eventName+"'");return false;}
this._dispatcher[eventName].apply(this._dispatcher,eventArguments);return true;}};InspectorBackend.Command=function(agent,qualifiedName,callSignature,replySignature)
{"use strict";this._agent=agent;this._instance=this;let[domainName,commandName]=qualifiedName.split(".");this._qualifiedName=qualifiedName;this._commandName=commandName;this._callSignature=callSignature||[];this._replySignature=replySignature||[];};InspectorBackend.Command.create=function(agent,commandName,callSignature,replySignature)
{"use strict";let instance=new InspectorBackend.Command(agent,commandName,callSignature,replySignature);function callable(){return instance._invokeWithArguments.call(instance,this,Array.from(arguments));}
callable._instance=instance;Object.setPrototypeOf(callable,InspectorBackend.Command.prototype);return callable;};InspectorBackend.Command.prototype={__proto__:Function.prototype, get qualifiedName()
{return this._instance._qualifiedName;},get commandName()
{return this._instance._commandName;},get callSignature()
{return this._instance._callSignature;},get replySignature()
{return this._instance._replySignature;},invoke(commandArguments,callback,agent)
{"use strict";agent=agent||this._instance._agent;if(typeof callback==="function")
agent._connection._sendCommandToBackendWithCallback(this._instance,commandArguments,callback);else
return agent._connection._sendCommandToBackendExpectingPromise(this._instance,commandArguments);},supports(parameterName)
{"use strict";return this._instance.callSignature.some((parameter)=>parameter["name"]===parameterName);}, _invokeWithArguments(agent,commandArguments)
{"use strict";let instance=this._instance;let callback=typeof commandArguments.lastValue==="function"?commandArguments.pop():null;function deliverFailure(message){console.error(`Protocol Error: ${message}`);if(callback)
setTimeout(callback.bind(null,message),0);else
return Promise.reject(new Error(message));}
let parameters={};for(let parameter of instance.callSignature){let parameterName=parameter["name"];let typeName=parameter["type"];let optionalFlag=parameter["optional"];if(!commandArguments.length&&!optionalFlag)
return deliverFailure(`Invalid number of arguments for command '${instance.qualifiedName}'.`);let value=commandArguments.shift();if(optionalFlag&&value===undefined)
continue;if(typeof value!==typeName)
return deliverFailure(`Invalid type of argument '${parameterName}' for command '${instance.qualifiedName}' call. It must be '${typeName}' but it is '${typeof value}'.`);parameters[parameterName]=value;}
if(!callback&&commandArguments.length===1&&commandArguments[0]!==undefined)
return deliverFailure(`Protocol Error: Optional callback argument for command '${instance.qualifiedName}' call must be a function but its type is '${typeof commandArguments[0]}'.`);if(callback)
agent._connection._sendCommandToBackendWithCallback(instance,parameters,callback);else
return agent._connection._sendCommandToBackendExpectingPromise(instance,parameters);}};InspectorBackend.Event=class Event
{constructor(eventName,parameterNames)
{this.eventName=eventName;this.parameterNames=parameterNames;}};InspectorBackend.Connection=class InspectorBackendConnection
{constructor()
{this._lastSequenceId=1;this._pendingResponses=new Map;this._agents={};this._deferredScripts=[];this._target=null;} 
get target()
{return this._target;}
set target(target)
{this._target=target;for(let domain in this._agents){let dispatcher=this._agents[domain].dispatcher;if(dispatcher)
dispatcher.target=target;}}
dispatch(message)
{let messageObject=(typeof message==="string")?JSON.parse(message):message;if("id"in messageObject)
this._dispatchResponse(messageObject);else
this._dispatchEvent(messageObject);}
runAfterPendingDispatches(script)
{if(!this._pendingResponses.size)
script.call(this);else
this._deferredScripts.push(script);} 
sendMessageToBackend(message)
{throw new Error("Should be implemented by a InspectorBackend.Connection subclass");} 
_dispatchResponse(messageObject)
{if(messageObject["error"]){if(messageObject["error"].code!==-32000)
console.error("Request with id = "+messageObject["id"]+" failed. "+JSON.stringify(messageObject["error"]));}
let sequenceId=messageObject["id"];let responseData=this._pendingResponses.take(sequenceId)||{};let{request,command,callback,promise}=responseData;let processingStartTimestamp=timestamp();for(let tracer of InspectorBackend.activeTracers)
tracer.logWillHandleResponse(messageObject);InspectorBackend.currentDispatchState.request=request;InspectorBackend.currentDispatchState.response=messageObject;if(typeof callback==="function")
this._dispatchResponseToCallback(command,request,messageObject,callback);else if(typeof promise==="object")
this._dispatchResponseToPromise(command,messageObject,promise);else
console.error("Received a command response without a corresponding callback or promise.",messageObject,command);InspectorBackend.currentDispatchState.request=null;InspectorBackend.currentDispatchState.response=null;let processingTime=(timestamp()-processingStartTimestamp).toFixed(3);let roundTripTime=(processingStartTimestamp-responseData.sendRequestTimestamp).toFixed(3);for(let tracer of InspectorBackend.activeTracers)
tracer.logDidHandleResponse(messageObject,{rtt:roundTripTime,dispatch:processingTime});if(this._deferredScripts.length&&!this._pendingResponses.size)
this._flushPendingScripts();}
_dispatchResponseToCallback(command,requestObject,responseObject,callback)
{let callbackArguments=[];callbackArguments.push(responseObject["error"]?responseObject["error"].message:null);if(responseObject["result"]){for(let parameterName of command.replySignature)
callbackArguments.push(responseObject["result"][parameterName]);}
try{callback.apply(null,callbackArguments);}catch(e){WebInspector.reportInternalError(e,{"cause":`An uncaught exception was thrown while dispatching response callback for command ${command.qualifiedName}.`});}}
_dispatchResponseToPromise(command,messageObject,promise)
{let{resolve,reject}=promise;if(messageObject["error"])
reject(new Error(messageObject["error"].message));else
resolve(messageObject["result"]);}
_dispatchEvent(messageObject)
{let qualifiedName=messageObject["method"];let[domainName,eventName]=qualifiedName.split(".");if(!(domainName in this._agents)){console.error("Protocol Error: Attempted to dispatch method '"+eventName+"' for non-existing domain '"+domainName+"'");return;}
let agent=this._agents[domainName];if(!agent.active){console.error("Protocol Error: Attempted to dispatch method for domain '"+domainName+"' which exists but is not active.");return;}
let event=agent.getEvent(eventName);if(!event){console.error("Protocol Error: Attempted to dispatch an unspecified method '"+qualifiedName+"'");return;}
let eventArguments=[];if(messageObject["params"])
eventArguments=event.parameterNames.map((name)=>messageObject["params"][name]);let processingStartTimestamp=timestamp();for(let tracer of InspectorBackend.activeTracers)
tracer.logWillHandleEvent(messageObject);InspectorBackend.currentDispatchState.event=messageObject;try{agent.dispatchEvent(eventName,eventArguments);}catch(e){for(let tracer of InspectorBackend.activeTracers)
tracer.logFrontendException(messageObject,e);WebInspector.reportInternalError(e,{"cause":`An uncaught exception was thrown while handling event: ${qualifiedName}`});}
InspectorBackend.currentDispatchState.event=null;let processingDuration=(timestamp()-processingStartTimestamp).toFixed(3);for(let tracer of InspectorBackend.activeTracers)
tracer.logDidHandleEvent(messageObject,{dispatch:processingDuration});}
_sendCommandToBackendWithCallback(command,parameters,callback)
{let sequenceId=this._lastSequenceId++;let messageObject={"id":sequenceId,"method":command.qualifiedName,};if(!isEmptyObject(parameters))
messageObject["params"]=parameters;let responseData={command,request:messageObject,callback};if(InspectorBackend.activeTracer)
responseData.sendRequestTimestamp=timestamp();this._pendingResponses.set(sequenceId,responseData);this._sendMessageToBackend(messageObject);}
_sendCommandToBackendExpectingPromise(command,parameters)
{let sequenceId=this._lastSequenceId++;let messageObject={"id":sequenceId,"method":command.qualifiedName,};if(!isEmptyObject(parameters))
messageObject["params"]=parameters;let responseData={command,request:messageObject};if(InspectorBackend.activeTracer)
responseData.sendRequestTimestamp=timestamp();let responsePromise=new Promise(function(resolve,reject){responseData.promise={resolve,reject};});this._pendingResponses.set(sequenceId,responseData);this._sendMessageToBackend(messageObject);return responsePromise;}
_sendMessageToBackend(messageObject)
{for(let tracer of InspectorBackend.activeTracers)
tracer.logFrontendRequest(messageObject);this.sendMessageToBackend(JSON.stringify(messageObject));}
_flushPendingScripts()
{let scriptsToRun=this._deferredScripts;this._deferredScripts=[];for(let script of scriptsToRun)
script.call(this);}};InspectorBackend.MainConnection=class InspectorBackendPageConnection extends InspectorBackend.Connection
{constructor()
{super();this._agents=InspectorBackend._agents;}
sendMessageToBackend(message)
{InspectorFrontendHost.sendMessageToBackend(message);}};InspectorBackend.WorkerConnection=class InspectorBackendWorkerConnection extends InspectorBackend.Connection
{constructor(workerId)
{super();this._workerId=workerId;const workerDomains=InspectorBackend.workerSupportedDomains;for(let domain of workerDomains){let agent=InspectorBackend._agents[domain];let clone=Object.create(InspectorBackend._agents[domain]);clone.connection=this;clone.dispatcher=new agent.dispatcher.constructor;this._agents[domain]=clone;}}
sendMessageToBackend(message)
{WorkerAgent.sendMessageToWorker(this._workerId,message);}};InspectorBackend.mainConnection=new InspectorBackend.MainConnection;InspectorFrontendAPI={_loaded:false,_pendingCommands:[],savedURL:function(url)
{},appendedToURL:function(url)
{},isTimelineProfilingEnabled:function()
{return WebInspector.timelineManager.isCapturing();},setTimelineProfilingEnabled:function(enabled)
{if(WebInspector.timelineManager.isCapturing()===enabled)
return;if(enabled)
WebInspector.timelineManager.startCapturing();else
WebInspector.timelineManager.stopCapturing();},setElementSelectionEnabled:function(enabled)
{WebInspector.domTreeManager.inspectModeEnabled=enabled;},setDockingUnavailable:function(unavailable)
{WebInspector.updateDockingAvailability(!unavailable);},setDockSide:function(side)
{WebInspector.updateDockedState(side);},setIsVisible:function(visible)
{WebInspector.updateVisibilityState(visible);},showConsole:function()
{WebInspector.showConsoleTab();WebInspector.quickConsole.prompt.focus();if(document.readyState!=="complete")
document.addEventListener("readystatechange",this);if(document.visibilityState!=="visible")
document.addEventListener("visibilitychange",this);},handleEvent:function(event)
{if(document.readyState==="complete"&&document.visibilityState==="visible"){WebInspector.quickConsole.prompt.focus();document.removeEventListener("readystatechange",this);document.removeEventListener("visibilitychange",this);}},showResources:function()
{WebInspector.showResourcesTab();},showTimelines:function()
{WebInspector.showTimelineTab();},showMainResourceForFrame:function(frameIdentifier)
{const options={ignoreNetworkTab:true,ignoreSearchTab:true,};WebInspector.showSourceCodeForFrame(frameIdentifier,options);},contextMenuItemSelected:function(id)
{try{WebInspector.ContextMenu.contextMenuItemSelected(id);}catch(e){console.error("Uncaught exception in inspector page under contextMenuItemSelected",e);}},contextMenuCleared:function()
{WebInspector.ContextMenu.contextMenuCleared();},dispatchMessageAsync:function(messageObject)
{WebInspector.dispatchMessageFromBackend(messageObject);},dispatchMessage:function(messageObject)
{InspectorBackend.dispatch(messageObject);},dispatch:function(signature)
{if(!InspectorFrontendAPI._loaded){InspectorFrontendAPI._pendingCommands.push(signature);return null;}
var methodName=signature.shift();if(!InspectorFrontendAPI[methodName])
return null;return InspectorFrontendAPI[methodName].apply(InspectorFrontendAPI,signature);},loadCompleted:function()
{InspectorFrontendAPI._loaded=true;for(var i=0;i<InspectorFrontendAPI._pendingCommands.length;++i)
InspectorFrontendAPI.dispatch(InspectorFrontendAPI._pendingCommands[i]);delete InspectorFrontendAPI._pendingCommands;}};(function(){let backendCommandsURL=InspectorFrontendHost.backendCommandsURL()||"Protocol/InspectorBackendCommands.js";document.write("<script src=\""+backendCommandsURL+"\"></script>");})();WebInspector._messagesToDispatch=[];WebInspector.dispatchNextQueuedMessageFromBackend=function()
{const startCount=WebInspector._messagesToDispatch.length;const startTimestamp=timestamp();const timeLimitPerRunLoop=10; let i=0;for(;i<WebInspector._messagesToDispatch.length;++i){
if(timestamp()-startTimestamp>timeLimitPerRunLoop)
break;InspectorBackend.dispatch(WebInspector._messagesToDispatch[i]);}
if(i===WebInspector._messagesToDispatch.length){WebInspector._messagesToDispatch=[];WebInspector._dispatchTimeout=null;}else{WebInspector._messagesToDispatch=WebInspector._messagesToDispatch.slice(i);WebInspector._dispatchTimeout=setTimeout(WebInspector.dispatchNextQueuedMessageFromBackend,0);}
if(InspectorBackend.dumpInspectorTimeStats){let messageDuration=(timestamp()-startTimestamp).toFixed(3);let dispatchedCount=startCount-WebInspector._messagesToDispatch.length;let remainingCount=WebInspector._messagesToDispatch.length;console.log(`time-stats: --- RunLoop duration: ${messageDuration}ms; dispatched: ${dispatchedCount}; remaining: ${remainingCount}`);}};WebInspector.dispatchMessageFromBackend=function(message)
{this._messagesToDispatch.push(message);
if(window.__uncaughtExceptions&&window.__uncaughtExceptions.length)
return;if(this._dispatchTimeout)
return;this._dispatchTimeout=setTimeout(this.dispatchNextQueuedMessageFromBackend,0);};WebInspector.RemoteObject=class RemoteObject
{constructor(target,objectId,type,subtype,value,description,size,classPrototype,className,preview)
{this._target=target||WebInspector.mainTarget;this._type=type;this._subtype=subtype;if(objectId){this._objectId=objectId;this._description=description||"";this._hasChildren=type!=="symbol";this._size=size;this._classPrototype=classPrototype;this._preview=preview;if(subtype==="class"){this._functionDescription=this._description;this._description="class "+className;}}else{this._description=description||(value+"");this._hasChildren=false;this._value=value;}} 
static createFakeRemoteObject()
{return new WebInspector.RemoteObject(undefined,WebInspector.RemoteObject.FakeRemoteObjectId,"object");}
static fromPrimitiveValue(value)
{return new WebInspector.RemoteObject(undefined,undefined,typeof value,undefined,value,undefined,undefined,undefined,undefined);}
static fromPayload(payload,target)
{if(payload.subtype==="array"){var match=payload.description.match(/\[(\d+)\]$/);if(match){payload.size=parseInt(match[1]);payload.description=payload.description.replace(/\[\d+\]$/,"");}}
if(payload.classPrototype)
payload.classPrototype=WebInspector.RemoteObject.fromPayload(payload.classPrototype,target);if(payload.preview){
if(!payload.preview.type){payload.preview.type=payload.type;payload.preview.subtype=payload.subtype;payload.preview.description=payload.description;payload.preview.size=payload.size;}
payload.preview=WebInspector.ObjectPreview.fromPayload(payload.preview);}
return new WebInspector.RemoteObject(target,payload.objectId,payload.type,payload.subtype,payload.value,payload.description,payload.size,payload.classPrototype,payload.className,payload.preview);}
static createCallArgument(valueOrObject)
{if(valueOrObject instanceof WebInspector.RemoteObject){if(valueOrObject.objectId)
return{objectId:valueOrObject.objectId};return{value:valueOrObject.value};}
return{value:valueOrObject};}
static resolveNode(node,objectGroup,callback)
{DOMAgent.resolveNode(node.id,objectGroup,function(error,object){if(!callback)
return;if(error||!object)
callback(null);else
callback(WebInspector.RemoteObject.fromPayload(object,WebInspector.mainTarget));});}
static resolveWebSocket(webSocketResource,objectGroup,callback)
{NetworkAgent.resolveWebSocket(webSocketResource.requestIdentifier,objectGroup,(error,object)=>{if(error||!object)
callback(null);else
callback(WebInspector.RemoteObject.fromPayload(object,webSocketResource.target));});}
static resolveCanvasContext(canvas,objectGroup,callback)
{CanvasAgent.resolveCanvasContext(canvas.identifier,objectGroup,(error,object)=>{if(error||!object)
callback(null);else
callback(WebInspector.RemoteObject.fromPayload(object,WebInspector.mainTarget));});}
static type(remoteObject)
{if(remoteObject===null)
return"null";var type=typeof remoteObject;if(type!=="object"&&type!=="function")
return type;return remoteObject.type;} 
get target()
{return this._target;}
get objectId()
{return this._objectId;}
get type()
{return this._type;}
get subtype()
{return this._subtype;}
get description()
{return this._description;}
get functionDescription()
{return this._functionDescription||this._description;}
get hasChildren()
{return this._hasChildren;}
get value()
{return this._value;}
get size()
{return this._size||0;}
get classPrototype()
{return this._classPrototype;}
get preview()
{return this._preview;}
hasSize()
{return this.isArray()||this.isCollectionType();}
hasValue()
{return"_value"in this;}
canLoadPreview()
{if(this._failedToLoadPreview)
return false;if(this._type!=="object")
return false;if(!this._objectId||this._isSymbol()||this._isFakeObject())
return false;return true;}
updatePreview(callback)
{if(!this.canLoadPreview()){callback(null);return;}
if(!RuntimeAgent.getPreview){this._failedToLoadPreview=true;callback(null);return;}
this._target.RuntimeAgent.getPreview(this._objectId,(error,payload)=>{if(error){this._failedToLoadPreview=true;callback(null);return;}
this._preview=WebInspector.ObjectPreview.fromPayload(payload);callback(this._preview);});}
getOwnPropertyDescriptors(callback)
{this._getPropertyDescriptors(true,callback);}
getAllPropertyDescriptors(callback)
{this._getPropertyDescriptors(false,callback);}
getDisplayablePropertyDescriptors(callback)
{if(!this._objectId||this._isSymbol()||this._isFakeObject()){callback([]);return;}
if(!RuntimeAgent.getDisplayableProperties){this._target.RuntimeAgent.getProperties(this._objectId,function(error,allProperties){var ownOrGetterPropertiesList=[];if(allProperties){for(var property of allProperties){if(property.isOwn||property.name==="__proto__"){ownOrGetterPropertiesList.push(property);}else if(property.value&&property.name!==property.name.toUpperCase()){var type=property.value.type;if(type&&type!=="function"&&property.name!=="constructor"){ownOrGetterPropertiesList.push(property);}}}}
this._getPropertyDescriptorsResolver(callback,error,ownOrGetterPropertiesList);}.bind(this));return;}
this._target.RuntimeAgent.getDisplayableProperties(this._objectId,true,this._getPropertyDescriptorsResolver.bind(this,callback));}
deprecatedGetOwnProperties(callback)
{this._deprecatedGetProperties(true,callback);}
deprecatedGetAllProperties(callback)
{this._deprecatedGetProperties(false,callback);}
deprecatedGetDisplayableProperties(callback)
{if(!this._objectId||this._isSymbol()||this._isFakeObject()){callback([]);return;}
if(!RuntimeAgent.getDisplayableProperties){this._target.RuntimeAgent.getProperties(this._objectId,function(error,allProperties){var ownOrGetterPropertiesList=[];if(allProperties){for(var property of allProperties){if(property.isOwn||property.get||property.name==="__proto__"){ownOrGetterPropertiesList.push(property);}else if(property.value&&property.name!==property.name.toUpperCase()){var type=property.value.type;if(type&&type!=="function"&&property.name!=="constructor"){ownOrGetterPropertiesList.push(property);}}}}
this._deprecatedGetPropertiesResolver(callback,error,ownOrGetterPropertiesList);}.bind(this));return;}
this._target.RuntimeAgent.getDisplayableProperties(this._objectId,this._deprecatedGetPropertiesResolver.bind(this,callback));}
setPropertyValue(name,value,callback)
{if(!this._objectId||this._isSymbol()||this._isFakeObject()){callback("Can't set a property of non-object.");return;}
this._target.RuntimeAgent.evaluate.invoke({expression:appendWebInspectorSourceURL(value),doNotPauseOnExceptionsAndMuteConsole:true},evaluatedCallback.bind(this),this._target.RuntimeAgent);function evaluatedCallback(error,result,wasThrown)
{if(error||wasThrown){callback(error||result.description);return;}
function setPropertyValue(propertyName,propertyValue)
{this[propertyName]=propertyValue;}
delete result.description;this._target.RuntimeAgent.callFunctionOn(this._objectId,appendWebInspectorSourceURL(setPropertyValue.toString()),[{value:name},result],true,undefined,propertySetCallback.bind(this));if(result._objectId)
this._target.RuntimeAgent.releaseObject(result._objectId);}
function propertySetCallback(error,result,wasThrown)
{if(error||wasThrown){callback(error||result.description);return;}
callback();}}
isUndefined()
{return this._type==="undefined";}
isNode()
{return this._subtype==="node";}
isArray()
{return this._subtype==="array";}
isClass()
{return this._subtype==="class";}
isCollectionType()
{return this._subtype==="map"||this._subtype==="set"||this._subtype==="weakmap"||this._subtype==="weakset";}
isWeakCollection()
{return this._subtype==="weakmap"||this._subtype==="weakset";}
getCollectionEntries(start,numberToFetch,callback)
{start=typeof start==="number"?start:0;numberToFetch=typeof numberToFetch==="number"?numberToFetch:100;let objectGroup=this.isWeakCollection()?this._weakCollectionObjectGroup():"";this._target.RuntimeAgent.getCollectionEntries(this._objectId,objectGroup,start,numberToFetch,(error,entries)=>{entries=entries.map((x)=>WebInspector.CollectionEntry.fromPayload(x,this._target));callback(entries);});}
releaseWeakCollectionEntries()
{this._target.RuntimeAgent.releaseObjectGroup(this._weakCollectionObjectGroup());}
pushNodeToFrontend(callback)
{if(this._objectId)
WebInspector.domTreeManager.pushNodeToFrontend(this._objectId,callback);else
callback(0);}
getProperty(propertyName,callback)
{function inspectedPage_object_getProperty(property){return this[property];}
this.callFunction(inspectedPage_object_getProperty,[propertyName],true,callback);}
callFunction(functionDeclaration,args,generatePreview,callback)
{function mycallback(error,result,wasThrown)
{result=result?WebInspector.RemoteObject.fromPayload(result,this._target):null;if(callback&&typeof callback==="function")
callback(error,result,wasThrown);}
if(args)
args=args.map(WebInspector.RemoteObject.createCallArgument);this._target.RuntimeAgent.callFunctionOn(this._objectId,appendWebInspectorSourceURL(functionDeclaration.toString()),args,true,undefined,!!generatePreview,mycallback.bind(this));}
callFunctionJSON(functionDeclaration,args,callback)
{function mycallback(error,result,wasThrown)
{callback((error||wasThrown)?null:result.value);}
this._target.RuntimeAgent.callFunctionOn(this._objectId,appendWebInspectorSourceURL(functionDeclaration.toString()),args,true,true,mycallback);}
invokeGetter(getterRemoteObject,callback)
{function backendInvokeGetter(getter)
{return getter?getter.call(this):undefined;}
this.callFunction(backendInvokeGetter,[getterRemoteObject],true,callback);}
getOwnPropertyDescriptor(propertyName,callback)
{function backendGetOwnPropertyDescriptor(propertyName)
{return this[propertyName];}
function wrappedCallback(error,result,wasThrown)
{if(error||wasThrown||!(result instanceof WebInspector.RemoteObject)){callback(null);return;}
var fakeDescriptor={name:propertyName,value:result,writable:true,configurable:true,enumerable:false};var fakePropertyDescriptor=new WebInspector.PropertyDescriptor(fakeDescriptor,null,true,false,false,false);callback(fakePropertyDescriptor);}
this.callFunction(backendGetOwnPropertyDescriptor,[propertyName],false,wrappedCallback.bind(this));}
release()
{if(this._objectId&&!this._isFakeObject())
this._target.RuntimeAgent.releaseObject(this._objectId);}
arrayLength()
{if(this._subtype!=="array")
return 0;var matches=this._description.match(/\[([0-9]+)\]/);if(!matches)
return 0;return parseInt(matches[1],10);}
asCallArgument()
{return WebInspector.RemoteObject.createCallArgument(this);}
findFunctionSourceCodeLocation()
{var result=new WebInspector.WrappedPromise;if(!this._isFunction()||!this._objectId){result.resolve(WebInspector.RemoteObject.SourceCodeLocationPromise.MissingObjectId);return result.promise;}
this._target.DebuggerAgent.getFunctionDetails(this._objectId,(error,response)=>{if(error){result.reject(error);return;}
var location=response.location;var sourceCode=WebInspector.debuggerManager.scriptForIdentifier(location.scriptId,this._target);if(!sourceCode||(!WebInspector.isDebugUIEnabled()&&isWebKitInternalScript(sourceCode.sourceURL))){result.resolve(WebInspector.RemoteObject.SourceCodeLocationPromise.NoSourceFound);return;}
var sourceCodeLocation=sourceCode.createSourceCodeLocation(location.lineNumber,location.columnNumber||0);result.resolve(sourceCodeLocation);});return result.promise;} 
_isFakeObject()
{return this._objectId===WebInspector.RemoteObject.FakeRemoteObjectId;}
_isSymbol()
{return this._type==="symbol";}
_isFunction()
{return this._type==="function";}
_weakCollectionObjectGroup()
{return JSON.stringify(this._objectId)+"-"+this._subtype;}
_getPropertyDescriptors(ownProperties,callback)
{if(!this._objectId||this._isSymbol()||this._isFakeObject()){callback([]);return;}
this._target.RuntimeAgent.getProperties(this._objectId,ownProperties,true,this._getPropertyDescriptorsResolver.bind(this,callback));}
getOwnPropertyDescriptorsAsObject(callback)
{this.getOwnPropertyDescriptors(function(properties){var propertiesResult={};var internalPropertiesResult={};for(var propertyDescriptor of properties){var object=propertyDescriptor.isInternalProperty?internalPropertiesResult:propertiesResult;object[propertyDescriptor.name]=propertyDescriptor;}
callback(propertiesResult,internalPropertiesResult);});}
_getPropertyDescriptorsResolver(callback,error,properties,internalProperties)
{if(error){callback(null);return;}
let descriptors=properties.map((payload)=>{return WebInspector.PropertyDescriptor.fromPayload(payload,false,this._target);});if(internalProperties){descriptors=descriptors.concat(internalProperties.map((payload)=>{return WebInspector.PropertyDescriptor.fromPayload(payload,true,this._target);}));}
callback(descriptors);}
_deprecatedGetProperties(ownProperties,callback)
{if(!this._objectId||this._isSymbol()||this._isFakeObject()){callback([]);return;}
this._target.RuntimeAgent.getProperties(this._objectId,ownProperties,this._deprecatedGetPropertiesResolver.bind(this,callback));}
_deprecatedGetPropertiesResolver(callback,error,properties,internalProperties)
{if(error){callback(null);return;}
if(internalProperties){properties=properties.concat(internalProperties.map(function(descriptor){descriptor.writable=false;descriptor.configurable=false;descriptor.enumerable=false;descriptor.isOwn=true;return descriptor;}));}
var result=[];for(var i=0;properties&&i<properties.length;++i){var property=properties[i];if(property.get||property.set){if(property.get)
result.push(new WebInspector.DeprecatedRemoteObjectProperty("get "+property.name,WebInspector.RemoteObject.fromPayload(property.get,this._target),property));if(property.set)
result.push(new WebInspector.DeprecatedRemoteObjectProperty("set "+property.name,WebInspector.RemoteObject.fromPayload(property.set,this._target),property));}else
result.push(new WebInspector.DeprecatedRemoteObjectProperty(property.name,WebInspector.RemoteObject.fromPayload(property.value,this._target),property));}
callback(result);}};WebInspector.RemoteObject.FakeRemoteObjectId="fake-remote-object";WebInspector.RemoteObject.SourceCodeLocationPromise={NoSourceFound:"remote-object-source-code-location-promise-no-source-found",MissingObjectId:"remote-object-source-code-location-promise-missing-object-id"};WebInspector.DeprecatedRemoteObjectProperty=class DeprecatedRemoteObjectProperty
{constructor(name,value,descriptor)
{this.name=name;this.value=value;this.enumerable=descriptor?!!descriptor.enumerable:true;this.writable=descriptor?!!descriptor.writable:true;if(descriptor&&descriptor.wasThrown)
this.wasThrown=true;} 
fromPrimitiveValue(name,value)
{return new WebInspector.DeprecatedRemoteObjectProperty(name,WebInspector.RemoteObject.fromPrimitiveValue(value));}};WebInspector.Target=class Target extends WebInspector.Object
{constructor(identifier,name,type,connection)
{super();this._identifier=identifier;this._name=name;this._type=type;this._connection=connection;this._executionContext=null;this._mainResource=null;this._resourceCollection=new WebInspector.ResourceCollection;this._extraScriptCollection=new WebInspector.Collection(WebInspector.Collection.TypeVerifier.Script);this._connection.target=this;} 
get RuntimeAgent(){return this._connection._agents.Runtime;}
get ConsoleAgent(){return this._connection._agents.Console;}
get DebuggerAgent(){return this._connection._agents.Debugger;}
get HeapAgent(){return this._connection._agents.Heap;} 
get identifier(){return this._identifier;}
get name(){return this._name;}
get type(){return this._type;}
get connection(){return this._connection;}
get executionContext(){return this._executionContext;}
get resourceCollection(){return this._resourceCollection;}
get extraScriptCollection(){return this._extraScriptCollection;}
get mainResource(){return this._mainResource;}
set mainResource(resource){this._mainResource=resource;}
addResource(resource)
{this._resourceCollection.add(resource);this.dispatchEventToListeners(WebInspector.Target.Event.ResourceAdded,{resource});}
adoptResource(resource)
{resource._target=this;this.addResource(resource);}
addScript(script)
{this._extraScriptCollection.add(script);this.dispatchEventToListeners(WebInspector.Target.Event.ScriptAdded,{script});}};WebInspector.Target.Type={Main:Symbol("main"),Worker:Symbol("worker"),};WebInspector.Target.Event={ResourceAdded:"target-resource-added",ScriptAdded:"target-script-added",};WebInspector.MainTarget=class MainTarget extends WebInspector.Target
{constructor(connection)
{super("main","",WebInspector.Target.Type.Main,InspectorBackend.mainConnection);let displayName=WebInspector.debuggableType===WebInspector.DebuggableType.Web?WebInspector.UIString("Main Frame"):this.displayName;this._executionContext=new WebInspector.ExecutionContext(this,WebInspector.RuntimeManager.TopLevelContextExecutionIdentifier,displayName,true,null);}
get displayName()
{switch(WebInspector.debuggableType){case WebInspector.DebuggableType.Web:return WebInspector.UIString("Page");case WebInspector.DebuggableType.JavaScript:return WebInspector.UIString("JavaScript Context");default:console.error("Unexpected debuggable type: ",WebInspector.debuggableType);return WebInspector.UIString("Main");}}
get mainResource()
{let mainFrame=WebInspector.frameResourceManager.mainFrame;return mainFrame?mainFrame.mainResource:null;}};WebInspector.WorkerTarget=class WorkerTarget extends WebInspector.Target
{constructor(workerId,name,connection)
{super(workerId,name,WebInspector.Target.Type.Worker,connection);WebInspector.frameResourceManager.adoptOrphanedResourcesForTarget(this);if(this.RuntimeAgent){this._executionContext=new WebInspector.ExecutionContext(this,WebInspector.RuntimeManager.TopLevelContextExecutionIdentifier,this.displayName,false,null);this.RuntimeAgent.enable();if(WebInspector.showJavaScriptTypeInformationSetting&&WebInspector.showJavaScriptTypeInformationSetting.value)
this.RuntimeAgent.enableTypeProfiler();if(WebInspector.enableControlFlowProfilerSetting&&WebInspector.enableControlFlowProfilerSetting.value)
this.RuntimeAgent.enableControlFlowProfiler();}
if(this.DebuggerAgent)
WebInspector.debuggerManager.initializeTarget(this);if(this.ConsoleAgent)
this.ConsoleAgent.enable();if(this.HeapAgent)
this.HeapAgent.enable();}
get displayName()
{return WebInspector.displayNameForURL(this._name);}};WebInspector.ApplicationCacheObserver=class ApplicationCacheObserver
{applicationCacheStatusUpdated(frameId,manifestURL,status)
{WebInspector.applicationCacheManager.applicationCacheStatusUpdated(frameId,manifestURL,status);}
networkStateUpdated(isNowOnline)
{WebInspector.applicationCacheManager.networkStateUpdated(isNowOnline);}};WebInspector.CSSObserver=class CSSObserver
{mediaQueryResultChanged()
{WebInspector.cssStyleManager.mediaQueryResultChanged();}
styleSheetChanged(styleSheetId)
{WebInspector.cssStyleManager.styleSheetChanged(styleSheetId);}
styleSheetAdded(styleSheetInfo)
{WebInspector.cssStyleManager.styleSheetAdded(styleSheetInfo);}
styleSheetRemoved(id)
{WebInspector.cssStyleManager.styleSheetRemoved(id);}
namedFlowCreated(namedFlow)
{WebInspector.domTreeManager.namedFlowCreated(namedFlow);}
namedFlowRemoved(documentNodeId,flowName)
{WebInspector.domTreeManager.namedFlowRemoved(documentNodeId,flowName);}
regionLayoutUpdated(namedFlow)
{this.regionOversetChanged(namedFlow);}
regionOversetChanged(namedFlow)
{WebInspector.domTreeManager.regionOversetChanged(namedFlow);}
registeredNamedFlowContentElement(documentNodeId,flowName,contentNodeId,nextContentElementNodeId)
{WebInspector.domTreeManager.registeredNamedFlowContentElement(documentNodeId,flowName,contentNodeId,nextContentElementNodeId);}
unregisteredNamedFlowContentElement(documentNodeId,flowName,contentNodeId)
{WebInspector.domTreeManager.unregisteredNamedFlowContentElement(documentNodeId,flowName,contentNodeId);}};WebInspector.CanvasObserver=class CanvasObserver
{canvasAdded(canvas)
{WebInspector.canvasManager.canvasAdded(canvas);}
canvasRemoved(canvasId)
{WebInspector.canvasManager.canvasRemoved(canvasId);}
canvasMemoryChanged(canvasId,memoryCost)
{WebInspector.canvasManager.canvasMemoryChanged(canvasId,memoryCost);}
cssCanvasClientNodesChanged(canvasId)
{WebInspector.canvasManager.cssCanvasClientNodesChanged(canvasId);}};WebInspector.ConsoleObserver=class ConsoleObserver
{messageAdded(message)
{if(message.source==="console-api"&&message.type==="clear")
return;if(message.type==="assert"&&!message.text)
message.text=WebInspector.UIString("Assertion");WebInspector.logManager.messageWasAdded(this.target,message.source,message.level,message.text,message.type,message.url,message.line,message.column||0,message.repeatCount,message.parameters,message.stackTrace,message.networkRequestId);}
messageRepeatCountUpdated(count)
{WebInspector.logManager.messageRepeatCountUpdated(count);}
messagesCleared()
{WebInspector.logManager.messagesCleared();}
heapSnapshot(timestamp,snapshotStringData,title)
{let workerProxy=WebInspector.HeapSnapshotWorkerProxy.singleton();workerProxy.createSnapshot(snapshotStringData,title||null,({objectId,snapshot:serializedSnapshot})=>{let snapshot=WebInspector.HeapSnapshotProxy.deserialize(objectId,serializedSnapshot);WebInspector.timelineManager.heapSnapshotAdded(timestamp,snapshot);});}};WebInspector.DOMObserver=class DOMObserver
{documentUpdated()
{WebInspector.domTreeManager._documentUpdated();}
setChildNodes(parentId,payloads)
{WebInspector.domTreeManager._setChildNodes(parentId,payloads);}
attributeModified(nodeId,name,value)
{WebInspector.domTreeManager._attributeModified(nodeId,name,value);}
attributeRemoved(nodeId,name)
{WebInspector.domTreeManager._attributeRemoved(nodeId,name);}
inlineStyleInvalidated(nodeIds)
{WebInspector.domTreeManager._inlineStyleInvalidated(nodeIds);}
characterDataModified(nodeId,characterData)
{WebInspector.domTreeManager._characterDataModified(nodeId,characterData);}
childNodeCountUpdated(nodeId,childNodeCount)
{WebInspector.domTreeManager._childNodeCountUpdated(nodeId,childNodeCount);}
childNodeInserted(parentNodeId,previousNodeId,payload)
{WebInspector.domTreeManager._childNodeInserted(parentNodeId,previousNodeId,payload);}
childNodeRemoved(parentNodeId,nodeId)
{WebInspector.domTreeManager._childNodeRemoved(parentNodeId,nodeId);}
shadowRootPushed(parentNodeId,nodeId)
{WebInspector.domTreeManager._childNodeInserted(parentNodeId,0,nodeId);}
shadowRootPopped(parentNodeId,nodeId)
{WebInspector.domTreeManager._childNodeRemoved(parentNodeId,nodeId);}
customElementStateChanged(nodeId,customElementState)
{WebInspector.domTreeManager._customElementStateChanged(nodeId,customElementState);}
pseudoElementAdded(parentNodeId,pseudoElement)
{WebInspector.domTreeManager._pseudoElementAdded(parentNodeId,pseudoElement);}
pseudoElementRemoved(parentNodeId,pseudoElementId)
{WebInspector.domTreeManager._pseudoElementRemoved(parentNodeId,pseudoElementId);}};WebInspector.DOMStorageObserver=class DOMStorageObserver
{domStorageItemsCleared(storageId)
{WebInspector.storageManager.itemsCleared(storageId);}
domStorageItemRemoved(storageId,key)
{WebInspector.storageManager.itemRemoved(storageId,key);}
domStorageItemAdded(storageId,key,value)
{WebInspector.storageManager.itemAdded(storageId,key,value);}
domStorageItemUpdated(storageId,key,oldValue,value)
{WebInspector.storageManager.itemUpdated(storageId,key,oldValue,value);}};WebInspector.DatabaseObserver=class DatabaseObserver
{addDatabase(database)
{WebInspector.storageManager.databaseWasAdded(database.id,database.domain,database.name,database.version);}};WebInspector.DebuggerObserver=class DebuggerObserver
{constructor()
{this._legacyScriptParsed=DebuggerAgent.hasEventParameter("scriptParsed","hasSourceURL");}
globalObjectCleared()
{WebInspector.debuggerManager.reset();}
scriptParsed(scriptId,url,startLine,startColumn,endLine,endColumn,isContentScript,sourceURL,sourceMapURL,isModule)
{if(this._legacyScriptParsed){
let legacySourceMapURL=arguments[7];let hasSourceURL=arguments[8];let legacySourceURL=hasSourceURL?url:undefined;WebInspector.debuggerManager.scriptDidParse(this.target,scriptId,url,startLine,startColumn,endLine,endColumn,isModule,isContentScript,legacySourceURL,legacySourceMapURL);return;}
WebInspector.debuggerManager.scriptDidParse(this.target,scriptId,url,startLine,startColumn,endLine,endColumn,isModule,isContentScript,sourceURL,sourceMapURL);}
scriptFailedToParse(url,scriptSource,startLine,errorLine,errorMessage)
{}
breakpointResolved(breakpointId,location)
{WebInspector.debuggerManager.breakpointResolved(this.target,breakpointId,location);}
paused(callFrames,reason,data,asyncStackTrace)
{WebInspector.debuggerManager.debuggerDidPause(this.target,callFrames,reason,data,asyncStackTrace);}
resumed()
{WebInspector.debuggerManager.debuggerDidResume(this.target);}
playBreakpointActionSound(breakpointActionIdentifier)
{WebInspector.debuggerManager.playBreakpointActionSound(breakpointActionIdentifier);}
didSampleProbe(sample)
{WebInspector.probeManager.didSampleProbe(this.target,sample);}};WebInspector.HeapObserver=class HeapObserver
{garbageCollected(collection)
{WebInspector.heapManager.garbageCollected(this.target,collection);}
trackingStart(timestamp,snapshotStringData)
{let workerProxy=WebInspector.HeapSnapshotWorkerProxy.singleton();workerProxy.createSnapshot(snapshotStringData,({objectId,snapshot:serializedSnapshot})=>{let snapshot=WebInspector.HeapSnapshotProxy.deserialize(objectId,serializedSnapshot);WebInspector.timelineManager.heapTrackingStarted(timestamp,snapshot);});}
trackingComplete(timestamp,snapshotStringData)
{let workerProxy=WebInspector.HeapSnapshotWorkerProxy.singleton();workerProxy.createSnapshot(snapshotStringData,({objectId,snapshot:serializedSnapshot})=>{let snapshot=WebInspector.HeapSnapshotProxy.deserialize(objectId,serializedSnapshot);WebInspector.timelineManager.heapTrackingCompleted(timestamp,snapshot);});}};WebInspector.InspectorObserver=class InspectorObserver
{evaluateForTestInFrontend(script)
{if(!InspectorFrontendHost.isUnderTest())
return;InspectorBackend.runAfterPendingDispatches(function(){window.eval(script);});}
inspect(payload,hints)
{var remoteObject=WebInspector.RemoteObject.fromPayload(payload,WebInspector.mainTarget);if(remoteObject.subtype==="node"){WebInspector.domTreeManager.inspectNodeObject(remoteObject);return;}
if(hints.databaseId)
WebInspector.storageManager.inspectDatabase(hints.databaseId);else if(hints.domStorageId)
WebInspector.storageManager.inspectDOMStorage(hints.domStorageId);remoteObject.release();}
activateExtraDomains(domains)
{WebInspector.activateExtraDomains(domains);}};WebInspector.LayerTreeObserver=class LayerTreeObserver
{layerTreeDidChange()
{if(WebInspector.layerTreeManager.supported)
WebInspector.layerTreeManager.layerTreeDidChange();}};WebInspector.MemoryObserver=class MemoryObserver
{memoryPressure(timestamp,severity)
{WebInspector.memoryManager.memoryPressure(timestamp,severity);}
trackingStart(timestamp)
{WebInspector.timelineManager.memoryTrackingStart(timestamp);}
trackingUpdate(event)
{WebInspector.timelineManager.memoryTrackingUpdate(event);}
trackingComplete()
{WebInspector.timelineManager.memoryTrackingComplete();}};WebInspector.NetworkObserver=class NetworkObserver
{requestWillBeSent(requestId,frameId,loaderId,documentURL,request,timestamp,initiator,redirectResponse,type,targetId)
{WebInspector.frameResourceManager.resourceRequestWillBeSent(requestId,frameId,loaderId,request,type,redirectResponse,timestamp,initiator,targetId);}
requestServedFromCache(requestId)
{WebInspector.frameResourceManager.markResourceRequestAsServedFromMemoryCache(requestId);}
responseReceived(requestId,frameId,loaderId,timestamp,type,response)
{WebInspector.frameResourceManager.resourceRequestDidReceiveResponse(requestId,frameId,loaderId,type,response,timestamp);}
dataReceived(requestId,timestamp,dataLength,encodedDataLength)
{WebInspector.frameResourceManager.resourceRequestDidReceiveData(requestId,dataLength,encodedDataLength,timestamp);}
loadingFinished(requestId,timestamp,sourceMapURL,metrics)
{WebInspector.frameResourceManager.resourceRequestDidFinishLoading(requestId,timestamp,sourceMapURL,metrics);}
loadingFailed(requestId,timestamp,errorText,canceled)
{WebInspector.frameResourceManager.resourceRequestDidFailLoading(requestId,canceled,timestamp,errorText);}
requestServedFromMemoryCache(requestId,frameId,loaderId,documentURL,timestamp,initiator,resource)
{WebInspector.frameResourceManager.resourceRequestWasServedFromMemoryCache(requestId,frameId,loaderId,resource,timestamp,initiator);}
webSocketCreated(requestId,url)
{WebInspector.frameResourceManager.webSocketCreated(requestId,url);}
webSocketWillSendHandshakeRequest(requestId,timestamp,walltime,request)
{WebInspector.frameResourceManager.webSocketWillSendHandshakeRequest(requestId,timestamp,walltime,request);}
webSocketHandshakeResponseReceived(requestId,timestamp,response)
{WebInspector.frameResourceManager.webSocketHandshakeResponseReceived(requestId,timestamp,response);}
webSocketClosed(requestId,timestamp)
{WebInspector.frameResourceManager.webSocketClosed(requestId,timestamp);}
webSocketFrameReceived(requestId,timestamp,response)
{WebInspector.frameResourceManager.webSocketFrameReceived(requestId,timestamp,response);}
webSocketFrameSent(requestId,timestamp,response)
{WebInspector.frameResourceManager.webSocketFrameSent(requestId,timestamp,response);}
webSocketFrameError(requestId,timestamp,errorMessage)
{}};WebInspector.PageObserver=class PageObserver
{domContentEventFired(timestamp)
{WebInspector.timelineManager.pageDOMContentLoadedEventFired(timestamp);}
loadEventFired(timestamp)
{WebInspector.timelineManager.pageLoadEventFired(timestamp);}
frameNavigated(frame,loaderId)
{WebInspector.frameResourceManager.frameDidNavigate(frame,loaderId);}
frameDetached(frameId)
{WebInspector.frameResourceManager.frameDidDetach(frameId);}
frameStartedLoading(frameId)
{}
frameStoppedLoading(frameId)
{}
frameScheduledNavigation(frameId,delay)
{}
frameClearedScheduledNavigation(frameId)
{}
javascriptDialogOpening(message)
{}
javascriptDialogClosed()
{}
scriptsEnabled(enabled)
{}};WebInspector.RuntimeObserver=class RuntimeObserver
{executionContextCreated(contextPayload)
{WebInspector.frameResourceManager.executionContextCreated(contextPayload);}};WebInspector.ScriptProfilerObserver=class ScriptProfilerObserver
{trackingStart(timestamp)
{WebInspector.timelineManager.scriptProfilerTrackingStarted(timestamp);}
trackingUpdate(event)
{WebInspector.timelineManager.scriptProfilerTrackingUpdated(event);}
trackingComplete(samples)
{WebInspector.timelineManager.scriptProfilerTrackingCompleted(samples);}
programmaticCaptureStarted()
{WebInspector.timelineManager.scriptProfilerProgrammaticCaptureStarted();}
programmaticCaptureStopped()
{WebInspector.timelineManager.scriptProfilerProgrammaticCaptureStopped();}};WebInspector.TimelineObserver=class TimelineObserver
{eventRecorded(record)
{WebInspector.timelineManager.eventRecorded(record);}
recordingStarted(startTime)
{WebInspector.timelineManager.capturingStarted(startTime);}
recordingStopped(endTime)
{WebInspector.timelineManager.capturingStopped(endTime);}
autoCaptureStarted()
{WebInspector.timelineManager.autoCaptureStarted();}
programmaticCaptureStarted()
{WebInspector.timelineManager.programmaticCaptureStarted();}
programmaticCaptureStopped()
{WebInspector.timelineManager.programmaticCaptureStopped();}};WebInspector.WorkerObserver=class WorkerObserver
{workerCreated(workerId,url)
{WebInspector.workerManager.workerCreated(workerId,url);}
workerTerminated(workerId)
{WebInspector.workerManager.workerTerminated(workerId);}
dispatchMessageFromWorker(workerId,message)
{WebInspector.workerManager.dispatchMessageFromWorker(workerId,message);}};WebInspector.BreakpointAction=class BreakpointAction extends WebInspector.Object
{constructor(breakpoint,typeOrInfo,data)
{super();this._breakpoint=breakpoint;if(typeof typeOrInfo==="string"){this._type=typeOrInfo;this._data=data||null;}else if(typeof typeOrInfo==="object"){this._type=typeOrInfo.type;this._data=typeOrInfo.data||null;}else
console.error("Unexpected type passed to WebInspector.BreakpointAction");this._id=WebInspector.debuggerManager.nextBreakpointActionIdentifier();} 
get breakpoint(){return this._breakpoint;}
get id(){return this._id;}
get type(){return this._type;}
get data()
{return this._data;}
set data(data)
{if(this._data===data)
return;this._data=data;this._breakpoint.breakpointActionDidChange(this);}
get info()
{var obj={type:this._type,id:this._id};if(this._data)
obj.data=this._data;return obj;}};WebInspector.BreakpointAction.Type={Log:"log",Evaluate:"evaluate",Sound:"sound",Probe:"probe"};WebInspector.ConsoleMessage=class ConsoleMessage extends WebInspector.Object
{constructor(target,source,level,message,type,url,line,column,repeatCount,parameters,callFrames,request)
{super();this._target=target;this._source=source;this._level=level;this._messageText=message;this._type=type||WebInspector.ConsoleMessage.MessageType.Log;this._url=url||null;this._line=line||0;this._column=column||0;this._sourceCodeLocation=undefined;this._repeatCount=repeatCount||0;this._parameters=parameters;callFrames=callFrames||[];this._stackTrace=WebInspector.StackTrace.fromPayload(this._target,{callFrames});this._request=request;} 
get target(){return this._target;}
get source(){return this._source;}
get level(){return this._level;}
get messageText(){return this._messageText;}
get type(){return this._type;}
get url(){return this._url;}
get line(){return this._line;}
get column(){return this._column;}
get repeatCount(){return this._repeatCount;}
get parameters(){return this._parameters;}
get stackTrace(){return this._stackTrace;}
get request(){return this._request;}
get sourceCodeLocation()
{if(this._sourceCodeLocation!==undefined)
return this._sourceCodeLocation;let topCallFrame=this._stackTrace.callFrames[0];if(topCallFrame&&topCallFrame.sourceCodeLocation){this._sourceCodeLocation=topCallFrame.sourceCodeLocation;return this._sourceCodeLocation;}
if(this._url&&this._url!=="undefined"){let sourceCode=WebInspector.frameResourceManager.resourceForURL(this._url);if(sourceCode){let lineNumber=this._line>0?this._line-1:0;let columnNumber=this._column>0?this._column-1:0;this._sourceCodeLocation=new WebInspector.SourceCodeLocation(sourceCode,lineNumber,columnNumber);return this._sourceCodeLocation;}}
this._sourceCodeLocation=null;return this._sourceCodeLocation;}};WebInspector.ConsoleMessage.MessageSource={HTML:"html",XML:"xml",JS:"javascript",Network:"network",ConsoleAPI:"console-api",Storage:"storage",Appcache:"appcache",Rendering:"rendering",CSS:"css",Security:"security",Other:"other",};WebInspector.ConsoleMessage.MessageType={Log:"log",Dir:"dir",DirXML:"dirxml",Table:"table",Trace:"trace",StartGroup:"startGroup",StartGroupCollapsed:"startGroupCollapsed",EndGroup:"endGroup",Assert:"assert",Timing:"timing",Profile:"profile",ProfileEnd:"profileEnd",Result:"result",};WebInspector.ConsoleMessage.MessageLevel={Log:"log",Info:"info",Warning:"warning",Error:"error",Debug:"debug",};WebInspector.Instrument=class Instrument extends WebInspector.Object
{ static createForTimelineType(type)
{switch(type){case WebInspector.TimelineRecord.Type.Network:return new WebInspector.NetworkInstrument;case WebInspector.TimelineRecord.Type.Layout:return new WebInspector.LayoutInstrument;case WebInspector.TimelineRecord.Type.Script:return new WebInspector.ScriptInstrument;case WebInspector.TimelineRecord.Type.RenderingFrame:return new WebInspector.FPSInstrument;case WebInspector.TimelineRecord.Type.Memory:return new WebInspector.MemoryInstrument;case WebInspector.TimelineRecord.Type.HeapAllocations:return new WebInspector.HeapAllocationsInstrument;default:console.error("Unknown TimelineRecord.Type: "+type);return null;}}
static startLegacyTimelineAgent(initiatedByBackend)
{if(WebInspector.Instrument._legacyTimelineAgentStarted)
return;WebInspector.Instrument._legacyTimelineAgentStarted=true;if(initiatedByBackend)
return;let result=TimelineAgent.start();if(!TimelineAgent.hasEvent("recordingStarted")){result.then(function(){WebInspector.timelineManager.capturingStarted();});}}
static stopLegacyTimelineAgent(initiatedByBackend)
{if(!WebInspector.Instrument._legacyTimelineAgentStarted)
return;WebInspector.Instrument._legacyTimelineAgentStarted=false;if(initiatedByBackend)
return;TimelineAgent.stop();} 
get timelineRecordType()
{return null;}
startInstrumentation(initiatedByBackend)
{WebInspector.Instrument.startLegacyTimelineAgent(initiatedByBackend);}
stopInstrumentation(initiatedByBackend)
{WebInspector.Instrument.stopLegacyTimelineAgent(initiatedByBackend);}};WebInspector.Instrument._legacyTimelineAgentStarted=false;WebInspector.SourceCode=class SourceCode extends WebInspector.Object
{constructor()
{super();this._originalRevision=new WebInspector.SourceCodeRevision(this,null,false);this._currentRevision=this._originalRevision;this._sourceMaps=null;this._formatterSourceMap=null;this._requestContentPromise=null;} 
get displayName()
{console.error("Needs to be implemented by a subclass.");return"";}
get originalRevision()
{return this._originalRevision;}
get currentRevision()
{return this._currentRevision;}
set currentRevision(revision)
{if(!(revision instanceof WebInspector.SourceCodeRevision))
return;if(revision.sourceCode!==this)
return;this._currentRevision=revision;this.dispatchEventToListeners(WebInspector.SourceCode.Event.ContentDidChange);}
get content()
{return this._currentRevision.content;}
get url()
{}
get contentIdentifier()
{
return this.url;}
get sourceMaps()
{return this._sourceMaps||[];}
addSourceMap(sourceMap)
{if(!this._sourceMaps)
this._sourceMaps=[];this._sourceMaps.push(sourceMap);this.dispatchEventToListeners(WebInspector.SourceCode.Event.SourceMapAdded);}
get formatterSourceMap()
{return this._formatterSourceMap;}
set formatterSourceMap(formatterSourceMap)
{this._formatterSourceMap=formatterSourceMap;this.dispatchEventToListeners(WebInspector.SourceCode.Event.FormatterDidChange);}
requestContent()
{this._requestContentPromise=this._requestContentPromise||this.requestContentFromBackend().then(this._processContent.bind(this));return this._requestContentPromise;}
createSourceCodeLocation(lineNumber,columnNumber)
{return new WebInspector.SourceCodeLocation(this,lineNumber,columnNumber);}
createLazySourceCodeLocation(lineNumber,columnNumber)
{return new WebInspector.LazySourceCodeLocation(this,lineNumber,columnNumber);}
createSourceCodeTextRange(textRange)
{return new WebInspector.SourceCodeTextRange(this,textRange);} 
revisionContentDidChange(revision)
{if(this._ignoreRevisionContentDidChangeEvent)
return;if(revision!==this._currentRevision)
return;this.handleCurrentRevisionContentChange();this.dispatchEventToListeners(WebInspector.SourceCode.Event.ContentDidChange);}
handleCurrentRevisionContentChange()
{}
get revisionForRequestedContent()
{return this._originalRevision;}
markContentAsStale()
{this._requestContentPromise=null;this._contentReceived=false;}
requestContentFromBackend()
{console.error("Needs to be implemented by a subclass.");return Promise.reject(new Error("Needs to be implemented by a subclass."));}
get mimeType()
{console.error("Needs to be implemented by a subclass.");} 
_processContent(parameters)
{var content=parameters.content||parameters.body||parameters.text||parameters.scriptSource;var error=parameters.error;if(parameters.base64Encoded)
content=decodeBase64ToBlob(content,this.mimeType);var revision=this.revisionForRequestedContent;this._ignoreRevisionContentDidChangeEvent=true;revision.content=content||null;this._ignoreRevisionContentDidChangeEvent=false;

return Promise.resolve({error,sourceCode:this,content,});}};WebInspector.SourceCode.Event={ContentDidChange:"source-code-content-did-change",SourceMapAdded:"source-code-source-map-added",FormatterDidChange:"source-code-formatter-did-change",LoadingDidFinish:"source-code-loading-did-finish",LoadingDidFail:"source-code-loading-did-fail"};WebInspector.SourceCodeLocation=class SourceCodeLocation extends WebInspector.Object
{constructor(sourceCode,lineNumber,columnNumber)
{super();this._sourceCode=sourceCode||null;this._lineNumber=lineNumber;this._columnNumber=columnNumber;this._resolveFormattedLocation();if(this._sourceCode){this._sourceCode.addEventListener(WebInspector.SourceCode.Event.SourceMapAdded,this._sourceCodeSourceMapAdded,this);this._sourceCode.addEventListener(WebInspector.SourceCode.Event.FormatterDidChange,this._sourceCodeFormatterDidChange,this);}
this._resetMappedLocation();} 
isEqual(other)
{if(!other)
return false;return this._sourceCode===other._sourceCode&&this._lineNumber===other._lineNumber&&this._columnNumber===other._columnNumber;}
get sourceCode()
{return this._sourceCode;}
set sourceCode(sourceCode)
{this.setSourceCode(sourceCode);}
get lineNumber()
{return this._lineNumber;}
get columnNumber()
{return this._columnNumber;}
position()
{return new WebInspector.SourceCodePosition(this.lineNumber,this.columnNumber);}
get formattedLineNumber()
{return this._formattedLineNumber;}
get formattedColumnNumber()
{return this._formattedColumnNumber;}
formattedPosition()
{return new WebInspector.SourceCodePosition(this.formattedLineNumber,this.formattedColumnNumber);}
get displaySourceCode()
{this.resolveMappedLocation();return this._mappedResource||this._sourceCode;}
get displayLineNumber()
{this.resolveMappedLocation();return isNaN(this._mappedLineNumber)?this._formattedLineNumber:this._mappedLineNumber;}
get displayColumnNumber()
{this.resolveMappedLocation();return isNaN(this._mappedColumnNumber)?this._formattedColumnNumber:this._mappedColumnNumber;}
displayPosition()
{return new WebInspector.SourceCodePosition(this.displayLineNumber,this.displayColumnNumber);}
originalLocationString(columnStyle,nameStyle,prefix)
{return this._locationString(this.sourceCode,this.lineNumber,this.columnNumber,columnStyle,nameStyle,prefix);}
formattedLocationString(columnStyle,nameStyle,prefix)
{return this._locationString(this.sourceCode,this.formattedLineNumber,this.formattedColumn,columnStyle,nameStyle,prefix);}
displayLocationString(columnStyle,nameStyle,prefix)
{return this._locationString(this.displaySourceCode,this.displayLineNumber,this.displayColumnNumber,columnStyle,nameStyle,prefix);}
tooltipString()
{if(!this.hasDifferentDisplayLocation())
return this.originalLocationString(WebInspector.SourceCodeLocation.ColumnStyle.Shown,WebInspector.SourceCodeLocation.NameStyle.Full);var tooltip=WebInspector.UIString("Located at %s").format(this.displayLocationString(WebInspector.SourceCodeLocation.ColumnStyle.Shown,WebInspector.SourceCodeLocation.NameStyle.Full));tooltip+="\n"+WebInspector.UIString("Originally %s").format(this.originalLocationString(WebInspector.SourceCodeLocation.ColumnStyle.Shown,WebInspector.SourceCodeLocation.NameStyle.Full));return tooltip;}
hasMappedLocation()
{this.resolveMappedLocation();return this._mappedResource!==null;}
hasFormattedLocation()
{return this._formattedLineNumber!==this._lineNumber||this._formattedColumnNumber!==this._columnNumber;}
hasDifferentDisplayLocation()
{return this.hasMappedLocation()||this.hasFormattedLocation();}
update(sourceCode,lineNumber,columnNumber)
{if(sourceCode===this._sourceCode&&lineNumber===this._lineNumber&&columnNumber===this._columnNumber)
return;if(this._mappedResource&&sourceCode===this._mappedResource&&lineNumber===this._mappedLineNumber&&columnNumber===this._mappedColumnNumber)
return;var newSourceCodeLocation=sourceCode.createSourceCodeLocation(lineNumber,columnNumber);this._makeChangeAndDispatchChangeEventIfNeeded(function(){this._lineNumber=newSourceCodeLocation._lineNumber;this._columnNumber=newSourceCodeLocation._columnNumber;if(newSourceCodeLocation._mappedLocationIsResolved){this._mappedLocationIsResolved=true;this._mappedResource=newSourceCodeLocation._mappedResource;this._mappedLineNumber=newSourceCodeLocation._mappedLineNumber;this._mappedColumnNumber=newSourceCodeLocation._mappedColumnNumber;}});}
populateLiveDisplayLocationTooltip(element,prefix)
{prefix=prefix||"";element.title=prefix+this.tooltipString();this.addEventListener(WebInspector.SourceCodeLocation.Event.DisplayLocationChanged,function(event){if(this.sourceCode)
element.title=prefix+this.tooltipString();},this);}
populateLiveDisplayLocationString(element,propertyName,columnStyle,nameStyle,prefix)
{var currentDisplay;function updateDisplayString(showAlternativeLocation,forceUpdate)
{if(!forceUpdate&&currentDisplay===showAlternativeLocation)
return;currentDisplay=showAlternativeLocation;if(!showAlternativeLocation){element[propertyName]=this.displayLocationString(columnStyle,nameStyle,prefix);element.classList.toggle(WebInspector.SourceCodeLocation.DisplayLocationClassName,this.hasDifferentDisplayLocation());}else if(this.hasDifferentDisplayLocation()){element[propertyName]=this.originalLocationString(columnStyle,nameStyle,prefix);element.classList.remove(WebInspector.SourceCodeLocation.DisplayLocationClassName);}}
function mouseOverOrMove(event)
{updateDisplayString.call(this,event.metaKey&&!event.altKey&&!event.shiftKey);}
updateDisplayString.call(this,false);this.addEventListener(WebInspector.SourceCodeLocation.Event.DisplayLocationChanged,function(event){if(this.sourceCode)
updateDisplayString.call(this,currentDisplay,true);},this);var boundMouseOverOrMove=mouseOverOrMove.bind(this);element.addEventListener("mouseover",boundMouseOverOrMove);element.addEventListener("mousemove",boundMouseOverOrMove);element.addEventListener("mouseout",(event)=>{updateDisplayString.call(this,false);});} 
setSourceCode(sourceCode)
{if(sourceCode===this._sourceCode)
return;this._makeChangeAndDispatchChangeEventIfNeeded(function(){if(this._sourceCode){this._sourceCode.removeEventListener(WebInspector.SourceCode.Event.SourceMapAdded,this._sourceCodeSourceMapAdded,this);this._sourceCode.removeEventListener(WebInspector.SourceCode.Event.FormatterDidChange,this._sourceCodeFormatterDidChange,this);}
this._sourceCode=sourceCode;if(this._sourceCode){this._sourceCode.addEventListener(WebInspector.SourceCode.Event.SourceMapAdded,this._sourceCodeSourceMapAdded,this);this._sourceCode.addEventListener(WebInspector.SourceCode.Event.FormatterDidChange,this._sourceCodeFormatterDidChange,this);}});}
resolveMappedLocation()
{if(this._mappedLocationIsResolved)
return;this._mappedLocationIsResolved=true;if(!this._sourceCode)
return;var sourceMaps=this._sourceCode.sourceMaps;if(!sourceMaps.length)
return;for(var i=0;i<sourceMaps.length;++i){var sourceMap=sourceMaps[i];var entry=sourceMap.findEntry(this._lineNumber,this._columnNumber);if(!entry||entry.length===2)
continue;var url=entry[2];var sourceMapResource=sourceMap.resourceForURL(url);if(!sourceMapResource)
return;this._mappedResource=sourceMapResource;this._mappedLineNumber=entry[3];this._mappedColumnNumber=entry[4];return;}} 
_locationString(sourceCode,lineNumber,columnNumber,columnStyle,nameStyle,prefix)
{if(!sourceCode)
return"";columnStyle=columnStyle||WebInspector.SourceCodeLocation.ColumnStyle.OnlyIfLarge;nameStyle=nameStyle||WebInspector.SourceCodeLocation.NameStyle.Short;prefix=prefix||"";let lineString=lineNumber+1;if(columnStyle===WebInspector.SourceCodeLocation.ColumnStyle.Shown&&columnNumber>0)
lineString+=":"+(columnNumber+1);else if(columnStyle===WebInspector.SourceCodeLocation.ColumnStyle.OnlyIfLarge&&columnNumber>WebInspector.SourceCodeLocation.LargeColumnNumber)
lineString+=":"+(columnNumber+1);else if(columnStyle===WebInspector.SourceCodeLocation.ColumnStyle.Hidden)
lineString="";switch(nameStyle){case WebInspector.SourceCodeLocation.NameStyle.None:return prefix+lineString;case WebInspector.SourceCodeLocation.NameStyle.Short:case WebInspector.SourceCodeLocation.NameStyle.Full:var displayURL=sourceCode.displayURL;var name=nameStyle===WebInspector.SourceCodeLocation.NameStyle.Full&&displayURL?displayURL:sourceCode.displayName;if(columnStyle===WebInspector.SourceCodeLocation.ColumnStyle.Hidden)
return prefix+name;var lineSuffix=displayURL?":"+lineString:WebInspector.UIString(" (line %s)").format(lineString);return prefix+name+lineSuffix;default:console.error("Unknown nameStyle: "+nameStyle);return prefix+lineString;}}
_resetMappedLocation()
{this._mappedLocationIsResolved=false;this._mappedResource=null;this._mappedLineNumber=NaN;this._mappedColumnNumber=NaN;}
_setMappedLocation(mappedResource,mappedLineNumber,mappedColumnNumber)
{this._mappedLocationIsResolved=true;this._mappedResource=mappedResource;this._mappedLineNumber=mappedLineNumber;this._mappedColumnNumber=mappedColumnNumber;}
_resolveFormattedLocation()
{if(this._sourceCode&&this._sourceCode.formatterSourceMap){var formattedLocation=this._sourceCode.formatterSourceMap.originalToFormatted(this._lineNumber,this._columnNumber);this._formattedLineNumber=formattedLocation.lineNumber;this._formattedColumnNumber=formattedLocation.columnNumber;}else{this._formattedLineNumber=this._lineNumber;this._formattedColumnNumber=this._columnNumber;}}
_makeChangeAndDispatchChangeEventIfNeeded(changeFunction)
{var oldSourceCode=this._sourceCode;var oldLineNumber=this._lineNumber;var oldColumnNumber=this._columnNumber;var oldFormattedLineNumber=this._formattedLineNumber;var oldFormattedColumnNumber=this._formattedColumnNumber;var oldDisplaySourceCode=this.displaySourceCode;var oldDisplayLineNumber=this.displayLineNumber;var oldDisplayColumnNumber=this.displayColumnNumber;this._resetMappedLocation();if(changeFunction)
changeFunction.call(this);this.resolveMappedLocation();this._resolveFormattedLocation();var displayLocationChanged=false;var newDisplaySourceCode=this.displaySourceCode;if(oldDisplaySourceCode!==newDisplaySourceCode)
displayLocationChanged=true;else if(newDisplaySourceCode&&(oldDisplayLineNumber!==this.displayLineNumber||oldDisplayColumnNumber!==this.displayColumnNumber))
displayLocationChanged=true;var anyLocationChanged=false;if(displayLocationChanged)
anyLocationChanged=true;else if(oldSourceCode!==this._sourceCode)
anyLocationChanged=true;else if(this._sourceCode&&(oldLineNumber!==this._lineNumber||oldColumnNumber!==this._columnNumber))
anyLocationChanged=true;else if(this._sourceCode&&(oldFormattedLineNumber!==this._formattedLineNumber||oldFormattedColumnNumber!==this._formattedColumnNumber))
anyLocationChanged=true;if(displayLocationChanged||anyLocationChanged){var oldData={oldSourceCode,oldLineNumber,oldColumnNumber,oldFormattedLineNumber,oldFormattedColumnNumber,oldDisplaySourceCode,oldDisplayLineNumber,oldDisplayColumnNumber};if(displayLocationChanged)
this.dispatchEventToListeners(WebInspector.SourceCodeLocation.Event.DisplayLocationChanged,oldData);if(anyLocationChanged)
this.dispatchEventToListeners(WebInspector.SourceCodeLocation.Event.LocationChanged,oldData);}}
_sourceCodeSourceMapAdded()
{this._makeChangeAndDispatchChangeEventIfNeeded(null);}
_sourceCodeFormatterDidChange()
{this._makeChangeAndDispatchChangeEventIfNeeded(null);}};WebInspector.SourceCodeLocation.DisplayLocationClassName="display-location";WebInspector.SourceCodeLocation.LargeColumnNumber=80;WebInspector.SourceCodeLocation.NameStyle={None:"none",Short:"short",Full:"full"};WebInspector.SourceCodeLocation.ColumnStyle={Hidden:"hidden",OnlyIfLarge:"only-if-large",Shown:"shown"};WebInspector.SourceCodeLocation.Event={LocationChanged:"source-code-location-location-changed",DisplayLocationChanged:"source-code-location-display-location-changed"};WebInspector.Timeline=class Timeline extends WebInspector.Object
{constructor(type)
{super();this._type=type;this.reset(true);} 
static create(type)
{if(type===WebInspector.TimelineRecord.Type.Network)
return new WebInspector.NetworkTimeline(type);if(type===WebInspector.TimelineRecord.Type.Memory)
return new WebInspector.MemoryTimeline(type);return new WebInspector.Timeline(type);} 
get type(){return this._type;}
get startTime(){return this._startTime;}
get endTime(){return this._endTime;}
get records(){return this._records;}
reset(suppressEvents)
{this._records=[];this._startTime=NaN;this._endTime=NaN;if(!suppressEvents){this.dispatchEventToListeners(WebInspector.Timeline.Event.TimesUpdated);this.dispatchEventToListeners(WebInspector.Timeline.Event.Reset);}}
addRecord(record)
{if(record.updatesDynamically)
record.addEventListener(WebInspector.TimelineRecord.Event.Updated,this._recordUpdated,this);



this._tryInsertingRecordInSortedOrder(record);this._updateTimesIfNeeded(record);this.dispatchEventToListeners(WebInspector.Timeline.Event.RecordAdded,{record});}
saveIdentityToCookie(cookie)
{cookie[WebInspector.Timeline.TimelineTypeCookieKey]=this._type;}
refresh()
{this.dispatchEventToListeners(WebInspector.Timeline.Event.Refreshed);}
recordsInTimeRange(startTime,endTime,includeRecordBeforeStart)
{let lowerIndex=this._records.lowerBound(startTime,(time,record)=>time-record.timestamp);let upperIndex=this._records.upperBound(endTime,(time,record)=>time-record.timestamp);if(includeRecordBeforeStart&&lowerIndex>0)
lowerIndex--;return this._records.slice(lowerIndex,upperIndex);} 
_updateTimesIfNeeded(record)
{var changed=false;if(isNaN(this._startTime)||record.startTime<this._startTime){this._startTime=record.startTime;changed=true;}
if(isNaN(this._endTime)||this._endTime<record.endTime){this._endTime=record.endTime;changed=true;}
if(changed)
this.dispatchEventToListeners(WebInspector.Timeline.Event.TimesUpdated);}
_recordUpdated(event)
{this._updateTimesIfNeeded(event.target);}
_tryInsertingRecordInSortedOrder(record)
{let lastValue=this._records.lastValue;if(!lastValue||lastValue.startTime<record.startTime||record.updatesDynamically){this._records.push(record);return;}
let start=this._records.length-2;let end=Math.max(this._records.length-20,0);for(let i=start;i>=end;--i){if(this._records[i].startTime<record.startTime){this._records.insertAtIndex(record,i+1);return;}}
this._records.push(record);}};WebInspector.Timeline.Event={Reset:"timeline-reset",RecordAdded:"timeline-record-added",TimesUpdated:"timeline-times-updated",Refreshed:"timeline-refreshed",};WebInspector.Timeline.TimelineTypeCookieKey="timeline-type";WebInspector.TimelineRange=class TimelineRange extends WebInspector.Object
{constructor(startValue,endValue)
{super();this._startValue=startValue;this._endValue=endValue;}
get startValue(){return this._startValue;}
set startValue(x){this._startValue=x;}
get endValue(){return this._endValue;}
set endValue(x){this._endValue=x;}};WebInspector.TimelineRecord=class TimelineRecord extends WebInspector.Object
{constructor(type,startTime,endTime,callFrames,sourceCodeLocation)
{super();if(type in WebInspector.TimelineRecord.Type)
type=WebInspector.TimelineRecord.Type[type];this._type=type;this._startTime=startTime||NaN;this._endTime=endTime||NaN;this._callFrames=callFrames||null;this._sourceCodeLocation=sourceCodeLocation||null;this._children=[];} 
get type()
{return this._type;}
get startTime()
{return this._startTime;}
get activeStartTime()
{return this._startTime;}
get endTime()
{return this._endTime;}
get duration()
{return this.endTime-this.startTime;}
get inactiveDuration()
{return this.activeStartTime-this.startTime;}
get activeDuration()
{return this.endTime-this.activeStartTime;}
get updatesDynamically()
{return false;}
get usesActiveStartTime()
{return false;}
get callFrames()
{return this._callFrames;}
get initiatorCallFrame()
{if(!this._callFrames||!this._callFrames.length)
return null;for(var i=0;i<this._callFrames.length;++i){if(this._callFrames[i].nativeCode)
continue;return this._callFrames[i];}
return null;}
get sourceCodeLocation()
{return this._sourceCodeLocation;}
get parent()
{return this._parent;}
set parent(x)
{if(this._parent===x)
return;this._parent=x;}
get children()
{return this._children;}
saveIdentityToCookie(cookie)
{cookie[WebInspector.TimelineRecord.SourceCodeURLCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.sourceCode.url?this._sourceCodeLocation.sourceCode.url.hash:null:null;cookie[WebInspector.TimelineRecord.SourceCodeLocationLineCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.lineNumber:null;cookie[WebInspector.TimelineRecord.SourceCodeLocationColumnCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.columnNumber:null;cookie[WebInspector.TimelineRecord.TypeCookieKey]=this._type||null;}};WebInspector.TimelineRecord.Event={Updated:"timeline-record-updated"};WebInspector.TimelineRecord.Type={Network:"timeline-record-type-network",Layout:"timeline-record-type-layout",Script:"timeline-record-type-script",RenderingFrame:"timeline-record-type-rendering-frame",Memory:"timeline-record-type-memory",HeapAllocations:"timeline-record-type-heap-allocations",};WebInspector.TimelineRecord.TypeIdentifier="timeline-record";WebInspector.TimelineRecord.SourceCodeURLCookieKey="timeline-record-source-code-url";WebInspector.TimelineRecord.SourceCodeLocationLineCookieKey="timeline-record-source-code-location-line";WebInspector.TimelineRecord.SourceCodeLocationColumnCookieKey="timeline-record-source-code-location-column";WebInspector.TimelineRecord.TypeCookieKey="timeline-record-type";WebInspector.AnalyzerMessage=class AnalyzerMessage extends WebInspector.Object
{constructor(sourceCodeLocation,text,ruleIdentifier)
{super();this._sourceCodeLocation=sourceCodeLocation;this._text=text;this._ruleIdentifier=ruleIdentifier;} 
get sourceCodeLocation(){return this._sourceCodeLocation;}
get sourceCode(){return this._sourceCodeLocation.sourceCode;}
get text(){return this._text;}
get ruleIdentifier(){return this._ruleIdentifier;}};WebInspector.ApplicationCacheFrame=class ApplicationCacheFrame extends WebInspector.Object
{constructor(frame,manifest,status)
{super();this._frame=frame;this._manifest=manifest;this._status=status;} 
get frame(){return this._frame;}
get manifest(){return this._manifest;}
get status(){return this._status;}
set status(status){this._status=status;}
saveIdentityToCookie(cookie)
{cookie[WebInspector.ApplicationCacheFrame.FrameURLCookieKey]=this.frame.url;cookie[WebInspector.ApplicationCacheFrame.ManifestURLCookieKey]=this.manifest.manifestURL;}};WebInspector.ApplicationCacheFrame.TypeIdentifier="application-cache-frame";WebInspector.ApplicationCacheFrame.FrameURLCookieKey="application-cache-frame-url";WebInspector.ApplicationCacheFrame.ManifestURLCookieKey="application-cache-frame-manifest-url";WebInspector.ApplicationCacheManifest=class ApplicationCacheManifest extends WebInspector.Object
{constructor(manifestURL)
{super();this._manifestURL=manifestURL;} 
get manifestURL(){return this._manifestURL;}};WebInspector.BackForwardEntry=class BackForwardEntry extends WebInspector.Object
{constructor(contentView,cookie)
{super();this._contentView=contentView;
this._tombstone=false;this._cookie=cookie||{};this._scrollPositions=[];contentView.saveToCookie(this._cookie);} 
makeCopy(newCookie)
{let copy=new WebInspector.BackForwardEntry(this._contentView,newCookie||this.cookie);copy._tombstone=this._tombstone;copy._scrollPositions=this._scrollPositions.slice();return copy;}
get contentView()
{return this._contentView;}
get cookie()
{return Object.shallowCopy(this._cookie);}
get tombstone()
{return this._tombstone;}
set tombstone(tombstone)
{this._tombstone=tombstone;}
prepareToShow(shouldCallShown)
{this._restoreFromCookie();this.contentView.visible=true;if(shouldCallShown)
this.contentView.shown();this.contentView.needsLayout();}
prepareToHide()
{this.contentView.visible=false;this.contentView.hidden();this._saveScrollPositions();}
isEqual(other)
{if(!other)
return false;return this._contentView===other._contentView&&Object.shallowEqual(this._cookie,other._cookie);} 
_restoreFromCookie()
{this._restoreScrollPositions();this.contentView.restoreFromCookie(this.cookie);}
_restoreScrollPositions()
{if(!this._scrollPositions.length)
return;var scrollableElements=this.contentView.scrollableElements||[];for(var i=0;i<scrollableElements.length;++i){var position=this._scrollPositions[i];var element=scrollableElements[i];if(!element)
continue;element.scrollTop=position.isScrolledToBottom?element.scrollHeight:position.scrollTop;
element.scrollLeft=position.isScrolledToBottom?0:position.scrollLeft;}}
_saveScrollPositions()
{var scrollableElements=this.contentView.scrollableElements||[];var scrollPositions=[];for(var i=0;i<scrollableElements.length;++i){var element=scrollableElements[i];if(!element)
continue;let position={scrollTop:element.scrollTop,scrollLeft:element.scrollLeft};if(this.contentView.shouldKeepElementsScrolledToBottom)
position.isScrolledToBottom=element.isScrolledToBottom();scrollPositions.push(position);}
this._scrollPositions=scrollPositions;}};WebInspector.Branch=class Branch extends WebInspector.Object
{constructor(displayName,revisions,locked)
{super();this._displayName=displayName;this._revisions=revisions instanceof Array?revisions.slice():[];this._locked=locked||false;} 
get displayName()
{return this._displayName;}
set displayName(displayName)
{if(!displayName)
return;this._displayName=displayName;}
get revisions()
{return this._revisions;}
get locked()
{return this._locked;}
revisionForRepresentedObject(representedObject,doNotCreateIfNeeded)
{for(var i=0;i<this._revisions.length;++i){var revision=this._revisions[i];if(revision instanceof WebInspector.SourceCodeRevision&&revision.sourceCode===representedObject)
return revision;}
if(doNotCreateIfNeeded)
return null;if(representedObject instanceof WebInspector.SourceCode){var revision=representedObject.originalRevision.copy();representedObject.currentRevision=revision;this.addRevision(revision);return revision;}
return null;}
addRevision(revision)
{if(this._locked)
return;if(this._revisions.includes(revision))
return;this._revisions.push(revision);}
removeRevision(revision)
{if(this._locked)
return;this._revisions.remove(revision);}
reset()
{if(this._locked)
return;this._revisions=[];}
fork(displayName)
{var copiedRevisions=this._revisions.map(function(revision){return revision.copy();});return new WebInspector.Branch(displayName,copiedRevisions);}
apply()
{for(var i=0;i<this._revisions.length;++i)
this._revisions[i].apply();}
revert()
{for(var i=this._revisions.length-1;i>=0;--i)
this._revisions[i].revert();}
lock()
{this._locked=true;}
unlock()
{this._locked=false;}};WebInspector.Breakpoint=class Breakpoint extends WebInspector.Object
{constructor(sourceCodeLocationOrInfo,disabled,condition)
{super();if(sourceCodeLocationOrInfo instanceof WebInspector.SourceCodeLocation){var sourceCode=sourceCodeLocationOrInfo.sourceCode;var contentIdentifier=sourceCode?sourceCode.contentIdentifier:null;var scriptIdentifier=sourceCode instanceof WebInspector.Script?sourceCode.id:null;var target=sourceCode instanceof WebInspector.Script?sourceCode.target:null;var location=sourceCodeLocationOrInfo;}else if(sourceCodeLocationOrInfo&&typeof sourceCodeLocationOrInfo==="object"){var contentIdentifier=sourceCodeLocationOrInfo.contentIdentifier||sourceCodeLocationOrInfo.url;var lineNumber=sourceCodeLocationOrInfo.lineNumber||0;var columnNumber=sourceCodeLocationOrInfo.columnNumber||0;var location=new WebInspector.SourceCodeLocation(null,lineNumber,columnNumber);var ignoreCount=sourceCodeLocationOrInfo.ignoreCount||0;var autoContinue=sourceCodeLocationOrInfo.autoContinue||false;var actions=sourceCodeLocationOrInfo.actions||[];for(var i=0;i<actions.length;++i)
actions[i]=new WebInspector.BreakpointAction(this,actions[i]);disabled=sourceCodeLocationOrInfo.disabled;condition=sourceCodeLocationOrInfo.condition;}else
console.error("Unexpected type passed to WebInspector.Breakpoint",sourceCodeLocationOrInfo);this._id=null;this._contentIdentifier=contentIdentifier||null;this._scriptIdentifier=scriptIdentifier||null;this._target=target||null;this._disabled=disabled||false;this._condition=condition||"";this._ignoreCount=ignoreCount||0;this._autoContinue=autoContinue||false;this._actions=actions||[];this._resolved=false;this._sourceCodeLocation=location;this._sourceCodeLocation.addEventListener(WebInspector.SourceCodeLocation.Event.LocationChanged,this._sourceCodeLocationLocationChanged,this);this._sourceCodeLocation.addEventListener(WebInspector.SourceCodeLocation.Event.DisplayLocationChanged,this._sourceCodeLocationDisplayLocationChanged,this);} 
get identifier()
{return this._id;}
set identifier(id)
{this._id=id||null;}
get contentIdentifier()
{return this._contentIdentifier;}
get scriptIdentifier()
{return this._scriptIdentifier;}
get target()
{return this._target;}
get sourceCodeLocation()
{return this._sourceCodeLocation;}
get resolved()
{return this._resolved;}
set resolved(resolved)
{if(this._resolved===resolved)
return;function isSpecialBreakpoint()
{return this._sourceCodeLocation.isEqual(new WebInspector.SourceCodeLocation(null,Infinity,Infinity));}
this._resolved=resolved||false;this.dispatchEventToListeners(WebInspector.Breakpoint.Event.ResolvedStateDidChange);}
get disabled()
{return this._disabled;}
set disabled(disabled)
{if(this._disabled===disabled)
return;this._disabled=disabled||false;this.dispatchEventToListeners(WebInspector.Breakpoint.Event.DisabledStateDidChange);}
get condition()
{return this._condition;}
set condition(condition)
{if(this._condition===condition)
return;this._condition=condition;this.dispatchEventToListeners(WebInspector.Breakpoint.Event.ConditionDidChange);}
get ignoreCount()
{return this._ignoreCount;}
set ignoreCount(ignoreCount)
{if(ignoreCount<0)
return;if(this._ignoreCount===ignoreCount)
return;this._ignoreCount=ignoreCount;this.dispatchEventToListeners(WebInspector.Breakpoint.Event.IgnoreCountDidChange);}
get autoContinue()
{return this._autoContinue;}
set autoContinue(cont)
{if(this._autoContinue===cont)
return;this._autoContinue=cont;this.dispatchEventToListeners(WebInspector.Breakpoint.Event.AutoContinueDidChange);}
get actions()
{return this._actions;}
get options()
{return{condition:this._condition,ignoreCount:this._ignoreCount,actions:this._serializableActions(),autoContinue:this._autoContinue};}
get info()
{return{contentIdentifier:this._contentIdentifier,lineNumber:this._sourceCodeLocation.lineNumber,columnNumber:this._sourceCodeLocation.columnNumber,disabled:this._disabled,condition:this._condition,ignoreCount:this._ignoreCount,actions:this._serializableActions(),autoContinue:this._autoContinue};}
get probeActions()
{return this._actions.filter(function(action){return action.type===WebInspector.BreakpointAction.Type.Probe;});}
cycleToNextMode()
{if(this.disabled){this.autoContinue=false;this.disabled=false;return;}
if(this.autoContinue){this.disabled=true;return;}
if(this.actions.length){this.autoContinue=true;return;}
this.disabled=true;}
createAction(type,precedingAction,data)
{var newAction=new WebInspector.BreakpointAction(this,type,data||null);if(!precedingAction)
this._actions.push(newAction);else{var index=this._actions.indexOf(precedingAction);if(index===-1)
this._actions.push(newAction);else
this._actions.splice(index+1,0,newAction);}
this.dispatchEventToListeners(WebInspector.Breakpoint.Event.ActionsDidChange);return newAction;}
recreateAction(type,actionToReplace)
{var newAction=new WebInspector.BreakpointAction(this,type,null);var index=this._actions.indexOf(actionToReplace);if(index===-1)
return null;this._actions[index]=newAction;this.dispatchEventToListeners(WebInspector.Breakpoint.Event.ActionsDidChange);return newAction;}
removeAction(action)
{var index=this._actions.indexOf(action);if(index===-1)
return;this._actions.splice(index,1);if(!this._actions.length)
this.autoContinue=false;this.dispatchEventToListeners(WebInspector.Breakpoint.Event.ActionsDidChange);}
clearActions(type)
{if(!type)
this._actions=[];else
this._actions=this._actions.filter(function(action){return action.type!==type;});this.dispatchEventToListeners(WebInspector.Breakpoint.Event.ActionsDidChange);}
saveIdentityToCookie(cookie)
{cookie[WebInspector.Breakpoint.ContentIdentifierCookieKey]=this.contentIdentifier;cookie[WebInspector.Breakpoint.LineNumberCookieKey]=this.sourceCodeLocation.lineNumber;cookie[WebInspector.Breakpoint.ColumnNumberCookieKey]=this.sourceCodeLocation.columnNumber;}
breakpointActionDidChange(action)
{var index=this._actions.indexOf(action);if(index===-1)
return;this.dispatchEventToListeners(WebInspector.Breakpoint.Event.ActionsDidChange);} 
_serializableActions()
{var actions=[];for(var i=0;i<this._actions.length;++i)
actions.push(this._actions[i].info);return actions;}
_sourceCodeLocationLocationChanged(event)
{this.dispatchEventToListeners(WebInspector.Breakpoint.Event.LocationDidChange,event.data);}
_sourceCodeLocationDisplayLocationChanged(event)
{this.dispatchEventToListeners(WebInspector.Breakpoint.Event.DisplayLocationDidChange,event.data);}};WebInspector.Breakpoint.DefaultBreakpointActionType=WebInspector.BreakpointAction.Type.Log;WebInspector.Breakpoint.TypeIdentifier="breakpoint";WebInspector.Breakpoint.ContentIdentifierCookieKey="breakpoint-content-identifier";WebInspector.Breakpoint.LineNumberCookieKey="breakpoint-line-number";WebInspector.Breakpoint.ColumnNumberCookieKey="breakpoint-column-number";WebInspector.Breakpoint.Event={DisabledStateDidChange:"breakpoint-disabled-state-did-change",ResolvedStateDidChange:"breakpoint-resolved-state-did-change",ConditionDidChange:"breakpoint-condition-did-change",IgnoreCountDidChange:"breakpoint-ignore-count-did-change",ActionsDidChange:"breakpoint-actions-did-change",AutoContinueDidChange:"breakpoint-auto-continue-did-change",LocationDidChange:"breakpoint-location-did-change",DisplayLocationDidChange:"breakpoint-display-location-did-change",};WebInspector.CallingContextTree=class CallingContextTree extends WebInspector.Object
{constructor(type)
{super();this._type=type||WebInspector.CallingContextTree.Type.TopDown;this.reset();} 
get type(){return this._type;}
get totalNumberOfSamples(){return this._totalNumberOfSamples;}
reset()
{this._root=new WebInspector.CallingContextTreeNode(-1,-1,-1,"<root>",null);this._totalNumberOfSamples=0;}
totalDurationInTimeRange(startTime,endTime)
{return this._root.filteredTimestampsAndDuration(startTime,endTime).duration;}
updateTreeWithStackTrace({timestamp,stackFrames},duration)
{this._totalNumberOfSamples++;let node=this._root;node.addTimestampAndExpressionLocation(timestamp,duration,null);switch(this._type){case WebInspector.CallingContextTree.Type.TopDown:for(let i=stackFrames.length;i--;){let stackFrame=stackFrames[i];node=node.findOrMakeChild(stackFrame);node.addTimestampAndExpressionLocation(timestamp,duration,stackFrame.expressionLocation||null,i===0);}
break;case WebInspector.CallingContextTree.Type.BottomUp:for(let i=0;i<stackFrames.length;++i){let stackFrame=stackFrames[i];node=node.findOrMakeChild(stackFrame);node.addTimestampAndExpressionLocation(timestamp,duration,stackFrame.expressionLocation||null,i===0);}
break;case WebInspector.CallingContextTree.Type.TopFunctionsTopDown:for(let i=stackFrames.length;i--;){node=this._root;for(let j=i+1;j--;){let stackFrame=stackFrames[j];node=node.findOrMakeChild(stackFrame);node.addTimestampAndExpressionLocation(timestamp,duration,stackFrame.expressionLocation||null,j===0);}}
break;case WebInspector.CallingContextTree.Type.TopFunctionsBottomUp:for(let i=0;i<stackFrames.length;i++){node=this._root;for(let j=i;j<stackFrames.length;j++){let stackFrame=stackFrames[j];node=node.findOrMakeChild(stackFrame);node.addTimestampAndExpressionLocation(timestamp,duration,stackFrame.expressionLocation||null,j===0);}}
break;default:break;}}
toCPUProfilePayload(startTime,endTime)
{let cpuProfile={};let roots=[];let numSamplesInTimeRange=this._root.filteredTimestampsAndDuration(startTime,endTime).timestamps.length;this._root.forEachChild((child)=>{if(child.hasStackTraceInTimeRange(startTime,endTime))
roots.push(child.toCPUProfileNode(numSamplesInTimeRange,startTime,endTime));});cpuProfile.rootNodes=roots;return cpuProfile;}
forEachChild(callback)
{this._root.forEachChild(callback);}
forEachNode(callback)
{this._root.forEachNode(callback);}
static __test_makeTreeFromProtocolMessageObject(messageObject)
{let tree=new WebInspector.CallingContextTree;let stackTraces=messageObject.params.samples.stackTraces;for(let i=0;i<stackTraces.length;i++)
tree.updateTreeWithStackTrace(stackTraces[i]);return tree;}
__test_matchesStackTrace(stackTrace)
{



let leaves=this.__test_buildLeafLinkedLists();outer:for(let node of leaves){for(let stackNode of stackTrace){for(let propertyName of Object.getOwnPropertyNames(stackNode)){if(stackNode[propertyName]!==node[propertyName])
continue outer;}
node=node.parent;}
return true;}
return false;}
__test_buildLeafLinkedLists()
{let result=[];let parent=null;this._root.__test_buildLeafLinkedLists(parent,result);return result;}};WebInspector.CallingContextTree.Type={TopDown:Symbol("TopDown"),BottomUp:Symbol("BottomUp"),TopFunctionsTopDown:Symbol("TopFunctionsTopDown"),TopFunctionsBottomUp:Symbol("TopFunctionsBottomUp"),};WebInspector.CallingContextTreeNode=class CallingContextTreeNode extends WebInspector.Object
{constructor(sourceID,line,column,name,url,hash)
{super();this._children={};this._sourceID=sourceID;this._line=line;this._column=column;this._name=name;this._url=url;this._uid=WebInspector.CallingContextTreeNode.__uid++;this._timestamps=[];this._durations=[];this._leafTimestamps=[];this._leafDurations=[];this._expressionLocations={};this._hash=hash||WebInspector.CallingContextTreeNode._hash(this);} 
static _hash(stackFrame)
{return stackFrame.name+":"+stackFrame.sourceID+":"+stackFrame.line+":"+stackFrame.column;} 
get sourceID(){return this._sourceID;}
get line(){return this._line;}
get column(){return this._column;}
get name(){return this._name;}
get uid(){return this._uid;}
get url(){return this._url;}
get hash(){return this._hash;}
hasChildrenInTimeRange(startTime,endTime)
{for(let propertyName of Object.getOwnPropertyNames(this._children)){let child=this._children[propertyName];if(child.hasStackTraceInTimeRange(startTime,endTime))
return true;}
return false;}
hasStackTraceInTimeRange(startTime,endTime)
{if(startTime>endTime)
return false;let timestamps=this._timestamps;let length=timestamps.length;if(!length)
return false;let index=timestamps.lowerBound(startTime);if(index===length)
return false;let hasTimestampInRange=timestamps[index]<=endTime;return hasTimestampInRange;}
filteredTimestampsAndDuration(startTime,endTime)
{let lowerIndex=this._timestamps.lowerBound(startTime);let upperIndex=this._timestamps.upperBound(endTime);let totalDuration=0;for(let i=lowerIndex;i<upperIndex;++i)
totalDuration+=this._durations[i];return{timestamps:this._timestamps.slice(lowerIndex,upperIndex),duration:totalDuration,};}
filteredLeafTimestampsAndDuration(startTime,endTime)
{let lowerIndex=this._leafTimestamps.lowerBound(startTime);let upperIndex=this._leafTimestamps.upperBound(endTime);let totalDuration=0;for(let i=lowerIndex;i<upperIndex;++i)
totalDuration+=this._leafDurations[i];return{leafTimestamps:this._leafTimestamps.slice(lowerIndex,upperIndex),leafDuration:totalDuration,};}
hasChildren()
{return!isEmptyObject(this._children);}
findOrMakeChild(stackFrame)
{let hash=WebInspector.CallingContextTreeNode._hash(stackFrame);let node=this._children[hash];if(node)
return node;node=new WebInspector.CallingContextTreeNode(stackFrame.sourceID,stackFrame.line,stackFrame.column,stackFrame.name,stackFrame.url,hash);this._children[hash]=node;return node;}
addTimestampAndExpressionLocation(timestamp,duration,expressionLocation,leaf)
{this._timestamps.push(timestamp);this._durations.push(duration);if(leaf){this._leafTimestamps.push(timestamp);this._leafDurations.push(duration);}
if(!expressionLocation)
return;let{line,column}=expressionLocation;let hashCons=line+":"+column;let timestamps=this._expressionLocations[hashCons];if(!timestamps){timestamps=[];this._expressionLocations[hashCons]=timestamps;}
timestamps.push(timestamp);}
forEachChild(callback)
{for(let propertyName of Object.getOwnPropertyNames(this._children))
callback(this._children[propertyName]);}
forEachNode(callback)
{callback(this);this.forEachChild(function(child){child.forEachNode(callback);});}
equals(other)
{return this._hash===other.hash;}
toCPUProfileNode(numSamples,startTime,endTime)
{let children=[];this.forEachChild((child)=>{if(child.hasStackTraceInTimeRange(startTime,endTime))
children.push(child.toCPUProfileNode(numSamples,startTime,endTime));});let cpuProfileNode={id:this._uid,functionName:this._name,url:this._url,lineNumber:this._line,columnNumber:this._column,children:children};let timestamps=[];let frameStartTime=Number.MAX_VALUE;let frameEndTime=Number.MIN_VALUE;for(let i=0;i<this._timestamps.length;i++){let timestamp=this._timestamps[i];if(startTime<=timestamp&&timestamp<=endTime){timestamps.push(timestamp);frameStartTime=Math.min(frameStartTime,timestamp);frameEndTime=Math.max(frameEndTime,timestamp);}}
cpuProfileNode.callInfo={callCount:timestamps.length,startTime:frameStartTime,endTime:frameEndTime,totalTime:(timestamps.length/numSamples)*(endTime-startTime)};return cpuProfileNode;}
__test_buildLeafLinkedLists(parent,result)
{let linkedListNode={name:this._name,url:this._url,parent:parent};if(this.hasChildren()){this.forEachChild((child)=>{child.__test_buildLeafLinkedLists(linkedListNode,result);});}else{result.push(linkedListNode);}}};WebInspector.CallingContextTreeNode.__uid=0;WebInspector.CSSCompletions=class CSSCompletions
{constructor(properties,acceptEmptyPrefix)
{this._values=[];this._longhands={};this._shorthands={};if(properties.length&&typeof properties[0]==="string")
this._values=this._values.concat(properties);else{for(var property of properties){var propertyName=property.name;this._values.push(propertyName);var longhands=property.longhands;if(longhands){this._longhands[propertyName]=longhands;for(var j=0;j<longhands.length;++j){var longhandName=longhands[j];var shorthands=this._shorthands[longhandName];if(!shorthands){shorthands=[];this._shorthands[longhandName]=shorthands;}
shorthands.push(propertyName);}}}}
this._values.sort();this._acceptEmptyPrefix=acceptEmptyPrefix;} 
static requestCSSCompletions()
{if(WebInspector.CSSCompletions.cssNameCompletions)
return;function propertyNamesCallback(error,names)
{if(error)
return;WebInspector.CSSCompletions.cssNameCompletions=new WebInspector.CSSCompletions(names,false);WebInspector.CSSKeywordCompletions.addCustomCompletions(names);if(!window.CodeMirror)
return;var propertyNamesForCodeMirror={};var valueKeywordsForCodeMirror={"inherit":true,"initial":true,"unset":true,"revert":true,"var":true};var colorKeywordsForCodeMirror={};function nameForCodeMirror(name)
{return name.replace(/^-[^-]+-/,"").replace(/\(\)$/,"").toLowerCase();}
function collectPropertyNameForCodeMirror(propertyName)
{var codeMirrorPropertyName=nameForCodeMirror(propertyName);propertyNamesForCodeMirror[codeMirrorPropertyName]=true;valueKeywordsForCodeMirror[codeMirrorPropertyName]=true;}
for(var property of names)
collectPropertyNameForCodeMirror(property.name);for(var propertyName in WebInspector.CSSKeywordCompletions._propertyKeywordMap){var keywords=WebInspector.CSSKeywordCompletions._propertyKeywordMap[propertyName];for(var i=0;i<keywords.length;++i){if(!isNaN(Number(keywords[i])))
continue;valueKeywordsForCodeMirror[nameForCodeMirror(keywords[i])]=true;}}
WebInspector.CSSKeywordCompletions._colors.forEach(function(colorName){colorKeywordsForCodeMirror[nameForCodeMirror(colorName)]=true;});function updateCodeMirrorCSSMode(mimeType)
{var modeSpec=CodeMirror.resolveMode(mimeType);modeSpec.propertyKeywords=propertyNamesForCodeMirror;modeSpec.valueKeywords=valueKeywordsForCodeMirror;modeSpec.colorKeywords=colorKeywordsForCodeMirror;CodeMirror.defineMIME(mimeType,modeSpec);}
updateCodeMirrorCSSMode("text/css");updateCodeMirrorCSSMode("text/x-scss");}
function fontFamilyNamesCallback(error,fontFamilyNames)
{if(error)
return;WebInspector.CSSKeywordCompletions.addPropertyCompletionValues("font-family",fontFamilyNames);WebInspector.CSSKeywordCompletions.addPropertyCompletionValues("font",fontFamilyNames);}
if(window.CSSAgent){CSSAgent.getSupportedCSSProperties(propertyNamesCallback);if(CSSAgent.getSupportedSystemFontFamilyNames)
CSSAgent.getSupportedSystemFontFamilyNames(fontFamilyNamesCallback);}} 
get values()
{return this._values;}
startsWith(prefix)
{var firstIndex=this._firstIndexOfPrefix(prefix);if(firstIndex===-1)
return[];var results=[];while(firstIndex<this._values.length&&this._values[firstIndex].startsWith(prefix))
results.push(this._values[firstIndex++]);return results;}
_firstIndexOfPrefix(prefix)
{if(!this._values.length)
return-1;if(!prefix)
return this._acceptEmptyPrefix?0:-1;var maxIndex=this._values.length-1;var minIndex=0;var foundIndex;do{var middleIndex=(maxIndex+minIndex)>>1;if(this._values[middleIndex].startsWith(prefix)){foundIndex=middleIndex;break;}
if(this._values[middleIndex]<prefix)
minIndex=middleIndex+1;else
maxIndex=middleIndex-1;}while(minIndex<=maxIndex);if(foundIndex===undefined)
return-1;while(foundIndex&&this._values[foundIndex-1].startsWith(prefix))
foundIndex--;return foundIndex;}
keySet()
{if(!this._keySet)
this._keySet=this._values.keySet();return this._keySet;}
next(str,prefix)
{return this._closest(str,prefix,1);}
previous(str,prefix)
{return this._closest(str,prefix,-1);}
_closest(str,prefix,shift)
{if(!str)
return"";var index=this._values.indexOf(str);if(index===-1)
return"";if(!prefix){index=(index+this._values.length+shift)%this._values.length;return this._values[index];}
var propertiesWithPrefix=this.startsWith(prefix);var j=propertiesWithPrefix.indexOf(str);j=(j+propertiesWithPrefix.length+shift)%propertiesWithPrefix.length;return propertiesWithPrefix[j];}
isShorthandPropertyName(shorthand)
{return shorthand in this._longhands;}
shorthandsForLonghand(longhand)
{return this._shorthands[longhand]||[];}
isValidPropertyName(name)
{return this._values.includes(name);}
propertyRequiresWebkitPrefix(name)
{return this._values.includes("-webkit-"+name)&&!this._values.includes(name);}
getClosestPropertyName(name)
{var bestMatches=[{distance:Infinity,name:null}];for(var property of this._values){var distance=name.levenshteinDistance(property);if(distance<bestMatches[0].distance)
bestMatches=[{distance,name:property}];else if(distance===bestMatches[0].distance)
bestMatches.push({distance,name:property});}
return bestMatches.length<3?bestMatches[0].name:false;}};WebInspector.CSSCompletions.cssNameCompletions=null;WebInspector.CSSKeywordCompletions={};WebInspector.CSSKeywordCompletions.forProperty=function(propertyName)
{let acceptedKeywords=["initial","unset","revert","var()"];let isNotPrefixed=propertyName.charAt(0)!=="-";if(propertyName in WebInspector.CSSKeywordCompletions._propertyKeywordMap)
acceptedKeywords=acceptedKeywords.concat(WebInspector.CSSKeywordCompletions._propertyKeywordMap[propertyName]);else if(isNotPrefixed&&("-webkit-"+propertyName)in WebInspector.CSSKeywordCompletions._propertyKeywordMap)
acceptedKeywords=acceptedKeywords.concat(WebInspector.CSSKeywordCompletions._propertyKeywordMap["-webkit-"+propertyName]);if(propertyName in WebInspector.CSSKeywordCompletions._colorAwareProperties)
acceptedKeywords=acceptedKeywords.concat(WebInspector.CSSKeywordCompletions._colors);else if(isNotPrefixed&&("-webkit-"+propertyName)in WebInspector.CSSKeywordCompletions._colorAwareProperties)
acceptedKeywords=acceptedKeywords.concat(WebInspector.CSSKeywordCompletions._colors);else if(propertyName.endsWith("color"))
acceptedKeywords=acceptedKeywords.concat(WebInspector.CSSKeywordCompletions._colors);if(propertyName in WebInspector.CSSKeywordCompletions.InheritedProperties)
acceptedKeywords.push("inherit");else if(isNotPrefixed&&("-webkit-"+propertyName)in WebInspector.CSSKeywordCompletions.InheritedProperties)
acceptedKeywords.push("inherit");if(acceptedKeywords.includes(WebInspector.CSSKeywordCompletions.AllPropertyNamesPlaceholder)&&WebInspector.CSSCompletions.cssNameCompletions){acceptedKeywords.remove(WebInspector.CSSKeywordCompletions.AllPropertyNamesPlaceholder);acceptedKeywords=acceptedKeywords.concat(WebInspector.CSSCompletions.cssNameCompletions.values);}
return new WebInspector.CSSCompletions(acceptedKeywords,true);};WebInspector.CSSKeywordCompletions.forFunction=function(functionName)
{let suggestions=["var()"];if(functionName==="var")
suggestions=[];else if(functionName=="env")
suggestions=suggestions.concat(["safe-area-inset-top","safe-area-inset-right","safe-area-inset-bottom","safe-area-inset-left"]);else if(functionName==="image-set")
suggestions.push("url()");else if(functionName==="repeat")
suggestions=suggestions.concat(["auto","auto-fill","auto-fit","min-content","max-content"]);else if(functionName.endsWith("gradient")){suggestions=suggestions.concat(["to","left","right","top","bottom"]);suggestions=suggestions.concat(WebInspector.CSSKeywordCompletions._colors);}
return new WebInspector.CSSCompletions(suggestions,true);}
WebInspector.CSSKeywordCompletions.addCustomCompletions=function(properties)
{for(var property of properties){if(property.values)
WebInspector.CSSKeywordCompletions.addPropertyCompletionValues(property.name,property.values);}};WebInspector.CSSKeywordCompletions.addPropertyCompletionValues=function(propertyName,newValues)
{var existingValues=WebInspector.CSSKeywordCompletions._propertyKeywordMap[propertyName];if(!existingValues){WebInspector.CSSKeywordCompletions._propertyKeywordMap[propertyName]=newValues;return;}
var union=new Set;for(var value of existingValues)
union.add(value);for(var value of newValues)
union.add(value);WebInspector.CSSKeywordCompletions._propertyKeywordMap[propertyName]=[...union.values()];};WebInspector.CSSKeywordCompletions.AllPropertyNamesPlaceholder="__all-properties__";WebInspector.CSSKeywordCompletions.InheritedProperties=["azimuth","border-collapse","border-spacing","caption-side","clip-rule","color","color-interpolation","color-interpolation-filters","color-rendering","cursor","direction","elevation","empty-cells","fill","fill-opacity","fill-rule","font","font-family","font-size","font-style","font-variant","font-variant-numeric","font-weight","font-optical-sizing","glyph-orientation-horizontal","glyph-orientation-vertical","hanging-punctuation","image-rendering","kerning","letter-spacing","line-height","list-style","list-style-image","list-style-position","list-style-type","marker","marker-end","marker-mid","marker-start","orphans","pitch","pitch-range","pointer-events","quotes","resize","richness","shape-rendering","speak","speak-header","speak-numeral","speak-punctuation","speech-rate","stress","stroke","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke-width","tab-size","text-align","text-anchor","text-decoration","text-indent","text-rendering","text-shadow","text-transform","visibility","voice-family","volume","white-space","widows","word-break","word-spacing","word-wrap","writing-mode","-webkit-aspect-ratio","-webkit-border-horizontal-spacing","-webkit-border-vertical-spacing","-webkit-box-direction","-webkit-color-correction","font-feature-settings","-webkit-font-kerning","-webkit-font-smoothing","-webkit-font-variant-ligatures","-webkit-hyphenate-character","-webkit-hyphenate-limit-after","-webkit-hyphenate-limit-before","-webkit-hyphenate-limit-lines","-webkit-hyphens","-webkit-line-align","-webkit-line-box-contain","-webkit-line-break","-webkit-line-grid","-webkit-line-snap","-webkit-locale","-webkit-nbsp-mode","-webkit-print-color-adjust","-webkit-rtl-ordering","-webkit-text-combine","-webkit-text-decorations-in-effect","-webkit-text-emphasis","-webkit-text-emphasis-color","-webkit-text-emphasis-position","-webkit-text-emphasis-style","-webkit-text-fill-color","-webkit-text-orientation","-webkit-text-security","-webkit-text-size-adjust","-webkit-text-stroke","-webkit-text-stroke-color","-webkit-text-stroke-width","-webkit-user-modify","-webkit-user-select","-webkit-writing-mode","-webkit-cursor-visibility","image-orientation","image-resolution","overflow-wrap","-webkit-text-align-last","-webkit-text-justify","-webkit-ruby-position","-webkit-text-decoration-line","font-synthesis","-webkit-overflow-scrolling","-webkit-touch-callout","-webkit-tap-highlight-color"].keySet();WebInspector.CSSKeywordCompletions._colors=["aqua","black","blue","fuchsia","gray","green","lime","maroon","navy","olive","orange","purple","red","silver","teal","white","yellow","transparent","currentcolor","grey","aliceblue","antiquewhite","aquamarine","azure","beige","bisque","blanchedalmond","blueviolet","brown","burlywood","cadetblue","chartreuse","chocolate","coral","cornflowerblue","cornsilk","crimson","cyan","darkblue","darkcyan","darkgoldenrod","darkgray","darkgreen","darkgrey","darkkhaki","darkmagenta","darkolivegreen","darkorange","darkorchid","darkred","darksalmon","darkseagreen","darkslateblue","darkslategray","darkslategrey","darkturquoise","darkviolet","deeppink","deepskyblue","dimgray","dimgrey","dodgerblue","firebrick","floralwhite","forestgreen","gainsboro","ghostwhite","gold","goldenrod","greenyellow","honeydew","hotpink","indianred","indigo","ivory","khaki","lavender","lavenderblush","lawngreen","lemonchiffon","lightblue","lightcoral","lightcyan","lightgoldenrodyellow","lightgray","lightgreen","lightgrey","lightpink","lightsalmon","lightseagreen","lightskyblue","lightslategray","lightslategrey","lightsteelblue","lightyellow","limegreen","linen","magenta","mediumaquamarine","mediumblue","mediumorchid","mediumpurple","mediumseagreen","mediumslateblue","mediumspringgreen","mediumturquoise","mediumvioletred","midnightblue","mintcream","mistyrose","moccasin","navajowhite","oldlace","olivedrab","orangered","orchid","palegoldenrod","palegreen","paleturquoise","palevioletred","papayawhip","peachpuff","peru","pink","plum","powderblue","rebeccapurple","rosybrown","royalblue","saddlebrown","salmon","sandybrown","seagreen","seashell","sienna","skyblue","slateblue","slategray","slategrey","snow","springgreen","steelblue","tan","thistle","tomato","turquoise","violet","wheat","whitesmoke","yellowgreen","rgb()","rgba()","hsl()","hsla()"];WebInspector.CSSKeywordCompletions._colorAwareProperties=["background","background-color","background-image","border","border-color","border-top","border-right","border-bottom","border-left","border-top-color","border-right-color","border-bottom-color","border-left-color","box-shadow","color","fill","outline","outline-color","stroke","text-line-through","text-line-through-color","text-overline","text-overline-color","text-shadow","text-underline","text-underline-color","-webkit-box-shadow","-webkit-column-rule","-webkit-column-rule-color","-webkit-text-emphasis","-webkit-text-emphasis-color","-webkit-text-fill-color","-webkit-text-stroke","-webkit-text-stroke-color","-webkit-text-decoration-color","-webkit-tap-highlight-color"].keySet();WebInspector.CSSKeywordCompletions._propertyKeywordMap={"table-layout":["auto","fixed"],"visibility":["hidden","visible","collapse"],"text-underline":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave"],"content":["list-item","close-quote","no-close-quote","no-open-quote","open-quote","attr()","counter()","counters()","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()"],"list-style-image":["none","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()"],"clear":["none","left","right","both"],"fill-rule":["nonzero","evenodd"],"stroke-linecap":["butt","round","square"],"stroke-linejoin":["round","miter","bevel"],"baseline-shift":["baseline","sub","super"],"border-bottom-width":["medium","thick","thin","calc()"],"margin-top-collapse":["collapse","separate","discard"],"-webkit-box-orient":["horizontal","vertical","inline-axis","block-axis"],"font-stretch":["normal","wider","narrower","ultra-condensed","extra-condensed","condensed","semi-condensed","semi-expanded","expanded","extra-expanded","ultra-expanded"],"font-optical-sizing":["auto","none",],"-webkit-color-correction":["default","srgb"],"border-left-width":["medium","thick","thin","calc()"],"-webkit-writing-mode":["lr","rl","tb","lr-tb","rl-tb","tb-rl","horizontal-tb","vertical-rl","vertical-lr","horizontal-bt"],"text-line-through-mode":["continuous","skip-white-space"],"text-overline-mode":["continuous","skip-white-space"],"text-underline-mode":["continuous","skip-white-space"],"text-line-through-style":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave"],"text-overline-style":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave"],"text-underline-style":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave"],"border-collapse":["collapse","separate"],"border-top-width":["medium","thick","thin","calc()"],"outline-color":["invert","-webkit-focus-ring-color"],"outline-style":["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double","auto"],"cursor":["auto","default","none","context-menu","help","pointer","progress","wait","cell","crosshair","text","vertical-text","alias","copy","move","no-drop","not-allowed","grab","grabbing","e-resize","n-resize","ne-resize","nw-resize","s-resize","se-resize","sw-resize","w-resize","ew-resize","ns-resize","nesw-resize","nwse-resize","col-resize","row-resize","all-scroll","zoom-in","zoom-out","-webkit-grab","-webkit-grabbing","-webkit-zoom-in","-webkit-zoom-out","url()","image-set()"],"border-width":["medium","thick","thin","calc()"],"size":["a3","a4","a5","b4","b5","landscape","ledger","legal","letter","portrait"],"background":["none","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()","repeat","repeat-x","repeat-y","no-repeat","space","round","scroll","fixed","local","auto","contain","cover","top","right","left","bottom","center","border-box","padding-box","content-box"],"background-image":["none","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()"],"background-size":["auto","contain","cover"],"background-attachment":["scroll","fixed","local"],"background-repeat":["repeat","repeat-x","repeat-y","no-repeat","space","round"],"background-blend-mode":["normal","multiply","screen","overlay","darken","lighten","color-dodge","color-burn","hard-light","soft-light","difference","exclusion","hue","saturation","color","luminosity"],"background-position":["top","right","left","bottom","center"],"background-origin":["border-box","padding-box","content-box"],"background-clip":["border-box","padding-box","content-box"],"direction":["ltr","rtl"],"enable-background":["accumulate","new"],"float":["none","left","right"],"hanging-punctuation":["none","first","last","allow-end","force-end"],"overflow-x":["hidden","auto","visible","overlay","scroll","marquee"],"overflow-y":["hidden","auto","visible","overlay","scroll","marquee","-webkit-paged-x","-webkit-paged-y"],"overflow":["hidden","auto","visible","overlay","scroll","marquee","-webkit-paged-x","-webkit-paged-y"],"margin-bottom-collapse":["collapse","separate","discard"],"-webkit-box-reflect":["none","left","right","above","below"],"text-rendering":["auto","optimizeSpeed","optimizeLegibility","geometricPrecision"],"text-align":["-webkit-auto","left","right","center","justify","-webkit-left","-webkit-right","-webkit-center","-webkit-match-parent","start","end"],"list-style-position":["outside","inside"],"margin-bottom":["auto"],"color-interpolation":["linearrgb"],"word-wrap":["normal","break-word"],"font-weight":["normal","bold","bolder","lighter","100","200","300","400","500","600","700","800","900"],"font-synthesis":["none","weight","style"],"margin-before-collapse":["collapse","separate","discard"],"text-overline-width":["normal","medium","auto","thick","thin","calc()"],"text-transform":["none","capitalize","uppercase","lowercase"],"border-right-style":["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double"],"border-left-style":["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double"],"font-style":["italic","oblique","normal"],"speak":["none","normal","spell-out","digits","literal-punctuation","no-punctuation"],"text-line-through":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave","continuous","skip-white-space"],"color-rendering":["auto","optimizeSpeed","optimizeQuality"],"list-style-type":["none","disc","circle","square","decimal","decimal-leading-zero","arabic-indic","binary","bengali","cambodian","khmer","devanagari","gujarati","gurmukhi","kannada","lower-hexadecimal","lao","malayalam","mongolian","myanmar","octal","oriya","persian","urdu","telugu","tibetan","thai","upper-hexadecimal","lower-roman","upper-roman","lower-greek","lower-alpha","lower-latin","upper-alpha","upper-latin","afar","ethiopic-halehame-aa-et","ethiopic-halehame-aa-er","amharic","ethiopic-halehame-am-et","amharic-abegede","ethiopic-abegede-am-et","cjk-earthly-branch","cjk-heavenly-stem","ethiopic","ethiopic-halehame-gez","ethiopic-abegede","ethiopic-abegede-gez","hangul-consonant","hangul","lower-norwegian","oromo","ethiopic-halehame-om-et","sidama","ethiopic-halehame-sid-et","somali","ethiopic-halehame-so-et","tigre","ethiopic-halehame-tig","tigrinya-er","ethiopic-halehame-ti-er","tigrinya-er-abegede","ethiopic-abegede-ti-er","tigrinya-et","ethiopic-halehame-ti-et","tigrinya-et-abegede","ethiopic-abegede-ti-et","upper-greek","upper-norwegian","asterisks","footnotes","hebrew","armenian","lower-armenian","upper-armenian","georgian","cjk-ideographic","hiragana","katakana","hiragana-iroha","katakana-iroha"],"-webkit-text-combine":["none","horizontal"],"outline":["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double"],"font":["caption","icon","menu","message-box","small-caption","-webkit-mini-control","-webkit-small-control","-webkit-control","status-bar","italic","oblique","small-caps","normal","bold","bolder","lighter","100","200","300","400","500","600","700","800","900","xx-small","x-small","small","medium","large","x-large","xx-large","-webkit-xxx-large","smaller","larger","serif","sans-serif","cursive","fantasy","monospace","-webkit-body","-webkit-pictograph","-apple-system","-apple-system-headline","-apple-system-body","-apple-system-subheadline","-apple-system-footnote","-apple-system-caption1","-apple-system-caption2","-apple-system-short-headline","-apple-system-short-body","-apple-system-short-subheadline","-apple-system-short-footnote","-apple-system-short-caption1","-apple-system-tall-body","-apple-system-title0","-apple-system-title1","-apple-system-title2","-apple-system-title3","-apple-system-title4","system-ui"],"dominant-baseline":["middle","auto","central","text-before-edge","text-after-edge","ideographic","alphabetic","hanging","mathematical","use-script","no-change","reset-size"],"display":["none","inline","block","list-item","compact","inline-block","table","inline-table","table-row-group","table-header-group","table-footer-group","table-row","table-column-group","table-column","table-cell","table-caption","-webkit-box","-webkit-inline-box","-wap-marquee","flex","inline-flex","grid","inline-grid"],"image-rendering":["auto","optimizeSpeed","optimizeQuality","-webkit-crisp-edges","-webkit-optimize-contrast","crisp-edges","pixelated"],"alignment-baseline":["baseline","middle","auto","before-edge","after-edge","central","text-before-edge","text-after-edge","ideographic","alphabetic","hanging","mathematical"],"outline-width":["medium","thick","thin","calc()"],"text-line-through-width":["normal","medium","auto","thick","thin"],"box-align":["baseline","center","stretch","start","end"],"box-shadow":["none"],"text-shadow":["none"],"-webkit-box-shadow":["none"],"border-right-width":["medium","thick","thin"],"border-top-style":["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double"],"line-height":["normal"],"counter-increment":["none"],"counter-reset":["none"],"text-overflow":["clip","ellipsis"],"-webkit-box-direction":["normal","reverse"],"margin-after-collapse":["collapse","separate","discard"],"break-after":["left","right","recto","verso","auto","avoid","page","column","region","avoid-page","avoid-column","avoid-region"],"break-before":["left","right","recto","verso","auto","avoid","page","column","region","avoid-page","avoid-column","avoid-region"],"break-inside":["auto","avoid","avoid-page","avoid-column","avoid-region"],"page-break-after":["left","right","auto","always","avoid"],"page-break-before":["left","right","auto","always","avoid"],"page-break-inside":["auto","avoid"],"-webkit-column-break-after":["left","right","auto","always","avoid"],"-webkit-column-break-before":["left","right","auto","always","avoid"],"-webkit-column-break-inside":["auto","avoid"],"-webkit-hyphens":["none","auto","manual"],"border-image":["repeat","stretch","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()"],"border-image-repeat":["repeat","stretch","space","round"],"-webkit-mask-box-image-repeat":["repeat","stretch","space","round"],"position":["absolute","fixed","relative","static","-webkit-sticky"],"font-family":["serif","sans-serif","cursive","fantasy","monospace","-webkit-body","-webkit-pictograph","-apple-system","-apple-system-headline","-apple-system-body","-apple-system-subheadline","-apple-system-footnote","-apple-system-caption1","-apple-system-caption2","-apple-system-short-headline","-apple-system-short-body","-apple-system-short-subheadline","-apple-system-short-footnote","-apple-system-short-caption1","-apple-system-tall-body","-apple-system-title0","-apple-system-title1","-apple-system-title2","-apple-system-title3","-apple-system-title4","system-ui"],"text-overflow-mode":["clip","ellipsis"],"border-bottom-style":["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double"],"unicode-bidi":["normal","bidi-override","embed","plaintext","isolate","isolate-override"],"clip-rule":["nonzero","evenodd"],"margin-left":["auto"],"margin-top":["auto"],"zoom":["normal","document","reset"],"z-index":["auto"],"width":["intrinsic","min-intrinsic","-webkit-min-content","-webkit-max-content","-webkit-fill-available","-webkit-fit-content","calc()"],"height":["intrinsic","min-intrinsic","calc()"],"max-width":["none","intrinsic","min-intrinsic","-webkit-min-content","-webkit-max-content","-webkit-fill-available","-webkit-fit-content","calc()"],"min-width":["intrinsic","min-intrinsic","-webkit-min-content","-webkit-max-content","-webkit-fill-available","-webkit-fit-content","calc()"],"max-height":["none","intrinsic","min-intrinsic","calc()"],"min-height":["intrinsic","min-intrinsic","calc()"],"-webkit-logical-width":["intrinsic","min-intrinsic","-webkit-min-content","-webkit-max-content","-webkit-fill-available","-webkit-fit-content","calc()"],"-webkit-logical-height":["intrinsic","min-intrinsic","calc()"],"-webkit-max-logical-width":["none","intrinsic","min-intrinsic","-webkit-min-content","-webkit-max-content","-webkit-fill-available","-webkit-fit-content","calc()"],"-webkit-min-logical-width":["intrinsic","min-intrinsic","-webkit-min-content","-webkit-max-content","-webkit-fill-available","-webkit-fit-content","calc()"],"-webkit-max-logical-height":["none","intrinsic","min-intrinsic","calc()"],"-webkit-min-logical-height":["intrinsic","min-intrinsic","calc()"],"empty-cells":["hide","show"],"pointer-events":["none","all","auto","visible","visiblepainted","visiblefill","visiblestroke","painted","fill","stroke"],"letter-spacing":["normal","calc()"],"word-spacing":["normal","calc()"],"-webkit-font-kerning":["auto","normal","none"],"-webkit-font-smoothing":["none","auto","antialiased","subpixel-antialiased"],"border":["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double"],"font-size":["xx-small","x-small","small","medium","large","x-large","xx-large","-webkit-xxx-large","smaller","larger"],"font-variant":["small-caps","normal"],"font-variant-numeric":["normal","ordinal","slashed-zero","lining-nums","oldstyle-nums","proportional-nums","tabular-nums","diagonal-fractions","stacked-fractions"],"vertical-align":["baseline","middle","sub","super","text-top","text-bottom","top","bottom","-webkit-baseline-middle"],"white-space":["normal","nowrap","pre","pre-line","pre-wrap"],"word-break":["normal","break-all","break-word"],"text-underline-width":["normal","medium","auto","thick","thin","calc()"],"text-indent":["-webkit-each-line","-webkit-hanging"],"-webkit-box-lines":["single","multiple"],"clip":["auto","rect()"],"clip-path":["none","url()","circle()","ellipse()","inset()","polygon()","margin-box","border-box","padding-box","content-box"],"shape-outside":["none","url()","circle()","ellipse()","inset()","polygon()","margin-box","border-box","padding-box","content-box"],"orphans":["auto"],"widows":["auto"],"margin":["auto"],"page":["auto"],"perspective":["none"],"perspective-origin":["none","left","right","bottom","top","center"],"-webkit-marquee-increment":["small","large","medium"],"-webkit-marquee-direction":["left","right","auto","reverse","forwards","backwards","ahead","up","down"],"-webkit-marquee-style":["none","scroll","slide","alternate"],"-webkit-marquee-repetition":["infinite"],"-webkit-marquee-speed":["normal","slow","fast"],"margin-right":["auto"],"marquee-speed":["normal","slow","fast"],"-webkit-text-emphasis":["circle","filled","open","dot","double-circle","triangle","sesame"],"-webkit-text-emphasis-style":["circle","filled","open","dot","double-circle","triangle","sesame"],"-webkit-text-emphasis-position":["over","under","left","right"],"transform":["none","scale()","scaleX()","scaleY()","scale3d()","rotate()","rotateX()","rotateY()","rotateZ()","rotate3d()","skew()","skewX()","skewY()","translate()","translateX()","translateY()","translateZ()","translate3d()","matrix()","matrix3d()","perspective()"],"transform-style":["flat","preserve-3d"],"-webkit-cursor-visibility":["auto","auto-hide"],"text-decoration":["none","underline","overline","line-through","blink"],"-webkit-text-decorations-in-effect":["none","underline","overline","line-through","blink"],"-webkit-text-decoration-line":["none","underline","overline","line-through","blink"],"-webkit-text-decoration-style":["solid","double","dotted","dashed","wavy"],"-webkit-text-decoration-skip":["auto","none","objects","ink"],"-webkit-text-underline-position":["auto","alphabetic","under"],"image-resolution":["from-image","snap"],"-webkit-blend-mode":["normal","multiply","screen","overlay","darken","lighten","color-dodge","color-burn","hard-light","soft-light","difference","exclusion","plus-darker","plus-lighter","hue","saturation","color","luminosity",],"mix-blend-mode":["normal","multiply","screen","overlay","darken","lighten","color-dodge","color-burn","hard-light","soft-light","difference","exclusion","plus-darker","plus-lighter","hue","saturation","color","luminosity",],"mix":["auto","normal","multiply","screen","overlay","darken","lighten","color-dodge","color-burn","hard-light","soft-light","difference","exclusion","plus-darker","plus-lighter","hue","saturation","color","luminosity","clear","copy","destination","source-over","destination-over","source-in","destination-in","source-out","destination-out","source-atop","destination-atop","xor"],"geometry":["detached","attached","grid()"],"overflow-wrap":["normal","break-word"],"transition":["none","ease","linear","ease-in","ease-out","ease-in-out","step-start","step-end","steps()","cubic-bezier()","spring()","all",WebInspector.CSSKeywordCompletions.AllPropertyNamesPlaceholder],"transition-timing-function":["ease","linear","ease-in","ease-out","ease-in-out","step-start","step-end","steps()","cubic-bezier()","spring()"],"transition-property":["all","none",WebInspector.CSSKeywordCompletions.AllPropertyNamesPlaceholder],"-webkit-column-progression":["normal","reverse"],"-webkit-box-decoration-break":["slice","clone"],"align-content":["auto","baseline","last-baseline","space-between","space-around","space-evenly","stretch","center","start","end","flex-start","flex-end","left","right","true","safe"],"justify-content":["auto","baseline","last-baseline","space-between","space-around","space-evenly","stretch","center","start","end","flex-start","flex-end","left","right","true","safe"],"align-items":["auto","stretch","baseline","last-baseline","center","start","end","self-start","self-end","flex-start","flex-end","left","right","true","safe"],"align-self":["auto","stretch","baseline","last-baseline","center","start","end","self-start","self-end","flex-start","flex-end","left","right","true","safe"],"justify-items":["auto","stretch","baseline","last-baseline","center","start","end","self-start","self-end","flex-start","flex-end","left","right","true","safe"],"justify-self":["auto","stretch","baseline","last-baseline","center","start","end","self-start","self-end","flex-start","flex-end","left","right","true","safe"],"flex-direction":["row","row-reverse","column","column-reverse"],"flex-wrap":["nowrap","wrap","wrap-reverse"],"flex-flow":["row","row-reverse","column","column-reverse","nowrap","wrap","wrap-reverse"],"flex":["none"],"flex-basis":["auto"],"grid":["none"],"grid-area":["auto"],"grid-auto-columns":["auto","-webkit-max-content","-webkit-min-content","minmax()",],"grid-auto-flow":["row","column","dense"],"grid-auto-rows":["auto","-webkit-max-content","-webkit-min-content","minmax()",],"grid-column":["auto"],"grid-column-start":["auto"],"grid-column-end":["auto"],"grid-row":["auto"],"grid-row-start":["auto"],"grid-row-end":["auto"],"grid-template":["none"],"grid-template-areas":["none"],"grid-template-columns":["none","auto","-webkit-max-content","-webkit-min-content","minmax()","repeat()"],"grid-template-rows":["none","auto","-webkit-max-content","-webkit-min-content","minmax()","repeat()"],"-webkit-ruby-position":["after","before","inter-character"],"-webkit-text-align-last":["auto","start","end","left","right","center","justify"],"-webkit-text-justify":["auto","none","inter-word","inter-ideograph","inter-cluster","distribute","kashida"],"max-zoom":["auto"],"min-zoom":["auto"],"orientation":["auto","portait","landscape"],"scroll-snap-align":["none","start","center","end"],"scroll-snap-type":["none","mandatory","proximity","x","y","inline","block","both"],"user-zoom":["zoom","fixed"],"-webkit-app-region":["drag","no-drag"],"-webkit-line-break":["auto","loose","normal","strict","after-white-space"],"-webkit-background-composite":["clear","copy","source-over","source-in","source-out","source-atop","destination-over","destination-in","destination-out","destination-atop","xor","plus-darker","plus-lighter"],"-webkit-mask-composite":["clear","copy","source-over","source-in","source-out","source-atop","destination-over","destination-in","destination-out","destination-atop","xor","plus-darker","plus-lighter"],"-webkit-animation-direction":["normal","alternate","reverse","alternate-reverse"],"-webkit-animation-fill-mode":["none","forwards","backwards","both"],"-webkit-animation-iteration-count":["infinite"],"-webkit-animation-play-state":["paused","running"],"-webkit-animation-timing-function":["ease","linear","ease-in","ease-out","ease-in-out","step-start","step-end","steps()","cubic-bezier()","spring()"],"-webkit-column-span":["all","none","calc()"],"-webkit-region-break-after":["auto","always","avoid","left","right"],"-webkit-region-break-before":["auto","always","avoid","left","right"],"-webkit-region-break-inside":["auto","avoid"],"-webkit-region-overflow":["auto","break"],"-webkit-backface-visibility":["visible","hidden"],"resize":["none","both","horizontal","vertical","auto"],"caption-side":["top","bottom","left","right"],"box-sizing":["border-box","content-box"],"-webkit-alt":["attr()"],"-webkit-border-fit":["border","lines"],"-webkit-line-align":["none","edges"],"-webkit-line-snap":["none","baseline","contain"],"-webkit-nbsp-mode":["normal","space"],"-webkit-print-color-adjust":["exact","economy"],"-webkit-rtl-ordering":["logical","visual"],"-webkit-text-security":["disc","circle","square","none"],"-webkit-user-drag":["auto","none","element"],"-webkit-user-modify":["read-only","read-write","read-write-plaintext-only"],"-webkit-user-select":["auto","none","text","all"],"-webkit-text-stroke-width":["medium","thick","thin","calc()"],"-webkit-border-start-width":["medium","thick","thin","calc()"],"-webkit-border-end-width":["medium","thick","thin","calc()"],"-webkit-border-before-width":["medium","thick","thin","calc()"],"-webkit-border-after-width":["medium","thick","thin","calc()"],"-webkit-column-rule-width":["medium","thick","thin","calc()"],"-webkit-aspect-ratio":["auto","from-dimensions","from-intrinsic","/"],"filter":["none","grayscale()","sepia()","saturate()","hue-rotate()","invert()","opacity()","brightness()","contrast()","blur()","drop-shadow()","custom()"],"-webkit-backdrop-filter":["none","grayscale()","sepia()","saturate()","hue-rotate()","invert()","opacity()","brightness()","contrast()","blur()","drop-shadow()","custom()"],"-webkit-column-count":["auto","calc()"],"-webkit-column-gap":["normal","calc()"],"-webkit-column-axis":["horizontal","vertical","auto"],"-webkit-column-width":["auto","calc()"],"-webkit-column-fill":["auto","balance"],"-webkit-hyphenate-character":["none"],"-webkit-hyphenate-limit-after":["auto"],"-webkit-hyphenate-limit-before":["auto"],"-webkit-hyphenate-limit-lines":["no-limit"],"-webkit-line-grid":["none"],"-webkit-locale":["auto"],"-webkit-text-orientation":["sideways","sideways-right","vertical-right","upright"],"-webkit-line-box-contain":["block","inline","font","glyphs","replaced","inline-box","none"],"font-feature-settings":["normal"],"-webkit-font-variant-ligatures":["normal","common-ligatures","no-common-ligatures","discretionary-ligatures","no-discretionary-ligatures","historical-ligatures","no-historical-ligatures"],"-webkit-animation-trigger":["auto","container-scroll()"],"-webkit-text-size-adjust":["none","auto"],"-webkit-touch-callout":["default","none"],"-webkit-overflow-scrolling":["auto","touch"]};WebInspector.CSSMedia=class CSSMedia extends WebInspector.Object
{constructor(type,text,sourceCodeLocation)
{super();this._type=type||null;this._text=text||"";this._sourceCodeLocation=sourceCodeLocation||null;} 
get type(){return this._type;}
get text(){return this._text;}
get sourceCodeLocation(){return this._sourceCodeLocation;}};WebInspector.CSSMedia.Type={MediaRule:"css-media-type-media-rule",ImportRule:"css-media-type-import-rule",LinkedStyleSheet:"css-media-type-linked-stylesheet",InlineStyleSheet:"css-media-type-inline-stylesheet"};WebInspector.CSSProperty=class CSSProperty extends WebInspector.Object
{constructor(index,text,name,value,priority,enabled,overridden,implicit,anonymous,valid,styleSheetTextRange)
{super();this._ownerStyle=null;this._index=index;this.update(text,name,value,priority,enabled,overridden,implicit,anonymous,valid,styleSheetTextRange,true);} 
static isInheritedPropertyName(name)
{if(name in WebInspector.CSSKeywordCompletions.InheritedProperties)
return true;return name.startsWith("--");} 
get ownerStyle()
{return this._ownerStyle;}
set ownerStyle(ownerStyle)
{this._ownerStyle=ownerStyle||null;}
get index()
{return this._index;}
set index(index)
{this._index=index;}
update(text,name,value,priority,enabled,overridden,implicit,anonymous,valid,styleSheetTextRange,dontFireEvents)
{text=text||"";name=name||"";value=value||"";priority=priority||"";enabled=enabled||false;overridden=overridden||false;implicit=implicit||false;anonymous=anonymous||false;valid=valid||false;var changed=false;if(!dontFireEvents){changed=this._name!==name||this._value!==value||this._priority!==priority||this._enabled!==enabled||this._implicit!==implicit||this._anonymous!==anonymous||this._valid!==valid;}

if(!dontFireEvents)
this.overridden=overridden;else
this._overridden=overridden;this._text=text;this._name=name;this._value=value;this._priority=priority;this._enabled=enabled;this._implicit=implicit;this._anonymous=anonymous;this._inherited=WebInspector.CSSProperty.isInheritedPropertyName(name);this._valid=valid;this._variable=name.startsWith("--");this._styleSheetTextRange=styleSheetTextRange||null;this._relatedShorthandProperty=null;this._relatedLonghandProperties=[];delete this._styleDeclarationTextRange;delete this._canonicalName;delete this._hasOtherVendorNameOrKeyword;if(changed)
this.dispatchEventToListeners(WebInspector.CSSProperty.Event.Changed);}
get synthesizedText()
{var name=this.name;if(!name)
return"";var priority=this.priority;return name+": "+this.value.trim()+(priority?" !"+priority:"")+";";}
get text()
{return this._text||this.synthesizedText;}
get name(){return this._name;}
get canonicalName()
{if(this._canonicalName)
return this._canonicalName;this._canonicalName=WebInspector.cssStyleManager.canonicalNameForPropertyName(this.name);return this._canonicalName;}
get value(){return this._value;}
get important()
{return this.priority==="important";}
get priority(){return this._priority;}
get enabled()
{return this._enabled&&this._ownerStyle&&(!isNaN(this._index)||this._ownerStyle.type===WebInspector.CSSStyleDeclaration.Type.Computed);}
get overridden(){return this._overridden;}
set overridden(overridden)
{overridden=overridden||false;if(this._overridden===overridden)
return;var previousOverridden=this._overridden;this._overridden=overridden;if(this._overriddenStatusChangedTimeout)
return;function delayed()
{delete this._overriddenStatusChangedTimeout;if(this._overridden===previousOverridden)
return;this.dispatchEventToListeners(WebInspector.CSSProperty.Event.OverriddenStatusChanged);}
this._overriddenStatusChangedTimeout=setTimeout(delayed.bind(this),0);}
get implicit(){return this._implicit;}
set implicit(implicit){this._implicit=implicit;}
get anonymous(){return this._anonymous;}
get inherited(){return this._inherited;}
get valid(){return this._valid;}
get variable(){return this._variable;}
get styleSheetTextRange(){return this._styleSheetTextRange;}
get styleDeclarationTextRange()
{if("_styleDeclarationTextRange"in this)
return this._styleDeclarationTextRange;if(!this._ownerStyle||!this._styleSheetTextRange)
return null;var styleTextRange=this._ownerStyle.styleSheetTextRange;if(!styleTextRange)
return null;var startLine=this._styleSheetTextRange.startLine-styleTextRange.startLine;var endLine=this._styleSheetTextRange.endLine-styleTextRange.startLine;var startColumn=this._styleSheetTextRange.startColumn;if(!startLine)
startColumn-=styleTextRange.startColumn;var endColumn=this._styleSheetTextRange.endColumn;if(!endLine)
endColumn-=styleTextRange.startColumn;this._styleDeclarationTextRange=new WebInspector.TextRange(startLine,startColumn,endLine,endColumn);return this._styleDeclarationTextRange;}
get relatedShorthandProperty(){return this._relatedShorthandProperty;}
set relatedShorthandProperty(property)
{this._relatedShorthandProperty=property||null;}
get relatedLonghandProperties(){return this._relatedLonghandProperties;}
addRelatedLonghandProperty(property)
{this._relatedLonghandProperties.push(property);}
clearRelatedLonghandProperties(property)
{this._relatedLonghandProperties=[];}
hasOtherVendorNameOrKeyword()
{if("_hasOtherVendorNameOrKeyword"in this)
return this._hasOtherVendorNameOrKeyword;this._hasOtherVendorNameOrKeyword=WebInspector.cssStyleManager.propertyNameHasOtherVendorPrefix(this.name)||WebInspector.cssStyleManager.propertyValueHasOtherVendorKeyword(this.value);return this._hasOtherVendorNameOrKeyword;}};WebInspector.CSSProperty.Event={Changed:"css-property-changed",OverriddenStatusChanged:"css-property-overridden-status-changed"};WebInspector.CSSRule=class CSSRule extends WebInspector.Object
{constructor(nodeStyles,ownerStyleSheet,id,type,sourceCodeLocation,selectorText,selectors,matchedSelectorIndices,style,mediaList)
{super();this._nodeStyles=nodeStyles;this._ownerStyleSheet=ownerStyleSheet||null;this._id=id||null;this._type=type||null;this.update(sourceCodeLocation,selectorText,selectors,matchedSelectorIndices,style,mediaList,true);} 
get id()
{return this._id;}
get ownerStyleSheet()
{return this._ownerStyleSheet;}
get editable()
{return!!this._id&&(this._type===WebInspector.CSSStyleSheet.Type.Author||this._type===WebInspector.CSSStyleSheet.Type.Inspector);}
update(sourceCodeLocation,selectorText,selectors,matchedSelectorIndices,style,mediaList,dontFireEvents)
{sourceCodeLocation=sourceCodeLocation||null;selectorText=selectorText||"";selectors=selectors||[];matchedSelectorIndices=matchedSelectorIndices||[];style=style||null;mediaList=mediaList||[];var changed=false;if(!dontFireEvents){changed=this._selectorText!==selectorText||!Array.shallowEqual(this._selectors,selectors)||!Array.shallowEqual(this._matchedSelectorIndices,matchedSelectorIndices)||this._style!==style||!!this._sourceCodeLocation!==!!sourceCodeLocation||this._mediaList.length!==mediaList.length;}
if(this._style)
this._style.ownerRule=null;this._sourceCodeLocation=sourceCodeLocation;this._selectorText=selectorText;this._selectors=selectors;this._matchedSelectorIndices=matchedSelectorIndices;this._mostSpecificSelector=null;this._style=style;this._mediaList=mediaList;this._matchedSelectors=null;this._matchedSelectorText=null;if(this._style)
this._style.ownerRule=this;if(changed)
this.dispatchEventToListeners(WebInspector.CSSRule.Event.Changed);}
get type()
{return this._type;}
get sourceCodeLocation()
{return this._sourceCodeLocation;}
get selectorText()
{return this._selectorText;}
set selectorText(selectorText)
{if(!this.editable)
return;if(this._selectorText===selectorText){this._selectorResolved(true);return;}
this._nodeStyles.changeRuleSelector(this,selectorText).then(this._selectorResolved.bind(this),this._selectorRejected.bind(this));}
get selectors()
{return this._selectors;}
get matchedSelectorIndices()
{return this._matchedSelectorIndices;}
get matchedSelectors()
{if(this._matchedSelectors)
return this._matchedSelectors;this._matchedSelectors=this._selectors.filter(function(element,index){return this._matchedSelectorIndices.includes(index);},this);return this._matchedSelectors;}
get matchedSelectorText()
{if("_matchedSelectorText"in this)
return this._matchedSelectorText;this._matchedSelectorText=this.matchedSelectors.map(function(x){return x.text;}).join(", ");return this._matchedSelectorText;}
hasMatchedPseudoElementSelector()
{if(this.nodeStyles&&this.nodeStyles.node&&this.nodeStyles.node.isPseudoElement())
return true;return this.matchedSelectors.some((selector)=>selector.isPseudoElementSelector());}
get style()
{return this._style;}
get mediaList()
{return this._mediaList;}
get mediaText()
{if(!this._mediaList.length)
return"";let mediaText="";for(let media of this._mediaList)
mediaText+=media.text;return mediaText;}
isEqualTo(rule)
{if(!rule)
return false;return Object.shallowEqual(this._id,rule.id);}
get mostSpecificSelector()
{if(!this._mostSpecificSelector)
this._mostSpecificSelector=this._determineMostSpecificSelector();return this._mostSpecificSelector;}
selectorIsGreater(otherSelector)
{var mostSpecificSelector=this.mostSpecificSelector;if(!mostSpecificSelector)
return false;return mostSpecificSelector.isGreaterThan(otherSelector);} 
get nodeStyles()
{return this._nodeStyles;} 
_determineMostSpecificSelector()
{if(!this._selectors||!this._selectors.length)
return null;var selectors=this.matchedSelectors;if(!selectors.length)
selectors=this._selectors;var specificSelector=selectors[0];for(var selector of selectors){if(selector.isGreaterThan(specificSelector))
specificSelector=selector;}
return specificSelector;}
_selectorRejected(error)
{this.dispatchEventToListeners(WebInspector.CSSRule.Event.SelectorChanged,{valid:!error});}
_selectorResolved(rulePayload)
{this.dispatchEventToListeners(WebInspector.CSSRule.Event.SelectorChanged,{valid:!!rulePayload});}};WebInspector.CSSRule.Event={Changed:"css-rule-changed",SelectorChanged:"css-rule-invalid-selector"};WebInspector.CSSSelector=class CSSSelector extends WebInspector.Object
{constructor(text,specificity,dynamic)
{super();this._text=text;this._specificity=specificity||null;this._dynamic=dynamic||false;} 
get text(){return this._text;}
get specificity(){return this._specificity;}
get dynamic(){return this._dynamic;}
isGreaterThan(selector)
{if(!selector||!selector.specificity)
return true;for(var i=0;i<this._specificity.length;++i){if(this._specificity[i]===selector.specificity[i])
continue;return this._specificity[i]>selector.specificity[i];}
return false;}
isPseudoElementSelector()
{return WebInspector.CSSStyleManager.PseudoElementNames.some((name)=>this._text.includes(`:${name}`));}};WebInspector.CSSStyleDeclaration=class CSSStyleDeclaration extends WebInspector.Object
{constructor(nodeStyles,ownerStyleSheet,id,type,node,inherited,text,properties,styleSheetTextRange)
{super();this._nodeStyles=nodeStyles;this._ownerRule=null;this._ownerStyleSheet=ownerStyleSheet||null;this._id=id||null;this._type=type||null;this._node=node||null;this._inherited=inherited||false;this._pendingProperties=[];this._propertyNameMap={};this._initialText=text;this._hasModifiedInitialText=false;this.update(text,properties,styleSheetTextRange,true);} 
get id()
{return this._id;}
get ownerStyleSheet()
{return this._ownerStyleSheet;}
get type()
{return this._type;}
get inherited()
{return this._inherited;}
get node()
{return this._node;}
get editable()
{if(!this._id)
return false;if(this._type===WebInspector.CSSStyleDeclaration.Type.Rule)
return this._ownerRule&&this._ownerRule.editable;if(this._type===WebInspector.CSSStyleDeclaration.Type.Inline)
return!this._node.isInUserAgentShadowTree();return false;}
update(text,properties,styleSheetTextRange,dontFireEvents)
{text=text||"";properties=properties||[];var oldProperties=this._properties||[];var oldText=this._text;this._text=text;this._properties=properties;this._styleSheetTextRange=styleSheetTextRange;this._propertyNameMap={};delete this._visibleProperties;var editable=this.editable;for(var i=0;i<this._properties.length;++i){var property=this._properties[i];property.ownerStyle=this;


if(!editable)
this._propertyNameMap[property.name]=property;else{this._pendingProperties.remove(property);}}
var removedProperties=[];for(var i=0;i<oldProperties.length;++i){var oldProperty=oldProperties[i];if(!this._properties.includes(oldProperty)){oldProperty.index=NaN;removedProperties.push(oldProperty);
if(editable)
this._pendingProperties.push(oldProperty);}}
if(dontFireEvents)
return;var addedProperties=[];for(var i=0;i<this._properties.length;++i){if(!oldProperties.includes(this._properties[i]))
addedProperties.push(this._properties[i]);}
if(oldText&&this._text&&oldText===this._text){if(!addedProperties.length&&!removedProperties.length)
return;}
function delayed()
{this.dispatchEventToListeners(WebInspector.CSSStyleDeclaration.Event.PropertiesChanged,{addedProperties,removedProperties});}
setTimeout(delayed.bind(this),0);}
get ownerRule()
{return this._ownerRule;}
set ownerRule(rule)
{this._ownerRule=rule||null;}
get text()
{return this._text;}
set text(text)
{if(this._text===text)
return;let trimmedText=WebInspector.CSSStyleDeclarationTextEditor.PrefixWhitespace+text.trim();if(this._text===trimmedText)
return;if(trimmedText===WebInspector.CSSStyleDeclarationTextEditor.PrefixWhitespace||this._type===WebInspector.CSSStyleDeclaration.Type.Inline)
text=trimmedText;let modified=text!==this._initialText;if(modified!==this._hasModifiedInitialText){this._hasModifiedInitialText=modified;this.dispatchEventToListeners(WebInspector.CSSStyleDeclaration.Event.InitialTextModified);}
this._nodeStyles.changeStyleText(this,text);}
resetText()
{this.text=this._initialText;}
get modified()
{return this._hasModifiedInitialText;}
get properties()
{return this._properties;}
get visibleProperties()
{if(this._visibleProperties)
return this._visibleProperties;this._visibleProperties=this._properties.filter(function(property){return!!property.styleDeclarationTextRange;});return this._visibleProperties;}
get pendingProperties()
{return this._pendingProperties;}
get styleSheetTextRange()
{return this._styleSheetTextRange;}
get mediaList()
{if(this._ownerRule)
return this._ownerRule.mediaList;return[];}
get selectorText()
{if(this._ownerRule)
return this._ownerRule.selectorText;return this._node.appropriateSelectorFor(true);}
propertyForName(name,dontCreateIfMissing)
{if(!name)
return null;if(!this.editable)
return this._propertyNameMap[name]||null;
function findMatch(properties)
{for(var i=0;i<properties.length;++i){var property=properties[i];if(property.canonicalName!==name&&property.name!==name)
continue;if(bestMatchProperty&&!bestMatchProperty.overridden&&property.overridden)
continue;bestMatchProperty=property;}}
var bestMatchProperty=null;findMatch(this._properties);if(bestMatchProperty)
return bestMatchProperty;if(dontCreateIfMissing||!this.editable)
return null;findMatch(this._pendingProperties,true);if(bestMatchProperty)
return bestMatchProperty;var newProperty=new WebInspector.CSSProperty(NaN,null,name);newProperty.ownerStyle=this;this._pendingProperties.push(newProperty);return newProperty;}
generateCSSRuleString()
{let indentString=WebInspector.indentString();let styleText="";let mediaList=this.mediaList;let mediaQueriesCount=mediaList.length;for(let i=mediaQueriesCount-1;i>=0;--i)
styleText+=indentString.repeat(mediaQueriesCount-i-1)+"@media "+mediaList[i].text+" {\n";styleText+=indentString.repeat(mediaQueriesCount)+this.selectorText+" {\n";for(let property of this._properties){if(property.anonymous)
continue;styleText+=indentString.repeat(mediaQueriesCount+1)+property.text.trim();if(!styleText.endsWith(";"))
styleText+=";";styleText+="\n";}
for(let i=mediaQueriesCount;i>0;--i)
styleText+=indentString.repeat(i)+"}\n";styleText+="}";return styleText;}
isInspectorRule()
{return this._ownerRule&&this._ownerRule.type===WebInspector.CSSStyleSheet.Type.Inspector;}
hasProperties()
{return!!this._properties.length;} 
get nodeStyles()
{return this._nodeStyles;}};WebInspector.CSSStyleDeclaration.Event={PropertiesChanged:"css-style-declaration-properties-changed",InitialTextModified:"css-style-declaration-initial-text-modified"};WebInspector.CSSStyleDeclaration.Type={Rule:"css-style-declaration-type-rule",Inline:"css-style-declaration-type-inline",Attribute:"css-style-declaration-type-attribute",Computed:"css-style-declaration-type-computed"};WebInspector.CSSStyleSheet=class CSSStyleSheet extends WebInspector.SourceCode
{constructor(id)
{super();this._id=id||null;this._url=null;this._parentFrame=null;this._origin=null;this._startLineNumber=0;this._startColumnNumber=0;this._inlineStyleAttribute=false;this._inlineStyleTag=false;this._hasInfo=false;} 
static resetUniqueDisplayNameNumbers()
{WebInspector.CSSStyleSheet._nextUniqueDisplayNameNumber=1;} 
get id()
{return this._id;}
get parentFrame()
{return this._parentFrame;}
get origin()
{return this._origin;}
get url()
{return this._url;}
get urlComponents()
{if(!this._urlComponents)
this._urlComponents=parseURL(this._url);return this._urlComponents;}
get mimeType()
{return"text/css";}
get displayName()
{if(this._url)
return WebInspector.displayNameForURL(this._url,this.urlComponents);if(!this._uniqueDisplayNameNumber)
this._uniqueDisplayNameNumber=this.constructor._nextUniqueDisplayNameNumber++;return WebInspector.UIString("Anonymous StyleSheet %d").format(this._uniqueDisplayNameNumber);}
get startLineNumber()
{return this._startLineNumber;}
get startColumnNumber()
{return this._startColumnNumber;}
hasInfo()
{return this._hasInfo;}
isInspectorStyleSheet()
{return this._origin===WebInspector.CSSStyleSheet.Type.Inspector;}
isInlineStyleTag()
{return this._inlineStyleTag;}
isInlineStyleAttributeStyleSheet()
{return this._inlineStyleAttribute;}
markAsInlineStyleAttributeStyleSheet()
{this._inlineStyleAttribute=true;}
offsetSourceCodeLocation(sourceCodeLocation)
{if(!sourceCodeLocation)
return null;if(!this._hasInfo)
return sourceCodeLocation;let sourceCode=sourceCodeLocation.sourceCode;let lineNumber=this._startLineNumber+sourceCodeLocation.lineNumber;let columnNumber=this._startColumnNumber+sourceCodeLocation.columnNumber;return sourceCode.createSourceCodeLocation(lineNumber,columnNumber);} 
updateInfo(url,parentFrame,origin,inlineStyle,startLineNumber,startColumnNumber)
{this._hasInfo=true;this._url=url||null;this._urlComponents=undefined;this._parentFrame=parentFrame||null;this._origin=origin;this._inlineStyleTag=inlineStyle;this._startLineNumber=startLineNumber;this._startColumnNumber=startColumnNumber;}
get revisionForRequestedContent()
{return this.currentRevision;}
handleCurrentRevisionContentChange()
{if(!this._id)
return;function contentDidChange(error)
{if(error)
return;DOMAgent.markUndoableState();this.dispatchEventToListeners(WebInspector.CSSStyleSheet.Event.ContentDidChange);}
this._ignoreNextContentDidChangeNotification=true;CSSAgent.setStyleSheetText(this._id,this.currentRevision.content,contentDidChange.bind(this));}
requestContentFromBackend()
{if(!this._id){
return Promise.reject(new Error("There is no identifier to request content with."));}
return CSSAgent.getStyleSheetText(this._id);}
noteContentDidChange()
{if(this._ignoreNextContentDidChangeNotification){this._ignoreNextContentDidChangeNotification=false;return false;}
this.markContentAsStale();this.dispatchEventToListeners(WebInspector.CSSStyleSheet.Event.ContentDidChange);return true;}};WebInspector.CSSStyleSheet._nextUniqueDisplayNameNumber=1;WebInspector.CSSStyleSheet.Event={ContentDidChange:"stylesheet-content-did-change"};WebInspector.CSSStyleSheet.Type={Author:"css-stylesheet-type-author",User:"css-stylesheet-type-user",UserAgent:"css-stylesheet-type-user-agent",Inspector:"css-stylesheet-type-inspector"};WebInspector.CallFrame=class CallFrame extends WebInspector.Object
{constructor(target,id,sourceCodeLocation,functionName,thisObject,scopeChain,nativeCode,programCode,isTailDeleted)
{super();this._isConsoleEvaluation=sourceCodeLocation&&isWebInspectorConsoleEvaluationScript(sourceCodeLocation.sourceCode.sourceURL);if(this._isConsoleEvaluation){functionName=WebInspector.UIString("Console Evaluation");programCode=true;}
this._target=target;this._id=id||null;this._sourceCodeLocation=sourceCodeLocation||null;this._functionName=functionName||"";this._thisObject=thisObject||null;this._scopeChain=scopeChain||[];this._nativeCode=nativeCode||false;this._programCode=programCode||false;this._isTailDeleted=isTailDeleted||false;} 
get target(){return this._target;}
get id(){return this._id;}
get sourceCodeLocation(){return this._sourceCodeLocation;}
get functionName(){return this._functionName;}
get nativeCode(){return this._nativeCode;}
get programCode(){return this._programCode;}
get thisObject(){return this._thisObject;}
get scopeChain(){return this._scopeChain;}
get isTailDeleted(){return this._isTailDeleted;}
get isConsoleEvaluation(){return this._isConsoleEvaluation;}
saveIdentityToCookie()
{
}
collectScopeChainVariableNames(callback)
{var result={this:true,__proto__:null};var pendingRequests=this._scopeChain.length;function propertiesCollected(properties)
{for(var i=0;properties&&i<properties.length;++i)
result[properties[i].name]=true;if(--pendingRequests)
return;callback(result);}
for(var i=0;i<this._scopeChain.length;++i)
this._scopeChain[i].objects[0].deprecatedGetAllProperties(propertiesCollected);}
mergedScopeChain()
{let mergedScopes=[];
let scopes=this._scopeChain.slice();



 
let lastMarkedHash=null;function markAsBaseIfNeeded(scope){if(!scope.hash)
return false;if(scope.type!==WebInspector.ScopeChainNode.Type.Closure)
return false;if(scope.hash===lastMarkedHash)
return false;lastMarkedHash=scope.hash;scope.__baseClosureScope=true;return true;}
function shouldMergeClosureScopes(youngScope,oldScope,lastMerge){if(!youngScope||!oldScope)
return false;if(!youngScope.hash||!oldScope.hash)
return false;if(youngScope.type!==WebInspector.ScopeChainNode.Type.Closure)
return false;if(oldScope.type!==WebInspector.ScopeChainNode.Type.Closure)
return false;if(youngScope.hash!==oldScope.hash)
return false;if(lastMerge&&youngScope.hash===lastMerge.hash)
return false;return true;}
let lastScope=null;let lastMerge=null;for(let i=scopes.length-1;i>=0;--i){let scope=scopes[i];markAsBaseIfNeeded(scope);if(shouldMergeClosureScopes(scope,lastScope,lastMerge)){let type=WebInspector.ScopeChainNode.Type.Closure;let objects=lastScope.objects.concat(scope.objects);let merged=new WebInspector.ScopeChainNode(type,objects,scope.name,scope.location);merged.__baseClosureScope=true;mergedScopes.pop();mergedScopes.push(merged);lastMerge=merged;lastScope=null;}else{mergedScopes.push(scope);lastMerge=null;lastScope=scope;}}
mergedScopes=mergedScopes.reverse();for(let scope of mergedScopes){if(scope.type===WebInspector.ScopeChainNode.Type.Closure){if(scope.name===this._functionName)
scope.convertToLocalScope();break;}}
return mergedScopes;} 
static functionNameFromPayload(payload)
{let functionName=payload.functionName;if(functionName==="global code")
return WebInspector.UIString("Global Code");if(functionName==="eval code")
return WebInspector.UIString("Eval Code");if(functionName==="module code")
return WebInspector.UIString("Module Code");return functionName;}
static programCodeFromPayload(payload)
{return payload.functionName.endsWith(" code");}
static fromDebuggerPayload(target,payload,scopeChain,sourceCodeLocation)
{let id=payload.callFrameId;let thisObject=WebInspector.RemoteObject.fromPayload(payload.this,target);let functionName=WebInspector.CallFrame.functionNameFromPayload(payload);let nativeCode=false;let programCode=WebInspector.CallFrame.programCodeFromPayload(payload);let isTailDeleted=payload.isTailDeleted;return new WebInspector.CallFrame(target,id,sourceCodeLocation,functionName,thisObject,scopeChain,nativeCode,programCode,isTailDeleted);}
static fromPayload(target,payload)
{let{url,scriptId}=payload;let nativeCode=false;let sourceCodeLocation=null;let functionName=WebInspector.CallFrame.functionNameFromPayload(payload);let programCode=WebInspector.CallFrame.programCodeFromPayload(payload);if(url==="[native code]"){nativeCode=true;url=null;}else if(url||scriptId){let sourceCode=null;if(scriptId){sourceCode=WebInspector.debuggerManager.scriptForIdentifier(scriptId,target);if(sourceCode&&sourceCode.resource)
sourceCode=sourceCode.resource;}
if(!sourceCode)
sourceCode=WebInspector.frameResourceManager.resourceForURL(url);if(!sourceCode)
sourceCode=WebInspector.debuggerManager.scriptsForURL(url,target)[0];if(sourceCode){let lineNumber=payload.lineNumber-1;sourceCodeLocation=sourceCode.createLazySourceCodeLocation(lineNumber,payload.columnNumber);}else{nativeCode=true;url=null;}}
const id=null;const thisObject=null;const scopeChain=null;const isTailDeleted=false;return new WebInspector.CallFrame(target,id,sourceCodeLocation,functionName,thisObject,scopeChain,nativeCode,programCode,isTailDeleted);}};WebInspector.Canvas=class Canvas extends WebInspector.Object
{constructor(identifier,contextType,frame,{domNode,cssCanvasName,contextAttributes,memoryCost}={})
{super();this._identifier=identifier;this._contextType=contextType;this._frame=frame;this._domNode=domNode||null;this._cssCanvasName=cssCanvasName||"";this._contextAttributes=contextAttributes||{};this._memoryCost=memoryCost||NaN;this._cssCanvasClientNodes=null;} 
static fromPayload(payload)
{let contextType=null;switch(payload.contextType){case CanvasAgent.ContextType.Canvas2D:contextType=WebInspector.Canvas.ContextType.Canvas2D;break;case CanvasAgent.ContextType.WebGL:contextType=WebInspector.Canvas.ContextType.WebGL;break;case CanvasAgent.ContextType.WebGL2:contextType=WebInspector.Canvas.ContextType.WebGL2;break;case CanvasAgent.ContextType.WebGPU:contextType=WebInspector.Canvas.ContextType.WebGPU;break;default:console.error("Invalid canvas context type",payload.contextType);}
let frame=WebInspector.frameResourceManager.frameForIdentifier(payload.frameId);return new WebInspector.Canvas(payload.canvasId,contextType,frame,{domNode:payload.nodeId?WebInspector.domTreeManager.nodeForId(payload.nodeId):null,cssCanvasName:payload.cssCanvasName,contextAttributes:payload.contextAttributes,memoryCost:payload.memoryCost,});}
static displayNameForContextType(contextType)
{switch(contextType){case WebInspector.Canvas.ContextType.Canvas2D:return WebInspector.UIString("2D");case WebInspector.Canvas.ContextType.WebGL:return WebInspector.unlocalizedString("WebGL");case WebInspector.Canvas.ContextType.WebGL2:return WebInspector.unlocalizedString("WebGL2");case WebInspector.Canvas.ContextType.WebGPU:return WebInspector.unlocalizedString("WebGPU");default:console.error("Invalid canvas context type",contextType);}}
static resetUniqueDisplayNameNumbers()
{WebInspector.Canvas._nextUniqueDisplayNameNumber=1;} 
get identifier(){return this._identifier;}
get contextType(){return this._contextType;}
get frame(){return this._frame;}
get cssCanvasName(){return this._cssCanvasName;}
get contextAttributes(){return this._contextAttributes;}
get memoryCost()
{return this._memoryCost;}
set memoryCost(memoryCost)
{if(memoryCost===this._memoryCost)
return;this._memoryCost=memoryCost;this.dispatchEventToListeners(WebInspector.Canvas.Event.MemoryChanged);}
get displayName()
{if(this._cssCanvasName)
return WebInspector.UIString("CSS canvas “%s”").format(this._cssCanvasName);if(this._domNode){let idSelector=this._domNode.escapedIdSelector;if(idSelector)
return WebInspector.UIString("Canvas %s").format(idSelector);}
if(!this._uniqueDisplayNameNumber)
this._uniqueDisplayNameNumber=this.constructor._nextUniqueDisplayNameNumber++;return WebInspector.UIString("Canvas %d").format(this._uniqueDisplayNameNumber);}
requestNode(callback)
{if(this._domNode){callback(this._domNode);return;}
WebInspector.domTreeManager.ensureDocument();CanvasAgent.requestNode(this._identifier,(error,nodeId)=>{if(error){callback(null);return;}
this._domNode=WebInspector.domTreeManager.nodeForId(nodeId);callback(this._domNode);});}
requestContent(callback)
{CanvasAgent.requestContent(this._identifier,(error,content)=>{if(error){callback(null);return;}
callback(content);});}
requestCSSCanvasClientNodes(callback)
{if(!this._cssCanvasName){callback([]);return;}
if(this._cssCanvasClientNodes){callback(this._cssCanvasClientNodes);return;}
WebInspector.domTreeManager.ensureDocument();CanvasAgent.requestCSSCanvasClientNodes(this._identifier,(error,clientNodeIds)=>{if(error){callback([]);return;}
clientNodeIds=Array.isArray(clientNodeIds)?clientNodeIds:[];this._cssCanvasClientNodes=clientNodeIds.map((clientNodeId)=>WebInspector.domTreeManager.nodeForId(clientNodeId));callback(this._cssCanvasClientNodes);});}
saveIdentityToCookie(cookie)
{cookie[WebInspector.Canvas.FrameURLCookieKey]=this._frame.url.hash;if(this._cssCanvasName)
cookie[WebInspector.Canvas.CSSCanvasNameCookieKey]=this._cssCanvasName;else if(this._domNode)
cookie[WebInspector.Canvas.NodePathCookieKey]=this._domNode.path;}
cssCanvasClientNodesChanged()
{if(!this._cssCanvasName)
return;this._cssCanvasClientNodes=null;this.dispatchEventToListeners(WebInspector.Canvas.Event.CSSCanvasClientNodesChanged);}};WebInspector.Canvas._nextUniqueDisplayNameNumber=1;WebInspector.Canvas.FrameURLCookieKey="canvas-frame-url";WebInspector.Canvas.CSSCanvasNameCookieKey="canvas-css-canvas-name";WebInspector.Canvas.ContextType={Canvas2D:"canvas-2d",WebGL:"webgl",WebGL2:"webgl2",WebGPU:"webgpu",};WebInspector.Canvas.ResourceSidebarType="resource-type-canvas";WebInspector.Canvas.Event={MemoryChanged:"canvas-memory-changed",CSSCanvasClientNodesChanged:"canvas-css-canvas-client-nodes-changed",};WebInspector.Collection=class Collection extends WebInspector.Object
{constructor(typeVerifier)
{super();this._items=new Set;this._typeVerifier=typeVerifier||WebInspector.Collection.TypeVerifier.Any;} 
get items(){return this._items;}
get typeVerifier(){return this._typeVerifier;}
add(item)
{let isValidType=this._typeVerifier(item);if(!isValidType)
return;this._items.add(item);this.itemAdded(item);this.dispatchEventToListeners(WebInspector.Collection.Event.ItemAdded,{item});}
remove(item)
{let wasRemoved=this._items.delete(item);this.itemRemoved(item);this.dispatchEventToListeners(WebInspector.Collection.Event.ItemRemoved,{item});}
clear()
{let items=new Set(this._items);this._items.clear();this.itemsCleared(items);for(let item of items)
this.dispatchEventToListeners(WebInspector.Collection.Event.ItemRemoved,{item});}
toArray()
{return Array.from(this._items);}
toJSON()
{return this.toArray();} 
itemAdded(item)
{}
itemRemoved(item)
{}
itemsCleared(items)
{}};WebInspector.Collection.Event={ItemAdded:"collection-item-added",ItemRemoved:"collection-item-removed",};WebInspector.Collection.TypeVerifier={Any:(object)=>true,ContentFlow:(object)=>object instanceof WebInspector.ContentFlow,Frame:(object)=>object instanceof WebInspector.Frame,Resource:(object)=>object instanceof WebInspector.Resource,Script:(object)=>object instanceof WebInspector.Script,CSSStyleSheet:(object)=>object instanceof WebInspector.CSSStyleSheet,Canvas:(object)=>object instanceof WebInspector.Canvas,};WebInspector.CollectionEntry=class CollectionEntry extends WebInspector.Object
{constructor(key,value)
{super();this._key=key;this._value=value;}

static fromPayload(payload,target)
{if(payload.key)
payload.key=WebInspector.RemoteObject.fromPayload(payload.key,target);if(payload.value)
payload.value=WebInspector.RemoteObject.fromPayload(payload.value,target);return new WebInspector.CollectionEntry(payload.key,payload.value);} 
get key(){return this._key;}
get value(){return this._value;}};WebInspector.CollectionEntryPreview=class CollectionEntryPreview extends WebInspector.Object
{constructor(keyPreview,valuePreview)
{super();this._key=keyPreview;this._value=valuePreview;}

static fromPayload(payload)
{if(payload.key)
payload.key=WebInspector.ObjectPreview.fromPayload(payload.key);if(payload.value)
payload.value=WebInspector.ObjectPreview.fromPayload(payload.value);return new WebInspector.CollectionEntryPreview(payload.key,payload.value);} 
get keyPreview(){return this._key;}
get valuePreview(){return this._value;}};WebInspector.Color=class Color
{constructor(format,components)
{this.format=format;if(format===WebInspector.Color.Format.HSL||format===WebInspector.Color.Format.HSLA)
this._hsla=components;else
this._rgba=components;this.valid=!components.some(isNaN);} 
static fromString(colorString)
{let value=colorString.toLowerCase().replace(/%|\s+/g,"");let transparentKeywords=["transparent","rgba(0,0,0,0)","hsla(0,0,0,0)"];if(transparentKeywords.includes(value)){let color=new WebInspector.Color(WebInspector.Color.Format.Keyword,[0,0,0,0]);color.keyword="transparent";color.original=colorString;return color;}
let simple=/^(?:#([0-9a-f]{3,8})|rgb\(([^)]+)\)|(\w+)|hsl\(([^)]+)\))$/i;let match=colorString.match(simple);if(match){if(match[1]){ let hex=match[1].toUpperCase();let len=hex.length;if(len===3){return new WebInspector.Color(WebInspector.Color.Format.ShortHEX,[parseInt(hex.charAt(0)+hex.charAt(0),16),parseInt(hex.charAt(1)+hex.charAt(1),16),parseInt(hex.charAt(2)+hex.charAt(2),16),1]);}else if(len===6){return new WebInspector.Color(WebInspector.Color.Format.HEX,[parseInt(hex.substring(0,2),16),parseInt(hex.substring(2,4),16),parseInt(hex.substring(4,6),16),1]);}else if(len===4){return new WebInspector.Color(WebInspector.Color.Format.ShortHEXAlpha,[parseInt(hex.charAt(0)+hex.charAt(0),16),parseInt(hex.charAt(1)+hex.charAt(1),16),parseInt(hex.charAt(2)+hex.charAt(2),16),parseInt(hex.charAt(3)+hex.charAt(3),16)/255]);}else if(len===8){return new WebInspector.Color(WebInspector.Color.Format.HEXAlpha,[parseInt(hex.substring(0,2),16),parseInt(hex.substring(2,4),16),parseInt(hex.substring(4,6),16),parseInt(hex.substring(6,8),16)/255]);}else
return null;}else if(match[2]){ let rgb=match[2].split(/\s*,\s*/);if(rgb.length!==3)
return null;return new WebInspector.Color(WebInspector.Color.Format.RGB,[parseInt(rgb[0]),parseInt(rgb[1]),parseInt(rgb[2]),1]);}else if(match[3]){ let keyword=match[3].toLowerCase();if(!WebInspector.Color.Keywords.hasOwnProperty(keyword))
return null;let color=new WebInspector.Color(WebInspector.Color.Format.Keyword,WebInspector.Color.Keywords[keyword].concat(1));color.keyword=keyword;color.original=colorString;return color;}else if(match[4]){ let hsl=match[4].replace(/%/g,"").split(/\s*,\s*/);if(hsl.length!==3)
return null;return new WebInspector.Color(WebInspector.Color.Format.HSL,[parseInt(hsl[0]),parseInt(hsl[1]),parseInt(hsl[2]),1]);}}
let advanced=/^(?:rgba\(([^)]+)\)|hsla\(([^)]+)\))$/i;match=colorString.match(advanced);if(match){if(match[1]){ let rgba=match[1].split(/\s*,\s*/);if(rgba.length!==4)
return null;return new WebInspector.Color(WebInspector.Color.Format.RGBA,[parseInt(rgba[0]),parseInt(rgba[1]),parseInt(rgba[2]),Number.constrain(parseFloat(rgba[3]),0,1)]);}else if(match[2]){ let hsla=match[2].replace(/%/g,"").split(/\s*,\s*/);if(hsla.length!==4)
return null;return new WebInspector.Color(WebInspector.Color.Format.HSLA,[parseInt(hsla[0]),parseInt(hsla[1]),parseInt(hsla[2]),Number.constrain(parseFloat(hsla[3]),0,1)]);}}
return null;}
static rgb2hsv(r,g,b)
{r/=255;g/=255;b/=255;let min=Math.min(Math.min(r,g),b);let max=Math.max(Math.max(r,g),b);let delta=max-min;let h;let s;let v=max;if(delta===0)
h=0;else if(max===r)
h=(60*((g-b)/delta))%360;else if(max===g)
h=60*((b-r)/delta)+120;else if(max===b)
h=60*((r-g)/delta)+240;if(h<0)
h+=360; if(max===0)
s=0;else
s=1-(min/max);return[h,s,v];}
static hsv2rgb(h,s,v)
{if(s===0)
return[v,v,v];h/=60;let i=Math.floor(h);let data=[v*(1-s),v*(1-s*(h-i)),v*(1-s*(1-(h-i)))];let rgb;switch(i){case 0:rgb=[v,data[2],data[0]];break;case 1:rgb=[data[1],v,data[0]];break;case 2:rgb=[data[0],v,data[2]];break;case 3:rgb=[data[0],data[1],v];break;case 4:rgb=[data[2],data[0],v];break;default:rgb=[v,data[0],data[1]];break;}
return rgb;} 
nextFormat(format)
{format=format||this.format;switch(format){case WebInspector.Color.Format.Original:case WebInspector.Color.Format.HEX:case WebInspector.Color.Format.HEXAlpha:return this.simple?WebInspector.Color.Format.RGB:WebInspector.Color.Format.RGBA;case WebInspector.Color.Format.RGB:case WebInspector.Color.Format.RGBA:return this.simple?WebInspector.Color.Format.HSL:WebInspector.Color.Format.HSLA;case WebInspector.Color.Format.HSL:case WebInspector.Color.Format.HSLA:if(this.isKeyword())
return WebInspector.Color.Format.Keyword;if(this.simple)
return this.canBeSerializedAsShortHEX()?WebInspector.Color.Format.ShortHEX:WebInspector.Color.Format.HEX;return this.canBeSerializedAsShortHEX()?WebInspector.Color.Format.ShortHEXAlpha:WebInspector.Color.Format.HEXAlpha;case WebInspector.Color.Format.ShortHEX:return WebInspector.Color.Format.HEX;case WebInspector.Color.Format.ShortHEXAlpha:return WebInspector.Color.Format.HEXAlpha;case WebInspector.Color.Format.Keyword:if(this.simple)
return this.canBeSerializedAsShortHEX()?WebInspector.Color.Format.ShortHEX:WebInspector.Color.Format.HEX;return this.canBeSerializedAsShortHEX()?WebInspector.Color.Format.ShortHEXAlpha:WebInspector.Color.Format.HEXAlpha;default:console.error("Unknown color format.");return null;}}
get alpha()
{return this._rgba?this._rgba[3]:this._hsla[3];}
get simple()
{return this.alpha===1;}
get rgb()
{let rgb=this.rgba.slice();rgb.pop();return rgb;}
get hsl()
{let hsl=this.hsla.slice();hsl.pop();return hsl;}
get rgba()
{if(!this._rgba)
this._rgba=this._hslaToRGBA(this._hsla);return this._rgba;}
get hsla()
{if(!this._hsla)
this._hsla=this._rgbaToHSLA(this.rgba);return this._hsla;}
copy()
{switch(this.format){case WebInspector.Color.Format.RGB:case WebInspector.Color.Format.HEX:case WebInspector.Color.Format.ShortHEX:case WebInspector.Color.Format.HEXAlpha:case WebInspector.Color.Format.ShortHEXAlpha:case WebInspector.Color.Format.Keyword:case WebInspector.Color.Format.RGBA:return new WebInspector.Color(this.format,this.rgba);case WebInspector.Color.Format.HSL:case WebInspector.Color.Format.HSLA:return new WebInspector.Color(this.format,this.hsla);}}
toString(format)
{if(!format)
format=this.format;switch(format){case WebInspector.Color.Format.Original:return this._toOriginalString();case WebInspector.Color.Format.RGB:return this._toRGBString();case WebInspector.Color.Format.RGBA:return this._toRGBAString();case WebInspector.Color.Format.HSL:return this._toHSLString();case WebInspector.Color.Format.HSLA:return this._toHSLAString();case WebInspector.Color.Format.HEX:return this._toHEXString();case WebInspector.Color.Format.ShortHEX:return this._toShortHEXString();case WebInspector.Color.Format.HEXAlpha:return this._toHEXAlphaString();case WebInspector.Color.Format.ShortHEXAlpha:return this._toShortHEXAlphaString();case WebInspector.Color.Format.Keyword:return this._toKeywordString();}
throw"invalid color format";}
isKeyword()
{if(this.keyword)
return true;if(!this.simple)
return Array.shallowEqual(this._rgba,[0,0,0,0])||Array.shallowEqual(this._hsla,[0,0,0,0]);let rgb=(this._rgba&&this._rgba.slice(0,3))||this._hslToRGB(this._hsla);return Object.keys(WebInspector.Color.Keywords).some(key=>Array.shallowEqual(WebInspector.Color.Keywords[key],rgb));}
canBeSerializedAsShortHEX()
{let rgba=this.rgba||this._hslaToRGBA(this._hsla);let r=this._componentToHexValue(rgba[0]);if(r[0]!==r[1])
return false;let g=this._componentToHexValue(rgba[1]);if(g[0]!==g[1])
return false;let b=this._componentToHexValue(rgba[2]);if(b[0]!==b[1])
return false;if(!this.simple){let a=this._componentToHexValue(Math.round(rgba[3]*255));if(a[0]!==a[1])
return false;}
return true;} 
_toOriginalString()
{return this.original||this._toKeywordString();}
_toKeywordString()
{if(this.keyword)
return this.keyword;let rgba=this.rgba;if(!this.simple){if(rgba[0]===0&&rgba[1]===0&&rgba[2]===0&&rgba[3]===0)
return"transparent";return this._toRGBAString();}
let keywords=WebInspector.Color.Keywords;for(let keyword in keywords){if(!keywords.hasOwnProperty(keyword))
continue;let keywordRGB=keywords[keyword];if(keywordRGB[0]===rgba[0]&&keywordRGB[1]===rgba[1]&&keywordRGB[2]===rgba[2])
return keyword;}
return this._toRGBString();}
_toShortHEXString()
{if(!this.simple)
return this._toRGBAString();let rgba=this.rgba;let r=this._componentToHexValue(rgba[0]);let g=this._componentToHexValue(rgba[1]);let b=this._componentToHexValue(rgba[2]);if(r[0]===r[1]&&g[0]===g[1]&&b[0]===b[1])
return"#"+r[0]+g[0]+b[0];else
return"#"+r+g+b;}
_toHEXString()
{if(!this.simple)
return this._toRGBAString();let rgba=this.rgba;let r=this._componentToHexValue(rgba[0]);let g=this._componentToHexValue(rgba[1]);let b=this._componentToHexValue(rgba[2]);return"#"+r+g+b;}
_toShortHEXAlphaString()
{let rgba=this.rgba;let r=this._componentToHexValue(rgba[0]);let g=this._componentToHexValue(rgba[1]);let b=this._componentToHexValue(rgba[2]);let a=this._componentToHexValue(Math.round(rgba[3]*255));if(r[0]===r[1]&&g[0]===g[1]&&b[0]===b[1]&&a[0]===a[1])
return"#"+r[0]+g[0]+b[0]+a[0];else
return"#"+r+g+b+a;}
_toHEXAlphaString()
{let rgba=this.rgba;let r=this._componentToHexValue(rgba[0]);let g=this._componentToHexValue(rgba[1]);let b=this._componentToHexValue(rgba[2]);let a=this._componentToHexValue(Math.round(rgba[3]*255));return"#"+r+g+b+a;}
_toRGBString()
{if(!this.simple)
return this._toRGBAString();let rgba=this.rgba.slice(0,-1);rgba=rgba.map((value)=>value.maxDecimals(2));return"rgb("+rgba.join(", ")+")";}
_toRGBAString()
{let rgba=this.rgba;rgba=rgba.map((value)=>value.maxDecimals(2));return"rgba("+rgba.join(", ")+")";}
_toHSLString()
{if(!this.simple)
return this._toHSLAString();let hsla=this.hsla;hsla=hsla.map((value)=>value.maxDecimals(2));return"hsl("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%)";}
_toHSLAString()
{let hsla=this.hsla;hsla=hsla.map((value)=>value.maxDecimals(2));return"hsla("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%, "+hsla[3]+")";}
_componentToNumber(value)
{return Number.constrain(value,0,255);}
_componentToHexValue(value)
{let hex=this._componentToNumber(value).toString(16);if(hex.length===1)
hex="0"+hex;return hex;}
_rgbToHSL(rgb)
{let r=this._componentToNumber(rgb[0])/255;let g=this._componentToNumber(rgb[1])/255;let b=this._componentToNumber(rgb[2])/255;let max=Math.max(r,g,b);let min=Math.min(r,g,b);let diff=max-min;let add=max+min;let h;let s;let l=0.5*add;if(min===max)
h=0;else if(r===max)
h=((60*(g-b)/diff)+360)%360;else if(g===max)
h=(60*(b-r)/diff)+120;else
h=(60*(r-g)/diff)+240;if(l===0)
s=0;else if(l===1)
s=1;else if(l<=0.5)
s=diff/add;else
s=diff/(2-add);return[Math.round(h),Math.round(s*100),Math.round(l*100)];}
_hslToRGB(hsl)
{let h=parseFloat(hsl[0])/360;let s=parseFloat(hsl[1])/100;let l=parseFloat(hsl[2])/100;h*=6;let sArray=[l+=s*=l<.5?l:1-l,l-h%1*s*2,l-=s*=2,l,l+h%1*s,l+s];return[Math.round(sArray[~~h%6]*255),Math.round(sArray[(h|16)%6]*255),Math.round(sArray[(h|8)%6]*255)];}
_rgbaToHSLA(rgba)
{let hsl=this._rgbToHSL(rgba);hsl.push(rgba[3]);return hsl;}
_hslaToRGBA(hsla)
{let rgba=this._hslToRGB(hsla);rgba.push(hsla[3]);return rgba;}};WebInspector.Color.Format={Original:"color-format-original",Keyword:"color-format-keyword",HEX:"color-format-hex",ShortHEX:"color-format-short-hex",HEXAlpha:"color-format-hex-alpha",ShortHEXAlpha:"color-format-short-hex-alpha",RGB:"color-format-rgb",RGBA:"color-format-rgba",HSL:"color-format-hsl",HSLA:"color-format-hsla"};WebInspector.Color.Keywords={"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"black":[0,0,0],"blanchedalmond":[255,235,205],"blue":[0,0,255],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[237,164,61],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"gray":[128,128,128],"green":[0,128,0],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"lime":[0,255,0],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"maroon":[128,0,0],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"navy":[0,0,128],"oldlace":[253,245,230],"olive":[128,128,0],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"purple":[128,0,128],"rebeccapurple":[102,51,153],"red":[255,0,0],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"silver":[192,192,192],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"teal":[0,128,128],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"white":[255,255,255],"whitesmoke":[245,245,245],"yellow":[255,255,0],"yellowgreen":[154,205,50]};WebInspector.ConsoleCommandResultMessage=class ConsoleCommandResult extends WebInspector.ConsoleMessage
{constructor(target,result,wasThrown,savedResultIndex,shouldRevealConsole=true)
{let source=WebInspector.ConsoleMessage.MessageSource.JS;let level=wasThrown?WebInspector.ConsoleMessage.MessageLevel.Error:WebInspector.ConsoleMessage.MessageLevel.Log;let type=WebInspector.ConsoleMessage.MessageType.Result;super(target,source,level,"",type,undefined,undefined,undefined,0,[result],undefined,undefined);this._savedResultIndex=savedResultIndex;this._shouldRevealConsole=shouldRevealConsole;if(this._savedResultIndex&&this._savedResultIndex>WebInspector.ConsoleCommandResultMessage.maximumSavedResultIndex)
WebInspector.ConsoleCommandResultMessage.maximumSavedResultIndex=this._savedResultIndex;} 
static clearMaximumSavedResultIndex()
{WebInspector.ConsoleCommandResultMessage.maximumSavedResultIndex=0;} 
get savedResultIndex()
{return this._savedResultIndex;}
get shouldRevealConsole()
{return this._shouldRevealConsole;}};WebInspector.ConsoleCommandResultMessage.maximumSavedResultIndex=0;WebInspector.ContentFlow=class ContentFlow extends WebInspector.Object
{constructor(documentNodeIdentifier,name,overset,contentNodes)
{super();this._documentNodeIdentifier=documentNodeIdentifier;this._name=name;this._overset=overset;this._contentNodes=contentNodes;} 
get id()
{return this._documentNodeIdentifier+":"+this._name;}
get documentNodeIdentifier()
{return this._documentNodeIdentifier;}
get name()
{return this._name;}
get overset()
{return this._overset;}
set overset(overset)
{if(this._overset===overset)
return;this._overset=overset;this.dispatchEventToListeners(WebInspector.ContentFlow.Event.FlowOversetWasChanged);}
get contentNodes()
{return this._contentNodes;}
insertContentNodeBefore(contentNode,referenceNode)
{var index=this._contentNodes.indexOf(referenceNode);this._contentNodes.splice(index,0,contentNode);this.dispatchEventToListeners(WebInspector.ContentFlow.Event.ContentNodeWasAdded,{node:contentNode,before:referenceNode});}
appendContentNode(contentNode)
{this._contentNodes.push(contentNode);this.dispatchEventToListeners(WebInspector.ContentFlow.Event.ContentNodeWasAdded,{node:contentNode});}
removeContentNode(contentNode)
{var index=this._contentNodes.indexOf(contentNode);this._contentNodes.splice(index,1);this.dispatchEventToListeners(WebInspector.ContentFlow.Event.ContentNodeWasRemoved,{node:contentNode});}};WebInspector.ContentFlow.Event={OversetWasChanged:"content-flow-overset-was-changed",ContentNodeWasAdded:"content-flow-content-node-was-added",ContentNodeWasRemoved:"content-flow-content-node-was-removed"};WebInspector.CookieStorageObject=class CookieStorageObject
{constructor(host)
{this._host=host;} 
static cookieMatchesResourceURL(cookie,resourceURL)
{var parsedURL=parseURL(resourceURL);if(!parsedURL||!WebInspector.CookieStorageObject.cookieDomainMatchesResourceDomain(cookie.domain,parsedURL.host))
return false;return parsedURL.path.startsWith(cookie.path)&&(!cookie.port||parsedURL.port===cookie.port)&&(!cookie.secure||parsedURL.scheme==="https");}
static cookieDomainMatchesResourceDomain(cookieDomain,resourceDomain)
{if(cookieDomain.charAt(0)!==".")
return resourceDomain===cookieDomain;return!!resourceDomain.match(new RegExp("^(?:[^\\.]+\\.)*"+cookieDomain.substring(1).escapeForRegExp()+"$"),"i");} 
get host()
{return this._host;}
saveIdentityToCookie(cookie)
{cookie[WebInspector.CookieStorageObject.CookieHostCookieKey]=this.host;}};WebInspector.CookieStorageObject.TypeIdentifier="cookie-storage";WebInspector.CookieStorageObject.CookieHostCookieKey="cookie-storage-host";WebInspector.DOMBreakpoint=class DOMBreakpoint extends WebInspector.Object
{constructor(domNodeOrInfo,type,disabled)
{super();if(domNodeOrInfo instanceof WebInspector.DOMNode){this._domNodeIdentifier=domNodeOrInfo.id;this._path=domNodeOrInfo.path();this._url=WebInspector.frameResourceManager.mainFrame.url;}else if(domNodeOrInfo&&typeof domNodeOrInfo==="object"){this._domNodeIdentifier=null;this._path=domNodeOrInfo.path;this._url=domNodeOrInfo.url;}
this._type=type;this._disabled=disabled||false;} 
get type(){return this._type;}
get url(){return this._url;}
get path(){return this._path;}
get disabled()
{return this._disabled;}
set disabled(disabled)
{if(this._disabled===disabled)
return;this._disabled=disabled;this.dispatchEventToListeners(WebInspector.DOMBreakpoint.Event.DisabledStateDidChange);}
get domNodeIdentifier()
{return this._domNodeIdentifier;}
set domNodeIdentifier(nodeIdentifier)
{if(this._domNodeIdentifier===nodeIdentifier)
return;let data={};if(!nodeIdentifier)
data.oldNodeIdentifier=this._domNodeIdentifier;this._domNodeIdentifier=nodeIdentifier;this.dispatchEventToListeners(WebInspector.DOMBreakpoint.Event.ResolvedStateDidChange,data);}
get serializableInfo()
{let info={url:this._url,path:this._path,type:this._type};if(this._disabled)
info.disabled=true;return info;}
saveIdentityToCookie(cookie)
{cookie[WebInspector.DOMBreakpoint.DocumentURLCookieKey]=this.url;cookie[WebInspector.DOMBreakpoint.NodePathCookieKey]=this.path;cookie[WebInspector.DOMBreakpoint.TypeCookieKey]=this.type;}};WebInspector.DOMBreakpoint.DocumentURLCookieKey="dom-breakpoint-document-url";WebInspector.DOMBreakpoint.NodePathCookieKey="dom-breakpoint-node-path";WebInspector.DOMBreakpoint.TypeCookieKey="dom-breakpoint-type";WebInspector.DOMBreakpoint.Type={SubtreeModified:"subtree-modified",AttributeModified:"attribute-modified",NodeRemoved:"node-removed",};WebInspector.DOMBreakpoint.Event={DisabledStateDidChange:"dom-breakpoint-disabled-state-did-change",ResolvedStateDidChange:"dom-breakpoint-resolved-state-did-change",};WebInspector.DOMNode=class DOMNode extends WebInspector.Object
{constructor(domTreeManager,doc,isInShadowTree,payload)
{super();this._domTreeManager=domTreeManager;this._isInShadowTree=isInShadowTree;this.id=payload.nodeId;this._domTreeManager._idToDOMNode[this.id]=this;this._nodeType=payload.nodeType;this._nodeName=payload.nodeName;this._localName=payload.localName;this._nodeValue=payload.nodeValue;this._pseudoType=payload.pseudoType;this._shadowRootType=payload.shadowRootType;this._computedRole=payload.role;this._contentSecurityPolicyHash=payload.contentSecurityPolicyHash;if(this._nodeType===Node.DOCUMENT_NODE)
this.ownerDocument=this;else
this.ownerDocument=doc;this._attributes=[];this._attributesMap=new Map;if(payload.attributes)
this._setAttributesPayload(payload.attributes);this._childNodeCount=payload.childNodeCount;this._children=null;this._filteredChildren=null;this._filteredChildrenNeedsUpdating=true;this._nextSibling=null;this._previousSibling=null;this.parentNode=null;this._enabledPseudoClasses=[];

this._shadowRoots=[];if(payload.shadowRoots){for(var i=0;i<payload.shadowRoots.length;++i){var root=payload.shadowRoots[i];var node=new WebInspector.DOMNode(this._domTreeManager,this.ownerDocument,true,root);node.parentNode=this;this._shadowRoots.push(node);}}
if(payload.children)
this._setChildrenPayload(payload.children);else if(this._shadowRoots.length&&!this._childNodeCount)
this._children=this._shadowRoots.slice();if(this._nodeType===Node.ELEMENT_NODE)
this._customElementState=payload.customElementState||WebInspector.DOMNode.CustomElementState.Builtin;else
this._customElementState=null;if(payload.templateContent){this._templateContent=new WebInspector.DOMNode(this._domTreeManager,this.ownerDocument,false,payload.templateContent);this._templateContent.parentNode=this;}
this._pseudoElements=new Map;if(payload.pseudoElements){for(var i=0;i<payload.pseudoElements.length;++i){var node=new WebInspector.DOMNode(this._domTreeManager,this.ownerDocument,this._isInShadowTree,payload.pseudoElements[i]);node.parentNode=this;this._pseudoElements.set(node.pseudoType(),node);}}
if(payload.contentDocument){this._contentDocument=new WebInspector.DOMNode(this._domTreeManager,null,false,payload.contentDocument);this._children=[this._contentDocument];this._renumber();}
if(payload.frameId)
this._frameIdentifier=payload.frameId;if(this._nodeType===Node.ELEMENT_NODE){if(this.ownerDocument&&!this.ownerDocument.documentElement&&this._nodeName==="HTML")
this.ownerDocument.documentElement=this;if(this.ownerDocument&&!this.ownerDocument.body&&this._nodeName==="BODY")
this.ownerDocument.body=this;if(payload.documentURL)
this.documentURL=payload.documentURL;}else if(this._nodeType===Node.DOCUMENT_TYPE_NODE){this.publicId=payload.publicId;this.systemId=payload.systemId;}else if(this._nodeType===Node.DOCUMENT_NODE){this.documentURL=payload.documentURL;this.xmlVersion=payload.xmlVersion;}else if(this._nodeType===Node.ATTRIBUTE_NODE){this.name=payload.name;this.value=payload.value;}} 
get frameIdentifier()
{return this._frameIdentifier||this.ownerDocument.frameIdentifier;}
get frame()
{if(!this._frame)
this._frame=WebInspector.frameResourceManager.frameForIdentifier(this.frameIdentifier);return this._frame;}
get children()
{if(!this._children)
return null;if(WebInspector.showShadowDOMSetting.value)
return this._children;if(this._filteredChildrenNeedsUpdating){this._filteredChildrenNeedsUpdating=false;this._filteredChildren=this._children.filter(function(node){return!node._isInShadowTree;});}
return this._filteredChildren;}
get firstChild()
{var children=this.children;if(children&&children.length>0)
return children[0];return null;}
get lastChild()
{var children=this.children;if(children&&children.length>0)
return children.lastValue;return null;}
get nextSibling()
{if(WebInspector.showShadowDOMSetting.value)
return this._nextSibling;var node=this._nextSibling;while(node){if(!node._isInShadowTree)
return node;node=node._nextSibling;}
return null;}
get previousSibling()
{if(WebInspector.showShadowDOMSetting.value)
return this._previousSibling;var node=this._previousSibling;while(node){if(!node._isInShadowTree)
return node;node=node._previousSibling;}
return null;}
get childNodeCount()
{var children=this.children;if(children)
return children.length;if(WebInspector.showShadowDOMSetting.value)
return this._childNodeCount+this._shadowRoots.length;return this._childNodeCount;}
set childNodeCount(count)
{this._childNodeCount=count;}
computedRole()
{return this._computedRole;}
contentSecurityPolicyHash()
{return this._contentSecurityPolicyHash;}
hasAttributes()
{return this._attributes.length>0;}
hasChildNodes()
{return this.childNodeCount>0;}
hasShadowRoots()
{return!!this._shadowRoots.length;}
isInShadowTree()
{return this._isInShadowTree;}
isInUserAgentShadowTree()
{return this._isInShadowTree&&this.ancestorShadowRoot().isUserAgentShadowRoot();}
isCustomElement()
{return this._customElementState===WebInspector.DOMNode.CustomElementState.Custom;}
customElementState()
{return this._customElementState;}
isShadowRoot()
{return!!this._shadowRootType;}
isUserAgentShadowRoot()
{return this._shadowRootType===WebInspector.DOMNode.ShadowRootType.UserAgent;}
ancestorShadowRoot()
{if(!this._isInShadowTree)
return null;let node=this;while(node&&!node.isShadowRoot())
node=node.parentNode;return node;}
ancestorShadowHost()
{let shadowRoot=this.ancestorShadowRoot();return shadowRoot?shadowRoot.parentNode:null;}
isPseudoElement()
{return this._pseudoType!==undefined;}
nodeType()
{return this._nodeType;}
nodeName()
{return this._nodeName;}
nodeNameInCorrectCase()
{return this.isXMLNode()?this.nodeName():this.nodeName().toLowerCase();}
setNodeName(name,callback)
{DOMAgent.setNodeName(this.id,name,this._makeUndoableCallback(callback));}
localName()
{return this._localName;}
templateContent()
{return this._templateContent||null;}
pseudoType()
{return this._pseudoType;}
hasPseudoElements()
{return this._pseudoElements.size>0;}
pseudoElements()
{return this._pseudoElements;}
beforePseudoElement()
{return this._pseudoElements.get(WebInspector.DOMNode.PseudoElementType.Before)||null;}
afterPseudoElement()
{return this._pseudoElements.get(WebInspector.DOMNode.PseudoElementType.After)||null;}
shadowRoots()
{return this._shadowRoots;}
shadowRootType()
{return this._shadowRootType;}
nodeValue()
{return this._nodeValue;}
setNodeValue(value,callback)
{DOMAgent.setNodeValue(this.id,value,this._makeUndoableCallback(callback));}
getAttribute(name)
{let attr=this._attributesMap.get(name);return attr?attr.value:undefined;}
setAttribute(name,text,callback)
{DOMAgent.setAttributesAsText(this.id,text,name,this._makeUndoableCallback(callback));}
setAttributeValue(name,value,callback)
{DOMAgent.setAttributeValue(this.id,name,value,this._makeUndoableCallback(callback));}
attributes()
{return this._attributes;}
removeAttribute(name,callback)
{function mycallback(error,success)
{if(!error){this._attributesMap.delete(name);for(var i=0;i<this._attributes.length;++i){if(this._attributes[i].name===name){this._attributes.splice(i,1);break;}}}
this._makeUndoableCallback(callback)(error);}
DOMAgent.removeAttribute(this.id,name,mycallback.bind(this));}
toggleClass(className,flag)
{if(!className||!className.length)
return;if(this.isPseudoElement()){this.parentNode.toggleClass(className,flag);return;}
if(this.nodeType()!==Node.ELEMENT_NODE)
return;function resolvedNode(object)
{if(!object)
return;function inspectedPage_node_toggleClass(className,flag)
{this.classList.toggle(className,flag);}
object.callFunction(inspectedPage_node_toggleClass,[className,flag]);object.release();}
WebInspector.RemoteObject.resolveNode(this,"",resolvedNode);}
getChildNodes(callback)
{if(this.children){if(callback)
callback(this.children);return;}
function mycallback(error){if(!error&&callback)
callback(this.children);}
DOMAgent.requestChildNodes(this.id,mycallback.bind(this));}
getSubtree(depth,callback)
{function mycallback(error)
{if(callback)
callback(error?null:this.children);}
DOMAgent.requestChildNodes(this.id,depth,mycallback.bind(this));}
getOuterHTML(callback)
{DOMAgent.getOuterHTML(this.id,callback);}
setOuterHTML(html,callback)
{DOMAgent.setOuterHTML(this.id,html,this._makeUndoableCallback(callback));}
removeNode(callback)
{DOMAgent.removeNode(this.id,this._makeUndoableCallback(callback));}
copyNode()
{function copy(error,text)
{if(!error)
InspectorFrontendHost.copyText(text);}
DOMAgent.getOuterHTML(this.id,copy);}
getEventListeners(callback)
{DOMAgent.getEventListenersForNode(this.id,callback);}
accessibilityProperties(callback)
{function accessibilityPropertiesCallback(error,accessibilityProperties)
{if(!error&&callback&&accessibilityProperties){callback({activeDescendantNodeId:accessibilityProperties.activeDescendantNodeId,busy:accessibilityProperties.busy,checked:accessibilityProperties.checked,childNodeIds:accessibilityProperties.childNodeIds,controlledNodeIds:accessibilityProperties.controlledNodeIds,current:accessibilityProperties.current,disabled:accessibilityProperties.disabled,exists:accessibilityProperties.exists,expanded:accessibilityProperties.expanded,flowedNodeIds:accessibilityProperties.flowedNodeIds,focused:accessibilityProperties.focused,ignored:accessibilityProperties.ignored,ignoredByDefault:accessibilityProperties.ignoredByDefault,invalid:accessibilityProperties.invalid,isPopupButton:accessibilityProperties.isPopUpButton,headingLevel:accessibilityProperties.headingLevel,hierarchyLevel:accessibilityProperties.hierarchyLevel,hidden:accessibilityProperties.hidden,label:accessibilityProperties.label,liveRegionAtomic:accessibilityProperties.liveRegionAtomic,liveRegionRelevant:accessibilityProperties.liveRegionRelevant,liveRegionStatus:accessibilityProperties.liveRegionStatus,mouseEventNodeId:accessibilityProperties.mouseEventNodeId,nodeId:accessibilityProperties.nodeId,ownedNodeIds:accessibilityProperties.ownedNodeIds,parentNodeId:accessibilityProperties.parentNodeId,pressed:accessibilityProperties.pressed,readonly:accessibilityProperties.readonly,required:accessibilityProperties.required,role:accessibilityProperties.role,selected:accessibilityProperties.selected,selectedChildNodeIds:accessibilityProperties.selectedChildNodeIds});}}
DOMAgent.getAccessibilityPropertiesForNode(this.id,accessibilityPropertiesCallback.bind(this));}
path()
{var path=[];var node=this;while(node&&"index"in node&&node._nodeName.length){path.push([node.index,node._nodeName]);node=node.parentNode;}
path.reverse();return path.join(",");}
get escapedIdSelector()
{let id=this.getAttribute("id");if(!id)
return"";id=id.trim();if(!id.length)
return"";id=CSS.escape(id);if(/[\s'"]/.test(id))
return`[id=\"${id}\"]`;return`#${id}`;}
get escapedClassSelector()
{let classes=this.getAttribute("class");if(!classes)
return"";classes=classes.trim();if(!classes.length)
return"";let foundClasses=new Set;return classes.split(/\s+/).reduce((selector,className)=>{if(!className.length||foundClasses.has(className))
return selector;foundClasses.add(className);return`${selector}.${CSS.escape(className)}`;},"");}
get displayName()
{return this.nodeNameInCorrectCase()+this.escapedIdSelector+this.escapedClassSelector;}
appropriateSelectorFor(justSelector)
{if(this.isPseudoElement())
return this.parentNode.appropriateSelectorFor()+"::"+this._pseudoType;let lowerCaseName=this.localName()||this.nodeName().toLowerCase();let id=this.escapedIdSelector;if(id.length)
return justSelector?id:lowerCaseName+id;let classes=this.escapedClassSelector;if(classes.length)
return justSelector?classes:lowerCaseName+classes;if(lowerCaseName==="input"&&this.getAttribute("type"))
return lowerCaseName+"[type=\""+this.getAttribute("type")+"\"]";return lowerCaseName;}
isAncestor(node)
{if(!node)
return false;var currentNode=node.parentNode;while(currentNode){if(this===currentNode)
return true;currentNode=currentNode.parentNode;}
return false;}
isDescendant(descendant)
{return descendant!==null&&descendant.isAncestor(this);}
get ownerSVGElement()
{if(this._nodeName==="svg")
return this;if(!this.parentNode)
return null;return this.parentNode.ownerSVGElement;}
isSVGElement()
{return!!this.ownerSVGElement;}
_setAttributesPayload(attrs)
{this._attributes=[];this._attributesMap=new Map;for(var i=0;i<attrs.length;i+=2)
this._addAttribute(attrs[i],attrs[i+1]);}
_insertChild(prev,payload)
{var node=new WebInspector.DOMNode(this._domTreeManager,this.ownerDocument,this._isInShadowTree,payload);if(!prev){if(!this._children){ this._children=this._shadowRoots.concat([node]);}else
this._children.unshift(node);}else
this._children.splice(this._children.indexOf(prev)+1,0,node);this._renumber();return node;}
_removeChild(node)
{if(node.isPseudoElement()){this._pseudoElements.delete(node.pseudoType());node.parentNode=null;}else{this._children.splice(this._children.indexOf(node),1);node.parentNode=null;this._renumber();}}
_setChildrenPayload(payloads)
{if(this._contentDocument)
return;this._children=this._shadowRoots.slice();for(var i=0;i<payloads.length;++i){var node=new WebInspector.DOMNode(this._domTreeManager,this.ownerDocument,this._isInShadowTree,payloads[i]);this._children.push(node);}
this._renumber();}
_renumber()
{this._filteredChildrenNeedsUpdating=true;var childNodeCount=this._children.length;if(childNodeCount===0)
return;for(var i=0;i<childNodeCount;++i){var child=this._children[i];child.index=i;child._nextSibling=i+1<childNodeCount?this._children[i+1]:null;child._previousSibling=i-1>=0?this._children[i-1]:null;child.parentNode=this;}}
_addAttribute(name,value)
{let attr={name,value,_node:this};this._attributesMap.set(name,attr);this._attributes.push(attr);}
_setAttribute(name,value)
{let attr=this._attributesMap.get(name);if(attr)
attr.value=value;else
this._addAttribute(name,value);}
_removeAttribute(name)
{let attr=this._attributesMap.get(name);if(attr){this._attributes.remove(attr);this._attributesMap.delete(name);}}
moveTo(targetNode,anchorNode,callback)
{DOMAgent.moveTo(this.id,targetNode.id,anchorNode?anchorNode.id:undefined,this._makeUndoableCallback(callback));}
isXMLNode()
{return!!this.ownerDocument&&!!this.ownerDocument.xmlVersion;}
get enabledPseudoClasses()
{return this._enabledPseudoClasses;}
setPseudoClassEnabled(pseudoClass,enabled)
{var pseudoClasses=this._enabledPseudoClasses;if(enabled){if(pseudoClasses.includes(pseudoClass))
return;pseudoClasses.push(pseudoClass);}else{if(!pseudoClasses.includes(pseudoClass))
return;pseudoClasses.remove(pseudoClass);}
function changed(error)
{if(!error)
this.dispatchEventToListeners(WebInspector.DOMNode.Event.EnabledPseudoClassesChanged);}
CSSAgent.forcePseudoState(this.id,pseudoClasses,changed.bind(this));}
_makeUndoableCallback(callback)
{return function(error)
{if(!error)
DOMAgent.markUndoableState();if(callback)
callback.apply(null,arguments);};}};WebInspector.DOMNode.Event={EnabledPseudoClassesChanged:"dom-node-enabled-pseudo-classes-did-change",AttributeModified:"dom-node-attribute-modified",AttributeRemoved:"dom-node-attribute-removed"};WebInspector.DOMNode.PseudoElementType={Before:"before",After:"after",};WebInspector.DOMNode.ShadowRootType={UserAgent:"user-agent",Closed:"closed",Open:"open",};WebInspector.DOMNode.CustomElementState={Builtin:"builtin",Custom:"custom",Waiting:"waiting",Failed:"failed",};WebInspector.DOMNodeStyles=class DOMNodeStyles extends WebInspector.Object
{constructor(node)
{super();this._node=node||null;this._rulesMap={};this._styleDeclarationsMap={};this._matchedRules=[];this._inheritedRules=[];this._pseudoElements={};this._inlineStyle=null;this._attributesStyle=null;this._computedStyle=null;this._orderedStyles=[];this._propertyNameToEffectivePropertyMap={};this._pendingRefreshTask=null;this.refresh();} 
get node()
{return this._node;}
get needsRefresh()
{return this._pendingRefreshTask||this._needsRefresh;}
refreshIfNeeded()
{if(!this._needsRefresh)
return;this.refresh();}
refresh()
{if(this._pendingRefreshTask)
return this._pendingRefreshTask;this._needsRefresh=false;let fetchedMatchedStylesPromise=new WebInspector.WrappedPromise;let fetchedInlineStylesPromise=new WebInspector.WrappedPromise;let fetchedComputedStylesPromise=new WebInspector.WrappedPromise;function wrap(func,promise){return(...args)=>{try{func.apply(this,args);}catch(e){console.error(e);promise.resolve();}};}
function parseRuleMatchArrayPayload(matchArray,node,inherited)
{var result=[];var ruleOccurrences={};for(var i=matchArray.length-1;i>=0;--i){var rule=this._parseRulePayload(matchArray[i].rule,matchArray[i].matchingSelectors,node,inherited,ruleOccurrences);if(!rule)
continue;result.push(rule);}
return result;}
function fetchedMatchedStyles(error,matchedRulesPayload,pseudoElementRulesPayload,inheritedRulesPayload)
{matchedRulesPayload=matchedRulesPayload||[];pseudoElementRulesPayload=pseudoElementRulesPayload||[];inheritedRulesPayload=inheritedRulesPayload||[];this._previousRulesMap=this._rulesMap;this._previousStyleDeclarationsMap=this._styleDeclarationsMap;this._rulesMap={};this._styleDeclarationsMap={};this._matchedRules=parseRuleMatchArrayPayload.call(this,matchedRulesPayload,this._node);this._pseudoElements={};for(var pseudoElementRulePayload of pseudoElementRulesPayload){var pseudoElementRules=parseRuleMatchArrayPayload.call(this,pseudoElementRulePayload.matches,this._node);this._pseudoElements[pseudoElementRulePayload.pseudoId]={matchedRules:pseudoElementRules};}
this._inheritedRules=[];var i=0;var currentNode=this._node.parentNode;while(currentNode&&i<inheritedRulesPayload.length){var inheritedRulePayload=inheritedRulesPayload[i];var inheritedRuleInfo={node:currentNode};inheritedRuleInfo.inlineStyle=inheritedRulePayload.inlineStyle?this._parseStyleDeclarationPayload(inheritedRulePayload.inlineStyle,currentNode,true,WebInspector.CSSStyleDeclaration.Type.Inline):null;inheritedRuleInfo.matchedRules=inheritedRulePayload.matchedCSSRules?parseRuleMatchArrayPayload.call(this,inheritedRulePayload.matchedCSSRules,currentNode,true):[];if(inheritedRuleInfo.inlineStyle||inheritedRuleInfo.matchedRules.length)
this._inheritedRules.push(inheritedRuleInfo);currentNode=currentNode.parentNode;++i;}
fetchedMatchedStylesPromise.resolve();}
function fetchedInlineStyles(error,inlineStylePayload,attributesStylePayload)
{this._inlineStyle=inlineStylePayload?this._parseStyleDeclarationPayload(inlineStylePayload,this._node,false,WebInspector.CSSStyleDeclaration.Type.Inline):null;this._attributesStyle=attributesStylePayload?this._parseStyleDeclarationPayload(attributesStylePayload,this._node,false,WebInspector.CSSStyleDeclaration.Type.Attribute):null;this._updateStyleCascade();fetchedInlineStylesPromise.resolve();}
function fetchedComputedStyle(error,computedPropertiesPayload)
{var properties=[];for(var i=0;computedPropertiesPayload&&i<computedPropertiesPayload.length;++i){var propertyPayload=computedPropertiesPayload[i];var canonicalName=WebInspector.cssStyleManager.canonicalNameForPropertyName(propertyPayload.name);propertyPayload.implicit=!this._propertyNameToEffectivePropertyMap[canonicalName];var property=this._parseStylePropertyPayload(propertyPayload,NaN,this._computedStyle);if(!property.implicit)
property.implicit=!this._isPropertyFoundInMatchingRules(property.name);properties.push(property);}
if(this._computedStyle)
this._computedStyle.update(null,properties);else
this._computedStyle=new WebInspector.CSSStyleDeclaration(this,null,null,WebInspector.CSSStyleDeclaration.Type.Computed,this._node,false,null,properties);let significantChange=false;for(let key in this._styleDeclarationsMap){if(key in this._previousStyleDeclarationsMap){if(Array.shallowEqual(this._styleDeclarationsMap[key],this._previousStyleDeclarationsMap[key]))
continue;
let styleFound=false;for(let style of this._styleDeclarationsMap[key]){if(this._previousStyleDeclarationsMap[key].includes(style)){styleFound=true;break;}}
if(styleFound)
continue;}
if(!this._includeUserAgentRulesOnNextRefresh){let firstStyle=this._styleDeclarationsMap[key][0];if(firstStyle&&firstStyle.ownerRule&&firstStyle.ownerRule.type===WebInspector.CSSStyleSheet.Type.UserAgent){

 continue;}}
significantChange=true;break;}
if(!significantChange){for(var key in this._previousStyleDeclarationsMap){if(key in this._styleDeclarationsMap)
continue;if(!this._includeUserAgentRulesOnNextRefresh){var firstStyle=this._previousStyleDeclarationsMap[key][0];if(firstStyle&&firstStyle.ownerRule&&firstStyle.ownerRule.type===WebInspector.CSSStyleSheet.Type.UserAgent)
continue;}
significantChange=true;break;}}
delete this._includeUserAgentRulesOnNextRefresh;delete this._previousRulesMap;delete this._previousStyleDeclarationsMap;this.dispatchEventToListeners(WebInspector.DOMNodeStyles.Event.Refreshed,{significantChange});fetchedComputedStylesPromise.resolve();}
WebInspector.cssStyleManager.fetchStyleSheetsIfNeeded();CSSAgent.getMatchedStylesForNode.invoke({nodeId:this._node.id,includePseudo:true,includeInherited:true},wrap.call(this,fetchedMatchedStyles,fetchedMatchedStylesPromise));CSSAgent.getInlineStylesForNode.invoke({nodeId:this._node.id},wrap.call(this,fetchedInlineStyles,fetchedInlineStylesPromise));CSSAgent.getComputedStyleForNode.invoke({nodeId:this._node.id},wrap.call(this,fetchedComputedStyle,fetchedComputedStylesPromise));this._pendingRefreshTask=Promise.all([fetchedMatchedStylesPromise.promise,fetchedInlineStylesPromise.promise,fetchedComputedStylesPromise.promise]).then(()=>{this._pendingRefreshTask=null;});return this._pendingRefreshTask;}
addRule(selector,text,styleSheetId)
{selector=selector||this._node.appropriateSelectorFor(true);function completed()
{DOMAgent.markUndoableState();this.refresh();}
function styleChanged(error,stylePayload)
{if(error)
return;completed.call(this);}
function addedRule(error,rulePayload)
{if(error)
return;if(!text||!text.length){completed.call(this);return;}
CSSAgent.setStyleText(rulePayload.style.styleId,text,styleChanged.bind(this));}
if(!CSSAgent.createStyleSheet){CSSAgent.addRule.invoke({contextNodeId:this._node.id,selector},addedRule.bind(this));return;}
function inspectorStyleSheetAvailable(styleSheet)
{if(!styleSheet)
return;CSSAgent.addRule(styleSheet.id,selector,addedRule.bind(this));}
if(styleSheetId)
inspectorStyleSheetAvailable.call(this,WebInspector.cssStyleManager.styleSheetForIdentifier(styleSheetId));else
WebInspector.cssStyleManager.preferredInspectorStyleSheetForFrame(this._node.frame,inspectorStyleSheetAvailable.bind(this));}
rulesForSelector(selector)
{selector=selector||this._node.appropriateSelectorFor(true);function ruleHasSelector(rule){return!rule.mediaList.length&&rule.selectorText===selector;}
let rules=this._matchedRules.filter(ruleHasSelector);for(let id in this._pseudoElements)
rules=rules.concat(this._pseudoElements[id].matchedRules.filter(ruleHasSelector));return rules;}
get matchedRules()
{return this._matchedRules;}
get inheritedRules()
{return this._inheritedRules;}
get inlineStyle()
{return this._inlineStyle;}
get attributesStyle()
{return this._attributesStyle;}
get pseudoElements()
{return this._pseudoElements;}
get computedStyle()
{return this._computedStyle;}
get orderedStyles()
{return this._orderedStyles;}
effectivePropertyForName(name)
{let property=this._propertyNameToEffectivePropertyMap[name];if(property)
return property;let canonicalName=WebInspector.cssStyleManager.canonicalNameForPropertyName(name);return this._propertyNameToEffectivePropertyMap[canonicalName]||null;} 
mediaQueryResultDidChange()
{this._markAsNeedsRefresh();}
pseudoClassesDidChange(node)
{this._includeUserAgentRulesOnNextRefresh=true;this._markAsNeedsRefresh();}
attributeDidChange(node,attributeName)
{this._markAsNeedsRefresh();}
changeRule(rule,selector,text)
{if(!rule)
return;selector=selector||"";function changeCompleted()
{DOMAgent.markUndoableState();this.refresh();}
function styleChanged(error,stylePayload)
{if(error)
return;changeCompleted.call(this);}
function changeText(styleId)
{if(!text||!text.length){changeCompleted.call(this);return;}
CSSAgent.setStyleText(styleId,text,styleChanged.bind(this));}
function ruleSelectorChanged(error,rulePayload)
{if(error)
return;changeText.call(this,rulePayload.style.styleId);}
this._needsRefresh=true;this._ignoreNextContentDidChangeForStyleSheet=rule.ownerStyleSheet;CSSAgent.setRuleSelector(rule.id,selector,ruleSelectorChanged.bind(this));}
changeRuleSelector(rule,selector)
{selector=selector||"";let result=new WebInspector.WrappedPromise;function ruleSelectorChanged(error,rulePayload)
{if(error){result.reject(error);return;}
DOMAgent.markUndoableState();
this.refresh().then(()=>{result.resolve(rulePayload);});}
this._needsRefresh=true;this._ignoreNextContentDidChangeForStyleSheet=rule.ownerStyleSheet;CSSAgent.setRuleSelector(rule.id,selector,ruleSelectorChanged.bind(this));return result.promise;}
changeStyleText(style,text)
{if(!style.ownerStyleSheet||!style.styleSheetTextRange)
return;text=text||"";function styleChanged(error,stylePayload)
{if(error)
return;this.refresh();}
CSSAgent.setStyleText(style.id,text,styleChanged.bind(this));} 
_createSourceCodeLocation(sourceURL,sourceLine,sourceColumn)
{if(!sourceURL)
return null;var sourceCode;if(this._node.ownerDocument){var mainResource=WebInspector.frameResourceManager.resourceForURL(this._node.ownerDocument.documentURL);if(mainResource){var parentFrame=mainResource.parentFrame;sourceCode=parentFrame.resourceForURL(sourceURL);}}
if(!sourceCode)
sourceCode=WebInspector.frameResourceManager.resourceForURL(sourceURL);if(!sourceCode)
return null;return sourceCode.createSourceCodeLocation(sourceLine||0,sourceColumn||0);}
_parseSourceRangePayload(payload)
{if(!payload)
return null;return new WebInspector.TextRange(payload.startLine,payload.startColumn,payload.endLine,payload.endColumn);}
_parseStylePropertyPayload(payload,index,styleDeclaration,styleText)
{var text=payload.text||"";var name=payload.name;var value=(payload.value||"").replace(/\s*!important\s*$/,"");var priority=payload.priority||"";var enabled=true;var overridden=false;var implicit=payload.implicit||false;var anonymous=false;var valid="parsedOk"in payload?payload.parsedOk:true;switch(payload.status||"style"){case"active":enabled=true;break;case"inactive":overridden=true;enabled=true;break;case"disabled":enabled=false;break;case"style":anonymous=true;break;}
var styleSheetTextRange=this._parseSourceRangePayload(payload.range);if(styleDeclaration){var property=isNaN(index)?styleDeclaration.propertyForName(name,true):styleDeclaration.properties[index];


if(property&&property.name===name&&(property.index===index||(isNaN(property.index)&&isNaN(index)))){property.update(text,name,value,priority,enabled,overridden,implicit,anonymous,valid,styleSheetTextRange);return property;}
var pendingProperties=styleDeclaration.pendingProperties;for(var i=0;i<pendingProperties.length;++i){var pendingProperty=pendingProperties[i];if(pendingProperty.name===name&&isNaN(pendingProperty.index)){pendingProperty.index=index;pendingProperty.update(text,name,value,priority,enabled,overridden,implicit,anonymous,valid,styleSheetTextRange);return pendingProperty;}}}
return new WebInspector.CSSProperty(index,text,name,value,priority,enabled,overridden,implicit,anonymous,valid,styleSheetTextRange);}
_parseStyleDeclarationPayload(payload,node,inherited,type,rule,updateAllStyles)
{if(!payload)
return null;rule=rule||null;inherited=inherited||false;var id=payload.styleId;var mapKey=id?id.styleSheetId+":"+id.ordinal:null;if(type===WebInspector.CSSStyleDeclaration.Type.Attribute)
mapKey=node.id+":attribute";var styleDeclaration=rule?rule.style:null;var styleDeclarations=[];var previousStyleDeclarationsMap=this._previousStyleDeclarationsMap||this._styleDeclarationsMap;if(mapKey&&mapKey in previousStyleDeclarationsMap){styleDeclarations=previousStyleDeclarationsMap[mapKey];if(updateAllStyles&&styleDeclarations.length){for(var i=0;i<styleDeclarations.length;++i){var styleDeclaration=styleDeclarations[i];this._parseStyleDeclarationPayload(payload,styleDeclaration.node,styleDeclaration.inherited,styleDeclaration.type,styleDeclaration.ownerRule);}
return null;}
if(!styleDeclaration){var filteredStyleDeclarations=styleDeclarations.filter(function(styleDeclaration){if(styleDeclaration.ownerRule){return false;}
if(styleDeclaration.node!==node)
return false;if(styleDeclaration.inherited!==inherited)
return false;return true;});styleDeclaration=filteredStyleDeclarations[0]||null;}}
if(previousStyleDeclarationsMap!==this._styleDeclarationsMap){styleDeclarations=mapKey&&mapKey in this._styleDeclarationsMap?this._styleDeclarationsMap[mapKey]:[];if(styleDeclaration&&!styleDeclarations.includes(styleDeclaration)){styleDeclarations.push(styleDeclaration);this._styleDeclarationsMap[mapKey]=styleDeclarations;}}
var shorthands={};for(var i=0;payload.shorthandEntries&&i<payload.shorthandEntries.length;++i){var shorthand=payload.shorthandEntries[i];shorthands[shorthand.name]=shorthand.value;}
var text=payload.cssText;var inheritedPropertyCount=0;var properties=[];for(var i=0;payload.cssProperties&&i<payload.cssProperties.length;++i){var propertyPayload=payload.cssProperties[i];if(inherited&&WebInspector.CSSProperty.isInheritedPropertyName(propertyPayload.name))
++inheritedPropertyCount;var property=this._parseStylePropertyPayload(propertyPayload,i,styleDeclaration,text);properties.push(property);}
var styleSheetTextRange=this._parseSourceRangePayload(payload.range);if(styleDeclaration){styleDeclaration.update(text,properties,styleSheetTextRange);return styleDeclaration;}
var styleSheet=id?WebInspector.cssStyleManager.styleSheetForIdentifier(id.styleSheetId):null;if(styleSheet){if(type===WebInspector.CSSStyleDeclaration.Type.Inline)
styleSheet.markAsInlineStyleAttributeStyleSheet();styleSheet.addEventListener(WebInspector.CSSStyleSheet.Event.ContentDidChange,this._styleSheetContentDidChange,this);}
if(inherited&&!inheritedPropertyCount)
return null;styleDeclaration=new WebInspector.CSSStyleDeclaration(this,styleSheet,id,type,node,inherited,text,properties,styleSheetTextRange);if(mapKey){styleDeclarations.push(styleDeclaration);this._styleDeclarationsMap[mapKey]=styleDeclarations;}
return styleDeclaration;}
_parseSelectorListPayload(selectorList)
{var selectors=selectorList.selectors;if(!selectors.length)
return[];if(typeof selectors[0]==="string"){return selectors.map(function(selectorText){return new WebInspector.CSSSelector(selectorText);});}
return selectors.map(function(selectorPayload){return new WebInspector.CSSSelector(selectorPayload.text,selectorPayload.specificity,selectorPayload.dynamic);});}
_parseRulePayload(payload,matchedSelectorIndices,node,inherited,ruleOccurrences)
{if(!payload)
return null;

var id=payload.ruleId||payload.style.styleId;var mapKey=id?id.styleSheetId+":"+id.ordinal+":"+(inherited?"I":"N")+":"+node.id:null;
var occurrence=0;if(mapKey){if(mapKey in ruleOccurrences)
occurrence=++ruleOccurrences[mapKey];else
ruleOccurrences[mapKey]=occurrence;mapKey+=":"+occurrence;}
var rule=null;var previousRulesMap=this._previousRulesMap||this._rulesMap;if(mapKey&&mapKey in previousRulesMap){rule=previousRulesMap[mapKey];if(previousRulesMap!==this._rulesMap){this._rulesMap[mapKey]=rule;}}
var style=this._parseStyleDeclarationPayload(payload.style,node,inherited,WebInspector.CSSStyleDeclaration.Type.Rule,rule);if(!style)
return null;var styleSheet=id?WebInspector.cssStyleManager.styleSheetForIdentifier(id.styleSheetId):null;var selectorText=payload.selectorList.text;var selectors=this._parseSelectorListPayload(payload.selectorList);var type=WebInspector.CSSStyleManager.protocolStyleSheetOriginToEnum(payload.origin);var sourceCodeLocation=null;var sourceRange=payload.selectorList.range;if(sourceRange)
sourceCodeLocation=this._createSourceCodeLocation(payload.sourceURL,sourceRange.startLine,sourceRange.startColumn);else{sourceCodeLocation=this._createSourceCodeLocation(payload.sourceURL,payload.sourceLine);}
if(styleSheet){if(!sourceCodeLocation&&styleSheet.isInspectorStyleSheet())
sourceCodeLocation=styleSheet.createSourceCodeLocation(sourceRange.startLine,sourceRange.startColumn)
sourceCodeLocation=styleSheet.offsetSourceCodeLocation(sourceCodeLocation);}
var mediaList=[];for(var i=0;payload.media&&i<payload.media.length;++i){var mediaItem=payload.media[i];var mediaType=WebInspector.CSSStyleManager.protocolMediaSourceToEnum(mediaItem.source);var mediaText=mediaItem.text;var mediaSourceCodeLocation=this._createSourceCodeLocation(mediaItem.sourceURL,mediaItem.sourceLine);if(styleSheet)
mediaSourceCodeLocation=styleSheet.offsetSourceCodeLocation(mediaSourceCodeLocation);mediaList.push(new WebInspector.CSSMedia(mediaType,mediaText,mediaSourceCodeLocation));}
if(rule){rule.update(sourceCodeLocation,selectorText,selectors,matchedSelectorIndices,style,mediaList);return rule;}
if(styleSheet)
styleSheet.addEventListener(WebInspector.CSSStyleSheet.Event.ContentDidChange,this._styleSheetContentDidChange,this);rule=new WebInspector.CSSRule(this,styleSheet,id,type,sourceCodeLocation,selectorText,selectors,matchedSelectorIndices,style,mediaList);if(mapKey)
this._rulesMap[mapKey]=rule;return rule;}
_markAsNeedsRefresh()
{this._needsRefresh=true;this.dispatchEventToListeners(WebInspector.DOMNodeStyles.Event.NeedsRefresh);}
_styleSheetContentDidChange(event)
{var styleSheet=event.target;if(!styleSheet)
return;if(styleSheet===this._ignoreNextContentDidChangeForStyleSheet){delete this._ignoreNextContentDidChangeForStyleSheet;return;}
this._markAsNeedsRefresh();}
_updateStyleCascade()
{var cascadeOrderedStyleDeclarations=this._collectStylesInCascadeOrder(this._matchedRules,this._inlineStyle,this._attributesStyle);for(var i=0;i<this._inheritedRules.length;++i){var inheritedStyleInfo=this._inheritedRules[i];var inheritedCascadeOrder=this._collectStylesInCascadeOrder(inheritedStyleInfo.matchedRules,inheritedStyleInfo.inlineStyle,null);cascadeOrderedStyleDeclarations=cascadeOrderedStyleDeclarations.concat(inheritedCascadeOrder);}
this._orderedStyles=cascadeOrderedStyleDeclarations;this._propertyNameToEffectivePropertyMap={};this._markOverriddenProperties(cascadeOrderedStyleDeclarations,this._propertyNameToEffectivePropertyMap);this._associateRelatedProperties(cascadeOrderedStyleDeclarations,this._propertyNameToEffectivePropertyMap);for(var pseudoIdentifier in this._pseudoElements){var pseudoElementInfo=this._pseudoElements[pseudoIdentifier];pseudoElementInfo.orderedStyles=this._collectStylesInCascadeOrder(pseudoElementInfo.matchedRules,null,null);this._markOverriddenProperties(pseudoElementInfo.orderedStyles);this._associateRelatedProperties(pseudoElementInfo.orderedStyles);}}
_collectStylesInCascadeOrder(matchedRules,inlineStyle,attributesStyle)
{var result=[];if(inlineStyle)
result.push(inlineStyle);var userAndUserAgentStyles=[];for(var i=0;i<matchedRules.length;++i){var rule=matchedRules[i];
switch(rule.type){case WebInspector.CSSStyleSheet.Type.Inspector:case WebInspector.CSSStyleSheet.Type.Author:result.push(rule.style);break;case WebInspector.CSSStyleSheet.Type.User:case WebInspector.CSSStyleSheet.Type.UserAgent:userAndUserAgentStyles.push(rule.style);break;}}
if(attributesStyle)
result.push(attributesStyle);result=result.concat(userAndUserAgentStyles);return result;}
_markOverriddenProperties(styles,propertyNameToEffectiveProperty)
{propertyNameToEffectiveProperty=propertyNameToEffectiveProperty||{};for(var i=0;i<styles.length;++i){var style=styles[i];var properties=style.properties;for(var j=0;j<properties.length;++j){var property=properties[j];if(!property.enabled||!property.valid){property.overridden=false;continue;}
if(style.inherited&&!property.inherited){property.overridden=false;continue;}
var canonicalName=property.canonicalName;if(canonicalName in propertyNameToEffectiveProperty){var effectiveProperty=propertyNameToEffectiveProperty[canonicalName];if(effectiveProperty.ownerStyle===property.ownerStyle){if(effectiveProperty.important&&!property.important){property.overridden=true;continue;}}else if(effectiveProperty.important||!property.important||effectiveProperty.ownerStyle.node!==property.ownerStyle.node){property.overridden=true;continue;}
if(!property.anonymous)
effectiveProperty.overridden=true;}
property.overridden=false;propertyNameToEffectiveProperty[canonicalName]=property;}}}
_associateRelatedProperties(styles,propertyNameToEffectiveProperty)
{for(var i=0;i<styles.length;++i){var properties=styles[i].properties;var knownShorthands={};for(var j=0;j<properties.length;++j){var property=properties[j];if(!property.valid)
continue;if(!WebInspector.CSSCompletions.cssNameCompletions.isShorthandPropertyName(property.name))
continue;if(knownShorthands[property.canonicalName]&&!knownShorthands[property.canonicalName].overridden){continue;}
knownShorthands[property.canonicalName]=property;}
for(var j=0;j<properties.length;++j){var property=properties[j];if(!property.valid)
continue;var shorthandProperty=null;if(!isEmptyObject(knownShorthands)){var possibleShorthands=WebInspector.CSSCompletions.cssNameCompletions.shorthandsForLonghand(property.canonicalName);for(var k=0;k<possibleShorthands.length;++k){if(possibleShorthands[k]in knownShorthands){shorthandProperty=knownShorthands[possibleShorthands[k]];break;}}}
if(!shorthandProperty||shorthandProperty.overridden!==property.overridden){property.relatedShorthandProperty=null;property.clearRelatedLonghandProperties();continue;}
shorthandProperty.addRelatedLonghandProperty(property);property.relatedShorthandProperty=shorthandProperty;if(propertyNameToEffectiveProperty&&propertyNameToEffectiveProperty[shorthandProperty.canonicalName]===shorthandProperty)
propertyNameToEffectiveProperty[property.canonicalName]=property;}}}
_isPropertyFoundInMatchingRules(propertyName)
{return this._orderedStyles.some((style)=>{return style.properties.some((property)=>property.name===propertyName);});}};WebInspector.DOMNodeStyles.Event={NeedsRefresh:"dom-node-styles-needs-refresh",Refreshed:"dom-node-styles-refreshed"};WebInspector.DOMSearchMatchObject=class DOMSearchMatchObject extends WebInspector.Object
{constructor(resource,domNode,title,searchTerm,textRange)
{super();this._resource=resource;this._domNode=domNode;this._title=title;this._searchTerm=searchTerm;this._sourceCodeTextRange=resource.createSourceCodeTextRange(textRange);} 
static titleForDOMNode(domNode)
{switch(domNode.nodeType()){case Node.ELEMENT_NODE:var title="<"+domNode.nodeNameInCorrectCase();for(var attribute of domNode.attributes()){title+=" "+attribute.name;if(attribute.value.length)
title+="=\""+attribute.value+"\"";}
return title+">";case Node.TEXT_NODE:return"\""+domNode.nodeValue()+"\"";case Node.COMMENT_NODE:return"<!--"+domNode.nodeValue()+"-->";case Node.DOCUMENT_TYPE_NODE:var title="<!DOCTYPE "+domNode.nodeName();if(domNode.publicId){title+=" PUBLIC \""+domNode.publicId+"\"";if(domNode.systemId)
title+=" \""+domNode.systemId+"\"";}else if(domNode.systemId)
title+=" SYSTEM \""+domNode.systemId+"\"";return title+">";case Node.CDATA_SECTION_NODE:return"<![CDATA["+domNode+"]]>";case Node.PROCESSING_INSTRUCTION_NODE:var data=domNode.nodeValue();var dataString=data.length?" "+data:"";var title="<?"+domNode.nodeNameInCorrectCase()+dataString+"?>";return title;default:console.error("Unknown DOM node type: ",domNode.nodeType());return domNode.nodeNameInCorrectCase();}} 
get resource()
{return this._resource;}
get domNode()
{return this._domNode;}
get title()
{return this._title;}
get className()
{if(!this._className)
this._className=this._generateClassName();return this._className;}
get searchTerm()
{return this._searchTerm;}
get sourceCodeTextRange()
{return this._sourceCodeTextRange;}
saveIdentityToCookie(cookie)
{cookie[WebInspector.DOMSearchMatchObject.URLCookieKey]=this._resource.url.hash;cookie[WebInspector.DOMSearchMatchObject.TitleKey]=this._title;var textRange=this._sourceCodeTextRange.textRange;cookie[WebInspector.DOMSearchMatchObject.TextRangeKey]=[textRange.startLine,textRange.startColumn,textRange.endLine,textRange.endColumn].join();} 
_generateClassName()
{switch(this._domNode.nodeType()){case Node.ELEMENT_NODE:return WebInspector.DOMSearchMatchObject.DOMMatchElementIconStyleClassName;case Node.TEXT_NODE:return WebInspector.DOMSearchMatchObject.DOMMatchTextNodeIconStyleClassName;case Node.COMMENT_NODE:return WebInspector.DOMSearchMatchObject.DOMMatchCommentIconStyleClassName;case Node.DOCUMENT_TYPE_NODE:return WebInspector.DOMSearchMatchObject.DOMMatchDocumentTypeIconStyleClassName;case Node.CDATA_SECTION_NODE:return WebInspector.DOMSearchMatchObject.DOMMatchCharacterDataIconStyleClassName;case Node.PROCESSING_INSTRUCTION_NODE: return WebInspector.DOMSearchMatchObject.DOMMatchDocumentTypeIconStyleClassName;default:console.error("Unknown DOM node type: ",this._domNode.nodeType());return WebInspector.DOMSearchMatchObject.DOMMatchNodeIconStyleClassName;}}};WebInspector.DOMSearchMatchObject.DOMMatchElementIconStyleClassName="dom-match-element-icon";WebInspector.DOMSearchMatchObject.DOMMatchTextNodeIconStyleClassName="dom-match-text-node-icon";WebInspector.DOMSearchMatchObject.DOMMatchCommentIconStyleClassName="dom-match-comment-icon";WebInspector.DOMSearchMatchObject.DOMMatchDocumentTypeIconStyleClassName="dom-match-document-type-icon";WebInspector.DOMSearchMatchObject.DOMMatchCharacterDataIconStyleClassName="dom-match-character-data-icon";WebInspector.DOMSearchMatchObject.DOMMatchNodeIconStyleClassName="dom-match-node-icon";WebInspector.DOMSearchMatchObject.TypeIdentifier="dom-search-match-object";WebInspector.DOMSearchMatchObject.URLCookieKey="resource-url";WebInspector.DOMSearchMatchObject.TitleKey="title";WebInspector.DOMSearchMatchObject.TextRangeKey="text-range";WebInspector.DOMStorageObject=class DOMStorageObject extends WebInspector.Object
{constructor(id,host,isLocalStorage)
{super();this._id=id;this._host=host;this._isLocalStorage=isLocalStorage;this._entries=new Map;} 
get id(){return this._id;}
get host(){return this._host;}
get entries(){return this._entries;}
saveIdentityToCookie(cookie)
{cookie[WebInspector.DOMStorageObject.HostCookieKey]=this.host;cookie[WebInspector.DOMStorageObject.LocalStorageCookieKey]=this.isLocalStorage();}
isLocalStorage()
{return this._isLocalStorage;}
getEntries(callback)
{function innerCallback(error,entries)
{if(error)
return;for(let[key,value]of entries){if(!key||!value)
continue;this._entries.set(key,value);}
callback(error,entries);}
DOMStorageAgent.getDOMStorageItems(this._id,innerCallback.bind(this));}
removeItem(key)
{DOMStorageAgent.removeDOMStorageItem(this._id,key);}
setItem(key,value)
{DOMStorageAgent.setDOMStorageItem(this._id,key,value);}
itemsCleared()
{this._entries.clear();this.dispatchEventToListeners(WebInspector.DOMStorageObject.Event.ItemsCleared);}
itemRemoved(key)
{this._entries.delete(key);this.dispatchEventToListeners(WebInspector.DOMStorageObject.Event.ItemRemoved,{key});}
itemAdded(key,value)
{this._entries.set(key,value);this.dispatchEventToListeners(WebInspector.DOMStorageObject.Event.ItemAdded,{key,value});}
itemUpdated(key,oldValue,value)
{this._entries.set(key,value);this.dispatchEventToListeners(WebInspector.DOMStorageObject.Event.ItemUpdated,{key,oldValue,value});}};WebInspector.DOMStorageObject.TypeIdentifier="dom-storage";WebInspector.DOMStorageObject.HostCookieKey="dom-storage-object-host";WebInspector.DOMStorageObject.LocalStorageCookieKey="dom-storage-object-local-storage";WebInspector.DOMStorageObject.Event={ItemsCleared:"dom-storage-object-items-cleared",ItemAdded:"dom-storage-object-item-added",ItemRemoved:"dom-storage-object-item-removed",ItemUpdated:"dom-storage-object-updated",};WebInspector.DOMTree=class DOMTree extends WebInspector.Object
{constructor(frame)
{super();this._frame=frame;this._rootDOMNode=null;this._requestIdentifier=0;this._contentFlowCollection=new WebInspector.Collection(WebInspector.Collection.TypeVerifier.ContentFlow);this._frame.addEventListener(WebInspector.Frame.Event.PageExecutionContextChanged,this._framePageExecutionContextChanged,this);WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.DocumentUpdated,this._documentUpdated,this);if(!this._frame.isMainFrame()){WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.NodeRemoved,this._nodeRemoved,this);this._frame.addEventListener(WebInspector.Frame.Event.MainResourceDidChange,this._frameMainResourceDidChange,this);}
WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.ContentFlowListWasUpdated,this._contentFlowListWasUpdated,this);WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.ContentFlowWasAdded,this._contentFlowWasAdded,this);WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.ContentFlowWasRemoved,this._contentFlowWasRemoved,this);} 
get frame(){return this._frame;}
get contentFlowCollection(){return this._contentFlowCollection;}
disconnect()
{WebInspector.domTreeManager.removeEventListener(null,null,this);this._frame.removeEventListener(null,null,this);}
invalidate()
{this._rootDOMNode=null;
this._pendingRootDOMNodeRequests=null;if(this._invalidateTimeoutIdentifier)
return;function performInvalidate()
{this._invalidateTimeoutIdentifier=undefined;this.dispatchEventToListeners(WebInspector.DOMTree.Event.RootDOMNodeInvalidated);}
this._invalidateTimeoutIdentifier=setTimeout(performInvalidate.bind(this),0);}
requestRootDOMNode(callback)
{if(typeof callback!=="function")
return;if(this._rootDOMNode){callback(this._rootDOMNode);return;}
if(!this._frame.isMainFrame()&&!this._frame.pageExecutionContext){this._rootDOMNodeRequestWaitingForExecutionContext=true;if(!this._pendingRootDOMNodeRequests)
this._pendingRootDOMNodeRequests=[];this._pendingRootDOMNodeRequests.push(callback);return;}
if(this._pendingRootDOMNodeRequests){this._pendingRootDOMNodeRequests.push(callback);return;}
this._pendingRootDOMNodeRequests=[callback];this._requestRootDOMNode();}
requestContentFlowList()
{this.requestRootDOMNode(function(rootNode){WebInspector.domTreeManager.getNamedFlowCollection(rootNode.id);});} 
_requestRootDOMNode()
{var requestIdentifier=++this._requestIdentifier;function rootObjectAvailable(error,result)
{if(!this._pendingRootDOMNodeRequests||requestIdentifier!==this._requestIdentifier)
return;if(error){console.error(JSON.stringify(error));this._rootDOMNode=null;dispatchCallbacks.call(this);return;}
var remoteObject=WebInspector.RemoteObject.fromPayload(result);remoteObject.pushNodeToFrontend(rootDOMNodeAvailable.bind(this,remoteObject));}
function rootDOMNodeAvailable(remoteObject,nodeId)
{remoteObject.release();if(!this._pendingRootDOMNodeRequests||requestIdentifier!==this._requestIdentifier)
return;if(!nodeId){this._rootDOMNode=null;dispatchCallbacks.call(this);return;}
this._rootDOMNode=WebInspector.domTreeManager.nodeForId(nodeId);if(!this._rootDOMNode){dispatchCallbacks.call(this);return;}
this._rootDOMNode.getChildNodes(dispatchCallbacks.bind(this));}
function mainDocumentAvailable(document)
{this._rootDOMNode=document;dispatchCallbacks.call(this);}
function dispatchCallbacks()
{if(!this._pendingRootDOMNodeRequests||requestIdentifier!==this._requestIdentifier)
return;for(var i=0;i<this._pendingRootDOMNodeRequests.length;++i)
this._pendingRootDOMNodeRequests[i](this._rootDOMNode);this._pendingRootDOMNodeRequests=null;}



if(this._frame.isMainFrame())
WebInspector.domTreeManager.requestDocument(mainDocumentAvailable.bind(this));else{var contextId=this._frame.pageExecutionContext.id;RuntimeAgent.evaluate.invoke({expression:appendWebInspectorSourceURL("document"),objectGroup:"",includeCommandLineAPI:false,doNotPauseOnExceptionsAndMuteConsole:true,contextId,returnByValue:false,generatePreview:false},rootObjectAvailable.bind(this));}}
_nodeRemoved(event)
{if(event.data.node!==this._rootDOMNode)
return;this.invalidate();}
_documentUpdated(event)
{this.invalidate();}
_frameMainResourceDidChange(event)
{this.invalidate();}
_framePageExecutionContextChanged(event)
{if(this._rootDOMNodeRequestWaitingForExecutionContext){this._rootDOMNodeRequestWaitingForExecutionContext=false;this._requestRootDOMNode();}}
_isContentFlowInCurrentDocument(flow)
{return this._rootDOMNode&&this._rootDOMNode.id===flow.documentNodeIdentifier;}
_contentFlowListWasUpdated(event)
{if(!this._rootDOMNode||this._rootDOMNode.id!==event.data.documentNodeIdentifier)
return;let deletedFlows=new Set(this._contentFlowCollection.items);let newFlows=new Set;for(let flow of event.data.flows){if(this._contentFlowCollection.items.has(flow)){deletedFlows.delete(flow);}else{this._contentFlowCollection.add(flow);newFlows.add(flow);}}
for(let flow of deletedFlows)
this._contentFlowCollection.remove(flow);for(let flow of deletedFlows)
this.dispatchEventToListeners(WebInspector.DOMTree.Event.ContentFlowWasRemoved,{flow});for(let flow of newFlows)
this.dispatchEventToListeners(WebInspector.DOMTree.Event.ContentFlowWasAdded,{flow});}
_contentFlowWasAdded(event)
{let flow=event.data.flow;if(!this._isContentFlowInCurrentDocument(flow))
return;this._contentFlowCollection.add(flow);this.dispatchEventToListeners(WebInspector.DOMTree.Event.ContentFlowWasAdded,{flow});}
_contentFlowWasRemoved(event)
{let flow=event.data.flow;if(!this._isContentFlowInCurrentDocument(flow))
return;this._contentFlowCollection.remove(flow);this.dispatchEventToListeners(WebInspector.DOMTree.Event.ContentFlowWasRemoved,{flow});}};WebInspector.DOMTree.Event={RootDOMNodeInvalidated:"dom-tree-root-dom-node-invalidated",ContentFlowWasAdded:"dom-tree-content-flow-was-added",ContentFlowWasRemoved:"dom-tree-content-flow-was-removed"};WebInspector.DatabaseObject=class DatabaseObject extends WebInspector.Object
{constructor(id,host,name,version)
{super();this._id=id;this._host=host?host:WebInspector.UIString("Local File");this._name=name;this._version=version;} 
get id(){return this._id;}
get host(){return this._host;}
get name(){return this._name;}
get version(){return this._version;}
saveIdentityToCookie(cookie)
{cookie[WebInspector.DatabaseObject.HostCookieKey]=this.host;cookie[WebInspector.DatabaseObject.NameCookieKey]=this.name;}
getTableNames(callback)
{function sortingCallback(error,names)
{if(!error)
callback(names.sort());}
DatabaseAgent.getDatabaseTableNames(this._id,sortingCallback);}
executeSQL(query,successCallback,errorCallback)
{function queryCallback(error,columnNames,values,sqlError)
{if(error){errorCallback(WebInspector.UIString("An unexpected error occurred."));return;}
if(sqlError){switch(sqlError.code){case SQLException.VERSION_ERR:errorCallback(WebInspector.UIString("Database no longer has expected version."));break;case SQLException.TOO_LARGE_ERR:errorCallback(WebInspector.UIString("Data returned from the database is too large."));break;default:errorCallback(WebInspector.UIString("An unexpected error occurred."));break;}
return;}
successCallback(columnNames,values);}
DatabaseAgent.executeSQL(this._id,query,queryCallback);}};WebInspector.DatabaseObject.TypeIdentifier="database";WebInspector.DatabaseObject.HostCookieKey="database-object-host";WebInspector.DatabaseObject.NameCookieKey="database-object-name";WebInspector.DatabaseTableObject=class DatabaseTableObject extends WebInspector.Object
{constructor(name,database)
{super();this._name=name;this._database=database;} 
get name(){return this._name;}
get database(){return this._database;}
saveIdentityToCookie(cookie)
{cookie[WebInspector.DatabaseTableObject.NameCookieKey]=this.name;}};WebInspector.DatabaseTableObject.TypeIdentifier="database-table";WebInspector.DatabaseTableObject.NameCookieKey="database-table-object-name";WebInspector.DebuggerDashboard=class DebuggerDashboard extends WebInspector.Object
{};WebInspector.DebuggerData=class DebuggerData extends WebInspector.Object
{constructor(target)
{super();this._target=target;this._paused=false;this._pausing=false;this._pauseReason=null;this._pauseData=null;this._callFrames=[];this._asyncStackTrace=null;this._scriptIdMap=new Map;this._scriptContentIdentifierMap=new Map;this._makePausingAfterNextResume=false;} 
get target(){return this._target;}
get paused(){return this._paused;}
get pausing(){return this._pausing;}
get pauseReason(){return this._pauseReason;}
get pauseData(){return this._pauseData;}
get callFrames(){return this._callFrames;}
get asyncStackTrace(){return this._asyncStackTrace;}
get scripts()
{return Array.from(this._scriptIdMap.values());}
scriptForIdentifier(id)
{return this._scriptIdMap.get(id);}
scriptsForURL(url)
{return this._scriptContentIdentifierMap.get(url)||[];}
reset()
{this._scriptIdMap.clear();}
addScript(script)
{this._scriptIdMap.set(script.id,script);if(script.contentIdentifier){let scripts=this._scriptContentIdentifierMap.get(script.contentIdentifier);if(!scripts){scripts=[];this._scriptContentIdentifierMap.set(script.contentIdentifier,scripts);}
scripts.push(script);}}
pauseIfNeeded()
{if(this._paused||this._pausing)
return Promise.resolve();this._pausing=true;return this._target.DebuggerAgent.pause();}
resumeIfNeeded()
{if(!this._paused&&!this._pausing)
return Promise.resolve();this._pausing=false;return this._target.DebuggerAgent.resume();}
continueUntilNextRunLoop()
{if(!this._paused||this._pausing)
return Promise.resolve();
this._makePausingAfterNextResume=true;return this._target.DebuggerAgent.continueUntilNextRunLoop();}
updateForPause(callFrames,pauseReason,pauseData,asyncStackTrace)
{this._paused=true;this._pausing=false;this._pauseReason=pauseReason;this._pauseData=pauseData;this._callFrames=callFrames;this._asyncStackTrace=asyncStackTrace;this._makePausingAfterNextResume=false;}
updateForResume()
{this._paused=false;this._pausing=false;this._pauseReason=null;this._pauseData=null;this._callFrames=[];this._asyncStackTrace=null;if(this._makePausingAfterNextResume){this._makePausingAfterNextResume=false;this._pausing=true;}}};WebInspector.DefaultDashboard=class DefaultDashboard extends WebInspector.Object
{constructor()
{super();this._waitingForFirstMainResourceToStartTrackingSize=true;WebInspector.Frame.addEventListener(WebInspector.Frame.Event.MainResourceDidChange,this._mainResourceDidChange,this);WebInspector.timelineManager.addEventListener(WebInspector.TimelineManager.Event.CapturingStopped,this._capturingStopped,this);WebInspector.Frame.addEventListener(WebInspector.Frame.Event.ResourceWasAdded,this._resourceWasAdded,this);WebInspector.Target.addEventListener(WebInspector.Target.Event.ResourceAdded,this._resourceWasAdded,this);WebInspector.frameResourceManager.addEventListener(WebInspector.FrameResourceManager.Event.FrameWasAdded,this._frameWasAdded,this);var logManager=WebInspector.logManager;logManager.addEventListener(WebInspector.LogManager.Event.Cleared,this._consoleWasCleared,this);logManager.addEventListener(WebInspector.LogManager.Event.MessageAdded,this._consoleMessageAdded,this);logManager.addEventListener(WebInspector.LogManager.Event.PreviousMessageRepeatCountUpdated,this._consoleMessageWasRepeated,this);this._resourcesCount=0;this._resourcesSize=0;this._time=0;this._logs=0;this._errors=0;this._issues=0;} 
get resourcesCount()
{return this._resourcesCount;}
set resourcesCount(value)
{this._resourcesCount=value;this._dataDidChange();}
get resourcesSize()
{return this._resourcesSize;}
set resourcesSize(value)
{this._resourcesSize=value;this._dataDidChange();}
get time()
{return this._time;}
set time(value)
{this._time=value;this._dataDidChange();}
get logs()
{return this._logs;}
set logs(value)
{this._logs=value;this._dataDidChange();}
get errors()
{return this._errors;}
set errors(value)
{this._errors=value;this._dataDidChange();}
get issues()
{return this._issues;}
set issues(value)
{this._issues=value;this._dataDidChange();} 
_dataDidChange()
{this.dispatchEventToListeners(WebInspector.DefaultDashboard.Event.DataDidChange);}
_mainResourceDidChange(event)
{if(!event.target.isMainFrame())
return;this._time=0;this._resourcesCount=1;this._resourcesSize=WebInspector.frameResourceManager.mainFrame.mainResource.size||0;if(this._waitingForFirstMainResourceToStartTrackingSize){this._waitingForFirstMainResourceToStartTrackingSize=false;WebInspector.Resource.addEventListener(WebInspector.Resource.Event.SizeDidChange,this._resourceSizeDidChange,this);}
this._dataDidChange();this._startUpdatingTime();}
_capturingStopped(event)
{this._stopUpdatingTime();}
_resourceWasAdded(event)
{++this.resourcesCount;}
_frameWasAdded(event)
{++this.resourcesCount;}
_resourceSizeDidChange(event)
{if(event.target.urlComponents.scheme==="data")
return;this.resourcesSize+=event.target.size-event.data.previousSize;}
_startUpdatingTime()
{this._stopUpdatingTime();this.time=0;this._timelineBaseTime=Date.now();this._timeIntervalDelay=50;this._timeIntervalIdentifier=setInterval(this._updateTime.bind(this),this._timeIntervalDelay);}
_stopUpdatingTime()
{if(!this._timeIntervalIdentifier)
return;clearInterval(this._timeIntervalIdentifier);this._timeIntervalIdentifier=undefined;}
_updateTime()
{var duration=Date.now()-this._timelineBaseTime;var timeIntervalDelay=this._timeIntervalDelay;if(duration>=1000) 
timeIntervalDelay=100;else if(duration>=60000) 
timeIntervalDelay=1000;else if(duration>=3600000) 
timeIntervalDelay=10000;if(timeIntervalDelay!==this._timeIntervalDelay){this._timeIntervalDelay=timeIntervalDelay;clearInterval(this._timeIntervalIdentifier);this._timeIntervalIdentifier=setInterval(this._updateTime.bind(this),this._timeIntervalDelay);}
var mainFrame=WebInspector.frameResourceManager.mainFrame;var mainFrameStartTime=mainFrame.mainResource.firstTimestamp;var mainFrameLoadEventTime=mainFrame.loadEventTimestamp;if(isNaN(mainFrameStartTime)||isNaN(mainFrameLoadEventTime)){this.time=duration/1000;return;}
this.time=mainFrameLoadEventTime-mainFrameStartTime;this._stopUpdatingTime();}
_consoleMessageAdded(event)
{var message=event.data.message;this._lastConsoleMessageType=message.level;this._incrementConsoleMessageType(message.level,message.repeatCount);}
_consoleMessageWasRepeated(event)
{this._incrementConsoleMessageType(this._lastConsoleMessageType,1);}
_incrementConsoleMessageType(type,increment)
{switch(type){case WebInspector.ConsoleMessage.MessageLevel.Log:case WebInspector.ConsoleMessage.MessageLevel.Info:case WebInspector.ConsoleMessage.MessageLevel.Debug:this.logs+=increment;break;case WebInspector.ConsoleMessage.MessageLevel.Warning:this.issues+=increment;break;case WebInspector.ConsoleMessage.MessageLevel.Error:this.errors+=increment;break;}}
_consoleWasCleared(event)
{this._logs=0;this._issues=0;this._errors=0;this._dataDidChange();}};WebInspector.DefaultDashboard.Event={DataDidChange:"default-dashboard-data-did-change"};WebInspector.ExecutionContext=class ExecutionContext extends WebInspector.Object
{constructor(target,id,name,isPageContext,frame)
{super();this._target=target;this._id=id;this._name=name;this._isPageContext=isPageContext||false;this._frame=frame||null;} 
get target(){return this._target;}
get id(){return this._id;}
get name(){return this._name;}
get isPageContext(){return this._isPageContext;}
get frame(){return this._frame;}};WebInspector.ExecutionContextList=class ExecutionContextList extends WebInspector.Object
{constructor()
{super();this._contexts=[];this._pageExecutionContext=null;} 
get pageExecutionContext()
{return this._pageExecutionContext;}
get contexts()
{return this._contexts;}
add(context)
{if(context.isPageContext&&this._pageExecutionContext){return false;}
this._contexts.push(context);if(context.isPageContext){this._pageExecutionContext=context;return true;}
return false;}
clear()
{this._contexts=[];this._pageExecutionContext=null;}};WebInspector.FPSInstrument=class FPSInstrument extends WebInspector.Instrument
{constructor()
{super();} 
static supported()
{return window.TimelineAgent&&TimelineAgent.EventType.RenderingFrame;} 
get timelineRecordType()
{return WebInspector.TimelineRecord.Type.RenderingFrame;}};WebInspector.Frame=class Frame extends WebInspector.Object
{constructor(id,name,securityOrigin,loaderIdentifier,mainResource)
{super();this._id=id;this._name=null;this._securityOrigin=null;this._resourceCollection=new WebInspector.ResourceCollection;this._provisionalResourceCollection=new WebInspector.ResourceCollection;this._extraScriptCollection=new WebInspector.Collection(WebInspector.Collection.TypeVerifier.Script);this._canvasCollection=new WebInspector.Collection(WebInspector.Collection.TypeVerifier.Canvas);this._childFrameCollection=new WebInspector.Collection(WebInspector.Collection.TypeVerifier.Frame);this._childFrameIdentifierMap=new Map;this._parentFrame=null;this._isMainFrame=false;this._domContentReadyEventTimestamp=NaN;this._loadEventTimestamp=NaN;this._executionContextList=new WebInspector.ExecutionContextList;this.initialize(name,securityOrigin,loaderIdentifier,mainResource);} 
get resourceCollection(){return this._resourceCollection;}
get extraScriptCollection(){return this._extraScriptCollection;}
get canvasCollection(){return this._canvasCollection;}
get childFrameCollection(){return this._childFrameCollection;}
initialize(name,securityOrigin,loaderIdentifier,mainResource)
{var oldName=this._name;var oldSecurityOrigin=this._securityOrigin;var oldMainResource=this._mainResource;this._name=name||null;this._securityOrigin=securityOrigin||null;this._loaderIdentifier=loaderIdentifier||null;this._mainResource=mainResource;this._mainResource._parentFrame=this;if(oldMainResource&&this._mainResource!==oldMainResource)
this._disassociateWithResource(oldMainResource);this.removeAllResources();this.removeAllChildFrames();this.clearExecutionContexts();this.clearProvisionalLoad();if(this._mainResource!==oldMainResource)
this._dispatchMainResourceDidChangeEvent(oldMainResource);if(this._securityOrigin!==oldSecurityOrigin)
this.dispatchEventToListeners(WebInspector.Frame.Event.SecurityOriginDidChange,{oldSecurityOrigin});if(this._name!==oldName)
this.dispatchEventToListeners(WebInspector.Frame.Event.NameDidChange,{oldName});}
startProvisionalLoad(provisionalMainResource)
{this._provisionalMainResource=provisionalMainResource;this._provisionalMainResource._parentFrame=this;this._provisionalLoaderIdentifier=provisionalMainResource.loaderIdentifier;this._provisionalResourceCollection.clear();this.dispatchEventToListeners(WebInspector.Frame.Event.ProvisionalLoadStarted);}
commitProvisionalLoad(securityOrigin)
{if(!this._provisionalLoaderIdentifier)
return;var oldSecurityOrigin=this._securityOrigin;var oldMainResource=this._mainResource;this._securityOrigin=securityOrigin||null;this._loaderIdentifier=this._provisionalLoaderIdentifier;this._mainResource=this._provisionalMainResource;this._domContentReadyEventTimestamp=NaN;this._loadEventTimestamp=NaN;if(oldMainResource&&this._mainResource!==oldMainResource)
this._disassociateWithResource(oldMainResource);this.removeAllResources();this._resourceCollection=this._provisionalResourceCollection;this._provisionalResourceCollection=new WebInspector.ResourceCollection;this._extraScriptCollection.clear();this._canvasCollection.clear();this.clearExecutionContexts(true);this.clearProvisionalLoad(true);this.removeAllChildFrames();this.dispatchEventToListeners(WebInspector.Frame.Event.ProvisionalLoadCommitted);if(this._mainResource!==oldMainResource)
this._dispatchMainResourceDidChangeEvent(oldMainResource);if(this._securityOrigin!==oldSecurityOrigin)
this.dispatchEventToListeners(WebInspector.Frame.Event.SecurityOriginDidChange,{oldSecurityOrigin});}
clearProvisionalLoad(skipProvisionalLoadClearedEvent)
{if(!this._provisionalLoaderIdentifier)
return;this._provisionalLoaderIdentifier=null;this._provisionalMainResource=null;this._provisionalResourceCollection.clear();if(!skipProvisionalLoadClearedEvent)
this.dispatchEventToListeners(WebInspector.Frame.Event.ProvisionalLoadCleared);}
get id()
{return this._id;}
get loaderIdentifier()
{return this._loaderIdentifier;}
get provisionalLoaderIdentifier()
{return this._provisionalLoaderIdentifier;}
get name()
{return this._name;}
get securityOrigin()
{return this._securityOrigin;}
get url()
{return this._mainResource._url;}
get domTree()
{if(!this._domTree)
this._domTree=new WebInspector.DOMTree(this);return this._domTree;}
get pageExecutionContext()
{return this._executionContextList.pageExecutionContext;}
get executionContextList()
{return this._executionContextList;}
clearExecutionContexts(committingProvisionalLoad)
{if(this._executionContextList.contexts.length){let contexts=this._executionContextList.contexts.slice();this._executionContextList.clear();this.dispatchEventToListeners(WebInspector.Frame.Event.ExecutionContextsCleared,{committingProvisionalLoad:!!committingProvisionalLoad,contexts});}}
addExecutionContext(context)
{var changedPageContext=this._executionContextList.add(context);if(changedPageContext)
this.dispatchEventToListeners(WebInspector.Frame.Event.PageExecutionContextChanged);}
get mainResource()
{return this._mainResource;}
get provisionalMainResource()
{return this._provisionalMainResource;}
get parentFrame()
{return this._parentFrame;}
get domContentReadyEventTimestamp()
{return this._domContentReadyEventTimestamp;}
get loadEventTimestamp()
{return this._loadEventTimestamp;}
isMainFrame()
{return this._isMainFrame;}
markAsMainFrame()
{this._isMainFrame=true;}
unmarkAsMainFrame()
{this._isMainFrame=false;}
markDOMContentReadyEvent(timestamp)
{this._domContentReadyEventTimestamp=timestamp||NaN;}
markLoadEvent(timestamp)
{this._loadEventTimestamp=timestamp||NaN;}
isDetached()
{var frame=this;while(frame){if(frame.isMainFrame())
return false;frame=frame.parentFrame;}
return true;}
childFrameForIdentifier(frameId)
{return this._childFrameIdentifierMap.get(frameId)||null;}
addChildFrame(frame)
{if(!(frame instanceof WebInspector.Frame))
return;if(frame._parentFrame===this)
return;if(frame._parentFrame)
frame._parentFrame.removeChildFrame(frame);this._childFrameCollection.add(frame);this._childFrameIdentifierMap.set(frame._id,frame);frame._parentFrame=this;this.dispatchEventToListeners(WebInspector.Frame.Event.ChildFrameWasAdded,{childFrame:frame});}
removeChildFrame(frameOrFrameId)
{let childFrameId=frameOrFrameId;if(childFrameId instanceof WebInspector.Frame)
childFrameId=frameOrFrameId._id;
let childFrame=this.childFrameForIdentifier(childFrameId);if(!(childFrame instanceof WebInspector.Frame))
return;this._childFrameCollection.remove(childFrame);this._childFrameIdentifierMap.delete(childFrame._id);childFrame._detachFromParentFrame();this.dispatchEventToListeners(WebInspector.Frame.Event.ChildFrameWasRemoved,{childFrame});}
removeAllChildFrames()
{this._detachFromParentFrame();for(let childFrame of this._childFrameCollection.items)
childFrame.removeAllChildFrames();this._childFrameCollection.clear();this._childFrameIdentifierMap.clear();this.dispatchEventToListeners(WebInspector.Frame.Event.AllChildFramesRemoved);}
resourceForURL(url,recursivelySearchChildFrames)
{var resource=this._resourceCollection.resourceForURL(url);if(resource)
return resource;for(let childFrame of this._childFrameCollection.items){resource=childFrame.mainResource;if(resource.url===url)
return resource;}
if(!recursivelySearchChildFrames)
return null;for(let childFrame of this._childFrameCollection.items){resource=childFrame.resourceForURL(url,true);if(resource)
return resource;}
return null;}
resourceCollectionForType(type)
{return this._resourceCollection.resourceCollectionForType(type);}
addResource(resource)
{if(!(resource instanceof WebInspector.Resource))
return;if(resource.parentFrame===this)
return;if(resource.parentFrame)
resource.parentFrame.remove(resource);this._associateWithResource(resource);if(this._isProvisionalResource(resource)){this._provisionalResourceCollection.add(resource);this.dispatchEventToListeners(WebInspector.Frame.Event.ProvisionalResourceWasAdded,{resource});}else{this._resourceCollection.add(resource);this.dispatchEventToListeners(WebInspector.Frame.Event.ResourceWasAdded,{resource});}}
removeResource(resource)
{this._resourceCollection.remove(resource);this._disassociateWithResource(resource);this.dispatchEventToListeners(WebInspector.Frame.Event.ResourceWasRemoved,{resource});}
removeAllResources()
{let resources=this._resourceCollection.items;if(!resources.size)
return;for(let resource of resources)
this._disassociateWithResource(resource);this._resourceCollection.clear();this.dispatchEventToListeners(WebInspector.Frame.Event.AllResourcesRemoved);}
addExtraScript(script)
{this._extraScriptCollection.add(script);this.dispatchEventToListeners(WebInspector.Frame.Event.ExtraScriptAdded,{script});}
saveIdentityToCookie(cookie)
{cookie[WebInspector.Frame.MainResourceURLCookieKey]=this.mainResource.url.hash;cookie[WebInspector.Frame.IsMainFrameCookieKey]=this._isMainFrame;} 
_detachFromParentFrame()
{if(this._domTree){this._domTree.disconnect();this._domTree=null;}
this._parentFrame=null;}
_isProvisionalResource(resource)
{return resource.loaderIdentifier&&this._provisionalLoaderIdentifier&&resource.loaderIdentifier===this._provisionalLoaderIdentifier;}
_associateWithResource(resource)
{if(resource._parentFrame)
return;resource._parentFrame=this;}
_disassociateWithResource(resource)
{if(resource.parentFrame!==this)
return;resource._parentFrame=null;}
_dispatchMainResourceDidChangeEvent(oldMainResource)
{this.dispatchEventToListeners(WebInspector.Frame.Event.MainResourceDidChange,{oldMainResource});}};WebInspector.Frame.Event={NameDidChange:"frame-name-did-change",SecurityOriginDidChange:"frame-security-origin-did-change",MainResourceDidChange:"frame-main-resource-did-change",ProvisionalLoadStarted:"frame-provisional-load-started",ProvisionalLoadCommitted:"frame-provisional-load-committed",ProvisionalLoadCleared:"frame-provisional-load-cleared",ProvisionalResourceWasAdded:"frame-provisional-resource-was-added",ResourceWasAdded:"frame-resource-was-added",ResourceWasRemoved:"frame-resource-was-removed",AllResourcesRemoved:"frame-all-resources-removed",ExtraScriptAdded:"frame-extra-script-added",ChildFrameWasAdded:"frame-child-frame-was-added",ChildFrameWasRemoved:"frame-child-frame-was-removed",AllChildFramesRemoved:"frame-all-child-frames-removed",PageExecutionContextChanged:"frame-page-execution-context-changed",ExecutionContextsCleared:"frame-execution-contexts-cleared"};WebInspector.Frame.TypeIdentifier="Frame";WebInspector.Frame.MainResourceURLCookieKey="frame-main-resource-url";WebInspector.Frame.IsMainFrameCookieKey="frame-is-main-frame";WebInspector.GarbageCollection=class GarbageCollection extends WebInspector.Object
{constructor(type,startTime,endTime)
{super();this._type=type;this._startTime=startTime;this._endTime=endTime;} 
static fromPayload(payload)
{let type=WebInspector.GarbageCollection.Type.Full;if(payload.type===HeapAgent.GarbageCollectionType.Partial)
type=WebInspector.GarbageCollection.Type.Partial;return new WebInspector.GarbageCollection(type,payload.startTime,payload.endTime);} 
get type(){return this._type;}
get startTime(){return this._startTime;}
get endTime(){return this._endTime;}
get duration()
{return this._endTime-this._startTime;}};WebInspector.GarbageCollection.Type={Partial:Symbol("Partial"),Full:Symbol("Full")};WebInspector.Point=class Point
{constructor(x,y)
{this.x=x||0;this.y=y||0;} 
static fromEvent(event)
{return new WebInspector.Point(event.pageX,event.pageY);}
static fromEventInElement(event,element)
{var wkPoint=window.webkitConvertPointFromPageToNode(element,new WebKitPoint(event.pageX,event.pageY));return new WebInspector.Point(wkPoint.x,wkPoint.y);} 
toString()
{return"WebInspector.Point["+this.x+","+this.y+"]";}
copy()
{return new WebInspector.Point(this.x,this.y);}
equals(anotherPoint)
{return this.x===anotherPoint.x&&this.y===anotherPoint.y;}
distance(anotherPoint)
{var dx=anotherPoint.x-this.x;var dy=anotherPoint.y-this.y;return Math.sqrt(dx*dx,dy*dy);}};WebInspector.Size=class Size
{constructor(width,height)
{this.width=width||0;this.height=height||0;} 
toString()
{return"WebInspector.Size["+this.width+","+this.height+"]";}
copy()
{return new WebInspector.Size(this.width,this.height);}
equals(anotherSize)
{return this.width===anotherSize.width&&this.height===anotherSize.height;}};WebInspector.Size.ZERO_SIZE=new WebInspector.Size(0,0);WebInspector.Rect=class Rect
{constructor(x,y,width,height)
{this.origin=new WebInspector.Point(x||0,y||0);this.size=new WebInspector.Size(width||0,height||0);} 
static rectFromClientRect(clientRect)
{return new WebInspector.Rect(clientRect.left,clientRect.top,clientRect.width,clientRect.height);}
static unionOfRects(rects)
{var union=rects[0];for(var i=1;i<rects.length;++i)
union=union.unionWithRect(rects[i]);return union;} 
toString()
{return"WebInspector.Rect["+[this.origin.x,this.origin.y,this.size.width,this.size.height].join(", ")+"]";}
copy()
{return new WebInspector.Rect(this.origin.x,this.origin.y,this.size.width,this.size.height);}
equals(anotherRect)
{return this.origin.equals(anotherRect.origin)&&this.size.equals(anotherRect.size);}
inset(insets)
{return new WebInspector.Rect(this.origin.x+insets.left,this.origin.y+insets.top,this.size.width-insets.left-insets.right,this.size.height-insets.top-insets.bottom);}
pad(padding)
{return new WebInspector.Rect(this.origin.x-padding,this.origin.y-padding,this.size.width+padding*2,this.size.height+padding*2);}
minX()
{return this.origin.x;}
minY()
{return this.origin.y;}
midX()
{return this.origin.x+(this.size.width/2);}
midY()
{return this.origin.y+(this.size.height/2);}
maxX()
{return this.origin.x+this.size.width;}
maxY()
{return this.origin.y+this.size.height;}
intersectionWithRect(rect)
{var x1=Math.max(this.minX(),rect.minX());var x2=Math.min(this.maxX(),rect.maxX());if(x1>x2)
return WebInspector.Rect.ZERO_RECT;var intersection=new WebInspector.Rect;intersection.origin.x=x1;intersection.size.width=x2-x1;var y1=Math.max(this.minY(),rect.minY());var y2=Math.min(this.maxY(),rect.maxY());if(y1>y2)
return WebInspector.Rect.ZERO_RECT;intersection.origin.y=y1;intersection.size.height=y2-y1;return intersection;}
unionWithRect(rect)
{var x=Math.min(this.minX(),rect.minX());var y=Math.min(this.minY(),rect.minY());var width=Math.max(this.maxX(),rect.maxX())-x;var height=Math.max(this.maxY(),rect.maxY())-y;return new WebInspector.Rect(x,y,width,height);}
round()
{return new WebInspector.Rect(Math.floor(this.origin.x),Math.floor(this.origin.y),Math.ceil(this.size.width),Math.ceil(this.size.height));}};WebInspector.Rect.ZERO_RECT=new WebInspector.Rect(0,0,0,0);WebInspector.EdgeInsets=class EdgeInsets
{constructor(top,right,bottom,left)
{if(arguments.length===1){this.top=top;this.right=top;this.bottom=top;this.left=top;}else if(arguments.length===4){this.top=top;this.right=right;this.bottom=bottom;this.left=left;}} 
equals(anotherInset)
{return this.top===anotherInset.top&&this.right===anotherInset.right&&this.bottom===anotherInset.bottom&&this.left===anotherInset.left;}
copy()
{return new WebInspector.EdgeInsets(this.top,this.right,this.bottom,this.left);}};WebInspector.RectEdge={MIN_X:0,MIN_Y:1,MAX_X:2,MAX_Y:3};WebInspector.Quad=class Quad
{constructor(quad)
{this.points=[new WebInspector.Point(quad[0],quad[1]), new WebInspector.Point(quad[2],quad[3]), new WebInspector.Point(quad[4],quad[5]), new WebInspector.Point(quad[6],quad[7])
];this.width=Math.round(Math.sqrt(Math.pow(quad[0]-quad[2],2)+Math.pow(quad[1]-quad[3],2)));this.height=Math.round(Math.sqrt(Math.pow(quad[0]-quad[6],2)+Math.pow(quad[1]-quad[7],2)));} 
toProtocol()
{return[this.points[0].x,this.points[0].y,this.points[1].x,this.points[1].y,this.points[2].x,this.points[2].y,this.points[3].x,this.points[3].y];}};WebInspector.Polygon=class Polygon
{constructor(points)
{this.points=points;} 
bounds()
{var minX=Number.MAX_VALUE;var minY=Number.MAX_VALUE;var maxX=-Number.MAX_VALUE;var maxY=-Number.MAX_VALUE;for(var point of this.points){minX=Math.min(minX,point.x);maxX=Math.max(maxX,point.x);minY=Math.min(minY,point.y);maxY=Math.max(maxY,point.y);}
return new WebInspector.Rect(minX,minY,maxX-minX,maxY-minY);}};WebInspector.CubicBezier=class CubicBezier
{constructor(x1,y1,x2,y2)
{this._inPoint=new WebInspector.Point(x1,y1);this._outPoint=new WebInspector.Point(x2,y2);this._curveInfo={x:{c:3.0*x1},y:{c:3.0*y1}};this._curveInfo.x.b=3.0*(x2-x1)-this._curveInfo.x.c;this._curveInfo.x.a=1.0-this._curveInfo.x.c-this._curveInfo.x.b;this._curveInfo.y.b=3.0*(y2-y1)-this._curveInfo.y.c;this._curveInfo.y.a=1.0-this._curveInfo.y.c-this._curveInfo.y.b;} 
static fromCoordinates(coordinates)
{if(!coordinates||coordinates.length<4)
return null;coordinates=coordinates.map(Number);if(coordinates.includes(NaN))
return null;return new WebInspector.CubicBezier(coordinates[0],coordinates[1],coordinates[2],coordinates[3]);}
static fromString(text)
{if(!text||!text.length)
return null;var trimmedText=text.toLowerCase().replace(/\s/g,"");if(!trimmedText.length)
return null;if(Object.keys(WebInspector.CubicBezier.keywordValues).includes(trimmedText))
return WebInspector.CubicBezier.fromCoordinates(WebInspector.CubicBezier.keywordValues[trimmedText]);var matches=trimmedText.match(/^cubic-bezier\(([-\d.]+),([-\d.]+),([-\d.]+),([-\d.]+)\)$/);if(!matches)
return null;matches.splice(0,1);return WebInspector.CubicBezier.fromCoordinates(matches);} 
get inPoint()
{return this._inPoint;}
get outPoint()
{return this._outPoint;}
copy()
{return new WebInspector.CubicBezier(this._inPoint.x,this._inPoint.y,this._outPoint.x,this._outPoint.y);}
toString()
{var values=[this._inPoint.x,this._inPoint.y,this._outPoint.x,this._outPoint.y];for(var key in WebInspector.CubicBezier.keywordValues){if(Array.shallowEqual(WebInspector.CubicBezier.keywordValues[key],values))
return key;}
return"cubic-bezier("+values.join(", ")+")";}
solve(x,epsilon)
{return this._sampleCurveY(this._solveCurveX(x,epsilon));} 
_sampleCurveX(t)
{return((this._curveInfo.x.a*t+this._curveInfo.x.b)*t+this._curveInfo.x.c)*t;}
_sampleCurveY(t)
{return((this._curveInfo.y.a*t+this._curveInfo.y.b)*t+this._curveInfo.y.c)*t;}
_sampleCurveDerivativeX(t)
{return(3.0*this._curveInfo.x.a*t+2.0*this._curveInfo.x.b)*t+this._curveInfo.x.c;}
_solveCurveX(x,epsilon)
{var t0,t1,t2,x2,d2,i;for(t2=x,i=0;i<8;i++){x2=this._sampleCurveX(t2)-x;if(Math.abs(x2)<epsilon)
return t2;d2=this._sampleCurveDerivativeX(t2);if(Math.abs(d2)<1e-6)
break;t2=t2-x2/d2;}
t0=0.0;t1=1.0;t2=x;if(t2<t0)
return t0;if(t2>t1)
return t1;while(t0<t1){x2=this._sampleCurveX(t2);if(Math.abs(x2-x)<epsilon)
return t2;if(x>x2)
t0=t2;else
t1=t2;t2=(t1-t0)*0.5+t0;}
return t2;}};WebInspector.CubicBezier.keywordValues={"ease":[0.25,0.1,0.25,1],"ease-in":[0.42,0,1,1],"ease-out":[0,0,0.58,1],"ease-in-out":[0.42,0,0.58,1],"linear":[0,0,1,1]};WebInspector.Spring=class Spring
{constructor(mass,stiffness,damping,initialVelocity)
{this.mass=Math.max(1,mass);this.stiffness=Math.max(1,stiffness);this.damping=Math.max(0,damping);this.initialVelocity=initialVelocity;} 
static fromValues(values)
{if(!values||values.length<4)
return null;values=values.map(Number);if(values.includes(NaN))
return null;return new WebInspector.Spring(...values);}
static fromString(text)
{if(!text||!text.length)
return null;let trimmedText=text.toLowerCase().trim();if(!trimmedText.length)
return null;let matches=trimmedText.match(/^spring\(([\d.]+)\s+([\d.]+)\s+([\d.]+)\s+([-\d.]+)\)$/);if(!matches)
return null;return WebInspector.Spring.fromValues(matches.slice(1));} 
copy()
{return new WebInspector.Spring(this.mass,this.stiffness,this.damping,this.initialVelocity);}
toString()
{return`spring(${this.mass} ${this.stiffness} ${this.damping} ${this.initialVelocity})`;}
solve(t)
{let w0=Math.sqrt(this.stiffness/this.mass);let zeta=this.damping/(2*Math.sqrt(this.stiffness*this.mass));let wd=0;let A=1;let B=-this.initialVelocity+w0;if(zeta<1){wd=w0*Math.sqrt(1-zeta*zeta);A=1;B=(zeta*w0+-this.initialVelocity)/wd;}
if(zeta<1) 
t=Math.exp(-t*zeta*w0)*(A*Math.cos(wd*t)+B*Math.sin(wd*t));else
t=(A+B*t)*Math.exp(-t*w0);return 1-t;}
calculateDuration(epsilon)
{epsilon=epsilon||0.0001;let t=0;let current=0;let minimum=Number.POSITIVE_INFINITY;while(current>=epsilon||minimum>=epsilon){current=Math.abs(1-this.solve(t)); if(minimum<epsilon&&current>=epsilon)
minimum=Number.POSITIVE_INFINITY; else if(current<minimum)
minimum=current;t+=0.1;}
return t;}};WebInspector.Gradient=class Gradient
{constructor(type,stops)
{this.type=type;this.stops=stops;} 
static fromString(cssString)
{var type;var openingParenthesisIndex=cssString.indexOf("(");var typeString=cssString.substring(0,openingParenthesisIndex);if(typeString.indexOf(WebInspector.Gradient.Types.Linear)!==-1)
type=WebInspector.Gradient.Types.Linear;else if(typeString.indexOf(WebInspector.Gradient.Types.Radial)!==-1)
type=WebInspector.Gradient.Types.Radial;else
return null;var components=[];var currentParams=[];var currentParam="";var openParentheses=0;var ch=openingParenthesisIndex+1;var c=null;while(c=cssString[ch]){if(c==="(")
openParentheses++;if(c===")")
openParentheses--;var isComma=c===",";var isSpace=/\s/.test(c);if(openParentheses===0){if(isSpace){if(currentParam!=="")
currentParams.push(currentParam);currentParam="";}else if(isComma){currentParams.push(currentParam);components.push(currentParams);currentParams=[];currentParam="";}}
if(openParentheses===-1){currentParams.push(currentParam);components.push(currentParams);break;}
if(openParentheses>0||(!isComma&&!isSpace))
currentParam+=c;ch++;}
if(openParentheses!==-1)
return null;var gradient;if(type===WebInspector.Gradient.Types.Linear)
gradient=WebInspector.LinearGradient.fromComponents(components);else
gradient=WebInspector.RadialGradient.fromComponents(components);if(gradient)
gradient.repeats=typeString.startsWith("repeating");return gradient;}
static stopsWithComponents(components)
{var stops=components.map(function(component){while(component.length){var color=WebInspector.Color.fromString(component.shift());if(!color)
continue;var stop={color};if(component.length&&component[0].substr(-1)==="%")
stop.offset=parseFloat(component.shift())/100;return stop;}});if(!stops.length)
return null;for(var i=0,count=stops.length;i<count;++i){var stop=stops[i];
if(!stop)
return null;if(!stop.offset)
stop.offset=i/(count-1);}
return stops;} 
stringFromStops(stops)
{var count=stops.length-1;return stops.map(function(stop,index){var str=stop.color;if(stop.offset!==index/count)
str+=" "+Math.round(stop.offset*10000)/100+"%";return str;}).join(", ");} 
copy()
{}
toString()
{}};WebInspector.Gradient.Types={Linear:"linear-gradient",Radial:"radial-gradient"};WebInspector.LinearGradient=class LinearGradient extends WebInspector.Gradient
{constructor(angle,stops)
{super(WebInspector.Gradient.Types.Linear,stops);this._angle=angle;} 
static fromComponents(components)
{let angle={value:180,units:WebInspector.LinearGradient.AngleUnits.DEG};if(components[0].length===1&&!WebInspector.Color.fromString(components[0][0])){let match=components[0][0].match(/([-\d\.]+)(\w+)/);if(!match||!Object.values(WebInspector.LinearGradient.AngleUnits).includes(match[2]))
return null;angle.value=parseFloat(match[1]);angle.units=match[2];components.shift();}else if(components[0][0]==="to"){components[0].shift();switch(components[0].sort().join(" ")){case"top":angle.value=0;break;case"right top":angle.value=45;break;case"right":angle.value=90;break;case"bottom right":angle.value=135;break;case"bottom":angle.value=180;break;case"bottom left":angle.value=225;break;case"left":angle.value=270;break;case"left top":angle.value=315;break;default:return null;}
components.shift();}else if(components[0].length!==1&&!WebInspector.Color.fromString(components[0][0])){
return null;}
var stops=WebInspector.Gradient.stopsWithComponents(components);if(!stops)
return null;return new WebInspector.LinearGradient(angle,stops);} 
set angleValue(value){this._angle.value=value;}
get angleValue()
{return this._angle.value.maxDecimals(2);}
set angleUnits(units)
{if(units===this._angle.units)
return;this._angle.value=this._angleValueForUnits(units);this._angle.units=units;}
get angleUnits(){return this._angle.units;}
copy()
{return new WebInspector.LinearGradient(this._angle,this.stops.concat());}
toString()
{let str="";let deg=this._angleValueForUnits(WebInspector.LinearGradient.AngleUnits.DEG);if(deg===0)
str+="to top";else if(deg===45)
str+="to top right";else if(deg===90)
str+="to right";else if(deg===135)
str+="to bottom right";else if(deg===225)
str+="to bottom left";else if(deg===270)
str+="to left";else if(deg===315)
str+="to top left";else if(deg!==180)
str+=this.angleValue+this.angleUnits;if(str!=="")
str+=", ";str+=this.stringFromStops(this.stops);return(this.repeats?"repeating-":"")+this.type+"("+str+")";} 
_angleValueForUnits(units)
{if(units===this._angle.units)
return this._angle.value;let deg=0;switch(this._angle.units){case WebInspector.LinearGradient.AngleUnits.DEG:deg=this._angle.value;break;case WebInspector.LinearGradient.AngleUnits.RAD:deg=this._angle.value*180/Math.PI;break;case WebInspector.LinearGradient.AngleUnits.GRAD:deg=this._angle.value/400*360;break;case WebInspector.LinearGradient.AngleUnits.TURN:deg=this._angle.value*360;break;default:WebInspector.reportInternalError(`Unknown angle units "${this._angle.units}"`);return 0;}
let value=0;switch(units){case WebInspector.LinearGradient.AngleUnits.DEG:value=deg;break;case WebInspector.LinearGradient.AngleUnits.RAD:value=deg*Math.PI/180;break;case WebInspector.LinearGradient.AngleUnits.GRAD:value=deg/360*400;break;case WebInspector.LinearGradient.AngleUnits.TURN:value=deg/360;break;}
return value;}};WebInspector.LinearGradient.AngleUnits={DEG:"deg",RAD:"rad",GRAD:"grad",TURN:"turn",};WebInspector.RadialGradient=class RadialGradient extends WebInspector.Gradient
{constructor(sizing,stops)
{super(WebInspector.Gradient.Types.Radial,stops);this.sizing=sizing;} 
static fromComponents(components)
{var sizing=!WebInspector.Color.fromString(components[0].join(" "))?components.shift().join(" "):"";var stops=WebInspector.Gradient.stopsWithComponents(components);if(!stops)
return null;return new WebInspector.RadialGradient(sizing,stops);} 
copy()
{return new WebInspector.RadialGradient(this.sizing,this.stops.concat());}
toString()
{var str=this.sizing;if(str!=="")
str+=", ";str+=this.stringFromStops(this.stops);return(this.repeats?"repeating-":"")+this.type+"("+str+")";}};WebInspector.HeapAllocationsInstrument=class HeapAllocationsInstrument extends WebInspector.Instrument
{constructor()
{super();this._snapshotIntervalIdentifier=undefined;} 
static supported()
{return window.HeapAgent;} 
get timelineRecordType()
{return WebInspector.TimelineRecord.Type.HeapAllocations;}
startInstrumentation(initiatedByBackend)
{if(!initiatedByBackend)
HeapAgent.startTracking();const snapshotInterval=10000;this._snapshotIntervalIdentifier=setInterval(this._takeHeapSnapshot.bind(this),snapshotInterval);}
stopInstrumentation(initiatedByBackend)
{if(!initiatedByBackend)
HeapAgent.stopTracking();window.clearInterval(this._snapshotIntervalIdentifier);this._snapshotIntervalIdentifier=undefined;} 
_takeHeapSnapshot()
{HeapAgent.snapshot(function(error,timestamp,snapshotStringData){let workerProxy=WebInspector.HeapSnapshotWorkerProxy.singleton();workerProxy.createSnapshot(snapshotStringData,({objectId,snapshot:serializedSnapshot})=>{let snapshot=WebInspector.HeapSnapshotProxy.deserialize(objectId,serializedSnapshot);WebInspector.timelineManager.heapSnapshotAdded(timestamp,snapshot);});});}};WebInspector.HeapAllocationsTimelineRecord=class HeapAllocationsTimelineRecord extends WebInspector.TimelineRecord
{constructor(timestamp,heapSnapshot)
{super(WebInspector.TimelineRecord.Type.HeapAllocations,timestamp,timestamp);this._timestamp=timestamp;this._heapSnapshot=heapSnapshot;} 
get timestamp(){return this._timestamp;}
get heapSnapshot(){return this._heapSnapshot;}};WebInspector.HeapSnapshotRootPath=class HeapSnapshotRootPath extends WebInspector.Object
{constructor(node,pathComponent,parent,isGlobalScope)
{super();this._node=node||null;this._parent=parent||null;this._pathComponent=typeof pathComponent==="string"?pathComponent:null;this._isGlobalScope=isGlobalScope||false;if(this._parent&&this._parent.isEmpty())
this._parent=null;} 
static emptyPath()
{return new WebInspector.HeapSnapshotRootPath(null);}
static pathComponentForIndividualEdge(edge)
{switch(edge.type){case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Internal:return null;case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Index:return"["+edge.data+"]";case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Property:case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Variable:if(WebInspector.HeapSnapshotRootPath.canPropertyNameBeDotAccess(edge.data))
return edge.data;return"["+doubleQuotedString(edge.data)+"]";}}
static canPropertyNameBeDotAccess(propertyName)
{return/^(?![0-9])\w+$/.test(propertyName);} 
get node(){return this._node;}
get parent(){return this._parent;}
get pathComponent(){return this._pathComponent;}
get rootNode()
{return this._parent?this._parent.rootNode:this._node;}
get fullPath()
{let components=[];for(let p=this;p&&p.pathComponent;p=p.parent)
components.push(p.pathComponent);components.reverse();return components.join("");}
isRoot()
{return!this._parent;}
isEmpty()
{return!this._node;}
isGlobalScope()
{return this._isGlobalScope;}
isPathComponentImpossible()
{return this._pathComponent&&this._pathComponent.startsWith("@");}
isFullPathImpossible()
{if(this.isEmpty())
return true;if(this.isPathComponentImpossible())
return true;if(this._parent)
return this._parent.isFullPathImpossible();return false;}
appendInternal(node)
{return new WebInspector.HeapSnapshotRootPath(node,WebInspector.HeapSnapshotRootPath.SpecialPathComponent.InternalPropertyName,this);}
appendArrayIndex(node,index)
{let component="["+index+"]";return new WebInspector.HeapSnapshotRootPath(node,component,this);}
appendPropertyName(node,propertyName)
{let component=WebInspector.HeapSnapshotRootPath.canPropertyNameBeDotAccess(propertyName)?"."+propertyName:"["+doubleQuotedString(propertyName)+"]";return new WebInspector.HeapSnapshotRootPath(node,component,this);}
appendVariableName(node,variableName)
{if(this._isGlobalScope)
return this.appendPropertyName(node,variableName);return new WebInspector.HeapSnapshotRootPath(node,variableName,this);}
appendGlobalScopeName(node,globalScopeName)
{return new WebInspector.HeapSnapshotRootPath(node,globalScopeName,this,true);}
appendEdge(edge)
{switch(edge.type){case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Internal:return this.appendInternal(edge.to);case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Index:return this.appendArrayIndex(edge.to,edge.data);case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Property:return this.appendPropertyName(edge.to,edge.data);case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Variable:return this.appendVariableName(edge.to,edge.data);}
console.error("Unexpected edge type",edge.type);}};WebInspector.HeapSnapshotRootPath.SpecialPathComponent={InternalPropertyName:"@internal",};WebInspector.IndexedDatabase=class IndexedDatabase extends WebInspector.Object
{constructor(name,securityOrigin,version,objectStores)
{super();this._name=name;this._securityOrigin=securityOrigin;this._host=parseSecurityOrigin(securityOrigin).host;this._version=version;this._objectStores=objectStores||[];for(var objectStore of this._objectStores)
objectStore.establishRelationship(this);} 
get name(){return this._name;}
get securityOrigin(){return this._securityOrigin;}
get host(){return this._host;}
get version(){return this._version;}
get objectStores(){return this._objectStores;}
saveIdentityToCookie(cookie)
{cookie[WebInspector.IndexedDatabase.NameCookieKey]=this._name;cookie[WebInspector.IndexedDatabase.HostCookieKey]=this._host;}};WebInspector.IndexedDatabase.TypeIdentifier="indexed-database";WebInspector.IndexedDatabase.NameCookieKey="indexed-database-name";WebInspector.IndexedDatabase.HostCookieKey="indexed-database-host";WebInspector.IndexedDatabaseObjectStore=class IndexedDatabaseObjectStore extends WebInspector.Object
{constructor(name,keyPath,autoIncrement,indexes)
{super();this._name=name;this._keyPath=keyPath;this._autoIncrement=autoIncrement||false;this._indexes=indexes||[];this._parentDatabase=null;for(var index of this._indexes)
index.establishRelationship(this);} 
get name(){return this._name;}
get keyPath(){return this._keyPath;}
get autoIncrement(){return this._autoIncrement;}
get parentDatabase(){return this._parentDatabase;}
get indexes(){return this._indexes;}
saveIdentityToCookie(cookie)
{cookie[WebInspector.IndexedDatabaseObjectStore.NameCookieKey]=this._name;cookie[WebInspector.IndexedDatabaseObjectStore.KeyPathCookieKey]=this._keyPath;} 
establishRelationship(parentDatabase)
{this._parentDatabase=parentDatabase||null;}};WebInspector.IndexedDatabaseObjectStore.TypeIdentifier="indexed-database-object-store";WebInspector.IndexedDatabaseObjectStore.NameCookieKey="indexed-database-object-store-name";WebInspector.IndexedDatabaseObjectStore.KeyPathCookieKey="indexed-database-object-store-key-path";WebInspector.IndexedDatabaseObjectStoreIndex=class IndexedDatabaseObjectStoreIndex extends WebInspector.Object
{constructor(name,keyPath,unique,multiEntry)
{super();this._name=name;this._keyPath=keyPath;this._unique=unique||false;this._multiEntry=multiEntry||false;this._parentObjectStore=null;} 
get name(){return this._name;}
get keyPath(){return this._keyPath;}
get unique(){return this._unique;}
get multiEntry(){return this._multiEntry;}
get parentObjectStore(){return this._parentObjectStore;}
saveIdentityToCookie(cookie)
{cookie[WebInspector.IndexedDatabaseObjectStoreIndex.NameCookieKey]=this._name;cookie[WebInspector.IndexedDatabaseObjectStoreIndex.KeyPathCookieKey]=this._keyPath;} 
establishRelationship(parentObjectStore)
{this._parentObjectStore=parentObjectStore||null;}};WebInspector.IndexedDatabaseObjectStoreIndex.TypeIdentifier="indexed-database-object-store-index";WebInspector.IndexedDatabaseObjectStoreIndex.NameCookieKey="indexed-database-object-store-index-name";WebInspector.IndexedDatabaseObjectStoreIndex.KeyPathCookieKey="indexed-database-object-store-index-key-path";WebInspector.IssueMessage=class IssueMessage extends WebInspector.Object
{constructor(consoleMessage)
{super();this._consoleMessage=consoleMessage;this._text=this._issueText();switch(this._consoleMessage.source){case"javascript":
var prefixRegex=/^([^:]+): (?:DOM Exception \d+: )?/;var match=prefixRegex.exec(this._text);if(match&&match[1]in WebInspector.IssueMessage.Type._prefixTypeMap){this._type=WebInspector.IssueMessage.Type._prefixTypeMap[match[1]];this._text=this._text.substring(match[0].length);}else
this._type=WebInspector.IssueMessage.Type.OtherIssue;break;case"css":case"xml":this._type=WebInspector.IssueMessage.Type.PageIssue;break;case"network":this._type=WebInspector.IssueMessage.Type.NetworkIssue;break;case"security":this._type=WebInspector.IssueMessage.Type.SecurityIssue;break;case"console-api":case"storage":case"appcache":case"rendering":case"other":this._type=WebInspector.IssueMessage.Type.OtherIssue;break;default:console.error("Unknown issue source:",this._consoleMessage.source);this._type=WebInspector.IssueMessage.Type.OtherIssue;}
this._sourceCodeLocation=consoleMessage.sourceCodeLocation;if(this._sourceCodeLocation)
this._sourceCodeLocation.addEventListener(WebInspector.SourceCodeLocation.Event.DisplayLocationChanged,this._sourceCodeLocationDisplayLocationChanged,this);} 
static displayName(type)
{switch(type){case WebInspector.IssueMessage.Type.SemanticIssue:return WebInspector.UIString("Semantic Issue");case WebInspector.IssueMessage.Type.RangeIssue:return WebInspector.UIString("Range Issue");case WebInspector.IssueMessage.Type.ReferenceIssue:return WebInspector.UIString("Reference Issue");case WebInspector.IssueMessage.Type.TypeIssue:return WebInspector.UIString("Type Issue");case WebInspector.IssueMessage.Type.PageIssue:return WebInspector.UIString("Page Issue");case WebInspector.IssueMessage.Type.NetworkIssue:return WebInspector.UIString("Network Issue");case WebInspector.IssueMessage.Type.SecurityIssue:return WebInspector.UIString("Security Issue");case WebInspector.IssueMessage.Type.OtherIssue:return WebInspector.UIString("Other Issue");default:console.error("Unknown issue message type:",type);return WebInspector.UIString("Other Issue");}} 
get text(){return this._text;}
get type(){return this._type;}
get level(){return this._consoleMessage.level;}
get source(){return this._consoleMessage.source;}
get url(){return this._consoleMessage.url;}
get sourceCodeLocation(){return this._sourceCodeLocation;} 
saveIdentityToCookie(cookie)
{cookie[WebInspector.IssueMessage.URLCookieKey]=this.url;cookie[WebInspector.IssueMessage.LineNumberCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.lineNumber:0;cookie[WebInspector.IssueMessage.ColumnNumberCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.columnNumber:0;} 
_issueText()
{let parameters=this._consoleMessage.parameters;if(!parameters)
return this._consoleMessage.messageText;if(WebInspector.RemoteObject.type(parameters[0])!=="string")
return this._consoleMessage.messageText;function valueFormatter(obj)
{return obj.description;}
let formatters={};formatters.o=valueFormatter;formatters.s=valueFormatter;formatters.f=valueFormatter;formatters.i=valueFormatter;formatters.d=valueFormatter;function append(a,b)
{a+=b;return a;}
let result=String.format(parameters[0].description,parameters.slice(1),formatters,"",append);let resultText=result.formattedResult;for(let i=0;i<result.unusedSubstitutions.length;++i)
resultText+=" "+result.unusedSubstitutions[i].description;return resultText;}
_sourceCodeLocationDisplayLocationChanged(event)
{this.dispatchEventToListeners(WebInspector.IssueMessage.Event.DisplayLocationDidChange,event.data);}};WebInspector.IssueMessage.Level={Error:"error",Warning:"warning"};WebInspector.IssueMessage.Type={SemanticIssue:"issue-message-type-semantic-issue",RangeIssue:"issue-message-type-range-issue",ReferenceIssue:"issue-message-type-reference-issue",TypeIssue:"issue-message-type-type-issue",PageIssue:"issue-message-type-page-issue",NetworkIssue:"issue-message-type-network-issue",SecurityIssue:"issue-message-type-security-issue",OtherIssue:"issue-message-type-other-issue"};WebInspector.IssueMessage.TypeIdentifier="issue-message";WebInspector.IssueMessage.URLCookieKey="issue-message-url";WebInspector.IssueMessage.LineNumberCookieKey="issue-message-line-number";WebInspector.IssueMessage.ColumnNumberCookieKey="issue-message-column-number";WebInspector.IssueMessage.Event={LocationDidChange:"issue-message-location-did-change",DisplayLocationDidChange:"issue-message-display-location-did-change"};WebInspector.IssueMessage.Type._prefixTypeMap={"SyntaxError":WebInspector.IssueMessage.Type.SemanticIssue,"URIError":WebInspector.IssueMessage.Type.SemanticIssue,"EvalError":WebInspector.IssueMessage.Type.SemanticIssue,"INVALID_CHARACTER_ERR":WebInspector.IssueMessage.Type.SemanticIssue,"SYNTAX_ERR":WebInspector.IssueMessage.Type.SemanticIssue,"RangeError":WebInspector.IssueMessage.Type.RangeIssue,"INDEX_SIZE_ERR":WebInspector.IssueMessage.Type.RangeIssue,"DOMSTRING_SIZE_ERR":WebInspector.IssueMessage.Type.RangeIssue,"ReferenceError":WebInspector.IssueMessage.Type.ReferenceIssue,"HIERARCHY_REQUEST_ERR":WebInspector.IssueMessage.Type.ReferenceIssue,"INVALID_STATE_ERR":WebInspector.IssueMessage.Type.ReferenceIssue,"NOT_FOUND_ERR":WebInspector.IssueMessage.Type.ReferenceIssue,"WRONG_DOCUMENT_ERR":WebInspector.IssueMessage.Type.ReferenceIssue,"TypeError":WebInspector.IssueMessage.Type.TypeIssue,"INVALID_NODE_TYPE_ERR":WebInspector.IssueMessage.Type.TypeIssue,"TYPE_MISMATCH_ERR":WebInspector.IssueMessage.Type.TypeIssue,"SECURITY_ERR":WebInspector.IssueMessage.Type.SecurityIssue,"NETWORK_ERR":WebInspector.IssueMessage.Type.NetworkIssue,"ABORT_ERR":WebInspector.IssueMessage.Type.OtherIssue,"DATA_CLONE_ERR":WebInspector.IssueMessage.Type.OtherIssue,"INUSE_ATTRIBUTE_ERR":WebInspector.IssueMessage.Type.OtherIssue,"INVALID_ACCESS_ERR":WebInspector.IssueMessage.Type.OtherIssue,"INVALID_MODIFICATION_ERR":WebInspector.IssueMessage.Type.OtherIssue,"NAMESPACE_ERR":WebInspector.IssueMessage.Type.OtherIssue,"NOT_SUPPORTED_ERR":WebInspector.IssueMessage.Type.OtherIssue,"NO_DATA_ALLOWED_ERR":WebInspector.IssueMessage.Type.OtherIssue,"NO_MODIFICATION_ALLOWED_ERR":WebInspector.IssueMessage.Type.OtherIssue,"QUOTA_EXCEEDED_ERR":WebInspector.IssueMessage.Type.OtherIssue,"TIMEOUT_ERR":WebInspector.IssueMessage.Type.OtherIssue,"URL_MISMATCH_ERR":WebInspector.IssueMessage.Type.OtherIssue,"VALIDATION_ERR":WebInspector.IssueMessage.Type.OtherIssue};WebInspector.KeyboardShortcut=class KeyboardShortcut extends WebInspector.Object
{constructor(modifiers,key,callback,targetElement)
{super();if(typeof key==="string"){key=key[0].toUpperCase();key=new WebInspector.Key(key.charCodeAt(0),key);}
if(callback&&!targetElement)
targetElement=document;this._modifiers=modifiers||WebInspector.KeyboardShortcut.Modifier.None;this._key=key;this._targetElement=targetElement;this._callback=callback;this._disabled=false;this._implicitlyPreventsDefault=true;if(targetElement){var targetKeyboardShortcuts=targetElement._keyboardShortcuts;if(!targetKeyboardShortcuts)
targetKeyboardShortcuts=targetElement._keyboardShortcuts=[];targetKeyboardShortcuts.push(this);if(!WebInspector.KeyboardShortcut._registeredKeyDownListener){WebInspector.KeyboardShortcut._registeredKeyDownListener=true;window.addEventListener("keydown",WebInspector.KeyboardShortcut._handleKeyDown);}}} 
static _handleKeyDown(event)
{if(event.defaultPrevented)
return;for(var targetElement=event.target;targetElement;targetElement=targetElement.parentNode){if(!targetElement._keyboardShortcuts)
continue;for(var i=0;i<targetElement._keyboardShortcuts.length;++i){var keyboardShortcut=targetElement._keyboardShortcuts[i];if(!keyboardShortcut.matchesEvent(event))
continue;if(!keyboardShortcut.callback)
continue;keyboardShortcut.callback(event,keyboardShortcut);if(keyboardShortcut.implicitlyPreventsDefault)
event.preventDefault();return;}}} 
get modifiers()
{return this._modifiers;}
get key()
{return this._key;}
get displayName()
{var result="";if(this._modifiers&WebInspector.KeyboardShortcut.Modifier.Control)
result+="\u2303";if(this._modifiers&WebInspector.KeyboardShortcut.Modifier.Option)
result+=WebInspector.Platform.name==="mac"?"\u2325":"\u2387";if(this._modifiers&WebInspector.KeyboardShortcut.Modifier.Shift)
result+="\u21e7";if(this._modifiers&WebInspector.KeyboardShortcut.Modifier.Command)
result+="\u2318";result+=this._key.toString();return result;}
get callback()
{return this._callback;}
set callback(callback)
{this._callback=callback||null;}
get disabled()
{return this._disabled;}
set disabled(disabled)
{this._disabled=disabled||false;}
get implicitlyPreventsDefault()
{return this._implicitlyPreventsDefault;}
set implicitlyPreventsDefault(implicitly)
{this._implicitlyPreventsDefault=implicitly;}
unbind()
{this._disabled=true;if(!this._targetElement)
return;var targetKeyboardShortcuts=this._targetElement._keyboardShortcuts;if(!targetKeyboardShortcuts)
return;targetKeyboardShortcuts.remove(this);}
matchesEvent(event)
{if(this._disabled)
return false;if(this._key.keyCode!==event.keyCode)
return false;var eventModifiers=WebInspector.KeyboardShortcut.Modifier.None;if(event.shiftKey)
eventModifiers|=WebInspector.KeyboardShortcut.Modifier.Shift;if(event.ctrlKey)
eventModifiers|=WebInspector.KeyboardShortcut.Modifier.Control;if(event.altKey)
eventModifiers|=WebInspector.KeyboardShortcut.Modifier.Option;if(event.metaKey)
eventModifiers|=WebInspector.KeyboardShortcut.Modifier.Command;return this._modifiers===eventModifiers;}};WebInspector.Key=class Key
{constructor(keyCode,displayName)
{this._keyCode=keyCode;this._displayName=displayName;} 
get keyCode()
{return this._keyCode;}
get displayName()
{return this._displayName;}
toString()
{return this._displayName;}};WebInspector.KeyboardShortcut.Modifier={None:0,Shift:1,Control:2,Option:4,Command:8,get CommandOrControl()
{return WebInspector.Platform.name==="mac"?this.Command:this.Control;}};WebInspector.KeyboardShortcut.Key={Backspace:new WebInspector.Key(8,"\u232b"),Tab:new WebInspector.Key(9,"\u21e5"),Enter:new WebInspector.Key(13,"\u21a9"),Escape:new WebInspector.Key(27,"\u238b"),Space:new WebInspector.Key(32,"Space"),PageUp:new WebInspector.Key(33,"\u21de"),PageDown:new WebInspector.Key(34,"\u21df"),End:new WebInspector.Key(35,"\u2198"),Home:new WebInspector.Key(36,"\u2196"),Left:new WebInspector.Key(37,"\u2190"),Up:new WebInspector.Key(38,"\u2191"),Right:new WebInspector.Key(39,"\u2192"),Down:new WebInspector.Key(40,"\u2193"),Delete:new WebInspector.Key(46,"\u2326"),Zero:new WebInspector.Key(48,"0"),F1:new WebInspector.Key(112,"F1"),F2:new WebInspector.Key(113,"F2"),F3:new WebInspector.Key(114,"F3"),F4:new WebInspector.Key(115,"F4"),F5:new WebInspector.Key(116,"F5"),F6:new WebInspector.Key(117,"F6"),F7:new WebInspector.Key(118,"F7"),F8:new WebInspector.Key(119,"F8"),F9:new WebInspector.Key(120,"F9"),F10:new WebInspector.Key(121,"F10"),F11:new WebInspector.Key(122,"F11"),F12:new WebInspector.Key(123,"F12"),Semicolon:new WebInspector.Key(186,";"),Plus:new WebInspector.Key(187,"+"),Comma:new WebInspector.Key(188,","),Minus:new WebInspector.Key(189,"-"),Period:new WebInspector.Key(190,"."),Slash:new WebInspector.Key(191,"/"),Apostrophe:new WebInspector.Key(192,"`"),LeftCurlyBrace:new WebInspector.Key(219,"{"),Backslash:new WebInspector.Key(220,"\\"),RightCurlyBrace:new WebInspector.Key(221,"}"),SingleQuote:new WebInspector.Key(222,"\'")};WebInspector.LayoutInstrument=class LayoutInstrument extends WebInspector.Instrument
{ get timelineRecordType()
{return WebInspector.TimelineRecord.Type.Layout;}};WebInspector.LayoutTimelineRecord=class LayoutTimelineRecord extends WebInspector.TimelineRecord
{constructor(eventType,startTime,endTime,callFrames,sourceCodeLocation,quad)
{super(WebInspector.TimelineRecord.Type.Layout,startTime,endTime,callFrames,sourceCodeLocation);if(eventType in WebInspector.LayoutTimelineRecord.EventType)
eventType=WebInspector.LayoutTimelineRecord.EventType[eventType];this._eventType=eventType;this._quad=quad||null;} 
static displayNameForEventType(eventType)
{switch(eventType){case WebInspector.LayoutTimelineRecord.EventType.InvalidateStyles:return WebInspector.UIString("Styles Invalidated");case WebInspector.LayoutTimelineRecord.EventType.RecalculateStyles:return WebInspector.UIString("Styles Recalculated");case WebInspector.LayoutTimelineRecord.EventType.InvalidateLayout:return WebInspector.UIString("Layout Invalidated");case WebInspector.LayoutTimelineRecord.EventType.ForcedLayout:return WebInspector.UIString("Forced Layout");case WebInspector.LayoutTimelineRecord.EventType.Layout:return WebInspector.UIString("Layout");case WebInspector.LayoutTimelineRecord.EventType.Paint:return WebInspector.UIString("Paint");case WebInspector.LayoutTimelineRecord.EventType.Composite:return WebInspector.UIString("Composite");}} 
get eventType()
{return this._eventType;}
get width()
{return this._quad?this._quad.width:NaN;}
get height()
{return this._quad?this._quad.height:NaN;}
get area()
{return this.width*this.height;}
get quad()
{return this._quad;}
saveIdentityToCookie(cookie)
{super.saveIdentityToCookie(cookie);cookie[WebInspector.LayoutTimelineRecord.EventTypeCookieKey]=this._eventType;}};WebInspector.LayoutTimelineRecord.EventType={InvalidateStyles:"layout-timeline-record-invalidate-styles",RecalculateStyles:"layout-timeline-record-recalculate-styles",InvalidateLayout:"layout-timeline-record-invalidate-layout",ForcedLayout:"layout-timeline-record-forced-layout",Layout:"layout-timeline-record-layout",Paint:"layout-timeline-record-paint",Composite:"layout-timeline-record-composite"};WebInspector.LayoutTimelineRecord.TypeIdentifier="layout-timeline-record";WebInspector.LayoutTimelineRecord.EventTypeCookieKey="layout-timeline-record-event-type";
WebInspector.LazySourceCodeLocation=class LazySourceCodeLocation extends WebInspector.SourceCodeLocation
{constructor(sourceCode,lineNumber,columnNumber)
{super(null,lineNumber,columnNumber);this._initialized=false;this._lazySourceCode=sourceCode;} 
isEqual(other)
{if(!other)
return false;return this._lazySourceCode===other._sourceCode&&this._lineNumber===other._lineNumber&&this._columnNumber===other._columnNumber;}
get sourceCode()
{return this._lazySourceCode;}
set sourceCode(sourceCode)
{this.setSourceCode(sourceCode);}
get formattedLineNumber()
{this._lazyInitialization();return this._formattedLineNumber;}
get formattedColumnNumber()
{this._lazyInitialization();return this._formattedColumnNumber;}
formattedPosition()
{this._lazyInitialization();return new WebInspector.SourceCodePosition(this._formattedLineNumber,this._formattedColumnNumber);}
hasFormattedLocation()
{this._lazyInitialization();return super.hasFormattedLocation();}
hasDifferentDisplayLocation()
{this._lazyInitialization();return super.hasDifferentDisplayLocation();} 
resolveMappedLocation()
{this._lazyInitialization();super.resolveMappedLocation();} 
_lazyInitialization()
{if(!this._initialized){this._initialized=true;this.sourceCode=this._lazySourceCode;}}};WebInspector.LineWidget=class LineWidget extends WebInspector.Object
{constructor(codeMirrorLineWidget,widgetElement)
{super();this._codeMirrorLineWidget=codeMirrorLineWidget;this._widgetElement=widgetElement;} 
get codeMirrorLineWidget()
{return this._codeMirrorLineWidget;}
get widgetElement()
{return this._widgetElement;}
clear()
{this._codeMirrorLineWidget.clear();}
update()
{if(this._codeMirrorLineWidget.update)
this._codeMirrorLineWidget.update();}};WebInspector.LogObject=class LogObject extends WebInspector.Object
{constructor()
{super();this._startDate=new Date;} 
get startDate()
{return this._startDate;}};WebInspector.MemoryCategory=class MemoryCategory extends WebInspector.Object
{constructor(type,size)
{super();this.type=type;this.size=size;}};WebInspector.MemoryCategory.Type={JavaScript:"javascript",Images:"images",Layers:"layers",Page:"page",};WebInspector.MemoryInstrument=class MemoryInstrument extends WebInspector.Instrument
{constructor()
{super();} 
static supported()
{return window.MemoryAgent;} 
get timelineRecordType()
{return WebInspector.TimelineRecord.Type.Memory;}
startInstrumentation(initiatedByBackend)
{if(!initiatedByBackend)
MemoryAgent.startTracking();}
stopInstrumentation(initiatedByBackend)
{if(!initiatedByBackend)
MemoryAgent.stopTracking();}};WebInspector.MemoryPressureEvent=class MemoryPressureEvent extends WebInspector.Object
{constructor(timestamp,severity)
{super();this._timestamp=timestamp;this._severity=severity;} 
static fromPayload(timestamp,protocolSeverity)
{let severity;switch(protocolSeverity){case MemoryAgent.MemoryPressureSeverity.Critical:severity=WebInspector.MemoryPressureEvent.Severity.Critical;break;case MemoryAgent.MemoryPressureSeverity.NonCritical:severity=WebInspector.MemoryPressureEvent.Severity.NonCritical;break;default:console.error("Unexpected memory pressure severity",protocolSeverity);severity=WebInspector.MemoryPressureEvent.Severity.NonCritical;break;}
return new WebInspector.MemoryPressureEvent(timestamp,severity);} 
get timestamp(){return this._timestamp;}
get severity(){return this._severity;}};WebInspector.MemoryPressureEvent.Severity={Critical:Symbol("Critical"),NonCritical:Symbol("NonCritical"),};WebInspector.MemoryTimeline=class MemoryTimeline extends WebInspector.Timeline
{ get memoryPressureEvents(){return this._pressureEvents;}
addMemoryPressureEvent(memoryPressureEvent)
{this._pressureEvents.push(memoryPressureEvent);this.dispatchEventToListeners(WebInspector.MemoryTimeline.Event.MemoryPressureEventAdded,{memoryPressureEvent});} 
reset(suppressEvents)
{super.reset(suppressEvents);this._pressureEvents=[];}};WebInspector.MemoryTimeline.Event={MemoryPressureEventAdded:"memory-timeline-memory-pressure-event-added",};WebInspector.MemoryTimelineRecord=class MemoryTimelineRecord extends WebInspector.TimelineRecord
{constructor(timestamp,categories)
{super(WebInspector.TimelineRecord.Type.Memory,timestamp,timestamp);this._timestamp=timestamp;this._categories=WebInspector.MemoryTimelineRecord.memoryCategoriesFromProtocol(categories);this._totalSize=0;for(let{size}of categories)
this._totalSize+=size;} 
static memoryCategoriesFromProtocol(categories)
{let javascriptSize=0;let imagesSize=0;let layersSize=0;let pageSize=0;for(let{type,size}of categories){switch(type){case MemoryAgent.CategoryDataType.Javascript:case MemoryAgent.CategoryDataType.JIT:javascriptSize+=size;break;case MemoryAgent.CategoryDataType.Images:imagesSize+=size;break;case MemoryAgent.CategoryDataType.Layers:layersSize+=size;break;case MemoryAgent.CategoryDataType.Page:case MemoryAgent.CategoryDataType.Other:pageSize+=size;break;default:console.warn("Unhandled Memory.CategoryDataType: "+type);break;}}
return[{type:WebInspector.MemoryCategory.Type.JavaScript,size:javascriptSize},{type:WebInspector.MemoryCategory.Type.Images,size:imagesSize},{type:WebInspector.MemoryCategory.Type.Layers,size:layersSize},{type:WebInspector.MemoryCategory.Type.Page,size:pageSize},];} 
get timestamp(){return this._timestamp;}
get categories(){return this._categories;}
get totalSize(){return this._totalSize;}};WebInspector.NativeConstructorFunctionParameters={Object:{assign:"target, ...sources",create:"prototype, [propertiesObject]",defineProperties:"object, properties",defineProperty:"object, propertyName, descriptor",freeze:"object",getOwnPropertyDescriptor:"object, propertyName",getOwnPropertyNames:"object",getOwnPropertySymbols:"object",getPrototypeOf:"object",is:"value1, value2",isExtensible:"object",isFrozen:"object",isSealed:"object",keys:"object",preventExtensions:"object",seal:"object",setPrototypeOf:"object, prototype",__proto__:null,},Array:{from:"arrayLike, [mapFunction], [thisArg]",isArray:"object",of:"[...values]",__proto__:null,},ArrayBuffer:{isView:"object",transfer:"oldBuffer, [newByteLength=length]",__proto__:null,},Number:{isFinite:"value",isInteger:"value",isNaN:"value",isSafeInteger:"value",parseFloat:"string",parseInt:"string, [radix]",__proto__:null,},Math:{abs:"x",acos:"x",acosh:"x",asin:"x",asinh:"x",atan2:"y, x",atan:"x",atanh:"x",cbrt:"x",ceil:"x",clz32:"x",cos:"x",cosh:"x",exp:"x",expm1:"x",floor:"x",fround:"x",hypot:"[...x]",imul:"x",log:"x",log1p:"x",log2:"x",log10:"x",max:"[...x]",min:"[...x]",pow:"x, y",round:"x",sign:"x",sin:"x",sinh:"x",sqrt:"x",tan:"x",tanh:"x",trunc:"x",__proto__:null,},JSON:{parse:"text, [reviver]",stringify:"value, [replacer], [space]",__proto__:null,},Date:{parse:"dateString",UTC:"year, [month], [day], [hour], [minute], [second], [ms]",__proto__:null,},Promise:{all:"iterable",race:"iterable",reject:"reason",resolve:"value",__proto__:null,},Reflect:{apply:"target, thisArgument, argumentsList",construct:"target, argumentsList, [newTarget=target]",defineProperty:"target, propertyKey, attributes",deleteProperty:"target, propertyKey",get:"target, propertyKey, [receiver]",getOwnPropertyDescriptor:"target, propertyKey",getPrototypeOf:"target",has:"target, propertyKey",isExtensible:"target",ownKeys:"target",preventExtensions:"target",set:"target, propertyKey, value, [receiver]",setPrototypeOf:"target, prototype",__proto__:null,},String:{fromCharCode:"...codeUnits",fromCodePoint:"...codePoints",raw:"template, ...substitutions",__proto__:null,},Symbol:{for:"key",keyFor:"symbol",__proto__:null,},Console:{assert:"condition, [message], [...values]",count:"[label]",debug:"message, [...values]",dir:"object",dirxml:"object",error:"message, [...values]",group:"[name]",groupCollapsed:"[name]",groupEnd:"[name]",info:"message, [...values]",log:"message, [...values]",profile:"name",profileEnd:"name",table:"data, [columns]",takeHeapSnapshot:"[label]",time:"name = \"default\"",timeEnd:"name = \"default\"",timeStamp:"[label]",trace:"message, [...values]",warn:"message, [...values]",__proto__:null,},IDBKeyRangeConstructor:{bound:"lower, upper, [lowerOpen], [upperOpen]",lowerBound:"lower, [open]",only:"value",upperBound:"upper, [open]",__proto__:null,},MediaSourceConstructor:{isTypeSupported:"type",__proto__:null,},MediaStreamTrackConstructor:{getSources:"callback",__proto__:null,},NotificationConstructor:{requestPermission:"[callback]",__proto__:null,},URLConstructor:{createObjectURL:"blob",revokeObjectURL:"url",__proto__:null,},WebKitMediaKeysConstructor:{isTypeSupported:"keySystem, [type]",__proto__:null,},};WebInspector.NativePrototypeFunctionParameters={Object:{__defineGetter__:"propertyName, getterFunction",__defineSetter__:"propertyName, setterFunction",__lookupGetter__:"propertyName",__lookupSetter__:"propertyName",hasOwnProperty:"propertyName",isPrototypeOf:"property",propertyIsEnumerable:"propertyName",__proto__:null,},Array:{concat:"value, ...",copyWithin:"targetIndex, startIndex, [endIndex=length]",every:"callback, [thisArg]",fill:"value, [startIndex=0], [endIndex=length]",filter:"callback, [thisArg]",find:"callback, [thisArg]",findIndex:"callback, [thisArg]",forEach:"callback, [thisArg]",includes:"searchValue, [startIndex=0]",indexOf:"searchValue, [startIndex=0]",join:"[separator=\",\"]",lastIndexOf:"searchValue, [startIndex=length]",map:"callback, [thisArg]",push:"value, ...",reduce:"callback, [initialValue]",reduceRight:"callback, [initialValue]",slice:"[startIndex=0], [endIndex=length]",some:"callback, [thisArg]",sort:"[compareFunction]",splice:"startIndex, [deleteCount=0], ...itemsToAdd",__proto__:null,},ArrayBuffer:{slice:"startIndex, [endIndex=byteLength]",__proto__:null,},DataView:{setInt8:"byteOffset, value",setInt16:"byteOffset, value, [littleEndian=false]",setInt23:"byteOffset, value, [littleEndian=false]",setUint8:"byteOffset, value",setUint16:"byteOffset, value, [littleEndian=false]",setUint32:"byteOffset, value, [littleEndian=false]",setFloat32:"byteOffset, value, [littleEndian=false]",setFloat64:"byteOffset, value, [littleEndian=false]",getInt8:"byteOffset",getInt16:"byteOffset, [littleEndian=false]",getInt23:"byteOffset, [littleEndian=false]",getUint8:"byteOffset",getUint16:"byteOffset, [littleEndian=false]",getUint32:"byteOffset, [littleEndian=false]",getFloat32:"byteOffset, [littleEndian=false]",getFloat64:"byteOffset, [littleEndian=false]",__proto__:null,},Date:{setDate:"day",setFullYear:"year, [month=getMonth()], [day=getDate()]",setHours:"hours, [minutes=getMinutes()], [seconds=getSeconds()], [ms=getMilliseconds()]",setMilliseconds:"ms",setMinutes:"minutes, [seconds=getSeconds()], [ms=getMilliseconds()]",setMonth:"month, [day=getDate()]",setSeconds:"seconds, [ms=getMilliseconds()]",setTime:"time",setUTCDate:"day",setUTCFullYear:"year, [month=getUTCMonth()], [day=getUTCDate()]",setUTCHours:"hours, [minutes=getUTCMinutes()], [seconds=getUTCSeconds()], [ms=getUTCMilliseconds()]",setUTCMilliseconds:"ms",setUTCMinutes:"minutes, [seconds=getUTCSeconds()], [ms=getUTCMilliseconds()]",setUTCMonth:"month, [day=getUTCDate()]",setUTCSeconds:"seconds, [ms=getUTCMilliseconds()]",setUTCTime:"time",setYear:"year",__proto__:null,},Function:{apply:"thisObject, [argumentsArray]",bind:"thisObject, ...arguments",call:"thisObject, ...arguments",__proto__:null,},Map:{delete:"key",forEach:"callback, [thisArg]",get:"key",has:"key",set:"key, value",__proto__:null,},Number:{toExponential:"[digits]",toFixed:"[digits]",toPrecision:"[significantDigits]",toString:"[radix=10]",__proto__:null,},RegExp:{compile:"pattern, flags",exec:"string",test:"string",__proto__:null,},Set:{delete:"value",forEach:"callback, [thisArg]",has:"value",add:"value",__proto__:null,},String:{charAt:"index",charCodeAt:"index",codePoints:"index",concat:"string, ...",includes:"searchValue, [startIndex=0]",indexOf:"searchValue, [startIndex=0]",lastIndexOf:"searchValue, [startIndex=length]",localeCompare:"string",match:"regex",repeat:"count",replace:"regex|string, replaceString|replaceHandler, [flags]",search:"regex",slice:"startIndex, [endIndex=length]",split:"[separator], [limit]",substr:"startIndex, [numberOfCharacters]",substring:"startIndex, [endIndex=length]",__proto__:null,},WeakMap:{delete:"key",get:"key",has:"key",set:"key, value",__proto__:null,},WeakSet:{delete:"value",has:"value",add:"value",__proto__:null,},Promise:{catch:"rejectionHandler",then:"resolvedHandler, rejectionHandler",__proto__:null,},Generator:{next:"value",return:"value",throw:"exception",__proto__:null,},Element:{closest:"selectors",getAttribute:"attributeName",getAttributeNS:"namespace, attributeName",getAttributeNode:"attributeName",getAttributeNodeNS:"namespace, attributeName",hasAttribute:"attributeName",hasAttributeNS:"namespace, attributeName",matches:"selector",removeAttribute:"attributeName",removeAttributeNS:"namespace, attributeName",removeAttributeNode:"attributeName",scrollIntoView:"[alignWithTop]",scrollIntoViewIfNeeded:"[centerIfNeeded]",setAttribute:"name, value",setAttributeNS:"namespace, name, value",setAttributeNode:"attributeNode",setAttributeNodeNS:"namespace, attributeNode",webkitMatchesSelector:"selectors",__proto__:null,},Node:{appendChild:"child",cloneNode:"[deep]",compareDocumentPosition:"[node]",contains:"[node]",insertBefore:"insertElement, referenceElement",isDefaultNamespace:"[namespace]",isEqualNode:"[node]",lookupNamespaceURI:"prefix",removeChild:"node",replaceChild:"newChild, oldChild",__proto__:null,},Window:{alert:"[message]",atob:"encodedData",btoa:"stringToEncode",cancelAnimationFrame:"id",clearInterval:"intervalId",clearTimeout:"timeoutId",confirm:"[message]",find:"string, [caseSensitive], [backwards], [wrapAround]",getComputedStyle:"[element], [pseudoElement]",getMatchedCSSRules:"[element], [pseudoElement]",matchMedia:"mediaQueryString",moveBy:"[deltaX], [deltaY]",moveTo:"[screenX], [screenY]",open:"url, windowName, [featuresString]",openDatabase:"name, version, displayName, estimatedSize, [creationCallback]",postMessage:"message, targetOrigin, [...transferables]",prompt:"[message], [value]",requestAnimationFrame:"callback",resizeBy:"[deltaX], [deltaY]",resizeTo:"[width], [height]",scrollBy:"[deltaX], [deltaY]",scrollTo:"[x], [y]",setInterval:"func, [delay], [...params]",setTimeout:"func, [delay], [...params]",showModalDialog:"url, [arguments], [options]",__proto__:null,},Document:{adoptNode:"[node]",caretRangeFromPoint:"[x], [y]",createAttribute:"attributeName",createAttributeNS:"namespace, qualifiedName",createCDATASection:"data",createComment:"data",createElement:"tagName",createElementNS:"namespace, qualifiedName",createEntityReference:"name",createEvent:"type",createExpression:"xpath, resolver",createNSResolver:"node",createNodeIterator:"root, whatToShow, filter",createProcessingInstruction:"target, data",createTextNode:"data",createTreeWalker:"root, whatToShow, filter, entityReferenceExpansion",elementFromPoint:"x, y",evaluate:"xpath, contextNode, namespaceResolver, resultType, result",execCommand:"command, userInterface, value",getCSSCanvasContext:"contextId, name, width, height",getElementById:"id",getElementsByName:"name",getOverrideStyle:"[element], [pseudoElement]",importNode:"node, deep",queryCommandEnabled:"command",queryCommandIndeterm:"command",queryCommandState:"command",queryCommandSupported:"command",queryCommandValue:"command",__proto__:null,},ANGLEInstancedArrays:{drawArraysInstancedANGLE:"mode, first, count, primcount",drawElementsInstancedANGLE:"mode, count, type, offset, primcount",vertexAttribDivisorANGLE:"index, divisor",__proto__:null,},AnalyserNode:{getByteFrequencyData:"array",getByteTimeDomainData:"array",getFloatFrequencyData:"array",__proto__:null,},AudioBuffer:{getChannelData:"channelIndex",__proto__:null,},AudioBufferCallback:{handleEvent:"audioBuffer",__proto__:null,},AudioBufferSourceNode:{noteGrainOn:"when, grainOffset, grainDuration",noteOff:"when",noteOn:"when",start:"[when], [grainOffset], [grainDuration]",stop:"[when]",__proto__:null,},AudioListener:{setOrientation:"x, y, z, xUp, yUp, zUp",setPosition:"x, y, z",setVelocity:"x, y, z",__proto__:null,},AudioNode:{connect:"destination, [output], [input]",disconnect:"[output]",__proto__:null,},AudioParam:{cancelScheduledValues:"startTime",exponentialRampToValueAtTime:"value, time",linearRampToValueAtTime:"value, time",setTargetAtTime:"target, time, timeConstant",setTargetValueAtTime:"targetValue, time, timeConstant",setValueAtTime:"value, time",setValueCurveAtTime:"values, time, duration",__proto__:null,},AudioTrackList:{getTrackById:"id",item:"index",__proto__:null,},BiquadFilterNode:{getFrequencyResponse:"frequencyHz, magResponse, phaseResponse",__proto__:null,},Blob:{slice:"[start], [end], [contentType]",__proto__:null,},CSS:{supports:"property, value",__proto__:null,},CSSKeyframesRule:{appendRule:"[rule]",deleteRule:"[key]",findRule:"[key]",insertRule:"[rule]",__proto__:null,},CSSMediaRule:{deleteRule:"[index]",insertRule:"[rule], [index]",__proto__:null,},CSSPrimitiveValue:{getFloatValue:"[unitType]",setFloatValue:"[unitType], [floatValue]",setStringValue:"[stringType], [stringValue]",__proto__:null,},CSSRuleList:{item:"[index]",__proto__:null,},CSSStyleDeclaration:{getPropertyCSSValue:"[propertyName]",getPropertyPriority:"[propertyName]",getPropertyShorthand:"[propertyName]",getPropertyValue:"[propertyName]",isPropertyImplicit:"[propertyName]",item:"[index]",removeProperty:"[propertyName]",setProperty:"[propertyName], [value], [priority]",__proto__:null,},CSSStyleSheet:{addRule:"[selector], [style], [index]",deleteRule:"[index]",insertRule:"[rule], [index]",removeRule:"[index]",__proto__:null,},CSSSupportsRule:{deleteRule:"[index]",insertRule:"[rule], [index]",__proto__:null,},CSSValueList:{item:"[index]",__proto__:null,},CanvasGradient:{addColorStop:"[offset], [color]",__proto__:null,},CanvasRenderingContext2D:{arc:"x, y, radius, startAngle, endAngle, [anticlockwise]",arcTo:"x1, y1, x2, y2, radius",bezierCurveTo:"cp1x, cp1y, cp2x, cp2y, x, y",clearRect:"x, y, width, height",clip:"path, [winding]",createImageData:"imagedata",createLinearGradient:"x0, y0, x1, y1",createPattern:"canvas, repetitionType",createRadialGradient:"x0, y0, r0, x1, y1, r1",drawFocusIfNeeded:"element",drawImage:"image, x, y",drawImageFromRect:"image, [sx], [sy], [sw], [sh], [dx], [dy], [dw], [dh], [compositeOperation]",ellipse:"x, y, radiusX, radiusY, rotation, startAngle, endAngle, [anticlockwise]",fill:"path, [winding]",fillRect:"x, y, width, height",fillText:"text, x, y, [maxWidth]",getImageData:"sx, sy, sw, sh",isPointInPath:"path, x, y, [winding]",isPointInStroke:"path, x, y",lineTo:"x, y",measureText:"text",moveTo:"x, y",putImageData:"imagedata, dx, dy",quadraticCurveTo:"cpx, cpy, x, y",rect:"x, y, width, height",rotate:"angle",scale:"sx, sy",setAlpha:"[alpha]",setCompositeOperation:"[compositeOperation]",setFillColor:"color, [alpha]",setLineCap:"[cap]",setLineDash:"dash",setLineJoin:"[join]",setLineWidth:"[width]",setMiterLimit:"[limit]",setShadow:"width, height, blur, [color], [alpha]",setStrokeColor:"color, [alpha]",setTransform:"m11, m12, m21, m22, dx, dy",stroke:"path",strokeRect:"x, y, width, height",strokeText:"text, x, y, [maxWidth]",transform:"m11, m12, m21, m22, dx, dy",translate:"tx, ty",webkitGetImageDataHD:"sx, sy, sw, sh",webkitPutImageDataHD:"imagedata, dx, dy",__proto__:null,},CharacterData:{appendData:"[data]",deleteData:"[offset], [length]",insertData:"[offset], [data]",replaceData:"[offset], [length], [data]",substringData:"[offset], [length]",__proto__:null,},CommandLineAPIHost:{copyText:"text",databaseId:"database",getEventListeners:"node",inspect:"objectId, hints",storageId:"storage",__proto__:null,},CompositionEvent:{initCompositionEvent:"[typeArg], [canBubbleArg], [cancelableArg], [viewArg], [dataArg]",__proto__:null,},Crypto:{getRandomValues:"array",__proto__:null,},CustomElementRegistry:{define:"name, constructor",get:"name",whenDefined:"name",__proto__:null,},CustomEvent:{initCustomEvent:"type, [bubbles], [cancelable], [detail]",__proto__:null,},DOMApplicationCache:{__proto__:null,},DOMImplementation:{createCSSStyleSheet:"[title], [media]",createDocument:"[namespaceURI], [qualifiedName], [doctype]",createDocumentType:"[qualifiedName], [publicId], [systemId]",createHTMLDocument:"[title]",hasFeature:"[feature], [version]",__proto__:null,},DOMParser:{parseFromString:"[str], [contentType]",__proto__:null,},DOMStringList:{contains:"[string]",item:"[index]",__proto__:null,},DOMTokenList:{add:"tokens...",contains:"token",item:"index",remove:"tokens...",toggle:"token, [force]",__proto__:null,},DataTransfer:{clearData:"[type]",getData:"type",setData:"type, data",setDragImage:"image, x, y",__proto__:null,},DataTransferItem:{getAsString:"[callback]",__proto__:null,},DataTransferItemList:{add:"file",item:"[index]",__proto__:null,},Database:{changeVersion:"oldVersion, newVersion, [callback], [errorCallback], [successCallback]",readTransaction:"callback, [errorCallback], [successCallback]",transaction:"callback, [errorCallback], [successCallback]",__proto__:null,},DatabaseCallback:{handleEvent:"database",__proto__:null,},DedicatedWorkerGlobalScope:{postMessage:"message, [messagePorts]",__proto__:null,},DeviceMotionEvent:{initDeviceMotionEvent:"[type], [bubbles], [cancelable], [acceleration], [accelerationIncludingGravity], [rotationRate], [interval]",__proto__:null,},DeviceOrientationEvent:{initDeviceOrientationEvent:"[type], [bubbles], [cancelable], [alpha], [beta], [gamma], [absolute]",__proto__:null,},DocumentFragment:{getElementById:"id",querySelector:"selectors",querySelectorAll:"selectors",__proto__:null,},Event:{initEvent:"type, [bubbles], [cancelable]",__proto__:null,},FileList:{item:"index",__proto__:null,},FileReader:{readAsArrayBuffer:"blob",readAsBinaryString:"blob",readAsDataURL:"blob",readAsText:"blob, [encoding]",__proto__:null,},FileReaderSync:{readAsArrayBuffer:"blob",readAsBinaryString:"blob",readAsDataURL:"blob",readAsText:"blob, [encoding]",__proto__:null,},FontFaceSet:{add:"font",check:"font, [text=\" \"]",delete:"font",load:"font, [text=\" \"]",__proto__:null,},FormData:{append:"[name], [value], [filename]",__proto__:null,},Geolocation:{clearWatch:"watchID",getCurrentPosition:"successCallback, [errorCallback], [options]",watchPosition:"successCallback, [errorCallback], [options]",__proto__:null,},HTMLAllCollection:{item:"[index]",namedItem:"name",tags:"name",__proto__:null,},HTMLButtonElement:{setCustomValidity:"error",__proto__:null,},HTMLCanvasElement:{getContext:"contextId",toDataURL:"[type]",__proto__:null,},HTMLCollection:{item:"[index]",namedItem:"[name]",__proto__:null,},HTMLDocument:{write:"[html]",writeln:"[html]",__proto__:null,},HTMLElement:{insertAdjacentElement:"[position], [element]",insertAdjacentHTML:"[position], [html]",insertAdjacentText:"[position], [text]",__proto__:null,},HTMLFieldSetElement:{setCustomValidity:"error",__proto__:null,},HTMLFormControlsCollection:{namedItem:"[name]",__proto__:null,},HTMLInputElement:{setCustomValidity:"error",setRangeText:"replacement",setSelectionRange:"start, end, [direction]",stepDown:"[n]",stepUp:"[n]",__proto__:null,},HTMLKeygenElement:{setCustomValidity:"error",__proto__:null,},HTMLMediaElement:{addTextTrack:"kind, [label], [language]",canPlayType:"[type], [keySystem]",fastSeek:"time",webkitAddKey:"keySystem, key, [initData], [sessionId]",webkitCancelKeyRequest:"keySystem, [sessionId]",webkitGenerateKeyRequest:"keySystem, [initData]",webkitSetMediaKeys:"mediaKeys",__proto__:null,},HTMLObjectElement:{setCustomValidity:"error",__proto__:null,},HTMLOptionsCollection:{add:"element, [before]",namedItem:"[name]",remove:"[index]",__proto__:null,},HTMLOutputElement:{setCustomValidity:"error",__proto__:null,},HTMLSelectElement:{add:"element, [before]",item:"index",namedItem:"[name]",setCustomValidity:"error",__proto__:null,},HTMLSlotElement:{assignedNodes:"[options]",__proto__:null,},HTMLTableElement:{deleteRow:"index",insertRow:"[index]",__proto__:null,},HTMLTableRowElement:{deleteCell:"index",insertCell:"[index]",__proto__:null,},HTMLTableSectionElement:{deleteRow:"index",insertRow:"[index]",__proto__:null,},HTMLTextAreaElement:{setCustomValidity:"error",setRangeText:"replacement",setSelectionRange:"[start], [end], [direction]",__proto__:null,},HTMLVideoElement:{webkitSetPresentationMode:"mode",webkitSupportsPresentationMode:"mode",__proto__:null,},HashChangeEvent:{initHashChangeEvent:"[type], [canBubble], [cancelable], [oldURL], [newURL]",__proto__:null,},History:{go:"[distance]",pushState:"data, title, [url]",replaceState:"data, title, [url]",__proto__:null,},IDBCursor:{advance:"count",continue:"[key]",update:"value",__proto__:null,},IDBDatabase:{createObjectStore:"name, [options]",deleteObjectStore:"name",transaction:"storeName, [mode]",__proto__:null,},IDBFactory:{cmp:"first, second",deleteDatabase:"name",open:"name, [version]",__proto__:null,},IDBIndex:{count:"[range]",get:"key",getKey:"key",openCursor:"[range], [direction]",openKeyCursor:"[range], [direction]",__proto__:null,},IDBObjectStore:{add:"value, [key]",count:"[range]",createIndex:"name, keyPath, [options]",delete:"keyRange",deleteIndex:"name",get:"key",index:"name",openCursor:"[range], [direction]",put:"value, [key]",__proto__:null,},IDBTransaction:{objectStore:"name",__proto__:null,},KeyboardEvent:{initKeyboardEvent:"[type], [canBubble], [cancelable], [view], [keyIdentifier], [location], [ctrlKey], [altKey], [shiftKey], [metaKey], [altGraphKey]",__proto__:null,},Location:{assign:"[url]",reload:"[force=false]",replace:"[url]",__proto__:null,},MediaController:{__proto__:null,},MediaControlsHost:{displayNameForTrack:"track",mediaUIImageData:"partID",setSelectedTextTrack:"track",sortedTrackListForMenu:"trackList",__proto__:null,},MediaList:{appendMedium:"[newMedium]",deleteMedium:"[oldMedium]",item:"[index]",__proto__:null,},MediaQueryList:{addListener:"[listener]",removeListener:"[listener]",__proto__:null,},MediaQueryListListener:{queryChanged:"[list]",__proto__:null,},MediaSource:{addSourceBuffer:"type",endOfStream:"[error]",removeSourceBuffer:"buffer",__proto__:null,},MediaStreamTrack:{applyConstraints:"constraints",__proto__:null,},MediaStreamTrackSourcesCallback:{handleEvent:"sources",__proto__:null,},MessageEvent:{initMessageEvent:"type, [bubbles], [cancelable], [data], [origin], [lastEventId], [source], [messagePorts]",__proto__:null,},MessagePort:{__proto__:null,},MimeTypeArray:{item:"[index]",namedItem:"[name]",__proto__:null,},MouseEvent:{initMouseEvent:"[type], [canBubble], [cancelable], [view], [detail], [screenX], [screenY], [clientX], [clientY], [ctrlKey], [altKey], [shiftKey], [metaKey], [button], [relatedTarget]",__proto__:null,},MutationEvent:{initMutationEvent:"[type], [canBubble], [cancelable], [relatedNode], [prevValue], [newValue], [attrName], [attrChange]",__proto__:null,},MutationObserver:{observe:"target, options",__proto__:null,},NamedNodeMap:{getNamedItem:"[name]",getNamedItemNS:"[namespaceURI], [localName]",item:"[index]",removeNamedItem:"[name]",removeNamedItemNS:"[namespaceURI], [localName]",setNamedItem:"[node]",setNamedItemNS:"[node]",__proto__:null,},Navigator:{getUserMedia:"options, successCallback, errorCallback",__proto__:null,},NavigatorUserMediaErrorCallback:{handleEvent:"error",__proto__:null,},NavigatorUserMediaSuccessCallback:{handleEvent:"stream",__proto__:null,},NodeFilter:{acceptNode:"[n]",__proto__:null,},NodeList:{item:"index",__proto__:null,},Notification:{__proto__:null,},NotificationCenter:{createNotification:"iconUrl, title, body",requestPermission:"[callback]",__proto__:null,},NotificationPermissionCallback:{handleEvent:"permission",__proto__:null,},OESVertexArrayObject:{bindVertexArrayOES:"[arrayObject]",deleteVertexArrayOES:"[arrayObject]",isVertexArrayOES:"[arrayObject]",__proto__:null,},OscillatorNode:{noteOff:"when",noteOn:"when",setPeriodicWave:"wave",start:"[when]",stop:"[when]",__proto__:null,},Path2D:{addPath:"path, [transform]",arc:"[x], [y], [radius], [startAngle], [endAngle], [anticlockwise]",arcTo:"[x1], [y1], [x2], [y2], [radius]",bezierCurveTo:"[cp1x], [cp1y], [cp2x], [cp2y], [x], [y]",ellipse:"x, y, radiusX, radiusY, rotation, startAngle, endAngle, [anticlockwise]",lineTo:"[x], [y]",moveTo:"[x], [y]",quadraticCurveTo:"[cpx], [cpy], [x], [y]",rect:"[x], [y], [width], [height]",__proto__:null,},Performance:{clearMarks:"[name]",clearMeasures:"name",getEntriesByName:"name, [type]",getEntriesByType:"type",mark:"name",measure:"name, [startMark], [endMark]",__proto__:null,},PerformanceObserver:{observe:"options",__proto__:null,},PerformanceObserverEntryList:{getEntriesByName:"name, [type]",getEntriesByType:"type",__proto__:null,},Plugin:{item:"[index]",namedItem:"[name]",__proto__:null,},PluginArray:{item:"[index]",namedItem:"[name]",refresh:"[reload]",__proto__:null,},PositionCallback:{handleEvent:"position",__proto__:null,},PositionErrorCallback:{handleEvent:"error",__proto__:null,},QuickTimePluginReplacement:{postEvent:"eventName",__proto__:null,},RTCDTMFSender:{insertDTMF:"tones, [duration], [interToneGap]",__proto__:null,},RTCDataChannel:{send:"data",__proto__:null,},RTCPeerConnectionErrorCallback:{handleEvent:"error",__proto__:null,},RTCSessionDescriptionCallback:{handleEvent:"sdp",__proto__:null,},RTCStatsCallback:{handleEvent:"response",__proto__:null,},RTCStatsReport:{stat:"name",__proto__:null,},RTCStatsResponse:{namedItem:"[name]",__proto__:null,},Range:{collapse:"[toStart]",compareBoundaryPoints:"[how], [sourceRange]",compareNode:"[refNode]",comparePoint:"[refNode], [offset]",createContextualFragment:"[html]",expand:"[unit]",insertNode:"[newNode]",intersectsNode:"[refNode]",isPointInRange:"[refNode], [offset]",selectNode:"[refNode]",selectNodeContents:"[refNode]",setEnd:"[refNode], [offset]",setEndAfter:"[refNode]",setEndBefore:"[refNode]",setStart:"[refNode], [offset]",setStartAfter:"[refNode]",setStartBefore:"[refNode]",surroundContents:"[newParent]",__proto__:null,},ReadableStream:{cancel:"reason",pipeThrough:"dest, options",pipeTo:"streams, options",__proto__:null,},WritableStream:{abort:"reason",close:"",write:"chunk",__proto__:null,},RequestAnimationFrameCallback:{handleEvent:"highResTime",__proto__:null,},SQLResultSetRowList:{item:"index",__proto__:null,},SQLStatementCallback:{handleEvent:"transaction, resultSet",__proto__:null,},SQLStatementErrorCallback:{handleEvent:"transaction, error",__proto__:null,},SQLTransaction:{executeSql:"sqlStatement, arguments, [callback], [errorCallback]",__proto__:null,},SQLTransactionCallback:{handleEvent:"transaction",__proto__:null,},SQLTransactionErrorCallback:{handleEvent:"error",__proto__:null,},SVGAngle:{convertToSpecifiedUnits:"unitType",newValueSpecifiedUnits:"unitType, valueInSpecifiedUnits",__proto__:null,},SVGAnimationElement:{beginElementAt:"[offset]",endElementAt:"[offset]",hasExtension:"[extension]",__proto__:null,},SVGColor:{setColor:"colorType, rgbColor, iccColor",setRGBColor:"rgbColor",setRGBColorICCColor:"rgbColor, iccColor",__proto__:null,},SVGCursorElement:{hasExtension:"[extension]",__proto__:null,},SVGDocument:{createEvent:"[eventType]",__proto__:null,},SVGElement:{getPresentationAttribute:"[name]",__proto__:null,},SVGFEDropShadowElement:{setStdDeviation:"[stdDeviationX], [stdDeviationY]",__proto__:null,},SVGFEGaussianBlurElement:{setStdDeviation:"[stdDeviationX], [stdDeviationY]",__proto__:null,},SVGFEMorphologyElement:{setRadius:"[radiusX], [radiusY]",__proto__:null,},SVGFilterElement:{setFilterRes:"[filterResX], [filterResY]",__proto__:null,},SVGGraphicsElement:{getTransformToElement:"[element]",hasExtension:"[extension]",__proto__:null,},SVGLength:{convertToSpecifiedUnits:"unitType",newValueSpecifiedUnits:"unitType, valueInSpecifiedUnits",__proto__:null,},SVGLengthList:{appendItem:"item",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null,},SVGMarkerElement:{setOrientToAngle:"[angle]",__proto__:null,},SVGMaskElement:{hasExtension:"[extension]",__proto__:null,},SVGMatrix:{multiply:"secondMatrix",rotate:"angle",rotateFromVector:"x, y",scale:"scaleFactor",scaleNonUniform:"scaleFactorX, scaleFactorY",skewX:"angle",skewY:"angle",translate:"x, y",__proto__:null,},SVGNumberList:{appendItem:"item",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null,},SVGPaint:{setPaint:"paintType, uri, rgbColor, iccColor",setUri:"uri",__proto__:null,},SVGPathElement:{createSVGPathSegArcAbs:"[x], [y], [r1], [r2], [angle], [largeArcFlag], [sweepFlag]",createSVGPathSegArcRel:"[x], [y], [r1], [r2], [angle], [largeArcFlag], [sweepFlag]",createSVGPathSegCurvetoCubicAbs:"[x], [y], [x1], [y1], [x2], [y2]",createSVGPathSegCurvetoCubicRel:"[x], [y], [x1], [y1], [x2], [y2]",createSVGPathSegCurvetoCubicSmoothAbs:"[x], [y], [x2], [y2]",createSVGPathSegCurvetoCubicSmoothRel:"[x], [y], [x2], [y2]",createSVGPathSegCurvetoQuadraticAbs:"[x], [y], [x1], [y1]",createSVGPathSegCurvetoQuadraticRel:"[x], [y], [x1], [y1]",createSVGPathSegCurvetoQuadraticSmoothAbs:"[x], [y]",createSVGPathSegCurvetoQuadraticSmoothRel:"[x], [y]",createSVGPathSegLinetoAbs:"[x], [y]",createSVGPathSegLinetoHorizontalAbs:"[x]",createSVGPathSegLinetoHorizontalRel:"[x]",createSVGPathSegLinetoRel:"[x], [y]",createSVGPathSegLinetoVerticalAbs:"[y]",createSVGPathSegLinetoVerticalRel:"[y]",createSVGPathSegMovetoAbs:"[x], [y]",createSVGPathSegMovetoRel:"[x], [y]",getPathSegAtLength:"[distance]",getPointAtLength:"[distance]",__proto__:null,},SVGPathSegList:{appendItem:"newItem",getItem:"index",initialize:"newItem",insertItemBefore:"newItem, index",removeItem:"index",replaceItem:"newItem, index",__proto__:null,},SVGPatternElement:{hasExtension:"[extension]",__proto__:null,},SVGPoint:{matrixTransform:"matrix",__proto__:null,},SVGPointList:{appendItem:"item",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null,},SVGSVGElement:{checkEnclosure:"[element], [rect]",checkIntersection:"[element], [rect]",createSVGTransformFromMatrix:"[matrix]",getElementById:"[elementId]",getEnclosureList:"[rect], [referenceElement]",getIntersectionList:"[rect], [referenceElement]",setCurrentTime:"[seconds]",suspendRedraw:"[maxWaitMilliseconds]",unsuspendRedraw:"[suspendHandleId]",__proto__:null,},SVGStringList:{appendItem:"item",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null,},SVGTextContentElement:{getCharNumAtPosition:"[point]",getEndPositionOfChar:"[offset]",getExtentOfChar:"[offset]",getRotationOfChar:"[offset]",getStartPositionOfChar:"[offset]",getSubStringLength:"[offset], [length]",selectSubString:"[offset], [length]",__proto__:null,},SVGTransform:{setMatrix:"matrix",setRotate:"angle, cx, cy",setScale:"sx, sy",setSkewX:"angle",setSkewY:"angle",setTranslate:"tx, ty",__proto__:null,},SVGTransformList:{appendItem:"item",createSVGTransformFromMatrix:"matrix",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null,},SecurityPolicy:{allowsConnectionTo:"url",allowsFontFrom:"url",allowsFormAction:"url",allowsFrameFrom:"url",allowsImageFrom:"url",allowsMediaFrom:"url",allowsObjectFrom:"url",allowsPluginType:"type",allowsScriptFrom:"url",allowsStyleFrom:"url",__proto__:null,},Selection:{addRange:"[range]",collapse:"[node], [index]",containsNode:"[node], [allowPartial]",extend:"[node], [offset]",getRangeAt:"[index]",modify:"[alter], [direction], [granularity]",selectAllChildren:"[node]",setBaseAndExtent:"[baseNode], [baseOffset], [extentNode], [extentOffset]",setPosition:"[node], [offset]",__proto__:null,},SourceBuffer:{appendBuffer:"data",remove:"start, end",__proto__:null,},SourceBufferList:{item:"index",__proto__:null,},SpeechSynthesis:{speak:"utterance",__proto__:null,},SpeechSynthesisUtterance:{__proto__:null,},Storage:{getItem:"key",key:"index",removeItem:"key",setItem:"key, data",__proto__:null,},StorageErrorCallback:{handleEvent:"error",__proto__:null,},StorageEvent:{initStorageEvent:"[typeArg], [canBubbleArg], [cancelableArg], [keyArg], [oldValueArg], [newValueArg], [urlArg], [storageAreaArg]",__proto__:null,},StorageInfo:{queryUsageAndQuota:"storageType, [usageCallback], [errorCallback]",requestQuota:"storageType, newQuotaInBytes, [quotaCallback], [errorCallback]",__proto__:null,},StorageQuota:{queryUsageAndQuota:"usageCallback, [errorCallback]",requestQuota:"newQuotaInBytes, [quotaCallback], [errorCallback]",__proto__:null,},StorageQuotaCallback:{handleEvent:"grantedQuotaInBytes",__proto__:null,},StorageUsageCallback:{handleEvent:"currentUsageInBytes, currentQuotaInBytes",__proto__:null,},StringCallback:{handleEvent:"data",__proto__:null,},StyleMedia:{matchMedium:"[mediaquery]",__proto__:null,},StyleSheetList:{item:"[index]",__proto__:null,},Text:{replaceWholeText:"[content]",splitText:"offset",__proto__:null,},TextEvent:{initTextEvent:"[typeArg], [canBubbleArg], [cancelableArg], [viewArg], [dataArg]",__proto__:null,},TextTrack:{addCue:"cue",addRegion:"region",removeCue:"cue",removeRegion:"region",__proto__:null,},TextTrackCue:{__proto__:null,},TextTrackCueList:{getCueById:"id",item:"index",__proto__:null,},TextTrackList:{getTrackById:"id",item:"index",__proto__:null,},TimeRanges:{end:"index",start:"index",__proto__:null,},TouchEvent:{initTouchEvent:"[touches], [targetTouches], [changedTouches], [type], [view], [screenX], [screenY], [clientX], [clientY], [ctrlKey], [altKey], [shiftKey], [metaKey]",__proto__:null,},TouchList:{item:"index",__proto__:null,},UIEvent:{initUIEvent:"[type], [canBubble], [cancelable], [view], [detail]",__proto__:null,},UserMessageHandler:{postMessage:"message",__proto__:null,},VTTRegionList:{getRegionById:"id",item:"index",__proto__:null,},VideoTrackList:{getTrackById:"id",item:"index",__proto__:null,},WebGL2RenderingContext:{beginQuery:"target, query",beginTransformFeedback:"primitiveMode",bindBufferBase:"target, index, buffer",bindBufferRange:"target, index, buffer, offset, size",bindSampler:"unit, sampler",bindTransformFeedback:"target, id",bindVertexArray:"vertexArray",blitFramebuffer:"srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter",clearBufferfi:"buffer, drawbuffer, depth, stencil",clearBufferfv:"buffer, drawbuffer, value",clearBufferiv:"buffer, drawbuffer, value",clearBufferuiv:"buffer, drawbuffer, value",clientWaitSync:"sync, flags, timeout",compressedTexImage3D:"target, level, internalformat, width, height, depth, border, imageSize, data",compressedTexSubImage3D:"target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data",copyBufferSubData:"readTarget, writeTarget, readOffset, writeOffset, size",copyTexSubImage3D:"target, level, xoffset, yoffset, zoffset, x, y, width, height",deleteQuery:"query",deleteSampler:"sampler",deleteSync:"sync",deleteTransformFeedback:"id",deleteVertexArray:"vertexArray",drawArraysInstanced:"mode, first, count, instanceCount",drawBuffers:"buffers",drawElementsInstanced:"mode, count, type, offset, instanceCount",drawRangeElements:"mode, start, end, count, type, offset",endQuery:"target",fenceSync:"condition, flags",framebufferTextureLayer:"target, attachment, texture, level, layer",getActiveUniformBlockName:"program, uniformBlockIndex",getActiveUniformBlockParameter:"program, uniformBlockIndex, pname",getActiveUniforms:"program, uniformIndices, pname",getBufferSubData:"target, offset, returnedData",getFragDataLocation:"program, name",getIndexedParameter:"target, index",getInternalformatParameter:"target, internalformat, pname",getQuery:"target, pname",getQueryParameter:"query, pname",getSamplerParameter:"sampler, pname",getSyncParameter:"sync, pname",getTransformFeedbackVarying:"program, index",getUniformBlockIndex:"program, uniformBlockName",getUniformIndices:"program, uniformNames",invalidateFramebuffer:"target, attachments",invalidateSubFramebuffer:"target, attachments, x, y, width, height",isQuery:"query",isSampler:"sampler",isSync:"sync",isTransformFeedback:"id",isVertexArray:"vertexArray",readBuffer:"src",renderbufferStorageMultisample:"target, samples, internalformat, width, height",samplerParameterf:"sampler, pname, param",samplerParameteri:"sampler, pname, param",texImage3D:"target, level, internalformat, width, height, depth, border, format, type, pixels",texStorage2D:"target, levels, internalformat, width, height",texStorage3D:"target, levels, internalformat, width, height, depth",texSubImage3D:"target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels",transformFeedbackVaryings:"program, varyings, bufferMode",uniform1ui:"location, v0",uniform1uiv:"location, value",uniform2ui:"location, v0, v1",uniform2uiv:"location, value",uniform3ui:"location, v0, v1, v2",uniform3uiv:"location, value",uniform4ui:"location, v0, v1, v2, v3",uniform4uiv:"location, value",uniformBlockBinding:"program, uniformBlockIndex, uniformBlockBinding",uniformMatrix2x3fv:"location, transpose, value",uniformMatrix2x4fv:"location, transpose, value",uniformMatrix3x2fv:"location, transpose, value",uniformMatrix3x4fv:"location, transpose, value",uniformMatrix4x2fv:"location, transpose, value",uniformMatrix4x3fv:"location, transpose, value",vertexAttribDivisor:"index, divisor",vertexAttribI4i:"index, x, y, z, w",vertexAttribI4iv:"index, v",vertexAttribI4ui:"index, x, y, z, w",vertexAttribI4uiv:"index, v",vertexAttribIPointer:"index, size, type, stride, offset",waitSync:"sync, flags, timeout",__proto__:null,},WebGLDebugShaders:{getTranslatedShaderSource:"shader",__proto__:null,},WebGLDrawBuffers:{drawBuffersWEBGL:"buffers",__proto__:null,},WebGLRenderingContextBase:{activeTexture:"texture",attachShader:"program, shader",bindAttribLocation:"program, index, name",bindBuffer:"target, buffer",bindFramebuffer:"target, framebuffer",bindRenderbuffer:"target, renderbuffer",bindTexture:"target, texture",blendColor:"red, green, blue, alpha",blendEquation:"mode",blendEquationSeparate:"modeRGB, modeAlpha",blendFunc:"sfactor, dfactor",blendFuncSeparate:"srcRGB, dstRGB, srcAlpha, dstAlpha",bufferData:"target, data, usage",bufferSubData:"target, offset, data",checkFramebufferStatus:"target",clear:"mask",clearColor:"red, green, blue, alpha",clearDepth:"depth",clearStencil:"s",colorMask:"red, green, blue, alpha",compileShader:"shader",compressedTexImage2D:"target, level, internalformat, width, height, border, data",compressedTexSubImage2D:"target, level, xoffset, yoffset, width, height, format, data",copyTexImage2D:"target, level, internalformat, x, y, width, height, border",copyTexSubImage2D:"target, level, xoffset, yoffset, x, y, width, height",createShader:"type",cullFace:"mode",deleteBuffer:"buffer",deleteFramebuffer:"framebuffer",deleteProgram:"program",deleteRenderbuffer:"renderbuffer",deleteShader:"shader",deleteTexture:"texture",depthFunc:"func",depthMask:"flag",depthRange:"zNear, zFar",detachShader:"program, shader",disable:"cap",disableVertexAttribArray:"index",drawArrays:"mode, first, count",drawElements:"mode, count, type, offset",enable:"cap",enableVertexAttribArray:"index",framebufferRenderbuffer:"target, attachment, renderbuffertarget, renderbuffer",framebufferTexture2D:"target, attachment, textarget, texture, level",frontFace:"mode",generateMipmap:"target",getActiveAttrib:"program, index",getActiveUniform:"program, index",getAttachedShaders:"program",getAttribLocation:"program, name",getBufferParameter:"target, pname",getExtension:"name",getFramebufferAttachmentParameter:"target, attachment, pname",getParameter:"pname",getProgramInfoLog:"program",getProgramParameter:"program, pname",getRenderbufferParameter:"target, pname",getShaderInfoLog:"shader",getShaderParameter:"shader, pname",getShaderPrecisionFormat:"shadertype, precisiontype",getShaderSource:"shader",getTexParameter:"target, pname",getUniform:"program, location",getUniformLocation:"program, name",getVertexAttrib:"index, pname",getVertexAttribOffset:"index, pname",hint:"target, mode",isBuffer:"buffer",isEnabled:"cap",isFramebuffer:"framebuffer",isProgram:"program",isRenderbuffer:"renderbuffer",isShader:"shader",isTexture:"texture",lineWidth:"width",linkProgram:"program",pixelStorei:"pname, param",polygonOffset:"factor, units",readPixels:"x, y, width, height, format, type, pixels",renderbufferStorage:"target, internalformat, width, height",sampleCoverage:"value, invert",scissor:"x, y, width, height",shaderSource:"shader, string",stencilFunc:"func, ref, mask",stencilFuncSeparate:"face, func, ref, mask",stencilMask:"mask",stencilMaskSeparate:"face, mask",stencilOp:"fail, zfail, zpass",stencilOpSeparate:"face, fail, zfail, zpass",texImage2D:"target, level, internalformat, width, height, border, format, type, pixels",texParameterf:"target, pname, param",texParameteri:"target, pname, param",texSubImage2D:"target, level, xoffset, yoffset, width, height, format, type, pixels",uniform1f:"location, x",uniform1fv:"location, v",uniform1i:"location, x",uniform1iv:"location, v",uniform2f:"location, x, y",uniform2fv:"location, v",uniform2i:"location, x, y",uniform2iv:"location, v",uniform3f:"location, x, y, z",uniform3fv:"location, v",uniform3i:"location, x, y, z",uniform3iv:"location, v",uniform4f:"location, x, y, z, w",uniform4fv:"location, v",uniform4i:"location, x, y, z, w",uniform4iv:"location, v",uniformMatrix2fv:"location, transpose, array",uniformMatrix3fv:"location, transpose, array",uniformMatrix4fv:"location, transpose, array",useProgram:"program",validateProgram:"program",vertexAttrib1f:"indx, x",vertexAttrib1fv:"indx, values",vertexAttrib2f:"indx, x, y",vertexAttrib2fv:"indx, values",vertexAttrib3f:"indx, x, y, z",vertexAttrib3fv:"indx, values",vertexAttrib4f:"indx, x, y, z, w",vertexAttrib4fv:"indx, values",vertexAttribPointer:"indx, size, type, normalized, stride, offset",viewport:"x, y, width, height",__proto__:null,},WebKitCSSMatrix:{multiply:"[secondMatrix]",rotate:"[rotX], [rotY], [rotZ]",rotateAxisAngle:"[x], [y], [z], [angle]",scale:"[scaleX], [scaleY], [scaleZ]",setMatrixValue:"[string]",skewX:"[angle]",skewY:"[angle]",translate:"[x], [y], [z]",__proto__:null,},WebKitMediaKeySession:{update:"key",__proto__:null,},WebKitMediaKeys:{createSession:"[type], [initData]",__proto__:null,},WebKitNamedFlow:{getRegionsByContent:"contentNode",__proto__:null,},WebKitNamedFlowCollection:{item:"index",namedItem:"name",__proto__:null,},WebKitSubtleCrypto:{decrypt:"algorithm, key, data",digest:"algorithm, data",encrypt:"algorithm, key, data",exportKey:"format, key",generateKey:"algorithm, [extractable], [keyUsages]",importKey:"format, keyData, algorithm, [extractable], [keyUsages]",sign:"algorithm, key, data",unwrapKey:"format, wrappedKey, unwrappingKey, unwrapAlgorithm, unwrappedKeyAlgorithm, [extractable], [keyUsages]",verify:"algorithm, key, signature, data",wrapKey:"format, key, wrappingKey, wrapAlgorithm",__proto__:null,},WebSocket:{close:"[code], [reason]",send:"data",__proto__:null,},WheelEvent:{initWebKitWheelEvent:"[wheelDeltaX], [wheelDeltaY], [view], [screenX], [screenY], [clientX], [clientY], [ctrlKey], [altKey], [shiftKey], [metaKey]",__proto__:null,},Worker:{postMessage:"message, [messagePorts]",__proto__:null,},WorkerGlobalScope:{clearInterval:"[handle]",clearTimeout:"[handle]",setInterval:"handler, [timeout]",setTimeout:"handler, [timeout]",__proto__:null,},XMLHttpRequest:{getResponseHeader:"header",open:"method, url, [async], [user], [password]",overrideMimeType:"override",setRequestHeader:"header, value",__proto__:null,},XMLHttpRequestUpload:{__proto__:null,},XMLSerializer:{serializeToString:"[node]",__proto__:null,},XPathEvaluator:{createExpression:"[expression], [resolver]",createNSResolver:"[nodeResolver]",evaluate:"[expression], [contextNode], [resolver], [type], [inResult]",__proto__:null,},XPathExpression:{evaluate:"[contextNode], [type], [inResult]",__proto__:null,},XPathNSResolver:{lookupNamespaceURI:"[prefix]",__proto__:null,},XPathResult:{snapshotItem:"[index]",__proto__:null,},XSLTProcessor:{getParameter:"namespaceURI, localName",importStylesheet:"[stylesheet]",removeParameter:"namespaceURI, localName",setParameter:"namespaceURI, localName, value",transformToDocument:"[source]",transformToFragment:"[source], [docVal]",__proto__:null,},webkitAudioContext:{createBuffer:"numberOfChannels, numberOfFrames, sampleRate",createChannelMerger:"[numberOfInputs]",createChannelSplitter:"[numberOfOutputs]",createDelay:"[maxDelayTime]",createDelayNode:"[maxDelayTime]",createJavaScriptNode:"bufferSize, [numberOfInputChannels], [numberOfOutputChannels]",createMediaElementSource:"mediaElement",createPeriodicWave:"real, imag",createScriptProcessor:"bufferSize, [numberOfInputChannels], [numberOfOutputChannels]",decodeAudioData:"audioData, successCallback, [errorCallback]",__proto__:null,},webkitAudioPannerNode:{setOrientation:"x, y, z",setPosition:"x, y, z",setVelocity:"x, y, z",__proto__:null,},webkitMediaStream:{addTrack:"track",getTrackById:"trackId",removeTrack:"track",__proto__:null,},webkitRTCPeerConnection:{addIceCandidate:"candidate, successCallback, failureCallback",addStream:"stream",createAnswer:"successCallback, failureCallback, [answerOptions]",createDTMFSender:"track",createDataChannel:"label, [options]",createOffer:"successCallback, failureCallback, [offerOptions]",getStats:"successCallback, failureCallback, [selector]",getStreamById:"streamId",removeStream:"stream",setLocalDescription:"description, successCallback, failureCallback",setRemoteDescription:"description, successCallback, failureCallback",updateIce:"configuration",__proto__:null,},EventTarget:{addEventListener:"type, listener, [useCapture=false]",removeEventListener:"type, listener, [useCapture=false]",dispatchEvent:"event",__proto__:null,},};(function(){
var EventTarget=WebInspector.NativePrototypeFunctionParameters.EventTarget;var eventTargetTypes=["Node","Window","AudioNode","AudioTrackList","DOMApplicationCache","FileReader","MediaController","MediaStreamTrack","MessagePort","Notification","RTCDTMFSender","SpeechSynthesisUtterance","TextTrack","TextTrackCue","TextTrackList","VideoTrackList","WebKitMediaKeySession","WebKitNamedFlow","WebSocket","WorkerGlobalScope","XMLHttpRequest","webkitMediaStream","webkitRTCPeerConnection"];for(var type of eventTargetTypes)
Object.assign(WebInspector.NativePrototypeFunctionParameters[type],EventTarget);var ElementQueries={getElementsByClassName:"classNames",getElementsByTagName:"tagName",getElementsByTagNameNS:"namespace, localName",querySelector:"selectors",querySelectorAll:"selectors",};Object.assign(WebInspector.NativePrototypeFunctionParameters.Element,ElementQueries);Object.assign(WebInspector.NativePrototypeFunctionParameters.Document,ElementQueries);var ChildNode={after:"[node|string]...",before:"[node|string]...",replaceWith:"[node|string]...",};Object.assign(WebInspector.NativePrototypeFunctionParameters.Element,ChildNode);Object.assign(WebInspector.NativePrototypeFunctionParameters.CharacterData,ChildNode);var ParentNode={append:"[node|string]...",prepend:"[node|string]...",};Object.assign(WebInspector.NativePrototypeFunctionParameters.Element,ParentNode);Object.assign(WebInspector.NativePrototypeFunctionParameters.Document,ParentNode);Object.assign(WebInspector.NativePrototypeFunctionParameters.DocumentFragment,ParentNode);WebInspector.NativePrototypeFunctionParameters.Console=WebInspector.NativeConstructorFunctionParameters.Console;})();WebInspector.NetworkInstrument=class NetworkInstrument extends WebInspector.Instrument
{ get timelineRecordType()
{return WebInspector.TimelineRecord.Type.Network;}
startInstrumentation(initiatedByBackend)
{}
stopInstrumentation(initiatedByBackend)
{}};WebInspector.NetworkTimeline=class NetworkTimeline extends WebInspector.Timeline
{ recordForResource(resource)
{return this._resourceRecordMap.get(resource)||null;}
reset(suppressEvents)
{this._resourceRecordMap=new Map;super.reset(suppressEvents);}
addRecord(record)
{if(this._resourceRecordMap.has(record.resource))
return;this._resourceRecordMap.set(record.resource,record);super.addRecord(record);}};WebInspector.ObjectPreview=class ObjectPreview extends WebInspector.Object
{constructor(type,subtype,description,lossless,overflow,properties,entries,size)
{super();this._type=type;this._subtype=subtype;this._description=description||"";this._lossless=lossless;this._overflow=overflow||false;this._size=size;this._properties=properties||null;this._entries=entries||null;}

static fromPayload(payload)
{if(payload.properties)
payload.properties=payload.properties.map(WebInspector.PropertyPreview.fromPayload);if(payload.entries)
payload.entries=payload.entries.map(WebInspector.CollectionEntryPreview.fromPayload);if(payload.subtype==="array"){var match=payload.description.match(/\[(\d+)\]$/);if(match){payload.size=parseInt(match[1]);payload.description=payload.description.replace(/\[\d+\]$/,"");}}
return new WebInspector.ObjectPreview(payload.type,payload.subtype,payload.description,payload.lossless,payload.overflow,payload.properties,payload.entries,payload.size);} 
get type(){return this._type;}
get subtype(){return this._subtype;}
get description(){return this._description;}
get lossless(){return this._lossless;}
get overflow(){return this._overflow;}
get propertyPreviews(){return this._properties;}
get collectionEntryPreviews(){return this._entries;}
get size(){return this._size;}
hasSize()
{return this._size!==undefined&&(this._subtype==="array"||this._subtype==="set"||this._subtype==="map"||this._subtype==="weakmap"||this._subtype==="weakset");}};WebInspector.ProbeSample=class ProbeSample extends WebInspector.Object
{constructor(sampleId,batchId,elapsedTime,object)
{super();this.sampleId=sampleId;this.batchId=batchId;this.timestamp=elapsedTime;this.object=object;}};WebInspector.Probe=class Probe extends WebInspector.Object
{constructor(id,breakpoint,expression)
{super();this._id=id;this._breakpoint=breakpoint;this._expression=expression;this._samples=[];} 
get id()
{return this._id;}
get breakpoint()
{return this._breakpoint;}
get expression()
{return this._expression;}
set expression(value)
{if(this._expression===value)
return;var data={oldValue:this._expression,newValue:value};this._expression=value;this.clearSamples();this.dispatchEventToListeners(WebInspector.Probe.Event.ExpressionChanged,data);}
get samples()
{return this._samples.slice();}
clearSamples()
{this._samples=[];this.dispatchEventToListeners(WebInspector.Probe.Event.SamplesCleared);}
addSample(sample)
{this._samples.push(sample);this.dispatchEventToListeners(WebInspector.Probe.Event.SampleAdded,sample);}};WebInspector.Probe.Event={ExpressionChanged:"probe-object-expression-changed",SampleAdded:"probe-object-sample-added",SamplesCleared:"probe-object-samples-cleared"};WebInspector.ProbeSet=class ProbeSet extends WebInspector.Object
{constructor(breakpoint)
{super();this._breakpoint=breakpoint;this._probes=[];this._probesByIdentifier=new Map;this._createDataTable();WebInspector.Frame.addEventListener(WebInspector.Frame.Event.MainResourceDidChange,this._mainResourceChanged,this);WebInspector.Probe.addEventListener(WebInspector.Probe.Event.SampleAdded,this._sampleCollected,this);WebInspector.Breakpoint.addEventListener(WebInspector.Breakpoint.Event.ResolvedStateDidChange,this._breakpointResolvedStateDidChange,this);} 
get breakpoint(){return this._breakpoint;}
get probes(){return this._probes.slice();}
get dataTable(){return this._dataTable;}
clear()
{this._breakpoint.clearActions(WebInspector.BreakpointAction.Type.Probe);}
clearSamples()
{for(var probe of this._probes)
probe.clearSamples();var oldTable=this._dataTable;this._createDataTable();this.dispatchEventToListeners(WebInspector.ProbeSet.Event.SamplesCleared,{oldTable});}
createProbe(expression)
{this.breakpoint.createAction(WebInspector.BreakpointAction.Type.Probe,null,expression);}
addProbe(probe)
{this._probes.push(probe);this._probesByIdentifier.set(probe.id,probe);this.dataTable.addProbe(probe);this.dispatchEventToListeners(WebInspector.ProbeSet.Event.ProbeAdded,probe);}
removeProbe(probe)
{this._probes.splice(this._probes.indexOf(probe),1);this._probesByIdentifier.delete(probe.id);this.dataTable.removeProbe(probe);this.dispatchEventToListeners(WebInspector.ProbeSet.Event.ProbeRemoved,probe);}
willRemove()
{WebInspector.Frame.removeEventListener(WebInspector.Frame.Event.MainResourceDidChange,this._mainResourceChanged,this);WebInspector.Probe.removeEventListener(WebInspector.Probe.Event.SampleAdded,this._sampleCollected,this);WebInspector.Breakpoint.removeEventListener(WebInspector.Breakpoint.Event.ResolvedStateDidChange,this._breakpointResolvedStateDidChange,this);} 
_mainResourceChanged()
{this.dataTable.mainResourceChanged();}
_createDataTable()
{if(this.dataTable)
this.dataTable.willRemove();this._dataTable=new WebInspector.ProbeSetDataTable(this);}
_sampleCollected(event)
{var sample=event.data;var probe=event.target;if(!this._probesByIdentifier.has(probe.id))
return;this.dataTable.addSampleForProbe(probe,sample);this.dispatchEventToListeners(WebInspector.ProbeSet.Event.SampleAdded,{probe,sample});}
_breakpointResolvedStateDidChange(event)
{this.dispatchEventToListeners(WebInspector.ProbeSet.Event.ResolvedStateDidChange);}};WebInspector.ProbeSet.Event={ProbeAdded:"probe-set-probe-added",ProbeRemoved:"probe-set-probe-removed",ResolvedStateDidChange:"probe-set-resolved-state-did-change",SampleAdded:"probe-set-sample-added",SamplesCleared:"probe-set-samples-cleared",};WebInspector.ProbeSetDataFrame=class ProbeSetDataFrame extends WebInspector.Object
{constructor(index)
{super();this._count=0;this._index=index;this._separator=false;} 
static compare(a,b)
{return a.index-b.index;} 
get key()
{return String(this._index);}
get count()
{return this._count;}
get index()
{return this._index;}
get isSeparator()
{return this._separator;}
set isSeparator(value)
{this._separator=!!value;}
addSampleForProbe(probe,sample)
{this[probe.id]=sample;this._count++;}
missingKeys(probeSet)
{return probeSet.probes.filter(function(probe){return!this.hasOwnProperty(probe.id);},this);}
isComplete(probeSet)
{return!this.missingKeys(probeSet).length;}
fillMissingValues(probeSet)
{for(var key of this.missingKeys(probeSet))
this[key]=WebInspector.ProbeSetDataFrame.MissingValue;}};WebInspector.ProbeSetDataFrame.MissingValue="?";WebInspector.ProbeSetDataTable=class ProbeSetDataTable extends WebInspector.Object
{constructor(probeSet)
{super();this._probeSet=probeSet;this._frames=[];this._previousBatchIdentifier=WebInspector.ProbeSetDataTable.SentinelValue;} 
get frames()
{return this._frames.slice();}
get separators()
{return this._frames.filter(function(frame){return frame.isSeparator;});}
willRemove()
{this.dispatchEventToListeners(WebInspector.ProbeSetDataTable.Event.WillRemove);this._frames=[];delete this._probeSet;}
mainResourceChanged()
{this.addSeparator();}
addSampleForProbe(probe,sample)
{if(sample.batchId!==this._previousBatchIdentifier){if(this._openFrame){this._openFrame.fillMissingValues(this._probeSet);this.addFrame(this._openFrame);}
this._openFrame=this.createFrame();this._previousBatchIdentifier=sample.batchId;}
this._openFrame.addSampleForProbe(probe,sample);if(this._openFrame.count===this._probeSet.probes.length){this.addFrame(this._openFrame);this._openFrame=null;}}
addProbe(probe)
{for(var frame of this.frames)
if(!frame[probe.id])
frame[probe.id]=WebInspector.ProbeSetDataTable.UnknownValue;}
removeProbe(probe)
{for(var frame of this.frames)
delete frame[probe.id];}
createFrame()
{return new WebInspector.ProbeSetDataFrame(this._frames.length);}
addFrame(frame)
{this._frames.push(frame);this.dispatchEventToListeners(WebInspector.ProbeSetDataTable.Event.FrameInserted,frame);}
addSeparator()
{if(!this._frames.length)
return;var previousFrame=this._frames.lastValue;if(previousFrame.isSeparator)
return;previousFrame.isSeparator=true;this.dispatchEventToListeners(WebInspector.ProbeSetDataTable.Event.SeparatorInserted,previousFrame);}};WebInspector.ProbeSetDataTable.Event={FrameInserted:"probe-set-data-table-frame-inserted",SeparatorInserted:"probe-set-data-table-separator-inserted",WillRemove:"probe-set-data-table-will-remove"};WebInspector.ProbeSetDataTable.SentinelValue=-1;WebInspector.ProbeSetDataTable.UnknownValue="?";WebInspector.Profile=class Profile extends WebInspector.Object
{constructor(topDownRootNodes)
{super();topDownRootNodes=topDownRootNodes||[];this._topDownRootNodes=topDownRootNodes;} 
get topDownRootNodes()
{return this._topDownRootNodes;}
get bottomUpRootNodes()
{return[];}};WebInspector.ProfileNode=class ProfileNode extends WebInspector.Object
{constructor(id,type,functionName,sourceCodeLocation,callInfo,calls,childNodes)
{super();childNodes=childNodes||[];this._id=id;this._type=type||WebInspector.ProfileNode.Type.Function;this._functionName=functionName||null;this._sourceCodeLocation=sourceCodeLocation||null;this._calls=calls||null;this._callInfo=callInfo||null;this._childNodes=childNodes;this._parentNode=null;this._previousSibling=null;this._nextSibling=null;this._computedTotalTimes=false;if(this._callInfo){this._startTime=this._callInfo.startTime;this._endTime=this._callInfo.endTime;this._totalTime=this._callInfo.totalTime;this._callCount=this._callInfo.callCount;}
for(var i=0;i<this._childNodes.length;++i)
this._childNodes[i].establishRelationships(this,this._childNodes[i-1],this._childNodes[i+1]);if(this._calls){for(var i=0;i<this._calls.length;++i)
this._calls[i].establishRelationships(this,this._calls[i-1],this._calls[i+1]);}} 
get id()
{return this._id;}
get type()
{return this._type;}
get functionName()
{return this._functionName;}
get sourceCodeLocation()
{return this._sourceCodeLocation;}
get startTime()
{if(this._startTime===undefined)
this._startTime=Math.max(0,this._calls[0].startTime);return this._startTime;}
get endTime()
{if(this._endTime===undefined)
this._endTime=Math.min(this._calls.lastValue.endTime,Infinity);return this._endTime;}
get selfTime()
{this._computeTotalTimesIfNeeded();return this._selfTime;}
get totalTime()
{this._computeTotalTimesIfNeeded();return this._totalTime;}
get callInfo()
{return this._callInfo;}
get calls()
{return this._calls;}
get previousSibling()
{return this._previousSibling;}
get nextSibling()
{return this._nextSibling;}
get parentNode()
{return this._parentNode;}
get childNodes()
{return this._childNodes;}
computeCallInfoForTimeRange(rangeStartTime,rangeEndTime)
{

if(this._callInfo){if(this._selfTime===undefined){var childNodesTotalTime=0;for(var childNode of this._childNodes)
childNodesTotalTime+=childNode.totalTime;this._selfTime=this._totalTime-childNodesTotalTime;if(this._selfTime<0.0001)
this._selfTime=0.0;}
return{callCount:this._callCount,startTime:this._startTime,endTime:this._endTime,selfTime:this._selfTime,totalTime:this._totalTime,averageTime:(this._selfTime/this._callCount),};}
var recordCallCount=true;var callCount=0;function totalTimeInRange(previousValue,call)
{if(rangeStartTime>call.endTime||rangeEndTime<call.startTime)
return previousValue;if(recordCallCount)
++callCount;return previousValue+Math.min(call.endTime,rangeEndTime)-Math.max(rangeStartTime,call.startTime);}
var startTime=Math.max(rangeStartTime,this._calls[0].startTime);var endTime=Math.min(this._calls.lastValue.endTime,rangeEndTime);var totalTime=this._calls.reduce(totalTimeInRange,0);recordCallCount=false;var childNodesTotalTime=0;for(var childNode of this._childNodes)
childNodesTotalTime+=childNode.calls.reduce(totalTimeInRange,0);var selfTime=totalTime-childNodesTotalTime;var averageTime=selfTime/callCount;return{startTime,endTime,totalTime,selfTime,callCount,averageTime};}
traverseNextProfileNode(stayWithin)
{var profileNode=this._childNodes[0];if(profileNode)
return profileNode;if(this===stayWithin)
return null;profileNode=this._nextSibling;if(profileNode)
return profileNode;profileNode=this;while(profileNode&&!profileNode.nextSibling&&profileNode.parentNode!==stayWithin)
profileNode=profileNode.parentNode;if(!profileNode)
return null;return profileNode.nextSibling;}
saveIdentityToCookie(cookie)
{cookie[WebInspector.ProfileNode.TypeCookieKey]=this._type||null;cookie[WebInspector.ProfileNode.FunctionNameCookieKey]=this._functionName||null;cookie[WebInspector.ProfileNode.SourceCodeURLCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.sourceCode.url?this._sourceCodeLocation.sourceCode.url.hash:null:null;cookie[WebInspector.ProfileNode.SourceCodeLocationLineCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.lineNumber:null;cookie[WebInspector.ProfileNode.SourceCodeLocationColumnCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.columnNumber:null;} 
establishRelationships(parentNode,previousSibling,nextSibling)
{this._parentNode=parentNode||null;this._previousSibling=previousSibling||null;this._nextSibling=nextSibling||null;} 
_computeTotalTimesIfNeeded()
{if(this._computedTotalTimes)
return;this._computedTotalTimes=true;var info=this.computeCallInfoForTimeRange(0,Infinity);this._startTime=info.startTime;this._endTime=info.endTime;this._selfTime=info.selfTime;this._totalTime=info.totalTime;}};WebInspector.ProfileNode.Type={Function:"profile-node-type-function",Program:"profile-node-type-program"};WebInspector.ProfileNode.TypeIdentifier="profile-node";WebInspector.ProfileNode.TypeCookieKey="profile-node-type";WebInspector.ProfileNode.FunctionNameCookieKey="profile-node-function-name";WebInspector.ProfileNode.SourceCodeURLCookieKey="profile-node-source-code-url";WebInspector.ProfileNode.SourceCodeLocationLineCookieKey="profile-node-source-code-location-line";WebInspector.ProfileNode.SourceCodeLocationColumnCookieKey="profile-node-source-code-location-column";WebInspector.ProfileNodeCall=class ProfileNodeCall extends WebInspector.Object
{constructor(startTime,totalTime)
{super();this._startTime=startTime;this._totalTime=totalTime||0;this._parentNode=null;this._previousSibling=null;this._nextSibling=null;} 
get startTime()
{return this._startTime;}
get totalTime()
{return this._totalTime;}
get endTime()
{return this._startTime+this._totalTime;} 
establishRelationships(parentNode,previousSibling,nextSibling)
{this._parentNode=parentNode||null;this._previousSibling=previousSibling||null;this._nextSibling=nextSibling||null;}};WebInspector.PropertyDescriptor=class PropertyDescriptor extends WebInspector.Object
{constructor(descriptor,symbol,isOwnProperty,wasThrown,nativeGetter,isInternalProperty)
{super();this._name=descriptor.name;this._value=descriptor.value;this._hasValue="value"in descriptor;this._get=descriptor.get;this._set=descriptor.set;this._symbol=symbol;this._writable=descriptor.writable||false;this._configurable=descriptor.configurable||false;this._enumerable=descriptor.enumerable||false;this._own=isOwnProperty||false;this._wasThrown=wasThrown||false;this._nativeGetterValue=nativeGetter||false;this._internal=isInternalProperty||false;}

static fromPayload(payload,internal,target)
{if(payload.value)
payload.value=WebInspector.RemoteObject.fromPayload(payload.value,target);if(payload.get)
payload.get=WebInspector.RemoteObject.fromPayload(payload.get,target);if(payload.set)
payload.set=WebInspector.RemoteObject.fromPayload(payload.set,target);if(payload.symbol)
payload.symbol=WebInspector.RemoteObject.fromPayload(payload.symbol,target);if(internal){payload.writable=payload.configurable=payload.enumerable=false;payload.isOwn=true;}
return new WebInspector.PropertyDescriptor(payload,payload.symbol,payload.isOwn,payload.wasThrown,payload.nativeGetter,internal);} 
get name(){return this._name;}
get value(){return this._value;}
get get(){return this._get;}
get set(){return this._set;}
get writable(){return this._writable;}
get configurable(){return this._configurable;}
get enumerable(){return this._enumerable;}
get symbol(){return this._symbol;}
get isOwnProperty(){return this._own;}
get wasThrown(){return this._wasThrown;}
get nativeGetter(){return this._nativeGetterValue;}
get isInternalProperty(){return this._internal;}
hasValue()
{return this._hasValue;}
hasGetter()
{return this._get&&this._get.type==="function";}
hasSetter()
{return this._set&&this._set.type==="function";}
isIndexProperty()
{return!isNaN(Number(this._name));}
isSymbolProperty()
{return!!this._symbol;}};WebInspector.PropertyPath=class PropertyPath extends WebInspector.Object
{constructor(object,pathComponent,parent,isPrototype)
{super();if(parent&&!parent.object)
throw new Error("Attempted to append to a PropertyPath with null object.");this._object=object;this._pathComponent=typeof pathComponent==="string"?pathComponent:null;this._parent=parent||null;this._isPrototype=isPrototype||false;} 
static emptyPropertyPathForScope(object)
{return new WebInspector.PropertyPath(object,WebInspector.PropertyPath.SpecialPathComponent.EmptyPathComponentForScope);} 
get object(){return this._object;}
get parent(){return this._parent;}
get isPrototype(){return this._isPrototype;}
get pathComponent(){return this._pathComponent;}
get rootObject()
{return this._parent?this._parent.rootObject:this._object;}
get lastNonPrototypeObject()
{if(!this._parent)
return this._object;var p=this._parent;while(p){if(!p.isPrototype)
break;if(!p.parent)
break;p=p.parent;}
return p.object;}
get fullPath()
{var components=[];for(var p=this;p&&p.pathComponent;p=p.parent)
components.push(p.pathComponent);components.reverse();return components.join("");}
get reducedPath()
{var components=[];var p=this;for(;p&&p.isPrototype;p=p.parent)
components.push(p.pathComponent);for(;p&&p.pathComponent;p=p.parent){if(p.isPrototype)
continue;components.push(p.pathComponent);}
components.reverse();return components.join("");}
displayPath(type)
{return type===WebInspector.PropertyPath.Type.Value?this.reducedPath:this.fullPath;}
isRoot()
{return!this._parent;}
isScope()
{return this._pathComponent===WebInspector.PropertyPath.SpecialPathComponent.EmptyPathComponentForScope;}
isPathComponentImpossible()
{return this._pathComponent&&this._pathComponent.startsWith("@");}
isFullPathImpossible()
{if(this.isPathComponentImpossible())
return true;if(this._parent)
return this._parent.isFullPathImpossible();return false;}
appendPropertyName(object,propertyName)
{var isPrototype=propertyName==="__proto__";if(this.isScope())
return new WebInspector.PropertyPath(object,propertyName,this,isPrototype);var component=this._canPropertyNameBeDotAccess(propertyName)?"."+propertyName:"["+doubleQuotedString(propertyName)+"]";return new WebInspector.PropertyPath(object,component,this,isPrototype);}
appendPropertySymbol(object,symbolName)
{var component=WebInspector.PropertyPath.SpecialPathComponent.SymbolPropertyName+(symbolName.length?"("+symbolName+")":"");return new WebInspector.PropertyPath(object,component,this);}
appendInternalPropertyName(object,propertyName)
{var component=WebInspector.PropertyPath.SpecialPathComponent.InternalPropertyName+"["+propertyName+"]";return new WebInspector.PropertyPath(object,component,this);}
appendGetterPropertyName(object,propertyName)
{var component=".__lookupGetter__("+doubleQuotedString(propertyName)+")";return new WebInspector.PropertyPath(object,component,this);}
appendSetterPropertyName(object,propertyName)
{var component=".__lookupSetter__("+doubleQuotedString(propertyName)+")";return new WebInspector.PropertyPath(object,component,this);}
appendArrayIndex(object,indexString)
{var component="["+indexString+"]";return new WebInspector.PropertyPath(object,component,this);}
appendMapKey(object)
{var component=WebInspector.PropertyPath.SpecialPathComponent.MapKey;return new WebInspector.PropertyPath(object,component,this);}
appendMapValue(object,keyObject)
{if(keyObject&&keyObject.hasValue()){if(keyObject.type==="string"){var component=".get("+doubleQuotedString(keyObject.description)+")";return new WebInspector.PropertyPath(object,component,this);}
var component=".get("+keyObject.description+")";return new WebInspector.PropertyPath(object,component,this);}
var component=WebInspector.PropertyPath.SpecialPathComponent.MapValue;return new WebInspector.PropertyPath(object,component,this);}
appendSetIndex(object)
{var component=WebInspector.PropertyPath.SpecialPathComponent.SetIndex;return new WebInspector.PropertyPath(object,component,this);}
appendSymbolProperty(object)
{var component=WebInspector.PropertyPath.SpecialPathComponent.SymbolPropertyName;return new WebInspector.PropertyPath(object,component,this);}
appendPropertyDescriptor(object,descriptor,type)
{if(descriptor.isInternalProperty)
return this.appendInternalPropertyName(object,descriptor.name);if(descriptor.symbol)
return this.appendSymbolProperty(object);if(type===WebInspector.PropertyPath.Type.Getter)
return this.appendGetterPropertyName(object,descriptor.name);if(type===WebInspector.PropertyPath.Type.Setter)
return this.appendSetterPropertyName(object,descriptor.name);if(this._object.subtype==="array"&&!isNaN(parseInt(descriptor.name)))
return this.appendArrayIndex(object,descriptor.name);return this.appendPropertyName(object,descriptor.name);} 
_canPropertyNameBeDotAccess(propertyName)
{return/^(?![0-9])\w+$/.test(propertyName);}};WebInspector.PropertyPath.SpecialPathComponent={InternalPropertyName:"@internal",SymbolPropertyName:"@symbol",MapKey:"@mapkey",MapValue:"@mapvalue",SetIndex:"@setindex",EmptyPathComponentForScope:"",};WebInspector.PropertyPath.Type={Value:"value",Getter:"getter",Setter:"setter",};WebInspector.PropertyPreview=class PropertyPreview extends WebInspector.Object
{constructor(name,type,subtype,value,valuePreview,isInternalProperty)
{super();this._name=name;this._type=type;this._subtype=subtype;this._value=value;this._valuePreview=valuePreview;this._internal=isInternalProperty;}

static fromPayload(payload)
{if(payload.valuePreview)
payload.valuePreview=WebInspector.ObjectPreview.fromPayload(payload.valuePreview);return new WebInspector.PropertyPreview(payload.name,payload.type,payload.subtype,payload.value,payload.valuePreview,payload.internal);} 
get name(){return this._name;}
get type(){return this._type;}
get subtype(){return this._subtype;}
get value(){return this._value;}
get valuePreview(){return this._valuePreview;}
get internal(){return this._internal;}};WebInspector.RenderingFrameTimelineRecord=class RenderingFrameTimelineRecord extends WebInspector.TimelineRecord
{constructor(startTime,endTime)
{super(WebInspector.TimelineRecord.Type.RenderingFrame,startTime,endTime);this._durationByTaskType=new Map;this._frameIndex=-1;} 
static resetFrameIndex()
{WebInspector.RenderingFrameTimelineRecord._nextFrameIndex=0;}
static displayNameForTaskType(taskType)
{switch(taskType){case WebInspector.RenderingFrameTimelineRecord.TaskType.Script:return WebInspector.UIString("Script");case WebInspector.RenderingFrameTimelineRecord.TaskType.Layout:return WebInspector.UIString("Layout");case WebInspector.RenderingFrameTimelineRecord.TaskType.Paint:return WebInspector.UIString("Paint");case WebInspector.RenderingFrameTimelineRecord.TaskType.Other:return WebInspector.UIString("Other");}}
static taskTypeForTimelineRecord(record)
{switch(record.type){case WebInspector.TimelineRecord.Type.Script:return WebInspector.RenderingFrameTimelineRecord.TaskType.Script;case WebInspector.TimelineRecord.Type.Layout:if(record.eventType===WebInspector.LayoutTimelineRecord.EventType.Paint||record.eventType===WebInspector.LayoutTimelineRecord.EventType.Composite)
return WebInspector.RenderingFrameTimelineRecord.TaskType.Paint;return WebInspector.RenderingFrameTimelineRecord.TaskType.Layout;default:console.error("Unsupported timeline record type: "+record.type);return null;}} 
get frameIndex()
{return this._frameIndex;}
get frameNumber()
{return this._frameIndex+1;}
setupFrameIndex()
{if(this._frameIndex>=0)
return;this._frameIndex=WebInspector.RenderingFrameTimelineRecord._nextFrameIndex++;}
durationForTask(taskType)
{if(this._durationByTaskType.has(taskType))
return this._durationByTaskType.get(taskType);var duration;if(taskType===WebInspector.RenderingFrameTimelineRecord.TaskType.Other)
duration=this._calculateDurationRemainder();else{duration=this.children.reduce(function(previousValue,currentValue){if(taskType!==WebInspector.RenderingFrameTimelineRecord.taskTypeForTimelineRecord(currentValue))
return previousValue;var currentDuration=currentValue.duration;if(currentValue.usesActiveStartTime)
currentDuration-=currentValue.inactiveDuration;return previousValue+currentDuration;},0);if(taskType===WebInspector.RenderingFrameTimelineRecord.TaskType.Script){
duration-=this.children.reduce(function(previousValue,currentValue){if(currentValue.type===WebInspector.TimelineRecord.Type.Layout&&(currentValue.sourceCodeLocation||currentValue.callFrames))
return previousValue+currentValue.duration;return previousValue;},0);}}
this._durationByTaskType.set(taskType,duration);return duration;} 
_calculateDurationRemainder()
{return Object.keys(WebInspector.RenderingFrameTimelineRecord.TaskType).reduce((previousValue,key)=>{let taskType=WebInspector.RenderingFrameTimelineRecord.TaskType[key];if(taskType===WebInspector.RenderingFrameTimelineRecord.TaskType.Other)
return previousValue;return previousValue-this.durationForTask(taskType);},this.duration);}};WebInspector.RenderingFrameTimelineRecord.TaskType={Script:"rendering-frame-timeline-record-script",Layout:"rendering-frame-timeline-record-layout",Paint:"rendering-frame-timeline-record-paint",Other:"rendering-frame-timeline-record-other"};WebInspector.RenderingFrameTimelineRecord.TypeIdentifier="rendering-frame-timeline-record";WebInspector.RenderingFrameTimelineRecord._nextFrameIndex=0;WebInspector.Resource=class Resource extends WebInspector.SourceCode
{constructor(url,mimeType,type,loaderIdentifier,targetId,requestIdentifier,requestMethod,requestHeaders,requestData,requestSentTimestamp,initiatorSourceCodeLocation,originalRequestWillBeSentTimestamp)
{super();if(type in WebInspector.Resource.Type)
type=WebInspector.Resource.Type[type];this._url=url;this._urlComponents=null;this._mimeType=mimeType;this._mimeTypeComponents=null;this._type=type||WebInspector.Resource.typeFromMIMEType(mimeType);this._loaderIdentifier=loaderIdentifier||null;this._requestIdentifier=requestIdentifier||null;this._requestMethod=requestMethod||null;this._requestData=requestData||null;this._requestHeaders=requestHeaders||{};this._responseHeaders={};this._parentFrame=null;this._initiatorSourceCodeLocation=initiatorSourceCodeLocation||null;this._initiatedResources=[];this._originalRequestWillBeSentTimestamp=originalRequestWillBeSentTimestamp||null;this._requestSentTimestamp=requestSentTimestamp||NaN;this._responseReceivedTimestamp=NaN;this._lastRedirectReceivedTimestamp=NaN;this._lastDataReceivedTimestamp=NaN;this._finishedOrFailedTimestamp=NaN;this._finishThenRequestContentPromise=null;this._statusCode=NaN;this._statusText=null;this._cached=false;this._canceled=false;this._failed=false;this._failureReasonText=null;this._receivedNetworkLoadMetrics=false;this._responseSource=WebInspector.Resource.ResponseSource.Unknown;this._timingData=new WebInspector.ResourceTimingData(this);this._protocol=null;this._priority=WebInspector.Resource.NetworkPriority.Unknown;this._remoteAddress=null;this._connectionIdentifier=null;this._target=targetId?WebInspector.targetManager.targetForIdentifier(targetId):WebInspector.mainTarget;this._requestHeadersTransferSize=NaN;this._requestBodyTransferSize=NaN;this._responseHeadersTransferSize=NaN;this._responseBodyTransferSize=NaN;this._responseBodySize=NaN;this._cachedResponseBodySize=NaN;this._estimatedSize=NaN;this._estimatedTransferSize=NaN;this._estimatedResponseHeadersSize=NaN;if(this._initiatorSourceCodeLocation&&this._initiatorSourceCodeLocation.sourceCode instanceof WebInspector.Resource)
this._initiatorSourceCodeLocation.sourceCode.addInitiatedResource(this);} 
static typeFromMIMEType(mimeType)
{if(!mimeType)
return WebInspector.Resource.Type.Other;mimeType=parseMIMEType(mimeType).type;if(mimeType in WebInspector.Resource._mimeTypeMap)
return WebInspector.Resource._mimeTypeMap[mimeType];if(mimeType.startsWith("image/"))
return WebInspector.Resource.Type.Image;if(mimeType.startsWith("font/"))
return WebInspector.Resource.Type.Font;return WebInspector.Resource.Type.Other;}
static displayNameForType(type,plural)
{switch(type){case WebInspector.Resource.Type.Document:if(plural)
return WebInspector.UIString("Documents");return WebInspector.UIString("Document");case WebInspector.Resource.Type.Stylesheet:if(plural)
return WebInspector.UIString("Stylesheets");return WebInspector.UIString("Stylesheet");case WebInspector.Resource.Type.Image:if(plural)
return WebInspector.UIString("Images");return WebInspector.UIString("Image");case WebInspector.Resource.Type.Font:if(plural)
return WebInspector.UIString("Fonts");return WebInspector.UIString("Font");case WebInspector.Resource.Type.Script:if(plural)
return WebInspector.UIString("Scripts");return WebInspector.UIString("Script");case WebInspector.Resource.Type.XHR:if(plural)
return WebInspector.UIString("XHRs");return WebInspector.UIString("XHR");case WebInspector.Resource.Type.Fetch:if(plural)
return WebInspector.UIString("Fetches");return WebInspector.UIString("Fetch");case WebInspector.Resource.Type.WebSocket:if(plural)
return WebInspector.UIString("Sockets");return WebInspector.UIString("Socket");case WebInspector.Resource.Type.Other:return WebInspector.UIString("Other");default:console.error("Unknown resource type",type);return null;}}
static displayNameForProtocol(protocol)
{switch(protocol){case"h2":return"HTTP/2";case"http/1.0":return"HTTP/1.0";case"http/1.1":return"HTTP/1.1";case"spdy/2":return"SPDY/2";case"spdy/3":return"SPDY/3";case"spdy/3.1":return"SPDY/3.1";default:return null;}}
static comparePriority(a,b)
{const map={[WebInspector.Resource.NetworkPriority.Unknown]:0,[WebInspector.Resource.NetworkPriority.Low]:1,[WebInspector.Resource.NetworkPriority.Medium]:2,[WebInspector.Resource.NetworkPriority.High]:3,};let aNum=map[a]||0;let bNum=map[b]||0;return aNum-bNum;}
static displayNameForPriority(priority)
{switch(priority){case WebInspector.Resource.NetworkPriority.Low:return WebInspector.UIString("Low");case WebInspector.Resource.NetworkPriority.Medium:return WebInspector.UIString("Medium");case WebInspector.Resource.NetworkPriority.High:return WebInspector.UIString("High");default:return null;}}
static responseSourceFromPayload(source)
{if(!source)
return WebInspector.Resource.ResponseSource.Unknown;switch(source){case NetworkAgent.ResponseSource.Unknown:return WebInspector.Resource.ResponseSource.Unknown;case NetworkAgent.ResponseSource.Network:return WebInspector.Resource.ResponseSource.Network;case NetworkAgent.ResponseSource.MemoryCache:return WebInspector.Resource.ResponseSource.MemoryCache;case NetworkAgent.ResponseSource.DiskCache:return WebInspector.Resource.ResponseSource.DiskCache;default:console.error("Unknown response source type",source);return WebInspector.Resource.ResponseSource.Unknown;}}
static networkPriorityFromPayload(priority)
{switch(priority){case NetworkAgent.MetricsPriority.Low:return WebInspector.Resource.NetworkPriority.Low;case NetworkAgent.MetricsPriority.Medium:return WebInspector.Resource.NetworkPriority.Medium;case NetworkAgent.MetricsPriority.High:return WebInspector.Resource.NetworkPriority.High;default:console.error("Unknown metrics priority",priority);return WebInspector.Resource.NetworkPriority.Unknown;}}
static connectionIdentifierFromPayload(connectionIdentifier)
{if(!WebInspector.Resource.connectionIdentifierMap){WebInspector.Resource.connectionIdentifierMap=new Map;WebInspector.Resource.nextConnectionIdentifier=1;}
let id=WebInspector.Resource.connectionIdentifierMap.get(connectionIdentifier);if(id)
return id;id=WebInspector.Resource.nextConnectionIdentifier++;WebInspector.Resource.connectionIdentifierMap.set(connectionIdentifier,id);return id;} 
get target(){return this._target;}
get type(){return this._type;}
get loaderIdentifier(){return this._loaderIdentifier;}
get requestIdentifier(){return this._requestIdentifier;}
get requestMethod(){return this._requestMethod;}
get requestData(){return this._requestData;}
get statusCode(){return this._statusCode;}
get statusText(){return this._statusText;}
get responseSource(){return this._responseSource;}
get timingData(){return this._timingData;}
get protocol(){return this._protocol;}
get priority(){return this._priority;}
get remoteAddress(){return this._remoteAddress;}
get connectionIdentifier(){return this._connectionIdentifier;}
get url()
{return this._url;}
get urlComponents()
{if(!this._urlComponents)
this._urlComponents=parseURL(this._url);return this._urlComponents;}
get displayName()
{return WebInspector.displayNameForURL(this._url,this.urlComponents);}
get displayURL()
{const isMultiLine=true;const dataURIMaxSize=64;return WebInspector.truncateURL(this._url,isMultiLine,dataURIMaxSize);}
get initiatorSourceCodeLocation()
{return this._initiatorSourceCodeLocation;}
get initiatedResources()
{return this._initiatedResources;}
get originalRequestWillBeSentTimestamp()
{return this._originalRequestWillBeSentTimestamp;}
get mimeType()
{return this._mimeType;}
get mimeTypeComponents()
{if(!this._mimeTypeComponents)
this._mimeTypeComponents=parseMIMEType(this._mimeType);return this._mimeTypeComponents;}
get syntheticMIMEType()
{
if(this._type===WebInspector.Resource.typeFromMIMEType(this._mimeType))
return this._mimeType;
switch(this._type){case WebInspector.Resource.Type.Stylesheet:return"text/css";case WebInspector.Resource.Type.Script:return"text/javascript";}
return this._mimeType;}
createObjectURL()
{let content=this.content;if(!content)
return this._url;if(content instanceof Blob)
return URL.createObjectURL(content);return null;}
isMainResource()
{return this._parentFrame?this._parentFrame.mainResource===this:false;}
addInitiatedResource(resource)
{if(!(resource instanceof WebInspector.Resource))
return;this._initiatedResources.push(resource);this.dispatchEventToListeners(WebInspector.Resource.Event.InitiatedResourcesDidChange);}
get parentFrame()
{return this._parentFrame;}
get finished()
{return this._finished;}
get failed()
{return this._failed;}
get canceled()
{return this._canceled;}
get failureReasonText()
{return this._failureReasonText;}
get requestDataContentType()
{return this._requestHeaders.valueForCaseInsensitiveKey("Content-Type")||null;}
get requestHeaders()
{return this._requestHeaders;}
get responseHeaders()
{return this._responseHeaders;}
get requestSentTimestamp()
{return this._requestSentTimestamp;}
get lastRedirectReceivedTimestamp()
{return this._lastRedirectReceivedTimestamp;}
get responseReceivedTimestamp()
{return this._responseReceivedTimestamp;}
get lastDataReceivedTimestamp()
{return this._lastDataReceivedTimestamp;}
get finishedOrFailedTimestamp()
{return this._finishedOrFailedTimestamp;}
get firstTimestamp()
{return this.timingData.startTime||this.lastRedirectReceivedTimestamp||this.responseReceivedTimestamp||this.lastDataReceivedTimestamp||this.finishedOrFailedTimestamp;}
get lastTimestamp()
{return this.timingData.responseEnd||this.lastDataReceivedTimestamp||this.responseReceivedTimestamp||this.lastRedirectReceivedTimestamp||this.requestSentTimestamp;}
get duration()
{return this.timingData.responseEnd-this.timingData.requestStart;}
get latency()
{return this.timingData.responseStart-this.timingData.requestStart;}
get receiveDuration()
{return this.timingData.responseEnd-this.timingData.responseStart;}
get cached()
{return this._cached;}
get requestHeadersTransferSize(){return this._requestHeadersTransferSize;}
get requestBodyTransferSize(){return this._requestBodyTransferSize;}
get responseHeadersTransferSize(){return this._responseHeadersTransferSize;}
get responseBodyTransferSize(){return this._responseBodyTransferSize;}
get cachedResponseBodySize(){return this._cachedResponseBodySize;}
get size()
{if(!isNaN(this._cachedResponseBodySize))
return this._cachedResponseBodySize;if(!isNaN(this._responseBodySize)&&this._responseBodySize!==0)
return this._responseBodySize;return this._estimatedSize;}
get networkEncodedSize()
{return this._responseBodyTransferSize;}
get networkDecodedSize()
{return this._responseBodySize;}
get networkTotalTransferSize()
{return this._responseHeadersTransferSize+this._responseBodyTransferSize;}
get estimatedNetworkEncodedSize()
{let exact=this.networkEncodedSize;if(!isNaN(exact))
return exact;if(this._cached)
return 0;


if(WebInspector.Platform.name==="mac"){let contentLength=Number(this._responseHeaders.valueForCaseInsensitiveKey("Content-Length"));if(!isNaN(contentLength))
return contentLength;}
if(!isNaN(this._estimatedTransferSize))
return this._estimatedTransferSize;






return Number(this._responseHeaders.valueForCaseInsensitiveKey("Content-Length")||this._estimatedSize);}
get estimatedTotalTransferSize()
{let exact=this.networkTotalTransferSize;if(!isNaN(exact))
return exact;if(this.statusCode===304) 
return this._estimatedResponseHeadersSize;if(this._cached)
return 0;return this._estimatedResponseHeadersSize+this.estimatedNetworkEncodedSize;}
get compressed()
{let contentEncoding=this._responseHeaders.valueForCaseInsensitiveKey("Content-Encoding");return!!(contentEncoding&&/\b(?:gzip|deflate)\b/.test(contentEncoding));}
get scripts()
{return this._scripts||[];}
scriptForLocation(sourceCodeLocation)
{if(sourceCodeLocation.sourceCode!==this)
return null;var lineNumber=sourceCodeLocation.lineNumber;var columnNumber=sourceCodeLocation.columnNumber;for(var i=0;i<this._scripts.length;++i){var script=this._scripts[i];if(script.range.startLine<=lineNumber&&script.range.endLine>=lineNumber){if(script.range.startLine===lineNumber&&columnNumber<script.range.startColumn)
continue;if(script.range.endLine===lineNumber&&columnNumber>script.range.endColumn)
continue;return script;}}
return null;}
updateForRedirectResponse(url,requestHeaders,elapsedTime)
{var oldURL=this._url;this._url=url;this._requestHeaders=requestHeaders||{};this._lastRedirectReceivedTimestamp=elapsedTime||NaN;if(oldURL!==url){this._urlComponents=null;this.dispatchEventToListeners(WebInspector.Resource.Event.URLDidChange,{oldURL});}
this.dispatchEventToListeners(WebInspector.Resource.Event.RequestHeadersDidChange);this.dispatchEventToListeners(WebInspector.Resource.Event.TimestampsDidChange);}
hasResponse()
{return!isNaN(this._statusCode);}
updateForResponse(url,mimeType,type,responseHeaders,statusCode,statusText,elapsedTime,timingData,source)
{let oldURL=this._url;let oldMIMEType=this._mimeType;let oldType=this._type;if(type in WebInspector.Resource.Type)
type=WebInspector.Resource.Type[type];this._url=url;this._mimeType=mimeType;this._type=type||WebInspector.Resource.typeFromMIMEType(mimeType);this._statusCode=statusCode;this._statusText=statusText;this._responseHeaders=responseHeaders||{};this._responseReceivedTimestamp=elapsedTime||NaN;this._timingData=WebInspector.ResourceTimingData.fromPayload(timingData,this);if(source)
this._responseSource=WebInspector.Resource.responseSourceFromPayload(source);const headerBaseSize=12;const headerPad=4;this._estimatedResponseHeadersSize=String(this._statusCode).length+this._statusText.length+headerBaseSize;for(let name in this._responseHeaders)
this._estimatedResponseHeadersSize+=name.length+this._responseHeaders[name].length+headerPad;if(!this._cached){if(statusCode===304||(this._responseSource===WebInspector.Resource.ResponseSource.MemoryCache||this._responseSource===WebInspector.Resource.ResponseSource.DiskCache))
this.markAsCached();}
if(oldURL!==url){this._urlComponents=null;this.dispatchEventToListeners(WebInspector.Resource.Event.URLDidChange,{oldURL});}
if(oldMIMEType!==mimeType){this._mimeTypeComponents=null;this.dispatchEventToListeners(WebInspector.Resource.Event.MIMETypeDidChange,{oldMIMEType});}
if(oldType!==type)
this.dispatchEventToListeners(WebInspector.Resource.Event.TypeDidChange,{oldType});
if(statusCode===304||this._responseHeaders.valueForCaseInsensitiveKey("Content-Length"))
this.dispatchEventToListeners(WebInspector.Resource.Event.TransferSizeDidChange);this.dispatchEventToListeners(WebInspector.Resource.Event.ResponseReceived);this.dispatchEventToListeners(WebInspector.Resource.Event.TimestampsDidChange);}
updateWithMetrics(metrics)
{this._receivedNetworkLoadMetrics=true;if(metrics.protocol)
this._protocol=metrics.protocol;if(metrics.priority)
this._priority=WebInspector.Resource.networkPriorityFromPayload(metrics.priority);if(metrics.remoteAddress)
this._remoteAddress=metrics.remoteAddress;if(metrics.connectionIdentifier)
this._connectionIdentifier=WebInspector.Resource.connectionIdentifierFromPayload(metrics.connectionIdentifier);if(metrics.requestHeaders){this._requestHeaders=metrics.requestHeaders;this.dispatchEventToListeners(WebInspector.Resource.Event.RequestHeadersDidChange);}
if("requestHeaderBytesSent"in metrics){this._requestHeadersTransferSize=metrics.requestHeaderBytesSent;this._requestBodyTransferSize=metrics.requestBodyBytesSent;this._responseHeadersTransferSize=metrics.responseHeaderBytesReceived;this._responseBodyTransferSize=metrics.responseBodyBytesReceived;this._responseBodySize=metrics.responseBodyDecodedSize;this.dispatchEventToListeners(WebInspector.Resource.Event.SizeDidChange,{previousSize:this._estimatedSize});this.dispatchEventToListeners(WebInspector.Resource.Event.TransferSizeDidChange);}}
setCachedResponseBodySize(size)
{this._cachedResponseBodySize=size;}
requestContentFromBackend()
{if(this._requestIdentifier)
return NetworkAgent.getResponseBody(this._requestIdentifier);if(this._parentFrame)
return PageAgent.getResourceContent(this._parentFrame.id,this._url);return Promise.reject(new Error("Content request failed."));}
increaseSize(dataLength,elapsedTime)
{if(isNaN(this._estimatedSize))
this._estimatedSize=0;let previousSize=this._estimatedSize;this._estimatedSize+=dataLength;this._lastDataReceivedTimestamp=elapsedTime||NaN;this.dispatchEventToListeners(WebInspector.Resource.Event.SizeDidChange,{previousSize});if(isNaN(this._estimatedTransferSize)&&this._statusCode!==304&&!this._responseHeaders.valueForCaseInsensitiveKey("Content-Length"))
this.dispatchEventToListeners(WebInspector.Resource.Event.TransferSizeDidChange);}
increaseTransferSize(encodedDataLength)
{if(isNaN(this._estimatedTransferSize))
this._estimatedTransferSize=0;this._estimatedTransferSize+=encodedDataLength;this.dispatchEventToListeners(WebInspector.Resource.Event.TransferSizeDidChange);}
markAsCached()
{this._cached=true;this.dispatchEventToListeners(WebInspector.Resource.Event.CacheStatusDidChange);if(this._statusCode!==304)
this.dispatchEventToListeners(WebInspector.Resource.Event.TransferSizeDidChange);}
markAsFinished(elapsedTime)
{this._finished=true;this._finishedOrFailedTimestamp=elapsedTime||NaN;this._timingData.markResponseEndTime(elapsedTime||NaN);if(this._finishThenRequestContentPromise)
this._finishThenRequestContentPromise=null;this.dispatchEventToListeners(WebInspector.Resource.Event.LoadingDidFinish);this.dispatchEventToListeners(WebInspector.Resource.Event.TimestampsDidChange);}
markAsFailed(canceled,elapsedTime,errorText)
{this._failed=true;this._canceled=canceled;this._finishedOrFailedTimestamp=elapsedTime||NaN;if(!this._failureReasonText)
this._failureReasonText=errorText||null;this.dispatchEventToListeners(WebInspector.Resource.Event.LoadingDidFail);this.dispatchEventToListeners(WebInspector.Resource.Event.TimestampsDidChange);}
revertMarkAsFinished()
{this._finished=false;this._finishedOrFailedTimestamp=NaN;}
legacyMarkServedFromMemoryCache()
{this._responseSource=WebInspector.Resource.ResponseSource.MemoryCache;this.markAsCached();}
legacyMarkServedFromDiskCache()
{this._responseSource=WebInspector.Resource.ResponseSource.DiskCache;this.markAsCached();}
hadLoadingError()
{return this._failed||this._canceled||this._statusCode>=400;}
getImageSize(callback)
{if(this.type!==WebInspector.Resource.Type.Image)
throw"Resource is not an image.";if(this._imageSize!==undefined){callback(this._imageSize);return;}
var objectURL=null;function imageDidLoad(){URL.revokeObjectURL(objectURL);this._imageSize={width:image.width,height:image.height};callback(this._imageSize);}
function requestContentFailure(){this._imageSize=null;callback(this._imageSize);}

var image=new Image;image.addEventListener("load",imageDidLoad.bind(this),false);this.requestContent().then((content)=>{objectURL=image.src=content.sourceCode.createObjectURL();if(!objectURL)
requestContentFailure.call(this);},requestContentFailure.bind(this));}
requestContent()
{if(this._finished)
return super.requestContent();if(this._failed)
return Promise.resolve({error:WebInspector.UIString("An error occurred trying to load the resource.")});if(!this._finishThenRequestContentPromise){this._finishThenRequestContentPromise=new Promise((resolve,reject)=>{this.addEventListener(WebInspector.Resource.Event.LoadingDidFinish,resolve);this.addEventListener(WebInspector.Resource.Event.LoadingDidFail,reject);}).then(WebInspector.SourceCode.prototype.requestContent.bind(this));}
return this._finishThenRequestContentPromise;}
associateWithScript(script)
{if(!this._scripts)
this._scripts=[];this._scripts.push(script);if(this._type===WebInspector.Resource.Type.Other||this._type===WebInspector.Resource.Type.XHR){let oldType=this._type;this._type=WebInspector.Resource.Type.Script;this.dispatchEventToListeners(WebInspector.Resource.Event.TypeDidChange,{oldType});}}
saveIdentityToCookie(cookie)
{cookie[WebInspector.Resource.URLCookieKey]=this.url.hash;cookie[WebInspector.Resource.MainResourceCookieKey]=this.isMainResource();}
generateCURLCommand()
{function escapeStringPosix(str){function escapeCharacter(x){let code=x.charCodeAt(0);let hex=code.toString(16);if(code<256)
return"\\x"+hex.padStart(2,"0");return"\\u"+hex.padStart(4,"0");}
if(/[^\x20-\x7E]|'/.test(str)){return"$'"+str.replace(/\\/g,"\\\\").replace(/'/g,"\\'").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/!/g,"\\041").replace(/[^\x20-\x7E]/g,escapeCharacter)+"'";}else{return`'${str}'`;}}
let command=["curl "+escapeStringPosix(this.url).replace(/[[{}\]]/g,"\\$&")];command.push(`-X${this.requestMethod}`);for(let key in this.requestHeaders)
command.push("-H "+escapeStringPosix(`${key}: ${this.requestHeaders[key]}`));if(this.requestDataContentType&&this.requestMethod!=="GET"&&this.requestData){if(this.requestDataContentType.match(/^application\/x-www-form-urlencoded\s*(;.*)?$/i))
command.push("--data "+escapeStringPosix(this.requestData));else
command.push("--data-binary "+escapeStringPosix(this.requestData));}
let curlCommand=command.join(" \\\n");InspectorFrontendHost.copyText(curlCommand);return curlCommand;}};WebInspector.Resource.TypeIdentifier="resource";WebInspector.Resource.URLCookieKey="resource-url";WebInspector.Resource.MainResourceCookieKey="resource-is-main-resource";WebInspector.Resource.Event={URLDidChange:"resource-url-did-change",MIMETypeDidChange:"resource-mime-type-did-change",TypeDidChange:"resource-type-did-change",RequestHeadersDidChange:"resource-request-headers-did-change",ResponseReceived:"resource-response-received",LoadingDidFinish:"resource-loading-did-finish",LoadingDidFail:"resource-loading-did-fail",TimestampsDidChange:"resource-timestamps-did-change",SizeDidChange:"resource-size-did-change",TransferSizeDidChange:"resource-transfer-size-did-change",CacheStatusDidChange:"resource-cached-did-change",InitiatedResourcesDidChange:"resource-initiated-resources-did-change",};WebInspector.Resource.Type={Document:"resource-type-document",Stylesheet:"resource-type-stylesheet",Image:"resource-type-image",Font:"resource-type-font",Script:"resource-type-script",XHR:"resource-type-xhr",Fetch:"resource-type-fetch",WebSocket:"resource-type-websocket",Other:"resource-type-other"};WebInspector.Resource.ResponseSource={Unknown:Symbol("unknown"),Network:Symbol("network"),MemoryCache:Symbol("memory-cache"),DiskCache:Symbol("disk-cache"),};WebInspector.Resource.NetworkPriority={Unknown:Symbol("unknown"),Low:Symbol("low"),Medium:Symbol("medium"),High:Symbol("high"),};WebInspector.Resource._mimeTypeMap={"text/html":WebInspector.Resource.Type.Document,"text/xml":WebInspector.Resource.Type.Document,"text/plain":WebInspector.Resource.Type.Document,"application/xhtml+xml":WebInspector.Resource.Type.Document,"image/svg+xml":WebInspector.Resource.Type.Document,"text/css":WebInspector.Resource.Type.Stylesheet,"text/xsl":WebInspector.Resource.Type.Stylesheet,"text/x-less":WebInspector.Resource.Type.Stylesheet,"text/x-sass":WebInspector.Resource.Type.Stylesheet,"text/x-scss":WebInspector.Resource.Type.Stylesheet,"application/pdf":WebInspector.Resource.Type.Image,"application/x-font-type1":WebInspector.Resource.Type.Font,"application/x-font-ttf":WebInspector.Resource.Type.Font,"application/x-font-woff":WebInspector.Resource.Type.Font,"application/x-truetype-font":WebInspector.Resource.Type.Font,"text/javascript":WebInspector.Resource.Type.Script,"text/ecmascript":WebInspector.Resource.Type.Script,"application/javascript":WebInspector.Resource.Type.Script,"application/ecmascript":WebInspector.Resource.Type.Script,"application/x-javascript":WebInspector.Resource.Type.Script,"application/json":WebInspector.Resource.Type.Script,"application/x-json":WebInspector.Resource.Type.Script,"text/x-javascript":WebInspector.Resource.Type.Script,"text/x-json":WebInspector.Resource.Type.Script,"text/javascript1.1":WebInspector.Resource.Type.Script,"text/javascript1.2":WebInspector.Resource.Type.Script,"text/javascript1.3":WebInspector.Resource.Type.Script,"text/jscript":WebInspector.Resource.Type.Script,"text/livescript":WebInspector.Resource.Type.Script,"text/x-livescript":WebInspector.Resource.Type.Script,"text/typescript":WebInspector.Resource.Type.Script,"text/x-clojure":WebInspector.Resource.Type.Script,"text/x-coffeescript":WebInspector.Resource.Type.Script};WebInspector.ResourceCollection=class ResourceCollection extends WebInspector.Collection
{constructor(resourceType)
{super(WebInspector.ResourceCollection.verifierForType(resourceType));this._resourceType=resourceType||null;this._resourceURLMap=new Map;this._resourcesTypeMap=new Map;} 
static verifierForType(type){switch(type){case WebInspector.Resource.Type.Document:return WebInspector.ResourceCollection.TypeVerifier.Document;case WebInspector.Resource.Type.Stylesheet:return WebInspector.ResourceCollection.TypeVerifier.Stylesheet;case WebInspector.Resource.Type.Image:return WebInspector.ResourceCollection.TypeVerifier.Image;case WebInspector.Resource.Type.Font:return WebInspector.ResourceCollection.TypeVerifier.Font;case WebInspector.Resource.Type.Script:return WebInspector.ResourceCollection.TypeVerifier.Script;case WebInspector.Resource.Type.XHR:return WebInspector.ResourceCollection.TypeVerifier.XHR;case WebInspector.Resource.Type.Fetch:return WebInspector.ResourceCollection.TypeVerifier.Fetch;case WebInspector.Resource.Type.WebSocket:return WebInspector.ResourceCollection.TypeVerifier.WebSocket;case WebInspector.Resource.Type.Other:return WebInspector.ResourceCollection.TypeVerifier.Other;default:return WebInspector.Collection.TypeVerifier.Resource;}} 
resourceForURL(url)
{return this._resourceURLMap.get(url)||null;}
resourceCollectionForType(type)
{if(this._resourceType){return this;}
let resourcesCollectionForType=this._resourcesTypeMap.get(type);if(!resourcesCollectionForType){resourcesCollectionForType=new WebInspector.ResourceCollection(type);this._resourcesTypeMap.set(type,resourcesCollectionForType);}
return resourcesCollectionForType;}
clear()
{super.clear();this._resourceURLMap.clear();if(!this._resourceType)
this._resourcesTypeMap.clear();} 
itemAdded(item)
{this._associateWithResource(item);}
itemRemoved(item)
{this._disassociateWithResource(item);}
itemsCleared(items)
{const skipRemoval=true;for(let item of items)
this._disassociateWithResource(item,skipRemoval);} 
_associateWithResource(resource)
{this._resourceURLMap.set(resource.url,resource);if(!this._resourceType){let resourcesCollectionForType=this.resourceCollectionForType(resource.type);resourcesCollectionForType.add(resource);}
resource.addEventListener(WebInspector.Resource.Event.URLDidChange,this._resourceURLDidChange,this);resource.addEventListener(WebInspector.Resource.Event.TypeDidChange,this._resourceTypeDidChange,this);}
_disassociateWithResource(resource,skipRemoval)
{resource.removeEventListener(WebInspector.Resource.Event.URLDidChange,this._resourceURLDidChange,this);resource.removeEventListener(WebInspector.Resource.Event.TypeDidChange,this._resourceTypeDidChange,this);if(skipRemoval)
return;if(!this._resourceType){let resourcesCollectionForType=this.resourceCollectionForType(resource.type);resourcesCollectionForType.remove(resource);}
this._resourceURLMap.delete(resource.url);}
_resourceURLDidChange(event)
{let resource=event.target;if(!(resource instanceof WebInspector.Resource))
return;let oldURL=event.data.oldURL;if(!oldURL)
return;this._resourceURLMap.set(resource.url,resource);this._resourceURLMap.delete(oldURL);}
_resourceTypeDidChange(event)
{let resource=event.target;if(!(resource instanceof WebInspector.Resource))
return;if(this._resourceType){this.remove(resource);return;}
let resourcesWithNewType=this.resourceCollectionForType(resource.type);resourcesWithNewType.add(resource);

}};WebInspector.ResourceCollection.TypeVerifier={Document:(object)=>WebInspector.Collection.TypeVerifier.Resource(object)&&object.type===WebInspector.Resource.Type.Document,Stylesheet:(object)=>{if(WebInspector.Collection.TypeVerifier.CSSStyleSheet(object))
return true;return WebInspector.Collection.TypeVerifier.Resource(object)&&object.type===WebInspector.Resource.Type.Stylesheet},Image:(object)=>WebInspector.Collection.TypeVerifier.Resource(object)&&object.type===WebInspector.Resource.Type.Image,Font:(object)=>WebInspector.Collection.TypeVerifier.Resource(object)&&object.type===WebInspector.Resource.Type.Font,Script:(object)=>WebInspector.Collection.TypeVerifier.Resource(object)&&object.type===WebInspector.Resource.Type.Script,XHR:(object)=>WebInspector.Collection.TypeVerifier.Resource(object)&&object.type===WebInspector.Resource.Type.XHR,Fetch:(object)=>WebInspector.Collection.TypeVerifier.Resource(object)&&object.type===WebInspector.Resource.Type.Fetch,WebSocket:(object)=>WebInspector.Collection.TypeVerifier.Resource(object)&&object.type===WebInspector.Resource.Type.WebSocket,Other:(object)=>WebInspector.Collection.TypeVerifier.Resource(object)&&object.type===WebInspector.Resource.Type.Other,};WebInspector.ResourceQueryMatch=class QueryMatch extends WebInspector.Object
{constructor(type,index,queryIndex)
{super();this._type=type;this._index=index;this._queryIndex=queryIndex;this._rank=undefined;} 
get type(){return this._type;}
get index(){return this._index;}
get queryIndex(){return this._queryIndex;}};WebInspector.ResourceQueryMatch.Type={Normal:Symbol("normal"),Special:Symbol("special")};WebInspector.ResourceQueryResult=class QueryResult extends WebInspector.Object
{constructor(resource,matches,cookie)
{super();this._resource=resource;this._matches=matches;this._cookie=cookie||null;} 
get resource(){return this._resource;}
get cookie(){return this._cookie;}
get rank()
{if(this._rank===undefined)
this._calculateRank();return this._rank;}
get matchingTextRanges()
{if(!this._matchingTextRanges)
this._matchingTextRanges=this._createMatchingTextRanges();return this._matchingTextRanges;} 
_calculateRank()
{const normalWeight=10;const consecutiveWeight=5;const specialMultiplier=5;function getMultiplier(match){if(match.type===WebInspector.ResourceQueryMatch.Type.Special)
return specialMultiplier;return 1;}
this._rank=0;let previousMatch=null;let consecutiveMatchStart=null;for(let match of this._matches){this._rank+=normalWeight*getMultiplier(match);let consecutive=previousMatch&&previousMatch.index===match.index-1;if(consecutive){if(!consecutiveMatchStart)
consecutiveMatchStart=previousMatch;


this._rank+=consecutiveWeight*getMultiplier(consecutiveMatchStart)*(match.index-consecutiveMatchStart.index);}else if(consecutiveMatchStart)
consecutiveMatchStart=null;previousMatch=match;

if(!consecutive)
this._rank-=match.index*getMultiplier(match);}}
_createMatchingTextRanges()
{if(!this._matches.length)
return[];let ranges=[];let startIndex=this._matches[0].index;let endIndex=startIndex;for(let i=1;i<this._matches.length;++i){let match=this._matches[i];if(match.index===endIndex+1){endIndex++;continue;}
ranges.push(new WebInspector.TextRange(0,startIndex,0,endIndex+1));startIndex=match.index;endIndex=startIndex;}
ranges.push(new WebInspector.TextRange(0,startIndex,0,endIndex+1));return ranges;} 
__test_createMatchesMask()
{let filename=this._resource.displayName;let lastIndex=-1;let result="";for(let match of this._matches){let gap=" ".repeat(match.index-lastIndex-1);result+=gap;result+=filename[match.index];lastIndex=match.index;}
return result;}};WebInspector.ResourceTimelineRecord=class ResourceTimelineRecord extends WebInspector.TimelineRecord
{constructor(resource)
{super(WebInspector.TimelineRecord.Type.Network);this._resource=resource;this._resource.addEventListener(WebInspector.Resource.Event.TimestampsDidChange,this._dispatchUpdatedEvent,this);} 
get resource()
{return this._resource;}
get updatesDynamically()
{return true;}
get usesActiveStartTime()
{return true;}
get startTime()
{return this._resource.timingData.startTime;}
get activeStartTime()
{return this._resource.timingData.responseStart;}
get endTime()
{return this._resource.timingData.responseEnd;} 
_dispatchUpdatedEvent()
{this.dispatchEventToListeners(WebInspector.TimelineRecord.Event.Updated);}};WebInspector.ResourceTimingData=class ResourceTimingData extends WebInspector.Object
{constructor(resource,data)
{super();data=data||{};this._resource=resource;this._startTime=data.startTime||NaN;this._domainLookupStart=data.domainLookupStart||NaN;this._domainLookupEnd=data.domainLookupEnd||NaN;this._connectStart=data.connectStart||NaN;this._connectEnd=data.connectEnd||NaN;this._secureConnectionStart=data.secureConnectionStart||NaN;this._requestStart=data.requestStart||NaN;this._responseStart=data.responseStart||NaN;this._responseEnd=data.responseEnd||NaN;if(this._domainLookupStart>=this._domainLookupEnd)
this._domainLookupStart=this._domainLookupEnd=NaN;if(this._connectStart>=this._connectEnd)
this._connectStart=this._connectEnd=NaN;} 
static fromPayload(payload,resource)
{payload=payload||{};if(typeof payload.requestTime==="number"||typeof payload.navigationStart==="number")
payload={};function offsetToTimestamp(offset){return offset>0?payload.startTime+(offset/1000):NaN;}
let data={startTime:payload.startTime,domainLookupStart:offsetToTimestamp(payload.domainLookupStart),domainLookupEnd:offsetToTimestamp(payload.domainLookupEnd),connectStart:offsetToTimestamp(payload.connectStart),connectEnd:offsetToTimestamp(payload.connectEnd),secureConnectionStart:offsetToTimestamp(payload.secureConnectionStart),requestStart:offsetToTimestamp(payload.requestStart),responseStart:offsetToTimestamp(payload.responseStart),responseEnd:offsetToTimestamp(payload.responseEnd)};if(isNaN(data.connectStart)&&!isNaN(data.secureConnectionStart))
data.connectStart=data.secureConnectionStart;return new WebInspector.ResourceTimingData(resource,data);} 
get startTime(){return this._startTime||this._resource.requestSentTimestamp;}
get domainLookupStart(){return this._domainLookupStart;}
get domainLookupEnd(){return this._domainLookupEnd;}
get connectStart(){return this._connectStart;}
get connectEnd(){return this._connectEnd;}
get secureConnectionStart(){return this._secureConnectionStart;}
get requestStart(){return this._requestStart||this._startTime||this._resource.requestSentTimestamp;}
get responseStart(){return this._responseStart||this._startTime||this._resource.responseReceivedTimestamp;}
get responseEnd(){return this._responseEnd||this._resource.finishedOrFailedTimestamp;}
markResponseEndTime(responseEnd)
{this._responseEnd=responseEnd;}};WebInspector.Revision=class Revision extends WebInspector.Object
{ apply()
{console.error("Needs to be implemented by a subclass.");}
revert()
{console.error("Needs to be implemented by a subclass.");}
copy()
{return this;}};WebInspector.ScopeChainNode=class ScopeChainNode extends WebInspector.Object
{constructor(type,objects,name,location,empty)
{super();if(type in WebInspector.ScopeChainNode.Type)
type=WebInspector.ScopeChainNode.Type[type];this._type=type||null;this._objects=objects||[];this._name=name||"";this._location=location||null;this._empty=empty||false;} 
get type(){return this._type;}
get objects(){return this._objects;}
get name(){return this._name;}
get location(){return this._location;}
get empty(){return this._empty;}
get hash()
{if(this._hash)
return this._hash;this._hash=this._name;if(this._location)
this._hash+=`:${this._location.scriptId}:${this._location.lineNumber}:${this._location.columnNumber}`;return this._hash;}
convertToLocalScope()
{this._type=WebInspector.ScopeChainNode.Type.Local;}};WebInspector.ScopeChainNode.Type={Local:"scope-chain-type-local",Global:"scope-chain-type-global",GlobalLexicalEnvironment:"scope-chain-type-global-lexical-environment",With:"scope-chain-type-with",Closure:"scope-chain-type-closure",Catch:"scope-chain-type-catch",FunctionName:"scope-chain-type-function-name",Block:"scope-chain-type-block",};WebInspector.Script=class Script extends WebInspector.SourceCode
{constructor(target,id,range,url,sourceType,injected,sourceURL,sourceMapURL)
{super();this._target=target;this._id=id||null;this._range=range||null;this._url=url||null;this._sourceType=sourceType||WebInspector.Script.SourceType.Program;this._sourceURL=sourceURL||null;this._sourceMappingURL=sourceMapURL||null;this._injected=injected||false;this._dynamicallyAddedScriptElement=false;this._scriptSyntaxTree=null;this._resource=this._resolveResource();
if(this._resource&&this._resource.type===WebInspector.Resource.Type.Document&&!this._range.startLine&&!this._range.startColumn){let documentResource=this._resource;this._resource=null;this._dynamicallyAddedScriptElement=true;documentResource.parentFrame.addExtraScript(this);this._dynamicallyAddedScriptElementNumber=documentResource.parentFrame.extraScriptCollection.items.size;}else if(this._resource)
this._resource.associateWithScript(this);if(isWebInspectorConsoleEvaluationScript(this._sourceURL)){this._uniqueDisplayNameNumber=this.constructor._nextUniqueConsoleDisplayNameNumber++;}
if(this._sourceMappingURL)
WebInspector.sourceMapManager.downloadSourceMap(this._sourceMappingURL,this._url,this);} 
static resetUniqueDisplayNameNumbers()
{WebInspector.Script._nextUniqueDisplayNameNumber=1;WebInspector.Script._nextUniqueConsoleDisplayNameNumber=1;} 
get target(){return this._target;}
get id(){return this._id;}
get range(){return this._range;}
get url(){return this._url;}
get sourceType(){return this._sourceType;}
get sourceURL(){return this._sourceURL;}
get sourceMappingURL(){return this._sourceMappingURL;}
get injected(){return this._injected;}
get contentIdentifier()
{if(this._url)
return this._url;if(!this._sourceURL)
return null;



if(isWebInspectorConsoleEvaluationScript(this._sourceURL))
return null;if(isWebInspectorInternalScript(this._sourceURL))
return null;return this._sourceURL;}
get urlComponents()
{if(!this._urlComponents)
this._urlComponents=parseURL(this._url);return this._urlComponents;}
get mimeType()
{return this._resource.mimeType;}
get displayName()
{if(this._url&&!this._dynamicallyAddedScriptElement)
return WebInspector.displayNameForURL(this._url,this.urlComponents);if(isWebInspectorConsoleEvaluationScript(this._sourceURL)){return WebInspector.UIString("Console Evaluation %d").format(this._uniqueDisplayNameNumber);}
if(this._sourceURL){if(!this._sourceURLComponents)
this._sourceURLComponents=parseURL(this._sourceURL);return WebInspector.displayNameForURL(this._sourceURL,this._sourceURLComponents);}
if(this._dynamicallyAddedScriptElement)
return WebInspector.UIString("Script Element %d").format(this._dynamicallyAddedScriptElementNumber);if(!this._uniqueDisplayNameNumber)
this._uniqueDisplayNameNumber=this.constructor._nextUniqueDisplayNameNumber++;return WebInspector.UIString("Anonymous Script %d").format(this._uniqueDisplayNameNumber);}
get displayURL()
{const isMultiLine=true;const dataURIMaxSize=64;if(this._url)
return WebInspector.truncateURL(this._url,isMultiLine,dataURIMaxSize);if(this._sourceURL)
return WebInspector.truncateURL(this._sourceURL,isMultiLine,dataURIMaxSize);return null;}
get dynamicallyAddedScriptElement()
{return this._dynamicallyAddedScriptElement;}
get anonymous()
{return!this._resource&&!this._url&&!this._sourceURL;}
get resource()
{return this._resource;}
get scriptSyntaxTree()
{return this._scriptSyntaxTree;}
isMainResource()
{return this._target.mainResource===this;}
requestContentFromBackend()
{if(!this._id){
return Promise.reject(new Error("There is no identifier to request content with."));}
return this._target.DebuggerAgent.getScriptSource(this._id);}
saveIdentityToCookie(cookie)
{cookie[WebInspector.Script.URLCookieKey]=this.url;cookie[WebInspector.Script.DisplayNameCookieKey]=this.displayName;}
requestScriptSyntaxTree(callback)
{if(this._scriptSyntaxTree){setTimeout(()=>{callback(this._scriptSyntaxTree);},0);return;}
var makeSyntaxTreeAndCallCallback=(content)=>{this._makeSyntaxTree(content);callback(this._scriptSyntaxTree);};var content=this.content;if(!content&&this._resource&&this._resource.type===WebInspector.Resource.Type.Script&&this._resource.finished)
content=this._resource.content;if(content){setTimeout(makeSyntaxTreeAndCallCallback,0,content);return;}
this.requestContent().then(function(parameters){makeSyntaxTreeAndCallCallback(parameters.sourceCode.content);}).catch(function(error){makeSyntaxTreeAndCallCallback(null);});} 
_resolveResource()
{

if(!this._url)
return null;let resolver=WebInspector.frameResourceManager;if(this._target!==WebInspector.mainTarget)
resolver=this._target.resourceCollection;try{let resource=resolver.resourceForURL(this._url);if(resource)
return resource;let decodedURL=decodeURI(this._url);if(decodedURL!==this._url){resource=resolver.resourceForURL(decodedURL);if(resource)
return resource;}
let urlWithoutFragment=removeURLFragment(this._url);if(urlWithoutFragment!==this._url){resource=resolver.resourceForURL(urlWithoutFragment);if(resource)
return resource;}
let decodedURLWithoutFragment=removeURLFragment(decodedURL);if(decodedURLWithoutFragment!==decodedURL){resource=resolver.resourceForURL(decodedURLWithoutFragment);if(resource)
return resource;}}catch(e){}
return null;}
_makeSyntaxTree(sourceText)
{if(this._scriptSyntaxTree||!sourceText)
return;this._scriptSyntaxTree=new WebInspector.ScriptSyntaxTree(sourceText,this);}};WebInspector.Script.SourceType={Program:"script-source-type-program",Module:"script-source-type-module",};WebInspector.Script.TypeIdentifier="script";WebInspector.Script.URLCookieKey="script-url";WebInspector.Script.DisplayNameCookieKey="script-display-name";WebInspector.Script._nextUniqueDisplayNameNumber=1;WebInspector.Script._nextUniqueConsoleDisplayNameNumber=1;WebInspector.ScriptInstrument=class ScriptInstrument extends WebInspector.Instrument
{ get timelineRecordType()
{return WebInspector.TimelineRecord.Type.Script;}
startInstrumentation(initiatedByBackend)
{if(!window.ScriptProfilerAgent){super.startInstrumentation();return;}
const includeSamples=true;if(!initiatedByBackend)
ScriptProfilerAgent.startTracking(includeSamples);}
stopInstrumentation(initiatedByBackend)
{if(!window.ScriptProfilerAgent){super.stopInstrumentation();return;}
if(!initiatedByBackend)
ScriptProfilerAgent.stopTracking();}};WebInspector.ScriptSyntaxTree=class ScriptSyntaxTree extends WebInspector.Object
{constructor(sourceText,script)
{super();this._script=script;try{let sourceType=this._script.sourceType===WebInspector.Script.SourceType.Module?"module":"script";let esprimaSyntaxTree=esprima.parse(sourceText,{range:true,sourceType});this._syntaxTree=this._createInternalSyntaxTree(esprimaSyntaxTree);this._parsedSuccessfully=true;}catch(error){this._parsedSuccessfully=false;this._syntaxTree=null;console.error("Couldn't parse JavaScript File: "+script.url,error);}} 
get parsedSuccessfully()
{return this._parsedSuccessfully;}
forEachNode(callback)
{if(!this._parsedSuccessfully)
return;this._recurse(this._syntaxTree,callback,this._defaultParserState());}
filter(predicate,startNode)
{if(!this._parsedSuccessfully)
return[];var nodes=[];function filter(node,state)
{if(predicate(node))
nodes.push(node);else
state.skipChildNodes=true;}
this._recurse(startNode,filter,this._defaultParserState());return nodes;}
containersOfOffset(offset)
{if(!this._parsedSuccessfully)
return[];let allNodes=[];const start=0;const end=1;this.forEachNode((node,state)=>{if(node.range[end]<offset)
state.skipChildNodes=true;if(node.range[start]>offset)
state.shouldStopEarly=true;if(node.range[start]<=offset&&node.range[end]>=offset)
allNodes.push(node);});return allNodes;}
filterByRange(startOffset,endOffset)
{if(!this._parsedSuccessfully)
return[];var allNodes=[];var start=0;var end=1;function filterForNodesInRange(node,state)
{


if(node.range[end]<startOffset)
state.skipChildNodes=true;if(startOffset<=node.range[start]&&node.range[start]<=endOffset)
allNodes.push(node);

if(node.range[start]>endOffset)
state.shouldStopEarly=true;}
this.forEachNode(filterForNodesInRange);return allNodes;}
containsNonEmptyReturnStatement(startNode)
{if(!this._parsedSuccessfully)
return false;if(startNode.attachments._hasNonEmptyReturnStatement!==undefined)
return startNode.attachments._hasNonEmptyReturnStatement;function removeFunctionsFilter(node)
{return node.type!==WebInspector.ScriptSyntaxTree.NodeType.FunctionExpression&&node.type!==WebInspector.ScriptSyntaxTree.NodeType.FunctionDeclaration&&node.type!==WebInspector.ScriptSyntaxTree.NodeType.ArrowFunctionExpression;}
var nodes=this.filter(removeFunctionsFilter,startNode);var hasNonEmptyReturnStatement=false;var returnStatementType=WebInspector.ScriptSyntaxTree.NodeType.ReturnStatement;for(var node of nodes){if(node.type===returnStatementType&&node.argument){hasNonEmptyReturnStatement=true;break;}}
startNode.attachments._hasNonEmptyReturnStatement=hasNonEmptyReturnStatement;return hasNonEmptyReturnStatement;}
static functionReturnDivot(node)
{if(!DOMAgent.hasEvent("pseudoElementAdded"))
return node.body.range[0];return node.typeProfilingReturnDivot;}
updateTypes(nodesToUpdate,callback)
{if(!this._parsedSuccessfully)
return;var allRequests=[];var allRequestNodes=[];var sourceID=this._script.id;for(var node of nodesToUpdate){switch(node.type){case WebInspector.ScriptSyntaxTree.NodeType.FunctionDeclaration:case WebInspector.ScriptSyntaxTree.NodeType.FunctionExpression:case WebInspector.ScriptSyntaxTree.NodeType.ArrowFunctionExpression:for(var param of node.params){for(var identifier of this._gatherIdentifiersInDeclaration(param)){allRequests.push({typeInformationDescriptor:WebInspector.ScriptSyntaxTree.TypeProfilerSearchDescriptor.NormalExpression,sourceID,divot:identifier.range[0]});allRequestNodes.push(identifier);}}
allRequests.push({typeInformationDescriptor:WebInspector.ScriptSyntaxTree.TypeProfilerSearchDescriptor.FunctionReturn,sourceID,divot:WebInspector.ScriptSyntaxTree.functionReturnDivot(node)});allRequestNodes.push(node);break;case WebInspector.ScriptSyntaxTree.NodeType.VariableDeclarator:for(var identifier of this._gatherIdentifiersInDeclaration(node.id)){allRequests.push({typeInformationDescriptor:WebInspector.ScriptSyntaxTree.TypeProfilerSearchDescriptor.NormalExpression,sourceID,divot:identifier.range[0]});allRequestNodes.push(identifier);}
break;}}
function handleTypes(error,typeInformationArray)
{if(error)
return;for(var i=0;i<typeInformationArray.length;i++){var node=allRequestNodes[i];var typeInformation=WebInspector.TypeDescription.fromPayload(typeInformationArray[i]);if(allRequests[i].typeInformationDescriptor===WebInspector.ScriptSyntaxTree.TypeProfilerSearchDescriptor.FunctionReturn)
node.attachments.returnTypes=typeInformation;else
node.attachments.types=typeInformation;}
callback(allRequestNodes);}
this._script.target.RuntimeAgent.getRuntimeTypesForVariablesAtOffsets(allRequests,handleTypes);} 
_gatherIdentifiersInDeclaration(node)
{function gatherIdentifiers(node)
{switch(node.type){case WebInspector.ScriptSyntaxTree.NodeType.Identifier:return[node];case WebInspector.ScriptSyntaxTree.NodeType.Property:return gatherIdentifiers(node.value);case WebInspector.ScriptSyntaxTree.NodeType.ObjectPattern:var identifiers=[];for(var property of node.properties){for(var identifier of gatherIdentifiers(property))
identifiers.push(identifier);}
return identifiers;case WebInspector.ScriptSyntaxTree.NodeType.ArrayPattern:var identifiers=[];for(var element of node.elements){for(var identifier of gatherIdentifiers(element))
identifiers.push(identifier);}
return identifiers;case WebInspector.ScriptSyntaxTree.NodeType.AssignmentPattern:return gatherIdentifiers(node.left);case WebInspector.ScriptSyntaxTree.NodeType.RestElement:case WebInspector.ScriptSyntaxTree.NodeType.RestProperty:return gatherIdentifiers(node.argument);default:return[];}}
return gatherIdentifiers(node);}
_defaultParserState()
{return{shouldStopEarly:false,skipChildNodes:false};}
_recurse(node,callback,state)
{if(!node)
return;if(state.shouldStopEarly||state.skipChildNodes)
return;callback(node,state);switch(node.type){case WebInspector.ScriptSyntaxTree.NodeType.AssignmentExpression:this._recurse(node.left,callback,state);this._recurse(node.right,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ArrayExpression:case WebInspector.ScriptSyntaxTree.NodeType.ArrayPattern:this._recurseArray(node.elements,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.AssignmentPattern:this._recurse(node.left,callback,state);this._recurse(node.right,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.AwaitExpression:this._recurse(node.argument,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.BlockStatement:this._recurseArray(node.body,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.BinaryExpression:this._recurse(node.left,callback,state);this._recurse(node.right,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.BreakStatement:this._recurse(node.label,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.CatchClause:this._recurse(node.param,callback,state);this._recurse(node.body,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.CallExpression:this._recurse(node.callee,callback,state);this._recurseArray(node.arguments,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ClassBody:this._recurseArray(node.body,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ClassDeclaration:case WebInspector.ScriptSyntaxTree.NodeType.ClassExpression:this._recurse(node.id,callback,state);this._recurse(node.superClass,callback,state);this._recurse(node.body,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ContinueStatement:this._recurse(node.label,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.DoWhileStatement:this._recurse(node.body,callback,state);this._recurse(node.test,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ExpressionStatement:this._recurse(node.expression,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ForStatement:this._recurse(node.init,callback,state);this._recurse(node.test,callback,state);this._recurse(node.update,callback,state);this._recurse(node.body,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ForInStatement:case WebInspector.ScriptSyntaxTree.NodeType.ForOfStatement:this._recurse(node.left,callback,state);this._recurse(node.right,callback,state);this._recurse(node.body,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.FunctionDeclaration:case WebInspector.ScriptSyntaxTree.NodeType.FunctionExpression:case WebInspector.ScriptSyntaxTree.NodeType.ArrowFunctionExpression:this._recurse(node.id,callback,state);this._recurseArray(node.params,callback,state);this._recurse(node.body,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.IfStatement:this._recurse(node.test,callback,state);this._recurse(node.consequent,callback,state);this._recurse(node.alternate,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.LabeledStatement:this._recurse(node.label,callback,state);this._recurse(node.body,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.LogicalExpression:this._recurse(node.left,callback,state);this._recurse(node.right,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.MemberExpression:this._recurse(node.object,callback,state);this._recurse(node.property,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.MethodDefinition:this._recurse(node.key,callback,state);this._recurse(node.value,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.NewExpression:this._recurse(node.callee,callback,state);this._recurseArray(node.arguments,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ObjectExpression:case WebInspector.ScriptSyntaxTree.NodeType.ObjectPattern:this._recurseArray(node.properties,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.Program:this._recurseArray(node.body,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.Property:this._recurse(node.key,callback,state);this._recurse(node.value,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.RestElement:this._recurse(node.argument,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.RestProperty:this._recurse(node.argument,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ReturnStatement:this._recurse(node.argument,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.SequenceExpression:this._recurseArray(node.expressions,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.SpreadElement:this._recurse(node.argument,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.SpreadProperty:this._recurse(node.argument,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.SwitchStatement:this._recurse(node.discriminant,callback,state);this._recurseArray(node.cases,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.SwitchCase:this._recurse(node.test,callback,state);this._recurseArray(node.consequent,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ConditionalExpression:this._recurse(node.test,callback,state);this._recurse(node.consequent,callback,state);this._recurse(node.alternate,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.TaggedTemplateExpression:this._recurse(node.tag,callback,state);this._recurse(node.quasi,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.TemplateLiteral:this._recurseArray(node.quasis,callback,state);this._recurseArray(node.expressions,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ThrowStatement:this._recurse(node.argument,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.TryStatement:this._recurse(node.block,callback,state);this._recurse(node.handler,callback,state);this._recurse(node.finalizer,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.UnaryExpression:this._recurse(node.argument,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.UpdateExpression:this._recurse(node.argument,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.VariableDeclaration:this._recurseArray(node.declarations,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.VariableDeclarator:this._recurse(node.id,callback,state);this._recurse(node.init,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.WhileStatement:this._recurse(node.test,callback,state);this._recurse(node.body,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.WithStatement:this._recurse(node.object,callback,state);this._recurse(node.body,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.YieldExpression:this._recurse(node.argument,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ExportAllDeclaration:this._recurse(node.source,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ExportNamedDeclaration:this._recurse(node.declaration,callback,state);this._recurseArray(node.specifiers,callback,state);this._recurse(node.source,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ExportDefaultDeclaration:this._recurse(node.declaration,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ExportSpecifier:this._recurse(node.local,callback,state);this._recurse(node.exported,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ImportDeclaration:this._recurseArray(node.specifiers,callback,state);this._recurse(node.source,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ImportDefaultSpecifier:this._recurse(node.local,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ImportNamespaceSpecifier:this._recurse(node.local,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.ImportSpecifier:this._recurse(node.imported,callback,state);this._recurse(node.local,callback,state);break;case WebInspector.ScriptSyntaxTree.NodeType.DebuggerStatement:case WebInspector.ScriptSyntaxTree.NodeType.EmptyStatement:case WebInspector.ScriptSyntaxTree.NodeType.Identifier:case WebInspector.ScriptSyntaxTree.NodeType.Import:case WebInspector.ScriptSyntaxTree.NodeType.Literal:case WebInspector.ScriptSyntaxTree.NodeType.MetaProperty:case WebInspector.ScriptSyntaxTree.NodeType.Super:case WebInspector.ScriptSyntaxTree.NodeType.ThisExpression:case WebInspector.ScriptSyntaxTree.NodeType.TemplateElement:break;}
state.skipChildNodes=false;}
_recurseArray(array,callback,state)
{for(var node of array)
this._recurse(node,callback,state);} 
_createInternalSyntaxTree(node)
{if(!node)
return null;var result=null;switch(node.type){case"ArrayExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.ArrayExpression,elements:node.elements.map(this._createInternalSyntaxTree,this)};break;case"ArrayPattern":result={type:WebInspector.ScriptSyntaxTree.NodeType.ArrayPattern,elements:node.elements.map(this._createInternalSyntaxTree,this)};break;case"ArrowFunctionExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.ArrowFunctionExpression,id:this._createInternalSyntaxTree(node.id),params:node.params.map(this._createInternalSyntaxTree,this),body:this._createInternalSyntaxTree(node.body),generator:node.generator,expression:node.expression,async:node.async,typeProfilingReturnDivot:node.range[0]};break;case"AssignmentExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.AssignmentExpression,operator:node.operator,left:this._createInternalSyntaxTree(node.left),right:this._createInternalSyntaxTree(node.right)};break;case"AssignmentPattern":result={type:WebInspector.ScriptSyntaxTree.NodeType.AssignmentPattern,left:this._createInternalSyntaxTree(node.left),right:this._createInternalSyntaxTree(node.right),};break;case"AwaitExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.AwaitExpression,argument:this._createInternalSyntaxTree(node.argument),};break;case"BlockStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.BlockStatement,body:node.body.map(this._createInternalSyntaxTree,this)};break;case"BinaryExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.BinaryExpression,operator:node.operator,left:this._createInternalSyntaxTree(node.left),right:this._createInternalSyntaxTree(node.right)};break;case"BreakStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.BreakStatement,label:this._createInternalSyntaxTree(node.label)};break;case"CallExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.CallExpression,callee:this._createInternalSyntaxTree(node.callee),arguments:node.arguments.map(this._createInternalSyntaxTree,this)};break;case"CatchClause":result={type:WebInspector.ScriptSyntaxTree.NodeType.CatchClause,param:this._createInternalSyntaxTree(node.param),body:this._createInternalSyntaxTree(node.body)};break;case"ClassBody":result={type:WebInspector.ScriptSyntaxTree.NodeType.ClassBody,body:node.body.map(this._createInternalSyntaxTree,this)};break;case"ClassDeclaration":result={type:WebInspector.ScriptSyntaxTree.NodeType.ClassDeclaration,id:this._createInternalSyntaxTree(node.id),superClass:this._createInternalSyntaxTree(node.superClass),body:this._createInternalSyntaxTree(node.body),};break;case"ClassExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.ClassExpression,id:this._createInternalSyntaxTree(node.id),superClass:this._createInternalSyntaxTree(node.superClass),body:this._createInternalSyntaxTree(node.body),};break;case"ConditionalExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.ConditionalExpression,test:this._createInternalSyntaxTree(node.test),consequent:this._createInternalSyntaxTree(node.consequent),alternate:this._createInternalSyntaxTree(node.alternate)};break;case"ContinueStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.ContinueStatement,label:this._createInternalSyntaxTree(node.label)};break;case"DoWhileStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.DoWhileStatement,body:this._createInternalSyntaxTree(node.body),test:this._createInternalSyntaxTree(node.test)};break;case"DebuggerStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.DebuggerStatement};break;case"EmptyStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.EmptyStatement};break;case"ExpressionStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.ExpressionStatement,expression:this._createInternalSyntaxTree(node.expression)};break;case"ForStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.ForStatement,init:this._createInternalSyntaxTree(node.init),test:this._createInternalSyntaxTree(node.test),update:this._createInternalSyntaxTree(node.update),body:this._createInternalSyntaxTree(node.body)};break;case"ForInStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.ForInStatement,left:this._createInternalSyntaxTree(node.left),right:this._createInternalSyntaxTree(node.right),body:this._createInternalSyntaxTree(node.body)};break;case"ForOfStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.ForOfStatement,left:this._createInternalSyntaxTree(node.left),right:this._createInternalSyntaxTree(node.right),body:this._createInternalSyntaxTree(node.body)};break;case"FunctionDeclaration":result={type:WebInspector.ScriptSyntaxTree.NodeType.FunctionDeclaration,id:this._createInternalSyntaxTree(node.id),params:node.params.map(this._createInternalSyntaxTree,this),body:this._createInternalSyntaxTree(node.body),generator:node.generator,async:node.async,typeProfilingReturnDivot:node.range[0]};break;case"FunctionExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.FunctionExpression,id:this._createInternalSyntaxTree(node.id),params:node.params.map(this._createInternalSyntaxTree,this),body:this._createInternalSyntaxTree(node.body),generator:node.generator,async:node.async,typeProfilingReturnDivot:node.range[0]
};break;case"Identifier":result={type:WebInspector.ScriptSyntaxTree.NodeType.Identifier,name:node.name};break;case"IfStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.IfStatement,test:this._createInternalSyntaxTree(node.test),consequent:this._createInternalSyntaxTree(node.consequent),alternate:this._createInternalSyntaxTree(node.alternate)};break;case"Literal":result={type:WebInspector.ScriptSyntaxTree.NodeType.Literal,value:node.value,raw:node.raw};break;case"LabeledStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.LabeledStatement,label:this._createInternalSyntaxTree(node.label),body:this._createInternalSyntaxTree(node.body)};break;case"LogicalExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.LogicalExpression,left:this._createInternalSyntaxTree(node.left),right:this._createInternalSyntaxTree(node.right),operator:node.operator};break;case"MemberExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.MemberExpression,object:this._createInternalSyntaxTree(node.object),property:this._createInternalSyntaxTree(node.property),computed:node.computed};break;case"MetaProperty":result={type:WebInspector.ScriptSyntaxTree.NodeType.MetaProperty,meta:this._createInternalSyntaxTree(node.meta),property:this._createInternalSyntaxTree(node.property),};break;case"MethodDefinition":result={type:WebInspector.ScriptSyntaxTree.NodeType.MethodDefinition,key:this._createInternalSyntaxTree(node.key),value:this._createInternalSyntaxTree(node.value),computed:node.computed,kind:node.kind,static:node.static};result.value.typeProfilingReturnDivot=node.range[0];break;case"NewExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.NewExpression,callee:this._createInternalSyntaxTree(node.callee),arguments:node.arguments.map(this._createInternalSyntaxTree,this)};break;case"ObjectExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.ObjectExpression,properties:node.properties.map(this._createInternalSyntaxTree,this)};break;case"ObjectPattern":result={type:WebInspector.ScriptSyntaxTree.NodeType.ObjectPattern,properties:node.properties.map(this._createInternalSyntaxTree,this)};break;case"Program":result={type:WebInspector.ScriptSyntaxTree.NodeType.Program,sourceType:node.sourceType,body:node.body.map(this._createInternalSyntaxTree,this)};break;case"Property":result={type:WebInspector.ScriptSyntaxTree.NodeType.Property,key:this._createInternalSyntaxTree(node.key),value:this._createInternalSyntaxTree(node.value),kind:node.kind,method:node.method,computed:node.computed};if(result.kind==="get"||result.kind==="set"||result.method)
result.value.typeProfilingReturnDivot=node.range[0];break;case"RestElement":result={type:WebInspector.ScriptSyntaxTree.NodeType.RestElement,argument:this._createInternalSyntaxTree(node.argument)};break;case"RestProperty":result={type:WebInspector.ScriptSyntaxTree.NodeType.RestProperty,argument:this._createInternalSyntaxTree(node.argument),};break;case"ReturnStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.ReturnStatement,argument:this._createInternalSyntaxTree(node.argument)};break;case"SequenceExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.SequenceExpression,expressions:node.expressions.map(this._createInternalSyntaxTree,this)};break;case"SpreadElement":result={type:WebInspector.ScriptSyntaxTree.NodeType.SpreadElement,argument:this._createInternalSyntaxTree(node.argument),};break;case"SpreadProperty":result={type:WebInspector.ScriptSyntaxTree.NodeType.SpreadProperty,argument:this._createInternalSyntaxTree(node.argument),};break;case"Super":result={type:WebInspector.ScriptSyntaxTree.NodeType.Super};break;case"SwitchStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.SwitchStatement,discriminant:this._createInternalSyntaxTree(node.discriminant),cases:node.cases.map(this._createInternalSyntaxTree,this)};break;case"SwitchCase":result={type:WebInspector.ScriptSyntaxTree.NodeType.SwitchCase,test:this._createInternalSyntaxTree(node.test),consequent:node.consequent.map(this._createInternalSyntaxTree,this)};break;case"TaggedTemplateExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.TaggedTemplateExpression,tag:this._createInternalSyntaxTree(node.tag),quasi:this._createInternalSyntaxTree(node.quasi)};break;case"TemplateElement":result={type:WebInspector.ScriptSyntaxTree.NodeType.TemplateElement,value:node.value,tail:node.tail};break;case"TemplateLiteral":result={type:WebInspector.ScriptSyntaxTree.NodeType.TemplateLiteral,quasis:node.quasis.map(this._createInternalSyntaxTree,this),expressions:node.expressions.map(this._createInternalSyntaxTree,this)};break;case"ThisExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.ThisExpression};break;case"ThrowStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.ThrowStatement,argument:this._createInternalSyntaxTree(node.argument)};break;case"TryStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.TryStatement,block:this._createInternalSyntaxTree(node.block),handler:this._createInternalSyntaxTree(node.handler),finalizer:this._createInternalSyntaxTree(node.finalizer)};break;case"UnaryExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.UnaryExpression,operator:node.operator,argument:this._createInternalSyntaxTree(node.argument)};break;case"UpdateExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.UpdateExpression,operator:node.operator,prefix:node.prefix,argument:this._createInternalSyntaxTree(node.argument)};break;case"VariableDeclaration":result={type:WebInspector.ScriptSyntaxTree.NodeType.VariableDeclaration,declarations:node.declarations.map(this._createInternalSyntaxTree,this),kind:node.kind};break;case"VariableDeclarator":result={type:WebInspector.ScriptSyntaxTree.NodeType.VariableDeclarator,id:this._createInternalSyntaxTree(node.id),init:this._createInternalSyntaxTree(node.init)};break;case"WhileStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.WhileStatement,test:this._createInternalSyntaxTree(node.test),body:this._createInternalSyntaxTree(node.body)};break;case"WithStatement":result={type:WebInspector.ScriptSyntaxTree.NodeType.WithStatement,object:this._createInternalSyntaxTree(node.object),body:this._createInternalSyntaxTree(node.body)};break;case"YieldExpression":result={type:WebInspector.ScriptSyntaxTree.NodeType.YieldExpression,argument:this._createInternalSyntaxTree(node.argument),delegate:node.delegate};break;case"ExportAllDeclaration":result={type:WebInspector.ScriptSyntaxTree.NodeType.ExportAllDeclaration,source:this._createInternalSyntaxTree(node.source),};break;case"ExportNamedDeclaration":result={type:WebInspector.ScriptSyntaxTree.NodeType.ExportNamedDeclaration,declaration:this._createInternalSyntaxTree(node.declaration),specifiers:node.specifiers.map(this._createInternalSyntaxTree,this),source:this._createInternalSyntaxTree(node.source),};break;case"ExportDefaultDeclaration":result={type:WebInspector.ScriptSyntaxTree.NodeType.ExportDefaultDeclaration,declaration:this._createInternalSyntaxTree(node.declaration),};break;case"ExportSpecifier":result={type:WebInspector.ScriptSyntaxTree.NodeType.ExportSpecifier,local:this._createInternalSyntaxTree(node.local),exported:this._createInternalSyntaxTree(node.exported),};break;case"Import":result={type:WebInspector.ScriptSyntaxTree.NodeType.Import,};break;case"ImportDeclaration":result={type:WebInspector.ScriptSyntaxTree.NodeType.ImportDeclaration,specifiers:node.specifiers.map(this._createInternalSyntaxTree,this),source:this._createInternalSyntaxTree(node.source),};break;case"ImportDefaultSpecifier":result={type:WebInspector.ScriptSyntaxTree.NodeType.ImportDefaultSpecifier,local:this._createInternalSyntaxTree(node.local),};break;case"ImportNamespaceSpecifier":result={type:WebInspector.ScriptSyntaxTree.NodeType.ImportNamespaceSpecifier,local:this._createInternalSyntaxTree(node.local),};break;case"ImportSpecifier":result={type:WebInspector.ScriptSyntaxTree.NodeType.ImportSpecifier,imported:this._createInternalSyntaxTree(node.imported),local:this._createInternalSyntaxTree(node.local),};break;default:console.error("Unsupported Syntax Tree Node: "+node.type,node);return null;}
result.range=node.range;result.attachments={};return result;}};WebInspector.ScriptSyntaxTree.TypeProfilerSearchDescriptor={NormalExpression:1,FunctionReturn:2};WebInspector.ScriptSyntaxTree.NodeType={ArrayExpression:Symbol("array-expression"),ArrayPattern:Symbol("array-pattern"),ArrowFunctionExpression:Symbol("arrow-function-expression"),AssignmentExpression:Symbol("assignment-expression"),AssignmentPattern:Symbol("assignment-pattern"),AwaitExpression:Symbol("await-expression"),BinaryExpression:Symbol("binary-expression"),BlockStatement:Symbol("block-statement"),BreakStatement:Symbol("break-statement"),CallExpression:Symbol("call-expression"),CatchClause:Symbol("catch-clause"),ClassBody:Symbol("class-body"),ClassDeclaration:Symbol("class-declaration"),ClassExpression:Symbol("class-expression"),ConditionalExpression:Symbol("conditional-expression"),ContinueStatement:Symbol("continue-statement"),DebuggerStatement:Symbol("debugger-statement"),DoWhileStatement:Symbol("do-while-statement"),EmptyStatement:Symbol("empty-statement"),ExportAllDeclaration:Symbol("export-all-declaration"),ExportDefaultDeclaration:Symbol("export-default-declaration"),ExportNamedDeclaration:Symbol("export-named-declaration"),ExportSpecifier:Symbol("export-specifier"),ExpressionStatement:Symbol("expression-statement"),ForInStatement:Symbol("for-in-statement"),ForOfStatement:Symbol("for-of-statement"),ForStatement:Symbol("for-statement"),FunctionDeclaration:Symbol("function-declaration"),FunctionExpression:Symbol("function-expression"),Identifier:Symbol("identifier"),IfStatement:Symbol("if-statement"),Import:Symbol("import"),ImportDeclaration:Symbol("import-declaration"),ImportDefaultSpecifier:Symbol("import-default-specifier"),ImportNamespaceSpecifier:Symbol("import-namespace-specifier"),ImportSpecifier:Symbol("import-specifier"),LabeledStatement:Symbol("labeled-statement"),Literal:Symbol("literal"),LogicalExpression:Symbol("logical-expression"),MemberExpression:Symbol("member-expression"),MetaProperty:Symbol("meta-property"),MethodDefinition:Symbol("method-definition"),NewExpression:Symbol("new-expression"),ObjectExpression:Symbol("object-expression"),ObjectPattern:Symbol("object-pattern"),Program:Symbol("program"),Property:Symbol("property"),RestElement:Symbol("rest-element"),RestProperty:Symbol("rest-property"),ReturnStatement:Symbol("return-statement"),SequenceExpression:Symbol("sequence-expression"),SpreadElement:Symbol("spread-element"),SpreadProperty:Symbol("spread-property"),Super:Symbol("super"),SwitchCase:Symbol("switch-case"),SwitchStatement:Symbol("switch-statement"),TaggedTemplateExpression:Symbol("tagged-template-expression"),TemplateElement:Symbol("template-element"),TemplateLiteral:Symbol("template-literal"),ThisExpression:Symbol("this-expression"),ThrowStatement:Symbol("throw-statement"),TryStatement:Symbol("try-statement"),UnaryExpression:Symbol("unary-expression"),UpdateExpression:Symbol("update-expression"),VariableDeclaration:Symbol("variable-declaration"),VariableDeclarator:Symbol("variable-declarator"),WhileStatement:Symbol("while-statement"),WithStatement:Symbol("with-statement"),YieldExpression:Symbol("yield-expression"),};WebInspector.ScriptTimelineRecord=class ScriptTimelineRecord extends WebInspector.TimelineRecord
{constructor(eventType,startTime,endTime,callFrames,sourceCodeLocation,details,profilePayload)
{super(WebInspector.TimelineRecord.Type.Script,startTime,endTime,callFrames,sourceCodeLocation);if(eventType in WebInspector.ScriptTimelineRecord.EventType)
eventType=WebInspector.ScriptTimelineRecord.EventType[eventType];this._eventType=eventType;this._details=details||"";this._profilePayload=profilePayload||null;this._profile=null;if(!window.ScriptProfilerAgent)
this._callCountOrSamples=NaN;else{this._callCountOrSamples=0;}} 
get eventType()
{return this._eventType;}
get details()
{return this._details;}
get profile()
{this._initializeProfileFromPayload();return this._profile;}
get callCountOrSamples()
{return this._callCountOrSamples;}
isGarbageCollection()
{return this._eventType===WebInspector.ScriptTimelineRecord.EventType.GarbageCollected;}
saveIdentityToCookie(cookie)
{super.saveIdentityToCookie(cookie);cookie[WebInspector.ScriptTimelineRecord.EventTypeCookieKey]=this._eventType;cookie[WebInspector.ScriptTimelineRecord.DetailsCookieKey]=this._details;}
get profilePayload()
{return this._profilePayload;}
set profilePayload(payload)
{this._profilePayload=payload;} 
_initializeProfileFromPayload(payload)
{if(this._profile||!this._profilePayload)
return;var payload=this._profilePayload;this._profilePayload=undefined;function profileNodeFromPayload(nodePayload)
{if(nodePayload.url){var sourceCode=WebInspector.frameResourceManager.resourceForURL(nodePayload.url);if(!sourceCode)
sourceCode=WebInspector.debuggerManager.scriptsForURL(nodePayload.url,WebInspector.assumingMainTarget())[0];var lineNumber=nodePayload.lineNumber-1;var sourceCodeLocation=sourceCode?sourceCode.createLazySourceCodeLocation(lineNumber,nodePayload.columnNumber):null;}
var isProgramCode=nodePayload.functionName==="(program)";var isAnonymousFunction=nodePayload.functionName==="(anonymous function)";var type=isProgramCode?WebInspector.ProfileNode.Type.Program:WebInspector.ProfileNode.Type.Function;var functionName=!isProgramCode&&!isAnonymousFunction&&nodePayload.functionName!=="(unknown)"?nodePayload.functionName:null;
var calls=null;if("calls"in nodePayload){calls=nodePayload.calls.map(profileNodeCallFromPayload);}
return new WebInspector.ProfileNode(nodePayload.id,type,functionName,sourceCodeLocation,nodePayload.callInfo,calls,nodePayload.children);}
function profileNodeCallFromPayload(nodeCallPayload)
{var startTime=WebInspector.timelineManager.computeElapsedTime(nodeCallPayload.startTime);return new WebInspector.ProfileNodeCall(startTime,nodeCallPayload.totalTime);}
var rootNodes=payload.rootNodes;var stack=[{parent:{children:rootNodes},index:0,root:true}];while(stack.length){var entry=stack.lastValue;if(entry.index<entry.parent.children.length){var childNodePayload=entry.parent.children[entry.index];if(childNodePayload.children&&childNodePayload.children.length)
stack.push({parent:childNodePayload,index:0});++entry.index;}else{if(!entry.root)
entry.parent.children=entry.parent.children.map(profileNodeFromPayload);else
rootNodes=rootNodes.map(profileNodeFromPayload);stack.pop();}}
if(window.ScriptProfilerAgent){for(let i=0;i<rootNodes.length;i++)
this._callCountOrSamples+=rootNodes[i].callInfo.callCount;}
this._profile=new WebInspector.Profile(rootNodes);}};WebInspector.ScriptTimelineRecord.EventType={ScriptEvaluated:"script-timeline-record-script-evaluated",APIScriptEvaluated:"script-timeline-record-api-script-evaluated",MicrotaskDispatched:"script-timeline-record-microtask-dispatched",EventDispatched:"script-timeline-record-event-dispatched",ProbeSampleRecorded:"script-timeline-record-probe-sample-recorded",TimerFired:"script-timeline-record-timer-fired",TimerInstalled:"script-timeline-record-timer-installed",TimerRemoved:"script-timeline-record-timer-removed",AnimationFrameFired:"script-timeline-record-animation-frame-fired",AnimationFrameRequested:"script-timeline-record-animation-frame-requested",AnimationFrameCanceled:"script-timeline-record-animation-frame-canceled",ConsoleProfileRecorded:"script-timeline-record-console-profile-recorded",GarbageCollected:"script-timeline-record-garbage-collected",};WebInspector.ScriptTimelineRecord.EventType.displayName=function(eventType,details,includeDetailsInMainTitle)
{if(details&&!WebInspector.ScriptTimelineRecord._eventDisplayNames){
var nameMap=new Map;nameMap.set("DOMActivate","DOM Activate");nameMap.set("DOMCharacterDataModified","DOM Character Data Modified");nameMap.set("DOMContentLoaded","DOM Content Loaded");nameMap.set("DOMFocusIn","DOM Focus In");nameMap.set("DOMFocusOut","DOM Focus Out");nameMap.set("DOMNodeInserted","DOM Node Inserted");nameMap.set("DOMNodeInsertedIntoDocument","DOM Node Inserted Into Document");nameMap.set("DOMNodeRemoved","DOM Node Removed");nameMap.set("DOMNodeRemovedFromDocument","DOM Node Removed From Document");nameMap.set("DOMSubtreeModified","DOM Sub-Tree Modified");nameMap.set("addsourcebuffer","Add Source Buffer");nameMap.set("addstream","Add Stream");nameMap.set("addtrack","Add Track");nameMap.set("animationend","Animation End");nameMap.set("animationiteration","Animation Iteration");nameMap.set("animationstart","Animation Start");nameMap.set("audioend","Audio End");nameMap.set("audioprocess","Audio Process");nameMap.set("audiostart","Audio Start");nameMap.set("beforecopy","Before Copy");nameMap.set("beforecut","Before Cut");nameMap.set("beforeload","Before Load");nameMap.set("beforepaste","Before Paste");nameMap.set("beforeunload","Before Unload");nameMap.set("canplay","Can Play");nameMap.set("canplaythrough","Can Play Through");nameMap.set("chargingchange","Charging Change");nameMap.set("chargingtimechange","Charging Time Change");nameMap.set("compositionend","Composition End");nameMap.set("compositionstart","Composition Start");nameMap.set("compositionupdate","Composition Update");nameMap.set("contextmenu","Context Menu");nameMap.set("cuechange","Cue Change");nameMap.set("datachannel","Data Channel");nameMap.set("dblclick","Double Click");nameMap.set("devicemotion","Device Motion");nameMap.set("deviceorientation","Device Orientation");nameMap.set("dischargingtimechange","Discharging Time Change");nameMap.set("dragend","Drag End");nameMap.set("dragenter","Drag Enter");nameMap.set("dragleave","Drag Leave");nameMap.set("dragover","Drag Over");nameMap.set("dragstart","Drag Start");nameMap.set("durationchange","Duration Change");nameMap.set("focusin","Focus In");nameMap.set("focusout","Focus Out");nameMap.set("gesturechange","Gesture Change");nameMap.set("gestureend","Gesture End");nameMap.set("gesturescrollend","Gesture Scroll End");nameMap.set("gesturescrollstart","Gesture Scroll Start");nameMap.set("gesturescrollupdate","Gesture Scroll Update");nameMap.set("gesturestart","Gesture Start");nameMap.set("gesturetap","Gesture Tap");nameMap.set("gesturetapdown","Gesture Tap Down");nameMap.set("hashchange","Hash Change");nameMap.set("icecandidate","ICE Candidate");nameMap.set("iceconnectionstatechange","ICE Connection State Change");nameMap.set("keydown","Key Down");nameMap.set("keypress","Key Press");nameMap.set("keyup","Key Up");nameMap.set("levelchange","Level Change");nameMap.set("loadeddata","Loaded Data");nameMap.set("loadedmetadata","Loaded Metadata");nameMap.set("loadend","Load End");nameMap.set("loadingdone","Loading Done");nameMap.set("loadstart","Load Start");nameMap.set("mousedown","Mouse Down");nameMap.set("mouseenter","Mouse Enter");nameMap.set("mouseleave","Mouse Leave");nameMap.set("mousemove","Mouse Move");nameMap.set("mouseout","Mouse Out");nameMap.set("mouseover","Mouse Over");nameMap.set("mouseup","Mouse Up");nameMap.set("mousewheel","Mouse Wheel");nameMap.set("negotiationneeded","Negotiation Needed");nameMap.set("nomatch","No Match");nameMap.set("noupdate","No Update");nameMap.set("orientationchange","Orientation Change");nameMap.set("overflowchanged","Overflow Changed");nameMap.set("pagehide","Page Hide");nameMap.set("pageshow","Page Show");nameMap.set("popstate","Pop State");nameMap.set("ratechange","Rate Change");nameMap.set("readystatechange","Ready State Change");nameMap.set("removesourcebuffer","Remove Source Buffer");nameMap.set("removestream","Remove Stream");nameMap.set("removetrack","Remove Track");nameMap.set("resize","Resize");nameMap.set("securitypolicyviolation","Security Policy Violation");nameMap.set("selectionchange","Selection Change");nameMap.set("selectstart","Select Start");nameMap.set("signalingstatechange","Signaling State Change");nameMap.set("soundend","Sound End");nameMap.set("soundstart","Sound Start");nameMap.set("sourceclose","Source Close");nameMap.set("sourceended","Source Ended");nameMap.set("sourceopen","Source Open");nameMap.set("speechend","Speech End");nameMap.set("speechstart","Speech Start");nameMap.set("textInput","Text Input");nameMap.set("timeupdate","Time Update");nameMap.set("tonechange","Tone Change");nameMap.set("touchcancel","Touch Cancel");nameMap.set("touchend","Touch End");nameMap.set("touchmove","Touch Move");nameMap.set("touchstart","Touch Start");nameMap.set("transitionend","Transition End");nameMap.set("updateend","Update End");nameMap.set("updateready","Update Ready");nameMap.set("updatestart","Update Start");nameMap.set("upgradeneeded","Upgrade Needed");nameMap.set("versionchange","Version Change");nameMap.set("visibilitychange","Visibility Change");nameMap.set("volumechange","Volume Change");nameMap.set("webglcontextcreationerror","WebGL Context Creation Error");nameMap.set("webglcontextlost","WebGL Context Lost");nameMap.set("webglcontextrestored","WebGL Context Restored");nameMap.set("webkitAnimationEnd","Animation End");nameMap.set("webkitAnimationIteration","Animation Iteration");nameMap.set("webkitAnimationStart","Animation Start");nameMap.set("webkitBeforeTextInserted","Before Text Inserted");nameMap.set("webkitEditableContentChanged","Editable Content Changed");nameMap.set("webkitTransitionEnd","Transition End");nameMap.set("webkitaddsourcebuffer","Add Source Buffer");nameMap.set("webkitbeginfullscreen","Begin Full Screen");nameMap.set("webkitcurrentplaybacktargetiswirelesschanged","Current Playback Target Is Wireless Changed");nameMap.set("webkitdeviceproximity","Device Proximity");nameMap.set("webkitendfullscreen","End Full Screen");nameMap.set("webkitfullscreenchange","Full Screen Change");nameMap.set("webkitfullscreenerror","Full Screen Error");nameMap.set("webkitkeyadded","Key Added");nameMap.set("webkitkeyerror","Key Error");nameMap.set("webkitkeymessage","Key Message");nameMap.set("webkitneedkey","Need Key");nameMap.set("webkitnetworkinfochange","Network Info Change");nameMap.set("webkitplaybacktargetavailabilitychanged","Playback Target Availability Changed");nameMap.set("webkitpointerlockchange","Pointer Lock Change");nameMap.set("webkitpointerlockerror","Pointer Lock Error");nameMap.set("webkitregionlayoutupdate","Region Layout Update");nameMap.set("webkitregionoversetchange","Region Overset Change");nameMap.set("webkitremovesourcebuffer","Remove Source Buffer");nameMap.set("webkitresourcetimingbufferfull","Resource Timing Buffer Full");nameMap.set("webkitsourceclose","Source Close");nameMap.set("webkitsourceended","Source Ended");nameMap.set("webkitsourceopen","Source Open");nameMap.set("webkitspeechchange","Speech Change");nameMap.set("writeend","Write End");nameMap.set("writestart","Write Start");WebInspector.ScriptTimelineRecord._eventDisplayNames=nameMap;}
switch(eventType){case WebInspector.ScriptTimelineRecord.EventType.ScriptEvaluated:case WebInspector.ScriptTimelineRecord.EventType.APIScriptEvaluated:return WebInspector.UIString("Script Evaluated");case WebInspector.ScriptTimelineRecord.EventType.MicrotaskDispatched:return WebInspector.UIString("Microtask Dispatched");case WebInspector.ScriptTimelineRecord.EventType.EventDispatched:if(details&&(details instanceof String||typeof details==="string")){var eventDisplayName=WebInspector.ScriptTimelineRecord._eventDisplayNames.get(details)||details.capitalize();return WebInspector.UIString("%s Event Dispatched").format(eventDisplayName);}
return WebInspector.UIString("Event Dispatched");case WebInspector.ScriptTimelineRecord.EventType.ProbeSampleRecorded:return WebInspector.UIString("Probe Sample Recorded");case WebInspector.ScriptTimelineRecord.EventType.ConsoleProfileRecorded:if(details&&(details instanceof String||typeof details==="string"))
return WebInspector.UIString("“%s” Profile Recorded").format(details);return WebInspector.UIString("Console Profile Recorded");case WebInspector.ScriptTimelineRecord.EventType.GarbageCollected:if(details&&(details instanceof WebInspector.GarbageCollection)&&includeDetailsInMainTitle){switch(details.type){case WebInspector.GarbageCollection.Type.Partial:return WebInspector.UIString("Partial Garbage Collection");case WebInspector.GarbageCollection.Type.Full:return WebInspector.UIString("Full Garbage Collection");}}
return WebInspector.UIString("Garbage Collection");case WebInspector.ScriptTimelineRecord.EventType.TimerFired:if(details&&includeDetailsInMainTitle)
return WebInspector.UIString("Timer %d Fired").format(details);return WebInspector.UIString("Timer Fired");case WebInspector.ScriptTimelineRecord.EventType.TimerInstalled:if(details&&includeDetailsInMainTitle)
return WebInspector.UIString("Timer %d Installed").format(details.timerId);return WebInspector.UIString("Timer Installed");case WebInspector.ScriptTimelineRecord.EventType.TimerRemoved:if(details&&includeDetailsInMainTitle)
return WebInspector.UIString("Timer %d Removed").format(details);return WebInspector.UIString("Timer Removed");case WebInspector.ScriptTimelineRecord.EventType.AnimationFrameFired:if(details&&includeDetailsInMainTitle)
return WebInspector.UIString("Animation Frame %d Fired").format(details);return WebInspector.UIString("Animation Frame Fired");case WebInspector.ScriptTimelineRecord.EventType.AnimationFrameRequested:if(details&&includeDetailsInMainTitle)
return WebInspector.UIString("Animation Frame %d Requested").format(details);return WebInspector.UIString("Animation Frame Requested");case WebInspector.ScriptTimelineRecord.EventType.AnimationFrameCanceled:if(details&&includeDetailsInMainTitle)
return WebInspector.UIString("Animation Frame %d Canceled").format(details);return WebInspector.UIString("Animation Frame Canceled");}};WebInspector.ScriptTimelineRecord.TypeIdentifier="script-timeline-record";WebInspector.ScriptTimelineRecord.EventTypeCookieKey="script-timeline-record-event-type";WebInspector.ScriptTimelineRecord.DetailsCookieKey="script-timeline-record-details";WebInspector.SourceCodePosition=class SourceCodePosition extends WebInspector.Object
{constructor(lineNumber,columNumber)
{super();this._lineNumber=lineNumber||0;this._columnNumber=columNumber||0;} 
get lineNumber(){return this._lineNumber;}
get columnNumber(){return this._columnNumber;}};WebInspector.SourceCodeRevision=class SourceCodeRevision extends WebInspector.Revision
{constructor(sourceCode,content)
{super();this._sourceCode=sourceCode;this._content=content||"";} 
get sourceCode()
{return this._sourceCode;}
get content()
{return this._content;}
set content(content)
{content=content||"";if(this._content===content)
return;this._content=content;this._sourceCode.revisionContentDidChange(this);}
apply()
{this._sourceCode.currentRevision=this;}
revert()
{this._sourceCode.currentRevision=this._sourceCode.originalRevision;}
copy()
{return new WebInspector.SourceCodeRevision(this._sourceCode,this._content);}};WebInspector.SourceCodeSearchMatchObject=class SourceCodeSearchMatchObject extends WebInspector.Object
{constructor(sourceCode,lineText,searchTerm,textRange)
{super();this._sourceCode=sourceCode;this._lineText=lineText;this._searchTerm=searchTerm;this._sourceCodeTextRange=sourceCode.createSourceCodeTextRange(textRange);} 
get sourceCode(){return this._sourceCode;}
get title(){return this._lineText;}
get searchTerm(){return this._searchTerm;}
get sourceCodeTextRange(){return this._sourceCodeTextRange;}
get className()
{return"source-code-match";}
saveIdentityToCookie(cookie)
{if(this._sourceCode.url)
cookie[WebInspector.SourceCodeSearchMatchObject.URLCookieKey]=this._sourceCode.url.hash;var textRange=this._sourceCodeTextRange.textRange;cookie[WebInspector.SourceCodeSearchMatchObject.TextRangeKey]=[textRange.startLine,textRange.startColumn,textRange.endLine,textRange.endColumn].join();}};WebInspector.SourceCodeSearchMatchObject.TypeIdentifier="source-code-search-match-object";WebInspector.SourceCodeSearchMatchObject.URLCookieKey="source-code-url";WebInspector.SourceCodeSearchMatchObject.TextRangeKey="text-range";WebInspector.SourceCodeTextRange=class SourceCodeTextRange extends WebInspector.Object
{constructor(sourceCode){super();this._sourceCode=sourceCode;if(arguments.length===2){var textRange=arguments[1];this._startLocation=sourceCode.createSourceCodeLocation(textRange.startLine,textRange.startColumn);this._endLocation=sourceCode.createSourceCodeLocation(textRange.endLine,textRange.endColumn);}else{this._startLocation=arguments[1];this._endLocation=arguments[2];}
this._startLocation.addEventListener(WebInspector.SourceCodeLocation.Event.LocationChanged,this._sourceCodeLocationChanged,this);this._endLocation.addEventListener(WebInspector.SourceCodeLocation.Event.LocationChanged,this._sourceCodeLocationChanged,this);} 
get sourceCode()
{return this._sourceCode;}
get textRange()
{var startLine=this._startLocation.lineNumber;var startColumn=this._startLocation.columnNumber;var endLine=this._endLocation.lineNumber;var endColumn=this._endLocation.columnNumber;return new WebInspector.TextRange(startLine,startColumn,endLine,endColumn);}
get formattedTextRange()
{var startLine=this._startLocation.formattedLineNumber;var startColumn=this._startLocation.formattedColumnNumber;var endLine=this._endLocation.formattedLineNumber;var endColumn=this._endLocation.formattedColumnNumber;return new WebInspector.TextRange(startLine,startColumn,endLine,endColumn);}

get displaySourceCode()
{if(!this._startAndEndLocationsInSameMappedResource())
return this._sourceCode;return this._startLocation.displaySourceCode;}
get displayTextRange()
{if(!this._startAndEndLocationsInSameMappedResource())
return this.formattedTextRange;var startLine=this._startLocation.displayLineNumber;var startColumn=this._startLocation.displayColumnNumber;var endLine=this._endLocation.displayLineNumber;var endColumn=this._endLocation.displayColumnNumber;return new WebInspector.TextRange(startLine,startColumn,endLine,endColumn);}
get synthesizedTextValue()
{return this._sourceCode.url+":"+(this._startLocation.lineNumber+1);} 
_startAndEndLocationsInSameMappedResource()
{return this._startLocation.hasMappedLocation()&&this._endLocation.hasMappedLocation()&&this._startLocation.displaySourceCode===this._endLocation.displaySourceCode;}
_sourceCodeLocationChanged(event)
{this.dispatchEventToListeners(WebInspector.SourceCodeLocation.Event.RangeChanged);}};WebInspector.SourceCodeTextRange.Event={RangeChanged:"source-code-text-range-range-changed"};WebInspector.SourceCodeTimeline=class SourceCodeTimeline extends WebInspector.Timeline
{constructor(sourceCode,sourceCodeLocation,recordType,recordEventType)
{super();this._sourceCode=sourceCode;this._sourceCodeLocation=sourceCodeLocation||null;this._recordType=recordType;this._recordEventType=recordEventType||null;} 
get sourceCode(){return this._sourceCode;}
get sourceCodeLocation(){return this._sourceCodeLocation;}
get recordType(){return this._recordType;}
get recordEventType(){return this._recordEventType;}
saveIdentityToCookie(cookie)
{cookie[WebInspector.SourceCodeTimeline.SourceCodeURLCookieKey]=this._sourceCode.url?this._sourceCode.url.hash:null;cookie[WebInspector.SourceCodeTimeline.SourceCodeLocationLineCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.lineNumber:null;cookie[WebInspector.SourceCodeTimeline.SourceCodeLocationColumnCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.columnNumber:null;cookie[WebInspector.SourceCodeTimeline.RecordTypeCookieKey]=this._recordType||null;cookie[WebInspector.SourceCodeTimeline.RecordEventTypeCookieKey]=this._recordEventType||null;}};WebInspector.SourceCodeTimeline.TypeIdentifier="source-code-timeline";WebInspector.SourceCodeTimeline.SourceCodeURLCookieKey="source-code-timeline-source-code-url";WebInspector.SourceCodeTimeline.SourceCodeLocationLineCookieKey="source-code-timeline-source-code-location-line";WebInspector.SourceCodeTimeline.SourceCodeLocationColumnCookieKey="source-code-timeline-source-code-location-column";WebInspector.SourceCodeTimeline.SourceCodeURLCookieKey="source-code-timeline-source-code-url";WebInspector.SourceCodeTimeline.RecordTypeCookieKey="source-code-timeline-record-type";WebInspector.SourceCodeTimeline.RecordEventTypeCookieKey="source-code-timeline-record-event-type";WebInspector.SourceMap=class SourceMap extends WebInspector.Object
{constructor(sourceMappingURL,payload,originalSourceCode)
{super();if(!WebInspector.SourceMap._base64Map){var base64Digits="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";WebInspector.SourceMap._base64Map={};for(var i=0;i<base64Digits.length;++i)
WebInspector.SourceMap._base64Map[base64Digits.charAt(i)]=i;}
this._originalSourceCode=originalSourceCode||null;this._sourceMapResources={};this._sourceMapResourcesList=[];this._sourceMappingURL=sourceMappingURL;this._reverseMappingsBySourceURL={};this._mappings=[];this._sources={};this._sourceRoot=null;this._sourceContentByURL={};this._parseMappingPayload(payload);} 
get originalSourceCode()
{return this._originalSourceCode;}
get sourceMappingBasePathURLComponents()
{if(this._sourceMappingURLBasePathComponents)
return this._sourceMappingURLBasePathComponents;if(this._sourceRoot){var baseURLPath=absoluteURL(this._sourceRoot,this._sourceMappingURL);if(baseURLPath){var urlComponents=parseURL(baseURLPath);if(!/\/$/.test(urlComponents.path))
urlComponents.path+="/";this._sourceMappingURLBasePathComponents=urlComponents;return this._sourceMappingURLBasePathComponents;}}
var urlComponents=parseURL(this._sourceMappingURL);if(!urlComponents.path)
urlComponents.path=this._sourceMappingURL||"";urlComponents.path=urlComponents.path.substr(0,urlComponents.path.lastIndexOf(urlComponents.lastPathComponent));urlComponents.lastPathComponent=null;this._sourceMappingURLBasePathComponents=urlComponents;return this._sourceMappingURLBasePathComponents;}
get resources()
{return this._sourceMapResourcesList;}
addResource(resource)
{this._sourceMapResources[resource.url]=resource;this._sourceMapResourcesList.push(resource);}
resourceForURL(url)
{return this._sourceMapResources[url];}
sources()
{return Object.keys(this._sources);}
sourceContent(sourceURL)
{return this._sourceContentByURL[sourceURL];}
_parseMappingPayload(mappingPayload)
{if(mappingPayload.sections)
this._parseSections(mappingPayload.sections);else
this._parseMap(mappingPayload,0,0);}
_parseSections(sections)
{for(var i=0;i<sections.length;++i){var section=sections[i];this._parseMap(section.map,section.offset.line,section.offset.column);}}
findEntry(lineNumber,columnNumber)
{var first=0;var count=this._mappings.length;while(count>1){var step=count>>1;var middle=first+step;var mapping=this._mappings[middle];if(lineNumber<mapping[0]||(lineNumber===mapping[0]&&columnNumber<mapping[1]))
count=step;else{first=middle;count-=step;}}
var entry=this._mappings[first];if(!first&&entry&&(lineNumber<entry[0]||(lineNumber===entry[0]&&columnNumber<entry[1])))
return null;return entry;}
findEntryReversed(sourceURL,lineNumber)
{var mappings=this._reverseMappingsBySourceURL[sourceURL];for(;lineNumber<mappings.length;++lineNumber){var mapping=mappings[lineNumber];if(mapping)
return mapping;}
return this._mappings[0];}
_parseMap(map,lineNumber,columnNumber)
{var sourceIndex=0;var sourceLineNumber=0;var sourceColumnNumber=0;var nameIndex=0;var sources=[];var originalToCanonicalURLMap={};for(var i=0;i<map.sources.length;++i){var originalSourceURL=map.sources[i];var href=originalSourceURL;if(map.sourceRoot&&href.charAt(0)!=="/")
href=map.sourceRoot.replace(/\/+$/,"")+"/"+href;var url=absoluteURL(href,this._sourceMappingURL)||href;originalToCanonicalURLMap[originalSourceURL]=url;sources.push(url);this._sources[url]=true;if(map.sourcesContent&&map.sourcesContent[i])
this._sourceContentByURL[url]=map.sourcesContent[i];}
this._sourceRoot=map.sourceRoot||null;var stringCharIterator=new WebInspector.SourceMap.StringCharIterator(map.mappings);var sourceURL=sources[sourceIndex];while(true){if(stringCharIterator.peek()===",")
stringCharIterator.next();else{while(stringCharIterator.peek()===";"){lineNumber+=1;columnNumber=0;stringCharIterator.next();}
if(!stringCharIterator.hasNext())
break;}
columnNumber+=this._decodeVLQ(stringCharIterator);if(this._isSeparator(stringCharIterator.peek())){this._mappings.push([lineNumber,columnNumber]);continue;}
var sourceIndexDelta=this._decodeVLQ(stringCharIterator);if(sourceIndexDelta){sourceIndex+=sourceIndexDelta;sourceURL=sources[sourceIndex];}
sourceLineNumber+=this._decodeVLQ(stringCharIterator);sourceColumnNumber+=this._decodeVLQ(stringCharIterator);if(!this._isSeparator(stringCharIterator.peek()))
nameIndex+=this._decodeVLQ(stringCharIterator);this._mappings.push([lineNumber,columnNumber,sourceURL,sourceLineNumber,sourceColumnNumber]);}
for(var i=0;i<this._mappings.length;++i){var mapping=this._mappings[i];var url=mapping[2];if(!url)
continue;if(!this._reverseMappingsBySourceURL[url])
this._reverseMappingsBySourceURL[url]=[];var reverseMappings=this._reverseMappingsBySourceURL[url];var sourceLine=mapping[3];if(!reverseMappings[sourceLine])
reverseMappings[sourceLine]=[mapping[0],mapping[1]];}}
_isSeparator(char)
{return char===","||char===";";}
_decodeVLQ(stringCharIterator)
{var result=0;var shift=0;do{var digit=WebInspector.SourceMap._base64Map[stringCharIterator.next()];result+=(digit&WebInspector.SourceMap.VLQ_BASE_MASK)<<shift;shift+=WebInspector.SourceMap.VLQ_BASE_SHIFT;}while(digit&WebInspector.SourceMap.VLQ_CONTINUATION_MASK);var negative=result&1;result>>=1;return negative?-result:result;}};WebInspector.SourceMap.VLQ_BASE_SHIFT=5;WebInspector.SourceMap.VLQ_BASE_MASK=(1<<5)-1;WebInspector.SourceMap.VLQ_CONTINUATION_MASK=1<<5;WebInspector.SourceMap.StringCharIterator=class StringCharIterator
{constructor(string)
{this._string=string;this._position=0;}
next()
{return this._string.charAt(this._position++);}
peek()
{return this._string.charAt(this._position);}
hasNext()
{return this._position<this._string.length;}};WebInspector.SourceMapResource=class SourceMapResource extends WebInspector.Resource
{constructor(url,sourceMap)
{super(url,null);this._sourceMap=sourceMap;var inheritedMIMEType=this._sourceMap.originalSourceCode instanceof WebInspector.Resource?this._sourceMap.originalSourceCode.syntheticMIMEType:null;var fileExtension=WebInspector.fileExtensionForURL(url);var fileExtensionMIMEType=WebInspector.mimeTypeForFileExtension(fileExtension,true);
this._mimeType=fileExtensionMIMEType||inheritedMIMEType||"text/javascript";this._type=WebInspector.Resource.typeFromMIMEType(this._mimeType);this.markAsFinished();} 
get sourceMap()
{return this._sourceMap;}
get sourceMapDisplaySubpath()
{var sourceMappingBasePathURLComponents=this._sourceMap.sourceMappingBasePathURLComponents;var resourceURLComponents=this.urlComponents;if(!resourceURLComponents.path)
resourceURLComponents.path=this.url;if(resourceURLComponents.scheme!==sourceMappingBasePathURLComponents.scheme||resourceURLComponents.host!==sourceMappingBasePathURLComponents.host)
return resourceURLComponents.host+(resourceURLComponents.port?(":"+resourceURLComponents.port):"")+resourceURLComponents.path;if(!resourceURLComponents.path.startsWith(sourceMappingBasePathURLComponents.path))
return relativePath(resourceURLComponents.path,sourceMappingBasePathURLComponents.path);return resourceURLComponents.path.substring(sourceMappingBasePathURLComponents.path.length,resourceURLComponents.length);}
requestContentFromBackend(callback)
{this.revertMarkAsFinished();var inlineContent=this._sourceMap.sourceContent(this.url);if(inlineContent){return sourceMapResourceLoaded.call(this,{content:inlineContent,mimeType:this.mimeType,statusCode:200});}
function sourceMapResourceNotAvailable(error,content,mimeType,statusCode)
{this.markAsFailed();return Promise.resolve({error:WebInspector.UIString("An error occurred trying to load the resource."),content,mimeType,statusCode});}
function sourceMapResourceLoadError(error)
{console.error(error||"There was an unknown error calling NetworkAgent.loadResource.");this.markAsFailed();return Promise.resolve({error:WebInspector.UIString("An error occurred trying to load the resource.")});}
function sourceMapResourceLoaded(parameters)
{var{error,content,mimeType,statusCode}=parameters;var base64encoded=false;if(statusCode>=400||error)
return sourceMapResourceNotAvailable(error,content,mimeType,statusCode);this.markAsFinished();return Promise.resolve({content,mimeType,base64encoded,statusCode});}
if(!window.NetworkAgent||!NetworkAgent.loadResource)
return sourceMapResourceLoadError.call(this);var frameIdentifier=null;if(this._sourceMap.originalSourceCode instanceof WebInspector.Resource&&this._sourceMap.originalSourceCode.parentFrame)
frameIdentifier=this._sourceMap.originalSourceCode.parentFrame.id;if(!frameIdentifier)
frameIdentifier=WebInspector.frameResourceManager.mainFrame.id;return NetworkAgent.loadResource(frameIdentifier,this.url).then(sourceMapResourceLoaded.bind(this)).catch(sourceMapResourceLoadError.bind(this));}
createSourceCodeLocation(lineNumber,columnNumber)
{var entry=this._sourceMap.findEntryReversed(this.url,lineNumber);var rawLineNumber=entry[0];var rawColumnNumber=entry[1];var originalSourceCode=this._sourceMap.originalSourceCode;if(originalSourceCode instanceof WebInspector.Script){if(rawLineNumber===0)
rawColumnNumber+=originalSourceCode.range.startColumn;rawLineNumber+=originalSourceCode.range.startLine;}
var location=originalSourceCode.createSourceCodeLocation(rawLineNumber,rawColumnNumber);location._setMappedLocation(this,lineNumber,columnNumber);return location;}
createSourceCodeTextRange(textRange)
{var startSourceCodeLocation=this.createSourceCodeLocation(textRange.startLine,textRange.startColumn);var endSourceCodeLocation=this.createSourceCodeLocation(textRange.endLine,textRange.endColumn);return new WebInspector.SourceCodeTextRange(this._sourceMap.originalSourceCode,startSourceCodeLocation,endSourceCodeLocation);}};WebInspector.StackTrace=class StackTrace extends WebInspector.Object
{constructor(callFrames,topCallFrameIsBoundary,truncated,parentStackTrace)
{super();this._callFrames=callFrames;this._topCallFrameIsBoundary=topCallFrameIsBoundary||false;this._truncated=truncated||false;this._parentStackTrace=parentStackTrace||null;} 
static fromPayload(target,payload)
{let result=null;let previousStackTrace=null;while(payload){let callFrames=payload.callFrames.map((x)=>WebInspector.CallFrame.fromPayload(target,x));let stackTrace=new WebInspector.StackTrace(callFrames,payload.topCallFrameIsBoundary,payload.truncated);if(!result)
result=stackTrace;if(previousStackTrace)
previousStackTrace._parentStackTrace=stackTrace;previousStackTrace=stackTrace;payload=payload.parentStackTrace;}
return result;}
static fromString(target,stack)
{let callFrames=WebInspector.StackTrace._parseStackTrace(stack);return WebInspector.StackTrace.fromPayload(target,{callFrames});}
static isLikelyStackTrace(stack)
{const smallestPossibleStackTraceLength="http://a.bc/:9:1".length;if(stack.length<smallestPossibleStackTraceLength.length*2)
return false;const approximateStackLengthOf50Items=5000;if(stack.length>approximateStackLengthOf50Items)
return false;if(/^[^a-z$_]/i.test(stack[0]))
return false;const reasonablyLongLineLength=500;const reasonablyLongNativeMethodLength=120;const stackTraceLine=`(.{1,${reasonablyLongLineLength}}:\\d+:\\d+|eval code|.{1,${reasonablyLongNativeMethodLength}}@\\[native code\\])`;const stackTrace=new RegExp(`^${stackTraceLine}(\\n${stackTraceLine})*$`,"g");return stackTrace.test(stack);}
static _parseStackTrace(stack)
{var lines=stack.split(/\n/g);var result=[];for(var line of lines){var functionName="";var url="";var lineNumber=0;var columnNumber=0;var atIndex=line.indexOf("@");if(atIndex!==-1){functionName=line.slice(0,atIndex);({url,lineNumber,columnNumber}=WebInspector.StackTrace._parseLocation(line.slice(atIndex+1)));}else if(line.includes("/"))
({url,lineNumber,columnNumber}=WebInspector.StackTrace._parseLocation(line));else
functionName=line;result.push({functionName,url,lineNumber,columnNumber});}
return result;}
static _parseLocation(locationString)
{var result={url:"",lineNumber:0,columnNumber:0};var locationRegEx=/(.+?)(?::(\d+)(?::(\d+))?)?$/;var matched=locationString.match(locationRegEx);if(!matched)
return result;result.url=matched[1];if(matched[2])
result.lineNumber=parseInt(matched[2]);if(matched[3])
result.columnNumber=parseInt(matched[3]);return result;} 
get callFrames()
{return this._callFrames;}
get firstNonNativeCallFrame()
{for(let frame of this._callFrames){if(!frame.nativeCode)
return frame;}
return null;}
get firstNonNativeNonAnonymousCallFrame()
{for(let frame of this._callFrames){if(frame.nativeCode)
continue;if(frame.sourceCodeLocation){let sourceCode=frame.sourceCodeLocation.sourceCode;if(sourceCode instanceof WebInspector.Script&&sourceCode.anonymous)
continue;}
return frame;}
return null;}
get topCallFrameIsBoundary(){return this._topCallFrameIsBoundary;}
get truncated(){return this._truncated;}
get parentStackTrace(){return this._parentStackTrace;}};WebInspector.StructureDescription=class StructureDescription extends WebInspector.Object
{constructor(fields,optionalFields,constructorName,prototypeStructure,imprecise)
{super();this._fields=fields||null;this._optionalFields=optionalFields||null;this._constructorName=constructorName||"";this._prototypeStructure=prototypeStructure||null;this._imprecise=imprecise||false;}

static fromPayload(payload)
{if(payload.prototypeStructure)
payload.prototypeStructure=WebInspector.StructureDescription.fromPayload(payload.prototypeStructure);return new WebInspector.StructureDescription(payload.fields,payload.optionalFields,payload.constructorName,payload.prototypeStructure,payload.imprecise);} 
get fields(){return this._fields;}
get optionalFields(){return this._optionalFields;}
get constructorName(){return this._constructorName;}
get prototypeStructure(){return this._prototypeStructure;}
get imprecise(){return this._imprecise;}};WebInspector.TextMarker=class TextMarker extends WebInspector.Object
{constructor(codeMirrorTextMarker,type)
{super();this._codeMirrorTextMarker=codeMirrorTextMarker;codeMirrorTextMarker.__webInspectorTextMarker=this;this._type=type||WebInspector.TextMarker.Type.Plain;} 
static textMarkerForCodeMirrorTextMarker(codeMirrorTextMarker)
{return codeMirrorTextMarker.__webInspectorTextMarker||new WebInspector.TextMarker(codeMirrorTextMarker);} 
get codeMirrorTextMarker()
{return this._codeMirrorTextMarker;}
get type()
{return this._type;}
get range()
{var range=this._codeMirrorTextMarker.find();if(!range)
return null;return new WebInspector.TextRange(range.from.line,range.from.ch,range.to.line,range.to.ch);}
get rects()
{var range=this._codeMirrorTextMarker.find();if(!range)
return WebInspector.Rect.ZERO_RECT;return this._codeMirrorTextMarker.doc.cm.rectsForRange({start:range.from,end:range.to});}
clear()
{this._codeMirrorTextMarker.clear();}};WebInspector.TextMarker.Type={Color:"text-marker-type-color",Gradient:"text-marker-type-gradient",Plain:"text-marker-type-plain",CubicBezier:"text-marker-type-cubic-bezier",Spring:"text-marker-type-spring",Variable:"text-marker-type-variable",};WebInspector.TextRange=class TextRange extends WebInspector.Object
{constructor(startLineOrStartOffset,startColumnOrEndOffset,endLine,endColumn)
{super();if(arguments.length===4){this._startLine=typeof startLineOrStartOffset==="number"?startLineOrStartOffset:NaN;this._startColumn=typeof startColumnOrEndOffset==="number"?startColumnOrEndOffset:NaN;this._endLine=typeof endLine==="number"?endLine:NaN;this._endColumn=typeof endColumn==="number"?endColumn:NaN;this._startOffset=NaN;this._endOffset=NaN;}else if(arguments.length===2){this._startOffset=typeof startLineOrStartOffset==="number"?startLineOrStartOffset:NaN;this._endOffset=typeof startColumnOrEndOffset==="number"?startColumnOrEndOffset:NaN;this._startLine=NaN;this._startColumn=NaN;this._endLine=NaN;this._endColumn=NaN;}} 
get startLine(){return this._startLine;}
get startColumn(){return this._startColumn;}
get endLine(){return this._endLine;}
get endColumn(){return this._endColumn;}
get startOffset(){return this._startOffset;}
get endOffset(){return this._endOffset;}
startPosition()
{return new WebInspector.SourceCodePosition(this._startLine,this._startColumn);}
endPosition()
{return new WebInspector.SourceCodePosition(this._endLine,this._endColumn);}
resolveOffsets(text)
{if(typeof text!=="string")
return;if(isNaN(this._startLine)||isNaN(this._startColumn)||isNaN(this._endLine)||isNaN(this._endColumn))
return;var lastNewLineOffset=0;for(var i=0;i<this._startLine;++i)
lastNewLineOffset=text.indexOf("\n",lastNewLineOffset)+1;this._startOffset=lastNewLineOffset+this._startColumn;for(var i=this._startLine;i<this._endLine;++i)
lastNewLineOffset=text.indexOf("\n",lastNewLineOffset)+1;this._endOffset=lastNewLineOffset+this._endColumn;}
contains(line,column)
{if(line<this._startLine||line>this._endLine)
return false;if(line===this._startLine&&column<this._startColumn)
return false;if(line===this._endLine&&column>this._endColumn)
return false;return true;}};WebInspector.TimelineMarker=class TimelineMarker extends WebInspector.Object
{constructor(time,type,details)
{super();this._time=time||0;this._type=type;this._details=details||null;} 
get time()
{return this._time;}
set time(x)
{x=x||0;if(this._time===x)
return;this._time=x;this.dispatchEventToListeners(WebInspector.TimelineMarker.Event.TimeChanged);}
get type()
{return this._type;}
get details()
{return this._details;}};WebInspector.TimelineMarker.Event={TimeChanged:"timeline-marker-time-changed"};WebInspector.TimelineMarker.Type={CurrentTime:"current-time",LoadEvent:"load-event",DOMContentEvent:"dom-content-event",TimeStamp:"timestamp"};WebInspector.TimelineRecording=class TimelineRecording extends WebInspector.Object
{constructor(identifier,displayName,instruments)
{super();this._identifier=identifier;this._timelines=new Map;this._displayName=displayName;this._capturing=false;this._readonly=false;this._instruments=instruments||[];this._topDownCallingContextTree=new WebInspector.CallingContextTree(WebInspector.CallingContextTree.Type.TopDown);this._bottomUpCallingContextTree=new WebInspector.CallingContextTree(WebInspector.CallingContextTree.Type.BottomUp);this._topFunctionsTopDownCallingContextTree=new WebInspector.CallingContextTree(WebInspector.CallingContextTree.Type.TopFunctionsTopDown);this._topFunctionsBottomUpCallingContextTree=new WebInspector.CallingContextTree(WebInspector.CallingContextTree.Type.TopFunctionsBottomUp);for(let type of WebInspector.TimelineManager.availableTimelineTypes()){let timeline=WebInspector.Timeline.create(type);this._timelines.set(type,timeline);timeline.addEventListener(WebInspector.Timeline.Event.TimesUpdated,this._timelineTimesUpdated,this);}
this._legacyFirstRecordedTimestamp=NaN;this.reset(true);} 
static sourceCodeTimelinesSupported()
{return WebInspector.debuggableType===WebInspector.DebuggableType.Web;} 
get displayName(){return this._displayName;}
get identifier(){return this._identifier;}
get timelines(){return this._timelines;}
get instruments(){return this._instruments;}
get readonly(){return this._readonly;}
get startTime(){return this._startTime;}
get endTime(){return this._endTime;}
get topDownCallingContextTree(){return this._topDownCallingContextTree;}
get bottomUpCallingContextTree(){return this._bottomUpCallingContextTree;}
get topFunctionsTopDownCallingContextTree(){return this._topFunctionsTopDownCallingContextTree;}
get topFunctionsBottomUpCallingContextTree(){return this._topFunctionsBottomUpCallingContextTree;}
start(initiatedByBackend)
{this._capturing=true;for(let instrument of this._instruments)
instrument.startInstrumentation(initiatedByBackend);}
stop(initiatedByBackend)
{this._capturing=false;for(let instrument of this._instruments)
instrument.stopInstrumentation(initiatedByBackend);}
saveIdentityToCookie()
{
}
isEmpty()
{for(var timeline of this._timelines.values()){if(timeline.records.length)
return false;}
return true;}
unloaded()
{this._readonly=true;this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.Unloaded);}
reset(suppressEvents)
{this._sourceCodeTimelinesMap=new Map;this._eventMarkers=[];this._startTime=NaN;this._endTime=NaN;this._discontinuities=[];this._topDownCallingContextTree.reset();this._bottomUpCallingContextTree.reset();this._topFunctionsTopDownCallingContextTree.reset();this._topFunctionsBottomUpCallingContextTree.reset();for(var timeline of this._timelines.values())
timeline.reset(suppressEvents);WebInspector.RenderingFrameTimelineRecord.resetFrameIndex();if(!suppressEvents){this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.Reset);this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.TimesUpdated);}}
sourceCodeTimelinesForSourceCode(sourceCode)
{var timelines=this._sourceCodeTimelinesMap.get(sourceCode);if(!timelines)
return[];return[...timelines.values()];}
timelineForInstrument(instrument)
{return this._timelines.get(instrument.timelineRecordType);}
instrumentForTimeline(timeline)
{return this._instruments.find((instrument)=>instrument.timelineRecordType===timeline.type);}
timelineForRecordType(recordType)
{return this._timelines.get(recordType);}
addInstrument(instrument)
{this._instruments.push(instrument);this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.InstrumentAdded,{instrument});}
removeInstrument(instrument)
{this._instruments.remove(instrument);this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.InstrumentRemoved,{instrument});}
addEventMarker(marker)
{if(!this._capturing)
return;this._eventMarkers.push(marker);this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.MarkerAdded,{marker});}
addRecord(record)
{var timeline=this._timelines.get(record.type);if(!timeline)
return;timeline.addRecord(record);if(record.type===WebInspector.TimelineRecord.Type.Network||record.type===WebInspector.TimelineRecord.Type.RenderingFrame||record.type===WebInspector.TimelineRecord.Type.Memory||record.type===WebInspector.TimelineRecord.Type.HeapAllocations)
return;if(!WebInspector.TimelineRecording.sourceCodeTimelinesSupported())
return;var activeMainResource=WebInspector.frameResourceManager.mainFrame.provisionalMainResource||WebInspector.frameResourceManager.mainFrame.mainResource;var sourceCode=record.sourceCodeLocation?record.sourceCodeLocation.sourceCode:activeMainResource;var sourceCodeTimelines=this._sourceCodeTimelinesMap.get(sourceCode);if(!sourceCodeTimelines){sourceCodeTimelines=new Map;this._sourceCodeTimelinesMap.set(sourceCode,sourceCodeTimelines);}
var newTimeline=false;var key=this._keyForRecord(record);var sourceCodeTimeline=sourceCodeTimelines.get(key);if(!sourceCodeTimeline){sourceCodeTimeline=new WebInspector.SourceCodeTimeline(sourceCode,record.sourceCodeLocation,record.type,record.eventType);sourceCodeTimelines.set(key,sourceCodeTimeline);newTimeline=true;}
sourceCodeTimeline.addRecord(record);if(newTimeline)
this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.SourceCodeTimelineAdded,{sourceCodeTimeline});}
addMemoryPressureEvent(memoryPressureEvent)
{let memoryTimeline=this._timelines.get(WebInspector.TimelineRecord.Type.Memory);if(!memoryTimeline)
return;memoryTimeline.addMemoryPressureEvent(memoryPressureEvent);}
addDiscontinuity(startTime,endTime)
{this._discontinuities.push({startTime,endTime});}
discontinuitiesInTimeRange(startTime,endTime)
{return this._discontinuities.filter((item)=>item.startTime<endTime&&item.endTime>startTime);}
addScriptInstrumentForProgrammaticCapture()
{for(let instrument of this._instruments){if(instrument instanceof WebInspector.ScriptInstrument)
return;}
this.addInstrument(new WebInspector.ScriptInstrument);let instrumentTypes=this._instruments.map((instrument)=>instrument.timelineRecordType);WebInspector.timelineManager.enabledTimelineTypes=instrumentTypes;}
computeElapsedTime(timestamp)
{if(!timestamp||isNaN(timestamp))
return NaN;
if(WebInspector.TimelineRecording.isLegacy===undefined)
WebInspector.TimelineRecording.isLegacy=timestamp>WebInspector.TimelineRecording.TimestampThresholdForLegacyRecordConversion;if(!WebInspector.TimelineRecording.isLegacy)
return timestamp;
if(timestamp<WebInspector.TimelineRecording.TimestampThresholdForLegacyAssumedMilliseconds)
timestamp*=1000;if(isNaN(this._legacyFirstRecordedTimestamp))
this._legacyFirstRecordedTimestamp=timestamp;return(timestamp-this._legacyFirstRecordedTimestamp)/1000.0;}
setLegacyBaseTimestamp(timestamp)
{if(timestamp<WebInspector.TimelineRecording.TimestampThresholdForLegacyAssumedMilliseconds)
timestamp*=1000;this._legacyFirstRecordedTimestamp=timestamp;}
initializeTimeBoundsIfNecessary(timestamp)
{if(isNaN(this._startTime)){this._startTime=timestamp;this._endTime=timestamp;this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.TimesUpdated);}} 
_keyForRecord(record)
{var key=record.type;if(record instanceof WebInspector.ScriptTimelineRecord||record instanceof WebInspector.LayoutTimelineRecord)
key+=":"+record.eventType;if(record instanceof WebInspector.ScriptTimelineRecord&&record.eventType===WebInspector.ScriptTimelineRecord.EventType.EventDispatched)
key+=":"+record.details;if(record.sourceCodeLocation)
key+=":"+record.sourceCodeLocation.lineNumber+":"+record.sourceCodeLocation.columnNumber;return key;}
_timelineTimesUpdated(event)
{var timeline=event.target;var changed=false;if(isNaN(this._startTime)||timeline.startTime<this._startTime){this._startTime=timeline.startTime;changed=true;}
if(isNaN(this._endTime)||this._endTime<timeline.endTime){this._endTime=timeline.endTime;changed=true;}
if(changed)
this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.TimesUpdated);}};WebInspector.TimelineRecording.Event={Reset:"timeline-recording-reset",Unloaded:"timeline-recording-unloaded",SourceCodeTimelineAdded:"timeline-recording-source-code-timeline-added",InstrumentAdded:"timeline-recording-instrument-added",InstrumentRemoved:"timeline-recording-instrument-removed",TimesUpdated:"timeline-recording-times-updated",MarkerAdded:"timeline-recording-marker-added",};WebInspector.TimelineRecording.isLegacy=undefined;WebInspector.TimelineRecording.TimestampThresholdForLegacyRecordConversion=10000000;WebInspector.TimelineRecording.TimestampThresholdForLegacyAssumedMilliseconds=1420099200000;WebInspector.TypeDescription=class TypeDescription extends WebInspector.Object
{constructor(leastCommonAncestor,typeSet,structures,valid,truncated)
{super();this._leastCommonAncestor=leastCommonAncestor||null;this._typeSet=typeSet||null;this._structures=structures||null;this._valid=valid||false;this._truncated=truncated||false;}

static fromPayload(payload)
{var typeSet=undefined;if(payload.typeSet)
typeSet=WebInspector.TypeSet.fromPayload(payload.typeSet);var structures=undefined;if(payload.structures)
structures=payload.structures.map(WebInspector.StructureDescription.fromPayload);return new WebInspector.TypeDescription(payload.leastCommonAncestor,typeSet,structures,payload.isValid,payload.isTruncated);} 
get leastCommonAncestor(){return this._leastCommonAncestor;}
get typeSet(){return this._typeSet;}
get structures(){return this._structures;}
get valid(){return this._valid;}
get truncated(){return this._truncated;}};WebInspector.TypeSet=class TypeSet extends WebInspector.Object
{constructor(typeSet)
{super();var bitString=0x0;if(typeSet.isFunction)
bitString|=WebInspector.TypeSet.TypeBit.Function;if(typeSet.isUndefined)
bitString|=WebInspector.TypeSet.TypeBit.Undefined;if(typeSet.isNull)
bitString|=WebInspector.TypeSet.TypeBit.Null;if(typeSet.isBoolean)
bitString|=WebInspector.TypeSet.TypeBit.Boolean;if(typeSet.isInteger)
bitString|=WebInspector.TypeSet.TypeBit.Integer;if(typeSet.isNumber)
bitString|=WebInspector.TypeSet.TypeBit.Number;if(typeSet.isString)
bitString|=WebInspector.TypeSet.TypeBit.String;if(typeSet.isObject)
bitString|=WebInspector.TypeSet.TypeBit.Object;if(typeSet.isSymbol)
bitString|=WebInspector.TypeSet.TypeBit.Symbol;this._typeSet=typeSet;this._bitString=bitString;this._primitiveTypeNames=null;} 
static fromPayload(payload)
{return new WebInspector.TypeSet(payload);} 
isContainedIn(test)
{
 
return this._bitString&&(this._bitString&test)===this._bitString;}
get primitiveTypeNames()
{if(this._primitiveTypeNames)
return this._primitiveTypeNames;this._primitiveTypeNames=[];var typeSet=this._typeSet;if(typeSet.isUndefined)
this._primitiveTypeNames.push("Undefined");if(typeSet.isNull)
this._primitiveTypeNames.push("Null");if(typeSet.isBoolean)
this._primitiveTypeNames.push("Boolean");if(typeSet.isString)
this._primitiveTypeNames.push("String");if(typeSet.isSymbol)
this._primitiveTypeNames.push("Symbol");

if(typeSet.isNumber)
this._primitiveTypeNames.push("Number");else if(typeSet.isInteger)
this._primitiveTypeNames.push("Integer");return this._primitiveTypeNames;}};WebInspector.TypeSet.TypeBit={"Function":0x1,"Undefined":0x2,"Null":0x4,"Boolean":0x8,"Integer":0x10,"Number":0x20,"String":0x40,"Object":0x80,"Symbol":0x100};WebInspector.TypeSet.NullOrUndefinedTypeBits=WebInspector.TypeSet.TypeBit.Null|WebInspector.TypeSet.TypeBit.Undefined;WebInspector.WebSocketResource=class WebSocketResource extends WebInspector.Resource
{constructor(url,loaderIdentifier,targetId,requestIdentifier,requestHeaders,requestData,timestamp,walltime,requestSentTimestamp,initiatorSourceCodeLocation)
{const type=WebInspector.Resource.Type.WebSocket;const mimeType=null;const requestMethod="GET";super(url,mimeType,type,loaderIdentifier,targetId,requestIdentifier,requestMethod,requestHeaders,requestData,requestSentTimestamp,initiatorSourceCodeLocation);this._timestamp=timestamp;this._walltime=walltime;this._readyState=WebInspector.WebSocketResource.ReadyState.Connecting;this._frames=[];} 
get frames(){return this._frames;}
get walltime(){return this._walltime;}
get readyState()
{return this._readyState;}
set readyState(state)
{if(state===this._readyState)
return;let previousState=this._readyState;this._readyState=state;this.dispatchEventToListeners(WebInspector.WebSocketResource.Event.ReadyStateChanged,{previousState,state});}
addFrame(data,payloadLength,isOutgoing,opcode,timestamp,elapsedTime)
{let frameData;if(opcode===WebInspector.WebSocketResource.OpCodes.BinaryFrame)
frameData=null;else
frameData=data;let frame={data:frameData,isOutgoing,opcode,walltime:this._walltimeForWebSocketTimestamp(timestamp)};this._frames.push(frame);if(payloadLength===undefined)
payloadLength=new TextEncoder("utf-8").encode(data).length;this.increaseSize(payloadLength,elapsedTime);this.dispatchEventToListeners(WebInspector.WebSocketResource.Event.FrameAdded,frame);} 
_walltimeForWebSocketTimestamp(timestamp)
{return this._walltime+(timestamp-this._timestamp);}};WebInspector.WebSocketResource.Event={FrameAdded:Symbol("web-socket-frame-added"),ReadyStateChanged:Symbol("web-socket-resource-ready-state-changed"),};WebInspector.WebSocketResource.ReadyState={Closed:Symbol("closed"),Connecting:Symbol("connecting"),Open:Symbol("open"),};WebInspector.WebSocketResource.OpCodes={ContinuationFrame:0,TextFrame:1,BinaryFrame:2,ConnectionCloseFrame:8,PingFrame:9,PongFrame:10,};WebInspector.WrappedPromise=class WrappedPromise
{constructor(work)
{this._settled=false;this._promise=new Promise((resolve,reject)=>{this._resolveCallback=resolve;this._rejectCallback=reject;
if(work&&typeof work==="function")
return work(this.resolve.bind(this),this.reject.bind(this));});} 
get settled()
{return this._settled;}
get promise()
{return this._promise;}
resolve(value)
{if(this._settled)
throw new Error("Promise is already settled, cannot call resolve().");this._settled=true;this._resolveCallback(value);}
reject(value)
{if(this._settled)
throw new Error("Promise is already settled, cannot call reject().");this._settled=true;this._rejectCallback(value);}};WebInspector.XHRBreakpoint=class XHRBreakpoint extends WebInspector.Object
{constructor(type,url,disabled)
{super();this._type=type||WebInspector.XHRBreakpoint.Type.Text;this._url=url||"";this._disabled=disabled||false;} 
get type(){return this._type;}
get url(){return this._url;}
get disabled()
{return this._disabled;}
set disabled(disabled)
{if(this._disabled===disabled)
return;this._disabled=disabled;this.dispatchEventToListeners(WebInspector.XHRBreakpoint.Event.DisabledStateDidChange);}
get serializableInfo()
{let info={type:this._type,url:this._url};if(this._disabled)
info.disabled=true;return info;}
saveIdentityToCookie(cookie)
{cookie[WebInspector.XHRBreakpoint.URLCookieKey]=this._url;}};WebInspector.XHRBreakpoint.URLCookieKey="xhr-breakpoint-url";WebInspector.XHRBreakpoint.Event={DisabledStateDidChange:"xhr-breakpoint-disabled-state-did-change",ResolvedStateDidChange:"xhr-breakpoint-resolved-state-did-change",};WebInspector.XHRBreakpoint.Type={Text:"text",RegularExpression:"regex",};WebInspector.FormatterWorkerProxy=class FormatterWorkerProxy extends WebInspector.Object
{constructor()
{super();this._formatterWorker=new Worker("Workers/Formatter/FormatterWorker.js");this._formatterWorker.addEventListener("message",this._handleMessage.bind(this));this._nextCallId=1;this._callbacks=new Map;} 
static singleton()
{if(!FormatterWorkerProxy.instance)
FormatterWorkerProxy.instance=new FormatterWorkerProxy;return FormatterWorkerProxy.instance;} 
formatJavaScript(sourceText,isModule,indentString,includeSourceMapData)
{this.performAction("formatJavaScript",...arguments);} 
performAction(actionName)
{let callId=this._nextCallId++;let callback=arguments[arguments.length-1];let actionArguments=Array.prototype.slice.call(arguments,1,arguments.length-1);this._callbacks.set(callId,callback);this._postMessage({callId,actionName,actionArguments});} 
_postMessage()
{this._formatterWorker.postMessage(...arguments);}
_handleMessage(event)
{let data=event.data;if(data.callId){let callback=this._callbacks.get(data.callId);this._callbacks.delete(data.callId);callback(data.result);return;}
console.error("Unexpected FormatterWorker message",data);}};WebInspector.HeapSnapshotDiffProxy=class HeapSnapshotDiffProxy extends WebInspector.Object
{constructor(snapshotDiffObjectId,snapshot1,snapshot2,totalSize,totalObjectCount,categories)
{super();this._proxyObjectId=snapshotDiffObjectId;this._snapshot1=snapshot1;this._snapshot2=snapshot2;this._totalSize=totalSize;this._totalObjectCount=totalObjectCount;this._categories=Map.fromObject(categories);} 
static deserialize(objectId,serializedSnapshotDiff)
{let{snapshot1:serializedSnapshot1,snapshot2:serializedSnapshot2,totalSize,totalObjectCount,categories}=serializedSnapshotDiff;
let snapshot1=WebInspector.HeapSnapshotProxy.deserialize(objectId,serializedSnapshot1);let snapshot2=WebInspector.HeapSnapshotProxy.deserialize(objectId,serializedSnapshot2);return new WebInspector.HeapSnapshotDiffProxy(objectId,snapshot1,snapshot2,totalSize,totalObjectCount,categories);} 
get snapshot1(){return this._snapshot1;}
get snapshot2(){return this._snapshot2;}
get totalSize(){return this._totalSize;}
get totalObjectCount(){return this._totalObjectCount;}
get categories(){return this._categories;}
get invalid(){return this._snapshot1.invalid||this._snapshot2.invalid;}
updateForCollectionEvent(event)
{if(!event.data.affectedSnapshots.includes(this._snapshot2._identifier))
return;this.update(()=>{this.dispatchEventToListeners(WebInspector.HeapSnapshotProxy.Event.CollectedNodes,event.data);});}
allocationBucketCounts(bucketSizes,callback)
{WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"allocationBucketCounts",bucketSizes,callback);}
instancesWithClassName(className,callback)
{WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"instancesWithClassName",className,(serializedNodes)=>{callback(serializedNodes.map(WebInspector.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId)));});}
update(callback)
{WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"update",({liveSize,categories})=>{this._categories=Map.fromObject(categories);callback();});}
nodeWithIdentifier(nodeIdentifier,callback)
{WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"nodeWithIdentifier",nodeIdentifier,(serializedNode)=>{callback(WebInspector.HeapSnapshotNodeProxy.deserialize(this._proxyObjectId,serializedNode));});}};WebInspector.HeapSnapshotEdgeProxy=class HeapSnapshotEdgeProxy
{constructor(objectId,fromIdentifier,toIdentifier,type,data)
{this._proxyObjectId=objectId;this.fromIdentifier=fromIdentifier;this.toIdentifier=toIdentifier;this.type=type;this.data=data;this.from=null;this.to=null;}
isPrivateSymbol()
{if(WebInspector.isDebugUIEnabled())
return false;return typeof this.data==="string"&&this.data.startsWith("PrivateSymbol");} 
static deserialize(objectId,serializedEdge)
{let{from,to,type,data}=serializedEdge;return new WebInspector.HeapSnapshotEdgeProxy(objectId,from,to,type,data);}};WebInspector.HeapSnapshotEdgeProxy.EdgeType={Internal:"Internal",Property:"Property",Index:"Index",Variable:"Variable",};WebInspector.HeapSnapshotNodeProxy=class HeapSnapshotNodeProxy
{constructor(snapshotObjectId,identifier,className,size,retainedSize,internal,gcRoot,dead,dominatorNodeIdentifier,hasChildren)
{this._proxyObjectId=snapshotObjectId;this.id=identifier;this.className=className;this.size=size;this.retainedSize=retainedSize;this.internal=internal;this.gcRoot=gcRoot;this.dead=dead;this.dominatorNodeIdentifier=dominatorNodeIdentifier;this.hasChildren=hasChildren;} 
static deserialize(objectId,serializedNode)
{let{id,className,size,retainedSize,internal,gcRoot,dead,dominatorNodeIdentifier,hasChildren}=serializedNode;return new WebInspector.HeapSnapshotNodeProxy(objectId,id,className,size,retainedSize,internal,gcRoot,dead,dominatorNodeIdentifier,hasChildren);} 
shortestGCRootPath(callback)
{WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"shortestGCRootPath",this.id,(serializedPath)=>{let isNode=false;let path=serializedPath.map((component)=>{isNode=!isNode;if(isNode)
return WebInspector.HeapSnapshotNodeProxy.deserialize(this._proxyObjectId,component);return WebInspector.HeapSnapshotEdgeProxy.deserialize(this._proxyObjectId,component);});for(let i=1;i<path.length;i+=2){let edge=path[i];edge.from=path[i-1];edge.to=path[i+1];}
callback(path);});}
dominatedNodes(callback)
{WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"dominatedNodes",this.id,(serializedNodes)=>{callback(serializedNodes.map(WebInspector.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId)));});}
retainedNodes(callback)
{WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"retainedNodes",this.id,({retainedNodes:serializedNodes,edges:serializedEdges})=>{let deserializedNodes=serializedNodes.map(WebInspector.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId));let deserializedEdges=serializedEdges.map(WebInspector.HeapSnapshotEdgeProxy.deserialize.bind(null,this._proxyObjectId));callback(deserializedNodes,deserializedEdges);});}
retainers(callback)
{WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"retainers",this.id,({retainers:serializedNodes,edges:serializedEdges})=>{let deserializedNodes=serializedNodes.map(WebInspector.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId));let deserializedEdges=serializedEdges.map(WebInspector.HeapSnapshotEdgeProxy.deserialize.bind(null,this._proxyObjectId));callback(deserializedNodes,deserializedEdges);});}};WebInspector.HeapSnapshotProxy=class HeapSnapshotProxy extends WebInspector.Object
{constructor(snapshotObjectId,identifier,title,totalSize,totalObjectCount,liveSize,categories)
{super();this._proxyObjectId=snapshotObjectId;this._identifier=identifier;this._title=title;this._totalSize=totalSize;this._totalObjectCount=totalObjectCount;this._liveSize=liveSize;this._categories=Map.fromObject(categories);if(!WebInspector.HeapSnapshotProxy.ValidSnapshotProxies)
WebInspector.HeapSnapshotProxy.ValidSnapshotProxies=[];WebInspector.HeapSnapshotProxy.ValidSnapshotProxies.push(this);} 
static deserialize(objectId,serializedSnapshot)
{let{identifier,title,totalSize,totalObjectCount,liveSize,categories}=serializedSnapshot;return new WebInspector.HeapSnapshotProxy(objectId,identifier,title,totalSize,totalObjectCount,liveSize,categories);}
static invalidateSnapshotProxies()
{if(!WebInspector.HeapSnapshotProxy.ValidSnapshotProxies)
return;for(let snapshotProxy of WebInspector.HeapSnapshotProxy.ValidSnapshotProxies)
snapshotProxy._invalidate();WebInspector.HeapSnapshotProxy.ValidSnapshotProxies=null;} 
get proxyObjectId(){return this._proxyObjectId;}
get identifier(){return this._identifier;}
get title(){return this._title;}
get totalSize(){return this._totalSize;}
get totalObjectCount(){return this._totalObjectCount;}
get liveSize(){return this._liveSize;}
get categories(){return this._categories;}
get invalid(){return this._proxyObjectId===0;}
updateForCollectionEvent(event)
{if(!event.data.affectedSnapshots.includes(this._identifier))
return;this.update(()=>{this.dispatchEventToListeners(WebInspector.HeapSnapshotProxy.Event.CollectedNodes,event.data);});}
allocationBucketCounts(bucketSizes,callback)
{WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"allocationBucketCounts",bucketSizes,callback);}
instancesWithClassName(className,callback)
{WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"instancesWithClassName",className,(serializedNodes)=>{callback(serializedNodes.map(WebInspector.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId)));});}
update(callback)
{WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"update",({liveSize,categories})=>{this._liveSize=liveSize;this._categories=Map.fromObject(categories);callback();});}
nodeWithIdentifier(nodeIdentifier,callback)
{WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"nodeWithIdentifier",nodeIdentifier,(serializedNode)=>{callback(WebInspector.HeapSnapshotNodeProxy.deserialize(this._proxyObjectId,serializedNode));});} 
_invalidate()
{this._proxyObjectId=0;this._liveSize=0;this.dispatchEventToListeners(WebInspector.HeapSnapshotProxy.Event.Invalidated);}};WebInspector.HeapSnapshotProxy.Event={CollectedNodes:"heap-snapshot-proxy-collected-nodes",Invalidated:"heap-snapshot-proxy-invalidated",};WebInspector.HeapSnapshotWorkerProxy=class HeapSnapshotWorkerProxy extends WebInspector.Object
{constructor()
{super();this._heapSnapshotWorker=new Worker("Workers/HeapSnapshot/HeapSnapshotWorker.js");this._heapSnapshotWorker.addEventListener("message",this._handleMessage.bind(this));this._nextCallId=1;this._callbacks=new Map;WebInspector.Frame.addEventListener(WebInspector.Frame.Event.MainResourceDidChange,this._mainResourceDidChange,this);} 
static singleton()
{if(!HeapSnapshotWorkerProxy.instance)
HeapSnapshotWorkerProxy.instance=new HeapSnapshotWorkerProxy;return HeapSnapshotWorkerProxy.instance;} 
clearSnapshots(callback)
{this.performAction("clearSnapshots",callback);}
createSnapshot(snapshotStringData,callback)
{this.performAction("createSnapshot",...arguments);}
createSnapshotDiff(objectId1,objectId2,callback)
{this.performAction("createSnapshotDiff",...arguments);} 
performAction(actionName)
{let callId=this._nextCallId++;let callback=arguments[arguments.length-1];let actionArguments=Array.prototype.slice.call(arguments,1,arguments.length-1);this._callbacks.set(callId,callback);this._postMessage({callId,actionName,actionArguments});}
callMethod(objectId,methodName)
{let callId=this._nextCallId++;let callback=arguments[arguments.length-1];let methodArguments=Array.prototype.slice.call(arguments,2,arguments.length-1);this._callbacks.set(callId,callback);this._postMessage({callId,objectId,methodName,methodArguments});} 
_mainResourceDidChange(event)
{if(!event.target.isMainFrame())
return;this.clearSnapshots(()=>{WebInspector.HeapSnapshotProxy.invalidateSnapshotProxies();});}
_postMessage()
{this._heapSnapshotWorker.postMessage(...arguments);}
_handleMessage(event)
{let data=event.data;if(data.error){this._callbacks.delete(data.callId);return;}
if(data.eventName){this.dispatchEventToListeners(data.eventName,data.eventData);return;}
if(data.callId){let callback=this._callbacks.get(data.callId);this._callbacks.delete(data.callId);callback(data.result);return;}
console.error("Unexpected HeapSnapshotWorker message",data);}};WebInspector.View=class View extends WebInspector.Object
{constructor(element)
{super();this._element=element||document.createElement("div");this._element.__view=this;this._parentView=null;this._subviews=[];this._dirty=false;this._dirtyDescendantsCount=0;this._needsLayoutWhenAttachedToRoot=false;this._isAttachedToRoot=false;this._layoutReason=null;this._didInitialLayout=false;} 
static rootView()
{if(!WebInspector.View._rootView)
WebInspector.View._rootView=new WebInspector.View(document.body);return WebInspector.View._rootView;} 
get element()
{return this._element;}
get layoutPending()
{return this._dirty;}
get parentView()
{return this._parentView;}
get subviews()
{return this._subviews;}
isDescendantOf(view)
{let parentView=this._parentView;while(parentView){if(parentView===view)
return true;parentView=parentView.parentView;}
return false;}
addSubview(view)
{this.insertSubviewBefore(view,null);}
insertSubviewBefore(view,referenceView)
{if(this._subviews.includes(view)){return;}
const beforeIndex=referenceView?this._subviews.indexOf(referenceView):this._subviews.length;if(beforeIndex===-1){return;}
this._subviews.insertAtIndex(view,beforeIndex);if(!view.element.parentNode)
this._element.insertBefore(view.element,referenceView?referenceView.element:null);view.didMoveToParent(this);}
removeSubview(view)
{if(!this._subviews.includes(view)){return;}
this._subviews.remove(view,true);this._element.removeChild(view.element);view.didMoveToParent(null);}
replaceSubview(oldView,newView)
{this.insertSubviewBefore(newView,oldView);this.removeSubview(oldView);}
updateLayout(layoutReason)
{this.cancelLayout();this._setLayoutReason(layoutReason);this._layoutSubtree();}
updateLayoutIfNeeded(layoutReason)
{if(!this._dirty&&this._didInitialLayout)
return;this.updateLayout(layoutReason);}
needsLayout(layoutReason)
{this._setLayoutReason(layoutReason);if(this._dirty)
return;WebInspector.View._scheduleLayoutForView(this);}
cancelLayout()
{WebInspector.View._cancelScheduledLayoutForView(this);} 
get layoutReason(){return this._layoutReason;}
didMoveToWindow(isAttachedToRoot)
{this._isAttachedToRoot=isAttachedToRoot;if(this._isAttachedToRoot&&this._needsLayoutWhenAttachedToRoot){WebInspector.View._scheduleLayoutForView(this);this._needsLayoutWhenAttachedToRoot=false;}
for(let view of this._subviews)
view.didMoveToWindow(isAttachedToRoot);}
didMoveToParent(parentView)
{this._parentView=parentView;let isAttachedToRoot=this.isDescendantOf(WebInspector.View._rootView);this.didMoveToWindow(isAttachedToRoot);if(!this._parentView)
return;let pendingLayoutsCount=this._dirtyDescendantsCount;if(this._dirty)
pendingLayoutsCount++;let view=this._parentView;while(view){view._dirtyDescendantsCount+=pendingLayoutsCount;view=view.parentView;}}
initialLayout()
{
}
layout()
{}
sizeDidChange()
{} 
_layoutSubtree()
{this._dirty=false;this._dirtyDescendantsCount=0;if(!this._didInitialLayout){this.initialLayout();this._didInitialLayout=true;}
if(this._layoutReason===WebInspector.View.LayoutReason.Resize)
this.sizeDidChange();this.layout();for(let view of this._subviews){view._setLayoutReason(this._layoutReason);view._layoutSubtree();}
this._layoutReason=null;}
_setLayoutReason(layoutReason)
{if(this._layoutReason===WebInspector.View.LayoutReason.Resize)
return;this._layoutReason=layoutReason||WebInspector.View.LayoutReason.Dirty;} 
static _scheduleLayoutForView(view)
{view._dirty=true;let parentView=view.parentView;while(parentView){parentView._dirtyDescendantsCount++;parentView=parentView.parentView;}
if(!view._isAttachedToRoot){view._needsLayoutWhenAttachedToRoot=true;return;}
if(WebInspector.View._scheduledLayoutUpdateIdentifier)
return;WebInspector.View._scheduledLayoutUpdateIdentifier=requestAnimationFrame(WebInspector.View._visitViewTreeForLayout);}
static _cancelScheduledLayoutForView(view)
{let cancelledLayoutsCount=view._dirtyDescendantsCount;if(view.layoutPending)
cancelledLayoutsCount++;let parentView=view.parentView;while(parentView){parentView._dirtyDescendantsCount=Math.max(0,parentView._dirtyDescendantsCount-cancelledLayoutsCount);parentView=parentView.parentView;}
if(!WebInspector.View._scheduledLayoutUpdateIdentifier)
return;let rootView=WebInspector.View._rootView;if(!rootView||rootView._dirtyDescendantsCount)
return;cancelAnimationFrame(WebInspector.View._scheduledLayoutUpdateIdentifier);WebInspector.View._scheduledLayoutUpdateIdentifier=undefined;}
static _visitViewTreeForLayout()
{WebInspector.View._scheduledLayoutUpdateIdentifier=undefined;let views=[WebInspector.View._rootView];while(views.length){let view=views.shift();if(view.layoutPending)
view._layoutSubtree();else if(view._dirtyDescendantsCount){views=views.concat(view.subviews);view._dirtyDescendantsCount=0;}}}};WebInspector.View.LayoutReason={Dirty:Symbol("layout-reason-dirty"),Resize:Symbol("layout-reason-resize")};WebInspector.View._rootView=null;WebInspector.View._scheduledLayoutUpdateIdentifier=undefined;WebInspector.ConsoleCommandView=class ConsoleCommandView extends WebInspector.Object
{constructor(commandText,className)
{super();this._commandText=commandText;this._className=className||"";} 
render()
{this._element=document.createElement("div");this._element.classList.add("console-user-command");this._element.setAttribute("data-labelprefix",WebInspector.UIString("Input: "));if(this._className)
this._element.classList.add(this._className);this._formattedCommandElement=this._element.appendChild(document.createElement("span"));this._formattedCommandElement.classList.add("console-message-text");this._formattedCommandElement.textContent=this._commandText; this._element.__commandView=this;}
get element()
{return this._element;}
get commandText()
{return this._commandText;}
toClipboardString(isPrefixOptional)
{return(isPrefixOptional?"":"> ")+this._commandText.removeWordBreakCharacters();}};WebInspector.ConsoleMessageView=class ConsoleMessageView extends WebInspector.Object
{constructor(message)
{super();this._message=message;this._expandable=false;this._repeatCount=message._repeatCount||0;this._extraParameters=message.parameters;} 
render()
{this._element=document.createElement("div");this._element.classList.add("console-message"); this._element.__message=this._message;this._element.__messageView=this;if(this._message.type===WebInspector.ConsoleMessage.MessageType.Result){this._element.classList.add("console-user-command-result");this._element.setAttribute("data-labelprefix",WebInspector.UIString("Output: "));}else if(this._message.type===WebInspector.ConsoleMessage.MessageType.StartGroup||this._message.type===WebInspector.ConsoleMessage.MessageType.StartGroupCollapsed)
this._element.classList.add("console-group-title");switch(this._message.level){case WebInspector.ConsoleMessage.MessageLevel.Log:this._element.classList.add("console-log-level");this._element.setAttribute("data-labelprefix",WebInspector.UIString("Log: "));break;case WebInspector.ConsoleMessage.MessageLevel.Info:this._element.classList.add("console-info-level");this._element.setAttribute("data-labelprefix",WebInspector.UIString("Info: "));break;case WebInspector.ConsoleMessage.MessageLevel.Debug:this._element.classList.add("console-debug-level");this._element.setAttribute("data-labelprefix",WebInspector.UIString("Debug: "));break;case WebInspector.ConsoleMessage.MessageLevel.Warning:this._element.classList.add("console-warning-level");this._element.setAttribute("data-labelprefix",WebInspector.UIString("Warning: "));break;case WebInspector.ConsoleMessage.MessageLevel.Error:this._element.classList.add("console-error-level");this._element.setAttribute("data-labelprefix",WebInspector.UIString("Error: "));break;}
this._appendLocationLink();this._messageTextElement=this._element.appendChild(document.createElement("span"));this._messageTextElement.classList.add("console-top-level-message");this._messageTextElement.classList.add("console-message-text");this._appendMessageTextAndArguments(this._messageTextElement);this._appendSavedResultIndex();this._appendExtraParameters();this._appendStackTrace();this._renderRepeatCount();}
get element()
{return this._element;}
get message()
{return this._message;}
get repeatCount()
{return this._repeatCount;}
set repeatCount(count)
{if(this._repeatCount===count)
return;this._repeatCount=count;if(this._element)
this._renderRepeatCount();}
_renderRepeatCount()
{let count=this._repeatCount;if(count<=1){if(this._repeatCountElement){this._repeatCountElement.remove();this._repeatCountElement=null;}
return;}
if(!this._repeatCountElement){this._repeatCountElement=document.createElement("span");this._repeatCountElement.classList.add("repeat-count");this._element.insertBefore(this._repeatCountElement,this._element.firstChild);}
this._repeatCountElement.textContent=Number.abbreviate(count);}
get expandable()
{if(this._expandable)
return true;if(this._objectTree)
return true;return false;}
expand()
{if(this._expandable)
this._element.classList.add("expanded");if(this._objectTree&&this._message.type!==WebInspector.ConsoleMessage.MessageType.Trace){if(!this._extraParameters||this._extraParameters.length<=1)
this._objectTree.expand();}}
collapse()
{if(this._expandable)
this._element.classList.remove("expanded");if(this._objectTree){if(!this._extraParameters||this._extraParameters.length<=1)
this._objectTree.collapse();}}
toggle()
{if(this._element.classList.contains("expanded"))
this.collapse();else
this.expand();}
toClipboardString(isPrefixOptional)
{let clipboardString=this._messageTextElement.innerText.removeWordBreakCharacters();if(this._message.savedResultIndex)
clipboardString=clipboardString.replace(/\s*=\s*(\$\d+)$/,"");let hasStackTrace=this._shouldShowStackTrace();if(!hasStackTrace){let repeatString=this.repeatCount>1?"x"+this.repeatCount:"";let urlLine="";if(this._message.url){let components=[WebInspector.displayNameForURL(this._message.url),"line "+this._message.line];if(repeatString)
components.push(repeatString);urlLine=" ("+components.join(", ")+")";}else if(repeatString)
urlLine=" ("+repeatString+")";if(urlLine){let lines=clipboardString.split("\n");lines[0]+=urlLine;clipboardString=lines.join("\n");}}
if(this._extraElementsList)
clipboardString+="\n"+this._extraElementsList.innerText.removeWordBreakCharacters().trim();if(hasStackTrace){this._message.stackTrace.callFrames.forEach(function(frame){clipboardString+="\n\t"+(frame.functionName||WebInspector.UIString("(anonymous function)"));if(frame.sourceCodeLocation)
clipboardString+=" ("+frame.sourceCodeLocation.originalLocationString()+")";});}
if(!isPrefixOptional||this._enforcesClipboardPrefixString())
return this._clipboardPrefixString()+clipboardString;return clipboardString;} 
_appendMessageTextAndArguments(element)
{if(this._message.source===WebInspector.ConsoleMessage.MessageSource.ConsoleAPI){switch(this._message.type){case WebInspector.ConsoleMessage.MessageType.Trace:var args=[WebInspector.UIString("Trace")];if(this._message.parameters){if(this._message.parameters[0].type==="string"){var prefixedFormatString=WebInspector.UIString("Trace: %s").format(this._message.parameters[0].description);args=[prefixedFormatString].concat(this._message.parameters.slice(1));}else
args=args.concat(this._message.parameters);}
this._appendFormattedArguments(element,args);break;case WebInspector.ConsoleMessage.MessageType.Assert:var args=[WebInspector.UIString("Assertion Failed")];if(this._message.parameters){if(this._message.parameters[0].type==="string"){var prefixedFormatString=WebInspector.UIString("Assertion Failed: %s").format(this._message.parameters[0].description);args=[prefixedFormatString].concat(this._message.parameters.slice(1));}else
args=args.concat(this._message.parameters);}
this._appendFormattedArguments(element,args);break;case WebInspector.ConsoleMessage.MessageType.Dir:var obj=this._message.parameters?this._message.parameters[0]:undefined;this._appendFormattedArguments(element,["%O",obj]);break;case WebInspector.ConsoleMessage.MessageType.Table:var args=this._message.parameters;element.appendChild(this._formatParameterAsTable(args));this._extraParameters=null;break;case WebInspector.ConsoleMessage.MessageType.StartGroup:case WebInspector.ConsoleMessage.MessageType.StartGroupCollapsed:var args=this._message.parameters||[this._message.messageText||WebInspector.UIString("Group")];this._formatWithSubstitutionString(args,element);this._extraParameters=null;break;default:var args=this._message.parameters||[this._message.messageText];this._appendFormattedArguments(element,args);break;}
return;}
var args=this._message.parameters||[this._message.messageText];this._appendFormattedArguments(element,args);}
_appendSavedResultIndex(element)
{if(!this._message.savedResultIndex)
return;var savedVariableElement=document.createElement("span");savedVariableElement.classList.add("console-saved-variable");savedVariableElement.textContent=" = $"+this._message.savedResultIndex;if(this._objectTree)
this._objectTree.appendTitleSuffix(savedVariableElement);else
this._messageTextElement.appendChild(savedVariableElement);}
_appendLocationLink()
{if(this._message.source===WebInspector.ConsoleMessage.MessageSource.Network){if(this._message.url){var anchor=WebInspector.linkifyURLAsNode(this._message.url,this._message.url,"console-message-url");anchor.classList.add("console-message-location");this._element.appendChild(anchor);}
return;}
var firstNonNativeNonAnonymousCallFrame=this._message.stackTrace.firstNonNativeNonAnonymousCallFrame;var callFrame;if(firstNonNativeNonAnonymousCallFrame){callFrame=firstNonNativeNonAnonymousCallFrame;}else if(this._message.url&&!this._shouldHideURL(this._message.url)){callFrame=WebInspector.CallFrame.fromPayload(this._message.target,{functionName:"",url:this._message.url,lineNumber:this._message.line,columnNumber:this._message.column});}
if(callFrame&&(!callFrame.isConsoleEvaluation||WebInspector.isDebugUIEnabled())){const showFunctionName=!!callFrame.functionName;var locationElement=new WebInspector.CallFrameView(callFrame,showFunctionName);locationElement.classList.add("console-message-location");this._element.appendChild(locationElement);return;}
if(this._message.parameters&&this._message.parameters.length===1){var parameter=this._createRemoteObjectIfNeeded(this._message.parameters[0]);parameter.findFunctionSourceCodeLocation().then(function(result){if(result===WebInspector.RemoteObject.SourceCodeLocationPromise.NoSourceFound||result===WebInspector.RemoteObject.SourceCodeLocationPromise.MissingObjectId)
return;var link=this._linkifyLocation(result.sourceCode.url,result.lineNumber,result.columnNumber);link.classList.add("console-message-location");if(this._element.hasChildNodes())
this._element.insertBefore(link,this._element.firstChild);else
this._element.appendChild(link);}.bind(this));}}
_appendExtraParameters()
{if(!this._extraParameters||!this._extraParameters.length)
return;this._makeExpandable();if(this._extraParameters.length>1)
this.expand();this._extraElementsList=this._element.appendChild(document.createElement("ol"));this._extraElementsList.classList.add("console-message-extra-parameters-container");for(var parameter of this._extraParameters){var listItemElement=this._extraElementsList.appendChild(document.createElement("li"));const forceObjectFormat=parameter.type==="object"&&(parameter.subtype!=="null"&&parameter.subtype!=="regexp"&&parameter.subtype!=="node"&&parameter.subtype!=="error");listItemElement.classList.add("console-message-extra-parameter");listItemElement.appendChild(this._formatParameter(parameter,forceObjectFormat));}}
_appendStackTrace()
{if(!this._shouldShowStackTrace())
return;this._makeExpandable();if(this._message.type===WebInspector.ConsoleMessage.MessageType.Trace)
this.expand();this._stackTraceElement=this._element.appendChild(document.createElement("div"));this._stackTraceElement.classList.add("console-message-text","console-message-stack-trace-container");var callFramesElement=new WebInspector.StackTraceView(this._message.stackTrace).element;this._stackTraceElement.appendChild(callFramesElement);}
_createRemoteObjectIfNeeded(parameter)
{if(parameter instanceof WebInspector.RemoteObject)
return parameter;if(typeof parameter==="object")
return WebInspector.RemoteObject.fromPayload(parameter,this._message.target);return WebInspector.RemoteObject.fromPrimitiveValue(parameter);}
_appendFormattedArguments(element,parameters)
{if(!parameters.length)
return;for(var i=0;i<parameters.length;++i)
parameters[i]=this._createRemoteObjectIfNeeded(parameters[i]);var builderElement=element.appendChild(document.createElement("span"));var shouldFormatWithStringSubstitution=WebInspector.RemoteObject.type(parameters[0])==="string"&&this._message.type!==WebInspector.ConsoleMessage.MessageType.Result;if(parameters.length===1&&!shouldFormatWithStringSubstitution){this._extraParameters=null;builderElement.appendChild(this._formatParameter(parameters[0],false));return;}
if(shouldFormatWithStringSubstitution&&this._isStackTrace(parameters[0]))
shouldFormatWithStringSubstitution=false;if(shouldFormatWithStringSubstitution){var result=this._formatWithSubstitutionString(parameters,builderElement);parameters=result.unusedSubstitutions;this._extraParameters=parameters;}else{var defaultMessage=WebInspector.UIString("No message");builderElement.append(defaultMessage);}
if(parameters.length){let enclosedElement=document.createElement("span");if(parameters.length===1&&!this._isStackTrace(parameters[0])){let parameter=parameters[0];builderElement.append(enclosedElement);enclosedElement.classList.add("console-message-preview-divider");enclosedElement.textContent=" \u2013 ";var previewContainer=builderElement.appendChild(document.createElement("span"));previewContainer.classList.add("console-message-preview");var preview=WebInspector.FormattedValue.createObjectPreviewOrFormattedValueForRemoteObject(parameter,WebInspector.ObjectPreviewView.Mode.Brief);var isPreviewView=preview instanceof WebInspector.ObjectPreviewView;if(isPreviewView)
preview.setOriginatingObjectInfo(parameter,null);var previewElement=isPreviewView?preview.element:preview;previewContainer.appendChild(previewElement);if((isPreviewView&&preview.lossless)||(!isPreviewView&&this._shouldConsiderObjectLossless(parameter))){this._extraParameters=null;enclosedElement.classList.add("inline-lossless");previewContainer.classList.add("inline-lossless");}}else{builderElement.append(" ",enclosedElement);enclosedElement.classList.add("console-message-enclosed");enclosedElement.textContent="("+parameters.length+")";}}}
_isStackTrace(parameter)
{if(WebInspector.RemoteObject.type(parameter)!=="string")
return false;return WebInspector.StackTrace.isLikelyStackTrace(parameter.description);}
_shouldConsiderObjectLossless(object)
{if(object.type==="string"){const description=object.description;const maxLength=WebInspector.FormattedValue.MAX_PREVIEW_STRING_LENGTH;const longOrMultiLineString=description.length>maxLength||description.slice(0,maxLength).includes("\n");return!longOrMultiLineString;}
return object.type!=="object"||object.subtype==="null"||object.subtype==="regexp";}
_formatParameter(parameter,forceObjectFormat)
{var type;if(forceObjectFormat)
type="object";else if(parameter instanceof WebInspector.RemoteObject)
type=parameter.subtype||parameter.type;else{type=typeof parameter;}
var formatters={"object":this._formatParameterAsObject,"error":this._formatParameterAsError,"map":this._formatParameterAsObject,"set":this._formatParameterAsObject,"weakmap":this._formatParameterAsObject,"weakset":this._formatParameterAsObject,"iterator":this._formatParameterAsObject,"class":this._formatParameterAsObject,"proxy":this._formatParameterAsObject,"array":this._formatParameterAsArray,"node":this._formatParameterAsNode,"string":this._formatParameterAsString,};var formatter=formatters[type]||this._formatParameterAsValue;const fragment=document.createDocumentFragment();formatter.call(this,parameter,fragment,forceObjectFormat);return fragment;}
_formatParameterAsValue(value,fragment)
{fragment.appendChild(WebInspector.FormattedValue.createElementForRemoteObject(value));}
_formatParameterAsString(object,fragment)
{if(this._isStackTrace(object)){let stackTrace=WebInspector.StackTrace.fromString(this._message.target,object.description);if(stackTrace.callFrames.length){let stackView=new WebInspector.StackTraceView(stackTrace);fragment.appendChild(stackView.element);return;}}
fragment.appendChild(WebInspector.FormattedValue.createLinkifiedElementString(object.description));}
_formatParameterAsNode(object,fragment)
{fragment.appendChild(WebInspector.FormattedValue.createElementForNode(object));}
_formatParameterAsObject(object,fragment,forceExpansion)
{this._objectTree=new WebInspector.ObjectTreeView(object,null,this._rootPropertyPathForObject(object),forceExpansion);fragment.appendChild(this._objectTree.element);}
_formatParameterAsError(object,fragment)
{this._objectTree=new WebInspector.ErrorObjectView(object);fragment.appendChild(this._objectTree.element);}
_formatParameterAsArray(array,fragment)
{this._objectTree=new WebInspector.ObjectTreeView(array,WebInspector.ObjectTreeView.Mode.Properties,this._rootPropertyPathForObject(array));fragment.appendChild(this._objectTree.element);}
_rootPropertyPathForObject(object)
{if(!this._message.savedResultIndex)
return null;return new WebInspector.PropertyPath(object,"$"+this._message.savedResultIndex);}
_formatWithSubstitutionString(parameters,formattedResult)
{function parameterFormatter(force,obj)
{return this._formatParameter(obj,force);}
function stringFormatter(obj)
{return obj.description;}
function floatFormatter(obj,token)
{let value=typeof obj.value==="number"?obj.value:obj.description;return String.standardFormatters.f(value,token);}
function integerFormatter(obj)
{let value=typeof obj.value==="number"?obj.value:obj.description;return String.standardFormatters.d(value);}
var currentStyle=null;function styleFormatter(obj)
{currentStyle={};var buffer=document.createElement("span");buffer.setAttribute("style",obj.description);for(var i=0;i<buffer.style.length;i++){var property=buffer.style[i];if(isWhitelistedProperty(property))
currentStyle[property]=buffer.style[property];}}
function isWhitelistedProperty(property)
{for(var prefix of["background","border","color","font","line","margin","padding","text"]){if(property.startsWith(prefix)||property.startsWith("-webkit-"+prefix))
return true;}
return false;}
var formatters={};formatters.o=parameterFormatter.bind(this,false);formatters.s=stringFormatter;formatters.f=floatFormatter;formatters.i=integerFormatter;formatters.d=integerFormatter;formatters.c=styleFormatter;formatters.O=parameterFormatter.bind(this,true);function append(a,b)
{if(b instanceof Node)
a.appendChild(b);else if(b!==undefined){var toAppend=WebInspector.linkifyStringAsFragment(b.toString());if(currentStyle){var wrapper=document.createElement("span");for(var key in currentStyle)
wrapper.style[key]=currentStyle[key];wrapper.appendChild(toAppend);toAppend=wrapper;}
a.appendChild(toAppend);}
return a;}
return String.format(parameters[0].description,parameters.slice(1),formatters,formattedResult,append);}
_shouldShowStackTrace()
{if(!this._message.stackTrace.callFrames.length)
return false;return this._message.source===WebInspector.ConsoleMessage.MessageSource.Network||this._message.level===WebInspector.ConsoleMessage.MessageLevel.Error||this._message.type===WebInspector.ConsoleMessage.MessageType.Trace;}
_shouldHideURL(url)
{return url==="undefined"||url==="[native code]";}
_linkifyLocation(url,lineNumber,columnNumber)
{const options={className:"console-message-url",ignoreNetworkTab:true,ignoreSearchTab:true,};return WebInspector.linkifyLocation(url,new WebInspector.SourceCodePosition(lineNumber,columnNumber),options);}
_userProvidedColumnNames(columnNamesArgument)
{if(!columnNamesArgument)
return null;if(columnNamesArgument.type==="string"||columnNamesArgument.type==="number")
return[String(columnNamesArgument.value)];if(columnNamesArgument.type!=="object"||columnNamesArgument.subtype!=="array"||!columnNamesArgument.preview||!columnNamesArgument.preview.propertyPreviews)
return null;var extractedColumnNames=[];for(var propertyPreview of columnNamesArgument.preview.propertyPreviews){if(propertyPreview.type==="string"||propertyPreview.type==="number")
extractedColumnNames.push(String(propertyPreview.value));}
return extractedColumnNames.length?extractedColumnNames:null;}
_formatParameterAsTable(parameters)
{var element=document.createElement("span");var table=parameters[0];if(!table||!table.preview)
return element;var rows=[];var columnNames=[];var flatValues=[];var preview=table.preview;var userProvidedColumnNames=false;var extractedColumnNames=this._userProvidedColumnNames(parameters[1]);if(extractedColumnNames){userProvidedColumnNames=true;columnNames=extractedColumnNames;}
if(preview.propertyPreviews){for(var i=0;i<preview.propertyPreviews.length;++i){var rowProperty=preview.propertyPreviews[i];var rowPreview=rowProperty.valuePreview;if(!rowPreview||!rowPreview.propertyPreviews)
continue;var rowValue={};var maxColumnsToRender=15;for(var j=0;j<rowPreview.propertyPreviews.length;++j){var cellProperty=rowPreview.propertyPreviews[j];var columnRendered=columnNames.includes(cellProperty.name);if(!columnRendered){if(userProvidedColumnNames||columnNames.length===maxColumnsToRender)
continue;columnRendered=true;columnNames.push(cellProperty.name);}
rowValue[cellProperty.name]=WebInspector.FormattedValue.createElementForPropertyPreview(cellProperty);}
rows.push([rowProperty.name,rowValue]);}}
if(rows.length){columnNames.unshift(WebInspector.UIString("(Index)"));for(var i=0;i<rows.length;++i){var rowName=rows[i][0];var rowValue=rows[i][1];flatValues.push(rowName);for(var j=1;j<columnNames.length;++j){var columnName=columnNames[j];if(!(columnName in rowValue))
flatValues.push(emDash);else
flatValues.push(rowValue[columnName]);}}}
if(!flatValues.length&&preview.propertyPreviews){for(var i=0;i<preview.propertyPreviews.length;++i){var rowProperty=preview.propertyPreviews[i];if(!("value"in rowProperty))
continue;if(!columnNames.length){columnNames.push(WebInspector.UIString("Index"));columnNames.push(WebInspector.UIString("Value"));}
flatValues.push(rowProperty.name);flatValues.push(WebInspector.FormattedValue.createElementForPropertyPreview(rowProperty));}}
if(!flatValues.length)
return element;var dataGrid=WebInspector.DataGrid.createSortableDataGrid(columnNames,flatValues);dataGrid.inline=true;dataGrid.variableHeightRows=true;element.appendChild(dataGrid.element);dataGrid.updateLayoutIfNeeded();return element;}
_levelString()
{switch(this._message.level){case WebInspector.ConsoleMessage.MessageLevel.Log:return"Log";case WebInspector.ConsoleMessage.MessageLevel.Info:return"Info";case WebInspector.ConsoleMessage.MessageLevel.Warning:return"Warning";case WebInspector.ConsoleMessage.MessageLevel.Debug:return"Debug";case WebInspector.ConsoleMessage.MessageLevel.Error:return"Error";}}
_enforcesClipboardPrefixString()
{return this._message.type!==WebInspector.ConsoleMessage.MessageType.Result;}
_clipboardPrefixString()
{if(this._message.type===WebInspector.ConsoleMessage.MessageType.Result)
return"< ";return"["+this._levelString()+"] ";}
_makeExpandable()
{if(this._expandable)
return;this._expandable=true;this._element.classList.add("expandable");this._boundClickHandler=this.toggle.bind(this);this._messageTextElement.addEventListener("click",this._boundClickHandler);}};WebInspector.ContentBrowser=class ContentBrowser extends WebInspector.View
{constructor(element,delegate,disableBackForward,disableFindBanner)
{super(element);this.element.classList.add("content-browser");this._navigationBar=new WebInspector.NavigationBar;this.addSubview(this._navigationBar);this._contentViewContainer=new WebInspector.ContentViewContainer;this._contentViewContainer.addEventListener(WebInspector.ContentViewContainer.Event.CurrentContentViewDidChange,this._currentContentViewDidChange,this);this.addSubview(this._contentViewContainer);if(!disableBackForward){let isRTL=WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL;let goBack=()=>{this.goBack();};let goForward=()=>{this.goForward();};let backShortcutKey=isRTL?WebInspector.KeyboardShortcut.Key.Right:WebInspector.KeyboardShortcut.Key.Left;let forwardShortcutKey=isRTL?WebInspector.KeyboardShortcut.Key.Left:WebInspector.KeyboardShortcut.Key.Right;this._backKeyboardShortcut=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.CommandOrControl|WebInspector.KeyboardShortcut.Modifier.Control,backShortcutKey,goBack,this.element);this._forwardKeyboardShortcut=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.CommandOrControl|WebInspector.KeyboardShortcut.Modifier.Control,forwardShortcutKey,goForward,this.element);let leftArrow="Images/BackForwardArrows.svg#left-arrow-mask";let rightArrow="Images/BackForwardArrows.svg#right-arrow-mask";let backButtonImage=isRTL?rightArrow:leftArrow;let forwardButtonImage=isRTL?leftArrow:rightArrow;this._backNavigationItem=new WebInspector.ButtonNavigationItem("back",WebInspector.UIString("Back (%s)").format(this._backKeyboardShortcut.displayName),backButtonImage,8,13);this._backNavigationItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,goBack);this._backNavigationItem.enabled=false;this._navigationBar.addNavigationItem(this._backNavigationItem);this._forwardNavigationItem=new WebInspector.ButtonNavigationItem("forward",WebInspector.UIString("Forward (%s)").format(this._forwardKeyboardShortcut.displayName),forwardButtonImage,8,13);this._forwardNavigationItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,goForward);this._forwardNavigationItem.enabled=false;this._navigationBar.addNavigationItem(this._forwardNavigationItem);this._navigationBar.addNavigationItem(new WebInspector.DividerNavigationItem);}
if(!disableFindBanner){this._findBanner=new WebInspector.FindBanner(this);this._findBanner.addEventListener(WebInspector.FindBanner.Event.DidShow,this._findBannerDidShow,this);this._findBanner.addEventListener(WebInspector.FindBanner.Event.DidHide,this._findBannerDidHide,this);}
this._hierarchicalPathNavigationItem=new WebInspector.HierarchicalPathNavigationItem;this._hierarchicalPathNavigationItem.addEventListener(WebInspector.HierarchicalPathNavigationItem.Event.PathComponentWasSelected,this._hierarchicalPathComponentWasSelected,this);this._navigationBar.addNavigationItem(this._hierarchicalPathNavigationItem);this._contentViewSelectionPathNavigationItem=new WebInspector.HierarchicalPathNavigationItem;this._dividingFlexibleSpaceNavigationItem=new WebInspector.FlexibleSpaceNavigationItem;this._navigationBar.addNavigationItem(this._dividingFlexibleSpaceNavigationItem);WebInspector.ContentView.addEventListener(WebInspector.ContentView.Event.SelectionPathComponentsDidChange,this._contentViewSelectionPathComponentDidChange,this);WebInspector.ContentView.addEventListener(WebInspector.ContentView.Event.SupplementalRepresentedObjectsDidChange,this._contentViewSupplementalRepresentedObjectsDidChange,this);WebInspector.ContentView.addEventListener(WebInspector.ContentView.Event.NumberOfSearchResultsDidChange,this._contentViewNumberOfSearchResultsDidChange,this);WebInspector.ContentView.addEventListener(WebInspector.ContentView.Event.NavigationItemsDidChange,this._contentViewNavigationItemsDidChange,this);this._delegate=delegate||null;this._currentContentViewNavigationItems=[];} 
get navigationBar()
{return this._navigationBar;}
get contentViewContainer()
{return this._contentViewContainer;}
get delegate()
{return this._delegate;}
set delegate(newDelegate)
{this._delegate=newDelegate||null;}
get currentContentView()
{return this._contentViewContainer.currentContentView;}
get currentRepresentedObjects()
{var representedObjects=[];var lastComponent=this._hierarchicalPathNavigationItem.lastComponent;if(lastComponent&&lastComponent.representedObject)
representedObjects.push(lastComponent.representedObject);lastComponent=this._contentViewSelectionPathNavigationItem.lastComponent;if(lastComponent&&lastComponent.representedObject)
representedObjects.push(lastComponent.representedObject);var currentContentView=this.currentContentView;if(currentContentView){var supplementalRepresentedObjects=currentContentView.supplementalRepresentedObjects;if(supplementalRepresentedObjects&&supplementalRepresentedObjects.length)
representedObjects=representedObjects.concat(supplementalRepresentedObjects);}
return representedObjects;}
showContentViewForRepresentedObject(representedObject,cookie,extraArguments)
{var contentView=this.contentViewForRepresentedObject(representedObject,false,extraArguments);return this._contentViewContainer.showContentView(contentView,cookie);}
showContentView(contentView,cookie)
{return this._contentViewContainer.showContentView(contentView,cookie);}
contentViewForRepresentedObject(representedObject,onlyExisting,extraArguments)
{return this._contentViewContainer.contentViewForRepresentedObject(representedObject,onlyExisting,extraArguments);}
updateHierarchicalPathForCurrentContentView()
{var currentContentView=this.currentContentView;this._updateHierarchicalPathNavigationItem(currentContentView?currentContentView.representedObject:null);}
canGoBack()
{var currentContentView=this.currentContentView;if(currentContentView&&currentContentView.canGoBack())
return true;return this._contentViewContainer.canGoBack();}
canGoForward()
{var currentContentView=this.currentContentView;if(currentContentView&&currentContentView.canGoForward())
return true;return this._contentViewContainer.canGoForward();}
goBack()
{var currentContentView=this.currentContentView;if(currentContentView&&currentContentView.canGoBack()){currentContentView.goBack();this._updateBackForwardButtons();return;}
this._contentViewContainer.goBack();}
goForward()
{var currentContentView=this.currentContentView;if(currentContentView&&currentContentView.canGoForward()){currentContentView.goForward();this._updateBackForwardButtons();return;}
this._contentViewContainer.goForward();}
showFindBanner()
{if(!this._findBanner)
return;var currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return;if(currentContentView.supportsCustomFindBanner){currentContentView.showCustomFindBanner();return;}
this._findBanner.show();}
findBannerPerformSearch(findBanner,query)
{var currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return;currentContentView.performSearch(query);}
findBannerSearchCleared(findBanner)
{var currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return;currentContentView.searchCleared();}
findBannerSearchQueryForSelection(findBanner)
{var currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return null;return currentContentView.searchQueryWithSelection();}
findBannerRevealPreviousResult(findBanner)
{var currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return;currentContentView.revealPreviousSearchResult(!findBanner.showing);}
findBannerRevealNextResult(findBanner)
{var currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return;currentContentView.revealNextSearchResult(!findBanner.showing);}
shown()
{this._contentViewContainer.shown();if(this._findBanner)
this._findBanner.enableKeyboardShortcuts();}
hidden()
{this._contentViewContainer.hidden();if(this._findBanner)
this._findBanner.disableKeyboardShortcuts();} 
_findBannerDidShow(event)
{var currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return;currentContentView.automaticallyRevealFirstSearchResult=true;if(this._findBanner.searchQuery!=="")
currentContentView.performSearch(this._findBanner.searchQuery);}
_findBannerDidHide(event)
{var currentContentView=this.currentContentView;if(!currentContentView||!currentContentView.supportsSearch)
return;currentContentView.automaticallyRevealFirstSearchResult=false;currentContentView.searchCleared();}
_contentViewNumberOfSearchResultsDidChange(event)
{if(!this._findBanner)
return;if(event.target!==this.currentContentView)
return;this._findBanner.numberOfResults=this.currentContentView.numberOfSearchResults;}
_updateHierarchicalPathNavigationItem(representedObject)
{if(!this.delegate||typeof this.delegate.contentBrowserTreeElementForRepresentedObject!=="function")
return;var treeElement=representedObject?this.delegate.contentBrowserTreeElementForRepresentedObject(this,representedObject):null;var pathComponents=[];while(treeElement&&!treeElement.root){var pathComponent=new WebInspector.GeneralTreeElementPathComponent(treeElement);pathComponents.unshift(pathComponent);treeElement=treeElement.parent;}
this._hierarchicalPathNavigationItem.components=pathComponents;}
_updateContentViewSelectionPathNavigationItem(contentView)
{var selectionPathComponents=contentView?contentView.selectionPathComponents||[]:[];this._contentViewSelectionPathNavigationItem.components=selectionPathComponents;if(!selectionPathComponents.length){this._hierarchicalPathNavigationItem.alwaysShowLastPathComponentSeparator=false;this._navigationBar.removeNavigationItem(this._contentViewSelectionPathNavigationItem);return;}
if(!this._navigationBar.navigationItems.includes(this._contentViewSelectionPathNavigationItem)){var hierarchicalPathItemIndex=this._navigationBar.navigationItems.indexOf(this._hierarchicalPathNavigationItem);this._navigationBar.insertNavigationItem(this._contentViewSelectionPathNavigationItem,hierarchicalPathItemIndex+1);this._hierarchicalPathNavigationItem.alwaysShowLastPathComponentSeparator=true;}}
_updateBackForwardButtons()
{if(!this._backNavigationItem||!this._forwardNavigationItem)
return;this._backNavigationItem.enabled=this.canGoBack();this._forwardNavigationItem.enabled=this.canGoForward();}
_updateContentViewNavigationItems(forceUpdate)
{let currentContentView=this.currentContentView;if(!currentContentView){this._removeAllNavigationItems();this._currentContentViewNavigationItems=[];return;}
if(currentContentView.parentContainer!==this._contentViewContainer)
return;if(!forceUpdate){let previousItems=this._currentContentViewNavigationItems.filter((item)=>!(item instanceof WebInspector.DividerNavigationItem));let isUnchanged=Array.shallowEqual(previousItems,currentContentView.navigationItems);if(isUnchanged)
return;}
this._removeAllNavigationItems();let navigationBar=this.navigationBar;let insertionIndex=navigationBar.navigationItems.indexOf(this._dividingFlexibleSpaceNavigationItem)+1;let newNavigationItems=[];currentContentView.navigationItems.forEach(function(navigationItem,index){if(index!==0||navigationItem instanceof WebInspector.ButtonNavigationItem){let divider=new WebInspector.DividerNavigationItem;navigationBar.insertNavigationItem(divider,insertionIndex++);newNavigationItems.push(divider);}
navigationBar.insertNavigationItem(navigationItem,insertionIndex++);newNavigationItems.push(navigationItem);});
this._currentContentViewNavigationItems=newNavigationItems;}
_removeAllNavigationItems()
{for(let navigationItem of this._currentContentViewNavigationItems){if(navigationItem.parentNavigationBar)
navigationItem.parentNavigationBar.removeNavigationItem(navigationItem);}}
_updateFindBanner(currentContentView)
{if(!this._findBanner)
return;if(!currentContentView){this._findBanner.targetElement=null;this._findBanner.numberOfResults=null;return;}
this._findBanner.targetElement=currentContentView.element;this._findBanner.numberOfResults=currentContentView.hasPerformedSearch?currentContentView.numberOfSearchResults:null;if(currentContentView.supportsSearch&&this._findBanner.searchQuery){currentContentView.automaticallyRevealFirstSearchResult=this._findBanner.showing;currentContentView.performSearch(this._findBanner.searchQuery);}}
_dispatchCurrentRepresentedObjectsDidChangeEvent()
{this._dispatchCurrentRepresentedObjectsDidChangeEvent.cancelDebounce();this.dispatchEventToListeners(WebInspector.ContentBrowser.Event.CurrentRepresentedObjectsDidChange);}
_contentViewSelectionPathComponentDidChange(event)
{if(event.target!==this.currentContentView)
return;this._updateContentViewSelectionPathNavigationItem(event.target);this._updateBackForwardButtons();this._updateContentViewNavigationItems();this._navigationBar.needsLayout();this.soon._dispatchCurrentRepresentedObjectsDidChangeEvent();}
_contentViewSupplementalRepresentedObjectsDidChange(event)
{if(event.target!==this.currentContentView)
return;this.soon._dispatchCurrentRepresentedObjectsDidChangeEvent();}
_currentContentViewDidChange(event)
{var currentContentView=this.currentContentView;this._updateHierarchicalPathNavigationItem(currentContentView?currentContentView.representedObject:null);this._updateContentViewSelectionPathNavigationItem(currentContentView);this._updateBackForwardButtons();this._updateContentViewNavigationItems();this._updateFindBanner(currentContentView);this._navigationBar.needsLayout();this.dispatchEventToListeners(WebInspector.ContentBrowser.Event.CurrentContentViewDidChange);this._dispatchCurrentRepresentedObjectsDidChangeEvent();}
_contentViewNavigationItemsDidChange(event)
{if(event.target!==this.currentContentView)
return;const forceUpdate=true;this._updateContentViewNavigationItems(forceUpdate);this._navigationBar.needsLayout();}
_hierarchicalPathComponentWasSelected(event)
{var treeElement=event.data.pathComponent.generalTreeElement;var originalTreeElement=treeElement;while(treeElement&&!WebInspector.ContentView.isViewable(treeElement.representedObject))
treeElement=treeElement.traverseNextTreeElement(false,originalTreeElement,false);if(!treeElement)
return;treeElement.revealAndSelect();}};WebInspector.ContentBrowser.Event={CurrentRepresentedObjectsDidChange:"content-browser-current-represented-objects-did-change",CurrentContentViewDidChange:"content-browser-current-content-view-did-change"};WebInspector.ContentView=class ContentView extends WebInspector.View
{constructor(representedObject,extraArguments)
{super();this._representedObject=representedObject;this.element.classList.add("content-view");this._parentContainer=null;} 
static createFromRepresentedObject(representedObject,extraArguments)
{if(representedObject instanceof WebInspector.Frame)
return new WebInspector.ResourceClusterContentView(representedObject.mainResource,extraArguments);if(representedObject instanceof WebInspector.Resource)
return new WebInspector.ResourceClusterContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.Script)
return new WebInspector.ScriptContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.CSSStyleSheet)
return new WebInspector.TextResourceContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.Canvas)
return new WebInspector.CanvasContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.TimelineRecording)
return new WebInspector.TimelineRecordingContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.Timeline){var timelineType=representedObject.type;if(timelineType===WebInspector.TimelineRecord.Type.Network)
return new WebInspector.NetworkTimelineView(representedObject,extraArguments);if(timelineType===WebInspector.TimelineRecord.Type.Layout)
return new WebInspector.LayoutTimelineView(representedObject,extraArguments);if(timelineType===WebInspector.TimelineRecord.Type.Script)
return new WebInspector.ScriptClusterTimelineView(representedObject,extraArguments);if(timelineType===WebInspector.TimelineRecord.Type.RenderingFrame)
return new WebInspector.RenderingFrameTimelineView(representedObject,extraArguments);if(timelineType===WebInspector.TimelineRecord.Type.Memory)
return new WebInspector.MemoryTimelineView(representedObject,extraArguments);if(timelineType===WebInspector.TimelineRecord.Type.HeapAllocations)
return new WebInspector.HeapAllocationsTimelineView(representedObject,extraArguments);}
if(representedObject instanceof WebInspector.Breakpoint||representedObject instanceof WebInspector.IssueMessage){if(representedObject.sourceCodeLocation)
return WebInspector.ContentView.createFromRepresentedObject(representedObject.sourceCodeLocation.displaySourceCode,extraArguments);}
if(representedObject instanceof WebInspector.DOMStorageObject)
return new WebInspector.DOMStorageContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.CookieStorageObject)
return new WebInspector.CookieStorageContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.DatabaseTableObject)
return new WebInspector.DatabaseTableContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.DatabaseObject)
return new WebInspector.DatabaseContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.IndexedDatabase)
return new WebInspector.IndexedDatabaseContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.IndexedDatabaseObjectStore)
return new WebInspector.IndexedDatabaseObjectStoreContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.IndexedDatabaseObjectStoreIndex)
return new WebInspector.IndexedDatabaseObjectStoreContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.ApplicationCacheFrame)
return new WebInspector.ApplicationCacheFrameContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.DOMTree)
return new WebInspector.FrameDOMTreeContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.DOMSearchMatchObject){var resultView=new WebInspector.FrameDOMTreeContentView(WebInspector.frameResourceManager.mainFrame.domTree,extraArguments);resultView.restoreFromCookie({nodeToSelect:representedObject.domNode});return resultView;}
if(representedObject instanceof WebInspector.DOMNode){if(representedObject.frame){let resultView=WebInspector.ContentView.createFromRepresentedObject(representedObject.frame,extraArguments);resultView.restoreFromCookie({nodeToSelect:representedObject});return resultView;}}
if(representedObject instanceof WebInspector.SourceCodeSearchMatchObject){var resultView;if(representedObject.sourceCode instanceof WebInspector.Resource)
resultView=new WebInspector.ResourceClusterContentView(representedObject.sourceCode,extraArguments);else if(representedObject.sourceCode instanceof WebInspector.Script)
resultView=new WebInspector.ScriptContentView(representedObject.sourceCode,extraArguments);else
console.error("Unknown SourceCode",representedObject.sourceCode);var textRangeToSelect=representedObject.sourceCodeTextRange.formattedTextRange;var startPosition=textRangeToSelect.startPosition();resultView.restoreFromCookie({lineNumber:startPosition.lineNumber,columnNumber:startPosition.columnNumber});return resultView;}
if(representedObject instanceof WebInspector.LogObject)
return new WebInspector.LogContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.ContentFlow)
return new WebInspector.ContentFlowDOMTreeContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.CallingContextTree)
return new WebInspector.ProfileView(representedObject,extraArguments);if(representedObject instanceof WebInspector.HeapSnapshotProxy||representedObject instanceof WebInspector.HeapSnapshotDiffProxy)
return new WebInspector.HeapSnapshotClusterContentView(representedObject,extraArguments);if(representedObject instanceof WebInspector.Collection)
return new WebInspector.CollectionContentView(representedObject,extraArguments);if(typeof representedObject==="string"||representedObject instanceof String)
return new WebInspector.TextContentView(representedObject,extraArguments);throw new Error("Can't make a ContentView for an unknown representedObject of type: "+representedObject.constructor.name);}
static contentViewForRepresentedObject(representedObject,onlyExisting,extraArguments)
{let resolvedRepresentedObject=WebInspector.ContentView.resolvedRepresentedObjectForRepresentedObject(representedObject);if(!resolvedRepresentedObject)
return null;let existingContentView=resolvedRepresentedObject[WebInspector.ContentView.ContentViewForRepresentedObjectSymbol];if(existingContentView)
return existingContentView;if(onlyExisting)
return null;let newContentView=WebInspector.ContentView.createFromRepresentedObject(representedObject,extraArguments);if(!newContentView)
return null;newContentView.representedObject[WebInspector.ContentView.ContentViewForRepresentedObjectSymbol]=newContentView;return newContentView;}
static closedContentViewForRepresentedObject(representedObject)
{let resolvedRepresentedObject=WebInspector.ContentView.resolvedRepresentedObjectForRepresentedObject(representedObject);resolvedRepresentedObject[WebInspector.ContentView.ContentViewForRepresentedObjectSymbol]=null;}
static resolvedRepresentedObjectForRepresentedObject(representedObject)
{if(representedObject instanceof WebInspector.Frame)
return representedObject.mainResource;if(representedObject instanceof WebInspector.Breakpoint||representedObject instanceof WebInspector.IssueMessage){if(representedObject.sourceCodeLocation)
return representedObject.sourceCodeLocation.displaySourceCode;}
if(representedObject instanceof WebInspector.DOMBreakpoint){if(representedObject.domNode)
return WebInspector.ContentView.resolvedRepresentedObjectForRepresentedObject(representedObject.domNode);}
if(representedObject instanceof WebInspector.DOMNode){if(representedObject.frame)
return WebInspector.ContentView.resolvedRepresentedObjectForRepresentedObject(representedObject.frame);}
if(representedObject instanceof WebInspector.DOMSearchMatchObject)
return WebInspector.frameResourceManager.mainFrame.domTree;if(representedObject instanceof WebInspector.SourceCodeSearchMatchObject)
return representedObject.sourceCode;return representedObject;}
static isViewable(representedObject)
{if(representedObject instanceof WebInspector.Frame)
return true;if(representedObject instanceof WebInspector.Resource)
return true;if(representedObject instanceof WebInspector.Script)
return true;if(representedObject instanceof WebInspector.CSSStyleSheet)
return true;if(representedObject instanceof WebInspector.Canvas)
return true;if(representedObject instanceof WebInspector.TimelineRecording)
return true;if(representedObject instanceof WebInspector.Timeline)
return true;if(representedObject instanceof WebInspector.Breakpoint||representedObject instanceof WebInspector.IssueMessage)
return representedObject.sourceCodeLocation;if(representedObject instanceof WebInspector.DOMStorageObject)
return true;if(representedObject instanceof WebInspector.CookieStorageObject)
return true;if(representedObject instanceof WebInspector.DatabaseTableObject)
return true;if(representedObject instanceof WebInspector.DatabaseObject)
return true;if(representedObject instanceof WebInspector.IndexedDatabase)
return true;if(representedObject instanceof WebInspector.IndexedDatabaseObjectStore)
return true;if(representedObject instanceof WebInspector.IndexedDatabaseObjectStoreIndex)
return true;if(representedObject instanceof WebInspector.ApplicationCacheFrame)
return true;if(representedObject instanceof WebInspector.DOMTree)
return true;if(representedObject instanceof WebInspector.DOMSearchMatchObject)
return true;if(representedObject instanceof WebInspector.SourceCodeSearchMatchObject)
return true;if(representedObject instanceof WebInspector.LogObject)
return true;if(representedObject instanceof WebInspector.ContentFlow)
return true;if(representedObject instanceof WebInspector.CallingContextTree)
return true;if(representedObject instanceof WebInspector.HeapSnapshotProxy||representedObject instanceof WebInspector.HeapSnapshotDiffProxy)
return true;if(representedObject instanceof WebInspector.Collection)
return true;if(typeof representedObject==="string"||representedObject instanceof String)
return true;return false;} 
get representedObject()
{return this._representedObject;}
get navigationItems()
{return[];}
get parentContainer()
{return this._parentContainer;}
get visible()
{return this._visible;}
set visible(flag)
{this._visible=flag;}
get scrollableElements()
{return[];}
get shouldKeepElementsScrolledToBottom()
{return false;}
get selectionPathComponents()
{return[];}
get supplementalRepresentedObjects()
{return[];}
get supportsSplitContentBrowser()
{return WebInspector.dockedConfigurationSupportsSplitContentBrowser();}
shown()
{}
hidden()
{}
closed()
{}
saveToCookie(cookie)
{}
restoreFromCookie(cookie)
{}
canGoBack()
{return false;}
canGoForward()
{return false;}
goBack()
{}
goForward()
{}
get supportsSearch()
{return false;}
get supportsCustomFindBanner()
{return false;}
showCustomFindBanner()
{}
get numberOfSearchResults()
{return null;}
get hasPerformedSearch()
{return false;}
set automaticallyRevealFirstSearchResult(reveal)
{}
performSearch(query)
{}
searchCleared()
{}
searchQueryWithSelection()
{return null;}
revealPreviousSearchResult(changeFocus)
{}
revealNextSearchResult(changeFocus)
{}};WebInspector.ContentView.Event={SelectionPathComponentsDidChange:"content-view-selection-path-components-did-change",SupplementalRepresentedObjectsDidChange:"content-view-supplemental-represented-objects-did-change",NumberOfSearchResultsDidChange:"content-view-number-of-search-results-did-change",NavigationItemsDidChange:"content-view-navigation-items-did-change"};WebInspector.ContentView.ContentViewForRepresentedObjectSymbol=Symbol("content-view-for-represented-object");WebInspector.DataGrid=class DataGrid extends WebInspector.View
{constructor(columnsData,editCallback,deleteCallback,preferredColumnOrder)
{super();this.columns=new Map;this.orderedColumns=[];this._settingsIdentifier=null;this._sortColumnIdentifier=null;this._sortColumnIdentifierSetting=null;this._sortOrder=WebInspector.DataGrid.SortOrder.Indeterminate;this._sortOrderSetting=null;this._columnVisibilitySetting=null;this._columnChooserEnabled=false;this._headerVisible=true;this._rows=[];this.children=[];this.selectedNode=null;this.expandNodesWhenArrowing=false;this.root=true;this.hasChildren=false;this.expanded=true;this.revealed=true;this.selected=false;this.dataGrid=this;this.indentWidth=15;this.rowHeight=20;this.resizers=[];this._columnWidthsInitialized=false;this._scrollbarWidth=0;this._cachedScrollTop=NaN;this._cachedScrollableOffsetHeight=NaN;this._previousRevealedRowCount=NaN;this._topDataTableMarginHeight=NaN;this._bottomDataTableMarginHeight=NaN;this._filterText="";this._filterDelegate=null;this._filterDidModifyNodeWhileProcessingItems=false;this.element.className="data-grid";this.element.tabIndex=0;this.element.addEventListener("keydown",this._keyDown.bind(this),false);this.element.copyHandler=this;this._headerWrapperElement=document.createElement("div");this._headerWrapperElement.classList.add("header-wrapper");this._headerTableElement=document.createElement("table");this._headerTableElement.className="header";this._headerWrapperElement.appendChild(this._headerTableElement);this._headerTableColumnGroupElement=this._headerTableElement.createChild("colgroup");this._headerTableBodyElement=this._headerTableElement.createChild("tbody");this._headerTableRowElement=this._headerTableBodyElement.createChild("tr");this._headerTableRowElement.addEventListener("contextmenu",this._contextMenuInHeader.bind(this),true);this._headerTableCellElements=new Map;this._scrollContainerElement=document.createElement("div");this._scrollContainerElement.className="data-container";this._scrollListener=()=>this._noteScrollPositionChanged();this._updateScrollListeners();this._topDataTableMarginElement=this._scrollContainerElement.createChild("div");this._dataTableElement=this._scrollContainerElement.createChild("table","data");this._bottomDataTableMarginElement=this._scrollContainerElement.createChild("div");this._dataTableElement.addEventListener("mousedown",this._mouseDownInDataTable.bind(this));this._dataTableElement.addEventListener("click",this._clickInDataTable.bind(this));this._dataTableElement.addEventListener("contextmenu",this._contextMenuInDataTable.bind(this),true);
if(editCallback){this._dataTableElement.addEventListener("dblclick",this._ondblclick.bind(this),false);this._editCallback=editCallback;}
if(deleteCallback)
this._deleteCallback=deleteCallback;this._dataTableColumnGroupElement=this._headerTableColumnGroupElement.cloneNode(true);this._dataTableElement.appendChild(this._dataTableColumnGroupElement);this.dataTableBodyElement=this._dataTableElement.createChild("tbody");this._fillerRowElement=this.dataTableBodyElement.createChild("tr","filler");this.element.appendChild(this._headerWrapperElement);this.element.appendChild(this._scrollContainerElement);if(preferredColumnOrder){for(var columnIdentifier of preferredColumnOrder)
this.insertColumn(columnIdentifier,columnsData[columnIdentifier]);}else{for(var columnIdentifier in columnsData)
this.insertColumn(columnIdentifier,columnsData[columnIdentifier]);}
this._updateScrollbarPadding();this._copyTextDelimiter="\t";}
_updateScrollbarPadding()
{if(this._inline)
return;let scrollbarWidth=this._scrollContainerElement.offsetWidth-this._scrollContainerElement.scrollWidth;if(this._scrollbarWidth===scrollbarWidth)
return;if(WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL)
this._headerWrapperElement.style.setProperty("padding-left",`${scrollbarWidth}px`);else
this._headerWrapperElement.style.setProperty("padding-right",`${scrollbarWidth}px`);this._scrollbarWidth=scrollbarWidth;}
static createSortableDataGrid(columnNames,values)
{var numColumns=columnNames.length;if(!numColumns)
return null;var columnsData={};for(var columnName of columnNames){columnsData[columnName]={width:columnName.length,title:columnName,sortable:true,};}
var dataGrid=new WebInspector.DataGrid(columnsData,undefined,undefined,columnNames);for(var i=0;i<values.length/numColumns;++i){var data={};for(var j=0;j<columnNames.length;++j)
data[columnNames[j]]=values[numColumns*i+j];var node=new WebInspector.DataGridNode(data,false);dataGrid.appendChild(node);}
function sortDataGrid()
{var sortColumnIdentifier=dataGrid.sortColumnIdentifier;var columnIsNumeric=true;for(var node of dataGrid.children){var value=dataGrid.textForDataGridNodeColumn(node,sortColumnIdentifier);if(isNaN(Number(value)))
columnIsNumeric=false;}
function comparator(dataGridNode1,dataGridNode2)
{var item1=dataGrid.textForDataGridNodeColumn(dataGridNode1,sortColumnIdentifier);var item2=dataGrid.textForDataGridNodeColumn(dataGridNode2,sortColumnIdentifier);var comparison;if(columnIsNumeric){var number1=parseFloat(item1);var number2=parseFloat(item2);comparison=number1<number2?-1:(number1>number2?1:0);}else
comparison=item1<item2?-1:(item1>item2?1:0);return comparison;}
dataGrid.sortNodes(comparator);}
dataGrid.addEventListener(WebInspector.DataGrid.Event.SortChanged,sortDataGrid,this);dataGrid.sortOrder=WebInspector.DataGrid.SortOrder.Ascending;dataGrid.sortColumnIdentifier=columnNames[0];return dataGrid;}
get headerVisible(){return this._headerVisible;}
set headerVisible(x)
{if(x===this._headerVisible)
return;this._headerVisible=x;this.element.classList.toggle("no-header",!this._headerVisible);}
get columnChooserEnabled(){return this._columnChooserEnabled;}
set columnChooserEnabled(x){this._columnChooserEnabled=x;}
get refreshCallback()
{return this._refreshCallback;}
set refreshCallback(refreshCallback)
{this._refreshCallback=refreshCallback;}
get sortOrder()
{return this._sortOrder;}
set sortOrder(order)
{if(!order||order===this._sortOrder)
return;this._sortOrder=order;if(this._sortOrderSetting)
this._sortOrderSetting.value=this._sortOrder;if(!this._sortColumnIdentifier)
return;var sortHeaderCellElement=this._headerTableCellElements.get(this._sortColumnIdentifier);sortHeaderCellElement.classList.toggle(WebInspector.DataGrid.SortColumnAscendingStyleClassName,this._sortOrder===WebInspector.DataGrid.SortOrder.Ascending);sortHeaderCellElement.classList.toggle(WebInspector.DataGrid.SortColumnDescendingStyleClassName,this._sortOrder===WebInspector.DataGrid.SortOrder.Descending);this.dispatchEventToListeners(WebInspector.DataGrid.Event.SortChanged);}
get sortColumnIdentifier()
{return this._sortColumnIdentifier;}
set sortColumnIdentifier(columnIdentifier)
{if(this._sortColumnIdentifier===columnIdentifier)
return;let oldSortColumnIdentifier=this._sortColumnIdentifier;this._sortColumnIdentifier=columnIdentifier;this._updateSortedColumn(oldSortColumnIdentifier);}
get inline(){return this._inline;}
set inline(x)
{if(this._inline===x)
return;this._inline=x||false;this._element.classList.toggle("inline",this._inline);this._updateScrollListeners();}
get variableHeightRows(){return this._variableHeightRows;}
set variableHeightRows(x)
{if(this._variableHeightRows===x)
return;this._variableHeightRows=x||false;this._element.classList.toggle("variable-height-rows",this._variableHeightRows);this._updateScrollListeners();}
get filterText(){return this._filterText;}
set filterText(x)
{if(this._filterText===x)
return;this._filterText=x;this.filterDidChange();}
get filterDelegate(){return this._filterDelegate;}
set filterDelegate(delegate)
{this._filterDelegate=delegate;this.filterDidChange();}
filterDidChange()
{if(this._scheduledFilterUpdateIdentifier)
return;if(this._applyFilterToNodesTask){this._applyFilterToNodesTask.cancel();this._applyFilterToNodesTask=null;}
this._scheduledFilterUpdateIdentifier=requestAnimationFrame(this._updateFilter.bind(this));}
hasFilters()
{return this._textFilterRegex||this._hasFilterDelegate();}
matchNodeAgainstCustomFilters(node)
{if(!this._hasFilterDelegate())
return true;return this._filterDelegate.dataGridMatchNodeAgainstCustomFilters(node);}
createSettings(identifier)
{if(this._settingsIdentifier===identifier)
return;this._settingsIdentifier=identifier;this._sortColumnIdentifierSetting=new WebInspector.Setting(this._settingsIdentifier+"-sort",this._sortColumnIdentifier);this._sortOrderSetting=new WebInspector.Setting(this._settingsIdentifier+"-sort-order",this._sortOrder);this._columnVisibilitySetting=new WebInspector.Setting(this._settingsIdentifier+"-column-visibility",{});if(!this.columns)
return;if(this._sortColumnIdentifierSetting.value){this.sortColumnIdentifier=this._sortColumnIdentifierSetting.value;this.sortOrder=this._sortOrderSetting.value;}
let visibilitySettings=this._columnVisibilitySetting.value;for(let columnIdentifier in visibilitySettings){let visible=visibilitySettings[columnIdentifier];this.setColumnVisible(columnIdentifier,visible);}}
_updateScrollListeners()
{if(this._inline||this._variableHeightRows){this._scrollContainerElement.removeEventListener("scroll",this._scrollListener);this._scrollContainerElement.removeEventListener("mousewheel",this._scrollListener);}else{this._scrollContainerElement.addEventListener("scroll",this._scrollListener);this._scrollContainerElement.addEventListener("mousewheel",this._scrollListener);}}
_applyFiltersToNodeAndDispatchEvent(node)
{const nodeWasHidden=node.hidden;this._applyFiltersToNode(node);if(nodeWasHidden!==node.hidden)
this.dispatchEventToListeners(WebInspector.DataGrid.Event.NodeWasFiltered,{node});return nodeWasHidden!==node.hidden;}
_applyFiltersToNode(node)
{if(!this.hasFilters()){node.hidden=false;if(node.expanded&&node[WebInspector.DataGrid.WasExpandedDuringFilteringSymbol]){node[WebInspector.DataGrid.WasExpandedDuringFilteringSymbol]=false;node.collapse();}
return;}
let filterableData=node.filterableData||[];let flags={expandNode:false};let filterRegex=this._textFilterRegex;function matchTextFilter()
{if(!filterableData.length||!filterRegex)
return true;if(filterableData.some((value)=>filterRegex.test(value))){flags.expandNode=true;return true;}
return false;}
function makeVisible()
{node.hidden=false;let currentAncestor=node.parent;while(currentAncestor&&!currentAncestor.root){currentAncestor.hidden=false;if(flags.expandNode&&!currentAncestor.expanded){currentAncestor[WebInspector.DataGrid.WasExpandedDuringFilteringSymbol]=true;currentAncestor.expand();}
currentAncestor=currentAncestor.parent;}}
if(matchTextFilter()&&this.matchNodeAgainstCustomFilters(node)){makeVisible();if(!flags.expandNode&&node.expanded&&node[WebInspector.DataGrid.WasExpandedDuringFilteringSymbol]){node[WebInspector.DataGrid.WasExpandedDuringFilteringSymbol]=false;node.collapse();}
return;}
node.hidden=true;}
_updateSortedColumn(oldSortColumnIdentifier)
{if(this._sortColumnIdentifierSetting)
this._sortColumnIdentifierSetting.value=this._sortColumnIdentifier;if(oldSortColumnIdentifier){let oldSortHeaderCellElement=this._headerTableCellElements.get(oldSortColumnIdentifier);oldSortHeaderCellElement.classList.remove(WebInspector.DataGrid.SortColumnAscendingStyleClassName);oldSortHeaderCellElement.classList.remove(WebInspector.DataGrid.SortColumnDescendingStyleClassName);}
if(this._sortColumnIdentifier){let newSortHeaderCellElement=this._headerTableCellElements.get(this._sortColumnIdentifier);newSortHeaderCellElement.classList.toggle(WebInspector.DataGrid.SortColumnAscendingStyleClassName,this._sortOrder===WebInspector.DataGrid.SortOrder.Ascending);newSortHeaderCellElement.classList.toggle(WebInspector.DataGrid.SortColumnDescendingStyleClassName,this._sortOrder===WebInspector.DataGrid.SortOrder.Descending);}
this.dispatchEventToListeners(WebInspector.DataGrid.Event.SortChanged);}
_hasFilterDelegate()
{return this._filterDelegate&&typeof this._filterDelegate.dataGridMatchNodeAgainstCustomFilters==="function";}
_ondblclick(event)
{if(this._editing||this._editingNode)
return;this._startEditing(event.target);}
_startEditingNodeAtColumnIndex(node,columnIndex)
{this._editing=true;this._editingNode=node;this._editingNode.select();var element=this._editingNode._element.children[columnIndex];WebInspector.startEditing(element,this._startEditingConfig(element));window.getSelection().setBaseAndExtent(element,0,element,1);}
_startEditing(target)
{var element=target.enclosingNodeOrSelfWithNodeName("td");if(!element)
return;this._editingNode=this.dataGridNodeFromNode(target);if(!this._editingNode){if(!this.placeholderNode)
return;this._editingNode=this.placeholderNode;} 
if(this._editingNode.isPlaceholderNode)
return this._startEditingNodeAtColumnIndex(this._editingNode,0);this._editing=true;WebInspector.startEditing(element,this._startEditingConfig(element));window.getSelection().setBaseAndExtent(element,0,element,1);}
_startEditingConfig(element)
{return new WebInspector.EditingConfig(this._editingCommitted.bind(this),this._editingCancelled.bind(this),element.textContent);}
_editingCommitted(element,newText,oldText,context,moveDirection)
{var columnIdentifier=element.__columnIdentifier;var columnIndex=this.orderedColumns.indexOf(columnIdentifier);var textBeforeEditing=this._editingNode.data[columnIdentifier]||"";var currentEditingNode=this._editingNode;

function determineNextCell(valueDidChange){if(moveDirection==="forward"){if(columnIndex<this.orderedColumns.length-1)
return{shouldSort:false,editingNode:currentEditingNode,columnIndex:columnIndex+1};var nextDataGridNode=currentEditingNode.traverseNextNode(true,null,true);return{shouldSort:true,editingNode:nextDataGridNode||currentEditingNode,columnIndex:0};}
if(moveDirection==="backward"){if(columnIndex>0)
return{shouldSort:false,editingNode:currentEditingNode,columnIndex:columnIndex-1};var previousDataGridNode=currentEditingNode.traversePreviousNode(true,null,true);return{shouldSort:true,editingNode:previousDataGridNode||currentEditingNode,columnIndex:this.orderedColumns.length-1};}
return{shouldSort:true};}
function moveToNextCell(valueDidChange){var moveCommand=determineNextCell.call(this,valueDidChange);if(moveCommand.shouldSort&&this._sortAfterEditingCallback){this._sortAfterEditingCallback();this._sortAfterEditingCallback=null;}
if(moveCommand.editingNode)
this._startEditingNodeAtColumnIndex(moveCommand.editingNode,moveCommand.columnIndex);}
this._editingCancelled(element);currentEditingNode.data[columnIdentifier]=newText.trim();this._editCallback(currentEditingNode,columnIdentifier,textBeforeEditing,newText,moveDirection);var textDidChange=textBeforeEditing.trim()!==newText.trim();moveToNextCell.call(this,textDidChange);}
_editingCancelled(element)
{this._editingNode.refresh();this._editing=false;this._editingNode=null;}
autoSizeColumns(minPercent,maxPercent,maxDescentLevel)
{if(minPercent)
minPercent=Math.min(minPercent,Math.floor(100/this.orderedColumns.length));var widths={};for(var[identifier,column]of this.columns)
widths[identifier]=(column["title"]||"").length;var children=maxDescentLevel?this._enumerateChildren(this,[],maxDescentLevel+1):this.children;for(var node of children){for(var identifier of this.columns.keys()){var text=this.textForDataGridNodeColumn(node,identifier);if(text.length>widths[identifier])
widths[identifier]=text.length;}}
var totalColumnWidths=0;for(var identifier of this.columns.keys())
totalColumnWidths+=widths[identifier];var recoupPercent=0;for(var identifier of this.columns.keys()){var width=Math.round(100*widths[identifier]/totalColumnWidths);if(minPercent&&width<minPercent){recoupPercent+=(minPercent-width);width=minPercent;}else if(maxPercent&&width>maxPercent){recoupPercent-=(width-maxPercent);width=maxPercent;}
widths[identifier]=width;}
while(minPercent&&recoupPercent>0){for(var identifier of this.columns.keys()){if(widths[identifier]>minPercent){--widths[identifier];--recoupPercent;if(!recoupPercent)
break;}}}
while(maxPercent&&recoupPercent<0){for(var identifier of this.columns.keys()){if(widths[identifier]<maxPercent){++widths[identifier];++recoupPercent;if(!recoupPercent)
break;}}}
for(var[identifier,column]of this.columns){column["element"].style.width=widths[identifier]+"%";column["bodyElement"].style.width=widths[identifier]+"%";}
this._columnWidthsInitialized=false;this.needsLayout();}
insertColumn(columnIdentifier,columnData,insertionIndex)
{if(insertionIndex===undefined)
insertionIndex=this.orderedColumns.length;insertionIndex=Number.constrain(insertionIndex,0,this.orderedColumns.length);var listeners=new WebInspector.EventListenerSet(this,"DataGrid column DOM listeners");var column=Object.shallowCopy(columnData);column["listeners"]=listeners;column["ordinal"]=insertionIndex;column["columnIdentifier"]=columnIdentifier;this.orderedColumns.splice(insertionIndex,0,columnIdentifier);for(var[identifier,existingColumn]of this.columns){var ordinal=existingColumn["ordinal"];if(ordinal>=insertionIndex)
existingColumn["ordinal"]=ordinal+1;}
this.columns.set(columnIdentifier,column);if(column["disclosure"])
this.disclosureColumnIdentifier=columnIdentifier;var headerColumnElement=document.createElement("col");if(column["width"])
headerColumnElement.style.width=column["width"];column["element"]=headerColumnElement;var referenceElement=this._headerTableColumnGroupElement.children[insertionIndex];this._headerTableColumnGroupElement.insertBefore(headerColumnElement,referenceElement);var headerCellElement=document.createElement("th");headerCellElement.className=columnIdentifier+"-column";headerCellElement.columnIdentifier=columnIdentifier;if(column["aligned"])
headerCellElement.classList.add(column["aligned"]);this._headerTableCellElements.set(columnIdentifier,headerCellElement);var referenceElement=this._headerTableRowElement.children[insertionIndex];this._headerTableRowElement.insertBefore(headerCellElement,referenceElement);if(column["headerView"]){let headerView=column["headerView"];headerCellElement.appendChild(headerView.element);this.addSubview(headerView);}else{let titleElement=headerCellElement.createChild("div");if(column["titleDOMFragment"])
titleElement.appendChild(column["titleDOMFragment"]);else
titleElement.textContent=column["title"]||"";}
if(column["sortable"]){listeners.register(headerCellElement,"click",this._headerCellClicked);headerCellElement.classList.add(WebInspector.DataGrid.SortableColumnStyleClassName);}
if(column["group"])
headerCellElement.classList.add("column-group-"+column["group"]);if(column["tooltip"])
headerCellElement.title=column["tooltip"];if(column["collapsesGroup"]){headerCellElement.createChild("div","divider");var collapseDiv=headerCellElement.createChild("div","collapser-button");collapseDiv.title=this._collapserButtonCollapseColumnsToolTip();listeners.register(collapseDiv,"mouseover",this._mouseoverColumnCollapser);listeners.register(collapseDiv,"mouseout",this._mouseoutColumnCollapser);listeners.register(collapseDiv,"click",this._clickInColumnCollapser);headerCellElement.collapsesGroup=column["collapsesGroup"];headerCellElement.classList.add("collapser");}
this._headerTableColumnGroupElement.span=this.orderedColumns.length;var dataColumnElement=headerColumnElement.cloneNode();var referenceElement=this._dataTableColumnGroupElement.children[insertionIndex];this._dataTableColumnGroupElement.insertBefore(dataColumnElement,referenceElement);column["bodyElement"]=dataColumnElement;var fillerCellElement=document.createElement("td");fillerCellElement.className=columnIdentifier+"-column";fillerCellElement.__columnIdentifier=columnIdentifier;if(column["group"])
fillerCellElement.classList.add("column-group-"+column["group"]);var referenceElement=this._fillerRowElement.children[insertionIndex];this._fillerRowElement.insertBefore(fillerCellElement,referenceElement);listeners.install();this.setColumnVisible(columnIdentifier,!column.hidden);}
removeColumn(columnIdentifier)
{var removedColumn=this.columns.get(columnIdentifier);this.columns.delete(columnIdentifier);this.orderedColumns.splice(this.orderedColumns.indexOf(columnIdentifier),1);var removedOrdinal=removedColumn["ordinal"];for(var[identifier,column]of this.columns){var ordinal=column["ordinal"];if(ordinal>removedOrdinal)
column["ordinal"]=ordinal-1;}
removedColumn["listeners"].uninstall(true);if(removedColumn["disclosure"])
this.disclosureColumnIdentifier=undefined;if(this.sortColumnIdentifier===columnIdentifier)
this.sortColumnIdentifier=null;this._headerTableCellElements.delete(columnIdentifier);this._headerTableRowElement.children[removedOrdinal].remove();this._headerTableColumnGroupElement.children[removedOrdinal].remove();this._dataTableColumnGroupElement.children[removedOrdinal].remove();this._fillerRowElement.children[removedOrdinal].remove();this._headerTableColumnGroupElement.span=this.orderedColumns.length;for(var child of this.children)
child.refresh();}
_enumerateChildren(rootNode,result,maxLevel)
{if(!rootNode.root)
result.push(rootNode);if(!maxLevel)
return;for(var i=0;i<rootNode.children.length;++i)
this._enumerateChildren(rootNode.children[i],result,maxLevel-1);return result;}





layout()
{if(!this._columnWidthsInitialized&&this.element.offsetWidth){

let headerTableColumnElements=this._headerTableColumnGroupElement.children;let tableWidth=this._dataTableElement.offsetWidth;let numColumns=headerTableColumnElements.length;let cells=this._headerTableBodyElement.rows[0].cells;let columnWidths=[];for(let i=0;i<numColumns;++i){let headerCellElement=cells[i];if(this._isColumnVisible(headerCellElement.columnIdentifier)){let columnWidth=headerCellElement.offsetWidth;let percentWidth=((columnWidth/tableWidth)*100)+"%";columnWidths.push(percentWidth);}else
columnWidths.push(0);}
for(let i=0;i<numColumns;i++){let percentWidth=columnWidths[i];this._headerTableColumnGroupElement.children[i].style.width=percentWidth;this._dataTableColumnGroupElement.children[i].style.width=percentWidth;}
this._columnWidthsInitialized=true;this._updateHeaderAndScrollbar();}
this._updateVisibleRows();}
sizeDidChange()
{this._updateHeaderAndScrollbar();}
_updateHeaderAndScrollbar()
{this._positionResizerElements();this._positionHeaderViews();this._updateScrollbarPadding();this._cachedScrollTop=NaN;this._cachedScrollableOffsetHeight=NaN;}
columnWidthsMap()
{var result={};for(var[identifier,column]of this.columns){var width=this._headerTableColumnGroupElement.children[column["ordinal"]].style.width;result[identifier]=parseFloat(width);}
return result;}
applyColumnWidthsMap(columnWidthsMap)
{for(var[identifier,column]of this.columns){var width=(columnWidthsMap[identifier]||0)+"%";var ordinal=column["ordinal"];this._headerTableColumnGroupElement.children[ordinal].style.width=width;this._dataTableColumnGroupElement.children[ordinal].style.width=width;}
this.needsLayout();}
_isColumnVisible(columnIdentifier)
{return!this.columns.get(columnIdentifier)["hidden"];}
setColumnVisible(columnIdentifier,visible)
{let column=this.columns.get(columnIdentifier);if(!column||visible===!column.hidden)
return;column.element.style.width=visible?column.width:0;column.hidden=!visible;if(this._columnVisibilitySetting){if(this._columnVisibilitySetting.value[columnIdentifier]!==visible){let copy=Object.shallowCopy(this._columnVisibilitySetting.value);copy[columnIdentifier]=visible;this._columnVisibilitySetting.value=copy;}}
this._columnWidthsInitialized=false;this.updateLayout();}
get scrollContainer()
{return this._scrollContainerElement;}
isScrolledToLastRow()
{return this._scrollContainerElement.isScrolledToBottom();}
scrollToLastRow()
{this._scrollContainerElement.scrollTop=this._scrollContainerElement.scrollHeight-this._scrollContainerElement.offsetHeight;}
_positionResizerElements()
{let leadingOffset=0;var previousResizer=null;var numResizers=this.orderedColumns.length-1;

var cells=this._headerTableBodyElement.rows[0].cells;var columnWidths=[];for(var i=0;i<numResizers;++i){leadingOffset+=cells[i].getBoundingClientRect().width;columnWidths.push(leadingOffset);}
for(var i=0;i<numResizers;++i){var resizer=this.resizers[i];if(!resizer){resizer=this.resizers[i]=new WebInspector.Resizer(WebInspector.Resizer.RuleOrientation.Vertical,this);this.element.appendChild(resizer.element);}
leadingOffset=columnWidths[i];if(this._isColumnVisible(this.orderedColumns[i])){resizer.element.style.removeProperty("display");resizer.element.style.setProperty(WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL?"right":"left",`${leadingOffset}px`);resizer[WebInspector.DataGrid.PreviousColumnOrdinalSymbol]=i;if(previousResizer)
previousResizer[WebInspector.DataGrid.NextColumnOrdinalSymbol]=i;previousResizer=resizer;}else{resizer.element.style.setProperty("display","none");resizer[WebInspector.DataGrid.PreviousColumnOrdinalSymbol]=0;resizer[WebInspector.DataGrid.NextColumnOrdinalSymbol]=0;}}
if(previousResizer)
previousResizer[WebInspector.DataGrid.NextColumnOrdinalSymbol]=this.orderedColumns.length-1;}
_positionHeaderViews()
{let leadingOffset=0;let headerViews=[];let offsets=[];let columnWidths=[];for(let columnIdentifier of this.orderedColumns){let column=this.columns.get(columnIdentifier);if(!column)
continue;let columnWidth=this._headerTableCellElements.get(columnIdentifier).offsetWidth;let headerView=column["headerView"];if(headerView){headerViews.push(headerView);offsets.push(leadingOffset);columnWidths.push(columnWidth);}
leadingOffset+=columnWidth;}
for(let i=0;i<headerViews.length;++i){let headerView=headerViews[i];headerView.element.style.setProperty(WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL?"right":"left",`${offsets[i]}px`);headerView.element.style.width=columnWidths[i]+"px";headerView.updateLayout(WebInspector.View.LayoutReason.Resize);}}
_noteRowsChanged()
{this._previousRevealedRowCount=NaN;this.needsLayout();}
_noteRowRemoved(dataGridNode)
{if(this._inline||this._variableHeightRows){
if(dataGridNode.element&&dataGridNode.element.parentNode)
dataGridNode.element.parentNode.removeChild(dataGridNode.element);return;}
this._noteRowsChanged();}
_noteScrollPositionChanged()
{this._cachedScrollTop=NaN;this.needsLayout();}
_updateVisibleRows()
{if(this._inline||this._variableHeightRows){


let nextElement=this.dataTableBodyElement.lastChild;for(let i=this._rows.length-1;i>=0;--i){let rowElement=this._rows[i].element;if(rowElement.nextSibling!==nextElement)
this.dataTableBodyElement.insertBefore(rowElement,nextElement);nextElement=rowElement;}
return;}
let rowHeight=this.rowHeight;let updateOffsetThreshold=rowHeight*5;let overflowPadding=updateOffsetThreshold*3;if(isNaN(this._cachedScrollTop))
this._cachedScrollTop=this._scrollContainerElement.scrollTop;if(isNaN(this._cachedScrollableOffsetHeight))
this._cachedScrollableOffsetHeight=this._scrollContainerElement.offsetHeight;let scrollTop=this._cachedScrollTop;let scrollableOffsetHeight=this._cachedScrollableOffsetHeight;let visibleRowCount=Math.ceil((scrollableOffsetHeight+(overflowPadding*2))/rowHeight);let currentTopMargin=this._topDataTableMarginHeight;let currentBottomMargin=this._bottomDataTableMarginHeight;let currentTableBottom=currentTopMargin+(visibleRowCount*rowHeight);let belowTopThreshold=!currentTopMargin||scrollTop>currentTopMargin+updateOffsetThreshold;let aboveBottomThreshold=!currentBottomMargin||scrollTop+scrollableOffsetHeight<currentTableBottom-updateOffsetThreshold;if(belowTopThreshold&&aboveBottomThreshold&&!isNaN(this._previousRevealedRowCount))
return;let revealedRows=this._rows.filter((row)=>row.revealed&&!row.hidden);this._previousRevealedRowCount=revealedRows.length;let topHiddenRowCount=Math.max(0,Math.floor((scrollTop-overflowPadding)/rowHeight));let bottomHiddenRowCount=Math.max(0,this._previousRevealedRowCount-topHiddenRowCount-visibleRowCount);let marginTop=topHiddenRowCount*rowHeight;let marginBottom=bottomHiddenRowCount*rowHeight;if(this._topDataTableMarginHeight!==marginTop){this._topDataTableMarginHeight=marginTop;this._topDataTableMarginElement.style.height=marginTop+"px";}
if(this._bottomDataTableMarginElement!==marginBottom){this._bottomDataTableMarginHeight=marginBottom;this._bottomDataTableMarginElement.style.height=marginBottom+"px";}
this._dataTableElement.classList.toggle("odd-first-zebra-stripe",!!(topHiddenRowCount%2));this.dataTableBodyElement.removeChildren();for(let i=topHiddenRowCount;i<topHiddenRowCount+visibleRowCount;++i){let rowDataGridNode=revealedRows[i];if(!rowDataGridNode)
continue;this.dataTableBodyElement.appendChild(rowDataGridNode.element);}
this.dataTableBodyElement.appendChild(this._fillerRowElement);}
addPlaceholderNode()
{if(this.placeholderNode)
this.placeholderNode.makeNormal();var emptyData={};for(var identifier of this.columns.keys())
emptyData[identifier]="";this.placeholderNode=new WebInspector.PlaceholderDataGridNode(emptyData);this.appendChild(this.placeholderNode);}
appendChild(child)
{this.insertChild(child,this.children.length);}
insertChild(child,index)
{if(!child)
return;if(child.parent===this)
return;if(child.parent)
child.parent.removeChild(child);this.children.splice(index,0,child);this.hasChildren=true;child.parent=this;child.dataGrid=this.dataGrid;child._recalculateSiblings(index);delete child._depth;delete child._revealed;delete child._attached;delete child._leftPadding;child._shouldRefreshChildren=true;var current=child.children[0];while(current){current.dataGrid=this.dataGrid;delete current._depth;delete current._revealed;delete current._attached;delete current._leftPadding;current._shouldRefreshChildren=true;current=current.traverseNextNode(false,child,true);}
if(this.expanded)
child._attach();if(!this.dataGrid.hasFilters())
return;this.dataGrid._applyFiltersToNodeAndDispatchEvent(child);}
removeChild(child)
{if(!child)
return;if(child.parent!==this)
return;child.deselect();child._detach();this.children.remove(child,true);if(child.previousSibling)
child.previousSibling.nextSibling=child.nextSibling;if(child.nextSibling)
child.nextSibling.previousSibling=child.previousSibling;child.dataGrid=null;child.parent=null;child.nextSibling=null;child.previousSibling=null;if(this.children.length<=0)
this.hasChildren=false;}
removeChildren()
{for(var i=0;i<this.children.length;++i){var child=this.children[i];child.deselect();child._detach();child.dataGrid=null;child.parent=null;child.nextSibling=null;child.previousSibling=null;}
this.children=[];this.hasChildren=false;}
removeChildrenRecursive()
{var childrenToRemove=this.children;var child=this.children[0];while(child){if(child.children.length)
childrenToRemove=childrenToRemove.concat(child.children);child=child.traverseNextNode(false,this,true);}
for(var i=0;i<childrenToRemove.length;++i){child=childrenToRemove[i];child.deselect();child._detach();child.children=[];child.dataGrid=null;child.parent=null;child.nextSibling=null;child.previousSibling=null;}
this.children=[];}
findNode(comparator,skipHidden,stayWithin,dontPopulate)
{let currentNode=this._rows[0];while(currentNode&&!currentNode.root){if(!currentNode.isPlaceholderNode&&!(skipHidden&&currentNode.hidden)){if(comparator(currentNode))
return currentNode;}
currentNode=currentNode.traverseNextNode(skipHidden,stayWithin,dontPopulate);}
return null;}
sortNodes(comparator)
{if(this._sortNodesRequestId)
return;this._sortNodesRequestId=window.requestAnimationFrame(this._sortNodesCallback.bind(this,comparator));}
sortNodesImmediately(comparator)
{this._sortNodesCallback(comparator);}
_sortNodesCallback(comparator)
{function comparatorWrapper(aNode,bNode)
{if(aNode.isPlaceholderNode)
return 1;if(bNode.isPlaceholderNode)
return-1;var reverseFactor=this.sortOrder!==WebInspector.DataGrid.SortOrder.Ascending?-1:1;return reverseFactor*comparator(aNode,bNode);}
this._sortNodesRequestId=undefined;if(this._editing){this._sortAfterEditingCallback=this.sortNodes.bind(this,comparator);return;}
this._rows.sort(comparatorWrapper.bind(this));this._noteRowsChanged();let previousSiblingNode=null;for(let node of this._rows){node.previousSibling=previousSiblingNode;if(previousSiblingNode)
previousSiblingNode.nextSibling=node;previousSiblingNode=node;}
if(previousSiblingNode)
previousSiblingNode.nextSibling=null;if(!this.parentView)
this.updateLayoutIfNeeded();}
_toggledSortOrder()
{return this._sortOrder!==WebInspector.DataGrid.SortOrder.Descending?WebInspector.DataGrid.SortOrder.Descending:WebInspector.DataGrid.SortOrder.Ascending;}
_selectSortColumnAndSetOrder(columnIdentifier,sortOrder)
{this.sortColumnIdentifier=columnIdentifier;this.sortOrder=sortOrder;}
_keyDown(event)
{if(!this.selectedNode||event.shiftKey||event.metaKey||event.ctrlKey||this._editing)
return;let isRTL=WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL;var handled=false;var nextSelectedNode;if(event.keyIdentifier==="Up"&&!event.altKey){nextSelectedNode=this.selectedNode.traversePreviousNode(true);while(nextSelectedNode&&!nextSelectedNode.selectable)
nextSelectedNode=nextSelectedNode.traversePreviousNode(true);handled=nextSelectedNode?true:false;}else if(event.keyIdentifier==="Down"&&!event.altKey){nextSelectedNode=this.selectedNode.traverseNextNode(true);while(nextSelectedNode&&!nextSelectedNode.selectable)
nextSelectedNode=nextSelectedNode.traverseNextNode(true);handled=nextSelectedNode?true:false;}else if((!isRTL&&event.keyIdentifier==="Left")||(isRTL&&event.keyIdentifier==="Right")){if(this.selectedNode.expanded){if(event.altKey)
this.selectedNode.collapseRecursively();else
this.selectedNode.collapse();handled=true;}else if(this.selectedNode.parent&&!this.selectedNode.parent.root){handled=true;if(this.selectedNode.parent.selectable){nextSelectedNode=this.selectedNode.parent;handled=nextSelectedNode?true:false;}else if(this.selectedNode.parent)
this.selectedNode.parent.collapse();}}else if((!isRTL&&event.keyIdentifier==="Right")||(isRTL&&event.keyIdentifier==="Left")){if(!this.selectedNode.revealed){this.selectedNode.reveal();handled=true;}else if(this.selectedNode.hasChildren){handled=true;if(this.selectedNode.expanded){nextSelectedNode=this.selectedNode.children[0];handled=nextSelectedNode?true:false;}else{if(event.altKey)
this.selectedNode.expandRecursively();else
this.selectedNode.expand();}}}else if(event.keyCode===8||event.keyCode===46){if(this._deleteCallback){handled=true;this._deleteCallback(this.selectedNode);}}else if(isEnterKey(event)){if(this._editCallback){handled=true;this._startEditing(this.selectedNode._element.children[0]);}}
if(nextSelectedNode){nextSelectedNode.reveal();nextSelectedNode.select();}
if(handled){event.preventDefault();event.stopPropagation();}}
closed()
{}
expand()
{}
collapse()
{}
reveal()
{}
revealAndSelect()
{}
dataGridNodeFromNode(target)
{var rowElement=target.enclosingNodeOrSelfWithNodeName("tr");return rowElement&&rowElement._dataGridNode;}
dataGridNodeFromPoint(x,y)
{var node=this._dataTableElement.ownerDocument.elementFromPoint(x,y);var rowElement=node.enclosingNodeOrSelfWithNodeName("tr");return rowElement&&rowElement._dataGridNode;}
_headerCellClicked(event)
{let cell=event.target.enclosingNodeOrSelfWithNodeName("th");if(!cell||!cell.columnIdentifier||!cell.classList.contains(WebInspector.DataGrid.SortableColumnStyleClassName))
return;let sortOrder=this._sortColumnIdentifier===cell.columnIdentifier?this._toggledSortOrder():this.sortOrder;this._selectSortColumnAndSetOrder(cell.columnIdentifier,sortOrder);}
_mouseoverColumnCollapser(event)
{var cell=event.target.enclosingNodeOrSelfWithNodeName("th");if(!cell||!cell.collapsesGroup)
return;cell.classList.add("mouse-over-collapser");}
_mouseoutColumnCollapser(event)
{var cell=event.target.enclosingNodeOrSelfWithNodeName("th");if(!cell||!cell.collapsesGroup)
return;cell.classList.remove("mouse-over-collapser");}
_clickInColumnCollapser(event)
{var cell=event.target.enclosingNodeOrSelfWithNodeName("th");if(!cell||!cell.collapsesGroup)
return;this._collapseColumnGroupWithCell(cell);event.stopPropagation();event.preventDefault();}
collapseColumnGroup(columnGroup)
{var collapserColumnIdentifier=null;for(var[identifier,column]of this.columns){if(column["collapsesGroup"]===columnGroup){collapserColumnIdentifier=identifier;break;}}
if(!collapserColumnIdentifier)
return;var cell=this._headerTableCellElements.get(collapserColumnIdentifier);this._collapseColumnGroupWithCell(cell);}
_collapseColumnGroupWithCell(cell)
{var columnsWillCollapse=cell.classList.toggle("collapsed");this.willToggleColumnGroup(cell.collapsesGroup,columnsWillCollapse);for(var[identifier,column]of this.columns){if(column["group"]===cell.collapsesGroup)
this.setColumnVisible(identifier,!columnsWillCollapse);}
var collapserButton=cell.querySelector(".collapser-button");if(collapserButton)
collapserButton.title=columnsWillCollapse?this._collapserButtonExpandColumnsToolTip():this._collapserButtonCollapseColumnsToolTip();this.didToggleColumnGroup(cell.collapsesGroup,columnsWillCollapse);}
_collapserButtonCollapseColumnsToolTip()
{return WebInspector.UIString("Collapse columns");}
_collapserButtonExpandColumnsToolTip()
{return WebInspector.UIString("Expand columns");}
willToggleColumnGroup(columnGroup,willCollapse)
{}
didToggleColumnGroup(columnGroup,didCollapse)
{}
headerTableHeader(columnIdentifier)
{return this._headerTableCellElements.get(columnIdentifier);}
_mouseDownInDataTable(event)
{var gridNode=this.dataGridNodeFromNode(event.target);if(!gridNode||!gridNode.selectable)
return;if(gridNode.isEventWithinDisclosureTriangle(event))
return;if(event.metaKey){if(gridNode.selected)
gridNode.deselect();else
gridNode.select();}else
gridNode.select();}
_contextMenuInHeader(event)
{let contextMenu=WebInspector.ContextMenu.createFromEvent(event);if(this._hasCopyableData())
contextMenu.appendItem(WebInspector.UIString("Copy Table"),this._copyTable.bind(this));let headerCellElement=event.target.enclosingNodeOrSelfWithNodeName("th");if(!headerCellElement)
return;let columnIdentifier=headerCellElement.columnIdentifier;let column=this.columns.get(columnIdentifier);if(!column)
return;if(column.sortable){contextMenu.appendSeparator();if(this.sortColumnIdentifier!==columnIdentifier||this.sortOrder!==WebInspector.DataGrid.SortOrder.Ascending){contextMenu.appendItem(WebInspector.UIString("Sort Ascending"),()=>{this._selectSortColumnAndSetOrder(columnIdentifier,WebInspector.DataGrid.SortOrder.Ascending);});}
if(this.sortColumnIdentifier!==columnIdentifier||this.sortOrder!==WebInspector.DataGrid.SortOrder.Descending){contextMenu.appendItem(WebInspector.UIString("Sort Descending"),()=>{this._selectSortColumnAndSetOrder(columnIdentifier,WebInspector.DataGrid.SortOrder.Descending);});}}
if(this._columnChooserEnabled){let didAddSeparator=false;for(let[identifier,columnInfo]of this.columns){if(columnInfo.locked)
continue;if(!didAddSeparator){contextMenu.appendSeparator();didAddSeparator=true;}
contextMenu.appendCheckboxItem(columnInfo.title,()=>{this.setColumnVisible(identifier,!!columnInfo.hidden);},!columnInfo.hidden);}}}
_contextMenuInDataTable(event)
{let contextMenu=WebInspector.ContextMenu.createFromEvent(event);let gridNode=this.dataGridNodeFromNode(event.target);if(gridNode)
gridNode.appendContextMenuItems(contextMenu);if(this.dataGrid._refreshCallback&&(!gridNode||gridNode!==this.placeholderNode))
contextMenu.appendItem(WebInspector.UIString("Refresh"),this._refreshCallback.bind(this));if(gridNode){if(gridNode.selectable&&gridNode.copyable&&!gridNode.isEventWithinDisclosureTriangle(event)){contextMenu.appendItem(WebInspector.UIString("Copy Row"),this._copyRow.bind(this,event.target));contextMenu.appendItem(WebInspector.UIString("Copy Table"),this._copyTable.bind(this));if(this.dataGrid._editCallback){if(gridNode===this.placeholderNode)
contextMenu.appendItem(WebInspector.UIString("Add New"),this._startEditing.bind(this,event.target));else{let element=event.target.enclosingNodeOrSelfWithNodeName("td");let columnIdentifier=element.__columnIdentifier;let columnTitle=this.dataGrid.columns.get(columnIdentifier)["title"];contextMenu.appendItem(WebInspector.UIString("Edit “%s”").format(columnTitle),this._startEditing.bind(this,event.target));}}
if(this.dataGrid._deleteCallback&&gridNode!==this.placeholderNode)
contextMenu.appendItem(WebInspector.UIString("Delete"),this._deleteCallback.bind(this,gridNode));}
if(gridNode.children.some((child)=>child.hasChildren)||(gridNode.hasChildren&&!gridNode.children.length)){contextMenu.appendSeparator();contextMenu.appendItem(WebInspector.UIString("Expand All"),gridNode.expandRecursively.bind(gridNode));contextMenu.appendItem(WebInspector.UIString("Collapse All"),gridNode.collapseRecursively.bind(gridNode));}}}
_clickInDataTable(event)
{var gridNode=this.dataGridNodeFromNode(event.target);if(!gridNode||!gridNode.hasChildren)
return;if(!gridNode.isEventWithinDisclosureTriangle(event))
return;if(gridNode.expanded){if(event.altKey)
gridNode.collapseRecursively();else
gridNode.collapse();}else{if(event.altKey)
gridNode.expandRecursively();else
gridNode.expand();}}
textForDataGridNodeColumn(node,columnIdentifier)
{var data=node.data[columnIdentifier];return(data instanceof Node?data.textContent:data)||"";}
set copyTextDelimiter(value){this._copyTextDelimiter=value;}
_copyTextForDataGridNode(node)
{let fields=node.dataGrid.orderedColumns.map((identifier)=>this.textForDataGridNodeColumn(node,identifier));return fields.join(this._copyTextDelimiter);}
_copyTextForDataGridHeaders()
{let fields=this.orderedColumns.map((identifier)=>this.headerTableHeader(identifier).textContent);return fields.join(this._copyTextDelimiter);}
handleBeforeCopyEvent(event)
{if(this.selectedNode&&window.getSelection().isCollapsed)
event.preventDefault();}
handleCopyEvent(event)
{if(!this.selectedNode||!window.getSelection().isCollapsed)
return;var copyText=this._copyTextForDataGridNode(this.selectedNode);event.clipboardData.setData("text/plain",copyText);event.stopPropagation();event.preventDefault();}
_copyRow(target)
{var gridNode=this.dataGridNodeFromNode(target);if(!gridNode)
return;var copyText=this._copyTextForDataGridNode(gridNode);InspectorFrontendHost.copyText(copyText);}
_copyTable()
{let copyData=[];copyData.push(this._copyTextForDataGridHeaders());for(let gridNode of this.children){if(!gridNode.copyable)
continue;copyData.push(this._copyTextForDataGridNode(gridNode));}
InspectorFrontendHost.copyText(copyData.join("\n"));}
_hasCopyableData()
{let gridNode=this.children[0];return gridNode&&gridNode.selectable&&gridNode.copyable;}
get resizeMethod()
{if(!this._resizeMethod)
return WebInspector.DataGrid.ResizeMethod.Nearest;return this._resizeMethod;}
set resizeMethod(method)
{this._resizeMethod=method;}
resizerDragStarted(resizer)
{if(!resizer[WebInspector.DataGrid.NextColumnOrdinalSymbol])
return true;this._currentResizer=resizer;}
resizerDragging(resizer,positionDelta)
{if(resizer!==this._currentResizer)
return;let isRTL=WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL;if(isRTL)
positionDelta*=-1;let dragPoint=0;if(isRTL)
dragPoint+=this.element.totalOffsetRight-resizer.initialPosition-positionDelta;else
dragPoint+=resizer.initialPosition-this.element.totalOffsetLeft-positionDelta;
var leftColumnIndex=resizer[WebInspector.DataGrid.PreviousColumnOrdinalSymbol];var rightColumnIndex=resizer[WebInspector.DataGrid.NextColumnOrdinalSymbol];var firstRowCells=this._headerTableBodyElement.rows[0].cells;let leadingEdgeOfPreviousColumn=0;for(let i=0;i<leftColumnIndex;++i)
leadingEdgeOfPreviousColumn+=firstRowCells[i].offsetWidth; if(this.resizeMethod===WebInspector.DataGrid.ResizeMethod.Last){rightColumnIndex=this.resizers.length;}else if(this.resizeMethod===WebInspector.DataGrid.ResizeMethod.First){leadingEdgeOfPreviousColumn+=firstRowCells[leftColumnIndex].offsetWidth-firstRowCells[0].offsetWidth;leftColumnIndex=0;}
let trailingEdgeOfNextColumn=leadingEdgeOfPreviousColumn+firstRowCells[leftColumnIndex].offsetWidth+firstRowCells[rightColumnIndex].offsetWidth;let leftMinimum=leadingEdgeOfPreviousColumn+WebInspector.DataGrid.ColumnResizePadding;let rightMaximum=trailingEdgeOfNextColumn-WebInspector.DataGrid.ColumnResizePadding;dragPoint=Number.constrain(dragPoint,leftMinimum,rightMaximum);resizer.element.style.setProperty(isRTL?"right":"left",`${dragPoint - this.CenterResizerOverBorderAdjustment}px`);let percentLeftColumn=(((dragPoint-leadingEdgeOfPreviousColumn)/this._dataTableElement.offsetWidth)*100)+"%";this._headerTableColumnGroupElement.children[leftColumnIndex].style.width=percentLeftColumn;this._dataTableColumnGroupElement.children[leftColumnIndex].style.width=percentLeftColumn;let percentRightColumn=(((trailingEdgeOfNextColumn-dragPoint)/this._dataTableElement.offsetWidth)*100)+"%";this._headerTableColumnGroupElement.children[rightColumnIndex].style.width=percentRightColumn;this._dataTableColumnGroupElement.children[rightColumnIndex].style.width=percentRightColumn;this._positionResizerElements();this._positionHeaderViews();const skipHidden=true;const dontPopulate=true;let leftColumnIdentifier=this.orderedColumns[leftColumnIndex];let rightColumnIdentifier=this.orderedColumns[rightColumnIndex];let child=this.children[0];while(child){child.didResizeColumn(leftColumnIdentifier);child.didResizeColumn(rightColumnIdentifier);child=child.traverseNextNode(skipHidden,this,dontPopulate);}
event.preventDefault();}
resizerDragEnded(resizer)
{if(resizer!==this._currentResizer)
return;this._currentResizer=null;}
_updateFilter()
{if(this._scheduledFilterUpdateIdentifier){cancelAnimationFrame(this._scheduledFilterUpdateIdentifier);this._scheduledFilterUpdateIdentifier=undefined;}
if(!this._rows.length)
return;this._textFilterRegex=simpleGlobStringToRegExp(this._filterText,"i");if(this._applyFilterToNodesTask&&this._applyFilterToNodesTask.processing)
this._applyFilterToNodesTask.cancel();function*createIteratorForNodesToBeFiltered()
{let dontPopulate=!this.hasFilters();let currentNode=this._rows[0];while(currentNode&&!currentNode.root){yield currentNode;currentNode=currentNode.traverseNextNode(false,null,dontPopulate);}}
let items=createIteratorForNodesToBeFiltered.call(this);this._applyFilterToNodesTask=new WebInspector.YieldableTask(this,items,{workInterval:100});this._filterDidModifyNodeWhileProcessingItems=false;this._applyFilterToNodesTask.start();} 
yieldableTaskWillProcessItem(task,node)
{let nodeWasModified=this._applyFiltersToNodeAndDispatchEvent(node);if(nodeWasModified)
this._filterDidModifyNodeWhileProcessingItems=true;}
yieldableTaskDidYield(task,processedItems,elapsedTime)
{if(!this._filterDidModifyNodeWhileProcessingItems)
return;this._filterDidModifyNodeWhileProcessingItems=false;this.dispatchEventToListeners(WebInspector.DataGrid.Event.FilterDidChange);}
yieldableTaskDidFinish(task)
{this._applyFilterToNodesTask=null;}};WebInspector.DataGrid.Event={SortChanged:"datagrid-sort-changed",SelectedNodeChanged:"datagrid-selected-node-changed",ExpandedNode:"datagrid-expanded-node",CollapsedNode:"datagrid-collapsed-node",FilterDidChange:"datagrid-filter-did-change",NodeWasFiltered:"datagrid-node-was-filtered"};WebInspector.DataGrid.ResizeMethod={Nearest:"nearest",First:"first",Last:"last"};WebInspector.DataGrid.SortOrder={Indeterminate:"data-grid-sort-order-indeterminate",Ascending:"data-grid-sort-order-ascending",Descending:"data-grid-sort-order-descending"};WebInspector.DataGrid.PreviousColumnOrdinalSymbol=Symbol("previous-column-ordinal");WebInspector.DataGrid.NextColumnOrdinalSymbol=Symbol("next-column-ordinal");WebInspector.DataGrid.WasExpandedDuringFilteringSymbol=Symbol("was-expanded-during-filtering");WebInspector.DataGrid.ColumnResizePadding=10;WebInspector.DataGrid.CenterResizerOverBorderAdjustment=3;WebInspector.DataGrid.SortColumnAscendingStyleClassName="sort-ascending";WebInspector.DataGrid.SortColumnDescendingStyleClassName="sort-descending";WebInspector.DataGrid.SortableColumnStyleClassName="sortable";WebInspector.DataGridNode=class DataGridNode extends WebInspector.Object
{constructor(data,hasChildren)
{super();this._expanded=false;this._hidden=false;this._selected=false;this._copyable=true;this._shouldRefreshChildren=true;this._data=data||{};this.hasChildren=hasChildren||false;this.children=[];this.dataGrid=null;this.parent=null;this.previousSibling=null;this.nextSibling=null;this.disclosureToggleWidth=10;}
get hidden()
{return this._hidden;}
set hidden(x)
{x=!!x;if(this._hidden===x)
return;this._hidden=x;if(this._element)
this._element.classList.toggle("hidden",this._hidden);if(this.dataGrid)
this.dataGrid._noteRowsChanged();}
get selectable()
{return this._element&&!this._hidden;}
get copyable()
{return this._copyable;}
set copyable(x)
{this._copyable=x;}
get element()
{if(this._element)
return this._element;if(!this.dataGrid)
return null;this._element=document.createElement("tr");this._element._dataGridNode=this;if(this.hasChildren)
this._element.classList.add("parent");if(this.expanded)
this._element.classList.add("expanded");if(this.selected)
this._element.classList.add("selected");if(this.revealed)
this._element.classList.add("revealed");if(this._hidden)
this._element.classList.add("hidden");this.createCells();return this._element;}
createCells()
{for(var columnIdentifier of this.dataGrid.orderedColumns)
this._element.appendChild(this.createCell(columnIdentifier));}
refreshIfNeeded()
{if(!this._needsRefresh)
return;this._needsRefresh=false;this.refresh();}
needsRefresh()
{this._needsRefresh=true;if(!this._revealed)
return;if(this._scheduledRefreshIdentifier)
return;this._scheduledRefreshIdentifier=requestAnimationFrame(this.refresh.bind(this));}
get data()
{return this._data;}
set data(x)
{x=x||{};if(Object.shallowEqual(this._data,x))
return;this._data=x;this.needsRefresh();}
get filterableData()
{if(this._cachedFilterableData)
return this._cachedFilterableData;this._cachedFilterableData=[];for(let column of this.dataGrid.columns.values()){if(column.hidden)
continue;let value=this.filterableDataForColumn(column.columnIdentifier);if(!value)
continue;if(!(value instanceof Array))
value=[value];if(!value.length)
continue;this._cachedFilterableData=this._cachedFilterableData.concat(value);}
return this._cachedFilterableData;}
get revealed()
{if("_revealed"in this)
return this._revealed;var currentAncestor=this.parent;while(currentAncestor&&!currentAncestor.root){if(!currentAncestor.expanded){this._revealed=false;return false;}
currentAncestor=currentAncestor.parent;}
this._revealed=true;return true;}
set hasChildren(x)
{if(this._hasChildren===x)
return;this._hasChildren=x;if(!this._element)
return;if(this._hasChildren){this._element.classList.add("parent");if(this.expanded)
this._element.classList.add("expanded");}else
this._element.classList.remove("parent","expanded");}
get hasChildren()
{return this._hasChildren;}
set revealed(x)
{if(this._revealed===x)
return;this._revealed=x;if(this._element){if(this._revealed)
this._element.classList.add("revealed");else
this._element.classList.remove("revealed");}
this.refreshIfNeeded();for(var i=0;i<this.children.length;++i)
this.children[i].revealed=x&&this.expanded;}
get depth()
{if("_depth"in this)
return this._depth;if(this.parent&&!this.parent.root)
this._depth=this.parent.depth+1;else
this._depth=0;return this._depth;}
get indentPadding()
{if(typeof this._indentPadding==="number")
return this._indentPadding;this._indentPadding=this.depth*this.dataGrid.indentWidth;return this._indentPadding;}
get shouldRefreshChildren()
{return this._shouldRefreshChildren;}
set shouldRefreshChildren(x)
{this._shouldRefreshChildren=x;if(x&&this.expanded)
this.expand();}
get selected()
{return this._selected;}
set selected(x)
{if(x)
this.select();else
this.deselect();}
get expanded()
{return this._expanded;}
set expanded(x)
{if(x)
this.expand();else
this.collapse();}
hasAncestor(ancestor)
{if(!ancestor)
return false;let currentAncestor=this.parent;while(currentAncestor){if(ancestor===currentAncestor)
return true;currentAncestor=currentAncestor.parent;}
return false;}
refresh()
{if(!this._element||!this.dataGrid)
return;if(this._scheduledRefreshIdentifier){cancelAnimationFrame(this._scheduledRefreshIdentifier);this._scheduledRefreshIdentifier=undefined;}
this._cachedFilterableData=null;this._needsRefresh=false;this._element.removeChildren();this.createCells();}
refreshRecursively()
{this.refresh();this.forEachChildInSubtree((node)=>node.refresh());}
updateLayout()
{}
createCell(columnIdentifier)
{var cellElement=document.createElement("td");cellElement.className=columnIdentifier+"-column";cellElement.__columnIdentifier=columnIdentifier;var div=cellElement.createChild("div","cell-content");var content=this.createCellContent(columnIdentifier,cellElement);div.append(content);let column=this.dataGrid.columns.get(columnIdentifier);if(column){if(column["aligned"])
cellElement.classList.add(column["aligned"]);if(column["group"])
cellElement.classList.add("column-group-"+column["group"]);if(column["icon"]){let iconElement=document.createElement("div");iconElement.classList.add("icon");div.insertBefore(iconElement,div.firstChild);}}
if(columnIdentifier===this.dataGrid.disclosureColumnIdentifier){cellElement.classList.add("disclosure");if(this.indentPadding){if(WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL)
cellElement.style.setProperty("padding-right",`${this.indentPadding}px`);else
cellElement.style.setProperty("padding-left",`${this.indentPadding}px`);}}
return cellElement;}
createCellContent(columnIdentifier)
{if(!(columnIdentifier in this.data))
return zeroWidthSpace;let data=this.data[columnIdentifier];return(typeof data==="number")?data.maxDecimals(2).toLocaleString():data;}
elementWithColumnIdentifier(columnIdentifier)
{if(!this.dataGrid)
return null;let index=this.dataGrid.orderedColumns.indexOf(columnIdentifier);if(index===-1)
return null;return this.element.children[index];}
appendChild(){return WebInspector.DataGrid.prototype.appendChild.apply(this,arguments);}
insertChild(){return WebInspector.DataGrid.prototype.insertChild.apply(this,arguments);}
removeChild(){return WebInspector.DataGrid.prototype.removeChild.apply(this,arguments);}
removeChildren(){return WebInspector.DataGrid.prototype.removeChildren.apply(this,arguments);}
removeChildrenRecursive(){return WebInspector.DataGrid.prototype.removeChildrenRecursive.apply(this,arguments);}
_recalculateSiblings(myIndex)
{if(!this.parent)
return;var previousChild=myIndex>0?this.parent.children[myIndex-1]:null;if(previousChild){previousChild.nextSibling=this;this.previousSibling=previousChild;}else
this.previousSibling=null;var nextChild=this.parent.children[myIndex+1];if(nextChild){nextChild.previousSibling=this;this.nextSibling=nextChild;}else
this.nextSibling=null;}
collapse()
{if(this._element)
this._element.classList.remove("expanded");this._expanded=false;for(var i=0;i<this.children.length;++i)
this.children[i].revealed=false;this.dispatchEventToListeners("collapsed");if(this.dataGrid){this.dataGrid.dispatchEventToListeners(WebInspector.DataGrid.Event.CollapsedNode,{dataGridNode:this});this.dataGrid._noteRowsChanged();}}
collapseRecursively()
{var item=this;while(item){if(item.expanded)
item.collapse();item=item.traverseNextNode(false,this,true);}}
expand()
{if(!this.hasChildren||this.expanded)
return;if(this.revealed&&!this._shouldRefreshChildren)
for(var i=0;i<this.children.length;++i)
this.children[i].revealed=true;if(this._shouldRefreshChildren){for(var i=0;i<this.children.length;++i)
this.children[i]._detach();this.dispatchEventToListeners("populate");if(this._attached){for(var i=0;i<this.children.length;++i){var child=this.children[i];if(this.revealed)
child.revealed=true;child._attach();}}
this._shouldRefreshChildren=false;}
if(this._element)
this._element.classList.add("expanded");this._expanded=true;this.dispatchEventToListeners("expanded");if(this.dataGrid){this.dataGrid.dispatchEventToListeners(WebInspector.DataGrid.Event.ExpandedNode,{dataGridNode:this});this.dataGrid._noteRowsChanged();}}
expandRecursively()
{var item=this;while(item){item.expand();item=item.traverseNextNode(false,this);}}
forEachImmediateChild(callback)
{for(let node of this.children)
callback(node);}
forEachChildInSubtree(callback)
{let node=this.traverseNextNode(false,this,true);while(node){callback(node);node=node.traverseNextNode(false,this,true);}}
isInSubtreeOfNode(baseNode)
{let node=baseNode;while(node){if(node===this)
return true;node=node.traverseNextNode(false,baseNode,true);}
return false;}
reveal()
{var currentAncestor=this.parent;while(currentAncestor&&!currentAncestor.root){if(!currentAncestor.expanded)
currentAncestor.expand();currentAncestor=currentAncestor.parent;}
this.element.scrollIntoViewIfNeeded(false);this.dispatchEventToListeners("revealed");}
select(suppressSelectedEvent)
{if(!this.dataGrid||!this.selectable||this.selected)
return;let oldSelectedNode=this.dataGrid.selectedNode;if(oldSelectedNode)
oldSelectedNode.deselect(true);this._selected=true;this.dataGrid.selectedNode=this;if(this._element)
this._element.classList.add("selected");if(!suppressSelectedEvent)
this.dataGrid.dispatchEventToListeners(WebInspector.DataGrid.Event.SelectedNodeChanged,{oldSelectedNode});}
revealAndSelect()
{this.reveal();this.select();}
deselect(suppressDeselectedEvent)
{if(!this.dataGrid||this.dataGrid.selectedNode!==this||!this.selected)
return;this._selected=false;this.dataGrid.selectedNode=null;if(this._element)
this._element.classList.remove("selected");if(!suppressDeselectedEvent)
this.dataGrid.dispatchEventToListeners(WebInspector.DataGrid.Event.SelectedNodeChanged,{oldSelectedNode:this});}
traverseNextNode(skipHidden,stayWithin,dontPopulate,info)
{if(!dontPopulate&&this.hasChildren)
this.dispatchEventToListeners("populate");if(info)
info.depthChange=0;var node=(!skipHidden||this.revealed)?this.children[0]:null;if(node&&(!skipHidden||this.expanded)){if(info)
info.depthChange=1;return node;}
if(this===stayWithin)
return null;node=(!skipHidden||this.revealed)?this.nextSibling:null;if(node)
return node;node=this;while(node&&!node.root&&!((!skipHidden||node.revealed)?node.nextSibling:null)&&node.parent!==stayWithin){if(info)
info.depthChange-=1;node=node.parent;}
if(!node)
return null;return(!skipHidden||node.revealed)?node.nextSibling:null;}
traversePreviousNode(skipHidden,dontPopulate)
{var node=(!skipHidden||this.revealed)?this.previousSibling:null;if(!dontPopulate&&node&&node.hasChildren)
node.dispatchEventToListeners("populate");while(node&&((!skipHidden||(node.revealed&&node.expanded))?node.children.lastValue:null)){if(!dontPopulate&&node.hasChildren)
node.dispatchEventToListeners("populate");node=((!skipHidden||(node.revealed&&node.expanded))?node.children.lastValue:null);}
if(node)
return node;if(!this.parent||this.parent.root)
return null;return this.parent;}
isEventWithinDisclosureTriangle(event)
{if(!this.hasChildren)
return false;let cell=event.target.enclosingNodeOrSelfWithNodeName("td");if(!cell||!cell.classList.contains("disclosure"))
return false;let computedStyle=window.getComputedStyle(cell);let start=0;if(WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL)
start+=cell.totalOffsetRight-computedStyle.getPropertyCSSValue("padding-right").getFloatValue(CSSPrimitiveValue.CSS_PX)-this.disclosureToggleWidth;else
start+=cell.totalOffsetLeft+computedStyle.getPropertyCSSValue("padding-left").getFloatValue(CSSPrimitiveValue.CSS_PX);return event.pageX>=start&&event.pageX<=start+this.disclosureToggleWidth;}
_attach()
{if(!this.dataGrid||this._attached)
return;this._attached=true;let insertionIndex=-1;if(!this.isPlaceholderNode){var previousGridNode=this.traversePreviousNode(true,true);insertionIndex=this.dataGrid._rows.indexOf(previousGridNode);if(insertionIndex===-1)
insertionIndex=0;else
insertionIndex++;}
if(insertionIndex===-1)
this.dataGrid._rows.push(this);else
this.dataGrid._rows.insertAtIndex(this,insertionIndex);this.dataGrid._noteRowsChanged();if(this.expanded){for(var i=0;i<this.children.length;++i)
this.children[i]._attach();}}
_detach()
{if(!this._attached)
return;this._attached=false;this.dataGrid._rows.remove(this,true);this.dataGrid._noteRowRemoved(this);for(var i=0;i<this.children.length;++i)
this.children[i]._detach();}
savePosition()
{if(this._savedPosition)
return;if(!this.parent)
return;this._savedPosition={parent:this.parent,index:this.parent.children.indexOf(this)};}
restorePosition()
{if(!this._savedPosition)
return;if(this.parent!==this._savedPosition.parent)
this._savedPosition.parent.insertChild(this,this._savedPosition.index);this._savedPosition=null;}
appendContextMenuItems(contextMenu)
{ return null;} 
filterableDataForColumn(columnIdentifier)
{let value=this.data[columnIdentifier];return typeof value==="string"?value:null;}
didResizeColumn(columnIdentifier)
{}};WebInspector.PlaceholderDataGridNode=class PlaceholderDataGridNode extends WebInspector.DataGridNode
{constructor(data)
{super(data,false);this.isPlaceholderNode=true;}
makeNormal()
{this.isPlaceholderNode=false;}};WebInspector.DetailsSectionRow=class DetailsSectionRow extends WebInspector.Object
{constructor(emptyMessage)
{super();this._element=document.createElement("div");this._element.className="row";this._emptyMessage=emptyMessage||"";} 
get element()
{return this._element;}
get emptyMessage()
{return this._emptyMessage;}
set emptyMessage(emptyMessage)
{this._emptyMessage=emptyMessage||"";if(!this._element.childNodes.length)
this.showEmptyMessage();}
showEmptyMessage()
{this.element.classList.add(WebInspector.DetailsSectionRow.EmptyStyleClassName);if(this._emptyMessage instanceof Node){this.element.removeChildren();this.element.appendChild(this._emptyMessage);}else
this.element.textContent=this._emptyMessage;}
hideEmptyMessage()
{this.element.classList.remove(WebInspector.DetailsSectionRow.EmptyStyleClassName);this.element.removeChildren();}};WebInspector.DetailsSectionRow.EmptyStyleClassName="empty";WebInspector.Dialog=class Dialog extends WebInspector.View
{constructor(delegate)
{super();this._delegate=delegate;this._dismissing=false;this._representedObject=null;this._cookie=null;this._visible=false;} 
get visible(){return this._visible;}
get delegate(){return this._delegate;}
get representedObject(){return this._representedObject;}
get cookie(){return this._cookie;}
present(parentElement)
{parentElement.appendChild(this.element);this._visible=true;this.didPresentDialog();}
dismiss(representedObject,cookie)
{if(this._dismissing)
return;let parent=this.element.parentNode;if(!parent)
return;this._dismissing=true;this._representedObject=representedObject||null;this._cookie=cookie||null;this._visible=false;this.element.remove();if(this._delegate&&typeof this._delegate.dialogWasDismissed==="function")
this._delegate.dialogWasDismissed(this);this._dismissing=false;this.didDismissDialog();} 
didDismissDialog()
{}
didPresetDialog()
{}
representedObjectIsValid(value)
{if(this.delegate&&typeof this.delegate.isDialogRepresentedObjectValid==="function")
return this.delegate.isDialogRepresentedObjectValid(this,value);return true;}};WebInspector.HierarchicalPathComponent=class HierarchicalPathComponent extends WebInspector.Object
{constructor(displayName,styleClassNames,representedObject,textOnly,showSelectorArrows)
{super();this._representedObject=representedObject||null;this._element=document.createElement("div");this._element.className="hierarchical-path-component";if(!Array.isArray(styleClassNames))
styleClassNames=[styleClassNames];this._element.classList.add(...styleClassNames);if(!textOnly){this._iconElement=document.createElement("img");this._iconElement.className="icon";this._element.appendChild(this._iconElement);}else
this._element.classList.add("text-only");this._titleElement=document.createElement("div");this._titleElement.className="title";this._titleElement.setAttribute("dir","auto");this._element.appendChild(this._titleElement);this._titleContentElement=document.createElement("div");this._titleContentElement.className="content";this._titleElement.appendChild(this._titleContentElement);this._separatorElement=document.createElement("div");this._separatorElement.className="separator";this._element.appendChild(this._separatorElement);this._selectElement=document.createElement("select");this._selectElement.setAttribute("dir","auto");this._selectElement.addEventListener("mouseover",this._selectElementMouseOver.bind(this));this._selectElement.addEventListener("mouseout",this._selectElementMouseOut.bind(this));this._selectElement.addEventListener("mousedown",this._selectElementMouseDown.bind(this));this._selectElement.addEventListener("mouseup",this._selectElementMouseUp.bind(this));this._selectElement.addEventListener("change",this._selectElementSelectionChanged.bind(this));this._element.appendChild(this._selectElement);this._previousSibling=null;this._nextSibling=null;this._truncatedDisplayNameLength=0;this._collapsed=false;this._hidden=false;this._selectorArrows=false;this.displayName=displayName;this.selectorArrows=showSelectorArrows;} 
get selectedPathComponent()
{let selectedOption=this._selectElement[this._selectElement.selectedIndex];if(!selectedOption&&this._selectElement.options.length===1)
selectedOption=this._selectElement.options[0];return selectedOption&&selectedOption._pathComponent||null;}
get element(){return this._element;}
get representedObject(){return this._representedObject;}
get displayName()
{return this._displayName;}
set displayName(newDisplayName)
{if(newDisplayName===this._displayName)
return;this._displayName=newDisplayName;this._updateElementTitleAndText();}
get truncatedDisplayNameLength()
{return this._truncatedDisplayNameLength;}
set truncatedDisplayNameLength(truncatedDisplayNameLength)
{truncatedDisplayNameLength=truncatedDisplayNameLength||0;if(truncatedDisplayNameLength===this._truncatedDisplayNameLength)
return;this._truncatedDisplayNameLength=truncatedDisplayNameLength;this._updateElementTitleAndText();}
get minimumWidth()
{if(this._collapsed)
return WebInspector.HierarchicalPathComponent.MinimumWidthCollapsed;if(this._selectorArrows)
return WebInspector.HierarchicalPathComponent.MinimumWidth+WebInspector.HierarchicalPathComponent.SelectorArrowsWidth;return WebInspector.HierarchicalPathComponent.MinimumWidth;}
get forcedWidth()
{let maxWidth=this._element.style.getProperty("width");if(typeof maxWidth==="string")
return parseInt(maxWidth);return null;}
set forcedWidth(width)
{if(typeof width==="number"){let minimumWidthForOneCharacterTruncatedTitle=WebInspector.HierarchicalPathComponent.MinimumWidthForOneCharacterTruncatedTitle;if(this.selectorArrows)
minimumWidthForOneCharacterTruncatedTitle+=WebInspector.HierarchicalPathComponent.SelectorArrowsWidth;
if(width<minimumWidthForOneCharacterTruncatedTitle)
width=0;
this._element.style.setProperty("width",Math.max(1,width)+"px");}else
this._element.style.removeProperty("width");}
get hidden()
{return this._hidden;}
set hidden(flag)
{if(this._hidden===flag)
return;this._hidden=flag;this._element.classList.toggle("hidden",this._hidden);}
get collapsed()
{return this._collapsed;}
set collapsed(flag)
{if(this._collapsed===flag)
return;this._collapsed=flag;this._element.classList.toggle("collapsed",this._collapsed);}
get selectorArrows()
{return this._selectorArrows;}
set selectorArrows(flag)
{if(this._selectorArrows===flag)
return;this._selectorArrows=flag;if(this._selectorArrows){this._selectorArrowsElement=document.createElement("img");this._selectorArrowsElement.className="selector-arrows";this._element.insertBefore(this._selectorArrowsElement,this._separatorElement);}else if(this._selectorArrowsElement){this._selectorArrowsElement.remove();this._selectorArrowsElement=null;}
this._element.classList.toggle("show-selector-arrows",!!this._selectorArrows);}
get previousSibling(){return this._previousSibling;}
set previousSibling(newSlibling){this._previousSibling=newSlibling||null;}
get nextSibling(){return this._nextSibling;}
set nextSibling(newSlibling){this._nextSibling=newSlibling||null;} 
_updateElementTitleAndText()
{let truncatedDisplayName=this._displayName;if(this._truncatedDisplayNameLength&&truncatedDisplayName.length>this._truncatedDisplayNameLength)
truncatedDisplayName=truncatedDisplayName.substring(0,this._truncatedDisplayNameLength)+ellipsis;this._element.title=this._displayName;this._titleContentElement.textContent=truncatedDisplayName;}
_updateSelectElement()
{this._selectElement.removeChildren();function createOption(component)
{let optionElement=document.createElement("option");let maxPopupMenuLength=130; optionElement.textContent=component.displayName.length<=maxPopupMenuLength?component.displayName:component.displayName.substring(0,maxPopupMenuLength)+ellipsis;optionElement._pathComponent=component;return optionElement;}
let previousSiblingCount=0;let sibling=this.previousSibling;while(sibling){this._selectElement.insertBefore(createOption(sibling),this._selectElement.firstChild);sibling=sibling.previousSibling;++previousSiblingCount;}
this._selectElement.appendChild(createOption(this));sibling=this.nextSibling;while(sibling){this._selectElement.appendChild(createOption(sibling));sibling=sibling.nextSibling;}




if(this._selectElement.options.length===1)
this._selectElement.selectedIndex=-1;else
this._selectElement.selectedIndex=previousSiblingCount;}
_selectElementMouseOver(event)
{if(typeof this.mouseOver==="function")
this.mouseOver();}
_selectElementMouseOut(event)
{if(typeof this.mouseOut==="function")
this.mouseOut();}
_selectElementMouseDown(event)
{this._updateSelectElement();}
_selectElementMouseUp(event)
{this.dispatchEventToListeners(WebInspector.HierarchicalPathComponent.Event.Clicked,{pathComponent:this.selectedPathComponent});}
_selectElementSelectionChanged(event)
{this.dispatchEventToListeners(WebInspector.HierarchicalPathComponent.Event.SiblingWasSelected,{pathComponent:this.selectedPathComponent});}};WebInspector.HierarchicalPathComponent.MinimumWidth=32;WebInspector.HierarchicalPathComponent.MinimumWidthCollapsed=24;WebInspector.HierarchicalPathComponent.MinimumWidthForOneCharacterTruncatedTitle=54;WebInspector.HierarchicalPathComponent.SelectorArrowsWidth=12;WebInspector.HierarchicalPathComponent.Event={SiblingWasSelected:"hierarchical-path-component-sibling-was-selected",Clicked:"hierarchical-path-component-clicked"};WebInspector.NavigationItem=class NavigationItem extends WebInspector.Object
{constructor(identifier,role,label)
{super();this._identifier=identifier||null;this._element=document.createElement("div");this._hidden=false;this._parentNavigationBar=null;if(role)
this._element.setAttribute("role",role);if(label)
this._element.setAttribute("aria-label",label);this._element.classList.add(...this._classNames);this._element.navigationItem=this;} 
get identifier(){return this._identifier;}
get element(){return this._element;}
get minimumWidth(){return this._element.realOffsetWidth;}
get parentNavigationBar(){return this._parentNavigationBar;}
updateLayout(expandOnly)
{}
get hidden()
{return this._hidden;}
set hidden(flag)
{if(this._hidden===flag)
return;this._hidden=flag;this._element.classList.toggle("hidden",flag);if(this._parentNavigationBar)
this._parentNavigationBar.needsLayout();} 
get _classNames()
{var classNames=["item"];if(this._identifier)
classNames.push(this._identifier);if(this.additionalClassNames instanceof Array)
classNames=classNames.concat(this.additionalClassNames);return classNames;}};WebInspector.Popover=class Popover extends WebInspector.Object
{constructor(delegate)
{super();this.delegate=delegate;this._edge=null;this._frame=new WebInspector.Rect;this._content=null;this._targetFrame=new WebInspector.Rect;this._anchorPoint=new WebInspector.Point;this._preferredEdges=null;this._resizeHandler=null;this._contentNeedsUpdate=false;this._dismissing=false;this._element=document.createElement("div");this._element.className="popover";this._element.addEventListener("transitionend",this,true);this._container=this._element.appendChild(document.createElement("div"));this._container.className="container";} 
get element()
{return this._element;}
get frame()
{return this._frame;}
get visible()
{return this._element.parentNode===document.body&&!this._element.classList.contains(WebInspector.Popover.FadeOutClassName);}
set frame(frame)
{this._element.style.left=frame.minX()+"px";this._element.style.top=frame.minY()+"px";this._element.style.width=frame.size.width+"px";this._element.style.height=frame.size.height+"px";this._element.style.backgroundSize=frame.size.width+"px "+frame.size.height+"px";this._frame=frame;}
set content(content)
{if(content===this._content)
return;this._content=content;this._contentNeedsUpdate=true;if(this.visible)
this._update(true);}
set windowResizeHandler(resizeHandler)
{this._resizeHandler=resizeHandler;}
update(shouldAnimate=true)
{if(!this.visible)
return;var previouslyFocusedElement=document.activeElement;this._contentNeedsUpdate=true;this._update(shouldAnimate);if(previouslyFocusedElement)
previouslyFocusedElement.focus();}
present(targetFrame,preferredEdges)
{this._targetFrame=targetFrame;this._preferredEdges=preferredEdges;if(!this._content)
return;this._addListenersIfNeeded();this._update();}
presentNewContentWithFrame(content,targetFrame,preferredEdges)
{this._content=content;this._contentNeedsUpdate=true;this._targetFrame=targetFrame;this._preferredEdges=preferredEdges;this._addListenersIfNeeded();var shouldAnimate=this.visible;this._update(shouldAnimate);}
dismiss()
{if(this._dismissing||this._element.parentNode!==document.body)
return;this._dismissing=true;this._isListeningForPopoverEvents=false;window.removeEventListener("mousedown",this,true);window.removeEventListener("scroll",this,true);window.removeEventListener("resize",this,true);window.removeEventListener("keypress",this,true);WebInspector.quickConsole.keyboardShortcutDisabled=false;this._element.classList.add(WebInspector.Popover.FadeOutClassName);if(this.delegate&&typeof this.delegate.willDismissPopover==="function")
this.delegate.willDismissPopover(this);}
handleEvent(event)
{switch(event.type){case"mousedown":case"scroll":if(!this._element.contains(event.target)&&!event.target.enclosingNodeOrSelfWithClass(WebInspector.Popover.IgnoreAutoDismissClassName)&&!event[WebInspector.Popover.EventPreventDismissSymbol]){this.dismiss();}
break;case"resize":if(this._resizeHandler)
this._resizeHandler();break;case"keypress":if(event.keyCode===WebInspector.KeyboardShortcut.Key.Escape.keyCode)
this.dismiss();break;case"transitionend":if(event.target===this._element){document.body.removeChild(this._element);this._element.classList.remove(WebInspector.Popover.FadeOutClassName);this._container.textContent="";if(this.delegate&&typeof this.delegate.didDismissPopover==="function")
this.delegate.didDismissPopover(this);this._dismissing=false;break;}
break;}} 
_update(shouldAnimate)
{if(shouldAnimate)
var previousEdge=this._edge;var targetFrame=this._targetFrame;var preferredEdges=this._preferredEdges;
if(this._element.parentNode!==document.body)
document.body.appendChild(this._element);else
this._element.classList.remove(WebInspector.Popover.FadeOutClassName);this._dismissing=false;if(this._contentNeedsUpdate){this._element.style.removeProperty("left");this._element.style.removeProperty("top");this._element.style.removeProperty("width");this._element.style.removeProperty("height");if(this._edge!==null)
this._element.classList.remove(this._cssClassNameForEdge());this._container.replaceWith(this._content);var popoverBounds=this._element.getBoundingClientRect();this._preferredSize=new WebInspector.Size(Math.ceil(popoverBounds.width),Math.ceil(popoverBounds.height));}
var titleBarOffset=WebInspector.Platform.name==="mac"&&WebInspector.Platform.version.release>=10?22:0;var containerFrame=new WebInspector.Rect(0,titleBarOffset,window.innerWidth,window.innerHeight-titleBarOffset);containerFrame=containerFrame.inset(WebInspector.Popover.ShadowEdgeInsets);var metrics=new Array(preferredEdges.length);for(var edgeName in WebInspector.RectEdge){var edge=WebInspector.RectEdge[edgeName];var item={edge,metrics:this._bestMetricsForEdge(this._preferredSize,targetFrame,containerFrame,edge)};var preferredIndex=preferredEdges.indexOf(edge);if(preferredIndex!==-1)
metrics[preferredIndex]=item;else
metrics.push(item);}
function area(size)
{return size.width*size.height;}
var bestEdge=metrics[0].edge;var bestMetrics=metrics[0].metrics;for(var i=1;i<metrics.length;i++){var itemMetrics=metrics[i].metrics;if(area(itemMetrics.contentSize)>area(bestMetrics.contentSize)){bestEdge=metrics[i].edge;bestMetrics=itemMetrics;}}
var anchorPoint;var bestFrame=bestMetrics.frame.round();this._edge=bestEdge;if(bestFrame===WebInspector.Rect.ZERO_RECT){this.dismiss();}else{switch(bestEdge){case WebInspector.RectEdge.MIN_X:anchorPoint=new WebInspector.Point(bestFrame.size.width-WebInspector.Popover.ShadowPadding,targetFrame.midY()-bestFrame.minY());break;case WebInspector.RectEdge.MAX_X:anchorPoint=new WebInspector.Point(WebInspector.Popover.ShadowPadding,targetFrame.midY()-bestFrame.minY());break;case WebInspector.RectEdge.MIN_Y:anchorPoint=new WebInspector.Point(targetFrame.midX()-bestFrame.minX(),bestFrame.size.height-WebInspector.Popover.ShadowPadding);break;case WebInspector.RectEdge.MAX_Y:anchorPoint=new WebInspector.Point(targetFrame.midX()-bestFrame.minX(),WebInspector.Popover.ShadowPadding);break;}
this._element.classList.add(this._cssClassNameForEdge());if(shouldAnimate&&this._edge===previousEdge)
this._animateFrame(bestFrame,anchorPoint);else{this.frame=bestFrame;this._setAnchorPoint(anchorPoint);this._drawBackground();}
if(this._preferredSize.width<WebInspector.Popover.MinWidth||this._preferredSize.height<WebInspector.Popover.MinHeight)
this._container.classList.add("center");else
this._container.classList.remove("center");}
if(this._contentNeedsUpdate){this._container.textContent="";this._content.replaceWith(this._container);this._container.appendChild(this._content);}
this._contentNeedsUpdate=false;}
_cssClassNameForEdge()
{switch(this._edge){case WebInspector.RectEdge.MIN_X:return"arrow-right";case WebInspector.RectEdge.MAX_X:return"arrow-left";case WebInspector.RectEdge.MIN_Y:return"arrow-down";case WebInspector.RectEdge.MAX_Y:return"arrow-up";}
console.error("Unknown edge.");return"arrow-up";}
_setAnchorPoint(anchorPoint)
{anchorPoint.x=Math.floor(anchorPoint.x);anchorPoint.y=Math.floor(anchorPoint.y);this._anchorPoint=anchorPoint;}
_animateFrame(toFrame,toAnchor)
{var startTime=Date.now();var duration=350;var epsilon=1/(200*duration);var spline=new WebInspector.CubicBezier(0.25,0.1,0.25,1);var fromFrame=this._frame.copy();var fromAnchor=this._anchorPoint.copy();function animatedValue(from,to,progress)
{return from+(to-from)*progress;}
function drawBackground()
{var progress=spline.solve(Math.min((Date.now()-startTime)/duration,1),epsilon);this.frame=new WebInspector.Rect(animatedValue(fromFrame.minX(),toFrame.minX(),progress),animatedValue(fromFrame.minY(),toFrame.minY(),progress),animatedValue(fromFrame.size.width,toFrame.size.width,progress),animatedValue(fromFrame.size.height,toFrame.size.height,progress)).round();this._setAnchorPoint(new WebInspector.Point(animatedValue(fromAnchor.x,toAnchor.x,progress),animatedValue(fromAnchor.y,toAnchor.y,progress)));this._drawBackground();if(progress<1)
requestAnimationFrame(drawBackground.bind(this));}
drawBackground.call(this);}
_drawBackground()
{var scaleFactor=window.devicePixelRatio;var width=this._frame.size.width;var height=this._frame.size.height;var scaledWidth=width*scaleFactor;var scaledHeight=height*scaleFactor;
var scratchCanvas=document.createElement("canvas");scratchCanvas.width=scaledWidth;scratchCanvas.height=scaledHeight;var ctx=scratchCanvas.getContext("2d");ctx.scale(scaleFactor,scaleFactor);
var bounds;var arrowHeight=WebInspector.Popover.AnchorSize.height;switch(this._edge){case WebInspector.RectEdge.MIN_X:bounds=new WebInspector.Rect(0,0,width-arrowHeight,height);break;case WebInspector.RectEdge.MAX_X:bounds=new WebInspector.Rect(arrowHeight,0,width-arrowHeight,height);break;case WebInspector.RectEdge.MIN_Y:bounds=new WebInspector.Rect(0,0,width,height-arrowHeight);break;case WebInspector.RectEdge.MAX_Y:bounds=new WebInspector.Rect(0,arrowHeight,width,height-arrowHeight);break;}
bounds=bounds.inset(WebInspector.Popover.ShadowEdgeInsets);ctx.fillStyle="black";this._drawFrame(ctx,bounds,this._edge,this._anchorPoint);ctx.clip();var fillGradient=ctx.createLinearGradient(0,0,0,height);fillGradient.addColorStop(0,"rgba(255, 255, 255, 0.95)");fillGradient.addColorStop(1,"rgba(235, 235, 235, 0.95)");ctx.fillStyle=fillGradient;ctx.fillRect(0,0,width,height);ctx.strokeStyle="rgba(0, 0, 0, 0.25)";ctx.lineWidth=2;this._drawFrame(ctx,bounds,this._edge,this._anchorPoint);ctx.stroke();let finalContext=document.getCSSCanvasContext("2d","popover",scaledWidth,scaledHeight);finalContext.clearRect(0,0,scaledWidth,scaledHeight);finalContext.shadowOffsetX=1;finalContext.shadowOffsetY=1;finalContext.shadowBlur=5;finalContext.shadowColor="rgba(0, 0, 0, 0.5)";finalContext.drawImage(scratchCanvas,0,0,scaledWidth,scaledHeight);}
_bestMetricsForEdge(preferredSize,targetFrame,containerFrame,edge)
{var x,y;var width=preferredSize.width+(WebInspector.Popover.ShadowPadding*2)+(WebInspector.Popover.ContentPadding*2);var height=preferredSize.height+(WebInspector.Popover.ShadowPadding*2)+(WebInspector.Popover.ContentPadding*2);var arrowLength=WebInspector.Popover.AnchorSize.height;switch(edge){case WebInspector.RectEdge.MIN_X:width+=arrowLength;x=targetFrame.origin.x-width+WebInspector.Popover.ShadowPadding;y=targetFrame.origin.y-(height-targetFrame.size.height)/2;break;case WebInspector.RectEdge.MAX_X:width+=arrowLength;x=targetFrame.origin.x+targetFrame.size.width-WebInspector.Popover.ShadowPadding;y=targetFrame.origin.y-(height-targetFrame.size.height)/2;break;case WebInspector.RectEdge.MIN_Y:height+=arrowLength;x=targetFrame.origin.x-(width-targetFrame.size.width)/2;y=targetFrame.origin.y-height+WebInspector.Popover.ShadowPadding;break;case WebInspector.RectEdge.MAX_Y:height+=arrowLength;x=targetFrame.origin.x-(width-targetFrame.size.width)/2;y=targetFrame.origin.y+targetFrame.size.height-WebInspector.Popover.ShadowPadding;break;}
if(edge===WebInspector.RectEdge.MIN_X||edge===WebInspector.RectEdge.MAX_X){if(y<containerFrame.minY())
y=containerFrame.minY();if(y+height>containerFrame.maxY())
y=containerFrame.maxY()-height;}else{if(x<containerFrame.minX())
x=containerFrame.minX();if(x+width>containerFrame.maxX())
x=containerFrame.maxX()-width;}
var preferredFrame=new WebInspector.Rect(x,y,width,height);var bestFrame=preferredFrame.intersectionWithRect(containerFrame);width=bestFrame.size.width-(WebInspector.Popover.ShadowPadding*2);height=bestFrame.size.height-(WebInspector.Popover.ShadowPadding*2);switch(edge){case WebInspector.RectEdge.MIN_X:case WebInspector.RectEdge.MAX_X:width-=arrowLength;break;case WebInspector.RectEdge.MIN_Y:case WebInspector.RectEdge.MAX_Y:height-=arrowLength;break;}
return{frame:bestFrame,contentSize:new WebInspector.Size(width,height)};}
_drawFrame(ctx,bounds,anchorEdge)
{let cornerRadius=WebInspector.Popover.CornerRadius;let arrowHalfLength=WebInspector.Popover.AnchorSize.width*0.5;let anchorPoint=this._anchorPoint;let arrowPadding=cornerRadius+arrowHalfLength;if(anchorEdge===WebInspector.RectEdge.MIN_Y||anchorEdge===WebInspector.RectEdge.MAX_Y)
anchorPoint.x=Number.constrain(anchorPoint.x,bounds.minX()+arrowPadding,bounds.maxX()-arrowPadding);else
anchorPoint.y=Number.constrain(anchorPoint.y,bounds.minY()+arrowPadding,bounds.maxY()-arrowPadding);ctx.beginPath();switch(anchorEdge){case WebInspector.RectEdge.MIN_X:ctx.moveTo(bounds.maxX(),bounds.minY()+cornerRadius);ctx.lineTo(bounds.maxX(),anchorPoint.y-arrowHalfLength);ctx.lineTo(anchorPoint.x,anchorPoint.y);ctx.lineTo(bounds.maxX(),anchorPoint.y+arrowHalfLength);ctx.arcTo(bounds.maxX(),bounds.maxY(),bounds.minX(),bounds.maxY(),cornerRadius);ctx.arcTo(bounds.minX(),bounds.maxY(),bounds.minX(),bounds.minY(),cornerRadius);ctx.arcTo(bounds.minX(),bounds.minY(),bounds.maxX(),bounds.minY(),cornerRadius);ctx.arcTo(bounds.maxX(),bounds.minY(),bounds.maxX(),bounds.maxY(),cornerRadius);break;case WebInspector.RectEdge.MAX_X:ctx.moveTo(bounds.minX(),bounds.maxY()-cornerRadius);ctx.lineTo(bounds.minX(),anchorPoint.y+arrowHalfLength);ctx.lineTo(anchorPoint.x,anchorPoint.y);ctx.lineTo(bounds.minX(),anchorPoint.y-arrowHalfLength);ctx.arcTo(bounds.minX(),bounds.minY(),bounds.maxX(),bounds.minY(),cornerRadius);ctx.arcTo(bounds.maxX(),bounds.minY(),bounds.maxX(),bounds.maxY(),cornerRadius);ctx.arcTo(bounds.maxX(),bounds.maxY(),bounds.minX(),bounds.maxY(),cornerRadius);ctx.arcTo(bounds.minX(),bounds.maxY(),bounds.minX(),bounds.minY(),cornerRadius);break;case WebInspector.RectEdge.MIN_Y:ctx.moveTo(bounds.maxX()-cornerRadius,bounds.maxY());ctx.lineTo(anchorPoint.x+arrowHalfLength,bounds.maxY());ctx.lineTo(anchorPoint.x,anchorPoint.y);ctx.lineTo(anchorPoint.x-arrowHalfLength,bounds.maxY());ctx.arcTo(bounds.minX(),bounds.maxY(),bounds.minX(),bounds.minY(),cornerRadius);ctx.arcTo(bounds.minX(),bounds.minY(),bounds.maxX(),bounds.minY(),cornerRadius);ctx.arcTo(bounds.maxX(),bounds.minY(),bounds.maxX(),bounds.maxY(),cornerRadius);ctx.arcTo(bounds.maxX(),bounds.maxY(),bounds.minX(),bounds.maxY(),cornerRadius);break;case WebInspector.RectEdge.MAX_Y:ctx.moveTo(bounds.minX()+cornerRadius,bounds.minY());ctx.lineTo(anchorPoint.x-arrowHalfLength,bounds.minY());ctx.lineTo(anchorPoint.x,anchorPoint.y);ctx.lineTo(anchorPoint.x+arrowHalfLength,bounds.minY());ctx.arcTo(bounds.maxX(),bounds.minY(),bounds.maxX(),bounds.maxY(),cornerRadius);ctx.arcTo(bounds.maxX(),bounds.maxY(),bounds.minX(),bounds.maxY(),cornerRadius);ctx.arcTo(bounds.minX(),bounds.maxY(),bounds.minX(),bounds.minY(),cornerRadius);ctx.arcTo(bounds.minX(),bounds.minY(),bounds.maxX(),bounds.minY(),cornerRadius);break;}
ctx.closePath();}
_addListenersIfNeeded()
{if(!this._isListeningForPopoverEvents){this._isListeningForPopoverEvents=true;window.addEventListener("mousedown",this,true);window.addEventListener("scroll",this,true);window.addEventListener("resize",this,true);window.addEventListener("keypress",this,true);WebInspector.quickConsole.keyboardShortcutDisabled=true;}}};WebInspector.Popover.FadeOutClassName="fade-out";WebInspector.Popover.CornerRadius=5;WebInspector.Popover.MinWidth=40;WebInspector.Popover.MinHeight=40;WebInspector.Popover.ShadowPadding=5;WebInspector.Popover.ContentPadding=5;WebInspector.Popover.AnchorSize=new WebInspector.Size(22,11);WebInspector.Popover.ShadowEdgeInsets=new WebInspector.EdgeInsets(WebInspector.Popover.ShadowPadding);WebInspector.Popover.IgnoreAutoDismissClassName="popover-ignore-auto-dismiss";WebInspector.Popover.EventPreventDismissSymbol=Symbol("popover-event-prevent-dismiss");WebInspector.SidebarPanel=class SidebarPanel extends WebInspector.View
{constructor(identifier,displayName)
{super();this._identifier=identifier;this._displayName=displayName;this._selected=false;this._savedScrollPosition=0;this.element.classList.add("panel",identifier);this.element.setAttribute("role","group");this.element.setAttribute("aria-label",displayName);this._contentView=new WebInspector.View;this._contentView.element.classList.add("content");this.addSubview(this._contentView);} 
get identifier()
{return this._identifier;}
get contentView()
{return this._contentView;}
get displayName()
{return this._displayName;}
get visible()
{return this.selected&&this.parentSidebar&&!this.parentSidebar.collapsed;}
get selected()
{return this._selected;}
set selected(flag)
{if(flag===this._selected)
return;this._selected=flag||false;this.element.classList.toggle("selected",this._selected);}
get parentSidebar()
{return this.parentView;}
get minimumWidth()
{return 0;}
show()
{if(!this.parentSidebar)
return;this.parentSidebar.collapsed=false;this.parentSidebar.selectedSidebarPanel=this;}
hide()
{if(!this.parentSidebar)
return;this.parentSidebar.collapsed=true;this.parentSidebar.selectedSidebarPanel=null;}
added()
{}
removed()
{}
shown()
{this._contentView.element.scrollTop=this._savedScrollPosition;this.updateLayoutIfNeeded();}
hidden()
{this._savedScrollPosition=this._contentView.element.scrollTop;}
visibilityDidChange()
{}};WebInspector.StyleDetailsPanel=class StyleDetailsPanel extends WebInspector.View
{constructor(delegate,className,identifier,label)
{super();this._delegate=delegate||null;this.element.classList.add(className,"offset-sections");this._navigationInfo={identifier,label};this._nodeStyles=null;this._visible=false;} 
get navigationInfo()
{return this._navigationInfo;}
get nodeStyles()
{return this._nodeStyles;}
shown()
{if(this._visible)
return;this._visible=true;this._refreshNodeStyles();this.updateLayoutIfNeeded();}
hidden()
{this._visible=false;this.cancelLayout();}
markAsNeedsRefresh(domNode)
{if(!domNode)
return;if(!this._nodeStyles||this._nodeStyles.node!==domNode){if(this._nodeStyles){this._nodeStyles.removeEventListener(WebInspector.DOMNodeStyles.Event.Refreshed,this.nodeStylesRefreshed,this);this._nodeStyles.removeEventListener(WebInspector.DOMNodeStyles.Event.NeedsRefresh,this._nodeStylesNeedsRefreshed,this);}
this._nodeStyles=WebInspector.cssStyleManager.stylesForNode(domNode);if(!this._nodeStyles)
return;this._nodeStyles.addEventListener(WebInspector.DOMNodeStyles.Event.Refreshed,this.nodeStylesRefreshed,this);this._nodeStyles.addEventListener(WebInspector.DOMNodeStyles.Event.NeedsRefresh,this._nodeStylesNeedsRefreshed,this);this._forceSignificantChange=true;}
if(this._visible)
this._refreshNodeStyles();}
refresh(significantChange)
{this.dispatchEventToListeners(WebInspector.StyleDetailsPanel.Event.Refreshed);} 
nodeStylesRefreshed(event)
{if(this._visible)
this._refreshPreservingScrollPosition(event.data.significantChange);} 
get _initialScrollOffset()
{if(!WebInspector.cssStyleManager.canForcePseudoClasses())
return 0;return this.nodeStyles.node.enabledPseudoClasses.length?0:WebInspector.CSSStyleDetailsSidebarPanel.NoForcedPseudoClassesScrollOffset;}
_refreshNodeStyles()
{if(!this._nodeStyles)
return;this._nodeStyles.refresh();}
_refreshPreservingScrollPosition(significantChange)
{significantChange=this._forceSignificantChange||significantChange||false;var previousScrollTop=this._initialScrollOffset;if(this.element.parentNode&&this._previousRefreshNodeIdentifier===this._nodeStyles.node.id)
previousScrollTop=this.element.parentNode.scrollTop;this.refresh(significantChange);this._previousRefreshNodeIdentifier=this._nodeStyles.node.id;if(this.element.parentNode)
this.element.parentNode.scrollTop=previousScrollTop;this._forceSignificantChange=false;}
_nodeStylesNeedsRefreshed(event)
{if(this._visible)
this._refreshNodeStyles();}};WebInspector.StyleDetailsPanel.Event={Refreshed:"style-details-panel-refreshed"};WebInspector.TabBar=class TabBar extends WebInspector.View
{constructor(element,tabBarItems)
{super(element);this.element.classList.add("tab-bar");this.element.setAttribute("role","tablist");this.element.addEventListener("mousedown",this._handleMouseDown.bind(this));this.element.addEventListener("click",this._handleClick.bind(this));this.element.addEventListener("mouseleave",this._handleMouseLeave.bind(this));this.element.createChild("div","top-border");this._tabBarItems=[];if(tabBarItems){for(let tabBarItem in tabBarItems)
this.addTabBarItem(tabBarItem);}
this.addTabBarItem(WebInspector.settingsTabContentView.tabBarItem,{suppressAnimations:true});this._newTabTabBarItem=new WebInspector.PinnedTabBarItem("Images/NewTabPlus.svg",WebInspector.UIString("Create a new tab"));this._newTabTabBarItem.element.addEventListener("mouseenter",this._handleNewTabMouseEnter.bind(this));this._newTabTabBarItem.element.addEventListener("click",this._handleNewTabClick.bind(this));this.addTabBarItem(this._newTabTabBarItem,{suppressAnimations:true});} 
get newTabTabBarItem(){return this._newTabTabBarItem;}
updateNewTabTabBarItemState()
{let newTabExists=!WebInspector.isNewTabWithTypeAllowed(WebInspector.NewTabContentView.Type);this._newTabTabBarItem.disabled=newTabExists;}
addTabBarItem(tabBarItem,options={})
{return this.insertTabBarItem(tabBarItem,this._tabBarItems.length,options);}
insertTabBarItem(tabBarItem,index,options={})
{if(!(tabBarItem instanceof WebInspector.TabBarItem))
return null;if(tabBarItem.parentTabBar===this)
return null;if(this._tabAnimatedClosedSinceMouseEnter){this._finishExpandingTabsAfterClose().then(()=>{this.insertTabBarItem(tabBarItem,index,options);});return null;}
if(tabBarItem.parentTabBar)
tabBarItem.parentTabBar.removeTabBarItem(tabBarItem);tabBarItem.parentTabBar=this;index=Number.constrain(index,0,this.normalTabCount);if(this.element.classList.contains("animating")){requestAnimationFrame(removeStyles.bind(this));options.suppressAnimations=true;}
var beforeTabSizesAndPositions;if(!options.suppressAnimations)
beforeTabSizesAndPositions=this._recordTabBarItemSizesAndPositions();this._tabBarItems.splice(index,0,tabBarItem);var nextSibling=this._tabBarItems[index+1];let nextSiblingElement=nextSibling?nextSibling.element:this._tabBarItems.lastValue.element;if(this.element.isAncestor(nextSiblingElement))
this.element.insertBefore(tabBarItem.element,nextSiblingElement);else
this.element.appendChild(tabBarItem.element);this.element.classList.toggle("single-tab",!this._hasMoreThanOneNormalTab());tabBarItem.element.style.left=null;tabBarItem.element.style.width=null;function animateTabs()
{this.element.classList.add("animating");this.element.classList.add("inserting-tab");this._applyTabBarItemSizesAndPositions(afterTabSizesAndPositions);this.element.addEventListener("webkitTransitionEnd",removeStylesListener);}
function removeStyles()
{this.element.classList.remove("static-layout");this.element.classList.remove("animating");this.element.classList.remove("inserting-tab");tabBarItem.element.classList.remove("being-inserted");this._clearTabBarItemSizesAndPositions();this.element.removeEventListener("webkitTransitionEnd",removeStylesListener);}
if(!options.suppressAnimations){var afterTabSizesAndPositions=this._recordTabBarItemSizesAndPositions();this.updateLayout();let tabBarItems=this._tabBarItemsFromLeftToRight();let previousTabBarItem=tabBarItems[tabBarItems.indexOf(tabBarItem)-1]||null;let previousTabBarItemSizeAndPosition=previousTabBarItem?beforeTabSizesAndPositions.get(previousTabBarItem):null;if(previousTabBarItemSizeAndPosition)
beforeTabSizesAndPositions.set(tabBarItem,{left:previousTabBarItemSizeAndPosition.left+previousTabBarItemSizeAndPosition.width,width:0});else
beforeTabSizesAndPositions.set(tabBarItem,{left:0,width:0});this.element.classList.add("static-layout");tabBarItem.element.classList.add("being-inserted");this._applyTabBarItemSizesAndPositions(beforeTabSizesAndPositions);var removeStylesListener=removeStyles.bind(this);requestAnimationFrame(animateTabs.bind(this));}else
this.needsLayout();if(!(tabBarItem instanceof WebInspector.PinnedTabBarItem))
this.updateNewTabTabBarItemState();this.dispatchEventToListeners(WebInspector.TabBar.Event.TabBarItemAdded,{tabBarItem});return tabBarItem;}
removeTabBarItem(tabBarItemOrIndex,options={})
{let tabBarItem=this._findTabBarItem(tabBarItemOrIndex);if(!tabBarItem||tabBarItem instanceof WebInspector.PinnedTabBarItem)
return null;tabBarItem.parentTabBar=null;if(this._selectedTabBarItem===tabBarItem){var index=this._tabBarItems.indexOf(tabBarItem);var nextTabBarItem=this._tabBarItems[index+1];if(!nextTabBarItem||nextTabBarItem instanceof WebInspector.PinnedTabBarItem)
nextTabBarItem=this._tabBarItems[index-1];this.selectedTabBarItem=nextTabBarItem;}
if(this.element.classList.contains("animating")){requestAnimationFrame(removeStyles.bind(this));options.suppressAnimations=true;}
var beforeTabSizesAndPositions;if(!options.suppressAnimations)
beforeTabSizesAndPositions=this._recordTabBarItemSizesAndPositions();let wasLastNormalTab=this._tabBarItems.indexOf(tabBarItem)===this.normalTabCount-1;this._tabBarItems.remove(tabBarItem);tabBarItem.element.remove();var hasMoreThanOneNormalTab=this._hasMoreThanOneNormalTab();this.element.classList.toggle("single-tab",!hasMoreThanOneNormalTab);const shouldOpenDefaultTab=!tabBarItem.isDefaultTab&&!this.normalTabCount;if(shouldOpenDefaultTab)
options.suppressAnimations=true;if(!hasMoreThanOneNormalTab||wasLastNormalTab||!options.suppressExpansion){if(!options.suppressAnimations){this._tabAnimatedClosedSinceMouseEnter=true;this._finishExpandingTabsAfterClose(beforeTabSizesAndPositions);}else
this.needsLayout();this.updateNewTabTabBarItemState();this.dispatchEventToListeners(WebInspector.TabBar.Event.TabBarItemRemoved,{tabBarItem});if(shouldOpenDefaultTab)
this._openDefaultTab();return tabBarItem;}
var lastNormalTabBarItem;function animateTabs()
{this.element.classList.add("animating");this.element.classList.add("closing-tab");
let extraSpaceBetweenNormalAndPinnedTabs=0;if(WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL){extraSpaceBetweenNormalAndPinnedTabs=this.element.getBoundingClientRect().width;for(let currentTabBarItem of this._tabBarItemsFromLeftToRight())
extraSpaceBetweenNormalAndPinnedTabs-=currentTabBarItem.element.getBoundingClientRect().width;}
let left=0;for(let currentTabBarItem of this._tabBarItemsFromLeftToRight()){let sizeAndPosition=beforeTabSizesAndPositions.get(currentTabBarItem);if(!(currentTabBarItem instanceof WebInspector.PinnedTabBarItem)){currentTabBarItem.element.style.left=extraSpaceBetweenNormalAndPinnedTabs+left+"px";left+=sizeAndPosition.width;lastNormalTabBarItem=currentTabBarItem;}else
left=sizeAndPosition.left+sizeAndPosition.width;}
if(this._selectedTabBarItem)
this._selectedTabBarItem.element.style.width=(parseFloat(this._selectedTabBarItem.element.style.width)+1)+"px";if(lastNormalTabBarItem!==this._selectedTabBarItem)
lastNormalTabBarItem.element.style.width=(parseFloat(lastNormalTabBarItem.element.style.width)+1)+"px";this.element.addEventListener("webkitTransitionEnd",removeStylesListener);}
function removeStyles()
{if(this._selectedTabBarItem&&this._selectedTabBarItem!==lastNormalTabBarItem)
this._selectedTabBarItem.element.style.width=(parseFloat(this._selectedTabBarItem.element.style.width)-1)+"px";this.element.classList.remove("animating");this.element.classList.remove("closing-tab");this.updateLayout();this.element.removeEventListener("webkitTransitionEnd",removeStylesListener);}
if(!options.suppressAnimations){this.element.classList.add("static-layout");this._tabAnimatedClosedSinceMouseEnter=true;this._applyTabBarItemSizesAndPositions(beforeTabSizesAndPositions);var removeStylesListener=removeStyles.bind(this);requestAnimationFrame(animateTabs.bind(this));}else
this.needsLayout();this.updateNewTabTabBarItemState();this.dispatchEventToListeners(WebInspector.TabBar.Event.TabBarItemRemoved,{tabBarItem});if(shouldOpenDefaultTab)
this._openDefaultTab();return tabBarItem;}
selectPreviousTab()
{if(this._tabBarItems.length<=1)
return;var startIndex=this._tabBarItems.indexOf(this._selectedTabBarItem);var newIndex=startIndex;do{if(newIndex===0)
newIndex=this._tabBarItems.length-1;else
newIndex--;if(!(this._tabBarItems[newIndex]instanceof WebInspector.PinnedTabBarItem))
break;}while(newIndex!==startIndex);if(newIndex===startIndex)
return;this.selectedTabBarItem=this._tabBarItems[newIndex];}
selectNextTab()
{if(this._tabBarItems.length<=1)
return;var startIndex=this._tabBarItems.indexOf(this._selectedTabBarItem);var newIndex=startIndex;do{if(newIndex===this._tabBarItems.length-1)
newIndex=0;else
newIndex++;if(!(this._tabBarItems[newIndex]instanceof WebInspector.PinnedTabBarItem))
break;}while(newIndex!==startIndex);if(newIndex===startIndex)
return;this.selectedTabBarItem=this._tabBarItems[newIndex];}
get selectedTabBarItem()
{return this._selectedTabBarItem;}
set selectedTabBarItem(tabBarItemOrIndex)
{let tabBarItem=this._findTabBarItem(tabBarItemOrIndex);if(tabBarItem===this._newTabTabBarItem){tabBarItem=this._tabBarItems[this.normalTabCount-1];}
if(this._selectedTabBarItem===tabBarItem)
return;if(this._selectedTabBarItem)
this._selectedTabBarItem.selected=false;this._selectedTabBarItem=tabBarItem||null;if(this._selectedTabBarItem)
this._selectedTabBarItem.selected=true;this.dispatchEventToListeners(WebInspector.TabBar.Event.TabBarItemSelected);}
get tabBarItems()
{return this._tabBarItems;}
get normalTabCount()
{return this._tabBarItems.filter((item)=>!(item instanceof WebInspector.PinnedTabBarItem)).length;} 
layout()
{if(this.element.classList.contains("static-layout"))
return;this.element.classList.remove("hide-titles");this.element.classList.remove("collapsed");let firstNormalTabItem=null;for(let tabItem of this._tabBarItems){if(tabItem instanceof WebInspector.PinnedTabBarItem)
continue;firstNormalTabItem=tabItem;break;}
if(!firstNormalTabItem)
return;if(firstNormalTabItem.element.offsetWidth>=120)
return;this.element.classList.add("collapsed");if(firstNormalTabItem.element.offsetWidth>=75)
return;this.element.classList.add("hide-titles");} 
_tabBarItemsFromLeftToRight()
{return WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.LTR?this._tabBarItems:this._tabBarItems.slice().reverse();}
_findTabBarItem(tabBarItemOrIndex)
{if(typeof tabBarItemOrIndex==="number")
return this._tabBarItems[tabBarItemOrIndex]||null;if(tabBarItemOrIndex instanceof WebInspector.TabBarItem){if(this._tabBarItems.includes(tabBarItemOrIndex))
return tabBarItemOrIndex;}
return null;}
_hasMoreThanOneNormalTab()
{let normalTabCount=0;for(let tabBarItem of this._tabBarItems){if(tabBarItem instanceof WebInspector.PinnedTabBarItem)
continue;++normalTabCount;if(normalTabCount>=2)
return true;}
return false;}
_openDefaultTab()
{this.dispatchEventToListeners(WebInspector.TabBar.Event.OpenDefaultTab);}
_recordTabBarItemSizesAndPositions()
{var tabBarItemSizesAndPositions=new Map;const barRect=this.element.getBoundingClientRect();for(var tabBarItem of this._tabBarItems){var boundingRect=tabBarItem.element.getBoundingClientRect();tabBarItemSizesAndPositions.set(tabBarItem,{left:boundingRect.left-barRect.left,width:boundingRect.width});}
return tabBarItemSizesAndPositions;}
_applyTabBarItemSizesAndPositions(tabBarItemSizesAndPositions,skipTabBarItem)
{for(var[tabBarItem,sizeAndPosition]of tabBarItemSizesAndPositions){if(skipTabBarItem&&tabBarItem===skipTabBarItem)
continue;tabBarItem.element.style.left=sizeAndPosition.left+"px";tabBarItem.element.style.width=sizeAndPosition.width+"px";}}
_clearTabBarItemSizesAndPositions(skipTabBarItem)
{for(var tabBarItem of this._tabBarItems){if(skipTabBarItem&&tabBarItem===skipTabBarItem)
continue;tabBarItem.element.style.left=null;tabBarItem.element.style.width=null;}}
_finishExpandingTabsAfterClose(beforeTabSizesAndPositions)
{return new Promise(function(resolve,reject){this._tabAnimatedClosedSinceMouseEnter=false;if(!beforeTabSizesAndPositions)
beforeTabSizesAndPositions=this._recordTabBarItemSizesAndPositions();this.element.classList.remove("static-layout");this._clearTabBarItemSizesAndPositions();var afterTabSizesAndPositions=this._recordTabBarItemSizesAndPositions();this._applyTabBarItemSizesAndPositions(beforeTabSizesAndPositions);this.element.classList.add("static-layout");function animateTabs()
{this.element.classList.add("static-layout");this.element.classList.add("animating");this.element.classList.add("expanding-tabs");this._applyTabBarItemSizesAndPositions(afterTabSizesAndPositions);this.element.addEventListener("webkitTransitionEnd",removeStylesListener);}
function removeStyles()
{this.element.classList.remove("static-layout");this.element.classList.remove("animating");this.element.classList.remove("expanding-tabs");this._clearTabBarItemSizesAndPositions();this.updateLayout();this.element.removeEventListener("webkitTransitionEnd",removeStylesListener);resolve();}
var removeStylesListener=removeStyles.bind(this);requestAnimationFrame(animateTabs.bind(this));}.bind(this));}
_handleMouseDown(event)
{if(event.button!==0||event.ctrlKey)
return;let itemElement=event.target.enclosingNodeOrSelfWithClass(WebInspector.TabBarItem.StyleClassName);if(!itemElement)
return;let tabBarItem=itemElement[WebInspector.TabBarItem.ElementReferenceSymbol];if(!tabBarItem)
return;if(tabBarItem.disabled)
return;if(tabBarItem===this._newTabTabBarItem)
return;let closeButtonElement=event.target.enclosingNodeOrSelfWithClass(WebInspector.TabBarItem.CloseButtonStyleClassName);if(closeButtonElement)
return;this.selectedTabBarItem=tabBarItem;if(tabBarItem instanceof WebInspector.PinnedTabBarItem||!this._hasMoreThanOneNormalTab())
return;this._firstNormalTabItemIndex=0;for(let i=0;i<this._tabBarItems.length;++i){if(this._tabBarItems[i]instanceof WebInspector.PinnedTabBarItem)
continue;this._firstNormalTabItemIndex=i;break;}
this._mouseIsDown=true;this._mouseMovedEventListener=this._handleMouseMoved.bind(this);this._mouseUpEventListener=this._handleMouseUp.bind(this);document.addEventListener("mousemove",this._mouseMovedEventListener,true);document.addEventListener("mouseup",this._mouseUpEventListener,true);event.preventDefault();event.stopPropagation();}
_handleClick(event)
{var itemElement=event.target.enclosingNodeOrSelfWithClass(WebInspector.TabBarItem.StyleClassName);if(!itemElement)
return;var tabBarItem=itemElement[WebInspector.TabBarItem.ElementReferenceSymbol];if(!tabBarItem)
return;if(tabBarItem.disabled)
return;const clickedMiddleButton=event.button===1;var closeButtonElement=event.target.enclosingNodeOrSelfWithClass(WebInspector.TabBarItem.CloseButtonStyleClassName);if(closeButtonElement||clickedMiddleButton){if(tabBarItem.isDefaultTab&&this.element.classList.contains("single-tab"))
return;if(!event.altKey){this.removeTabBarItem(tabBarItem,{suppressExpansion:true});return;}
for(let i=this._tabBarItems.length-1;i>=0;--i){let item=this._tabBarItems[i];if(item===tabBarItem||item instanceof WebInspector.PinnedTabBarItem)
continue;this.removeTabBarItem(item);}}}
_handleMouseMoved(event)
{if(!this._mouseIsDown)
return;if(!this._selectedTabBarItem)
return;event.preventDefault();event.stopPropagation();if(!this.element.classList.contains("static-layout")){this._applyTabBarItemSizesAndPositions(this._recordTabBarItemSizesAndPositions());this.element.classList.add("static-layout");this.element.classList.add("dragging-tab");}
if(this._mouseOffset===undefined)
this._mouseOffset=event.pageX-this._selectedTabBarItem.element.totalOffsetLeft;var tabBarMouseOffset=event.pageX-this.element.totalOffsetLeft;var newLeft=tabBarMouseOffset-this._mouseOffset;this._selectedTabBarItem.element.style.left=newLeft+"px";var selectedTabMidX=newLeft+(this._selectedTabBarItem.element.realOffsetWidth/2);var currentIndex=this._tabBarItems.indexOf(this._selectedTabBarItem);var newIndex=currentIndex;for(let tabBarItem of this._tabBarItems){if(tabBarItem===this._selectedTabBarItem)
continue;var tabBarItemRect=tabBarItem.element.getBoundingClientRect();if(selectedTabMidX<tabBarItemRect.left||selectedTabMidX>tabBarItemRect.right)
continue;newIndex=this._tabBarItems.indexOf(tabBarItem);break;}
newIndex=Number.constrain(newIndex,this._firstNormalTabItemIndex,this.normalTabCount-1);if(currentIndex===newIndex)
return;this._tabBarItems.splice(currentIndex,1);this._tabBarItems.splice(newIndex,0,this._selectedTabBarItem);let nextSibling=this._tabBarItems[newIndex+1];let nextSiblingElement=nextSibling?nextSibling.element:this._newTabTabBarItem.element;this.element.insertBefore(this._selectedTabBarItem.element,nextSiblingElement);let left=0;for(let tabBarItem of this._tabBarItemsFromLeftToRight()){if(tabBarItem!==this._selectedTabBarItem&&tabBarItem!==this._newTabTabBarItem&&parseFloat(tabBarItem.element.style.left)!==left)
tabBarItem.element.style.left=left+"px";left+=parseFloat(tabBarItem.element.style.width);}}
_handleMouseUp(event)
{if(!this._mouseIsDown)
return;this.element.classList.remove("dragging-tab");if(!this._tabAnimatedClosedSinceMouseEnter){this.element.classList.remove("static-layout");this._clearTabBarItemSizesAndPositions();}else{let left=0;for(let tabBarItem of this._tabBarItemsFromLeftToRight()){if(tabBarItem===this._selectedTabBarItem)
tabBarItem.element.style.left=left+"px";left+=parseFloat(tabBarItem.element.style.width);}}
this._mouseIsDown=false;this._mouseOffset=undefined;document.removeEventListener("mousemove",this._mouseMovedEventListener,true);document.removeEventListener("mouseup",this._mouseUpEventListener,true);this._mouseMovedEventListener=null;this._mouseUpEventListener=null;event.preventDefault();event.stopPropagation();this.dispatchEventToListeners(WebInspector.TabBar.Event.TabBarItemsReordered);}
_handleMouseLeave(event)
{if(this._mouseIsDown||!this._tabAnimatedClosedSinceMouseEnter||!this.element.classList.contains("static-layout")||this.element.classList.contains("animating"))
return;const barRect=this.element.getBoundingClientRect();const newTabItemRect=this._newTabTabBarItem.element.getBoundingClientRect();if(event.pageY>barRect.top&&event.pageY<barRect.bottom&&event.pageX>barRect.left&&event.pageX<(newTabItemRect?newTabItemRect.right:barRect.right))
return;this._finishExpandingTabsAfterClose();}
_handleNewTabClick(event)
{WebInspector.showNewTabTab();}
_handleNewTabMouseEnter(event)
{if(!this._tabAnimatedClosedSinceMouseEnter||!this.element.classList.contains("static-layout")||this.element.classList.contains("animating"))
return;this._finishExpandingTabsAfterClose();}};WebInspector.TabBar.Event={TabBarItemSelected:"tab-bar-tab-bar-item-selected",TabBarItemAdded:"tab-bar-tab-bar-item-added",TabBarItemRemoved:"tab-bar-tab-bar-item-removed",TabBarItemsReordered:"tab-bar-tab-bar-items-reordered",OpenDefaultTab:"tab-bar-open-default-tab"};WebInspector.TabBarItem=class TabBarItem extends WebInspector.Object
{constructor(image,title,representedObject)
{super();this._parentTabBar=null;this._element=document.createElement("div");this._element.classList.add(WebInspector.TabBarItem.StyleClassName);this._element.setAttribute("role","tab");this._element.tabIndex=0;this._element[WebInspector.TabBarItem.ElementReferenceSymbol]=this;this._element.createChild("div","flex-space");this._iconElement=document.createElement("img");this._iconElement.classList.add("icon");this._element.appendChild(this._iconElement);this._element.createChild("div","flex-space");this.title=title;this.image=image;this.representedObject=representedObject;} 
get element(){return this._element;}
get representedObject(){return this._representedObject;}
set representedObject(representedObject){this._representedObject=representedObject||null;}
get parentTabBar(){return this._parentTabBar;}
set parentTabBar(tabBar){this._parentTabBar=tabBar||null;}
get selected()
{return this._element.classList.contains("selected");}
set selected(selected)
{this._element.classList.toggle("selected",selected);if(selected)
this._element.setAttribute("aria-selected","true");else
this._element.removeAttribute("aria-selected");}
get disabled()
{return this._element.classList.contains("disabled");}
set disabled(disabled)
{this._element.classList.toggle("disabled",disabled);}
get isDefaultTab()
{return this._element.classList.contains("default-tab");}
set isDefaultTab(isDefaultTab)
{this._element.classList.toggle("default-tab",isDefaultTab);}
get image(){return this._iconElement.src;}
set image(url){this._iconElement.src=url||"";}
get title(){return this._element.title||"";}
set title(title){this._element.title=title||"";}};WebInspector.TabBarItem.StyleClassName="item";WebInspector.TabBarItem.CloseButtonStyleClassName="close";WebInspector.TabBarItem.ElementReferenceSymbol=Symbol("tab-bar-item");WebInspector.TabBrowser=class TabBrowser extends WebInspector.View
{constructor(element,tabBar,navigationSidebar,detailsSidebar)
{super(element);this.element.classList.add("tab-browser");this._tabBar=tabBar;this._navigationSidebar=navigationSidebar||null;this._detailsSidebar=detailsSidebar||null;if(this._navigationSidebar){this._navigationSidebar.addEventListener(WebInspector.Sidebar.Event.CollapsedStateDidChange,this._sidebarCollapsedStateDidChange,this);this._navigationSidebar.addEventListener(WebInspector.Sidebar.Event.WidthDidChange,this._sidebarWidthDidChange,this);}
if(this._detailsSidebar){this._detailsSidebar.addEventListener(WebInspector.Sidebar.Event.CollapsedStateDidChange,this._sidebarCollapsedStateDidChange,this);this._detailsSidebar.addEventListener(WebInspector.Sidebar.Event.SidebarPanelSelected,this._sidebarPanelSelected,this);this._detailsSidebar.addEventListener(WebInspector.Sidebar.Event.WidthDidChange,this._sidebarWidthDidChange,this);}
this._contentViewContainer=new WebInspector.ContentViewContainer;this.addSubview(this._contentViewContainer);let showNextTab=()=>{this._showNextTab();};let showPreviousTab=()=>{this._showPreviousTab();};let isRTL=WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL;let nextKey1=isRTL?WebInspector.KeyboardShortcut.Key.LeftCurlyBrace:WebInspector.KeyboardShortcut.Key.RightCurlyBrace;let previousKey1=isRTL?WebInspector.KeyboardShortcut.Key.RightCurlyBrace:WebInspector.KeyboardShortcut.Key.LeftCurlyBrace;this._showNextTabKeyboardShortcut1=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.CommandOrControl|WebInspector.KeyboardShortcut.Modifier.Shift,nextKey1,showNextTab);this._showPreviousTabKeyboardShortcut1=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.CommandOrControl|WebInspector.KeyboardShortcut.Modifier.Shift,previousKey1,showPreviousTab);let nextModifier2=isRTL?WebInspector.KeyboardShortcut.Modifier.Shift:0;let previousModifier2=isRTL?0:WebInspector.KeyboardShortcut.Modifier.Shift;this._showNextTabKeyboardShortcut2=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.Control|nextModifier2,WebInspector.KeyboardShortcut.Key.Tab,showNextTab);this._showPreviousTabKeyboardShortcut2=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.Control|previousModifier2,WebInspector.KeyboardShortcut.Key.Tab,showPreviousTab);let previousTabKey=isRTL?WebInspector.KeyboardShortcut.Key.Right:WebInspector.KeyboardShortcut.Key.Left;let nextTabKey=isRTL?WebInspector.KeyboardShortcut.Key.Left:WebInspector.KeyboardShortcut.Key.Right;this._previousTabKeyboardShortcut=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.CommandOrControl|WebInspector.KeyboardShortcut.Modifier.Shift,previousTabKey,this._showPreviousTabCheckingForEditableField.bind(this));this._previousTabKeyboardShortcut.implicitlyPreventsDefault=false;this._nextTabKeyboardShortcut=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.CommandOrControl|WebInspector.KeyboardShortcut.Modifier.Shift,nextTabKey,this._showNextTabCheckingForEditableField.bind(this));this._nextTabKeyboardShortcut.implicitlyPreventsDefault=false;this._tabBar.addEventListener(WebInspector.TabBar.Event.TabBarItemSelected,this._tabBarItemSelected,this);this._tabBar.addEventListener(WebInspector.TabBar.Event.TabBarItemAdded,this._tabBarItemAdded,this);this._tabBar.addEventListener(WebInspector.TabBar.Event.TabBarItemRemoved,this._tabBarItemRemoved,this);this._tabBar.newTabTabBarItem.addEventListener(WebInspector.PinnedTabBarItem.Event.ContextMenu,this._handleNewTabContextMenu,this);this._recentTabContentViews=[];this._closedTabClasses=new Set;} 
get tabBar()
{return this._tabBar;}
get navigationSidebar()
{return this._navigationSidebar;}
get detailsSidebar()
{return this._detailsSidebar;}
get selectedTabContentView()
{return this._contentViewContainer.currentContentView;}
bestTabContentViewForClass(constructor)
{for(var tabContentView of this._recentTabContentViews){if(tabContentView instanceof constructor)
return tabContentView;}
return null;}
bestTabContentViewForRepresentedObject(representedObject,options={})
{for(var tabContentView of this._recentTabContentViews){if(options.ignoreSearchTab&&tabContentView instanceof WebInspector.SearchTabContentView)
continue;if(options.ignoreNetworkTab&&tabContentView instanceof WebInspector.NetworkTabContentView)
continue;if(tabContentView.canShowRepresentedObject(representedObject))
return tabContentView;}
return null;}
addTabForContentView(tabContentView,options={})
{if(!(tabContentView instanceof WebInspector.TabContentView))
return false;let tabBarItem=tabContentView.tabBarItem;if(!(tabBarItem instanceof WebInspector.TabBarItem))
return false;if(tabBarItem.representedObject!==tabContentView)
tabBarItem.representedObject=tabContentView;tabContentView.parentTabBrowser=this;if(tabBarItem.parentTabBar===this._tabBar)
return true;
if(this._recentTabContentViews.length&&this.selectedTabContentView)
this._recentTabContentViews.splice(1,0,tabContentView);else
this._recentTabContentViews.push(tabContentView);if(typeof options.insertionIndex==="number")
this._tabBar.insertTabBarItem(tabBarItem,options.insertionIndex,options);else
this._tabBar.addTabBarItem(tabBarItem,options);return true;}
showTabForContentView(tabContentView,options={})
{if(!this.addTabForContentView(tabContentView,options))
return false;if(!options.suppressSelection)
this._tabBar.selectedTabBarItem=tabContentView.tabBarItem;



this.needsLayout();return true;}
closeTabForContentView(tabContentView,options={})
{if(!(tabContentView instanceof WebInspector.TabContentView))
return false;if(!(tabContentView.tabBarItem instanceof WebInspector.TabBarItem))
return false;if(tabContentView.tabBarItem.parentTabBar!==this._tabBar)
return false;this._tabBar.removeTabBarItem(tabContentView.tabBarItem,options);return true;} 
layout()
{if(this.layoutReason!==WebInspector.View.LayoutReason.Resize)
return;for(let tabContentView of this._recentTabContentViews)
tabContentView[WebInspector.TabBrowser.NeedsResizeLayoutSymbol]=tabContentView!==this.selectedTabContentView;} 
_tabBarItemSelected(event)
{let tabContentView=this._tabBar.selectedTabBarItem?this._tabBar.selectedTabBarItem.representedObject:null;if(tabContentView){let isSettingsTab=tabContentView instanceof WebInspector.SettingsTabContentView;if(!isSettingsTab){this._recentTabContentViews.remove(tabContentView);this._recentTabContentViews.unshift(tabContentView);}
this._contentViewContainer.showContentView(tabContentView);}else{this._contentViewContainer.closeAllContentViews();}
this._showNavigationSidebarPanelForTabContentView(tabContentView);this._showDetailsSidebarPanelsForTabContentView(tabContentView);if(tabContentView&&tabContentView[WebInspector.TabBrowser.NeedsResizeLayoutSymbol]){tabContentView[WebInspector.TabBrowser.NeedsResizeLayoutSymbol]=false;tabContentView.updateLayout(WebInspector.View.LayoutReason.Resize);}
this.dispatchEventToListeners(WebInspector.TabBrowser.Event.SelectedTabContentViewDidChange);}
_tabBarItemAdded(event)
{let tabContentView=event.data.tabBarItem.representedObject;if(!tabContentView)
return;this._closedTabClasses.delete(tabContentView.constructor);}
_tabBarItemRemoved(event)
{let tabContentView=event.data.tabBarItem.representedObject;if(!tabContentView)
return;this._recentTabContentViews.remove(tabContentView);if(!tabContentView.constructor.isEphemeral())
this._closedTabClasses.add(tabContentView.constructor);this._contentViewContainer.closeContentView(tabContentView);tabContentView.parentTabBrowser=null;}
_handleNewTabContextMenu(event)
{
let closedTabClasses=Array.from(this._closedTabClasses).reverse();let allTabClasses=Array.from(WebInspector.knownTabClasses());let tabClassesToDisplay=closedTabClasses.concat(allTabClasses.filter((tabClass)=>{if(closedTabClasses.includes(tabClass))
return false;if(tabClass.isEphemeral())
return false;return WebInspector.isNewTabWithTypeAllowed(tabClass.Type);}));if(!tabClassesToDisplay.length)
return;let contextMenu=event.data.contextMenu;contextMenu.appendItem(WebInspector.UIString("Recently Closed Tabs"),null,true);for(let tabClass of tabClassesToDisplay){contextMenu.appendItem(tabClass.tabInfo().title,()=>{WebInspector.createNewTabWithType(tabClass.Type,{shouldShowNewTab:true});});}}
_sidebarPanelSelected(event)
{if(this._ignoreSidebarEvents)
return;var tabContentView=this.selectedTabContentView;if(!tabContentView)
return;if(tabContentView.managesDetailsSidebarPanels)
return;var selectedSidebarPanel=this._detailsSidebar.selectedSidebarPanel;tabContentView.detailsSidebarSelectedPanelSetting.value=selectedSidebarPanel?selectedSidebarPanel.identifier:null;}
_sidebarCollapsedStateDidChange(event)
{if(this._ignoreSidebarEvents)
return;var tabContentView=this.selectedTabContentView;if(!tabContentView)
return;if(event.target===this._navigationSidebar)
tabContentView.navigationSidebarCollapsedSetting.value=this._navigationSidebar.collapsed;else if(event.target===this._detailsSidebar&&!tabContentView.managesDetailsSidebarPanels)
tabContentView.detailsSidebarCollapsedSetting.value=this._detailsSidebar.collapsed;}
_sidebarWidthDidChange(event)
{if(this._ignoreSidebarEvents||!event.data)
return;let tabContentView=this.selectedTabContentView;if(!tabContentView)
return;switch(event.target){case this._navigationSidebar:tabContentView.navigationSidebarWidthSetting.value=event.data.newWidth;break;case this._detailsSidebar:tabContentView.detailsSidebarWidthSetting.value=event.data.newWidth;break;}}
_showNavigationSidebarPanelForTabContentView(tabContentView)
{if(!this._navigationSidebar)
return;this._ignoreSidebarEvents=true;this._navigationSidebar.removeSidebarPanel(0);if(!tabContentView){this._ignoreSidebarEvents=false;return;}
if(tabContentView.navigationSidebarWidthSetting.value)
this._navigationSidebar.width=tabContentView.navigationSidebarWidthSetting.value;var navigationSidebarPanel=tabContentView.navigationSidebarPanel;if(!navigationSidebarPanel){this._navigationSidebar.collapsed=true;this._ignoreSidebarEvents=false;return;}
this._navigationSidebar.addSidebarPanel(navigationSidebarPanel);this._navigationSidebar.selectedSidebarPanel=navigationSidebarPanel;this._navigationSidebar.collapsed=tabContentView.navigationSidebarCollapsedSetting.value;this._ignoreSidebarEvents=false;}
_showDetailsSidebarPanelsForTabContentView(tabContentView)
{if(!this._detailsSidebar)
return;this._ignoreSidebarEvents=true;for(var i=this._detailsSidebar.sidebarPanels.length-1;i>=0;--i)
this._detailsSidebar.removeSidebarPanel(i);if(!tabContentView){this._ignoreSidebarEvents=false;return;}
if(tabContentView.detailsSidebarWidthSetting.value)
this._detailsSidebar.width=tabContentView.detailsSidebarWidthSetting.value;if(tabContentView.managesDetailsSidebarPanels){tabContentView.showDetailsSidebarPanels();this._ignoreSidebarEvents=false;return;}
var detailsSidebarPanels=tabContentView.detailsSidebarPanels;if(!detailsSidebarPanels){this._detailsSidebar.collapsed=true;this._ignoreSidebarEvents=false;return;}
for(var detailsSidebarPanel of detailsSidebarPanels)
this._detailsSidebar.addSidebarPanel(detailsSidebarPanel);this._detailsSidebar.selectedSidebarPanel=tabContentView.detailsSidebarSelectedPanelSetting.value||detailsSidebarPanels[0];this._detailsSidebar.collapsed=tabContentView.detailsSidebarCollapsedSetting.value||!detailsSidebarPanels.length;this._ignoreSidebarEvents=false;}
_showPreviousTab(event)
{this._tabBar.selectPreviousTab();}
_showNextTab(event)
{this._tabBar.selectNextTab();}
_showNextTabCheckingForEditableField(event)
{if(WebInspector.isEventTargetAnEditableField(event))
return;this._showNextTab(event);event.preventDefault();}
_showPreviousTabCheckingForEditableField(event)
{if(WebInspector.isEventTargetAnEditableField(event))
return;this._showPreviousTab(event);event.preventDefault();}};WebInspector.TabBrowser.NeedsResizeLayoutSymbol=Symbol("needs-resize-layout");WebInspector.TabBrowser.Event={SelectedTabContentViewDidChange:"tab-browser-selected-tab-content-view-did-change"};WebInspector.TextEditor=class TextEditor extends WebInspector.View
{constructor(element,mimeType,delegate)
{super(element);this.element.classList.add("text-editor",WebInspector.SyntaxHighlightedStyleClassName);this._codeMirror=WebInspector.CodeMirrorEditor.create(this.element,{readOnly:true,indentWithTabs:WebInspector.settings.indentWithTabs.value,indentUnit:WebInspector.settings.indentUnit.value,tabSize:WebInspector.settings.tabSize.value,lineNumbers:true,lineWrapping:WebInspector.settings.enableLineWrapping.value,matchBrackets:true,autoCloseBrackets:true,showWhitespaceCharacters:WebInspector.settings.showWhitespaceCharacters.value,styleSelectedText:true,});WebInspector.settings.indentWithTabs.addEventListener(WebInspector.Setting.Event.Changed,(event)=>{this._codeMirror.setOption("indentWithTabs",WebInspector.settings.indentWithTabs.value);});WebInspector.settings.indentUnit.addEventListener(WebInspector.Setting.Event.Changed,(event)=>{this._codeMirror.setOption("indentUnit",WebInspector.settings.indentUnit.value);});WebInspector.settings.tabSize.addEventListener(WebInspector.Setting.Event.Changed,(event)=>{this._codeMirror.setOption("tabSize",WebInspector.settings.tabSize.value);});WebInspector.settings.enableLineWrapping.addEventListener(WebInspector.Setting.Event.Changed,(event)=>{this._codeMirror.setOption("lineWrapping",WebInspector.settings.enableLineWrapping.value);});WebInspector.settings.showWhitespaceCharacters.addEventListener(WebInspector.Setting.Event.Changed,(event)=>{this._codeMirror.setOption("showWhitespaceCharacters",WebInspector.settings.showWhitespaceCharacters.value);});this._codeMirror.on("change",this._contentChanged.bind(this));this._codeMirror.on("gutterClick",this._gutterMouseDown.bind(this));this._codeMirror.on("gutterContextMenu",this._gutterContextMenu.bind(this));this._codeMirror.getScrollerElement().addEventListener("click",this._openClickedLinks.bind(this),true);this._completionController=new WebInspector.CodeMirrorCompletionController(this._codeMirror,this);this._tokenTrackingController=new WebInspector.CodeMirrorTokenTrackingController(this._codeMirror,this);this._initialStringNotSet=true;this.mimeType=mimeType;this._breakpoints={};this._executionLineNumber=NaN;this._executionColumnNumber=NaN;this._executionLineHandle=null;this._executionMultilineHandles=[];this._executionRangeHighlightMarker=null;this._searchQuery=null;this._searchResults=[];this._currentSearchResultIndex=-1;this._ignoreCodeMirrorContentDidChangeEvent=0;this._formatted=false;this._formattingPromise=null;this._formatterSourceMap=null;this._deferReveal=false;this._delegate=delegate||null;} 
get visible()
{return this._visible;}
get string()
{return this._codeMirror.getValue();}
set string(newString)
{function update()
{if(this._initialStringNotSet)
this._codeMirror.removeLineClass(0,"wrap");if(this._codeMirror.getValue()!==newString){this._codeMirror.setValue(newString);}else{this.layout();}
if(this._initialStringNotSet){this._codeMirror.clearHistory();this._codeMirror.markClean();this._initialStringNotSet=false;}
this._updateExecutionLine();this._updateExecutionRangeHighlight();for(var lineNumber in this._breakpoints)
this._setBreakpointStylesOnLine(lineNumber);this._revealPendingPositionIfPossible();}
this._ignoreCodeMirrorContentDidChangeEvent++;this._codeMirror.operation(update.bind(this));this._ignoreCodeMirrorContentDidChangeEvent--;}
get readOnly()
{return this._codeMirror.getOption("readOnly")||false;}
set readOnly(readOnly)
{this._codeMirror.setOption("readOnly",readOnly);}
get formatted()
{return this._formatted;}
get hasModified()
{let historySize=this._codeMirror.historySize().undo;if(this._formatted)
historySize--;return historySize>0;}
updateFormattedState(formatted)
{return this._format(formatted).catch(handlePromiseException);}
hasFormatter()
{let mode=this._codeMirror.getMode().name;return mode==="javascript"||mode==="css";}
canBeFormatted()
{return this.hasFormatter();}
canShowTypeAnnotations()
{return false;}
canShowCoverageHints()
{return false;}
get selectedTextRange()
{var start=this._codeMirror.getCursor(true);var end=this._codeMirror.getCursor(false);return this._textRangeFromCodeMirrorPosition(start,end);}
set selectedTextRange(textRange)
{var position=this._codeMirrorPositionFromTextRange(textRange);this._codeMirror.setSelection(position.start,position.end);}
get mimeType()
{return this._mimeType;}
set mimeType(newMIMEType)
{newMIMEType=parseMIMEType(newMIMEType).type;this._mimeType=newMIMEType;this._codeMirror.setOption("mode",{name:newMIMEType,globalVars:true});}
get executionLineNumber()
{return this._executionLineNumber;}
get executionColumnNumber()
{return this._executionColumnNumber;}
get formatterSourceMap()
{return this._formatterSourceMap;}
get tokenTrackingController()
{return this._tokenTrackingController;}
get delegate()
{return this._delegate;}
set delegate(newDelegate)
{this._delegate=newDelegate||null;}
get numberOfSearchResults()
{return this._searchResults.length;}
get currentSearchQuery()
{return this._searchQuery;}
set automaticallyRevealFirstSearchResult(reveal)
{this._automaticallyRevealFirstSearchResult=reveal;if(this._automaticallyRevealFirstSearchResult&&this._searchResults.length>0){if(this._currentSearchResultIndex===-1)
this._revealFirstSearchResultAfterCursor();}}
set deferReveal(defer)
{this._deferReveal=defer;}
performSearch(query)
{if(this._searchQuery===query)
return;this.searchCleared();this._searchQuery=query;if(typeof this.customPerformSearch==="function"&&!this.formatted){if(this.customPerformSearch(query))
return;}
var queryRegex=new RegExp(query.escapeForRegExp(),"gi");var searchCursor=this._codeMirror.getSearchCursor(queryRegex,{line:0,ch:0},false);var boundBatchSearch=batchSearch.bind(this);var numberOfSearchResultsDidChangeTimeout=null;function reportNumberOfSearchResultsDidChange()
{if(numberOfSearchResultsDidChangeTimeout){clearTimeout(numberOfSearchResultsDidChangeTimeout);numberOfSearchResultsDidChangeTimeout=null;}
this.dispatchEventToListeners(WebInspector.TextEditor.Event.NumberOfSearchResultsDidChange);}
function batchSearch()
{if(this._searchQuery!==query)
return;var newSearchResults=[];var foundResult=false;for(var i=0;i<WebInspector.TextEditor.NumberOfFindsPerSearchBatch&&(foundResult=searchCursor.findNext());++i){var textRange=this._textRangeFromCodeMirrorPosition(searchCursor.from(),searchCursor.to());newSearchResults.push(textRange);}
this.addSearchResults(newSearchResults);if(!numberOfSearchResultsDidChangeTimeout)
numberOfSearchResultsDidChangeTimeout=setTimeout(reportNumberOfSearchResultsDidChange.bind(this),500);if(foundResult){setTimeout(boundBatchSearch,50);}else{reportNumberOfSearchResultsDidChange.call(this);}}
boundBatchSearch();}
setExecutionLineAndColumn(lineNumber,columnNumber)
{if(!this._executionLineHandle&&isNaN(lineNumber))
return;this._executionLineNumber=lineNumber;this._executionColumnNumber=columnNumber;if(!this._initialStringNotSet){this._updateExecutionLine();this._updateExecutionRangeHighlight();}

this.dispatchEventToListeners(WebInspector.TextEditor.Event.ExecutionLineNumberDidChange);}
addSearchResults(textRanges)
{if(!textRanges||!textRanges.length)
return;function markRanges()
{for(var i=0;i<textRanges.length;++i){var position=this._codeMirrorPositionFromTextRange(textRanges[i]);var mark=this._codeMirror.markText(position.start,position.end,{className:WebInspector.TextEditor.SearchResultStyleClassName});this._searchResults.push(mark);}
if(this._automaticallyRevealFirstSearchResult){if(this._currentSearchResultIndex===-1)
this._revealFirstSearchResultAfterCursor();}}
this._codeMirror.operation(markRanges.bind(this));}
searchCleared()
{function clearResults(){for(var i=0;i<this._searchResults.length;++i)
this._searchResults[i].clear();}
this._codeMirror.operation(clearResults.bind(this));this._searchQuery=null;this._searchResults=[];this._currentSearchResultIndex=-1;}
searchQueryWithSelection()
{if(!this._codeMirror.somethingSelected())
return null;return this._codeMirror.getSelection();}
revealPreviousSearchResult(changeFocus)
{if(!this._searchResults.length)
return;if(this._currentSearchResultIndex===-1||this._cursorDoesNotMatchLastRevealedSearchResult()){this._revealFirstSearchResultBeforeCursor(changeFocus);return;}
if(this._currentSearchResultIndex>0)
--this._currentSearchResultIndex;else
this._currentSearchResultIndex=this._searchResults.length-1;this._revealSearchResult(this._searchResults[this._currentSearchResultIndex],changeFocus,-1);}
revealNextSearchResult(changeFocus)
{if(!this._searchResults.length)
return;if(this._currentSearchResultIndex===-1||this._cursorDoesNotMatchLastRevealedSearchResult()){this._revealFirstSearchResultAfterCursor(changeFocus);return;}
if(this._currentSearchResultIndex+1<this._searchResults.length)
++this._currentSearchResultIndex;else
this._currentSearchResultIndex=0;this._revealSearchResult(this._searchResults[this._currentSearchResultIndex],changeFocus,1);}
line(lineNumber)
{return this._codeMirror.getLine(lineNumber);}
getTextInRange(startPosition,endPosition)
{return this._codeMirror.getRange(startPosition,endPosition);}
addStyleToTextRange(startPosition,endPosition,styleClassName)
{endPosition.ch+=1;return this._codeMirror.getDoc().markText(startPosition,endPosition,{className:styleClassName,inclusiveLeft:true,inclusiveRight:true});}
revealPosition(position,textRangeToSelect,forceUnformatted,noHighlight)
{if(!(position instanceof WebInspector.SourceCodePosition))
return;if(!this._visible||this._initialStringNotSet||this._deferReveal){this._positionToReveal=position;this._textRangeToSelect=textRangeToSelect;this._forceUnformatted=forceUnformatted;return;}
delete this._positionToReveal;delete this._textRangeToSelect;delete this._forceUnformatted;if(this._formatted&&forceUnformatted){this.updateFormattedState(false).then(()=>{setTimeout(this.revealPosition.bind(this),0,position,textRangeToSelect);});return;}
let line=Number.constrain(position.lineNumber,0,this._codeMirror.lineCount()-1);let lineHandle=this._codeMirror.getLineHandle(line);if(!textRangeToSelect){let column=Number.constrain(position.columnNumber,0,this._codeMirror.getLine(line).length-1);textRangeToSelect=new WebInspector.TextRange(line,column,line,column);}
function removeStyleClass()
{this._codeMirror.removeLineClass(lineHandle,"wrap",WebInspector.TextEditor.HighlightedStyleClassName);}
function revealAndHighlightLine()
{var position=this._codeMirrorPositionFromTextRange(textRangeToSelect);if(!this._isPositionVisible(position.start))
this._scrollIntoViewCentered(position.start);this.selectedTextRange=textRangeToSelect;if(noHighlight)
return;if(WebInspector.debuggerManager.paused&&line===this._executionLineNumber)
return;this._codeMirror.addLineClass(lineHandle,"wrap",WebInspector.TextEditor.HighlightedStyleClassName);

setTimeout(removeStyleClass.bind(this),WebInspector.TextEditor.HighlightAnimationDuration);}
this._codeMirror.operation(revealAndHighlightLine.bind(this));}
shown()
{this._visible=true;this._codeMirror.refresh();
this._revealPendingPositionIfPossible();}
hidden()
{this._visible=false;}
close()
{WebInspector.settings.indentWithTabs.removeEventListener(null,null,this);WebInspector.settings.indentUnit.removeEventListener(null,null,this);WebInspector.settings.tabSize.removeEventListener(null,null,this);WebInspector.settings.enableLineWrapping.removeEventListener(null,null,this);WebInspector.settings.showWhitespaceCharacters.removeEventListener(null,null,this);}
setBreakpointInfoForLineAndColumn(lineNumber,columnNumber,breakpointInfo)
{if(this._ignoreSetBreakpointInfoCalls)
return;if(breakpointInfo)
this._addBreakpointToLineAndColumnWithInfo(lineNumber,columnNumber,breakpointInfo);else
this._removeBreakpointFromLineAndColumn(lineNumber,columnNumber);}
updateBreakpointLineAndColumn(oldLineNumber,oldColumnNumber,newLineNumber,newColumnNumber)
{if(!this._breakpoints[oldLineNumber])
return;if(!this._breakpoints[oldLineNumber][oldColumnNumber])
return;var breakpointInfo=this._breakpoints[oldLineNumber][oldColumnNumber];this._removeBreakpointFromLineAndColumn(oldLineNumber,oldColumnNumber);this._addBreakpointToLineAndColumnWithInfo(newLineNumber,newColumnNumber,breakpointInfo);}
addStyleClassToLine(lineNumber,styleClassName)
{var lineHandle=this._codeMirror.getLineHandle(lineNumber);if(!lineHandle)
return null;return this._codeMirror.addLineClass(lineHandle,"wrap",styleClassName);}
removeStyleClassFromLine(lineNumber,styleClassName)
{var lineHandle=this._codeMirror.getLineHandle(lineNumber);if(!lineHandle)
return null;return this._codeMirror.removeLineClass(lineHandle,"wrap",styleClassName);}
toggleStyleClassForLine(lineNumber,styleClassName)
{var lineHandle=this._codeMirror.getLineHandle(lineNumber);if(!lineHandle)
return false;return this._codeMirror.toggleLineClass(lineHandle,"wrap",styleClassName);}
createWidgetForLine(lineNumber)
{var lineHandle=this._codeMirror.getLineHandle(lineNumber);if(!lineHandle)
return null;var widgetElement=document.createElement("div");var lineWidget=this._codeMirror.addLineWidget(lineHandle,widgetElement,{coverGutter:false,noHScroll:true});return new WebInspector.LineWidget(lineWidget,widgetElement);}
get lineCount()
{return this._codeMirror.lineCount();}
focus()
{this._codeMirror.focus();}
contentDidChange(replacedRanges,newRanges)
{}
rectsForRange(range)
{return this._codeMirror.rectsForRange(range);}
get markers()
{return this._codeMirror.getAllMarks().map(WebInspector.TextMarker.textMarkerForCodeMirrorTextMarker);}
markersAtPosition(position)
{return this._codeMirror.findMarksAt(position).map(WebInspector.TextMarker.textMarkerForCodeMirrorTextMarker);}
createColorMarkers(range)
{return createCodeMirrorColorTextMarkers(this._codeMirror,range);}
createGradientMarkers(range)
{return createCodeMirrorGradientTextMarkers(this._codeMirror,range);}
createCubicBezierMarkers(range)
{return createCodeMirrorCubicBezierTextMarkers(this._codeMirror,range);}
createSpringMarkers(range)
{return createCodeMirrorSpringTextMarkers(this._codeMirror,range);}
editingControllerForMarker(editableMarker)
{switch(editableMarker.type){case WebInspector.TextMarker.Type.Color:return new WebInspector.CodeMirrorColorEditingController(this._codeMirror,editableMarker);case WebInspector.TextMarker.Type.Gradient:return new WebInspector.CodeMirrorGradientEditingController(this._codeMirror,editableMarker);case WebInspector.TextMarker.Type.CubicBezier:return new WebInspector.CodeMirrorBezierEditingController(this._codeMirror,editableMarker);case WebInspector.TextMarker.Type.Spring:return new WebInspector.CodeMirrorSpringEditingController(this._codeMirror,editableMarker);default:return new WebInspector.CodeMirrorEditingController(this._codeMirror,editableMarker);}}
visibleRangeOffsets()
{var startOffset=null;var endOffset=null;var visibleRange=this._codeMirror.getViewport();if(this._formatterSourceMap){startOffset=this._formatterSourceMap.formattedToOriginalOffset(Math.max(visibleRange.from-1,0),0);endOffset=this._formatterSourceMap.formattedToOriginalOffset(visibleRange.to-1,0);}else{startOffset=this._codeMirror.getDoc().indexFromPos({line:visibleRange.from,ch:0});endOffset=this._codeMirror.getDoc().indexFromPos({line:visibleRange.to,ch:0});}
return{startOffset,endOffset};}
originalOffsetToCurrentPosition(offset)
{var position=null;if(this._formatterSourceMap){var location=this._formatterSourceMap.originalPositionToFormatted(offset);position={line:location.lineNumber,ch:location.columnNumber};}else
position=this._codeMirror.getDoc().posFromIndex(offset);return position;}
currentOffsetToCurrentPosition(offset)
{return this._codeMirror.getDoc().posFromIndex(offset);}
currentPositionToOriginalOffset(position)
{let offset=null;if(this._formatterSourceMap)
offset=this._formatterSourceMap.formattedToOriginalOffset(position.line,position.ch);else
offset=this._codeMirror.getDoc().indexFromPos(position);return offset;}
currentPositionToOriginalPosition(position)
{if(!this._formatterSourceMap)
return position;let location=this._formatterSourceMap.formattedToOriginal(position.line,position.ch);return{line:location.lineNumber,ch:location.columnNumber};}
currentPositionToCurrentOffset(position)
{return this._codeMirror.getDoc().indexFromPos(position);}
setInlineWidget(position,inlineElement)
{return this._codeMirror.setUniqueBookmark(position,{widget:inlineElement});}
addScrollHandler(handler)
{this._codeMirror.on("scroll",handler);}
removeScrollHandler(handler)
{this._codeMirror.off("scroll",handler);} 
layout()
{

if(this._visible)
this._codeMirror.refresh();}
_format(formatted)
{if(this._formatted===formatted)
return Promise.resolve(this._formatted);if(formatted&&!this.canBeFormatted())
return Promise.resolve(this._formatted);if(this._formattingPromise)
return this._formattingPromise;this._ignoreCodeMirrorContentDidChangeEvent++;this._formattingPromise=this.prettyPrint(formatted).then(()=>{this._ignoreCodeMirrorContentDidChangeEvent--;this._formattingPromise=null;let originalFormatted=this._formatted;this._formatted=!!this._formatterSourceMap;if(this._formatted!==originalFormatted)
this.dispatchEventToListeners(WebInspector.TextEditor.Event.FormattingDidChange);return this._formatted;});return this._formattingPromise;}
prettyPrint(pretty)
{return new Promise((resolve,reject)=>{let beforePrettyPrintState={selectionAnchor:this._codeMirror.getCursor("anchor"),selectionHead:this._codeMirror.getCursor("head"),};if(!pretty)
this._undoFormatting(beforePrettyPrintState,resolve);else if(this._canUseFormatterWorker())
this._startWorkerPrettyPrint(beforePrettyPrintState,resolve);else
this._startCodeMirrorPrettyPrint(beforePrettyPrintState,resolve);});}
_canUseFormatterWorker()
{return this._codeMirror.getMode().name==="javascript";}
_startWorkerPrettyPrint(beforePrettyPrintState,callback)
{let sourceText=this._codeMirror.getValue();let indentString=WebInspector.indentString();const includeSourceMapData=true;let sourceType=this._delegate?this._delegate.textEditorScriptSourceType(this):WebInspector.Script.SourceType.Program;const isModule=sourceType===WebInspector.Script.SourceType.Module;let workerProxy=WebInspector.FormatterWorkerProxy.singleton();workerProxy.formatJavaScript(sourceText,isModule,indentString,includeSourceMapData,({formattedText,sourceMapData})=>{if(formattedText===null){callback();return;}
this._finishPrettyPrint(beforePrettyPrintState,formattedText,sourceMapData,callback);});}
_startCodeMirrorPrettyPrint(beforePrettyPrintState,callback)
{let indentString=WebInspector.indentString();let start={line:0,ch:0};let end={line:this._codeMirror.lineCount()-1};let builder=new FormatterContentBuilder(indentString);let formatter=new WebInspector.Formatter(this._codeMirror,builder);formatter.format(start,end);let formattedText=builder.formattedContent;let sourceMapData=builder.sourceMapData;this._finishPrettyPrint(beforePrettyPrintState,formattedText,sourceMapData,callback);}
_finishPrettyPrint(beforePrettyPrintState,formattedText,sourceMapData,callback)
{this._codeMirror.operation(()=>{this._formatterSourceMap=WebInspector.FormatterSourceMap.fromSourceMapData(sourceMapData);this._codeMirror.setValue(formattedText);this._updateAfterFormatting(true,beforePrettyPrintState);});callback();}
_undoFormatting(beforePrettyPrintState,callback)
{this._codeMirror.operation(()=>{this._codeMirror.undo();this._updateAfterFormatting(false,beforePrettyPrintState);});callback();}
_updateAfterFormatting(pretty,beforePrettyPrintState)
{let oldSelectionAnchor=beforePrettyPrintState.selectionAnchor;let oldSelectionHead=beforePrettyPrintState.selectionHead;let newSelectionAnchor,newSelectionHead;let newExecutionLocation=null;if(pretty){if(this._positionToReveal){let newRevealPosition=this._formatterSourceMap.originalToFormatted(this._positionToReveal.lineNumber,this._positionToReveal.columnNumber);this._positionToReveal=new WebInspector.SourceCodePosition(newRevealPosition.lineNumber,newRevealPosition.columnNumber);}
if(this._textRangeToSelect){let mappedRevealSelectionStart=this._formatterSourceMap.originalToFormatted(this._textRangeToSelect.startLine,this._textRangeToSelect.startColumn);let mappedRevealSelectionEnd=this._formatterSourceMap.originalToFormatted(this._textRangeToSelect.endLine,this._textRangeToSelect.endColumn);this._textRangeToSelect=new WebInspector.TextRange(mappedRevealSelectionStart.lineNumber,mappedRevealSelectionStart.columnNumber,mappedRevealSelectionEnd.lineNumber,mappedRevealSelectionEnd.columnNumber);}
if(!isNaN(this._executionLineNumber)){newExecutionLocation=this._formatterSourceMap.originalToFormatted(this._executionLineNumber,this._executionColumnNumber);}
let mappedAnchorLocation=this._formatterSourceMap.originalToFormatted(oldSelectionAnchor.line,oldSelectionAnchor.ch);let mappedHeadLocation=this._formatterSourceMap.originalToFormatted(oldSelectionHead.line,oldSelectionHead.ch);newSelectionAnchor={line:mappedAnchorLocation.lineNumber,ch:mappedAnchorLocation.columnNumber};newSelectionHead={line:mappedHeadLocation.lineNumber,ch:mappedHeadLocation.columnNumber};}else{if(this._positionToReveal){let newRevealPosition=this._formatterSourceMap.formattedToOriginal(this._positionToReveal.lineNumber,this._positionToReveal.columnNumber);this._positionToReveal=new WebInspector.SourceCodePosition(newRevealPosition.lineNumber,newRevealPosition.columnNumber);}
if(this._textRangeToSelect){let mappedRevealSelectionStart=this._formatterSourceMap.formattedToOriginal(this._textRangeToSelect.startLine,this._textRangeToSelect.startColumn);let mappedRevealSelectionEnd=this._formatterSourceMap.formattedToOriginal(this._textRangeToSelect.endLine,this._textRangeToSelect.endColumn);this._textRangeToSelect=new WebInspector.TextRange(mappedRevealSelectionStart.lineNumber,mappedRevealSelectionStart.columnNumber,mappedRevealSelectionEnd.lineNumber,mappedRevealSelectionEnd.columnNumber);}
if(!isNaN(this._executionLineNumber)){newExecutionLocation=this._formatterSourceMap.formattedToOriginal(this._executionLineNumber,this._executionColumnNumber);}
let mappedAnchorLocation=this._formatterSourceMap.formattedToOriginal(oldSelectionAnchor.line,oldSelectionAnchor.ch);let mappedHeadLocation=this._formatterSourceMap.formattedToOriginal(oldSelectionHead.line,oldSelectionHead.ch);newSelectionAnchor={line:mappedAnchorLocation.lineNumber,ch:mappedAnchorLocation.columnNumber};newSelectionHead={line:mappedHeadLocation.lineNumber,ch:mappedHeadLocation.columnNumber};this._formatterSourceMap=null;}
this._scrollIntoViewCentered(newSelectionAnchor);this._codeMirror.setSelection(newSelectionAnchor,newSelectionHead);if(newExecutionLocation){this._executionLineHandle=null;this._executionMultilineHandles=[];this.setExecutionLineAndColumn(newExecutionLocation.lineNumber,newExecutionLocation.columnNumber);}
if(this.currentSearchQuery){let searchQuery=this.currentSearchQuery;this.searchCleared();setTimeout(()=>{this.performSearch(searchQuery);},0);}
if(this._delegate&&typeof this._delegate.textEditorUpdatedFormatting==="function")
this._delegate.textEditorUpdatedFormatting(this);} 
hasEdits()
{return!this._codeMirror.isClean();}
_contentChanged(codeMirror,change)
{if(this._ignoreCodeMirrorContentDidChangeEvent>0)
return;var replacedRanges=[];var newRanges=[];while(change){replacedRanges.push(new WebInspector.TextRange(change.from.line,change.from.ch,change.to.line,change.to.ch));newRanges.push(new WebInspector.TextRange(change.from.line,change.from.ch,change.from.line+change.text.length-1,change.text.length===1?change.from.ch+change.text[0].length:change.text.lastValue.length));change=change.next;}
this.contentDidChange(replacedRanges,newRanges);if(this._formatted){this._formatterSourceMap=null;this._formatted=false;if(this._delegate&&typeof this._delegate.textEditorUpdatedFormatting==="function")
this._delegate.textEditorUpdatedFormatting(this);this.dispatchEventToListeners(WebInspector.TextEditor.Event.FormattingDidChange);}
this.dispatchEventToListeners(WebInspector.TextEditor.Event.ContentDidChange);}
_textRangeFromCodeMirrorPosition(start,end)
{return new WebInspector.TextRange(start.line,start.ch,end.line,end.ch);}
_codeMirrorPositionFromTextRange(textRange)
{var start={line:textRange.startLine,ch:textRange.startColumn};var end={line:textRange.endLine,ch:textRange.endColumn};return{start,end};}
_revealPendingPositionIfPossible()
{if(!this._positionToReveal)
return;if(!this._visible)
return;this.revealPosition(this._positionToReveal,this._textRangeToSelect,this._forceUnformatted);}
_revealSearchResult(result,changeFocus,directionInCaseOfRevalidation)
{var position=result.find();if(!position){this._revalidateSearchResults(directionInCaseOfRevalidation);return;}
if(!this._isPositionVisible(position.from))
this._scrollIntoViewCentered(position.from);this.selectedTextRange=this._textRangeFromCodeMirrorPosition(position.from,position.to);this._automaticallyRevealFirstSearchResult=false;if(changeFocus)
this._codeMirror.focus();
if(this._bouncyHighlightElement)
this._bouncyHighlightElement.remove();this._bouncyHighlightElement=document.createElement("div");this._bouncyHighlightElement.className=WebInspector.TextEditor.BouncyHighlightStyleClassName;var textContent=this._codeMirror.getSelection();var coordinates=this._codeMirror.cursorCoords(true,"page");let textEditorRect=this.element.getBoundingClientRect();coordinates.top-=textEditorRect.top;coordinates.left-=textEditorRect.left;this._bouncyHighlightElement.textContent=textContent;this._bouncyHighlightElement.style.top=coordinates.top+"px";this._bouncyHighlightElement.style.left=coordinates.left+"px";this.element.appendChild(this._bouncyHighlightElement);let scrollHandler=()=>{if(this._bouncyHighlightElement)
this._bouncyHighlightElement.remove();};this.addScrollHandler(scrollHandler);function animationEnded()
{if(!this._bouncyHighlightElement)
return;this._bouncyHighlightElement.remove();delete this._bouncyHighlightElement;this.removeScrollHandler(scrollHandler);}
this._bouncyHighlightElement.addEventListener("animationend",animationEnded.bind(this));}
_binarySearchInsertionIndexInSearchResults(object,comparator)
{
var array=this._searchResults;var first=0;var last=array.length-1;while(first<=last){var mid=(first+last)>>1;var c=comparator(object,array[mid]);if(c===null)
return null;if(c>0)
first=mid+1;else if(c<0)
last=mid-1;else
return mid;}
return first-1;}
_revealFirstSearchResultBeforeCursor(changeFocus)
{var currentCursorPosition=this._codeMirror.getCursor("start");if(currentCursorPosition.line===0&&currentCursorPosition.ch===0){this._currentSearchResultIndex=this._searchResults.length-1;this._revealSearchResult(this._searchResults[this._currentSearchResultIndex],changeFocus,-1);return;}
var index=this._binarySearchInsertionIndexInSearchResults(currentCursorPosition,function(current,searchResult){var searchResultMarker=searchResult.find();if(!searchResultMarker)
return null;return WebInspector.compareCodeMirrorPositions(current,searchResultMarker.from);});if(index===null){this._revalidateSearchResults(-1);return;}
this._currentSearchResultIndex=index;this._revealSearchResult(this._searchResults[this._currentSearchResultIndex],changeFocus);}
_revealFirstSearchResultAfterCursor(changeFocus)
{var currentCursorPosition=this._codeMirror.getCursor("start");if(currentCursorPosition.line===0&&currentCursorPosition.ch===0){this._currentSearchResultIndex=0;this._revealSearchResult(this._searchResults[this._currentSearchResultIndex],changeFocus,1);return;}
var index=this._binarySearchInsertionIndexInSearchResults(currentCursorPosition,function(current,searchResult){var searchResultMarker=searchResult.find();if(!searchResultMarker)
return null;return WebInspector.compareCodeMirrorPositions(current,searchResultMarker.from);});if(index===null){this._revalidateSearchResults(1);return;}
if(index+1<this._searchResults.length)
++index;else
index=0;this._currentSearchResultIndex=index;this._revealSearchResult(this._searchResults[this._currentSearchResultIndex],changeFocus);}
_cursorDoesNotMatchLastRevealedSearchResult()
{var lastRevealedSearchResultMarker=this._searchResults[this._currentSearchResultIndex].find();if(!lastRevealedSearchResultMarker)
return true;var currentCursorPosition=this._codeMirror.getCursor("start");var lastRevealedSearchResultPosition=lastRevealedSearchResultMarker.from;return WebInspector.compareCodeMirrorPositions(currentCursorPosition,lastRevealedSearchResultPosition)!==0;}
_revalidateSearchResults(direction)
{this._currentSearchResultIndex=-1;var updatedSearchResults=[];for(var i=0;i<this._searchResults.length;++i){if(this._searchResults[i].find())
updatedSearchResults.push(this._searchResults[i]);}
this._searchResults=updatedSearchResults;this.dispatchEventToListeners(WebInspector.TextEditor.Event.NumberOfSearchResultsDidChange);if(this._searchResults.length){if(direction>0)
this._revealFirstSearchResultAfterCursor();else
this._revealFirstSearchResultBeforeCursor();}}
_clearMultilineExecutionLineHighlights()
{if(this._executionMultilineHandles.length){for(let lineHandle of this._executionMultilineHandles)
this._codeMirror.removeLineClass(lineHandle,"wrap",WebInspector.TextEditor.ExecutionLineStyleClassName);this._executionMultilineHandles=[];}}
_updateExecutionLine()
{this._codeMirror.operation(()=>{if(this._executionLineHandle){this._codeMirror.removeLineClass(this._executionLineHandle,"wrap",WebInspector.TextEditor.ExecutionLineStyleClassName);this._codeMirror.removeLineClass(this._executionLineHandle,"wrap","primary");}
this._clearMultilineExecutionLineHighlights();this._executionLineHandle=!isNaN(this._executionLineNumber)?this._codeMirror.getLineHandle(this._executionLineNumber):null;if(this._executionLineHandle){this._codeMirror.addLineClass(this._executionLineHandle,"wrap",WebInspector.TextEditor.ExecutionLineStyleClassName);this._codeMirror.addLineClass(this._executionLineHandle,"wrap","primary");this._codeMirror.removeLineClass(this._executionLineHandle,"wrap",WebInspector.TextEditor.HighlightedStyleClassName);}});}
_updateExecutionRangeHighlight()
{if(this._executionRangeHighlightMarker){this._executionRangeHighlightMarker.clear();this._executionRangeHighlightMarker=null;}
if(isNaN(this._executionLineNumber))
return;let currentPosition={line:this._executionLineNumber,ch:this._executionColumnNumber};let originalOffset=this.currentPositionToOriginalOffset(currentPosition);let originalCodeMirrorPosition=this.currentPositionToOriginalPosition(currentPosition);let originalPosition=new WebInspector.SourceCodePosition(originalCodeMirrorPosition.line,originalCodeMirrorPosition.ch);let characterAtOffset=this._codeMirror.getRange(currentPosition,{line:this._executionLineNumber,ch:this._executionColumnNumber+1});this._delegate.textEditorExecutionHighlightRange(originalOffset,originalPosition,characterAtOffset,(range)=>{let start,end;if(!range){start={line:this._executionLineNumber,ch:this._executionColumnNumber};end={line:this._executionLineNumber};}else{start=this.originalOffsetToCurrentPosition(range[0]);end=this.originalOffsetToCurrentPosition(range[1]);}
if(this._executionRangeHighlightMarker){this._executionRangeHighlightMarker.clear();this._executionRangeHighlightMarker=null;}
let text=this._codeMirror.getRange(start,end);let trailingWhitespace=text.match(/\s+$/);if(trailingWhitespace)
end.ch=Math.max(0,end.ch-trailingWhitespace[0].length);this._clearMultilineExecutionLineHighlights();if(start.line!==end.line){for(let line=start.line;line<end.line;++line){let lineHandle=this._codeMirror.getLineHandle(line);this._codeMirror.addLineClass(lineHandle,"wrap",WebInspector.TextEditor.ExecutionLineStyleClassName);this._executionMultilineHandles.push(lineHandle);}}
this._executionRangeHighlightMarker=this._codeMirror.markText(start,end,{className:"execution-range-highlight"});});}
_setBreakpointStylesOnLine(lineNumber)
{var columnBreakpoints=this._breakpoints[lineNumber];if(!columnBreakpoints)
return;var allDisabled=true;var allResolved=true;var allAutoContinue=true;var multiple=Object.keys(columnBreakpoints).length>1;for(var columnNumber in columnBreakpoints){var breakpointInfo=columnBreakpoints[columnNumber];if(!breakpointInfo.disabled)
allDisabled=false;if(!breakpointInfo.resolved)
allResolved=false;if(!breakpointInfo.autoContinue)
allAutoContinue=false;}
allResolved=allResolved&&WebInspector.debuggerManager.breakpointsEnabled;function updateStyles()
{var lineHandle=this._codeMirror.getLineHandle(lineNumber);if(!lineHandle)
return;this._codeMirror.addLineClass(lineHandle,"wrap",WebInspector.TextEditor.HasBreakpointStyleClassName);if(allResolved)
this._codeMirror.addLineClass(lineHandle,"wrap",WebInspector.TextEditor.BreakpointResolvedStyleClassName);else
this._codeMirror.removeLineClass(lineHandle,"wrap",WebInspector.TextEditor.BreakpointResolvedStyleClassName);if(allDisabled)
this._codeMirror.addLineClass(lineHandle,"wrap",WebInspector.TextEditor.BreakpointDisabledStyleClassName);else
this._codeMirror.removeLineClass(lineHandle,"wrap",WebInspector.TextEditor.BreakpointDisabledStyleClassName);if(allAutoContinue)
this._codeMirror.addLineClass(lineHandle,"wrap",WebInspector.TextEditor.BreakpointAutoContinueStyleClassName);else
this._codeMirror.removeLineClass(lineHandle,"wrap",WebInspector.TextEditor.BreakpointAutoContinueStyleClassName);if(multiple)
this._codeMirror.addLineClass(lineHandle,"wrap",WebInspector.TextEditor.MultipleBreakpointsStyleClassName);else
this._codeMirror.removeLineClass(lineHandle,"wrap",WebInspector.TextEditor.MultipleBreakpointsStyleClassName);}
this._codeMirror.operation(updateStyles.bind(this));}
_addBreakpointToLineAndColumnWithInfo(lineNumber,columnNumber,breakpointInfo)
{if(!this._breakpoints[lineNumber])
this._breakpoints[lineNumber]={};this._breakpoints[lineNumber][columnNumber]=breakpointInfo;this._setBreakpointStylesOnLine(lineNumber);}
_removeBreakpointFromLineAndColumn(lineNumber,columnNumber)
{delete this._breakpoints[lineNumber][columnNumber];if(!isEmptyObject(this._breakpoints[lineNumber])){this._setBreakpointStylesOnLine(lineNumber);return;}
delete this._breakpoints[lineNumber];function updateStyles()
{var lineHandle=this._codeMirror.getLineHandle(lineNumber);if(!lineHandle)
return;this._codeMirror.removeLineClass(lineHandle,"wrap",WebInspector.TextEditor.HasBreakpointStyleClassName);this._codeMirror.removeLineClass(lineHandle,"wrap",WebInspector.TextEditor.BreakpointResolvedStyleClassName);this._codeMirror.removeLineClass(lineHandle,"wrap",WebInspector.TextEditor.BreakpointDisabledStyleClassName);this._codeMirror.removeLineClass(lineHandle,"wrap",WebInspector.TextEditor.BreakpointAutoContinueStyleClassName);this._codeMirror.removeLineClass(lineHandle,"wrap",WebInspector.TextEditor.MultipleBreakpointsStyleClassName);}
this._codeMirror.operation(updateStyles.bind(this));}
_allColumnBreakpointInfoForLine(lineNumber)
{return this._breakpoints[lineNumber];}
_setColumnBreakpointInfoForLine(lineNumber,columnBreakpointInfo)
{this._breakpoints[lineNumber]=columnBreakpointInfo;this._setBreakpointStylesOnLine(lineNumber);}
_gutterMouseDown(codeMirror,lineNumber,gutterElement,event)
{if(event.button!==0||event.ctrlKey)
return;if(!this._codeMirror.hasLineClass(lineNumber,"wrap",WebInspector.TextEditor.HasBreakpointStyleClassName)){if(this._delegate&&typeof this._delegate.textEditorBreakpointAdded==="function"){var data=this._delegate.textEditorBreakpointAdded(this,lineNumber,0);if(data){var breakpointInfo=data.breakpointInfo;if(breakpointInfo)
this._addBreakpointToLineAndColumnWithInfo(data.lineNumber,data.columnNumber,breakpointInfo);}}
return;}
if(this._codeMirror.hasLineClass(lineNumber,"wrap",WebInspector.TextEditor.MultipleBreakpointsStyleClassName)){return;}
var columnNumber=Object.keys(this._breakpoints[lineNumber])[0];this._draggingBreakpointInfo=this._breakpoints[lineNumber][columnNumber];this._lineNumberWithMousedDownBreakpoint=lineNumber;this._lineNumberWithDraggedBreakpoint=lineNumber;this._columnNumberWithMousedDownBreakpoint=columnNumber;this._columnNumberWithDraggedBreakpoint=columnNumber;this._documentMouseMovedEventListener=this._documentMouseMoved.bind(this);this._documentMouseUpEventListener=this._documentMouseUp.bind(this);document.addEventListener("mousemove",this._documentMouseMovedEventListener,true);document.addEventListener("mouseup",this._documentMouseUpEventListener,true);}
_gutterContextMenu(codeMirror,lineNumber,gutterElement,event)
{if(this._delegate&&typeof this._delegate.textEditorGutterContextMenu==="function"){var breakpoints=[];for(var columnNumber in this._breakpoints[lineNumber])
breakpoints.push({lineNumber,columnNumber});this._delegate.textEditorGutterContextMenu(this,lineNumber,0,breakpoints,event);}}
_documentMouseMoved(event)
{if(!("_lineNumberWithMousedDownBreakpoint"in this))
return;event.preventDefault();var lineNumber;var position=this._codeMirror.coordsChar({left:event.pageX,top:event.pageY});
var gutterBounds=this._codeMirror.getGutterElement().getBoundingClientRect();if(event.pageX<gutterBounds.left||event.pageX>gutterBounds.right||event.pageY<gutterBounds.top||event.pageY>gutterBounds.bottom)
position=null;if(position&&"line"in position)
lineNumber=position.line;
if(lineNumber===this._lineNumberWithDraggedBreakpoint)
return;
this._mouseDragged=true;if("_lineNumberWithDraggedBreakpoint"in this){
if(this._previousColumnBreakpointInfo)
this._setColumnBreakpointInfoForLine(this._lineNumberWithDraggedBreakpoint,this._previousColumnBreakpointInfo);else
this._removeBreakpointFromLineAndColumn(this._lineNumberWithDraggedBreakpoint,this._columnNumberWithDraggedBreakpoint);delete this._previousColumnBreakpointInfo;delete this._lineNumberWithDraggedBreakpoint;delete this._columnNumberWithDraggedBreakpoint;}
if(lineNumber!==undefined){var newColumnBreakpoints={};var columnNumber=(lineNumber===this._lineNumberWithMousedDownBreakpoint?this._columnNumberWithDraggedBreakpoint:0);newColumnBreakpoints[columnNumber]=this._draggingBreakpointInfo;this._previousColumnBreakpointInfo=this._allColumnBreakpointInfoForLine(lineNumber);this._setColumnBreakpointInfoForLine(lineNumber,newColumnBreakpoints);this._lineNumberWithDraggedBreakpoint=lineNumber;this._columnNumberWithDraggedBreakpoint=columnNumber;}}
_documentMouseUp(event)
{if(!("_lineNumberWithMousedDownBreakpoint"in this))
return;event.preventDefault();document.removeEventListener("mousemove",this._documentMouseMovedEventListener,true);document.removeEventListener("mouseup",this._documentMouseUpEventListener,true);var delegateImplementsBreakpointClicked=this._delegate&&typeof this._delegate.textEditorBreakpointClicked==="function";var delegateImplementsBreakpointRemoved=this._delegate&&typeof this._delegate.textEditorBreakpointRemoved==="function";var delegateImplementsBreakpointMoved=this._delegate&&typeof this._delegate.textEditorBreakpointMoved==="function";if(this._mouseDragged){if(!("_lineNumberWithDraggedBreakpoint"in this)){if(delegateImplementsBreakpointRemoved){this._ignoreSetBreakpointInfoCalls=true;this._delegate.textEditorBreakpointRemoved(this,this._lineNumberWithMousedDownBreakpoint,this._columnNumberWithMousedDownBreakpoint);delete this._ignoreSetBreakpointInfoCalls;}}else if(this._lineNumberWithMousedDownBreakpoint!==this._lineNumberWithDraggedBreakpoint){
if(this._previousColumnBreakpointInfo&&delegateImplementsBreakpointRemoved){this._ignoreSetBreakpointInfoCalls=true;for(var columnNumber in this._previousColumnBreakpointInfo)
this._delegate.textEditorBreakpointRemoved(this,this._lineNumberWithDraggedBreakpoint,columnNumber);delete this._ignoreSetBreakpointInfoCalls;}
if(delegateImplementsBreakpointMoved){this._ignoreSetBreakpointInfoCalls=true;this._delegate.textEditorBreakpointMoved(this,this._lineNumberWithMousedDownBreakpoint,this._columnNumberWithMousedDownBreakpoint,this._lineNumberWithDraggedBreakpoint,this._columnNumberWithDraggedBreakpoint);delete this._ignoreSetBreakpointInfoCalls;}}}else{if(this._lineNumberWithMousedDownBreakpoint in this._breakpoints&&this._columnNumberWithMousedDownBreakpoint in this._breakpoints[this._lineNumberWithMousedDownBreakpoint]&&delegateImplementsBreakpointClicked)
this._delegate.textEditorBreakpointClicked(this,this._lineNumberWithMousedDownBreakpoint,this._columnNumberWithMousedDownBreakpoint);}
delete this._documentMouseMovedEventListener;delete this._documentMouseUpEventListener;delete this._lineNumberWithMousedDownBreakpoint;delete this._lineNumberWithDraggedBreakpoint;delete this._columnNumberWithMousedDownBreakpoint;delete this._columnNumberWithDraggedBreakpoint;delete this._previousColumnBreakpointInfo;delete this._mouseDragged;}
_openClickedLinks(event)
{var position=this._codeMirror.coordsChar({left:event.pageX,top:event.pageY});var tokenInfo=this._codeMirror.getTokenAt(position);if(!tokenInfo||!tokenInfo.type||!tokenInfo.string)
return;if(!/\blink\b/.test(tokenInfo.type))
return;var url=tokenInfo.string;var baseURL="";if(this._delegate&&typeof this._delegate.textEditorBaseURL==="function")
baseURL=this._delegate.textEditorBaseURL(this);WebInspector.openURL(absoluteURL(url,baseURL));event.preventDefault();event.stopPropagation();}
_isPositionVisible(position)
{var scrollInfo=this._codeMirror.getScrollInfo();var visibleRangeStart=scrollInfo.top;var visibleRangeEnd=visibleRangeStart+scrollInfo.clientHeight;var coords=this._codeMirror.charCoords(position,"local");return coords.top>=visibleRangeStart&&coords.bottom<=visibleRangeEnd;}
_scrollIntoViewCentered(position)
{var scrollInfo=this._codeMirror.getScrollInfo();var lineHeight=Math.ceil(this._codeMirror.defaultTextHeight());var margin=Math.floor((scrollInfo.clientHeight-lineHeight)/2);this._codeMirror.scrollIntoView(position,margin);}};WebInspector.TextEditor.HighlightedStyleClassName="highlighted";WebInspector.TextEditor.SearchResultStyleClassName="search-result";WebInspector.TextEditor.HasBreakpointStyleClassName="has-breakpoint";WebInspector.TextEditor.BreakpointResolvedStyleClassName="breakpoint-resolved";WebInspector.TextEditor.BreakpointAutoContinueStyleClassName="breakpoint-auto-continue";WebInspector.TextEditor.BreakpointDisabledStyleClassName="breakpoint-disabled";WebInspector.TextEditor.MultipleBreakpointsStyleClassName="multiple-breakpoints";WebInspector.TextEditor.ExecutionLineStyleClassName="execution-line";WebInspector.TextEditor.BouncyHighlightStyleClassName="bouncy-highlight";WebInspector.TextEditor.NumberOfFindsPerSearchBatch=10;WebInspector.TextEditor.HighlightAnimationDuration=2000;WebInspector.TextEditor.Event={ExecutionLineNumberDidChange:"text-editor-execution-line-number-did-change",NumberOfSearchResultsDidChange:"text-editor-number-of-search-results-did-change",ContentDidChange:"text-editor-content-did-change",FormattingDidChange:"text-editor-formatting-did-change"};WebInspector.TimelineOverviewGraph=class TimelineOverviewGraph extends WebInspector.View
{constructor(timelineOverview)
{super();this.element.classList.add("timeline-overview-graph");this._zeroTime=0;this._startTime=0;this._endTime=5;this._currentTime=0;this._timelineOverview=timelineOverview;this._selectedRecord=null;this._selectedRecordChanged=false;this._scheduledSelectedRecordLayoutUpdateIdentifier=undefined;this._selected=false;this._visible=true;} 
static createForTimeline(timeline,timelineOverview)
{var timelineType=timeline.type;if(timelineType===WebInspector.TimelineRecord.Type.Network)
return new WebInspector.NetworkTimelineOverviewGraph(timeline,timelineOverview);if(timelineType===WebInspector.TimelineRecord.Type.Layout)
return new WebInspector.LayoutTimelineOverviewGraph(timeline,timelineOverview);if(timelineType===WebInspector.TimelineRecord.Type.Script)
return new WebInspector.ScriptTimelineOverviewGraph(timeline,timelineOverview);if(timelineType===WebInspector.TimelineRecord.Type.RenderingFrame)
return new WebInspector.RenderingFrameTimelineOverviewGraph(timeline,timelineOverview);if(timelineType===WebInspector.TimelineRecord.Type.Memory)
return new WebInspector.MemoryTimelineOverviewGraph(timeline,timelineOverview);if(timelineType===WebInspector.TimelineRecord.Type.HeapAllocations)
return new WebInspector.HeapAllocationsTimelineOverviewGraph(timeline,timelineOverview);throw new Error("Can't make a graph for an unknown timeline.");}
get zeroTime()
{return this._zeroTime;}
set zeroTime(x)
{x=x||0;if(this._zeroTime===x)
return;this._zeroTime=x;this.needsLayout();}
get startTime()
{return this._startTime;}
set startTime(x)
{x=x||0;if(this._startTime===x)
return;this._startTime=x;this.needsLayout();}
get endTime()
{return this._endTime;}
set endTime(x)
{x=x||0;if(this._endTime===x)
return;this._endTime=x;this.needsLayout();}
get currentTime()
{return this._currentTime;}
set currentTime(x)
{x=x||0;if(this._currentTime===x)
return;let oldCurrentTime=this._currentTime;this._currentTime=x;if((this._startTime<=oldCurrentTime&&oldCurrentTime<=this._endTime)||(this._startTime<=this._currentTime&&this._currentTime<=this._endTime))
this.needsLayout();}
get timelineOverview()
{return this._timelineOverview;}
get secondsPerPixel(){return this._timelineOverview.secondsPerPixel;}
get visible()
{return this._visible;}
get selectedRecord()
{return this._selectedRecord;}
set selectedRecord(x)
{if(this._selectedRecord===x)
return;this._selectedRecord=x;this._selectedRecordChanged=true;this._needsSelectedRecordLayout();}
get height()
{return 36;}
get selected(){return this._selected;}
set selected(x)
{if(this._selected===x)
return;this._selected=x;this.element.classList.toggle("selected",this._selected);}
shown()
{if(this._visible)
return;this._visible=true;this.element.classList.toggle("hidden",!this._visible);this.updateLayout();}
hidden()
{if(!this._visible)
return;this._visible=false;this.element.classList.toggle("hidden",!this._visible);}
reset()
{}
recordWasFiltered(record,filtered)
{}
needsLayout()
{if(!this._visible)
return;super.needsLayout();} 
updateSelectedRecord()
{} 
_needsSelectedRecordLayout()
{if(this.layoutPending)
return;if(this._scheduledSelectedRecordLayoutUpdateIdentifier)
return;this._scheduledSelectedRecordLayoutUpdateIdentifier=requestAnimationFrame(()=>{this._scheduledSelectedRecordLayoutUpdateIdentifier=undefined;this.updateSelectedRecord();this.dispatchEventToListeners(WebInspector.TimelineOverviewGraph.Event.RecordSelected,{record:this.selectedRecord});});}};WebInspector.TimelineOverviewGraph.Event={RecordSelected:"timeline-overview-graph-record-selected"};WebInspector.TimelineView=class TimelineView extends WebInspector.ContentView
{constructor(representedObject)
{super(representedObject);this.element.classList.add("timeline-view");this._zeroTime=0;this._startTime=0;this._endTime=5;this._currentTime=0;} 
get scrollableElements()
{if(!this._timelineDataGrid)
return[];return[this._timelineDataGrid.scrollContainer];}
get showsLiveRecordingData()
{return true;}
get showsFilterBar()
{return true;}
get navigationItems()
{return this._scopeBar?[this._scopeBar]:[];}
get selectionPathComponents()
{return null;}
get zeroTime()
{return this._zeroTime;}
set zeroTime(x)
{x=x||0;if(this._zeroTime===x)
return;this._zeroTime=x;this._timesDidChange();}
get startTime()
{return this._startTime;}
set startTime(x)
{x=x||0;if(this._startTime===x)
return;this._startTime=x;this._timesDidChange();this._scheduleFilterDidChange();}
get endTime()
{return this._endTime;}
set endTime(x)
{x=x||0;if(this._endTime===x)
return;this._endTime=x;this._timesDidChange();this._scheduleFilterDidChange();}
get currentTime()
{return this._currentTime;}
set currentTime(x)
{x=x||0;if(this._currentTime===x)
return;let oldCurrentTime=this._currentTime;this._currentTime=x;function checkIfLayoutIsNeeded(currentTime)
{const wiggleTime=0.05; return this._startTime-wiggleTime<=currentTime&&currentTime<=this._endTime+wiggleTime;}
if(checkIfLayoutIsNeeded.call(this,oldCurrentTime)||checkIfLayoutIsNeeded.call(this,this._currentTime))
this._timesDidChange();}
get filterStartTime()
{return this.startTime;}
get filterEndTime()
{return this.endTime;}
setupDataGrid(dataGrid)
{if(this._timelineDataGrid){this._timelineDataGrid.filterDelegate=null;this._timelineDataGrid.removeEventListener(WebInspector.DataGrid.Event.SelectedNodeChanged,this._timelineDataGridSelectedNodeChanged,this);this._timelineDataGrid.removeEventListener(WebInspector.DataGrid.Event.NodeWasFiltered,this._timelineDataGridNodeWasFiltered,this);this._timelineDataGrid.removeEventListener(WebInspector.DataGrid.Event.FilterDidChange,this.filterDidChange,this);}
this._timelineDataGrid=dataGrid;this._timelineDataGrid.filterDelegate=this;this._timelineDataGrid.addEventListener(WebInspector.DataGrid.Event.SelectedNodeChanged,this._timelineDataGridSelectedNodeChanged,this);this._timelineDataGrid.addEventListener(WebInspector.DataGrid.Event.NodeWasFiltered,this._timelineDataGridNodeWasFiltered,this);this._timelineDataGrid.addEventListener(WebInspector.DataGrid.Event.FilterDidChange,this.filterDidChange,this);}
selectRecord(record)
{if(!this._timelineDataGrid)
return;let selectedDataGridNode=this._timelineDataGrid.selectedNode;if(!record){if(selectedDataGridNode)
selectedDataGridNode.deselect();return;}
let dataGridNode=this._timelineDataGrid.findNode((node)=>node.record===record);if(!dataGridNode||dataGridNode.selected)
return;if(selectedDataGridNode&&selectedDataGridNode.hasAncestor(dataGridNode))
return;dataGridNode.revealAndSelect();}
reset()
{}
updateFilter(filters)
{if(!this._timelineDataGrid)
return;this._timelineDataGrid.filterText=filters?filters.text:"";}
matchDataGridNodeAgainstCustomFilters(node)
{return true;}
needsLayout()
{if(!this.visible)
return;super.needsLayout();} 
dataGridMatchNodeAgainstCustomFilters(node)
{if(!this.matchDataGridNodeAgainstCustomFilters(node))
return false;let startTime=this.filterStartTime;let endTime=this.filterEndTime;let currentTime=this.currentTime;function checkTimeBounds(itemStartTime,itemEndTime)
{itemStartTime=itemStartTime||currentTime;itemEndTime=itemEndTime||currentTime;return startTime<=itemEndTime&&itemStartTime<=endTime;}
if(node instanceof WebInspector.ResourceTimelineDataGridNode){let resource=node.resource;return checkTimeBounds(resource.requestSentTimestamp,resource.finishedOrFailedTimestamp);}
if(node instanceof WebInspector.SourceCodeTimelineTimelineDataGridNode){let sourceCodeTimeline=node.sourceCodeTimeline;if(!checkTimeBounds(sourceCodeTimeline.startTime,sourceCodeTimeline.endTime))
return false;for(let record of sourceCodeTimeline.records){if(checkTimeBounds(record.startTime,record.endTime))
return true;}
return false;}
if(node instanceof WebInspector.ProfileNodeDataGridNode){let profileNode=node.profileNode;if(checkTimeBounds(profileNode.startTime,profileNode.endTime))
return true;return false;}
if(node instanceof WebInspector.TimelineDataGridNode){let record=node.record;return checkTimeBounds(record.startTime,record.endTime);}
if(node instanceof WebInspector.ProfileDataGridNode)
return node.callingContextTreeNode.hasStackTraceInTimeRange(startTime,endTime);console.error("Unknown DataGridNode, can't filter by time.");return true;} 
userSelectedRecordFromOverview(timelineRecord)
{}
filterDidChange()
{} 
_timelineDataGridSelectedNodeChanged(event)
{this.dispatchEventToListeners(WebInspector.ContentView.Event.SelectionPathComponentsDidChange);}
_timelineDataGridNodeWasFiltered(event)
{let node=event.data.node;if(!(node instanceof WebInspector.TimelineDataGridNode))
return;this.dispatchEventToListeners(WebInspector.TimelineView.Event.RecordWasFiltered,{record:node.record,filtered:node.hidden});}
_timesDidChange()
{if(!WebInspector.timelineManager.isCapturing()||this.showsLiveRecordingData)
this.needsLayout();}
_scheduleFilterDidChange()
{if(!this._timelineDataGrid||this._updateFilterTimeout)
return;this._updateFilterTimeout=setTimeout(()=>{this._updateFilterTimeout=undefined;this._timelineDataGrid.filterDidChange();},0);}};WebInspector.TimelineView.Event={RecordWasFiltered:"record-was-filtered"};WebInspector.TreeElement=class TreeElement extends WebInspector.Object
{constructor(title,representedObject,hasChildren)
{super();this._title=title;this.representedObject=(representedObject||{});if(this.representedObject.__treeElementIdentifier)
this.identifier=this.representedObject.__treeElementIdentifier;else{this.identifier=WebInspector.TreeOutline._knownTreeElementNextIdentifier++;this.representedObject.__treeElementIdentifier=this.identifier;}
this._hidden=false;this._selectable=true;this.expanded=false;this.selected=false;this.hasChildren=hasChildren;this.children=[];this.treeOutline=null;this.parent=null;this.previousSibling=null;this.nextSibling=null;this._listItemNode=null;} 
appendChild(){return WebInspector.TreeOutline.prototype.appendChild.apply(this,arguments);}
insertChild(){return WebInspector.TreeOutline.prototype.insertChild.apply(this,arguments);}
removeChild(){return WebInspector.TreeOutline.prototype.removeChild.apply(this,arguments);}
removeChildAtIndex(){return WebInspector.TreeOutline.prototype.removeChildAtIndex.apply(this,arguments);}
removeChildren(){return WebInspector.TreeOutline.prototype.removeChildren.apply(this,arguments);}
removeChildrenRecursive(){return WebInspector.TreeOutline.prototype.removeChildrenRecursive.apply(this,arguments);}
selfOrDescendant(){return WebInspector.TreeOutline.prototype.selfOrDescendant.apply(this,arguments);}
get arrowToggleWidth()
{return 10;}
get selectable()
{if(this._hidden)
return false;return this._selectable;}
set selectable(x)
{this._selectable=x;}
get listItemElement()
{return this._listItemNode;}
get title()
{return this._title;}
set title(x)
{this._title=x;this._setListItemNodeContent();this.didChange();}
get titleHTML()
{return this._titleHTML;}
set titleHTML(x)
{this._titleHTML=x;this._setListItemNodeContent();this.didChange();}
get tooltip()
{return this._tooltip;}
set tooltip(x)
{this._tooltip=x;if(this._listItemNode)
this._listItemNode.title=x?x:"";}
get hasChildren()
{return this._hasChildren;}
set hasChildren(x)
{if(this._hasChildren===x)
return;this._hasChildren=x;if(!this._listItemNode)
return;if(x)
this._listItemNode.classList.add("parent");else{this._listItemNode.classList.remove("parent");this.collapse();}
this.didChange();}
get hidden()
{return this._hidden;}
set hidden(x)
{if(this._hidden===x)
return;this._hidden=x;if(this._listItemNode)
this._listItemNode.hidden=this._hidden;if(this._childrenListNode)
this._childrenListNode.hidden=this._hidden;if(this.treeOutline)
this.treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementVisibilityDidChange,{element:this});}
get shouldRefreshChildren()
{return this._shouldRefreshChildren;}
set shouldRefreshChildren(x)
{this._shouldRefreshChildren=x;if(x&&this.expanded)
this.expand();}
_fireDidChange()
{if(this.treeOutline)
this.treeOutline._treeElementDidChange(this);}
didChange()
{if(!this.treeOutline)
return;this.onNextFrame._fireDidChange();}
_setListItemNodeContent()
{if(!this._listItemNode)
return;if(!this._titleHTML&&!this._title)
this._listItemNode.removeChildren();else if(typeof this._titleHTML==="string")
this._listItemNode.innerHTML=this._titleHTML;else if(typeof this._title==="string")
this._listItemNode.textContent=this._title;else{this._listItemNode.removeChildren();if(this._title.parentNode)
this._title.parentNode.removeChild(this._title);this._listItemNode.appendChild(this._title);}}
_attach()
{if(!this._listItemNode||this.parent._shouldRefreshChildren){if(this._listItemNode&&this._listItemNode.parentNode)
this._listItemNode.parentNode.removeChild(this._listItemNode);this._listItemNode=this.treeOutline._childrenListNode.ownerDocument.createElement("li");this._listItemNode.treeElement=this;this._setListItemNodeContent();this._listItemNode.title=this._tooltip?this._tooltip:"";this._listItemNode.hidden=this.hidden;if(this.hasChildren)
this._listItemNode.classList.add("parent");if(this.expanded)
this._listItemNode.classList.add("expanded");if(this.selected)
this._listItemNode.classList.add("selected");this._listItemNode.addEventListener("mousedown",WebInspector.TreeElement.treeElementMouseDown);this._listItemNode.addEventListener("click",WebInspector.TreeElement.treeElementToggled);this._listItemNode.addEventListener("dblclick",WebInspector.TreeElement.treeElementDoubleClicked);if(this.onattach)
this.onattach(this);}
var nextSibling=null;if(this.nextSibling&&this.nextSibling._listItemNode&&this.nextSibling._listItemNode.parentNode===this.parent._childrenListNode)
nextSibling=this.nextSibling._listItemNode;this.parent._childrenListNode.insertBefore(this._listItemNode,nextSibling);if(this._childrenListNode)
this.parent._childrenListNode.insertBefore(this._childrenListNode,this._listItemNode.nextSibling);if(this.selected)
this.select();if(this.expanded)
this.expand();}
_detach()
{if(this.ondetach)
this.ondetach(this);if(this._listItemNode&&this._listItemNode.parentNode)
this._listItemNode.parentNode.removeChild(this._listItemNode);if(this._childrenListNode&&this._childrenListNode.parentNode)
this._childrenListNode.parentNode.removeChild(this._childrenListNode);}
static treeElementMouseDown(event)
{var element=event.currentTarget;if(!element||!element.treeElement||!element.treeElement.selectable)
return;if(element.treeElement.isEventWithinDisclosureTriangle(event)){event.preventDefault();return;}
element.treeElement.selectOnMouseDown(event);}
static treeElementToggled(event)
{var element=event.currentTarget;if(!element||!element.treeElement)
return;var toggleOnClick=element.treeElement.toggleOnClick&&!element.treeElement.selectable;var isInTriangle=element.treeElement.isEventWithinDisclosureTriangle(event);if(!toggleOnClick&&!isInTriangle)
return;if(element.treeElement.expanded){if(event.altKey)
element.treeElement.collapseRecursively();else
element.treeElement.collapse();}else{if(event.altKey)
element.treeElement.expandRecursively();else
element.treeElement.expand();}
event.stopPropagation();}
static treeElementDoubleClicked(event)
{var element=event.currentTarget;if(!element||!element.treeElement)
return;if(element.treeElement.isEventWithinDisclosureTriangle(event))
return;if(element.treeElement.dispatchEventToListeners(WebInspector.TreeElement.Event.DoubleClick))
return;if(element.treeElement.ondblclick)
element.treeElement.ondblclick.call(element.treeElement,event);else if(element.treeElement.hasChildren&&!element.treeElement.expanded)
element.treeElement.expand();}
collapse()
{if(this._listItemNode)
this._listItemNode.classList.remove("expanded");if(this._childrenListNode)
this._childrenListNode.classList.remove("expanded");this.expanded=false;if(this.treeOutline)
this.treeOutline._treeElementsExpandedState[this.identifier]=false;if(this.oncollapse)
this.oncollapse(this);if(this.treeOutline)
this.treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementDisclosureDidChanged,{element:this});}
collapseRecursively()
{var item=this;while(item){if(item.expanded)
item.collapse();item=item.traverseNextTreeElement(false,this,true);}}
expand()
{if(this.expanded&&!this._shouldRefreshChildren&&this._childrenListNode)
return;
this.expanded=true;if(this.treeOutline)
this.treeOutline._treeElementsExpandedState[this.identifier]=true;if(!this.hasChildren)
return;if(this.treeOutline&&(!this._childrenListNode||this._shouldRefreshChildren)){if(this._childrenListNode&&this._childrenListNode.parentNode)
this._childrenListNode.parentNode.removeChild(this._childrenListNode);this._childrenListNode=this.treeOutline._childrenListNode.ownerDocument.createElement("ol");this._childrenListNode.parentTreeElement=this;this._childrenListNode.classList.add("children");this._childrenListNode.hidden=this.hidden;this.onpopulate();
this.expanded=true;for(var i=0;i<this.children.length;++i)
this.children[i]._attach();this._shouldRefreshChildren=false;}
if(this._listItemNode){this._listItemNode.classList.add("expanded");if(this._childrenListNode&&this._childrenListNode.parentNode!==this._listItemNode.parentNode)
this.parent._childrenListNode.insertBefore(this._childrenListNode,this._listItemNode.nextSibling);}
if(this._childrenListNode)
this._childrenListNode.classList.add("expanded");if(this.onexpand)
this.onexpand(this);if(this.treeOutline)
this.treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementDisclosureDidChanged,{element:this});}
expandRecursively(maxDepth)
{var item=this;var info={};var depth=0;
if(maxDepth===undefined)
maxDepth=3;while(item){if(depth<maxDepth)
item.expand();item=item.traverseNextTreeElement(false,this,(depth>=maxDepth),info);depth+=info.depthChange;}}
hasAncestor(ancestor)
{if(!ancestor)
return false;var currentNode=this.parent;while(currentNode){if(ancestor===currentNode)
return true;currentNode=currentNode.parent;}
return false;}
reveal()
{var currentAncestor=this.parent;while(currentAncestor&&!currentAncestor.root){if(!currentAncestor.expanded)
currentAncestor.expand();currentAncestor=currentAncestor.parent;}
if(this.onreveal)
this.onreveal(this);}
revealed(ignoreHidden)
{if(!ignoreHidden&&this.hidden)
return false;var currentAncestor=this.parent;while(currentAncestor&&!currentAncestor.root){if(!currentAncestor.expanded)
return false;if(!ignoreHidden&&currentAncestor.hidden)
return false;currentAncestor=currentAncestor.parent;}
return true;}
selectOnMouseDown(event)
{this.select(false,true);}
select(omitFocus,selectedByUser,suppressOnSelect,suppressOnDeselect)
{if(!this.treeOutline||!this.selectable)
return;if(this.selected&&!this.treeOutline.allowsRepeatSelection)
return;if(!omitFocus)
this.treeOutline._childrenListNode.focus();let treeOutline=this.treeOutline;if(!treeOutline)
return;treeOutline.processingSelectionChange=true;

if(!suppressOnSelect)
suppressOnDeselect=true;let deselectedElement=treeOutline.selectedTreeElement;if(!this.selected){if(treeOutline.selectedTreeElement)
treeOutline.selectedTreeElement.deselect(suppressOnDeselect);this.selected=true;treeOutline.selectedTreeElement=this;if(this._listItemNode)
this._listItemNode.classList.add("selected");}
if(!suppressOnSelect){if(this.onselect)
this.onselect(this,selectedByUser);treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.SelectionDidChange,{selectedElement:this,deselectedElement,selectedByUser});}
treeOutline.processingSelectionChange=false;let treeOutlineGroup=WebInspector.TreeOutlineGroup.groupForTreeOutline(treeOutline);if(!treeOutlineGroup)
return;treeOutlineGroup.didSelectTreeElement(this);}
revealAndSelect(omitFocus,selectedByUser,suppressOnSelect,suppressOnDeselect)
{this.reveal();this.select(omitFocus,selectedByUser,suppressOnSelect,suppressOnDeselect);}
deselect(suppressOnDeselect)
{if(!this.treeOutline||this.treeOutline.selectedTreeElement!==this||!this.selected)
return false;this.selected=false;this.treeOutline.selectedTreeElement=null;if(this._listItemNode)
this._listItemNode.classList.remove("selected");if(!suppressOnDeselect){if(this.ondeselect)
this.ondeselect(this);this.treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.SelectionDidChange,{deselectedElement:this});}
return true;}
onpopulate()
{}
traverseNextTreeElement(skipUnrevealed,stayWithin,dontPopulate,info)
{function shouldSkip(element){return skipUnrevealed&&!element.revealed(true);}
var depthChange=0;var element=this;if(!dontPopulate)
element.onpopulate();do{if(element.hasChildren&&element.children[0]&&(!skipUnrevealed||element.expanded)){element=element.children[0];depthChange+=1;}else{while(element&&!element.nextSibling&&element.parent&&!element.parent.root&&element.parent!==stayWithin){element=element.parent;depthChange-=1;}
if(element)
element=element.nextSibling;}}while(element&&shouldSkip(element));if(info)
info.depthChange=depthChange;return element;}
traversePreviousTreeElement(skipUnrevealed,dontPopulate)
{function shouldSkip(element){return skipUnrevealed&&!element.revealed(true);}
var element=this;do{if(element.previousSibling){element=element.previousSibling;while(element&&element.hasChildren&&element.expanded&&!shouldSkip(element)){if(!dontPopulate)
element.onpopulate();element=element.children.lastValue;}}else
element=element.parent&&element.parent.root?null:element.parent;}while(element&&shouldSkip(element));return element;}
isEventWithinDisclosureTriangle(event)
{if(!document.contains(this._listItemNode))
return false;let computedStyle=window.getComputedStyle(this._listItemNode);let start=0;if(WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL)
start+=this._listItemNode.totalOffsetRight-computedStyle.getPropertyCSSValue("padding-right").getFloatValue(CSSPrimitiveValue.CSS_PX)-this.arrowToggleWidth;else
start+=this._listItemNode.totalOffsetLeft+computedStyle.getPropertyCSSValue("padding-left").getFloatValue(CSSPrimitiveValue.CSS_PX);return event.pageX>=start&&event.pageX<=start+this.arrowToggleWidth&&this.hasChildren;}
populateContextMenu(contextMenu,event)
{if(this.children.some((child)=>child.hasChildren)||(this.hasChildren&&!this.children.length)){contextMenu.appendSeparator();contextMenu.appendItem(WebInspector.UIString("Expand All"),this.expandRecursively.bind(this));contextMenu.appendItem(WebInspector.UIString("Collapse All"),this.collapseRecursively.bind(this));}}};WebInspector.TreeElement.Event={DoubleClick:"tree-element-double-click",};WebInspector.TreeOutline=class TreeOutline extends WebInspector.Object
{constructor(element)
{super();this.element=element||document.createElement("ol");this.element.classList.add(WebInspector.TreeOutline.ElementStyleClassName);this.element.addEventListener("contextmenu",this._handleContextmenu.bind(this));this.children=[];this.selectedTreeElement=null;this._childrenListNode=this.element;this._childrenListNode.removeChildren();this._knownTreeElements=[];this._treeElementsExpandedState=[];this.allowsRepeatSelection=false;this.root=true;this.hasChildren=false;this.expanded=true;this.selected=false;this.treeOutline=this;this._hidden=false;this._compact=false;this._large=false;this._disclosureButtons=true;this._customIndent=false;this._childrenListNode.tabIndex=0;this._childrenListNode.addEventListener("keydown",this._treeKeyDown.bind(this),true);WebInspector.TreeOutline._generateStyleRulesIfNeeded();} 
get hidden()
{return this._hidden;}
set hidden(x)
{if(this._hidden===x)
return;this._hidden=x;this.element.hidden=this._hidden;}
get compact()
{return this._compact;}
set compact(x)
{if(this._compact===x)
return;this._compact=x;if(this._compact)
this.large=false;this.element.classList.toggle("compact",this._compact);}
get large()
{return this._large;}
set large(x)
{if(this._large===x)
return;this._large=x;if(this._large)
this.compact=false;this.element.classList.toggle("large",this._large);}
get disclosureButtons()
{return this._disclosureButtons;}
set disclosureButtons(x)
{if(this._disclosureButtons===x)
return;this._disclosureButtons=x;this.element.classList.toggle("hide-disclosure-buttons",!this._disclosureButtons);}
get customIndent()
{return this._customIndent;}
set customIndent(x)
{if(this._customIndent===x)
return;this._customIndent=x;this.element.classList.toggle(WebInspector.TreeOutline.CustomIndentStyleClassName,this._customIndent);}
appendChild(child)
{if(!child)
return;var lastChild=this.children[this.children.length-1];if(lastChild){lastChild.nextSibling=child;child.previousSibling=lastChild;}else{child.previousSibling=null;child.nextSibling=null;}
var isFirstChild=!this.children.length;this.children.push(child);this.hasChildren=true;child.parent=this;child.treeOutline=this.treeOutline;child.treeOutline._rememberTreeElement(child);var current=child.children[0];while(current){current.treeOutline=this.treeOutline;current.treeOutline._rememberTreeElement(current);current=current.traverseNextTreeElement(false,child,true);}
if(child.hasChildren&&child.treeOutline._treeElementsExpandedState[child.identifier]!==undefined)
child.expanded=child.treeOutline._treeElementsExpandedState[child.identifier];if(this._childrenListNode)
child._attach();if(this.treeOutline)
this.treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementAdded,{element:child});if(isFirstChild&&this.expanded)
this.expand();}
insertChild(child,index)
{if(!child)
return;var previousChild=(index>0?this.children[index-1]:null);if(previousChild){previousChild.nextSibling=child;child.previousSibling=previousChild;}else{child.previousSibling=null;}
var nextChild=this.children[index];if(nextChild){nextChild.previousSibling=child;child.nextSibling=nextChild;}else{child.nextSibling=null;}
var isFirstChild=!this.children.length;this.children.splice(index,0,child);this.hasChildren=true;child.parent=this;child.treeOutline=this.treeOutline;child.treeOutline._rememberTreeElement(child);var current=child.children[0];while(current){current.treeOutline=this.treeOutline;current.treeOutline._rememberTreeElement(current);current=current.traverseNextTreeElement(false,child,true);}
if(child.hasChildren&&child.treeOutline._treeElementsExpandedState[child.identifier]!==undefined)
child.expanded=child.treeOutline._treeElementsExpandedState[child.identifier];if(this._childrenListNode)
child._attach();if(this.treeOutline)
this.treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementAdded,{element:child});if(isFirstChild&&this.expanded)
this.expand();}
removeChildAtIndex(childIndex,suppressOnDeselect,suppressSelectSibling)
{if(childIndex<0||childIndex>=this.children.length)
return;let child=this.children[childIndex];this.children.splice(childIndex,1);let parent=child.parent;if(child.deselect(suppressOnDeselect)){if(child.previousSibling&&!suppressSelectSibling)
child.previousSibling.select(true,false);else if(child.nextSibling&&!suppressSelectSibling)
child.nextSibling.select(true,false);else if(!suppressSelectSibling)
parent.select(true,false);}
if(child.previousSibling)
child.previousSibling.nextSibling=child.nextSibling;if(child.nextSibling)
child.nextSibling.previousSibling=child.previousSibling;let treeOutline=child.treeOutline;if(treeOutline){treeOutline._forgetTreeElement(child);treeOutline._forgetChildrenRecursive(child);}
child._detach();child.treeOutline=null;child.parent=null;child.nextSibling=null;child.previousSibling=null;if(treeOutline)
treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementRemoved,{element:child});}
removeChild(child,suppressOnDeselect,suppressSelectSibling)
{if(!child)
return;var childIndex=this.children.indexOf(child);if(childIndex===-1)
return;this.removeChildAtIndex(childIndex,suppressOnDeselect,suppressSelectSibling);if(!this.children.length){if(this._listItemNode)
this._listItemNode.classList.remove("parent");this.hasChildren=false;}}
removeChildren(suppressOnDeselect)
{for(let child of this.children){child.deselect(suppressOnDeselect);let treeOutline=child.treeOutline;if(treeOutline){treeOutline._forgetTreeElement(child);treeOutline._forgetChildrenRecursive(child);}
child._detach();child.treeOutline=null;child.parent=null;child.nextSibling=null;child.previousSibling=null;if(treeOutline)
treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementRemoved,{element:child});}
this.children=[];}
removeChildrenRecursive(suppressOnDeselect)
{let childrenToRemove=this.children;let child=this.children[0];while(child){if(child.children.length)
childrenToRemove=childrenToRemove.concat(child.children);child=child.traverseNextTreeElement(false,this,true);}
for(let child of childrenToRemove){child.deselect(suppressOnDeselect);let treeOutline=child.treeOutline;if(treeOutline)
treeOutline._forgetTreeElement(child);child._detach();child.children=[];child.treeOutline=null;child.parent=null;child.nextSibling=null;child.previousSibling=null;if(treeOutline)
treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementRemoved,{element:child});}
this.children=[];}
reattachIfIndexChanged(treeElement,insertionIndex)
{if(this.children[insertionIndex]===treeElement)
return;let wasSelected=treeElement.selected;if(treeElement.parent===this)
this.removeChild(treeElement);this.insertChild(treeElement,insertionIndex);if(wasSelected)
treeElement.select();}
_rememberTreeElement(element)
{if(!this._knownTreeElements[element.identifier])
this._knownTreeElements[element.identifier]=[]; var elements=this._knownTreeElements[element.identifier];if(elements.indexOf(element)!==-1)
return; elements.push(element);}
_forgetTreeElement(element)
{if(this.selectedTreeElement===element){element.deselect(true);this.selectedTreeElement=null;}
if(this._knownTreeElements[element.identifier])
this._knownTreeElements[element.identifier].remove(element,true);}
_forgetChildrenRecursive(parentElement)
{var child=parentElement.children[0];while(child){this._forgetTreeElement(child);child=child.traverseNextTreeElement(false,parentElement,true);}}
getCachedTreeElement(representedObject)
{if(!representedObject)
return null;if(representedObject.__treeElementIdentifier){
var elements=this._knownTreeElements[representedObject.__treeElementIdentifier];if(elements){for(var i=0;i<elements.length;++i)
if(elements[i].representedObject===representedObject)
return elements[i];}}
return null;}
selfOrDescendant(predicate)
{let treeElements=[this];while(treeElements.length){let treeElement=treeElements.shift();if(predicate(treeElement))
return treeElement;treeElements=treeElements.concat(treeElement.children);}
return false;}
findTreeElement(representedObject,isAncestor,getParent)
{if(!representedObject)
return null;var cachedElement=this.getCachedTreeElement(representedObject);if(cachedElement)
return cachedElement;
var item;var found=false;for(var i=0;i<this.children.length;++i){item=this.children[i];if(item.representedObject===representedObject||(isAncestor&&isAncestor(item.representedObject,representedObject))){found=true;break;}}
if(!found)
return null;var ancestors=[];var currentObject=representedObject;while(currentObject){ancestors.unshift(currentObject);if(currentObject===item.representedObject)
break;currentObject=getParent(currentObject);}
for(var i=0;i<ancestors.length;++i){
if(ancestors[i]===representedObject)
continue;
item=this.findTreeElement(ancestors[i],isAncestor,getParent);if(item)
item.onpopulate();}
return this.getCachedTreeElement(representedObject);}
_treeElementDidChange(treeElement)
{if(treeElement.treeOutline!==this)
return;this.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementDidChange,{element:treeElement});}
treeElementFromNode(node)
{var listNode=node.enclosingNodeOrSelfWithNodeNameInArray(["ol","li"]);if(listNode)
return listNode.parentTreeElement||listNode.treeElement;return null;}
treeElementFromPoint(x,y)
{var node=this._childrenListNode.ownerDocument.elementFromPoint(x,y);if(!node)
return null;return this.treeElementFromNode(node);}
_treeKeyDown(event)
{if(event.target!==this._childrenListNode)
return;if(!this.selectedTreeElement||event.shiftKey||event.metaKey||event.ctrlKey)
return;let isRTL=WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL;var handled=false;var nextSelectedElement;if(event.keyIdentifier==="Up"&&!event.altKey){nextSelectedElement=this.selectedTreeElement.traversePreviousTreeElement(true);while(nextSelectedElement&&!nextSelectedElement.selectable)
nextSelectedElement=nextSelectedElement.traversePreviousTreeElement(true);handled=nextSelectedElement?true:false;}else if(event.keyIdentifier==="Down"&&!event.altKey){nextSelectedElement=this.selectedTreeElement.traverseNextTreeElement(true);while(nextSelectedElement&&!nextSelectedElement.selectable)
nextSelectedElement=nextSelectedElement.traverseNextTreeElement(true);handled=nextSelectedElement?true:false;}else if((!isRTL&&event.keyIdentifier==="Left")||(isRTL&&event.keyIdentifier==="Right")){if(this.selectedTreeElement.expanded){if(event.altKey)
this.selectedTreeElement.collapseRecursively();else
this.selectedTreeElement.collapse();handled=true;}else if(this.selectedTreeElement.parent&&!this.selectedTreeElement.parent.root){handled=true;if(this.selectedTreeElement.parent.selectable){nextSelectedElement=this.selectedTreeElement.parent;while(nextSelectedElement&&!nextSelectedElement.selectable)
nextSelectedElement=nextSelectedElement.parent;handled=nextSelectedElement?true:false;}else if(this.selectedTreeElement.parent)
this.selectedTreeElement.parent.collapse();}}else if((!isRTL&&event.keyIdentifier==="Right")||(isRTL&&event.keyIdentifier==="Left")){if(!this.selectedTreeElement.revealed()){this.selectedTreeElement.reveal();handled=true;}else if(this.selectedTreeElement.hasChildren){handled=true;if(this.selectedTreeElement.expanded){nextSelectedElement=this.selectedTreeElement.children[0];while(nextSelectedElement&&!nextSelectedElement.selectable)
nextSelectedElement=nextSelectedElement.nextSibling;handled=nextSelectedElement?true:false;}else{if(event.altKey)
this.selectedTreeElement.expandRecursively();else
this.selectedTreeElement.expand();}}}else if(event.keyCode===8||event.keyCode===46){if(this.selectedTreeElement.ondelete)
handled=this.selectedTreeElement.ondelete();if(!handled&&this.treeOutline.ondelete)
handled=this.treeOutline.ondelete(this.selectedTreeElement);}else if(isEnterKey(event)){if(this.selectedTreeElement.onenter)
handled=this.selectedTreeElement.onenter();if(!handled&&this.treeOutline.onenter)
handled=this.treeOutline.onenter(this.selectedTreeElement);}else if(event.keyIdentifier==="U+0020"){if(this.selectedTreeElement.onspace)
handled=this.selectedTreeElement.onspace();if(!handled&&this.treeOutline.onspace)
handled=this.treeOutline.onspace(this.selectedTreeElement);}
if(nextSelectedElement){nextSelectedElement.reveal();nextSelectedElement.select(false,true);}
if(handled){event.preventDefault();event.stopPropagation();}}
expand()
{}
collapse()
{}
revealed()
{return true;}
reveal()
{}
select()
{}
revealAndSelect(omitFocus)
{}
get selectedTreeElementIndex()
{if(!this.hasChildren||!this.selectedTreeElement)
return;for(var i=0;i<this.children.length;++i){if(this.children[i]===this.selectedTreeElement)
return i;}
return false;} 
treeElementFromEvent(event)
{let scrollContainer=this.element.parentElement;

let x=scrollContainer.totalOffsetLeft+scrollContainer.offsetWidth-36;let y=event.pageY;

let elementUnderMouse=this.treeElementFromPoint(x,y);let elementAboveMouse=this.treeElementFromPoint(x,y-2);let element=null;if(elementUnderMouse===elementAboveMouse)
element=elementUnderMouse;else
element=this.treeElementFromPoint(x,y+2);return element;}
populateContextMenu(contextMenu,event,treeElement)
{treeElement.populateContextMenu(contextMenu,event);} 
static _generateStyleRulesIfNeeded()
{if(WebInspector.TreeOutline._styleElement)
return;WebInspector.TreeOutline._styleElement=document.createElement("style");let maximumTreeDepth=32;let baseLeftPadding=5;let depthPadding=10;let styleText="";let childrenSubstring="";for(let i=1;i<=maximumTreeDepth;++i){childrenSubstring+=i===maximumTreeDepth?" .children":" > .children";styleText+=`.${WebInspector.TreeOutline.ElementStyleClassName}:not(.${WebInspector.TreeOutline.CustomIndentStyleClassName})${childrenSubstring} > .item { `;if(WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL)
styleText+="padding-right: ";else
styleText+="padding-left: ";styleText+=(baseLeftPadding+(depthPadding*i))+"px; }\n";}
WebInspector.TreeOutline._styleElement.textContent=styleText;document.head.appendChild(WebInspector.TreeOutline._styleElement);}
_handleContextmenu(event)
{let treeElement=this.treeElementFromEvent(event);if(!treeElement)
return;let contextMenu=WebInspector.ContextMenu.createFromEvent(event);this.populateContextMenu(contextMenu,event,treeElement);}};WebInspector.TreeOutline._styleElement=null;WebInspector.TreeOutline.ElementStyleClassName="tree-outline";WebInspector.TreeOutline.CustomIndentStyleClassName="custom-indent";WebInspector.TreeOutline.Event={ElementAdded:Symbol("element-added"),ElementDidChange:Symbol("element-did-change"),ElementRemoved:Symbol("element-removed"),ElementDisclosureDidChanged:Symbol("element-disclosure-did-change"),ElementVisibilityDidChange:Symbol("element-visbility-did-change"),SelectionDidChange:Symbol("selection-did-change")};WebInspector.TreeOutline._knownTreeElementNextIdentifier=1;WebInspector.TreeOutlineGroup=class TreeOutlineGroup extends WebInspector.Collection
{constructor()
{super((object)=>object instanceof WebInspector.TreeOutline);} 
static groupForTreeOutline(treeOutline)
{return treeOutline[WebInspector.TreeOutlineGroup.GroupForTreeOutlineSymbol]||null;} 
get selectedTreeElement()
{for(let treeOutline of this.items){if(treeOutline.selectedTreeElement)
return treeOutline.selectedTreeElement;}
return null;} 
itemAdded(treeOutline)
{treeOutline[WebInspector.TreeOutlineGroup.GroupForTreeOutlineSymbol]=this;if(treeOutline.selectedTreeElement)
this._removeConflictingTreeSelections(treeOutline.selectedTreeElement);}
itemRemoved(treeOutline)
{treeOutline[WebInspector.TreeOutlineGroup.GroupForTreeOutlineSymbol]=null;}
didSelectTreeElement(treeElement)
{if(!treeElement)
return;this._removeConflictingTreeSelections(treeElement);} 
_removeConflictingTreeSelections(treeElement)
{let selectedTreeOutline=treeElement.treeOutline;for(let treeOutline of this.items){if(selectedTreeOutline===treeOutline)
continue;if(treeOutline.selectedTreeElement)
treeOutline.selectedTreeElement.deselect();}}};WebInspector.TreeOutlineGroup.GroupForTreeOutlineSymbol=Symbol("group-for-tree-outline");WebInspector.ButtonNavigationItem=class ButtonNavigationItem extends WebInspector.NavigationItem
{constructor(identifier,toolTipOrLabel,image,imageWidth,imageHeight,role,label)
{super(identifier);this.toolTip=toolTipOrLabel;this._element.addEventListener("click",this._mouseClicked.bind(this));this._element.setAttribute("role",role||"button");if(label)
this._element.setAttribute("aria-label",label);this._imageWidth=imageWidth||16;this._imageHeight=imageHeight||16;if(image)
this.image=image;else
this.label=toolTipOrLabel;} 
get toolTip()
{return this._element.title;}
set toolTip(newToolTip)
{if(!newToolTip)
return;this._element.title=newToolTip;}
get label()
{return this._element.textContent;}
set label(newLabel)
{this._element.classList.add(WebInspector.ButtonNavigationItem.TextOnlyClassName);this._element.textContent=newLabel||"";if(this.parentNavigationBar)
this.parentNavigationBar.needsLayout();}
get image()
{return this._image;}
set image(newImage)
{if(!newImage){this._element.removeChildren();return;}
this._element.removeChildren();this._element.classList.remove(WebInspector.ButtonNavigationItem.TextOnlyClassName);this._image=newImage;this._glyphElement=useSVGSymbol(this._image,"glyph");this._glyphElement.style.width=this._imageWidth+"px";this._glyphElement.style.height=this._imageHeight+"px";this._element.appendChild(this._glyphElement);}
get enabled()
{return!this._element.classList.contains(WebInspector.ButtonNavigationItem.DisabledStyleClassName);}
set enabled(flag)
{if(flag)
this._element.classList.remove(WebInspector.ButtonNavigationItem.DisabledStyleClassName);else
this._element.classList.add(WebInspector.ButtonNavigationItem.DisabledStyleClassName);} 
get additionalClassNames()
{return["button"];} 
_mouseClicked(event)
{if(!this.enabled)
return;this.dispatchEventToListeners(WebInspector.ButtonNavigationItem.Event.Clicked);}};WebInspector.ButtonNavigationItem.DisabledStyleClassName="disabled";WebInspector.ButtonNavigationItem.TextOnlyClassName="text-only";WebInspector.ButtonNavigationItem.Event={Clicked:"button-navigation-item-clicked"};WebInspector.DatabaseUserQueryViewBase=class DatabaseUserQueryViewBase extends WebInspector.View
{constructor(query)
{super();this.element.className="database-user-query";let commandTextElement=document.createElement("span");commandTextElement.className="database-query-text";commandTextElement.textContent=query;this.element.appendChild(commandTextElement);this._resultElement=document.createElement("div");this._resultElement.className="database-query-result";this.element.appendChild(this._resultElement);} 
get resultElement()
{return this._resultElement;}};WebInspector.DatabaseUserQueryErrorView=class DatabaseUserQueryErrorView extends WebInspector.DatabaseUserQueryViewBase
{constructor(query,message)
{super(query);this.resultElement.classList.add("error");this.resultElement.textContent=message;}};WebInspector.DatabaseUserQuerySuccessView=class DatabaseUserQuerySuccessView extends WebInspector.DatabaseUserQueryViewBase
{constructor(query,columnNames,values)
{super(query);this._dataGrid=WebInspector.DataGrid.createSortableDataGrid(columnNames,values);if(this._dataGrid){this._dataGrid.inline=true;this.resultElement.appendChild(this._dataGrid.element);this._dataGrid.updateLayoutIfNeeded();}else{this.resultElement.classList.add("no-results");this.resultElement.textContent=WebInspector.UIString("Query returned no results.");}} 
get dataGrid()
{return this._dataGrid;} 
layout()
{if(this._dataGrid)
this._dataGrid.updateLayout();}};WebInspector.DOMTreeContentView=class DOMTreeContentView extends WebInspector.ContentView
{constructor(representedObject)
{super(representedObject);this._compositingBordersButtonNavigationItem=new WebInspector.ActivateButtonNavigationItem("layer-borders",WebInspector.UIString("Show compositing borders"),WebInspector.UIString("Hide compositing borders"),"Images/LayerBorders.svg",13,13);this._compositingBordersButtonNavigationItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,this._toggleCompositingBorders,this);this._compositingBordersButtonNavigationItem.enabled=!!PageAgent.getCompositingBordersVisible;WebInspector.showPaintRectsSetting.addEventListener(WebInspector.Setting.Event.Changed,this._showPaintRectsSettingChanged,this);this._paintFlashingButtonNavigationItem=new WebInspector.ActivateButtonNavigationItem("paint-flashing",WebInspector.UIString("Enable paint flashing"),WebInspector.UIString("Disable paint flashing"),"Images/PaintFlashing.svg",16,16);this._paintFlashingButtonNavigationItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,this._togglePaintFlashing,this);this._paintFlashingButtonNavigationItem.enabled=!!PageAgent.setShowPaintRects;this._paintFlashingButtonNavigationItem.activated=PageAgent.setShowPaintRects&&WebInspector.showPaintRectsSetting.value;WebInspector.showShadowDOMSetting.addEventListener(WebInspector.Setting.Event.Changed,this._showShadowDOMSettingChanged,this);this._showsShadowDOMButtonNavigationItem=new WebInspector.ActivateButtonNavigationItem("shows-shadow-DOM",WebInspector.UIString("Show shadow DOM nodes"),WebInspector.UIString("Hide shadow DOM nodes"),"Images/ShadowDOM.svg",13,13);this._showsShadowDOMButtonNavigationItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,this._toggleShowsShadowDOMSetting,this);this._showShadowDOMSettingChanged();WebInspector.showPrintStylesSetting.addEventListener(WebInspector.Setting.Event.Changed,this._showPrintStylesSettingChanged,this);this._showPrintStylesButtonNavigationItem=new WebInspector.ActivateButtonNavigationItem("print-styles",WebInspector.UIString("Force Print Media Styles"),WebInspector.UIString("Use Default Media Styles"),"Images/Printer.svg",16,16);this._showPrintStylesButtonNavigationItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,this._togglePrintStylesSetting,this);this._showPrintStylesSettingChanged();this.element.classList.add("dom-tree");this.element.addEventListener("click",this._mouseWasClicked.bind(this),false);this._domTreeOutline=new WebInspector.DOMTreeOutline(true,true,true);this._domTreeOutline.addEventListener(WebInspector.TreeOutline.Event.ElementAdded,this._domTreeElementAdded,this);this._domTreeOutline.addEventListener(WebInspector.DOMTreeOutline.Event.SelectedNodeChanged,this._selectedNodeDidChange,this);this._domTreeOutline.wireToDomAgent();this._domTreeOutline.editable=true;this.element.appendChild(this._domTreeOutline.element);WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.AttributeModified,this._domNodeChanged,this);WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.AttributeRemoved,this._domNodeChanged,this);WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.CharacterDataModified,this._domNodeChanged,this);this._lastSelectedNodePathSetting=new WebInspector.Setting("last-selected-node-path",null);this._numberOfSearchResults=null;this._breakpointGutterEnabled=false;this._pendingBreakpointNodeIdentifiers=new Set;if(WebInspector.domDebuggerManager.supported){WebInspector.debuggerManager.addEventListener(WebInspector.DebuggerManager.Event.BreakpointsEnabledDidChange,this._breakpointsEnabledDidChange,this);WebInspector.domDebuggerManager.addEventListener(WebInspector.DOMDebuggerManager.Event.DOMBreakpointAdded,this._domBreakpointAddedOrRemoved,this);WebInspector.domDebuggerManager.addEventListener(WebInspector.DOMDebuggerManager.Event.DOMBreakpointRemoved,this._domBreakpointAddedOrRemoved,this);WebInspector.DOMBreakpoint.addEventListener(WebInspector.DOMBreakpoint.Event.DisabledStateDidChange,this._domBreakpointDisabledStateDidChange,this);WebInspector.DOMBreakpoint.addEventListener(WebInspector.DOMBreakpoint.Event.ResolvedStateDidChange,this._domBreakpointResolvedStateDidChange,this);this._breakpointsEnabledDidChange();}} 
get navigationItems()
{return[this._showPrintStylesButtonNavigationItem,this._showsShadowDOMButtonNavigationItem,this._compositingBordersButtonNavigationItem,this._paintFlashingButtonNavigationItem];}
get domTreeOutline()
{return this._domTreeOutline;}
get scrollableElements()
{return[this.element];}
get breakpointGutterEnabled()
{return this._breakpointGutterEnabled;}
set breakpointGutterEnabled(flag)
{if(this._breakpointGutterEnabled===flag)
return;this._breakpointGutterEnabled=flag;this.element.classList.toggle("show-gutter",this._breakpointGutterEnabled);}
shown()
{super.shown();this._domTreeOutline.setVisible(true,WebInspector.isConsoleFocused());this._updateCompositingBordersButtonToMatchPageSettings();if(!this._domTreeOutline.rootDOMNode)
return;this._restoreBreakpointsAfterUpdate();}
hidden()
{super.hidden();WebInspector.domTreeManager.hideDOMNodeHighlight();this._domTreeOutline.setVisible(false);}
closed()
{super.closed();WebInspector.showPaintRectsSetting.removeEventListener(null,null,this);WebInspector.showShadowDOMSetting.removeEventListener(null,null,this);WebInspector.debuggerManager.removeEventListener(null,null,this);WebInspector.domTreeManager.removeEventListener(null,null,this);WebInspector.domDebuggerManager.removeEventListener(null,null,this);WebInspector.DOMBreakpoint.removeEventListener(null,null,this);this._domTreeOutline.close();this._pendingBreakpointNodeIdentifiers.clear();}
get selectionPathComponents()
{var treeElement=this._domTreeOutline.selectedTreeElement;var pathComponents=[];while(treeElement&&!treeElement.root){
if(treeElement.isCloseTag()){treeElement=treeElement.parent;continue;}
var pathComponent=new WebInspector.DOMTreeElementPathComponent(treeElement,treeElement.representedObject);pathComponent.addEventListener(WebInspector.HierarchicalPathComponent.Event.Clicked,this._pathComponentSelected,this);pathComponents.unshift(pathComponent);treeElement=treeElement.parent;}
return pathComponents;}
restoreFromCookie(cookie)
{if(!cookie||!cookie.nodeToSelect)
return;this.selectAndRevealDOMNode(cookie.nodeToSelect);
cookie.nodeToSelect=undefined;}
selectAndRevealDOMNode(domNode,preventFocusChange)
{this._domTreeOutline.selectDOMNode(domNode,!preventFocusChange);}
handleCopyEvent(event)
{var selectedDOMNode=this._domTreeOutline.selectedDOMNode();if(!selectedDOMNode)
return;event.clipboardData.clearData();event.preventDefault();selectedDOMNode.copyNode();}
get supportsSave()
{return WebInspector.canArchiveMainFrame();}
get saveData()
{function saveHandler(forceSaveAs)
{WebInspector.archiveMainFrame();}
return{customSaveHandler:saveHandler};}
get supportsSearch()
{return true;}
get numberOfSearchResults()
{return this._numberOfSearchResults;}
get hasPerformedSearch()
{return this._numberOfSearchResults!==null;}
set automaticallyRevealFirstSearchResult(reveal)
{this._automaticallyRevealFirstSearchResult=reveal;if(this._automaticallyRevealFirstSearchResult&&this._numberOfSearchResults>0){if(this._currentSearchResultIndex===-1)
this.revealNextSearchResult();}}
performSearch(query)
{if(this._searchQuery===query)
return;if(this._searchIdentifier){DOMAgent.discardSearchResults(this._searchIdentifier);this._hideSearchHighlights();}
this._searchQuery=query;this._searchIdentifier=null;this._numberOfSearchResults=null;this._currentSearchResultIndex=-1;function searchResultsReady(error,searchIdentifier,resultsCount)
{if(error)
return;this._searchIdentifier=searchIdentifier;this._numberOfSearchResults=resultsCount;this.dispatchEventToListeners(WebInspector.ContentView.Event.NumberOfSearchResultsDidChange);this._showSearchHighlights();if(this._automaticallyRevealFirstSearchResult)
this.revealNextSearchResult();}
function contextNodesReady(nodeIds)
{DOMAgent.performSearch(query,nodeIds,searchResultsReady.bind(this));}
this.getSearchContextNodes(contextNodesReady.bind(this));}
getSearchContextNodes(callback)
{callback(undefined);}
searchCleared()
{if(this._searchIdentifier){DOMAgent.discardSearchResults(this._searchIdentifier);this._hideSearchHighlights();}
this._searchQuery=null;this._searchIdentifier=null;this._numberOfSearchResults=null;this._currentSearchResultIndex=-1;}
revealPreviousSearchResult(changeFocus)
{if(!this._numberOfSearchResults)
return;if(this._currentSearchResultIndex>0)
--this._currentSearchResultIndex;else
this._currentSearchResultIndex=this._numberOfSearchResults-1;this._revealSearchResult(this._currentSearchResultIndex,changeFocus);}
revealNextSearchResult(changeFocus)
{if(!this._numberOfSearchResults)
return;if(this._currentSearchResultIndex+1<this._numberOfSearchResults)
++this._currentSearchResultIndex;else
this._currentSearchResultIndex=0;this._revealSearchResult(this._currentSearchResultIndex,changeFocus);} 
layout()
{this._domTreeOutline.updateSelection();} 
_revealSearchResult(index,changeFocus)
{var searchIdentifier=this._searchIdentifier;function revealResult(error,nodeIdentifiers)
{if(error)
return;if(this._searchIdentifier!==searchIdentifier)
return;var domNode=WebInspector.domTreeManager.nodeForId(nodeIdentifiers[0]);if(!domNode)
return;this._domTreeOutline.selectDOMNode(domNode,changeFocus);var selectedTreeElement=this._domTreeOutline.selectedTreeElement;if(selectedTreeElement)
selectedTreeElement.emphasizeSearchHighlight();}
DOMAgent.getSearchResults(this._searchIdentifier,index,index+1,revealResult.bind(this));}
_restoreSelectedNodeAfterUpdate(documentURL,defaultNode)
{if(!WebInspector.domTreeManager.restoreSelectedNodeIsAllowed)
return;function selectNode(lastSelectedNode)
{var nodeToFocus=lastSelectedNode;if(!nodeToFocus)
nodeToFocus=defaultNode;if(!nodeToFocus)
return;this._dontSetLastSelectedNodePath=true;this.selectAndRevealDOMNode(nodeToFocus,WebInspector.isConsoleFocused());this._dontSetLastSelectedNodePath=false;if(!lastSelectedNode&&this._domTreeOutline.selectedTreeElement)
this._domTreeOutline.selectedTreeElement.expand();}
function selectLastSelectedNode(nodeId)
{if(!WebInspector.domTreeManager.restoreSelectedNodeIsAllowed)
return;selectNode.call(this,WebInspector.domTreeManager.nodeForId(nodeId));}
if(documentURL&&this._lastSelectedNodePathSetting.value&&this._lastSelectedNodePathSetting.value.path&&this._lastSelectedNodePathSetting.value.url===documentURL.hash)
WebInspector.domTreeManager.pushNodeByPathToFrontend(this._lastSelectedNodePathSetting.value.path,selectLastSelectedNode.bind(this));else
selectNode.call(this);}
_domTreeElementAdded(event)
{if(!this._pendingBreakpointNodeIdentifiers.size)
return;let treeElement=event.data.element;let node=treeElement.representedObject;if(!(node instanceof WebInspector.DOMNode))
return;if(!this._pendingBreakpointNodeIdentifiers.delete(node.id))
return;this._updateBreakpointStatus(node.id);}
_selectedNodeDidChange(event)
{var selectedDOMNode=this._domTreeOutline.selectedDOMNode();if(selectedDOMNode&&!this._dontSetLastSelectedNodePath)
this._lastSelectedNodePathSetting.value={url:WebInspector.frameResourceManager.mainFrame.url.hash,path:selectedDOMNode.path()};if(selectedDOMNode)
ConsoleAgent.addInspectedNode(selectedDOMNode.id);this.dispatchEventToListeners(WebInspector.ContentView.Event.SelectionPathComponentsDidChange);}
_pathComponentSelected(event)
{if(!event.data.pathComponent)
return;this._domTreeOutline.selectDOMNode(event.data.pathComponent.domTreeElement.representedObject,true);}
_domNodeChanged(event)
{var selectedDOMNode=this._domTreeOutline.selectedDOMNode();if(selectedDOMNode!==event.data.node)
return;this.dispatchEventToListeners(WebInspector.ContentView.Event.SelectionPathComponentsDidChange);}
_mouseWasClicked(event)
{var anchorElement=event.target.enclosingNodeOrSelfWithNodeName("a");if(!anchorElement||!anchorElement.href)
return;event.preventDefault();event.stopPropagation();if(WebInspector.isBeingEdited(anchorElement)){return;}
if(this._followLinkTimeoutIdentifier){clearTimeout(this._followLinkTimeoutIdentifier);delete this._followLinkTimeoutIdentifier;}
if(event.detail>1)
return;function followLink()
{

const options={alwaysOpenExternally:event?event.metaKey:false,lineNumber:anchorElement.lineNumber,ignoreNetworkTab:true,ignoreSearchTab:true,};WebInspector.openURL(anchorElement.href,this._frame,options);}
this._followLinkTimeoutIdentifier=setTimeout(followLink.bind(this),333);}
_toggleCompositingBorders(event)
{var activated=!this._compositingBordersButtonNavigationItem.activated;this._compositingBordersButtonNavigationItem.activated=activated;PageAgent.setCompositingBordersVisible(activated);}
_togglePaintFlashing(event)
{WebInspector.showPaintRectsSetting.value=!WebInspector.showPaintRectsSetting.value;}
_updateCompositingBordersButtonToMatchPageSettings()
{var button=this._compositingBordersButtonNavigationItem;
PageAgent.getCompositingBordersVisible(function(error,compositingBordersVisible){button.activated=error?false:compositingBordersVisible;button.enabled=error!=="unsupported";});}
_showPaintRectsSettingChanged(event)
{this._paintFlashingButtonNavigationItem.activated=WebInspector.showPaintRectsSetting.value;PageAgent.setShowPaintRects(this._paintFlashingButtonNavigationItem.activated);}
_showShadowDOMSettingChanged(event)
{this._showsShadowDOMButtonNavigationItem.activated=WebInspector.showShadowDOMSetting.value;}
_toggleShowsShadowDOMSetting(event)
{WebInspector.showShadowDOMSetting.value=!WebInspector.showShadowDOMSetting.value;}
_showPrintStylesSettingChanged(event)
{this._showPrintStylesButtonNavigationItem.activated=WebInspector.showPrintStylesSetting.value;}
_togglePrintStylesSetting(event)
{WebInspector.showPrintStylesSetting.value=!WebInspector.showPrintStylesSetting.value;let mediaType=WebInspector.showPrintStylesSetting.value?"print":"";PageAgent.setEmulatedMedia(mediaType);WebInspector.cssStyleManager.mediaTypeChanged();}
_showSearchHighlights()
{this._searchResultNodes=[];var searchIdentifier=this._searchIdentifier;DOMAgent.getSearchResults(this._searchIdentifier,0,this._numberOfSearchResults,function(error,nodeIdentifiers){if(error)
return;if(this._searchIdentifier!==searchIdentifier)
return;for(var i=0;i<nodeIdentifiers.length;++i){var domNode=WebInspector.domTreeManager.nodeForId(nodeIdentifiers[i]);if(!domNode)
continue;this._searchResultNodes.push(domNode);var treeElement=this._domTreeOutline.findTreeElement(domNode);if(treeElement)
treeElement.highlightSearchResults(this._searchQuery);}}.bind(this));}
_hideSearchHighlights()
{if(!this._searchResultNodes)
return;for(var domNode of this._searchResultNodes){var treeElement=this._domTreeOutline.findTreeElement(domNode);if(treeElement)
treeElement.hideSearchHighlights();}
delete this._searchResultNodes;}
_domBreakpointAddedOrRemoved(event)
{let breakpoint=event.data.breakpoint;this._updateBreakpointStatus(breakpoint.domNodeIdentifier);}
_domBreakpointDisabledStateDidChange(event)
{let breakpoint=event.target;this._updateBreakpointStatus(breakpoint.domNodeIdentifier);}
_domBreakpointResolvedStateDidChange(event)
{let breakpoint=event.target;let nodeIdentifier=breakpoint.domNodeIdentifier||event.data.oldNodeIdentifier;this._updateBreakpointStatus(nodeIdentifier);}
_updateBreakpointStatus(nodeIdentifier)
{let domNode=WebInspector.domTreeManager.nodeForId(nodeIdentifier);if(!domNode)
return;let treeElement=this._domTreeOutline.findTreeElement(domNode);if(!treeElement){this._pendingBreakpointNodeIdentifiers.add(nodeIdentifier);return;}
let breakpoints=WebInspector.domDebuggerManager.domBreakpointsForNode(domNode);if(!breakpoints.length){treeElement.breakpointStatus=WebInspector.DOMTreeElement.BreakpointStatus.None;return;}
this.breakpointGutterEnabled=true;let disabled=breakpoints.some((item)=>item.disabled);treeElement.breakpointStatus=disabled?WebInspector.DOMTreeElement.BreakpointStatus.DisabledBreakpoint:WebInspector.DOMTreeElement.BreakpointStatus.Breakpoint;}
_restoreBreakpointsAfterUpdate()
{this._pendingBreakpointNodeIdentifiers.clear();this.breakpointGutterEnabled=false;let updatedNodes=new Set;for(let breakpoint of WebInspector.domDebuggerManager.domBreakpoints){if(updatedNodes.has(breakpoint.domNodeIdentifier))
continue;this._updateBreakpointStatus(breakpoint.domNodeIdentifier);}}
_breakpointsEnabledDidChange(event)
{this._domTreeOutline.element.classList.toggle("breakpoints-disabled",!WebInspector.debuggerManager.breakpointsEnabled);}};WebInspector.DetailsSidebarPanel=class DetailsSidebarPanel extends WebInspector.SidebarPanel
{constructor(identifier,displayName,dontCreateNavigationItem)
{super(identifier,displayName);this.element.classList.add("details");if(!dontCreateNavigationItem)
this._navigationItem=new WebInspector.RadioButtonNavigationItem(identifier,displayName);} 
get navigationItem()
{return this._navigationItem;}
inspect(objects)
{return false;}};WebInspector.GeneralTabBarItem=class GeneralTabBarItem extends WebInspector.TabBarItem
{constructor(image,title,representedObject)
{super(image,title,representedObject);let closeButtonElement=document.createElement("div");closeButtonElement.classList.add(WebInspector.TabBarItem.CloseButtonStyleClassName);closeButtonElement.title=WebInspector.UIString("Click to close this tab; Option-click to close all tabs except this one");this.element.insertBefore(closeButtonElement,this.element.firstChild);this.element.addEventListener("contextmenu",this._handleContextMenuEvent.bind(this));} 
set title(title)
{if(title){this._titleElement=document.createElement("span");this._titleElement.classList.add("title");let titleContentElement=document.createElement("span");titleContentElement.classList.add("content");titleContentElement.textContent=title;this._titleElement.appendChild(titleContentElement);this.element.insertBefore(this._titleElement,this.element.lastChild);}else{if(this._titleElement)
this._titleElement.remove();this._titleElement=null;}
super.title=title;} 
_handleContextMenuEvent(event)
{if(!this._parentTabBar)
return;let closeTab=()=>{this._parentTabBar.removeTabBarItem(this);};let closeOtherTabs=()=>{let tabBarItems=this._parentTabBar.tabBarItems;for(let i=tabBarItems.length-1;i>=0;--i){let item=tabBarItems[i];if(item===this||item instanceof WebInspector.PinnedTabBarItem)
continue;this._parentTabBar.removeTabBarItem(item);}};let hasOtherNonPinnedTabs=this._parentTabBar.tabBarItems.some((item)=>item!==this&&!(item instanceof WebInspector.PinnedTabBarItem));let contextMenu=WebInspector.ContextMenu.createFromEvent(event);contextMenu.appendItem(WebInspector.UIString("Close Tab"),closeTab,this.isDefaultTab);contextMenu.appendItem(WebInspector.UIString("Close Other Tabs"),closeOtherTabs,!hasOtherNonPinnedTabs);}};WebInspector.GeneralTreeElement=class GeneralTreeElement extends WebInspector.TreeElement
{constructor(classNames,title,subtitle,representedObject,hasChildren)
{super("",representedObject,hasChildren);this.classNames=classNames;this._tooltipHandledSeparately=false;this._mainTitle=title||"";this._subtitle=subtitle||"";this._status="";} 
get element()
{return this._listItemNode;}
get iconElement()
{this._createElementsIfNeeded();return this._iconElement;}
get titlesElement()
{this._createElementsIfNeeded();return this._titlesElement;}
get mainTitleElement()
{this._createElementsIfNeeded();return this._mainTitleElement;}
get subtitleElement()
{this._createElementsIfNeeded();this._createSubtitleElementIfNeeded();return this._subtitleElement;}
get classNames()
{return this._classNames;}
set classNames(x)
{x=x||[];if(typeof x==="string")
x=[x];if(Array.shallowEqual(this._classNames,x))
return;if(this._listItemNode&&this._classNames)
this._listItemNode.classList.remove(...this._classNames);this._classNames=x;if(this._listItemNode)
this._listItemNode.classList.add(...this._classNames);}
addClassName(className)
{if(this._classNames.includes(className))
return;this._classNames.push(className);if(this._listItemNode)
this._listItemNode.classList.add(className);}
removeClassName(className)
{if(!this._classNames.includes(className))
return;this._classNames.remove(className);if(this._listItemNode)
this._listItemNode.classList.remove(className);}
get mainTitle()
{return this._mainTitle;}
set mainTitle(x)
{x=x||"";if(this._mainTitle===x)
return;this._mainTitle=x;this._updateTitleElements();this.didChange();this.dispatchEventToListeners(WebInspector.GeneralTreeElement.Event.MainTitleDidChange);}
get subtitle()
{return this._subtitle;}
set subtitle(x)
{x=x||"";if(this._subtitle===x)
return;this._subtitle=x;this._updateTitleElements();this.didChange();}
get status()
{return this._status;}
set status(x)
{x=x||"";if(this._status===x)
return;if(!this._statusElement){this._statusElement=document.createElement("div");this._statusElement.className=WebInspector.GeneralTreeElement.StatusElementStyleClassName;}
this._status=x;this._updateStatusElement();}
get filterableData()
{return{text:[this.mainTitle,this.subtitle]};}
get tooltipHandledSeparately()
{return this._tooltipHandledSeparately;}
set tooltipHandledSeparately(x)
{this._tooltipHandledSeparately=!!x;}
isEventWithinDisclosureTriangle(event)
{return event.target===this._disclosureButton;}
onattach()
{this._createElementsIfNeeded();this._updateTitleElements();this._listItemNode.classList.add("item");if(this._classNames)
this._listItemNode.classList.add(...this._classNames);this._listItemNode.appendChild(this._disclosureButton);this._listItemNode.appendChild(this._iconElement);if(this._statusElement)
this._listItemNode.appendChild(this._statusElement);this._listItemNode.appendChild(this._titlesElement);}
ondetach()
{}
onreveal()
{if(this._listItemNode)
this._listItemNode.scrollIntoViewIfNeeded(false);} 
callFirstAncestorFunction(functionName,args)
{var currentNode=this.parent;while(currentNode){if(typeof currentNode[functionName]==="function"){currentNode[functionName].apply(currentNode,args);break;}
currentNode=currentNode.parent;}} 
_createElementsIfNeeded()
{if(this._createdElements)
return;this._disclosureButton=document.createElement("button");this._disclosureButton.className=WebInspector.GeneralTreeElement.DisclosureButtonStyleClassName;
this._disclosureButton.tabIndex=-1;this._iconElement=document.createElement("img");this._iconElement.className=WebInspector.GeneralTreeElement.IconElementStyleClassName;this._titlesElement=document.createElement("div");this._titlesElement.className=WebInspector.GeneralTreeElement.TitlesElementStyleClassName;this._mainTitleElement=document.createElement("span");this._mainTitleElement.className=WebInspector.GeneralTreeElement.MainTitleElementStyleClassName;this._titlesElement.appendChild(this._mainTitleElement);this._createdElements=true;}
_createSubtitleElementIfNeeded()
{if(this._subtitleElement)
return;this._subtitleElement=document.createElement("span");this._subtitleElement.className=WebInspector.GeneralTreeElement.SubtitleElementStyleClassName;this._titlesElement.appendChild(this._subtitleElement);}
_updateTitleElements()
{if(!this._createdElements)
return;if(typeof this._mainTitle==="string"){if(this._mainTitleElement.textContent!==this._mainTitle)
this._mainTitleElement.textContent=this._mainTitle;}else if(this._mainTitle instanceof Node){this._mainTitleElement.removeChildren();this._mainTitleElement.appendChild(this._mainTitle);}
if(typeof this._subtitle==="string"&&this._subtitle){this._createSubtitleElementIfNeeded();if(this._subtitleElement.textContent!==this._subtitle)
this._subtitleElement.textContent=this._subtitle;this._titlesElement.classList.remove(WebInspector.GeneralTreeElement.NoSubtitleStyleClassName);}else if(this._subtitle instanceof Node){this._createSubtitleElementIfNeeded();this._subtitleElement.removeChildren();this._subtitleElement.appendChild(this._subtitle);}else{if(this._subtitleElement)
this._subtitleElement.textContent="";this._titlesElement.classList.add(WebInspector.GeneralTreeElement.NoSubtitleStyleClassName);}
if(!this.tooltip&&!this._tooltipHandledSeparately)
this._updateTitleTooltip();}
_updateTitleTooltip()
{if(!this._listItemNode)
return;let mainTitleText=this._mainTitleElement.textContent;let subtitleText=this._subtitleElement?this._subtitleElement.textContent:"";let large=this.treeOutline&&this.treeOutline.large;if(mainTitleText&&subtitleText)
this._listItemNode.title=mainTitleText+(large?"\n":" \u2014 ")+subtitleText;else if(mainTitleText)
this._listItemNode.title=mainTitleText;else
this._listItemNode.title=subtitleText;}
_updateStatusElement()
{if(!this._statusElement)
return;if(!this._statusElement.parentNode&&this._listItemNode)
this._listItemNode.insertBefore(this._statusElement,this._titlesElement);if(this._status instanceof Node){this._statusElement.removeChildren();this._statusElement.appendChild(this._status);}else
this._statusElement.textContent=this._status;}};WebInspector.GeneralTreeElement.DisclosureButtonStyleClassName="disclosure-button";WebInspector.GeneralTreeElement.IconElementStyleClassName="icon";WebInspector.GeneralTreeElement.StatusElementStyleClassName="status";WebInspector.GeneralTreeElement.TitlesElementStyleClassName="titles";WebInspector.GeneralTreeElement.MainTitleElementStyleClassName="title";WebInspector.GeneralTreeElement.SubtitleElementStyleClassName="subtitle";WebInspector.GeneralTreeElement.NoSubtitleStyleClassName="no-subtitle";WebInspector.GeneralTreeElement.Event={MainTitleDidChange:"general-tree-element-main-title-did-change"};WebInspector.NavigationSidebarPanel=class NavigationSidebarPanel extends WebInspector.SidebarPanel
{constructor(identifier,displayName,shouldAutoPruneStaleTopLevelResourceTreeElements)
{super(identifier,displayName);this.element.classList.add("navigation");this.contentView.element.addEventListener("scroll",this.soon._updateContentOverflowShadowVisibility);this._contentTreeOutlineGroup=new WebInspector.TreeOutlineGroup;this._contentTreeOutline=this.createContentTreeOutline();this._filterBar=new WebInspector.FilterBar;this._filterBar.addEventListener(WebInspector.FilterBar.Event.FilterDidChange,this._filterDidChange,this);this.element.appendChild(this._filterBar.element);this._bottomOverflowShadowElement=document.createElement("div");this._bottomOverflowShadowElement.className=WebInspector.NavigationSidebarPanel.OverflowShadowElementStyleClassName;this.element.appendChild(this._bottomOverflowShadowElement);this._boundUpdateContentOverflowShadowVisibility=this.soon._updateContentOverflowShadowVisibility;window.addEventListener("resize",this._boundUpdateContentOverflowShadowVisibility);this._filtersSetting=new WebInspector.Setting(identifier+"-navigation-sidebar-filters",{});this._filterBar.filters=this._filtersSetting.value;this._emptyContentPlaceholderElements=new Map;this._emptyFilterResults=new Map;this._shouldAutoPruneStaleTopLevelResourceTreeElements=shouldAutoPruneStaleTopLevelResourceTreeElements||false;if(this._shouldAutoPruneStaleTopLevelResourceTreeElements){WebInspector.Frame.addEventListener(WebInspector.Frame.Event.MainResourceDidChange,this._checkForStaleResources,this);WebInspector.Frame.addEventListener(WebInspector.Frame.Event.ChildFrameWasRemoved,this._checkForStaleResources,this);WebInspector.Frame.addEventListener(WebInspector.Frame.Event.ResourceWasRemoved,this._checkForStaleResources,this);}
this._pendingViewStateCookie=null;this._restoringState=false;} 
closed()
{window.removeEventListener("resize",this._boundUpdateContentOverflowShadowVisibility);WebInspector.Frame.removeEventListener(null,null,this);}
get contentBrowser()
{return this._contentBrowser;}
set contentBrowser(contentBrowser)
{this._contentBrowser=contentBrowser||null;}
get contentTreeOutline()
{return this._contentTreeOutline;}
get contentTreeOutlines()
{return this._contentTreeOutlineGroup.items;}
get currentRepresentedObject()
{if(!this._contentBrowser)
return null;return this._contentBrowser.currentRepresentedObjects[0]||null;}
get filterBar()
{return this._filterBar;}
get restoringState()
{return this._restoringState;}
cancelRestoringState()
{if(!this._finalAttemptToRestoreViewStateTimeout)
return;clearTimeout(this._finalAttemptToRestoreViewStateTimeout);this._finalAttemptToRestoreViewStateTimeout=undefined;}
createContentTreeOutline(suppressFiltering)
{let contentTreeOutline=new WebInspector.TreeOutline;contentTreeOutline.allowsRepeatSelection=true;contentTreeOutline.element.classList.add(WebInspector.NavigationSidebarPanel.ContentTreeOutlineElementStyleClassName);this._contentTreeOutlineGroup.add(contentTreeOutline);this.contentView.element.appendChild(contentTreeOutline.element);if(!suppressFiltering){contentTreeOutline.addEventListener(WebInspector.TreeOutline.Event.ElementAdded,this._treeElementAddedOrChanged,this);contentTreeOutline.addEventListener(WebInspector.TreeOutline.Event.ElementDidChange,this._treeElementAddedOrChanged,this);contentTreeOutline.addEventListener(WebInspector.TreeOutline.Event.ElementDisclosureDidChanged,this._treeElementDisclosureDidChange,this);}
contentTreeOutline[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol]=suppressFiltering;return contentTreeOutline;}
suppressFilteringOnTreeElements(treeElements)
{for(let treeElement of treeElements)
treeElement[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol]=true;this._updateFilter();}
treeElementForRepresentedObject(representedObject)
{let treeElement=null;for(let treeOutline of this.contentTreeOutlines){treeElement=treeOutline.getCachedTreeElement(representedObject);if(treeElement)
break;}
return treeElement;}
showDefaultContentView()
{}
showDefaultContentViewForTreeElement(treeElement)
{if(!treeElement||!treeElement.representedObject)
return false;
if(!this.selected){let contentView=this.contentBrowser.contentViewForRepresentedObject(treeElement.representedObject);if(contentView&&contentView.parentContainer&&contentView.parentContainer!==this.contentBrowser.contentViewContainer)
return false;let selectedTabContentView=WebInspector.tabBrowser.selectedTabContentView;if(selectedTabContentView&&selectedTabContentView.contentBrowser!==this.contentBrowser)
return false;}
let contentView=this.contentBrowser.showContentViewForRepresentedObject(treeElement.representedObject);if(!contentView)
return false;treeElement.revealAndSelect(true,false,true,true);return true;}
saveStateToCookie(cookie)
{if(!this._contentBrowser)
return;let representedObject=this.currentRepresentedObject;if(!representedObject)
return;cookie[WebInspector.TypeIdentifierCookieKey]=representedObject.constructor.TypeIdentifier;if(representedObject.saveIdentityToCookie){representedObject.saveIdentityToCookie(cookie);return;}
console.error("NavigationSidebarPanel representedObject is missing a saveIdentityToCookie implementation.",representedObject);}
restoreStateFromCookie(cookie,relaxedMatchDelay)
{this._pendingViewStateCookie=cookie;this._restoringState=true;this._checkOutlinesForPendingViewStateCookie();if(this._finalAttemptToRestoreViewStateTimeout)
clearTimeout(this._finalAttemptToRestoreViewStateTimeout);if(relaxedMatchDelay===0)
return;function finalAttemptToRestoreViewStateFromCookie()
{this._finalAttemptToRestoreViewStateTimeout=undefined;this._checkOutlinesForPendingViewStateCookie(true);this._pendingViewStateCookie=null;this._restoringState=false;}

this._finalAttemptToRestoreViewStateTimeout=setTimeout(finalAttemptToRestoreViewStateFromCookie.bind(this),relaxedMatchDelay);}
showEmptyContentPlaceholder(message,treeOutline)
{treeOutline=treeOutline||this._contentTreeOutline;let emptyContentPlaceholderElement=this._createEmptyContentPlaceholderIfNeeded(treeOutline);if(emptyContentPlaceholderElement.parentNode&&emptyContentPlaceholderElement.children[0].textContent===message)
return;emptyContentPlaceholderElement.children[0].textContent=message;let emptyContentPlaceholderParentElement=treeOutline.element.parentNode;emptyContentPlaceholderParentElement.appendChild(emptyContentPlaceholderElement);this._updateContentOverflowShadowVisibility();}
hideEmptyContentPlaceholder(treeOutline)
{treeOutline=treeOutline||this._contentTreeOutline;let emptyContentPlaceholderElement=this._emptyContentPlaceholderElements.get(treeOutline);if(!emptyContentPlaceholderElement||!emptyContentPlaceholderElement.parentNode)
return;emptyContentPlaceholderElement.remove();this._updateContentOverflowShadowVisibility();}
updateEmptyContentPlaceholder(message,treeOutline)
{treeOutline=treeOutline||this._contentTreeOutline;if(!treeOutline.children.length){this.showEmptyContentPlaceholder(message,treeOutline);}else if(!this._emptyFilterResults.get(treeOutline)){this.hideEmptyContentPlaceholder(treeOutline);}}
updateFilter()
{this._updateFilter();}
shouldFilterPopulate()
{return this.hasCustomFilters();}
hasCustomFilters()
{return false;}
matchTreeElementAgainstCustomFilters(treeElement)
{return true;}
matchTreeElementAgainstFilterFunctions(treeElement)
{if(!this._filterFunctions||!this._filterFunctions.length)
return true;for(var filterFunction of this._filterFunctions){if(filterFunction(treeElement))
return true;}
return false;}
applyFiltersToTreeElement(treeElement)
{if(!this._filterBar.hasActiveFilters()&&!this.hasCustomFilters()){treeElement.hidden=false;if(treeElement.expanded&&treeElement[WebInspector.NavigationSidebarPanel.WasExpandedDuringFilteringSymbol]){treeElement[WebInspector.NavigationSidebarPanel.WasExpandedDuringFilteringSymbol]=false;treeElement.collapse();}
return;}
var filterableData=treeElement.filterableData||{};var flags={expandTreeElement:false};var filterRegex=this._textFilterRegex;function matchTextFilter(inputs)
{if(!inputs||!filterRegex)
return true;for(var input of inputs){if(!input)
continue;if(filterRegex.test(input)){flags.expandTreeElement=true;return true;}}
return false;}
function makeVisible()
{treeElement.hidden=false;var currentAncestor=treeElement.parent;while(currentAncestor&&!currentAncestor.root){currentAncestor.hidden=false;if(flags.expandTreeElement&&!currentAncestor.expanded){currentAncestor.__wasExpandedDuringFiltering=true;currentAncestor.expand();}
currentAncestor=currentAncestor.parent;}}
let suppressFiltering=treeElement[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol];if(suppressFiltering||(matchTextFilter(filterableData.text)&&this.matchTreeElementAgainstFilterFunctions(treeElement,flags)&&this.matchTreeElementAgainstCustomFilters(treeElement,flags))){makeVisible();if(!flags.expandTreeElement&&treeElement.expanded&&treeElement[WebInspector.NavigationSidebarPanel.WasExpandedDuringFilteringSymbol]){treeElement[WebInspector.NavigationSidebarPanel.WasExpandedDuringFilteringSymbol]=false;treeElement.collapse();}
return;}
treeElement.hidden=true;}
shown()
{super.shown();this._updateContentOverflowShadowVisibility();} 
pruneStaleResourceTreeElements()
{if(this._checkForStaleResourcesTimeoutIdentifier){clearTimeout(this._checkForStaleResourcesTimeoutIdentifier);this._checkForStaleResourcesTimeoutIdentifier=undefined;}
for(let contentTreeOutline of this.contentTreeOutlines){
for(var i=contentTreeOutline.children.length-1;i>=0;--i){var treeElement=contentTreeOutline.children[i];if(!(treeElement instanceof WebInspector.ResourceTreeElement))
continue;var resource=treeElement.resource;if(!resource.parentFrame||resource.parentFrame.isDetached())
contentTreeOutline.removeChildAtIndex(i,true,true);}}}
treeElementAddedOrChanged(treeElement)
{} 
_updateContentOverflowShadowVisibility()
{if(!this.visible)
return;this._updateContentOverflowShadowVisibility.cancelDebounce();let scrollHeight=this.contentView.element.scrollHeight;let offsetHeight=this.contentView.element.offsetHeight;if(scrollHeight<offsetHeight){if(this._topOverflowShadowElement)
this._topOverflowShadowElement.style.opacity=0;this._bottomOverflowShadowElement.style.opacity=0;return;}
let edgeThreshold=1;let scrollTop=this.contentView.element.scrollTop;let topCoverage=Math.min(scrollTop,edgeThreshold);let bottomCoverage=Math.max(0,(offsetHeight+scrollTop)-(scrollHeight-edgeThreshold));if(this._topOverflowShadowElement)
this._topOverflowShadowElement.style.opacity=(topCoverage/edgeThreshold).toFixed(1);this._bottomOverflowShadowElement.style.opacity=(1-(bottomCoverage/edgeThreshold)).toFixed(1);}
_checkForEmptyFilterResults()
{function checkTreeOutlineForEmptyFilterResults(treeOutline)
{if(!treeOutline.children.length)
return;let filterableTreeElementFound=false;let unfilteredTreeElementFound=false;let currentTreeElement=treeOutline.children[0];while(currentTreeElement){let suppressFilteringForTreeElement=currentTreeElement[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol];if(!suppressFilteringForTreeElement){filterableTreeElementFound=true;if(!currentTreeElement.hidden){unfilteredTreeElementFound=true;break;}}
currentTreeElement=currentTreeElement.nextSibling;}
if(unfilteredTreeElementFound||!filterableTreeElementFound){this.hideEmptyContentPlaceholder(treeOutline);this._emptyFilterResults.set(treeOutline,false);return;}
this.showEmptyContentPlaceholder(WebInspector.UIString("No Filter Results"),treeOutline);this._emptyFilterResults.set(treeOutline,true);}
for(let treeOutline of this.contentTreeOutlines){if(treeOutline[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol])
continue;checkTreeOutlineForEmptyFilterResults.call(this,treeOutline);}}
_filterDidChange()
{this._updateFilter();}
_updateFilter()
{let selectedTreeElement;for(let treeOutline of this.contentTreeOutlines){if(treeOutline.hidden||treeOutline[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol])
continue;selectedTreeElement=treeOutline.selectedTreeElement;if(selectedTreeElement)
break;}
let filters=this._filterBar.filters;this._textFilterRegex=simpleGlobStringToRegExp(filters.text,"i");this._filtersSetting.value=filters;this._filterFunctions=filters.functions;let dontPopulate=!this._filterBar.hasActiveFilters()&&!this.shouldFilterPopulate();for(let treeOutline of this.contentTreeOutlines){if(treeOutline.hidden||treeOutline[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol])
continue;let currentTreeElement=treeOutline.children[0];while(currentTreeElement&&!currentTreeElement.root){if(!currentTreeElement[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol]){const currentTreeElementWasHidden=currentTreeElement.hidden;this.applyFiltersToTreeElement(currentTreeElement);if(currentTreeElementWasHidden!==currentTreeElement.hidden)
this._treeElementWasFiltered(currentTreeElement);}
currentTreeElement=currentTreeElement.traverseNextTreeElement(false,null,dontPopulate);}}
this._checkForEmptyFilterResults();this._updateContentOverflowShadowVisibility();}
_treeElementAddedOrChanged(event)
{var dontPopulate=!this._filterBar.hasActiveFilters()&&!this.shouldFilterPopulate();let treeElement=event.data.element;let currentTreeElement=treeElement;while(currentTreeElement&&!currentTreeElement.root){if(!currentTreeElement[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol]){const currentTreeElementWasHidden=currentTreeElement.hidden;this.applyFiltersToTreeElement(currentTreeElement);if(currentTreeElementWasHidden!==currentTreeElement.hidden)
this._treeElementWasFiltered(currentTreeElement);}
currentTreeElement=currentTreeElement.traverseNextTreeElement(false,treeElement,dontPopulate);}
this._checkForEmptyFilterResults();if(this.visible)
this.soon._updateContentOverflowShadowVisibility();if(this.selected)
this._checkElementsForPendingViewStateCookie([treeElement]);this.treeElementAddedOrChanged(treeElement);}
_treeElementDisclosureDidChange(event)
{this.soon._updateContentOverflowShadowVisibility();}
_checkForStaleResourcesIfNeeded()
{if(!this._checkForStaleResourcesTimeoutIdentifier||!this._shouldAutoPruneStaleTopLevelResourceTreeElements)
return;this.pruneStaleResourceTreeElements();}
_checkForStaleResources(event)
{if(this._checkForStaleResourcesTimeoutIdentifier)
return;this._checkForStaleResourcesTimeoutIdentifier=setTimeout(this.pruneStaleResourceTreeElements.bind(this));}
_isTreeElementWithoutRepresentedObject(treeElement)
{return treeElement instanceof WebInspector.FolderTreeElement||treeElement instanceof WebInspector.DatabaseHostTreeElement||treeElement instanceof WebInspector.IndexedDatabaseHostTreeElement||treeElement instanceof WebInspector.ApplicationCacheManifestTreeElement||treeElement instanceof WebInspector.ThreadTreeElement||treeElement instanceof WebInspector.IdleTreeElement||treeElement instanceof WebInspector.DOMBreakpointTreeElement||treeElement instanceof WebInspector.XHRBreakpointTreeElement||treeElement instanceof WebInspector.CSSStyleSheetTreeElement||typeof treeElement.representedObject==="string"||treeElement.representedObject instanceof String;}
_checkOutlinesForPendingViewStateCookie(matchTypeOnly)
{if(!this._pendingViewStateCookie)
return;this._checkForStaleResourcesIfNeeded();var visibleTreeElements=[];this.contentTreeOutlines.forEach(function(outline){var currentTreeElement=outline.hasChildren?outline.children[0]:null;while(currentTreeElement){visibleTreeElements.push(currentTreeElement);currentTreeElement=currentTreeElement.traverseNextTreeElement(false,null,false);}});return this._checkElementsForPendingViewStateCookie(visibleTreeElements,matchTypeOnly);}
_checkElementsForPendingViewStateCookie(treeElements,matchTypeOnly)
{if(!this._pendingViewStateCookie)
return;var cookie=this._pendingViewStateCookie;function treeElementMatchesCookie(treeElement)
{if(this._isTreeElementWithoutRepresentedObject(treeElement))
return false;var representedObject=treeElement.representedObject;if(!representedObject)
return false;var typeIdentifier=cookie[WebInspector.TypeIdentifierCookieKey];if(typeIdentifier!==representedObject.constructor.TypeIdentifier)
return false;if(matchTypeOnly)
return true;var candidateObjectCookie={};if(representedObject.saveIdentityToCookie)
representedObject.saveIdentityToCookie(candidateObjectCookie);var candidateCookieKeys=Object.keys(candidateObjectCookie);return candidateCookieKeys.length&&candidateCookieKeys.every((key)=>candidateObjectCookie[key]===cookie[key]);}
var matchedElement=null;treeElements.some((element)=>{if(treeElementMatchesCookie.call(this,element)){matchedElement=element;return true;}
return false;});if(matchedElement){let didShowContentView=this.showDefaultContentViewForTreeElement(matchedElement);if(!didShowContentView)
return;this._pendingViewStateCookie=null;
setTimeout(()=>{this._restoringState=false;},0);if(this._finalAttemptToRestoreViewStateTimeout){clearTimeout(this._finalAttemptToRestoreViewStateTimeout);this._finalAttemptToRestoreViewStateTimeout=undefined;}}}
_createEmptyContentPlaceholderIfNeeded(treeOutline)
{let emptyContentPlaceholderElement=this._emptyContentPlaceholderElements.get(treeOutline);if(emptyContentPlaceholderElement)
return emptyContentPlaceholderElement;emptyContentPlaceholderElement=document.createElement("div");emptyContentPlaceholderElement.classList.add(WebInspector.NavigationSidebarPanel.EmptyContentPlaceholderElementStyleClassName);this._emptyContentPlaceholderElements.set(treeOutline,emptyContentPlaceholderElement);let emptyContentPlaceholderMessageElement=document.createElement("div");emptyContentPlaceholderMessageElement.className=WebInspector.NavigationSidebarPanel.EmptyContentPlaceholderMessageElementStyleClassName;emptyContentPlaceholderElement.appendChild(emptyContentPlaceholderMessageElement);return emptyContentPlaceholderElement;}
_treeElementWasFiltered(treeElement)
{if(treeElement.selected||treeElement.hidden)
return;let representedObject=this.currentRepresentedObject;if(!representedObject||treeElement.representedObject!==representedObject)
return;const omitFocus=true;const selectedByUser=false;const suppressOnSelect=true;const suppressOnDeselect=true;treeElement.revealAndSelect(omitFocus,selectedByUser,suppressOnSelect,suppressOnDeselect);}};WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol=Symbol("suppress-filtering");WebInspector.NavigationSidebarPanel.WasExpandedDuringFilteringSymbol=Symbol("was-expanded-during-filtering");WebInspector.NavigationSidebarPanel.OverflowShadowElementStyleClassName="overflow-shadow";WebInspector.NavigationSidebarPanel.ContentTreeOutlineElementStyleClassName="navigation-sidebar-panel-content-tree-outline";WebInspector.NavigationSidebarPanel.EmptyContentPlaceholderElementStyleClassName="empty-content-placeholder";WebInspector.NavigationSidebarPanel.EmptyContentPlaceholderMessageElementStyleClassName="message";WebInspector.PinnedTabBarItem=class PinnedTabBarItem extends WebInspector.TabBarItem
{constructor(image,title,representedObject)
{super(image,title,representedObject);this.element.classList.add("pinned");this.element.addEventListener("contextmenu",this._handleContextMenuEvent.bind(this));} 
_handleContextMenuEvent(event)
{event.preventDefault();let contextMenu=WebInspector.ContextMenu.createFromEvent(event);this.dispatchEventToListeners(WebInspector.PinnedTabBarItem.Event.ContextMenu,{contextMenu});}};WebInspector.PinnedTabBarItem.Event={ContextMenu:"pinned-tab-bar-item-context-menu",};WebInspector.ResourceContentView=class ResourceContentView extends WebInspector.ContentView
{constructor(resource,styleClassName)
{super(resource);this._resource=resource;this.element.classList.add(styleClassName,"resource");this._spinnerTimeout=setTimeout(()=>{
let spinner=new WebInspector.IndeterminateProgressSpinner;this.element.appendChild(spinner.element);this._spinnerTimeout=undefined;},100);this.element.addEventListener("click",this._mouseWasClicked.bind(this),false);resource.requestContent().then(this._contentAvailable.bind(this)).catch(this.showGenericErrorMessage.bind(this));if(!this.managesOwnIssues){WebInspector.issueManager.addEventListener(WebInspector.IssueManager.Event.IssueWasAdded,this._issueWasAdded,this);var issues=WebInspector.issueManager.issuesForSourceCode(resource);for(var i=0;i<issues.length;++i)
this.addIssue(issues[i]);}} 
get resource()
{return this._resource;}
get supportsSave()
{return this._resource.finished;}
get saveData()
{return{url:this._resource.url,content:this._resource.content};}
contentAvailable(content,base64Encoded)
{}
showGenericErrorMessage()
{this._contentError(WebInspector.UIString("An error occurred trying to load the resource."));}
addIssue(issue)
{this.element.removeChildren();this.element.appendChild(WebInspector.createMessageTextView(issue.text,issue.level===WebInspector.IssueMessage.Level.Error));}
closed()
{super.closed();if(!this.managesOwnIssues)
WebInspector.issueManager.removeEventListener(null,null,this);} 
removeLoadingIndicator()
{if(this._spinnerTimeout){clearTimeout(this._spinnerTimeout);this._spinnerTimeout=undefined;}
this.element.removeChildren();} 
_contentAvailable(parameters)
{if(parameters.error){this._contentError(parameters.error);return;}
this.contentAvailable(parameters.sourceCode.content,parameters.base64Encoded);}
_contentError(error)
{if(this._hasContent())
return;this.removeLoadingIndicator();this.element.appendChild(WebInspector.createMessageTextView(error,true));this.dispatchEventToListeners(WebInspector.ResourceContentView.Event.ContentError);}
_hasContent()
{return this.element.hasChildNodes()&&!this.element.querySelector(".indeterminate-progress-spinner");}
_issueWasAdded(event)
{var issue=event.data.issue;if(!WebInspector.IssueManager.issueMatchSourceCode(issue,this.resource))
return;this.addIssue(issue);}
_mouseWasClicked(event)
{WebInspector.handlePossibleLinkClick(event,this.resource.parentFrame);}};WebInspector.ResourceContentView.Event={ContentError:"resource-content-view-content-error",};WebInspector.TabContentView=class TabContentView extends WebInspector.ContentView
{constructor(identifier,styleClassNames,tabBarItem,navigationSidebarPanelConstructor,detailsSidebarPanelConstructors)
{super(null);this.element.classList.add("tab");if(typeof styleClassNames==="string")
styleClassNames=[styleClassNames];this.element.classList.add(...styleClassNames);this._identifier=identifier;this._tabBarItem=tabBarItem;this._navigationSidebarPanelConstructor=navigationSidebarPanelConstructor||null;this._detailsSidebarPanelConstructors=detailsSidebarPanelConstructors||[];const defaultSidebarWidth=300;this._navigationSidebarCollapsedSetting=new WebInspector.Setting(identifier+"-navigation-sidebar-collapsed",false);this._navigationSidebarWidthSetting=new WebInspector.Setting(identifier+"-navigation-sidebar-width",defaultSidebarWidth);this._detailsSidebarCollapsedSetting=new WebInspector.Setting(identifier+"-details-sidebar-collapsed",true);this._detailsSidebarSelectedPanelSetting=new WebInspector.Setting(identifier+"-details-sidebar-selected-panel",null);this._detailsSidebarWidthSetting=new WebInspector.Setting(identifier+"-details-sidebar-width",defaultSidebarWidth);this._cookieSetting=new WebInspector.Setting(identifier+"-tab-cookie",{});}
static isTabAllowed()
{return true;}
static isEphemeral()
{return false;}
static shouldSaveTab()
{return true;} 
get type()
{return null;}
get parentTabBrowser()
{return this._parentTabBrowser;}
set parentTabBrowser(tabBrowser)
{this._parentTabBrowser=tabBrowser||null;}
get identifier()
{return this._identifier;}
get tabBarItem()
{return this._tabBarItem;}
get managesDetailsSidebarPanels()
{return false;}
showDetailsSidebarPanels()
{}
showRepresentedObject(representedObject,cookie)
{}
canShowRepresentedObject(representedObject)
{return false;}
shown()
{super.shown();if(this._shouldRestoreStateWhenShown)
this.restoreStateFromCookie(WebInspector.StateRestorationType.Delayed);}
restoreStateFromCookie(restorationType)
{if(!this.visible){this._shouldRestoreStateWhenShown=true;return;}
this._shouldRestoreStateWhenShown=false;var relaxMatchDelay=0;if(restorationType===WebInspector.StateRestorationType.Load)
relaxMatchDelay=1000;else if(restorationType===WebInspector.StateRestorationType.Navigation)
relaxMatchDelay=2000;let cookie=this._cookieSetting.value||{};if(this.navigationSidebarPanel)
this.navigationSidebarPanel.restoreStateFromCookie(cookie,relaxMatchDelay);this.restoreFromCookie(cookie);}
saveStateToCookie(cookie)
{if(this._shouldRestoreStateWhenShown)
return;cookie=cookie||{};if(this.navigationSidebarPanel)
this.navigationSidebarPanel.saveStateToCookie(cookie);this.saveToCookie(cookie);this._cookieSetting.value=cookie;}
get navigationSidebarPanel()
{if(!this._navigationSidebarPanelConstructor)
return null;return WebInspector.instanceForClass(this._navigationSidebarPanelConstructor);}
get navigationSidebarCollapsedSetting(){return this._navigationSidebarCollapsedSetting;}
get navigationSidebarWidthSetting(){return this._navigationSidebarWidthSetting;}
get detailsSidebarPanels()
{if(!this._detailsSidebarPanels)
this._detailsSidebarPanels=this._detailsSidebarPanelConstructors.map(constructor=>WebInspector.instanceForClass(constructor));return this._detailsSidebarPanels;}
get detailsSidebarCollapsedSetting(){return this._detailsSidebarCollapsedSetting;}
get detailsSidebarSelectedPanelSetting(){return this._detailsSidebarSelectedPanelSetting;}
get detailsSidebarWidthSetting(){return this._detailsSidebarWidthSetting;}};WebInspector.TimelineDataGrid=class TimelineDataGrid extends WebInspector.DataGrid
{constructor(columns,treeOutline,synchronizerDelegate,editCallback,deleteCallback)
{super(columns,editCallback,deleteCallback);if(treeOutline)
this._treeOutlineDataGridSynchronizer=new WebInspector.TreeOutlineDataGridSynchronizer(treeOutline,this,synchronizerDelegate);this.element.classList.add("timeline");this._sortDelegate=null;this._scopeBarColumns=[];for(var[identifier,column]of this.columns){var scopeBar=column.scopeBar;if(!scopeBar)
continue;this._scopeBarColumns.push(identifier);scopeBar.columnIdentifier=identifier;scopeBar.addEventListener(WebInspector.ScopeBar.Event.SelectionChanged,this._scopeBarSelectedItemsDidChange,this);}
if(this._scopeBarColumns.length>1){console.error("Creating a TimelineDataGrid with more than one filterable column is not yet supported.");return;}
this.addEventListener(WebInspector.DataGrid.Event.SelectedNodeChanged,this._dataGridSelectedNodeChanged,this);this.addEventListener(WebInspector.DataGrid.Event.SortChanged,this._sort,this);this.columnChooserEnabled=true;}
static createColumnScopeBar(prefix,map)
{prefix=prefix+"-timeline-data-grid-";var scopeBarItems=[];for(var[key,value]of map){var id=prefix+key;var item=new WebInspector.ScopeBarItem(id,value);item.value=key;scopeBarItems.push(item);}
var allItem=new WebInspector.ScopeBarItem(prefix+"type-all",WebInspector.UIString("All"));scopeBarItems.unshift(allItem);return new WebInspector.ScopeBar(prefix+"scope-bar",scopeBarItems,allItem,true);} 
get sortDelegate()
{return this._sortDelegate;}
set sortDelegate(delegate)
{delegate=delegate||null;if(this._sortDelegate===delegate)
return;this._sortDelegate=delegate;if(this.sortOrder!==WebInspector.DataGrid.SortOrder.Indeterminate)
this.dispatchEventToListeners(WebInspector.DataGrid.Event.SortChanged);}
reset()
{if(!this._treeOutlineDataGridSynchronizer)
this.removeChildren();this._hidePopover();}
shown()
{if(this._treeOutlineDataGridSynchronizer)
this._treeOutlineDataGridSynchronizer.synchronize();}
hidden()
{this._hidePopover();}
treeElementForDataGridNode(dataGridNode)
{if(!this._treeOutlineDataGridSynchronizer)
return null;return this._treeOutlineDataGridSynchronizer.treeElementForDataGridNode(dataGridNode);}
dataGridNodeForTreeElement(treeElement)
{if(!this._treeOutlineDataGridSynchronizer)
return null;return this._treeOutlineDataGridSynchronizer.dataGridNodeForTreeElement(treeElement);}
callFramePopoverAnchorElement()
{return null;}
addRowInSortOrder(treeElement,dataGridNode,parentTreeElementOrDataGridNode)
{let parentDataGridNode;let childElement=dataGridNode;if(treeElement){if(!this._treeOutlineDataGridSynchronizer)
return;this._treeOutlineDataGridSynchronizer.associate(treeElement,dataGridNode);let parentTreeElement=parentTreeElementOrDataGridNode||this._treeOutlineDataGridSynchronizer.treeOutline;parentDataGridNode=parentTreeElement.root?this:this._treeOutlineDataGridSynchronizer.dataGridNodeForTreeElement(parentTreeElement);parentTreeElementOrDataGridNode=parentTreeElement;childElement=treeElement;}else{parentTreeElementOrDataGridNode=parentTreeElementOrDataGridNode||this;parentDataGridNode=parentTreeElementOrDataGridNode;}
if(this.sortColumnIdentifier){let insertionIndex=insertionIndexForObjectInListSortedByFunction(dataGridNode,parentDataGridNode.children,this._sortComparator.bind(this));parentTreeElementOrDataGridNode.insertChild(childElement,insertionIndex);}else{parentTreeElementOrDataGridNode.appendChild(childElement);}}
shouldIgnoreSelectionEvent()
{return this._ignoreSelectionEvent||false;} 
dataGridNodeNeedsRefresh(dataGridNode)
{if(!this._dirtyDataGridNodes)
this._dirtyDataGridNodes=new Set;this._dirtyDataGridNodes.add(dataGridNode);if(this._scheduledDataGridNodeRefreshIdentifier)
return;this._scheduledDataGridNodeRefreshIdentifier=requestAnimationFrame(this._refreshDirtyDataGridNodes.bind(this));}
hasCustomFilters()
{return true;}
matchNodeAgainstCustomFilters(node)
{if(!super.matchNodeAgainstCustomFilters(node))
return false;for(let identifier of this._scopeBarColumns){let scopeBar=this.columns.get(identifier).scopeBar;if(!scopeBar||scopeBar.defaultItem.selected)
continue;let value=node.data[identifier];if(!scopeBar.selectedItems.some((scopeBarItem)=>scopeBarItem.value===value))
return false;}
return true;} 
_refreshDirtyDataGridNodes()
{if(this._scheduledDataGridNodeRefreshIdentifier){cancelAnimationFrame(this._scheduledDataGridNodeRefreshIdentifier);this._scheduledDataGridNodeRefreshIdentifier=undefined;}
if(!this._dirtyDataGridNodes)
return;let selectedNode=this.selectedNode;let sortComparator=this._sortComparator.bind(this);if(this._treeOutlineDataGridSynchronizer)
this._treeOutlineDataGridSynchronizer.enabled=false;for(let dataGridNode of this._dirtyDataGridNodes){dataGridNode.refresh();if(!this.sortColumnIdentifier)
continue;if(dataGridNode===selectedNode)
this._ignoreSelectionEvent=true;if(dataGridNode.parent===this)
this.removeChild(dataGridNode);let insertionIndex=insertionIndexForObjectInListSortedByFunction(dataGridNode,this.children,sortComparator);this.insertChild(dataGridNode,insertionIndex);if(dataGridNode===selectedNode){selectedNode.revealAndSelect();this._ignoreSelectionEvent=false;}
if(!this._treeOutlineDataGridSynchronizer)
continue;let treeOutline=this._treeOutlineDataGridSynchronizer.treeOutline;let treeElement=this._treeOutlineDataGridSynchronizer.treeElementForDataGridNode(dataGridNode);treeOutline.reattachIfIndexChanged(treeElement,insertionIndex);dataGridNode.element.classList.toggle("hidden",treeElement.hidden);}
if(this._treeOutlineDataGridSynchronizer)
this._treeOutlineDataGridSynchronizer.enabled=true;this._dirtyDataGridNodes=null;}
_sort()
{if(!this.children.length)
return;let sortColumnIdentifier=this.sortColumnIdentifier;if(!sortColumnIdentifier)
return;let selectedNode=this.selectedNode;this._ignoreSelectionEvent=true;let treeOutline;if(this._treeOutlineDataGridSynchronizer){this._treeOutlineDataGridSynchronizer.enabled=false;treeOutline=this._treeOutlineDataGridSynchronizer.treeOutline;if(treeOutline.selectedTreeElement)
treeOutline.selectedTreeElement.deselect(true);}

let parentDataGridNodes=[this];let currentDataGridNode=this.children[0];while(currentDataGridNode){if(currentDataGridNode.children.length)
parentDataGridNodes.push(currentDataGridNode);currentDataGridNode=currentDataGridNode.traverseNextNode(false,null,true);}
for(let parentDataGridNode of parentDataGridNodes){let childDataGridNodes=parentDataGridNode.children.slice();parentDataGridNode.removeChildren();let parentTreeElement;if(this._treeOutlineDataGridSynchronizer){parentTreeElement=parentDataGridNode===this?treeOutline:this._treeOutlineDataGridSynchronizer.treeElementForDataGridNode(parentDataGridNode);parentTreeElement.removeChildren();}
childDataGridNodes.sort(this._sortComparator.bind(this));for(let dataGridNode of childDataGridNodes){if(this._treeOutlineDataGridSynchronizer){let treeElement=this._treeOutlineDataGridSynchronizer.treeElementForDataGridNode(dataGridNode);if(parentTreeElement)
parentTreeElement.appendChild(treeElement);dataGridNode.element.classList.toggle("hidden",treeElement.hidden);}
parentDataGridNode.appendChild(dataGridNode);}}
if(this._treeOutlineDataGridSynchronizer)
this._treeOutlineDataGridSynchronizer.enabled=true;if(selectedNode)
selectedNode.revealAndSelect();this._ignoreSelectionEvent=false;}
_sortComparator(node1,node2)
{var sortColumnIdentifier=this.sortColumnIdentifier;if(!sortColumnIdentifier)
return 0;var sortDirection=this.sortOrder===WebInspector.DataGrid.SortOrder.Ascending?1:-1;if(this._sortDelegate&&typeof this._sortDelegate.dataGridSortComparator==="function"){let result=this._sortDelegate.dataGridSortComparator(sortColumnIdentifier,sortDirection,node1,node2);if(typeof result==="number")
return result;}
var value1=node1.data[sortColumnIdentifier];var value2=node2.data[sortColumnIdentifier];if(typeof value1==="number"&&typeof value2==="number"){if(isNaN(value1)&&isNaN(value2))
return 0;if(isNaN(value1))
return-sortDirection;if(isNaN(value2))
return sortDirection;return(value1-value2)*sortDirection;}
if(typeof value1==="string"&&typeof value2==="string")
return value1.extendedLocaleCompare(value2)*sortDirection;if(value1 instanceof WebInspector.CallFrame||value2 instanceof WebInspector.CallFrame){value1=value1&&value1.functionName?value1.functionName:(value1&&value1.sourceCodeLocation?value1.sourceCodeLocation.sourceCode:"");value2=value2&&value2.functionName?value2.functionName:(value2&&value2.sourceCodeLocation?value2.sourceCodeLocation.sourceCode:"");}
if(value1 instanceof WebInspector.SourceCode||value2 instanceof WebInspector.SourceCode){value1=value1?value1.displayName||"":"";value2=value2?value2.displayName||"":"";}
if(value1 instanceof WebInspector.SourceCodeLocation||value2 instanceof WebInspector.SourceCodeLocation){value1=value1?value1.displayLocationString()||"":"";value2=value2?value2.displayLocationString()||"":"";}
return(value1<value2?-1:(value1>value2?1:0))*sortDirection;}
_scopeBarSelectedItemsDidChange(event)
{this.filterDidChange();}
_dataGridSelectedNodeChanged(event)
{if(!this.selectedNode){this._hidePopover();return;}
var record=this.selectedNode.record;if(!record||!record.callFrames||!record.callFrames.length){this._hidePopover();return;}
this._showPopoverForSelectedNodeSoon();}
_showPopoverForSelectedNodeSoon()
{if(this._showPopoverTimeout)
return;this._showPopoverTimeout=setTimeout(()=>{if(!this._popover){this._popover=new WebInspector.Popover;this._popover.windowResizeHandler=()=>{this._updatePopoverForSelectedNode(false);};}
this._updatePopoverForSelectedNode(true);this._showPopoverTimeout=undefined;},WebInspector.TimelineDataGrid.DelayedPopoverShowTimeout);}
_hidePopover()
{if(this._showPopoverTimeout){clearTimeout(this._showPopoverTimeout);this._showPopoverTimeout=undefined;}
if(this._popover)
this._popover.dismiss();if(this._hidePopoverContentClearTimeout)
clearTimeout(this._hidePopoverContentClearTimeout);this._hidePopoverContentClearTimeout=setTimeout(()=>{if(this._popoverCallStackTreeOutline)
this._popoverCallStackTreeOutline.removeChildren();},WebInspector.TimelineDataGrid.DelayedPopoverHideContentClearTimeout);}
_updatePopoverForSelectedNode(updateContent)
{if(!this._popover||!this.selectedNode)
return;let targetPopoverElement=this.callFramePopoverAnchorElement();if(!targetPopoverElement)
return;let rect=WebInspector.Rect.rectFromClientRect(targetPopoverElement.getBoundingClientRect());if(!rect.size.width&&!rect.size.height)
return;if(this._hidePopoverContentClearTimeout){clearTimeout(this._hidePopoverContentClearTimeout);this._hidePopoverContentClearTimeout=undefined;}
let targetFrame=rect.pad(2);let preferredEdges=[WebInspector.RectEdge.MAX_Y,WebInspector.RectEdge.MIN_Y,WebInspector.RectEdge.MAX_X];if(updateContent)
this._popover.presentNewContentWithFrame(this._createPopoverContent(),targetFrame,preferredEdges);else
this._popover.present(targetFrame,preferredEdges);}
_createPopoverContent()
{if(!this._popoverCallStackTreeOutline){this._popoverCallStackTreeOutline=new WebInspector.TreeOutline;this._popoverCallStackTreeOutline.disclosureButtons=false;this._popoverCallStackTreeOutline.element.classList.add("timeline-data-grid");this._popoverCallStackTreeOutline.addEventListener(WebInspector.TreeOutline.Event.SelectionDidChange,this._popoverCallStackTreeSelectionDidChange,this);}else
this._popoverCallStackTreeOutline.removeChildren();var callFrames=this.selectedNode.record.callFrames;for(var i=0;i<callFrames.length;++i){var callFrameTreeElement=new WebInspector.CallFrameTreeElement(callFrames[i]);this._popoverCallStackTreeOutline.appendChild(callFrameTreeElement);}
var content=document.createElement("div");content.className="timeline-data-grid-popover";content.appendChild(this._popoverCallStackTreeOutline.element);return content;}
_popoverCallStackTreeSelectionDidChange(event)
{let treeElement=event.data.selectedElement;if(!treeElement)
return;this._popover.dismiss();var callFrame=treeElement.callFrame;if(!callFrame.sourceCodeLocation)
return;WebInspector.showSourceCodeLocation(callFrame.sourceCodeLocation,{ignoreNetworkTab:true,ignoreSearchTab:true,});}};WebInspector.TimelineDataGrid.HasNonDefaultFilterStyleClassName="has-non-default-filter";WebInspector.TimelineDataGrid.DelayedPopoverShowTimeout=250;WebInspector.TimelineDataGrid.DelayedPopoverHideContentClearTimeout=500;WebInspector.TimelineDataGridNode=class TimelineDataGridNode extends WebInspector.DataGridNode
{constructor(includesGraph,graphDataSource,hasChildren)
{super({},hasChildren);this.copyable=false;this._includesGraph=includesGraph||false;this._graphDataSource=graphDataSource||null;if(graphDataSource){this._graphContainerElement=document.createElement("div");this._timelineRecordBars=[];}} 
get record()
{return this.records&&this.records.length?this.records[0]:null;}
get records()
{return[];}
get graphDataSource()
{return this._graphDataSource;}
get data()
{if(!this._graphDataSource)
return{};var records=this.records||[];return{graph:records.length?records[0].startTime:0};}
collapse()
{super.collapse();if(!this._graphDataSource||!this.revealed)
return;this.refreshGraph();}
expand()
{super.expand();if(!this._graphDataSource||!this.revealed)
return;this.refreshGraph();var childNode=this.children[0];while(childNode){if(childNode instanceof WebInspector.TimelineDataGridNode)
childNode.refreshGraph();childNode=childNode.traverseNextNode(true,this);}}
createCellContent(columnIdentifier,cell)
{if(columnIdentifier==="graph"&&this._graphDataSource){this.needsGraphRefresh();return this._graphContainerElement;}
var value=this.data[columnIdentifier];if(!value)
return emDash;const options={useGoToArrowButton:true,ignoreNetworkTab:true,ignoreSearchTab:true,};if(value instanceof WebInspector.SourceCodeLocation){if(value.sourceCode instanceof WebInspector.Resource){cell.classList.add(WebInspector.ResourceTreeElement.ResourceIconStyleClassName);cell.classList.add(value.sourceCode.type);}else if(value.sourceCode instanceof WebInspector.Script){if(value.sourceCode.url){cell.classList.add(WebInspector.ResourceTreeElement.ResourceIconStyleClassName);cell.classList.add(WebInspector.Resource.Type.Script);}else
cell.classList.add(WebInspector.ScriptTreeElement.AnonymousScriptIconStyleClassName);}else
console.error("Unknown SourceCode subclass.");value.populateLiveDisplayLocationTooltip(cell);var fragment=document.createDocumentFragment();fragment.appendChild(WebInspector.createSourceCodeLocationLink(value,options));var titleElement=document.createElement("span");value.populateLiveDisplayLocationString(titleElement,"textContent");fragment.appendChild(titleElement);return fragment;}
if(value instanceof WebInspector.CallFrame){var callFrame=value;var isAnonymousFunction=false;var functionName=callFrame.functionName;if(!functionName){functionName=WebInspector.UIString("(anonymous function)");isAnonymousFunction=true;}
cell.classList.add(WebInspector.CallFrameView.FunctionIconStyleClassName);var fragment=document.createDocumentFragment();if(callFrame.sourceCodeLocation&&callFrame.sourceCodeLocation.sourceCode){callFrame.sourceCodeLocation.populateLiveDisplayLocationTooltip(cell);fragment.appendChild(WebInspector.createSourceCodeLocationLink(callFrame.sourceCodeLocation,options));if(isAnonymousFunction){if(callFrame.sourceCodeLocation.sourceCode instanceof WebInspector.Resource){cell.classList.add(WebInspector.ResourceTreeElement.ResourceIconStyleClassName);cell.classList.add(callFrame.sourceCodeLocation.sourceCode.type);}else if(callFrame.sourceCodeLocation.sourceCode instanceof WebInspector.Script){if(callFrame.sourceCodeLocation.sourceCode.url){cell.classList.add(WebInspector.ResourceTreeElement.ResourceIconStyleClassName);cell.classList.add(WebInspector.Resource.Type.Script);}else
cell.classList.add(WebInspector.ScriptTreeElement.AnonymousScriptIconStyleClassName);}else
console.error("Unknown SourceCode subclass.");var titleElement=document.createElement("span");callFrame.sourceCodeLocation.populateLiveDisplayLocationString(titleElement,"textContent");fragment.appendChild(titleElement);}else{cell.classList.add(WebInspector.CallFrameView.FunctionIconStyleClassName);fragment.append(functionName);var subtitleElement=document.createElement("span");subtitleElement.classList.add("subtitle");callFrame.sourceCodeLocation.populateLiveDisplayLocationString(subtitleElement,"textContent");fragment.appendChild(subtitleElement);}
return fragment;}
var icon=document.createElement("div");icon.classList.add("icon");fragment.append(icon,functionName);return fragment;}
return super.createCellContent(columnIdentifier,cell);}
refresh()
{if(this._graphDataSource&&this._includesGraph)
this.needsGraphRefresh();super.refresh();}
refreshGraph()
{if(!this._graphDataSource)
return;if(this._scheduledGraphRefreshIdentifier){cancelAnimationFrame(this._scheduledGraphRefreshIdentifier);this._scheduledGraphRefreshIdentifier=undefined;}
if(!this.revealed)
return;let secondsPerPixel=this._graphDataSource.secondsPerPixel;if(isNaN(secondsPerPixel))
return;var recordBarIndex=0;function createBar(records,renderMode)
{var timelineRecordBar=this._timelineRecordBars[recordBarIndex];if(!timelineRecordBar)
timelineRecordBar=this._timelineRecordBars[recordBarIndex]=new WebInspector.TimelineRecordBar(records,renderMode);else{timelineRecordBar.renderMode=renderMode;timelineRecordBar.records=records;}
timelineRecordBar.refresh(this._graphDataSource);if(!timelineRecordBar.element.parentNode){this._graphContainerElement.appendChild(timelineRecordBar.element);this.didAddRecordBar(timelineRecordBar);}
++recordBarIndex;}
function collectRecordsByType(records,recordsByTypeMap)
{for(var record of records){var typedRecords=recordsByTypeMap.get(record.type);if(!typedRecords){typedRecords=[];recordsByTypeMap.set(record.type,typedRecords);}
typedRecords.push(record);}}
var boundCreateBar=createBar.bind(this);if(this.expanded){WebInspector.TimelineRecordBar.createCombinedBars(this.records,secondsPerPixel,this._graphDataSource,boundCreateBar);}else{var recordTypeMap=new Map;collectRecordsByType(this.records,recordTypeMap);var childNode=this.children[0];while(childNode){if(childNode instanceof WebInspector.TimelineDataGridNode)
collectRecordsByType(childNode.records,recordTypeMap);childNode=childNode.traverseNextNode(false,this);}
for(var records of recordTypeMap.values())
WebInspector.TimelineRecordBar.createCombinedBars(records,secondsPerPixel,this._graphDataSource,boundCreateBar);}
for(;recordBarIndex<this._timelineRecordBars.length;++recordBarIndex){this._timelineRecordBars[recordBarIndex].element.remove();this.didRemoveRecordBar(this._timelineRecordBars[recordBarIndex]);this._timelineRecordBars[recordBarIndex].records=null;}}
needsGraphRefresh()
{if(!this.revealed){var ancestor=this;while(ancestor&&!ancestor.root){if(ancestor.revealed&&ancestor instanceof WebInspector.TimelineDataGridNode){ancestor.needsGraphRefresh();return;}
ancestor=ancestor.parent;}
return;}
if(!this._graphDataSource||this._scheduledGraphRefreshIdentifier)
return;this._scheduledGraphRefreshIdentifier=requestAnimationFrame(this.refreshGraph.bind(this));}
displayName()
{const includeDetails=true;return WebInspector.TimelineTabContentView.displayNameForRecord(this.record,true);}
iconClassNames()
{return[WebInspector.TimelineTabContentView.iconClassNameForRecord(this.record)];} 
createGoToArrowButton(cellElement,callback)
{function buttonClicked(event)
{if(this.hidden||!this.revealed)
return;event.stopPropagation();callback(this,cellElement.__columnIdentifier);}
let button=WebInspector.createGoToArrowButton();button.addEventListener("click",buttonClicked.bind(this));let contentElement=cellElement.firstChild;contentElement.appendChild(button);}
isRecordVisible(record)
{if(!this._graphDataSource)
return false;if(isNaN(record.startTime))
return false;if(record.endTime<this.graphDataSource.startTime)
return false;if(record.startTime>this.graphDataSource.currentTime||record.startTime>this.graphDataSource.endTime)
return false;return true;}
filterableDataForColumn(columnIdentifier)
{let value=this.data[columnIdentifier];if(value instanceof WebInspector.SourceCodeLocation)
return value.displayLocationString();if(value instanceof WebInspector.CallFrame)
return[value.functionName,value.sourceCodeLocation.displayLocationString()];return super.filterableDataForColumn(columnIdentifier);}
didAddRecordBar(recordBar)
{}
didRemoveRecordBar(recordBar)
{}
didResizeColumn(columnIdentifier)
{if(columnIdentifier!=="graph")
return;this.needsGraphRefresh();}};WebInspector.ContentBrowserTabContentView=class ContentBrowserTabContentView extends WebInspector.TabContentView
{constructor(identifier,styleClassNames,tabBarItem,navigationSidebarPanelConstructor,detailsSidebarPanelConstructors,disableBackForward)
{if(typeof styleClassNames==="string")
styleClassNames=[styleClassNames];styleClassNames.push("content-browser");var contentBrowser=new WebInspector.ContentBrowser(null,null,disableBackForward);super(identifier,styleClassNames,tabBarItem,navigationSidebarPanelConstructor,detailsSidebarPanelConstructors);this._contentBrowser=contentBrowser;this._contentBrowser.delegate=this;this._lastSelectedDetailsSidebarPanelSetting=new WebInspector.Setting(identifier+"-last-selected-details-sidebar-panel",null);this._contentBrowser.addEventListener(WebInspector.ContentBrowser.Event.CurrentRepresentedObjectsDidChange,this.showDetailsSidebarPanels,this);this._contentBrowser.addEventListener(WebInspector.ContentBrowser.Event.CurrentContentViewDidChange,this._contentBrowserCurrentContentViewDidChange,this);this._contentBrowser.updateHierarchicalPathForCurrentContentView();if(navigationSidebarPanelConstructor){let showToolTip=WebInspector.UIString("Show the navigation sidebar (%s)").format(WebInspector.navigationSidebarKeyboardShortcut.displayName);let hideToolTip=WebInspector.UIString("Hide the navigation sidebar (%s)").format(WebInspector.navigationSidebarKeyboardShortcut.displayName);let image=WebInspector.resolvedLayoutDirection()==WebInspector.LayoutDirection.RTL?"Images/ToggleRightSidebar.svg":"Images/ToggleLeftSidebar.svg";this._showNavigationSidebarItem=new WebInspector.ActivateButtonNavigationItem("toggle-navigation-sidebar",showToolTip,hideToolTip,image,16,16);this._showNavigationSidebarItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,WebInspector.toggleNavigationSidebar,WebInspector);this._showNavigationSidebarItem.activated=!WebInspector.navigationSidebar.collapsed;this._contentBrowser.navigationBar.insertNavigationItem(this._showNavigationSidebarItem,0);this._contentBrowser.navigationBar.insertNavigationItem(new WebInspector.DividerNavigationItem,1);WebInspector.navigationSidebar.addEventListener(WebInspector.Sidebar.Event.CollapsedStateDidChange,this._navigationSidebarCollapsedStateDidChange,this);}
if(detailsSidebarPanelConstructors&&detailsSidebarPanelConstructors.length){let showToolTip=WebInspector.UIString("Show the details sidebar (%s)").format(WebInspector.detailsSidebarKeyboardShortcut.displayName);let hideToolTip=WebInspector.UIString("Hide the details sidebar (%s)").format(WebInspector.detailsSidebarKeyboardShortcut.displayName);let image=WebInspector.resolvedLayoutDirection()==WebInspector.LayoutDirection.RTL?"Images/ToggleLeftSidebar.svg":"Images/ToggleRightSidebar.svg";this._showDetailsSidebarItem=new WebInspector.ActivateButtonNavigationItem("toggle-details-sidebar",showToolTip,hideToolTip,image,16,16);this._showDetailsSidebarItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,WebInspector.toggleDetailsSidebar,WebInspector);this._showDetailsSidebarItem.activated=!WebInspector.detailsSidebar.collapsed;this._showDetailsSidebarItem.enabled=false;this._contentBrowser.navigationBar.addNavigationItem(new WebInspector.DividerNavigationItem);this._contentBrowser.navigationBar.addNavigationItem(this._showDetailsSidebarItem);WebInspector.detailsSidebar.addEventListener(WebInspector.Sidebar.Event.CollapsedStateDidChange,this._detailsSidebarCollapsedStateDidChange,this);WebInspector.detailsSidebar.addEventListener(WebInspector.Sidebar.Event.SidebarPanelSelected,this._detailsSidebarPanelSelected,this);}
this.addSubview(this._contentBrowser);} 
get contentBrowser()
{return this._contentBrowser;}
shown()
{if(this.navigationSidebarPanel){if(!this.navigationSidebarPanel.contentBrowser)
this.navigationSidebarPanel.contentBrowser=this._contentBrowser;}
super.shown();this._contentBrowser.shown();if(this.navigationSidebarPanel){if(!this._contentBrowser.currentContentView)
this.navigationSidebarPanel.showDefaultContentView();}}
hidden()
{super.hidden();this._contentBrowser.hidden();}
closed()
{super.closed();WebInspector.navigationSidebar.removeEventListener(null,null,this);WebInspector.detailsSidebar.removeEventListener(null,null,this);if(this.navigationSidebarPanel&&typeof this.navigationSidebarPanel.closed==="function")
this.navigationSidebarPanel.closed();this._contentBrowser.contentViewContainer.closeAllContentViews();}
get managesDetailsSidebarPanels()
{return true;}
showDetailsSidebarPanels()
{if(!this.visible)
return;var currentRepresentedObjects=this._contentBrowser.currentRepresentedObjects;var currentSidebarPanels=WebInspector.detailsSidebar.sidebarPanels;var wasSidebarEmpty=!currentSidebarPanels.length;
this._ignoreDetailsSidebarPanelSelectedEvent=true;this._ignoreDetailsSidebarPanelCollapsedEvent=true;let hiddenSidebarPanels=0;for(var i=0;i<this.detailsSidebarPanels.length;++i){var sidebarPanel=this.detailsSidebarPanels[i];if(sidebarPanel.inspect(currentRepresentedObjects)){if(currentSidebarPanels.includes(sidebarPanel)){continue;}
let index=i-hiddenSidebarPanels;WebInspector.detailsSidebar.insertSidebarPanel(sidebarPanel,index);if(this._lastSelectedDetailsSidebarPanelSetting.value===sidebarPanel.identifier){WebInspector.detailsSidebar.selectedSidebarPanel=sidebarPanel;}}else{WebInspector.detailsSidebar.removeSidebarPanel(sidebarPanel);hiddenSidebarPanels++;}}
if(!WebInspector.detailsSidebar.selectedSidebarPanel&&currentSidebarPanels.length)
WebInspector.detailsSidebar.selectedSidebarPanel=currentSidebarPanels[0];if(!WebInspector.detailsSidebar.sidebarPanels.length)
WebInspector.detailsSidebar.collapsed=true;else if(wasSidebarEmpty)
WebInspector.detailsSidebar.collapsed=this.detailsSidebarCollapsedSetting.value;this._ignoreDetailsSidebarPanelCollapsedEvent=false;this._ignoreDetailsSidebarPanelSelectedEvent=false;if(!this.detailsSidebarPanels.length)
return;this._showDetailsSidebarItem.enabled=WebInspector.detailsSidebar.sidebarPanels.length;}
showRepresentedObject(representedObject,cookie)
{if(this.navigationSidebarPanel)
this.navigationSidebarPanel.cancelRestoringState();this.contentBrowser.showContentViewForRepresentedObject(representedObject,cookie);} 
contentBrowserTreeElementForRepresentedObject(contentBrowser,representedObject)
{return this.treeElementForRepresentedObject(representedObject);} 
treeElementForRepresentedObject(representedObject)
{if(!this.navigationSidebarPanel)
return null;return this.navigationSidebarPanel.treeElementForRepresentedObject(representedObject);} 
_navigationSidebarCollapsedStateDidChange(event)
{this._showNavigationSidebarItem.activated=!WebInspector.navigationSidebar.collapsed;}
_detailsSidebarCollapsedStateDidChange(event)
{if(!this.visible)
return;this._showDetailsSidebarItem.activated=!WebInspector.detailsSidebar.collapsed;this._showDetailsSidebarItem.enabled=WebInspector.detailsSidebar.sidebarPanels.length;if(this._ignoreDetailsSidebarPanelCollapsedEvent)
return;this.detailsSidebarCollapsedSetting.value=WebInspector.detailsSidebar.collapsed;}
_detailsSidebarPanelSelected(event)
{if(!this.visible)
return;this._showDetailsSidebarItem.activated=!WebInspector.detailsSidebar.collapsed;this._showDetailsSidebarItem.enabled=WebInspector.detailsSidebar.sidebarPanels.length;if(!WebInspector.detailsSidebar.selectedSidebarPanel||this._ignoreDetailsSidebarPanelSelectedEvent)
return;this._lastSelectedDetailsSidebarPanelSetting.value=WebInspector.detailsSidebar.selectedSidebarPanel.identifier;}
_contentBrowserCurrentContentViewDidChange(event)
{let currentContentView=this._contentBrowser.currentContentView;if(!currentContentView)
return;this._revealAndSelectRepresentedObject(currentContentView.representedObject);}
_revealAndSelectRepresentedObject(representedObject)
{if(this.navigationSidebarPanel){

for(let contentTreeOutline of this.navigationSidebarPanel.contentTreeOutlines){if(contentTreeOutline.processingSelectionChange)
return;}}
let treeElement=this.treeElementForRepresentedObject(representedObject);if(treeElement)
treeElement.revealAndSelect(true,false,true,true);else if(this.navigationSidebarPanel&&this.navigationSidebarPanel.contentTreeOutline.selectedTreeElement)
this.navigationSidebarPanel.contentTreeOutline.selectedTreeElement.deselect(true);}};WebInspector.DOMDetailsSidebarPanel=class DOMDetailsSidebarPanel extends WebInspector.DetailsSidebarPanel
{constructor(identifier,displayName,dontCreateNavigationItem)
{super(identifier,displayName,dontCreateNavigationItem);this.element.addEventListener("click",this._mouseWasClicked.bind(this),true);this._domNode=null;} 
inspect(objects)
{if(!(objects instanceof Array))
objects=[objects];var nodeToInspect=null;for(var i=0;i<objects.length;++i){if(objects[i]instanceof WebInspector.DOMNode){nodeToInspect=objects[i];break;}}
if(nodeToInspect&&!this.supportsDOMNode(nodeToInspect))
nodeToInspect=null;this.domNode=nodeToInspect;return!!this._domNode;}
get domNode()
{return this._domNode;}
set domNode(domNode)
{if(domNode===this._domNode)
return;if(this._domNode)
this.removeEventListeners();this._domNode=domNode;if(this._domNode)
this.addEventListeners();this.needsLayout();}
supportsDOMNode(nodeToInspect)
{return true;}
addEventListeners()
{}
removeEventListeners()
{} 
_mouseWasClicked(event)
{if(this._domNode&&this._domNode.ownerDocument){var mainResource=WebInspector.frameResourceManager.resourceForURL(this._domNode.ownerDocument.documentURL);if(mainResource)
var parentFrame=mainResource.parentFrame;}
const options={ignoreNetworkTab:true,ignoreSearchTab:true,};WebInspector.handlePossibleLinkClick(event,parentFrame,options);}};WebInspector.FolderTreeElement=class FolderTreeElement extends WebInspector.GeneralTreeElement
{constructor(title,representedObject)
{const classNames=[WebInspector.FolderTreeElement.FolderIconStyleClassName];const subtitle=null;const hasChildren=true;super(classNames,title,subtitle,representedObject,hasChildren);}};WebInspector.FolderTreeElement.FolderIconStyleClassName="folder-icon";WebInspector.FolderizedTreeElement=class FolderizedTreeElement extends WebInspector.GeneralTreeElement
{constructor(classNames,title,subtitle,representedObject,hasChildren)
{super(classNames,title,subtitle,representedObject,hasChildren);this.shouldRefreshChildren=true;this._folderExpandedSettingMap=new Map;this._folderSettingsKey="";this._folderTypeMap=new Map;this._folderizeSettingsMap=new Map;this._groupedIntoFolders=false;this._clearNewChildQueue();} 
get groupedIntoFolders()
{return this._groupedIntoFolders;}
set folderSettingsKey(x)
{this._folderSettingsKey=x;}
registerFolderizeSettings(type,displayName,representedObject,treeElementConstructor)
{let settings={type,displayName,topLevel:displayName===null,representedObject,treeElementConstructor,};this._folderizeSettingsMap.set(type,settings);}
removeChildren()
{super.removeChildren();this._clearNewChildQueue();for(var folder of this._folderTypeMap.values())
folder.removeChildren();this._folderExpandedSettingMap.clear();this._folderTypeMap.clear();this._groupedIntoFolders=false;} 
addChildForRepresentedObject(representedObject)
{var settings=this._settingsForRepresentedObject(representedObject);if(!settings){console.error("No settings for represented object",representedObject);return;}
if(!this.treeOutline){this.shouldRefreshChildren=true;return;}
var childTreeElement=this.treeOutline.getCachedTreeElement(representedObject);if(!childTreeElement)
childTreeElement=new settings.treeElementConstructor(representedObject);this._addTreeElement(childTreeElement);}
addRepresentedObjectToNewChildQueue(representedObject)
{this._newChildQueue.push(representedObject);if(!this._newChildQueueTimeoutIdentifier)
this._newChildQueueTimeoutIdentifier=setTimeout(this._populateFromNewChildQueue.bind(this),WebInspector.FolderizedTreeElement.NewChildQueueUpdateInterval);}
removeChildForRepresentedObject(representedObject)
{this._removeRepresentedObjectFromNewChildQueue(representedObject);this.updateParentStatus();if(!this.treeOutline){this.shouldRefreshChildren=true;return;}

var childTreeElement=this.treeOutline.getCachedTreeElement(representedObject);if(!childTreeElement||!childTreeElement.parent)
return;this._removeTreeElement(childTreeElement);}
compareChildTreeElements(a,b)
{return this._compareTreeElementsByMainTitle(a,b);}
updateParentStatus()
{let hasChildren=false;for(let settings of this._folderizeSettingsMap.values()){if(settings.representedObject.items.size){hasChildren=true;break;}}
this.hasChildren=hasChildren;if(!this.hasChildren)
this.removeChildren();}
prepareToPopulate()
{if(!this._groupedIntoFolders&&this._shouldGroupIntoFolders()){this._groupedIntoFolders=true;return true;}
return false;} 
_clearNewChildQueue()
{this._newChildQueue=[];if(this._newChildQueueTimeoutIdentifier){clearTimeout(this._newChildQueueTimeoutIdentifier);this._newChildQueueTimeoutIdentifier=null;}}
_populateFromNewChildQueue()
{if(!this.children.length){this.updateParentStatus();this.shouldRefreshChildren=true;return;}
if(this.prepareToPopulate()){this._clearNewChildQueue();this.shouldRefreshChildren=true;return;}
for(var i=0;i<this._newChildQueue.length;++i)
this.addChildForRepresentedObject(this._newChildQueue[i]);this._clearNewChildQueue();}
_removeRepresentedObjectFromNewChildQueue(representedObject)
{this._newChildQueue.remove(representedObject);}
_addTreeElement(childTreeElement)
{if(!childTreeElement)
return;var wasSelected=childTreeElement.selected;this._removeTreeElement(childTreeElement,true,true);var parentTreeElement=this._parentTreeElementForRepresentedObject(childTreeElement.representedObject);if(parentTreeElement!==this&&!parentTreeElement.parent)
this._insertFolderTreeElement(parentTreeElement);this._insertChildTreeElement(parentTreeElement,childTreeElement);if(wasSelected)
childTreeElement.revealAndSelect(true,false,true,true);}
_compareTreeElementsByMainTitle(a,b)
{let aIsFolder=a instanceof WebInspector.FolderTreeElement;let bIsFolder=b instanceof WebInspector.FolderTreeElement;if(aIsFolder&&!bIsFolder)
return-1;if(bIsFolder&&!aIsFolder)
return 1;return a.mainTitle.extendedLocaleCompare(b.mainTitle);}
_insertFolderTreeElement(folderTreeElement)
{this.insertChild(folderTreeElement,insertionIndexForObjectInListSortedByFunction(folderTreeElement,this.children,this._compareTreeElementsByMainTitle));}
_insertChildTreeElement(parentTreeElement,childTreeElement)
{parentTreeElement.insertChild(childTreeElement,insertionIndexForObjectInListSortedByFunction(childTreeElement,parentTreeElement.children,this.compareChildTreeElements.bind(this)));}
_removeTreeElement(childTreeElement,suppressOnDeselect,suppressSelectSibling)
{var oldParent=childTreeElement.parent;if(!oldParent)
return;oldParent.removeChild(childTreeElement,suppressOnDeselect,suppressSelectSibling);if(oldParent===this)
return;if(!(oldParent instanceof WebInspector.FolderTreeElement))
return;if(!oldParent.children.length)
oldParent.parent.removeChild(oldParent);}
_parentTreeElementForRepresentedObject(representedObject)
{if(!this._groupedIntoFolders)
return this;function createFolderTreeElement(settings)
{let folderTreeElement=new WebInspector.FolderTreeElement(settings.displayName,settings.representedObject);let folderExpandedSetting=new WebInspector.Setting(settings.type+"-folder-expanded-"+this._folderSettingsKey,false);this._folderExpandedSettingMap.set(folderTreeElement,folderExpandedSetting);if(folderExpandedSetting.value)
folderTreeElement.expand();folderTreeElement.onexpand=this._folderTreeElementExpandedStateChange.bind(this);folderTreeElement.oncollapse=this._folderTreeElementExpandedStateChange.bind(this);return folderTreeElement;}
var settings=this._settingsForRepresentedObject(representedObject);if(!settings){console.error("Unknown representedObject",representedObject);return this;}
if(settings.topLevel)
return this;var folder=this._folderTypeMap.get(settings.type);if(folder)
return folder;folder=createFolderTreeElement.call(this,settings);this._folderTypeMap.set(settings.type,folder);return folder;}
_folderTreeElementExpandedStateChange(folderTreeElement)
{let expandedSetting=this._folderExpandedSettingMap.get(folderTreeElement);if(!expandedSetting)
return;expandedSetting.value=folderTreeElement.expanded;}
_settingsForRepresentedObject(representedObject)
{for(let settings of this._folderizeSettingsMap.values()){if(settings.representedObject.typeVerifier(representedObject))
return settings;}
return null;}
_shouldGroupIntoFolders()
{if(this._groupedIntoFolders)
return true;
var numberOfSmallCategories=0;var numberOfMediumCategories=0;var foundLargeCategory=false;function pushCategory(childCount)
{if(!childCount)
return false;if(foundLargeCategory)
return true;if(childCount>=WebInspector.FolderizedTreeElement.LargeChildCountThreshold){if(numberOfSmallCategories||numberOfMediumCategories)
return true;foundLargeCategory=true;return false;}
if(childCount>=WebInspector.FolderizedTreeElement.MediumChildCountThreshold){return++numberOfMediumCategories>=WebInspector.FolderizedTreeElement.NumberOfMediumCategoriesThreshold;}
++numberOfSmallCategories;return false;}
for(var settings of this._folderizeSettingsMap.values()){if(pushCategory(settings.representedObject.items.size))
return true;}
return false;}};WebInspector.FolderizedTreeElement.MediumChildCountThreshold=5;WebInspector.FolderizedTreeElement.LargeChildCountThreshold=15;WebInspector.FolderizedTreeElement.NumberOfMediumCategoriesThreshold=2;WebInspector.FolderizedTreeElement.NewChildQueueUpdateInterval=500;WebInspector.NetworkTabContentView=class NetworkTabContentView extends WebInspector.ContentBrowserTabContentView
{constructor(identifier)
{let{image,title}=WebInspector.NetworkTabContentView.tabInfo();let tabBarItem=new WebInspector.GeneralTabBarItem(image,title);let detailsSidebarPanelConstructors=[WebInspector.ResourceDetailsSidebarPanel,WebInspector.ProbeDetailsSidebarPanel];super(identifier||"network","network",tabBarItem,WebInspector.NetworkSidebarPanel,detailsSidebarPanelConstructors);}
static tabInfo()
{return{image:"Images/Network.svg",title:WebInspector.UIString("Network"),};}
static isTabAllowed()
{return!!window.NetworkAgent&&!!window.PageAgent;} 
get type()
{return WebInspector.NetworkTabContentView.Type;}
canShowRepresentedObject(representedObject)
{if(!(representedObject instanceof WebInspector.Resource))
return false;return!!this.navigationSidebarPanel.contentTreeOutline.getCachedTreeElement(representedObject);}
get supportsSplitContentBrowser()
{
return false;}};WebInspector.NetworkTabContentView.Type="network";WebInspector.NewTabContentView=class NewTabContentView extends WebInspector.TabContentView
{constructor(identifier)
{let{image,title}=WebInspector.NewTabContentView.tabInfo();let tabBarItem=new WebInspector.GeneralTabBarItem(image,title);tabBarItem.isDefaultTab=true;super(identifier||"new-tab","new-tab",tabBarItem);WebInspector.notifications.addEventListener(WebInspector.Notification.TabTypesChanged,this._updateShownTabs.bind(this));this._tabElementsByTabClass=new Map;this._updateShownTabs();}
static tabInfo()
{return{image:"Images/NewTab.svg",title:WebInspector.UIString("New Tab"),};}
static isEphemeral()
{return true;}
static shouldSaveTab()
{return false;} 
get type()
{return WebInspector.NewTabContentView.Type;}
shown()
{WebInspector.tabBrowser.tabBar.addEventListener(WebInspector.TabBar.Event.TabBarItemAdded,this._updateTabItems,this);WebInspector.tabBrowser.tabBar.addEventListener(WebInspector.TabBar.Event.TabBarItemRemoved,this._updateTabItems,this);this._updateTabItems();}
hidden()
{WebInspector.tabBrowser.tabBar.removeEventListener(null,null,this);}
get supportsSplitContentBrowser()
{
return false;}
layout()
{this._tabElementsByTabClass.clear();this.element.removeChildren();for(let tabClass of this._shownTabClasses){let tabItemElement=document.createElement("div");tabItemElement.classList.add("tab-item");tabItemElement.addEventListener("click",this._createNewTabWithType.bind(this,tabClass.Type));tabItemElement[WebInspector.NewTabContentView.TypeSymbol]=tabClass.Type;let boxElement=tabItemElement.appendChild(document.createElement("div"));boxElement.classList.add("box");let info=tabClass.tabInfo();let imageElement=boxElement.appendChild(document.createElement("img"));imageElement.src=info.image;let labelElement=tabItemElement.appendChild(document.createElement("label"));labelElement.textContent=info.title;this.element.appendChild(tabItemElement);this._tabElementsByTabClass.set(tabClass,tabItemElement);}
this._updateTabItems();} 
_createNewTabWithType(tabType,event)
{if(!WebInspector.isNewTabWithTypeAllowed(tabType))
return;const canCreateAdditionalTabs=this._allowableTabTypes().length>1;const options={referencedView:this,shouldReplaceTab:!canCreateAdditionalTabs||!WebInspector.modifierKeys.metaKey,shouldShowNewTab:!WebInspector.modifierKeys.metaKey};WebInspector.createNewTabWithType(tabType,options);}
_updateShownTabs()
{let allTabClasses=Array.from(WebInspector.knownTabClasses());let allowedTabClasses=allTabClasses.filter((tabClass)=>tabClass.isTabAllowed()&&!tabClass.isEphemeral());allowedTabClasses.sort((a,b)=>a.tabInfo().title.extendedLocaleCompare(b.tabInfo().title));if(Array.shallowEqual(this._shownTabClasses,allowedTabClasses))
return;this._shownTabClasses=allowedTabClasses;this.needsLayout();}
_allowableTabTypes()
{let tabTypes=this._shownTabClasses.map((tabClass)=>tabClass.Type);return tabTypes.filter((type)=>WebInspector.isNewTabWithTypeAllowed(type));}
_updateTabItems()
{for(let[tabClass,tabItemElement]of this._tabElementsByTabClass.entries()){let allowed=WebInspector.isNewTabWithTypeAllowed(tabClass.Type);tabItemElement.classList.toggle(WebInspector.NewTabContentView.DisabledStyleClassName,!allowed);}}};WebInspector.NewTabContentView.Type="new-tab";WebInspector.NewTabContentView.TypeSymbol=Symbol("type");WebInspector.NewTabContentView.TabItemStyleClassName="tab-item";WebInspector.NewTabContentView.DisabledStyleClassName="disabled";WebInspector.ObjectTreeBaseTreeElement=class ObjectTreeBaseTreeElement extends WebInspector.GeneralTreeElement
{constructor(representedObject,propertyPath,property)
{super(null,null,null,representedObject,false);this._property=property;this._propertyPath=propertyPath;this.toggleOnClick=true;this.selectable=false;this.tooltipHandledSeparately=true;} 
get property()
{return this._property;}
get propertyPath()
{return this._propertyPath;} 
resolvedValue()
{if(this._getterValue)
return this._getterValue;if(this._property.hasValue())
return this._property.value;return null;}
resolvedValuePropertyPath()
{if(this._getterValue)
return this._propertyPath.appendPropertyDescriptor(this._getterValue,this._property,WebInspector.PropertyPath.Type.Value);if(this._property.hasValue())
return this._propertyPath.appendPropertyDescriptor(this._property.value,this._property,WebInspector.PropertyPath.Type.Value);return null;}
thisPropertyPath()
{return this._propertyPath.appendPropertyDescriptor(null,this._property,this.propertyPathType());}
hadError()
{return this._property.wasThrown||this._getterHadError;}
propertyPathType()
{if(this._getterValue||this._property.hasValue())
return WebInspector.PropertyPath.Type.Value;if(this._property.hasGetter())
return WebInspector.PropertyPath.Type.Getter;if(this._property.hasSetter())
return WebInspector.PropertyPath.Type.Setter;return WebInspector.PropertyPath.Type.Value;}
propertyPathString(propertyPath)
{if(propertyPath.isFullPathImpossible())
return WebInspector.UIString("Unable to determine path to property from root");return propertyPath.displayPath(this.propertyPathType());}
createGetterElement(interactive)
{var getterElement=document.createElement("img");getterElement.className="getter";if(!interactive){getterElement.classList.add("disabled");getterElement.title=WebInspector.UIString("Getter");return getterElement;}
getterElement.title=WebInspector.UIString("Invoke getter");getterElement.addEventListener("click",(event)=>{event.stopPropagation();var lastNonPrototypeObject=this._propertyPath.lastNonPrototypeObject;var getterObject=this._property.get;lastNonPrototypeObject.invokeGetter(getterObject,(error,result,wasThrown)=>{this._getterHadError=!!(error||wasThrown);this._getterValue=result;if(this.invokedGetter&&typeof this.invokedGetter==="function")
this.invokedGetter();});});return getterElement;}
createSetterElement(interactive)
{var setterElement=document.createElement("img");setterElement.className="setter";setterElement.title=WebInspector.UIString("Setter");if(!interactive)
setterElement.classList.add("disabled");return setterElement;}
populateContextMenu(contextMenu,event)
{if(event.__addedObjectPreviewContextMenuItems)
return;if(event.__addedObjectTreeContextMenuItems)
return;event.__addedObjectTreeContextMenuItems=true;if(typeof this.treeOutline.objectTreeElementAddContextMenuItems==="function"){this.treeOutline.objectTreeElementAddContextMenuItems(this,contextMenu);if(!contextMenu.isEmpty())
contextMenu.appendSeparator();}
let resolvedValue=this.resolvedValue();if(!resolvedValue)
return;if(this._property&&this._property.symbol)
contextMenu.appendItem(WebInspector.UIString("Log Symbol"),this._logSymbolProperty.bind(this));contextMenu.appendItem(WebInspector.UIString("Log Value"),this._logValue.bind(this));let propertyPath=this.resolvedValuePropertyPath();if(propertyPath&&!propertyPath.isFullPathImpossible()){contextMenu.appendItem(WebInspector.UIString("Copy Path to Property"),()=>{InspectorFrontendHost.copyText(propertyPath.displayPath(WebInspector.PropertyPath.Type.Value));});}
contextMenu.appendSeparator();this._appendMenusItemsForObject(contextMenu,resolvedValue);super.populateContextMenu(contextMenu,event);} 
_logSymbolProperty()
{var symbol=this._property.symbol;if(!symbol)
return;var text=WebInspector.UIString("Selected Symbol");WebInspector.consoleLogViewController.appendImmediateExecutionWithResult(text,symbol,true);}
_logValue(value)
{var resolvedValue=value||this.resolvedValue();if(!resolvedValue)
return;var propertyPath=this.resolvedValuePropertyPath();var isImpossible=propertyPath.isFullPathImpossible();var text=isImpossible?WebInspector.UIString("Selected Value"):propertyPath.displayPath(this.propertyPathType());if(!isImpossible)
WebInspector.quickConsole.prompt.pushHistoryItem(text);WebInspector.consoleLogViewController.appendImmediateExecutionWithResult(text,resolvedValue,isImpossible);}
_appendMenusItemsForObject(contextMenu,resolvedValue)
{if(resolvedValue.type==="function"){if(!isFunctionStringNativeCode(resolvedValue.description)){contextMenu.appendItem(WebInspector.UIString("Jump to Definition"),function(){resolvedValue.target.DebuggerAgent.getFunctionDetails(resolvedValue.objectId,function(error,response){if(error)
return;let location=response.location;let sourceCode=WebInspector.debuggerManager.scriptForIdentifier(location.scriptId,resolvedValue.target);if(!sourceCode)
return;let sourceCodeLocation=sourceCode.createSourceCodeLocation(location.lineNumber,location.columnNumber||0);const options={ignoreNetworkTab:true,ignoreSearchTab:true,};WebInspector.showSourceCodeLocation(sourceCodeLocation,options);});});}
return;}
if(resolvedValue.subtype==="node"){contextMenu.appendItem(WebInspector.UIString("Copy as HTML"),function(){resolvedValue.pushNodeToFrontend(function(nodeId){WebInspector.domTreeManager.nodeForId(nodeId).copyNode();});});contextMenu.appendItem(WebInspector.UIString("Scroll Into View"),function(){function scrollIntoView(){this.scrollIntoViewIfNeeded(true);}
resolvedValue.callFunction(scrollIntoView,undefined,false,function(){});});contextMenu.appendSeparator();contextMenu.appendItem(WebInspector.UIString("Reveal in DOM Tree"),function(){resolvedValue.pushNodeToFrontend(function(nodeId){WebInspector.domTreeManager.inspectElement(nodeId);});});return;}}};WebInspector.SourceCodeTreeElement=class SourceCodeTreeElement extends WebInspector.FolderizedTreeElement
{constructor(sourceCode,classNames,title,subtitle,representedObject,hasChildren)
{super(classNames,title,subtitle,representedObject||sourceCode,hasChildren);this._updateSourceCode(sourceCode);} 
updateSourceMapResources()
{if(!this.treeOutline||!this.treeOutline.includeSourceMapResourceChildren)
return;this.hasChildren=!!this._sourceCode.sourceMaps.length;this.shouldRefreshChildren=this.hasChildren;if(!this.hasChildren)
this.removeChildren();} 
onattach()
{super.onattach();this.updateSourceMapResources();}
onpopulate()
{if(!this.treeOutline||!this.treeOutline.includeSourceMapResourceChildren)
return;if(!this.hasChildren||!this.shouldRefreshChildren)
return;this.shouldRefreshChildren=false;this.removeChildren();function combineFolderChain(topFolder,bottomFolder)
{var components=[];for(var currentFolder=bottomFolder;currentFolder!==topFolder;currentFolder=currentFolder.parent)
components.push(currentFolder.mainTitle);components.push(topFolder.mainTitle);var folderName=components.reverse().join("/");var newFolder=new WebInspector.FolderTreeElement(folderName);var folderIndex=topFolder.parent.children.indexOf(topFolder);topFolder.parent.insertChild(newFolder,folderIndex);topFolder.parent.removeChild(topFolder);var children=bottomFolder.children;bottomFolder.removeChildren();for(var i=0;i<children.length;++i)
newFolder.appendChild(children[i]);}
function findAndCombineFolderChains(treeElement,previousSingleTreeElement)
{if(!(treeElement instanceof WebInspector.FolderTreeElement)){if(previousSingleTreeElement&&previousSingleTreeElement!==treeElement.parent)
combineFolderChain(previousSingleTreeElement,treeElement.parent);return;}
if(previousSingleTreeElement&&treeElement.children.length!==1){combineFolderChain(previousSingleTreeElement,treeElement);previousSingleTreeElement=null;}
if(!previousSingleTreeElement&&treeElement.children.length===1)
previousSingleTreeElement=treeElement;for(var i=0;i<treeElement.children.length;++i)
findAndCombineFolderChains(treeElement.children[i],previousSingleTreeElement);}
var sourceMaps=this._sourceCode.sourceMaps;for(var i=0;i<sourceMaps.length;++i){var sourceMap=sourceMaps[i];for(var j=0;j<sourceMap.resources.length;++j){var sourceMapResource=sourceMap.resources[j];var relativeSubpath=sourceMapResource.sourceMapDisplaySubpath;var folderTreeElement=this.createFoldersAsNeededForSubpath(relativeSubpath);var sourceMapTreeElement=new WebInspector.SourceMapResourceTreeElement(sourceMapResource);folderTreeElement.insertChild(sourceMapTreeElement,insertionIndexForObjectInListSortedByFunction(sourceMapTreeElement,folderTreeElement.children,WebInspector.ResourceTreeElement.compareFolderAndResourceTreeElements));}}
for(var i=0;i<this.children.length;++i)
findAndCombineFolderChains(this.children[i],null);} 
createFoldersAsNeededForSubpath(subpath)
{if(!subpath)
return this;var components=subpath.split("/");if(components.length===1)
return this;if(!this._subpathFolderTreeElementMap)
this._subpathFolderTreeElementMap={};var currentPath="";var currentFolderTreeElement=this;for(var i=0;i<components.length-1;++i){var componentName=components[i];currentPath+=(i?"/":"")+componentName;var cachedFolder=this._subpathFolderTreeElementMap[currentPath];if(cachedFolder){currentFolderTreeElement=cachedFolder;continue;}
var newFolder=new WebInspector.FolderTreeElement(componentName);newFolder.__path=currentPath;this._subpathFolderTreeElementMap[currentPath]=newFolder;var index=insertionIndexForObjectInListSortedByFunction(newFolder,currentFolderTreeElement.children,WebInspector.ResourceTreeElement.compareFolderAndResourceTreeElements);currentFolderTreeElement.insertChild(newFolder,index);currentFolderTreeElement=newFolder;}
return currentFolderTreeElement;}
descendantResourceTreeElementTypeDidChange(childTreeElement,oldType)
{let parentTreeElement=childTreeElement.parent;let wasParentExpanded=parentTreeElement.expanded;let wasSelected=childTreeElement.selected;parentTreeElement.removeChild(childTreeElement,true,true);parentTreeElement.insertChild(childTreeElement,insertionIndexForObjectInListSortedByFunction(childTreeElement,parentTreeElement.children,WebInspector.ResourceTreeElement.compareFolderAndResourceTreeElements));if(wasParentExpanded)
parentTreeElement.expand();if(wasSelected)
childTreeElement.revealAndSelect(true,false,true,true);}
_updateSourceCode(sourceCode)
{if(this._sourceCode===sourceCode)
return;if(this._sourceCode)
this._sourceCode.removeEventListener(WebInspector.SourceCode.Event.SourceMapAdded,this.updateSourceMapResources,this);this._sourceCode=sourceCode;this._sourceCode.addEventListener(WebInspector.SourceCode.Event.SourceMapAdded,this.updateSourceMapResources,this);this.updateSourceMapResources();}};WebInspector.StorageTreeElement=class StorageTreeElement extends WebInspector.GeneralTreeElement
{constructor(classNames,title,representedObject)
{super(classNames,title,null,representedObject,false);this.flattened=false;} 
get flattened()
{return this._flattened;}
set flattened(flattened)
{if(this._flattened===flattened)
return;this._flattened=flattened;if(!this._flattened){this.mainTitle=this.name;this.subtitle=this.secondaryName;this._updateChildrenTitles();return;}
this.mainTitle=this.categoryName;this.subtitle=this.name;this._updateChildrenTitles();} 
_updateChildrenTitles()
{for(var i=0;i<this.children.length;++i){if(typeof this.children[i].updateTitles==="function")
this.children[i].updateTitles();}}};WebInspector.TimelineDataGridNodePathComponent=class TimelineDataGridNodePathComponent extends WebInspector.HierarchicalPathComponent
{constructor(timelineDataGridNode,representedObject)
{super(timelineDataGridNode.displayName(),timelineDataGridNode.iconClassNames(),representedObject||timelineDataGridNode.record);this._timelineDataGridNode=timelineDataGridNode;} 
get timelineDataGridNode()
{return this._timelineDataGridNode;}
get previousSibling()
{let previousSibling=this._timelineDataGridNode.previousSibling;while(previousSibling&&previousSibling.hidden)
previousSibling=previousSibling.previousSibling;if(!previousSibling)
return null;return new WebInspector.TimelineDataGridNodePathComponent(previousSibling);}
get nextSibling()
{let nextSibling=this._timelineDataGridNode.nextSibling;while(nextSibling&&nextSibling.hidden)
nextSibling=nextSibling.nextSibling;if(!nextSibling)
return null;return new WebInspector.TimelineDataGridNodePathComponent(nextSibling);}};WebInspector.TimelineOverview=class TimelineOverview extends WebInspector.View
{constructor(timelineRecording,delegate)
{super();this._timelinesViewModeSettings=this._createViewModeSettings(WebInspector.TimelineOverview.ViewMode.Timelines,WebInspector.TimelineOverview.MinimumDurationPerPixel,WebInspector.TimelineOverview.MaximumDurationPerPixel,0.01,0,15);this._instrumentTypes=WebInspector.TimelineManager.availableTimelineTypes();if(WebInspector.FPSInstrument.supported()){let minimumDurationPerPixel=1/WebInspector.TimelineRecordFrame.MaximumWidthPixels;let maximumDurationPerPixel=1/WebInspector.TimelineRecordFrame.MinimumWidthPixels;this._renderingFramesViewModeSettings=this._createViewModeSettings(WebInspector.TimelineOverview.ViewMode.RenderingFrames,minimumDurationPerPixel,maximumDurationPerPixel,minimumDurationPerPixel,0,100);}
this._recording=timelineRecording;this._recording.addEventListener(WebInspector.TimelineRecording.Event.InstrumentAdded,this._instrumentAdded,this);this._recording.addEventListener(WebInspector.TimelineRecording.Event.InstrumentRemoved,this._instrumentRemoved,this);this._recording.addEventListener(WebInspector.TimelineRecording.Event.MarkerAdded,this._markerAdded,this);this._recording.addEventListener(WebInspector.TimelineRecording.Event.Reset,this._recordingReset,this);this._delegate=delegate;this.element.classList.add("timeline-overview");this._updateWheelAndGestureHandlers();this._graphsContainerView=new WebInspector.View;this._graphsContainerView.element.classList.add("graphs-container");this.addSubview(this._graphsContainerView);this._overviewGraphsByTypeMap=new Map;this._editInstrumentsButton=new WebInspector.ActivateButtonNavigationItem("toggle-edit-instruments",WebInspector.UIString("Edit configuration"),WebInspector.UIString("Save configuration"));this._editInstrumentsButton.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,this._toggleEditingInstruments,this);this._editingInstruments=false;this._updateEditInstrumentsButton();let instrumentsNavigationBar=new WebInspector.NavigationBar;instrumentsNavigationBar.element.classList.add("timelines");instrumentsNavigationBar.addNavigationItem(new WebInspector.FlexibleSpaceNavigationItem);instrumentsNavigationBar.addNavigationItem(this._editInstrumentsButton);this.addSubview(instrumentsNavigationBar);this._timelinesTreeOutline=new WebInspector.TreeOutline;this._timelinesTreeOutline.element.classList.add("timelines");this._timelinesTreeOutline.disclosureButtons=false;this._timelinesTreeOutline.large=true;this._timelinesTreeOutline.addEventListener(WebInspector.TreeOutline.Event.SelectionDidChange,this._timelinesTreeSelectionDidChange,this);this.element.appendChild(this._timelinesTreeOutline.element);this._treeElementsByTypeMap=new Map;this._timelineRuler=new WebInspector.TimelineRuler;this._timelineRuler.allowsClippedLabels=true;this._timelineRuler.allowsTimeRangeSelection=true;this._timelineRuler.element.addEventListener("mousedown",this._timelineRulerMouseDown.bind(this));this._timelineRuler.element.addEventListener("click",this._timelineRulerMouseClicked.bind(this));this._timelineRuler.addEventListener(WebInspector.TimelineRuler.Event.TimeRangeSelectionChanged,this._timeRangeSelectionChanged,this);this.addSubview(this._timelineRuler);this._currentTimeMarker=new WebInspector.TimelineMarker(0,WebInspector.TimelineMarker.Type.CurrentTime);this._timelineRuler.addMarker(this._currentTimeMarker);this._scrollContainerElement=document.createElement("div");this._scrollContainerElement.classList.add("scroll-container");this._scrollContainerElement.addEventListener("scroll",this._handleScrollEvent.bind(this));this.element.appendChild(this._scrollContainerElement);this._scrollWidthSizer=document.createElement("div");this._scrollWidthSizer.classList.add("scroll-width-sizer");this._scrollContainerElement.appendChild(this._scrollWidthSizer);this._startTime=0;this._currentTime=0;this._revealCurrentTime=false;this._endTime=0;this._pixelAlignDuration=false;this._mouseWheelDelta=0;this._cachedScrollContainerWidth=NaN;this._timelineRulerSelectionChanged=false;this._viewMode=WebInspector.TimelineOverview.ViewMode.Timelines;this._selectedTimeline=null;for(let instrument of this._recording.instruments)
this._instrumentAdded(instrument);if(!WebInspector.timelineManager.isCapturingPageReload())
this._resetSelection();this._viewModeDidChange();WebInspector.timelineManager.addEventListener(WebInspector.TimelineManager.Event.CapturingStarted,this._capturingStarted,this);WebInspector.timelineManager.addEventListener(WebInspector.TimelineManager.Event.CapturingStopped,this._capturingStopped,this);} 
get selectedTimeline()
{return this._selectedTimeline;}
set selectedTimeline(x)
{if(this._editingInstruments)
return;if(this._selectedTimeline===x)
return;this._selectedTimeline=x;if(this._selectedTimeline){let treeElement=this._treeElementsByTypeMap.get(this._selectedTimeline.type);let omitFocus=true;let wasSelectedByUser=false;treeElement.select(omitFocus,wasSelectedByUser);}else if(this._timelinesTreeOutline.selectedTreeElement)
this._timelinesTreeOutline.selectedTreeElement.deselect();}
get editingInstruments()
{return this._editingInstruments;}
get viewMode()
{return this._viewMode;}
set viewMode(x)
{if(this._editingInstruments)
return;if(this._viewMode===x)
return;this._viewMode=x;this._viewModeDidChange();}
get startTime()
{return this._startTime;}
set startTime(x)
{x=x||0;if(this._startTime===x)
return;if(this._viewMode!==WebInspector.TimelineOverview.ViewMode.RenderingFrames){let selectionOffset=this.selectionStartTime-this._startTime;this.selectionStartTime=selectionOffset+x;}
this._startTime=x;this.needsLayout();}
get currentTime()
{return this._currentTime;}
set currentTime(x)
{x=x||0;if(this._currentTime===x)
return;this._currentTime=x;this._revealCurrentTime=true;this.needsLayout();}
get secondsPerPixel()
{return this._currentSettings.durationPerPixelSetting.value;}
set secondsPerPixel(x)
{x=Math.min(this._currentSettings.maximumDurationPerPixel,Math.max(this._currentSettings.minimumDurationPerPixel,x));if(this.secondsPerPixel===x)
return;if(this._pixelAlignDuration){x=1/Math.round(1/x);if(this.secondsPerPixel===x)
return;}
this._currentSettings.durationPerPixelSetting.value=x;this.needsLayout();}
get pixelAlignDuration()
{return this._pixelAlignDuration;}
set pixelAlignDuration(x)
{if(this._pixelAlignDuration===x)
return;this._mouseWheelDelta=0;this._pixelAlignDuration=x;if(this._pixelAlignDuration)
this.secondsPerPixel=1/Math.round(1/this.secondsPerPixel);}
get endTime()
{return this._endTime;}
set endTime(x)
{x=x||0;if(this._endTime===x)
return;this._endTime=x;this.needsLayout();}
get scrollStartTime()
{return this._currentSettings.scrollStartTime;}
set scrollStartTime(x)
{x=x||0;if(this.scrollStartTime===x)
return;this._currentSettings.scrollStartTime=x;this.needsLayout();}
get scrollContainerWidth()
{return this._cachedScrollContainerWidth;}
get visibleDuration()
{if(isNaN(this._cachedScrollContainerWidth)){this._cachedScrollContainerWidth=this._scrollContainerElement.offsetWidth;if(!this._cachedScrollContainerWidth)
this._cachedScrollContainerWidth=NaN;}
return this._cachedScrollContainerWidth*this.secondsPerPixel;}
get selectionStartTime()
{return this._timelineRuler.selectionStartTime;}
set selectionStartTime(x)
{x=x||0;if(this._timelineRuler.selectionStartTime===x)
return;let selectionDuration=this.selectionDuration;this._timelineRuler.selectionStartTime=x;this._timelineRuler.selectionEndTime=x+selectionDuration;}
get selectionDuration()
{return this._timelineRuler.selectionEndTime-this._timelineRuler.selectionStartTime;}
set selectionDuration(x)
{x=Math.max(this._timelineRuler.minimumSelectionDuration,x);this._timelineRuler.selectionEndTime=this._timelineRuler.selectionStartTime+x;}
get height()
{let height=0;for(let overviewGraph of this._overviewGraphsByTypeMap.values()){if(overviewGraph.visible)
height+=overviewGraph.height;}
return height;}
get visible()
{return this._visible;}
shown()
{this._visible=true;for(let[type,overviewGraph]of this._overviewGraphsByTypeMap){if(this._canShowTimelineType(type))
overviewGraph.shown();}
this.updateLayout(WebInspector.View.LayoutReason.Resize);}
hidden()
{this._visible=false;for(let overviewGraph of this._overviewGraphsByTypeMap.values())
overviewGraph.hidden();}
reset()
{for(let overviewGraph of this._overviewGraphsByTypeMap.values())
overviewGraph.reset();this._mouseWheelDelta=0;this._resetSelection();}
revealMarker(marker)
{this.scrollStartTime=marker.time-(this.visibleDuration/2);}
recordWasFiltered(timeline,record,filtered)
{let overviewGraph=this._overviewGraphsByTypeMap.get(timeline.type);if(!overviewGraph)
return;overviewGraph.recordWasFiltered(record,filtered);}
selectRecord(timeline,record)
{let overviewGraph=this._overviewGraphsByTypeMap.get(timeline.type);if(!overviewGraph)
return;overviewGraph.selectedRecord=record;}
userSelectedRecord(record)
{if(this._delegate&&this._delegate.timelineOverviewUserSelectedRecord)
this._delegate.timelineOverviewUserSelectedRecord(this,record);}
updateLayoutIfNeeded(layoutReason)
{if(this.layoutPending){super.updateLayoutIfNeeded(layoutReason);return;}
this._timelineRuler.updateLayoutIfNeeded(layoutReason);for(let overviewGraph of this._overviewGraphsByTypeMap.values()){if(overviewGraph.visible)
overviewGraph.updateLayoutIfNeeded(layoutReason);}}
discontinuitiesInTimeRange(startTime,endTime)
{return this._recording.discontinuitiesInTimeRange(startTime,endTime);} 
get timelineRuler()
{return this._timelineRuler;}
layout()
{let startTime=this._startTime;let endTime=this._endTime;let currentTime=this._currentTime;if(this._viewMode===WebInspector.TimelineOverview.ViewMode.RenderingFrames){let renderingFramesTimeline=this._recording.timelines.get(WebInspector.TimelineRecord.Type.RenderingFrame);startTime=0;endTime=renderingFramesTimeline.records.length;currentTime=endTime;}
let duration=endTime-startTime;let newWidth=Math.ceil(duration/this.secondsPerPixel);this._updateElementWidth(this._scrollWidthSizer,newWidth);this._currentTimeMarker.time=currentTime;if(this._revealCurrentTime){this.revealMarker(this._currentTimeMarker);this._revealCurrentTime=false;}
const visibleDuration=this.visibleDuration;let scrollStartTime=Math.min(this.scrollStartTime,endTime-visibleDuration);scrollStartTime=Math.max(startTime,scrollStartTime);this._timelineRuler.zeroTime=startTime;this._timelineRuler.startTime=scrollStartTime;this._timelineRuler.secondsPerPixel=this.secondsPerPixel;if(!this._dontUpdateScrollLeft){this._ignoreNextScrollEvent=true;let scrollLeft=Math.ceil((scrollStartTime-startTime)/this.secondsPerPixel);if(scrollLeft)
this._scrollContainerElement.scrollLeft=scrollLeft;}
for(let overviewGraph of this._overviewGraphsByTypeMap.values()){if(!overviewGraph.visible)
continue;overviewGraph.zeroTime=startTime;overviewGraph.startTime=scrollStartTime;overviewGraph.currentTime=currentTime;overviewGraph.endTime=scrollStartTime+visibleDuration;}}
sizeDidChange()
{this._cachedScrollContainerWidth=NaN;} 
_updateElementWidth(element,newWidth)
{var currentWidth=parseInt(element.style.width);if(currentWidth!==newWidth)
element.style.width=newWidth+"px";}
_handleScrollEvent(event)
{if(this._ignoreNextScrollEvent){this._ignoreNextScrollEvent=false;return;}
this._dontUpdateScrollLeft=true;let scrollOffset=this._scrollContainerElement.scrollLeft;if(WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL)
this.scrollStartTime=this._startTime-(scrollOffset*this.secondsPerPixel);else
this.scrollStartTime=this._startTime+(scrollOffset*this.secondsPerPixel);this.updateLayoutIfNeeded();this._dontUpdateScrollLeft=false;}
_handleWheelEvent(event)
{if(event.__cloned)
return;if(this._handlingGesture)
return;
if(Math.abs(event.deltaX)>=Math.abs(event.deltaY)*0.5){let newWheelEvent=new event.constructor(event.type,event);newWheelEvent.__cloned=true;this._scrollContainerElement.dispatchEvent(newWheelEvent);return;}
let mouseOffset=event.pageX-this._graphsContainerView.element.totalOffsetLeft;let mousePositionTime=this._currentSettings.scrollStartTime+(mouseOffset*this.secondsPerPixel);let deviceDirection=event.webkitDirectionInvertedFromDevice?1:-1;let delta=event.deltaY*(this.secondsPerPixel/WebInspector.TimelineOverview.ScrollDeltaDenominator)*deviceDirection;if(this._pixelAlignDuration&&(delta<0&&this._mouseWheelDelta>=0||delta>=0&&this._mouseWheelDelta<0))
this._mouseWheelDelta=0;let previousDurationPerPixel=this.secondsPerPixel;this._mouseWheelDelta+=delta;this.secondsPerPixel+=this._mouseWheelDelta;if(this.secondsPerPixel===this._currentSettings.minimumDurationPerPixel&&delta<0||this.secondsPerPixel===this._currentSettings.maximumDurationPerPixel&&delta>=0)
this._mouseWheelDelta=0;else
this._mouseWheelDelta=previousDurationPerPixel+this._mouseWheelDelta-this.secondsPerPixel;this.scrollStartTime=mousePositionTime-(mouseOffset*this.secondsPerPixel);event.preventDefault();event.stopPropagation();}
_handleGestureStart(event)
{if(this._handlingGesture){ return;}
let mouseOffset=event.pageX-this._graphsContainerView.element.totalOffsetLeft;let mousePositionTime=this._currentSettings.scrollStartTime+(mouseOffset*this.secondsPerPixel);this._handlingGesture=true;this._gestureStartStartTime=mousePositionTime;this._gestureStartDurationPerPixel=this.secondsPerPixel;event.preventDefault();event.stopPropagation();}
_handleGestureChange(event)
{let scale=Math.max(1/5,event.scale);let mouseOffset=event.pageX-this._graphsContainerView.element.totalOffsetLeft;let newSecondsPerPixel=this._gestureStartDurationPerPixel/scale;this.secondsPerPixel=newSecondsPerPixel;this.scrollStartTime=this._gestureStartStartTime-(mouseOffset*this.secondsPerPixel);event.preventDefault();event.stopPropagation();}
_handleGestureEnd(event)
{this._handlingGesture=false;this._gestureStartStartTime=NaN;this._gestureStartDurationPerPixel=NaN;}
_instrumentAdded(instrumentOrEvent)
{let instrument=instrumentOrEvent instanceof WebInspector.Instrument?instrumentOrEvent:instrumentOrEvent.data.instrument;let timeline=this._recording.timelineForInstrument(instrument);let treeElement=new WebInspector.TimelineTreeElement(timeline);let insertionIndex=insertionIndexForObjectInListSortedByFunction(treeElement,this._timelinesTreeOutline.children,this._compareTimelineTreeElements.bind(this));this._timelinesTreeOutline.insertChild(treeElement,insertionIndex);this._treeElementsByTypeMap.set(timeline.type,treeElement);let overviewGraph=WebInspector.TimelineOverviewGraph.createForTimeline(timeline,this);overviewGraph.addEventListener(WebInspector.TimelineOverviewGraph.Event.RecordSelected,this._recordSelected,this);this._overviewGraphsByTypeMap.set(timeline.type,overviewGraph);this._graphsContainerView.insertSubviewBefore(overviewGraph,this._graphsContainerView.subviews[insertionIndex]);treeElement.element.style.height=overviewGraph.height+"px";if(!this._canShowTimelineType(timeline.type)){overviewGraph.hidden();treeElement.hidden=true;}}
_instrumentRemoved(event)
{let instrument=event.data.instrument;let timeline=this._recording.timelineForInstrument(instrument);let overviewGraph=this._overviewGraphsByTypeMap.get(timeline.type);let treeElement=this._treeElementsByTypeMap.get(timeline.type);let shouldSuppressOnDeselect=false;let shouldSuppressSelectSibling=true;this._timelinesTreeOutline.removeChild(treeElement,shouldSuppressOnDeselect,shouldSuppressSelectSibling);overviewGraph.removeEventListener(WebInspector.TimelineOverviewGraph.Event.RecordSelected,this._recordSelected,this);this._graphsContainerView.removeSubview(overviewGraph);this._overviewGraphsByTypeMap.delete(timeline.type);this._treeElementsByTypeMap.delete(timeline.type);}
_markerAdded(event)
{this._timelineRuler.addMarker(event.data.marker);}
_timelineRulerMouseDown(event)
{this._timelineRulerSelectionChanged=false;}
_timelineRulerMouseClicked(event)
{if(this._timelineRulerSelectionChanged)
return;for(let overviewGraph of this._overviewGraphsByTypeMap.values()){let graphRect=overviewGraph.element.getBoundingClientRect();if(!(event.pageX>=graphRect.left&&event.pageX<=graphRect.right&&event.pageY>=graphRect.top&&event.pageY<=graphRect.bottom))
continue;let newClickEvent=new event.constructor(event.type,event);overviewGraph.element.dispatchEvent(newClickEvent);return;}}
_timeRangeSelectionChanged(event)
{this._timelineRulerSelectionChanged=true;let startTime=this._viewMode===WebInspector.TimelineOverview.ViewMode.Timelines?this._startTime:0;this._currentSettings.selectionStartValueSetting.value=this.selectionStartTime-startTime;this._currentSettings.selectionDurationSetting.value=this.selectionDuration;this.dispatchEventToListeners(WebInspector.TimelineOverview.Event.TimeRangeSelectionChanged);}
_recordSelected(event)
{for(let[type,overviewGraph]of this._overviewGraphsByTypeMap){if(overviewGraph!==event.target)
continue;let timeline=this._recording.timelines.get(type);this.dispatchEventToListeners(WebInspector.TimelineOverview.Event.RecordSelected,{timeline,record:event.data.record});return;}}
_resetSelection()
{function reset(settings)
{settings.durationPerPixelSetting.reset();settings.selectionStartValueSetting.reset();settings.selectionDurationSetting.reset();}
reset(this._timelinesViewModeSettings);if(this._renderingFramesViewModeSettings)
reset(this._renderingFramesViewModeSettings);this.secondsPerPixel=this._currentSettings.durationPerPixelSetting.value;this.selectionStartTime=this._currentSettings.selectionStartValueSetting.value;this.selectionDuration=this._currentSettings.selectionDurationSetting.value;}
_recordingReset(event)
{this._timelineRuler.clearMarkers();this._timelineRuler.addMarker(this._currentTimeMarker);}
_canShowTimelineType(type)
{let timelineViewMode=WebInspector.TimelineOverview.ViewMode.Timelines;if(type===WebInspector.TimelineRecord.Type.RenderingFrame)
timelineViewMode=WebInspector.TimelineOverview.ViewMode.RenderingFrames;return timelineViewMode===this._viewMode;}
_viewModeDidChange()
{let startTime=0;let isRenderingFramesMode=this._viewMode===WebInspector.TimelineOverview.ViewMode.RenderingFrames;if(isRenderingFramesMode){this._timelineRuler.minimumSelectionDuration=1;this._timelineRuler.snapInterval=1;this._timelineRuler.formatLabelCallback=(value)=>value.maxDecimals(0).toLocaleString();}else{this._timelineRuler.minimumSelectionDuration=0.01;this._timelineRuler.snapInterval=NaN;this._timelineRuler.formatLabelCallback=null;startTime=this._startTime;}
this.pixelAlignDuration=isRenderingFramesMode;this.selectionStartTime=this._currentSettings.selectionStartValueSetting.value+startTime;this.selectionDuration=this._currentSettings.selectionDurationSetting.value;for(let[type,overviewGraph]of this._overviewGraphsByTypeMap){let treeElement=this._treeElementsByTypeMap.get(type);treeElement.hidden=!this._canShowTimelineType(type);if(treeElement.hidden)
overviewGraph.hidden();else
overviewGraph.shown();}
this.element.classList.toggle("frames",isRenderingFramesMode);this.updateLayout(WebInspector.View.LayoutReason.Resize);}
_createViewModeSettings(viewMode,minimumDurationPerPixel,maximumDurationPerPixel,durationPerPixel,selectionStartValue,selectionDuration)
{durationPerPixel=Math.min(maximumDurationPerPixel,Math.max(minimumDurationPerPixel,durationPerPixel));let durationPerPixelSetting=new WebInspector.Setting(viewMode+"-duration-per-pixel",durationPerPixel);let selectionStartValueSetting=new WebInspector.Setting(viewMode+"-selection-start-value",selectionStartValue);let selectionDurationSetting=new WebInspector.Setting(viewMode+"-selection-duration",selectionDuration);return{scrollStartTime:0,minimumDurationPerPixel,maximumDurationPerPixel,durationPerPixelSetting,selectionStartValueSetting,selectionDurationSetting};}
get _currentSettings()
{return this._viewMode===WebInspector.TimelineOverview.ViewMode.Timelines?this._timelinesViewModeSettings:this._renderingFramesViewModeSettings;}
_timelinesTreeSelectionDidChange(event)
{function updateGraphSelectedState(timeline,selected)
{let overviewGraph=this._overviewGraphsByTypeMap.get(timeline.type);overviewGraph.selected=selected;}
let selectedTreeElement=event.data.selectedElement;let deselectedTreeElement=event.data.deselectedElement;let timeline=null;if(selectedTreeElement){timeline=selectedTreeElement.representedObject;updateGraphSelectedState.call(this,timeline,true);}
if(deselectedTreeElement)
updateGraphSelectedState.call(this,deselectedTreeElement.representedObject,false);this._selectedTimeline=timeline;this.dispatchEventToListeners(WebInspector.TimelineOverview.Event.TimelineSelected);}
_toggleEditingInstruments(event)
{if(this._editingInstruments)
this._stopEditingInstruments();else
this._startEditingInstruments();}
_editingInstrumentsDidChange()
{this.element.classList.toggle(WebInspector.TimelineOverview.EditInstrumentsStyleClassName,this._editingInstruments);this._timelineRuler.enabled=!this._editingInstruments;this._updateWheelAndGestureHandlers();this._updateEditInstrumentsButton();this.dispatchEventToListeners(WebInspector.TimelineOverview.Event.EditingInstrumentsDidChange);}
_updateEditInstrumentsButton()
{let newLabel=this._editingInstruments?WebInspector.UIString("Done"):WebInspector.UIString("Edit");this._editInstrumentsButton.label=newLabel;this._editInstrumentsButton.activated=this._editingInstruments;this._editInstrumentsButton.enabled=!WebInspector.timelineManager.isCapturing();}
_updateWheelAndGestureHandlers()
{if(this._editingInstruments){this.element.removeEventListener("wheel",this._handleWheelEventListener);this.element.removeEventListener("gesturestart",this._handleGestureStartEventListener);this.element.removeEventListener("gesturechange",this._handleGestureChangeEventListener);this.element.removeEventListener("gestureend",this._handleGestureEndEventListener);this._handleWheelEventListener=null;this._handleGestureStartEventListener=null;this._handleGestureChangeEventListener=null;this._handleGestureEndEventListener=null;}else{this._handleWheelEventListener=this._handleWheelEvent.bind(this);this._handleGestureStartEventListener=this._handleGestureStart.bind(this);this._handleGestureChangeEventListener=this._handleGestureChange.bind(this);this._handleGestureEndEventListener=this._handleGestureEnd.bind(this);this.element.addEventListener("wheel",this._handleWheelEventListener);this.element.addEventListener("gesturestart",this._handleGestureStartEventListener);this.element.addEventListener("gesturechange",this._handleGestureChangeEventListener);this.element.addEventListener("gestureend",this._handleGestureEndEventListener);}}
_startEditingInstruments()
{if(this._editingInstruments)
return;this._editingInstruments=true;for(let type of this._instrumentTypes){let treeElement=this._treeElementsByTypeMap.get(type);if(!treeElement){let timeline=this._recording.timelines.get(type);const placeholder=true;treeElement=new WebInspector.TimelineTreeElement(timeline,placeholder);let insertionIndex=insertionIndexForObjectInListSortedByFunction(treeElement,this._timelinesTreeOutline.children,this._compareTimelineTreeElements.bind(this));this._timelinesTreeOutline.insertChild(treeElement,insertionIndex);let placeholderGraph=new WebInspector.View;placeholderGraph.element.classList.add("timeline-overview-graph");treeElement[WebInspector.TimelineOverview.PlaceholderOverviewGraph]=placeholderGraph;this._graphsContainerView.insertSubviewBefore(placeholderGraph,this._graphsContainerView.subviews[insertionIndex]);}
treeElement.editing=true;treeElement.addEventListener(WebInspector.TimelineTreeElement.Event.EnabledDidChange,this._timelineTreeElementEnabledDidChange,this);}
this._editingInstrumentsDidChange();}
_stopEditingInstruments()
{if(!this._editingInstruments)
return;this._editingInstruments=false;let instruments=this._recording.instruments;for(let treeElement of this._treeElementsByTypeMap.values()){if(treeElement.status.checked){treeElement.editing=false;treeElement.removeEventListener(WebInspector.TimelineTreeElement.Event.EnabledDidChange,this._timelineTreeElementEnabledDidChange,this);continue;}
let timelineInstrument=instruments.find((instrument)=>instrument.timelineRecordType===treeElement.representedObject.type);this._recording.removeInstrument(timelineInstrument);}
let placeholderTreeElements=this._timelinesTreeOutline.children.filter((treeElement)=>treeElement.placeholder);for(let treeElement of placeholderTreeElements){this._timelinesTreeOutline.removeChild(treeElement);let placeholderGraph=treeElement[WebInspector.TimelineOverview.PlaceholderOverviewGraph];this._graphsContainerView.removeSubview(placeholderGraph);if(treeElement.status.checked){let instrument=WebInspector.Instrument.createForTimelineType(treeElement.representedObject.type);this._recording.addInstrument(instrument);}}
let instrumentTypes=instruments.map((instrument)=>instrument.timelineRecordType);WebInspector.timelineManager.enabledTimelineTypes=instrumentTypes;this._editingInstrumentsDidChange();}
_capturingStarted()
{this._editInstrumentsButton.enabled=false;this._stopEditingInstruments();}
_capturingStopped()
{this._editInstrumentsButton.enabled=true;}
_compareTimelineTreeElements(a,b)
{let aTimelineType=a.representedObject.type;let bTimelineType=b.representedObject.type;if(aTimelineType===WebInspector.TimelineRecord.Type.RenderingFrame)
return 1;if(bTimelineType===WebInspector.TimelineRecord.Type.RenderingFrame)
return-1;if(a.placeholder!==b.placeholder)
return a.placeholder?1:-1;let aTimelineIndex=this._instrumentTypes.indexOf(aTimelineType);let bTimelineIndex=this._instrumentTypes.indexOf(bTimelineType);return aTimelineIndex-bTimelineIndex;}
_timelineTreeElementEnabledDidChange(event)
{let enabled=this._timelinesTreeOutline.children.some((treeElement)=>{let timelineType=treeElement.representedObject.type;return this._canShowTimelineType(timelineType)&&treeElement.status.checked;});this._editInstrumentsButton.enabled=enabled;}};WebInspector.TimelineOverview.PlaceholderOverviewGraph=Symbol("placeholder-overview-graph");WebInspector.TimelineOverview.ScrollDeltaDenominator=500;WebInspector.TimelineOverview.EditInstrumentsStyleClassName="edit-instruments";WebInspector.TimelineOverview.MinimumDurationPerPixel=0.0001;WebInspector.TimelineOverview.MaximumDurationPerPixel=60;WebInspector.TimelineOverview.ViewMode={Timelines:"timeline-overview-view-mode-timelines",RenderingFrames:"timeline-overview-view-mode-rendering-frames"};WebInspector.TimelineOverview.Event={EditingInstrumentsDidChange:"editing-instruments-did-change",RecordSelected:"timeline-overview-record-selected",TimelineSelected:"timeline-overview-timeline-selected",TimeRangeSelectionChanged:"timeline-overview-time-range-selection-changed"};WebInspector.TimelineRecordTreeElement=class TimelineRecordTreeElement extends WebInspector.GeneralTreeElement
{constructor(timelineRecord,subtitleNameStyle,includeDetailsInMainTitle,sourceCodeLocation,representedObject)
{sourceCodeLocation=sourceCodeLocation||timelineRecord.sourceCodeLocation||null;let alternateSubtitle=null;if(includeDetailsInMainTitle&&timelineRecord.type===WebInspector.TimelineRecord.Type.Script&&timelineRecord.eventType===WebInspector.ScriptTimelineRecord.EventType.TimerInstalled){let timeoutString=Number.secondsToString(timelineRecord.details.timeout/1000);alternateSubtitle=document.createElement("span");alternateSubtitle.classList.add("alternate-subtitle");if(timelineRecord.details.repeating)
alternateSubtitle.textContent=WebInspector.UIString("%s interval").format(timeoutString);else
alternateSubtitle.textContent=WebInspector.UIString("%s delay").format(timeoutString);}
let subtitle=null;if(sourceCodeLocation){subtitle=document.createElement("span");if(subtitleNameStyle!==WebInspector.SourceCodeLocation.NameStyle.None)
sourceCodeLocation.populateLiveDisplayLocationString(subtitle,"textContent",null,subtitleNameStyle);else
sourceCodeLocation.populateLiveDisplayLocationString(subtitle,"textContent",null,WebInspector.SourceCodeLocation.NameStyle.None,WebInspector.UIString("line "));}
let iconStyleClass=WebInspector.TimelineTabContentView.iconClassNameForRecord(timelineRecord);let title=WebInspector.TimelineTabContentView.displayNameForRecord(timelineRecord);super([iconStyleClass],title,subtitle,representedObject||timelineRecord,false);this._record=timelineRecord;this._sourceCodeLocation=sourceCodeLocation;if(this._sourceCodeLocation)
this.tooltipHandledSeparately=true;if(alternateSubtitle)
this.titlesElement.appendChild(alternateSubtitle);} 
get record()
{return this._record;}
get filterableData()
{var url=this._sourceCodeLocation?this._sourceCodeLocation.sourceCode.url:"";return{text:[this.mainTitle,url||"",this._record.details||""]};}
get sourceCodeLocation()
{return this._sourceCodeLocation;} 
onattach()
{super.onattach();if(!this.tooltipHandledSeparately)
return;var tooltipPrefix=this.mainTitle+"\n";this._sourceCodeLocation.populateLiveDisplayLocationTooltip(this.element,tooltipPrefix);}};WebInspector.TimelineRecordTreeElement.StyleRecordIconStyleClass="style-record";WebInspector.TimelineRecordTreeElement.LayoutRecordIconStyleClass="layout-record";WebInspector.TimelineRecordTreeElement.PaintRecordIconStyleClass="paint-record";WebInspector.TimelineRecordTreeElement.CompositeRecordIconStyleClass="composite-record";WebInspector.TimelineRecordTreeElement.RenderingFrameRecordIconStyleClass="rendering-frame-record";WebInspector.TimelineRecordTreeElement.APIRecordIconStyleClass="api-record";WebInspector.TimelineRecordTreeElement.EvaluatedRecordIconStyleClass="evaluated-record";WebInspector.TimelineRecordTreeElement.EventRecordIconStyleClass="event-record";WebInspector.TimelineRecordTreeElement.TimerRecordIconStyleClass="timer-record";WebInspector.TimelineRecordTreeElement.AnimationRecordIconStyleClass="animation-record";WebInspector.TimelineRecordTreeElement.ProbeRecordIconStyleClass="probe-record";WebInspector.TimelineRecordTreeElement.ConsoleProfileIconStyleClass="console-profile-record";WebInspector.TimelineRecordTreeElement.GarbageCollectionIconStyleClass="garbage-collection-profile-record";WebInspector.TimelineTreeElement=class TimelineTreeElement extends WebInspector.GeneralTreeElement
{constructor(timeline,placeholder)
{let displayName=WebInspector.TimelineTabContentView.displayNameForTimelineType(timeline.type);let iconClassName=WebInspector.TimelineTabContentView.iconClassNameForTimelineType(timeline.type);let genericClassName=WebInspector.TimelineTabContentView.genericClassNameForTimelineType(timeline.type);super([iconClassName,genericClassName],displayName,"",timeline);this._placeholder=placeholder||false;this.editing=this._placeholder;} 
get placeholder()
{return this._placeholder;}
get editing()
{return this._editing;}
set editing(x)
{if(this._editing===x)
return;this._editing=x;this.selectable=!this._editing;this._updateStatusButton();} 
onattach()
{super.onattach();this.listItemElement.addEventListener("click",this._clickHandler.bind(this));} 
_showCloseButton()
{let tooltip=WebInspector.UIString("Close %s timeline view").format(this.mainTitle);let button=new WebInspector.TreeElementStatusButton(useSVGSymbol("Images/CloseLarge.svg","close-button",tooltip));button.addEventListener(WebInspector.TreeElementStatusButton.Event.Clicked,()=>{this.deselect();});this.status=button.element;}
_showCheckbox()
{let checkboxElement=document.createElement("input");checkboxElement.type="checkbox";checkboxElement.checked=!this._placeholder;let button=new WebInspector.TreeElementStatusButton(checkboxElement);checkboxElement.addEventListener("change",()=>{this._dispatchEnabledDidChangeEvent();});this.status=checkboxElement;}
_updateStatusButton()
{if(this._editing)
this._showCheckbox();else
this._showCloseButton();}
_clickHandler()
{if(!this._editing)
return;this.status.checked=!this.status.checked;this._dispatchEnabledDidChangeEvent();}
_dispatchEnabledDidChangeEvent()
{this.dispatchEventToListeners(WebInspector.TimelineTreeElement.Event.EnabledDidChange);}};WebInspector.TimelineTreeElement.Event={EnabledDidChange:"timeline-tree-element-enabled-did-change"};WebInspector.ConsoleTabContentView=class ConsoleTabContentView extends WebInspector.ContentBrowserTabContentView
{constructor(identifier)
{let{image,title}=WebInspector.ConsoleTabContentView.tabInfo();let tabBarItem=new WebInspector.GeneralTabBarItem(image,title);super(identifier||"console","console",tabBarItem,null,null,true);}
static tabInfo()
{return{image:"Images/Console.svg",title:WebInspector.UIString("Console"),};} 
get type()
{return WebInspector.ConsoleTabContentView.Type;}
shown()
{super.shown();WebInspector.consoleContentView.prompt.focus();if(this.contentBrowser.currentContentView===WebInspector.consoleContentView)
return;
if(WebInspector.consoleContentView.parentContainer)
WebInspector.consoleContentView.parentContainer.closeContentView(WebInspector.consoleContentView);this.contentBrowser.showContentView(WebInspector.consoleContentView);}
showRepresentedObject(representedObject,cookie)
{

}
canShowRepresentedObject(representedObject)
{return representedObject instanceof WebInspector.LogObject;}
get supportsSplitContentBrowser()
{return false;}};WebInspector.ConsoleTabContentView.Type="console";WebInspector.DebuggerTabContentView=class DebuggerTabContentView extends WebInspector.ContentBrowserTabContentView
{constructor(identifier)
{let{image,title}=WebInspector.DebuggerTabContentView.tabInfo();let tabBarItem=new WebInspector.GeneralTabBarItem(image,title);let detailsSidebarPanelConstructors=[WebInspector.ScopeChainDetailsSidebarPanel,WebInspector.ResourceDetailsSidebarPanel,WebInspector.ProbeDetailsSidebarPanel];super(identifier||"debugger","debugger",tabBarItem,WebInspector.DebuggerSidebarPanel,detailsSidebarPanelConstructors);}
static tabInfo()
{return{image:"Images/Debugger.svg",title:WebInspector.UIString("Debugger"),};} 
get type()
{return WebInspector.DebuggerTabContentView.Type;}
get supportsSplitContentBrowser()
{return true;}
canShowRepresentedObject(representedObject)
{if(representedObject instanceof WebInspector.Script)
return true;if(!(representedObject instanceof WebInspector.Resource))
return false;return representedObject.type===WebInspector.Resource.Type.Document||representedObject.type===WebInspector.Resource.Type.Script;}
showDetailsSidebarPanels()
{super.showDetailsSidebarPanels();if(!this._showScopeChainDetailsSidebarPanel)
return;let scopeChainDetailsSidebarPanel=WebInspector.instanceForClass(WebInspector.ScopeChainDetailsSidebarPanel);if(!scopeChainDetailsSidebarPanel.parentSidebar)
return;scopeChainDetailsSidebarPanel.show();this._showScopeChainDetailsSidebarPanel=false;}
showScopeChainDetailsSidebarPanel()
{this._showScopeChainDetailsSidebarPanel=true;}
revealAndSelectBreakpoint(breakpoint)
{var treeElement=this.navigationSidebarPanel.treeElementForRepresentedObject(breakpoint);if(treeElement)
treeElement.revealAndSelect();}};WebInspector.DebuggerTabContentView.Type="debugger";WebInspector.ElementsTabContentView=class ElementsTabContentView extends WebInspector.ContentBrowserTabContentView
{constructor(identifier)
{let{image,title}=WebInspector.ElementsTabContentView.tabInfo();let tabBarItem=new WebInspector.GeneralTabBarItem(image,title);let detailsSidebarPanelConstructors=[WebInspector.DOMNodeDetailsSidebarPanel,WebInspector.CSSStyleDetailsSidebarPanel];if(window.LayerTreeAgent)
detailsSidebarPanelConstructors.push(WebInspector.LayerTreeDetailsSidebarPanel);super(identifier||"elements","elements",tabBarItem,null,detailsSidebarPanelConstructors,true);WebInspector.frameResourceManager.addEventListener(WebInspector.FrameResourceManager.Event.MainFrameDidChange,this._mainFrameDidChange,this);WebInspector.Frame.addEventListener(WebInspector.Frame.Event.MainResourceDidChange,this._mainResourceDidChange,this);}
static tabInfo()
{return{image:"Images/Elements.svg",title:WebInspector.UIString("Elements"),};}
static isTabAllowed()
{return!!window.DOMAgent;} 
get type()
{return WebInspector.ElementsTabContentView.Type;}
get supportsSplitContentBrowser()
{return true;}
canShowRepresentedObject(representedObject)
{return representedObject instanceof WebInspector.DOMTree;}
showRepresentedObject(representedObject,cookie)
{if(!this.contentBrowser.currentContentView)
this._showDOMTreeContentView();if(!cookie||!cookie.nodeToSelect)
return;let domTreeContentView=this.contentBrowser.currentContentView;domTreeContentView.selectAndRevealDOMNode(cookie.nodeToSelect);
cookie.nodeToSelect=undefined;}
shown()
{super.shown();if(!this.contentBrowser.currentContentView)
this._showDOMTreeContentView();}
closed()
{super.closed();WebInspector.frameResourceManager.removeEventListener(null,null,this);WebInspector.Frame.removeEventListener(null,null,this);} 
_showDOMTreeContentView()
{this.contentBrowser.contentViewContainer.closeAllContentViews();var mainFrame=WebInspector.frameResourceManager.mainFrame;if(mainFrame)
this.contentBrowser.showContentViewForRepresentedObject(mainFrame.domTree);}
_mainFrameDidChange(event)
{this._showDOMTreeContentView();}
_mainResourceDidChange(event)
{if(!event.target.isMainFrame())
return;this._showDOMTreeContentView();}};WebInspector.ElementsTabContentView.Type="elements";WebInspector.ResourceTreeElement=class ResourceTreeElement extends WebInspector.SourceCodeTreeElement
{constructor(resource,representedObject)
{super(resource,["resource",WebInspector.ResourceTreeElement.ResourceIconStyleClassName,resource.type],"","",representedObject||resource,false);this._updateResource(resource);} 
static compareResourceTreeElements(a,b)
{var comparisonResult=a.resource.type.extendedLocaleCompare(b.resource.type);if(comparisonResult!==0)
return comparisonResult;if(a.resource.type===WebInspector.Resource.Type.XHR||a.resource.type===WebInspector.Resource.Type.Fetch||a.resource.type===WebInspector.Resource.Type.WebSocket)
return a.resource.firstTimestamp-b.resource.firstTimestamp||0;


comparisonResult=a.subtitle.extendedLocaleCompare(b.subtitle);if(comparisonResult!==0)
return comparisonResult;return a.mainTitle.extendedLocaleCompare(b.mainTitle);}
static compareFolderAndResourceTreeElements(a,b)
{var aIsFolder=a instanceof WebInspector.FolderTreeElement;var bIsFolder=b instanceof WebInspector.FolderTreeElement;if(aIsFolder&&!bIsFolder)
return-1;if(!aIsFolder&&bIsFolder)
return 1;if(aIsFolder&&bIsFolder)
return a.mainTitle.extendedLocaleCompare(b.mainTitle);return WebInspector.ResourceTreeElement.compareResourceTreeElements(a,b);} 
get resource()
{return this._resource;}
get filterableData()
{let urlComponents=this._resource.urlComponents;return{text:[urlComponents.lastPathComponent,urlComponents.path,this._resource.url]};}
ondblclick()
{if(this._resource.type===WebInspector.Resource.Type.WebSocket)
return;InspectorFrontendHost.openInNewTab(this._resource.url);}
_updateResource(resource)
{
if(this._resource){this._resource.removeEventListener(WebInspector.Resource.Event.URLDidChange,this._urlDidChange,this);this._resource.removeEventListener(WebInspector.Resource.Event.TypeDidChange,this._typeDidChange,this);this._resource.removeEventListener(WebInspector.Resource.Event.LoadingDidFinish,this._updateStatus,this);this._resource.removeEventListener(WebInspector.Resource.Event.LoadingDidFail,this._updateStatus,this);}
this._updateSourceCode(resource);this._resource=resource;resource.addEventListener(WebInspector.Resource.Event.URLDidChange,this._urlDidChange,this);resource.addEventListener(WebInspector.Resource.Event.TypeDidChange,this._typeDidChange,this);resource.addEventListener(WebInspector.Resource.Event.LoadingDidFinish,this._updateStatus,this);resource.addEventListener(WebInspector.Resource.Event.LoadingDidFail,this._updateStatus,this);this._updateTitles();this._updateStatus();this._updateToolTip();} 
_updateTitles()
{var frame=this._resource.parentFrame;var target=this._resource.target;var isMainResource=this._resource.isMainResource();var parentResourceHost=target.mainResource?target.mainResource.urlComponents.host:null;if(isMainResource&&frame){parentResourceHost=frame.parentFrame?frame.parentFrame.mainResource.urlComponents.host:null;}else if(frame){parentResourceHost=frame.mainResource.urlComponents.host;}
var urlComponents=this._resource.urlComponents;var oldMainTitle=this.mainTitle;this.mainTitle=WebInspector.displayNameForURL(this._resource.url,urlComponents);var subtitle=parentResourceHost!==urlComponents.host||frame&&frame.isMainFrame()&&isMainResource?WebInspector.displayNameForHost(urlComponents.host):null;this.subtitle=this.mainTitle!==subtitle?subtitle:null;if(oldMainTitle!==this.mainTitle)
this.callFirstAncestorFunction("descendantResourceTreeElementMainTitleDidChange",[this,oldMainTitle]);}
populateContextMenu(contextMenu,event)
{WebInspector.appendContextMenuItemsForSourceCode(contextMenu,this._resource);super.populateContextMenu(contextMenu,event);} 
_updateStatus()
{if(this._resource.hadLoadingError())
this.addClassName(WebInspector.ResourceTreeElement.FailedStyleClassName);else
this.removeClassName(WebInspector.ResourceTreeElement.FailedStyleClassName);if(this._resource.finished||this._resource.failed){if(this.status&&this.status[WebInspector.ResourceTreeElement.SpinnerSymbol])
this.status="";}else{let spinner=new WebInspector.IndeterminateProgressSpinner;this.status=spinner.element;this.status[WebInspector.ResourceTreeElement.SpinnerSymbol]=true;}}
_updateToolTip()
{this.tooltip=this._resource.displayURL;}
_urlDidChange(event)
{this._updateTitles();this._updateToolTip();}
_typeDidChange(event)
{this.removeClassName(event.data.oldType);this.addClassName(this._resource.type);this.callFirstAncestorFunction("descendantResourceTreeElementTypeDidChange",[this,event.data.oldType]);}};WebInspector.ResourceTreeElement.ResourceIconStyleClassName="resource-icon";WebInspector.ResourceTreeElement.FailedStyleClassName="failed";WebInspector.ResourceTreeElement.SpinnerSymbol=Symbol("spinner");WebInspector.ResourcesTabContentView=class ResourcesTabContentView extends WebInspector.ContentBrowserTabContentView
{constructor(identifier)
{let{image,title}=WebInspector.ResourcesTabContentView.tabInfo();let tabBarItem=new WebInspector.GeneralTabBarItem(image,title);let detailsSidebarPanelConstructors=[WebInspector.ResourceDetailsSidebarPanel,WebInspector.ProbeDetailsSidebarPanel];if(window.CanvasAgent&&WebInspector.settings.experimentalShowCanvasContextsInResources.value)
detailsSidebarPanelConstructors.push(WebInspector.CanvasDetailsSidebarPanel);detailsSidebarPanelConstructors=detailsSidebarPanelConstructors.concat([WebInspector.DOMNodeDetailsSidebarPanel,WebInspector.CSSStyleDetailsSidebarPanel]);if(window.LayerTreeAgent)
detailsSidebarPanelConstructors.push(WebInspector.LayerTreeDetailsSidebarPanel);super(identifier||"resources","resources",tabBarItem,WebInspector.ResourceSidebarPanel,detailsSidebarPanelConstructors);}
static tabInfo()
{return{image:"Images/Resources.svg",title:WebInspector.UIString("Resources"),};} 
get type()
{return WebInspector.ResourcesTabContentView.Type;}
get supportsSplitContentBrowser()
{return true;}
canShowRepresentedObject(representedObject)
{return representedObject instanceof WebInspector.Frame||representedObject instanceof WebInspector.Resource||representedObject instanceof WebInspector.Script||representedObject instanceof WebInspector.CSSStyleSheet||representedObject instanceof WebInspector.ContentFlow||representedObject instanceof WebInspector.Canvas||representedObject instanceof WebInspector.Collection;}};WebInspector.ResourcesTabContentView.Type="resources";WebInspector.SearchTabContentView=class SearchTabContentView extends WebInspector.ContentBrowserTabContentView
{constructor(identifier)
{let{image,title}=WebInspector.SearchTabContentView.tabInfo();let tabBarItem=new WebInspector.GeneralTabBarItem(image,title);let detailsSidebarPanelConstructors=[WebInspector.ResourceDetailsSidebarPanel,WebInspector.ProbeDetailsSidebarPanel,WebInspector.DOMNodeDetailsSidebarPanel,WebInspector.CSSStyleDetailsSidebarPanel];if(window.LayerTreeAgent)
detailsSidebarPanelConstructors.push(WebInspector.LayerTreeDetailsSidebarPanel);super(identifier||"search","search",tabBarItem,WebInspector.SearchSidebarPanel,detailsSidebarPanelConstructors);this._forcePerformSearch=false;}
static tabInfo()
{return{image:"Images/SearchResults.svg",title:WebInspector.UIString("Search"),};}
static isEphemeral()
{return true;} 
get type()
{return WebInspector.SearchTabContentView.Type;}
shown()
{super.shown();setTimeout(this.focusSearchField.bind(this));}
canShowRepresentedObject(representedObject)
{if(!(representedObject instanceof WebInspector.Resource)&&!(representedObject instanceof WebInspector.Script)&&!(representedObject instanceof WebInspector.DOMTree))
return false;return!!this.navigationSidebarPanel.contentTreeOutline.getCachedTreeElement(representedObject);}
focusSearchField()
{this.navigationSidebarPanel.focusSearchField(this._forcePerformSearch);this._forcePerformSearch=false;}
performSearch(searchQuery)
{this.navigationSidebarPanel.performSearch(searchQuery);this._forcePerformSearch=false;}
handleCopyEvent(event)
{let selectedTreeElement=this.navigationSidebarPanel.contentTreeOutline.selectedTreeElement;if(!selectedTreeElement)
return;event.clipboardData.setData("text/plain",selectedTreeElement.synthesizedTextValue);event.stopPropagation();event.preventDefault();} 
initialLayout()
{super.initialLayout();this._forcePerformSearch=true;}};WebInspector.SearchTabContentView.Type="search";WebInspector.SettingsTabContentView=class SettingsTabContentView extends WebInspector.TabContentView
{constructor(identifier)
{let tabBarItem=new WebInspector.PinnedTabBarItem("Images/Gear.svg",WebInspector.UIString("Open Settings"));super(identifier||"settings","settings",tabBarItem);tabBarItem.representedObject=this;this._selectedSettingsView=null;this._settingsViews=[];}
static tabInfo()
{return{image:"Images/Gear.svg",title:WebInspector.UIString("Settings"),};}
static isEphemeral()
{return true;}
static shouldSaveTab()
{return false;} 
get type(){return WebInspector.SettingsTabContentView.Type;}
get selectedSettingsView()
{return this._selectedSettingsView;}
set selectedSettingsView(settingsView)
{if(this._selectedSettingsView===settingsView)
return;if(this._selectedSettingsView)
this.replaceSubview(this._selectedSettingsView,settingsView);else
this.addSubview(settingsView);this._selectedSettingsView=settingsView;this._selectedSettingsView.updateLayout();let navigationItem=this._navigationBar.findNavigationItem(settingsView.identifier);console.assert(navigationItem,"Missing navigation item for settings view.",settingsView)
if(!navigationItem)
return;this._navigationBar.selectedNavigationItem=navigationItem;}
addSettingsView(settingsView)
{if(this._settingsViews.includes(settingsView)){return;}
this._settingsViews.push(settingsView);this._navigationBar.addNavigationItem(new WebInspector.RadioButtonNavigationItem(settingsView.identifier,settingsView.displayName));this._updateNavigationBarVisibility();}
setSettingsViewVisible(settingsView,visible)
{let navigationItem=this._navigationBar.findNavigationItem(settingsView.identifier);if(!navigationItem)
return;if(navigationItem.hidden===!visible)
return;navigationItem.hidden=!visible;settingsView.element.classList.toggle("hidden",!visible);this._updateNavigationBarVisibility();if(!this.selectedSettingsView){if(visible)
this.selectedSettingsView=settingsView;return;}
if(this.selectedSettingsView!==settingsView)
return;let index=this._settingsViews.indexOf(settingsView);console.assert(index!==-1,"SettingsView not found.",settingsView)
if(index===-1)
return;let previousIndex=index;while(--previousIndex>=0){let previousNavigationItem=this._navigationBar.navigationItems[previousIndex];if(!previousNavigationItem||previousNavigationItem.hidden)
continue;this.selectedSettingsView=this._settingsViews[previousIndex];return;}
let nextIndex=index;while(++nextIndex<this._settingsViews.length){let nextNavigationItem=this._navigationBar.navigationItems[nextIndex];if(!nextNavigationItem||nextNavigationItem.hidden)
continue;this.selectedSettingsView=this._settingsViews[nextIndex];return;}} 
initialLayout()
{this._navigationBar=new WebInspector.NavigationBar;this._navigationBar.addEventListener(WebInspector.NavigationBar.Event.NavigationItemSelected,this._navigationItemSelected,this);this.addSubview(this._navigationBar);this._createGeneralSettingsView();WebInspector.notifications.addEventListener(WebInspector.Notification.DebugUIEnabledDidChange,this._updateDebugSettingsViewVisibility,this);this._updateDebugSettingsViewVisibility();this.selectedSettingsView=this._settingsViews[0];} 
_createGeneralSettingsView()
{let generalSettingsView=new WebInspector.SettingsView("general",WebInspector.UIString("General"));const indentValues=[WebInspector.UIString("Tabs"),WebInspector.UIString("Spaces")];let indentEditor=generalSettingsView.addGroupWithCustomSetting(WebInspector.UIString("Prefer indent using:"),WebInspector.SettingEditor.Type.Select,{values:indentValues});indentEditor.value=indentValues[WebInspector.settings.indentWithTabs.value?0:1];indentEditor.addEventListener(WebInspector.SettingEditor.Event.ValueDidChange,()=>{WebInspector.settings.indentWithTabs.value=indentEditor.value===indentValues[0];});const widthLabel=WebInspector.UIString("spaces");const widthOptions={min:1};generalSettingsView.addSetting(WebInspector.UIString("Tab width:"),WebInspector.settings.tabSize,widthLabel,widthOptions);generalSettingsView.addSetting(WebInspector.UIString("Indent width:"),WebInspector.settings.indentUnit,widthLabel,widthOptions);generalSettingsView.addSetting(WebInspector.UIString("Line wrapping:"),WebInspector.settings.enableLineWrapping,WebInspector.UIString("Wrap lines to editor width"));let showGroup=generalSettingsView.addGroup(WebInspector.UIString("Show:"));showGroup.addSetting(WebInspector.settings.showWhitespaceCharacters,WebInspector.UIString("Whitespace characters"));showGroup.addSetting(WebInspector.settings.showInvalidCharacters,WebInspector.UIString("Invalid characters"));generalSettingsView.addSeparator();let stylesEditingGroup=generalSettingsView.addGroup(WebInspector.UIString("Styles Editing:"));stylesEditingGroup.addSetting(WebInspector.settings.stylesShowInlineWarnings,WebInspector.UIString("Show inline warnings"));stylesEditingGroup.addSetting(WebInspector.settings.stylesInsertNewline,WebInspector.UIString("Automatically insert newline"));stylesEditingGroup.addSetting(WebInspector.settings.stylesSelectOnFirstClick,WebInspector.UIString("Select text on first click"));generalSettingsView.addSeparator();generalSettingsView.addSetting(WebInspector.UIString("Network:"),WebInspector.settings.clearNetworkOnNavigate,WebInspector.UIString("Clear when page navigates"));generalSettingsView.addSeparator();generalSettingsView.addSetting(WebInspector.UIString("Console:"),WebInspector.settings.clearLogOnNavigate,WebInspector.UIString("Clear when page navigates"));generalSettingsView.addSeparator();generalSettingsView.addSetting(WebInspector.UIString("Debugger:"),WebInspector.settings.showScopeChainOnPause,WebInspector.UIString("Show Scope Chain on pause"));generalSettingsView.addSeparator();const zoomLevels=[0.6,0.8,1,1.2,1.4,1.6,1.8,2,2.2,2.4];const zoomValues=zoomLevels.map((level)=>[level,Number.percentageString(level,0)]);let zoomEditor=generalSettingsView.addGroupWithCustomSetting(WebInspector.UIString("Zoom:"),WebInspector.SettingEditor.Type.Select,{values:zoomValues});zoomEditor.value=WebInspector.getZoomFactor();zoomEditor.addEventListener(WebInspector.SettingEditor.Event.ValueDidChange,()=>{WebInspector.setZoomFactor(zoomEditor.value);});WebInspector.settings.zoomFactor.addEventListener(WebInspector.Setting.Event.Changed,()=>{zoomEditor.value=WebInspector.getZoomFactor().maxDecimals(2);});this.addSettingsView(generalSettingsView);}
_createDebugSettingsView()
{if(this._debugSettingsView)
return;this._debugSettingsView=new WebInspector.SettingsView("debug",WebInspector.unlocalizedString("Debug"));let protocolMessagesGroup=this._debugSettingsView.addGroup(WebInspector.unlocalizedString("Protocol Logging:"));let autoLogProtocolMessagesEditor=protocolMessagesGroup.addSetting(WebInspector.settings.autoLogProtocolMessages,WebInspector.unlocalizedString("Messages"));WebInspector.settings.autoLogProtocolMessages.addEventListener(WebInspector.Setting.Event.Changed,()=>{autoLogProtocolMessagesEditor.value=InspectorBackend.dumpInspectorProtocolMessages;});protocolMessagesGroup.addSetting(WebInspector.settings.autoLogTimeStats,WebInspector.unlocalizedString("Time Stats"));this._debugSettingsView.addSeparator();this._debugSettingsView.addSetting(WebInspector.unlocalizedString("Uncaught Exception Reporter:"),WebInspector.settings.enableUncaughtExceptionReporter,WebInspector.unlocalizedString("Enabled"));this._debugSettingsView.addSeparator();const layoutDirectionValues=[[WebInspector.LayoutDirection.System,WebInspector.unlocalizedString("System Default")],[WebInspector.LayoutDirection.LTR,WebInspector.unlocalizedString("Left to Right (LTR)")],[WebInspector.LayoutDirection.RTL,WebInspector.unlocalizedString("Right to Left (RTL)")],];let layoutDirectionEditor=this._debugSettingsView.addGroupWithCustomSetting(WebInspector.unlocalizedString("Layout Direction:"),WebInspector.SettingEditor.Type.Select,{values:layoutDirectionValues});layoutDirectionEditor.value=WebInspector.settings.layoutDirection.value;layoutDirectionEditor.addEventListener(WebInspector.SettingEditor.Event.ValueDidChange,()=>{WebInspector.setLayoutDirection(layoutDirectionEditor.value);});if(window.CanvasAgent){this._debugSettingsView.addSeparator();this._debugSettingsView.addSetting(WebInspector.UIString("Canvas:"),WebInspector.settings.experimentalShowCanvasContextsInResources,WebInspector.UIString("Show Contexts in Resources Tab"));}
this.addSettingsView(this._debugSettingsView);}
_updateNavigationBarVisibility()
{let visibleItems=0;for(let item of this._navigationBar.navigationItems){if(!item.hidden&&++visibleItems>1){this._navigationBar.element.classList.remove("invisible");return;}}
this._navigationBar.element.classList.add("invisible");}
_navigationItemSelected(event)
{let navigationItem=event.target.selectedNavigationItem;if(!navigationItem)
return;let settingsView=this._settingsViews.find((view)=>view.identifier===navigationItem.identifier);if(!settingsView)
return;this.selectedSettingsView=settingsView;}
_updateDebugSettingsViewVisibility()
{if(WebInspector.isDebugUIEnabled())
this._createDebugSettingsView();if(!this._debugSettingsView)
return;this.setSettingsViewVisible(this._debugSettingsView,WebInspector.isDebugUIEnabled());this.needsLayout();}};WebInspector.SettingsTabContentView.Type="settings";WebInspector.StorageTabContentView=class StorageTabContentView extends WebInspector.ContentBrowserTabContentView
{constructor(identifier)
{let{image,title}=WebInspector.StorageTabContentView.tabInfo();let tabBarItem=new WebInspector.GeneralTabBarItem(image,title);let detailsSidebarPanelConstructors=[WebInspector.ApplicationCacheDetailsSidebarPanel,WebInspector.IndexedDatabaseDetailsSidebarPanel];super(identifier||"storage","storage",tabBarItem,WebInspector.StorageSidebarPanel,detailsSidebarPanelConstructors);}
static tabInfo()
{return{image:"Images/Storage.svg",title:WebInspector.UIString("Storage"),};}
static isTabAllowed()
{return!!window.DOMStorageAgent||!!window.DatabaseAgent||!!window.IndexedDBAgent;} 
get type()
{return WebInspector.StorageTabContentView.Type;}
get supportsSplitContentBrowser()
{return true;}
canShowRepresentedObject(representedObject)
{return representedObject instanceof WebInspector.DOMStorageObject||representedObject instanceof WebInspector.CookieStorageObject||representedObject instanceof WebInspector.DatabaseTableObject||representedObject instanceof WebInspector.DatabaseObject||representedObject instanceof WebInspector.ApplicationCacheFrame||representedObject instanceof WebInspector.IndexedDatabaseObjectStore||representedObject instanceof WebInspector.IndexedDatabase||representedObject instanceof WebInspector.IndexedDatabaseObjectStoreIndex;}};WebInspector.StorageTabContentView.Type="storage";WebInspector.TimelineTabContentView=class TimelineTabContentView extends WebInspector.ContentBrowserTabContentView
{constructor(identifier)
{let{image,title}=WebInspector.TimelineTabContentView.tabInfo();let tabBarItem=new WebInspector.GeneralTabBarItem(image,title);let detailsSidebarPanelConstructors=[WebInspector.ResourceDetailsSidebarPanel,WebInspector.ProbeDetailsSidebarPanel];super(identifier||"timeline","timeline",tabBarItem,null,detailsSidebarPanelConstructors);this._recordingTreeElementMap=new Map;this._recordingsTreeOutline=new WebInspector.TreeOutline;this._recordingsTreeOutline.addEventListener(WebInspector.TreeOutline.Event.SelectionDidChange,this._recordingsTreeSelectionDidChange,this);this._toggleRecordingShortcut=new WebInspector.KeyboardShortcut(null,WebInspector.KeyboardShortcut.Key.Space,this._toggleRecordingOnSpacebar.bind(this));this._toggleRecordingShortcut.implicitlyPreventsDefault=false;this._toggleRecordingShortcut.disabled=true;this._toggleNewRecordingShortcut=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.Shift,WebInspector.KeyboardShortcut.Key.Space,this._toggleNewRecordingOnSpacebar.bind(this));this._toggleNewRecordingShortcut.implicitlyPreventsDefault=false;this._toggleNewRecordingShortcut.disabled=true;let toolTip=WebInspector.UIString("Start recording (%s)\nCreate new recording (%s)").format(this._toggleRecordingShortcut.displayName,this._toggleNewRecordingShortcut.displayName);let altToolTip=WebInspector.UIString("Stop recording (%s)").format(this._toggleRecordingShortcut.displayName);this._recordButton=new WebInspector.ToggleButtonNavigationItem("record-start-stop",toolTip,altToolTip,"Images/Record.svg","Images/Stop.svg",13,13);this._recordButton.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,this._recordButtonClicked,this);this.contentBrowser.navigationBar.insertNavigationItem(this._recordButton,0);if(WebInspector.FPSInstrument.supported()){let timelinesNavigationItem=new WebInspector.RadioButtonNavigationItem(WebInspector.TimelineOverview.ViewMode.Timelines,WebInspector.UIString("Events"));let renderingFramesNavigationItem=new WebInspector.RadioButtonNavigationItem(WebInspector.TimelineOverview.ViewMode.RenderingFrames,WebInspector.UIString("Frames"));this.contentBrowser.navigationBar.insertNavigationItem(timelinesNavigationItem,1);this.contentBrowser.navigationBar.insertNavigationItem(renderingFramesNavigationItem,2);this.contentBrowser.navigationBar.addEventListener(WebInspector.NavigationBar.Event.NavigationItemSelected,this._viewModeSelected,this);}
WebInspector.timelineManager.addEventListener(WebInspector.TimelineManager.Event.RecordingCreated,this._recordingCreated,this);WebInspector.timelineManager.addEventListener(WebInspector.TimelineManager.Event.RecordingLoaded,this._recordingLoaded,this);WebInspector.timelineManager.addEventListener(WebInspector.TimelineManager.Event.CapturingStarted,this._capturingStartedOrStopped,this);WebInspector.timelineManager.addEventListener(WebInspector.TimelineManager.Event.CapturingStopped,this._capturingStartedOrStopped,this);WebInspector.notifications.addEventListener(WebInspector.Notification.VisibilityStateDidChange,this._inspectorVisibilityChanged,this);this._displayedRecording=null;this._displayedContentView=null;this._viewMode=null;this._previousSelectedTimelineType=null;const selectedByUser=false;this._changeViewMode(WebInspector.TimelineOverview.ViewMode.Timelines,selectedByUser);for(let recording of WebInspector.timelineManager.recordings)
this._addRecording(recording);this._recordingCountChanged();this.contentBrowser.updateHierarchicalPathForCurrentContentView();} 
static tabInfo()
{return{image:"Images/Timeline.svg",title:WebInspector.UIString("Timelines"),};}
static isTabAllowed()
{return!!window.TimelineAgent||!!window.ScriptProfilerAgent;}
static displayNameForTimelineType(timelineType)
{switch(timelineType){case WebInspector.TimelineRecord.Type.Network:return WebInspector.UIString("Network Requests");case WebInspector.TimelineRecord.Type.Layout:return WebInspector.UIString("Layout & Rendering");case WebInspector.TimelineRecord.Type.Script:return WebInspector.UIString("JavaScript & Events");case WebInspector.TimelineRecord.Type.RenderingFrame:return WebInspector.UIString("Rendering Frames");case WebInspector.TimelineRecord.Type.Memory:return WebInspector.UIString("Memory");case WebInspector.TimelineRecord.Type.HeapAllocations:return WebInspector.UIString("JavaScript Allocations");default:console.error("Unknown Timeline type:",timelineType);}
return null;}
static iconClassNameForTimelineType(timelineType)
{switch(timelineType){case WebInspector.TimelineRecord.Type.Network:return"network-icon";case WebInspector.TimelineRecord.Type.Layout:return"layout-icon";case WebInspector.TimelineRecord.Type.Memory:return"memory-icon";case WebInspector.TimelineRecord.Type.HeapAllocations:return"heap-allocations-icon";case WebInspector.TimelineRecord.Type.Script:return"script-icon";case WebInspector.TimelineRecord.Type.RenderingFrame:return"rendering-frame-icon";default:console.error("Unknown Timeline type:",timelineType);}
return null;}
static genericClassNameForTimelineType(timelineType)
{switch(timelineType){case WebInspector.TimelineRecord.Type.Network:return"network";case WebInspector.TimelineRecord.Type.Layout:return"colors";case WebInspector.TimelineRecord.Type.Memory:return"memory";case WebInspector.TimelineRecord.Type.HeapAllocations:return"heap-allocations";case WebInspector.TimelineRecord.Type.Script:return"script";case WebInspecto