SUMMARY = "aml dvb samples"
LICENSE = "LGPL-2.0+"
LIC_FILES_CHKSUM = "file://Doxyfile;md5=c771730fa57fc498cd9dc7d74b84934d"
FILESEXTRAPATHS_prepend := "${THISDIR}/files:"

SRC_URI = "${@bb.utils.contains('DISTRO_FEATURES', 'amlrepo', "git://${AML_GIT_ROOT}/dvb.git;protocol=${AML_GIT_PROTOCOL};branch=tv-kernel-4.9", \ 
            "${RDK_COMPONENTS_ROOT_GIT}/sdk/soc/amlogic/dvb;protocol=${RDK_GIT_PROTOCOL};branch=${RDK_GIT_BRANCH}",d)}"
SRC_URI_append = " file://0001-RDK-update-aml-dvb-to-only-compile-test-apps.patch"
SRC_URI_append = " file://0001-RDKTV-5745-Add-extra-tuner-signal-strength-status-in.patch"

SRCREV ?= "${AUTOREV}"
PV = "${SRCPV}"

DEPENDS = " aml-zvbi sqlite libamavutils"
RDEPENDS_${PN} += " libamavutils"

do_configure[noexec] = "1"
inherit autotools pkgconfig
S="${WORKDIR}/git"

EXTRA_OEMAKE="TARGET_DIR=${S} \ 
              TARGET_LDFLAGS=' -lstdc++ -lpthread -lrt -lm -ldl -lc -lgcc -L${STAGING_DIR_TARGET}/usr/lib' \
             " 
do_compile() {
    cd ${S}
    mkdir -p ${S}/usr/lib
    mkdir -p ${S}/usr/bin
    oe_runmake  all
}
do_install() {
   install -d ${D}${libdir} 
   install -d ${D}${bindir}

    cd ${S}
    install -D -m 0644 ${S}/am_adp/libam_adp.so ${D}/usr/lib
    install -m 0755 ${S}/test/am_fend_test/am_fend_test ${D}${bindir}
    install -m 0755 ${S}/test/am_dvr_test/am_dvr_test ${D}${bindir}
    install -m 0755 ${S}/test/am_dmx_test/am_dmx_test ${D}${bindir}
}

FILES_${PN} = "${libdir}/* ${bindir}/*"
FILES_${PN}-dev = "${includedir}/* "
INSANE_SKIP_${PN} = "dev-so ldflags dev-elf"
INSANE_SKIP_${PN}-dev = "dev-so ldflags dev-elf"
