inherit kernel
require linux-meson.inc
FILESEXTRAPATHS_prepend := "${THISDIR}/4.9:"
FILESEXTRAPATHS_prepend_aarch64 := "${THISDIR}/aarch64:"
FILESEXTRAPATHS_prepend_armv7a := "${THISDIR}/armv7a:"

KBRANCH = "${@bb.utils.contains('DISTRO_FEATURES', 'amlrepo', "amlogic-4.9-dev", "${RDK_GIT_BRANCH}", d)}" 
SRC_URI = "${@bb.utils.contains('DISTRO_FEATURES', 'amlrepo', "git://${AML_GIT_ROOT}/kernel/common.git;protocol=${AML_GIT_PROTOCOL};branch=${KBRANCH};",    \ 
            "${RDK_COMPONENTS_ROOT_GIT}/sdk/soc/amlogic/kernel/common;protocol=${RDK_GIT_PROTOCOL};branch=${RDK_GIT_BRANCH}", d)}"

SRC_URI_append = " file://defconfig"

SRC_URI_append = " file://meson.scc \
            file://meson.cfg \
            file://meson-user-config.cfg \
            file://systemd.cfg \
            file://logcat.cfg \
            file://minfo.cfg \
            file://meson-user-patches.scc "
SRC_URI_append = "${@bb.utils.contains('DISTRO_FEATURES', 'msync',  " file://msync.cfg", " " , d)}"

SRC_URI_append = " file://0050-SKY-qca-Bluetooth_SIG_Certification_fixes.patch"

SRC_URI_append = " file://0001-vout-add-video-pll-adjustment-interface.patch"
SRC_URI_append = " file://0002-lcd-enable-clock-adjustment.patch"

SRC_URI_append = " file://0001-ATSC-demod-BER-value-not-reset-on-channel-change.patch"
SRC_URI_append = " file://0001-RDKTV-5662-Expose-Tuner-signal-strength-though-Linux.patch"
SRC_URI_append = " file://0001-AMLOGIC-1271-TV-31485-Multiple-PQ-errors-returned-wi.patch"
SRC_URI_append = " file://0001-decoder-synchronize-code-from-AndroidR-in-v4l2.-2-3.patch"
SRC_URI_append = " file://0001-AMLOGIC-1490-dv-remove-reset-operation-of-tv-core-wh.patch"
SRC_URI_append = " file://0001-dtv_demod-atsc-co-channel-interference.patch"
SRC_URI_append = " file://0001-Add-support-for-mmc-full-pwr-cycle.patch"
SRC_URI_append = " file://0001-dtv_demod-atsc-co-channel-interference-update.patch"
SRC_URI_append = " file://0001-dtv_demod-atsc-turn-off-unnecessary-logs.patch"
SRC_URI_append = " file://0002-dtv_demod-atsc-get-ck-clk.patch"
SRC_URI_append = " file://drm-add-refresh-rate-event-notify-1-1.patch"
SRC_URI_append = "${@bb.utils.contains('DISTRO_FEATURES', 'RDKTV_2GB', " file://0001-RDK-36645-codec_mm-adjust-default-tvp-pool-size.patch", " file://0001-Subject-codec_mm-adjust-default-tvp-pool-size-from-2.patch" , d)}"
SRC_URI_append = " file://0029-172469-codecmm-scatter.patch"
SRC_URI_append = " file://0031-reset-hdr-module-resume-reboot.patch"
SRC_URI_append = " file://0033-double-check-gamma-value.patch"
SRC_URI_append = " file://0035-dv-dvbt2-atsc.patch"
SRC_URI_append = " file://0038-primaries-from-src.patch"
SRC_URI_append = " file://0040-RDK-34142-backlight-fade.patch"
SRC_URI_append = " file://0040-keysimulator-sysfs.patch"
SRC_URI_append = " file://0041-AMLOGIC-3009-is-not-eos.patch"
SRC_URI_append = " file://0042-qamb.patch"
SRC_URI_append = " file://0052-softirq-priority-inversion-fix.patch"
SRC_URI_append = " file://0053-AMLOGIC-4546-FTA-Factory-Reset-reboots-the-panel-to-.patch"
SRC_URI_append = " file://0054-AMLOGIC-4612-Tune-TV-to-ch-62.1-UHD-store-loop-Clear.patch"

SRC_URI_append = " file://CVE-2019-15505.patch"
SRC_URI_append = " file://CVE-2019-15927.patch"
SRC_URI_append = " file://CVE-2019-19052.patch"
SRC_URI_append = " file://CVE-2020-11668.patch"
SRC_URI_append = " file://CVE-2019-19531.patch"
SRC_URI_append = " file://CVE-2019-13631.patch"
SRC_URI_append = " file://CVE-2020-13143.patch"
SRC_URI_append = " file://CVE-2019-19528_1.patch"
SRC_URI_append = " file://CVE-2019-19528_2.patch"
SRC_URI_append = " file://CVE-2019-20810.patch"
SRC_URI_append = " file://CVE-2019-15118.patch"
SRC_URI_append = " file://CVE-2019-14763.patch"
SRC_URI_append = " file://CVE-2020-15393.patch"
SRC_URI_append = " file://CVE-2021-29265.patch"
SRC_URI_append = " file://CVE-2019-19530.patch"
SRC_URI_append = " file://CVE-2019-19525.patch"
SRC_URI_append = " file://CVE-2019-19523.patch"
SRC_URI_append = " file://CVE-2019-19068.patch"
SRC_URI_append = " file://CVE-2019-19063.patch"
SRC_URI_append = " file://CVE-2019-18809.patch"
SRC_URI_append = " file://CVE-2019-15291.patch"
SRC_URI_append = " file://CVE-2019-15221.patch"
SRC_URI_append = " file://CVE-2019-15220.patch"
SRC_URI_append = " file://CVE-2019-15219.patch"
SRC_URI_append = " file://CVE-2019-15218.patch"
SRC_URI_append = " file://CVE-2019-15217.patch"
SRC_URI_append = " file://CVE-2019-15216.patch"
SRC_URI_append = " file://CVE-2019-15215.patch"
SRC_URI_append = " file://CVE-2019-15212.patch"
SRC_URI_append = " file://CVE-2019-15211.patch"
SRC_URI_append = " file://CVE-2019-15098.patch"
SRC_URI_append = " file://CVE-2019-19535.patch"
SRC_URI_append = " file://CVE-2018-19985.patch"
SRC_URI_append = " file://CVE-2020-11609.patch"
SRC_URI_append = " file://CVE-2020-11608.patch"
SRC_URI_append = " file://CVE-2019-19966.patch"
SRC_URI_append = " file://CVE-2019-19534.patch"
SRC_URI_append = " file://CVE-2019-19533.patch"

SRC_URI_append = " file://AMLOGIC-2695-cleanup-suspend-resume.patch"
SRC_URI_append = " file://0001-PQ-CM2-debug.patch"
SRC_URI_append = " file://0001-tvin-cvbs-force-out-TVIN_ASPECT_4x3_FULL-1-2.patch"
SRC_URI_append = " file://0001-dv-display-half-black-screen-in-netflix-small-window.patch"
SRC_URI_append = " file://llama-5158-disable-log.patch"
SRC_URI_append = " file://AMLOGIC-3301-reset-NIC-upon-tx-timeout.patch"
SRC_URI_append = " file://AMLOGIC-3878-dump-bl30-logs.patch"
SRC_URI_append = " file://0144-AMLOGIC-4465-dtv_demod-returns-locked-status-w.patch"
SRC_URI_append = " file://AMLOGIC-3878-bl30.cfg"

#Game Controller support
SRC_URI_append = " file://0001-LLAMA-10606-upstream-4-10-hid-sony-fixes.patch"
SRC_URI_append = " file://0002-LLAMA-10606-upstream-4-12-hid-sony-fixes.patch"
SRC_URI_append = " file://0003-LLAMA-10606-report-DS4-version-info-through-sysfs.patch"
SRC_URI_append = " file://0004-LLAMA-10606-use-devm_api-to-simplify-sony_leds_init.patch"
SRC_URI_append = " file://0005-LLAMA-10606-fix-race-condition-between-rumble-and-device-remove.patch"
SRC_URI_append = " file://0006-LLAMA-10606-fix-memory-corruption-issue-on-cleanup.patch"
SRC_URI_append = " file://0007-LLAMA-10606-fix-for-broken-buttons-on-DS3-USB-dongles.patch"
SRC_URI_append = " file://0008-LLAMA-10606-sony-dualsense-PS5-support.patch"
SRC_URI_append = " file://0009-LLAMA-10606-exclude-PS5-controller-from-hid-generic.patch"
SRC_URI_append = " file://0010-LLAMA-10606-fix-to-remove-noise-events-ps-controllers.patch"
SRC_URI_append = " file://0011-LLAMA-10606-fix-for-xbox-mapping.patch"
SRC_URI_append = " file://0012-LLAMA-10606-fix-for-xbox-pairing-issue.patch"
SRC_URI_append = " file://0013-LLAMA-10606-sony-ps4-gen2-and-ps4-dongle-support.patch"
SRC_URI_append = " file://0015-LLAMA-10606-xbox-mapping.patch"
SRC_URI_append = " file://0001-CPESP-3698-Nintendo-Switch-ProController_Support.patch"
SRC_URI_append = " file://0001-RDKTV-26609fix-battery-level-reporting-on-BT-mice.patch"
SRC_URI_append = " file://0001_RDKTV_28125_adaptive_controller_support.patch"

#rumble effect fix for 4.9 kernel
SRC_URI_append = " file://RDK-52258-linux4.9_fix_xbox_rumble_effect.patch"
SRC_URI_append = " file://RDKTV-33395_Enable_configs_for_Nintendo_rumble_effect.cfg"

#RT Thread Priority DRM patches
SRC_URI_append = " file://0016-RDKTV-30786_drmfb_to_use_high_priority_work_Q.patch"
SRC_URI_append = " file://0017-RDKTV-30786_drmlib_vblank_wait_fix.patch"

SRC_URI_append = "${@bb.utils.contains('DISTRO_FEATURES', 'kirkstone', " file://0001-kirkstone-build-error.patch", "", d)}"
LINUX_VERSION ?= "4.9.113"
LINUX_VERSION_EXTENSION ?= "-amlogic"

PR = "r2"

SRCREV ?="${AUTOREV}"
machine_branch = "${SRCREV}"

PV = "${LINUX_VERSION}+git${SRCPV}"

COMPATIBLE_MACHINE = "(mesong12b_*|mesong12a_*|mesongxl_*|mesontxlx_*|mesontm2_*)"

S = "${WORKDIR}/git"
