#!/bin/sh
Apparmor_blocklist="/opt/secure/Apparmor_blocklist"
Apparmor_defaults="/etc/apparmor/apparmor_defaults"
PROFILES_DIR="/etc/apparmor.d/"
PARSER="/sbin/apparmor_parser"
SYSFS_AA_PATH="/sys/kernel/security/apparmor/profiles"
RDKLOGS="/opt/logs/startup_stdout_log.txt"
PROFILES_UNCONFINED_DIR="/etc/apparmor.d/unconfined/"
LoadedProfile_count=0
echo -n noquiet > /sys/module/apparmor/parameters/audit

if  [ -f $PROFILES_DIR/etc.apparmor.apparmor_parse.sh ]; then
      $PARSER -rWC $PROFILES_DIR/etc.apparmor.apparmor_parse.sh
      if [ $? -eq 0 ]; then
           echo -n "changeprofile apparmor_parse.sh" > /proc/self/attr/current
      fi
fi

if [ -f /etc/device.properties ];then
     source /etc/device.properties
fi

if [ ! -f $RDKLOGS ]; then
	touch $RDKLOGS
fi

if [ ! -f $Apparmor_blocklist ]; then
  	touch $Apparmor_blocklist
fi

while read line; do
        mode=`echo $line | cut -d ":" -f 2`
        process=`echo $line | cut -d ":" -f 1`
        profile=`ls -ltr $PROFILES_DIR | grep -w $process | awk '{print $9}'`
        if [ ! -z $profile ]; then
	     blocklist_process=`grep -w $process $Apparmor_blocklist`
	     blocklist_mode=`echo $blocklist_process | awk -F ":" '{print $2}'`
	     if [ "$mode" == "enforce" ]; then
                     if [ "$blocklist_mode" == "complain" ]; then
                             $PARSER -rWC $PROFILES_DIR/$profile
                     elif [ "$blocklist_mode" != "disable" ]; then
                             $PARSER -rW $PROFILES_DIR/$profile
                             LoadedProfile_count=`expr $LoadedProfile_count + 1`
                     elif [ "$blocklist_mode" == "disable" ]; then
                           if [ "$process" != "global" ]; then
                             $PARSER -rWC $PROFILES_UNCONFINED_DIR/$profile
                           fi
                     fi
             elif [ "$mode" == "complain" ] && [ "$blocklist_mode" != "disable" ]; then
                     $PARSER -rWC $PROFILES_DIR/$profile
             fi
        fi
done<$Apparmor_defaults

/bin/systemd-notify --ready --status="apparmor profiles loaded"

list=`cat $SYSFS_AA_PATH | grep complain | awk '{print $1}' | tr '\n'  ','`
cnt=`cat $SYSFS_AA_PATH | grep complain | wc -l`
if [ ! -z "$list" ]; then
     echo "List of profiles in Apparmor-complain mode:$cnt : $list" >> $RDKLOGS
fi
list=`cat $SYSFS_AA_PATH | grep enforce | awk '{print $1}' | tr '\n'  ','`
cnt=`cat $SYSFS_AA_PATH | grep enforce | wc -l`
if [ ! -z "$list" ]; then
     echo "List of profiles in Apparmor-enforce mode:$cnt : $list"  >> $RDKLOGS
fi
if [ $LoadedProfile_count -ne $cnt ]; then
     echo "Mismatch in the number of loaded Apparmor profiles" >> $RDKLOGS
fi
if [ -f /etc/apparmor/aar_telemetry.sh ]; then
        /etc/apparmor/aar_telemetry.sh &
fi
