/*
 * drivers/amlogic/media/dtv_demod/dvbs.c
 *
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 */

#include "demod_func.h"
#include "dvbs.h"

static struct stchip_register_t l2a_def_val_local[] = {
	{0x200,    0x8c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKTFC2 */
	{0x201,    0x45,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKTFC1 */
	{0x202,    0xc9,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKTFC0 */
	{0x203,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKTDELTAF1 */
	{0x204,    0x37,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKTDELTAF0 */
	{0x205,    0x08,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKTCTRL */
	{0x206,    0x10,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRFC2 */
	{0x207,    0x45,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRFC1 */
	{0x208,    0xc9,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRFC0 */
	{0x209,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRK1 */
	{0x20a,    0x71,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRK2 */
	{0x20b,    0x28,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRAGCR */
	{0x20c,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRAGC */
	{0x20d,    0x13,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRALPHA */
	{0x20e,    0x90,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRPLTH1 */
	{0x20f,    0xbe,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRPLTH0 */
	{0x210,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRDF1 */
	{0x211,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRDF0 */
	{0x212,    0x58,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRSTEPP */
	{0x213,    0x6f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRSTEPM */
	{0x214,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRDET1 */
	{0x215,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRDET0 */
	{0x216,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRDTH1 */
	{0x217,    0xe9,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRDTH0 */
	{0x218,    0x4d,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRLOSS */
	{0x219,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRLEAK */
	{0x21a,    0x2a,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRAGCTH */
	{0x21b,    0x16,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRFINIIR */
	{0x21c,    0x04,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRFBIT1 */
	{0x21d,    0xbc,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRFBIT0 */
	{0x21e,    0x3c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRMINSTART */
	{0x21f,    0x8c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRMAXSTART */
	{0x220,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRPEAKDIF */
	{0x221,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRMINPK */
	{0x222,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRMAXPK */
	{0x223,    0x0a,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRFWDWN */
	{0x224,    0x32,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRFWTH */
	{0x225,    0x50,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRINITDEV */
	{0x226,    0x37,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRMINDEV */
	{0x227,    0x78,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRMAXDEV */
	{0x228,    0x40,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRMAXTERR */
	{0x229,    0x28,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRKTMG */
	{0x22a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRLOW */
	{0x22b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRHIGH */
	{0x22c,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRWORDVAL3 */
	{0x22d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRWORDVAL2 */
	{0x22e,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRWORDVAL1 */
	{0x22f,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRWORDVAL0 */
	{0x230,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRWORDMSK3 */
	{0x231,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRWORDMSK2 */
	{0x232,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRWORDMSK1 */
	{0x233,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRWORDMSK0 */
	{0x234,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRDELAYLG */
	{0x235,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRSTOPLG */
	{0x236,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRMESLG */
	{0x237,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FSK_FSKRCFG */
	/*{0x300,    0x00,    STCHIP_REGSIZE_8},*//* REG_RL2A_DVBSX_DISEQC_DISIRQCFG */
	/*{0x301,    0x00,    STCHIP_REGSIZE_8},*//* REG_RL2A_DVBSX_DISEQC_DISIRQSTAT */
	/*{0x302,    0x00,    STCHIP_REGSIZE_8},*//* REG_RL2A_DVBSX_DISEQC_DISTXCFG */
	/*{0x303,    0x20,    STCHIP_REGSIZE_8},*//* REG_RL2A_DVBSX_DISEQC_DISTXSTATUS */
	/*{0x304,    0x00,    STCHIP_REGSIZE_8},*//* REG_RL2A_DVBSX_DISEQC_DISTXBYTES */
	/*{0x305,    0x00,    STCHIP_REGSIZE_8},*//* REG_RL2A_DVBSX_DISEQC_DISTXFIFO */
	/*{0x306,    0xc0,    STCHIP_REGSIZE_8},*//* REG_RL2A_DVBSX_DISEQC_DISTXF22 */
	/*{0x307,    0x00,    STCHIP_REGSIZE_8},*//* REG_RL2A_DVBSX_DISEQC_DISTXWAIT */
	{0x308,    0x02,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISTIMEOCFG */
	{0x309,    0x8c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISTIMEOUT */
	{0x30a,    0x04,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXCFG */
	{0x30b,    0x04,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXSTAT1 */
	{0x30c,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXSTAT0 */
	{0x30d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXBYTES */
	{0x30e,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXPARITY1 */
	{0x30f,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXPARITY0 */
	{0x310,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXFIFO */
	{0x311,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXDC1 */
	{0x312,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXDC0 */
	{0x313,    0x62,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXKOFF */
	{0x314,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXF221 */
	{0x315,    0x2b,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXF220 */
	{0x316,    0xa9,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXF100 */
	{0x317,    0x31,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXK1 */
	{0x318,    0xb1,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXK2 */
	{0x319,    0xa8,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXPK */
	{0x31a,    0x46,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXENV */
	{0x31b,    0x0c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXVMIN */
	{0x31c,    0x0f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_DISRXSHORT22K */
	{0x31e,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_ACRPRESC */
	{0x31f,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQC_ACRDIV */
	{0x330,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQCTST_DISTBUS */
	{0x331,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQCTST_DISTSTCFG */
	{0x332,    0x55,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQCTST_DISPRBSEED */
	{0x333,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQCTST_DISPRBSCNT1 */
	{0x334,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQCTST_DISPRBSCNT0 */
	{0x335,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQCTST_DISRXSPYERR1 */
	{0x336,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQCTST_DISRXSPYERR0 */
	{0x337,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQCTST_DISRXSPYCNT1 */
	{0x338,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQCTST_DISRXSPYCNT0 */
	{0x339,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQCTST_DISRXPEAKMEAN1 */
	{0x33a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DISEQCTST_DISRXPEAKMEAN0 */
	{0x400,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF1 */
	{0x401,    0x1b,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF2 */
	{0x402,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF3 */
	{0x403,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF4 */
	{0x404,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF5 */
	{0x405,    0x1b,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF6 */
	{0x406,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF7 */
	{0x407,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF8 */
	{0x408,    0x18,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF9 */
	{0x409,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF10 */
	{0x40a,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF11 */
	{0x40b,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF12 */
	{0x40c,    0x1b,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF13 */
	{0x40d,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF14 */
	{0x40e,    0x18,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF15 */
	{0x40f,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF16 */
	{0x410,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF17 */
	{0x411,    0x1b,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF18 */
	{0x412,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF19 */
	{0x413,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF20 */
	{0x414,    0x18,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF21 */
	{0x415,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF22 */
	{0x416,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF23 */
	{0x417,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF24 */
	{0x418,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF25 */
	{0x419,    0x18,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF26 */
	{0x41a,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF27 */
	{0x41b,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF28 */
	{0x41c,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF1 */
	{0x41d,    0x1b,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF2 */
	{0x41e,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF3 */
	{0x41f,    0x1d,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF4 */
	{0x420,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF5 */
	{0x421,    0x1b,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF6 */
	{0x422,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF7 */
	{0x423,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF8 */
	{0x424,    0x1d,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF9 */
	{0x425,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF10 */
	{0x426,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF12 */
	{0x427,    0x1b,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF13 */
	{0x428,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF14 */
	{0x429,    0x1d,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF15 */
	{0x42a,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF16 */
	{0x42b,    0x1b,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF18 */
	{0x42c,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF19 */
	{0x42d,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF20 */
	{0x42e,    0x1d,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF21 */
	{0x42f,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF22 */
	{0x430,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF24 */
	{0x431,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF25 */
	{0x432,    0x1d,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF26 */
	{0x433,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF27 */
	{0x434,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF33_0 */
	{0x435,    0x17,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF33_1 */
	{0x436,    0x16,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF34_0 */
	{0x437,    0x16,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF34_1 */
	{0x438,    0x15,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF35_0 */
	{0x439,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF35_1 */
	{0x43a,    0x16,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF36_0 */
	{0x43b,    0x17,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF36_1 */
	{0x43c,    0x16,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF37_0 */
	{0x43d,    0x16,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF37_1 */
	{0x43e,    0x16,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF38_0 */
	{0x43f,    0x15,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF38_1 */
	{0x440,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF39_0 */
	{0x441,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF39_1 */
	{0x442,    0x17,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF40_0 */
	{0x443,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF40_1 */
	{0x444,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF41_0 */
	{0x445,    0x16,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF41_1 */
	{0x446,    0x17,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF42_0 */
	{0x447,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF42_1 */
	{0x448,    0x15,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF43_0 */
	{0x449,    0x1b,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF43_1 */
	{0x44a,    0x15,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF44_1 */
	{0x44b,    0x15,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF45_0 */
	{0x44c,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF45_1 */
	{0x44d,    0x15,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF46_0 */
	{0x44e,    0x15,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF46_1 */
	{0x44f,    0x16,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF47_1 */
	{0x450,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF48_1 */
	{0x451,    0x18,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF49_1 */
	{0x452,    0x16,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF50_0 */
	{0x453,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF50_1 */
	{0x454,    0x15,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF51_0 */
	{0x455,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF51_1 */
	{0x456,    0x15,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF52_0 */
	{0x457,    0x15,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF52_1 */
	{0x458,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF53_0 */
	{0x459,    0x16,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF53_1 */
	{0x45a,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF54_0 */
	{0x45b,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF54_1 */
	{0x45c,    0x1a,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF55_0 */
	{0x45d,    0x13,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF55_1 */
	{0x45e,    0x13,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF56_0 */
	{0x45f,    0x18,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF56_1 */
	{0x460,    0x13,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF57_0 */
	{0x461,    0x13,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF57_1 */
	{0x462,    0x15,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF58_0 */
	{0x463,    0x18,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF58_1 */
	{0x464,    0x13,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF59_0 */
	{0x465,    0x13,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF59_1 */
	{0x466,    0x15,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF60_0 */
	{0x467,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF60_1 */
	{0x468,    0x18,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF61_0 */
	{0x469,    0x1b,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF61_1 */
	{0x46a,    0x18,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF62_0 */
	{0x470,    0x02,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR13 */
	{0x471,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR12 */
	{0x472,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR11 */
	{0x473,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR10 */
	{0x474,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR9 */
	{0x475,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR8 */
	{0x476,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR7 */
	{0x477,    0x05,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR6 */
	{0x478,    0x5b,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR5 */
	{0x479,    0x96,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR4 */
	{0x47a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR3 */
	{0x47b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR2 */
	{0x47c,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR1 */
	{0x47d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR0 */
	{0x480,    0x18,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF1 */
	{0x481,    0x1c,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF2 */
	{0x482,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF3 */
	{0x483,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF4 */
	{0x484,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF5 */
	{0x485,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF6 */
	{0x486,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF7 */
	{0x487,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF8 */
	{0x488,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF9 */
	{0x489,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF10 */
	{0x48a,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF11 */
	{0x48b,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF12 */
	{0x48c,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF13 */
	{0x48d,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF14 */
	{0x48e,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF15 */
	{0x48f,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF16 */
	{0x490,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF17 */
	{0x491,    0x24,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF18 */
	{0x492,    0x24,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF19 */
	{0x493,    0x26,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF20 */
	{0x494,    0x26,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF21 */
	{0x495,    0x27,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF22 */
	{0x496,    0x29,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF23 */
	{0x497,    0x40,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF24 */
	{0x498,    0x50,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF25 */
	{0x499,    0x60,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF26 */
	{0x49a,    0x70,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF27 */
	{0x49b,    0x70,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF28 */
	{0x49c,    0x1C,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF1 */
	{0x49d,    0x1C,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF2 */
	{0x49e,    0x1E,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF3 */
	{0x49f,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF4 */
	{0x4a0,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF5 */
	{0x4a1,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF6 */
	{0x4a2,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF7 */
	{0x4a3,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF8 */
	{0x4a4,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF9 */
	{0x4a5,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF10 */
	{0x4a6,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF12 */
	{0x4a7,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF13 */
	{0x4a8,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF14 */
	{0x4a9,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF15 */
	{0x4aa,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF16 */
	{0x4ab,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF18 */
	{0x4ac,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF19 */
	{0x4ad,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF20 */
	{0x4ae,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF21 */
	{0x4af,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF22 */
	{0x4b0,    0x40,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF24 */
	{0x4b1,    0x50,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF25 */
	{0x4b2,    0x60,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF26 */
	{0x4b3,    0x70,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF27 */
	{0x4b4,    0x18,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF33_0 */
	{0x4b5,    0x1C,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF33_1 */
	{0x4b6,    0x1f,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF34_0 */
	{0x4b7,    0x1D,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF34_1 */
	{0x4b8,    0x1E,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF35_0 */
	{0x4b9,    0x1F,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF35_1 */
	{0x4ba,    0x22,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF36_0 */
	{0x4bb,    0x26,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF36_1 */
	{0x4bc,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF37_0 */
	{0x4bd,    0x1f,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF37_1 */
	{0x4be,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF38_0 */
	{0x4bf,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF38_1 */
	{0x4c0,    0x21,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF39_0 */
	{0x4c1,    0x26,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF39_1 */
	{0x4c2,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF40_0 */
	{0x4c3,    0x24,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF40_1 */
	{0x4c4,    0x2A,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF41_0 */
	{0x4c5,    0x25,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF41_1 */
	{0x4c6,    0x29,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF42_0 */
	{0x4c7,    0x30,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF42_1 */
	{0x4c8,    0x40,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF43_0 */
	{0x4c9,    0x45,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF43_1 */
	{0x4ca,    0x53,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF44_1 */
	{0x4cb,    0x57,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF45_0 */
	{0x4cc,    0x62,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF45_1 */
	{0x4cd,    0x71,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF46_0 */
	{0x4ce,    0x76,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF46_1 */
	{0x4cf,    0x83,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF47_1 */
	{0x4d0,    0x84,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF48_1 */
	{0x4d1,    0x84,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF49_1 */
	{0x4d2,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF50_0 */
	{0x4d3,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF50_1 */
	{0x4d4,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF51_0 */
	{0x4d5,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF51_1 */
	{0x4d6,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF52_0 */
	{0x4d7,    0x36,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF52_1 */
	{0x4d8,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF53_0 */
	{0x4d9,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF53_1 */
	{0x4da,    0x13,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF54_0 */
	{0x4db,    0x13,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF54_1 */
	{0x4dc,    0x1a,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF55_0 */
	{0x4dd,    0x1F,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF55_1 */
	{0x4de,    0x25,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF56_0 */
	{0x4df,    0x2B,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF56_1 */
	{0x4e0,    0x12,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF57_0 */
	{0x4e1,    0x18,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF57_1 */
	{0x4e2,    0x1F,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF58_0 */
	{0x4e3,    0x26,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF58_1 */
	{0x4e4,    0x1A,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF59_0 */
	{0x4e5,    0x1C,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF59_1 */
	{0x4e6,    0x1D,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF60_0 */
	{0x4e7,    0x1F,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF60_1 */
	{0x4e8,    0x29,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF61_0 */
	{0x4e9,    0x3B,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF61_1 */
	{0x4ea,    0x41,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF62_0 */
	{0x4f0,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GENCFG */
	{0x4f1,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_CFGEXT */
	{0x4f2,    0x02,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITERNOERR */
	{0x4f3,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_MODCOD */
	{0x4f4,    0x0c,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_DIFFDIV */
	{0x4f5,    0x33,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITERDIV */
	{0x4f6,    0x28,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBCYCLETRANSFER1 */
	{0x4f7,    0x86,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBCYCLETRANSFER2 */
	{0x4f8,    0x0a,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBCYCLETRANSFER3 */
	{0x4f9,    0x26,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBCYCLETRANSFER4 */
	{0x500,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER13 */
	{0x501,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER12 */
	{0x502,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER11 */
	{0x503,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER10 */
	{0x504,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER9 */
	{0x505,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER8 */
	{0x506,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER7 */
	{0x507,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER6 */
	{0x508,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER5 */
	{0x509,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER4 */
	{0x50a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER3 */
	{0x50b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER2 */
	{0x50c,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER1 */
	{0x50d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER0 */
	{0x510,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBFROVERFLOW */
	{0x511,    0x08,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBFR_CHECK */
	{0x520,    0x22,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_CONTROLLDPC */
	{0x521,    0x07,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_MAXEXTRAITER */
	{0x522,    0x08,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LGTHSTOPITER */
	{0x523,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBLAYERSTOP */
	{0x524,    0x02,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_THSTOP */
	{0x525,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_FRACTSET */
	{0x560,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCERR1 */
	{0x561,    0x1c,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCERR0 */
	{0x562,    0x1c,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_BCHERR */
	{0x563,    0x05,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_STATUSITER */
	{0x564,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_STATUSMAXITER */
	{0x565,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCSYND */
	{0x566,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCDBGINIT */
	{0x567,    0x07,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPRESYNDFAIL1 */
	{0x568,    0xb5,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPRESYNDFAIL2 */
	{0x569,    0x2f,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPRESYNDFAIL3 */
	{0x56a,    0xc4,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPRESYNDFAIL4 */
	{0x56b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPOSTSYNDFAIL1 */
	{0x56c,    0x0b,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPOSTSYNDFAIL2 */
	{0x56d,    0x6d,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPOSTSYNDFAIL3 */
	{0x56e,    0xc4,    STCHIP_REGSIZE_8},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPOSTSYNDFAIL4 */
	{0x899,    0x3b,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_RCDEBUG1 */
	{0x89a,    0x1b,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_RCDEBUG0 */
	{0x8a0,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_TSGENERAL */
	{0x8a1,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_TSGENCFG2 */
	{0x8a2,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_TSGSTATUS */
	{0x8a3,    0x0c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_TSRSCFG */
	{0x8a4,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_TSTTSRS */
	{0x8c0,    0x06,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_GCTRL */
	{0x8c1,    0xc8,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_FFTCTRL */
	{0x8c2,    0x0a,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_FFTACC */
	{0x8c3,    0x04,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_THRESHOLD */
	{0x8c4,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_GAINCONT */
	{0x8c5,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_UPDCONT */
	{0x8c6,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_GSTAT */
	{0x8c7,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_EXPMAX */
	{0x8c8,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_BINMAX1 */
	{0x8c9,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_BINMAX0 */
	{0x8ca,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX2 */
	{0x8cb,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX1 */
	{0x8cc,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX0 */
	{0x8cd,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_BINMAX21 */
	{0x8ce,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_BINMAX20 */
	{0x8cf,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX22 */
	{0x8d0,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX21 */
	{0x8d1,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX20 */
	{0x8d2,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_BINMAX31 */
	{0x8d3,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_BINMAX30 */
	{0x8d4,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX32 */
	{0x8d5,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX31 */
	{0x8d6,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX30 */
	{0x8d7,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_CPTACC */
	{0x8d8,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_CTESTAT */
	{0x8da,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_CFOEST1 */
	{0x8db,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_CFOEST0 */
	{0x8ec,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_DEBUG1 */
	{0x8ed,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMADDR1 */
	{0x8ee,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMADDR0 */
	{0x8ef,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMSTAT */
	{0x8f0,    0xda,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA01 */
	{0x8f1,    0x12,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA00 */
	{0x8f2,    0xda,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA11 */
	{0x8f3,    0x12,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA10 */
	{0x8f4,    0xda,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA21 */
	{0x8f5,    0x12,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA20 */
	{0x8f6,    0xda,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA31 */
	{0x8f7,    0x12,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA30 */
	{0x8f8,    0xda,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA41 */
	{0x8f9,    0x12,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA40 */
	{0x8fa,    0xda,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA51 */
	{0x8fb,    0x12,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA50 */
	{0x8fc,    0xda,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA61 */
	{0x8fd,    0x12,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA60 */
	{0x8fe,    0xda,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA71 */
	{0x8ff,    0x12,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA70 */
	{0x900,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_IQCONST */
	{0x901,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_IQOPTION */
	{0x902,    0xe5,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_ISYMB */
	{0x903,    0xe0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_QSYMB */
	{0x910,    0x54,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1CFG */
	{0x911,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1RFN */
	{0x912,    0x99,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1CN */
	{0x913,    0x58,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1REF */
	{0x914,    0xe2,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1IDCCOMP */
	{0x915,    0xf1,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1QDCCOMP */
	{0x916,    0x43,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1POWERI */
	{0x917,    0x34,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1POWERQ */
	{0x918,    0x0e,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1AMM */
	{0x919,    0x05,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1QUAD */
	{0x91a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1IQIN1 */
	{0x91b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1IQIN0 */
	{0x91c,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1SHDB */
	{0x91d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1OPT */
	{0x920,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DEMOD */
	/* REG_RL2A_DVBSX_DEMOD_DMDCFGMD, important dvbs/s2/s2x auto search */
	{0x922,    0xcc,    STCHIP_REGSIZE_8},
	{0x923,    0x3b,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDCFG2 */
	{0x924,    0x15,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDISTATE */
	{0x925,    0x40,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDT0M */
	{0x926,    0xc0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDT0L */
	{0x927,    0x99,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDT1M */
	{0x928,    0xee,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDT1L */
	{0x929,    0x08,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDCFG3 */
	{0x92a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDCFG4 */
	{0x92b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDCFG5 */
	{0x930,    0x03,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDMODCOD */
	{0x931,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDPLFNUM */
	{0x932,    0x09,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDSTATE */
	{0x933,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDFLYW */
	{0x934,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DSTATUS */
	{0x935,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DSTATUS2 */
	{0x936,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DSTATUS3 */
	{0x937,    0x60,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DSTATUS4 */
	{0x938,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DSTATUS5 */
	{0x939,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DSTATUS6 */
	{0x93a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDERRORS */
	{0x940,    0x15,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_HDEBITCFG2 */
	{0x941,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_HDEBITCFG1 */
	{0x942,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_HDEBITCFG0 */
	{0x943,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DSAMPDLY */
	{0x944,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DSYMBDLY */
	{0x948,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SHDBFIFO21 */
	{0x949,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SHDBFIFO20 */
	{0x94a,    0x21,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SHDBPARAL */
	{0x950,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SLICEADR */
	{0x951,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SLICEDATA */
	{0x952,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SLICECFG */
	{0x953,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SLICENBR */
	{0x954,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SLICESYMB2 */
	{0x955,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SLICESYMB1 */
	{0x956,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SLICESYMB0 */
	{0x957,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SLICERATIO */
	{0x958,    0x73,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SLICESTAT */
	{0x959,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SLICEMAX */
	{0x95a,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SLICEMIN */
	{0x95b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SLICESEL */
	{0x95c,    0x05,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SLICEANC */
	{0x95d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DEMODAUX */
	{0x95e,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_HDEBITCFG4 */
	{0x970,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_FILTCFGM */
	{0x971,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_FILTCFGL */
	{0x972,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_IQFILT0 */
	{0x973,    0x40,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_IQFILT1 */
	{0x974,    0x40,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_IQFILT2 */
	{0x975,    0x40,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_IQFILT3 */
	/* REG_RL2A_DVBSX_DEMOD_CORRELMANT, 0x58 for tracking low CNR, 0x8C for acqusisiton */
	{0x980,    0x8C,    STCHIP_REGSIZE_8},
	{0x981,    0x60,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CORRELABS */
	{0x982,    0x40,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CORRELABSM */
	{0x983,    0xaa,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CORRELEXP */
	{0x984,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CORRELCOEF */
	{0x985,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CORRELCFG */
	{0x986,    0x70,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CORRELFREQ */
	{0x987,    0x02,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLHMODCOD */
	{0x988,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDREG */
	{0x990,    0x5b,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC2O */
	{0x991,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC2REF */
	{0x992,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGCNADJ */
	{0x993,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGCKS */
	{0x994,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGCRSADJ */
	{0x995,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGCRQ8ADJ */
	{0x996,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGCR1ADJ */
	{0x997,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGCR2ADJ */
	{0x998,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGCR3ADJ */
	{0x999,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGCR4ADJ */
	{0x99a,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGCR5ADJ */
	{0x99b,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGCR6ADJ */
	{0x99c,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGCR7ADJ */
	{0x99d,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGCR8ADJ */
	{0x99e,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGCR1BADJ */
	{0x99f,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC2ADJ */
	{0x9a0,    0x6e,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC2I1 */
	{0x9a1,    0x04,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC2I0 */
	{0x9a2,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC2IMP */
	{0x9a3,    0x58,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC1ADJ */
	{0x9a4,    0x96,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC2R10DB */
	{0x9a5,    0xb8,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC2R20DB */
	{0x9a6,    0xc9,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC2AMPL */
	{0x9a7,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC2VAR */
	{0x9a8,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_AGC2RATIO */
	{0x9b0,    0xc6,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CARCFG */
	{0x9b1,    0x2a,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_ACLCNLK */
	{0x9b2,    0x18,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_BCLCNLK */
	{0x9b3,    0x28,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_ACLCLK */
	{0x9b4,    0x18,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_BCLCLK */
	{0x9b5,    0x79,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CARFREQ */
	{0x9b6,    0x04,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CARHDR */
	{0x9b7,    0xd0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_LDT */
	{0x9b8,    0xb8,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_LDT2 */
	{0x9b9,    0xf8,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRICFG */
	{0x9ba,    0x67,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR1BCFG */
	{0x9bb,    0xe9,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRULB1 */
	{0x9bc,    0x7c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRULB0 */
	{0x9bd,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRCNTR2 */
	{0x9be,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRCNTR1 */
	{0x9bf,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRCNTR0 */
	{0x9c0,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRIBASE2 */
	{0x9c1,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRIBASE1 */
	{0x9c2,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRIBASE0 */
	{0x9c3,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRINIT2 */
	{0x9c4,    0x33,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRINIT1 */
	{0x9c5,    0x3c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRINIT0 */
	{0x9c6,    0x0c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRUP2 */
	{0x9c7,    0xcc,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRUP1 */
	{0x9c8,    0x46,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRUP0 */
	{0x9c9,    0xf3,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRLOW2 */
	{0x9ca,    0x33,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRLOW1 */
	{0x9cb,    0xba,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRLOW0 */
	{0x9cc,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRINC2 */
	{0x9cd,    0x99,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRINC1 */
	{0x9ce,    0x88,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFRINC0 */
	{0x9cf,    0xfc,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR12 */
	{0x9d0,    0x70,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR11 */
	{0x9d1,    0x8b,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR10 */
	{0x9d2,    0xbb,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_LDI */
	{0x9d3,    0xfc,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR1F2 */
	{0x9d4,    0x70,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR1F1 */
	{0x9d5,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR1F0 */
	{0x9d6,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR1G */
	{0x9d7,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR1B2 */
	{0x9d8,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR1B1 */
	{0x9d9,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR1B0 */
	{0x9da,    0x98,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_GAUSSR0 */
	{0x9db,    0x30,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CCIR0 */
	{0x9dc,    0xac,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CCIQUANT */
	{0x9dd,    0x50,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CCITHRES */
	{0x9de,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CCIACC */
	{0x9e0,    0xd3,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TMGCFG */
	{0x9e1,    0x88,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_RTCNLK */
	{0x9e2,    0x33,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_RTCLK */
	{0x9e3,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TMGTHRISE */
	{0x9e4,    0x08,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TMGTHFALL */
	{0x9e5,    0x30,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFRUPRATIO */
	{0x9e6,    0xf0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFRLOWRATIO */
	{0x9e7,    0xa0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_KTTMG */
	{0x9e8,    0xf5,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_KREFTMG */
	{0x9e9,    0x88,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFRSTEP */
	{0x9ea,    0x40,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TMGCFG2 */
	{0x9eb,    0x50,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_KREFTMG2 */
	{0x9ec,    0x06,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TMGCFG3 */
	{0x9ed,    0x91,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TMGMTHRES */
	//{0x9f0,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFRINIT2 */
	//{0x9f1,    0x98,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFRINIT1 */
	//{0x9f2,    0x8d,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFRINIT0 */
	{0x9f3,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFRUP2 */
	{0x9f4,    0xfe,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFRUP1 */
	{0x9f5,    0xf9,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFRUP0 */
	{0x9f6,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFRLOW2 */
	{0x9f7,    0x4b,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFRLOW1 */
	{0x9f8,    0xca,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFRLOW0 */
	{0x9fc,    0x19,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFR3 */
	//{0x9fd,    0x98,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFR2 */
	//{0x9fe,    0x8d,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFR1 */
	//{0x9ff,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SFR0 */
	{0xa00,    0xfd,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TMGREG2 */
	{0xa01,    0x30,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TMGREG1 */
	{0xa02,    0x08,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TMGREG0 */
	{0xa03,    0x04,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TMGLOCK1 */
	{0xa04,    0x24,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TMGLOCK0 */
	{0xa05,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TMGOBS */
	{0xa06,    0x7f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDCODSFR2 */
	{0xa07,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDCODSFR1 */
	{0xa08,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDCODSFR0 */
	{0xa10,    0x41,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DFECFG */
	{0xa11,    0x41,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_FFECFG */
	{0xa12,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_XFECFG */
	{0xa13,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_XFECFG2 */
	{0xa14,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PEGALCFG */
	{0xa15,    0x42,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_WDFECFG */
	{0xa16,    0x91,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_WDFERCFG */
	{0xa17,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_WDFERAMPOS */
	{0xa18,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_WDFERAMI */
	{0xa19,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_WDFERAMQ */
	{0xa1a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_WDFEROBS */
	{0xa1b,    0x89,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DFESTNBR */
	{0xa1c,    0x04,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_FFESTNBR */
	{0xa20,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI1 */
	{0xa21,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ1 */
	{0xa22,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI2 */
	{0xa23,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ2 */
	{0xa24,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI3 */
	{0xa25,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ3 */
	{0xa26,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI4 */
	{0xa27,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ4 */
	{0xa28,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI5 */
	{0xa29,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ5 */
	{0xa2a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI6 */
	{0xa2b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ6 */
	{0xa2c,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI7 */
	{0xa2d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ7 */
	{0xa2e,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI8 */
	{0xa2f,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ8 */
	{0xa30,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_FFEI1 */
	{0xa31,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_FFEQ1 */
	{0xa32,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_FFEI2 */
	{0xa33,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_FFEQ2 */
	{0xa34,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_FFEI3 */
	{0xa35,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_FFEQ3 */
	{0xa36,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_FFEI4 */
	{0xa37,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_FFEQ4 */
	{0xa38,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_FFEI5 */
	{0xa39,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_FFEQ5 */
	{0xa40,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI9 */
	{0xa41,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ9 */
	{0xa42,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI10 */
	{0xa43,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ10 */
	{0xa44,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI11 */
	{0xa45,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ11 */
	{0xa46,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI12 */
	{0xa47,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ12 */
	{0xa48,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI13 */
	{0xa49,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ13 */
	{0xa4a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI14 */
	{0xa4b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ14 */
	{0xa4c,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI15 */
	{0xa4d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ15 */
	{0xa4e,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAI16 */
	{0xa4f,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_EQUAQ16 */
	{0xa60,    0x06,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CAR2CFG */
	{0xa61,    0x23,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR2CFR1 */
	{0xa62,    0xc0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CAR3CFG */
	{0xa63,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR22 */
	{0xa64,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR21 */
	{0xa65,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR20 */
	{0xa68,    0x48,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_ACLC2S1 */
	{0xa69,    0x48,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_ACLC2S2Q */
	{0xa6a,    0x48,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_ACLC2S28 */
	{0xa6b,    0x48,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_ACLC2S216A */
	{0xa6c,    0x48,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_ACLC2S232A */
	{0xa6d,    0x48,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_ACLC2S264A */
	{0xa6e,    0x48,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_ACLC2S2128A */
	{0xa6f,    0x48,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_ACLC2S2256A */
	{0xa70,    0xc8,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S1 */
	{0xa71,    0xc6,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S2Q */
	{0xa72,    0xc8,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S28 */
	{0xa73,    0xc8,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S216A */
	{0xa74,    0xc8,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S232A */
	{0xa75,    0xc8,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S264A */
	{0xa76,    0xc8,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S2128A */
	{0xa77,    0xc8,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S2256A */
	{0xa84,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NCO2MAX1 */
	{0xa85,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NCO2MAX0 */
	{0xa86,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NCO2FR1 */
	{0xa87,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NCO2FR0 */
	{0xa88,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR2AVRGE1 */
	{0xa89,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CFR2AVRGE0 */
	{0xa8a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DPILOTMAX1 */
	{0xa8b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DPILOTMAX0 */
	{0xa98,    0x2c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NOSCFG */
	{0xa99,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NOSCFGF1 */
	{0xa9a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NOSCFGF2 */
	{0xaa0,    0x25,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NNOSDATAT1 */
	{0xaa1,    0xcf,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NNOSDATAT0 */
	{0xaa2,    0x17,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NNOSDATA1 */
	{0xaa3,    0xb9,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NNOSDATA0 */
	{0xaa4,    0x24,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NNOSPLHT1 */
	{0xaa5,    0xa6,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NNOSPLHT0 */
	{0xaa6,    0x1b,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NNOSPLH1 */
	{0xaa7,    0xf8,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NNOSPLH0 */
	{0xaa8,    0x22,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NOSDATAT1 */
	{0xaa9,    0x0c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NOSDATAT0 */
	{0xaaa,    0x1b,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NNOSFRAME1 */
	{0xaab,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NNOSFRAME0 */
	{0xaac,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NNOSRAD1 */
	{0xaad,    0x7f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NNOSRAD0 */
	{0xaae,    0x1e,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NOSRAMCNR1 */
	{0xaaf,    0x86,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NOSRAMCNR0 */
	{0xac0,    0x60,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NOSTHRES1 */
	{0xac1,    0x69,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NOSTHRES2 */
	{0xac2,    0xd3,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NOSDIFF1 */
	{0xac3,    0x35,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_RAINFADE */
	{0xac4,    0x28,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NOSRAMCFG */
	{0xac5,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NOSRAMPOS */
	{0xac6,    0x09,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_NOSRAMVAL */
	{0xad0,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SOFCODE3 */
	{0xad1,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SOFCODE2 */
	{0xad2,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SOFCODE1 */
	{0xad3,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SOFCODE0 */
	{0xad4,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB7 */
	{0xad5,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB6 */
	{0xad6,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB5 */
	{0xad7,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB4 */
	{0xad8,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB3 */
	{0xad9,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB2 */
	{0xada,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB1 */
	{0xadb,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB0 */
	{0xadc,    0x70,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMBB */
	{0xadd,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMBA */
	{0xade,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB9 */
	{0xadf,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB8 */
	{0xae0,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB7 */
	{0xae1,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB6 */
	{0xae2,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB5 */
	{0xae3,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB4 */
	{0xae4,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB3 */
	{0xae5,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB2 */
	{0xae6,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB1 */
	{0xae7,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB0 */
	{0xaec,    0x24,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLROOT2 */
	{0xaed,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLROOT1 */
	{0xaee,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLROOT0 */
	{0xb00,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLST0 */
	{0xb01,    0xcc,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLST1 */
	{0xb02,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLST2 */
	{0xb03,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLST3 */
	{0xb04,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLST4 */
	{0xb05,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLST5 */
	{0xb06,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLST6 */
	{0xb07,    0xc0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLST7 */
	{0xb08,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLST8 */
	{0xb09,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLST9 */
	{0xb0a,    0xc0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLSTA */
	{0xb0b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLSTB */
	{0xb0c,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLSTC */
	{0xb0d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLSTD */
	{0xb0e,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLSTE */
	{0xb0f,    0x0f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLSTF */
	{0xb10,    0xfc,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS10 */
	{0xb11,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS11 */
	{0xb12,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS12 */
	{0xb13,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS13 */
	{0xb14,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS14 */
	{0xb15,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS15 */
	{0xb16,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS16 */
	{0xb17,    0x33,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS17 */
	{0xb18,    0x30,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS18 */
	{0xb19,    0x03,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS19 */
	{0xb1a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS1A */
	{0xb1b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS1B */
	{0xb1c,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS1C */
	{0xb1d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS1D */
	{0xb1e,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS1E */
	{0xb1f,    0x0f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODLS1F */
	{0xb20,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODCH3 */
	{0xb21,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODCH2 */
	{0xb22,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODCH1 */
	{0xb23,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_MODCODCHM */
	{0xb24,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDRESCFG */
	{0xb25,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDRESADR */
	{0xb26,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA7 */
	{0xb27,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA6 */
	{0xb28,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA5 */
	{0xb29,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA4 */
	{0xb2a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA3 */
	{0xb2b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA2 */
	{0xb2c,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA1 */
	{0xb2d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA0 */
	{0xb2e,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA8 */
	{0xb2f,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA9 */
	{0xb30,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TNRCFG */
	{0xb31,    0x02,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TNRCFG2 */
	{0xb80,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF7 */
	{0xb81,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF6 */
	{0xb82,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF5 */
	{0xb83,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF4 */
	{0xb84,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF3 */
	{0xb85,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF2 */
	{0xb86,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF1 */
	{0xb87,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF0 */
	{0xb88,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SDEMAP */
	{0xb89,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEFM2 */
	{0xb8a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEFM1 */
	{0xb8b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEFM0 */
	{0xba0,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_LLROBS5 */
	{0xba1,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_LLROBS4 */
	{0xba2,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_LLROBS3 */
	{0xba3,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_LLROBS2 */
	{0xba4,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_LLROBS1 */
	{0xba5,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_LLROBS0 */
	{0xba6,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_LLROBSCFG */
	{0xbb0,    0xf3,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDPLHSTAT */
	{0xbb1,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDSELOBS */
	{0xbb2,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_LOCKTIME3 */
	{0xbb3,    0x8d,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_LOCKTIME2 */
	{0xbb4,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_LOCKTIME1 */
	{0xbb5,    0x1c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_LOCKTIME0 */
	{0xbc0,    0x04,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CALCFG */
	{0xbc1,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CALADDR */
	{0xbc2,    0x09,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CALSTART */
	{0xbc3,    0x3f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CALMASK */
	{0xbc4,    0x0e,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CALSTOP */
	{0xbc5,    0x1f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CALOBS */
	{0xbc6,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CALRESINC */
	{0xbc7,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CALRESDEC */
	{0xbc8,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_CALRLIST */
	{0xbe0,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLHCCMP1 */
	{0xbe1,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLHCCMP0 */
	{0xbe2,    0x0f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDTIMER */
	{0xbe3,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DMDATTEMPT */
	{0xbe4,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLFHEADER1 */
	{0xbe5,    0xbb,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLFHEADER0 */
	{0xbe6,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLHSFRDIFF1 */
	{0xbe7,    0x40,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLHSFRDIFF0 */
	{0xbe8,    0x0c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLHRCMP1 */
	{0xbe9,    0x3e,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLHRCMP0 */
	{0xbea,    0x06,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLHRECORD1 */
	{0xbeb,    0xf4,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLHRECORD0 */
	{0xbec,    0x07,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLHRECNCO1 */
	{0xbed,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLHRECNCO0 */
	{0xbee,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLHDELTAF1 */
	{0xbef,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLHDELTAF0 */
	{0xc00,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PHERRCMP5 */
	{0xc01,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PHERRCMP4 */
	{0xc02,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PHERRCMP3 */
	{0xc03,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PHERRCMP2 */
	{0xc04,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PHERRCMP1 */
	{0xc05,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PHERRCMP0 */
	{0xc06,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_PLHDEBUG */
	{0xcc0,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TSTDMD */
	{0xcc1,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TPOLY */
	{0xcc2,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TSTR */
	{0xcc3,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TAGC2 */
	{0xcc4,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TCTL1 */
	{0xcc5,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TCTL2 */
	{0xcc6,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TCTL3 */
	{0xcc8,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TCTL4 */
	{0xcc9,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TSTCAR3 */
	{0xcca,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_TSTHDEBIT */
	{0xcf0,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_DEMOD_DEMODEND */
	{0xd00,    0x38,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_SIGPOWER */
	{0xd01,    0x32,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_DEMAPVIT */
	{0xd02,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_VITSCALE */
	{0xd03,    0x10,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_FECM */
	{0xd04,    0xd7,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_VTH12 */
	{0xd05,    0x85,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_VTH23 */
	{0xd06,    0x58,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_VTH34 */
	{0xd07,    0x3a,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_VTH56 */
	{0xd08,    0x34,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_VTH67 */
	{0xd09,    0x28,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_VTH78 */
	{0xd0a,    0xbf,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_PRVIT */
	{0xd0b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_VAVSRVIT */
	{0xd10,    0x32,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_VITCURPUN */
	{0xd11,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_VERROR */
	{0xd12,    0x7f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_VITCNR */
	{0xd13,    0x85,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_VTHINUSE */
	{0xd14,    0x24,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_VSTATUSVIT */
	{0xd18,    0x27,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_KDIV12 */
	{0xd19,    0x32,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_KDIV23 */
	{0xd1a,    0x32,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_KDIV34 */
	{0xd1b,    0x32,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_KDIV56 */
	{0xd1c,    0x32,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_KDIV67 */
	{0xd1d,    0x50,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_KDIV78 */
	{0xd20,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_SELOUT */
	{0xd21,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_TSYNC */
	{0xd22,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_VITERBI_TSTERR */
	{0xd80,    0xb0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_SUPERFEC_SFAVSR */
	{0xd81,    0x22,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_SUPERFEC_SFDEMAP */
	{0xd82,    0xcc,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_SUPERFEC_SFERROR */
	{0xd83,    0x14,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_SUPERFEC_SFECCNR */
	{0xd84,    0x1f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_SUPERFEC_SFKDIV12 */
	{0xd85,    0x22,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_SUPERFEC_SFKDIV23 */
	{0xd86,    0x24,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_SUPERFEC_SFKDIV34 */
	{0xd87,    0x24,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_SUPERFEC_SFKDIV56 */
	{0xd88,    0x29,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_SUPERFEC_SFKDIV67 */
	{0xd89,    0x2c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_SUPERFEC_SFKDIV78 */
	{0xd8a,    0x08,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_SUPERFEC_SFECSTATUS */
	{0xd8d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_SUPERFEC_TSTSFMET */
	{0xd8e,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_SUPERFEC_TSFSYNC */
	{0xd8f,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_SUPERFEC_TSTSFERR */
	{0xe00,    0xf0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSSTATE1 */
	{0xe01,    0x12,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSSTATE0 */
	{0xe02,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSCFG2 */
	{0xe03,    0x04,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSCFG1 */
	/* change value from 0x20 to 0xa0 to support CI+ card */
	{0xe04,    0xa0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSCFG0 */
	{0xe05,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSSYNC */
	{0xe06,    0x03,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSDIVN */
	{0xe07,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSCFG4 */
	{0xe08,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSHEMCFG */
	{0xe09,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSCPLPCFG */
	{0xe0a,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSPCRCFG */
	{0xe0b,    0x1f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSPCRPID1 */
	{0xe0c,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSPCRPID0 */
	{0xe0d,    0x84,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSNCRCFG */
	{0xe0e,    0x1f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSNCRPID1 */
	{0xe0f,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSNCRPID0 */
	{0xe10,    0xe0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSNCRADJ2 */
	{0xe11,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSNCRADJ1 */
	{0xe12,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSNCRADJ0 */
	{0xe13,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSPIDFLTM */
	{0xe14,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSPIDFLTL */
	{0xe15,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSPIDFLTC */
	{0xe16,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSDLYSET2 */
	{0xe17,    0x93,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSDLYSET1 */
	{0xe18,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSDLYSET0 */
	{0xe19,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSINSDELH */
	{0xe1a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSINSDELM */
	{0xe1b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSINSDELL */
	{0xe1c,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSCFG5 */
	{0xe1d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSCFG6 */
	{0xe1e,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSPIDFLTD */
	{0xe1f,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSSAMPDLY */
	{0xe20,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSMINSPEED */
	{0xe21,    0x04,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSMAXSPEED */
	{0xe22,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSSPEED */
	{0xe24,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSDILSTK1 */
	{0xe25,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSDILSTK0 */
	{0xe26,    0x52,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSSTATUS */
	{0xe27,    0x28,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSSTATUS2 */
	{0xe28,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSSTATUS3 */
	{0xe29,    0x0f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSMODCOD1 */
	{0xe2a,    0x10,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSMODCOD0 */
	{0xe30,    0x0c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSBITRATE1 */
	{0xe31,    0xdc,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSBITRATE0 */
	{0xe32,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSPACKLEN1 */
	{0xe33,    0xed,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSPACKLEN0 */
	{0xe34,    0x7f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSBLOCLEN1 */
	{0xe35,    0x44,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSBLOCLEN0 */
	{0xe36,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSDLY2 */
	{0xe37,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSDLY1 */
	{0xe38,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSDLY0 */
	{0xe39,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_ISCRUNIT2 */
	{0xe3a,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_ISCRUNIT1 */
	{0xe3b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_ISCRUNIT0 */
	{0xe3c,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSNPDAV */
	{0xe3d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSBUFSTAT2 */
	{0xe3e,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSBUFSTAT1 */
	{0xe3f,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSBUFSTAT0 */
	{0xe40,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSXCROBS1 */
	{0xe41,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSXCROBS0 */
	{0xe42,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSPCR272 */
	{0xe43,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSPCR271 */
	{0xe44,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSPCR270 */
	{0xe50,    0x48,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSDEBUG1 */
	{0xe51,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSDEBUG0 */
	{0xe52,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSOBSCFG */
	{0xe53,    0x47,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSOBS1 */
	{0xe54,    0x1f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSOBS0 */
	{0xe60,    0x35,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_ERRCTRL1 */
	{0xe61,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_ERRCNT12 */
	{0xe62,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_ERRCNT11 */
	{0xe63,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_ERRCNT10 */
	{0xe64,    0xc1,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_ERRCTRL2 */
	{0xe65,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_ERRCNT22 */
	{0xe66,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_ERRCNT21 */
	{0xe67,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_ERRCNT20 */
	{0xe70,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSTTS1 */
	{0xe71,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSTTS2 */
	{0xe72,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSTTS3 */
	{0xe73,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSTTS4 */
	{0xe74,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSTTS5 */
	{0xe75,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSTTS6 */
	{0xe76,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSTTS7 */
	{0xe77,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSTCPLP */
	{0xe80,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSCFG */
	{0xe81,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSSTAT */
	{0xe82,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSSTART5 */
	{0xe83,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSSTART4 */
	{0xe84,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSSTART3 */
	{0xe85,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSSTART2 */
	{0xe86,    0x02,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSSTART1 */
	{0xe87,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSSTART0 */
	{0xe88,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSEND5 */
	{0xe89,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSEND4 */
	{0xe8a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSEND3 */
	{0xe8b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSEND2 */
	{0xe8c,    0x02,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSEND1 */
	{0xe8d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSEND0 */
	{0xe8f,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSPRE */
	{0xe90,    0x66,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSTIME5 */
	{0xe91,    0x0b,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSTIME4 */
	{0xe92,    0x11,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSTIME3 */
	{0xe93,    0xe2,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSTIME2 */
	{0xe94,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSTIME1 */
	{0xe95,    0xd9,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSRCSTIME0 */
	{0xec0,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFDILSTK1 */
	{0xec1,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFDILSTK0 */
	{0xec2,    0x46,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFSTATUS */
	{0xec3,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFDLY2 */
	{0xec4,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFDLY1 */
	{0xec5,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFDLY0 */
	{0xec6,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFDLYSET2 */
	{0xec7,    0x6b,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFDLYSET1 */
	{0xec8,    0x64,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFDLYSET0 */
	{0xec9,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFOBSCFG */
	{0xeca,    0x47,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFOBS1 */
	{0xecb,    0x05,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFOBS0 */
	{0xecc,    0x30,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFECINFO */
	{0xed0,    0x94,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFERRCTRL */
	{0xed1,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFERRCNT2 */
	{0xed2,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFERRCNT1 */
	{0xed3,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_SFERRCNT0 */
	{0xed8,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSTTSSF1 */
	{0xed9,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSTTSSF2 */
	{0xeda,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_HWARE_TSTTSSF3 */
	{0xf00,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_PDELCTRL0 */
	{0xf01,    0x20,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_PDELCTRL1 */
	{0xf02,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_PDELCTRL2 */
	{0xf03,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_PDELCTRL3 */
	{0xf04,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_PDELCTRL4 */
	{0xf05,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_BBHCTRL1 */
	{0xf06,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_BBHCTRL2 */
	{0xf07,    0x41,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_HYSTTHRESH */
	{0xf08,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_ISIENTRY */
	{0xf09,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_ISIBITENA */
	{0xf0c,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_PDELDBGM */
	{0xf0d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_PDELDBGL */
	{0xf10,    0xf0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_MATCST1 */
	{0xf11,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_MATCST0 */
	{0xf12,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_UPLCST1 */
	{0xf13,    0x77,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_UPLCST0 */
	{0xf14,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_DFLCST1 */
	{0xf15,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_DFLCST0 */
	{0xf16,    0x47,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_SYNCCST */
	{0xf17,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_SYNCDCST1 */
	{0xf18,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_SYNCDCST0 */
	{0xf20,    0xf0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_MATSTR1 */
	{0xf21,    0xe0,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_MATSTR0 */
	{0xf22,    0x05,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_UPLSTR1 */
	{0xf23,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_UPLSTR0 */
	{0xf24,    0x7d,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_DFLSTR1 */
	{0xf25,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_DFLSTR0 */
	{0xf26,    0x47,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_SYNCSTR */
	{0xf27,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_SYNCDSTR1 */
	{0xf28,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_SYNCDSTR0 */
	{0xf29,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_ISIMAXSTR */
	{0xf2a,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_ISIMINSTR */
	{0xf30,    0x9c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_PDELSTATUS1 */
	{0xf31,    0x10,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_PDELSTATUS2 */
	{0xf32,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_PDELSTATUS3 */
	{0xf34,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_BBFCRCKO1 */
	{0xf35,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_BBFCRCKO0 */
	{0xf36,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_UPCRCKO1 */
	{0xf37,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_UPCRCKO0 */
	{0xf3f,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_PKTDELIN_TPKTDELIN */
	{0xf80,    0x88,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FECSPY */
	{0xf81,    0x2c,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYCFG */
	{0xf82,    0xba,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYDATA */
	{0xf83,    0x06,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYOUT */
	{0xf84,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYBER */
	{0xf85,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYOPT */
	{0xf88,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSTATUS */
	{0xf89,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FGOODPACK */
	{0xf8a,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FPACKCNT */
	{0xf8b,    0xe9,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYMISC */
	{0xf8c,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSTATES1 */
	{0xf8d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSTATES0 */
	{0xf90,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FBERCPT4 */
	{0xf91,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FBERCPT3 */
	{0xf92,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FBERCPT2 */
	{0xf93,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FBERCPT1 */
	{0xf94,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FBERCPT0 */
	{0xf95,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FBERERR2 */
	{0xf96,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FBERERR1 */
	{0xf97,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FBERERR0 */
	{0xf98,    0x02,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYDIST1 */
	{0xf99,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYDIST0 */
	{0xf9a,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYPCR1 */
	{0xf9b,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYPCR0 */
	{0xf9c,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYNCR1 */
	{0xf9d,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYNCR0 */
	{0xfa0,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS7 */
	{0xfa1,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS6 */
	{0xfa2,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS5 */
	{0xfa3,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS4 */
	{0xfa4,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS3 */
	{0xfa5,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS2 */
	{0xfa6,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS1 */
	{0xfa7,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS0 */
	{0xfae,    0x10,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVDESCM */
	{0xfaf,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVDESCL */
	{0xfb0,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVOBS3 */
	{0xfb1,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVOBS2 */
	{0xfb2,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVOBS1 */
	{0xfb3,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVOBS0 */
	{0xfb4,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVCFG */
	{0xfb5,    0x01,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVPID1 */
	{0xfb6,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVPID0 */
	{0xfb7,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVCFG2 */
	{0xfb8,    0x80,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVMAX1 */
	{0xfb9,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVMAX0 */
	{0xfba,    0x7f,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVMIN1 */
	{0xfbb,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVMIN0 */
	{0xfbc,    0xff,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVABS1 */
	{0xfbd,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVABS0 */
	{0xfbe,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVCPT1 */
	{0xfbf,    0x00,    STCHIP_REGSIZE_8},/* REG_RL2A_DVBSX_FECSPY_NCRVCPT0 */
	{0xffff,    0,    0},/*table end*/
};

void demod_init_local(void)
{
	unsigned int reg = 0;

	do {
		if (l2a_def_val_local[reg].addr == 0xffff)
			break;

		dvbs_wr_byte(l2a_def_val_local[reg].addr,
			     l2a_def_val_local[reg].value);
		reg++;
	} while (1);
}

void dvbs2_reg_initial(unsigned int symkb_rate)
{
	unsigned int tmp = 0;

	tmp = symkb_rate * ((16777216 + 67500) / 135000);

	dvbs_wr_byte(0x9fd, (tmp >> 16) & 0xff);
	dvbs_wr_byte(0x9fe, (tmp >> 8) & 0xff);
	dvbs_wr_byte(0x9ff, tmp & 0xff);

	dvbs_wr_byte(0x9f0, (tmp >> 16) & 0xff);
	dvbs_wr_byte(0x9f1, (tmp >> 8) & 0xff);
	dvbs_wr_byte(0x9f2, tmp & 0xff);

	demod_init_local();

	dvbs_wr_byte(0x110, 0x00);
	dvbs_wr_byte(0x111, 0x00);
	dvbs_wr_byte(0x130, 0x00);
	dvbs_wr_byte(0x120, 0x04);
}

unsigned int dvbs2_diseqc_irq_check(void)
{
	unsigned int diseq_irq_flag;
	unsigned int diseq_irq_sts;/* enum diseq_irq_flag */

	diseq_irq_flag = dvbs_rd_byte(DVBS_REG_SYS_IRQSTATUS0);
	if (diseq_irq_flag & 0x1) {
		diseq_irq_sts = dvbs_rd_byte(DVBS_REG_DISIRQSTAT);
		return diseq_irq_sts;
	} else {
		return 0;
	}
}

void dvbs2_diseqc_reset(void)
{
	dvbs_write_bits(DVBS_REG_DISRXCFG, 1, 7, 1);
	dvbs_write_bits(DVBS_REG_DISRXCFG, 0, 7, 1);
}

void dvbs2_diseqc_irq_en(unsigned int onoff)
{
	char val;

	if (onoff) {
		/*
		 * 1:enable IRQGAPBURST interrupt
		 * 1:enable IRQFIFO64B interrupt
		 * 1:enable IRQTXEND interrupt
		 * 1:enable IRQTIMEOUT interrupt
		 * 1:enable IRQTRFINISH interrupt
		 * 1:enable IRQRXFIFO8B interrupt
		 * 1:enable IRQRXEND interrupt
		 */
		dvbs_wr_byte(DVBS_REG_DISIRQCFG, 0xff);
		/* Enable diseqc interrupt */
		val = dvbs_rd_byte(DVBS_REG_SYS_IRQMSK0);
		dvbs_wr_byte(DVBS_REG_SYS_IRQMSK0, val | 0x1);
	} else {
		/* Disable diseqc interrupt*/
		val = dvbs_rd_byte(DVBS_REG_SYS_IRQMSK0);
		dvbs_wr_byte(DVBS_REG_SYS_IRQMSK0, val & (~0x1));
	}
}

void dvbs2_diseqc_init(void)
{
	/* set high resistance for diseqc input */
	dvbs_wr_byte(DVBS_REG_GPIO0CFG, 0xcc);
	/* DiSEqC transmission configuration 2:DiSEqC 2/3 */
	/*dvbs_wr_byte(DVBS_REG_DISTXCFG, 0x2);*/
	dvbs2_diseqc_continuous_tone(0);
	/* rx 22k tone, 125Mhz:b0, default 135Mhz:c0*/
	/*dvbs_wr_byte(DVBS_REG_DISTXF22, 0xb0);*/
	/* number of bit to wait before starting the transmission */
	dvbs_wr_byte(DVBS_REG_DISTIMEOCFG, 0x84);
	/* rx 22k tone, 125Mhz:143, default 135Mhz:12b*/
	/*dvbs_wr_byte(DVBS_REG_DISRXF220, 0x43);*/
	/* 9c for 125Mhz */
	/*dvbs_wr_byte(DVBS_REG_DISRXF100, 0x9c);*/
	/* for rx : enable rx, glitch, GPIO0  */
	dvbs_wr_byte(DVBS_REG_DISRXCFG, 0x47);
	/* number of bit to wait before starting the transmission */
	dvbs_wr_byte(DVBS_REG_DISTXWAIT, 0x1);
}

void dvbs2_diseqc_continuous_tone(unsigned int onoff)
{
	char val;

	val = dvbs_rd_byte(DVBS_REG_DISTXCFG) & 0xfc;
	if (onoff) {
		dvbs_wr_byte(DVBS_REG_DISTXCFG, val);
	} else {
		val |= 0x2;
		dvbs_wr_byte(DVBS_REG_DISTXCFG, val);
	}
}

void dvbs2_diseqc_send_msg(unsigned int len, unsigned char *msg)
{
	unsigned int i;
	unsigned int len_fifo;

	dvbs2_diseqc_init();
	dvbs2_diseqc_irq_en(1);
	for (i = 0; i < len ; i++)
		dvbs_wr_byte(DVBS_REG_DISTXFIFO, msg[i]);
		/*PR_INFO("0x%x\n", msg[i]);*/

	len_fifo = dvbs_rd_byte(DVBS_REG_DISTXBYTES);
	/*PR_INFO("tx fifo num:0x%x\n", len_fifo);*/
}

void dvbs2_diseqc_read_msg(unsigned int *len, unsigned char *msg)
{
	unsigned int i;
	unsigned int len_fifo;

	len_fifo = dvbs_rd_byte(DVBS_REG_DISRXBYTES);
	for (i = 0; i < len_fifo ; i++)
		msg[i] = dvbs_rd_byte(DVBS_REG_DISRXFIFO);

	*len = len_fifo;
}

void demod_dump_reg_diseqc(void)
{
	unsigned int i;

	for (i = DVBS_REG_SYS_IRQMSK1; i <= DVBS_REG_SYS_IRQFORCE0; i++)
		PR_INFO(" diseqc reg:0x%x val:0x%x\n", i, dvbs_rd_byte(i));

	for (i = DVBS_REG_GPIO0CFG; i <= DVBS_REG_I2CMAPO20; i++)
		PR_INFO(" diseqc reg:0x%x val:0x%x\n", i, dvbs_rd_byte(i));

	for (i = DVBS_REG_DISIRQCFG; i <= DVBS_REG_ACRDIV; i++)
		PR_INFO(" diseqc reg:0x%x val:0x%x\n", i, dvbs_rd_byte(i));
}

