# BUILD_DEST is the Qt PREFIX which is where Qt will install itself
# When Qt based apps are built against Qt, they will look for headers/libs in BUILD_DEST
# BUILD_DEST cannot be changed afterwards, so to have it live in another location on
# the end users system, they can do a softlink to it.  E.G. ln /path/to/qt/install $BUILD_DEST -s

# QT_SOURCE and QT_CROSS_COMPILE must be the same as when Qt was built.
# To use the original Qt source to either re-build its components (e.g. for patching) or
# to built Qt based apps that require private Qt source headers (e.g. a gfxdriver plugin)
# These paths cannot be changed without breaking the Qt makefiles (which will have these paths in them)
# To get around this issue, create soft links for both of these paths

if [ -z "$COMBINED_ROOT" ]; then
    echo "COMBINED_ROOT is not set"
    exit 1
fi

export FOSS_INSTALL_DIR=${FOSS_INSTALL_DIR:=${COMBINED_ROOT}/opensource}
export FSROOT=${FSROOT:=${COMBINED_ROOT}/sdk/fsroot/ramdisk}
export BUILD_DEST=/usr/local/Qt

export QT_SOURCE=$QT_SRC_ROOT
export QT_CROSS_COMPILE=$TOOLCHAIN_DIR
export QT_BUILD_NUM_CPUS=2 #single core - update this to 1 + the number of cpu's on your build system (might compile faster)
export QT_BUILD_CONFIG_TYPE=release #release or debug
export QT_CONFIGURE_HTTP_CHANNELS=1 # if 1, able to set the http channel count in libQtNetwork

# Setup cross-compile
export PKG_CONFIG_DIR=
export PKG_CONFIG_LIBDIR="${FOSS_INSTALL_DIR}/lib/pkgconfig:${TOOLCHAIN_DIR}/lib/pkgconfig:${TOOLCHAIN_DIR}/usr/lib/pkgconfig:${TOOLCHAIN_DIR}/usr/local/lib/pkgconfig"
export PKG_CONFIG_SYSROOT_DIR=

# platform overrides
if [ ! -n $QT_RDK_PLATFORM_DIR ] || [ ! -e $QT_RDK_PLATFORM_DIR/platformenv.sh ]; then
	QT_RDK_PLATFORM_DIR=$QT_SOURCE/platform
	if [ ! -e $QT_RDK_PLATFORM_DIR/platformenv.sh ]; then
		QT_RDK_PLATFORM_DIR=$QT_SOURCE/source/platform
	fi
fi
if [ -e $QT_RDK_PLATFORM_DIR/platformenv.sh ]; then
	export QT_RDK_PLATFORM_DIR
	source $QT_RDK_PLATFORM_DIR/platformenv.sh
else
	unset QT_RDK_PLATFORM_DIR
	echo "Failed to find rdk platform dir, QT_RDK_PLATFORM_DIR is not set."
fi
