do_configure[noexec] = "1"


DEPENDS += "openssl-native bison-native bc-native"

do_configure[depends] = "virtual/kernel:do_install"

do_make_scripts() {
    export LINUX_VER_STR="$(make -C ${STAGING_KERNEL_DIR}/kernel/linux-4.19 ${MOD_OPTS} -s --no-print-directory kernelversion)"
    make CC="${KERNEL_CC}" LD="${KERNEL_LD}" AR="${KERNEL_AR}" \
         HOST_EXTRACFLAGS="-I${WORKDIR}/recipe-sysroot-native/usr/include -I${STAGING_KERNEL_DIR}/kernel/linux-4.19/scripts/dtc/libfdt" \
         KBUILD_HOSTLDFLAGS="-L${WORKDIR}/recipe-sysroot-native/usr/lib" \
         -C ${STAGING_KERNEL_DIR}/kernel/linux-4.19 O=${STAGING_KERNEL_BUILDDIR} LINUX_VER_STR=${LINUX_VER_STR} scripts
}

EXTRA_OEMAKE +='-C "${STAGING_KERNEL_DIR}/kernel/linux-4.19" M="${S}" CFLAGS_MODULE+=-DNETLINK_NFLUA=16 INSTALL_MOD_DIR=lua CONFIG_LUNATIK=m CONFIG_LUADATA=m CONFIG_LUAKCRYPTO=m CONFIG_LUAJSON=m CONFIG_NFLUA=m CONFIG_NFLUA_LEGACY=m EXTRA_CFLAGS="-I${STAGING_KERNEL_DIR}/kernel/bcmkernel/include -I${STAGING_KERNEL_DIR}/kernel/bcmkernel/include/uapi"'

do_compile() {
    unset CFLAGS CPPFLAGS CXXFLAGS LDFLAGS
    export LINUX_VER_STR="$(make -C ${STAGING_KERNEL_DIR}/kernel/linux-4.19 ${MOD_OPTS} -s --no-print-directory kernelversion)"
    oe_runmake -C ${STAGING_KERNEL_DIR}/kernel/linux-4.19 M=${S} LINUX_VER_STR=${LINUX_VER_STR} modules
}

do_install() {
        install -d ${D}/lib/modules/${KERNEL_VERSION}/
        install -m 644 ${S}/lib/luajson/luajson.ko ${D}/lib/modules/${KERNEL_VERSION}/
        install -m 644 ${S}/lib/lunatik/lunatik.ko ${D}/lib/modules/${KERNEL_VERSION}/
        install -m 644 ${S}/lib/luadata/luadata.ko ${D}/lib/modules/${KERNEL_VERSION}/
        install -m 644 ${S}/lib/luakcrypto/luakcrypto.ko ${D}/lib/modules/${KERNEL_VERSION}/
        install -m 644 ${S}/src/luaconntrack.ko ${D}/lib/modules/${KERNEL_VERSION}/
        install -m 644 ${S}/src/nflua.ko ${D}/lib/modules/${KERNEL_VERSION}/
}
