SUMMARY = "Broadcom Oops Capture Kernel Driver"
DESCRIPTION = "Broadcom Oops Capture Kernel Driver"
SECTION = "console/utils"
LICENSE = "GPLv2"
INC_PR = "r3"
LIC_FILES_CHKSUM = "file://COPYING;md5=eb723b61539feef013de476e68b5c50a"

DEPENDS += " virtual/kernel"
PROVIDES += "boops-k"
RPROVIDES_${PN} += "boops-k"

SRC_URI = "${RDK_GENERIC_ROOT_GIT}/boops/soc/broadcom/common;protocol=${RDK_GIT_PROTOCOL};branch=${RDK_GIT_BRANCH}"
PV = "${RDK_RELEASE}+git"
SRCREV = "${AUTOREV}"
S = "${WORKDIR}/git/boops-k"

LDFLAGS_append=" -Wall"
CFLAGS_append=" "
CFLAGS += " -Wall -Wno-unused-function"
do_compile[lockfiles] = "${TMPDIR}/kernel-scripts.lock"

MAKE_TARGETS = "all"
MODULE_NAME = "boops"

inherit module pkgconfig

module_do_install() {
    install -d ${D}${includedir}
    bbnote "Copying boops_shared.h to ${includedir}"
    cp -f ${S}/source/boops_shared.h ${D}${includedir}

    install -d ${D}/lib/modules/${KERNEL_VERSION}/misc
    bbnote "Copying ${MODULE_NAME}.ko to ${D}/lib/modules/${KERNEL_VERSION}/misc"
    install -m 0644 ${S}/${MODULE_NAME}.ko ${D}/lib/modules/${KERNEL_VERSION}/misc/${MODULE_NAME}.ko
}

