DEPENDS += "bison-native bc-native openssl-native"

FILESEXTRAPATHS_prepend := "${THISDIR}/${PN}:"

SRC_URI += "file://0001-Fix-MMC-Crash-Upon-Oops-Dumping.patch"

RPROVIDES_${PN} += "kernel-module-boops-k"

do_configure[depends] = "virtual/kernel:do_install"

MOD_OPTS += "CROSS_COMPILE=${TARGET_PREFIX}"
MOD_OPTS += "EXTMODDIR=${S}"

EXTRA_OEMAKE +='-C "${STAGING_KERNEL_DIR}/kernel/linux-4.19" M="${S}" EXTRA_CFLAGS="-I ${STAGING_KERNEL_DIR}/kernel/bcmkernel/include"'

do_compile() {
    unset CFLAGS CPPFLAGS CXXFLAGS LDFLAGS
    export LINUX_VER_STR="$(make -C ${STAGING_KERNEL_DIR}/kernel/linux-4.19 ${MOD_OPTS} -s --no-print-directory kernelversion)"
    make -C ${STAGING_KERNEL_DIR}/kernel/linux-4.19 ${MOD_OPTS} BRCM_ALT_TOOLCHAIN_BASE=${WORKDIR} LINUX_VER_STR=${LINUX_VER_STR} scripts
    oe_runmake -C ${STAGING_KERNEL_DIR}/kernel/linux-4.19 M=${S} LINUX_VER_STR=${LINUX_VER_STR} modules
}

module_do_install_append () {
    install -d ${STAGING_INCDIR_SHARED}/

    bbnote "Copying boops_shared.h to ${STAGING_INCDIR_SHARED}"
    cp -rf ${S}/source/boops_shared.h ${STAGING_INCDIR_SHARED}
}

inherit module
