#!/bin/sh

if [ -f /etc/device.properties ] ; then
    source /etc/device.properties
fi

# Oops dump panic check
dump_file=/rdklogs/logs/resetinfo.txt
block_size=512
CONSOLE_LOG="/rdklogs/logs/Consolelog.txt.0"

if [[ "${MMC_OOPS_ENABLE}" == "true" ]]; then
    echo "sky_traceKernelPanic.sh: oops_mmc dump start"
    rm -rf $dump_file
    rm -rf $dump_file.tmp
    rdk_version=$(sed -n 's/^imagename://p' /version.txt)

    /sbin/modprobe boops storage_type="mmc" mmc_block_first="${BOOPS_MMC_BLOCK_START}" mmc_block_count="${BOOPS_MMC_BLOCK_COUNT}" build_version="${rdk_version}"

    [ $? -ne 0 ] && exit 1

    # dump the contents of oops partition to a file
    /usr/bin/boops --in_file "$BOOPS_MMC_DEVICE" --byte_offset "$(($BOOPS_MMC_BLOCK_START*$block_size))" --out_file "${dump_file}.tmp" --prefix --debug --raw_header
    
    # Erase oops partition and run the monitor in the background
    /usr/bin/boops --in_file "$BOOPS_MMC_DEVICE" --byte_offset "$(($BOOPS_MMC_BLOCK_START*$block_size))" --prefix --monitor --erase &

    if [ -f "$dump_file.tmp" ]; then
        cat $dump_file.tmp >> $dump_file
        rm -rf $dump_file.tmp
    fi
    echo "sky_traceKernelPanic.sh: oops_mmc dump end"
fi

# Set last reboot reason to kernel-panic.
if [ -f $dump_file ] && [ `cat $dump_file | grep "PREVIOUS_KERNEL_OOPS_DUMP_START"` ]
then
    syscfg set X_RDKCENTRAL-COM_LastRebootReason "kernel-panic"
    syscfg set X_RDKCENTRAL-COM_LastRebootCounter "1"
    echo "Detected last reboot reason as kernel-panic"
#LTE-1437 Reboot reason is reporting wrong for XLE devices
elif [ "$BOX_TYPE" = "WNXL11BWL" ] && [ -f "$CONSOLE_LOG" ] && grep -qiE 'Kernel panic - not syncing|Unable to handle kernel' $CONSOLE_LOG; then
  echo "Kernel-panic related logs found in $CONSOLE_LOG"
  echo "$(grep -im 1 'Kernel panic - not syncing' $CONSOLE_LOG)"
  echo "$(grep -im 1 'Unable to handle kernel' $CONSOLE_LOG)"
  echo "$(grep -im 1 'rebooting' $CONSOLE_LOG)"
  syscfg set X_RDKCENTRAL-COM_LastRebootReason "kernel-panic"
  syscfg set X_RDKCENTRAL-COM_LastRebootCounter "1"
  echo "Detected last reboot reason as kernel-panic"
else
    echo "Detected last reboot reason as not a kernel-panic"
fi
syscfg commit
sleep 1
