/****************************************************************************
 *
 * Copyright (c) 2019 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Tim Ross <tross@broadcom.com>
 *****************************************************************************/
#ifndef _DQNET_FAP_H_
#define _DQNET_FAP_H_

struct dqnet_fap_ops {
	int	(*init_system)(void);
	int	(*exit_system)(void);
	int	(*init_port)(struct net_device *dev);
	int	(*exit_port)(struct net_device *dev);
	int	(*get_tx_prio)(struct net_device *dev, int *prio);
	int	(*get_tx_q_type)(struct net_device *dev,
				 enum dqnet_q_type *q_type);
	struct rtnl_link_stats64 *(*link_stats)(struct net_device *dev,
			     struct rtnl_link_stats64 *stats);
	int	(*get_tag_len)(struct net_device *dev);
	int	(*add_tag)(struct net_device *dev, struct fpm_buff *fb);
	enum dqnet_qmsg_fmt
		(*get_qmsg_fmt)(struct net_device *dev);
	int	(*get_imp_lag_port)(struct net_device *dev);
	int	(*set_imp_lag_port)(struct net_device *dev,
				    int port, int assign);
	int	(*set_wan)(struct dqnet_netdev *ndevs, char *ifname,
			   int enable);
	int	(*set_isolate)(struct net_device *dev, int enable);
	int	(*get_expected_queue)(struct net_device *dev);
	int	(*dump)(struct seq_file *s);
	int	(*balance_imp_lag_port)(struct dqnet_netdev *ndevs, int action,
					int poi);
	int	(*get_wifi_idx)(struct dqnet_netdev *ndev);
	int 	(*get_q_info)(struct net_device *dev,
			      struct dqnet_channel *chan);
	int	(*enable_rx_shaper)(struct net_device *dev, int enable);
	int	(*set_stp)(struct net_device *dev, int state);
	int	(*set_ageing)(struct net_device *dev, clock_t ageing);
	int	(*fdb_add)(struct net_device *dev, u16 vid, const unsigned char *addr);
	int	(*fdb_del)(struct net_device *dev, u16 vid, const unsigned char *addr);
	int	(*set_mtu)(struct net_device *dev, int mtu);
};

void dqnet_getsym_fap_ops(void);
void dqnet_putsym_fap_ops(void);
int dqnet_fap_init_system(void);
int dqnet_fap_exit_system(void);
int dqnet_fap_init_port(struct net_device *dev);
int dqnet_fap_exit_port(struct net_device *dev);
int dqnet_fap_get_tx_prio(struct net_device *dev, int *prio);
int dqnet_fap_get_tx_q_type(struct net_device *dev,
			    enum dqnet_q_type *q_type);
struct rtnl_link_stats64 *dqnet_fap_link_stats(struct net_device *dev,
			 struct rtnl_link_stats64 *stats);
int dqnet_fap_get_tag_len(struct net_device *dev);
int dqnet_fap_add_tag(struct net_device *dev, struct fpm_buff *fb);
int dqnet_fap_set_imp_lag_port(struct net_device *dev,
			       int port, int assign);
int dqnet_fap_set_isolate(struct net_device *dev,
			  int enable);
int dqnet_fap_set_wan(struct dqnet_netdev *ndevs, char *ifname,
		      int enable);
int dqnet_fap_balance_imp_lag_ports(struct dqnet_netdev *ndevs, int action,
				    int poi);
int dqnet_fap_get_wifi_idx(struct dqnet_netdev *ndev);
int dqnet_fap_get_q_info(struct net_device *dev,
			 struct dqnet_channel *chan);
int dqnet_fap_enable_rx_shaper(struct net_device *dev, int enable);
int dqnet_fap_set_stp(struct net_device *dev, int state);
int dqnet_fap_set_ageing(struct net_device *dev, clock_t ageing);
int dqnet_fap_fdb_add(struct net_device *dev, u16 vid, const unsigned char *addr);
int dqnet_fap_fdb_del(struct net_device *dev, u16 vid, const unsigned char *addr);
int dqnet_fap_set_mtu(struct net_device *dev, int mtu);

#endif
