/* dhparam.c: initial DH parameters for stunnel */
#include "prototypes.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void)
{
    static unsigned char dhp_2048[] = {
        0xA4, 0xC9, 0xC1, 0x58, 0x7A, 0x51, 0x8F, 0x53, 0x8F, 0x6A,
        0x77, 0x15, 0xCF, 0xAC, 0x37, 0x99, 0xD1, 0xA6, 0xF1, 0xA2,
        0x46, 0x3A, 0xA8, 0x66, 0xFD, 0x22, 0x4A, 0x6B, 0x93, 0x8A,
        0x4A, 0x7E, 0x28, 0x66, 0x82, 0x02, 0x3A, 0x6E, 0x42, 0x3F,
        0x96, 0x20, 0x07, 0x18, 0xA4, 0x31, 0x0F, 0xA8, 0x1E, 0x44,
        0x77, 0x2A, 0x5C, 0x4D, 0x19, 0x9F, 0x10, 0x52, 0xD5, 0x38,
        0xD5, 0x0E, 0x66, 0x82, 0x75, 0xA9, 0x8B, 0x47, 0xA1, 0x8F,
        0x8A, 0xEB, 0x21, 0xD4, 0xF7, 0x30, 0xE4, 0x63, 0x62, 0x1B,
        0x29, 0xE3, 0xCC, 0x69, 0x88, 0x40, 0x91, 0xF8, 0xF9, 0xD6,
        0xC9, 0x1E, 0xC1, 0xB0, 0x43, 0x0A, 0x14, 0x34, 0x05, 0xAB,
        0x45, 0xFC, 0xCB, 0x68, 0x8A, 0x96, 0x91, 0x69, 0xE4, 0x48,
        0x3B, 0xD8, 0xE1, 0x22, 0xD9, 0x34, 0x8F, 0xE2, 0x05, 0x7F,
        0x5F, 0x93, 0xF2, 0x6B, 0xF2, 0xDF, 0xF4, 0x70, 0x63, 0xE6,
        0xC7, 0x69, 0x91, 0x8E, 0x1C, 0xF9, 0x1C, 0xF0, 0x2B, 0x2F,
        0x1C, 0x1A, 0xA5, 0x84, 0x6A, 0xCB, 0x05, 0x1B, 0x0E, 0xDF,
        0x28, 0xF0, 0x9D, 0xCA, 0x0E, 0xCE, 0xB0, 0xA7, 0xD9, 0xBA,
        0x83, 0x30, 0xA4, 0x2C, 0xF4, 0x16, 0x09, 0xD3, 0xF4, 0xD9,
        0xC8, 0x49, 0x57, 0x78, 0xA4, 0x20, 0xCC, 0xFA, 0xE8, 0x5E,
        0xB4, 0x64, 0x6C, 0x68, 0x87, 0x91, 0xCE, 0x58, 0x83, 0x38,
        0x0F, 0x59, 0xAF, 0x31, 0x03, 0xDC, 0x88, 0x32, 0x6F, 0xFE,
        0xF3, 0x07, 0xFE, 0xBA, 0xFB, 0x9A, 0xEF, 0xB0, 0x57, 0x0F,
        0xBD, 0x58, 0x0D, 0xC0, 0xEF, 0x08, 0xD6, 0x13, 0x02, 0x57,
        0x35, 0x60, 0x15, 0x98, 0xEF, 0xE2, 0xA4, 0x38, 0xCB, 0xD4,
        0x2F, 0x5E, 0xF4, 0x46, 0x80, 0x18, 0x88, 0x40, 0x9D, 0x71,
        0x4C, 0xA4, 0x81, 0xEB, 0x75, 0xBC, 0xDC, 0x16, 0x41, 0xAB,
        0x95, 0x7E, 0xA9, 0x73, 0x6B, 0x5B
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.65 */
