/****************************************************************************
 *
 * Copyright (c) 2010-2012 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or
 * its licensors, and may only be used, duplicated, modified or distributed
 * pursuant to the terms and conditions of a separate, written license
 * agreement executed between you and Broadcom (an "Authorized License").
 * Except as set forth in an Authorized License, Broadcom grants no license
 * (express or implied), right to use, or waiver of any kind with respect to
 * the Software, and Broadcom expressly reserves all rights in and to the
 * Software and all intellectual property rights therein.  IF YOU HAVE NO
 * AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY,
 * AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE
 * SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization,
 * constitutes the valuable trade secrets of Broadcom, and you shall use all
 * reasonable efforts to protect the confidentiality thereof, and to use this
 * information only in connection with your use of Broadcom integrated circuit
 * products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED
 * "AS IS" AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS
 * OR WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
 * RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL
 * IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR
 * A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET
 * ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME
 * THE ENTIRE RISK ARISING OUT OF USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM
 * OR ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
 * INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY
 * RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN
 * EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1,
 * WHICHEVER IS GREATER. THESE LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY
 * FAILURE OF ESSENTIAL PURPOSE OF ANY LIMITED REMEDY.
 *
 *******************************************************************************
 *
 * itc_channel_defs.h
 * Oct. 23 2012
 * Peter Sulc
 *
 *******************************************************************************/
#ifndef _ITC_CHANNEL_DEFS_H_
#define _ITC_CHANNEL_DEFS_H_

/* DQM channel and device/implementation specific defines */
#define RPC_TUNNELS_MAX		4
#define RPC_INVALID_TUNNEL	-1

/* service indexes */
enum {
	RPC_SERVICE_INIT = 0,	/* special channel init and handshake messages */
	RPC_SERVICE_MISC,	/* misc. messages/services */
	RPC_SERVICE_FLASH_MTD,	/* Flash MTD */
	RPC_SERVICE_FLASH = RPC_SERVICE_FLASH_MTD,
	RPC_SERVICE_NONVOL,	/* Split mode nonvol support */
	RPC_SERVICE_EROUTER,	/* erouter - Linux user space */
	RPC_SERVICE_EROUTER_PM,	/* erouter - Linux user space power management */
	RPC_SERVICE_WPS_CTL,	/* wireless reset button */
	RPC_SERVICE_BASH_USER,	/* Linux bash shell service */
	RPC_SERVICE_TEST_USER,	/* Linux user space test service */
	RPC_SERVICE_GPIO,	/* GPIO */
	RPC_SERVICE_PINCTRL,	/* Pin Control */
	RPC_SERVICE_LED,	/* LED */
	RPC_SERVICE_VFBIO,	/* Flash block I/O */
	RPC_SERVICE_PWR,	/* Power Domain Control */
	RPC_SERVICE_CLK,	/* Clock Control */
	RPC_SERVICE_SYS,	/* System-wide Services */
	RPC_SERVICE_BBS,	/* BBS Control */
	RPC_SERVICE_BA,		/* Boot Assist */
	RPC_SERVICE_AVS,	/* Adaptive Voltage Scaling service */
	RPC_SERVICE_UBCAP,	/* UBUS Capture */
	RPC_SERVICE_FPM,	/* FPM */
	RPC_SERVICE_RTC,	/* Real-Time Clock */
	RPC_SERVICE_RSVD1,	/* Reserved */
	RPC_SERVICE_RSVD2,	/* Reserved */
	RPC_SERVICE_ALERT,	/* Alert */
	RPC_SERVICE_OTP,	/* OTP */
	RPC_SERVICE_VENDOR,	/* Linux Vendor service */
	RPC_SERVICE_AMP,	/* AMP service */
	RPC_MAX_SERVICES	/* Total number of supported services */
};

#define SERVICE_MISC_ACTIVE		true
#define SERVICE_FLASH_MTD_ACTIVE	true
#define SERVICE_NONVOL_ACTIVE		false
#define SERVICE_EROUTER_ACTIVE		true
#define SERVICE_EROUTER_PM_ACTIVE	false
#define SERVICE_WPS_CTL_ACTIVE		true
#define SERVICE_BASH_USER_ACTIVE	false
#define SERVICE_TEST_USER_ACTIVE	false
#define SERVICE_GPIO_ACTIVE		false
#define SERVICE_PINMUX_ACTIVE		false
#define SERVICE_LED_ACTIVE		true
#define SERVICE_VFBIO_ACTIVE		false
#define SERVICE_PWR_ACTIVE		true
#define SERVICE_CLK_ACTIVE		true
#define SERVICE_SYS_ACTIVE		true
#define SERVICE_BBS_ACTIVE		false
#define SERVICE_BA_ACTIVE		true
#define SERVICE_AVS_ACTIVE		false
#define SERVICE_UBCAP_ACTIVE		false
#define SERVICE_FPM_ACTIVE		false
#define SERVICE_RTC_ACTIVE		false
#define SERVICE_RSVD1_ACTIVE		true
#define SERVICE_RSVD2_ACTIVE		false
#define SERVICE_ALERT_ACTIVE		false
#define SERVICE_OTP_ACTIVE		false
#define SERVICE_VENDOR_ACTIVE		false
#define SERVICE_AMP_ACTIVE		false

#define RPC_MSG_POOL_MSG_CNT	64
#define RPC_ORPHAN_QUEUE_LIMIT	8

#endif
