 /****************************************************************************
 *
 * Copyright (c) 2015-2020 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/kthread.h>
#include "flowmgr.h"
#include "flowmgr_fap.h"
#include "flowmgr_fap_ops.h"
#include <uapi/linux/bcm_media_gw/flowmgr/flowmgr_ioctl.h>
#include "dqnet.h"

#define FLOW_TRIGGER_MARK 0xACC1

void flowmgr_manual_trigger_clear(struct nf_conn *ct,
				  void *offload_info,
				  int direction)
{
	struct offload_info *ct_offload_info = (struct offload_info *)offload_info;
	ct_offload_info->start_promote = 0;
	if (flowmgr.promote_mode == MANUAL_PROMOTE_BY_CTMARK)
		ct->mark &= ((direction == IP_CT_DIR_ORIGINAL)? 0xFFFF : 0xFFFF0000);
}

int is_flowmgr_manual_enable(void)
{
	return (flowmgr.promote_mode != AUTO_PROMOTE);
}

void flowmgr_manual_enable(int enable)
{
	if (enable && (flowmgr.promote_mode == AUTO_PROMOTE) &&
	     !flowmgr.tcp_pkt_threshold)
		flowmgr.tcp_pkt_threshold = 1;
}

int flowmgr_manual_trigger_check(struct nf_conn *ct, struct sk_buff *skb, u8 start_promote)
{
	if (flowmgr.promote_mode == MANUAL_PROMOTE_BY_CMD && !start_promote)
		return 0;
	else if (flowmgr.promote_mode == MANUAL_PROMOTE_BY_CTMARK) {
			u16 mark;
			mark = (CTINFO2DIR(nfctinfo(skb)) == IP_CT_DIR_ORIGINAL) ?
				ct->mark >> 16 : ct->mark & 0xFFFF;
		if (mark != FLOW_TRIGGER_MARK)
			return 0;
	}
	return 1;
}

int flowmgr_manual_promote(void *t, struct nf_conn *ct)
{
	struct nf_conn_offload *ct_offload = NULL;
	ct_offload = nf_conn_offload_find(ct);
	if (!ct_offload) {
		pr_err("%s: ct_offload not found\n", __func__);
		return -1;
	}
	ct_offload_orig.start_promote = 1;
	ct_offload_repl.start_promote = 1;
	return 0;
}

int flowmgr_manual_demote(void *t, struct nf_conn *ct)
{
	struct nf_conn_offload *ct_offload = NULL;
	ct_offload = nf_conn_offload_find(ct);
	if (!ct_offload) {
		pr_err("%s: ct_offload not found\n", __func__);
		return -1;
	}
	flowmgr_demote(ct, ct_offload);
	return 0;
}

int flowmgr_manual_init(void)
{
	return 0;
}

void flowmgr_manual_fini(void)
{
}
