 /****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/


#ifndef _NF_CONNTRACK_RSVP_H
#define _NF_CONNTRACK_RSVP_H

#ifdef __KERNEL__

struct rsvp_hdr
{
    __u8 vers;
    __u8 msgType;
    __sum16 checksum;
    __u8 ttl;
    __u8 reserved;
    __be16 length;
};

struct rsvp_session_hdr
{
    __be16 length;
    __u8 classNum;
    __u8 cType;
    __be32 ipAddress;
    __u8 protocol;
    __u8 flags;
    __be16 ports;
};

extern int
(*nf_nat_rsvp_convert_ip_hook)(struct rsvp_hdr *rsvph, struct rsvp_session_hdr *rsvpsh, __be32 ip);

#endif /* __KERNEL__ */

#endif /* _NF_CONNTRACK_RSVP_H */
