/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Tim Ross <tross@broadcom.com>
 *****************************************************************************/
#ifndef _DQNET_QMSG_H_
#define _DQNET_QMSG_H_

#include <linux/bcm_media_gw/msgfifo.h>
#include <bcmnethooks.h>

struct dqnet_qmsg_ops {
	int	(*encode_qmsg)(struct dqnet_netdev *ndev,
			       struct fpm_buff *fb,
			       u32 *msgdata);
	int	(*decode_qmsg)(struct dqnet_channel *chan,
			       u32 *msgdata,
			       struct fpm_buff *fb);
	int	(*id_to_port)(u32 if_id, u32 if_sub_id, u8 *port);
	int	(*port_to_id)(u8 port, u32 *if_id, u32 *if_sub_id);
	int	(*max_if_id)(void);
	int	(*max_if_subid)(void);
};

int dqnet_init_q_msg_funcs(struct dqnet_channel *chan);
int dqnet_max_if_id(void);
int dqnet_max_if_subid(void);
void dqnet_getsym_qmsg_ops(void);
void dqnet_putsym_qmsg_ops(void);

#endif
