SUMMARY = "ulogd"

LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://COPYING;md5=c93c0550bd3173f4504b2cbd8991e50b"
PV = "2.0.7"

SRC_URI  = "https://netfilter.org/projects/ulogd/files/ulogd-${PV}.tar.bz2 \
	    file://ulogd-conf.patch \
	    file://ulogd.service \
	   "

SRC_URI[md5sum] = "2bb2868cf51acbb90c35763c9f995f31"
SRC_URI[sha1sum] = "f2d90469e2842e2bfbe19c55cf6d56ac107aa4b9"

inherit autotools systemd pkgconfig

DEPENDS += "libpcap libnetfilter-conntrack libnetfilter-log libnetfilter-acct"

S="${WORKDIR}/ulogd-${PV}"

FILES_${PN} += "/usr/lib/ulogd ${systemd_unitdir}/system"

INSANE_SKIP_${PN} = "ldflags"
INSANE_SKIP_${PN}-dev = "ldflags"

SYSTEMD_SERVICE_${PN} = "ulogd.service"

do_install() {
    install -d ${D}/usr${base_sbindir}
    install -m 0755 ${B}/src/ulogd  ${D}/usr${base_sbindir}
    install -d ${D}${systemd_unitdir}/system
    install -m 0644 ${WORKDIR}/ulogd.service ${D}${systemd_unitdir}/system
    install -d ${D}${sysconfdir}
    install -m 0644 ${B}/ulogd.conf ${D}${sysconfdir}
    install -d ${D}/usr/lib/ulogd
    install -m 0644 ${B}/output/.libs/*.so ${D}/usr/lib/ulogd
    install -m 0644 ${B}/input/packet/.libs/*.so ${D}/usr/lib/ulogd
    install -m 0644 ${B}/output/pcap/.libs/*.so ${D}/usr/lib/ulogd
    install -m 0644 ${B}/filter/raw2packet/.libs/*.so ${D}/usr/lib/ulogd
    install -m 0644 ${B}/input/sum/.libs/*.so ${D}/usr/lib/ulogd
    install -m 0644 ${B}/filter/.libs/*.so ${D}/usr/lib/ulogd
}

