 /****************************************************************************
 *
 * Copyright (c) 2016 Broadcom Limited
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayesh.patel@broadcom.com>
 *****************************************************************************/
#include <linux/types.h>
#include <linux/platform_device.h>
#include <linux/of.h>
#include <linux/types.h>
#include "dqskb_priv.h"

int dqskb_parse_dt_prop_u32(struct device_node *of_node,
			    const char *propname, u32 *dst)
{
	int status = 0;

	if (!of_property_read_u32(of_node, propname, dst))
	{
		pr_debug("%s = %xh\n", propname, *dst);
	}
	else
	{
		pr_err("Missing %s property!\n", propname);
		status = -EFAULT;
	}

	return status;
}

int dqskb_parse_dt_prop_string(struct device_node *of_node,
				  const char *propname, char **dst)
{
	int status = 0;

	if (!of_property_read_string(of_node, propname, (const char **)dst))
	{
		pr_debug("%s = %s\n", propname, *dst);
	}
	else
	{
		pr_err("Missing %s property!\n", propname);
		status = -EFAULT;
	}

	return status;
}

int dqskb_parse_dt_node(struct platform_device *pdev)
{
	int status = 0;
	struct dqskb_dev *sdev = pdev->dev.platform_data;
	struct device_node *of_node = pdev->dev.of_node;
	char *str;

	if (!sdev)
		goto done;

	status = dqskb_parse_dt_prop_string(of_node, "dev-name",
					    &str);
	if (status)
		goto done;
	strncpy(sdev->name, str, sizeof(sdev->name));
	sdev->name[sizeof(sdev->name)-1] = '\0';

	status = dqskb_parse_dt_prop_string(of_node, "dqm",
					    &str);
	if (status)
		goto done;
	strncpy(sdev->dqm_dev, str, sizeof(sdev->dqm_dev));
	sdev->dqm_dev[sizeof(sdev->dqm_dev)-1] = '\0';

	status = dqskb_parse_dt_prop_u32(of_node, "tx-q",
					 &sdev->tx_q);
	if (status)
		goto done;

	status = dqskb_parse_dt_prop_u32(of_node, "rx-q",
					 &sdev->rx_q);
	if (status)
		goto done;

	goto done;

  done:
	return status;
}
