 /****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#ifndef __BCMPORT_H
#define __BCMPORT_H

#if LINUX_VERSION_CODE < KERNEL_VERSION(3, 8, 0)
static inline bool ether_addr_equal(const u8 *addr1, const u8 *addr2)
{
#if defined(CONFIG_HAVE_EFFICIENT_UNALIGNED_ACCESS)
	u32 fold = ((*(const u32 *)addr1) ^ (*(const u32 *)addr2)) |
		   ((*(const u16 *)(addr1 + 4)) ^ (*(const u16 *)(addr2 + 4)));

	return fold == 0;
#else
	const u16 *a = (const u16 *)addr1;
	const u16 *b = (const u16 *)addr2;

	return ((a[0] ^ b[0]) | (a[1] ^ b[1]) | (a[2] ^ b[2])) == 0;
#endif
}
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(3, 8, 0)
#define hlist_iterate_safe \
	hlist_for_each_entry_safe
#define hlist_iterate_rcu \
	hlist_for_each_entry_rcu
#define hlist_iterate \
	hlist_for_each_entry
#else
#define hlist_iterate_safe(a, b, c, d) \
	struct hlist_node *h;\
	hlist_for_each_entry_safe(a, h, b, c, d)
#define hlist_iterate_rcu(a, b, c) \
	struct hlist_node *h;\
	hlist_for_each_entry_rcu(a, h, b, c)
#define hlist_iterate(a, b, c) \
	struct hlist_node *h;\
	hlist_for_each_entry(a, h, b, c)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(5, 5, 0)
#define proc_open open
#define proc_close close
#define proc_read read
#define proc_write write
#define proc_release release
#define proc_lseek llseek
#define proc_ops file_operations
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(5, 15, 0)
//struct timeval
//{
//    int tv_sec, tv_usec;
//};
//
//static inline void
//jiffies_to_timeval(unsigned long jiffies, struct timeval *value)
//{
//        value->tv_usec = (jiffies % HZ) * (1000000L / HZ);
//        value->tv_sec = jiffies / HZ;
//}

struct timeval {
	long	tv_sec;		/* seconds */
	long	tv_usec;	/* microseconds */
};

static inline void jiffies_to_timeval(const unsigned long jiffies, struct timeval *value)
{
        /*
         * Convert jiffies to nanoseconds and separate with
         * one divide.
         */
        u32 rem;

        value->tv_sec = div_u64_rem((u64)jiffies * TICK_NSEC,
                                    NSEC_PER_SEC, &rem);
        value->tv_usec = rem / NSEC_PER_USEC;
}

#endif
#endif
