#!/bin/sh
####################################################################################
# If not stated otherwise in this file or this component's Licenses.txt file the
# following copyright and licenses apply:

#  Copyright 2019 RDK Management

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

# http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#######################################################################################
source /etc/device.properties
source /etc/log_timestamp.sh
GRE_BRIDGE="brebhaul"
LOCAL_BR_IP="169.254.85.1"
mesh_ethbhaul_setup()
{
   echo_t "ETH_BACKHAUL : Start Vlan Creation...." >> /rdklogs/logs/ethbhaul.log
   if [  -d "/sys/class/net/l2sd0.100.123" ]; then
      echo_t "ETH_BACKHAUL : Skipping 123 vlan creation" >> /rdklogs/logs/ethbhaul.log
   else
      ip link add link l2sd0.100 l2sd0.100.123 type vlan proto 802.1Q id 123
      ip link set l2sd0.100.123 up
      brctl addif $GRE_BRIDGE l2sd0.100.123
      ip rule add from all iif l2sd0.100.123 lookup erouter
      echo_t "ETH_BACKHAUL : Vlan 123 is created ...." >> /rdklogs/logs/ethbhaul.log
   fi
   #Enable external switch for QinQ support in case of Cisco
   if [ "$MODEL_NUM" = "DPC3941" ]; then
      cli system/l2switch/extswitch/acceptTag
   fi
   echo_t "ETH_BACKHAUL : End Vlan Creation...." >> /rdklogs/logs/ethbhaul.log
}

remove_pod_ethbhaul()
{
   echo_t "ETH_BACKHAUL : Start Vlan Deletion...." >> /rdklogs/logs/ethbhaul.log
   ip link del l2sd0.100.123
   echo_t "ETH_BACKHAUL : End Vlan Deletion...." >> /rdklogs/logs/ethbhaul.log
   for ethpod in `ls /sys/devices/virtual/net/br403/brif | grep ethpod`; do 
     ip link del $ethpod
   done
}
create_pod_tunnel()
{
  echo_t "ETH_BACKHAUL : Start GRE creation with remote pod IP $2...." >> /rdklogs/logs/ethbhaul.log
  if [ "$2" != "" ];then
    ip link del ethpod$1
    ip link add ethpod$1 type gretap local $LOCAL_BR_IP remote $2 dev $GRE_BRIDGE tos 1
    ifconfig ethpod$1 up
    vconfig add ethpod$1 101
    vconfig add ethpod$1 106
    ifconfig ethpod$1.101 up
    ifconfig ethpod$1.106 up
    brctl addif br403 ethpod$1
    brctl addif brlan1 ethpod$1.101
    brctl addif br106 ethpod$1.106
  else
    echo_t "ETH_BACKHAUL : GRE Remote IP is missing, not creating the GRE tunnel.." >> /rdklogs/logs/ethbhaul.log
   fi
}

if [ "$1" == "enable" ]; then
   mesh_ethbhaul_setup
elif [ "$1" == "disable" ]; then
   remove_pod_ethbhaul
elif [ "$1" == "gre" ]; then
   create_pod_tunnel $2 $3
fi
