/****************************************************************************
 *
 * Broadcom Proprietary and Confidential. (c) 2017 Broadcom.  All rights reserved.
 * The term “Broadcom” refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Peter Sulc <peter.sulc@broadcom.com>
 * Filename: gisb_arb.h
 * Description: gisb arb bus error dump
 ****************************************************************************/

#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/io.h>
#include <linux/printk.h>

#include "gisb_arb.h"

static void *gisb_arb_base;

int __init gisb_arb_map(u64 base, u32 size)
{
	gisb_arb_base = ioremap(base, size);
	return 0;
}

void gisb_error_exception_print(void)
{
	if (!gisb_arb_base)
		return;
	pr_info("GISB ARB ERR HI ADDR: %08x\n",
		__raw_readl(gisb_arb_base + SUN_GISB_ARB_ERR_CAP_HI_ADDR));
	pr_info("GISB ARB ERR ADDR:    %08x\n",
		__raw_readl(gisb_arb_base + SUN_GISB_ARB_ERR_CAP_ADDR));
	pr_info("GISB ARB ERR DATA:    %08x\n",
		__raw_readl(gisb_arb_base + SUN_GISB_ARB_ERR_CAP_DATA));
	pr_info("GISB ARB ERR STATUS:  %08x\n",
		__raw_readl(gisb_arb_base + SUN_GISB_ARB_ERR_CAP_STATUS));
	pr_info("GISB ARB ERR MASTER:  %08x\n",
		__raw_readl(gisb_arb_base + SUN_GISB_ARB_ERR_CAP_MASTER));
}
EXPORT_SYMBOL(gisb_error_exception_print);
