/****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Piotr Romanus <promanus@broadcom.com>
 ****************************************************************************/

#ifndef _ETHSW_DB_H
#define _ETHSW_DB_H

#include <linux/version.h>
#include "../include/bcmport.h"


/* Following code is derived from flowmgr_db.c implementation */

/* Client DB Structure */
struct ethsw_db_entry {
	struct hlist_node	hlist;

	struct rcu_head		rcu;
	unsigned long		used;
	__u8			portid;          /* Input Interface Index  */
	atomic_t		use;             /* Use count              */
	__u16                   vlanid;
	__u8			addr[6];	 /* MAC address            */
};

int ethsw_db_init(void);
void ethsw_db_fini(void);
struct ethsw_db_entry *ethsw_db_find(const unsigned char *addr, u16 vid);
int ethsw_db_delete(const unsigned char *addr, u16 vid);
int ethsw_db_insert(int portid, const unsigned char *addr, u16 vid);
int ethsw_db_update(int portid, const unsigned char *addr, u16 vid);
void ethsw_db_flush(void);

void ethsw_db_delete_by_port(int portid);
void ethsw_db_delete_by_age(int age);

struct hlist_node  *ethsw_db_get_first(int *hashid);
struct hlist_node *ethsw_db_get_next(int *hashid,
				       struct hlist_node *head);
struct hlist_node *ethsw_db_get_idx(int *hashid, loff_t pos);

#endif
