 /****************************************************************************
 *
 * Broadcom Proprietary and Confidential. (c) 2017 Broadcom.  All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

/****************************************************************************
 *	Filename:       netdev_rfap.h
 *	Author: 	Peter Sulc
 *	Creation Date:  2/2/16
 *	PURPOSE: DQM/FPM/runner interface layer for netdev drivers.
 ****************************************************************************/

#ifndef _BCM3390_RFAP_H_
#define _BCM3390_RFAP_H_

struct netdev_rfap_ops {
#if defined(CONFIG_BCM_NETDEV_RFAP_PCI) || defined(CONFIG_BCM_NETDEV_RFAP_PCI_MODULE)
	struct net_device *(*alloc_net_device)(int sizeof_priv, unsigned short devn, unsigned int count);
	void (*free_net_device)(struct net_device *netdev);
#else
	struct net_device *(*alloc_net_device)(int sizeof_priv);
#endif
	void *(*netdev_priv)(const struct net_device *dev);
#if defined(CONFIG_BCM_NETDEV_RFAP_PCI) || defined(CONFIG_BCM_NETDEV_RFAP_PCI_MODULE)
	void (*set_dev_name)(struct net_device *netdev, u32 instance);
	int  (*probe)(struct net_device *netdev, u32 instance);
#else
	void (*set_dev_name)(struct net_device *netdev);
	int  (*probe)(struct net_device *netdev);
#endif
	void (*remove)(struct net_device *netdev);
	int  (*open)(struct net_device *netdev);
	int  (*close)(struct net_device *netdev);
	void (*rx_hook)(struct net_device *netdev, struct sk_buff *skb);
	struct sk_buff *(*alloc_skb)(struct net_device *netdev, int len);
	int (*free_skb)(struct net_device *netdev, struct sk_buff *skb);
	phys_addr_t (*virt_to_phys)(void *buf);
	void *(*phys_to_virt)(phys_addr_t paddr);
	void (*flush_invalidate_buf)(void *start, u32 size);
	void (*invalidate_buf)(void *start, u32 size);

#if defined(CONFIG_BCM_NETDEV_RFAP_PCI) || defined(CONFIG_BCM_NETDEV_RFAP_PCI_MODULE)
	int  (*init_brm_config)(u32 if_id, int enable);
	void (*set_request_id)(u32 if_id, u32 index, u32 request_id);
	int  (*set_next_idx)(u32 if_id, u32 index);
	void (*complete_wakeup)(u32 if_id, int is_tx_complete);
	int  (*enable_irq)(u32 irq);
	int  (*clear_irq)(u32 irq);
	void (*set_ring)(u32 if_id, u32 addr, u32 sz, bool is_rx);
	void (*set_hw_tail)(u32 if_id, u32 tail_addr, u32 tail_idx_addr, bool is_rx);
	void (*set_desc_sz)(u32 if_id, u32 rx_sz, u32 tx_sz);
	void (*set_hw_int_mask_addr)(u32 if_id, u32 addr);
	void (*set_hw_rx_pkt_cnt_addr)(u32 if_id, u32 addr);
	u32  (*get_post_done_intr)(u32 if_id, bool is_rx);
	u32  (*get_index_ptr)(u32 if_id, bool is_rx);
	u32  (*get_brm_instance)(struct net_device *netdev);
#endif
};

static inline struct netdev_rfap_ops *rfap_get_ops(void)
{
	extern struct netdev_rfap_ops netdev_rfap;
	return symbol_get(netdev_rfap);
}
static inline void rfap_put_ops(void)
{
	extern struct netdev_rfap_ops netdev_rfap;
	symbol_put(netdev_rfap);
}

#endif
