/****************************************************************************
 *
 * Copyright (c) 2013 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or
 * its licensors, and may only be used, duplicated, modified or distributed
 * pursuant to the terms and conditions of a separate, written license
 * agreement executed between you and Broadcom (an "Authorized License").
 * Except as set forth in an Authorized License, Broadcom grants no license
 * (express or implied), right to use, or waiver of any kind with respect to
 * the Software, and Broadcom expressly reserves all rights in and to the
 * Software and all intellectual property rights therein.  IF YOU HAVE NO
 * AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY,
 * AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE
 * SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization,
 * constitutes the valuable trade secrets of Broadcom, and you shall use all
 * reasonable efforts to protect the confidentiality thereof, and to use this
 * information only in connection with your use of Broadcom integrated circuit
 * products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED
 * "AS IS" AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS
 * OR WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
 * RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL
 * IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR
 * A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET
 * ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME
 * THE ENTIRE RISK ARISING OUT OF USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM
 * OR ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
 * INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY
 * RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN
 * EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1,
 * WHICHEVER IS GREATER. THESE LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY
 * FAILURE OF ESSENTIAL PURPOSE OF ANY LIMITED REMEDY.
 *
 *******************************************************************************
 *
 * itc_user.h
 * Peter Sulc
 *
 *******************************************************************************/

#ifndef _ITC_USER_H_
#define _ITC_USER_H_

#include <linux/ioctl.h>

#define ITC_IOC_CODE		'>'
#define ITC_TUNNEL_NAME_MAX	32

#define ITC_IOCTL_SERVICE_REGISTER	_IOR(ITC_IOC_CODE,	0, int)
#define ITC_IOCTL_SERVICE_LISTEN	_IOR(ITC_IOC_CODE,	1, rpc_msg)
#define ITC_IOCTL_GET_TUNNEL_ID		_IOR(ITC_IOC_CODE,	2, char[ITC_TUNNEL_NAME_MAX])
#define ITC_IOCTL_SEND_REPLY		_IOW(ITC_IOC_CODE,	3, rpc_msg)
#define ITC_IOCTL_SEND_MESSAGE		_IOW(ITC_IOC_CODE,	4, rpc_msg)
#define ITC_IOCTL_SEND_REQUEST		_IOWR(ITC_IOC_CODE,	5, rpc_msg)
#define ITC_IOCTL_SEND_REQUEST_TIMEOUT	_IOWR(ITC_IOC_CODE,	6, rpc_msg)

/*
 * Allocate/free an uncached buffer suitable for DMA operations and map
 * it into the process's virtual address space. The physical address returned
 * can be embedded in the RPC message data for passing to another CPU or
 * hardware.
 *
 * Make sure that all data members are aligned to 64b boundaries so that
 * implicit alignment is not introduced when userspace apps are compiled
 * as 64b. Also avoid use of pointers and use data types that have explicit
 * length regardless of 32b or 64b userspace app complilation.
 */
struct rpc_user_buf {
	uint64_t	pa;
	uint64_t  	va;
	uint32_t	size;
	uint32_t	rsvd0;
	int32_t  	id;
	uint32_t	rsvd1;
};
typedef struct rpc_user_buf rpc_user_buf;
int rpc_alloc_buf(rpc_user_buf *buf);
int rpc_free_buf(rpc_user_buf *buf);
#define ITC_IOCTL_ALLOC 		_IOWR(ITC_IOC_CODE,	7, rpc_user_buf)
#define ITC_IOCTL_FREE  		_IOWR(ITC_IOC_CODE,	8, rpc_user_buf)

#endif
