LICENSE = "GPL-2.0-only"
LIC_FILES_CHKSUM = "file://COPYING;md5=0ba16794955006770904e8293abcbee5"

HOMEPAGE = "https://github.com/LibertyGlobal/memcr"

FILESEXTRAPATHS_prepend := "${THISDIR}/files:"

SRC_URI = "git://git@github.com/LibertyGlobal/memcr.git;branch=main;protocol=ssh"
SRC_URI += " file://memcr.service"
SRC_URI += " file://0001-RDK-54059-retry-ptrace-seize-on-EPERM.patch"
SRC_URI += " file://0001-RDK-47153-Support-zstd-compression-and-option-to-set-dump-dir-.patch"

INSANE_SKIP_${PN} += "ldflags"

PV = "1.0+git${SRCPV}"
# Code base from 30.08.2024
SRCREV = "b58f2b8e26cab6b67eceaa36fd6ce5a6d04dcd28"

DEPENDS += " util-linux-native lz4 openssl zstd"
RDEPENDS_${PN} = "libcrypto lz4 zstd"

S = "${WORKDIR}/git"

inherit systemd

SYSTEMD_SERVICE_${PN} = "memcr.service"
SYSTEMD_AUTO_ENABLE = "enable"

do_compile () {
	oe_runmake COMPRESS_LZ4=1 COMPRESS_ZSTD=1 CHECKSUM_MD5=1 ENCRYPT=1
}

do_install () {
	install -D -m 755 ${B}/memcr  ${D}${bindir}/memcr
	install -D -m 755 ${B}/parasite.bin  ${D}${bindir}/parasite.bin
	install -D -m 755 ${B}/memcr-client  ${D}${bindir}/memcr-client
	install -d ${D}${libdir}/memcr
	install -D -m 644 ${B}/libencrypt.so ${D}${libdir}/memcr/libencrypt.so
	install -d ${D}${systemd_unitdir}/system
	install -m 0644 ${WORKDIR}/memcr.service ${D}${systemd_unitdir}/system
}

FILES_${PN} += "${systemd_unitdir}/system/memcr.service"
FILES_${PN} += "${bindir}/memcr ${bindir}/parasite.bin ${bindir}/memcr-client"
FILES_${PN} += "${libdir}/memcr/libencrypt.so"
