inherit kernel
require linux-meson.inc

LIC_FILES_CHKSUM = "file://${THISDIR}/../../license/COPYING.GPL;md5=751419260aa954499f7abaabaa882bbe"

#We still need patch even in external src mode
SRCTREECOVEREDTASKS_remove = "do_patch"
FILESEXTRAPATHS_prepend := "${THISDIR}/5.4:"
FILESEXTRAPATHS_prepend := "${THISDIR}/common:"
KBRANCH = "${@bb.utils.contains('DISTRO_FEATURES', 'amlrepo', "amlogic-5.4-dev", "${RDK_GIT_BRANCH}", d)}"
SRC_URI = "${@bb.utils.contains('DISTRO_FEATURES', 'amlrepo', "git://${AML_GIT_ROOT}/kernel/common.git;protocol=${AML_GIT_PROTOCOL};branch=${KBRANCH};",    \
            "${RDK_COMPONENTS_ROOT_GIT}/sdk/soc/amlogic/kernel/linux-5.4;protocol=${RDK_GIT_PROTOCOL};branch=${RDK_GIT_BRANCH}", d)}"
#SRC_URI_append = " file://defconfig"
SRC_URI_append = " file://gki-read_ext_module_config.sh"
SRC_URI_append = " file://gki-read_ext_module_predefine.sh"
SRC_URI_append = " file://common.cfg"
SRC_URI_append = " file://ipc.cfg"
SRC_URI_append_s4 = " file://s4.cfg"
SRC_URI_append_t7 = " file://t7.cfg"
SRC_URI_append_t5w = " file://t5w.cfg"
SRC_URI_append_t5d = " file://t5d.cfg"
SRC_URI_append_t3 = " file://t3.cfg"
SRC_URI_append_sc2 = " file://sc2.cfg"
SRC_URI_append = " file://0001-panel-config-from-dts.patch"
SRC_URI_append = " file://0001-change-hdmi-mixer-name-to-match-K49.patch"
SRC_URI_append = " file://0001-Fix-for-saving-emmc-tuning-info.patch"
SRC_URI_append = " file://0001-Add-changes-to-enable-maintenance-boot-mode.patch"
SRC_URI_append = " file://0001-CVE-2024-47685-netfilter-nf_reject_ipv6-fix-nf_reject_ip6_tcphdr_pu.patch"
SRC_URI_append = " file://0001-CVE-2024-47659-smack-tcp-ipv4-fix-incorrect-labeling.patch"
SRC_URI_append = " file://0001-CVE-2023-2163-bpf-Fix-incorrect-verifier-pruning-due.patch"
SRC_URI_append = " file://0001-CVE-2022-42896-Bluetooth-L2CAP-Add-definitions-for-E.patch"
SRC_URI_append = " file://0002-CVE-2022-42896-Bluetooth-L2CAP-Add-initial-code-for.patch"
SRC_URI_append = " file://0003-CVE-2022-42896-Bluetooth-L2CAP-Fix-accepting-connect.patch"
SRC_URI_append = " file://0001-Bluetooth-L2CAP-fix-use-after-free-in-l2cap_conn_del.patch"
SRC_URI_append = " file://0001-CVE-2022-42719-wifi-mac80211-refactor-elements-parsi.patch"
SRC_URI_append = " file://0001-CVE-2022-42719-wifi-mac80211-fix-MBSSID-parsing-use.patch"
SRC_URI_append = " file://0001-CVE-2023-5178-nvmet-tcp-move-send-recv-error-handlin.patch"
SRC_URI_append = " file://0002-CVE-2023-5178-nvmet-tcp-Fix-a-possible-UAF-in-queue-.patch"

#SRC_URI_append = " file://meson.scc \
#            file://meson.cfg \
#            file://meson-user-config.cfg \
#            file://systemd.cfg \
#            file://logcat.cfg \
#            file://meson-user-patches.scc "
#SRC_URI_append = " ${@get_patch_list('${THISDIR}/armv7a')}"

#Game Controller support
SRC_URI_append = " file://0001-LLAMA-10606-fix-to-remove-noise-events-ps-controllers.patch"
SRC_URI_append = " file://0002-LLAMA-10606-fix-for-xbox-pairing-issue.patch"
SRC_URI_append = " file://0003-LLAMA-10606-fix-for-xbox-mapping.patch"
SRC_URI_append = " file://0004-LLAMA-10606-fix-for-Sony-playstation-mapping.patch"
SRC_URI_append = " file://0005-LLAMA-10606-xbox-mapping.patch"
SRC_URI_append = " file://0006-CPESP-3698-Nintendo-Switch-ProController_Support.patch"
SRC_URI_append = " file://0007-RDKTV-26609fix-battery-level-reporting-on-BT-mice.patch"
SRC_URI_append = " file://0008_RDKTV_28125_adaptive_controller_support.patch"

#Haptic feedback support on All Game Controllers
SRC_URI_append = " file://CPESP-6152_Nintendo_rumble_config.cfg"

#RT Thread Priority DRM patches
SRC_URI_append = " file://0009-RDKTV-30786_drmfb_to_use_high_priority_work_Q.patch"

#For common patches
KDIR = "aml-5.4"
SRC_URI_append = " ${@get_patch_list_with_path('${THISDIR}/amlogic/${KDIR}')}"
#disable CONFIG_USB_VIDEO_CLASS
SRC_URI_append = " file://disable_usb_video_class.cfg"
DEPENDS += "rsync-native"

LINUX_VERSION ?= "5.4.210"
LINUX_VERSION_EXTENSION ?= "-amlogic"

PR = "r2"
SRCREV ?="${AUTOREV}"
PV = "${LINUX_VERSION}+git${SRCPV}"
machine_branch = "${SRCREV}"

COMPATIBLE_MACHINE = "(mesontm2-5.4*|mesonsc2-5.4*|mesont5d-5.4*|mesont7*|mesons4-*|mesont5w-*|mesont3*|sky-llama-pro*|platco*)"

KERNEL_IMAGETYPE = "Image"
KCONFIG_MODE = "alldefconfig"

S = "${WORKDIR}/git"
KBUILD_DEFCONFIG_t7 = "meson64_a64_R_defconfig"
KBUILD_DEFCONFIG_sc2 = "meson64_a64_R_defconfig"
KBUILD_DEFCONFIG_tm2-5.4 = "meson64_a64_R_defconfig"
KBUILD_DEFCONFIG_t5w = "meson64_a64_R_defconfig"
KBUILD_DEFCONFIG_t3 = "meson64_a64_R_defconfig"
KBUILD_DEFCONFIG_s4 = "meson64_a64_R_defconfig"
KBUILD_DEFCONFIG_kernel32 = "meson64_a32_defconfig"


GKI_DEFCONFIG = "meson64_gki_module_config"
GKI_DEFCONFIG_kernel32 = ""

gki_module_compile () {
  oe_runmake -C ${STAGING_KERNEL_DIR}/${1} CC="${KERNEL_CC}" LD="${KERNEL_LD}" O=${B} M=${1} KERNEL_SRC=${S}
}

gki_module_install () {
  cd ${B}; rsync -R $(find ${1} -name *.ko | xargs) ${D}${nonarch_base_libdir}/modules/${KERNEL_VERSION}/kernel/; cd -
}

do_compile_append () {
  if [ -n "${GKI_DEFCONFIG}" ]; then
    #Note, gki_ext_module_config/gki_ext_module_predefine will be used by all kernel module build
    ${WORKDIR}/gki-read_ext_module_config.sh ${S}/arch/arm64/configs/${GKI_DEFCONFIG} > ${STAGING_KERNEL_DIR}/gki_ext_module_config
    ${WORKDIR}/gki-read_ext_module_predefine.sh ${S}/arch/arm64/configs/${GKI_DEFCONFIG} > ${STAGING_KERNEL_DIR}/gki_ext_module_predefine

    export GKI_EXT_MODULE_CONFIG="$(cat ${STAGING_KERNEL_DIR}/gki_ext_module_config)"
    export GKI_EXT_MODULE_PREDEFINE="$(cat ${STAGING_KERNEL_DIR}/gki_ext_module_predefine)"
    gki_module_compile drivers/amlogic
    gki_module_compile sound/soc/amlogic
    gki_module_compile sound/soc/codecs/amlogic
  else
    rm -fr ${STAGING_KERNEL_DIR}/gki_ext_module_config ${STAGING_KERNEL_DIR}/gki_ext_module_predefine
  fi
}

do_install_append () {
  if [ -n "${GKI_DEFCONFIG}" ]; then
    gki_module_install drivers/amlogic
    gki_module_install sound/soc/amlogic
    gki_module_install sound/soc/codecs/amlogic
  fi
}

