PART=$1

#Kill current Sky UI and export westeros variables
systemctl stop sky-appsservice
export XDG_RUNTIME_DIR=/tmp
export LD_PRELOAD=libwesteros_gl.so.0.0.0
export WESTEROS_GL_GRAPHICS_MAX_SIZE=1920x1080
export WESTEROS_GL_MODE=3840x2160x60
export WESTEROS_GL_USE_REFRESH_LOCK=1
export WESTEROS_GL_USE_AMLOGIC_AVSYNC=1
westeros --renderer libwesteros_render_embedded.so.0.0.0 --display main0 --embedded --window-size 1920x1080 --noFBO &
export XDG_RUNTIME_DIR=/tmp
westeros-gl-console set zoom-mode 0
export WAYLAND_DISPLAY=main0
export WESTEROS_SINK_AMLOGIC_USE_DMABUF=1
export WESTEROS_SINK_USE_FREERUN=1
sleep 3

kill_westeros() {
  PIDS=$(ps -eaf)
  PID=$(echo "$PIDS" | grep "westeros" | awk '{print $2}')

  if [[ -z "$PID" ]];
  then(
      echo "No instance of westeros is currently running!"
  )else(
      kill -9 $PID
  )
  fi
}

HORIZONDALLINE="=========================================================="

echo -e "\n$HORIZONDALLINE"
echo -e "\n"
echo "          Available Testcases and Streams"
echo -e "\n$HORIZONDALLINE"

while true; do
  gst-play-dvcert-1.0 --dvlist

  echo -e "\n$HORIZONDALLINE"
  echo -e "\n"

  echo "Choose an option "
  echo "1. Play a Stream"
  echo "2. View DV mode"
  echo -e "3. Exit application\n\n"

  echo "Enter option: "
  read count </dev/tty
  echo -e "\n"

  case $count in
    1)
      echo "Enter Testcase ID to play: "
      read TESTID </dev/tty
      echo -e "\n"

      echo "Choose a DV mode"
      echo "1. Dark Mode"
      echo -e "2. Light mode\n"

      echo "Enter DV mode: "
      read DVMODE </dev/tty
      echo -e "\n"
      case $DVMODE in
        1)
	  curl -d '{"jsonrpc": "2.0","id": 1,"method": "org.rdk.tv.ControlSettings.2.setDolbyVisionMode","params":{"DolbyVisionMode":"dark"}}' http://127.0.0.1:9998/jsonrpc
	  echo -e "\n"
          ;;
        2)
	  curl -d '{"jsonrpc": "2.0","id": 1,"method": "org.rdk.tv.ControlSettings.2.setDolbyVisionMode","params":{"DolbyVisionMode":"bright"}}' http://127.0.0.1:9998/jsonrpc
	  echo -e "\n"
          ;;
        *)
          echo "Choose from the available modes. Thank you!"
          ;;
      esac
      case $TESTID in
        1)
          gst-launch-1.0 filesrc location=/run/media/sda1/Test_Vectors/Dolby_Vision/Adaptive_Streaming_Tests/O_AST-file_based-dvhe.04-02-MP4-23_976/combined_AST_dvhe04-02_23976_10b___st.mp4 ! qtdemux ! h265parse ! westerossink force-aspect-ratio=false
          ;;
        2)
          gst-launch-1.0 filesrc location=/run/media/sda1/Test_Vectors/Dolby_Vision/Adaptive_Streaming_Tests/O_AST-file_based-dvhe.05-00-MP4-23_976/combined_AST_dvhe05-00_23976_10b___st.mp4 ! qtdemux ! h265parse ! westerossink force-aspect-ratio=false
          ;;
        3)
          gst-launch-1.0 filesrc location=/run/media/sda1/Test_Vectors/Dolby_Vision/Adaptive_Streaming_Tests/O_AST-file_based-dvhe.08-02-MP4-23_976/combined_AST_dvhe08-02_23976_10b___st.mp4 ! qtdemux ! h265parse ! westerossink force-aspect-ratio=false
          ;;
        *)
          gst-play-dvcert-1.0 --dvtest=$TESTID
          ;;
      esac
 
      unset count
      unset TESTID
      unset DVMODE
      ;;
    2)
      curl -d '{"jsonrpc": "2.0","id": 1,"method": "org.rdk.tv.ControlSettings.2.getDolbyVisionMode"}' http://127.0.0.1:9998/jsonrpc
      echo -e "\n"
      ;;
    3)
      kill_westeros
      break
      ;;
    *)
      echo "Please choose a valid choice. Thank you!"
      ;;

  esac
done
