/*
 Copyright (C) 2007 Apple Inc.  All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:
 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
*/

if(typeof(WScript) === "undefined")
{
    var WScript = {
        Echo: print
    }
}

function record(time) {
    document.getElementById("console").innerHTML = time + "ms";
    if (window.parent) {
        parent.recordResult(time);
    }
}

"use strict";

var sjcl={cipher:{},hash:{},mode:{},misc:{},codec:{},exception:{corrupt:function(a){this.toString=function(){return"CORRUPT: "+this.message};this.message=a},invalid:function(a){this.toString=function(){return"INVALID: "+this.message};this.message=a},bug:function(a){this.toString=function(){return"BUG: "+this.message};this.message=a}}};
sjcl.cipher.aes=function(a){this.h[0][0][0]||this.w();var b,c,d,e,f=this.h[0][4],g=this.h[1];b=a.length;var h=1;if(b!==4&&b!==6&&b!==8)throw new sjcl.exception.invalid("invalid aes key size");this.a=[d=a.slice(0),e=[]];for(a=b;a<4*b+28;a++){c=d[a-1];if(a%b===0||b===8&&a%b===4){c=f[c>>>24]<<24^f[c>>16&255]<<16^f[c>>8&255]<<8^f[c&255];if(a%b===0){c=c<<8^c>>>24^h<<24;h=h<<1^(h>>7)*283}}d[a]=d[a-b]^c}for(b=0;a;b++,a--){c=d[b&3?a:a-4];e[b]=a<=4||b<4?c:g[0][f[c>>>24]]^g[1][f[c>>16&255]]^g[2][f[c>>8&255]]^
g[3][f[c&255]]}};
sjcl.cipher.aes.prototype={encrypt:function(a){return this.H(a,0)},decrypt:function(a){return this.H(a,1)},h:[[[],[],[],[],[]],[[],[],[],[],[]]],w:function(){var a=this.h[0],b=this.h[1],c=a[4],d=b[4],e,f,g,h=[],i=[],k,j,l,m;for(e=0;e<0x100;e++)i[(h[e]=e<<1^(e>>7)*283)^e]=e;for(f=g=0;!c[f];f^=k||1,g=i[g]||1){l=g^g<<1^g<<2^g<<3^g<<4;l=l>>8^l&255^99;c[f]=l;d[l]=f;j=h[e=h[k=h[f]]];m=j*0x1010101^e*0x10001^k*0x101^f*0x1010100;j=h[l]*0x101^l*0x1010100;for(e=0;e<4;e++){a[e][f]=j=j<<24^j>>>8;b[e][l]=m=m<<24^m>>>8}}for(e=
0;e<5;e++){a[e]=a[e].slice(0);b[e]=b[e].slice(0)}},H:function(a,b){if(a.length!==4)throw new sjcl.exception.invalid("invalid aes block size");var c=this.a[b],d=a[0]^c[0],e=a[b?3:1]^c[1],f=a[2]^c[2];a=a[b?1:3]^c[3];var g,h,i,k=c.length/4-2,j,l=4,m=[0,0,0,0];g=this.h[b];var n=g[0],o=g[1],p=g[2],q=g[3],r=g[4];for(j=0;j<k;j++){g=n[d>>>24]^o[e>>16&255]^p[f>>8&255]^q[a&255]^c[l];h=n[e>>>24]^o[f>>16&255]^p[a>>8&255]^q[d&255]^c[l+1];i=n[f>>>24]^o[a>>16&255]^p[d>>8&255]^q[e&255]^c[l+2];a=n[a>>>24]^o[d>>16&
255]^p[e>>8&255]^q[f&255]^c[l+3];l+=4;d=g;e=h;f=i}for(j=0;j<4;j++){m[b?3&-j:j]=r[d>>>24]<<24^r[e>>16&255]<<16^r[f>>8&255]<<8^r[a&255]^c[l++];g=d;d=e;e=f;f=a;a=g}return m}};
sjcl.bitArray={bitSlice:function(a,b,c){a=sjcl.bitArray.P(a.slice(b/32),32-(b&31)).slice(1);return c===undefined?a:sjcl.bitArray.clamp(a,c-b)},concat:function(a,b){if(a.length===0||b.length===0)return a.concat(b);var c=a[a.length-1],d=sjcl.bitArray.getPartial(c);return d===32?a.concat(b):sjcl.bitArray.P(b,d,c|0,a.slice(0,a.length-1))},bitLength:function(a){var b=a.length;if(b===0)return 0;return(b-1)*32+sjcl.bitArray.getPartial(a[b-1])},clamp:function(a,b){if(a.length*32<b)return a;a=a.slice(0,Math.ceil(b/
32));var c=a.length;b&=31;if(c>0&&b)a[c-1]=sjcl.bitArray.partial(b,a[c-1]&2147483648>>b-1,1);return a},partial:function(a,b,c){if(a===32)return b;return(c?b|0:b<<32-a)+a*0x10000000000},getPartial:function(a){return Math.round(a/0x10000000000)||32},equal:function(a,b){if(sjcl.bitArray.bitLength(a)!==sjcl.bitArray.bitLength(b))return false;var c=0,d;for(d=0;d<a.length;d++)c|=a[d]^b[d];return c===0},P:function(a,b,c,d){var e;e=0;if(d===undefined)d=[];for(;b>=32;b-=32){d.push(c);c=0}if(b===0)return d.concat(a);
for(e=0;e<a.length;e++){d.push(c|a[e]>>>b);c=a[e]<<32-b}e=a.length?a[a.length-1]:0;a=sjcl.bitArray.getPartial(e);d.push(sjcl.bitArray.partial(b+a&31,b+a>32?c:d.pop(),1));return d},k:function(a,b){return[a[0]^b[0],a[1]^b[1],a[2]^b[2],a[3]^b[3]]}};
sjcl.codec.utf8String={fromBits:function(a){var b="",c=sjcl.bitArray.bitLength(a),d,e;for(d=0;d<c/8;d++){if((d&3)===0)e=a[d/4];b+=String.fromCharCode(e>>>24);e<<=8}return decodeURIComponent(escape(b))},toBits:function(a){a=unescape(encodeURIComponent(a));var b=[],c,d=0;for(c=0;c<a.length;c++){d=d<<8|a.charCodeAt(c);if((c&3)===3){b.push(d);d=0}}c&3&&b.push(sjcl.bitArray.partial(8*(c&3),d));return b}};
sjcl.codec.hex={fromBits:function(a){var b="",c;for(c=0;c<a.length;c++)b+=((a[c]|0)+0xf00000000000).toString(16).substr(4);return b.substr(0,sjcl.bitArray.bitLength(a)/4)},toBits:function(a){var b,c=[],d;a=a.replace(/\s|0x/g,"");d=a.length;a+="00000000";for(b=0;b<a.length;b+=8)c.push(parseInt(a.substr(b,8),16)^0);return sjcl.bitArray.clamp(c,d*4)}};
sjcl.codec.base64={D:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",fromBits:function(a,b){var c="",d,e=0,f=sjcl.codec.base64.D,g=0,h=sjcl.bitArray.bitLength(a);for(d=0;c.length*6<h;){c+=f.charAt((g^a[d]>>>e)>>>26);if(e<6){g=a[d]<<6-e;e+=26;d++}else{g<<=6;e-=6}}for(;c.length&3&&!b;)c+="=";return c},toBits:function(a){a=a.replace(/\s|=/g,"");var b=[],c,d=0,e=sjcl.codec.base64.D,f=0,g;for(c=0;c<a.length;c++){g=e.indexOf(a.charAt(c));if(g<0)throw new sjcl.exception.invalid("this isn't base64!");
if(d>26){d-=26;b.push(f^g>>>d);f=g<<32-d}else{d+=6;f^=g<<32-d}}d&56&&b.push(sjcl.bitArray.partial(d&56,f,1));return b}};sjcl.hash.sha256=function(a){this.a[0]||this.w();if(a){this.n=a.n.slice(0);this.i=a.i.slice(0);this.e=a.e}else this.reset()};sjcl.hash.sha256.hash=function(a){return(new sjcl.hash.sha256).update(a).finalize()};
sjcl.hash.sha256.prototype={blockSize:512,reset:function(){this.n=this.N.slice(0);this.i=[];this.e=0;return this},update:function(a){if(typeof a==="string")a=sjcl.codec.utf8String.toBits(a);var b,c=this.i=sjcl.bitArray.concat(this.i,a);b=this.e;a=this.e=b+sjcl.bitArray.bitLength(a);for(b=512+b&-512;b<=a;b+=512)this.C(c.splice(0,16));return this},finalize:function(){var a,b=this.i,c=this.n;b=sjcl.bitArray.concat(b,[sjcl.bitArray.partial(1,1)]);for(a=b.length+2;a&15;a++)b.push(0);b.push(Math.floor(this.e/
4294967296));for(b.push(this.e|0);b.length;)this.C(b.splice(0,16));this.reset();return c},N:[],a:[],w:function(){function a(e){return(e-Math.floor(e))*0x100000000|0}var b=0,c=2,d;a:for(;b<64;c++){for(d=2;d*d<=c;d++)if(c%d===0)continue a;if(b<8)this.N[b]=a(Math.pow(c,0.5));this.a[b]=a(Math.pow(c,1/3));b++}},C:function(a){var b,c,d=a.slice(0),e=this.n,f=this.a,g=e[0],h=e[1],i=e[2],k=e[3],j=e[4],l=e[5],m=e[6],n=e[7];for(a=0;a<64;a++){if(a<16)b=d[a];else{b=d[a+1&15];c=d[a+14&15];b=d[a&15]=(b>>>7^b>>>18^
b>>>3^b<<25^b<<14)+(c>>>17^c>>>19^c>>>10^c<<15^c<<13)+d[a&15]+d[a+9&15]|0}b=b+n+(j>>>6^j>>>11^j>>>25^j<<26^j<<21^j<<7)+(m^j&(l^m))+f[a];n=m;m=l;l=j;j=k+b|0;k=i;i=h;h=g;g=b+(h&i^k&(h^i))+(h>>>2^h>>>13^h>>>22^h<<30^h<<19^h<<10)|0}e[0]=e[0]+g|0;e[1]=e[1]+h|0;e[2]=e[2]+i|0;e[3]=e[3]+k|0;e[4]=e[4]+j|0;e[5]=e[5]+l|0;e[6]=e[6]+m|0;e[7]=e[7]+n|0}};
sjcl.mode.ccm={name:"ccm",encrypt:function(a,b,c,d,e){var f,g=b.slice(0),h=sjcl.bitArray,i=h.bitLength(c)/8,k=h.bitLength(g)/8;e=e||64;d=d||[];if(i<7)throw new sjcl.exception.invalid("ccm: iv must be at least 7 bytes");for(f=2;f<4&&k>>>8*f;f++);if(f<15-i)f=15-i;c=h.clamp(c,8*(15-f));b=sjcl.mode.ccm.G(a,b,c,d,e,f);g=sjcl.mode.ccm.I(a,g,c,b,e,f);return h.concat(g.data,g.tag)},decrypt:function(a,b,c,d,e){e=e||64;d=d||[];var f=sjcl.bitArray,g=f.bitLength(c)/8,h=f.bitLength(b),i=f.clamp(b,h-e),k=f.bitSlice(b,
h-e);h=(h-e)/8;if(g<7)throw new sjcl.exception.invalid("ccm: iv must be at least 7 bytes");for(b=2;b<4&&h>>>8*b;b++);if(b<15-g)b=15-g;c=f.clamp(c,8*(15-b));i=sjcl.mode.ccm.I(a,i,c,k,e,b);a=sjcl.mode.ccm.G(a,i.data,c,d,e,b);if(!f.equal(i.tag,a))throw new sjcl.exception.corrupt("ccm: tag doesn't match");return i.data},G:function(a,b,c,d,e,f){var g=[],h=sjcl.bitArray,i=h.k;e/=8;if(e%2||e<4||e>16)throw new sjcl.exception.invalid("ccm: invalid tag length");if(d.length>0xffffffff||b.length>0xffffffff)throw new sjcl.exception.bug("ccm: can't deal with 4GiB or more data");
f=[h.partial(8,(d.length?64:0)|e-2<<2|f-1)];f=h.concat(f,c);f[3]|=h.bitLength(b)/8;f=a.encrypt(f);if(d.length){c=h.bitLength(d)/8;if(c<=65279)g=[h.partial(16,c)];else if(c<=0xffffffff)g=h.concat([h.partial(16,65534)],[c]);g=h.concat(g,d);for(d=0;d<g.length;d+=4)f=a.encrypt(i(f,g.slice(d,d+4)))}for(d=0;d<b.length;d+=4)f=a.encrypt(i(f,b.slice(d,d+4)));return h.clamp(f,e*8)},I:function(a,b,c,d,e,f){var g,h=sjcl.bitArray;g=h.k;var i=b.length,k=h.bitLength(b);c=h.concat([h.partial(8,f-1)],c).concat([0,
0,0]).slice(0,4);d=h.bitSlice(g(d,a.encrypt(c)),0,e);if(!i)return{tag:d,data:[]};for(g=0;g<i;g+=4){c[3]++;e=a.encrypt(c);b[g]^=e[0];b[g+1]^=e[1];b[g+2]^=e[2];b[g+3]^=e[3]}return{tag:d,data:h.clamp(b,k)}}};
sjcl.mode.ocb2={name:"ocb2",encrypt:function(a,b,c,d,e,f){if(sjcl.bitArray.bitLength(c)!==128)throw new sjcl.exception.invalid("ocb iv must be 128 bits");var g,h=sjcl.mode.ocb2.A,i=sjcl.bitArray,k=i.k,j=[0,0,0,0];c=h(a.encrypt(c));var l,m=[];d=d||[];e=e||64;for(g=0;g+4<b.length;g+=4){l=b.slice(g,g+4);j=k(j,l);m=m.concat(k(c,a.encrypt(k(c,l))));c=h(c)}l=b.slice(g);b=i.bitLength(l);g=a.encrypt(k(c,[0,0,0,b]));l=i.clamp(k(l,g),b);j=k(j,k(l,g));j=a.encrypt(k(j,k(c,h(c))));if(d.length)j=k(j,f?d:sjcl.mode.ocb2.pmac(a,
d));return m.concat(i.concat(l,i.clamp(j,e)))},decrypt:function(a,b,c,d,e,f){if(sjcl.bitArray.bitLength(c)!==128)throw new sjcl.exception.invalid("ocb iv must be 128 bits");e=e||64;var g=sjcl.mode.ocb2.A,h=sjcl.bitArray,i=h.k,k=[0,0,0,0],j=g(a.encrypt(c)),l,m,n=sjcl.bitArray.bitLength(b)-e,o=[];d=d||[];for(c=0;c+4<n/32;c+=4){l=i(j,a.decrypt(i(j,b.slice(c,c+4))));k=i(k,l);o=o.concat(l);j=g(j)}m=n-c*32;l=a.encrypt(i(j,[0,0,0,m]));l=i(l,h.clamp(b.slice(c),m));k=i(k,l);k=a.encrypt(i(k,i(j,g(j))));if(d.length)k=
i(k,f?d:sjcl.mode.ocb2.pmac(a,d));if(!h.equal(h.clamp(k,e),h.bitSlice(b,n)))throw new sjcl.exception.corrupt("ocb: tag doesn't match");return o.concat(h.clamp(l,m))},pmac:function(a,b){var c,d=sjcl.mode.ocb2.A,e=sjcl.bitArray,f=e.k,g=[0,0,0,0],h=a.encrypt([0,0,0,0]);h=f(h,d(d(h)));for(c=0;c+4<b.length;c+=4){h=d(h);g=f(g,a.encrypt(f(h,b.slice(c,c+4))))}b=b.slice(c);if(e.bitLength(b)<128){h=f(h,d(h));b=e.concat(b,[2147483648|0])}g=f(g,b);return a.encrypt(f(d(f(h,d(h))),g))},A:function(a){return[a[0]<<
1^a[1]>>>31,a[1]<<1^a[2]>>>31,a[2]<<1^a[3]>>>31,a[3]<<1^(a[0]>>>31)*135]}};sjcl.misc.hmac=function(a,b){this.M=b=b||sjcl.hash.sha256;var c=[[],[]],d=b.prototype.blockSize/32;this.l=[new b,new b];if(a.length>d)a=b.hash(a);for(b=0;b<d;b++){c[0][b]=a[b]^909522486;c[1][b]=a[b]^1549556828}this.l[0].update(c[0]);this.l[1].update(c[1])};sjcl.misc.hmac.prototype.encrypt=sjcl.misc.hmac.prototype.mac=function(a,b){a=(new this.M(this.l[0])).update(a,b).finalize();return(new this.M(this.l[1])).update(a).finalize()};
sjcl.misc.pbkdf2=function(a,b,c,d,e){c=c||1E3;if(d<0||c<0)throw sjcl.exception.invalid("invalid params to pbkdf2");if(typeof a==="string")a=sjcl.codec.utf8String.toBits(a);e=e||sjcl.misc.hmac;a=new e(a);var f,g,h,i,k=[],j=sjcl.bitArray;for(i=1;32*k.length<(d||1);i++){e=f=a.encrypt(j.concat(b,[i]));for(g=1;g<c;g++){f=a.encrypt(f);for(h=0;h<f.length;h++)e[h]^=f[h]}k=k.concat(e)}if(d)k=j.clamp(k,d);return k};
sjcl.random={randomWords:function(a,b){var c=[];b=this.isReady(b);var d;if(b===0)throw new sjcl.exception.notready("generator isn't seeded");else b&2&&this.U(!(b&1));for(b=0;b<a;b+=4){(b+1)%0x10000===0&&this.L();d=this.u();c.push(d[0],d[1],d[2],d[3])}this.L();return c.slice(0,a)},setDefaultParanoia:function(a){this.t=a},addEntropy:function(a,b,c){c=c||"user";var d,e,f=(new Date).valueOf(),g=this.q[c],h=this.isReady();d=this.F[c];if(d===undefined)d=this.F[c]=this.R++;if(g===undefined)g=this.q[c]=0;this.q[c]=
(this.q[c]+1)%this.b.length;switch(typeof a){case "number":break;case "object":if(b===undefined)for(c=b=0;c<a.length;c++)for(e=a[c];e>0;){b++;e>>>=1}this.b[g].update([d,this.J++,2,b,f,a.length].concat(a));break;case "string":if(b===undefined)b=a.length;this.b[g].update([d,this.J++,3,b,f,a.length]);this.b[g].update(a);break;default:throw new sjcl.exception.bug("random: addEntropy only supports number, array or string");}this.j[g]+=b;this.f+=b;if(h===0){this.isReady()!==0&&this.K("seeded",Math.max(this.g,
this.f));this.K("progress",this.getProgress())}},isReady:function(a){a=this.B[a!==undefined?a:this.t];return this.g&&this.g>=a?this.j[0]>80&&(new Date).valueOf()>this.O?3:1:this.f>=a?2:0},getProgress:function(a){a=this.B[a?a:this.t];return this.g>=a?1["0"]:this.f>a?1["0"]:this.f/a},startCollectors:function(){if(!this.m){if(window.addEventListener){window.addEventListener("load",this.o,false);window.addEventListener("mousemove",this.p,false)}else if(document.attachEvent){document.attachEvent("onload",
this.o);document.attachEvent("onmousemove",this.p)}else throw new sjcl.exception.bug("can't attach event");this.m=true}},stopCollectors:function(){if(this.m){if(window.removeEventListener){window.removeEventListener("load",this.o);window.removeEventListener("mousemove",this.p)}else if(window.detachEvent){window.detachEvent("onload",this.o);window.detachEvent("onmousemove",this.p)}this.m=false}},addEventListener:function(a,b){this.r[a][this.Q++]=b},removeEventListener:function(a,b){var c;a=this.r[a];
var d=[];for(c in a)a.hasOwnProperty[c]&&a[c]===b&&d.push(c);for(b=0;b<d.length;b++){c=d[b];delete a[c]}},b:[new sjcl.hash.sha256],j:[0],z:0,q:{},J:0,F:{},R:0,g:0,f:0,O:0,a:[0,0,0,0,0,0,0,0],d:[0,0,0,0],s:undefined,t:6,m:false,r:{progress:{},seeded:{}},Q:0,B:[0,48,64,96,128,192,0x100,384,512,768,1024],u:function(){for(var a=0;a<4;a++){this.d[a]=this.d[a]+1|0;if(this.d[a])break}return this.s.encrypt(this.d)},L:function(){this.a=this.u().concat(this.u());this.s=new sjcl.cipher.aes(this.a)},T:function(a){this.a=
sjcl.hash.sha256.hash(this.a.concat(a));this.s=new sjcl.cipher.aes(this.a);for(a=0;a<4;a++){this.d[a]=this.d[a]+1|0;if(this.d[a])break}},U:function(a){var b=[],c=0,d;this.O=b[0]=(new Date).valueOf()+3E4;for(d=0;d<16;d++)b.push(Math.random()*0x100000000|0);for(d=0;d<this.b.length;d++){b=b.concat(this.b[d].finalize());c+=this.j[d];this.j[d]=0;if(!a&&this.z&1<<d)break}if(this.z>=1<<this.b.length){this.b.push(new sjcl.hash.sha256);this.j.push(0)}this.f-=c;if(c>this.g)this.g=c;this.z++;this.T(b)},p:function(a){sjcl.random.addEntropy([a.x||
a.clientX||a.offsetX,a.y||a.clientY||a.offsetY],2,"mouse")},o:function(){sjcl.random.addEntropy(new Date,2,"loadtime")},K:function(a,b){var c;a=sjcl.random.r[a];var d=[];for(c in a)a.hasOwnProperty(c)&&d.push(a[c]);for(c=0;c<d.length;c++)d[c](b)}};
sjcl.json={defaults:{v:1,iter:1E3,ks:128,ts:64,mode:"ccm",adata:"",cipher:"aes"},encrypt:function(a,b,c,d){c=c||{};d=d||{};var e=sjcl.json,f=e.c({iv:sjcl.random.randomWords(4,0)},e.defaults);e.c(f,c);if(typeof f.salt==="string")f.salt=sjcl.codec.base64.toBits(f.salt);if(typeof f.iv==="string")f.iv=sjcl.codec.base64.toBits(f.iv);if(!sjcl.mode[f.mode]||!sjcl.cipher[f.cipher]||typeof a==="string"&&f.iter<=100||f.ts!==64&&f.ts!==96&&f.ts!==128||f.ks!==128&&f.ks!==192&&f.ks!==0x100||f.iv.length<2||f.iv.length>
4)throw new sjcl.exception.invalid("json encrypt: invalid parameters");if(typeof a==="string"){c=sjcl.misc.cachedPbkdf2(a,f);a=c.key.slice(0,f.ks/32);f.salt=c.salt}if(typeof b==="string")b=sjcl.codec.utf8String.toBits(b);c=new sjcl.cipher[f.cipher](a);e.c(d,f);d.key=a;f.ct=sjcl.mode[f.mode].encrypt(c,b,f.iv,f.adata,f.tag);return e.encode(e.V(f,e.defaults))},decrypt:function(a,b,c,d){c=c||{};d=d||{};var e=sjcl.json;b=e.c(e.c(e.c({},e.defaults),e.decode(b)),c,true);if(typeof b.salt==="string")b.salt=
sjcl.codec.base64.toBits(b.salt);if(typeof b.iv==="string")b.iv=sjcl.codec.base64.toBits(b.iv);if(!sjcl.mode[b.mode]||!sjcl.cipher[b.cipher]||typeof a==="string"&&b.iter<=100||b.ts!==64&&b.ts!==96&&b.ts!==128||b.ks!==128&&b.ks!==192&&b.ks!==0x100||!b.iv||b.iv.length<2||b.iv.length>4)throw new sjcl.exception.invalid("json decrypt: invalid parameters");if(typeof a==="string"){c=sjcl.misc.cachedPbkdf2(a,b);a=c.key.slice(0,b.ks/32);b.salt=c.salt}c=new sjcl.cipher[b.cipher](a);c=sjcl.mode[b.mode].decrypt(c,
b.ct,b.iv,b.adata,b.tag);e.c(d,b);d.key=a;return sjcl.codec.utf8String.fromBits(c)},encode:function(a){var b,c="{",d="";for(b in a)if(a.hasOwnProperty(b)){if(!b.match(/^[a-z0-9]+$/i))throw new sjcl.exception.invalid("json encode: invalid property name");c+=d+b+":";d=",";switch(typeof a[b]){case "number":case "boolean":c+=a[b];break;case "string":c+='"'+escape(a[b])+'"';break;case "object":c+='"'+sjcl.codec.base64.fromBits(a[b],1)+'"';break;default:throw new sjcl.exception.bug("json encode: unsupported type");
}}return c+"}"},decode:function(a){a=a.replace(/\s/g,"");if(!a.match(/^\{.*\}$/))throw new sjcl.exception.invalid("json decode: this isn't json!");a=a.replace(/^\{|\}$/g,"").split(/,/);var b={},c,d;for(c=0;c<a.length;c++){if(!(d=a[c].match(/^([a-z][a-z0-9]*):(?:(\d+)|"([a-z0-9+\/%*_.@=\-]*)")$/i)))throw new sjcl.exception.invalid("json decode: this isn't json!");b[d[1]]=d[2]?parseInt(d[2],10):d[1].match(/^(ct|salt|iv)$/)?sjcl.codec.base64.toBits(d[3]):unescape(d[3])}return b},c:function(a,b,c){if(a===
undefined)a={};if(b===undefined)return a;var d;for(d in b)if(b.hasOwnProperty(d)){if(c&&a[d]!==undefined&&a[d]!==b[d])throw new sjcl.exception.invalid("required parameter overridden");a[d]=b[d]}return a},V:function(a,b){var c={},d;for(d in a)if(a.hasOwnProperty(d)&&a[d]!==b[d])c[d]=a[d];return c},W:function(a,b){var c={},d;for(d=0;d<b.length;d++)if(a[b[d]]!==undefined)c[b[d]]=a[b[d]];return c}};sjcl.encrypt=sjcl.json.encrypt;sjcl.decrypt=sjcl.json.decrypt;sjcl.misc.S={};
sjcl.misc.cachedPbkdf2=function(a,b){var c=sjcl.misc.S,d;b=b||{};d=b.iter||1E3;c=c[a]=c[a]||{};d=c[d]=c[d]||{firstSalt:b.salt&&b.salt.length?b.salt.slice(0):sjcl.random.randomWords(2,0)};c=b.salt===undefined?d.firstSalt:b.salt;d[c]=d[c]||sjcl.misc.pbkdf2(a,c,b.iter);return{key:d[c].slice(0),salt:c.slice(0)}};


var browserUtil = {
  isRhino: true,
  
  pauseAndThen: function (cb) { cb(); },
  
  cpsIterate: function (f, start, end, pause, callback) {
    function go() {
      var called = false;
      if (start >= end) {
        callback && callback();
      } else {
        f(start, function () {
          if (!called) { called = true; start++; go(); }
        });
      }
    }
    go (start);
  },
  
  cpsMap: function (map, list, pause, callback) {
    browserUtil.cpsIterate(function (i, cb) { map(list[i], i, list.length, cb); },
                           0, list.length, pause, callback);
  },

  loadScripts: function(scriptNames, callback) {
    for (i=0; i<scriptNames.length; i++) {
      load(scriptNames[i]);
      callback && callback();
    }
  },
  
  write: function(type, message) {
    print(message);
    return { update: function (type2, message2) {
      if (type2 === 'pass') { print("  + " + message2); }
      else if (type2 === 'unimplemented') { print("  ? " + message2); }
      else { print("  - " + message2); }
    }};
  },
  
  writeNewline: function () { print(""); },
  
  status: function(message) {}
};

sjcl.test = { vector: {}, all: {} };

/* A bit of a hack.  Because sjcl.test will be reloaded several times
 * for different variants of sjcl, but browserUtils will not, this
 * variable keeps a permanent record of whether anything has failed.
 */
if (typeof browserUtil.allPassed === 'undefined') {
    browserUtil.allPassed = true;
}

sjcl.test.TestCase = function(name, doRun) {
  this.doRun = doRun;
  this.name = name;
  this.passes = 0;
  this.failures = 0;
  this.isUnimplemented = false;
  sjcl.test.all[name] = this;
};

sjcl.test.TestCase.prototype = {
  /** Pass some subtest of this test */
  pass: function () { this.passes ++; },
  
  /** Fail some subtest of this test */
  fail: function (message) {
    if (message !== undefined) {
      this.log("fail", "*** FAIL *** " + this.name + ": " + message);
    } else {
      this.log("fail", "*** FAIL *** " + this.name);
    }
    this.failures ++;
    browserUtil.allPassed = false;
  },
  
  unimplemented: function() {
    this.isUnimplemented = true;
  },
  
  /** Log a message to the console */
  log: browserUtil.write,
  
  /** Require that the first argument is true; otherwise fail with the given message */
  require: function (bool, message) {
    if (bool) {
      this.pass();
    } else if (message !== undefined) {
      this.fail(message);
    } else {
      this.fail("requirement failed");
    }
  },

  /** Pause and then take the specified action. */
  pauseAndThen: browserUtil.pauseAndThen,
  
  /** Continuation-passing-style iteration */
  cpsIterate: browserUtil.cpsIterate,
  
  /** Continuation-passing-style iteration */
  cpsMap: browserUtil.cpsMap,

  /** Report the results of this test. */
  report: function (repo) {
    var t = (new Date()).valueOf() - this.startTime;
    if (this.failures !== 0) {
      repo.update("fail", "failed " + this.failures + " / " +
                  (this.passes + this.failures) + " tests. (" + t + " ms)");
    } else if (this.passes === 1) {
      repo.update("pass", "passed. (" + t + " ms)");
    } else if (this.isUnimplemented) {
      repo.update("unimplemented", "unimplemented");
    } else {
      repo.update("pass", "passed all " + this.passes + " tests. (" + t + " ms)");
    }
    browserUtil.writeNewline();
  },
  

  /** Run the test. */
  run: function (ntests, i, cb) {
    var thiz = this;
    this.startTime = (new Date()).valueOf();
    this.pauseAndThen(function () {
      thiz.doRun(function () {
        cb && cb();
      })
    });
  }
};

// pass a list of tests to run, or pass nothing and it will run them all
sjcl.test.run = function (tests, callback) {
  var t;
    
  if (tests === undefined || tests.length == 0) {
    tests = [];
    for (t in sjcl.test.all) {
      if (sjcl.test.all.hasOwnProperty(t)) {
        tests.push(t);
      }
    }
  }
  
  browserUtil.cpsMap(function (t, i, n, cb) {
    sjcl.test.all[tests[i]].run(n, i+1, cb);
  }, tests, true, callback);
};

/* Several test scripts rely on sjcl.codec.hex to parse their test
 * vectors, but we are not guaranteed that sjcl.codec.hex is
 * implemented.
 */
sjcl.codec = sjcl.codec || {};
sjcl.codec.hex = sjcl.codec.hex ||
{
  fromBits: function (arr) {
    var out = "", i, x;
    for (i=0; i<arr.length; i++) {
      out += ((arr[i]|0)+0xF00000000000).toString(16).substr(4);
    }
    return out.substr(0, sjcl.bitArray.bitLength(arr)/4);//.replace(/(.{8})/g, "$1 ");
  },
  toBits: function (str) {
    var i, out=[], len;
    str = str.replace(/\s|0x/g, "");
    len = str.length;
    str = str + "00000000";
    for (i=0; i<str.length; i+=8) {
      out.push(parseInt(str.substr(i,8),16)^0);
    }
    return sjcl.bitArray.clamp(out, len*4);
  }
};

sjcl.test.vector.aes = [ 
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xf34481ec,0x3cc627ba,0xcd5dc3fb,0x08f273e6],
    ct:  [0x0336763e,0x966d9259,0x5a567cc9,0xce537f5e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x9798c464,0x0bad75c7,0xc3227db9,0x10174e72],
    ct:  [0xa9a1631b,0xf4996954,0xebc09395,0x7b234589] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x96ab5c2f,0xf612d9df,0xaae8c31f,0x30c42168],
    ct:  [0xff4f8391,0xa6a40ca5,0xb25d23be,0xdd44a597] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x6a118a87,0x4519e64e,0x9963798a,0x503f1d35],
    ct:  [0xdc43be40,0xbe0e5371,0x2f7e2bf5,0xca707209] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xcb9fceec,0x81286ca3,0xe989bd97,0x9b0cb284],
    ct:  [0x92beedab,0x1895a94f,0xaa69b632,0xe5cc47ce] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xb26aeb18,0x74e47ca8,0x358ff223,0x78f09144],
    ct:  [0x459264f4,0x798f6a78,0xbacb89c1,0x5ed3d601] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x58c8e00b,0x2631686d,0x54eab84b,0x91f0aca1],
    ct:  [0x08a4e2ef,0xec8a8e33,0x12ca7460,0xb9040bbf] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xf34481ec,0x3cc627ba,0xcd5dc3fb,0x08f273e6],
    ct:  [0x0336763e,0x966d9259,0x5a567cc9,0xce537f5e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x9798c464,0x0bad75c7,0xc3227db9,0x10174e72],
    ct:  [0xa9a1631b,0xf4996954,0xebc09395,0x7b234589] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x96ab5c2f,0xf612d9df,0xaae8c31f,0x30c42168],
    ct:  [0xff4f8391,0xa6a40ca5,0xb25d23be,0xdd44a597] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x6a118a87,0x4519e64e,0x9963798a,0x503f1d35],
    ct:  [0xdc43be40,0xbe0e5371,0x2f7e2bf5,0xca707209] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xcb9fceec,0x81286ca3,0xe989bd97,0x9b0cb284],
    ct:  [0x92beedab,0x1895a94f,0xaa69b632,0xe5cc47ce] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xb26aeb18,0x74e47ca8,0x358ff223,0x78f09144],
    ct:  [0x459264f4,0x798f6a78,0xbacb89c1,0x5ed3d601] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x58c8e00b,0x2631686d,0x54eab84b,0x91f0aca1],
    ct:  [0x08a4e2ef,0xec8a8e33,0x12ca7460,0xb9040bbf] },
  { key: [0x10a58869,0xd74be5a3,0x74cf867c,0xfb473859],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6d251e69,0x44b051e0,0x4eaa6fb4,0xdbf78465] },
  { key: [0xcaea65cd,0xbb75e916,0x9ecd22eb,0xe6e54675],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6e292011,0x90152df4,0xee058139,0xdef610bb] },
  { key: [0xa2e2fa9b,0xaf7d2082,0x2ca9f054,0x2f764a41],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc3b44b95,0xd9d2f256,0x70eee9a0,0xde099fa3] },
  { key: [0xb6364ac4,0xe1de1e28,0x5eaf144a,0x2415f7a0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5d9b0557,0x8fc944b3,0xcf1ccf0e,0x746cd581] },
  { key: [0x64cf9c7a,0xbc50b888,0xaf65f49d,0x521944b2],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf7efc89d,0x5dba5781,0x04016ce5,0xad659c05] },
  { key: [0x47d6742e,0xefcc0465,0xdc96355e,0x851b64d9],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0306194f,0x666d1836,0x24aa230a,0x8b264ae7] },
  { key: [0x3eb39790,0x678c56be,0xe34bbcde,0xccf6cdb5],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x858075d5,0x36d79cce,0xe571f7d7,0x204b1f67] },
  { key: [0x64110a92,0x4f0743d5,0x00ccadae,0x72c13427],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x35870c6a,0x57e9e923,0x14bcb808,0x7cde72ce] },
  { key: [0x18d81265,0x16f8a12a,0xb1a36d9f,0x04d68e51],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6c68e9be,0x5ec41e22,0xc825b7c7,0xaffb4363] },
  { key: [0xf5303579,0x68578480,0xb398a3c2,0x51cd1093],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf5df3999,0x0fc688f1,0xb07224cc,0x03e86cea] },
  { key: [0xda84367f,0x325d42d6,0x01b43269,0x64802e8e],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbba071bc,0xb470f8f6,0x586e5d3a,0xdd18bc66] },
  { key: [0xe37b1c6a,0xa2846f6f,0xdb413f23,0x8b089f23],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x43c9f7e6,0x2f5d288b,0xb27aa40e,0xf8fe1ea8] },
  { key: [0x6c002b68,0x2483e0ca,0xbcc731c2,0x53be5674],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3580d19c,0xff44f101,0x4a7c966a,0x69059de5] },
  { key: [0x143ae8ed,0x6555aba9,0x6110ab58,0x893a8ae1],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x806da864,0xdd29d48d,0xeafbe764,0xf8202aef] },
  { key: [0xb69418a8,0x5332240d,0xc8249235,0x3956ae0c],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa303d940,0xded8f0ba,0xff6f7541,0x4cac5243] },
  { key: [0x71b5c08a,0x1993e136,0x2e4d0ce9,0xb22b78d5],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc2dabd11,0x7f8a3eca,0xbfbb11d1,0x2194d9d0] },
  { key: [0xe234cdca,0x2606b81f,0x29408d5f,0x6da21206],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfff60a47,0x40086b3b,0x9c56195b,0x98d91a7b] },
  { key: [0x13237c49,0x074a3da0,0x78dc1d82,0x8bb78c6f],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8146a08e,0x2357f0ca,0xa30ca8c9,0x4d1a0544] },
  { key: [0x3071a2a4,0x8fe6cbd0,0x4f1a1290,0x98e308f8],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4b98e06d,0x356deb07,0xebb824e5,0x713f7be3] },
  { key: [0x90f42ec0,0xf68385f2,0xffc5dfc0,0x3a654dce],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7a20a53d,0x460fc9ce,0x0423a7a0,0x764c6cf2] },
  { key: [0xfebd9a24,0xd8b65c1c,0x787d50a4,0xed3619a9],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf4a70d8a,0xf877f9b0,0x2b4c40df,0x57d45b17] },
  { key: [0x10a58869,0xd74be5a3,0x74cf867c,0xfb473859],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6d251e69,0x44b051e0,0x4eaa6fb4,0xdbf78465] },
  { key: [0xcaea65cd,0xbb75e916,0x9ecd22eb,0xe6e54675],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6e292011,0x90152df4,0xee058139,0xdef610bb] },
  { key: [0xa2e2fa9b,0xaf7d2082,0x2ca9f054,0x2f764a41],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc3b44b95,0xd9d2f256,0x70eee9a0,0xde099fa3] },
  { key: [0xb6364ac4,0xe1de1e28,0x5eaf144a,0x2415f7a0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5d9b0557,0x8fc944b3,0xcf1ccf0e,0x746cd581] },
  { key: [0x64cf9c7a,0xbc50b888,0xaf65f49d,0x521944b2],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf7efc89d,0x5dba5781,0x04016ce5,0xad659c05] },
  { key: [0x47d6742e,0xefcc0465,0xdc96355e,0x851b64d9],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0306194f,0x666d1836,0x24aa230a,0x8b264ae7] },
  { key: [0x3eb39790,0x678c56be,0xe34bbcde,0xccf6cdb5],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x858075d5,0x36d79cce,0xe571f7d7,0x204b1f67] },
  { key: [0x64110a92,0x4f0743d5,0x00ccadae,0x72c13427],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x35870c6a,0x57e9e923,0x14bcb808,0x7cde72ce] },
  { key: [0x18d81265,0x16f8a12a,0xb1a36d9f,0x04d68e51],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6c68e9be,0x5ec41e22,0xc825b7c7,0xaffb4363] },
  { key: [0xf5303579,0x68578480,0xb398a3c2,0x51cd1093],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf5df3999,0x0fc688f1,0xb07224cc,0x03e86cea] },
  { key: [0xda84367f,0x325d42d6,0x01b43269,0x64802e8e],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbba071bc,0xb470f8f6,0x586e5d3a,0xdd18bc66] },
  { key: [0xe37b1c6a,0xa2846f6f,0xdb413f23,0x8b089f23],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x43c9f7e6,0x2f5d288b,0xb27aa40e,0xf8fe1ea8] },
  { key: [0x6c002b68,0x2483e0ca,0xbcc731c2,0x53be5674],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3580d19c,0xff44f101,0x4a7c966a,0x69059de5] },
  { key: [0x143ae8ed,0x6555aba9,0x6110ab58,0x893a8ae1],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x806da864,0xdd29d48d,0xeafbe764,0xf8202aef] },
  { key: [0xb69418a8,0x5332240d,0xc8249235,0x3956ae0c],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa303d940,0xded8f0ba,0xff6f7541,0x4cac5243] },
  { key: [0x71b5c08a,0x1993e136,0x2e4d0ce9,0xb22b78d5],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc2dabd11,0x7f8a3eca,0xbfbb11d1,0x2194d9d0] },
  { key: [0xe234cdca,0x2606b81f,0x29408d5f,0x6da21206],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfff60a47,0x40086b3b,0x9c56195b,0x98d91a7b] },
  { key: [0x13237c49,0x074a3da0,0x78dc1d82,0x8bb78c6f],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8146a08e,0x2357f0ca,0xa30ca8c9,0x4d1a0544] },
  { key: [0x3071a2a4,0x8fe6cbd0,0x4f1a1290,0x98e308f8],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4b98e06d,0x356deb07,0xebb824e5,0x713f7be3] },
  { key: [0x90f42ec0,0xf68385f2,0xffc5dfc0,0x3a654dce],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7a20a53d,0x460fc9ce,0x0423a7a0,0x764c6cf2] },
  { key: [0xfebd9a24,0xd8b65c1c,0x787d50a4,0xed3619a9],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf4a70d8a,0xf877f9b0,0x2b4c40df,0x57d45b17] },
  { key: [0x80000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0edd33d3,0xc621e546,0x455bd8ba,0x1418bec8] },
  { key: [0xc0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4bc3f883,0x450c113c,0x64ca42e1,0x112a9e87] },
  { key: [0xe0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x72a1da77,0x0f5d7ac4,0xc9ef94d8,0x22affd97] },
  { key: [0xf0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x970014d6,0x34e2b765,0x0777e8e8,0x4d03ccd8] },
  { key: [0xf8000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf17e79ae,0xd0db7e27,0x9e955b5f,0x493875a7] },
  { key: [0xfc000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9ed5a751,0x36a940d0,0x963da379,0xdb4af26a] },
  { key: [0xfe000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc4295f83,0x465c7755,0xe8fa364b,0xac6a7ea5] },
  { key: [0xff000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb1d75825,0x6b28fd85,0x0ad49442,0x08cf1155] },
  { key: [0xff800000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x42ffb34c,0x743de4d8,0x8ca38011,0xc990890b] },
  { key: [0xffc00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9958f0ec,0xea8b2172,0xc0c1995f,0x9182c0f3] },
  { key: [0xffe00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x956d7798,0xfac20f82,0xa8823f98,0x4d06f7f5] },
  { key: [0xfff00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa01bf44f,0x2d16be92,0x8ca44aaf,0x7b9b106b] },
  { key: [0xfff80000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb5f1a33e,0x50d40d10,0x3764c76b,0xd4c6b6f8] },
  { key: [0xfffc0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2637050c,0x9fc0d481,0x7e2d69de,0x878aee8d] },
  { key: [0xfffe0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x113ecbe4,0xa453269a,0x0dd26069,0x467fb5b5] },
  { key: [0xffff0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x97d0754f,0xe68f11b9,0xe375d070,0xa608c884] },
  { key: [0xffff8000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc6a0b3e9,0x98d05068,0xa5399778,0x405200b4] },
  { key: [0xffffc000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdf556a33,0x438db87b,0xc41b1752,0xc55e5e49] },
  { key: [0xffffe000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x90fb128d,0x3a1af6e5,0x48521bb9,0x62bf1f05] },
  { key: [0xfffff000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x26298e9c,0x1db517c2,0x15fadfb7,0xd2a8d691] },
  { key: [0xfffff800,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa6cb761d,0x61f8292d,0x0df393a2,0x79ad0380] },
  { key: [0xfffffc00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x12acd89b,0x13cd5f87,0x26e34d44,0xfd486108] },
  { key: [0xfffffe00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x95b1703f,0xc57ba09f,0xe0c3580f,0xebdd7ed4] },
  { key: [0xffffff00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xde11722d,0x893e9f91,0x21c381be,0xcc1da59a] },
  { key: [0xffffff80,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6d114ccb,0x27bf3910,0x12e8974c,0x546d9bf2] },
  { key: [0xffffffc0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5ce37e17,0xeb4646ec,0xfac29b9c,0xc38d9340] },
  { key: [0xffffffe0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x18c1b6e2,0x15712205,0x6d0243d8,0xa165cddb] },
  { key: [0xfffffff0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x99693e6a,0x59d1366c,0x74d82356,0x2d7e1431] },
  { key: [0xfffffff8,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6c7c64dc,0x84a8bba7,0x58ed17eb,0x025a57e3] },
  { key: [0xfffffffc,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe17bc79f,0x30eaab2f,0xac2cbbe3,0x458d687a] },
  { key: [0xfffffffe,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1114bc20,0x28009b92,0x3f0b0191,0x5ce5e7c4] },
  { key: [0xffffffff,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9c28524a,0x16a1e1c1,0x452971ca,0xa8d13476] },
  { key: [0xffffffff,0x80000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xed62e163,0x63638360,0xfdd6ad62,0x112794f0] },
  { key: [0xffffffff,0xc0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5a8688f0,0xb2a2c162,0x24c16165,0x8ffd4044] },
  { key: [0xffffffff,0xe0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x23f71084,0x2b9bb9c3,0x2f26648c,0x786807ca] },
  { key: [0xffffffff,0xf0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x44a98bf1,0x1e163f63,0x2c47ec6a,0x49683a89] },
  { key: [0xffffffff,0xf8000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0f18aff9,0x4274696d,0x9b61848b,0xd50ac5e5] },
  { key: [0xffffffff,0xfc000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x82408571,0xc3e24245,0x40207f83,0x3b6dda69] },
  { key: [0xffffffff,0xfe000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x303ff996,0x947f0c7d,0x1f43c8f3,0x027b9b75] },
  { key: [0xffffffff,0xff000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7df4daf4,0xad29a361,0x5a9b6ece,0x5c99518a] },
  { key: [0xffffffff,0xff800000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc72954a4,0x8d0774db,0x0b4971c5,0x26260415] },
  { key: [0xffffffff,0xffc00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1df9b761,0x12dc6531,0xe07d2cfd,0xa04411f0] },
  { key: [0xffffffff,0xffe00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8e4d8e69,0x9119e1fc,0x87545a64,0x7fb1d34f] },
  { key: [0xffffffff,0xfff00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe6c4807a,0xe11f36f0,0x91c57d9f,0xb68548d1] },
  { key: [0xffffffff,0xfff80000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8ebf73aa,0xd49c8200,0x7f77a5c1,0xccec6ab4] },
  { key: [0xffffffff,0xfffc0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4fb288cc,0x20400490,0x01d2c758,0x5ad123fc] },
  { key: [0xffffffff,0xfffe0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x04497110,0xefb9dceb,0x13e2b13f,0xb4465564] },
  { key: [0xffffffff,0xffff0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x75550e6c,0xb5a88e49,0x634c9ab6,0x9eda0430] },
  { key: [0xffffffff,0xffff8000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb6768473,0xce9843ea,0x66a81405,0xdd50b345] },
  { key: [0xffffffff,0xffffc000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcb2f4303,0x83f9084e,0x03a65357,0x1e065de6] },
  { key: [0xffffffff,0xffffe000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xff4e66c0,0x7bae3e79,0xfb7d2108,0x47a3b0ba] },
  { key: [0xffffffff,0xfffff000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7b907851,0x25505fad,0x59b13c18,0x6dd66ce3] },
  { key: [0xffffffff,0xfffff800,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8b527a6a,0xebdaec9e,0xaef8eda2,0xcb7783e5] },
  { key: [0xffffffff,0xfffffc00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x43fdaf53,0xebbc9880,0xc228617d,0x6a9b548b] },
  { key: [0xffffffff,0xfffffe00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x53786104,0xb9744b98,0xf052c46f,0x1c850d0b] },
  { key: [0xffffffff,0xffffff00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb5ab3013,0xdd1e61df,0x06cbaf34,0xca2aee78] },
  { key: [0xffffffff,0xffffff80,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7470469b,0xe9723030,0xfdcc73a8,0xcd4fbb10] },
  { key: [0xffffffff,0xffffffc0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa35a63f5,0x343ebe9e,0xf8167bcb,0x48ad122e] },
  { key: [0xffffffff,0xffffffe0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfd8687f0,0x757a210e,0x9fdf1812,0x04c30863] },
  { key: [0xffffffff,0xfffffff0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7a181e84,0xbd5457d2,0x6a88fbae,0x96018fb0] },
  { key: [0xffffffff,0xfffffff8,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x653317b9,0x362b6f9b,0x9e1a580e,0x68d494b5] },
  { key: [0xffffffff,0xfffffffc,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x995c9dc0,0xb689f03c,0x45867b5f,0xaa5c18d1] },
  { key: [0xffffffff,0xfffffffe,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x77a4d96d,0x56dda398,0xb9aabecf,0xc75729fd] },
  { key: [0xffffffff,0xffffffff,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x84be19e0,0x53635f09,0xf2665e7b,0xae85b42d] },
  { key: [0xffffffff,0xffffffff,0x80000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x32cd6528,0x42926aea,0x4aa6137b,0xb2be2b5e] },
  { key: [0xffffffff,0xffffffff,0xc0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x493d4a4f,0x38ebb337,0xd10aa84e,0x9171a554] },
  { key: [0xffffffff,0xffffffff,0xe0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd9bff7ff,0x454b0ec5,0xa4a2a695,0x66e2cb84] },
  { key: [0xffffffff,0xffffffff,0xf0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3535d565,0xace3f31e,0xb249ba2c,0xc6765d7a] },
  { key: [0xffffffff,0xffffffff,0xf8000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf60e91fc,0x3269eecf,0x3231c6e9,0x945697c6] },
  { key: [0xffffffff,0xffffffff,0xfc000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xab69cfad,0xf51f8e60,0x4d9cc371,0x82f6635a] },
  { key: [0xffffffff,0xffffffff,0xfe000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7866373f,0x24a0b6ed,0x56e0d96f,0xcdafb877] },
  { key: [0xffffffff,0xffffffff,0xff000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1ea448c2,0xaac954f5,0xd812e9d7,0x8494446a] },
  { key: [0xffffffff,0xffffffff,0xff800000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xacc5599d,0xd8ac0223,0x9a0fef4a,0x36dd1668] },
  { key: [0xffffffff,0xffffffff,0xffc00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd8764468,0xbb103828,0xcf7e1473,0xce895073] },
  { key: [0xffffffff,0xffffffff,0xffe00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1b0d0289,0x3683b9f1,0x80458e4a,0xa6b73982] },
  { key: [0xffffffff,0xffffffff,0xfff00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x96d9b017,0xd302df41,0x0a937dcd,0xb8bb6e43] },
  { key: [0xffffffff,0xffffffff,0xfff80000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xef1623cc,0x44313cff,0x440b1594,0xa7e21cc6] },
  { key: [0xffffffff,0xffffffff,0xfffc0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x284ca2fa,0x35807b8b,0x0ae4d19e,0x11d7dbd7] },
  { key: [0xffffffff,0xffffffff,0xfffe0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf2e97687,0x5755f940,0x1d54f36e,0x2a23a594] },
  { key: [0xffffffff,0xffffffff,0xffff0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xec198a18,0xe10e5324,0x03b7e208,0x87c8dd80] },
  { key: [0xffffffff,0xffffffff,0xffff8000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x545d50eb,0xd919e4a6,0x949d96ad,0x47e46a80] },
  { key: [0xffffffff,0xffffffff,0xffffc000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdbdfb527,0x060e0a71,0x009c7bb0,0xc68f1d44] },
  { key: [0xffffffff,0xffffffff,0xffffe000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9cfa1322,0xea33da21,0x73a024f2,0xff0d896d] },
  { key: [0xffffffff,0xffffffff,0xfffff000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8785b1a7,0x5b0f3bd9,0x58dcd0e2,0x9318c521] },
  { key: [0xffffffff,0xffffffff,0xfffff800,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x38f67b9e,0x98e4a97b,0x6df030a9,0xfcdd0104] },
  { key: [0xffffffff,0xffffffff,0xfffffc00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x192afffb,0x2c880e82,0xb05926d0,0xfc6c448b] },
  { key: [0xffffffff,0xffffffff,0xfffffe00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6a7980ce,0x7b105cf5,0x30952d74,0xdaaf798c] },
  { key: [0xffffffff,0xffffffff,0xffffff00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xea3695e1,0x351b9d68,0x58bd958c,0xf513ef6c] },
  { key: [0xffffffff,0xffffffff,0xffffff80,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6da0490b,0xa0ba0343,0xb935681d,0x2cce5ba1] },
  { key: [0xffffffff,0xffffffff,0xffffffc0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf0ea23af,0x08534011,0xc60009ab,0x29ada2f1] },
  { key: [0xffffffff,0xffffffff,0xffffffe0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xff13806c,0xf19cc387,0x21554d7c,0x0fcdcd4b] },
  { key: [0xffffffff,0xffffffff,0xfffffff0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6838af1f,0x4f69bae9,0xd85dd188,0xdcdf0688] },
  { key: [0xffffffff,0xffffffff,0xfffffff8,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x36cf44c9,0x2d550bfb,0x1ed28ef5,0x83ddf5d7] },
  { key: [0xffffffff,0xffffffff,0xfffffffc,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd06e3195,0xb5376f10,0x9d5c4ec6,0xc5d62ced] },
  { key: [0xffffffff,0xffffffff,0xfffffffe,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc440de01,0x4d3d6107,0x07279b13,0x242a5c36] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf0c5c6ff,0xa5e0bd3a,0x94c88f6b,0x6f7c16b9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0x80000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3e40c390,0x1cd7effc,0x22bffc35,0xdee0b4d9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xc0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb63305c7,0x2bedfab9,0x7382c406,0xd0c49bc6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xe0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x36bbaab2,0x2a6bd492,0x5a99a2b4,0x08d2dbae] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xf0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x307c5b8f,0xcd0533ab,0x98bc51e2,0x7a6ce461] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xf8000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x829c04ff,0x4c07513c,0x0b3ef05c,0x03e337b5] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfc000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf17af0e8,0x95dda5eb,0x98efc680,0x66e84c54] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfe000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x277167f3,0x812afff1,0xffacb4a9,0x34379fc3] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xff000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2cb1dc3a,0x9c72972e,0x425ae2ef,0x3eb597cd] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xff800000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x36aeaa3a,0x213e968d,0x4b5b679d,0x3a2c97fe] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffc00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9241daca,0x4fdd034a,0x82372db5,0x0e1a0f3f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffe00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc14574d9,0xcd00cf2b,0x5a7f77e5,0x3cd57885] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfff00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x793de392,0x36570aba,0x83ab9b73,0x7cb521c9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfff80000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x16591c0f,0x27d60e29,0xb85a96c3,0x3861a7ef] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffc0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x44fb5c4d,0x4f5cb79b,0xe5c174a3,0xb1c97348] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffe0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x674d2b61,0x633d162b,0xe59dde04,0x222f4740] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffff0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb4750ff2,0x63a65e1f,0x9e924ccf,0xd98f3e37] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffff8000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x62d0662d,0x6eaedded,0xebae7f7e,0xa3a4f6b6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffc000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x70c46bb3,0x0692be65,0x7f7eaa93,0xebad9897] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffe000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x323994cf,0xb9da285a,0x5d9642e1,0x759b224a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffff000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1dbf5787,0x7b7b1738,0x5c85d0b5,0x4851e371] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffff800],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdfa5c097,0xcdc1532a,0xc071d57b,0x1d28d1bd] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffc00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3a0c53fa,0x37311fc1,0x0bd2a998,0x1f513174] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffe00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xba4f970c,0x0a25c418,0x14bdae2e,0x506be3b4] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffff00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2dce3acb,0x727cd13c,0xcd76d425,0xea56e4f6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffff80],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5160474d,0x504b9b3e,0xefb68d35,0xf245f4b3] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffc0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x41a8a947,0x766635de,0xc37553d9,0xa6c0cbb7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffe0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x25d6cfe6,0x881f2bf4,0x97dd14cd,0x4ddf445b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffff0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x41c78c13,0x5ed9e98c,0x09664064,0x7265da1e] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffff8],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5a4d404d,0x8917e353,0xe92a2107,0x2c3b2305] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffffc],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x02bc9684,0x6b3fdc71,0x643f384c,0xd3cc3eaf] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffffe],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9ba4a914,0x3f4e5d40,0x48521c4f,0x8877d88e] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa1f6258c,0x877d5fcd,0x89644845,0x38bfc92c] },
  { key: [0x80000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0edd33d3,0xc621e546,0x455bd8ba,0x1418bec8] },
  { key: [0xc0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4bc3f883,0x450c113c,0x64ca42e1,0x112a9e87] },
  { key: [0xe0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x72a1da77,0x0f5d7ac4,0xc9ef94d8,0x22affd97] },
  { key: [0xf0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x970014d6,0x34e2b765,0x0777e8e8,0x4d03ccd8] },
  { key: [0xf8000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf17e79ae,0xd0db7e27,0x9e955b5f,0x493875a7] },
  { key: [0xfc000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9ed5a751,0x36a940d0,0x963da379,0xdb4af26a] },
  { key: [0xfe000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc4295f83,0x465c7755,0xe8fa364b,0xac6a7ea5] },
  { key: [0xff000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb1d75825,0x6b28fd85,0x0ad49442,0x08cf1155] },
  { key: [0xff800000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x42ffb34c,0x743de4d8,0x8ca38011,0xc990890b] },
  { key: [0xffc00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9958f0ec,0xea8b2172,0xc0c1995f,0x9182c0f3] },
  { key: [0xffe00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x956d7798,0xfac20f82,0xa8823f98,0x4d06f7f5] },
  { key: [0xfff00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa01bf44f,0x2d16be92,0x8ca44aaf,0x7b9b106b] },
  { key: [0xfff80000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb5f1a33e,0x50d40d10,0x3764c76b,0xd4c6b6f8] },
  { key: [0xfffc0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2637050c,0x9fc0d481,0x7e2d69de,0x878aee8d] },
  { key: [0xfffe0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x113ecbe4,0xa453269a,0x0dd26069,0x467fb5b5] },
  { key: [0xffff0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x97d0754f,0xe68f11b9,0xe375d070,0xa608c884] },
  { key: [0xffff8000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc6a0b3e9,0x98d05068,0xa5399778,0x405200b4] },
  { key: [0xffffc000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdf556a33,0x438db87b,0xc41b1752,0xc55e5e49] },
  { key: [0xffffe000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x90fb128d,0x3a1af6e5,0x48521bb9,0x62bf1f05] },
  { key: [0xfffff000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x26298e9c,0x1db517c2,0x15fadfb7,0xd2a8d691] },
  { key: [0xfffff800,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa6cb761d,0x61f8292d,0x0df393a2,0x79ad0380] },
  { key: [0xfffffc00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x12acd89b,0x13cd5f87,0x26e34d44,0xfd486108] },
  { key: [0xfffffe00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x95b1703f,0xc57ba09f,0xe0c3580f,0xebdd7ed4] },
  { key: [0xffffff00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xde11722d,0x893e9f91,0x21c381be,0xcc1da59a] },
  { key: [0xffffff80,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6d114ccb,0x27bf3910,0x12e8974c,0x546d9bf2] },
  { key: [0xffffffc0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5ce37e17,0xeb4646ec,0xfac29b9c,0xc38d9340] },
  { key: [0xffffffe0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x18c1b6e2,0x15712205,0x6d0243d8,0xa165cddb] },
  { key: [0xfffffff0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x99693e6a,0x59d1366c,0x74d82356,0x2d7e1431] },
  { key: [0xfffffff8,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6c7c64dc,0x84a8bba7,0x58ed17eb,0x025a57e3] },
  { key: [0xfffffffc,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe17bc79f,0x30eaab2f,0xac2cbbe3,0x458d687a] },
  { key: [0xfffffffe,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1114bc20,0x28009b92,0x3f0b0191,0x5ce5e7c4] },
  { key: [0xffffffff,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9c28524a,0x16a1e1c1,0x452971ca,0xa8d13476] },
  { key: [0xffffffff,0x80000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xed62e163,0x63638360,0xfdd6ad62,0x112794f0] },
  { key: [0xffffffff,0xc0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5a8688f0,0xb2a2c162,0x24c16165,0x8ffd4044] },
  { key: [0xffffffff,0xe0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x23f71084,0x2b9bb9c3,0x2f26648c,0x786807ca] },
  { key: [0xffffffff,0xf0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x44a98bf1,0x1e163f63,0x2c47ec6a,0x49683a89] },
  { key: [0xffffffff,0xf8000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0f18aff9,0x4274696d,0x9b61848b,0xd50ac5e5] },
  { key: [0xffffffff,0xfc000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x82408571,0xc3e24245,0x40207f83,0x3b6dda69] },
  { key: [0xffffffff,0xfe000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x303ff996,0x947f0c7d,0x1f43c8f3,0x027b9b75] },
  { key: [0xffffffff,0xff000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7df4daf4,0xad29a361,0x5a9b6ece,0x5c99518a] },
  { key: [0xffffffff,0xff800000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc72954a4,0x8d0774db,0x0b4971c5,0x26260415] },
  { key: [0xffffffff,0xffc00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1df9b761,0x12dc6531,0xe07d2cfd,0xa04411f0] },
  { key: [0xffffffff,0xffe00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8e4d8e69,0x9119e1fc,0x87545a64,0x7fb1d34f] },
  { key: [0xffffffff,0xfff00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe6c4807a,0xe11f36f0,0x91c57d9f,0xb68548d1] },
  { key: [0xffffffff,0xfff80000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8ebf73aa,0xd49c8200,0x7f77a5c1,0xccec6ab4] },
  { key: [0xffffffff,0xfffc0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4fb288cc,0x20400490,0x01d2c758,0x5ad123fc] },
  { key: [0xffffffff,0xfffe0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x04497110,0xefb9dceb,0x13e2b13f,0xb4465564] },
  { key: [0xffffffff,0xffff0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x75550e6c,0xb5a88e49,0x634c9ab6,0x9eda0430] },
  { key: [0xffffffff,0xffff8000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb6768473,0xce9843ea,0x66a81405,0xdd50b345] },
  { key: [0xffffffff,0xffffc000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcb2f4303,0x83f9084e,0x03a65357,0x1e065de6] },
  { key: [0xffffffff,0xffffe000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xff4e66c0,0x7bae3e79,0xfb7d2108,0x47a3b0ba] },
  { key: [0xffffffff,0xfffff000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7b907851,0x25505fad,0x59b13c18,0x6dd66ce3] },
  { key: [0xffffffff,0xfffff800,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8b527a6a,0xebdaec9e,0xaef8eda2,0xcb7783e5] },
  { key: [0xffffffff,0xfffffc00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x43fdaf53,0xebbc9880,0xc228617d,0x6a9b548b] },
  { key: [0xffffffff,0xfffffe00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x53786104,0xb9744b98,0xf052c46f,0x1c850d0b] },
  { key: [0xffffffff,0xffffff00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb5ab3013,0xdd1e61df,0x06cbaf34,0xca2aee78] },
  { key: [0xffffffff,0xffffff80,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7470469b,0xe9723030,0xfdcc73a8,0xcd4fbb10] },
  { key: [0xffffffff,0xffffffc0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa35a63f5,0x343ebe9e,0xf8167bcb,0x48ad122e] },
  { key: [0xffffffff,0xffffffe0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfd8687f0,0x757a210e,0x9fdf1812,0x04c30863] },
  { key: [0xffffffff,0xfffffff0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7a181e84,0xbd5457d2,0x6a88fbae,0x96018fb0] },
  { key: [0xffffffff,0xfffffff8,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x653317b9,0x362b6f9b,0x9e1a580e,0x68d494b5] },
  { key: [0xffffffff,0xfffffffc,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x995c9dc0,0xb689f03c,0x45867b5f,0xaa5c18d1] },
  { key: [0xffffffff,0xfffffffe,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x77a4d96d,0x56dda398,0xb9aabecf,0xc75729fd] },
  { key: [0xffffffff,0xffffffff,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x84be19e0,0x53635f09,0xf2665e7b,0xae85b42d] },
  { key: [0xffffffff,0xffffffff,0x80000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x32cd6528,0x42926aea,0x4aa6137b,0xb2be2b5e] },
  { key: [0xffffffff,0xffffffff,0xc0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x493d4a4f,0x38ebb337,0xd10aa84e,0x9171a554] },
  { key: [0xffffffff,0xffffffff,0xe0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd9bff7ff,0x454b0ec5,0xa4a2a695,0x66e2cb84] },
  { key: [0xffffffff,0xffffffff,0xf0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3535d565,0xace3f31e,0xb249ba2c,0xc6765d7a] },
  { key: [0xffffffff,0xffffffff,0xf8000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf60e91fc,0x3269eecf,0x3231c6e9,0x945697c6] },
  { key: [0xffffffff,0xffffffff,0xfc000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xab69cfad,0xf51f8e60,0x4d9cc371,0x82f6635a] },
  { key: [0xffffffff,0xffffffff,0xfe000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7866373f,0x24a0b6ed,0x56e0d96f,0xcdafb877] },
  { key: [0xffffffff,0xffffffff,0xff000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1ea448c2,0xaac954f5,0xd812e9d7,0x8494446a] },
  { key: [0xffffffff,0xffffffff,0xff800000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xacc5599d,0xd8ac0223,0x9a0fef4a,0x36dd1668] },
  { key: [0xffffffff,0xffffffff,0xffc00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd8764468,0xbb103828,0xcf7e1473,0xce895073] },
  { key: [0xffffffff,0xffffffff,0xffe00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1b0d0289,0x3683b9f1,0x80458e4a,0xa6b73982] },
  { key: [0xffffffff,0xffffffff,0xfff00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x96d9b017,0xd302df41,0x0a937dcd,0xb8bb6e43] },
  { key: [0xffffffff,0xffffffff,0xfff80000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xef1623cc,0x44313cff,0x440b1594,0xa7e21cc6] },
  { key: [0xffffffff,0xffffffff,0xfffc0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x284ca2fa,0x35807b8b,0x0ae4d19e,0x11d7dbd7] },
  { key: [0xffffffff,0xffffffff,0xfffe0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf2e97687,0x5755f940,0x1d54f36e,0x2a23a594] },
  { key: [0xffffffff,0xffffffff,0xffff0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xec198a18,0xe10e5324,0x03b7e208,0x87c8dd80] },
  { key: [0xffffffff,0xffffffff,0xffff8000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x545d50eb,0xd919e4a6,0x949d96ad,0x47e46a80] },
  { key: [0xffffffff,0xffffffff,0xffffc000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdbdfb527,0x060e0a71,0x009c7bb0,0xc68f1d44] },
  { key: [0xffffffff,0xffffffff,0xffffe000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9cfa1322,0xea33da21,0x73a024f2,0xff0d896d] },
  { key: [0xffffffff,0xffffffff,0xfffff000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8785b1a7,0x5b0f3bd9,0x58dcd0e2,0x9318c521] },
  { key: [0xffffffff,0xffffffff,0xfffff800,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x38f67b9e,0x98e4a97b,0x6df030a9,0xfcdd0104] },
  { key: [0xffffffff,0xffffffff,0xfffffc00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x192afffb,0x2c880e82,0xb05926d0,0xfc6c448b] },
  { key: [0xffffffff,0xffffffff,0xfffffe00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6a7980ce,0x7b105cf5,0x30952d74,0xdaaf798c] },
  { key: [0xffffffff,0xffffffff,0xffffff00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xea3695e1,0x351b9d68,0x58bd958c,0xf513ef6c] },
  { key: [0xffffffff,0xffffffff,0xffffff80,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6da0490b,0xa0ba0343,0xb935681d,0x2cce5ba1] },
  { key: [0xffffffff,0xffffffff,0xffffffc0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf0ea23af,0x08534011,0xc60009ab,0x29ada2f1] },
  { key: [0xffffffff,0xffffffff,0xffffffe0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xff13806c,0xf19cc387,0x21554d7c,0x0fcdcd4b] },
  { key: [0xffffffff,0xffffffff,0xfffffff0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6838af1f,0x4f69bae9,0xd85dd188,0xdcdf0688] },
  { key: [0xffffffff,0xffffffff,0xfffffff8,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x36cf44c9,0x2d550bfb,0x1ed28ef5,0x83ddf5d7] },
  { key: [0xffffffff,0xffffffff,0xfffffffc,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd06e3195,0xb5376f10,0x9d5c4ec6,0xc5d62ced] },
  { key: [0xffffffff,0xffffffff,0xfffffffe,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc440de01,0x4d3d6107,0x07279b13,0x242a5c36] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf0c5c6ff,0xa5e0bd3a,0x94c88f6b,0x6f7c16b9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0x80000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3e40c390,0x1cd7effc,0x22bffc35,0xdee0b4d9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xc0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb63305c7,0x2bedfab9,0x7382c406,0xd0c49bc6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xe0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x36bbaab2,0x2a6bd492,0x5a99a2b4,0x08d2dbae] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xf0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x307c5b8f,0xcd0533ab,0x98bc51e2,0x7a6ce461] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xf8000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x829c04ff,0x4c07513c,0x0b3ef05c,0x03e337b5] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfc000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf17af0e8,0x95dda5eb,0x98efc680,0x66e84c54] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfe000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x277167f3,0x812afff1,0xffacb4a9,0x34379fc3] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xff000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2cb1dc3a,0x9c72972e,0x425ae2ef,0x3eb597cd] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xff800000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x36aeaa3a,0x213e968d,0x4b5b679d,0x3a2c97fe] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffc00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9241daca,0x4fdd034a,0x82372db5,0x0e1a0f3f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffe00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc14574d9,0xcd00cf2b,0x5a7f77e5,0x3cd57885] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfff00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x793de392,0x36570aba,0x83ab9b73,0x7cb521c9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfff80000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x16591c0f,0x27d60e29,0xb85a96c3,0x3861a7ef] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffc0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x44fb5c4d,0x4f5cb79b,0xe5c174a3,0xb1c97348] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffe0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x674d2b61,0x633d162b,0xe59dde04,0x222f4740] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffff0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb4750ff2,0x63a65e1f,0x9e924ccf,0xd98f3e37] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffff8000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x62d0662d,0x6eaedded,0xebae7f7e,0xa3a4f6b6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffc000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x70c46bb3,0x0692be65,0x7f7eaa93,0xebad9897] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffe000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x323994cf,0xb9da285a,0x5d9642e1,0x759b224a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffff000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1dbf5787,0x7b7b1738,0x5c85d0b5,0x4851e371] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffff800],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdfa5c097,0xcdc1532a,0xc071d57b,0x1d28d1bd] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffc00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3a0c53fa,0x37311fc1,0x0bd2a998,0x1f513174] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffe00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xba4f970c,0x0a25c418,0x14bdae2e,0x506be3b4] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffff00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2dce3acb,0x727cd13c,0xcd76d425,0xea56e4f6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffff80],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5160474d,0x504b9b3e,0xefb68d35,0xf245f4b3] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffc0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x41a8a947,0x766635de,0xc37553d9,0xa6c0cbb7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffe0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x25d6cfe6,0x881f2bf4,0x97dd14cd,0x4ddf445b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffff0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x41c78c13,0x5ed9e98c,0x09664064,0x7265da1e] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffff8],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5a4d404d,0x8917e353,0xe92a2107,0x2c3b2305] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffffc],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x02bc9684,0x6b3fdc71,0x643f384c,0xd3cc3eaf] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffffe],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9ba4a914,0x3f4e5d40,0x48521c4f,0x8877d88e] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa1f6258c,0x877d5fcd,0x89644845,0x38bfc92c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x80000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3ad78e72,0x6c1ec02b,0x7ebfe92b,0x23d9ec34] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xc0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xaae5939c,0x8efdf2f0,0x4e60b9fe,0x7117b2c2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xe0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf031d4d7,0x4f5dcbf3,0x9daaf8ca,0x3af6e527] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xf0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x96d9fd5c,0xc4f07441,0x727df0f3,0x3e401a36] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xf8000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x30ccdb04,0x4646d7e1,0xf3ccea3d,0xca08b8c0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfc000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x16ae4ce5,0x042a67ee,0x8e177b7c,0x587ecc82] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfe000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb6da0bb1,0x1a23855d,0x9c5cb1b4,0xc6412e0a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xff000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdb4f1aa5,0x30967d67,0x32ce4715,0xeb0ee24b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xff800000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa8173825,0x2621dd18,0x0a34f345,0x5b4baa2f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffc00000,0x00000000,0x00000000,0x00000000],
    ct:  [0x77e2b508,0xdb7fd892,0x34caf793,0x9ee5621a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffe00000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb8499c25,0x1f8442ee,0x13f0933b,0x688fcd19] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfff00000,0x00000000,0x00000000,0x00000000],
    ct:  [0x965135f8,0xa81f25c9,0xd630b175,0x02f68e53] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfff80000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8b87145a,0x01ad1c6c,0xede995ea,0x3670454f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffc0000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8eae3b10,0xa0c8ca6d,0x1d3b0fa6,0x1e56b0b2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffe0000,0x00000000,0x00000000,0x00000000],
    ct:  [0x64b4d629,0x810fda6b,0xafdf08f3,0xb0d8d2c5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffff0000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd7e5dbd3,0x324595f8,0xfdc7d7c5,0x71da6c2a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffff8000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf3f72375,0x264e167f,0xca9de2c1,0x527d9606] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffc000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8ee79dd4,0xf401ff9b,0x7ea945d8,0x6666c13b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffe000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdd35cea2,0x799940b4,0x0db3f819,0xcb94c08b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffff000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6941cb6b,0x3e08c2b7,0xafa581eb,0xdd607b87] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffff800,0x00000000,0x00000000,0x00000000],
    ct:  [0x2c20f439,0xf6bb097b,0x29b8bd6d,0x99aad799] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffc00,0x00000000,0x00000000,0x00000000],
    ct:  [0x625d01f0,0x58e565f7,0x7ae86378,0xbd2c49b3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffe00,0x00000000,0x00000000,0x00000000],
    ct:  [0xc0b5fd98,0x190ef45f,0xbb430143,0x8d095950] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffff00,0x00000000,0x00000000,0x00000000],
    ct:  [0x13001ff5,0xd99806ef,0xd25da34f,0x56be854b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffff80,0x00000000,0x00000000,0x00000000],
    ct:  [0x3b594c60,0xf5c8277a,0x5113677f,0x94208d82] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffc0,0x00000000,0x00000000,0x00000000],
    ct:  [0xe9c0fc18,0x18e4aa46,0xbd2e39d6,0x38f89e05] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffe0,0x00000000,0x00000000,0x00000000],
    ct:  [0xf8023ee9,0xc3fdc45a,0x019b4e98,0x5c7e1a54] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffff0,0x00000000,0x00000000,0x00000000],
    ct:  [0x35f40182,0xab4662f3,0x023baec1,0xee796b57] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffff8,0x00000000,0x00000000,0x00000000],
    ct:  [0x3aebbad7,0x303649b4,0x194a6945,0xc6cc3694] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffffc,0x00000000,0x00000000,0x00000000],
    ct:  [0xa2124bea,0x53ec2834,0x279bed7f,0x7eb0f938] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffffe,0x00000000,0x00000000,0x00000000],
    ct:  [0xb9fb4399,0xfa4facc7,0x309e14ec,0x98360b0a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0x00000000,0x00000000,0x00000000],
    ct:  [0xc2627743,0x7420c5d6,0x34f715ae,0xa81a9132] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0x80000000,0x00000000,0x00000000],
    ct:  [0x171a0e1b,0x2dd424f0,0xe089af2c,0x4c10f32f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xc0000000,0x00000000,0x00000000],
    ct:  [0x7cadbe40,0x2d1b208f,0xe735edce,0x00aee7ce] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xe0000000,0x00000000,0x00000000],
    ct:  [0x43b02ff9,0x29a1485a,0xf6f5c6d6,0x558baa0f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xf0000000,0x00000000,0x00000000],
    ct:  [0x092faacc,0x9bf43508,0xbf8fa861,0x3ca75dea] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xf8000000,0x00000000,0x00000000],
    ct:  [0xcb2bf828,0x0f3f9742,0xc7ed513f,0xe802629c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfc000000,0x00000000,0x00000000],
    ct:  [0x215a41ee,0x442fa992,0xa6e32398,0x6ded3f68] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfe000000,0x00000000,0x00000000],
    ct:  [0xf21e99cf,0x4f0f77ce,0xa836e11a,0x2fe75fb1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xff000000,0x00000000,0x00000000],
    ct:  [0x95e3a0ca,0x9079e646,0x331df8b4,0xe70d2cd6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xff800000,0x00000000,0x00000000],
    ct:  [0x4afe7f12,0x0ce7613f,0x74fc12a0,0x1a828073] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffc00000,0x00000000,0x00000000],
    ct:  [0x827f000e,0x75e2c8b9,0xd479beed,0x913fe678] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffe00000,0x00000000,0x00000000],
    ct:  [0x35830c8e,0x7aaefe2d,0x30310ef3,0x81cbf691] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfff00000,0x00000000,0x00000000],
    ct:  [0x191aa0f2,0xc8570144,0xf38657ea,0x4085ebe5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfff80000,0x00000000,0x00000000],
    ct:  [0x85062c2c,0x909f15d9,0x269b6c18,0xce99c4f0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffc0000,0x00000000,0x00000000],
    ct:  [0x678034dc,0x9e41b5a5,0x60ed239e,0xeab1bc78] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffe0000,0x00000000,0x00000000],
    ct:  [0xc2f93a4c,0xe5ab6d5d,0x56f1b93c,0xf19911c1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffff0000,0x00000000,0x00000000],
    ct:  [0x1c3112bc,0xb0c1dcc7,0x49d79974,0x3691bf82] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffff8000,0x00000000,0x00000000],
    ct:  [0x00c55bd7,0x5c7f9c88,0x1989d3ec,0x1911c0d4] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffc000,0x00000000,0x00000000],
    ct:  [0xea2e6b5e,0xf182b7df,0xf3629abd,0x6a12045f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffe000,0x00000000,0x00000000],
    ct:  [0x22322327,0xe01780b1,0x7397f240,0x87f8cc6f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffff000,0x00000000,0x00000000],
    ct:  [0xc9cacb5c,0xd11692c3,0x73b24117,0x68149ee7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffff800,0x00000000,0x00000000],
    ct:  [0xa18e3dbb,0xca577860,0xdab6b80d,0xa3139256] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffc00,0x00000000,0x00000000],
    ct:  [0x79b61c37,0xbf328ecc,0xa8d74326,0x5a3d425c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffe00,0x00000000,0x00000000],
    ct:  [0xd2d99c6b,0xcc1f06fd,0xa8e27e8a,0xe3f1ccc7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffff00,0x00000000,0x00000000],
    ct:  [0x1bfd4b91,0xc701fd6b,0x61b7f997,0x829d663b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffff80,0x00000000,0x00000000],
    ct:  [0x11005d52,0xf25f16bd,0xc9545a87,0x6a63490a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffc0,0x00000000,0x00000000],
    ct:  [0x3a4d354f,0x02bb5a5e,0x47d39666,0x867f246a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffe0,0x00000000,0x00000000],
    ct:  [0xd451b8d6,0xe1e1a0eb,0xb155fbbf,0x6e7b7dc3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffff0,0x00000000,0x00000000],
    ct:  [0x6898d4f4,0x2fa7ba6a,0x10ac05e8,0x7b9f2080] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffff8,0x00000000,0x00000000],
    ct:  [0xb611295e,0x739ca7d9,0xb50f8e4c,0x0e754a3f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffffc,0x00000000,0x00000000],
    ct:  [0x7d33fc7d,0x8abe3ca1,0x936759f8,0xf5deaf20] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffffe,0x00000000,0x00000000],
    ct:  [0x3b5e0f56,0x6dc96c29,0x8f0c1263,0x7539b25c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0x00000000,0x00000000],
    ct:  [0xf807c3e7,0x985fe0f5,0xa50e2cdb,0x25c5109e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0x80000000,0x00000000],
    ct:  [0x41f992a8,0x56fb278b,0x389a62f5,0xd274d7e9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xc0000000,0x00000000],
    ct:  [0x10d3ed7a,0x6fe15ab4,0xd91acbc7,0xd0767ab1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xe0000000,0x00000000],
    ct:  [0x21feecd4,0x5b2e6759,0x73ac33bf,0x0c5424fc] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xf0000000,0x00000000],
    ct:  [0x1480cb39,0x55ba62d0,0x9eea668f,0x7c708817] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xf8000000,0x00000000],
    ct:  [0x66404033,0xd6b72b60,0x9354d549,0x6e7eb511] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfc000000,0x00000000],
    ct:  [0x1c317a22,0x0a7d700d,0xa2b1e075,0xb00266e1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfe000000,0x00000000],
    ct:  [0xab3b8954,0x2233f127,0x1bf8fd0c,0x0f403545] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xff000000,0x00000000],
    ct:  [0xd93eae96,0x6fac46dc,0xa927d6b1,0x14fa3f9e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xff800000,0x00000000],
    ct:  [0x1bdec521,0x316503d9,0xd5ee65df,0x3ea94ddf] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffc00000,0x00000000],
    ct:  [0xeef45643,0x1dea8b4a,0xcf83bdae,0x3717f75f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffe00000,0x00000000],
    ct:  [0x06f2519a,0x2fafaa59,0x6bfef5cf,0xa15c21b9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfff00000,0x00000000],
    ct:  [0x251a7eac,0x7e2fe809,0xe4aa8d0d,0x7012531a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfff80000,0x00000000],
    ct:  [0x3bffc16e,0x4c49b268,0xa20f8d96,0xa60b4058] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffc0000,0x00000000],
    ct:  [0xe886f928,0x1999c5bb,0x3b3e8862,0xe2f7c988] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffe0000,0x00000000],
    ct:  [0x563bf90d,0x61beef39,0xf48dd625,0xfcef1361] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffff0000,0x00000000],
    ct:  [0x4d37c850,0x644563c6,0x9fd0acd9,0xa049325b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffff8000,0x00000000],
    ct:  [0xb87c921b,0x91829ef3,0xb13ca541,0xee1130a6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffc000,0x00000000],
    ct:  [0x2e65eb6b,0x6ea383e1,0x09accce8,0x326b0393] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffe000,0x00000000],
    ct:  [0x9ca547f7,0x439edc3e,0x255c0f4d,0x49aa8990] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffff000,0x00000000],
    ct:  [0xa5e65261,0x4c9300f3,0x7816b1f9,0xfd0c87f9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffff800,0x00000000],
    ct:  [0x14954f0b,0x4697776f,0x44494fe4,0x58d814ed] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffc00,0x00000000],
    ct:  [0x7c8d9ab6,0xc2761723,0xfe42f8bb,0x506cbcf7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffe00,0x00000000],
    ct:  [0xdb7e1932,0x679fdd99,0x742aab04,0xaa0d5a80] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffff00,0x00000000],
    ct:  [0x4c6a1c83,0xe568cd10,0xf27c2d73,0xded19c28] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffff80,0x00000000],
    ct:  [0x90ecbe61,0x77e674c9,0x8de41241,0x3f7ac915] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffc0,0x00000000],
    ct:  [0x90684a2a,0xc55fe1ec,0x2b8ebd56,0x22520b73] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffe0,0x00000000],
    ct:  [0x7472f9a7,0x988607ca,0x79707795,0x991035e6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffff0,0x00000000],
    ct:  [0x56aff089,0x878bf335,0x2f8df172,0xa3ae47d8] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffff8,0x00000000],
    ct:  [0x65c0526c,0xbe40161b,0x8019a2a3,0x171abd23] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffffc,0x00000000],
    ct:  [0x377be0be,0x33b4e3e3,0x10b4aabd,0xa173f84f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffffe,0x00000000],
    ct:  [0x9402e9aa,0x6f69de65,0x04da8d20,0xc4fcaa2f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0x00000000],
    ct:  [0x123c1f4a,0xf313ad8c,0x2ce648b2,0xe71fb6e1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0x80000000],
    ct:  [0x1ffc626d,0x30203dcd,0xb0019fb8,0x0f726cf4] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xc0000000],
    ct:  [0x76da1fbe,0x3a50728c,0x50fd2e62,0x1b5ad885] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xe0000000],
    ct:  [0x082eb8be,0x35f442fb,0x52668e16,0xa591d1d6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xf0000000],
    ct:  [0xe656f9ec,0xf5fe27ec,0x3e4a73d0,0x0c282fb3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xf8000000],
    ct:  [0x2ca8209d,0x63274cd9,0xa29bb74b,0xcd77683a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfc000000],
    ct:  [0x79bf5dce,0x14bb7dd7,0x3a8e3611,0xde7ce026] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfe000000],
    ct:  [0x3c849939,0xa5d29399,0xf344c4a0,0xeca8a576] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xff000000],
    ct:  [0xed3c0a94,0xd59bece9,0x8835da7a,0xa4f07ca2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xff800000],
    ct:  [0x63919ed4,0xce101964,0x38b6ad09,0xd99cd795] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffc00000],
    ct:  [0x7678f3a8,0x33f19fea,0x95f3c602,0x9e2bc610] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffe00000],
    ct:  [0x3aa42683,0x1067d36b,0x92be7c5f,0x81c13c56] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfff00000],
    ct:  [0x9272e2d2,0xcdd11050,0x998c8450,0x77a30ea0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfff80000],
    ct:  [0x088c4b53,0xf5ec0ff8,0x14c19ada,0xe7f6246c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffc0000],
    ct:  [0x4010a5e4,0x01fdf0a0,0x354ddbcc,0x0d012b17] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffe0000],
    ct:  [0xa87a3857,0x36c0a618,0x9bd6589b,0xd8445a93] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffff0000],
    ct:  [0x545f2b83,0xd9616dcc,0xf60fa983,0x0e9cd287] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffff8000],
    ct:  [0x4b706f7f,0x92406352,0x394037a6,0xd4f4688d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffc000],
    ct:  [0xb7972b39,0x41c44b90,0xafa7b264,0xbfba7387] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffe000],
    ct:  [0x6f45732c,0xf1088154,0x6f0fd238,0x96d2bb60] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffff000],
    ct:  [0x2e3579ca,0x15af27f6,0x4b3c955a,0x5bfc30ba] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffff800],
    ct:  [0x34a2c5a9,0x1ae2aec9,0x9b7d1b5f,0xa6780447] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffc00],
    ct:  [0xa4d6616b,0xd04f8733,0x5b0e5335,0x1227a9ee] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffe00],
    ct:  [0x7f692b03,0x945867d1,0x6179a8ce,0xfc83ea3f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffff00],
    ct:  [0x3bd141ee,0x84a0e641,0x4a26e7a4,0xf281f8a2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffff80],
    ct:  [0xd1788f57,0x2d98b2b1,0x6ec5d5f3,0x922b99bc] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffc0],
    ct:  [0x0833ff6f,0x61d98a57,0xb288e8c3,0x586b85a6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffe0],
    ct:  [0x85682617,0x97de176b,0xf0b43bec,0xc6285afb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffff0],
    ct:  [0xf9b0fda0,0xc4a898f5,0xb9e6f661,0xc4ce4d07] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffff8],
    ct:  [0x8ade8959,0x13685c67,0xc5269f8a,0xae42983e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffffc],
    ct:  [0x39bde67d,0x5c8ed8a8,0xb1c37eb8,0xfa9f5ac0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffffe],
    ct:  [0x5c005e72,0xc1418c44,0xf569f2ea,0x33ba54f3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffff],
    ct:  [0x3f5b8cc9,0xea855a0a,0xfa7347d2,0x3e8d664e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x80000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3ad78e72,0x6c1ec02b,0x7ebfe92b,0x23d9ec34] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xc0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xaae5939c,0x8efdf2f0,0x4e60b9fe,0x7117b2c2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xe0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf031d4d7,0x4f5dcbf3,0x9daaf8ca,0x3af6e527] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xf0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x96d9fd5c,0xc4f07441,0x727df0f3,0x3e401a36] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xf8000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x30ccdb04,0x4646d7e1,0xf3ccea3d,0xca08b8c0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfc000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x16ae4ce5,0x042a67ee,0x8e177b7c,0x587ecc82] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfe000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb6da0bb1,0x1a23855d,0x9c5cb1b4,0xc6412e0a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xff000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdb4f1aa5,0x30967d67,0x32ce4715,0xeb0ee24b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xff800000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa8173825,0x2621dd18,0x0a34f345,0x5b4baa2f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffc00000,0x00000000,0x00000000,0x00000000],
    ct:  [0x77e2b508,0xdb7fd892,0x34caf793,0x9ee5621a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffe00000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb8499c25,0x1f8442ee,0x13f0933b,0x688fcd19] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfff00000,0x00000000,0x00000000,0x00000000],
    ct:  [0x965135f8,0xa81f25c9,0xd630b175,0x02f68e53] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfff80000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8b87145a,0x01ad1c6c,0xede995ea,0x3670454f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffc0000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8eae3b10,0xa0c8ca6d,0x1d3b0fa6,0x1e56b0b2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffe0000,0x00000000,0x00000000,0x00000000],
    ct:  [0x64b4d629,0x810fda6b,0xafdf08f3,0xb0d8d2c5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffff0000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd7e5dbd3,0x324595f8,0xfdc7d7c5,0x71da6c2a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffff8000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf3f72375,0x264e167f,0xca9de2c1,0x527d9606] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffc000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8ee79dd4,0xf401ff9b,0x7ea945d8,0x6666c13b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffe000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdd35cea2,0x799940b4,0x0db3f819,0xcb94c08b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffff000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6941cb6b,0x3e08c2b7,0xafa581eb,0xdd607b87] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffff800,0x00000000,0x00000000,0x00000000],
    ct:  [0x2c20f439,0xf6bb097b,0x29b8bd6d,0x99aad799] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffc00,0x00000000,0x00000000,0x00000000],
    ct:  [0x625d01f0,0x58e565f7,0x7ae86378,0xbd2c49b3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffe00,0x00000000,0x00000000,0x00000000],
    ct:  [0xc0b5fd98,0x190ef45f,0xbb430143,0x8d095950] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffff00,0x00000000,0x00000000,0x00000000],
    ct:  [0x13001ff5,0xd99806ef,0xd25da34f,0x56be854b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffff80,0x00000000,0x00000000,0x00000000],
    ct:  [0x3b594c60,0xf5c8277a,0x5113677f,0x94208d82] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffc0,0x00000000,0x00000000,0x00000000],
    ct:  [0xe9c0fc18,0x18e4aa46,0xbd2e39d6,0x38f89e05] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffe0,0x00000000,0x00000000,0x00000000],
    ct:  [0xf8023ee9,0xc3fdc45a,0x019b4e98,0x5c7e1a54] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffff0,0x00000000,0x00000000,0x00000000],
    ct:  [0x35f40182,0xab4662f3,0x023baec1,0xee796b57] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffff8,0x00000000,0x00000000,0x00000000],
    ct:  [0x3aebbad7,0x303649b4,0x194a6945,0xc6cc3694] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffffc,0x00000000,0x00000000,0x00000000],
    ct:  [0xa2124bea,0x53ec2834,0x279bed7f,0x7eb0f938] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffffe,0x00000000,0x00000000,0x00000000],
    ct:  [0xb9fb4399,0xfa4facc7,0x309e14ec,0x98360b0a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0x00000000,0x00000000,0x00000000],
    ct:  [0xc2627743,0x7420c5d6,0x34f715ae,0xa81a9132] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0x80000000,0x00000000,0x00000000],
    ct:  [0x171a0e1b,0x2dd424f0,0xe089af2c,0x4c10f32f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xc0000000,0x00000000,0x00000000],
    ct:  [0x7cadbe40,0x2d1b208f,0xe735edce,0x00aee7ce] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xe0000000,0x00000000,0x00000000],
    ct:  [0x43b02ff9,0x29a1485a,0xf6f5c6d6,0x558baa0f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xf0000000,0x00000000,0x00000000],
    ct:  [0x092faacc,0x9bf43508,0xbf8fa861,0x3ca75dea] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xf8000000,0x00000000,0x00000000],
    ct:  [0xcb2bf828,0x0f3f9742,0xc7ed513f,0xe802629c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfc000000,0x00000000,0x00000000],
    ct:  [0x215a41ee,0x442fa992,0xa6e32398,0x6ded3f68] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfe000000,0x00000000,0x00000000],
    ct:  [0xf21e99cf,0x4f0f77ce,0xa836e11a,0x2fe75fb1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xff000000,0x00000000,0x00000000],
    ct:  [0x95e3a0ca,0x9079e646,0x331df8b4,0xe70d2cd6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xff800000,0x00000000,0x00000000],
    ct:  [0x4afe7f12,0x0ce7613f,0x74fc12a0,0x1a828073] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffc00000,0x00000000,0x00000000],
    ct:  [0x827f000e,0x75e2c8b9,0xd479beed,0x913fe678] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffe00000,0x00000000,0x00000000],
    ct:  [0x35830c8e,0x7aaefe2d,0x30310ef3,0x81cbf691] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfff00000,0x00000000,0x00000000],
    ct:  [0x191aa0f2,0xc8570144,0xf38657ea,0x4085ebe5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfff80000,0x00000000,0x00000000],
    ct:  [0x85062c2c,0x909f15d9,0x269b6c18,0xce99c4f0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffc0000,0x00000000,0x00000000],
    ct:  [0x678034dc,0x9e41b5a5,0x60ed239e,0xeab1bc78] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffe0000,0x00000000,0x00000000],
    ct:  [0xc2f93a4c,0xe5ab6d5d,0x56f1b93c,0xf19911c1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffff0000,0x00000000,0x00000000],
    ct:  [0x1c3112bc,0xb0c1dcc7,0x49d79974,0x3691bf82] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffff8000,0x00000000,0x00000000],
    ct:  [0x00c55bd7,0x5c7f9c88,0x1989d3ec,0x1911c0d4] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffc000,0x00000000,0x00000000],
    ct:  [0xea2e6b5e,0xf182b7df,0xf3629abd,0x6a12045f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffe000,0x00000000,0x00000000],
    ct:  [0x22322327,0xe01780b1,0x7397f240,0x87f8cc6f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffff000,0x00000000,0x00000000],
    ct:  [0xc9cacb5c,0xd11692c3,0x73b24117,0x68149ee7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffff800,0x00000000,0x00000000],
    ct:  [0xa18e3dbb,0xca577860,0xdab6b80d,0xa3139256] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffc00,0x00000000,0x00000000],
    ct:  [0x79b61c37,0xbf328ecc,0xa8d74326,0x5a3d425c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffe00,0x00000000,0x00000000],
    ct:  [0xd2d99c6b,0xcc1f06fd,0xa8e27e8a,0xe3f1ccc7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffff00,0x00000000,0x00000000],
    ct:  [0x1bfd4b91,0xc701fd6b,0x61b7f997,0x829d663b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffff80,0x00000000,0x00000000],
    ct:  [0x11005d52,0xf25f16bd,0xc9545a87,0x6a63490a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffc0,0x00000000,0x00000000],
    ct:  [0x3a4d354f,0x02bb5a5e,0x47d39666,0x867f246a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffe0,0x00000000,0x00000000],
    ct:  [0xd451b8d6,0xe1e1a0eb,0xb155fbbf,0x6e7b7dc3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffff0,0x00000000,0x00000000],
    ct:  [0x6898d4f4,0x2fa7ba6a,0x10ac05e8,0x7b9f2080] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffff8,0x00000000,0x00000000],
    ct:  [0xb611295e,0x739ca7d9,0xb50f8e4c,0x0e754a3f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffffc,0x00000000,0x00000000],
    ct:  [0x7d33fc7d,0x8abe3ca1,0x936759f8,0xf5deaf20] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffffe,0x00000000,0x00000000],
    ct:  [0x3b5e0f56,0x6dc96c29,0x8f0c1263,0x7539b25c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0x00000000,0x00000000],
    ct:  [0xf807c3e7,0x985fe0f5,0xa50e2cdb,0x25c5109e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0x80000000,0x00000000],
    ct:  [0x41f992a8,0x56fb278b,0x389a62f5,0xd274d7e9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xc0000000,0x00000000],
    ct:  [0x10d3ed7a,0x6fe15ab4,0xd91acbc7,0xd0767ab1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xe0000000,0x00000000],
    ct:  [0x21feecd4,0x5b2e6759,0x73ac33bf,0x0c5424fc] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xf0000000,0x00000000],
    ct:  [0x1480cb39,0x55ba62d0,0x9eea668f,0x7c708817] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xf8000000,0x00000000],
    ct:  [0x66404033,0xd6b72b60,0x9354d549,0x6e7eb511] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfc000000,0x00000000],
    ct:  [0x1c317a22,0x0a7d700d,0xa2b1e075,0xb00266e1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfe000000,0x00000000],
    ct:  [0xab3b8954,0x2233f127,0x1bf8fd0c,0x0f403545] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xff000000,0x00000000],
    ct:  [0xd93eae96,0x6fac46dc,0xa927d6b1,0x14fa3f9e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xff800000,0x00000000],
    ct:  [0x1bdec521,0x316503d9,0xd5ee65df,0x3ea94ddf] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffc00000,0x00000000],
    ct:  [0xeef45643,0x1dea8b4a,0xcf83bdae,0x3717f75f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffe00000,0x00000000],
    ct:  [0x06f2519a,0x2fafaa59,0x6bfef5cf,0xa15c21b9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfff00000,0x00000000],
    ct:  [0x251a7eac,0x7e2fe809,0xe4aa8d0d,0x7012531a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfff80000,0x00000000],
    ct:  [0x3bffc16e,0x4c49b268,0xa20f8d96,0xa60b4058] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffc0000,0x00000000],
    ct:  [0xe886f928,0x1999c5bb,0x3b3e8862,0xe2f7c988] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffe0000,0x00000000],
    ct:  [0x563bf90d,0x61beef39,0xf48dd625,0xfcef1361] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffff0000,0x00000000],
    ct:  [0x4d37c850,0x644563c6,0x9fd0acd9,0xa049325b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffff8000,0x00000000],
    ct:  [0xb87c921b,0x91829ef3,0xb13ca541,0xee1130a6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffc000,0x00000000],
    ct:  [0x2e65eb6b,0x6ea383e1,0x09accce8,0x326b0393] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffe000,0x00000000],
    ct:  [0x9ca547f7,0x439edc3e,0x255c0f4d,0x49aa8990] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffff000,0x00000000],
    ct:  [0xa5e65261,0x4c9300f3,0x7816b1f9,0xfd0c87f9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffff800,0x00000000],
    ct:  [0x14954f0b,0x4697776f,0x44494fe4,0x58d814ed] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffc00,0x00000000],
    ct:  [0x7c8d9ab6,0xc2761723,0xfe42f8bb,0x506cbcf7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffe00,0x00000000],
    ct:  [0xdb7e1932,0x679fdd99,0x742aab04,0xaa0d5a80] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffff00,0x00000000],
    ct:  [0x4c6a1c83,0xe568cd10,0xf27c2d73,0xded19c28] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffff80,0x00000000],
    ct:  [0x90ecbe61,0x77e674c9,0x8de41241,0x3f7ac915] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffc0,0x00000000],
    ct:  [0x90684a2a,0xc55fe1ec,0x2b8ebd56,0x22520b73] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffe0,0x00000000],
    ct:  [0x7472f9a7,0x988607ca,0x79707795,0x991035e6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffff0,0x00000000],
    ct:  [0x56aff089,0x878bf335,0x2f8df172,0xa3ae47d8] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffff8,0x00000000],
    ct:  [0x65c0526c,0xbe40161b,0x8019a2a3,0x171abd23] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffffc,0x00000000],
    ct:  [0x377be0be,0x33b4e3e3,0x10b4aabd,0xa173f84f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffffe,0x00000000],
    ct:  [0x9402e9aa,0x6f69de65,0x04da8d20,0xc4fcaa2f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0x00000000],
    ct:  [0x123c1f4a,0xf313ad8c,0x2ce648b2,0xe71fb6e1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0x80000000],
    ct:  [0x1ffc626d,0x30203dcd,0xb0019fb8,0x0f726cf4] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xc0000000],
    ct:  [0x76da1fbe,0x3a50728c,0x50fd2e62,0x1b5ad885] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xe0000000],
    ct:  [0x082eb8be,0x35f442fb,0x52668e16,0xa591d1d6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xf0000000],
    ct:  [0xe656f9ec,0xf5fe27ec,0x3e4a73d0,0x0c282fb3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xf8000000],
    ct:  [0x2ca8209d,0x63274cd9,0xa29bb74b,0xcd77683a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfc000000],
    ct:  [0x79bf5dce,0x14bb7dd7,0x3a8e3611,0xde7ce026] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfe000000],
    ct:  [0x3c849939,0xa5d29399,0xf344c4a0,0xeca8a576] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xff000000],
    ct:  [0xed3c0a94,0xd59bece9,0x8835da7a,0xa4f07ca2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xff800000],
    ct:  [0x63919ed4,0xce101964,0x38b6ad09,0xd99cd795] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffc00000],
    ct:  [0x7678f3a8,0x33f19fea,0x95f3c602,0x9e2bc610] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffe00000],
    ct:  [0x3aa42683,0x1067d36b,0x92be7c5f,0x81c13c56] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfff00000],
    ct:  [0x9272e2d2,0xcdd11050,0x998c8450,0x77a30ea0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfff80000],
    ct:  [0x088c4b53,0xf5ec0ff8,0x14c19ada,0xe7f6246c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffc0000],
    ct:  [0x4010a5e4,0x01fdf0a0,0x354ddbcc,0x0d012b17] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffe0000],
    ct:  [0xa87a3857,0x36c0a618,0x9bd6589b,0xd8445a93] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffff0000],
    ct:  [0x545f2b83,0xd9616dcc,0xf60fa983,0x0e9cd287] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffff8000],
    ct:  [0x4b706f7f,0x92406352,0x394037a6,0xd4f4688d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffc000],
    ct:  [0xb7972b39,0x41c44b90,0xafa7b264,0xbfba7387] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffe000],
    ct:  [0x6f45732c,0xf1088154,0x6f0fd238,0x96d2bb60] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffff000],
    ct:  [0x2e3579ca,0x15af27f6,0x4b3c955a,0x5bfc30ba] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffff800],
    ct:  [0x34a2c5a9,0x1ae2aec9,0x9b7d1b5f,0xa6780447] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffc00],
    ct:  [0xa4d6616b,0xd04f8733,0x5b0e5335,0x1227a9ee] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffe00],
    ct:  [0x7f692b03,0x945867d1,0x6179a8ce,0xfc83ea3f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffff00],
    ct:  [0x3bd141ee,0x84a0e641,0x4a26e7a4,0xf281f8a2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffff80],
    ct:  [0xd1788f57,0x2d98b2b1,0x6ec5d5f3,0x922b99bc] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffc0],
    ct:  [0x0833ff6f,0x61d98a57,0xb288e8c3,0x586b85a6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffe0],
    ct:  [0x85682617,0x97de176b,0xf0b43bec,0xc6285afb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffff0],
    ct:  [0xf9b0fda0,0xc4a898f5,0xb9e6f661,0xc4ce4d07] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffff8],
    ct:  [0x8ade8959,0x13685c67,0xc5269f8a,0xae42983e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffffc],
    ct:  [0x39bde67d,0x5c8ed8a8,0xb1c37eb8,0xfa9f5ac0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffffe],
    ct:  [0x5c005e72,0xc1418c44,0xf569f2ea,0x33ba54f3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffff],
    ct:  [0x3f5b8cc9,0xea855a0a,0xfa7347d2,0x3e8d664e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x80000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6cd02513,0xe8d4dc98,0x6b4afe08,0x7a60bd0c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xc0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2ce1f8b7,0xe30627c1,0xc4519ead,0xa44bc436] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xe0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9946b5f8,0x7af446f5,0x796c1fee,0x63a2da24] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xf0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2a560364,0xce529efc,0x21788779,0x568d5555] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xf8000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x35c14718,0x37af4461,0x53bce55d,0x5ba72a0a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfc000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xce60bc52,0x386234f1,0x58f84341,0xe534cd9e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfe000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8c7c27ff,0x32bcf8dc,0x2dc57c90,0xc2903961] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xff000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x32bb6a7e,0xc84499e1,0x66f93600,0x3d55a5bb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xff800000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa5c772e5,0xc62631ef,0x660ee1d5,0x877f6d1b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffc00000,0x00000000,0x00000000,0x00000000],
    ct:  [0x030d7e5b,0x64f380a7,0xe4ea5387,0xb5cd7f49] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffe00000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0dc9a261,0x0037009b,0x698f11bb,0x7e86c83e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfff00000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0046612c,0x766d1840,0xc226364f,0x1fa7ed72] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfff80000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4880c7e0,0x8f27befe,0x78590743,0xc05e698b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffc0000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2520ce82,0x9a26577f,0x0f4822c4,0xecc87401] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffe0000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8765e8ac,0xc1697583,0x19cb46dc,0x7bcf3dca] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffff0000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe98f4ba4,0xf073df4b,0xaa116d01,0x1dc24a28] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffff8000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf378f68c,0x5dbf59e2,0x11b3a659,0xa7317d94] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffc000,0x00000000,0x00000000,0x00000000],
    ct:  [0x283d3b06,0x9d8eb9fb,0x432d74b9,0x6ca762b4] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffe000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa7e1842e,0x8a87861c,0x221a5008,0x83245c51] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffff000,0x00000000,0x00000000,0x00000000],
    ct:  [0x77aa2704,0x71881be0,0x70fb52c7,0x067ce732] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffff800,0x00000000,0x00000000,0x00000000],
    ct:  [0x01b0f476,0xd484f43f,0x1aeb6efa,0x9361a8ac] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffc00,0x00000000,0x00000000,0x00000000],
    ct:  [0x1c3a94f1,0xc052c55c,0x2d8359af,0xf2163b4f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffe00,0x00000000,0x00000000,0x00000000],
    ct:  [0xe8a067b6,0x04d5373d,0x8b0f2e05,0xa03b341b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffff00,0x00000000,0x00000000,0x00000000],
    ct:  [0xa7876ec8,0x7f5a09bf,0xea42c77d,0xa30fd50e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffff80,0x00000000,0x00000000,0x00000000],
    ct:  [0x0cf3e9d3,0xa42be5b8,0x54ca65b1,0x3f35f48d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffc0,0x00000000,0x00000000,0x00000000],
    ct:  [0x6c62f6bb,0xcab7c3e8,0x21c9290f,0x08892dda] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffe0,0x00000000,0x00000000,0x00000000],
    ct:  [0x7f5e05bd,0x20687381,0x96fee79a,0xce7e3aec] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffff0,0x00000000,0x00000000,0x00000000],
    ct:  [0x440e0d73,0x3255cda9,0x2fb46e84,0x2fe58054] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffff8,0x00000000,0x00000000,0x00000000],
    ct:  [0xaa5d5b1c,0x4ea1b7a2,0x2e5583ac,0x2e9ed8a7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffffc,0x00000000,0x00000000,0x00000000],
    ct:  [0x77e537e8,0x9e8491e8,0x662aae3b,0xc809421d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffffe,0x00000000,0x00000000,0x00000000],
    ct:  [0x997dd3e9,0xf1598bfa,0x73f75973,0xf7e93b76] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0x00000000,0x00000000,0x00000000],
    ct:  [0x1b38d4f7,0x452afefc,0xb7fc7212,0x44e4b72e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0x80000000,0x00000000,0x00000000],
    ct:  [0x0be2b182,0x52e774dd,0xa30cdda0,0x2c6906e3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xc0000000,0x00000000,0x00000000],
    ct:  [0xd2695e59,0xc20361d8,0x2652d7d5,0x8b6f11b2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xe0000000,0x00000000,0x00000000],
    ct:  [0x902d88d1,0x3eae5208,0x9abd6143,0xcfe394e9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xf0000000,0x00000000,0x00000000],
    ct:  [0xd49bceb3,0xb823fedd,0x602c3053,0x45734bd2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xf8000000,0x00000000,0x00000000],
    ct:  [0x707b1dbb,0x0ffa40ef,0x7d95def4,0x21233fae] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfc000000,0x00000000,0x00000000],
    ct:  [0x7ca0c1d9,0x3356d9eb,0x8aa95208,0x4d75f913] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfe000000,0x00000000,0x00000000],
    ct:  [0xf2cbf9cb,0x186e270d,0xd7bdb0c2,0x8febc57d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xff000000,0x00000000,0x00000000],
    ct:  [0xc94337c3,0x7c4e790a,0xb45780bd,0x9c3674a0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xff800000,0x00000000,0x00000000],
    ct:  [0x8e3558c1,0x35252fb9,0xc9f367ed,0x609467a1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffc00000,0x00000000,0x00000000],
    ct:  [0x1b72eeae,0xe4899b44,0x3914e5b3,0xa57fba92] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffe00000,0x00000000,0x00000000],
    ct:  [0x011865f9,0x1bc56868,0xd051e52c,0x9efd59b7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfff00000,0x00000000,0x00000000],
    ct:  [0xe4771318,0xad7a63dd,0x680f6e58,0x3b7747ea] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfff80000,0x00000000,0x00000000],
    ct:  [0x61e3d194,0x088dc8d9,0x7e9e6db3,0x7457eac5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffc0000,0x00000000,0x00000000],
    ct:  [0x36ff1ec9,0xccfbc349,0xe5d356d0,0x63693ad6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffe0000,0x00000000,0x00000000],
    ct:  [0x3cc9e9a9,0xbe8cc3f6,0xfb2ea240,0x88e9bb19] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffff0000,0x00000000,0x00000000],
    ct:  [0x1ee5ab00,0x3dc8722e,0x74905d9a,0x8fe3d350] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffff8000,0x00000000,0x00000000],
    ct:  [0x24533931,0x9584b0a4,0x12412869,0xd6c2eada] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffc000,0x00000000,0x00000000],
    ct:  [0x7bd49691,0x8115d14e,0xd5380852,0x716c8814] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffe000,0x00000000,0x00000000],
    ct:  [0x273ab2f2,0xb4a366a5,0x7d582a33,0x9313c8b1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffff000,0x00000000,0x00000000],
    ct:  [0x113365a9,0xffbe3b0c,0xa61e9850,0x7554168b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffff800,0x00000000,0x00000000],
    ct:  [0xafa99c99,0x7ac478a0,0xdea4119c,0x9e45f8b1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffc00,0x00000000,0x00000000],
    ct:  [0x9216309a,0x7842430b,0x83ffb986,0x38011512] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffe00,0x00000000,0x00000000],
    ct:  [0x62abc792,0x28825849,0x2a7cb451,0x45f4b759] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffff00,0x00000000,0x00000000],
    ct:  [0x534923c1,0x69d504d7,0x519c15d3,0x0e756c50] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffff80,0x00000000,0x00000000],
    ct:  [0xfa75e05b,0xcdc7e00c,0x273fa33f,0x6ee441d2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffc0,0x00000000,0x00000000],
    ct:  [0x7d350fa6,0x057080f1,0x086a56b1,0x7ec240db] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffe0,0x00000000,0x00000000],
    ct:  [0xf34e4a63,0x24ea4a5c,0x39a661c8,0xfe5ada8f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffff0,0x00000000,0x00000000],
    ct:  [0x0882a16f,0x44088d42,0x447a29ac,0x090ec17e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffff8,0x00000000,0x00000000],
    ct:  [0x3a3c15bf,0xc11a9537,0xc1306870,0x04e136ee] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffffc,0x00000000,0x00000000],
    ct:  [0x22c0a767,0x8dc6d8cf,0x5c8a6d5a,0x9960767c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffffe,0x00000000,0x00000000],
    ct:  [0xb46b0980,0x9d68b9a4,0x56432a79,0xbdc2e38c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0x00000000,0x00000000],
    ct:  [0x93baaffb,0x35fbe739,0xc17c6ac2,0x2eecf18f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0x80000000,0x00000000],
    ct:  [0xc8aa80a7,0x850675bc,0x007c46df,0x06b49868] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xc0000000,0x00000000],
    ct:  [0x12c6f387,0x7af421a9,0x18a84b77,0x5858021d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xe0000000,0x00000000],
    ct:  [0x33f12328,0x2c5d6339,0x24f7d5ba,0x3f3cab11] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xf0000000,0x00000000],
    ct:  [0xa8f16100,0x2733e93c,0xa4527d22,0xc1a0c5bb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xf8000000,0x00000000],
    ct:  [0xb72f70eb,0xf3e3fda2,0x3f508eec,0x76b42c02] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfc000000,0x00000000],
    ct:  [0x6a9d965e,0x6274143f,0x25afdcfc,0x88ffd77c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfe000000,0x00000000],
    ct:  [0xa0c74fd0,0xb9361764,0xce91c520,0x0b095357] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xff000000,0x00000000],
    ct:  [0x091d1fdc,0x2bd2c346,0xcd5046a8,0xc6209146] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xff800000,0x00000000],
    ct:  [0xe2a37580,0x116cfb71,0x85625449,0x6ab0aca8] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffc00000,0x00000000],
    ct:  [0xe0b3a007,0x85917c7e,0xfc9adba3,0x22813571] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffe00000,0x00000000],
    ct:  [0x733d41f4,0x727b5ef0,0xdf4af4cf,0x3cffa0cb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfff00000,0x00000000],
    ct:  [0xa99ebb03,0x0260826f,0x981ad3e6,0x4490aa4f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfff80000,0x00000000],
    ct:  [0x73f34c7d,0x3eae5e80,0x082c1647,0x524308ee] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffc0000,0x00000000],
    ct:  [0x40ebd5ad,0x082345b7,0xa2097ccd,0x3464da02] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffe0000,0x00000000],
    ct:  [0x7cc4ae9a,0x424b2cec,0x90c97153,0xc2457ec5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffff0000,0x00000000],
    ct:  [0x54d632d0,0x3aba0bd0,0xf91877eb,0xdd4d09cb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffff8000,0x00000000],
    ct:  [0xd3427be7,0xe4d27cd5,0x4f5fe37b,0x03cf0897] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffc000,0x00000000],
    ct:  [0xb2099795,0xe88cc158,0xfd75ea13,0x3d7e7fbe] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffe000,0x00000000],
    ct:  [0xa6cae46f,0xb6fadfe7,0xa2c302a3,0x4242817b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffff000,0x00000000],
    ct:  [0x026a7024,0xd6a902e0,0xb3ffccba,0xa910cc3f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffff800,0x00000000],
    ct:  [0x156f0776,0x7a85a431,0x2321f639,0x68338a01] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffc00,0x00000000],
    ct:  [0x15eec9eb,0xf42b9ca7,0x6897d2cd,0x6c5a12e2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffe00,0x00000000],
    ct:  [0xdb0d3a6f,0xdcc13f91,0x5e2b302c,0xeeb70fd8] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffff00,0x00000000],
    ct:  [0x71dbf37e,0x87a2e34d,0x15b20e8f,0x10e48924] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffff80,0x00000000],
    ct:  [0xc745c451,0xe96ff3c0,0x45e4367c,0x833e3b54] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffc0,0x00000000],
    ct:  [0x340da09c,0x2dd11c3b,0x679d08cc,0xd27dd595] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffe0,0x00000000],
    ct:  [0x8279f7c0,0xc2a03ee6,0x60c6d392,0xdb025d18] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffff0,0x00000000],
    ct:  [0xa4b2c7d8,0xeba531ff,0x47c5041a,0x55fbd1ec] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffff8,0x00000000],
    ct:  [0x74569a2c,0xa5a7bd51,0x31ce8dc7,0xcbfbf72f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffffc,0x00000000],
    ct:  [0x3713da0c,0x0219b634,0x54035613,0xb5a403dd] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffffe,0x00000000],
    ct:  [0x8827551d,0xdcc9df23,0xfa72a3de,0x4e9f0b07] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0x00000000],
    ct:  [0x2e3febfd,0x625bfcd0,0xa2c06eb4,0x60da1732] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0x80000000],
    ct:  [0xee82e6ba,0x488156f7,0x6496311d,0xa6941deb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xc0000000],
    ct:  [0x4770446f,0x01d1f391,0x256e85a1,0xb30d89d3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xe0000000],
    ct:  [0xaf04b68f,0x104f21ef,0x2afb4767,0xcf74143c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xf0000000],
    ct:  [0xcf3579a9,0xba38c8e4,0x3653173e,0x14f3a4c6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xf8000000],
    ct:  [0xb3bba904,0xf4953e09,0xb54800af,0x2f62e7d4] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfc000000],
    ct:  [0xfc424965,0x6e14b29e,0xb9c44829,0xb4c59a46] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfe000000],
    ct:  [0x9b31568f,0xebe81cfc,0x2e65af1c,0x86d1a308] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xff000000],
    ct:  [0x9ca09c25,0xf273a766,0xdb98a480,0xce8dfedc] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xff800000],
    ct:  [0xb9099257,0x86f34c3c,0x92d97188,0x3c9fbedf] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffc00000],
    ct:  [0x82647f13,0x32fe570a,0x9d4d92b2,0xee771d3b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffe00000],
    ct:  [0x3604a7e8,0x0832b3a9,0x9954bca6,0xf5b9f501] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfff00000],
    ct:  [0x884607b1,0x28c5de3a,0xb39a529a,0x1ef51bef] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfff80000],
    ct:  [0x670cfa09,0x3d1dbdb2,0x31704140,0x4102435e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffc0000],
    ct:  [0x7a867195,0xf3ce8769,0xcbd33650,0x2fbb5130] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffe0000],
    ct:  [0x52efcf64,0xc72b2f7c,0xa5b3c836,0xb1078c15] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffff0000],
    ct:  [0x4019250f,0x6eefb2ac,0x5ccbcae0,0x44e75c7e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffff8000],
    ct:  [0x022c4f6f,0x5a017d29,0x27856276,0x67ddef24] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffc000],
    ct:  [0xe9c21078,0xa2eb7e03,0x250f7100,0x0fa9e3ed] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffe000],
    ct:  [0xa13eaeeb,0x9cd391da,0x4e2b0949,0x0b3e7fad] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffff000],
    ct:  [0xc958a171,0xdca1d4ed,0x53e1af1d,0x380803a9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffff800],
    ct:  [0x21442e07,0xa110667f,0x2583eaee,0xee44dc8c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffc00],
    ct:  [0x59bbb353,0xcf1dd867,0xa6e33737,0xaf655e99] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffe00],
    ct:  [0x43cd3b25,0x375d0ce4,0x1087ff9f,0xe2829639] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffff00],
    ct:  [0x6b98b17e,0x80d1118e,0x3516bd76,0x8b285a84] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffff80],
    ct:  [0xae47ed36,0x76ca0c08,0xdeea02d9,0x5b81db58] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffc0],
    ct:  [0x34ec40dc,0x20413795,0xed53628e,0xa748720b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffe0],
    ct:  [0x4dc68163,0xf8e98354,0x73253542,0xc8a65d46] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffff0],
    ct:  [0x2aabb999,0xf4369317,0x5af65c6c,0x612c46fb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffff8],
    ct:  [0xe01f9449,0x9dac3547,0x515c5b1d,0x756f0f58] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffffc],
    ct:  [0x9d12435a,0x46480ce0,0x0ea349f7,0x1799df9a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffffe],
    ct:  [0xcef41d16,0xd266bdfe,0x46938ad7,0x884cc0cf] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffff],
    ct:  [0xb13db4da,0x1f718bc6,0x904797c8,0x2bcf2d32] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x80000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6cd02513,0xe8d4dc98,0x6b4afe08,0x7a60bd0c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xc0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2ce1f8b7,0xe30627c1,0xc4519ead,0xa44bc436] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xe0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9946b5f8,0x7af446f5,0x796c1fee,0x63a2da24] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xf0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2a560364,0xce529efc,0x21788779,0x568d5555] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xf8000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x35c14718,0x37af4461,0x53bce55d,0x5ba72a0a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfc000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xce60bc52,0x386234f1,0x58f84341,0xe534cd9e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfe000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8c7c27ff,0x32bcf8dc,0x2dc57c90,0xc2903961] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xff000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x32bb6a7e,0xc84499e1,0x66f93600,0x3d55a5bb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xff800000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa5c772e5,0xc62631ef,0x660ee1d5,0x877f6d1b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffc00000,0x00000000,0x00000000,0x00000000],
    ct:  [0x030d7e5b,0x64f380a7,0xe4ea5387,0xb5cd7f49] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffe00000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0dc9a261,0x0037009b,0x698f11bb,0x7e86c83e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfff00000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0046612c,0x766d1840,0xc226364f,0x1fa7ed72] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfff80000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4880c7e0,0x8f27befe,0x78590743,0xc05e698b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffc0000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2520ce82,0x9a26577f,0x0f4822c4,0xecc87401] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffe0000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8765e8ac,0xc1697583,0x19cb46dc,0x7bcf3dca] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffff0000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe98f4ba4,0xf073df4b,0xaa116d01,0x1dc24a28] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffff8000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf378f68c,0x5dbf59e2,0x11b3a659,0xa7317d94] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffc000,0x00000000,0x00000000,0x00000000],
    ct:  [0x283d3b06,0x9d8eb9fb,0x432d74b9,0x6ca762b4] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffe000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa7e1842e,0x8a87861c,0x221a5008,0x83245c51] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffff000,0x00000000,0x00000000,0x00000000],
    ct:  [0x77aa2704,0x71881be0,0x70fb52c7,0x067ce732] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffff800,0x00000000,0x00000000,0x00000000],
    ct:  [0x01b0f476,0xd484f43f,0x1aeb6efa,0x9361a8ac] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffc00,0x00000000,0x00000000,0x00000000],
    ct:  [0x1c3a94f1,0xc052c55c,0x2d8359af,0xf2163b4f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffe00,0x00000000,0x00000000,0x00000000],
    ct:  [0xe8a067b6,0x04d5373d,0x8b0f2e05,0xa03b341b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffff00,0x00000000,0x00000000,0x00000000],
    ct:  [0xa7876ec8,0x7f5a09bf,0xea42c77d,0xa30fd50e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffff80,0x00000000,0x00000000,0x00000000],
    ct:  [0x0cf3e9d3,0xa42be5b8,0x54ca65b1,0x3f35f48d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffc0,0x00000000,0x00000000,0x00000000],
    ct:  [0x6c62f6bb,0xcab7c3e8,0x21c9290f,0x08892dda] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffe0,0x00000000,0x00000000,0x00000000],
    ct:  [0x7f5e05bd,0x20687381,0x96fee79a,0xce7e3aec] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffff0,0x00000000,0x00000000,0x00000000],
    ct:  [0x440e0d73,0x3255cda9,0x2fb46e84,0x2fe58054] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffff8,0x00000000,0x00000000,0x00000000],
    ct:  [0xaa5d5b1c,0x4ea1b7a2,0x2e5583ac,0x2e9ed8a7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffffc,0x00000000,0x00000000,0x00000000],
    ct:  [0x77e537e8,0x9e8491e8,0x662aae3b,0xc809421d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffffe,0x00000000,0x00000000,0x00000000],
    ct:  [0x997dd3e9,0xf1598bfa,0x73f75973,0xf7e93b76] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0x00000000,0x00000000,0x00000000],
    ct:  [0x1b38d4f7,0x452afefc,0xb7fc7212,0x44e4b72e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0x80000000,0x00000000,0x00000000],
    ct:  [0x0be2b182,0x52e774dd,0xa30cdda0,0x2c6906e3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xc0000000,0x00000000,0x00000000],
    ct:  [0xd2695e59,0xc20361d8,0x2652d7d5,0x8b6f11b2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xe0000000,0x00000000,0x00000000],
    ct:  [0x902d88d1,0x3eae5208,0x9abd6143,0xcfe394e9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xf0000000,0x00000000,0x00000000],
    ct:  [0xd49bceb3,0xb823fedd,0x602c3053,0x45734bd2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xf8000000,0x00000000,0x00000000],
    ct:  [0x707b1dbb,0x0ffa40ef,0x7d95def4,0x21233fae] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfc000000,0x00000000,0x00000000],
    ct:  [0x7ca0c1d9,0x3356d9eb,0x8aa95208,0x4d75f913] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfe000000,0x00000000,0x00000000],
    ct:  [0xf2cbf9cb,0x186e270d,0xd7bdb0c2,0x8febc57d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xff000000,0x00000000,0x00000000],
    ct:  [0xc94337c3,0x7c4e790a,0xb45780bd,0x9c3674a0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xff800000,0x00000000,0x00000000],
    ct:  [0x8e3558c1,0x35252fb9,0xc9f367ed,0x609467a1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffc00000,0x00000000,0x00000000],
    ct:  [0x1b72eeae,0xe4899b44,0x3914e5b3,0xa57fba92] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffe00000,0x00000000,0x00000000],
    ct:  [0x011865f9,0x1bc56868,0xd051e52c,0x9efd59b7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfff00000,0x00000000,0x00000000],
    ct:  [0xe4771318,0xad7a63dd,0x680f6e58,0x3b7747ea] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfff80000,0x00000000,0x00000000],
    ct:  [0x61e3d194,0x088dc8d9,0x7e9e6db3,0x7457eac5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffc0000,0x00000000,0x00000000],
    ct:  [0x36ff1ec9,0xccfbc349,0xe5d356d0,0x63693ad6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffe0000,0x00000000,0x00000000],
    ct:  [0x3cc9e9a9,0xbe8cc3f6,0xfb2ea240,0x88e9bb19] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffff0000,0x00000000,0x00000000],
    ct:  [0x1ee5ab00,0x3dc8722e,0x74905d9a,0x8fe3d350] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffff8000,0x00000000,0x00000000],
    ct:  [0x24533931,0x9584b0a4,0x12412869,0xd6c2eada] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffc000,0x00000000,0x00000000],
    ct:  [0x7bd49691,0x8115d14e,0xd5380852,0x716c8814] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffe000,0x00000000,0x00000000],
    ct:  [0x273ab2f2,0xb4a366a5,0x7d582a33,0x9313c8b1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffff000,0x00000000,0x00000000],
    ct:  [0x113365a9,0xffbe3b0c,0xa61e9850,0x7554168b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffff800,0x00000000,0x00000000],
    ct:  [0xafa99c99,0x7ac478a0,0xdea4119c,0x9e45f8b1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffc00,0x00000000,0x00000000],
    ct:  [0x9216309a,0x7842430b,0x83ffb986,0x38011512] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffe00,0x00000000,0x00000000],
    ct:  [0x62abc792,0x28825849,0x2a7cb451,0x45f4b759] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffff00,0x00000000,0x00000000],
    ct:  [0x534923c1,0x69d504d7,0x519c15d3,0x0e756c50] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffff80,0x00000000,0x00000000],
    ct:  [0xfa75e05b,0xcdc7e00c,0x273fa33f,0x6ee441d2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffc0,0x00000000,0x00000000],
    ct:  [0x7d350fa6,0x057080f1,0x086a56b1,0x7ec240db] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffe0,0x00000000,0x00000000],
    ct:  [0xf34e4a63,0x24ea4a5c,0x39a661c8,0xfe5ada8f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffff0,0x00000000,0x00000000],
    ct:  [0x0882a16f,0x44088d42,0x447a29ac,0x090ec17e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffff8,0x00000000,0x00000000],
    ct:  [0x3a3c15bf,0xc11a9537,0xc1306870,0x04e136ee] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffffc,0x00000000,0x00000000],
    ct:  [0x22c0a767,0x8dc6d8cf,0x5c8a6d5a,0x9960767c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffffe,0x00000000,0x00000000],
    ct:  [0xb46b0980,0x9d68b9a4,0x56432a79,0xbdc2e38c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0x00000000,0x00000000],
    ct:  [0x93baaffb,0x35fbe739,0xc17c6ac2,0x2eecf18f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0x80000000,0x00000000],
    ct:  [0xc8aa80a7,0x850675bc,0x007c46df,0x06b49868] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xc0000000,0x00000000],
    ct:  [0x12c6f387,0x7af421a9,0x18a84b77,0x5858021d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xe0000000,0x00000000],
    ct:  [0x33f12328,0x2c5d6339,0x24f7d5ba,0x3f3cab11] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xf0000000,0x00000000],
    ct:  [0xa8f16100,0x2733e93c,0xa4527d22,0xc1a0c5bb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xf8000000,0x00000000],
    ct:  [0xb72f70eb,0xf3e3fda2,0x3f508eec,0x76b42c02] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfc000000,0x00000000],
    ct:  [0x6a9d965e,0x6274143f,0x25afdcfc,0x88ffd77c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfe000000,0x00000000],
    ct:  [0xa0c74fd0,0xb9361764,0xce91c520,0x0b095357] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xff000000,0x00000000],
    ct:  [0x091d1fdc,0x2bd2c346,0xcd5046a8,0xc6209146] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xff800000,0x00000000],
    ct:  [0xe2a37580,0x116cfb71,0x85625449,0x6ab0aca8] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffc00000,0x00000000],
    ct:  [0xe0b3a007,0x85917c7e,0xfc9adba3,0x22813571] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffe00000,0x00000000],
    ct:  [0x733d41f4,0x727b5ef0,0xdf4af4cf,0x3cffa0cb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfff00000,0x00000000],
    ct:  [0xa99ebb03,0x0260826f,0x981ad3e6,0x4490aa4f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfff80000,0x00000000],
    ct:  [0x73f34c7d,0x3eae5e80,0x082c1647,0x524308ee] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffc0000,0x00000000],
    ct:  [0x40ebd5ad,0x082345b7,0xa2097ccd,0x3464da02] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffe0000,0x00000000],
    ct:  [0x7cc4ae9a,0x424b2cec,0x90c97153,0xc2457ec5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffff0000,0x00000000],
    ct:  [0x54d632d0,0x3aba0bd0,0xf91877eb,0xdd4d09cb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffff8000,0x00000000],
    ct:  [0xd3427be7,0xe4d27cd5,0x4f5fe37b,0x03cf0897] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffc000,0x00000000],
    ct:  [0xb2099795,0xe88cc158,0xfd75ea13,0x3d7e7fbe] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffe000,0x00000000],
    ct:  [0xa6cae46f,0xb6fadfe7,0xa2c302a3,0x4242817b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffff000,0x00000000],
    ct:  [0x026a7024,0xd6a902e0,0xb3ffccba,0xa910cc3f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffff800,0x00000000],
    ct:  [0x156f0776,0x7a85a431,0x2321f639,0x68338a01] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffc00,0x00000000],
    ct:  [0x15eec9eb,0xf42b9ca7,0x6897d2cd,0x6c5a12e2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffe00,0x00000000],
    ct:  [0xdb0d3a6f,0xdcc13f91,0x5e2b302c,0xeeb70fd8] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffff00,0x00000000],
    ct:  [0x71dbf37e,0x87a2e34d,0x15b20e8f,0x10e48924] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffff80,0x00000000],
    ct:  [0xc745c451,0xe96ff3c0,0x45e4367c,0x833e3b54] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffc0,0x00000000],
    ct:  [0x340da09c,0x2dd11c3b,0x679d08cc,0xd27dd595] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffe0,0x00000000],
    ct:  [0x8279f7c0,0xc2a03ee6,0x60c6d392,0xdb025d18] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffff0,0x00000000],
    ct:  [0xa4b2c7d8,0xeba531ff,0x47c5041a,0x55fbd1ec] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffff8,0x00000000],
    ct:  [0x74569a2c,0xa5a7bd51,0x31ce8dc7,0xcbfbf72f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffffc,0x00000000],
    ct:  [0x3713da0c,0x0219b634,0x54035613,0xb5a403dd] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffffe,0x00000000],
    ct:  [0x8827551d,0xdcc9df23,0xfa72a3de,0x4e9f0b07] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0x00000000],
    ct:  [0x2e3febfd,0x625bfcd0,0xa2c06eb4,0x60da1732] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0x80000000],
    ct:  [0xee82e6ba,0x488156f7,0x6496311d,0xa6941deb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xc0000000],
    ct:  [0x4770446f,0x01d1f391,0x256e85a1,0xb30d89d3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xe0000000],
    ct:  [0xaf04b68f,0x104f21ef,0x2afb4767,0xcf74143c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xf0000000],
    ct:  [0xcf3579a9,0xba38c8e4,0x3653173e,0x14f3a4c6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xf8000000],
    ct:  [0xb3bba904,0xf4953e09,0xb54800af,0x2f62e7d4] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfc000000],
    ct:  [0xfc424965,0x6e14b29e,0xb9c44829,0xb4c59a46] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfe000000],
    ct:  [0x9b31568f,0xebe81cfc,0x2e65af1c,0x86d1a308] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xff000000],
    ct:  [0x9ca09c25,0xf273a766,0xdb98a480,0xce8dfedc] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xff800000],
    ct:  [0xb9099257,0x86f34c3c,0x92d97188,0x3c9fbedf] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffc00000],
    ct:  [0x82647f13,0x32fe570a,0x9d4d92b2,0xee771d3b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffe00000],
    ct:  [0x3604a7e8,0x0832b3a9,0x9954bca6,0xf5b9f501] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfff00000],
    ct:  [0x884607b1,0x28c5de3a,0xb39a529a,0x1ef51bef] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfff80000],
    ct:  [0x670cfa09,0x3d1dbdb2,0x31704140,0x4102435e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffc0000],
    ct:  [0x7a867195,0xf3ce8769,0xcbd33650,0x2fbb5130] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffe0000],
    ct:  [0x52efcf64,0xc72b2f7c,0xa5b3c836,0xb1078c15] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffff0000],
    ct:  [0x4019250f,0x6eefb2ac,0x5ccbcae0,0x44e75c7e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffff8000],
    ct:  [0x022c4f6f,0x5a017d29,0x27856276,0x67ddef24] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffc000],
    ct:  [0xe9c21078,0xa2eb7e03,0x250f7100,0x0fa9e3ed] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffe000],
    ct:  [0xa13eaeeb,0x9cd391da,0x4e2b0949,0x0b3e7fad] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffff000],
    ct:  [0xc958a171,0xdca1d4ed,0x53e1af1d,0x380803a9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffff800],
    ct:  [0x21442e07,0xa110667f,0x2583eaee,0xee44dc8c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffc00],
    ct:  [0x59bbb353,0xcf1dd867,0xa6e33737,0xaf655e99] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffe00],
    ct:  [0x43cd3b25,0x375d0ce4,0x1087ff9f,0xe2829639] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffff00],
    ct:  [0x6b98b17e,0x80d1118e,0x3516bd76,0x8b285a84] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffff80],
    ct:  [0xae47ed36,0x76ca0c08,0xdeea02d9,0x5b81db58] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffc0],
    ct:  [0x34ec40dc,0x20413795,0xed53628e,0xa748720b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffe0],
    ct:  [0x4dc68163,0xf8e98354,0x73253542,0xc8a65d46] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffff0],
    ct:  [0x2aabb999,0xf4369317,0x5af65c6c,0x612c46fb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffff8],
    ct:  [0xe01f9449,0x9dac3547,0x515c5b1d,0x756f0f58] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffffc],
    ct:  [0x9d12435a,0x46480ce0,0x0ea349f7,0x1799df9a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffffe],
    ct:  [0xcef41d16,0xd266bdfe,0x46938ad7,0x884cc0cf] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffff],
    ct:  [0xb13db4da,0x1f718bc6,0x904797c8,0x2bcf2d32] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x26aa49dc,0xfe7629a8,0x901a69a9,0x914e6dfd],
    ct:  [0xd5e08bf9,0xa182e857,0xcf40b3a3,0x6ee248cc] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x941a4773,0x058224e1,0xef66d10e,0x0a6ee782],
    ct:  [0x067cd9d3,0x74920779,0x18415625,0x07fa9626] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x1b077a6a,0xf4b7f982,0x29de786d,0x7516b639],
    ct:  [0x275cfc04,0x13d8ccb7,0x0513c385,0x9b1d0f72] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x9c2d8842,0xe5f48f57,0x648205d3,0x9a239af1],
    ct:  [0xc9b8135f,0xf1b5adc4,0x13dfd053,0xb21bd96d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xbff52510,0x095f518e,0xcca60af4,0x205444bb],
    ct:  [0x4a3650c3,0x371ce2eb,0x35e389a1,0x71427440] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x51719783,0xd3185a53,0x5bd75adc,0x65071ce1],
    ct:  [0x4f354592,0xff7c8847,0xd2d0870c,0xa9481b7c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x26aa49dc,0xfe7629a8,0x901a69a9,0x914e6dfd],
    ct:  [0xd5e08bf9,0xa182e857,0xcf40b3a3,0x6ee248cc] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x941a4773,0x058224e1,0xef66d10e,0x0a6ee782],
    ct:  [0x067cd9d3,0x74920779,0x18415625,0x07fa9626] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x1b077a6a,0xf4b7f982,0x29de786d,0x7516b639],
    ct:  [0x275cfc04,0x13d8ccb7,0x0513c385,0x9b1d0f72] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x9c2d8842,0xe5f48f57,0x648205d3,0x9a239af1],
    ct:  [0xc9b8135f,0xf1b5adc4,0x13dfd053,0xb21bd96d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xbff52510,0x095f518e,0xcca60af4,0x205444bb],
    ct:  [0x4a3650c3,0x371ce2eb,0x35e389a1,0x71427440] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x51719783,0xd3185a53,0x5bd75adc,0x65071ce1],
    ct:  [0x4f354592,0xff7c8847,0xd2d0870c,0xa9481b7c] },
  { key: [0xe9f065d7,0xc1357358,0x7f787535,0x7dfbb16c,0x53489f6a,0x4bd0f7cd],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0956259c,0x9cd5cfd0,0x181cca53,0x380cde06] },
  { key: [0x15d20f6e,0xbc7e649f,0xd95b76b1,0x07e6daba,0x967c8a94,0x84797f29],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8e4e1842,0x4e591a3d,0x5b6f0876,0xf16f8594] },
  { key: [0xa8a282ee,0x31c03fae,0x4f8e9b89,0x30d5473c,0x2ed695a3,0x47e88b7c],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x93f3270c,0xfc877ef1,0x7e106ce9,0x38979cb0] },
  { key: [0xcd62376d,0x5ebb4149,0x17f0c78f,0x05266433,0xdc9192a1,0xec943300],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7f6c25ff,0x41858561,0xbb62f364,0x92e93c29] },
  { key: [0x502a6ab3,0x6984af26,0x8bf423c7,0xf5092052,0x07fc1552,0xaf4a91e5],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8e06556d,0xcbb00b80,0x9a025047,0xcff2a940] },
  { key: [0x25a39dbf,0xd8034f71,0xa81f9ceb,0x55026e40,0x37f8f6aa,0x30ab44ce],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3608c344,0x868e9455,0x5d23a120,0xf8a5502d] },
  { key: [0xe08c1541,0x1774ec4a,0x908b64ea,0xdc6ac419,0x9c7cd453,0xf3aaef53],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x77da2021,0x935b840b,0x7f5dcc39,0x132da9e5] },
  { key: [0x3b375a1f,0xf7e8d444,0x09696e63,0x26ec9dec,0x86138e2a,0xe010b980],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3b7c24f8,0x25e3bf98,0x73c9f14d,0x39a0e6f4] },
  { key: [0x950bb9f2,0x2cc35be6,0xfe79f52c,0x320af93d,0xec5bc9c0,0xc2f9cd53],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x64ebf956,0x86b35350,0x8c90ecd8,0xb6134316] },
  { key: [0x7001c487,0xcc3e572c,0xfc92f4d0,0xe697d982,0xe8856fdc,0xc957da40],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xff558c5d,0x27210b79,0x29b73fc7,0x08eb4cf1] },
  { key: [0xf029ce61,0xd4e5a405,0xb41ead0a,0x883cc6a7,0x37da2cf5,0x0a6c92ae],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa2c3b2a8,0x18075490,0xa7b4c143,0x80f02702] },
  { key: [0x61257134,0xa518a0d5,0x7d9d244d,0x45f6498c,0xbc32f2ba,0xfc522d79],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcfe4d740,0x02696ccf,0x7d87b14a,0x2f9cafc9] },
  { key: [0xb0ab0a6a,0x818baef2,0xd11fa33e,0xac947284,0xfb7d748c,0xfb75e570],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd2eafd86,0xf63b109b,0x91f5dbb3,0xa3fb7e13] },
  { key: [0xee053aa0,0x11c8b428,0xcdcc3636,0x313c54d6,0xa03cac01,0xc71579d6],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9b9fdd1c,0x5975655f,0x539998b3,0x06a324af] },
  { key: [0xd2926527,0xe0aa9f37,0xb45e2ec2,0xade5853e,0xf8075761,0x04c7ace3],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdd619e1c,0xf2044461,0x12e0af2b,0x9afa8f8c] },
  { key: [0x982215f4,0xe173dfa0,0xfcffe5d3,0xda41c481,0x2c7bcc8e,0xd3540f93],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd4f0aae1,0x3c8fe933,0x9fbf9e69,0xed0ad74d] },
  { key: [0x98c6b8e0,0x1e379fbd,0x14e61af6,0xaf891596,0x583565f2,0xa27d59e9],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x19c80ec4,0xa6deb7e5,0xed1033dd,0xa933498f] },
  { key: [0xb3ad5cea,0x1dddc214,0xca969ac3,0x5f37dae1,0xa9a9d152,0x8f89bb35],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3cf5e1d2,0x1a17956d,0x1dffad6a,0x7c41c659] },
  { key: [0x45899367,0xc3132849,0x763073c4,0x35a9288a,0x766c8b9e,0xc2308516],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x69fd12e8,0x505f8ded,0x2fdcb197,0xa121b362] },
  { key: [0xec250e04,0xc3903f60,0x2647b85a,0x401a1ae7,0xca2f02f6,0x7fa4253e],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8aa584e2,0xcc4d1741,0x7a97cb9a,0x28ba29c8] },
  { key: [0xd077a03b,0xd8a38973,0x928ccafe,0x4a9d2f45,0x5130bd0a,0xf5ae46a9],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xabc786fb,0x1edb5045,0x80c4d882,0xef29a0c7] },
  { key: [0xd184c36c,0xf0dddfec,0x39e65419,0x50060222,0x37871a47,0xc33d3198],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2e19fb60,0xa3e1de01,0x66f483c9,0x7824a978] },
  { key: [0x4c6994ff,0xa9dcdc80,0x5b60c2c0,0x095334c4,0x2d95a8fc,0x0ca5b080],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x76567095,0x38dd5fec,0x41e0ce6a,0x0f8e207d] },
  { key: [0xc88f5b00,0xa4ef9a68,0x40e2acaf,0x33f00a3b,0xdc4e2589,0x5303fa72],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa67cf333,0xb314d411,0xd3c0ae6e,0x1cfcd8f5] },
  { key: [0xe9f065d7,0xc1357358,0x7f787535,0x7dfbb16c,0x53489f6a,0x4bd0f7cd],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0956259c,0x9cd5cfd0,0x181cca53,0x380cde06] },
  { key: [0x15d20f6e,0xbc7e649f,0xd95b76b1,0x07e6daba,0x967c8a94,0x84797f29],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8e4e1842,0x4e591a3d,0x5b6f0876,0xf16f8594] },
  { key: [0xa8a282ee,0x31c03fae,0x4f8e9b89,0x30d5473c,0x2ed695a3,0x47e88b7c],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x93f3270c,0xfc877ef1,0x7e106ce9,0x38979cb0] },
  { key: [0xcd62376d,0x5ebb4149,0x17f0c78f,0x05266433,0xdc9192a1,0xec943300],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7f6c25ff,0x41858561,0xbb62f364,0x92e93c29] },
  { key: [0x502a6ab3,0x6984af26,0x8bf423c7,0xf5092052,0x07fc1552,0xaf4a91e5],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8e06556d,0xcbb00b80,0x9a025047,0xcff2a940] },
  { key: [0x25a39dbf,0xd8034f71,0xa81f9ceb,0x55026e40,0x37f8f6aa,0x30ab44ce],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3608c344,0x868e9455,0x5d23a120,0xf8a5502d] },
  { key: [0xe08c1541,0x1774ec4a,0x908b64ea,0xdc6ac419,0x9c7cd453,0xf3aaef53],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x77da2021,0x935b840b,0x7f5dcc39,0x132da9e5] },
  { key: [0x3b375a1f,0xf7e8d444,0x09696e63,0x26ec9dec,0x86138e2a,0xe010b980],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3b7c24f8,0x25e3bf98,0x73c9f14d,0x39a0e6f4] },
  { key: [0x950bb9f2,0x2cc35be6,0xfe79f52c,0x320af93d,0xec5bc9c0,0xc2f9cd53],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x64ebf956,0x86b35350,0x8c90ecd8,0xb6134316] },
  { key: [0x7001c487,0xcc3e572c,0xfc92f4d0,0xe697d982,0xe8856fdc,0xc957da40],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xff558c5d,0x27210b79,0x29b73fc7,0x08eb4cf1] },
  { key: [0xf029ce61,0xd4e5a405,0xb41ead0a,0x883cc6a7,0x37da2cf5,0x0a6c92ae],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa2c3b2a8,0x18075490,0xa7b4c143,0x80f02702] },
  { key: [0x61257134,0xa518a0d5,0x7d9d244d,0x45f6498c,0xbc32f2ba,0xfc522d79],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcfe4d740,0x02696ccf,0x7d87b14a,0x2f9cafc9] },
  { key: [0xb0ab0a6a,0x818baef2,0xd11fa33e,0xac947284,0xfb7d748c,0xfb75e570],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd2eafd86,0xf63b109b,0x91f5dbb3,0xa3fb7e13] },
  { key: [0xee053aa0,0x11c8b428,0xcdcc3636,0x313c54d6,0xa03cac01,0xc71579d6],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9b9fdd1c,0x5975655f,0x539998b3,0x06a324af] },
  { key: [0xd2926527,0xe0aa9f37,0xb45e2ec2,0xade5853e,0xf8075761,0x04c7ace3],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdd619e1c,0xf2044461,0x12e0af2b,0x9afa8f8c] },
  { key: [0x982215f4,0xe173dfa0,0xfcffe5d3,0xda41c481,0x2c7bcc8e,0xd3540f93],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd4f0aae1,0x3c8fe933,0x9fbf9e69,0xed0ad74d] },
  { key: [0x98c6b8e0,0x1e379fbd,0x14e61af6,0xaf891596,0x583565f2,0xa27d59e9],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x19c80ec4,0xa6deb7e5,0xed1033dd,0xa933498f] },
  { key: [0xb3ad5cea,0x1dddc214,0xca969ac3,0x5f37dae1,0xa9a9d152,0x8f89bb35],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3cf5e1d2,0x1a17956d,0x1dffad6a,0x7c41c659] },
  { key: [0x45899367,0xc3132849,0x763073c4,0x35a9288a,0x766c8b9e,0xc2308516],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x69fd12e8,0x505f8ded,0x2fdcb197,0xa121b362] },
  { key: [0xec250e04,0xc3903f60,0x2647b85a,0x401a1ae7,0xca2f02f6,0x7fa4253e],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8aa584e2,0xcc4d1741,0x7a97cb9a,0x28ba29c8] },
  { key: [0xd077a03b,0xd8a38973,0x928ccafe,0x4a9d2f45,0x5130bd0a,0xf5ae46a9],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xabc786fb,0x1edb5045,0x80c4d882,0xef29a0c7] },
  { key: [0xd184c36c,0xf0dddfec,0x39e65419,0x50060222,0x37871a47,0xc33d3198],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2e19fb60,0xa3e1de01,0x66f483c9,0x7824a978] },
  { key: [0x4c6994ff,0xa9dcdc80,0x5b60c2c0,0x095334c4,0x2d95a8fc,0x0ca5b080],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x76567095,0x38dd5fec,0x41e0ce6a,0x0f8e207d] },
  { key: [0xc88f5b00,0xa4ef9a68,0x40e2acaf,0x33f00a3b,0xdc4e2589,0x5303fa72],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa67cf333,0xb314d411,0xd3c0ae6e,0x1cfcd8f5] },
  { key: [0x80000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xde885dc8,0x7f5a9259,0x4082d02c,0xc1e1b42c] },
  { key: [0xc0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x132b074e,0x80f2a597,0xbf5febd8,0xea5da55e] },
  { key: [0xe0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6eccedf8,0xde592c22,0xfb81347b,0x79f2db1f] },
  { key: [0xf0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x180b09f2,0x67c45145,0xdb2f826c,0x2582d35c] },
  { key: [0xf8000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xedd807ef,0x7652d7eb,0x0e13c8b5,0xe15b3bc0] },
  { key: [0xfc000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9978bcf8,0xdd8fd722,0x41223ad2,0x4b31b8a4] },
  { key: [0xfe000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5310f654,0x343e8f27,0xe12c83a4,0x8d24ff81] },
  { key: [0xff000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x833f7125,0x8d53036b,0x02952c76,0xc744f5a1] },
  { key: [0xff800000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xeba83ff2,0x00cff931,0x8a92f869,0x1a06b09f] },
  { key: [0xffc00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xff620ccb,0xe9f3292a,0xbdf2176b,0x09f04eba] },
  { key: [0xffe00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7ababc4b,0x3f516c9a,0xafb35f41,0x40b548f9] },
  { key: [0xfff00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xaa187824,0xd9c4582b,0x0916493e,0xcbde8c57] },
  { key: [0xfff80000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1c0ad553,0x177fd5ea,0x1092c9d6,0x26a29dc4] },
  { key: [0xfffc0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa5dc46c3,0x72611941,0x24ecaebd,0x680408ec] },
  { key: [0xfffe0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe4f2f2ae,0x23e9b10b,0xacfa5860,0x1531ba54] },
  { key: [0xffff0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb7d67cf1,0xa1e91e8f,0xf3a57a17,0x2c7bf412] },
  { key: [0xffff8000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x26706be0,0x6967884e,0x847d1371,0x28ce47b3] },
  { key: [0xffffc000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb2f8b409,0xb0585909,0xaad3a7b5,0xa219072a] },
  { key: [0xffffe000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5e4b7bff,0x0290c783,0x44c54a23,0xb722cd20] },
  { key: [0xfffff000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x07093657,0x552d4414,0x227ce161,0xe9ebf7dd] },
  { key: [0xfffff800,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe1af1e7d,0x8bc225ed,0x4dffb771,0xecbb9e67] },
  { key: [0xfffffc00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xef655525,0x3635d843,0x2156cfd9,0xc11b145a] },
  { key: [0xfffffe00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfb403507,0x4a5d4260,0xc90cbd6d,0xa6c3fceb] },
  { key: [0xffffff00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x446ee416,0xf9ad1c10,0x3eb0cc96,0x751c88e1] },
  { key: [0xffffff80,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x198ae2a4,0x637ac0a7,0x890a8fd1,0x485445c9] },
  { key: [0xffffffc0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x562012ec,0x8faded08,0x25fb2fa7,0x0ab30cbd] },
  { key: [0xffffffe0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcc8a64b4,0x6b5d88bf,0x7f247d4d,0xbaf38f05] },
  { key: [0xfffffff0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa1682537,0x62e2cc81,0xb42d1e50,0x01762699] },
  { key: [0xfffffff8,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1b41f83b,0x38ce5032,0xc6cd7af9,0x8cf62061] },
  { key: [0xfffffffc,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x61a89990,0xcd141175,0x0d5fb0dc,0x988447d4] },
  { key: [0xfffffffe,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb5accc8e,0xd629edf8,0xc68a5391,0x83b1ea82] },
  { key: [0xffffffff,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb16fa71f,0x846b81a1,0x3f361c43,0xa851f290] },
  { key: [0xffffffff,0x80000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4fad6efd,0xff5975ae,0xe7692234,0xbcd54488] },
  { key: [0xffffffff,0xc0000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xebfdb05a,0x783d0308,0x2dfe5fdd,0x80a00b17] },
  { key: [0xffffffff,0xe0000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xeb81b584,0x766997af,0x6ba5529d,0x3bdd8609] },
  { key: [0xffffffff,0xf0000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0cf4ff4f,0x49c8a0ca,0x060c4434,0x99e29313] },
  { key: [0xffffffff,0xf8000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcc4ba8a8,0xe029f8b2,0x6d8afff9,0xdf133bb6] },
  { key: [0xffffffff,0xfc000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfefebf64,0x360f38e4,0xe63558f0,0xffc550c3] },
  { key: [0xffffffff,0xfe000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x12ad98cb,0xf725137d,0x6a8108c2,0xbed99322] },
  { key: [0xffffffff,0xff000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6afaa996,0x226198b3,0xe2610413,0xce1b3f78] },
  { key: [0xffffffff,0xff800000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2a8ce674,0x7a7e3936,0x7828e290,0x848502d9] },
  { key: [0xffffffff,0xffc00000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x223736e8,0xb8f89ca1,0xe37b6dea,0xb40facf1] },
  { key: [0xffffffff,0xffe00000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc0f797e5,0x0418b95f,0xa6013333,0x917a9480] },
  { key: [0xffffffff,0xfff00000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa758de37,0xc2ece2a0,0x2c73c01f,0xedc9a132] },
  { key: [0xffffffff,0xfff80000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3a9b87ae,0x77bae706,0x803966c6,0x6c73adbd] },
  { key: [0xffffffff,0xfffc0000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd365ab8d,0xf8ffd782,0xe358121a,0x4a4fc541] },
  { key: [0xffffffff,0xfffe0000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc8dcd9e6,0xf75e6c36,0xc8daee04,0x66f0ed74] },
  { key: [0xffffffff,0xffff0000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc79a637b,0xeb1c0304,0xf14014c0,0x37e736dd] },
  { key: [0xffffffff,0xffff8000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x105f0a25,0xe84ac930,0xd996281a,0x5f954dd9] },
  { key: [0xffffffff,0xffffc000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x42e4074b,0x2927973e,0x8d17ffa9,0x2f7fe615] },
  { key: [0xffffffff,0xffffe000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4fe2a9d2,0xc1824449,0xc69e3e03,0x98f12963] },
  { key: [0xffffffff,0xfffff000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb7f29c1e,0x1f62847a,0x15253b28,0xa1e9d712] },
  { key: [0xffffffff,0xfffff800,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x36ed5d29,0xb903f31e,0x8983ef8b,0x0a2bf990] },
  { key: [0xffffffff,0xfffffc00,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x27b80702,0x70810f9d,0x023f9dd7,0xff3b4aa2] },
  { key: [0xffffffff,0xfffffe00,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x94d46e15,0x5c1228f6,0x1d1a0db4,0x815ecc4b] },
  { key: [0xffffffff,0xffffff00,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xca6108d1,0xd9807142,0x8eeceef1,0x714b96dd] },
  { key: [0xffffffff,0xffffff80,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdc5b25b7,0x1b6296cf,0x73dd2cdc,0xac2f70b1] },
  { key: [0xffffffff,0xffffffc0,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x44aba95e,0x8a06a2d9,0xd3530d26,0x77878c80] },
  { key: [0xffffffff,0xffffffe0,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa570d20e,0x89b467e8,0xf5176061,0xb81dd396] },
  { key: [0xffffffff,0xfffffff0,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x758f4467,0xa5d8f1e7,0x307dc30b,0x34e404f4] },
  { key: [0xffffffff,0xfffffff8,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbcea28e9,0x071b5a23,0x02970ff3,0x52451bc5] },
  { key: [0xffffffff,0xfffffffc,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7523c00b,0xc177d331,0xad312e09,0xc9015c1c] },
  { key: [0xffffffff,0xfffffffe,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xccac61e3,0x183747b3,0xf5836da2,0x1a1bc4f4] },
  { key: [0xffffffff,0xffffffff,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x707b0757,0x91878880,0xb44189d3,0x522b8c30] },
  { key: [0xffffffff,0xffffffff,0x80000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7132d0c0,0xe4a07593,0xcf12ebb1,0x2be7688c] },
  { key: [0xffffffff,0xffffffff,0xc0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xeffbac16,0x44deb0c7,0x84275fe5,0x6e19ead3] },
  { key: [0xffffffff,0xffffffff,0xe0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa005063f,0x30f4228b,0x374e2459,0x738f26bb] },
  { key: [0xffffffff,0xffffffff,0xf0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x29975b5f,0x48bb68fc,0xbbc7cea9,0x3b452ed7] },
  { key: [0xffffffff,0xffffffff,0xf8000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcf3f2576,0xe2afedc7,0x4bb1ca7e,0xeec1c0e7] },
  { key: [0xffffffff,0xffffffff,0xfc000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x07c403f5,0xf966e0e3,0xd9f296d6,0x226dca28] },
  { key: [0xffffffff,0xffffffff,0xfe000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc8c20908,0x249ab4a3,0x4d6dd0a3,0x1327ff1a] },
  { key: [0xffffffff,0xffffffff,0xff000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc0541329,0xecb6159a,0xb23b7fc5,0xe6a21bca] },
  { key: [0xffffffff,0xffffffff,0xff800000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7aa1acf1,0xa2ed9ba7,0x2bc6deb3,0x1d88b863] },
  { key: [0xffffffff,0xffffffff,0xffc00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x808bd8ed,0xdabb6f3b,0xf0d5a8a2,0x7be1fe8a] },
  { key: [0xffffffff,0xffffffff,0xffe00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x273c7d76,0x85e14ec6,0x6bbb96b8,0xf05b6ddd] },
  { key: [0xffffffff,0xffffffff,0xfff00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x32752eef,0xc8c2a93f,0x91b6e73e,0xb07cca6e] },
  { key: [0xffffffff,0xffffffff,0xfff80000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd893e7d6,0x2f6ce502,0xc64f75e2,0x81f9c000] },
  { key: [0xffffffff,0xffffffff,0xfffc0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8dfd999b,0xe5d0cfa3,0x5732c0dd,0xc88ff5a5] },
  { key: [0xffffffff,0xffffffff,0xfffe0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x02647c76,0xa300c317,0x3b841487,0xeb2bae9f] },
  { key: [0xffffffff,0xffffffff,0xffff0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x172df8b0,0x2f04b53a,0xdab028b4,0xe01acd87] },
  { key: [0xffffffff,0xffffffff,0xffff8000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x054b3bf4,0x998aeb05,0xafd87ec5,0x36533a36] },
  { key: [0xffffffff,0xffffffff,0xffffc000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3783f7bf,0x44c97f06,0x5258a666,0xcae03020] },
  { key: [0xffffffff,0xffffffff,0xffffe000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xaad4c8a6,0x3f809541,0x04de7b92,0xcede1be1] },
  { key: [0xffffffff,0xffffffff,0xfffff000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcbfe6181,0x0fd5467c,0xcdacb758,0x00f3ac07] },
  { key: [0xffffffff,0xffffffff,0xfffff800,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x830d8a25,0x90f7d8e1,0xb55a737f,0x4af45f34] },
  { key: [0xffffffff,0xffffffff,0xfffffc00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfffcd468,0x3f858058,0xe7431467,0x1d43fa2c] },
  { key: [0xffffffff,0xffffffff,0xfffffe00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x523d0bab,0xbb82f46e,0xbc9e70b1,0xcd41ddd0] },
  { key: [0xffffffff,0xffffffff,0xffffff00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x344aab37,0x080d7486,0xf7d542a3,0x09e53eed] },
  { key: [0xffffffff,0xffffffff,0xffffff80,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x56c5609d,0x0906b23a,0xb9caca81,0x6f5dbebd] },
  { key: [0xffffffff,0xffffffff,0xffffffc0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7026026e,0xedd91adc,0x6d831cdf,0x9894bdc6] },
  { key: [0xffffffff,0xffffffff,0xffffffe0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x88330baa,0x4f2b618f,0xc9d9b021,0xbf503d5a] },
  { key: [0xffffffff,0xffffffff,0xfffffff0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfc9e0ea2,0x2480b0ba,0xc935c8a8,0xebefcdcf] },
  { key: [0xffffffff,0xffffffff,0xfffffff8,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x29ca779f,0x398fb04f,0x867da7e8,0xa44756cb] },
  { key: [0xffffffff,0xffffffff,0xfffffffc,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x51f89c42,0x985786bf,0xc43c6df8,0xada36832] },
  { key: [0xffffffff,0xffffffff,0xfffffffe,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6ac1de5f,0xb8f21d87,0x4e91c53b,0x560c50e3] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x03aa9058,0x490eda30,0x6001a8a9,0xf48d0ca7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0x80000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe34ec71d,0x6128d487,0x1865d617,0xc30b37e3] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xc0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x14be1c53,0x5b17cabd,0x0c4d9352,0x9d69bf47] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xe0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc9ef6775,0x6507beec,0x9dd38628,0x83478044] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xf0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x40e231fa,0x5a5948ce,0x2134e92f,0xc0664d4b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xf8000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x03194b8e,0x5dda5530,0xd0c678c0,0xb48f5d92] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfc000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x90bd086f,0x237cc4fd,0x99f4d76b,0xde6b4826] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfe000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x19259761,0xca17130d,0x6ed86d57,0xcd7951ee] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xff000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd7cbb3f3,0x4b9b450f,0x24b0e851,0x8e54da6d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xff800000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x725b9cae,0xbe9f7f41,0x7f4068d0,0xd2ee20b3] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffc00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9d924b93,0x4a90ce1f,0xd39b8a97,0x94f82672] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffe00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc50562bf,0x094526a9,0x1c5bc63c,0x0c224995] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfff00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd2f11805,0x046743bd,0x74f57188,0xd9188df7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfff80000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8dd274bd,0x0f1b58ae,0x345d9e72,0x33f9b8f3] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffc0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9d6bdc8f,0x4ce5feb0,0xf3bed2e4,0xb9a9bb0b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffe0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfd5548bc,0xf3f42565,0xf7efa945,0x62528d46] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffff0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd2ccaebd,0x3a4c3e80,0xb0637481,0x31ba4a71] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffff8000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe03cb23d,0x9e11c9d9,0x3f117e9c,0x0a91b576] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffc000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x78f933a2,0x081ac1db,0x84f69d10,0xf4523fe0] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffe000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4061f741,0x2ed320de,0x0edc8851,0xc2e2436f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffff000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9064ba1c,0xd04ce6ba,0xb9847433,0x0814b4d4] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffff800,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x48391bff,0xb9cfff80,0xac238c88,0x6ef0a461] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffc00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb8d2a67d,0xf5a999fd,0xbf93edd0,0x343296c9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffe00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xaaca7367,0x396b69a2,0x21bd632b,0xea386eec] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffff00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa80fd502,0x0dfe65f5,0xf16293ec,0x92c6fd89] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffff80,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2162995b,0x8217a67f,0x1abc342e,0x146406f8] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffc0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc6a6164b,0x7a60bae4,0xe986ffac,0x28dfadd9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffe0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x64e0d7f9,0x00e3d9c8,0x3e4b8f96,0x717b2146] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffff0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1ad2561d,0xe8c1232f,0x5d8dbab4,0x739b6cbb] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffff8,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x279689e9,0xa557f58b,0x1c3bf40c,0x97a90964] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffffc,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc4637e4a,0x5e6377f9,0xcc5a8638,0x045de029] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffffe,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x492e607e,0x5aea4688,0x594b45f3,0xaee3df90] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe8c4e438,0x1feec740,0x54954c05,0xb777a00a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x80000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x91549514,0x605f3824,0x6c9b724a,0xd839f01d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xc0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x74b24e3b,0x6fefe40a,0x4f9ef7ac,0x6e44d76a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xe0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2437a683,0xdc5d4b52,0xabb4a123,0xa8df86c6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbb2852c8,0x91c5947d,0x2ed44032,0xc421b85f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf8000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1b9f5fbd,0x5e8a4264,0xc0a85b80,0x409afa5e] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfc000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x30dab809,0xf85a917f,0xe924733f,0x424ac589] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfe000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xeaef5c1f,0x8d605192,0x646695ce,0xadc65f32] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb8aa9004,0x0b4c15a1,0x2316b78e,0x0f9586fc] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff800000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x97fac829,0x7ceaabc8,0x7d454350,0x601e0673] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffc00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9b47ef56,0x7ac28dfe,0x488492f1,0x57e2b2e0] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffe00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1b842602,0x7ddb962b,0x5c5ba7eb,0x8bc9ab63] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe917fc77,0xe71992a1,0x2dbe4c18,0x068bec82] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff80000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdceebbc9,0x8840f8ae,0x6daf7657,0x3b7e56f4] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffc0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4e11a9f7,0x4205125b,0x61e0aee0,0x47eca20d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffe0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf60467f5,0x5a1f17ea,0xb88e8001,0x20cbc284] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd436649f,0x600b449e,0xe276530f,0x0cd83c11] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff8000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3bc0e365,0x6a9e3ac7,0xcd378a73,0x7f53b637] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffc000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6bacae63,0xd33b928a,0xa8380f8d,0x54d88c17] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffe000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8935ffbc,0x75ae6251,0xbf8e859f,0x085adcb9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x93dc4970,0xfe35f677,0x47cb0562,0xc06d875a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff800,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x14f9df85,0x89758517,0x97ba604f,0xb0d16cc7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffc00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x02ea0c98,0xdca10b38,0xc21b3b14,0xe8d1b71f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffe00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8f091b1b,0x5b0749b2,0xadc803e6,0x3dda9b72] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x05b389e3,0x322c6da0,0x8384345a,0x4137fd08] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff80,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x381308c4,0x38f35b39,0x9f10ad71,0xb05027d8] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffc0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x68c230fc,0xfa9279c3,0x409fc423,0xe2acbe04] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffe0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1c84a475,0xacb011f3,0xf59f4f46,0xb76274c0] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x45119b68,0xcb3f8399,0xee60066b,0x5611a4d7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff8,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9423762f,0x527a4060,0xffca312d,0xcca22a16] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffc,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf361a274,0x5a33f056,0xa5ac6ace,0x2f08e344] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffe,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5ef14576,0x6eca849f,0x5d011536,0xa6557fdb] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc9af27b2,0xc89c9b4c,0xf4a0c410,0x6ac80318] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x80000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfb9c4f16,0xc621f4ea,0xb7e9ac1d,0x7551dd57] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xc0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x138e06fb,0xa466fa70,0x854d8c2e,0x524cffb2] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xe0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfb4bc78b,0x22507077,0x3f04c404,0x66d4e90c] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8b2cbff1,0xed0150fe,0xda8a4799,0xbe94551f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf8000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x08b30d7b,0x3f279627,0x09a36bca,0xdfb974bd] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfc000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfdf6d32e,0x044d77ad,0xcf37fb97,0xac213326] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfe000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x93cb284e,0xcdcfd781,0xa8afe320,0x77949e88] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7b017bb0,0x2ec87b2b,0x94c96e40,0xa26fc71a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff800000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc5c038b6,0x990664ab,0x08a3aaa5,0xdf9f3266] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffc00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4b7020be,0x37fab625,0x9b2a27f4,0xec551576] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffe00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x60136703,0x374f64e8,0x60b48ce3,0x1f930716] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8d63a269,0xb14d506c,0xcc401ab8,0xa9f1b591] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff80000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd317f81d,0xc6aa454a,0xee4bd4a5,0xa5cff4bd] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffc0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdddececd,0x5354f04d,0x530d76ed,0x884246eb] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffe0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x41c5205c,0xc8fd8eda,0x9a3cffd2,0x518f365a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcf42fb47,0x4293d96e,0xca9db1b3,0x7b1ba676] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff8000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa2316926,0x07169b4e,0xcdead5cd,0x3b10db3e] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffc000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xace4b91c,0x9c669e77,0xe7acacd1,0x9859ed49] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffe000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x75db7cfd,0x4a7b2b62,0xab78a48f,0x3ddaf4af] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc1faba2d,0x46e259cf,0x480d7c38,0xe4572a58] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff800],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x241c45bc,0x6ae16dee,0x6eb7bea1,0x28701582] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffc00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8fd03057,0xcf136442,0x0c2b7806,0x9a3e2502] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffe00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xddb505e6,0xcc1384cb,0xaec1df90,0xb80beb20] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5674a3be,0xd27bf4bd,0x3622f9f5,0xfe208306] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff80],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb687f26a,0x89cfbfbb,0x8e5eeac5,0x4055315e] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffc0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0547dd32,0xd3b29ab6,0xa4caeb60,0x6c5b6f78] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffe0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x186861f8,0xbc5386d3,0x1fb77f72,0x0c3226e6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xeacf1e6c,0x4224efb3,0x8900b185,0xab1dfd42] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff8],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd241aab0,0x5a42d319,0xde81d874,0xf5c7b90d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffc],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5eb9bc75,0x9e2ad8d2,0x140a6c76,0x2ae9e1ab] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffe],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x018596e1,0x5e78e2c0,0x64159def,0xce5f3085] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdd8a4935,0x14231cbf,0x56eccee4,0xc40889fb] },
  { key: [0x80000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xde885dc8,0x7f5a9259,0x4082d02c,0xc1e1b42c] },
  { key: [0xc0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x132b074e,0x80f2a597,0xbf5febd8,0xea5da55e] },
  { key: [0xe0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6eccedf8,0xde592c22,0xfb81347b,0x79f2db1f] },
  { key: [0xf0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x180b09f2,0x67c45145,0xdb2f826c,0x2582d35c] },
  { key: [0xf8000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xedd807ef,0x7652d7eb,0x0e13c8b5,0xe15b3bc0] },
  { key: [0xfc000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9978bcf8,0xdd8fd722,0x41223ad2,0x4b31b8a4] },
  { key: [0xfe000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5310f654,0x343e8f27,0xe12c83a4,0x8d24ff81] },
  { key: [0xff000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x833f7125,0x8d53036b,0x02952c76,0xc744f5a1] },
  { key: [0xff800000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xeba83ff2,0x00cff931,0x8a92f869,0x1a06b09f] },
  { key: [0xffc00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xff620ccb,0xe9f3292a,0xbdf2176b,0x09f04eba] },
  { key: [0xffe00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7ababc4b,0x3f516c9a,0xafb35f41,0x40b548f9] },
  { key: [0xfff00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xaa187824,0xd9c4582b,0x0916493e,0xcbde8c57] },
  { key: [0xfff80000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1c0ad553,0x177fd5ea,0x1092c9d6,0x26a29dc4] },
  { key: [0xfffc0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa5dc46c3,0x72611941,0x24ecaebd,0x680408ec] },
  { key: [0xfffe0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe4f2f2ae,0x23e9b10b,0xacfa5860,0x1531ba54] },
  { key: [0xffff0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb7d67cf1,0xa1e91e8f,0xf3a57a17,0x2c7bf412] },
  { key: [0xffff8000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x26706be0,0x6967884e,0x847d1371,0x28ce47b3] },
  { key: [0xffffc000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb2f8b409,0xb0585909,0xaad3a7b5,0xa219072a] },
  { key: [0xffffe000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5e4b7bff,0x0290c783,0x44c54a23,0xb722cd20] },
  { key: [0xfffff000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x07093657,0x552d4414,0x227ce161,0xe9ebf7dd] },
  { key: [0xfffff800,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe1af1e7d,0x8bc225ed,0x4dffb771,0xecbb9e67] },
  { key: [0xfffffc00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xef655525,0x3635d843,0x2156cfd9,0xc11b145a] },
  { key: [0xfffffe00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfb403507,0x4a5d4260,0xc90cbd6d,0xa6c3fceb] },
  { key: [0xffffff00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x446ee416,0xf9ad1c10,0x3eb0cc96,0x751c88e1] },
  { key: [0xffffff80,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x198ae2a4,0x637ac0a7,0x890a8fd1,0x485445c9] },
  { key: [0xffffffc0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x562012ec,0x8faded08,0x25fb2fa7,0x0ab30cbd] },
  { key: [0xffffffe0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcc8a64b4,0x6b5d88bf,0x7f247d4d,0xbaf38f05] },
  { key: [0xfffffff0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa1682537,0x62e2cc81,0xb42d1e50,0x01762699] },
  { key: [0xfffffff8,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1b41f83b,0x38ce5032,0xc6cd7af9,0x8cf62061] },
  { key: [0xfffffffc,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x61a89990,0xcd141175,0x0d5fb0dc,0x988447d4] },
  { key: [0xfffffffe,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb5accc8e,0xd629edf8,0xc68a5391,0x83b1ea82] },
  { key: [0xffffffff,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb16fa71f,0x846b81a1,0x3f361c43,0xa851f290] },
  { key: [0xffffffff,0x80000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4fad6efd,0xff5975ae,0xe7692234,0xbcd54488] },
  { key: [0xffffffff,0xc0000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xebfdb05a,0x783d0308,0x2dfe5fdd,0x80a00b17] },
  { key: [0xffffffff,0xe0000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xeb81b584,0x766997af,0x6ba5529d,0x3bdd8609] },
  { key: [0xffffffff,0xf0000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0cf4ff4f,0x49c8a0ca,0x060c4434,0x99e29313] },
  { key: [0xffffffff,0xf8000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcc4ba8a8,0xe029f8b2,0x6d8afff9,0xdf133bb6] },
  { key: [0xffffffff,0xfc000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfefebf64,0x360f38e4,0xe63558f0,0xffc550c3] },
  { key: [0xffffffff,0xfe000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x12ad98cb,0xf725137d,0x6a8108c2,0xbed99322] },
  { key: [0xffffffff,0xff000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6afaa996,0x226198b3,0xe2610413,0xce1b3f78] },
  { key: [0xffffffff,0xff800000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2a8ce674,0x7a7e3936,0x7828e290,0x848502d9] },
  { key: [0xffffffff,0xffc00000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x223736e8,0xb8f89ca1,0xe37b6dea,0xb40facf1] },
  { key: [0xffffffff,0xffe00000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc0f797e5,0x0418b95f,0xa6013333,0x917a9480] },
  { key: [0xffffffff,0xfff00000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa758de37,0xc2ece2a0,0x2c73c01f,0xedc9a132] },
  { key: [0xffffffff,0xfff80000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3a9b87ae,0x77bae706,0x803966c6,0x6c73adbd] },
  { key: [0xffffffff,0xfffc0000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd365ab8d,0xf8ffd782,0xe358121a,0x4a4fc541] },
  { key: [0xffffffff,0xfffe0000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc8dcd9e6,0xf75e6c36,0xc8daee04,0x66f0ed74] },
  { key: [0xffffffff,0xffff0000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc79a637b,0xeb1c0304,0xf14014c0,0x37e736dd] },
  { key: [0xffffffff,0xffff8000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x105f0a25,0xe84ac930,0xd996281a,0x5f954dd9] },
  { key: [0xffffffff,0xffffc000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x42e4074b,0x2927973e,0x8d17ffa9,0x2f7fe615] },
  { key: [0xffffffff,0xffffe000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4fe2a9d2,0xc1824449,0xc69e3e03,0x98f12963] },
  { key: [0xffffffff,0xfffff000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb7f29c1e,0x1f62847a,0x15253b28,0xa1e9d712] },
  { key: [0xffffffff,0xfffff800,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x36ed5d29,0xb903f31e,0x8983ef8b,0x0a2bf990] },
  { key: [0xffffffff,0xfffffc00,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x27b80702,0x70810f9d,0x023f9dd7,0xff3b4aa2] },
  { key: [0xffffffff,0xfffffe00,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x94d46e15,0x5c1228f6,0x1d1a0db4,0x815ecc4b] },
  { key: [0xffffffff,0xffffff00,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xca6108d1,0xd9807142,0x8eeceef1,0x714b96dd] },
  { key: [0xffffffff,0xffffff80,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdc5b25b7,0x1b6296cf,0x73dd2cdc,0xac2f70b1] },
  { key: [0xffffffff,0xffffffc0,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x44aba95e,0x8a06a2d9,0xd3530d26,0x77878c80] },
  { key: [0xffffffff,0xffffffe0,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa570d20e,0x89b467e8,0xf5176061,0xb81dd396] },
  { key: [0xffffffff,0xfffffff0,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x758f4467,0xa5d8f1e7,0x307dc30b,0x34e404f4] },
  { key: [0xffffffff,0xfffffff8,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbcea28e9,0x071b5a23,0x02970ff3,0x52451bc5] },
  { key: [0xffffffff,0xfffffffc,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7523c00b,0xc177d331,0xad312e09,0xc9015c1c] },
  { key: [0xffffffff,0xfffffffe,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xccac61e3,0x183747b3,0xf5836da2,0x1a1bc4f4] },
  { key: [0xffffffff,0xffffffff,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x707b0757,0x91878880,0xb44189d3,0x522b8c30] },
  { key: [0xffffffff,0xffffffff,0x80000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7132d0c0,0xe4a07593,0xcf12ebb1,0x2be7688c] },
  { key: [0xffffffff,0xffffffff,0xc0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xeffbac16,0x44deb0c7,0x84275fe5,0x6e19ead3] },
  { key: [0xffffffff,0xffffffff,0xe0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa005063f,0x30f4228b,0x374e2459,0x738f26bb] },
  { key: [0xffffffff,0xffffffff,0xf0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x29975b5f,0x48bb68fc,0xbbc7cea9,0x3b452ed7] },
  { key: [0xffffffff,0xffffffff,0xf8000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcf3f2576,0xe2afedc7,0x4bb1ca7e,0xeec1c0e7] },
  { key: [0xffffffff,0xffffffff,0xfc000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x07c403f5,0xf966e0e3,0xd9f296d6,0x226dca28] },
  { key: [0xffffffff,0xffffffff,0xfe000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc8c20908,0x249ab4a3,0x4d6dd0a3,0x1327ff1a] },
  { key: [0xffffffff,0xffffffff,0xff000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc0541329,0xecb6159a,0xb23b7fc5,0xe6a21bca] },
  { key: [0xffffffff,0xffffffff,0xff800000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7aa1acf1,0xa2ed9ba7,0x2bc6deb3,0x1d88b863] },
  { key: [0xffffffff,0xffffffff,0xffc00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x808bd8ed,0xdabb6f3b,0xf0d5a8a2,0x7be1fe8a] },
  { key: [0xffffffff,0xffffffff,0xffe00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x273c7d76,0x85e14ec6,0x6bbb96b8,0xf05b6ddd] },
  { key: [0xffffffff,0xffffffff,0xfff00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x32752eef,0xc8c2a93f,0x91b6e73e,0xb07cca6e] },
  { key: [0xffffffff,0xffffffff,0xfff80000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd893e7d6,0x2f6ce502,0xc64f75e2,0x81f9c000] },
  { key: [0xffffffff,0xffffffff,0xfffc0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8dfd999b,0xe5d0cfa3,0x5732c0dd,0xc88ff5a5] },
  { key: [0xffffffff,0xffffffff,0xfffe0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x02647c76,0xa300c317,0x3b841487,0xeb2bae9f] },
  { key: [0xffffffff,0xffffffff,0xffff0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x172df8b0,0x2f04b53a,0xdab028b4,0xe01acd87] },
  { key: [0xffffffff,0xffffffff,0xffff8000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x054b3bf4,0x998aeb05,0xafd87ec5,0x36533a36] },
  { key: [0xffffffff,0xffffffff,0xffffc000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3783f7bf,0x44c97f06,0x5258a666,0xcae03020] },
  { key: [0xffffffff,0xffffffff,0xffffe000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xaad4c8a6,0x3f809541,0x04de7b92,0xcede1be1] },
  { key: [0xffffffff,0xffffffff,0xfffff000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcbfe6181,0x0fd5467c,0xcdacb758,0x00f3ac07] },
  { key: [0xffffffff,0xffffffff,0xfffff800,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x830d8a25,0x90f7d8e1,0xb55a737f,0x4af45f34] },
  { key: [0xffffffff,0xffffffff,0xfffffc00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfffcd468,0x3f858058,0xe7431467,0x1d43fa2c] },
  { key: [0xffffffff,0xffffffff,0xfffffe00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x523d0bab,0xbb82f46e,0xbc9e70b1,0xcd41ddd0] },
  { key: [0xffffffff,0xffffffff,0xffffff00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x344aab37,0x080d7486,0xf7d542a3,0x09e53eed] },
  { key: [0xffffffff,0xffffffff,0xffffff80,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x56c5609d,0x0906b23a,0xb9caca81,0x6f5dbebd] },
  { key: [0xffffffff,0xffffffff,0xffffffc0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7026026e,0xedd91adc,0x6d831cdf,0x9894bdc6] },
  { key: [0xffffffff,0xffffffff,0xffffffe0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x88330baa,0x4f2b618f,0xc9d9b021,0xbf503d5a] },
  { key: [0xffffffff,0xffffffff,0xfffffff0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfc9e0ea2,0x2480b0ba,0xc935c8a8,0xebefcdcf] },
  { key: [0xffffffff,0xffffffff,0xfffffff8,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x29ca779f,0x398fb04f,0x867da7e8,0xa44756cb] },
  { key: [0xffffffff,0xffffffff,0xfffffffc,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x51f89c42,0x985786bf,0xc43c6df8,0xada36832] },
  { key: [0xffffffff,0xffffffff,0xfffffffe,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6ac1de5f,0xb8f21d87,0x4e91c53b,0x560c50e3] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x03aa9058,0x490eda30,0x6001a8a9,0xf48d0ca7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0x80000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe34ec71d,0x6128d487,0x1865d617,0xc30b37e3] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xc0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x14be1c53,0x5b17cabd,0x0c4d9352,0x9d69bf47] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xe0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc9ef6775,0x6507beec,0x9dd38628,0x83478044] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xf0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x40e231fa,0x5a5948ce,0x2134e92f,0xc0664d4b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xf8000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x03194b8e,0x5dda5530,0xd0c678c0,0xb48f5d92] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfc000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x90bd086f,0x237cc4fd,0x99f4d76b,0xde6b4826] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfe000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x19259761,0xca17130d,0x6ed86d57,0xcd7951ee] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xff000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd7cbb3f3,0x4b9b450f,0x24b0e851,0x8e54da6d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xff800000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x725b9cae,0xbe9f7f41,0x7f4068d0,0xd2ee20b3] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffc00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9d924b93,0x4a90ce1f,0xd39b8a97,0x94f82672] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffe00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc50562bf,0x094526a9,0x1c5bc63c,0x0c224995] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfff00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd2f11805,0x046743bd,0x74f57188,0xd9188df7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfff80000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8dd274bd,0x0f1b58ae,0x345d9e72,0x33f9b8f3] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffc0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9d6bdc8f,0x4ce5feb0,0xf3bed2e4,0xb9a9bb0b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffe0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfd5548bc,0xf3f42565,0xf7efa945,0x62528d46] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffff0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd2ccaebd,0x3a4c3e80,0xb0637481,0x31ba4a71] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffff8000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe03cb23d,0x9e11c9d9,0x3f117e9c,0x0a91b576] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffc000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x78f933a2,0x081ac1db,0x84f69d10,0xf4523fe0] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffe000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4061f741,0x2ed320de,0x0edc8851,0xc2e2436f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffff000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9064ba1c,0xd04ce6ba,0xb9847433,0x0814b4d4] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffff800,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x48391bff,0xb9cfff80,0xac238c88,0x6ef0a461] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffc00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb8d2a67d,0xf5a999fd,0xbf93edd0,0x343296c9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffe00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xaaca7367,0x396b69a2,0x21bd632b,0xea386eec] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffff00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa80fd502,0x0dfe65f5,0xf16293ec,0x92c6fd89] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffff80,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2162995b,0x8217a67f,0x1abc342e,0x146406f8] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffc0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc6a6164b,0x7a60bae4,0xe986ffac,0x28dfadd9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffe0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x64e0d7f9,0x00e3d9c8,0x3e4b8f96,0x717b2146] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffff0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1ad2561d,0xe8c1232f,0x5d8dbab4,0x739b6cbb] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffff8,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x279689e9,0xa557f58b,0x1c3bf40c,0x97a90964] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffffc,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc4637e4a,0x5e6377f9,0xcc5a8638,0x045de029] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffffe,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x492e607e,0x5aea4688,0x594b45f3,0xaee3df90] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe8c4e438,0x1feec740,0x54954c05,0xb777a00a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x80000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x91549514,0x605f3824,0x6c9b724a,0xd839f01d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xc0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x74b24e3b,0x6fefe40a,0x4f9ef7ac,0x6e44d76a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xe0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2437a683,0xdc5d4b52,0xabb4a123,0xa8df86c6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbb2852c8,0x91c5947d,0x2ed44032,0xc421b85f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf8000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1b9f5fbd,0x5e8a4264,0xc0a85b80,0x409afa5e] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfc000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x30dab809,0xf85a917f,0xe924733f,0x424ac589] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfe000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xeaef5c1f,0x8d605192,0x646695ce,0xadc65f32] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb8aa9004,0x0b4c15a1,0x2316b78e,0x0f9586fc] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff800000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x97fac829,0x7ceaabc8,0x7d454350,0x601e0673] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffc00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9b47ef56,0x7ac28dfe,0x488492f1,0x57e2b2e0] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffe00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1b842602,0x7ddb962b,0x5c5ba7eb,0x8bc9ab63] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe917fc77,0xe71992a1,0x2dbe4c18,0x068bec82] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff80000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdceebbc9,0x8840f8ae,0x6daf7657,0x3b7e56f4] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffc0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4e11a9f7,0x4205125b,0x61e0aee0,0x47eca20d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffe0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf60467f5,0x5a1f17ea,0xb88e8001,0x20cbc284] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd436649f,0x600b449e,0xe276530f,0x0cd83c11] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff8000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3bc0e365,0x6a9e3ac7,0xcd378a73,0x7f53b637] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffc000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6bacae63,0xd33b928a,0xa8380f8d,0x54d88c17] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffe000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8935ffbc,0x75ae6251,0xbf8e859f,0x085adcb9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x93dc4970,0xfe35f677,0x47cb0562,0xc06d875a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff800,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x14f9df85,0x89758517,0x97ba604f,0xb0d16cc7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffc00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x02ea0c98,0xdca10b38,0xc21b3b14,0xe8d1b71f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffe00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8f091b1b,0x5b0749b2,0xadc803e6,0x3dda9b72] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x05b389e3,0x322c6da0,0x8384345a,0x4137fd08] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff80,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x381308c4,0x38f35b39,0x9f10ad71,0xb05027d8] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffc0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x68c230fc,0xfa9279c3,0x409fc423,0xe2acbe04] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffe0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1c84a475,0xacb011f3,0xf59f4f46,0xb76274c0] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x45119b68,0xcb3f8399,0xee60066b,0x5611a4d7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff8,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9423762f,0x527a4060,0xffca312d,0xcca22a16] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffc,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf361a274,0x5a33f056,0xa5ac6ace,0x2f08e344] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffe,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5ef14576,0x6eca849f,0x5d011536,0xa6557fdb] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc9af27b2,0xc89c9b4c,0xf4a0c410,0x6ac80318] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x80000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfb9c4f16,0xc621f4ea,0xb7e9ac1d,0x7551dd57] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xc0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x138e06fb,0xa466fa70,0x854d8c2e,0x524cffb2] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xe0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfb4bc78b,0x22507077,0x3f04c404,0x66d4e90c] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8b2cbff1,0xed0150fe,0xda8a4799,0xbe94551f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf8000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x08b30d7b,0x3f279627,0x09a36bca,0xdfb974bd] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfc000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfdf6d32e,0x044d77ad,0xcf37fb97,0xac213326] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfe000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x93cb284e,0xcdcfd781,0xa8afe320,0x77949e88] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7b017bb0,0x2ec87b2b,0x94c96e40,0xa26fc71a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff800000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc5c038b6,0x990664ab,0x08a3aaa5,0xdf9f3266] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffc00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4b7020be,0x37fab625,0x9b2a27f4,0xec551576] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffe00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x60136703,0x374f64e8,0x60b48ce3,0x1f930716] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8d63a269,0xb14d506c,0xcc401ab8,0xa9f1b591] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff80000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd317f81d,0xc6aa454a,0xee4bd4a5,0xa5cff4bd] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffc0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdddececd,0x5354f04d,0x530d76ed,0x884246eb] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffe0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x41c5205c,0xc8fd8eda,0x9a3cffd2,0x518f365a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcf42fb47,0x4293d96e,0xca9db1b3,0x7b1ba676] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff8000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa2316926,0x07169b4e,0xcdead5cd,0x3b10db3e] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffc000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xace4b91c,0x9c669e77,0xe7acacd1,0x9859ed49] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffe000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x75db7cfd,0x4a7b2b62,0xab78a48f,0x3ddaf4af] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc1faba2d,0x46e259cf,0x480d7c38,0xe4572a58] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff800],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x241c45bc,0x6ae16dee,0x6eb7bea1,0x28701582] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffc00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8fd03057,0xcf136442,0x0c2b7806,0x9a3e2502] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffe00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xddb505e6,0xcc1384cb,0xaec1df90,0xb80beb20] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5674a3be,0xd27bf4bd,0x3622f9f5,0xfe208306] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff80],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb687f26a,0x89cfbfbb,0x8e5eeac5,0x4055315e] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffc0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0547dd32,0xd3b29ab6,0xa4caeb60,0x6c5b6f78] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffe0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x186861f8,0xbc5386d3,0x1fb77f72,0x0c3226e6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xeacf1e6c,0x4224efb3,0x8900b185,0xab1dfd42] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff8],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd241aab0,0x5a42d319,0xde81d874,0xf5c7b90d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffc],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5eb9bc75,0x9e2ad8d2,0x140a6c76,0x2ae9e1ab] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffe],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x018596e1,0x5e78e2c0,0x64159def,0xce5f3085] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdd8a4935,0x14231cbf,0x56eccee4,0xc40889fb] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x80000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xddc6bf79,0x0c15760d,0x8d9aeb6f,0x9a75fd4e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xc0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0a6bdc6d,0x4c1e6280,0x301fd8e9,0x7ddbe601] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xe0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9b80eefb,0x7ebe2d2b,0x16247aa0,0xefc72f5d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xf0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7f2c5ece,0x07a98d8b,0xee13c511,0x77395ff7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xf8000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7818d800,0xdcf6f4be,0x1e0e94f4,0x03d1e4c2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfc000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe74cd1c9,0x2f0919c3,0x5a032412,0x3d6177d3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfe000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8092a4dc,0xf2da7e77,0xe93bdd37,0x1dfed82e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xff000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x49af6b37,0x2135acef,0x10132e54,0x8f217b17] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xff800000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8bcd40f9,0x4ebb63b9,0xf7909676,0xe667f1e7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffc00000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfe1cffb8,0x3f45dcfb,0x38b29be4,0x38dbd3ab] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffe00000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0dc58a8d,0x88662370,0x5aec15cb,0x1e70dc0e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfff00000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc218faa1,0x6056bd07,0x74c3e8d7,0x9c35a5e4] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfff80000,0x00000000,0x00000000,0x00000000],
    ct:  [0x047bba83,0xf7aa8417,0x31504e01,0x2208fc9e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffc0000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdc8f0e49,0x15fd81ba,0x70a33131,0x0882f6da] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffe0000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1569859e,0xa6b7206c,0x30bf4fd0,0xcbfac33c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffff0000,0x00000000,0x00000000,0x00000000],
    ct:  [0x300ade92,0xf88f48fa,0x2df730ec,0x16ef44cd] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffff8000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1fe6cc3c,0x05965dc0,0x8eb0590c,0x95ac71d0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffc000,0x00000000,0x00000000,0x00000000],
    ct:  [0x59e858ea,0xaa97fec3,0x8111275b,0x6cf5abc0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffe000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2239455e,0x7afe3b06,0x16100288,0xcc5a723b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffff000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3ee500c5,0xc8d63479,0x717163e5,0x5c5c4522] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffff800,0x00000000,0x00000000,0x00000000],
    ct:  [0xd5e38bf1,0x5f16d90e,0x3e214041,0xd774daa8] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffc00,0x00000000,0x00000000,0x00000000],
    ct:  [0xb1f4066e,0x6f4f187d,0xfe5f2ad1,0xb17819d0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffe00,0x00000000,0x00000000,0x00000000],
    ct:  [0x6ef4cc4d,0xe49b1106,0x5d7af290,0x9854794a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffff00,0x00000000,0x00000000,0x00000000],
    ct:  [0xac86bc60,0x6b6640c3,0x09e782f2,0x32bf367f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffff80,0x00000000,0x00000000,0x00000000],
    ct:  [0x36aff0ef,0x7bf32807,0x72cf4cac,0x80a0d2b2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffc0,0x00000000,0x00000000,0x00000000],
    ct:  [0x1f8eedea,0x0f62a140,0x6d58cfc3,0xecea72cf] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffe0,0x00000000,0x00000000,0x00000000],
    ct:  [0xabf4154a,0x3375a1d3,0xe6b1d454,0x438f95a6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffff0,0x00000000,0x00000000,0x00000000],
    ct:  [0x96f96e9d,0x607f6615,0xfc192061,0xee648b07] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffff8,0x00000000,0x00000000,0x00000000],
    ct:  [0xcf37cdaa,0xa0d2d536,0xc7185763,0x4c792064] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffffc,0x00000000,0x00000000,0x00000000],
    ct:  [0xfbd6640c,0x80245c2b,0x805373f1,0x30703127] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffffe,0x00000000,0x00000000,0x00000000],
    ct:  [0x8d6a8afe,0x55a6e481,0xbadae0d1,0x46f436db] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0x00000000,0x00000000,0x00000000],
    ct:  [0x6a4981f2,0x915e3e68,0xaf6c2238,0x5dd06756] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0x80000000,0x00000000,0x00000000],
    ct:  [0x42a1136e,0x5f8d8d21,0xd3101998,0x642d573b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xc0000000,0x00000000,0x00000000],
    ct:  [0x9b471596,0xdc69ae15,0x86cee615,0x8b0b0181] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xe0000000,0x00000000,0x00000000],
    ct:  [0x753665c4,0xaf1eff33,0xaa8b628b,0xf8741cfd] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xf0000000,0x00000000,0x00000000],
    ct:  [0x9a682acf,0x40be01f5,0xb2a4193c,0x9a82404d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xf8000000,0x00000000,0x00000000],
    ct:  [0x54fafe26,0xe4287f17,0xd1935f87,0xeb9ade01] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfc000000,0x00000000,0x00000000],
    ct:  [0x49d541b2,0xe74cfe73,0xe6a8e822,0x5f7bd449] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfe000000,0x00000000,0x00000000],
    ct:  [0x11a45530,0xf624ff6f,0x76a1b382,0x6626ff7b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xff000000,0x00000000,0x00000000],
    ct:  [0xf96b0c4a,0x8bc6c861,0x30289f60,0xb43b8fba] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xff800000,0x00000000,0x00000000],
    ct:  [0x48c7d0e8,0x0834ebdc,0x35b6735f,0x76b46c8b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffc00000,0x00000000,0x00000000],
    ct:  [0x2463531a,0xb54d6695,0x5e73edc4,0xcb8eaa45] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffe00000,0x00000000,0x00000000],
    ct:  [0xac9bd8e2,0x53046913,0x4b9d5b06,0x5d4f565b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfff00000,0x00000000,0x00000000],
    ct:  [0x3f5f9106,0xd0e52f97,0x3d4890e6,0xf37e8a00] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfff80000,0x00000000,0x00000000],
    ct:  [0x20ebc86f,0x1304d272,0xe2e207e5,0x9db639f0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffc0000,0x00000000,0x00000000],
    ct:  [0xe67ae642,0x6bf9526c,0x972cff07,0x2b52252c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffe0000,0x00000000,0x00000000],
    ct:  [0x1a518ddd,0xaf9efa0d,0x002cc58d,0x107edfc8] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffff0000,0x00000000,0x00000000],
    ct:  [0xead731af,0x4d3a2fe3,0xb34bed04,0x7942a49f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffff8000,0x00000000,0x00000000],
    ct:  [0xb1d4efe4,0x0242f83e,0x93b6c8d7,0xefb5eae9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffc000,0x00000000,0x00000000],
    ct:  [0xcd2b1fec,0x11fd906c,0x5c763009,0x9443610a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffe000,0x00000000,0x00000000],
    ct:  [0xa1853fe4,0x7fe29289,0xd153161d,0x06387d21] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffff000,0x00000000,0x00000000],
    ct:  [0x46321541,0x79a555c1,0x7ea604d0,0x889fab14] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffff800,0x00000000,0x00000000],
    ct:  [0xdd27cac6,0x401a022e,0x8f38f9f9,0x3e774417] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffc00,0x00000000,0x00000000],
    ct:  [0xc090313e,0xb98674f3,0x5f312338,0x5fb95d4d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffe00,0x00000000,0x00000000],
    ct:  [0xcc352626,0x2b92f02e,0xdce548f7,0x16b9f45c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffff00,0x00000000,0x00000000],
    ct:  [0xc0838d1a,0x2b16a7c7,0xf0dfcc43,0x3c399c33] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffff80,0x00000000,0x00000000],
    ct:  [0x0d9ac756,0xeb297695,0xeed4d382,0xeb126d26] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffc0,0x00000000,0x00000000],
    ct:  [0x56ede9dd,0xa3f6f141,0xbff1757f,0xa689c3e1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffe0,0x00000000,0x00000000],
    ct:  [0x768f520e,0xfe0f23e6,0x1d3ec8ad,0x9ce91774] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffff0,0x00000000,0x00000000],
    ct:  [0xb1144ddf,0xa7575521,0x3390e7c5,0x96660490] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffff8,0x00000000,0x00000000],
    ct:  [0x1d7c0c40,0x40b355b9,0xd107a993,0x25e3b050] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffffc,0x00000000,0x00000000],
    ct:  [0xd8e2bb1a,0xe8ee3dcf,0x5bf7d6c3,0x8da82a1a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffffe,0x00000000,0x00000000],
    ct:  [0xfaf82d17,0x8af25a98,0x86a47e7f,0x789b98d7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0x00000000,0x00000000],
    ct:  [0x9b58dbfd,0x77fe5aca,0x9cfc190c,0xd1b82d19] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0x80000000,0x00000000],
    ct:  [0x77f39208,0x9042e478,0xac16c0c8,0x6a0b5db5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xc0000000,0x00000000],
    ct:  [0x19f08e34,0x20ee69b4,0x77ca1420,0x281c4782] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xe0000000,0x00000000],
    ct:  [0xa1b19bee,0xe4e11713,0x9f74b3c5,0x3fdcb875] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xf0000000,0x00000000],
    ct:  [0xa37a5869,0xb218a9f3,0xa0868d19,0xaea0ad6a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xf8000000,0x00000000],
    ct:  [0xbc3594e8,0x65bcd026,0x1b132027,0x31f33580] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfc000000,0x00000000],
    ct:  [0x811441ce,0x1d309eee,0x7185e8c7,0x52c07557] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfe000000,0x00000000],
    ct:  [0x959971ce,0x41341905,0x63518e70,0x0b9874d1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xff000000,0x00000000],
    ct:  [0x76b5614a,0x042707c9,0x8e2132e2,0xe805fe63] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xff800000,0x00000000],
    ct:  [0x7d9fa6a5,0x7530d0f0,0x36fec31c,0x230b0cc6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffc00000,0x00000000],
    ct:  [0x964153a8,0x3bf6989a,0x4ba80daa,0x91c3e081] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffe00000,0x00000000],
    ct:  [0xa013014d,0x4ce8054c,0xf2591d06,0xf6f2f176] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfff00000,0x00000000],
    ct:  [0xd1c5f639,0x9bf38250,0x2e385eee,0x1474a869] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfff80000,0x00000000],
    ct:  [0x0007e20b,0x8298ec35,0x4f0f5fe7,0x470f36bd] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffc0000,0x00000000],
    ct:  [0xb95ba05b,0x332da61e,0xf63a2b31,0xfcad9879] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffe0000,0x00000000],
    ct:  [0x4620a49b,0xd9674915,0x61669ab2,0x5dce45f4] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffff0000,0x00000000],
    ct:  [0x12e71214,0xae8e04f0,0xbb63d742,0x5c6f14d5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffff8000,0x00000000],
    ct:  [0x4cc42fc1,0x407b008f,0xe350907c,0x092e80ac] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffc000,0x00000000],
    ct:  [0x08b244ce,0x7cbc8ee9,0x7fbba808,0xcb146fda] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffe000,0x00000000],
    ct:  [0x39b333e8,0x694f2154,0x6ad1edd9,0xd87ed95b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffff000,0x00000000],
    ct:  [0x3b271f8a,0xb2e6e4a2,0x0ba8090f,0x43ba78f3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffff800,0x00000000],
    ct:  [0x9ad983f3,0xbf651cd0,0x393f0a73,0xcccdea50] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffc00,0x00000000],
    ct:  [0x8f476cbf,0xf75c1f72,0x5ce18e4b,0xbcd19b32] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffe00,0x00000000],
    ct:  [0x905b6267,0xf1d6ab53,0x20835a13,0x3f096f2a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffff00,0x00000000],
    ct:  [0x145b60d6,0xd0193c23,0xf4221848,0xa892d61a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffff80,0x00000000],
    ct:  [0x55cfb3fb,0x6d75cad0,0x445bbc8d,0xafa25b0f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffc0,0x00000000],
    ct:  [0x7b8e7098,0xe357ef71,0x237d46d8,0xb075b0f5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffe0,0x00000000],
    ct:  [0x2bf27229,0x901eb40f,0x2df9d839,0x8d1505ae] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffff0,0x00000000],
    ct:  [0x83a63402,0xa77f9ad5,0xc1e931a9,0x31ecd706] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffff8,0x00000000],
    ct:  [0x6f8ba652,0x1152d31f,0x2bada184,0x3e26b973] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffffc,0x00000000],
    ct:  [0xe5c3b8e3,0x0fd2d8e6,0x239b17b4,0x4bd23bbd] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffffe,0x00000000],
    ct:  [0x1ac1f710,0x2c59933e,0x8b2ddc3f,0x14e94baa] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0x00000000],
    ct:  [0x21d9ba49,0xf276b45f,0x11af8fc7,0x1a088e3d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0x80000000],
    ct:  [0x649f1cdd,0xc3792b46,0x38635a39,0x2bc9bade] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xc0000000],
    ct:  [0xe2775e4b,0x59c1bc2e,0x31a2078c,0x11b5a08c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xe0000000],
    ct:  [0x2be1fae5,0x048a2558,0x2a679ca1,0x0905eb80] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xf0000000],
    ct:  [0xda86f292,0xc6f41ea3,0x4fb2068d,0xf75ecc29] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xf8000000],
    ct:  [0x220df19f,0x85d69b1b,0x562fa69a,0x3c5beca5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfc000000],
    ct:  [0x1f11d5d0,0x355e0b55,0x6ccdb6c7,0xf5083b4d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfe000000],
    ct:  [0x62526b78,0xbe79cb38,0x4633c91f,0x83b4151b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xff000000],
    ct:  [0x90ddbcb9,0x50843592,0xdd47bbef,0x00fdc876] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xff800000],
    ct:  [0x2fd0e41c,0x5b840227,0x7354a739,0x1d2618e2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffc00000],
    ct:  [0x3cdf13e7,0x2dee4c58,0x1bafec70,0xb85f9660] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffe00000],
    ct:  [0xafa2ffc1,0x37577092,0xe2b654fa,0x199d2c43] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfff00000],
    ct:  [0x8d683ee6,0x3e60d208,0xe343ce48,0xdbc44cac] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfff80000],
    ct:  [0x705a4ef8,0xba213372,0x9c20185c,0x3d3a4763] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffc0000],
    ct:  [0x0861a861,0xc3db4e94,0x194211b7,0x7ed761b9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffe0000],
    ct:  [0x4b00c27e,0x8b26da7e,0xab9d3a88,0xdec8b031] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffff0000],
    ct:  [0x5f397bf0,0x3084820c,0xc8810d52,0xe5b666e9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffff8000],
    ct:  [0x63fafabb,0x72c07bfb,0xd3ddc9b1,0x203104b8] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffc000],
    ct:  [0x683e2140,0x585b1845,0x2dd4ffbb,0x93c95df9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffe000],
    ct:  [0x286894e4,0x8e537f87,0x63b56707,0xd7d155c8] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffff000],
    ct:  [0xa423deab,0xc173dcf7,0xe2c4c53e,0x77d37cd1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffff800],
    ct:  [0xeb816831,0x3e1cfdfd,0xb5e986d5,0x429cf172] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffc00],
    ct:  [0x27127daa,0xfc9accd2,0xfb334ec3,0xeba52323] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffe00],
    ct:  [0xee0715b9,0x6f72e3f7,0xa22a5064,0xfc592f4c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffff00],
    ct:  [0x29ee5267,0x70f2a11d,0xcfa989d1,0xce88830f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffff80],
    ct:  [0x0493370e,0x054b0987,0x1130fe49,0xaf730a5a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffc0],
    ct:  [0x9b7b940f,0x6c509f9e,0x44a4ee14,0x0448ee46] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffe0],
    ct:  [0x2915be4a,0x1ecfdcbe,0x3e023811,0xa12bb6c7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffff0],
    ct:  [0x7240e524,0xbc51d8c4,0xd440b1be,0x55d1062c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffff8],
    ct:  [0xda63039d,0x38cb4612,0xb2dc36ba,0x26684b93] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffffc],
    ct:  [0x0f59cb5a,0x4b522e2a,0xc56c1a64,0xf558ad9a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffffe],
    ct:  [0x7bfe9d87,0x6c6d63c1,0xd035da8f,0xe21c409d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffff],
    ct:  [0xacdace80,0x78a32b1a,0x182bfa49,0x87ca1347] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x80000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xddc6bf79,0x0c15760d,0x8d9aeb6f,0x9a75fd4e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xc0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0a6bdc6d,0x4c1e6280,0x301fd8e9,0x7ddbe601] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xe0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9b80eefb,0x7ebe2d2b,0x16247aa0,0xefc72f5d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xf0000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7f2c5ece,0x07a98d8b,0xee13c511,0x77395ff7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xf8000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7818d800,0xdcf6f4be,0x1e0e94f4,0x03d1e4c2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfc000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe74cd1c9,0x2f0919c3,0x5a032412,0x3d6177d3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfe000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8092a4dc,0xf2da7e77,0xe93bdd37,0x1dfed82e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xff000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x49af6b37,0x2135acef,0x10132e54,0x8f217b17] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xff800000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8bcd40f9,0x4ebb63b9,0xf7909676,0xe667f1e7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffc00000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfe1cffb8,0x3f45dcfb,0x38b29be4,0x38dbd3ab] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffe00000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0dc58a8d,0x88662370,0x5aec15cb,0x1e70dc0e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfff00000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc218faa1,0x6056bd07,0x74c3e8d7,0x9c35a5e4] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfff80000,0x00000000,0x00000000,0x00000000],
    ct:  [0x047bba83,0xf7aa8417,0x31504e01,0x2208fc9e] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffc0000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdc8f0e49,0x15fd81ba,0x70a33131,0x0882f6da] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffe0000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1569859e,0xa6b7206c,0x30bf4fd0,0xcbfac33c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffff0000,0x00000000,0x00000000,0x00000000],
    ct:  [0x300ade92,0xf88f48fa,0x2df730ec,0x16ef44cd] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffff8000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1fe6cc3c,0x05965dc0,0x8eb0590c,0x95ac71d0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffc000,0x00000000,0x00000000,0x00000000],
    ct:  [0x59e858ea,0xaa97fec3,0x8111275b,0x6cf5abc0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffe000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2239455e,0x7afe3b06,0x16100288,0xcc5a723b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffff000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3ee500c5,0xc8d63479,0x717163e5,0x5c5c4522] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffff800,0x00000000,0x00000000,0x00000000],
    ct:  [0xd5e38bf1,0x5f16d90e,0x3e214041,0xd774daa8] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffc00,0x00000000,0x00000000,0x00000000],
    ct:  [0xb1f4066e,0x6f4f187d,0xfe5f2ad1,0xb17819d0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffe00,0x00000000,0x00000000,0x00000000],
    ct:  [0x6ef4cc4d,0xe49b1106,0x5d7af290,0x9854794a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffff00,0x00000000,0x00000000,0x00000000],
    ct:  [0xac86bc60,0x6b6640c3,0x09e782f2,0x32bf367f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffff80,0x00000000,0x00000000,0x00000000],
    ct:  [0x36aff0ef,0x7bf32807,0x72cf4cac,0x80a0d2b2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffc0,0x00000000,0x00000000,0x00000000],
    ct:  [0x1f8eedea,0x0f62a140,0x6d58cfc3,0xecea72cf] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffe0,0x00000000,0x00000000,0x00000000],
    ct:  [0xabf4154a,0x3375a1d3,0xe6b1d454,0x438f95a6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffff0,0x00000000,0x00000000,0x00000000],
    ct:  [0x96f96e9d,0x607f6615,0xfc192061,0xee648b07] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffff8,0x00000000,0x00000000,0x00000000],
    ct:  [0xcf37cdaa,0xa0d2d536,0xc7185763,0x4c792064] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffffc,0x00000000,0x00000000,0x00000000],
    ct:  [0xfbd6640c,0x80245c2b,0x805373f1,0x30703127] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xfffffffe,0x00000000,0x00000000,0x00000000],
    ct:  [0x8d6a8afe,0x55a6e481,0xbadae0d1,0x46f436db] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0x00000000,0x00000000,0x00000000],
    ct:  [0x6a4981f2,0x915e3e68,0xaf6c2238,0x5dd06756] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0x80000000,0x00000000,0x00000000],
    ct:  [0x42a1136e,0x5f8d8d21,0xd3101998,0x642d573b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xc0000000,0x00000000,0x00000000],
    ct:  [0x9b471596,0xdc69ae15,0x86cee615,0x8b0b0181] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xe0000000,0x00000000,0x00000000],
    ct:  [0x753665c4,0xaf1eff33,0xaa8b628b,0xf8741cfd] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xf0000000,0x00000000,0x00000000],
    ct:  [0x9a682acf,0x40be01f5,0xb2a4193c,0x9a82404d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xf8000000,0x00000000,0x00000000],
    ct:  [0x54fafe26,0xe4287f17,0xd1935f87,0xeb9ade01] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfc000000,0x00000000,0x00000000],
    ct:  [0x49d541b2,0xe74cfe73,0xe6a8e822,0x5f7bd449] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfe000000,0x00000000,0x00000000],
    ct:  [0x11a45530,0xf624ff6f,0x76a1b382,0x6626ff7b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xff000000,0x00000000,0x00000000],
    ct:  [0xf96b0c4a,0x8bc6c861,0x30289f60,0xb43b8fba] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xff800000,0x00000000,0x00000000],
    ct:  [0x48c7d0e8,0x0834ebdc,0x35b6735f,0x76b46c8b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffc00000,0x00000000,0x00000000],
    ct:  [0x2463531a,0xb54d6695,0x5e73edc4,0xcb8eaa45] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffe00000,0x00000000,0x00000000],
    ct:  [0xac9bd8e2,0x53046913,0x4b9d5b06,0x5d4f565b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfff00000,0x00000000,0x00000000],
    ct:  [0x3f5f9106,0xd0e52f97,0x3d4890e6,0xf37e8a00] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfff80000,0x00000000,0x00000000],
    ct:  [0x20ebc86f,0x1304d272,0xe2e207e5,0x9db639f0] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffc0000,0x00000000,0x00000000],
    ct:  [0xe67ae642,0x6bf9526c,0x972cff07,0x2b52252c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffe0000,0x00000000,0x00000000],
    ct:  [0x1a518ddd,0xaf9efa0d,0x002cc58d,0x107edfc8] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffff0000,0x00000000,0x00000000],
    ct:  [0xead731af,0x4d3a2fe3,0xb34bed04,0x7942a49f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffff8000,0x00000000,0x00000000],
    ct:  [0xb1d4efe4,0x0242f83e,0x93b6c8d7,0xefb5eae9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffc000,0x00000000,0x00000000],
    ct:  [0xcd2b1fec,0x11fd906c,0x5c763009,0x9443610a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffe000,0x00000000,0x00000000],
    ct:  [0xa1853fe4,0x7fe29289,0xd153161d,0x06387d21] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffff000,0x00000000,0x00000000],
    ct:  [0x46321541,0x79a555c1,0x7ea604d0,0x889fab14] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffff800,0x00000000,0x00000000],
    ct:  [0xdd27cac6,0x401a022e,0x8f38f9f9,0x3e774417] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffc00,0x00000000,0x00000000],
    ct:  [0xc090313e,0xb98674f3,0x5f312338,0x5fb95d4d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffe00,0x00000000,0x00000000],
    ct:  [0xcc352626,0x2b92f02e,0xdce548f7,0x16b9f45c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffff00,0x00000000,0x00000000],
    ct:  [0xc0838d1a,0x2b16a7c7,0xf0dfcc43,0x3c399c33] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffff80,0x00000000,0x00000000],
    ct:  [0x0d9ac756,0xeb297695,0xeed4d382,0xeb126d26] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffc0,0x00000000,0x00000000],
    ct:  [0x56ede9dd,0xa3f6f141,0xbff1757f,0xa689c3e1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffe0,0x00000000,0x00000000],
    ct:  [0x768f520e,0xfe0f23e6,0x1d3ec8ad,0x9ce91774] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffff0,0x00000000,0x00000000],
    ct:  [0xb1144ddf,0xa7575521,0x3390e7c5,0x96660490] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffff8,0x00000000,0x00000000],
    ct:  [0x1d7c0c40,0x40b355b9,0xd107a993,0x25e3b050] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffffc,0x00000000,0x00000000],
    ct:  [0xd8e2bb1a,0xe8ee3dcf,0x5bf7d6c3,0x8da82a1a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xfffffffe,0x00000000,0x00000000],
    ct:  [0xfaf82d17,0x8af25a98,0x86a47e7f,0x789b98d7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0x00000000,0x00000000],
    ct:  [0x9b58dbfd,0x77fe5aca,0x9cfc190c,0xd1b82d19] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0x80000000,0x00000000],
    ct:  [0x77f39208,0x9042e478,0xac16c0c8,0x6a0b5db5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xc0000000,0x00000000],
    ct:  [0x19f08e34,0x20ee69b4,0x77ca1420,0x281c4782] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xe0000000,0x00000000],
    ct:  [0xa1b19bee,0xe4e11713,0x9f74b3c5,0x3fdcb875] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xf0000000,0x00000000],
    ct:  [0xa37a5869,0xb218a9f3,0xa0868d19,0xaea0ad6a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xf8000000,0x00000000],
    ct:  [0xbc3594e8,0x65bcd026,0x1b132027,0x31f33580] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfc000000,0x00000000],
    ct:  [0x811441ce,0x1d309eee,0x7185e8c7,0x52c07557] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfe000000,0x00000000],
    ct:  [0x959971ce,0x41341905,0x63518e70,0x0b9874d1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xff000000,0x00000000],
    ct:  [0x76b5614a,0x042707c9,0x8e2132e2,0xe805fe63] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xff800000,0x00000000],
    ct:  [0x7d9fa6a5,0x7530d0f0,0x36fec31c,0x230b0cc6] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffc00000,0x00000000],
    ct:  [0x964153a8,0x3bf6989a,0x4ba80daa,0x91c3e081] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffe00000,0x00000000],
    ct:  [0xa013014d,0x4ce8054c,0xf2591d06,0xf6f2f176] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfff00000,0x00000000],
    ct:  [0xd1c5f639,0x9bf38250,0x2e385eee,0x1474a869] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfff80000,0x00000000],
    ct:  [0x0007e20b,0x8298ec35,0x4f0f5fe7,0x470f36bd] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffc0000,0x00000000],
    ct:  [0xb95ba05b,0x332da61e,0xf63a2b31,0xfcad9879] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffe0000,0x00000000],
    ct:  [0x4620a49b,0xd9674915,0x61669ab2,0x5dce45f4] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffff0000,0x00000000],
    ct:  [0x12e71214,0xae8e04f0,0xbb63d742,0x5c6f14d5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffff8000,0x00000000],
    ct:  [0x4cc42fc1,0x407b008f,0xe350907c,0x092e80ac] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffc000,0x00000000],
    ct:  [0x08b244ce,0x7cbc8ee9,0x7fbba808,0xcb146fda] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffe000,0x00000000],
    ct:  [0x39b333e8,0x694f2154,0x6ad1edd9,0xd87ed95b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffff000,0x00000000],
    ct:  [0x3b271f8a,0xb2e6e4a2,0x0ba8090f,0x43ba78f3] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffff800,0x00000000],
    ct:  [0x9ad983f3,0xbf651cd0,0x393f0a73,0xcccdea50] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffc00,0x00000000],
    ct:  [0x8f476cbf,0xf75c1f72,0x5ce18e4b,0xbcd19b32] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffe00,0x00000000],
    ct:  [0x905b6267,0xf1d6ab53,0x20835a13,0x3f096f2a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffff00,0x00000000],
    ct:  [0x145b60d6,0xd0193c23,0xf4221848,0xa892d61a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffff80,0x00000000],
    ct:  [0x55cfb3fb,0x6d75cad0,0x445bbc8d,0xafa25b0f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffc0,0x00000000],
    ct:  [0x7b8e7098,0xe357ef71,0x237d46d8,0xb075b0f5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffe0,0x00000000],
    ct:  [0x2bf27229,0x901eb40f,0x2df9d839,0x8d1505ae] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffff0,0x00000000],
    ct:  [0x83a63402,0xa77f9ad5,0xc1e931a9,0x31ecd706] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffff8,0x00000000],
    ct:  [0x6f8ba652,0x1152d31f,0x2bada184,0x3e26b973] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffffc,0x00000000],
    ct:  [0xe5c3b8e3,0x0fd2d8e6,0x239b17b4,0x4bd23bbd] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xfffffffe,0x00000000],
    ct:  [0x1ac1f710,0x2c59933e,0x8b2ddc3f,0x14e94baa] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0x00000000],
    ct:  [0x21d9ba49,0xf276b45f,0x11af8fc7,0x1a088e3d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0x80000000],
    ct:  [0x649f1cdd,0xc3792b46,0x38635a39,0x2bc9bade] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xc0000000],
    ct:  [0xe2775e4b,0x59c1bc2e,0x31a2078c,0x11b5a08c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xe0000000],
    ct:  [0x2be1fae5,0x048a2558,0x2a679ca1,0x0905eb80] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xf0000000],
    ct:  [0xda86f292,0xc6f41ea3,0x4fb2068d,0xf75ecc29] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xf8000000],
    ct:  [0x220df19f,0x85d69b1b,0x562fa69a,0x3c5beca5] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfc000000],
    ct:  [0x1f11d5d0,0x355e0b55,0x6ccdb6c7,0xf5083b4d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfe000000],
    ct:  [0x62526b78,0xbe79cb38,0x4633c91f,0x83b4151b] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xff000000],
    ct:  [0x90ddbcb9,0x50843592,0xdd47bbef,0x00fdc876] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xff800000],
    ct:  [0x2fd0e41c,0x5b840227,0x7354a739,0x1d2618e2] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffc00000],
    ct:  [0x3cdf13e7,0x2dee4c58,0x1bafec70,0xb85f9660] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffe00000],
    ct:  [0xafa2ffc1,0x37577092,0xe2b654fa,0x199d2c43] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfff00000],
    ct:  [0x8d683ee6,0x3e60d208,0xe343ce48,0xdbc44cac] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfff80000],
    ct:  [0x705a4ef8,0xba213372,0x9c20185c,0x3d3a4763] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffc0000],
    ct:  [0x0861a861,0xc3db4e94,0x194211b7,0x7ed761b9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffe0000],
    ct:  [0x4b00c27e,0x8b26da7e,0xab9d3a88,0xdec8b031] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffff0000],
    ct:  [0x5f397bf0,0x3084820c,0xc8810d52,0xe5b666e9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffff8000],
    ct:  [0x63fafabb,0x72c07bfb,0xd3ddc9b1,0x203104b8] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffc000],
    ct:  [0x683e2140,0x585b1845,0x2dd4ffbb,0x93c95df9] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffe000],
    ct:  [0x286894e4,0x8e537f87,0x63b56707,0xd7d155c8] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffff000],
    ct:  [0xa423deab,0xc173dcf7,0xe2c4c53e,0x77d37cd1] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffff800],
    ct:  [0xeb816831,0x3e1cfdfd,0xb5e986d5,0x429cf172] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffc00],
    ct:  [0x27127daa,0xfc9accd2,0xfb334ec3,0xeba52323] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffe00],
    ct:  [0xee0715b9,0x6f72e3f7,0xa22a5064,0xfc592f4c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffff00],
    ct:  [0x29ee5267,0x70f2a11d,0xcfa989d1,0xce88830f] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffff80],
    ct:  [0x0493370e,0x054b0987,0x1130fe49,0xaf730a5a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffc0],
    ct:  [0x9b7b940f,0x6c509f9e,0x44a4ee14,0x0448ee46] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffe0],
    ct:  [0x2915be4a,0x1ecfdcbe,0x3e023811,0xa12bb6c7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffff0],
    ct:  [0x7240e524,0xbc51d8c4,0xd440b1be,0x55d1062c] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffff8],
    ct:  [0xda63039d,0x38cb4612,0xb2dc36ba,0x26684b93] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffffc],
    ct:  [0x0f59cb5a,0x4b522e2a,0xc56c1a64,0xf558ad9a] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xfffffffe],
    ct:  [0x7bfe9d87,0x6c6d63c1,0xd035da8f,0xe21c409d] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0xffffffff,0xffffffff,0xffffffff,0xffffffff],
    ct:  [0xacdace80,0x78a32b1a,0x182bfa49,0x87ca1347] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x014730f8,0x0ac625fe,0x84f026c6,0x0bfd547d],
    ct:  [0x5c9d844e,0xd46f9885,0x085e5d6a,0x4f94c7d7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x0b24af36,0x193ce466,0x5f2825d7,0xb4749c98],
    ct:  [0xa9ff75bd,0x7cf6613d,0x3731c77c,0x3b6d0c04] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x761c1fe4,0x1a18acf2,0x0d241650,0x611d90f1],
    ct:  [0x623a52fc,0xea5d443e,0x48d9181a,0xb32c7421] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x8a560769,0xd605868a,0xd80d819b,0xdba03771],
    ct:  [0x38f2c7ae,0x10612415,0xd27ca190,0xd27da8b4] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x91fbef2d,0x15a97816,0x060bee1f,0xeaa49afe],
    ct:  [0x1bc704f1,0xbce135ce,0xb810341b,0x216d7abe] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x014730f8,0x0ac625fe,0x84f026c6,0x0bfd547d],
    ct:  [0x5c9d844e,0xd46f9885,0x085e5d6a,0x4f94c7d7] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x0b24af36,0x193ce466,0x5f2825d7,0xb4749c98],
    ct:  [0xa9ff75bd,0x7cf6613d,0x3731c77c,0x3b6d0c04] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x761c1fe4,0x1a18acf2,0x0d241650,0x611d90f1],
    ct:  [0x623a52fc,0xea5d443e,0x48d9181a,0xb32c7421] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x8a560769,0xd605868a,0xd80d819b,0xdba03771],
    ct:  [0x38f2c7ae,0x10612415,0xd27ca190,0xd27da8b4] },
  { key: [0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x91fbef2d,0x15a97816,0x060bee1f,0xeaa49afe],
    ct:  [0x1bc704f1,0xbce135ce,0xb810341b,0x216d7abe] },
  { key: [0xc47b0294,0xdbbbee0f,0xec4757f2,0x2ffeee35,0x87ca4730,0xc3d33b69,0x1df38bab,0x076bc558],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x46f2fb34,0x2d6f0ab4,0x77476fc5,0x01242c5f] },
  { key: [0x28d46cff,0xa1585331,0x94214a91,0xe712fc2b,0x45b51807,0x6675affd,0x910edeca,0x5f41ac64],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4bf3b0a6,0x9aeb6657,0x794f2901,0xb1440ad4] },
  { key: [0xc1cc358b,0x449909a1,0x9436cfbb,0x3f852ef8,0xbcb5ed12,0xac705832,0x5f56e609,0x9aab1a1c],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x35206527,0x2169abf9,0x85684392,0x7d0674fd] },
  { key: [0x984ca75f,0x4ee8d706,0xf46c2d98,0xc0bf4a45,0xf5b00d79,0x1c2dfeb1,0x91b5ed8e,0x420fd627],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4307456a,0x9e67813b,0x452e15fa,0x8fffe398] },
  { key: [0xb43d08a4,0x47ac8609,0xbaadae4f,0xf12918b9,0xf68fc165,0x3f126922,0x2f123981,0xded7a92f],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x46634466,0x07354989,0x477a5c6f,0x0f007ef4] },
  { key: [0x1d85a181,0xb54cde51,0xf0e09809,0x5b2962fd,0xc93b51fe,0x9b88602b,0x3f54130b,0xf76a5bd9],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x531c2c38,0x344578b8,0x4d50b3c9,0x17bbb6e1] },
  { key: [0xdc0eba1f,0x2232a787,0x9ded34ed,0x8428eeb8,0x769b056b,0xbaf8ad77,0xcb65c354,0x1430b4cf],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfc6aec90,0x63234800,0x05c58e7e,0x1ab004ad] },
  { key: [0xf8be9ba6,0x15c5a952,0xcabbca24,0xf68f8593,0x039624d5,0x24c816ac,0xda2c9183,0xbd917cb9],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa3944b95,0xca0b5204,0x3584ef02,0x151926a8] },
  { key: [0x797f8b3d,0x176dac5b,0x7e34a2d5,0x39c4ef36,0x7a16f863,0x5f626473,0x7591c5c0,0x7bf57a3e],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa74289fe,0x73a4c123,0xca189ea1,0xe1b49ad5] },
  { key: [0x6838d40c,0xaf927749,0xc13f0329,0xd331f448,0xe202c73e,0xf52c5f73,0xa37ca635,0xd4c47707],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb91d4ea4,0x488644b5,0x6cf0812f,0xa7fcf5fc] },
  { key: [0xccd1bc3c,0x659cd3c5,0x9bc43748,0x4e3c5c72,0x4441da8d,0x6e90ce55,0x6cd57d07,0x52663bbc],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x304f81ab,0x61a80c2e,0x743b94d5,0x002a126b] },
  { key: [0x13428b5e,0x4c005e06,0x36dd3384,0x05d173ab,0x135dec2a,0x25c22c5d,0xf0722d69,0xdcc43887],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x649a7154,0x5378c783,0xe368c9ad,0xe7114f6c] },
  { key: [0x07eb03a0,0x8d291d1b,0x07408bf3,0x512ab40c,0x91097ac7,0x7461aad4,0xbb859647,0xf74f00ee],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x47cb030d,0xa2ab051d,0xfc6c4bf6,0x910d12bb] },
  { key: [0x90143ae2,0x0cd78c5d,0x8ebdd6cb,0x9dc17624,0x27a96c78,0xc639bccc,0x41a61424,0x564eafe1],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x798c7c00,0x5dee432b,0x2c8ea5df,0xa381ecc3] },
  { key: [0xb7a5794d,0x52737475,0xd53d5a37,0x7200849b,0xe0260a67,0xa2b22ced,0x8bbef128,0x82270d07],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x637c31dc,0x2591a076,0x36f646b7,0x2daabbe7] },
  { key: [0xfca02f3d,0x5011cfc5,0xc1e23165,0xd413a049,0xd4526a99,0x1827424d,0x896fe343,0x5e0bf68e],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x179a49c7,0x12154bbf,0xfbe6e7a8,0x4a18e220] },
  { key: [0xc47b0294,0xdbbbee0f,0xec4757f2,0x2ffeee35,0x87ca4730,0xc3d33b69,0x1df38bab,0x076bc558],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x46f2fb34,0x2d6f0ab4,0x77476fc5,0x01242c5f] },
  { key: [0x28d46cff,0xa1585331,0x94214a91,0xe712fc2b,0x45b51807,0x6675affd,0x910edeca,0x5f41ac64],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4bf3b0a6,0x9aeb6657,0x794f2901,0xb1440ad4] },
  { key: [0xc1cc358b,0x449909a1,0x9436cfbb,0x3f852ef8,0xbcb5ed12,0xac705832,0x5f56e609,0x9aab1a1c],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x35206527,0x2169abf9,0x85684392,0x7d0674fd] },
  { key: [0x984ca75f,0x4ee8d706,0xf46c2d98,0xc0bf4a45,0xf5b00d79,0x1c2dfeb1,0x91b5ed8e,0x420fd627],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4307456a,0x9e67813b,0x452e15fa,0x8fffe398] },
  { key: [0xb43d08a4,0x47ac8609,0xbaadae4f,0xf12918b9,0xf68fc165,0x3f126922,0x2f123981,0xded7a92f],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x46634466,0x07354989,0x477a5c6f,0x0f007ef4] },
  { key: [0x1d85a181,0xb54cde51,0xf0e09809,0x5b2962fd,0xc93b51fe,0x9b88602b,0x3f54130b,0xf76a5bd9],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x531c2c38,0x344578b8,0x4d50b3c9,0x17bbb6e1] },
  { key: [0xdc0eba1f,0x2232a787,0x9ded34ed,0x8428eeb8,0x769b056b,0xbaf8ad77,0xcb65c354,0x1430b4cf],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfc6aec90,0x63234800,0x05c58e7e,0x1ab004ad] },
  { key: [0xf8be9ba6,0x15c5a952,0xcabbca24,0xf68f8593,0x039624d5,0x24c816ac,0xda2c9183,0xbd917cb9],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa3944b95,0xca0b5204,0x3584ef02,0x151926a8] },
  { key: [0x797f8b3d,0x176dac5b,0x7e34a2d5,0x39c4ef36,0x7a16f863,0x5f626473,0x7591c5c0,0x7bf57a3e],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa74289fe,0x73a4c123,0xca189ea1,0xe1b49ad5] },
  { key: [0x6838d40c,0xaf927749,0xc13f0329,0xd331f448,0xe202c73e,0xf52c5f73,0xa37ca635,0xd4c47707],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb91d4ea4,0x488644b5,0x6cf0812f,0xa7fcf5fc] },
  { key: [0xccd1bc3c,0x659cd3c5,0x9bc43748,0x4e3c5c72,0x4441da8d,0x6e90ce55,0x6cd57d07,0x52663bbc],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x304f81ab,0x61a80c2e,0x743b94d5,0x002a126b] },
  { key: [0x13428b5e,0x4c005e06,0x36dd3384,0x05d173ab,0x135dec2a,0x25c22c5d,0xf0722d69,0xdcc43887],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x649a7154,0x5378c783,0xe368c9ad,0xe7114f6c] },
  { key: [0x07eb03a0,0x8d291d1b,0x07408bf3,0x512ab40c,0x91097ac7,0x7461aad4,0xbb859647,0xf74f00ee],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x47cb030d,0xa2ab051d,0xfc6c4bf6,0x910d12bb] },
  { key: [0x90143ae2,0x0cd78c5d,0x8ebdd6cb,0x9dc17624,0x27a96c78,0xc639bccc,0x41a61424,0x564eafe1],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x798c7c00,0x5dee432b,0x2c8ea5df,0xa381ecc3] },
  { key: [0xb7a5794d,0x52737475,0xd53d5a37,0x7200849b,0xe0260a67,0xa2b22ced,0x8bbef128,0x82270d07],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x637c31dc,0x2591a076,0x36f646b7,0x2daabbe7] },
  { key: [0xfca02f3d,0x5011cfc5,0xc1e23165,0xd413a049,0xd4526a99,0x1827424d,0x896fe343,0x5e0bf68e],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x179a49c7,0x12154bbf,0xfbe6e7a8,0x4a18e220] },
  { key: [0x80000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe35a6dcb,0x19b201a0,0x1ebcfa8a,0xa22b5759] },
  { key: [0xc0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb29169cd,0xcf2d83e8,0x38125a12,0xee6aa400] },
  { key: [0xe0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd8f3a72f,0xc3cdf74d,0xfaf6c3e6,0xb97b2fa6] },
  { key: [0xf0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1c777679,0xd50037c7,0x9491a94d,0xa76a9a35] },
  { key: [0xf8000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9cf4893e,0xcafa0a02,0x47a898e0,0x40691559] },
  { key: [0xfc000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8fbb4137,0x03735326,0x310a269b,0xd3aa94b2] },
  { key: [0xfe000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x60e32246,0xbed2b0e8,0x59e55c1c,0xc6b26502] },
  { key: [0xff000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xec52a212,0xf80a09df,0x6317021b,0xc2a9819e] },
  { key: [0xff800000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf23e5b60,0x0eb70dbc,0xcf6c0b1d,0x9a68182c] },
  { key: [0xffc00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa3f599d6,0x3a82a968,0xc33fe265,0x90745970] },
  { key: [0xffe00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd1ccb9b1,0x337002cb,0xac42c520,0xb5d67722] },
  { key: [0xfff00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcc111f6c,0x37cf40a1,0x159d00fb,0x59fb0488] },
  { key: [0xfff80000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdc43b51a,0xb6090523,0x72989a26,0xe9cdd714] },
  { key: [0xfffc0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4dcede8d,0xa9e2578f,0x39703d44,0x33dc6459] },
  { key: [0xfffe0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1a4c1c26,0x3bbccfaf,0xc1178289,0x4685e3a8] },
  { key: [0xffff0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x937ad848,0x80db5061,0x3423d6d5,0x27a2823d] },
  { key: [0xffff8000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x610b71df,0xc688e150,0xd8152c5b,0x35ebc14d] },
  { key: [0xffffc000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x27ef2495,0xdabf3238,0x85aab39c,0x80f18d8b] },
  { key: [0xffffe000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x633cafea,0x395bc03a,0xdae3a1e2,0x068e4b4e] },
  { key: [0xfffff000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6e1b482b,0x53761cf6,0x31819b74,0x9a6f3724] },
  { key: [0xfffff800,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x976e6f85,0x1ab52c77,0x1998dbb2,0xd71c75a9] },
  { key: [0xfffffc00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x85f2ba84,0xf8c307cf,0x525e124c,0x3e22e6cc] },
  { key: [0xfffffe00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6bcca98b,0xf6a835fa,0x64955f72,0xde4115fe] },
  { key: [0xffffff00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2c75e2d3,0x6eebd654,0x11f14fd0,0xeb1d2a06] },
  { key: [0xffffff80,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbd492950,0x06250ffc,0xa5100b60,0x07a0eade] },
  { key: [0xffffffc0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa190527d,0x0ef7c70f,0x459cd394,0x0df316ec] },
  { key: [0xffffffe0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbbd1097a,0x62433f79,0x449fa97d,0x4ee80dbf] },
  { key: [0xfffffff0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x07058e40,0x8f5b99b0,0xe0f061a1,0x761b5b3b] },
  { key: [0xfffffff8,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5fd1f13f,0xa0f31e37,0xfabde328,0xf894eac2] },
  { key: [0xfffffffc,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfc4af7c9,0x48df26e2,0xef3e01c1,0xee5b8f6f] },
  { key: [0xfffffffe,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x829fd720,0x8fb92d44,0xa074a677,0xee9861ac] },
  { key: [0xffffffff,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xad9fc613,0xa703251b,0x54c64a0e,0x76431711] },
  { key: [0xffffffff,0x80000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x33ac9ecc,0xc4cc75e2,0x711618f8,0x0b1548e8] },
  { key: [0xffffffff,0xc0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2025c74b,0x8ad8f4cd,0xa17ee204,0x9c4c902d] },
  { key: [0xffffffff,0xe0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf85ca05f,0xe528f1ce,0x9b790166,0xe8d551e7] },
  { key: [0xffffffff,0xf0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6f6238d8,0x966048d4,0x967154e0,0xdad5a6c9] },
  { key: [0xffffffff,0xf8000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf2b21b4e,0x7640a9b3,0x346de8b8,0x2fb41e49] },
  { key: [0xffffffff,0xfc000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf836f251,0xad1d11d4,0x9dc34462,0x8b1884e1] },
  { key: [0xffffffff,0xfe000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x077e9470,0xae7abea5,0xa9769d49,0x182628c3] },
  { key: [0xffffffff,0xff000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe0dcc2d2,0x7fc98656,0x33f85223,0xcf0d611f] },
  { key: [0xffffffff,0xff800000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbe66cfea,0x2fecd6bf,0x0ec7b435,0x2c99bcaa] },
  { key: [0xffffffff,0xffc00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdf31144f,0x87a2ef52,0x3facdcf2,0x1a427804] },
  { key: [0xffffffff,0xffe00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb5bb0f56,0x29fb6aae,0x5e1839a3,0xc3625d63] },
  { key: [0xffffffff,0xfff00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3c9db333,0x5306fe1e,0xc612bdbf,0xae6b6028] },
  { key: [0xffffffff,0xfff80000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3dd5c346,0x34a79d3c,0xfcc83397,0x60e6f5f4] },
  { key: [0xffffffff,0xfffc0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x82bda118,0xa3ed7af3,0x14fa2ccc,0x5c07b761] },
  { key: [0xffffffff,0xfffe0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2937a64f,0x7d4f46fe,0x6fea3b34,0x9ec78e38] },
  { key: [0xffffffff,0xffff0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x225f068c,0x28476605,0x735ad671,0xbb8f39f3] },
  { key: [0xffffffff,0xffff8000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xae682c5e,0xcd71898e,0x08942ac9,0xaa89875c] },
  { key: [0xffffffff,0xffffc000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5e031cb9,0xd676c302,0x2d7f2622,0x7e85c38f] },
  { key: [0xffffffff,0xffffe000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa78463fb,0x064db5d5,0x2bb64bfe,0xf64f2dda] },
  { key: [0xffffffff,0xfffff000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8aa9b75e,0x78459387,0x6c53a00e,0xae5af52b] },
  { key: [0xffffffff,0xfffff800,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3f84566d,0xf23da48a,0xf692722f,0xe980573a] },
  { key: [0xffffffff,0xfffffc00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x31690b5e,0xd41c7eb4,0x2a1e8327,0x0a7ff0e6] },
  { key: [0xffffffff,0xfffffe00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x77dd7702,0x646d55f0,0x8365e477,0xd3590eda] },
  { key: [0xffffffff,0xffffff00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4c022ac6,0x2b3cb78d,0x739cc67b,0x3e20bb7e] },
  { key: [0xffffffff,0xffffff80,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x092fa137,0xce18b5df,0xe7906f55,0x0bb13370] },
  { key: [0xffffffff,0xffffffc0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3e0cdadf,0x2e68353c,0x0027672c,0x97144dd3] },
  { key: [0xffffffff,0xffffffe0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd8c4b200,0xb383fc1f,0x2b2ea677,0x618a1d27] },
  { key: [0xffffffff,0xfffffff0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x11825f99,0xb0e9bb34,0x77c1c071,0x3b015aac] },
  { key: [0xffffffff,0xfffffff8,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf8b9fffb,0x5c187f7d,0xdc7ab10f,0x4fb77576] },
  { key: [0xffffffff,0xfffffffc,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xffb4e87a,0x32b37d6f,0x2c8328d3,0xb5377802] },
  { key: [0xffffffff,0xfffffffe,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd276c13a,0x5d220f4d,0xa9224e74,0x896391ce] },
  { key: [0xffffffff,0xffffffff,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x94efe7a0,0xe2e031e2,0x536da01d,0xf799c927] },
  { key: [0xffffffff,0xffffffff,0x80000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8f8fd822,0x680a8597,0x4e53a5a8,0xeb9d38de] },
  { key: [0xffffffff,0xffffffff,0xc0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe0f0a91b,0x2e45f8cc,0x37b7805a,0x3042588d] },
  { key: [0xffffffff,0xffffffff,0xe0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x597a6252,0x255e46d6,0x364dbeed,0xa31e279c] },
  { key: [0xffffffff,0xffffffff,0xf0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf51a0f69,0x4442b8f0,0x5571797f,0xec7ee8bf] },
  { key: [0xffffffff,0xffffffff,0xf8000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9ff071b1,0x65b5198a,0x93dddeeb,0xc54d09b5] },
  { key: [0xffffffff,0xffffffff,0xfc000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc20a19fd,0x5758b0c4,0xbc1a5df8,0x9cf73877] },
  { key: [0xffffffff,0xffffffff,0xfe000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x97120166,0x307119ca,0x2280e931,0x5668e96f] },
  { key: [0xffffffff,0xffffffff,0xff000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4b3b9f1e,0x099c2a09,0xdc091e90,0xe4f18f0a] },
  { key: [0xffffffff,0xffffffff,0xff800000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xeb040b89,0x1d4b37f6,0x851f7ec2,0x19cd3f6d] },
  { key: [0xffffffff,0xffffffff,0xffc00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9f0fdec0,0x8b7fd79a,0xa39535be,0xa42db92a] },
  { key: [0xffffffff,0xffffffff,0xffe00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2e70f168,0xfc74bf91,0x1df240bc,0xd2cef236] },
  { key: [0xffffffff,0xffffffff,0xfff00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x462ccd7f,0x5fd1108d,0xbc152f3c,0xacad328b] },
  { key: [0xffffffff,0xffffffff,0xfff80000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa4af534a,0x7d0b643a,0x01868785,0xd86dfb95] },
  { key: [0xffffffff,0xffffffff,0xfffc0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xab980296,0x197e1a50,0x22326c31,0xda4bf6f3] },
  { key: [0xffffffff,0xffffffff,0xfffe0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf97d57b3,0x333b6281,0xb07d486d,0xb2d4e20c] },
  { key: [0xffffffff,0xffffffff,0xffff0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf33fa367,0x20231afe,0x4c759ade,0x6bd62eb6] },
  { key: [0xffffffff,0xffffffff,0xffff8000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfdcfac0c,0x02ca5383,0x43c68117,0xe0a15938] },
  { key: [0xffffffff,0xffffffff,0xffffc000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xad4916f5,0xee5772be,0x764fc027,0xb8a6e539] },
  { key: [0xffffffff,0xffffffff,0xffffe000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2e16873e,0x1678610d,0x7e14c02d,0x002ea845] },
  { key: [0xffffffff,0xffffffff,0xfffff000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4e6e627c,0x1acc5134,0x0053a823,0x6d579576] },
  { key: [0xffffffff,0xffffffff,0xfffff800,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xab0c8410,0xaeeead92,0xfeec1eb4,0x30d652cb] },
  { key: [0xffffffff,0xffffffff,0xfffffc00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe86f7e23,0xe835e114,0x977f60e1,0xa592202e] },
  { key: [0xffffffff,0xffffffff,0xfffffe00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe68ad505,0x5a367041,0xfade09d9,0xa70a794b] },
  { key: [0xffffffff,0xffffffff,0xffffff00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0791823a,0x3c666bb6,0x162825e7,0x8606a7fe] },
  { key: [0xffffffff,0xffffffff,0xffffff80,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdcca366a,0x9bf47b7b,0x868b77e2,0x5c18a364] },
  { key: [0xffffffff,0xffffffff,0xffffffc0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x684c9efc,0x237e4a44,0x2965f84b,0xce20247a] },
  { key: [0xffffffff,0xffffffff,0xffffffe0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa858411f,0xfbe63fdb,0x9c8aa1bf,0xaed67b52] },
  { key: [0xffffffff,0xffffffff,0xfffffff0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x04bc3da2,0x179c3015,0x498b0e03,0x910db5b8] },
  { key: [0xffffffff,0xffffffff,0xfffffff8,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x40071eea,0xb3f935db,0xc25d0084,0x1460260f] },
  { key: [0xffffffff,0xffffffff,0xfffffffc,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0ebd7c30,0xed2016e0,0x8ba806dd,0xb008bcc8] },
  { key: [0xffffffff,0xffffffff,0xfffffffe,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x15c6becf,0x0f4cec71,0x29cbd22d,0x1a79b1b8] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0aeede5b,0x91f72170,0x0e9e62ed,0xbf60b781] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0x80000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x266581af,0x0dcfbed1,0x585e0a24,0x2c64b8df] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xc0000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6693dc91,0x1662ae47,0x3216ba22,0x189a511a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xe0000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7606fa36,0xd86473e6,0xfb3a1bb0,0xe2c0adf5] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xf0000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x112078e9,0xe11fbb78,0xe26ffb88,0x99e96b9a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xf8000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x40b264e9,0x21e9e4a8,0x2694589e,0xf3798262] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfc000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8d4595cb,0x4fa70267,0x15f55bd6,0x8e2882f9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfe000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb588a302,0xbdbc0919,0x7df1edae,0x68926ed9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xff000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x33f75023,0x90b8a4a2,0x21cfecd0,0x666624ba] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xff800000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3d20253a,0xdbce3be2,0x373767c4,0xd822c566] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffc00000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa42734a3,0x929bf84c,0xf0116c98,0x56a3c18c] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffe00000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe3abc493,0x9457422b,0xb957da3c,0x56938c6d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfff00000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x972bdd2e,0x7c525130,0xfadc8f76,0xfc6f4b3f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfff80000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x84a83d7b,0x94c699cb,0xcb8a7d9b,0x61f64093] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffc0000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xce61d635,0x14aded03,0xd43e6ebf,0xc3a9001f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffe0000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6c839dd5,0x8eeae6b8,0xa36af48e,0xd63d2dc9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffff0000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcd5ece55,0xb8da3bf6,0x22c4100d,0xf5de46f9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffff8000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3b6f46f4,0x0e0ac5fc,0x0a9c1105,0xf800f48d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffc000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xba26d47d,0xa3aeb028,0xde4fb5b3,0xa854a24b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffe000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x87f53bf6,0x20d36772,0x68445212,0x904389d5] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffff000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x10617d28,0xb5e0f460,0x5492b182,0xa5d7f9f6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffff800,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9aaec4fa,0xbbf6fae2,0xa71feff0,0x2e372b39] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffc00,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3a90c62d,0x88b5c428,0x09abf782,0x488ed130] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffe00,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf1f1c5a4,0x0899e157,0x72857ccb,0x65c7a09a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffff00,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x190843d2,0x9b25a389,0x7c692ce1,0xdd81ee52] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffff80,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa866bc65,0xb6941d86,0xe8420a7f,0xfb0964db] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffc0,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8193c6ff,0x85225ced,0x4255e92f,0x6e078a14] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffe0,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9661cb24,0x24d7d4a3,0x80d547f9,0xe7ec1cb9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffff0,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x86f93d9e,0xc08453a0,0x71e2e287,0x7877a9c8] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffff8,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x27eefa80,0xce6a4a9d,0x598e3fec,0x365434d2] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffffc,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd6206844,0x4578e3ab,0x39ce7ec9,0x5dd045dc] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffffe,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb5f71d4d,0xd9a71fe5,0xd8bc8ba7,0xe6ea3048] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6825a347,0xac479d4f,0x9d95c5cb,0x8d3fd7e9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x80000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe3714e94,0xa5778955,0xcc034635,0x8e94783a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xc0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd836b44b,0xb29e0c7d,0x89fa4b2d,0x4b677d2a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xe0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5d454b75,0x021d76d4,0xb84f873a,0x8f877b92] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc3498f7e,0xced20953,0x14fc2811,0x5885b33f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf8000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6e668856,0x539ad8e4,0x05bd123f,0xe6c88530] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfc000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8680db7f,0x3a87b860,0x5543cfdb,0xe6754076] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfe000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6c5d03b1,0x3069c365,0x8b3179be,0x91b0800c] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xef1b384a,0xc4d93eda,0x00c92add,0x0995ea5f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff800000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbf811580,0x5471741b,0xd5ad20a0,0x3944790f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffc00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc64c24b6,0x894b038b,0x3c0d09b1,0xdf068b0b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffe00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3967a10c,0xffe27d01,0x78545fbf,0x6a40544b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7c85e9c9,0x5de1a9ec,0x5a5363a8,0xa053472d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff80000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa9eec03c,0x8abec7ba,0x68315c2c,0x8c2316e0] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffc0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcac8e414,0xc2f38822,0x7ae14986,0xfc983524] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffe0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5d942b7f,0x4622ce05,0x6c3ce3ce,0x5f1dd9d6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd240d648,0xce21a302,0x0282c3f1,0xb528a0b6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff8000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x45d089c3,0x6d5c5a4e,0xfc689e3b,0x0de10dd5] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffc000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb4da5df4,0xbecb5462,0xe03a0ed0,0x0d295629] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffe000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdcf4e129,0x136c1a4b,0x7a0f3893,0x5cc34b2b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd9a4c761,0x8b0ce48a,0x3d5aee1a,0x1c0114c4] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff800,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xca352df0,0x25c65c7b,0x0bf306fb,0xee0f36ba] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffc00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x238aca23,0xfd3409f3,0x8af63378,0xed2f5473] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffe00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x59836a0e,0x06a79691,0xb36667d5,0x380d8188] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x33905080,0xf7acf1cd,0xae0a91fc,0x3e85aee4] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff80,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x72c9e464,0x6dbc3d63,0x20fc6689,0xd93e8833] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffc0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xba77413d,0xea5925b7,0xf5417ea4,0x7ff19f59] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffe0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6cae8129,0xf843d86d,0xc786a0fb,0x1a184970] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfcfefb53,0x4100796e,0xebbd9902,0x06754e19] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff8,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8c791d5f,0xdddf470d,0xa04f3e6d,0xc4a5b5b5] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffc,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc93bbdc0,0x7a4611ae,0x4bb266ea,0x5034a387] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffe,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc102e38e,0x489aa747,0x62f3efc5,0xbb23205a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x93201481,0x665cbafc,0x1fcc220b,0xc545fb3d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x80000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4960757e,0xc6ce68cf,0x195e454c,0xfd0f32ca] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xc0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfeec7ce6,0xa6cbd07c,0x04341673,0x7f1bbb33] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xe0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x11c54139,0x04487a80,0x5d70a8ed,0xd9c35527] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x347846b2,0xb2e36f1f,0x0324c86f,0x7f1b98e2] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf8000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x332eee1a,0x0cbd19ca,0x2d69b426,0x894044f0] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfc000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x866b5b39,0x77ba6efa,0x5128efbd,0xa9ff03cd] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfe000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcc1445ee,0x94c0f08c,0xdee5c344,0xecd1e233] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbe288319,0x029363c2,0x622feba4,0xb05dfdfe] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff800000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcfd18755,0x23f3cd21,0xc395651e,0x6ee15e56] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffc00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcb5a4086,0x57837c53,0xbf16f9d8,0x465dce19] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffe00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xca0bf42c,0xb107f55c,0xcff2fc09,0xee08ca15] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfdd9bbb4,0xa7dc2e4a,0x23536a58,0x80a2db67] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff80000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xede447b3,0x62c48499,0x3dec9442,0xa3b46aef] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffc0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x10dffb05,0x904bff7c,0x4781df78,0x0ad26837] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffe0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc33bc13e,0x8de88ac2,0x5232aa74,0x96398783] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xca359c70,0x803a3b2a,0x3d542e87,0x81dea975] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff8000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbcc65b52,0x6f88d05b,0x89ce8a52,0x021fdb06] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffc000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdb91a388,0x55c8c464,0x3851fbfb,0x358b0109] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffe000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xca6e8893,0xa114ae8e,0x27d5ab03,0xa5499610] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6629d2b8,0xdf97da72,0x8cdd8b1e,0x7f945077] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff800,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4570a5a1,0x8cfc0dd5,0x82f1d88d,0x5c9a1720] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffc00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x72bc65aa,0x8e89562e,0x3f274d45,0xaf1cd10b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffe00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x98551da1,0xa6503276,0xae1c7762,0x5f9ea615] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0ddfe51c,0xed7e3f4a,0xe927daa3,0xfe452cee] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff80,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdb826251,0xe4ce384b,0x80218b0e,0x1da1dd4c] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffc0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2cacf728,0xb88abbad,0x7011ed0e,0x64a1680c] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffe0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x330d8ee7,0xc5677e09,0x9ac74c99,0x94ee4cfb] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xedf61ae3,0x62e882dd,0xc0167474,0xa7a77f3a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff8,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6168b00b,0xa7859e09,0x70ecfd75,0x7efecf7c] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffc,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd1415447,0x866230d2,0x8bb1ea18,0xa4cdfd02] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffe,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x51618339,0x2f7a8763,0xafec68a0,0x60264141] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x77565c8d,0x73cfd413,0x0b4aa14d,0x8911710f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x80000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x37232a4e,0xd21ccc27,0xc19c9610,0x078cabac] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xc0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x804f32ea,0x71828c7d,0x329077e7,0x12231666] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xe0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd64424f2,0x3cb97215,0xe9c2c6f2,0x8d29eab7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x023e82b5,0x33f68c75,0xc238cebd,0xb2ee89a2] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf8000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x193a3d24,0x157a51f1,0xee0893f6,0x777417e7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfc000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x84ecacfc,0xd400084d,0x078612b1,0x945f2ef5] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfe000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1dcd8bb1,0x73259eb3,0x3a5242b0,0xde31a455] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x35e9eddb,0xc375e792,0xc19992c1,0x9165012b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff800000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8a772231,0xc01dfdd7,0xc98e4cfd,0xdcc0807a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffc00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6eda7ff6,0xb8319180,0xff0d6e65,0x629d01c3] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffe00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc267ef0e,0x2d01a993,0x944dd397,0x101413cb] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe9f80e9d,0x845bcc0f,0x62926af7,0x2eabca39] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff80000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x67029907,0x27aa0878,0x637b45dc,0xd3a3b074] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffc0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2e2e647d,0x5360e092,0x30a5d738,0xca33471e] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffe0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1f56413c,0x7add6f43,0xd1d56e4f,0x02190330] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x69cd0606,0xe15af729,0xd6bca143,0x016d9842] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff8000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa085d7c1,0xa500873a,0x20099c4c,0xaa3c3f5b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffc000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4fc0d230,0xf8891415,0xb87b83f9,0x5f2e09d1] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffe000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4327d08c,0x523d8eba,0x697a4336,0x507d1f42] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7a15aab8,0x2701efa5,0xae36ab1d,0x6b76290f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff800,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5bf00518,0x93a18bb3,0x0e139a58,0xfed0fa54] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffc00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x97e8adf6,0x5638fd9c,0xdf3bc22c,0x17fe4dbd] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffe00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1ee6ee32,0x6583a058,0x6491c964,0x18d1a35d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x26b549c2,0xec756f82,0xecc48008,0xe529956b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff80,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x70377b6d,0xa669b072,0x129e057c,0xc28e9ca5] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffc0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9c94b8b0,0xcb8bcc91,0x9072262b,0x3fa05ad9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffe0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2fbb83df,0xd0d7abcb,0x05cd28ca,0xd2dfb523] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x96877803,0xde77744b,0xb970d0a9,0x1f4debae] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff8,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7379f337,0x0cf6e5ce,0x12ae5969,0xc8eea312] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffc,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x02dc99fa,0x3d4f98ce,0x80985e72,0x33889313] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffe,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1e38e759,0x075ba5ca,0xb6457da5,0x1844295a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x70bed8db,0xf615868a,0x1f9d9b05,0xd3e7a267] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x80000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x234b148b,0x8cb1d8c3,0x2b287e89,0x6903d150] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xc0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x294b033d,0xf4da853f,0x4be3e243,0xf7e513f4] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xe0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3f58c950,0xf0367160,0xadec45f2,0x441e7411] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x37f65553,0x6a704e5a,0xce182d74,0x2a820cf4] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf8000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xea7bd6bb,0x63418731,0xaeac790f,0xe42d61e8] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfc000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe74a4c99,0x9b4c064e,0x48bb1e41,0x3f51e5ea] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfe000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xba9ebefd,0xb4ccf30f,0x296cecb3,0xbc1943e8] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3194367a,0x4898c502,0xc13bb747,0x8640a72d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff800000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xda797713,0x263d6f33,0xa5478a65,0xef60d412] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffc00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd1ac39bb,0x1ef86b9c,0x1344f214,0x679aa376] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffe00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2fdea9e6,0x50532be5,0xbc0e7325,0x337fd363] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd3a204db,0xd9c2af15,0x8b6ca67a,0x5156ce4a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff80000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3a0a0e75,0xa8da3673,0x5aee6684,0xd965a778] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffc0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x52fc3e62,0x0492ea99,0x641ea168,0xda5b6d52] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffe0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd2e0c7f1,0x5b477246,0x7d2cfc87,0x3000b2ca] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x56353113,0x5e0c4d70,0xa38f8bdb,0x190ba04e] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff8000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa8a39a0f,0x5663f4c0,0xfe5f2d3c,0xafff421a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffc000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd94b5e90,0xdb354c1e,0x42f61fab,0xe167b2c0] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffe000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x50e6d3c9,0xb6698a7c,0xd276f96b,0x1473f35a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9338f08e,0x0ebee969,0x05d8f2e8,0x25208f43] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff800],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8b378c86,0x672aa54a,0x3a266ba1,0x9d2580ca] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffc00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcca7c308,0x6f5f9511,0xb31233da,0x7cab9160] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffe00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5b40ff4e,0xc9be536b,0xa23035fa,0x4f06064c] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x60eb5af8,0x416b2571,0x49372194,0xe8b88749] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff80],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2f005a8a,0xed8a361c,0x92e440c1,0x5520cbd1] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffc0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7b036276,0x11678a99,0x77175788,0x07a800e2] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffe0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcf78618f,0x74f6f369,0x6e0a4779,0xb90b5a77] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x03720371,0xa04962ea,0xea0a852e,0x69972858] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff8],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1f8a8133,0xaa8ccf70,0xe2bd3285,0x831ca6b7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffc],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x27936bd2,0x7fb1468f,0xc8b48bc4,0x83321725] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffe],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb07d4f3e,0x2cd2ef2e,0xb5459807,0x54dfea0f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4bf85f1b,0x5d54adbc,0x307b0a04,0x8389adcb] },
  { key: [0x80000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe35a6dcb,0x19b201a0,0x1ebcfa8a,0xa22b5759] },
  { key: [0xc0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb29169cd,0xcf2d83e8,0x38125a12,0xee6aa400] },
  { key: [0xe0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd8f3a72f,0xc3cdf74d,0xfaf6c3e6,0xb97b2fa6] },
  { key: [0xf0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1c777679,0xd50037c7,0x9491a94d,0xa76a9a35] },
  { key: [0xf8000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9cf4893e,0xcafa0a02,0x47a898e0,0x40691559] },
  { key: [0xfc000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8fbb4137,0x03735326,0x310a269b,0xd3aa94b2] },
  { key: [0xfe000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x60e32246,0xbed2b0e8,0x59e55c1c,0xc6b26502] },
  { key: [0xff000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xec52a212,0xf80a09df,0x6317021b,0xc2a9819e] },
  { key: [0xff800000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf23e5b60,0x0eb70dbc,0xcf6c0b1d,0x9a68182c] },
  { key: [0xffc00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa3f599d6,0x3a82a968,0xc33fe265,0x90745970] },
  { key: [0xffe00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd1ccb9b1,0x337002cb,0xac42c520,0xb5d67722] },
  { key: [0xfff00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcc111f6c,0x37cf40a1,0x159d00fb,0x59fb0488] },
  { key: [0xfff80000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdc43b51a,0xb6090523,0x72989a26,0xe9cdd714] },
  { key: [0xfffc0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4dcede8d,0xa9e2578f,0x39703d44,0x33dc6459] },
  { key: [0xfffe0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1a4c1c26,0x3bbccfaf,0xc1178289,0x4685e3a8] },
  { key: [0xffff0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x937ad848,0x80db5061,0x3423d6d5,0x27a2823d] },
  { key: [0xffff8000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x610b71df,0xc688e150,0xd8152c5b,0x35ebc14d] },
  { key: [0xffffc000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x27ef2495,0xdabf3238,0x85aab39c,0x80f18d8b] },
  { key: [0xffffe000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x633cafea,0x395bc03a,0xdae3a1e2,0x068e4b4e] },
  { key: [0xfffff000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6e1b482b,0x53761cf6,0x31819b74,0x9a6f3724] },
  { key: [0xfffff800,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x976e6f85,0x1ab52c77,0x1998dbb2,0xd71c75a9] },
  { key: [0xfffffc00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x85f2ba84,0xf8c307cf,0x525e124c,0x3e22e6cc] },
  { key: [0xfffffe00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6bcca98b,0xf6a835fa,0x64955f72,0xde4115fe] },
  { key: [0xffffff00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2c75e2d3,0x6eebd654,0x11f14fd0,0xeb1d2a06] },
  { key: [0xffffff80,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbd492950,0x06250ffc,0xa5100b60,0x07a0eade] },
  { key: [0xffffffc0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa190527d,0x0ef7c70f,0x459cd394,0x0df316ec] },
  { key: [0xffffffe0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbbd1097a,0x62433f79,0x449fa97d,0x4ee80dbf] },
  { key: [0xfffffff0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x07058e40,0x8f5b99b0,0xe0f061a1,0x761b5b3b] },
  { key: [0xfffffff8,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5fd1f13f,0xa0f31e37,0xfabde328,0xf894eac2] },
  { key: [0xfffffffc,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfc4af7c9,0x48df26e2,0xef3e01c1,0xee5b8f6f] },
  { key: [0xfffffffe,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x829fd720,0x8fb92d44,0xa074a677,0xee9861ac] },
  { key: [0xffffffff,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xad9fc613,0xa703251b,0x54c64a0e,0x76431711] },
  { key: [0xffffffff,0x80000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x33ac9ecc,0xc4cc75e2,0x711618f8,0x0b1548e8] },
  { key: [0xffffffff,0xc0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2025c74b,0x8ad8f4cd,0xa17ee204,0x9c4c902d] },
  { key: [0xffffffff,0xe0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf85ca05f,0xe528f1ce,0x9b790166,0xe8d551e7] },
  { key: [0xffffffff,0xf0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6f6238d8,0x966048d4,0x967154e0,0xdad5a6c9] },
  { key: [0xffffffff,0xf8000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf2b21b4e,0x7640a9b3,0x346de8b8,0x2fb41e49] },
  { key: [0xffffffff,0xfc000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf836f251,0xad1d11d4,0x9dc34462,0x8b1884e1] },
  { key: [0xffffffff,0xfe000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x077e9470,0xae7abea5,0xa9769d49,0x182628c3] },
  { key: [0xffffffff,0xff000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe0dcc2d2,0x7fc98656,0x33f85223,0xcf0d611f] },
  { key: [0xffffffff,0xff800000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbe66cfea,0x2fecd6bf,0x0ec7b435,0x2c99bcaa] },
  { key: [0xffffffff,0xffc00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdf31144f,0x87a2ef52,0x3facdcf2,0x1a427804] },
  { key: [0xffffffff,0xffe00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb5bb0f56,0x29fb6aae,0x5e1839a3,0xc3625d63] },
  { key: [0xffffffff,0xfff00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3c9db333,0x5306fe1e,0xc612bdbf,0xae6b6028] },
  { key: [0xffffffff,0xfff80000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3dd5c346,0x34a79d3c,0xfcc83397,0x60e6f5f4] },
  { key: [0xffffffff,0xfffc0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x82bda118,0xa3ed7af3,0x14fa2ccc,0x5c07b761] },
  { key: [0xffffffff,0xfffe0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2937a64f,0x7d4f46fe,0x6fea3b34,0x9ec78e38] },
  { key: [0xffffffff,0xffff0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x225f068c,0x28476605,0x735ad671,0xbb8f39f3] },
  { key: [0xffffffff,0xffff8000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xae682c5e,0xcd71898e,0x08942ac9,0xaa89875c] },
  { key: [0xffffffff,0xffffc000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5e031cb9,0xd676c302,0x2d7f2622,0x7e85c38f] },
  { key: [0xffffffff,0xffffe000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa78463fb,0x064db5d5,0x2bb64bfe,0xf64f2dda] },
  { key: [0xffffffff,0xfffff000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8aa9b75e,0x78459387,0x6c53a00e,0xae5af52b] },
  { key: [0xffffffff,0xfffff800,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3f84566d,0xf23da48a,0xf692722f,0xe980573a] },
  { key: [0xffffffff,0xfffffc00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x31690b5e,0xd41c7eb4,0x2a1e8327,0x0a7ff0e6] },
  { key: [0xffffffff,0xfffffe00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x77dd7702,0x646d55f0,0x8365e477,0xd3590eda] },
  { key: [0xffffffff,0xffffff00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4c022ac6,0x2b3cb78d,0x739cc67b,0x3e20bb7e] },
  { key: [0xffffffff,0xffffff80,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x092fa137,0xce18b5df,0xe7906f55,0x0bb13370] },
  { key: [0xffffffff,0xffffffc0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3e0cdadf,0x2e68353c,0x0027672c,0x97144dd3] },
  { key: [0xffffffff,0xffffffe0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd8c4b200,0xb383fc1f,0x2b2ea677,0x618a1d27] },
  { key: [0xffffffff,0xfffffff0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x11825f99,0xb0e9bb34,0x77c1c071,0x3b015aac] },
  { key: [0xffffffff,0xfffffff8,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf8b9fffb,0x5c187f7d,0xdc7ab10f,0x4fb77576] },
  { key: [0xffffffff,0xfffffffc,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xffb4e87a,0x32b37d6f,0x2c8328d3,0xb5377802] },
  { key: [0xffffffff,0xfffffffe,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd276c13a,0x5d220f4d,0xa9224e74,0x896391ce] },
  { key: [0xffffffff,0xffffffff,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x94efe7a0,0xe2e031e2,0x536da01d,0xf799c927] },
  { key: [0xffffffff,0xffffffff,0x80000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8f8fd822,0x680a8597,0x4e53a5a8,0xeb9d38de] },
  { key: [0xffffffff,0xffffffff,0xc0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe0f0a91b,0x2e45f8cc,0x37b7805a,0x3042588d] },
  { key: [0xffffffff,0xffffffff,0xe0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x597a6252,0x255e46d6,0x364dbeed,0xa31e279c] },
  { key: [0xffffffff,0xffffffff,0xf0000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf51a0f69,0x4442b8f0,0x5571797f,0xec7ee8bf] },
  { key: [0xffffffff,0xffffffff,0xf8000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9ff071b1,0x65b5198a,0x93dddeeb,0xc54d09b5] },
  { key: [0xffffffff,0xffffffff,0xfc000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc20a19fd,0x5758b0c4,0xbc1a5df8,0x9cf73877] },
  { key: [0xffffffff,0xffffffff,0xfe000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x97120166,0x307119ca,0x2280e931,0x5668e96f] },
  { key: [0xffffffff,0xffffffff,0xff000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4b3b9f1e,0x099c2a09,0xdc091e90,0xe4f18f0a] },
  { key: [0xffffffff,0xffffffff,0xff800000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xeb040b89,0x1d4b37f6,0x851f7ec2,0x19cd3f6d] },
  { key: [0xffffffff,0xffffffff,0xffc00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9f0fdec0,0x8b7fd79a,0xa39535be,0xa42db92a] },
  { key: [0xffffffff,0xffffffff,0xffe00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2e70f168,0xfc74bf91,0x1df240bc,0xd2cef236] },
  { key: [0xffffffff,0xffffffff,0xfff00000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x462ccd7f,0x5fd1108d,0xbc152f3c,0xacad328b] },
  { key: [0xffffffff,0xffffffff,0xfff80000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa4af534a,0x7d0b643a,0x01868785,0xd86dfb95] },
  { key: [0xffffffff,0xffffffff,0xfffc0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xab980296,0x197e1a50,0x22326c31,0xda4bf6f3] },
  { key: [0xffffffff,0xffffffff,0xfffe0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf97d57b3,0x333b6281,0xb07d486d,0xb2d4e20c] },
  { key: [0xffffffff,0xffffffff,0xffff0000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf33fa367,0x20231afe,0x4c759ade,0x6bd62eb6] },
  { key: [0xffffffff,0xffffffff,0xffff8000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfdcfac0c,0x02ca5383,0x43c68117,0xe0a15938] },
  { key: [0xffffffff,0xffffffff,0xffffc000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xad4916f5,0xee5772be,0x764fc027,0xb8a6e539] },
  { key: [0xffffffff,0xffffffff,0xffffe000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2e16873e,0x1678610d,0x7e14c02d,0x002ea845] },
  { key: [0xffffffff,0xffffffff,0xfffff000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4e6e627c,0x1acc5134,0x0053a823,0x6d579576] },
  { key: [0xffffffff,0xffffffff,0xfffff800,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xab0c8410,0xaeeead92,0xfeec1eb4,0x30d652cb] },
  { key: [0xffffffff,0xffffffff,0xfffffc00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe86f7e23,0xe835e114,0x977f60e1,0xa592202e] },
  { key: [0xffffffff,0xffffffff,0xfffffe00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe68ad505,0x5a367041,0xfade09d9,0xa70a794b] },
  { key: [0xffffffff,0xffffffff,0xffffff00,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0791823a,0x3c666bb6,0x162825e7,0x8606a7fe] },
  { key: [0xffffffff,0xffffffff,0xffffff80,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdcca366a,0x9bf47b7b,0x868b77e2,0x5c18a364] },
  { key: [0xffffffff,0xffffffff,0xffffffc0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x684c9efc,0x237e4a44,0x2965f84b,0xce20247a] },
  { key: [0xffffffff,0xffffffff,0xffffffe0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa858411f,0xfbe63fdb,0x9c8aa1bf,0xaed67b52] },
  { key: [0xffffffff,0xffffffff,0xfffffff0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x04bc3da2,0x179c3015,0x498b0e03,0x910db5b8] },
  { key: [0xffffffff,0xffffffff,0xfffffff8,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x40071eea,0xb3f935db,0xc25d0084,0x1460260f] },
  { key: [0xffffffff,0xffffffff,0xfffffffc,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0ebd7c30,0xed2016e0,0x8ba806dd,0xb008bcc8] },
  { key: [0xffffffff,0xffffffff,0xfffffffe,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x15c6becf,0x0f4cec71,0x29cbd22d,0x1a79b1b8] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0aeede5b,0x91f72170,0x0e9e62ed,0xbf60b781] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0x80000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x266581af,0x0dcfbed1,0x585e0a24,0x2c64b8df] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xc0000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6693dc91,0x1662ae47,0x3216ba22,0x189a511a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xe0000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7606fa36,0xd86473e6,0xfb3a1bb0,0xe2c0adf5] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xf0000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x112078e9,0xe11fbb78,0xe26ffb88,0x99e96b9a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xf8000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x40b264e9,0x21e9e4a8,0x2694589e,0xf3798262] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfc000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8d4595cb,0x4fa70267,0x15f55bd6,0x8e2882f9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfe000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb588a302,0xbdbc0919,0x7df1edae,0x68926ed9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xff000000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x33f75023,0x90b8a4a2,0x21cfecd0,0x666624ba] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xff800000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3d20253a,0xdbce3be2,0x373767c4,0xd822c566] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffc00000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa42734a3,0x929bf84c,0xf0116c98,0x56a3c18c] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffe00000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe3abc493,0x9457422b,0xb957da3c,0x56938c6d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfff00000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x972bdd2e,0x7c525130,0xfadc8f76,0xfc6f4b3f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfff80000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x84a83d7b,0x94c699cb,0xcb8a7d9b,0x61f64093] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffc0000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xce61d635,0x14aded03,0xd43e6ebf,0xc3a9001f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffe0000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6c839dd5,0x8eeae6b8,0xa36af48e,0xd63d2dc9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffff0000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcd5ece55,0xb8da3bf6,0x22c4100d,0xf5de46f9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffff8000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3b6f46f4,0x0e0ac5fc,0x0a9c1105,0xf800f48d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffc000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xba26d47d,0xa3aeb028,0xde4fb5b3,0xa854a24b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffe000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x87f53bf6,0x20d36772,0x68445212,0x904389d5] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffff000,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x10617d28,0xb5e0f460,0x5492b182,0xa5d7f9f6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffff800,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9aaec4fa,0xbbf6fae2,0xa71feff0,0x2e372b39] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffc00,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3a90c62d,0x88b5c428,0x09abf782,0x488ed130] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffe00,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xf1f1c5a4,0x0899e157,0x72857ccb,0x65c7a09a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffff00,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x190843d2,0x9b25a389,0x7c692ce1,0xdd81ee52] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffff80,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa866bc65,0xb6941d86,0xe8420a7f,0xfb0964db] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffc0,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8193c6ff,0x85225ced,0x4255e92f,0x6e078a14] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffe0,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9661cb24,0x24d7d4a3,0x80d547f9,0xe7ec1cb9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffff0,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x86f93d9e,0xc08453a0,0x71e2e287,0x7877a9c8] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffff8,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x27eefa80,0xce6a4a9d,0x598e3fec,0x365434d2] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffffc,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd6206844,0x4578e3ab,0x39ce7ec9,0x5dd045dc] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xfffffffe,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb5f71d4d,0xd9a71fe5,0xd8bc8ba7,0xe6ea3048] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x00000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6825a347,0xac479d4f,0x9d95c5cb,0x8d3fd7e9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x80000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe3714e94,0xa5778955,0xcc034635,0x8e94783a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xc0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd836b44b,0xb29e0c7d,0x89fa4b2d,0x4b677d2a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xe0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5d454b75,0x021d76d4,0xb84f873a,0x8f877b92] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf0000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc3498f7e,0xced20953,0x14fc2811,0x5885b33f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf8000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6e668856,0x539ad8e4,0x05bd123f,0xe6c88530] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfc000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8680db7f,0x3a87b860,0x5543cfdb,0xe6754076] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfe000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6c5d03b1,0x3069c365,0x8b3179be,0x91b0800c] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff000000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xef1b384a,0xc4d93eda,0x00c92add,0x0995ea5f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff800000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbf811580,0x5471741b,0xd5ad20a0,0x3944790f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffc00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc64c24b6,0x894b038b,0x3c0d09b1,0xdf068b0b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffe00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3967a10c,0xffe27d01,0x78545fbf,0x6a40544b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff00000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7c85e9c9,0x5de1a9ec,0x5a5363a8,0xa053472d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff80000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa9eec03c,0x8abec7ba,0x68315c2c,0x8c2316e0] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffc0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcac8e414,0xc2f38822,0x7ae14986,0xfc983524] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffe0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5d942b7f,0x4622ce05,0x6c3ce3ce,0x5f1dd9d6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd240d648,0xce21a302,0x0282c3f1,0xb528a0b6] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff8000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x45d089c3,0x6d5c5a4e,0xfc689e3b,0x0de10dd5] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffc000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb4da5df4,0xbecb5462,0xe03a0ed0,0x0d295629] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffe000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdcf4e129,0x136c1a4b,0x7a0f3893,0x5cc34b2b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff000,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd9a4c761,0x8b0ce48a,0x3d5aee1a,0x1c0114c4] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff800,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xca352df0,0x25c65c7b,0x0bf306fb,0xee0f36ba] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffc00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x238aca23,0xfd3409f3,0x8af63378,0xed2f5473] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffe00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x59836a0e,0x06a79691,0xb36667d5,0x380d8188] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff00,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x33905080,0xf7acf1cd,0xae0a91fc,0x3e85aee4] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff80,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x72c9e464,0x6dbc3d63,0x20fc6689,0xd93e8833] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffc0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xba77413d,0xea5925b7,0xf5417ea4,0x7ff19f59] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffe0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6cae8129,0xf843d86d,0xc786a0fb,0x1a184970] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff0,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfcfefb53,0x4100796e,0xebbd9902,0x06754e19] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff8,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8c791d5f,0xdddf470d,0xa04f3e6d,0xc4a5b5b5] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffc,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc93bbdc0,0x7a4611ae,0x4bb266ea,0x5034a387] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffe,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc102e38e,0x489aa747,0x62f3efc5,0xbb23205a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x00000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x93201481,0x665cbafc,0x1fcc220b,0xc545fb3d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x80000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4960757e,0xc6ce68cf,0x195e454c,0xfd0f32ca] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xc0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfeec7ce6,0xa6cbd07c,0x04341673,0x7f1bbb33] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xe0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x11c54139,0x04487a80,0x5d70a8ed,0xd9c35527] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf0000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x347846b2,0xb2e36f1f,0x0324c86f,0x7f1b98e2] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf8000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x332eee1a,0x0cbd19ca,0x2d69b426,0x894044f0] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfc000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x866b5b39,0x77ba6efa,0x5128efbd,0xa9ff03cd] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfe000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcc1445ee,0x94c0f08c,0xdee5c344,0xecd1e233] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff000000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbe288319,0x029363c2,0x622feba4,0xb05dfdfe] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff800000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcfd18755,0x23f3cd21,0xc395651e,0x6ee15e56] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffc00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcb5a4086,0x57837c53,0xbf16f9d8,0x465dce19] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffe00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xca0bf42c,0xb107f55c,0xcff2fc09,0xee08ca15] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff00000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xfdd9bbb4,0xa7dc2e4a,0x23536a58,0x80a2db67] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff80000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xede447b3,0x62c48499,0x3dec9442,0xa3b46aef] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffc0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x10dffb05,0x904bff7c,0x4781df78,0x0ad26837] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffe0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc33bc13e,0x8de88ac2,0x5232aa74,0x96398783] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xca359c70,0x803a3b2a,0x3d542e87,0x81dea975] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff8000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xbcc65b52,0x6f88d05b,0x89ce8a52,0x021fdb06] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffc000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdb91a388,0x55c8c464,0x3851fbfb,0x358b0109] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffe000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xca6e8893,0xa114ae8e,0x27d5ab03,0xa5499610] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff000,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6629d2b8,0xdf97da72,0x8cdd8b1e,0x7f945077] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff800,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4570a5a1,0x8cfc0dd5,0x82f1d88d,0x5c9a1720] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffc00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x72bc65aa,0x8e89562e,0x3f274d45,0xaf1cd10b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffe00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x98551da1,0xa6503276,0xae1c7762,0x5f9ea615] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff00,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x0ddfe51c,0xed7e3f4a,0xe927daa3,0xfe452cee] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff80,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xdb826251,0xe4ce384b,0x80218b0e,0x1da1dd4c] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffc0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2cacf728,0xb88abbad,0x7011ed0e,0x64a1680c] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffe0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x330d8ee7,0xc5677e09,0x9ac74c99,0x94ee4cfb] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff0,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xedf61ae3,0x62e882dd,0xc0167474,0xa7a77f3a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff8,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6168b00b,0xa7859e09,0x70ecfd75,0x7efecf7c] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffc,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd1415447,0x866230d2,0x8bb1ea18,0xa4cdfd02] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffe,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x51618339,0x2f7a8763,0xafec68a0,0x60264141] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x00000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x77565c8d,0x73cfd413,0x0b4aa14d,0x8911710f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x80000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x37232a4e,0xd21ccc27,0xc19c9610,0x078cabac] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xc0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x804f32ea,0x71828c7d,0x329077e7,0x12231666] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xe0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd64424f2,0x3cb97215,0xe9c2c6f2,0x8d29eab7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf0000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x023e82b5,0x33f68c75,0xc238cebd,0xb2ee89a2] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf8000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x193a3d24,0x157a51f1,0xee0893f6,0x777417e7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfc000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x84ecacfc,0xd400084d,0x078612b1,0x945f2ef5] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfe000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1dcd8bb1,0x73259eb3,0x3a5242b0,0xde31a455] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff000000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x35e9eddb,0xc375e792,0xc19992c1,0x9165012b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff800000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8a772231,0xc01dfdd7,0xc98e4cfd,0xdcc0807a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffc00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x6eda7ff6,0xb8319180,0xff0d6e65,0x629d01c3] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffe00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xc267ef0e,0x2d01a993,0x944dd397,0x101413cb] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff00000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe9f80e9d,0x845bcc0f,0x62926af7,0x2eabca39] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff80000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x67029907,0x27aa0878,0x637b45dc,0xd3a3b074] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffc0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2e2e647d,0x5360e092,0x30a5d738,0xca33471e] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffe0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1f56413c,0x7add6f43,0xd1d56e4f,0x02190330] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x69cd0606,0xe15af729,0xd6bca143,0x016d9842] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff8000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa085d7c1,0xa500873a,0x20099c4c,0xaa3c3f5b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffc000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4fc0d230,0xf8891415,0xb87b83f9,0x5f2e09d1] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffe000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4327d08c,0x523d8eba,0x697a4336,0x507d1f42] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff000,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7a15aab8,0x2701efa5,0xae36ab1d,0x6b76290f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff800,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5bf00518,0x93a18bb3,0x0e139a58,0xfed0fa54] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffc00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x97e8adf6,0x5638fd9c,0xdf3bc22c,0x17fe4dbd] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffe00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1ee6ee32,0x6583a058,0x6491c964,0x18d1a35d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff00,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x26b549c2,0xec756f82,0xecc48008,0xe529956b] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff80,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x70377b6d,0xa669b072,0x129e057c,0xc28e9ca5] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffc0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9c94b8b0,0xcb8bcc91,0x9072262b,0x3fa05ad9] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffe0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2fbb83df,0xd0d7abcb,0x05cd28ca,0xd2dfb523] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff0,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x96877803,0xde77744b,0xb970d0a9,0x1f4debae] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff8,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7379f337,0x0cf6e5ce,0x12ae5969,0xc8eea312] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffc,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x02dc99fa,0x3d4f98ce,0x80985e72,0x33889313] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffe,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1e38e759,0x075ba5ca,0xb6457da5,0x1844295a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x00000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x70bed8db,0xf615868a,0x1f9d9b05,0xd3e7a267] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0x80000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x234b148b,0x8cb1d8c3,0x2b287e89,0x6903d150] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xc0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x294b033d,0xf4da853f,0x4be3e243,0xf7e513f4] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xe0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3f58c950,0xf0367160,0xadec45f2,0x441e7411] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf0000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x37f65553,0x6a704e5a,0xce182d74,0x2a820cf4] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xf8000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xea7bd6bb,0x63418731,0xaeac790f,0xe42d61e8] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfc000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xe74a4c99,0x9b4c064e,0x48bb1e41,0x3f51e5ea] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfe000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xba9ebefd,0xb4ccf30f,0x296cecb3,0xbc1943e8] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff000000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3194367a,0x4898c502,0xc13bb747,0x8640a72d] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xff800000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xda797713,0x263d6f33,0xa5478a65,0xef60d412] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffc00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd1ac39bb,0x1ef86b9c,0x1344f214,0x679aa376] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffe00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2fdea9e6,0x50532be5,0xbc0e7325,0x337fd363] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff00000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd3a204db,0xd9c2af15,0x8b6ca67a,0x5156ce4a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfff80000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x3a0a0e75,0xa8da3673,0x5aee6684,0xd965a778] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffc0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x52fc3e62,0x0492ea99,0x641ea168,0xda5b6d52] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffe0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd2e0c7f1,0x5b477246,0x7d2cfc87,0x3000b2ca] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff0000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x56353113,0x5e0c4d70,0xa38f8bdb,0x190ba04e] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffff8000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xa8a39a0f,0x5663f4c0,0xfe5f2d3c,0xafff421a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffc000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xd94b5e90,0xdb354c1e,0x42f61fab,0xe167b2c0] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffe000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x50e6d3c9,0xb6698a7c,0xd276f96b,0x1473f35a] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff000],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x9338f08e,0x0ebee969,0x05d8f2e8,0x25208f43] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffff800],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x8b378c86,0x672aa54a,0x3a266ba1,0x9d2580ca] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffc00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcca7c308,0x6f5f9511,0xb31233da,0x7cab9160] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffe00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x5b40ff4e,0xc9be536b,0xa23035fa,0x4f06064c] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff00],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x60eb5af8,0x416b2571,0x49372194,0xe8b88749] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffff80],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x2f005a8a,0xed8a361c,0x92e440c1,0x5520cbd1] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffc0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x7b036276,0x11678a99,0x77175788,0x07a800e2] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffe0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xcf78618f,0x74f6f369,0x6e0a4779,0xb90b5a77] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff0],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x03720371,0xa04962ea,0xea0a852e,0x69972858] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffff8],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x1f8a8133,0xaa8ccf70,0xe2bd3285,0x831ca6b7] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffc],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x27936bd2,0x7fb1468f,0xc8b48bc4,0x83321725] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xfffffffe],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0xb07d4f3e,0x2cd2ef2e,0xb5459807,0x54dfea0f] },
  { key: [0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff],
    pt:  [0x00000000,0x00000000,0x00000000,0x00000000],
    ct:  [0x4bf85f1b,0x5d54adbc,0x307b0a04,0x8389adcb] }
];


var _sunSpiderStartDate = new Date();

new sjcl.test.TestCase("AES official known-answer tests", function (cb) {
  if (!sjcl.cipher.aes) {
    this.unimplemented();
    cb && cb();
    return;
  }
  
  var i, kat = sjcl.test.vector.aes, tv, len, aes;

  //XXX add more vectors instead of looping
  for (var index = 0; index < 8; index++) {
      for (i=0; i<kat.length; i++) {
        tv = kat[i];
        len = 32 * tv.key.length;
        aes = new sjcl.cipher.aes(tv.key);
        this.require(sjcl.bitArray.equal(aes.encrypt(tv.pt), tv.ct), "encrypt "+len+" #"+i);
        this.require(sjcl.bitArray.equal(aes.decrypt(tv.ct), tv.pt), "decrypt "+len+" #"+i);
      }
  }
  cb && cb();
});

sjcl.test.run();


var _sunSpiderInterval = new Date() - _sunSpiderStartDate;

WScript.Echo("### TIME:", _sunSpiderInterval, "ms");
