// SPDX-License-Identifier: (GPL-2.0+ OR MIT)
/*
 * Copyright (c) 2021 Amlogic, Inc. All rights reserved.
 */

#include "demod_func.h"
#include "dvbs.h"

static unsigned int dvbs_iq_swap;
MODULE_PARM_DESC(dvbs_iq_swap, "\n\t\t dvbs IQ swap");
module_param(dvbs_iq_swap, int, 0644);

static struct stchip_register_t l2a_def_val_local[] = {
	{0x200,    0x8c},/* REG_RL2A_DVBSX_FSK_FSKTFC2 */
	{0x201,    0x45},/* REG_RL2A_DVBSX_FSK_FSKTFC1 */
	{0x202,    0xc9},/* REG_RL2A_DVBSX_FSK_FSKTFC0 */
	{0x203,    0x01},/* REG_RL2A_DVBSX_FSK_FSKTDELTAF1 */
	{0x204,    0x37},/* REG_RL2A_DVBSX_FSK_FSKTDELTAF0 */
	{0x205,    0x08},/* REG_RL2A_DVBSX_FSK_FSKTCTRL */
	{0x206,    0x10},/* REG_RL2A_DVBSX_FSK_FSKRFC2 */
	{0x207,    0x45},/* REG_RL2A_DVBSX_FSK_FSKRFC1 */
	{0x208,    0xc9},/* REG_RL2A_DVBSX_FSK_FSKRFC0 */
	{0x209,    0x38},/* REG_RL2A_DVBSX_FSK_FSKRK1 */
	{0x20a,    0x71},/* REG_RL2A_DVBSX_FSK_FSKRK2 */
	{0x20b,    0x28},/* REG_RL2A_DVBSX_FSK_FSKRAGCR */
	{0x20c,    0xff},/* REG_RL2A_DVBSX_FSK_FSKRAGC */
	{0x20d,    0x13},/* REG_RL2A_DVBSX_FSK_FSKRALPHA */
	{0x20e,    0x90},/* REG_RL2A_DVBSX_FSK_FSKRPLTH1 */
	{0x20f,    0xbe},/* REG_RL2A_DVBSX_FSK_FSKRPLTH0 */
	{0x210,    0x80},/* REG_RL2A_DVBSX_FSK_FSKRDF1 */
	{0x211,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRDF0 */
	{0x212,    0x58},/* REG_RL2A_DVBSX_FSK_FSKRSTEPP */
	{0x213,    0x6f},/* REG_RL2A_DVBSX_FSK_FSKRSTEPM */
	{0x214,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRDET1 */
	{0x215,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRDET0 */
	{0x216,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRDTH1 */
	{0x217,    0xe9},/* REG_RL2A_DVBSX_FSK_FSKRDTH0 */
	{0x218,    0x4d},/* REG_RL2A_DVBSX_FSK_FSKRLOSS */
	{0x219,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRLEAK */
	{0x21a,    0x2a},/* REG_RL2A_DVBSX_FSK_FSKRAGCTH */
	{0x21b,    0x16},/* REG_RL2A_DVBSX_FSK_FSKRFINIIR */
	{0x21c,    0x04},/* REG_RL2A_DVBSX_FSK_FSKRFBIT1 */
	{0x21d,    0xbc},/* REG_RL2A_DVBSX_FSK_FSKRFBIT0 */
	{0x21e,    0x3c},/* REG_RL2A_DVBSX_FSK_FSKRMINSTART */
	{0x21f,    0x8c},/* REG_RL2A_DVBSX_FSK_FSKRMAXSTART */
	{0x220,    0x1e},/* REG_RL2A_DVBSX_FSK_FSKRPEAKDIF */
	{0x221,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRMINPK */
	{0x222,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRMAXPK */
	{0x223,    0x0a},/* REG_RL2A_DVBSX_FSK_FSKRFWDWN */
	{0x224,    0x32},/* REG_RL2A_DVBSX_FSK_FSKRFWTH */
	{0x225,    0x50},/* REG_RL2A_DVBSX_FSK_FSKRINITDEV */
	{0x226,    0x37},/* REG_RL2A_DVBSX_FSK_FSKRMINDEV */
	{0x227,    0x78},/* REG_RL2A_DVBSX_FSK_FSKRMAXDEV */
	{0x228,    0x40},/* REG_RL2A_DVBSX_FSK_FSKRMAXTERR */
	{0x229,    0x28},/* REG_RL2A_DVBSX_FSK_FSKRKTMG */
	{0x22a,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRLOW */
	{0x22b,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRHIGH */
	{0x22c,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRWORDVAL3 */
	{0x22d,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRWORDVAL2 */
	{0x22e,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRWORDVAL1 */
	{0x22f,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRWORDVAL0 */
	{0x230,    0xff},/* REG_RL2A_DVBSX_FSK_FSKRWORDMSK3 */
	{0x231,    0xff},/* REG_RL2A_DVBSX_FSK_FSKRWORDMSK2 */
	{0x232,    0xff},/* REG_RL2A_DVBSX_FSK_FSKRWORDMSK1 */
	{0x233,    0xff},/* REG_RL2A_DVBSX_FSK_FSKRWORDMSK0 */
	{0x234,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRDELAYLG */
	{0x235,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRSTOPLG */
	{0x236,    0x00},/* REG_RL2A_DVBSX_FSK_FSKRMESLG */
	{0x237,    0x80},/* REG_RL2A_DVBSX_FSK_FSKRCFG */
	/*{0x300,    0x00},*//* REG_RL2A_DVBSX_DISEQC_DISIRQCFG */
	/*{0x301,    0x00},*//* REG_RL2A_DVBSX_DISEQC_DISIRQSTAT */
	/*{0x302,    0x00},*//* REG_RL2A_DVBSX_DISEQC_DISTXCFG */
	/*{0x303,    0x20},*//* REG_RL2A_DVBSX_DISEQC_DISTXSTATUS */
	/*{0x304,    0x00},*//* REG_RL2A_DVBSX_DISEQC_DISTXBYTES */
	/*{0x305,    0x00},*//* REG_RL2A_DVBSX_DISEQC_DISTXFIFO */
	/*{0x306,    0xc0},*//* REG_RL2A_DVBSX_DISEQC_DISTXF22 */
	/*{0x307,    0x00},*//* REG_RL2A_DVBSX_DISEQC_DISTXWAIT */
	//{0x308,    0x02},/* REG_RL2A_DVBSX_DISEQC_DISTIMEOCFG */
	{0x309,    0x8c},/* REG_RL2A_DVBSX_DISEQC_DISTIMEOUT */
	//{0x30a,    0x04},/* REG_RL2A_DVBSX_DISEQC_DISRXCFG */
	{0x30b,    0x04},/* REG_RL2A_DVBSX_DISEQC_DISRXSTAT1 */
	{0x30c,    0x00},/* REG_RL2A_DVBSX_DISEQC_DISRXSTAT0 */
	{0x30d,    0x00},/* REG_RL2A_DVBSX_DISEQC_DISRXBYTES */
	{0x30e,    0x00},/* REG_RL2A_DVBSX_DISEQC_DISRXPARITY1 */
	{0x30f,    0x00},/* REG_RL2A_DVBSX_DISEQC_DISRXPARITY0 */
	//{0x310,    0x00},/* REG_RL2A_DVBSX_DISEQC_DISRXFIFO */
	{0x311,    0x00},/* REG_RL2A_DVBSX_DISEQC_DISRXDC1 */
	{0x312,    0x00},/* REG_RL2A_DVBSX_DISEQC_DISRXDC0 */
	{0x313,    0x62},/* REG_RL2A_DVBSX_DISEQC_DISRXKOFF */
	{0x314,    0x01},/* REG_RL2A_DVBSX_DISEQC_DISRXF221 */
	//{0x315,    0x2b},/* REG_RL2A_DVBSX_DISEQC_DISRXF220 */
	//{0x316,    0xa9},/* REG_RL2A_DVBSX_DISEQC_DISRXF100 */
	{0x317,    0x31},/* REG_RL2A_DVBSX_DISEQC_DISRXK1 */
	{0x318,    0xb1},/* REG_RL2A_DVBSX_DISEQC_DISRXK2 */
	{0x319,    0xa8},/* REG_RL2A_DVBSX_DISEQC_DISRXPK */
	{0x31a,    0x46},/* REG_RL2A_DVBSX_DISEQC_DISRXENV */
	{0x31b,    0x0c},/* REG_RL2A_DVBSX_DISEQC_DISRXVMIN */
	{0x31c,    0x0f},/* REG_RL2A_DVBSX_DISEQC_DISRXSHORT22K */
	{0x31e,    0x01},/* REG_RL2A_DVBSX_DISEQC_ACRPRESC */
	{0x31f,    0x14},/* REG_RL2A_DVBSX_DISEQC_ACRDIV */
	{0x330,    0x00},/* REG_RL2A_DVBSX_DISEQCTST_DISTBUS */
	{0x331,    0x00},/* REG_RL2A_DVBSX_DISEQCTST_DISTSTCFG */
	{0x332,    0x55},/* REG_RL2A_DVBSX_DISEQCTST_DISPRBSEED */
	{0x333,    0x00},/* REG_RL2A_DVBSX_DISEQCTST_DISPRBSCNT1 */
	{0x334,    0x00},/* REG_RL2A_DVBSX_DISEQCTST_DISPRBSCNT0 */
	{0x335,    0x00},/* REG_RL2A_DVBSX_DISEQCTST_DISRXSPYERR1 */
	{0x336,    0x00},/* REG_RL2A_DVBSX_DISEQCTST_DISRXSPYERR0 */
	{0x337,    0x00},/* REG_RL2A_DVBSX_DISEQCTST_DISRXSPYCNT1 */
	{0x338,    0x00},/* REG_RL2A_DVBSX_DISEQCTST_DISRXSPYCNT0 */
	{0x339,    0x00},/* REG_RL2A_DVBSX_DISEQCTST_DISRXPEAKMEAN1 */
	{0x33a,    0x00},/* REG_RL2A_DVBSX_DISEQCTST_DISRXPEAKMEAN0 */
	{0x400,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF1 */
	{0x401,    0x1b},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF2 */
	{0x402,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF3 */
	{0x403,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF4 */
	{0x404,    0x14},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF5 */
	{0x405,    0x1b},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF6 */
	{0x406,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF7 */
	{0x407,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF8 */
	{0x408,    0x18},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF9 */
	{0x409,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF10 */
	{0x40a,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF11 */
	{0x40b,    0x14},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF12 */
	{0x40c,    0x1b},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF13 */
	{0x40d,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF14 */
	{0x40e,    0x18},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF15 */
	{0x40f,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF16 */
	{0x410,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF17 */
	{0x411,    0x1b},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF18 */
	{0x412,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF19 */
	{0x413,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF20 */
	{0x414,    0x18},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF21 */
	{0x415,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF22 */
	{0x416,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF23 */
	{0x417,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF24 */
	{0x418,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF25 */
	{0x419,    0x18},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF26 */
	{0x41a,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF27 */
	{0x41b,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF28 */
	{0x41c,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF1 */
	{0x41d,    0x1b},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF2 */
	{0x41e,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF3 */
	{0x41f,    0x1d},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF4 */
	{0x420,    0x14},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF5 */
	{0x421,    0x1b},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF6 */
	{0x422,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF7 */
	{0x423,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF8 */
	{0x424,    0x1d},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF9 */
	{0x425,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF10 */
	{0x426,    0x14},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF12 */
	{0x427,    0x1b},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF13 */
	{0x428,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF14 */
	{0x429,    0x1d},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF15 */
	{0x42a,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF16 */
	{0x42b,    0x1b},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF18 */
	{0x42c,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF19 */
	{0x42d,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF20 */
	{0x42e,    0x1d},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF21 */
	{0x42f,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF22 */
	{0x430,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF24 */
	{0x431,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF25 */
	{0x432,    0x1d},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF26 */
	{0x433,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF27 */
	{0x434,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF33_0 */
	{0x435,    0x17},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF33_1 */
	{0x436,    0x16},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF34_0 */
	{0x437,    0x16},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF34_1 */
	{0x438,    0x15},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF35_0 */
	{0x439,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF35_1 */
	{0x43a,    0x16},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF36_0 */
	{0x43b,    0x17},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF36_1 */
	{0x43c,    0x16},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF37_0 */
	{0x43d,    0x16},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF37_1 */
	{0x43e,    0x16},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF38_0 */
	{0x43f,    0x15},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF38_1 */
	{0x440,    0x14},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF39_0 */
	{0x441,    0x14},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF39_1 */
	{0x442,    0x17},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF40_0 */
	{0x443,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF40_1 */
	{0x444,    0x14},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF41_0 */
	{0x445,    0x16},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF41_1 */
	{0x446,    0x17},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF42_0 */
	{0x447,    0x14},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF42_1 */
	{0x448,    0x15},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF43_0 */
	{0x449,    0x1b},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF43_1 */
	{0x44a,    0x15},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF44_1 */
	{0x44b,    0x15},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF45_0 */
	{0x44c,    0x14},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF45_1 */
	{0x44d,    0x15},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF46_0 */
	{0x44e,    0x15},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF46_1 */
	{0x44f,    0x16},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF47_1 */
	{0x450,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF48_1 */
	{0x451,    0x18},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF49_1 */
	{0x452,    0x16},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF50_0 */
	{0x453,    0x14},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF50_1 */
	{0x454,    0x15},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF51_0 */
	{0x455,    0x14},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF51_1 */
	{0x456,    0x15},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF52_0 */
	{0x457,    0x15},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF52_1 */
	{0x458,    0x14},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF53_0 */
	{0x459,    0x16},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_NF53_1 */
	{0x45a,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF54_0 */
	{0x45b,    0x19},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF54_1 */
	{0x45c,    0x1a},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF55_0 */
	{0x45d,    0x13},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF55_1 */
	{0x45e,    0x13},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF56_0 */
	{0x45f,    0x18},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF56_1 */
	{0x460,    0x13},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF57_0 */
	{0x461,    0x13},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF57_1 */
	{0x462,    0x15},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF58_0 */
	{0x463,    0x18},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF58_1 */
	{0x464,    0x13},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF59_0 */
	{0x465,    0x13},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF59_1 */
	{0x466,    0x15},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF60_0 */
	{0x467,    0x14},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF60_1 */
	{0x468,    0x18},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF61_0 */
	{0x469,    0x1b},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF61_1 */
	{0x46a,    0x18},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITER_SF62_0 */
	{0x470,    0x02},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR13 */
	{0x471,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR12 */
	{0x472,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR11 */
	{0x473,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR10 */
	{0x474,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR9 */
	{0x475,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR8 */
	{0x476,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR7 */
	{0x477,    0x05},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR6 */
	{0x478,    0x5b},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR5 */
	{0x479,    0x96},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR4 */
	{0x47a,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR3 */
	{0x47b,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR2 */
	{0x47c,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR1 */
	{0x47d,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_SELSATUR0 */
	{0x480,    0x18},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF1 */
	{0x481,    0x1c},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF2 */
	{0x482,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF3 */
	{0x483,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF4 */
	{0x484,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF5 */
	{0x485,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF6 */
	{0x486,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF7 */
	{0x487,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF8 */
	{0x488,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF9 */
	{0x489,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF10 */
	{0x48a,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF11 */
	{0x48b,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF12 */
	{0x48c,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF13 */
	{0x48d,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF14 */
	{0x48e,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF15 */
	{0x48f,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF16 */
	{0x490,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF17 */
	{0x491,    0x24},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF18 */
	{0x492,    0x24},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF19 */
	{0x493,    0x26},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF20 */
	{0x494,    0x26},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF21 */
	{0x495,    0x27},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF22 */
	{0x496,    0x29},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF23 */
	{0x497,    0x40},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF24 */
	{0x498,    0x50},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF25 */
	{0x499,    0x60},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF26 */
	{0x49a,    0x70},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF27 */
	{0x49b,    0x70},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF28 */
	{0x49c,    0x1C},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF1 */
	{0x49d,    0x1C},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF2 */
	{0x49e,    0x1E},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF3 */
	{0x49f,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF4 */
	{0x4a0,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF5 */
	{0x4a1,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF6 */
	{0x4a2,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF7 */
	{0x4a3,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF8 */
	{0x4a4,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF9 */
	{0x4a5,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF10 */
	{0x4a6,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF12 */
	{0x4a7,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF13 */
	{0x4a8,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF14 */
	{0x4a9,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF15 */
	{0x4aa,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF16 */
	{0x4ab,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF18 */
	{0x4ac,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF19 */
	{0x4ad,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF20 */
	{0x4ae,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF21 */
	{0x4af,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF22 */
	{0x4b0,    0x40},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF24 */
	{0x4b1,    0x50},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF25 */
	{0x4b2,    0x60},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF26 */
	{0x4b3,    0x70},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF27 */
	{0x4b4,    0x18},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF33_0 */
	{0x4b5,    0x1C},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF33_1 */
	{0x4b6,    0x1f},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF34_0 */
	{0x4b7,    0x1D},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF34_1 */
	{0x4b8,    0x1E},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF35_0 */
	{0x4b9,    0x1F},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF35_1 */
	{0x4ba,    0x22},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF36_0 */
	{0x4bb,    0x26},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF36_1 */
	{0x4bc,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF37_0 */
	{0x4bd,    0x1f},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF37_1 */
	{0x4be,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF38_0 */
	{0x4bf,    0x1e},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF38_1 */
	{0x4c0,    0x21},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF39_0 */
	{0x4c1,    0x26},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF39_1 */
	{0x4c2,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF40_0 */
	{0x4c3,    0x24},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF40_1 */
	{0x4c4,    0x2A},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF41_0 */
	{0x4c5,    0x25},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF41_1 */
	{0x4c6,    0x29},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF42_0 */
	{0x4c7,    0x30},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF42_1 */
	{0x4c8,    0x40},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF43_0 */
	{0x4c9,    0x45},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF43_1 */
	{0x4ca,    0x53},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF44_1 */
	{0x4cb,    0x57},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF45_0 */
	{0x4cc,    0x62},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF45_1 */
	{0x4cd,    0x71},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF46_0 */
	{0x4ce,    0x76},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF46_1 */
	{0x4cf,    0x83},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF47_1 */
	{0x4d0,    0x84},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF48_1 */
	{0x4d1,    0x84},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF49_1 */
	{0x4d2,    0x80},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF50_0 */
	{0x4d3,    0x80},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF50_1 */
	{0x4d4,    0x80},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF51_0 */
	{0x4d5,    0x80},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF51_1 */
	{0x4d6,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF52_0 */
	{0x4d7,    0x36},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF52_1 */
	{0x4d8,    0x80},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF53_0 */
	{0x4d9,    0x80},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_NF53_1 */
	{0x4da,    0x13},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF54_0 */
	{0x4db,    0x13},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF54_1 */
	{0x4dc,    0x1a},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF55_0 */
	{0x4dd,    0x1F},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF55_1 */
	{0x4de,    0x25},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF56_0 */
	{0x4df,    0x2B},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF56_1 */
	{0x4e0,    0x12},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF57_0 */
	{0x4e1,    0x18},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF57_1 */
	{0x4e2,    0x1F},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF58_0 */
	{0x4e3,    0x26},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF58_1 */
	{0x4e4,    0x1A},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF59_0 */
	{0x4e5,    0x1C},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF59_1 */
	{0x4e6,    0x1D},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF60_0 */
	{0x4e7,    0x1F},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF60_1 */
	{0x4e8,    0x29},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF61_0 */
	{0x4e9,    0x3B},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF61_1 */
	{0x4ea,    0x41},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GAINLLR_SF62_0 */
	{0x4f0,    0x14},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_GENCFG */
	{0x4f1,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_CFGEXT */
	{0x4f2,    0x02},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITERNOERR */
	{0x4f3,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_MODCOD */
	{0x4f4,    0x0c},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_DIFFDIV */
	{0x4f5,    0x33},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBITERDIV */
	{0x4f6,    0x28},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBCYCLETRANSFER1 */
	{0x4f7,    0x86},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBCYCLETRANSFER2 */
	{0x4f8,    0x0a},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBCYCLETRANSFER3 */
	{0x4f9,    0x26},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBCYCLETRANSFER4 */
	{0x500,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER13 */
	{0x501,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER12 */
	{0x502,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER11 */
	{0x503,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER10 */
	{0x504,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER9 */
	{0x505,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER8 */
	{0x506,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER7 */
	{0x507,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER6 */
	{0x508,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER5 */
	{0x509,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER4 */
	{0x50a,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER3 */
	{0x50b,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER2 */
	{0x50c,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER1 */
	{0x50d,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_INVDINTER0 */
	{0x510,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBFROVERFLOW */
	{0x511,    0x08},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBFR_CHECK */
	{0x520,    0x22},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_CONTROLLDPC */
	{0x521,    0x07},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_MAXEXTRAITER */
	{0x522,    0x08},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LGTHSTOPITER */
	{0x523,    0x20},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_NBLAYERSTOP */
	{0x524,    0x02},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_THSTOP */
	{0x525,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_FRACTSET */
	{0x560,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCERR1 */
	{0x561,    0x1c},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCERR0 */
	{0x562,    0x1c},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_BCHERR */
	{0x563,    0x05},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_STATUSITER */
	{0x564,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_STATUSMAXITER */
	{0x565,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCSYND */
	{0x566,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCDBGINIT */
	{0x567,    0x07},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPRESYNDFAIL1 */
	{0x568,    0xb5},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPRESYNDFAIL2 */
	{0x569,    0x2f},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPRESYNDFAIL3 */
	{0x56a,    0xc4},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPRESYNDFAIL4 */
	{0x56b,    0x00},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPOSTSYNDFAIL1 */
	{0x56c,    0x0b},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPOSTSYNDFAIL2 */
	{0x56d,    0x6d},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPOSTSYNDFAIL3 */
	{0x56e,    0xc4},/* REG_RL2A_L2SAT_SAT2A_DVBS2FEC_LDPCPOSTSYNDFAIL4 */
	{0x899,    0x3b},/* REG_RL2A_DVBSX_HWARE_GEN_RCDEBUG1 */
	{0x89a,    0x1b},/* REG_RL2A_DVBSX_HWARE_GEN_RCDEBUG0 */
	{0x8a0,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_TSGENERAL */
	{0x8a1,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_TSGENCFG2 */
	{0x8a2,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_TSGSTATUS */
	{0x8a3,    0x0c},/* REG_RL2A_DVBSX_HWARE_GEN_TSRSCFG */
	{0x8a4,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_TSTTSRS */
	{0x8c0,    0x06},/* REG_RL2A_DVBSX_HWARE_GEN_GCTRL */
	{0x8c1,    0xc8},/* REG_RL2A_DVBSX_HWARE_GEN_FFTCTRL */
	{0x8c2,    0x0a},/* REG_RL2A_DVBSX_HWARE_GEN_FFT_ACC */
	{0x8c3,    0x04},/* REG_RL2A_DVBSX_HWARE_GEN_THRESHOLD */
	{0x8c4,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_GAINCONT */
	{0x8c5,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_UPDCONT */
	{0x8c6,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_GSTAT */
	{0x8c7,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_EXPMAX */
	{0x8c8,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_BINMAX1 */
	{0x8c9,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_BINMAX0 */
	{0x8ca,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX2 */
	{0x8cb,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX1 */
	{0x8cc,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX0 */
	{0x8cd,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_BINMAX21 */
	{0x8ce,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_BINMAX20 */
	{0x8cf,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX22 */
	{0x8d0,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX21 */
	{0x8d1,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX20 */
	{0x8d2,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_BINMAX31 */
	{0x8d3,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_BINMAX30 */
	{0x8d4,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX32 */
	{0x8d5,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX31 */
	{0x8d6,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_VALMAX30 */
	{0x8d7,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_CPTACC */
	{0x8d8,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_CTESTAT */
	{0x8da,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_CFOEST1 */
	{0x8db,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_CFOEST0 */
	{0x8ec,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_DEBUG1 */
	{0x8ed,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_MEMADDR1 */
	{0x8ee,    0x00},/* REG_RL2A_DVBSX_HWARE_GEN_MEMADDR0 */
	{0x8ef,    0x01},/* REG_RL2A_DVBSX_HWARE_GEN_MEMSTAT */
	{0x8f0,    0xda},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA01 */
	{0x8f1,    0x12},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA00 */
	{0x8f2,    0xda},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA11 */
	{0x8f3,    0x12},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA10 */
	{0x8f4,    0xda},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA21 */
	{0x8f5,    0x12},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA20 */
	{0x8f6,    0xda},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA31 */
	{0x8f7,    0x12},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA30 */
	{0x8f8,    0xda},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA41 */
	{0x8f9,    0x12},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA40 */
	{0x8fa,    0xda},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA51 */
	{0x8fb,    0x12},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA50 */
	{0x8fc,    0xda},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA61 */
	{0x8fd,    0x12},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA60 */
	{0x8fe,    0xda},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA71 */
	{0x8ff,    0x12},/* REG_RL2A_DVBSX_HWARE_GEN_MEMVA70 */
	{0x900,    0x00},/* REG_RL2A_DVBSX_DEMOD_IQCONST */
	{0x901,    0x00},/* REG_RL2A_DVBSX_DEMOD_IQOPTION */
	{0x902,    0xe5},/* REG_RL2A_DVBSX_DEMOD_ISYMB */
	{0x903,    0xe0},/* REG_RL2A_DVBSX_DEMOD_QSYMB */
	{0x910,    0x54},/* REG_RL2A_DVBSX_DEMOD_AGC1CFG */
	{0x911,    0x00},/* REG_RL2A_DVBSX_DEMOD_AGC1RFN */
	{0x912,    0x99},/* REG_RL2A_DVBSX_DEMOD_AGC1CN */
	/* change from 0x58 to 0x50 */
	{0x913,    0x50},/* REG_RL2A_DVBSX_DEMOD_AGC1REF */
	{0x914,    0xe2},/* REG_RL2A_DVBSX_DEMOD_AGC1IDCCOMP */
	{0x915,    0xf1},/* REG_RL2A_DVBSX_DEMOD_AGC1QDCCOMP */
	{0x916,    0x43},/* REG_RL2A_DVBSX_DEMOD_AGC1POWERI */
	{0x917,    0x34},/* REG_RL2A_DVBSX_DEMOD_AGC1POWERQ */
	{0x918,    0x0e},/* REG_RL2A_DVBSX_DEMOD_AGC1AMM */
	{0x919,    0x05},/* REG_RL2A_DVBSX_DEMOD_AGC1QUAD */
	{0x91a,    0x00},/* REG_RL2A_DVBSX_DEMOD_AGC1IQIN1 */
	{0x91b,    0x00},/* REG_RL2A_DVBSX_DEMOD_AGC1IQIN0 */
	{0x91c,    0x00},/* REG_RL2A_DVBSX_DEMOD_AGC1SHDB */
	{0x91d,    0x00},/* REG_RL2A_DVBSX_DEMOD_AGC1OPT */
	{0x920,    0x00},/* REG_RL2A_DVBSX_DEMOD_DEMOD */
	/* REG_RL2A_DVBSX_DEMOD_DMDCFGMD, important dvbs/s2/s2x auto search */
	/* value changed from 0xcc to 0xdc, enable auto sr */
	{0x922,    0xcc}, /*0xdc to enable auto sr ,0xcc to disable autosr*/
	{0x923,    0x3b},/* REG_RL2A_DVBSX_DEMOD_DMDCFG2 */
	{0x924,    0x15},/* REG_RL2A_DVBSX_DEMOD_DMDISTATE */
	{0x925,    0x40},/* REG_RL2A_DVBSX_DEMOD_DMDT0M */
	{0x926,    0xc0},/* REG_RL2A_DVBSX_DEMOD_DMDT0L */
	{0x927,    0x99},/* REG_RL2A_DVBSX_DEMOD_DMDT1M */
	{0x928,    0xee},/* REG_RL2A_DVBSX_DEMOD_DMDT1L */
	{0x929,    0x08},/* REG_RL2A_DVBSX_DEMOD_DMDCFG3 */
	{0x92a,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDCFG4 */
	{0x92b,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDCFG5 */
	{0x930,    0x03},/* REG_RL2A_DVBSX_DEMOD_DMDMODCOD */
	{0x931,    0x01},/* REG_RL2A_DVBSX_DEMOD_DMDPLFNUM */
	{0x932,    0x09},/* REG_RL2A_DVBSX_DEMOD_DMDSTATE */
	{0x933,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDFLYW */
	{DSTATUS,    0x00},/* REG_RL2A_DVBSX_DEMOD_DSTATUS */
	{0x935,    0x00},/* REG_RL2A_DVBSX_DEMOD_DSTATUS2 */
	{0x936,    0x80},/* REG_RL2A_DVBSX_DEMOD_DSTATUS3 */
	{0x937,    0x60},/* REG_RL2A_DVBSX_DEMOD_DSTATUS4 */
	{0x938,    0x00},/* REG_RL2A_DVBSX_DEMOD_DSTATUS5 */
	{0x939,    0x00},/* REG_RL2A_DVBSX_DEMOD_DSTATUS6 */
	{0x93a,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDERRORS */
	{0x940,    0x15},/* REG_RL2A_DVBSX_DEMOD_HDEBITCFG2 */
	{0x941,    0x00},/* REG_RL2A_DVBSX_DEMOD_HDEBITCFG1 */
	{0x942,    0x00},/* REG_RL2A_DVBSX_DEMOD_HDEBITCFG0 */
	{0x943,    0x00},/* REG_RL2A_DVBSX_DEMOD_DSAMPDLY */
	{0x944,    0x00},/* REG_RL2A_DVBSX_DEMOD_DSYMBDLY */
	{0x948,    0x00},/* REG_RL2A_DVBSX_DEMOD_SHDBFIFO21 */
	{0x949,    0x00},/* REG_RL2A_DVBSX_DEMOD_SHDBFIFO20 */
	{0x94a,    0x21},/* REG_RL2A_DVBSX_DEMOD_SHDBPARAL */
	{0x950,    0x80},/* REG_RL2A_DVBSX_DEMOD_SLICEADR */
	{0x951,    0x00},/* REG_RL2A_DVBSX_DEMOD_SLICEDATA */
	{0x952,    0x00},/* REG_RL2A_DVBSX_DEMOD_SLICECFG */
	{0x953,    0x00},/* REG_RL2A_DVBSX_DEMOD_SLICENBR */
	{0x954,    0x00},/* REG_RL2A_DVBSX_DEMOD_SLICESYMB2 */
	{0x955,    0x00},/* REG_RL2A_DVBSX_DEMOD_SLICESYMB1 */
	{0x956,    0x00},/* REG_RL2A_DVBSX_DEMOD_SLICESYMB0 */
	{0x957,    0x00},/* REG_RL2A_DVBSX_DEMOD_SLICERATIO */
	{0x958,    0x73},/* REG_RL2A_DVBSX_DEMOD_SLICESTAT */
	{0x959,    0x00},/* REG_RL2A_DVBSX_DEMOD_SLICEMAX */
	{0x95a,    0xff},/* REG_RL2A_DVBSX_DEMOD_SLICEMIN */
	{0x95b,    0x00},/* REG_RL2A_DVBSX_DEMOD_SLICESEL */
	{0x95c,    0x05},/* REG_RL2A_DVBSX_DEMOD_SLICEANC */
	{0x95d,    0x00},/* REG_RL2A_DVBSX_DEMOD_DEMODAUX */
	{0x95e,    0x00},/* REG_RL2A_DVBSX_DEMOD_HDEBITCFG4 */
	{0x970,    0x00},/* REG_RL2A_DVBSX_DEMOD_FILTCFGM */
	{0x971,    0x00},/* REG_RL2A_DVBSX_DEMOD_FILTCFGL */
	{0x972,    0x1e},/* REG_RL2A_DVBSX_DEMOD_IQFILT0 */
	{0x973,    0x40},/* REG_RL2A_DVBSX_DEMOD_IQFILT1 */
	{0x974,    0x40},/* REG_RL2A_DVBSX_DEMOD_IQFILT2 */
	{0x975,    0x40},/* REG_RL2A_DVBSX_DEMOD_IQFILT3 */
	/* REG_RL2A_DVBSX_DEMOD_CORRELMANT, 0x58 for tracking low CNR, 0x8C for acquisiton */
	{0x980,    0x8C},
	{0x981,    0x60},/* REG_RL2A_DVBSX_DEMOD_CORRELABS */
	{0x982,    0x40},/* REG_RL2A_DVBSX_DEMOD_CORRELABSM */
	{0x983,    0xaa},/* REG_RL2A_DVBSX_DEMOD_CORRELEXP */
	{0x984,    0x20},/* REG_RL2A_DVBSX_DEMOD_CORRELCOEF */
	{0x985,    0x01},/* REG_RL2A_DVBSX_DEMOD_CORRELCFG */
	{0x986,    0x70},/* REG_RL2A_DVBSX_DEMOD_CORRELFREQ */
	{0x987,    0x02},/* REG_RL2A_DVBSX_DEMOD_PLHMODCOD */
	{0x988,    0x01},/* REG_RL2A_DVBSX_DEMOD_DMDREG */
	{0x990,    0x5b},/* REG_RL2A_DVBSX_DEMOD_AGC2O */
	{0x991,    0x40},/* REG_RL2A_DVBSX_DEMOD_AGC2REF */
	{0x992,    0x00},/* REG_RL2A_DVBSX_DEMOD_AGCNADJ */
	{0x993,    0x00},/* REG_RL2A_DVBSX_DEMOD_AGCKS */
	{0x994,    0x38},/* REG_RL2A_DVBSX_DEMOD_AGCRSADJ */
	{0x995,    0x38},/* REG_RL2A_DVBSX_DEMOD_AGCRQ8ADJ */
	{0x996,    0x38},/* REG_RL2A_DVBSX_DEMOD_AGCR1ADJ */
	{0x997,    0x38},/* REG_RL2A_DVBSX_DEMOD_AGCR2ADJ */
	{0x998,    0x38},/* REG_RL2A_DVBSX_DEMOD_AGCR3ADJ */
	{0x999,    0x38},/* REG_RL2A_DVBSX_DEMOD_AGCR4ADJ */
	{0x99a,    0x38},/* REG_RL2A_DVBSX_DEMOD_AGCR5ADJ */
	{0x99b,    0x38},/* REG_RL2A_DVBSX_DEMOD_AGCR6ADJ */
	{0x99c,    0x38},/* REG_RL2A_DVBSX_DEMOD_AGCR7ADJ */
	{0x99d,    0x38},/* REG_RL2A_DVBSX_DEMOD_AGCR8ADJ */
	{0x99e,    0x38},/* REG_RL2A_DVBSX_DEMOD_AGCR1BADJ */
	{0x99f,    0x38},/* REG_RL2A_DVBSX_DEMOD_AGC2ADJ */
	{0x9a0,    0x6e},/* REG_RL2A_DVBSX_DEMOD_AGC2I1 */
	{0x9a1,    0x04},/* REG_RL2A_DVBSX_DEMOD_AGC2I0 */
	{0x9a2,    0x00},/* REG_RL2A_DVBSX_DEMOD_AGC2IMP */
	{0x9a3,    0x58},/* REG_RL2A_DVBSX_DEMOD_AGC1ADJ */
	{0x9a4,    0x96},/* REG_RL2A_DVBSX_DEMOD_AGC2R10DB */
	{0x9a5,    0xb8},/* REG_RL2A_DVBSX_DEMOD_AGC2R20DB */
	{0x9a6,    0xc9},/* REG_RL2A_DVBSX_DEMOD_AGC2AMPL */
	{0x9a7,    0x00},/* REG_RL2A_DVBSX_DEMOD_AGC2VAR */
	{0x9a8,    0x80},/* REG_RL2A_DVBSX_DEMOD_AGC2RATIO */
	{0x9b0,    0xc6},/* REG_RL2A_DVBSX_DEMOD_CARCFG */
	{0x9b1,    0x2a},/* REG_RL2A_DVBSX_DEMOD_ACLCNLK */
	{0x9b2,    0x18},/* REG_RL2A_DVBSX_DEMOD_BCLCNLK */
	{0x9b3,    0x28},/* REG_RL2A_DVBSX_DEMOD_ACLCLK */
	{0x9b4,    0x18},/* REG_RL2A_DVBSX_DEMOD_BCLCLK */
	{0x9b5,    0x79},/* REG_RL2A_DVBSX_DEMOD_CARFREQ */
	{0x9b6,    0x04},/* REG_RL2A_DVBSX_DEMOD_CARHDR */
	{0x9b7,    0xd0},/* REG_RL2A_DVBSX_DEMOD_LDT */
	{0x9b8,    0xb8},/* REG_RL2A_DVBSX_DEMOD_LDT2 */
	{0x9b9,    0xf8},/* REG_RL2A_DVBSX_DEMOD_CFRICFG */
	{0x9ba,    0x67},/* REG_RL2A_DVBSX_DEMOD_CFR1BCFG */
	{0x9bb,    0xe9},/* REG_RL2A_DVBSX_DEMOD_CFRULB1 */
	{0x9bc,    0x7c},/* REG_RL2A_DVBSX_DEMOD_CFRULB0 */
	{0x9bd,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFRCNTR2 */
	{0x9be,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFRCNTR1 */
	{0x9bf,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFRCNTR0 */
	{0x9c0,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFRIBASE2 */
	{0x9c1,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFRIBASE1 */
	{0x9c2,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFRIBASE0 */
	{0x9c3,    0xff},/* REG_RL2A_DVBSX_DEMOD_CFRINIT2 */
	{0x9c4,    0x33},/* REG_RL2A_DVBSX_DEMOD_CFRINIT1 */
	{0x9c5,    0x3c},/* REG_RL2A_DVBSX_DEMOD_CFRINIT0 */
	{0x9c6,    0x0c},/* REG_RL2A_DVBSX_DEMOD_CFRUP2 */
	{0x9c7,    0xcc},/* REG_RL2A_DVBSX_DEMOD_CFRUP1 */
	{0x9c8,    0x46},/* REG_RL2A_DVBSX_DEMOD_CFRUP0 */
	{0x9c9,    0xf3},/* REG_RL2A_DVBSX_DEMOD_CFRLOW2 */
	{0x9ca,    0x33},/* REG_RL2A_DVBSX_DEMOD_CFRLOW1 */
	{0x9cb,    0xba},/* REG_RL2A_DVBSX_DEMOD_CFRLOW0 */
	{0x9cc,    0x01},/* REG_RL2A_DVBSX_DEMOD_CFRINC2 */
	{0x9cd,    0x99},/* REG_RL2A_DVBSX_DEMOD_CFRINC1 */
	{0x9ce,    0x88},/* REG_RL2A_DVBSX_DEMOD_CFRINC0 */
	{0x9cf,    0xfc},/* REG_RL2A_DVBSX_DEMOD_CFR12 */
	{0x9d0,    0x70},/* REG_RL2A_DVBSX_DEMOD_CFR11 */
	{0x9d1,    0x8b},/* REG_RL2A_DVBSX_DEMOD_CFR10 */
	{0x9d2,    0xbb},/* REG_RL2A_DVBSX_DEMOD_LDI */
	{0x9d3,    0xfc},/* REG_RL2A_DVBSX_DEMOD_CFR1F2 */
	{0x9d4,    0x70},/* REG_RL2A_DVBSX_DEMOD_CFR1F1 */
	{0x9d5,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFR1F0 */
	{0x9d6,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFR1G */
	{0x9d7,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFR1B2 */
	{0x9d8,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFR1B1 */
	{0x9d9,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFR1B0 */
	{0x9da,    0x98},/* REG_RL2A_DVBSX_DEMOD_GAUSSR0 */
	{0x9db,    0x30},/* REG_RL2A_DVBSX_DEMOD_CCIR0 */
	{0x9dc,    0xac},/* REG_RL2A_DVBSX_DEMOD_CCIQUANT */
	{0x9dd,    0x50},/* REG_RL2A_DVBSX_DEMOD_CCITHRES */
	{0x9de,    0x00},/* REG_RL2A_DVBSX_DEMOD_CCIACC */
	{0x9e0,    0xd3},/* REG_RL2A_DVBSX_DEMOD_TMGCFG */
	{0x9e1,    0x88},/* REG_RL2A_DVBSX_DEMOD_RTCNLK */
	{0x9e2,    0x33},/* REG_RL2A_DVBSX_DEMOD_RTCLK */
	{0x9e3,    0x20},/* REG_RL2A_DVBSX_DEMOD_TMGTHRISE */
	{0x9e4,    0x08},/* REG_RL2A_DVBSX_DEMOD_TMGTHFALL */
	{0x9e5,    0x30},/* REG_RL2A_DVBSX_DEMOD_SFRUPRATIO */
	{0x9e6,    0xf0},/* REG_RL2A_DVBSX_DEMOD_SFRLOWRATIO */
	{0x9e7,    0xa0},/* REG_RL2A_DVBSX_DEMOD_KTTMG */
	{0x9e8,    0xf5},/* REG_RL2A_DVBSX_DEMOD_KREFTMG */
	{0x9e9,    0x88},/* REG_RL2A_DVBSX_DEMOD_SFRSTEP */
	{0x9ea,    0x40},/* REG_RL2A_DVBSX_DEMOD_TMGCFG2 */
	{0x9eb,    0x50},/* REG_RL2A_DVBSX_DEMOD_KREFTMG2 */
	/* value changed from 0x6 to 0,enable auto sr upper and low */
	{0x9ec,    0x06},/* REG_RL2A_DVBSX_DEMOD_TMGCFG3 */
	{0x9ed,    0x91},/* REG_RL2A_DVBSX_DEMOD_TMGMTHRES */
	//{0x9f0,    0x19},/* REG_RL2A_DVBSX_DEMOD_SFRINIT2 */
	//{0x9f1,    0x98},/* REG_RL2A_DVBSX_DEMOD_SFRINIT1 */
	//{0x9f2,    0x8d},/* REG_RL2A_DVBSX_DEMOD_SFRINIT0 */

	/* auto sr upper begin */
	{0x9f3,    0x55},/* REG_RL2A_DVBSX_DEMOD_SFRUP2 */
	{0x9f4,    0x55},/* REG_RL2A_DVBSX_DEMOD_SFRUP1 */
	{0x9f5,    0x55},/* REG_RL2A_DVBSX_DEMOD_SFRUP0 */
	/* auto sr upper end */

	/* auto sr low begin */
	{0x9f6,    0x01},/* REG_RL2A_DVBSX_DEMOD_SFRLOW2 */
	{0x9f7,    0xe5},/* REG_RL2A_DVBSX_DEMOD_SFRLOW1 */
	{0x9f8,    0x73},/* REG_RL2A_DVBSX_DEMOD_SFRLOW0 */
	/* auto sr low end */

	//{0x9fc,    0x19},/* REG_RL2A_DVBSX_DEMOD_SFR3 */
	//{0x9fd,    0x98},/* REG_RL2A_DVBSX_DEMOD_SFR2 */
	//{0x9fe,    0x8d},/* REG_RL2A_DVBSX_DEMOD_SFR1 */
	//{0x9ff,    0x00},/* REG_RL2A_DVBSX_DEMOD_SFR0 */
	{0xa00,    0xfd},/* REG_RL2A_DVBSX_DEMOD_TMGREG2 */
	{0xa01,    0x30},/* REG_RL2A_DVBSX_DEMOD_TMGREG1 */
	{0xa02,    0x08},/* REG_RL2A_DVBSX_DEMOD_TMGREG0 */
	{0xa03,    0x04},/* REG_RL2A_DVBSX_DEMOD_TMGLOCK1 */
	{0xa04,    0x24},/* REG_RL2A_DVBSX_DEMOD_TMGLOCK0 */
	{0xa05,    0x00},/* REG_RL2A_DVBSX_DEMOD_TMGOBS */
	{0xa06,    0x7f},/* REG_RL2A_DVBSX_DEMOD_DMDCODSFR2 */
	{0xa07,    0xff},/* REG_RL2A_DVBSX_DEMOD_DMDCODSFR1 */
	{0xa08,    0xff},/* REG_RL2A_DVBSX_DEMOD_DMDCODSFR0 */
	{0xa10,    0x41},/* REG_RL2A_DVBSX_DEMOD_DFECFG */
	{0xa11,    0x41},/* REG_RL2A_DVBSX_DEMOD_FFECFG */
	{0xa12,    0x00},/* REG_RL2A_DVBSX_DEMOD_XFECFG */
	{0xa13,    0x00},/* REG_RL2A_DVBSX_DEMOD_XFECFG2 */
	{0xa14,    0x00},/* REG_RL2A_DVBSX_DEMOD_PEGALCFG */
	{0xa15,    0x42},/* REG_RL2A_DVBSX_DEMOD_WDFECFG */
	{0xa16,    0x91},/* REG_RL2A_DVBSX_DEMOD_WDFERCFG */
	{0xa17,    0x00},/* REG_RL2A_DVBSX_DEMOD_WDFERAMPOS */
	{0xa18,    0x00},/* REG_RL2A_DVBSX_DEMOD_WDFERAMI */
	{0xa19,    0x00},/* REG_RL2A_DVBSX_DEMOD_WDFERAMQ */
	{0xa1a,    0x00},/* REG_RL2A_DVBSX_DEMOD_WDFEROBS */
	{0xa1b,    0x89},/* REG_RL2A_DVBSX_DEMOD_DFESTNBR */
	{0xa1c,    0x04},/* REG_RL2A_DVBSX_DEMOD_FFESTNBR */
	{0xa20,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAI1 */
	{0xa21,    0x01},/* REG_RL2A_DVBSX_DEMOD_EQUAQ1 */
	{0xa22,    0xff},/* REG_RL2A_DVBSX_DEMOD_EQUAI2 */
	{0xa23,    0xff},/* REG_RL2A_DVBSX_DEMOD_EQUAQ2 */
	{0xa24,    0x01},/* REG_RL2A_DVBSX_DEMOD_EQUAI3 */
	{0xa25,    0x01},/* REG_RL2A_DVBSX_DEMOD_EQUAQ3 */
	{0xa26,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAI4 */
	{0xa27,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAQ4 */
	{0xa28,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAI5 */
	{0xa29,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAQ5 */
	{0xa2a,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAI6 */
	{0xa2b,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAQ6 */
	{0xa2c,    0xff},/* REG_RL2A_DVBSX_DEMOD_EQUAI7 */
	{0xa2d,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAQ7 */
	{0xa2e,    0xff},/* REG_RL2A_DVBSX_DEMOD_EQUAI8 */
	{0xa2f,    0x01},/* REG_RL2A_DVBSX_DEMOD_EQUAQ8 */
	{0xa30,    0x01},/* REG_RL2A_DVBSX_DEMOD_FFEI1 */
	{0xa31,    0xff},/* REG_RL2A_DVBSX_DEMOD_FFEQ1 */
	{0xa32,    0x01},/* REG_RL2A_DVBSX_DEMOD_FFEI2 */
	{0xa33,    0x01},/* REG_RL2A_DVBSX_DEMOD_FFEQ2 */
	{0xa34,    0x00},/* REG_RL2A_DVBSX_DEMOD_FFEI3 */
	{0xa35,    0x00},/* REG_RL2A_DVBSX_DEMOD_FFEQ3 */
	{0xa36,    0xff},/* REG_RL2A_DVBSX_DEMOD_FFEI4 */
	{0xa37,    0x01},/* REG_RL2A_DVBSX_DEMOD_FFEQ4 */
	{0xa38,    0x00},/* REG_RL2A_DVBSX_DEMOD_FFEI5 */
	{0xa39,    0x00},/* REG_RL2A_DVBSX_DEMOD_FFEQ5 */
	{0xa40,    0x01},/* REG_RL2A_DVBSX_DEMOD_EQUAI9 */
	{0xa41,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAQ9 */
	{0xa42,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAI10 */
	{0xa43,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAQ10 */
	{0xa44,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAI11 */
	{0xa45,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAQ11 */
	{0xa46,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAI12 */
	{0xa47,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAQ12 */
	{0xa48,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAI13 */
	{0xa49,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAQ13 */
	{0xa4a,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAI14 */
	{0xa4b,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAQ14 */
	{0xa4c,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAI15 */
	{0xa4d,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAQ15 */
	{0xa4e,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAI16 */
	{0xa4f,    0x00},/* REG_RL2A_DVBSX_DEMOD_EQUAQ16 */
	{0xa60,    0x06},/* REG_RL2A_DVBSX_DEMOD_CAR2CFG */
	{0xa61,    0x23},/* REG_RL2A_DVBSX_DEMOD_CFR2CFR1 */
	{0xa62,    0xc0},/* REG_RL2A_DVBSX_DEMOD_CAR3CFG */
	{0xa63,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFR22 */
	{0xa64,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFR21 */
	{0xa65,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFR20 */
	{0xa68,    0x48},/* REG_RL2A_DVBSX_DEMOD_ACLC2S1 */
	{0xa69,    0x48},/* REG_RL2A_DVBSX_DEMOD_ACLC2S2Q */
	{0xa6a,    0x48},/* REG_RL2A_DVBSX_DEMOD_ACLC2S28 */
	{0xa6b,    0x48},/* REG_RL2A_DVBSX_DEMOD_ACLC2S216A */
	{0xa6c,    0x48},/* REG_RL2A_DVBSX_DEMOD_ACLC2S232A */
	{0xa6d,    0x48},/* REG_RL2A_DVBSX_DEMOD_ACLC2S264A */
	{0xa6e,    0x48},/* REG_RL2A_DVBSX_DEMOD_ACLC2S2128A */
	{0xa6f,    0x48},/* REG_RL2A_DVBSX_DEMOD_ACLC2S2256A */
	{0xa70,    0xc8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S1 */
	{0xa71,    0xc6},/* REG_RL2A_DVBSX_DEMOD_BCLC2S2Q */
	{0xa72,    0xc8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S28 */
	{0xa73,    0xc8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S216A */
	{0xa74,    0xc8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S232A */
	{0xa75,    0xc8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S264A */
	{0xa76,    0xc8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S2128A */
	{0xa77,    0xc8},/* REG_RL2A_DVBSX_DEMOD_BCLC2S2256A */
	{0xa84,    0x00},/* REG_RL2A_DVBSX_DEMOD_NCO2MAX1 */
	{0xa85,    0x00},/* REG_RL2A_DVBSX_DEMOD_NCO2MAX0 */
	{0xa86,    0x00},/* REG_RL2A_DVBSX_DEMOD_NCO2FR1 */
	{0xa87,    0x00},/* REG_RL2A_DVBSX_DEMOD_NCO2FR0 */
	{0xa88,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFR2AVRGE1 */
	{0xa89,    0x00},/* REG_RL2A_DVBSX_DEMOD_CFR2AVRGE0 */
	{0xa8a,    0x00},/* REG_RL2A_DVBSX_DEMOD_DPILOTMAX1 */
	{0xa8b,    0x00},/* REG_RL2A_DVBSX_DEMOD_DPILOTMAX0 */
	{0xa98,    0x3f},/* REG_RL2A_DVBSX_DEMOD_NOSCFG */
	{0xa99,    0x00},/* REG_RL2A_DVBSX_DEMOD_NOSCFGF1 */
	{0xa9a,    0x00},/* REG_RL2A_DVBSX_DEMOD_NOSCFGF2 */
	{0xaa0,    0x25},/* REG_RL2A_DVBSX_DEMOD_NNOSDATAT1 */
	{0xaa1,    0xcf},/* REG_RL2A_DVBSX_DEMOD_NNOSDATAT0 */
	{0xaa2,    0x17},/* REG_RL2A_DVBSX_DEMOD_NNOSDATA1 */
	{0xaa3,    0xb9},/* REG_RL2A_DVBSX_DEMOD_NNOSDATA0 */
	{0xaa4,    0x24},/* REG_RL2A_DVBSX_DEMOD_NNOSPLHT1 */
	{0xaa5,    0xa6},/* REG_RL2A_DVBSX_DEMOD_NNOSPLHT0 */
	{0xaa6,    0x1b},/* REG_RL2A_DVBSX_DEMOD_NNOSPLH1 */
	{0xaa7,    0xf8},/* REG_RL2A_DVBSX_DEMOD_NNOSPLH0 */
	{0xaa8,    0x22},/* REG_RL2A_DVBSX_DEMOD_NOSDATAT1 */
	{0xaa9,    0x0c},/* REG_RL2A_DVBSX_DEMOD_NOSDATAT0 */
	{0xaaa,    0x1b},/* REG_RL2A_DVBSX_DEMOD_NNOSFRAME1 */
	{0xaab,    0x00},/* REG_RL2A_DVBSX_DEMOD_NNOSFRAME0 */
	{0xaac,    0x00},/* REG_RL2A_DVBSX_DEMOD_NNOSRAD1 */
	{0xaad,    0x7f},/* REG_RL2A_DVBSX_DEMOD_NNOSRAD0 */
	{0xaae,    0x1e},/* REG_RL2A_DVBSX_DEMOD_NOSRAMCNR1 */
	{0xaaf,    0x86},/* REG_RL2A_DVBSX_DEMOD_NOSRAMCNR0 */
	{0xac0,    0x60},/* REG_RL2A_DVBSX_DEMOD_NOSTHRES1 */
	{0xac1,    0x69},/* REG_RL2A_DVBSX_DEMOD_NOSTHRES2 */
	{0xac2,    0xd3},/* REG_RL2A_DVBSX_DEMOD_NOSDIFF1 */
	{0xac3,    0x35},/* REG_RL2A_DVBSX_DEMOD_RAINFADE */
	{0xac4,    0x28},/* REG_RL2A_DVBSX_DEMOD_NOSRAMCFG */
	{0xac5,    0x14},/* REG_RL2A_DVBSX_DEMOD_NOSRAMPOS */
	{0xac6,    0x09},/* REG_RL2A_DVBSX_DEMOD_NOSRAMVAL */
	{0xad0,    0x80},/* REG_RL2A_DVBSX_DEMOD_SOFCODE3 */
	{0xad1,    0x00},/* REG_RL2A_DVBSX_DEMOD_SOFCODE2 */
	{0xad2,    0x00},/* REG_RL2A_DVBSX_DEMOD_SOFCODE1 */
	{0xad3,    0x00},/* REG_RL2A_DVBSX_DEMOD_SOFCODE0 */
	{0xad4,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB7 */
	{0xad5,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB6 */
	{0xad6,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB5 */
	{0xad7,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB4 */
	{0xad8,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB3 */
	{0xad9,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB2 */
	{0xada,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB1 */
	{0xadb,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSSCRAMB0 */
	{0xadc,    0x70},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMBB */
	{0xadd,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMBA */
	{0xade,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB9 */
	{0xadf,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB8 */
	{0xae0,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB7 */
	{0xae1,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB6 */
	{0xae2,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB5 */
	{0xae3,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB4 */
	{0xae4,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB3 */
	{0xae5,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB2 */
	{0xae6,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB1 */
	{0xae7,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLSMSCRAMB0 */
	{0xaec,    0x24},/* REG_RL2A_DVBSX_DEMOD_PLROOT2 */
	{0xaed,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLROOT1 */
	{0xaee,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLROOT0 */
	{0xb00,    0xff},/* REG_RL2A_DVBSX_DEMOD_MODCODLST0 */
	{0xb01,    0xcc},/* REG_RL2A_DVBSX_DEMOD_MODCODLST1 */
	{0xb02,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLST2 */
	{0xb03,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLST3 */
	{0xb04,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLST4 */
	{0xb05,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLST5 */
	{0xb06,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLST6 */
	{0xb07,    0xc0},/* REG_RL2A_DVBSX_DEMOD_MODCODLST7 */
	{0xb08,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLST8 */
	{0xb09,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLST9 */
	{0xb0a,    0xc0},/* REG_RL2A_DVBSX_DEMOD_MODCODLSTA */
	{0xb0b,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLSTB */
	{0xb0c,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLSTC */
	{0xb0d,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLSTD */
	{0xb0e,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLSTE */
	{0xb0f,    0x0f},/* REG_RL2A_DVBSX_DEMOD_MODCODLSTF */
	{0xb10,    0xfc},/* REG_RL2A_DVBSX_DEMOD_MODCODLS10 */
	{0xb11,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLS11 */
	{0xb12,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLS12 */
	{0xb13,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLS13 */
	{0xb14,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLS14 */
	{0xb15,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLS15 */
	{0xb16,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLS16 */
	{0xb17,    0x33},/* REG_RL2A_DVBSX_DEMOD_MODCODLS17 */
	{0xb18,    0x30},/* REG_RL2A_DVBSX_DEMOD_MODCODLS18 */
	{0xb19,    0x03},/* REG_RL2A_DVBSX_DEMOD_MODCODLS19 */
	{0xb1a,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLS1A */
	{0xb1b,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLS1B */
	{0xb1c,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLS1C */
	{0xb1d,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLS1D */
	{0xb1e,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODLS1E */
	{0xb1f,    0x0f},/* REG_RL2A_DVBSX_DEMOD_MODCODLS1F */
	{0xb20,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODCH3 */
	{0xb21,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODCH2 */
	{0xb22,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODCH1 */
	{0xb23,    0x00},/* REG_RL2A_DVBSX_DEMOD_MODCODCHM */
	{0xb24,    0x01},/* REG_RL2A_DVBSX_DEMOD_DMDRESCFG */
	{0xb25,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDRESADR */
	{0xb26,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA7 */
	{0xb27,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA6 */
	{0xb28,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA5 */
	{0xb29,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA4 */
	{0xb2a,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA3 */
	{0xb2b,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA2 */
	{0xb2c,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA1 */
	{0xb2d,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA0 */
	{0xb2e,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA8 */
	{0xb2f,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDRESDATA9 */
	{0xb30,    0x00},/* REG_RL2A_DVBSX_DEMOD_TNRCFG */
	{0xb31,    0x02},/* REG_RL2A_DVBSX_DEMOD_TNRCFG2 */
	{0xb80,    0x00},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF7 */
	{0xb81,    0x00},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF6 */
	{0xb82,    0x00},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF5 */
	{0xb83,    0x00},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF4 */
	{0xb84,    0x00},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF3 */
	{0xb85,    0x00},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF2 */
	{0xb86,    0x00},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF1 */
	{0xb87,    0x00},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEF0 */
	{0xb88,    0x00},/* REG_RL2A_DVBSX_DEMOD_SDEMAP */
	{0xb89,    0x00},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEFM2 */
	{0xb8a,    0x00},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEFM1 */
	{0xb8b,    0x00},/* REG_RL2A_DVBSX_DEMOD_SMAPCOEFM0 */
	{0xba0,    0x00},/* REG_RL2A_DVBSX_DEMOD_LLROBS5 */
	{0xba1,    0x00},/* REG_RL2A_DVBSX_DEMOD_LLROBS4 */
	{0xba2,    0x00},/* REG_RL2A_DVBSX_DEMOD_LLROBS3 */
	{0xba3,    0x00},/* REG_RL2A_DVBSX_DEMOD_LLROBS2 */
	{0xba4,    0x00},/* REG_RL2A_DVBSX_DEMOD_LLROBS1 */
	{0xba5,    0x00},/* REG_RL2A_DVBSX_DEMOD_LLROBS0 */
	{0xba6,    0x00},/* REG_RL2A_DVBSX_DEMOD_LLROBSCFG */
	{0xbb0,    0xf3},/* REG_RL2A_DVBSX_DEMOD_DMDPLHSTAT */
	{0xbb1,    0x20},/* REG_RL2A_DVBSX_DEMOD_DMDSELOBS */
	{0xbb2,    0x00},/* REG_RL2A_DVBSX_DEMOD_LOCKTIME3 */
	{0xbb3,    0x8d},/* REG_RL2A_DVBSX_DEMOD_LOCKTIME2 */
	{0xbb4,    0x20},/* REG_RL2A_DVBSX_DEMOD_LOCKTIME1 */
	{0xbb5,    0x1c},/* REG_RL2A_DVBSX_DEMOD_LOCKTIME0 */
	{0xbc0,    0x04},/* REG_RL2A_DVBSX_DEMOD_CALCFG */
	{0xbc1,    0x00},/* REG_RL2A_DVBSX_DEMOD_CALADDR */
	{0xbc2,    0x09},/* REG_RL2A_DVBSX_DEMOD_CALSTART */
	{0xbc3,    0x3f},/* REG_RL2A_DVBSX_DEMOD_CALMASK */
	{0xbc4,    0x0e},/* REG_RL2A_DVBSX_DEMOD_CALSTOP */
	{0xbc5,    0x1f},/* REG_RL2A_DVBSX_DEMOD_CALOBS */
	{0xbc6,    0x00},/* REG_RL2A_DVBSX_DEMOD_CALRESINC */
	{0xbc7,    0x00},/* REG_RL2A_DVBSX_DEMOD_CALRESDEC */
	{0xbc8,    0x00},/* REG_RL2A_DVBSX_DEMOD_CALRLIST */
	{0xbe0,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLHCCMP1 */
	{0xbe1,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLHCCMP0 */
	{0xbe2,    0x0f},/* REG_RL2A_DVBSX_DEMOD_DMDTIMER */
	{0xbe3,    0x00},/* REG_RL2A_DVBSX_DEMOD_DMDATTEMPT */
	{0xbe4,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLFHEADER1 */
	{0xbe5,    0xbb},/* REG_RL2A_DVBSX_DEMOD_PLFHEADER0 */
	{0xbe6,    0xff},/* REG_RL2A_DVBSX_DEMOD_PLHSFRDIFF1 */
	{0xbe7,    0x40},/* REG_RL2A_DVBSX_DEMOD_PLHSFRDIFF0 */
	{0xbe8,    0x0c},/* REG_RL2A_DVBSX_DEMOD_PLHRCMP1 */
	{0xbe9,    0x3e},/* REG_RL2A_DVBSX_DEMOD_PLHRCMP0 */
	{0xbea,    0x06},/* REG_RL2A_DVBSX_DEMOD_PLHRECORD1 */
	{0xbeb,    0xf4},/* REG_RL2A_DVBSX_DEMOD_PLHRECORD0 */
	{0xbec,    0x07},/* REG_RL2A_DVBSX_DEMOD_PLHRECNCO1 */
	{0xbed,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLHRECNCO0 */
	{0xbee,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLHDELTAF1 */
	{0xbef,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLHDELTAF0 */
	{0xc00,    0x00},/* REG_RL2A_DVBSX_DEMOD_PHERRCMP5 */
	{0xc01,    0x00},/* REG_RL2A_DVBSX_DEMOD_PHERRCMP4 */
	{0xc02,    0x00},/* REG_RL2A_DVBSX_DEMOD_PHERRCMP3 */
	{0xc03,    0x00},/* REG_RL2A_DVBSX_DEMOD_PHERRCMP2 */
	{0xc04,    0x00},/* REG_RL2A_DVBSX_DEMOD_PHERRCMP1 */
	{0xc05,    0x00},/* REG_RL2A_DVBSX_DEMOD_PHERRCMP0 */
	{0xc06,    0x00},/* REG_RL2A_DVBSX_DEMOD_PLHDEBUG */
	{0xcc0,    0x00},/* REG_RL2A_DVBSX_DEMOD_TSTDMD */
	{0xcc1,    0x00},/* REG_RL2A_DVBSX_DEMOD_TPOLY */
	{0xcc2,    0x00},/* REG_RL2A_DVBSX_DEMOD_TSTR */
	{0xcc3,    0x00},/* REG_RL2A_DVBSX_DEMOD_TAGC2 */
	{0xcc4,    0x00},/* REG_RL2A_DVBSX_DEMOD_TCTL1 */
	{0xcc5,    0x00},/* REG_RL2A_DVBSX_DEMOD_TCTL2 */
	{0xcc6,    0x00},/* REG_RL2A_DVBSX_DEMOD_TCTL3 */
	{0xcc8,    0x00},/* REG_RL2A_DVBSX_DEMOD_TCTL4 */
	{0xcc9,    0x00},/* REG_RL2A_DVBSX_DEMOD_TSTCAR3 */
	{0xcca,    0x00},/* REG_RL2A_DVBSX_DEMOD_TSTHDEBIT */
	{0xcf0,    0x00},/* REG_RL2A_DVBSX_DEMOD_DEMODEND */
	{0xd00,    0x38},/* REG_RL2A_DVBSX_VITERBI_SIGPOWER */
	{0xd01,    0x32},/* REG_RL2A_DVBSX_VITERBI_DEMAPVIT */
	{0xd02,    0x00},/* REG_RL2A_DVBSX_VITERBI_VITSCALE */
	{0xd03,    0x10},/* REG_RL2A_DVBSX_VITERBI_FECM */
	{0xd04,    0xd7},/* REG_RL2A_DVBSX_VITERBI_VTH12 */
	{0xd05,    0x85},/* REG_RL2A_DVBSX_VITERBI_VTH23 */
	{0xd06,    0x58},/* REG_RL2A_DVBSX_VITERBI_VTH34 */
	{0xd07,    0x3a},/* REG_RL2A_DVBSX_VITERBI_VTH56 */
	{0xd08,    0x34},/* REG_RL2A_DVBSX_VITERBI_VTH67 */
	{0xd09,    0x28},/* REG_RL2A_DVBSX_VITERBI_VTH78 */
	{0xd0a,    0xbf},/* REG_RL2A_DVBSX_VITERBI_PRVIT */
	{0xd0b,    0x00},/* REG_RL2A_DVBSX_VITERBI_VAVSRVIT */
	{0xd10,    0x32},/* REG_RL2A_DVBSX_VITERBI_VITCURPUN */
	{0xd11,    0x00},/* REG_RL2A_DVBSX_VITERBI_VERROR */
	{0xd12,    0x7f},/* REG_RL2A_DVBSX_VITERBI_VITCNR */
	{0xd13,    0x85},/* REG_RL2A_DVBSX_VITERBI_VTHINUSE */
	{0xd14,    0x24},/* REG_RL2A_DVBSX_VITERBI_VSTATUSVIT */
	{0xd18,    0x27},/* REG_RL2A_DVBSX_VITERBI_KDIV12 */
	{0xd19,    0x32},/* REG_RL2A_DVBSX_VITERBI_KDIV23 */
	{0xd1a,    0x32},/* REG_RL2A_DVBSX_VITERBI_KDIV34 */
	{0xd1b,    0x32},/* REG_RL2A_DVBSX_VITERBI_KDIV56 */
	{0xd1c,    0x32},/* REG_RL2A_DVBSX_VITERBI_KDIV67 */
	{0xd1d,    0x50},/* REG_RL2A_DVBSX_VITERBI_KDIV78 */
	{0xd20,    0x00},/* REG_RL2A_DVBSX_VITERBI_SELOUT */
	{0xd21,    0x00},/* REG_RL2A_DVBSX_VITERBI_TSYNC */
	{0xd22,    0x00},/* REG_RL2A_DVBSX_VITERBI_TSTERR */
	{0xd80,    0xb0},/* REG_RL2A_DVBSX_SUPERFEC_SFAVSR */
	{0xd81,    0x22},/* REG_RL2A_DVBSX_SUPERFEC_SFDEMAP */
	{0xd82,    0xcc},/* REG_RL2A_DVBSX_SUPERFEC_SFERROR */
	{0xd83,    0x14},/* REG_RL2A_DVBSX_SUPERFEC_SFECCNR */
	{0xd84,    0x1f},/* REG_RL2A_DVBSX_SUPERFEC_SFKDIV12 */
	{0xd85,    0x22},/* REG_RL2A_DVBSX_SUPERFEC_SFKDIV23 */
	{0xd86,    0x24},/* REG_RL2A_DVBSX_SUPERFEC_SFKDIV34 */
	{0xd87,    0x24},/* REG_RL2A_DVBSX_SUPERFEC_SFKDIV56 */
	{0xd88,    0x29},/* REG_RL2A_DVBSX_SUPERFEC_SFKDIV67 */
	{0xd89,    0x2c},/* REG_RL2A_DVBSX_SUPERFEC_SFKDIV78 */
	{0xd8a,    0x08},/* REG_RL2A_DVBSX_SUPERFEC_SFECSTATUS */
	{0xd8d,    0x00},/* REG_RL2A_DVBSX_SUPERFEC_TSTSFMET */
	{0xd8e,    0x00},/* REG_RL2A_DVBSX_SUPERFEC_TSFSYNC */
	{0xd8f,    0x00},/* REG_RL2A_DVBSX_SUPERFEC_TSTSFERR */
	{0xe00,    0xf0},/* REG_RL2A_DVBSX_HWARE_TSSTATE1 */
	{0xe01,    0x12},/* REG_RL2A_DVBSX_HWARE_TSSTATE0 */
	{0xe02,    0x00},/* REG_RL2A_DVBSX_HWARE_TSCFG2 */
	{0xe03,    0x04},/* REG_RL2A_DVBSX_HWARE_TSCFG1 */
	/* change value from 0x20 to 0xa0 to support CI+ card */
	{0xe04,    0x20},/* REG_RL2A_DVBSX_HWARE_TSCFG0 */
	{0xe05,    0x00},/* REG_RL2A_DVBSX_HWARE_TSSYNC */
	{0xe06,    0x03},/* REG_RL2A_DVBSX_HWARE_TSDIVN */
	{0xe07,    0x00},/* REG_RL2A_DVBSX_HWARE_TSCFG4 */
	{0xe08,    0x00},/* REG_RL2A_DVBSX_HWARE_TSHEMCFG */
	{0xe09,    0x00},/* REG_RL2A_DVBSX_HWARE_TSCPLPCFG */
	{0xe0a,    0x80},/* REG_RL2A_DVBSX_HWARE_TSPCRCFG */
	{0xe0b,    0x1f},/* REG_RL2A_DVBSX_HWARE_TSPCRPID1 */
	{0xe0c,    0xff},/* REG_RL2A_DVBSX_HWARE_TSPCRPID0 */
	{0xe0d,    0x84},/* REG_RL2A_DVBSX_HWARE_TSNCRCFG */
	{0xe0e,    0x1f},/* REG_RL2A_DVBSX_HWARE_TSNCRPID1 */
	{0xe0f,    0xff},/* REG_RL2A_DVBSX_HWARE_TSNCRPID0 */
	{0xe10,    0xe0},/* REG_RL2A_DVBSX_HWARE_TSNCRADJ2 */
	{0xe11,    0x00},/* REG_RL2A_DVBSX_HWARE_TSNCRADJ1 */
	{0xe12,    0x00},/* REG_RL2A_DVBSX_HWARE_TSNCRADJ0 */
	{0xe13,    0x00},/* REG_RL2A_DVBSX_HWARE_TSPIDFLTM */
	{0xe14,    0x00},/* REG_RL2A_DVBSX_HWARE_TSPIDFLTL */
	{0xe15,    0x00},/* REG_RL2A_DVBSX_HWARE_TSPIDFLTC */
	{0xe16,    0x00},/* REG_RL2A_DVBSX_HWARE_TSDLYSET2 */
	{0xe17,    0x93},/* REG_RL2A_DVBSX_HWARE_TSDLYSET1 */
	{0xe18,    0x00},/* REG_RL2A_DVBSX_HWARE_TSDLYSET0 */
	{0xe19,    0x00},/* REG_RL2A_DVBSX_HWARE_TSINSDELH */
	{0xe1a,    0x00},/* REG_RL2A_DVBSX_HWARE_TSINSDELM */
	{0xe1b,    0x00},/* REG_RL2A_DVBSX_HWARE_TSINSDELL */
	{0xe1c,    0x00},/* REG_RL2A_DVBSX_HWARE_TSCFG5 */
	{0xe1d,    0x00},/* REG_RL2A_DVBSX_HWARE_TSCFG6 */
	{0xe1e,    0x00},/* REG_RL2A_DVBSX_HWARE_TSPIDFLTD */
	{0xe1f,    0x00},/* REG_RL2A_DVBSX_HWARE_TSSAMPDLY */
	{0xe20,    0xff},/* REG_RL2A_DVBSX_HWARE_TSMINSPEED */
	{0xe21,    0x04},/* REG_RL2A_DVBSX_HWARE_TSMAXSPEED */
	{0xe22,    0xff},/* REG_RL2A_DVBSX_HWARE_TSSPEED */
	{0xe24,    0x00},/* REG_RL2A_DVBSX_HWARE_TSDILSTK1 */
	{0xe25,    0x00},/* REG_RL2A_DVBSX_HWARE_TSDILSTK0 */
	{0xe26,    0x52},/* REG_RL2A_DVBSX_HWARE_TSSTATUS */
	{0xe27,    0x28},/* REG_RL2A_DVBSX_HWARE_TSSTATUS2 */
	{0xe28,    0x00},/* REG_RL2A_DVBSX_HWARE_TSSTATUS3 */
	{0xe29,    0x0f},/* REG_RL2A_DVBSX_HWARE_TSMODCOD1 */
	{0xe2a,    0x10},/* REG_RL2A_DVBSX_HWARE_TSMODCOD0 */
	{0xe30,    0x0c},/* REG_RL2A_DVBSX_HWARE_TSBITRATE1 */
	{0xe31,    0xdc},/* REG_RL2A_DVBSX_HWARE_TSBITRATE0 */
	{0xe32,    0x00},/* REG_RL2A_DVBSX_HWARE_TSPACKLEN1 */
	{0xe33,    0xed},/* REG_RL2A_DVBSX_HWARE_TSPACKLEN0 */
	{0xe34,    0x7f},/* REG_RL2A_DVBSX_HWARE_TSBLOCLEN1 */
	{0xe35,    0x44},/* REG_RL2A_DVBSX_HWARE_TSBLOCLEN0 */
	{0xe36,    0x00},/* REG_RL2A_DVBSX_HWARE_TSDLY2 */
	{0xe37,    0x00},/* REG_RL2A_DVBSX_HWARE_TSDLY1 */
	{0xe38,    0x00},/* REG_RL2A_DVBSX_HWARE_TSDLY0 */
	{0xe39,    0x00},/* REG_RL2A_DVBSX_HWARE_ISCRUNIT2 */
	{0xe3a,    0x01},/* REG_RL2A_DVBSX_HWARE_ISCRUNIT1 */
	{0xe3b,    0x00},/* REG_RL2A_DVBSX_HWARE_ISCRUNIT0 */
	{0xe3c,    0x00},/* REG_RL2A_DVBSX_HWARE_TSNPDAV */
	{0xe3d,    0x00},/* REG_RL2A_DVBSX_HWARE_TSBUFSTAT2 */
	{0xe3e,    0x00},/* REG_RL2A_DVBSX_HWARE_TSBUFSTAT1 */
	{0xe3f,    0x00},/* REG_RL2A_DVBSX_HWARE_TSBUFSTAT0 */
	{0xe40,    0x00},/* REG_RL2A_DVBSX_HWARE_TSXCROBS1 */
	{0xe41,    0x00},/* REG_RL2A_DVBSX_HWARE_TSXCROBS0 */
	{0xe42,    0xff},/* REG_RL2A_DVBSX_HWARE_TSPCR272 */
	{0xe43,    0xff},/* REG_RL2A_DVBSX_HWARE_TSPCR271 */
	{0xe44,    0xff},/* REG_RL2A_DVBSX_HWARE_TSPCR270 */
	{0xe50,    0x48},/* REG_RL2A_DVBSX_HWARE_TSDEBUG1 */
	{0xe51,    0x00},/* REG_RL2A_DVBSX_HWARE_TSDEBUG0 */
	{0xe52,    0x00},/* REG_RL2A_DVBSX_HWARE_TSOBSCFG */
	{0xe53,    0x47},/* REG_RL2A_DVBSX_HWARE_TSOBS1 */
	{0xe54,    0x1f},/* REG_RL2A_DVBSX_HWARE_TSOBS0 */
	{0xe60,    0x35},/* REG_RL2A_DVBSX_HWARE_ERRCTRL1 */
	{0xe61,    0x80},/* REG_RL2A_DVBSX_HWARE_ERRCNT12 */
	{0xe62,    0x00},/* REG_RL2A_DVBSX_HWARE_ERRCNT11 */
	{0xe63,    0x00},/* REG_RL2A_DVBSX_HWARE_ERRCNT10 */
	{0xe64,    0xc1},/* REG_RL2A_DVBSX_HWARE_ERRCTRL2 */
	{0xe65,    0x00},/* REG_RL2A_DVBSX_HWARE_ERRCNT22 */
	{0xe66,    0x00},/* REG_RL2A_DVBSX_HWARE_ERRCNT21 */
	{0xe67,    0x00},/* REG_RL2A_DVBSX_HWARE_ERRCNT20 */
	{0xe70,    0x00},/* REG_RL2A_DVBSX_HWARE_TSTTS1 */
	{0xe71,    0x00},/* REG_RL2A_DVBSX_HWARE_TSTTS2 */
	{0xe72,    0x00},/* REG_RL2A_DVBSX_HWARE_TSTTS3 */
	{0xe73,    0x00},/* REG_RL2A_DVBSX_HWARE_TSTTS4 */
	{0xe74,    0x00},/* REG_RL2A_DVBSX_HWARE_TSTTS5 */
	{0xe75,    0x00},/* REG_RL2A_DVBSX_HWARE_TSTTS6 */
	{0xe76,    0x00},/* REG_RL2A_DVBSX_HWARE_TSTTS7 */
	{0xe77,    0x00},/* REG_RL2A_DVBSX_HWARE_TSTCPLP */
	{0xe80,    0x00},/* REG_RL2A_DVBSX_HWARE_TSRCSCFG */
	{0xe81,    0x20},/* REG_RL2A_DVBSX_HWARE_TSRCSSTAT */
	{0xe82,    0x00},/* REG_RL2A_DVBSX_HWARE_TSRCSSTART5 */
	{0xe83,    0x00},/* REG_RL2A_DVBSX_HWARE_TSRCSSTART4 */
	{0xe84,    0x00},/* REG_RL2A_DVBSX_HWARE_TSRCSSTART3 */
	{0xe85,    0x00},/* REG_RL2A_DVBSX_HWARE_TSRCSSTART2 */
	{0xe86,    0x02},/* REG_RL2A_DVBSX_HWARE_TSRCSSTART1 */
	{0xe87,    0x00},/* REG_RL2A_DVBSX_HWARE_TSRCSSTART0 */
	{0xe88,    0x00},/* REG_RL2A_DVBSX_HWARE_TSRCSEND5 */
	{0xe89,    0x00},/* REG_RL2A_DVBSX_HWARE_TSRCSEND4 */
	{0xe8a,    0x00},/* REG_RL2A_DVBSX_HWARE_TSRCSEND3 */
	{0xe8b,    0x00},/* REG_RL2A_DVBSX_HWARE_TSRCSEND2 */
	{0xe8c,    0x02},/* REG_RL2A_DVBSX_HWARE_TSRCSEND1 */
	{0xe8d,    0x00},/* REG_RL2A_DVBSX_HWARE_TSRCSEND0 */
	{0xe8f,    0x00},/* REG_RL2A_DVBSX_HWARE_TSRCSPRE */
	{0xe90,    0x66},/* REG_RL2A_DVBSX_HWARE_TSRCSTIME5 */
	{0xe91,    0x0b},/* REG_RL2A_DVBSX_HWARE_TSRCSTIME4 */
	{0xe92,    0x11},/* REG_RL2A_DVBSX_HWARE_TSRCSTIME3 */
	{0xe93,    0xe2},/* REG_RL2A_DVBSX_HWARE_TSRCSTIME2 */
	{0xe94,    0x00},/* REG_RL2A_DVBSX_HWARE_TSRCSTIME1 */
	{0xe95,    0xd9},/* REG_RL2A_DVBSX_HWARE_TSRCSTIME0 */
	{0xec0,    0x00},/* REG_RL2A_DVBSX_HWARE_SFDILSTK1 */
	{0xec1,    0x00},/* REG_RL2A_DVBSX_HWARE_SFDILSTK0 */
	{0xec2,    0x46},/* REG_RL2A_DVBSX_HWARE_SFSTATUS */
	{0xec3,    0x80},/* REG_RL2A_DVBSX_HWARE_SFDLY2 */
	{0xec4,    0x00},/* REG_RL2A_DVBSX_HWARE_SFDLY1 */
	{0xec5,    0x00},/* REG_RL2A_DVBSX_HWARE_SFDLY0 */
	{0xec6,    0x00},/* REG_RL2A_DVBSX_HWARE_SFDLYSET2 */
	{0xec7,    0x6b},/* REG_RL2A_DVBSX_HWARE_SFDLYSET1 */
	{0xec8,    0x64},/* REG_RL2A_DVBSX_HWARE_SFDLYSET0 */
	{0xec9,    0x00},/* REG_RL2A_DVBSX_HWARE_SFOBSCFG */
	{0xeca,    0x47},/* REG_RL2A_DVBSX_HWARE_SFOBS1 */
	{0xecb,    0x05},/* REG_RL2A_DVBSX_HWARE_SFOBS0 */
	{0xecc,    0x30},/* REG_RL2A_DVBSX_HWARE_SFECINFO */
	{0xed0,    0x94},/* REG_RL2A_DVBSX_HWARE_SFERRCTRL */
	{0xed1,    0x80},/* REG_RL2A_DVBSX_HWARE_SFERRCNT2 */
	{0xed2,    0x00},/* REG_RL2A_DVBSX_HWARE_SFERRCNT1 */
	{0xed3,    0x00},/* REG_RL2A_DVBSX_HWARE_SFERRCNT0 */
	{0xed8,    0x00},/* REG_RL2A_DVBSX_HWARE_TSTTSSF1 */
	{0xed9,    0x00},/* REG_RL2A_DVBSX_HWARE_TSTTSSF2 */
	{0xeda,    0x00},/* REG_RL2A_DVBSX_HWARE_TSTTSSF3 */
	{0xf00,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_PDELCTRL0 */
	{0xf01,    0x20},/* REG_RL2A_DVBSX_PKTDELIN_PDELCTRL1 */
	{0xf02,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_PDELCTRL2 */
	{0xf03,    0x01},/* REG_RL2A_DVBSX_PKTDELIN_PDELCTRL3 */
	{0xf04,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_PDELCTRL4 */
	{0xf05,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_BBHCTRL1 */
	{0xf06,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_BBHCTRL2 */
	{0xf07,    0x41},/* REG_RL2A_DVBSX_PKTDELIN_HYSTTHRESH */
	{0xf08,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_ISIENTRY */
	{0xf09,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_ISIBITENA */
	{0xf0c,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_PDELDBGM */
	{0xf0d,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_PDELDBGL */
	{0xf10,    0xf0},/* REG_RL2A_DVBSX_PKTDELIN_MATCST1 */
	{0xf11,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_MATCST0 */
	{0xf12,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_UPLCST1 */
	{0xf13,    0x77},/* REG_RL2A_DVBSX_PKTDELIN_UPLCST0 */
	{0xf14,    0xff},/* REG_RL2A_DVBSX_PKTDELIN_DFLCST1 */
	{0xf15,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_DFLCST0 */
	{0xf16,    0x47},/* REG_RL2A_DVBSX_PKTDELIN_SYNCCST */
	{0xf17,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_SYNCDCST1 */
	{0xf18,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_SYNCDCST0 */
	{0xf20,    0xf0},/* REG_RL2A_DVBSX_PKTDELIN_MATSTR1 */
	{0xf21,    0xe0},/* REG_RL2A_DVBSX_PKTDELIN_MATSTR0 */
	{0xf22,    0x05},/* REG_RL2A_DVBSX_PKTDELIN_UPLSTR1 */
	{0xf23,    0x80},/* REG_RL2A_DVBSX_PKTDELIN_UPLSTR0 */
	{0xf24,    0x7d},/* REG_RL2A_DVBSX_PKTDELIN_DFLSTR1 */
	{0xf25,    0x80},/* REG_RL2A_DVBSX_PKTDELIN_DFLSTR0 */
	{0xf26,    0x47},/* REG_RL2A_DVBSX_PKTDELIN_SYNCSTR */
	{0xf27,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_SYNCDSTR1 */
	{0xf28,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_SYNCDSTR0 */
	{0xf29,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_ISIMAXSTR */
	{0xf2a,    0xff},/* REG_RL2A_DVBSX_PKTDELIN_ISIMINSTR */
	{0xf30,    0x9c},/* REG_RL2A_DVBSX_PKTDELIN_PDELSTATUS1 */
	{0xf31,    0x10},/* REG_RL2A_DVBSX_PKTDELIN_PDELSTATUS2 */
	{0xf32,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_PDELSTATUS3 */
	{0xf34,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_BBFCRCKO1 */
	{0xf35,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_BBFCRCKO0 */
	{0xf36,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_UPCRCKO1 */
	{0xf37,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_UPCRCKO0 */
	{0xf3f,    0x00},/* REG_RL2A_DVBSX_PKTDELIN_TPKTDELIN */
	{0xf80,    0x88},/* REG_RL2A_DVBSX_FECSPY_FECSPY */
	{0xf81,    0x2c},/* REG_RL2A_DVBSX_FECSPY_FSPYCFG */
	{0xf82,    0xba},/* REG_RL2A_DVBSX_FECSPY_FSPYDATA */
	{0xf83,    0x06},/* REG_RL2A_DVBSX_FECSPY_FSPYOUT */
	{0xf84,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYBER */
	{0xf85,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYOPT */
	{0xf88,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSTATUS */
	{0xf89,    0x00},/* REG_RL2A_DVBSX_FECSPY_FGOODPACK */
	{0xf8a,    0xff},/* REG_RL2A_DVBSX_FECSPY_FPACKCNT */
	{0xf8b,    0xe9},/* REG_RL2A_DVBSX_FECSPY_FSPYMISC */
	{0xf8c,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSTATES1 */
	{0xf8d,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSTATES0 */
	{0xf90,    0x00},/* REG_RL2A_DVBSX_FECSPY_FBERCPT4 */
	{0xf91,    0x00},/* REG_RL2A_DVBSX_FECSPY_FBERCPT3 */
	{0xf92,    0x00},/* REG_RL2A_DVBSX_FECSPY_FBERCPT2 */
	{0xf93,    0x00},/* REG_RL2A_DVBSX_FECSPY_FBERCPT1 */
	{0xf94,    0x00},/* REG_RL2A_DVBSX_FECSPY_FBERCPT0 */
	{0xf95,    0x00},/* REG_RL2A_DVBSX_FECSPY_FBERERR2 */
	{0xf96,    0x00},/* REG_RL2A_DVBSX_FECSPY_FBERERR1 */
	{0xf97,    0x00},/* REG_RL2A_DVBSX_FECSPY_FBERERR0 */
	{0xf98,    0x02},/* REG_RL2A_DVBSX_FECSPY_FSPYDIST1 */
	{0xf99,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYDIST0 */
	{0xf9a,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYPCR1 */
	{0xf9b,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYPCR0 */
	{0xf9c,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYNCR1 */
	{0xf9d,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYNCR0 */
	{0xfa0,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS7 */
	{0xfa1,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS6 */
	{0xfa2,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS5 */
	{0xfa3,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS4 */
	{0xfa4,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS3 */
	{0xfa5,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS2 */
	{0xfa6,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS1 */
	{0xfa7,    0x00},/* REG_RL2A_DVBSX_FECSPY_FSPYOBS0 */
	{0xfae,    0x10},/* REG_RL2A_DVBSX_FECSPY_NCRVDESCM */
	{0xfaf,    0x00},/* REG_RL2A_DVBSX_FECSPY_NCRVDESCL */
	{0xfb0,    0x00},/* REG_RL2A_DVBSX_FECSPY_NCRVOBS3 */
	{0xfb1,    0x00},/* REG_RL2A_DVBSX_FECSPY_NCRVOBS2 */
	{0xfb2,    0x00},/* REG_RL2A_DVBSX_FECSPY_NCRVOBS1 */
	{0xfb3,    0x00},/* REG_RL2A_DVBSX_FECSPY_NCRVOBS0 */
	{0xfb4,    0x01},/* REG_RL2A_DVBSX_FECSPY_NCRVCFG */
	{0xfb5,    0x01},/* REG_RL2A_DVBSX_FECSPY_NCRVPID1 */
	{0xfb6,    0x80},/* REG_RL2A_DVBSX_FECSPY_NCRVPID0 */
	{0xfb7,    0x00},/* REG_RL2A_DVBSX_FECSPY_NCRVCFG2 */
	{0xfb8,    0x80},/* REG_RL2A_DVBSX_FECSPY_NCRVMAX1 */
	{0xfb9,    0xff},/* REG_RL2A_DVBSX_FECSPY_NCRVMAX0 */
	{0xfba,    0x7f},/* REG_RL2A_DVBSX_FECSPY_NCRVMIN1 */
	{0xfbb,    0x00},/* REG_RL2A_DVBSX_FECSPY_NCRVMIN0 */
	{0xfbc,    0xff},/* REG_RL2A_DVBSX_FECSPY_NCRVABS1 */
	{0xfbd,    0x00},/* REG_RL2A_DVBSX_FECSPY_NCRVABS0 */
	{0xfbe,    0x00},/* REG_RL2A_DVBSX_FECSPY_NCRVCPT1 */
	{0xfbf,    0x00},/* REG_RL2A_DVBSX_FECSPY_NCRVCPT0 */
	{0xffff,    0},/*table end*/
};

static struct fe_lla_lookup_t fe_l2a_s1_cn_lookup = {
	90,
	{
		{ -35, 9474 }, { -30, 9449 }, { -25, 9381 }, { -20, 9300 },
		{ -15, 9240 }, {-10, 9155 }, {-5, 9046 }, { 0, 8943 },
		{ 5, 8813 }, { 10, 8688 }, { 15, 8539 }, { 20, 8328 },
		{ 25, 8151 }, { 30, 7989 }, { 33, 7762 }, { 36, 7701 },
		{ 39, 7574 }, { 42, 7399 }, { 45, 7283 }, { 48, 7116 },
		{ 51, 6952 }, { 54, 6796 }, { 57, 6641 }, { 60, 6477 },
		{ 63, 6327 }, { 66, 6151 }, { 69, 5987 }, { 72, 5810 },
		{ 75, 5661 }, { 78, 5494 }, { 81, 5333 }, { 84, 5176 },
		{ 87, 5032 }, { 90, 4851 }, { 93, 4701 }, { 96, 4566 },
		{ 99, 4435 }, { 102, 4279 }, { 105, 4149 }, { 108, 4021 },
		{ 111, 3872 }, { 114, 3762 }, { 117, 3637 }, { 120, 3526 },
		{ 123, 3412 }, { 126, 3298 }, { 129, 3192 }, { 132, 3083 },
		{ 135, 2988 }, { 138, 2886 }, { 141, 2796 }, { 144, 2703 },
		{ 147, 2621 }, { 150, 2534 }, { 160, 2261 }, { 170, 2030 },
		{ 180, 1827 }, { 190, 1618 }, { 200, 1464 }, { 210, 1308 },
		{ 220, 1177 }, { 230, 1067 }, { 240, 964 }, { 250, 871 },
		{ 260, 785 }, { 270,  722 }, { 280, 674 }, { 290, 623 },
		{ 300, 582 }, { 310,  534 }, { 320, 515 }, { 330, 482 },
		{ 340, 458 }, { 350,  440 }, { 360, 425 }, { 370, 412 },
		{ 380, 422 }, { 390,  408 }, { 400, 383 }, { 410, 385 },
		{ 420, 376 }, { 430,  384 }, { 440, 382 }, { 450, 376 },
		{ 460, 379 }, { 470,  370 }, { 480, 381 }, { 490, 371 },
		{ 500, 371 }, { 510,  369 },
	}
};

static struct fe_lla_lookup_t fe_l2a_s2_cn_lookup = {
	90,
	{
		{ -35, 13780 }, { -30, 13393 }, { -25, 12984 },
		{ -20, 12618 }, { -15, 12265 }, { -10, 11823 },
		{ -5, 11498 }, { 0, 11034 }, { 5, 10660 },
		{ 10, 10330 }, {  15, 9828 }, { 20, 9515 },
		{ 25, 9052 }, {  30, 8613 }, { 33, 8487 },
		{ 36, 8162 }, {  39, 7956 }, { 42, 7753 },
		{ 45, 7547 }, {  48, 7328 }, { 51, 7081 },
		{ 54, 6934 }, {  57, 6702 }, { 60, 6544 },
		{ 63, 6362 }, {  66, 6141 }, { 69, 5949 },
		{ 72, 5750 }, {  75, 5669 }, { 78, 5502 },
		{ 81, 5263 }, {  84, 5047 }, { 87, 4954 },
		{ 90, 4835 }, {  93, 4637 }, { 96, 4529 },
		{ 99, 4363 }, { 102, 4231 }, { 105, 4073 },
		{ 108, 3930 }, { 111, 3830 }, { 114, 3735 },
		{ 117, 3572 }, { 120, 3487 }, { 123, 3391 },
		{ 126, 3237 }, { 129, 3114 }, { 132, 3027 },
		{ 135, 2954 }, { 138, 2847 }, { 141, 2777 },
		{ 144, 2683 }, { 147, 2553 }, { 150, 2497 },
		{ 160, 2260 }, { 170, 2011 }, { 180, 1792 },
		{ 190, 1583 }, { 200, 1461 }, { 210, 1295 },
		{ 220, 1167 }, { 230, 1050 }, { 240, 961 },
		{ 250, 884 }, { 260, 812 }, { 270, 735 },
		{ 280, 668 }, { 290, 623 }, { 300, 574 },
		{ 310, 555 }, { 320, 527 }, { 330, 495 },
		{ 340, 463 }, { 350, 460 }, { 360, 462 },
		{ 370, 430 }, { 380, 420 }, { 390, 434 },
		{ 400, 404 }, { 410, 408 }, { 420, 398 },
		{ 430, 401 }, { 440, 395 }, { 450, 400 },
		{ 460, 388 }, { 470, 419 }, { 480, 418 },
		{ 490, 403 }, { 500, 394 }, { 510, 396 },
	}
};

void demod_init_local(unsigned int symb_rate_kbs, unsigned int is_blind_scan)
{
	unsigned int reg = 0;

	do {
		if (l2a_def_val_local[reg].addr == 0xffff)
			break;

		/* for wider frequency offset when low SR. */
		if (symb_rate_kbs < (SR_LOW_THRD / 1000) && !is_blind_scan &&
			l2a_def_val_local[reg].addr == 0x9b0) {
			dvbs_wr_byte(0x9b0, 0x6);
		} else if (is_blind_scan && l2a_def_val_local[reg].addr == AUTOSR_REG) {
			dvbs_wr_byte(AUTOSR_REG, AUTOSR_OFF);
		} else {
			dvbs_wr_byte(l2a_def_val_local[reg].addr,
					l2a_def_val_local[reg].value);
		}
		reg++;
	} while (1);
}

void dvbs2_reg_initial(unsigned int symb_rate_kbs, unsigned int is_blind_scan)
{
	unsigned int tmp = 0;

	/* BW/(1+ROLLOFF)=SYMBOLRATE */
	tmp = symb_rate_kbs * ((ALIGN_24 + ADC_CLK_135M / 2) / ADC_CLK_135M);

	dvbs_wr_byte(0x9fc, (tmp >> 16) & 0xff);
	dvbs_wr_byte(0x9fd, (tmp >> 8) & 0xff);
	dvbs_wr_byte(0x9fe, tmp & 0xff);

	dvbs_wr_byte(0x9f0, (tmp >> 16) & 0xff);
	dvbs_wr_byte(0x9f1, (tmp >> 8) & 0xff);
	dvbs_wr_byte(0x9f2, tmp & 0xff);

	PR_DVBS("reg initial is_blind_scan:%d\n", is_blind_scan);
	demod_init_local(symb_rate_kbs, is_blind_scan);

	dvbs_wr_byte(0x110, 0x00);
	dvbs_wr_byte(0x111, 0x00);
	dvbs_wr_byte(0x130, 0x00);
	dvbs_wr_byte(0x120, 0x04);
}

unsigned int dvbs2_diseqc_irq_check(void)
{
	unsigned int diseq_irq_flag;
	unsigned int diseq_irq_sts;/* enum diseq_irq_flag */

	diseq_irq_flag = dvbs_rd_byte(DVBS_REG_SYS_IRQSTATUS0);
	if (diseq_irq_flag & 0x1) {
		diseq_irq_sts = dvbs_rd_byte(DVBS_REG_DISIRQSTAT);
		return diseq_irq_sts;
	} else {
		return 0;
	}
}

unsigned int dvbs2_diseqc_rx_check(void)
{
	unsigned char rx_empty = 0;
	unsigned int len_fifo = 0;

	rx_empty = dvbs_rd_byte(DVBS_REG_DISRXSTAT1) & 0x04;
	if (!rx_empty)
		len_fifo = dvbs_rd_byte(DVBS_REG_DISRXBYTES);

	return len_fifo;
}

void dvbs2_diseqc_reset(void)
{
	dvbs_write_bits(DVBS_REG_DISRXCFG, 1, 7, 1);
	dvbs_write_bits(DVBS_REG_DISRXCFG, 0, 7, 1);
}

void dvbs2_diseqc_send_irq_en(bool onoff)
{
	unsigned char val = 0;

	if (onoff) {
		/*
		 * 1:enable IRQGAPBURST interrupt
		 * 1:enable IRQFIFO64B interrupt
		 * 1:enable IRQTXEND interrupt
		 * 1:enable IRQTIMEOUT interrupt
		 * 1:enable IRQTRFINISH interrupt
		 * 1:enable IRQRXFIFO8B interrupt
		 * 1:enable IRQRXEND interrupt
		 */
		dvbs_wr_byte(DVBS_REG_DISIRQCFG, 0x1f);
		/* Enable diseqc interrupt */
		val = dvbs_rd_byte(DVBS_REG_SYS_IRQMSK0);
		dvbs_wr_byte(DVBS_REG_SYS_IRQMSK0, val | 0x1);
	} else {
		val = dvbs_rd_byte(DVBS_REG_DISIRQCFG);
		dvbs_wr_byte(DVBS_REG_DISIRQCFG, val & (~0x1f));

		/* Disable diseqc interrupt*/
		val = dvbs_rd_byte(DVBS_REG_SYS_IRQMSK0);
		dvbs_wr_byte(DVBS_REG_SYS_IRQMSK0, val & (~0x1));
	}
}

void dvbs2_diseqc_recv_irq_en(bool onoff)
{
	unsigned char val = 0;

	if (onoff) {
		/*
		 * 1:enable IRQGAPBURST interrupt
		 * 1:enable IRQFIFO64B interrupt
		 * 1:enable IRQTXEND interrupt
		 * 1:enable IRQTIMEOUT interrupt
		 * 1:enable IRQTRFINISH interrupt
		 * 1:enable IRQRXFIFO8B interrupt
		 * 1:enable IRQRXEND interrupt
		 */
		val = dvbs_rd_byte(DVBS_REG_DISIRQCFG);
		dvbs_wr_byte(DVBS_REG_DISIRQCFG, val | 0x60);
		/* Enable diseqc interrupt */
		val = dvbs_rd_byte(DVBS_REG_SYS_IRQMSK0);
		dvbs_wr_byte(DVBS_REG_SYS_IRQMSK0, val | 0x1);
	} else {
		val = dvbs_rd_byte(DVBS_REG_DISIRQCFG);
		dvbs_wr_byte(DVBS_REG_DISIRQCFG, val | (~0x60));

		/* Disable diseqc interrupt*/
		val = dvbs_rd_byte(DVBS_REG_SYS_IRQMSK0);
		dvbs_wr_byte(DVBS_REG_SYS_IRQMSK0, val & (~0x1));
	}
}

void dvbs2_diseqc_init(void)
{
	struct amldtvdemod_device_s *devp = dtvdemod_get_dev();

	/* set high resistance for diseqc input */
	dvbs_wr_byte(DVBS_REG_GPIO0CFG, 0xcc);

	/* DiSEqC transmission configuration 2:DiSEqC 2/3 */
	if (devp && devp->diseqc.lnbc.is_internal_tone)
		dvbs_wr_byte(DVBS_REG_DISTXCFG, dvbs_rd_byte(DVBS_REG_DISTXCFG) | 0x8);

	dvbs2_diseqc_continuous_tone(false);
	/* rx 22k tone, 125Mhz:b0, default 135Mhz:c0*/
	//dvbs_wr_byte(DVBS_REG_DISTXF22, 0xb0); //t5d
	/* number of bit to wait before starting the transmission */
	dvbs_wr_byte(DVBS_REG_DISTIMEOCFG, 0x84);
	/* rx 22k tone, 125Mhz:143, default 135Mhz:12b*/
	dvbs_wr_byte(DVBS_REG_DISRXF220, 0xf0);
	/* 9c for 125Mhz */
	dvbs_wr_byte(DVBS_REG_DISRXF100, 0x9c);
	/* for rx : enable rx, glitch, GPIO0  */

	dvbs_wr_byte(DVBS_REG_DISRXCFG, 0x84);
	dvbs_wr_byte(DVBS_REG_DISRXCFG, 0x4);

	/* number of bit to wait before starting the transmission */
	dvbs_wr_byte(DVBS_REG_DISTXWAIT, 0x1);
	dvbs_wr_byte(DVBS_REG_DSQADCINCFG, 0x67);
}

void dvbs2_diseqc_recv_en(bool onoff)
{
	unsigned char val = 0;

	val = dvbs_rd_byte(DVBS_REG_DISRXCFG);

	if (onoff)
		dvbs_wr_byte(DVBS_REG_DISRXCFG, val | 0x1);
	else
		dvbs_wr_byte(DVBS_REG_DISRXCFG, val & (~0x1));
}

void dvbs2_diseqc_continuous_tone(bool onoff)
{
	unsigned char val = 0;

	val = dvbs_rd_byte(DVBS_REG_DISTXCFG) & 0xfc;
	if (onoff) {
		dvbs_wr_byte(DVBS_REG_DISTXCFG, val);
	} else {
		val |= 0x2;
		dvbs_wr_byte(DVBS_REG_DISTXCFG, val);
	}
}

void dvbs2_diseqc_send_msg(unsigned int len, unsigned char *msg)
{
	unsigned int i = 0;
	unsigned int len_fifo = 0;

	dvbs2_diseqc_init();
	dvbs2_diseqc_send_irq_en(true);
	for (i = 0; i < len ; i++)
		dvbs_wr_byte(DVBS_REG_DISTXFIFO, msg[i]);
		/*PR_INFO("0x%x\n", msg[i]);*/

	len_fifo = dvbs_rd_byte(DVBS_REG_DISTXBYTES);
	/*PR_INFO("tx fifo num:0x%x\n", len_fifo);*/
}

unsigned int dvbs2_diseqc_read_msg(unsigned int len, unsigned char *msg)
{
	unsigned int i = 0;
	unsigned int len_fifo = 0;

	len_fifo = dvbs_rd_byte(DVBS_REG_DISRXBYTES);
	for (i = 0; i < len_fifo && i < len ; i++)
		msg[i] = dvbs_rd_byte(DVBS_REG_DISRXFIFO);

	return i;
}

void demod_dump_reg_diseqc(void)
{
	unsigned int i = 0;

	for (i = DVBS_REG_SYS_IRQMSK1; i <= DVBS_REG_SYS_IRQFORCE0; i++)
		PR_INFO(" diseqc reg:0x%x val:0x%x\n", i, dvbs_rd_byte(i));

	for (i = DVBS_REG_GPIO0CFG; i <= DVBS_REG_I2CMAPO20; i++)
		PR_INFO(" diseqc reg:0x%x val:0x%x\n", i, dvbs_rd_byte(i));

	for (i = DVBS_REG_DISIRQCFG; i <= DVBS_REG_ACRDIV; i++)
		PR_INFO(" diseqc reg:0x%x val:0x%x\n", i, dvbs_rd_byte(i));
}

void dvbs_check_status(struct seq_file *seq)
{
	char *roll_off;

	switch (dvbs_rd_byte(0xa05) & 0x7) {
	case 0:
		roll_off = "0.35";
		break;

	case 1:
		roll_off = "0.25";
		break;

	case 2:
		roll_off = "0.20";
		break;

	case 3:
		roll_off = "0.10";
		break;

	case 5:
		roll_off = "0.15";
		break;

	case 4:
		roll_off = "0.05";
		break;

	default:
		roll_off = "Unknown Roll Off";
		break;
	}

	if (seq) {
		seq_printf(seq, "Roll Off:%s,SNR 0x%x,0x152=0x%x,0x153=0x%x,TS_ok:%d\n",
			roll_off,
			(dvbs_rd_byte(CNR_HIGH) << 8) | dvbs_rd_byte(CNR_LOW), dvbs_rd_byte(0x152),
			dvbs_rd_byte(0x153), (dvbs_rd_byte(0x160) >> 3) & 0x1);
		seq_printf(seq, "PER1:%d,PER2:%d\n",
			((dvbs_rd_byte(0xe61) & 0x7f)  << 16) +
			((dvbs_rd_byte(0xe62) & 0xff) << 8) +
			(dvbs_rd_byte(0xe63) & 0xff),
			((dvbs_rd_byte(0xe65) & 0x7f)  << 16) +
			((dvbs_rd_byte(0xe66) & 0xff) << 8) +
			(dvbs_rd_byte(0xe67) & 0xff));
	} else {
		PR_DVBS("Roll Off:%s,SNR 0x%x,0x152=0x%x,0x153=0x%x,TS_ok:%d\n",
			roll_off,
			(dvbs_rd_byte(CNR_HIGH) << 8) | dvbs_rd_byte(CNR_LOW), dvbs_rd_byte(0x152),
			dvbs_rd_byte(0x153), (dvbs_rd_byte(0x160) >> 3) & 0x1);
		PR_DVBS("PER1:%d,PER2:%d\n",
			((dvbs_rd_byte(0xe61) & 0x7f)  << 16) +
			((dvbs_rd_byte(0xe62) & 0xff) << 8) +
			(dvbs_rd_byte(0xe63) & 0xff),
			((dvbs_rd_byte(0xe65) & 0x7f)  << 16) +
			((dvbs_rd_byte(0xe66) & 0xff) << 8) +
			(dvbs_rd_byte(0xe67) & 0xff));
	}
}

unsigned int dvbs_get_quality(void)
{
	unsigned int noisefield1, noisefield0;
	unsigned int c_n = -100, regval, imin, imax, i;
	unsigned int fld_value[2];
	struct fe_lla_lookup_t *lookup;

	if ((dvbs_rd_byte(0x932) & 0x60) >> 5 == 0x2) {
		lookup = &fe_l2a_s2_cn_lookup;
		//If DVBS2 use PLH normalized noise indicators
		noisefield1 = 0xaa4;
		noisefield0 = 0xaa5;
	} else {
		lookup = &fe_l2a_s1_cn_lookup;
		//if not DVBS2 use symbol normalized noise indicators
		noisefield1 = 0xaa0;
		noisefield0 = 0xaa1;
	}

	fld_value[0] = dvbs_rd_byte(0x934) & 0x08;
	if (fld_value[0]) {
		if (lookup->size) {
			regval = 0;
			for (i = 0; i < 8; i++) {
				fld_value[0] = dvbs_rd_byte(noisefield1) & 0xff;
				fld_value[1] = dvbs_rd_byte(noisefield0) & 0xff;
				regval += (fld_value[0] << 8) + fld_value[1];
			}
			regval /= 8;
			imin = 0;
			imax = lookup->size - 1;
			if ((lookup->table[imin].regval <= regval &&
				regval <= lookup->table[imax].regval) ||
				(lookup->table[imin].regval >= regval &&
				regval >= lookup->table[imax].regval)) {
				while ((imax - imin) > 1) {
					i = (imax + imin) >> 1;
					if ((lookup->table[imin].regval <= regval &&
						regval <= lookup->table[i].regval) ||
						(lookup->table[imin].regval >= regval &&
						regval >= lookup->table[i].regval))
						imax = i;
					else
						imin = i;
				}

				c_n = ((regval - lookup->table[imin].regval) *
				(lookup->table[imax].realval - lookup->table[imin].realval) /
				(lookup->table[imax].regval - lookup->table[imin].regval)) +
				lookup->table[imin].realval;
			} else if (regval < lookup->table[imin].regval) {
				c_n = 1000;
			}
		}
	}
	return c_n;
}

unsigned int dvbs_get_freq_offset(unsigned int *polarity)
{
	unsigned int carrier_offset = 0, freq_offset = 0;

	carrier_offset = dvbs_rd_byte(CFR12) << 16;
	carrier_offset |= dvbs_rd_byte(CFR11) << 8;
	carrier_offset |= dvbs_rd_byte(CFR10);

	*polarity = carrier_offset >> 23 & 0x1;
	/* negative val, convert to original code */
	if (*polarity) {
		carrier_offset ^= 0xffffff;
		carrier_offset += 1;
	}

	/* fre offset = carrier_offset * Fs(adc) / 2^24 */
	freq_offset = carrier_offset * (ADC_CLK_135M / 1000); //ADC_CLK_135M
	freq_offset = (freq_offset + ALIGN_24 / 2000) / (ALIGN_24 / 1000);

	PR_DVBS("%s: polarity %d, carrier_offset 0x%x, freq_offset %dKHz.\n",
		__func__, *polarity, carrier_offset, freq_offset);

	return freq_offset;
}

unsigned int dvbs_get_symbol_rate(void)
{
#ifdef DVBS_NEW_GET_SR
	unsigned int value = 0, sr_kbps = 0;
	unsigned int samples = 0, clock = 0;
	unsigned int value_h = 0, value_l = 0, clock_h = 0, clock_l = 0;

	value = dvbs_rd_byte(0x9fc) << 24;
	value |= dvbs_rd_byte(0x9fd) << 16;
	value |= dvbs_rd_byte(0x9fe) << 8;
	value |= dvbs_rd_byte(0x9ff);

	samples = dvbs_rd_byte(0x94a) & 0x1f;
	clock = samples * ADC_CLK_135M * 1000;

	clock_h = clock >> 16;
	value_h = value >> 16;
	clock_l = clock & 0xffff;
	value_l = value & 0xffff;

	sr_kbps = (clock_h * value_h) +
			((clock_h * value_l) >> 16) +
			((value_h * clock_l) >> 16);

	PR_INFO("%s: value 0x%0x, samples 0x%x, clock %d, sr_kbps %d bps.\n",
			__func__, value, samples, clock, sr_kbps);

	return (sr_kbps / 1000);
#else
	unsigned int value = 0, sr_kbps = 0;

	value = dvbs_rd_byte(0x9fc) << 16;
	value |= dvbs_rd_byte(0x9fd) << 8;
	value |= dvbs_rd_byte(0x9fe);
	value = value * (ADC_CLK_135M / 1000);

	sr_kbps = (value + ALIGN_24 / 2000) / (ALIGN_24 / 1000);

	PR_INFO("%s: value %d, sr_kbps %d Kbps.\n", __func__, value, sr_kbps);

	return sr_kbps;
#endif
}

#define SIGNAL_STRENGTH_READ_TIMES 50
static unsigned char s_aStrengthVal[] = {
	0xd3,
	0xd5, 0xd2, 0xd0, 0xce, 0xcb,
	0xc8, 0xc5, 0xc2, 0xbe, 0xb9,
	0xb4, 0xad, 0xa7, 0xa3, 0xa1,
	0x9e, 0x9c, 0x99, 0x97, 0x94,
	0x91, 0x8b, 0x8e, 0x87, 0x83,
	0x7e, 0x79, 0x73, 0x68
};

int dvbs_get_signal_strength_off(void)
{
	int i;
	unsigned int val = 0;

	for (i = 0; i < SIGNAL_STRENGTH_READ_TIMES; i++)
		val += dvbs_rd_byte(0x91a);
	val /= SIGNAL_STRENGTH_READ_TIMES;

	for (i = 1; i < sizeof(s_aStrengthVal); i++) {
		if (val >= s_aStrengthVal[i])
			break;
	}

	PR_DVBS("average value level val=0x%x\n", val);

	return -i;
}

void dvbs_fft_reg_init(unsigned int *reg_val)
{
	unsigned int fld_value;
	int i = 0;

	fld_value = (dvbs_rd_byte(0x8c0)) & 0x1;
	reg_val[i++] = fld_value;
	fld_value = ((dvbs_rd_byte(0x942)) & 0xc0) >> 6;
	reg_val[i++] = fld_value;
	fld_value = ((dvbs_rd_byte(0x940)) & 0xc0) >> 6;
	reg_val[i++] = fld_value;
	fld_value = (dvbs_rd_byte(0x924)) & 0x1f;
	reg_val[i++] = fld_value;
	fld_value = ((dvbs_rd_byte(0xb31)) & 0x80) >> 7;
	reg_val[i++] = fld_value;

	fld_value = ((dvbs_rd_byte(0x9a3)) & 0x80) >> 7;
	reg_val[i++] = fld_value;
	fld_value = ((dvbs_rd_byte(0x99f)) & 0x80) >> 7;
	reg_val[i++] = fld_value;
	fld_value = (dvbs_rd_byte(0x990)) & 0x7;
	reg_val[i++] = fld_value;

	fld_value = dvbs_rd_byte(0x970);
	reg_val[i++] = fld_value;
	fld_value = dvbs_rd_byte(0x971);
	reg_val[i++] = fld_value;
	fld_value = dvbs_rd_byte(0x9a0);
	reg_val[i++] = fld_value;
	fld_value = dvbs_rd_byte(0x9a1);
	reg_val[i++] = fld_value;

	fld_value = ((dvbs_rd_byte(0x8c0)) & 0x3c) >> 2;
	reg_val[i++] = fld_value;
	fld_value = (dvbs_rd_byte(0x8c5)) & 0xff;
	reg_val[i++] = fld_value;
	fld_value = ((dvbs_rd_byte(0x8c0)) & 0x40) >> 6;
	reg_val[i++] = fld_value;

	fld_value = dvbs_rd_byte(0x8c1);
	reg_val[i++] = fld_value;
	fld_value = dvbs_rd_byte(0x8c4);
	reg_val[i++] = fld_value;
	fld_value = dvbs_rd_byte(0x8c3);
	reg_val[i++] = fld_value;
	fld_value = dvbs_rd_byte(0x8ec);
	reg_val[i++] = fld_value;

	dvbs_write_bits(0x942, 0x01, 6, 2);
	dvbs_write_bits(0x940, 0x01, 6, 2);
	dvbs_write_bits(0x924, 0x02, 0, 5);//demod_mode
	dvbs_write_bits(0xb31, dvbs_iq_swap ? 1 : 0, 7, 1);
	dvbs_write_bits(0x8a1, 0x02, 4, 2);
	/* Agc blocked */
	dvbs_write_bits(0x9a3, 0x1, 7, 1);
	dvbs_write_bits(0x99f, 0x1, 7, 1);
	dvbs_write_bits(0x990, 0x0, 0, 3);

	dvbs_write_bits(0x970, 0x1, 0, 1);
	dvbs_write_bits(0x970, 0x1, 1, 1);
	dvbs_write_bits(0x970, 0x1, 2, 1);

	dvbs_write_bits(0x971, 0x0, 0, 2);
	dvbs_write_bits(0x971, 0x0, 2, 2);
	dvbs_write_bits(0x971, 0x0, 4, 2);

	dvbs_wr_byte(0x9a0, 0x40);
	dvbs_wr_byte(0x9a1, 0x42);

	/* fft reading registers adjustment */
	dvbs_write_bits(0x8c0, 0x1, 2, 4); // input mode  1-cte 2-z4
	dvbs_write_bits(0x8c5, 0x2, 0, 8);
	dvbs_write_bits(0x8c0, 0x0, 6, 1);

	dvbs_write_bits(0x8c1, 0x0, 0, 3);
	dvbs_write_bits(0x8c1, 0x1, 3, 1);
	dvbs_write_bits(0x8c1, 0x4, 4, 3);//cte mode
	dvbs_write_bits(0x8c1, 0x0, 7, 1);

	dvbs_write_bits(0x8c4, 0x2, 0, 7);
	dvbs_write_bits(0x8c4, 0x0, 7, 1);

	dvbs_write_bits(0x8c3, 0x4, 0, 4);//MAX_THRESHOLD
	dvbs_write_bits(0x8c3, 0x0, 4, 1);//NO_STOP

	dvbs_write_bits(0x8ec, 0x0, 0, 1);
	dvbs_write_bits(0x8ec, 0x0, 1, 1);
	dvbs_write_bits(0x8ec, 0x0, 2, 1);
	dvbs_write_bits(0x8ec, 0x1, 3, 1);
	dvbs_write_bits(0x8ec, 0x0, 4, 1);
	dvbs_write_bits(0x8ec, 0x1, 5, 1);
	dvbs_write_bits(0x8ec, 0x0, 6, 1);

	dvbs_write_bits(0x9a3, 0x88, 0, 7);
	dvbs_write_bits(0x99f, 0x56, 0, 7);

	dvbs_wr_byte(0x990, 0x0);
	dvbs_write_bits(0x912, 0x0, 0, 3);
	dvbs_write_bits(0x910, 0x1, 5, 1);
	dvbs_write_bits(0x910, 0x1, 3, 1);
	dvbs_wr_byte(0x913, 0x58);
	dvbs_write_bits(0x912, 0x0, 0, 3);

	dvbs_wr_byte(0x918, 0x00);
	dvbs_wr_byte(0x919, 0x00);
	dvbs_wr_byte(0x993, 0x02);
	dvbs_wr_byte(0x9b1, 0x00);
	dvbs_wr_byte(0x9b2, 0x00);
	dvbs_wr_byte(0x9b3, 0x00);
	dvbs_wr_byte(0x9b5, 0x00);
	dvbs_wr_byte(0x9b6, 0x00);
	dvbs_wr_byte(0x9ba, 0x00);
	dvbs_wr_byte(0x9d7, 0x00);

	dvbs_wr_byte(0x9d8, 0x00);
	dvbs_wr_byte(0x9d9, 0x00);
	dvbs_wr_byte(0x9e0, 0xc3);
	dvbs_wr_byte(0x9e1, 0x00);
	dvbs_wr_byte(0xa00, 0x00);
	dvbs_wr_byte(0xa01, 0x00);
	dvbs_wr_byte(0xa02, 0x00);
	dvbs_wr_byte(0xa61, 0x00);
	dvbs_wr_byte(0xa63, 0x00);
	dvbs_wr_byte(0xa64, 0x00);
	dvbs_wr_byte(0xa65, 0x00);
	msleep(100);
}

void dvbs_fft_reg_term(unsigned int reg_val[60])
{
	int i = 0;

	/* Restore params */
	dvbs_write_bits(0x8c0, reg_val[i++], 0, 1);
	dvbs_write_bits(0x942, reg_val[i++], 6, 2);
	dvbs_write_bits(0x940, reg_val[i++], 6, 2);
	dvbs_write_bits(0x924, reg_val[i++], 0, 5);//demod_mode
	dvbs_write_bits(0xb31, reg_val[i++], 7, 1);

	dvbs_write_bits(0x9a3, reg_val[i++], 7, 1);
	dvbs_write_bits(0x99f, reg_val[i++], 7, 1);
	dvbs_write_bits(0x990, reg_val[i++], 0, 3);

	dvbs_wr_byte(0x970, reg_val[i++]);
	dvbs_wr_byte(0x971, reg_val[i++]);

	dvbs_wr_byte(0x9a0, reg_val[i++]);
	dvbs_wr_byte(0x9a1, reg_val[i++]);

	dvbs_write_bits(0x8c0, reg_val[i++], 2, 4);
	dvbs_write_bits(0x8c5, reg_val[i++], 0, 8);
	dvbs_write_bits(0x8c0, reg_val[i++], 6, 1);

	dvbs_wr_byte(0x8c1, reg_val[i++]);
	dvbs_wr_byte(0x8c4, reg_val[i++]);
	dvbs_wr_byte(0x8c3, reg_val[i++]);
	dvbs_wr_byte(0x8ec, reg_val[i++]);
	// Forbid the use of RAMs by the UFBS
	dvbs_write_bits(0x8a1, 0, 4, 2);
}

void fe_l2a_set_symbol_rate(unsigned int symb_rate)
{
	unsigned int tmp = 0;

	tmp = (symb_rate / 1000) * (1 << 15);
	tmp = tmp / ADC_CLK_135M;
	tmp = tmp * (1 << 9);
	PR_DVBS("1 tmp: %d, symb_rate: %d.\n", tmp, symb_rate);

	//tmp = symb_rate / 1000 * ((ALIGN_24 + ADC_CLK_135M / 2) / ADC_CLK_135M);
	//PR_DVBS("2 tmp: %d, symb_rate: %d.\n", tmp, symb_rate);

	dvbs_wr_byte(0x9f0, (tmp >> 16) & 0xff);
	dvbs_wr_byte(0x9f1, (tmp >> 8) & 0xff);
	dvbs_wr_byte(0x9f2, tmp & 0xff);

	// read back from register for checking
	//tmp = ((dvbs_rd_byte(0x9f0) & 0xff) << 16);
	//tmp = tmp | ((dvbs_rd_byte(0x9f1) & 0xff) << 8);
	//tmp = tmp | (dvbs_rd_byte(0x9f2) & 0xff);

	//PR_DVBS("3 tmp: %d, symb_rate: %d.\n", tmp, symb_rate);
}

void dvbs_blind_fft_work(struct fft_threadcontrols *spectr_ana_data,
	int frq, struct fft_search_result *search_result)
{
	unsigned int frc_demod_set = 0;
	unsigned int fld_value = 0;
	unsigned int contmode = 0;
	int cte_freq_ok = 0;
	int timeout = 0;
	int range_m = 0;
	int bin_max = 0;

	dvbs_write_bits(0x8c1, spectr_ana_data->mode, 0, 3);
	dvbs_write_bits(0x8c2, spectr_ana_data->acc, 0, 8);
	dvbs_write_bits(0x8c0, 0x1, 0, 1);//UFBS_ENABLE

	frc_demod_set = frq * ALIGN_24 / (ADC_CLK_135M / 1000);
	dvbs_wr_byte(0x9c3, ((char)(frc_demod_set >> 16)));
	dvbs_wr_byte(0x9c4, ((char)(frc_demod_set >> 8)));
	dvbs_wr_byte(0x9c5, (char)frc_demod_set);

	// Set bandwidth
	fe_l2a_set_symbol_rate(2 * spectr_ana_data->range * 1000000);

	// start acquisition
	dvbs_write_bits(0x8c0, 0x1, 1, 1);
	msleep(20);
	dvbs_write_bits(0x8c0, 0x0, 1, 1);

	fld_value = (dvbs_rd_byte(0x8c4) & 0x80) >> 7;
	if (!fld_value) {
		contmode = (dvbs_rd_byte(0x8c6)) & 0x1;
		while ((contmode != 1) && (timeout < 40)) {
			contmode = (dvbs_rd_byte(0x8c6)) & 0x1;
			timeout = timeout + 1;
			msleep(20);
		}
	}

	//change range from hz to M
	range_m = spectr_ana_data->range;
	//search_result->result_cfo_est = (dvbs_rd_byte(0x8da) << 8) + dvbs_rd_byte(0x8db);
	//indicates the bin of the highest peak
	bin_max = (dvbs_rd_byte(0x8c8) << 8) + dvbs_rd_byte(0x8c9);

	if (bin_max > 4095)
		bin_max = bin_max - 8191;
	search_result->result_bw = range_m * 2000 * (8192 - bin_max) / 8192;
	cte_freq_ok = ((dvbs_rd_byte(0x8c6)) & 0x10) >> 4;

	if (cte_freq_ok == 1) {
		if ((search_result->result_bw < 1100 * range_m * 2) &
			(search_result->result_bw > 550 * range_m * 2)) {
			if (bin_max >= 0) {
				search_result->result_frc = spectr_ana_data->in_bw_center_frc - frq;
				search_result->found_ok = 1;
			} else if ((bin_max < 0) & (search_result->result_bw >= (range_m * 2000)) &
				((abs(bin_max * 10) / 8192) < 1)) {
				search_result->result_frc = spectr_ana_data->in_bw_center_frc - frq;
				search_result->found_ok = 1;
			} else {
				search_result->found_ok = 0;
			}
		} else {
			search_result->found_ok = 0;
		}
	} else {
		search_result->found_ok = 0;
	}

	// Empty hardware fft
	dvbs_write_bits(0x8ed, 0x0, 0, 3);
	dvbs_wr_byte(0x8ee, 0x0);
	// Sleep down hardware fft
	dvbs_write_bits(0x8c0, 0x1, 1, 1);
}

void dvbs_blind_fft_result_handle(struct fft_total_result *result)
{
	int m = 0;
	int n = 0;
	unsigned int frc_data_tmp = 0;
	unsigned int bw_data_tmp = 0;

	for (m = 0; m < (result->tp_num - 1); m++) {
		for (n = 0; n < (result->tp_num - 1 - m); n++) {
			if (result->freq[n] > result->freq[n + 1]) {
				frc_data_tmp = result->freq[n];
				result->freq[n] = result->freq[n + 1];
				result->freq[n + 1] = frc_data_tmp;

				bw_data_tmp = result->bw[n];
				result->bw[n] = result->bw[n + 1];
				result->bw[n + 1] = bw_data_tmp;
			}
		}
	}
}

unsigned int fe_l2a_get_AGC2_accu(void)
{
	unsigned int AGC2_accu = 0;
	unsigned int mantissa = 0;
	int exponent = 0;
	unsigned int AGC2I1 = 0, AGC2I0 = 0;
#ifdef DVBS_BLIND_SCAN_DEBUG
	unsigned int fld_value[2] = { 0 };

	fld_value[0] = dvbs_rd_byte(0x9a0);
	fld_value[1] = (dvbs_rd_byte(0x9a1) & 0xc0) >> 6;
	mantissa = fld_value[1] + (fld_value[0] << 2);
	fld_value[0] = dvbs_rd_byte(0x9a1) & 0x3f;
	exponent = (int)(fld_value[0] - 4); //5 - 9

	if (exponent >= 0)
		AGC2_accu = mantissa * (1 << exponent);

	PR_DVBS("1 AGC2_accu: %d(0x%x), mantissa: %d, exponent: %d.\n",
			AGC2_accu, AGC2_accu, mantissa, exponent);

	/* Georg's method */
	fld_value[0] = dvbs_rd_byte(0x9a0);
	fld_value[1] = (dvbs_rd_byte(0x9a1) & 0xc0) >> 6;
	mantissa = ((fld_value[0] << 8) | fld_value[1]) >> 6;
	exponent = (int)((dvbs_rd_byte(0x9a1) & 0x3f) - 9);

	if (exponent >= 0)
		AGC2_accu = mantissa * (1 << exponent);

	PR_DVBS("2 AGC2_accu: %d(0x%x), mantissa: %d, exponent: %d.\n",
			AGC2_accu, AGC2_accu, mantissa, exponent);
#endif
	/* Damien's method */
	/*************** calculate AGC2 **************************/
	/* Agc2 = (AGC2I1 * 4 + AGC2I1) * 2^X toPowerY (exp - 9) */
	/* exp min = 5, max = 15                                 */
	/* so (exp - 9) min = -4, max = 6                        */
	/*********************************************************/
	AGC2I1 = dvbs_rd_byte(0x9a0);
	AGC2I0 = dvbs_rd_byte(0x9a1);
	mantissa = ((AGC2I1 * 4) + ((AGC2I0 >> 6) & 0x3)) & 0xffff;
	exponent = AGC2I0 & 0x3f;

	/* divide the mantissa by 2^abs(exponent - 9) */
	exponent = exponent - 9;
	if (exponent < 0) {
		AGC2_accu = 2 << abs(exponent);
		AGC2_accu = (1000 * mantissa) / AGC2_accu;
	} else {
		AGC2_accu = 2 << exponent;
		AGC2_accu = (1000 * mantissa) * AGC2_accu;
	}

	PR_DVBS("3 AGC2_accu: %d(0x%x), mantissa: %d, exponent: %d.\n",
		AGC2_accu, AGC2_accu, mantissa, exponent);

	return AGC2_accu;
}

unsigned int dvbs_blind_check_AGC2_bandwidth_new(int *next_step_khz)
{
	struct amldtvdemod_device_s *devp = dtvdemod_get_dev();
	int i = 0, j = 0, k = 0, l = 0, m = 0, n = 0;
	int nb_steps = 0, init_freq = 0, freq_step = 0;
	unsigned int tmp1 = 0, tmp2 = 0, tmp3 = 0;
	unsigned int agc2_level = 0, agc2_ratio = 0, accu_level = 0;
	unsigned int min_agc2_level = 0, max_agc2_level = 0, mid_agc2_level = 0;
	unsigned int agc2_level_tab[20] = { 0 };
	unsigned char div = 2, wait_for_fall = 0;
	unsigned int asperity = 0;
#ifdef DVBS_BLIND_SCAN_DEBUG
	int tmp = 0;
#endif

	dvbs_wr_byte(0x924, 0x1c); //demod stop
	tmp2 = dvbs_rd_byte(0x9b0);
	dvbs_wr_byte(0x9b0, 0x6);

	tmp3 = dvbs_rd_byte(0x9b5);
	dvbs_wr_byte(0x9b5, 0x00);
	dvbs_wr_byte(0x991, 0x40); //default 0x38

	tmp1 = dvbs_rd_byte(0x922);
	dvbs_write_bits(0x922, 1, 6, 1);
	dvbs_write_bits(0x922, 1, 7, 1);
	/* Enable the SR SCAN */
	dvbs_write_bits(0x922, 0, 4, 1);
	/* activate the carrier frequency search loop */
	dvbs_write_bits(0x922, 0, 3, 1);

	/* AGC2 bandwidth * 0.5M */
	fe_l2a_set_symbol_rate(1000000 / div);

	nb_steps = (45000000 / 2000000) * div;
	//if (nb_steps <= 0)
	//	nb_steps = 1;

	/* AGC2 step is 1 / div MHz */
	//freq_step = 1000 * ((ALIGN_24 + ADC_CLK_135M / 2) / ADC_CLK_135M) / div;
	//PR_DVBS("1 freq_step: %d\n", freq_step);
	freq_step = ((1000000 << 8) / ((ADC_CLK_135M * 1000) >> 8)) / div;
	freq_step = freq_step << 8;
	PR_DVBS("2 freq_step: %d\n", freq_step);

	init_freq = 0 - (freq_step * nb_steps);

	for (i = 0; i < nb_steps * 2; ++i) {
		if (devp->blind_scan_stop)
			break;

		PR_DVBS("init_freq: %d, freq_step: %d, nb_steps: %d.\n",
				init_freq, freq_step, nb_steps);

		dvbs_wr_byte(0x924, 0x1c);

		dvbs_wr_byte(0x9c3, (init_freq >> 16) & 0xff);
		dvbs_wr_byte(0x9c4, (init_freq >> 8) & 0xff);
		dvbs_wr_byte(0x9c5, init_freq  & 0xff);
#ifdef DVBS_BLIND_SCAN_DEBUG
		tmp = ((dvbs_rd_byte(0x9c3) & 0xff) << 16) |
				((dvbs_rd_byte(0x9c4) & 0xff) << 8) |
				(dvbs_rd_byte(0x9c5) & 0xff);
		if (tmp & 0x800000)
			tmp = (((~tmp) & 0x7fffff) + 1) * (-1);

		PR_DVBS("get hw carrier_freq1 = %d.\n", tmp);
#endif
		dvbs_wr_byte(0x924, 0x18); //Warm start
		usleep_range(5 * 1000, 6 * 1000);//msleep(5);

		agc2_level = fe_l2a_get_AGC2_accu();
		if (agc2_level > 0x1fffff)
			agc2_level = 0x1fffff;

		PR_DVBS("agc2_level: %d(0x%x), i: %d, j: %d.\n",
				agc2_level, agc2_level, i, j);

		if (i == 0) {
			//min_agc2_level = agc2_level;
			//max_agc2_level = agc2_level;
			//mid_agc2_level = agc2_level;

			for (l = 0; l < 10 * div; ++l)
				agc2_level_tab[l] = agc2_level;

		} else {
			k = i % (10 * div);
			agc2_level_tab[k] = agc2_level;

			min_agc2_level = 0x3fffff;
			max_agc2_level = 0x0000;
			accu_level = 0;

			/* Min and max detection */
			for (l = 0; l < 10 * div; ++l) {
				if (agc2_level_tab[l] < min_agc2_level)
					min_agc2_level = agc2_level_tab[l];

				if (agc2_level_tab[l] > max_agc2_level)
					max_agc2_level = agc2_level_tab[l];

				accu_level = accu_level + agc2_level_tab[l];
			}

			mid_agc2_level = accu_level / (10 * div);

			if (!wait_for_fall) {
				agc2_ratio = (max_agc2_level - min_agc2_level) * 128;
				agc2_ratio = agc2_ratio / mid_agc2_level;
			} else {
				agc2_ratio = (agc2_level - min_agc2_level) * 128;
				agc2_ratio = agc2_ratio / mid_agc2_level;
			}

			if (agc2_ratio > 0xffff)
				agc2_ratio = 0xffff;

			PR_DVBS("i: %d, j: %d.\n", i, j);
			PR_DVBS("agc2_level     %d.\n", agc2_level);
			PR_DVBS("max_agc2_level %d.\n", max_agc2_level);
			PR_DVBS("min_agc2_level %d.\n", min_agc2_level);
			PR_DVBS("mid_agc2_level %d.\n", mid_agc2_level);
			PR_DVBS("agc2_ratio     %d.\n", agc2_ratio);

			if (agc2_ratio > BLIND_SEARCH_AGC2BANDWIDTH_80 &&
				agc2_level == min_agc2_level &&
				agc2_level < BLIND_SEARCH_POW_TH) {
				/* rising edge */

				PR_DVBS("Find first edge is rising ...\n");
				PR_DVBS("agc2_ratio 0x%x, min_agc2_level 0x%x, agc2_level 0x%x).\n",
						agc2_ratio, min_agc2_level, agc2_level);

				/* The first edge is rising */
				//asperity = 1;
				wait_for_fall = 1;
				j = 0;

			PR_DVBS("rising: i %d, j %d, m %d, n %d, asperity %d, init_freq %d.\n",
					i, j, m, n, asperity, init_freq);

				for (l = 0; l < 10 * div; l++)
					agc2_level_tab[l] = agc2_level;

			} else if (agc2_ratio > BLIND_SEARCH_AGC2BANDWIDTH_80 &&
				min_agc2_level < BLIND_SEARCH_POW_TH &&
				agc2_level == max_agc2_level && 1 == wait_for_fall) {
				/* falling edge */

				if (m > BLIND_SEARCH_BW_MIN)
					n = m;

				if (m == 0)
					wait_for_fall = 3;
				else if (m <= BLIND_SEARCH_BW_MIN)
					wait_for_fall = 0;
				else
					wait_for_fall = 2;

				m = 0;

				PR_DVBS("Find first edge is falling ...\n");
				PR_DVBS("agc2_ratio 0x%x, min_agc2_level 0x%x).\n",
						agc2_ratio, min_agc2_level);

				/* the first edge is falling */
				//if (!wait_for_fall)
				//	asperity = 2;
				//else
				//	asperity = 1;

			PR_DVBS("falling: i %d, j %d, m %d, n %d, asperity %d, init_freq %d.\n",
					i, j, m, n, asperity, init_freq);

				//if (j == 1) {
					for (l = 0; l < 10 * div; l++)
						agc2_level_tab[l] = agc2_level;

					/* All reset */
					//j = 0;
					//wait_for_fall = 0;
					//asperity = 0;
				//} else {
				//	break;
				//}
			} else if (agc2_ratio > BLIND_SEARCH_POW_TH && 1 == wait_for_fall) {
				wait_for_fall = 0;
				m = 0;
			}

			//if (wait_for_fall == 1 && j == (5 * div))
			//	break;

			if (wait_for_fall == 1)
				m += 1;

			if (wait_for_fall == 2 || wait_for_fall == 3)
				j += 1;
		}

		init_freq = init_freq + freq_step;
	}

	dvbs_wr_byte(0x922, tmp1);
	dvbs_wr_byte(0x9b0, tmp2);
	dvbs_wr_byte(0x9b5, tmp3);

	/* Demod Stop */
	dvbs_wr_byte(0x924, 0x1c);
	dvbs_wr_byte(0x9c4, 0x0);
	dvbs_wr_byte(0x9c5, 0x0);

	/* asperity == 1, means rising edge followed by a constant level
	 * or a falling edge.
	 * others, means falling edge.
	 */

	if (n == 0 && j == 0) {
		asperity = 0;
		*next_step_khz = (1000 / div) * m;
	} else if (n != 0 && j == 0) {
		asperity = 1;
		if (m != 0)
			*next_step_khz = (1000 / div) * m;
		else
			*next_step_khz = 0;
	} else {
		asperity = 1;
		if (m != 0)
			*next_step_khz = (1000 / div) * m;
		else
			*next_step_khz = 0;
	}

	return asperity;
}

unsigned int dvbs_blind_check_AGC2_bandwidth_old(int *next_step_khz)
{
	struct amldtvdemod_device_s *devp = dtvdemod_get_dev();
	int i = 0, j = 0, k = 0, l = 0;
	int nb_steps = 0, init_freq = 0, freq_step = 0;
	unsigned int tmp1 = 0, tmp2 = 0, tmp3 = 0;
	unsigned int agc2_level = 0, agc2_ratio = 0, accu_level = 0;
	unsigned int min_agc2_level = 0, max_agc2_level = 0, mid_agc2_level = 0;
	unsigned int agc2_level_tab[20] = { 0 };
	unsigned char div = 2, wait_for_fall = 0;
	unsigned int asperity = 0;
#ifdef DVBS_BLIND_SCAN_DEBUG
	int tmp = 0;
#endif

	dvbs_wr_byte(0x924, 0x1c); //demod stop
	tmp2 = dvbs_rd_byte(0x9b0);
	dvbs_wr_byte(0x9b0, 0x6);

	tmp3 = dvbs_rd_byte(0x9b5);
	dvbs_wr_byte(0x9b5, 0x00);
	dvbs_wr_byte(0x991, 0x40); //default 0x38

	tmp1 = dvbs_rd_byte(0x922);
	dvbs_write_bits(0x922, 1, 6, 1);
	dvbs_write_bits(0x922, 1, 7, 1);
	/* Enable the SR SCAN */
	dvbs_write_bits(0x922, 0, 4, 1);
	/* activate the carrier frequency search loop */
	dvbs_write_bits(0x922, 0, 3, 1);

	/* AGC2 bandwidth * 0.5M */
	fe_l2a_set_symbol_rate(1000000 / div);

	nb_steps = (45000000 / 2000000) * div;
	//if (nb_steps <= 0)
	//	nb_steps = 1;

	/* AGC2 step is 1 / div MHz */
	//freq_step = 1000 * ((ALIGN_24 + ADC_CLK_135M / 2) / ADC_CLK_135M) / div;
	//PR_DVBS("1 freq_step: %d\n", freq_step);
	freq_step = ((1000000 << 8) / ((ADC_CLK_135M * 1000) >> 8)) / div;
	freq_step = freq_step << 8;
	PR_DVBS("2 freq_step: %d\n", freq_step);

	init_freq = freq_step * nb_steps;

	for (i = 0; i < nb_steps * 2; ++i) {
		if (devp->blind_scan_stop)
			break;

		PR_DVBS("init_freq: %d, freq_step: %d, nb_steps: %d.\n",
				init_freq, freq_step, nb_steps);

		dvbs_wr_byte(0x924, 0x1c);

		dvbs_wr_byte(0x9c3, (init_freq >> 16) & 0xff);
		dvbs_wr_byte(0x9c4, (init_freq >> 8) & 0xff);
		dvbs_wr_byte(0x9c5, init_freq  & 0xff);
#ifdef DVBS_BLIND_SCAN_DEBUG
		tmp = ((dvbs_rd_byte(0x9c3) & 0xff) << 16) |
				((dvbs_rd_byte(0x9c4) & 0xff) << 8) |
				(dvbs_rd_byte(0x9c5) & 0xff);
		if (tmp & 0x800000)
			tmp = (((~tmp) & 0x7fffff) + 1) * (-1);

		PR_DVBS("get hw carrier_freq1 = %d.\n", tmp);
#endif
		dvbs_wr_byte(0x924, 0x18); //Warm start
		usleep_range(5 * 1000, 6 * 1000);//msleep(5);

		agc2_level = fe_l2a_get_AGC2_accu();
		if (agc2_level > 0x1fffff)
			agc2_level = 0x1fffff;

		PR_DVBS("agc2_level: %d(0x%x), i: %d, j: %d.\n",
				agc2_level, agc2_level, i, j);

		if (i == 0) {
			//min_agc2_level = agc2_level;
			//max_agc2_level = agc2_level;
			//mid_agc2_level = agc2_level;

			for (l = 0; l < 5 * div; ++l)
				agc2_level_tab[l] = agc2_level;

		} else {
			k = i % (5 * div);
			agc2_level_tab[k] = agc2_level;

			min_agc2_level = 0x3fffff;
			max_agc2_level = 0x0000;
			accu_level = 0;

			/* Min and max detection */
			for (l = 0; l < 5 * div; ++l) {
				if (agc2_level_tab[l] < min_agc2_level)
					min_agc2_level = agc2_level_tab[l];

				if (agc2_level_tab[l] > max_agc2_level)
					max_agc2_level = agc2_level_tab[l];

				accu_level = accu_level + agc2_level_tab[l];
			}

			mid_agc2_level = accu_level / (5 * div);

			if (!wait_for_fall) {
				agc2_ratio = (max_agc2_level - min_agc2_level) * 128;
				agc2_ratio = agc2_ratio / mid_agc2_level;
			} else {
				agc2_ratio = (agc2_level - min_agc2_level) * 128;
				agc2_ratio = agc2_ratio / mid_agc2_level;
			}

			if (agc2_ratio > 0xffff)
				agc2_ratio = 0xffff;

			PR_DVBS("i: %d, j: %d.\n", i, j);
			PR_DVBS("agc2_level     %d.\n", agc2_level);
			PR_DVBS("max_agc2_level %d.\n", max_agc2_level);
			PR_DVBS("min_agc2_level %d.\n", min_agc2_level);
			PR_DVBS("mid_agc2_level %d.\n", mid_agc2_level);
			PR_DVBS("agc2_ratio     %d.\n", agc2_ratio);

			if (agc2_ratio > BLIND_SEARCH_AGC2BANDWIDTH_40 &&
				agc2_level == min_agc2_level &&
				agc2_level < BLIND_SEARCH_POW_TH) {
				/* rising edge */

				PR_DVBS("Find first edge is rising ...\n");
				PR_DVBS("agc2_ratio 0x%x, min_agc2_level 0x%x, agc2_level 0x%x).\n",
						agc2_ratio, min_agc2_level, agc2_level);

				/* The first edge is rising */
				asperity = 1;
				wait_for_fall = 1;

				PR_DVBS("rising: i %d, j %d, asperity %d, init_freq %d.\n",
						i, j, asperity, init_freq);

				for (l = 0; l < 5 * div; l++)
					agc2_level_tab[l] = agc2_level;

			} else if (agc2_ratio > BLIND_SEARCH_AGC2BANDWIDTH_40 &&
						min_agc2_level < BLIND_SEARCH_POW_TH) {
				/* falling edge */

				PR_DVBS("Find first edge is falling ...\n");
				PR_DVBS("agc2_ratio 0x%x, min_agc2_level 0x%x).\n",
						agc2_ratio, min_agc2_level);

				/* the first edge is falling */
				if (!wait_for_fall)
					asperity = 2;
				else
					asperity = 1;

				PR_DVBS("falling: i %d, j %d, asperity %d, init_freq %d.\n",
						i, j, asperity, init_freq);

				if (j == 1) {
					for (l = 0; l < 5 * div; l++)
						agc2_level_tab[l] = agc2_level;

					/* All reset */
					j = 0;
					wait_for_fall = 0;
					asperity = 0;
				} else {
					break;
				}
			}

			if (wait_for_fall == 1 && j == (5 * div))
				break;

			if (wait_for_fall == 1)
				j += 1;
		}

		init_freq = init_freq - freq_step;
	}

	dvbs_wr_byte(0x922, tmp1);
	dvbs_wr_byte(0x9b0, tmp2);
	dvbs_wr_byte(0x9b5, tmp3);

	/* Demod Stop */
	dvbs_wr_byte(0x924, 0x1c);
	dvbs_wr_byte(0x9c4, 0x0);
	dvbs_wr_byte(0x9c5, 0x0);

	/* asperity == 1, means rising edge followed by a constant level
	 * or a falling edge.
	 * others, means falling edge.
	 */

	*next_step_khz = 0;

	return asperity;
}
