/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2021 Amlogic, Inc. All rights reserved.
 */

#ifndef __VPP_COMMON_DEF_H__
#define __VPP_COMMON_DEF_H__

#define _VPP_TYPE  'V'

#define VPP_GAMMA_TABLE_LEN       (256)
#define VPP_PRE_GAMMA_TABLE_LEN   (65)
#define VPP_MTRX_COEF_LEN         (9)
#define VPP_MTRX_OFFSET_LEN       (3)
#define VPP_HIST_BIN_COUNT        (64)
#define VPP_COLOR_HIST_BIN_COUNT  (32)
#define VPP_HDR_HIST_BIN_COUNT    (128)
#define VPP_COLOR_PRIMARY_LEN     (8)

#define VPP_DNLP_SCURV_LEN             (65)
#define VPP_DNLP_GAIN_VAR_LUT_LEN      (49)
#define VPP_DNLP_WEXT_GAIN_LEN         (48)
#define VPP_DNLP_ADP_THRD_LEN          (33)
#define VPP_DNLP_REG_BLK_BOOST_LEN     (13)
#define VPP_DNLP_REG_ADP_OFSET_LEN     (20)
#define VPP_DNLP_REG_MONO_PROT_LEN     (6)
#define VPP_DNLP_TREND_WHT_EXP_LUT_LEN (9)
#define VPP_DNLP_HIST_GAIN_LEN         (65)

/*Common enum*/
enum vpp_rgb_mode_e {
	EN_MODE_R = 0,
	EN_MODE_G,
	EN_MODE_B,
	EN_MODE_RGB_MAX,
};

enum vpp_level_mode_e {
	EN_LEVEL_MODE_OFF = 0,
	EN_LEVEL_MODE_LOW,
	EN_LEVEL_MODE_MID,
	EN_LEVEL_MODE_HIGH,
	EN_LEVEL_MODE_AUTO,
};

enum vpp_pc_mode_e {
	EN_PC_MODE_OFF = 0,
	EN_PC_MODE_ON,
};

enum vpp_module_e {
	EN_MODULE_VADJ1 = 0,
	EN_MODULE_VADJ2,
	EN_MODULE_PREGAMMA,
	EN_MODULE_GAMMA,
	EN_MODULE_WB,
	EN_MODULE_DNLP,     /*5*/
	EN_MODULE_CCORING,
	EN_MODULE_SR0,
	EN_MODULE_SR1,
	EN_MODULE_LC,
	EN_MODULE_CM,       /*10*/
	EN_MODULE_BLE,
	EN_MODULE_BLS,
	EN_MODULE_LUT3D,
	EN_MODULE_ALL,
};

enum vpp_color_primary_e {
	EN_COLOR_PRI_NULL = 0,
	EN_COLOR_PRI_BT601,
	EN_COLOR_PRI_BT709,
	EN_COLOR_PRI_BT2020,
	EN_COLOR_PRI_MAX,
};

enum vpp_hdr_lut_type_e {
	EN_HDR_LUT_TYPE_HLG = 0,
	EN_HDR_LUT_TYPE_HDR,
	EN_HDR_LUT_TYPE_MAX,
};

enum vpp_hdr_type_e {
	EN_TYPE_NONE = 0,
	EN_TYPE_SDR,
	EN_TYPE_HDR10,
	EN_TYPE_HLG,
	EN_TYPE_HDR10PLUS,
	EN_TYPE_DOBVI,
	EN_TYPE_MVC,
	EN_TYPE_CUVA_HDR,
	EN_TYPE_CUVA_HLG,
};

enum vpp_dnlp_rt_e {
	EN_DNLP_RT_0S = 0,
	EN_DNLP_RT_1S = 6,
	EN_DNLP_RT_2S,
	EN_DNLP_RT_4S,
	EN_DNLP_RT_8S,
	EN_DNLP_RT_16S,
	EN_DNLP_RT_32S,
	EN_DNLP_RT_64S,
	EN_DNLP_RT_FREEZE,
};

enum vpp_dnlp_rl_e {
	EN_DNLP_RL_01 = 1, /*max_contrast = 1.0625x*/
	EN_DNLP_RL_02,     /*max_contrast = 1.1250x*/
	EN_DNLP_RL_03,     /*max_contrast = 1.1875x*/
	EN_DNLP_RL_04,     /*max_contrast = 1.2500x*/
	EN_DNLP_RL_05,     /*max_contrast = 1.3125x*/
	EN_DNLP_RL_06,     /*max_contrast = 1.3750x*/
	EN_DNLP_RL_07,     /*max_contrast = 1.4375x*/
	EN_DNLP_RL_08,     /*max_contrast = 1.5000x*/
	EN_DNLP_RL_09,     /*max_contrast = 1.5625x*/
	EN_DNLP_RL_10,     /*max_contrast = 1.6250x*/
	EN_DNLP_RL_11,     /*max_contrast = 1.6875x*/
	EN_DNLP_RL_12,     /*max_contrast = 1.7500x*/
	EN_DNLP_RL_13,     /*max_contrast = 1.8125x*/
	EN_DNLP_RL_14,     /*max_contrast = 1.8750x*/
	EN_DNLP_RL_15,     /*max_contrast = 1.9375x*/
	EN_DNLP_RL_16,     /*max_contrast = 2.0000x*/
};

enum vpp_dnlp_ext_e {
	EN_DNLP_EXT_00 = 0, /*weak*/
	EN_DNLP_EXT_01,
	EN_DNLP_EXT_02,
	EN_DNLP_EXT_03,
	EN_DNLP_EXT_04,
	EN_DNLP_EXT_05,
	EN_DNLP_EXT_06,
	EN_DNLP_EXT_07,
	EN_DNLP_EXT_08,
	EN_DNLP_EXT_09,
	EN_DNLP_EXT_10,
	EN_DNLP_EXT_11,
	EN_DNLP_EXT_12,
	EN_DNLP_EXT_13,
	EN_DNLP_EXT_14,
	EN_DNLP_EXT_15,
	EN_DNLP_EXT_16,     /*strong*/
};

enum vpp_csc_type_e {
	EN_CSC_MATRIX_NULL                = 0,
	EN_CSC_MATRIX_RGB_YUV601          = 0x1,
	EN_CSC_MATRIX_RGB_YUV601F         = 0x2,
	EN_CSC_MATRIX_RGB_YUV709          = 0x3,
	EN_CSC_MATRIX_RGB_YUV709F         = 0x4,
	EN_CSC_MATRIX_YUV601_RGB          = 0x10,
	EN_CSC_MATRIX_YUV601_YUV601F      = 0x11,
	EN_CSC_MATRIX_YUV601_YUV709       = 0x12,
	EN_CSC_MATRIX_YUV601_YUV709F      = 0x13,
	EN_CSC_MATRIX_YUV601F_RGB         = 0x14,
	EN_CSC_MATRIX_YUV601F_YUV601      = 0x15,
	EN_CSC_MATRIX_YUV601F_YUV709      = 0x16,
	EN_CSC_MATRIX_YUV601F_YUV709F     = 0x17,
	EN_CSC_MATRIX_YUV709_RGB          = 0x20,
	EN_CSC_MATRIX_YUV709_YUV601       = 0x21,
	EN_CSC_MATRIX_YUV709_YUV601F      = 0x22,
	EN_CSC_MATRIX_YUV709_YUV709F      = 0x23,
	EN_CSC_MATRIX_YUV709F_RGB         = 0x24,
	EN_CSC_MATRIX_YUV709F_YUV601      = 0x25,
	EN_CSC_MATRIX_YUV709F_YUV709      = 0x26,
	EN_CSC_MATRIX_YUV601L_YUV709L     = 0x27,
	EN_CSC_MATRIX_YUV709L_YUV601L     = 0x28,
	EN_CSC_MATRIX_YUV709F_YUV601F     = 0x29,
	EN_CSC_MATRIX_BT2020YUV_BT2020RGB = 0x40,
	EN_CSC_MATRIX_BT2020RGB_709RGB,
	EN_CSC_MATRIX_BT2020RGB_CUSRGB,
	EN_CSC_MATRIX_BT2020YUV_BT2020RGB_DYNAMIC = 0x50,
	EN_CSC_MATRIX_DEFAULT_CSCTYPE     = 0xffff,
};

enum vpp_mtrx_type_e {
	EN_MTRX_VD1 = 0,
	EN_MTRX_POST,
	EN_MTRX_POST2,
	EN_MTRX_MAX,
};

enum vpp_dnlp_param_e {
	EN_DNLP_SMHIST_CK = 0,
	EN_DNLP_MVREFLSH,
	EN_DNLP_CUVBLD_MIN,
	EN_DNLP_CUVBLD_MAX,
	EN_DNLP_BBD_RATIO_LOW,
	EN_DNLP_BBD_RATIO_HIG,
	EN_DNLP_BLK_CCTR,
	EN_DNLP_BRGT_CTRL,
	EN_DNLP_BRGT_RANGE,
	EN_DNLP_BRGHT_ADD,
	EN_DNLP_BRGHT_MAX,
	EN_DNLP_AUTO_RNG,
	EN_DNLP_LOWRANGE,
	EN_DNLP_HGHRANGE,
	EN_DNLP_SATUR_RAT,
	EN_DNLP_SATUR_MAX,
	EN_DNLP_SBGNBND,
	EN_DNLP_SENDBND,
	EN_DNLP_CLASHBGN,
	EN_DNLP_CLASHEND,
	EN_DNLP_CLAHE_GAIN_NEG,
	EN_DNLP_CLAHE_GAIN_POS,
	EN_DNLP_MTDBLD_RATE,
	EN_DNLP_ADPMTD_LBND,
	EN_DNLP_ADPMTD_HBND,
	EN_DNLP_BLKEXT_OFST,
	EN_DNLP_WHTEXT_OFST,
	EN_DNLP_BLKEXT_RATE,
	EN_DNLP_WHTEXT_RATE,
	EN_DNLP_BWEXT_DIV4X_MIN,
	EN_DNLP_IRGNBGN,
	EN_DNLP_IRGNEND,
	EN_DNLP_FINAL_GAIN,
	EN_DNLP_CLIPRATE_V3,
	EN_DNLP_CLIPRATE_MIN,
	EN_DNLP_ADPCRAT_LBND,
	EN_DNLP_ADPCRAT_HBND,
	EN_DNLP_SCURV_LOW_TH,
	EN_DNLP_SCURV_MID1_TH,
	EN_DNLP_SCURV_MID2_TH,
	EN_DNLP_SCURV_HGH1_TH,
	EN_DNLP_SCURV_HGH2_TH,
	EN_DNLP_MTDRATE_ADP_EN,
	EN_DNLP_CLAHE_METHOD,
	EN_DNLP_BLE_EN,
	EN_DNLP_NORM,
	EN_DNLP_SCN_CHG_TH,
	EN_DNLP_IIR_STEP_MUX,
	EN_DNLP_SINGLE_BIN_BW,
	EN_DNLP_SINGLE_BIN_METHOD,
	EN_DNLP_REG_MAX_SLOP_1ST,
	EN_DNLP_REG_MAX_SLOP_MID,
	EN_DNLP_REG_MAX_SLOP_FIN,
	EN_DNLP_REG_MIN_SLOP_1ST,
	EN_DNLP_REG_MIN_SLOP_MID,
	EN_DNLP_REG_MIN_SLOP_FIN,
	EN_DNLP_REG_TREND_WHT_EXPAND_MODE,
	EN_DNLP_REG_TREND_BLK_EXPAND_MODE,
	EN_DNLP_HIST_CUR_GAIN,
	EN_DNLP_HIST_CUR_GAIN_PRECISE,
	EN_DNLP_REG_MONO_BINRANG_ST,
	EN_DNLP_REG_MONO_BINRANG_ED,
	EN_DNLP_C_HIST_GAIN_BASE,
	EN_DNLP_S_HIST_GAIN_BASE,
	EN_DNLP_MVREFLSH_OFFSET,
	EN_DNLP_LUMA_AVG_TH,
	EN_DNLP_PARAM_MAX,
};

enum vpp_cm_curve_type_e {
	EN_CM_LUMA = 0,
	EN_CM_SAT,
	EN_CM_HUE,
	EN_CM_HUE_BY_HS,
};

enum vpp_lut3d_data_type_e {
	EN_LUT3D_INPUT_PARAM = 0,
	EN_LUT3D_UNIFY_KEY,
	EN_LUT3D_BIN_FILE,
};

enum vpp_data_src_e {
	EN_SRC_VGA = 0,
	EN_SRC_ATV_NTSC,
	EN_SRC_ATV_PAL,
	EN_SRC_ATV_PAL_M,
	EN_SRC_ATV_SECAM,
	EN_SRC_ATV_NTSC443,
	EN_SRC_ATV_PAL_N60,
	EN_SRC_ATV_NTSC50,
	EN_SRC_ATV_PAL_N,
	EN_SRC_AV_NTSC,
	EN_SRC_AV_PAL, /*10*/
	EN_SRC_AV_PAL_M,
	EN_SRC_AV_SECAM,
	EN_SRC_AV_NTSC443,
	EN_SRC_AV_PAL_N60,
	EN_SRC_AV_NTSC50,
	EN_SRC_AV_PAL_N,
	EN_SRC_SV_NTSC,
	EN_SRC_SV_PAL,
	EN_SRC_SV_PAL_M,
	EN_SRC_SV_SECAM, /*20*/
	EN_SRC_SCART_AV,
	EN_SRC_SCART_RGB,
	EN_SRC_COMPONENT_480I,
	EN_SRC_COMPONENT_480P,
	EN_SRC_COMPONENT_576I,
	EN_SRC_COMPONENT_576P,
	EN_SRC_COMPONENT_720P,
	EN_SRC_COMPONENT_1080I,
	EN_SRC_COMPONENT_1080P,
	EN_SRC_HDMI_480I, /*30*/
	EN_SRC_HDMI_480P,
	EN_SRC_HDMI_576I,
	EN_SRC_HDMI_576P,
	EN_SRC_HDMI_720P,
	EN_SRC_HDMI_1080I,
	EN_SRC_HDMI_1080P,
	EN_SRC_HDMI_4K,
	EN_SRC_HDMI_8K,
	EN_SRC_MM_480I,
	EN_SRC_MM_480P, /*40*/
	EN_SRC_MM_576I,
	EN_SRC_MM_576P,
	EN_SRC_MM_720P,
	EN_SRC_MM_1080I,
	EN_SRC_MM_1080P,
	EN_SRC_MM_4K,
	EN_SRC_MM_8K,
	EN_SRC_DTV_480I,
	EN_SRC_DTV_480P,
	EN_SRC_DTV_576I, /*50*/
	EN_SRC_DTV_576P,
	EN_SRC_DTV_720P,
	EN_SRC_DTV_1080I,
	EN_SRC_DTV_1080P,
	EN_SRC_DTV_4K,
	EN_SRC_DTV_8K,
	EN_SRC_HDMI_HDR10,
	EN_SRC_HDMI_HLG,
	EN_SRC_HDMI_HDR10P,
	EN_SRC_HDMI_CUVA_HDR, /*60*/
	EN_SRC_HDMI_CUVA_HLG,
	EN_SRC_HDMI_DOBVI,
	EN_SRC_MM_HDR10,
	EN_SRC_MM_HLG,
	EN_SRC_MM_HDR10P,
	EN_SRC_MM_CUVA_HDR,
	EN_SRC_MM_CUVA_HLG,
	EN_SRC_MM_DOBVI,
	EN_SRC_DTV_HDR10,
	EN_SRC_DTV_HLG, /*70*/
	EN_SRC_DTV_HDR10P,
	EN_SRC_DTV_CUVA_HDR,
	EN_SRC_DTV_CUVA_HLG,
	EN_SRC_DTV_DOBVI,
	EN_SRC_INDEX_MAX,
};

/*Settings index sync*/
enum vpp_ble_param_e {
	EN_BLE_START = 0,
	EN_BLE_SLOPE1,
	EN_BLE_MIDPT,
	EN_BLE_SLOPE2,
	EN_BLE_PARAM_MAX,
};

enum vpp_ccoring_param_e {
	EN_CC_SLOPE = 0,
	EN_CC_TH,
	EN_CC_BYPASS_YTH,
	EN_CC_PARAM_MAX,
};

enum vpp_bls_param_e {
	EN_BLS_EN_SEL = 0,
	EN_BLS_CB_INC,
	EN_BLS_CR_INC,
	EN_BLS_GAIN,
	EN_BLS_GAIN_CB4CR,
	EN_BLS_LUMA_HIGH,   /*5*/
	EN_BLS_ERR_CRP,
	EN_BLS_ERR_SIGN3,
	EN_BLS_ERR_CRP_INV,
	EN_BLS_ERR_CRN,
	EN_BLS_ERR_SIGN2,   /*10*/
	EN_BLS_ERR_CRN_INV,
	EN_BLS_ERR_CBP,
	EN_BLS_ERR_SIGN1,
	EN_BLS_ERR_CBP_INV,
	EN_BLS_ERR_CBN,     /*15*/
	EN_BLS_ERR_SIGN0,
	EN_BLS_ERR_CBN_INV,
	EN_BLS_PARAM_MAX,
};

enum vpp_lc_param_e {
	EN_LC_CURVE_NODES_VLPF = 0,
	EN_LC_CURVE_NODES_HLPF,
	EN_LC_LMT_RAT_VALID,
	EN_LC_LMT_RAT_MIN_MAX,
	EN_LC_CONTRAST_GAIN_HIGH,
	EN_LC_CONTRAST_GAIN_LOW,   /*5*/
	EN_LC_CONTRAST_LMT_HIGH_1,
	EN_LC_CONTRAST_LMT_LOW_1,
	EN_LC_CONTRAST_LMT_HIGH_0,
	EN_LC_CONTRAST_LMT_LOW_0,
	EN_LC_CONTRAST_SCALE_HIGH, /*10*/
	EN_LC_CONTRAST_SCALE_LOW,
	EN_LC_CONTRAST_BVN_HIGH,
	EN_LC_CONTRAST_BVN_LOW,
	EN_LC_SLOPE_MAX_FACE,
	EN_LC_NUM_M_CORING,        /*15*/
	EN_LC_YPKBV_SLOPE_MAX,
	EN_LC_YPKBV_SLOPE_MIN,
	EN_LC_PARAM_MAX,
};

enum vpp_sharpness0_param_e {
	EN_SHARPNESS0_PKNR_VSIZE = 0,
	EN_SHARPNESS0_PKNR_VBLANK_NUM,
	EN_SHARPNESS0_NR_GAU_CMODE,
	EN_SHARPNESS0_NR_GAU_YMODE,
	EN_SHARPNESS0_NR_GAU_CNORM,
	EN_SHARPNESS0_NR_GAU_YNORM,
	EN_SHARPNESS0_PK_CIRHPCON2GAIN6,
	EN_SHARPNESS0_PK_CIRHPCON2GAIN5,
	EN_SHARPNESS0_PK_CIRHPCON2GAIN1,
	EN_SHARPNESS0_PK_CIRHPCON2GAIN0,
	EN_SHARPNESS0_PK_CIRHPCON2GAIN4,
	EN_SHARPNESS0_PK_CIRHPCON2GAIN3,   /*10*/
	EN_SHARPNESS0_PK_CIRHPCON2GAIN2,
	EN_SHARPNESS0_PK_CIRBPCON2GAIN6,
	EN_SHARPNESS0_PK_CIRBPCON2GAIN5,
	EN_SHARPNESS0_PK_CIRBPCON2GAIN1,
	EN_SHARPNESS0_PK_CIRBPCON2GAIN0,
	EN_SHARPNESS0_PK_CIRBPCON2GAIN4,
	EN_SHARPNESS0_PK_CIRBPCON2GAIN3,
	EN_SHARPNESS0_PK_CIRBPCON2GAIN2,
	EN_SHARPNESS0_PK_DRTHPCON2GAIN6,
	EN_SHARPNESS0_PK_DRTHPCON2GAIN5,/*20*/
	EN_SHARPNESS0_PK_DRTHPCON2GAIN1,
	EN_SHARPNESS0_PK_DRTHPCON2GAIN0,
	EN_SHARPNESS0_PK_DRTHPCON2GAIN4,
	EN_SHARPNESS0_PK_DRTHPCON2GAIN3,
	EN_SHARPNESS0_PK_DRTHPCON2GAIN2,
	EN_SHARPNESS0_PK_DRTBPCON2GAIN6,
	EN_SHARPNESS0_PK_DRTBPCON2GAIN5,
	EN_SHARPNESS0_PK_DRTBPCON2GAIN1,
	EN_SHARPNESS0_PK_DRTBPCON2GAIN0,
	EN_SHARPNESS0_PK_DRTBPCON2GAIN4,   /*30*/
	EN_SHARPNESS0_PK_DRTBPCON2GAIN3,
	EN_SHARPNESS0_PK_DRTBPCON2GAIN2,
	EN_SHARPNESS0_CIRBP_DIAG_MODE,
	EN_SHARPNESS0_CIRBP_VERT_MODE,
	EN_SHARPNESS0_CIRBP_HORZ_MODE,
	EN_SHARPNESS0_CIRHP_DIAG_MODE,
	EN_SHARPNESS0_CIRHP_VERT_MODE,
	EN_SHARPNESS0_CIRHP_HORZ_MODE,
	EN_SHARPNESS0_DRTBP_DIAG_MODE,
	EN_SHARPNESS0_DRTBP_VERT_MODE,    /*40*/
	EN_SHARPNESS0_DRTBP_HORZ_MODE,
	EN_SHARPNESS0_DRTHP_DIAG_MODE,
	EN_SHARPNESS0_DRTHP_VERT_MODE,
	EN_SHARPNESS0_DRTHP_HORZ_MODE,
	EN_SHARPNESS0_CIRHP_DIAG_CORE,
	EN_SHARPNESS0_CIRHP_VERT_CORE,
	EN_SHARPNESS0_CIRHP_HORZ_CORE,
	EN_SHARPNESS0_CIRBP_DIAG_CORE,
	EN_SHARPNESS0_CIRBP_VERT_CORE,
	EN_SHARPNESS0_CIRBP_HORZ_CORE,    /*50*/
	EN_SHARPNESS0_DRTHP_DIAG_CORE,
	EN_SHARPNESS0_DRTHP_VERT_CORE,
	EN_SHARPNESS0_DRTHP_HORZ_CORE,
	EN_SHARPNESS0_DRTBP_DIAG_CORE,
	EN_SHARPNESS0_DRTBP_VERT_CORE,
	EN_SHARPNESS0_DRTBP_HORZ_CORE,
	EN_SHARPNESS0_BP_CIR_DGAIN,
	EN_SHARPNESS0_BP_CIR_VGAIN,
	EN_SHARPNESS0_BP_CIR_HGAIN,
	EN_SHARPNESS0_HP_CIR_DGAIN,      /*60*/
	EN_SHARPNESS0_HP_CIR_VGAIN,
	EN_SHARPNESS0_HP_CIR_HGAIN,
	EN_SHARPNESS0_NR_ALP0_SSD_OFST,
	EN_SHARPNESS0_NR_ALP0_SSD_GAIN,
	EN_SHARPNESS0_NR_ALP0_MINERR_YPAR6,
	EN_SHARPNESS0_NR_ALP0_MINERR_YPAR5,
	EN_SHARPNESS0_NR_ALP0_MINERR_YPAR1,
	EN_SHARPNESS0_NR_ALP0_MINERR_YPAR0,
	EN_SHARPNESS0_NR_ALP0_MINERR_YPAR4,
	EN_SHARPNESS0_NR_ALP0_MINERR_YPAR3,   /*70*/
	EN_SHARPNESS0_NR_ALP0_MINERR_YPAR2,
	EN_SHARPNESS0_NR_ALP0_MINERR_CPAR6,
	EN_SHARPNESS0_NR_ALP0_MINERR_CPAR5,
	EN_SHARPNESS0_NR_ALP0_MINERR_CPAR1,
	EN_SHARPNESS0_NR_ALP0_MINERR_CPAR0,
	EN_SHARPNESS0_NR_ALP0_MINERR_CPAR4,
	EN_SHARPNESS0_NR_ALP0_MINERR_CPAR3,
	EN_SHARPNESS0_NR_ALP0_MINERR_CPAR2,
	EN_SHARPNESS0_NR_ALP0_CMAX,
	EN_SHARPNESS0_NR_ALP0_CMIX,          /*80*/
	EN_SHARPNESS0_NR_ALP0_YMAX,
	EN_SHARPNESS0_NR_ALP0_YMIX,
	EN_SHARPNESS0_NR_ALP1_CORE_OFST,
	EN_SHARPNESS0_NR_ALP1_CORE_RATE,
	EN_SHARPNESS0_NR_ALP1_MAXERR_MODE,
	EN_SHARPNESS0_NR_ALP1_MINERR_PAR6,
	EN_SHARPNESS0_NR_ALP1_MINERR_PAR5,
	EN_SHARPNESS0_NR_ALP1_MINERR_PAR1,
	EN_SHARPNESS0_NR_ALP1_MINERR_PAR0,
	EN_SHARPNESS0_NR_ALP1_MINERR_PAR4,    /*90*/
	EN_SHARPNESS0_NR_ALP1_MINERR_PAR3,
	EN_SHARPNESS0_NR_ALP1_MINERR_PAR2,
	EN_SHARPNESS0_NR_ALP1_CMAX,
	EN_SHARPNESS0_NR_ALP1_CMIN,
	EN_SHARPNESS0_NR_ALP1_YMAX,
	EN_SHARPNESS0_NR_ALP1_YMIN,
	EN_SHARPNESS0_PK_ALP2_CORE_OFST,
	EN_SHARPNESS0_PK_ALP2_CORE_RATE,
	EN_SHARPNESS0_PK_ALP2_MAXERR_MODE,
	EN_SHARPNESS0_PK_ALP2_MINERR_PAR6,    /*100*/
	EN_SHARPNESS0_PK_ALP2_MINERR_PAR5,
	EN_SHARPNESS0_PK_ALP2_MINERR_PAR1,
	EN_SHARPNESS0_PK_ALP2_MINERR_PAR0,
	EN_SHARPNESS0_PK_ALP2_MINERR_PAR4,
	EN_SHARPNESS0_PK_ALP2_MINERR_PAR3,
	EN_SHARPNESS0_PK_ALP2_MINERR_PAR2,
	EN_SHARPNESS0_PK_ALP2_MAX,
	EN_SHARPNESS0_PK_ALP2_MIN,
	EN_SHARPNESS0_BP_FINAL_GAIN,
	EN_SHARPNESS0_HP_FINAL_GAIN,          /*110*/
	EN_SHARPNESS0_FINAL_GAIN_RS,
	EN_SHARPNESS0_PK_OS_HMIDGAIN,
	EN_SHARPNESS0_PK_OS_HMIDCORE,
	EN_SHARPNESS0_PK_OS_HSIDEGAIN,
	EN_SHARPNESS0_PK_OS_HSIDECORE,
	EN_SHARPNESS0_PK_OS_VMIDGAIN,
	EN_SHARPNESS0_PK_OS_VMIDCORE,
	EN_SHARPNESS0_PK_OS_VSIDEGAIN,
	EN_SHARPNESS0_PK_OS_VSIDECORE,
	EN_SHARPNESS0_PK_OS_ADPT_MIN,       /*120*/
	EN_SHARPNESS0_PK_OS_ADPT_MAX,
	EN_SHARPNESS0_PK_OS_MINERR_GAIN,
	EN_SHARPNESS0_PK_OS_MINERR_CORE,
	EN_SHARPNESS0_PK_OS_UP,
	EN_SHARPNESS0_PK_OS_DOWN,
	EN_SHARPNESS0_PK_OSV_MODE,
	EN_SHARPNESS0_PK_OSH_MODE,
	EN_SHARPNESS0_NR_EN,
	EN_SHARPNESS0_PK_EN,
	EN_SHARPNESS0_3D_MODE,
	EN_SHARPNESS0_PK_DRT_FORCE,
	EN_SHARPNESS0_PK_BIAS_DIAG,        /*130*/
	EN_SHARPNESS0_PK_SAD_HOR_GAIN,
	EN_SHARPNESS0_PK_SAD_VER_GAIN,
	EN_SHARPNESS0_NR_LEDGE_BLEND_MODE,
	EN_SHARPNESS0_NR_CEDGE_BLEND_MODE,
	EN_SHARPNESS0_DNLP_INPUT_MODE,
	EN_SHARPNESS0_ADP_LEDGE_DIR_ALPMAX,
	EN_SHARPNESS0_ADP_LEDGE_DIR_ALPMIN,
	EN_SHARPNESS0_ADP_LEDGE_DIR_ALP_CORE_RATE,
	EN_SHARPNESS0_ADP_LEDGE_DIR_ALP_CORE_OFST,
	EN_SHARPNESS0_ADP_CEDGE_DIR_ALPMAX,       /*140*/
	EN_SHARPNESS0_ADP_CEDGE_DIR_ALPMIN,
	EN_SHARPNESS0_ADP_CEDGE_DIR_ALP_CORE_RATE,
	EN_SHARPNESS0_ADP_CEDGE_DIR_ALP_CORE_OFST,
	EN_SHARPNESS0_ADP_CEDGE_VDF_GAIN,
	EN_SHARPNESS0_ADP_CEDGE_HDF_GAIN,
	EN_SHARPNESS0_ADP_LEDGE_VDF_GAIN,
	EN_SHARPNESS0_ADP_LEDGE_HDF_GAIN,
	EN_SHARPNESS0_ADP_VCEDGE_DEBUG,
	EN_SHARPNESS0_ADP_HCEDGE_DEBUG,
	EN_SHARPNESS0_ADP_VLEDGE_DEBUG,     /*150*/
	EN_SHARPNESS0_ADP_HLEDGE_DEBUG,
	EN_SHARPNESS0_ADP_HVCEDGE_ACBLEND_MODE,
	EN_SHARPNESS0_ADP_HVLEDGE_ACBLEND_MODE,
	EN_SHARPNESS0_ADP_HVCEDGE_DCBLEND_MODE,
	EN_SHARPNESS0_ADP_HVLEDGE_DCBLEND_MODE,
	EN_SHARPNESS0_ADP_CEDGE_DIR_DIFMODE,
	EN_SHARPNESS0_ADP_CEDGE_DIR_LPF,
	EN_SHARPNESS0_ADP_LEDGE_DIR_DIFMODE,
	EN_SHARPNESS0_ADP_LEDGE_DIR_LPF,
	EN_SHARPNESS0_ADP_HCEDGE_DC_MODE,
	EN_SHARPNESS0_ADP_HCEDGE_CLP_MODE,
	EN_SHARPNESS0_ADP_HCEDGE_HARD_WIN_MIN,
	EN_SHARPNESS0_ADP_HCEDGE_HARD_CLP_MIN,
	EN_SHARPNESS0_ADP_HCEDGE_LPF2_FLT,      /*160*/
	EN_SHARPNESS0_ADP_HCEDGE_LPF1_FLT,
	EN_SHARPNESS0_ADP_HCEDGE_LPF0_FLT,
	EN_SHARPNESS0_ADP_HCEDGE_DDN_FLT,
	EN_SHARPNESS0_ADP_HCEDGE_HDN_FLT,
	EN_SHARPNESS0_ADP_HCEDGE_VDN_FLT,
	EN_SHARPNESS0_ADP_HCEDGE_EN,
	EN_SHARPNESS0_ADP_HCEDGE_BST_GAIN3,
	EN_SHARPNESS0_ADP_HCEDGE_BST_GAIN2,
	EN_SHARPNESS0_ADP_HCEDGE_BST_GAIN1,
	EN_SHARPNESS0_ADP_HCEDGE_BST_GAIN0,
	EN_SHARPNESS0_ADP_HCEDGE_BST_CORE3,    /*170*/
	EN_SHARPNESS0_ADP_HCEDGE_BST_CORE2,
	EN_SHARPNESS0_ADP_HCEDGE_BST_CORE1,
	EN_SHARPNESS0_ADP_HCEDGE_BST_CORE0,
	EN_SHARPNESS0_ADP_HCEDGE_CON_2_GAIN2,
	EN_SHARPNESS0_ADP_HCEDGE_CON_2_GAIN1,
	EN_SHARPNESS0_ADP_HCEDGE_CON_2_GAIN0,
	EN_SHARPNESS0_ADP_HCEDGE_CON_LPF,
	EN_SHARPNESS0_ADP_HCEDGE_DX_MODE,
	EN_SHARPNESS0_ADP_HCEDGE_CON_MODE,
	EN_SHARPNESS0_ADP_HCEDGE_CON_2_GAIN6,   /*180*/
	EN_SHARPNESS0_ADP_HCEDGE_CON_2_GAIN5,
	EN_SHARPNESS0_ADP_HCEDGE_CON_2_GAIN4,
	EN_SHARPNESS0_ADP_HCEDGE_CON_2_GAIN3,
	EN_SHARPNESS0_ADP_HCEDGE_OS_MARGIN,
	EN_SHARPNESS0_ADP_HLEDGE_DC_MODE,
	EN_SHARPNESS0_ADP_HLEDGE_CLP_MODE,
	EN_SHARPNESS0_ADP_HLEDGE_HARD_WIN_MIN,
	EN_SHARPNESS0_ADP_HLEDGE_HARD_CLP_MIN,
	EN_SHARPNESS0_ADP_HLEDGE_LPF2_FLT,
	EN_SHARPNESS0_ADP_HLEDGE_LPF1_FLT,
	EN_SHARPNESS0_ADP_HLEDGE_LPF0_FLT,    /*190*/
	EN_SHARPNESS0_ADP_HLEDGE_DDN_FLT,
	EN_SHARPNESS0_ADP_HLEDGE_HDN_FLT,
	EN_SHARPNESS0_ADP_HLEDGE_VDN_FLT,
	EN_SHARPNESS0_ADP_HLEDGE_EN,
	EN_SHARPNESS0_ADP_HLEDGE_BST_GAIN3,
	EN_SHARPNESS0_ADP_HLEDGE_BST_GAIN2,
	EN_SHARPNESS0_ADP_HLEDGE_BST_GAIN1,
	EN_SHARPNESS0_ADP_HLEDGE_BST_GAIN0,
	EN_SHARPNESS0_ADP_HLEDGE_BST_CORE3,
	EN_SHARPNESS0_ADP_HLEDGE_BST_CORE2,
	EN_SHARPNESS0_ADP_HLEDGE_BST_CORE1,    /*200*/
	EN_SHARPNESS0_ADP_HLEDGE_BST_CORE0,
	EN_SHARPNESS0_ADP_HLEDGE_CON_2_GAIN2,
	EN_SHARPNESS0_ADP_HLEDGE_CON_2_GAIN1,
	EN_SHARPNESS0_ADP_HLEDGE_CON_2_GAIN0,
	EN_SHARPNESS0_ADP_HLEDGE_CON_LPF,
	EN_SHARPNESS0_ADP_HLEDGE_DX_MODE,
	EN_SHARPNESS0_ADP_HLEDGE_CON_MODE,
	EN_SHARPNESS0_ADP_HLEDGE_CON_2_GAIN6,
	EN_SHARPNESS0_ADP_HLEDGE_CON_2_GAIN5,
	EN_SHARPNESS0_ADP_HLEDGE_CON_2_GAIN4,   /*210*/
	EN_SHARPNESS0_ADP_HLEDGE_CON_2_GAIN3,
	EN_SHARPNESS0_ADP_HLEDGE_OS_MARGIN,
	EN_SHARPNESS0_ADP_VLEDGE_HARD_CLP_WIN,
	EN_SHARPNESS0_ADP_VLEDGE_CON_LPF,
	EN_SHARPNESS0_ADP_VLEDGE_DX_MODE,
	EN_SHARPNESS0_ADP_VLEDGE_DAN_FLT,
	EN_SHARPNESS0_ADP_VLEDGE_HAN_FLT,
	EN_SHARPNESS0_ADP_VLEDGE_DXN_FLT,
	EN_SHARPNESS0_ADP_VLEDGE_HXN_FLT,
	EN_SHARPNESS0_ADP_VLEDGE_EN,
	EN_SHARPNESS0_ADP_VLEDGE_BST_GAIN2,
	EN_SHARPNESS0_ADP_VLEDGE_BST_GAIN1,
	EN_SHARPNESS0_ADP_VLEDGE_BST_GAIN0,
	EN_SHARPNESS0_ADP_VLEDGE_BST_CORE2,
	EN_SHARPNESS0_ADP_VLEDGE_BST_CORE1,
	EN_SHARPNESS0_ADP_VLEDGE_BST_CORE0,
	EN_SHARPNESS0_ADP_VLEDGE_CON_2_GAIN3,
	EN_SHARPNESS0_ADP_VLEDGE_CON_2_GAIN2,
	EN_SHARPNESS0_ADP_VLEDGE_CON_2_GAIN1,
	EN_SHARPNESS0_ADP_VLEDGE_CON_2_GAIN0,
	EN_SHARPNESS0_ADP_VLEDGE_OS_MARGIN,
	EN_SHARPNESS0_ADP_VLEDGE_CON_2_GAIN6,
	EN_SHARPNESS0_ADP_VLEDGE_CON_2_GAIN5,    /*230*/
	EN_SHARPNESS0_ADP_VLEDGE_CON_2_GAIN4,
	EN_SHARPNESS0_ADP_VCEDGE_HARD_CLP_WIN,
	EN_SHARPNESS0_ADP_VCEDGE_CON_LPF,
	EN_SHARPNESS0_ADP_VCEDGE_DX_MODE,
	EN_SHARPNESS0_ADP_VCEDGE_DAN_FLT,
	EN_SHARPNESS0_ADP_VCEDGE_HAN_FLT,
	EN_SHARPNESS0_ADP_VCEDGE_DXN_FLT,
	EN_SHARPNESS0_ADP_VCEDGE_HXN_FLT,
	EN_SHARPNESS0_ADP_VCEDGE_EN,
	EN_SHARPNESS0_ADP_VCEDGE_BST_GAIN2,
	EN_SHARPNESS0_ADP_VCEDGE_BST_GAIN1,
	EN_SHARPNESS0_ADP_VCEDGE_BST_GAIN0,
	EN_SHARPNESS0_ADP_VCEDGE_BST_CORE2,     /*240*/
	EN_SHARPNESS0_ADP_VCEDGE_BST_CORE1,
	EN_SHARPNESS0_ADP_VCEDGE_BST_CORE0,
	EN_SHARPNESS0_ADP_VCEDGE_CON_2_GAIN3,
	EN_SHARPNESS0_ADP_VCEDGE_CON_2_GAIN2,
	EN_SHARPNESS0_ADP_VCEDGE_CON_2_GAIN1,
	EN_SHARPNESS0_ADP_VCEDGE_CON_2_GAIN0,
	EN_SHARPNESS0_ADP_VCEDGE_OS_MARGIN,
	EN_SHARPNESS0_ADP_VCEDGE_CON_2_GAIN6,
	EN_SHARPNESS0_ADP_VCEDGE_CON_2_GAIN5,
	EN_SHARPNESS0_ADP_VCEDGE_CON_2_GAIN4,/*250*/
	EN_SHARPNESS0_3D_MID_HEIGHT,
	EN_SHARPNESS0_3D_MID_WIDTH,
	EN_SHARPNESS0_SR3_CEDGE_HSAD_HLPF,
	EN_SHARPNESS0_SR3_LEDGE_HSAD_HLPF,
	EN_SHARPNESS0_SR3_CEDGE_VSAD_MODE,
	EN_SHARPNESS0_SR3_LEDGE_VSAD_MODE,
	EN_SHARPNESS0_SR3_CEDGE_DSAD_MODE,
	EN_SHARPNESS0_SR3_LEDGE_DSAD_MODE,
	EN_SHARPNESS0_SR3_CEDGE_HSAD_MODE,
	EN_SHARPNESS0_SR3_LEDGE_HSAD_MODE,
	EN_SHARPNESS0_SR3_CEDGE_SAD_CORE_RATE,
	EN_SHARPNESS0_SR3_LEDGE_SAD_CORE_RATE,
	EN_SHARPNESS0_SR3_PK_SAD_CORE_RATE,
	EN_SHARPNESS0_SR3_PK_EDGE_BLEND_MODE,
	EN_SHARPNESS0_PK_DRTBLD_RANGE,
	EN_SHARPNESS0_SR3_PK_BPDRT_MODE,
	EN_SHARPNESS0_SR3_PK_HPDRT_MODE,
	EN_SHARPNESS0_SR3_PK_DSAD_HLPF,
	EN_SHARPNESS0_SR3_PK_VSAD_HLPF,
	EN_SHARPNESS0_SR3_PK_HSAD_HLPF,
	EN_SHARPNESS0_SR3_PK_SAD_MODE,
	EN_SHARPNESS0_SR3_SAD_INTLEV_GAIN,
	EN_SHARPNESS0_SR3_SAD_INTLEV_MODE1,
	EN_SHARPNESS0_SR3_SAD_INTLEV_MODE,
	EN_SHARPNESS0_SR3_PK_BP_HVCON_REPLACE81V_GAIN,
	EN_SHARPNESS0_SR3_PK_HP_HVCON_REPLACE81V_GAIN,
	EN_SHARPNESS0_SR3_PK_BP_HVCON_REPLACE8_MAXSAD,  /*260*/
	EN_SHARPNESS0_SR3_PK_HP_HVCON_REPLACE8_MAXSAD,
	EN_SHARPNESS0_SR3_DRTLPF_ENABLE,
	EN_SHARPNESS0_SR3_DRTLPF_THETA_MIN_IDX,
	EN_SHARPNESS0_SR3_DRTLPF_THETA_EN,
	EN_SHARPNESS0_PK_DEBUG_EDGE,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_0,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_1,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_2,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_3,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_4,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_5,     /*270*/
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_6,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_7,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_8,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_9,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_10,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_11,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_OFST0,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_OFST1,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_OFST2,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_OFST3,   /*280*/
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_OFST4,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_OFST5,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_OFST6,
	EN_SHARPNESS0_SR3_DRTLPF_ALPHA_OFST7,
	EN_SHARPNESS0_SR3_DERING_LCVAR_NEARBY_MAXSAD_TH,
	EN_SHARPNESS0_SR3_DERING_LCVAR_GAIN,
	EN_SHARPNESS0_SR3_DERING_LCVAR_BLEND_MODE,
	EN_SHARPNESS0_SR3_DERING_MAXRANGE,
	EN_SHARPNESS0_SR3_DERING_VARLPF_MODE,
	EN_SHARPNESS0_SR3_DERING_ENABLE,        /*290*/
	EN_SHARPNESS0_SR3_DERING_LUMA2PKGAIN0,
	EN_SHARPNESS0_SR3_DERING_LUMA2PKGAIN1,
	EN_SHARPNESS0_SR3_DERING_LUMA2PKGAIN2,
	EN_SHARPNESS0_SR3_DERING_LUMA2PKGAIN3,
	EN_SHARPNESS0_SR3_DERING_LUMA2PKGAIN4,
	EN_SHARPNESS0_SR3_DERING_LUMA2PKGAIN5,
	EN_SHARPNESS0_SR3_DERING_LUMA2PKGAIN6,
	EN_SHARPNESS0_SR3_DERING_LUMA2PKOS0,
	EN_SHARPNESS0_SR3_DERING_LUMA2PKOS1,
	EN_SHARPNESS0_SR3_DERING_LUMA2PKOS2,   /*300*/
	EN_SHARPNESS0_SR3_DERING_LUMA2PKOS3,
	EN_SHARPNESS0_SR3_DERING_LUMA2PKOS4,
	EN_SHARPNESS0_SR3_DERING_LUMA2PKOS5,
	EN_SHARPNESS0_SR3_DERING_LUMA2PKOS6,
	EN_SHARPNESS0_SR3_DERING_GAINVS_MAXSAD0,
	EN_SHARPNESS0_SR3_DERING_GAINVS_MAXSAD1,
	EN_SHARPNESS0_SR3_DERING_GAINVS_MAXSAD2,
	EN_SHARPNESS0_SR3_DERING_GAINVS_MAXSAD3,
	EN_SHARPNESS0_SR3_DERING_GAINVS_MAXSAD4,
	EN_SHARPNESS0_SR3_DERING_GAINVS_MAXSAD5,   /*310*/
	EN_SHARPNESS0_SR3_DERING_GAINVS_MAXSAD6,
	EN_SHARPNESS0_SR3_DERING_GAINVS_MAXSAD7,
	EN_SHARPNESS0_SR3_DERING_GAINVS_VR2MAX0,
	EN_SHARPNESS0_SR3_DERING_GAINVS_VR2MAX1,
	EN_SHARPNESS0_SR3_DERING_GAINVS_VR2MAX2,
	EN_SHARPNESS0_SR3_DERING_GAINVS_VR2MAX3,
	EN_SHARPNESS0_SR3_DERING_GAINVS_VR2MAX4,
	EN_SHARPNESS0_SR3_DERING_GAINVS_VR2MAX5,
	EN_SHARPNESS0_SR3_DERING_GAINVS_VR2MAX6,
	EN_SHARPNESS0_SR3_DERING_GAINVS_VR2MAX7,   /*320*/
	EN_SHARPNESS0_SR3_DERING_VR2MAX_LIMT,
	EN_SHARPNESS0_SR3_DERING_VR2MAX_GAIN,
	EN_SHARPNESS0_SR3_DERING_LCVAR_FLOOR,
	EN_SHARPNESS0_SR3_DRTLPF_THETA_L16,
	EN_SHARPNESS0_SR3_DRTLPF_THETA_H16,
	EN_SHARPNESS0_NRDEBAND_LPF_MODE0,
	EN_SHARPNESS0_NRDEBAND_LPF_MODE1,
	EN_SHARPNESS0_NRDEBAND_EN0,
	EN_SHARPNESS0_NRDEBAND_EN1,
	EN_SHARPNESS0_NRDEBAND_HPXOR0,
	EN_SHARPNESS0_NRDEBAND_HPXOR1,
	EN_SHARPNESS0_NRDEBAND_BANDRAND0,
	EN_SHARPNESS0_NRDEBAND_BANDRAND1,
	EN_SHARPNESS0_NRDEBAND_BANDRAND2,     /*330*/
	EN_SHARPNESS0_NRDEBAND_RANDMODE,
	EN_SHARPNESS0_NRDEBAND_SIDERAND,
	EN_SHARPNESS0_NRDEBAND_EN10,
	EN_SHARPNESS0_NRDEBAND_EN11,
	EN_SHARPNESS0_NRDEBAND_RGB,
	EN_SHARPNESS0_NRDEBAND_RESET0,
	EN_SHARPNESS0_NRDEBAND_RESET1,
	EN_SHARPNESS0_NRDEBAND_RANDSLUT0,
	EN_SHARPNESS0_NRDEBAND_RANDSLUT1,
	EN_SHARPNESS0_NRDEBAND_RANDSLUT2,
	EN_SHARPNESS0_NRDEBAND_RANDSLUT3,
	EN_SHARPNESS0_NRDEBAND_RANDSLUT4,
	EN_SHARPNESS0_NRDEBAND_RANDSLUT5,
	EN_SHARPNESS0_NRDEBAND_RANDSLUT6,
	EN_SHARPNESS0_NRDEBAND_RANDSLUT7,
	EN_SHARPNESS0_NRDEBAND_YC_TH0,
	EN_SHARPNESS0_NRDEBAND_YC_TH1,      /*340*/
	EN_SHARPNESS0_NRDEBAND_SEED0_L16,
	EN_SHARPNESS0_NRDEBAND_SEED0_H16,
	EN_SHARPNESS0_NRDEBAND_SEED1_L16,
	EN_SHARPNESS0_NRDEBAND_SEED1_H16,
	EN_SHARPNESS0_NRDEBAND_SEED2_L16,
	EN_SHARPNESS0_NRDEBAND_SEED2_H16,
	EN_SHARPNESS0_PKGAIN_VSLUMA_LUT0,
	EN_SHARPNESS0_PKGAIN_VSLUMA_LUT1,
	EN_SHARPNESS0_PKGAIN_VSLUMA_LUT2,
	EN_SHARPNESS0_PKGAIN_VSLUMA_LUT3,   /*350*/
	EN_SHARPNESS0_PKGAIN_VSLUMA_LUT4,
	EN_SHARPNESS0_PKGAIN_VSLUMA_LUT5,
	EN_SHARPNESS0_PKGAIN_VSLUMA_LUT6,
	EN_SHARPNESS0_PKGAIN_VSLUMA_LUT7,
	EN_SHARPNESS0_PKGAIN_VSLUMA_LUT8,
	EN_SHARPNESS0_PARAM_MAX,
};

enum vpp_sharpness1_param_e {
	EN_SHARPNESS1_PKNR_VSIZE = 0,
	EN_SHARPNESS1_PKNR_VBLANK_NUM,
	EN_SHARPNESS1_NR_GAU_CMODE,
	EN_SHARPNESS1_NR_GAU_YMODE,
	EN_SHARPNESS1_NR_GAU_CNORM,
	EN_SHARPNESS1_NR_GAU_YNORM,
	EN_SHARPNESS1_PK_CIRHPCON2GAIN6,
	EN_SHARPNESS1_PK_CIRHPCON2GAIN5,
	EN_SHARPNESS1_PK_CIRHPCON2GAIN1,
	EN_SHARPNESS1_PK_CIRHPCON2GAIN0,
	EN_SHARPNESS1_PK_CIRHPCON2GAIN4,
	EN_SHARPNESS1_PK_CIRHPCON2GAIN3,/*10*/
	EN_SHARPNESS1_PK_CIRHPCON2GAIN2,
	EN_SHARPNESS1_PK_CIRBPCON2GAIN6,
	EN_SHARPNESS1_PK_CIRBPCON2GAIN5,
	EN_SHARPNESS1_PK_CIRBPCON2GAIN1,
	EN_SHARPNESS1_PK_CIRBPCON2GAIN0,
	EN_SHARPNESS1_PK_CIRBPCON2GAIN4,
	EN_SHARPNESS1_PK_CIRBPCON2GAIN3,
	EN_SHARPNESS1_PK_CIRBPCON2GAIN2,
	EN_SHARPNESS1_PK_DRTHPCON2GAIN6,
	EN_SHARPNESS1_PK_DRTHPCON2GAIN5,/*20*/
	EN_SHARPNESS1_PK_DRTHPCON2GAIN1,
	EN_SHARPNESS1_PK_DRTHPCON2GAIN0,
	EN_SHARPNESS1_PK_DRTHPCON2GAIN4,
	EN_SHARPNESS1_PK_DRTHPCON2GAIN3,
	EN_SHARPNESS1_PK_DRTHPCON2GAIN2,
	EN_SHARPNESS1_PK_DRTBPCON2GAIN6,
	EN_SHARPNESS1_PK_DRTBPCON2GAIN5,
	EN_SHARPNESS1_PK_DRTBPCON2GAIN1,
	EN_SHARPNESS1_PK_DRTBPCON2GAIN0,
	EN_SHARPNESS1_PK_DRTBPCON2GAIN4,   /*30*/
	EN_SHARPNESS1_PK_DRTBPCON2GAIN3,
	EN_SHARPNESS1_PK_DRTBPCON2GAIN2,
	EN_SHARPNESS1_CIRBP_DIAG_MODE,
	EN_SHARPNESS1_CIRBP_VERT_MODE,
	EN_SHARPNESS1_CIRBP_HORZ_MODE,
	EN_SHARPNESS1_CIRHP_DIAG_MODE,
	EN_SHARPNESS1_CIRHP_VERT_MODE,
	EN_SHARPNESS1_CIRHP_HORZ_MODE,
	EN_SHARPNESS1_DRTBP_DIAG_MODE,
	EN_SHARPNESS1_DRTBP_VERT_MODE,    /*40*/
	EN_SHARPNESS1_DRTBP_HORZ_MODE,
	EN_SHARPNESS1_DRTHP_DIAG_MODE,
	EN_SHARPNESS1_DRTHP_VERT_MODE,
	EN_SHARPNESS1_DRTHP_HORZ_MODE,
	EN_SHARPNESS1_CIRHP_DIAG_CORE,
	EN_SHARPNESS1_CIRHP_VERT_CORE,
	EN_SHARPNESS1_CIRHP_HORZ_CORE,
	EN_SHARPNESS1_CIRBP_DIAG_CORE,
	EN_SHARPNESS1_CIRBP_VERT_CORE,
	EN_SHARPNESS1_CIRBP_HORZ_CORE,    /*50*/
	EN_SHARPNESS1_DRTHP_DIAG_CORE,
	EN_SHARPNESS1_DRTHP_VERT_CORE,
	EN_SHARPNESS1_DRTHP_HORZ_CORE,
	EN_SHARPNESS1_DRTBP_DIAG_CORE,
	EN_SHARPNESS1_DRTBP_VERT_CORE,
	EN_SHARPNESS1_DRTBP_HORZ_CORE,
	EN_SHARPNESS1_BP_CIR_DGAIN,
	EN_SHARPNESS1_BP_CIR_VGAIN,
	EN_SHARPNESS1_BP_CIR_HGAIN,
	EN_SHARPNESS1_HP_CIR_DGAIN,      /*60*/
	EN_SHARPNESS1_HP_CIR_VGAIN,
	EN_SHARPNESS1_HP_CIR_HGAIN,
	EN_SHARPNESS1_NR_ALP0_SSD_OFST,
	EN_SHARPNESS1_NR_ALP0_SSD_GAIN,
	EN_SHARPNESS1_NR_ALP0_MINERR_YPAR6,
	EN_SHARPNESS1_NR_ALP0_MINERR_YPAR5,
	EN_SHARPNESS1_NR_ALP0_MINERR_YPAR1,
	EN_SHARPNESS1_NR_ALP0_MINERR_YPAR0,
	EN_SHARPNESS1_NR_ALP0_MINERR_YPAR4,
	EN_SHARPNESS1_NR_ALP0_MINERR_YPAR3,   /*70*/
	EN_SHARPNESS1_NR_ALP0_MINERR_YPAR2,
	EN_SHARPNESS1_NR_ALP0_MINERR_CPAR6,
	EN_SHARPNESS1_NR_ALP0_MINERR_CPAR5,
	EN_SHARPNESS1_NR_ALP0_MINERR_CPAR1,
	EN_SHARPNESS1_NR_ALP0_MINERR_CPAR0,
	EN_SHARPNESS1_NR_ALP0_MINERR_CPAR4,
	EN_SHARPNESS1_NR_ALP0_MINERR_CPAR3,
	EN_SHARPNESS1_NR_ALP0_MINERR_CPAR2,
	EN_SHARPNESS1_NR_ALP0_CMAX,
	EN_SHARPNESS1_NR_ALP0_CMIX,          /*80*/
	EN_SHARPNESS1_NR_ALP0_YMAX,
	EN_SHARPNESS1_NR_ALP0_YMIX,
	EN_SHARPNESS1_NR_ALP1_CORE_OFST,
	EN_SHARPNESS1_NR_ALP1_CORE_RATE,
	EN_SHARPNESS1_NR_ALP1_MAXERR_MODE,
	EN_SHARPNESS1_NR_ALP1_MINERR_PAR6,
	EN_SHARPNESS1_NR_ALP1_MINERR_PAR5,
	EN_SHARPNESS1_NR_ALP1_MINERR_PAR1,
	EN_SHARPNESS1_NR_ALP1_MINERR_PAR0,
	EN_SHARPNESS1_NR_ALP1_MINERR_PAR4,    /*90*/
	EN_SHARPNESS1_NR_ALP1_MINERR_PAR3,
	EN_SHARPNESS1_NR_ALP1_MINERR_PAR2,
	EN_SHARPNESS1_NR_ALP1_CMAX,
	EN_SHARPNESS1_NR_ALP1_CMIN,
	EN_SHARPNESS1_NR_ALP1_YMAX,
	EN_SHARPNESS1_NR_ALP1_YMIN,
	EN_SHARPNESS1_PK_ALP2_CORE_OFST,
	EN_SHARPNESS1_PK_ALP2_CORE_RATE,
	EN_SHARPNESS1_PK_ALP2_MAXERR_MODE,
	EN_SHARPNESS1_PK_ALP2_MINERR_PAR6,    /*100*/
	EN_SHARPNESS1_PK_ALP2_MINERR_PAR5,
	EN_SHARPNESS1_PK_ALP2_MINERR_PAR1,
	EN_SHARPNESS1_PK_ALP2_MINERR_PAR0,
	EN_SHARPNESS1_PK_ALP2_MINERR_PAR4,
	EN_SHARPNESS1_PK_ALP2_MINERR_PAR3,
	EN_SHARPNESS1_PK_ALP2_MINERR_PAR2,
	EN_SHARPNESS1_PK_ALP2_MAX,
	EN_SHARPNESS1_PK_ALP2_MIN,
	EN_SHARPNESS1_BP_FINAL_GAIN,
	EN_SHARPNESS1_HP_FINAL_GAIN,          /*110*/
	EN_SHARPNESS1_FINAL_GAIN_RS,
	EN_SHARPNESS1_PK_OS_HMIDGAIN,
	EN_SHARPNESS1_PK_OS_HMIDCORE,
	EN_SHARPNESS1_PK_OS_HSIDEGAIN,
	EN_SHARPNESS1_PK_OS_HSIDECORE,
	EN_SHARPNESS1_PK_OS_VMIDGAIN,
	EN_SHARPNESS1_PK_OS_VMIDCORE,
	EN_SHARPNESS1_PK_OS_VSIDEGAIN,
	EN_SHARPNESS1_PK_OS_VSIDECORE,
	EN_SHARPNESS1_PK_OS_ADPT_MIN,       /*120*/
	EN_SHARPNESS1_PK_OS_ADPT_MAX,
	EN_SHARPNESS1_PK_OS_MINERR_GAIN,
	EN_SHARPNESS1_PK_OS_MINERR_CORE,
	EN_SHARPNESS1_PK_OS_UP,
	EN_SHARPNESS1_PK_OS_DOWN,
	EN_SHARPNESS1_PK_OSV_MODE,
	EN_SHARPNESS1_PK_OSH_MODE,
	EN_SHARPNESS1_NR_EN,
	EN_SHARPNESS1_PK_EN,
	EN_SHARPNESS1_3D_MODE,
	EN_SHARPNESS1_PK_DRT_FORCE,
	EN_SHARPNESS1_PK_BIAS_DIAG,        /*130*/
	EN_SHARPNESS1_PK_SAD_HOR_GAIN,
	EN_SHARPNESS1_PK_SAD_VER_GAIN,
	EN_SHARPNESS1_NR_LEDGE_BLEND_MODE,
	EN_SHARPNESS1_NR_CEDGE_BLEND_MODE,
	EN_SHARPNESS1_DNLP_INPUT_MODE,
	EN_SHARPNESS1_ADP_LEDGE_DIR_ALPMAX,
	EN_SHARPNESS1_ADP_LEDGE_DIR_ALPMIN,
	EN_SHARPNESS1_ADP_LEDGE_DIR_ALP_CORE_RATE,
	EN_SHARPNESS1_ADP_LEDGE_DIR_ALP_CORE_OFST,
	EN_SHARPNESS1_ADP_CEDGE_DIR_ALPMAX,       /*140*/
	EN_SHARPNESS1_ADP_CEDGE_DIR_ALPMIN,
	EN_SHARPNESS1_ADP_CEDGE_DIR_ALP_CORE_RATE,
	EN_SHARPNESS1_ADP_CEDGE_DIR_ALP_CORE_OFST,
	EN_SHARPNESS1_ADP_CEDGE_VDF_GAIN,
	EN_SHARPNESS1_ADP_CEDGE_HDF_GAIN,
	EN_SHARPNESS1_ADP_LEDGE_VDF_GAIN,
	EN_SHARPNESS1_ADP_LEDGE_HDF_GAIN,
	EN_SHARPNESS1_ADP_VCEDGE_DEBUG,
	EN_SHARPNESS1_ADP_HCEDGE_DEBUG,
	EN_SHARPNESS1_ADP_VLEDGE_DEBUG,     /*150*/
	EN_SHARPNESS1_ADP_HLEDGE_DEBUG,
	EN_SHARPNESS1_ADP_HVCEDGE_ACBLEND_MODE,
	EN_SHARPNESS1_ADP_HVLEDGE_ACBLEND_MODE,
	EN_SHARPNESS1_ADP_HVCEDGE_DCBLEND_MODE,
	EN_SHARPNESS1_ADP_HVLEDGE_DCBLEND_MODE,
	EN_SHARPNESS1_ADP_CEDGE_DIR_DIFMODE,
	EN_SHARPNESS1_ADP_CEDGE_DIR_LPF,
	EN_SHARPNESS1_ADP_LEDGE_DIR_DIFMODE,
	EN_SHARPNESS1_ADP_LEDGE_DIR_LPF,
	EN_SHARPNESS1_ADP_HCEDGE_DC_MODE,
	EN_SHARPNESS1_ADP_HCEDGE_CLP_MODE,
	EN_SHARPNESS1_ADP_HCEDGE_HARD_WIN_MIN,
	EN_SHARPNESS1_ADP_HCEDGE_HARD_CLP_MIN,
	EN_SHARPNESS1_ADP_HCEDGE_LPF2_FLT,      /*160*/
	EN_SHARPNESS1_ADP_HCEDGE_LPF1_FLT,
	EN_SHARPNESS1_ADP_HCEDGE_LPF0_FLT,
	EN_SHARPNESS1_ADP_HCEDGE_DDN_FLT,
	EN_SHARPNESS1_ADP_HCEDGE_HDN_FLT,
	EN_SHARPNESS1_ADP_HCEDGE_VDN_FLT,
	EN_SHARPNESS1_ADP_HCEDGE_EN,
	EN_SHARPNESS1_ADP_HCEDGE_BST_GAIN3,
	EN_SHARPNESS1_ADP_HCEDGE_BST_GAIN2,
	EN_SHARPNESS1_ADP_HCEDGE_BST_GAIN1,
	EN_SHARPNESS1_ADP_HCEDGE_BST_GAIN0,
	EN_SHARPNESS1_ADP_HCEDGE_BST_CORE3,    /*170*/
	EN_SHARPNESS1_ADP_HCEDGE_BST_CORE2,
	EN_SHARPNESS1_ADP_HCEDGE_BST_CORE1,
	EN_SHARPNESS1_ADP_HCEDGE_BST_CORE0,
	EN_SHARPNESS1_ADP_HCEDGE_CON_2_GAIN2,
	EN_SHARPNESS1_ADP_HCEDGE_CON_2_GAIN1,
	EN_SHARPNESS1_ADP_HCEDGE_CON_2_GAIN0,
	EN_SHARPNESS1_ADP_HCEDGE_CON_LPF,
	EN_SHARPNESS1_ADP_HCEDGE_DX_MODE,
	EN_SHARPNESS1_ADP_HCEDGE_CON_MODE,
	EN_SHARPNESS1_ADP_HCEDGE_CON_2_GAIN6,   /*180*/
	EN_SHARPNESS1_ADP_HCEDGE_CON_2_GAIN5,
	EN_SHARPNESS1_ADP_HCEDGE_CON_2_GAIN4,
	EN_SHARPNESS1_ADP_HCEDGE_CON_2_GAIN3,
	EN_SHARPNESS1_ADP_HCEDGE_OS_MARGIN,
	EN_SHARPNESS1_ADP_HLEDGE_DC_MODE,
	EN_SHARPNESS1_ADP_HLEDGE_CLP_MODE,
	EN_SHARPNESS1_ADP_HLEDGE_HARD_WIN_MIN,
	EN_SHARPNESS1_ADP_HLEDGE_HARD_CLP_MIN,
	EN_SHARPNESS1_ADP_HLEDGE_LPF2_FLT,
	EN_SHARPNESS1_ADP_HLEDGE_LPF1_FLT,
	EN_SHARPNESS1_ADP_HLEDGE_LPF0_FLT,    /*190*/
	EN_SHARPNESS1_ADP_HLEDGE_DDN_FLT,
	EN_SHARPNESS1_ADP_HLEDGE_HDN_FLT,
	EN_SHARPNESS1_ADP_HLEDGE_VDN_FLT,
	EN_SHARPNESS1_ADP_HLEDGE_EN,
	EN_SHARPNESS1_ADP_HLEDGE_BST_GAIN3,
	EN_SHARPNESS1_ADP_HLEDGE_BST_GAIN2,
	EN_SHARPNESS1_ADP_HLEDGE_BST_GAIN1,
	EN_SHARPNESS1_ADP_HLEDGE_BST_GAIN0,
	EN_SHARPNESS1_ADP_HLEDGE_BST_CORE3,
	EN_SHARPNESS1_ADP_HLEDGE_BST_CORE2,
	EN_SHARPNESS1_ADP_HLEDGE_BST_CORE1,    /*200*/
	EN_SHARPNESS1_ADP_HLEDGE_BST_CORE0,
	EN_SHARPNESS1_ADP_HLEDGE_CON_2_GAIN2,
	EN_SHARPNESS1_ADP_HLEDGE_CON_2_GAIN1,
	EN_SHARPNESS1_ADP_HLEDGE_CON_2_GAIN0,
	EN_SHARPNESS1_ADP_HLEDGE_CON_LPF,
	EN_SHARPNESS1_ADP_HLEDGE_DX_MODE,
	EN_SHARPNESS1_ADP_HLEDGE_CON_MODE,
	EN_SHARPNESS1_ADP_HLEDGE_CON_2_GAIN6,
	EN_SHARPNESS1_ADP_HLEDGE_CON_2_GAIN5,
	EN_SHARPNESS1_ADP_HLEDGE_CON_2_GAIN4,   /*210*/
	EN_SHARPNESS1_ADP_HLEDGE_CON_2_GAIN3,
	EN_SHARPNESS1_ADP_HLEDGE_OS_MARGIN,
	EN_SHARPNESS1_ADP_VLEDGE_HARD_CLP_WIN,
	EN_SHARPNESS1_ADP_VLEDGE_CON_LPF,
	EN_SHARPNESS1_ADP_VLEDGE_DX_MODE,
	EN_SHARPNESS1_ADP_VLEDGE_DAN_FLT,
	EN_SHARPNESS1_ADP_VLEDGE_HAN_FLT,
	EN_SHARPNESS1_ADP_VLEDGE_DXN_FLT,
	EN_SHARPNESS1_ADP_VLEDGE_HXN_FLT,
	EN_SHARPNESS1_ADP_VLEDGE_EN,
	EN_SHARPNESS1_ADP_VLEDGE_BST_GAIN2,
	EN_SHARPNESS1_ADP_VLEDGE_BST_GAIN1,
	EN_SHARPNESS1_ADP_VLEDGE_BST_GAIN0,
	EN_SHARPNESS1_ADP_VLEDGE_BST_CORE2,
	EN_SHARPNESS1_ADP_VLEDGE_BST_CORE1,
	EN_SHARPNESS1_ADP_VLEDGE_BST_CORE0,
	EN_SHARPNESS1_ADP_VLEDGE_CON_2_GAIN3,
	EN_SHARPNESS1_ADP_VLEDGE_CON_2_GAIN2,
	EN_SHARPNESS1_ADP_VLEDGE_CON_2_GAIN1,
	EN_SHARPNESS1_ADP_VLEDGE_CON_2_GAIN0,
	EN_SHARPNESS1_ADP_VLEDGE_OS_MARGIN,
	EN_SHARPNESS1_ADP_VLEDGE_CON_2_GAIN6,
	EN_SHARPNESS1_ADP_VLEDGE_CON_2_GAIN5,    /*230*/
	EN_SHARPNESS1_ADP_VLEDGE_CON_2_GAIN4,
	EN_SHARPNESS1_ADP_VCEDGE_HARD_CLP_WIN,
	EN_SHARPNESS1_ADP_VCEDGE_CON_LPF,
	EN_SHARPNESS1_ADP_VCEDGE_DX_MODE,
	EN_SHARPNESS1_ADP_VCEDGE_DAN_FLT,
	EN_SHARPNESS1_ADP_VCEDGE_HAN_FLT,
	EN_SHARPNESS1_ADP_VCEDGE_DXN_FLT,
	EN_SHARPNESS1_ADP_VCEDGE_HXN_FLT,
	EN_SHARPNESS1_ADP_VCEDGE_EN,
	EN_SHARPNESS1_ADP_VCEDGE_BST_GAIN2,
	EN_SHARPNESS1_ADP_VCEDGE_BST_GAIN1,
	EN_SHARPNESS1_ADP_VCEDGE_BST_GAIN0,
	EN_SHARPNESS1_ADP_VCEDGE_BST_CORE2,     /*240*/
	EN_SHARPNESS1_ADP_VCEDGE_BST_CORE1,
	EN_SHARPNESS1_ADP_VCEDGE_BST_CORE0,
	EN_SHARPNESS1_ADP_VCEDGE_CON_2_GAIN3,
	EN_SHARPNESS1_ADP_VCEDGE_CON_2_GAIN2,
	EN_SHARPNESS1_ADP_VCEDGE_CON_2_GAIN1,
	EN_SHARPNESS1_ADP_VCEDGE_CON_2_GAIN0,
	EN_SHARPNESS1_ADP_VCEDGE_OS_MARGIN,
	EN_SHARPNESS1_ADP_VCEDGE_CON_2_GAIN6,
	EN_SHARPNESS1_ADP_VCEDGE_CON_2_GAIN5,
	EN_SHARPNESS1_ADP_VCEDGE_CON_2_GAIN4,/*250*/
	EN_SHARPNESS1_3D_MID_HEIGHT,
	EN_SHARPNESS1_3D_MID_WIDTH,
	EN_SHARPNESS1_SR2_Y_BIC_HCOEFF00,
	EN_SHARPNESS1_SR2_Y_BIC_HCOEFF01,
	EN_SHARPNESS1_SR2_Y_BIC_HCOEFF02,
	EN_SHARPNESS1_SR2_Y_BIC_HCOEFF03,
	EN_SHARPNESS1_SR2_Y_BIC_HCOEFF10,
	EN_SHARPNESS1_SR2_Y_BIC_HCOEFF11,
	EN_SHARPNESS1_SR2_Y_BIC_HCOEFF12,
	EN_SHARPNESS1_SR2_Y_BIC_HCOEFF13,
	EN_SHARPNESS1_SR2_C_BIC_HCOEFF00,
	EN_SHARPNESS1_SR2_C_BIC_HCOEFF01,
	EN_SHARPNESS1_SR2_C_BIC_HCOEFF02,
	EN_SHARPNESS1_SR2_C_BIC_HCOEFF03,
	EN_SHARPNESS1_SR2_C_BIC_HCOEFF10,
	EN_SHARPNESS1_SR2_C_BIC_HCOEFF11,
	EN_SHARPNESS1_SR2_C_BIC_HCOEFF12,
	EN_SHARPNESS1_SR2_C_BIC_HCOEFF13,
	EN_SHARPNESS1_SR2_Y_BIC_VCOEFF00,
	EN_SHARPNESS1_SR2_Y_BIC_VCOEFF01,
	EN_SHARPNESS1_SR2_Y_BIC_VCOEFF02,
	EN_SHARPNESS1_SR2_Y_BIC_VCOEFF03,
	EN_SHARPNESS1_SR2_Y_BIC_VCOEFF10,
	EN_SHARPNESS1_SR2_Y_BIC_VCOEFF11,
	EN_SHARPNESS1_SR2_Y_BIC_VCOEFF12,
	EN_SHARPNESS1_SR2_Y_BIC_VCOEFF13,
	EN_SHARPNESS1_SR2_C_BIC_VCOEFF00,
	EN_SHARPNESS1_SR2_C_BIC_VCOEFF01,
	EN_SHARPNESS1_SR2_C_BIC_VCOEFF02,
	EN_SHARPNESS1_SR2_C_BIC_VCOEFF03,
	EN_SHARPNESS1_SR2_C_BIC_VCOEFF10,
	EN_SHARPNESS1_SR2_C_BIC_VCOEFF11,
	EN_SHARPNESS1_SR2_C_BIC_VCOEFF12,
	EN_SHARPNESS1_SR2_C_BIC_VCOEFF13,
	EN_SHARPNESS1_SR2_CMPMUX_AFT,
	EN_SHARPNESS1_SR2_CMPMUX_BUF,
	EN_SHARPNESS1_SR3_CEDGE_HSAD_HLPF,
	EN_SHARPNESS1_SR3_LEDGE_HSAD_HLPF,
	EN_SHARPNESS1_SR3_CEDGE_VSAD_MODE,
	EN_SHARPNESS1_SR3_LEDGE_VSAD_MODE,
	EN_SHARPNESS1_SR3_CEDGE_DSAD_MODE,
	EN_SHARPNESS1_SR3_LEDGE_DSAD_MODE,
	EN_SHARPNESS1_SR3_CEDGE_HSAD_MODE,
	EN_SHARPNESS1_SR3_LEDGE_HSAD_MODE,
	EN_SHARPNESS1_SR3_CEDGE_SAD_CORE_RATE,
	EN_SHARPNESS1_SR3_LEDGE_SAD_CORE_RATE,
	EN_SHARPNESS1_SR3_PK_SAD_CORE_RATE,
	EN_SHARPNESS1_SR3_PK_EDGE_BLEND_MODE,
	EN_SHARPNESS1_PK_DRTBLD_RANGE,
	EN_SHARPNESS1_SR3_PK_BPDRT_MODE,
	EN_SHARPNESS1_SR3_PK_HPDRT_MODE,
	EN_SHARPNESS1_SR3_PK_DSAD_HLPF,
	EN_SHARPNESS1_SR3_PK_VSAD_HLPF,
	EN_SHARPNESS1_SR3_PK_HSAD_HLPF,
	EN_SHARPNESS1_SR3_PK_SAD_MODE,
	EN_SHARPNESS1_SR3_SAD_INTLEV_GAIN,
	EN_SHARPNESS1_SR3_SAD_INTLEV_MODE1,
	EN_SHARPNESS1_SR3_SAD_INTLEV_MODE,
	EN_SHARPNESS1_SR3_PK_BP_HVCON_REPLACE81V_GAIN,
	EN_SHARPNESS1_SR3_PK_HP_HVCON_REPLACE81V_GAIN,
	EN_SHARPNESS1_SR3_PK_BP_HVCON_REPLACE8_MAXSAD,  /*260*/
	EN_SHARPNESS1_SR3_PK_HP_HVCON_REPLACE8_MAXSAD,
	EN_SHARPNESS1_SR3_DEJAGGY_ENABLE,
	EN_SHARPNESS1_SR3_DEJAGGY_SAMESIDE_MODE,
	EN_SHARPNESS1_SR3_DEJAGGY_SAMESIDE_PRTCT,
	EN_SHARPNESS1_SR3_DEJAGGY_PROCLUMA_ALPHA_0,
	EN_SHARPNESS1_SR3_DEJAGGY_PROCLUMA_ALPHA_1,
	EN_SHARPNESS1_SR3_DEJAGGY_PROCCHRM_ALPHA_0,
	EN_SHARPNESS1_SR3_DEJAGGY_PROCCHRM_ALPHA_1,
	EN_SHARPNESS1_SR3_DEJAGGY_CTRLLUMA_ALPHA_0,
	EN_SHARPNESS1_SR3_DEJAGGY_CTRLLUMA_ALPHA_1,
	EN_SHARPNESS1_SR3_DEJAGGY_CTRLCHRM_ALPHA_0,
	EN_SHARPNESS1_SR3_DEJAGGY_CTRLCHRM_ALPHA_1,
	EN_SHARPNESS1_SR3_DRTLPF_ENABLE,
	EN_SHARPNESS1_SR3_DRTLPF_THETA_MIN_IDX,
	EN_SHARPNESS1_SR3_DRTLPF_THETA_EN,
	EN_SHARPNESS1_PK_DEBUG_EDGE,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_0,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_1,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_2,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_3,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_4,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_5,     /*270*/
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_6,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_7,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_8,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_9,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_10,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_11,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_OFST0,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_OFST1,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_OFST2,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_OFST3,   /*280*/
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_OFST4,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_OFST5,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_OFST6,
	EN_SHARPNESS1_SR3_DRTLPF_ALPHA_OFST7,
	EN_SHARPNESS1_SR3_DERING_LCVAR_NEARBY_MAXSAD_TH,
	EN_SHARPNESS1_SR3_DERING_LCVAR_GAIN,
	EN_SHARPNESS1_SR3_DERING_LCVAR_BLEND_MODE,
	EN_SHARPNESS1_SR3_DERING_MAXRANGE,
	EN_SHARPNESS1_SR3_DERING_VARLPF_MODE,
	EN_SHARPNESS1_SR3_DERING_ENABLE,        /*290*/
	EN_SHARPNESS1_SR3_DERING_LUMA2PKGAIN0,
	EN_SHARPNESS1_SR3_DERING_LUMA2PKGAIN1,
	EN_SHARPNESS1_SR3_DERING_LUMA2PKGAIN2,
	EN_SHARPNESS1_SR3_DERING_LUMA2PKGAIN3,
	EN_SHARPNESS1_SR3_DERING_LUMA2PKGAIN4,
	EN_SHARPNESS1_SR3_DERING_LUMA2PKGAIN5,
	EN_SHARPNESS1_SR3_DERING_LUMA2PKGAIN6,
	EN_SHARPNESS1_SR3_DERING_LUMA2PKOS0,
	EN_SHARPNESS1_SR3_DERING_LUMA2PKOS1,
	EN_SHARPNESS1_SR3_DERING_LUMA2PKOS2,   /*300*/
	EN_SHARPNESS1_SR3_DERING_LUMA2PKOS3,
	EN_SHARPNESS1_SR3_DERING_LUMA2PKOS4,
	EN_SHARPNESS1_SR3_DERING_LUMA2PKOS5,
	EN_SHARPNESS1_SR3_DERING_LUMA2PKOS6,
	EN_SHARPNESS1_SR3_DERING_GAINVS_MAXSAD0,
	EN_SHARPNESS1_SR3_DERING_GAINVS_MAXSAD1,
	EN_SHARPNESS1_SR3_DERING_GAINVS_MAXSAD2,
	EN_SHARPNESS1_SR3_DERING_GAINVS_MAXSAD3,
	EN_SHARPNESS1_SR3_DERING_GAINVS_MAXSAD4,
	EN_SHARPNESS1_SR3_DERING_GAINVS_MAXSAD5,   /*310*/
	EN_SHARPNESS1_SR3_DERING_GAINVS_MAXSAD6,
	EN_SHARPNESS1_SR3_DERING_GAINVS_MAXSAD7,
	EN_SHARPNESS1_SR3_DERING_GAINVS_VR2MAX0,
	EN_SHARPNESS1_SR3_DERING_GAINVS_VR2MAX1,
	EN_SHARPNESS1_SR3_DERING_GAINVS_VR2MAX2,
	EN_SHARPNESS1_SR3_DERING_GAINVS_VR2MAX3,
	EN_SHARPNESS1_SR3_DERING_GAINVS_VR2MAX4,
	EN_SHARPNESS1_SR3_DERING_GAINVS_VR2MAX5,
	EN_SHARPNESS1_SR3_DERING_GAINVS_VR2MAX6,
	EN_SHARPNESS1_SR3_DERING_GAINVS_VR2MAX7,   /*320*/
	EN_SHARPNESS1_SR3_DERING_VR2MAX_LIMT,
	EN_SHARPNESS1_SR3_DERING_VR2MAX_GAIN,
	EN_SHARPNESS1_SR3_DERING_LCVAR_FLOOR,
	EN_SHARPNESS1_SR3_DRTLPF_THETA_L16,
	EN_SHARPNESS1_SR3_DRTLPF_THETA_H16,
	EN_SHARPNESS1_SATPRT_ENABLE,
	EN_SHARPNESS1_SATPRT_IS_LMT,
	EN_SHARPNESS1_SATPRT_CSC_MODE,
	EN_SHARPNESS1_SATPRT_SAT_RATE,
	EN_SHARPNESS1_SATPRT_SAT_CORE,
	EN_SHARPNESS1_SATPRT_DIV_M_R,
	EN_SHARPNESS1_SATPRT_DIV_M_G,
	EN_SHARPNESS1_SATPRT_DIV_M_B,
	EN_SHARPNESS1_NRDEBAND_LPF_MODE0,
	EN_SHARPNESS1_NRDEBAND_LPF_MODE1,
	EN_SHARPNESS1_NRDEBAND_EN0,
	EN_SHARPNESS1_NRDEBAND_EN1,
	EN_SHARPNESS1_NRDEBAND_HPXOR0,
	EN_SHARPNESS1_NRDEBAND_HPXOR1,
	EN_SHARPNESS1_NRDEBAND_BANDRAND0,
	EN_SHARPNESS1_NRDEBAND_BANDRAND1,
	EN_SHARPNESS1_NRDEBAND_BANDRAND2,     /*330*/
	EN_SHARPNESS1_NRDEBAND_RANDMODE,
	EN_SHARPNESS1_NRDEBAND_SIDERAND,
	EN_SHARPNESS1_NRDEBAND_EN10,
	EN_SHARPNESS1_NRDEBAND_EN11,
	EN_SHARPNESS1_NRDEBAND_RGB,
	EN_SHARPNESS1_NRDEBAND_RESET0,
	EN_SHARPNESS1_NRDEBAND_RESET1,
	EN_SHARPNESS1_NRDEBAND_RANDSLUT0,
	EN_SHARPNESS1_NRDEBAND_RANDSLUT1,
	EN_SHARPNESS1_NRDEBAND_RANDSLUT2,
	EN_SHARPNESS1_NRDEBAND_RANDSLUT3,
	EN_SHARPNESS1_NRDEBAND_RANDSLUT4,
	EN_SHARPNESS1_NRDEBAND_RANDSLUT5,
	EN_SHARPNESS1_NRDEBAND_RANDSLUT6,
	EN_SHARPNESS1_NRDEBAND_RANDSLUT7,
	EN_SHARPNESS1_NRDEBAND_YC_TH0,
	EN_SHARPNESS1_NRDEBAND_YC_TH1,      /*340*/
	EN_SHARPNESS1_NRDEBAND_SEED0_L16,
	EN_SHARPNESS1_NRDEBAND_SEED0_H16,
	EN_SHARPNESS1_NRDEBAND_SEED1_L16,
	EN_SHARPNESS1_NRDEBAND_SEED1_H16,
	EN_SHARPNESS1_NRDEBAND_SEED2_L16,
	EN_SHARPNESS1_NRDEBAND_SEED2_H16,
	EN_SHARPNESS1_PKGAIN_VSLUMA_LUT0,
	EN_SHARPNESS1_PKGAIN_VSLUMA_LUT1,
	EN_SHARPNESS1_PKGAIN_VSLUMA_LUT2,
	EN_SHARPNESS1_PKGAIN_VSLUMA_LUT3,   /*350*/
	EN_SHARPNESS1_PKGAIN_VSLUMA_LUT4,
	EN_SHARPNESS1_PKGAIN_VSLUMA_LUT5,
	EN_SHARPNESS1_PKGAIN_VSLUMA_LUT6,
	EN_SHARPNESS1_PKGAIN_VSLUMA_LUT7,
	EN_SHARPNESS1_PKGAIN_VSLUMA_LUT8,
	EN_SHARPNESS1_PKOSHT_VSLUMA_LUT0,
	EN_SHARPNESS1_PKOSHT_VSLUMA_LUT1,
	EN_SHARPNESS1_PKOSHT_VSLUMA_LUT2,
	EN_SHARPNESS1_PKOSHT_VSLUMA_LUT3,
	EN_SHARPNESS1_PKOSHT_VSLUMA_LUT4,    /*360*/
	EN_SHARPNESS1_PKOSHT_VSLUMA_LUT5,
	EN_SHARPNESS1_PKOSHT_VSLUMA_LUT6,
	EN_SHARPNESS1_PKOSHT_VSLUMA_LUT7,
	EN_SHARPNESS1_PKOSHT_VSLUMA_LUT8,
	EN_SHARPNESS1_PARAM_MAX,
};

enum vpp_sr_param_e {
	EN_SR_ENABLE = 0,
	EN_SR_PARAM_MAX,
};

/*Commom struct*/
struct vpp_pq_en_ctrl_s {
	unsigned char vadj1_en; /*control video brightness contrast saturation hue*/
	unsigned char vd1_ctrst_en;
	unsigned char vadj2_en; /*control video+osd brightness contrast saturation hue*/
	unsigned char post_ctrst_en;
	unsigned char pregamma_en;
	unsigned char gamma_en;
	unsigned char wb_en;
	unsigned char dnlp_en;
	unsigned char lc_en;
	unsigned char black_ext_en;
	unsigned char chroma_cor_en;
	unsigned char sharpness0_en;
	unsigned char sharpness1_en;
	unsigned char cm_en;
	unsigned char lut3d_en;
	unsigned char reserved;
};

struct vpp_pq_state_s {
	int pq_en;
	struct vpp_pq_en_ctrl_s pq_cfg;
};

struct vpp_white_balance_s {
	int r_pre_offset;     /*s11.0, range -1024~+1023, default is 0*/
	int g_pre_offset;     /*s11.0, range -1024~+1023, default is 0*/
	int b_pre_offset;     /*s11.0, range -1024~+1023, default is 0*/
	unsigned int r_gain;  /*u1.10, range 0~2047, default is 1024 (1.0x)*/
	unsigned int g_gain;  /*u1.10, range 0~2047, default is 1024 (1.0x)*/
	unsigned int b_gain;  /*u1.10, range 0~2047, default is 1024 (1.0x)*/
	int r_post_offset;    /*s11.0, range -1024~+1023, default is 0*/
	int g_post_offset;    /*s11.0, range -1024~+1023, default is 0*/
	int b_post_offset;    /*s11.0, range -1024~+1023, default is 0*/
};

struct vpp_pre_gamma_table_s {
	unsigned int r_data[VPP_PRE_GAMMA_TABLE_LEN];
	unsigned int g_data[VPP_PRE_GAMMA_TABLE_LEN];
	unsigned int b_data[VPP_PRE_GAMMA_TABLE_LEN];
};

struct vpp_gamma_table_s {
	unsigned int r_data[VPP_GAMMA_TABLE_LEN];
	unsigned int g_data[VPP_GAMMA_TABLE_LEN];
	unsigned int b_data[VPP_GAMMA_TABLE_LEN];
};

struct vpp_mtrx_param_s {
	unsigned int pre_offset[VPP_MTRX_OFFSET_LEN];
	unsigned int matrix_coef[VPP_MTRX_COEF_LEN];
	unsigned int post_offset[VPP_MTRX_OFFSET_LEN];
	unsigned int right_shift;
};

struct vpp_mtrx_info_s {
	enum vpp_mtrx_type_e mtrx_sel;
	struct vpp_mtrx_param_s mtrx_param;
};

struct vpp_histgm_ave_s {
	unsigned int sum;
	int width;
	int height;
	int ave;
};

struct vpp_histgm_param_s {
	unsigned int hist_pow;
	unsigned int luma_sum;
	unsigned int pixel_sum;
	unsigned int histgm[VPP_HIST_BIN_COUNT];
	unsigned int hue_histgm[VPP_COLOR_HIST_BIN_COUNT];
	unsigned int sat_histgm[VPP_COLOR_HIST_BIN_COUNT];
};

struct vpp_hdr_histgm_param_s {
	unsigned int data_rgb_max[VPP_HDR_HIST_BIN_COUNT];
};

/*master_display_info for display device*/
struct vpp_hdr_metadata_s {
	unsigned int primaries[3][2]; /*normalized 50000 in G,B,R order*/
	unsigned int white_point[2];  /*normalized 50000*/
	unsigned int luminance[2];    /*max/min luminance, normalized 10000*/
};

struct vpp_hdr_lut_s {
	enum vpp_hdr_lut_type_e lut_type;
	unsigned int lut_size;
	union {
		int *lut_data;
		long long lut_len;
	};
};

struct vpp_tmo_param_s {
	int tmo_en;
	int reg_highlight;
	int reg_hist_th;
	int reg_light_th;
	int reg_highlight_th1;
	int reg_highlight_th2;
	int reg_display_e;
	int reg_middle_a;
	int reg_middle_a_adj;
	int reg_middle_b;
	int reg_middle_s;
	int reg_max_th1;
	int reg_middle_th;
	int reg_thold1;
	int reg_thold2;
	int reg_thold3;
	int reg_thold4;
	int reg_max_th2;
	int reg_pnum_th;
	int reg_hl0;
	int reg_hl1;
	int reg_hl2;
	int reg_hl3;
	int reg_display_adj;
	int reg_avg_th;
	int reg_avg_adj;
	int reg_low_adj;
	int reg_high_en;
	int reg_high_adj1;
	int reg_high_adj2;
	int reg_high_maxdiff;
	int reg_high_mindiff;
	unsigned int alpha;
};

struct vpp_lc_curve_s {
	unsigned int lc_saturation[63];
	unsigned int lc_yminval_lmt[16];
	unsigned int lc_ypkbv_ymaxval_lmt[16];
	unsigned int lc_ymaxval_lmt[16];
	unsigned int lc_ypkbv_lmt[16];
	unsigned int lc_ypkbv_ratio[4];
};

struct vpp_ble_param_s {
	unsigned int param[EN_BLE_PARAM_MAX];
};

struct vpp_cc_param_s {
	unsigned int param[EN_CC_PARAM_MAX];
};

struct vpp_bls_param_s {
	unsigned int param[EN_BLS_PARAM_MAX];
};

struct vpp_lc_param_s {
	unsigned int param[EN_LC_PARAM_MAX];
};

struct vpp_sharpness0_param_s {
	unsigned int param[EN_SHARPNESS0_PARAM_MAX];
};

struct vpp_sharpness1_param_s {
	unsigned int param[EN_SHARPNESS1_PARAM_MAX];
};

struct vpp_sr_param_s {
	unsigned char mode; /*0=sharpness0, 1=sharpness1*/
	unsigned int param[EN_SR_PARAM_MAX];
};

struct vpp_cabc_aad_param_s {
	unsigned int length;
	union {
		void *cabc_aad_param_ptr;
		long long cabc_aad_param_ptr_len;
	};
};

struct vpp_aad_param_s {
	int aad_param_cabc_aad_en;
	int aad_param_aad_en;
	int aad_param_tf_en;
	int aad_param_force_gain_en;
	int aad_param_sensor_mode;
	int aad_param_mode;
	int aad_param_dist_mode;
	int aad_param_tf_alpha;
	int aad_param_sensor_input[3];
	struct vpp_cabc_aad_param_s db_LUT_Y_gain;
	struct vpp_cabc_aad_param_s db_LUT_RG_gain;
	struct vpp_cabc_aad_param_s db_LUT_BG_gain;
	struct vpp_cabc_aad_param_s db_gain_lut;
	struct vpp_cabc_aad_param_s db_xy_lut;
};

struct vpp_cabc_param_s {
	int cabc_param_cabc_en;
	int cabc_param_hist_mode;
	int cabc_param_tf_en;
	int cabc_param_sc_flag;
	int cabc_param_bl_map_mode;
	int cabc_param_bl_map_en;
	int cabc_param_temp_proc;
	int cabc_param_max95_ratio;
	int cabc_param_hist_blend_alpha;
	int cabc_param_init_bl_min;
	int cabc_param_init_bl_max;
	int cabc_param_tf_alpha;
	int cabc_param_sc_hist_diff_thd;
	int cabc_param_sc_apl_diff_thd;
	int cabc_param_patch_bl_th;
	int cabc_param_patch_on_alpha;
	int cabc_param_patch_bl_off_th;
	int cabc_param_patch_off_alpha;
	struct vpp_cabc_aad_param_s db_o_bl_cv;
	struct vpp_cabc_aad_param_s db_maxbin_bl_cv;
};

struct vpp_dnlp_curve_param_s {
	unsigned int dnlp_scurv_low[VPP_DNLP_SCURV_LEN];
	unsigned int dnlp_scurv_mid1[VPP_DNLP_SCURV_LEN];
	unsigned int dnlp_scurv_mid2[VPP_DNLP_SCURV_LEN];
	unsigned int dnlp_scurv_hgh1[VPP_DNLP_SCURV_LEN];
	unsigned int dnlp_scurv_hgh2[VPP_DNLP_SCURV_LEN];
	unsigned int gain_var_lut49[VPP_DNLP_GAIN_VAR_LUT_LEN];
	unsigned int wext_gain[VPP_DNLP_WEXT_GAIN_LEN];
	unsigned int adp_thrd[VPP_DNLP_ADP_THRD_LEN];
	unsigned int reg_blk_boost_12[VPP_DNLP_REG_BLK_BOOST_LEN];
	unsigned int reg_adp_ofset_20[VPP_DNLP_REG_ADP_OFSET_LEN];
	unsigned int reg_mono_protect[VPP_DNLP_REG_MONO_PROT_LEN];
	unsigned int reg_trend_wht_expand_lut8[VPP_DNLP_TREND_WHT_EXP_LUT_LEN];
	unsigned int c_hist_gain[VPP_DNLP_HIST_GAIN_LEN];
	unsigned int s_hist_gain[VPP_DNLP_HIST_GAIN_LEN];
	unsigned int param[EN_DNLP_PARAM_MAX];
};

struct vpp_cm_curve_s {
	enum vpp_cm_curve_type_e curve_type;
	unsigned int data_size;
	void *pdata;
};

struct vpp_lut3d_path_s {
	enum vpp_lut3d_data_type_e data_type;
	unsigned char data_count;
	unsigned char path_length;
	unsigned char *ppath;
};

struct vpp_lut3d_table_s {
	enum vpp_lut3d_data_type_e data_type;
	unsigned char data_index;
	unsigned char data_check;
	unsigned int data_size;
	int *pdata;
};

struct vpp_aipq_table_s {
	unsigned int height;
	unsigned int width;
	union {
		void *table_ptr;
		long long table_len;
	};
};

struct vpp_eye_protect_s {
	bool enable;
	int rgb[EN_MODE_RGB_MAX];
};

struct vpp_module_ctrl_s {
	enum vpp_module_e module_type;
	bool status;
};

struct vpp_color_primary_s {/*R/G/B/W (x,y)*50000*/
	unsigned int data_src[VPP_COLOR_PRIMARY_LEN];
	unsigned int data_dest[VPP_COLOR_PRIMARY_LEN];
};

struct vpp_pq_tuning_reg_s {
	unsigned char reg_addr;
	unsigned char bit_start;
	unsigned char bit_end;
	unsigned int val;
};

struct vpp_pq_tuning_page_s {
	unsigned char page_addr;
	int page_idx;
	int reg_count;
	struct vpp_pq_tuning_reg_s *preg_list;
};

struct vpp_pq_tuning_table_s {
	int page_count;
	struct vpp_pq_tuning_page_s *ppage_list;
};

/*IOCtl*/
#define VPP_IOC_SET_BRIGHTNESS      _IOW(_VPP_TYPE, 0x01, int)
#define VPP_IOC_SET_CONTRAST        _IOW(_VPP_TYPE, 0x02, int)
#define VPP_IOC_SET_SATURATION      _IOW(_VPP_TYPE, 0x03, int)
#define VPP_IOC_SET_HUE             _IOW(_VPP_TYPE, 0x04, int)
#define VPP_IOC_SET_SHARPNESS       _IOW(_VPP_TYPE, 0x05, int)
#define VPP_IOC_SET_BRIGHTNESS_POST _IOW(_VPP_TYPE, 0x06, int)
#define VPP_IOC_SET_CONTRAST_POST   _IOW(_VPP_TYPE, 0x07, int)
#define VPP_IOC_SET_SATURATION_POST _IOW(_VPP_TYPE, 0x08, int)
#define VPP_IOC_SET_HUE_POST        _IOW(_VPP_TYPE, 0x09, int)
#define VPP_IOC_SET_WB              _IOW(_VPP_TYPE, 0x0a, struct vpp_white_balance_s)
#define VPP_IOC_SET_PRE_GAMMA_DATA  _IOW(_VPP_TYPE, 0x0b, struct vpp_pre_gamma_table_s)
#define VPP_IOC_SET_GAMMA_DATA      _IOW(_VPP_TYPE, 0x0c, struct vpp_gamma_table_s)
#define VPP_IOC_SET_MATRIX_PARAM    _IOW(_VPP_TYPE, 0x0d, struct vpp_mtrx_info_s)
#define VPP_IOC_SET_MODULE_STATUS   _IOW(_VPP_TYPE, 0x0e, struct vpp_module_ctrl_s)
#define VPP_IOC_SET_PQ_STATE        _IOW(_VPP_TYPE, 0x0f, struct vpp_pq_state_s)
#define VPP_IOC_SET_PC_MODE         _IOW(_VPP_TYPE, 0x10, enum vpp_pc_mode_e)

#define VPP_IOC_SET_DNLP_PARAM      _IOW(_VPP_TYPE, 0x11, struct vpp_dnlp_curve_param_s)
#define VPP_IOC_SET_LC_CURVE        _IOW(_VPP_TYPE, 0x12, struct vpp_lc_curve_s)
#define VPP_IOC_SET_LC_PARAM        _IOW(_VPP_TYPE, 0x13, struct vpp_lc_param_s)
#define VPP_IOC_SET_CSC_TYPE        _IOW(_VPP_TYPE, 0x14, enum vpp_csc_type_e)
#define VPP_IOC_SET_3DLUT_DATA      _IOW(_VPP_TYPE, 0x15, struct vpp_lut3d_table_s)

#define VPP_IOC_SET_HDR_TMO         _IOW(_VPP_TYPE, 0x16, struct vpp_hdr_lut_s)
#define VPP_IOC_SET_HDR_OETF        _IOW(_VPP_TYPE, 0x17, struct vpp_hdr_lut_s)
#define VPP_IOC_SET_HDR_EOTF        _IOW(_VPP_TYPE, 0x18, struct vpp_hdr_lut_s)
#define VPP_IOC_SET_HDR_CGAIN       _IOW(_VPP_TYPE, 0x19, struct vpp_hdr_lut_s)

#define VPP_IOC_SET_CM_CURVE        _IOW(_VPP_TYPE, 0x1a, struct vpp_cm_curve_s)
#define VPP_IOC_SET_CM_OFFSET_CURVE _IOW(_VPP_TYPE, 0x1b, struct vpp_cm_curve_s)

#define VPP_IOC_SET_EYE_PROTECT     _IOW(_VPP_TYPE, 0x1c, struct vpp_eye_protect_s)
#define VPP_IOC_SET_AIPQ_TABLE      _IOW(_VPP_TYPE, 0x1d, struct vpp_aipq_table_s)

#define VPP_IOC_SET_COLOR_PRIMARY_STATUS _IOW(_VPP_TYPE, 0x1e, int)
#define VPP_IOC_SET_COLOR_PRIMARY   _IOW(_VPP_TYPE, 0x1f, struct vpp_color_primary_s)

#define VPP_IOC_GET_PC_MODE         _IOR(_VPP_TYPE, 0x80, enum vpp_pc_mode_e)
#define VPP_IOC_GET_CSC_TYPE        _IOR(_VPP_TYPE, 0x81, enum vpp_csc_type_e)
#define VPP_IOC_GET_HDR_TYPE        _IOR(_VPP_TYPE, 0x82, enum vpp_hdr_type_e)
#define VPP_IOC_GET_COLOR_PRIM      _IOR(_VPP_TYPE, 0x83, enum vpp_color_primary_e)
#define VPP_IOC_GET_HDR_METADATA    _IOR(_VPP_TYPE, 0x84, struct vpp_hdr_metadata_s)
#define VPP_IOC_GET_HIST_AVG        _IOR(_VPP_TYPE, 0x85, struct vpp_histgm_ave_s)
#define VPP_IOC_GET_HIST_BIN        _IOR(_VPP_TYPE, 0x86, struct vpp_histgm_param_s)
#define VPP_IOC_GET_PQ_STATE        _IOR(_VPP_TYPE, 0x87, struct vpp_pq_state_s)
#define VPP_IOC_GET_HDR_HIST        _IOR(_VPP_TYPE, 0x88, struct vpp_hdr_histgm_param_s)

#endif

