/*
 * Copyright (c) 2021-2022 Amlogic, Inc. All rights reserved.
 *
 * SPDX-License-Identifier: MIT
 */

#ifndef __BD71837_H__

#define __BD71837_H__

#include "pmic.h"

/* I2C slave address */
#define bd718x7_slave_address 0x4b

enum {
	BD718XX_BUCK1 = 0,
	BD718XX_BUCK2,
	BD718XX_BUCK3,
	BD718XX_BUCK4,
	BD718XX_BUCK5,
	BD718XX_BUCK6,
	BD718XX_BUCK7,
	BD718XX_BUCK8,
	BD718XX_LDO1,
	BD718XX_LDO2,
	BD718XX_LDO3,
	BD718XX_LDO4,
	BD718XX_LDO5,
	BD718XX_LDO6,
	BD718XX_LDO7,
	BD718XX_REGULATOR_AMOUNT,
};

/* Common voltage configurations */
#define BD718XX_DVS_BUCK_VOLTAGE_NUM 0x3D
#define BD718XX_4TH_NODVS_BUCK_VOLTAGE_NUM 0x3D

#define BD718XX_LDO1_VOLTAGE_NUM 0x08
#define BD718XX_LDO2_VOLTAGE_NUM 0x02
#define BD718XX_LDO3_VOLTAGE_NUM 0x10
#define BD718XX_LDO4_VOLTAGE_NUM 0x0A
#define BD718XX_LDO6_VOLTAGE_NUM 0x0A

/* BD71837 specific voltage configurations */
#define BD71837_BUCK5_VOLTAGE_NUM 0x10
#define BD71837_BUCK6_VOLTAGE_NUM 0x04
#define BD71837_BUCK7_VOLTAGE_NUM 0x08
#define BD71837_LDO5_VOLTAGE_NUM 0x10
#define BD71837_LDO7_VOLTAGE_NUM 0x10

/* BD71847 specific voltage configurations */
#define BD71847_BUCK3_VOLTAGE_NUM 0x18
#define BD71847_BUCK4_VOLTAGE_NUM 0x08
#define BD71847_LDO5_VOLTAGE_NUM 0x20

/* Registers specific to BD71837 */
enum {
	BD71837_REG_BUCK3_CTRL = 0x07,
	BD71837_REG_BUCK4_CTRL = 0x08,
	BD71837_REG_BUCK3_VOLT_RUN = 0x12,
	BD71837_REG_BUCK4_VOLT_RUN = 0x13,
	BD71837_REG_LDO7_VOLT = 0x1E,
};

/* Registers common for BD71837 and BD71847 */
enum {
	BD718XX_REG_REV = 0x00,
	BD718XX_REG_SWRESET = 0x01,
	BD718XX_REG_I2C_DEV = 0x02,
	BD718XX_REG_PWRCTRL0 = 0x03,
	BD718XX_REG_PWRCTRL1 = 0x04,
	BD718XX_REG_BUCK1_CTRL = 0x05,
	BD718XX_REG_BUCK2_CTRL = 0x06,
	BD718XX_REG_1ST_NODVS_BUCK_CTRL = 0x09,
	BD718XX_REG_2ND_NODVS_BUCK_CTRL = 0x0A,
	BD718XX_REG_3RD_NODVS_BUCK_CTRL = 0x0B,
	BD718XX_REG_4TH_NODVS_BUCK_CTRL = 0x0C,
	BD718XX_REG_BUCK1_VOLT_RUN = 0x0D,
	BD718XX_REG_BUCK1_VOLT_IDLE = 0x0E,
	BD718XX_REG_BUCK1_VOLT_SUSP = 0x0F,
	BD718XX_REG_BUCK2_VOLT_RUN = 0x10,
	BD718XX_REG_BUCK2_VOLT_IDLE = 0x11,
	BD718XX_REG_1ST_NODVS_BUCK_VOLT = 0x14,
	BD718XX_REG_2ND_NODVS_BUCK_VOLT = 0x15,
	BD718XX_REG_3RD_NODVS_BUCK_VOLT = 0x16,
	BD718XX_REG_4TH_NODVS_BUCK_VOLT = 0x17,
	BD718XX_REG_LDO1_VOLT = 0x18,
	BD718XX_REG_LDO2_VOLT = 0x19,
	BD718XX_REG_LDO3_VOLT = 0x1A,
	BD718XX_REG_LDO4_VOLT = 0x1B,
	BD718XX_REG_LDO5_VOLT = 0x1C,
	BD718XX_REG_LDO6_VOLT = 0x1D,
	BD718XX_REG_TRANS_COND0 = 0x1F,
	BD718XX_REG_TRANS_COND1 = 0x20,
	BD718XX_REG_VRFAULTEN = 0x21,
	BD718XX_REG_MVRFLTMASK0 = 0x22,
	BD718XX_REG_MVRFLTMASK1 = 0x23,
	BD718XX_REG_MVRFLTMASK2 = 0x24,
	BD718XX_REG_RCVCFG = 0x25,
	BD718XX_REG_RCVNUM = 0x26,
	BD718XX_REG_PWRONCONFIG0 = 0x27,
	BD718XX_REG_PWRONCONFIG1 = 0x28,
	BD718XX_REG_RESETSRC = 0x29,
	BD718XX_REG_MIRQ = 0x2A,
	BD718XX_REG_IRQ = 0x2B,
	BD718XX_REG_IN_MON = 0x2C,
	BD718XX_REG_POW_STATE = 0x2D,
	BD718XX_REG_OUT32K = 0x2E,
	BD718XX_REG_REGLOCK = 0x2F,
	BD718XX_REG_OTPVER = 0xFF,
	BD718XX_MAX_REGISTER = 0x100,
};

#define REGLOCK_PWRSEQ 0x1
#define REGLOCK_VREG 0x10

/* Generic BUCK control masks */
#define BD718XX_BUCK_SEL 0x02
#define BD718XX_BUCK_EN 0x01
#define BD718XX_BUCK_RUN_ON 0x04

/* Generic LDO masks */
#define BD718XX_LDO_SEL 0x80
#define BD718XX_LDO_EN 0x40

/* BD71837 BUCK ramp rate CTRL reg bits */
#define BUCK_RAMPRATE_MASK 0xC0
#define BUCK_RAMPRATE_10P00MV 0x0
#define BUCK_RAMPRATE_5P00MV 0x1
#define BUCK_RAMPRATE_2P50MV 0x2
#define BUCK_RAMPRATE_1P25MV 0x3

#define DVS_BUCK_RUN_MASK 0x3F
#define DVS_BUCK_SUSP_MASK 0x3F
#define DVS_BUCK_IDLE_MASK 0x3F

#define BD718XX_1ST_NODVS_BUCK_MASK 0x07
#define BD718XX_3RD_NODVS_BUCK_MASK 0x07
#define BD718XX_4TH_NODVS_BUCK_MASK 0x3F

#define BD71847_BUCK3_MASK 0x07
#define BD71847_BUCK3_RANGE_MASK 0xC0
#define BD71847_BUCK4_MASK 0x03
#define BD71847_BUCK4_RANGE_MASK 0x40

#define BD71837_BUCK5_MASK 0x07
#define BD71837_BUCK5_RANGE_MASK 0x80
#define BD71837_BUCK6_MASK 0x03

#define BD718XX_LDO1_MASK 0x03
#define BD718XX_LDO1_RANGE_MASK 0x20
#define BD718XX_LDO2_MASK 0x20
#define BD718XX_LDO3_MASK 0x0F
#define BD718XX_LDO4_MASK 0x0F
#define BD718XX_LDO6_MASK 0x0F

#define BD71837_LDO5_MASK 0x0F
#define BD71847_LDO5_MASK 0x0F
#define BD71847_LDO5_RANGE_MASK 0x20

#define BD71837_LDO7_MASK 0x0F

/* BD718XX Voltage monitoring masks */
#define BD718XX_BUCK1_VRMON80 0x1
#define BD718XX_BUCK1_VRMON130 0x2
#define BD718XX_BUCK2_VRMON80 0x4
#define BD718XX_BUCK2_VRMON130 0x8
#define BD718XX_1ST_NODVS_BUCK_VRMON80 0x1
#define BD718XX_1ST_NODVS_BUCK_VRMON130 0x2
#define BD718XX_2ND_NODVS_BUCK_VRMON80 0x4
#define BD718XX_2ND_NODVS_BUCK_VRMON130 0x8
#define BD718XX_3RD_NODVS_BUCK_VRMON80 0x10
#define BD718XX_3RD_NODVS_BUCK_VRMON130 0x20
#define BD718XX_4TH_NODVS_BUCK_VRMON80 0x40
#define BD718XX_4TH_NODVS_BUCK_VRMON130 0x80
#define BD718XX_LDO1_VRMON80 0x1
#define BD718XX_LDO2_VRMON80 0x2
#define BD718XX_LDO3_VRMON80 0x4
#define BD718XX_LDO4_VRMON80 0x8
#define BD718XX_LDO5_VRMON80 0x10
#define BD718XX_LDO6_VRMON80 0x20

/* BD71837 specific voltage monitoring masks */
#define BD71837_BUCK3_VRMON80 0x10
#define BD71837_BUCK3_VRMON130 0x20
#define BD71837_BUCK4_VRMON80 0x40
#define BD71837_BUCK4_VRMON130 0x80
#define BD71837_LDO7_VRMON80 0x40

/* BD718XX_REG_IRQ bits */
#define IRQ_SWRST 0x40
#define IRQ_PWRON_S 0x20
#define IRQ_PWRON_L 0x10
#define IRQ_PWRON 0x08
#define IRQ_WDOG 0x04
#define IRQ_ON_REQ 0x02
#define IRQ_STBY_REQ 0x01

/* BD718XX_REG_OUT32K bits */
#define BD718XX_OUT32K_EN 0x01

/* BD7183XX gated clock rate */
#define BD718XX_CLK_RATE 32768

/* ROHM BD718XX irqs */
enum {
	BD718XX_INT_STBY_REQ,
	BD718XX_INT_ON_REQ,
	BD718XX_INT_WDOG,
	BD718XX_INT_PWRBTN,
	BD718XX_INT_PWRBTN_L,
	BD718XX_INT_PWRBTN_S,
	BD718XX_INT_SWRST
};

/* ROHM BD718XX interrupt masks */
#define BD718XX_INT_SWRST_MASK 0x40
#define BD718XX_INT_PWRBTN_S_MASK 0x20
#define BD718XX_INT_PWRBTN_L_MASK 0x10
#define BD718XX_INT_PWRBTN_MASK 0x8
#define BD718XX_INT_WDOG_MASK 0x4
#define BD718XX_INT_ON_REQ_MASK 0x2
#define BD718XX_INT_STBY_REQ_MASK 0x1

/* Register write induced reset settings */

/*
 * Even though the bit zero is not SWRESET type we still want to write zero
 * to it when changing type. Bit zero is 'SWRESET' trigger bit and if we
 * write 1 to it we will trigger the action. So always write 0 to it when
 * changning SWRESET action - no matter what we read from it.
 */
#define BD718XX_SWRESET_TYPE_MASK 7
#define BD718XX_SWRESET_TYPE_DISABLED 0
#define BD718XX_SWRESET_TYPE_COLD 4
#define BD718XX_SWRESET_TYPE_WARM 6

#define BD718XX_SWRESET_RESET_MASK 1
#define BD718XX_SWRESET_RESET 1

/* Poweroff state transition conditions */

#define BD718XX_ON_REQ_POWEROFF_MASK 1
#define BD718XX_SWRESET_POWEROFF_MASK 2
#define BD718XX_WDOG_POWEROFF_MASK 4
#define BD718XX_KEY_L_POWEROFF_MASK 8

#define BD718XX_POWOFF_TO_SNVS 0
#define BD718XX_POWOFF_TO_RDY 0xF

#define BD718XX_POWOFF_TIME_MASK 0xF0
enum {
	BD718XX_POWOFF_TIME_5MS = 0,
	BD718XX_POWOFF_TIME_10MS,
	BD718XX_POWOFF_TIME_15MS,
	BD718XX_POWOFF_TIME_20MS,
	BD718XX_POWOFF_TIME_25MS,
	BD718XX_POWOFF_TIME_30MS,
	BD718XX_POWOFF_TIME_35MS,
	BD718XX_POWOFF_TIME_40MS,
	BD718XX_POWOFF_TIME_45MS,
	BD718XX_POWOFF_TIME_50MS,
	BD718XX_POWOFF_TIME_75MS,
	BD718XX_POWOFF_TIME_100MS,
	BD718XX_POWOFF_TIME_250MS,
	BD718XX_POWOFF_TIME_500MS,
	BD718XX_POWOFF_TIME_750MS,
	BD718XX_POWOFF_TIME_1500MS
};

/* Poweron sequence state transition conditions */
#define BD718XX_RDY_TO_SNVS_MASK 0xF
#define BD718XX_SNVS_TO_RUN_MASK 0xF0

#define BD718XX_PWR_TRIG_KEY_L 1
#define BD718XX_PWR_TRIG_KEY_S 2
#define BD718XX_PWR_TRIG_PMIC_ON 4
#define BD718XX_PWR_TRIG_VSYS_UVLO 8
#define BD718XX_RDY_TO_SNVS_SIFT 0
#define BD718XX_SNVS_TO_RUN_SIFT 4

#define BD718XX_PWRBTN_PRESS_DURATION_MASK 0xF

/* Timeout value for detecting short press */
enum {
	BD718XX_PWRBTN_SHORT_PRESS_10MS = 0,
	BD718XX_PWRBTN_SHORT_PRESS_500MS,
	BD718XX_PWRBTN_SHORT_PRESS_1000MS,
	BD718XX_PWRBTN_SHORT_PRESS_1500MS,
	BD718XX_PWRBTN_SHORT_PRESS_2000MS,
	BD718XX_PWRBTN_SHORT_PRESS_2500MS,
	BD718XX_PWRBTN_SHORT_PRESS_3000MS,
	BD718XX_PWRBTN_SHORT_PRESS_3500MS,
	BD718XX_PWRBTN_SHORT_PRESS_4000MS,
	BD718XX_PWRBTN_SHORT_PRESS_4500MS,
	BD718XX_PWRBTN_SHORT_PRESS_5000MS,
	BD718XX_PWRBTN_SHORT_PRESS_5500MS,
	BD718XX_PWRBTN_SHORT_PRESS_6000MS,
	BD718XX_PWRBTN_SHORT_PRESS_6500MS,
	BD718XX_PWRBTN_SHORT_PRESS_7000MS,
	BD718XX_PWRBTN_SHORT_PRESS_7500MS
};

/* Timeout value for detecting LONG press */
enum {
	BD718XX_PWRBTN_LONG_PRESS_10MS = 0,
	BD718XX_PWRBTN_LONG_PRESS_1S,
	BD718XX_PWRBTN_LONG_PRESS_2S,
	BD718XX_PWRBTN_LONG_PRESS_3S,
	BD718XX_PWRBTN_LONG_PRESS_4S,
	BD718XX_PWRBTN_LONG_PRESS_5S,
	BD718XX_PWRBTN_LONG_PRESS_6S,
	BD718XX_PWRBTN_LONG_PRESS_7S,
	BD718XX_PWRBTN_LONG_PRESS_8S,
	BD718XX_PWRBTN_LONG_PRESS_9S,
	BD718XX_PWRBTN_LONG_PRESS_10S,
	BD718XX_PWRBTN_LONG_PRESS_11S,
	BD718XX_PWRBTN_LONG_PRESS_12S,
	BD718XX_PWRBTN_LONG_PRESS_13S,
	BD718XX_PWRBTN_LONG_PRESS_14S,
	BD718XX_PWRBTN_LONG_PRESS_15S
};

enum {
	ROHM_CHIP_TYPE_BD71837 = 0,
	ROHM_CHIP_TYPE_BD71847,
	ROHM_CHIP_TYPE_BD70528,
	ROHM_CHIP_TYPE_AMOUNT
};

extern struct pmic_regulator BD71837_PMIC;

#endif /* __BD71837_H__ */
