assert = {
    sameValue: function (input, expected, message) {
        if (input !== expected)
            throw new Error(message);
    }
};

function testSub(x, y, z) {
    assert.sameValue(x - y, z, x + " - " + y + " = " + z);
}

testSub(0xFEDCBA9876543210n, 0xFEDCBA9876543210n, 0x0n);
testSub(0xFEDCBA9876543210n, 0xFEDCBA987654320Fn, 0x1n);
testSub(0xFEDCBA9876543210n, 0xFEDCBA98n, 0xFEDCBA9777777778n);
testSub(0xFEDCBA9876543210n, 0xFEDCBA97n, 0xFEDCBA9777777779n);
testSub(0xFEDCBA9876543210n, 0x1234n, 0xFEDCBA9876541FDCn);
testSub(0xFEDCBA9876543210n, 0x3n, 0xFEDCBA987654320Dn);
testSub(0xFEDCBA9876543210n, 0x2n, 0xFEDCBA987654320En);
testSub(0xFEDCBA9876543210n, 0x1n, 0xFEDCBA987654320Fn);
testSub(0xFEDCBA9876543210n, 0x0n, 0xFEDCBA9876543210n);
testSub(0xFEDCBA9876543210n, -0x1n, 0xFEDCBA9876543211n);
testSub(0xFEDCBA9876543210n, -0x2n, 0xFEDCBA9876543212n);
testSub(0xFEDCBA9876543210n, -0x3n, 0xFEDCBA9876543213n);
testSub(0xFEDCBA9876543210n, -0x1234n, 0xFEDCBA9876544444n);
testSub(0xFEDCBA9876543210n, -0xFEDCBA97n, 0xFEDCBA997530ECA7n);
testSub(0xFEDCBA9876543210n, -0xFEDCBA98n, 0xFEDCBA997530ECA8n);
testSub(0xFEDCBA9876543210n, -0xFEDCBA987654320Fn, 0x1FDB97530ECA8641Fn);
testSub(0xFEDCBA9876543210n, -0xFEDCBA9876543210n, 0x1FDB97530ECA86420n);
testSub(0xFEDCBA987654320Fn, 0xFEDCBA9876543210n, -0x1n);
testSub(0xFEDCBA987654320Fn, 0xFEDCBA987654320Fn, 0x0n);
testSub(0xFEDCBA987654320Fn, 0xFEDCBA98n, 0xFEDCBA9777777777n);
testSub(0xFEDCBA987654320Fn, 0xFEDCBA97n, 0xFEDCBA9777777778n);
testSub(0xFEDCBA987654320Fn, 0x1234n, 0xFEDCBA9876541FDBn);
testSub(0xFEDCBA987654320Fn, 0x3n, 0xFEDCBA987654320Cn);
testSub(0xFEDCBA987654320Fn, 0x2n, 0xFEDCBA987654320Dn);
testSub(0xFEDCBA987654320Fn, 0x1n, 0xFEDCBA987654320En);
testSub(0xFEDCBA987654320Fn, 0x0n, 0xFEDCBA987654320Fn);
testSub(0xFEDCBA987654320Fn, -0x1n, 0xFEDCBA9876543210n);
testSub(0xFEDCBA987654320Fn, -0x2n, 0xFEDCBA9876543211n);
testSub(0xFEDCBA987654320Fn, -0x3n, 0xFEDCBA9876543212n);
testSub(0xFEDCBA987654320Fn, -0x1234n, 0xFEDCBA9876544443n);
testSub(0xFEDCBA987654320Fn, -0xFEDCBA97n, 0xFEDCBA997530ECA6n);
testSub(0xFEDCBA987654320Fn, -0xFEDCBA98n, 0xFEDCBA997530ECA7n);
testSub(0xFEDCBA987654320Fn, -0xFEDCBA987654320Fn, 0x1FDB97530ECA8641En);
testSub(0xFEDCBA987654320Fn, -0xFEDCBA9876543210n, 0x1FDB97530ECA8641Fn);
testSub(0xFEDCBA98n, 0xFEDCBA9876543210n, -0xFEDCBA9777777778n);
testSub(0xFEDCBA98n, 0xFEDCBA987654320Fn, -0xFEDCBA9777777777n);
testSub(0xFEDCBA98n, 0xFEDCBA98n, 0x0n);
testSub(0xFEDCBA98n, 0xFEDCBA97n, 0x1n);
testSub(0xFEDCBA98n, 0x1234n, 0xFEDCA864n);
testSub(0xFEDCBA98n, 0x3n, 0xFEDCBA95n);
testSub(0xFEDCBA98n, 0x2n, 0xFEDCBA96n);
testSub(0xFEDCBA98n, 0x1n, 0xFEDCBA97n);
testSub(0xFEDCBA98n, 0x0n, 0xFEDCBA98n);
testSub(0xFEDCBA98n, -0x1n, 0xFEDCBA99n);
testSub(0xFEDCBA98n, -0x2n, 0xFEDCBA9An);
testSub(0xFEDCBA98n, -0x3n, 0xFEDCBA9Bn);
testSub(0xFEDCBA98n, -0x1234n, 0xFEDCCCCCn);
testSub(0xFEDCBA98n, -0xFEDCBA97n, 0x1FDB9752Fn);
testSub(0xFEDCBA98n, -0xFEDCBA98n, 0x1FDB97530n);
testSub(0xFEDCBA98n, -0xFEDCBA987654320Fn, 0xFEDCBA997530ECA7n);
testSub(0xFEDCBA98n, -0xFEDCBA9876543210n, 0xFEDCBA997530ECA8n);
testSub(0xFEDCBA97n, 0xFEDCBA9876543210n, -0xFEDCBA9777777779n);
testSub(0xFEDCBA97n, 0xFEDCBA987654320Fn, -0xFEDCBA9777777778n);
testSub(0xFEDCBA97n, 0xFEDCBA98n, -0x1n);
testSub(0xFEDCBA97n, 0xFEDCBA97n, 0x0n);
testSub(0xFEDCBA97n, 0x1234n, 0xFEDCA863n);
testSub(0xFEDCBA97n, 0x3n, 0xFEDCBA94n);
testSub(0xFEDCBA97n, 0x2n, 0xFEDCBA95n);
testSub(0xFEDCBA97n, 0x1n, 0xFEDCBA96n);
testSub(0xFEDCBA97n, 0x0n, 0xFEDCBA97n);
testSub(0xFEDCBA97n, -0x1n, 0xFEDCBA98n);
testSub(0xFEDCBA97n, -0x2n, 0xFEDCBA99n);
testSub(0xFEDCBA97n, -0x3n, 0xFEDCBA9An);
testSub(0xFEDCBA97n, -0x1234n, 0xFEDCCCCBn);
testSub(0xFEDCBA97n, -0xFEDCBA97n, 0x1FDB9752En);
testSub(0xFEDCBA97n, -0xFEDCBA98n, 0x1FDB9752Fn);
testSub(0xFEDCBA97n, -0xFEDCBA987654320Fn, 0xFEDCBA997530ECA6n);
testSub(0xFEDCBA97n, -0xFEDCBA9876543210n, 0xFEDCBA997530ECA7n);
testSub(0x1234n, 0xFEDCBA9876543210n, -0xFEDCBA9876541FDCn);
testSub(0x1234n, 0xFEDCBA987654320Fn, -0xFEDCBA9876541FDBn);
testSub(0x1234n, 0xFEDCBA98n, -0xFEDCA864n);
testSub(0x1234n, 0xFEDCBA97n, -0xFEDCA863n);
testSub(0x1234n, 0x1234n, 0x0n);
testSub(0x1234n, 0x3n, 0x1231n);
testSub(0x1234n, 0x2n, 0x1232n);
testSub(0x1234n, 0x1n, 0x1233n);
testSub(0x1234n, 0x0n, 0x1234n);
testSub(0x1234n, -0x1n, 0x1235n);
testSub(0x1234n, -0x2n, 0x1236n);
testSub(0x1234n, -0x3n, 0x1237n);
testSub(0x1234n, -0x1234n, 0x2468n);
testSub(0x1234n, -0xFEDCBA97n, 0xFEDCCCCBn);
testSub(0x1234n, -0xFEDCBA98n, 0xFEDCCCCCn);
testSub(0x1234n, -0xFEDCBA987654320Fn, 0xFEDCBA9876544443n);
testSub(0x1234n, -0xFEDCBA9876543210n, 0xFEDCBA9876544444n);
testSub(0x3n, 0xFEDCBA9876543210n, -0xFEDCBA987654320Dn);
testSub(0x3n, 0xFEDCBA987654320Fn, -0xFEDCBA987654320Cn);
testSub(0x3n, 0xFEDCBA98n, -0xFEDCBA95n);
testSub(0x3n, 0xFEDCBA97n, -0xFEDCBA94n);
testSub(0x3n, 0x1234n, -0x1231n);
testSub(0x3n, 0x3n, 0x0n);
testSub(0x3n, 0x2n, 0x1n);
testSub(0x3n, 0x1n, 0x2n);
testSub(0x3n, 0x0n, 0x3n);
testSub(0x3n, -0x1n, 0x4n);
testSub(0x3n, -0x2n, 0x5n);
testSub(0x3n, -0x3n, 0x6n);
testSub(0x3n, -0x1234n, 0x1237n);
testSub(0x3n, -0xFEDCBA97n, 0xFEDCBA9An);
testSub(0x3n, -0xFEDCBA98n, 0xFEDCBA9Bn);
testSub(0x3n, -0xFEDCBA987654320Fn, 0xFEDCBA9876543212n);
testSub(0x3n, -0xFEDCBA9876543210n, 0xFEDCBA9876543213n);
testSub(0x2n, 0xFEDCBA9876543210n, -0xFEDCBA987654320En);
testSub(0x2n, 0xFEDCBA987654320Fn, -0xFEDCBA987654320Dn);
testSub(0x2n, 0xFEDCBA98n, -0xFEDCBA96n);
testSub(0x2n, 0xFEDCBA97n, -0xFEDCBA95n);
testSub(0x2n, 0x1234n, -0x1232n);
testSub(0x2n, 0x3n, -0x1n);
testSub(0x2n, 0x2n, 0x0n);
testSub(0x2n, 0x1n, 0x1n);
testSub(0x2n, 0x0n, 0x2n);
testSub(0x2n, -0x1n, 0x3n);
testSub(0x2n, -0x2n, 0x4n);
testSub(0x2n, -0x3n, 0x5n);
testSub(0x2n, -0x1234n, 0x1236n);
testSub(0x2n, -0xFEDCBA97n, 0xFEDCBA99n);
testSub(0x2n, -0xFEDCBA98n, 0xFEDCBA9An);
testSub(0x2n, -0xFEDCBA987654320Fn, 0xFEDCBA9876543211n);
testSub(0x2n, -0xFEDCBA9876543210n, 0xFEDCBA9876543212n);
testSub(0x1n, 0xFEDCBA9876543210n, -0xFEDCBA987654320Fn);
testSub(0x1n, 0xFEDCBA987654320Fn, -0xFEDCBA987654320En);
testSub(0x1n, 0xFEDCBA98n, -0xFEDCBA97n);
testSub(0x1n, 0xFEDCBA97n, -0xFEDCBA96n);
testSub(0x1n, 0x1234n, -0x1233n);
testSub(0x1n, 0x3n, -0x2n);
testSub(0x1n, 0x2n, -0x1n);
testSub(0x1n, 0x1n, 0x0n);
testSub(0x1n, 0x0n, 0x1n);
testSub(0x1n, -0x1n, 0x2n);
testSub(0x1n, -0x2n, 0x3n);
testSub(0x1n, -0x3n, 0x4n);
testSub(0x1n, -0x1234n, 0x1235n);
testSub(0x1n, -0xFEDCBA97n, 0xFEDCBA98n);
testSub(0x1n, -0xFEDCBA98n, 0xFEDCBA99n);
testSub(0x1n, -0xFEDCBA987654320Fn, 0xFEDCBA9876543210n);
testSub(0x1n, -0xFEDCBA9876543210n, 0xFEDCBA9876543211n);
testSub(0x0n, 0xFEDCBA9876543210n, -0xFEDCBA9876543210n);
testSub(0x0n, 0xFEDCBA987654320Fn, -0xFEDCBA987654320Fn);
testSub(0x0n, 0xFEDCBA98n, -0xFEDCBA98n);
testSub(0x0n, 0xFEDCBA97n, -0xFEDCBA97n);
testSub(0x0n, 0x1234n, -0x1234n);
testSub(0x0n, 0x3n, -0x3n);
testSub(0x0n, 0x2n, -0x2n);
testSub(0x0n, 0x1n, -0x1n);
testSub(0x0n, 0x0n, 0x0n);
testSub(0x0n, -0x1n, 0x1n);
testSub(0x0n, -0x2n, 0x2n);
testSub(0x0n, -0x3n, 0x3n);
testSub(0x0n, -0x1234n, 0x1234n);
testSub(0x0n, -0xFEDCBA97n, 0xFEDCBA97n);
testSub(0x0n, -0xFEDCBA98n, 0xFEDCBA98n);
testSub(0x0n, -0xFEDCBA987654320Fn, 0xFEDCBA987654320Fn);
testSub(0x0n, -0xFEDCBA9876543210n, 0xFEDCBA9876543210n);
testSub(-0x1n, 0xFEDCBA9876543210n, -0xFEDCBA9876543211n);
testSub(-0x1n, 0xFEDCBA987654320Fn, -0xFEDCBA9876543210n);
testSub(-0x1n, 0xFEDCBA98n, -0xFEDCBA99n);
testSub(-0x1n, 0xFEDCBA97n, -0xFEDCBA98n);
testSub(-0x1n, 0x1234n, -0x1235n);
testSub(-0x1n, 0x3n, -0x4n);
testSub(-0x1n, 0x2n, -0x3n);
testSub(-0x1n, 0x1n, -0x2n);
testSub(-0x1n, 0x0n, -0x1n);
testSub(-0x1n, -0x1n, 0x0n);
testSub(-0x1n, -0x2n, 0x1n);
testSub(-0x1n, -0x3n, 0x2n);
testSub(-0x1n, -0x1234n, 0x1233n);
testSub(-0x1n, -0xFEDCBA97n, 0xFEDCBA96n);
testSub(-0x1n, -0xFEDCBA98n, 0xFEDCBA97n);
testSub(-0x1n, -0xFEDCBA987654320Fn, 0xFEDCBA987654320En);
testSub(-0x1n, -0xFEDCBA9876543210n, 0xFEDCBA987654320Fn);
testSub(-0x2n, 0xFEDCBA9876543210n, -0xFEDCBA9876543212n);
testSub(-0x2n, 0xFEDCBA987654320Fn, -0xFEDCBA9876543211n);
testSub(-0x2n, 0xFEDCBA98n, -0xFEDCBA9An);
testSub(-0x2n, 0xFEDCBA97n, -0xFEDCBA99n);
testSub(-0x2n, 0x1234n, -0x1236n);
testSub(-0x2n, 0x3n, -0x5n);
testSub(-0x2n, 0x2n, -0x4n);
testSub(-0x2n, 0x1n, -0x3n);
testSub(-0x2n, 0x0n, -0x2n);
testSub(-0x2n, -0x1n, -0x1n);
testSub(-0x2n, -0x2n, 0x0n);
testSub(-0x2n, -0x3n, 0x1n);
testSub(-0x2n, -0x1234n, 0x1232n);
testSub(-0x2n, -0xFEDCBA97n, 0xFEDCBA95n);
testSub(-0x2n, -0xFEDCBA98n, 0xFEDCBA96n);
testSub(-0x2n, -0xFEDCBA987654320Fn, 0xFEDCBA987654320Dn);
testSub(-0x2n, -0xFEDCBA9876543210n, 0xFEDCBA987654320En);
testSub(-0x3n, 0xFEDCBA9876543210n, -0xFEDCBA9876543213n);
testSub(-0x3n, 0xFEDCBA987654320Fn, -0xFEDCBA9876543212n);
testSub(-0x3n, 0xFEDCBA98n, -0xFEDCBA9Bn);
testSub(-0x3n, 0xFEDCBA97n, -0xFEDCBA9An);
testSub(-0x3n, 0x1234n, -0x1237n);
testSub(-0x3n, 0x3n, -0x6n);
testSub(-0x3n, 0x2n, -0x5n);
testSub(-0x3n, 0x1n, -0x4n);
testSub(-0x3n, 0x0n, -0x3n);
testSub(-0x3n, -0x1n, -0x2n);
testSub(-0x3n, -0x2n, -0x1n);
testSub(-0x3n, -0x3n, 0x0n);
testSub(-0x3n, -0x1234n, 0x1231n);
testSub(-0x3n, -0xFEDCBA97n, 0xFEDCBA94n);
testSub(-0x3n, -0xFEDCBA98n, 0xFEDCBA95n);
testSub(-0x3n, -0xFEDCBA987654320Fn, 0xFEDCBA987654320Cn);
testSub(-0x3n, -0xFEDCBA9876543210n, 0xFEDCBA987654320Dn);
testSub(-0x1234n, 0xFEDCBA9876543210n, -0xFEDCBA9876544444n);
testSub(-0x1234n, 0xFEDCBA987654320Fn, -0xFEDCBA9876544443n);
testSub(-0x1234n, 0xFEDCBA98n, -0xFEDCCCCCn);
testSub(-0x1234n, 0xFEDCBA97n, -0xFEDCCCCBn);
testSub(-0x1234n, 0x1234n, -0x2468n);
testSub(-0x1234n, 0x3n, -0x1237n);
testSub(-0x1234n, 0x2n, -0x1236n);
testSub(-0x1234n, 0x1n, -0x1235n);
testSub(-0x1234n, 0x0n, -0x1234n);
testSub(-0x1234n, -0x1n, -0x1233n);
testSub(-0x1234n, -0x2n, -0x1232n);
testSub(-0x1234n, -0x3n, -0x1231n);
testSub(-0x1234n, -0x1234n, 0x0n);
testSub(-0x1234n, -0xFEDCBA97n, 0xFEDCA863n);
testSub(-0x1234n, -0xFEDCBA98n, 0xFEDCA864n);
testSub(-0x1234n, -0xFEDCBA987654320Fn, 0xFEDCBA9876541FDBn);
testSub(-0x1234n, -0xFEDCBA9876543210n, 0xFEDCBA9876541FDCn);
testSub(-0xFEDCBA97n, 0xFEDCBA9876543210n, -0xFEDCBA997530ECA7n);
testSub(-0xFEDCBA97n, 0xFEDCBA987654320Fn, -0xFEDCBA997530ECA6n);
testSub(-0xFEDCBA97n, 0xFEDCBA98n, -0x1FDB9752Fn);
testSub(-0xFEDCBA97n, 0xFEDCBA97n, -0x1FDB9752En);
testSub(-0xFEDCBA97n, 0x1234n, -0xFEDCCCCBn);
testSub(-0xFEDCBA97n, 0x3n, -0xFEDCBA9An);
testSub(-0xFEDCBA97n, 0x2n, -0xFEDCBA99n);
testSub(-0xFEDCBA97n, 0x1n, -0xFEDCBA98n);
testSub(-0xFEDCBA97n, 0x0n, -0xFEDCBA97n);
testSub(-0xFEDCBA97n, -0x1n, -0xFEDCBA96n);
testSub(-0xFEDCBA97n, -0x2n, -0xFEDCBA95n);
testSub(-0xFEDCBA97n, -0x3n, -0xFEDCBA94n);
testSub(-0xFEDCBA97n, -0x1234n, -0xFEDCA863n);
testSub(-0xFEDCBA97n, -0xFEDCBA97n, 0x0n);
testSub(-0xFEDCBA97n, -0xFEDCBA98n, 0x1n);
testSub(-0xFEDCBA97n, -0xFEDCBA987654320Fn, 0xFEDCBA9777777778n);
testSub(-0xFEDCBA97n, -0xFEDCBA9876543210n, 0xFEDCBA9777777779n);
testSub(-0xFEDCBA98n, 0xFEDCBA9876543210n, -0xFEDCBA997530ECA8n);
testSub(-0xFEDCBA98n, 0xFEDCBA987654320Fn, -0xFEDCBA997530ECA7n);
testSub(-0xFEDCBA98n, 0xFEDCBA98n, -0x1FDB97530n);
testSub(-0xFEDCBA98n, 0xFEDCBA97n, -0x1FDB9752Fn);
testSub(-0xFEDCBA98n, 0x1234n, -0xFEDCCCCCn);
testSub(-0xFEDCBA98n, 0x3n, -0xFEDCBA9Bn);
testSub(-0xFEDCBA98n, 0x2n, -0xFEDCBA9An);
testSub(-0xFEDCBA98n, 0x1n, -0xFEDCBA99n);
testSub(-0xFEDCBA98n, 0x0n, -0xFEDCBA98n);
testSub(-0xFEDCBA98n, -0x1n, -0xFEDCBA97n);
testSub(-0xFEDCBA98n, -0x2n, -0xFEDCBA96n);
testSub(-0xFEDCBA98n, -0x3n, -0xFEDCBA95n);
testSub(-0xFEDCBA98n, -0x1234n, -0xFEDCA864n);
testSub(-0xFEDCBA98n, -0xFEDCBA97n, -0x1n);
testSub(-0xFEDCBA98n, -0xFEDCBA98n, 0x0n);
testSub(-0xFEDCBA98n, -0xFEDCBA987654320Fn, 0xFEDCBA9777777777n);
testSub(-0xFEDCBA98n, -0xFEDCBA9876543210n, 0xFEDCBA9777777778n);
testSub(-0xFEDCBA987654320Fn, 0xFEDCBA9876543210n, -0x1FDB97530ECA8641Fn);
testSub(-0xFEDCBA987654320Fn, 0xFEDCBA987654320Fn, -0x1FDB97530ECA8641En);
testSub(-0xFEDCBA987654320Fn, 0xFEDCBA98n, -0xFEDCBA997530ECA7n);
testSub(-0xFEDCBA987654320Fn, 0xFEDCBA97n, -0xFEDCBA997530ECA6n);
testSub(-0xFEDCBA987654320Fn, 0x1234n, -0xFEDCBA9876544443n);
testSub(-0xFEDCBA987654320Fn, 0x3n, -0xFEDCBA9876543212n);
testSub(-0xFEDCBA987654320Fn, 0x2n, -0xFEDCBA9876543211n);
testSub(-0xFEDCBA987654320Fn, 0x1n, -0xFEDCBA9876543210n);
testSub(-0xFEDCBA987654320Fn, 0x0n, -0xFEDCBA987654320Fn);
testSub(-0xFEDCBA987654320Fn, -0x1n, -0xFEDCBA987654320En);
testSub(-0xFEDCBA987654320Fn, -0x2n, -0xFEDCBA987654320Dn);
testSub(-0xFEDCBA987654320Fn, -0x3n, -0xFEDCBA987654320Cn);
testSub(-0xFEDCBA987654320Fn, -0x1234n, -0xFEDCBA9876541FDBn);
testSub(-0xFEDCBA987654320Fn, -0xFEDCBA97n, -0xFEDCBA9777777778n);
testSub(-0xFEDCBA987654320Fn, -0xFEDCBA98n, -0xFEDCBA9777777777n);
testSub(-0xFEDCBA987654320Fn, -0xFEDCBA987654320Fn, 0x0n);
testSub(-0xFEDCBA987654320Fn, -0xFEDCBA9876543210n, 0x1n);
testSub(-0xFEDCBA9876543210n, 0xFEDCBA9876543210n, -0x1FDB97530ECA86420n);
testSub(-0xFEDCBA9876543210n, 0xFEDCBA987654320Fn, -0x1FDB97530ECA8641Fn);
testSub(-0xFEDCBA9876543210n, 0xFEDCBA98n, -0xFEDCBA997530ECA8n);
testSub(-0xFEDCBA9876543210n, 0xFEDCBA97n, -0xFEDCBA997530ECA7n);
testSub(-0xFEDCBA9876543210n, 0x1234n, -0xFEDCBA9876544444n);
testSub(-0xFEDCBA9876543210n, 0x3n, -0xFEDCBA9876543213n);
testSub(-0xFEDCBA9876543210n, 0x2n, -0xFEDCBA9876543212n);
testSub(-0xFEDCBA9876543210n, 0x1n, -0xFEDCBA9876543211n);
testSub(-0xFEDCBA9876543210n, 0x0n, -0xFEDCBA9876543210n);
testSub(-0xFEDCBA9876543210n, -0x1n, -0xFEDCBA987654320Fn);
testSub(-0xFEDCBA9876543210n, -0x2n, -0xFEDCBA987654320En);
testSub(-0xFEDCBA9876543210n, -0x3n, -0xFEDCBA987654320Dn);
testSub(-0xFEDCBA9876543210n, -0x1234n, -0xFEDCBA9876541FDCn);
testSub(-0xFEDCBA9876543210n, -0xFEDCBA97n, -0xFEDCBA9777777779n);
testSub(-0xFEDCBA9876543210n, -0xFEDCBA98n, -0xFEDCBA9777777778n);
testSub(-0xFEDCBA9876543210n, -0xFEDCBA987654320Fn, -0x1n);
testSub(-0xFEDCBA9876543210n, -0xFEDCBA9876543210n, 0x0n);

