// Copyright 2017, the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Generated by tools/bigint-tester.py.

var data = [{
  a: 0x6163dn,
  r: -0x6163dn
}, {
  a: 0x9ab935684a90b8243f5b1d1ab87f53227c9a5eff299dc3a73438235ec3b3d301ecc0fen,
  r: -0x9ab935684a90b8243f5b1d1ab87f53227c9a5eff299dc3a73438235ec3b3d301ecc0fen
}, {
  a: 0x81ccca7651adc9d57022fa4d22a43a1d4474ed8b9b1n,
  r: -0x81ccca7651adc9d57022fa4d22a43a1d4474ed8b9b1n
}, {
  a: 0xf5377df0610fa41e2b81630ea37c15n,
  r: -0xf5377df0610fa41e2b81630ea37c15n
}, {
  a: -0x3c2be587cb98d403cff18e305d2b64f86480e6a61292c2c019db6n,
  r: 0x3c2be587cb98d403cff18e305d2b64f86480e6a61292c2c019db6n
}, {
  a: -0x94n,
  r: 0x94n
}, {
  a: 0xe4d344301abfd2d6f13abcc3c064b4n,
  r: -0xe4d344301abfd2d6f13abcc3c064b4n
}, {
  a: -0xa7b39cd347189a40f2f679ceb9f15e6eb84159ebc6e12adan,
  r: 0xa7b39cd347189a40f2f679ceb9f15e6eb84159ebc6e12adan
}, {
  a: 0x28c6e17523f290742en,
  r: -0x28c6e17523f290742en
}, {
  a: -0xb08a17e21e5d242bb28decd407715dc0247n,
  r: 0xb08a17e21e5d242bb28decd407715dc0247n
}, {
  a: -0xd7279c2992ca5598e4d13377c099193c4eafb5d14f9b5c95048a82b74e3bc4ce5n,
  r: 0xd7279c2992ca5598e4d13377c099193c4eafb5d14f9b5c95048a82b74e3bc4ce5n
}, {
  a: -0x86124c932246988596fc71a88af6230af8d33a42n,
  r: 0x86124c932246988596fc71a88af6230af8d33a42n
}, {
  a: 0xc4e740527b4fc3a6856c76e4cc5d2e87f7fdec9f18n,
  r: -0xc4e740527b4fc3a6856c76e4cc5d2e87f7fdec9f18n
}, {
  a: 0x159bb6768f6f113524efca60bb6378a1n,
  r: -0x159bb6768f6f113524efca60bb6378a1n
}, {
  a: 0x19f6fae561acd5f4b88939e402d62f65d080f7962f5e47n,
  r: -0x19f6fae561acd5f4b88939e402d62f65d080f7962f5e47n
}, {
  a: 0x645b796eeac63bcdn,
  r: -0x645b796eeac63bcdn
}, {
  a: 0x424dcc3ab54b9940866b17n,
  r: -0x424dcc3ab54b9940866b17n
}, {
  a: 0x51237274801bdc23619d5f8c42f31fad016bc9096d17e29n,
  r: -0x51237274801bdc23619d5f8c42f31fad016bc9096d17e29n
}, {
  a: -0x164ea1b2ecfbf38e1c8fac319fe7f6795b3e4n,
  r: 0x164ea1b2ecfbf38e1c8fac319fe7f6795b3e4n
}, {
  a: 0x4fc57114522571814270745a280ef07c5n,
  r: -0x4fc57114522571814270745a280ef07c5n
}, {
  a: -0x2f67b8c0c20ffe18e5114f356b2f7220cef290ab8a5n,
  r: 0x2f67b8c0c20ffe18e5114f356b2f7220cef290ab8a5n
}, {
  a: -0x3998ce7345n,
  r: 0x3998ce7345n
}, {
  a: 0x3f9fdfde634e312543d1a0fb9ab9n,
  r: -0x3f9fdfde634e312543d1a0fb9ab9n
}, {
  a: 0xe6086a243db37c9c94aff05f8d7n,
  r: -0xe6086a243db37c9c94aff05f8d7n
}, {
  a: 0n,
  r: 0n
}, {
  a: -0x8c3900a3e1322525622e0b300d47e9ff0e9886d87321n,
  r: 0x8c3900a3e1322525622e0b300d47e9ff0e9886d87321n
}, {
  a: 0xce0e85n,
  r: -0xce0e85n
}, {
  a: 0xa49f6c5083d5e5b302ce1ca506n,
  r: -0xa49f6c5083d5e5b302ce1ca506n
}, {
  a: 0x8132en,
  r: -0x8132en
}, {
  a: 0xeab6a80a87e42454de4b80af7c2b1465a5fce3acbdcb1a092d4cf5f7fe4b1562e42bdn,
  r: -0xeab6a80a87e42454de4b80af7c2b1465a5fce3acbdcb1a092d4cf5f7fe4b1562e42bdn
}, {
  a: -0xf9bdb6cab4b355deb95ac34ffb289d82d7a75678e8c011f74074bce726en,
  r: 0xf9bdb6cab4b355deb95ac34ffb289d82d7a75678e8c011f74074bce726en
}, {
  a: -0x14f28f3736368e7629525adadc6c1e11f9b7c6dn,
  r: 0x14f28f3736368e7629525adadc6c1e11f9b7c6dn
}, {
  a: 0xd4c4404d15b7d3a7fdea87b77c0b5c68f2c25dccf6deb61n,
  r: -0xd4c4404d15b7d3a7fdea87b77c0b5c68f2c25dccf6deb61n
}, {
  a: 0x21f4b976f12a184efb72729c3d6e44e0b0f0f349efc116fn,
  r: -0x21f4b976f12a184efb72729c3d6e44e0b0f0f349efc116fn
}, {
  a: -0xc10c2f546bb01b87123bdd63c19c0282284008ed8e94aaa1d39917en,
  r: 0xc10c2f546bb01b87123bdd63c19c0282284008ed8e94aaa1d39917en
}, {
  a: 0x9687883363d03958d8edfeb5083a5bbe615fn,
  r: -0x9687883363d03958d8edfeb5083a5bbe615fn
}, {
  a: -0x8b66610098f4d982601554c667cd62e11074n,
  r: 0x8b66610098f4d982601554c667cd62e11074n
}, {
  a: 0x71f2bc3d7d62046665f6d208c18a9cd6496649b3107n,
  r: -0x71f2bc3d7d62046665f6d208c18a9cd6496649b3107n
}, {
  a: -0x38n,
  r: 0x38n
}, {
  a: -0x3f976f7acc67007e86cda176ddb2f5d1d571d923cafe943cefa3f2570ce8877e92n,
  r: 0x3f976f7acc67007e86cda176ddb2f5d1d571d923cafe943cefa3f2570ce8877e92n
}, {
  a: 0x3822dd6645fb0dd5f2eb787058401e6b6745an,
  r: -0x3822dd6645fb0dd5f2eb787058401e6b6745an
}, {
  a: -0xf091dff19d81cde8a12fb14f67f1fa210b2d0dd322918n,
  r: 0xf091dff19d81cde8a12fb14f67f1fa210b2d0dd322918n
}, {
  a: 0xb734c8fc16910335d9120cn,
  r: -0xb734c8fc16910335d9120cn
}, {
  a: -0x2d305672269557bc793b2a7140a06n,
  r: 0x2d305672269557bc793b2a7140a06n
}, {
  a: -0xc7bb7635a407cbd46608n,
  r: 0xc7bb7635a407cbd46608n
}, {
  a: -0x26cf42ff21995n,
  r: 0x26cf42ff21995n
}, {
  a: 0x946aa94b56eec2aacf739d800f68f5265d3b05cbfn,
  r: -0x946aa94b56eec2aacf739d800f68f5265d3b05cbfn
}, {
  a: -0xf65ea2399d2c6042b7df127072caa9d864eef993ddn,
  r: 0xf65ea2399d2c6042b7df127072caa9d864eef993ddn
}, {
  a: 0xb9c92bn,
  r: -0xb9c92bn
}, {
  a: -0xcb866313a924d68ab59fee3df696cad9891b32de180d2b163a8f7e5dbfc702n,
  r: 0xcb866313a924d68ab59fee3df696cad9891b32de180d2b163a8f7e5dbfc702n
}, {
  a: 0xa7603e6294f67c5fen,
  r: -0xa7603e6294f67c5fen
}, {
  a: -0x573fc00dd9dc3e5bd7dfab9f8a86b0873n,
  r: 0x573fc00dd9dc3e5bd7dfab9f8a86b0873n
}, {
  a: -0xf586540e4988ff44eeb8cfe4f694951d229532771a7d608df91a2n,
  r: 0xf586540e4988ff44eeb8cfe4f694951d229532771a7d608df91a2n
}, {
  a: 0x7463f89ac99an,
  r: -0x7463f89ac99an
}, {
  a: 0x6179931275aaf614n,
  r: -0x6179931275aaf614n
}, {
  a: -0xc3315e184927dae8n,
  r: 0xc3315e184927dae8n
}, {
  a: -0x66372132f25a003892969c080501cf722f87cdaa740a3f4ed1fce8ff8a2642bbdd21bn,
  r: 0x66372132f25a003892969c080501cf722f87cdaa740a3f4ed1fce8ff8a2642bbdd21bn
}, {
  a: 0xfceb282565549288e50139bb7cd5605n,
  r: -0xfceb282565549288e50139bb7cd5605n
}, {
  a: -0x9e29718468f6976a533da876ebd4db2d3b420b59b965f43752n,
  r: 0x9e29718468f6976a533da876ebd4db2d3b420b59b965f43752n
}, {
  a: 0x4aedf7aede629185355fc9c9eca4d29002b192fe6355002e39a5n,
  r: -0x4aedf7aede629185355fc9c9eca4d29002b192fe6355002e39a5n
}, {
  a: 0xd6505e11247510763c792648dd45fe5ba5d704n,
  r: -0xd6505e11247510763c792648dd45fe5ba5d704n
}, {
  a: 0x6b092360453a6ca92ec1c72ccd6c1e7c03091n,
  r: -0x6b092360453a6ca92ec1c72ccd6c1e7c03091n
}, {
  a: 0x1ab701ae6d54869n,
  r: -0x1ab701ae6d54869n
}, {
  a: -0x9a4a02475949dbd6cd9edb188e33c2d4043n,
  r: 0x9a4a02475949dbd6cd9edb188e33c2d4043n
}, {
  a: -0xce504a90c09cn,
  r: 0xce504a90c09cn
}, {
  a: -0xc4a5f0bf02736dn,
  r: 0xc4a5f0bf02736dn
}, {
  a: -0x9b59cc190a798638fd0ceecfee43df8648f8bfbf178f88da7de4067f34be3fn,
  r: 0x9b59cc190a798638fd0ceecfee43df8648f8bfbf178f88da7de4067f34be3fn
}, {
  a: -0x5fd44850cc8a52e4443b8d07b6d2n,
  r: 0x5fd44850cc8a52e4443b8d07b6d2n
}, {
  a: 0xf91ce9be873ae3cn,
  r: -0xf91ce9be873ae3cn
}, {
  a: -0x139n,
  r: 0x139n
}, {
  a: 0x416n,
  r: -0x416n
}, {
  a: -0xd60961c2d62810444af740213690ef43n,
  r: 0xd60961c2d62810444af740213690ef43n
}, {
  a: -0xee0f9c733489cb2986de5d09ef338dca977c75777779d94846a37f42c4n,
  r: 0xee0f9c733489cb2986de5d09ef338dca977c75777779d94846a37f42c4n
}, {
  a: 0x31a8c69565560e0cdae35c8cn,
  r: -0x31a8c69565560e0cdae35c8cn
}, {
  a: -0x1ba77f6n,
  r: 0x1ba77f6n
}, {
  a: -0x9n,
  r: 0x9n
}, {
  a: 0x199fe508b90ad56cda277aeb6e5bcf212c66c41fa559bef6842d952fn,
  r: -0x199fe508b90ad56cda277aeb6e5bcf212c66c41fa559bef6842d952fn
}, {
  a: -0x5e0dceed9d6c1fc54052a1bc00bb333n,
  r: 0x5e0dceed9d6c1fc54052a1bc00bb333n
}, {
  a: 0xa14fc158c4b26b910f94e32becf3ee926572n,
  r: -0xa14fc158c4b26b910f94e32becf3ee926572n
}, {
  a: 0xc0cdf6b58c8132cd49ce2fc5174b8a13014b5be82n,
  r: -0xc0cdf6b58c8132cd49ce2fc5174b8a13014b5be82n
}, {
  a: 0x6844b9880311133db509227cdb526f6d899c8e408d740eeba29b0e889d29dn,
  r: -0x6844b9880311133db509227cdb526f6d899c8e408d740eeba29b0e889d29dn
}, {
  a: -0x7e20d4df906001c4e0c4e27c2202a9414e4d85e4921b2c355fe766e10b6c6cn,
  r: 0x7e20d4df906001c4e0c4e27c2202a9414e4d85e4921b2c355fe766e10b6c6cn
}, {
  a: 0x58a70f6ba222d46f1b766cn,
  r: -0x58a70f6ba222d46f1b766cn
}, {
  a: -0x40010022936268eaa0e930bf36b76c69f903ab9c850573b6b4a632b4bf2717n,
  r: 0x40010022936268eaa0e930bf36b76c69f903ab9c850573b6b4a632b4bf2717n
}, {
  a: 0n,
  r: 0n
}, {
  a: -0xa180439eb976cca38a3e368772cbe63070cef41df30208c743ac22n,
  r: 0xa180439eb976cca38a3e368772cbe63070cef41df30208c743ac22n
}, {
  a: 0x1b5feecb224a52a34ba4256853f5f475550e32d2e5711703f7b5dab32fcd1b6d9fn,
  r: -0x1b5feecb224a52a34ba4256853f5f475550e32d2e5711703f7b5dab32fcd1b6d9fn
}, {
  a: 0xd78be5c4fc05fbbad479a75cfae11f4f7e5bd07a05e19f6b484n,
  r: -0xd78be5c4fc05fbbad479a75cfae11f4f7e5bd07a05e19f6b484n
}, {
  a: -0xe885269c4ff32c3ab3a64bb7948a32e830c253c3b09614211959d4db97db8139848dn,
  r: 0xe885269c4ff32c3ab3a64bb7948a32e830c253c3b09614211959d4db97db8139848dn
}, {
  a: 0x9045c6f42b30f372471f889n,
  r: -0x9045c6f42b30f372471f889n
}, {
  a: 0x11616fd6808760b2c94f2232cf31e670ed73a8a2a7409391091dc587e51cfd5c5dan,
  r: -0x11616fd6808760b2c94f2232cf31e670ed73a8a2a7409391091dc587e51cfd5c5dan
}, {
  a: -0x4438f21afe3e8d60e671cde75981fecee8f6bn,
  r: 0x4438f21afe3e8d60e671cde75981fecee8f6bn
}, {
  a: 0xeaf97edbc1a3438d5a18a4870cbd8d6a3590207629e8n,
  r: -0xeaf97edbc1a3438d5a18a4870cbd8d6a3590207629e8n
}, {
  a: -0x27543aa5362bc30f546821f389fc602c608d485bbn,
  r: 0x27543aa5362bc30f546821f389fc602c608d485bbn
}, {
  a: -0x8e3d661c669077c5df6e1d864287fddeb6c1ec57066c1ab491816bn,
  r: 0x8e3d661c669077c5df6e1d864287fddeb6c1ec57066c1ab491816bn
}, {
  a: 0x48af1bc7943f96d7215858acaf9538cfd7bca3fad4e8n,
  r: -0x48af1bc7943f96d7215858acaf9538cfd7bca3fad4e8n
}, {
  a: 0xbd959b6084803c48b093f9346987d084518cc089a2447ef72031d15688f7fn,
  r: -0xbd959b6084803c48b093f9346987d084518cc089a2447ef72031d15688f7fn
}, {
  a: -0xe022bn,
  r: 0xe022bn
}, {
  a: 0x7e5dab36ef00dace0cbf80880169285f910a8e5ec537f51b4a41e6cc4711979eb4dn,
  r: -0x7e5dab36ef00dace0cbf80880169285f910a8e5ec537f51b4a41e6cc4711979eb4dn
}, {
  a: -0x6343183ff099n,
  r: 0x6343183ff099n
}, {
  a: -0xe49769b47fd2b28caf9bd096d72b58f3fdbd25e4ea25253f4fe92c7c3d76ef26a41305n,
  r: 0xe49769b47fd2b28caf9bd096d72b58f3fdbd25e4ea25253f4fe92c7c3d76ef26a41305n
}, {
  a: -0xd9a7a3b19de1e1301d1af960cdaba5d2f82fd1218cn,
  r: 0xd9a7a3b19de1e1301d1af960cdaba5d2f82fd1218cn
}, {
  a: -0x577f2f6d76171014d085aa60c16c7c94c4223749847759e70c6n,
  r: 0x577f2f6d76171014d085aa60c16c7c94c4223749847759e70c6n
}, {
  a: -0x6a62ba45108847a3ce2e192655768634b57992a4n,
  r: 0x6a62ba45108847a3ce2e192655768634b57992a4n
}, {
  a: 0x52354be3225c1657f69d7dbbd8b4841f1cbb90f897164d64c6fbc709e82e0d40n,
  r: -0x52354be3225c1657f69d7dbbd8b4841f1cbb90f897164d64c6fbc709e82e0d40n
}, {
  a: 0xe297db426afdc0ee2ed37b8269acb671298ec6ad7faf9n,
  r: -0xe297db426afdc0ee2ed37b8269acb671298ec6ad7faf9n
}, {
  a: -0xbc42430cecda9fb61ed030e3574b55214539f5c0422e9ee933e4f7f82ced1ee994ecen,
  r: 0xbc42430cecda9fb61ed030e3574b55214539f5c0422e9ee933e4f7f82ced1ee994ecen
}, {
  a: -0xbfb2fb6bf2b93f426aen,
  r: 0xbfb2fb6bf2b93f426aen
}, {
  a: -0xe50a933d0fbdee882c04b36da8c5fd1a710ca354bf4dfc352e7f24b48b7fn,
  r: 0xe50a933d0fbdee882c04b36da8c5fd1a710ca354bf4dfc352e7f24b48b7fn
}, {
  a: 0xfbec4f298cb2ae6n,
  r: -0xfbec4f298cb2ae6n
}, {
  a: 0xfed4767ca578n,
  r: -0xfed4767ca578n
}, {
  a: 0x2n,
  r: -0x2n
}, {
  a: -0x15b098f13e934651n,
  r: 0x15b098f13e934651n
}, {
  a: 0x7078512bn,
  r: -0x7078512bn
}, {
  a: 0x3661765269f90n,
  r: -0x3661765269f90n
}, {
  a: 0x5afe52bfa1n,
  r: -0x5afe52bfa1n
}, {
  a: 0x4aa5ab263079734a6bd126999f301f7577ed67e46155n,
  r: -0x4aa5ab263079734a6bd126999f301f7577ed67e46155n
}, {
  a: -0x4de6bb93f2f4073b52c6ba33ec7c344698ffn,
  r: 0x4de6bb93f2f4073b52c6ba33ec7c344698ffn
}, {
  a: -0xec558883314baa48n,
  r: 0xec558883314baa48n
}, {
  a: -0x70fn,
  r: 0x70fn
}, {
  a: -0x4bfdbfbf3f5b1cae4bb1en,
  r: 0x4bfdbfbf3f5b1cae4bb1en
}, {
  a: 0xb68bc2fbab07a403c09e470878fbn,
  r: -0xb68bc2fbab07a403c09e470878fbn
}, {
  a: -0x7n,
  r: 0x7n
}, {
  a: 0x188a75798ec2310c7f4a455d27242e45850591dan,
  r: -0x188a75798ec2310c7f4a455d27242e45850591dan
}, {
  a: -0x2f2f2a8e4974ff522d23d9cd9748a6fn,
  r: 0x2f2f2a8e4974ff522d23d9cd9748a6fn
}, {
  a: -0x69ab38c0ab02c380af7723c51a22c2113cf79d78c1e0115bd65223d0d87efbf8f56an,
  r: 0x69ab38c0ab02c380af7723c51a22c2113cf79d78c1e0115bd65223d0d87efbf8f56an
}, {
  a: -0xb5662917af1292ea1727baden,
  r: 0xb5662917af1292ea1727baden
}, {
  a: 0xf5f168en,
  r: -0xf5f168en
}, {
  a: -0x1ceac3f3b312d8510e340578add406d0b73f013097da0bde9dd93n,
  r: 0x1ceac3f3b312d8510e340578add406d0b73f013097da0bde9dd93n
}, {
  a: -0x3e1bab885076eea6393an,
  r: 0x3e1bab885076eea6393an
}, {
  a: -0x3a6fbf4a8455a37d6505be15690cbada3ba0n,
  r: 0x3a6fbf4a8455a37d6505be15690cbada3ba0n
}, {
  a: -0x91d89954452b6d9411eba53517da59n,
  r: 0x91d89954452b6d9411eba53517da59n
}, {
  a: 0xabf8ae7c182cbbd997145077c339e50fdf32478dfd59c039bb75b5932fc5en,
  r: -0xabf8ae7c182cbbd997145077c339e50fdf32478dfd59c039bb75b5932fc5en
}, {
  a: -0xf14488eab1fa68880fb078fbe8faa61dce6b80eb3255c630e66fn,
  r: 0xf14488eab1fa68880fb078fbe8faa61dce6b80eb3255c630e66fn
}, {
  a: -0x20d8718a66b5d72abf757fa28d57857885b8a8f513f85588ccbab842969697b0f7ccn,
  r: 0x20d8718a66b5d72abf757fa28d57857885b8a8f513f85588ccbab842969697b0f7ccn
}, {
  a: -0x538cc54f97c96a16ba964e71be1d00bdn,
  r: 0x538cc54f97c96a16ba964e71be1d00bdn
}, {
  a: 0n,
  r: 0n
}, {
  a: -0xd78fa9783d21f741ec8344n,
  r: 0xd78fa9783d21f741ec8344n
}, {
  a: 0xa7ab2cf4b38b0f3709fb0b909cd3d25e9db461b1n,
  r: -0xa7ab2cf4b38b0f3709fb0b909cd3d25e9db461b1n
}, {
  a: 0x2bd37051f3ef26028cbdbfa0a7acd174c32da13ccbd10b5cd9572ce00b23c4640d24n,
  r: -0x2bd37051f3ef26028cbdbfa0a7acd174c32da13ccbd10b5cd9572ce00b23c4640d24n
}, {
  a: 0xaeb81n,
  r: -0xaeb81n
}, {
  a: -0x3df6683cf6b5fa5n,
  r: 0x3df6683cf6b5fa5n
}, {
  a: -0xf3c54e3d81d6c2006649e54fb5c441e0125e2c115924d5c88dbca53db02n,
  r: 0xf3c54e3d81d6c2006649e54fb5c441e0125e2c115924d5c88dbca53db02n
}, {
  a: 0x9e13431372edfc334b398d701628af132d2609425648db1db01dn,
  r: -0x9e13431372edfc334b398d701628af132d2609425648db1db01dn
}, {
  a: -0x27f0eeb0e0b38f2525276352d62727f9aab32bean,
  r: 0x27f0eeb0e0b38f2525276352d62727f9aab32bean
}, {
  a: -0x5ab801ecd5dn,
  r: 0x5ab801ecd5dn
}, {
  a: -0x19a804d3294140ac24a134f3724cddc7915961a8c5e3f0a0n,
  r: 0x19a804d3294140ac24a134f3724cddc7915961a8c5e3f0a0n
}, {
  a: 0xc0030c26291b838d0e14ddade749e708747c2b7ac73c3f9ff33f40f4bf2n,
  r: -0xc0030c26291b838d0e14ddade749e708747c2b7ac73c3f9ff33f40f4bf2n
}, {
  a: -0x42b3daf62a17048aa8e60b41bdcaace2dc9n,
  r: 0x42b3daf62a17048aa8e60b41bdcaace2dc9n
}, {
  a: -0xe0e39a9ee69d43c5552a335f78fca5bfn,
  r: 0xe0e39a9ee69d43c5552a335f78fca5bfn
}, {
  a: 0x55d1e82cdd371n,
  r: -0x55d1e82cdd371n
}, {
  a: -0x7ebd5788a44f40763a7en,
  r: 0x7ebd5788a44f40763a7en
}, {
  a: 0x6c9fcdc908c79af96dc3d641e0af2d904af6586b228f79dd0d7a43362c2358a06n,
  r: -0x6c9fcdc908c79af96dc3d641e0af2d904af6586b228f79dd0d7a43362c2358a06n
}, {
  a: -0xc4718578ede75be9f51153e0506586a8a2af6f3069dad813dec1ab3n,
  r: 0xc4718578ede75be9f51153e0506586a8a2af6f3069dad813dec1ab3n
}, {
  a: -0x69d225b8d4c938e8039d20b18dcc1n,
  r: 0x69d225b8d4c938e8039d20b18dcc1n
}, {
  a: 0x7bc5ad91c2dbe5c8a46ea2769cabd9baf3fd3a8d79b35n,
  r: -0x7bc5ad91c2dbe5c8a46ea2769cabd9baf3fd3a8d79b35n
}, {
  a: -0xe66944d78fb29551c41bb335af1n,
  r: 0xe66944d78fb29551c41bb335af1n
}, {
  a: 0x6514257a7ae727ae1n,
  r: -0x6514257a7ae727ae1n
}, {
  a: 0x3b9f698a3fb7ef905602c679534bcfe30ebd854536f59c7eb0de2cafn,
  r: -0x3b9f698a3fb7ef905602c679534bcfe30ebd854536f59c7eb0de2cafn
}, {
  a: 0x35301bf9025caa6453d8934490c5a61c5n,
  r: -0x35301bf9025caa6453d8934490c5a61c5n
}, {
  a: -0xb93c6c1ca4f2n,
  r: 0xb93c6c1ca4f2n
}, {
  a: -0x6b3ac64f19c3524732e202237c864e79303544a0ad8357n,
  r: 0x6b3ac64f19c3524732e202237c864e79303544a0ad8357n
}, {
  a: 0n,
  r: 0n
}, {
  a: -0xc78b0af72798f1f298e365e04f7a91917f2de563894c914676fa962eeda598n,
  r: 0xc78b0af72798f1f298e365e04f7a91917f2de563894c914676fa962eeda598n
}, {
  a: 0x6222c9c0e18en,
  r: -0x6222c9c0e18en
}, {
  a: 0xb25b4ba0d7fea0ea4b10b907da49f182ece5895bd16b037a1a2da80bbedcn,
  r: -0xb25b4ba0d7fea0ea4b10b907da49f182ece5895bd16b037a1a2da80bbedcn
}, {
  a: 0x8f51an,
  r: -0x8f51an
}, {
  a: -0xa9858b7ed2f1ee9n,
  r: 0xa9858b7ed2f1ee9n
}, {
  a: -0x792d919e51c9c4f4b6480f9e02924f7c315c775aabb2a478f25778d386f2888n,
  r: 0x792d919e51c9c4f4b6480f9e02924f7c315c775aabb2a478f25778d386f2888n
}, {
  a: -0x1802b5d08a219d9c045e2bd8f99e8dd6c75314a2e225534006b6b1948an,
  r: 0x1802b5d08a219d9c045e2bd8f99e8dd6c75314a2e225534006b6b1948an
}, {
  a: 0x683cdn,
  r: -0x683cdn
}, {
  a: -0x37153b5ec1b40e0480c35469330b69b1f61d5en,
  r: 0x37153b5ec1b40e0480c35469330b69b1f61d5en
}, {
  a: -0x3bb622671d1401191bde78f3ee815abf32848906a61cf30dab55b57f89c55ec0f045n,
  r: 0x3bb622671d1401191bde78f3ee815abf32848906a61cf30dab55b57f89c55ec0f045n
}, {
  a: -0x906fc5efb906923318227493200ff50d108bb5c7309431e83n,
  r: 0x906fc5efb906923318227493200ff50d108bb5c7309431e83n
}, {
  a: -0x9203791b6efdc8fn,
  r: 0x9203791b6efdc8fn
}, {
  a: -0x395cb40e438a6b3c150575029b0023408c038ce8f80f3en,
  r: 0x395cb40e438a6b3c150575029b0023408c038ce8f80f3en
}, {
  a: -0x7ae5e506bd282e2e7aa7aen,
  r: 0x7ae5e506bd282e2e7aa7aen
}, {
  a: -0x5799f24e2be02n,
  r: 0x5799f24e2be02n
}, {
  a: -0x832094aaedebb4259a1ed4ab6f0n,
  r: 0x832094aaedebb4259a1ed4ab6f0n
}, {
  a: 0xdn,
  r: -0xdn
}, {
  a: -0xf396a1c21fn,
  r: 0xf396a1c21fn
}, {
  a: 0xdf27634en,
  r: -0xdf27634en
}, {
  a: -0xa8b36bf0fc6949e3bc6794a30d6503e58fcaf3d81059ea1049417e4f1adf35713n,
  r: 0xa8b36bf0fc6949e3bc6794a30d6503e58fcaf3d81059ea1049417e4f1adf35713n
}, {
  a: 0x9ae27f034ae2d13eb3ceb44c28b3n,
  r: -0x9ae27f034ae2d13eb3ceb44c28b3n
}, {
  a: 0x383b13n,
  r: -0x383b13n
}, {
  a: 0x64dn,
  r: -0x64dn
}, {
  a: 0xf81d94f1eea702e3b18d8130a71fe1c068a1b42d2bn,
  r: -0xf81d94f1eea702e3b18d8130a71fe1c068a1b42d2bn
}, {
  a: -0x3e89eba74dd1178e928ef68433e27d5890df4106n,
  r: 0x3e89eba74dd1178e928ef68433e27d5890df4106n
}, {
  a: -0x66020695e1be3n,
  r: 0x66020695e1be3n
}, {
  a: -0x621c394e8a242e7c523d6ff80dabn,
  r: 0x621c394e8a242e7c523d6ff80dabn
}, {
  a: 0xe21f787n,
  r: -0xe21f787n
}, {
  a: 0xe3993652n,
  r: -0xe3993652n
}, {
  a: 0xf99fc02bn,
  r: -0xf99fc02bn
}, {
  a: -0x60bd486e1e5a11c690c675c79541ff73c9bdae3ca5fcc9feb8da3167f25c97ec2cn,
  r: 0x60bd486e1e5a11c690c675c79541ff73c9bdae3ca5fcc9feb8da3167f25c97ec2cn
}, {
  a: 0x943375436c7bdbd2b1f93efbc918866an,
  r: -0x943375436c7bdbd2b1f93efbc918866an
}, {
  a: -0x9220451cd724110707120465cbaaa36fea9772ec2fe86a8fbc7d5fa85960cd5761e39n,
  r: 0x9220451cd724110707120465cbaaa36fea9772ec2fe86a8fbc7d5fa85960cd5761e39n
}, {
  a: 0x4ba10fn,
  r: -0x4ba10fn
}, {
  a: -0xec869df7cddf50a3790a73ed6d1dc07343b08251bea95a3dd0aa6b79eab1309e3n,
  r: 0xec869df7cddf50a3790a73ed6d1dc07343b08251bea95a3dd0aa6b79eab1309e3n
}, {
  a: 0xcd26b11e555dfb3b5f8f60effea3e5deaff7b0e4945078326fa094a0546265802an,
  r: -0xcd26b11e555dfb3b5f8f60effea3e5deaff7b0e4945078326fa094a0546265802an
}, {
  a: -0x3b3e8b5d19ce3336efa74488e6e4def188c93c8d63dn,
  r: 0x3b3e8b5d19ce3336efa74488e6e4def188c93c8d63dn
}, {
  a: -0x4c4eabddfd28e7884852dff98n,
  r: 0x4c4eabddfd28e7884852dff98n
}, {
  a: -0x17429636f7f4ab0c3d977f17cde03cde05116fc7d70ec998fd9ac12n,
  r: 0x17429636f7f4ab0c3d977f17cde03cde05116fc7d70ec998fd9ac12n
}, {
  a: -0x7cc356644d66aa17d64325b6578n,
  r: 0x7cc356644d66aa17d64325b6578n
}, {
  a: 0xd89b4f742dd90d282d258e1e348e800daa6n,
  r: -0xd89b4f742dd90d282d258e1e348e800daa6n
}, {
  a: 0n,
  r: 0n
}, {
  a: -0x87e4aa49ff73fb58adf7ece3c0ea333d3ee99ca4256a0e1e0bac4d24c2e2d935b94306n,
  r: 0x87e4aa49ff73fb58adf7ece3c0ea333d3ee99ca4256a0e1e0bac4d24c2e2d935b94306n
}, {
  a: 0x478bd85bd62b4d273en,
  r: -0x478bd85bd62b4d273en
}, {
  a: -0x6ca7d8eafdn,
  r: 0x6ca7d8eafdn
}, {
  a: 0x3fe554945ddaaa58963c99f758b9dff81d7e6n,
  r: -0x3fe554945ddaaa58963c99f758b9dff81d7e6n
}, {
  a: -0x9240412f7edac78n,
  r: 0x9240412f7edac78n
}, {
  a: 0x7fdb2cbb3f0n,
  r: -0x7fdb2cbb3f0n
}, {
  a: -0xa2d28f578728bea17f38n,
  r: 0xa2d28f578728bea17f38n
}, {
  a: -0x5beeddn,
  r: 0x5beeddn
}, {
  a: 0x2445401n,
  r: -0x2445401n
}, {
  a: 0x5af3b0a5fc4e48cc0b1f5d5333cfc355f27n,
  r: -0x5af3b0a5fc4e48cc0b1f5d5333cfc355f27n
}, {
  a: -0xb5f9853cn,
  r: 0xb5f9853cn
}, {
  a: -0xf020db2b34cbd2031d9ebde3f4900761e55ef85c7356b39c6eec11d13n,
  r: 0xf020db2b34cbd2031d9ebde3f4900761e55ef85c7356b39c6eec11d13n
}, {
  a: -0x85bacn,
  r: 0x85bacn
}, {
  a: 0x31c6b9edfe80befa876726460b3fc2775b120n,
  r: -0x31c6b9edfe80befa876726460b3fc2775b120n
}, {
  a: 0xe9e513f177bea06d98e7fd43841114cbeafd81354n,
  r: -0xe9e513f177bea06d98e7fd43841114cbeafd81354n
}, {
  a: -0x4d5e79e5b2dfac0e5f0e1ee436255207d611c1a194649e4cb231eac9c9a7n,
  r: 0x4d5e79e5b2dfac0e5f0e1ee436255207d611c1a194649e4cb231eac9c9a7n
}, {
  a: -0x8ed629a91e6n,
  r: 0x8ed629a91e6n
}, {
  a: 0x619bf0e2b0724n,
  r: -0x619bf0e2b0724n
}, {
  a: -0x29531a818ae681def25799dee79c766c4d451bb008ff289cc0e6f1722n,
  r: 0x29531a818ae681def25799dee79c766c4d451bb008ff289cc0e6f1722n
}, {
  a: -0xa2eacc21efc7473bad1d5c281fcec3e305810db957a81de94af6dd06a6dcan,
  r: 0xa2eacc21efc7473bad1d5c281fcec3e305810db957a81de94af6dd06a6dcan
}, {
  a: 0x945b98883a1ae84d8393bd6d7d61f6030652n,
  r: -0x945b98883a1ae84d8393bd6d7d61f6030652n
}, {
  a: -0x982a681da1e8c5ccf889398d19e0b173580fc7a0ba7eca1e0d5f1ece71n,
  r: 0x982a681da1e8c5ccf889398d19e0b173580fc7a0ba7eca1e0d5f1ece71n
}, {
  a: 0x9d1401cn,
  r: -0x9d1401cn
}, {
  a: -0x5c74dn,
  r: 0x5c74dn
}, {
  a: -0x54454e4ecf95bd848ac27cc7eb9a4d54c633a3707af82aa22706e1f4c122243n,
  r: 0x54454e4ecf95bd848ac27cc7eb9a4d54c633a3707af82aa22706e1f4c122243n
}, {
  a: 0xa8550af91733f626a232bf3642f8971361fn,
  r: -0xa8550af91733f626a232bf3642f8971361fn
}, {
  a: 0xb18c5f01c143bd551baeb9ed288b72404803120bn,
  r: -0xb18c5f01c143bd551baeb9ed288b72404803120bn
}, {
  a: 0x1524bcfefbc9b827f89e4191868e1331e2a136db6afabbe77e47abe3cn,
  r: -0x1524bcfefbc9b827f89e4191868e1331e2a136db6afabbe77e47abe3cn
}, {
  a: -0x2a25b25441543aaff8b2130f0f136647a6335b1046cfa3ad729ff52238n,
  r: 0x2a25b25441543aaff8b2130f0f136647a6335b1046cfa3ad729ff52238n
}, {
  a: 0x112e283c9569a3c8fe431a902a8c17b195c11c9c8e5d8e321d79685en,
  r: -0x112e283c9569a3c8fe431a902a8c17b195c11c9c8e5d8e321d79685en
}, {
  a: 0x42b7n,
  r: -0x42b7n
}, {
  a: -0x83aa717af93ab8910c8a72ed5n,
  r: 0x83aa717af93ab8910c8a72ed5n
}, {
  a: 0x4caaab69e730a6b0179378c28e92fd161ba63845d077e590a1934613cc88n,
  r: -0x4caaab69e730a6b0179378c28e92fd161ba63845d077e590a1934613cc88n
}, {
  a: 0x1551141n,
  r: -0x1551141n
}, {
  a: 0x4fd8f11n,
  r: -0x4fd8f11n
}, {
  a: -0xaedba1e5373323e8ec8dacdf440cd88cc30d9fdc1c3bc2fe9dbf396a2145dcn,
  r: 0xaedba1e5373323e8ec8dacdf440cd88cc30d9fdc1c3bc2fe9dbf396a2145dcn
}, {
  a: -0x80a6f9fa0a25fff0d10c2b8c2bb001dbd9c64b42e9n,
  r: 0x80a6f9fa0a25fff0d10c2b8c2bb001dbd9c64b42e9n
}, {
  a: -0x269f9bb0c87233e22f7n,
  r: 0x269f9bb0c87233e22f7n
}, {
  a: -0x6d94a8ba79e8b8b4683065cbdee26fd96n,
  r: 0x6d94a8ba79e8b8b4683065cbdee26fd96n
}, {
  a: 0xb6dfee45f75e19ded76bn,
  r: -0xb6dfee45f75e19ded76bn
}, {
  a: 0x6051f4c673816fn,
  r: -0x6051f4c673816fn
}, {
  a: 0x35e0eea94ec31314324b720debef78d3db588192cbca96n,
  r: -0x35e0eea94ec31314324b720debef78d3db588192cbca96n
}, {
  a: -0x14f114d8c94c1efc254c0d9507545bn,
  r: 0x14f114d8c94c1efc254c0d9507545bn
}, {
  a: 0x64ad4d66n,
  r: -0x64ad4d66n
}, {
  a: -0x6714772b892ab7a7a8ba96c9cfdn,
  r: 0x6714772b892ab7a7a8ba96c9cfdn
}, {
  a: -0xb922a25aca87b786ad29ebd7de1228d393f9d82b94251792229545n,
  r: 0xb922a25aca87b786ad29ebd7de1228d393f9d82b94251792229545n
}, {
  a: -0x63104dn,
  r: 0x63104dn
}, {
  a: -0x9bd05c7b293797abcf404f25a245e5c3e9d6065b150n,
  r: 0x9bd05c7b293797abcf404f25a245e5c3e9d6065b150n
}, {
  a: -0xa4dee8d39cbfeb0068bb0d418fn,
  r: 0xa4dee8d39cbfeb0068bb0d418fn
}, {
  a: -0xe365c3n,
  r: 0xe365c3n
}, {
  a: -0x654a2a5f0bcdban,
  r: 0x654a2a5f0bcdban
}, {
  a: 0xb7e0f13n,
  r: -0xb7e0f13n
}, {
  a: -0xcd2bc4bfe37f3ab88abc432ed534cc26511aaa41b14f13faa82fae4400726ceb154n,
  r: 0xcd2bc4bfe37f3ab88abc432ed534cc26511aaa41b14f13faa82fae4400726ceb154n
}, {
  a: -0x98e8a56f623ef4e78be6aaddfca578cf2ddd57025d7e9f7f4cn,
  r: 0x98e8a56f623ef4e78be6aaddfca578cf2ddd57025d7e9f7f4cn
}, {
  a: 0x9b314984bea8cddb0f99a976e4251168e73990n,
  r: -0x9b314984bea8cddb0f99a976e4251168e73990n
}, {
  a: 0xb1e12bff17bb76fbd00da018f8514e2b6e9aef9dcc58af4a53a73b666d9678cc06621n,
  r: -0xb1e12bff17bb76fbd00da018f8514e2b6e9aef9dcc58af4a53a73b666d9678cc06621n
}, {
  a: 0x9514e3ac9a3a86eeb1d3n,
  r: -0x9514e3ac9a3a86eeb1d3n
}, {
  a: -0x278d691cd369c8d5ca61e79eb1d14a9408f88c01cb0cebfn,
  r: 0x278d691cd369c8d5ca61e79eb1d14a9408f88c01cb0cebfn
}, {
  a: 0x4067e4c403d401ea2b034db55bd41d435056n,
  r: -0x4067e4c403d401ea2b034db55bd41d435056n
}, {
  a: -0x86800be60c74fcaac265025a1526009bn,
  r: 0x86800be60c74fcaac265025a1526009bn
}, {
  a: 0x3ad1b550727f254d8bb3a7586d5129496a36f70f1n,
  r: -0x3ad1b550727f254d8bb3a7586d5129496a36f70f1n
}, {
  a: -0xf57ca2bffe27b35bffe94692293f496156ee92c49b16c4d6086f0776e76f8457fefn,
  r: 0xf57ca2bffe27b35bffe94692293f496156ee92c49b16c4d6086f0776e76f8457fefn
}, {
  a: 0xe64fd58d982b0f2180190n,
  r: -0xe64fd58d982b0f2180190n
}, {
  a: 0xf2f5d1bfd1a3873e6aa55cf2caff4den,
  r: -0xf2f5d1bfd1a3873e6aa55cf2caff4den
}, {
  a: -0xb97a777n,
  r: 0xb97a777n
}, {
  a: 0xd3n,
  r: -0xd3n
}, {
  a: 0xfaf114e12448n,
  r: -0xfaf114e12448n
}, {
  a: -0x1c63daf299a8cad7c436621a21ad7d8b8fn,
  r: 0x1c63daf299a8cad7c436621a21ad7d8b8fn
}, {
  a: 0x84a2bf60cn,
  r: -0x84a2bf60cn
}, {
  a: 0x543be5a417b69068b2d8a3a01cn,
  r: -0x543be5a417b69068b2d8a3a01cn
}, {
  a: -0x26aa45805425f80n,
  r: 0x26aa45805425f80n
}, {
  a: 0x61742826b889caf8710ee4bn,
  r: -0x61742826b889caf8710ee4bn
}, {
  a: 0x448dc512ef6e802a8a6ba40b3a1c73c7b950n,
  r: -0x448dc512ef6e802a8a6ba40b3a1c73c7b950n
}, {
  a: 0x19802dda35b3ce11cbc8b0b8n,
  r: -0x19802dda35b3ce11cbc8b0b8n
}, {
  a: -0x3142608af8c96f9ca22afe99390687c7ca0224e245e3640f336cefe4cb941ebdn,
  r: 0x3142608af8c96f9ca22afe99390687c7ca0224e245e3640f336cefe4cb941ebdn
}, {
  a: -0x9e12f8a95n,
  r: 0x9e12f8a95n
}, {
  a: 0xa3c51454e598e1fe9b4b46n,
  r: -0xa3c51454e598e1fe9b4b46n
}, {
  a: -0xcebc9d1855408e5689b9n,
  r: 0xcebc9d1855408e5689b9n
}, {
  a: -0xd9e92c91a286a2072b464b3a440856ac9b74d3f7n,
  r: 0xd9e92c91a286a2072b464b3a440856ac9b74d3f7n
}, {
  a: -0xb3cc3e4ee9fcac9bbeec5306f53693c8398n,
  r: 0xb3cc3e4ee9fcac9bbeec5306f53693c8398n
}, {
  a: 0xd86226c164f4c97a2338c331acf2e26f6e5ff9fb31c4309994004abff243a468986n,
  r: -0xd86226c164f4c97a2338c331acf2e26f6e5ff9fb31c4309994004abff243a468986n
}, {
  a: 0xaf1f2dc437eb25bd25e512f45326f10dbb056238fc5n,
  r: -0xaf1f2dc437eb25bd25e512f45326f10dbb056238fc5n
}, {
  a: 0x52e4e2en,
  r: -0x52e4e2en
}, {
  a: -0x25c0f4d015c136134b13ea9d730d596a0ebba52bden,
  r: 0x25c0f4d015c136134b13ea9d730d596a0ebba52bden
}, {
  a: -0x7083b85c2c84ab97b11beda19349cbeb459e67b5bcf6a1248n,
  r: 0x7083b85c2c84ab97b11beda19349cbeb459e67b5bcf6a1248n
}, {
  a: 0x6n,
  r: -0x6n
}, {
  a: -0x8ca771b339013b8fd1503fa5b2217c3c092849b776335b4c3812dbe6e776d6601e405en,
  r: 0x8ca771b339013b8fd1503fa5b2217c3c092849b776335b4c3812dbe6e776d6601e405en
}, {
  a: -0xd8b53n,
  r: 0xd8b53n
}, {
  a: -0x92fa7c63n,
  r: 0x92fa7c63n
}, {
  a: -0x4c1d42a6bb0b3e4688fcda1a3baa9f6618dd852c3f8685cbc18266922n,
  r: 0x4c1d42a6bb0b3e4688fcda1a3baa9f6618dd852c3f8685cbc18266922n
}, {
  a: -0xb721ada8a1c1517400d1ee7b9a2984c1ccce454aaf2171cf4b11n,
  r: 0xb721ada8a1c1517400d1ee7b9a2984c1ccce454aaf2171cf4b11n
}, {
  a: 0xcd17bf3bcd0c0c0n,
  r: -0xcd17bf3bcd0c0c0n
}, {
  a: 0x677c6610161e8ccf84be3aea4c68a4cf1990d6ade9e70n,
  r: -0x677c6610161e8ccf84be3aea4c68a4cf1990d6ade9e70n
}, {
  a: 0n,
  r: 0n
}, {
  a: 0x3783103937fb9211742396874522e8621f43e21a3051fdca7c0bfa7bb71fn,
  r: -0x3783103937fb9211742396874522e8621f43e21a3051fdca7c0bfa7bb71fn
}, {
  a: 0xb31228f7123f936685e494b5f64c80e7f476a3a12n,
  r: -0xb31228f7123f936685e494b5f64c80e7f476a3a12n
}, {
  a: -0x52c466cf187cfc91cc53af5ce401de9db5cf0an,
  r: 0x52c466cf187cfc91cc53af5ce401de9db5cf0an
}, {
  a: 0x80117n,
  r: -0x80117n
}, {
  a: 0xban,
  r: -0xban
}, {
  a: 0x9abdaf8ee06en,
  r: -0x9abdaf8ee06en
}, {
  a: 0xa90e6aeee890a031805d67b3babfb962081767411e947d65b9dn,
  r: -0xa90e6aeee890a031805d67b3babfb962081767411e947d65b9dn
}, {
  a: 0x294c7d548a2df7c57n,
  r: -0x294c7d548a2df7c57n
}, {
  a: -0x7cn,
  r: 0x7cn
}, {
  a: 0xb6cad6e98n,
  r: -0xb6cad6e98n
}, {
  a: -0x7589d7127351b3baf989252a8ac521809cn,
  r: 0x7589d7127351b3baf989252a8ac521809cn
}, {
  a: 0xfdef70n,
  r: -0xfdef70n
}, {
  a: -0x928d3aeca67f2c15a384b52af81ddc0d3n,
  r: 0x928d3aeca67f2c15a384b52af81ddc0d3n
}, {
  a: 0x7e08b6a5e0317f6610fe640a057a07fbe1c10a78318f1bf8f8e7ab323b3f852ad36n,
  r: -0x7e08b6a5e0317f6610fe640a057a07fbe1c10a78318f1bf8f8e7ab323b3f852ad36n
}, {
  a: -0xf3663d79a02bbac8924d9e16987e0b262f62n,
  r: 0xf3663d79a02bbac8924d9e16987e0b262f62n
}, {
  a: 0xa984bf684be9bde041b3b36a53f132048ec85c1d37c9358af701026720n,
  r: -0xa984bf684be9bde041b3b36a53f132048ec85c1d37c9358af701026720n
}, {
  a: 0x9cebe38450c9n,
  r: -0x9cebe38450c9n
}, {
  a: 0x57d642e431cfaa234a00ben,
  r: -0x57d642e431cfaa234a00ben
}, {
  a: 0xcc76n,
  r: -0xcc76n
}, {
  a: 0x2e71d8876feedd7f53011e18ab83e1cb798n,
  r: -0x2e71d8876feedd7f53011e18ab83e1cb798n
}, {
  a: -0x5c33be7300fe73544ad21dea30564a6deb29406f363cded9ec3b8cc8n,
  r: 0x5c33be7300fe73544ad21dea30564a6deb29406f363cded9ec3b8cc8n
}, {
  a: 0xcb7a9443d4n,
  r: -0xcb7a9443d4n
}, {
  a: 0x56360271233d16dn,
  r: -0x56360271233d16dn
}, {
  a: 0xad32dbd4c23d5066a04b7bf42a6bbben,
  r: -0xad32dbd4c23d5066a04b7bf42a6bbben
}, {
  a: -0xbdb09b5a51a419e15427d4n,
  r: 0xbdb09b5a51a419e15427d4n
}, {
  a: -0x2f78605e445a7e2c6affe4n,
  r: 0x2f78605e445a7e2c6affe4n
}, {
  a: 0xc95d3be860107db8ffdb676dab08n,
  r: -0xc95d3be860107db8ffdb676dab08n
}, {
  a: -0x916ff6fc05975f45e2452ab8c8df0616n,
  r: 0x916ff6fc05975f45e2452ab8c8df0616n
}, {
  a: 0x7d78bdd16f521530b198f824d62c1c5ffe52a31c9dn,
  r: -0x7d78bdd16f521530b198f824d62c1c5ffe52a31c9dn
}, {
  a: 0xaedan,
  r: -0xaedan
}, {
  a: -0x45b7da59ad8b737c6f8630380702582aa5aea23e1f3c97536393ef5f8275b9ba04cen,
  r: 0x45b7da59ad8b737c6f8630380702582aa5aea23e1f3c97536393ef5f8275b9ba04cen
}, {
  a: 0xbn,
  r: -0xbn
}, {
  a: -0x8b24cf88156f2aac3fdf0976980a941170adcd735ae37ba8f1e9e5n,
  r: 0x8b24cf88156f2aac3fdf0976980a941170adcd735ae37ba8f1e9e5n
}, {
  a: -0x71b2d6ec2b413215e160ddded758a38079723n,
  r: 0x71b2d6ec2b413215e160ddded758a38079723n
}, {
  a: -0xf7af1e2db00440b4f3222c3ef7dfb2351c414a1f0fe4c66n,
  r: 0xf7af1e2db00440b4f3222c3ef7dfb2351c414a1f0fe4c66n
}, {
  a: 0xbf343a2af86bcf7f425aba8cd76a48en,
  r: -0xbf343a2af86bcf7f425aba8cd76a48en
}, {
  a: -0xfea16121010a0a08f4eb4dce24n,
  r: 0xfea16121010a0a08f4eb4dce24n
}, {
  a: -0x94e7831344bce60d6c23e3bb755b0eac340abb4467925cccbee0f09695a0n,
  r: 0x94e7831344bce60d6c23e3bb755b0eac340abb4467925cccbee0f09695a0n
}, {
  a: -0xd1f498ae96004dcbd837de286bd98e8dcad850be14190997701be7403a87eb3cn,
  r: 0xd1f498ae96004dcbd837de286bd98e8dcad850be14190997701be7403a87eb3cn
}, {
  a: 0x5cn,
  r: -0x5cn
}, {
  a: 0x245b7a4f5f7b2150dbe6b9d621504c33e2ebb7d8c96d177ae11a1dc0b7c8n,
  r: -0x245b7a4f5f7b2150dbe6b9d621504c33e2ebb7d8c96d177ae11a1dc0b7c8n
}, {
  a: -0x6d4f07adf896975e02a22cfcaa999ac4a666bbfa07f66c5e4ba26c747fbn,
  r: 0x6d4f07adf896975e02a22cfcaa999ac4a666bbfa07f66c5e4ba26c747fbn
}, {
  a: 0x101edbee1143b31a02a61ab3b8102dd42c846313f4ab3bn,
  r: -0x101edbee1143b31a02a61ab3b8102dd42c846313f4ab3bn
}, {
  a: -0x9864748370e1872e2a11c910344f7db56fcdf6f18fccb2872b7cc5ac1a563cb362c0dn,
  r: 0x9864748370e1872e2a11c910344f7db56fcdf6f18fccb2872b7cc5ac1a563cb362c0dn
}, {
  a: 0x43174c5841cd9fdf45ff62d58141e63c95ade566521d2d8be6350cn,
  r: -0x43174c5841cd9fdf45ff62d58141e63c95ade566521d2d8be6350cn
}, {
  a: 0xd95723634f0eff90ff7158a8b07d6ca379484df54ae787dd956e7e7ddb8128150df18bn,
  r: -0xd95723634f0eff90ff7158a8b07d6ca379484df54ae787dd956e7e7ddb8128150df18bn
}, {
  a: -0x6030n,
  r: 0x6030n
}, {
  a: 0x6609ff3e4a7c130ca3409n,
  r: -0x6609ff3e4a7c130ca3409n
}, {
  a: 0x42c795195fccae77259b43c66cf2c3dc1d256968583f5e0243e9cc6670dn,
  r: -0x42c795195fccae77259b43c66cf2c3dc1d256968583f5e0243e9cc6670dn
}, {
  a: 0x579b616d2f7d4fd001e6e8ac0ec24c786n,
  r: -0x579b616d2f7d4fd001e6e8ac0ec24c786n
}, {
  a: 0xb8019aaba37231133ef56n,
  r: -0xb8019aaba37231133ef56n
}, {
  a: 0x92f4765750137b5bf90015d7b1n,
  r: -0x92f4765750137b5bf90015d7b1n
}, {
  a: 0xc59ed26889d4dfff227856d4bba5c1ed4c650f4n,
  r: -0xc59ed26889d4dfff227856d4bba5c1ed4c650f4n
}, {
  a: -0xb4a1e01422424d78d93de9b00d478bae2b776dn,
  r: 0xb4a1e01422424d78d93de9b00d478bae2b776dn
}, {
  a: -0x5e33d86c9e0846062b1b2114c9858c8f9c689714de9c93037b195e1n,
  r: 0x5e33d86c9e0846062b1b2114c9858c8f9c689714de9c93037b195e1n
}, {
  a: 0x19a51d32b2f6ea6fdd12730465cn,
  r: -0x19a51d32b2f6ea6fdd12730465cn
}, {
  a: 0x35a67cn,
  r: -0x35a67cn
}, {
  a: 0x73a9314edd40d892b1e00639cb54ccd10dd4620f01b53e2548c91b3a8922f37dn,
  r: -0x73a9314edd40d892b1e00639cb54ccd10dd4620f01b53e2548c91b3a8922f37dn
}, {
  a: 0x23c50cfea4820370155df637bd9dd014929c28a42c99f8a071b712476b69b1a26b0n,
  r: -0x23c50cfea4820370155df637bd9dd014929c28a42c99f8a071b712476b69b1a26b0n
}, {
  a: 0x53cfa6b8bc72ed43ba0ad11aec7438b32527e8e108ceee08n,
  r: -0x53cfa6b8bc72ed43ba0ad11aec7438b32527e8e108ceee08n
}, {
  a: -0x2df59ca5cd134116faaf1b9b2b85a0e3458aba229d5737521563d7cdea933n,
  r: 0x2df59ca5cd134116faaf1b9b2b85a0e3458aba229d5737521563d7cdea933n
}, {
  a: 0x4ac3d495cn,
  r: -0x4ac3d495cn
}, {
  a: -0x313db8a9588bd07dbe845f80a2436d01df9adf277f0f508d407c10cfde88fd3en,
  r: 0x313db8a9588bd07dbe845f80a2436d01df9adf277f0f508d407c10cfde88fd3en
}, {
  a: -0xc69467c868320651de09b633e3d94da9c7006958ff5e305e17en,
  r: 0xc69467c868320651de09b633e3d94da9c7006958ff5e305e17en
}, {
  a: -0x3d24bff03d6c6537e7865450f5fb7d37324n,
  r: 0x3d24bff03d6c6537e7865450f5fb7d37324n
}, {
  a: 0xf8c7bc9f2fn,
  r: -0xf8c7bc9f2fn
}, {
  a: 0xae6n,
  r: -0xae6n
}, {
  a: 0x85eb2988d22bd434a3348acccbaac628358f5n,
  r: -0x85eb2988d22bd434a3348acccbaac628358f5n
}, {
  a: 0x873c464089bfb5c9efd3b3a89d7500bdn,
  r: -0x873c464089bfb5c9efd3b3a89d7500bdn
}, {
  a: 0xf46481c153c2f2e6c2bn,
  r: -0xf46481c153c2f2e6c2bn
}, {
  a: 0x11d60b478n,
  r: -0x11d60b478n
}, {
  a: 0x2426adacaan,
  r: -0x2426adacaan
}, {
  a: -0xfdc952f8231c162921ec88404c4519a60024d5504686b372dn,
  r: 0xfdc952f8231c162921ec88404c4519a60024d5504686b372dn
}, {
  a: -0xd0d93c75ccaced6296an,
  r: 0xd0d93c75ccaced6296an
}, {
  a: -0x14b0n,
  r: 0x14b0n
}, {
  a: 0x39759f59564361da8cd80fc68d0863n,
  r: -0x39759f59564361da8cd80fc68d0863n
}, {
  a: 0x2d08202d20ccdcf941ce2c567171d2ee2c7899a7f30e4b75e406dcn,
  r: -0x2d08202d20ccdcf941ce2c567171d2ee2c7899a7f30e4b75e406dcn
}, {
  a: -0xcc844a1824fd1df06b1cbde70c53244537dn,
  r: 0xcc844a1824fd1df06b1cbde70c53244537dn
}, {
  a: -0x9af08edc8d642dean,
  r: 0x9af08edc8d642dean
}, {
  a: 0x59e6c5d3da5bae6980b662408e046d77f0d2c69bcbbff94f43d383d52n,
  r: -0x59e6c5d3da5bae6980b662408e046d77f0d2c69bcbbff94f43d383d52n
}, {
  a: 0n,
  r: 0n
}, {
  a: -0x1bb1f87a6de247e77786dd9a7b8432aed9245215d6e9b3n,
  r: 0x1bb1f87a6de247e77786dd9a7b8432aed9245215d6e9b3n
}, {
  a: -0xf2n,
  r: 0xf2n
}, {
  a: -0x6d3n,
  r: 0x6d3n
}, {
  a: -0xan,
  r: 0xan
}, {
  a: -0x765a3d8831f329cf958c720f1de6535b73f669db2a58d539n,
  r: 0x765a3d8831f329cf958c720f1de6535b73f669db2a58d539n
}, {
  a: -0xddf9a11669ded1feefae11a92623f6523d5d9ba7f64bffn,
  r: 0xddf9a11669ded1feefae11a92623f6523d5d9ba7f64bffn
}, {
  a: 0xa15332545ea713c6n,
  r: -0xa15332545ea713c6n
}, {
  a: 0xd99584bd098d17b15b2fad8n,
  r: -0xd99584bd098d17b15b2fad8n
}, {
  a: 0x97810b6b1ec84d286402525112f073944aa2690f8ece306c2216e7328e08f6439c5bn,
  r: -0x97810b6b1ec84d286402525112f073944aa2690f8ece306c2216e7328e08f6439c5bn
}, {
  a: -0xa2106df782ae5f2c0867b1bf2d2a6e516d76091173cc9b8ad10b069en,
  r: 0xa2106df782ae5f2c0867b1bf2d2a6e516d76091173cc9b8ad10b069en
}, {
  a: 0xcn,
  r: -0xcn
}, {
  a: 0xc7n,
  r: -0xc7n
}, {
  a: 0x72969e0a655bed2a82d36080385n,
  r: -0x72969e0a655bed2a82d36080385n
}, {
  a: -0xcceaa000c855cbf3c0de4a678bf78de776403n,
  r: 0xcceaa000c855cbf3c0de4a678bf78de776403n
}, {
  a: -0x68784033cfcd7cf1add7a1e291ebeb07f5fff2b454a09d7f870852cd1911cc2ccn,
  r: 0x68784033cfcd7cf1add7a1e291ebeb07f5fff2b454a09d7f870852cd1911cc2ccn
}, {
  a: -0x3e81061d975af5001bde780a8n,
  r: 0x3e81061d975af5001bde780a8n
}, {
  a: -0x17748n,
  r: 0x17748n
}, {
  a: -0x934c8eb8e29eae0fb345e60ce9en,
  r: 0x934c8eb8e29eae0fb345e60ce9en
}, {
  a: 0xb5fce19ad4bd28748f21035ba1fb5008669b809b243e5a26d476f3e951654f01daaad7n,
  r: -0xb5fce19ad4bd28748f21035ba1fb5008669b809b243e5a26d476f3e951654f01daaad7n
}, {
  a: 0x1afb814b328ad10a3731ddc8ff13b9164fab509af13fb798f173n,
  r: -0x1afb814b328ad10a3731ddc8ff13b9164fab509af13fb798f173n
}, {
  a: -0x5ac71426ceen,
  r: 0x5ac71426ceen
}, {
  a: -0x65e747beaa044f8c10bdfdf277804c9d370159n,
  r: 0x65e747beaa044f8c10bdfdf277804c9d370159n
}, {
  a: -0xd1466bae02bd5dda8f627a482882330008dbeef82a7b5df4b7651c0bd9f6acf0925n,
  r: 0xd1466bae02bd5dda8f627a482882330008dbeef82a7b5df4b7651c0bd9f6acf0925n
}, {
  a: -0xa2ff7dff8a8e6e9571a28ff78efc0n,
  r: 0xa2ff7dff8a8e6e9571a28ff78efc0n
}, {
  a: -0x1c5245e9n,
  r: 0x1c5245e9n
}, {
  a: 0x4afec6cn,
  r: -0x4afec6cn
}, {
  a: -0x9ddfd87e2ffa0cn,
  r: 0x9ddfd87e2ffa0cn
}, {
  a: 0x548d370cccd421247a4c2759a84f6586fd25f7911487bd6b4123a2an,
  r: -0x548d370cccd421247a4c2759a84f6586fd25f7911487bd6b4123a2an
}, {
  a: 0x89460b3011529e1ad481bbc2dd18520924dc5n,
  r: -0x89460b3011529e1ad481bbc2dd18520924dc5n
}, {
  a: -0x671efd1b9579d7cb7fcf6773a37386b2a9b030a973acddde5b6bf676997ea4e40ee55n,
  r: 0x671efd1b9579d7cb7fcf6773a37386b2a9b030a973acddde5b6bf676997ea4e40ee55n
}, {
  a: 0xec8n,
  r: -0xec8n
}, {
  a: 0x6673c9308226dceaac2efc89dbd7ddec3b4a2c6c138ab3784f9726c021n,
  r: -0x6673c9308226dceaac2efc89dbd7ddec3b4a2c6c138ab3784f9726c021n
}, {
  a: 0xf59an,
  r: -0xf59an
}, {
  a: -0x2b32c979d08e49e53d223a454fa1258b8d67801062bn,
  r: 0x2b32c979d08e49e53d223a454fa1258b8d67801062bn
}, {
  a: 0xc0113308fda70b5b0ffc3c439262c0d64b27e732cn,
  r: -0xc0113308fda70b5b0ffc3c439262c0d64b27e732cn
}, {
  a: -0x349ed5af6781eb31bb35659189e7fn,
  r: 0x349ed5af6781eb31bb35659189e7fn
}, {
  a: -0xa0e49b073a3a43093a32e144n,
  r: 0xa0e49b073a3a43093a32e144n
}, {
  a: 0xa68cf8461e233942843bd28fn,
  r: -0xa68cf8461e233942843bd28fn
}, {
  a: 0n,
  r: 0n
}, {
  a: -0x9c97b0bf359c549a8bcbdc53d57099b593fc208f5af2n,
  r: 0x9c97b0bf359c549a8bcbdc53d57099b593fc208f5af2n
}, {
  a: -0x346f72c2ef3ac65325cb7792f92f81065cd0029247e7922c2bfdaa5fn,
  r: 0x346f72c2ef3ac65325cb7792f92f81065cd0029247e7922c2bfdaa5fn
}, {
  a: -0x1b3cdd0232421cdcd344edfb59a7d6158be57fa51569a4bb6dd57422927n,
  r: 0x1b3cdd0232421cdcd344edfb59a7d6158be57fa51569a4bb6dd57422927n
}, {
  a: -0xd35628d75752e3339d1a16038d384bf3ab905fdaeeb0220351ddn,
  r: 0xd35628d75752e3339d1a16038d384bf3ab905fdaeeb0220351ddn
}, {
  a: -0x936a4f7e90a59658dac0890c27d1aff76e219b666c1bcbdaca7932820ddn,
  r: 0x936a4f7e90a59658dac0890c27d1aff76e219b666c1bcbdaca7932820ddn
}, {
  a: -0x38bd4c0259e754e207n,
  r: 0x38bd4c0259e754e207n
}, {
  a: -0x84e0493b11f173398c3c928b07c926a982ac802a853934ae3c611d0815fd88f83d60e6n,
  r: 0x84e0493b11f173398c3c928b07c926a982ac802a853934ae3c611d0815fd88f83d60e6n
}, {
  a: 0xd89073d5e7ea5b221a354b7408n,
  r: -0xd89073d5e7ea5b221a354b7408n
}, {
  a: 0xfb13c7c89a9ff078d642b81fcf252c4952c34039181b1dce2d68bn,
  r: -0xfb13c7c89a9ff078d642b81fcf252c4952c34039181b1dce2d68bn
}, {
  a: 0x2cd24985c783fec349550dfcb318b536c7a40e72988c97983f74e7847n,
  r: -0x2cd24985c783fec349550dfcb318b536c7a40e72988c97983f74e7847n
}, {
  a: 0xc9e649b28c4cn,
  r: -0xc9e649b28c4cn
}, {
  a: -0xdf2c39n,
  r: 0xdf2c39n
}, {
  a: -0x13893fd3ac1dd2ecdf6d669c65d3b103b5cdbbc2d686n,
  r: 0x13893fd3ac1dd2ecdf6d669c65d3b103b5cdbbc2d686n
}, {
  a: 0x7f6e6465689529n,
  r: -0x7f6e6465689529n
}, {
  a: 0xcb965b94ec8e02ba92c1d40b5a57e30f55c8e1a197b711f4n,
  r: -0xcb965b94ec8e02ba92c1d40b5a57e30f55c8e1a197b711f4n
}, {
  a: 0x3fad1388fc8109c74n,
  r: -0x3fad1388fc8109c74n
}, {
  a: -0x4658a5f330120a0c131cfbadc04d0d20c5ee2b76n,
  r: 0x4658a5f330120a0c131cfbadc04d0d20c5ee2b76n
}, {
  a: 0x8f32483a32dc3522b05f72f4dfdefbcce9bbee184f86e77e96dfabe41680dbcd2ben,
  r: -0x8f32483a32dc3522b05f72f4dfdefbcce9bbee184f86e77e96dfabe41680dbcd2ben
}, {
  a: 0x6814d3f2a1ebbd4e3f99df3bd701aa3712fe0bf64073676579e997en,
  r: -0x6814d3f2a1ebbd4e3f99df3bd701aa3712fe0bf64073676579e997en
}, {
  a: 0x3271c920b749ba676dccbb2f7d31727302fb59e098a9453b13n,
  r: -0x3271c920b749ba676dccbb2f7d31727302fb59e098a9453b13n
}, {
  a: 0xc4ff5da361fa22a197a789ece9f4e2b77f6cffffb6f36n,
  r: -0xc4ff5da361fa22a197a789ece9f4e2b77f6cffffb6f36n
}, {
  a: 0n,
  r: 0n
}, {
  a: 0x85965n,
  r: -0x85965n
}, {
  a: -0x349e331cc41a8c9bc35e46ff19b09b3f4035b2600967a1an,
  r: 0x349e331cc41a8c9bc35e46ff19b09b3f4035b2600967a1an
}, {
  a: 0x4b71d6528a29bad95fa5e644ad6653500146d585891d37270cdf551cn,
  r: -0x4b71d6528a29bad95fa5e644ad6653500146d585891d37270cdf551cn
}, {
  a: 0x4b67f49313cb7776c1e8506204c6fen,
  r: -0x4b67f49313cb7776c1e8506204c6fen
}, {
  a: 0xb5a067157143002b8360ab27166ab8baf6ba5f614en,
  r: -0xb5a067157143002b8360ab27166ab8baf6ba5f614en
}, {
  a: -0xdd628196d4afc8f1981e9905829d51ecf63feaec0df5ba694934def0334c3d0438a3n,
  r: 0xdd628196d4afc8f1981e9905829d51ecf63feaec0df5ba694934def0334c3d0438a3n
}, {
  a: 0x9a32c223cb06e25e1e9ffe29f6330af975293a8d6ca101cn,
  r: -0x9a32c223cb06e25e1e9ffe29f6330af975293a8d6ca101cn
}, {
  a: -0x521421f9c02843e16aa9b8e726514708e03b16ccc92a6a2b853d28c63737abn,
  r: 0x521421f9c02843e16aa9b8e726514708e03b16ccc92a6a2b853d28c63737abn
}, {
  a: 0x7d8252c464c280e1cce5720fe73ca47bac6fb4349bd5578eb9d0fd8e886b3181bdf1n,
  r: -0x7d8252c464c280e1cce5720fe73ca47bac6fb4349bd5578eb9d0fd8e886b3181bdf1n
}, {
  a: 0x7eb86cd1522a3719302f04f3dff89cb94af2d857e69e6n,
  r: -0x7eb86cd1522a3719302f04f3dff89cb94af2d857e69e6n
}, {
  a: 0xf2736412040f7n,
  r: -0xf2736412040f7n
}, {
  a: -0x127584897c0791c09195c97056ed4768n,
  r: 0x127584897c0791c09195c97056ed4768n
}, {
  a: -0xbd2abe7194f9567523532f081fn,
  r: 0xbd2abe7194f9567523532f081fn
}, {
  a: -0x3416a29b2475ff7a4518418067e6e34b6n,
  r: 0x3416a29b2475ff7a4518418067e6e34b6n
}, {
  a: -0xf6e21b4416d90c97132d4fdc34033b87705710662be9d915f079b5e25f031345ba3n,
  r: 0xf6e21b4416d90c97132d4fdc34033b87705710662be9d915f079b5e25f031345ba3n
}, {
  a: 0xbfaac6a4bb371492bcf8f18e62cae8485aae2b5844n,
  r: -0xbfaac6a4bb371492bcf8f18e62cae8485aae2b5844n
}, {
  a: -0xbcebd57034a64259d1779a550a9a6e0df315b4a4ea34cn,
  r: 0xbcebd57034a64259d1779a550a9a6e0df315b4a4ea34cn
}, {
  a: 0x66f6812eda9e2f7d3de302bd71418471939f836045n,
  r: -0x66f6812eda9e2f7d3de302bd71418471939f836045n
}, {
  a: -0xe9b0a1aa9b83188b5e8e153b7e85263843d79a8f8ban,
  r: 0xe9b0a1aa9b83188b5e8e153b7e85263843d79a8f8ban
}, {
  a: -0x213c9ecn,
  r: 0x213c9ecn
}, {
  a: -0xeef6b5n,
  r: 0xeef6b5n
}, {
  a: 0xd78en,
  r: -0xd78en
}, {
  a: -0x47n,
  r: 0x47n
}, {
  a: 0x8e36a56e1a4bd39c6191d6f73e5n,
  r: -0x8e36a56e1a4bd39c6191d6f73e5n
}, {
  a: -0x60736bc6ece2ec0e55eff7bc611c28b4cc927ef20723dc616n,
  r: 0x60736bc6ece2ec0e55eff7bc611c28b4cc927ef20723dc616n
}, {
  a: -0xb695b434e1ef889eb79003e06c1d1fbn,
  r: 0xb695b434e1ef889eb79003e06c1d1fbn
}, {
  a: 0x6375f3028a3efb7e17747aa871fdbf10ff94791691fc75ef6c73c6205cac559n,
  r: -0x6375f3028a3efb7e17747aa871fdbf10ff94791691fc75ef6c73c6205cac559n
}, {
  a: -0x5f40a99ea549n,
  r: 0x5f40a99ea549n
}, {
  a: 0xfc5ee784574b55db213c6e8n,
  r: -0xfc5ee784574b55db213c6e8n
}, {
  a: -0x76375c4eb8e49e60261235edae2e7can,
  r: 0x76375c4eb8e49e60261235edae2e7can
}, {
  a: -0x8ab7c4e685caa505a16fdebfe369b8a943cen,
  r: 0x8ab7c4e685caa505a16fdebfe369b8a943cen
}, {
  a: 0x6a03ca1c8b69c3d957ea008n,
  r: -0x6a03ca1c8b69c3d957ea008n
}, {
  a: 0x2a28adb0c5b454903b14879f2907e5acc9n,
  r: -0x2a28adb0c5b454903b14879f2907e5acc9n
}, {
  a: 0x5ba857700b8d92ddae8e395c56efa833ebbe7d52dan,
  r: -0x5ba857700b8d92ddae8e395c56efa833ebbe7d52dan
}, {
  a: 0x60b8b9f0151bf5d11db9133432be493af45500daa4c38106238eb455dn,
  r: -0x60b8b9f0151bf5d11db9133432be493af45500daa4c38106238eb455dn
}, {
  a: -0x782fc8ea89bfcfe1997af1b94242abc85c0706n,
  r: 0x782fc8ea89bfcfe1997af1b94242abc85c0706n
}, {
  a: -0x573db5480ed1dab63ee7179a934af0ee6fa732b98ebn,
  r: 0x573db5480ed1dab63ee7179a934af0ee6fa732b98ebn
}, {
  a: 0xdacf6741451f15fd08e274163ebn,
  r: -0xdacf6741451f15fd08e274163ebn
}, {
  a: -0x925e6fd15dcc62aeb0ac8d21b5ecec6a15e07b32f5623a1en,
  r: 0x925e6fd15dcc62aeb0ac8d21b5ecec6a15e07b32f5623a1en
}, {
  a: 0x5a052e5a9b37a9n,
  r: -0x5a052e5a9b37a9n
}, {
  a: 0xbe0bd4526909eadec5db75ee3ce13763bd91618e490cc8a27ce3c5a772234n,
  r: -0xbe0bd4526909eadec5db75ee3ce13763bd91618e490cc8a27ce3c5a772234n
}, {
  a: 0xc7ccd5a62320d677060n,
  r: -0xc7ccd5a62320d677060n
}, {
  a: 0x81c88590n,
  r: -0x81c88590n
}, {
  a: -0x3358970ae21ae5d25036a2a6bc9ee42e5b822482d0b87b711a7ca756234762f2036aen,
  r: 0x3358970ae21ae5d25036a2a6bc9ee42e5b822482d0b87b711a7ca756234762f2036aen
}, {
  a: 0x568367d0d868b9f250b3ab160ac8d77n,
  r: -0x568367d0d868b9f250b3ab160ac8d77n
}, {
  a: -0x5aeaf302f99en,
  r: 0x5aeaf302f99en
}, {
  a: 0xb5a302673eab8061865e00n,
  r: -0xb5a302673eab8061865e00n
}, {
  a: -0x6240a2eb4db46f9d1e151ca14e5cd494e91406b33bb27c539a22f89c6a8bfn,
  r: 0x6240a2eb4db46f9d1e151ca14e5cd494e91406b33bb27c539a22f89c6a8bfn
}, {
  a: -0x355ef6eb6ee24323a6a4d9be5d59d64444150525bbb61n,
  r: 0x355ef6eb6ee24323a6a4d9be5d59d64444150525bbb61n
}, {
  a: 0x590954f031ddfcce9116ae3c9a707b0b2802af5bde15256560470b264194aed873bn,
  r: -0x590954f031ddfcce9116ae3c9a707b0b2802af5bde15256560470b264194aed873bn
}, {
  a: -0x9550a123005de36f9f013fe862f9n,
  r: 0x9550a123005de36f9f013fe862f9n
}, {
  a: 0x34c302c2a84n,
  r: -0x34c302c2a84n
}, {
  a: -0xf1f63795f881168145185bd2e13b2b8e4fc44fba106ea399d4804ab4206f0bcc4n,
  r: 0xf1f63795f881168145185bd2e13b2b8e4fc44fba106ea399d4804ab4206f0bcc4n
}, {
  a: -0x8eb7e927832b6bc2273d0d5d40e059693ccd3acc5cn,
  r: 0x8eb7e927832b6bc2273d0d5d40e059693ccd3acc5cn
}, {
  a: -0x8490dddfe3283a00b566e6d72c7n,
  r: 0x8490dddfe3283a00b566e6d72c7n
}, {
  a: -0x683d5ea48f7502c3ec6505f7cn,
  r: 0x683d5ea48f7502c3ec6505f7cn
}, {
  a: -0x8669f51e704dbf81d3c4c3d8aca6ffe7277ca79eeb2f8530d0632bn,
  r: 0x8669f51e704dbf81d3c4c3d8aca6ffe7277ca79eeb2f8530d0632bn
}, {
  a: -0xadb509d6171d2d6835fe362a8b2d17e688a2753b1298c32f232n,
  r: 0xadb509d6171d2d6835fe362a8b2d17e688a2753b1298c32f232n
}, {
  a: 0x6e022eb093eb818699n,
  r: -0x6e022eb093eb818699n
}, {
  a: -0xef952bda283619ff4b3c8d8dn,
  r: 0xef952bda283619ff4b3c8d8dn
}, {
  a: 0xd2684cc5fa2e1fcb11d7c12ec28766cfca95b4d6f1ee5fadn,
  r: -0xd2684cc5fa2e1fcb11d7c12ec28766cfca95b4d6f1ee5fadn
}, {
  a: -0x705db3597e12203e18f71103456n,
  r: 0x705db3597e12203e18f71103456n
}, {
  a: -0xf54d59951529e78c2ac2b0929482959478f895a50894725abe2a9451n,
  r: 0xf54d59951529e78c2ac2b0929482959478f895a50894725abe2a9451n
}, {
  a: -0x54cfecff6295bc26534b82eca5fc9afdc16dc1098aa2c27360a4447879d608a963dn,
  r: 0x54cfecff6295bc26534b82eca5fc9afdc16dc1098aa2c27360a4447879d608a963dn
}, {
  a: 0x3a42cbn,
  r: -0x3a42cbn
}, {
  a: 0xd381919034a47dcbdd6f62f36d339bf9a73afc49b30cbeccffb953c2bd60ae09e90041n,
  r: -0xd381919034a47dcbdd6f62f36d339bf9a73afc49b30cbeccffb953c2bd60ae09e90041n
}, {
  a: 0xf1be70faee3f6bb62c84c6n,
  r: -0xf1be70faee3f6bb62c84c6n
}, {
  a: -0x8c355defbb351a8f1a352f2ccf0eb0388fbc9d2a6154b01c40f85d3871635f403n,
  r: 0x8c355defbb351a8f1a352f2ccf0eb0388fbc9d2a6154b01c40f85d3871635f403n
}, {
  a: 0x9dec4ee3da7f71f5161820c03a8345cc59b0dfe8c20db21f230n,
  r: -0x9dec4ee3da7f71f5161820c03a8345cc59b0dfe8c20db21f230n
}, {
  a: 0x480cd85ae2e3fd9ecf2f7417863a40db8dc44ef6e122n,
  r: -0x480cd85ae2e3fd9ecf2f7417863a40db8dc44ef6e122n
}, {
  a: -0x5b3f33a69de51e639ca0f914673113f1361c03cc373849a8d80e58a43n,
  r: 0x5b3f33a69de51e639ca0f914673113f1361c03cc373849a8d80e58a43n
}, {
  a: 0x9e9f739967209c30803300c47bn,
  r: -0x9e9f739967209c30803300c47bn
}, {
  a: 0x79dd62975a28fac036b83981b1428cba37d2f81fb6cn,
  r: -0x79dd62975a28fac036b83981b1428cba37d2f81fb6cn
}, {
  a: 0x21a7724dca20915edff4fba345f23644ce5c1e579a2376fn,
  r: -0x21a7724dca20915edff4fba345f23644ce5c1e579a2376fn
}, {
  a: 0xde33a5068a3f2227687n,
  r: -0xde33a5068a3f2227687n
}, {
  a: -0x11aa3n,
  r: 0x11aa3n
}, {
  a: -0x9n,
  r: 0x9n
}, {
  a: -0x3455037d5afa1fcn,
  r: 0x3455037d5afa1fcn
}, {
  a: -0x3764ee31dd36bb80d62bfb7325784n,
  r: 0x3764ee31dd36bb80d62bfb7325784n
}, {
  a: 0xa58aab3c43283dedd3cfad1907c9c951756b5c67d1bd6836f0d53n,
  r: -0xa58aab3c43283dedd3cfad1907c9c951756b5c67d1bd6836f0d53n
}, {
  a: -0xd3f28bb0n,
  r: 0xd3f28bb0n
}, {
  a: 0x675735e64a33d4dd11cb036e8289586531ce80dan,
  r: -0x675735e64a33d4dd11cb036e8289586531ce80dan
}, {
  a: 0x3b96034da571b133b3ab0e7489ef18c9fed6ad4a71b0868953n,
  r: -0x3b96034da571b133b3ab0e7489ef18c9fed6ad4a71b0868953n
}, {
  a: 0xf1n,
  r: -0xf1n
}, {
  a: 0x9161a9878971f245f68ae8b4d53ec1550430f41b7031d0c23801f1975n,
  r: -0x9161a9878971f245f68ae8b4d53ec1550430f41b7031d0c23801f1975n
}, {
  a: 0x6f0fb3022891fb2afbafce1620ab1dcbbcc1c465aa746efcf6a88f8ac4ab42fbda351n,
  r: -0x6f0fb3022891fb2afbafce1620ab1dcbbcc1c465aa746efcf6a88f8ac4ab42fbda351n
}, {
  a: 0x8fb0d042n,
  r: -0x8fb0d042n
}, {
  a: 0x2e1b79bc33e571f43fc2cc0780n,
  r: -0x2e1b79bc33e571f43fc2cc0780n
}, {
  a: -0x5fc118f7c6f4c69e2b5e5ebfe00badd8fd1149f36e98500b2c6899f5489d3n,
  r: 0x5fc118f7c6f4c69e2b5e5ebfe00badd8fd1149f36e98500b2c6899f5489d3n
}, {
  a: -0xa693258fe54070n,
  r: 0xa693258fe54070n
}, {
  a: -0xe355d3d13b344335c69bc14d73a71aa1e39450d072ce5n,
  r: 0xe355d3d13b344335c69bc14d73a71aa1e39450d072ce5n
}, {
  a: -0x8715ad095a102125b72f6768fb0bb388fe96abcd4c9b042684ba8ca0458en,
  r: 0x8715ad095a102125b72f6768fb0bb388fe96abcd4c9b042684ba8ca0458en
}, {
  a: -0xa543581ae75a0c0a3401340718d2e7bc7a70e4c67be615474b8ccb0n,
  r: 0xa543581ae75a0c0a3401340718d2e7bc7a70e4c67be615474b8ccb0n
}, {
  a: 0xdn,
  r: -0xdn
}, {
  a: 0x6d96237732f75079cean,
  r: -0x6d96237732f75079cean
}, {
  a: 0x6n,
  r: -0x6n
}, {
  a: 0xf098fe397f5553be7ad333c8b6726n,
  r: -0xf098fe397f5553be7ad333c8b6726n
}, {
  a: -0xcb4948df4b2b802bf089bbc19836b634c5559a4f00a4d71619fa5f1n,
  r: 0xcb4948df4b2b802bf089bbc19836b634c5559a4f00a4d71619fa5f1n
}, {
  a: 0xa32fb0afb2ed5a71a2c0e35fd9257895d1c61565fa63bd2ca002eb1eec5f1aa35c7dcn,
  r: -0xa32fb0afb2ed5a71a2c0e35fd9257895d1c61565fa63bd2ca002eb1eec5f1aa35c7dcn
}, {
  a: -0xfd0465c85f8bc21a8b5c7d3f217b06106acc8309b090318aabb48368300d6a02d4b7cn,
  r: 0xfd0465c85f8bc21a8b5c7d3f217b06106acc8309b090318aabb48368300d6a02d4b7cn
}, {
  a: 0xaba5b1dff9f8a18ae71a2n,
  r: -0xaba5b1dff9f8a18ae71a2n
}, {
  a: 0xde758f0e03737e99df48c09b2cc110e563d6d6611n,
  r: -0xde758f0e03737e99df48c09b2cc110e563d6d6611n
}, {
  a: 0xf6eaa7c6b6ed089d4n,
  r: -0xf6eaa7c6b6ed089d4n
}, {
  a: 0xb1c3d508fean,
  r: -0xb1c3d508fean
}, {
  a: 0xa930767abd73c22617c49dee023f2f243465fc070f0501209dbfe730b6a4293n,
  r: -0xa930767abd73c22617c49dee023f2f243465fc070f0501209dbfe730b6a4293n
}, {
  a: -0x94f8db4bcba37ac3f165d7cefccd5766b82b80848e8b58f1bb91149n,
  r: 0x94f8db4bcba37ac3f165d7cefccd5766b82b80848e8b58f1bb91149n
}, {
  a: 0x1e6ef7ece1a3211b30b4790c1n,
  r: -0x1e6ef7ece1a3211b30b4790c1n
}, {
  a: -0x57dfa5c7952698a6e506d22747855dn,
  r: 0x57dfa5c7952698a6e506d22747855dn
}, {
  a: -0xe233167b09abf1318bb33de1e7d8ebc19375b3e652n,
  r: 0xe233167b09abf1318bb33de1e7d8ebc19375b3e652n
}, {
  a: -0xddn,
  r: 0xddn
}, {
  a: 0xf708f671ba9a060a361beef9n,
  r: -0xf708f671ba9a060a361beef9n
}, {
  a: -0xac89569005cd80092ccac84n,
  r: 0xac89569005cd80092ccac84n
}, {
  a: 0x319fc4f0e7abfada56897ce46c3cd9b28d614fn,
  r: -0x319fc4f0e7abfada56897ce46c3cd9b28d614fn
}, {
  a: 0x9e35defe212493d5an,
  r: -0x9e35defe212493d5an
}, {
  a: 0xb9fccb5b2d92af4n,
  r: -0xb9fccb5b2d92af4n
}, {
  a: -0x90a1403d8f606d10d44a33c1106f3e489909637849b559600150487ac311n,
  r: 0x90a1403d8f606d10d44a33c1106f3e489909637849b559600150487ac311n
}, {
  a: 0xcn,
  r: -0xcn
}, {
  a: -0x1f2f1f9caff5b7e595en,
  r: 0x1f2f1f9caff5b7e595en
}, {
  a: -0x56ed66febebbac47b30db10d5bf4c4n,
  r: 0x56ed66febebbac47b30db10d5bf4c4n
}, {
  a: 0xeaea6d5cf54bn,
  r: -0xeaea6d5cf54bn
}, {
  a: 0xf00dc4fa3793d534e5b61ba2d1d718n,
  r: -0xf00dc4fa3793d534e5b61ba2d1d718n
}, {
  a: 0xfc7e8d6f583aa342b61672f1065990n,
  r: -0xfc7e8d6f583aa342b61672f1065990n
}, {
  a: -0x1817bb1ccc668beabd7c1c80d3fcb8ac759f11fb310fca26f5f071aef27a6adecbf669n,
  r: 0x1817bb1ccc668beabd7c1c80d3fcb8ac759f11fb310fca26f5f071aef27a6adecbf669n
}, {
  a: -0x1813d25447cb621c61b10296303b9345f3880b7a9f9758d584af97an,
  r: 0x1813d25447cb621c61b10296303b9345f3880b7a9f9758d584af97an
}, {
  a: -0xc6d0f06c72fafe922cbab8744bn,
  r: 0xc6d0f06c72fafe922cbab8744bn
}, {
  a: 0x2fea81db8a20c57f1730529d042e3bn,
  r: -0x2fea81db8a20c57f1730529d042e3bn
}, {
  a: 0x7619b98e29b7857dab5b94e35a48ed254c930bbfec98n,
  r: -0x7619b98e29b7857dab5b94e35a48ed254c930bbfec98n
}, {
  a: 0x3c0a18c930cd31b9828efa36d373a48b84331a3121c77eee0332868ac525n,
  r: -0x3c0a18c930cd31b9828efa36d373a48b84331a3121c77eee0332868ac525n
}, {
  a: 0x4ae6e570ed27a94d5n,
  r: -0x4ae6e570ed27a94d5n
}, {
  a: 0x506b88d4bn,
  r: -0x506b88d4bn
}, {
  a: 0x71cfdaad83a2bc4d2c7adcdc7f4b23c5f4a08afeac6a1b363d1b9bb0fa6n,
  r: -0x71cfdaad83a2bc4d2c7adcdc7f4b23c5f4a08afeac6a1b363d1b9bb0fa6n
}, {
  a: -0x9881c133c42c52a5en,
  r: 0x9881c133c42c52a5en
}, {
  a: 0xa027518521882b12b3c8477e5e8b51071d81b39c0431282eabb12043cc92dn,
  r: -0xa027518521882b12b3c8477e5e8b51071d81b39c0431282eabb12043cc92dn
}, {
  a: -0x1ecaa6f33279d5c96568f24ba0aac0bb7339305c6fn,
  r: 0x1ecaa6f33279d5c96568f24ba0aac0bb7339305c6fn
}, {
  a: -0x59e73f6b568e140en,
  r: 0x59e73f6b568e140en
}, {
  a: -0x41a147168998ae73b24476d3e58d4adcc32a23f89n,
  r: 0x41a147168998ae73b24476d3e58d4adcc32a23f89n
}, {
  a: -0xddc886583fda8c84edbn,
  r: 0xddc886583fda8c84edbn
}, {
  a: 0x29fca03ee0319e4cee99e72bc141528ff2fc9a0d0c953b83f0c2049c002f88decdb6e8n,
  r: -0x29fca03ee0319e4cee99e72bc141528ff2fc9a0d0c953b83f0c2049c002f88decdb6e8n
}, {
  a: -0x5fd281n,
  r: 0x5fd281n
}, {
  a: 0x215a4088803065417806ad82cec14086deb01f71n,
  r: -0x215a4088803065417806ad82cec14086deb01f71n
}, {
  a: -0x9cb90f69a311e50e717d6771b5a608ada7fd862d84d7c33c1642718f30d905ecn,
  r: 0x9cb90f69a311e50e717d6771b5a608ada7fd862d84d7c33c1642718f30d905ecn
}, {
  a: 0xdaf842927a2d3ada86e3f1dce8d6n,
  r: -0xdaf842927a2d3ada86e3f1dce8d6n
}, {
  a: 0x9b1d98ec48b88fc6ede5de84e6n,
  r: -0x9b1d98ec48b88fc6ede5de84e6n
}, {
  a: -0x5b5045b1b34bc37fn,
  r: 0x5b5045b1b34bc37fn
}, {
  a: -0x25b7c361d32554393d0a88e70ed9f32bcdcbe9782bf7bae68c0f6e6ddde0n,
  r: 0x25b7c361d32554393d0a88e70ed9f32bcdcbe9782bf7bae68c0f6e6ddde0n
}, {
  a: -0x7d9a3371c0bc3b898434911f84n,
  r: 0x7d9a3371c0bc3b898434911f84n
}, {
  a: 0x583784b3dd2a372ae91519e872442d0e99d843an,
  r: -0x583784b3dd2a372ae91519e872442d0e99d843an
}, {
  a: 0x7943fe5n,
  r: -0x7943fe5n
}, {
  a: -0x47df6f80992b03826b9b4d28cc1301d479f9dd3c318n,
  r: 0x47df6f80992b03826b9b4d28cc1301d479f9dd3c318n
}, {
  a: -0x74740e43f8feb9562n,
  r: 0x74740e43f8feb9562n
}, {
  a: 0xae7a51e681d1df076d1cf6bc0fd186ea857f4d0b472f9923n,
  r: -0xae7a51e681d1df076d1cf6bc0fd186ea857f4d0b472f9923n
}, {
  a: -0x5ad4c1e7150a672444088e6bbbce4d3731d2765f714ffn,
  r: 0x5ad4c1e7150a672444088e6bbbce4d3731d2765f714ffn
}, {
  a: 0xd86a524459f80cabe61657b0n,
  r: -0xd86a524459f80cabe61657b0n
}, {
  a: 0xd19ba9c3d6n,
  r: -0xd19ba9c3d6n
}, {
  a: -0x10b3c37efd00e8ef925f1n,
  r: 0x10b3c37efd00e8ef925f1n
}, {
  a: -0xbf8eb11b34bd567d2a5b0n,
  r: 0xbf8eb11b34bd567d2a5b0n
}, {
  a: -0x3aba7832257342a1007ffb709a895aaan,
  r: 0x3aba7832257342a1007ffb709a895aaan
}, {
  a: 0x3dcf99f9f1b474e7719e1c8a8d22198bd37147f206da36068f983bcc0n,
  r: -0x3dcf99f9f1b474e7719e1c8a8d22198bd37147f206da36068f983bcc0n
}, {
  a: -0x4da8e766e85e46a8a92b07a838c16a0cff4209cf11d36444a080fd7fa16efa1n,
  r: 0x4da8e766e85e46a8a92b07a838c16a0cff4209cf11d36444a080fd7fa16efa1n
}, {
  a: -0x22eb351b502cf234f3bb77673c097ddd4ec5e652c1a24fe706d1b8n,
  r: 0x22eb351b502cf234f3bb77673c097ddd4ec5e652c1a24fe706d1b8n
}, {
  a: 0x1ca66b4ace82bb38ad1940ff57a416en,
  r: -0x1ca66b4ace82bb38ad1940ff57a416en
}, {
  a: -0x454f8d8d9680c1fcf0eefff420919bb3e3cc6e073d5c7e6fbc070fd1b927n,
  r: 0x454f8d8d9680c1fcf0eefff420919bb3e3cc6e073d5c7e6fbc070fd1b927n
}, {
  a: -0x886ea568ebee586e77c81c5f5c938ed2028b3d24113bdd51cf22ecb06bdcf28544c6n,
  r: 0x886ea568ebee586e77c81c5f5c938ed2028b3d24113bdd51cf22ecb06bdcf28544c6n
}, {
  a: 0xbn,
  r: -0xbn
}, {
  a: -0xae3c3269eae82bn,
  r: 0xae3c3269eae82bn
}, {
  a: 0x2b34d13d27ba47bn,
  r: -0x2b34d13d27ba47bn
}, {
  a: 0xd73bca496fb3c0869cn,
  r: -0xd73bca496fb3c0869cn
}, {
  a: 0x2eac6a1d6f3238bfd7n,
  r: -0x2eac6a1d6f3238bfd7n
}, {
  a: -0x7e3f16686335107d478d2ad9dcea7904c3ac944ad109fcn,
  r: 0x7e3f16686335107d478d2ad9dcea7904c3ac944ad109fcn
}, {
  a: -0x9276ccd2373ff81003dec910d1b9e5a79556fe07be35e7n,
  r: 0x9276ccd2373ff81003dec910d1b9e5a79556fe07be35e7n
}, {
  a: -0x1e114aab614en,
  r: 0x1e114aab614en
}, {
  a: 0x58d4a7624464ec99ae62dbaea7aaa583e5db1eccb50n,
  r: -0x58d4a7624464ec99ae62dbaea7aaa583e5db1eccb50n
}, {
  a: -0x64e33e6e2260219fa208f064463eae5a7an,
  r: 0x64e33e6e2260219fa208f064463eae5a7an
}, {
  a: -0xce47f5bdeb81b68a4725555634856026f4fb354030d457bc450525d9229ba58n,
  r: 0xce47f5bdeb81b68a4725555634856026f4fb354030d457bc450525d9229ba58n
}, {
  a: 0x180d5f4c41dba1449e38f725915c6d52c198f5322949f94152624d37f8cdbdf7bcb5cbn,
  r: -0x180d5f4c41dba1449e38f725915c6d52c198f5322949f94152624d37f8cdbdf7bcb5cbn
}, {
  a: 0xa1a0d26dc15ab79c388997b56d1571cb833aa8c66b9f2918c9ad086228feec0n,
  r: -0xa1a0d26dc15ab79c388997b56d1571cb833aa8c66b9f2918c9ad086228feec0n
}, {
  a: 0xfd6e1n,
  r: -0xfd6e1n
}, {
  a: -0x437bfd9076d224709f5e7e88dc19b41a1a5810a09n,
  r: 0x437bfd9076d224709f5e7e88dc19b41a1a5810a09n
}, {
  a: -0x2e1c6e199a209b0599n,
  r: 0x2e1c6e199a209b0599n
}, {
  a: -0xcdeae055c4a466c2a40cb1f80336bc380fb7d4d45e88dn,
  r: 0xcdeae055c4a466c2a40cb1f80336bc380fb7d4d45e88dn
}, {
  a: -0x90395cb159b8e17fa31490ade23f3bc022dddb4bcc981n,
  r: 0x90395cb159b8e17fa31490ade23f3bc022dddb4bcc981n
}, {
  a: 0xd849ae741f9f066a1463fb92c54bafed1701b62b54bafa83n,
  r: -0xd849ae741f9f066a1463fb92c54bafed1701b62b54bafa83n
}, {
  a: -0xf64603688cad5f5c8n,
  r: 0xf64603688cad5f5c8n
}, {
  a: -0x9309a3f5cb52add05a8ef69661144e8d480n,
  r: 0x9309a3f5cb52add05a8ef69661144e8d480n
}, {
  a: -0x7adn,
  r: 0x7adn
}, {
  a: 0x79f2d4338b4d98472d778be2dn,
  r: -0x79f2d4338b4d98472d778be2dn
}, {
  a: 0x1cc6120e58dn,
  r: -0x1cc6120e58dn
}, {
  a: 0x5e24cbe041c386ade875c0394600d61c63cccdn,
  r: -0x5e24cbe041c386ade875c0394600d61c63cccdn
}, {
  a: -0xbd58b8b92a999f74n,
  r: 0xbd58b8b92a999f74n
}, {
  a: -0xb11842acb3b5n,
  r: 0xb11842acb3b5n
}, {
  a: -0x2fde472b06e535806ed53n,
  r: 0x2fde472b06e535806ed53n
}, {
  a: -0x70ecbd0205dcf8e6n,
  r: 0x70ecbd0205dcf8e6n
}, {
  a: 0x5106ebd8737f69724a3d64e49cd17cbn,
  r: -0x5106ebd8737f69724a3d64e49cd17cbn
}, {
  a: 0xd216e771d3ef87e0c690fb47faaef8c42af5a93n,
  r: -0xd216e771d3ef87e0c690fb47faaef8c42af5a93n
}, {
  a: -0x5a4b0196899bbb66df8a762cbd9043945ca9c2180ae3ddeb5fdn,
  r: 0x5a4b0196899bbb66df8a762cbd9043945ca9c2180ae3ddeb5fdn
}, {
  a: -0x625f3d0e17283aan,
  r: 0x625f3d0e17283aan
}, {
  a: 0x4a812793440f36e69181c5a42561200cc14d24e4fc9b067016f457a4n,
  r: -0x4a812793440f36e69181c5a42561200cc14d24e4fc9b067016f457a4n
}, {
  a: -0xb20bc68b0655fn,
  r: 0xb20bc68b0655fn
}, {
  a: -0x5bn,
  r: 0x5bn
}, {
  a: -0xdb3641077970dfdecc2656946b0acb226e990044b5a45ce535b34d4d748ba6en,
  r: 0xdb3641077970dfdecc2656946b0acb226e990044b5a45ce535b34d4d748ba6en
}, {
  a: 0x189dn,
  r: -0x189dn
}, {
  a: 0x59137af715e7aabe00897aef6bc0c7998e0e84c442664dd6c5d1ee7n,
  r: -0x59137af715e7aabe00897aef6bc0c7998e0e84c442664dd6c5d1ee7n
}, {
  a: 0x36a54427d59143d56b3ca8fb30ee44c2b2n,
  r: -0x36a54427d59143d56b3ca8fb30ee44c2b2n
}, {
  a: 0x9d724d0aa32e47fa978cb0505fab89a510d1e7ed29a76cd6450d04b438b0n,
  r: -0x9d724d0aa32e47fa978cb0505fab89a510d1e7ed29a76cd6450d04b438b0n
}, {
  a: -0x8ce5599705ca1f38a79f52eb5bd653b6cf728569e41ee9da2fc8890n,
  r: 0x8ce5599705ca1f38a79f52eb5bd653b6cf728569e41ee9da2fc8890n
}, {
  a: -0x924efe339bbed9n,
  r: 0x924efe339bbed9n
}, {
  a: -0xed62d077121f2b8a1c9255417ban,
  r: 0xed62d077121f2b8a1c9255417ban
}, {
  a: 0n,
  r: 0n
}, {
  a: -0xabe0c4170cb6148805d8b4ef8ac7b3355e42e0ab9291375n,
  r: 0xabe0c4170cb6148805d8b4ef8ac7b3355e42e0ab9291375n
}, {
  a: 0xc4e1167d3f406079a52a435f8128448368d011bfb423b5dc9n,
  r: -0xc4e1167d3f406079a52a435f8128448368d011bfb423b5dc9n
}, {
  a: 0xcd4ddfb881ba8da2264d2abf4160afn,
  r: -0xcd4ddfb881ba8da2264d2abf4160afn
}, {
  a: 0xac5d9c6a4d8d7643265b84a315ba135d852e438865870fben,
  r: -0xac5d9c6a4d8d7643265b84a315ba135d852e438865870fben
}, {
  a: -0xabacd1d1cdba2f7cb5132bac243cd1cc870a4d456a51an,
  r: 0xabacd1d1cdba2f7cb5132bac243cd1cc870a4d456a51an
}, {
  a: 0xfe929d91d1e9f8e8629c046e2ad9441f436ca3d807353abddeeb659abe6006n,
  r: -0xfe929d91d1e9f8e8629c046e2ad9441f436ca3d807353abddeeb659abe6006n
}, {
  a: 0x458316d5bde97f71580bcfe58d6acn,
  r: -0x458316d5bde97f71580bcfe58d6acn
}, {
  a: -0xe65n,
  r: 0xe65n
}, {
  a: 0xad9b4a5e4a110bc59259cb6a11e62bf540275f2b4b3ae79da47a724f6bcn,
  r: -0xad9b4a5e4a110bc59259cb6a11e62bf540275f2b4b3ae79da47a724f6bcn
}, {
  a: 0n,
  r: 0n
}, {
  a: -0x312d7745c5a317b514c49db03bc83014624e2n,
  r: 0x312d7745c5a317b514c49db03bc83014624e2n
}, {
  a: -0xa909b4e630e0f0b2018ceb8353879a65dae11077ff6d3dc4n,
  r: 0xa909b4e630e0f0b2018ceb8353879a65dae11077ff6d3dc4n
}, {
  a: 0xd529d360103bd5b0b2cd4a4103d5317312f5babf37a0fee6559fac4e5cf450fn,
  r: -0xd529d360103bd5b0b2cd4a4103d5317312f5babf37a0fee6559fac4e5cf450fn
}, {
  a: -0x652n,
  r: 0x652n
}, {
  a: 0xdn,
  r: -0xdn
}, {
  a: 0xe25189231566a3803f027d6f5cb86cbdd45bbb2dfbn,
  r: -0xe25189231566a3803f027d6f5cb86cbdd45bbb2dfbn
}, {
  a: 0xaad68a1a17bb8507251a8e612c11301313d9n,
  r: -0xaad68a1a17bb8507251a8e612c11301313d9n
}, {
  a: -0x563ed3aef0c54dd5e06210172145n,
  r: 0x563ed3aef0c54dd5e06210172145n
}, {
  a: -0x3b2a811657dd449cf2b4ceb4301f1aaan,
  r: 0x3b2a811657dd449cf2b4ceb4301f1aaan
}, {
  a: -0xcf7d8e25605bfan,
  r: 0xcf7d8e25605bfan
}, {
  a: -0x7a79fc6bb1244c11c31988fb7a158f98b412bban,
  r: 0x7a79fc6bb1244c11c31988fb7a158f98b412bban
}, {
  a: -0xb650f400ba4e6c39a4a6an,
  r: 0xb650f400ba4e6c39a4a6an
}, {
  a: -0x7f330faffda9dc2219e99f5d36376b78abe606e015ad043f0e921fe2c1fda8b587d53n,
  r: 0x7f330faffda9dc2219e99f5d36376b78abe606e015ad043f0e921fe2c1fda8b587d53n
}, {
  a: -0xdd56fdc06898an,
  r: 0xdd56fdc06898an
}, {
  a: 0xf2800bf7e8a71f3a0c665ca060edab58f78156e69622c700636cfab00en,
  r: -0xf2800bf7e8a71f3a0c665ca060edab58f78156e69622c700636cfab00en
}, {
  a: 0x5fd900c9ffcdn,
  r: -0x5fd900c9ffcdn
}, {
  a: 0xa98476349100da41ac0f2707242e325b469986d4e56e8b4742df12bcf88188a36fn,
  r: -0xa98476349100da41ac0f2707242e325b469986d4e56e8b4742df12bcf88188a36fn
}, {
  a: -0xb6069e13ff76f66c2920e342ba97a766843ebb5n,
  r: 0xb6069e13ff76f66c2920e342ba97a766843ebb5n
}, {
  a: 0xff07be33300927e517627061d4n,
  r: -0xff07be33300927e517627061d4n
}, {
  a: 0x53ca78c973f9e991e8ab12087c62b0ed633cb7dbb266fe5a8f8a776d098321d0e5bn,
  r: -0x53ca78c973f9e991e8ab12087c62b0ed633cb7dbb266fe5a8f8a776d098321d0e5bn
}, {
  a: -0x19f06309871058a5149c85a1f60591847c98c129809f2701410aa6a014c006dn,
  r: 0x19f06309871058a5149c85a1f60591847c98c129809f2701410aa6a014c006dn
}, {
  a: 0x15b8690ccn,
  r: -0x15b8690ccn
}, {
  a: 0x6361n,
  r: -0x6361n
}, {
  a: 0xacef2a8bd8ec353219787c3e7c7524b0b0a25n,
  r: -0xacef2a8bd8ec353219787c3e7c7524b0b0a25n
}, {
  a: 0x3970cc905cb12b12cb71cbd65n,
  r: -0x3970cc905cb12b12cb71cbd65n
}, {
  a: 0x56b1d750aa330551644444f917908c2b9n,
  r: -0x56b1d750aa330551644444f917908c2b9n
}, {
  a: -0xd0285c1a11n,
  r: 0xd0285c1a11n
}, {
  a: 0x5d12664b0bec4ed7e5b3f5cc56c0e431a7ea6052bb392b06c659n,
  r: -0x5d12664b0bec4ed7e5b3f5cc56c0e431a7ea6052bb392b06c659n
}, {
  a: -0x8efa7013cccfd843e74e1b6f4935c323dc506145c4735fa78d38a0688c6n,
  r: 0x8efa7013cccfd843e74e1b6f4935c323dc506145c4735fa78d38a0688c6n
}, {
  a: -0xf08ee2b5bb1e116d63f019a47dbe6b91e009e0e52149c6242f02f289d51n,
  r: 0xf08ee2b5bb1e116d63f019a47dbe6b91e009e0e52149c6242f02f289d51n
}, {
  a: 0x44a4792c0f6a187a1fd1d788f7ec062819b715fe6n,
  r: -0x44a4792c0f6a187a1fd1d788f7ec062819b715fe6n
}, {
  a: 0x47527f883fa2a4bb3a457a9b1245313b858b2d39bf8ebddc4d56e90e39ff7f77c4f7fn,
  r: -0x47527f883fa2a4bb3a457a9b1245313b858b2d39bf8ebddc4d56e90e39ff7f77c4f7fn
}, {
  a: -0x1a61887e465041c370c66dn,
  r: 0x1a61887e465041c370c66dn
}, {
  a: -0x4026768acan,
  r: 0x4026768acan
}, {
  a: 0xbfddf0e3c308ac5734a4faed624n,
  r: -0xbfddf0e3c308ac5734a4faed624n
}, {
  a: -0xa828ef5b036b0f2d4c3e52c33a1beff82b0301937n,
  r: 0xa828ef5b036b0f2d4c3e52c33a1beff82b0301937n
}, {
  a: -0xb61d970f438020ee969c4a1396e1f92ab79b0en,
  r: 0xb61d970f438020ee969c4a1396e1f92ab79b0en
}, {
  a: -0x230ef82d29b2fdba67e70351f4a0a7c5febb760e70c6de19bda18a0739809037bb50fen,
  r: 0x230ef82d29b2fdba67e70351f4a0a7c5febb760e70c6de19bda18a0739809037bb50fen
}, {
  a: 0x9b1dfc224af725bdee2b24e3112e134783c23b31e19dn,
  r: -0x9b1dfc224af725bdee2b24e3112e134783c23b31e19dn
}, {
  a: 0xd315fa6c829975c97de961a3f3n,
  r: -0xd315fa6c829975c97de961a3f3n
}, {
  a: 0x2ff32d0def350a8ecd5e858d4d556bcn,
  r: -0x2ff32d0def350a8ecd5e858d4d556bcn
}, {
  a: 0xaa035bf3b61f4233e49c87670df929a90e1b762bcffn,
  r: -0xaa035bf3b61f4233e49c87670df929a90e1b762bcffn
}, {
  a: -0xdd034bc3ffc7e8b0fdb2ac0338bdc3fn,
  r: 0xdd034bc3ffc7e8b0fdb2ac0338bdc3fn
}, {
  a: -0x875b8ec556c434073fa4c2f35db4a9f751335f1a69bbe9n,
  r: 0x875b8ec556c434073fa4c2f35db4a9f751335f1a69bbe9n
}, {
  a: -0x3a0294893e572fa7aa73b4e5d7e5cd446951fe45032324b769c5370n,
  r: 0x3a0294893e572fa7aa73b4e5d7e5cd446951fe45032324b769c5370n
}, {
  a: -0xe8cf2a4ed4b161cb73c9fn,
  r: 0xe8cf2a4ed4b161cb73c9fn
}, {
  a: -0x5f040d2b18d98d74116948f357n,
  r: 0x5f040d2b18d98d74116948f357n
}, {
  a: -0x41n,
  r: 0x41n
}, {
  a: -0xe43e56c6d67745dfd10281fda7cdbdb54a81a30b5580056fe1ff6a53ecden,
  r: 0xe43e56c6d67745dfd10281fda7cdbdb54a81a30b5580056fe1ff6a53ecden
}, {
  a: 0x89ed419d1f48306b574aeec4742ca72855cdaf5a88f2e2d1b3072f9dan,
  r: -0x89ed419d1f48306b574aeec4742ca72855cdaf5a88f2e2d1b3072f9dan
}, {
  a: 0x3an,
  r: -0x3an
}, {
  a: 0xef31cdaa98ef23ed64386n,
  r: -0xef31cdaa98ef23ed64386n
}, {
  a: -0xe4397c2dbac14f5d64cec3a3a0b137cf4d932180e0cn,
  r: 0xe4397c2dbac14f5d64cec3a3a0b137cf4d932180e0cn
}, {
  a: -0xba01a4314a34fac9bfd19218b4723d5n,
  r: 0xba01a4314a34fac9bfd19218b4723d5n
}, {
  a: -0x3898c0127c4c54015d0a50f7a9e5aa8bed401b61cd474e5n,
  r: 0x3898c0127c4c54015d0a50f7a9e5aa8bed401b61cd474e5n
}, {
  a: 0xbcb1c6b9bb493b555aeff4n,
  r: -0xbcb1c6b9bb493b555aeff4n
}, {
  a: -0xaef5ab1b84c5e0293396438e6e96b48ba3b7f67f775124n,
  r: 0xaef5ab1b84c5e0293396438e6e96b48ba3b7f67f775124n
}, {
  a: -0x899eb8a101n,
  r: 0x899eb8a101n
}, {
  a: 0x680d51an,
  r: -0x680d51an
}, {
  a: -0x33a96e2ee6a00c5f4c73dc467a19d60d96d29eb75b3081n,
  r: 0x33a96e2ee6a00c5f4c73dc467a19d60d96d29eb75b3081n
}, {
  a: 0x736dbaf4832f00ac7dn,
  r: -0x736dbaf4832f00ac7dn
}, {
  a: 0xe75f7a2c9c90d966385c9ce8793221f3378ed2d8de502aan,
  r: -0xe75f7a2c9c90d966385c9ce8793221f3378ed2d8de502aan
}, {
  a: -0xe45b7e5971765c48658dn,
  r: 0xe45b7e5971765c48658dn
}, {
  a: 0x3c239fa56680n,
  r: -0x3c239fa56680n
}, {
  a: -0x5bfcce5d69a8n,
  r: 0x5bfcce5d69a8n
}, {
  a: -0xabb130720f00107n,
  r: 0xabb130720f00107n
}, {
  a: 0x4612139e97bf9bf93c37ad2ac09a1b3en,
  r: -0x4612139e97bf9bf93c37ad2ac09a1b3en
}, {
  a: -0x5ae285cb0903762f8fc5697n,
  r: 0x5ae285cb0903762f8fc5697n
}, {
  a: -0xd106d9a81f854a41a701b35396513bn,
  r: 0xd106d9a81f854a41a701b35396513bn
}, {
  a: 0x1c5eb64d05a184fd30568e44e63n,
  r: -0x1c5eb64d05a184fd30568e44e63n
}, {
  a: -0x2f3bdbeae17416ce170aeaec3019f9b6eabdcbec0353d1d709c9n,
  r: 0x2f3bdbeae17416ce170aeaec3019f9b6eabdcbec0353d1d709c9n
}, {
  a: -0xd11df02ba93b4n,
  r: 0xd11df02ba93b4n
}, {
  a: -0xbabed4c7017a0e09b61a79a6327677b0c916c41e37b3553c6cc857ff803760322n,
  r: 0xbabed4c7017a0e09b61a79a6327677b0c916c41e37b3553c6cc857ff803760322n
}, {
  a: -0x7d517773015b25a6a2e85641d58a48c6c92eef33033681666f0n,
  r: 0x7d517773015b25a6a2e85641d58a48c6c92eef33033681666f0n
}, {
  a: 0x5384167258f9a70bd367d98b3ac7d30bb690c3a30b43f0468ea82b3n,
  r: -0x5384167258f9a70bd367d98b3ac7d30bb690c3a30b43f0468ea82b3n
}, {
  a: -0x6f134b40a090205f0e3faa0fc5e2d018bfa7715827bn,
  r: 0x6f134b40a090205f0e3faa0fc5e2d018bfa7715827bn
}, {
  a: -0x352e9cc4dfc55516431ff5e931de4bc9298d5b9c05fc614n,
  r: 0x352e9cc4dfc55516431ff5e931de4bc9298d5b9c05fc614n
}, {
  a: -0xf67d9cd9cfc2n,
  r: 0xf67d9cd9cfc2n
}, {
  a: 0x8852728923f6273b34bn,
  r: -0x8852728923f6273b34bn
}, {
  a: 0x256641e018df8c60n,
  r: -0x256641e018df8c60n
}, {
  a: 0xfcae33a50cbc01f27f86911a18ben,
  r: -0xfcae33a50cbc01f27f86911a18ben
}, {
  a: 0x52f258d8af05882cf11791270c85ce6aa0505n,
  r: -0x52f258d8af05882cf11791270c85ce6aa0505n
}, {
  a: -0xec3f8c134451a559fb7d444a05d23cb22a206c7533441an,
  r: 0xec3f8c134451a559fb7d444a05d23cb22a206c7533441an
}, {
  a: 0xa58b058717f21c953b46cc7f2e2c7443a584a549bn,
  r: -0xa58b058717f21c953b46cc7f2e2c7443a584a549bn
}, {
  a: 0xe776306c6155e0a49d79005e31e381aa13509e292a89n,
  r: -0xe776306c6155e0a49d79005e31e381aa13509e292a89n
}, {
  a: -0xede63433d4141261d599b610243045479915d0a84e95510101bn,
  r: 0xede63433d4141261d599b610243045479915d0a84e95510101bn
}, {
  a: -0xfd7826a7d55b5d1cda77ff1beba0cc01b5d170cd21n,
  r: 0xfd7826a7d55b5d1cda77ff1beba0cc01b5d170cd21n
}, {
  a: 0x1438d0abd162d8253ac89efb184d5c6f2042a3e9ae9b5e809bbfdf09041an,
  r: -0x1438d0abd162d8253ac89efb184d5c6f2042a3e9ae9b5e809bbfdf09041an
}, {
  a: -0x358e120235d8a096n,
  r: 0x358e120235d8a096n
}, {
  a: 0xd042222fd94c0c560b6b15dfa7995fn,
  r: -0xd042222fd94c0c560b6b15dfa7995fn
}, {
  a: -0xdb3b864c0b07d8f66c0f7176dcbfe4f220b58d4dce93b339aab7n,
  r: 0xdb3b864c0b07d8f66c0f7176dcbfe4f220b58d4dce93b339aab7n
}, {
  a: -0xf5d4dd64e3a23407b0f4b505n,
  r: 0xf5d4dd64e3a23407b0f4b505n
}, {
  a: -0xc149b733cfcfc9a74f23e92d174f98n,
  r: 0xc149b733cfcfc9a74f23e92d174f98n
}, {
  a: 0x936789ed18c5b7a60923e9ea88e3e27n,
  r: -0x936789ed18c5b7a60923e9ea88e3e27n
}, {
  a: -0x27e56b98dff16102929n,
  r: 0x27e56b98dff16102929n
}, {
  a: -0x4a471d72a05baf83df0db47152e4a6fn,
  r: 0x4a471d72a05baf83df0db47152e4a6fn
}, {
  a: -0x272n,
  r: 0x272n
}, {
  a: -0x71684cc776ee6f8e1270f9b13d6f968650133fe9b0d168e208b1b58c9860980336404n,
  r: 0x71684cc776ee6f8e1270f9b13d6f968650133fe9b0d168e208b1b58c9860980336404n
}, {
  a: -0xc9f2e7c6180b6a75b35ffac9b21e48f71984381fa76af7n,
  r: 0xc9f2e7c6180b6a75b35ffac9b21e48f71984381fa76af7n
}, {
  a: -0xba1a16d75c1ed227675d98c91c16d1831b8bffb0995023en,
  r: 0xba1a16d75c1ed227675d98c91c16d1831b8bffb0995023en
}, {
  a: -0xb9ddf78e63e6d40cc3932n,
  r: 0xb9ddf78e63e6d40cc3932n
}, {
  a: -0x6a7152e2ea5bb5474b336a7bf2c2360dbff0caeebn,
  r: 0x6a7152e2ea5bb5474b336a7bf2c2360dbff0caeebn
}, {
  a: -0xab4fbb6720f9dd2a8439261a2820c65e9af957d9710e2deff2ca949n,
  r: 0xab4fbb6720f9dd2a8439261a2820c65e9af957d9710e2deff2ca949n
}, {
  a: 0x6a47b9180955194e610beb7c9f16a857f288415710c1629010545f1n,
  r: -0x6a47b9180955194e610beb7c9f16a857f288415710c1629010545f1n
}, {
  a: -0x824cd2d3a8f0bb3e6c5dn,
  r: 0x824cd2d3a8f0bb3e6c5dn
}, {
  a: -0x860bd5845db9f9a874e78f3dca1426a5ca1600d0d1cb41n,
  r: 0x860bd5845db9f9a874e78f3dca1426a5ca1600d0d1cb41n
}, {
  a: -0x97e4d6564e9b52cd9b625f6b94492c9f2d528c2eb2b1a9b76becn,
  r: 0x97e4d6564e9b52cd9b625f6b94492c9f2d528c2eb2b1a9b76becn
}, {
  a: -0x89ea3dd49107f58bb3d4d3725a3be9ac86995b9d7ad38401ec29dn,
  r: 0x89ea3dd49107f58bb3d4d3725a3be9ac86995b9d7ad38401ec29dn
}, {
  a: -0xd97543c3bb03ba65db845558e660b7a5dc2eb0eb4df17794567b1c698ee3377n,
  r: 0xd97543c3bb03ba65db845558e660b7a5dc2eb0eb4df17794567b1c698ee3377n
}, {
  a: -0x21b8ad9aed5d41de46f7a5844dbb1b9c0f3d63aa8906eeabd422n,
  r: 0x21b8ad9aed5d41de46f7a5844dbb1b9c0f3d63aa8906eeabd422n
}, {
  a: 0x93c4c69dc7a3529a19198ce619b929292c397966bn,
  r: -0x93c4c69dc7a3529a19198ce619b929292c397966bn
}, {
  a: 0x333b3f107abd94e2a672300c7a83883620af9efaded701905c5d0b5d6ba71fn,
  r: -0x333b3f107abd94e2a672300c7a83883620af9efaded701905c5d0b5d6ba71fn
}, {
  a: -0x35ceddb636da96a4ad5d21c39880593d1n,
  r: 0x35ceddb636da96a4ad5d21c39880593d1n
}, {
  a: -0xe8badf15fd063a0377f57686280ef77d3f4d8f0e12cdn,
  r: 0xe8badf15fd063a0377f57686280ef77d3f4d8f0e12cdn
}, {
  a: 0x512f2f331ee9774dce1f4a8efbd47b8caf0d95adad5f3d58fn,
  r: -0x512f2f331ee9774dce1f4a8efbd47b8caf0d95adad5f3d58fn
}, {
  a: 0xba4aad6eb521a38n,
  r: -0xba4aad6eb521a38n
}, {
  a: 0x8a60595bc5f1b63a91n,
  r: -0x8a60595bc5f1b63a91n
}, {
  a: 0x44c514f3adn,
  r: -0x44c514f3adn
}, {
  a: 0xd4a479f6bebn,
  r: -0xd4a479f6bebn
}, {
  a: 0x94d7849fdaan,
  r: -0x94d7849fdaan
}, {
  a: 0xdcd0c62e4cf1faa41c2e54477f55df1944e1f5479017ccfn,
  r: -0xdcd0c62e4cf1faa41c2e54477f55df1944e1f5479017ccfn
}, {
  a: -0xb762ac589945cb3fn,
  r: 0xb762ac589945cb3fn
}, {
  a: -0x30a2686178c2a861f06ab0755977d9ebe7ad5n,
  r: 0x30a2686178c2a861f06ab0755977d9ebe7ad5n
}, {
  a: 0x3472ad367f1510417ce381a909ce0a98df1844148eaeaeca25429d7582ff817een,
  r: -0x3472ad367f1510417ce381a909ce0a98df1844148eaeaeca25429d7582ff817een
}, {
  a: 0xc86bb0f74632n,
  r: -0xc86bb0f74632n
}, {
  a: 0x68f816bb5853a8e58d115ccda4ec3ee5de88f2ba4aada2570d978c55a409de48c0n,
  r: -0x68f816bb5853a8e58d115ccda4ec3ee5de88f2ba4aada2570d978c55a409de48c0n
}, {
  a: -0xefcd8a066a6959bcc2db0f9dc1cef8140a45ff46ea16f1d1dd00b1443742bcn,
  r: 0xefcd8a066a6959bcc2db0f9dc1cef8140a45ff46ea16f1d1dd00b1443742bcn
}, {
  a: 0xee2c7n,
  r: -0xee2c7n
}, {
  a: -0x83772401a4f4bdae50139d693b5en,
  r: 0x83772401a4f4bdae50139d693b5en
}, {
  a: -0xc7188ecf0c1ad567bf16549e256b63aa01ee574c991n,
  r: 0xc7188ecf0c1ad567bf16549e256b63aa01ee574c991n
}, {
  a: -0xa872f55241036fb1e3f9a25dad6aea1868cc5032a35760ce533a7308249cn,
  r: 0xa872f55241036fb1e3f9a25dad6aea1868cc5032a35760ce533a7308249cn
}, {
  a: -0xc56cff51bd2a5e58e32ec0fn,
  r: 0xc56cff51bd2a5e58e32ec0fn
}, {
  a: 0xeab040eb7e48cba3bbbe45c5f954cn,
  r: -0xeab040eb7e48cba3bbbe45c5f954cn
}, {
  a: 0x255229b78dac32c4c3816681b87835cdfec703f729bfdee830ca8f82a64ed6ac8d33n,
  r: -0x255229b78dac32c4c3816681b87835cdfec703f729bfdee830ca8f82a64ed6ac8d33n
}, {
  a: -0x249b8a3028f713a262e0f17df98244c8n,
  r: 0x249b8a3028f713a262e0f17df98244c8n
}, {
  a: 0xd400f8ac3f074ae63698a31ae94b4c13a9b8d063021fd025e8n,
  r: -0xd400f8ac3f074ae63698a31ae94b4c13a9b8d063021fd025e8n
}, {
  a: 0x140aa865673b1048e0a6aa09b0f700cf2a05c04e58ea10f5b963d9bba35n,
  r: -0x140aa865673b1048e0a6aa09b0f700cf2a05c04e58ea10f5b963d9bba35n
}, {
  a: 0x24626833859a7b0742d60c6bc771dcdb19ce19e6a628f9b7b687ec05fb3655a6d155n,
  r: -0x24626833859a7b0742d60c6bc771dcdb19ce19e6a628f9b7b687ec05fb3655a6d155n
}, {
  a: -0x750e2bn,
  r: 0x750e2bn
}, {
  a: 0x653497833197f2635d0b4ea244809876n,
  r: -0x653497833197f2635d0b4ea244809876n
}, {
  a: 0x85e0aa665fdbcf5835037n,
  r: -0x85e0aa665fdbcf5835037n
}, {
  a: 0x306e0220407n,
  r: -0x306e0220407n
}, {
  a: 0xac5fea83f26f7cf86400b530b57f82f313ab701c50c81276n,
  r: -0xac5fea83f26f7cf86400b530b57f82f313ab701c50c81276n
}, {
  a: -0x5d9db3535cb07d2ad3c58f7cdc9458d07cbe97d0700f598c7cn,
  r: 0x5d9db3535cb07d2ad3c58f7cdc9458d07cbe97d0700f598c7cn
}, {
  a: 0xc4ad14303e0746b51c9b27bd6420f0d51346ean,
  r: -0xc4ad14303e0746b51c9b27bd6420f0d51346ean
}, {
  a: -0xe7d52772ebec42978fbcc37931e6859n,
  r: 0xe7d52772ebec42978fbcc37931e6859n
}, {
  a: -0xcdb6bf648b3c65435c03en,
  r: 0xcdb6bf648b3c65435c03en
}, {
  a: -0xbaf39b9d3b1c9ebc5650f7d099e7n,
  r: 0xbaf39b9d3b1c9ebc5650f7d099e7n
}, {
  a: 0x9d5580710f81848706d1d15df3f26bd45afan,
  r: -0x9d5580710f81848706d1d15df3f26bd45afan
}, {
  a: -0xc456b7db6268cd5541a33996e07ac4287af577918369cn,
  r: 0xc456b7db6268cd5541a33996e07ac4287af577918369cn
}, {
  a: -0x4d469790c8f143b175bc0a17d2251bbfb9n,
  r: 0x4d469790c8f143b175bc0a17d2251bbfb9n
}, {
  a: -0xc818e52bae941e99bc57202bc7980a9ab1dd6365016eb628b52b134ed86f17n,
  r: 0xc818e52bae941e99bc57202bc7980a9ab1dd6365016eb628b52b134ed86f17n
}, {
  a: -0xcc94fa6a586d5eeb8e61564b037cc75916a06c8728b0720cea5cd2d7a25d3d8868n,
  r: 0xcc94fa6a586d5eeb8e61564b037cc75916a06c8728b0720cea5cd2d7a25d3d8868n
}, {
  a: 0x8253637039d0ed0fa5c3d85c7e63b819471efb8d223221a7527n,
  r: -0x8253637039d0ed0fa5c3d85c7e63b819471efb8d223221a7527n
}, {
  a: -0xa1b5e202f033a7fb1b196ce5ba187c30e5d2n,
  r: 0xa1b5e202f033a7fb1b196ce5ba187c30e5d2n
}, {
  a: -0x8f4fa8f7439bfdbe9faa81c9b203a5aan,
  r: 0x8f4fa8f7439bfdbe9faa81c9b203a5aan
}, {
  a: 0x7977c654e95c812f2d4f9debec4ae3fec8d90ea4642d4n,
  r: -0x7977c654e95c812f2d4f9debec4ae3fec8d90ea4642d4n
}, {
  a: -0x7b7n,
  r: 0x7b7n
}, {
  a: -0x232dfn,
  r: 0x232dfn
}, {
  a: -0xb70bf35dce71b5fb67997ad068d47fededdfcd8241ab53f1cbe6f5d4n,
  r: 0xb70bf35dce71b5fb67997ad068d47fededdfcd8241ab53f1cbe6f5d4n
}, {
  a: 0x5f6b59a8d3a7eed58ce1f7816296ef05fn,
  r: -0x5f6b59a8d3a7eed58ce1f7816296ef05fn
}, {
  a: -0x99a13e7de859f1655e731b1ea9a78572ca2318e9777ffcf8a6e5bbe1f0n,
  r: 0x99a13e7de859f1655e731b1ea9a78572ca2318e9777ffcf8a6e5bbe1f0n
}, {
  a: 0xb1f8651d2cc6fcf8c63222c8121a271b50753c0dd80cn,
  r: -0xb1f8651d2cc6fcf8c63222c8121a271b50753c0dd80cn
}, {
  a: -0xee563cbae6d63d5226efb17bc512d16540f825636aa8d78d20332cb15f55098afbn,
  r: 0xee563cbae6d63d5226efb17bc512d16540f825636aa8d78d20332cb15f55098afbn
}, {
  a: 0xa4b3n,
  r: -0xa4b3n
}, {
  a: -0xea69f13c2f30906de2c5e856f468932en,
  r: 0xea69f13c2f30906de2c5e856f468932en
}, {
  a: -0xb2a274422a8715dd613b5c8d3cd0ff529n,
  r: 0xb2a274422a8715dd613b5c8d3cd0ff529n
}, {
  a: -0x34ac9cc647c403n,
  r: 0x34ac9cc647c403n
}, {
  a: -0x6f93676b1071277fe22f327c663233af29e9509n,
  r: 0x6f93676b1071277fe22f327c663233af29e9509n
}, {
  a: 0x4b406bd91672e147f4f495da84c857a585c966504e26n,
  r: -0x4b406bd91672e147f4f495da84c857a585c966504e26n
}, {
  a: -0x992702ac820883172bae7568df9cccc778c44161bcda326b4b3c04dfe4ce3288480n,
  r: 0x992702ac820883172bae7568df9cccc778c44161bcda326b4b3c04dfe4ce3288480n
}, {
  a: -0x844n,
  r: 0x844n
}, {
  a: -0x55f91e021a2299b75f1a983a318b63917df7d25eb3ec44392n,
  r: 0x55f91e021a2299b75f1a983a318b63917df7d25eb3ec44392n
}, {
  a: 0xb03ed7f32009324e690b0a2d01f0n,
  r: -0xb03ed7f32009324e690b0a2d01f0n
}, {
  a: 0xe0e5300d54e3f01702c59421b51da52225182d2a62ce82edc8a9ba8an,
  r: -0xe0e5300d54e3f01702c59421b51da52225182d2a62ce82edc8a9ba8an
}, {
  a: 0xbcb93bae307aac7b74c5346306561b3456dc9269159a5f57740827dce63fn,
  r: -0xbcb93bae307aac7b74c5346306561b3456dc9269159a5f57740827dce63fn
}, {
  a: 0n,
  r: 0n
}, {
  a: 0x3c1f6cf12f5f4b22dc55f1d886ec657cf490n,
  r: -0x3c1f6cf12f5f4b22dc55f1d886ec657cf490n
}, {
  a: -0xdde28d87f053ae71c193c0dfcd432n,
  r: 0xdde28d87f053ae71c193c0dfcd432n
}, {
  a: -0x85762f874534f25830dceadd7cn,
  r: 0x85762f874534f25830dceadd7cn
}, {
  a: -0x923fc36e8633a1c03cc616461301n,
  r: 0x923fc36e8633a1c03cc616461301n
}, {
  a: 0x9ee57b2ee34d7fc51d03829fe8982f6ae3b371c89a9f1153en,
  r: -0x9ee57b2ee34d7fc51d03829fe8982f6ae3b371c89a9f1153en
}, {
  a: -0x39ddfe2142eab54100c2c8ea68c274a5a261fc2n,
  r: 0x39ddfe2142eab54100c2c8ea68c274a5a261fc2n
}, {
  a: -0x49f3733f9e4n,
  r: 0x49f3733f9e4n
}, {
  a: 0xe81a639cd2e8bb80cc6c8262bfb5cdddn,
  r: -0xe81a639cd2e8bb80cc6c8262bfb5cdddn
}, {
  a: 0xa70322236598677ca2340b4dcb542acf9d9a33b905n,
  r: -0xa70322236598677ca2340b4dcb542acf9d9a33b905n
}, {
  a: -0xa0567d6n,
  r: 0xa0567d6n
}, {
  a: 0xf6fded97d1506176e77536n,
  r: -0xf6fded97d1506176e77536n
}, {
  a: 0x85eb8bd35e1e12d8b5c0fee601fea3bd2f7f069354f67f15711490404dn,
  r: -0x85eb8bd35e1e12d8b5c0fee601fea3bd2f7f069354f67f15711490404dn
}, {
  a: -0xcn,
  r: 0xcn
}, {
  a: -0x7b3d10b444befa054853940fd930765a6deb0021a56d76e72e9a383de7ab20a2fn,
  r: 0x7b3d10b444befa054853940fd930765a6deb0021a56d76e72e9a383de7ab20a2fn
}, {
  a: -0x7a768a5620876d20fd8bbbcb009cb443dn,
  r: 0x7a768a5620876d20fd8bbbcb009cb443dn
}, {
  a: -0x73544457f4313054935f5a384a8fen,
  r: 0x73544457f4313054935f5a384a8fen
}, {
  a: -0x4d42f262504ce0153ce3e5f2d6a77bn,
  r: 0x4d42f262504ce0153ce3e5f2d6a77bn
}, {
  a: -0xcf65c8e04b0584be953df7a7aafb6df58002bf1a9544b7149fec341en,
  r: 0xcf65c8e04b0584be953df7a7aafb6df58002bf1a9544b7149fec341en
}, {
  a: 0xb96bffef0916b183fe94e9307f212f19763c4d076b7aef593ab9a0390bde39e35n,
  r: -0xb96bffef0916b183fe94e9307f212f19763c4d076b7aef593ab9a0390bde39e35n
}, {
  a: 0x396b141fd208e2273cafd586c3979n,
  r: -0x396b141fd208e2273cafd586c3979n
}, {
  a: -0xa15a3e01b790630e89ff48506d4c18d71298n,
  r: 0xa15a3e01b790630e89ff48506d4c18d71298n
}, {
  a: -0xd85d1499bad7831d9126d0672d81afd64c1n,
  r: 0xd85d1499bad7831d9126d0672d81afd64c1n
}, {
  a: 0x22bd51b700396aa490ec0c3a631b149f7a4714d5165e2f6cc39317aad177951bn,
  r: -0x22bd51b700396aa490ec0c3a631b149f7a4714d5165e2f6cc39317aad177951bn
}, {
  a: 0x2a8c7cc8fc6336n,
  r: -0x2a8c7cc8fc6336n
}, {
  a: 0xebe97c7753ed1cn,
  r: -0xebe97c7753ed1cn
}, {
  a: -0xb22e4838fdf3e54eb23228615c36a6n,
  r: 0xb22e4838fdf3e54eb23228615c36a6n
}, {
  a: 0xfd98af987753f545ccdb79512402ba05n,
  r: -0xfd98af987753f545ccdb79512402ba05n
}, {
  a: 0xccd6a4d427f2e07ce0650n,
  r: -0xccd6a4d427f2e07ce0650n
}, {
  a: 0xf008d8c3060d8158668f9ec5a83bn,
  r: -0xf008d8c3060d8158668f9ec5a83bn
}, {
  a: -0x2bace7c73d1fdd81f90a7b813ae6bn,
  r: 0x2bace7c73d1fdd81f90a7b813ae6bn
}, {
  a: 0x8dda4f383458f57b8619f646f3ddffd5a5ac481dad8f42648d18e3ac7a271592a159an,
  r: -0x8dda4f383458f57b8619f646f3ddffd5a5ac481dad8f42648d18e3ac7a271592a159an
}, {
  a: -0xa8cfebca4713e11c21fdcec271241fa508c05c56ab6e32633ab6abfn,
  r: 0xa8cfebca4713e11c21fdcec271241fa508c05c56ab6e32633ab6abfn
}, {
  a: 0x95e34b853391n,
  r: -0x95e34b853391n
}, {
  a: -0xa9967d85b78601096e4647d47570f745b2e75073807c1a02c3ec4n,
  r: 0xa9967d85b78601096e4647d47570f745b2e75073807c1a02c3ec4n
}, {
  a: 0x23c0d1dae818ce8ce9f65284f69c06ecfc0c85n,
  r: -0x23c0d1dae818ce8ce9f65284f69c06ecfc0c85n
}, {
  a: 0x1f45eeb55e10cabn,
  r: -0x1f45eeb55e10cabn
}, {
  a: 0xdbafd26cf06ca72c4cd7b2655d58c8daf6cb54f2n,
  r: -0xdbafd26cf06ca72c4cd7b2655d58c8daf6cb54f2n
}, {
  a: 0x547d8d3099b00cf747b0b885cf0an,
  r: -0x547d8d3099b00cf747b0b885cf0an
}, {
  a: 0x7ccbdb67313522399a05eb8n,
  r: -0x7ccbdb67313522399a05eb8n
}, {
  a: -0xb9db16c0a936a161ea8deec8346a9828ac1872c0f177n,
  r: 0xb9db16c0a936a161ea8deec8346a9828ac1872c0f177n
}, {
  a: -0x5e9a22fce9814322d760ef8e9ee9f4cb7ffd04f85115ee1334643a0n,
  r: 0x5e9a22fce9814322d760ef8e9ee9f4cb7ffd04f85115ee1334643a0n
}, {
  a: 0xc240d41e8fa958e01b01b71e098c07cfcb8296d198e7be608ab71e31an,
  r: -0xc240d41e8fa958e01b01b71e098c07cfcb8296d198e7be608ab71e31an
}, {
  a: 0xdccecaa0b0d2acb2117aa3a261fa833660e60n,
  r: -0xdccecaa0b0d2acb2117aa3a261fa833660e60n
}, {
  a: -0xcf335311bn,
  r: 0xcf335311bn
}, {
  a: -0x80ee8fe8c453e55c2cb34d4f1e527786ca848aa23n,
  r: 0x80ee8fe8c453e55c2cb34d4f1e527786ca848aa23n
}, {
  a: 0x8f2c2fc3db649a6dc53930dd262896fb2a3abcb04c541db2a6376b943d9c5d9n,
  r: -0x8f2c2fc3db649a6dc53930dd262896fb2a3abcb04c541db2a6376b943d9c5d9n
}, {
  a: 0n,
  r: 0n
}, {
  a: -0x81c9449df9c2e7fe1c5c6ac8f8d4f509n,
  r: 0x81c9449df9c2e7fe1c5c6ac8f8d4f509n
}, {
  a: 0x35df4a4487469f770n,
  r: -0x35df4a4487469f770n
}, {
  a: -0xc2befe41eff65aa7201efbc6e52a766ec64212ca8d6a7ec6e9cb670a621463a7a600n,
  r: 0xc2befe41eff65aa7201efbc6e52a766ec64212ca8d6a7ec6e9cb670a621463a7a600n
}, {
  a: -0xda13dc0c7a043253078c20582865e503e0e0cbdcf67783f0245e24c2d65731bd4f84n,
  r: 0xda13dc0c7a043253078c20582865e503e0e0cbdcf67783f0245e24c2d65731bd4f84n
}, {
  a: 0x4cd5384289676fd17c66b3fbb8ef77bb5f2bn,
  r: -0x4cd5384289676fd17c66b3fbb8ef77bb5f2bn
}, {
  a: -0xea4377d8000fd4a70cc7d87125ac06bn,
  r: 0xea4377d8000fd4a70cc7d87125ac06bn
}, {
  a: 0x40347c8dba0c08a1d178508f4cd4ae5d81500bad0n,
  r: -0x40347c8dba0c08a1d178508f4cd4ae5d81500bad0n
}, {
  a: 0xb23284fab665f73036b202113f18834978e81bc68410c0n,
  r: -0xb23284fab665f73036b202113f18834978e81bc68410c0n
}, {
  a: -0x605b32d16eda7378f2n,
  r: 0x605b32d16eda7378f2n
}, {
  a: 0x12ea332c6ed329225c1fefedef1718085049c1c41f19b075153ce1n,
  r: -0x12ea332c6ed329225c1fefedef1718085049c1c41f19b075153ce1n
}, {
  a: 0xf9b71f6de5e07n,
  r: -0xf9b71f6de5e07n
}, {
  a: 0xd91a7c48f5238df49fda1c96cae0e56dab68fed4b86d93d58bede1ab6dc269eadbn,
  r: -0xd91a7c48f5238df49fda1c96cae0e56dab68fed4b86d93d58bede1ab6dc269eadbn
}, {
  a: -0x9c0fa0f3bd1e6n,
  r: 0x9c0fa0f3bd1e6n
}, {
  a: -0x20bfn,
  r: 0x20bfn
}, {
  a: -0xf59e5d5216116793c14b7a0814dc1594ea879739daen,
  r: 0xf59e5d5216116793c14b7a0814dc1594ea879739daen
}, {
  a: -0xba6fbac9cf51d4084ee54a0fd8aebfd211265f8e6978an,
  r: 0xba6fbac9cf51d4084ee54a0fd8aebfd211265f8e6978an
}, {
  a: 0x911e3e7e58df3227fd5a4ab4e574ec8c5e94b95n,
  r: -0x911e3e7e58df3227fd5a4ab4e574ec8c5e94b95n
}, {
  a: 0xb89e7c0120521a5d31c94f49e3013d350697449f786eda442b0b33347838e6bdn,
  r: -0xb89e7c0120521a5d31c94f49e3013d350697449f786eda442b0b33347838e6bdn
}, {
  a: 0x18741c631944dca3a69feb89446994f079n,
  r: -0x18741c631944dca3a69feb89446994f079n
}, {
  a: 0x3a1f1b13c6837b61a326fbef58n,
  r: -0x3a1f1b13c6837b61a326fbef58n
}, {
  a: -0x39cc40d3539864f72055e2009693c3808777feda171n,
  r: 0x39cc40d3539864f72055e2009693c3808777feda171n
}, {
  a: -0x8a3cn,
  r: 0x8a3cn
}, {
  a: -0xfe66866da42979328n,
  r: 0xfe66866da42979328n
}, {
  a: 0xf6de4802b965efac827500a96043n,
  r: -0xf6de4802b965efac827500a96043n
}, {
  a: -0x98bc3n,
  r: 0x98bc3n
}, {
  a: 0x89a60a71129accfcd0754ef103e175ff021d1f6a485037e63d50bf8b0n,
  r: -0x89a60a71129accfcd0754ef103e175ff021d1f6a485037e63d50bf8b0n
}, {
  a: 0x1273a10de19a68f2n,
  r: -0x1273a10de19a68f2n
}, {
  a: -0x557a41277a8bee9f207993205d9d7dcbdb18e1ec8b12cd5d41n,
  r: 0x557a41277a8bee9f207993205d9d7dcbdb18e1ec8b12cd5d41n
}, {
  a: -0x73c1db8a2fc7a082e4614b9n,
  r: 0x73c1db8a2fc7a082e4614b9n
}, {
  a: 0x39f2781a52n,
  r: -0x39f2781a52n
}, {
  a: 0xf12ddc276b7d25d18d40bcd1178daca7f3285c1287899d38ad1n,
  r: -0xf12ddc276b7d25d18d40bcd1178daca7f3285c1287899d38ad1n
}, {
  a: 0x2bcbb53en,
  r: -0x2bcbb53en
}, {
  a: -0xc47eafa54f9e6cc747f5f8550672e35c64f6166458316a04aba11cd1ff463088256dbn,
  r: 0xc47eafa54f9e6cc747f5f8550672e35c64f6166458316a04aba11cd1ff463088256dbn
}, {
  a: 0xb23937eacea2824660e8n,
  r: -0xb23937eacea2824660e8n
}, {
  a: -0x68510c2f814bd41n,
  r: 0x68510c2f814bd41n
}, {
  a: -0x782c0a7ab8f0fe8ce2eefc7402e9202383bbe68de694ff9d996e5c05511f35b8a7dn,
  r: 0x782c0a7ab8f0fe8ce2eefc7402e9202383bbe68de694ff9d996e5c05511f35b8a7dn
}, {
  a: -0x5n,
  r: 0x5n
}, {
  a: -0x9308623f17fff91fdd2d87e29b379405b405182n,
  r: 0x9308623f17fff91fdd2d87e29b379405b405182n
}, {
  a: -0x9ec0884266af8b61c54d72cd86c7c0cba90b6099c11e5ad9ba84n,
  r: 0x9ec0884266af8b61c54d72cd86c7c0cba90b6099c11e5ad9ba84n
}, {
  a: -0x7n,
  r: 0x7n
}, {
  a: 0xd2e72d9ae1390580bd30145f007ea436f892c338cc148a0b6255dn,
  r: -0xd2e72d9ae1390580bd30145f007ea436f892c338cc148a0b6255dn
}, {
  a: -0x2n,
  r: 0x2n
}, {
  a: 0xbcab1d57df3065419c85042e6n,
  r: -0xbcab1d57df3065419c85042e6n
}, {
  a: 0x3f770d4b662547026an,
  r: -0x3f770d4b662547026an
}, {
  a: 0x172a6654e9a16550862086f846579dca2f302b83fcc56n,
  r: -0x172a6654e9a16550862086f846579dca2f302b83fcc56n
}, {
  a: -0x2c51bf7ba4a3f6ad308a7e34644246f7707e9474152e9cb63104e27c8an,
  r: 0x2c51bf7ba4a3f6ad308a7e34644246f7707e9474152e9cb63104e27c8an
}, {
  a: 0xff6n,
  r: -0xff6n
}, {
  a: 0x274bdba953e1d3aa4be3f42d0040d669e7f6f00dead2774b33f95183c00b6n,
  r: -0x274bdba953e1d3aa4be3f42d0040d669e7f6f00dead2774b33f95183c00b6n
}, {
  a: 0xd5c6c1a29e25387dd27e671db50a2125a4bfaca7b2cff733b8db567bedaa7e17916631n,
  r: -0xd5c6c1a29e25387dd27e671db50a2125a4bfaca7b2cff733b8db567bedaa7e17916631n
}, {
  a: -0x9n,
  r: 0x9n
}, {
  a: -0xbe1964b244aa1092e5dfd9cc2494cb8d394fadaf4f2614ed01036f07aac06f508n,
  r: 0xbe1964b244aa1092e5dfd9cc2494cb8d394fadaf4f2614ed01036f07aac06f508n
}, {
  a: 0x80a10222f33d8aa9acc56c6ab451b8348627486092246810b3f68eafan,
  r: -0x80a10222f33d8aa9acc56c6ab451b8348627486092246810b3f68eafan
}, {
  a: -0xf0bdf6a791177c930d1e621015cbbc6d268c8462ceb6cn,
  r: 0xf0bdf6a791177c930d1e621015cbbc6d268c8462ceb6cn
}, {
  a: 0x1764230baacace0d91eb72e2034e77ced3f47bn,
  r: -0x1764230baacace0d91eb72e2034e77ced3f47bn
}, {
  a: -0x5754046f978b8a512c249bfbdb666n,
  r: 0x5754046f978b8a512c249bfbdb666n
}, {
  a: -0x5e31c7e0cff86c2df133e33791a5f851979e7ff26c8cf2c7b84b13fn,
  r: 0x5e31c7e0cff86c2df133e33791a5f851979e7ff26c8cf2c7b84b13fn
}, {
  a: -0xabce21e7ce162df998e2bec00ab1bd4604a1a63750c50148378135eea2c1535e1a1dn,
  r: 0xabce21e7ce162df998e2bec00ab1bd4604a1a63750c50148378135eea2c1535e1a1dn
}, {
  a: 0xbbd84018d7n,
  r: -0xbbd84018d7n
}, {
  a: 0x8066596af3c5441eff03c1ba030dbaf25b9652f8b9742f575f263n,
  r: -0x8066596af3c5441eff03c1ba030dbaf25b9652f8b9742f575f263n
}, {
  a: 0x3c5bd94858a513e994617a0736fan,
  r: -0x3c5bd94858a513e994617a0736fan
}, {
  a: -0xb363b69fe66597765a3106b4147b8d1ba406407fn,
  r: 0xb363b69fe66597765a3106b4147b8d1ba406407fn
}, {
  a: -0xf69fa694n,
  r: 0xf69fa694n
}, {
  a: -0x2dd773302f1bd30177fc2524c2n,
  r: 0x2dd773302f1bd30177fc2524c2n
}, {
  a: -0xfn,
  r: 0xfn
}, {
  a: 0x3f29c59e1f6b2098fd80b7531db6f8abaa7af74a739f9526596358f95cf05e5f10dn,
  r: -0x3f29c59e1f6b2098fd80b7531db6f8abaa7af74a739f9526596358f95cf05e5f10dn
}, {
  a: 0x2bf7c5f59fb8076ab59c52ed375036d94c3cdaaa1c4dc02a061e3d6231b45eb8915b05n,
  r: -0x2bf7c5f59fb8076ab59c52ed375036d94c3cdaaa1c4dc02a061e3d6231b45eb8915b05n
}, {
  a: 0x20238cb104ba73a0031b24ee1a2f11cbb8bb50ab55cc8561n,
  r: -0x20238cb104ba73a0031b24ee1a2f11cbb8bb50ab55cc8561n
}, {
  a: 0x819c9e09703a1c8e29f9072a3e77aef055e5ed6n,
  r: -0x819c9e09703a1c8e29f9072a3e77aef055e5ed6n
}, {
  a: 0x1d22f273564e95199725b4fd60542e7a4ef29076c5d419046d0n,
  r: -0x1d22f273564e95199725b4fd60542e7a4ef29076c5d419046d0n
}, {
  a: 0x7551340c80d9bad5054e6a60398300c07fb40f0610278n,
  r: -0x7551340c80d9bad5054e6a60398300c07fb40f0610278n
}, {
  a: 0xbab9105b4749d2303021cb3aedd8n,
  r: -0xbab9105b4749d2303021cb3aedd8n
}, {
  a: 0x62d48468b6a3b091d1f1920d753cc7dcee224889944de520029b9f36fef2149d8n,
  r: -0x62d48468b6a3b091d1f1920d753cc7dcee224889944de520029b9f36fef2149d8n
}, {
  a: 0n,
  r: 0n
}, {
  a: -0xd12a2104291862bdc9f49e20fbf31716230f9c001df0ad5d05fn,
  r: 0xd12a2104291862bdc9f49e20fbf31716230f9c001df0ad5d05fn
}, {
  a: 0x69cn,
  r: -0x69cn
}, {
  a: 0xc2059a4ec19d13d67f90d8c5543529n,
  r: -0xc2059a4ec19d13d67f90d8c5543529n
}, {
  a: 0xc82b7388ee2081f8d17c6444551bb92043836c3en,
  r: -0xc82b7388ee2081f8d17c6444551bb92043836c3en
}, {
  a: -0x44364312cf677bb795a9e76006f3n,
  r: 0x44364312cf677bb795a9e76006f3n
}, {
  a: 0x6b0f1be50d51dfcaa20189c9cn,
  r: -0x6b0f1be50d51dfcaa20189c9cn
}, {
  a: -0xc8f26f3a3c2d9539f5e6140d14c68a53cd17c6c3ca48d6b8007300d445e512594n,
  r: 0xc8f26f3a3c2d9539f5e6140d14c68a53cd17c6c3ca48d6b8007300d445e512594n
}, {
  a: 0x91d9001eb39040c8011795da3c9dbc432102b7d4f3n,
  r: -0x91d9001eb39040c8011795da3c9dbc432102b7d4f3n
}, {
  a: 0x568e4a25cfc4084d7c613372a54313121ba62970ad152122e1bb53809f2fcf8dad6bn,
  r: -0x568e4a25cfc4084d7c613372a54313121ba62970ad152122e1bb53809f2fcf8dad6bn
}, {
  a: -0xb7974a4b16aa58eb1ac221f81f89eda6e8e266050cc09ceed078deb4dc41589bn,
  r: 0xb7974a4b16aa58eb1ac221f81f89eda6e8e266050cc09ceed078deb4dc41589bn
}, {
  a: -0x5827eea68b6355n,
  r: 0x5827eea68b6355n
}, {
  a: 0xdd7e841e397ab8c4eb946bc9ed16377abf83513d2991fb266cf99c0006a411feea5n,
  r: -0xdd7e841e397ab8c4eb946bc9ed16377abf83513d2991fb266cf99c0006a411feea5n
}, {
  a: -0x1508f8cc0a8n,
  r: 0x1508f8cc0a8n
}, {
  a: -0x1bfba1075432f6f182b52551b0b9935454302c3ce41bd47de361db15fc0d49an,
  r: 0x1bfba1075432f6f182b52551b0b9935454302c3ce41bd47de361db15fc0d49an
}, {
  a: 0xdcf49fd57a5363c2091e1d9247010809en,
  r: -0xdcf49fd57a5363c2091e1d9247010809en
}, {
  a: -0x27b62f65a909516d61601357ba6efb20n,
  r: 0x27b62f65a909516d61601357ba6efb20n
}, {
  a: 0x4ea5e6ca4694bbef11fc90d601bee1152db8f08c4749ea039b9254n,
  r: -0x4ea5e6ca4694bbef11fc90d601bee1152db8f08c4749ea039b9254n
}, {
  a: -0x2a94c6d0cec1aa34646bec71ecd182615ae00ee8cc911a75f9e3105a993f0ed5n,
  r: 0x2a94c6d0cec1aa34646bec71ecd182615ae00ee8cc911a75f9e3105a993f0ed5n
}, {
  a: -0xb35b83d402b38a4n,
  r: 0xb35b83d402b38a4n
}, {
  a: 0x8eb015fccd6215b3dfabdf37217d028bd6632ef8e0da3c655cb59412e5fn,
  r: -0x8eb015fccd6215b3dfabdf37217d028bd6632ef8e0da3c655cb59412e5fn
}, {
  a: -0xfa4b3be8103037ebdefd23bf5bc4c64fd820572b0d3258n,
  r: 0xfa4b3be8103037ebdefd23bf5bc4c64fd820572b0d3258n
}, {
  a: 0xc65fc6a07fb926d92e2d2fbn,
  r: -0xc65fc6a07fb926d92e2d2fbn
}, {
  a: -0x812be6448bc05b7ce444cedbbe229f772a28e0acc6107936120f7ed0n,
  r: 0x812be6448bc05b7ce444cedbbe229f772a28e0acc6107936120f7ed0n
}, {
  a: -0x5c3deb3e4a8fa61f8c21b9n,
  r: 0x5c3deb3e4a8fa61f8c21b9n
}, {
  a: -0xd913376b7800ce4e3e145711b2c53afa2aece6afdce2becf3a68a4ef2b2001394ea610n,
  r: 0xd913376b7800ce4e3e145711b2c53afa2aece6afdce2becf3a68a4ef2b2001394ea610n
}, {
  a: -0xb7fa2810d15650a247dd7d3ce057ef28aaee7725c3b65d97ac76fc239b465f9n,
  r: 0xb7fa2810d15650a247dd7d3ce057ef28aaee7725c3b65d97ac76fc239b465f9n
}, {
  a: 0x57f7907111dae652dfdfcb9bf83dn,
  r: -0x57f7907111dae652dfdfcb9bf83dn
}, {
  a: -0xa3f442663941e0838bd8766478n,
  r: 0xa3f442663941e0838bd8766478n
}, {
  a: 0x59012ec5cf3a6993e16f60b0305b701d511ce7ec23d9c3e59c6a30ed3n,
  r: -0x59012ec5cf3a6993e16f60b0305b701d511ce7ec23d9c3e59c6a30ed3n
}, {
  a: -0x4d1a77n,
  r: 0x4d1a77n
}, {
  a: 0xd0b5a096c02db9a1229f1498e4d0828a33fd4ee4abn,
  r: -0xd0b5a096c02db9a1229f1498e4d0828a33fd4ee4abn
}, {
  a: 0xcf4c0faf3d1d0cbb1648ab47e0ca76ff6c3c34643bf9f8f78c14f8a152aa6en,
  r: -0xcf4c0faf3d1d0cbb1648ab47e0ca76ff6c3c34643bf9f8f78c14f8a152aa6en
}, {
  a: -0x247ad0fa812d2a30ab32fb0706099812a42818c9a56f98188e508c1aaa87b7n,
  r: 0x247ad0fa812d2a30ab32fb0706099812a42818c9a56f98188e508c1aaa87b7n
}, {
  a: -0xfd04698aafeb1cfd6d9d7fb50f2ad4n,
  r: 0xfd04698aafeb1cfd6d9d7fb50f2ad4n
}, {
  a: -0xd5ef0d08583e240676fc365087592b55290da21161f0344926dn,
  r: 0xd5ef0d08583e240676fc365087592b55290da21161f0344926dn
}, {
  a: -0x91495f9c9a909f0eeaf79d6de10275n,
  r: 0x91495f9c9a909f0eeaf79d6de10275n
}, {
  a: -0x7b7e78e06n,
  r: 0x7b7e78e06n
}, {
  a: -0xff7d7d45181aac761faa55932833b4ff210a0b526fef25f766n,
  r: 0xff7d7d45181aac761faa55932833b4ff210a0b526fef25f766n
}, {
  a: 0x89b5ab8db5f8a5a82d41b65d5236f3b560042ceb1eedb6c6f8410c5ee5771d3ac2dn,
  r: -0x89b5ab8db5f8a5a82d41b65d5236f3b560042ceb1eedb6c6f8410c5ee5771d3ac2dn
}, {
  a: 0x6adcf41581a222210398fe62e8834738fed36e96480186bcd64n,
  r: -0x6adcf41581a222210398fe62e8834738fed36e96480186bcd64n
}, {
  a: 0x2ff2215190e10a22e86098eb4bc7b95f6441a52048c08db48896753cn,
  r: -0x2ff2215190e10a22e86098eb4bc7b95f6441a52048c08db48896753cn
}, {
  a: -0xa2cab52719a7400ef8b105d4cn,
  r: 0xa2cab52719a7400ef8b105d4cn
}, {
  a: 0xc0ae2d5f4a7e61a8bee45c889b88d835d37f680aa0fff8fec8b36dn,
  r: -0xc0ae2d5f4a7e61a8bee45c889b88d835d37f680aa0fff8fec8b36dn
}, {
  a: 0xefb8433c21afb26265a1c76026d7an,
  r: -0xefb8433c21afb26265a1c76026d7an
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var r = -d.a;
  if (d.r !== r) {
    print("Input:    " + d.a.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    error_count++;
  }
}
if (error_count !== 0)
  throw new Error("Finished with " + error_count + " errors.")

