/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef VPP_REGS_HEADER_
#define VPP_REGS_HEADER_

#define VPP_DUMMY_DATA                    0x1d00
#define VPP_LINE_IN_LENGTH                0x1d01
#define VPP_PIC_IN_HEIGHT                 0x1d02
#define VPP_SCALE_COEF_IDX                0x1d03
#define VPP_SCALE_COEF                    0x1d04
#define VPP_VSC_REGION12_STARTP           0x1d05
#define VPP_VSC_REGION34_STARTP           0x1d06
#define VPP_VSC_REGION4_ENDP              0x1d07
#define VPP_VSC_START_PHASE_STEP          0x1d08
#define VPP_VSC_REGION0_PHASE_SLOPE       0x1d09
#define VPP_VSC_REGION1_PHASE_SLOPE       0x1d0a
#define VPP_VSC_REGION3_PHASE_SLOPE       0x1d0b
#define VPP_VSC_REGION4_PHASE_SLOPE       0x1d0c
#define VPP_VSC_PHASE_CTRL                0x1d0d
#define VPP_VSC_INI_PHASE                 0x1d0e
#define VPP_HSC_REGION12_STARTP           0x1d10
#define VPP_HSC_REGION34_STARTP           0x1d11
#define VPP_HSC_REGION4_ENDP              0x1d12
#define VPP_HSC_START_PHASE_STEP          0x1d13
#define VPP_HSC_REGION0_PHASE_SLOPE       0x1d14
#define VPP_HSC_REGION1_PHASE_SLOPE       0x1d15
#define VPP_HSC_REGION3_PHASE_SLOPE       0x1d16
#define VPP_HSC_REGION4_PHASE_SLOPE       0x1d17
#define VPP_HSC_PHASE_CTRL                0x1d18
#define VPP_SC_MISC                       0x1d19
#define VPP_PREBLEND_VD1_H_START_END      0x1d1a
#define VPP_PREBLEND_VD1_V_START_END      0x1d1b
#define VPP_POSTBLEND_VD1_H_START_END     0x1d1c
#define VPP_POSTBLEND_VD1_V_START_END     0x1d1d
#define VPP_BLEND_VD2_H_START_END         0x1d1e
#define VPP_BLEND_VD2_V_START_END         0x1d1f
#define VPP_PREBLEND_H_SIZE               0x1d20
#define VPP_POSTBLEND_H_SIZE              0x1d21
#define VPP_HOLD_LINES                    0x1d22
#define VPP_BLEND_ONECOLOR_CTRL           0x1d23
#define VPP_PREBLEND_CURRENT_XY           0x1d24
#define VPP_POSTBLEND_CURRENT_XY          0x1d25
#define VPP_MISC                          0x1d26
#define VPP_OFIFO_SIZE                    0x1d27
#define VPP_FIFO_STATUS                   0x1d28
#define VPP_SMOKE_CTRL                    0x1d29
#define VPP_SMOKE1_VAL                    0x1d2a
#define VPP_SMOKE2_VAL                    0x1d2b
#define VPP_SMOKE3_VAL                    0x1d2c
#define VPP_SMOKE1_H_START_END            0x1d2d
#define VPP_SMOKE1_V_START_END            0x1d2e
#define VPP_SMOKE2_H_START_END            0x1d2f
#define VPP_SMOKE2_V_START_END            0x1d30
#define VPP_SMOKE3_H_START_END            0x1d31
#define VPP_SMOKE3_V_START_END            0x1d32
#define VPP_SCO_FIFO_CTRL                 0x1d33
#define VPP_HSC_PHASE_CTRL1               0x1d34
#define VPP_HSC_INI_PAT_CTRL              0x1d35
#define VPP_SC_GCLK_CTRL_T7               0x1d36
#define VPP_PREHSC_COEF                   0x1d37
#define VPP_PREHSC_CTRL                   0x1d38
#define VPP_PRE_SCALE_CTRL                0x1d38
#define VPP_PREVSC_COEF                   0x1d39
#define VPP_PREHSC_COEF1                  0x1d3a

#define VPP_VADJ_CTRL                     0x1d40
#define VPP_VADJ1_Y                       0x1d41
#define VPP_VADJ1_MA_MB                   0x1d42
#define VPP_VADJ1_MC_MD                   0x1d43
#define VPP_VADJ2_Y                       0x1d44
#define VPP_VADJ2_MA_MB                   0x1d45
#define VPP_VADJ2_MC_MD                   0x1d46
#define VPP_HSHARP_CTRL                   0x1d50
#define VPP_HSHARP_LUMA_THRESH01          0x1d51
#define VPP_HSHARP_LUMA_THRESH23          0x1d52
#define VPP_HSHARP_CHROMA_THRESH01        0x1d53
#define VPP_HSHARP_CHROMA_THRESH23        0x1d54
#define VPP_HSHARP_LUMA_GAIN              0x1d55
#define VPP_HSHARP_CHROMA_GAIN            0x1d56
#define VPP_MATRIX_PROBE_COLOR            0x1d5c
#define VPP_MATRIX_HL_COLOR               0x1d5d
#define VPP_MATRIX_PROBE_POS              0x1d5e
#define VPP_MATRIX_CTRL                   0x1d5f
#define VPP_MATRIX_COEF00_01              0x1d60
#define VPP_MATRIX_COEF02_10              0x1d61
#define VPP_MATRIX_COEF11_12              0x1d62
#define VPP_MATRIX_COEF20_21              0x1d63
#define VPP_MATRIX_COEF22                 0x1d64
#define VPP_MATRIX_OFFSET0_1              0x1d65
#define VPP_MATRIX_OFFSET2                0x1d66
#define VPP_MATRIX_PRE_OFFSET0_1          0x1d67
#define VPP_MATRIX_PRE_OFFSET2            0x1d68
#define VPP_DUMMY_DATA1                   0x1d69
#define VPP_GAINOFF_CTRL0                 0x1d6a
#define VPP_GAINOFF_CTRL1                 0x1d6b
#define VPP_GAINOFF_CTRL2                 0x1d6c
#define VPP_GAINOFF_CTRL3                 0x1d6d
#define VPP_GAINOFF_CTRL4                 0x1d6e
#define VPP_CHROMA_ADDR_PORT              0x1d70
#define VPP_CHROMA_DATA_PORT              0x1d71
#define VPP_GCLK_CTRL0                    0x1d72
#define VPP_GCLK_CTRL1                    0x1d73
#define VPP_SC_GCLK_CTRL                  0x1d74
#define VPP_MISC1                         0x1d76
#define VPP_SRSCL_GCLK_CTRL               0x1d77
#define VPP_BLACKEXT_CTRL                 0x1d80
#define VPP_DNLP_CTRL_00                  0x1d81
#define VPP_DNLP_CTRL_01                  0x1d82
#define VPP_DNLP_CTRL_02                  0x1d83
#define VPP_DNLP_CTRL_03                  0x1d84
#define VPP_DNLP_CTRL_04                  0x1d85
#define VPP_DNLP_CTRL_05                  0x1d86
#define VPP_DNLP_CTRL_06                  0x1d87
#define VPP_DNLP_CTRL_07                  0x1d88
#define VPP_DNLP_CTRL_08                  0x1d89
#define VPP_DNLP_CTRL_09                  0x1d8a
#define VPP_DNLP_CTRL_10                  0x1d8b
#define VPP_DNLP_CTRL_11                  0x1d8c
#define VPP_DNLP_CTRL_12                  0x1d8d
#define VPP_DNLP_CTRL_13                  0x1d8e
#define VPP_DNLP_CTRL_14                  0x1d8f
#define VPP_DNLP_CTRL_15                  0x1d90
#define VPP_SRSHARP0_CTRL                 0x1d91
#define VPP_SRSHARP1_CTRL                 0x1d92
#define VPP_PEAKING_NLP_1                 0x1d93
/* gxm has no super-core */
#define VPP_AMDV_CTRL                    0x1d93
#define VPP_PEAKING_NLP_2                 0x1d94
#define VPP_PEAKING_NLP_3                 0x1d95
#define VPP_PEAKING_NLP_4                 0x1d96
#define VPP_PEAKING_NLP_5                 0x1d97
#define VPP_SHARP_LIMIT                   0x1d98
#define VPP_VLTI_CTRL                     0x1d99
#define VPP_HLTI_CTRL                     0x1d9a
#define VPP_CTI_CTRL                      0x1d9b
#define VPP_BLUE_STRETCH_1                0x1d9c
#define VPP_BLUE_STRETCH_2                0x1d9d
#define VPP_BLUE_STRETCH_3                0x1d9e
#define VPP_CCORING_CTRL                  0x1da0
#define VPP_VE_ENABLE_CTRL                0x1da1
#define VPP_VE_DEMO_LEFT_TOP_SCREEN_WIDTH 0x1da2
#define VPP_VE_DEMO_CENTER_BAR            0x1da3
#define VPP_VE_H_V_SIZE                   0x1da4
#define VPP_PSR_H_V_SIZE                  0x1da5
#define VPP_OUT_H_V_SIZE                  0x1da5
#define VPP_IN_H_V_SIZE                   0x1da6
#define VPP_VDO_MEAS_CTRL                 0x1da8
#define VPP_VDO_MEAS_VS_COUNT_HI          0x1da9
#define VPP_VDO_MEAS_VS_COUNT_LO          0x1daa
#define VPP_INPUT_CTRL                    0x1dab
#define VPP_CTI_CTRL2                     0x1dac
#define VPP_PEAKING_SAT_THD1              0x1dad
#define VPP_PEAKING_SAT_THD2              0x1dae
#define VPP_PEAKING_SAT_THD3              0x1daf
#define VPP_PEAKING_SAT_THD4              0x1db0
#define VPP_PEAKING_SAT_THD5              0x1db1
#define VPP_PEAKING_SAT_THD6              0x1db2
#define VPP_PEAKING_SAT_THD7              0x1db3
#define VPP_PEAKING_SAT_THD8              0x1db4
#define VPP_PEAKING_SAT_THD9              0x1db5
#define VPP_PEAKING_GAIN_ADD1             0x1db6
#define VPP_PEAKING_GAIN_ADD2             0x1db7
#define VPP_PEAKING_DNLP                  0x1db8
#define VPP_SHARP_DEMO_WIN_CTRL1          0x1db9
#define VPP_SHARP_DEMO_WIN_CTRL2          0x1dba
#define VPP_FRONT_HLTI_CTRL               0x1dbb
#define VPP_FRONT_CTI_CTRL                0x1dbc
#define VPP_FRONT_CTI_CTRL2               0x1dbd
#define VPP_OSD_VSC_PHASE_STEP            0x1dc0
#define VPP_OSD_VSC_INI_PHASE             0x1dc1
#define VPP_OSD_VSC_CTRL0                 0x1dc2
#define VPP_OSD_HSC_PHASE_STEP            0x1dc3
#define VPP_OSD_HSC_INI_PHASE             0x1dc4
#define VPP_OSD_HSC_CTRL0                 0x1dc5
#define VPP_OSD_HSC_INI_PAT_CTRL          0x1dc6
#define VPP_OSD_SC_DUMMY_DATA             0x1dc7
#define VPP_OSD_SC_CTRL0                  0x1dc8
#define VPP_OSD_SCI_WH_M1                 0x1dc9
#define VPP_OSD_SCO_H_START_END           0x1dca
#define VPP_OSD_SCO_V_START_END           0x1dcb
#define VPP_OSD_SCALE_COEF_IDX            0x1dcc
#define VPP_OSD_SCALE_COEF                0x1dcd
#define VPP_INT_LINE_NUM                  0x1dce

#define VPP_CLIP_MISC0                    0x1dd9
#define VPP_CLIP_MISC1                    0x1dda

#define VPP_VD1_CLIP_MISC0                0x1de1
#define VPP_VD1_CLIP_MISC1                0x1de2
#define VPP_VD2_CLIP_MISC0                0x1de3
#define VPP_VD2_CLIP_MISC1                0x1de4
#define VPP_VD3_CLIP_MISC0                0x1de5
#define VPP_VD3_CLIP_MISC1                0x1de6

#define VPP2_MISC                         0x1e26
#define VPP2_OFIFO_SIZE                   0x1e27
#define VPP2_INT_LINE_NUM                 0x1e20
#define VPP2_OFIFO_URG_CTRL               0x1e21

#define SRSHARP0_SHARP_HVSIZE             0x3200
#define SRSHARP0_SHARP_HVBLANK_NUM        0x3201
#define SRSHARP0_SHARP_PK_NR_ENABLE       0x3227
#define SRSHARP0_SHARP_DNLP_EN            0x3245
#define SRSHARP0_SHARP_SR2_CTRL           0x3257
#define SRSHARP0_SHARP_SR2_CTRL2          0x3364
#define SRSHARP1_SHARP_HVSIZE             0x3280
#define SRSHARP1_SHARP_HVBLANK_NUM        0x3281
#define SRSHARP1_SHARP_PK_NR_ENABLE       0x32a7
#define SRSHARP1_SHARP_DNLP_EN            0x32c5
#define SRSHARP1_SHARP_SR2_CTRL           0x32d7
#define SRSHARP1_DEMO_MODE_WINDOW_CTRL0   0x3400
#define SRSHARP1_NN_POST_TOP              0x3402
#define SRSHARP1_SHARP_SR2_CTRL2          0x33e4

#define VPP_POST_MATRIX_SAT               0x32c1

/* g12a vd2 pps */
/* for sc2 */
#define VD2_PREHSC_COEF                   0x3937
#define VD2_PREHSC_CTRL                   0x3938
/* for t5d, s4 */
#define VD2_PREHSC_COEF_T5D               0x395d
#define VD2_PRE_SCALE_CTRL                0x395e
#define VD2_PREVSC_COEF                   0x395f
#define VD2_PREVSC_COEF1                  0x3942

#define VD2_SCALE_COEF_IDX                0x3943
#define VD2_SCALE_COEF                    0x3944
#define VD2_VSC_REGION12_STARTP           0x3945
#define VD2_VSC_REGION34_STARTP           0x3946
#define VD2_VSC_REGION4_ENDP              0x3947
#define VD2_VSC_START_PHASE_STEP          0x3948
#define VD2_VSC_REGION0_PHASE_SLOPE       0x3949
#define VD2_VSC_REGION1_PHASE_SLOPE       0x394a
#define VD2_VSC_REGION3_PHASE_SLOPE       0x394b
#define VD2_VSC_REGION4_PHASE_SLOPE       0x394c
#define VD2_VSC_PHASE_CTRL                0x394d
#define VD2_VSC_INI_PHASE                 0x394e
#define VD2_HSC_REGION12_STARTP           0x394f
#define VD2_HSC_REGION34_STARTP           0x3950
#define VD2_HSC_REGION4_ENDP              0x3951
#define VD2_HSC_START_PHASE_STEP          0x3952
#define VD2_HSC_REGION0_PHASE_SLOPE       0x3953
#define VD2_HSC_REGION1_PHASE_SLOPE       0x3954
#define VD2_HSC_REGION3_PHASE_SLOPE       0x3955
#define VD2_HSC_REGION4_PHASE_SLOPE       0x3956
#define VD2_HSC_PHASE_CTRL                0x3957
#define VD2_SC_MISC                       0x3958
#define VD2_SCO_FIFO_CTRL                 0x3959
#define VD2_HSC_PHASE_CTRL1               0x395a
#define VD2_HSC_INI_PAT_CTRL              0x395b
#define VD2_SC_GCLK_CTRL                  0x395c
#define VPP_VD2_HDR_IN_SIZE               0x1df0

/* t7 vd2 pps */
#define VD2_SCALE_COEF_IDX_T7                         0x3933
#define VD2_SCALE_COEF_T7                             0x3934
#define VD2_VSC_REGION12_STARTP_T7                    0x3935
#define VD2_VSC_REGION34_STARTP_T7                    0x3936
#define VD2_VSC_REGION4_ENDP_T7                       0x3937
#define VD2_VSC_START_PHASE_STEP_T7                   0x3938
#define VD2_VSC_REGION0_PHASE_SLOPE_T7                0x3939
#define VD2_VSC_REGION1_PHASE_SLOPE_T7                0x393a
#define VD2_VSC_REGION3_PHASE_SLOPE_T7                0x393b
#define VD2_VSC_REGION4_PHASE_SLOPE_T7                0x393c
#define VD2_VSC_PHASE_CTRL_T7                         0x393d
#define VD2_VSC_INI_PHASE_T7                          0x393e
#define VD2_HSC_REGION12_STARTP_T7                    0x393f
#define VD2_HSC_REGION34_STARTP_T7                    0x3940
#define VD2_HSC_REGION4_ENDP_T7                       0x3941
#define VD2_HSC_START_PHASE_STEP_T7                   0x3942
#define VD2_HSC_REGION0_PHASE_SLOPE_T7                0x3943
#define VD2_HSC_REGION1_PHASE_SLOPE_T7                0x3944
#define VD2_HSC_REGION3_PHASE_SLOPE_T7                0x3945
#define VD2_HSC_REGION4_PHASE_SLOPE_T7                0x3946
#define VD2_HSC_PHASE_CTRL_T7                         0x3947
#define VD2_SC_MISC_T7                                0x3948
#define VD2_SCO_FIFO_CTRL_T7                          0x3949
#define VD2_HSC_PHASE_CTRL1_T7                        0x394a
#define VD2_HSC_INI_PAT_CTRL_T7                       0x394b
#define VD2_SC_GCLK_CTRL_T7                           0x394c
#define VD2_PREHSC_COEF_T7                            0x394d
#define VD2_PRE_SCALE_CTRL_T7                         0x394e
#define VD2_PREVSC_COEF_T7                            0x394f
#define VD2_PREHSC_COEF1_T7                           0x3950

/* t7 vd3 pps */
#define VD3_SCALE_COEF_IDX                         0x5903
#define VD3_SCALE_COEF                             0x5904
#define VD3_VSC_REGION12_STARTP                    0x5905
#define VD3_VSC_REGION34_STARTP                    0x5906
#define VD3_VSC_REGION4_ENDP                       0x5907
#define VD3_VSC_START_PHASE_STEP                   0x5908
#define VD3_VSC_REGION0_PHASE_SLOPE                0x5909
#define VD3_VSC_REGION1_PHASE_SLOPE                0x590a
#define VD3_VSC_REGION3_PHASE_SLOPE                0x590b
#define VD3_VSC_REGION4_PHASE_SLOPE                0x590c
#define VD3_VSC_PHASE_CTRL                         0x590d
#define VD3_VSC_INI_PHASE                          0x590e
#define VD3_HSC_REGION12_STARTP                    0x590f
#define VD3_HSC_REGION34_STARTP                    0x5910
#define VD3_HSC_REGION4_ENDP                       0x5911
#define VD3_HSC_START_PHASE_STEP                   0x5912
#define VD3_HSC_REGION0_PHASE_SLOPE                0x5913
#define VD3_HSC_REGION1_PHASE_SLOPE                0x5914
#define VD3_HSC_REGION3_PHASE_SLOPE                0x5915
#define VD3_HSC_REGION4_PHASE_SLOPE                0x5916
#define VD3_HSC_PHASE_CTRL                         0x5917
#define VD3_SC_MISC                                0x5918
#define VD3_SCO_FIFO_CTRL                          0x5919
#define VD3_HSC_PHASE_CTRL1                        0x591a
#define VD3_HSC_INI_PAT_CTRL                       0x591b
#define VD3_SC_GCLK_CTRL                           0x591c
#define VD3_PREHSC_COEF                            0x591d
#define VD3_PRE_SCALE_CTRL                         0x591e
#define VD3_PREVSC_COEF                            0x591f
#define VD3_PREHSC_COEF1                           0x5920

/* t3 aisr pps */
#define SCHN_SCALE_COEF_IDX                        0x2e70
#define SCHN_SCALE_COEF                            0x2e71
#define SCHN_VSC_REGION12_STARTP                   0x2e72
#define SCHN_VSC_REGION34_STARTP                   0x2e73
#define SCHN_VSC_REGION4_ENDP                      0x2e74
#define SCHN_VSC_START_PHASE_STEP                  0x2e75
#define SCHN_VSC_REGION0_PHASE_SLOPE               0x2e76
#define SCHN_VSC_REGION1_PHASE_SLOPE               0x2e77
#define SCHN_VSC_REGION3_PHASE_SLOPE               0x2e78
#define SCHN_VSC_REGION4_PHASE_SLOPE               0x2e79
#define SCHN_VSC_PHASE_CTRL                        0x2e7a
#define SCHN_VSC_INI_PHASE                         0x2e7b
#define SCHN_HSC_REGION12_STARTP                   0x2e7c
#define SCHN_HSC_REGION34_STARTP                   0x2e7d
#define SCHN_HSC_REGION4_ENDP                      0x2e7e
#define SCHN_HSC_START_PHASE_STEP                  0x2e7f
#define SCHN_HSC_REGION0_PHASE_SLOPE               0x2e80
#define SCHN_HSC_REGION1_PHASE_SLOPE               0x2e81
#define SCHN_HSC_REGION3_PHASE_SLOPE               0x2e82
#define SCHN_HSC_REGION4_PHASE_SLOPE               0x2e83
#define SCHN_HSC_PHASE_CTRL                        0x2e84
#define SCHN_SC_MISC                               0x2e85
#define SCHN_SCO_FIFO_CTRL                         0x2e86
#define SCHN_HSC_PHASE_CTRL1                       0x2e87
#define SCHN_HSC_INI_PAT_CTRL                      0x2e88
#define SCHN_SC_GCLK_CTRL                          0x2e89
#define SCHN_PREHSC_COEF                           0x2e8a
#define SCHN_PREVSC_COEF                           0x2e8b
#define SCHN_PRE_SCALE_CTRL                        0x2e8c
#define SCHN_PREHSC_COEF1                          0x2e8d

#define VD1_BLEND_SRC_CTRL                0x1dfb
#define VD2_BLEND_SRC_CTRL                0x1dfc
#define OSD1_BLEND_SRC_CTRL               0x1dfd
#define OSD2_BLEND_SRC_CTRL               0x1dfe

#define VPP_BLEND_VD3_H_START_END                  0x1deb
#define VPP_BLEND_VD3_V_START_END                  0x1dec
#define VD3_BLEND_SRC_CTRL                         0x1def

#define VPP_POST_BLEND_BLEND_DUMMY_DATA   0x3968
#define VPP_POST_BLEND_DUMMY_ALPHA        0x3969

/* after g12b */
#define SRSHARP0_SHARP_SYNC_CTRL          0x3eb0
#define SRSHARP1_SHARP_SYNC_CTRL          0x3fb0
/* after tm2revb */
#define TM2REVB_SRSHARP0_SHARP_SYNC_CTRL 0x50b0
#define TM2REVB_SRSHARP1_SHARP_SYNC_CTRL 0x52b0
#define VPU_RDARB_MODE_L2C1               0x279d
#define VPU_WRARB_MODE_L2C1               0x27a2
#define VPP_XVYCC_MISC   0x1dcf
#define VPP_XVYCC_MISC0  0x1ddf

/* vpp crc */
#define VPP_RO_CRCSUM           0x1db2
#define VPP_CRC_CHK             0x1db3

/*viu2  vpp crc */
#define VPP2_CRC_CHK            0x1eb0
#define VPP2_RO_CRCSUM          0x1eb1

/* pip alpha gen */
#define VD1_PIP_ALPH_CTRL                          0x5880
#define VD1_PIP_ALPH_SCP_H_0                       0x5881
#define VD1_PIP_ALPH_SCP_H_1                       0x5882
#define VD1_PIP_ALPH_SCP_H_2                       0x5883
#define VD1_PIP_ALPH_SCP_H_3                       0x5884
#define VD1_PIP_ALPH_SCP_H_4                       0x5885
#define VD1_PIP_ALPH_SCP_H_5                       0x5886
#define VD1_PIP_ALPH_SCP_H_6                       0x5887
#define VD1_PIP_ALPH_SCP_H_7                       0x5888
#define VD1_PIP_ALPH_SCP_H_8                       0x5889
#define VD1_PIP_ALPH_SCP_H_9                       0x588a
#define VD1_PIP_ALPH_SCP_H_10                      0x588b
#define VD1_PIP_ALPH_SCP_H_11                      0x588c
#define VD1_PIP_ALPH_SCP_H_12                      0x588d
#define VD1_PIP_ALPH_SCP_H_13                      0x588e
#define VD1_PIP_ALPH_SCP_H_14                      0x588f
#define VD1_PIP_ALPH_SCP_H_15                      0x5890
#define VD1_PIP_ALPH_SCP_V_0                       0x5891
#define VD1_PIP_ALPH_SCP_V_1                       0x5892
#define VD1_PIP_ALPH_SCP_V_2                       0x5893
#define VD1_PIP_ALPH_SCP_V_3                       0x5894
#define VD1_PIP_ALPH_SCP_V_4                       0x5895
#define VD1_PIP_ALPH_SCP_V_5                       0x5896
#define VD1_PIP_ALPH_SCP_V_6                       0x5897
#define VD1_PIP_ALPH_SCP_V_7                       0x5898
#define VD1_PIP_ALPH_SCP_V_8                       0x5899
#define VD1_PIP_ALPH_SCP_V_9                       0x589a
#define VD1_PIP_ALPH_SCP_V_10                      0x589b
#define VD1_PIP_ALPH_SCP_V_11                      0x589c
#define VD1_PIP_ALPH_SCP_V_12                      0x589d
#define VD1_PIP_ALPH_SCP_V_13                      0x589e
#define VD1_PIP_ALPH_SCP_V_14                      0x589f
#define VD1_PIP_ALPH_SCP_V_15                      0x58a0

#define VD2_PIP_ALPH_CTRL                          0x58b0
#define VD2_PIP_ALPH_SCP_H_0                       0x58b1
#define VD2_PIP_ALPH_SCP_H_1                       0x58b2
#define VD2_PIP_ALPH_SCP_H_2                       0x58b3
#define VD2_PIP_ALPH_SCP_H_3                       0x58b4
#define VD2_PIP_ALPH_SCP_H_4                       0x58b5
#define VD2_PIP_ALPH_SCP_H_5                       0x58b6
#define VD2_PIP_ALPH_SCP_H_6                       0x58b7
#define VD2_PIP_ALPH_SCP_H_7                       0x58b8
#define VD2_PIP_ALPH_SCP_H_8                       0x58b9
#define VD2_PIP_ALPH_SCP_H_9                       0x58ba
#define VD2_PIP_ALPH_SCP_H_10                      0x58bb
#define VD2_PIP_ALPH_SCP_H_11                      0x58bc
#define VD2_PIP_ALPH_SCP_H_12                      0x58bd
#define VD2_PIP_ALPH_SCP_H_13                      0x58be
#define VD2_PIP_ALPH_SCP_H_14                      0x58bf
#define VD2_PIP_ALPH_SCP_H_15                      0x58c0
#define VD2_PIP_ALPH_SCP_V_0                       0x58c1
#define VD2_PIP_ALPH_SCP_V_1                       0x58c2
#define VD2_PIP_ALPH_SCP_V_2                       0x58c3
#define VD2_PIP_ALPH_SCP_V_3                       0x58c4
#define VD2_PIP_ALPH_SCP_V_4                       0x58c5
#define VD2_PIP_ALPH_SCP_V_5                       0x58c6
#define VD2_PIP_ALPH_SCP_V_6                       0x58c7
#define VD2_PIP_ALPH_SCP_V_7                       0x58c8
#define VD2_PIP_ALPH_SCP_V_8                       0x58c9
#define VD2_PIP_ALPH_SCP_V_9                       0x58ca
#define VD2_PIP_ALPH_SCP_V_10                      0x58cb
#define VD2_PIP_ALPH_SCP_V_11                      0x58cc
#define VD2_PIP_ALPH_SCP_V_12                      0x58cd
#define VD2_PIP_ALPH_SCP_V_13                      0x58ce
#define VD2_PIP_ALPH_SCP_V_14                      0x58cf
#define VD2_PIP_ALPH_SCP_V_15                      0x58d0

#define VD3_PIP_ALPH_CTRL                          0x5850
#define VD3_PIP_ALPH_SCP_H_0                       0x5851
#define VD3_PIP_ALPH_SCP_H_1                       0x5852
#define VD3_PIP_ALPH_SCP_H_2                       0x5853
#define VD3_PIP_ALPH_SCP_H_3                       0x5854
#define VD3_PIP_ALPH_SCP_H_4                       0x5855
#define VD3_PIP_ALPH_SCP_H_5                       0x5856
#define VD3_PIP_ALPH_SCP_H_6                       0x5857
#define VD3_PIP_ALPH_SCP_H_7                       0x5858
#define VD3_PIP_ALPH_SCP_H_8                       0x5859
#define VD3_PIP_ALPH_SCP_H_9                       0x585a
#define VD3_PIP_ALPH_SCP_H_10                      0x585b
#define VD3_PIP_ALPH_SCP_H_11                      0x585c
#define VD3_PIP_ALPH_SCP_H_12                      0x585d
#define VD3_PIP_ALPH_SCP_H_13                      0x585e
#define VD3_PIP_ALPH_SCP_H_14                      0x585f
#define VD3_PIP_ALPH_SCP_H_15                      0x5860
#define VD3_PIP_ALPH_SCP_V_0                       0x5861
#define VD3_PIP_ALPH_SCP_V_1                       0x5862
#define VD3_PIP_ALPH_SCP_V_2                       0x5863
#define VD3_PIP_ALPH_SCP_V_3                       0x5864
#define VD3_PIP_ALPH_SCP_V_4                       0x5865
#define VD3_PIP_ALPH_SCP_V_5                       0x5866
#define VD3_PIP_ALPH_SCP_V_6                       0x5867
#define VD3_PIP_ALPH_SCP_V_7                       0x5868
#define VD3_PIP_ALPH_SCP_V_8                       0x5869
#define VD3_PIP_ALPH_SCP_V_9                       0x586a
#define VD3_PIP_ALPH_SCP_V_10                      0x586b
#define VD3_PIP_ALPH_SCP_V_11                      0x586c
#define VD3_PIP_ALPH_SCP_V_12                      0x586d
#define VD3_PIP_ALPH_SCP_V_13                      0x586e
#define VD3_PIP_ALPH_SCP_V_14                      0x586f
#define VD3_PIP_ALPH_SCP_V_15                      0x5870

#define G12_FGRAIN_CTRL                  0x4800
#define G12_FGRAIN_WIN_H                 0x4801
#define G12_FGRAIN_WIN_V                 0x4802
#define G12_VD2_FGRAIN_CTRL              0x4810
#define G12_VD2_FGRAIN_WIN_H             0x4811
#define G12_VD2_FGRAIN_WIN_V             0x4812

#define SC2_FGRAIN_CTRL                  0x4870
#define SC2_FGRAIN_WIN_H                 0x4871
#define SC2_FGRAIN_WIN_V                 0x4872
#define SC2_VD2_FGRAIN_CTRL              0x48f0
#define SC2_VD2_FGRAIN_WIN_H             0x48f1
#define SC2_VD2_FGRAIN_WIN_V             0x48f2
#define VD3_FGRAIN_CTRL                  0x4970
#define VD3_FGRAIN_WIN_H                 0x4971
#define VD3_FGRAIN_WIN_V                 0x4972

#define MALI_AFBCD_TOP_CTRL                        0x1a0f
#define VD1_HDR_IN_SIZE                            0x1a57
#define VD2_HDR_IN_SIZE                            0x1a58
#define VD3_HDR_IN_SIZE                            0x1a59
#define VPP_MISC2                                  0x1d7a
#define MALI_AFBCD1_TOP_CTRL                       0x1a55
#define MALI_AFBCD2_TOP_CTRL                       0x1a56
#define VD_PATH_MISC_CTRL                          0x1a7a
#define T7_VD2_PPS_DUMMY_DATA                      0x1a81
#define VD3_PPS_DUMMY_DATA                         0x1a82
#define VPP_VD1_DSC_CTRL                           0x1a83
#define VPP_VD2_DSC_CTRL                           0x1a84
#define VPP_VD3_DSC_CTRL                           0x1a85
#define PATH_START_SEL                             0x1a8a

#define VIU_FRM_CTRL                               0x1a51
#define VIU1_FRM_CTRL                              0x1a8d
#define VIU2_FRM_CTRL                              0x1a8e

#define VPU_VENC_CTRL                              0x1cef
#define VPU1_VENC_CTRL                             0x22ef
#define VPU2_VENC_CTRL                             0x24ef

#define VPP1_BLD_CTRL                              0x5985
#define VPP1_BLD_OUT_SIZE                          0x5986
#define VPP1_BLD_DIN0_HSCOPE                       0x5987
#define VPP1_BLD_DIN0_VSCOPE                       0x5988
#define VPP1_BLD_DIN1_HSCOPE                       0x5989
#define VPP1_BLD_DIN1_VSCOPE                       0x598a
#define VPP1_BLD_DIN2_HSCOPE                       0x598b
#define VPP1_BLD_DIN2_VSCOPE                       0x598c
#define VPP1_BLEND_BLEND_DUMMY_DATA                0x59a9
#define VPP1_BLEND_DUMMY_ALPHA                     0x59aa

#define VPP2_BLD_CTRL                              0x59c5
#define VPP2_BLD_OUT_SIZE                          0x59c6
#define VPP2_BLD_DIN0_HSCOPE                       0x59c7
#define VPP2_BLD_DIN0_VSCOPE                       0x59c8
#define VPP2_BLD_DIN1_HSCOPE                       0x59c9
#define VPP2_BLD_DIN1_VSCOPE                       0x59ca
#define VPP2_BLD_DIN2_HSCOPE                       0x59cb
#define VPP2_BLD_DIN2_VSCOPE                       0x59cc
#define VPP2_BLEND_BLEND_DUMMY_DATA                0x59e9
#define VPP2_BLEND_DUMMY_ALPHA                     0x59ea

/* aisr */
#define AISR_RESHAP_CTRL0                          0x2e40
#define AISR_RESHAP_CTRL1                          0x2e41
#define AISR_RESHAP_CTRL2                          0x2e42
#define AISR_RESHAP_SCOPE_X                        0x2e43
#define AISR_RESHAP_SCOPE_Y                        0x2e44
#define AISR_RESHAP_BADDR00                        0x2e45
#define AISR_RESHAP_BADDR01                        0x2e46
#define AISR_RESHAP_BADDR02                        0x2e47
#define AISR_RESHAP_BADDR03                        0x2e48
#define AISR_RESHAP_BADDR10                        0x2e49
#define AISR_RESHAP_BADDR11                        0x2e4a
#define AISR_RESHAP_BADDR12                        0x2e4b
#define AISR_RESHAP_BADDR13                        0x2e4c
#define AISR_RESHAP_BADDR20                        0x2e4d
#define AISR_RESHAP_BADDR21                        0x2e4e
#define AISR_RESHAP_BADDR22                        0x2e4f
#define AISR_RESHAP_BADDR23                        0x2e50
#define AISR_RESHAP_BADDR30                        0x2e51
#define AISR_RESHAP_BADDR31                        0x2e52
#define AISR_RESHAP_BADDR32                        0x2e53
#define AISR_RESHAP_BADDR33                        0x2e54
#define AISR_RESHAP_MISC                           0x2e55
#define AISR_POST_CTRL                             0x2e5a
#define AISR_POST_SIZE                             0x2e5b

#define DEMO_MODE_WINDO_CTRL0                      0x5380
#define DEMO_MODE_WINDO_CTRL1                      0x5381

#define VPP_SR0_IN_SIZE                            0x1d97
#define VPP_SR1_IN_SIZE                            0x1d98

#define VIU_VD1_PATH_CTRL                          0x1a73
#define VIU_VD2_PATH_CTRL                          0x1a74
#define VIU_VD3_PATH_CTRL                          0x1a75
#define VIU_OSD1_PATH_CTRL                         0x1a76
#define VIU_OSD2_PATH_CTRL                         0x1a77
#define VIU_OSD3_PATH_CTRL                         0x1a78
#define VIU_OSD4_PATH_CTRL                         0x1a79

#define OSD1_HDR2_CLK_GATE                         0x38a1
#define OSD2_HDR2_CLK_GATE                         0x5b51
#define VD1_HDR2_CLK_GATE                          0x3801
#define VD2_HDR2_CLK_GATE                          0x3851
#define VD3_HDR2_CLK_GATE                          0x5931

#define VPU_AXI_CACHE                              0x2733

/* noc_vpu */
#define NOC_VPU_QOS_R_OFFSET_FRC0      0x100
#define NOC_VPU_QOS_W_OFFSET_FRC0      0x300
#define NOC_VPU_QOS_R_OFFSET_FRC1      0x500
#define NOC_VPU_QOS_W_OFFSET_FRC1      0x700
#define NOC_VPU_QOS_R_OFFSET_FRC2      0x900
#define NOC_VPU_QOS_R_OFFSET_VPU0      0xb00
#define NOC_VPU_QOS_W_OFFSET_VPU0      0xd00
#define NOC_VPU_QOS_R_OFFSET_VPU1      0x1000
#define NOC_VPU_QOS_W_OFFSET_VPU1      0x1200
#define NOC_VPU_QOS_R_OFFSET_VPU2      0x1400

#endif

