/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef _TAS5805_H
#define _TAS5805_H

#include <linux/regmap.h>

static const int tas5805m_reset[][2] = {
//RESET
	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x03, 0x02 },
	{ 0x01, 0x11 },
	{ 0x00, 0x00 },
	{ 0x00, 0x00 },
	{ 0x00, 0x00 },
	{ 0x00, 0x00 },
	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x03, 0x02 },
};

static const int  tas5805m_init_sequence[][2] = {
	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x03, 0x00 },
	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x46, 0x11 },

	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x03, 0x02 },
	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x78, 0x80 },

	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x61, 0x0b },
	{ 0x60, 0x01 },

	{ 0x00, 0x00 },
	{ 0x02, 0x11 },//Fsw=384kHz, BD Mode, 1SPW Mode
	{ 0x66, 0x85 },
	{ 0x6b, 0x03 },//Enable SS
	{ 0x6c, 0x03 },//Set Tri-freq to 24Hz, SS range 336~432kHz
	{ 0x3a, 0xf8 },
	{ 0x53, 0x00 },
	{ 0x54, 0x00 },
	{ 0x00, 0x00 },
	{ 0x00, 0x00 },
	{ 0x00, 0x00 },
	{ 0x00, 0x00 },

	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x66, 0x87 },
	{ 0x7f, 0x8c },
	{ 0x00, 0x29 },
	{ 0x18, 0x00 },
	{ 0x19, 0x80 },
	{ 0x1a, 0x00 },
	{ 0x1b, 0x00 },
	{ 0x1c, 0x00 },
	{ 0x1d, 0x00 },
	{ 0x1e, 0x00 },
	{ 0x1f, 0x00 },
	{ 0x20, 0x00 },
	{ 0x21, 0x00 },
	{ 0x22, 0x00 },
	{ 0x23, 0x00 },
	{ 0x24, 0x00 },
	{ 0x25, 0x80 },
	{ 0x26, 0x00 },
	{ 0x27, 0x00 },
	{ 0x00, 0x2a },
	{ 0x24, 0x00 },
	{ 0x25, 0x28 },
	{ 0x26, 0x7a },
	{ 0x27, 0x27 },
	{ 0x28, 0x00 },
	{ 0x29, 0x28 },
	{ 0x2a, 0x7a },
	{ 0x2b, 0x27 },
	{ 0x30, 0x00 },
	{ 0x31, 0xe2 },
	{ 0x32, 0xc4 },
	{ 0x33, 0x6b },
	{ 0x00, 0x2c },
	{ 0x0c, 0x00 },
	{ 0x0d, 0x00 },
	{ 0x0e, 0x00 },
	{ 0x0f, 0x00 },
	{ 0x10, 0x00 },
	{ 0x11, 0x00 },
	{ 0x12, 0x00 },
	{ 0x13, 0x00 },
	{ 0x14, 0x00 },
	{ 0x15, 0x80 },
	{ 0x16, 0x00 },
	{ 0x17, 0x00 },
	{ 0x18, 0x00 },
	{ 0x19, 0x00 },
	{ 0x1a, 0x00 },
	{ 0x1b, 0x00 },
	{ 0x1c, 0x00 },
	{ 0x1d, 0x80 },
	{ 0x1e, 0x00 },
	{ 0x1f, 0x00 },
	{ 0x20, 0x00 },
	{ 0x21, 0x00 },
	{ 0x22, 0x00 },
	{ 0x23, 0x00 },
	{ 0x28, 0x00 },
	{ 0x29, 0x00 },
	{ 0x2a, 0x00 },
	{ 0x2b, 0x00 },
	{ 0x2c, 0x00 },
	{ 0x2d, 0x80 },
	{ 0x2e, 0x00 },
	{ 0x2f, 0x00 },
	{ 0x34, 0x00 },
	{ 0x35, 0x80 },
	{ 0x36, 0x00 },
	{ 0x37, 0x00 },
	{ 0x38, 0x00 },
	{ 0x39, 0x00 },
	{ 0x3a, 0x00 },
	{ 0x3b, 0x00 },
	{ 0x48, 0x00 },
	{ 0x49, 0x00 },
	{ 0x4a, 0x00 },
	{ 0x4b, 0x00 },
	{ 0x4c, 0x00 },
	{ 0x4d, 0x80 },
	{ 0x4e, 0x00 },
	{ 0x4f, 0x00 },
	{ 0x5c, 0x00 },
	{ 0x5d, 0x00 },
	{ 0x5e, 0xae },
	{ 0x5f, 0xc3 },
	{ 0x60, 0x01 },
	{ 0x61, 0x12 },
	{ 0x62, 0x6e },
	{ 0x63, 0x98 },
	{ 0x64, 0x08 },
	{ 0x65, 0x13 },
	{ 0x66, 0x85 },
	{ 0x67, 0x62 },
	{ 0x68, 0x40 },
	{ 0x69, 0x00 },
	{ 0x6a, 0x00 },
	{ 0x6b, 0x00 },
	{ 0x6c, 0x04 },
	{ 0x6d, 0xc1 },
	{ 0x6e, 0xff },
	{ 0x6f, 0x93 },
	{ 0x00, 0x2d },
	{ 0x18, 0x7b },
	{ 0x19, 0x3e },
	{ 0x1a, 0x00 },
	{ 0x1b, 0x6d },
	{ 0x1c, 0x00 },
	{ 0x1d, 0x00 },
	{ 0x1e, 0xae },
	{ 0x1f, 0xc3 },
	{ 0x20, 0x00 },
	{ 0x21, 0x00 },
	{ 0x22, 0x00 },
	{ 0x23, 0x00 },
	{ 0x24, 0x00 },
	{ 0x25, 0x00 },
	{ 0x26, 0x00 },
	{ 0x27, 0x00 },
	{ 0x28, 0x00 },
	{ 0x29, 0x00 },
	{ 0x2a, 0x00 },
	{ 0x2b, 0x00 },
	{ 0x2c, 0x00 },
	{ 0x2d, 0x80 },
	{ 0x2e, 0x00 },
	{ 0x2f, 0x00 },
	{ 0x00, 0x00 },
	{ 0x7f, 0xaa },
	{ 0x00, 0x24 },
	{ 0x18, 0x08 },
	{ 0x19, 0x00 },
	{ 0x1a, 0x00 },
	{ 0x1b, 0x00 },
	{ 0x1c, 0x00 },
	{ 0x1d, 0x00 },
	{ 0x1e, 0x00 },
	{ 0x1f, 0x00 },
	{ 0x20, 0x00 },
	{ 0x21, 0x00 },
	{ 0x22, 0x00 },
	{ 0x23, 0x00 },
	{ 0x24, 0x00 },
	{ 0x25, 0x00 },
	{ 0x26, 0x00 },
	{ 0x27, 0x00 },
	{ 0x28, 0x00 },
	{ 0x29, 0x00 },
	{ 0x2a, 0x00 },
	{ 0x2b, 0x00 },
	{ 0x2c, 0x08 },
	{ 0x2d, 0x00 },
	{ 0x2e, 0x00 },
	{ 0x2f, 0x00 },
	{ 0x30, 0x00 },
	{ 0x31, 0x00 },
	{ 0x32, 0x00 },
	{ 0x33, 0x00 },
	{ 0x34, 0x00 },
	{ 0x35, 0x00 },
	{ 0x36, 0x00 },
	{ 0x37, 0x00 },
	{ 0x38, 0x00 },
	{ 0x39, 0x00 },
	{ 0x3a, 0x00 },
	{ 0x3b, 0x00 },
	{ 0x3c, 0x00 },
	{ 0x3d, 0x00 },
	{ 0x3e, 0x00 },
	{ 0x3f, 0x00 },
	{ 0x40, 0x08 },
	{ 0x41, 0x00 },
	{ 0x42, 0x00 },
	{ 0x43, 0x00 },
	{ 0x44, 0x00 },
	{ 0x45, 0x00 },
	{ 0x46, 0x00 },
	{ 0x47, 0x00 },
	{ 0x48, 0x00 },
	{ 0x49, 0x00 },
	{ 0x4a, 0x00 },
	{ 0x4b, 0x00 },
	{ 0x4c, 0x00 },
	{ 0x4d, 0x00 },
	{ 0x4e, 0x00 },
	{ 0x4f, 0x00 },
	{ 0x50, 0x00 },
	{ 0x51, 0x00 },
	{ 0x52, 0x00 },
	{ 0x53, 0x00 },
	{ 0x54, 0x08 },
	{ 0x55, 0x00 },
	{ 0x56, 0x00 },
	{ 0x57, 0x00 },
	{ 0x58, 0x00 },
	{ 0x59, 0x00 },
	{ 0x5a, 0x00 },
	{ 0x5b, 0x00 },
	{ 0x5c, 0x00 },
	{ 0x5d, 0x00 },
	{ 0x5e, 0x00 },
	{ 0x5f, 0x00 },
	{ 0x60, 0x00 },
	{ 0x61, 0x00 },
	{ 0x62, 0x00 },
	{ 0x63, 0x00 },
	{ 0x64, 0x00 },
	{ 0x65, 0x00 },
	{ 0x66, 0x00 },
	{ 0x67, 0x00 },
	{ 0x68, 0x08 },
	{ 0x69, 0x00 },
	{ 0x6a, 0x00 },
	{ 0x6b, 0x00 },
	{ 0x6c, 0x00 },
	{ 0x6d, 0x00 },
	{ 0x6e, 0x00 },
	{ 0x6f, 0x00 },
	{ 0x70, 0x00 },
	{ 0x71, 0x00 },
	{ 0x72, 0x00 },
	{ 0x73, 0x00 },
	{ 0x74, 0x00 },
	{ 0x75, 0x00 },
	{ 0x76, 0x00 },
	{ 0x77, 0x00 },
	{ 0x78, 0x00 },
	{ 0x79, 0x00 },
	{ 0x7a, 0x00 },
	{ 0x7b, 0x00 },
	{ 0x7c, 0x08 },
	{ 0x7d, 0x00 },
	{ 0x7e, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x00, 0x25 },
	{ 0x08, 0x00 },
	{ 0x09, 0x00 },
	{ 0x0a, 0x00 },
	{ 0x0b, 0x00 },
	{ 0x0c, 0x00 },
	{ 0x0d, 0x00 },
	{ 0x0e, 0x00 },
	{ 0x0f, 0x00 },
	{ 0x10, 0x00 },
	{ 0x11, 0x00 },
	{ 0x12, 0x00 },
	{ 0x13, 0x00 },
	{ 0x14, 0x00 },
	{ 0x15, 0x00 },
	{ 0x16, 0x00 },
	{ 0x17, 0x00 },
	{ 0x18, 0x08 },
	{ 0x19, 0x00 },
	{ 0x1a, 0x00 },
	{ 0x1b, 0x00 },
	{ 0x1c, 0x00 },
	{ 0x1d, 0x00 },
	{ 0x1e, 0x00 },
	{ 0x1f, 0x00 },
	{ 0x20, 0x00 },
	{ 0x21, 0x00 },
	{ 0x22, 0x00 },
	{ 0x23, 0x00 },
	{ 0x24, 0x00 },
	{ 0x25, 0x00 },
	{ 0x26, 0x00 },
	{ 0x27, 0x00 },
	{ 0x28, 0x00 },
	{ 0x29, 0x00 },
	{ 0x2a, 0x00 },
	{ 0x2b, 0x00 },
	{ 0x2c, 0x08 },
	{ 0x2d, 0x00 },
	{ 0x2e, 0x00 },
	{ 0x2f, 0x00 },
	{ 0x30, 0x00 },
	{ 0x31, 0x00 },
	{ 0x32, 0x00 },
	{ 0x33, 0x00 },
	{ 0x34, 0x00 },
	{ 0x35, 0x00 },
	{ 0x36, 0x00 },
	{ 0x37, 0x00 },
	{ 0x38, 0x00 },
	{ 0x39, 0x00 },
	{ 0x3a, 0x00 },
	{ 0x3b, 0x00 },
	{ 0x3c, 0x00 },
	{ 0x3d, 0x00 },
	{ 0x3e, 0x00 },
	{ 0x3f, 0x00 },
	{ 0x40, 0x08 },
	{ 0x41, 0x00 },
	{ 0x42, 0x00 },
	{ 0x43, 0x00 },
	{ 0x44, 0x00 },
	{ 0x45, 0x00 },
	{ 0x46, 0x00 },
	{ 0x47, 0x00 },
	{ 0x48, 0x00 },
	{ 0x49, 0x00 },
	{ 0x4a, 0x00 },
	{ 0x4b, 0x00 },
	{ 0x4c, 0x00 },
	{ 0x4d, 0x00 },
	{ 0x4e, 0x00 },
	{ 0x4f, 0x00 },
	{ 0x50, 0x00 },
	{ 0x51, 0x00 },
	{ 0x52, 0x00 },
	{ 0x53, 0x00 },
	{ 0x54, 0x08 },
	{ 0x55, 0x00 },
	{ 0x56, 0x00 },
	{ 0x57, 0x00 },
	{ 0x58, 0x00 },
	{ 0x59, 0x00 },
	{ 0x5a, 0x00 },
	{ 0x5b, 0x00 },
	{ 0x5c, 0x00 },
	{ 0x5d, 0x00 },
	{ 0x5e, 0x00 },
	{ 0x5f, 0x00 },
	{ 0x60, 0x00 },
	{ 0x61, 0x00 },
	{ 0x62, 0x00 },
	{ 0x63, 0x00 },
	{ 0x64, 0x00 },
	{ 0x65, 0x00 },
	{ 0x66, 0x00 },
	{ 0x67, 0x00 },
	{ 0x68, 0x08 },
	{ 0x69, 0x00 },
	{ 0x6a, 0x00 },
	{ 0x6b, 0x00 },
	{ 0x6c, 0x00 },
	{ 0x6d, 0x00 },
	{ 0x6e, 0x00 },
	{ 0x6f, 0x00 },
	{ 0x70, 0x00 },
	{ 0x71, 0x00 },
	{ 0x72, 0x00 },
	{ 0x73, 0x00 },
	{ 0x74, 0x00 },
	{ 0x75, 0x00 },
	{ 0x76, 0x00 },
	{ 0x77, 0x00 },
	{ 0x78, 0x00 },
	{ 0x79, 0x00 },
	{ 0x7a, 0x00 },
	{ 0x7b, 0x00 },
	{ 0x7c, 0x08 },
	{ 0x7d, 0x00 },
	{ 0x7e, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x00, 0x26 },
	{ 0x08, 0x00 },
	{ 0x09, 0x00 },
	{ 0x0a, 0x00 },
	{ 0x0b, 0x00 },
	{ 0x0c, 0x00 },
	{ 0x0d, 0x00 },
	{ 0x0e, 0x00 },
	{ 0x0f, 0x00 },
	{ 0x10, 0x00 },
	{ 0x11, 0x00 },
	{ 0x12, 0x00 },
	{ 0x13, 0x00 },
	{ 0x14, 0x00 },
	{ 0x15, 0x00 },
	{ 0x16, 0x00 },
	{ 0x17, 0x00 },
	{ 0x18, 0x08 },
	{ 0x19, 0x00 },
	{ 0x1a, 0x00 },
	{ 0x1b, 0x00 },
	{ 0x1c, 0x00 },
	{ 0x1d, 0x00 },
	{ 0x1e, 0x00 },
	{ 0x1f, 0x00 },
	{ 0x20, 0x00 },
	{ 0x21, 0x00 },
	{ 0x22, 0x00 },
	{ 0x23, 0x00 },
	{ 0x24, 0x00 },
	{ 0x25, 0x00 },
	{ 0x26, 0x00 },
	{ 0x27, 0x00 },
	{ 0x28, 0x00 },
	{ 0x29, 0x00 },
	{ 0x2a, 0x00 },
	{ 0x2b, 0x00 },
	{ 0x2c, 0x08 },
	{ 0x2d, 0x00 },
	{ 0x2e, 0x00 },
	{ 0x2f, 0x00 },
	{ 0x30, 0x00 },
	{ 0x31, 0x00 },
	{ 0x32, 0x00 },
	{ 0x33, 0x00 },
	{ 0x34, 0x00 },
	{ 0x35, 0x00 },
	{ 0x36, 0x00 },
	{ 0x37, 0x00 },
	{ 0x38, 0x00 },
	{ 0x39, 0x00 },
	{ 0x3a, 0x00 },
	{ 0x3b, 0x00 },
	{ 0x3c, 0x00 },
	{ 0x3d, 0x00 },
	{ 0x3e, 0x00 },
	{ 0x3f, 0x00 },
	{ 0x40, 0x08 },
	{ 0x41, 0x00 },
	{ 0x42, 0x00 },
	{ 0x43, 0x00 },
	{ 0x44, 0x00 },
	{ 0x45, 0x00 },
	{ 0x46, 0x00 },
	{ 0x47, 0x00 },
	{ 0x48, 0x00 },
	{ 0x49, 0x00 },
	{ 0x4a, 0x00 },
	{ 0x4b, 0x00 },
	{ 0x4c, 0x00 },
	{ 0x4d, 0x00 },
	{ 0x4e, 0x00 },
	{ 0x4f, 0x00 },
	{ 0x50, 0x00 },
	{ 0x51, 0x00 },
	{ 0x52, 0x00 },
	{ 0x53, 0x00 },
	{ 0x54, 0x08 },
	{ 0x55, 0x00 },
	{ 0x56, 0x00 },
	{ 0x57, 0x00 },
	{ 0x58, 0x00 },
	{ 0x59, 0x00 },
	{ 0x5a, 0x00 },
	{ 0x5b, 0x00 },
	{ 0x5c, 0x00 },
	{ 0x5d, 0x00 },
	{ 0x5e, 0x00 },
	{ 0x5f, 0x00 },
	{ 0x60, 0x00 },
	{ 0x61, 0x00 },
	{ 0x62, 0x00 },
	{ 0x63, 0x00 },
	{ 0x64, 0x00 },
	{ 0x65, 0x00 },
	{ 0x66, 0x00 },
	{ 0x67, 0x00 },
	{ 0x68, 0x08 },
	{ 0x69, 0x00 },
	{ 0x6a, 0x00 },
	{ 0x6b, 0x00 },
	{ 0x6c, 0x00 },
	{ 0x6d, 0x00 },
	{ 0x6e, 0x00 },
	{ 0x6f, 0x00 },
	{ 0x70, 0x00 },
	{ 0x71, 0x00 },
	{ 0x72, 0x00 },
	{ 0x73, 0x00 },
	{ 0x74, 0x00 },
	{ 0x75, 0x00 },
	{ 0x76, 0x00 },
	{ 0x77, 0x00 },
	{ 0x78, 0x00 },
	{ 0x79, 0x00 },
	{ 0x7a, 0x00 },
	{ 0x7b, 0x00 },
	{ 0x7c, 0x08 },
	{ 0x7d, 0x00 },
	{ 0x7e, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x00, 0x27 },
	{ 0x08, 0x00 },
	{ 0x09, 0x00 },
	{ 0x0a, 0x00 },
	{ 0x0b, 0x00 },
	{ 0x0c, 0x00 },
	{ 0x0d, 0x00 },
	{ 0x0e, 0x00 },
	{ 0x0f, 0x00 },
	{ 0x10, 0x00 },
	{ 0x11, 0x00 },
	{ 0x12, 0x00 },
	{ 0x13, 0x00 },
	{ 0x14, 0x00 },
	{ 0x15, 0x00 },
	{ 0x16, 0x00 },
	{ 0x17, 0x00 },
	{ 0x18, 0x08 },
	{ 0x19, 0x00 },
	{ 0x1a, 0x00 },
	{ 0x1b, 0x00 },
	{ 0x1c, 0x00 },
	{ 0x1d, 0x00 },
	{ 0x1e, 0x00 },
	{ 0x1f, 0x00 },
	{ 0x20, 0x00 },
	{ 0x21, 0x00 },
	{ 0x22, 0x00 },
	{ 0x23, 0x00 },
	{ 0x24, 0x00 },
	{ 0x25, 0x00 },
	{ 0x26, 0x00 },
	{ 0x27, 0x00 },
	{ 0x28, 0x00 },
	{ 0x29, 0x00 },
	{ 0x2a, 0x00 },
	{ 0x2b, 0x00 },
	{ 0x2c, 0x08 },
	{ 0x2d, 0x00 },
	{ 0x2e, 0x00 },
	{ 0x2f, 0x00 },
	{ 0x30, 0x00 },
	{ 0x31, 0x00 },
	{ 0x32, 0x00 },
	{ 0x33, 0x00 },
	{ 0x34, 0x00 },
	{ 0x35, 0x00 },
	{ 0x36, 0x00 },
	{ 0x37, 0x00 },
	{ 0x38, 0x00 },
	{ 0x39, 0x00 },
	{ 0x3a, 0x00 },
	{ 0x3b, 0x00 },
	{ 0x3c, 0x00 },
	{ 0x3d, 0x00 },
	{ 0x3e, 0x00 },
	{ 0x3f, 0x00 },
	{ 0x40, 0x08 },
	{ 0x41, 0x00 },
	{ 0x42, 0x00 },
	{ 0x43, 0x00 },
	{ 0x44, 0x00 },
	{ 0x45, 0x00 },
	{ 0x46, 0x00 },
	{ 0x47, 0x00 },
	{ 0x48, 0x00 },
	{ 0x49, 0x00 },
	{ 0x4a, 0x00 },
	{ 0x4b, 0x00 },
	{ 0x4c, 0x00 },
	{ 0x4d, 0x00 },
	{ 0x4e, 0x00 },
	{ 0x4f, 0x00 },
	{ 0x50, 0x00 },
	{ 0x51, 0x00 },
	{ 0x52, 0x00 },
	{ 0x53, 0x00 },
	{ 0x54, 0x08 },
	{ 0x55, 0x00 },
	{ 0x56, 0x00 },
	{ 0x57, 0x00 },
	{ 0x58, 0x00 },
	{ 0x59, 0x00 },
	{ 0x5a, 0x00 },
	{ 0x5b, 0x00 },
	{ 0x5c, 0x00 },
	{ 0x5d, 0x00 },
	{ 0x5e, 0x00 },
	{ 0x5f, 0x00 },
	{ 0x60, 0x00 },
	{ 0x61, 0x00 },
	{ 0x62, 0x00 },
	{ 0x63, 0x00 },
	{ 0x64, 0x00 },
	{ 0x65, 0x00 },
	{ 0x66, 0x00 },
	{ 0x67, 0x00 },
	{ 0x68, 0x08 },
	{ 0x69, 0x00 },
	{ 0x6a, 0x00 },
	{ 0x6b, 0x00 },
	{ 0x6c, 0x00 },
	{ 0x6d, 0x00 },
	{ 0x6e, 0x00 },
	{ 0x6f, 0x00 },
	{ 0x70, 0x00 },
	{ 0x71, 0x00 },
	{ 0x72, 0x00 },
	{ 0x73, 0x00 },
	{ 0x74, 0x00 },
	{ 0x75, 0x00 },
	{ 0x76, 0x00 },
	{ 0x77, 0x00 },
	{ 0x78, 0x00 },
	{ 0x79, 0x00 },
	{ 0x7a, 0x00 },
	{ 0x7b, 0x00 },
	{ 0x7c, 0x08 },
	{ 0x7d, 0x00 },
	{ 0x7e, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x00, 0x28 },
	{ 0x08, 0x00 },
	{ 0x09, 0x00 },
	{ 0x0a, 0x00 },
	{ 0x0b, 0x00 },
	{ 0x0c, 0x00 },
	{ 0x0d, 0x00 },
	{ 0x0e, 0x00 },
	{ 0x0f, 0x00 },
	{ 0x10, 0x00 },
	{ 0x11, 0x00 },
	{ 0x12, 0x00 },
	{ 0x13, 0x00 },
	{ 0x14, 0x00 },
	{ 0x15, 0x00 },
	{ 0x16, 0x00 },
	{ 0x17, 0x00 },
	{ 0x18, 0x08 },
	{ 0x19, 0x00 },
	{ 0x1a, 0x00 },
	{ 0x1b, 0x00 },
	{ 0x1c, 0x00 },
	{ 0x1d, 0x00 },
	{ 0x1e, 0x00 },
	{ 0x1f, 0x00 },
	{ 0x20, 0x00 },
	{ 0x21, 0x00 },
	{ 0x22, 0x00 },
	{ 0x23, 0x00 },
	{ 0x24, 0x00 },
	{ 0x25, 0x00 },
	{ 0x26, 0x00 },
	{ 0x27, 0x00 },
	{ 0x28, 0x00 },
	{ 0x29, 0x00 },
	{ 0x2a, 0x00 },
	{ 0x2b, 0x00 },
	{ 0x2c, 0x08 },
	{ 0x2d, 0x00 },
	{ 0x2e, 0x00 },
	{ 0x2f, 0x00 },
	{ 0x30, 0x00 },
	{ 0x31, 0x00 },
	{ 0x32, 0x00 },
	{ 0x33, 0x00 },
	{ 0x34, 0x00 },
	{ 0x35, 0x00 },
	{ 0x36, 0x00 },
	{ 0x37, 0x00 },
	{ 0x38, 0x00 },
	{ 0x39, 0x00 },
	{ 0x3a, 0x00 },
	{ 0x3b, 0x00 },
	{ 0x3c, 0x00 },
	{ 0x3d, 0x00 },
	{ 0x3e, 0x00 },
	{ 0x3f, 0x00 },
	{ 0x40, 0x08 },
	{ 0x41, 0x00 },
	{ 0x42, 0x00 },
	{ 0x43, 0x00 },
	{ 0x44, 0x00 },
	{ 0x45, 0x00 },
	{ 0x46, 0x00 },
	{ 0x47, 0x00 },
	{ 0x48, 0x00 },
	{ 0x49, 0x00 },
	{ 0x4a, 0x00 },
	{ 0x4b, 0x00 },
	{ 0x4c, 0x00 },
	{ 0x4d, 0x00 },
	{ 0x4e, 0x00 },
	{ 0x4f, 0x00 },
	{ 0x50, 0x00 },
	{ 0x51, 0x00 },
	{ 0x52, 0x00 },
	{ 0x53, 0x00 },
	{ 0x54, 0x08 },
	{ 0x55, 0x00 },
	{ 0x56, 0x00 },
	{ 0x57, 0x00 },
	{ 0x58, 0x00 },
	{ 0x59, 0x00 },
	{ 0x5a, 0x00 },
	{ 0x5b, 0x00 },
	{ 0x5c, 0x00 },
	{ 0x5d, 0x00 },
	{ 0x5e, 0x00 },
	{ 0x5f, 0x00 },
	{ 0x60, 0x00 },
	{ 0x61, 0x00 },
	{ 0x62, 0x00 },
	{ 0x63, 0x00 },
	{ 0x64, 0x00 },
	{ 0x65, 0x00 },
	{ 0x66, 0x00 },
	{ 0x67, 0x00 },
	{ 0x68, 0x08 },
	{ 0x69, 0x00 },
	{ 0x6a, 0x00 },
	{ 0x6b, 0x00 },
	{ 0x6c, 0x00 },
	{ 0x6d, 0x00 },
	{ 0x6e, 0x00 },
	{ 0x6f, 0x00 },
	{ 0x70, 0x00 },
	{ 0x71, 0x00 },
	{ 0x72, 0x00 },
	{ 0x73, 0x00 },
	{ 0x74, 0x00 },
	{ 0x75, 0x00 },
	{ 0x76, 0x00 },
	{ 0x77, 0x00 },
	{ 0x78, 0x00 },
	{ 0x79, 0x00 },
	{ 0x7a, 0x00 },
	{ 0x7b, 0x00 },
	{ 0x7c, 0x08 },
	{ 0x7d, 0x00 },
	{ 0x7e, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x00, 0x29 },
	{ 0x08, 0x00 },
	{ 0x09, 0x00 },
	{ 0x0a, 0x00 },
	{ 0x0b, 0x00 },
	{ 0x0c, 0x00 },
	{ 0x0d, 0x00 },
	{ 0x0e, 0x00 },
	{ 0x0f, 0x00 },
	{ 0x10, 0x00 },
	{ 0x11, 0x00 },
	{ 0x12, 0x00 },
	{ 0x13, 0x00 },
	{ 0x14, 0x00 },
	{ 0x15, 0x00 },
	{ 0x16, 0x00 },
	{ 0x17, 0x00 },
	{ 0x00, 0x2e },
	{ 0x7c, 0x08 },
	{ 0x7d, 0x00 },
	{ 0x7e, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x00, 0x2f },
	{ 0x08, 0x00 },
	{ 0x09, 0x00 },
	{ 0x0a, 0x00 },
	{ 0x0b, 0x00 },
	{ 0x0c, 0x00 },
	{ 0x0d, 0x00 },
	{ 0x0e, 0x00 },
	{ 0x0f, 0x00 },
	{ 0x10, 0x00 },
	{ 0x11, 0x00 },
	{ 0x12, 0x00 },
	{ 0x13, 0x00 },
	{ 0x14, 0x00 },
	{ 0x15, 0x00 },
	{ 0x16, 0x00 },
	{ 0x17, 0x00 },
	{ 0x1c, 0x08 },
	{ 0x1d, 0x00 },
	{ 0x1e, 0x00 },
	{ 0x1f, 0x00 },
	{ 0x20, 0x00 },
	{ 0x21, 0x00 },
	{ 0x22, 0x00 },
	{ 0x23, 0x00 },
	{ 0x24, 0x00 },
	{ 0x25, 0x00 },
	{ 0x26, 0x00 },
	{ 0x27, 0x00 },
	{ 0x28, 0x00 },
	{ 0x29, 0x00 },
	{ 0x2a, 0x00 },
	{ 0x2b, 0x00 },
	{ 0x2c, 0x00 },
	{ 0x2d, 0x00 },
	{ 0x2e, 0x00 },
	{ 0x2f, 0x00 },
	{ 0x00, 0x2a },
	{ 0x48, 0x00 },
	{ 0x49, 0x05 },
	{ 0x4a, 0x83 },
	{ 0x4b, 0x2a },
	{ 0x4c, 0x00 },
	{ 0x4d, 0x05 },
	{ 0x4e, 0x83 },
	{ 0x4f, 0x2a },
	{ 0x50, 0x00 },
	{ 0x51, 0x05 },
	{ 0x52, 0x83 },
	{ 0x53, 0x2a },
	{ 0x54, 0x7d },
	{ 0x55, 0xa1 },
	{ 0x56, 0x77 },
	{ 0x57, 0x3d },
	{ 0x58, 0x84 },
	{ 0x59, 0xa7 },
	{ 0x5a, 0x04 },
	{ 0x5b, 0xdf },
	{ 0x00, 0x00 },
	{ 0x7f, 0x8c },
	{ 0x00, 0x2b },
	{ 0x34, 0x00 },
	{ 0x35, 0x1b },
	{ 0x36, 0x4b },
	{ 0x37, 0x98 },
	{ 0x38, 0x00 },
	{ 0x39, 0x1b },
	{ 0x3a, 0x4b },
	{ 0x3b, 0x98 },
	{ 0x3c, 0x00 },
	{ 0x3d, 0x0d },
	{ 0x3e, 0xa6 },
	{ 0x3f, 0x86 },
	{ 0x40, 0x00 },
	{ 0x41, 0x00 },
	{ 0x42, 0x00 },
	{ 0x43, 0x00 },
	{ 0x44, 0x00 },
	{ 0x45, 0x00 },
	{ 0x46, 0x00 },
	{ 0x47, 0x00 },
	{ 0x48, 0xff },
	{ 0x49, 0x81 },
	{ 0x4a, 0x47 },
	{ 0x4b, 0xae },
	{ 0x4c, 0xf9 },
	{ 0x4d, 0x06 },
	{ 0x4e, 0x21 },
	{ 0x4f, 0xa9 },
	{ 0x50, 0xfe },
	{ 0x51, 0x01 },
	{ 0x52, 0xc0 },
	{ 0x53, 0x79 },
	{ 0x54, 0x00 },
	{ 0x55, 0x00 },
	{ 0x56, 0x00 },
	{ 0x57, 0x00 },
	{ 0x58, 0x00 },
	{ 0x59, 0x00 },
	{ 0x5a, 0x00 },
	{ 0x5b, 0x00 },
	{ 0x00, 0x2d },
	{ 0x58, 0x02 },
	{ 0x59, 0xa3 },
	{ 0x5a, 0x9a },
	{ 0x5b, 0xcc },
	{ 0x5c, 0x02 },
	{ 0x5d, 0xa3 },
	{ 0x5e, 0x9a },
	{ 0x5f, 0xcc },
	{ 0x60, 0x00 },
	{ 0x61, 0x44 },
	{ 0x62, 0x32 },
	{ 0x63, 0x13 },
	{ 0x64, 0x00 },
	{ 0x65, 0x00 },
	{ 0x66, 0x00 },
	{ 0x67, 0x00 },
	{ 0x68, 0x00 },
	{ 0x69, 0x00 },
	{ 0x6a, 0x00 },
	{ 0x6b, 0x00 },
	{ 0x6c, 0xff },
	{ 0x6d, 0x81 },
	{ 0x6e, 0x47 },
	{ 0x6f, 0xae },
	{ 0x70, 0xf9 },
	{ 0x71, 0x06 },
	{ 0x72, 0x21 },
	{ 0x73, 0xa9 },
	{ 0x74, 0xfe },
	{ 0x75, 0x01 },
	{ 0x76, 0xc0 },
	{ 0x77, 0x79 },
	{ 0x78, 0x00 },
	{ 0x79, 0x00 },
	{ 0x7a, 0x00 },
	{ 0x7b, 0x00 },
	{ 0x7c, 0x00 },
	{ 0x7d, 0x00 },
	{ 0x7e, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x00, 0x00 },
	{ 0x7f, 0xaa },
	{ 0x00, 0x2e },
	{ 0x40, 0x06 },
	{ 0x41, 0x55 },
	{ 0x42, 0xaf },
	{ 0x43, 0xd8 },
	{ 0x44, 0x06 },
	{ 0x45, 0x55 },
	{ 0x46, 0xaf },
	{ 0x47, 0xd8 },
	{ 0x48, 0x06 },
	{ 0x49, 0x55 },
	{ 0x4a, 0xaf },
	{ 0x4b, 0xd8 },
	{ 0x4c, 0x51 },
	{ 0x4d, 0xe5 },
	{ 0x4e, 0x7f },
	{ 0x4f, 0x65 },
	{ 0x50, 0xc2 },
	{ 0x51, 0xde },
	{ 0x52, 0x41 },
	{ 0x53, 0xd5 },
	{ 0x00, 0x2b },
	{ 0x20, 0x58 },
	{ 0x21, 0x3b },
	{ 0x22, 0x2f },
	{ 0x23, 0x3d },
	{ 0x24, 0xa7 },
	{ 0x25, 0xc4 },
	{ 0x26, 0xd0 },
	{ 0x27, 0xc3 },
	{ 0x28, 0x58 },
	{ 0x29, 0x3b },
	{ 0x2a, 0x2f },
	{ 0x2b, 0x3d },
	{ 0x2c, 0x51 },
	{ 0x2d, 0xe5 },
	{ 0x2e, 0x7f },
	{ 0x2f, 0x65 },
	{ 0x30, 0xc2 },
	{ 0x31, 0xde },
	{ 0x32, 0x41 },
	{ 0x33, 0xd5 },
	{ 0x0c, 0x58 },
	{ 0x0d, 0x3b },
	{ 0x0e, 0x2f },
	{ 0x0f, 0x3d },
	{ 0x10, 0xa7 },
	{ 0x11, 0xc4 },
	{ 0x12, 0xd0 },
	{ 0x13, 0xc3 },
	{ 0x14, 0x58 },
	{ 0x15, 0x3b },
	{ 0x16, 0x2f },
	{ 0x17, 0x3d },
	{ 0x18, 0x51 },
	{ 0x19, 0xe5 },
	{ 0x1a, 0x7f },
	{ 0x1b, 0x65 },
	{ 0x1c, 0xc2 },
	{ 0x1d, 0xde },
	{ 0x1e, 0x41 },
	{ 0x1f, 0xd5 },
	{ 0x00, 0x2a },
	{ 0x34, 0x00 },
	{ 0x35, 0x05 },
	{ 0x36, 0x83 },
	{ 0x37, 0x2a },
	{ 0x38, 0x00 },
	{ 0x39, 0x05 },
	{ 0x3a, 0x83 },
	{ 0x3b, 0x2a },
	{ 0x3c, 0x00 },
	{ 0x3d, 0x05 },
	{ 0x3e, 0x83 },
	{ 0x3f, 0x2a },
	{ 0x40, 0x7d },
	{ 0x41, 0xa1 },
	{ 0x42, 0x77 },
	{ 0x43, 0x3d },
	{ 0x44, 0x84 },
	{ 0x45, 0xa7 },
	{ 0x46, 0x04 },
	{ 0x47, 0xdf },
	{ 0x00, 0x00 },
	{ 0x7f, 0x8c },
	{ 0x00, 0x2d },
	{ 0x30, 0x02 },
	{ 0x31, 0xa3 },
	{ 0x32, 0x9a },
	{ 0x33, 0xcc },
	{ 0x34, 0x02 },
	{ 0x35, 0xa3 },
	{ 0x36, 0x9a },
	{ 0x37, 0xcc },
	{ 0x38, 0x00 },
	{ 0x39, 0x06 },
	{ 0x3a, 0xd3 },
	{ 0x3b, 0x72 },
	{ 0x3c, 0x00 },
	{ 0x3d, 0x00 },
	{ 0x3e, 0x00 },
	{ 0x3f, 0x00 },
	{ 0x40, 0x00 },
	{ 0x41, 0x00 },
	{ 0x42, 0x00 },
	{ 0x43, 0x00 },
	{ 0x44, 0xff },
	{ 0x45, 0x81 },
	{ 0x46, 0x47 },
	{ 0x47, 0xae },
	{ 0x48, 0xf9 },
	{ 0x49, 0x06 },
	{ 0x4a, 0x21 },
	{ 0x4b, 0xa9 },
	{ 0x4c, 0xfe },
	{ 0x4d, 0x01 },
	{ 0x4e, 0xc0 },
	{ 0x4f, 0x79 },
	{ 0x50, 0x00 },
	{ 0x51, 0x00 },
	{ 0x52, 0x00 },
	{ 0x53, 0x00 },
	{ 0x54, 0x00 },
	{ 0x55, 0x00 },
	{ 0x56, 0x00 },
	{ 0x57, 0x00 },
	{ 0x00, 0x00 },
	{ 0x7f, 0xaa },
	{ 0x00, 0x2a },
	{ 0x5c, 0x7d },
	{ 0x5d, 0xa6 },
	{ 0x5e, 0xfa },
	{ 0x5f, 0x66 },
	{ 0x60, 0x82 },
	{ 0x61, 0x59 },
	{ 0x62, 0x05 },
	{ 0x63, 0x9a },
	{ 0x64, 0x7d },
	{ 0x65, 0xa6 },
	{ 0x66, 0xfa },
	{ 0x67, 0x66 },
	{ 0x68, 0x7d },
	{ 0x69, 0xa1 },
	{ 0x6a, 0x77 },
	{ 0x6b, 0x3d },
	{ 0x6c, 0x84 },
	{ 0x6d, 0xa7 },
	{ 0x6e, 0x04 },
	{ 0x6f, 0xdf },
	{ 0x70, 0x7d },
	{ 0x71, 0xa6 },
	{ 0x72, 0xfa },
	{ 0x73, 0x66 },
	{ 0x74, 0x82 },
	{ 0x75, 0x59 },
	{ 0x76, 0x05 },
	{ 0x77, 0x9a },
	{ 0x78, 0x7d },
	{ 0x79, 0xa6 },
	{ 0x7a, 0xfa },
	{ 0x7b, 0x66 },
	{ 0x7c, 0x7d },
	{ 0x7d, 0xa1 },
	{ 0x7e, 0x77 },
	{ 0x7f, 0x3d },
	{ 0x00, 0x2b },
	{ 0x08, 0x84 },
	{ 0x09, 0xa7 },
	{ 0x0a, 0x04 },
	{ 0x0b, 0xdf },
	{ 0x00, 0x2e },
	{ 0x54, 0x06 },
	{ 0x55, 0x55 },
	{ 0x56, 0xaf },
	{ 0x57, 0xd8 },
	{ 0x58, 0x06 },
	{ 0x59, 0x55 },
	{ 0x5a, 0xaf },
	{ 0x5b, 0xd8 },
	{ 0x5c, 0x06 },
	{ 0x5d, 0x55 },
	{ 0x5e, 0xaf },
	{ 0x5f, 0xd8 },
	{ 0x60, 0x51 },
	{ 0x61, 0xe5 },
	{ 0x62, 0x7f },
	{ 0x63, 0x65 },
	{ 0x64, 0xc2 },
	{ 0x65, 0xde },
	{ 0x66, 0x41 },
	{ 0x67, 0xd5 },
	{ 0x00, 0x00 },
	{ 0x7f, 0x8c },
	{ 0x00, 0x2e },
	{ 0x10, 0x00 },
	{ 0x11, 0x80 },
	{ 0x12, 0x00 },
	{ 0x13, 0x00 },
	{ 0x0c, 0x00 },
	{ 0x0d, 0x80 },
	{ 0x0e, 0x00 },
	{ 0x0f, 0x00 },
	{ 0x08, 0x00 },
	{ 0x09, 0x80 },
	{ 0x0a, 0x00 },
	{ 0x0b, 0x00 },
	{ 0x18, 0x00 },
	{ 0x19, 0x80 },
	{ 0x1a, 0x00 },
	{ 0x1b, 0x00 },
	{ 0x1c, 0x40 },
	{ 0x1d, 0x00 },
	{ 0x1e, 0x00 },
	{ 0x1f, 0x00 },
	{ 0x20, 0x40 },
	{ 0x21, 0x00 },
	{ 0x22, 0x00 },
	{ 0x23, 0x00 },

//Register Tuning
	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x30, 0x00 },
	{ 0x4c, 0x30 },
	{ 0x03, 0x03 },
	{ 0x02, 0x11 },//Fsw=384kHz, 1SPW Mode

	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x78, 0x80 },
};

struct tas5805m_platform_data {
	int reset_pin;
};

#endif
