#!/bin/sh

#
# Copyright (C) 2022 Liberty Global Service B.V.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2
# of the license.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this library; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
#

set -e
set -u

NAME=$1
BDIR=$2
INC_GUARD=__${NAME}_h__
PREFIX=${NAME}_blob_offset
BLOB=${NAME}_blob
OBJNAME=${BDIR}/${NAME}.bin.o
BINARY=${BDIR}/${NAME}.bin

AWK_CMD='$2 ~ /^[tT]$/ { print "#define '$PREFIX'" $3 " 0x" $1; }'

cat << EOF
/* Autogenerated by $0, do not edit */
#ifndef $INC_GUARD
#define $INC_GUARD

EOF

nm $OBJNAME | grep "__parasite_" | tr . _ | awk "$AWK_CMD"

cat << EOF

static unsigned char __attribute__((__used__)) $BLOB[] = {
EOF

hexdump -v -e '"\t" 8/1 "0x%02x, " "\n"' $BINARY

cat << EOF
};

#endif /* $INC_GUARD */
EOF
