# Copyright (c) 2021-2022 Amlogic, Inc. All rights reserved.

# SPDX-License-Identifier: MIT

include("${CMAKE_CURRENT_LIST_DIR}/find_compiler.cmake")

set(CMAKE_SYSTEM_NAME Generic)

if(CONFIG_TOOLCHAIN_CLANG_LLVM)
	# Find CLANG for ARM.
	message(STATUS "Override the toolchain with CLANG+LLVM")
	aml_find_compiler(COMPILER_CC_CLANG clang)
	aml_find_compiler(COMPILER_CXX_CLANG clang)
	set(COMPILER_ASM "${COMPILER_CC_CLANG}" CACHE INTERNAL "" FORCE)
	aml_find_compiler(COMPILER_OBJCOPY_CLANG clang)
	aml_find_compiler(COMPILER_OBJDUMP_CLANG clang)

	# Specify the compiler.
	set(CMAKE_C_COMPILER ${COMPILER_CC_CLANG} CACHE FILEPATH "C compiler" FORCE)
	set(CMAKE_CXX_COMPILER ${COMPILER_CXX_CLANG} CACHE FILEPATH "C++ compiler" FORCE)
	#set(CMAKE_C_LINK_EXECUTABLE ${COMPILER_LD} CACHE FILEPATH "LD linker" FORCE)
	set(CMAKE_OBJCOPY_COMPILER ${COMPILER_OBJCOPY_CLANG} CACHE FILEPATH "objcopy compiler" FORCE)
	set(CMAKE_OBJDUMP_COMPILER ${COMPILER_OBJDUMP_CLANG} CACHE FILEPATH "objdump compiler" FORCE)
	# Disable compiler checks.
	set(CMAKE_C_COMPILER_FORCED TRUE FORCE)
	set(CMAKE_CXX_COMPILER_FORCED TRUE FORCE)

	# Add target system root to cmake find path.
	get_filename_component(COMPILER_DIR "${COMPILER_CC_CLANG}" DIRECTORY)
	get_filename_component(CMAKE_FIND_ROOT_PATH "${COMPILER_DIR}" DIRECTORY)

	# Look for includes and libraries only in the target system prefix.
	#set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
	#set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)

	# Helper variables to abstracts some common compiler flags.
	set(COMPILER_NO_WARNINGS "-w" CACHE INTERNAL "" FORCE)
else()
	# Find GCC for ARM.
	message(STATUS "Override the toolchain with GCC")
	aml_find_compiler(COMPILER_CC aarch64-none-elf-gcc)
	aml_find_compiler(COMPILER_CXX aarch64-none-elf-g++)
	set(COMPILER_ASM "${COMPILER_CC}" CACHE FILEPATH "" FORCE)
	aml_find_compiler(COMPILER_OBJCOPY aarch64-none-elf-objcopy)
	aml_find_compiler(COMPILER_OBJDUMP aarch64-none-elf-objdump)

	# Specify the compiler.
	set(CMAKE_C_COMPILER ${COMPILER_CC} CACHE FILEPATH "C compiler" FORCE)
	set(CMAKE_CXX_COMPILER ${COMPILER_CXX} CACHE FILEPATH "C++ compiler" FORCE)
	set(CMAKE_ASM_COMPILER ${COMPILER_ASM} CACHE FILEPATH "ASM compiler" FORCE)
	#set(CMAKE_C_LINK_EXECUTABLE ${COMPILER_LD} CACHE FILEPATH "LD linker" FORCE)
	set(CMAKE_OBJCOPY_COMPILER ${COMPILER_OBJCOPY} CACHE FILEPATH "objcopy compiler" FORCE)
	set(CMAKE_OBJDUMP_COMPILER ${COMPILER_OBJDUMP} CACHE FILEPATH "objdump compiler" FORCE)
	# Disable compiler checks.
	set(CMAKE_C_COMPILER_FORCED TRUE FORCE)
	set(CMAKE_CXX_COMPILER_FORCED TRUE FORCE)

	# Add target system root to cmake find path.
	get_filename_component(COMPILER_DIR "${COMPILER_CC}" DIRECTORY)
	get_filename_component(CMAKE_FIND_ROOT_PATH "${COMPILER_DIR}" DIRECTORY)

	# Look for includes and libraries only in the target system prefix.
	#set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
	#set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)

	# Helper variables to abstracts some common compiler flags.
	set(COMPILER_NO_WARNINGS "-w" CACHE INTERNAL "" FORCE)
endif()
