/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * arch/arm/include/asm/arch-txhd/secure_apb.h
 *
 * Copyright (C) 2020 Amlogic, Inc. All rights reserved.
 *
 */

#include <asm/arch/regs.h>

#ifdef SECURE_APB_H
#else
#define SECURE_APB_H

//
// Reading file:  ./secure_apb4_ee.h
//
// synopsys translate_off
// synopsys translate_on
//========================================================================
//  RNG
//========================================================================
//  APB4_DECODER_NON_SECURE_BASE     32'hFF634000
//  APB4_DECODER_SECURE_BASE         32'hFF634000
#define     RNG_SEC_CONFIG_REG1                                (0xff634000 + (0x01 << 2))
#define SEC_RNG_SEC_CONFIG_REG1                                (0xff634000 + (0x01 << 2))
#define   P_RNG_SEC_CONFIG_REG1                                (volatile uint32_t *)(0xff634000 + (0x01 << 2))
#define     RNG_SEC_CONFIG_REG2                                (0xff634000 + (0x02 << 2))
#define SEC_RNG_SEC_CONFIG_REG2                                (0xff634000 + (0x02 << 2))
#define   P_RNG_SEC_CONFIG_REG2                                (volatile uint32_t *)(0xff634000 + (0x02 << 2))
#define     RNG_SEC_SCRATCH_REG                                (0xff634000 + (0x03 << 2))
#define SEC_RNG_SEC_SCRATCH_REG                                (0xff634000 + (0x03 << 2))
#define   P_RNG_SEC_SCRATCH_REG                                (volatile uint32_t *)(0xff634000 + (0x03 << 2))
#define     RNG_SEC_DATA                                       (0xff634000 + (0x04 << 2))
#define SEC_RNG_SEC_DATA                                       (0xff634000 + (0x04 << 2))
#define   P_RNG_SEC_DATA                                       (volatile uint32_t *)(0xff634000 + (0x04 << 2))
#define     RNG_SEC_STS                                        (0xff634000 + (0x05 << 2))
#define SEC_RNG_SEC_STS                                        (0xff634000 + (0x05 << 2))
#define   P_RNG_SEC_STS                                        (volatile uint32_t *)(0xff634000 + (0x05 << 2))
#define     RNG_USR_DATA                                       (0xff634000 + (0x06 << 2))
#define SEC_RNG_USR_DATA                                       (0xff634000 + (0x06 << 2))
#define   P_RNG_USR_DATA                                       (volatile uint32_t *)(0xff634000 + (0x06 << 2))
#define     RNG_USR_STS                                        (0xff634000 + (0x07 << 2))
#define SEC_RNG_USR_STS                                        (0xff634000 + (0x07 << 2))
#define   P_RNG_USR_STS                                        (volatile uint32_t *)(0xff634000 + (0x07 << 2))
//========================================================================
//  ACODEC
//========================================================================
//  APB4_DECODER_NON_SECURE_BASE     32'hFF632000
//  APB4_DECODER_SECURE_BASE         32'hFF632000
#define     ACODEC_0                                           (0xff632000 + (0x00 << 2))
#define SEC_ACODEC_0                                           (0xff632000 + (0x00 << 2))
#define   P_ACODEC_0                                           (volatile uint32_t *)(0xff632000 + (0x00 << 2))
#define     ACODEC_1                                           (0xff632000 + (0x01 << 2))
#define SEC_ACODEC_1                                           (0xff632000 + (0x01 << 2))
#define   P_ACODEC_1                                           (volatile uint32_t *)(0xff632000 + (0x01 << 2))
#define     ACODEC_2                                           (0xff632000 + (0x02 << 2))
#define SEC_ACODEC_2                                           (0xff632000 + (0x02 << 2))
#define   P_ACODEC_2                                           (volatile uint32_t *)(0xff632000 + (0x02 << 2))
#define     ACODEC_3                                           (0xff632000 + (0x03 << 2))
#define SEC_ACODEC_3                                           (0xff632000 + (0x03 << 2))
#define   P_ACODEC_3                                           (volatile uint32_t *)(0xff632000 + (0x03 << 2))
#define     ACODEC_4                                           (0xff632000 + (0x04 << 2))
#define SEC_ACODEC_4                                           (0xff632000 + (0x04 << 2))
#define   P_ACODEC_4                                           (volatile uint32_t *)(0xff632000 + (0x04 << 2))
#define     ACODEC_5                                           (0xff632000 + (0x05 << 2))
#define SEC_ACODEC_5                                           (0xff632000 + (0x05 << 2))
#define   P_ACODEC_5                                           (volatile uint32_t *)(0xff632000 + (0x05 << 2))
#define     ACODEC_6                                           (0xff632000 + (0x06 << 2))
#define SEC_ACODEC_6                                           (0xff632000 + (0x06 << 2))
#define   P_ACODEC_6                                           (volatile uint32_t *)(0xff632000 + (0x06 << 2))
#define     ACODEC_7                                           (0xff632000 + (0x07 << 2))
#define SEC_ACODEC_7                                           (0xff632000 + (0x07 << 2))
#define   P_ACODEC_7                                           (volatile uint32_t *)(0xff632000 + (0x07 << 2))
//========================================================================
//  PERIPHS
//========================================================================
//  APB4_DECODER_NON_SECURE_BASE     32'hFF634400
//  APB4_DECODER_SECURE_BASE         32'hFF634400
// The following are handled by $periphs/rtl/periphs_reg.v
#define     PREG_CTLREG0_ADDR                                  (0xff634400 + (0x00 << 2))
#define SEC_PREG_CTLREG0_ADDR                                  (0xff634400 + (0x00 << 2))
#define   P_PREG_CTLREG0_ADDR                                  (volatile uint32_t *)(0xff634400 + (0x00 << 2))
// ----------------------------
#define     PREG_PAD_GPIO6_EN_N                                (0xff634400 + (0x08 << 2))
#define SEC_PREG_PAD_GPIO6_EN_N                                (0xff634400 + (0x08 << 2))
#define   P_PREG_PAD_GPIO6_EN_N                                (volatile uint32_t *)(0xff634400 + (0x08 << 2))
#define     PREG_PAD_GPIO6_O                                   (0xff634400 + (0x09 << 2))
#define SEC_PREG_PAD_GPIO6_O                                   (0xff634400 + (0x09 << 2))
#define   P_PREG_PAD_GPIO6_O                                   (volatile uint32_t *)(0xff634400 + (0x09 << 2))
#define     PREG_PAD_GPIO6_I                                   (0xff634400 + (0x0a << 2))
#define SEC_PREG_PAD_GPIO6_I                                   (0xff634400 + (0x0a << 2))
#define   P_PREG_PAD_GPIO6_I                                   (volatile uint32_t *)(0xff634400 + (0x0a << 2))
// ----------------------------
// ----------------------------
#define     PREG_JTAG_GPIO_ADDR                                (0xff634400 + (0x0b << 2))
#define SEC_PREG_JTAG_GPIO_ADDR                                (0xff634400 + (0x0b << 2))
#define   P_PREG_JTAG_GPIO_ADDR                                (volatile uint32_t *)(0xff634400 + (0x0b << 2))
// ----------------------------
// Pre-defined GPIO addresses
// ----------------------------
#define     PREG_PAD_GPIO0_EN_N                                (0xff634400 + (0x0c << 2))
#define SEC_PREG_PAD_GPIO0_EN_N                                (0xff634400 + (0x0c << 2))
#define   P_PREG_PAD_GPIO0_EN_N                                (volatile uint32_t *)(0xff634400 + (0x0c << 2))
#define     PREG_PAD_GPIO0_O                                   (0xff634400 + (0x0d << 2))
#define SEC_PREG_PAD_GPIO0_O                                   (0xff634400 + (0x0d << 2))
#define   P_PREG_PAD_GPIO0_O                                   (volatile uint32_t *)(0xff634400 + (0x0d << 2))
#define     PREG_PAD_GPIO0_I                                   (0xff634400 + (0x0e << 2))
#define SEC_PREG_PAD_GPIO0_I                                   (0xff634400 + (0x0e << 2))
#define   P_PREG_PAD_GPIO0_I                                   (volatile uint32_t *)(0xff634400 + (0x0e << 2))
// ----------------------------
#define     PREG_PAD_GPIO1_EN_N                                (0xff634400 + (0x0f << 2))
#define SEC_PREG_PAD_GPIO1_EN_N                                (0xff634400 + (0x0f << 2))
#define   P_PREG_PAD_GPIO1_EN_N                                (volatile uint32_t *)(0xff634400 + (0x0f << 2))
#define     PREG_PAD_GPIO1_O                                   (0xff634400 + (0x10 << 2))
#define SEC_PREG_PAD_GPIO1_O                                   (0xff634400 + (0x10 << 2))
#define   P_PREG_PAD_GPIO1_O                                   (volatile uint32_t *)(0xff634400 + (0x10 << 2))
#define     PREG_PAD_GPIO1_I                                   (0xff634400 + (0x11 << 2))
#define SEC_PREG_PAD_GPIO1_I                                   (0xff634400 + (0x11 << 2))
#define   P_PREG_PAD_GPIO1_I                                   (volatile uint32_t *)(0xff634400 + (0x11 << 2))
// ----------------------------
#define     PREG_PAD_GPIO2_EN_N                                (0xff634400 + (0x12 << 2))
#define SEC_PREG_PAD_GPIO2_EN_N                                (0xff634400 + (0x12 << 2))
#define   P_PREG_PAD_GPIO2_EN_N                                (volatile uint32_t *)(0xff634400 + (0x12 << 2))
#define     PREG_PAD_GPIO2_O                                   (0xff634400 + (0x13 << 2))
#define SEC_PREG_PAD_GPIO2_O                                   (0xff634400 + (0x13 << 2))
#define   P_PREG_PAD_GPIO2_O                                   (volatile uint32_t *)(0xff634400 + (0x13 << 2))
#define     PREG_PAD_GPIO2_I                                   (0xff634400 + (0x14 << 2))
#define SEC_PREG_PAD_GPIO2_I                                   (0xff634400 + (0x14 << 2))
#define   P_PREG_PAD_GPIO2_I                                   (volatile uint32_t *)(0xff634400 + (0x14 << 2))
// ----------------------------
#define     PREG_PAD_GPIO3_EN_N                                (0xff634400 + (0x15 << 2))
#define SEC_PREG_PAD_GPIO3_EN_N                                (0xff634400 + (0x15 << 2))
#define   P_PREG_PAD_GPIO3_EN_N                                (volatile uint32_t *)(0xff634400 + (0x15 << 2))
#define     PREG_PAD_GPIO3_O                                   (0xff634400 + (0x16 << 2))
#define SEC_PREG_PAD_GPIO3_O                                   (0xff634400 + (0x16 << 2))
#define   P_PREG_PAD_GPIO3_O                                   (volatile uint32_t *)(0xff634400 + (0x16 << 2))
#define     PREG_PAD_GPIO3_I                                   (0xff634400 + (0x17 << 2))
#define SEC_PREG_PAD_GPIO3_I                                   (0xff634400 + (0x17 << 2))
#define   P_PREG_PAD_GPIO3_I                                   (volatile uint32_t *)(0xff634400 + (0x17 << 2))
// ----------------------------
#define     PREG_PAD_GPIO4_EN_N                                (0xff634400 + (0x18 << 2))
#define SEC_PREG_PAD_GPIO4_EN_N                                (0xff634400 + (0x18 << 2))
#define   P_PREG_PAD_GPIO4_EN_N                                (volatile uint32_t *)(0xff634400 + (0x18 << 2))
#define     PREG_PAD_GPIO4_O                                   (0xff634400 + (0x19 << 2))
#define SEC_PREG_PAD_GPIO4_O                                   (0xff634400 + (0x19 << 2))
#define   P_PREG_PAD_GPIO4_O                                   (volatile uint32_t *)(0xff634400 + (0x19 << 2))
#define     PREG_PAD_GPIO4_I                                   (0xff634400 + (0x1a << 2))
#define SEC_PREG_PAD_GPIO4_I                                   (0xff634400 + (0x1a << 2))
#define   P_PREG_PAD_GPIO4_I                                   (volatile uint32_t *)(0xff634400 + (0x1a << 2))
// ----------------------------
#define     PREG_PAD_GPIO5_EN_N                                (0xff634400 + (0x1b << 2))
#define SEC_PREG_PAD_GPIO5_EN_N                                (0xff634400 + (0x1b << 2))
#define   P_PREG_PAD_GPIO5_EN_N                                (volatile uint32_t *)(0xff634400 + (0x1b << 2))
#define     PREG_PAD_GPIO5_O                                   (0xff634400 + (0x1c << 2))
#define SEC_PREG_PAD_GPIO5_O                                   (0xff634400 + (0x1c << 2))
#define   P_PREG_PAD_GPIO5_O                                   (volatile uint32_t *)(0xff634400 + (0x1c << 2))
#define     PREG_PAD_GPIO5_I                                   (0xff634400 + (0x1d << 2))
#define SEC_PREG_PAD_GPIO5_I                                   (0xff634400 + (0x1d << 2))
#define   P_PREG_PAD_GPIO5_I                                   (volatile uint32_t *)(0xff634400 + (0x1d << 2))
// ----------------------------
// ----------------------------
// Pin Mux  (9)
// ----------------------------
#define     PERIPHS_PIN_MUX_0                                  (0xff634400 + (0x20 << 2))
#define SEC_PERIPHS_PIN_MUX_0                                  (0xff634400 + (0x20 << 2))
#define   P_PERIPHS_PIN_MUX_0                                  (volatile uint32_t *)(0xff634400 + (0x20 << 2))
#define     PERIPHS_PIN_MUX_1                                  (0xff634400 + (0x21 << 2))
#define SEC_PERIPHS_PIN_MUX_1                                  (0xff634400 + (0x21 << 2))
#define   P_PERIPHS_PIN_MUX_1                                  (volatile uint32_t *)(0xff634400 + (0x21 << 2))
#define     PERIPHS_PIN_MUX_2                                  (0xff634400 + (0x22 << 2))
#define SEC_PERIPHS_PIN_MUX_2                                  (0xff634400 + (0x22 << 2))
#define   P_PERIPHS_PIN_MUX_2                                  (volatile uint32_t *)(0xff634400 + (0x22 << 2))
#define     PERIPHS_PIN_MUX_3                                  (0xff634400 + (0x23 << 2))
#define SEC_PERIPHS_PIN_MUX_3                                  (0xff634400 + (0x23 << 2))
#define   P_PERIPHS_PIN_MUX_3                                  (volatile uint32_t *)(0xff634400 + (0x23 << 2))
#define     PERIPHS_PIN_MUX_4                                  (0xff634400 + (0x24 << 2))
#define SEC_PERIPHS_PIN_MUX_4                                  (0xff634400 + (0x24 << 2))
#define   P_PERIPHS_PIN_MUX_4                                  (volatile uint32_t *)(0xff634400 + (0x24 << 2))
#define     PERIPHS_PIN_MUX_5                                  (0xff634400 + (0x25 << 2))
#define SEC_PERIPHS_PIN_MUX_5                                  (0xff634400 + (0x25 << 2))
#define   P_PERIPHS_PIN_MUX_5                                  (volatile uint32_t *)(0xff634400 + (0x25 << 2))
#define     PERIPHS_PIN_MUX_6                                  (0xff634400 + (0x26 << 2))
#define SEC_PERIPHS_PIN_MUX_6                                  (0xff634400 + (0x26 << 2))
#define   P_PERIPHS_PIN_MUX_6                                  (volatile uint32_t *)(0xff634400 + (0x26 << 2))
#define     PERIPHS_PIN_MUX_7                                  (0xff634400 + (0x27 << 2))
#define SEC_PERIPHS_PIN_MUX_7                                  (0xff634400 + (0x27 << 2))
#define   P_PERIPHS_PIN_MUX_7                                  (volatile uint32_t *)(0xff634400 + (0x27 << 2))
#define     PERIPHS_PIN_MUX_8                                  (0xff634400 + (0x28 << 2))
#define SEC_PERIPHS_PIN_MUX_8                                  (0xff634400 + (0x28 << 2))
#define   P_PERIPHS_PIN_MUX_8                                  (volatile uint32_t *)(0xff634400 + (0x28 << 2))
#define     PERIPHS_PIN_MUX_9                                  (0xff634400 + (0x29 << 2))
#define SEC_PERIPHS_PIN_MUX_9                                  (0xff634400 + (0x29 << 2))
#define   P_PERIPHS_PIN_MUX_9                                  (volatile uint32_t *)(0xff634400 + (0x29 << 2))
#define     PERIPHS_PIN_MUX_A                                  (0xff634400 + (0x2a << 2))
#define SEC_PERIPHS_PIN_MUX_A                                  (0xff634400 + (0x2a << 2))
#define   P_PERIPHS_PIN_MUX_A                                  (volatile uint32_t *)(0xff634400 + (0x2a << 2))
#define     PERIPHS_PIN_MUX_B                                  (0xff634400 + (0x2b << 2))
#define SEC_PERIPHS_PIN_MUX_B                                  (0xff634400 + (0x2b << 2))
#define   P_PERIPHS_PIN_MUX_B                                  (volatile uint32_t *)(0xff634400 + (0x2b << 2))
#define     PERIPHS_PIN_MUX_C                                  (0xff634400 + (0x2c << 2))
#define SEC_PERIPHS_PIN_MUX_C                                  (0xff634400 + (0x2c << 2))
#define   P_PERIPHS_PIN_MUX_C                                  (volatile uint32_t *)(0xff634400 + (0x2c << 2))
#define     PERIPHS_PIN_MUX_D                                  (0xff634400 + (0x2d << 2))
#define SEC_PERIPHS_PIN_MUX_D                                  (0xff634400 + (0x2d << 2))
#define   P_PERIPHS_PIN_MUX_D                                  (volatile uint32_t *)(0xff634400 + (0x2d << 2))
#define     PERIPHS_PIN_MUX_E                                  (0xff634400 + (0x2e << 2))
#define SEC_PERIPHS_PIN_MUX_E                                  (0xff634400 + (0x2e << 2))
#define   P_PERIPHS_PIN_MUX_E                                  (volatile uint32_t *)(0xff634400 + (0x2e << 2))
#define     PERIPHS_PIN_MUX_F                                  (0xff634400 + (0x2f << 2))
#define SEC_PERIPHS_PIN_MUX_F                                  (0xff634400 + (0x2f << 2))
#define   P_PERIPHS_PIN_MUX_F                                  (volatile uint32_t *)(0xff634400 + (0x2f << 2))
// ----------------------------
// Pad controls
// ----------------------------
#define     PAD_PULL_UP_REG6                                   (0xff634400 + (0x39 << 2))
#define SEC_PAD_PULL_UP_REG6                                   (0xff634400 + (0x39 << 2))
#define   P_PAD_PULL_UP_REG6                                   (volatile uint32_t *)(0xff634400 + (0x39 << 2))
#define     PAD_PULL_UP_REG0                                   (0xff634400 + (0x3a << 2))
#define SEC_PAD_PULL_UP_REG0                                   (0xff634400 + (0x3a << 2))
#define   P_PAD_PULL_UP_REG0                                   (volatile uint32_t *)(0xff634400 + (0x3a << 2))
#define     PAD_PULL_UP_REG1                                   (0xff634400 + (0x3b << 2))
#define SEC_PAD_PULL_UP_REG1                                   (0xff634400 + (0x3b << 2))
#define   P_PAD_PULL_UP_REG1                                   (volatile uint32_t *)(0xff634400 + (0x3b << 2))
#define     PAD_PULL_UP_REG2                                   (0xff634400 + (0x3c << 2))
#define SEC_PAD_PULL_UP_REG2                                   (0xff634400 + (0x3c << 2))
#define   P_PAD_PULL_UP_REG2                                   (volatile uint32_t *)(0xff634400 + (0x3c << 2))
#define     PAD_PULL_UP_REG3                                   (0xff634400 + (0x3d << 2))
#define SEC_PAD_PULL_UP_REG3                                   (0xff634400 + (0x3d << 2))
#define   P_PAD_PULL_UP_REG3                                   (volatile uint32_t *)(0xff634400 + (0x3d << 2))
#define     PAD_PULL_UP_REG4                                   (0xff634400 + (0x3e << 2))
#define SEC_PAD_PULL_UP_REG4                                   (0xff634400 + (0x3e << 2))
#define   P_PAD_PULL_UP_REG4                                   (volatile uint32_t *)(0xff634400 + (0x3e << 2))
#define     PAD_PULL_UP_REG5                                   (0xff634400 + (0x3f << 2))
#define SEC_PAD_PULL_UP_REG5                                   (0xff634400 + (0x3f << 2))
#define   P_PAD_PULL_UP_REG5                                   (volatile uint32_t *)(0xff634400 + (0x3f << 2))
// ----------------------------
// Random (2)
// ----------------------------
#define     RAND64_ADDR0                                       (0xff634400 + (0x40 << 2))
#define SEC_RAND64_ADDR0                                       (0xff634400 + (0x40 << 2))
#define   P_RAND64_ADDR0                                       (volatile uint32_t *)(0xff634400 + (0x40 << 2))
#define     RAND64_ADDR1                                       (0xff634400 + (0x41 << 2))
#define SEC_RAND64_ADDR1                                       (0xff634400 + (0x41 << 2))
#define   P_RAND64_ADDR1                                       (volatile uint32_t *)(0xff634400 + (0x41 << 2))
// ---------------------------
// Ethernet (1)
// ----------------------------
#define     PREG_ETHERNET_ADDR0                                (0xff634400 + (0x42 << 2))
#define SEC_PREG_ETHERNET_ADDR0                                (0xff634400 + (0x42 << 2))
#define   P_PREG_ETHERNET_ADDR0                                (volatile uint32_t *)(0xff634400 + (0x42 << 2))
// ---------------------------
// AM_ANALOG_TOP
// ----------------------------
#define     PREG_AM_ANALOG_ADDR                                (0xff634400 + (0x43 << 2))
#define SEC_PREG_AM_ANALOG_ADDR                                (0xff634400 + (0x43 << 2))
#define   P_PREG_AM_ANALOG_ADDR                                (volatile uint32_t *)(0xff634400 + (0x43 << 2))
// ---------------------------
// Mali55 (1)
// ----------------------------
#define     PREG_MALI_BYTE_CNTL                                (0xff634400 + (0x44 << 2))
#define SEC_PREG_MALI_BYTE_CNTL                                (0xff634400 + (0x44 << 2))
#define   P_PREG_MALI_BYTE_CNTL                                (volatile uint32_t *)(0xff634400 + (0x44 << 2))
// ---------------------------
// WIFI (1)
// ----------------------------
#define     PREG_WIFI_CNTL                                     (0xff634400 + (0x45 << 2))
#define SEC_PREG_WIFI_CNTL                                     (0xff634400 + (0x45 << 2))
#define   P_PREG_WIFI_CNTL                                     (volatile uint32_t *)(0xff634400 + (0x45 << 2))
#define     PAD_PULL_UP_EN_REG0                                (0xff634400 + (0x48 << 2))
#define SEC_PAD_PULL_UP_EN_REG0                                (0xff634400 + (0x48 << 2))
#define   P_PAD_PULL_UP_EN_REG0                                (volatile uint32_t *)(0xff634400 + (0x48 << 2))
#define     PAD_PULL_UP_EN_REG1                                (0xff634400 + (0x49 << 2))
#define SEC_PAD_PULL_UP_EN_REG1                                (0xff634400 + (0x49 << 2))
#define   P_PAD_PULL_UP_EN_REG1                                (volatile uint32_t *)(0xff634400 + (0x49 << 2))
#define     PAD_PULL_UP_EN_REG2                                (0xff634400 + (0x4a << 2))
#define SEC_PAD_PULL_UP_EN_REG2                                (0xff634400 + (0x4a << 2))
#define   P_PAD_PULL_UP_EN_REG2                                (volatile uint32_t *)(0xff634400 + (0x4a << 2))
#define     PAD_PULL_UP_EN_REG3                                (0xff634400 + (0x4b << 2))
#define SEC_PAD_PULL_UP_EN_REG3                                (0xff634400 + (0x4b << 2))
#define   P_PAD_PULL_UP_EN_REG3                                (volatile uint32_t *)(0xff634400 + (0x4b << 2))
#define     PAD_PULL_UP_EN_REG4                                (0xff634400 + (0x4c << 2))
#define SEC_PAD_PULL_UP_EN_REG4                                (0xff634400 + (0x4c << 2))
#define   P_PAD_PULL_UP_EN_REG4                                (volatile uint32_t *)(0xff634400 + (0x4c << 2))
#define     PAD_PULL_UP_EN_REG5                                (0xff634400 + (0x4d << 2))
#define SEC_PAD_PULL_UP_EN_REG5                                (0xff634400 + (0x4d << 2))
#define   P_PAD_PULL_UP_EN_REG5                                (volatile uint32_t *)(0xff634400 + (0x4d << 2))
#define     PAD_PULL_UP_EN_REG6                                (0xff634400 + (0x4e << 2))
#define SEC_PAD_PULL_UP_EN_REG6                                (0xff634400 + (0x4e << 2))
#define   P_PAD_PULL_UP_EN_REG6                                (volatile uint32_t *)(0xff634400 + (0x4e << 2))
// ---------------------------
#define     PREG_ETH_REG0                                      (0xff634400 + (0x50 << 2))
#define SEC_PREG_ETH_REG0                                      (0xff634400 + (0x50 << 2))
#define   P_PREG_ETH_REG0                                      (volatile uint32_t *)(0xff634400 + (0x50 << 2))
#define     PREG_ETH_REG1                                      (0xff634400 + (0x51 << 2))
#define SEC_PREG_ETH_REG1                                      (0xff634400 + (0x51 << 2))
#define   P_PREG_ETH_REG1                                      (volatile uint32_t *)(0xff634400 + (0x51 << 2))
#define     PREG_NAND_CFG_KEY0                                 (0xff634400 + (0x52 << 2))
#define SEC_PREG_NAND_CFG_KEY0                                 (0xff634400 + (0x52 << 2))
#define   P_PREG_NAND_CFG_KEY0                                 (volatile uint32_t *)(0xff634400 + (0x52 << 2))
#define     PREG_NAND_CFG_KEY1                                 (0xff634400 + (0x53 << 2))
#define SEC_PREG_NAND_CFG_KEY1                                 (0xff634400 + (0x53 << 2))
#define   P_PREG_NAND_CFG_KEY1                                 (volatile uint32_t *)(0xff634400 + (0x53 << 2))
#define     PREG_VPU_SECURE0                                   (0xff634400 + (0x54 << 2))
#define SEC_PREG_VPU_SECURE0                                   (0xff634400 + (0x54 << 2))
#define   P_PREG_VPU_SECURE0                                   (volatile uint32_t *)(0xff634400 + (0x54 << 2))
#define     PREG_VPU_SECURE1                                   (0xff634400 + (0x55 << 2))
#define SEC_PREG_VPU_SECURE1                                   (0xff634400 + (0x55 << 2))
#define   P_PREG_VPU_SECURE1                                   (volatile uint32_t *)(0xff634400 + (0x55 << 2))
#define     PREG_ETH_REG2                                      (0xff634400 + (0x56 << 2))
#define SEC_PREG_ETH_REG2                                      (0xff634400 + (0x56 << 2))
#define   P_PREG_ETH_REG2                                      (volatile uint32_t *)(0xff634400 + (0x56 << 2))
#define     PREG_ETH_REG3                                      (0xff634400 + (0x57 << 2))
#define SEC_PREG_ETH_REG3                                      (0xff634400 + (0x57 << 2))
#define   P_PREG_ETH_REG3                                      (volatile uint32_t *)(0xff634400 + (0x57 << 2))
#define     PREG_ETH_REG4                                      (0xff634400 + (0x58 << 2))
#define SEC_PREG_ETH_REG4                                      (0xff634400 + (0x58 << 2))
#define   P_PREG_ETH_REG4                                      (volatile uint32_t *)(0xff634400 + (0x58 << 2))
//new TS
#define     TS_CFG_REG                                         (0xff634400 + (0x5a << 2))
#define SEC_TS_CFG_REG                                         (0xff634400 + (0x5a << 2))
#define   P_TS_CFG_REG                                         (volatile uint32_t *)(0xff634400 + (0x5a << 2))
#define     TS_CFG_REG2                                        (0xff634400 + (0x5b << 2))
#define SEC_TS_CFG_REG2                                        (0xff634400 + (0x5b << 2))
#define   P_TS_CFG_REG2                                        (volatile uint32_t *)(0xff634400 + (0x5b << 2))
#define     TS_YOUT                                            (0xff634400 + (0x5c << 2))
#define SEC_TS_YOUT                                            (0xff634400 + (0x5c << 2))
#define   P_TS_YOUT                                            (volatile uint32_t *)(0xff634400 + (0x5c << 2))
// ---------------------------
// Generic production test
// ----------------------------
#define     PROD_TEST_REG0                                     (0xff634400 + (0x60 << 2))
#define SEC_PROD_TEST_REG0                                     (0xff634400 + (0x60 << 2))
#define   P_PROD_TEST_REG0                                     (volatile uint32_t *)(0xff634400 + (0x60 << 2))
#define     PROD_TEST_REG1                                     (0xff634400 + (0x61 << 2))
#define SEC_PROD_TEST_REG1                                     (0xff634400 + (0x61 << 2))
#define   P_PROD_TEST_REG1                                     (volatile uint32_t *)(0xff634400 + (0x61 << 2))
#define     PROD_TEST_REG2                                     (0xff634400 + (0x62 << 2))
#define SEC_PROD_TEST_REG2                                     (0xff634400 + (0x62 << 2))
#define   P_PROD_TEST_REG2                                     (volatile uint32_t *)(0xff634400 + (0x62 << 2))
#define     PROD_TEST_REG3                                     (0xff634400 + (0x63 << 2))
#define SEC_PROD_TEST_REG3                                     (0xff634400 + (0x63 << 2))
#define   P_PROD_TEST_REG3                                     (volatile uint32_t *)(0xff634400 + (0x63 << 2))
// ---------------------------
// am_analog_top
// ----------------------------
//`define METAL_REVISION                      8'h6a
#define     ADC_TOP_MISC                                       (0xff634400 + (0x6b << 2))
#define SEC_ADC_TOP_MISC                                       (0xff634400 + (0x6b << 2))
#define   P_ADC_TOP_MISC                                       (volatile uint32_t *)(0xff634400 + (0x6b << 2))
#define     DPLL_TOP_MISC                                      (0xff634400 + (0x6c << 2))
#define SEC_DPLL_TOP_MISC                                      (0xff634400 + (0x6c << 2))
#define   P_DPLL_TOP_MISC                                      (volatile uint32_t *)(0xff634400 + (0x6c << 2))
#define     ANALOG_TOP_MISC                                    (0xff634400 + (0x6d << 2))
#define SEC_ANALOG_TOP_MISC                                    (0xff634400 + (0x6d << 2))
#define   P_ANALOG_TOP_MISC                                    (volatile uint32_t *)(0xff634400 + (0x6d << 2))
#define     AM_ANALOG_TOP_REG0                                 (0xff634400 + (0x6e << 2))
#define SEC_AM_ANALOG_TOP_REG0                                 (0xff634400 + (0x6e << 2))
#define   P_AM_ANALOG_TOP_REG0                                 (volatile uint32_t *)(0xff634400 + (0x6e << 2))
#define     AM_ANALOG_TOP_REG1                                 (0xff634400 + (0x6f << 2))
#define SEC_AM_ANALOG_TOP_REG1                                 (0xff634400 + (0x6f << 2))
#define   P_AM_ANALOG_TOP_REG1                                 (volatile uint32_t *)(0xff634400 + (0x6f << 2))
// ---------------------------
// Sticky regs
// ----------------------------
#define     PREG_STICKY_REG0                                   (0xff634400 + (0x70 << 2))
#define SEC_PREG_STICKY_REG0                                   (0xff634400 + (0x70 << 2))
#define   P_PREG_STICKY_REG0                                   (volatile uint32_t *)(0xff634400 + (0x70 << 2))
#define     PREG_STICKY_REG1                                   (0xff634400 + (0x71 << 2))
#define SEC_PREG_STICKY_REG1                                   (0xff634400 + (0x71 << 2))
#define   P_PREG_STICKY_REG1                                   (volatile uint32_t *)(0xff634400 + (0x71 << 2))
#define     PREG_STICKY_REG2                                   (0xff634400 + (0x72 << 2))
#define SEC_PREG_STICKY_REG2                                   (0xff634400 + (0x72 << 2))
#define   P_PREG_STICKY_REG2                                   (volatile uint32_t *)(0xff634400 + (0x72 << 2))
#define     PREG_STICKY_REG3                                   (0xff634400 + (0x73 << 2))
#define SEC_PREG_STICKY_REG3                                   (0xff634400 + (0x73 << 2))
#define   P_PREG_STICKY_REG3                                   (volatile uint32_t *)(0xff634400 + (0x73 << 2))
#define     PREG_STICKY_REG4                                   (0xff634400 + (0x74 << 2))
#define SEC_PREG_STICKY_REG4                                   (0xff634400 + (0x74 << 2))
#define   P_PREG_STICKY_REG4                                   (volatile uint32_t *)(0xff634400 + (0x74 << 2))
#define     PREG_STICKY_REG5                                   (0xff634400 + (0x75 << 2))
#define SEC_PREG_STICKY_REG5                                   (0xff634400 + (0x75 << 2))
#define   P_PREG_STICKY_REG5                                   (volatile uint32_t *)(0xff634400 + (0x75 << 2))
#define     PREG_STICKY_REG6                                   (0xff634400 + (0x76 << 2))
#define SEC_PREG_STICKY_REG6                                   (0xff634400 + (0x76 << 2))
#define   P_PREG_STICKY_REG6                                   (volatile uint32_t *)(0xff634400 + (0x76 << 2))
#define     PREG_STICKY_REG7                                   (0xff634400 + (0x77 << 2))
#define SEC_PREG_STICKY_REG7                                   (0xff634400 + (0x77 << 2))
#define   P_PREG_STICKY_REG7                                   (volatile uint32_t *)(0xff634400 + (0x77 << 2))
#define     PREG_STICKY_REG8                                   (0xff634400 + (0x78 << 2))
#define SEC_PREG_STICKY_REG8                                   (0xff634400 + (0x78 << 2))
#define   P_PREG_STICKY_REG8                                   (volatile uint32_t *)(0xff634400 + (0x78 << 2))
#define     PREG_STICKY_REG9                                   (0xff634400 + (0x79 << 2))
#define SEC_PREG_STICKY_REG9                                   (0xff634400 + (0x79 << 2))
#define   P_PREG_STICKY_REG9                                   (volatile uint32_t *)(0xff634400 + (0x79 << 2))
#define     PREG_WRITE_ONCE_REG                                (0xff634400 + (0x7e << 2))
#define SEC_PREG_WRITE_ONCE_REG                                (0xff634400 + (0x7e << 2))
#define   P_PREG_WRITE_ONCE_REG                                (volatile uint32_t *)(0xff634400 + (0x7e << 2))
// ---------------------------
// AM Ring Oscillator
// ----------------------------
#define     AM_RING_OSC_REG0                                   (0xff634400 + (0x7f << 2))
#define SEC_AM_RING_OSC_REG0                                   (0xff634400 + (0x7f << 2))
#define   P_AM_RING_OSC_REG0                                   (volatile uint32_t *)(0xff634400 + (0x7f << 2))
// Control whether to provide random number to HDMITX20
#define     HDMITX20_RNDNUM                                    (0xff634400 + (0x80 << 2))
#define SEC_HDMITX20_RNDNUM                                    (0xff634400 + (0x80 << 2))
#define   P_HDMITX20_RNDNUM                                    (volatile uint32_t *)(0xff634400 + (0x80 << 2))
// ---------------------------
// Bus Monitoring
// ----------------------------
#define     BUS_MONITOR_CNTL                                   (0xff634400 + (0x81 << 2))
#define SEC_BUS_MONITOR_CNTL                                   (0xff634400 + (0x81 << 2))
#define   P_BUS_MONITOR_CNTL                                   (volatile uint32_t *)(0xff634400 + (0x81 << 2))
#define     BUS_MON0_ADDR                                      (0xff634400 + (0x82 << 2))
#define SEC_BUS_MON0_ADDR                                      (0xff634400 + (0x82 << 2))
#define   P_BUS_MON0_ADDR                                      (volatile uint32_t *)(0xff634400 + (0x82 << 2))
#define     BUS_MON0_DATA                                      (0xff634400 + (0x83 << 2))
#define SEC_BUS_MON0_DATA                                      (0xff634400 + (0x83 << 2))
#define   P_BUS_MON0_DATA                                      (volatile uint32_t *)(0xff634400 + (0x83 << 2))
#define     BUS_MON0_DATA_MSK                                  (0xff634400 + (0x84 << 2))
#define SEC_BUS_MON0_DATA_MSK                                  (0xff634400 + (0x84 << 2))
#define   P_BUS_MON0_DATA_MSK                                  (volatile uint32_t *)(0xff634400 + (0x84 << 2))
#define     BUS_MON1_ADDR                                      (0xff634400 + (0x85 << 2))
#define SEC_BUS_MON1_ADDR                                      (0xff634400 + (0x85 << 2))
#define   P_BUS_MON1_ADDR                                      (volatile uint32_t *)(0xff634400 + (0x85 << 2))
#define     BUS_MON1_DATA                                      (0xff634400 + (0x86 << 2))
#define SEC_BUS_MON1_DATA                                      (0xff634400 + (0x86 << 2))
#define   P_BUS_MON1_DATA                                      (volatile uint32_t *)(0xff634400 + (0x86 << 2))
#define     BUS_MON1_DATA_MSK                                  (0xff634400 + (0x87 << 2))
#define SEC_BUS_MON1_DATA_MSK                                  (0xff634400 + (0x87 << 2))
#define   P_BUS_MON1_DATA_MSK                                  (volatile uint32_t *)(0xff634400 + (0x87 << 2))
#define     ASYNC_FIFO_LOCK_ADR                                (0xff634400 + (0x88 << 2))
#define SEC_ASYNC_FIFO_LOCK_ADR                                (0xff634400 + (0x88 << 2))
#define   P_ASYNC_FIFO_LOCK_ADR                                (volatile uint32_t *)(0xff634400 + (0x88 << 2))
#define     SECE_TIMER_CTRL                                    (0xff634400 + (0x89 << 2))
#define SEC_SECE_TIMER_CTRL                                    (0xff634400 + (0x89 << 2))
#define   P_SECE_TIMER_CTRL                                    (volatile uint32_t *)(0xff634400 + (0x89 << 2))
#define     SECE_TIMER_LOW                                     (0xff634400 + (0x8a << 2))
#define SEC_SECE_TIMER_LOW                                     (0xff634400 + (0x8a << 2))
#define   P_SECE_TIMER_LOW                                     (volatile uint32_t *)(0xff634400 + (0x8a << 2))
#define     SECE_TIMER_HIG                                     (0xff634400 + (0x8b << 2))
#define SEC_SECE_TIMER_HIG                                     (0xff634400 + (0x8b << 2))
#define   P_SECE_TIMER_HIG                                     (volatile uint32_t *)(0xff634400 + (0x8b << 2))
// ---------------------------
// System CPU control registers
// ----------------------------
#define     SYS_CPU_POR_CFG0                                   (0xff634400 + (0x90 << 2))
#define SEC_SYS_CPU_POR_CFG0                                   (0xff634400 + (0x90 << 2))
#define   P_SYS_CPU_POR_CFG0                                   (volatile uint32_t *)(0xff634400 + (0x90 << 2))
#define     SYS_CPU_POR_CFG1                                   (0xff634400 + (0x91 << 2))
#define SEC_SYS_CPU_POR_CFG1                                   (0xff634400 + (0x91 << 2))
#define   P_SYS_CPU_POR_CFG1                                   (volatile uint32_t *)(0xff634400 + (0x91 << 2))
#define     SYS_CPU_CFG0                                       (0xff634400 + (0x92 << 2))
#define SEC_SYS_CPU_CFG0                                       (0xff634400 + (0x92 << 2))
#define   P_SYS_CPU_CFG0                                       (volatile uint32_t *)(0xff634400 + (0x92 << 2))
#define     SYS_CPU_CFG1                                       (0xff634400 + (0x93 << 2))
#define SEC_SYS_CPU_CFG1                                       (0xff634400 + (0x93 << 2))
#define   P_SYS_CPU_CFG1                                       (volatile uint32_t *)(0xff634400 + (0x93 << 2))
#define     SYS_CPU_CFG2                                       (0xff634400 + (0x94 << 2))
#define SEC_SYS_CPU_CFG2                                       (0xff634400 + (0x94 << 2))
#define   P_SYS_CPU_CFG2                                       (volatile uint32_t *)(0xff634400 + (0x94 << 2))
#define     SYS_CPU_CFG3                                       (0xff634400 + (0x95 << 2))
#define SEC_SYS_CPU_CFG3                                       (0xff634400 + (0x95 << 2))
#define   P_SYS_CPU_CFG3                                       (volatile uint32_t *)(0xff634400 + (0x95 << 2))
#define     SYS_CPU_CFG4                                       (0xff634400 + (0x96 << 2))
#define SEC_SYS_CPU_CFG4                                       (0xff634400 + (0x96 << 2))
#define   P_SYS_CPU_CFG4                                       (volatile uint32_t *)(0xff634400 + (0x96 << 2))
#define     SYS_CPU_CFG5                                       (0xff634400 + (0x97 << 2))
#define SEC_SYS_CPU_CFG5                                       (0xff634400 + (0x97 << 2))
#define   P_SYS_CPU_CFG5                                       (volatile uint32_t *)(0xff634400 + (0x97 << 2))
#define     SYS_CPU_CFG6                                       (0xff634400 + (0x98 << 2))
#define SEC_SYS_CPU_CFG6                                       (0xff634400 + (0x98 << 2))
#define   P_SYS_CPU_CFG6                                       (volatile uint32_t *)(0xff634400 + (0x98 << 2))
#define     SYS_CPU_CFG7                                       (0xff634400 + (0x99 << 2))
#define SEC_SYS_CPU_CFG7                                       (0xff634400 + (0x99 << 2))
#define   P_SYS_CPU_CFG7                                       (volatile uint32_t *)(0xff634400 + (0x99 << 2))
#define     SYS_CPU_CFG8                                       (0xff634400 + (0x9a << 2))
#define SEC_SYS_CPU_CFG8                                       (0xff634400 + (0x9a << 2))
#define   P_SYS_CPU_CFG8                                       (volatile uint32_t *)(0xff634400 + (0x9a << 2))
#define     SYS_CPU_CFG9                                       (0xff634400 + (0x9b << 2))
#define SEC_SYS_CPU_CFG9                                       (0xff634400 + (0x9b << 2))
#define   P_SYS_CPU_CFG9                                       (volatile uint32_t *)(0xff634400 + (0x9b << 2))
#define     SYS_CPU_CFG10                                      (0xff634400 + (0x9c << 2))
#define SEC_SYS_CPU_CFG10                                      (0xff634400 + (0x9c << 2))
#define   P_SYS_CPU_CFG10                                      (volatile uint32_t *)(0xff634400 + (0x9c << 2))
#define     SYS_CPU_CFG11                                      (0xff634400 + (0x9d << 2))
#define SEC_SYS_CPU_CFG11                                      (0xff634400 + (0x9d << 2))
#define   P_SYS_CPU_CFG11                                      (volatile uint32_t *)(0xff634400 + (0x9d << 2))
#define     SYS_CPU_CFG12                                      (0xff634400 + (0x9e << 2))
#define SEC_SYS_CPU_CFG12                                      (0xff634400 + (0x9e << 2))
#define   P_SYS_CPU_CFG12                                      (volatile uint32_t *)(0xff634400 + (0x9e << 2))
#define     SYS_CPU_CFG13                                      (0xff634400 + (0x9f << 2))
#define SEC_SYS_CPU_CFG13                                      (0xff634400 + (0x9f << 2))
#define   P_SYS_CPU_CFG13                                      (volatile uint32_t *)(0xff634400 + (0x9f << 2))
#define     SYS_CPU_STATUS0                                    (0xff634400 + (0xa0 << 2))
#define SEC_SYS_CPU_STATUS0                                    (0xff634400 + (0xa0 << 2))
#define   P_SYS_CPU_STATUS0                                    (volatile uint32_t *)(0xff634400 + (0xa0 << 2))
#define     SYS_CPU_STATUS1                                    (0xff634400 + (0xa1 << 2))
#define SEC_SYS_CPU_STATUS1                                    (0xff634400 + (0xa1 << 2))
#define   P_SYS_CPU_STATUS1                                    (volatile uint32_t *)(0xff634400 + (0xa1 << 2))
#define     SYS_CPU_STATUS2                                    (0xff634400 + (0xa2 << 2))
#define SEC_SYS_CPU_STATUS2                                    (0xff634400 + (0xa2 << 2))
#define   P_SYS_CPU_STATUS2                                    (volatile uint32_t *)(0xff634400 + (0xa2 << 2))
#define     SYS_CPU_STATUS3                                    (0xff634400 + (0xa3 << 2))
#define SEC_SYS_CPU_STATUS3                                    (0xff634400 + (0xa3 << 2))
#define   P_SYS_CPU_STATUS3                                    (volatile uint32_t *)(0xff634400 + (0xa3 << 2))
#define     SYS_CPU_STATUS4                                    (0xff634400 + (0xa4 << 2))
#define SEC_SYS_CPU_STATUS4                                    (0xff634400 + (0xa4 << 2))
#define   P_SYS_CPU_STATUS4                                    (volatile uint32_t *)(0xff634400 + (0xa4 << 2))
#define     SYS_CPU_STATUS5                                    (0xff634400 + (0xa5 << 2))
#define SEC_SYS_CPU_STATUS5                                    (0xff634400 + (0xa5 << 2))
#define   P_SYS_CPU_STATUS5                                    (volatile uint32_t *)(0xff634400 + (0xa5 << 2))
#define     SYS_CPU_MISC                                       (0xff634400 + (0xa8 << 2))
#define SEC_SYS_CPU_MISC                                       (0xff634400 + (0xa8 << 2))
#define   P_SYS_CPU_MISC                                       (volatile uint32_t *)(0xff634400 + (0xa8 << 2))
//========================================================================
//  HIU - Registers
//========================================================================
// APB4_DECODER_NON_SECURE_BASE     32'hFF63C000
// APB4_DECODER_SECURE_BASE         32'hFF63C000
#define     SCR_HIU                                            (0xff63c000 + (0x0b << 2))
#define SEC_SCR_HIU                                            (0xff63c000 + (0x0b << 2))
#define   P_SCR_HIU                                            (volatile uint32_t *)(0xff63c000 + (0x0b << 2))
#define     HPG_TIMER                                          (0xff63c000 + (0x0f << 2))
#define SEC_HPG_TIMER                                          (0xff63c000 + (0x0f << 2))
#define   P_HPG_TIMER                                          (volatile uint32_t *)(0xff63c000 + (0x0f << 2))
#define     HHI_GP0_PLL_CNTL                                   (0xff63c000 + (0x10 << 2))
#define SEC_HHI_GP0_PLL_CNTL                                   (0xff63c000 + (0x10 << 2))
#define   P_HHI_GP0_PLL_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x10 << 2))
#define     HHI_GP0_PLL_CNTL2                                  (0xff63c000 + (0x11 << 2))
#define SEC_HHI_GP0_PLL_CNTL2                                  (0xff63c000 + (0x11 << 2))
#define   P_HHI_GP0_PLL_CNTL2                                  (volatile uint32_t *)(0xff63c000 + (0x11 << 2))
#define     HHI_GP0_PLL_CNTL3                                  (0xff63c000 + (0x12 << 2))
#define SEC_HHI_GP0_PLL_CNTL3                                  (0xff63c000 + (0x12 << 2))
#define   P_HHI_GP0_PLL_CNTL3                                  (volatile uint32_t *)(0xff63c000 + (0x12 << 2))
#define     HHI_GP0_PLL_CNTL4                                  (0xff63c000 + (0x13 << 2))
#define SEC_HHI_GP0_PLL_CNTL4                                  (0xff63c000 + (0x13 << 2))
#define   P_HHI_GP0_PLL_CNTL4                                  (volatile uint32_t *)(0xff63c000 + (0x13 << 2))
#define     HHI_GP0_PLL_CNTL5                                  (0xff63c000 + (0x14 << 2))
#define SEC_HHI_GP0_PLL_CNTL5                                  (0xff63c000 + (0x14 << 2))
#define   P_HHI_GP0_PLL_CNTL5                                  (volatile uint32_t *)(0xff63c000 + (0x14 << 2))
#define     HHI_GP0_PLL_STS                                    (0xff63c000 + (0x15 << 2))
#define SEC_HHI_GP0_PLL_STS                                    (0xff63c000 + (0x15 << 2))
#define   P_HHI_GP0_PLL_STS                                    (volatile uint32_t *)(0xff63c000 + (0x15 << 2))
#define     HHI_GP0_PLL_CNTL1                                  (0xff63c000 + (0x16 << 2))
#define SEC_HHI_GP0_PLL_CNTL1                                  (0xff63c000 + (0x16 << 2))
#define   P_HHI_GP0_PLL_CNTL1                                  (volatile uint32_t *)(0xff63c000 + (0x16 << 2))
#define     HHI_GP1_PLL_CNTL                                   (0xff63c000 + (0x18 << 2))
#define SEC_HHI_GP1_PLL_CNTL                                   (0xff63c000 + (0x18 << 2))
#define   P_HHI_GP1_PLL_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x18 << 2))
#define     HHI_GP1_PLL_CNTL2                                  (0xff63c000 + (0x19 << 2))
#define SEC_HHI_GP1_PLL_CNTL2                                  (0xff63c000 + (0x19 << 2))
#define   P_HHI_GP1_PLL_CNTL2                                  (volatile uint32_t *)(0xff63c000 + (0x19 << 2))
#define     HHI_GP1_PLL_CNTL3                                  (0xff63c000 + (0x1a << 2))
#define SEC_HHI_GP1_PLL_CNTL3                                  (0xff63c000 + (0x1a << 2))
#define   P_HHI_GP1_PLL_CNTL3                                  (volatile uint32_t *)(0xff63c000 + (0x1a << 2))
#define     HHI_GP1_PLL_CNTL4                                  (0xff63c000 + (0x1b << 2))
#define SEC_HHI_GP1_PLL_CNTL4                                  (0xff63c000 + (0x1b << 2))
#define   P_HHI_GP1_PLL_CNTL4                                  (volatile uint32_t *)(0xff63c000 + (0x1b << 2))
#define     HHI_GP1_PLL_CNTL5                                  (0xff63c000 + (0x1c << 2))
#define SEC_HHI_GP1_PLL_CNTL5                                  (0xff63c000 + (0x1c << 2))
#define   P_HHI_GP1_PLL_CNTL5                                  (volatile uint32_t *)(0xff63c000 + (0x1c << 2))
#define     HHI_GP1_PLL_STS                                    (0xff63c000 + (0x1d << 2))
#define SEC_HHI_GP1_PLL_STS                                    (0xff63c000 + (0x1d << 2))
#define   P_HHI_GP1_PLL_STS                                    (volatile uint32_t *)(0xff63c000 + (0x1d << 2))
#define     HHI_GP1_PLL_CNTL1                                  (0xff63c000 + (0x1e << 2))
#define SEC_HHI_GP1_PLL_CNTL1                                  (0xff63c000 + (0x1e << 2))
#define   P_HHI_GP1_PLL_CNTL1                                  (volatile uint32_t *)(0xff63c000 + (0x1e << 2))
#define     HHI_CADC_CNTL                                      (0xff63c000 + (0x20 << 2))
#define SEC_HHI_CADC_CNTL                                      (0xff63c000 + (0x20 << 2))
#define   P_HHI_CADC_CNTL                                      (volatile uint32_t *)(0xff63c000 + (0x20 << 2))
#define     HHI_CADC_CNTL2                                     (0xff63c000 + (0x21 << 2))
#define SEC_HHI_CADC_CNTL2                                     (0xff63c000 + (0x21 << 2))
#define   P_HHI_CADC_CNTL2                                     (volatile uint32_t *)(0xff63c000 + (0x21 << 2))
#define     HHI_CADC_CNTL3                                     (0xff63c000 + (0x22 << 2))
#define SEC_HHI_CADC_CNTL3                                     (0xff63c000 + (0x22 << 2))
#define   P_HHI_CADC_CNTL3                                     (volatile uint32_t *)(0xff63c000 + (0x22 << 2))
#define     HHI_CADC_CNTL4                                     (0xff63c000 + (0x23 << 2))
#define SEC_HHI_CADC_CNTL4                                     (0xff63c000 + (0x23 << 2))
#define   P_HHI_CADC_CNTL4                                     (volatile uint32_t *)(0xff63c000 + (0x23 << 2))
#define     HHI_CADC_CNTL5                                     (0xff63c000 + (0x24 << 2))
#define SEC_HHI_CADC_CNTL5                                     (0xff63c000 + (0x24 << 2))
#define   P_HHI_CADC_CNTL5                                     (volatile uint32_t *)(0xff63c000 + (0x24 << 2))
#define     HHI_CADC_CNTL6                                     (0xff63c000 + (0x25 << 2))
#define SEC_HHI_CADC_CNTL6                                     (0xff63c000 + (0x25 << 2))
#define   P_HHI_CADC_CNTL6                                     (volatile uint32_t *)(0xff63c000 + (0x25 << 2))
#define     HHI_DADC_CNTL                                      (0xff63c000 + (0x27 << 2))
#define SEC_HHI_DADC_CNTL                                      (0xff63c000 + (0x27 << 2))
#define   P_HHI_DADC_CNTL                                      (volatile uint32_t *)(0xff63c000 + (0x27 << 2))
#define     HHI_DADC_CNTL2                                     (0xff63c000 + (0x28 << 2))
#define SEC_HHI_DADC_CNTL2                                     (0xff63c000 + (0x28 << 2))
#define   P_HHI_DADC_CNTL2                                     (volatile uint32_t *)(0xff63c000 + (0x28 << 2))
#define     HHI_DADC_RDBK0_I                                   (0xff63c000 + (0x29 << 2))
#define SEC_HHI_DADC_RDBK0_I                                   (0xff63c000 + (0x29 << 2))
#define   P_HHI_DADC_RDBK0_I                                   (volatile uint32_t *)(0xff63c000 + (0x29 << 2))
#define     HHI_DADC_CNTL3                                     (0xff63c000 + (0x2a << 2))
#define SEC_HHI_DADC_CNTL3                                     (0xff63c000 + (0x2a << 2))
#define   P_HHI_DADC_CNTL3                                     (volatile uint32_t *)(0xff63c000 + (0x2a << 2))
#define     HHI_DADC_CNTL4                                     (0xff63c000 + (0x2b << 2))
#define SEC_HHI_DADC_CNTL4                                     (0xff63c000 + (0x2b << 2))
#define   P_HHI_DADC_CNTL4                                     (volatile uint32_t *)(0xff63c000 + (0x2b << 2))
#define     HHI_AFE_TUNNING_CNTL                               (0xff63c000 + (0x2c << 2))
#define SEC_HHI_AFE_TUNNING_CNTL                               (0xff63c000 + (0x2c << 2))
#define   P_HHI_AFE_TUNNING_CNTL                               (volatile uint32_t *)(0xff63c000 + (0x2c << 2))
#define     HHI_AFE_TUNNING_CNTL_I                             (0xff63c000 + (0x2d << 2))
#define SEC_HHI_AFE_TUNNING_CNTL_I                             (0xff63c000 + (0x2d << 2))
#define   P_HHI_AFE_TUNNING_CNTL_I                             (volatile uint32_t *)(0xff63c000 + (0x2d << 2))
#define     HHI_CVBS_DETECT_CNTL                               (0xff63c000 + (0x2e << 2))
#define SEC_HHI_CVBS_DETECT_CNTL                               (0xff63c000 + (0x2e << 2))
#define   P_HHI_CVBS_DETECT_CNTL                               (volatile uint32_t *)(0xff63c000 + (0x2e << 2))
#define     HHI_XTAL_DIVN_CNTL                                 (0xff63c000 + (0x2f << 2))
#define SEC_HHI_XTAL_DIVN_CNTL                                 (0xff63c000 + (0x2f << 2))
#define   P_HHI_XTAL_DIVN_CNTL                                 (volatile uint32_t *)(0xff63c000 + (0x2f << 2))
#define     HHI_GCLK2_MPEG0                                    (0xff63c000 + (0x30 << 2))
#define SEC_HHI_GCLK2_MPEG0                                    (0xff63c000 + (0x30 << 2))
#define   P_HHI_GCLK2_MPEG0                                    (volatile uint32_t *)(0xff63c000 + (0x30 << 2))
#define     HHI_GCLK2_MPEG1                                    (0xff63c000 + (0x31 << 2))
#define SEC_HHI_GCLK2_MPEG1                                    (0xff63c000 + (0x31 << 2))
#define   P_HHI_GCLK2_MPEG1                                    (volatile uint32_t *)(0xff63c000 + (0x31 << 2))
#define     HHI_GCLK2_MPEG2                                    (0xff63c000 + (0x32 << 2))
#define SEC_HHI_GCLK2_MPEG2                                    (0xff63c000 + (0x32 << 2))
#define   P_HHI_GCLK2_MPEG2                                    (volatile uint32_t *)(0xff63c000 + (0x32 << 2))
#define     HHI_GCLK2_OTHER                                    (0xff63c000 + (0x34 << 2))
#define SEC_HHI_GCLK2_OTHER                                    (0xff63c000 + (0x34 << 2))
#define   P_HHI_GCLK2_OTHER                                    (volatile uint32_t *)(0xff63c000 + (0x34 << 2))
#define     HHI_GCLK2_AO                                       (0xff63c000 + (0x35 << 2))
#define SEC_HHI_GCLK2_AO                                       (0xff63c000 + (0x35 << 2))
#define   P_HHI_GCLK2_AO                                       (volatile uint32_t *)(0xff63c000 + (0x35 << 2))
#define     HHI_TIMER90K                                       (0xff63c000 + (0x3b << 2))
#define SEC_HHI_TIMER90K                                       (0xff63c000 + (0x3b << 2))
#define   P_HHI_TIMER90K                                       (volatile uint32_t *)(0xff63c000 + (0x3b << 2))
#define     HHI_DIF_TCON_CNTL0                                 (0xff63c000 + (0x3c << 2))
#define SEC_HHI_DIF_TCON_CNTL0                                 (0xff63c000 + (0x3c << 2))
#define   P_HHI_DIF_TCON_CNTL0                                 (volatile uint32_t *)(0xff63c000 + (0x3c << 2))
#define     HHI_DIF_TCON_CNTL1                                 (0xff63c000 + (0x3d << 2))
#define SEC_HHI_DIF_TCON_CNTL1                                 (0xff63c000 + (0x3d << 2))
#define   P_HHI_DIF_TCON_CNTL1                                 (volatile uint32_t *)(0xff63c000 + (0x3d << 2))
#define     HHI_DIF_TCON_CNTL2                                 (0xff63c000 + (0x3e << 2))
#define SEC_HHI_DIF_TCON_CNTL2                                 (0xff63c000 + (0x3e << 2))
#define   P_HHI_DIF_TCON_CNTL2                                 (volatile uint32_t *)(0xff63c000 + (0x3e << 2))
#define     HHI_MEM_PD_REG0                                    (0xff63c000 + (0x40 << 2))
#define SEC_HHI_MEM_PD_REG0                                    (0xff63c000 + (0x40 << 2))
#define   P_HHI_MEM_PD_REG0                                    (volatile uint32_t *)(0xff63c000 + (0x40 << 2))
//VIU1
//bit 29:28 mem_pd_vi_sharp,  2'b00: Sharpness line buffer memory power on, 2'b11: power down
//bit 29:28 mem_pd_vi_dipost, 2'b00: Deinterlace - di_post memory power on, 2'b11: power down
//bit 27:26 mem_pd_vi_dipre,  2'b00: Deinterlace - di_pre memory power on, 2'b11: power down
//bit 25:24 mem_pd_vi_prot3,  2'b00: picture rotation3 memory power on, 2'b11: power down
//bit 23:22 mem_pd_vi_prot2,  2'b00: picture rotation2 memory power on, 2'b11: power down
//bit 21:20 mem_pd_vi_prot1,  2'b00: picture rotation1 memory power on, 2'b11: power down
//bit 19:18 mem_pd_vi_vdin1,  2'b00: vdin1 memory power on, 2'b11: power down
//bit 17:16 mem_pd_vi_vdin0,  2'b00: vdin0 memory power on, 2'b11: power down
//bit 15:14 mem_pd_vi_osd_sc, 2'b00: osd_scaler memory power on, 2'b11: power down
//bit 13:12 mem_pd_vi_scale,  2'b00: scaler memory power on, 2'b11: power down
//bit 11:10 mem_pd_vi_ofifo,  2'b00: vpp output fifo memory power on, 2'b11: power down
//bit 9:8   mem_pd_vi_chroma, 2'b00: color management module memory power on, 2'b11: power down
//bit 7:6   mem_pd_vi_vd2,    2'b00: vd2 memory power on, 2'b11: power down
//bit 5:4   mem_pd_vi_vd1,    2'b00: vd1 memory power on, 2'b11: power down
//bit 3:2   mem_pd_vi_osd2,   2'b00: osd2 memory power on, 2'b11: power down
//bit 1:0   mem_pd_vi_osd1,   2'b00: osd1 memory power on, 2'b11: power down
#define     HHI_VPU_MEM_PD_REG0                                (0xff63c000 + (0x41 << 2))
#define SEC_HHI_VPU_MEM_PD_REG0                                (0xff63c000 + (0x41 << 2))
#define   P_HHI_VPU_MEM_PD_REG0                                (volatile uint32_t *)(0xff63c000 + (0x41 << 2))
//bit 29:28 mem_pd_atv_dmd,   2'b00: ATV DMD memory power on, 2'b11: power down
//bit 29:28 mem_pd_cvd2,      2'b00: CVD2 memory power on, 2'b11: power down
//bit 27:26 mem_pd_isp,       2'b00: ISP memory power on, 2'b11: power down
//bit 25:24 mem_pd_venci_int, 2'b00: cvbs- enci interface memory power on, 2'b11: power down
//bit 23:22 mem_pd_venc_l_top,2'b00: panel - encl top memory power on, 2'b11: power down
//bit 21:20 mem_pd_vencp_int, 2'b00: hdmi - encp interface memory power on, 2'b11: power down
//bit 13:12 mem_pd_vi2_osd_sc,2'b00: viu2 OSD scaler memory power on, 2'b11: power down
//bit 11:10 mem_pd_vi2_scale, 2'b00: viu2 scaler memory power on, 2'b11: power down
//bit 9:8   mem_pd_vi2_ofifo, 2'b00: viu2 vpp output fifo memory power on, 2'b11: power down
//bit 7:6   mem_pd_vi2_chroma,2'b00: viu2 color management module memory power on, 2'b11: power down
//bit 5:4   mem_pd_vi2_vd1,   2'b00: viu2 vd1 memory power on, 2'b11: power down
//bit 3:2   mem_pd_vi2_osd2,  2'b00: viu2 osd2 memory power on, 2'b11: power down
//bit 1:0   mem_pd_vi2_osd1,  2'b00: viu2 osd1 memory power on, 2'b11: power down
#define     HHI_VPU_MEM_PD_REG1                                (0xff63c000 + (0x42 << 2))
#define SEC_HHI_VPU_MEM_PD_REG1                                (0xff63c000 + (0x42 << 2))
#define   P_HHI_VPU_MEM_PD_REG1                                (volatile uint32_t *)(0xff63c000 + (0x42 << 2))
#define     HHI_DEMOD_MEM_PD_REG                               (0xff63c000 + (0x43 << 2))
#define SEC_HHI_DEMOD_MEM_PD_REG                               (0xff63c000 + (0x43 << 2))
#define   P_HHI_DEMOD_MEM_PD_REG                               (volatile uint32_t *)(0xff63c000 + (0x43 << 2))
#define     HHI_AUD_DAC_CTRL                                   (0xff63c000 + (0x44 << 2))
#define SEC_HHI_AUD_DAC_CTRL                                   (0xff63c000 + (0x44 << 2))
#define   P_HHI_AUD_DAC_CTRL                                   (volatile uint32_t *)(0xff63c000 + (0x44 << 2))
// `define HHI_VIID_PLL_CNTL4      8'h46 // video PLL read back
// `define HHI_VIID_PLL_CNTL       8'h47 // Video PLL control, word 1
// `define HHI_VIID_PLL_CNTL2      8'h48 // Video PLL control, word 2
// `define HHI_VIID_PLL_CNTL3      8'h49 // Video PLL control, word 3
#define     HHI_VIID_CLK_DIV                                   (0xff63c000 + (0x4a << 2))
#define SEC_HHI_VIID_CLK_DIV                                   (0xff63c000 + (0x4a << 2))
#define   P_HHI_VIID_CLK_DIV                                   (volatile uint32_t *)(0xff63c000 + (0x4a << 2))
#define     HHI_VIID_CLK_CNTL                                  (0xff63c000 + (0x4b << 2))
#define SEC_HHI_VIID_CLK_CNTL                                  (0xff63c000 + (0x4b << 2))
#define   P_HHI_VIID_CLK_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x4b << 2))
#define     HHI_VIID_DIVIDER_CNTL                              (0xff63c000 + (0x4c << 2))
#define SEC_HHI_VIID_DIVIDER_CNTL                              (0xff63c000 + (0x4c << 2))
#define   P_HHI_VIID_DIVIDER_CNTL                              (volatile uint32_t *)(0xff63c000 + (0x4c << 2))
//bit 1:0   mem_pd_vi_wm,  2'b00: viu1 wm memory power on, 2'b11: power down
#define     HHI_VPU_MEM_PD_REG2                                (0xff63c000 + (0x4d << 2))
#define SEC_HHI_VPU_MEM_PD_REG2                                (0xff63c000 + (0x4d << 2))
#define   P_HHI_VPU_MEM_PD_REG2                                (volatile uint32_t *)(0xff63c000 + (0x4d << 2))
// Gated clock enables.  There are 64 enables for the MPEG clocks and 32 enables for other clock domains
#define     HHI_GCLK_MPEG0                                     (0xff63c000 + (0x50 << 2))
#define SEC_HHI_GCLK_MPEG0                                     (0xff63c000 + (0x50 << 2))
#define   P_HHI_GCLK_MPEG0                                     (volatile uint32_t *)(0xff63c000 + (0x50 << 2))
#define     HHI_GCLK_MPEG1                                     (0xff63c000 + (0x51 << 2))
#define SEC_HHI_GCLK_MPEG1                                     (0xff63c000 + (0x51 << 2))
#define   P_HHI_GCLK_MPEG1                                     (volatile uint32_t *)(0xff63c000 + (0x51 << 2))
#define     HHI_GCLK_MPEG2                                     (0xff63c000 + (0x52 << 2))
#define SEC_HHI_GCLK_MPEG2                                     (0xff63c000 + (0x52 << 2))
#define   P_HHI_GCLK_MPEG2                                     (volatile uint32_t *)(0xff63c000 + (0x52 << 2))
#define     HHI_GCLK_OTHER                                     (0xff63c000 + (0x54 << 2))
#define SEC_HHI_GCLK_OTHER                                     (0xff63c000 + (0x54 << 2))
#define   P_HHI_GCLK_OTHER                                     (volatile uint32_t *)(0xff63c000 + (0x54 << 2))
#define     HHI_GCLK_AO                                        (0xff63c000 + (0x55 << 2))
#define SEC_HHI_GCLK_AO                                        (0xff63c000 + (0x55 << 2))
#define   P_HHI_GCLK_AO                                        (volatile uint32_t *)(0xff63c000 + (0x55 << 2))
//`define HHI_SYS_OSCIN_CNTL      8'h56
#define     HHI_SYS_CPU_CLK_CNTL1                              (0xff63c000 + (0x57 << 2))
#define SEC_HHI_SYS_CPU_CLK_CNTL1                              (0xff63c000 + (0x57 << 2))
#define   P_HHI_SYS_CPU_CLK_CNTL1                              (volatile uint32_t *)(0xff63c000 + (0x57 << 2))
#define     HHI_SYS_CPU_RESET_CNTL                             (0xff63c000 + (0x58 << 2))
#define SEC_HHI_SYS_CPU_RESET_CNTL                             (0xff63c000 + (0x58 << 2))
#define   P_HHI_SYS_CPU_RESET_CNTL                             (volatile uint32_t *)(0xff63c000 + (0x58 << 2))
// PLL Controls
#define     HHI_VID_CLK_DIV                                    (0xff63c000 + (0x59 << 2))
#define SEC_HHI_VID_CLK_DIV                                    (0xff63c000 + (0x59 << 2))
#define   P_HHI_VID_CLK_DIV                                    (volatile uint32_t *)(0xff63c000 + (0x59 << 2))
#define     HHI_MPEG_CLK_CNTL                                  (0xff63c000 + (0x5d << 2))
#define SEC_HHI_MPEG_CLK_CNTL                                  (0xff63c000 + (0x5d << 2))
#define   P_HHI_MPEG_CLK_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x5d << 2))
#define     HHI_AUD_CLK_CNTL                                   (0xff63c000 + (0x5e << 2))
#define SEC_HHI_AUD_CLK_CNTL                                   (0xff63c000 + (0x5e << 2))
#define   P_HHI_AUD_CLK_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x5e << 2))
#define     HHI_VID_CLK_CNTL                                   (0xff63c000 + (0x5f << 2))
#define SEC_HHI_VID_CLK_CNTL                                   (0xff63c000 + (0x5f << 2))
#define   P_HHI_VID_CLK_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x5f << 2))
#define     HHI_WIFI_CLK_CNTL                                  (0xff63c000 + (0x60 << 2))
#define SEC_HHI_WIFI_CLK_CNTL                                  (0xff63c000 + (0x60 << 2))
#define   P_HHI_WIFI_CLK_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x60 << 2))
#define     HHI_WIFI_PLL_CNTL                                  (0xff63c000 + (0x61 << 2))
#define SEC_HHI_WIFI_PLL_CNTL                                  (0xff63c000 + (0x61 << 2))
#define   P_HHI_WIFI_PLL_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x61 << 2))
#define     HHI_WIFI_PLL_CNTL2                                 (0xff63c000 + (0x62 << 2))
#define SEC_HHI_WIFI_PLL_CNTL2                                 (0xff63c000 + (0x62 << 2))
#define   P_HHI_WIFI_PLL_CNTL2                                 (volatile uint32_t *)(0xff63c000 + (0x62 << 2))
#define     HHI_WIFI_PLL_CNTL3                                 (0xff63c000 + (0x63 << 2))
#define SEC_HHI_WIFI_PLL_CNTL3                                 (0xff63c000 + (0x63 << 2))
#define   P_HHI_WIFI_PLL_CNTL3                                 (volatile uint32_t *)(0xff63c000 + (0x63 << 2))
#define     HHI_AUD_CLK_CNTL2                                  (0xff63c000 + (0x64 << 2))
#define SEC_HHI_AUD_CLK_CNTL2                                  (0xff63c000 + (0x64 << 2))
#define   P_HHI_AUD_CLK_CNTL2                                  (volatile uint32_t *)(0xff63c000 + (0x64 << 2))
#define     HHI_VID_CLK_CNTL2                                  (0xff63c000 + (0x65 << 2))
#define SEC_HHI_VID_CLK_CNTL2                                  (0xff63c000 + (0x65 << 2))
#define   P_HHI_VID_CLK_CNTL2                                  (volatile uint32_t *)(0xff63c000 + (0x65 << 2))
#define     HHI_VID_DIVIDER_CNTL                               (0xff63c000 + (0x66 << 2))
#define SEC_HHI_VID_DIVIDER_CNTL                               (0xff63c000 + (0x66 << 2))
#define   P_HHI_VID_DIVIDER_CNTL                               (volatile uint32_t *)(0xff63c000 + (0x66 << 2))
#define     HHI_SYS_CPU_CLK_CNTL                               (0xff63c000 + (0x67 << 2))
#define SEC_HHI_SYS_CPU_CLK_CNTL                               (0xff63c000 + (0x67 << 2))
#define   P_HHI_SYS_CPU_CLK_CNTL                               (volatile uint32_t *)(0xff63c000 + (0x67 << 2))
#define     HHI_VID_PLL_CLK_DIV                                (0xff63c000 + (0x68 << 2))
#define SEC_HHI_VID_PLL_CLK_DIV                                (0xff63c000 + (0x68 << 2))
#define   P_HHI_VID_PLL_CLK_DIV                                (volatile uint32_t *)(0xff63c000 + (0x68 << 2))
#define     HHI_AUD_CLK_CNTL3                                  (0xff63c000 + (0x69 << 2))
#define SEC_HHI_AUD_CLK_CNTL3                                  (0xff63c000 + (0x69 << 2))
#define   P_HHI_AUD_CLK_CNTL3                                  (volatile uint32_t *)(0xff63c000 + (0x69 << 2))
#define     HHI_AUD_CLK_CNTL4                                  (0xff63c000 + (0x6a << 2))
#define SEC_HHI_AUD_CLK_CNTL4                                  (0xff63c000 + (0x6a << 2))
#define   P_HHI_AUD_CLK_CNTL4                                  (volatile uint32_t *)(0xff63c000 + (0x6a << 2))
// Moved to Martin's domain `define HHI_DDR_PLL_CNTL        8'h68 // DDR PLL control, word 1
// Moved to Martin's domain `define HHI_DDR_PLL_CNTL2       8'h69 // DDR PLL control, word 2
// Moved to Martin's domain `define HHI_DDR_PLL_CNTL3       8'h6a // DDR PLL control, word 3
// Moved to Martin's domain `define HHI_DDR_PLL_CNTL4       8'h6b // DDR PLL control, word 3
#define     HHI_MALI_CLK_CNTL                                  (0xff63c000 + (0x6c << 2))
#define SEC_HHI_MALI_CLK_CNTL                                  (0xff63c000 + (0x6c << 2))
#define   P_HHI_MALI_CLK_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x6c << 2))
#define     HHI_MIPI_PHY_CLK_CNTL                              (0xff63c000 + (0x6e << 2))
#define SEC_HHI_MIPI_PHY_CLK_CNTL                              (0xff63c000 + (0x6e << 2))
#define   P_HHI_MIPI_PHY_CLK_CNTL                              (volatile uint32_t *)(0xff63c000 + (0x6e << 2))
#define     HHI_VPU_CLK_CNTL                                   (0xff63c000 + (0x6f << 2))
#define SEC_HHI_VPU_CLK_CNTL                                   (0xff63c000 + (0x6f << 2))
#define   P_HHI_VPU_CLK_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x6f << 2))
#define     HHI_OTHER_PLL_CNTL                                 (0xff63c000 + (0x70 << 2))
#define SEC_HHI_OTHER_PLL_CNTL                                 (0xff63c000 + (0x70 << 2))
#define   P_HHI_OTHER_PLL_CNTL                                 (volatile uint32_t *)(0xff63c000 + (0x70 << 2))
#define     HHI_OTHER_PLL_CNTL2                                (0xff63c000 + (0x71 << 2))
#define SEC_HHI_OTHER_PLL_CNTL2                                (0xff63c000 + (0x71 << 2))
#define   P_HHI_OTHER_PLL_CNTL2                                (volatile uint32_t *)(0xff63c000 + (0x71 << 2))
#define     HHI_OTHER_PLL_CNTL3                                (0xff63c000 + (0x72 << 2))
#define SEC_HHI_OTHER_PLL_CNTL3                                (0xff63c000 + (0x72 << 2))
#define   P_HHI_OTHER_PLL_CNTL3                                (volatile uint32_t *)(0xff63c000 + (0x72 << 2))
#define     HHI_HDMI_CLK_CNTL                                  (0xff63c000 + (0x73 << 2))
#define SEC_HHI_HDMI_CLK_CNTL                                  (0xff63c000 + (0x73 << 2))
#define   P_HHI_HDMI_CLK_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x73 << 2))
#define     HHI_DEMOD_CLK_CNTL                                 (0xff63c000 + (0x74 << 2))
#define SEC_HHI_DEMOD_CLK_CNTL                                 (0xff63c000 + (0x74 << 2))
#define   P_HHI_DEMOD_CLK_CNTL                                 (volatile uint32_t *)(0xff63c000 + (0x74 << 2))
#define     HHI_SATA_CLK_CNTL                                  (0xff63c000 + (0x75 << 2))
#define SEC_HHI_SATA_CLK_CNTL                                  (0xff63c000 + (0x75 << 2))
#define   P_HHI_SATA_CLK_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x75 << 2))
#define     HHI_ETH_CLK_CNTL                                   (0xff63c000 + (0x76 << 2))
#define SEC_HHI_ETH_CLK_CNTL                                   (0xff63c000 + (0x76 << 2))
#define   P_HHI_ETH_CLK_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x76 << 2))
#define     HHI_CLK_DOUBLE_CNTL                                (0xff63c000 + (0x77 << 2))
#define SEC_HHI_CLK_DOUBLE_CNTL                                (0xff63c000 + (0x77 << 2))
#define   P_HHI_CLK_DOUBLE_CNTL                                (volatile uint32_t *)(0xff63c000 + (0x77 << 2))
#define     HHI_VDEC_CLK_CNTL                                  (0xff63c000 + (0x78 << 2))
#define SEC_HHI_VDEC_CLK_CNTL                                  (0xff63c000 + (0x78 << 2))
#define   P_HHI_VDEC_CLK_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x78 << 2))
#define     HHI_VDEC2_CLK_CNTL                                 (0xff63c000 + (0x79 << 2))
#define SEC_HHI_VDEC2_CLK_CNTL                                 (0xff63c000 + (0x79 << 2))
#define   P_HHI_VDEC2_CLK_CNTL                                 (volatile uint32_t *)(0xff63c000 + (0x79 << 2))
#define     HHI_VDEC3_CLK_CNTL                                 (0xff63c000 + (0x7a << 2))
#define SEC_HHI_VDEC3_CLK_CNTL                                 (0xff63c000 + (0x7a << 2))
#define   P_HHI_VDEC3_CLK_CNTL                                 (volatile uint32_t *)(0xff63c000 + (0x7a << 2))
#define     HHI_VDEC4_CLK_CNTL                                 (0xff63c000 + (0x7b << 2))
#define SEC_HHI_VDEC4_CLK_CNTL                                 (0xff63c000 + (0x7b << 2))
#define   P_HHI_VDEC4_CLK_CNTL                                 (volatile uint32_t *)(0xff63c000 + (0x7b << 2))
//`define HHI_HDCP22_CLK_CNTL     8'h7c // HDMI HDCP2.2 clock control
#define     HHI_VAPBCLK_CNTL                                   (0xff63c000 + (0x7d << 2))
#define SEC_HHI_VAPBCLK_CNTL                                   (0xff63c000 + (0x7d << 2))
#define   P_HHI_VAPBCLK_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x7d << 2))
#define     HHI_VP9DEC_CLK_CNTL                                (0xff63c000 + (0x7e << 2))
#define SEC_HHI_VP9DEC_CLK_CNTL                                (0xff63c000 + (0x7e << 2))
#define   P_HHI_VP9DEC_CLK_CNTL                                (volatile uint32_t *)(0xff63c000 + (0x7e << 2))
// `define HHI_SYS_CPU_AUTO_CLK0        8'h78   never used
// `define HHI_SYS_CPU_AUTO_CLK1        8'h79   never used
// `define HHI_MEDIA_CPU_AUTO_CLK0    8'h7a     never used
// `define HHI_MEDIA_CPU_AUTO_CLK1    8'h7b     never used
#define     HHI_HDMI_AFC_CNTL                                  (0xff63c000 + (0x7f << 2))
#define SEC_HHI_HDMI_AFC_CNTL                                  (0xff63c000 + (0x7f << 2))
#define   P_HHI_HDMI_AFC_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x7f << 2))
#define     HHI_HDMIRX_CLK_CNTL                                (0xff63c000 + (0x80 << 2))
#define SEC_HHI_HDMIRX_CLK_CNTL                                (0xff63c000 + (0x80 << 2))
#define   P_HHI_HDMIRX_CLK_CNTL                                (volatile uint32_t *)(0xff63c000 + (0x80 << 2))
#define     HHI_HDMIRX_AUD_CLK_CNTL                            (0xff63c000 + (0x81 << 2))
#define SEC_HHI_HDMIRX_AUD_CLK_CNTL                            (0xff63c000 + (0x81 << 2))
#define   P_HHI_HDMIRX_AUD_CLK_CNTL                            (volatile uint32_t *)(0xff63c000 + (0x81 << 2))
#define     HHI_EDP_APB_CLK_CNTL                               (0xff63c000 + (0x82 << 2))
#define SEC_HHI_EDP_APB_CLK_CNTL                               (0xff63c000 + (0x82 << 2))
#define   P_HHI_EDP_APB_CLK_CNTL                               (volatile uint32_t *)(0xff63c000 + (0x82 << 2))
#define     HHI_VPU_CLKB_CNTL                                  (0xff63c000 + (0x83 << 2))
#define SEC_HHI_VPU_CLKB_CNTL                                  (0xff63c000 + (0x83 << 2))
#define   P_HHI_VPU_CLKB_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x83 << 2))
#define     HHI_VID_PLL_MOD_CNTL0                              (0xff63c000 + (0x84 << 2))
#define SEC_HHI_VID_PLL_MOD_CNTL0                              (0xff63c000 + (0x84 << 2))
#define   P_HHI_VID_PLL_MOD_CNTL0                              (volatile uint32_t *)(0xff63c000 + (0x84 << 2))
#define     HHI_VID_PLL_MOD_LOW_TCNT                           (0xff63c000 + (0x85 << 2))
#define SEC_HHI_VID_PLL_MOD_LOW_TCNT                           (0xff63c000 + (0x85 << 2))
#define   P_HHI_VID_PLL_MOD_LOW_TCNT                           (volatile uint32_t *)(0xff63c000 + (0x85 << 2))
#define     HHI_VID_PLL_MOD_HIGH_TCNT                          (0xff63c000 + (0x86 << 2))
#define SEC_HHI_VID_PLL_MOD_HIGH_TCNT                          (0xff63c000 + (0x86 << 2))
#define   P_HHI_VID_PLL_MOD_HIGH_TCNT                          (volatile uint32_t *)(0xff63c000 + (0x86 << 2))
#define     HHI_VID_PLL_MOD_NOM_TCNT                           (0xff63c000 + (0x87 << 2))
#define SEC_HHI_VID_PLL_MOD_NOM_TCNT                           (0xff63c000 + (0x87 << 2))
#define   P_HHI_VID_PLL_MOD_NOM_TCNT                           (volatile uint32_t *)(0xff63c000 + (0x87 << 2))
#define     HHI_USB_CLK_CNTL                                   (0xff63c000 + (0x88 << 2))
#define SEC_HHI_USB_CLK_CNTL                                   (0xff63c000 + (0x88 << 2))
#define   P_HHI_USB_CLK_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x88 << 2))
// Removed `define HHI_DDR_CLK_CNTL            8'h88
#define     HHI_32K_CLK_CNTL                                   (0xff63c000 + (0x89 << 2))
#define SEC_HHI_32K_CLK_CNTL                                   (0xff63c000 + (0x89 << 2))
#define   P_HHI_32K_CLK_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x89 << 2))
#define     HHI_GEN_CLK_CNTL                                   (0xff63c000 + (0x8a << 2))
#define SEC_HHI_GEN_CLK_CNTL                                   (0xff63c000 + (0x8a << 2))
#define   P_HHI_GEN_CLK_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x8a << 2))
#define     HHI_GEN_CLK_CNTL2                                  (0xff63c000 + (0x8b << 2))
#define SEC_HHI_GEN_CLK_CNTL2                                  (0xff63c000 + (0x8b << 2))
#define   P_HHI_GEN_CLK_CNTL2                                  (volatile uint32_t *)(0xff63c000 + (0x8b << 2))
#define     HHI_AUDPLL_CLK_OUT_CNTL                            (0xff63c000 + (0x8c << 2))
#define SEC_HHI_AUDPLL_CLK_OUT_CNTL                            (0xff63c000 + (0x8c << 2))
#define   P_HHI_AUDPLL_CLK_OUT_CNTL                            (volatile uint32_t *)(0xff63c000 + (0x8c << 2))
#define     HHI_ALOCKER_CLK_CNTL                               (0xff63c000 + (0x8d << 2))
#define SEC_HHI_ALOCKER_CLK_CNTL                               (0xff63c000 + (0x8d << 2))
#define   P_HHI_ALOCKER_CLK_CNTL                               (volatile uint32_t *)(0xff63c000 + (0x8d << 2))
#define     HHI_JTAG_CONFIG                                    (0xff63c000 + (0x8e << 2))
#define SEC_HHI_JTAG_CONFIG                                    (0xff63c000 + (0x8e << 2))
#define   P_HHI_JTAG_CONFIG                                    (volatile uint32_t *)(0xff63c000 + (0x8e << 2))
#define     HHI_VAFE_CLKXTALIN_CNTL                            (0xff63c000 + (0x8f << 2))
#define SEC_HHI_VAFE_CLKXTALIN_CNTL                            (0xff63c000 + (0x8f << 2))
#define   P_HHI_VAFE_CLKXTALIN_CNTL                            (volatile uint32_t *)(0xff63c000 + (0x8f << 2))
#define     HHI_VAFE_CLKOSCIN_CNTL                             (0xff63c000 + (0x90 << 2))
#define SEC_HHI_VAFE_CLKOSCIN_CNTL                             (0xff63c000 + (0x90 << 2))
#define   P_HHI_VAFE_CLKOSCIN_CNTL                             (volatile uint32_t *)(0xff63c000 + (0x90 << 2))
#define     HHI_VAFE_CLKIN_CNTL                                (0xff63c000 + (0x91 << 2))
#define SEC_HHI_VAFE_CLKIN_CNTL                                (0xff63c000 + (0x91 << 2))
#define   P_HHI_VAFE_CLKIN_CNTL                                (volatile uint32_t *)(0xff63c000 + (0x91 << 2))
#define     HHI_TVFE_AUTOMODE_CLK_CNTL                         (0xff63c000 + (0x92 << 2))
#define SEC_HHI_TVFE_AUTOMODE_CLK_CNTL                         (0xff63c000 + (0x92 << 2))
#define   P_HHI_TVFE_AUTOMODE_CLK_CNTL                         (volatile uint32_t *)(0xff63c000 + (0x92 << 2))
#define     HHI_VAFE_CLKPI_CNTL                                (0xff63c000 + (0x93 << 2))
#define SEC_HHI_VAFE_CLKPI_CNTL                                (0xff63c000 + (0x93 << 2))
#define   P_HHI_VAFE_CLKPI_CNTL                                (volatile uint32_t *)(0xff63c000 + (0x93 << 2))
#define     HHI_VDIN_MEAS_CLK_CNTL                             (0xff63c000 + (0x94 << 2))
#define SEC_HHI_VDIN_MEAS_CLK_CNTL                             (0xff63c000 + (0x94 << 2))
#define   P_HHI_VDIN_MEAS_CLK_CNTL                             (volatile uint32_t *)(0xff63c000 + (0x94 << 2))
// `define HHI_PCM2_CLK_CNTL           8'h95
#define     HHI_PCM_CLK_CNTL                                   (0xff63c000 + (0x96 << 2))
#define SEC_HHI_PCM_CLK_CNTL                                   (0xff63c000 + (0x96 << 2))
#define   P_HHI_PCM_CLK_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x96 << 2))
#define     HHI_NAND_CLK_CNTL                                  (0xff63c000 + (0x97 << 2))
#define SEC_HHI_NAND_CLK_CNTL                                  (0xff63c000 + (0x97 << 2))
#define   P_HHI_NAND_CLK_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x97 << 2))
#define     HHI_ISP_LED_CLK_CNTL                               (0xff63c000 + (0x98 << 2))
#define SEC_HHI_ISP_LED_CLK_CNTL                               (0xff63c000 + (0x98 << 2))
#define   P_HHI_ISP_LED_CLK_CNTL                               (volatile uint32_t *)(0xff63c000 + (0x98 << 2))
#define     HHI_SD_EMMC_CLK_CNTL                               (0xff63c000 + (0x99 << 2))
#define SEC_HHI_SD_EMMC_CLK_CNTL                               (0xff63c000 + (0x99 << 2))
#define   P_HHI_SD_EMMC_CLK_CNTL                               (volatile uint32_t *)(0xff63c000 + (0x99 << 2))
#define     HHI_EDP_TX_PHY_CNTL0                               (0xff63c000 + (0x9c << 2))
#define SEC_HHI_EDP_TX_PHY_CNTL0                               (0xff63c000 + (0x9c << 2))
#define   P_HHI_EDP_TX_PHY_CNTL0                               (volatile uint32_t *)(0xff63c000 + (0x9c << 2))
#define     HHI_EDP_TX_PHY_CNTL1                               (0xff63c000 + (0x9d << 2))
#define SEC_HHI_EDP_TX_PHY_CNTL1                               (0xff63c000 + (0x9d << 2))
#define   P_HHI_EDP_TX_PHY_CNTL1                               (volatile uint32_t *)(0xff63c000 + (0x9d << 2))
#define     HHI_ADC_PLL_CNTL5                                  (0xff63c000 + (0x9e << 2))
#define SEC_HHI_ADC_PLL_CNTL5                                  (0xff63c000 + (0x9e << 2))
#define   P_HHI_ADC_PLL_CNTL5                                  (volatile uint32_t *)(0xff63c000 + (0x9e << 2))
#define     HHI_ADC_PLL_CNTL6                                  (0xff63c000 + (0x9f << 2))
#define SEC_HHI_ADC_PLL_CNTL6                                  (0xff63c000 + (0x9f << 2))
#define   P_HHI_ADC_PLL_CNTL6                                  (volatile uint32_t *)(0xff63c000 + (0x9f << 2))
#define     HHI_MPLL_CNTL                                      (0xff63c000 + (0xa0 << 2))
#define SEC_HHI_MPLL_CNTL                                      (0xff63c000 + (0xa0 << 2))
#define   P_HHI_MPLL_CNTL                                      (volatile uint32_t *)(0xff63c000 + (0xa0 << 2))
#define     HHI_MPLL_CNTL2                                     (0xff63c000 + (0xa1 << 2))
#define SEC_HHI_MPLL_CNTL2                                     (0xff63c000 + (0xa1 << 2))
#define   P_HHI_MPLL_CNTL2                                     (volatile uint32_t *)(0xff63c000 + (0xa1 << 2))
#define     HHI_MPLL_CNTL3                                     (0xff63c000 + (0xa2 << 2))
#define SEC_HHI_MPLL_CNTL3                                     (0xff63c000 + (0xa2 << 2))
#define   P_HHI_MPLL_CNTL3                                     (volatile uint32_t *)(0xff63c000 + (0xa2 << 2))
#define     HHI_MPLL_CNTL4                                     (0xff63c000 + (0xa3 << 2))
#define SEC_HHI_MPLL_CNTL4                                     (0xff63c000 + (0xa3 << 2))
#define   P_HHI_MPLL_CNTL4                                     (volatile uint32_t *)(0xff63c000 + (0xa3 << 2))
#define     HHI_MPLL_CNTL5                                     (0xff63c000 + (0xa4 << 2))
#define SEC_HHI_MPLL_CNTL5                                     (0xff63c000 + (0xa4 << 2))
#define   P_HHI_MPLL_CNTL5                                     (volatile uint32_t *)(0xff63c000 + (0xa4 << 2))
#define     HHI_MPLL_CNTL6                                     (0xff63c000 + (0xa5 << 2))
#define SEC_HHI_MPLL_CNTL6                                     (0xff63c000 + (0xa5 << 2))
#define   P_HHI_MPLL_CNTL6                                     (volatile uint32_t *)(0xff63c000 + (0xa5 << 2))
#define     HHI_MPLL_CNTL7                                     (0xff63c000 + (0xa6 << 2))
#define SEC_HHI_MPLL_CNTL7                                     (0xff63c000 + (0xa6 << 2))
#define   P_HHI_MPLL_CNTL7                                     (volatile uint32_t *)(0xff63c000 + (0xa6 << 2))
#define     HHI_MPLL_CNTL8                                     (0xff63c000 + (0xa7 << 2))
#define SEC_HHI_MPLL_CNTL8                                     (0xff63c000 + (0xa7 << 2))
#define   P_HHI_MPLL_CNTL8                                     (volatile uint32_t *)(0xff63c000 + (0xa7 << 2))
#define     HHI_MPLL_CNTL9                                     (0xff63c000 + (0xa8 << 2))
#define SEC_HHI_MPLL_CNTL9                                     (0xff63c000 + (0xa8 << 2))
#define   P_HHI_MPLL_CNTL9                                     (volatile uint32_t *)(0xff63c000 + (0xa8 << 2))
#define     HHI_MPLL_CNTL10                                    (0xff63c000 + (0xa9 << 2))
#define SEC_HHI_MPLL_CNTL10                                    (0xff63c000 + (0xa9 << 2))
#define   P_HHI_MPLL_CNTL10                                    (volatile uint32_t *)(0xff63c000 + (0xa9 << 2))
#define     HHI_ADC_PLL_CNTL                                   (0xff63c000 + (0xaa << 2))
#define SEC_HHI_ADC_PLL_CNTL                                   (0xff63c000 + (0xaa << 2))
#define   P_HHI_ADC_PLL_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0xaa << 2))
#define     HHI_ADC_PLL_CNTL2                                  (0xff63c000 + (0xab << 2))
#define SEC_HHI_ADC_PLL_CNTL2                                  (0xff63c000 + (0xab << 2))
#define   P_HHI_ADC_PLL_CNTL2                                  (volatile uint32_t *)(0xff63c000 + (0xab << 2))
#define     HHI_ADC_PLL_CNTL3                                  (0xff63c000 + (0xac << 2))
#define SEC_HHI_ADC_PLL_CNTL3                                  (0xff63c000 + (0xac << 2))
#define   P_HHI_ADC_PLL_CNTL3                                  (volatile uint32_t *)(0xff63c000 + (0xac << 2))
#define     HHI_ADC_PLL_CNTL4                                  (0xff63c000 + (0xad << 2))
#define SEC_HHI_ADC_PLL_CNTL4                                  (0xff63c000 + (0xad << 2))
#define   P_HHI_ADC_PLL_CNTL4                                  (volatile uint32_t *)(0xff63c000 + (0xad << 2))
#define     HHI_ADC_PLL_STS                                    (0xff63c000 + (0xae << 2))
#define SEC_HHI_ADC_PLL_STS                                    (0xff63c000 + (0xae << 2))
#define   P_HHI_ADC_PLL_STS                                    (volatile uint32_t *)(0xff63c000 + (0xae << 2))
#define     HHI_ADC_PLL_CNTL1                                  (0xff63c000 + (0xaf << 2))
#define SEC_HHI_ADC_PLL_CNTL1                                  (0xff63c000 + (0xaf << 2))
#define   P_HHI_ADC_PLL_CNTL1                                  (volatile uint32_t *)(0xff63c000 + (0xaf << 2))
#define     HHI_AUDCLK_PLL_CNTL                                (0xff63c000 + (0xb0 << 2))
#define SEC_HHI_AUDCLK_PLL_CNTL                                (0xff63c000 + (0xb0 << 2))
#define   P_HHI_AUDCLK_PLL_CNTL                                (volatile uint32_t *)(0xff63c000 + (0xb0 << 2))
#define     HHI_AUDCLK_PLL_CNTL2                               (0xff63c000 + (0xb1 << 2))
#define SEC_HHI_AUDCLK_PLL_CNTL2                               (0xff63c000 + (0xb1 << 2))
#define   P_HHI_AUDCLK_PLL_CNTL2                               (volatile uint32_t *)(0xff63c000 + (0xb1 << 2))
#define     HHI_AUDCLK_PLL_CNTL3                               (0xff63c000 + (0xb2 << 2))
#define SEC_HHI_AUDCLK_PLL_CNTL3                               (0xff63c000 + (0xb2 << 2))
#define   P_HHI_AUDCLK_PLL_CNTL3                               (volatile uint32_t *)(0xff63c000 + (0xb2 << 2))
#define     HHI_AUDCLK_PLL_CNTL4                               (0xff63c000 + (0xb3 << 2))
#define SEC_HHI_AUDCLK_PLL_CNTL4                               (0xff63c000 + (0xb3 << 2))
#define   P_HHI_AUDCLK_PLL_CNTL4                               (volatile uint32_t *)(0xff63c000 + (0xb3 << 2))
#define     HHI_AUDCLK_PLL_CNTL5                               (0xff63c000 + (0xb4 << 2))
#define SEC_HHI_AUDCLK_PLL_CNTL5                               (0xff63c000 + (0xb4 << 2))
#define   P_HHI_AUDCLK_PLL_CNTL5                               (volatile uint32_t *)(0xff63c000 + (0xb4 << 2))
#define     HHI_AUDCLK_PLL_CNTL6                               (0xff63c000 + (0xb5 << 2))
#define SEC_HHI_AUDCLK_PLL_CNTL6                               (0xff63c000 + (0xb5 << 2))
#define   P_HHI_AUDCLK_PLL_CNTL6                               (volatile uint32_t *)(0xff63c000 + (0xb5 << 2))
#define     HHI_L2_DDR_CLK_CNTL                                (0xff63c000 + (0xb6 << 2))
#define SEC_HHI_L2_DDR_CLK_CNTL                                (0xff63c000 + (0xb6 << 2))
#define   P_HHI_L2_DDR_CLK_CNTL                                (volatile uint32_t *)(0xff63c000 + (0xb6 << 2))
#define     HHI_MPLL3_CNTL0                                    (0xff63c000 + (0xb8 << 2))
#define SEC_HHI_MPLL3_CNTL0                                    (0xff63c000 + (0xb8 << 2))
#define   P_HHI_MPLL3_CNTL0                                    (volatile uint32_t *)(0xff63c000 + (0xb8 << 2))
#define     HHI_MPLL3_CNTL1                                    (0xff63c000 + (0xb9 << 2))
#define SEC_HHI_MPLL3_CNTL1                                    (0xff63c000 + (0xb9 << 2))
#define   P_HHI_MPLL3_CNTL1                                    (volatile uint32_t *)(0xff63c000 + (0xb9 << 2))
#define     HHI_PLL_TOP_MISC                                   (0xff63c000 + (0xba << 2))
#define SEC_HHI_PLL_TOP_MISC                                   (0xff63c000 + (0xba << 2))
#define   P_HHI_PLL_TOP_MISC                                   (volatile uint32_t *)(0xff63c000 + (0xba << 2))
#define     HHI_VDAC_CNTL0                                     (0xff63c000 + (0xbd << 2))
#define SEC_HHI_VDAC_CNTL0                                     (0xff63c000 + (0xbd << 2))
#define   P_HHI_VDAC_CNTL0                                     (volatile uint32_t *)(0xff63c000 + (0xbd << 2))
#define     HHI_VDAC_CNTL1                                     (0xff63c000 + (0xbe << 2))
#define SEC_HHI_VDAC_CNTL1                                     (0xff63c000 + (0xbe << 2))
#define   P_HHI_VDAC_CNTL1                                     (volatile uint32_t *)(0xff63c000 + (0xbe << 2))
#define     HHI_SYS_PLL_CNTL1                                  (0xff63c000 + (0xbf << 2))
#define SEC_HHI_SYS_PLL_CNTL1                                  (0xff63c000 + (0xbf << 2))
#define   P_HHI_SYS_PLL_CNTL1                                  (volatile uint32_t *)(0xff63c000 + (0xbf << 2))
#define     HHI_SYS_PLL_CNTL                                   (0xff63c000 + (0xc0 << 2))
#define SEC_HHI_SYS_PLL_CNTL                                   (0xff63c000 + (0xc0 << 2))
#define   P_HHI_SYS_PLL_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0xc0 << 2))
#define     HHI_SYS_PLL_CNTL2                                  (0xff63c000 + (0xc1 << 2))
#define SEC_HHI_SYS_PLL_CNTL2                                  (0xff63c000 + (0xc1 << 2))
#define   P_HHI_SYS_PLL_CNTL2                                  (volatile uint32_t *)(0xff63c000 + (0xc1 << 2))
#define     HHI_SYS_PLL_CNTL3                                  (0xff63c000 + (0xc2 << 2))
#define SEC_HHI_SYS_PLL_CNTL3                                  (0xff63c000 + (0xc2 << 2))
#define   P_HHI_SYS_PLL_CNTL3                                  (volatile uint32_t *)(0xff63c000 + (0xc2 << 2))
#define     HHI_SYS_PLL_CNTL4                                  (0xff63c000 + (0xc3 << 2))
#define SEC_HHI_SYS_PLL_CNTL4                                  (0xff63c000 + (0xc3 << 2))
#define   P_HHI_SYS_PLL_CNTL4                                  (volatile uint32_t *)(0xff63c000 + (0xc3 << 2))
#define     HHI_SYS_PLL_CNTL5                                  (0xff63c000 + (0xc4 << 2))
#define SEC_HHI_SYS_PLL_CNTL5                                  (0xff63c000 + (0xc4 << 2))
#define   P_HHI_SYS_PLL_CNTL5                                  (volatile uint32_t *)(0xff63c000 + (0xc4 << 2))
#define     HHI_SYS_PLL_STS                                    (0xff63c000 + (0xc5 << 2))
#define SEC_HHI_SYS_PLL_STS                                    (0xff63c000 + (0xc5 << 2))
#define   P_HHI_SYS_PLL_STS                                    (volatile uint32_t *)(0xff63c000 + (0xc5 << 2))
#define     HHI_DPLL_TOP_I                                     (0xff63c000 + (0xc6 << 2))
#define SEC_HHI_DPLL_TOP_I                                     (0xff63c000 + (0xc6 << 2))
#define   P_HHI_DPLL_TOP_I                                     (volatile uint32_t *)(0xff63c000 + (0xc6 << 2))
#define     HHI_DPLL_TOP2_I                                    (0xff63c000 + (0xc7 << 2))
#define SEC_HHI_DPLL_TOP2_I                                    (0xff63c000 + (0xc7 << 2))
#define   P_HHI_DPLL_TOP2_I                                    (volatile uint32_t *)(0xff63c000 + (0xc7 << 2))
#define     HHI_HDMI_PLL_CNTL                                  (0xff63c000 + (0xc8 << 2))
#define SEC_HHI_HDMI_PLL_CNTL                                  (0xff63c000 + (0xc8 << 2))
#define   P_HHI_HDMI_PLL_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0xc8 << 2))
#define     HHI_HDMI_PLL_CNTL1                                 (0xff63c000 + (0xc9 << 2))
#define SEC_HHI_HDMI_PLL_CNTL1                                 (0xff63c000 + (0xc9 << 2))
#define   P_HHI_HDMI_PLL_CNTL1                                 (volatile uint32_t *)(0xff63c000 + (0xc9 << 2))
#define     HHI_HDMI_PLL_CNTL2                                 (0xff63c000 + (0xca << 2))
#define SEC_HHI_HDMI_PLL_CNTL2                                 (0xff63c000 + (0xca << 2))
#define   P_HHI_HDMI_PLL_CNTL2                                 (volatile uint32_t *)(0xff63c000 + (0xca << 2))
#define     HHI_HDMI_PLL_CNTL3                                 (0xff63c000 + (0xcb << 2))
#define SEC_HHI_HDMI_PLL_CNTL3                                 (0xff63c000 + (0xcb << 2))
#define   P_HHI_HDMI_PLL_CNTL3                                 (volatile uint32_t *)(0xff63c000 + (0xcb << 2))
#define     HHI_HDMI_PLL_CNTL4                                 (0xff63c000 + (0xcc << 2))
#define SEC_HHI_HDMI_PLL_CNTL4                                 (0xff63c000 + (0xcc << 2))
#define   P_HHI_HDMI_PLL_CNTL4                                 (volatile uint32_t *)(0xff63c000 + (0xcc << 2))
#define     HHI_HDMI_PLL_CNTL5                                 (0xff63c000 + (0xcd << 2))
#define SEC_HHI_HDMI_PLL_CNTL5                                 (0xff63c000 + (0xcd << 2))
#define   P_HHI_HDMI_PLL_CNTL5                                 (volatile uint32_t *)(0xff63c000 + (0xcd << 2))
#define     HHI_HDMI_PLL_STS                                   (0xff63c000 + (0xce << 2))
#define SEC_HHI_HDMI_PLL_STS                                   (0xff63c000 + (0xce << 2))
#define   P_HHI_HDMI_PLL_STS                                   (volatile uint32_t *)(0xff63c000 + (0xce << 2))
#define     HHI_DSI_LVDS_EDP_CNTL0                             (0xff63c000 + (0xd1 << 2))
#define SEC_HHI_DSI_LVDS_EDP_CNTL0                             (0xff63c000 + (0xd1 << 2))
#define   P_HHI_DSI_LVDS_EDP_CNTL0                             (volatile uint32_t *)(0xff63c000 + (0xd1 << 2))
#define     HHI_DSI_LVDS_EDP_CNTL1                             (0xff63c000 + (0xd2 << 2))
#define SEC_HHI_DSI_LVDS_EDP_CNTL1                             (0xff63c000 + (0xd2 << 2))
#define   P_HHI_DSI_LVDS_EDP_CNTL1                             (volatile uint32_t *)(0xff63c000 + (0xd2 << 2))
#define     HHI_CSI_PHY_CNTL0                                  (0xff63c000 + (0xd3 << 2))
#define SEC_HHI_CSI_PHY_CNTL0                                  (0xff63c000 + (0xd3 << 2))
#define   P_HHI_CSI_PHY_CNTL0                                  (volatile uint32_t *)(0xff63c000 + (0xd3 << 2))
#define     HHI_CSI_PHY_CNTL1                                  (0xff63c000 + (0xd4 << 2))
#define SEC_HHI_CSI_PHY_CNTL1                                  (0xff63c000 + (0xd4 << 2))
#define   P_HHI_CSI_PHY_CNTL1                                  (volatile uint32_t *)(0xff63c000 + (0xd4 << 2))
#define     HHI_CSI_PHY_CNTL2                                  (0xff63c000 + (0xd5 << 2))
#define SEC_HHI_CSI_PHY_CNTL2                                  (0xff63c000 + (0xd5 << 2))
#define   P_HHI_CSI_PHY_CNTL2                                  (volatile uint32_t *)(0xff63c000 + (0xd5 << 2))
#define     HHI_CSI_PHY_CNTL3                                  (0xff63c000 + (0xd6 << 2))
#define SEC_HHI_CSI_PHY_CNTL3                                  (0xff63c000 + (0xd6 << 2))
#define   P_HHI_CSI_PHY_CNTL3                                  (volatile uint32_t *)(0xff63c000 + (0xd6 << 2))
#define     HHI_CSI_PHY_CNTL4                                  (0xff63c000 + (0xd7 << 2))
#define SEC_HHI_CSI_PHY_CNTL4                                  (0xff63c000 + (0xd7 << 2))
#define   P_HHI_CSI_PHY_CNTL4                                  (volatile uint32_t *)(0xff63c000 + (0xd7 << 2))
#define     HHI_DIF_CSI_PHY_CNTL0                              (0xff63c000 + (0xd8 << 2))
#define SEC_HHI_DIF_CSI_PHY_CNTL0                              (0xff63c000 + (0xd8 << 2))
#define   P_HHI_DIF_CSI_PHY_CNTL0                              (volatile uint32_t *)(0xff63c000 + (0xd8 << 2))
#define     HHI_DIF_CSI_PHY_CNTL1                              (0xff63c000 + (0xd9 << 2))
#define SEC_HHI_DIF_CSI_PHY_CNTL1                              (0xff63c000 + (0xd9 << 2))
#define   P_HHI_DIF_CSI_PHY_CNTL1                              (volatile uint32_t *)(0xff63c000 + (0xd9 << 2))
#define     HHI_DIF_CSI_PHY_CNTL2                              (0xff63c000 + (0xda << 2))
#define SEC_HHI_DIF_CSI_PHY_CNTL2                              (0xff63c000 + (0xda << 2))
#define   P_HHI_DIF_CSI_PHY_CNTL2                              (volatile uint32_t *)(0xff63c000 + (0xda << 2))
#define     HHI_DIF_CSI_PHY_CNTL3                              (0xff63c000 + (0xdb << 2))
#define SEC_HHI_DIF_CSI_PHY_CNTL3                              (0xff63c000 + (0xdb << 2))
#define   P_HHI_DIF_CSI_PHY_CNTL3                              (volatile uint32_t *)(0xff63c000 + (0xdb << 2))
#define     HHI_DIF_CSI_PHY_CNTL4                              (0xff63c000 + (0xdc << 2))
#define SEC_HHI_DIF_CSI_PHY_CNTL4                              (0xff63c000 + (0xdc << 2))
#define   P_HHI_DIF_CSI_PHY_CNTL4                              (volatile uint32_t *)(0xff63c000 + (0xdc << 2))
#define     HHI_DIF_CSI_PHY_CNTL5                              (0xff63c000 + (0xdd << 2))
#define SEC_HHI_DIF_CSI_PHY_CNTL5                              (0xff63c000 + (0xdd << 2))
#define   P_HHI_DIF_CSI_PHY_CNTL5                              (volatile uint32_t *)(0xff63c000 + (0xdd << 2))
#define     HHI_LVDS_TX_PHY_CNTL0                              (0xff63c000 + (0xde << 2))
#define SEC_HHI_LVDS_TX_PHY_CNTL0                              (0xff63c000 + (0xde << 2))
#define   P_HHI_LVDS_TX_PHY_CNTL0                              (volatile uint32_t *)(0xff63c000 + (0xde << 2))
#define     HHI_LVDS_TX_PHY_CNTL1                              (0xff63c000 + (0xdf << 2))
#define SEC_HHI_LVDS_TX_PHY_CNTL1                              (0xff63c000 + (0xdf << 2))
#define   P_HHI_LVDS_TX_PHY_CNTL1                              (volatile uint32_t *)(0xff63c000 + (0xdf << 2))
#define     HHI_VID2_PLL_CNTL                                  (0xff63c000 + (0xe0 << 2))
#define SEC_HHI_VID2_PLL_CNTL                                  (0xff63c000 + (0xe0 << 2))
#define   P_HHI_VID2_PLL_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0xe0 << 2))
#define     HHI_VID2_PLL_CNTL2                                 (0xff63c000 + (0xe1 << 2))
#define SEC_HHI_VID2_PLL_CNTL2                                 (0xff63c000 + (0xe1 << 2))
#define   P_HHI_VID2_PLL_CNTL2                                 (volatile uint32_t *)(0xff63c000 + (0xe1 << 2))
#define     HHI_VID2_PLL_CNTL3                                 (0xff63c000 + (0xe2 << 2))
#define SEC_HHI_VID2_PLL_CNTL3                                 (0xff63c000 + (0xe2 << 2))
#define   P_HHI_VID2_PLL_CNTL3                                 (volatile uint32_t *)(0xff63c000 + (0xe2 << 2))
#define     HHI_VID2_PLL_CNTL4                                 (0xff63c000 + (0xe3 << 2))
#define SEC_HHI_VID2_PLL_CNTL4                                 (0xff63c000 + (0xe3 << 2))
#define   P_HHI_VID2_PLL_CNTL4                                 (volatile uint32_t *)(0xff63c000 + (0xe3 << 2))
#define     HHI_VID2_PLL_CNTL5                                 (0xff63c000 + (0xe4 << 2))
#define SEC_HHI_VID2_PLL_CNTL5                                 (0xff63c000 + (0xe4 << 2))
#define   P_HHI_VID2_PLL_CNTL5                                 (volatile uint32_t *)(0xff63c000 + (0xe4 << 2))
#define     HHI_VID2_PLL_CNTL_I                                (0xff63c000 + (0xe5 << 2))
#define SEC_HHI_VID2_PLL_CNTL_I                                (0xff63c000 + (0xe5 << 2))
#define   P_HHI_VID2_PLL_CNTL_I                                (volatile uint32_t *)(0xff63c000 + (0xe5 << 2))
#define     HHI_HDMI_PHY_CNTL0                                 (0xff63c000 + (0xe8 << 2))
#define SEC_HHI_HDMI_PHY_CNTL0                                 (0xff63c000 + (0xe8 << 2))
#define   P_HHI_HDMI_PHY_CNTL0                                 (volatile uint32_t *)(0xff63c000 + (0xe8 << 2))
#define     HHI_HDMI_PHY_CNTL1                                 (0xff63c000 + (0xe9 << 2))
#define SEC_HHI_HDMI_PHY_CNTL1                                 (0xff63c000 + (0xe9 << 2))
#define   P_HHI_HDMI_PHY_CNTL1                                 (volatile uint32_t *)(0xff63c000 + (0xe9 << 2))
#define     HHI_HDMI_PHY_CNTL2                                 (0xff63c000 + (0xea << 2))
#define SEC_HHI_HDMI_PHY_CNTL2                                 (0xff63c000 + (0xea << 2))
#define   P_HHI_HDMI_PHY_CNTL2                                 (volatile uint32_t *)(0xff63c000 + (0xea << 2))
#define     HHI_HDMI_PHY_CNTL3                                 (0xff63c000 + (0xeb << 2))
#define SEC_HHI_HDMI_PHY_CNTL3                                 (0xff63c000 + (0xeb << 2))
#define   P_HHI_HDMI_PHY_CNTL3                                 (volatile uint32_t *)(0xff63c000 + (0xeb << 2))
#define     HHI_HDMI_PHY_CNTL4                                 (0xff63c000 + (0xec << 2))
#define SEC_HHI_HDMI_PHY_CNTL4                                 (0xff63c000 + (0xec << 2))
#define   P_HHI_HDMI_PHY_CNTL4                                 (volatile uint32_t *)(0xff63c000 + (0xec << 2))
#define     HHI_HDMI_PHY_STATUS                                (0xff63c000 + (0xed << 2))
#define SEC_HHI_HDMI_PHY_STATUS                                (0xff63c000 + (0xed << 2))
#define   P_HHI_HDMI_PHY_STATUS                                (volatile uint32_t *)(0xff63c000 + (0xed << 2))
#define     HHI_TS_CLK_CNTL                                    (0xff63c000 + (0xef << 2))
#define SEC_HHI_TS_CLK_CNTL                                    (0xff63c000 + (0xef << 2))
#define   P_HHI_TS_CLK_CNTL                                    (volatile uint32_t *)(0xff63c000 + (0xef << 2))
#define     HHI_TCON_CLK_CNTL                                  (0xff63c000 + (0xf0 << 2))
#define SEC_HHI_TCON_CLK_CNTL                                  (0xff63c000 + (0xf0 << 2))
#define   P_HHI_TCON_CLK_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0xf0 << 2))
//`define HHI_ADEC_SYS_CLK_CNTL       8'hf1
#define     HHI_VID_LOCK_CLK_CNTL                              (0xff63c000 + (0xf2 << 2))
#define SEC_HHI_VID_LOCK_CLK_CNTL                              (0xff63c000 + (0xf2 << 2))
#define   P_HHI_VID_LOCK_CLK_CNTL                              (volatile uint32_t *)(0xff63c000 + (0xf2 << 2))
#define     HHI_ATV_DMD_SYS_CLK_CNTL                           (0xff63c000 + (0xf3 << 2))
#define SEC_HHI_ATV_DMD_SYS_CLK_CNTL                           (0xff63c000 + (0xf3 << 2))
#define   P_HHI_ATV_DMD_SYS_CLK_CNTL                           (volatile uint32_t *)(0xff63c000 + (0xf3 << 2))
#define     HHI_EE_MISC_CNTL                                   (0xff63c000 + (0xf4 << 2))
#define SEC_HHI_EE_MISC_CNTL                                   (0xff63c000 + (0xf4 << 2))
#define   P_HHI_EE_MISC_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0xf4 << 2))
#define     HHI_BT656_CLK_CNTL                                 (0xff63c000 + (0xf5 << 2))
#define SEC_HHI_BT656_CLK_CNTL                                 (0xff63c000 + (0xf5 << 2))
#define   P_HHI_BT656_CLK_CNTL                                 (volatile uint32_t *)(0xff63c000 + (0xf5 << 2))
//`define HHI_SAR_CLK_CNTL            8'hf6
#define     HHI_SPICC_CLK_CNTL                                 (0xff63c000 + (0xf7 << 2))
#define SEC_HHI_SPICC_CLK_CNTL                                 (0xff63c000 + (0xf7 << 2))
#define   P_HHI_SPICC_CLK_CNTL                                 (volatile uint32_t *)(0xff63c000 + (0xf7 << 2))
#define     HHI_HDMIRX_AUD_PLL_CNTL                            (0xff63c000 + (0xf8 << 2))
#define SEC_HHI_HDMIRX_AUD_PLL_CNTL                            (0xff63c000 + (0xf8 << 2))
#define   P_HHI_HDMIRX_AUD_PLL_CNTL                            (volatile uint32_t *)(0xff63c000 + (0xf8 << 2))
#define     HHI_HDMIRX_AUD_PLL_CNTL2                           (0xff63c000 + (0xf9 << 2))
#define SEC_HHI_HDMIRX_AUD_PLL_CNTL2                           (0xff63c000 + (0xf9 << 2))
#define   P_HHI_HDMIRX_AUD_PLL_CNTL2                           (volatile uint32_t *)(0xff63c000 + (0xf9 << 2))
#define     HHI_HDMIRX_AUD_PLL_CNTL3                           (0xff63c000 + (0xfa << 2))
#define SEC_HHI_HDMIRX_AUD_PLL_CNTL3                           (0xff63c000 + (0xfa << 2))
#define   P_HHI_HDMIRX_AUD_PLL_CNTL3                           (volatile uint32_t *)(0xff63c000 + (0xfa << 2))
#define     HHI_HDMIRX_AUD_PLL_CNTL4                           (0xff63c000 + (0xfb << 2))
#define SEC_HHI_HDMIRX_AUD_PLL_CNTL4                           (0xff63c000 + (0xfb << 2))
#define   P_HHI_HDMIRX_AUD_PLL_CNTL4                           (volatile uint32_t *)(0xff63c000 + (0xfb << 2))
#define     HHI_HDMIRX_AUD_PLL_CNTL5                           (0xff63c000 + (0xfc << 2))
#define SEC_HHI_HDMIRX_AUD_PLL_CNTL5                           (0xff63c000 + (0xfc << 2))
#define   P_HHI_HDMIRX_AUD_PLL_CNTL5                           (volatile uint32_t *)(0xff63c000 + (0xfc << 2))
#define     HHI_HDMIRX_AUD_PLL_CNTL6                           (0xff63c000 + (0xfd << 2))
#define SEC_HHI_HDMIRX_AUD_PLL_CNTL6                           (0xff63c000 + (0xfd << 2))
#define   P_HHI_HDMIRX_AUD_PLL_CNTL6                           (volatile uint32_t *)(0xff63c000 + (0xfd << 2))
#define     HHI_HDMIRX_AUD_PLL_CNTL_I                          (0xff63c000 + (0xfe << 2))
#define SEC_HHI_HDMIRX_AUD_PLL_CNTL_I                          (0xff63c000 + (0xfe << 2))
#define   P_HHI_HDMIRX_AUD_PLL_CNTL_I                          (volatile uint32_t *)(0xff63c000 + (0xfe << 2))
//========================================================================
//  HIU - Mailbox
//========================================================================
// APB4_DECODER_NON_SECURE_BASE     32'hFF63C400
// APB4_DECODER_SECURE_BASE         32'hFF63C400
#define     HIU_MAILBOX_SET_0                                  (0xff63c400 + (0x01 << 2))
#define SEC_HIU_MAILBOX_SET_0                                  (0xff63c400 + (0x01 << 2))
#define   P_HIU_MAILBOX_SET_0                                  (volatile uint32_t *)(0xff63c400 + (0x01 << 2))
#define     HIU_MAILBOX_STAT_0                                 (0xff63c400 + (0x02 << 2))
#define SEC_HIU_MAILBOX_STAT_0                                 (0xff63c400 + (0x02 << 2))
#define   P_HIU_MAILBOX_STAT_0                                 (volatile uint32_t *)(0xff63c400 + (0x02 << 2))
#define     HIU_MAILBOX_CLR_0                                  (0xff63c400 + (0x03 << 2))
#define SEC_HIU_MAILBOX_CLR_0                                  (0xff63c400 + (0x03 << 2))
#define   P_HIU_MAILBOX_CLR_0                                  (volatile uint32_t *)(0xff63c400 + (0x03 << 2))
#define     HIU_MAILBOX_SET_1                                  (0xff63c400 + (0x04 << 2))
#define SEC_HIU_MAILBOX_SET_1                                  (0xff63c400 + (0x04 << 2))
#define   P_HIU_MAILBOX_SET_1                                  (volatile uint32_t *)(0xff63c400 + (0x04 << 2))
#define     HIU_MAILBOX_STAT_1                                 (0xff63c400 + (0x05 << 2))
#define SEC_HIU_MAILBOX_STAT_1                                 (0xff63c400 + (0x05 << 2))
#define   P_HIU_MAILBOX_STAT_1                                 (volatile uint32_t *)(0xff63c400 + (0x05 << 2))
#define     HIU_MAILBOX_CLR_1                                  (0xff63c400 + (0x06 << 2))
#define SEC_HIU_MAILBOX_CLR_1                                  (0xff63c400 + (0x06 << 2))
#define   P_HIU_MAILBOX_CLR_1                                  (volatile uint32_t *)(0xff63c400 + (0x06 << 2))
#define     HIU_MAILBOX_SET_2                                  (0xff63c400 + (0x07 << 2))
#define SEC_HIU_MAILBOX_SET_2                                  (0xff63c400 + (0x07 << 2))
#define   P_HIU_MAILBOX_SET_2                                  (volatile uint32_t *)(0xff63c400 + (0x07 << 2))
#define     HIU_MAILBOX_STAT_2                                 (0xff63c400 + (0x08 << 2))
#define SEC_HIU_MAILBOX_STAT_2                                 (0xff63c400 + (0x08 << 2))
#define   P_HIU_MAILBOX_STAT_2                                 (volatile uint32_t *)(0xff63c400 + (0x08 << 2))
#define     HIU_MAILBOX_CLR_2                                  (0xff63c400 + (0x09 << 2))
#define SEC_HIU_MAILBOX_CLR_2                                  (0xff63c400 + (0x09 << 2))
#define   P_HIU_MAILBOX_CLR_2                                  (volatile uint32_t *)(0xff63c400 + (0x09 << 2))
#define     HIU_MAILBOX_SET_3                                  (0xff63c400 + (0x0a << 2))
#define SEC_HIU_MAILBOX_SET_3                                  (0xff63c400 + (0x0a << 2))
#define   P_HIU_MAILBOX_SET_3                                  (volatile uint32_t *)(0xff63c400 + (0x0a << 2))
#define     HIU_MAILBOX_STAT_3                                 (0xff63c400 + (0x0b << 2))
#define SEC_HIU_MAILBOX_STAT_3                                 (0xff63c400 + (0x0b << 2))
#define   P_HIU_MAILBOX_STAT_3                                 (volatile uint32_t *)(0xff63c400 + (0x0b << 2))
#define     HIU_MAILBOX_CLR_3                                  (0xff63c400 + (0x0c << 2))
#define SEC_HIU_MAILBOX_CLR_3                                  (0xff63c400 + (0x0c << 2))
#define   P_HIU_MAILBOX_CLR_3                                  (volatile uint32_t *)(0xff63c400 + (0x0c << 2))
#define     HIU_MAILBOX_SET_4                                  (0xff63c400 + (0x0d << 2))
#define SEC_HIU_MAILBOX_SET_4                                  (0xff63c400 + (0x0d << 2))
#define   P_HIU_MAILBOX_SET_4                                  (volatile uint32_t *)(0xff63c400 + (0x0d << 2))
#define     HIU_MAILBOX_STAT_4                                 (0xff63c400 + (0x0e << 2))
#define SEC_HIU_MAILBOX_STAT_4                                 (0xff63c400 + (0x0e << 2))
#define   P_HIU_MAILBOX_STAT_4                                 (volatile uint32_t *)(0xff63c400 + (0x0e << 2))
#define     HIU_MAILBOX_CLR_4                                  (0xff63c400 + (0x0f << 2))
#define SEC_HIU_MAILBOX_CLR_4                                  (0xff63c400 + (0x0f << 2))
#define   P_HIU_MAILBOX_CLR_4                                  (volatile uint32_t *)(0xff63c400 + (0x0f << 2))
#define     HIU_MAILBOX_SET_5                                  (0xff63c400 + (0x10 << 2))
#define SEC_HIU_MAILBOX_SET_5                                  (0xff63c400 + (0x10 << 2))
#define   P_HIU_MAILBOX_SET_5                                  (volatile uint32_t *)(0xff63c400 + (0x10 << 2))
#define     HIU_MAILBOX_STAT_5                                 (0xff63c400 + (0x11 << 2))
#define SEC_HIU_MAILBOX_STAT_5                                 (0xff63c400 + (0x11 << 2))
#define   P_HIU_MAILBOX_STAT_5                                 (volatile uint32_t *)(0xff63c400 + (0x11 << 2))
#define     HIU_MAILBOX_CLR_5                                  (0xff63c400 + (0x12 << 2))
#define SEC_HIU_MAILBOX_CLR_5                                  (0xff63c400 + (0x12 << 2))
#define   P_HIU_MAILBOX_CLR_5                                  (volatile uint32_t *)(0xff63c400 + (0x12 << 2))
//========================================================================
//  EFUSE
//========================================================================
//  APB4_DECODER_NON_SECURE_BASE     32'hFF630000
//  APB4_DECODER_SECURE_BASE         32'hFF630000
#define     EFUSE_CLR                                          (0xff630000 + (0x00 << 2))
#define SEC_EFUSE_CLR                                          (0xff630000 + (0x00 << 2))
#define   P_EFUSE_CLR                                          (volatile uint32_t *)(0xff630000 + (0x00 << 2))
#define     EFUSE_START                                        (0xff630000 + (0x01 << 2))
#define SEC_EFUSE_START                                        (0xff630000 + (0x01 << 2))
#define   P_EFUSE_START                                        (volatile uint32_t *)(0xff630000 + (0x01 << 2))
#define     EFUSE_WDATA0                                       (0xff630000 + (0x04 << 2))
#define SEC_EFUSE_WDATA0                                       (0xff630000 + (0x04 << 2))
#define   P_EFUSE_WDATA0                                       (volatile uint32_t *)(0xff630000 + (0x04 << 2))
#define     EFUSE_WDATA1                                       (0xff630000 + (0x05 << 2))
#define SEC_EFUSE_WDATA1                                       (0xff630000 + (0x05 << 2))
#define   P_EFUSE_WDATA1                                       (volatile uint32_t *)(0xff630000 + (0x05 << 2))
#define     EFUSE_WDATA2                                       (0xff630000 + (0x06 << 2))
#define SEC_EFUSE_WDATA2                                       (0xff630000 + (0x06 << 2))
#define   P_EFUSE_WDATA2                                       (volatile uint32_t *)(0xff630000 + (0x06 << 2))
#define     EFUSE_WDATA3                                       (0xff630000 + (0x07 << 2))
#define SEC_EFUSE_WDATA3                                       (0xff630000 + (0x07 << 2))
#define   P_EFUSE_WDATA3                                       (volatile uint32_t *)(0xff630000 + (0x07 << 2))
#define     EFUSE_RDATA0                                       (0xff630000 + (0x08 << 2))
#define SEC_EFUSE_RDATA0                                       (0xff630000 + (0x08 << 2))
#define   P_EFUSE_RDATA0                                       (volatile uint32_t *)(0xff630000 + (0x08 << 2))
#define     EFUSE_RDATA1                                       (0xff630000 + (0x09 << 2))
#define SEC_EFUSE_RDATA1                                       (0xff630000 + (0x09 << 2))
#define   P_EFUSE_RDATA1                                       (volatile uint32_t *)(0xff630000 + (0x09 << 2))
#define     EFUSE_RDATA2                                       (0xff630000 + (0x0a << 2))
#define SEC_EFUSE_RDATA2                                       (0xff630000 + (0x0a << 2))
#define   P_EFUSE_RDATA2                                       (volatile uint32_t *)(0xff630000 + (0x0a << 2))
#define     EFUSE_RDATA3                                       (0xff630000 + (0x0b << 2))
#define SEC_EFUSE_RDATA3                                       (0xff630000 + (0x0b << 2))
#define   P_EFUSE_RDATA3                                       (volatile uint32_t *)(0xff630000 + (0x0b << 2))
#define     KL_START0                                          (0xff630000 + (0x20 << 2))
#define SEC_KL_START0                                          (0xff630000 + (0x20 << 2))
#define   P_KL_START0                                          (volatile uint32_t *)(0xff630000 + (0x20 << 2))
#define     KL_START1                                          (0xff630000 + (0x21 << 2))
#define SEC_KL_START1                                          (0xff630000 + (0x21 << 2))
#define   P_KL_START1                                          (volatile uint32_t *)(0xff630000 + (0x21 << 2))
#define     KL_RESP0_0                                         (0xff630000 + (0x24 << 2))
#define SEC_KL_RESP0_0                                         (0xff630000 + (0x24 << 2))
#define   P_KL_RESP0_0                                         (volatile uint32_t *)(0xff630000 + (0x24 << 2))
#define     KL_RESP0_1                                         (0xff630000 + (0x25 << 2))
#define SEC_KL_RESP0_1                                         (0xff630000 + (0x25 << 2))
#define   P_KL_RESP0_1                                         (volatile uint32_t *)(0xff630000 + (0x25 << 2))
#define     KL_RESP0_2                                         (0xff630000 + (0x26 << 2))
#define SEC_KL_RESP0_2                                         (0xff630000 + (0x26 << 2))
#define   P_KL_RESP0_2                                         (volatile uint32_t *)(0xff630000 + (0x26 << 2))
#define     KL_RESP0_3                                         (0xff630000 + (0x27 << 2))
#define SEC_KL_RESP0_3                                         (0xff630000 + (0x27 << 2))
#define   P_KL_RESP0_3                                         (volatile uint32_t *)(0xff630000 + (0x27 << 2))
#define     KL_RESP1_0                                         (0xff630000 + (0x28 << 2))
#define SEC_KL_RESP1_0                                         (0xff630000 + (0x28 << 2))
#define   P_KL_RESP1_0                                         (volatile uint32_t *)(0xff630000 + (0x28 << 2))
#define     KL_RESP1_1                                         (0xff630000 + (0x29 << 2))
#define SEC_KL_RESP1_1                                         (0xff630000 + (0x29 << 2))
#define   P_KL_RESP1_1                                         (volatile uint32_t *)(0xff630000 + (0x29 << 2))
#define     KL_RESP1_2                                         (0xff630000 + (0x2a << 2))
#define SEC_KL_RESP1_2                                         (0xff630000 + (0x2a << 2))
#define   P_KL_RESP1_2                                         (volatile uint32_t *)(0xff630000 + (0x2a << 2))
#define     KL_RESP1_3                                         (0xff630000 + (0x2b << 2))
#define SEC_KL_RESP1_3                                         (0xff630000 + (0x2b << 2))
#define   P_KL_RESP1_3                                         (volatile uint32_t *)(0xff630000 + (0x2b << 2))
#define     KL_RAM                                             (0xff630000 + (0x40 << 2))
#define SEC_KL_RAM                                             (0xff630000 + (0x40 << 2))
#define   P_KL_RAM                                             (volatile uint32_t *)(0xff630000 + (0x40 << 2))
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  ./secure_apb4_ee.h
//
//
// Reading file:  ./ao_rti_reg.h
//
//#define AO_RTI_REG_BASE 0x00
// APB4_DECODER_NON_SECURE_BASE     32'hFF800000
// APB4_DECODER_SECURE_BASE         32'hFF800000
// Registers not affected by the Watchdog timer
#define     AO_RTI_STATUS_REG0                                 (0xff800000 + (0x00 << 2))
#define SEC_AO_RTI_STATUS_REG0                                 (0xff800000 + (0x00 << 2))
#define   P_AO_RTI_STATUS_REG0                                 (volatile uint32_t *)(0xff800000 + (0x00 << 2))
#define     AO_RTI_STATUS_REG1                                 (0xff800000 + (0x01 << 2))
#define SEC_AO_RTI_STATUS_REG1                                 (0xff800000 + (0x01 << 2))
#define   P_AO_RTI_STATUS_REG1                                 (volatile uint32_t *)(0xff800000 + (0x01 << 2))
#define     AO_RTI_STATUS_REG2                                 (0xff800000 + (0x02 << 2))
#define SEC_AO_RTI_STATUS_REG2                                 (0xff800000 + (0x02 << 2))
#define   P_AO_RTI_STATUS_REG2                                 (volatile uint32_t *)(0xff800000 + (0x02 << 2))
#define     AO_RTI_PWR_CNTL_REG1                               (0xff800000 + (0x03 << 2))
#define SEC_AO_RTI_PWR_CNTL_REG1                               (0xff800000 + (0x03 << 2))
#define   P_AO_RTI_PWR_CNTL_REG1                               (volatile uint32_t *)(0xff800000 + (0x03 << 2))
#define     AO_RTI_PWR_CNTL_REG0                               (0xff800000 + (0x04 << 2))
#define SEC_AO_RTI_PWR_CNTL_REG0                               (0xff800000 + (0x04 << 2))
#define   P_AO_RTI_PWR_CNTL_REG0                               (volatile uint32_t *)(0xff800000 + (0x04 << 2))
#define     AO_RTI_PIN_MUX_REG                                 (0xff800000 + (0x05 << 2))
#define SEC_AO_RTI_PIN_MUX_REG                                 (0xff800000 + (0x05 << 2))
#define   P_AO_RTI_PIN_MUX_REG                                 (volatile uint32_t *)(0xff800000 + (0x05 << 2))
#define     AO_RTI_PIN_MUX_REG2                                (0xff800000 + (0x06 << 2))
#define SEC_AO_RTI_PIN_MUX_REG2                                (0xff800000 + (0x06 << 2))
#define   P_AO_RTI_PIN_MUX_REG2                                (volatile uint32_t *)(0xff800000 + (0x06 << 2))
#define     AO_RTI_STATUS_REG3                                 (0xff800000 + (0x07 << 2))
#define SEC_AO_RTI_STATUS_REG3                                 (0xff800000 + (0x07 << 2))
#define   P_AO_RTI_STATUS_REG3                                 (volatile uint32_t *)(0xff800000 + (0x07 << 2))
//`define AO_REMAP_REG0               8'h07 //TODO: DELETE. NOT USED
#define     AO_REMAP_REG1                                      (0xff800000 + (0x08 << 2))
#define SEC_AO_REMAP_REG1                                      (0xff800000 + (0x08 << 2))
#define   P_AO_REMAP_REG1                                      (volatile uint32_t *)(0xff800000 + (0x08 << 2))
#define     AO_GPIO_O_EN_N                                     (0xff800000 + (0x09 << 2))
#define SEC_AO_GPIO_O_EN_N                                     (0xff800000 + (0x09 << 2))
#define   P_AO_GPIO_O_EN_N                                     (volatile uint32_t *)(0xff800000 + (0x09 << 2))
#define     AO_GPIO_I                                          (0xff800000 + (0x0a << 2))
#define SEC_AO_GPIO_I                                          (0xff800000 + (0x0a << 2))
#define   P_AO_GPIO_I                                          (volatile uint32_t *)(0xff800000 + (0x0a << 2))
#define     AO_RTI_PULL_UP_REG                                 (0xff800000 + (0x0b << 2))
#define SEC_AO_RTI_PULL_UP_REG                                 (0xff800000 + (0x0b << 2))
#define   P_AO_RTI_PULL_UP_REG                                 (volatile uint32_t *)(0xff800000 + (0x0b << 2))
#define     AO_RTI_JTAG_CONFIG_REG                             (0xff800000 + (0x0c << 2))
#define SEC_AO_RTI_JTAG_CONFIG_REG                             (0xff800000 + (0x0c << 2))
#define   P_AO_RTI_JTAG_CONFIG_REG                             (volatile uint32_t *)(0xff800000 + (0x0c << 2))
#define     AO_RTI_WD_MARK                                     (0xff800000 + (0x0d << 2))
#define SEC_AO_RTI_WD_MARK                                     (0xff800000 + (0x0d << 2))
#define   P_AO_RTI_WD_MARK                                     (volatile uint32_t *)(0xff800000 + (0x0d << 2))
// sando add for AO CPU
#define     AO_CPU_CNTL                                        (0xff800000 + (0x0e << 2))
#define SEC_AO_CPU_CNTL                                        (0xff800000 + (0x0e << 2))
#define   P_AO_CPU_CNTL                                        (volatile uint32_t *)(0xff800000 + (0x0e << 2))
#define     AO_CPU_CNTL2                                       (0xff800000 + (0x0f << 2))
#define SEC_AO_CPU_CNTL2                                       (0xff800000 + (0x0f << 2))
#define   P_AO_CPU_CNTL2                                       (volatile uint32_t *)(0xff800000 + (0x0f << 2))
#define     AO_RTI_GEN_CNTL_REG0                               (0xff800000 + (0x10 << 2))
#define SEC_AO_RTI_GEN_CNTL_REG0                               (0xff800000 + (0x10 << 2))
#define   P_AO_RTI_GEN_CNTL_REG0                               (volatile uint32_t *)(0xff800000 + (0x10 << 2))
#define     AO_CPU_CNTL_NS                                     (0xff800000 + (0x11 << 2))
#define SEC_AO_CPU_CNTL_NS                                     (0xff800000 + (0x11 << 2))
#define   P_AO_CPU_CNTL_NS                                     (volatile uint32_t *)(0xff800000 + (0x11 << 2))
#define     AO_METAL_REVISION_1                                (0xff800000 + (0x12 << 2))
#define SEC_AO_METAL_REVISION_1                                (0xff800000 + (0x12 << 2))
#define   P_AO_METAL_REVISION_1                                (volatile uint32_t *)(0xff800000 + (0x12 << 2))
#define     AO_TIMER_REG                                       (0xff800000 + (0x13 << 2))
#define SEC_AO_TIMER_REG                                       (0xff800000 + (0x13 << 2))
#define   P_AO_TIMER_REG                                       (volatile uint32_t *)(0xff800000 + (0x13 << 2))
#define     AO_TIMERA_REG                                      (0xff800000 + (0x14 << 2))
#define SEC_AO_TIMERA_REG                                      (0xff800000 + (0x14 << 2))
#define   P_AO_TIMERA_REG                                      (volatile uint32_t *)(0xff800000 + (0x14 << 2))
#define     AO_TIMERE_REG                                      (0xff800000 + (0x15 << 2))
#define SEC_AO_TIMERE_REG                                      (0xff800000 + (0x15 << 2))
#define   P_AO_TIMERE_REG                                      (volatile uint32_t *)(0xff800000 + (0x15 << 2))
#define     AO_OSCIN_CNTL                                      (0xff800000 + (0x16 << 2))
#define SEC_AO_OSCIN_CNTL                                      (0xff800000 + (0x16 << 2))
#define   P_AO_OSCIN_CNTL                                      (volatile uint32_t *)(0xff800000 + (0x16 << 2))
#define     AO_AHB2DDR_CNTL                                    (0xff800000 + (0x18 << 2))
#define SEC_AO_AHB2DDR_CNTL                                    (0xff800000 + (0x18 << 2))
#define   P_AO_AHB2DDR_CNTL                                    (volatile uint32_t *)(0xff800000 + (0x18 << 2))
#define     AO_TIMEBASE_CNTL                                   (0xff800000 + (0x19 << 2))
#define SEC_AO_TIMEBASE_CNTL                                   (0xff800000 + (0x19 << 2))
#define   P_AO_TIMEBASE_CNTL                                   (volatile uint32_t *)(0xff800000 + (0x19 << 2))
//`define AO_CRT_CLK_CNTL1            8'h1a
#define     AO_GEN_CLK_CNTL                                    (0xff800000 + (0x1a << 2))
#define SEC_AO_GEN_CLK_CNTL                                    (0xff800000 + (0x1a << 2))
#define   P_AO_GEN_CLK_CNTL                                    (volatile uint32_t *)(0xff800000 + (0x1a << 2))
#define     AO_RTI_INTER_OSC_CTL0                              (0xff800000 + (0x1b << 2))
#define SEC_AO_RTI_INTER_OSC_CTL0                              (0xff800000 + (0x1b << 2))
#define   P_AO_RTI_INTER_OSC_CTL0                              (volatile uint32_t *)(0xff800000 + (0x1b << 2))
#define     AO_RTI_INTER_OSC_CTL1                              (0xff800000 + (0x1c << 2))
#define SEC_AO_RTI_INTER_OSC_CTL1                              (0xff800000 + (0x1c << 2))
#define   P_AO_RTI_INTER_OSC_CTL1                              (volatile uint32_t *)(0xff800000 + (0x1c << 2))
#define     AO_CEC_CLK_CNTL_REG0                               (0xff800000 + (0x1d << 2))
#define SEC_AO_CEC_CLK_CNTL_REG0                               (0xff800000 + (0x1d << 2))
#define   P_AO_CEC_CLK_CNTL_REG0                               (volatile uint32_t *)(0xff800000 + (0x1d << 2))
#define     AO_CEC_CLK_CNTL_REG1                               (0xff800000 + (0x1e << 2))
#define SEC_AO_CEC_CLK_CNTL_REG1                               (0xff800000 + (0x1e << 2))
#define   P_AO_CEC_CLK_CNTL_REG1                               (volatile uint32_t *)(0xff800000 + (0x1e << 2))
#define     AO_METAL_REVISION                                  (0xff800000 + (0x1f << 2))
#define SEC_AO_METAL_REVISION                                  (0xff800000 + (0x1f << 2))
#define   P_AO_METAL_REVISION                                  (volatile uint32_t *)(0xff800000 + (0x1f << 2))
#define     AO_IRQ_MASK_FIQ_SEL                                (0xff800000 + (0x20 << 2))
#define SEC_AO_IRQ_MASK_FIQ_SEL                                (0xff800000 + (0x20 << 2))
#define   P_AO_IRQ_MASK_FIQ_SEL                                (volatile uint32_t *)(0xff800000 + (0x20 << 2))
#define     AO_IRQ_GPIO_REG                                    (0xff800000 + (0x21 << 2))
#define SEC_AO_IRQ_GPIO_REG                                    (0xff800000 + (0x21 << 2))
#define   P_AO_IRQ_GPIO_REG                                    (volatile uint32_t *)(0xff800000 + (0x21 << 2))
#define     AO_IRQ_STAT                                        (0xff800000 + (0x22 << 2))
#define SEC_AO_IRQ_STAT                                        (0xff800000 + (0x22 << 2))
#define   P_AO_IRQ_STAT                                        (volatile uint32_t *)(0xff800000 + (0x22 << 2))
#define     AO_IRQ_STAT_CLR                                    (0xff800000 + (0x23 << 2))
#define SEC_AO_IRQ_STAT_CLR                                    (0xff800000 + (0x23 << 2))
#define   P_AO_IRQ_STAT_CLR                                    (volatile uint32_t *)(0xff800000 + (0x23 << 2))
#define     AO_SAR_CLK                                         (0xff800000 + (0x24 << 2))
#define SEC_AO_SAR_CLK                                         (0xff800000 + (0x24 << 2))
#define   P_AO_SAR_CLK                                         (volatile uint32_t *)(0xff800000 + (0x24 << 2))
#define     AO_RTC_ALT_CLK_CNTL0                               (0xff800000 + (0x25 << 2))
#define SEC_AO_RTC_ALT_CLK_CNTL0                               (0xff800000 + (0x25 << 2))
#define   P_AO_RTC_ALT_CLK_CNTL0                               (volatile uint32_t *)(0xff800000 + (0x25 << 2))
#define     AO_RTC_ALT_CLK_CNTL1                               (0xff800000 + (0x26 << 2))
#define SEC_AO_RTC_ALT_CLK_CNTL1                               (0xff800000 + (0x26 << 2))
#define   P_AO_RTC_ALT_CLK_CNTL1                               (volatile uint32_t *)(0xff800000 + (0x26 << 2))
#define     AO_TIMESTAMP_CNTL2                                 (0xff800000 + (0x27 << 2))
#define SEC_AO_TIMESTAMP_CNTL2                                 (0xff800000 + (0x27 << 2))
#define   P_AO_TIMESTAMP_CNTL2                                 (volatile uint32_t *)(0xff800000 + (0x27 << 2))
#define     AO_DEBUG_REG0                                      (0xff800000 + (0x28 << 2))
#define SEC_AO_DEBUG_REG0                                      (0xff800000 + (0x28 << 2))
#define   P_AO_DEBUG_REG0                                      (volatile uint32_t *)(0xff800000 + (0x28 << 2))
#define     AO_DEBUG_REG1                                      (0xff800000 + (0x29 << 2))
#define SEC_AO_DEBUG_REG1                                      (0xff800000 + (0x29 << 2))
#define   P_AO_DEBUG_REG1                                      (volatile uint32_t *)(0xff800000 + (0x29 << 2))
#define     AO_DEBUG_REG2                                      (0xff800000 + (0x2a << 2))
#define SEC_AO_DEBUG_REG2                                      (0xff800000 + (0x2a << 2))
#define   P_AO_DEBUG_REG2                                      (volatile uint32_t *)(0xff800000 + (0x2a << 2))
#define     AO_DEBUG_REG3                                      (0xff800000 + (0x2b << 2))
#define SEC_AO_DEBUG_REG3                                      (0xff800000 + (0x2b << 2))
#define   P_AO_DEBUG_REG3                                      (volatile uint32_t *)(0xff800000 + (0x2b << 2))
#define     AO_TIMESTAMP_CNTL1                                 (0xff800000 + (0x2c << 2))
#define SEC_AO_TIMESTAMP_CNTL1                                 (0xff800000 + (0x2c << 2))
#define   P_AO_TIMESTAMP_CNTL1                                 (volatile uint32_t *)(0xff800000 + (0x2c << 2))
#define     AO_TIMESTAMP_CNTL                                  (0xff800000 + (0x2d << 2))
#define SEC_AO_TIMESTAMP_CNTL                                  (0xff800000 + (0x2d << 2))
#define   P_AO_TIMESTAMP_CNTL                                  (volatile uint32_t *)(0xff800000 + (0x2d << 2))
#define     AO_TIMESTAMP_RD0                                   (0xff800000 + (0x2e << 2))
#define SEC_AO_TIMESTAMP_RD0                                   (0xff800000 + (0x2e << 2))
#define   P_AO_TIMESTAMP_RD0                                   (volatile uint32_t *)(0xff800000 + (0x2e << 2))
#define     AO_TIMESTAMP_RD1                                   (0xff800000 + (0x2f << 2))
#define SEC_AO_TIMESTAMP_RD1                                   (0xff800000 + (0x2f << 2))
#define   P_AO_TIMESTAMP_RD1                                   (volatile uint32_t *)(0xff800000 + (0x2f << 2))
#define     AO_IR_BLASTER_ADDR0                                (0xff800000 + (0x30 << 2))
#define SEC_AO_IR_BLASTER_ADDR0                                (0xff800000 + (0x30 << 2))
#define   P_AO_IR_BLASTER_ADDR0                                (volatile uint32_t *)(0xff800000 + (0x30 << 2))
#define     AO_IR_BLASTER_ADDR1                                (0xff800000 + (0x31 << 2))
#define SEC_AO_IR_BLASTER_ADDR1                                (0xff800000 + (0x31 << 2))
#define   P_AO_IR_BLASTER_ADDR1                                (volatile uint32_t *)(0xff800000 + (0x31 << 2))
#define     AO_IR_BLASTER_ADDR2                                (0xff800000 + (0x32 << 2))
#define SEC_AO_IR_BLASTER_ADDR2                                (0xff800000 + (0x32 << 2))
#define   P_AO_IR_BLASTER_ADDR2                                (volatile uint32_t *)(0xff800000 + (0x32 << 2))
#define     AO_CPU_STAT1                                       (0xff800000 + (0x33 << 2))
#define SEC_AO_CPU_STAT1                                       (0xff800000 + (0x33 << 2))
#define   P_AO_CPU_STAT1                                       (volatile uint32_t *)(0xff800000 + (0x33 << 2))
#define     AO_CPU_STAT2                                       (0xff800000 + (0x34 << 2))
#define SEC_AO_CPU_STAT2                                       (0xff800000 + (0x34 << 2))
#define   P_AO_CPU_STAT2                                       (volatile uint32_t *)(0xff800000 + (0x34 << 2))
#define     AO_CPU_TIMESTAMP                                   (0xff800000 + (0x35 << 2))
#define SEC_AO_CPU_TIMESTAMP                                   (0xff800000 + (0x35 << 2))
#define   P_AO_CPU_TIMESTAMP                                   (volatile uint32_t *)(0xff800000 + (0x35 << 2))
#define     AO_CPU_TIMESTAMP2                                  (0xff800000 + (0x36 << 2))
#define SEC_AO_CPU_TIMESTAMP2                                  (0xff800000 + (0x36 << 2))
#define   P_AO_CPU_TIMESTAMP2                                  (volatile uint32_t *)(0xff800000 + (0x36 << 2))
#define     AO_CPU_CNTL3                                       (0xff800000 + (0x37 << 2))
#define SEC_AO_CPU_CNTL3                                       (0xff800000 + (0x37 << 2))
#define   P_AO_CPU_CNTL3                                       (volatile uint32_t *)(0xff800000 + (0x37 << 2))
// general Power control
#define     AO_RTI_PWR_SYS_CPU_CNTL0                           (0xff800000 + (0x38 << 2))
#define SEC_AO_RTI_PWR_SYS_CPU_CNTL0                           (0xff800000 + (0x38 << 2))
#define   P_AO_RTI_PWR_SYS_CPU_CNTL0                           (volatile uint32_t *)(0xff800000 + (0x38 << 2))
#define     AO_RTI_PWR_SYS_CPU_CNTL1                           (0xff800000 + (0x39 << 2))
#define SEC_AO_RTI_PWR_SYS_CPU_CNTL1                           (0xff800000 + (0x39 << 2))
#define   P_AO_RTI_PWR_SYS_CPU_CNTL1                           (volatile uint32_t *)(0xff800000 + (0x39 << 2))
#define     AO_RTI_GEN_PWR_SLEEP0                              (0xff800000 + (0x3a << 2))
#define SEC_AO_RTI_GEN_PWR_SLEEP0                              (0xff800000 + (0x3a << 2))
#define   P_AO_RTI_GEN_PWR_SLEEP0                              (volatile uint32_t *)(0xff800000 + (0x3a << 2))
#define     AO_RTI_GEN_PWR_ISO0                                (0xff800000 + (0x3b << 2))
#define SEC_AO_RTI_GEN_PWR_ISO0                                (0xff800000 + (0x3b << 2))
#define   P_AO_RTI_GEN_PWR_ISO0                                (volatile uint32_t *)(0xff800000 + (0x3b << 2))
#define     AO_RTI_GEN_PWR_ACK0                                (0xff800000 + (0x3c << 2))
#define SEC_AO_RTI_GEN_PWR_ACK0                                (0xff800000 + (0x3c << 2))
#define   P_AO_RTI_GEN_PWR_ACK0                                (volatile uint32_t *)(0xff800000 + (0x3c << 2))
#define     AO_RTI_PWR_SYS_CPU_MEM_PD0                         (0xff800000 + (0x3d << 2))
#define SEC_AO_RTI_PWR_SYS_CPU_MEM_PD0                         (0xff800000 + (0x3d << 2))
#define   P_AO_RTI_PWR_SYS_CPU_MEM_PD0                         (volatile uint32_t *)(0xff800000 + (0x3d << 2))
#define     AO_RTI_PWR_SYS_CPU_MEM_PD1                         (0xff800000 + (0x3e << 2))
#define SEC_AO_RTI_PWR_SYS_CPU_MEM_PD1                         (0xff800000 + (0x3e << 2))
#define   P_AO_RTI_PWR_SYS_CPU_MEM_PD1                         (volatile uint32_t *)(0xff800000 + (0x3e << 2))
#define     AO_CPU_CNTL4                                       (0xff800000 + (0x3f << 2))
#define SEC_AO_CPU_CNTL4                                       (0xff800000 + (0x3f << 2))
#define   P_AO_CPU_CNTL4                                       (volatile uint32_t *)(0xff800000 + (0x3f << 2))
#define     AO_CEC_GEN_CNTL                                    (0xff800000 + (0x40 << 2))
#define SEC_AO_CEC_GEN_CNTL                                    (0xff800000 + (0x40 << 2))
#define   P_AO_CEC_GEN_CNTL                                    (volatile uint32_t *)(0xff800000 + (0x40 << 2))
#define     AO_CEC_RW_REG                                      (0xff800000 + (0x41 << 2))
#define SEC_AO_CEC_RW_REG                                      (0xff800000 + (0x41 << 2))
#define   P_AO_CEC_RW_REG                                      (volatile uint32_t *)(0xff800000 + (0x41 << 2))
#define     AO_CEC_INTR_MASKN                                  (0xff800000 + (0x42 << 2))
#define SEC_AO_CEC_INTR_MASKN                                  (0xff800000 + (0x42 << 2))
#define   P_AO_CEC_INTR_MASKN                                  (volatile uint32_t *)(0xff800000 + (0x42 << 2))
#define     AO_CEC_INTR_CLR                                    (0xff800000 + (0x43 << 2))
#define SEC_AO_CEC_INTR_CLR                                    (0xff800000 + (0x43 << 2))
#define   P_AO_CEC_INTR_CLR                                    (volatile uint32_t *)(0xff800000 + (0x43 << 2))
#define     AO_CEC_INTR_STAT                                   (0xff800000 + (0x44 << 2))
#define SEC_AO_CEC_INTR_STAT                                   (0xff800000 + (0x44 << 2))
#define   P_AO_CEC_INTR_STAT                                   (volatile uint32_t *)(0xff800000 + (0x44 << 2))
#define     AO_CPU_CNTL5                                       (0xff800000 + (0x45 << 2))
#define SEC_AO_CPU_CNTL5                                       (0xff800000 + (0x45 << 2))
#define   P_AO_CPU_CNTL5                                       (volatile uint32_t *)(0xff800000 + (0x45 << 2))
#define     AO_WATCHDOG_CNTL                                   (0xff800000 + (0x48 << 2))
#define SEC_AO_WATCHDOG_CNTL                                   (0xff800000 + (0x48 << 2))
#define   P_AO_WATCHDOG_CNTL                                   (volatile uint32_t *)(0xff800000 + (0x48 << 2))
#define     AO_WATCHDOG_CNTL1                                  (0xff800000 + (0x49 << 2))
#define SEC_AO_WATCHDOG_CNTL1                                  (0xff800000 + (0x49 << 2))
#define   P_AO_WATCHDOG_CNTL1                                  (volatile uint32_t *)(0xff800000 + (0x49 << 2))
#define     AO_WATCHDOG_TCNT                                   (0xff800000 + (0x4a << 2))
#define SEC_AO_WATCHDOG_TCNT                                   (0xff800000 + (0x4a << 2))
#define   P_AO_WATCHDOG_TCNT                                   (volatile uint32_t *)(0xff800000 + (0x4a << 2))
#define     AO_WATCHDOG_RESET                                  (0xff800000 + (0x4b << 2))
#define SEC_AO_WATCHDOG_RESET                                  (0xff800000 + (0x4b << 2))
#define   P_AO_WATCHDOG_RESET                                  (volatile uint32_t *)(0xff800000 + (0x4b << 2))
#define     AO_RTI_STICKY_REG0                                 (0xff800000 + (0x4c << 2))
#define SEC_AO_RTI_STICKY_REG0                                 (0xff800000 + (0x4c << 2))
#define   P_AO_RTI_STICKY_REG0                                 (volatile uint32_t *)(0xff800000 + (0x4c << 2))
#define     AO_RTI_STICKY_REG1                                 (0xff800000 + (0x4d << 2))
#define SEC_AO_RTI_STICKY_REG1                                 (0xff800000 + (0x4d << 2))
#define   P_AO_RTI_STICKY_REG1                                 (volatile uint32_t *)(0xff800000 + (0x4d << 2))
#define     AO_RTI_STICKY_REG2                                 (0xff800000 + (0x4e << 2))
#define SEC_AO_RTI_STICKY_REG2                                 (0xff800000 + (0x4e << 2))
#define   P_AO_RTI_STICKY_REG2                                 (volatile uint32_t *)(0xff800000 + (0x4e << 2))
#define     AO_RTI_STICKY_REG3                                 (0xff800000 + (0x4f << 2))
#define SEC_AO_RTI_STICKY_REG3                                 (0xff800000 + (0x4f << 2))
#define   P_AO_RTI_STICKY_REG3                                 (volatile uint32_t *)(0xff800000 + (0x4f << 2))
//
// Secure APB3 Slot 2 registers
//
#define     AO_SEC_REG0                                        (0xff800000 + (0x50 << 2))
#define SEC_AO_SEC_REG0                                        (0xff800000 + (0x50 << 2))
#define   P_AO_SEC_REG0                                        (volatile uint32_t *)(0xff800000 + (0x50 << 2))
#define     AO_SEC_REG1                                        (0xff800000 + (0x51 << 2))
#define SEC_AO_SEC_REG1                                        (0xff800000 + (0x51 << 2))
#define   P_AO_SEC_REG1                                        (volatile uint32_t *)(0xff800000 + (0x51 << 2))
#define     AO_SEC_REG2                                        (0xff800000 + (0x52 << 2))
#define SEC_AO_SEC_REG2                                        (0xff800000 + (0x52 << 2))
#define   P_AO_SEC_REG2                                        (volatile uint32_t *)(0xff800000 + (0x52 << 2))
#define     AO_SEC_TMODE_PWD0                                  (0xff800000 + (0x58 << 2))
#define SEC_AO_SEC_TMODE_PWD0                                  (0xff800000 + (0x58 << 2))
#define   P_AO_SEC_TMODE_PWD0                                  (volatile uint32_t *)(0xff800000 + (0x58 << 2))
#define     AO_SEC_TMODE_PWD1                                  (0xff800000 + (0x59 << 2))
#define SEC_AO_SEC_TMODE_PWD1                                  (0xff800000 + (0x59 << 2))
#define   P_AO_SEC_TMODE_PWD1                                  (volatile uint32_t *)(0xff800000 + (0x59 << 2))
#define     AO_SEC_TMODE_PWD2                                  (0xff800000 + (0x5a << 2))
#define SEC_AO_SEC_TMODE_PWD2                                  (0xff800000 + (0x5a << 2))
#define   P_AO_SEC_TMODE_PWD2                                  (volatile uint32_t *)(0xff800000 + (0x5a << 2))
#define     AO_SEC_TMODE_PWD3                                  (0xff800000 + (0x5b << 2))
#define SEC_AO_SEC_TMODE_PWD3                                  (0xff800000 + (0x5b << 2))
#define   P_AO_SEC_TMODE_PWD3                                  (volatile uint32_t *)(0xff800000 + (0x5b << 2))
#define     AO_SEC_SCRATCH                                     (0xff800000 + (0x5f << 2))
#define SEC_AO_SEC_SCRATCH                                     (0xff800000 + (0x5f << 2))
#define   P_AO_SEC_SCRATCH                                     (volatile uint32_t *)(0xff800000 + (0x5f << 2))
#define     AO_SEC_JTAG_PWD0                                   (0xff800000 + (0x60 << 2))
#define SEC_AO_SEC_JTAG_PWD0                                   (0xff800000 + (0x60 << 2))
#define   P_AO_SEC_JTAG_PWD0                                   (volatile uint32_t *)(0xff800000 + (0x60 << 2))
#define     AO_SEC_JTAG_PWD1                                   (0xff800000 + (0x61 << 2))
#define SEC_AO_SEC_JTAG_PWD1                                   (0xff800000 + (0x61 << 2))
#define   P_AO_SEC_JTAG_PWD1                                   (volatile uint32_t *)(0xff800000 + (0x61 << 2))
#define     AO_SEC_JTAG_PWD2                                   (0xff800000 + (0x62 << 2))
#define SEC_AO_SEC_JTAG_PWD2                                   (0xff800000 + (0x62 << 2))
#define   P_AO_SEC_JTAG_PWD2                                   (volatile uint32_t *)(0xff800000 + (0x62 << 2))
#define     AO_SEC_JTAG_PWD3                                   (0xff800000 + (0x63 << 2))
#define SEC_AO_SEC_JTAG_PWD3                                   (0xff800000 + (0x63 << 2))
#define   P_AO_SEC_JTAG_PWD3                                   (volatile uint32_t *)(0xff800000 + (0x63 << 2))
#define     AO_SEC_JTAG_SEC_CNTL                               (0xff800000 + (0x64 << 2))
#define SEC_AO_SEC_JTAG_SEC_CNTL                               (0xff800000 + (0x64 << 2))
#define   P_AO_SEC_JTAG_SEC_CNTL                               (volatile uint32_t *)(0xff800000 + (0x64 << 2))
#define     AO_SEC_JTAG_PWD_ADDR0                              (0xff800000 + (0x65 << 2))
#define SEC_AO_SEC_JTAG_PWD_ADDR0                              (0xff800000 + (0x65 << 2))
#define   P_AO_SEC_JTAG_PWD_ADDR0                              (volatile uint32_t *)(0xff800000 + (0x65 << 2))
#define     AO_SEC_JTAG_PWD_ADDR1                              (0xff800000 + (0x66 << 2))
#define SEC_AO_SEC_JTAG_PWD_ADDR1                              (0xff800000 + (0x66 << 2))
#define   P_AO_SEC_JTAG_PWD_ADDR1                              (volatile uint32_t *)(0xff800000 + (0x66 << 2))
#define     AO_SEC_JTAG_PWD_ADDR2                              (0xff800000 + (0x67 << 2))
#define SEC_AO_SEC_JTAG_PWD_ADDR2                              (0xff800000 + (0x67 << 2))
#define   P_AO_SEC_JTAG_PWD_ADDR2                              (volatile uint32_t *)(0xff800000 + (0x67 << 2))
#define     AO_SEC_JTAG_PWD_ADDR3                              (0xff800000 + (0x68 << 2))
#define SEC_AO_SEC_JTAG_PWD_ADDR3                              (0xff800000 + (0x68 << 2))
#define   P_AO_SEC_JTAG_PWD_ADDR3                              (volatile uint32_t *)(0xff800000 + (0x68 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG0_0                      (0xff800000 + (0x70 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG0_0                      (0xff800000 + (0x70 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG0_0                      (volatile uint32_t *)(0xff800000 + (0x70 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG0_1                      (0xff800000 + (0x71 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG0_1                      (0xff800000 + (0x71 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG0_1                      (volatile uint32_t *)(0xff800000 + (0x71 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG0_2                      (0xff800000 + (0x72 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG0_2                      (0xff800000 + (0x72 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG0_2                      (volatile uint32_t *)(0xff800000 + (0x72 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG1_0                      (0xff800000 + (0x73 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG1_0                      (0xff800000 + (0x73 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG1_0                      (volatile uint32_t *)(0xff800000 + (0x73 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG1_1                      (0xff800000 + (0x74 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG1_1                      (0xff800000 + (0x74 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG1_1                      (volatile uint32_t *)(0xff800000 + (0x74 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG1_2                      (0xff800000 + (0x75 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG1_2                      (0xff800000 + (0x75 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG1_2                      (volatile uint32_t *)(0xff800000 + (0x75 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG2_0                      (0xff800000 + (0x76 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG2_0                      (0xff800000 + (0x76 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG2_0                      (volatile uint32_t *)(0xff800000 + (0x76 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG2_1                      (0xff800000 + (0x77 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG2_1                      (0xff800000 + (0x77 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG2_1                      (volatile uint32_t *)(0xff800000 + (0x77 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG2_2                      (0xff800000 + (0x78 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG2_2                      (0xff800000 + (0x78 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG2_2                      (volatile uint32_t *)(0xff800000 + (0x78 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG3_0                      (0xff800000 + (0x79 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG3_0                      (0xff800000 + (0x79 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG3_0                      (volatile uint32_t *)(0xff800000 + (0x79 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG3_1                      (0xff800000 + (0x7a << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG3_1                      (0xff800000 + (0x7a << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG3_1                      (volatile uint32_t *)(0xff800000 + (0x7a << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG3_2                      (0xff800000 + (0x7b << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG3_2                      (0xff800000 + (0x7b << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG3_2                      (volatile uint32_t *)(0xff800000 + (0x7b << 2))
#define     AO_SEC_AO_AHB_SRAM_REG0_0                          (0xff800000 + (0x7c << 2))
#define SEC_AO_SEC_AO_AHB_SRAM_REG0_0                          (0xff800000 + (0x7c << 2))
#define   P_AO_SEC_AO_AHB_SRAM_REG0_0                          (volatile uint32_t *)(0xff800000 + (0x7c << 2))
#define     AO_SEC_AO_AHB_SRAM_REG0_1                          (0xff800000 + (0x7d << 2))
#define SEC_AO_SEC_AO_AHB_SRAM_REG0_1                          (0xff800000 + (0x7d << 2))
#define   P_AO_SEC_AO_AHB_SRAM_REG0_1                          (volatile uint32_t *)(0xff800000 + (0x7d << 2))
#define     AO_SEC_AO_AHB_SRAM_REG1_0                          (0xff800000 + (0x7e << 2))
#define SEC_AO_SEC_AO_AHB_SRAM_REG1_0                          (0xff800000 + (0x7e << 2))
#define   P_AO_SEC_AO_AHB_SRAM_REG1_0                          (volatile uint32_t *)(0xff800000 + (0x7e << 2))
#define     AO_SEC_AO_AHB_SRAM_REG1_1                          (0xff800000 + (0x7f << 2))
#define SEC_AO_SEC_AO_AHB_SRAM_REG1_1                          (0xff800000 + (0x7f << 2))
#define   P_AO_SEC_AO_AHB_SRAM_REG1_1                          (volatile uint32_t *)(0xff800000 + (0x7f << 2))
#define     AO_SEC_SD_CFG8                                     (0xff800000 + (0x88 << 2))
#define SEC_AO_SEC_SD_CFG8                                     (0xff800000 + (0x88 << 2))
#define   P_AO_SEC_SD_CFG8                                     (volatile uint32_t *)(0xff800000 + (0x88 << 2))
#define     AO_SEC_SD_CFG9                                     (0xff800000 + (0x89 << 2))
#define SEC_AO_SEC_SD_CFG9                                     (0xff800000 + (0x89 << 2))
#define   P_AO_SEC_SD_CFG9                                     (volatile uint32_t *)(0xff800000 + (0x89 << 2))
#define     AO_SEC_SD_CFG10                                    (0xff800000 + (0x8a << 2))
#define SEC_AO_SEC_SD_CFG10                                    (0xff800000 + (0x8a << 2))
#define   P_AO_SEC_SD_CFG10                                    (volatile uint32_t *)(0xff800000 + (0x8a << 2))
#define     AO_SEC_SD_CFG11                                    (0xff800000 + (0x8b << 2))
#define SEC_AO_SEC_SD_CFG11                                    (0xff800000 + (0x8b << 2))
#define   P_AO_SEC_SD_CFG11                                    (volatile uint32_t *)(0xff800000 + (0x8b << 2))
#define     AO_SEC_SD_CFG12                                    (0xff800000 + (0x8c << 2))
#define SEC_AO_SEC_SD_CFG12                                    (0xff800000 + (0x8c << 2))
#define   P_AO_SEC_SD_CFG12                                    (volatile uint32_t *)(0xff800000 + (0x8c << 2))
#define     AO_SEC_SD_CFG13                                    (0xff800000 + (0x8d << 2))
#define SEC_AO_SEC_SD_CFG13                                    (0xff800000 + (0x8d << 2))
#define   P_AO_SEC_SD_CFG13                                    (volatile uint32_t *)(0xff800000 + (0x8d << 2))
#define     AO_SEC_SD_CFG14                                    (0xff800000 + (0x8e << 2))
#define SEC_AO_SEC_SD_CFG14                                    (0xff800000 + (0x8e << 2))
#define   P_AO_SEC_SD_CFG14                                    (volatile uint32_t *)(0xff800000 + (0x8e << 2))
#define     AO_SEC_SD_CFG15                                    (0xff800000 + (0x8f << 2))
#define SEC_AO_SEC_SD_CFG15                                    (0xff800000 + (0x8f << 2))
#define   P_AO_SEC_SD_CFG15                                    (volatile uint32_t *)(0xff800000 + (0x8f << 2))
#define     AO_SEC_GP_CFG0                                     (0xff800000 + (0x90 << 2))
#define SEC_AO_SEC_GP_CFG0                                     (0xff800000 + (0x90 << 2))
#define   P_AO_SEC_GP_CFG0                                     (volatile uint32_t *)(0xff800000 + (0x90 << 2))
#define     AO_SEC_GP_CFG1                                     (0xff800000 + (0x91 << 2))
#define SEC_AO_SEC_GP_CFG1                                     (0xff800000 + (0x91 << 2))
#define   P_AO_SEC_GP_CFG1                                     (volatile uint32_t *)(0xff800000 + (0x91 << 2))
#define     AO_SEC_GP_CFG2                                     (0xff800000 + (0x92 << 2))
#define SEC_AO_SEC_GP_CFG2                                     (0xff800000 + (0x92 << 2))
#define   P_AO_SEC_GP_CFG2                                     (volatile uint32_t *)(0xff800000 + (0x92 << 2))
#define     AO_SEC_GP_CFG3                                     (0xff800000 + (0x93 << 2))
#define SEC_AO_SEC_GP_CFG3                                     (0xff800000 + (0x93 << 2))
#define   P_AO_SEC_GP_CFG3                                     (volatile uint32_t *)(0xff800000 + (0x93 << 2))
#define     AO_SEC_GP_CFG4                                     (0xff800000 + (0x94 << 2))
#define SEC_AO_SEC_GP_CFG4                                     (0xff800000 + (0x94 << 2))
#define   P_AO_SEC_GP_CFG4                                     (volatile uint32_t *)(0xff800000 + (0x94 << 2))
#define     AO_SEC_GP_CFG5                                     (0xff800000 + (0x95 << 2))
#define SEC_AO_SEC_GP_CFG5                                     (0xff800000 + (0x95 << 2))
#define   P_AO_SEC_GP_CFG5                                     (volatile uint32_t *)(0xff800000 + (0x95 << 2))
#define     AO_SEC_GP_CFG6                                     (0xff800000 + (0x96 << 2))
#define SEC_AO_SEC_GP_CFG6                                     (0xff800000 + (0x96 << 2))
#define   P_AO_SEC_GP_CFG6                                     (volatile uint32_t *)(0xff800000 + (0x96 << 2))
#define     AO_SEC_GP_CFG7                                     (0xff800000 + (0x97 << 2))
#define SEC_AO_SEC_GP_CFG7                                     (0xff800000 + (0x97 << 2))
#define   P_AO_SEC_GP_CFG7                                     (volatile uint32_t *)(0xff800000 + (0x97 << 2))
#define     AO_SEC_GP_CFG8                                     (0xff800000 + (0x98 << 2))
#define SEC_AO_SEC_GP_CFG8                                     (0xff800000 + (0x98 << 2))
#define   P_AO_SEC_GP_CFG8                                     (volatile uint32_t *)(0xff800000 + (0x98 << 2))
#define     AO_SEC_GP_CFG9                                     (0xff800000 + (0x99 << 2))
#define SEC_AO_SEC_GP_CFG9                                     (0xff800000 + (0x99 << 2))
#define   P_AO_SEC_GP_CFG9                                     (volatile uint32_t *)(0xff800000 + (0x99 << 2))
#define     AO_SEC_GP_CFG10                                    (0xff800000 + (0x9a << 2))
#define SEC_AO_SEC_GP_CFG10                                    (0xff800000 + (0x9a << 2))
#define   P_AO_SEC_GP_CFG10                                    (volatile uint32_t *)(0xff800000 + (0x9a << 2))
#define     AO_SEC_GP_CFG11                                    (0xff800000 + (0x9b << 2))
#define SEC_AO_SEC_GP_CFG11                                    (0xff800000 + (0x9b << 2))
#define   P_AO_SEC_GP_CFG11                                    (volatile uint32_t *)(0xff800000 + (0x9b << 2))
#define     AO_SEC_GP_CFG12                                    (0xff800000 + (0x9c << 2))
#define SEC_AO_SEC_GP_CFG12                                    (0xff800000 + (0x9c << 2))
#define   P_AO_SEC_GP_CFG12                                    (volatile uint32_t *)(0xff800000 + (0x9c << 2))
#define     AO_SEC_GP_CFG13                                    (0xff800000 + (0x9d << 2))
#define SEC_AO_SEC_GP_CFG13                                    (0xff800000 + (0x9d << 2))
#define   P_AO_SEC_GP_CFG13                                    (volatile uint32_t *)(0xff800000 + (0x9d << 2))
#define     AO_SEC_GP_CFG14                                    (0xff800000 + (0x9e << 2))
#define SEC_AO_SEC_GP_CFG14                                    (0xff800000 + (0x9e << 2))
#define   P_AO_SEC_GP_CFG14                                    (volatile uint32_t *)(0xff800000 + (0x9e << 2))
#define     AO_SEC_GP_CFG15                                    (0xff800000 + (0x9f << 2))
#define SEC_AO_SEC_GP_CFG15                                    (0xff800000 + (0x9f << 2))
#define   P_AO_SEC_GP_CFG15                                    (volatile uint32_t *)(0xff800000 + (0x9f << 2))
#define     AO_CECB_CLK_CNTL_REG0                              (0xff800000 + (0xa0 << 2))
#define SEC_AO_CECB_CLK_CNTL_REG0                              (0xff800000 + (0xa0 << 2))
#define   P_AO_CECB_CLK_CNTL_REG0                              (volatile uint32_t *)(0xff800000 + (0xa0 << 2))
#define     AO_CECB_CLK_CNTL_REG1                              (0xff800000 + (0xa1 << 2))
#define SEC_AO_CECB_CLK_CNTL_REG1                              (0xff800000 + (0xa1 << 2))
#define   P_AO_CECB_CLK_CNTL_REG1                              (volatile uint32_t *)(0xff800000 + (0xa1 << 2))
#define     AO_CECB_GEN_CNTL                                   (0xff800000 + (0xa2 << 2))
#define SEC_AO_CECB_GEN_CNTL                                   (0xff800000 + (0xa2 << 2))
#define   P_AO_CECB_GEN_CNTL                                   (volatile uint32_t *)(0xff800000 + (0xa2 << 2))
#define     AO_CECB_RW_REG                                     (0xff800000 + (0xa3 << 2))
#define SEC_AO_CECB_RW_REG                                     (0xff800000 + (0xa3 << 2))
#define   P_AO_CECB_RW_REG                                     (volatile uint32_t *)(0xff800000 + (0xa3 << 2))
#define     AO_CECB_INTR_MASKN                                 (0xff800000 + (0xa4 << 2))
#define SEC_AO_CECB_INTR_MASKN                                 (0xff800000 + (0xa4 << 2))
#define   P_AO_CECB_INTR_MASKN                                 (volatile uint32_t *)(0xff800000 + (0xa4 << 2))
#define     AO_CECB_INTR_CLR                                   (0xff800000 + (0xa5 << 2))
#define SEC_AO_CECB_INTR_CLR                                   (0xff800000 + (0xa5 << 2))
#define   P_AO_CECB_INTR_CLR                                   (volatile uint32_t *)(0xff800000 + (0xa5 << 2))
#define     AO_CECB_INTR_STAT                                  (0xff800000 + (0xa6 << 2))
#define SEC_AO_CECB_INTR_STAT                                  (0xff800000 + (0xa6 << 2))
#define   P_AO_CECB_INTR_STAT                                  (volatile uint32_t *)(0xff800000 + (0xa6 << 2))
//`define AO_RTC_ADDR0                    8'h70 //TODO: DEFINE IF WE'RE IMPLEMENTING AO_RTC
//`define AO_RTC_ADDR1                    8'h71 //TODO: DEFINE IF WE'RE IMPLEMENTING AO_RTC
//`define AO_RTC_ADDR2                    8'h72 //TODO: DEFINE IF WE'RE IMPLEMENTING AO_RTC
//`define AO_RTC_ADDR3                    8'h73 //TODO: DEFINE IF WE'RE IMPLEMENTING AO_RTC
//`define AO_RTC_ADDR4                    8'h74 //TODO: DEFINE IF WE'RE IMPLEMENTING AO_RTC
#define     AO_MSG_INDEX0                                      (0xff800000 + (0xb0 << 2))
#define SEC_AO_MSG_INDEX0                                      (0xff800000 + (0xb0 << 2))
#define   P_AO_MSG_INDEX0                                      (volatile uint32_t *)(0xff800000 + (0xb0 << 2))
#define     AO_MSG_INDEX1                                      (0xff800000 + (0xb1 << 2))
#define SEC_AO_MSG_INDEX1                                      (0xff800000 + (0xb1 << 2))
#define   P_AO_MSG_INDEX1                                      (volatile uint32_t *)(0xff800000 + (0xb1 << 2))
#define     AO_MSG_INDEX2                                      (0xff800000 + (0xb2 << 2))
#define SEC_AO_MSG_INDEX2                                      (0xff800000 + (0xb2 << 2))
#define   P_AO_MSG_INDEX2                                      (volatile uint32_t *)(0xff800000 + (0xb2 << 2))
#define     AO_MSG_INDEX3                                      (0xff800000 + (0xb3 << 2))
#define SEC_AO_MSG_INDEX3                                      (0xff800000 + (0xb3 << 2))
#define   P_AO_MSG_INDEX3                                      (volatile uint32_t *)(0xff800000 + (0xb3 << 2))
// ----------------------------
// PWM C-D
// ----------------------------
//#define AO_PWM_CD_REG_BASE 0x02
// APB4_DECODER_NON_SECURE_BASE     32'hFF802000
// APB4_DECODER_SECURE_BASE         32'hFF802000
#define     AO_PWM_PWM_C                                       (0xff802000 + (0x00 << 2))
#define SEC_AO_PWM_PWM_C                                       (0xff802000 + (0x00 << 2))
#define   P_AO_PWM_PWM_C                                       (volatile uint32_t *)(0xff802000 + (0x00 << 2))
#define     AO_PWM_PWM_D                                       (0xff802000 + (0x01 << 2))
#define SEC_AO_PWM_PWM_D                                       (0xff802000 + (0x01 << 2))
#define   P_AO_PWM_PWM_D                                       (volatile uint32_t *)(0xff802000 + (0x01 << 2))
#define     AO_PWM_MISC_REG_CD                                 (0xff802000 + (0x02 << 2))
#define SEC_AO_PWM_MISC_REG_CD                                 (0xff802000 + (0x02 << 2))
#define   P_AO_PWM_MISC_REG_CD                                 (volatile uint32_t *)(0xff802000 + (0x02 << 2))
#define     AO_PWM_DELTA_SIGMA_CD                              (0xff802000 + (0x03 << 2))
#define SEC_AO_PWM_DELTA_SIGMA_CD                              (0xff802000 + (0x03 << 2))
#define   P_AO_PWM_DELTA_SIGMA_CD                              (volatile uint32_t *)(0xff802000 + (0x03 << 2))
#define     AO_PWM_TIME_CD                                     (0xff802000 + (0x04 << 2))
#define SEC_AO_PWM_TIME_CD                                     (0xff802000 + (0x04 << 2))
#define   P_AO_PWM_TIME_CD                                     (volatile uint32_t *)(0xff802000 + (0x04 << 2))
#define     AO_PWM_C2                                          (0xff802000 + (0x05 << 2))
#define SEC_AO_PWM_C2                                          (0xff802000 + (0x05 << 2))
#define   P_AO_PWM_C2                                          (volatile uint32_t *)(0xff802000 + (0x05 << 2))
#define     AO_PWM_D2                                          (0xff802000 + (0x06 << 2))
#define SEC_AO_PWM_D2                                          (0xff802000 + (0x06 << 2))
#define   P_AO_PWM_D2                                          (volatile uint32_t *)(0xff802000 + (0x06 << 2))
#define     AO_PWM_BLINK_CD                                    (0xff802000 + (0x07 << 2))
#define SEC_AO_PWM_BLINK_CD                                    (0xff802000 + (0x07 << 2))
#define   P_AO_PWM_BLINK_CD                                    (volatile uint32_t *)(0xff802000 + (0x07 << 2))
// ----------------------------
// UART
// ----------------------------
//#define AO_UART_REG_BASE 0x03
// APB4_DECODER_NON_SECURE_BASE     32'hFF803000
// APB4_DECODER_SECURE_BASE         32'hFF803000
#define     AO_UART_WFIFO                                      (0xff803000 + (0x00 << 2))
#define SEC_AO_UART_WFIFO                                      (0xff803000 + (0x00 << 2))
#define   P_AO_UART_WFIFO                                      (volatile uint32_t *)(0xff803000 + (0x00 << 2))
#define     AO_UART_RFIFO                                      (0xff803000 + (0x01 << 2))
#define SEC_AO_UART_RFIFO                                      (0xff803000 + (0x01 << 2))
#define   P_AO_UART_RFIFO                                      (volatile uint32_t *)(0xff803000 + (0x01 << 2))
#define     AO_UART_CONTROL                                    (0xff803000 + (0x02 << 2))
#define SEC_AO_UART_CONTROL                                    (0xff803000 + (0x02 << 2))
#define   P_AO_UART_CONTROL                                    (volatile uint32_t *)(0xff803000 + (0x02 << 2))
#define     AO_UART_STATUS                                     (0xff803000 + (0x03 << 2))
#define SEC_AO_UART_STATUS                                     (0xff803000 + (0x03 << 2))
#define   P_AO_UART_STATUS                                     (volatile uint32_t *)(0xff803000 + (0x03 << 2))
#define     AO_UART_MISC                                       (0xff803000 + (0x04 << 2))
#define SEC_AO_UART_MISC                                       (0xff803000 + (0x04 << 2))
#define   P_AO_UART_MISC                                       (volatile uint32_t *)(0xff803000 + (0x04 << 2))
#define     AO_UART_REG5                                       (0xff803000 + (0x05 << 2))
#define SEC_AO_UART_REG5                                       (0xff803000 + (0x05 << 2))
#define   P_AO_UART_REG5                                       (volatile uint32_t *)(0xff803000 + (0x05 << 2))
// ----------------------------
// UART2
// ----------------------------
//#define AO_UART2_REG_BASE 0x04
// APB4_DECODER_NON_SECURE_BASE     32'hFF804000
// APB4_DECODER_SECURE_BASE         32'hFF804000
#define     AO_UART2_WFIFO                                     (0xff804000 + (0x00 << 2))
#define SEC_AO_UART2_WFIFO                                     (0xff804000 + (0x00 << 2))
#define   P_AO_UART2_WFIFO                                     (volatile uint32_t *)(0xff804000 + (0x00 << 2))
#define     AO_UART2_RFIFO                                     (0xff804000 + (0x01 << 2))
#define SEC_AO_UART2_RFIFO                                     (0xff804000 + (0x01 << 2))
#define   P_AO_UART2_RFIFO                                     (volatile uint32_t *)(0xff804000 + (0x01 << 2))
#define     AO_UART2_CONTROL                                   (0xff804000 + (0x02 << 2))
#define SEC_AO_UART2_CONTROL                                   (0xff804000 + (0x02 << 2))
#define   P_AO_UART2_CONTROL                                   (volatile uint32_t *)(0xff804000 + (0x02 << 2))
#define     AO_UART2_STATUS                                    (0xff804000 + (0x03 << 2))
#define SEC_AO_UART2_STATUS                                    (0xff804000 + (0x03 << 2))
#define   P_AO_UART2_STATUS                                    (volatile uint32_t *)(0xff804000 + (0x03 << 2))
#define     AO_UART2_MISC                                      (0xff804000 + (0x04 << 2))
#define SEC_AO_UART2_MISC                                      (0xff804000 + (0x04 << 2))
#define   P_AO_UART2_MISC                                      (volatile uint32_t *)(0xff804000 + (0x04 << 2))
#define     AO_UART2_REG5                                      (0xff804000 + (0x05 << 2))
#define SEC_AO_UART2_REG5                                      (0xff804000 + (0x05 << 2))
#define   P_AO_UART2_REG5                                      (volatile uint32_t *)(0xff804000 + (0x05 << 2))
// ----------------------------
// I2C Master (8)
// ----------------------------
//#define AO_I2C_M_REG_BASE 0x05
// APB4_DECODER_NON_SECURE_BASE     32'hFF805000
// APB4_DECODER_SECURE_BASE         32'hFF805000
#define     AO_I2C_M_0_CONTROL_REG                             (0xff805000 + (0x00 << 2))
#define SEC_AO_I2C_M_0_CONTROL_REG                             (0xff805000 + (0x00 << 2))
#define   P_AO_I2C_M_0_CONTROL_REG                             (volatile uint32_t *)(0xff805000 + (0x00 << 2))
#define     AO_I2C_M_0_SLAVE_ADDR                              (0xff805000 + (0x01 << 2))
#define SEC_AO_I2C_M_0_SLAVE_ADDR                              (0xff805000 + (0x01 << 2))
#define   P_AO_I2C_M_0_SLAVE_ADDR                              (volatile uint32_t *)(0xff805000 + (0x01 << 2))
#define     AO_I2C_M_0_TOKEN_LIST0                             (0xff805000 + (0x02 << 2))
#define SEC_AO_I2C_M_0_TOKEN_LIST0                             (0xff805000 + (0x02 << 2))
#define   P_AO_I2C_M_0_TOKEN_LIST0                             (volatile uint32_t *)(0xff805000 + (0x02 << 2))
#define     AO_I2C_M_0_TOKEN_LIST1                             (0xff805000 + (0x03 << 2))
#define SEC_AO_I2C_M_0_TOKEN_LIST1                             (0xff805000 + (0x03 << 2))
#define   P_AO_I2C_M_0_TOKEN_LIST1                             (volatile uint32_t *)(0xff805000 + (0x03 << 2))
#define     AO_I2C_M_0_WDATA_REG0                              (0xff805000 + (0x04 << 2))
#define SEC_AO_I2C_M_0_WDATA_REG0                              (0xff805000 + (0x04 << 2))
#define   P_AO_I2C_M_0_WDATA_REG0                              (volatile uint32_t *)(0xff805000 + (0x04 << 2))
#define     AO_I2C_M_0_WDATA_REG1                              (0xff805000 + (0x05 << 2))
#define SEC_AO_I2C_M_0_WDATA_REG1                              (0xff805000 + (0x05 << 2))
#define   P_AO_I2C_M_0_WDATA_REG1                              (volatile uint32_t *)(0xff805000 + (0x05 << 2))
#define     AO_I2C_M_0_RDATA_REG0                              (0xff805000 + (0x06 << 2))
#define SEC_AO_I2C_M_0_RDATA_REG0                              (0xff805000 + (0x06 << 2))
#define   P_AO_I2C_M_0_RDATA_REG0                              (volatile uint32_t *)(0xff805000 + (0x06 << 2))
#define     AO_I2C_M_0_RDATA_REG1                              (0xff805000 + (0x07 << 2))
#define SEC_AO_I2C_M_0_RDATA_REG1                              (0xff805000 + (0x07 << 2))
#define   P_AO_I2C_M_0_RDATA_REG1                              (volatile uint32_t *)(0xff805000 + (0x07 << 2))
// ----------------------------
// I2C Slave (3)
// ----------------------------
//#define AO_I2C_S_REG_BASE 0x06
// APB4_DECODER_NON_SECURE_BASE     32'hFF806000
// APB4_DECODER_SECURE_BASE         32'hFF806000
#define     AO_I2C_S_CONTROL_REG                               (0xff806000 + (0x00 << 2))
#define SEC_AO_I2C_S_CONTROL_REG                               (0xff806000 + (0x00 << 2))
#define   P_AO_I2C_S_CONTROL_REG                               (volatile uint32_t *)(0xff806000 + (0x00 << 2))
#define     AO_I2C_S_SEND_REG                                  (0xff806000 + (0x01 << 2))
#define SEC_AO_I2C_S_SEND_REG                                  (0xff806000 + (0x01 << 2))
#define   P_AO_I2C_S_SEND_REG                                  (volatile uint32_t *)(0xff806000 + (0x01 << 2))
#define     AO_I2C_S_RECV_REG                                  (0xff806000 + (0x02 << 2))
#define SEC_AO_I2C_S_RECV_REG                                  (0xff806000 + (0x02 << 2))
#define   P_AO_I2C_S_RECV_REG                                  (volatile uint32_t *)(0xff806000 + (0x02 << 2))
#define     AO_I2C_S_CNTL1_REG                                 (0xff806000 + (0x03 << 2))
#define SEC_AO_I2C_S_CNTL1_REG                                 (0xff806000 + (0x03 << 2))
#define   P_AO_I2C_S_CNTL1_REG                                 (volatile uint32_t *)(0xff806000 + (0x03 << 2))
// ----------------------------
// PWM A-B
// ----------------------------
//#define AO_PWM_AB_REG_BASE 0x07
// APB4_DECODER_NON_SECURE_BASE     32'hFF807000
// APB4_DECODER_SECURE_BASE         32'hFF807000
#define     AO_PWM_PWM_A                                       (0xff807000 + (0x00 << 2))
#define SEC_AO_PWM_PWM_A                                       (0xff807000 + (0x00 << 2))
#define   P_AO_PWM_PWM_A                                       (volatile uint32_t *)(0xff807000 + (0x00 << 2))
#define     AO_PWM_PWM_B                                       (0xff807000 + (0x01 << 2))
#define SEC_AO_PWM_PWM_B                                       (0xff807000 + (0x01 << 2))
#define   P_AO_PWM_PWM_B                                       (volatile uint32_t *)(0xff807000 + (0x01 << 2))
#define     AO_PWM_MISC_REG_AB                                 (0xff807000 + (0x02 << 2))
#define SEC_AO_PWM_MISC_REG_AB                                 (0xff807000 + (0x02 << 2))
#define   P_AO_PWM_MISC_REG_AB                                 (volatile uint32_t *)(0xff807000 + (0x02 << 2))
#define     AO_PWM_DELTA_SIGMA_AB                              (0xff807000 + (0x03 << 2))
#define SEC_AO_PWM_DELTA_SIGMA_AB                              (0xff807000 + (0x03 << 2))
#define   P_AO_PWM_DELTA_SIGMA_AB                              (volatile uint32_t *)(0xff807000 + (0x03 << 2))
#define     AO_PWM_TIME_AB                                     (0xff807000 + (0x04 << 2))
#define SEC_AO_PWM_TIME_AB                                     (0xff807000 + (0x04 << 2))
#define   P_AO_PWM_TIME_AB                                     (volatile uint32_t *)(0xff807000 + (0x04 << 2))
#define     AO_PWM_A2                                          (0xff807000 + (0x05 << 2))
#define SEC_AO_PWM_A2                                          (0xff807000 + (0x05 << 2))
#define   P_AO_PWM_A2                                          (volatile uint32_t *)(0xff807000 + (0x05 << 2))
#define     AO_PWM_B2                                          (0xff807000 + (0x06 << 2))
#define SEC_AO_PWM_B2                                          (0xff807000 + (0x06 << 2))
#define   P_AO_PWM_B2                                          (volatile uint32_t *)(0xff807000 + (0x06 << 2))
#define     AO_PWM_BLINK_AB                                    (0xff807000 + (0x07 << 2))
#define SEC_AO_PWM_BLINK_AB                                    (0xff807000 + (0x07 << 2))
#define   P_AO_PWM_BLINK_AB                                    (volatile uint32_t *)(0xff807000 + (0x07 << 2))
// ----------------------------
// Multiformat IR Remote
// ----------------------------
//#define AO_MF_IR_DEC_REG_BASE 0x08
// APB4_DECODER_NON_SECURE_BASE     32'hFF808000
// APB4_DECODER_SECURE_BASE         32'hFF808000
#define     AO_IR_DEC_LDR_ACTIVE                               (0xff808000 + (0x00 << 2))
#define SEC_AO_IR_DEC_LDR_ACTIVE                               (0xff808000 + (0x00 << 2))
#define   P_AO_IR_DEC_LDR_ACTIVE                               (volatile uint32_t *)(0xff808000 + (0x00 << 2))
#define     AO_IR_DEC_LDR_IDLE                                 (0xff808000 + (0x01 << 2))
#define SEC_AO_IR_DEC_LDR_IDLE                                 (0xff808000 + (0x01 << 2))
#define   P_AO_IR_DEC_LDR_IDLE                                 (volatile uint32_t *)(0xff808000 + (0x01 << 2))
#define     AO_IR_DEC_LDR_REPEAT                               (0xff808000 + (0x02 << 2))
#define SEC_AO_IR_DEC_LDR_REPEAT                               (0xff808000 + (0x02 << 2))
#define   P_AO_IR_DEC_LDR_REPEAT                               (volatile uint32_t *)(0xff808000 + (0x02 << 2))
#define     AO_IR_DEC_BIT_0                                    (0xff808000 + (0x03 << 2))
#define SEC_AO_IR_DEC_BIT_0                                    (0xff808000 + (0x03 << 2))
#define   P_AO_IR_DEC_BIT_0                                    (volatile uint32_t *)(0xff808000 + (0x03 << 2))
#define     AO_IR_DEC_REG0                                     (0xff808000 + (0x04 << 2))
#define SEC_AO_IR_DEC_REG0                                     (0xff808000 + (0x04 << 2))
#define   P_AO_IR_DEC_REG0                                     (volatile uint32_t *)(0xff808000 + (0x04 << 2))
#define     AO_IR_DEC_FRAME                                    (0xff808000 + (0x05 << 2))
#define SEC_AO_IR_DEC_FRAME                                    (0xff808000 + (0x05 << 2))
#define   P_AO_IR_DEC_FRAME                                    (volatile uint32_t *)(0xff808000 + (0x05 << 2))
#define     AO_IR_DEC_STATUS                                   (0xff808000 + (0x06 << 2))
#define SEC_AO_IR_DEC_STATUS                                   (0xff808000 + (0x06 << 2))
#define   P_AO_IR_DEC_STATUS                                   (volatile uint32_t *)(0xff808000 + (0x06 << 2))
#define     AO_IR_DEC_REG1                                     (0xff808000 + (0x07 << 2))
#define SEC_AO_IR_DEC_REG1                                     (0xff808000 + (0x07 << 2))
#define   P_AO_IR_DEC_REG1                                     (volatile uint32_t *)(0xff808000 + (0x07 << 2))
#define     AO_MF_IR_DEC_LDR_ACTIVE                            (0xff808000 + (0x10 << 2))
#define SEC_AO_MF_IR_DEC_LDR_ACTIVE                            (0xff808000 + (0x10 << 2))
#define   P_AO_MF_IR_DEC_LDR_ACTIVE                            (volatile uint32_t *)(0xff808000 + (0x10 << 2))
#define     AO_MF_IR_DEC_LDR_IDLE                              (0xff808000 + (0x11 << 2))
#define SEC_AO_MF_IR_DEC_LDR_IDLE                              (0xff808000 + (0x11 << 2))
#define   P_AO_MF_IR_DEC_LDR_IDLE                              (volatile uint32_t *)(0xff808000 + (0x11 << 2))
#define     AO_MF_IR_DEC_LDR_REPEAT                            (0xff808000 + (0x12 << 2))
#define SEC_AO_MF_IR_DEC_LDR_REPEAT                            (0xff808000 + (0x12 << 2))
#define   P_AO_MF_IR_DEC_LDR_REPEAT                            (volatile uint32_t *)(0xff808000 + (0x12 << 2))
#define     AO_MF_IR_DEC_BIT_0                                 (0xff808000 + (0x13 << 2))
#define SEC_AO_MF_IR_DEC_BIT_0                                 (0xff808000 + (0x13 << 2))
#define   P_AO_MF_IR_DEC_BIT_0                                 (volatile uint32_t *)(0xff808000 + (0x13 << 2))
#define     AO_MF_IR_DEC_REG0                                  (0xff808000 + (0x14 << 2))
#define SEC_AO_MF_IR_DEC_REG0                                  (0xff808000 + (0x14 << 2))
#define   P_AO_MF_IR_DEC_REG0                                  (volatile uint32_t *)(0xff808000 + (0x14 << 2))
#define     AO_MF_IR_DEC_FRAME                                 (0xff808000 + (0x15 << 2))
#define SEC_AO_MF_IR_DEC_FRAME                                 (0xff808000 + (0x15 << 2))
#define   P_AO_MF_IR_DEC_FRAME                                 (volatile uint32_t *)(0xff808000 + (0x15 << 2))
#define     AO_MF_IR_DEC_STATUS                                (0xff808000 + (0x16 << 2))
#define SEC_AO_MF_IR_DEC_STATUS                                (0xff808000 + (0x16 << 2))
#define   P_AO_MF_IR_DEC_STATUS                                (volatile uint32_t *)(0xff808000 + (0x16 << 2))
#define     AO_MF_IR_DEC_REG1                                  (0xff808000 + (0x17 << 2))
#define SEC_AO_MF_IR_DEC_REG1                                  (0xff808000 + (0x17 << 2))
#define   P_AO_MF_IR_DEC_REG1                                  (volatile uint32_t *)(0xff808000 + (0x17 << 2))
#define     AO_MF_IR_DEC_REG2                                  (0xff808000 + (0x18 << 2))
#define SEC_AO_MF_IR_DEC_REG2                                  (0xff808000 + (0x18 << 2))
#define   P_AO_MF_IR_DEC_REG2                                  (volatile uint32_t *)(0xff808000 + (0x18 << 2))
#define     AO_MF_IR_DEC_DURATN2                               (0xff808000 + (0x19 << 2))
#define SEC_AO_MF_IR_DEC_DURATN2                               (0xff808000 + (0x19 << 2))
#define   P_AO_MF_IR_DEC_DURATN2                               (volatile uint32_t *)(0xff808000 + (0x19 << 2))
#define     AO_MF_IR_DEC_DURATN3                               (0xff808000 + (0x1a << 2))
#define SEC_AO_MF_IR_DEC_DURATN3                               (0xff808000 + (0x1a << 2))
#define   P_AO_MF_IR_DEC_DURATN3                               (volatile uint32_t *)(0xff808000 + (0x1a << 2))
#define     AO_MF_IR_DEC_FRAME1                                (0xff808000 + (0x1b << 2))
#define SEC_AO_MF_IR_DEC_FRAME1                                (0xff808000 + (0x1b << 2))
#define   P_AO_MF_IR_DEC_FRAME1                                (volatile uint32_t *)(0xff808000 + (0x1b << 2))
#define     AO_MF_IR_DEC_STATUS1                               (0xff808000 + (0x1c << 2))
#define SEC_AO_MF_IR_DEC_STATUS1                               (0xff808000 + (0x1c << 2))
#define   P_AO_MF_IR_DEC_STATUS1                               (volatile uint32_t *)(0xff808000 + (0x1c << 2))
#define     AO_MF_IR_DEC_STATUS2                               (0xff808000 + (0x1d << 2))
#define SEC_AO_MF_IR_DEC_STATUS2                               (0xff808000 + (0x1d << 2))
#define   P_AO_MF_IR_DEC_STATUS2                               (volatile uint32_t *)(0xff808000 + (0x1d << 2))
#define     AO_MF_IR_DEC_REG3                                  (0xff808000 + (0x1e << 2))
#define SEC_AO_MF_IR_DEC_REG3                                  (0xff808000 + (0x1e << 2))
#define   P_AO_MF_IR_DEC_REG3                                  (volatile uint32_t *)(0xff808000 + (0x1e << 2))
#define     AO_MF_IR_DEC_FRAME_RSV0                            (0xff808000 + (0x1f << 2))
#define SEC_AO_MF_IR_DEC_FRAME_RSV0                            (0xff808000 + (0x1f << 2))
#define   P_AO_MF_IR_DEC_FRAME_RSV0                            (volatile uint32_t *)(0xff808000 + (0x1f << 2))
#define     AO_MF_IR_DEC_FRAME_RSV1                            (0xff808000 + (0x20 << 2))
#define SEC_AO_MF_IR_DEC_FRAME_RSV1                            (0xff808000 + (0x20 << 2))
#define   P_AO_MF_IR_DEC_FRAME_RSV1                            (volatile uint32_t *)(0xff808000 + (0x20 << 2))
#define     AO_MF_IR_DEC_FILTE                                 (0xff808000 + (0x21 << 2))
#define SEC_AO_MF_IR_DEC_FILTE                                 (0xff808000 + (0x21 << 2))
#define   P_AO_MF_IR_DEC_FILTE                                 (volatile uint32_t *)(0xff808000 + (0x21 << 2))
#define     AO_MF_IR_DEC_IRQ_CTL                               (0xff808000 + (0x22 << 2))
#define SEC_AO_MF_IR_DEC_IRQ_CTL                               (0xff808000 + (0x22 << 2))
#define   P_AO_MF_IR_DEC_IRQ_CTL                               (volatile uint32_t *)(0xff808000 + (0x22 << 2))
#define     AO_MF_IR_DEC_FIFO_CTL                              (0xff808000 + (0x23 << 2))
#define SEC_AO_MF_IR_DEC_FIFO_CTL                              (0xff808000 + (0x23 << 2))
#define   P_AO_MF_IR_DEC_FIFO_CTL                              (volatile uint32_t *)(0xff808000 + (0x23 << 2))
#define     AO_MF_IR_DEC_WIDTH_NEW                             (0xff808000 + (0x24 << 2))
#define SEC_AO_MF_IR_DEC_WIDTH_NEW                             (0xff808000 + (0x24 << 2))
#define   P_AO_MF_IR_DEC_WIDTH_NEW                             (volatile uint32_t *)(0xff808000 + (0x24 << 2))
#define     AO_MF_IR_DEC_REPEAT_DET                            (0xff808000 + (0x25 << 2))
#define SEC_AO_MF_IR_DEC_REPEAT_DET                            (0xff808000 + (0x25 << 2))
#define   P_AO_MF_IR_DEC_REPEAT_DET                            (volatile uint32_t *)(0xff808000 + (0x25 << 2))
// ---------------------------
// SAR ADC
// ---------------------------
//#define AO_SAR_ADC_REG_BASE 0x09
// APB4_DECODER_NON_SECURE_BASE     32'hFF809000
// APB4_DECODER_SECURE_BASE         32'hFF809000
#define     AO_SAR_ADC_REG0                                    (0xff809000 + (0x00 << 2))
#define SEC_AO_SAR_ADC_REG0                                    (0xff809000 + (0x00 << 2))
#define   P_AO_SAR_ADC_REG0                                    (volatile uint32_t *)(0xff809000 + (0x00 << 2))
#define     AO_SAR_ADC_CHAN_LIST                               (0xff809000 + (0x01 << 2))
#define SEC_AO_SAR_ADC_CHAN_LIST                               (0xff809000 + (0x01 << 2))
#define   P_AO_SAR_ADC_CHAN_LIST                               (volatile uint32_t *)(0xff809000 + (0x01 << 2))
#define     AO_SAR_ADC_AVG_CNTL                                (0xff809000 + (0x02 << 2))
#define SEC_AO_SAR_ADC_AVG_CNTL                                (0xff809000 + (0x02 << 2))
#define   P_AO_SAR_ADC_AVG_CNTL                                (volatile uint32_t *)(0xff809000 + (0x02 << 2))
#define     AO_SAR_ADC_REG3                                    (0xff809000 + (0x03 << 2))
#define SEC_AO_SAR_ADC_REG3                                    (0xff809000 + (0x03 << 2))
#define   P_AO_SAR_ADC_REG3                                    (volatile uint32_t *)(0xff809000 + (0x03 << 2))
#define     AO_SAR_ADC_DELAY                                   (0xff809000 + (0x04 << 2))
#define SEC_AO_SAR_ADC_DELAY                                   (0xff809000 + (0x04 << 2))
#define   P_AO_SAR_ADC_DELAY                                   (volatile uint32_t *)(0xff809000 + (0x04 << 2))
#define     AO_SAR_ADC_LAST_RD                                 (0xff809000 + (0x05 << 2))
#define SEC_AO_SAR_ADC_LAST_RD                                 (0xff809000 + (0x05 << 2))
#define   P_AO_SAR_ADC_LAST_RD                                 (volatile uint32_t *)(0xff809000 + (0x05 << 2))
#define     AO_SAR_ADC_FIFO_RD                                 (0xff809000 + (0x06 << 2))
#define SEC_AO_SAR_ADC_FIFO_RD                                 (0xff809000 + (0x06 << 2))
#define   P_AO_SAR_ADC_FIFO_RD                                 (volatile uint32_t *)(0xff809000 + (0x06 << 2))
#define     AO_SAR_ADC_AUX_SW                                  (0xff809000 + (0x07 << 2))
#define SEC_AO_SAR_ADC_AUX_SW                                  (0xff809000 + (0x07 << 2))
#define   P_AO_SAR_ADC_AUX_SW                                  (volatile uint32_t *)(0xff809000 + (0x07 << 2))
#define     AO_SAR_ADC_CHAN_10_SW                              (0xff809000 + (0x08 << 2))
#define SEC_AO_SAR_ADC_CHAN_10_SW                              (0xff809000 + (0x08 << 2))
#define   P_AO_SAR_ADC_CHAN_10_SW                              (volatile uint32_t *)(0xff809000 + (0x08 << 2))
#define     AO_SAR_ADC_DETECT_IDLE_SW                          (0xff809000 + (0x09 << 2))
#define SEC_AO_SAR_ADC_DETECT_IDLE_SW                          (0xff809000 + (0x09 << 2))
#define   P_AO_SAR_ADC_DETECT_IDLE_SW                          (volatile uint32_t *)(0xff809000 + (0x09 << 2))
#define     AO_SAR_ADC_DELTA_10                                (0xff809000 + (0x0a << 2))
#define SEC_AO_SAR_ADC_DELTA_10                                (0xff809000 + (0x0a << 2))
#define   P_AO_SAR_ADC_DELTA_10                                (volatile uint32_t *)(0xff809000 + (0x0a << 2))
#define     AO_SAR_ADC_REG11                                   (0xff809000 + (0x0b << 2))
#define SEC_AO_SAR_ADC_REG11                                   (0xff809000 + (0x0b << 2))
#define   P_AO_SAR_ADC_REG11                                   (volatile uint32_t *)(0xff809000 + (0x0b << 2))
#define     AO_SAR_ADC_REG12                                   (0xff809000 + (0x0c << 2))
#define SEC_AO_SAR_ADC_REG12                                   (0xff809000 + (0x0c << 2))
#define   P_AO_SAR_ADC_REG12                                   (volatile uint32_t *)(0xff809000 + (0x0c << 2))
#define     AO_SAR_ADC_REG13                                   (0xff809000 + (0x0d << 2))
#define SEC_AO_SAR_ADC_REG13                                   (0xff809000 + (0x0d << 2))
#define   P_AO_SAR_ADC_REG13                                   (volatile uint32_t *)(0xff809000 + (0x0d << 2))
// ---------------------------
// RTC (4)
// ---------------------------
// Moved to the secure APB3 bus
// `define AO_RTC_ADDR0                8'hd0
// `define AO_RTC_ADDR1                8'hd1
// `define AO_RTC_ADDR2                8'hd2
// `define AO_RTC_ADDR3                8'hd3
// `define AO_RTC_ADDR4                8'hd4
//
// Closing file:  ./ao_rti_reg.h
//

#endif // SECURE_APB_H


#define P_DMA_T0   (volatile uint32_t *)0xff63e000
#define P_DMA_T1   (volatile uint32_t *)0xff63e004
#define P_DMA_T2   (volatile uint32_t *)0xff63e008
#define P_DMA_T3   (volatile uint32_t *)0xff63e00c
#define P_DMA_T4   (volatile uint32_t *)0xff63e010
#define P_DMA_T5   (volatile uint32_t *)0xff63e014
#define P_DMA_STS0 (volatile uint32_t *)0xff63e020
#define P_DMA_STS1 (volatile uint32_t *)0xff63e024
#define P_DMA_STS2 (volatile uint32_t *)0xff63e028
#define P_DMA_STS3 (volatile uint32_t *)0xff63e02c
#define P_DMA_STS4 (volatile uint32_t *)0xff63e030
#define P_DMA_STS5 (volatile uint32_t *)0xff63e034
#define P_DMA_CFG  (volatile uint32_t *)0xff63e040
#define P_DMA_SEC  (volatile uint32_t *)0xff63e044
