/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * common/cmd_ddr_test.c
 *
 * Copyright (C) 2020 Amlogic, Inc. All rights reserved.
 *
 */

#include <common.h>
#include <u-boot/sha256.h>


//#define  USE_FOR_NEWMAN
//#define USE_FOR_UBOOT_2018

#ifdef CONFIG_ENV_IS_NOWHERE

int setenv(const char *varname, const char *varvalue)
{
return 1;
}

char *getenv(const char *name)
{
	return NULL;
}

#endif //CONFIG_ENV_IS_NOWHERE
#define DWC_AC_PINMUX_TOTAL						28
#define DWC_DFI_PINMUX_TOTAL					26

//#define DDR_USE_DEFINE_TEMPLATE_CONFIG   1
#define DDR_STICKY_MAGIC_NUMBER					0x20180000
#define DDR_CHIP_ID								0x30
#define DDR_STICKY_SOURCE_DMC_STICKY			0x1
#define DDR_STICKY_SOURCE_SRAM					0x2

#define DDR_STICKY_OVERRIDE_CONFIG_MESSAGE_CMD	0x1 //override config
#define DDR_STICKY_SPECIAL_FUNCTION_CMD			0x2 //special test such as shift some bdlr or parameter or interleave test

#define DDR_INIT_CONFIG_STICKY_MESSAGE_SRAM_ADDRESS	0x00040000
#define DDR_INIT_CONFIG_GLOBAL_MESSAGE_SRAM_ADDRESS	0x00050000
#define CONFIG_DDR_TYPE_DDR3				0
#define CONFIG_DDR_TYPE_DDR4				1
#define CONFIG_DDR_TYPE_LPDDR4				2
#define CONFIG_DDR_TYPE_LPDDR3				3
#define CONFIG_DDR_TYPE_LPDDR2				4
//#define CONFIG_DDR_TYPE_LPDDR4X				5
#define CONFIG_DDR_TYPE_AUTO				0xf
#define CONFIG_DDR_TYPE_AUTO_LIMIT			CONFIG_DDR_TYPE_DDR4

#define CONFIG_DDR0_16BIT_CH0				0x1
#define CONFIG_DDR0_16BIT_RANK01_CH0		0x4
#define CONFIG_DDR0_32BIT_RANK0_CH0			0x2
#define CONFIG_DDR0_32BIT_RANK01_CH01		0x3
#define CONFIG_DDR0_32BIT_16BIT_RANK0_CH0	0x5
#define CONFIG_DDR0_32BIT_16BIT_RANK01_CH0	0x6
#define CONFIG_DDR0_32BIT_RANK01_CH0		0x7
#define CONFIG_DDR0_32BIT_RANK0_CH01		0x8


static uint32_t ddr_rd_8_16bit_on_32reg(uint32_t base_addr,uint32_t size,uint32_t offset_index)
{
	uint32_t read_value=0;
	uint32_t addr_t=0;
	uint32_t offset=0;
	if(size==8){
		offset=((offset_index%4)<<3);
		addr_t=(base_addr+((offset_index>>2) << 2));
		read_value= (*(volatile uint32_t *)(( unsigned long )(addr_t)));
		read_value=(read_value>>offset)&0xff;

	}
	if(size==16){
		offset=((offset_index%2)<<4);
		addr_t=(base_addr+((offset_index>>1) << 2));
		read_value= (*(volatile uint32_t *)(( unsigned long )(addr_t)));
		read_value=(read_value>>offset)&0xffff;
	}
	return read_value;

}
static uint32_t ddr_wr_8_16bit_on_32reg(uint32_t base_addr,uint32_t size,uint32_t offset_index,uint32_t value)
{
	uint32_t read_value=0;
	uint32_t write_value=0;
	uint32_t addr_t=0;
	uint32_t offset=0;
	if(size==8){
		offset=((offset_index%4)<<3);
		addr_t=(base_addr+((offset_index>>2) << 2));
		read_value= (*(volatile uint32_t *)(( unsigned long )(addr_t)));
		write_value=(value<<offset)|(read_value&(~(0xff<<offset)));
	}
	if(size==16){
		offset=((offset_index%2)<<4);
		addr_t=(base_addr+((offset_index>>1) << 2));
		read_value= (*(volatile uint32_t *)(( unsigned long )(addr_t)));
		write_value=(value<<offset)|(read_value&(~(0xffff<<offset)));
	}
	*(volatile uint32_t *)(( unsigned long )(addr_t))=write_value;
	return write_value;
}
typedef struct ddr_set{
	unsigned	int		magic;
	unsigned	char	fast_boot[4];// 0   fastboot enable  1 window test margin  2 auto offset after window test 3 auto window test
//	unsigned	int		rsv_int0;
	unsigned	char	board_id;
	//board id reserve,,do not modify
	unsigned	char	version;
	// firmware reserve version,,do not modify
	unsigned	char	DramType;
	//support DramType should confirm with amlogic
	//#define CONFIG_DDR_TYPE_DDR3				0
	//#define CONFIG_DDR_TYPE_DDR4				1
	//#define CONFIG_DDR_TYPE_LPDDR4				2
	//#define CONFIG_DDR_TYPE_LPDDR3				3
	//#define CONFIG_DDR_TYPE_LPDDR2				4
	unsigned	char	DisabledDbyte;
	//use for dram bus 16bit or 32bit,if use 16bit mode ,should disable bit 2,3
	//bit 0 ---use byte 0 ,1 disable byte 0,
	//bit 1 ---use byte 1 ,1 disable byte 1,
	//bit 2 ---use byte 2 ,1 disable byte 2,
	//bit 3 ---use byte 3 ,1 disable byte 3,
	unsigned	char	Is2Ttiming;
	//ddr3/ddr3 use 2t timing,now only support 2t timming
	unsigned	char	HdtCtrl;
	//training information control,do not modify
	unsigned	char	dram_rank_config;
	//support Dram connection type should confirm with amlogic
	//#define CONFIG_DDR0_16BIT_CH0				0x1  //dram total bus width 16bit only use cs0
	//#define CONFIG_DDR0_16BIT_RANK01_CH0		0x4  //dram total bus width 16bit  use cs0 cs1
	//#define CONFIG_DDR0_32BIT_RANK0_CH0			0x2  //dram total bus width 32bit  use cs0
	//#define CONFIG_DDR0_32BIT_RANK01_CH01		0x3    //only for lpddr4,dram total bus width 32bit  use channel a cs0 cs1 channel b cs0 cs1
	//#define CONFIG_DDR0_32BIT_16BIT_RANK0_CH0		0x5    //dram total bus width 32bit only use cs0,but high address use 16bit mode
	//#define CONFIG_DDR0_32BIT_16BIT_RANK01_CH0	0x6   //dram total bus width 32bit  use cs0 cs1,but cs1 use 16bit mode ,current phy not support reserve
	//#define CONFIG_DDR0_32BIT_RANK01_CH0		0x7       //dram total bus width 32bit  use cs0 cs1
	//#define CONFIG_DDR0_32BIT_RANK0_CH01		0x8     //only for lpddr4,dram total bus width 32bit  use channel a cs0  channel b cs0

	/* rsv_char0. update for diagnose type define */
	unsigned	char	diagnose;

	/* imem/dmem define */
	unsigned	int		imem_load_addr;
	//system reserve,do not modify
	unsigned	int		dmem_load_addr;
	//system reserve,do not modify
	unsigned	short	imem_load_size;
	//system reserve,do not modify
	unsigned	short	dmem_load_size;
	//system reserve,do not modify
	unsigned	int		ddr_base_addr;
	//system reserve,do not modify
	unsigned	int		ddr_start_offset;
	//system reserve,do not modify

	unsigned	short	dram_cs0_size_MB;
	//config cs0 dram size ,like 1G DRAM ,setting 1024
	unsigned	short	dram_cs1_size_MB;
	//config cs1 dram size,like 512M DRAM ,setting 512
	/* align8 */

	unsigned	short	training_SequenceCtrl[2];
	//system reserve,do not modify
	unsigned	char	phy_odt_config_rank[2];
	unsigned	char	 rever1;
	unsigned	char	 rever2;
	//training odt config ,only use for training
	// [0]Odt pattern for accesses targeting rank 0. [3:0] is used for write ODT [7:4] is used for read ODT
	// [1]Odt pattern for accesses targeting rank 1. [3:0] is used for write ODT [7:4] is used for read ODT
	unsigned	int		dfi_odt_config;
	//normal go status od config,use for normal status
	//bit 12.  rank1 ODT default. default value for ODT[1] pins if theres no read/write activity.
	//bit 11.  rank1 ODT write sel.  enable ODT[1] if there's write occur in rank1.
	//bit 10.  rank1 ODT write nsel. enable ODT[1] if theres's write occur in rank0.
	//bit 9.   rank1 odt read sel.   enable ODT[1] if there's read occur in rank1.
	//bit 8.   rank1 odt read nsel.  enable ODT[1] if there's read occure in rank0.
	//bit 4.   rank0 ODT default.    default value for ODT[0] pins if theres no read/write activity.
	//bit 3.   rank0 ODT write sel.  enable ODT[0] if there's write occur in rank0.
	//bit 2.   rank0 ODT write nsel. enable ODT[0] if theres's write occur in rank1.
	//bit 1.   rank0 odt read sel.   enable ODT[0] if there's read occur in rank0.
	//bit 0.   rank0 odt read nsel.  enable ODT[0] if there's read occure in rank1.
	unsigned	short	DRAMFreq[4];
	//config dram frequency,use DRAMFreq[0],other reserve
	unsigned	char	PllBypassEn;
	//system reserve,do not modify
	unsigned	char	ddr_rdbi_wr_enable;
	//system reserve,do not modify
	unsigned	char	ddr_rfc_type;
	//config dram rfc type,according dram type,also can use same dram type max config
	//#define DDR_RFC_TYPE_DDR3_512Mbx1				0
	//#define DDR_RFC_TYPE_DDR3_512Mbx2				1
	//#define DDR_RFC_TYPE_DDR3_512Mbx4				2
	//#define DDR_RFC_TYPE_DDR3_512Mbx8				3
	//#define DDR_RFC_TYPE_DDR3_512Mbx16				4
	//#define DDR_RFC_TYPE_DDR4_2Gbx1					5
	//#define DDR_RFC_TYPE_DDR4_2Gbx2					6
	//#define DDR_RFC_TYPE_DDR4_2Gbx4					7
	//#define DDR_RFC_TYPE_DDR4_2Gbx8					8
	//#define DDR_RFC_TYPE_LPDDR4_2Gbx1				9
	//#define DDR_RFC_TYPE_LPDDR4_3Gbx1				10
	//#define DDR_RFC_TYPE_LPDDR4_4Gbx1				11
	unsigned	char	enable_lpddr4x_mode;
	//system reserve,do not modify
	/* align8 */

	unsigned	int		pll_ssc_mode;
	//
	/* pll ssc config:
	 *
	 *   pll_ssc_mode = (1<<20) | (1<<8) | ([strength] << 4) | [mode],
	 *      ppm = strength * 500
	 *      mode: 0=center, 1=up, 2=down
	 *
	 *   eg:
	 *     1. config 1000ppm center ss. then mode=0, strength=2
	 *        .pll_ssc_mode = (1<<20) | (1<<8) | (2 << 4) | 0,
	 *     2. config 3000ppm down ss. then mode=2, strength=6
	 *        .pll_ssc_mode = (1<<20) | (1<<8) | (6 << 4) | 2,
	 */
	unsigned	short	clk_drv_ohm;
	//config soc clk pin signal driver strength ,select 20,30,40,60ohm
	unsigned	short	cs_drv_ohm;
	//config soc cs0 cs1 pin signal driver strength ,select 20,30,40,60ohm
	unsigned	short	ac_drv_ohm;
	//config soc  normal address command pin driver strength ,select 20,30,40,60ohm
	unsigned	short	soc_data_drv_ohm_p;
	//config soc data pin pull up driver strength,select 0,28,30,32,34,37,40,43,48,53,60,68,80,96,120ohm
	unsigned	short	soc_data_drv_ohm_n;
	//config soc data pin pull down driver strength,select 0,28,30,32,34,37,40,43,48,53,60,68,80,96,120ohm
	unsigned	short	soc_data_odt_ohm_p;
	//config soc data pin odt pull up strength,select 0,28,30,32,34,37,40,43,48,53,60,68,80,96,120ohm
	unsigned	short	soc_data_odt_ohm_n;
	//config soc data pin odt pull down strength,select 0,28,30,32,34,37,40,43,48,53,60,68,80,96,120ohm
	unsigned	short	dram_data_drv_ohm;
	//config dram data pin pull up pull down driver strength,ddr3 select 34,40ohm,ddr4 select 34,48ohm,lpddr4 select 40,48,60,80,120,240ohm
	unsigned	short	dram_data_odt_ohm;
	//config dram data pin odt pull up down strength,ddr3 select 40,60,120ohm,ddr4 select 34,40,48,60,120,240ohm,lpddr4 select 40,48,60,80,120,240ohm
	unsigned	short	dram_ac_odt_ohm;
	//config dram ac pin odt pull up down strength,use for lpddr4, select 40,48,60,80,120,240ohm
	unsigned	short	soc_clk_slew_rate;
	//system reserve,do not modify
	unsigned	short	soc_cs_slew_rate;
	//system reserve,do not modify
	unsigned	short	soc_ac_slew_rate;
	//system reserve,do not modify
	unsigned	short	soc_data_slew_rate;
	//system reserve,do not modify
	unsigned	short	vref_output_permil; //phy
	//setting same with vref_dram_permil
	unsigned	short	vref_receiver_permil; //soc
	//soc init SOC receiver vref ,config like 500 means 0.5VDDQ,take care ,please follow SI
	unsigned	short	vref_dram_permil;
	//soc init DRAM receiver vref ,config like 500 means 0.5VDDQ,take care ,please follow SI
	unsigned	short	max_core_timmming_frequency;
	//use for limited ddr speed core timmming parameter,for some old dram maybe have no over speed register
	/* align8 */

	unsigned	char	ac_trace_delay[10];
	unsigned	char	lpddr4_dram_vout_voltage_1_3_2_5_setting;
	unsigned	char	lpddr4_x8_mode;
	//system reserve,do not modify ,take care ,please follow SI
	unsigned	char	ac_pinmux[DWC_AC_PINMUX_TOTAL];
	//use for lpddr3 /lpddr4 ca pinmux remap
	unsigned	char	dfi_pinmux[DWC_DFI_PINMUX_TOTAL];
	unsigned	char	slt_test_function[2];  //[0] slt test function enable,bit 0 enable 4 frequency scan,bit 1 enable force delay line offset ,bit 7 enable skip training function
	//[1],slt test parameter ,use for force delay line offset
	//system reserve,do not modify
	unsigned	short	tdqs2dq;//dq_bdlr_org;
	unsigned	char  dram_data_wr_odt_ohm;
	unsigned	char	bitTimeControl_2d;
	//system reserve,do not modify
	/* align8 */

	unsigned	int		ddr_dmc_remap[5];
	//system reserve,do not modify
	/* align8 */
	unsigned char		ddr_lpddr34_ca_remap[4];
	////use for lpddr3 /lpddr4 ca training data byte lane remap
	unsigned	char	ddr_lpddr34_dq_remap[32];
	////use for lpddr3 /lpddr4 ca pinmux remap
	unsigned	int		dram_rtt_nom_wr_park[2];
	//system reserve,do not modify
	unsigned	int		ddr_func;
	//system reserve,do not modify
	/* align8 */

	//unsigned	long	rsv_long0[2];
	/* v1 end */
//	/*
	unsigned	char	read_dqs_delay[16];
	unsigned	char	read_dq_bit_delay[72];
	unsigned	short	write_dqs_delay[16];
//	*/
	unsigned	short	write_dq_bit_delay[72];
	unsigned	short	read_dqs_gate_delay[16];
	unsigned	char	soc_bit_vref[32];
	unsigned	char	dram_bit_vref[32];
	///*
	unsigned	char	rever3;//read_dqs  read_dq,write_dqs, write_dq
	unsigned	char	dfi_mrl;
	unsigned	char	dfi_hwtmrl;
	unsigned	char	ARdPtrInitVal;
	unsigned	char	retraining[16];
	//override read bit delay
	//extra
//	unsigned	short	dmc_test_worst_window_tx;
//	unsigned	short	dmc_test_worst_window_rx;
//	*/
}ddr_set_t;

ddr_set_t p_ddr_set_t;

char* itoa_ddr_test(int num,char*str,int radix)
{/*Index Table*/
	printf("\nitoa_ddr_test 1\n");
	char index[]="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	unsigned unum;/*Intermediate variable*/
	char temp;
	int i=0,j,k;
	/*check unum value*/
	if (radix == 10 && num<0)
	{
		unum = (unsigned)-num;
		str[i++] = '-';
	}
	else
		unum = (unsigned)num;
	/*transformation*/
	printf("\nitoa_ddr_test 2\n");
	printf("\nunum=0x%08x\n",unum);
	printf("\nunum2=0x%08x\n",(unum%(unsigned)radix));
	printf("\nradix=0x%08x\n",radix);
	str[0] = index[0];
	printf("\nitoa_ddr_test 22\n");
	unum /= radix;
	printf("\nitoa_ddr_test 23\n");
	do {
		str[i++] = index[unum%(unsigned)radix];
		unum /= radix;
	}while(unum);
	printf("\nitoa_ddr_test 3\n");
	str[i] = '\0';
	/*Reverse order*/
	if (str[0] == '-')
		k = 1;
	else
	   	k = 0;
	printf("\nitoa_ddr_test 4\n");
	for (j = k;j <= (i-1)/2;j++)
	{
		temp = str[j];
		str[j] = str[i-1+k-j];
		str[i-1+k-j] = temp;
	}
	return str;
}
//#endif

/*
char *strsep(char **stringp, const char *delim)
{
    char *s;
    const char *p;
    int c, sc;
    char *tok;
    if ((s = *stringp)== NULL)
        return (NULL);
    for (tok = s;;) {
        c = *s++;
        p = delim;
        do {
            if ((sc =*p++) == c) {
                if (c == 0)
                    s = NULL;
                else
                    s[-1] = 0;
                *stringp = s;
                return (tok);
            }
        } while (sc != 0);
    }
  
}
*/
int TOLOWER(int ch)
{

   if ((unsigned int)(ch - 'A') < 26u )
      ch += 'a' - 'A';

   return ch;
}

int isxdigit(int ch)
{
    return (unsigned int)( ch         - '0') < 10u  ||
           (unsigned int)((ch | 0x20) - 'a') <  6u;
}

int isdigit(int ch)
{
    return (unsigned int)(ch - '0') < 10u;
}
unsigned int simple_guess_base(const char *cp)
{
	if (cp[0] == '0') {
		if (TOLOWER(cp[1]) == 'x' && isxdigit(cp[2]))
			return 16;
		else
			// return 8;
			return 10;
	} else {
		return 10;
	}
}
unsigned int simple_strtoull_ddr(const char *cp, char **endp, unsigned int base)
{
	unsigned int  result = 0;
	//printf("test sizeof(str_buf)==%d\n",1);
	if(cp == NULL) //jiaxing add 20170616
		return 0;
	if (!base)
		base = simple_guess_base(cp);
	if (base == 16 && cp[0] == '0' && TOLOWER(cp[1]) == 'x')
		cp += 2;
	if (base == 10) {
		while ((*cp)== '0') 
			cp++;
	}
	while (isxdigit(*cp)) {
		unsigned int value;
		value = isdigit(*cp) ? *cp - '0' : TOLOWER(*cp) - 'a' + 10;
		if (value >= base)
			break;
		result = result * base + value;
		cp++;
	}
	if (endp)
		*endp = (char *)cp;
	return result;
}	
unsigned int env_to_a_num(const char *env_name)
{
	char *str_buf = NULL;
	char buf[48];
	str_buf = (char *)(&buf);
	memset(str_buf, 0, sizeof(buf));
	printf("sizeof(str_buf)==%d\n",(unsigned int)(sizeof(buf)));
	str_buf = getenv(env_name);
	unsigned int a_num = 0;
	char *endp;

	printf("str==%s\n",str_buf);

	a_num=simple_strtoull_ddr(str_buf, &endp, 0);
	printf("%s==0x%08x\n",str_buf,a_num);

	return a_num;
}
unsigned int a_num_to_env(const char *env_name ,unsigned int *a_num)
{
	char *str_buf=NULL;
	char buf[1024];
	//unsigned int str_to_numarry[48];
	//str_buf = (char *)malloc(sizeof(char)*1024);
	str_buf = (char *)(&buf);
	memset(str_buf, 0, sizeof(buf));
	printf("sizeof(str_buf)==%d\n",(unsigned int)(sizeof(buf)));
	str_buf = getenv(env_name);

	printf("str==%s\n",str_buf);

	sprintf(buf, "0x%08x", *a_num);

	printf( "%s==0x%08x", buf,*a_num);
	setenv(env_name, buf);

	run_command("save",0);
	return 1;
}
unsigned int env_to_num(const char *env_name,unsigned int *num_arry)
{
	char *str_buf = NULL;
	char buf[1024];
	unsigned int str_to_numarry[48];
	//str_buf = (char *)malloc(sizeof(char)*1024);
	str_buf = (char *)(&buf);
	memset(str_buf, 0, sizeof(buf));
	printf("sizeof(str_buf)==%d\n",(unsigned int)(sizeof(buf)));
	str_buf = getenv(env_name);

	char * str[48];
	char *endp;
	int i;
	for (i = 0; i < 48; i++)
		str_to_numarry[i] = 0;
	printf("str==%s\n",str_buf);
	for (i = 0; i < 48; i++) {
		str[i] = strsep(&str_buf, ";");
		//str[i] = strsep(&str_buf, " ");
		if(str[i] == NULL)
			break;
		str_to_numarry[i] = simple_strtoull_ddr(str[i], &endp, 0);
		//printf("str_to_numarry[%d]==%d\n",i,str_to_numarry[i]);
		//num_arry[i]=str_to_numarry[i];
	}
	for (i = 0; i < 48; i++) {
		printf("str_to_numarry[%d]==%d\n",i,str_to_numarry[i]);
		num_arry[i] = str_to_numarry[i];
	}
	//num_arry=(unsigned int *)(&str_to_numarry);
	return 1;
}

unsigned int num_to_env(const char *env_name,unsigned int *num_arry)
{
	char *str_buf=NULL;
	char buf[1024];
	int i;
	//unsigned int str_to_numarry[48];
	//str_buf = (char *)malloc(sizeof(char)*1024);
	str_buf = (char *)(&buf);
	memset(str_buf, 0, sizeof(buf));
	printf("sizeof(str_buf)==%d\n",(unsigned int)(sizeof(buf)));
	str_buf = getenv(env_name);

	//char * str[48];
	printf("str==%s\n",str_buf);


	sprintf(buf, "0x%08x", num_arry[0]);
	for (i = 1; i < 48; i++) {
		//num_arry[i]=0;
		sprintf(buf, "%s;0x%08x", buf,num_arry[i]);
		printf("%d  %d\n", i,num_arry[i]);
	}
	//sprintf(str, "%lx", value);
	printf( "%s", buf);
	setenv(env_name, buf);

	run_command("save",0);
	//num_arry=(unsigned int *)(&str_to_numarry);
	return 1;
}

#define TDATA32F 0xffffffff
#define TDATA32A 0xaaaaaaaa
#define TDATA325 0x55555555
#define     PREG_STICKY_G12A_REG0                                   (0xff634400 + (0x070 << 2))
//#define  DDR_TEST_AUTO_TEST_CMD_MAGIC   0x01234567
#define DMC_STICKY_0                               ((0x0000  << 2) + 0xff639800)
#define DMC_STICKY_G12A_0                               ((0x0000  << 2) + 0xff638800)
#define DMC_STICKY_MAGIC_0                              0x12345678
#define DMC_STICKY_MAGIC_1                              0xabcdbead
#define DMC_STICKY_UBOOT_WINDOW_MAGIC_1                              0x22
#define DMC_STICKY_AUTO_TEST_CMD_INDEX_MAGIC_1                              0x33
unsigned int dmc_sticky[64];
unsigned int sticky_reg_base_add=0;

//#define DDR_TEST_ACLCDLR
unsigned int   global_boot_times= 0;
unsigned int   watchdog_time_s= 20;
unsigned int global_ddr_clk=1;
unsigned int	bdlr_100step=0;
unsigned int       ui_1_32_100step=0;
unsigned int   error_count =0;
unsigned int  error_outof_count_flag=0;
unsigned int  copy_test_flag = 0;
unsigned int  training_pattern_flag = 0;
unsigned int test_start_addr=0x1080000;

unsigned int  dq_lcd_bdl_value_aclcdlr_org_a;
unsigned int  dq_lcd_bdl_value_bdlr0_org_a;
unsigned int  dq_lcd_bdl_value_aclcdlr_min_a;
unsigned int  dq_lcd_bdl_value_bdlr0_min_a;
unsigned int  dq_lcd_bdl_value_aclcdlr_max_a;
unsigned int  dq_lcd_bdl_value_bdlr0_max_a;
unsigned int  dq_lcd_bdl_value_aclcdlr_status_a;
unsigned int  dq_lcd_bdl_value_bdlr0_status_a;

unsigned int  dq_lcd_bdl_value_aclcdlr_org_b;
unsigned int  dq_lcd_bdl_value_bdlr0_org_b;
unsigned int  dq_lcd_bdl_value_aclcdlr_min_b;
unsigned int  dq_lcd_bdl_value_bdlr0_min_b;
unsigned int  dq_lcd_bdl_value_aclcdlr_max_b;
unsigned int  dq_lcd_bdl_value_bdlr0_max_b;

unsigned int  dq_lcd_bdl_value_wdq_org_a[4];
unsigned int  dq_lcd_bdl_value_rdqs_org_a[4];
unsigned int  dq_lcd_bdl_value_wdq_min_a[4];
unsigned int  dq_lcd_bdl_value_wdq_max_a[4];
unsigned int  dq_lcd_bdl_value_rdqs_min_a[4];
unsigned int  dq_lcd_bdl_value_rdqs_max_a[4];
unsigned int  dq_lcd_bdl_value_wdq_status_a[4];
unsigned int  dq_lcd_bdl_value_rdqs_status_a[4];

unsigned int  dq_lcd_bdl_value_wdq_org_b[4];
unsigned int  dq_lcd_bdl_value_rdqs_org_b[4];
unsigned int  dq_lcd_bdl_value_wdq_min_b[4];
unsigned int  dq_lcd_bdl_value_wdq_max_b[4];
unsigned int  dq_lcd_bdl_value_rdqs_min_b[4];
unsigned int  dq_lcd_bdl_value_rdqs_max_b[4];
unsigned int  dq_lcd_bdl_value_wdq_status_b[4];
unsigned int  dq_lcd_bdl_value_rdqs_status_b[4];
unsigned int  acbdlr0_9_reg_org[10];
unsigned int  acbdlr0_9_reg_setup_max[40];
unsigned int  acbdlr0_9_reg_hold_max[40];
unsigned int  acbdlr0_9_reg_setup_time[40];
unsigned int  acbdlr0_9_reg_hold_time[40];
//    unsigned int  data_bdlr0_5_reg_org[6];
unsigned int  data_bdlr0_5_reg_org[28];//4//4lane
unsigned int  bdlr0_9_reg_setup_max[24*4];//4//4 lane 96 bdlr
unsigned int  bdlr0_9_reg_hold_max[24*4];
unsigned int  bdlr0_9_reg_setup_time[24*4];
unsigned int  bdlr0_9_reg_hold_time[24*4];

#define readl(addr)    (unsigned int )(*((volatile  unsigned int  *)((unsigned long)(unsigned int )addr)))  //rd_reg(addr)
#define writel(data ,addr)  (*((volatile  unsigned int  *)((unsigned long)(unsigned int )addr)))=(data)  //wr_reg(addr, data)

#define wr_reg(addr, data)	(*((volatile  unsigned int  *)((unsigned long)(unsigned int )addr)))=(data)  //wr_reg(addr, data)
#define rd_reg(addr)		 (unsigned int )(*((volatile  unsigned int  *)((unsigned long)(unsigned int )addr)))  //rd_reg(addr)

//#define CONFIG_DDR_CMD_BDL_TUNE
//#define  CONFIG_CMD_DDR_TEST

#ifndef CONFIG_CHIP 
//#define CONFIG_CHIP    CHIP_OLD //CHIP_OLD// //#define CHIP_OLD           0  //#define CHIP_TXLX           1
#define CHIP_OLD           0
#define CHIP_TXLX           1
#define CHIP_A113           2
#define CHIP_G12         3
#define CONFIG_CHIP   CHIP_G12// CHIP_OLD//
#endif

#define P_DDR_PHY_DEFAULT           0
#define P_DDR_PHY_GX_BABY             1
#define  P_DDR_PHY_GX_TV_BABY     2
#define  P_DDR_PHY_905X        3

//#define  P_DDR_PHY_OLD_TAG         0
#define  P_DDR_PHY_G12        4

#if (CONFIG_CHIP>=CHIP_G12)
#define CONFIG_DDR_PHY   P_DDR_PHY_G12
#else 
//#define CONFIG_CHIP    CHIP_OLD//
//#define CONFIG_DDR_PHY    P_DDR_PHY_905X//P_DDR_PHY_GX_BABY//P_DDR_PHY_905X// P_DDR_PHY_GX_BABY
//#define CONFIG_DDR_PHY   P_DDR_PHY_G12//P_DDR_PHY_DEFAULT// P_DDR_PHY_905X//P_DDR_PHY_GX_BABY//P_DDR_PHY_905X// P_DDR_PHY_GX_BABY
#define CONFIG_DDR_PHY   P_DDR_PHY_905X//P_DDR_PHY_DEFAULT// P_DDR_PHY_905X//P_DDR_PHY_GX_BABY//P_DDR_PHY_905X// P_DDR_PHY_GX_BABY
//#define CONFIG_DDR_PHY_NEW_TAG1   P_DDR_PHY_G12
#endif

#define G12_AM_DDR_PLL_CNTL0   0xff638c00

#if (CONFIG_DDR_PHY > P_DDR_PHY_DEFAULT)
#include <asm/arch/secure_apb.h>
#endif

#define PATTERN_USE_DDR_DES
#define  USE_64BIT_POINTER
//#define  USE_32BIT_POINTER
#ifdef USE_64BIT_POINTER
#define p_convter_int(a)  ( unsigned int )( unsigned long )(a)
#define int_convter_p(a)  ( unsigned long )(a)

#else
#define p_convter_int(a)  ( unsigned int )(a)
#define int_convter_p(a)  ( unsigned int )(a)
#endif

#ifdef PATTERN_USE_DDR_DES
#define des_pattern(a,b,c,d)  (des[a]^pattern_##b[c][d])
#define des_inv_pattern(a,b,c,d)   ( des[a]^(~(pattern_##b[c][d])))
#define des_xor_pattern(a,b)   ( a^b)
//des[temp_i]^pattern_2[temp_k][temp_i]
#else
#define des_pattern(a,b,c,d)  (des[a]&0)+pattern_##b[c][d]
#define des_inv_pattern(a,b,c,d)  (des[a]&0)+~(pattern_##b[c][d])
#define des_xor_pattern(a,b)  (a&0+b)
#endif


#define  DDR_LCDLR_CK_USE_FAST_PATTERN
#if (CONFIG_DDR_PHY > P_DDR_PHY_DEFAULT)
#define  DDR_PREFETCH_CACHE
#endif
#ifdef DDR_PREFETCH_CACHE
#define ddr_pld_cache(P)   asm ("prfm PLDL1KEEP, [%0, #376]"::"r" (P))
#else
#define ddr_pld_cache(P)
#endif

#if (CONFIG_DDR_PHY ==  P_DDR_PHY_GX_BABY)
#define DDR0_PUB_REG_BASE			0xc8836000
#define DDR1_PUB_REG_BASE			0xc8836000
#define  CHANNEL_A_REG_BASE  0
#define  CHANNEL_B_REG_BASE  0x2000
#define P_DDR0_CLK_CTRL   0xc8836c00
#define P_DDR1_CLK_CTRL  0xc8836c00
#define OPEN_CHANNEL_A_PHY_CLK()      (writel((0), 0xc8836c00))
#define OPEN_CHANNEL_B_PHY_CLK()     (writel((0), 0xc8836c00))
#define CLOSE_CHANNEL_A_PHY_CLK()      (writel((5), 0xc8836c00))
#define CLOSE_CHANNEL_B_PHY_CLK()     (writel((5), 0xc8836c00))
// #define P_ISA_TIMERE                0xc1109988
//   #define get_us_time()    (readl(P_ISA_TIMERE))
#define AM_DDR_PLL_CNTL						0xc8836800
#define DDR0_PUB_ZQCR						(DDR0_PUB_REG_BASE+(0x90<<2))
#define DDR0_PUB_ZQ0PR						(DDR0_PUB_REG_BASE+(0x91<<2))
#define DDR0_PUB_ZQ0DR						(DDR0_PUB_REG_BASE+(0x92<<2))

#define DDR1_PUB_ZQCR						(DDR1_PUB_REG_BASE+(0x90<<2))
#define DDR1_PUB_ZQ0PR						(DDR1_PUB_REG_BASE+(0x91<<2))
#define DDR1_PUB_ZQ0DR						(DDR1_PUB_REG_BASE+(0x92<<2))

#define DDR0_PUB_ZQ1PR						(DDR0_PUB_REG_BASE+(0x95<<2))
#define DDR0_PUB_ZQ1DR						(DDR0_PUB_REG_BASE+(0x96<<2))
#define DDR0_PUB_ZQ1SR						(DDR0_PUB_REG_BASE+(0x97<<2))
//0x98 reserved)
#define DDR0_PUB_ZQ2PR						(DDR0_PUB_REG_BASE+(0x99<<2))
#define DDR0_PUB_ZQ2DR						(DDR0_PUB_REG_BASE+(0x9A<<2))
#define DDR0_PUB_ZQ2SR						(DDR0_PUB_REG_BASE+(0x9B<<2))
//0x9c reserved)
#define DDR0_PUB_ZQ3PR						(DDR0_PUB_REG_BASE+(0x9D<<2))
#define DDR0_PUB_ZQ3DR						(DDR0_PUB_REG_BASE+(0x9E<<2))
#define DDR0_PUB_ZQ3SR						(DDR0_PUB_REG_BASE+(0x9F<<2))
#define ACBDLR_MAX   0X1F
#define ACLCDLR_MAX   0XFF
#define DQBDLR_MAX   0X1F
#define DQLCDLR_MAX   0XFF
#define DXNGTR_MAX   0X7
#define ACBDLR_NUM   10
#define DDR0_PUB_DX0GCR0                           ((0xa0  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX1GCR0                           ((0x0c0  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX2GCR0                           ((0x0e0  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX3GCR0                           ((0x0100  << 2) + DDR0_PUB_REG_BASE)


#define DMC_REG_BASE						0xc8838000
#define DMC_MON_CTRL2						(DMC_REG_BASE + (0x26 <<2 ))
   //bit 31.   qos_mon_en.    write 1 to trigger the enable. polling this bit 0, means finished.  or use interrupt to check finish.
   //bit 30.   qos_mon interrupt clear.  clear the qos monitor result.  read 1 = qos mon finish interrupt.
   //bit 20.   qos_mon_trig_sel.  1 = vsync.  0 = timer.
   //bit 19:16.  qos monitor channel select.   select one at one time only.
   //bit 15:0.   port select for the selected channel.
#define DMC_MON_CTRL3						(DMC_REG_BASE + (0x27 <<2 ))
  // qos_mon_clk_timer.   How long to measure the bandwidth.


#define DMC_MON_ALL_REQ_CNT					(DMC_REG_BASE + (0x28 <<2 ))
  // at the test period,  the whole MMC request time.
#define DMC_MON_ALL_GRANT_CNT				(DMC_REG_BASE + (0x29 <<2 ))
  // at the test period,  the whole MMC granted data cycles. 64bits unit.
#define DMC_MON_ONE_GRANT_CNT				(DMC_REG_BASE + (0x2a <<2 ))


#elif (CONFIG_DDR_PHY ==  P_DDR_PHY_GX_TV_BABY)
#define DDR0_PUB_REG_BASE			0xc8836000
#define DDR1_PUB_REG_BASE			0xc8837000
#define  CHANNEL_A_REG_BASE  0
#define  CHANNEL_B_REG_BASE  0x1000
#define P_DDR0_CLK_CTRL   0xc8836c00
#define P_DDR1_CLK_CTRL  0xc8836c00
#define OPEN_CHANNEL_A_PHY_CLK()      (writel((0), 0xc8836c00))
#define OPEN_CHANNEL_B_PHY_CLK()      (writel((0), 0xc8837c00))
#define CLOSE_CHANNEL_A_PHY_CLK()      (writel((0x12a), 0xc8836c00))
#define CLOSE_CHANNEL_B_PHY_CLK()    (writel((0x12a), 0xc8837c00))
//	#define P_ISA_TIMERE                 0xc1109988
//   #define get_us_time()   (readl(P_ISA_TIMERE) )
#define AM_DDR_PLL_CNTL						0xc8836800
#define DDR0_PUB_ZQCR						(DDR0_PUB_REG_BASE+(0x90<<2))
#define DDR0_PUB_ZQ0PR						(DDR0_PUB_REG_BASE+(0x91<<2))
#define DDR0_PUB_ZQ0DR						(DDR0_PUB_REG_BASE+(0x92<<2))
#define DDR1_PUB_ZQCR						(DDR1_PUB_REG_BASE+(0x90<<2))
#define DDR1_PUB_ZQ0PR						(DDR1_PUB_REG_BASE+(0x91<<2))
#define DDR1_PUB_ZQ0DR						(DDR1_PUB_REG_BASE+(0x92<<2))

#define DDR0_PUB_ZQ0SR						(DDR0_PUB_REG_BASE+(0x93<<2))
//0x94 reserved)
#define DDR0_PUB_ZQ1PR						(DDR0_PUB_REG_BASE+(0x95<<2))
#define DDR0_PUB_ZQ1DR						(DDR0_PUB_REG_BASE+(0x96<<2))
#define DDR0_PUB_ZQ1SR						(DDR0_PUB_REG_BASE+(0x97<<2))
//0x98 reserved)
#define DDR0_PUB_ZQ2PR						(DDR0_PUB_REG_BASE+(0x99<<2))
#define DDR0_PUB_ZQ2DR						(DDR0_PUB_REG_BASE+(0x9A<<2))
#define DDR0_PUB_ZQ2SR						(DDR0_PUB_REG_BASE+(0x9B<<2))
//0x9c reserved)
#define DDR0_PUB_ZQ3PR						(DDR0_PUB_REG_BASE+(0x9D<<2))
#define DDR0_PUB_ZQ3DR						(DDR0_PUB_REG_BASE+(0x9E<<2))
#define DDR0_PUB_ZQ3SR						(DDR0_PUB_REG_BASE+(0x9F<<2))
#define ACBDLR_MAX   0X1F
#define ACLCDLR_MAX   0XFF
#define DQBDLR_MAX   0X1F
#define DQLCDLR_MAX   0XFF
#define DXNGTR_MAX   0X7
#define DDR0_PUB_DX0GCR0                           ((0xa0  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX1GCR0                           ((0x0c0  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX2GCR0                           ((0x0e0  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX3GCR0                           ((0x0100  << 2) + DDR0_PUB_REG_BASE)
#define DMC_REG_BASE						0xc8838000
#define DMC_MON_CTRL2						(DMC_REG_BASE + (0x26 <<2 ))
   //bit 31.   qos_mon_en.    write 1 to trigger the enable. polling this bit 0, means finished.  or use interrupt to check finish.
   //bit 30.   qos_mon interrupt clear.  clear the qos monitor result.  read 1 = qos mon finish interrupt.
   //bit 20.   qos_mon_trig_sel.  1 = vsync.  0 = timer.
   //bit 19:16.  qos monitor channel select.   select one at one time only.
   //bit 15:0.   port select for the selected channel.
#define DMC_MON_CTRL3						(DMC_REG_BASE + (0x27 <<2 ))
  // qos_mon_clk_timer.   How long to measure the bandwidth.


#define DMC_MON_ALL_REQ_CNT					(DMC_REG_BASE + (0x28 <<2 ))
  // at the test period,  the whole MMC request time.
#define DMC_MON_ALL_GRANT_CNT				(DMC_REG_BASE + (0x29 <<2 ))
  // at the test period,  the whole MMC granted data cycles. 64bits unit.
#define DMC_MON_ONE_GRANT_CNT				(DMC_REG_BASE + (0x2a <<2 ))
  // at the test period,  the granted data cycles for the selected channel and ports.

#elif (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)

	  // #define P_ISA_TIMERE                 0xc1109988
	 //  #define get_us_time()   (readl(P_ISA_TIMERE) )
#if CONFIG_CHIP   >=CHIP_TXLX
#define DDR0_PUB_REG_BASE			      ((0x0000  << 2) + 0xff636000)//DDR0_PUB_RIDR
#define DDR1_PUB_REG_BASE			    ((0x0000  << 2) + 0xff636000)//DDR0_PUB_RIDR
#define  CHANNEL_A_REG_BASE  0
#define  CHANNEL_B_REG_BASE  0//0x1000
#define MMC_REG_BASE                          ((0x0000  << 2) + 0xff637000)  // #define AM_DDR_PLL_CNTL0                           ((0x0000  << 2) + 0xff637000) 0xc8837000
#define   DDR_CLK_CNTL   (MMC_REG_BASE + ( 0x7	<< 2 ))
#define P_DDR0_CLK_CTRL   DDR_CLK_CNTL
#define P_DDR1_CLK_CTRL  DDR_CLK_CNTL
#define OPEN_CHANNEL_A_PHY_CLK()    //  (writel((0Xb000a000), DDR_CLK_CNTL))
#define OPEN_CHANNEL_B_PHY_CLK()     // (writel((0Xb000a000), DDR_CLK_CNTL))
#define CLOSE_CHANNEL_A_PHY_CLK()   //  (writel((0Xb000a005), DDR_CLK_CNTL))
#define CLOSE_CHANNEL_B_PHY_CLK()    // (writel((0Xb000a005), DDR_CLK_CNTL))

#define AM_DDR_PLL_CNTL0     	       (MMC_REG_BASE + ( 0x0	<< 2 ))
#define AM_DDR_PLL_CNTL						AM_DDR_PLL_CNTL0
#define  DDR0_PUB_ZQCR               (DDR0_PUB_REG_BASE + ( 0x1a0 << 2 ))
#define  DDR0_PUB_ZQ0PR              (DDR0_PUB_REG_BASE + ( 0x1a1 << 2 ))
#define  DDR0_PUB_ZQ0DR              (DDR0_PUB_REG_BASE + ( 0x1a2 << 2 ))
#define  DDR0_PUB_ZQ0SR             ( DDR0_PUB_REG_BASE + ( 0x1a3 << 2 ))

#define  DDR0_PUB_ZQ1PR              (DDR0_PUB_REG_BASE + ( 0x1a5 << 2 ))
#define  DDR0_PUB_ZQ1DR              (DDR0_PUB_REG_BASE + ( 0x1a6 << 2 ))
#define  DDR0_PUB_ZQ1SR              (DDR0_PUB_REG_BASE + ( 0x1a7 << 2 ))

#define  DDR0_PUB_ZQ2PR             ( DDR0_PUB_REG_BASE + ( 0x1a9 << 2 ))
#define  DDR0_PUB_ZQ2DR              (DDR0_PUB_REG_BASE + ( 0x1aA << 2 ))
#define  DDR0_PUB_ZQ2SR             ( DDR0_PUB_REG_BASE + ( 0x1aB << 2 ))

#define DDR0_PUB_DX0GCR0                           ((0x01c0  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX1GCR0                           ((0x0200  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX2GCR0                           ((0x0240  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX3GCR0                           ((0x0280  << 2) + DDR0_PUB_REG_BASE)

#define DDR1_PUB_ZQCR					DDR0_PUB_ZQ0PR
#define DDR1_PUB_ZQ0PR					DDR0_PUB_ZQ0PR
#define DDR1_PUB_ZQ0DR					DDR0_PUB_ZQ0DR

#define ACBDLR_MAX   0X3F
#define ACLCDLR_MAX   0X1FF
#define DQBDLR_MAX   0X3F
#define DQLCDLR_MAX   0X1FF
#define DXNGTR_MAX   0X1F

     //     #define DMC_REG_BASE						MMC_REG_BASE

#define DMC_MON_CTRL2						(DMC_REG_BASE + (0x26 <<2 ))
   //bit 31.   qos_mon_en.    write 1 to trigger the enable. polling this bit 0, means finished.  or use interrupt to check finish.
   //bit 30.   qos_mon interrupt clear.  clear the qos monitor result.  read 1 = qos mon finish interrupt.
   //bit 20.   qos_mon_trig_sel.  1 = vsync.  0 = timer.
   //bit 19:16.  qos monitor channel select.   select one at one time only.
   //bit 15:0.   port select for the selected channel.
#define DMC_MON_CTRL3						(DMC_REG_BASE + (0x27 <<2 ))
// qos_mon_clk_timer.   How long to measure the bandwidth.


#define DMC_MON_ALL_REQ_CNT					(DMC_REG_BASE + (0x28 <<2 ))
  // at the test period,  the whole MMC request time.
#define DMC_MON_ALL_GRANT_CNT				(DMC_REG_BASE + (0x29 <<2 ))
  // at the test period,  the whole MMC granted data cycles. 64bits unit.
#define DMC_MON_ONE_GRANT_CNT				(DMC_REG_BASE + (0x2a <<2 ))
  // at the test period,  the granted data cycles for the selected channel and ports.

#else
#define DDR0_PUB_REG_BASE			0xc8836000
#define DDR1_PUB_REG_BASE			0xc8836000
#define  CHANNEL_A_REG_BASE  0
#define  CHANNEL_B_REG_BASE  0//0x1000
#define MMC_REG_BASE   0xc8837000
#define   DDR_CLK_CNTL   (MMC_REG_BASE + ( 0x7	<< 2 ))
#define P_DDR0_CLK_CTRL   DDR_CLK_CNTL
#define P_DDR1_CLK_CTRL  DDR_CLK_CNTL
#define OPEN_CHANNEL_A_PHY_CLK()    //  (writel((0Xb000a000), DDR_CLK_CNTL))
#define OPEN_CHANNEL_B_PHY_CLK()    //  (writel((0Xb000a000), DDR_CLK_CNTL))
#define CLOSE_CHANNEL_A_PHY_CLK()  //   (writel((0Xb000a005), DDR_CLK_CNTL))
#define CLOSE_CHANNEL_B_PHY_CLK()   //  (writel((0Xb000a005), DDR_CLK_CNTL))

#define AM_DDR_PLL_CNTL0     	       (MMC_REG_BASE + ( 0x0	<< 2 ))
#define AM_DDR_PLL_CNTL						AM_DDR_PLL_CNTL0
#define  DDR0_PUB_ZQCR               (DDR0_PUB_REG_BASE + ( 0x1a0 << 2 ))
#define  DDR0_PUB_ZQ0PR              (DDR0_PUB_REG_BASE + ( 0x1a1 << 2 ))
#define  DDR0_PUB_ZQ0DR              (DDR0_PUB_REG_BASE + ( 0x1a2 << 2 ))
#define  DDR0_PUB_ZQ0SR             ( DDR0_PUB_REG_BASE + ( 0x1a3 << 2 ))

#define  DDR0_PUB_ZQ1PR              (DDR0_PUB_REG_BASE + ( 0x1a5 << 2 ))
#define  DDR0_PUB_ZQ1DR              (DDR0_PUB_REG_BASE + ( 0x1a6 << 2 ))
#define  DDR0_PUB_ZQ1SR              (DDR0_PUB_REG_BASE + ( 0x1a7 << 2 ))

#define  DDR0_PUB_ZQ2PR             ( DDR0_PUB_REG_BASE + ( 0x1a9 << 2 ))
#define  DDR0_PUB_ZQ2DR              (DDR0_PUB_REG_BASE + ( 0x1aA << 2 ))
#define  DDR0_PUB_ZQ2SR             ( DDR0_PUB_REG_BASE + ( 0x1aB << 2 ))

#define DDR1_PUB_ZQCR					DDR0_PUB_ZQ0PR
#define DDR1_PUB_ZQ0PR					DDR0_PUB_ZQ0PR
#define DDR1_PUB_ZQ0DR					DDR0_PUB_ZQ0DR

#define ACBDLR_MAX   0X3F
#define ACLCDLR_MAX   0X1FF
#define DQBDLR_MAX   0X3F
#define DQLCDLR_MAX   0X1FF
#define DXNGTR_MAX   0X1F
#define DDR0_PUB_DX0GCR0                           ((0x1c0  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX1GCR0                           ((0x200  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX2GCR0                           ((0x240  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX3GCR0                           ((0x0280  << 2) + DDR0_PUB_REG_BASE)
#ifndef  DMC_REG_BASE
#define DMC_REG_BASE						MMC_REG_BASE
#endif
#define DMC_MON_CTRL2						(DMC_REG_BASE + (0x26 <<2 ))
//bit 31.   qos_mon_en.    write 1 to trigger the enable. polling this bit 0, means finished.  or use interrupt to check finish.
//bit 30.   qos_mon interrupt clear.  clear the qos monitor result.  read 1 = qos mon finish interrupt.
//bit 20.   qos_mon_trig_sel.  1 = vsync.  0 = timer.
//bit 19:16.  qos monitor channel select.   select one at one time only.
//bit 15:0.   port select for the selected channel.
#define DMC_MON_CTRL3						(DMC_REG_BASE + (0x27 <<2 ))
// qos_mon_clk_timer.   How long to measure the bandwidth.

#define DMC_MON_ALL_REQ_CNT					(DMC_REG_BASE + (0x28 <<2 ))
// at the test period,  the whole MMC request time.
#define DMC_MON_ALL_GRANT_CNT				(DMC_REG_BASE + (0x29 <<2 ))
// at the test period,  the whole MMC granted data cycles. 64bits unit.
#define DMC_MON_ONE_GRANT_CNT				(DMC_REG_BASE + (0x2a <<2 ))
// at the test period,  the granted data cycles for the selected channel and ports.
#endif 

#elif (CONFIG_DDR_PHY ==  P_DDR_PHY_DEFAULT)

#define DDR0_PUB_REG_BASE			0xc8001000		//0xc8836000
#define DDR1_PUB_REG_BASE			0xc8001000		//	0xc8836000
#define  CHANNEL_A_REG_BASE  0
#define  CHANNEL_B_REG_BASE  0x2000
#define P_DDR0_CLK_CTRL   0xc8000800
#define P_DDR1_CLK_CTRL  0xc8002800
#define OPEN_CHANNEL_A_PHY_CLK()      (writel((0x12b), 0xc8000800))
#define OPEN_CHANNEL_B_PHY_CLK()      (writel((0x12b), 0xc8002800))
#define CLOSE_CHANNEL_A_PHY_CLK()      (writel((0x12a), 0xc8000800))
#define CLOSE_CHANNEL_B_PHY_CLK()      (writel((0x12a), 0xc8002800))
//	#define P_ISA_TIMERE                 0xc1109988
//   #define get_us_time()   (readl(P_ISA_TIMERE))

#define PREG_STICKY_REG0  0xc1100000+(0x207c<<2)
#define PREG_STICKY_REG1             0xc1100000+(0x207d<<2)
#define WATCHDOG_TC                           0xc1100000+(0x2640<<2)//     0x2640

#define AM_DDR_PLL_CNTL  0xc8000400
#define DDR0_PUB_ZQCR						(DDR0_PUB_REG_BASE+(0x90<<2))
#define DDR0_PUB_ZQ0PR						(DDR0_PUB_REG_BASE+(0x91<<2))
#define DDR0_PUB_ZQ0DR						(DDR0_PUB_REG_BASE+(0x92<<2))
#define DDR0_PUB_ZQ1PR						(DDR0_PUB_REG_BASE+(0x91<<2))
#define DDR0_PUB_ZQ1DR						(DDR0_PUB_REG_BASE+(0x92<<2))
#define DDR0_PUB_ZQ2PR						(DDR0_PUB_REG_BASE+(0x91<<2))
#define DDR0_PUB_ZQ2DR						(DDR0_PUB_REG_BASE+(0x92<<2))
#define DDR1_PUB_ZQCR						(DDR1_PUB_REG_BASE+(0x90<<2))
#define DDR1_PUB_ZQ0PR						(DDR1_PUB_REG_BASE+(0x91<<2))
#define DDR1_PUB_ZQ0DR						(DDR1_PUB_REG_BASE+(0x92<<2))
#define ACBDLR_MAX   0X1F
#define ACLCDLR_MAX   0XFF
#define DQBDLR_MAX   0X1F
#define DQLCDLR_MAX   0XFF
#define DXNGTR_MAX   0X7
#define DDR0_PUB_DX0GCR0                           ((0xa0  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX1GCR0                           ((0x0c0  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX2GCR0                           ((0x0e0  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX3GCR0                           ((0x0100  << 2) + DDR0_PUB_REG_BASE)
#define DMC_REG_BASE      0xc8006000
#define DMC_MON_CTRL2						(DMC_REG_BASE + (0x26 <<2 ))
//bit 31.   qos_mon_en.    write 1 to trigger the enable. polling this bit 0, means finished.  or use interrupt to check finish.
//bit 30.   qos_mon interrupt clear.  clear the qos monitor result.  read 1 = qos mon finish interrupt.
//bit 20.   qos_mon_trig_sel.  1 = vsync.  0 = timer.
//bit 19:16.  qos monitor channel select.   select one at one time only.
//bit 15:0.   port select for the selected channel.
#define DMC_MON_CTRL3						(DMC_REG_BASE + (0x27 <<2 ))
// qos_mon_clk_timer.   How long to measure the bandwidth.

#define DMC_MON_ALL_REQ_CNT					(DMC_REG_BASE + (0x28 <<2 ))
// at the test period,  the whole MMC request time.
#define DMC_MON_ALL_GRANT_CNT				(DMC_REG_BASE + (0x29 <<2 ))
// at the test period,  the whole MMC granted data cycles. 64bits unit.
#define DMC_MON_ONE_GRANT_CNT				(DMC_REG_BASE + (0x2a <<2 ))
// at the test period,  the granted data cycles for the selected channel and ports.



#elif (CONFIG_DDR_PHY ==  P_DDR_PHY_G12)
#define DDR0_PUB_REG_BASE			0xff636000
#define DDR1_PUB_REG_BASE			0xff636000
#define  CHANNEL_A_REG_BASE  0
#define  CHANNEL_B_REG_BASE  0//0x1000
#define MMC_REG_BASE   0xff637000
#define   DDR_CLK_CNTL   (MMC_REG_BASE + ( 0x7	<< 2 ))
#define P_DDR0_CLK_CTRL   DDR_CLK_CNTL
#define P_DDR1_CLK_CTRL  DDR_CLK_CNTL
#define OPEN_CHANNEL_A_PHY_CLK()    //  (writel((0Xb000a000), DDR_CLK_CNTL))
#define OPEN_CHANNEL_B_PHY_CLK()    //  (writel((0Xb000a000), DDR_CLK_CNTL))
#define CLOSE_CHANNEL_A_PHY_CLK()  //   (writel((0Xb000a005), DDR_CLK_CNTL))
#define CLOSE_CHANNEL_B_PHY_CLK()   //  (writel((0Xb000a005), DDR_CLK_CNTL))

#define AM_DDR_PLL_CNTL0     	       (MMC_REG_BASE + ( 0x0	<< 2 ))
#define AM_DDR_PLL_CNTL						AM_DDR_PLL_CNTL0
#define  DDR0_PUB_ZQCR               (DDR0_PUB_REG_BASE + ( 0x1a0 << 2 ))
#define  DDR0_PUB_ZQ0PR              (DDR0_PUB_REG_BASE + ( 0x1a1 << 2 ))
#define  DDR0_PUB_ZQ0DR              (DDR0_PUB_REG_BASE + ( 0x1a2 << 2 ))
#define  DDR0_PUB_ZQ0SR             ( DDR0_PUB_REG_BASE + ( 0x1a3 << 2 ))

#define  DDR0_PUB_ZQ1PR              (DDR0_PUB_REG_BASE + ( 0x1a5 << 2 ))
#define  DDR0_PUB_ZQ1DR              (DDR0_PUB_REG_BASE + ( 0x1a6 << 2 ))
#define  DDR0_PUB_ZQ1SR              (DDR0_PUB_REG_BASE + ( 0x1a7 << 2 ))

#define  DDR0_PUB_ZQ2PR             ( DDR0_PUB_REG_BASE + ( 0x1a9 << 2 ))
#define  DDR0_PUB_ZQ2DR              (DDR0_PUB_REG_BASE + ( 0x1aA << 2 ))
#define  DDR0_PUB_ZQ2SR             ( DDR0_PUB_REG_BASE + ( 0x1aB << 2 ))

#define DDR1_PUB_ZQCR					DDR0_PUB_ZQ0PR
#define DDR1_PUB_ZQ0PR					DDR0_PUB_ZQ0PR
#define DDR1_PUB_ZQ0DR					DDR0_PUB_ZQ0DR

#define ACBDLR_MAX   0X3F
#define ACLCDLR_MAX   0X1FF
#define DQBDLR_MAX   0X3F
#define DQLCDLR_MAX   0X1FF
#define DXNGTR_MAX   0X1F
#define DDR0_PUB_DX0GCR0                           ((0x1c0  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX1GCR0                           ((0x200  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX2GCR0                           ((0x240  << 2) + DDR0_PUB_REG_BASE)
#define DDR0_PUB_DX3GCR0                           ((0x0280  << 2) + DDR0_PUB_REG_BASE)
#ifndef  DMC_REG_BASE
#define DMC_REG_BASE						MMC_REG_BASE
#endif
#define DMC_MON_CTRL2						(DMC_REG_BASE + (0x26 <<2 ))
//bit 31.   qos_mon_en.    write 1 to trigger the enable. polling this bit 0, means finished.  or use interrupt to check finish.
//bit 30.   qos_mon interrupt clear.  clear the qos monitor result.  read 1 = qos mon finish interrupt.
//bit 20.   qos_mon_trig_sel.  1 = vsync.  0 = timer.
//bit 19:16.  qos monitor channel select.   select one at one time only.
//bit 15:0.   port select for the selected channel.
#define DMC_MON_CTRL3						(DMC_REG_BASE + (0x27 <<2 ))
// qos_mon_clk_timer.   How long to measure the bandwidth.


#define DMC_MON_ALL_REQ_CNT					(DMC_REG_BASE + (0x28 <<2 ))
// at the test period,  the whole MMC request time.
#define DMC_MON_ALL_GRANT_CNT				(DMC_REG_BASE + (0x29 <<2 ))
  // at the test period,  the whole MMC granted data cycles. 64bits unit.
#define DMC_MON_ONE_GRANT_CNT				(DMC_REG_BASE + (0x2a <<2 ))
  // at the test period,  the granted data cycles for the selected channel and ports.
#endif 

#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
#define DDR0_PUB_PIR						(DDR0_PUB_REG_BASE+(0x01<<2))
#define DDR0_PUB_PGCR0         (DDR0_PUB_REG_BASE + ( 0x004 << 2  ))// R/W - PHY General Configuration Register 0
#define DDR0_PUB_PGCR1        ( DDR0_PUB_REG_BASE + ( 0x005 << 2 )) // R/W - PHY General Configuration Register 1
#define DDR0_PUB_PGCR2         (DDR0_PUB_REG_BASE + ( 0x006 << 2 )) // R/W - PHY General Configuration Register 2
#define DDR0_PUB_PGCR3        ( DDR0_PUB_REG_BASE + ( 0x007 << 2 )) // R/W - PHY General Configuration Register 3
#define DDR0_PUB_PGCR4        ( DDR0_PUB_REG_BASE + ( 0x008 << 2 )) // R/W - PHY General Configuration Register 4
#define DDR0_PUB_PGCR5         (DDR0_PUB_REG_BASE + ( 0x009 << 2 )) // R/W - PHY General Configuration Register 5
#define DDR0_PUB_PGCR6         (DDR0_PUB_REG_BASE + ( 0x00A << 2 )) // R/W - PHY General Configuration Register 6
#define DDR0_PUB_PGCR7         (DDR0_PUB_REG_BASE + ( 0x00B << 2 )) // R/W - PHY General Configuration Register 7
#define DDR0_PUB_PGCR8         (DDR0_PUB_REG_BASE + ( 0x00C << 2 )) // R/W - PHY General Configuration Register 8

#define DDR1_PUB_PIR						(DDR1_PUB_REG_BASE+(0x01<<2))
#define DDR1_PUB_PGCR0         (DDR0_PUB_REG_BASE + ( 0x004 << 2 )) // R/W - PHY General Configuration Register 0
#define DDR1_PUB_PGCR1         (DDR0_PUB_REG_BASE + ( 0x005 << 2 )) // R/W - PHY General Configuration Register 1
#define DDR1_PUB_PGCR2        ( DDR0_PUB_REG_BASE + ( 0x006 << 2 )) // R/W - PHY General Configuration Register 2
#define DDR1_PUB_PGCR3         (DDR0_PUB_REG_BASE + ( 0x007 << 2 )) // R/W - PHY General Configuration Register 3
#define DDR1_PUB_PGCR4         (DDR0_PUB_REG_BASE + ( 0x008 << 2 ) )// R/W - PHY General Configuration Register 4
#define DDR1_PUB_PGCR5         (DDR0_PUB_REG_BASE + ( 0x009 << 2 )) // R/W - PHY General Configuration Register 5
#define DDR1_PUB_PGCR6         (DDR0_PUB_REG_BASE + ( 0x00A << 2 )) // R/W - PHY General Configuration Register 6
#define DDR1_PUB_PGCR7         (DDR0_PUB_REG_BASE + ( 0x00B << 2 )) // R/W - PHY General Configuration Register 7
#define DDR1_PUB_PGCR8         (DDR0_PUB_REG_BASE + ( 0x00C << 2 ) )// R/W - PHY General Configuration Register 8

#define DDR0_PUB_DX0BDLR0     (DDR0_PUB_REG_BASE + ( 0x1d0  << 2 ))
#define DDR0_PUB_DX0BDLR1     (DDR0_PUB_REG_BASE + ( 0x1d1  << 2 ))
#define DDR0_PUB_DX0BDLR2    ( DDR0_PUB_REG_BASE + ( 0x1d2  << 2 ))
#define DDR0_PUB_DX0BDLR3     (DDR0_PUB_REG_BASE + ( 0x1d4  << 2 ))
#define DDR0_PUB_DX0BDLR4     (DDR0_PUB_REG_BASE + ( 0x1d5  << 2 ))
#define DDR0_PUB_DX0BDLR5     (DDR0_PUB_REG_BASE + ( 0x1d6  << 2 ))
#define DDR0_PUB_DX0BDLR6     (DDR0_PUB_REG_BASE + ( 0x1d8  << 2 ))
#define DDR0_PUB_DX0LCDLR0    (DDR0_PUB_REG_BASE + ( 0x1e0  << 2 ))
#define DDR0_PUB_DX0LCDLR1    (DDR0_PUB_REG_BASE + ( 0x1e1  << 2 ))
#define DDR0_PUB_DX0LCDLR2    (DDR0_PUB_REG_BASE + ( 0x1e2  << 2 ))
#define DDR0_PUB_DX0LCDLR3    (DDR0_PUB_REG_BASE + ( 0x1e3  << 2 ))
#define DDR0_PUB_DX0LCDLR4    (DDR0_PUB_REG_BASE + ( 0x1e4  << 2 ))
#define DDR0_PUB_DX0LCDLR5    (DDR0_PUB_REG_BASE + ( 0x1e5  << 2 ))
#define DDR0_PUB_DX0MDLR0     (DDR0_PUB_REG_BASE + ( 0x1e8  << 2 ))
#define DDR0_PUB_DX0MDLR1     (DDR0_PUB_REG_BASE + ( 0x1e9  << 2) )
#define DDR0_PUB_DX0GTR0      (DDR0_PUB_REG_BASE + ( 0x1f0  << 2 ))
#define DDR0_PUB_DX0GTR1      (DDR0_PUB_REG_BASE + ( 0x1f1  << 2) )
#define DDR0_PUB_DX0GTR2      (DDR0_PUB_REG_BASE + ( 0x1f2  << 2) )
#define DDR0_PUB_DX0GTR3      (DDR0_PUB_REG_BASE + ( 0x1f3  << 2))

#define DDR0_PUB_DX1BDLR0     (DDR0_PUB_REG_BASE + ( 0x210  << 2) )
#define DDR0_PUB_DX1BDLR1     (DDR0_PUB_REG_BASE + ( 0x211  << 2) )
#define DDR0_PUB_DX1BDLR2     (DDR0_PUB_REG_BASE + ( 0x212  << 2) )
#define DDR0_PUB_DX1BDLR3     (DDR0_PUB_REG_BASE + ( 0x214  << 2) )
#define DDR0_PUB_DX1BDLR4     (DDR0_PUB_REG_BASE + ( 0x215  << 2) )
#define DDR0_PUB_DX1BDLR5    ( DDR0_PUB_REG_BASE + ( 0x216  << 2) )
#define DDR0_PUB_DX1BDLR6    ( DDR0_PUB_REG_BASE + ( 0x218  << 2) )
#define DDR0_PUB_DX1LCDLR0    (DDR0_PUB_REG_BASE + ( 0x220  << 2) )
#define DDR0_PUB_DX1LCDLR1    (DDR0_PUB_REG_BASE + ( 0x221  << 2) )
#define DDR0_PUB_DX1LCDLR2    (DDR0_PUB_REG_BASE + ( 0x222  << 2) )
#define DDR0_PUB_DX1LCDLR3    (DDR0_PUB_REG_BASE + ( 0x223  << 2) )
#define DDR0_PUB_DX1LCDLR4    (DDR0_PUB_REG_BASE + ( 0x224  << 2) )
#define DDR0_PUB_DX1LCDLR5    (DDR0_PUB_REG_BASE + ( 0x225  << 2) )
#define DDR0_PUB_DX1MDLR0     (DDR0_PUB_REG_BASE + ( 0x228  << 2) )
#define DDR0_PUB_DX1MDLR1     (DDR0_PUB_REG_BASE + ( 0x229  << 2) )
#define DDR0_PUB_DX1GTR0      (DDR0_PUB_REG_BASE + ( 0x230  << 2 ))
#define DDR0_PUB_DX1GTR1      (DDR0_PUB_REG_BASE + ( 0x231  << 2) )
#define DDR0_PUB_DX1GTR2      (DDR0_PUB_REG_BASE + ( 0x232  << 2) )
#define DDR0_PUB_DX1GTR3      (DDR0_PUB_REG_BASE + ( 0x233  << 2) )

#define DDR0_PUB_DX2BDLR0     (DDR0_PUB_REG_BASE + ( 0x250  << 2) )
#define DDR0_PUB_DX2BDLR1     (DDR0_PUB_REG_BASE + ( 0x251  << 2) )
#define DDR0_PUB_DX2BDLR2     (DDR0_PUB_REG_BASE + ( 0x252  << 2) )
#define DDR0_PUB_DX2BDLR3     (DDR0_PUB_REG_BASE + ( 0x254  << 2) )
#define DDR0_PUB_DX2BDLR4     (DDR0_PUB_REG_BASE + ( 0x255  << 2) )
#define DDR0_PUB_DX2BDLR5     (DDR0_PUB_REG_BASE + ( 0x256  << 2) )
#define DDR0_PUB_DX2BDLR6     (DDR0_PUB_REG_BASE + ( 0x258  << 2) )
#define DDR0_PUB_DX2LCDLR0   ( DDR0_PUB_REG_BASE + ( 0x260  << 2) )
#define DDR0_PUB_DX2LCDLR1    (DDR0_PUB_REG_BASE + ( 0x261  << 2) )
#define DDR0_PUB_DX2LCDLR2   ( DDR0_PUB_REG_BASE + ( 0x262  << 2) )
#define DDR0_PUB_DX2LCDLR3    (DDR0_PUB_REG_BASE + ( 0x263  << 2) )
#define DDR0_PUB_DX2LCDLR4    (DDR0_PUB_REG_BASE + ( 0x264  << 2) )
#define DDR0_PUB_DX2LCDLR5   ( DDR0_PUB_REG_BASE + ( 0x265  << 2) )
#define DDR0_PUB_DX2MDLR0     (DDR0_PUB_REG_BASE + ( 0x268  << 2) )
#define DDR0_PUB_DX2MDLR1     (DDR0_PUB_REG_BASE + ( 0x269  << 2) )
#define DDR0_PUB_DX2GTR0     ( DDR0_PUB_REG_BASE + ( 0x270  << 2 ))
#define DDR0_PUB_DX2GTR1      (DDR0_PUB_REG_BASE + ( 0x271  << 2) )
#define DDR0_PUB_DX2GTR2      (DDR0_PUB_REG_BASE + ( 0x272  << 2) )
#define DDR0_PUB_DX2GTR3      (DDR0_PUB_REG_BASE + ( 0x273  << 2) )

#define DDR0_PUB_DX3BDLR0     (DDR0_PUB_REG_BASE + ( 0x290  << 2) )
#define DDR0_PUB_DX3BDLR1     (DDR0_PUB_REG_BASE + ( 0x291  << 2) )
#define DDR0_PUB_DX3BDLR2     (DDR0_PUB_REG_BASE + ( 0x292  << 2) )
#define DDR0_PUB_DX3BDLR3     (DDR0_PUB_REG_BASE + ( 0x294  << 2) )
#define DDR0_PUB_DX3BDLR4     (DDR0_PUB_REG_BASE + ( 0x295  << 2) )
#define DDR0_PUB_DX3BDLR5     (DDR0_PUB_REG_BASE + ( 0x296  << 2) )
#define DDR0_PUB_DX3BDLR6     (DDR0_PUB_REG_BASE + ( 0x298  << 2) )
#define DDR0_PUB_DX3LCDLR0    (DDR0_PUB_REG_BASE + ( 0x2a0  << 2) )
#define DDR0_PUB_DX3LCDLR1    (DDR0_PUB_REG_BASE + ( 0x2a1  << 2) )
#define DDR0_PUB_DX3LCDLR2    (DDR0_PUB_REG_BASE + ( 0x2a2  << 2) )
#define DDR0_PUB_DX3LCDLR3    (DDR0_PUB_REG_BASE + ( 0x2a3  << 2) )
#define DDR0_PUB_DX3LCDLR4    (DDR0_PUB_REG_BASE + ( 0x2a4  << 2) )
#define DDR0_PUB_DX3LCDLR5    (DDR0_PUB_REG_BASE + ( 0x2a5  << 2) )
#define DDR0_PUB_DX3MDLR0     (DDR0_PUB_REG_BASE + ( 0x2a8  << 2) )
#define DDR0_PUB_DX3MDLR1     (DDR0_PUB_REG_BASE + ( 0x2a9  << 2) )
#define DDR0_PUB_DX3GTR0      (DDR0_PUB_REG_BASE + ( 0x2b0  << 2 ))
#define DDR0_PUB_DX3GTR1     ( DDR0_PUB_REG_BASE + ( 0x2b1  << 2) )
#define DDR0_PUB_DX3GTR2    (  DDR0_PUB_REG_BASE + ( 0x2b2  << 2) )
#define DDR0_PUB_DX3GTR3    (  DDR0_PUB_REG_BASE + ( 0x2b3  << 2) )

#define DDR1_PUB_DX0BDLR0 (	DDR0_PUB_REG_BASE + ( 0x1d0  << 2) )
#define DDR1_PUB_DX0BDLR1 (	DDR0_PUB_REG_BASE + ( 0x1d1  << 2) )
#define DDR1_PUB_DX0BDLR2	(DDR0_PUB_REG_BASE + ( 0x1d2  << 2 ))
#define DDR1_PUB_DX0BDLR3	(DDR0_PUB_REG_BASE + ( 0x1d4  << 2 ))
#define DDR1_PUB_DX0BDLR4	(DDR0_PUB_REG_BASE + ( 0x1d5  << 2) )
#define DDR1_PUB_DX0BDLR5	(DDR0_PUB_REG_BASE + ( 0x1d6  << 2) )
#define DDR1_PUB_DX0BDLR6	(DDR0_PUB_REG_BASE + ( 0x1d8  << 2) )
#define DDR1_PUB_DX0LCDLR0  (	DDR0_PUB_REG_BASE + ( 0x1e0  << 2) )
#define DDR1_PUB_DX0LCDLR1	  (DDR0_PUB_REG_BASE + ( 0x1e1  << 2 ))
#define DDR1_PUB_DX0LCDLR2  (	DDR0_PUB_REG_BASE + ( 0x1e2  << 2) )
#define DDR1_PUB_DX0LCDLR3	  (DDR0_PUB_REG_BASE + ( 0x1e3  << 2 ))
#define DDR1_PUB_DX0LCDLR4  (	DDR0_PUB_REG_BASE + ( 0x1e4  << 2) )
#define DDR1_PUB_DX0LCDLR5	  (DDR0_PUB_REG_BASE + ( 0x1e5  << 2 ))
#define DDR1_PUB_DX0MDLR0	  (DDR0_PUB_REG_BASE + ( 0x1e8  << 2 ))
#define DDR1_PUB_DX0MDLR1	 (DDR0_PUB_REG_BASE + ( 0x1e9  << 2 ))
#define DDR1_PUB_DX0GTR0	(DDR0_PUB_REG_BASE + ( 0x1f0  << 2 ))
#define DDR1_PUB_DX0GTR1	(DDR0_PUB_REG_BASE + ( 0x1f1  << 2) )
#define DDR1_PUB_DX0GTR2	(DDR0_PUB_REG_BASE + ( 0x1f2  << 2) )
#define DDR1_PUB_DX0GTR3	(DDR0_PUB_REG_BASE + ( 0x1f3  << 2))

#define DDR1_PUB_DX1BDLR0	(DDR0_PUB_REG_BASE + ( 0x210  << 2 ))
#define DDR1_PUB_DX1BDLR1	(DDR0_PUB_REG_BASE + ( 0x211  << 2 ))
#define DDR1_PUB_DX1BDLR2	(DDR0_PUB_REG_BASE + ( 0x212  << 2 ))
#define DDR1_PUB_DX1BDLR3	(DDR0_PUB_REG_BASE + ( 0x214  << 2 ))
#define DDR1_PUB_DX1BDLR4	(DDR0_PUB_REG_BASE + ( 0x215  << 2 ))
#define DDR1_PUB_DX1BDLR5	(DDR0_PUB_REG_BASE + ( 0x216  << 2 ))
#define DDR1_PUB_DX1BDLR6	(DDR0_PUB_REG_BASE + ( 0x218  << 2 ))
#define DDR1_PUB_DX1LCDLR0	 (DDR0_PUB_REG_BASE + ( 0x220  << 2 ))
#define DDR1_PUB_DX1LCDLR1	 (DDR0_PUB_REG_BASE + ( 0x221  << 2 ))
#define DDR1_PUB_DX1LCDLR2 (	DDR0_PUB_REG_BASE + ( 0x222  << 2 ))
#define DDR1_PUB_DX1LCDLR3	 (DDR0_PUB_REG_BASE + ( 0x223  << 2 ))
#define DDR1_PUB_DX1LCDLR4 (	DDR0_PUB_REG_BASE + ( 0x224  << 2 ))
#define DDR1_PUB_DX1LCDLR5	 (DDR0_PUB_REG_BASE + ( 0x225  << 2 ))
#define DDR1_PUB_DX1MDLR0	 (DDR0_PUB_REG_BASE + ( 0x228  << 2 ))
#define DDR1_PUB_DX1MDLR1	 (DDR0_PUB_REG_BASE + ( 0x229  << 2 ))
#define DDR1_PUB_DX1GTR0	(DDR0_PUB_REG_BASE + ( 0x230  << 2 ))
#define DDR1_PUB_DX1GTR1	(DDR0_PUB_REG_BASE + ( 0x231  << 2 ))
#define DDR1_PUB_DX1GTR2	(DDR0_PUB_REG_BASE + ( 0x232  << 2 ))
#define DDR1_PUB_DX1GTR3	(DDR0_PUB_REG_BASE + ( 0x233  << 2 ))

#define DDR1_PUB_DX2BDLR0	(DDR0_PUB_REG_BASE + ( 0x250  << 2 ))
#define DDR1_PUB_DX2BDLR1	(DDR0_PUB_REG_BASE + ( 0x251  << 2 ))
#define DDR1_PUB_DX2BDLR2	(DDR0_PUB_REG_BASE + ( 0x252  << 2 ))
#define DDR1_PUB_DX2BDLR3	(DDR0_PUB_REG_BASE + ( 0x254  << 2 ))
#define DDR1_PUB_DX2BDLR4	(DDR0_PUB_REG_BASE + ( 0x255  << 2 ))
#define DDR1_PUB_DX2BDLR5	(DDR0_PUB_REG_BASE + ( 0x256  << 2 ))
#define DDR1_PUB_DX2BDLR6	(DDR0_PUB_REG_BASE + ( 0x258  << 2 ))
#define DDR1_PUB_DX2LCDLR0	 (DDR0_PUB_REG_BASE + ( 0x260  << 2 ))
#define DDR1_PUB_DX2LCDLR1	 (DDR0_PUB_REG_BASE + ( 0x261  << 2 ))
#define DDR1_PUB_DX2LCDLR2 (	DDR0_PUB_REG_BASE + ( 0x262  << 2 ))
#define DDR1_PUB_DX2LCDLR3	 (DDR0_PUB_REG_BASE + ( 0x263  << 2 ))
#define DDR1_PUB_DX2LCDLR4	 (DDR0_PUB_REG_BASE + ( 0x264  << 2 ))
#define DDR1_PUB_DX2LCDLR5	 (DDR0_PUB_REG_BASE + ( 0x265  << 2 ))
#define DDR1_PUB_DX2MDLR0	 (DDR0_PUB_REG_BASE + ( 0x268  << 2 ))
#define DDR1_PUB_DX2MDLR1	 (DDR0_PUB_REG_BASE + ( 0x269  << 2 ))
#define DDR1_PUB_DX2GTR0	(DDR0_PUB_REG_BASE + ( 0x270  << 2 ))
#define DDR1_PUB_DX2GTR1	(DDR0_PUB_REG_BASE + ( 0x271  << 2 ))
#define DDR1_PUB_DX2GTR2	(DDR0_PUB_REG_BASE + ( 0x272  << 2 ))
#define DDR1_PUB_DX2GTR3	(DDR0_PUB_REG_BASE + ( 0x273  << 2 ))

#define DDR1_PUB_DX3BDLR0	(DDR0_PUB_REG_BASE + ( 0x290  << 2 ))
#define DDR1_PUB_DX3BDLR1	(DDR0_PUB_REG_BASE + ( 0x291  << 2 ))
#define DDR1_PUB_DX3BDLR2	(DDR0_PUB_REG_BASE + ( 0x292  << 2 ))
#define DDR1_PUB_DX3BDLR3	(DDR0_PUB_REG_BASE + ( 0x294  << 2 ))
#define DDR1_PUB_DX3BDLR4	(DDR0_PUB_REG_BASE + ( 0x295  << 2 ))
#define DDR1_PUB_DX3BDLR5	(DDR0_PUB_REG_BASE + ( 0x296  << 2 ))
#define DDR1_PUB_DX3BDLR6	(DDR0_PUB_REG_BASE + ( 0x298  << 2 ))
#define DDR1_PUB_DX3LCDLR0	 (DDR0_PUB_REG_BASE + ( 0x2a0  << 2 ))
#define DDR1_PUB_DX3LCDLR1	 (DDR0_PUB_REG_BASE + ( 0x2a1  << 2 ))
#define DDR1_PUB_DX3LCDLR2 (	DDR0_PUB_REG_BASE + ( 0x2a2  << 2 ))
#define DDR1_PUB_DX3LCDLR3	 (DDR0_PUB_REG_BASE + ( 0x2a3  << 2 ))
#define DDR1_PUB_DX3LCDLR4	 (DDR0_PUB_REG_BASE + ( 0x2a4  << 2 ))
#define DDR1_PUB_DX3LCDLR5 (	DDR0_PUB_REG_BASE + ( 0x2a5  << 2 ))
#define DDR1_PUB_DX3MDLR0	 (DDR0_PUB_REG_BASE + ( 0x2a8  << 2 ))
#define DDR1_PUB_DX3MDLR1	(DDR0_PUB_REG_BASE + ( 0x2a9  << 2 ))
#define DDR1_PUB_DX3GTR0	(DDR0_PUB_REG_BASE + ( 0x2b0  << 2 ))
#define DDR1_PUB_DX3GTR1	(DDR0_PUB_REG_BASE + ( 0x2b1  << 2 ))
#define DDR1_PUB_DX3GTR2	(DDR0_PUB_REG_BASE + ( 0x2b2  << 2 ))
#define DDR1_PUB_DX3GTR3	(DDR0_PUB_REG_BASE + ( 0x2b3  << 2 ))


#define DDR0_PUB_ACLCDLR       (DDR0_PUB_REG_BASE + ( 0x160 << 2 )) // R/W - LC Delay Line Present Register
#define DDR0_PUB_ACMDLR0      ( DDR0_PUB_REG_BASE + ( 0x168 << 2 )) // R/W - AC Master Delay Line Register 0
#define DDR0_PUB_ACMDLR1     (  DDR0_PUB_REG_BASE + ( 0x169 << 2 )) // R/W - Master Delay Line Register 1
#define DDR0_PUB_ACBDLR0       (DDR0_PUB_REG_BASE + ( 0x150 << 2 )) // R/W - AC Bit Delay Line Register 0
#define DDR0_PUB_ACBDLR3       ( DDR0_PUB_REG_BASE + ( 0x153 << 2 ) ) // R/W - AC Bit Delay Line Register 3

#define DDR1_PUB_ACLCDLR       (DDR0_PUB_REG_BASE + ( 0x160 << 2 ) )// R/W - LC Delay Line Present Register
#define DDR1_PUB_ACMDLR0      ( DDR0_PUB_REG_BASE + ( 0x168 << 2 )) // R/W - AC Master Delay Line Register 0
#define DDR1_PUB_ACMDLR1      ( DDR0_PUB_REG_BASE + ( 0x169 << 2 )) // R/W - Master Delay Line Register 1
#define DDR1_PUB_ACBDLR0      ( DDR0_PUB_REG_BASE + ( 0x150 << 2 ) )// R/W - AC Bit Delay Line Register 0


#define DDR0_PUB_ACMDLR					DDR0_PUB_ACMDLR0
#define DDR1_PUB_ACMDLR					DDR1_PUB_ACMDLR0
#define DDR0_PUB_DX0GTR	                            DDR0_PUB_DX0GTR0
#define DDR0_PUB_DX1GTR	                            DDR0_PUB_DX1GTR0
#define DDR0_PUB_DX2GTR	                            DDR0_PUB_DX2GTR0
#define DDR0_PUB_DX3GTR	                            DDR0_PUB_DX3GTR0
#define DDR1_PUB_DX0GTR	                            DDR0_PUB_DX0GTR0
#define DDR1_PUB_DX1GTR	                            DDR0_PUB_DX1GTR0
#define DDR1_PUB_DX2GTR	                            DDR0_PUB_DX2GTR0
#define DDR1_PUB_DX3GTR	                            DDR0_PUB_DX3GTR0


#define DDR0_PUB_IOVCR0       (  DDR0_PUB_REG_BASE + ( 0x148 << 2 )) // R/W - IO VREF Control Register 0
#define DDR0_PUB_IOVCR1      (   DDR0_PUB_REG_BASE + ( 0x149 << 2 )) // R/W - IO VREF Control Register 1
#define DDR0_PUB_VTCR0        (  DDR0_PUB_REG_BASE + ( 0x14A << 2 ) )// R/W - VREF Training Control Register 0
#define DDR0_PUB_VTCR1        (  DDR0_PUB_REG_BASE + ( 0x14B << 2 )) // R/W - VREF Training Control Register 1
#define DDR1_PUB_IOVCR0     (    DDR0_PUB_REG_BASE + ( 0x148 << 2 )) // R/W - IO VREF Control Register 0
#define DDR1_PUB_IOVCR1      (   DDR0_PUB_REG_BASE + ( 0x149 << 2 )) // R/W - IO VREF Control Register 1
#define DDR1_PUB_VTCR0        (  DDR0_PUB_REG_BASE + ( 0x14A << 2 )) // R/W - VREF Training Control Register 0
#define DDR1_PUB_VTCR1        (  DDR0_PUB_REG_BASE + ( 0x14B << 2 )) // R/W - VREF Training Control Register 1

//#define DDR0_PUB_MR6           ( DDR0_PUB_REG_BASE + ( 0x066 << 2 ) ) // R/W - Extended Mode Register 6
//#define DDR1_PUB_MR6           ( DDR0_PUB_REG_BASE + ( 0x066 << 2 ) ) // R/W - Extended Mode Register 6
#define DDR0_PUB_DX0GCR6      ( DDR0_PUB_REG_BASE + ( 0x1c6  << 2 ) )
#define DDR0_PUB_DX1GCR6      ( DDR0_PUB_REG_BASE + ( 0x206  << 2 ) )
#define DDR0_PUB_DX2GCR6      ( DDR0_PUB_REG_BASE + ( 0x246  << 2 ) )
#define DDR0_PUB_DX3GCR6      ( DDR0_PUB_REG_BASE + ( 0x286  << 2 ) )
#define DDR0_PUB_DCR           ( DDR0_PUB_REG_BASE + ( 0x040 << 2 ) ) // R/W - DRAM Configuration Register
#define DDR0_PUB_MR0           ( DDR0_PUB_REG_BASE + ( 0x060 << 2 ) ) // R/W - Mode Register
#define DDR0_PUB_MR1           ( DDR0_PUB_REG_BASE + ( 0x061 << 2 ) ) // R/W - Extended Mode Register
#define DDR0_PUB_MR2           ( DDR0_PUB_REG_BASE + ( 0x062 << 2 ) ) // R/W - Extended Mode Register 2
#define DDR0_PUB_MR3           ( DDR0_PUB_REG_BASE + ( 0x063 << 2 ) ) // R/W - Extended Mode Register 3
#define DDR0_PUB_MR4           ( DDR0_PUB_REG_BASE + ( 0x064 << 2 ) ) // R/W - Extended Mode Register 4
#define DDR0_PUB_MR5           ( DDR0_PUB_REG_BASE + ( 0x065 << 2 ) ) // R/W - Extended Mode Register 5
#define DDR0_PUB_MR6           ( DDR0_PUB_REG_BASE + ( 0x066 << 2 ) ) // R/W - Extended Mode Register 6
#define DDR0_PUB_MR7           ( DDR0_PUB_REG_BASE + ( 0x067 << 2 ) ) // R/W - Extended Mode Register 7
#define DDR0_PUB_MR11          ( DDR0_PUB_REG_BASE + ( 0x06B << 2 ) ) // R/W - Extended Mode Register 11
#define DDR0_PUB_RANKIDR       ( DDR0_PUB_REG_BASE + ( 0x137 << 2 ) ) // R/W - Rank ID Register
#define DDR0_PUB_DTCR0         ( DDR0_PUB_REG_BASE + ( 0x080 << 2 ) ) // R/W - Data Training Configuration Register
#define DDR0_PUB_DTEDR0        ( DDR0_PUB_REG_BASE + ( 0x08C << 2 ) ) // R/W - Data Training Eye Data Register 0
#define DDR0_PUB_DTEDR1        ( DDR0_PUB_REG_BASE + ( 0x08D << 2 ) ) // R/W - Data Training Eye Data Register 1
#define DDR0_PUB_DTEDR2        ( DDR0_PUB_REG_BASE + ( 0x08E << 2 ) ) // R/W - Data Training Eye Data Register 2
#define DDR0_PUB_VTDR          ( DDR0_PUB_REG_BASE + ( 0x08F << 2 ) ) // R/W - Vref Training Data Register
#else

#define DDR0_PUB_PIR						(DDR0_PUB_REG_BASE+(0x01<<2))
#define DDR0_PUB_PGCR0						(DDR0_PUB_REG_BASE+(0x02<<2))
#define DDR0_PUB_PGCR1						(DDR0_PUB_REG_BASE+(0x03<<2))

#define DDR1_PUB_PIR						(DDR1_PUB_REG_BASE+(0x01<<2))
#define DDR1_PUB_PGCR0						(DDR1_PUB_REG_BASE+(0x02<<2))
#define DDR1_PUB_PGCR1						(DDR1_PUB_REG_BASE+(0x03<<2))

#define  DDR0_PUB_DX0BDLR0   (DDR0_PUB_REG_BASE+(0xA7<<2))
#define  DDR0_PUB_DX1BDLR0    (DDR0_PUB_REG_BASE+(0xC7<<2))
#define  DDR0_PUB_DX2BDLR0   (DDR0_PUB_REG_BASE+(0xE7<<2))
#define  DDR0_PUB_DX3BDLR0    (DDR0_PUB_REG_BASE+(0x107<<2))

#define DDR0_PUB_DX0BDLR1					(DDR0_PUB_REG_BASE+(0xA8<<2))
#define DDR0_PUB_DX0BDLR2					(DDR0_PUB_REG_BASE+(0xA9<<2))
#define DDR0_PUB_DX0BDLR3					(DDR0_PUB_REG_BASE+(0xAA<<2))
#define DDR0_PUB_DX0BDLR4					(DDR0_PUB_REG_BASE+(0xAB<<2))
#define DDR0_PUB_DX0BDLR5					(DDR0_PUB_REG_BASE+(0xAC<<2))
#define DDR0_PUB_DX0BDLR6					(DDR0_PUB_REG_BASE+(0xAD<<2))

#define DDR0_PUB_DX0LCDLR0					(DDR0_PUB_REG_BASE+(0xAE<<2))
#define DDR0_PUB_DX0LCDLR1					(DDR0_PUB_REG_BASE+(0xAF<<2))
#define DDR0_PUB_DX0LCDLR2					(DDR0_PUB_REG_BASE+(0xB0<<2))
#define DDR0_PUB_DX0MDLR					(DDR0_PUB_REG_BASE+(0xB1<<2))
#define DDR0_PUB_DX0GTR						(DDR0_PUB_REG_BASE+(0xB2<<2))
#define DDR0_PUB_DX1LCDLR0					(DDR0_PUB_REG_BASE+(0xCE<<2))
#define DDR0_PUB_DX1LCDLR1					(DDR0_PUB_REG_BASE+(0xCF<<2))
#define DDR0_PUB_DX1LCDLR2					(DDR0_PUB_REG_BASE+(0xD0<<2))
#define DDR0_PUB_DX1MDLR					(DDR0_PUB_REG_BASE+(0xD1<<2))
#define DDR0_PUB_DX1GTR						(DDR0_PUB_REG_BASE+(0xD2<<2))
#define DDR0_PUB_DX2LCDLR0					(DDR0_PUB_REG_BASE+(0xEE<<2))
#define DDR0_PUB_DX2LCDLR1					(DDR0_PUB_REG_BASE+(0xEF<<2))
#define DDR0_PUB_DX2LCDLR2					(DDR0_PUB_REG_BASE+(0xF0<<2))
#define DDR0_PUB_DX2MDLR					(DDR0_PUB_REG_BASE+(0xF1<<2))
#define DDR0_PUB_DX3LCDLR0					(DDR0_PUB_REG_BASE+(0x10E<<2))
#define DDR0_PUB_DX3LCDLR1					(DDR0_PUB_REG_BASE+(0x10F<<2))
#define DDR0_PUB_DX3LCDLR2					(DDR0_PUB_REG_BASE+(0x110<<2))
#define DDR0_PUB_DX3MDLR					(DDR0_PUB_REG_BASE+(0x111<<2))
#define DDR0_PUB_DX3GTR						(DDR0_PUB_REG_BASE+(0x112<<2))

#define DDR1_PUB_DX0LCDLR0					(DDR1_PUB_REG_BASE+(0xAE<<2))
#define DDR1_PUB_DX0LCDLR1					(DDR1_PUB_REG_BASE+(0xAF<<2))
#define DDR1_PUB_DX0LCDLR2					(DDR1_PUB_REG_BASE+(0xB0<<2))
#define DDR1_PUB_DX0MDLR					(DDR1_PUB_REG_BASE+(0xB1<<2))
#define DDR1_PUB_DX0GTR						(DDR1_PUB_REG_BASE+(0xB2<<2))
#define DDR1_PUB_DX1LCDLR0					(DDR1_PUB_REG_BASE+(0xCE<<2))
#define DDR1_PUB_DX1LCDLR1					(DDR1_PUB_REG_BASE+(0xCF<<2))
#define DDR1_PUB_DX1LCDLR2					(DDR1_PUB_REG_BASE+(0xD0<<2))
#define DDR1_PUB_DX1MDLR					(DDR1_PUB_REG_BASE+(0xD1<<2))
#define DDR1_PUB_DX1GTR						(DDR1_PUB_REG_BASE+(0xD2<<2))
#define DDR1_PUB_DX2LCDLR0					(DDR1_PUB_REG_BASE+(0xEE<<2))
#define DDR1_PUB_DX2LCDLR1					(DDR1_PUB_REG_BASE+(0xEF<<2))
#define DDR1_PUB_DX2LCDLR2					(DDR1_PUB_REG_BASE+(0xF0<<2))
#define DDR1_PUB_DX2MDLR					(DDR1_PUB_REG_BASE+(0xF1<<2))
#define DDR1_PUB_DX3LCDLR0					(DDR1_PUB_REG_BASE+(0x10E<<2))
#define DDR1_PUB_DX3LCDLR1					(DDR1_PUB_REG_BASE+(0x10F<<2))
#define DDR1_PUB_DX3LCDLR2					(DDR1_PUB_REG_BASE+(0x110<<2))
#define DDR1_PUB_DX3MDLR					(DDR1_PUB_REG_BASE+(0x111<<2))
#define DDR1_PUB_DX3GTR						(DDR1_PUB_REG_BASE+(0x112<<2))


#define DDR0_PUB_ACMDLR						(DDR0_PUB_REG_BASE+(0x0E<<2))
#define DDR0_PUB_ACLCDLR					(DDR0_PUB_REG_BASE+(0x0F<<2))
#define DDR0_PUB_ACBDLR0					(DDR0_PUB_REG_BASE+(0x10<<2))
#define DDR0_PUB_ACBDLR3					(DDR0_PUB_REG_BASE+(0x13<<2))
#define DDR1_PUB_ACMDLR						(DDR1_PUB_REG_BASE+(0x0E<<2))
#define DDR1_PUB_ACLCDLR					(DDR1_PUB_REG_BASE+(0x0F<<2))
#define DDR1_PUB_ACBDLR0					(DDR1_PUB_REG_BASE+(0x10<<2))

#define DDR0_PUB_ACMDLR0	DDR0_PUB_ACMDLR
#define DDR1_PUB_ACMDLR0	DDR1_PUB_ACMDLR
#define DDR0_PUB_DX0MDLR0 DDR0_PUB_DX0MDLR
#define DDR0_PUB_DX1MDLR0 DDR0_PUB_DX1MDLR
#define DDR0_PUB_DX2MDLR0 DDR0_PUB_DX2MDLR
#define DDR0_PUB_DX3MDLR0 DDR0_PUB_DX3MDLR
#define DDR1_PUB_DX0MDLR0 DDR0_PUB_DX0MDLR
#define DDR1_PUB_DX1MDLR0 DDR0_PUB_DX1MDLR
#define DDR1_PUB_DX2MDLR0 DDR0_PUB_DX2MDLR
#define DDR1_PUB_DX3MDLR0 DDR0_PUB_DX3MDLR
#define DDR0_PUB_DCR						(DDR0_PUB_REG_BASE+(0x22<<2))
#define DDR0_PUB_MR0						(DDR0_PUB_REG_BASE+(0x27<<2))
#define DDR0_PUB_MR1						(DDR0_PUB_REG_BASE+(0x28<<2))
#define DDR0_PUB_MR2						(DDR0_PUB_REG_BASE+(0x29<<2))
#define DDR0_PUB_MR3						(DDR0_PUB_REG_BASE+(0x2A<<2))
#define DDR0_PUB_RANKIDR       ( DDR0_PUB_REG_BASE + ( 0x0<< 2 ) ) // R/W - Rank ID Register
#define DDR0_PUB_DTCR0         ( DDR0_PUB_REG_BASE + ( 0<< 2 ) ) // R/W - Data Training Configuration Register
#define DDR0_PUB_DTEDR0        ( DDR0_PUB_REG_BASE + ( 0x0 << 2 ) ) // R/W - Data Training Eye Data Register 0
#define DDR0_PUB_DTEDR1        ( DDR0_PUB_REG_BASE + ( 0x0<< 2 ) ) // R/W - Data Training Eye Data Register 1
#define DDR0_PUB_DTEDR2        ( DDR0_PUB_REG_BASE + ( 0x0 << 2 ) ) // R/W - Data Training Eye Data Register 2
#define DDR0_PUB_VTDR          ( DDR0_PUB_REG_BASE + ( 0x0<< 2 ) ) // R/W - Vref Training Data Register

#ifndef  P_DDR0_CLK_CTRL
#define P_DDR0_CLK_CTRL   0xc8000800
#endif
#ifndef  P_DDR1_CLK_CTRL
#define P_DDR1_CLK_CTRL  0xc8002800
#endif

#define DDR0_PUB_IOVCR0						(DDR0_PUB_REG_BASE+(0x8E<<2))
#define DDR0_PUB_IOVCR1						(DDR0_PUB_REG_BASE+(0x8F<<2))
#endif

#if (CONFIG_DDR_PHY ==  P_DDR_PHY_GX_BABY)
//unsigned int des[8];
/*
	unsigned int pattern_1[4][8]=
	{
	0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,
0xff00ff00	,

};
unsigned int pattern_2[4][8]={
0x0001fe00	,
0x0000ff00	,
0x0000ff00	,
0x0000ff00	,
0x0002fd00	,
0x0000ff00	,
0x0000ff00	,
0x0000ff00	,
0x0004fb00	,
0x0000ff00	,
0x0000ff00	,
0x0000ff00	,
0x0008f700	,
0x0000ff00	,
0x0000ff00	,
0x0000ff00	,
0x0010ef00	,
0x0000ff00	,
0x0000ff00	,
0x0000ff00	,
0x0020df00	,
0x0000ff00	,
0x0000ff00	,
0x0000ff00	,
0x0040bf00	,
0x0000ff00	,
0x0000ff00	,
0x0000ff00	,
0x00807f00	,
0x0000ff00	,
0x0000ff00	,
0x0000ff00	,

};
unsigned int pattern_3[4][8]={
	0x00010000	,
	0x00000000	,
	0x00000000	,
	0x00000000	,
	0x00020000	,
	0x00000000	,
	0x00000000	,
	0x00000000	,
	0x00040000	,
	0x00000000	,
	0x00000000	,
	0x00000000	,
	0x00080000	,
	0x00000000	,
	0x00000000	,
	0x00000000	,
	0x00100000	,
	0x00000000	,
	0x00000000	,
	0x00000000	,
	0x00200000	,
	0x00000000	,
	0x00000000	,
	0x00000000	,
	0x00400000	,
	0x00000000	,
	0x00000000	,
	0x00000000	,
	0x00800000	,
	0x00000000	,
	0x00000000	,
	0x00000000	,
};
unsigned int pattern_4[4][8]={
	0x51c8c049	,
	0x2d43592c	,
	0x0777b50b	,
	0x9cd2ebe5	,
	0xc04199d5	,
	0xdc968dc0	,
	0xb8ba8a33	,
	0x35e4327f	,
	0x51c8c049	,
	0x2d43592c	,
	0x0777b50b	,
	0x9cd2ebe5	,
	0xc04199d5	,
	0xdc968dc0	,
	0xb8ba8a33	,
	0x35e4327f	,
	0x51c8c049	,
	0x2d43592c	,
	0x0777b50b	,
	0x9cd2ebe5	,
	0xc04199d5	,
	0xdc968dc0	,
	0xb8ba8a33	,
	0x35e4327f	,
	0x51c8c049	,
	0x2d43592c	,
	0x0777b50b	,
	0x9cd2ebe5	,
	0xc04199d5	,
	0xdc968dc0	,
	0xb8ba8a33	,
	0x35e4327f	,
};
unsigned int pattern_5[4][8]={
	0xaec9c149	,
	0xd243592c	,
	0xf877b50b	,
	0x63d2ebe5	,
	0x3f439bd5	,
	0x23968dc0	,
	0x47ba8a33	,
	0xcae4327f	,
	0xaeccc449	,
	0xd243592c	,
	0xf877b50b	,
	0x63d2ebe5	,
	0x3f4991d5	,
	0x23968dc0	,
	0x47ba8a33	,
	0xcae4327f	,
	0xaed8d049	,
	0xd243592c	,
	0xf877b50b	,
	0x63d2ebe5	,
	0x3f61b9d5	,
	0x23968dc0	,
	0x47ba8a33	,
	0xcae4327f	,
	0xae888049	,
	0xd243592c	,
	0xf877b50b	,
	0x63d2ebe5	,
	0x3fc119d5	,
	0x23968dc0	,
	0x47ba8a33	,
	0xcae4327f	,
};
unsigned int pattern_6[4][8]={
	0xaec9c149	,
	0xd243a62c	,
	0xf8774a0b	,
	0x63d214e5	,
	0x3f4366d5	,
	0x239672c0	,
	0x47ba7533	,
	0xcae4cd7f	,
	0xaecc3f49	,
	0xd243a62c	,
	0xf8774a0b	,
	0x63d214e5	,
	0x3f4966d5	,
	0x239672c0	,
	0x47ba7533	,
	0xcae4cd7f	,
	0xaed83f49	,
	0xd243a62c	,
	0xf8774a0b	,
	0x63d214e5	,
	0x3f6166d5	,
	0x239672c0	,
	0x47ba7533	,
	0xcae4cd7f	,
	0xae883f49	,
	0xd243a62c	,
	0xf8774a0b	,
	0x63d214e5	,
	0x3fc166d5	,
	0x239672c0	,
	0x47ba7533	,
	0xcae4cd7f	,

};
unsigned int  des[8] ={
	0xaec83f49,
	0xd243a62c,
	0xf8774a0b,
	0x63d214e5,
	0x3f4166d5,
	0x239672c0,
	0x47ba7533,
	0xcae4cd7f,
};
*/
/*
   unsigned int  des[8] ;
   des[0] = 	0xaec83f49;
   des[1] =      0xd243a62c;
   des[2] =      0xf8774a0b;
   des[3] =       0x63d214e5;
   des[4] =      0x3f4166d5;
   des[5] =     0x239672c0;
   des[6] =      0x47ba7533;
   des[7] =      0xcae4cd7f;
   pattern_1[0][0] = 0xff00ff00;
   pattern_1[0][1] = 0xff00ff00;
   pattern_1[0][2] = 0xff00ff00;
   pattern_1[0][3] = 0xff00ff00;
   pattern_1[0][4] = 0xff00ff00;
   pattern_1[0][5] = 0xff00ff00;
   pattern_1[0][6] = 0xff00ff00;
   pattern_1[0][7] = 0xff00ff00;

   pattern_1[1][0] = 0xff00ff00;
   pattern_1[1][1] = 0xff00ff00;
   pattern_1[1][2] = 0xff00ff00;
   pattern_1[1][3] = 0xff00ff00;
   pattern_1[1][4] = 0xff00ff00;
   pattern_1[1][5] = 0xff00ff00;
   pattern_1[1][6] = 0xff00ff00;
   pattern_1[1][7] = 0xff00ff00;

   pattern_1[2][0] = 0xff00ff00;
   pattern_1[2][1] = 0xff00ff00;
   pattern_1[2][2] = 0xff00ff00;
   pattern_1[2][3] = 0xff00ff00;
   pattern_1[2][4] = 0xff00ff00;
   pattern_1[2][5] = 0xff00ff00;
   pattern_1[2][6] = 0xff00ff00;
   pattern_1[2][7] = 0xff00ff00;

   pattern_1[3][0] = 0xff00ff00;
   pattern_1[3][1] = 0xff00ff00;
   pattern_1[3][2] = 0xff00ff00;
   pattern_1[3][3] = 0xff00ff00;
   pattern_1[3][4] = 0xff00ff00;
   pattern_1[3][5] = 0xff00ff00;
   pattern_1[3][6] = 0xff00ff00;
   pattern_1[3][7] = 0xff00ff00;

   pattern_2[0][0] = 0x0001fe00;
   pattern_2[0][1] = 0x0000ff00;
   pattern_2[0][2] = 0x0000ff00;
   pattern_2[0][3] = 0x0000ff00;
   pattern_2[0][4] = 0x0002fd00;
   pattern_2[0][5] = 0x0000ff00;
   pattern_2[0][6] = 0x0000ff00;
   pattern_2[0][7] = 0x0000ff00;

   pattern_2[1][0] = 0x0004fb00;
   pattern_2[1][1] = 0x0000ff00;
   pattern_2[1][2] = 0x0000ff00;
   pattern_2[1][3] = 0x0000ff00;
   pattern_2[1][4] = 0x0008f700;
   pattern_2[1][5] = 0x0000ff00;
   pattern_2[1][6] = 0x0000ff00;
   pattern_2[1][7] = 0x0000ff00;

   pattern_2[2][0] = 0x0010ef00;
   pattern_2[2][1] = 0x0000ff00;
   pattern_2[2][2] = 0x0000ff00;
   pattern_2[2][3] = 0x0000ff00;
   pattern_2[2][4] = 0x0020df00;
   pattern_2[2][5] = 0x0000ff00;
   pattern_2[2][6] = 0x0000ff00;
pattern_2[2][7] = 0x0000ff00;

pattern_2[3][0] = 0x0040bf00;
pattern_2[3][1] = 0x0000ff00;
pattern_2[3][2] = 0x0000ff00;
pattern_2[3][3] = 0x0000ff00;
pattern_2[3][4] = 0x00807f00;
pattern_2[3][5] = 0x0000ff00;
pattern_2[3][6] = 0x0000ff00;
pattern_2[3][7] = 0x0000ff00;

pattern_3[0][0] = 0x00010000;
pattern_3[0][1] = 0x00000000;
pattern_3[0][2] = 0x00000000;
pattern_3[0][3] = 0x00000000;
pattern_3[0][4] = 0x00020000;
pattern_3[0][5] = 0x00000000;
pattern_3[0][6] = 0x00000000;
pattern_3[0][7] = 0x00000000;

pattern_3[1][0] = 0x00040000;
pattern_3[1][1] = 0x00000000;
pattern_3[1][2] = 0x00000000;
pattern_3[1][3] = 0x00000000;
pattern_3[1][4] = 0x00080000;
	pattern_3[1][5] = 0x00000000;
	pattern_3[1][6] = 0x00000000;
	pattern_3[1][7] = 0x00000000;

	pattern_3[2][0] = 0x00100000;
	pattern_3[2][1] = 0x00000000;
	pattern_3[2][2] = 0x00000000;
	pattern_3[2][3] = 0x00000000;
	pattern_3[2][4] = 0x00200000;
	pattern_3[2][5] = 0x00000000;
	pattern_3[2][6] = 0x00000000;
	pattern_3[2][7] = 0x00000000;

	pattern_3[3][0] = 0x00400000;
	pattern_3[3][1] = 0x00000000;
	pattern_3[3][2] = 0x00000000;
	pattern_3[3][3] = 0x00000000;
	pattern_3[3][4] = 0x00800000;
	pattern_3[3][5] = 0x00000000;
	pattern_3[3][6] = 0x00000000;
	pattern_3[3][7] = 0x00000000;

pattern_4[0][0] =	0x51c8c049	;
pattern_4[0][1] =	0x2d43592c	;
pattern_4[0][2] =	0x0777b50b	;
pattern_4[0][3] =	0x9cd2ebe5	;
pattern_4[0][4] =	0xc04199d5	;
pattern_4[0][5] =	0xdc968dc0	;
pattern_4[0][6] =	0xb8ba8a33	;
pattern_4[0][7] =	0x35e4327f	;

pattern_4[1][0] =	0x51c8c049	;
pattern_4[1][1] =	0x2d43592c	;
pattern_4[1][2] =	0x0777b50b	;
pattern_4[1][3] =	0x9cd2ebe5	;
pattern_4[1][4] =	0xc04199d5	;
pattern_4[1][5] =	0xdc968dc0	;
pattern_4[1][6] =	0xb8ba8a33	;
pattern_4[1][7] =	0x35e4327f	;

pattern_4[2][0] =	0x51c8c049	;
pattern_4[2][1] =	0x2d43592c	;
pattern_4[2][2] =	0x0777b50b	;
pattern_4[2][3] =	0x9cd2ebe5	;
pattern_4[2][4] =	0xc04199d5	;
pattern_4[2][5] =	0xdc968dc0	;
pattern_4[2][6] =	0xb8ba8a33	;
pattern_4[2][7] =	0x35e4327f	;

pattern_4[3][0] =	0x51c8c049	;
pattern_4[3][1] =	0x2d43592c	;
pattern_4[3][2] =	0x0777b50b	;
pattern_4[3][3] =	0x9cd2ebe5	;
pattern_4[3][4] =	0xc04199d5	;
pattern_4[3][5] =	0xdc968dc0	;
pattern_4[3][6] =	0xb8ba8a33	;
pattern_4[3][7] =	0x35e4327f	;

pattern_5[0][0] =	0xaec9c149	;
pattern_5[0][1] =	0xd243592c	;
pattern_5[0][2] =	0xf877b50b	;
pattern_5[0][3] =	0x63d2ebe5	;
pattern_5[0][4] =	0x3f439bd5	;
pattern_5[0][5] =	0x23968dc0	;
pattern_5[0][6] =	0x47ba8a33	;
pattern_5[0][7] =	0xcae4327f	;
pattern_5[1][0] =	0xaeccc449	;
pattern_5[1][1] =	0xd243592c	;
pattern_5[1][2] =	0xf877b50b	;
pattern_5[1][3] =	0x63d2ebe5	;
pattern_5[1][4] =	0x3f4991d5	;
pattern_5[1][5] =	0x23968dc0	;
pattern_5[1][6] =	0x47ba8a33	;
pattern_5[1][7] =	0xcae4327f	;
pattern_5[2][0] =	0xaed8d049	;
pattern_5[2][1] =	0xd243592c	;
pattern_5[2][2] =	0xf877b50b	;
pattern_5[2][3] =	0x63d2ebe5	;
pattern_5[2][4] =	0x3f61b9d5	;
pattern_5[2][5] =	0x23968dc0	;
pattern_5[2][6] =	0x47ba8a33	;
pattern_5[2][7] =	0xcae4327f	;
pattern_5[3][0] =	0xae888049	;
pattern_5[3][1] =	0xd243592c	;
pattern_5[3][2] =	0xf877b50b	;
pattern_5[3][3] =	0x63d2ebe5	;
pattern_5[3][4] =	0x3fc119d5	;
pattern_5[3][5] =	0x23968dc0	;
pattern_5[3][6] =	0x47ba8a33	;
pattern_5[3][7] =	0xcae4327f	;

pattern_6[0][1] =	0xd243a62c	;
pattern_6[0][2] =	0xf8774a0b	;
pattern_6[0][3] =	0x63d214e5	;
pattern_6[0][4] =	0x3f4366d5	;
pattern_6[0][5] =	0x239672c0	;
pattern_6[0][6] =	0x47ba7533	;
pattern_6[0][7] =	0xcae4cd7f	;
pattern_6[1][0] =	0xaecc3f49	;
pattern_6[1][1] =	0xd243a62c	;
pattern_6[1][2] =	0xf8774a0b	;
pattern_6[1][3] =	0x63d214e5	;
pattern_6[1][4] =	0x3f4966d5	;
pattern_6[1][5] =	0x239672c0	;
pattern_6[1][6] =	0x47ba7533	;
pattern_6[1][7] =	0xcae4cd7f	;
pattern_6[2][0] =	0xaed83f49	;
pattern_6[2][1] =	0xd243a62c	;
pattern_6[2][2] =	0xf8774a0b	;
pattern_6[2][3] =	0x63d214e5	;
pattern_6[2][4] =	0x3f6166d5	;
pattern_6[2][5] =	0x239672c0	;
pattern_6[2][6] =	0x47ba7533	;
pattern_6[2][7] =	0xcae4cd7f	;
pattern_6[3][0] =	0xae883f49	;
pattern_6[3][1] =	0xd243a62c	;
pattern_6[3][2] =	0xf8774a0b	;
pattern_6[3][3] =	0x63d214e5	;
pattern_6[3][4] =	0x3fc166d5	;
pattern_6[3][5] =	0x239672c0	;
pattern_6[3][6] =	0x47ba7533	;
pattern_6[3][7] =	0xcae4cd7f	;
*/
#endif

#define DDR_TEST_START_ADDR  0x1080000//  0x10000000 //CONFIG_SYS_MEMTEST_START
#define DDR_TEST_SIZE 0x2000000
//#define DDR_TEST_SIZE 0x2000

#if (CONFIG_CHIP>=CHIP_TXLX)

#define P_EE_TIMER_E                                 (volatile unsigned int *)((0x3c62  << 2) + 0xffd00000)

///*
//#ifndef P_PIN_MUX_REG1
// Pin Mux  (9)
// ----------------------------
#if (CONFIG_CHIP==CHIP_TXLX)
#define     PERIPHS_PIN_MUX_0                                  (0xff634400 + (0x2c << 2))
#define SEC_PERIPHS_PIN_MUX_0                                  (0xff634400 + (0x2c << 2))
#define   P_PERIPHS_PIN_MUX_0                                  (volatile uint32_t *)(0xff634400 + (0x2c << 2))
#define     PERIPHS_PIN_MUX_1                                  (0xff634400 + (0x2d << 2))
#define SEC_PERIPHS_PIN_MUX_1                                  (0xff634400 + (0x2d << 2))
#define   P_PERIPHS_PIN_MUX_1                                  (volatile uint32_t *)(0xff634400 + (0x2d << 2))
#define     PERIPHS_PIN_MUX_2                                  (0xff634400 + (0x2e << 2))
#define SEC_PERIPHS_PIN_MUX_2                                  (0xff634400 + (0x2e << 2))
#define   P_PERIPHS_PIN_MUX_2                                  (volatile uint32_t *)(0xff634400 + (0x2e << 2))
#define     PERIPHS_PIN_MUX_3                                  (0xff634400 + (0x2f << 2))
#define SEC_PERIPHS_PIN_MUX_3                                  (0xff634400 + (0x2f << 2))
#define   P_PERIPHS_PIN_MUX_3                                  (volatile uint32_t *)(0xff634400 + (0x2f << 2))
#define     PERIPHS_PIN_MUX_4                                  (0xff634400 + (0x30 << 2))
#define SEC_PERIPHS_PIN_MUX_4                                  (0xff634400 + (0x30 << 2))
#define   P_PERIPHS_PIN_MUX_4                                  (volatile uint32_t *)(0xff634400 + (0x30 << 2))
#define     PERIPHS_PIN_MUX_5                                  (0xff634400 + (0x31 << 2))
#define SEC_PERIPHS_PIN_MUX_5                                  (0xff634400 + (0x31 << 2))
#define   P_PERIPHS_PIN_MUX_5                                  (volatile uint32_t *)(0xff634400 + (0x31 << 2))
#define     PERIPHS_PIN_MUX_6                                  (0xff634400 + (0x32 << 2))
#define SEC_PERIPHS_PIN_MUX_6                                  (0xff634400 + (0x32 << 2))
#define   P_PERIPHS_PIN_MUX_6                                  (volatile uint32_t *)(0xff634400 + (0x32 << 2))
#define     PERIPHS_PIN_MUX_7                                  (0xff634400 + (0x33 << 2))
#define SEC_PERIPHS_PIN_MUX_7                                  (0xff634400 + (0x33 << 2))
#define   P_PERIPHS_PIN_MUX_7                                  (volatile uint32_t *)(0xff634400 + (0x33 << 2))
#define     PERIPHS_PIN_MUX_8                                  (0xff634400 + (0x34 << 2))
#define SEC_PERIPHS_PIN_MUX_8                                  (0xff634400 + (0x34 << 2))
#define   P_PERIPHS_PIN_MUX_8                                  (volatile uint32_t *)(0xff634400 + (0x34 << 2))
#define     PERIPHS_PIN_MUX_9                                  (0xff634400 + (0x35 << 2))
#define SEC_PERIPHS_PIN_MUX_9                                  (0xff634400 + (0x35 << 2))
#define   P_PERIPHS_PIN_MUX_9                                  (volatile uint32_t *)(0xff634400 + (0x35 << 2))
#define     PERIPHS_PIN_MUX_10                                 (0xff634400 + (0x36 << 2))
#define SEC_PERIPHS_PIN_MUX_10                                 (0xff634400 + (0x36 << 2))
#define   P_PERIPHS_PIN_MUX_10                                 (volatile uint32_t *)(0xff634400 + (0x36 << 2))
#define     PERIPHS_PIN_MUX_11                                 (0xff634400 + (0x37 << 2))
#define SEC_PERIPHS_PIN_MUX_11                                 (0xff634400 + (0x37 << 2))
#define   P_PERIPHS_PIN_MUX_11                                 (volatile uint32_t *)(0xff634400 + (0x37 << 2))
#define     PERIPHS_PIN_MUX_12                                 (0xff634400 + (0x38 << 2))
#define SEC_PERIPHS_PIN_MUX_12                                 (0xff634400 + (0x38 << 2))
#define   P_PERIPHS_PIN_MUX_12                                 (volatile uint32_t *)(0xff634400 + (0x38 << 2))
#endif 
#define P_PIN_MUX_REG1        P_PERIPHS_PIN_MUX_1// (((volatile unsigned *)(0xda834400 + (0x2d << 2))))
#define P_PIN_MUX_REG2       P_PERIPHS_PIN_MUX_2//  (((volatile unsigned *)(0xda834400 + (0x2e << 2))))
#define P_PIN_MUX_REG3		P_PERIPHS_PIN_MUX_3//(((volatile unsigned *)(0xda834400 + (0x2f << 2))))
#define P_PIN_MUX_REG7		P_PERIPHS_PIN_MUX_7//(((volatile unsigned *)(0xda834400 + (0x33 << 2))))
//#endif

//#ifndef P_PWM_MISC_REG_AB
//#define P_PWM_MISC_REG_AB	(*((volatile unsigned *)(0xc1100000 + (0x2156 << 2))))
//#define P_PWM_PWM_B		(*((volatile unsigned *)(0xc1100000 + (0x2155 << 2))))
//#define P_PWM_MISC_REG_CD	(*((volatile unsigned *)(0xc1100000 + (0x2192 << 2))))
//#define P_PWM_PWM_D		(*((volatile unsigned *)(0xc1100000 + (0x2191 << 2))))
//#endif
//*/
//#define   PWM_MISC_REG_AB                          (0x6c02)
//#define P_PWM_MISC_REG_AB                          (volatile unsigned int *)((0x6c02  << 2) + 0xffd00000)
//#define WATCHDOG_CNTL                              ((0x3c34  << 2) + 0xffd00000)
//#define WATCHDOG_CNTL1                             ((0x3c35  << 2) + 0xffd00000)
//#define WATCHDOG_TCNT                              ((0x3c36  << 2) + 0xffd00000)
//#define WATCHDOG_RESET                             ((0x3c37  << 2) + 0xffd00000)
#else
//#define ddr_udelay(a)  do{}while((a<<5)--);
#define P_EE_TIMER_E                                 (volatile unsigned int *)(((0x2662  << 2) + 0xc1100000))
//#define WATCHDOG_CNTL              0xc11098d0
//#define WATCHDOG_CNTL1            0xc11098d4
//#define WATCHDOG_TCNT             0xc11098d8
//#define WATCHDOG_RESET            0xc11098dc
#ifndef P_WATCHDOG_CNTL
#if (CONFIG_DDR_PHY > P_DDR_PHY_DEFAULT)
#define P_WATCHDOG_CNTL              (volatile unsigned int *)0xc11098d0
#define P_WATCHDOG_CNTL1           (volatile unsigned int *) 0xc11098d4
#define P_WATCHDOG_TCNT             (volatile unsigned int *)0xc11098d8
#define P_WATCHDOG_RESET           (volatile unsigned int *) 0xc11098dc
#else
#define P_WATCHDOG_CNTL              (volatile unsigned int *)(0xc1100000+(0x2640<<2))
//#define P_WATCHDOG_CNTL1           (volatile unsigned int *) 0xc11098d4
//#define P_WATCHDOG_TCNT             (volatile unsigned int *)0xc11098d8
#define P_WATCHDOG_RESET           (volatile unsigned int *)(0xc1100000+(0x2641<<2))
#endif
#endif


#ifndef P_PIN_MUX_REG1
#define P_PIN_MUX_REG1         (((volatile unsigned *)(0xda834400 + (0x2d << 2))))
#define P_PIN_MUX_REG2         (((volatile unsigned *)(0xda834400 + (0x2e << 2))))
#define P_PIN_MUX_REG3		(((volatile unsigned *)(0xda834400 + (0x2f << 2))))
#define P_PIN_MUX_REG7		(((volatile unsigned *)(0xda834400 + (0x33 << 2))))
#endif

#ifndef P_PWM_MISC_REG_AB
#define P_PWM_MISC_REG_AB	(((volatile unsigned *)(0xc1100000 + (0x2156 << 2))))
#define P_PWM_PWM_B		(((volatile unsigned *)(0xc1100000 + (0x2155 << 2))))
#define P_PWM_MISC_REG_CD	(((volatile unsigned *)(0xc1100000 + (0x2192 << 2))))
#define P_PWM_PWM_D		(((volatile unsigned *)(0xc1100000 + (0x2191 << 2))))
#endif

#ifndef P_EE_TIMER_E
#define P_EE_TIMER_E		(((volatile unsigned *)(0xc1100000 + (0x2662 << 2))))
#endif

#endif

#define get_us_time()    (*P_EE_TIMER_E)// (readl(P_ISA_TIMERE))

// #define P_ISA_TIMERE                0xc1109988
//   #define get_us_time()    (readl(P_ISA_TIMERE))

/*
#define P_PIN_MUX_REG3		(*((volatile unsigned *)(0xff634400 + (0x2f << 2))))
#define P_PIN_MUX_REG4		(*((volatile unsigned *)(0xff634400 + (0x30 << 2))))

#define P_PWM_MISC_REG_AB	(*((volatile unsigned *)(0xff807000 + (0x02 << 2))))
#define P_PWM_PWM_A		(*((volatile unsigned *)((0x6c00  << 2) + 0xffd00000)))

#define AO_PIN_MUX_REG		(*((volatile unsigned *)(0xff800000 + (0x05 << 2))))
*/

#define dwc_ddrphy_apb_wr(addr, dat)   *(volatile uint16_t *)(int_convter_p(((addr) << 1)+0xfe000000))=((uint16_t)dat)
#define dwc_ddrphy_apb_rd(addr)   *(volatile uint16_t *)(int_convter_p(((addr) << 1)+0xfe000000))
#define ACX_MAX                              0x80

void ddr_udelay(unsigned int us)
{
//#ifndef CONFIG_PXP_EMULATOR
	unsigned int t0 = (*((P_EE_TIMER_E)));

	while ((*((P_EE_TIMER_E))) - t0 <= us)
		;
//#endif
}

#define DDR_PARAMETER_SOURCE_FROM_DMC_STICKY  1 
#define DDR_PARAMETER_SOURCE_FROM_UBOOT_ENV    2 
#define DDR_PARAMETER_SOURCE_FROM_UBOOT_IDME  3 
#define DDR_PARAMETER_SOURCE_FROM_ORG_STICKY  4 

#define 	DDR_PARAMETER_READ		1
#define 	DDR_PARAMETER_WRITE		2
#define 	DDR_PARAMETER_LEFT		1
#define 	DDR_PARAMETER_RIGHT		2

typedef struct ddr_test_struct {
	unsigned	int	ddr_data_source	;  
	unsigned	int	ddr_data_test_size	;  
	unsigned	int	ddr_address_test_size	;  
	unsigned	int	ddr_test_watchdog_times_s	;  
	unsigned	int	ddr_test_lane_disable	;  

	unsigned	int	ddr_test_window_flag[8]	;  
	unsigned	int	ddr_test_window_data[100]	;  
}  ddr_test_struct_t;			
ddr_test_struct_t *g_ddr_test_struct;			

unsigned int  read_write_window_test_parameter(unsigned int source_index, unsigned int parameter_index ,unsigned int parameter_value,unsigned int read_write_flag )
{

	if(source_index == DDR_PARAMETER_SOURCE_FROM_DMC_STICKY)
	{
		sticky_reg_base_add = (DDR0_PUB_REG_BASE&0xffff0000)+((DMC_STICKY_0)&0xffff);

		if(read_write_flag == DDR_PARAMETER_WRITE)
			wr_reg((sticky_reg_base_add+(parameter_index<<2)), parameter_value);
		if(read_write_flag == DDR_PARAMETER_READ)
			parameter_value = rd_reg((sticky_reg_base_add+(parameter_index<<2)));
	}

	if(source_index == DDR_PARAMETER_SOURCE_FROM_UBOOT_ENV)
	{
		char *pre_env_name = "ddr_test_data_num";
		char *env_name = "ddr_test_data_num_0000";
		char *str_buf = NULL;
		char *temp_s = NULL;
		char *endp = NULL;
		char buf[1024];
		str_buf = (char *)(&buf);
		memset(str_buf, 0, sizeof(buf));
		sprintf(env_name,"%s_%04d",pre_env_name,parameter_index);
		sprintf(buf, "0x%08x", parameter_value);

		if(read_write_flag == DDR_PARAMETER_WRITE)
		{ 
			setenv(env_name, buf);
			run_command("save",0);
		}
		if(read_write_flag == DDR_PARAMETER_READ)
		{ 
			temp_s = getenv(env_name);
			if(temp_s)
				parameter_value = simple_strtoull_ddr(temp_s, &endp, 0);
			else
				parameter_value = 0;
		}
	}

	if(source_index == DDR_PARAMETER_SOURCE_FROM_ORG_STICKY)
	{
		sticky_reg_base_add=(PREG_STICKY_REG0);

		if(read_write_flag==DDR_PARAMETER_WRITE)
			wr_reg((sticky_reg_base_add+(parameter_index<<2)), parameter_value);
		if(read_write_flag==DDR_PARAMETER_READ)
			parameter_value=rd_reg((sticky_reg_base_add+(parameter_index<<2)));
	}
	return parameter_value;
}


unsigned int  read_write_window_test_flag(unsigned int source_index, unsigned int parameter_index ,unsigned int parameter_value,unsigned int read_write_flag )
{

	if (source_index == DDR_PARAMETER_SOURCE_FROM_ORG_STICKY)
	{
		sticky_reg_base_add = PREG_STICKY_REG0;

		if (read_write_flag == DDR_PARAMETER_WRITE)
			wr_reg((sticky_reg_base_add+(parameter_index<<2)), parameter_value);
		if (read_write_flag == DDR_PARAMETER_READ)
			parameter_value = rd_reg((sticky_reg_base_add+(parameter_index<<2)));
	}

	if (source_index == DDR_PARAMETER_SOURCE_FROM_DMC_STICKY)
	{
		sticky_reg_base_add = (DDR0_PUB_REG_BASE&0xffff0000)+((DMC_STICKY_0)&0xffff);

		if (read_write_flag == DDR_PARAMETER_WRITE)
			wr_reg((sticky_reg_base_add+(parameter_index<<2)), parameter_value);
		if (read_write_flag == DDR_PARAMETER_READ)
			parameter_value = rd_reg((sticky_reg_base_add+(parameter_index<<2)));
	}

	if (source_index == DDR_PARAMETER_SOURCE_FROM_UBOOT_ENV)
	{
		char *pre_env_name = "ddr_test_data_num";
		char *env_name = "ddr_test_data_num_0000";
		char *str_buf = NULL;
		char *temp_s = NULL;
		char *endp = NULL;
		char buf[1024];
		str_buf = (char *)(&buf);
		memset(str_buf, 0, sizeof(buf));
		sprintf(env_name,"%s_%04d",pre_env_name,parameter_index);
		sprintf(buf, "0x%08x", parameter_value);

		if (read_write_flag == DDR_PARAMETER_WRITE)
		{
			setenv(env_name, buf);
			run_command("save",0);
		}
		if(read_write_flag == DDR_PARAMETER_READ)
		{ 
			temp_s = getenv(env_name);
			if(temp_s)
				parameter_value = simple_strtoull_ddr(temp_s, &endp, 0);
			else
				parameter_value = 0;
		}
	}

	return parameter_value;
}

void ddr_test_watchdog_init(uint32_t msec)
{

	// src: 24MHz
	// div: 24000 for 1ms
	// reset ao-22 and ee-21
	//	writel( (1<<24)|(1<<25)|(1<<23)|(1<<21)|(24000-1),(unsigned int )P_WATCHDOG_CNTL);
#if (CONFIG_DDR_PHY > P_DDR_PHY_DEFAULT)
	*P_WATCHDOG_CNTL = (1<<24)|(1<<25)|(1<<23)|(1<<21)|(24000-1);

	// set timeout
	//*P_WATCHDOG_TCNT = msec;
	//	writel(msec,(unsigned int )P_WATCHDOG_CNTL); //bit0-15
	*P_WATCHDOG_TCNT = msec;
	//writel(0,(unsigned int )P_WATCHDOG_RESET);
	*P_WATCHDOG_RESET = 0;
	//*P_WATCHDOG_RESET = 0;

	// enable
	*P_WATCHDOG_CNTL = (*P_WATCHDOG_CNTL)|(1<<18);
	//writel((readl((unsigned int )P_WATCHDOG_CNTL))|(1<<18),(unsigned int )P_WATCHDOG_CNTL);
	//*P_WATCHDOG_CNTL |= (1<<18);
#else
	*P_WATCHDOG_CNTL = (0<<24)|(msec*8-1);
	//*P_WATCHDOG_TCNT=msec;
#endif
}

void ddr_test_watchdog_enable(uint32_t sec)
{

	// src: 24MHz
	// div: 24000 for 1ms
	// reset ao-22 and ee-21
	//	writel( (1<<24)|(1<<25)|(1<<23)|(1<<21)|(24000-1),(unsigned int )P_WATCHDOG_CNTL);
#if (CONFIG_DDR_PHY > P_DDR_PHY_DEFAULT)
	*P_WATCHDOG_CNTL=(1<<24)|(1<<25)|(1<<23)|(1<<21)|(240000-1); //10ms
	// set timeout
	//*P_WATCHDOG_TCNT = msec;
	//	writel(msec,(unsigned int )P_WATCHDOG_CNTL); //bit0-15
	if(sec*100>0xffff)
		*P_WATCHDOG_TCNT=0xffff;
	else
		*P_WATCHDOG_TCNT=sec*100;  //max 655s
	//writel(0,(unsigned int )P_WATCHDOG_RESET);
	*P_WATCHDOG_RESET=0;
	//*P_WATCHDOG_RESET = 0;

	// enable
	*P_WATCHDOG_CNTL=(*P_WATCHDOG_CNTL)|(1<<18);
	//writel((readl((unsigned int )P_WATCHDOG_CNTL))|(1<<18),(unsigned int )P_WATCHDOG_CNTL);
	//*P_WATCHDOG_CNTL |= (1<<18);
#else
	//*P_WATCHDOG_CNTL=(1<<24)|(1<<19)|(sec*8000-1);
	*P_WATCHDOG_CNTL=(1<<24)|(1<<19)|(0xffff);
	printf("\nm8baby_watchdog max only 5s,please take care test size not too long for m8baby\n");
#endif
	printf("\nP_WATCHDOG_ENABLE\n");
}

void ddr_test_watchdog_disable(void )
{

	// src: 24MHz
	// div: 24000 for 1ms
	// reset ao-22 and ee-21
	//	writel( (1<<24)|(1<<25)|(1<<23)|(1<<21)|(24000-1),(unsigned int )P_WATCHDOG_CNTL);
#if (CONFIG_DDR_PHY > P_DDR_PHY_DEFAULT)
	*P_WATCHDOG_CNTL=(1<<24)|(1<<25)|(1<<23)|(1<<21)|(240000-1); //10ms
	// set timeout
	//*P_WATCHDOG_TCNT = msec;
	//	writel(msec,(unsigned int )P_WATCHDOG_CNTL); //bit0-15
	//*P_WATCHDOG_TCNT=sec*100;
	//writel(0,(unsigned int )P_WATCHDOG_RESET);
	*P_WATCHDOG_RESET=0;
	//*P_WATCHDOG_RESET = 0;

	// enable
	*P_WATCHDOG_CNTL=(*P_WATCHDOG_CNTL)&(~(1<<18));
	//writel((readl((unsigned int )P_WATCHDOG_CNTL))|(1<<18),(unsigned int )P_WATCHDOG_CNTL);
	//*P_WATCHDOG_CNTL |= (1<<18);
#else
	*P_WATCHDOG_CNTL=(0<<24)|(0<<19)|(24000-1);
#endif
	printf("\nP_WATCHDOG_DISABLE\n");
}


void ddr_test_watchdog_clear(void )
{

	// src: 24MHz
	// div: 24000 for 1ms
	// reset ao-22 and ee-21
	//	writel( (1<<24)|(1<<25)|(1<<23)|(1<<21)|(24000-1),(unsigned int )P_WATCHDOG_CNTL);
	//*P_WATCHDOG_CNTL=(1<<24)|(1<<25)|(1<<23)|(1<<21)|(240000-1); //10ms
	// set timeout
	//*P_WATCHDOG_TCNT = msec;
	//	writel(msec,(unsigned int )P_WATCHDOG_CNTL); //bit0-15
	//*P_WATCHDOG_TCNT=sec*100;
	//writel(0,(unsigned int )P_WATCHDOG_RESET);
	*P_WATCHDOG_RESET=0;
	//*P_WATCHDOG_RESET = 0;

	// enable
	//*P_WATCHDOG_CNTL=(*P_WATCHDOG_CNTL)&(~(1<<18));
	//writel((readl((unsigned int )P_WATCHDOG_CNTL))|(1<<18),(unsigned int )P_WATCHDOG_CNTL);
	//*P_WATCHDOG_CNTL |= (1<<18);
	//printf("\nP_WATCHDOG_CLEAR,reg=0x%8x\n",(P_WATCHDOG_RESET));
}

void ddr_test_watchdog_reset_system(void)
{
	//#define P_WATCHDOG_CNTL              0xc11098d0
	//#define P_WATCHDOG_CNTL1            0xc11098d4
	//#define P_WATCHDOG_TCNT             0xc11098d8
	//#define P_WATCHDOG_RESET            0xc11098dc
#if (CONFIG_DDR_PHY > P_DDR_PHY_DEFAULT)
	int i;

	while (1) {
		/*
		   writel(	0x3	| (1 << 21) // sys reset en  ao ee 3
		   | (1 << 23) // interrupt en
		   | (1 << 24) // clk en
		   | (1 << 25) // clk div en
		   | (1 << 26) // sys reset now  ao ee 3
		   , (unsigned int )P_WATCHDOG_CNTL);
		   */
		*P_WATCHDOG_CNTL=
			0x3	| (1 << 21) // sys reset en  ao ee 3
			| (1 << 23) // interrupt en
			| (1 << 24) // clk en
			| (1 << 25) // clk div en
			| (1 << 26); // sys reset now  ao ee 3;
		//printf("\nP_WATCHDOG_CNTL reg_add_%x08==%x08",(unsigned int )P_WATCHDOG_CNTL,readl((unsigned int )P_WATCHDOG_CNTL));
		//printf("\nP_WATCHDOG_CNTL==%x08",readl((unsigned int )P_WATCHDOG_CNTL));
		//printf("\nP_WATCHDOG_CNTL==%x08",readl((unsigned int )P_WATCHDOG_CNTL));
		printf("\nP_WATCHDOG_CNTLREG_ADD %x08==%x08",(unsigned int)(unsigned long)P_WATCHDOG_CNTL,
				*P_WATCHDOG_CNTL);
		//writel(0, (unsigned int )P_WATCHDOG_RESET);
		*P_WATCHDOG_RESET=0;

		//	writel(readl((unsigned int )P_WATCHDOG_CNTL) | (1<<18), // watchdog en
		//(unsigned int )P_WATCHDOG_CNTL);
		*P_WATCHDOG_CNTL=(*P_WATCHDOG_CNTL)|(1<<18);
		for (i=0; i<100; i++)
			*P_WATCHDOG_CNTL;
		//readl((unsigned int )P_WATCHDOG_CNTL);/*Deceive gcc for waiting some cycles */
	}

#else
	//WRITE_CBUS_REG(WATCHDOG_TC, 0xf080000 | 2000);
	*P_WATCHDOG_CNTL=(0xf080000 | 2000);
#endif
	while(1);
}


//just tune for lcdlr

#if ( CONFIG_DDR_PHY >= P_DDR_PHY_G12)
#else
int do_ddr_fine_tune_lcdlr_env1(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter ddr_fine_tune_lcdlr_env  function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	int i = 0;
	printf("\nargc== 0x%08x\n", argc);
	for(i = 0; i<argc; i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}

	//writel((0), 0xc8836c00);
	OPEN_CHANNEL_A_PHY_CLK();

	OPEN_CHANNEL_B_PHY_CLK();
	//writel((0), 0xc8836c00);

	char *endp;
	//  unsigned int   *p_start_addr;

#define WR_RD_ADJ_USE_ENV  1
#define WR_RD_ADJ_USE_UART_INPUT 2
	unsigned int   wr_rd_adj_input_src=1;
	int wr_adj_per[12]={
		100	,
		1000,
		100	,
		100	,
		100	,
		100	,
		100	,
		100	,
		100	,
		100	,
		100	,
		100	,
	};
	int rd_adj_per[12]={
		100	,
		100	,
		80	,
		80	,
		80	,
		80	,
		100	,
		100	,
		100	,
		100	,
		100	,
		100	,
	};
	if(argc == 1)
		printf("\nplease read help\n");

	if(argc >= 2)
	{
		wr_rd_adj_input_src = simple_strtoull_ddr(argv[1], &endp, 10);

		unsigned int i=0; 	
		if(wr_rd_adj_input_src==WR_RD_ADJ_USE_UART_INPUT)
		{
			printf("\ntune ddr lcdlr use uart input\n");
			if (argc>24+2)
				argc=24+2;

			for(i = 2;i<argc;i++)
			{
				if(i<(2+12))
					wr_adj_per[i-2]=simple_strtoull_ddr(argv[i], &endp, 10);
				else
					rd_adj_per[i-14]=simple_strtoull_ddr(argv[i], &endp, 10);
			}
		}

		// unsigned int = 0, max = 0xff, min = 0x00;
		if(wr_rd_adj_input_src==WR_RD_ADJ_USE_ENV)
		{
			printf("\ntune ddr lcdlr use uboot env\n");
			//char str[24];
			const char *s;

			// char *varname;
			int value=0;

			//*varname="env_ddrtest";
			s = getenv("env_wr_lcdlr_pr");
			if (s)
			{//i=0;
				//while(s_temp)
				{
					printf("%s",s);
					//sscanf(s,"d%,",wr_adj_per);
					//sprintf(str,"d%",s);
					//getc
				}
				value = simple_strtoull_ddr(s, &endp, 16);
				printf("%d",value);
			}
			s = getenv("env_rd_lcdlr_pr");

			if (s)
			{//i=0;
				//while(s_temp)
				{
					printf("%s",s);
					//sscanf(s,"d%,",rd_adj_per);

				}
				//value = simple_strtoull_ddr(s, &endp, 16);
			}

			//sprintf(str, "%lx", value);
			//  setenv("env_ddrtest", str);
			//run_command("save",0);

			if (argc>24+2)
				argc=24+2;
			for(i = 2;i<argc;i++)
			{
				if(i<(2+12))
					wr_adj_per[i-2]=simple_strtoull_ddr(argv[i], &endp, 16);
				else
					rd_adj_per[i-14]=simple_strtoull_ddr(argv[i], &endp, 16);
			}
		}
		printf(" int wr_adj_per[12]={\n");
		for(i = 0;i<12;i++)
			printf("%04d ,\n",wr_adj_per[i]);
		printf("};\n");
		printf(" int rd_adj_per[12]={\n");
		for(i = 0;i<12;i++)
			printf("%04d ,\n",rd_adj_per[i]);
		printf("};\n");

#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
		wr_reg(DDR0_PUB_PIR, (rd_reg(DDR0_PUB_PIR))|(1<<29));
		wr_reg(DDR0_PUB_PGCR6, (rd_reg(DDR0_PUB_PGCR6))|(1<<0));
		wr_reg(DDR1_PUB_PIR, (rd_reg(DDR1_PUB_PIR))|(1<<29));
		wr_reg(DDR1_PUB_PGCR6, (rd_reg(DDR1_PUB_PGCR6))|(1<<0));
#else
		wr_reg(DDR0_PUB_PIR, (rd_reg(DDR0_PUB_PIR))|(1<<29));
		wr_reg(DDR0_PUB_PGCR1, (rd_reg(DDR0_PUB_PGCR1))|(1<<26));
		wr_reg(DDR1_PUB_PIR, (rd_reg(DDR1_PUB_PIR))|(1<<29));
		wr_reg(DDR1_PUB_PGCR1, (rd_reg(DDR1_PUB_PGCR1))|(1<<26));
#endif

		int lcdlr_w=0,lcdlr_r=0;
		unsigned temp_reg=0;
		int temp_count=0;
		for( temp_count=0;temp_count<2;temp_count++)
		{     temp_reg=(unsigned)(DDR0_PUB_ACLCDLR+(temp_count<<2));
			lcdlr_w=(int)((rd_reg((uint64_t)(temp_reg)))&ACLCDLR_MAX);
			lcdlr_w=lcdlr_w?lcdlr_w:1;
			lcdlr_w=(lcdlr_w*(wr_adj_per[temp_count]))/100;
			if(temp_count==1)
				lcdlr_w=lcdlr_w&ACBDLR_MAX;
			wr_reg(((uint64_t)(temp_reg)),((lcdlr_w)&ACLCDLR_MAX));
		}
#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
		for( temp_count=2;temp_count<6;temp_count++)
		{     temp_reg=(unsigned)(DDR0_PUB_DX0LCDLR1+(DDR0_PUB_DX1LCDLR1-DDR0_PUB_DX0LCDLR1)*(temp_count-2));
			lcdlr_w=(int)((rd_reg((uint64_t)(temp_reg)))&DQLCDLR_MAX);
			lcdlr_w=lcdlr_w?lcdlr_w:1;
			lcdlr_r=(int)(((rd_reg((uint64_t)(temp_reg+DDR0_PUB_DX0LCDLR3-DDR0_PUB_DX0LCDLR1))))&DQLCDLR_MAX);
			lcdlr_r=lcdlr_r?lcdlr_r:1;
			lcdlr_w=(lcdlr_w*(wr_adj_per[temp_count]))/100;
			lcdlr_r=(lcdlr_r*(rd_adj_per[temp_count]))/100;
			wr_reg(((uint64_t)(temp_reg)),(lcdlr_w));
			wr_reg(((uint64_t)(temp_reg+DDR0_PUB_DX0LCDLR3-DDR0_PUB_DX0LCDLR1)),(lcdlr_r));
			wr_reg(((uint64_t)(temp_reg+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR1)),(lcdlr_r));
		}
#else
		for ( temp_count=2;temp_count<6;temp_count++) {
			temp_reg=(unsigned)(DDR0_PUB_DX0LCDLR1+(DDR0_PUB_DX1LCDLR1-DDR0_PUB_DX0LCDLR1)*(temp_count-2));
			lcdlr_w=(int)((rd_reg((uint64_t)(temp_reg)))&DQLCDLR_MAX);
			lcdlr_w=lcdlr_w?lcdlr_w:1;
			lcdlr_r=(int)(((rd_reg((uint64_t)(temp_reg)))>>8)&DQLCDLR_MAX);
			lcdlr_r=lcdlr_r?lcdlr_r:1;
			lcdlr_w=(lcdlr_w*(wr_adj_per[temp_count]))/100;
			lcdlr_r=(lcdlr_r*(rd_adj_per[temp_count]))/100;
			wr_reg(((uint64_t)(temp_reg)),(((lcdlr_r<<16)|(lcdlr_r<<8)|(lcdlr_w))));
		}
#endif
		for( temp_count=6;temp_count<8;temp_count++) {
			temp_reg=(unsigned)(DDR1_PUB_ACLCDLR+((temp_count-6)<<2));

			lcdlr_w=(int)((rd_reg((uint64_t)(temp_reg)))&ACLCDLR_MAX);
			lcdlr_w=lcdlr_w?lcdlr_w:1;
			lcdlr_w=(lcdlr_w*(wr_adj_per[temp_count]))/100;
			if(temp_count==7)
				lcdlr_w=lcdlr_w&ACBDLR_MAX;
			wr_reg(((uint64_t)(temp_reg)),((lcdlr_w)&ACLCDLR_MAX));
		}
#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
		for( temp_count=8;temp_count<12;temp_count++) {
			temp_reg=(unsigned)(DDR1_PUB_DX0LCDLR1+(DDR1_PUB_DX1LCDLR1-DDR1_PUB_DX0LCDLR1)*(temp_count-2));
			lcdlr_w=(int)((rd_reg((uint64_t)(temp_reg)))&DQLCDLR_MAX);
			lcdlr_w=lcdlr_w?lcdlr_w:1;
			lcdlr_r=(int)(((rd_reg((uint64_t)(temp_reg+DDR1_PUB_DX0LCDLR3-DDR1_PUB_DX0LCDLR1))))&DQLCDLR_MAX);
			lcdlr_r=lcdlr_r?lcdlr_r:1;
			lcdlr_w=(lcdlr_w*(wr_adj_per[temp_count]))/100;
			lcdlr_r=(lcdlr_r*(rd_adj_per[temp_count]))/100;
			wr_reg(((uint64_t)(temp_reg)),(lcdlr_w));
			wr_reg(((uint64_t)(temp_reg+DDR1_PUB_DX0LCDLR3-DDR1_PUB_DX0LCDLR1)),(lcdlr_r));
			wr_reg(((uint64_t)(temp_reg+DDR1_PUB_DX0LCDLR4-DDR1_PUB_DX0LCDLR1)),(lcdlr_r));
		}
#else
		for( temp_count=8;temp_count<12;temp_count++) {
			temp_reg=(unsigned)(DDR1_PUB_DX0LCDLR1+(DDR1_PUB_DX1LCDLR1-DDR1_PUB_DX0LCDLR1)*(temp_count-8));
			lcdlr_w=(int)((rd_reg((uint64_t)(temp_reg)))&0xff);
			lcdlr_w=lcdlr_w?lcdlr_w:1;
			lcdlr_r=(int)(((rd_reg((uint64_t)(temp_reg)))>>8)&0xff);
			lcdlr_r=lcdlr_r?lcdlr_r:1;
			lcdlr_w=(lcdlr_w*(wr_adj_per[temp_count]))/100;
			lcdlr_r=(lcdlr_r*(rd_adj_per[temp_count]))/100;
			wr_reg(((uint64_t)(temp_reg)),(((lcdlr_r<<16)|(lcdlr_r<<8)|(lcdlr_w))));
		}
#endif	

#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
		wr_reg(DDR0_PUB_PGCR6, (rd_reg(DDR0_PUB_PGCR6))&(~(1<<0)));
		wr_reg(DDR0_PUB_PIR, (rd_reg(DDR0_PUB_PIR))&(~(1<<29)));

		wr_reg(DDR1_PUB_PGCR6, (rd_reg(DDR1_PUB_PGCR6))&(~(1<<0)));
		wr_reg(DDR1_PUB_PIR, (rd_reg(DDR1_PUB_PIR))&(~(1<<29)));
#else
		wr_reg(DDR0_PUB_PGCR1, (rd_reg(DDR0_PUB_PGCR1))&(~(1<<26)));
		wr_reg(DDR0_PUB_PIR, (rd_reg(DDR0_PUB_PIR))&(~(1<<29)));

		wr_reg(DDR1_PUB_PGCR1, (rd_reg(DDR1_PUB_PGCR1))&(~(1<<26)));
		wr_reg(DDR1_PUB_PIR, (rd_reg(DDR1_PUB_PIR))&(~(1<<29)));
#endif
		printf("\nend adjust lcdlr\n");

		CLOSE_CHANNEL_A_PHY_CLK();
		CLOSE_CHANNEL_B_PHY_CLK();
	}

	return 1;
}
U_BOOT_CMD(
	ddr_test_tune_dqs_env,	30,	1,	do_ddr_fine_tune_lcdlr_env1,
	"do_ddr_fine_tune_lcdlr_env arg1 arg2 arg3...",
	"do_ddr_fine_tune_lcdlr_env arg1 arg2 arg3... \n dcache off ? \n" 
);

#endif
//*/
static void ddr_write(void *buff,  unsigned int  m_length)
{
	unsigned int  *p;
	unsigned int  i, j, n;
	unsigned int  m_len = m_length;

	p = ( unsigned int  *)buff;

	while (m_len)
	{
		for (j=0;j<32;j++)
		{

			if (m_len >= 128)
				n = 32;
			else
				n = m_len>>2;

			for (i = 0; i < n; i++)
			{
#ifdef DDR_PREFETCH_CACHE
				ddr_pld_cache(p)  ;
#endif
				switch (i)
				{
					case 0:
					case 9:
					case 14:
					case 25:
					case 30:
						*(p+i) = TDATA32F;
						break;
					case 1:
					case 6:
					case 8:
					case 17:
					case 22:
						*(p+i) = 0;
						break;
					case 16:
					case 23:
					case 31:
						*(p+i) = TDATA32A;
						break;
					case 7:
					case 15:
					case 24:
						*(p+i) = TDATA325;
						break;
					case 2:
					case 4:
					case 10:
					case 12:
					case 19:
					case 21:
					case 27:
					case 29:
						*(p+i) = 1<<j;
						break;
					case 3:
					case 5:
					case 11:
					case 13:
					case 18:
					case 20:
					case 26:
					case 28:
						*(p+i) = ~(1<<j);
						break;
				}
			}

			if (m_len > 128)
			{
				m_len -= 128;
				p += 32;
			}
			else
			{
				p += (m_len>>2);
				m_len = 0;
				break;
			}
		}
	}
}

static void ddr_read(void *buff,  unsigned int  m_length)
{
	unsigned int  *p;
	unsigned int  i, j, n;
	unsigned int  m_len = m_length;

	p = ( unsigned int  *)buff;

	while (m_len)
	{
		for (j=0;j<32;j++)
		{

			if (m_len >= 128)
				n = 32;
			else
				n = m_len>>2;

			for (i = 0; i < n; i++)
			{
#ifdef DDR_PREFETCH_CACHE
				ddr_pld_cache(p)  ;
#endif
				if ((error_outof_count_flag) && (error_count))
				{
					printf("Error data out of count");
					m_len=0;
					break;
				}
				switch (i)
				{

					case 0:
					case 9:
					case 14:
					case 25:
					case 30:
						if (*(p+i) != TDATA32F)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), TDATA32F);
						}
						break;
					case 1:
					case 6:
					case 8:
					case 17:
					case 22:
						if (*(p+i) != 0) {error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0);
						}break;
					case 16:
					case 23:
					case 31:
						if (*(p+i) != TDATA32A) {error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), TDATA32A);
						} break;
					case 7:
					case 15:
					case 24:
						if (*(p+i) != TDATA325) {error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), TDATA325);
						} break;
					case 2:
					case 4:
					case 10:
					case 12:
					case 19:
					case 21:
					case 27:
					case 29:
						if (*(p+i) != 1<<j) {error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 1<<j);
						} break;
					case 3:
					case 5:
					case 11:
					case 13:
					case 18:
					case 20:
					case 26:
					case 28:
						if (*(p+i) != ~(1<<j)) {error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~(1<<j));
						} break;
				}
			}

			if (m_len > 128)
			{
				m_len -= 128;
				p += 32;
			}
			else
			{
				p += (m_len>>2);
				m_len = 0;
				break;
			}
		}
	}
}


static void ddr_write4(void *buff,  unsigned int  m_length)
{
	unsigned int  *p;
	unsigned int  i, j, n;
	unsigned int  m_len = m_length;

	p = ( unsigned int  *)buff;

	while (m_len)
	{
		for (j=0;j<32;j++)
		{

			if (m_len >= 128)
				n = 32;
			else
				n = m_len>>2;

			for (i = 0; i < n; i++)
			{
#ifdef DDR_PREFETCH_CACHE
				ddr_pld_cache(p)  ;
#endif
				switch (i)
				{
					case 0:
					case 1:
					case 2:
					case 3:

						*(p+i) = 0xff00ff00;
						break;
					case 4:
					case 5:
					case 6:
					case 7:

						*(p+i) = ~0xff00ff00;
						break;
					case 8:
					case 9:
					case 10:
					case 11:
						*(p+i) = 0xaa55aa55;
						break;
					case 12:
					case 13:
					case 14:
					case 15:
						*(p+i) = ~0xaa55aa55;
						break;
					case 16:
					case 17:
					case 18:
					case 19:

					case 24:
					case 25:
					case 26:
					case 27:

						*(p+i) = 1<<j;
						break;

					case 20:
					case 21:
					case 22:
					case 23:
					case 28:
					case 29:
					case 30:
					case 31:
						*(p+i) = ~(1<<j);
						break;
				}
			}

			if (m_len > 128)
			{
				m_len -= 128;
				p += 32;
			}
			else
			{
				p += (m_len>>2);
				m_len = 0;
				break;
			}
		}
	}
}

static void ddr_read4(void *buff,  unsigned int  m_length)
{
	unsigned int  *p;
	unsigned int  i, j, n;
	unsigned int  m_len = m_length;

	p = ( unsigned int  *)buff;

	while (m_len)
	{
		for (j=0;j<32;j++)
		{

			if (m_len >= 128)
				n = 32;
			else
				n = m_len>>2;

			for (i = 0; i < n; i++)
			{
#ifdef DDR_PREFETCH_CACHE
				ddr_pld_cache(p)  ;
#endif
				if ((error_outof_count_flag) && (error_count))
				{
					printf("Error data out of count");
					m_len=0;
					break;
				}
				switch (i)
				{

					case 0:
					case 1:
					case 2:
					case 3:

						//   *(p+i) = 0xff00ff00;
						if (*(p+i) != 0xff00ff00)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), TDATA32F);
						}
						break;
					case 4:
					case 5:
					case 6:
					case 7:

						//      *(p+i) = ~0xff00ff00;
						if (*(p+i) != ~0xff00ff00)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), TDATA32F);
						}
						break;
					case 8:
					case 9:
					case 10:
					case 11:
						//    *(p+i) = 0xaa55aa55;
						if (*(p+i) != 0xaa55aa55)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), TDATA32F);
						}
						break;
					case 12:
					case 13:
					case 14:
					case 15:
						//   *(p+i) = ~0xaa55aa55;
						if (*(p+i) != ~0xaa55aa55)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), TDATA32F);
						}
						break;
					case 16:
					case 17:
					case 18:
					case 19:

					case 24:
					case 25:
					case 26:
					case 27:

						//   *(p+i) = 1<<j;
						if (*(p+i) != (1<<j))
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), TDATA32F);
						}
						break;

					case 20:
					case 21:
					case 22:
					case 23:
					case 28:
					case 29:
					case 30:
					case 31:
						//  *(p+i) = ~(1<<j);
						if (*(p+i) !=~( 1<<j))
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), TDATA32F);
						}
						break;
				}
			}

			if (m_len > 128)
			{
				m_len -= 128;
				p += 32;
			}
			else
			{
				p += (m_len>>2);
				m_len = 0;
				break;
			}
		}
	}
}

static void ddr_read_full(void *buff,  unsigned int  m_length,unsigned int  start_pattern,
	unsigned int  pattern_offset)
{
	unsigned int  *p;
	unsigned int  i=0;
	unsigned int  m_len = m_length&0xfffffffc;

	p = ( unsigned int  *)buff;
	//*(p)=start_pattern;
	while (m_len)
	{
		m_len=m_len-4;

		//	*(p+i) = (*(p))+pattern_offset;

#ifdef DDR_PREFETCH_CACHE
		ddr_pld_cache(p+i)  ;
#endif
		if ((error_outof_count_flag) && (error_count))
		{
			printf("Error data out of count");
			m_len=0;
			break;
		}
		if ((*(p+i)) !=(start_pattern+pattern_offset*i))
		{error_count++;
			printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 
					(start_pattern+pattern_offset*i));
		}
		break;

		i++;
	}
}

static void ddr_write_full(void *buff,  unsigned int  m_length,unsigned int  start_pattern,
	unsigned int  pattern_offset)
{
	unsigned int  *p;
	unsigned int  i=0;
	unsigned int  m_len = m_length&0xfffffffc;

	p = ( unsigned int  *)buff;
	//*(p)=start_pattern;
	while (m_len)
	{
		m_len=m_len-4;
		*(p+i) = start_pattern+pattern_offset*i;
		i++;
	}
}

///*
static void ddr_test_copy(void *addr_dest,void *addr_src,unsigned int memcpy_size)
{
	unsigned int  *p_dest;
	unsigned int  *p_src;

	unsigned int  m_len = memcpy_size;

	p_dest = ( unsigned int  *)addr_dest;
	p_src = ( unsigned int  *)addr_src;
	m_len = m_len/4; //assume it's multiple of 4
	while (m_len--) {
		ddr_pld_cache(p_src)  ;//#define ddr_pld_cache(P)   asm ("prfm PLDL1KEEP, [%0, #376]"::"r" (P))
		*p_dest++ = *p_src++;
		*p_dest++ = *p_src++;
		*p_dest++ = *p_src++;
		*p_dest++ = *p_src++;
	}
}
//*/
int do_ddr_test_copy(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	char *endp;
	unsigned long   loop = 1;
	unsigned int   print_flag =1;
	// unsigned int  start_addr = DDR_TEST_START_ADDR;
	unsigned int  src_addr = DDR_TEST_START_ADDR;
	unsigned int  dec_addr = DDR_TEST_START_ADDR+0x8000000;
	unsigned int  test_size = DDR_TEST_SIZE;


	print_flag=1;

	printf("\nargc== 0x%08x\n", argc);
	int i ;
	for (i = 0;i<argc;i++)
		printf("\nargv[%d]=%s\n",i,argv[i]);

	//    printf("\nLINE== 0x%08x\n", __LINE__);
	if (argc ==1) {
		//    start_addr = simple_strtoull_ddr(argv[2], &endp, 16);
		//    if (*argv[2] == 0 || *endp != 0)
		src_addr = DDR_TEST_START_ADDR;
		loop = 1;
	}
	if (argc > 2) {
		//    start_addr = simple_strtoull_ddr(argv[2], &endp, 16);
		if (*argv[2] == 0 || *endp != 0)
			src_addr = DDR_TEST_START_ADDR;
	}
	if (argc > 3) {
		src_addr = simple_strtoull_ddr(argv[1], &endp, 16);
		dec_addr = simple_strtoull_ddr(argv[2], &endp, 16);
		test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		loop = 1;
		if (*argv[3] == 0 || *endp != 0)
			test_size = DDR_TEST_SIZE;

	}
	if (test_size<0x1000)
		test_size = DDR_TEST_SIZE;
	if (argc > 4) {
		loop = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
			loop = 1;
	}
	if (argc > 5) {
		print_flag = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
			print_flag = 1;
	}
	//COPY_TEST_START:

	///*
	unsigned long time_start, time_end,test_loops;
	test_loops=loop;
	unsigned long size_count=0;
	size_count=loop*test_size;
	time_start = get_us_time();//us

	do {
		//     loop = 1;
		ddr_test_copy((void *)(int_convter_p(dec_addr)),(void *)(int_convter_p(src_addr)),test_size);
		//bcopy((void *)(int_convter_p(src_addr)),(void *)(int_convter_p(dec_addr)),test_size);
		//mcopy((void *)(int_convter_p(src_addr)),(void *)(int_convter_p(dec_addr)),test_size);
		if (print_flag)
		{
			printf("\nloop==0x%08x", ( unsigned int )loop);
			printf("\n      \n");
		}
	}while(--loop);
	//*/
	time_end = get_us_time();//us
	printf("\ncopy %d times use %dus\n                             \n",( unsigned int )test_loops,( unsigned int )(time_end-time_start));

	printf("\nddr copy bandwidth==%d MBYTE/S \n                             \n",(unsigned int)(size_count/(time_end-time_start)));
	printf("\rEnd ddr test.                              \n");

	unsigned int m_len=0,counter=0;
	unsigned int  *p_dest;
	p_dest=  (void *)(int_convter_p(dec_addr));
	m_len = test_size/4; //assume it's multiple of 4
	counter=(unsigned int)test_loops;
	size_count=counter*test_size;
	time_start = get_us_time();//us
	do {
		loop = 1;
		m_len = test_size/4;
		while (m_len--) {
			ddr_pld_cache(p_dest)  ;
			*p_dest++ = 0x12345678;
			*p_dest++ = 0x12345678;
			*p_dest++ = 0x12345678;
			*p_dest++ = 0x12345678;
		}
	}while(--counter);
	time_end = get_us_time();//us
	printf("\nwrite %d bytes use %dus\n                             \n",( unsigned int )test_size,( unsigned int )(time_end-time_start));

	printf("\nddr write bandwidth==%d MBYTE/S \n                             \n",(unsigned int)(size_count/(time_end-time_start)));

	unsigned int  *p_src;
	p_src=  (void *)(int_convter_p(src_addr));
	m_len = test_size/4; //assume it's multiple of 4
	unsigned int temp0=0;
	//unsigned int temp1=0;
	//unsigned int temp2=0;
	//unsigned int temp3=0;
	counter=(unsigned int)test_loops;
	size_count=counter*test_size;

	//  #define OPEN_CHANNEL_A_PHY_CLK()      (writel((0), 0xc8836c00))
	//writel((1000000<<0), DMC_MON_CTRL1);
	//writel((0<<31)|(1<<30)|(0<<20)|(1<<16)|(1<<0), DMC_MON_CTRL2);
	//writel((1<<31)|(0<<30)|(0<<20)|(1<<16)|(1<<0), DMC_MON_CTRL2);
	time_start = get_us_time();//us
	do {
		loop = 1;
		m_len = test_size/4;
		while (m_len--) {
			//  ddr_pld_cache(p_src++)  ;
#ifdef DDR_PREFETCH_CACHE
			__asm__ __volatile__ ("prfm PLDL1KEEP, [%0, #376]"::"r" (p_src));
#endif
			p_src++;
			temp0 =( *p_src);
			m_len--;
			m_len--;
			m_len--;
			m_len--;
			m_len--;
			m_len--;
			m_len--;
		}
	}while(--counter);
	*p_dest++ = temp0;
	*p_dest++ = *p_src;
	*p_dest++ = *p_src;
	*p_dest++ = *p_src;
	time_end = get_us_time();//us

	printf("\nread %d Kbytes use %dus\n                             \n",(unsigned int)(size_count/1000),( unsigned int )(time_end-time_start));
	printf("\nddr read bandwidth==%d MBYTE/S \n                             \n",(unsigned int)(size_count/(time_end-time_start)));

	return 0;
}

U_BOOT_CMD(
	ddr_test_copy,	7,	1,	do_ddr_test_copy,
	"ddr_test_copy function",
	"ddr_test_copy  0x08000000 0x10000000 0x02000000 1 0 ? \n"
);

///*
#define DDR_PATTERN_LOOP_1 32
#define DDR_PATTERN_LOOP_2 64
#define DDR_PATTERN_LOOP_3 96
/*
__asm
{
.Global memcpy_pld
.type memcpy_pld ,%function
.align 8
memcpy_pld:
mov x4,x0
subs x2,x2,#8
b.mi 2f
1: ldr x3,[x1],#8
	subs x2,x2,#8
	str x3,[x4],#8
	prfm PLDL1KEEP,[x1,#376]
	b.pl  1b

2: adds x2,x2,#4
	b.mi 3f
	ldr w3,[x1],#4
	sub x2,x2,#4
	str w3,[x4],#4

3: adds x2,x2,#2
	b.mi 4f
	ldr w3,[x1],#2
	sub x2,x2,#4
	str w3,[x4],#4

4: adds x2,x2,#1
	b.mi 5f
	ldr w3,[x1],#2
	sub x2,x2,#4
	str w3,[x4],#4

5: ret
}
*/
//static void ddr_memcpy_pld(void *addr_dest,  void *addr_src, unsigned int  m_length)
//{
/*
asm
{
//.Global memcpy_pld
.type memcpy_pld ,%function
.align 8
memcpy_pld:
mov x4,x0
subs x2,x2,#8
b.mi 2f
1: ldr x3,[x1],#8
	subs x2,x2,#8
	str x3,[x4],#8
	prfm PLDL1KEEP,[x1,#376]
	b.pl  1b

2: adds x2,x2,#4
	b.mi 3f
	ldr w3,[x1],#4
	sub x2,x2,#4
	str w3,[x4],#4

3: adds x2,x2,#2
	b.mi 4f
	ldr w3,[x1],#2
	sub x2,x2,#4
	str w3,[x4],#4

4: adds x2,x2,#1
	b.mi 5f
	ldr w3,[x1],#2
	sub x2,x2,#4
	str w3,[x4],#4

5: ret
}
memcpy_pld(addr_dest,addr_src,m_length);
*/
//}



#if (CONFIG_DDR_PHY ==  P_DDR_PHY_GX_BABY)

///*

int ddr_test_gx_cross_talk_pattern(int ddr_test_size)
{
	unsigned int  start_addr = 0x10000000;
	error_outof_count_flag=1;
	error_count=0;

	unsigned int  des[8] ;
	unsigned int  pattern_1[4][8] ;
	unsigned int  pattern_2[4][8] ;
	unsigned int  pattern_3[4][8] ;
	unsigned int  pattern_4[4][8] ;
	unsigned int  pattern_5[4][8] ;
	unsigned int  pattern_6[4][8] ;

	des[0] = 	0xaec83f49;
	des[1] =      0xd243a62c;
	des[2] =      0xf8774a0b;
	des[3] =       0x63d214e5;
	des[4] =      0x3f4166d5;
	des[5] =     0x239672c0;
	des[6] =      0x47ba7533;
	des[7] =      0xcae4cd7f;
	pattern_1[0][0] = 0xff00ff00;
	pattern_1[0][1] = 0xff00ff00;
	pattern_1[0][2] = 0xff00ff00;
	pattern_1[0][3] = 0xff00ff00;
	pattern_1[0][4] = 0xff00ff00;
	pattern_1[0][5] = 0xff00ff00;
	pattern_1[0][6] = 0xff00ff00;
	pattern_1[0][7] = 0xff00ff00;

	pattern_1[1][0] = 0x00ffff00;
	pattern_1[1][1] = 0x00ffff00;
	pattern_1[1][2] = 0x00ffff00;
	pattern_1[1][3] = 0x00ffff00;
	pattern_1[1][4] = 0x00ffff00;
	pattern_1[1][5] = 0x00ffff00;
	pattern_1[1][6] = 0x00ffff00;
	pattern_1[1][7] = 0x00ffff00;

	pattern_1[2][0] = 0xffff0000;
	pattern_1[2][1] = 0xffff0000;
	pattern_1[2][2] = 0xffff0000;
	pattern_1[2][3] = 0xffff0000;
	pattern_1[2][4] = 0xffff0000;
	pattern_1[2][5] = 0xffff0000;
	pattern_1[2][6] = 0xffff0000;
	pattern_1[2][7] = 0xffff0000;
	pattern_1[3][0] = 0xff00ff00;
	pattern_1[3][1] = 0xff00ff00;
	pattern_1[3][2] = 0xff00ff00;
	pattern_1[3][3] = 0xff00ff00;
	pattern_1[3][4] = 0xff00ff00;
	pattern_1[3][5] = 0xff00ff00;
	pattern_1[3][6] = 0xff00ff00;
	pattern_1[3][7] = 0xff00ff00;

	pattern_2[0][0] = 0x0001fe00;
	pattern_2[0][1] = 0x0000ff00;
	pattern_2[0][2] = 0x0000ff00;
	pattern_2[0][3] = 0x0000ff00;
	pattern_2[0][4] = 0x0002fd00;
	pattern_2[0][5] = 0x0000ff00;
	pattern_2[0][6] = 0x0000ff00;
	pattern_2[0][7] = 0x0000ff00;

	pattern_2[1][0] = 0x0004fb00;
	pattern_2[1][1] = 0x0000ff00;
	pattern_2[1][2] = 0x0000ff00;
	pattern_2[1][3] = 0x0000ff00;
	pattern_2[1][4] = 0x0008f700;
	pattern_2[1][5] = 0x0000ff00;
	pattern_2[1][6] = 0x0000ff00;
	pattern_2[1][7] = 0x0000ff00;

	pattern_2[2][0] = 0x0010ef00;
	pattern_2[2][1] = 0x0000ff00;
	pattern_2[2][2] = 0x0000ff00;
	pattern_2[2][3] = 0x0000ff00;
	pattern_2[2][4] = 0x0020df00;
	pattern_2[2][5] = 0x0000ff00;
	pattern_2[2][6] = 0x0000ff00;
	pattern_2[2][7] = 0x0000ff00;

	pattern_2[3][0] = 0x0040bf00;
	pattern_2[3][1] = 0x0000ff00;
	pattern_2[3][2] = 0x0000ff00;
	pattern_2[3][3] = 0x0000ff00;
	pattern_2[3][4] = 0x00807f00;
	pattern_2[3][5] = 0x0000ff00;
	pattern_2[3][6] = 0x0000ff00;
	pattern_2[3][7] = 0x0000ff00;

	pattern_3[0][0] = 0x00010000;
	pattern_3[0][1] = 0x00000000;
	pattern_3[0][2] = 0x00000000;
	pattern_3[0][3] = 0x00000000;
	pattern_3[0][4] = 0x00020000;
	pattern_3[0][5] = 0x00000000;
	pattern_3[0][6] = 0x00000000;
	pattern_3[0][7] = 0x00000000;

	pattern_3[1][0] = 0x00040000;
	pattern_3[1][1] = 0x00000000;
	pattern_3[1][2] = 0x00000000;
	pattern_3[1][3] = 0x00000000;
	pattern_3[1][4] = 0x00080000;
	pattern_3[1][5] = 0x00000000;
	pattern_3[1][6] = 0x00000000;
	pattern_3[1][7] = 0x00000000;

	pattern_3[2][0] = 0x00100000;
	pattern_3[2][1] = 0x00000000;
	pattern_3[2][2] = 0x00000000;
	pattern_3[2][3] = 0x00000000;
	pattern_3[2][4] = 0x00200000;
	pattern_3[2][5] = 0x00000000;
	pattern_3[2][6] = 0x00000000;
	pattern_3[2][7] = 0x00000000;

	pattern_3[3][0] = 0x00400000;
	pattern_3[3][1] = 0x00000000;
	pattern_3[3][2] = 0x00000000;
	pattern_3[3][3] = 0x00000000;
	pattern_3[3][4] = 0x00800000;
	pattern_3[3][5] = 0x00000000;
	pattern_3[3][6] = 0x00000000;
	pattern_3[3][7] = 0x00000000;

	///*
	pattern_4[0][0] =	0x51c8c049	;
	pattern_4[0][1] =	0x2d43592c	;
	pattern_4[0][2] =	0x0777b50b	;
	pattern_4[0][3] =	0x9cd2ebe5	;
	pattern_4[0][4] =	0xc04199d5	;
	pattern_4[0][5] =	0xdc968dc0	;
	pattern_4[0][6] =	0xb8ba8a33	;
	pattern_4[0][7] =	0x35e4327f	;

	pattern_4[1][0] =	0xae37c049	;
	pattern_4[1][1] =	0xd2bc592c	;
	pattern_4[1][2] =	0xf888b50b	;
	pattern_4[1][3] =	0x632debe5	;
	pattern_4[1][4] =	0x3fbe99d5	;
	pattern_4[1][5] =	0x23698dc0	;
	pattern_4[1][6] =	0x47458a33	;
	pattern_4[1][7] =	0xca1b327f	;

	pattern_4[2][0] =	0x51373f49	;
	pattern_4[2][1] =	0x2dbca62c	;
	pattern_4[2][2] =	0x07884a0b	;
	pattern_4[2][3] =	0x9c2d14e5	;
	pattern_4[2][4] =	0xc0be66d5	;
	pattern_4[2][5] =	0xdc6972c0	;
	pattern_4[2][6] =	0xb8457533	;
	pattern_4[2][7] =	0x351bcd7f	;


	pattern_4[3][0] =	0x51c8c049	;
	pattern_4[3][1] =	0x2d43592c	;
	pattern_4[3][2] =	0x0777b50b	;
	pattern_4[3][3] =	0x9cd2ebe5	;
	pattern_4[3][4] =	0xc04199d5	;
	pattern_4[3][5] =	0xdc968dc0	;
	pattern_4[3][6] =	0xb8ba8a33	;
	pattern_4[3][7] =	0x35e4327f	;

	pattern_5[0][0] =	0xaec9c149	;
	pattern_5[0][1] =	0xd243592c	;
	pattern_5[0][2] =	0xf877b50b	;
	pattern_5[0][3] =	0x63d2ebe5	;
	pattern_5[0][4] =	0x3f439bd5	;
	pattern_5[0][5] =	0x23968dc0	;
	pattern_5[0][6] =	0x47ba8a33	;
	pattern_5[0][7] =	0xcae4327f	;
	pattern_5[1][0] =	0xaeccc449	;
	pattern_5[1][1] =	0xd243592c	;
	pattern_5[1][2] =	0xf877b50b	;
	pattern_5[1][3] =	0x63d2ebe5	;
	pattern_5[1][4] =	0x3f4991d5	;
	pattern_5[1][5] =	0x23968dc0	;
	pattern_5[1][6] =	0x47ba8a33	;
	pattern_5[1][7] =	0xcae4327f	;
	pattern_5[2][0] =	0xaed8d049	;
	pattern_5[2][1] =	0xd243592c	;
	pattern_5[2][2] =	0xf877b50b	;
	pattern_5[2][3] =	0x63d2ebe5	;
	pattern_5[2][4] =	0x3f61b9d5	;
	pattern_5[2][5] =	0x23968dc0	;
	pattern_5[2][6] =	0x47ba8a33	;
	pattern_5[2][7] =	0xcae4327f	;
	pattern_5[3][0] =	0xae888049	;
	pattern_5[3][1] =	0xd243592c	;
	pattern_5[3][2] =	0xf877b50b	;
	pattern_5[3][3] =	0x63d2ebe5	;
	pattern_5[3][4] =	0x3fc119d5	;
	pattern_5[3][5] =	0x23968dc0	;
	pattern_5[3][6] =	0x47ba8a33	;
	pattern_5[3][7] =	0xcae4327f	;

	pattern_6[0][0] =   0xaec93f49   ;
	pattern_6[0][1] =	0xd243a62c	;
	pattern_6[0][2] =	0xf8774a0b	;
	pattern_6[0][3] =	0x63d214e5	;
	pattern_6[0][4] =	0x3f4366d5	;
	pattern_6[0][5] =	0x239672c0	;
	pattern_6[0][6] =	0x47ba7533	;
	pattern_6[0][7] =	0xcae4cd7f	;
	pattern_6[1][0] =	0xaecc3f49	;
	pattern_6[1][1] =	0xd243a62c	;
	pattern_6[1][2] =	0xf8774a0b	;
	pattern_6[1][3] =	0x63d214e5	;
	pattern_6[1][4] =	0x3f4966d5	;
	pattern_6[1][5] =	0x239672c0	;
	pattern_6[1][6] =	0x47ba7533	;
	pattern_6[1][7] =	0xcae4cd7f	;
	pattern_6[2][0] =	0xaed83f49	;
	pattern_6[2][1] =	0xd243a62c	;
	pattern_6[2][2] =	0xf8774a0b	;
	pattern_6[2][3] =	0x63d214e5	;
	pattern_6[2][4] =	0x3f6166d5	;
	pattern_6[2][5] =	0x239672c0	;
	pattern_6[2][6] =	0x47ba7533	;
	pattern_6[2][7] =	0xcae4cd7f	;
	pattern_6[3][0] =	0xae883f49	;
	pattern_6[3][1] =	0xd243a62c	;
	pattern_6[3][2] =	0xf8774a0b	;
	pattern_6[3][3] =	0x63d214e5	;
	pattern_6[3][4] =	0x3fc166d5	;
	pattern_6[3][5] =	0x239672c0	;
	pattern_6[3][6] =	0x47ba7533	;
	pattern_6[3][7] =	0xcae4cd7f	;
	//*/
	//*/
	start_addr=0x10000000;
	unsigned int			test_size = 0x20;
	unsigned int test_addr;
	unsigned int temp_i=0;
	unsigned int temp_k=0;
	unsigned int pattern_o[8];
	unsigned int pattern_d[8];
	{
		//  if(lflag)
		//      loop = 888;

		//if(old_pattern_flag==1)
		{

			printf("\nStart writing at 0x%08x - 0x%08x...\n", start_addr, start_addr + test_size);

			/*
			   for ((temp_k=0);(temp_k<4);(temp_k++)) {
			   {

			   for ((temp_i=0);(temp_i<8);(temp_i++))
			   {
			   test_addr=start_addr+(temp_i<<2);
			 *(volatile uint32_t *)(int_convter_p(test_addr))=des_pattern(temp_i,2,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
			//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
			//des[temp_i]^pattern_2[temp_k][temp_i]
			}
			//   _clean_dcache_addr(0x10000000);
			flush_dcache_range(start_addr,start_addr + test_size);

			for ((temp_i=0);(temp_i<8);(temp_i++)) {
			test_addr=start_addr+(temp_i<<2);
			pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
			//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_2[temp_k][temp_i]);
			//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
			//printf("\n0x%08x",pattern_5[temp_k][temp_i]);
			if (pattern_o[temp_i] != pattern_5[temp_k][temp_i])
			{error_count++;
			printf("p5Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), pattern_5[temp_k][temp_i],pattern_2[temp_k][temp_i]);
			}
			}
			}
			}
			*/
			//if(pattern_flag1==1)
			{
				for ((temp_k=0);(temp_k<4);(temp_k++))
				{
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_pattern(temp_i,1,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_1[temp_k][temp_i]);
							//  printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							//	  printf("\n0x%08x",pattern_4[temp_k][temp_i]);
							if (pattern_o[temp_i] != pattern_4[temp_k][temp_i])
							{error_count++;
								printf("p4Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), pattern_4[temp_k][temp_i],pattern_1[temp_k][temp_i]);
							}

						}
					}
				}
				for ((temp_k=0);(temp_k<4);(temp_k++))
				{
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_inv_pattern(temp_i,1,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_1[temp_k][temp_i]);
							//  printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							//	  printf("\n0x%08x",pattern_4[temp_k][temp_i]);
							pattern_d[temp_i]=des_xor_pattern((des[temp_i]),(pattern_o[temp_i]));
							if ((des_xor_pattern((des[temp_i]),(pattern_o[temp_i]))) != pattern_d[temp_i])
							{error_count++;
								printf("p4 invError data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), ~(pattern_4[temp_k][temp_i]),pattern_d[temp_i]);
							}

						}
					}
				}
			}
			//if(pattern_flag2==1)
			{
				for ((temp_k=0);(temp_k<4);(temp_k++)) {
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_pattern(temp_i,2,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_2[temp_k][temp_i]);
							//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							//printf("\n0x%08x",pattern_5[temp_k][temp_i]);
							if (pattern_o[temp_i] != pattern_5[temp_k][temp_i])
							{error_count++;
								printf("p5Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), pattern_5[temp_k][temp_i],pattern_2[temp_k][temp_i]);
							}
						}
					}
				}
				for ((temp_k=0);(temp_k<4);(temp_k++))
				{
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_inv_pattern(temp_i,2,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_2[temp_k][temp_i]);
							//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							//printf("\n0x%08x",pattern_5[temp_k][temp_i]);
							pattern_d[temp_i]=des_xor_pattern((des[temp_i]),(pattern_o[temp_i]));
							if ((des_xor_pattern((des[temp_i]),(pattern_o[temp_i]))) != pattern_d[temp_i])
							{error_count++;
								printf("p5 invError data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), ~(pattern_5[temp_k][temp_i]),pattern_d[temp_i]);
							}
						}
					}
				}

			}

			//	if(pattern_flag3==1)
			{
				for ((temp_k=0);(temp_k<4);(temp_k++)) {
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_pattern(temp_i,3,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_3[temp_k][temp_i]);
							//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							// printf("\n0x%08x",pattern_6[temp_k][temp_i]);
							if (pattern_o[temp_i] != pattern_6[temp_k][temp_i])
							{error_count++;
								printf("p6Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), pattern_6[temp_k][temp_i],pattern_3[temp_k][temp_i]);
							}
						}
					}
				}
				for ((temp_k=0);(temp_k<4);(temp_k++))
				{
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_inv_pattern(temp_i,3,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_3[temp_k][temp_i]);
							//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							// printf("\n0x%08x",pattern_6[temp_k][temp_i]);
							pattern_d[temp_i]=des_xor_pattern((des[temp_i]),(pattern_o[temp_i]));
							if ((des_xor_pattern((des[temp_i]),(pattern_o[temp_i]))) != pattern_d[temp_i])
							{error_count++;
								printf("p6 invError data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), ~(pattern_6[temp_k][temp_i]),pattern_d[temp_i]);
							}
						}
					}
				}
			}



		}

		printf("\Error count==0x%08x", error_count);
		printf("\n      \n");
	}

	if (error_count)
		return 1;
	else
		return 0;
}

int ddr_test_gx_training_pattern(int ddr_test_size)
{
	unsigned int  start_addr = 0x10000000;
	error_outof_count_flag=1;
	error_count=0;

	unsigned int  des[8] ;
	unsigned int  pattern_1[4][8] ;
	// unsigned int  pattern_2[4][8] ;
	// unsigned int  pattern_3[4][8] ;
	// unsigned int  pattern_4[4][8] ;
	// unsigned int  pattern_5[4][8] ;
	//unsigned int  pattern_6[4][8] ;

	des[0] = 	0xaec83f49;
	des[1] =      0xd243a62c;
	des[2] =      0xf8774a0b;
	des[3] =       0x63d214e5;
	des[4] =      0x3f4166d5;
	des[5] =     0x239672c0;
	des[6] =      0x47ba7533;
	des[7] =      0xcae4cd7f;
	/*
	   pattern_1[0][0] = 0x55005500;
	   pattern_1[0][1] = 0xaa00aa00;
	   pattern_1[0][2] = 0x55005500;
	   pattern_1[0][3] = 0xaa00aa00;
	   pattern_1[0][4] = 0x55005500;
	   pattern_1[0][5] = 0xaa00aa00;
	   pattern_1[0][6] = 0x55005500;
	   pattern_1[0][7] = 0xaa00aa00;

	   pattern_1[1][0] = 0x55005500;
	   pattern_1[1][1] = 0xaa00aa00;
	   pattern_1[1][2] = 0x55005500;
	   pattern_1[1][3] = 0xaa00aa00;
	   pattern_1[1][4] = 0x55005500;
	   pattern_1[1][5] = 0xaa00aa00;
	   pattern_1[1][6] = 0x55005500;
	   pattern_1[1][7] = 0xaa00aa00;

	   pattern_1[2][0] = 0x55005500;
	   pattern_1[2][1] = 0xaa00aa00;
	   pattern_1[2][2] = 0x55005500;
	   pattern_1[2][3] = 0xaa00aa00;
	   pattern_1[2][4] = 0x55005500;
	   pattern_1[2][5] = 0xaa00aa00;
	   pattern_1[2][6] = 0x55005500;
	   pattern_1[2][7] = 0xaa00aa00;

	   pattern_1[3][0] = 0x55005500;
	   pattern_1[3][1] = 0xaa00aa00;
	   pattern_1[3][2] = 0x55005500;
	   pattern_1[3][3] = 0xaa00aa00;
	   pattern_1[3][4] = 0x55005500;
	   pattern_1[3][5] = 0xaa00aa00;
	   pattern_1[3][6] = 0x55005500;
	   pattern_1[3][7] = 0xaa00aa00;
	   */
	// /*
	pattern_1[0][0] = 0x55aa5500;
	pattern_1[0][1] = 0x55aa5500;
	pattern_1[0][2] = 0x55aa5500;
	pattern_1[0][3] = 0x55aa5500;
	pattern_1[0][4] = 0xaa00ff00;
	pattern_1[0][5] = 0xaa00ff00;
	pattern_1[0][6] = 0xaa00ff00;
	pattern_1[0][7] = 0xaa00ff00;

	pattern_1[1][0] = 0x55005500;
	pattern_1[1][1] = 0xaa00aa00;
	pattern_1[1][2] = 0x55005500;
	pattern_1[1][3] = 0xaa00aa00;
	pattern_1[1][4] = 0x55005500;
	pattern_1[1][5] = 0xaa00aa00;
	pattern_1[1][6] = 0x55005500;
	pattern_1[1][7] = 0xaa00aa00;

	pattern_1[2][0] = 0x0001fe00;
	pattern_1[2][1] = 0x0000ff00;
	pattern_1[2][2] = 0x0000ff00;
	pattern_1[2][3] = 0x0000ff00;
	pattern_1[2][4] = 0x0002fd00;
	pattern_1[2][5] = 0x0000ff00;
	pattern_1[2][6] = 0x0000ff00;
	pattern_1[2][7] = 0x0000ff00;

	pattern_1[3][0] = 0x0004fb00;
	pattern_1[3][1] = 0x0000ff00;
	pattern_1[3][2] = 0x0000ff00;
	pattern_1[3][3] = 0x0000ff00;
	pattern_1[3][4] = 0x0008f700;
	pattern_1[3][5] = 0x0000ff00;
	pattern_1[3][6] = 0x0000ff00;
	pattern_1[3][7] = 0x0000ff00;
	//*/
	/*
	   pattern_2[0][0] = 0x0001fe00;
	   pattern_2[0][1] = 0x0000ff00;
	   pattern_2[0][2] = 0x0000ff00;
	   pattern_2[0][3] = 0x0000ff00;
	   pattern_2[0][4] = 0x0002fd00;
	   pattern_2[0][5] = 0x0000ff00;
	   pattern_2[0][6] = 0x0000ff00;
	   pattern_2[0][7] = 0x0000ff00;

	   pattern_2[1][0] = 0x0004fb00;
	   pattern_2[1][1] = 0x0000ff00;
	   pattern_2[1][2] = 0x0000ff00;
	   pattern_2[1][3] = 0x0000ff00;
	   pattern_2[1][4] = 0x0008f700;
	   pattern_2[1][5] = 0x0000ff00;
	   pattern_2[1][6] = 0x0000ff00;
	   pattern_2[1][7] = 0x0000ff00;

	   pattern_2[2][0] = 0x0010ef00;
	   pattern_2[2][1] = 0x0000ff00;
	   pattern_2[2][2] = 0x0000ff00;
	   pattern_2[2][3] = 0x0000ff00;
	   pattern_2[2][4] = 0x0020df00;
	   pattern_2[2][5] = 0x0000ff00;
	   pattern_2[2][6] = 0x0000ff00;
	   pattern_2[2][7] = 0x0000ff00;

	   pattern_2[3][0] = 0x0040bf00;
	   pattern_2[3][1] = 0x0000ff00;
	   pattern_2[3][2] = 0x0000ff00;
	   pattern_2[3][3] = 0x0000ff00;
	   pattern_2[3][4] = 0x00807f00;
	   pattern_2[3][5] = 0x0000ff00;
	   pattern_2[3][6] = 0x0000ff00;
	   pattern_2[3][7] = 0x0000ff00;

	   pattern_3[0][0] = 0x00010000;
	   pattern_3[0][1] = 0x00000000;
	   pattern_3[0][2] = 0x00000000;
	   pattern_3[0][3] = 0x00000000;
	   pattern_3[0][4] = 0x00020000;
	   pattern_3[0][5] = 0x00000000;
	   pattern_3[0][6] = 0x00000000;
	   pattern_3[0][7] = 0x00000000;

	   pattern_3[1][0] = 0x00040000;
	   pattern_3[1][1] = 0x00000000;
	   pattern_3[1][2] = 0x00000000;
	   pattern_3[1][3] = 0x00000000;
	   pattern_3[1][4] = 0x00080000;
	   pattern_3[1][5] = 0x00000000;
	   pattern_3[1][6] = 0x00000000;
	   pattern_3[1][7] = 0x00000000;

	   pattern_3[2][0] = 0x00100000;
	   pattern_3[2][1] = 0x00000000;
	   pattern_3[2][2] = 0x00000000;
	   pattern_3[2][3] = 0x00000000;
	   pattern_3[2][4] = 0x00200000;
	   pattern_3[2][5] = 0x00000000;
	   pattern_3[2][6] = 0x00000000;
	   pattern_3[2][7] = 0x00000000;

	   pattern_3[3][0] = 0x00400000;
	   pattern_3[3][1] = 0x00000000;
	   pattern_3[3][2] = 0x00000000;
	   pattern_3[3][3] = 0x00000000;
	   pattern_3[3][4] = 0x00800000;
	   pattern_3[3][5] = 0x00000000;
	   pattern_3[3][6] = 0x00000000;
	pattern_3[3][7] = 0x00000000;


	pattern_4[0][0] =	0x51c8c049	;
	pattern_4[0][1] =	0x2d43592c	;
	pattern_4[0][2] =	0x0777b50b	;
	pattern_4[0][3] =	0x9cd2ebe5	;
	pattern_4[0][4] =	0xc04199d5	;
	pattern_4[0][5] =	0xdc968dc0	;
	pattern_4[0][6] =	0xb8ba8a33	;
	pattern_4[0][7] =	0x35e4327f	;

	pattern_4[1][0] =	0xae37c049	;
	pattern_4[1][1] =	0xd2bc592c	;
	pattern_4[1][2] =	0xf888b50b	;
	pattern_4[1][3] =	0x632debe5	;
	pattern_4[1][4] =	0x3fbe99d5	;
	pattern_4[1][5] =	0x23698dc0	;
	pattern_4[1][6] =	0x47458a33	;
	pattern_4[1][7] =	0xca1b327f	;

	pattern_4[2][0] =	0x51373f49	;
	pattern_4[2][1] =	0x2dbca62c	;
	pattern_4[2][2] =	0x07884a0b	;
	pattern_4[2][3] =	0x9c2d14e5	;
	pattern_4[2][4] =	0xc0be66d5	;
	pattern_4[2][5] =	0xdc6972c0	;
	pattern_4[2][6] =	0xb8457533	;
	pattern_4[2][7] =	0x351bcd7f	;


	pattern_4[3][0] =	0x51c8c049	;
	pattern_4[3][1] =	0x2d43592c	;
	pattern_4[3][2] =	0x0777b50b	;
	pattern_4[3][3] =	0x9cd2ebe5	;
	pattern_4[3][4] =	0xc04199d5	;
	pattern_4[3][5] =	0xdc968dc0	;
	pattern_4[3][6] =	0xb8ba8a33	;
	pattern_4[3][7] =	0x35e4327f	;

	pattern_5[0][0] =	0xaec9c149	;
	pattern_5[0][1] =	0xd243592c	;
	pattern_5[0][2] =	0xf877b50b	;
	pattern_5[0][3] =	0x63d2ebe5	;
	pattern_5[0][4] =	0x3f439bd5	;
	pattern_5[0][5] =	0x23968dc0	;
	pattern_5[0][6] =	0x47ba8a33	;
	pattern_5[0][7] =	0xcae4327f	;
	pattern_5[1][0] =	0xaeccc449	;
	pattern_5[1][1] =	0xd243592c	;
	pattern_5[1][2] =	0xf877b50b	;
	pattern_5[1][3] =	0x63d2ebe5	;
	pattern_5[1][4] =	0x3f4991d5	;
	pattern_5[1][5] =	0x23968dc0	;
	pattern_5[1][6] =	0x47ba8a33	;
	pattern_5[1][7] =	0xcae4327f	;
	pattern_5[2][0] =	0xaed8d049	;
	pattern_5[2][1] =	0xd243592c	;
	pattern_5[2][2] =	0xf877b50b	;
	pattern_5[2][3] =	0x63d2ebe5	;
	pattern_5[2][4] =	0x3f61b9d5	;
	pattern_5[2][5] =	0x23968dc0	;
	pattern_5[2][6] =	0x47ba8a33	;
	pattern_5[2][7] =	0xcae4327f	;
	pattern_5[3][0] =	0xae888049	;
	pattern_5[3][1] =	0xd243592c	;
	pattern_5[3][2] =	0xf877b50b	;
	pattern_5[3][3] =	0x63d2ebe5	;
	pattern_5[3][4] =	0x3fc119d5	;
	pattern_5[3][5] =	0x23968dc0	;
	pattern_5[3][6] =	0x47ba8a33	;
	pattern_5[3][7] =	0xcae4327f	;

	pattern_6[0][0] =   0xaec93f49   ;
	pattern_6[0][1] =	0xd243a62c	;
	pattern_6[0][2] =	0xf8774a0b	;
	pattern_6[0][3] =	0x63d214e5	;
	pattern_6[0][4] =	0x3f4366d5	;
	pattern_6[0][5] =	0x239672c0	;
	pattern_6[0][6] =	0x47ba7533	;
	pattern_6[0][7] =	0xcae4cd7f	;
	pattern_6[1][0] =	0xaecc3f49	;
	pattern_6[1][1] =	0xd243a62c	;
	pattern_6[1][2] =	0xf8774a0b	;
	pattern_6[1][3] =	0x63d214e5	;
	pattern_6[1][4] =	0x3f4966d5	;
	pattern_6[1][5] =	0x239672c0	;
	pattern_6[1][6] =	0x47ba7533	;
	pattern_6[1][7] =	0xcae4cd7f	;
	pattern_6[2][0] =	0xaed83f49	;
	pattern_6[2][1] =	0xd243a62c	;
	pattern_6[2][2] =	0xf8774a0b	;
	pattern_6[2][3] =	0x63d214e5	;
	pattern_6[2][4] =	0x3f6166d5	;
	pattern_6[2][5] =	0x239672c0	;
	pattern_6[2][6] =	0x47ba7533	;
	pattern_6[2][7] =	0xcae4cd7f	;
	pattern_6[3][0] =	0xae883f49	;
	pattern_6[3][1] =	0xd243a62c	;
	pattern_6[3][2] =	0xf8774a0b	;
	pattern_6[3][3] =	0x63d214e5	;
	pattern_6[3][4] =	0x3fc166d5	;
	pattern_6[3][5] =	0x239672c0	;
	pattern_6[3][6] =	0x47ba7533	;
	pattern_6[3][7] =	0xcae4cd7f	;
	*/
		//*/
		//*/
		start_addr=0x10000000;
	unsigned int			test_size = 0x20;
	unsigned int test_addr;
	unsigned int temp_i=0;
	unsigned int temp_k=0;
	unsigned int pattern_o[8];
	unsigned int pattern_d[8];
	{
		//  if(lflag)
		//      loop = 888;

		//if(old_pattern_flag==1)
		{

			printf("\nStart writing at 0x%08x - 0x%08x...\n", start_addr, start_addr + test_size);

			/*
			   for ((temp_k=0);(temp_k<4);(temp_k++)) {
			   {

			   for ((temp_i=0);(temp_i<8);(temp_i++))
			   {
			   test_addr=start_addr+(temp_i<<2);
			 *(volatile uint32_t *)(int_convter_p(test_addr))=des_pattern(temp_i,2,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
			//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
			//des[temp_i]^pattern_2[temp_k][temp_i]
			}
			//   _clean_dcache_addr(0x10000000);
			flush_dcache_range(start_addr,start_addr + test_size);

			for ((temp_i=0);(temp_i<8);(temp_i++)) {
			test_addr=start_addr+(temp_i<<2);
			pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
			//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_2[temp_k][temp_i]);
			//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
			//printf("\n0x%08x",pattern_5[temp_k][temp_i]);
			if (pattern_o[temp_i] != pattern_5[temp_k][temp_i])
			{error_count++;
			printf("p5Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), pattern_5[temp_k][temp_i],pattern_2[temp_k][temp_i]);
			}
			}
			}
			}
			*/
			//if(pattern_flag1==1)
			{
				for ((temp_k=0);(temp_k<4);(temp_k++))
				{
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_pattern(temp_i,1,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_1[temp_k][temp_i]);
							//  printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							//	  printf("\n0x%08x",pattern_4[temp_k][temp_i]);
							if ((pattern_o[temp_i]) != (des_pattern(temp_i,1,temp_k,temp_i)))
							{error_count++;
								//                printf("p4Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), pattern_4[temp_k][temp_i],pattern_1[temp_k][temp_i]);
								printf("p4Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), des_pattern(temp_i,1,temp_k,temp_i),pattern_1[temp_k][temp_i]);
							}


						}
					}
				}

				for ((temp_k=0);(temp_k<4);(temp_k++))
				{
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_inv_pattern(temp_i,1,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_1[temp_k][temp_i]);
							//  printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							//	  printf("\n0x%08x",pattern_4[temp_k][temp_i]);
							pattern_d[temp_i]=des_xor_pattern((des[temp_i]),(pattern_o[temp_i]));
							if ((des_xor_pattern((des[temp_i]),des_inv_pattern(temp_i,1,temp_k,temp_i))) != pattern_d[temp_i])
							{error_count++;
								printf("p4 invError data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",
										pattern_o[temp_i], p_convter_int(test_addr), ~(pattern_1[temp_k][temp_i]),pattern_d[temp_i]);
							}

						}
					}
				}

			}
		}

		printf("\Error count==0x%08x", error_count);
		printf("\n      \n");
	}
	if (error_count)
		return 1;
	else
		return 0;
}

#endif

static void ddr_write_pattern4_cross_talk_p(void *buff,  unsigned int  m_length)
{
	unsigned int  *p;
	//    unsigned int  i, j, n;
	unsigned int  i, n;
	unsigned int  m_len = m_length;
	//#define ddr_pattern_loop 32
	p = ( unsigned int  *)buff;

	while (m_len)
	{
		//  for(j=0;j<32;j++)
		{
			if (m_len >= 128*4)
				n = 32*4;
			else
				n = m_len>>2;

			for (i = 0; i < n; i++)
			{
#ifdef DDR_PREFETCH_CACHE
				ddr_pld_cache(p)  ;
#endif
				switch (i)
				{
					case 0:
					case 1:
					case 2:
					case 3:
					case 8:
					case 9:
					case 10:
					case 11:
					case 16:
					case 17:
					case 18:
					case 19:
					case 24:
					case 25:
					case 26:
					case 27:
						//   case 30:
						*(p+i) = TDATA32F;
						break;
					case 4:
					case 5:
					case 6:
					case 7:
					case 12:
					case 13:
					case 14:
					case 15:
					case 20:
					case 21:
					case 22:
					case 23:
					case 28:
					case 29:
					case 30:
					case 31:
						//   case 22:
						*(p+i) = 0;
						break;
					case DDR_PATTERN_LOOP_1+0:
					case DDR_PATTERN_LOOP_1+1:
					case DDR_PATTERN_LOOP_1+2:
					case DDR_PATTERN_LOOP_1+3:
					case DDR_PATTERN_LOOP_1+8:
					case DDR_PATTERN_LOOP_1+9:
					case DDR_PATTERN_LOOP_1+10:
					case DDR_PATTERN_LOOP_1+11:
					case DDR_PATTERN_LOOP_1+16:
					case DDR_PATTERN_LOOP_1+17:
					case DDR_PATTERN_LOOP_1+18:
					case DDR_PATTERN_LOOP_1+19:
					case DDR_PATTERN_LOOP_1+24:
					case DDR_PATTERN_LOOP_1+25:
					case DDR_PATTERN_LOOP_1+26:
					case DDR_PATTERN_LOOP_1+27:
						//   case 30:
						*(p+i) = TDATA32A;
						break;
					case DDR_PATTERN_LOOP_1+4:
					case DDR_PATTERN_LOOP_1+5:
					case DDR_PATTERN_LOOP_1+6:
					case DDR_PATTERN_LOOP_1+7:
					case DDR_PATTERN_LOOP_1+12:
					case DDR_PATTERN_LOOP_1+13:
					case DDR_PATTERN_LOOP_1+14:
					case DDR_PATTERN_LOOP_1+15:
					case DDR_PATTERN_LOOP_1+20:
					case DDR_PATTERN_LOOP_1+21:
					case DDR_PATTERN_LOOP_1+22:
					case DDR_PATTERN_LOOP_1+23:
					case DDR_PATTERN_LOOP_1+28:
					case DDR_PATTERN_LOOP_1+29:
					case DDR_PATTERN_LOOP_1+30:
					case DDR_PATTERN_LOOP_1+31:
						*(p+i) = TDATA325;


						break;
					case DDR_PATTERN_LOOP_2+0:
					case DDR_PATTERN_LOOP_2+1:
					case DDR_PATTERN_LOOP_2+2:
					case DDR_PATTERN_LOOP_2+3:
						*(p+i) =0xfe01fe01;
						break;
					case DDR_PATTERN_LOOP_2+4:
					case DDR_PATTERN_LOOP_2+5:
					case DDR_PATTERN_LOOP_2+6:
					case DDR_PATTERN_LOOP_2+7:
						*(p+i) =0xfd02fd02;
						break;
					case DDR_PATTERN_LOOP_2+8:
					case DDR_PATTERN_LOOP_2+9:
					case DDR_PATTERN_LOOP_2+10:
					case DDR_PATTERN_LOOP_2+11:
						*(p+i) =0xfb04fb04;
						break;
					case DDR_PATTERN_LOOP_2+12:
					case DDR_PATTERN_LOOP_2+13:
					case DDR_PATTERN_LOOP_2+14:
					case DDR_PATTERN_LOOP_2+15:
						*(p+i) =0xf708f708;
						break;
					case DDR_PATTERN_LOOP_2+16:
					case DDR_PATTERN_LOOP_2+17:
					case DDR_PATTERN_LOOP_2+18:
					case DDR_PATTERN_LOOP_2+19:
						*(p+i) =0xef10ef10;
						break;
					case DDR_PATTERN_LOOP_2+20:
					case DDR_PATTERN_LOOP_2+21:
					case DDR_PATTERN_LOOP_2+22:
					case DDR_PATTERN_LOOP_2+23:
						*(p+i) =0xdf20df20;
						break;
					case DDR_PATTERN_LOOP_2+24:
					case DDR_PATTERN_LOOP_2+25:
					case DDR_PATTERN_LOOP_2+26:
					case DDR_PATTERN_LOOP_2+27:
						*(p+i) =0xbf40bf40;
						break;
					case DDR_PATTERN_LOOP_2+28:
					case DDR_PATTERN_LOOP_2+29:
					case DDR_PATTERN_LOOP_2+30:
					case DDR_PATTERN_LOOP_2+31:
						*(p+i) =0x7f807f80;
						break;
					case DDR_PATTERN_LOOP_3+0:
					case DDR_PATTERN_LOOP_3+1:
					case DDR_PATTERN_LOOP_3+2:
					case DDR_PATTERN_LOOP_3+3:
						*(p+i) =0x00000100;
						break;
					case DDR_PATTERN_LOOP_3+4:
					case DDR_PATTERN_LOOP_3+5:
					case DDR_PATTERN_LOOP_3+6:
					case DDR_PATTERN_LOOP_3+7:
						*(p+i) =0x00000200;
						break;
					case DDR_PATTERN_LOOP_3+8:
					case DDR_PATTERN_LOOP_3+9:
					case DDR_PATTERN_LOOP_3+10:
					case DDR_PATTERN_LOOP_3+11:
						*(p+i) =0x00000400;
						break;
					case DDR_PATTERN_LOOP_3+12:
					case DDR_PATTERN_LOOP_3+13:
					case DDR_PATTERN_LOOP_3+14:
					case DDR_PATTERN_LOOP_3+15:
						*(p+i) =0x00000800;
						break;
					case DDR_PATTERN_LOOP_3+16:
					case DDR_PATTERN_LOOP_3+17:
					case DDR_PATTERN_LOOP_3+18:
					case DDR_PATTERN_LOOP_3+19:
						*(p+i) =0x00001000;
						break;
					case DDR_PATTERN_LOOP_3+20:
					case DDR_PATTERN_LOOP_3+21:
					case DDR_PATTERN_LOOP_3+22:
					case DDR_PATTERN_LOOP_3+23:
						*(p+i) =0x00002000;
						break;
					case DDR_PATTERN_LOOP_3+24:
					case DDR_PATTERN_LOOP_3+25:
					case DDR_PATTERN_LOOP_3+26:
					case DDR_PATTERN_LOOP_3+27:
						*(p+i) =0x00004000;
						break;
					case DDR_PATTERN_LOOP_3+28:
					case DDR_PATTERN_LOOP_3+29:
					case DDR_PATTERN_LOOP_3+30:
					case DDR_PATTERN_LOOP_3+31:
						*(p+i) =0x00008000;
						break;


				}
			}

			if (m_len >( 128*4))
			{
				m_len -=( 128*4);
				p += 32*4;
			}
			else
			{
				p += (m_len>>2);
				m_len = 0;
				break;
			}
		}
	}
}

static void ddr_write_pattern4_cross_talk_p2(void *buff,  unsigned int  m_length)
{
	unsigned int  *p;
	//    unsigned int  i, j, n;
	unsigned int  i, n;
	unsigned int  m_len = m_length;
	//#define ddr_pattern_loop 32
	p = ( unsigned int  *)buff;

	while (m_len)
	{
		//  for(j=0;j<32;j++)
		{
			if (m_len >= 128*4)
				n = 32*4;
			else
				n = m_len>>2;

			for (i = 0; i < n; i++)
			{
#ifdef DDR_PREFETCH_CACHE
				ddr_pld_cache(p)  ;
#endif

				switch (i)
				{

					case 0:
					case DDR_PATTERN_LOOP_1+1:
					case DDR_PATTERN_LOOP_2+2:
					case DDR_PATTERN_LOOP_3+3:
						*(p+i) = 0xfe01fe01;
						break;
					case 4:
					case DDR_PATTERN_LOOP_1+5:
					case DDR_PATTERN_LOOP_2+6:
					case DDR_PATTERN_LOOP_3+7:
						*(p+i) = 0xfd02fd02;
						break;

					case 8:
					case DDR_PATTERN_LOOP_1+9:
					case DDR_PATTERN_LOOP_2+10:
					case DDR_PATTERN_LOOP_3+11:
						*(p+i) = 0xfb04fb04;
						break;

					case 12:
					case DDR_PATTERN_LOOP_1+13:
					case DDR_PATTERN_LOOP_2+14:
					case DDR_PATTERN_LOOP_3+15:
						*(p+i) = 0xf708f708;
						break;

					case 16:
					case DDR_PATTERN_LOOP_1+17:
					case DDR_PATTERN_LOOP_2+18:
					case DDR_PATTERN_LOOP_3+19:
						*(p+i) = 0xef10ef10;
						break;

					case 20:
					case DDR_PATTERN_LOOP_1+21:
					case DDR_PATTERN_LOOP_2+22:
					case DDR_PATTERN_LOOP_3+23:
						*(p+i) = 0xdf20df20;
						break;

					case 24:
					case DDR_PATTERN_LOOP_1+25:
					case DDR_PATTERN_LOOP_2+26:
					case DDR_PATTERN_LOOP_3+27:
						*(p+i) = 0xbf40bf40;
						break;

					case 28:
					case DDR_PATTERN_LOOP_1+29:
					case DDR_PATTERN_LOOP_2+30:
					case DDR_PATTERN_LOOP_3+31:
						*(p+i) = 0x7f807f80;
						break;


					default:

						*(p+i) = 0xff00ff00;
						break;

						break;


				}
			}

			if (m_len >( 128*4))
			{
				m_len -=( 128*4);
				p += 32*4;
			}
			else
			{
				p += (m_len>>2);
				m_len = 0;
				break;
			}
		}
	}
}
static void ddr_read_pattern4_cross_talk_p(void *buff,  unsigned int  m_length)
{
	unsigned int  *p;
	//   unsigned int  i, j, n;
	unsigned int  i, n;
	unsigned int  m_len = m_length;

	p = ( unsigned int  *)buff;

	while (m_len)
	{
		//  for(j=0;j<32;j++)
		{
			if (m_len >= 128*4)
				n = 32*4;
			else
				n = m_len>>2;

			for (i = 0; i < n; i++)
			{
#ifdef DDR_PREFETCH_CACHE
				ddr_pld_cache(p)  ;
#endif
				if ((error_outof_count_flag) && (error_count))
				{
					printf("Error data out of count");
					m_len=0;
					break;
				}

				switch (i)
				{

					case 0:
					case 1:
					case 2:
					case 3:
					case 8:
					case 9:
					case 10:
					case 11:
					case 16:
					case 17:
					case 18:
					case 19:
					case 24:
					case 25:
					case 26:
					case 27:
						//   case 30:
						//      *(p+i) = TDATA32F;
						if (*(p+i) != TDATA32F)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), TDATA32F);
							break;
						}
						break;
					case 4:
					case 5:
					case 6:
					case 7:
					case 12:
					case 13:
					case 14:
					case 15:
					case 20:
					case 21:
					case 22:
					case 23:
					case 28:
					case 29:
					case 30:
					case 31:
						//   case 22:
						//   *(p+i) = 0;
						if (*(p+i) != 0)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0);
							break;}
						break;
					case DDR_PATTERN_LOOP_1+0:
					case DDR_PATTERN_LOOP_1+1:
					case DDR_PATTERN_LOOP_1+2:
					case DDR_PATTERN_LOOP_1+3:
					case DDR_PATTERN_LOOP_1+8:
					case DDR_PATTERN_LOOP_1+9:
					case DDR_PATTERN_LOOP_1+10:
					case DDR_PATTERN_LOOP_1+11:
					case DDR_PATTERN_LOOP_1+16:
					case DDR_PATTERN_LOOP_1+17:
					case DDR_PATTERN_LOOP_1+18:
					case DDR_PATTERN_LOOP_1+19:
					case DDR_PATTERN_LOOP_1+24:
					case DDR_PATTERN_LOOP_1+25:
					case DDR_PATTERN_LOOP_1+26:
					case DDR_PATTERN_LOOP_1+27:
						//   case 30:
						//        *(p+i) = TDATA32A;
						if (*(p+i) != TDATA32A)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), TDATA32A);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_1+4:
					case DDR_PATTERN_LOOP_1+5:
					case DDR_PATTERN_LOOP_1+6:
					case DDR_PATTERN_LOOP_1+7:
					case DDR_PATTERN_LOOP_1+12:
					case DDR_PATTERN_LOOP_1+13:
					case DDR_PATTERN_LOOP_1+14:
					case DDR_PATTERN_LOOP_1+15:
					case DDR_PATTERN_LOOP_1+20:
					case DDR_PATTERN_LOOP_1+21:
					case DDR_PATTERN_LOOP_1+22:
					case DDR_PATTERN_LOOP_1+23:
					case DDR_PATTERN_LOOP_1+28:
					case DDR_PATTERN_LOOP_1+29:
					case DDR_PATTERN_LOOP_1+30:
					case DDR_PATTERN_LOOP_1+31:
						//	*(p+i) = TDATA325;
						if (*(p+i) != TDATA325)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), TDATA325);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_2+0:
					case DDR_PATTERN_LOOP_2+1:
					case DDR_PATTERN_LOOP_2+2:
					case DDR_PATTERN_LOOP_2+3:
						//   	*(p+i) =0xfe01fe01;
						if (*(p+i) !=0xfe01fe01)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xfe01fe01);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_2+4:
					case DDR_PATTERN_LOOP_2+5:
					case DDR_PATTERN_LOOP_2+6:
					case DDR_PATTERN_LOOP_2+7:
						// 	*(p+i) =0xfd02fd02;
						if (*(p+i) != 0xfd02fd02)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xfd02fd02);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_2+8:
					case DDR_PATTERN_LOOP_2+9:
					case DDR_PATTERN_LOOP_2+10:
					case DDR_PATTERN_LOOP_2+11:
						//	*(p+i) =0xfb04fb04;
						if (*(p+i) != 0xfb04fb04)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xfb04fb04);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_2+12:
					case DDR_PATTERN_LOOP_2+13:
					case DDR_PATTERN_LOOP_2+14:
					case DDR_PATTERN_LOOP_2+15:
						//	*(p+i) =0xf7b08f708;
						if (*(p+i) != 0xf708f708)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xf708f708);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_2+16:
					case DDR_PATTERN_LOOP_2+17:
					case DDR_PATTERN_LOOP_2+18:
					case DDR_PATTERN_LOOP_2+19:
						//	*(p+i) =0xef10ef10;
						if (*(p+i) != 0xef10ef10)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xef10ef10);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_2+20:
					case DDR_PATTERN_LOOP_2+21:
					case DDR_PATTERN_LOOP_2+22:
					case DDR_PATTERN_LOOP_2+23:
						//	*(p+i) =0xdf20df20;
						if (*(p+i) != 0xdf20df20)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xdf20df20);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_2+24:
					case DDR_PATTERN_LOOP_2+25:
					case DDR_PATTERN_LOOP_2+26:
					case DDR_PATTERN_LOOP_2+27:
						//  	*(p+i) =0xbf40bf40;
						if (*(p+i) != 0xbf40bf40)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xbf40bf40);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_2+28:
					case DDR_PATTERN_LOOP_2+29:
					case DDR_PATTERN_LOOP_2+30:
					case DDR_PATTERN_LOOP_2+31:
						//   	*(p+i) =0x7f807f80;
						if (*(p+i) != 0x7f807f80)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x7f807f80);
							break;

						}
						break;
					case DDR_PATTERN_LOOP_3+0:
					case DDR_PATTERN_LOOP_3+1:
					case DDR_PATTERN_LOOP_3+2:
					case DDR_PATTERN_LOOP_3+3:
						//	*(p+i) =0x00000100;
						if (*(p+i) != 0x00000100)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x00000100);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_3+4:
					case DDR_PATTERN_LOOP_3+5:
					case DDR_PATTERN_LOOP_3+6:
					case DDR_PATTERN_LOOP_3+7:
						//  	*(p+i) =0x00000100;
						if (*(p+i) != 0x00000200)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x00000200);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_3+8:
					case DDR_PATTERN_LOOP_3+9:
					case DDR_PATTERN_LOOP_3+10:
					case DDR_PATTERN_LOOP_3+11:
						//	*(p+i) =0x00000100;
						if (*(p+i) != 0x00000400)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x00000400);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_3+12:
					case DDR_PATTERN_LOOP_3+13:
					case DDR_PATTERN_LOOP_3+14:
					case DDR_PATTERN_LOOP_3+15:
						//	*(p+i) =0x00000100;
						if (*(p+i) != 0x00000800)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x00000800);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_3+16:
					case DDR_PATTERN_LOOP_3+17:
					case DDR_PATTERN_LOOP_3+18:
					case DDR_PATTERN_LOOP_3+19:
						//	*(p+i) =0xfffffeff;
						if (*(p+i) != 0x00001000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x00001000);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_3+20:
					case DDR_PATTERN_LOOP_3+21:
					case DDR_PATTERN_LOOP_3+22:
					case DDR_PATTERN_LOOP_3+23:
						// 	*(p+i) =0xfffffeff;
						if (*(p+i) != 0x00002000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x00002000);

						} break;
					case DDR_PATTERN_LOOP_3+24:
					case DDR_PATTERN_LOOP_3+25:
					case DDR_PATTERN_LOOP_3+26:
					case DDR_PATTERN_LOOP_3+27:
						//	*(p+i) =0xfffffeff;
						if (*(p+i) != 0x00004000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x00004000);
							break;
						}
						break;
					case DDR_PATTERN_LOOP_3+28:
					case DDR_PATTERN_LOOP_3+29:
					case DDR_PATTERN_LOOP_3+30:
					case DDR_PATTERN_LOOP_3+31:
						//	*(p+i) =0xfffffeff;
						if (*(p+i) != 0x00008000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x00008000);
							break;
						}
						break;



				}
			}

			if (m_len > 128*4)
			{
				m_len -= 128*4;
				p += 32*4;
			}
			else
			{
				p += (m_len>>2);
				m_len = 0;
				break;
			}
		}
	}
}
//*/
static void ddr_read_pattern4_cross_talk_p2(void *buff,  unsigned int  m_length)
{
	unsigned int  *p;
	//   unsigned int  i, j, n;
	unsigned int  i, n;
	unsigned int  m_len = m_length;

	p = ( unsigned int  *)buff;

	while (m_len)
	{
		//  for(j=0;j<32;j++)
		{
			if (m_len >= 128*4)
				n = 32*4;
			else
				n = m_len>>2;

			for (i = 0; i < n; i++)
			{
#ifdef DDR_PREFETCH_CACHE
				ddr_pld_cache(p)  ;
#endif
				if ((error_outof_count_flag) && (error_count))
				{
					printf("Error data out of count");
					m_len=0;
					break;
				}

				switch (i)
				{
					case 0:
					case DDR_PATTERN_LOOP_1+1:
					case DDR_PATTERN_LOOP_2+2:
					case DDR_PATTERN_LOOP_3+3:
						//   *(p+i) = 0xfe01fe01;
						if (*(p+i) != 0xfe01fe01)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xfe01fe01);
							break;
						}
						break;
					case 4:
					case DDR_PATTERN_LOOP_1+5:
					case DDR_PATTERN_LOOP_2+6:
					case DDR_PATTERN_LOOP_3+7:
						//	   *(p+i) = 0xfd02fd02;
						if (*(p+i) != 0xfd02fd02)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xfd02fd02);
							break;
						}
						break;

					case 8:
					case DDR_PATTERN_LOOP_1+9:
					case DDR_PATTERN_LOOP_2+10:
					case DDR_PATTERN_LOOP_3+11:
						//   *(p+i) = 0xfb04fb04;
						if (*(p+i) != 0xfb04fb04)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xfb04fb04);
							break;
						}
						break;

					case 12:
					case DDR_PATTERN_LOOP_1+13:
					case DDR_PATTERN_LOOP_2+14:
					case DDR_PATTERN_LOOP_3+15:
						//	   *(p+i) = 0xf708f708;
						if (*(p+i) != 0xf708f708)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xf708f708);
							break;
						}
						break;

					case 16:
					case DDR_PATTERN_LOOP_1+17:
					case DDR_PATTERN_LOOP_2+18:
					case DDR_PATTERN_LOOP_3+19:
						//	   *(p+i) = 0xef10ef10;
						if (*(p+i) != 0xef10ef10)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xef10ef10);
							break;
						}
						break;

					case 20:
					case DDR_PATTERN_LOOP_1+21:
					case DDR_PATTERN_LOOP_2+22:
					case DDR_PATTERN_LOOP_3+23:
						//   *(p+i) = 0xdf20df20;
						if (*(p+i) != 0xdf20df20)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xdf20df20);
							break;
						}
						break;

					case 24:
					case DDR_PATTERN_LOOP_1+25:
					case DDR_PATTERN_LOOP_2+26:
					case DDR_PATTERN_LOOP_3+27:
						//	   *(p+i) = 0xbf40bf40;
						if (*(p+i) != 0xbf40bf40)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xbf40bf40);
							break;
						}
						break;
					case 28:
					case DDR_PATTERN_LOOP_1+29:
					case DDR_PATTERN_LOOP_2+30:
					case DDR_PATTERN_LOOP_3+31:
						//	   *(p+i) = 0x7f807f80;
						if (*(p+i) != 0x7f807f80)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x7f807f80);
							break;
						}
						break;


					default:

						//  *(p+i) = 0xff00ff00;
						if (*(p+i) != 0xff00ff00)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xff00ff00);
							break;
						}
						break;

						break;


				}
			}

			if (m_len > 128*4)
			{
				m_len -= 128*4;
				p += 32*4;
			}
			else
			{
				p += (m_len>>2);
				m_len = 0;
				break;
			}
		}
	}
}

static void ddr_write_pattern4_cross_talk_n(void *buff,  unsigned int  m_length)
{
	unsigned int  *p;
	//    unsigned int  i, j, n;
	unsigned int  i, n;
	unsigned int  m_len = m_length;
	//#define ddr_pattern_loop 32
	p = ( unsigned int  *)buff;

	while (m_len)
	{
		//  for(j=0;j<32;j++)
		{
			if (m_len >= 128*4)
				n = 32*4;
			else
				n = m_len>>2;

			for (i = 0; i < n; i++)
			{
#ifdef DDR_PREFETCH_CACHE
				ddr_pld_cache(p)  ;
#endif
				switch (i)
				{
					case 0:
					case 1:
					case 2:
					case 3:
					case 8:
					case 9:
					case 10:
					case 11:
					case 16:
					case 17:
					case 18:
					case 19:
					case 24:
					case 25:
					case 26:
					case 27:
						//   case 30:
						*(p+i) = ~TDATA32F;
						break;
					case 4:
					case 5:
					case 6:
					case 7:
					case 12:
					case 13:
					case 14:
					case 15:
					case 20:
					case 21:
					case 22:
					case 23:
					case 28:
					case 29:
					case 30:
					case 31:
						//   case 22:
						*(p+i) = ~0;
						break;
					case DDR_PATTERN_LOOP_1+0:
					case DDR_PATTERN_LOOP_1+1:
					case DDR_PATTERN_LOOP_1+2:
					case DDR_PATTERN_LOOP_1+3:
					case DDR_PATTERN_LOOP_1+8:
					case DDR_PATTERN_LOOP_1+9:
					case DDR_PATTERN_LOOP_1+10:
					case DDR_PATTERN_LOOP_1+11:
					case DDR_PATTERN_LOOP_1+16:
					case DDR_PATTERN_LOOP_1+17:
					case DDR_PATTERN_LOOP_1+18:
					case DDR_PATTERN_LOOP_1+19:
					case DDR_PATTERN_LOOP_1+24:
					case DDR_PATTERN_LOOP_1+25:
					case DDR_PATTERN_LOOP_1+26:
					case DDR_PATTERN_LOOP_1+27:
						//   case 30:
						*(p+i) = ~TDATA32A;
						break;
					case DDR_PATTERN_LOOP_1+4:
					case DDR_PATTERN_LOOP_1+5:
					case DDR_PATTERN_LOOP_1+6:
					case DDR_PATTERN_LOOP_1+7:
					case DDR_PATTERN_LOOP_1+12:
					case DDR_PATTERN_LOOP_1+13:
					case DDR_PATTERN_LOOP_1+14:
					case DDR_PATTERN_LOOP_1+15:
					case DDR_PATTERN_LOOP_1+20:
					case DDR_PATTERN_LOOP_1+21:
					case DDR_PATTERN_LOOP_1+22:
					case DDR_PATTERN_LOOP_1+23:
					case DDR_PATTERN_LOOP_1+28:
					case DDR_PATTERN_LOOP_1+29:
					case DDR_PATTERN_LOOP_1+30:
					case DDR_PATTERN_LOOP_1+31:
						*(p+i) =~TDATA325;


						break;
					case DDR_PATTERN_LOOP_2+0:
					case DDR_PATTERN_LOOP_2+1:
					case DDR_PATTERN_LOOP_2+2:
					case DDR_PATTERN_LOOP_2+3:
						*(p+i) =~0xfe01fe01;
						break;
					case DDR_PATTERN_LOOP_2+4:
					case DDR_PATTERN_LOOP_2+5:
					case DDR_PATTERN_LOOP_2+6:
					case DDR_PATTERN_LOOP_2+7:
						*(p+i) =~0xfd02fd02;
						break;
					case DDR_PATTERN_LOOP_2+8:
					case DDR_PATTERN_LOOP_2+9:
					case DDR_PATTERN_LOOP_2+10:
					case DDR_PATTERN_LOOP_2+11:
						*(p+i) =~0xfb04fb04;
						break;
					case DDR_PATTERN_LOOP_2+12:
					case DDR_PATTERN_LOOP_2+13:
					case DDR_PATTERN_LOOP_2+14:
					case DDR_PATTERN_LOOP_2+15:
						*(p+i) =~0xf708f708;
						break;
					case DDR_PATTERN_LOOP_2+16:
					case DDR_PATTERN_LOOP_2+17:
					case DDR_PATTERN_LOOP_2+18:
					case DDR_PATTERN_LOOP_2+19:
						*(p+i) =~0xef10ef10;
						break;
					case DDR_PATTERN_LOOP_2+20:
					case DDR_PATTERN_LOOP_2+21:
					case DDR_PATTERN_LOOP_2+22:
					case DDR_PATTERN_LOOP_2+23:
						*(p+i) =~0xdf20df20;
						break;
					case DDR_PATTERN_LOOP_2+24:
					case DDR_PATTERN_LOOP_2+25:
					case DDR_PATTERN_LOOP_2+26:
					case DDR_PATTERN_LOOP_2+27:
						*(p+i) =~0xbf40bf40;
						break;
					case DDR_PATTERN_LOOP_2+28:
					case DDR_PATTERN_LOOP_2+29:
					case DDR_PATTERN_LOOP_2+30:
					case DDR_PATTERN_LOOP_2+31:
						*(p+i) =~0x7f807f80;
						break;
					case DDR_PATTERN_LOOP_3+0:
					case DDR_PATTERN_LOOP_3+1:
					case DDR_PATTERN_LOOP_3+2:
					case DDR_PATTERN_LOOP_3+3:
						*(p+i) =~0x00000100;
						break;
					case DDR_PATTERN_LOOP_3+4:
					case DDR_PATTERN_LOOP_3+5:
					case DDR_PATTERN_LOOP_3+6:
					case DDR_PATTERN_LOOP_3+7:
						*(p+i) =~0x00000200;
						break;
					case DDR_PATTERN_LOOP_3+8:
					case DDR_PATTERN_LOOP_3+9:
					case DDR_PATTERN_LOOP_3+10:
					case DDR_PATTERN_LOOP_3+11:
						*(p+i) =~0x00000400;
						break;
					case DDR_PATTERN_LOOP_3+12:
					case DDR_PATTERN_LOOP_3+13:
					case DDR_PATTERN_LOOP_3+14:
					case DDR_PATTERN_LOOP_3+15:
						*(p+i) =~0x00000800;
						break;
					case DDR_PATTERN_LOOP_3+16:
					case DDR_PATTERN_LOOP_3+17:
					case DDR_PATTERN_LOOP_3+18:
					case DDR_PATTERN_LOOP_3+19:
						*(p+i) =~0x00001000;
						break;
					case DDR_PATTERN_LOOP_3+20:
					case DDR_PATTERN_LOOP_3+21:
					case DDR_PATTERN_LOOP_3+22:
					case DDR_PATTERN_LOOP_3+23:
						*(p+i) =~0x00002000;
						break;
					case DDR_PATTERN_LOOP_3+24:
					case DDR_PATTERN_LOOP_3+25:
					case DDR_PATTERN_LOOP_3+26:
					case DDR_PATTERN_LOOP_3+27:
						*(p+i) =~0x00004000;
						break;
					case DDR_PATTERN_LOOP_3+28:
					case DDR_PATTERN_LOOP_3+29:
					case DDR_PATTERN_LOOP_3+30:
					case DDR_PATTERN_LOOP_3+31:
						*(p+i) =~0x00008000;
						break;


				}
			}

			if (m_len >( 128*4))
			{
				m_len -=( 128*4);
				p += 32*4;
			}
			else
			{
				p += (m_len>>2);
				m_len = 0;
				break;
			}
		}
	}
}


static void ddr_write_pattern4_cross_talk_n2(void *buff,  unsigned int  m_length)
{
	unsigned int  *p;
	//    unsigned int  i, j, n;
	unsigned int  i, n;
	unsigned int  m_len = m_length;
	//#define ddr_pattern_loop 32
	p = ( unsigned int  *)buff;

	while (m_len)
	{
		//  for(j=0;j<32;j++)
		{
			if (m_len >= 128*4)
				n = 32*4;
			else
				n = m_len>>2;

			for (i = 0; i < n; i++)
			{
#ifdef DDR_PREFETCH_CACHE
				ddr_pld_cache(p)  ;
#endif

				switch (i)
				{
					case 0:
					case DDR_PATTERN_LOOP_1+1:
					case DDR_PATTERN_LOOP_2+2:
					case DDR_PATTERN_LOOP_3+3:
						*(p+i) = ~0xfe01fe01;
						break;
					case 4:
					case DDR_PATTERN_LOOP_1+5:
					case DDR_PATTERN_LOOP_2+6:
					case DDR_PATTERN_LOOP_3+7:
						*(p+i) = ~0xfd02fd02;
						break;

					case 8:
					case DDR_PATTERN_LOOP_1+9:
					case DDR_PATTERN_LOOP_2+10:
					case DDR_PATTERN_LOOP_3+11:
						*(p+i) = ~0xfb04fb04;
						break;

					case 12:
					case DDR_PATTERN_LOOP_1+13:
					case DDR_PATTERN_LOOP_2+14:
					case DDR_PATTERN_LOOP_3+15:
						*(p+i) = ~0xf708f708;
						break;

					case 16:
					case DDR_PATTERN_LOOP_1+17:
					case DDR_PATTERN_LOOP_2+18:
					case DDR_PATTERN_LOOP_3+19:
						*(p+i) = ~0xef10ef10;
						break;

					case 20:
					case DDR_PATTERN_LOOP_1+21:
					case DDR_PATTERN_LOOP_2+22:
					case DDR_PATTERN_LOOP_3+23:
						*(p+i) = ~0xdf20df20;
						break;

					case 24:
					case DDR_PATTERN_LOOP_1+25:
					case DDR_PATTERN_LOOP_2+26:
					case DDR_PATTERN_LOOP_3+27:
						*(p+i) =~0xbf40bf40;
						break;
					case 28:
					case DDR_PATTERN_LOOP_1+29:
					case DDR_PATTERN_LOOP_2+30:
					case DDR_PATTERN_LOOP_3+31:
						*(p+i) = ~0x7f807f80;
						break;


					default:

						*(p+i) = ~0xff00ff00;
						break;

						break;


				}
			}

			if (m_len >( 128*4))
			{
				m_len -=( 128*4);
				p += 32*4;
			}
			else
			{
				p += (m_len>>2);
				m_len = 0;
				break;
			}
		}
	}
}

static void ddr_read_pattern4_cross_talk_n(void *buff,  unsigned int  m_length)
{
	unsigned int  *p;
	//   unsigned int  i, j, n;
	unsigned int  i, n;
	unsigned int  m_len = m_length;

	p = ( unsigned int  *)buff;

	while (m_len)
	{
		//  for(j=0;j<32;j++)
		{
			if (m_len >= 128*4)
				n = 32*4;
			else
				n = m_len>>2;

			for (i = 0; i < n; i++)
			{
#ifdef DDR_PREFETCH_CACHE
				ddr_pld_cache(p)  ;
#endif
				if ((error_outof_count_flag) && (error_count))
				{
					printf("Error data out of count");
					m_len=0;
					break;
				}
				switch (i)
				{
					case 0:
					case 1:
					case 2:
					case 3:
					case 8:
					case 9:
					case 10:
					case 11:
					case 16:
					case 17:
					case 18:
					case 19:
					case 24:
					case 25:
					case 26:
					case 27:
						//   case 30:
						//      *(p+i) = TDATA32F;
						if (*(p+i) !=~TDATA32F)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~TDATA32F);
							break;
						}
						break;
					case 4:
					case 5:
					case 6:
					case 7:
					case 12:
					case 13:
					case 14:
					case 15:
					case 20:
					case 21:
					case 22:
					case 23:
					case 28:
					case 29:
					case 30:
					case 31:
						//   case 22:
						//   *(p+i) = 0;
						if (*(p+i) !=~0)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0);
						}
						break;
					case DDR_PATTERN_LOOP_1+0:
					case DDR_PATTERN_LOOP_1+1:
					case DDR_PATTERN_LOOP_1+2:
					case DDR_PATTERN_LOOP_1+3:
					case DDR_PATTERN_LOOP_1+8:
					case DDR_PATTERN_LOOP_1+9:
					case DDR_PATTERN_LOOP_1+10:
					case DDR_PATTERN_LOOP_1+11:
					case DDR_PATTERN_LOOP_1+16:
					case DDR_PATTERN_LOOP_1+17:
					case DDR_PATTERN_LOOP_1+18:
					case DDR_PATTERN_LOOP_1+19:
					case DDR_PATTERN_LOOP_1+24:
					case DDR_PATTERN_LOOP_1+25:
					case DDR_PATTERN_LOOP_1+26:
					case DDR_PATTERN_LOOP_1+27:
						//   case 30:
						//        *(p+i) = TDATA32A;
						if (*(p+i) != ~TDATA32A)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i),~TDATA32A);
						}
						break;
					case DDR_PATTERN_LOOP_1+4:
					case DDR_PATTERN_LOOP_1+5:
					case DDR_PATTERN_LOOP_1+6:
					case DDR_PATTERN_LOOP_1+7:
					case DDR_PATTERN_LOOP_1+12:
					case DDR_PATTERN_LOOP_1+13:
					case DDR_PATTERN_LOOP_1+14:
					case DDR_PATTERN_LOOP_1+15:
					case DDR_PATTERN_LOOP_1+20:
					case DDR_PATTERN_LOOP_1+21:
					case DDR_PATTERN_LOOP_1+22:
					case DDR_PATTERN_LOOP_1+23:
					case DDR_PATTERN_LOOP_1+28:
					case DDR_PATTERN_LOOP_1+29:
					case DDR_PATTERN_LOOP_1+30:
					case DDR_PATTERN_LOOP_1+31:
						//	*(p+i) = TDATA325;
						if (*(p+i) != ~TDATA325)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~TDATA325);
						}
						break;
					case DDR_PATTERN_LOOP_2+0:
					case DDR_PATTERN_LOOP_2+1:
					case DDR_PATTERN_LOOP_2+2:
					case DDR_PATTERN_LOOP_2+3:
						//   	*(p+i) =0xfe01fe01;
						if (*(p+i) !=~0xfe01fe01)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xfe01fe01);
						}
						break;
					case DDR_PATTERN_LOOP_2+4:
					case DDR_PATTERN_LOOP_2+5:
					case DDR_PATTERN_LOOP_2+6:
					case DDR_PATTERN_LOOP_2+7:
						// 	*(p+i) =0xfd02fd02;
						if (*(p+i) != ~0xfd02fd02)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xfd02fd02);
						}
						break;

					case DDR_PATTERN_LOOP_2+8:
					case DDR_PATTERN_LOOP_2+9:
					case DDR_PATTERN_LOOP_2+10:
					case DDR_PATTERN_LOOP_2+11:
						//	*(p+i) =0xfb04fb04;
						if (*(p+i) != ~0xfb04fb04)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xfb04fb04);
						}
						break;
					case DDR_PATTERN_LOOP_2+12:
					case DDR_PATTERN_LOOP_2+13:
					case DDR_PATTERN_LOOP_2+14:
					case DDR_PATTERN_LOOP_2+15:
						//	*(p+i) =0xf7b08f708;
						if (*(p+i) != ~0xf708f708)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xf708f708);
						}
						break;
					case DDR_PATTERN_LOOP_2+16:
					case DDR_PATTERN_LOOP_2+17:
					case DDR_PATTERN_LOOP_2+18:
					case DDR_PATTERN_LOOP_2+19:
						//	*(p+i) =0xef10ef10;
						if (*(p+i) != ~0xef10ef10)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xef10ef10);
						}
						break;
					case DDR_PATTERN_LOOP_2+20:
					case DDR_PATTERN_LOOP_2+21:
					case DDR_PATTERN_LOOP_2+22:
					case DDR_PATTERN_LOOP_2+23:
						//	*(p+i) =0xdf20df20;
						if (*(p+i) != ~0xdf20df20)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xdf20df20);
						}
						break;
					case DDR_PATTERN_LOOP_2+24:
					case DDR_PATTERN_LOOP_2+25:
					case DDR_PATTERN_LOOP_2+26:
					case DDR_PATTERN_LOOP_2+27:
						//  	*(p+i) =0xbf40bf40;
						if (*(p+i) != ~0xbf40bf40)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xbf40bf40);
						}
						break;
					case DDR_PATTERN_LOOP_2+28:
					case DDR_PATTERN_LOOP_2+29:
					case DDR_PATTERN_LOOP_2+30:
					case DDR_PATTERN_LOOP_2+31:
						//   	*(p+i) =0x7f807f80;
						if (*(p+i) != ~0x7f807f80)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x7f807f80);
						}
						break;
						break;
					case DDR_PATTERN_LOOP_3+0:
					case DDR_PATTERN_LOOP_3+1:
					case DDR_PATTERN_LOOP_3+2:
					case DDR_PATTERN_LOOP_3+3:
						//	*(p+i) =0x00000100;
						if (*(p+i) != ~0x00000100)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x00000100);
						}
						break;
					case DDR_PATTERN_LOOP_3+4:
					case DDR_PATTERN_LOOP_3+5:
					case DDR_PATTERN_LOOP_3+6:
					case DDR_PATTERN_LOOP_3+7:
						//  	*(p+i) =0x00000100;
						if (*(p+i) != ~0x00000200)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x00000200);
						}
						break;
					case DDR_PATTERN_LOOP_3+8:
					case DDR_PATTERN_LOOP_3+9:
					case DDR_PATTERN_LOOP_3+10:
					case DDR_PATTERN_LOOP_3+11:
						//	*(p+i) =0x00000100;
						if (*(p+i) != ~0x00000400)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x00000400);
						}
						break;
					case DDR_PATTERN_LOOP_3+12:
					case DDR_PATTERN_LOOP_3+13:
					case DDR_PATTERN_LOOP_3+14:
					case DDR_PATTERN_LOOP_3+15:
						//	*(p+i) =0x00000100;
						if (*(p+i) != ~0x00000800)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x00000800);
						}
						break;
					case DDR_PATTERN_LOOP_3+16:
					case DDR_PATTERN_LOOP_3+17:
					case DDR_PATTERN_LOOP_3+18:
					case DDR_PATTERN_LOOP_3+19:
						//	*(p+i) =0xfffffeff;
						if (*(p+i) != ~0x00001000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x00001000);
						}
						break;
					case DDR_PATTERN_LOOP_3+20:
					case DDR_PATTERN_LOOP_3+21:
					case DDR_PATTERN_LOOP_3+22:
					case DDR_PATTERN_LOOP_3+23:
						// 	*(p+i) =0xfffffeff;
						if (*(p+i) != ~0x00002000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x00002000);
						}
						break;
					case DDR_PATTERN_LOOP_3+24:
					case DDR_PATTERN_LOOP_3+25:
					case DDR_PATTERN_LOOP_3+26:
					case DDR_PATTERN_LOOP_3+27:
						//	*(p+i) =0xfffffeff;
						if (*(p+i) != ~0x00004000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x00004000);
						}
						break;
					case DDR_PATTERN_LOOP_3+28:
					case DDR_PATTERN_LOOP_3+29:
					case DDR_PATTERN_LOOP_3+30:
					case DDR_PATTERN_LOOP_3+31:
						//	*(p+i) =0xfffffeff;
						if (*(p+i) != ~0x00008000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x00008000);
						}
						break;



				}
			}

			if (m_len > 128*4)
			{
				m_len -= 128*4;
				p += 32*4;
			}
			else
			{
				p += (m_len>>2);
				m_len = 0;
				break;
			}
		}
	}
}


//*/
static void ddr_read_pattern4_cross_talk_n2(void *buff,  unsigned int  m_length)
{
	unsigned int  *p;
	//   unsigned int  i, j, n;
	unsigned int  i, n;
	unsigned int  m_len = m_length;

	p = ( unsigned int  *)buff;

	while (m_len)
	{
		//  for(j=0;j<32;j++)
		{
			if (m_len >= 128*4)
				n = 32*4;
			else
				n = m_len>>2;

			for (i = 0; i < n; i++)
			{
#ifdef DDR_PREFETCH_CACHE
				ddr_pld_cache(p)  ;
#endif
				if ((error_outof_count_flag) && (error_count))
				{
					printf("Error data out of count");
					m_len=0;
					break;
				}

				switch (i)
				{
					case 0:
					case DDR_PATTERN_LOOP_1+1:
					case DDR_PATTERN_LOOP_2+2:
					case DDR_PATTERN_LOOP_3+3:
						//   *(p+i) = 0xfe01fe01;
						if (*(p+i) != ~0xfe01fe01)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xfe01fe01);
							break;
						}
						break;
					case 4:
					case DDR_PATTERN_LOOP_1+5:
					case DDR_PATTERN_LOOP_2+6:
					case DDR_PATTERN_LOOP_3+7:
						//	   *(p+i) = 0xfd02fd02;
						if (*(p+i) != ~0xfd02fd02)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xfd02fd02);
							break;
						}
						break;

					case 8:
					case DDR_PATTERN_LOOP_1+9:
					case DDR_PATTERN_LOOP_2+10:
					case DDR_PATTERN_LOOP_3+11:
						//   *(p+i) = 0xfb04fb04;
						if (*(p+i) != ~0xfb04fb04)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xfb04fb04);
							break;
						}
						break;

					case 12:
					case DDR_PATTERN_LOOP_1+13:
					case DDR_PATTERN_LOOP_2+14:
					case DDR_PATTERN_LOOP_3+15:
						//	   *(p+i) = 0xf708f708;
						if (*(p+i) != ~0xf708f708)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xf708f708);
							break;
						}
						break;

					case 16:
					case DDR_PATTERN_LOOP_1+17:
					case DDR_PATTERN_LOOP_2+18:
					case DDR_PATTERN_LOOP_3+19:
						//	   *(p+i) = 0xef10ef10;
						if (*(p+i) != ~0xef10ef10)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xef10ef10);
							break;
						}
						break;

					case 20:
					case DDR_PATTERN_LOOP_1+21:
					case DDR_PATTERN_LOOP_2+22:
					case DDR_PATTERN_LOOP_3+23:
						//   *(p+i) = 0xdf20df20;
						if (*(p+i) != ~0xdf20df20)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xdf20df20);
							break;
						}
						break;

					case 24:
					case DDR_PATTERN_LOOP_1+25:
					case DDR_PATTERN_LOOP_2+26:
					case DDR_PATTERN_LOOP_3+27:
						//	   *(p+i) = 0xbf40bf40;
						if (*(p+i) != ~0xbf40bf40)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xbf40bf40);
							break;
						}
						break;
					case 28:
					case DDR_PATTERN_LOOP_1+29:
					case DDR_PATTERN_LOOP_2+30:
					case DDR_PATTERN_LOOP_3+31:
						//	   *(p+i) = 0x7f807f80;
						if (*(p+i) != ~0x7f807f80)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x7f807f80);
							break;
						}
						break;


					default:

						//  *(p+i) = 0xff00ff00;
						if (*(p+i) != ~0xff00ff00)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xff00ff00);
							break;
						}
						break;

						break;


				}
			}

			if (m_len > 128*4)
			{
				m_len -= 128*4;
				p += 32*4;
			}
			else
			{
				p += (m_len>>2);
				m_len = 0;
				break;
			}
		}
	}
}

static void ddr_write_pattern4_no_cross_talk(void *buff,  unsigned int  m_length)
{
	unsigned int  *p;
	//    unsigned int  i, j, n;
	unsigned int  i, n;
	unsigned int  m_len = m_length;
	//#define ddr_pattern_loop 32
	p = ( unsigned int  *)buff;

	while (m_len)
	{
		//  for(j=0;j<32;j++)
		{
			if (m_len >= 128*4)
				n = 32*4;
			else
				n = m_len>>2;

			for (i = 0; i < n; i++)
			{
#ifdef DDR_PREFETCH_CACHE
				ddr_pld_cache(p)  ;
#endif
				switch (i)
				{
					case 0:
					case 1:
					case 2:
					case 3:
						*(p+i) = 0xff00ff00;
						break;
					case 4:
					case 5:
					case 6:
					case 7:
						*(p+i) = 0xffff0000;
						break;

					case 8:
					case 9:
					case 10:
					case 11:
						*(p+i) = 0xff000000;
						break;
					case 12:
					case 13:
					case 14:
					case 15:
						*(p+i) = 0xff00ffff;
						break;

					case 16:
					case 17:
					case 18:
					case 19:
						*(p+i) = 0xff00ffff;
						break;
					case 20:
					case 21:
					case 22:
					case 23:
						*(p+i) = 0xff0000ff;
						break;
					case 24:
					case 25:
					case 26:
					case 27:
						*(p+i) = 0xffff0000;
						break;

					case 28:
					case 29:
					case 30:
					case 31:
						*(p+i) = 0x00ff00ff;
						break;
					case DDR_PATTERN_LOOP_1+0:
					case DDR_PATTERN_LOOP_1+1:
					case DDR_PATTERN_LOOP_1+2:
					case DDR_PATTERN_LOOP_1+3:
						*(p+i) =~0xff00ff00;
						break;
					case DDR_PATTERN_LOOP_1+4:
					case DDR_PATTERN_LOOP_1+5:
					case DDR_PATTERN_LOOP_1+6:
					case DDR_PATTERN_LOOP_1+7:
						*(p+i) =~0xffff0000;
						break;
					case DDR_PATTERN_LOOP_1+8:
					case DDR_PATTERN_LOOP_1+9:
					case DDR_PATTERN_LOOP_1+10:
					case DDR_PATTERN_LOOP_1+11:
						*(p+i) =~0xff000000;
						break;
					case DDR_PATTERN_LOOP_1+12:
					case DDR_PATTERN_LOOP_1+13:
					case DDR_PATTERN_LOOP_1+14:
					case DDR_PATTERN_LOOP_1+15:
						*(p+i) =~0xff00ffff;
						break;
					case DDR_PATTERN_LOOP_1+16:
					case DDR_PATTERN_LOOP_1+17:
					case DDR_PATTERN_LOOP_1+18:
					case DDR_PATTERN_LOOP_1+19:
						*(p+i) =~0xff00ffff;
						break;
					case DDR_PATTERN_LOOP_1+20:
					case DDR_PATTERN_LOOP_1+21:
					case DDR_PATTERN_LOOP_1+22:
					case DDR_PATTERN_LOOP_1+23:
						*(p+i) =~0xff00ffff;
						break;
					case DDR_PATTERN_LOOP_1+24:
					case DDR_PATTERN_LOOP_1+25:
					case DDR_PATTERN_LOOP_1+26:
					case DDR_PATTERN_LOOP_1+27:
						*(p+i) =~0xffff0000;
						break;
					case DDR_PATTERN_LOOP_1+28:
					case DDR_PATTERN_LOOP_1+29:
					case DDR_PATTERN_LOOP_1+30:
					case DDR_PATTERN_LOOP_1+31:
						*(p+i) =~0x00ff00ff;
						break;

					case DDR_PATTERN_LOOP_2+0:
					case DDR_PATTERN_LOOP_2+1:
					case DDR_PATTERN_LOOP_2+2:
					case DDR_PATTERN_LOOP_2+3:
						*(p+i) =0x00ff0000;
						break;
					case DDR_PATTERN_LOOP_2+4:
					case DDR_PATTERN_LOOP_2+5:
					case DDR_PATTERN_LOOP_2+6:
					case DDR_PATTERN_LOOP_2+7:
						*(p+i) =0xff000000;
						break;
					case DDR_PATTERN_LOOP_2+8:
					case DDR_PATTERN_LOOP_2+9:
					case DDR_PATTERN_LOOP_2+10:
					case DDR_PATTERN_LOOP_2+11:
						*(p+i) =0x0000ffff;
						break;
					case DDR_PATTERN_LOOP_2+12:
					case DDR_PATTERN_LOOP_2+13:
					case DDR_PATTERN_LOOP_2+14:
					case DDR_PATTERN_LOOP_2+15:
						*(p+i) =0x000000ff;
						break;
					case DDR_PATTERN_LOOP_2+16:
					case DDR_PATTERN_LOOP_2+17:
					case DDR_PATTERN_LOOP_2+18:
					case DDR_PATTERN_LOOP_2+19:
						*(p+i) =0x00ff00ff;
						break;
					case DDR_PATTERN_LOOP_2+20:
					case DDR_PATTERN_LOOP_2+21:
					case DDR_PATTERN_LOOP_2+22:
					case DDR_PATTERN_LOOP_2+23:
						*(p+i) =0xff00ff00;
						break;
					case DDR_PATTERN_LOOP_2+24:
					case DDR_PATTERN_LOOP_2+25:
					case DDR_PATTERN_LOOP_2+26:
					case DDR_PATTERN_LOOP_2+27:
						*(p+i) =0xff00ffff;
						break;
					case DDR_PATTERN_LOOP_2+28:
					case DDR_PATTERN_LOOP_2+29:
					case DDR_PATTERN_LOOP_2+30:
					case DDR_PATTERN_LOOP_2+31:
						*(p+i) =0xff00ff00;
						break;
					case DDR_PATTERN_LOOP_3+0:
					case DDR_PATTERN_LOOP_3+1:
					case DDR_PATTERN_LOOP_3+2:
					case DDR_PATTERN_LOOP_3+3:
						*(p+i) =~0x00ff0000;
						break;
					case DDR_PATTERN_LOOP_3+4:
					case DDR_PATTERN_LOOP_3+5:
					case DDR_PATTERN_LOOP_3+6:
					case DDR_PATTERN_LOOP_3+7:
						*(p+i) =~0xff000000;
						break;
					case DDR_PATTERN_LOOP_3+8:
					case DDR_PATTERN_LOOP_3+9:
					case DDR_PATTERN_LOOP_3+10:
					case DDR_PATTERN_LOOP_3+11:
						*(p+i) =~0x0000ffff;
						break;
					case DDR_PATTERN_LOOP_3+12:
					case DDR_PATTERN_LOOP_3+13:
					case DDR_PATTERN_LOOP_3+14:
					case DDR_PATTERN_LOOP_3+15:
						*(p+i) =~0x000000ff;
						break;
					case DDR_PATTERN_LOOP_3+16:
					case DDR_PATTERN_LOOP_3+17:
					case DDR_PATTERN_LOOP_3+18:
					case DDR_PATTERN_LOOP_3+19:
						*(p+i) =~0x00ff00ff;
						break;
					case DDR_PATTERN_LOOP_3+20:
					case DDR_PATTERN_LOOP_3+21:
					case DDR_PATTERN_LOOP_3+22:
					case DDR_PATTERN_LOOP_3+23:
						*(p+i) =~0xff00ff00;
						break;
					case DDR_PATTERN_LOOP_3+24:
					case DDR_PATTERN_LOOP_3+25:
					case DDR_PATTERN_LOOP_3+26:
					case DDR_PATTERN_LOOP_3+27:
						*(p+i) =~0xff00ffff;
						break;
					case DDR_PATTERN_LOOP_3+28:
					case DDR_PATTERN_LOOP_3+29:
					case DDR_PATTERN_LOOP_3+30:
					case DDR_PATTERN_LOOP_3+31:
						*(p+i) =~0xff00ff00;
						break;


				}
			}

			if (m_len >( 128*4))
			{
				m_len -=( 128*4);
				p += 32*4;
			}
			else
			{
				p += (m_len>>2);
				m_len = 0;
				break;
			}
		}
	}
}

static void ddr_read_pattern4_no_cross_talk(void *buff,  unsigned int  m_length)
{
	unsigned int  *p;
	//   unsigned int  i, j, n;
	unsigned int  i, n;
	unsigned int  m_len = m_length;

	p = ( unsigned int  *)buff;
	while (m_len)
	{
		//  for(j=0;j<32;j++)
		{
			if (m_len >= 128*4)
				n = 32*4;
			else
				n = m_len>>2;

			for (i = 0; i < n; i++)
			{
#ifdef DDR_PREFETCH_CACHE
				ddr_pld_cache(p)  ;
#endif
				if ((error_outof_count_flag) && (error_count))
				{
					printf("Error data out of count");
					m_len=0;
					break;
				}
				switch (i)
				{
					case 0:
					case 1:
					case 2:
					case 3:
						//	  if(*(p+i) !=~TDATA32F)

						if ( *(p+i) != 0xff00ff00)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xff00ff00);
						}
						break;
					case 4:
					case 5:
					case 6:
					case 7:
						if ( *(p+i) != 0xffff0000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xffff0000);
						}
						break;

					case 8:
					case 9:
					case 10:
					case 11:
						// *(p+i) = 0xff000000;
						if ( *(p+i) != 0xff000000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xff000000);
						}
						break;
					case 12:
					case 13:
					case 14:
					case 15:
						// *(p+i) = 0xff00ffff;
						if ( *(p+i) != 0xff00ffff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xff00ffff);
						}
						break;

					case 16:
					case 17:
					case 18:
					case 19:
						//	 *(p+i) = 0xff00ffff;
						if ( *(p+i) != 0xff00ffff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xff00ffff);
						}
						break;
					case 20:
					case 21:
					case 22:
					case 23:
						//  *(p+i) = 0xff0000ff;
						if ( *(p+i) != 0xff0000ff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xff0000ff);
						}
						break;
					case 24:
					case 25:
					case 26:
					case 27:
						//  *(p+i) = 0xffff0000;
						if ( *(p+i) != 0xffff0000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xffff0000);
						}
						break;

					case 28:
					case 29:
					case 30:
					case 31:
						//  *(p+i) = 0x00ff00ff;
						if ( *(p+i) != 0x00ff00ff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x00ff00ff);
						}
						break;
					case DDR_PATTERN_LOOP_1+0:
					case DDR_PATTERN_LOOP_1+1:
					case DDR_PATTERN_LOOP_1+2:
					case DDR_PATTERN_LOOP_1+3:
						//  	*(p+i) =~0xff00ff00;
						if ( *(p+i) != ~0xff00ff00)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xff00ff00);
						}
						break;
					case DDR_PATTERN_LOOP_1+4:
					case DDR_PATTERN_LOOP_1+5:
					case DDR_PATTERN_LOOP_1+6:
					case DDR_PATTERN_LOOP_1+7:
						// 	*(p+i) =~0xffff0000;
						if ( *(p+i) != ~0xffff0000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xffff0000);
						}
						break;
					case DDR_PATTERN_LOOP_1+8:
					case DDR_PATTERN_LOOP_1+9:
					case DDR_PATTERN_LOOP_1+10:
					case DDR_PATTERN_LOOP_1+11:
						// 	*(p+i) =~0xff000000;
						if ( *(p+i) != ~0xff000000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xff000000);
						}
						break;
					case DDR_PATTERN_LOOP_1+12:
					case DDR_PATTERN_LOOP_1+13:
					case DDR_PATTERN_LOOP_1+14:
					case DDR_PATTERN_LOOP_1+15:
						//	*(p+i) =~0xff00ffff;
						if ( *(p+i) != ~0xff00ffff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xff00ffff);
						}
						break;
					case DDR_PATTERN_LOOP_1+16:
					case DDR_PATTERN_LOOP_1+17:
					case DDR_PATTERN_LOOP_1+18:
					case DDR_PATTERN_LOOP_1+19:
						//	*(p+i) =~0xff00ffff;
						if ( *(p+i) != ~0xff00ffff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xff00ffff);
						}
						break;
					case DDR_PATTERN_LOOP_1+20:
					case DDR_PATTERN_LOOP_1+21:
					case DDR_PATTERN_LOOP_1+22:
					case DDR_PATTERN_LOOP_1+23:
						//	*(p+i) =~0xff00ffff;
						if ( *(p+i) != ~0xff00ffff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xff00ffff);
						}
						break;
					case DDR_PATTERN_LOOP_1+24:
					case DDR_PATTERN_LOOP_1+25:
					case DDR_PATTERN_LOOP_1+26:
					case DDR_PATTERN_LOOP_1+27:
						//	*(p+i) =~0xffff0000;
						if ( *(p+i) != ~0xffff0000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xffff0000);
						}
						break;
					case DDR_PATTERN_LOOP_1+28:
					case DDR_PATTERN_LOOP_1+29:
					case DDR_PATTERN_LOOP_1+30:
					case DDR_PATTERN_LOOP_1+31:
						//  	*(p+i) =~0x00ff00ff;
						if ( *(p+i) != ~0x00ff00ff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x00ff00ff);
						}
						break;

					case DDR_PATTERN_LOOP_2+0:
					case DDR_PATTERN_LOOP_2+1:
					case DDR_PATTERN_LOOP_2+2:
					case DDR_PATTERN_LOOP_2+3:
						//  	*(p+i) =0x00ff0000;
						if ( *(p+i) != 0x00ff0000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x00ff0000);
						}
						break;
					case DDR_PATTERN_LOOP_2+4:
					case DDR_PATTERN_LOOP_2+5:
					case DDR_PATTERN_LOOP_2+6:
					case DDR_PATTERN_LOOP_2+7:
						//   	*(p+i) =0xff000000;
						if ( *(p+i) != 0xff000000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xff000000);
						}
						break;
					case DDR_PATTERN_LOOP_2+8:
					case DDR_PATTERN_LOOP_2+9:
					case DDR_PATTERN_LOOP_2+10:
					case DDR_PATTERN_LOOP_2+11:
						// 	*(p+i) =0x0000ffff;
						if ( *(p+i) != 0x0000ffff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x0000ffff);
						}
						break;
					case DDR_PATTERN_LOOP_2+12:
					case DDR_PATTERN_LOOP_2+13:
					case DDR_PATTERN_LOOP_2+14:
					case DDR_PATTERN_LOOP_2+15:
						//   	*(p+i) =0x000000ff;
						if ( *(p+i) != 0x000000ff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x000000ff);
						}
						break;
					case DDR_PATTERN_LOOP_2+16:
					case DDR_PATTERN_LOOP_2+17:
					case DDR_PATTERN_LOOP_2+18:
					case DDR_PATTERN_LOOP_2+19:
						//   	*(p+i) =0x00ff00ff;
						if ( *(p+i) != 0x00ff00ff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0x00ff00ff);
						}
						break;
					case DDR_PATTERN_LOOP_2+20:
					case DDR_PATTERN_LOOP_2+21:
					case DDR_PATTERN_LOOP_2+22:
					case DDR_PATTERN_LOOP_2+23:
						//	*(p+i) =0xff00ff00;
						if ( *(p+i) != 0xff00ff00)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xff00ff00);
						}
						break;
					case DDR_PATTERN_LOOP_2+24:
					case DDR_PATTERN_LOOP_2+25:
					case DDR_PATTERN_LOOP_2+26:
					case DDR_PATTERN_LOOP_2+27:
						//   	*(p+i) =0xff00ffff;
						if ( *(p+i) != 0xff00ffff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xff00ffff);
						}
						break;
					case DDR_PATTERN_LOOP_2+28:
					case DDR_PATTERN_LOOP_2+29:
					case DDR_PATTERN_LOOP_2+30:
					case DDR_PATTERN_LOOP_2+31:
						//	   	*(p+i) =0xff00ff00;
						if ( *(p+i) != 0xff00ff00)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), 0xff00ff00);
						}
						break;
					case DDR_PATTERN_LOOP_3+0:
					case DDR_PATTERN_LOOP_3+1:
					case DDR_PATTERN_LOOP_3+2:
					case DDR_PATTERN_LOOP_3+3:
						//	*(p+i) =~0x00ff0000;
						if ( *(p+i) != ~0x00ff0000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x00ff0000);
						}
						break;
					case DDR_PATTERN_LOOP_3+4:
					case DDR_PATTERN_LOOP_3+5:
					case DDR_PATTERN_LOOP_3+6:
					case DDR_PATTERN_LOOP_3+7:
						//   	*(p+i) =~0xff000000;
						if ( *(p+i) != ~0xff000000)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xff000000);
						}
						break;
					case DDR_PATTERN_LOOP_3+8:
					case DDR_PATTERN_LOOP_3+9:
					case DDR_PATTERN_LOOP_3+10:
					case DDR_PATTERN_LOOP_3+11:
						//  	*(p+i) =~0x0000ffff;
						if ( *(p+i) != ~0x0000ffff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x0000ffff);
						}
						break;
					case DDR_PATTERN_LOOP_3+12:
					case DDR_PATTERN_LOOP_3+13:
					case DDR_PATTERN_LOOP_3+14:
					case DDR_PATTERN_LOOP_3+15:
						//   	*(p+i) =~0x000000ff;
						if ( *(p+i) != ~0x000000ff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x000000ff);
						}
						break;
					case DDR_PATTERN_LOOP_3+16:
					case DDR_PATTERN_LOOP_3+17:
					case DDR_PATTERN_LOOP_3+18:
					case DDR_PATTERN_LOOP_3+19:
						//   	*(p+i) =~0x00ff00ff;
						if ( *(p+i) != ~0x00ff00ff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0x00ff00ff);
						}
						break;
					case DDR_PATTERN_LOOP_3+20:
					case DDR_PATTERN_LOOP_3+21:
					case DDR_PATTERN_LOOP_3+22:
					case DDR_PATTERN_LOOP_3+23:
						//	*(p+i) =~0xff00ff00;
						if ( *(p+i) != ~0xff00ff00)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xff00ff00);
						}
						break;
					case DDR_PATTERN_LOOP_3+24:
					case DDR_PATTERN_LOOP_3+25:
					case DDR_PATTERN_LOOP_3+26:
					case DDR_PATTERN_LOOP_3+27:
						//  	*(p+i) =~0xff00ffff;
						if ( *(p+i) != ~0xff00ffff)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xff00ffff);
						}
						break;
					case DDR_PATTERN_LOOP_3+28:
					case DDR_PATTERN_LOOP_3+29:
					case DDR_PATTERN_LOOP_3+30:
					case DDR_PATTERN_LOOP_3+31:
						//   	*(p+i) =~0xff00ff00;
						if ( *(p+i) != ~0xff00ff00)
						{error_count++;
							printf("Error data [0x%08x] at offset 0x%08x[0x%08x]\n", *(p+i), p_convter_int(p + i), ~0xff00ff00);
						}
						break;


				}
			}

			if (m_len >( 128*4))
			{
				m_len -=( 128*4);
				p += 32*4;
			}
			else
			{
				p += (m_len>>2);
				m_len = 0;
				break;
			}
		}
	}
}



int do_ddr_test(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	char *endp;
	unsigned int   loop = 1;
	unsigned int   lflag = 0;
	unsigned int  start_addr = DDR_TEST_START_ADDR;
	unsigned int  test_size = DDR_TEST_SIZE;
	unsigned int   simple_pattern_flag = 1;
	unsigned int   cross_talk_pattern_flag = 1;
	unsigned int   old_pattern_flag = 1;

	unsigned int   print_flag = 1;
	//	  copy_test_flag = 0;
	print_flag = 1;
	error_outof_count_flag =0;
	error_count =0;
	printf("\nargc== 0x%08x\n", argc);
	int i ;
	for (i = 0;i<argc;i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}
	if (!argc)
		goto DDR_TEST_START;
	if (argc > 1) {
		if (strcmp(argv[1], "l") == 0) {
			lflag = 1;
		}
		else if (strcmp(argv[1], "h") == 0){
			goto usage;
		}
		else{
			loop = simple_strtoull_ddr(argv[1], &endp, 10);
			if (*argv[1] == 0 || *endp != 0)
				loop = 1;
		}
	}
	//    printf("\nLINE== 0x%08x\n", __LINE__);
	if (argc ==1) {
		//    start_addr = simple_strtoull_ddr(argv[2], &endp, 16);
		//    if (*argv[2] == 0 || *endp != 0)
		start_addr = DDR_TEST_START_ADDR;
		loop = 1;

	}
	if (argc > 2) {
		start_addr = simple_strtoull_ddr(argv[2], &endp, 16);
		if (*argv[2] == 0 || *endp != 0)
			start_addr = DDR_TEST_START_ADDR;

	}
	if (argc > 3) {
		test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
			test_size = DDR_TEST_SIZE;

	}
	if (test_size<0x1000)
		test_size = DDR_TEST_SIZE;

	old_pattern_flag = 1;
	simple_pattern_flag = 1;
	cross_talk_pattern_flag = 1;
	//printf("\nLINE== 0x%08x\n", __LINE__);
	if (argc ==2) {
		if ( (strcmp(argv[1], "s") == 0))
		{
			simple_pattern_flag = 1;
			old_pattern_flag=0;
			cross_talk_pattern_flag = 0;
		}
		else if ((strcmp(argv[1], "c") == 0))
		{
			simple_pattern_flag = 0;
			old_pattern_flag=0;
			cross_talk_pattern_flag = 1;
		}
		else  if ( (strcmp(argv[1], "e") == 0))
		{
			error_outof_count_flag=1;
		}
	}
	if (argc >2) {
		if ( (strcmp(argv[1], "n") == 0) || (strcmp(argv[2], "n") == 0))
		{
			print_flag = 0;
		}
		if ( (strcmp(argv[1], "p") == 0) || (strcmp(argv[2], "p") == 0))
		{
			copy_test_flag = 1;
		}
		if ( (strcmp(argv[1], "s") == 0) || (strcmp(argv[2], "s") == 0))
		{
			simple_pattern_flag = 1;
			old_pattern_flag=0;
			cross_talk_pattern_flag = 0;
		}
		else if ((strcmp(argv[1], "c") == 0)||(strcmp(argv[2], "c") == 0))
		{
			simple_pattern_flag = 0;
			old_pattern_flag=0;
			cross_talk_pattern_flag = 1;
		}
		else  if ( (strcmp(argv[1], "e") == 0)||(strcmp(argv[2], "e") == 0))
		{
			error_outof_count_flag=1;
		}
	}
	//printf("\nLINE1== 0x%08x\n", __LINE__);
	if (argc > 3) {
		if ( (strcmp(argv[1], "p") == 0) || (strcmp(argv[2], "p") == 0) || (strcmp(argv[3], "p") == 0))
		{
			copy_test_flag = 1;
		}
		if ( (strcmp(argv[1], "n") == 0) || (strcmp(argv[2], "n") == 0) || (strcmp(argv[3], "n") == 0))
		{
			print_flag = 0;
		}
		if ( (strcmp(argv[1], "s") == 0) || (strcmp(argv[2], "s") == 0) || (strcmp(argv[3], "s") == 0))
		{
			simple_pattern_flag = 1;
			old_pattern_flag=0;
			cross_talk_pattern_flag = 0;
		}
		if ((strcmp(argv[1], "c") == 0) || (strcmp(argv[2], "c") == 0) || (strcmp(argv[3], "c") == 0))
		{
			simple_pattern_flag = 0;
			old_pattern_flag=0;
			cross_talk_pattern_flag = 1;
		}
		if ( (strcmp(argv[1], "e") == 0) || (strcmp(argv[2], "e") == 0) || (strcmp(argv[3], "e") == 0))
		{
			error_outof_count_flag=1;
		}
	}

	//    printf("\nLINE2== 0x%08x\n", __LINE__);
	//	printf("\nLINE3== 0x%08x\n", __LINE__);
	//	printf("\nLINE== 0x%08x\n", __LINE__);

DDR_TEST_START:

	///*
	do {
		if (lflag)
			loop = 888;

		if (old_pattern_flag == 1)
		{
			{
				//	printf("\nLINE== 0x%08x\n", __LINE__);
				//printf("\nLINE== 0x%08x\n", __LINE__);
				//printf("\nLINE== 0x%08x\n", __LINE__);
				if (print_flag)
					printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + test_size);
				ddr_write((void *)(int_convter_p(start_addr)), test_size);
				//	 flush_dcache_range(start_addr,start_addr + test_size);
				if (print_flag) {
					printf("\nEnd write.                                 ");
					printf("\nStart 1st reading...                       ");
				}
				ddr_read((void *)(int_convter_p(start_addr)), test_size);
				if (print_flag) {
					printf("\nEnd 1st read.                              ");
					printf("\nStart 2nd reading...                       ");}
				ddr_read((void *)(int_convter_p(start_addr)), test_size);
				if (print_flag) {
					printf("\nEnd 2nd read.                              ");
					printf("\nStart 3rd reading...                       ");}
				ddr_read((void *)(int_convter_p(start_addr)), test_size);
				if (print_flag)
					printf("\nEnd 3rd read.                              \n");

				if (copy_test_flag)
				{
					if(print_flag)
						printf("\n copy_test_flag = 1,start copy test.                              \n");
					ddr_test_copy((void *)(int_convter_p(start_addr+test_size/2)),(void *)(int_convter_p(start_addr)), test_size/2 );
					ddr_read((void *)(int_convter_p(start_addr+test_size/2)), test_size/2);
					ddr_read((void *)(int_convter_p(start_addr+test_size/2)), test_size/2);
				}

			}
			{
				//	printf("\nLINE== 0x%08x\n", __LINE__);
				//printf("\nLINE== 0x%08x\n", __LINE__);
				//printf("\nLINE== 0x%08x\n", __LINE__);
				if (print_flag) {
					printf("\nStart *4 normal pattern.                                 ");
					printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + test_size);
				}
				ddr_write4((void *)(int_convter_p(start_addr)), test_size);
				if (print_flag) {
					printf("\nEnd write.                                 ");
					printf("\nStart 1st reading...                       ");}
				ddr_read4((void *)(int_convter_p(start_addr)), test_size);
				if (print_flag) {
					printf("\nEnd 1st read.                              ");
					printf("\nStart 2nd reading...                       ");}
				ddr_read4((void *)(int_convter_p(start_addr)), test_size);
				if (print_flag) {
					printf("\nEnd 2nd read.                              ");
					printf("\nStart 3rd reading...                       ");}
				ddr_read4((void *)(int_convter_p(start_addr)), test_size);
				if (print_flag)
					printf("\rEnd 3rd read.                              \n");
				if (copy_test_flag)
				{

					ddr_test_copy((void *)(int_convter_p(start_addr+test_size/2)),(void *)(int_convter_p(start_addr)), test_size/2 );
					ddr_read4((void *)(int_convter_p(start_addr+test_size/2)), test_size/2);
					ddr_read4((void *)(int_convter_p(start_addr+test_size/2)), test_size/2);
				}


			}
		}

		if (simple_pattern_flag == 1)
		{
			if (print_flag) {
				printf("\nStart *4 no cross talk pattern.                                 ");
				printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + test_size);
			}
			ddr_write_pattern4_no_cross_talk((void *)(int_convter_p(start_addr)), test_size);
			if (print_flag) {
				printf("\rEnd write.                                 ");
				printf("\rStart 1st reading...                       ");}
			ddr_read_pattern4_no_cross_talk((void *)(int_convter_p(start_addr)), test_size);
			if (print_flag) {
				printf("\rEnd 1st read.                              ");
				printf("\rStart 2nd reading...                       ");}
			ddr_read_pattern4_no_cross_talk((void *)(int_convter_p(start_addr)), test_size);
			if (print_flag) {
				printf("\rEnd 2nd read.                              ");
				printf("\rStart 3rd reading...                       ");}
			ddr_read_pattern4_no_cross_talk((void *)(int_convter_p(start_addr)), test_size);
			if (print_flag)
				printf("\rEnd 3rd read.                              \n");

			if (copy_test_flag)
			{
				ddr_test_copy((void *)(int_convter_p(start_addr+test_size/2)),(void *)(int_convter_p(start_addr)), test_size/2 );
				ddr_read_pattern4_no_cross_talk((void *)(int_convter_p(start_addr+test_size/2)), test_size/2);
				ddr_read_pattern4_no_cross_talk((void *)(int_convter_p(start_addr+test_size/2)), test_size/2);
			}

		}

		if (cross_talk_pattern_flag == 1)
		{if(print_flag){
						   printf("\nStart *4  cross talk pattern p.                                 ");
						   printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + test_size);
					   }
		ddr_write_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd write.                                 ");
			printf("\rStart 1st reading...                       ");}
		ddr_read_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd 1st read.                              ");
			printf("\rStart 2nd reading...                       ");}
		ddr_read_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd 2nd read.                              ");
			printf("\rStart 3rd reading...                       ");}
		ddr_read_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd 3rd read.                              \n");

			printf("\nStart *4  cross talk pattern n.                                 ");
			printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + test_size);}
		ddr_write_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd write.                                 ");
			printf("\rStart 1st reading...                       ");}
		ddr_read_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd 1st read.                              ");
			printf("\rStart 2nd reading...                       ");}
		ddr_read_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd 2nd read.                              ");
			printf("\rStart 3rd reading...                       ");}
		ddr_read_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd 3rd read.                              \n");

			///*
			printf("\nStart *4  cross talk pattern p2.                                 ");
			printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + test_size);}
		ddr_write_pattern4_cross_talk_p2((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd write.                                 ");
			printf("\rStart 1st reading...                       ");}
		ddr_read_pattern4_cross_talk_p2((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd 1st read.                              ");
			printf("\rStart 2nd reading...                       ");}
		ddr_read_pattern4_cross_talk_p2((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd 2nd read.                              ");
			printf("\rStart 3rd reading...                       ");}
		ddr_read_pattern4_cross_talk_p2((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd 3rd read.                              \n");

			printf("\nStart *4  cross talk pattern n2.                                 ");
			printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + test_size);}
		ddr_write_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd write.                                 ");
			printf("\rStart 1st reading...                       ");}
		ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd 1st read.                              ");
			printf("\rStart 2nd reading...                       ");}
		ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag) {
			printf("\rEnd 2nd read.                              ");
			printf("\rStart 3rd reading...                       ");}
		ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr)), test_size);
		if (print_flag)
			printf("\rEnd 3rd read.                              \n");

		if (copy_test_flag)
		{
			ddr_test_copy((void *)(int_convter_p(start_addr+test_size/2)),(void *)(int_convter_p(start_addr)), test_size/2 );
			ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr+test_size/2)), test_size/2);
			ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr+test_size/2)), test_size/2);
		}
		//    */

		}

		if (print_flag)
			printf("\nError count==0x%08x", error_count);

	}while(--loop);
	//*/

	printf("\rEnd ddr test.                              \n");

	return 0;

usage:
	cmd_usage(cmdtp);
	return 1;
}

U_BOOT_CMD(
	ddrtest,	5,	1,	do_ddr_test,
	"DDR test function",
	"ddrtest [LOOP] [ADDR].Default address is 0x8d000000\n"
);

int do_ddr_special_test(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	char *endp;
	unsigned int   loop = 1;
	unsigned int   lflag = 0;
	unsigned int  start_addr = DDR_TEST_START_ADDR;
	unsigned int test_addr = DDR_TEST_START_ADDR;
	unsigned int  test_size = DDR_TEST_SIZE;
	unsigned int   write_times = 1;
	unsigned int  read_times = 3;
	//  unsigned int   old_pattern_flag = 1;

	unsigned int   print_flag = 1;
	//	  copy_test_flag = 0;
	print_flag = 1;
	error_outof_count_flag =0;
	error_count =0;
	printf("\nargc== 0x%08x\n", argc);
	int i ;
	for (i = 0;i<argc;i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}

	if (strcmp(argv[1], "l") == 0) {
		lflag = 1;
	}
	else if (strcmp(argv[1], "h") == 0){
		goto usage;
	}
	else{
		loop = simple_strtoull_ddr(argv[1], &endp, 10);
		if (*argv[1] == 0 || *endp != 0)
			loop = 1;
	}

	//    printf("\nLINE== 0x%08x\n", __LINE__);
	if (argc ==1) {
		//    start_addr = simple_strtoull_ddr(argv[2], &endp, 16);
		//    if (*argv[2] == 0 || *endp != 0)
		start_addr = DDR_TEST_START_ADDR;
		loop = 1;

	}
	if (argc > 2) {
		start_addr = simple_strtoull_ddr(argv[2], &endp, 16);
		if (*argv[2] == 0 || *endp != 0)
			start_addr = DDR_TEST_START_ADDR;

	}
	if (argc > 3) {
		test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
			test_size = DDR_TEST_SIZE;

	}
	if (test_size<0x1000)
		test_size = DDR_TEST_SIZE;
	if (argc > 4) {
		write_times = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
			write_times = 0;

	}
	if (argc > 5) {
		read_times = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
			read_times = 0;

	}
	unsigned int  base_pattern = 1;
	unsigned int  inc_flag = 1;
	if (argc > 6) {
		base_pattern = simple_strtoull_ddr(argv[6], &endp, 16);
		if (*argv[6] == 0 || *endp != 0)
			base_pattern = 0;

	}
	if (argc > 7) {
		inc_flag = simple_strtoull_ddr(argv[7], &endp, 16);
		if (*argv[7] == 0 || *endp != 0)
			inc_flag = 0;

	}


	unsigned int  count    = 1;
	unsigned int   test_val = 1;

	///*
	do {
		if (lflag)
			loop = 888;

		if (1)
		{

			for (i=0;i<write_times;)
			{i++;
				printf("\nwrite_times==0x%08x \n",((unsigned int)i));
				test_addr=start_addr;
				test_val=base_pattern;
				count=(test_size>>2);
				do
				{
					writel(test_val,(unsigned long)test_addr);
					test_addr=test_addr+4;
					if (inc_flag)
						test_val=test_val+1;

				}
				while (count--) ;
			}

			for (i=0;i<read_times;)
			{i++;
				printf("\nread_times==0x%08x \n",((unsigned int)i));
				test_addr=start_addr;
				test_val=base_pattern;
				count=(test_size>>2);

				do
				{

					//writel(val,(unsigned long)reg);
					if (test_val != (readl((unsigned long)test_addr))) {

						printf("\nadd==0x%08x,pattern==0x%08x,read==0x%08x \n",((unsigned int)test_addr),((unsigned int)test_val),(readl((unsigned int)test_addr)));
					}
					test_addr=test_addr+4;
					if (inc_flag)
						test_val=test_val+1;
				}
				while (count--) ;
			}
		}



		if (print_flag)
			printf("\nError count==0x%08x", error_count);

	}while(--loop);
	//*/

	printf("\rEnd ddr test.                              \n");

	return 0;

usage:
	cmd_usage(cmdtp);
	return 1;
}
U_BOOT_CMD(
	ddr_spec_test,	8,	1,	do_ddr_special_test,
	"DDR test function",
	"ddrtest [LOOP] [ADDR] [size] [write_times] [read times] [pattern] [inc].ddr_spec_test 1 0x1080000 0x200000 1  3 1 1 \n"
);

int ddr_test_s_cross_talk_pattern(int ddr_test_size)
{
#define TEST_OFFSET  0//0X40000000
	// unsigned int  start_addr = DDR_TEST_START_ADDR+TEST_OFFSET;
	unsigned int  start_addr=test_start_addr;

	error_outof_count_flag=1;

	error_count=0;

#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
	training_pattern_flag=0;
#endif
	///*
	if (training_pattern_flag)
	{
#if (CONFIG_DDR_PHY ==  P_DDR_PHY_GX_BABY)
		ddr_test_gx_training_pattern(ddr_test_size);
#endif
		if (error_count)
			return 1;
		else
			return 0;
	}
	else
	{
#if (CONFIG_DDR_PHY ==  P_DDR_PHY_GX_BABY)
		ddr_test_gx_training_pattern(ddr_test_size);
#endif

	}

	{
		printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
		ddr_write((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\nEnd write.                                 ");
		printf("\nStart 1st reading...                       ");
		ddr_read((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\nEnd 1st read.                              ");
		printf("\nStart 2nd reading...                       ");
		ddr_read((void *)(int_convter_p(start_addr)), ddr_test_size);
		if (error_count)
		return error_count;
		printf("\nStart writing pattern4 at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
		ddr_write4((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\nEnd write.                                 ");
		printf("\nStart 1st reading...                       ");
		ddr_read4((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\nEnd 1st read.                              ");
		printf("\nStart 2nd reading...                       ");
		ddr_read4((void *)(int_convter_p(start_addr)), ddr_test_size);

		if (error_count)
		return error_count;
		printf("\nStart *4 no cross talk pattern.                                 ");
		printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
		ddr_write_pattern4_no_cross_talk((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\nEnd write.                                 ");
		printf("\nStart 1st reading...                       ");
		ddr_read_pattern4_no_cross_talk((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\nEnd 1st read.                              ");
		printf("\nStart 2nd reading...                       ");
		ddr_read_pattern4_no_cross_talk((void *)(int_convter_p(start_addr)), ddr_test_size);
	}

	if (error_count)
		return error_count;
	//if(cross_talk_pattern_flag==1)
	{
		printf("\nStart *4  cross talk pattern p.                                 ");
		printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
		ddr_write_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd write.                                 ");
		printf("\rStart 1st reading...                       ");
		ddr_read_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 1st read.                              ");
		printf("\rStart 2nd reading...                       ");
		ddr_read_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 2nd read.                              ");

		if (error_count)
		return error_count;
		printf("\nStart *4  cross talk pattern n.                                 ");
		printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
		ddr_write_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd write.                                 ");
		printf("\rStart 1st reading...                       ");
		ddr_read_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 1st read.                              ");
		printf("\rStart 2nd reading...                       ");
		ddr_read_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 2nd read.                              ");
		//    printf("\rStart 3rd reading...                       ");
		//    ddr_read_pattern4_cross_talk_n((void *)start_addr, ddr_test_size);
		//   printf("\rEnd 3rd read.                              \n");
	}
	if (error_count)
		return error_count;
	{
		printf("\nStart *4  cross talk pattern p2.                                 ");
		printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
		ddr_write_pattern4_cross_talk_p2((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd write.                                 ");
		printf("\rStart 1st reading...                       ");
		ddr_read_pattern4_cross_talk_p2((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 1st read.                              ");
		printf("\rStart 2nd reading...                       ");
		ddr_read_pattern4_cross_talk_p2((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 2nd read.                              ");

		//   printf("\rStart 3rd reading...                       ");
		//    ddr_read_pattern4_cross_talk_p((void *)start_addr, ddr_test_size);
		//    printf("\rEnd 3rd read.                              \n");
		if (error_count)
		return error_count;
		printf("\nStart *4  cross talk pattern n.                                 ");
		printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
		ddr_write_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd write.                                 ");
		printf("\rStart 1st reading...                       ");
		ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 1st read.                              ");
		printf("\rStart 2nd reading...                       ");
		ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 2nd read.                              ");

		if (copy_test_flag)
		{
			if (error_count)
			return error_count;
			printf("\n start copy test  ...                            ");
			ddr_test_copy((void *)(int_convter_p(start_addr+ddr_test_size/2)),(void *)(int_convter_p(start_addr)), ddr_test_size/2 );
			ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr+ddr_test_size/2)), ddr_test_size/2);
			ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr+ddr_test_size/2)), ddr_test_size/2);
		}
	}

	if (error_count)
		return 1;
	else
		return 0;
	}



int ddr_test_s_cross_talk_pattern_quick_retrun(int ddr_test_size)
{
	error_outof_count_flag =1;
	#define TEST_OFFSET  0//0X40000000
	// unsigned int  start_addr = DDR_TEST_START_ADDR+TEST_OFFSET;
	unsigned int  start_addr=test_start_addr;

	error_outof_count_flag=1;

	error_count=0;

	#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
		training_pattern_flag=0;
	#endif
	///*
	if (training_pattern_flag)
	{
	#if (CONFIG_DDR_PHY ==  P_DDR_PHY_GX_BABY)
		ddr_test_gx_training_pattern(ddr_test_size);
	#endif
	if (error_count)
		return 1;
	else
		return 0;
	}
	else
	{
	#if (CONFIG_DDR_PHY ==  P_DDR_PHY_GX_BABY)
		ddr_test_gx_training_pattern(ddr_test_size);
	#endif
	}
	//			*/
	/*
	ddr_test_gx_cross_talk_pattern( ddr_test_size);
	if (error_count)
	return 1;
	else
	return 0;
	*/

	{
		printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
		ddr_write((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\nEnd write.                                 ");
		printf("\nStart 1st reading...                       ");
		ddr_read((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\nEnd 1st read.                              ");
		printf("\nStart 2nd reading...                       ");
		ddr_read((void *)(int_convter_p(start_addr)), ddr_test_size);

		printf("\nStart writing pattern4 at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
		ddr_write4((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\nEnd write.                                 ");
		printf("\nStart 1st reading...                       ");
		ddr_read4((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\nEnd 1st read.                              ");
		printf("\nStart 2nd reading...                       ");
		ddr_read4((void *)(int_convter_p(start_addr)), ddr_test_size);

		printf("\nStart *4 no cross talk pattern.                                 ");
		printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
		ddr_write_pattern4_no_cross_talk((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\nEnd write.                                 ");
		printf("\nStart 1st reading...                       ");
		ddr_read_pattern4_no_cross_talk((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\nEnd 1st read.                              ");
		printf("\nStart 2nd reading...                       ");
		ddr_read_pattern4_no_cross_talk((void *)(int_convter_p(start_addr)), ddr_test_size);
	}
	//if(cross_talk_pattern_flag==1)
	{
		printf("\nStart *4  cross talk pattern p.                                 ");
		printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
		ddr_write_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd write.                                 ");
		printf("\rStart 1st reading...                       ");
		ddr_read_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 1st read.                              ");
		printf("\rStart 2nd reading...                       ");
		ddr_read_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 2nd read.                              ");

		//   printf("\rStart 3rd reading...                       ");
		//    ddr_read_pattern4_cross_talk_p((void *)start_addr, ddr_test_size);
		//    printf("\rEnd 3rd read.                              \n");

		printf("\nStart *4  cross talk pattern n.                                 ");
		printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
		ddr_write_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd write.                                 ");
		printf("\rStart 1st reading...                       ");
		ddr_read_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 1st read.                              ");
		printf("\rStart 2nd reading...                       ");
		ddr_read_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 2nd read.                              ");
		//    printf("\rStart 3rd reading...                       ");
		//    ddr_read_pattern4_cross_talk_n((void *)start_addr, ddr_test_size);
		//   printf("\rEnd 3rd read.                              \n");


	}

	{
		printf("\nStart *4  cross talk pattern p2.                                 ");
		printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
		ddr_write_pattern4_cross_talk_p2((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd write.                                 ");
		printf("\rStart 1st reading...                       ");
		ddr_read_pattern4_cross_talk_p2((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 1st read.                              ");
		printf("\rStart 2nd reading...                       ");
		ddr_read_pattern4_cross_talk_p2((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 2nd read.                              ");

		//   printf("\rStart 3rd reading...                       ");
		//    ddr_read_pattern4_cross_talk_p((void *)start_addr, ddr_test_size);
		//    printf("\rEnd 3rd read.                              \n");

		printf("\nStart *4  cross talk pattern n.                                 ");
		printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
		ddr_write_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd write.                                 ");
		printf("\rStart 1st reading...                       ");
		ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 1st read.                              ");
		printf("\rStart 2nd reading...                       ");
		ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr)), ddr_test_size);
		printf("\rEnd 2nd read.                              ");
		//    printf("\rStart 3rd reading...                       ");
		//    ddr_read_pattern4_cross_talk_n((void *)start_addr, ddr_test_size);
	 //   printf("\rEnd 3rd read.                              \n");
		if (copy_test_flag)
		{
			printf("\n start copy test  ...                            ");
			ddr_test_copy((void *)(int_convter_p(start_addr+ddr_test_size/2)),(void *)(int_convter_p(start_addr)), ddr_test_size/2 );
			ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr+ddr_test_size/2)), ddr_test_size/2);
			ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr+ddr_test_size/2)), ddr_test_size/2);
		}

	}

	if (error_count)
		return 1;
	else
		return 0;
}

#if ( CONFIG_DDR_PHY >= P_DDR_PHY_G12)
int do_ddr_test_dqs_window_step(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter test ddr dqs window step function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);

	unsigned int   temp_test_error= 0;

	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_lane_step=0;
	unsigned int   testing_lane=0;
	unsigned int   test_lane_step_rdqs_flag=0;
	unsigned int   test_min_max_flag=0;
	unsigned int   test_times=1;
	unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;

	unsigned int   dq_lcd_bdl_reg_org=0;
	unsigned int   dq_lcd_bdl_reg_left=0;
	unsigned int   dq_lcd_bdl_reg_right=0;

	unsigned int   dq_lcd_bdl_reg_left_min=0;
	unsigned int   dq_lcd_bdl_reg_right_min=0;

	unsigned int   dq_lcd_bdl_temp_reg_value=0;

	//  unsigned int   dq_lcd_bdl_temp_reg_lef_min_value;
	//     unsigned int   dq_lcd_bdl_temp_reg_rig_min_value;
	//   unsigned int   dq_lcd_bdl_temp_reg_lef;
	//   unsigned int   dq_lcd_bdl_temp_reg_rig;

	unsigned int   ddr_test_size= DDR_TEST_SIZE;//DDR_CORSS_TALK_TEST_SIZE;

	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))
		{
			channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))
		{
			channel_b_en = 1;
		}
		else
		{
			goto usage;
		}
	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))
		{
			channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))
		{
			channel_b_en = 1;
		}
	}
	ddr_test_size = DDR_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_TEST_SIZE;
		}
	}
	if (argc >4) {
		test_lane_step = 0;
		test_lane_step = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
		{
			test_lane_step = 0;
		}
		if   ((strcmp(argv[4], "l") == 0) || (strcmp(argv[4], "L") == 0))
		{
			test_lane_step = 0;
		}
	}
	if (test_lane_step >7)
		test_lane_step = 0;
	unsigned int   test_loop=1;
	if (argc >5) {
		test_min_max_flag = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
		{
			test_min_max_flag = 0;
		}
		else
		{
			//test_min_max_flag =1;
		}
	}
	unsigned int   test_temp_value_use_sticky_register=0;
	if (argc >6) {
		test_temp_value_use_sticky_register = simple_strtoull_ddr(argv[6], &endp, 16);
		if (*argv[6] == 0 || *endp != 0)
		{
			test_temp_value_use_sticky_register = 0;
		}
		else
		{
			//test_min_max_flag =1;
		}
	}
	sticky_reg_base_add=(DDR0_PUB_REG_BASE&0xffff0000)+((DMC_STICKY_0)&0xffff);

	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_lane_step== 0x%08x\n", test_lane_step);
	printf("\ntest_min_max_flag== 0x%08x\n", test_min_max_flag);
	printf("\ntest_temp_value_use_sticky_register== 0x%08x\n", test_temp_value_use_sticky_register);

	const char *temp_s;
	char *env_lcdlr_temp_count;
	char *buf;
	buf="";
	unsigned int lcdlr_temp_count=0;
	env_lcdlr_temp_count="lcdlr_temp_count";

	if(test_temp_value_use_sticky_register)
	{
		lcdlr_temp_count=readl((sticky_reg_base_add+(6<<2)));
	}
	else
	{
		temp_s= getenv(env_lcdlr_temp_count);
		if(temp_s)
		{
			lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
		}
		else
		{
			lcdlr_temp_count=0;
		}
	}
			
	//if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	//if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}

for (test_times=0;(test_times<test_loop);(test_times++))
{
	////tune and save training dqs value
	if (channel_a_en || channel_b_en)
	{
		if (( channel_a_en) && ( channel_b_en == 0))
		{
			reg_base_adj=CHANNEL_A_REG_BASE;
		}
		else if(( channel_b_en)&&( channel_a_en==0))
		{
			reg_base_adj=CHANNEL_B_REG_BASE;
		}
		else if ((channel_a_en+channel_b_en)==2)
		{
			reg_base_adj=CHANNEL_A_REG_BASE;
		}

		{
			printf("\nshould pause ddl pir== 0x%08x,if no pause ddl ,write lcdlr some time may occur error\n", readl(DDR0_PUB_REG_BASE+4));
			writel((readl(DDR0_PUB_REG_BASE+4))|(1<<29),(DDR0_PUB_REG_BASE+4));
			printf("\n pause ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
			if( channel_b_en)
			{
				printf("\nddr1 should pause ddl pir== 0x%08x,if no pause ddl ,write lcdlr some time may occur error\n", readl(DDR1_PUB_REG_BASE+4));
				writel((readl(DDR1_PUB_REG_BASE+4))|(1<<29),(DDR1_PUB_REG_BASE+4));
				printf("\n ddr1 pause ddl pir== 0x%08x\n", readl(DDR1_PUB_REG_BASE+4));
			}
			if (test_lane_step>8)
				test_lane_step=0;
			printf("\ntest_lane_step==0x%08x\n ",test_lane_step);

			reg_add=DDR0_PUB_DX0BDLR0+reg_base_adj+(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_lane_step>>1);
			test_lane_step_rdqs_flag=test_lane_step%2;
			testing_lane=(test_lane_step>>1);

			dq_lcd_bdl_temp_reg_value=readl(reg_add);
			dq_lcd_bdl_reg_org=dq_lcd_bdl_temp_reg_value;
			printf("\nreg_add_0x%08x==0x%08x\n ",reg_add,dq_lcd_bdl_temp_reg_value);

			#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
			if (test_lane_step_rdqs_flag)
			{
				dq_lcd_bdl_temp_reg_value=(((readl(reg_add))&0xff00)>>8);
				dq_lcd_bdl_reg_org=dq_lcd_bdl_temp_reg_value;
			}
			else
			{
				dq_lcd_bdl_temp_reg_value=(((readl(reg_add))&0x00ff)>>0);
				dq_lcd_bdl_reg_org=dq_lcd_bdl_temp_reg_value;
			}
			#endif

			if ((test_min_max_flag == 0)||( (test_min_max_flag == 2)))
			{
				while (dq_lcd_bdl_temp_reg_value>0)
				{
					ddr_test_watchdog_clear();
					temp_test_error=0;
					dq_lcd_bdl_temp_reg_value--;

					{
						lcdlr_temp_count=dq_lcd_bdl_temp_reg_value;
						sprintf(buf, "0x%08x", lcdlr_temp_count);
						printf( "%s\n", buf);
						if(test_temp_value_use_sticky_register)
						{
							writel(lcdlr_temp_count,(sticky_reg_base_add+(6<<2)));
						}
						else
						{
							setenv(env_lcdlr_temp_count, buf);
							run_command("save",0);
						}
					}

					printf("\n left temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value);
					if (!test_lane_step_rdqs_flag)
					{
					#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
						writel((dq_lcd_bdl_temp_reg_value<<0)|(((readl(reg_add))&0xffff00)),reg_add);
					#else
						writel(dq_lcd_bdl_temp_reg_value,reg_add);
					#endif
					}
					else
					{
					#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
						writel((dq_lcd_bdl_temp_reg_value<<8)|(dq_lcd_bdl_temp_reg_value<<16)|(((readl(reg_add))&0xff)),reg_add);
					#endif
					}
					printf("\n rmin read reg==0x%08x\n ",(readl(reg_add)));
					temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

					if (temp_test_error)
					{
						//printf("\nwdqd left edge detect \n");
						dq_lcd_bdl_temp_reg_value++;
						break;
					}
				}
				printf("\n left edge detect \n");
				printf("\nleft edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value);

				dq_lcd_bdl_reg_left=dq_lcd_bdl_temp_reg_value;
				if (test_times == 0)
					dq_lcd_bdl_reg_left_min=dq_lcd_bdl_reg_left;
				if (dq_lcd_bdl_reg_left>dq_lcd_bdl_reg_left_min)  //update wdqd min value
				{
					dq_lcd_bdl_reg_left_min=dq_lcd_bdl_reg_left	;
				}
			} 
			else
			{
				printf("\n left edge skip \n");
			}

			if (!test_lane_step_rdqs_flag)
			{
				#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
					writel((dq_lcd_bdl_reg_org<<0)|(((readl(reg_add))&0xffff00)),reg_add);
				#else
					writel(dq_lcd_bdl_reg_org,reg_add);
				#endif
				//  writel(dq_lcd_bdl_reg_org,reg_add);
			}
			else
			{
				#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
				writel((dq_lcd_bdl_reg_org<<8)|(dq_lcd_bdl_reg_org<<16)|(((readl(reg_add))&0xff)),reg_add);
				#else
				#endif
				//	  writel(dq_lcd_bdl_reg_org,reg_add);
				//	  writel(dq_lcd_bdl_reg_org,reg_add+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR3);
			}

			dq_lcd_bdl_temp_reg_value=dq_lcd_bdl_reg_org;

			printf("\n read reg==0x%08x\n ",(readl(reg_add)));


			if ((test_min_max_flag == 0)|| (test_min_max_flag == 1))
			{
				while (dq_lcd_bdl_temp_reg_value<DQLCDLR_MAX)
				{
					ddr_test_watchdog_clear();
					temp_test_error=0;
					dq_lcd_bdl_temp_reg_value++;


					lcdlr_temp_count=dq_lcd_bdl_temp_reg_value;
					sprintf(buf, "0x%08x", lcdlr_temp_count);
					printf( "%s\n", buf);
					if(test_temp_value_use_sticky_register)
					{
						writel(lcdlr_temp_count,(sticky_reg_base_add+(6<<2)));
					}
					else
					{
						setenv(env_lcdlr_temp_count, buf);
						run_command("save",0);
					}

					printf("\n rig temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value);
					if (!test_lane_step_rdqs_flag)
					{
						//writel(dq_lcd_bdl_temp_reg_value,reg_add);
						#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
							writel((dq_lcd_bdl_temp_reg_value<<0)|(((readl(reg_add))&0xffff00)),reg_add);
						#else
							writel(dq_lcd_bdl_temp_reg_value,reg_add);
						#endif
					}
					else
					{
						#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
							writel((dq_lcd_bdl_temp_reg_value<<8)|(dq_lcd_bdl_temp_reg_value<<16)|(((readl(reg_add))&0xff)),reg_add);
						#endif
						//	  writel(dq_lcd_bdl_temp_reg_value,reg_add);
						//	  writel(dq_lcd_bdl_temp_reg_value,reg_add+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR3);
					}
					printf("\n r max read reg==0x%08x\n ",(readl(reg_add)));
					temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
					if (temp_test_error)
					{
						//printf("\nwdqd right edge detect \n");
						dq_lcd_bdl_temp_reg_value--;
						break;
					}
				}
				printf("\n right edge detect \n");
				printf("\n right edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value);

				dq_lcd_bdl_reg_right=dq_lcd_bdl_temp_reg_value;
				if (test_times == 0)
					dq_lcd_bdl_reg_right_min=dq_lcd_bdl_reg_right;
				if (dq_lcd_bdl_reg_right<dq_lcd_bdl_reg_right_min)  //update wdqd min value
				{
					dq_lcd_bdl_reg_right_min=dq_lcd_bdl_reg_right	;
				}
			}

			if (!test_lane_step_rdqs_flag)
			{
				// writel(dq_lcd_bdl_reg_org,reg_add);
				#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
					writel((dq_lcd_bdl_reg_org<<0)|(((readl(reg_add))&0xffff00)),reg_add);
				#else
					writel(dq_lcd_bdl_reg_org,reg_add);
				#endif
			}
			else
			{
				#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
					writel((dq_lcd_bdl_reg_org<<8)|(dq_lcd_bdl_reg_org<<16)|(((readl(reg_add))&0xff)),reg_add);
				#endif
				// 	  writel(dq_lcd_bdl_reg_org,reg_add);
				//	  writel(dq_lcd_bdl_reg_org,reg_add+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR3);
			}
			printf("\n read reg==0x%08x\n ",(readl(reg_add)));
			printf("\nend pause ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
			writel(((readl(DDR0_PUB_REG_BASE+4))&(~(1<<29))),(DDR0_PUB_REG_BASE+4));
			printf("\n resume ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
		}
	}

}

	dq_lcd_bdl_temp_reg_value=(dq_lcd_bdl_reg_right_min<<16)|dq_lcd_bdl_reg_left_min;
	if (!test_lane_step_rdqs_flag)
	{
		if(channel_a_en)
		{
			dq_lcd_bdl_value_wdq_org_a[testing_lane]=dq_lcd_bdl_reg_org;
			if (test_min_max_flag != 1)
				dq_lcd_bdl_value_wdq_min_a[testing_lane]=dq_lcd_bdl_reg_left_min;
			if (test_min_max_flag != 2)
				dq_lcd_bdl_value_wdq_max_a[testing_lane]=dq_lcd_bdl_reg_right_min;
		}
		if (channel_b_en)
		{
			dq_lcd_bdl_value_wdq_org_b[testing_lane]=dq_lcd_bdl_reg_org;
			if (test_min_max_flag != 1)
				dq_lcd_bdl_value_wdq_min_b[testing_lane]=dq_lcd_bdl_reg_left_min;
			if (test_min_max_flag != 2)
				dq_lcd_bdl_value_wdq_max_b[testing_lane]=dq_lcd_bdl_reg_right_min;
		}
	}
	else
	{
		if (channel_a_en) {
			dq_lcd_bdl_value_rdqs_org_a[testing_lane]=dq_lcd_bdl_reg_org;
			if (test_min_max_flag != 1)
				dq_lcd_bdl_value_rdqs_min_a[testing_lane]=dq_lcd_bdl_reg_left_min;
			if (test_min_max_flag != 2)
				dq_lcd_bdl_value_rdqs_max_a[testing_lane]=dq_lcd_bdl_reg_right_min;
		}
		if (channel_b_en) {
			dq_lcd_bdl_value_rdqs_org_b[testing_lane]=dq_lcd_bdl_reg_org;
			if (test_min_max_flag != 1)
				dq_lcd_bdl_value_rdqs_min_b[testing_lane]=dq_lcd_bdl_reg_left_min;
			if (test_min_max_flag != 2)
				dq_lcd_bdl_value_rdqs_max_b[testing_lane]=dq_lcd_bdl_reg_right_min;
		}
	}

	return dq_lcd_bdl_temp_reg_value;

usage:
	cmd_usage(cmdtp);
	return 1;

}
U_BOOT_CMD(
	ddr_tune_dqs_step,	7,	1,	do_ddr_test_dqs_window_step,
	"ddr_tune_dqs_step function",
	"ddr_tune_dqs_step a 0 0x80000 3 or ddr_tune_dqs_step b 0 0x80000 5 \n dcache off ? \n"
);
#else

int do_ddr_test_fine_tune_dqs(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter Tune ddr dqs function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);
	//  unsigned int   loop = 1;
	unsigned int   temp_count_i = 1;
	unsigned int   temp_count_j= 1;
	unsigned int   temp_count_k= 1;
	unsigned int   temp_test_error= 0;


	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_loop=1;
	unsigned int   test_times=1;
	unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;
	unsigned int   testing_channel = 0;

#define  DATX8_DQ_LCD_BDL_REG_WIDTH  12

#define  DATX8_DQ_LANE_WIDTH  4
#define  CHANNEL_CHANNEL_WIDTH  2

#define  CHANNEL_A  0
#define  CHANNEL_B  1



#define  DATX8_DQ_LANE_LANE00  0
#define  DATX8_DQ_LANE_LANE01  1
#define  DATX8_DQ_LANE_LANE02  2
#define  DATX8_DQ_LANE_LANE03  3

#define  DATX8_DQ_BDLR0  0
#define  DATX8_DQ_BDLR1  1
#define  DATX8_DQ_BDLR2  2
#define  DATX8_DQ_BDLR3  3
#define  DATX8_DQ_BDLR4  4
#define  DATX8_DQ_BDLR5  5
#define  DATX8_DQ_BDLR6  6
#define  DATX8_DQ_DXNLCDLR0     7
#define  DATX8_DQ_DXNLCDLR1     8
#define  DATX8_DQ_DXNLCDLR2     9
#define  DATX8_DQ_DXNMDLR        10
#define  DATX8_DQ_DXNGTR          11


#define  DDR_CORSS_TALK_TEST_SIZE   0x20000

#define  DQ_LCD_BDL_REG_NUM_PER_CHANNEL  DATX8_DQ_LCD_BDL_REG_WIDTH*DATX8_DQ_LANE_WIDTH
#define  DQ_LCD_BDL_REG_NUM    DQ_LCD_BDL_REG_NUM_PER_CHANNEL*CHANNEL_CHANNEL_WIDTH

	unsigned int   dq_lcd_bdl_reg_org[DQ_LCD_BDL_REG_NUM];
	unsigned int   dq_lcd_bdl_reg_left[DQ_LCD_BDL_REG_NUM];
	unsigned int   dq_lcd_bdl_reg_right[DQ_LCD_BDL_REG_NUM];
	unsigned int   dq_lcd_bdl_reg_index[DQ_LCD_BDL_REG_NUM];

	unsigned int   dq_lcd_bdl_reg_left_min[DQ_LCD_BDL_REG_NUM];
	unsigned int   dq_lcd_bdl_reg_right_min[DQ_LCD_BDL_REG_NUM];

	unsigned int   dq_lcd_bdl_temp_reg_value;
	unsigned int   dq_lcd_bdl_temp_reg_value_dqs;
	unsigned int   dq_lcd_bdl_temp_reg_value_wdqd;
	unsigned int   dq_lcd_bdl_temp_reg_value_rdqsd;
	//  unsigned int   dq_lcd_bdl_temp_reg_value_rdqsnd;
	unsigned int   dq_lcd_bdl_temp_reg_lef_min_value;
	unsigned int   dq_lcd_bdl_temp_reg_rig_min_value;
	//   unsigned int   dq_lcd_bdl_temp_reg_value_dqs;
	//  unsigned int   dq_lcd_bdl_temp_reg_value_wdqd;
	//   unsigned int   dq_lcd_bdl_temp_reg_value_rdqsd;

	unsigned int   dq_lcd_bdl_temp_reg_lef;
	unsigned int   dq_lcd_bdl_temp_reg_rig;
	unsigned int   dq_lcd_bdl_temp_reg_center;
	unsigned int   dq_lcd_bdl_temp_reg_windows;
	unsigned int   dq_lcd_bdl_temp_reg_center_min;
	unsigned int   dq_lcd_bdl_temp_reg_windows_min;

	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;



	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))

		{channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))

		{channel_b_en = 1;
		}
		else
		{
			goto usage;
		}
	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))

		{channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

		{channel_b_en = 1;
		}
	}
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}

	}
	if (argc >4) {
		test_loop = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
		{
			test_loop = 1;
		}
		if   ((strcmp(argv[4], "l") == 0) || (strcmp(argv[4], "L") == 0))
		{
			test_loop = 100000;
		}
	}
	if (argc >5) {
		training_pattern_flag = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
		{
			training_pattern_flag = 0;
		}
		else if(training_pattern_flag)
			training_pattern_flag = 1;


	}


	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_loop== 0x%08x\n", test_loop);
	printf("\training_pattern_flag== 0x%08x\n", training_pattern_flag);
	if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}


	//save and print org training dqs value
	if (channel_a_en || channel_b_en)
	{


		//dcache_disable();
		//serial_puts("\ndebug for ddrtest ,jiaxing disable dcache");

		{
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{
				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;
					}
				}

				for ((temp_count_i=0);(temp_count_i<DATX8_DQ_LANE_WIDTH);(temp_count_i++))
				{

					if (temp_count_i == DATX8_DQ_LANE_LANE00)
					{
						reg_add=DDR0_PUB_DX0BDLR0+reg_base_adj;}

					else    if(temp_count_i==DATX8_DQ_LANE_LANE01)
					{
						reg_add=DDR0_PUB_DX1BDLR0+reg_base_adj;}

					else   	 if(temp_count_i==DATX8_DQ_LANE_LANE02)
					{
						reg_add=DDR0_PUB_DX2BDLR0+reg_base_adj;}
					else    if(temp_count_i==DATX8_DQ_LANE_LANE03)
					{
						reg_add=DDR0_PUB_DX3BDLR0+reg_base_adj;}



					for ((temp_count_j=0);(temp_count_j<DATX8_DQ_LCD_BDL_REG_WIDTH);(temp_count_j++))
					{
						dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j]=readl(reg_add+4*temp_count_j);
						dq_lcd_bdl_reg_index[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j]=reg_add+4*temp_count_j;
						printf("\n org add  0x%08x reg== 0x%08x\n",(reg_add+4*temp_count_j), (dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j]));
						dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j]
							=dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j];
						dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j]
							=dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j];

					}
				}

			}

		}

	}////save and print org training dqs value


	for (test_times=0;(test_times<test_loop);(test_times++))
	{
		////tune and save training dqs value
		if (channel_a_en || channel_b_en)

		{
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{

				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;
					}
				}

				for ((temp_count_i=0);(temp_count_i<DATX8_DQ_LANE_WIDTH);(temp_count_i++))
				{
					{ printf("\ntest lane==0x%08x\n ",temp_count_i);

						if (temp_count_i == DATX8_DQ_LANE_LANE00)
						{
							reg_add=DDR0_PUB_DX0BDLR0+reg_base_adj;}

						else    if(temp_count_i==DATX8_DQ_LANE_LANE01)
						{
							reg_add=DDR0_PUB_DX1BDLR0+reg_base_adj;}

						else   	 if(temp_count_i==DATX8_DQ_LANE_LANE02)
						{
							reg_add=DDR0_PUB_DX2BDLR0+reg_base_adj;}
						else    if(temp_count_i==DATX8_DQ_LANE_LANE03)
						{
							reg_add=DDR0_PUB_DX3BDLR0+reg_base_adj;}
					}

					for ((temp_count_k=0);(temp_count_k<2);(temp_count_k++))
					{

						if (temp_count_k == 0)
						{
#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
							dq_lcd_bdl_temp_reg_value_dqs=(readl(reg_add+DDR0_PUB_DX0LCDLR1-DDR0_PUB_DX0BDLR0));
							dq_lcd_bdl_temp_reg_value_wdqd=(readl(reg_add+DDR0_PUB_DX0LCDLR1-DDR0_PUB_DX0BDLR0))&DQLCDLR_MAX;
							dq_lcd_bdl_temp_reg_value_rdqsd=(readl(reg_add+DDR0_PUB_DX0LCDLR3-DDR0_PUB_DX0BDLR0))&DQLCDLR_MAX;
							//  dq_lcd_bdl_temp_reg_value_rdqsnd=((dq_lcd_bdl_temp_reg_value_dqs&0xff0000))>>16;
#else
							dq_lcd_bdl_temp_reg_value_dqs=readl(reg_add+4*DATX8_DQ_DXNLCDLR1);
							dq_lcd_bdl_temp_reg_value_wdqd=(dq_lcd_bdl_temp_reg_value_dqs&0xff);
							dq_lcd_bdl_temp_reg_value_rdqsd=((dq_lcd_bdl_temp_reg_value_dqs&0xff00))>>8;
							//  dq_lcd_bdl_temp_reg_value_rdqsnd=((dq_lcd_bdl_temp_reg_value_dqs&0xff0000))>>16;
#endif

							while (dq_lcd_bdl_temp_reg_value_wdqd>0)
							{
								temp_test_error=0;
								dq_lcd_bdl_temp_reg_value_wdqd--;
								printf("\nwdqd left temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value_wdqd);
								dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
								writel(dq_lcd_bdl_temp_reg_value_wdqd,(reg_add+DDR0_PUB_DX0LCDLR1-DDR0_PUB_DX0BDLR0));
#else
								writel(dq_lcd_bdl_temp_reg_value_dqs,(reg_add+4*DATX8_DQ_DXNLCDLR1));
#endif
								temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
								if (temp_test_error)
								{
									//printf("\nwdqd left edge detect \n");
									dq_lcd_bdl_temp_reg_value_wdqd++;
									break;
								}
							}
							printf("\nwdqd left edge detect \n");
							printf("\nwdqd left edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value_wdqd);
							dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
							//only update dq_lcd_bdl_temp_reg_value_wdqd
							dq_lcd_bdl_temp_reg_value=dq_lcd_bdl_reg_left[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							dq_lcd_bdl_temp_reg_value_dqs=((dq_lcd_bdl_temp_reg_value&0x00)|dq_lcd_bdl_temp_reg_value_wdqd);
							dq_lcd_bdl_reg_left[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]=dq_lcd_bdl_temp_reg_value_dqs;


							dq_lcd_bdl_temp_reg_lef_min_value=dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							if (dq_lcd_bdl_temp_reg_value_wdqd>(dq_lcd_bdl_temp_reg_lef_min_value&0xff))  //update wdqd min value
							{
								dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]
									=((dq_lcd_bdl_temp_reg_lef_min_value&0xffff00)|dq_lcd_bdl_temp_reg_value_wdqd)	;
							}


							writel(dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1],(reg_add+4*DATX8_DQ_DXNLCDLR1));

							dq_lcd_bdl_temp_reg_value_dqs=readl(reg_add+4*DATX8_DQ_DXNLCDLR1);
							dq_lcd_bdl_temp_reg_value_wdqd=(dq_lcd_bdl_temp_reg_value_dqs&0xff);
							dq_lcd_bdl_temp_reg_value_rdqsd=((dq_lcd_bdl_temp_reg_value_dqs&0xff00))>>8;


							while (dq_lcd_bdl_temp_reg_value_wdqd<0xff)
							{
								temp_test_error=0;
								dq_lcd_bdl_temp_reg_value_wdqd++;
								printf("\nwdqd rig temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value_wdqd);
								dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
								writel(dq_lcd_bdl_temp_reg_value_dqs,(reg_add+4*DATX8_DQ_DXNLCDLR1));
								temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
								if (temp_test_error)
								{
									//printf("\nwdqd right edge detect \n");
									dq_lcd_bdl_temp_reg_value_wdqd--;
									break;
								}
							}
							printf("\nwdqd right edge detect \n");
							printf("\nwdqd right edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value_wdqd);
							dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
							//only update dq_lcd_bdl_temp_reg_value_wdqd
							dq_lcd_bdl_temp_reg_value=dq_lcd_bdl_reg_right[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							dq_lcd_bdl_temp_reg_value_dqs=((dq_lcd_bdl_temp_reg_value&0x00)|dq_lcd_bdl_temp_reg_value_wdqd);

							dq_lcd_bdl_reg_right[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]=dq_lcd_bdl_temp_reg_value_dqs;

							dq_lcd_bdl_temp_reg_rig_min_value=dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							if (dq_lcd_bdl_temp_reg_value_wdqd<(dq_lcd_bdl_temp_reg_rig_min_value&0xff))  //update wdqd min value
							{
								dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]
									=((dq_lcd_bdl_temp_reg_rig_min_value&0xffff00)|dq_lcd_bdl_temp_reg_value_wdqd)	;
							}



							writel(dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1],(reg_add+4*DATX8_DQ_DXNLCDLR1));


						}
						else if(temp_count_k==1)
						{

							dq_lcd_bdl_temp_reg_value_dqs=readl(reg_add+4*DATX8_DQ_DXNLCDLR1);
							dq_lcd_bdl_temp_reg_value_wdqd=(dq_lcd_bdl_temp_reg_value_dqs&0xff);
							dq_lcd_bdl_temp_reg_value_rdqsd=((dq_lcd_bdl_temp_reg_value_dqs&0xff00))>>8;

							while (dq_lcd_bdl_temp_reg_value_rdqsd>0)
							{
								temp_test_error=0;
								dq_lcd_bdl_temp_reg_value_rdqsd--;
								printf("\nrdqsd left temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value_rdqsd);
								dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
								writel(dq_lcd_bdl_temp_reg_value_dqs,(reg_add+4*DATX8_DQ_DXNLCDLR1));
								temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
								if (temp_test_error)
								{
									//printf("\nrdqsd left edge detect \n");
									dq_lcd_bdl_temp_reg_value_rdqsd++;
									break;
								}
							}
							printf("\nrdqsd left edge detect \n");
							printf("\nrdqsd left edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value_rdqsd);
							dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
							//only update dq_lcd_bdl_temp_reg_value_rdqsd rdqsnd
							dq_lcd_bdl_temp_reg_value=dq_lcd_bdl_reg_left[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							dq_lcd_bdl_temp_reg_value_dqs=((dq_lcd_bdl_temp_reg_value&0x0000ff)|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));

							dq_lcd_bdl_reg_left[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]=dq_lcd_bdl_temp_reg_value_dqs;


							dq_lcd_bdl_temp_reg_lef_min_value=dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							if (dq_lcd_bdl_temp_reg_value_rdqsd>((dq_lcd_bdl_temp_reg_lef_min_value>>8)&0xff))  //update wdqd min value
							{
								dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]
									=((dq_lcd_bdl_temp_reg_lef_min_value&0xff)|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16))	;
							}


							writel(dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1],(reg_add+4*DATX8_DQ_DXNLCDLR1));

							dq_lcd_bdl_temp_reg_value_dqs=readl(reg_add+4*DATX8_DQ_DXNLCDLR1);
							dq_lcd_bdl_temp_reg_value_wdqd=(dq_lcd_bdl_temp_reg_value_dqs&0xff);
							dq_lcd_bdl_temp_reg_value_rdqsd=((dq_lcd_bdl_temp_reg_value_dqs&0xff00))>>8;

							while (dq_lcd_bdl_temp_reg_value_rdqsd<0xff)
							{
								temp_test_error=0;
								dq_lcd_bdl_temp_reg_value_rdqsd++;
								printf("\nrdqsd right temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value_rdqsd);
								dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
								writel(dq_lcd_bdl_temp_reg_value_dqs,(reg_add+4*DATX8_DQ_DXNLCDLR1));
								temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
								if (temp_test_error)
								{
									//printf("\nrdqsd right edge detect \n");
									dq_lcd_bdl_temp_reg_value_rdqsd--;
									break;
								}
							}
							printf("\nrdqsd right edge detect \n");
							printf("\nrdqsd right edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value_rdqsd);
							dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
							//only update dq_lcd_bdl_temp_reg_value_rdqsd rdqsnd
							dq_lcd_bdl_temp_reg_value=dq_lcd_bdl_reg_right[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							dq_lcd_bdl_temp_reg_value_dqs=((dq_lcd_bdl_temp_reg_value&0x0000ff)|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
							dq_lcd_bdl_reg_right[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]=dq_lcd_bdl_temp_reg_value_dqs;


							dq_lcd_bdl_temp_reg_rig_min_value=dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							if (dq_lcd_bdl_temp_reg_value_rdqsd<((dq_lcd_bdl_temp_reg_rig_min_value>>8)&0xff))  //update wdqd min value
							{
								dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]
									=((dq_lcd_bdl_temp_reg_rig_min_value&0xff)|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16))	;
							}



							writel(dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1],(reg_add+4*DATX8_DQ_DXNLCDLR1));




						}

					}
				}

			}
		}

		////tune and save training dqs value




		////calculate and print  dqs value
		for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
		{
			if (( channel_a_en) && ( channel_b_en == 0))
			{
				reg_base_adj=CHANNEL_A_REG_BASE;
			}
			else if(( channel_b_en)&&( channel_a_en==0))
			{
				reg_base_adj=CHANNEL_B_REG_BASE;
			}
			else if ((channel_a_en+channel_b_en)==2)
			{
				if ( testing_channel == CHANNEL_A)
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if( testing_channel==CHANNEL_B)
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
			}
			reg_add=DDR0_PUB_DX0BDLR0+reg_base_adj;


			for ((temp_count_j=0);(temp_count_j<DQ_LCD_BDL_REG_NUM_PER_CHANNEL);(temp_count_j++))
			{
				//  dq_lcd_bdl_reg_index[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j]=reg_add+4*temp_count_j;

				printf("\n org add  0x%08x reg== 0x%08x\n",(dq_lcd_bdl_reg_index[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_j]), (dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_j]));
			}

			for ((temp_count_j=0);(temp_count_j<DQ_LCD_BDL_REG_NUM_PER_CHANNEL);(temp_count_j++))
			{
				printf("\n lef add  0x%08x reg== 0x%08x\n",(dq_lcd_bdl_reg_index[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_j]), (dq_lcd_bdl_reg_left[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_j]));
			}

			for ((temp_count_j=0);(temp_count_j<DQ_LCD_BDL_REG_NUM_PER_CHANNEL);(temp_count_j++))
			{
				printf("\n rig add  0x%08x reg== 0x%08x\n",(dq_lcd_bdl_reg_index[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_j]), (dq_lcd_bdl_reg_right[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_j]));
			}

			printf("\n ddrtest size ==0x%08x, test times==0x%08x,test_loop==0x%08x\n",ddr_test_size,(test_times+1),test_loop);
			printf("\n add  0x00000000 reg==    org           lef           rig           center        win           lef_m         rig_m         min_c         min_win        \n");
			for ((temp_count_i=0);(temp_count_i<DATX8_DQ_LANE_WIDTH);(temp_count_i++))
			{
				{

					if (temp_count_i == DATX8_DQ_LANE_LANE00)
					{
						reg_add=DDR0_PUB_DX0BDLR0+reg_base_adj+DATX8_DQ_DXNLCDLR1*4;}

					else    if(temp_count_i==DATX8_DQ_LANE_LANE01)
					{
						reg_add=DDR0_PUB_DX1BDLR0+reg_base_adj+DATX8_DQ_DXNLCDLR1*4;}

					else   	 if(temp_count_i==DATX8_DQ_LANE_LANE02)
					{
						reg_add=DDR0_PUB_DX2BDLR0+reg_base_adj+DATX8_DQ_DXNLCDLR1*4;}
					else    if(temp_count_i==DATX8_DQ_LANE_LANE03)
					{
						reg_add=DDR0_PUB_DX3BDLR0+reg_base_adj+DATX8_DQ_DXNLCDLR1*4;}
				}

				dq_lcd_bdl_temp_reg_lef=(dq_lcd_bdl_reg_left[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]);
				dq_lcd_bdl_temp_reg_rig=(dq_lcd_bdl_reg_right[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]);

				if (test_times == 0)
				{
					(dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1])=dq_lcd_bdl_temp_reg_lef;
					(dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1])=dq_lcd_bdl_temp_reg_rig;

				}
				dq_lcd_bdl_temp_reg_lef_min_value=(dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]);
				dq_lcd_bdl_temp_reg_rig_min_value=(dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]);


				//dq_lcd_bdl_temp_reg_value_wdqd=(dq_lcd_bdl_temp_reg_value&0x0000ff);
				dq_lcd_bdl_temp_reg_center=( (((dq_lcd_bdl_temp_reg_lef&0xff)+(dq_lcd_bdl_temp_reg_rig&0xff))/2)
						|(((((dq_lcd_bdl_temp_reg_lef>>8)&0xff)+((dq_lcd_bdl_temp_reg_rig>>8)&0xff))/2)<<8)
						|(((((dq_lcd_bdl_temp_reg_lef>>16)&0xff)+((dq_lcd_bdl_temp_reg_rig>>8)&0xff))/2)<<16) );

				dq_lcd_bdl_temp_reg_windows=( (((dq_lcd_bdl_temp_reg_rig&0xff)-(dq_lcd_bdl_temp_reg_lef&0xff)))
						|(((((dq_lcd_bdl_temp_reg_rig>>8)&0xff)-((dq_lcd_bdl_temp_reg_lef>>8)&0xff)))<<8)
						|(((((dq_lcd_bdl_temp_reg_rig>>16)&0xff)-((dq_lcd_bdl_temp_reg_lef>>8)&0xff)))<<16) );


				dq_lcd_bdl_temp_reg_center_min=( (((dq_lcd_bdl_temp_reg_lef_min_value&0xff)+(dq_lcd_bdl_temp_reg_rig_min_value&0xff))/2)
						|(((((dq_lcd_bdl_temp_reg_lef_min_value>>8)&0xff)+((dq_lcd_bdl_temp_reg_rig_min_value>>8)&0xff))/2)<<8)
						|(((((dq_lcd_bdl_temp_reg_lef_min_value>>16)&0xff)+((dq_lcd_bdl_temp_reg_rig_min_value>>8)&0xff))/2)<<16) );

				dq_lcd_bdl_temp_reg_windows_min=( (((dq_lcd_bdl_temp_reg_rig_min_value&0xff)-(dq_lcd_bdl_temp_reg_lef_min_value&0xff)))
						|(((((dq_lcd_bdl_temp_reg_rig_min_value>>8)&0xff)-((dq_lcd_bdl_temp_reg_lef_min_value>>8)&0xff)))<<8)
						|(((((dq_lcd_bdl_temp_reg_rig_min_value>>16)&0xff)-((dq_lcd_bdl_temp_reg_lef_min_value>>8)&0xff)))<<16) );

				printf("\n add  0x%08x reg==    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x\n",
						(dq_lcd_bdl_reg_index[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]),
						(dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]),
						(dq_lcd_bdl_reg_left[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]),
						(dq_lcd_bdl_reg_right[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]),
						dq_lcd_bdl_temp_reg_center,dq_lcd_bdl_temp_reg_windows,
						(dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]),
						(dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]),
						dq_lcd_bdl_temp_reg_center_min,dq_lcd_bdl_temp_reg_windows_min
					  );
			}


		}

	}




	return 0;

usage:
	cmd_usage(cmdtp);
	return 1;

}

U_BOOT_CMD(
	ddr_tune_dqs,	6,	1,	do_ddr_test_fine_tune_dqs,
	"DDR tune dqs function",
	"ddr_tune_dqs a 0 0x80000 3 or ddr_tune_dqs b 0 0x80000 5 or ddr_tune_dqs a b 0x80000 l\n dcache off ? \n"
);



int do_ddr_test_dqs_window_step(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter test ddr dqs window step function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);

	unsigned int   temp_test_error= 0;


	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_lane_step=0;
	unsigned int   testing_lane=0;
	unsigned int   test_lane_step_rdqs_flag=0;
	unsigned int   test_min_max_flag=0;
	unsigned int   test_times=1;
	unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;


	unsigned int   dq_lcd_bdl_reg_org=0;
	unsigned int   dq_lcd_bdl_reg_left=0;
	unsigned int   dq_lcd_bdl_reg_right=0;


	unsigned int   dq_lcd_bdl_reg_left_min=0;
	unsigned int   dq_lcd_bdl_reg_right_min=0;

	unsigned int   dq_lcd_bdl_temp_reg_value=0;


	//  unsigned int   dq_lcd_bdl_temp_reg_lef_min_value;
	//     unsigned int   dq_lcd_bdl_temp_reg_rig_min_value;


	//   unsigned int   dq_lcd_bdl_temp_reg_lef;
	//   unsigned int   dq_lcd_bdl_temp_reg_rig;


	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;



	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))

		{channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))

		{channel_b_en = 1;
		}
		else
		{
			goto usage;
		}
	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))

		{channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

		{channel_b_en = 1;
		}
	}
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}

	}
	if (argc >4) {
		test_lane_step = 0;
		test_lane_step = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
		{
			test_lane_step = 0;
		}
		if   ((strcmp(argv[4], "l") == 0) || (strcmp(argv[4], "L") == 0))
		{
			test_lane_step = 0;
		}
	}
	if (test_lane_step >7)
		test_lane_step = 0;
	unsigned int   test_loop=1;
	if (argc >5) {

		test_min_max_flag = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
		{
			test_min_max_flag = 0;
		}
		else
		{
			//test_min_max_flag =1;
		}
	}
	unsigned int   test_temp_value_use_sticky_register=0;
	if (argc >6) {

		test_temp_value_use_sticky_register = simple_strtoull_ddr(argv[6], &endp, 16);
		if (*argv[6] == 0 || *endp != 0)
		{
			test_temp_value_use_sticky_register = 0;
		}
		else
		{
			//test_min_max_flag =1;
		}
	}
	sticky_reg_base_add=(DDR0_PUB_REG_BASE&0xffff0000)+((DMC_STICKY_0)&0xffff);

	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_lane_step== 0x%08x\n", test_lane_step);
	printf("\ntest_min_max_flag== 0x%08x\n", test_min_max_flag);
	printf("\ntest_temp_value_use_sticky_register== 0x%08x\n", test_temp_value_use_sticky_register);

	const char *temp_s;
	char *env_lcdlr_temp_count;
	char *buf;
	buf="";
	unsigned int lcdlr_temp_count=0;
	env_lcdlr_temp_count="lcdlr_temp_count";

	if(test_temp_value_use_sticky_register)
	{lcdlr_temp_count=readl((sticky_reg_base_add+(6<<2)));
	}
	else
	{

		temp_s= getenv(env_lcdlr_temp_count);
		if(temp_s)
		{
			lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
		}
		else
		{lcdlr_temp_count=0;
		}
	}

	if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}



	//save and print org training dqs value
	if (channel_a_en || channel_b_en)
	{
		//dcache_disable();
		//serial_puts("\ndebug for ddrtest ,jiaxing disable dcache");

	}////save and print org training dqs value


	for (test_times=0;(test_times<test_loop);(test_times++))
	{
		////tune and save training dqs value
		if (channel_a_en || channel_b_en)

		{

			{

				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}



				{
					printf("\nshould pause ddl pir== 0x%08x,if no pause ddl ,write lcdlr some time may occur error\n", readl(DDR0_PUB_REG_BASE+4));
					writel((readl(DDR0_PUB_REG_BASE+4))|(1<<29),(DDR0_PUB_REG_BASE+4));
					printf("\n pause ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
					if( channel_b_en)
					{	printf("\nddr1 should pause ddl pir== 0x%08x,if no pause ddl ,write lcdlr some time may occur error\n", readl(DDR1_PUB_REG_BASE+4));
						writel((readl(DDR1_PUB_REG_BASE+4))|(1<<29),(DDR1_PUB_REG_BASE+4));
						printf("\n ddr1 pause ddl pir== 0x%08x\n", readl(DDR1_PUB_REG_BASE+4));
					}
					if (test_lane_step>8)
						test_lane_step=0;
					printf("\ntest_lane_step==0x%08x\n ",test_lane_step);

					reg_add=DDR0_PUB_DX0BDLR0+reg_base_adj+(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_lane_step>>1);
					test_lane_step_rdqs_flag=test_lane_step%2;
					testing_lane=(test_lane_step>>1);
					if (!test_lane_step_rdqs_flag)
					{reg_add=reg_add+DDR0_PUB_DX0LCDLR1-DDR0_PUB_DX0BDLR0;
					}
					else
					{
#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
						reg_add=reg_add+DDR0_PUB_DX0LCDLR1-DDR0_PUB_DX0BDLR0;
#else
						reg_add=reg_add+DDR0_PUB_DX0LCDLR3-DDR0_PUB_DX0BDLR0;
#endif

					}

					dq_lcd_bdl_temp_reg_value=readl(reg_add);
					dq_lcd_bdl_reg_org=dq_lcd_bdl_temp_reg_value;
					printf("\nreg_add_0x%08x==0x%08x\n ",reg_add,dq_lcd_bdl_temp_reg_value);
#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
					if (test_lane_step_rdqs_flag)
					{dq_lcd_bdl_temp_reg_value=(((readl(reg_add))&0xff00)>>8);
						dq_lcd_bdl_reg_org=dq_lcd_bdl_temp_reg_value;
					}
					else
					{dq_lcd_bdl_temp_reg_value=(((readl(reg_add))&0x00ff)>>0);
						dq_lcd_bdl_reg_org=dq_lcd_bdl_temp_reg_value;
					}
#endif

					if ((test_min_max_flag == 0)||( (test_min_max_flag == 2)))
					{
						while (dq_lcd_bdl_temp_reg_value>0)
						{
							ddr_test_watchdog_clear();
							temp_test_error=0;
							dq_lcd_bdl_temp_reg_value--;

							{
								lcdlr_temp_count=dq_lcd_bdl_temp_reg_value;
								sprintf(buf, "0x%08x", lcdlr_temp_count);
								printf( "%s\n", buf);
								if(test_temp_value_use_sticky_register)
								{
									writel(lcdlr_temp_count,(sticky_reg_base_add+(6<<2)));
								}
								else
								{
									setenv(env_lcdlr_temp_count, buf);
									run_command("save",0);
								}
							}



							printf("\n left temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value);
							if (!test_lane_step_rdqs_flag)
							{
#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
								writel((dq_lcd_bdl_temp_reg_value<<0)|(((readl(reg_add))&0xffff00)),reg_add);
#else
								writel(dq_lcd_bdl_temp_reg_value,reg_add);
#endif
							}
							else
							{
#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
								writel((dq_lcd_bdl_temp_reg_value<<8)|(dq_lcd_bdl_temp_reg_value<<16)|(((readl(reg_add))&0xff)),reg_add);
#else
								writel(dq_lcd_bdl_temp_reg_value,reg_add);
								writel(dq_lcd_bdl_temp_reg_value,reg_add+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR3);
#endif
							}
							printf("\n rmin read reg==0x%08x\n ",(readl(reg_add)));
							temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

							if (temp_test_error)
							{
								//printf("\nwdqd left edge detect \n");
								dq_lcd_bdl_temp_reg_value++;
								break;
							}
						}
						printf("\n left edge detect \n");
						printf("\nleft edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value);


						dq_lcd_bdl_reg_left=dq_lcd_bdl_temp_reg_value;
						if (test_times == 0)
							dq_lcd_bdl_reg_left_min=dq_lcd_bdl_reg_left;
						if (dq_lcd_bdl_reg_left>dq_lcd_bdl_reg_left_min)  //update wdqd min value
						{
							dq_lcd_bdl_reg_left_min=dq_lcd_bdl_reg_left	;
						}
					} else
					{
						printf("\n left edge skip \n");
					}

					if (!test_lane_step_rdqs_flag)
					{
#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
						writel((dq_lcd_bdl_reg_org<<0)|(((readl(reg_add))&0xffff00)),reg_add);
#else
						writel(dq_lcd_bdl_reg_org,reg_add);
#endif
						//  writel(dq_lcd_bdl_reg_org,reg_add);
					}
					else
					{
#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
						writel((dq_lcd_bdl_reg_org<<8)|(dq_lcd_bdl_reg_org<<16)|(((readl(reg_add))&0xff)),reg_add);
#else
						writel(dq_lcd_bdl_reg_org,reg_add);
						writel(dq_lcd_bdl_reg_org,reg_add+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR3);
#endif
						//	  writel(dq_lcd_bdl_reg_org,reg_add);
						//	  writel(dq_lcd_bdl_reg_org,reg_add+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR3);
					}

					dq_lcd_bdl_temp_reg_value=dq_lcd_bdl_reg_org;

					printf("\n read reg==0x%08x\n ",(readl(reg_add)));


					if ((test_min_max_flag == 0)|| (test_min_max_flag == 1))
					{
						while (dq_lcd_bdl_temp_reg_value<DQLCDLR_MAX)
						{
							ddr_test_watchdog_clear();
							temp_test_error=0;
							dq_lcd_bdl_temp_reg_value++;


							{
								lcdlr_temp_count=dq_lcd_bdl_temp_reg_value;
								sprintf(buf, "0x%08x", lcdlr_temp_count);
								printf( "%s\n", buf);
								if(test_temp_value_use_sticky_register)
								{
									writel(lcdlr_temp_count,(sticky_reg_base_add+(6<<2)));
								}
								else
								{
									setenv(env_lcdlr_temp_count, buf);
									run_command("save",0);
								}
							}

							printf("\n rig temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value);
							if (!test_lane_step_rdqs_flag)
							{
								//writel(dq_lcd_bdl_temp_reg_value,reg_add);
#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
								writel((dq_lcd_bdl_temp_reg_value<<0)|(((readl(reg_add))&0xffff00)),reg_add);
#else
								writel(dq_lcd_bdl_temp_reg_value,reg_add);
#endif
							}
							else
							{
#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
								writel((dq_lcd_bdl_temp_reg_value<<8)|(dq_lcd_bdl_temp_reg_value<<16)|(((readl(reg_add))&0xff)),reg_add);
#else
								writel(dq_lcd_bdl_temp_reg_value,reg_add);
								writel(dq_lcd_bdl_temp_reg_value,reg_add+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR3);
#endif
								//	  writel(dq_lcd_bdl_temp_reg_value,reg_add);
								//	  writel(dq_lcd_bdl_temp_reg_value,reg_add+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR3);
							}
							printf("\n r max read reg==0x%08x\n ",(readl(reg_add)));
							temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
							if (temp_test_error)
							{
								//printf("\nwdqd right edge detect \n");
								dq_lcd_bdl_temp_reg_value--;
								break;
							}
						}
						printf("\n right edge detect \n");
						printf("\n right edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value);

						dq_lcd_bdl_reg_right=dq_lcd_bdl_temp_reg_value;
						if (test_times == 0)
							dq_lcd_bdl_reg_right_min=dq_lcd_bdl_reg_right;
						if (dq_lcd_bdl_reg_right<dq_lcd_bdl_reg_right_min)  //update wdqd min value
						{
							dq_lcd_bdl_reg_right_min=dq_lcd_bdl_reg_right	;
						}
					}

					if (!test_lane_step_rdqs_flag)
					{
						// writel(dq_lcd_bdl_reg_org,reg_add);
#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
						writel((dq_lcd_bdl_reg_org<<0)|(((readl(reg_add))&0xffff00)),reg_add);
#else
						writel(dq_lcd_bdl_reg_org,reg_add);
#endif
					}
					else
					{
#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
						writel((dq_lcd_bdl_reg_org<<8)|(dq_lcd_bdl_reg_org<<16)|(((readl(reg_add))&0xff)),reg_add);
#else
						writel(dq_lcd_bdl_reg_org,reg_add);
						writel(dq_lcd_bdl_reg_org,reg_add+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR3);
#endif
						// 	  writel(dq_lcd_bdl_reg_org,reg_add);
						//	  writel(dq_lcd_bdl_reg_org,reg_add+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR3);
					}

					printf("\n read reg==0x%08x\n ",(readl(reg_add)));
					printf("\nend pause ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
					writel(((readl(DDR0_PUB_REG_BASE+4))&(~(1<<29))),(DDR0_PUB_REG_BASE+4));
					printf("\n resume ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
				}



			}
		}

	}

	dq_lcd_bdl_temp_reg_value=(dq_lcd_bdl_reg_right_min<<16)|dq_lcd_bdl_reg_left_min;
	if (!test_lane_step_rdqs_flag)
	{if(channel_a_en){
						 dq_lcd_bdl_value_wdq_org_a[testing_lane]=dq_lcd_bdl_reg_org;
						 if (test_min_max_flag != 1)
							 dq_lcd_bdl_value_wdq_min_a[testing_lane]=dq_lcd_bdl_reg_left_min;
						 if (test_min_max_flag != 2)
							 dq_lcd_bdl_value_wdq_max_a[testing_lane]=dq_lcd_bdl_reg_right_min;
					 }
	if (channel_b_en)
	{
		dq_lcd_bdl_value_wdq_org_b[testing_lane]=dq_lcd_bdl_reg_org;
		if (test_min_max_flag != 1)
			dq_lcd_bdl_value_wdq_min_b[testing_lane]=dq_lcd_bdl_reg_left_min;
		if (test_min_max_flag != 2)
			dq_lcd_bdl_value_wdq_max_b[testing_lane]=dq_lcd_bdl_reg_right_min;
	}
	}
	else
	{
		if (channel_a_en) {
			dq_lcd_bdl_value_rdqs_org_a[testing_lane]=dq_lcd_bdl_reg_org;
			if (test_min_max_flag != 1)
				dq_lcd_bdl_value_rdqs_min_a[testing_lane]=dq_lcd_bdl_reg_left_min;
			if (test_min_max_flag != 2)
				dq_lcd_bdl_value_rdqs_max_a[testing_lane]=dq_lcd_bdl_reg_right_min;
		}
		if (channel_b_en) {
			dq_lcd_bdl_value_rdqs_org_b[testing_lane]=dq_lcd_bdl_reg_org;
			if (test_min_max_flag != 1)
				dq_lcd_bdl_value_rdqs_min_b[testing_lane]=dq_lcd_bdl_reg_left_min;
			if (test_min_max_flag != 2)
				dq_lcd_bdl_value_rdqs_max_b[testing_lane]=dq_lcd_bdl_reg_right_min;
		}
	}

	return dq_lcd_bdl_temp_reg_value;

usage:
	cmd_usage(cmdtp);
	return 1;

}

///*
U_BOOT_CMD(
	ddr_tune_dqs_step,	7,	1,	do_ddr_test_dqs_window_step,
	"ddr_tune_dqs_step function",
	"ddr_tune_dqs_step a 0 0x80000 3 or ddr_tune_dqs_step b 0 0x80000 5 \n dcache off ? \n"
);



extern int ddr_test_s_add_cross_talk_pattern(int ddr_test_size);


int do_ddr_test_lcdlr_clk_step(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter test ddr lcdlr clk step function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);

	unsigned int   temp_test_error= 0;


	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_lane_step=0;
	// unsigned int   testing_lane=0;
	// unsigned int   test_lane_step_rdqs_flag=0;
	unsigned int   test_min_max_flag=0;
	unsigned int   test_times=1;
	unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;


	unsigned int   dq_lcd_bdl_reg_org=0;
	unsigned int   dq_lcd_bdl_reg_left=0;
	unsigned int   dq_lcd_bdl_reg_right=0;


	unsigned int   dq_lcd_bdl_reg_left_min=0;
	unsigned int   dq_lcd_bdl_reg_right_min=0;

	unsigned int   dq_lcd_bdl_temp_reg_value=0;


	//  unsigned int   dq_lcd_bdl_temp_reg_lef_min_value;
	//     unsigned int   dq_lcd_bdl_temp_reg_rig_min_value;


	//   unsigned int   dq_lcd_bdl_temp_reg_lef;
	//   unsigned int   dq_lcd_bdl_temp_reg_rig;


	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;



	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))

		{channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))

		{channel_b_en = 1;
		}
		else
		{
			goto usage;
		}
	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))

		{channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

		{channel_b_en = 1;
		}
	}
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}

	}
	if (argc >4) {
		test_lane_step = 0;
		test_lane_step = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
		{
			test_lane_step = 0;
		}
		if   ((strcmp(argv[4], "l") == 0) || (strcmp(argv[4], "L") == 0))
		{
			test_lane_step = 0;
		}
	}
	if (test_lane_step >7)
		test_lane_step = 0;
	unsigned int   test_loop=1;
	if (argc >5) {

		test_min_max_flag = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
		{
			test_min_max_flag = 0;
		}
		else
		{
			//test_min_max_flag =1;
		}
	}
	unsigned int   test_temp_value_use_sticky_register=0;
	if (argc >6) {

		test_temp_value_use_sticky_register = simple_strtoull_ddr(argv[6], &endp, 16);
		if (*argv[6] == 0 || *endp != 0)
		{
			test_temp_value_use_sticky_register = 0;
		}
		else
		{
			//test_min_max_flag =1;
		}
	}
	sticky_reg_base_add=(DDR0_PUB_REG_BASE&0xffff0000)+((DMC_STICKY_0)&0xffff);
	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_lane_step== 0x%08x\n", test_lane_step);
	printf("\ntest_min_max_flag== 0x%08x\n", test_min_max_flag);
	printf("\ntest_temp_value_use_sticky_register== 0x%08x\n", test_temp_value_use_sticky_register);
	const char *temp_s;
	char *env_lcdlr_temp_count;
	char *buf;
	buf="";
	unsigned int lcdlr_temp_count=0;
	env_lcdlr_temp_count="lcdlr_temp_count_a";
	unsigned int lcdlr_max=0;
	if(test_temp_value_use_sticky_register)
	{lcdlr_temp_count=readl((sticky_reg_base_add+(6<<2)));
	}
	else
	{

		temp_s= getenv(env_lcdlr_temp_count);
		if(temp_s)
		{
			lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
		}
		else
		{lcdlr_temp_count=0;
		}
	}

	if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}



	//save and print org training dqs value
	if (channel_a_en || channel_b_en)
	{
		//dcache_disable();
		//serial_puts("\ndebug for ddrtest ,jiaxing disable dcache");

	}////save and print org training dqs value


	for (test_times=0;(test_times<test_loop);(test_times++))
	{
		////tune and save training dqs value
		if (channel_a_en || channel_b_en)

		{

			{

				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}



				{
					printf("\nshould pause ddl pir== 0x%08x,if no pause ddl ,write lcdlr some time may occur error\n", readl(DDR0_PUB_REG_BASE+4));
					writel((readl(DDR0_PUB_REG_BASE+4))|(1<<29),(DDR0_PUB_REG_BASE+4));
					printf("\n pause ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
					if( channel_b_en)
					{	printf("\nddr1 should pause ddl pir== 0x%08x,if no pause ddl ,write lcdlr some time may occur error\n", readl(DDR1_PUB_REG_BASE+4));
						writel((readl(DDR1_PUB_REG_BASE+4))|(1<<29),(DDR1_PUB_REG_BASE+4));
						printf("\n ddr1 pause ddl pir== 0x%08x\n", readl(DDR1_PUB_REG_BASE+4));
					}
					if (test_lane_step>2)
						test_lane_step=0;
					printf("\ntest_lane_step==0x%08x\n ",test_lane_step);
					if(test_lane_step==0)
					{reg_add=DDR0_PUB_ACLCDLR+reg_base_adj;
						lcdlr_max=ACLCDLR_MAX;
					}
					if(test_lane_step==1)
					{reg_add=DDR0_PUB_ACBDLR0+reg_base_adj;
						lcdlr_max=ACBDLR_MAX;
					}


					dq_lcd_bdl_temp_reg_value=readl(reg_add);
					dq_lcd_bdl_reg_org=dq_lcd_bdl_temp_reg_value;
					printf("\nreg_add_0x%08x==0x%08x\n ",reg_add,dq_lcd_bdl_temp_reg_value);

					if(test_lane_step==0)
					{dq_lcd_bdl_temp_reg_value=(((readl(reg_add))&ACLCDLR_MAX));
						dq_lcd_bdl_reg_org=dq_lcd_bdl_temp_reg_value;
					}
					if(test_lane_step==1)
					{dq_lcd_bdl_temp_reg_value=(((readl(reg_add))&ACBDLR_MAX));
						dq_lcd_bdl_reg_org=dq_lcd_bdl_temp_reg_value;
					}


					if ((test_min_max_flag == 0)||( (test_min_max_flag == 2)))
					{
						while (dq_lcd_bdl_temp_reg_value>0)
						{
							ddr_test_watchdog_clear();
							temp_test_error=0;
							dq_lcd_bdl_temp_reg_value--;

							{
								lcdlr_temp_count=dq_lcd_bdl_temp_reg_value;
								sprintf(buf, "0x%08x", lcdlr_temp_count);
								printf( "%s\n", buf);
								if(test_temp_value_use_sticky_register)
								{
									writel(lcdlr_temp_count,(sticky_reg_base_add+(6<<2)));
								}
								else
								{
									setenv(env_lcdlr_temp_count, buf);
									run_command("save",0);
								}

							}



							printf("\n left temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value);

							{
								writel(dq_lcd_bdl_temp_reg_value,reg_add);
							}

							printf("\n rmin read reg==0x%08x\n ",(readl(reg_add)));
							//temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
							//#ifdef DDR_LCDLR_CK_USE_FAST_PATTERN
							temp_test_error=ddr_test_s_add_cross_talk_pattern(ddr_test_size);
							// #else
							//  temp_test_error= ddr_test_s_add_cross_talk_pattern(ddr_test_size);
							//  temp_test_error= temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
							//  #endif


							if (temp_test_error)
							{
								//printf("\nwdqd left edge detect \n");
								dq_lcd_bdl_temp_reg_value++;
								break;
							}
						}
						printf("\n left edge detect \n");
						printf("\nleft edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value);


						dq_lcd_bdl_reg_left=dq_lcd_bdl_temp_reg_value;
						if (test_times == 0)
							dq_lcd_bdl_reg_left_min=dq_lcd_bdl_reg_left;
						if (dq_lcd_bdl_reg_left>dq_lcd_bdl_reg_left_min)  //update wdqd min value
						{
							dq_lcd_bdl_reg_left_min=dq_lcd_bdl_reg_left	;
						}
					}
					else
					{
						printf("\n left edge skip \n");
					}


					{

						writel(dq_lcd_bdl_reg_org,reg_add);

					}

					dq_lcd_bdl_temp_reg_value=dq_lcd_bdl_reg_org;

					printf("\n read reg==0x%08x\n ",(readl(reg_add)));


					if ((test_min_max_flag == 0)|| (test_min_max_flag == 1))
					{
						//if(test_lane_step==0)
						while (dq_lcd_bdl_temp_reg_value<lcdlr_max)
						{
							ddr_test_watchdog_clear();
							temp_test_error=0;
							dq_lcd_bdl_temp_reg_value++;
							{
								lcdlr_temp_count=dq_lcd_bdl_temp_reg_value;
								sprintf(buf, "0x%08x", lcdlr_temp_count);
								printf( "%s\n", buf);
								if(test_temp_value_use_sticky_register)
								{
									writel(lcdlr_temp_count,(sticky_reg_base_add+(6<<2)));
								}
								else
								{
									setenv(env_lcdlr_temp_count, buf);
									run_command("save",0);
								}
							}

							printf("\n rig temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value);
							{
								writel(dq_lcd_bdl_temp_reg_value,reg_add);
							}

							printf("\n r max read reg==0x%08x\n ",(readl(reg_add)));
							//	temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
							temp_test_error=ddr_test_s_add_cross_talk_pattern(ddr_test_size);
							if (temp_test_error)
							{
								//printf("\nwdqd right edge detect \n");
								dq_lcd_bdl_temp_reg_value--;
								break;
							}
						}
						printf("\n right edge detect \n");
						printf("\n right edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value);

						dq_lcd_bdl_reg_right=dq_lcd_bdl_temp_reg_value;
						if (test_times == 0)
							dq_lcd_bdl_reg_right_min=dq_lcd_bdl_reg_right;
						if (dq_lcd_bdl_reg_right<dq_lcd_bdl_reg_right_min)  //update wdqd min value
						{
							dq_lcd_bdl_reg_right_min=dq_lcd_bdl_reg_right	;
						}
					}

					{
						writel(dq_lcd_bdl_reg_org,reg_add);
					}

					printf("\n read reg==0x%08x\n ",(readl(reg_add)));
					printf("\nend pause ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
					writel(((readl(DDR0_PUB_REG_BASE+4))&(~(1<<29))),(DDR0_PUB_REG_BASE+4));
					printf("\n resume ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
				}



			}
		}

	}

	dq_lcd_bdl_temp_reg_value=(dq_lcd_bdl_reg_right_min<<16)|dq_lcd_bdl_reg_left_min;

	{if(channel_a_en){
						 if(test_lane_step==0)
						 {
							 dq_lcd_bdl_value_aclcdlr_org_a=dq_lcd_bdl_reg_org;
							 if (test_min_max_flag != 1)
								 dq_lcd_bdl_value_aclcdlr_min_a=dq_lcd_bdl_reg_left_min;
							 if (test_min_max_flag != 2)
								 dq_lcd_bdl_value_aclcdlr_max_a=dq_lcd_bdl_reg_right_min;
						 }
						 if(test_lane_step==1)
						 {
							 dq_lcd_bdl_value_bdlr0_org_a=dq_lcd_bdl_reg_org;
							 if (test_min_max_flag != 1)
								 dq_lcd_bdl_value_bdlr0_min_a=dq_lcd_bdl_reg_left_min;
							 if (test_min_max_flag != 2)
								 dq_lcd_bdl_value_bdlr0_max_a=dq_lcd_bdl_reg_right_min;
						 }
					 }
	if (channel_b_en)
	{
		if(test_lane_step==0)
		{
			dq_lcd_bdl_value_aclcdlr_org_b=dq_lcd_bdl_reg_org;
			if (test_min_max_flag != 1)
				dq_lcd_bdl_value_aclcdlr_min_b=dq_lcd_bdl_reg_left_min;
			if (test_min_max_flag != 2)
				dq_lcd_bdl_value_aclcdlr_max_b=dq_lcd_bdl_reg_right_min;
		}
		if(test_lane_step==1)
		{
			dq_lcd_bdl_value_bdlr0_org_b=dq_lcd_bdl_reg_org;
			if (test_min_max_flag != 1)
				dq_lcd_bdl_value_bdlr0_min_b=dq_lcd_bdl_reg_left_min;
			if (test_min_max_flag != 2)
				dq_lcd_bdl_value_bdlr0_max_b=dq_lcd_bdl_reg_right_min;
		}
	}
	}



	return dq_lcd_bdl_temp_reg_value;

usage:
	cmd_usage(cmdtp);
	return 1;

}

U_BOOT_CMD(
	ddr_tune_aclcdlr_step,	7,	1,	do_ddr_test_lcdlr_clk_step,
	"ddr_tune_aclcdlr_step function",
	"ddr_tune_aclcdlr_step a 0 0x80000 3 or ddr_tune_aclcdlr_step b 0 0x80000 5 \n dcache off ? \n"
);

int do_ddr_test_dqs_window(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnterddr_test_dqs_window function\n");
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;
	// unsigned int   reg_add=0;
	// unsigned int   reg_base_adj=0;

	unsigned int   lane_step= 0;
	unsigned int   reg_value= 0;
	//int argc2;
	//char     *  argv2[30];
	char *endp;

	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))

		{channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))

		{channel_b_en = 1;
		}


	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))

		{channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

		{channel_b_en = 1;
		}
	}
	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}
	}
	//argc2=5;
	//for(i = 1;i<(argc);i++)
	{
		//argv2[i-1]=argv[i];
	}

	//argv2[0]=argv[1];
	//argv2[1]=argv[2];
	//argv2[2]=argv[3];
	//#include <stdio.h>
	//   unsigned int   wr_adj_per[24] ;
	if(1)
	{
		printf("\ntest use uboot env\n");
		{
			//char str[24];
			const char *s;
			unsigned int str_to_numarry[48];
			//str_buf = (char *)malloc(sizeof(char)*1024);

			unsigned int *num_arry;
			num_arry = (unsigned int *)(&str_to_numarry);
			int i;
			// char *varname;
			// int value=0;

			///varname="env_ddrtest";
			s = getenv("env_wr_lcdlr_pr");
			if (s)
			{//i=0;
				//while(s_temp)
				{
					env_to_num("env_wr_lcdlr_pr",num_arry);//unsigned int *num_arry


					for (i = 0; i < 48; i++) {

						printf("str_to_numarry[%d]==%d\n",i,num_arry[i]);
					}
					//	printf("%s,length=%d",s,(strlen(s)));
					//sscanf(s,"d%,",wr_adj_per);
					//sprintf(str,"d%",s);
					//getc
					//       if (strlen(s) > 16) 
					{
						//   sscanf(s, "%08x, %08x, %08x, \n",
						//          &wr_adj_per[0], &wr_adj_per[1], &wr_adj_per[2]);
					} 
				}
			}
		}
	}
	// unsigned int = 0, max = 0xff, min = 0x00;
	/*
	   if(0)
	   {
	   {printf("\ntest use uboot env\n");
	   {
	//char str[24];
	const char *s;

	// char *varname;
	int value=0;

	///varname="env_ddrtest";
	s = getenv("env_wr_lcdlr_pr");
	if (s)
	{//i=0;
	//while(s_temp)
	{
	printf("%s",s);
	//sscanf(s,"d%,",wr_adj_per);
	//sprintf(str,"d%",s);
	//getc
	if (strlen(s) > 16) {
	sscanf(s, "%08x, %08x, %08x, %08x, %08x\n",
	&wr_adj_per[i-2], &max, &min, &type_h, &type_l);
	} else {
	sscanf(buf, "%08x, %08x, %08x\n",
	&reg, &max, &min);
	}

	}
	value = simple_strtoull_ddr(s, &endp, 16);
	printf("%d",value);
	}
	s = getenv("env_rd_lcdlr_pr");

	if (s)
	{//i=0;
	//while(s_temp)
	{
	printf("%s",s);
	//sscanf(s,"d%,",rd_adj_per);

	}
	//value = simple_strtoull_ddr(s, &endp, 16);
	}

	//sprintf(str, "%lx", value);
	//  setenv("env_ddrtest", str);


	//run_command("save",0);
	}

	if (argc>24+2)
	argc=24+2;
	for(i = 2;i<argc;i++)
	{
	if(i<(2+12)){
	wr_adj_per[i-2]=simple_strtoull_ddr(argv[i], &endp, 16);
	}
	else
	{
	rd_adj_per[i-14]=simple_strtoull_ddr(argv[i], &endp, 16);
	}
	}


	}
	printf(" int wr_adj_per[12]={\n");
	for(i = 0;i<12;i++)
	{
	printf("%04d ,\n",wr_adj_per[i]);
}
printf("};\n");
printf(" int rd_adj_per[12]={\n");
for(i = 0;i<12;i++)
{
	printf("%04d ,\n",rd_adj_per[i]);
}
printf("};\n");

}
*/

char str[100];

if (channel_a_en)
{

	//*(char     *)(argv2[0])="a";
	//	run_command("ddr_test_cmd 11 a 0 0x80000  ",0);
	printf("\ntest dqs window lane a\n");
	for ((lane_step=0);(lane_step<8);(lane_step++))
	{
		//sprintf(argv2[3],"d%",( lane_step));
		//itoa_ddr_test(lane_step,(argv2[3]),10);
		//printf("\nargv2[%d]=%s\n",0,argv2[0]);
		//	printf("\nargv2[%d]=%s\n",3,argv2[3]);
		// reg_value=do_ddr_test_dqs_window_step((cmd_tbl_t * )cmdtp, (int) flag,( int) argc2, (argv2));
		sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d",ddr_test_size,( lane_step));
		printf("\nstr=%s\n",str);
		//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
		//printf("\nstr=%s\n",str);
		run_command(str,0);

	}
}


if (channel_b_en)
{//*(char     *)(argv2[0])="b";
	//	run_command("ddr_test_cmd 11 a 0 0x80000  ",0);
	printf("\ntest dqs window lane b\n");
	for ((lane_step=0);(lane_step<8);(lane_step++))
	{
		//sprintf(str,"ddr_tune_dqs_step  a 0 0x80000 %d",( lane_step));
		//printf("\nstr=%s\n",str);
		sprintf(str,"ddr_tune_dqs_step  b 0 0x%08x %d",ddr_test_size,( lane_step));
		printf("\nstr=%s\n",str);
		run_command(str,0);

	}
}

if (channel_a_en)
{
	for ((lane_step=0);(lane_step<4);(lane_step++))
	{
		printf("\n a_lane_0x%08x|wdq_org 0x%08x  |wdq_min 0x%08x |wdq_max 0x%08x ::|rdqs_org  0x%08x  |rdqs_min 0x%08x |rdqs_max 0x%08x  \n",
				lane_step,
				dq_lcd_bdl_value_wdq_org_a[lane_step],
				dq_lcd_bdl_value_wdq_min_a[lane_step],dq_lcd_bdl_value_wdq_max_a[lane_step],
				dq_lcd_bdl_value_rdqs_org_a[lane_step],
				dq_lcd_bdl_value_rdqs_min_a[lane_step],dq_lcd_bdl_value_rdqs_max_a[lane_step]);
	}}
if (channel_b_en)
{
	for ((lane_step=0);(lane_step<4);(lane_step++))
	{
		printf("\n b_lane_0x%08x|wdq_org 0x%08x  |wdq_min 0x%08x |wdq_max 0x%08x ::|rdqs_org  0x%08x  |rdqs_min 0x%08x |rdqs_max 0x%08x  \n",
				lane_step,
				dq_lcd_bdl_value_wdq_org_b[lane_step],
				dq_lcd_bdl_value_wdq_min_b[lane_step],dq_lcd_bdl_value_wdq_max_b[lane_step],
				dq_lcd_bdl_value_rdqs_org_b[lane_step],
				dq_lcd_bdl_value_rdqs_min_b[lane_step],dq_lcd_bdl_value_rdqs_max_b[lane_step]);
	}}

return reg_value;
}

/*
U_BOOT_CMD(
	ddr_tune_dqs_step,	5,	1,	do_ddr_test_fine_tune_dqs_step,
	"ddr_tune_dqs_step function",
	"ddr_tune_dqs_step a 0 0x800000 3 or ddr_tune_dqs_step b 0 0x800000 5 or ddr_tune_dqs_step a b 0x800000 l\n dcache off ? \n"
);
*/

int do_ddr_test_fine_tune_dqs_step(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter Tune ddr dqs step function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);
	//  unsigned int   loop = 1;
	unsigned int   temp_count_i = 1;
	unsigned int   temp_count_j= 1;
	unsigned int   temp_count_k= 1;
	unsigned int   temp_test_error= 0;


	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_lane_step=0;
	unsigned int   test_lane_step_rdqs_flag=0;
	unsigned int   test_loop=1;
	unsigned int   test_times=1;
	unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;
	unsigned int   testing_channel = 0;

#define  DATX8_DQ_LCD_BDL_REG_WIDTH  12

#define  DATX8_DQ_LANE_WIDTH  4
#define  CHANNEL_CHANNEL_WIDTH  2

#define  CHANNEL_A  0
#define  CHANNEL_B  1



#define  DATX8_DQ_LANE_LANE00  0
#define  DATX8_DQ_LANE_LANE01  1
#define  DATX8_DQ_LANE_LANE02  2
#define  DATX8_DQ_LANE_LANE03  3

#define  DATX8_DQ_BDLR0  0
#define  DATX8_DQ_BDLR1  1
#define  DATX8_DQ_BDLR2  2
#define  DATX8_DQ_BDLR3  3
#define  DATX8_DQ_BDLR4  4
#define  DATX8_DQ_BDLR5  5
#define  DATX8_DQ_BDLR6  6
#define  DATX8_DQ_DXNLCDLR0     7
#define  DATX8_DQ_DXNLCDLR1     8
#define  DATX8_DQ_DXNLCDLR2     9
#define  DATX8_DQ_DXNMDLR        10
#define  DATX8_DQ_DXNGTR          11


#define  DDR_CORSS_TALK_TEST_SIZE   0x20000

#define  DQ_LCD_BDL_REG_NUM_PER_CHANNEL  DATX8_DQ_LCD_BDL_REG_WIDTH*DATX8_DQ_LANE_WIDTH
#define  DQ_LCD_BDL_REG_NUM    DQ_LCD_BDL_REG_NUM_PER_CHANNEL*CHANNEL_CHANNEL_WIDTH

	unsigned int   dq_lcd_bdl_reg_org[DQ_LCD_BDL_REG_NUM];
	unsigned int   dq_lcd_bdl_reg_left[DQ_LCD_BDL_REG_NUM];
	unsigned int   dq_lcd_bdl_reg_right[DQ_LCD_BDL_REG_NUM];
	unsigned int   dq_lcd_bdl_reg_index[DQ_LCD_BDL_REG_NUM];

	unsigned int   dq_lcd_bdl_reg_left_min[DQ_LCD_BDL_REG_NUM];
	unsigned int   dq_lcd_bdl_reg_right_min[DQ_LCD_BDL_REG_NUM];

	unsigned int   dq_lcd_bdl_temp_reg_value;
	unsigned int   dq_lcd_bdl_temp_reg_value_dqs;
	unsigned int   dq_lcd_bdl_temp_reg_value_wdqd;
	unsigned int   dq_lcd_bdl_temp_reg_value_rdqsd;
	//  unsigned int   dq_lcd_bdl_temp_reg_value_rdqsnd;
	unsigned int   dq_lcd_bdl_temp_reg_lef_min_value;
	unsigned int   dq_lcd_bdl_temp_reg_rig_min_value;
	//   unsigned int   dq_lcd_bdl_temp_reg_value_dqs;
	//  unsigned int   dq_lcd_bdl_temp_reg_value_wdqd;
	//   unsigned int   dq_lcd_bdl_temp_reg_value_rdqsd;

	unsigned int   dq_lcd_bdl_temp_reg_lef;
	unsigned int   dq_lcd_bdl_temp_reg_rig;
	unsigned int   dq_lcd_bdl_temp_reg_center;
	unsigned int   dq_lcd_bdl_temp_reg_windows;
	unsigned int   dq_lcd_bdl_temp_reg_center_min;
	unsigned int   dq_lcd_bdl_temp_reg_windows_min;

	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;



	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))

		{channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))

		{channel_b_en = 1;
		}
		else
		{
			goto usage;
		}
	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))

		{channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

		{channel_b_en = 1;
		}
	}
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}

	}
	if (argc >4) {
		test_lane_step = 0;
		test_lane_step = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
		{
			test_lane_step = 0;
		}
		if   ((strcmp(argv[4], "l") == 0) || (strcmp(argv[4], "L") == 0))
		{
			test_lane_step = 0;
		}
	}
	test_loop=1;

	unsigned int   test_min_max=0;
	if (argc >5) {

		test_min_max = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
		{
			test_min_max = 0;
		}
		else
			test_min_max=1;

	}

	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_lane_step== 0x%08x\n", test_lane_step);
	printf("\ntest_loop== 0x%08x\n", test_loop);
	printf("\ntest_min_max== 0x%08x\n", test_min_max);
	if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}



	//save and print org training dqs value
	if (channel_a_en || channel_b_en)
	{


		//dcache_disable();
		//serial_puts("\ndebug for ddrtest ,jiaxing disable dcache");

		{
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{
				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;
					}
				}

				for ((temp_count_i=0);(temp_count_i<DATX8_DQ_LANE_WIDTH);(temp_count_i++))
				{

					if (temp_count_i == DATX8_DQ_LANE_LANE00)
					{
						reg_add=DDR0_PUB_DX0BDLR0+reg_base_adj;}

					else    if(temp_count_i==DATX8_DQ_LANE_LANE01)
					{
						reg_add=DDR0_PUB_DX1BDLR0+reg_base_adj;}

					else   	 if(temp_count_i==DATX8_DQ_LANE_LANE02)
					{
						reg_add=DDR0_PUB_DX2BDLR0+reg_base_adj;}
					else    if(temp_count_i==DATX8_DQ_LANE_LANE03)
					{
						reg_add=DDR0_PUB_DX3BDLR0+reg_base_adj;}



					for ((temp_count_j=0);(temp_count_j<DATX8_DQ_LCD_BDL_REG_WIDTH);(temp_count_j++))
					{
						dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j]=readl(reg_add+4*temp_count_j);
						dq_lcd_bdl_reg_index[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j]=reg_add+4*temp_count_j;
						printf("\n org add  0x%08x reg== 0x%08x\n",(reg_add+4*temp_count_j), (dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j]));
						dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j]
							=dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j];
						dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j]
							=dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j];

					}
				}

			}

		}

	}////save and print org training dqs value


	for (test_times=0;(test_times<test_loop);(test_times++))
	{
		////tune and save training dqs value
		if (channel_a_en || channel_b_en)

		{
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{

				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;
					}
				}

				for ((temp_count_i=0);(temp_count_i<DATX8_DQ_LANE_WIDTH);(temp_count_i++))
				{
					if (test_lane_step>8)
						test_lane_step=0;
					if (test_lane_step)
					{
						printf("\ntest_lane_step==0x%08x\n ",test_lane_step);
						temp_count_i=(test_lane_step>>1);
						test_lane_step_rdqs_flag=test_lane_step-(temp_count_i<<1);
						test_lane_step=0;
					}
					{
						printf("\ntest lane==0x%08x\n ",temp_count_i);
						if (temp_count_i == DATX8_DQ_LANE_LANE00)
						{
							reg_add=DDR0_PUB_DX0BDLR0+reg_base_adj;}

						else    if(temp_count_i==DATX8_DQ_LANE_LANE01)
						{
							reg_add=DDR0_PUB_DX1BDLR0+reg_base_adj;}

						else   	 if(temp_count_i==DATX8_DQ_LANE_LANE02)
						{
							reg_add=DDR0_PUB_DX2BDLR0+reg_base_adj;}
						else    if(temp_count_i==DATX8_DQ_LANE_LANE03)
						{
							reg_add=DDR0_PUB_DX3BDLR0+reg_base_adj;}
					}

					for ((temp_count_k=0);(temp_count_k<2);(temp_count_k++))
					{
						if (test_lane_step_rdqs_flag)
						{
							temp_count_k=1;
							test_lane_step_rdqs_flag=0;
						}
						if (temp_count_k == 0)
						{
							dq_lcd_bdl_temp_reg_value_dqs=readl(reg_add+4*DATX8_DQ_DXNLCDLR1);
							dq_lcd_bdl_temp_reg_value_wdqd=(dq_lcd_bdl_temp_reg_value_dqs&0xff);
							dq_lcd_bdl_temp_reg_value_rdqsd=((dq_lcd_bdl_temp_reg_value_dqs&0xff00))>>8;
							//  dq_lcd_bdl_temp_reg_value_rdqsnd=((dq_lcd_bdl_temp_reg_value_dqs&0xff0000))>>16;

							while (dq_lcd_bdl_temp_reg_value_wdqd>0)
							{
								if(test_min_max)
								{break;
								}
								temp_test_error=0;
								dq_lcd_bdl_temp_reg_value_wdqd--;
								printf("\nwdqd left temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value_wdqd);
								dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
								writel(dq_lcd_bdl_temp_reg_value_dqs,(reg_add+4*DATX8_DQ_DXNLCDLR1));
								temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

								if (temp_test_error)
								{
									//printf("\nwdqd left edge detect \n");
									dq_lcd_bdl_temp_reg_value_wdqd++;
									break;
								}
							}
							printf("\nwdqd left edge detect \n");
							printf("\nwdqd left edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value_wdqd);
							dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
							//only update dq_lcd_bdl_temp_reg_value_wdqd
							dq_lcd_bdl_temp_reg_value=dq_lcd_bdl_reg_left[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							dq_lcd_bdl_temp_reg_value_dqs=((dq_lcd_bdl_temp_reg_value&0x00)|dq_lcd_bdl_temp_reg_value_wdqd);
							dq_lcd_bdl_reg_left[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]=dq_lcd_bdl_temp_reg_value_dqs;


							dq_lcd_bdl_temp_reg_lef_min_value=dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							if (dq_lcd_bdl_temp_reg_value_wdqd>(dq_lcd_bdl_temp_reg_lef_min_value&0xff))  //update wdqd min value
							{
								dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]
									=((dq_lcd_bdl_temp_reg_lef_min_value&0xffff00)|dq_lcd_bdl_temp_reg_value_wdqd)	;
							}


							writel(dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1],(reg_add+4*DATX8_DQ_DXNLCDLR1));

							dq_lcd_bdl_temp_reg_value_dqs=readl(reg_add+4*DATX8_DQ_DXNLCDLR1);
							dq_lcd_bdl_temp_reg_value_wdqd=(dq_lcd_bdl_temp_reg_value_dqs&0xff);
							dq_lcd_bdl_temp_reg_value_rdqsd=((dq_lcd_bdl_temp_reg_value_dqs&0xff00))>>8;


							while (dq_lcd_bdl_temp_reg_value_wdqd<0xff)
							{
								temp_test_error=0;
								dq_lcd_bdl_temp_reg_value_wdqd++;
								printf("\nwdqd rig temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value_wdqd);
								dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
								writel(dq_lcd_bdl_temp_reg_value_dqs,(reg_add+4*DATX8_DQ_DXNLCDLR1));
								temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
								if (temp_test_error)
								{
									//printf("\nwdqd right edge detect \n");
									dq_lcd_bdl_temp_reg_value_wdqd--;
									break;
								}
							}
							printf("\nwdqd right edge detect \n");
							printf("\nwdqd right edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value_wdqd);
							dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
							//only update dq_lcd_bdl_temp_reg_value_wdqd
							dq_lcd_bdl_temp_reg_value=dq_lcd_bdl_reg_right[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							dq_lcd_bdl_temp_reg_value_dqs=((dq_lcd_bdl_temp_reg_value&0x00)|dq_lcd_bdl_temp_reg_value_wdqd);

							dq_lcd_bdl_reg_right[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]=dq_lcd_bdl_temp_reg_value_dqs;

							dq_lcd_bdl_temp_reg_rig_min_value=dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							if (dq_lcd_bdl_temp_reg_value_wdqd<(dq_lcd_bdl_temp_reg_rig_min_value&0xff))  //update wdqd min value
							{
								dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]
									=((dq_lcd_bdl_temp_reg_rig_min_value&0xffff00)|dq_lcd_bdl_temp_reg_value_wdqd)	;
							}



							writel(dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1],(reg_add+4*DATX8_DQ_DXNLCDLR1));


						}
						else if(temp_count_k==1)
						{

							dq_lcd_bdl_temp_reg_value_dqs=readl(reg_add+4*DATX8_DQ_DXNLCDLR1);
							dq_lcd_bdl_temp_reg_value_wdqd=(dq_lcd_bdl_temp_reg_value_dqs&0xff);
							dq_lcd_bdl_temp_reg_value_rdqsd=((dq_lcd_bdl_temp_reg_value_dqs&0xff00))>>8;

							while (dq_lcd_bdl_temp_reg_value_rdqsd>0)
							{
								temp_test_error=0;
								dq_lcd_bdl_temp_reg_value_rdqsd--;
								printf("\nrdqsd left temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value_rdqsd);
								dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
								writel(dq_lcd_bdl_temp_reg_value_dqs,(reg_add+4*DATX8_DQ_DXNLCDLR1));
								temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
								if (temp_test_error)
								{
									//printf("\nrdqsd left edge detect \n");
									dq_lcd_bdl_temp_reg_value_rdqsd++;
									break;
								}
							}
							printf("\nrdqsd left edge detect \n");
							printf("\nrdqsd left edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value_rdqsd);
							dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
							//only update dq_lcd_bdl_temp_reg_value_rdqsd rdqsnd
							dq_lcd_bdl_temp_reg_value=dq_lcd_bdl_reg_left[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							dq_lcd_bdl_temp_reg_value_dqs=((dq_lcd_bdl_temp_reg_value&0x0000ff)|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));

							dq_lcd_bdl_reg_left[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]=dq_lcd_bdl_temp_reg_value_dqs;


							dq_lcd_bdl_temp_reg_lef_min_value=dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							if (dq_lcd_bdl_temp_reg_value_rdqsd>((dq_lcd_bdl_temp_reg_lef_min_value>>8)&0xff))  //update wdqd min value
							{
								dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]
									=((dq_lcd_bdl_temp_reg_lef_min_value&0xff)|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16))	;
							}


							writel(dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1],(reg_add+4*DATX8_DQ_DXNLCDLR1));

							dq_lcd_bdl_temp_reg_value_dqs=readl(reg_add+4*DATX8_DQ_DXNLCDLR1);
							dq_lcd_bdl_temp_reg_value_wdqd=(dq_lcd_bdl_temp_reg_value_dqs&0xff);
							dq_lcd_bdl_temp_reg_value_rdqsd=((dq_lcd_bdl_temp_reg_value_dqs&0xff00))>>8;

							while (dq_lcd_bdl_temp_reg_value_rdqsd<0xff)
							{
								temp_test_error=0;
								dq_lcd_bdl_temp_reg_value_rdqsd++;
								printf("\nrdqsd right temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value_rdqsd);
								dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
								writel(dq_lcd_bdl_temp_reg_value_dqs,(reg_add+4*DATX8_DQ_DXNLCDLR1));
								temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
								if (temp_test_error)
								{
									//printf("\nrdqsd right edge detect \n");
									dq_lcd_bdl_temp_reg_value_rdqsd--;
									break;
								}
							}
							printf("\nrdqsd right edge detect \n");
							printf("\nrdqsd right edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value_rdqsd);
							dq_lcd_bdl_temp_reg_value_dqs=(dq_lcd_bdl_temp_reg_value_wdqd|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
							//only update dq_lcd_bdl_temp_reg_value_rdqsd rdqsnd
							dq_lcd_bdl_temp_reg_value=dq_lcd_bdl_reg_right[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							dq_lcd_bdl_temp_reg_value_dqs=((dq_lcd_bdl_temp_reg_value&0x0000ff)|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16));
							dq_lcd_bdl_reg_right[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]=dq_lcd_bdl_temp_reg_value_dqs;


							dq_lcd_bdl_temp_reg_rig_min_value=dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1];
							if (dq_lcd_bdl_temp_reg_value_rdqsd<((dq_lcd_bdl_temp_reg_rig_min_value>>8)&0xff))  //update wdqd min value
							{
								dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]
									=((dq_lcd_bdl_temp_reg_rig_min_value&0xff)|(dq_lcd_bdl_temp_reg_value_rdqsd<<8)|(dq_lcd_bdl_temp_reg_value_rdqsd<<16))	;
							}



							writel(dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1],(reg_add+4*DATX8_DQ_DXNLCDLR1));




						}

					}
				}

			}
		}

		////tune and save training dqs value




		////calculate and print  dqs value
		for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
		{
			if (( channel_a_en) && ( channel_b_en == 0))
			{
				reg_base_adj=CHANNEL_A_REG_BASE;
			}
			else if(( channel_b_en)&&( channel_a_en==0))
			{
				reg_base_adj=CHANNEL_B_REG_BASE;
			}
			else if ((channel_a_en+channel_b_en)==2)
			{
				if ( testing_channel == CHANNEL_A)
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if( testing_channel==CHANNEL_B)
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
			}
			reg_add=DDR0_PUB_DX0BDLR0+reg_base_adj;


			for ((temp_count_j=0);(temp_count_j<DQ_LCD_BDL_REG_NUM_PER_CHANNEL);(temp_count_j++))
			{
				//  dq_lcd_bdl_reg_index[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+temp_count_j]=reg_add+4*temp_count_j;

				printf("\n org add  0x%08x reg== 0x%08x\n",(dq_lcd_bdl_reg_index[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_j]), (dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_j]));
			}

			for ((temp_count_j=0);(temp_count_j<DQ_LCD_BDL_REG_NUM_PER_CHANNEL);(temp_count_j++))
			{
				printf("\n lef add  0x%08x reg== 0x%08x\n",(dq_lcd_bdl_reg_index[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_j]), (dq_lcd_bdl_reg_left[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_j]));
			}

			for ((temp_count_j=0);(temp_count_j<DQ_LCD_BDL_REG_NUM_PER_CHANNEL);(temp_count_j++))
			{
				printf("\n rig add  0x%08x reg== 0x%08x\n",(dq_lcd_bdl_reg_index[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_j]), (dq_lcd_bdl_reg_right[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_j]));
			}

			printf("\n ddrtest size ==0x%08x, test times==0x%08x,test_loop==0x%08x\n",ddr_test_size,(test_times+1),test_loop);
			printf("\n add  0x00000000 reg==    org           lef           rig           center        win           lef_m         rig_m         min_c         min_win        \n");
			for ((temp_count_i=0);(temp_count_i<DATX8_DQ_LANE_WIDTH);(temp_count_i++))
			{
				{

					if (temp_count_i == DATX8_DQ_LANE_LANE00)
					{
						reg_add=DDR0_PUB_DX0BDLR0+reg_base_adj+DATX8_DQ_DXNLCDLR1*4;}

					else    if(temp_count_i==DATX8_DQ_LANE_LANE01)
					{
						reg_add=DDR0_PUB_DX1BDLR0+reg_base_adj+DATX8_DQ_DXNLCDLR1*4;}

					else   	 if(temp_count_i==DATX8_DQ_LANE_LANE02)
					{
						reg_add=DDR0_PUB_DX2BDLR0+reg_base_adj+DATX8_DQ_DXNLCDLR1*4;}
					else    if(temp_count_i==DATX8_DQ_LANE_LANE03)
					{
						reg_add=DDR0_PUB_DX3BDLR0+reg_base_adj+DATX8_DQ_DXNLCDLR1*4;}
				}

				dq_lcd_bdl_temp_reg_lef=(dq_lcd_bdl_reg_left[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]);
				dq_lcd_bdl_temp_reg_rig=(dq_lcd_bdl_reg_right[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]);

				if (test_times == 0)
				{
					(dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1])=dq_lcd_bdl_temp_reg_lef;
					(dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1])=dq_lcd_bdl_temp_reg_rig;

				}
				dq_lcd_bdl_temp_reg_lef_min_value=(dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]);
				dq_lcd_bdl_temp_reg_rig_min_value=(dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]);


				//dq_lcd_bdl_temp_reg_value_wdqd=(dq_lcd_bdl_temp_reg_value&0x0000ff);
				dq_lcd_bdl_temp_reg_center=( (((dq_lcd_bdl_temp_reg_lef&0xff)+(dq_lcd_bdl_temp_reg_rig&0xff))/2)
						|(((((dq_lcd_bdl_temp_reg_lef>>8)&0xff)+((dq_lcd_bdl_temp_reg_rig>>8)&0xff))/2)<<8)
						|(((((dq_lcd_bdl_temp_reg_lef>>16)&0xff)+((dq_lcd_bdl_temp_reg_rig>>8)&0xff))/2)<<16) );

				dq_lcd_bdl_temp_reg_windows=( (((dq_lcd_bdl_temp_reg_rig&0xff)-(dq_lcd_bdl_temp_reg_lef&0xff)))
						|(((((dq_lcd_bdl_temp_reg_rig>>8)&0xff)-((dq_lcd_bdl_temp_reg_lef>>8)&0xff)))<<8)
						|(((((dq_lcd_bdl_temp_reg_rig>>16)&0xff)-((dq_lcd_bdl_temp_reg_lef>>8)&0xff)))<<16) );


				dq_lcd_bdl_temp_reg_center_min=( (((dq_lcd_bdl_temp_reg_lef_min_value&0xff)+(dq_lcd_bdl_temp_reg_rig_min_value&0xff))/2)
						|(((((dq_lcd_bdl_temp_reg_lef_min_value>>8)&0xff)+((dq_lcd_bdl_temp_reg_rig_min_value>>8)&0xff))/2)<<8)
						|(((((dq_lcd_bdl_temp_reg_lef_min_value>>16)&0xff)+((dq_lcd_bdl_temp_reg_rig_min_value>>8)&0xff))/2)<<16) );

				dq_lcd_bdl_temp_reg_windows_min=( (((dq_lcd_bdl_temp_reg_rig_min_value&0xff)-(dq_lcd_bdl_temp_reg_lef_min_value&0xff)))
						|(((((dq_lcd_bdl_temp_reg_rig_min_value>>8)&0xff)-((dq_lcd_bdl_temp_reg_lef_min_value>>8)&0xff)))<<8)
						|(((((dq_lcd_bdl_temp_reg_rig_min_value>>16)&0xff)-((dq_lcd_bdl_temp_reg_lef_min_value>>8)&0xff)))<<16) );

				printf("\n add  0x%08x reg==    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x\n",
						(dq_lcd_bdl_reg_index[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]),
						(dq_lcd_bdl_reg_org[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]),
						(dq_lcd_bdl_reg_left[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]),
						(dq_lcd_bdl_reg_right[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]),
						dq_lcd_bdl_temp_reg_center,dq_lcd_bdl_temp_reg_windows,
						(dq_lcd_bdl_reg_left_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]),
						(dq_lcd_bdl_reg_right_min[testing_channel*DQ_LCD_BDL_REG_NUM_PER_CHANNEL+temp_count_i*DATX8_DQ_LCD_BDL_REG_WIDTH+DATX8_DQ_DXNLCDLR1]),
						dq_lcd_bdl_temp_reg_center_min,dq_lcd_bdl_temp_reg_windows_min
					  );
			}


		}

	}





	return 0;

usage:
	cmd_usage(cmdtp);
	return 1;

}



int do_ddr_test_dqs_window_env(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnterddr_test_dqs_window function\n");
	printf("\nddr_test_cmd 0x22 a 0 0x80000 ns lane_disable add_test_size   --- watchdog should >15s\n");
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;
	// unsigned int   reg_add=0;
	// unsigned int   reg_base_adj=0;

	unsigned int   lane_step= 0;
	unsigned int   reg_value= 0;
	//int argc2;
	//char     *  argv2[30];
	char *endp;
	char *buf;
	buf="";

	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))

		{channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))

		{channel_b_en = 1;
		}


	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))

		{channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

		{channel_b_en = 1;
		}
	}
	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}
	}



	if (argc >4) {
		watchdog_time_s = simple_strtoull_ddr(argv[4], &endp, 0);
		if (*argv[4] == 0 || *endp != 0)
		{
			watchdog_time_s= 20;
		}
	}
	printf("watchdog_time_s==%d\n",watchdog_time_s);

	unsigned int   lane_disable= 0;

	if (argc >5) {
		lane_disable = simple_strtoull_ddr(argv[5], &endp, 0);
		if (*argv[5] == 0 || *endp != 0)
		{
			lane_disable= 0;
		}
	}
	printf("lane_disable==0x%08x\n",lane_disable);

	unsigned int  add_test_size= DDR_CORSS_TALK_TEST_SIZE;

	if (argc >6) {
		add_test_size = simple_strtoull_ddr(argv[6], &endp, 0);
		if (*argv[6] == 0 || *endp != 0)
		{
			add_test_size= ddr_test_size;
		}
	}
	printf("add_test_size==0x%08x\n",add_test_size);
	//argc2=5;
	//for(i = 1;i<(argc);i++)
	{
		//argv2[i-1]=argv[i];
	}

	//argv2[0]=argv[1];
	//argv2[1]=argv[2];
	//argv2[2]=argv[3];
	//#include <stdio.h>
	//   unsigned int   wr_adj_per[24] ;
	//if(1)

	printf("\ntest use uboot env\n");

	char str[1024]="";
	char str_temp1[1024]="";
	char str_temp2[1024]="";
	const char *s;
	unsigned int str_to_numarry[48];
	//str_buf = (char *)malloc(sizeof(char)*1024);

	unsigned int *num_arry;
	//unsigned int *num_arry_temp;
	unsigned int *num_arry_lane0=NULL;
	unsigned int *num_arry_lane1=NULL;
	unsigned int *num_arry_lane2=NULL;
	unsigned int *num_arry_lane3=NULL;
	char *name_lane0; 
	char *name_lane1; 
	char *name_lane2; 
	char *name_lane3; 
	num_arry = (unsigned int *)(&str_to_numarry);
	int i;
	char *varname;  char *env_lcdlr_temp_count;
	unsigned int lcdlr_temp_count=0;
	const char *temp_s;const char *temp_s1;
	// int value=0;

	varname="env_ddrtest_data_lane";
	name_lane0="ddr_test_data_lane0";
	name_lane1="ddr_test_data_lane1";
	name_lane2="ddr_test_data_lane2";
	name_lane3="ddr_test_data_lane3";
	env_lcdlr_temp_count="lcdlr_temp_count";
	s = getenv(varname);
	if (s)
	{//i=0;
		//while(s_temp)
		{
			env_to_num(varname,num_arry);//unsigned int *num_arry
			temp_s= getenv(env_lcdlr_temp_count);
			if(temp_s)
			{
				lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
			}
			else
			{lcdlr_temp_count=0;
			}

			if(0){
				env_to_num(name_lane0,num_arry_lane0);//unsigned int *num_arry
				env_to_num(name_lane1,num_arry_lane1);//unsigned int *num_arry
				env_to_num(name_lane2,num_arry_lane2);//unsigned int *num_arry
				env_to_num(name_lane3,num_arry_lane3);//unsigned int *num_arry
			}

			for (i = 0; i < 48; i++) {

				printf("str_to_numarry[%d]==%d\n",i,num_arry[i]);
			}
			//for (lane_step = 0;lane_step< 4;lane_step++)
			if(0)
			{
				for (i = 0; i < 8; i++) {

					printf("lane_0 str_to_numarry[%d]==%d\n",i,num_arry_lane0[i]);
				}
				for (i = 0; i < 8; i++) {

					printf("lane_1 str_to_numarry[%d]==%d\n",i,num_arry_lane1[i]);
				}
				for (i = 0; i < 8; i++) {

					printf("lane_2 str_to_numarry[%d]==%d\n",i,num_arry_lane2[i]);
				}
				for (i = 0; i < 8; i++) {

					printf("lane_3 str_to_numarry[%d]==%d\n",i,num_arry_lane3[i]);
				}
			}
			//	printf("%s,length=%d",s,(strlen(s)));
			//sscanf(s,"d%,",wr_adj_per);
			//sprintf(str,"d%",s);
			//getc
			//       if (strlen(s) > 16) 
			{
				//   sscanf(s, "%08x, %08x, %08x, \n",
				//          &wr_adj_per[0], &wr_adj_per[1], &wr_adj_per[2]);
			} 
		}
	}
	else
	{
		printf("no env set,exit\n");
		return 0;}
	s = getenv(varname);//for debug display env   should add


	///*
	//if(1)

	unsigned int test_arg_0_cmd0 =0;  //master cmd
	unsigned int test_arg_1_cmd1 =0;  //min cmd
	unsigned int test_arg_2_step =0; //step 0  init  -1 lane0 w min  -2 lane0 w max -3 lane0 r min    4 lane0 r max -----5 lane1 w min ...
	unsigned int test_arg_3_freq =0;
	unsigned int test_arg_4_step_status =0; //uboot test we should read error then done status.  0 no test 1 ongoing 2 this step done  fail or pass
	//  unsigned int   lane_step= 0;
	//char str[24];


	test_arg_0_cmd0=num_arry[0];
	test_arg_1_cmd1=num_arry[1];
	test_arg_2_step=num_arry[2];
	test_arg_3_freq=num_arry[3];
	test_arg_4_step_status=num_arry[4];
	printf("test_arg_0_cmd0==%d\n",test_arg_0_cmd0);
	printf("test_arg_0_cmd1==%d\n",test_arg_1_cmd1);
	printf("test_arg_2_step==%d\n",test_arg_2_step);
	printf("test_arg_3_freq==%d\n",test_arg_3_freq);
	printf("test_arg_4_step_status==%d\n",test_arg_4_step_status);

	if(test_arg_2_step)
	{
		if(test_arg_3_freq!=global_ddr_clk)
		{
			printf("running ddr freq==%d,but test freq is%d,will reboot use d2pll \n",global_ddr_clk,test_arg_3_freq);
			sprintf(str,"d2pll  %d",test_arg_3_freq);
			printf("\nstr=%s\n",str);
			run_command(str,0);
			while(1);
		}
	}
	if(test_arg_2_step==0)
	{
		{
			test_arg_0_cmd0=0x22;
			test_arg_1_cmd1=0;
			test_arg_2_step=1;
			test_arg_3_freq=global_ddr_clk;
			test_arg_4_step_status=0;
			num_arry[0]=test_arg_0_cmd0;
			num_arry[1]=test_arg_1_cmd1;
			num_arry[2]=test_arg_2_step;
			num_arry[3]=test_arg_3_freq;
			num_arry[4]=test_arg_4_step_status;
			num_arry[5]=0;
			num_arry[6]=0;
			num_arry[7]=0;
			for (i = 8; i < 48; i++) {
				num_arry[i]=0;
			}

			for (lane_step = 0; lane_step < 4; lane_step++)
			{
				//if(lane_step%2)
				{
#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
					dq_lcd_bdl_value_wdq_org_a[lane_step]=((readl((lane_step)*(DDR0_PUB_DX1LCDLR1-
										DDR0_PUB_DX0LCDLR1)
									+DDR0_PUB_DX0LCDLR1))&0xff);
					dq_lcd_bdl_value_rdqs_org_a[lane_step]=(((readl((lane_step)*(DDR0_PUB_DX1LCDLR1-
											DDR0_PUB_DX0LCDLR1)
										+DDR0_PUB_DX0LCDLR1))>>8)&0xff);
#else
					dq_lcd_bdl_value_wdq_org_a[lane_step]=((readl((lane_step)*(DDR0_PUB_DX1LCDLR1-
										DDR0_PUB_DX0LCDLR1)
									+DDR0_PUB_DX0LCDLR1))&0x1ff);
					dq_lcd_bdl_value_rdqs_org_a[lane_step]=(((readl((lane_step)*(DDR0_PUB_DX1LCDLR3-
											DDR0_PUB_DX0LCDLR3)
										+DDR0_PUB_DX0LCDLR3))>>0)&0x1ff);

					printf("lcdlr1 %d  %08x,%08x,%08x\n", lane_step,((lane_step)*(DDR0_PUB_DX1LCDLR1-
									DDR0_PUB_DX0LCDLR1)
								+DDR0_PUB_DX0LCDLR1),
							((readl((lane_step)*(DDR0_PUB_DX1LCDLR1-
												 DDR0_PUB_DX0LCDLR1)
									+DDR0_PUB_DX0LCDLR1))&0x1ff),dq_lcd_bdl_value_wdq_org_a[lane_step]);
					printf("lcdlr3 %d  %08x,%08x,%08x\n", lane_step,((lane_step)*(DDR0_PUB_DX1LCDLR3-
									DDR0_PUB_DX0LCDLR3)
								+DDR0_PUB_DX0LCDLR3),
							(((readl((lane_step)*(DDR0_PUB_DX1LCDLR3-
												  DDR0_PUB_DX0LCDLR3)
									 +DDR0_PUB_DX0LCDLR3))>>0)&0x1ff),dq_lcd_bdl_value_rdqs_org_a[lane_step]);
#endif

					//printf("lcdlr1 %d  %08x\n", lane_step,((lane_step)*(DDR0_PUB_DX1LCDLR1-
					//DDR0_PUB_DX0LCDLR1)
					//+DDR0_PUB_DX0LCDLR1));
					//printf("lcdlr3 %d  %08x\n", lane_step,((lane_step)*(DDR0_PUB_DX1LCDLR3-
					//DDR0_PUB_DX0LCDLR3)
					//+DDR0_PUB_DX0LCDLR3));
					//dq_lcd_bdl_value_rdqs_org_a[lane_step]=0;
					dq_lcd_bdl_value_rdqs_min_a[lane_step]=0xffff;
					dq_lcd_bdl_value_rdqs_max_a[lane_step]=0xffff;
					dq_lcd_bdl_value_rdqs_status_a[lane_step]=0;
				}
				//else
				{
					//dq_lcd_bdl_value_wdq_org_a[lane_step]=0;
					dq_lcd_bdl_value_wdq_min_a[lane_step]=0xffff;
					dq_lcd_bdl_value_wdq_max_a[lane_step]=0xffff;
					dq_lcd_bdl_value_wdq_status_a[lane_step]=0;
				}
			}

			{
				dq_lcd_bdl_value_aclcdlr_org_a=((readl(DDR0_PUB_ACLCDLR))&ACLCDLR_MAX);
				dq_lcd_bdl_value_aclcdlr_min_a=0xffff;
				dq_lcd_bdl_value_aclcdlr_max_a=0xffff;
				dq_lcd_bdl_value_aclcdlr_status_a=0;
				dq_lcd_bdl_value_bdlr0_org_a=((readl(DDR0_PUB_ACBDLR0))&ACBDLR_MAX);
				dq_lcd_bdl_value_bdlr0_min_a=0xffff;
				dq_lcd_bdl_value_bdlr0_max_a=0xffff;
				dq_lcd_bdl_value_bdlr0_status_a=0;
			}



#if 1 //( CONFIG_DDR_PHY<P_DDR_PHY_905X)
			printf("DDR0_PUB_DX0GCR0==%x\n",(readl(DDR0_PUB_DX0GCR0)));
			printf("DDR0_PUB_DX1GCR0==%x\n",(readl(DDR0_PUB_DX1GCR0)));
			printf("DDR0_PUB_DX2GCR0==%x\n",(readl(DDR0_PUB_DX2GCR0)));
			printf("DDR0_PUB_DX3GCR0==%x\n",(readl(DDR0_PUB_DX3GCR0)));
			if(((readl(DDR0_PUB_DX0GCR0))&1)==0)
				lane_disable=   lane_disable|1;      
			if(((readl(DDR0_PUB_DX1GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<1);   
			if(((readl(DDR0_PUB_DX2GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<2);   
			if(((readl(DDR0_PUB_DX3GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<3);   

#endif
			if(lane_disable)
			{if(lane_disable&0x1){
									 dq_lcd_bdl_value_wdq_status_a[0]=4;
									 dq_lcd_bdl_value_rdqs_status_a[0]=4;
								 }
			if(lane_disable&0x2){
				dq_lcd_bdl_value_wdq_status_a[1]=4;
				dq_lcd_bdl_value_rdqs_status_a[1]=4;
			}
			if(lane_disable&0x4){
				dq_lcd_bdl_value_wdq_status_a[2]=4;
				dq_lcd_bdl_value_rdqs_status_a[2]=4;
			}
			if(lane_disable&0x8){
				dq_lcd_bdl_value_wdq_status_a[3]=4;
				dq_lcd_bdl_value_rdqs_status_a[3]=4;
			}
			printf("lane_disable==%x\n",lane_disable);
			if(lane_disable&0x10){
				dq_lcd_bdl_value_aclcdlr_status_a=4;
				printf("dq_lcd_bdl_value_aclcdlr_status_a==%x\n",dq_lcd_bdl_value_aclcdlr_status_a);
			}
			if(lane_disable&0x20){
				dq_lcd_bdl_value_bdlr0_status_a=4;
				printf("dq_lcd_bdl_value_bdlr0_status_a==%x\n",dq_lcd_bdl_value_bdlr0_status_a);

			}
			}

			{
				for (lane_step = 0; lane_step < 4; lane_step++)


				{
					num_arry[8+lane_step*4*2+0]=dq_lcd_bdl_value_wdq_org_a[lane_step];
					num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_wdq_min_a[lane_step];
					num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_wdq_max_a[lane_step];
					num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_wdq_status_a[lane_step];
					num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_rdqs_org_a[lane_step];
					num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
					num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
					num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
				}




				lane_step=4;
				{
					num_arry[8+lane_step*4*2+0]=dq_lcd_bdl_value_aclcdlr_org_a;
					num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_aclcdlr_min_a;
					num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_aclcdlr_max_a;
					num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_aclcdlr_status_a;
					num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_bdlr0_org_a;
					num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_bdlr0_min_a;
					num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_bdlr0_max_a;
					num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_bdlr0_status_a;
				}
			}

			if(0){
				for (i = 0; i < 8; i++) {
					num_arry_lane0[i]=num_arry[8+i];
				}
				for (i = 0; i < 8; i++) {
					num_arry_lane1[i]=num_arry[8+8+i];
				}
				for (i = 0; i < 8; i++) {
					num_arry_lane2[i]=num_arry[8+8+8+i];
				}
				for (i = 0; i < 8; i++) {
					num_arry_lane3[i]=num_arry[8+8+8+8+i];
				}
				num_to_env(name_lane0,num_arry_lane0);
				num_to_env(name_lane1,num_arry_lane1);
				num_to_env(name_lane2,num_arry_lane2);
				num_to_env(name_lane3,num_arry_lane3);
				run_command("save",0);
			}

		}




		for (i = 0; i < 48; i++) {
			sprintf(str_temp1,"ddr_test_data_num_%04d",i);
			sprintf(str_temp2,"0x%08x",num_arry[i]);
			setenv(str_temp1, str_temp2);
			run_command("save",0);
		}



	}

	test_arg_2_step++;
	num_arry[2]=test_arg_2_step;
	sprintf(str, "0x%08x", num_arry[0]);
	printf("%d  %d\n", 0,num_arry[0]);
	for (i = 1; i < 48; i++) {
		//num_arry[i]=0;
		sprintf(str, "%s;0x%08x", str,num_arry[i]);
		printf("%d  %d\n", i,num_arry[i]);

	}
	//sprintf(str, "%lx", value);
	printf("%s", str);
	setenv(varname, str);
	run_command("save",0);


	i=2;
	sprintf(str_temp1,"ddr_test_data_num_%04d",i);
	sprintf(str_temp2,"0x%08x",num_arry[i]);
	setenv(str_temp1, str_temp2);
	run_command("save",0);

	for (i = 8; i < 48; i++) {
		sprintf(str_temp1,"ddr_test_data_num_%04d",i);
		temp_s1= getenv(str_temp1);
		if(temp_s1)
		{
			num_arry[i]= simple_strtoull_ddr(temp_s1, &endp, 0);
		}
		else
		{num_arry[i]=0;
		}
		printf("ddr_test_data_num_%04d==%d\n",i,num_arry[i]);
	}

	///*
	{
		for (lane_step = 0; lane_step < 4; lane_step++)
		{
			{
				dq_lcd_bdl_value_wdq_org_a[lane_step]=num_arry[8+lane_step*4*2+0];
				dq_lcd_bdl_value_wdq_min_a[lane_step]=num_arry[8+lane_step*4*2+1];
				dq_lcd_bdl_value_wdq_max_a[lane_step]=num_arry[8+lane_step*4*2+2];
				dq_lcd_bdl_value_wdq_status_a[lane_step]=num_arry[8+lane_step*4*2+3];
			}
			{
				dq_lcd_bdl_value_rdqs_org_a[lane_step]=num_arry[8+lane_step*4*2+4];
				dq_lcd_bdl_value_rdqs_min_a[lane_step]=num_arry[8+lane_step*4*2+5];
				dq_lcd_bdl_value_rdqs_max_a[lane_step]=num_arry[8+lane_step*4*2+6];
				dq_lcd_bdl_value_rdqs_status_a[lane_step]=num_arry[8+lane_step*4*2+7];
			}


		}
		lane_step=4;
		{
			dq_lcd_bdl_value_aclcdlr_org_a=num_arry[8+lane_step*4*2+0];
			dq_lcd_bdl_value_aclcdlr_min_a=num_arry[8+lane_step*4*2+1];
			dq_lcd_bdl_value_aclcdlr_max_a=num_arry[8+lane_step*4*2+2];
			dq_lcd_bdl_value_aclcdlr_status_a=num_arry[8+lane_step*4*2+3];
			dq_lcd_bdl_value_bdlr0_org_a=num_arry[8+lane_step*4*2+4];
			dq_lcd_bdl_value_bdlr0_min_a=num_arry[8+lane_step*4*2+5];
			dq_lcd_bdl_value_bdlr0_max_a=num_arry[8+lane_step*4*2+6];
			dq_lcd_bdl_value_bdlr0_status_a=num_arry[8+lane_step*4*2+7];
		}
	}
	//*/




	if (channel_a_en)
	{

		//*(char     *)(argv2[0])="a";
		//	run_command("ddr_test_cmd 11 a 0 0x80000  ",0);
		printf("\ntest dqs window lane a\n");
		for ((lane_step=0);(lane_step<4);(lane_step++))
		{
			ddr_test_watchdog_enable(watchdog_time_s); //s
			printf("\nenable %ds watchdog \n",watchdog_time_s);

			/*
			   {
			   lcdlr_temp_count=dq_lcd_bdl_temp_reg_value;
			   sprintf(buf, "0x%08x", lcdlr_temp_count);
			   printf( "%s", buf);
			   setenv(env_lcdlr_temp_count, buf);
			   run_command("save",0);
			   }
			   */
			if((dq_lcd_bdl_value_wdq_status_a[lane_step]==0xffff)
					||(dq_lcd_bdl_value_wdq_status_a[lane_step]==0)
					||(dq_lcd_bdl_value_wdq_status_a[lane_step]==1)
			  )
			{
				if((dq_lcd_bdl_value_wdq_status_a[lane_step]==0xffff)
						||(dq_lcd_bdl_value_wdq_status_a[lane_step]==0))
				{		dq_lcd_bdl_value_wdq_status_a[lane_step]=1;
					{
						{
							num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_wdq_status_a[lane_step];
							i=8+lane_step*8+3;
							sprintf(str_temp1,"ddr_test_data_num_%04d",i);
							sprintf(str_temp2,"0x%08x",num_arry[i]);
							setenv(str_temp1, str_temp2);
							run_command("save",0);
						}
						lcdlr_temp_count=0;
						sprintf(buf, "0x%08x", lcdlr_temp_count);
						printf( "%s", buf);
						setenv(env_lcdlr_temp_count, buf);
						run_command("save",0);
					}

					sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d",ddr_test_size,( lane_step*2+0),2);
					printf("\nstr=%s\n",str);
					//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
					//printf("\nstr=%s\n",str);
					ddr_test_watchdog_clear();
					run_command(str,0);
					ddr_test_watchdog_clear();
					ddr_udelay(2000000);
					dq_lcd_bdl_value_wdq_status_a[lane_step]=2;

				}
				else if (dq_lcd_bdl_value_wdq_status_a[lane_step]==1)
				{
					temp_s= getenv(env_lcdlr_temp_count);
					if(temp_s)
					{
						lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
					}
					dq_lcd_bdl_value_wdq_min_a[lane_step]=lcdlr_temp_count;
					dq_lcd_bdl_value_wdq_status_a[lane_step]=2;
				}

				num_arry[8+lane_step*4*2+0]=dq_lcd_bdl_value_wdq_org_a[lane_step];
				num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_wdq_min_a[lane_step];
				//num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_wdq_max_a[lane_step];
				num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_wdq_status_a[lane_step];

				//ddr_udelay(1000000);
				//num_to_env(varname,num_arry);
				{
					i=8+lane_step*8+1;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					setenv(str_temp1, str_temp2);
					run_command("save",0);
					i=8+lane_step*8+3;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					setenv(str_temp1, str_temp2);
					run_command("save",0);
				}


				run_command("reset",0);
			}

			if((dq_lcd_bdl_value_wdq_status_a[lane_step]==2)||
					(dq_lcd_bdl_value_wdq_status_a[lane_step]==3))
			{
				//	if((dq_lcd_bdl_value_wdq_min_a[lane_step])==0xffff)
				//		{dq_lcd_bdl_value_wdq_status_a[lane_step]=0;
				//		num_to_env(varname,num_arry);
				//             run_command("reset",0);
				//		}

				{
					if(dq_lcd_bdl_value_wdq_status_a[lane_step]==2)
					{		dq_lcd_bdl_value_wdq_status_a[lane_step]=3;
						{
							num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_wdq_status_a[lane_step];
							i=8+lane_step*8+3;
							sprintf(str_temp1,"ddr_test_data_num_%04d",i);
							sprintf(str_temp2,"0x%08x",num_arry[i]);
							setenv(str_temp1, str_temp2);
							run_command("save",0);
						}
						{
							lcdlr_temp_count=0;
							sprintf(buf, "0x%08x", lcdlr_temp_count);
							printf( "%s", buf);
							setenv(env_lcdlr_temp_count, buf);
							run_command("save",0);
						}

						sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d",ddr_test_size,( lane_step*2+0),1);
						printf("\nstr=%s\n",str);
						//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
						//printf("\nstr=%s\n",str);
						ddr_test_watchdog_clear();
						run_command(str,0);
						ddr_test_watchdog_clear();
						ddr_udelay(2000000);
						dq_lcd_bdl_value_wdq_status_a[lane_step]=4;

					}
					else if (dq_lcd_bdl_value_wdq_status_a[lane_step]==3)
					{
						temp_s= getenv(env_lcdlr_temp_count);
						if(temp_s)
						{
							lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
						}
						dq_lcd_bdl_value_wdq_max_a[lane_step]=lcdlr_temp_count;
						dq_lcd_bdl_value_wdq_status_a[lane_step]=4;
					}

					num_arry[8+lane_step*4*2+0]=dq_lcd_bdl_value_wdq_org_a[lane_step];
					//num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_wdq_min_a[lane_step];
					num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_wdq_max_a[lane_step];
					num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_wdq_status_a[lane_step];
					//ddr_udelay(1000000);
					//num_to_env(varname,num_arry);
					{
						i=8+lane_step*8+2;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						setenv(str_temp1, str_temp2);
						run_command("save",0);
						i=8+lane_step*8+3;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						setenv(str_temp1, str_temp2);
						run_command("save",0);
					}

					run_command("reset",0);
				}

			}


			if((dq_lcd_bdl_value_rdqs_status_a[lane_step]==0xffff)
					||(dq_lcd_bdl_value_rdqs_status_a[lane_step]==0)
					||(dq_lcd_bdl_value_rdqs_status_a[lane_step]==1)
			  )
			{
				if((dq_lcd_bdl_value_rdqs_status_a[lane_step]==0xffff)
						||(dq_lcd_bdl_value_rdqs_status_a[lane_step]==0))
				{		dq_lcd_bdl_value_rdqs_status_a[lane_step]=1;
					{
						num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
						i=8+lane_step*8+7;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						setenv(str_temp1, str_temp2);
						run_command("save",0);
					}
					{
						lcdlr_temp_count=0;
						sprintf(buf, "0x%08x", lcdlr_temp_count);
						printf( "%s", buf);
						setenv(env_lcdlr_temp_count, buf);
						run_command("save",0);
					}

					sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d",ddr_test_size,( lane_step*2+1),2);
					printf("\nstr=%s\n",str);
					//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
					//printf("\nstr=%s\n",str);
					ddr_test_watchdog_clear();
					run_command(str,0);
					ddr_test_watchdog_clear();
					ddr_udelay(2000000);
					dq_lcd_bdl_value_rdqs_status_a[lane_step]=2;

				}
				else if (dq_lcd_bdl_value_rdqs_status_a[lane_step]==1)
				{
					temp_s= getenv(env_lcdlr_temp_count);
					if(temp_s)
					{
						lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
					}
					dq_lcd_bdl_value_rdqs_min_a[lane_step]=lcdlr_temp_count;
					dq_lcd_bdl_value_rdqs_status_a[lane_step]=2;
				}

				num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_rdqs_org_a[lane_step];
				num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
				//num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
				num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
				//ddr_udelay(1000000);
				//num_to_env(varname,num_arry);
				{
					i=8+lane_step*8+5;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					setenv(str_temp1, str_temp2);
					run_command("save",0);
					i=8+lane_step*8+7;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					setenv(str_temp1, str_temp2);
					run_command("save",0);
				}

				run_command("reset",0);
			}

			if((dq_lcd_bdl_value_rdqs_status_a[lane_step]==2)||
					(dq_lcd_bdl_value_rdqs_status_a[lane_step]==3))
			{

				{
					if(dq_lcd_bdl_value_rdqs_status_a[lane_step]==2)
					{	

						dq_lcd_bdl_value_rdqs_status_a[lane_step]=3;
						{
							num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
							i=8+lane_step*8+7;
							sprintf(str_temp1,"ddr_test_data_num_%04d",i);
							sprintf(str_temp2,"0x%08x",num_arry[i]);
							setenv(str_temp1, str_temp2);
							run_command("save",0);
						}

						{
							lcdlr_temp_count=0;
							sprintf(buf, "0x%08x", lcdlr_temp_count);
							printf( "%s", buf);
							setenv(env_lcdlr_temp_count, buf);
							run_command("save",0);
						}

						sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d",ddr_test_size,( lane_step*2+1),1);
						printf("\nstr=%s\n",str);
						//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
						//printf("\nstr=%s\n",str);
						ddr_test_watchdog_clear();
						run_command(str,0);
						ddr_test_watchdog_clear();
						ddr_udelay(2000000);
						dq_lcd_bdl_value_rdqs_status_a[lane_step]=4;

					}
					else if (dq_lcd_bdl_value_rdqs_status_a[lane_step]==3)
					{
						temp_s= getenv(env_lcdlr_temp_count);
						if(temp_s)
						{
							lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
						}
						dq_lcd_bdl_value_rdqs_max_a[lane_step]=lcdlr_temp_count;
						dq_lcd_bdl_value_rdqs_status_a[lane_step]=4;
					}

					num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_rdqs_org_a[lane_step];
					//num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
					num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
					num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
					//ddr_udelay(1000000);
					//	num_to_env(varname,num_arry);

					{
						i=8+lane_step*8+6;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						setenv(str_temp1, str_temp2);
						run_command("save",0);
						i=8+lane_step*8+7;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						setenv(str_temp1, str_temp2);
						run_command("save",0);
					}
					run_command("reset",0);
				}

			}

			/*
			   if((dq_lcd_bdl_value_rdqs_status_a[lane_step]==0xffff)||
			   (dq_lcd_bdl_value_rdqs_status_a[lane_step]==0))
			   {dq_lcd_bdl_value_rdqs_status_a[lane_step]=0;
			   sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d",ddr_test_size,( lane_step*2+1),2);
			   printf("\nstr=%s\n",str);
			//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
			//printf("\nstr=%s\n",str);
			ddr_test_watchdog_clear();
			run_command(str,0);
			ddr_test_watchdog_clear();
			dq_lcd_bdl_value_rdqs_status_a[lane_step]=1;
			num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_rdqs_org_a[lane_step];
			num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
			//num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
			num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
			num_to_env(varname,num_arry);
			run_command("reset",0);
			}

			if((dq_lcd_bdl_value_rdqs_status_a[lane_step]==1)||
			(dq_lcd_bdl_value_rdqs_status_a[lane_step]==2))
			{dq_lcd_bdl_value_rdqs_status_a[lane_step]=2;
			sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d",ddr_test_size,( lane_step*2+1),1);
			printf("\nstr=%s\n",str);
			//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
			//printf("\nstr=%s\n",str);
			ddr_test_watchdog_clear();
			run_command(str,0);
			ddr_test_watchdog_clear();
			dq_lcd_bdl_value_rdqs_status_a[lane_step]=3;
			num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_rdqs_org_a[lane_step];
			//num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
			num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
			num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
			num_to_env(varname,num_arry);
			run_command("reset",0);
			}
			*/	


			ddr_test_watchdog_disable(); //s
			{printf("close  watchdog\n");
			}


		}



	}

	if (channel_a_en)
	{

		//*(char     *)(argv2[0])="a";
		//	run_command("ddr_test_cmd 11 a 0 0x80000  ",0);
		printf("\ntest lcdlr ac bdlr window lane a...\n");

		{
			ddr_test_watchdog_enable(watchdog_time_s); //s
			printf("\nenable %ds watchdog \n",watchdog_time_s);
			printf("\ndq_lcd_bdl_value_aclcdlr_status_a %d \n",dq_lcd_bdl_value_aclcdlr_status_a);
			lane_step=4;
			env_lcdlr_temp_count="lcdlr_temp_count_a";
			if((dq_lcd_bdl_value_aclcdlr_status_a>=0xffff)
					||(dq_lcd_bdl_value_aclcdlr_status_a==0)
					||(dq_lcd_bdl_value_aclcdlr_status_a==1)
			  )
			{
				if((dq_lcd_bdl_value_aclcdlr_status_a>=0xffff)
						||(dq_lcd_bdl_value_aclcdlr_status_a==0))
				{		dq_lcd_bdl_value_aclcdlr_status_a=1;
					{
						{
							num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_aclcdlr_status_a;
							i=8+lane_step*8+3;
							printf("aclcdlr_status_a==0x%08x\n",num_arry[i]);
							sprintf(str_temp1,"ddr_test_data_num_%04d",i);
							sprintf(str_temp2,"0x%08x",num_arry[i]);
							setenv(str_temp1, str_temp2);
							run_command("save",0);
						}
						printf("\n222test lcdlr ac bdlr window lane a...\n");
						lcdlr_temp_count=0;
						sprintf(buf, "0x%08x", lcdlr_temp_count);
						printf( "%s", buf);
						setenv(env_lcdlr_temp_count, buf);
						run_command("save",0);
					}

					printf("\n333test lcdlr ac bdlr window lane a...\n");
					//ddr_tune_aclcdlr_step
					sprintf(str,"ddr_tune_aclcdlr_step  a 0 0x%08x %d %d",add_test_size,( 0),2);
					printf("\nstr=%s\n",str);
					printf("aclcdlr_status_a1==0x%08x\n",num_arry[i]);
					//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
					//printf("\nstr=%s\n",str);
					ddr_test_watchdog_clear();
					run_command(str,0);
					ddr_test_watchdog_clear();
					ddr_udelay(2000000);
					dq_lcd_bdl_value_aclcdlr_status_a=2;

				}
				else if (dq_lcd_bdl_value_aclcdlr_status_a==1)
				{
					temp_s= getenv(env_lcdlr_temp_count);
					if(temp_s)
					{
						lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
					}
					dq_lcd_bdl_value_aclcdlr_min_a=lcdlr_temp_count;
					dq_lcd_bdl_value_aclcdlr_status_a=2;
				}

				num_arry[8+lane_step*4*2+0]=dq_lcd_bdl_value_aclcdlr_org_a;
				num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_aclcdlr_min_a;
				//num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_wdq_max_a[lane_step];
				num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_aclcdlr_status_a;

				//ddr_udelay(1000000);
				//num_to_env(varname,num_arry);
				{
					i=8+lane_step*8+1;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					setenv(str_temp1, str_temp2);
					run_command("save",0);
					i=8+lane_step*8+3;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					setenv(str_temp1, str_temp2);
					run_command("save",0);
				}


				run_command("reset",0);
			}

			if((dq_lcd_bdl_value_aclcdlr_status_a==2)||
					(dq_lcd_bdl_value_aclcdlr_status_a==3))
			{
				//	if((dq_lcd_bdl_value_wdq_min_a[lane_step])==0xffff)
				//		{dq_lcd_bdl_value_wdq_status_a[lane_step]=0;
				//		num_to_env(varname,num_arry);
				//             run_command("reset",0);
				//		}

				{
					if(dq_lcd_bdl_value_aclcdlr_status_a==2)
					{		dq_lcd_bdl_value_aclcdlr_status_a=3;
						{
							num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_aclcdlr_status_a;
							i=8+lane_step*8+3;
							sprintf(str_temp1,"ddr_test_data_num_%04d",i);
							sprintf(str_temp2,"0x%08x",num_arry[i]);
							setenv(str_temp1, str_temp2);
							run_command("save",0);
						}
						{
							lcdlr_temp_count=0;
							sprintf(buf, "0x%08x", lcdlr_temp_count);
							printf( "%s", buf);
							setenv(env_lcdlr_temp_count, buf);
							run_command("save",0);
						}

						sprintf(str,"ddr_tune_aclcdlr_step  a 0 0x%08x %d %d",add_test_size,( 0),1);
						printf("\nstr=%s\n",str);
						//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
						//printf("\nstr=%s\n",str);
						ddr_test_watchdog_clear();
						run_command(str,0);
						ddr_test_watchdog_clear();
						ddr_udelay(2000000);
						dq_lcd_bdl_value_aclcdlr_status_a=4;

					}
					else if (dq_lcd_bdl_value_aclcdlr_status_a==3)
					{
						temp_s= getenv(env_lcdlr_temp_count);
						if(temp_s)
						{
							lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
						}
						dq_lcd_bdl_value_aclcdlr_max_a=lcdlr_temp_count;
						dq_lcd_bdl_value_aclcdlr_status_a=4;
					}

					num_arry[8+lane_step*4*2+0]=dq_lcd_bdl_value_aclcdlr_org_a;
					//num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_wdq_min_a[lane_step];
					num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_aclcdlr_max_a;
					num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_aclcdlr_status_a;
					//ddr_udelay(1000000);
					//num_to_env(varname,num_arry);
					{
						i=8+lane_step*8+2;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						setenv(str_temp1, str_temp2);
						run_command("save",0);
						i=8+lane_step*8+3;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						setenv(str_temp1, str_temp2);
						run_command("save",0);
					}

					run_command("reset",0);
				}

			}


			if((dq_lcd_bdl_value_bdlr0_status_a==0xffff)
					||(dq_lcd_bdl_value_bdlr0_status_a==0)
					||(dq_lcd_bdl_value_bdlr0_status_a==1)
			  )
			{
				if((dq_lcd_bdl_value_bdlr0_status_a==0xffff)
						||(dq_lcd_bdl_value_bdlr0_status_a==0))
				{		dq_lcd_bdl_value_bdlr0_status_a=1;
					{
						num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_bdlr0_status_a;
						i=8+lane_step*8+7;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						setenv(str_temp1, str_temp2);
						run_command("save",0);
					}
					{
						lcdlr_temp_count=0;
						sprintf(buf, "0x%08x", lcdlr_temp_count);
						printf( "%s", buf);
						setenv(env_lcdlr_temp_count, buf);
						run_command("save",0);
					}

					sprintf(str,"ddr_tune_aclcdlr_step  a 0 0x%08x %d %d",add_test_size,( 1),2);
					printf("\nstr=%s\n",str);
					//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
					//printf("\nstr=%s\n",str);
					ddr_test_watchdog_clear();
					run_command(str,0);
					ddr_test_watchdog_clear();
					ddr_udelay(2000000);
					dq_lcd_bdl_value_bdlr0_status_a=2;

				}
				else if (dq_lcd_bdl_value_bdlr0_status_a==1)
				{
					temp_s= getenv(env_lcdlr_temp_count);
					if(temp_s)
					{
						lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
					}
					dq_lcd_bdl_value_bdlr0_min_a=lcdlr_temp_count;
					dq_lcd_bdl_value_bdlr0_status_a=2;
				}

				num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_bdlr0_org_a;
				num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_bdlr0_min_a;
				//num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
				num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_bdlr0_status_a;
				//ddr_udelay(1000000);
				//num_to_env(varname,num_arry);
				{
					i=8+lane_step*8+5;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					setenv(str_temp1, str_temp2);
					run_command("save",0);
					i=8+lane_step*8+7;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					setenv(str_temp1, str_temp2);
					run_command("save",0);
				}

				run_command("reset",0);
			}

			if((dq_lcd_bdl_value_bdlr0_status_a==2)||
					(dq_lcd_bdl_value_bdlr0_status_a==3))
			{

				{
					if(dq_lcd_bdl_value_bdlr0_status_a==2)
					{	

						dq_lcd_bdl_value_bdlr0_status_a=3;
						{
							num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_bdlr0_status_a;
							i=8+lane_step*8+7;
							sprintf(str_temp1,"ddr_test_data_num_%04d",i);
							sprintf(str_temp2,"0x%08x",num_arry[i]);
							setenv(str_temp1, str_temp2);
							run_command("save",0);
						}

						{
							lcdlr_temp_count=0;
							sprintf(buf, "0x%08x", lcdlr_temp_count);
							printf( "%s", buf);
							setenv(env_lcdlr_temp_count, buf);
							run_command("save",0);
						}

						sprintf(str,"ddr_tune_aclcdlr_step  a 0 0x%08x %d %d",add_test_size,( 1),1);
						printf("\nstr=%s\n",str);
						//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
						//printf("\nstr=%s\n",str);
						ddr_test_watchdog_clear();
						run_command(str,0);
						ddr_test_watchdog_clear();
						ddr_udelay(2000000);
						dq_lcd_bdl_value_bdlr0_status_a=4;

					}
					else if (dq_lcd_bdl_value_bdlr0_status_a==3)
					{
						temp_s= getenv(env_lcdlr_temp_count);
						if(temp_s)
						{
							lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
						}
						dq_lcd_bdl_value_bdlr0_max_a=lcdlr_temp_count;
						dq_lcd_bdl_value_bdlr0_status_a=4;
					}

					num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_bdlr0_org_a;
					//num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
					num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_bdlr0_max_a;
					num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_bdlr0_status_a;
					//ddr_udelay(1000000);
					//	num_to_env(varname,num_arry);

					{
						i=8+lane_step*8+6;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						setenv(str_temp1, str_temp2);
						run_command("save",0);
						i=8+lane_step*8+7;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						setenv(str_temp1, str_temp2);
						run_command("save",0);
					}
					run_command("reset",0);
				}

			}

			/*
			   if((dq_lcd_bdl_value_rdqs_status_a[lane_step]==0xffff)||
			   (dq_lcd_bdl_value_rdqs_status_a[lane_step]==0))
			   {dq_lcd_bdl_value_rdqs_status_a[lane_step]=0;
			   sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d",ddr_test_size,( lane_step*2+1),2);
			   printf("\nstr=%s\n",str);
			//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
			//printf("\nstr=%s\n",str);
			ddr_test_watchdog_clear();
			run_command(str,0);
			ddr_test_watchdog_clear();
			dq_lcd_bdl_value_rdqs_status_a[lane_step]=1;
			num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_rdqs_org_a[lane_step];
			num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
			//num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
			num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
			num_to_env(varname,num_arry);
			run_command("reset",0);
			}

			if((dq_lcd_bdl_value_rdqs_status_a[lane_step]==1)||
			(dq_lcd_bdl_value_rdqs_status_a[lane_step]==2))
			{dq_lcd_bdl_value_rdqs_status_a[lane_step]=2;
			sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d",ddr_test_size,( lane_step*2+1),1);
			printf("\nstr=%s\n",str);
			//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
			//printf("\nstr=%s\n",str);
			ddr_test_watchdog_clear();
			run_command(str,0);
			ddr_test_watchdog_clear();
			dq_lcd_bdl_value_rdqs_status_a[lane_step]=3;
			num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_rdqs_org_a[lane_step];
			//num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
			num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
			num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
			num_to_env(varname,num_arry);
			run_command("reset",0);
			}
			*/	


			ddr_test_watchdog_disable(); //s
			{printf("close  watchdog\n");
			}


		}



	}

	if (channel_b_en)
	{//*(char     *)(argv2[0])="b";
		//	run_command("ddr_test_cmd 11 a 0 0x80000  ",0);
		printf("\ntest dqs window lane b\n");
		for ((lane_step=0);(lane_step<8);(lane_step++))
		{
			//sprintf(str,"ddr_tune_dqs_step  a 0 0x80000 %d",( lane_step));
			//printf("\nstr=%s\n",str);
			sprintf(str,"ddr_tune_dqs_step  b 0 0x%08x %d",ddr_test_size,( lane_step));
			printf("\nstr=%s\n",str);
			run_command(str,0);

		}
	}

	unsigned int   acmdlr= 0;
	unsigned int  delay_step_x100= 0;
	if (channel_a_en)
	{
		acmdlr=((readl((DDR0_PUB_ACMDLR)))&ACLCDLR_MAX);
		delay_step_x100=100*1000000/(2*global_ddr_clk*acmdlr);
		printf("\nacmdlr=0x%08x-->dec %d,ddr clk==%d,step=%d ps,10step=%d ps,100step=%d ps,\n",acmdlr,acmdlr,global_ddr_clk,
				delay_step_x100/100,delay_step_x100/10,delay_step_x100);

		for ((lane_step=0);(lane_step<4);(lane_step++))
		{
			printf("\n a_lane_0x%08x|wdq_org 0x%08x  |wdq_min 0x%08x |wdq_max 0x%08x ::|rdqs_org  0x%08x  |rdqs_min 0x%08x |rdqs_max 0x%08x  \n",
					lane_step,
					dq_lcd_bdl_value_wdq_org_a[lane_step],
					dq_lcd_bdl_value_wdq_min_a[lane_step],dq_lcd_bdl_value_wdq_max_a[lane_step],
					dq_lcd_bdl_value_rdqs_org_a[lane_step],
					dq_lcd_bdl_value_rdqs_min_a[lane_step],dq_lcd_bdl_value_rdqs_max_a[lane_step]);
		}
		{
			printf("\nac_lane_0x%08x|lcd_org 0x%08x  |lcd_min 0x%08x |lcd_max 0x%08x ::|bdlr_org  0x%08x  |bdlr_min 0x%08x |bdlr_max 0x%08x  \n",
					4,
					dq_lcd_bdl_value_aclcdlr_org_a,
					dq_lcd_bdl_value_aclcdlr_min_a,dq_lcd_bdl_value_aclcdlr_max_a,
					dq_lcd_bdl_value_bdlr0_org_a,
					dq_lcd_bdl_value_bdlr0_min_a,dq_lcd_bdl_value_bdlr0_max_a);
		}
		printf("\n\n-----------------------------------------------------------------------------\n\n");
		{
			printf("\n ac_lane_0x0000000|  lcdlr_org  |lcdlr_set ps|lcdlr_hold ps:|\
					clk_setup  ps| clk_hold ps|adj_percent[100]\n");

			printf("\n ac_lane0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					4,
					dq_lcd_bdl_value_aclcdlr_org_a,
					(((dq_lcd_bdl_value_aclcdlr_max_a-dq_lcd_bdl_value_aclcdlr_org_a)*delay_step_x100
					 )/100),
					(((dq_lcd_bdl_value_aclcdlr_org_a-dq_lcd_bdl_value_aclcdlr_min_a)*delay_step_x100
					 )/100),

					0,
					0,
					100*(dq_lcd_bdl_value_aclcdlr_max_a+dq_lcd_bdl_value_aclcdlr_min_a)/(
						2*dq_lcd_bdl_value_aclcdlr_org_a));
			printf("\n ck_lane0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					4,
					dq_lcd_bdl_value_bdlr0_org_a,
					0,
					0,
					(((dq_lcd_bdl_value_bdlr0_org_a-dq_lcd_bdl_value_bdlr0_min_a)*delay_step_x100
					 )/100),
					(((dq_lcd_bdl_value_bdlr0_max_a-dq_lcd_bdl_value_bdlr0_org_a)*delay_step_x100
					 )/100),

					100*(dq_lcd_bdl_value_aclcdlr_max_a+dq_lcd_bdl_value_aclcdlr_min_a)/(
						2*dq_lcd_bdl_value_bdlr0_org_a));
		}
		printf("\n a_lane_0x00000000| wrdq_org 0x0|w_setup x ps|w_hold  x ps::|\
				rd_setup  ps|rd_hold x ps|adj_percent[100]\n");


		for ((lane_step=0);(lane_step<4);(lane_step++))
		{
			printf("\n a_lane_0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					lane_step,
					dq_lcd_bdl_value_wdq_org_a[lane_step],
					(((dq_lcd_bdl_value_wdq_max_a[lane_step]-dq_lcd_bdl_value_wdq_org_a[lane_step])*delay_step_x100
					 )/100),
					(((dq_lcd_bdl_value_wdq_org_a[lane_step]-dq_lcd_bdl_value_wdq_min_a[lane_step])*delay_step_x100
					 )/100),

					0,
					0,
					100*(dq_lcd_bdl_value_wdq_max_a[lane_step]+dq_lcd_bdl_value_wdq_min_a[lane_step])/(
						2*dq_lcd_bdl_value_wdq_org_a[lane_step]));

			printf("\n a_lane_0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					lane_step,
					dq_lcd_bdl_value_rdqs_org_a[lane_step],
					0,
					0,

					(((dq_lcd_bdl_value_rdqs_org_a[lane_step]-dq_lcd_bdl_value_rdqs_min_a[lane_step])*delay_step_x100
					 )/100),
					(((dq_lcd_bdl_value_rdqs_max_a[lane_step]-dq_lcd_bdl_value_rdqs_org_a[lane_step])*delay_step_x100
					 )/100),
					100*(dq_lcd_bdl_value_rdqs_max_a[lane_step]+dq_lcd_bdl_value_rdqs_min_a[lane_step])/(
						2*dq_lcd_bdl_value_rdqs_org_a[lane_step]));



		}
	}



	if (channel_b_en)
	{
		for ((lane_step=0);(lane_step<4);(lane_step++))
		{;
		}
	}

	return reg_value;
}


U_BOOT_CMD(
	ddr_dqs_window_step,	6,	1,	do_ddr_test_dqs_window_step,
	"DDR tune dqs function",
	"ddr_dqs_window_step a 0 0x800000 1 or ddr_dqs_window_step b 0 0x800000 5\n dcache off ? \n"
);

///*

#endif

int do_ddr2pll_cmd(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{

#if ( CONFIG_DDR_PHY >= P_DDR_PHY_G12)
	extern int do_ddr2pll_g12_cmd(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[]);
	do_ddr2pll_g12_cmd(cmdtp,flag,argc, argv);
	return 1;
#endif

#define DDR_TEST_CMD_TEST_ZQ     0
#define DDR_TEST_CMD_TEST_AC_BIT_SETUP      1
#define DDR_TEST_CMD_TEST_AC_BIT_HOLD     2
#define DDR_TEST_CMD_TEST_DATA_WRITE_BIT_SETUP      3
#define DDR_TEST_CMD_TEST_DATA_WRITE_BIT_HOLD      4
#define DDR_TEST_CMD_TEST_DATA_READ_BIT_SETUP      5
#define DDR_TEST_CMD_TEST_DATA_READ_BIT_HOLD     6
#define DDR_TEST_CMD_TEST_DATA_VREF     7
#define DDR_TEST_CMD_TEST_CLK_INVETER     8

#define DDR_TEST_CMD_TEST_FULLTEST     0xffffffff
	char *endp;
	unsigned int pll, zqcr;
	unsigned int zqpr_soc_dram=0;
	unsigned int ddr_test_cmd_soc_vref=0;
	unsigned int ddr_test_cmd_dram_vref=0;//0x3f;
	unsigned int ddr_test_cmd_zq_vref=0;//0x3f;


	unsigned int ddr_full_test_enable=0;
	/*
#define DDR3_DRV_40OHM		0
#define DDR3_DRV_34OHM		1
#define DDR3_ODT_0OHM		0
#define DDR3_ODT_60OHM		1
#define DDR3_ODT_120OHM		2
#define DDR3_ODT_40OHM		3
#define DDR3_ODT_20OHM		4
#define DDR3_ODT_30OHM		5

	// lpddr2 drv odt 
#define LPDDR2_DRV_34OHM	1
#define LPDDR2_DRV_40OHM	2
#define LPDDR2_DRV_48OHM	3
#define LPDDR2_DRV_60OHM	4
#define LPDDR2_DRV_80OHM	6
#define LPDDR2_DRV_120OHM	7
#define LPDDR2_ODT_0OHM		0

	// lpddr3 drv odt 
#define LPDDR3_DRV_34OHM	1
#define LPDDR3_DRV_40OHM	2
#define LPDDR3_DRV_48OHM	3
#define LPDDR3_DRV_60OHM	4
#define LPDDR3_DRV_80OHM	6
#define LPDDR3_DRV_34_40OHM	9
#define LPDDR3_DRV_40_48OHM	10
#define LPDDR3_DRV_34_48OHM	11
#define LPDDR3_ODT_0OHM		0
#define LPDDR3_ODT_60OHM	1
#define LPDDR3_ODT_12OHM	2
#define LPDDR3_ODT_240HM	3

#define DDR4_DRV_34OHM		0
#define DDR4_DRV_48OHM		1
#define DDR4_ODT_0OHM		0
#define DDR4_ODT_60OHM		1
#define DDR4_ODT_120OHM		2
#define DDR4_ODT_40OHM		3
#define DDR4_ODT_240OHM		4
#define DDR4_ODT_48OHM		5
#define DDR4_ODT_80OHM		6
#define DDR4_ODT_34OHM		7
*/
	printf("\nargc== 0x%08x\n", argc);
	int i ;
	for (i = 0;i<argc;i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}

	unsigned int soc_data_drv_odt				= 0;
	//unsigned int dram_drv				= 0;
	//unsigned int dram_odt				= 0;
	/* need at least two arguments */
	if (argc < 2)
		goto usage;

	pll = simple_strtoull_ddr(argv[1], &endp,0);
	if (*argv[1] == 0 || *endp != 0) {
		printf ("Error: Wrong format parament!\n");
		return 1;
	}
	if (argc >2)
	{
		zqcr = simple_strtoull_ddr(argv[2], &endp, 0);
		if (*argv[2] == 0 || *endp != 0) {
			zqcr = 0;
		}
	}
	else
	{
		zqcr = 0;
	}

	if(zqcr==0xffffffff)
	{
		ddr_full_test_enable=1;
		zqcr=0;}

	if (argc >3)
	{
		// soc_data_drv_odt=zqpr_soc_dram&0xfffff;
		// dram_drv=(zqpr_soc_dram>>20)&0xf;
		//  dram_odt=(zqpr_soc_dram>>24)&0xf;
		//bit28 enable soc_zqpr ,bit 29 enabe dram_drv bit 30 enable dram_odt
		zqpr_soc_dram = simple_strtoull_ddr(argv[3], &endp, 0);
		if (*argv[3] == 0 || *endp != 0) {
			zqpr_soc_dram = 0;
		}
	}
	else
	{
		zqpr_soc_dram = 0;
	}

	if (argc >4)
	{
		ddr_test_cmd_soc_vref = simple_strtoull_ddr(argv[4], &endp, 0);
		if (*argv[4] == 0 || *endp != 0) {
			ddr_test_cmd_soc_vref = 0;
		}
	}
	else
	{
		ddr_test_cmd_soc_vref = 0;
	}
	if (argc >5)
	{
		ddr_test_cmd_dram_vref = simple_strtoull_ddr(argv[5], &endp, 0);
		if (*argv[5] == 0 || *endp != 0) {
			ddr_test_cmd_dram_vref = 0;
		}
	}
	unsigned int soc_dram_hex_dec=0;
	if (argc >6)
	{
		soc_dram_hex_dec = simple_strtoull_ddr(argv[6], &endp, 0);
		if (*argv[6] == 0 || *endp != 0) {
			soc_dram_hex_dec = 0;
		}
	}
	if (argc >7)
	{
		ddr_test_cmd_zq_vref = simple_strtoull_ddr(argv[7], &endp, 0);
		if (*argv[7] == 0 || *endp != 0) {
			ddr_test_cmd_zq_vref = 0;
		}
	}



	unsigned int soc_dram_drv_odt_use_vlaue=0;
	unsigned int soc_ac_drv=0;
	unsigned int soc_ac_odt=0;
	unsigned int soc_data_drv=0;
	unsigned int soc_data_odt=0;
	unsigned int dram_drv=0;
	unsigned int dram_odt=0;
	unsigned int soc_data_drv_odt_adj_enable=0;
	unsigned int dram_data_drv_adj_enable=0;
	unsigned int dram_data_odt_adj_enable=0;

	unsigned int zq0pr_org = rd_reg(DDR0_PUB_ZQ0PR);
	unsigned int zq1pr_org = rd_reg(DDR0_PUB_ZQ1PR);
	unsigned int pub_dcr= rd_reg(DDR0_PUB_DCR);
#define DDR_TYPE_LPDDR2  0
#define DDR_TYPE_LPDDR3  1
#define DDR_TYPE_DDR3  3
#define DDR_TYPE_DDR4  4
	unsigned int ddr_type= pub_dcr&0x7; //0 -lpddr2  |  1- lpddr3  |   2- rev  |  3 -ddr3   | 4- ddr4
	//	unsigned int zq2pr_org = rd_reg(DDR0_PUB_ZQ2PR);
	if (argc >8)
	{
		soc_dram_drv_odt_use_vlaue = simple_strtoull_ddr(argv[8], &endp, 0);
		if (*argv[8] == 0 || *endp != 0) {
			soc_dram_drv_odt_use_vlaue = 0;
		}
	}
	if(soc_dram_drv_odt_use_vlaue)
	{if(zqcr)
		{printf("zqcr[0x%08x],\n", zqcr);
			{
				soc_ac_drv=zqcr%100;
				if(soc_ac_drv>100)
				{soc_ac_drv=0;}
				if(soc_ac_drv==0)
				{soc_ac_drv=1;}
				soc_ac_drv=(480/soc_ac_drv)-1;

				if(ddr_type==DDR_TYPE_DDR3)
				{
					if(soc_ac_drv>0xf)
					{soc_ac_drv=zq0pr_org&0xf;}
				}
				if(ddr_type==DDR_TYPE_DDR4)
				{
					if(soc_ac_drv>0xf)
					{soc_ac_drv=(zq0pr_org>>8)&0xf;}
				}
			}


			{
				soc_ac_odt=zqcr/100;
				if(soc_ac_odt>240)
				{soc_ac_odt=480;}
				if(soc_ac_odt==0)
				{soc_ac_odt=1;}


				if(ddr_type==DDR_TYPE_DDR3)
				{
					soc_ac_odt=(360/soc_ac_odt)-1;
					if(soc_ac_odt>0xf)
					{soc_ac_odt=(zq0pr_org>>4)&0xf;}
				}
				if(ddr_type==DDR_TYPE_DDR4)
				{
					soc_ac_odt=(480/soc_ac_odt)-1;
					if(soc_ac_odt>0xf)
					{soc_ac_odt=(zq0pr_org>>16)&0xf;}
				}
			}

			zqcr=(soc_ac_odt<<16)|(soc_ac_drv<<12)|(soc_ac_drv<<8)|(soc_ac_odt<<4)|(soc_ac_drv);
			printf("zqcr[0x%08x],soc_ac_odt [0x%08x],soc_ac_drv [0x%08x]\n", zqcr,soc_ac_odt,soc_ac_drv);
		}
		if(zqpr_soc_dram)
		{printf("zqpr_soc_dram[0x%08x],\n", zqpr_soc_dram);
			{
				soc_data_drv=zqpr_soc_dram%100;
				printf("soc_data_drv[%d],\n", soc_data_drv);
				if(soc_data_drv>100)
				{soc_data_drv=0;

				}
				if(soc_data_drv==0)
				{soc_data_drv=1;
					//soc_data_drv_odt_adj_enable=0;
				}
				else
				{//soc_data_drv_odt_adj_enable=1;
				}
				soc_data_drv=(480/soc_data_drv)-1;

				if(ddr_type==DDR_TYPE_DDR3)
				{
					if(soc_data_drv>0xf)
					{soc_data_drv=zq1pr_org&0xf;}
				}
				if(ddr_type==DDR_TYPE_DDR4)
				{
					if(soc_data_drv>0xf)
					{soc_data_drv=(zq1pr_org>>8)&0xf;}
				}
			}


			{
				soc_data_odt=(zqpr_soc_dram/100)%1000;
				printf("soc_data_odt[%d],\n", soc_data_odt);
				if(soc_data_odt>240)
				{soc_data_odt=360;}
				if(soc_data_odt==0)
				{soc_data_odt=1;}


				if(ddr_type==DDR_TYPE_DDR3)
				{
					soc_data_odt=(360/soc_data_odt)-1;
					if(soc_data_odt>0xf)
					{soc_data_odt=(zq1pr_org>>4)&0xf;}
				}
				if(ddr_type==DDR_TYPE_DDR4)
				{
					soc_data_odt=(480/soc_data_odt)-1;
					if(soc_data_odt>0xf)
					{soc_data_odt=(zq1pr_org>>16)&0xf;}
				}

			}

			soc_data_drv_odt_adj_enable=1;

			{
				dram_drv=(zqpr_soc_dram/100000)%100;
				printf("dram_drv[%d],\n", dram_drv);

				if(dram_drv>100)
				{dram_drv=0;}
				if(dram_drv==0)
				{
					dram_data_drv_adj_enable=0;}
				else
				{dram_data_drv_adj_enable=1;
				}

				if(ddr_type==DDR_TYPE_DDR3)
				{
					if(dram_drv>=40)
					{dram_drv=0;}

					else
					{dram_drv=1;
					}
				}


				if(ddr_type==DDR_TYPE_DDR4)
				{
					if(dram_drv<48)
					{dram_drv=0;}

					else
					{dram_drv=1;
					}
				}
			}


			{
				dram_odt=(zqpr_soc_dram/100000)/100;
				printf("dram_odt[%d],\n", dram_odt);
				if(dram_odt>240)
				{dram_odt=480;}
				if(dram_odt==0)
				{
					dram_data_odt_adj_enable=0;
				}
				else
				{dram_data_odt_adj_enable=1;
				}


				if(ddr_type==DDR_TYPE_DDR3)
				{
					if(dram_odt>160)
					{dram_odt=0;}
					else if (dram_odt>90)
					{dram_odt=2;}
					else if (dram_odt>50)
					{dram_odt=1;}
					else if (dram_odt>35)
					{dram_odt=3;}
					else if (dram_odt>25)
					{dram_odt=5;}
					else if (dram_odt<=25)
					{dram_odt=4;}

				}
				if(ddr_type==DDR_TYPE_DDR4)
				{
					if(dram_odt>280)
					{dram_odt=0;}
					else if (dram_odt>180)
					{dram_odt=4;}
					else if (dram_odt>100)
					{dram_odt=2;}
					else if (dram_odt>70)
					{dram_odt=6;}
					else if (dram_odt>54)
					{dram_odt=1;}
					else if (dram_odt>44)
					{dram_odt=5;}
					else if (dram_odt>37)
					{dram_odt=3;}
					else if (dram_odt<=34)
					{dram_odt=7;}

				}



			}

			zqpr_soc_dram=(dram_data_odt_adj_enable<<30)|(dram_data_drv_adj_enable<<29)|(soc_data_drv_odt_adj_enable<<28)|
				(dram_odt<<24)|(dram_drv<<20)|(soc_data_odt<<16)|(soc_data_drv<<12)|(soc_data_drv<<8)|(soc_data_odt<<4)|(soc_data_drv);
		}
	}


	if (soc_dram_hex_dec)
	{
		if (argc >4)
		{
			ddr_test_cmd_soc_vref = simple_strtoull_ddr(argv[4], &endp, 0);
			if (*argv[4] == 0 || *endp != 0) {
				ddr_test_cmd_soc_vref = 0;
			}
		}
		else
		{
			ddr_test_cmd_soc_vref = 0;
		}
		if (argc >5)
		{
			ddr_test_cmd_dram_vref = simple_strtoull_ddr(argv[5], &endp, 0);
			if (*argv[5] == 0 || *endp != 0) {
				ddr_test_cmd_dram_vref = 0;
			}
		}
		if (argc >7)
		{
			ddr_test_cmd_zq_vref = simple_strtoull_ddr(argv[7], &endp, 0);
			if (*argv[7] == 0 || *endp != 0) {
				ddr_test_cmd_zq_vref = 0;
			}
		}
		if (ddr_test_cmd_soc_vref)
		{
			if (ddr_test_cmd_soc_vref<45)
				ddr_test_cmd_soc_vref=45;
			if (ddr_test_cmd_soc_vref>88)
				ddr_test_cmd_soc_vref=88;
			ddr_test_cmd_soc_vref=(ddr_test_cmd_soc_vref*100-4407)/70;
		}

		if (ddr_test_cmd_dram_vref)
		{
			if (ddr_test_cmd_dram_vref<45)
				ddr_test_cmd_dram_vref=45;
			if (ddr_test_cmd_dram_vref>92)
				ddr_test_cmd_dram_vref=92;
			if (ddr_test_cmd_dram_vref>60) {
				ddr_test_cmd_dram_vref=(ddr_test_cmd_dram_vref*100-6000)/65;
			}
			else{
				ddr_test_cmd_dram_vref=((ddr_test_cmd_dram_vref*100-4500)/65)|(1<<6);
			}
		}


		printf("\nSet ddr_test_cmd_dram_vref [0x%08x]\n",ddr_test_cmd_dram_vref);
		if (ddr_test_cmd_zq_vref == 0)
			ddr_test_cmd_zq_vref=0;
		if (ddr_test_cmd_zq_vref) {
			if (ddr_test_cmd_zq_vref<45)
				ddr_test_cmd_zq_vref=45;
			if (ddr_test_cmd_zq_vref>88)
				ddr_test_cmd_zq_vref=88;
			ddr_test_cmd_zq_vref=(ddr_test_cmd_zq_vref*100-4407)/70;
		}
	}

	//if(ddr_test_cmd_type==DDR_TEST_CMD_TEST_AC_BIT_HOLD)
	//{if (ddr_test_cmd_clk_seed ==0)
	//ddr_test_cmd_clk_seed = 0x3f;
	//if (ddr_test_cmd_acbdl_x_seed ==0)
	//ddr_test_cmd_acbdl_x_seed = 0x3f;
	//}

#if defined(CONFIG_M6TV) || defined(CONFIG_M6TVD)
	writel(zqcr | (0x3c << 24), PREG_STICKY_REG0);
#else
	writel(zqcr | (0xf13 << 20), PREG_STICKY_REG0);
#endif
#if ( CONFIG_DDR_PHY>=P_DDR_PHY_905X)
	writel((ddr_test_cmd_zq_vref<<24)|(ddr_test_cmd_soc_vref<<8)|ddr_test_cmd_dram_vref , PREG_STICKY_REG9);
	writel((zqpr_soc_dram<<0) , PREG_STICKY_REG8);
	soc_data_drv_odt=zqpr_soc_dram&0xfffff;
	dram_drv=(zqpr_soc_dram>>20)&0xf;
	dram_odt=(zqpr_soc_dram>>24)&0xf;
	printf("setting zqpr_soc_dram [0x%08x],..bit28 enable soc_zqpr ,   bit 29 enabe dram_drv,   bit 30 enable dram_odt\n", zqpr_soc_dram);
	printf("soc_data_drv_odt [0x%08x],dram_drv [0x%08x],dram_odt [0x%08x]\n", soc_data_drv_odt,dram_drv,dram_odt);
	if(ddr_full_test_enable)
	{
		pll=(ddr_full_test_enable<<21)|pll;
		printf("ddr_full_test_enable %08x,set sticky reg1 bit 21 1\n", ddr_full_test_enable);
	}

#endif


	writel(pll, PREG_STICKY_REG1);

	printf("Set pll done [0x%08x]\n", readl(PREG_STICKY_REG1));
	printf("Set STICKY_REG0 [0x%08x]\n", readl(PREG_STICKY_REG0));
#if ( CONFIG_DDR_PHY>=P_DDR_PHY_905X)
	printf("Set STICKY_REG9 [0x%08x]\n", readl(PREG_STICKY_REG9));
	printf("Set STICKY_REG8 [0x%08x]\n", readl(PREG_STICKY_REG8));

#endif
	printf("\nbegin reset 111...........\n");
	printf("\nbegin reset 2...........\n");
	printf("\nbegin reset 3...........\n");

#ifdef CONFIG_M8B
	printf(" t1 \n");
	writel(0xf080000 | 2000, WATCHDOG_TC);
#else
	printf(" t2 \n");
	//  writel(WATCHDOG_TC, 0xf400000 | 2000);
	// *P_WATCHDOG_RESET = 0;
	ddr_test_watchdog_reset_system();
#endif
	while(1);
	return 0;

usage:

	printf(" ddr_test_cmd 0x17 clk zq_ac zq_soc_dram soc_vref dram_vref dec_hex zq_vref 0\n");
	printf("example ddr_test_cmd 0x17 1200 0x2aa4a 0x2015995d 50 81 1 50 \n");
	printf("or  ddr_test_cmd 0x17 1200 0x2aa4a 0x2015995d 0x09 0x20 0 50 \n");
	printf("or  ddr_test_cmd 0x17 1200 6034 0603406034 0 0 0 0 1 \n");
	printf("setting zqpr_soc_dram ,..bit28 enable soc_zqpr ,   bit 29 enabe dram_drv,   bit 30 enable dram_odt\n");
	printf("setting zqpr_soc_dram ,bit0-bit19  soc_data_drv_odt,bit20-bit24  dram_drv ,  bit24-bit28  dram_odt\n");
	printf("setting zqpr_soc_dram ,bit0-bit19 bit 0-7 use for ddr3,bit8-19 use for ddr4,odt_down_up\n");
	printf("setting zqpr_soc_dram ,soc_drv=(480/((setting)+1));ddr4---soc_odt=(480/(setting)+1));ddr3---soc_odt=(360/(setting)+1));\n");

	printf(" DDR3_DRV_40OHM		0\n");
	printf(" DDR3_DRV_34OHM		1\n\n");

	printf(" DDR3_ODT_0OHM		0\n");
	printf(" DDR3_ODT_60OHM		1\n");
	printf(" DDR3_ODT_120OHM	2\n");
	printf(" DDR3_ODT_40OHM		3\n");
	printf(" DDR3_ODT_20OHM		4\n");
	printf(" DDR3_ODT_30OHM		5\n\n\n");

	printf(" LPDDR2_DRV_34OHM	1\n");
	printf(" LPDDR2_DRV_40OHM	2\n");
	printf(" LPDDR2_DRV_48OHM	3\n");
	printf(" LPDDR2_DRV_60OHM	4\n");
	printf(" LPDDR2_DRV_80OHM	6\n");
	printf(" LPDDR2_DRV_120OHM	7\n\n");

	printf(" LPDDR2_ODT_0OHM	0\n\n\n");


	printf(" LPDDR3_DRV_34OHM	1\n");
	printf(" LPDDR3_DRV_40OHM	2\n");
	printf(" LPDDR3_DRV_48OHM	3\n");
	printf(" LPDDR3_DRV_60OHM	4\n");
	printf(" LPDDR3_DRV_80OHM	6\n");
	printf(" LPDDR3_DRV_34_40OHM	9\n");
	printf(" LPDDR3_DRV_40_48OHM	10\n");
	printf(" LPDDR3_DRV_34_48OHM	11\n\n");

	printf(" LPDDR3_ODT_0OHM		0\n");
	printf(" LPDDR3_ODT_60OHM	1\n");
	printf(" LPDDR3_ODT_12OHM	2\n");
	printf(" LPDDR3_ODT_240HM	3\n\n\n");

	printf(" DDR4_DRV_34OHM		0\n");
	printf(" DDR4_DRV_48OHM		1\n\n");

	printf(" DDR4_ODT_0OHM		0\n");
	printf(" DDR4_ODT_60OHM		1\n");
	printf(" DDR4_ODT_120OHM		2\n");
	printf(" DDR4_ODT_40OHM		3\n");
	printf(" DDR4_ODT_240OHM		4\n");
	printf(" DDR4_ODT_48OHM		5\n");
	printf(" DDR4_ODT_80OHM		6\n");
	printf(" DDR4_ODT_34OHM		7\n\n\n\n");


	cmd_usage(cmdtp);
	return 1;
}

int do_ddr_uboot_new_cmd(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	//ddr_test_cmd 0x36 0x20180030 0x1 cmd_offset cmd_value value_size reset_enable
#if 1
	//#define DDR_USE_DEFINE_TEMPLATE_CONFIG   1
	//#define DDR_STICKY_MAGIC_NUMBER					0x20180000
	//#define DDR_CHIP_ID								0x30
	//#define DDR_STICKY_SOURCE_DMC_STICKY			0x1
	//#define DDR_STICKY_SOURCE_SRAM					0x2
	//dmc sticky reg default not 0. need use common sticky reg as identity

#if 0
	unsigned int ddr_pll = rd_reg(AM_DDR_PLL_CNTL0);
	extern int pll_convert_to_ddr_clk_g12a(unsigned int);
	global_ddr_clk=pll_convert_to_ddr_clk_g12a(ddr_pll);
#endif
#define DDR_STICKY_OVERRIDE_CONFIG_MESSAGE_CMD	0x1 //override config
#define DDR_STICKY_SPECIAL_FUNCTION_CMD			0x2 //special test such as shift some bdlr or parameter or interleave test

#define G12_DMC_STICKY_0                               ((0x0000  << 2) + 0xff638800)
	uint32_t magic_chipid= 0;//rd_reg(P_PREG_STICKY_REG0);
	uint32_t sticky_cmd = 0;//rd_reg(P_PREG_STICKY_REG1);
	uint32_t cmd_offset = 0;
	uint32_t cmd_value = 0;
	uint32_t reset_enable = 0;
	uint32_t value_size = 4;
	char *endp;
	//bit 0 trigger effect reset.
	if ((magic_chipid) != ((DDR_STICKY_MAGIC_NUMBER+DDR_CHIP_ID)&0xffff0000)) {
		//magic number not match
		//	magic_chipid=DDR_STICKY_MAGIC_NUMBER+DDR_CHIP_ID;
		//	sticky_cmd=DDR_STICKY_OVERRIDE_CONFIG_MESSAGE_CMD;
		printf("sticky0 magic not match\n");

	}


	//	wr_reg(P_PREG_STICKY_REG0, 0);
	//	wr_reg(P_PREG_STICKY_REG1, 0);



	printf("\nargc== 0x%08x\n", argc);
	int i ;
	for (i = 0;i<argc;i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}



	if (argc < 2)
		goto usage;

	magic_chipid = simple_strtoull_ddr(argv[1], &endp,0);
	if (*argv[1] == 0 || *endp != 0) {
		printf ("Error: Wrong format parament!\n");
		return 1;
	}
	if (argc >2)
	{
		sticky_cmd = simple_strtoull_ddr(argv[2], &endp, 0);
		if (*argv[2] == 0 || *endp != 0) {
			sticky_cmd = 0;
		}
	}

	if (argc >3)
	{
		cmd_offset = simple_strtoull_ddr(argv[3], &endp, 0);
		if (*argv[3] == 0 || *endp != 0) {
			cmd_offset = 0;
		}
	}
	if (argc >4)
	{
		cmd_value= simple_strtoull_ddr(argv[4], &endp, 0);
		if (*argv[4] == 0 || *endp != 0) {
			cmd_value = 0;
		}
	}
	if (argc >5)
	{
		value_size= simple_strtoull_ddr(argv[5], &endp, 0);
		if (*argv[5] == 0 || *endp != 0) {
			value_size = 4;
		}
	}
	if (argc >6)
	{
		reset_enable= simple_strtoull_ddr(argv[6], &endp, 0);
		if (*argv[6] == 0 || *endp != 0) {
			reset_enable = 0;
		}
	}
	printf("cmd_offset[0x%08x}==cmd_value [0x%08x]\n", cmd_offset,cmd_value);
	writel((magic_chipid&0xffff0000)|(rd_reg(PREG_STICKY_REG0)), PREG_STICKY_REG0);
	writel(sticky_cmd, PREG_STICKY_REG1);

	uint32_t read_value = 0;
	if(value_size)
	{
		read_value=rd_reg(G12_DMC_STICKY_0+((cmd_offset/4)<<2));
		if(value_size==1){
			wr_reg((G12_DMC_STICKY_0+((cmd_offset/4)<<2)), ((cmd_value<<((cmd_offset%4)*8))|(read_value&(~(0xff<<((cmd_offset%4)*8))))));
		}
		if(value_size==2){
			wr_reg((G12_DMC_STICKY_0+((cmd_offset/4)<<2)), ((cmd_value<<((cmd_offset%4)*8))|(read_value&(~(0xffff<<((cmd_offset%4)*8))))));
		}
		if(value_size==4){
			//	wr_reg((G12_DMC_STICKY_0+cmd_offset/4), ((cmd_value<<((cmd_offset%4)*8))|(read_value&(~(0xffff<<((cmd_offset%4)*8))))));
			wr_reg((G12_DMC_STICKY_0+((cmd_offset/4)<<2)), cmd_value);
		}




		printf("DMC_STICKY_0_ offset[0x%08x}== [0x%08x]\n", cmd_offset,readl((G12_DMC_STICKY_0+((cmd_offset/4)<<2))));
	}


	printf("PREG_STICKY_REG0== [0x%08x]\n", readl(PREG_STICKY_REG0));

	if(reset_enable)
	{
		ddr_test_watchdog_reset_system();

		while(1);
	}
	return 0;

usage:





	cmd_usage(cmdtp);

#endif
	return 1;
}


#if ( CONFIG_DDR_PHY >= P_DDR_PHY_G12)
#else
int do_ddr_test_ac_bit_setup_hold_window(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter test ddr ac bit window  function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);
	unsigned int   ddl_100step_ps= 0;

	unsigned int   temp_test_error= 0;
	unsigned int   temp_count= 0;
	unsigned int   temp_reg_value[40];

	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_ac_setup_hold=0;
	//unsigned int   testing_seed=0;
	// unsigned int   test_lane_step_rdqs_flag=0;
	unsigned int   test_acbdl=0;
	//   unsigned int   test_times=1;
	unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;


	unsigned int   acbdlr0_reg_org=0;
	unsigned int   acbdlr_x_reg_org=0;
	unsigned int   acbdlr_x_reg_hold_min=0;
	//  unsigned int   acbdlr_x_reg_hold_min=0;
	unsigned int   acbdlr_x_reg_setup_max=0;
	//    unsigned int   acbdlr_x_reg_setup_max=0;
	//  unsigned int   dq_lcd_bdl_reg_left=0;
	//  unsigned int   dq_lcd_bdl_reg_right=0;


	//  unsigned int   dq_lcd_bdl_reg_left_min=0;
	//  unsigned int   dq_lcd_bdl_reg_right_min=0;

	unsigned int   dq_lcd_bdl_temp_reg_value=0;


	//  unsigned int   dq_lcd_bdl_temp_reg_lef_min_value;
	//     unsigned int   dq_lcd_bdl_temp_reg_rig_min_value;


	//   unsigned int   dq_lcd_bdl_temp_reg_lef;
	//   unsigned int   dq_lcd_bdl_temp_reg_rig;


	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;


	{
		if (argc == 2)
		{
			if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))

			{channel_a_en = 1;
			}
			else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))

			{channel_b_en = 1;
			}
			else
			{
				goto usage;
			}
		}
		if (argc > 2)
		{
			if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))

			{channel_a_en = 1;
			}
			if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

			{channel_b_en = 1;
			}
		}
		ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		if (argc >3) {
			ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
			if (*argv[3] == 0 || *endp != 0)
			{
				ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
			}

		}
		if (argc >4) {
			test_ac_setup_hold = 0;
			test_ac_setup_hold = simple_strtoull_ddr(argv[4], &endp, 16);
			if (*argv[4] == 0 || *endp != 0)
			{
				test_ac_setup_hold = 0;
			}
			if   ((strcmp(argv[4], "l") == 0) || (strcmp(argv[4], "L") == 0))
			{
				test_ac_setup_hold = 0;
			}
		}
		if (test_ac_setup_hold >1)
			test_ac_setup_hold = 2;
		if (argc >5) {

			test_acbdl= simple_strtoull_ddr(argv[5], &endp, 16);
			if (*argv[5] == 0 || *endp != 0)
			{
				test_acbdl = 0;
			}
			if (test_acbdl>39)
				test_acbdl =12;//default test cs0 pin
		}
	}
	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_ac_setup_hold== 0x%08x\n", test_ac_setup_hold);
	printf("\ntest_acbdl== 0x%08x\n", test_acbdl);
	if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}



	//save and print org training dqs value
	if (channel_a_en || channel_b_en)
	{
		//dcache_disable();
		//serial_puts("\ndebug for ddrtest ,jiaxing disable dcache");

	}////save and print org training dqs value
	{
		////tune and save training dqs value
		if (channel_a_en || channel_b_en)
		{

			{

				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				printf("\nshould pause ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
				writel((readl(DDR0_PUB_REG_BASE+4))|(1<<29),(DDR0_PUB_REG_BASE+4));
				printf("\n pause ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));


				for ((temp_count=0);(temp_count<10);(temp_count++))
				{
					acbdlr0_9_reg_org[temp_count]=(readl(DDR0_PUB_ACBDLR0+(temp_count<<2)+reg_base_adj));

				};


				{
					ddl_100step_ps=((100*1000*1000)/(2*global_ddr_clk))/((((readl(DDR0_PUB_ACMDLR0+reg_base_adj)))>>16)&0xff);
					printf("\nddl_100step_ps== %08d,0_5cycle_ps== %08d,0_5cycle==0x%08x\n", ddl_100step_ps,((1000*1000)/(2*global_ddr_clk)),
							((((readl(DDR0_PUB_ACMDLR0+reg_base_adj)))>>16)&0xff));

					reg_add=DDR0_PUB_ACBDLR0+reg_base_adj;
					acbdlr0_reg_org=readl(DDR0_PUB_ACBDLR0+reg_base_adj);
					acbdlr_x_reg_org=readl(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj);
					printf("\ntest_acbdl %08x | ac_setup_hold==0x%08x\n ",test_acbdl,test_ac_setup_hold);
					printf("\nacbdlr0_reg_0x%08x_org==0x%08x  |  acbdlr_x_reg_0x%08x_org==0x%08x\n ",(DDR0_PUB_ACBDLR0+reg_base_adj),
							acbdlr0_reg_org,(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj),acbdlr_x_reg_org);
					if (test_ac_setup_hold == 0)
					{
						printf("\ntest_ac_setup\n ");


						//writel(0,(DDR0_PUB_ACBDLR0+reg_base_adj));
						dq_lcd_bdl_temp_reg_value=readl(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj);


						//{writel((dq_lcd_bdl_temp_reg_value&(~(0xff<<(8*(test_acbdl%4))))),((test_acbdl/4)*4+DDR0_PUB_ACBDLR0+reg_base_adj));
						//}



						reg_add=(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj);
						acbdlr_x_reg_org=readl(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj);
						dq_lcd_bdl_temp_reg_value=((acbdlr_x_reg_org>>(8*(test_acbdl%4)))&0xff);
						while (dq_lcd_bdl_temp_reg_value<ACBDLR_MAX)
						{
							temp_test_error=0;
							dq_lcd_bdl_temp_reg_value++;
							printf("\n reg_add==0x%08x,right temp==0x%08x\n,value==0x%08x",reg_add,dq_lcd_bdl_temp_reg_value,
									((acbdlr_x_reg_org)&(~(0xff<<(8*(test_acbdl%4)))))|(dq_lcd_bdl_temp_reg_value<<(8*(test_acbdl%4))));

							{
								writel(((acbdlr_x_reg_org)&(~(0xff<<(8*(test_acbdl%4)))))|(dq_lcd_bdl_temp_reg_value<<(8*(test_acbdl%4))),reg_add);

							}
							temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

							if (temp_test_error)
							{
								//printf("\nwdqd left edge detect \n");
								dq_lcd_bdl_temp_reg_value--;
								break;
							}
						}
						printf("\n right edge detect ,reg==0x%08x\n",(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj));
						printf("\n org==0x%08x,right edge==0x%08x,value==0x%08x\n ",((acbdlr_x_reg_org>>(8*(test_acbdl%4)))&0xff),dq_lcd_bdl_temp_reg_value,
								((acbdlr_x_reg_org)&(~(0xff<<(8*(test_acbdl%4)))))|(dq_lcd_bdl_temp_reg_value<<(8*(test_acbdl%4))));

						{acbdlr_x_reg_setup_max=dq_lcd_bdl_temp_reg_value;}

						dq_lcd_bdl_temp_reg_value=0;
						//writel(((acbdlr_x_reg_org)&(~(0xff<<(8*(test_acbdl%4)))))|(dq_lcd_bdl_temp_reg_value<<(8*(test_acbdl%4))),reg_add);
						writel(((acbdlr_x_reg_org)),reg_add);
						//test_ac_setup_hold=1;
						{
							printf("\ntest_acbdl %08x | ac_setup_hold==0x%08x acmdlr==0x%08x  ddl_100step_ps==%08d\n",test_acbdl,test_ac_setup_hold,
									readl(DDR0_PUB_ACMDLR0+reg_base_adj),ddl_100step_ps);
							printf("\nacbdlr0_reg_org==0x%08x  |  acbdlr_x_reg_org==0x%08x\n ",acbdlr0_reg_org,acbdlr_x_reg_org);
							printf("acbdlr_x_reg_setup_max 0x%08x  \
									setup time==0x%08x, %08d ps \n ",
									acbdlr_x_reg_setup_max,(acbdlr_x_reg_setup_max-
										((acbdlr_x_reg_org>>(8*(test_acbdl%4)))&0xff)),((acbdlr_x_reg_setup_max-
											((acbdlr_x_reg_org>>(8*(test_acbdl%4)))&0xff)) *ddl_100step_ps)/100
								  );
							acbdlr0_9_reg_setup_max[test_acbdl]=(acbdlr_x_reg_setup_max-
									((acbdlr_x_reg_org>>(8*(test_acbdl%4)))&0xff));
							acbdlr0_9_reg_setup_time[test_acbdl]=((acbdlr_x_reg_setup_max-
										((acbdlr_x_reg_org>>(8*(test_acbdl%4)))&0xff)) *ddl_100step_ps)/100;
							for ((temp_count=0);(temp_count<10);(temp_count++))
							{
								writel(((acbdlr0_9_reg_org[temp_count])),(DDR0_PUB_ACBDLR0+(temp_count<<2)+reg_base_adj));

							};

						}

					}

					if (test_ac_setup_hold == 1)
					{
						printf("\ntest_ac_hold 1\n ");
						acbdlr0_reg_org=readl(DDR0_PUB_ACBDLR0+reg_base_adj);
						acbdlr_x_reg_org=readl(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj);
						printf("\ntest_acbdl %08x | ac_setup_hold==0x%08x\n ",test_acbdl,test_ac_setup_hold);
						printf("\nacbdlr0_reg_org==0x%08x  |  acbdlr_x_reg_org==0x%08x\n ",acbdlr0_reg_org,acbdlr_x_reg_org);


						printf("\nacbdlr0_reg==0x%08x  |  acbdlr_x_reg==0x%08x\n ",
								readl(DDR0_PUB_ACBDLR0+reg_base_adj),readl(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj));

						reg_add=(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj);
						dq_lcd_bdl_temp_reg_value=readl(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj);
						dq_lcd_bdl_temp_reg_value=((dq_lcd_bdl_temp_reg_value>>(8*(test_acbdl%4)))&0xff);
						while (dq_lcd_bdl_temp_reg_value>0)
						{
							temp_test_error=0;
							dq_lcd_bdl_temp_reg_value--;
							printf("\n reg==0x%08x, left temp==0x%08x\n ,value==0x%08x ",reg_add,dq_lcd_bdl_temp_reg_value,
									((acbdlr_x_reg_org)&(~(0xff<<(8*(test_acbdl%4)))))|(dq_lcd_bdl_temp_reg_value<<(8*(test_acbdl%4))));

							{
								writel(((acbdlr_x_reg_org)&(~(0xff<<(8*(test_acbdl%4)))))|(dq_lcd_bdl_temp_reg_value<<(8*(test_acbdl%4))),reg_add);

							}
							temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

							if (temp_test_error)
							{
								//printf("\nwdqd left edge detect \n");
								dq_lcd_bdl_temp_reg_value++;
								break;
							}
						}
						printf("\n left edge detect ,reg==0x%08x\n",(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj));
						printf("\n org==0x%08x,left edge==0x%08x\n ",((acbdlr_x_reg_org>>(8*(test_acbdl%4)))&0xff),dq_lcd_bdl_temp_reg_value);

						{acbdlr_x_reg_hold_min=dq_lcd_bdl_temp_reg_value;}


						//test_ac_setup_hold=1;
						//writel(acbdlr0_reg_org,(DDR0_PUB_ACBDLR0+reg_base_adj));
						writel(acbdlr_x_reg_org,(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj));
						//dq_lcd_bdl_temp_reg_value=0;
						// writel(((acbdlr_x_reg_org)&(~(0xff<<(8*(test_acbdl%4)))))|(dq_lcd_bdl_temp_reg_value<<(8*(test_acbdl%4))),reg_add);
						{


							printf("\ntest_acbdl %08x | ac_setup_hold==0x%08x acmdlr==0x%08x  ddl_100step_ps==%08d\n",test_acbdl,test_ac_setup_hold,
									readl(DDR0_PUB_ACMDLR0+reg_base_adj),ddl_100step_ps);
							printf("\nacbdlr0_reg_org==0x%08x  |  acbdlr_x_reg_org==0x%08x\n ",acbdlr0_reg_org,acbdlr_x_reg_org);
							printf("acbdlr_x_reg_hold_min==0x%08x \
									holdup time==0x%08x, %08d ps\n ",
									acbdlr_x_reg_hold_min,
									(((acbdlr_x_reg_org>>(8*(test_acbdl%4)))&0xff)-acbdlr_x_reg_hold_min),
									((((acbdlr_x_reg_org>>(8*(test_acbdl%4)))&0xff)-acbdlr_x_reg_hold_min)*ddl_100step_ps)/100);

						}
						acbdlr0_9_reg_hold_max[test_acbdl]=(((acbdlr_x_reg_org>>(8*(test_acbdl%4)))&0xff)-acbdlr_x_reg_hold_min);
						acbdlr0_9_reg_hold_time[test_acbdl]=((((acbdlr_x_reg_org>>(8*(test_acbdl%4)))&0xff)-acbdlr_x_reg_hold_min)*ddl_100step_ps)/100;

						for ((temp_count=0);(temp_count<10);(temp_count++))
						{
							writel(((acbdlr0_9_reg_org[temp_count])),(DDR0_PUB_ACBDLR0+(temp_count<<2)+reg_base_adj));

						};

					}

					if (test_ac_setup_hold == 2)
					{
						printf("\ntest_ac_hold 2 method\n ");
						acbdlr0_reg_org=readl(DDR0_PUB_ACBDLR0+reg_base_adj);
						acbdlr_x_reg_org=readl(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj);
						printf("\ntest_acbdl %08x | ac_setup_hold==0x%08x\n ",test_acbdl,test_ac_setup_hold);
						printf("\nacbdlr0_reg_org==0x%08x  |  acbdlr_x_reg_org==0x%08x\n ",acbdlr0_reg_org,acbdlr_x_reg_org);


						printf("\nacbdlr0_reg==0x%08x  |  acbdlr_x_reg==0x%08x\n ",
								readl(DDR0_PUB_ACBDLR0+reg_base_adj),readl(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj));

						reg_add=(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj);
						//dq_lcd_bdl_temp_reg_value=readl(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj);
						//dq_lcd_bdl_temp_reg_value=((dq_lcd_bdl_temp_reg_value>>(8*(test_acbdl%4)))&0xff);
						dq_lcd_bdl_temp_reg_value=(readl(DDR0_PUB_ACBDLR0+reg_base_adj)&0xff);
						while (dq_lcd_bdl_temp_reg_value<0x3f)
						{
							temp_test_error=0;
							dq_lcd_bdl_temp_reg_value++;
							printf("\n reg==0x%08x, right temp==0x%08x,value==0x%08x\n ",(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj),dq_lcd_bdl_temp_reg_value,
									((dq_lcd_bdl_temp_reg_value|(dq_lcd_bdl_temp_reg_value<<(8))|(dq_lcd_bdl_temp_reg_value<<(16))
									  |(dq_lcd_bdl_temp_reg_value<<(24)))&(~(0xff<<(8*(test_acbdl%4)))))|(acbdlr_x_reg_org&((0xff<<(8*(test_acbdl%4))))));
							/*
							   {
							   for ((temp_count=0);(temp_count<10);(temp_count++))
							   {
							   writel((dq_lcd_bdl_temp_reg_value|(dq_lcd_bdl_temp_reg_value<<(8))|(dq_lcd_bdl_temp_reg_value<<(16))
							   |(dq_lcd_bdl_temp_reg_value<<(24))),(DDR0_PUB_ACBDLR0+(temp_count<<2)+reg_base_adj));
							   };

							   writel(((dq_lcd_bdl_temp_reg_value|(dq_lcd_bdl_temp_reg_value<<(8))|(dq_lcd_bdl_temp_reg_value<<(16))
							   |(dq_lcd_bdl_temp_reg_value<<(24)))&(~(0xff<<(8*(test_acbdl%4)))))|(acbdlr_x_reg_org&((0xff<<(8*(test_acbdl%4))))),
							   (((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj));

							   }
							   */

							{
								for ((temp_count=0);(temp_count<40);(temp_count++))
								{if(temp_count==(test_acbdl))
									{
										temp_reg_value[temp_count]=((readl(DDR0_PUB_ACBDLR0+(((temp_count)>>2)<<2)+
														reg_base_adj))>>(8*(temp_count%4)))&0xff;
									}else
									{
										temp_reg_value[temp_count]=(((readl(DDR0_PUB_ACBDLR0+(((temp_count)>>2)<<2)+
															reg_base_adj))>>(8*(temp_count%4)))&0xff)+1;
									}
									temp_reg_value[temp_count]=((temp_reg_value[temp_count]>ACBDLR_MAX)?(ACBDLR_MAX):(temp_reg_value[temp_count]));

								};
								for ((temp_count=0);(temp_count<40);(temp_count++))
								{
									writel((((temp_reg_value[(temp_count)])|((temp_reg_value[temp_count+1])<<(8))|(((temp_reg_value[temp_count+2])<<(16)))
													|((temp_reg_value[temp_count+3])<<(24)))),
											(DDR0_PUB_ACBDLR0+(((temp_count)>>2)<<2)+
											 reg_base_adj));
									temp_count=temp_count+3;
								};
								printf("\n reg_bdlr_ck==0x%08x,right temp==0x%08x\n,ck_value==0x%08x",(DDR0_PUB_ACBDLR0+
											reg_base_adj),(dq_lcd_bdl_temp_reg_value),
										(readl(DDR0_PUB_ACBDLR0+
											   reg_base_adj)));
								printf("\n reg_bdlr_x==0x%08x,right temp==0x%08x\n,x_value==0x%08x",(DDR0_PUB_ACBDLR0+(((test_acbdl)>>2)<<2)+
											reg_base_adj),(dq_lcd_bdl_temp_reg_value),
										(readl(DDR0_PUB_ACBDLR0+(((test_acbdl)>>2)<<2)+
											   reg_base_adj)));

							}



							temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

							if (temp_test_error)
							{
								//printf("\nwdqd left edge detect \n");
								dq_lcd_bdl_temp_reg_value--;
								break;
							}
						}
						printf("\n right edge detect ,reg==0x%08x\n",(((test_acbdl>>2)<<2)+DDR0_PUB_ACBDLR0+reg_base_adj));
						printf("\norg==0x%08x, right edge==0x%08x\n ",acbdlr0_reg_org&0xff,dq_lcd_bdl_temp_reg_value);

						{acbdlr_x_reg_hold_min=dq_lcd_bdl_temp_reg_value;}


						//test_ac_setup_hold=1;
						dq_lcd_bdl_temp_reg_value=0;

						{


							printf("\ntest_acbdl %08x | ac_setup_hold==0x%08x acmdlr==0x%08x  ddl_100step_ps==%08d\n",test_acbdl,test_ac_setup_hold,
									readl(DDR0_PUB_ACMDLR0+reg_base_adj),ddl_100step_ps);
							printf("\nacbdlr0_reg_org==0x%08x  |  acbdlr_x_reg_org==0x%08x\n ",acbdlr0_reg_org,acbdlr_x_reg_org);
							printf("acbdlr_x_reg_hold_max==0x%08x \
									holdup time==0x%08x, %08d ps\n ",
									acbdlr_x_reg_hold_min,
									((acbdlr_x_reg_hold_min-(acbdlr0_reg_org&0xff))),((acbdlr_x_reg_hold_min-(acbdlr0_reg_org&0xff))*ddl_100step_ps)/100);

						}
						acbdlr0_9_reg_hold_max[test_acbdl]=((acbdlr_x_reg_hold_min-(acbdlr0_reg_org&0xff)));
						acbdlr0_9_reg_hold_time[test_acbdl]=((acbdlr_x_reg_hold_min-(acbdlr0_reg_org&0xff))*ddl_100step_ps)/100;
						for ((temp_count=0);(temp_count<10);(temp_count++))
						{
							writel(((acbdlr0_9_reg_org[temp_count])),(DDR0_PUB_ACBDLR0+(temp_count<<2)+reg_base_adj));

						};

					}
				}
			}

		}

		//  ddl_100step_ps=((100*1000*1000)/(2*global_ddr_clk))/((((readl(DDR0_PUB_ACMDLR0+reg_base_adj)))>>16)&0xff);



		printf("\nddl_100step_ps== %08d,0_5cycle_ps== %08d\n", ddl_100step_ps,((1000*1000)/(2*global_ddr_clk)));

		printf("\nresume  ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
		writel((readl(DDR0_PUB_REG_BASE+4))&(~(1<<29)),(DDR0_PUB_REG_BASE+4));
		printf("\n resume ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));

		return dq_lcd_bdl_temp_reg_value;

usage:
		cmd_usage(cmdtp);
		return 1;

	}
}

U_BOOT_CMD(
	ddr_test_ac_bit_setup_hold_window,	6,	1,	do_ddr_test_ac_bit_setup_hold_window,
	"DDR test ac bit margin function",
	"do_ddr_test_ac_bit_setup_hold_window a 0 0x8000000 0 c or do_ddr_test_ac_bit_setup_hold_window a 0 0x8000000 2 c  \n dcache off ? \n"
	//do_ddr_test_ac_bit_setup_hold_window a 0 0x8000000 setup/hold pin_id //c --- cs ,,8 --- ba0
);

int do_ddr_test_data_bit_setup_hold_window(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	///*
	printf("\nEnter test ddr data bit window  function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);
	unsigned int   ddl_100step_ps= 0;

	unsigned int   temp_test_error= 0;
	unsigned int   temp_count= 0;


	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_data_setup_hold=0;
	//unsigned int   testing_seed=0;
	// unsigned int   test_lane_step_rdqs_flag=0;
	unsigned int  open_vt=0;
	unsigned int  test_bdl=0;
	//   unsigned int   test_times=1;
	// unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   reg_bdlrck=0;
	unsigned int   reg_bdlr_x=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;


	unsigned int   bdlrck_reg_org=0;
	unsigned int   bdlr_x_reg_org=0;
	//   unsigned int   bdlr_x_reg_hold_min=0;
	//  unsigned int   acbdlr_x_reg_hold_min=0;
	unsigned int   bdlr_x_reg_setup_max=0;
	unsigned int   bdlr_x_reg_hold_max=0;
	//    unsigned int   acbdlr_x_reg_setup_max=0;
	//  unsigned int   dq_lcd_bdl_reg_left=0;
	//  unsigned int   dq_lcd_bdl_reg_right=0;


	//  unsigned int   dq_lcd_bdl_reg_left_min=0;
	//  unsigned int   dq_lcd_bdl_reg_right_min=0;

	unsigned int   dq_lcd_bdl_temp_reg_value=0;
	unsigned int   temp_reg_value[24];


	//  unsigned int   dq_lcd_bdl_temp_reg_lef_min_value;
	//     unsigned int   dq_lcd_bdl_temp_reg_rig_min_value;


	//   unsigned int   dq_lcd_bdl_temp_reg_lef;
	//   unsigned int   dq_lcd_bdl_temp_reg_rig;


	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;


	{
		if (argc == 2)
		{
			if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))

			{channel_a_en = 1;
			}
			else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))

			{channel_b_en = 1;
			}
			else
			{
				goto usage;
			}
		}
		if (argc > 2)
		{
			if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))

			{channel_a_en = 1;
			}
			if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

			{channel_b_en = 1;
			}
		}
		ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		if (argc >3) {
			ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
			if (*argv[3] == 0 || *endp != 0)
			{
				ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
			}

		}
		if (argc >4) {
			test_data_setup_hold = 0;
			test_data_setup_hold = simple_strtoull_ddr(argv[4], &endp, 16);
			if (*argv[4] == 0 || *endp != 0)
			{
				test_data_setup_hold = 0;
			}
			if   ((strcmp(argv[4], "l") == 0) || (strcmp(argv[4], "L") == 0))
			{
				test_data_setup_hold = 0;
			}
		}
		if (test_data_setup_hold >1)
			test_data_setup_hold = 1;
		if (argc >5) {

			test_bdl= simple_strtoull_ddr(argv[5], &endp, 0);
			if (*argv[5] == 0 || *endp != 0)
			{
				test_bdl = 0;
			}
			if (test_bdl>96)
				test_bdl =0;
		}
		if (argc >6) {

			open_vt= simple_strtoull_ddr(argv[6], &endp, 0);
			if (*argv[6] == 0 || *endp != 0)
			{
				open_vt = 0;
			}
			//if(open_vt)
			//	 open_vt =1;
		}
	}
	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_data_setup_hold== 0x%08x\n", test_data_setup_hold);
	printf("\ntest_bdl== 0x%08x\n", test_bdl);
	if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}



	//save and print org training dqs value
	if (channel_a_en || channel_b_en)
	{
		//dcache_disable();
		//serial_puts("\ndebug for ddrtest ,jiaxing disable dcache");

	}////save and print org training dqs value



	{
		////tune and save training dqs value
		if (channel_a_en || channel_b_en)

		{

			{

				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}

				printf("\nshould pause ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
				writel((readl(DDR0_PUB_REG_BASE+4))|(1<<29),(DDR0_PUB_REG_BASE+4));
				printf("\n pause ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
				for ((temp_count=0);(temp_count<28);(temp_count++))
				{
					//data_bdlr0_5_reg_org[temp_count]=(((readl(((temp_count>>2)<<2)+DDR0_PUB_DX0BDLR0+(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(temp_count/6)+reg_base_adj))
					//	>>(8*(test_bdl%4)))&0xff);
					data_bdlr0_5_reg_org[temp_count]=((readl(((temp_count%7)<<2)+DDR0_PUB_DX0BDLR0+(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(temp_count/7)+reg_base_adj))
							);
				};


				{
					ddl_100step_ps=((100*1000*1000)/(2*global_ddr_clk))/((((readl(DDR0_PUB_DX0MDLR0+reg_base_adj)))>>16)&0xff);
					printf("\nddl_100step_ps== %08d,0_5cycle_ps== %08d,0_5cycle==0x%08x\n", ddl_100step_ps,((1000*1000)/(2*global_ddr_clk)),
							((((readl(DDR0_PUB_DX0MDLR0+reg_base_adj)))>>16)&0xff));

					//reg_add=DDR0_PUB_DX0BDLR0+reg_base_adj;
					reg_bdlrck=((((test_bdl%24)>11)?(DDR0_PUB_DX0BDLR5):(DDR0_PUB_DX0BDLR2))+(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_bdl/24)+reg_base_adj);
					reg_bdlr_x= (DDR0_PUB_DX0BDLR0+((((test_bdl%24)>>2)<<2))+
							(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_bdl/24)+reg_base_adj);
					if ((test_bdl%24)>11)
					{reg_bdlr_x=reg_bdlr_x+4;//dxnbdlr345 register add have a gap with dxnbdlr012
					}
					bdlrck_reg_org=readl(reg_bdlrck)  ;
					bdlr_x_reg_org=readl(reg_bdlr_x);
					printf("\ntest_bdl %08x | data_setup_hold==0x%08x\n ",test_bdl,test_data_setup_hold);
					printf("\nbdlr0_reg_0x%08x_org==0x%08x  |  bdlr_x_reg_0x%08x_org==0x%08x\n ",reg_bdlrck,
							bdlrck_reg_org,reg_bdlr_x,bdlr_x_reg_org);
					if (test_data_setup_hold == 0)
					{
						printf("\ntest_data_setup\n ");



						reg_bdlrck=((((test_bdl%24)>11)?(DDR0_PUB_DX0BDLR5):(DDR0_PUB_DX0BDLR2))+(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_bdl/24)+reg_base_adj);
						reg_bdlr_x= (DDR0_PUB_DX0BDLR0+((((test_bdl%24)>>2)<<2))+
								(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_bdl/24)+reg_base_adj);
						if ((test_bdl%24)>11)
						{reg_bdlr_x=reg_bdlr_x+4;//dxnbdlr345 register add have a gap with dxnbdlr012
						}
						bdlrck_reg_org=readl(reg_bdlrck)  ;
						bdlr_x_reg_org=readl(reg_bdlr_x);

						dq_lcd_bdl_temp_reg_value=((bdlr_x_reg_org>>(8*(test_bdl%4)))&0xff);
						while (dq_lcd_bdl_temp_reg_value<ACBDLR_MAX)
						{
							temp_test_error=0;
							dq_lcd_bdl_temp_reg_value++;
							printf("\n reg_bdlr_x==0x%08x,right temp==0x%08x\n,value==0x%08x",reg_bdlr_x,dq_lcd_bdl_temp_reg_value,
									((bdlr_x_reg_org)&(~(0xff<<(8*(test_bdl%4)))))|(dq_lcd_bdl_temp_reg_value<<(8*(test_bdl%4))));

							{
								writel(((bdlr_x_reg_org)&(~(0xff<<(8*(test_bdl%4)))))|(dq_lcd_bdl_temp_reg_value<<(8*(test_bdl%4))),reg_bdlr_x);

							}
							temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

							if (temp_test_error)
							{
								//printf("\nwdqd left edge detect \n");
								dq_lcd_bdl_temp_reg_value--;
								break;
							}
						}
						printf("\n right edge detect ,reg==0x%08x\n",(reg_bdlr_x));
						printf("\n org==0x%08x,right edge==0x%08x,value==0x%08x\n ",((bdlr_x_reg_org>>(8*(test_bdl%4)))&0xff),dq_lcd_bdl_temp_reg_value,
								((bdlr_x_reg_org)&(~(0xff<<(8*(test_bdl%4)))))|(dq_lcd_bdl_temp_reg_value<<(8*(test_bdl%4))));

						{bdlr_x_reg_setup_max=dq_lcd_bdl_temp_reg_value;}

						dq_lcd_bdl_temp_reg_value=0;
						//writel(((acbdlr_x_reg_org)&(~(0xff<<(8*(test_acbdl%4)))))|(dq_lcd_bdl_temp_reg_value<<(8*(test_acbdl%4))),reg_add);
						writel(((bdlr_x_reg_org)),reg_bdlr_x);
						//test_ac_setup_hold=1;
						{
							printf("\ntest_bdl %08x | data_setup_hold==0x%08x mdlr==0x%08x  ddl_100step_ps==%08d\n",test_bdl,test_data_setup_hold,
									readl(DDR0_PUB_DX0MDLR0+reg_base_adj),ddl_100step_ps);
							printf("\nbdlr_ck_reg_org==0x%08x  |  bdlr_x_reg_org==0x%08x\n ",bdlrck_reg_org,bdlr_x_reg_org);
							printf("acbdlr_x_reg_setup_max 0x%08x  \
									setup time==0x%08x, %08d ps \n ",
									bdlr_x_reg_setup_max,(bdlr_x_reg_setup_max-
										((bdlr_x_reg_org>>(8*(test_bdl%4)))&0xff)),((bdlr_x_reg_setup_max-
											((bdlr_x_reg_org>>(8*(test_bdl%4)))&0xff)) *ddl_100step_ps)/100
								  );
							bdlr0_9_reg_setup_max[test_bdl]=(bdlr_x_reg_setup_max-
									((bdlr_x_reg_org>>(8*(test_bdl%4)))&0xff));
							bdlr0_9_reg_setup_time[test_bdl]=((bdlr_x_reg_setup_max-
										((bdlr_x_reg_org>>(8*(test_bdl%4)))&0xff)) *ddl_100step_ps)/100;
							for ((temp_count=0);(temp_count<28);(temp_count++))
							{
								writel(((data_bdlr0_5_reg_org[temp_count])),
										(((temp_count%7)<<2)+DDR0_PUB_DX0BDLR0+(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(temp_count/7)+reg_base_adj));

							};

						}

					}




					if (test_data_setup_hold)
					{
						printf("\ntest_data_hold\n ");



						reg_bdlrck=((((test_bdl%24)>11)?(DDR0_PUB_DX0BDLR5):(DDR0_PUB_DX0BDLR2))+(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_bdl/24)+reg_base_adj);
						reg_bdlr_x= (DDR0_PUB_DX0BDLR0+((((test_bdl%24)>>2)<<2))+
								(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_bdl/24)+reg_base_adj);
						if ((test_bdl%24)>11)
						{reg_bdlr_x=reg_bdlr_x+4;//dxnbdlr345 register add have a gap with dxnbdlr012
						}
						bdlrck_reg_org=readl(reg_bdlrck)  ;
						bdlr_x_reg_org=readl(reg_bdlr_x);

						dq_lcd_bdl_temp_reg_value=((bdlrck_reg_org>>(8*(1)))&0xff);
						while (dq_lcd_bdl_temp_reg_value<ACBDLR_MAX)
						{
							temp_test_error=0;
							dq_lcd_bdl_temp_reg_value++;
							printf("\n reg_bdlr_ck==0x%08x,right temp==0x%08x\n,value==0x%08x",reg_bdlrck,dq_lcd_bdl_temp_reg_value,
									(((bdlrck_reg_org)&(~(0xffff<<(8*(1)))))|(dq_lcd_bdl_temp_reg_value<<(8*(1)))|(dq_lcd_bdl_temp_reg_value<<(8*(2)))));

							{
								// writel((((bdlrck_reg_org)&(~(0xffff<<(8*(1)))))|(dq_lcd_bdl_temp_reg_value<<(8*(1)))|(dq_lcd_bdl_temp_reg_value<<(8*(2)))),reg_bdlrck);

							}



							if (((test_bdl%24)<12))
							{
								for ((temp_count=0);(temp_count<12);(temp_count++))
								{if(temp_count==(test_bdl%24))
									{
										temp_reg_value[temp_count]=((readl(DDR0_PUB_DX0BDLR0+(((test_bdl%24)>>2)<<2)+
														(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_bdl/24)+reg_base_adj))>>(8*(temp_count%4)))&0xff;
									}else
									{
										temp_reg_value[temp_count]=(((readl(DDR0_PUB_DX0BDLR0+(((test_bdl%24)>>2)<<2)+
															(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_bdl/24)+reg_base_adj))>>(8*(temp_count%4)))&0xff)+1;
									}
									temp_reg_value[temp_count]=((temp_reg_value[temp_count]>ACBDLR_MAX)?(ACBDLR_MAX):(temp_reg_value[temp_count]));

								};
								for ((temp_count=0);(temp_count<12);(temp_count++))
								{
									writel((((temp_reg_value[(temp_count)])|((temp_reg_value[temp_count+1])<<(8))|(((temp_reg_value[temp_count+2])<<(16)))
													|((temp_reg_value[temp_count+3])<<(24)))),
											(DDR0_PUB_DX0BDLR0+(((temp_count%24)>>2)<<2)+
											 (DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_bdl/24)+reg_base_adj));
									temp_count=temp_count+3;
								};
								printf("\n reg_bdlr_x==0x%08x,right temp==0x%08x\n,x_value==0x%08x",reg_bdlr_x,dq_lcd_bdl_temp_reg_value,
										(readl(DDR0_PUB_DX0BDLR0+(((test_bdl%24)>>2)<<2)+
											   (DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_bdl/24)+reg_base_adj)));

							}


							if (((test_bdl%24) >= 12))
							{
								for ((temp_count=12);(temp_count<24);(temp_count++))
								{if(temp_count==(test_bdl%24))
									{
										temp_reg_value[temp_count]=((readl(DDR0_PUB_DX0BDLR0+(((test_bdl%24)>>2)<<2)+4+
														(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_bdl/24)+reg_base_adj))>>(8*(temp_count%4)))&0xff;
									}else
									{
										temp_reg_value[temp_count]=(((readl(DDR0_PUB_DX0BDLR0+(((test_bdl%24)>>2)<<2)+4+
															(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_bdl/24)+reg_base_adj))>>(8*(temp_count%4)))&0xff)+1;
									}
									temp_reg_value[temp_count]=((temp_reg_value[temp_count]>ACBDLR_MAX)?(ACBDLR_MAX):(temp_reg_value[temp_count]));

								};
								for ((temp_count=12);(temp_count<24);(temp_count++))
								{
									writel((((temp_reg_value[(temp_count)])|((temp_reg_value[temp_count+1])<<(8))|(((temp_reg_value[temp_count+2])<<(16)))
													|((temp_reg_value[temp_count+3])<<(24)))),
											(DDR0_PUB_DX0BDLR0+(((temp_count%24)>>2)<<2)+4+
											 (DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_bdl/24)+reg_base_adj));
									temp_count=temp_count+3;
								};
								printf("\n reg_bdlr_x==0x%08x,right temp==0x%08x\n,x_value==0x%08x",reg_bdlr_x,dq_lcd_bdl_temp_reg_value,
										(readl(DDR0_PUB_DX0BDLR0+(((test_bdl%24)>>2)<<2)+4+
											   (DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(test_bdl/24)+reg_base_adj)));
							}

							temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

							if (temp_test_error)
							{
								//printf("\nwdqd left edge detect \n");
								dq_lcd_bdl_temp_reg_value--;
								break;
							}
						}

						printf("\n right edge detect ,reg==0x%08x\n",(reg_bdlrck));
						printf("\n org==0x%08x,right edge==0x%08x,value==0x%08x\n ",((bdlrck_reg_org>>(8*(1)))&0xff),dq_lcd_bdl_temp_reg_value,
								(((bdlrck_reg_org)&(~(0xffff<<(8*(1)))))|(dq_lcd_bdl_temp_reg_value<<(8*(1)))|(dq_lcd_bdl_temp_reg_value<<(8*(2)))));

						{bdlr_x_reg_hold_max=dq_lcd_bdl_temp_reg_value;}

						dq_lcd_bdl_temp_reg_value=0;
						//writel(((acbdlr_x_reg_org)&(~(0xff<<(8*(test_acbdl%4)))))|(dq_lcd_bdl_temp_reg_value<<(8*(test_acbdl%4))),reg_add);
						writel(((bdlrck_reg_org)),reg_bdlrck);
						//test_ac_setup_hold=1;
						{
							printf("\ntest_bdl %08x | data_setup_hold==0x%08x mdlr==0x%08x  ddl_100step_ps==%08d\n",test_bdl,test_data_setup_hold,
									readl(DDR0_PUB_DX0MDLR0+reg_base_adj),ddl_100step_ps);
							printf("\nbdlr_ck_reg_org==0x%08x  |  bdlr_x_reg_org==0x%08x\n ",bdlrck_reg_org,bdlr_x_reg_org);
							printf("acbdlr_x_reg_hold_max 0x%08x  \
									hold time==0x%08x, %08d ps \n ",
									bdlr_x_reg_hold_max,(bdlr_x_reg_hold_max-
										((bdlrck_reg_org>>(8*(1)))&0xff)),((bdlr_x_reg_hold_max-
											((bdlrck_reg_org>>(8*(1)))&0xff)) *ddl_100step_ps)/100
								  );
							bdlr0_9_reg_hold_max[test_bdl]=(bdlr_x_reg_hold_max-
									((bdlrck_reg_org>>(8*(1)))&0xff));
							bdlr0_9_reg_hold_time[test_bdl]=((bdlr_x_reg_hold_max-
										((bdlrck_reg_org>>(8*(1)))&0xff)) *ddl_100step_ps)/100;
							for ((temp_count=0);(temp_count<28);(temp_count++))
							{
								writel(((data_bdlr0_5_reg_org[temp_count])),
										(((temp_count%7)<<2)+DDR0_PUB_DX0BDLR0+(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(temp_count/7)+reg_base_adj));

							};

						}

					}





				}
			}

		}

		//  ddl_100step_ps=((100*1000*1000)/(2*global_ddr_clk))/((((readl(DDR0_PUB_ACMDLR0+reg_base_adj)))>>16)&0xff);



		printf("\nddl_100step_ps== %08d,0_5cycle_ps== %08d\n", ddl_100step_ps,((1000*1000)/(2*global_ddr_clk)));

		printf("\nresume  ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
		if (open_vt)
		{
			writel((readl(DDR0_PUB_REG_BASE+4))&(~(1<<29)),(DDR0_PUB_REG_BASE+4));
		}
		printf("\n resume ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));

		return dq_lcd_bdl_temp_reg_value;



	}

usage:
	cmd_usage(cmdtp);
	//*/
	return 1;
}
U_BOOT_CMD(
	ddr_test_data_bit_setup_hold_window,	6,	1,	do_ddr_test_data_bit_setup_hold_window,
	"DDR test data bit margin function",
	"ddr_test_data_bit_setup_hold_window a 0 0x8000000 0 3 or ddr_test_data_bit_setup_hold_window a 0 0x8000000 1 3  \n dcache off ? \n"
);
#endif

unsigned int
do_test_address_bus(volatile unsigned int * baseAddress, unsigned int nBytes)
{
	unsigned int addressMask = (nBytes/sizeof(unsigned int) - 1);
	unsigned int offset;
	unsigned int testOffset;

	unsigned int pattern	 = (unsigned int) 0xAAAAAAAA;
	unsigned int antipattern = (unsigned int) 0x55555555;

	unsigned int data1, data2;

	unsigned int ret = 0;

	/*
	 * Write the default pattern at each of the power-of-two offsets.
	 */
	for (offset = 1; (offset & addressMask) != 0; offset <<= 1)
	{
		baseAddress[offset] = pattern;
	}

	/*
	 * Check for address bits stuck high.
	 */
	testOffset = 0;
	baseAddress[testOffset] = antipattern;

	for (offset = 1; (offset & addressMask) != 0; offset <<= 1)
	{
		data1 = baseAddress[offset];
		data2 = baseAddress[offset];
		if (data1 != data2)
		{
			printf("  memTestAddressBus - read twice different[offset]: 0x%8x-0x%8x\n", data1, data2);
			ret = 1;
		}
		if (data1 != pattern)
		{
			printf("  memTestAddressBus - write[0x%8x]: 0x%8x, read[0x%8x]: 0x%8x\n", \
					offset, pattern, offset, data1);
			ret = 1;
			//return ((unsigned int) &baseAddress[offset]);
		}
	}

	baseAddress[testOffset] = pattern;

	/*
	 * Check for address bits stuck low or shorted.
	 */
	for (testOffset = 1; (testOffset & addressMask) != 0; testOffset <<= 1)
	{
		baseAddress[testOffset] = antipattern;

		if (baseAddress[0] != pattern)
		{
			printf("  memTestAddressBus2 - write baseAddress[0x%8x]: 0x%8x, read baseAddress[0]: 0x%8x\n", \
					testOffset, antipattern, baseAddress[0]);
			ret = 1;
			//return ((unsigned int) &baseAddress[testOffset]);
		}

		for (offset = 1; (offset & addressMask) != 0; offset <<= 1)
		{
			data1 = baseAddress[offset];
			if ((data1 != pattern) && (offset != testOffset))
			{
				printf("  memTestAddressBus3 - write baseAddress[0x%8x]: 0x%8x, read baseAddress[0x%8x]: 0x%8x\n", \
						testOffset, antipattern, testOffset, data1);
				ret = 1;
				//return ((unsigned int) &baseAddress[testOffset]);
			}
		}

		baseAddress[testOffset] = pattern;
	}


	for (offset = 0x1; (offset <=addressMask) ; offset++)
	{
		if (((~offset) <= addressMask) )
		{
			baseAddress[offset] = pattern;
			baseAddress[(~offset)] = antipattern;
		}
	}

	for (offset = 0x1; (offset <=addressMask); offset++)
	{
		if (((~offset) <= addressMask) )
		{
			if (baseAddress[offset] != pattern)
			{
				printf("  memTestAddressBus4 - write baseAddress[0x%8x]: 0x%8x, read baseAddress[0x%8x]: 0x%8x\n", \
						offset, pattern, offset, baseAddress[offset]);

				ret = 1;
				break;
			}

			if (baseAddress[(~offset)] != antipattern)
			{
				printf("  memTestAddressBus5 - write baseAddress[0x%8x]: 0x%8x, read baseAddress[0x%8x]: 0x%8x\n", \
						((~offset)), antipattern, ((~offset)), baseAddress[((~offset))]);
				ret = 1;
				break;
			}
		}
	}

	if (ret)
	{return (ret);
	}
	//unsigned int suq_value;
	for (offset = 0x1; (offset <=addressMask) ; offset++)
	{

		{
			pattern=((offset<<2)-offset);
			baseAddress[offset] = pattern;
			//baseAddress[(~offset)] = antipattern;
		}
	}

	for (offset = 0x1; (offset <=addressMask); offset++)
	{

		{
			pattern=((offset<<2)-offset);
			if (baseAddress[offset] != pattern)
			{
				printf("  memTestAddressBus6 - write baseAddress[0x%8x]: 0x%8x, read baseAddress[0x%8x]: 0x%8x\n", \
						offset,pattern, offset, baseAddress[offset]);
				ret = 1;
				break;
			}


		}
	}
	if (ret)
	{return (ret);
	}
	for (offset = 0x1; (offset <=addressMask) ; offset++)
	{

		{
			pattern=~((offset<<2)-offset);
			baseAddress[offset] = pattern;
			//baseAddress[(~offset)] = antipattern;
		}
	}

	for (offset = 0x1; (offset <=addressMask); offset++)
	{

		{
			pattern=~((offset<<2)-offset);
			if (baseAddress[offset] != pattern)
			{
				printf("  memTestAddressBus7 - write baseAddress[0x%8x]: 0x%8x, read baseAddress[0x%8x]: 0x%8x\n", \
						offset,pattern, offset, baseAddress[offset]);
				ret = 1;
				break;
			}


		}
	}


	return (ret);
}   /* memTestAddressBus() */

int ddr_test_s_add_cross_talk_pattern(int ddr_test_size)
{
	// unsigned int  start_addr = DDR_TEST_START_ADDR;
	unsigned int  start_addr=test_start_addr;
	error_outof_count_flag=1;
	error_count=0;
	///*
	printf("\rStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
	ddr_write((void *)(int_convter_p(start_addr)), ddr_test_size);
	printf("\rEnd write.                                 ");
	printf("\nStart 1st reading...                       ");
	ddr_read((void *)(int_convter_p(start_addr)), ddr_test_size);
	printf("\rEnd 1st read.                              ");
	printf("\rStart 2nd reading...                       ");
	ddr_read((void *)(int_convter_p(start_addr)), ddr_test_size);
	//*/
	/*
	   printf("\rStart writing pattern4 at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
	   ddr_write4((void *)(int_convter_p(start_addr)), ddr_test_size);
	   printf("\rEnd write.                                 ");
	   printf("\rStart 1st reading...                       ");
	   ddr_read4((void *)(int_convter_p(start_addr)), ddr_test_size);
	   printf("\rEnd 1st read.                              ");
	   printf("\rStart 2nd reading...                       ");
	   ddr_read4((void *)(int_convter_p(start_addr)), ddr_test_size);
	   */
	ddr_write_full((void *)(int_convter_p(start_addr)), ddr_test_size,0x0,0x3);
	printf("\rEnd write.                                 ");
	printf("\rStart 1st reading...                       ");
	ddr_read_full((void *)(int_convter_p(start_addr)), ddr_test_size,0,3);
	printf("\rEnd 1st read.                              ");
	printf("\rStart 2nd reading...                       ");
	ddr_read_full((void *)(int_convter_p(start_addr)), ddr_test_size,0,3);


	printf("\rStart writing add pattern                                 ");
	if (do_test_address_bus((void *)(int_convter_p(start_addr)), ddr_test_size))
		error_count++;


	/*
	   printf("\nStart *4 no cross talk pattern.                                 ");
	   printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
	   ddr_write_pattern4_no_cross_talk((void *)(int_convter_p(start_addr)), ddr_test_size);
	   printf("\nEnd write.                                 ");
	   printf("\nStart 1st reading...                       ");
	   ddr_read_pattern4_no_cross_talk((void *)(int_convter_p(start_addr)), ddr_test_size);
	   printf("\nEnd 1st read.                              ");
	   printf("\nStart 2nd reading...                       ");
	   ddr_read_pattern4_no_cross_talk((void *)(int_convter_p(start_addr)), ddr_test_size);

	//if(cross_talk_pattern_flag==1)
	{
	printf("\nStart *4  cross talk pattern p.                                 ");
	printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
	ddr_write_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), ddr_test_size);
	printf("\rEnd write.                                 ");
	printf("\rStart 1st reading...                       ");
	ddr_read_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), ddr_test_size);
	printf("\rEnd 1st read.                              ");
	printf("\rStart 2nd reading...                       ");
	ddr_read_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), ddr_test_size);
	printf("\rEnd 2nd read.                              ");

	//   printf("\rStart 3rd reading...                       ");
	//    ddr_read_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), ddr_test_size);
	//    printf("\rEnd 3rd read.                              \n");

	printf("\nStart *4  cross talk pattern n.                                 ");
	printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
	ddr_write_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), ddr_test_size);
	printf("\rEnd write.                                 ");
	printf("\rStart 1st reading...                       ");
	ddr_read_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), ddr_test_size);
	printf("\rEnd 1st read.                              ");
	printf("\rStart 2nd reading...                       ");
	ddr_read_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), ddr_test_size);
	printf("\rEnd 2nd read.                              ");
	//    printf("\rStart 3rd reading...                       ");
	//    ddr_read_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), ddr_test_size);
	//   printf("\rEnd 3rd read.                              \n");


	}

	{
	printf("\nStart *4  cross talk pattern p2.                                 ");
	printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
	ddr_write_pattern4_cross_talk_p2((void *)(int_convter_p(start_addr)), ddr_test_size);
	printf("\rEnd write.                                 ");
	printf("\rStart 1st reading...                       ");
	ddr_read_pattern4_cross_talk_p2((void *)(int_convter_p(start_addr)), ddr_test_size);
	printf("\rEnd 1st read.                              ");
	printf("\rStart 2nd reading...                       ");
	ddr_read_pattern4_cross_talk_p2((void *)(int_convter_p(start_addr)), ddr_test_size);
	printf("\rEnd 2nd read.                              ");

	//   printf("\rStart 3rd reading...                       ");
	//    ddr_read_pattern4_cross_talk_p((void *)(int_convter_p(start_addr)), ddr_test_size);
	//    printf("\rEnd 3rd read.                              \n");

	printf("\nStart *4  cross talk pattern n.                                 ");
	printf("\nStart writing at 0x%08x - 0x%08x...", start_addr, start_addr + ddr_test_size);
	ddr_write_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr)), ddr_test_size);
	printf("\rEnd write.                                 ");
	printf("\rStart 1st reading...                       ");
	ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr)), ddr_test_size);
	printf("\rEnd 1st read.                              ");
	printf("\rStart 2nd reading...                       ");
	ddr_read_pattern4_cross_talk_n2((void *)(int_convter_p(start_addr)), ddr_test_size);
	printf("\rEnd 2nd read.                              ");
	//    printf("\rStart 3rd reading...                       ");
	//    ddr_read_pattern4_cross_talk_n((void *)(int_convter_p(start_addr)), ddr_test_size);
	//   printf("\rEnd 3rd read.                              \n");


}
	*/
if (error_count)
	return 1;
	else
	return 0;
	}

int do_ddr_test_ac_windows_aclcdlr(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter Test ddr ac windows function\n");
	printf("\nset ddr  test test_start_addr==0x%08x \n",test_start_addr);
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);
	//  unsigned int   loop = 1;
	//unsigned int   temp_count_i = 1;
	//  unsigned int   temp_count_j= 1;
	//  unsigned int   temp_count_k= 1;
	unsigned int   temp_test_error= 0;


	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_loop=1;
	unsigned int   test_times=1;
	unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;
	unsigned int   testing_channel = 0;



#define  CHANNEL_A  0
#define  CHANNEL_B  1






#define  DDR_CORSS_TALK_TEST_SIZE   0x20000

	unsigned int  ac_mdlr_a_org=0;
	unsigned int  ac_mdlr_b_org=0;

	unsigned int  ac_lcdlr_a_org=0;
	unsigned int   ac_bdlr0_a_org=0;
	unsigned int  ac_lcdlr_b_org=0;
	unsigned int   ac_bdlr0_b_org=0;
	unsigned int  ac_lcdlr_a_rig=0;
	unsigned int   ac_bdlr0_a_rig=0;
	unsigned int  ac_lcdlr_b_rig=0;
	unsigned int   ac_bdlr0_b_rig=0;
	unsigned int  ac_lcdlr_a_lef=0;
	unsigned int   ac_bdlr0_a_lef=0;
	unsigned int  ac_lcdlr_b_lef=0;
	unsigned int   ac_bdlr0_b_lef=0;

	unsigned int  ac_lcdlr_a_rig_min=0;
	unsigned int   ac_bdlr0_a_rig_min=0;
	unsigned int  ac_lcdlr_b_rig_min=0;
	unsigned int   ac_bdlr0_b_rig_min=0;
	unsigned int  ac_lcdlr_a_lef_min=0;
	unsigned int   ac_bdlr0_a_lef_min=0;
	unsigned int  ac_lcdlr_b_lef_min=0;
	unsigned int   ac_bdlr0_b_lef_min=0;
	unsigned int  ac_lcdlr_temp=0;
	unsigned int   ac_bdlr0_temp=0;



	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;

	//#define DDR_TEST_ACLCDLR


	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))

		{channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))

		{channel_b_en = 1;
		}
		else
		{
			goto usage;
		}
	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))

		{channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

		{channel_b_en = 1;
		}
	}
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}

	}
	if (argc >4) {
		test_loop = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
		{
			test_loop = 1;
		}
		if   ((strcmp(argv[4], "l") == 0) || (strcmp(argv[4], "L") == 0))
		{
			test_loop = 100000;
		}
	}
	unsigned int   test_min_max=0;
	if (argc >5) {

		test_min_max = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
		{
			test_min_max = 0;
		}
		else
			test_min_max=1;

	}


	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_loop== 0x%08x\n", test_loop);
	printf("\ntest_min_max== 0x%08x\n", test_min_max);
	if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}


	//save and print org training dqs value
	if (channel_a_en || channel_b_en)
	{


		//dcache_disable();
		//serial_puts("\ndebug for ddrtest ,jiaxing disable dcache");

		{
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{
				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
						reg_add=DDR0_PUB_ACMDLR+reg_base_adj;



					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;

						reg_add=DDR0_PUB_ACMDLR+reg_base_adj;



					}
				}

				reg_add=DDR0_PUB_ACMDLR+reg_base_adj;

				printf("\ntest A channel AC110\n");
				if (reg_base_adj == CHANNEL_A_REG_BASE)
				{
					printf("\ntest A channel 0x%08x\n",reg_add);
					ac_mdlr_a_org=(unsigned int )(readl((unsigned int )reg_add));//readl(reg_add);//0xc8836000
					ac_lcdlr_a_org=(unsigned int )(readl((unsigned int )(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR)));//readl(reg_add+4);
					ac_bdlr0_a_org=(unsigned int )(readl((unsigned int )(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR)));//readl(reg_add+8);
					printf("\ntest A channel AC113\n");
					printf("\n ac_mdlr_org  0x%08x reg== 0x%08x\n",(reg_add), ac_mdlr_a_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_a_org);
					printf("\n ac_bdlr0_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_a_org);
				}
				if (reg_base_adj == CHANNEL_B_REG_BASE)
				{
					printf("\ntest A channel AC112\n");
					ac_mdlr_b_org=readl(reg_add);
					ac_lcdlr_b_org=readl(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR);
					ac_bdlr0_b_org=readl(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR);
					printf("\n ac_mdlr_org  0x%08x reg== 0x%08x\n",(reg_add), ac_mdlr_b_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_b_org);
					printf("\n ac_bdlr0_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_b_org);
				}


			}

		}

	}////save and print org training  value


	for (test_times=0;(test_times<test_loop);(test_times++))
	{
		////tune and save training dqs value
		if (channel_a_en || channel_b_en)

		{
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{

				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;
					}
				}

				if (reg_base_adj == CHANNEL_A_REG_BASE)
				{
					printf("\ntest A channel AC\n");
				}
				else
				{
					printf("\ntest B channel AC\n");
				}

				{
					{
						//#ifdef DDR_TEST_ACLCDLR

						reg_add=DDR0_PUB_ACLCDLR+reg_base_adj;

						ac_lcdlr_temp=readl(reg_add);

						while (ac_lcdlr_temp>0)
						{
							if(test_min_max)
							{break;
							}
							temp_test_error=0;
							ac_lcdlr_temp--;

							printf("\nlcdlr test value==0x%08x\n ",ac_lcdlr_temp);
							writel(ac_lcdlr_temp,(reg_add));
#ifdef DDR_LCDLR_CK_USE_FAST_PATTERN
							temp_test_error=ddr_test_s_add_cross_talk_pattern(ddr_test_size);
#else
							temp_test_error= ddr_test_s_add_cross_talk_pattern(ddr_test_size);
							temp_test_error= temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
#endif
							if (temp_test_error)
							{
								//printf("\nwdqd left edge detect \n");
								ac_lcdlr_temp++;
								break;
							}
						}

						printf("\nlcdlr left edge detect \n");
						printf("\nlcdlr left edge==0x%08x\n ",ac_lcdlr_temp);
						if (reg_base_adj == CHANNEL_A_REG_BASE)
						{
							ac_lcdlr_a_lef=ac_lcdlr_temp;
							ac_lcdlr_temp=ac_lcdlr_a_org;
						}
						else
						{
							ac_lcdlr_b_lef=ac_lcdlr_temp;
							ac_lcdlr_temp=ac_lcdlr_b_org;

						}
						writel(ac_lcdlr_temp,(reg_add));

						while (ac_lcdlr_temp<ACLCDLR_MAX)
						{
							temp_test_error=0;
							ac_lcdlr_temp++;
							printf("\nlcdlr test value==0x%08x\n ",ac_lcdlr_temp);
							writel(ac_lcdlr_temp,(reg_add));
#ifdef DDR_LCDLR_CK_USE_FAST_PATTERN
							temp_test_error=ddr_test_s_add_cross_talk_pattern(ddr_test_size);
#else
							temp_test_error= ddr_test_s_add_cross_talk_pattern(ddr_test_size);
							temp_test_error= temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
#endif
							if (temp_test_error)
							{
								//printf("\nlcdlr right edge detect \n");
								ac_lcdlr_temp--;
								break;
							}
						}
						printf("\nlcdlrright edge detect \n");
						printf("\nlcdlr right edge==0x%08x\n ",ac_lcdlr_temp);



						if (reg_base_adj == CHANNEL_A_REG_BASE)
						{
							ac_lcdlr_a_rig=ac_lcdlr_temp;
							ac_lcdlr_temp=ac_lcdlr_a_org;
						}
						else
						{
							ac_lcdlr_b_rig=ac_lcdlr_temp;
							ac_lcdlr_temp=ac_lcdlr_b_org;

						}
						writel(ac_lcdlr_temp,(reg_add));



						//#endif

						{
							reg_add=DDR0_PUB_ACBDLR0+reg_base_adj;

							ac_bdlr0_temp=readl(reg_add);
							while (ac_bdlr0_temp>0)
							{
								if(test_min_max)
								{break;
								}
								temp_test_error=0;
								ac_bdlr0_temp--;
								printf("\nbdlr0 test value==0x%08x\n ",ac_bdlr0_temp);
								writel(ac_bdlr0_temp,(reg_add));
#ifdef DDR_LCDLR_CK_USE_FAST_PATTERN
								temp_test_error=ddr_test_s_add_cross_talk_pattern(ddr_test_size);
#else
								temp_test_error= ddr_test_s_add_cross_talk_pattern(ddr_test_size);
								temp_test_error= temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
#endif
								if (temp_test_error)
								{
									//printf("\nwdqd left edge detect \n");
									ac_bdlr0_temp++;
									break;
								}
							}
							printf("\nacbdlr0 left edge detect \n");
							printf("\nacbdlr0 left edge==0x%08x\n ",ac_bdlr0_temp);

							if (reg_base_adj == CHANNEL_A_REG_BASE)
							{
								ac_bdlr0_a_lef=ac_bdlr0_temp;
								ac_bdlr0_temp=ac_bdlr0_a_org;
							}
							else
							{
								ac_bdlr0_b_lef=ac_bdlr0_temp;
								ac_bdlr0_temp=ac_bdlr0_b_org;

							}

							writel(ac_bdlr0_temp,(reg_add));

							while (ac_bdlr0_temp<ACBDLR_MAX)
							{
								temp_test_error=0;
								ac_bdlr0_temp++;
								printf("\nbdlr0 test value==0x%08x\n ",ac_bdlr0_temp);
								writel(ac_bdlr0_temp,(reg_add));
#ifdef DDR_LCDLR_CK_USE_FAST_PATTERN
								temp_test_error=ddr_test_s_add_cross_talk_pattern(ddr_test_size);
#else
								temp_test_error= ddr_test_s_add_cross_talk_pattern(ddr_test_size);
								temp_test_error= temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
#endif
								if (temp_test_error)
								{
									//printf("\nacbdlr0 right edge detect \n");
									ac_bdlr0_temp--;
									break;
								}
							}
							printf("\nacbdlr0 right edge detect \n");
							printf("\nacbdlr0 right edge==0x%08x\n ",ac_bdlr0_temp);

							if (reg_base_adj == CHANNEL_A_REG_BASE)
							{
								ac_bdlr0_a_rig=ac_bdlr0_temp;
								ac_bdlr0_temp=ac_bdlr0_a_org;
							}
							else
							{
								ac_bdlr0_b_rig=ac_bdlr0_temp;
								ac_bdlr0_temp=ac_bdlr0_b_org;

							}

							writel(ac_bdlr0_temp,(reg_add));

						}
					}

				}
			}

			////tune and save training dqs value




			////calculate and print  dqs value
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{
				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;
					}
				}
				reg_add=DDR0_PUB_ACMDLR+reg_base_adj;

				if (reg_base_adj == CHANNEL_A_REG_BASE)
				{
					if (test_times)
					{
						if (ac_lcdlr_a_lef>ac_lcdlr_a_lef_min)
							ac_lcdlr_a_lef_min=ac_lcdlr_a_lef;

						if (ac_lcdlr_a_rig<ac_lcdlr_a_rig_min)
							ac_lcdlr_a_rig_min=ac_lcdlr_a_rig;

						if (ac_bdlr0_a_lef>ac_bdlr0_a_lef_min)
							ac_bdlr0_a_lef_min=ac_bdlr0_a_lef;

						if (ac_bdlr0_a_rig<ac_bdlr0_a_rig_min)
							ac_bdlr0_a_rig_min=ac_bdlr0_a_rig;
					}
					else
					{
						ac_lcdlr_a_lef_min=ac_lcdlr_a_lef;
						ac_lcdlr_a_rig_min=ac_lcdlr_a_rig;
						ac_bdlr0_a_lef_min=ac_bdlr0_a_lef;
						ac_bdlr0_a_rig_min=ac_bdlr0_a_rig;
					}
					printf("\ntest A channel AC result\n");
					printf("\n ac_mdlr_org  0x%08x reg== 0x%08x\n",(reg_add), ac_mdlr_a_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_a_org);
					printf("\n ac_bdlr0_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_a_org);

					printf("\n ac_acmdlr_org  0x%08x reg== 0x%08x   lcdlr_lef   lcdlr_rig   lcdlr_lmin  lcdlr_rmin\n",(reg_add),ac_mdlr_a_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x  0x%08x  0x%08x  0x%08x  0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_a_org,ac_lcdlr_a_lef,ac_lcdlr_a_rig,ac_lcdlr_a_lef_min,ac_lcdlr_a_rig_min);
					printf("\n ac_bdlr0_a_org  0x%08x reg== 0x%08x  0x%08x  0x%08x  0x%08x  0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_a_org,ac_bdlr0_a_lef,ac_bdlr0_a_rig,ac_bdlr0_a_lef_min,ac_bdlr0_a_rig_min);



				}

				if (reg_base_adj == CHANNEL_B_REG_BASE)
				{
					if (test_times)
					{
						if (ac_lcdlr_b_lef>ac_lcdlr_b_lef_min)
							ac_lcdlr_b_lef_min=ac_lcdlr_b_lef;

						if (ac_lcdlr_b_rig<ac_lcdlr_b_rig_min)
							ac_lcdlr_b_rig_min=ac_lcdlr_b_rig;

						if (ac_bdlr0_b_lef>ac_bdlr0_b_lef_min)
							ac_bdlr0_b_lef_min=ac_bdlr0_b_lef;

						if (ac_bdlr0_b_rig<ac_bdlr0_b_rig_min)
							ac_bdlr0_b_rig_min=ac_bdlr0_b_rig;
					}
					else
					{
						ac_lcdlr_b_lef_min=ac_lcdlr_b_lef;
						ac_lcdlr_b_rig_min=ac_lcdlr_b_rig;
						ac_bdlr0_b_lef_min=ac_bdlr0_b_lef;
						ac_bdlr0_b_rig_min=ac_bdlr0_b_rig;
					}
					printf("\ntest B channel AC result\n");
					printf("\n ac_mdlr_org  0x%08x reg== 0x%08x\n",(reg_add), ac_mdlr_b_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_b_org);
					printf("\n ac_bdlr0_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_b_org);

					printf("\n ac_acmdlr_org  0x%08x reg== 0x%08x   lcdlr_lef   lcdlr_rig   lcdlr_lmin  lcdlr_rmin\n",(reg_add),ac_mdlr_b_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x  0x%08x  0x%08x  0x%08x  0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_b_org,ac_lcdlr_b_lef,ac_lcdlr_b_rig,ac_lcdlr_b_lef_min,ac_lcdlr_b_rig_min);
					printf("\n ac_bdlr0_a_org  0x%08x reg== 0x%08x  0x%08x  0x%08x  0x%08x  0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_b_org,ac_bdlr0_b_lef,ac_bdlr0_b_rig,ac_bdlr0_b_lef_min,ac_bdlr0_b_rig_min);



				}



			}


		}

	}




	return 0;

usage:
	cmd_usage(cmdtp);
	return 1;

}




U_BOOT_CMD(
	ddr_tune_ddr_ac_aclcdlr,	6,	1,	do_ddr_test_ac_windows_aclcdlr,
	"DDR tune dqs function",
	"ddr_tune_ddr_ac_aclcdlr a 0 0x8000000 3 or ddr_tune_ddr_ac_aclcdlr b 0 0x80000 5 or ddr_tune_ddr_ac_aclcdlr a b 0x80000 l\n dcache off ? \n"
);


int do_ddr_test_ac_windows_acbdlr_ck(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter Test ddr ac windows function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);
	//  unsigned int   loop = 1;
	//   unsigned int   temp_count_i = 1;
	//   unsigned int   temp_count_j= 1;
	//    unsigned int   temp_count_k= 1;
	unsigned int   temp_test_error= 0;


	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_loop=1;
	unsigned int   test_times=1;
	unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;
	unsigned int   testing_channel = 0;



#define  CHANNEL_A  0
#define  CHANNEL_B  1






#define  DDR_CORSS_TALK_TEST_SIZE   0x20000

	unsigned int  ac_mdlr_a_org=0;
	unsigned int  ac_mdlr_b_org=0;

	unsigned int  ac_lcdlr_a_org=0;
	unsigned int   ac_bdlr0_a_org=0;
	unsigned int  ac_lcdlr_b_org=0;
	unsigned int   ac_bdlr0_b_org=0;
	unsigned int  ac_lcdlr_a_rig=0;
	unsigned int   ac_bdlr0_a_rig=0;
	unsigned int  ac_lcdlr_b_rig=0;
	unsigned int   ac_bdlr0_b_rig=0;
	unsigned int  ac_lcdlr_a_lef=0;
	unsigned int   ac_bdlr0_a_lef=0;
	unsigned int  ac_lcdlr_b_lef=0;
	unsigned int   ac_bdlr0_b_lef=0;

	unsigned int  ac_lcdlr_a_rig_min=0;
	unsigned int   ac_bdlr0_a_rig_min=0;
	unsigned int  ac_lcdlr_b_rig_min=0;
	unsigned int   ac_bdlr0_b_rig_min=0;
	unsigned int  ac_lcdlr_a_lef_min=0;
	unsigned int   ac_bdlr0_a_lef_min=0;
	unsigned int  ac_lcdlr_b_lef_min=0;
	unsigned int   ac_bdlr0_b_lef_min=0;
	//   unsigned int  ac_lcdlr_temp;
	unsigned int   ac_bdlr0_temp=0;



	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;


	//#define DDR_TEST_ACLCDLR


	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))

		{channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))

		{channel_b_en = 1;
		}
		else
		{
			goto usage;
		}
	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))

		{channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

		{channel_b_en = 1;
		}
	}
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}

	}
	if (argc >4) {
		test_loop = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
		{
			test_loop = 1;
		}
		if   ((strcmp(argv[4], "l") == 0) || (strcmp(argv[4], "L") == 0))
		{
			test_loop = 100000;
		}
	}

	unsigned int   test_min_max=0;
	if (argc >5) {

		test_min_max = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
		{
			test_min_max = 0;
		}
		else
			test_min_max=1;

	}

	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_loop== 0x%08x\n", test_loop);
	printf("\ntest_min_max== 0x%08x\n", test_min_max);
	if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}


	//save and print org training dqs value
	if (channel_a_en || channel_b_en)
	{


		//dcache_disable();
		//serial_puts("\ndebug for ddrtest ,jiaxing disable dcache");

		{
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{
				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
						reg_add=DDR0_PUB_ACMDLR+reg_base_adj;



					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;

						reg_add=DDR0_PUB_ACMDLR+reg_base_adj;



					}
				}

				reg_add=DDR0_PUB_ACMDLR+reg_base_adj;


				if (reg_base_adj == CHANNEL_A_REG_BASE)
				{
					printf("\ntest A channel 0x%08x\n",reg_add);
					ac_mdlr_a_org=(unsigned int )(readl((unsigned int )reg_add));//readl(reg_add);//0xc8836000
					ac_lcdlr_a_org=(unsigned int )(readl((unsigned int )(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR)));//readl(reg_add+4);
					ac_bdlr0_a_org=(unsigned int )(readl((unsigned int )(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR)));//readl(reg_add+8);

					printf("\n ac_mdlr_org  0x%08x reg== 0x%08x\n",(reg_add), ac_mdlr_a_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_a_org);
					printf("\n ac_bdlr0_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_a_org);
				}
				if (reg_base_adj == CHANNEL_B_REG_BASE)
				{

					ac_mdlr_b_org=readl(reg_add);
					ac_lcdlr_b_org=readl(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR);
					ac_bdlr0_b_org=readl(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR);
					printf("\n ac_mdlr_org  0x%08x reg== 0x%08x\n",(reg_add), ac_mdlr_b_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_b_org);
					printf("\n ac_bdlr0_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_b_org);
				}


			}

		}

	}////save and print org training  value


	for (test_times=0;(test_times<test_loop);(test_times++))
	{
		////tune and save training dqs value
		if (channel_a_en || channel_b_en)

		{
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{

				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;
					}
				}

				if (reg_base_adj == CHANNEL_A_REG_BASE)
				{
					printf("\ntest A channel AC\n");
				}
				else
				{
					printf("\ntest B channel AC\n");
				}

				{
					{
#ifdef DDR_TEST_ACLCDLR

						reg_add=DDR0_PUB_ACLCDLR+reg_base_adj;

						ac_lcdlr_temp=readl(reg_add);

						while (ac_lcdlr_temp>0)
						{
							if(test_min_max)
							{break;
							}
							temp_test_error=0;
							ac_lcdlr_temp--;

							printf("\nlcdlr test value==0x%08x\n ",ac_lcdlr_temp);
							writel(ac_lcdlr_temp,(reg_add));
#ifdef DDR_LCDLR_CK_USE_FAST_PATTERN
							temp_test_error=ddr_test_s_add_cross_talk_pattern(ddr_test_size);
#else
							temp_test_error= ddr_test_s_add_cross_talk_pattern(ddr_test_size);
							temp_test_error= temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
#endif
							if (temp_test_error)
							{
								//printf("\nwdqd left edge detect \n");
								ac_lcdlr_temp++;
								break;
							}
						}

						printf("\nlcdlr left edge detect \n");
						printf("\nlcdlr left edge==0x%08x\n ",ac_lcdlr_temp);
						if (reg_base_adj == CHANNEL_A_REG_BASE)
						{
							ac_lcdlr_a_lef=ac_lcdlr_temp;
							ac_lcdlr_temp=ac_lcdlr_a_org;
						}
						else
						{
							ac_lcdlr_b_lef=ac_lcdlr_temp;
							ac_lcdlr_temp=ac_lcdlr_b_org;

						}
						writel(ac_lcdlr_temp,(reg_add));

						while (ac_lcdlr_temp<ACLCDLR_MAX)
						{
							temp_test_error=0;
							ac_lcdlr_temp++;
							printf("\nlcdlr test value==0x%08x\n ",ac_lcdlr_temp);
							writel(ac_lcdlr_temp,(reg_add));
#ifdef DDR_LCDLR_CK_USE_FAST_PATTERN
							temp_test_error=ddr_test_s_add_cross_talk_pattern(ddr_test_size);
#else
							temp_test_error= ddr_test_s_add_cross_talk_pattern(ddr_test_size);
							temp_test_error= temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
#endif
							if (temp_test_error)
							{
								//printf("\nlcdlr right edge detect \n");
								ac_lcdlr_temp--;
								break;
							}
						}
						printf("\nlcdlrright edge detect \n");
						printf("\nlcdlr right edge==0x%08x\n ",ac_lcdlr_temp);



						if (reg_base_adj == CHANNEL_A_REG_BASE)
						{
							ac_lcdlr_a_rig=ac_lcdlr_temp;
							ac_lcdlr_temp=ac_lcdlr_a_org;
						}
						else
						{
							ac_lcdlr_b_rig=ac_lcdlr_temp;
							ac_lcdlr_temp=ac_lcdlr_b_org;

						}
						writel(ac_lcdlr_temp,(reg_add));



#endif

						{
							reg_add=DDR0_PUB_ACBDLR0+reg_base_adj;

							ac_bdlr0_temp=readl(reg_add);
							while (ac_bdlr0_temp>0)
							{
								temp_test_error=0;
								ac_bdlr0_temp--;
								printf("\nbdlr0 test value==0x%08x\n ",ac_bdlr0_temp);
								writel(ac_bdlr0_temp,(reg_add));
#ifdef DDR_LCDLR_CK_USE_FAST_PATTERN
								temp_test_error=ddr_test_s_add_cross_talk_pattern(ddr_test_size);
#else
								temp_test_error= ddr_test_s_add_cross_talk_pattern(ddr_test_size);
								temp_test_error= temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
#endif
								if (temp_test_error)
								{
									//printf("\nwdqd left edge detect \n");
									ac_bdlr0_temp++;
									break;
								}
							}
							printf("\nacbdlr0 left edge detect \n");
							printf("\nacbdlr0 left edge==0x%08x\n ",ac_bdlr0_temp);

							if (reg_base_adj == CHANNEL_A_REG_BASE)
							{
								ac_bdlr0_a_lef=ac_bdlr0_temp;
								ac_bdlr0_temp=ac_bdlr0_a_org;
							}
							else
							{
								ac_bdlr0_b_lef=ac_bdlr0_temp;
								ac_bdlr0_temp=ac_bdlr0_b_org;

							}

							writel(ac_bdlr0_temp,(reg_add));

							while (ac_bdlr0_temp<ACBDLR_MAX)
							{
								temp_test_error=0;
								ac_bdlr0_temp++;
								printf("\nbdlr0 test value==0x%08x\n ",ac_bdlr0_temp);
								writel(ac_bdlr0_temp,(reg_add));
#ifdef DDR_LCDLR_CK_USE_FAST_PATTERN
								temp_test_error=ddr_test_s_add_cross_talk_pattern(ddr_test_size);
#else
								temp_test_error= ddr_test_s_add_cross_talk_pattern(ddr_test_size);
								temp_test_error= temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
#endif
								if (temp_test_error)
								{
									//printf("\nacbdlr0 right edge detect \n");
									ac_bdlr0_temp--;
									break;
								}
							}
							printf("\nacbdlr0 right edge detect \n");
							printf("\nacbdlr0 right edge==0x%08x\n ",ac_bdlr0_temp);

							if (reg_base_adj == CHANNEL_A_REG_BASE)
							{
								ac_bdlr0_a_rig=ac_bdlr0_temp;
								ac_bdlr0_temp=ac_bdlr0_a_org;
							}
							else
							{
								ac_bdlr0_b_rig=ac_bdlr0_temp;
								ac_bdlr0_temp=ac_bdlr0_b_org;

							}

							writel(ac_bdlr0_temp,(reg_add));

						}
					}

				}
			}

			////tune and save training dqs value




			////calculate and print  dqs value
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{
				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;
					}
				}
				reg_add=DDR0_PUB_ACMDLR+reg_base_adj;

				if (reg_base_adj == CHANNEL_A_REG_BASE)
				{
					if (test_times)
					{
						if (ac_lcdlr_a_lef>ac_lcdlr_a_lef_min)
							ac_lcdlr_a_lef_min=ac_lcdlr_a_lef;

						if (ac_lcdlr_a_rig<ac_lcdlr_a_rig_min)
							ac_lcdlr_a_rig_min=ac_lcdlr_a_rig;

						if (ac_bdlr0_a_lef>ac_bdlr0_a_lef_min)
							ac_bdlr0_a_lef_min=ac_bdlr0_a_lef;

						if (ac_bdlr0_a_rig<ac_bdlr0_a_rig_min)
							ac_bdlr0_a_rig_min=ac_bdlr0_a_rig;
					}
					else
					{
						ac_lcdlr_a_lef_min=ac_lcdlr_a_lef;
						ac_lcdlr_a_rig_min=ac_lcdlr_a_rig;
						ac_bdlr0_a_lef_min=ac_bdlr0_a_lef;
						ac_bdlr0_a_rig_min=ac_bdlr0_a_rig;
					}
					printf("\ntest A channel AC result\n");
					printf("\n ac_mdlr_org  0x%08x reg== 0x%08x\n",(reg_add), ac_mdlr_a_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_a_org);
					printf("\n ac_bdlr0_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_a_org);

					printf("\n ac_acmdlr_org  0x%08x reg== 0x%08x   lcdlr_lef   lcdlr_rig   lcdlr_lmin  lcdlr_rmin\n",(reg_add),ac_mdlr_a_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x  0x%08x  0x%08x  0x%08x  0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_a_org,ac_lcdlr_a_lef,ac_lcdlr_a_rig,ac_lcdlr_a_lef_min,ac_lcdlr_a_rig_min);
					printf("\n ac_bdlr0_a_org  0x%08x reg== 0x%08x  0x%08x  0x%08x  0x%08x  0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_a_org,ac_bdlr0_a_lef,ac_bdlr0_a_rig,ac_bdlr0_a_lef_min,ac_bdlr0_a_rig_min);



				}

				if (reg_base_adj == CHANNEL_B_REG_BASE)
				{
					if (test_times)
					{
						if (ac_lcdlr_b_lef>ac_lcdlr_b_lef_min)
							ac_lcdlr_b_lef_min=ac_lcdlr_b_lef;

						if (ac_lcdlr_b_rig<ac_lcdlr_b_rig_min)
							ac_lcdlr_b_rig_min=ac_lcdlr_b_rig;

						if (ac_bdlr0_b_lef>ac_bdlr0_b_lef_min)
							ac_bdlr0_b_lef_min=ac_bdlr0_b_lef;

						if (ac_bdlr0_b_rig<ac_bdlr0_b_rig_min)
							ac_bdlr0_b_rig_min=ac_bdlr0_b_rig;
					}
					else
					{
						ac_lcdlr_b_lef_min=ac_lcdlr_b_lef;
						ac_lcdlr_b_rig_min=ac_lcdlr_b_rig;
						ac_bdlr0_b_lef_min=ac_bdlr0_b_lef;
						ac_bdlr0_b_rig_min=ac_bdlr0_b_rig;
					}
					printf("\ntest B channel AC result\n");
					printf("\n ac_mdlr_org  0x%08x reg== 0x%08x\n",(reg_add), ac_mdlr_b_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_b_org);
					printf("\n ac_bdlr0_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_b_org);

					printf("\n ac_acmdlr_org  0x%08x reg== 0x%08x   lcdlr_lef   lcdlr_rig   lcdlr_lmin  lcdlr_rmin\n",(reg_add),ac_mdlr_b_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x  0x%08x  0x%08x  0x%08x  0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_b_org,ac_lcdlr_b_lef,ac_lcdlr_b_rig,ac_lcdlr_b_lef_min,ac_lcdlr_b_rig_min);
					printf("\n ac_bdlr0_a_org  0x%08x reg== 0x%08x  0x%08x  0x%08x  0x%08x  0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_b_org,ac_bdlr0_b_lef,ac_bdlr0_b_rig,ac_bdlr0_b_lef_min,ac_bdlr0_b_rig_min);




				}



			}


		}

	}




	return 0;

usage:
	cmd_usage(cmdtp);
	return 1;

}




U_BOOT_CMD(
	ddr_tune_ddr_ac_acbdlr_ck,	6,	1,	do_ddr_test_ac_windows_acbdlr_ck,
	"DDR tune dqs function",
	"ddr_tune_ddr_ac_acbdlr_ck a 0 0x8000000 3 or ddr_tune_ddr_ac_acbdlr_ck b 0 0x80000 5 or ddr_tune_ddr_ac_acbdlr_ck a b 0x80000 l\n dcache off ? \n"
);


int do_ddr_test_ac_bit_margin(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnterddr_test_ac_window function\n");
	unsigned int   channel_a_en = 0;
	//	   unsigned int   channel_b_en = 0;
	// unsigned int   reg_add=0;
	// unsigned int   reg_base_adj=0;

	unsigned int   lane_step= 0;
	unsigned int   reg_value= 0;
	unsigned int   test_ac_setup_hold= 0;
	//int argc2;
	//char     *  argv2[30];
	//  unsigned int  acbdlr0_9_reg_org[10];
	//   unsigned int  acbdlr0_9_reg_setup_max[40];
	//  unsigned int  acbdlr0_9_reg_hold_max[40];
	//     unsigned int  acbdlr0_9_reg_setup_time[40];
	// unsigned int  acbdlr0_9_reg_hold_time[40];

	char *endp;

	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))
		{
			channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))
		{//channel_b_en = 1;
		}
	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))
		{
			channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

		{//channel_b_en = 1;
		}
	}
	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}
	}
	//argc2=5;
	//for(i = 1;i<(argc);i++)
	{
		//argv2[i-1]=argv[i];
	}

	//argv2[0]=argv[1];
	//argv2[1]=argv[2];
	//argv2[2]=argv[3];
	char str[100];
	test_ac_setup_hold=0;
	if (channel_a_en)
	{

		//*(char     *)(argv2[0])="a";
		//	run_command("ddr_test_cmd 11 a 0 0x80000  ",0);
		printf("\ntest ac window  a\n");
		for ((lane_step=4);(lane_step<40);(lane_step++))
		{
			if (lane_step == 7)
			{lane_step=8;
			}
			if (lane_step == 12)
			{lane_step=16;
			}
			if (lane_step == 14)
			{lane_step=16;
			}
			if (lane_step == 18)
			{lane_step=20;
			}
			if (lane_step == 22)
			{lane_step=24;
			}
			//sprintf(argv2[3],"d%",( lane_step));
			//itoa_ddr_test(lane_step,(argv2[3]),10);
			//printf("\nargv2[%d]=%s\n",0,argv2[0]);
			//	printf("\nargv2[%d]=%s\n",3,argv2[3]);//a 0 0x8000000 0 c
			// reg_value=do_ddr_test_dqs_window_step((cmd_tbl_t * )cmdtp, (int) flag,( int) argc2, (argv2));
			sprintf(str,"ddr_test_ac_bit_setup_hold_window  a 0  0x%08x  %d  0x%08x",ddr_test_size,test_ac_setup_hold,( lane_step));
			printf("\nstr=%s\n",str);
			//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
			//printf("\nstr=%s\n",str);
			run_command(str,0);

			test_ac_setup_hold=2;
			sprintf(str,"ddr_test_ac_bit_setup_hold_window  a 0  0x%08x  %d  0x%08x",ddr_test_size,test_ac_setup_hold,( lane_step));
			printf("\nstr=%s\n",str);
			//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
			//printf("\nstr=%s\n",str);
			run_command(str,0);
			test_ac_setup_hold=0;

		}
	}
	if (channel_a_en)
	{
		for ((lane_step=0);(lane_step<10);(lane_step++))
		{
			printf("acbdlr0_9_reg_org[%d]0x%08x==0x%08x\n",	lane_step,(DDR0_PUB_ACBDLR0+(lane_step<<2)),acbdlr0_9_reg_org[lane_step]);

		};

		for ((lane_step=0);(lane_step<40);(lane_step++))
		{
			printf("\n a_ac_lane_0x%08x|setup_max 0x%08x  |hold_max 0x%08x |setup_time %08d ps ::|hold_time %08d ps  \n",
					lane_step,
					acbdlr0_9_reg_setup_max[lane_step],
					acbdlr0_9_reg_hold_max[lane_step],
					acbdlr0_9_reg_setup_time[lane_step],
					acbdlr0_9_reg_hold_time[lane_step]);

		}
	}
	return reg_value;
}

int do_ddr_test_data_bit_margin(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnterddr_test_data_window function\n");
	unsigned int   channel_a_en = 0;
	//	   unsigned int   channel_b_en = 0;
	// unsigned int   reg_add=0;
	// unsigned int   reg_base_adj=0;

	unsigned int   lane_step= 0;
	unsigned int   reg_value= 0;
	unsigned int   test_ac_setup_hold= 0;
	//int argc2;
	//char     *  argv2[30];
	//  unsigned int  acbdlr0_9_reg_org[10];
	//   unsigned int  acbdlr0_9_reg_setup_max[40];
	//  unsigned int  acbdlr0_9_reg_hold_max[40];
	//     unsigned int  acbdlr0_9_reg_setup_time[40];
	// unsigned int  acbdlr0_9_reg_hold_time[40];

	char *endp;

	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))

		{channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))

		{//channel_b_en = 1;
		}


	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))

		{channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

		{//channel_b_en = 1;
		}
	}
	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}
	}
	unsigned int   ddr_test_type=0;
	unsigned int   ddr_test_type_para1=0;
	unsigned int   ddr_test_type_para2=0;
	if (argc >4) {
		ddr_test_type = simple_strtoull_ddr(argv[4], &endp, 0);
		if (*argv[4] == 0 || *endp != 0)
		{
			ddr_test_type = 0;
		}
	}
	if (ddr_test_type) {
		if (argc >5) {
			ddr_test_type_para1 = simple_strtoull_ddr(argv[5], &endp, 0);
			if (*argv[5] == 0 || *endp != 0)
			{
				ddr_test_type_para1 = 0;
			}
		}
		if (argc >6) {
			ddr_test_type_para2 = simple_strtoull_ddr(argv[6], &endp, 0);
			if (*argv[6] == 0 || *endp != 0)
			{
				ddr_test_type_para2 = 96;
			}
		}
	}else
	{ ddr_test_type_para1 = 0;
		ddr_test_type_para2 = 96;
	}
	//argc2=5;
	//for(i = 1;i<(argc);i++)
	{
		//argv2[i-1]=argv[i];
	}

	//argv2[0]=argv[1];
	//argv2[1]=argv[2];
	//argv2[2]=argv[3];
	printf("\ntest data window ddr_test_type==0x%08x, ddr_test_type_para1==0x%08x,ddr_test_type_para2==0x%08x\n",
			ddr_test_type,ddr_test_type_para1,ddr_test_type_para2);
	char str[100];
	unsigned int   temp_count=0;
	test_ac_setup_hold=0;
	if (channel_a_en)
	{
		for ((temp_count=0);(temp_count<28);(temp_count++))
		{
			//data_bdlr0_5_reg_org[temp_count]=(((readl(((temp_count>>2)<<2)+DDR0_PUB_DX0BDLR0+(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(temp_count/6)+reg_base_adj))
			//	>>(8*(test_bdl%4)))&0xff);
			data_bdlr0_5_reg_org[temp_count]=((readl(((temp_count%7)<<2)+DDR0_PUB_DX0BDLR0+(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(temp_count/7)))
					);
		};

		//*(char     *)(argv2[0])="a";
		//	run_command("ddr_test_cmd 11 a 0 0x80000  ",0);
		printf("\ntest data window  a\n");
		for ((lane_step=ddr_test_type_para1);(lane_step<ddr_test_type_para2);(lane_step++))
		{
			if (lane_step == 9)
			{lane_step=12;
			}
			if (lane_step == 21)
			{lane_step=24;
			}
			if (lane_step == 33)
			{lane_step=36;
			}
			if (lane_step == 45)
			{lane_step=48;
			}
			if (lane_step == 33+24)
			{lane_step=36+24;
			}
			if (lane_step == 45+24)
			{lane_step=48+24;
			}
			if (lane_step == 33+48)
			{lane_step=36+48;
			}
			if (lane_step == 44+48)
			{lane_step=48+48;
			}

			//sprintf(argv2[3],"d%",( lane_step));
			//itoa_ddr_test(lane_step,(argv2[3]),10);
			//printf("\nargv2[%d]=%s\n",0,argv2[0]);
			//	printf("\nargv2[%d]=%s\n",3,argv2[3]);//a 0 0x8000000 0 c
			// reg_value=do_ddr_test_dqs_window_step((cmd_tbl_t * )cmdtp, (int) flag,( int) argc2, (argv2));
			sprintf(str,"ddr_test_data_bit_setup_hold_window  a 0  0x%08x  %d  0x%08x",ddr_test_size,test_ac_setup_hold,( lane_step));
			printf("\nstr=%s\n",str);
			//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
			//printf("\nstr=%s\n",str);
			run_command(str,0);

			test_ac_setup_hold=1;
			sprintf(str,"ddr_test_data_bit_setup_hold_window  a 0  0x%08x  %d  0x%08x",ddr_test_size,test_ac_setup_hold,( lane_step));
			printf("\nstr=%s\n",str);
			//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
			//printf("\nstr=%s\n",str);
			run_command(str,0);
			test_ac_setup_hold=0;
			for ((temp_count=0);(temp_count<28);(temp_count++))
			{
				writel(((data_bdlr0_5_reg_org[temp_count])),
						(((temp_count%7)<<2)+DDR0_PUB_DX0BDLR0+(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(temp_count/7)));

			};


		}
	}





	if (channel_a_en)
	{
		for ((lane_step=0);(lane_step<28);(lane_step++))
		{
			printf("data_bdlr0_5_reg_org[%d]0x%08x==0x%08x\n",	lane_step,
					(((lane_step%7)<<2)+DDR0_PUB_DX0BDLR0+(DDR0_PUB_DX1BDLR0-DDR0_PUB_DX0BDLR0)*(lane_step/7)),
					data_bdlr0_5_reg_org[lane_step]);

		};

		for ((lane_step=0);(lane_step<96);(lane_step++))
		{
			printf("\n a_ac_lane_0x%08x|setup_max 0x%08x  |hold_max 0x%08x |setup_time %08d ps ::|hold_time %08d ps  \n",
					lane_step,
					bdlr0_9_reg_setup_max[lane_step],
					bdlr0_9_reg_hold_max[lane_step],
					bdlr0_9_reg_setup_time[lane_step],
					bdlr0_9_reg_hold_time[lane_step]);

		}}



	return reg_value;
}

//#if (CONFIG_DDR_PHY ==  P_DDR_PHY_GX_BABY)
int do_ddr_gx_crosstalk(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	///*
	unsigned int  des[8] ;
	unsigned int  pattern_1[4][8] ;
	unsigned int  pattern_2[4][8] ;
	unsigned int  pattern_3[4][8] ;
	unsigned int  pattern_4[4][8] ;
	unsigned int  pattern_5[4][8] ;
	unsigned int  pattern_6[4][8] ;


	des[0] = 	0xaec83f49;
	des[1] =      0xd243a62c;
	des[2] =      0xf8774a0b;
	des[3] =       0x63d214e5;
	des[4] =      0x3f4166d5;
	des[5] =     0x239672c0;
	des[6] =      0x47ba7533;
	des[7] =      0xcae4cd7f;
	pattern_1[0][0] = 0xff00ff00;
	pattern_1[0][1] = 0xff00ff00;
	pattern_1[0][2] = 0xff00ff00;
	pattern_1[0][3] = 0xff00ff00;
	pattern_1[0][4] = 0xff00ff00;
	pattern_1[0][5] = 0xff00ff00;
	pattern_1[0][6] = 0xff00ff00;
	pattern_1[0][7] = 0xff00ff00;

	pattern_1[1][0] = 0x00ffff00;
	pattern_1[1][1] = 0x00ffff00;
	pattern_1[1][2] = 0x00ffff00;
	pattern_1[1][3] = 0x00ffff00;
	pattern_1[1][4] = 0x00ffff00;
	pattern_1[1][5] = 0x00ffff00;
	pattern_1[1][6] = 0x00ffff00;
	pattern_1[1][7] = 0x00ffff00;

	pattern_1[2][0] = 0xffff0000;
	pattern_1[2][1] = 0xffff0000;
	pattern_1[2][2] = 0xffff0000;
	pattern_1[2][3] = 0xffff0000;
	pattern_1[2][4] = 0xffff0000;
	pattern_1[2][5] = 0xffff0000;
	pattern_1[2][6] = 0xffff0000;
	pattern_1[2][7] = 0xffff0000;

	pattern_1[3][0] = 0xff00ff00;
	pattern_1[3][1] = 0xff00ff00;
	pattern_1[3][2] = 0xff00ff00;
	pattern_1[3][3] = 0xff00ff00;
	pattern_1[3][4] = 0xff00ff00;
	pattern_1[3][5] = 0xff00ff00;
	pattern_1[3][6] = 0xff00ff00;
	pattern_1[3][7] = 0xff00ff00;

	pattern_2[0][0] = 0x0001fe00;
	pattern_2[0][1] = 0x0000ff00;
	pattern_2[0][2] = 0x0000ff00;
	pattern_2[0][3] = 0x0000ff00;
	pattern_2[0][4] = 0x0002fd00;
	pattern_2[0][5] = 0x0000ff00;
	pattern_2[0][6] = 0x0000ff00;
	pattern_2[0][7] = 0x0000ff00;

	pattern_2[1][0] = 0x0004fb00;
	pattern_2[1][1] = 0x0000ff00;
	pattern_2[1][2] = 0x0000ff00;
	pattern_2[1][3] = 0x0000ff00;
	pattern_2[1][4] = 0x0008f700;
	pattern_2[1][5] = 0x0000ff00;
	pattern_2[1][6] = 0x0000ff00;
	pattern_2[1][7] = 0x0000ff00;

	pattern_2[2][0] = 0x0010ef00;
	pattern_2[2][1] = 0x0000ff00;
	pattern_2[2][2] = 0x0000ff00;
	pattern_2[2][3] = 0x0000ff00;
	pattern_2[2][4] = 0x0020df00;
	pattern_2[2][5] = 0x0000ff00;
	pattern_2[2][6] = 0x0000ff00;
	pattern_2[2][7] = 0x0000ff00;

	pattern_2[3][0] = 0x0040bf00;
	pattern_2[3][1] = 0x0000ff00;
	pattern_2[3][2] = 0x0000ff00;
	pattern_2[3][3] = 0x0000ff00;
	pattern_2[3][4] = 0x00807f00;
	pattern_2[3][5] = 0x0000ff00;
	pattern_2[3][6] = 0x0000ff00;
	pattern_2[3][7] = 0x0000ff00;

	pattern_3[0][0] = 0x00010000;
	pattern_3[0][1] = 0x00000000;
	pattern_3[0][2] = 0x00000000;
	pattern_3[0][3] = 0x00000000;
	pattern_3[0][4] = 0x00020000;
	pattern_3[0][5] = 0x00000000;
	pattern_3[0][6] = 0x00000000;
	pattern_3[0][7] = 0x00000000;

	pattern_3[1][0] = 0x00040000;
	pattern_3[1][1] = 0x00000000;
	pattern_3[1][2] = 0x00000000;
	pattern_3[1][3] = 0x00000000;
	pattern_3[1][4] = 0x00080000;
	pattern_3[1][5] = 0x00000000;
	pattern_3[1][6] = 0x00000000;
	pattern_3[1][7] = 0x00000000;

	pattern_3[2][0] = 0x00100000;
	pattern_3[2][1] = 0x00000000;
	pattern_3[2][2] = 0x00000000;
	pattern_3[2][3] = 0x00000000;
	pattern_3[2][4] = 0x00200000;
	pattern_3[2][5] = 0x00000000;
	pattern_3[2][6] = 0x00000000;
	pattern_3[2][7] = 0x00000000;

	pattern_3[3][0] = 0x00400000;
	pattern_3[3][1] = 0x00000000;
	pattern_3[3][2] = 0x00000000;
	pattern_3[3][3] = 0x00000000;
	pattern_3[3][4] = 0x00800000;
	pattern_3[3][5] = 0x00000000;
	pattern_3[3][6] = 0x00000000;
	pattern_3[3][7] = 0x00000000;

	///*
	pattern_4[0][0] =	0x51c8c049	;
	pattern_4[0][1] =	0x2d43592c	;
	pattern_4[0][2] =	0x0777b50b	;
	pattern_4[0][3] =	0x9cd2ebe5	;
	pattern_4[0][4] =	0xc04199d5	;
	pattern_4[0][5] =	0xdc968dc0	;
	pattern_4[0][6] =	0xb8ba8a33	;
	pattern_4[0][7] =	0x35e4327f	;

	pattern_4[1][0] =	0xae37c049	;
	pattern_4[1][1] =	0xd2bc592c	;
	pattern_4[1][2] =	0xf888b50b	;
	pattern_4[1][3] =	0x632debe5	;
	pattern_4[1][4] =	0x3fbe99d5	;
	pattern_4[1][5] =	0x23698dc0	;
	pattern_4[1][6] =	0x47458a33	;
	pattern_4[1][7] =	0xca1b327f	;

	pattern_4[2][0] =	0x51373f49	;
	pattern_4[2][1] =	0x2dbca62c	;
	pattern_4[2][2] =	0x07884a0b	;
	pattern_4[2][3] =	0x9c2d14e5	;
	pattern_4[2][4] =	0xc0be66d5	;
	pattern_4[2][5] =	0xdc6972c0	;
	pattern_4[2][6] =	0xb8457533	;
	pattern_4[2][7] =	0x351bcd7f	;


	pattern_4[3][0] =	0x51c8c049	;
	pattern_4[3][1] =	0x2d43592c	;
	pattern_4[3][2] =	0x0777b50b	;
	pattern_4[3][3] =	0x9cd2ebe5	;
	pattern_4[3][4] =	0xc04199d5	;
	pattern_4[3][5] =	0xdc968dc0	;
	pattern_4[3][6] =	0xb8ba8a33	;
	pattern_4[3][7] =	0x35e4327f	;

	pattern_5[0][0] =	0xaec9c149	;
	pattern_5[0][1] =	0xd243592c	;
	pattern_5[0][2] =	0xf877b50b	;
	pattern_5[0][3] =	0x63d2ebe5	;
	pattern_5[0][4] =	0x3f439bd5	;
	pattern_5[0][5] =	0x23968dc0	;
	pattern_5[0][6] =	0x47ba8a33	;
	pattern_5[0][7] =	0xcae4327f	;
	pattern_5[1][0] =	0xaeccc449	;
	pattern_5[1][1] =	0xd243592c	;
	pattern_5[1][2] =	0xf877b50b	;
	pattern_5[1][3] =	0x63d2ebe5	;
	pattern_5[1][4] =	0x3f4991d5	;
	pattern_5[1][5] =	0x23968dc0	;
	pattern_5[1][6] =	0x47ba8a33	;
	pattern_5[1][7] =	0xcae4327f	;
	pattern_5[2][0] =	0xaed8d049	;
	pattern_5[2][1] =	0xd243592c	;
	pattern_5[2][2] =	0xf877b50b	;
	pattern_5[2][3] =	0x63d2ebe5	;
	pattern_5[2][4] =	0x3f61b9d5	;
	pattern_5[2][5] =	0x23968dc0	;
	pattern_5[2][6] =	0x47ba8a33	;
	pattern_5[2][7] =	0xcae4327f	;
	pattern_5[3][0] =	0xae888049	;
	pattern_5[3][1] =	0xd243592c	;
	pattern_5[3][2] =	0xf877b50b	;
	pattern_5[3][3] =	0x63d2ebe5	;
	pattern_5[3][4] =	0x3fc119d5	;
	pattern_5[3][5] =	0x23968dc0	;
	pattern_5[3][6] =	0x47ba8a33	;
	pattern_5[3][7] =	0xcae4327f	;

	pattern_6[0][0] =   0xaec93f49   ;
	pattern_6[0][1] =	0xd243a62c	;
	pattern_6[0][2] =	0xf8774a0b	;
	pattern_6[0][3] =	0x63d214e5	;
	pattern_6[0][4] =	0x3f4366d5	;
	pattern_6[0][5] =	0x239672c0	;
	pattern_6[0][6] =	0x47ba7533	;
	pattern_6[0][7] =	0xcae4cd7f	;
	pattern_6[1][0] =	0xaecc3f49	;
	pattern_6[1][1] =	0xd243a62c	;
	pattern_6[1][2] =	0xf8774a0b	;
	pattern_6[1][3] =	0x63d214e5	;
	pattern_6[1][4] =	0x3f4966d5	;
	pattern_6[1][5] =	0x239672c0	;
	pattern_6[1][6] =	0x47ba7533	;
	pattern_6[1][7] =	0xcae4cd7f	;
	pattern_6[2][0] =	0xaed83f49	;
	pattern_6[2][1] =	0xd243a62c	;
	pattern_6[2][2] =	0xf8774a0b	;
	pattern_6[2][3] =	0x63d214e5	;
	pattern_6[2][4] =	0x3f6166d5	;
	pattern_6[2][5] =	0x239672c0	;
	pattern_6[2][6] =	0x47ba7533	;
	pattern_6[2][7] =	0xcae4cd7f	;
	pattern_6[3][0] =	0xae883f49	;
	pattern_6[3][1] =	0xd243a62c	;
	pattern_6[3][2] =	0xf8774a0b	;
	pattern_6[3][3] =	0x63d214e5	;
	pattern_6[3][4] =	0x3fc166d5	;
	pattern_6[3][5] =	0x239672c0	;
	pattern_6[3][6] =	0x47ba7533	;
	pattern_6[3][7] =	0xcae4cd7f	;
	//*/
	//*/

	char *endp;
	unsigned int   loop = 1;
	unsigned int   lflag = 0;
	unsigned int  start_addr = DDR_TEST_START_ADDR;
	unsigned int  test_size = DDR_TEST_SIZE;
	unsigned int   test_addr;

	error_outof_count_flag =0;
	error_count =0;
	printf("\nargc== 0x%08x\n", argc);
	int i ;
	for (i = 0;i<argc;i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}
	if (argc == 1)
		goto usage;
	if (argc>1)
	{
		if (strcmp(argv[1], "l") == 0) {
			lflag = 1;
		}

		else{
			loop = simple_strtoull_ddr(argv[1], &endp, 10);
			if (*argv[1] == 0 || *endp != 0)
				loop = 1;
		}

		//    printf("\nLINE== 0x%08x\n", __LINE__);
		if (argc ==1) {
			//    start_addr = simple_strtoull_ddr(argv[2], &endp, 16);
			//    if (*argv[2] == 0 || *endp != 0)
			start_addr = DDR_TEST_START_ADDR;
			loop = 1;

		}
	}



	if (argc >= 2) {
		loop = simple_strtoull_ddr(argv[1], &endp, 16);
		if (*argv[1] == 0 || *endp != 0)
			loop = 1;

	}
	unsigned int pattern_flag1=1;
	unsigned int pattern_flag2=1;
	unsigned int pattern_flag3=1;
	pattern_flag1 = 1;
	pattern_flag2=1;
	pattern_flag3 = 1;


	if (argc >= 3  ) {
		if ( (strcmp(argv[2], "s") == 0))
		{
			pattern_flag1 = 1;
			pattern_flag2=0;
			pattern_flag3 = 0;
		}
		else if ((strcmp(argv[2], "c") == 0))
		{
			pattern_flag1 = 0;
			pattern_flag2=1;
			pattern_flag3 = 0;
		}
		else  if ( (strcmp(argv[2], "d") == 0))
		{
			pattern_flag1 = 0;
			pattern_flag2=0;
			pattern_flag3 = 1;
		}
	}

	//	if(test_size<0x20)
	start_addr=0x10000000;
	test_size = 0x20;
	unsigned int temp_i=0;
	unsigned int temp_k=0;
	unsigned int pattern_o[8];
	unsigned int pattern_d[8];


	//DDR_TEST_START:

	///*
	error_count=0;
	do {
		if (lflag)
			loop = 888;

		//if(old_pattern_flag==1)
		{

			printf("\nStart writing at 0x%08x - 0x%08x...\n", start_addr, start_addr + test_size);

			/*
			   for ((temp_k=0);(temp_k<4);(temp_k++)) {
			   {

			   for ((temp_i=0);(temp_i<8);(temp_i++))
			   {
			   test_addr=start_addr+(temp_i<<2);
			 *(volatile uint32_t *)(int_convter_p(test_addr))=des_pattern(temp_i,2,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
			//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
			//des[temp_i]^pattern_2[temp_k][temp_i]
			}
			//   _clean_dcache_addr(0x10000000);
			flush_dcache_range(start_addr,start_addr + test_size);

			for ((temp_i=0);(temp_i<8);(temp_i++)) {
			test_addr=start_addr+(temp_i<<2);
			pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
			//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_2[temp_k][temp_i]);
			//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
			//printf("\n0x%08x",pattern_5[temp_k][temp_i]);
			if (pattern_o[temp_i] != pattern_5[temp_k][temp_i])
			{error_count++;
			printf("p5Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), pattern_5[temp_k][temp_i],pattern_2[temp_k][temp_i]);
			}
			}
			}
			}
			*/
			if (pattern_flag1 == 1) {
				for ((temp_k=0);(temp_k<4);(temp_k++))
				{
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_pattern(temp_i,1,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_1[temp_k][temp_i]);
							//  printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							//	  printf("\n0x%08x",pattern_4[temp_k][temp_i]);
							if (pattern_o[temp_i] != pattern_4[temp_k][temp_i])
							{error_count++;
								printf("p4Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), pattern_4[temp_k][temp_i],pattern_1[temp_k][temp_i]);
							}

						}
					}
				}
				for ((temp_k=0);(temp_k<4);(temp_k++))
				{
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_inv_pattern(temp_i,1,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_1[temp_k][temp_i]);
							//  printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							//	  printf("\n0x%08x",pattern_4[temp_k][temp_i]);
							pattern_d[temp_i]=des_xor_pattern((des[temp_i]),(pattern_o[temp_i]));
							if ((des_xor_pattern((des[temp_i]),(pattern_o[temp_i]))) != pattern_d[temp_i])
							{error_count++;
								printf("p4 invError data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), ~(pattern_4[temp_k][temp_i]),pattern_d[temp_i]);
							}

						}
					}
				}
			}
			if (pattern_flag2 == 1) {
				for ((temp_k=0);(temp_k<4);(temp_k++)) {
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_pattern(temp_i,2,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_2[temp_k][temp_i]);
							//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							//printf("\n0x%08x",pattern_5[temp_k][temp_i]);
							if (pattern_o[temp_i] != pattern_5[temp_k][temp_i])
							{error_count++;
								printf("p5Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), pattern_5[temp_k][temp_i],pattern_2[temp_k][temp_i]);
							}
						}
					}
				}
				for ((temp_k=0);(temp_k<4);(temp_k++))
				{
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_inv_pattern(temp_i,2,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_2[temp_k][temp_i]);
							//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							//printf("\n0x%08x",pattern_5[temp_k][temp_i]);
							pattern_d[temp_i]=des_xor_pattern((des[temp_i]),(pattern_o[temp_i]));
							if ((des_xor_pattern((des[temp_i]),(pattern_o[temp_i]))) != pattern_d[temp_i])
							{error_count++;
								printf("p5 invError data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), ~(pattern_5[temp_k][temp_i]),pattern_d[temp_i]);
							}
						}
					}
				}

			}

			if (pattern_flag3 == 1) {
				for ((temp_k=0);(temp_k<4);(temp_k++)) {
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_pattern(temp_i,3,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_3[temp_k][temp_i]);
							//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							// printf("\n0x%08x",pattern_6[temp_k][temp_i]);
							if (pattern_o[temp_i] != pattern_6[temp_k][temp_i])
							{error_count++;
								printf("p6Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), pattern_6[temp_k][temp_i],pattern_3[temp_k][temp_i]);
							}
						}
					}
				}
				for ((temp_k=0);(temp_k<4);(temp_k++))
				{
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_inv_pattern(temp_i,3,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_3[temp_k][temp_i]);
							//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							// printf("\n0x%08x",pattern_6[temp_k][temp_i]);
							pattern_d[temp_i]=des_xor_pattern((des[temp_i]),(pattern_o[temp_i]));
							if ((des_xor_pattern((des[temp_i]),(pattern_o[temp_i]))) != pattern_d[temp_i])
							{error_count++;
								printf("p6 invError data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), ~(pattern_6[temp_k][temp_i]),pattern_d[temp_i]);
							}
						}
					}
				}
			}



		}

		printf("\Error count==0x%08x", error_count);
		printf("\n      \n");
	}while(--loop);
	//*/

	printf("\rEnd ddr test.                              \n");

	return 0;

usage:
	cmd_usage(cmdtp);
	return 1;
}


U_BOOT_CMD(
	ddrtest_gx_crosstalk,	5,	1,	do_ddr_gx_crosstalk,
	"DDR test function",
	"ddrtest [LOOP] [ADDR].Default address is 0x10000000\n"
);



//#if (CONFIG_DDR_PHY ==  P_DDR_PHY_GX_TV_BABY)
int do_ddr_gxtvbb_crosstalk(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	///*
	unsigned int  a_des[8],b_des[8],des[8] ;
	unsigned int  pattern_1[4][8] ;
	unsigned int  pattern_2[4][8] ;
	unsigned int  pattern_3[4][8] ;
	// unsigned int  pattern_4[4][8] ;
	// unsigned int  pattern_5[4][8] ;
	//  unsigned int  pattern_6[4][8] ;


	a_des[0] =      0x7ea09b52;
	a_des[1] =      0xbc57bb23;
	a_des[2] =      0x8d2b6e65;
	a_des[3] =      0x15fdcdc4;
	a_des[4] =      0xbc1df453;
	a_des[5] =      0x21bcbcdf;
	a_des[6] =      0x267b7ac1;
	a_des[7] =      0x6af03d72;


	b_des[0] =      0xdfc2ee12;
	b_des[1] =      0x4f58da43;
	b_des[2] =      0x87809557;
	b_des[3] =      0xb87ddbf4;
	b_des[4] =      0x667fb021;
	b_des[5] =      0x64593586;
	b_des[6] =      0xee73d8d5;
	b_des[7] =      0xe65f972d;
	pattern_1[0][0] = 0xff00ff00;
	pattern_1[0][1] = 0xff00ff00;
	pattern_1[0][2] = 0xff00ff00;
	pattern_1[0][3] = 0xff00ff00;
	pattern_1[0][4] = 0xff00ff00;
	pattern_1[0][5] = 0xff00ff00;
	pattern_1[0][6] = 0xff00ff00;
	pattern_1[0][7] = 0xff00ff00;

	pattern_1[1][0] = 0x00ffff00;
	pattern_1[1][1] = 0x00ffff00;
	pattern_1[1][2] = 0x00ffff00;
	pattern_1[1][3] = 0x00ffff00;
	pattern_1[1][4] = 0x00ffff00;
	pattern_1[1][5] = 0x00ffff00;
	pattern_1[1][6] = 0x00ffff00;
	pattern_1[1][7] = 0x00ffff00;

	pattern_1[2][0] = 0xffff0000;
	pattern_1[2][1] = 0xffff0000;
	pattern_1[2][2] = 0xffff0000;
	pattern_1[2][3] = 0xffff0000;
	pattern_1[2][4] = 0xffff0000;
	pattern_1[2][5] = 0xffff0000;
	pattern_1[2][6] = 0xffff0000;
	pattern_1[2][7] = 0xffff0000;

	pattern_1[3][0] = 0xff00ff00;
	pattern_1[3][1] = 0xff00ff00;
	pattern_1[3][2] = 0xff00ff00;
	pattern_1[3][3] = 0xff00ff00;
	pattern_1[3][4] = 0xff00ff00;
	pattern_1[3][5] = 0xff00ff00;
	pattern_1[3][6] = 0xff00ff00;
	pattern_1[3][7] = 0xff00ff00;

	pattern_2[0][0] = 0x0001fe00;
	pattern_2[0][1] = 0x0000ff00;
	pattern_2[0][2] = 0x0000ff00;
	pattern_2[0][3] = 0x0000ff00;
	pattern_2[0][4] = 0x0002fd00;
	pattern_2[0][5] = 0x0000ff00;
	pattern_2[0][6] = 0x0000ff00;
	pattern_2[0][7] = 0x0000ff00;

	pattern_2[1][0] = 0x0004fb00;
	pattern_2[1][1] = 0x0000ff00;
	pattern_2[1][2] = 0x0000ff00;
	pattern_2[1][3] = 0x0000ff00;
	pattern_2[1][4] = 0x0008f700;
	pattern_2[1][5] = 0x0000ff00;
	pattern_2[1][6] = 0x0000ff00;
	pattern_2[1][7] = 0x0000ff00;

	pattern_2[2][0] = 0x0010ef00;
	pattern_2[2][1] = 0x0000ff00;
	pattern_2[2][2] = 0x0000ff00;
	pattern_2[2][3] = 0x0000ff00;
	pattern_2[2][4] = 0x0020df00;
	pattern_2[2][5] = 0x0000ff00;
	pattern_2[2][6] = 0x0000ff00;
	pattern_2[2][7] = 0x0000ff00;

	pattern_2[3][0] = 0x0040bf00;
	pattern_2[3][1] = 0x0000ff00;
	pattern_2[3][2] = 0x0000ff00;
	pattern_2[3][3] = 0x0000ff00;
	pattern_2[3][4] = 0x00807f00;
	pattern_2[3][5] = 0x0000ff00;
	pattern_2[3][6] = 0x0000ff00;
	pattern_2[3][7] = 0x0000ff00;

	pattern_3[0][0] = 0x00010000;
	pattern_3[0][1] = 0x00000000;
	pattern_3[0][2] = 0x00000000;
	pattern_3[0][3] = 0x00000000;
	pattern_3[0][4] = 0x00020000;
	pattern_3[0][5] = 0x00000000;
	pattern_3[0][6] = 0x00000000;
	pattern_3[0][7] = 0x00000000;

	pattern_3[1][0] = 0x00040000;
	pattern_3[1][1] = 0x00000000;
	pattern_3[1][2] = 0x00000000;
	pattern_3[1][3] = 0x00000000;
	pattern_3[1][4] = 0x00080000;
	pattern_3[1][5] = 0x00000000;
	pattern_3[1][6] = 0x00000000;
	pattern_3[1][7] = 0x00000000;

	pattern_3[2][0] = 0x00100000;
	pattern_3[2][1] = 0x00000000;
	pattern_3[2][2] = 0x00000000;
	pattern_3[2][3] = 0x00000000;
	pattern_3[2][4] = 0x00200000;
	pattern_3[2][5] = 0x00000000;
	pattern_3[2][6] = 0x00000000;
	pattern_3[2][7] = 0x00000000;

	pattern_3[3][0] = 0x00400000;
	pattern_3[3][1] = 0x00000000;
	pattern_3[3][2] = 0x00000000;
	pattern_3[3][3] = 0x00000000;
	pattern_3[3][4] = 0x00800000;
	pattern_3[3][5] = 0x00000000;
	pattern_3[3][6] = 0x00000000;
	pattern_3[3][7] = 0x00000000;

	/*
	   pattern_4[0][0] =	0x51c8c049	;
	   pattern_4[0][1] =	0x2d43592c	;
	   pattern_4[0][2] =	0x0777b50b	;
	   pattern_4[0][3] =	0x9cd2ebe5	;
	   pattern_4[0][4] =	0xc04199d5	;
	   pattern_4[0][5] =	0xdc968dc0	;
	   pattern_4[0][6] =	0xb8ba8a33	;
	   pattern_4[0][7] =	0x35e4327f	;

	   pattern_4[1][0] =	0xae37c049	;
	   pattern_4[1][1] =	0xd2bc592c	;
	   pattern_4[1][2] =	0xf888b50b	;
	   pattern_4[1][3] =	0x632debe5	;
	   pattern_4[1][4] =	0x3fbe99d5	;
	   pattern_4[1][5] =	0x23698dc0	;
	   pattern_4[1][6] =	0x47458a33	;
	   pattern_4[1][7] =	0xca1b327f	;

	   pattern_4[2][0] =	0x51373f49	;
	   pattern_4[2][1] =	0x2dbca62c	;
	   pattern_4[2][2] =	0x07884a0b	;
	   pattern_4[2][3] =	0x9c2d14e5	;
	   pattern_4[2][4] =	0xc0be66d5	;
	   pattern_4[2][5] =	0xdc6972c0	;
	   pattern_4[2][6] =	0xb8457533	;
	   pattern_4[2][7] =	0x351bcd7f	;


	   pattern_4[3][0] =	0x51c8c049	;
	   pattern_4[3][1] =	0x2d43592c	;
	   pattern_4[3][2] =	0x0777b50b	;
	   pattern_4[3][3] =	0x9cd2ebe5	;
	   pattern_4[3][4] =	0xc04199d5	;
	   pattern_4[3][5] =	0xdc968dc0	;
	   pattern_4[3][6] =	0xb8ba8a33	;
	   pattern_4[3][7] =	0x35e4327f	;

	   pattern_5[0][0] =	0xaec9c149	;
	   pattern_5[0][1] =	0xd243592c	;
	   pattern_5[0][2] =	0xf877b50b	;
	   pattern_5[0][3] =	0x63d2ebe5	;
	   pattern_5[0][4] =	0x3f439bd5	;
	   pattern_5[0][5] =	0x23968dc0	;
	   pattern_5[0][6] =	0x47ba8a33	;
	   pattern_5[0][7] =	0xcae4327f	;
	   pattern_5[1][0] =	0xaeccc449	;
	   pattern_5[1][1] =	0xd243592c	;
	   pattern_5[1][2] =	0xf877b50b	;
	   pattern_5[1][3] =	0x63d2ebe5	;
	   pattern_5[1][4] =	0x3f4991d5	;
	   pattern_5[1][5] =	0x23968dc0	;
	   pattern_5[1][6] =	0x47ba8a33	;
	   pattern_5[1][7] =	0xcae4327f	;
	   pattern_5[2][0] =	0xaed8d049	;
	   pattern_5[2][1] =	0xd243592c	;
	   pattern_5[2][2] =	0xf877b50b	;
	   pattern_5[2][3] =	0x63d2ebe5	;
	   pattern_5[2][4] =	0x3f61b9d5	;
	   pattern_5[2][5] =	0x23968dc0	;
	   pattern_5[2][6] =	0x47ba8a33	;
	   pattern_5[2][7] =	0xcae4327f	;
	   pattern_5[3][0] =	0xae888049	;
	   pattern_5[3][1] =	0xd243592c	;
	   pattern_5[3][2] =	0xf877b50b	;
	   pattern_5[3][3] =	0x63d2ebe5	;
	   pattern_5[3][4] =	0x3fc119d5	;
	   pattern_5[3][5] =	0x23968dc0	;
	   pattern_5[3][6] =	0x47ba8a33	;
	   pattern_5[3][7] =	0xcae4327f	;

	pattern_6[0][0] =   0xaec93f49   ;
	pattern_6[0][1] =	0xd243a62c	;
	pattern_6[0][2] =	0xf8774a0b	;
	pattern_6[0][3] =	0x63d214e5	;
	pattern_6[0][4] =	0x3f4366d5	;
	pattern_6[0][5] =	0x239672c0	;
	pattern_6[0][6] =	0x47ba7533	;
	pattern_6[0][7] =	0xcae4cd7f	;
	pattern_6[1][0] =	0xaecc3f49	;
	pattern_6[1][1] =	0xd243a62c	;
	pattern_6[1][2] =	0xf8774a0b	;
	pattern_6[1][3] =	0x63d214e5	;
	pattern_6[1][4] =	0x3f4966d5	;
	pattern_6[1][5] =	0x239672c0	;
	pattern_6[1][6] =	0x47ba7533	;
	pattern_6[1][7] =	0xcae4cd7f	;
	pattern_6[2][0] =	0xaed83f49	;
	pattern_6[2][1] =	0xd243a62c	;
	pattern_6[2][2] =	0xf8774a0b	;
	pattern_6[2][3] =	0x63d214e5	;
	pattern_6[2][4] =	0x3f6166d5	;
	pattern_6[2][5] =	0x239672c0	;
	pattern_6[2][6] =	0x47ba7533	;
	pattern_6[2][7] =	0xcae4cd7f	;
	pattern_6[3][0] =	0xae883f49	;
	pattern_6[3][1] =	0xd243a62c	;
	pattern_6[3][2] =	0xf8774a0b	;
	pattern_6[3][3] =	0x63d214e5	;
	pattern_6[3][4] =	0x3fc166d5	;
	pattern_6[3][5] =	0x239672c0	;
	pattern_6[3][6] =	0x47ba7533	;
	pattern_6[3][7] =	0xcae4cd7f	;
	*/
		//*/

	char *endp;
	unsigned int   loop = 1;
	unsigned int   lflag = 0;
	unsigned int  start_addr = DDR_TEST_START_ADDR;
	unsigned int  test_size = DDR_TEST_SIZE;
	unsigned int   test_addr;

	error_outof_count_flag =0;
	error_count =0;

	printf("\nargc== 0x%08x\n", argc);
	int i ;
	for (i = 0;i<argc;i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}
	if (argc == 1)
		goto usage;
	if (argc>1)
	{
		if (strcmp(argv[1], "l") == 0) {
			lflag = 1;
		}

		else{
			loop = simple_strtoull_ddr(argv[1], &endp, 10);
			if (*argv[1] == 0 || *endp != 0)
				loop = 1;
		}

		//    printf("\nLINE== 0x%08x\n", __LINE__);
		if (argc ==1) {
			//    start_addr = simple_strtoull_ddr(argv[2], &endp, 16);
			//    if (*argv[2] == 0 || *endp != 0)
			start_addr = DDR_TEST_START_ADDR;
			loop = 1;
		}
	}

	if (argc >= 2) {
		loop = simple_strtoull_ddr(argv[1], &endp, 16);
		if (*argv[1] == 0 || *endp != 0)
			loop = 1;

	}
	unsigned int pattern_flag1=1;
	unsigned int pattern_flag2=1;
	unsigned int pattern_flag3=1;
	pattern_flag1 = 1;
	pattern_flag2=1;
	pattern_flag3 = 1;


	if (argc >= 3  ) {
		if ( (strcmp(argv[2], "s") == 0))
		{
			pattern_flag1 = 1;
			pattern_flag2=0;
			pattern_flag3 = 0;
		}
		else if ((strcmp(argv[2], "c") == 0))
		{
			pattern_flag1 = 0;
			pattern_flag2=1;
			pattern_flag3 = 0;
		}
		else  if ( (strcmp(argv[2], "d") == 0))
		{
			pattern_flag1 = 0;
			pattern_flag2=0;
			pattern_flag3 = 1;
		}
	}

	//	if(test_size<0x20)
	start_addr=0x10000000;
	test_size = 0x20;
	unsigned int temp_i=0;
	unsigned int temp_k=0;
	unsigned int pattern_o[8];
	unsigned int pattern_d[8];
	//unsigned int i=0;

	printf("\nloop should >2 and now loop== 0x%08x\n", loop);
	//DDR_TEST_START:

	///*

	error_count=0;
	do {
		if (lflag)
			loop = 888;
		if (loop%2)
		{
			start_addr=0x10000000;
			test_size = 0x20;
			for ((i=0);(i<8);(i++))
			{
				des[i]=  a_des[i];
			}
		}
		else
		{
			start_addr=0x10000400;
			test_size = 0x20;
			for ((i=0);(i<8);(i++))
			{
				des[i]=  b_des[i];
			}
		}
		//if(old_pattern_flag==1)
		{

			printf("\nStart writing at 0x%08x - 0x%08x...\n", start_addr, start_addr + test_size);

			/*
			   for ((temp_k=0);(temp_k<4);(temp_k++)) {
			   {

			   for ((temp_i=0);(temp_i<8);(temp_i++))
			   {
			   test_addr=start_addr+(temp_i<<2);
			 *(volatile uint32_t *)(int_convter_p(test_addr))=des_pattern(temp_i,2,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
			//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
			//des[temp_i]^pattern_2[temp_k][temp_i]
			}
			//   _clean_dcache_addr(0x10000000);
			flush_dcache_range(start_addr,start_addr + test_size);

			for ((temp_i=0);(temp_i<8);(temp_i++)) {
			test_addr=start_addr+(temp_i<<2);
			pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
			//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_2[temp_k][temp_i]);
			//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
			//printf("\n0x%08x",pattern_5[temp_k][temp_i]);
			if (pattern_o[temp_i] != pattern_5[temp_k][temp_i])
			{error_count++;
			printf("p5Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), pattern_5[temp_k][temp_i],pattern_2[temp_k][temp_i]);
			}
			}
			}
			}
			*/
			if (pattern_flag1 == 1) {
				for ((temp_k=0);(temp_k<4);(temp_k++))
				{
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_pattern(temp_i,1,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_1[temp_k][temp_i]);
							//  printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							//	  printf("\n0x%08x",pattern_4[temp_k][temp_i]);
							//	if(pattern_o[temp_i]!=pattern_4[temp_k][temp_i])
							if ((pattern_o[temp_i]) != (des_pattern(temp_i,1,temp_k,temp_i)))
							{error_count++;
								//                printf("p4Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), pattern_4[temp_k][temp_i],pattern_1[temp_k][temp_i]);
								printf("p4Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), des_pattern(temp_i,1,temp_k,temp_i),pattern_1[temp_k][temp_i]);
							}

						}
					}
				}
				for ((temp_k=0);(temp_k<4);(temp_k++))
				{
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_inv_pattern(temp_i,1,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_1[temp_k][temp_i]);
							//  printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							//	  printf("\n0x%08x",pattern_4[temp_k][temp_i]);
							pattern_d[temp_i]=des_xor_pattern((des[temp_i]),(pattern_o[temp_i]));
							if ((des_xor_pattern((des[temp_i]),(pattern_o[temp_i]))) != pattern_d[temp_i])
							{error_count++;
								//                     printf("p4 invError data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), ~(pattern_4[temp_k][temp_i]),pattern_d[temp_i]);
								printf("p4 invError data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), ~(des_pattern(temp_i,1,temp_k,temp_i)),pattern_d[temp_i]);
							}

						}
					}
				}
			}
			if (pattern_flag2 == 1) {
				for ((temp_k=0);(temp_k<4);(temp_k++)) {
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_pattern(temp_i,2,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_2[temp_k][temp_i]);
							//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							//printf("\n0x%08x",pattern_5[temp_k][temp_i]);
							//	if(pattern_o[temp_i]!=pattern_5[temp_k][temp_i])
							if ((pattern_o[temp_i]) != (des_pattern(temp_i,2,temp_k,temp_i)))
							{error_count++;
								//           printf("p5Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), pattern_5[temp_k][temp_i],pattern_2[temp_k][temp_i]);
								printf("p5Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), des_pattern(temp_i,2,temp_k,temp_i),pattern_2[temp_k][temp_i]);
							}
						}
					}
				}
				for ((temp_k=0);(temp_k<4);(temp_k++))
				{
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_inv_pattern(temp_i,2,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_2[temp_k][temp_i]);
							//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							//printf("\n0x%08x",pattern_5[temp_k][temp_i]);
							pattern_d[temp_i]=des_xor_pattern((des[temp_i]),(pattern_o[temp_i]));
							if ((des_xor_pattern((des[temp_i]),(pattern_o[temp_i]))) != pattern_d[temp_i])
							{error_count++;
								//          printf("p5 invError data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), ~(pattern_5[temp_k][temp_i]),pattern_d[temp_i]);
								printf("p5 invError data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), ~(des_inv_pattern(temp_i,2,temp_k,temp_i)),pattern_d[temp_i]);
							}
						}
					}
				}

			}

			if (pattern_flag3 == 1) {
				for ((temp_k=0);(temp_k<4);(temp_k++)) {
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_pattern(temp_i,3,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_3[temp_k][temp_i]);
							//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							// printf("\n0x%08x",pattern_6[temp_k][temp_i]);
							//if(pattern_o[temp_i]!=pattern_6[temp_k][temp_i])
							if ((pattern_o[temp_i]) != (des_pattern(temp_i,3,temp_k,temp_i)))
							{error_count++;
								//       printf("p6Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), pattern_6[temp_k][temp_i],pattern_3[temp_k][temp_i]);
								printf("p6Error data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), des_pattern(temp_i,3,temp_k,temp_i),pattern_3[temp_k][temp_i]);
							}
						}
					}
				}
				for ((temp_k=0);(temp_k<4);(temp_k++))
				{
					{
						ddr_udelay(10000);
						for ((temp_i=0);(temp_i<8);(temp_i++))
						{
							test_addr=start_addr+(temp_i<<2);
							*(volatile uint32_t *)(int_convter_p(test_addr))=des_inv_pattern(temp_i,3,temp_k,temp_i);//des[temp_i]^pattern_2[temp_k][temp_i];
							//	#define des_pattern(a,b,c,d)  des[a]^pattern_##b[c][d]
							//des[temp_i]^pattern_2[temp_k][temp_i]
						}
						//   _clean_dcache_addr(0x10000000);
#ifdef DDR_PREFETCH_CACHE
						flush_dcache_range(start_addr,start_addr + test_size);
#endif
						for ((temp_i=0);(temp_i<8);(temp_i++)) {
							test_addr=start_addr+(temp_i<<2);
							pattern_o[temp_i]=*(volatile uint32_t *)(int_convter_p(test_addr));
							//	 printf("\n test_addr pattern_o pattern_d  0x%08x - 0x%08x - 0x%08x", test_addr,pattern_o[temp_i], pattern_3[temp_k][temp_i]);
							//printf("\n0x%08x",(pattern_o[temp_i])^(des[temp_i]));
							// printf("\n0x%08x",pattern_6[temp_k][temp_i]);
							pattern_d[temp_i]=des_xor_pattern((des[temp_i]),(pattern_o[temp_i]));
							if ((des_xor_pattern((des[temp_i]),(pattern_o[temp_i]))) != pattern_d[temp_i])
							{error_count++;
								//       printf("p6 invError data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), ~(pattern_6[temp_k][temp_i]),pattern_d[temp_i]);
								printf("p6 invError data [0x%08x] at offset 0x%08x[0x%08x]-D0x%08x\n",pattern_o[temp_i], p_convter_int(test_addr), ~(des_inv_pattern(temp_i,3,temp_k,temp_i)),pattern_d[temp_i]);
							}
						}
					}
				}
			}



		}

		printf("\Error count==0x%08x", error_count);
		printf("\n      \n");
	}while(--loop);
	//*/

	printf("\rEnd ddr test.                              \n");

	return 0;

usage:
	cmd_usage(cmdtp);
	return 1;
}


U_BOOT_CMD(
	ddrtest_gxtvbb_crosstalk,	5,	1,	do_ddr_gxtvbb_crosstalk,
	"DDR test function",
	"ddrtest [LOOP] [ADDR].Default address is 0x10000000\n"
);

#if 1
int do_ddrtest_find_gate_wind(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter Tune ddr dqs function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);
	//  unsigned int   loop = 1;
	unsigned int   temp_count_i = 1;
	//   unsigned int   temp_count_j= 1;
	//    unsigned int   temp_count_k= 1;
	unsigned int   temp_test_error= 0;

	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_loop=1;
	unsigned int   test_times=1;
	unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;
	unsigned int   testing_channel = 0;

	// /*
	// #define  DATX8_DQ_LCD_BDL_REG_WIDTH  12

#define  DATX8_DQ_LANE_WIDTH  4
#define  CHANNEL_CHANNEL_WIDTH  2

#define  CHANNEL_A  0
#define  CHANNEL_B  1



#define  DATX8_DQ_LANE_LANE00  0
#define  DATX8_DQ_LANE_LANE01  1
#define  DATX8_DQ_LANE_LANE02  2
#define  DATX8_DQ_LANE_LANE03  3

#define  DATX8_DQ_BDLR0  0
#define  DATX8_DQ_BDLR1  1
#define  DATX8_DQ_BDLR2  2
#define  DATX8_DQ_BDLR3  3
#define  DATX8_DQ_BDLR4  4
#define  DATX8_DQ_BDLR5  5
#define  DATX8_DQ_BDLR6  6
#define  DATX8_DQ_DXNLCDLR0     7
#define  DATX8_DQ_DXNLCDLR1     8
#define  DATX8_DQ_DXNLCDLR2     9
#define  DATX8_DQ_DXNMDLR        10
#define  DATX8_DQ_DXNGTR          11


#define  DDR_CORSS_TALK_TEST_SIZE   0x20000

	// #define  DQ_LCD_BDL_REG_NUM_PER_CHANNEL  5//DATX8_DQ_LCD_BDL_REG_WIDTH*DATX8_DQ_LANE_WIDTH
	//    #define  DQ_LCD_BDL_REG_NUM    DQ_LCD_BDL_REG_NUM_PER_CHANNEL*CHANNEL_CHANNEL_WIDTH
	//*/


	//  unsigned int   dq_lcd_bdl_reg_org[DQ_LCD_BDL_REG_NUM];
	//  unsigned int   dq_lcd_bdl_reg_left[DQ_LCD_BDL_REG_NUM];
	//  unsigned int   dq_lcd_bdl_reg_right[DQ_LCD_BDL_REG_NUM];
	//  unsigned int   dq_lcd_bdl_reg_index[DQ_LCD_BDL_REG_NUM];

	//  unsigned int   dq_lcd_bdl_reg_left_min[DQ_LCD_BDL_REG_NUM];
	//  unsigned int   dq_lcd_bdl_reg_right_min[DQ_LCD_BDL_REG_NUM];

	unsigned int   dq_lcd_bdl_temp_reg_value;
	//   unsigned int   dq_lcd_bdl_temp_reg_value_min;
	//  unsigned int   dq_lcd_bdl_temp_reg_value_max;
	//   unsigned int   dq_lcd_bdl_temp_reg_value_rdqsd;
	//  unsigned int   dq_lcd_bdl_temp_reg_value_rdqsnd;
	//   unsigned int   dq_lcd_bdl_temp_reg_lef_min_value;
	//     unsigned int   dq_lcd_bdl_temp_reg_rig_min_value;
	//   unsigned int   dq_lcd_bdl_temp_reg_value_dqs;
	//  unsigned int   dq_lcd_bdl_temp_reg_value_wdqd;
	//   unsigned int   dq_lcd_bdl_temp_reg_value_rdqsd;

	//   unsigned int   dq_lcd_bdl_temp_reg_lef;
	//   unsigned int   dq_lcd_bdl_temp_reg_rig;
	//    unsigned int   dq_lcd_bdl_temp_reg_center;
	//    unsigned int   dq_lcd_bdl_temp_reg_windows;
	//      unsigned int   dq_lcd_bdl_temp_reg_center_min;
	//    unsigned int   dq_lcd_bdl_temp_reg_windows_min;

	unsigned int   dqgtr_org[4],dqlcdlr2_org[4],dqgtr_l[4],dqlcdlr2_l[4],dqgtr_r[4],dqlcdlr2_r[4],dqmdlr[4];
	unsigned int dqgtr_temp;
	unsigned int dqlcdlr2_temp;
	unsigned int dqqsgate_org[4],dqqsgate_l[4], dqqsgate_r[4];
	unsigned int   ddr_gate_up_down=0;
	unsigned int   ddr_gate_init_lane=0;

	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;



	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))
		{
			channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))
		{
			channel_b_en = 1;
		}
		else
		{
			goto usage;
		}
	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))
		{
			channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))
		{
			channel_b_en = 1;
		}
	}
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}

	}
	if (argc >4) {
		test_loop = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
		{
			test_loop = 1;
		}
		if   ((strcmp(argv[4], "l") == 0) || (strcmp(argv[4], "L") == 0))
		{
			test_loop = 100000;
		}
	}


	if (argc >5) {
		ddr_gate_up_down = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
		{
			ddr_gate_up_down = 0;
		}
		if   ((strcmp(argv[5], "l") == 0) || (strcmp(argv[5], "L") == 0))
		{
			ddr_gate_up_down = 00000;
		}
	}
	if (argc >6) {
		ddr_gate_init_lane = simple_strtoull_ddr(argv[6], &endp, 16);
		if (*argv[6] == 0 || *endp != 0)
		{
			ddr_gate_init_lane = 0;
		}
		if   ((strcmp(argv[6], "l") == 0) || (strcmp(argv[6], "L") == 0))
		{
			ddr_gate_init_lane = 00000;
		}
	}


	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_loop== 0x%08x\n", test_loop);
	printf("\nddr_gate_up_down== 0x%08x\n", ddr_gate_up_down);
	printf("\nddr_gate_init_lane== 0x%08x\n", ddr_gate_init_lane);
	if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}


	//save and print org training dqs value
	if (channel_a_en || channel_b_en)
	{


		//dcache_disable();
		//serial_puts("\ndebug for ddrtest ,jiaxing disable dcache");

		for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
		{
			if (( channel_a_en) && ( channel_b_en == 0))
			{
				reg_base_adj=CHANNEL_A_REG_BASE;
			}
			else if(( channel_b_en)&&( channel_a_en==0))
			{
				reg_base_adj=CHANNEL_B_REG_BASE;
			}
			else if ((channel_a_en+channel_b_en)==2)
			{
				if ( testing_channel == CHANNEL_A)
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if( testing_channel==CHANNEL_B)
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
			}

			for ((temp_count_i=0);(temp_count_i<DATX8_DQ_LANE_WIDTH);(temp_count_i++))
			{

				if (temp_count_i == DATX8_DQ_LANE_LANE00)
				{
					reg_add=DDR0_PUB_DX0LCDLR0+reg_base_adj;
				}
				else    if(temp_count_i==DATX8_DQ_LANE_LANE01)
				{
					reg_add=DDR0_PUB_DX1LCDLR0+reg_base_adj;
				}
				else   	 if(temp_count_i==DATX8_DQ_LANE_LANE02)
				{
					reg_add=DDR0_PUB_DX2LCDLR0+reg_base_adj;
				} else    if(temp_count_i==DATX8_DQ_LANE_LANE03)
				{
					reg_add=DDR0_PUB_DX3LCDLR0+reg_base_adj;
				}
			}
		}
	}////save and print org training dqs value


	for (test_times=0;(test_times<test_loop);(test_times++))
	{
		////tune and save training dqs value
		if (channel_a_en || channel_b_en)
		{
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{
				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;
					}
				}

				for ((temp_count_i=0);(temp_count_i<DATX8_DQ_LANE_WIDTH);(temp_count_i++))
				{
					printf("\ntest lane==0x%08x\n ",temp_count_i);
					if (ddr_gate_init_lane)
					{
						temp_count_i=ddr_gate_init_lane;
						printf("\ntest lane change==0x%08x\n ",temp_count_i);
					}


					if (temp_count_i == DATX8_DQ_LANE_LANE00)
					{
						reg_add=DDR0_PUB_DX0LCDLR0+reg_base_adj;
					}
					else    if(temp_count_i==DATX8_DQ_LANE_LANE01)
					{
						reg_add=DDR0_PUB_DX1LCDLR0+reg_base_adj;
					}
					else   	 if(temp_count_i==DATX8_DQ_LANE_LANE02)
					{
						reg_add=DDR0_PUB_DX2LCDLR0+reg_base_adj;
					}
					else    if(temp_count_i==DATX8_DQ_LANE_LANE03)
					{
						reg_add=DDR0_PUB_DX3LCDLR0+reg_base_adj;
					}

					// for((temp_count_k=0);(temp_count_k<2);(temp_count_k++))
					{
						//if(temp_count_k==0)
						{
							dqlcdlr2_org[temp_count_i]=readl(reg_add+DDR0_PUB_DX0LCDLR2-DDR0_PUB_DX0LCDLR0);
							dqgtr_org[temp_count_i]=readl(reg_add+DDR0_PUB_DX0GTR-DDR0_PUB_DX0LCDLR0);
							dqmdlr[temp_count_i]=readl(reg_add+DDR0_PUB_ACMDLR-DDR0_PUB_DX0LCDLR0);
							dq_lcd_bdl_temp_reg_value=(((dqmdlr[temp_count_i]))&ACLCDLR_MAX)*2*((dqgtr_org[temp_count_i])&(DXNGTR_MAX))+(((dqlcdlr2_org[temp_count_i]))&ACLCDLR_MAX);
							dqqsgate_org[temp_count_i]=dq_lcd_bdl_temp_reg_value;

							printf("\ngate org==0x%08x  0x%08x   0x%08x 0x%08x\n ",dqqsgate_org[temp_count_i],dqgtr_org[temp_count_i],dqlcdlr2_org[temp_count_i], dqmdlr[temp_count_i]);

							if (ddr_gate_up_down == 0)
							{
								while (dq_lcd_bdl_temp_reg_value>0)
								{
									temp_test_error=0;
									dq_lcd_bdl_temp_reg_value--;
									printf("\ngate left temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value);
									dqgtr_temp=dq_lcd_bdl_temp_reg_value/((((dqmdlr[temp_count_i]))&ACLCDLR_MAX)*2);
									dqlcdlr2_temp=dq_lcd_bdl_temp_reg_value-dqgtr_temp*((((dqmdlr[temp_count_i]))&ACLCDLR_MAX)*2);

									writel((dqlcdlr2_temp),(reg_add+DDR0_PUB_DX0LCDLR2-DDR0_PUB_DX0LCDLR0));
									writel((((readl((reg_add+DDR0_PUB_DX0GTR-DDR0_PUB_DX0LCDLR0)))&0xfffff000)|(dqgtr_temp)),(reg_add+DDR0_PUB_DX0GTR-DDR0_PUB_DX0LCDLR0));
									printf("\n (reg_add+DDR0_PUB_DX0GTR-DDR0_PUB_DX0LCDLR0) 0x%08x gtr==0x%08x\n ",(reg_add+DDR0_PUB_DX0GTR-DDR0_PUB_DX0LCDLR0),(readl((reg_add+DDR0_PUB_DX0GTR-DDR0_PUB_DX0LCDLR0))));
									printf("\nlcdlr2==0x%08x\n ",readl(reg_add+DDR0_PUB_DX0LCDLR2-DDR0_PUB_DX0LCDLR0));
									printf("\ndqgtr_temp==0x%08x\n ",dqgtr_temp);
									printf("\ngatedqlcdlr2_temp==0x%08x\n ",dqlcdlr2_temp);
									temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
									if (temp_test_error)
									{
										printf("\ngateleft edge detect \n");
										dq_lcd_bdl_temp_reg_value++;
										break;
									}
								}
								printf("\ngate left edge detect \n");
								printf("\ngate left edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value);
								//dq_lcd_bdl_temp_reg_value_min=dq_lcd_bdl_temp_reg_value;
								dqqsgate_l[temp_count_i]=dq_lcd_bdl_temp_reg_value;
								writel(dqlcdlr2_org[temp_count_i],(reg_add+DDR0_PUB_DX0LCDLR2-DDR0_PUB_DX0LCDLR0));
								writel( dqgtr_org[temp_count_i],(reg_add+DDR0_PUB_DX0GTR-DDR0_PUB_DX0LCDLR0));

								dq_lcd_bdl_temp_reg_value=(((dqmdlr[temp_count_i]))&ACLCDLR_MAX)*2*((dqgtr_org[temp_count_i])&DXNGTR_MAX)+(((dqlcdlr2_org[temp_count_i]))&ACLCDLR_MAX);
							}
							while (dq_lcd_bdl_temp_reg_value>0)
							{
								temp_test_error=0;
								dq_lcd_bdl_temp_reg_value++;
								printf("\ngate rig temp==0x%08x\n ",dq_lcd_bdl_temp_reg_value);
								dqgtr_temp=dq_lcd_bdl_temp_reg_value/((((dqmdlr[temp_count_i]))&ACLCDLR_MAX)*2);
								dqlcdlr2_temp=dq_lcd_bdl_temp_reg_value-dqgtr_temp*((((dqmdlr[temp_count_i]))&ACLCDLR_MAX)*2);

								writel((dqlcdlr2_temp),(reg_add+DDR0_PUB_DX0LCDLR2-DDR0_PUB_DX0LCDLR0));
								writel(((readl((reg_add+DDR0_PUB_DX0GTR-DDR0_PUB_DX0LCDLR0)))&0xfffff000)|(dqgtr_temp),(reg_add+DDR0_PUB_DX0GTR-DDR0_PUB_DX0LCDLR0));
								printf("\n (reg_addDDR0_PUB_DX0GTR) 0x%08x gtr==0x%08x\n ",(reg_add+DDR0_PUB_DX0GTR-DDR0_PUB_DX0LCDLR0),(readl((reg_add+DDR0_PUB_DX0GTR-DDR0_PUB_DX0LCDLR0))));
								printf("\nlcdlr2==0x%08x\n ",readl(reg_add+DDR0_PUB_DX0LCDLR2-DDR0_PUB_DX0LCDLR0));
								printf("\ndqgtr_temp==0x%08x\n ",dqgtr_temp);
								printf("\ngatedqlcdlr2_temp==0x%08x\n ",dqlcdlr2_temp);
								temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
								if (temp_test_error)
								{
									printf("\ngaterig edge detect \n");
									dq_lcd_bdl_temp_reg_value++;
									break;
								}
							}
							printf("\ngate rig edge detect \n");
							printf("\ngate rig edge==0x%08x\n ",dq_lcd_bdl_temp_reg_value);
							//dq_lcd_bdl_temp_reg_value_max=dq_lcd_bdl_temp_reg_value;
							dqqsgate_r[temp_count_i]=dq_lcd_bdl_temp_reg_value;
							writel(dqlcdlr2_org[temp_count_i],(reg_add+DDR0_PUB_DX0LCDLR2-DDR0_PUB_DX0LCDLR0));
							writel( dqgtr_org[temp_count_i],(reg_add+DDR0_PUB_DX0GTR-DDR0_PUB_DX0LCDLR0));






						}



					}
				}

			}
		}

		////tune and save training dqs value




		////calculate and print  dqs value
		for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
		{
			if (( channel_a_en) && ( channel_b_en == 0))
			{
				reg_base_adj=CHANNEL_A_REG_BASE;
			}
			else if(( channel_b_en)&&( channel_a_en==0))
			{
				reg_base_adj=CHANNEL_B_REG_BASE;
			}
			else if ((channel_a_en+channel_b_en)==2)
			{
				if ( testing_channel == CHANNEL_A)
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if( testing_channel==CHANNEL_B)
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
			}
			reg_add=DDR0_PUB_DX0LCDLR0+reg_base_adj;




			printf("\n ddrtest size ==0x%08x, test times==0x%08x,test_loop==0x%08x\n",ddr_test_size,(test_times+1),test_loop);
			printf("\n add  0x00000000 reg==    org           lef           rig           center        win           lef_m         rig_m         min_c         min_win        \n");

			for ((temp_count_i=0);(temp_count_i<DATX8_DQ_LANE_WIDTH);(temp_count_i++))
			{
				{

					if (temp_count_i == DATX8_DQ_LANE_LANE00)
					{
						reg_add=DDR0_PUB_DX0LCDLR0+reg_base_adj+0*4;}

					else    if(temp_count_i==DATX8_DQ_LANE_LANE01)
					{
						reg_add=DDR0_PUB_DX1LCDLR0+reg_base_adj+0*4;}

					else   	 if(temp_count_i==DATX8_DQ_LANE_LANE02)
					{
						reg_add=DDR0_PUB_DX2LCDLR0+reg_base_adj+0*4;}
					else    if(temp_count_i==DATX8_DQ_LANE_LANE03)
					{
						reg_add=DDR0_PUB_DX3LCDLR0+reg_base_adj+0*4;}
				}

				//unsigned int   dqgtr_org[4],dqlcdlr2_org[4],dqgtr_l[4],dqlcdlr2_l[4],dqgtr_r[4],dqlcdlr2_r[4],dqmdlr[4];
				//	 unsigned int dqgtr_temp;
				//	  unsigned int dqlcdlr2_temp;
				//	  unsigned int dqqsgate_l[4], dqqsgate_r[4];
				(dqgtr_l[temp_count_i])=(dqqsgate_l[temp_count_i])/((((dqmdlr[temp_count_i]))&ACLCDLR_MAX)*2);
				(dqlcdlr2_l[temp_count_i])=(dqqsgate_l[temp_count_i])-(dqgtr_l[temp_count_i])*((((dqmdlr[temp_count_i]))&ACLCDLR_MAX)*2);
				(dqgtr_r[temp_count_i])=(dqqsgate_r[temp_count_i])/((((dqmdlr[temp_count_i]))&ACLCDLR_MAX)*2);
				(dqlcdlr2_r[temp_count_i])=(dqqsgate_r[temp_count_i])-(dqgtr_r[temp_count_i])*((((dqmdlr[temp_count_i]))&ACLCDLR_MAX)*2);
				printf("\n add  reg==    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x    0x%08x\n",
						(dqqsgate_org[temp_count_i]),
						(dqqsgate_l[temp_count_i]),
						(dqqsgate_r[temp_count_i]),
						(dqgtr_org[temp_count_i]),
						(dqlcdlr2_org[temp_count_i]),
						(dqgtr_l[temp_count_i]),
						(dqgtr_r[temp_count_i]),
						(dqlcdlr2_l[temp_count_i]),
						(dqlcdlr2_r[temp_count_i])
					  );


			}





		}

	}




	return 0;

usage:
	cmd_usage(cmdtp);
	return 1;

}


U_BOOT_CMD(
	ddrtest_gate,	7,	1,	do_ddrtest_find_gate_wind,
	"DDR test function should dcache off ddrtest_gate a 0 0x80000 1 0 3",
	"ddrtest_gate [LOOP] [ADDR].Default address is 0x10000000\n"
);


#endif

///*
int do_ddr_test_ac_windows_bdlr(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter Test ddr ac bdlr windows function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);
	//  unsigned int   loop = 1;
	//   unsigned int   temp_count_i = 1;
	//   unsigned int   temp_count_j= 1;
	//    unsigned int   temp_count_k= 1;
	unsigned int   temp_test_error= 0;
	static unsigned int soft_ca_training_seed=0;
	static unsigned int soft_ca_training_step=0;

	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_loop=1;
	unsigned int   test_times=1;
	unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;
	unsigned int   testing_channel = 0;

#define  CHANNEL_A  0
#define  CHANNEL_B  1
#define  DDR_CORSS_TALK_TEST_SIZE   0x20000

	unsigned int  ac_mdlr_a_org=0;
	unsigned int  ac_mdlr_b_org=0;

	unsigned int  ac_lcdlr_a_org=0;
	unsigned int   ac_bdlr0_a_org=0;
	unsigned int  ac_lcdlr_b_org=0;
	unsigned int   ac_bdlr0_b_org=0;
	unsigned int  ac_lcdlr_a_rig=0;
	unsigned int   ac_bdlr0_a_rig=0;
	unsigned int  ac_lcdlr_b_rig=0;
	unsigned int   ac_bdlr0_b_rig=0;
	unsigned int  ac_lcdlr_a_lef=0;
	unsigned int   ac_bdlr0_a_lef=0;
	unsigned int  ac_lcdlr_b_lef=0;
	unsigned int   ac_bdlr0_b_lef=0;

	unsigned int  ac_lcdlr_a_rig_min=0;
	unsigned int   ac_bdlr0_a_rig_min=0;
	unsigned int  ac_lcdlr_b_rig_min=0;
	unsigned int   ac_bdlr0_b_rig_min=0;
	unsigned int  ac_lcdlr_a_lef_min=0;
	unsigned int   ac_bdlr0_a_lef_min=0;
	unsigned int  ac_lcdlr_b_lef_min=0;
	unsigned int   ac_bdlr0_b_lef_min=0;
	//   unsigned int  ac_lcdlr_temp;
	//  unsigned int   ac_bdlr0_temp=0;



	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;

	unsigned int   ac_bdlr_lef[10];
	unsigned int   ac_bdlr_rig[10];
	unsigned int   ac_bdlr_temp_value;
	unsigned int   ac_bdlr_reg_seed_value;
	unsigned int   ac_bdlr_temp_reg_value;
	//  unsigned int   temp_test_error;
	unsigned int temp_i=0;
	unsigned int temp_j=0;
	//unsigned int reg_add=0;
	//		static unsigned int soft_ca_training_enabled=1;

	//#define DDR_TEST_ACLCDLR


	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))

		{channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))

		{channel_b_en = 1;
		}
		else
		{
			goto usage;
		}
	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))

		{channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

		{channel_b_en = 1;
		}
	}
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}

	}
	if (argc >4) {
		test_loop = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
		{
			test_loop = 1;
		}
		if   ((strcmp(argv[4], "l") == 0) || (strcmp(argv[4], "L") == 0))
		{
			test_loop = 100000;
		}
	}

	if (argc >5) {
		soft_ca_training_seed = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
		{
			soft_ca_training_seed = 0x1f;
		}


	}
	if (argc >6) {
		soft_ca_training_step = simple_strtoull_ddr(argv[6], &endp, 16);
		if (*argv[6] == 0 || *endp != 0)
		{
			soft_ca_training_step = 0;
		}


	}
	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_loop== 0x%08x\n", test_loop);
	printf("\nsoft_ca_training_seed== 0x%08x\n", soft_ca_training_seed);
	printf("\nsoft_ca_training_step== 0x%08x\n", soft_ca_training_step);
	if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}

	//save and print org training dqs value
	if (channel_a_en || channel_b_en)
	{


		//dcache_disable();
		//serial_puts("\ndebug for ddrtest ,jiaxing disable dcache");

		{
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{
				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
						reg_add=DDR0_PUB_ACMDLR+reg_base_adj;



					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;

						reg_add=DDR0_PUB_ACMDLR+reg_base_adj;



					}
				}

				reg_add=DDR0_PUB_ACMDLR+reg_base_adj;


				if (reg_base_adj == CHANNEL_A_REG_BASE)
				{
					printf("\ntest A channel 0x%08x\n",reg_add);
					ac_mdlr_a_org=(unsigned int )(readl((unsigned int )reg_add));//readl(reg_add);//0xc8836000
					ac_lcdlr_a_org=(unsigned int )(readl((unsigned int )(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR)));//readl(reg_add+4);
					ac_bdlr0_a_org=(unsigned int )(readl((unsigned int )(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR)));//readl(reg_add+8);

					printf("\n ac_mdlr_org  0x%08x reg== 0x%08x\n",(reg_add), ac_mdlr_a_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_a_org);
					printf("\n ac_bdlr0_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_a_org);
				}
				if (reg_base_adj == CHANNEL_B_REG_BASE)
				{

					ac_mdlr_b_org=readl(reg_add);
					ac_lcdlr_b_org=readl(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR);
					ac_bdlr0_b_org=readl(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR);
					printf("\n ac_mdlr_org  0x%08x reg== 0x%08x\n",(reg_add), ac_mdlr_b_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_b_org);
					printf("\n ac_bdlr0_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_b_org);
				}


			}

		}

	}////save and print org training  value


	for (test_times=0;(test_times<test_loop);(test_times++))
	{
		////tune and save training dqs value
		if (channel_a_en || channel_b_en)
		{
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{
				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;
					}
				}

				if (reg_base_adj == CHANNEL_A_REG_BASE)
				{
					printf("\ntest A channel AC\n");
				}
				else
				{
					printf("\ntest B channel AC\n");
				}


#define wrr_reg(addr, data)	(*((volatile  unsigned int  *)((unsigned long)(unsigned int )addr)))=(data)  //wr_reg(addr, data)
#define rdr_reg(addr)		 (unsigned int )(*((volatile  unsigned int  *)((unsigned long)(unsigned int )addr)))  //rd_reg(addr)
				//wr_reg(DDR0_PUB_ACBDLR3, 0x0808);  //cs0 cs1
				//wr_reg(DDR0_PUB_ACBDLR0, 0x1f);  //ck0
				//	wr_reg(DDR0_PUB_ACBDLR4, 0x0808); //odt0 odt1
				//wr_reg(DDR0_PUB_ACBDLR5, 0x0808);  //cke0 cke1


				//wr_reg(DDR0_PUB_ACBDLR1, 0x181818); //ras cas we
				//wr_reg(DDR0_PUB_ACBDLR2, 0x181818); //ba0 ba1 ba2
				//wr_reg(DDR0_PUB_ACBDLR6, 0x12121212); //a0 a1 a2 a3
				//wr_reg(DDR0_PUB_ACBDLR7, 0x0d0d0d0d); //a4 a5 a6 a7
				//wr_reg(DDR0_PUB_ACBDLR8, 0x10101010);  //a8 a9 a10 a11
				//wr_reg(DDR0_PUB_ACBDLR9, 0x18181818);  //a12 a13 a14 a15
				reg_add=DDR0_PUB_ACBDLR0;
				ac_bdlr_reg_seed_value=(soft_ca_training_seed|(soft_ca_training_seed<<8)|(soft_ca_training_seed<<16)|(soft_ca_training_seed<<24));
				for ((  temp_i=0);(temp_i<10);( temp_i++))
				{
					//wr_reg((DDR0_PUB_ACBDLR0+temp_i*4),
					//ac_bdlr_reg_seed_value);  //cs0 cs1
					//reg_add=reg_add+temp_i*4;

					//reg_add=DDR0_PUB_ACMDLR+reg_base_adj;
					reg_add=(DDR0_PUB_ACBDLR0+temp_i*4);
					reg_add=reg_add+reg_base_adj;
					wrr_reg((reg_add),
							ac_bdlr_reg_seed_value);  //cs0 cs1
					ac_bdlr_lef[temp_i]=ac_bdlr_reg_seed_value;
					ac_bdlr_rig[temp_i]=ac_bdlr_reg_seed_value;
				}

				printf("\nbdl  soft_ca_training_step==0x%08x\n ",soft_ca_training_step);
				for (( temp_i=0);(temp_i<10);( temp_i++))
				{
					//ac_bdlr_temp_value=rdr_reg((unsigned int )reg_add);
					if (temp_i == 1)
					{
						//temp_i=3;
					}

					for (( temp_j=0);(temp_j<4);( temp_j++))
					{
						if (soft_ca_training_step)
						{
							temp_i=(soft_ca_training_step>>2);
							temp_j=soft_ca_training_step-((soft_ca_training_step>>2)<<2);
							soft_ca_training_step=0;
						}
						if ((temp_i*4+temp_j) == 1)
						{
							temp_i=1;
							temp_j=0;
						}
						if ((temp_i*4+temp_j) == 7)
						{
							temp_i=2;
							temp_j=0;
						}
						if ((temp_i*4+temp_j) == 14)
						{
							temp_i=4;
							temp_j=0;
						}
						if ((temp_i*4+temp_j) == 18)
						{
							temp_i=5;
							temp_j=0;
						}
						if ((temp_i*4+temp_j) == 22)
						{
							temp_i=6;
							temp_j=0;
						}
						//printf("\nbdl  temp_i==0x%08x\n ",temp_i);
						printf("\nbdl  temp_ij==0x%08x\n ",(temp_i*4+temp_j));
						reg_add=(DDR0_PUB_ACBDLR0+temp_i*4);
						reg_add=reg_add+reg_base_adj;
						ac_bdlr_temp_reg_value=rdr_reg((unsigned int )reg_add);
						ac_bdlr_temp_value=((ac_bdlr_temp_reg_value>>(temp_j<<3))&ACBDLR_MAX);
						while (ac_bdlr_temp_value>0)
						{
							temp_test_error=0;
							ac_bdlr_temp_value--;

							printf("\nbdl  temp_ij==0x%08x lef temp==0x%08x\n ",(temp_i*4+temp_j),ac_bdlr_temp_value);

							ac_bdlr_temp_reg_value=(((~(0xff<<(temp_j<<3)))&ac_bdlr_reg_seed_value)|((ac_bdlr_temp_value)<<(temp_j<<3)));
							reg_add=(DDR0_PUB_ACBDLR0+temp_i*4);
							reg_add=reg_add+reg_base_adj;
							wrr_reg((unsigned int )reg_add,
									ac_bdlr_temp_reg_value);
							printf("\nbdl reg_add 0x%08x== 0x%08x\n ",reg_add,ac_bdlr_temp_reg_value);

#ifdef DDR_LCDLR_CK_USE_FAST_PATTERN
							temp_test_error=ddr_test_s_add_cross_talk_pattern(ddr_test_size);
#else
							temp_test_error= ddr_test_s_add_cross_talk_pattern(ddr_test_size);
							temp_test_error= temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
#endif
							if (temp_test_error)
							{
								printf("\nbdl left edge detect \n");
								ac_bdlr_temp_value++;
								break;
							}
						}

						printf("\nbdl left edge detect \n");
						printf("\n\nbdl  temp_ij==0x%08x          bdl left edge==0x%08x\n ",(temp_i*4+temp_j),ac_bdlr_temp_value);
						reg_add=(DDR0_PUB_ACBDLR0+temp_i*4);
						reg_add=reg_add+reg_base_adj;
						wrr_reg((unsigned int )reg_add,
								ac_bdlr_reg_seed_value);

						ac_bdlr_temp_reg_value=(((~(0xff<<(temp_j<<3)))&ac_bdlr_lef[temp_i])|((ac_bdlr_temp_value)<<(temp_j<<3)));
						ac_bdlr_lef[temp_i]=ac_bdlr_temp_reg_value;

						ac_bdlr_temp_value=((ac_bdlr_reg_seed_value>>(temp_j<<3))&ACBDLR_MAX);
						while (ac_bdlr_temp_value<ACBDLR_MAX)
						{
							temp_test_error=0;
							ac_bdlr_temp_value++;
							printf("\ntemp_ij==0x%08x rig temp==0x%08x\n ",(temp_i*4+temp_j),ac_bdlr_temp_value);

							ac_bdlr_temp_reg_value=(((~(0xff<<(temp_j<<3)))&ac_bdlr_reg_seed_value)|((ac_bdlr_temp_value)<<(temp_j<<3)));
							reg_add=(DDR0_PUB_ACBDLR0+temp_i*4);
							reg_add=reg_add+reg_base_adj;
							wrr_reg((unsigned int )reg_add,
									ac_bdlr_temp_reg_value);
							printf("\nbdl reg_add 0x%08x== 0x%08x\n ",reg_add,ac_bdlr_temp_reg_value);
#ifdef DDR_LCDLR_CK_USE_FAST_PATTERN
							temp_test_error=ddr_test_s_add_cross_talk_pattern(ddr_test_size);
#else
							temp_test_error= ddr_test_s_add_cross_talk_pattern(ddr_test_size);
							temp_test_error= temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
#endif
							if (temp_test_error)
							{
								printf("\nbdl rig edge detect \n");
								ac_bdlr_temp_value--;
								break;
							}
						}



						printf("\nbdl rig edge detect \n");
						//printf("\n\nbdl rig edge==0x%08x\n ",ac_bdlr_temp_value);
						printf("\n\nbdl  temp_ij==0x%08x          bdl righ edge==0x%08x\n ",(temp_i*4+temp_j),ac_bdlr_temp_value);
						reg_add=(DDR0_PUB_ACBDLR0+temp_i*4);
						reg_add=reg_add+reg_base_adj;
						wrr_reg((unsigned int )reg_add,
								ac_bdlr_reg_seed_value);

						ac_bdlr_temp_reg_value=(((~(0xff<<(temp_j<<3)))&ac_bdlr_rig[temp_i])|((ac_bdlr_temp_value)<<(temp_j<<3)));
						ac_bdlr_rig[temp_i]=ac_bdlr_temp_reg_value;
					}
				}

				printf("\nbdl lef edge==bdlr0     bdlr1     bdlr2     bdlr3     bdlr4     bdlr5     bdlr6     bdlr7     bdlr8     bdlr9     \n ");
				printf("\nbdl lef edge==\n");
				for (( temp_i=0);(temp_i<10);( temp_i++))
				{

					printf("0x%08x\n ",ac_bdlr_lef[temp_i]);

				}

				printf("\n ");
				for (( temp_i=0);(temp_i<10);( temp_i++))
				{
					printf("0x%08x\n ",ac_bdlr_rig[temp_i]);
				}
				printf("\nbdl rig edge===========\n");
				printf("\n===================\n");

				printf("\nbdl lef edge==\n");
				for (( temp_i=0);(temp_i<10);( temp_i++))
				{
					for (( temp_j=0);(temp_j<4);( temp_j++))
					{
						if ((temp_i*4+temp_j) == 1)
						{
							temp_i=1;
							temp_j=0;
						}
						if ((temp_i*4+temp_j) == 7)
						{
							temp_i=2;
							temp_j=0;
						}
						if ((temp_i*4+temp_j) == 14)
						{
							temp_i=4;
							temp_j=0;
						}
						if ((temp_i*4+temp_j) == 18)
						{
							temp_i=5;
							temp_j=0;
						}
						if ((temp_i*4+temp_j) == 22)
						{
							temp_i=6;
							temp_j=0;
						}
						ac_bdlr_temp_reg_value=((((0xff<<(temp_j<<3)))&ac_bdlr_lef[temp_i])>>(temp_j<<3));
						printf("\ntempi_j0x%08x==0x%08x",((temp_i<<2)+temp_j),ac_bdlr_temp_reg_value);
					}
				}

				printf("\n ");
				printf("\nbdl rig edge==\n");
				for (( temp_i=0);(temp_i<10);( temp_i++))
				{
					for (( temp_j=0);(temp_j<4);( temp_j++))
					{
						if ((temp_i*4+temp_j) == 1)
						{
							temp_i=1;
							temp_j=0;
						}
						if ((temp_i*4+temp_j) == 7)
						{
							temp_i=2;
							temp_j=0;
						}
						if ((temp_i*4+temp_j) == 14)
						{
							temp_i=4;
							temp_j=0;
						}
						if ((temp_i*4+temp_j) == 18)
						{
							temp_i=5;
							temp_j=0;
						}
						if ((temp_i*4+temp_j) == 22)
						{
							temp_i=6;
							temp_j=0;
						}
						ac_bdlr_temp_reg_value=((((0xff<<(temp_j<<3)))&ac_bdlr_rig[temp_i])>>(temp_j<<3));
						printf("\ntempi_j0x%08x==0x%08x",((temp_i<<2)+temp_j),ac_bdlr_temp_reg_value);
					}
				}
			}

			////tune and save training dqs value
			////calculate and print  dqs value
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{
				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;
					}
				}
				reg_add=DDR0_PUB_ACMDLR+reg_base_adj;

				if (reg_base_adj == CHANNEL_A_REG_BASE)
				{
					if (test_times)
					{
						if (ac_lcdlr_a_lef>ac_lcdlr_a_lef_min)
							ac_lcdlr_a_lef_min=ac_lcdlr_a_lef;

						if (ac_lcdlr_a_rig<ac_lcdlr_a_rig_min)
							ac_lcdlr_a_rig_min=ac_lcdlr_a_rig;

						if (ac_bdlr0_a_lef>ac_bdlr0_a_lef_min)
							ac_bdlr0_a_lef_min=ac_bdlr0_a_lef;

						if (ac_bdlr0_a_rig<ac_bdlr0_a_rig_min)
							ac_bdlr0_a_rig_min=ac_bdlr0_a_rig;
					}
					else
					{
						ac_lcdlr_a_lef_min=ac_lcdlr_a_lef;
						ac_lcdlr_a_rig_min=ac_lcdlr_a_rig;
						ac_bdlr0_a_lef_min=ac_bdlr0_a_lef;
						ac_bdlr0_a_rig_min=ac_bdlr0_a_rig;
					}
					printf("\ntest A channel AC result\n");
					printf("\n ac_mdlr_org  0x%08x reg== 0x%08x\n",(reg_add), ac_mdlr_a_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_a_org);
					printf("\n ac_bdlr0_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_a_org);

					printf("\n ac_acmdlr_org  0x%08x reg== 0x%08x   lcdlr_lef   lcdlr_rig   lcdlr_lmin  lcdlr_rmin\n",(reg_add),ac_mdlr_a_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x  0x%08x  0x%08x  0x%08x  0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_a_org,ac_lcdlr_a_lef,ac_lcdlr_a_rig,ac_lcdlr_a_lef_min,ac_lcdlr_a_rig_min);
					printf("\n ac_bdlr0_a_org  0x%08x reg== 0x%08x  0x%08x  0x%08x  0x%08x  0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_a_org,ac_bdlr0_a_lef,ac_bdlr0_a_rig,ac_bdlr0_a_lef_min,ac_bdlr0_a_rig_min);
				}

				if (reg_base_adj == CHANNEL_B_REG_BASE)
				{
					if (test_times)
					{
						if (ac_lcdlr_b_lef>ac_lcdlr_b_lef_min)
							ac_lcdlr_b_lef_min=ac_lcdlr_b_lef;

						if (ac_lcdlr_b_rig<ac_lcdlr_b_rig_min)
							ac_lcdlr_b_rig_min=ac_lcdlr_b_rig;

						if (ac_bdlr0_b_lef>ac_bdlr0_b_lef_min)
							ac_bdlr0_b_lef_min=ac_bdlr0_b_lef;

						if (ac_bdlr0_b_rig<ac_bdlr0_b_rig_min)
							ac_bdlr0_b_rig_min=ac_bdlr0_b_rig;
					}
					else
					{
						ac_lcdlr_b_lef_min=ac_lcdlr_b_lef;
						ac_lcdlr_b_rig_min=ac_lcdlr_b_rig;
						ac_bdlr0_b_lef_min=ac_bdlr0_b_lef;
						ac_bdlr0_b_rig_min=ac_bdlr0_b_rig;
					}
					printf("\ntest B channel AC result\n");
					printf("\n ac_mdlr_org  0x%08x reg== 0x%08x\n",(reg_add), ac_mdlr_b_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_b_org);
					printf("\n ac_bdlr0_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_b_org);

					printf("\n ac_acmdlr_org  0x%08x reg== 0x%08x   lcdlr_lef   lcdlr_rig   lcdlr_lmin  lcdlr_rmin\n",(reg_add),ac_mdlr_b_org);
					printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x  0x%08x  0x%08x  0x%08x  0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_b_org,ac_lcdlr_b_lef,ac_lcdlr_b_rig,ac_lcdlr_b_lef_min,ac_lcdlr_b_rig_min);
					printf("\n ac_bdlr0_a_org  0x%08x reg== 0x%08x  0x%08x  0x%08x  0x%08x  0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_b_org,ac_bdlr0_b_lef,ac_bdlr0_b_rig,ac_bdlr0_b_lef_min,ac_bdlr0_b_rig_min);
				}
			}
		}

	}




	return 0;

usage:
	cmd_usage(cmdtp);
	return 1;

}


U_BOOT_CMD(
	ddr_tune_ddr_ac_bdlr,	7,	1,	do_ddr_test_ac_windows_bdlr,
	"DDR tune ac bdl function",
	"ddr_tune_ddr_ac_bdlr a 0 0x8000000 1 seed step or ddr_tune_ddr_ac_bdlr b 0 0x800000 1 seed step or ddr_tune_ddr_ac_acbdlr_ck a b 0x80000 l\n dcache off ? \n"
);


#if ( CONFIG_DDR_PHY >= P_DDR_PHY_G12)
#else
int do_ddr_test_vref(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter Test ddr vref function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);


	//  unsigned int   loop = 1;
	//   unsigned int   temp_count_i = 1;
	//   unsigned int   temp_count_j= 1;
	//    unsigned int   temp_count_k= 1;
	unsigned int   temp_test_error= 0;
	static unsigned int training_seed=0;
	static unsigned int training_step=0;

	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_loop=1;
	unsigned int   test_times=1;
	unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;
	unsigned int   testing_channel = 0;



#define  CHANNEL_A  0
#define  CHANNEL_B  1
#define  DDR_CORSS_TALK_TEST_SIZE   0x20000

	unsigned int  ac_mdlr_a_org=0;
	unsigned int  ac_mdlr_b_org=0;

	unsigned int  ac_lcdlr_a_org=0;
	unsigned int   ac_bdlr0_a_org=0;
	unsigned int  ac_lcdlr_b_org=0;
	unsigned int   ac_bdlr0_b_org=0;
	//  unsigned int  ac_lcdlr_a_rig=0;
	//  unsigned int   ac_bdlr0_a_rig=0;
	//  unsigned int  ac_lcdlr_b_rig=0;
	//  unsigned int   ac_bdlr0_b_rig=0;
	//  unsigned int  ac_lcdlr_a_lef=0;
	//  unsigned int   ac_bdlr0_a_lef=0;
	//  unsigned int  ac_lcdlr_b_lef=0;
	//  unsigned int   ac_bdlr0_b_lef=0;

	//	  unsigned int  ac_lcdlr_a_rig_min=0;
	//  unsigned int   ac_bdlr0_a_rig_min=0;
	//  unsigned int  ac_lcdlr_b_rig_min=0;
	//  unsigned int   ac_bdlr0_b_rig_min=0;
	//  unsigned int  ac_lcdlr_a_lef_min=0;
	//  unsigned int   ac_bdlr0_a_lef_min=0;
	//  unsigned int  ac_lcdlr_b_lef_min=0;
	//  unsigned int   ac_bdlr0_b_lef_min=0;
	//   unsigned int  ac_lcdlr_temp;
	//  unsigned int   ac_bdlr0_temp=0;



	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;

	//   unsigned int   ac_bdlr_lef[10];
	//   unsigned int   ac_bdlr_rig[10];
	unsigned int   iovref_temp_value;
	unsigned int   iovref_temp_reg_value;
	unsigned int  reg_seed_value;
	//	   unsigned int   temp_reg_value;
	unsigned int   iovref_lef;
	unsigned int   iovref_rig;
	//  unsigned int   temp_test_error;
	//	unsigned int temp_i=0;
	//	unsigned int temp_j=0;
	//unsigned int reg_add=0;
	//		static unsigned int training_enabled=1;

	//	 iovref_lef=0x49;
	// printf("\n\n iovref  org                     ==0x%08x   %08dmV\n",iovref_lef,(((((iovref_lef&0X3F)*7)+440)*3)/2)+1);
	//#define DDR_TEST_ACLCDLR


	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))
		{
			channel_a_en = 1;
		}
		else if ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))
		{
			channel_b_en = 1;
		}
		else
		{
			goto usage;
		}
	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))
		{
			channel_a_en = 1;
		}
		if ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

		{
			channel_b_en = 1;
		}
	}
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}

	}
	if (argc >4) {
		test_loop = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
		{
			test_loop = 1;
		}
		if   ((strcmp(argv[4], "l") == 0) || (strcmp(argv[4], "L") == 0))
		{
			test_loop = 100000;
		}
	}
	training_seed = 0x49;
	if (argc >5) {
		training_seed = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
		{
			training_seed = 0x49;
		}


	}

	printf("\n\n iovref  training_seed             ==0x%08x   %08dmV\n",training_seed,(((((training_seed&0X3F)*7)+440)*3)/2)+1);

	training_step = 0;
	if (argc >6) {
		training_step = simple_strtoull_ddr(argv[6], &endp, 16);
		if (*argv[6] == 0 || *endp != 0)
		{
			training_step = 0;
		}
	}
	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_loop== 0x%08x\n", test_loop);
	if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}

	//save and print org training dqs value
	if (channel_a_en || channel_b_en)
	{
		//dcache_disable();
		//serial_puts("\ndebug for ddrtest ,jiaxing disable dcache");

		for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
		{
			if (( channel_a_en) && ( channel_b_en == 0))
			{
				reg_base_adj=CHANNEL_A_REG_BASE;
			}
			else if(( channel_b_en)&&( channel_a_en==0))
			{
				reg_base_adj=CHANNEL_B_REG_BASE;
			}
			else if ((channel_a_en+channel_b_en)==2)
			{
				if ( testing_channel == CHANNEL_A)
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
					reg_add=DDR0_PUB_ACMDLR+reg_base_adj;
				}
				else if( testing_channel==CHANNEL_B)
				{
					reg_base_adj=CHANNEL_B_REG_BASE;

					reg_add=DDR0_PUB_ACMDLR+reg_base_adj;
				}
			}

			reg_add=DDR0_PUB_ACMDLR+reg_base_adj;

			if (reg_base_adj == CHANNEL_A_REG_BASE)
			{
				printf("\ntest A channel 0x%08x\n",reg_add);
				ac_mdlr_a_org=(unsigned int )(readl((unsigned int )reg_add));//readl(reg_add);//0xc8836000
				ac_lcdlr_a_org=(unsigned int )(readl((unsigned int )(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR)));//readl(reg_add+4);
				ac_bdlr0_a_org=(unsigned int )(readl((unsigned int )(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR)));//readl(reg_add+8);

				printf("\n ac_mdlr_org  0x%08x reg== 0x%08x\n",(reg_add), ac_mdlr_a_org);
				printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_a_org);
				printf("\n ac_bdlr0_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_a_org);
			}
			if (reg_base_adj == CHANNEL_B_REG_BASE)
			{

				ac_mdlr_b_org=readl(reg_add);
				ac_lcdlr_b_org=readl(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR);
				ac_bdlr0_b_org=readl(reg_add+8);
				printf("\n ac_mdlr_org  0x%08x reg== 0x%08x\n",(reg_add), ac_mdlr_b_org);
				printf("\n ac_lcdlr_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACLCDLR-DDR0_PUB_ACMDLR), ac_lcdlr_b_org);
				printf("\n ac_bdlr0_org  0x%08x reg== 0x%08x\n",(reg_add+DDR0_PUB_ACBDLR0-DDR0_PUB_ACMDLR), ac_bdlr0_b_org);
			}


		}


	}////save and print org training  value


	for (test_times=0;(test_times<test_loop);(test_times++))
	{
		////tune and save training dqs value
		if (channel_a_en || channel_b_en)
		{
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{
				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;
					}
				}

				if (reg_base_adj == CHANNEL_A_REG_BASE)
				{
					printf("\ntest A channel AC\n");
				}
				else
				{
					printf("\ntest B channel AC\n");
				}


#define wrr_reg(addr, data)	(*((volatile  unsigned int  *)((unsigned long)(unsigned int )addr)))=(data)  //wr_reg(addr, data)
#define rdr_reg(addr)		 (unsigned int )(*((volatile  unsigned int  *)((unsigned long)(unsigned int )addr)))  //rd_reg(addr)
				//wr_reg(DDR0_PUB_ACBDLR3, 0x0808);  //cs0 cs1
				//wr_reg(DDR0_PUB_ACBDLR0, 0x1f);  //ck0
				//	wr_reg(DDR0_PUB_ACBDLR4, 0x0808); //odt0 odt1
				//wr_reg(DDR0_PUB_ACBDLR5, 0x0808);  //cke0 cke1


				//wr_reg(DDR0_PUB_ACBDLR1, 0x181818); //ras cas we
				//wr_reg(DDR0_PUB_ACBDLR2, 0x181818); //ba0 ba1 ba2
				//wr_reg(DDR0_PUB_ACBDLR6, 0x12121212); //a0 a1 a2 a3
				//wr_reg(DDR0_PUB_ACBDLR7, 0x0d0d0d0d); //a4 a5 a6 a7
				//wr_reg(DDR0_PUB_ACBDLR8, 0x10101010);  //a8 a9 a10 a11
				//wr_reg(DDR0_PUB_ACBDLR9, 0x18181818);  //a12 a13 a14 a15
				reg_add=DDR0_PUB_IOVCR0;
				reg_seed_value=(training_seed|(training_seed<<8)|(training_seed<<16)|(training_seed<<24));
				//for((  temp_i=0);(temp_i<10);( temp_i++))
				//wr_reg((DDR0_PUB_ACBDLR0+temp_i*4),
				//ac_bdlr_reg_seed_value);  //cs0 cs1
				//reg_add=reg_add+temp_i*4;

				//reg_add=DDR0_PUB_ACMDLR+reg_base_adj;
				//reg_add=(DDR0_PUB_ACBDLR0+temp_i*4);
				reg_add=reg_add+reg_base_adj;
				iovref_temp_value=rdr_reg((unsigned int )reg_add);
				iovref_temp_value=((iovref_temp_value)&0xff);
				//	 iovref_lef=0x49;
				if (iovref_temp_value)
				{
					printf("\n\n iovref  org                     ==0x%08x   %08dmV\n",iovref_temp_value,(((((iovref_temp_value&0X3F)*7)+440)*3)/2)+1);
				}
				else
				{
					printf("\nio vref power down ,use external resister \n ");
				}

				wrr_reg((reg_add),
						reg_seed_value);  //

				wrr_reg((reg_add+4),
						reg_seed_value);  //
				iovref_lef=training_seed;
				iovref_rig=training_seed;

				printf("\ntraining_step==0x%08x\n ",training_step);

				iovref_temp_value=rdr_reg((unsigned int )reg_add);
				iovref_temp_value=((iovref_temp_value)&0xff);
				while (iovref_temp_value>0x40)
				{
					temp_test_error=0;
					iovref_temp_value--;

					printf("\niovref lef temp==0x%08x\n ",iovref_temp_value);

					iovref_temp_reg_value=(iovref_temp_value|(iovref_temp_value<<8)|(iovref_temp_value<<16)|(iovref_temp_value<<24));;
					wrr_reg((reg_add),
							iovref_temp_reg_value);  //

					wrr_reg((reg_add+DDR0_PUB_IOVCR1-DDR0_PUB_IOVCR0),
							iovref_temp_reg_value);  //
					printf("\n reg_add 0x%08x== 0x%08x\n ",reg_add,iovref_temp_reg_value);
					temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
					temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
					if (temp_test_error)
					{
						printf("\nvref down edge detect \n");
						iovref_temp_value++;
						break;
					}
				}

				printf("\n down edge detect \n");
				printf("\n\n iovref                       down edge==0x%08x\n ",iovref_temp_value);
				iovref_lef=iovref_temp_value;

				wrr_reg((reg_add),
						reg_seed_value);  //

				wrr_reg((reg_add+DDR0_PUB_IOVCR1-DDR0_PUB_IOVCR0),
						reg_seed_value);  //

				iovref_temp_value=rdr_reg((unsigned int )reg_add);
				iovref_temp_value=((iovref_temp_value)&0xff);


				while (iovref_temp_value<0x7f)
				{
					temp_test_error=0;
					iovref_temp_value++;

					printf("\niovref lef temp==0x%08x\n ",iovref_temp_value);

					iovref_temp_reg_value=(iovref_temp_value|(iovref_temp_value<<8)|(iovref_temp_value<<16)|(iovref_temp_value<<24));;
					wrr_reg((reg_add),
							iovref_temp_reg_value);  //

					wrr_reg((reg_add+DDR0_PUB_IOVCR1-DDR0_PUB_IOVCR0),
							iovref_temp_reg_value);  //
					printf("\n reg_add 0x%08x== 0x%08x\n ",reg_add,iovref_temp_reg_value);

					temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
					temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
					if (temp_test_error)
					{
						printf("\nvref up edge detect \n");
						iovref_temp_value--;
						break;
					}
				}

				printf("\n up edge detect \n");
				printf("\n\n iovref                       up edge==0x%08x\n ",iovref_temp_value);
				iovref_rig=iovref_temp_value;

				//reg_seed_value=0x49494949
				wrr_reg((reg_add),
						0x49494949);  //

				wrr_reg((reg_add+DDR0_PUB_IOVCR1-DDR0_PUB_IOVCR0),
						0x49494949);  //

				printf("\n\n iovref                       down edge==0x%08x   %08dmV\n",iovref_lef,(((((iovref_lef&0X3F)*7)+440)*3)/2)+1);
				printf("\n\n iovref                         up edge==0x%08x   %08dmV\n",iovref_rig,(((((iovref_rig&0X3F)*7)+440)*3)/2)+1);
				printf("\n\n iovref                            mid ==0x%08x   %08dmV\n",
						(iovref_lef+iovref_rig)/2,(((((((iovref_lef+iovref_rig)/2)&0X3F)*7)+440)*3)/2)+1);
				if (iovref_lef == 0x40)
					printf("\n\n iovref   down edge reach  reg limited\n");
			}
		}
	}

	return 0;

usage:
	cmd_usage(cmdtp);
	return 1;

}
U_BOOT_CMD(
	ddr_tune_ddr_vref,	7,	1,	do_ddr_test_vref,
	"DDR tune vref function ddr_tune_ddr_vref  a 0 0x8000000  1 48 1",
	"ddr_tune_ddr_vref  a 0 0x8000000  1 seed step \n dcache off ? \n"
);


int do_ddr4_test_phy_vref(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("watchdog_time_s==%d\n",watchdog_time_s);
	if(watchdog_time_s==0)
	{
		watchdog_time_s=50;
		printf("test soc_vref re set watchdog_time_s==%d\n",watchdog_time_s);
	}

#if ( CONFIG_DDR_PHY>=P_DDR_PHY_905X)
	// unsigned int  start_addr=test_start_addr;
	printf("\nEnter Test ddr4 phy vref function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);

	//  unsigned int   loop = 1;
	//   unsigned int   temp_count_i = 1;
	//   unsigned int   temp_count_j= 1;
	//    unsigned int   temp_count_k= 1;
	unsigned int   temp_test_error= 0;
	int training_seed=0;
	int training_step=0;

	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_soc_dram=0;
	//  unsigned int   test_times=1;
	unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;
	unsigned int   testing_channel = 0;
	unsigned int   dxnlcdlr3[4];
	unsigned int   dxnlcdlr4[4];


#define  CHANNEL_A  0
#define  CHANNEL_B  1
#define  DDR_CORSS_TALK_TEST_SIZE   0x20000
	//   #define DDR0_PUB_REG_BASE					0xc8836000
#define DDR0_PUB_DX0GCR4      ( DDR0_PUB_REG_BASE + ( 0x1c4  << 2 ) )
#define DDR0_PUB_DX1GCR4     ( DDR0_PUB_REG_BASE + ( 0x204  << 2 ) )
#define DDR0_PUB_DX2GCR4      ( DDR0_PUB_REG_BASE + ( 0x244  << 2 ) )
#define DDR0_PUB_DX3GCR4      ( DDR0_PUB_REG_BASE + ( 0x284  << 2 ) )
#define DDR0_PUB_DX0GCR5      ( DDR0_PUB_REG_BASE + ( 0x1c5  << 2 ) )
#define DDR0_PUB_DX1GCR5      ( DDR0_PUB_REG_BASE + ( 0x205  << 2 ) )
#define DDR0_PUB_DX2GCR5      ( DDR0_PUB_REG_BASE + ( 0x245  << 2 ) )
#define DDR0_PUB_DX3GCR5      ( DDR0_PUB_REG_BASE + ( 0x285  << 2 ) )

	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;

	//   unsigned int   ac_bdlr_lef[10];
	//   unsigned int   ac_bdlr_rig[10];
	int   iovref_temp_value;
	int ddr_soc_iovref_org=0;
	int   iovref_temp_reg_value;
	//    unsigned int  reg_seed_value;
	//	   unsigned int   temp_reg_value;
	int   iovref_org[4];
	int   iovref_lef[4];
	int   iovref_rig[4];
	//  unsigned int   temp_test_error;
	//	unsigned int temp_i=0;
	//	unsigned int temp_j=0;
	//unsigned int reg_add=0;
	//		static unsigned int training_enabled=1;

	//	 iovref_lef=0x49;
	// printf("\n\n iovref  org                     ==0x%08x   %08dmV\n",iovref_lef,(((((iovref_lef&0X3F)*7)+440)*3)/2)+1);
	//#define DDR_TEST_ACLCDLR

	char str_temp1[1024]="";
	char str_temp2[1024]="";
	char str[512]="";
	unsigned int  soc_iovref_test_ddr_clk=0;
	sprintf(str_temp1,"ddr_soc_iovref_test_ddr_clk");
	soc_iovref_test_ddr_clk=env_to_a_num(str_temp1);
	if(soc_iovref_test_ddr_clk==0)
	{
		soc_iovref_test_ddr_clk=global_ddr_clk;
		{
			sprintf(str_temp1,"ddr_soc_iovref_test_ddr_clk");
			sprintf(str_temp2,"0x%08x",soc_iovref_test_ddr_clk);
			setenv(str_temp1, str_temp2);
			run_command("save",0);
		}
	}
	if(soc_iovref_test_ddr_clk!=global_ddr_clk)
	{
		printf("running ddr freq==%d,but test freq is %d,will reboot use d2pll \n",global_ddr_clk,soc_iovref_test_ddr_clk);
		sprintf(str,"d2pll  %d",soc_iovref_test_ddr_clk);
		printf("\nstr=%s\n",str);
		run_command(str,0);
		while(1);
	}
	unsigned int  soc_iovref_test_step=0;
	sprintf(str_temp1,"soc_iovref_test_step");
	soc_iovref_test_step=env_to_a_num(str_temp1);
	if(soc_iovref_test_step==0)
		iovref_temp_value=0;
	{
		sprintf(str_temp1,"soc_iovref_test_step");
		sprintf(str_temp2,"0x%08x",iovref_temp_value);
		setenv(str_temp1, str_temp2);
		run_command("save",0);
	}

	unsigned int  soc_iovref_lef=0;
	unsigned int  soc_iovref_rig=0;
	//char *p_str=NULL;
	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))

		{channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))
		{
			channel_b_en = 1;
		}
		else
		{
			goto usage;
		}
	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))
		{
			channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))
		{
			channel_b_en = 1;
		}
	}
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}

	}
	if (argc >4) {
		test_soc_dram = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
		{
			test_soc_dram = 0;
		}
		if (test_soc_dram)
			test_soc_dram = 1;

	}
	training_seed = 0;
	if (argc >5) {
		training_seed = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
		{
			training_seed =0;// 0x2e;
		}
	}

	if (training_seed>0x3f)
		training_seed=0x3f;

	printf("\n\n iovref  training_seed             ==0x%08x   %08dmV\n",training_seed,((((((training_seed&0X3F)*7)+440)*3)/2)+1)*12/15);

	training_step = 0;
	if (argc >6) {
		training_step = simple_strtoull_ddr(argv[6], &endp, 16);
		if (*argv[6] == 0 || *endp != 0)
		{
			training_step = 0;
		}
	}
	int vref_all=1;
	if (argc >7) {
		vref_all = simple_strtoull_ddr(argv[7], &endp, 16);
		if (*argv[7] == 0 || *endp != 0)
		{
			vref_all =0;//
		}
	}
	vref_all =1;//
	int vref_lcdlr_offset=0;
	if (argc >8) {
		vref_lcdlr_offset = simple_strtoull_ddr(argv[8], &endp, 16);
		if (*argv[8] == 0 || *endp != 0)
		{
			vref_lcdlr_offset =0;
		}
	}
	int vref_set_test_step=0;
	if (argc >9) {
		vref_set_test_step = simple_strtoull_ddr(argv[9], &endp, 16);
		if (*argv[9] == 0 || *endp != 0)
		{
			vref_set_test_step =0;
		}
	}

	unsigned int soc_dram_hex_dec=0;
	if (argc >10)
	{
		soc_dram_hex_dec = simple_strtoull_ddr(argv[10], &endp, 0);
		if (*argv[10] == 0 || *endp != 0) {
			soc_dram_hex_dec = 0;
		}
	}
	if (soc_dram_hex_dec)
	{
		if (argc >5) {
			training_seed = simple_strtoull_ddr(argv[5], &endp, 0);
			if (*argv[5] == 0 || *endp != 0)
			{
				training_seed =0;// 0x2e;
			}
			printf("\ntraining_seed== 0x%08x\n", training_seed);

		}
		if (training_seed<45)
			training_seed=45;
		if (training_seed>88)
			training_seed=88;
		training_seed =(((training_seed*1000-44070)/698));


		printf("\n\n iovref  training_seed             ==0x%08x   %08dmV\n",training_seed,((((((training_seed&0X3F)*7)+440)*3)/2)+1)*12/15);
	}
	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_soc_dram== 0x%08x\n", test_soc_dram);
	printf("\nvref_all== 0x%08x\n", vref_all);
	printf("\nvref_lcdlr_offset== 0x%08x\n", vref_lcdlr_offset);
	printf("\nsoc_dram_hex_dec== 0x%08x\n", soc_dram_hex_dec);
	if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}

	//save and print org training dqs value
	if (channel_a_en || channel_b_en)
	{
		//dcache_disable();
		//serial_puts("\ndebug for ddrtest ,jiaxing disable dcache");
	}////save and print org training  value



	////tune and save training dqs value
	if (channel_a_en || channel_b_en)
	{
		for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
		{
			if (( channel_a_en) && ( channel_b_en == 0))
			{
				reg_base_adj=CHANNEL_A_REG_BASE;
			}
			else if(( channel_b_en)&&( channel_a_en==0))
			{
				reg_base_adj=CHANNEL_B_REG_BASE;
			}
			else if ((channel_a_en+channel_b_en)==2)
			{
				if ( testing_channel == CHANNEL_A)
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if( testing_channel==CHANNEL_B)
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
			}

			if (reg_base_adj == CHANNEL_A_REG_BASE)
			{
				printf("\ntest A channel data lane\n");
			}
			else
			{
				printf("\ntest B channel data lane\n");
			}




#define wrr_reg(addr, data)	(*((volatile  unsigned int  *)((unsigned long)(unsigned int )addr)))=(data)  //wr_reg(addr, data)
#define rdr_reg(addr)		 (unsigned int )(*((volatile  unsigned int  *)((unsigned long)(unsigned int )addr)))  //rd_reg(addr)
				unsigned int   dxnmdlr=0;
				reg_add=DDR0_PUB_DX0MDLR0+reg_base_adj;
				dxnmdlr=((rdr_reg((unsigned int )reg_add))>>16)&0x1ff;
				//	reg_seed_value=(training_seed|(0x0<<8)|(0x0<<16)|(0x0<<24));
				wrr_reg((((DDR0_PUB_DX0GCR4))),((rdr_reg((unsigned int )(DDR0_PUB_DX0GCR4)))&(~(1<<28)))|(7<<25)|(0xf<<2));
				wrr_reg((((DDR0_PUB_DX1GCR4))),((rdr_reg((unsigned int )(DDR0_PUB_DX1GCR4)))&(~(1<<28)))|(7<<25)|(0xf<<2));
				wrr_reg((((DDR0_PUB_DX2GCR4))),((rdr_reg((unsigned int )(DDR0_PUB_DX2GCR4)))&(~(1<<28)))|(7<<25)|(0xf<<2));
				wrr_reg((((DDR0_PUB_DX3GCR4))),((rdr_reg((unsigned int )(DDR0_PUB_DX3GCR4)))&(~(1<<28)))|(7<<25)|(0xf<<2));
				printf("\nDDR0_PUB_DX0GCR4==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_DX0GCR4))));
				printf("\nDDR0_PUB_DX1GCR4==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_DX1GCR4))));
				printf("\nDDR0_PUB_DX2GCR4==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_DX2GCR4))));
				printf("\nDDR0_PUB_DX3GCR4==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_DX3GCR4))));

				printf("\ndxnmdlr==0x%08x\n ",dxnmdlr);
				unsigned int   temp_i=0;
				unsigned int   temp_i_max=4;
				for ((  temp_i=0);(temp_i<4);( temp_i++))
				{
					dxnlcdlr3[temp_i]=(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+temp_i*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3))));
					dxnlcdlr4[temp_i]=(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+temp_i*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4))));
					reg_add=DDR0_PUB_DX0GCR5+reg_base_adj+temp_i*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5);
					iovref_temp_value=rdr_reg((unsigned int )reg_add);
					iovref_org[temp_i]=iovref_temp_value;
					iovref_temp_value=((iovref_temp_value)&0xff);
					printf("\ndxnlcdlr3[%08x]==0x%08x,dxnlcdlr4[%08x]==0x%08x\n ",temp_i,dxnlcdlr3[temp_i],temp_i,dxnlcdlr4[temp_i]);
					//	 iovref_lef=0x49;
					if (iovref_temp_value)
					{
						printf("reg_add==0x%08x,value==0x%08x, iovref  org ==0x%08x   %08dmV\n",reg_add,
								iovref_org[temp_i],iovref_temp_value,((((((iovref_temp_value&0X3F)*7)+440)*3)/2)+1)*12/15);
					}
					else
					{
						printf("\nio vref power down ,use external resister \n ");
					}

					wrr_reg((reg_add),
							iovref_org[temp_i]);  //
					iovref_lef[temp_i]=(iovref_org[temp_i])&0xff;
					iovref_rig[temp_i]=(iovref_org[temp_i])&0xff;
					if (training_seed)
					{iovref_lef[temp_i]=training_seed;
						iovref_rig[temp_i]=training_seed;

					}
				}

				printf("\ntraining_step==0x%08x\n ",training_step);
				if (vref_all)
				{temp_i_max=1;
				}
				for ((  temp_i=0);(temp_i<temp_i_max);( temp_i++))
				{
					reg_add=DDR0_PUB_DX0GCR5+reg_base_adj+temp_i*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5);


					if (training_seed)
					{
						wrr_reg((reg_add),
								(training_seed|((iovref_org[temp_i])&0xffffff00)));
						if (vref_all) {
							wrr_reg(((reg_add+1*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5))),
									(training_seed|((iovref_org[temp_i+1])&0xffffff00)));  //
							wrr_reg(((reg_add+2*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5))),
									(training_seed|((iovref_org[temp_i+2])&0xffffff00)));  //
							wrr_reg(((reg_add+3*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5))),
									(training_seed|((iovref_org[temp_i+3])&0xffffff00)));  //
						}
					}

					{

						iovref_temp_value=rdr_reg((unsigned int )reg_add);
						iovref_temp_value=((iovref_temp_value)&0xff);

						sprintf(str_temp1,"ddr_soc_iovref_org");
						ddr_soc_iovref_org=env_to_a_num(str_temp1);
						if(ddr_soc_iovref_org==0)
						{
							sprintf(str_temp1,"ddr_soc_iovref_org");
							sprintf(str_temp2,"0x%08x",iovref_temp_value);
							setenv(str_temp1, str_temp2);
							run_command("save",0);

							sprintf(str_temp1,"ddr_soc_iovref_lef");
							sprintf(str_temp2,"0x%08x",iovref_temp_value);
							setenv(str_temp1, str_temp2);
							run_command("save",0);

							sprintf(str_temp1,"ddr_soc_iovref_rig");
							sprintf(str_temp2,"0x%08x",iovref_temp_value);
							setenv(str_temp1, str_temp2);
							run_command("save",0);
						}
						sprintf(str_temp1,"ddr_soc_iovref_lef");
						soc_iovref_lef=env_to_a_num(str_temp1);
						sprintf(str_temp1,"ddr_soc_iovref_rig");
						soc_iovref_rig=env_to_a_num(str_temp1);


						if(soc_iovref_lef)
						{;
						}

						ddr_test_watchdog_enable(watchdog_time_s);

						if (vref_set_test_step)
						{
							printf("\nvref_set_test_step==0x%08x,skip test left edge\n ",vref_set_test_step);
							soc_iovref_test_step=1;
							{
								sprintf(str_temp1,"soc_iovref_test_step");
								sprintf(str_temp2,"0x%08x",soc_iovref_test_step);
								setenv(str_temp1, str_temp2);
								run_command("save",0);
							}
							//break;
						}

						if(soc_iovref_test_step==0)
						{//int temp=0;
							if(soc_iovref_lef)
							{iovref_temp_value=soc_iovref_lef;
							}
							while (iovref_temp_value>0x0)
							{

								temp_test_error=0;
								iovref_temp_value=iovref_temp_value-training_step;
								if (iovref_temp_value<training_step)
									iovref_temp_value=0;
								printf("\niovref lef temp==0x%08x\n ",iovref_temp_value);

								{
									sprintf(str_temp1,"ddr_soc_iovref_lef");
									sprintf(str_temp2,"0x%08x",iovref_temp_value);
									setenv(str_temp1, str_temp2);
									run_command("save",0);
								}

								iovref_temp_reg_value=(iovref_temp_value|((iovref_org[temp_i])&0xffffff00));
								wrr_reg((reg_add),
										iovref_temp_reg_value);  //
								if (vref_all) {
									wrr_reg((reg_add+1*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5)),
											iovref_temp_reg_value);  //
									wrr_reg((reg_add+2*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5)),
											iovref_temp_reg_value);  //
									wrr_reg((reg_add+3*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5)),
											iovref_temp_reg_value);  //
								}
								printf("\n reg_add 0x%08x== 0x%08x\n ",reg_add,iovref_temp_reg_value);
								printf("\n reg_add 0x%08x== 0x%08x\n ",(reg_add+1*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5)),iovref_temp_reg_value);
								printf("\n reg_add 0x%08x== 0x%08x\n ",(reg_add+2*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5)),iovref_temp_reg_value);
								printf("\n reg_add 0x%08x== 0x%08x\n ",(reg_add+3*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5)),iovref_temp_reg_value);
								ddr_test_watchdog_clear();
								temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
								ddr_test_watchdog_clear();
								temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
								ddr_test_watchdog_clear();
								if (vref_lcdlr_offset)
								{
									{
										wrr_reg((DDR0_PUB_DX0LCDLR3+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX0LCDLR3+reg_base_adj)))+vref_lcdlr_offset));  //
										wrr_reg((DDR0_PUB_DX0LCDLR4+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX0LCDLR4+reg_base_adj)))+vref_lcdlr_offset));  //
										if (vref_all) {
											wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
													((rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3))))+vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
													((rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3))))+vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
													((rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3))))+vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
													((rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4))))+vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
													((rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4))))+vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
													((rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4))))+vref_lcdlr_offset));  //
										}
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
										ddr_test_watchdog_clear();

										{
											{
												wrr_reg((DDR0_PUB_DX0LCDLR3+reg_base_adj),dxnlcdlr3[0]);  //
												wrr_reg((DDR0_PUB_DX0LCDLR4+reg_base_adj),dxnlcdlr4[0]);  //
												if (vref_all) {
													wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
															dxnlcdlr3[1]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
															dxnlcdlr3[2]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
															dxnlcdlr3[3]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
															dxnlcdlr4[1]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
															dxnlcdlr4[2]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
															dxnlcdlr4[3]);  //
												}

											}
										}

									}

								}

								if (vref_lcdlr_offset)
								{
									{
										wrr_reg((DDR0_PUB_DX0LCDLR3+reg_base_adj),(dxnlcdlr3[0]-vref_lcdlr_offset));  //
										wrr_reg((DDR0_PUB_DX0LCDLR4+reg_base_adj),(dxnlcdlr4[0]-vref_lcdlr_offset));  //
										if (vref_all) {
											wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
													(dxnlcdlr3[1]-vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
													(dxnlcdlr3[2]-vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
													(dxnlcdlr3[3]-vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
													(dxnlcdlr4[1]-vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
													(dxnlcdlr4[2]-vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
													(dxnlcdlr4[3]-vref_lcdlr_offset));  //
										}
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										ddr_test_watchdog_clear();
										temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);


										{
											{
												wrr_reg((DDR0_PUB_DX0LCDLR3+reg_base_adj),dxnlcdlr3[0]);  //
												wrr_reg((DDR0_PUB_DX0LCDLR4+reg_base_adj),dxnlcdlr4[0]);  //
												if (vref_all) {
													wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
															dxnlcdlr3[1]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
															dxnlcdlr3[2]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
															dxnlcdlr3[3]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
															dxnlcdlr4[1]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
															dxnlcdlr4[2]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
															dxnlcdlr4[3]);  //
												}

											}
										}

									}

								}
								if (temp_test_error)
								{
									printf("\nvref down edge detect \n");
									iovref_temp_value=iovref_temp_value+training_step;
									break;
								}
							}
							printf("\niovref lef temp==0x%08x\n ",iovref_temp_value);

							{
								sprintf(str_temp1,"ddr_soc_iovref_lef");
								sprintf(str_temp2,"0x%08x",iovref_temp_value);
								setenv(str_temp1, str_temp2);
								run_command("save",0);
							}

							{
								soc_iovref_test_step=1;
								sprintf(str_temp1,"soc_iovref_test_step");
								sprintf(str_temp2,"0x%08x",soc_iovref_test_step);
								setenv(str_temp1, str_temp2);
								run_command("save",0);
								run_command("reset",0);
							}

						}

						sprintf(str_temp1,"ddr_soc_iovref_lef");
						soc_iovref_lef=env_to_a_num(str_temp1);
						iovref_temp_value=soc_iovref_lef;
						printf("\n down edge detect \n");
						printf("\n\n iovref                       down edge==0x%08x\n ",soc_iovref_lef);
						iovref_lef[temp_i]=iovref_temp_value;
						//if(soc_iovref_lef)
						//{iovref_temp_value=soc_iovref_lef;
						//iovref_lef[temp_i]=iovref_temp_value;
						//}
						wrr_reg((reg_add),
								iovref_org[temp_i]);  //
						if (vref_all) {
							wrr_reg(((reg_add+1*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5))),
									iovref_org[temp_i+1]);  //
							wrr_reg(((reg_add+2*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5))),
									iovref_org[temp_i+2]);  //
							wrr_reg(((reg_add+3*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5))),
									iovref_org[temp_i+3]);  //
						}

						if (vref_lcdlr_offset)
						{
							{
								wrr_reg((DDR0_PUB_DX0LCDLR3+reg_base_adj),dxnlcdlr3[0]);  //
								wrr_reg((DDR0_PUB_DX0LCDLR4+reg_base_adj),dxnlcdlr4[0]);  //
								if (vref_all) {
									wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
											dxnlcdlr3[1]);  //
									wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
											dxnlcdlr3[2]);  //
									wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
											dxnlcdlr3[3]);  //
									wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
											dxnlcdlr4[1]);  //
									wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
											dxnlcdlr4[2]);  //
									wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
											dxnlcdlr4[3]);  //
								}

							}
						}
					}


					{
						if (training_seed)
						{
							wrr_reg((reg_add),
									(training_seed|((iovref_org[temp_i])&0xffffff00)));
							if (vref_all) {
								wrr_reg(((reg_add+1*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5))),
										(training_seed|((iovref_org[temp_i+1])&0xffffff00)));  //
								wrr_reg(((reg_add+2*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5))),
										(training_seed|((iovref_org[temp_i+2])&0xffffff00)));  //
								wrr_reg(((reg_add+3*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5))),
										(training_seed|((iovref_org[temp_i+3])&0xffffff00)));  //
							}
						}

						iovref_temp_value=rdr_reg((unsigned int )reg_add);
						iovref_temp_value=((iovref_temp_value)&0xff);

						//if(soc_iovref_rig==0)
						if(soc_iovref_test_step==1)
						{
							if(soc_iovref_rig)
							{iovref_temp_value=soc_iovref_rig;
							}
							while (iovref_temp_value<0x3f)
							{
								temp_test_error=0;
								iovref_temp_value=iovref_temp_value+training_step;
								if (iovref_temp_value>0x3f)
									iovref_temp_value=0x3f;
								printf("\niovref rig temp==0x%08x\n ",iovref_temp_value);

								{
									sprintf(str_temp1,"ddr_soc_iovref_rig");
									sprintf(str_temp2,"0x%08x",iovref_temp_value);
									setenv(str_temp1, str_temp2);
									run_command("save",0);
								}

								iovref_temp_reg_value=(iovref_temp_value|((iovref_org[temp_i])&0xffffff00));
								wrr_reg((reg_add),
										iovref_temp_reg_value);  //
								if (vref_all) {
									wrr_reg((reg_add+1*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5)),
											iovref_temp_reg_value);  //
									wrr_reg((reg_add+2*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5)),
											iovref_temp_reg_value);  //
									wrr_reg((reg_add+3*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5)),
											iovref_temp_reg_value);  //
								}

								printf("\n reg_add 0x%08x== 0x%08x\n ",reg_add,iovref_temp_reg_value);
								printf("\n reg_add 0x%08x== 0x%08x\n ",(reg_add+1*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5)),iovref_temp_reg_value);
								printf("\n reg_add 0x%08x== 0x%08x\n ",(reg_add+2*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5)),iovref_temp_reg_value);
								printf("\n reg_add 0x%08x== 0x%08x\n ",(reg_add+3*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5)),iovref_temp_reg_value);
								ddr_test_watchdog_clear();
								temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
								ddr_test_watchdog_clear();
								temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
								if (vref_lcdlr_offset)
								{
									{
										wrr_reg((DDR0_PUB_DX0LCDLR3+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX0LCDLR3+reg_base_adj)))+vref_lcdlr_offset));  //
										wrr_reg((DDR0_PUB_DX0LCDLR4+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX0LCDLR4+reg_base_adj)))+vref_lcdlr_offset));  //
										if (vref_all) {
											wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
													((rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3))))+vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
													((rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3))))+vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
													((rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3))))+vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
													((rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4))))+vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
													((rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4))))+vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
													((rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4))))+vref_lcdlr_offset));  //
										}
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										ddr_test_watchdog_clear();
										temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
										{
											{
												wrr_reg((DDR0_PUB_DX0LCDLR3+reg_base_adj),dxnlcdlr3[0]);  //
												wrr_reg((DDR0_PUB_DX0LCDLR4+reg_base_adj),dxnlcdlr4[0]);  //
												if (vref_all) {
													wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
															dxnlcdlr3[1]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
															dxnlcdlr3[2]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
															dxnlcdlr3[3]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
															dxnlcdlr4[1]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
															dxnlcdlr4[2]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
															dxnlcdlr4[3]);  //
												}

											}
										}

									}

								}

								if (vref_lcdlr_offset)
								{
									{
										wrr_reg((DDR0_PUB_DX0LCDLR3+reg_base_adj),(dxnlcdlr3[0]-vref_lcdlr_offset));  //
										wrr_reg((DDR0_PUB_DX0LCDLR4+reg_base_adj),(dxnlcdlr4[0]-vref_lcdlr_offset));  //
										if (vref_all) {
											wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
													(dxnlcdlr3[1]-vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
													(dxnlcdlr3[2]-vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
													(dxnlcdlr3[3]-vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
													(dxnlcdlr4[1]-vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
													(dxnlcdlr4[2]-vref_lcdlr_offset));  //
											wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
													(dxnlcdlr4[3]-vref_lcdlr_offset));  //
										}
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+0*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
												(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)))));
										ddr_test_watchdog_clear();
										temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
										ddr_test_watchdog_clear();

										{
											{
												wrr_reg((DDR0_PUB_DX0LCDLR3+reg_base_adj),dxnlcdlr3[0]);  //
												wrr_reg((DDR0_PUB_DX0LCDLR4+reg_base_adj),dxnlcdlr4[0]);  //
												if (vref_all) {
													wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
															dxnlcdlr3[1]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
															dxnlcdlr3[2]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
															dxnlcdlr3[3]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
															dxnlcdlr4[1]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
															dxnlcdlr4[2]);  //
													wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
															dxnlcdlr4[3]);  //
												}

											}
										}

									}

								}

								if (temp_test_error)
								{
									printf("\nvref up edge detect \n");
									iovref_temp_value=iovref_temp_value-training_step;
									break;
								}
							}
						}

						printf("\niovref rig temp==0x%08x\n ",iovref_temp_value);

						{
							sprintf(str_temp1,"ddr_soc_iovref_rig");
							sprintf(str_temp2,"0x%08x",iovref_temp_value);
							setenv(str_temp1, str_temp2);
							run_command("save",0);
						}

						{
							soc_iovref_test_step=2;
							sprintf(str_temp1,"soc_iovref_test_step");
							sprintf(str_temp2,"0x%08x",soc_iovref_test_step);
							setenv(str_temp1, str_temp2);
							run_command("save",0);
							//run_command("reset",0);
						}

					}

					sprintf(str_temp1,"ddr_soc_iovref_rig");
					soc_iovref_rig=env_to_a_num(str_temp1);
					iovref_temp_value=soc_iovref_rig;

					printf("\n up edge detect \n");
					printf("\n\n iovref                       up edge==0x%08x\n ",iovref_temp_value);
					iovref_rig[temp_i]=iovref_temp_value;
					//if(soc_iovref_rig)
					//{iovref_temp_value=soc_iovref_rig;
					//iovref_rig[temp_i]=iovref_temp_value;
					//}
					wrr_reg((reg_add),
							iovref_org[temp_i]);  //
					if (vref_all) {
						wrr_reg(((reg_add+1*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5))),
								iovref_org[temp_i+1]);  //
						wrr_reg(((reg_add+2*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5))),
								iovref_org[temp_i+2]);  //
						wrr_reg(((reg_add+3*(DDR0_PUB_DX1GCR5-DDR0_PUB_DX0GCR5))),
								iovref_org[temp_i+3]);  //
					}

					if (vref_lcdlr_offset)
					{
						{
							wrr_reg((DDR0_PUB_DX0LCDLR3+reg_base_adj),dxnlcdlr3[0]);  //
							wrr_reg((DDR0_PUB_DX0LCDLR4+reg_base_adj),dxnlcdlr4[0]);  //
							if (vref_all) {
								wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
										dxnlcdlr3[1]);  //
								wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
										dxnlcdlr3[2]);  //
								wrr_reg(((DDR0_PUB_DX0LCDLR3+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)),
										dxnlcdlr3[3]);  //
								wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+1*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
										dxnlcdlr4[1]);  //
								wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+2*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
										dxnlcdlr4[2]);  //
								wrr_reg(((DDR0_PUB_DX0LCDLR4+reg_base_adj)+3*(DDR0_PUB_DX1LCDLR4-DDR0_PUB_DX0LCDLR4)),
										dxnlcdlr4[3]);  //
							}

						}
					}


				}
				// vddq=1.5v
				ddr_test_watchdog_disable();
				printf("\n\nsoc  iovref test clk==%d\n",soc_iovref_test_ddr_clk);
				printf("\n\n iovref  vddq=1.2v,if use other vddq ,please recount\n");
				for ((  temp_i=0);(temp_i<4);( temp_i++))
				{
					printf("\n\n iovref  lane_x=0x%08x,     org==0x%08x   %08dmV\n",temp_i,iovref_org[temp_i],((((((iovref_org[temp_i]&0X3F)*7)+440)*3)/2)+1)*12/15);
					printf("\n\n iovref  lane_x=0x%08x,     down edge==0x%08x   %08dmV\n",temp_i,iovref_lef[temp_i],((((((iovref_lef[temp_i]&0X3F)*7)+440)*3)/2)+1)*12/15);
					printf("\n\n iovref  lane_x=0x%08x,     up edge==0x%08x   %08dmV\n",temp_i,iovref_rig[temp_i],((((((iovref_rig[temp_i]&0X3F)*7)+440)*3)/2)+1)*12/15);
					printf("\n\n iovref  lane_x=0x%08x,     mid ==0x%08x   %08dmV\n",temp_i,
							(iovref_lef[temp_i]+iovref_rig[temp_i])/2,((((((((iovref_lef[temp_i]+iovref_rig[temp_i])/2)&0X3F)*7)+440)*3)/2)+1)*12/15);
					if (iovref_lef[temp_i] == 0x0)
					{
						printf("\n\n iovref   down edge reach  reg limited\n");
					}
					if (iovref_rig[temp_i] == 0x3f)
					{
						printf("\n\n iovref   up edge reach  reg limited\n");
					}
				}
				{
					sprintf(str_temp1,"ddr_soc_iovref_org");
					sprintf(str_temp2,"0x%08x",iovref_org[0]);
					setenv(str_temp1, str_temp2);
					run_command("save",0);
				}

				{
					sprintf(str_temp1,"ddr_soc_iovref_lef");
					sprintf(str_temp2,"0x%08x",iovref_lef[0]);
					setenv(str_temp1, str_temp2);
					run_command("save",0);
				}
				{
					sprintf(str_temp1,"ddr_soc_iovref_rig");
					sprintf(str_temp2,"0x%08x",iovref_rig[0]);
					setenv(str_temp1, str_temp2);
					run_command("save",0);
				}

				printf("\n\n printf soc vref from env ,if remeasure should clear ddr_soc_iovref_org env  ddr_soc_iovref_lef \
						ddr_soc_iovref_rig ddr_soc_vref_range,ddr_soc_iovref_test_ddr_clk \n");
		}
	}
	return 0;

usage:
	cmd_usage(cmdtp);
#endif
	return 1;

}
//*/

int do_ddr4_test_dram_vref(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{


	printf("watchdog_time_s==%d\n",watchdog_time_s);
	if(watchdog_time_s==0)
	{
		watchdog_time_s=50;
		printf("test dram_vref re set watchdog_time_s==%d\n",watchdog_time_s);
	}

#if ( CONFIG_DDR_PHY>=P_DDR_PHY_905X)
	// unsigned int  start_addr=test_start_addr;
	printf("\nEnter Test ddr4 dram vref function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);


	//  unsigned int   loop = 1;
	//   unsigned int   temp_count_i = 1;
	//   unsigned int   temp_count_j= 1;
	//    unsigned int   temp_count_k= 1;
	unsigned int   temp_test_error= 0;
	int training_seed=0;
	int training_step=0;

	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_clear=0;
	//  unsigned int   test_times=1;
	unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;
	unsigned int   testing_channel = 0;
	unsigned int   dxnlcdlr1[4];
	//  unsigned int   dxnlcdlr4[4];


#define  CHANNEL_A  0
#define  CHANNEL_B  1


#define  DDR_CORSS_TALK_TEST_SIZE   0x20000
	//   #define DDR0_PUB_REG_BASE					0xc8836000
#define DDR0_PUB_DX0GCR4      ( DDR0_PUB_REG_BASE + ( 0x1c4  << 2 ) )
#define DDR0_PUB_DX1GCR4     ( DDR0_PUB_REG_BASE + ( 0x204  << 2 ) )
#define DDR0_PUB_DX2GCR4      ( DDR0_PUB_REG_BASE + ( 0x244  << 2 ) )
#define DDR0_PUB_DX3GCR4      ( DDR0_PUB_REG_BASE + ( 0x284  << 2 ) )
#define DDR0_PUB_DX0GCR5      ( DDR0_PUB_REG_BASE + ( 0x1c5  << 2 ) )
#define DDR0_PUB_DX1GCR5      ( DDR0_PUB_REG_BASE + ( 0x205  << 2 ) )
#define DDR0_PUB_DX2GCR5      ( DDR0_PUB_REG_BASE + ( 0x245  << 2 ) )
#define DDR0_PUB_DX3GCR5      ( DDR0_PUB_REG_BASE + ( 0x285  << 2 ) )



	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;

	//   unsigned int   ac_bdlr_lef[10];
	//   unsigned int   ac_bdlr_rig[10];
	int   iovref_temp_value;
	//     int   iovref_temp_reg_value;
	//    unsigned int  reg_seed_value;
	//	   unsigned int   temp_reg_value;
	int   iovref_org=0;
	int   iovref_lef=0;
	int   iovref_rig=0;
	int   iovref_mid;
	int   iovref_test_read;
	int   iovref_test_step;
	//  unsigned int   temp_test_error;
	//	unsigned int temp_i=0;
	//	unsigned int temp_j=0;
	//unsigned int reg_add=0;
	//		static unsigned int training_enabled=1;

	//	 iovref_lef=0x49;
	// printf("\n\n iovref  org                     ==0x%08x   %08dmV\n",iovref_lef,(((((iovref_lef&0X3F)*7)+440)*3)/2)+1);
	//#define DDR_TEST_ACLCDLR


	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))
		{
			channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))
		{
			channel_b_en = 1;
		}
		else
		{
			goto usage;
		}
	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))
		{
			channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))
		{
			channel_b_en = 1;
		}
	}
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}

	}
	if (argc >4) {
		test_clear = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
		{
			test_clear = 0;
		}
		if (  test_clear )
			test_clear = 1;

	}
	training_seed = 0;
	if (argc >5) {
		training_seed = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
		{
			training_seed =0;// 0x2e;
		}


	}





	training_step = 0;
	if (argc >6) {
		training_step = simple_strtoull_ddr(argv[6], &endp, 16);
		if (*argv[6] == 0 || *endp != 0)
		{
			training_step = 0;
		}

	}
	if (!training_step)
		training_step=1;
	int vref_all=0;
	if (argc >7) {
		vref_all = simple_strtoull_ddr(argv[7], &endp, 16);
		if (*argv[7] == 0 || *endp != 0)
		{
			vref_all =0;// 0x2e;
		}}
	int vref_lcdlr_offset=0;
	if (argc >8) {
		vref_lcdlr_offset = simple_strtoull_ddr(argv[8], &endp, 16);
		if (*argv[8] == 0 || *endp != 0)
		{
			vref_lcdlr_offset =0;
		}}
	int vref_set_test_step=0;
	if (argc >9) {
		vref_set_test_step = simple_strtoull_ddr(argv[9], &endp, 16);
		if (*argv[9] == 0 || *endp != 0)
		{
			vref_set_test_step =0;
		}}
	int vref_dram_range=0;
	if (argc >10) {
		vref_dram_range = simple_strtoull_ddr(argv[10], &endp, 16);
		if (*argv[10] == 0 || *endp != 0)
		{
			vref_dram_range =0;
		}}


	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_clear== 0x%08x\n", test_clear);
	printf("\nvref_all== 0x%08x\n", vref_all);
	printf("\nvref_lcdlr_offset== 0x%08x\n", vref_lcdlr_offset);
	printf("\nvref_dram_range== 0x%08x\n", vref_dram_range);

	unsigned int soc_dram_hex_dec=0;
	if (argc >11)
	{
		soc_dram_hex_dec = simple_strtoull_ddr(argv[11], &endp, 16);
		if (*argv[11] == 0 || *endp != 0) {
			soc_dram_hex_dec = 0;
		}
	}
	if (soc_dram_hex_dec)
	{
		if (argc >5) {
			training_seed = simple_strtoull_ddr(argv[5], &endp, 0);
			if (*argv[5] == 0 || *endp != 0)
			{
				training_seed =0;// 0x2e;
			}


		}

	}
	if (training_seed)
	{
		if (soc_dram_hex_dec)
		{
			if (vref_dram_range)
			{
				if (training_seed<45)
					training_seed=45;
				if (training_seed>77)
					training_seed=77;
				training_seed =(((((training_seed*1000-45000)/650)>0X32)?(0X32):(((training_seed*1000-45000)/650))));
			}
			if (vref_dram_range == 0)
			{
				if (training_seed<60)
					training_seed=60;
				if (training_seed>92)
					training_seed=92;
				training_seed =(((((training_seed*1000-60000)/650)>0X32)?(0X32):(((training_seed*1000-60000)/650))));
			}
		}
		if (vref_dram_range == 0)
			printf("\n\n iovref  training_seed             ==0x%08x   %08dmV\n",training_seed,(((((training_seed&0X3F)*65)+6000)*1200)/10000));
		else
			printf("\n\n iovref  training_seed             ==0x%08x   %08dmV\n",training_seed,(((((training_seed&0X3F)*65)+4500)*1200)/10000));
	}
	if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}

	char str_temp1[1024]="";
	char str_temp2[1024]="";
	char *p_str=NULL;


	char str[512]="";
	unsigned int  dram_iovref_test_ddr_clk=0;
	sprintf(str_temp1,"ddr_dram_iovref_test_ddr_clk");
	dram_iovref_test_ddr_clk=env_to_a_num(str_temp1);
	if(dram_iovref_test_ddr_clk==0)
	{dram_iovref_test_ddr_clk=global_ddr_clk;
		{
			sprintf(str_temp1,"ddr_dram_iovref_test_ddr_clk");
			sprintf(str_temp2,"0x%08x",dram_iovref_test_ddr_clk);
			setenv(str_temp1, str_temp2);
			run_command("save",0);
		}
	}
	if(dram_iovref_test_ddr_clk!=global_ddr_clk)
	{
		printf("running ddr freq==%d,but test freq is%d,will reboot use d2pll \n",global_ddr_clk,dram_iovref_test_ddr_clk);
		sprintf(str,"d2pll  %d",dram_iovref_test_ddr_clk);
		printf("\nstr=%s\n",str);
		run_command(str,0);
		while(1);
	}


	{
		{
			sprintf(str_temp1,"ddr_dram_iovref_org");
			//	sprintf(str_temp2,"0x%08x",iovref_org);
			p_str=getenv(str_temp1);

			if(p_str)
			{
				iovref_org= simple_strtoull_ddr(p_str, &endp, 0);
			}


			sprintf(str_temp1,"ddr_dram_iovref_lef");
			//sprintf(str_temp2,"0x%08x",iovref_lef);
			p_str=getenv(str_temp1);

			if(p_str)
			{
				iovref_lef= simple_strtoull_ddr(p_str, &endp, 0);
			}


			sprintf(str_temp1,"ddr_dram_iovref_rig");
			//sprintf(str_temp2,"0x%08x",iovref_rig);
			p_str=getenv(str_temp1);

			if(p_str)
			{
				iovref_rig= simple_strtoull_ddr(p_str, &endp, 0);
			}

			sprintf(str_temp1,"ddr_dram_vref_range");
			//sprintf(str_temp2,"0x%08x",vref_dram_range);
			p_str=getenv(str_temp1);


			if(p_str)
			{
				vref_dram_range= simple_strtoull_ddr(p_str, &endp, 0);
			}

		}

		if(vref_dram_range|iovref_rig|iovref_org|iovref_lef)
		{
			printf("\n\ndram  iovref test clk==%d\n",dram_iovref_test_ddr_clk);
			iovref_mid=(iovref_lef+iovref_rig)/2;
			if (vref_dram_range == 0)
			{
				printf("iovref_org==0x%08x,%08dmV||iovref_lef==0x%08x,%08dmV||iovref_rig==0x%08x,%08dmV||iovref_mid0x%08x,%08dmV\n",
						iovref_org,((((((iovref_org&0X3F)*65)+6000)*1200)/10000)),iovref_lef,((((((iovref_lef&0X3F)*65)+6000)*1200)/10000)),
						iovref_rig,((((((iovref_rig&0X3F)*65)+6000)*1200)/10000)),iovref_mid,((((((iovref_mid&0X3F)*65)+6000)*1200)/10000)));
			}
			if (vref_dram_range)
			{
				printf("iovref_org==0x%08x,%08dmV||iovref_lef==0x%08x,%08dmV||iovref_rig==0x%08x,%08dmV||iovref_mid0x%08x,%08dmV\n",
						iovref_org,((((((iovref_org&0X3F)*65)+4500)*1200)/10000)),iovref_lef,((((((iovref_lef&0X3F)*65)+4500)*1200)/10000)),
						iovref_rig,((((((iovref_rig&0X3F)*65)+4500)*1200)/10000)),iovref_mid,((((((iovref_mid&0X3F)*65)+4500)*1200)/10000)));
			}
			if (iovref_rig == 0x32)
			{
				printf("\n\n iovref  rig reach reg max\n");
			}
			if (iovref_rig == 0x0)
			{
				printf("\n\n iovref  lef reach reg min\n");
			}
			printf("\n\n printf dram vref from env ,if remeasure should clear ddr_dram_iovref_org env  ddr_dram_iovref_lef \
					ddr_dram_iovref_rig ddr_dram_vref_range,ddr_dram_iovref_test_ddr_clk \n");
			return 1;
		}

	}


	//save and print org training dqs value
	if (channel_a_en || channel_b_en)
	{
		//dcache_disable();
		//serial_puts("\ndebug for ddrtest ,jiaxing disable dcache");
	}////save and print org training  value



	{
		////tune and save training dqs value
		if (channel_a_en || channel_b_en)

		{
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{

				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;
					}
				}

				if (reg_base_adj == CHANNEL_A_REG_BASE)
				{
					printf("\ntest A channel data lane\n");
				}
				else
				{
					printf("\ntest B channel data lane\n");
				}




			}

			{


#define wrr_reg(addr, data)	(*((volatile  unsigned int  *)((unsigned long)(unsigned int )addr)))=(data)  //wr_reg(addr, data)
#define rdr_reg(addr)		 (unsigned int )(*((volatile  unsigned int  *)((unsigned long)(unsigned int )addr)))  //rd_reg(addr)
				unsigned int   dxnmdlr=0;
				reg_add=DDR0_PUB_DX0MDLR0+reg_base_adj;
				dxnmdlr=((rdr_reg((unsigned int )reg_add))>>16)&0x1ff;
				//	reg_seed_value=(training_seed|(0x0<<8)|(0x0<<16)|(0x0<<24));
				printf("\ndxnmdlr==0x%08x\n ",dxnmdlr);
				//turn off ddr4 phy read vref gate,only output ac lane vref
				wrr_reg((((DDR0_PUB_DX0GCR4))),((rdr_reg((unsigned int )(DDR0_PUB_DX0GCR4)))&(~(1<<28)))|(7<<25)|(0xf<<2));
				wrr_reg((((DDR0_PUB_DX1GCR4))),((rdr_reg((unsigned int )(DDR0_PUB_DX1GCR4)))&(~(1<<28)))|(7<<25)|(0xf<<2));
				wrr_reg((((DDR0_PUB_DX2GCR4))),((rdr_reg((unsigned int )(DDR0_PUB_DX2GCR4)))&(~(1<<28)))|(7<<25)|(0xf<<2));
				wrr_reg((((DDR0_PUB_DX3GCR4))),((rdr_reg((unsigned int )(DDR0_PUB_DX3GCR4)))&(~(1<<28)))|(7<<25)|(0xf<<2));
				wrr_reg((((DDR0_PUB_IOVCR0))),0x00090909|(0x0f<<24));
				wrr_reg((((DDR0_PUB_IOVCR1))),0x109);
				printf("\nDDR0_PUB_DX0GCR4==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_DX0GCR4))));
				printf("\nDDR0_PUB_DX1GCR4==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_DX1GCR4))));
				printf("\nDDR0_PUB_DX2GCR4==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_DX2GCR4))));
				printf("\nDDR0_PUB_DX3GCR4==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_DX3GCR4))));
				printf("\nDDR0_PUB_IOVCR0==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_IOVCR0))));
				printf("\nDDR0_PUB_IOVCR1==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_IOVCR1))));
				unsigned int   temp_i=0;
				//unsigned int   temp_i_max=4;//DDR0_PUB_MR6
				for ((  temp_i=0);(temp_i<4);( temp_i++))
				{
					dxnlcdlr1[temp_i]=(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR1+reg_base_adj)+temp_i*(DDR0_PUB_DX1LCDLR1-DDR0_PUB_DX0LCDLR1))));

					printf("\nreg==0x%08x,dxnlcdlr1[%08x]==0x%08x\n ",
							((DDR0_PUB_DX0LCDLR1+reg_base_adj)+temp_i*(DDR0_PUB_DX1LCDLR1-DDR0_PUB_DX0LCDLR1)),
							temp_i,dxnlcdlr1[temp_i]);

				}

				iovref_test_read=(rdr_reg((unsigned int )((DDR0_PUB_DX0GCR6))))&0x3f;
				iovref_temp_value=rdr_reg((unsigned int )(DDR0_PUB_DX0GCR6));
				if ((iovref_temp_value&0x3f) == 0x09)
				{
					iovref_temp_value=(rdr_reg((unsigned int )(DDR0_PUB_MR6)))&0x3f;;
					iovref_test_read=iovref_temp_value;
				}
				iovref_org=(rdr_reg((unsigned int )((PREG_STICKY_REG7))))&0xff;


				printf("PREG_STICKY_REG7==0x%08x\n ",(rdr_reg((unsigned int )((PREG_STICKY_REG7)))));
				printf("DDR0_PUB_MR6==0x%08x\n ",(rdr_reg((unsigned int )((DDR0_PUB_MR6)))));
				printf("DDR0_PUB_DX0GCR6==0x%08x\n ",(rdr_reg((unsigned int )((DDR0_PUB_DX0GCR6)))));
				if (((iovref_org) == 0) || (test_clear))
				{



					iovref_org=iovref_temp_value&0x3f;
					iovref_lef=iovref_org;
					iovref_rig=iovref_org;
					iovref_test_step=0;

					if (training_seed)
					{
						iovref_org=training_seed&0x3f;
						iovref_lef=iovref_org;
						iovref_rig=iovref_org;
						iovref_test_step=0;

					}
					if (vref_dram_range == 0)
						printf("\n\n iovref  training_seed             ==0x%08x   %08dmV\n",training_seed,(((((training_seed&0X3F)*65)+6000)*1200)/10000));
					else
						printf("\n\n iovref  training_seed             ==0x%08x   %08dmV\n",training_seed,(((((training_seed&0X3F)*65)+4500)*1200)/10000));
					wrr_reg((PREG_STICKY_REG7),iovref_org|(iovref_lef<<8)|((iovref_rig<<16))|(iovref_test_step<<24));
				}

				printf("PREG_STICKY_REG7==0x%08x\n ",(rdr_reg((unsigned int )((PREG_STICKY_REG7)))));
				{
					if ((((rdr_reg((unsigned int )((DDR0_PUB_MR6))))>>6)&1) == 0)
					{
						printf("reg_add==0x%08x,value==0x%08x, iovref  org ==0x%08x   %08dmV\n",DDR0_PUB_MR6,
								iovref_temp_value,iovref_org,((((((iovref_org&0X3F)*65)+6000)*1200)/10000)));
						printf("reg_add==0x%08x,value==0x%08x, iovref_dx0gcr6 ==0x%08x   %08dmV\n",DDR0_PUB_DX0GCR6,
								(rdr_reg((unsigned int )((DDR0_PUB_DX0GCR6)))),(rdr_reg((unsigned int )((DDR0_PUB_DX0GCR6)))),
								(((((((rdr_reg((unsigned int )((DDR0_PUB_DX0GCR6))))&0X3F)*65)+6000)*1200)/10000)));

					}
					if (((rdr_reg((unsigned int )((DDR0_PUB_MR6))))>>6)&1)
					{
						printf("reg_add==0x%08x,value==0x%08x, iovref  org ==0x%08x   %08dmV\n",DDR0_PUB_MR6,
								iovref_temp_value,iovref_org,((((((iovref_org&0X3F)*65)+4500)*1200)/10000)));
						printf("reg_add==0x%08x,value==0x%08x, iovref_dx0gcr6 ==0x%08x   %08dmV\n",DDR0_PUB_DX0GCR6,
								(rdr_reg((unsigned int )((DDR0_PUB_DX0GCR6)))),(rdr_reg((unsigned int )((DDR0_PUB_DX0GCR6)))),
								(((((((rdr_reg((unsigned int )((DDR0_PUB_DX0GCR6))))&0X3F)*65)+4500)*1200)/10000)));

					}

				}

				iovref_org=(rdr_reg((unsigned int )((PREG_STICKY_REG7))))&0x3f;  //
				iovref_lef=((rdr_reg((unsigned int )((PREG_STICKY_REG7))))>>8)&0x3f;
				iovref_rig=((rdr_reg((unsigned int )((PREG_STICKY_REG7))))>>16)&0x3f;
				iovref_test_step=((rdr_reg((unsigned int )((PREG_STICKY_REG7))))>>24)&0x3f;



				printf("\ntraining_step==0x%08x\n ",training_step);
				printf("\niovref_test_step==0x%08x\n ",iovref_test_step);
				printf("\niovref_lef==0x%08x\n ",iovref_lef);
				printf("\niovref_rig==0x%08x\n ",iovref_rig);
				if (vref_set_test_step)
				{if(iovref_test_step==0)
					iovref_test_step=vref_set_test_step;
				}
				if (iovref_test_step<2)
				{
					if (iovref_test_step == 0)
					{
						iovref_temp_value=iovref_lef;

					}
					if (iovref_test_step == 1)
					{
						iovref_temp_value=iovref_rig;
					}
					//iovref_temp_value=iovref_lef-training_step;
					printf("\niovref  temp==0x%08x\n ",iovref_temp_value);
					printf("\niovref_test_read==0x%08x\n ",iovref_test_read);
					temp_test_error=0;
					if ((iovref_org == iovref_lef) && (iovref_org == iovref_rig)) {
						printf("\nfirst test");
					}
					else if(iovref_test_read!=iovref_temp_value)
					{temp_test_error=1;
					}

					ddr_test_watchdog_enable(watchdog_time_s);
					temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
					ddr_test_watchdog_clear();
					temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
					if (vref_lcdlr_offset)
					{
						{
							wrr_reg((DDR0_PUB_DX0LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX0LCDLR1+reg_base_adj)))+vref_lcdlr_offset));  //
							wrr_reg((DDR0_PUB_DX1LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX1LCDLR1+reg_base_adj)))+vref_lcdlr_offset));  //
							wrr_reg((DDR0_PUB_DX2LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX2LCDLR1+reg_base_adj)))+vref_lcdlr_offset));  //
							wrr_reg((DDR0_PUB_DX3LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX3LCDLR1+reg_base_adj)))+vref_lcdlr_offset));  //


							printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR1+reg_base_adj)),
									(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR1+reg_base_adj)))));
							printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX1LCDLR1+reg_base_adj)),
									(rdr_reg((unsigned int )((DDR0_PUB_DX1LCDLR1+reg_base_adj)))));
							printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX2LCDLR1+reg_base_adj)),
									(rdr_reg((unsigned int )((DDR0_PUB_DX2LCDLR1+reg_base_adj)))));
							printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX3LCDLR1+reg_base_adj)),
									(rdr_reg((unsigned int )((DDR0_PUB_DX3LCDLR1+reg_base_adj)))));

							temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);

							{
								wrr_reg((DDR0_PUB_DX0LCDLR1+reg_base_adj),dxnlcdlr1[0]);  //
								wrr_reg((DDR0_PUB_DX1LCDLR1+reg_base_adj),dxnlcdlr1[1]);  //
								wrr_reg((DDR0_PUB_DX2LCDLR1+reg_base_adj),dxnlcdlr1[2]);  //
								wrr_reg((DDR0_PUB_DX3LCDLR1+reg_base_adj),dxnlcdlr1[3]);  //

							}
						}

						//	/*
						{
							{
								wrr_reg((DDR0_PUB_DX0LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX0LCDLR1+reg_base_adj)))-vref_lcdlr_offset));  //
								wrr_reg((DDR0_PUB_DX1LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX1LCDLR1+reg_base_adj)))-vref_lcdlr_offset));  //
								wrr_reg((DDR0_PUB_DX2LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX2LCDLR1+reg_base_adj)))-vref_lcdlr_offset));  //
								wrr_reg((DDR0_PUB_DX3LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX3LCDLR1+reg_base_adj)))-vref_lcdlr_offset));  //


								printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR1+reg_base_adj)),
										(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR1+reg_base_adj)))));
								printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX1LCDLR1+reg_base_adj)),
										(rdr_reg((unsigned int )((DDR0_PUB_DX1LCDLR1+reg_base_adj)))));
								printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX2LCDLR1+reg_base_adj)),
										(rdr_reg((unsigned int )((DDR0_PUB_DX2LCDLR1+reg_base_adj)))));
								printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX3LCDLR1+reg_base_adj)),
										(rdr_reg((unsigned int )((DDR0_PUB_DX3LCDLR1+reg_base_adj)))));

								temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
								ddr_test_watchdog_clear();
								{
									wrr_reg((DDR0_PUB_DX0LCDLR1+reg_base_adj),dxnlcdlr1[0]);  //
									wrr_reg((DDR0_PUB_DX1LCDLR1+reg_base_adj),dxnlcdlr1[1]);  //
									wrr_reg((DDR0_PUB_DX2LCDLR1+reg_base_adj),dxnlcdlr1[2]);  //
									wrr_reg((DDR0_PUB_DX3LCDLR1+reg_base_adj),dxnlcdlr1[3]);  //

								}
							}


						}
						//*/
					}


					if (temp_test_error)
					{
						printf("\nvref  edge detect \n");
						if (iovref_test_step == 0)
						{

							iovref_lef=((iovref_temp_value+training_step)<0x32)?((iovref_temp_value+training_step)):(0x32);
							iovref_temp_value=iovref_org;
						}
						if (iovref_test_step == 1)
						{

							iovref_rig=(iovref_temp_value>training_step)?((iovref_temp_value-training_step)):(0);
							iovref_temp_value=iovref_org;
						}
						iovref_test_step++;
						//	break;
					}
					else
					{
						printf("\niovref_lef1=%x\n",iovref_lef);
						printf("\niovref_test_step=%x\n",iovref_test_step);
						if (iovref_test_step == 0)
						{
							printf("\niovref_lef1_2=%x\n",(iovref_temp_value-training_step));
							iovref_lef=(iovref_temp_value>training_step)?((iovref_temp_value-training_step)):(0);
							iovref_temp_value=iovref_lef;
							if (iovref_lef == 0)
							{
								iovref_test_step++;
								iovref_temp_value=iovref_org;
							}
						}
						if (iovref_test_step == 1)
						{
							iovref_rig=((iovref_temp_value+training_step)<0x32)?(iovref_temp_value+training_step):(0x32);
							iovref_temp_value=iovref_rig;
							if (iovref_rig == 0x32)
								iovref_test_step++;
						}
						printf("\niovref_lef2=%x\n",iovref_lef);
					}
					{


						wrr_reg((PREG_STICKY_REG7),iovref_org|(iovref_lef<<8)|((iovref_rig<<16))|(iovref_test_step<<24));
						printf("\nddr4ram vref test will reboot use new dram vref setting==0x%08x\n ",(rdr_reg((unsigned int )(PREG_STICKY_REG7))));
						char str[100];
						sprintf(str,"ddr_test_cmd 0x17 %d 0 0 0 0x%x",dram_iovref_test_ddr_clk,iovref_temp_value|((vref_dram_range&1)<<6));
						printf("\nstr=%s\n",str);
						run_command(str,0);
						//run_command("ddr_test_cmd 0x17 1100 0 0 0xsoc 0xdram ",0);//
					}
				}

				ddr_test_watchdog_disable();
				if (iovref_test_step >= 2)
				{
					printf("\n\ndram  iovref test clk==%d\n",dram_iovref_test_ddr_clk);
					printf("\n\n iovref  vddq=1.2v,if use other vddq ,please recount\n");
					printf("\nddr4ram vref test finish iovref_test_step==0x%08x\n ",iovref_test_step);
					iovref_org=(rdr_reg((unsigned int )((PREG_STICKY_REG7))))&0x3f;  //
					iovref_lef=((rdr_reg((unsigned int )((PREG_STICKY_REG7))))>>8)&0x3f;
					iovref_rig=((rdr_reg((unsigned int )((PREG_STICKY_REG7))))>>16)&0x3f;
					iovref_test_step=((rdr_reg((unsigned int )((PREG_STICKY_REG7))))>>24)&0x3f;
					iovref_mid=(iovref_lef+iovref_rig)/2;
					if (vref_dram_range == 0)
					{
						printf("iovref_org==0x%08x,%08dmV||iovref_lef==0x%08x,%08dmV||iovref_rig==0x%08x,%08dmV||iovref_mid0x%08x,%08dmV\n",
								iovref_org,((((((iovref_org&0X3F)*65)+6000)*1200)/10000)),iovref_lef,((((((iovref_lef&0X3F)*65)+6000)*1200)/10000)),
								iovref_rig,((((((iovref_rig&0X3F)*65)+6000)*1200)/10000)),iovref_mid,((((((iovref_mid&0X3F)*65)+6000)*1200)/10000)));
					}
					if (vref_dram_range)
					{
						printf("iovref_org==0x%08x,%08dmV||iovref_lef==0x%08x,%08dmV||iovref_rig==0x%08x,%08dmV||iovref_mid0x%08x,%08dmV\n",
								iovref_org,((((((iovref_org&0X3F)*65)+4500)*1200)/10000)),iovref_lef,((((((iovref_lef&0X3F)*65)+4500)*1200)/10000)),
								iovref_rig,((((((iovref_rig&0X3F)*65)+4500)*1200)/10000)),iovref_mid,((((((iovref_mid&0X3F)*65)+4500)*1200)/10000)));
					}
					if (iovref_rig == 0x32)
					{
						printf("\n\n iovref  rig reach reg max\n");
					}
					if (iovref_rig == 0x0)
					{
						printf("\n\n iovref  lef reach reg min\n");
					}
					//char str2[100];
					//sprintf(str2,"ddr_test_cmd 0x17 %d 0 0 0 0x%x",global_ddr_clk,iovref_org);
					//printf("\nstr2=%s\n",str2);
					//run_command(str2,0);
					{
						{
							sprintf(str_temp1,"ddr_dram_iovref_org");
							sprintf(str_temp2,"0x%08x",iovref_org);
							setenv(str_temp1, str_temp2);
							run_command("save",0);
						}
						{
							sprintf(str_temp1,"ddr_dram_iovref_lef");
							sprintf(str_temp2,"0x%08x",iovref_lef);
							setenv(str_temp1, str_temp2);
							run_command("save",0);
						}
						{
							sprintf(str_temp1,"ddr_dram_iovref_rig");
							sprintf(str_temp2,"0x%08x",iovref_rig);
							setenv(str_temp1, str_temp2);
							run_command("save",0);
						}
						{
							sprintf(str_temp1,"ddr_dram_vref_range");
							sprintf(str_temp2,"0x%08x",vref_dram_range);
							setenv(str_temp1, str_temp2);
							run_command("save",0);
						}
					}



















				}



			}






		}

	}




	return 0;

usage:
	cmd_usage(cmdtp);
#endif
	return 1;

}

#endif
int do_ddr4_test_dram_ac_vref(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
#if ( CONFIG_DDR_PHY>=P_DDR_PHY_905X)
	///*
	// unsigned int  start_addr=test_start_addr;
	printf("\nEnter Test ddr4 phy_ac or ddr3 dram data vref function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);

	//  unsigned int   loop = 1;
	//   unsigned int   temp_count_i = 1;
	//   unsigned int   temp_count_j= 1;
	//    unsigned int   temp_count_k= 1;
	unsigned int   temp_test_error= 0;
	int training_seed=0;
	int training_step=0;

	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_dram_ac_data=0;
	//  unsigned int   test_times=1;
	unsigned int   reg_add=0;
	unsigned int   reg_base_adj=0;
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;
	unsigned int   testing_channel = 0;
	unsigned int   dxnlcdlr1[4];
	// unsigned int   dxnlcdlr4[4];


#define  CHANNEL_A  0
#define  CHANNEL_B  1

#define  DDR_CORSS_TALK_TEST_SIZE   0x20000
	//   #define DDR0_PUB_REG_BASE					0xc8836000
#define DDR0_PUB_DX0GCR4      ( DDR0_PUB_REG_BASE + ( 0x1c4  << 2 ) )
#define DDR0_PUB_DX1GCR4     ( DDR0_PUB_REG_BASE + ( 0x204  << 2 ) )
#define DDR0_PUB_DX2GCR4      ( DDR0_PUB_REG_BASE + ( 0x244  << 2 ) )
#define DDR0_PUB_DX3GCR4      ( DDR0_PUB_REG_BASE + ( 0x284  << 2 ) )
#define DDR0_PUB_DX0GCR5      ( DDR0_PUB_REG_BASE + ( 0x1c5  << 2 ) )
#define DDR0_PUB_DX1GCR5      ( DDR0_PUB_REG_BASE + ( 0x205  << 2 ) )
#define DDR0_PUB_DX2GCR5      ( DDR0_PUB_REG_BASE + ( 0x245  << 2 ) )
#define DDR0_PUB_DX3GCR5      ( DDR0_PUB_REG_BASE + ( 0x285  << 2 ) )

	//#define DDR0_PUB_IOVCR0        ( DDR0_PUB_REG_BASE + ( 0x148 << 2 ) ) // R/W - IO VREF Control Register 0
	//#define DDR0_PUB_IOVCR1        ( DDR0_PUB_REG_BASE + ( 0x149 << 2 ) ) // R/W - IO VREF Control Register 1


	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;

	//   unsigned int   ac_bdlr_lef[10];
	//   unsigned int   ac_bdlr_rig[10];
	int   iovref_temp_value;
	//    int   iovref_temp_reg_value;
	//    unsigned int  reg_seed_value;
	//	   unsigned int   temp_reg_value;
	int   iovref_org;
	int   iovref_lef;
	int   iovref_rig;
	//  unsigned int   temp_test_error;
	//	unsigned int temp_i=0;
	//	unsigned int temp_j=0;
	//unsigned int reg_add=0;
	//		static unsigned int training_enabled=1;

	//	 iovref_lef=0x49;
	// printf("\n\n iovref  org                     ==0x%08x   %08dmV\n",iovref_lef,(((((iovref_lef&0X3F)*7)+440)*3)/2)+1);
	//#define DDR_TEST_ACLCDLR


	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))
			channel_a_en = 1;
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))
			channel_b_en = 1;
		else
			goto usage;
	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))
			channel_a_en = 1;
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))
			channel_b_en = 1;
	}
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}

	}
	if (argc >4) {
		test_dram_ac_data = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
		{
			test_dram_ac_data = 0;
		}
		if (  test_dram_ac_data )
			test_dram_ac_data = 1;

	}
	training_seed = 0;
	if (argc >5) {
		training_seed = simple_strtoull_ddr(argv[5], &endp, 16);
		if (*argv[5] == 0 || *endp != 0)
		{
			training_seed =0;// 0x2e;
		}


	}


	training_step = 0;
	if (argc >6) {
		training_step = simple_strtoull_ddr(argv[6], &endp, 16);
		if (*argv[6] == 0 || *endp != 0)
		{
			training_step = 0;
		}



	}
	int vref_all=0;
	if (argc >7) {
		vref_all = simple_strtoull_ddr(argv[7], &endp, 16);
		if (*argv[7] == 0 || *endp != 0)
		{
			vref_all =0;// 0x2e;
		}}
	int vref_lcdlr_offset=0;
	if (argc >8) {
		vref_lcdlr_offset = simple_strtoull_ddr(argv[8], &endp, 16);
		if (*argv[8] == 0 || *endp != 0)
		{
			vref_lcdlr_offset =0;
		}}
	int soc_dram_hex_dec=0;
	if (argc >9)
	{
		soc_dram_hex_dec = simple_strtoull_ddr(argv[9], &endp, 16);
		if (*argv[9] == 0 || *endp != 0) {
			soc_dram_hex_dec = 0;
		}
	}
	if (training_seed ==0) // 0x2e;
	{training_seed=0x9;
	}
	if (soc_dram_hex_dec)
	{
		if (argc >5) {
			training_seed = simple_strtoull_ddr(argv[5], &endp, 0);
			if (*argv[5] == 0 || *endp != 0)
			{
				training_seed =0;// 0x2e;
			}


		}
		if (training_seed ==0) // 0x2e;
		{training_seed=50;
		}
		if (training_seed<45)
			training_seed=45;
		if (training_seed>88)
			training_seed=88;
		training_seed =(((training_seed*1000-44070)/698));

	}



	printf("\n\n iovref  training_seed             ==0x%08x   %08dmV\n",training_seed,(((((training_seed&0X3F)*7)+440)*3)/2)+1);
	printf("\nchannel_a_en== 0x%08x\n", channel_a_en);
	printf("\nchannel_b_en== 0x%08x\n", channel_b_en);
	printf("\nddr_test_size== 0x%08x\n", ddr_test_size);
	printf("\ntest_dram_ac_data== 0x%08x\n", test_dram_ac_data);
	printf("\nvref_all== 0x%08x\n", vref_all);
	printf("\nvref_lcdlr_offset== 0x%08x\n", vref_lcdlr_offset);
	if ( channel_a_en)
	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}
	if ( channel_b_en)
	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}

	//save and print org training dqs value
	if (channel_a_en || channel_b_en)
	{
		//dcache_disable();
		//serial_puts("\ndebug for ddrtest ,jiaxing disable dcache");
	}////save and print org training  value



	{
		////tune and save training dqs value
		if (channel_a_en || channel_b_en)

		{
			for ((testing_channel=0);(testing_channel<(channel_a_en+channel_b_en));(testing_channel++))
			{

				if (( channel_a_en) && ( channel_b_en == 0))
				{
					reg_base_adj=CHANNEL_A_REG_BASE;
				}
				else if(( channel_b_en)&&( channel_a_en==0))
				{
					reg_base_adj=CHANNEL_B_REG_BASE;
				}
				else if ((channel_a_en+channel_b_en)==2)
				{
					if ( testing_channel == CHANNEL_A)
					{
						reg_base_adj=CHANNEL_A_REG_BASE;
					}
					else if( testing_channel==CHANNEL_B)
					{
						reg_base_adj=CHANNEL_B_REG_BASE;
					}
				}

				if (reg_base_adj == CHANNEL_A_REG_BASE)
				{
					printf("\ntest A channel data lane\n");
				}
				else
				{
					printf("\ntest B channel data lane\n");
				}


				{


#define wrr_reg(addr, data)	(*((volatile  unsigned int  *)((unsigned long)(unsigned int )addr)))=(data)  //wr_reg(addr, data)
#define rdr_reg(addr)		 (unsigned int )(*((volatile  unsigned int  *)((unsigned long)(unsigned int )addr)))  //rd_reg(addr)
					unsigned int   dxnmdlr=0;
					reg_add=DDR0_PUB_DX0MDLR0+reg_base_adj;
					dxnmdlr=((rdr_reg((unsigned int )reg_add))>>16)&0x1ff;
					//	reg_seed_value=(training_seed|(0x0<<8)|(0x0<<16)|(0x0<<24));
					printf("\ndxnmdlr==0x%08x\n ",dxnmdlr);
					//turn off ddr4 phy read vref gate,only output ac lane vref
					wrr_reg((((DDR0_PUB_DX0GCR4))),((rdr_reg((unsigned int )(DDR0_PUB_DX0GCR4)))&(~(1<<28)))|(7<<25)|(0xf<<2));
					wrr_reg((((DDR0_PUB_DX1GCR4))),((rdr_reg((unsigned int )(DDR0_PUB_DX1GCR4)))&(~(1<<28)))|(7<<25)|(0xf<<2));
					wrr_reg((((DDR0_PUB_DX2GCR4))),((rdr_reg((unsigned int )(DDR0_PUB_DX2GCR4)))&(~(1<<28)))|(7<<25)|(0xf<<2));
					wrr_reg((((DDR0_PUB_DX3GCR4))),((rdr_reg((unsigned int )(DDR0_PUB_DX3GCR4)))&(~(1<<28)))|(7<<25)|(0xf<<2));
					printf("\norg DDR0_PUB_IOVCR0==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_IOVCR0))));
					printf("\norg DDR0_PUB_IOVCR1==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_IOVCR1))));
					wrr_reg((((DDR0_PUB_IOVCR0))),training_seed|(training_seed<<8)|(training_seed<<16)|(0x1f<<24));
					wrr_reg((((DDR0_PUB_IOVCR1))),0x109);
					printf("\nDDR0_PUB_DX0GCR4==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_DX0GCR4))));
					printf("\nDDR0_PUB_DX1GCR4==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_DX1GCR4))));
					printf("\nDDR0_PUB_DX2GCR4==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_DX2GCR4))));
					printf("\nDDR0_PUB_DX3GCR4==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_DX3GCR4))));
					printf("\nDDR0_PUB_IOVCR0==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_IOVCR0))));
					printf("\nDDR0_PUB_IOVCR1==0x%08x\n ",(rdr_reg((unsigned int )(DDR0_PUB_IOVCR1))));
					unsigned int   temp_i=0;

					for ((  temp_i=0);(temp_i<4);( temp_i++))
					{
						{
							dxnlcdlr1[temp_i]=(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR1+reg_base_adj)+temp_i*(DDR0_PUB_DX1LCDLR1-DDR0_PUB_DX0LCDLR1))));

							printf("\ndxnlcdlr1[%08x]==0x%08x,dxnlcdlr1[%08x]==0x%08x\n ",temp_i,dxnlcdlr1[temp_i],temp_i,dxnlcdlr1[temp_i]);

						}
					}
					reg_add=DDR0_PUB_IOVCR0+reg_base_adj;
					iovref_temp_value=rdr_reg((unsigned int )reg_add);
					iovref_org=((iovref_temp_value)&0xff);
					//	 iovref_lef=0x49;

					{
						printf("reg_add==0x%08x,value==0x%08x, iovref  org ==0x%08x   %08dmV\n",reg_add,
								iovref_temp_value,iovref_org,((((((iovref_temp_value&0X3F)*7)+440)*3)/2)+1)*15/15);
					}


					wrr_reg((reg_add),iovref_temp_value);  //
					iovref_lef=(iovref_org)&0xff;
					iovref_rig=(iovref_org)&0xff;

				}

				printf("\ntraining_step==0x%08x\n ",training_step);


				{






					{

						iovref_temp_value=rdr_reg((unsigned int )reg_add);
						iovref_temp_value=((iovref_temp_value)&0xff);

						while (iovref_temp_value>0x0)
						{
							temp_test_error=0;
							iovref_temp_value=iovref_temp_value-training_step;
							if (iovref_temp_value<training_step)
								iovref_temp_value=0;
							printf("\niovref lef temp==0x%08x\n ",iovref_temp_value);


							wrr_reg((reg_add),(0x1f000000|iovref_temp_value|(iovref_temp_value<<8)|(iovref_temp_value<<16)));

							printf("\n reg_add 0x%08x== 0x%08x\n ",reg_add,rdr_reg((unsigned int )reg_add));

							temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
							temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
							if (vref_lcdlr_offset)
							{
								{
									wrr_reg((DDR0_PUB_DX0LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX0LCDLR1+reg_base_adj)))+vref_lcdlr_offset));  //
									wrr_reg((DDR0_PUB_DX1LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX1LCDLR1+reg_base_adj)))+vref_lcdlr_offset));  //
									wrr_reg((DDR0_PUB_DX2LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX2LCDLR1+reg_base_adj)))+vref_lcdlr_offset));  //
									wrr_reg((DDR0_PUB_DX3LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX3LCDLR1+reg_base_adj)))+vref_lcdlr_offset));  //


									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR1+reg_base_adj)))));
									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX1LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX1LCDLR1+reg_base_adj)))));
									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX2LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX2LCDLR1+reg_base_adj)))));
									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX3LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX3LCDLR1+reg_base_adj)))));

									temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);


									{
										wrr_reg((DDR0_PUB_DX0LCDLR1+reg_base_adj),dxnlcdlr1[0]);  //
										wrr_reg((DDR0_PUB_DX1LCDLR1+reg_base_adj),dxnlcdlr1[1]);  //
										wrr_reg((DDR0_PUB_DX2LCDLR1+reg_base_adj),dxnlcdlr1[2]);  //
										wrr_reg((DDR0_PUB_DX3LCDLR1+reg_base_adj),dxnlcdlr1[3]);  //

									}

								}

							}

							if (vref_lcdlr_offset)
							{
								{
									wrr_reg((DDR0_PUB_DX0LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX0LCDLR1+reg_base_adj)))-vref_lcdlr_offset));  //
									wrr_reg((DDR0_PUB_DX1LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX1LCDLR1+reg_base_adj)))-vref_lcdlr_offset));  //
									wrr_reg((DDR0_PUB_DX2LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX2LCDLR1+reg_base_adj)))-vref_lcdlr_offset));  //
									wrr_reg((DDR0_PUB_DX3LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX3LCDLR1+reg_base_adj)))-vref_lcdlr_offset));  //


									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR1+reg_base_adj)))));
									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX1LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX1LCDLR1+reg_base_adj)))));
									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX2LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX2LCDLR1+reg_base_adj)))));
									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX3LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX3LCDLR1+reg_base_adj)))));

									temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);


									{
										wrr_reg((DDR0_PUB_DX0LCDLR1+reg_base_adj),dxnlcdlr1[0]);  //
										wrr_reg((DDR0_PUB_DX1LCDLR1+reg_base_adj),dxnlcdlr1[1]);  //
										wrr_reg((DDR0_PUB_DX2LCDLR1+reg_base_adj),dxnlcdlr1[2]);  //
										wrr_reg((DDR0_PUB_DX3LCDLR1+reg_base_adj),dxnlcdlr1[3]);  //

									}

								}

							}
							if (temp_test_error)
							{
								printf("\nvref down edge detect \n");
								iovref_temp_value=iovref_temp_value+training_step;
								break;
							}
						}

						printf("\n down edge detect \n");
						printf("\n\n iovref                       down edge==0x%08x\n ",iovref_temp_value);
						iovref_lef=iovref_temp_value;

						wrr_reg((reg_add),iovref_org);  //
						wrr_reg((DDR0_PUB_DX0LCDLR1+reg_base_adj),dxnlcdlr1[0]);  //
						wrr_reg((DDR0_PUB_DX1LCDLR1+reg_base_adj),dxnlcdlr1[1]);  //
						wrr_reg((DDR0_PUB_DX2LCDLR1+reg_base_adj),dxnlcdlr1[2]);  //
						wrr_reg((DDR0_PUB_DX3LCDLR1+reg_base_adj),dxnlcdlr1[3]);  //



					}

					{

						iovref_temp_value=rdr_reg((unsigned int )reg_add);
						iovref_temp_value=((iovref_temp_value)&0xff);

						while (iovref_temp_value<0x3f)
						{
							temp_test_error=0;
							iovref_temp_value=iovref_temp_value+training_step;
							if (iovref_temp_value>0x3f)
								iovref_temp_value=0x3f;
							printf("\niovref rig temp==0x%08x\n ",iovref_temp_value);

							wrr_reg((reg_add),(0x1f000000|iovref_temp_value|(iovref_temp_value<<8)|(iovref_temp_value<<16)));

							printf("\n reg_add 0x%08x== 0x%08x\n ",reg_add,rdr_reg((unsigned int )reg_add));

							temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
							temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
							if (vref_lcdlr_offset)
							{
								{
									wrr_reg((DDR0_PUB_DX0LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX0LCDLR1+reg_base_adj)))+vref_lcdlr_offset));  //
									wrr_reg((DDR0_PUB_DX1LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX1LCDLR1+reg_base_adj)))+vref_lcdlr_offset));  //
									wrr_reg((DDR0_PUB_DX2LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX2LCDLR1+reg_base_adj)))+vref_lcdlr_offset));  //
									wrr_reg((DDR0_PUB_DX3LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX3LCDLR1+reg_base_adj)))+vref_lcdlr_offset));  //


									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR1+reg_base_adj)))));
									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX1LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX1LCDLR1+reg_base_adj)))));
									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX2LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX2LCDLR1+reg_base_adj)))));
									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX3LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX3LCDLR1+reg_base_adj)))));

									temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);


									{
										wrr_reg((DDR0_PUB_DX0LCDLR1+reg_base_adj),dxnlcdlr1[0]);  //
										wrr_reg((DDR0_PUB_DX1LCDLR1+reg_base_adj),dxnlcdlr1[1]);  //
										wrr_reg((DDR0_PUB_DX2LCDLR1+reg_base_adj),dxnlcdlr1[2]);  //
										wrr_reg((DDR0_PUB_DX3LCDLR1+reg_base_adj),dxnlcdlr1[3]);  //

									}

								}

							}

							if (vref_lcdlr_offset)
							{
								{
									wrr_reg((DDR0_PUB_DX0LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX0LCDLR1+reg_base_adj)))-vref_lcdlr_offset));  //
									wrr_reg((DDR0_PUB_DX1LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX1LCDLR1+reg_base_adj)))-vref_lcdlr_offset));  //
									wrr_reg((DDR0_PUB_DX2LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX2LCDLR1+reg_base_adj)))-vref_lcdlr_offset));  //
									wrr_reg((DDR0_PUB_DX3LCDLR1+reg_base_adj),((rdr_reg((unsigned int )(DDR0_PUB_DX3LCDLR1+reg_base_adj)))-vref_lcdlr_offset));  //


									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX0LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX0LCDLR1+reg_base_adj)))));
									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX1LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX1LCDLR1+reg_base_adj)))));
									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX2LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX2LCDLR1+reg_base_adj)))));
									printf("\n reg_add 0x%08x== 0x%08x\n ",((DDR0_PUB_DX3LCDLR1+reg_base_adj)),
											(rdr_reg((unsigned int )((DDR0_PUB_DX3LCDLR1+reg_base_adj)))));

									temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);


									{
										wrr_reg((DDR0_PUB_DX0LCDLR1+reg_base_adj),dxnlcdlr1[0]);  //
										wrr_reg((DDR0_PUB_DX1LCDLR1+reg_base_adj),dxnlcdlr1[1]);  //
										wrr_reg((DDR0_PUB_DX2LCDLR1+reg_base_adj),dxnlcdlr1[2]);  //
										wrr_reg((DDR0_PUB_DX3LCDLR1+reg_base_adj),dxnlcdlr1[3]);  //

									}

								}

							}
							if (temp_test_error)
							{
								printf("\nvref up edge detect \n");
								iovref_temp_value=iovref_temp_value-training_step;
								break;
							}
						}

						printf("\n up edge detect \n");
						printf("\n\n iovref                       up edge==0x%08x\n ",iovref_temp_value);
						iovref_rig=iovref_temp_value;

						wrr_reg((reg_add),iovref_org);  //
						wrr_reg((DDR0_PUB_DX0LCDLR1+reg_base_adj),dxnlcdlr1[0]);  //
						wrr_reg((DDR0_PUB_DX1LCDLR1+reg_base_adj),dxnlcdlr1[1]);  //
						wrr_reg((DDR0_PUB_DX2LCDLR1+reg_base_adj),dxnlcdlr1[2]);  //
						wrr_reg((DDR0_PUB_DX3LCDLR1+reg_base_adj),dxnlcdlr1[3]);  //



					}



					{
						printf("\n\n iovref  vddq=1.5v,if use other vddq ,please recount\n");
						printf("\n vddq=1.5v iovref  ac+dram_data org==0x%08x   %08dmV||down edge==0x%08x %08dmV||up edge==0x%08x %08dmV||mid==0x%08x   %08dmV\n",
								iovref_org,(((((((iovref_org&0X3F)*7)+440)*3)/2)+1)*15/15),iovref_lef,(((((((iovref_lef&0X3F)*7)+440)*3)/2)+1)*15/15),
								iovref_rig,(((((((iovref_rig&0X3F)*7)+440)*3)/2)+1)*15/15),((iovref_lef+iovref_rig)/2),
								(((((((((iovref_lef+iovref_rig)/2)&0X3F)*7)+440)*3)/2)+1)*15/15)
							  );

						if (iovref_lef == 0x0)
						{
							printf("\n\n iovref   down edge reach  reg limited\n");
						}
						if (iovref_rig == 0x3f)
						{
							printf("\n\n iovref   up edge reach  reg limited\n");
						}
					}














				}



			}






		}

	}




	return 0;

usage:
	cmd_usage(cmdtp);
	//*/
#endif
	return 1;

}
//

int pll_convert_to_ddr_clk_g12a(unsigned int ddr_pll)
{
	unsigned int ddr_clk=0;
	unsigned int od_div=0xfff;
	ddr_pll=ddr_pll&0xfffff;
#if 1// (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
	//unsigned int ddr_clk = 2*((((24 * ((ddr_pll>>4)&0x1ff))/((ddr_pll>>16)&0x1f))>>((((ddr_pll>>0)&0x3)==3)?(2):(((ddr_pll>>0)&0x3))))/(((ddr_pll>>2)&0x3)+1));  //od1  od
	if(((ddr_pll>>16)&7)==0)
		od_div=2;
	if(((ddr_pll>>16)&7)==1)
		od_div=3;

	if(((ddr_pll>>16)&7)==2)
		od_div=4;

	if(((ddr_pll>>16)&7)==3)
		od_div=6;

	if(((ddr_pll>>16)&7)==4)
		od_div=8;

	if(((ddr_pll>>10)&0x1f))
		ddr_clk = 2*((((24 * ((ddr_pll>>0)&0x1ff))/((ddr_pll>>10)&0x1f))>>((((ddr_pll>>19)&0x1)==1)?(2):(1))))/od_div;

#else
	ddr_clk = 2*(((24 * (ddr_pll&0x1ff))/((ddr_pll>>9)&0x1f))>>((ddr_pll>>16)&0x3));

#endif


	return ddr_clk;
}


int ddr_clk_convert_to_pll_g12a(unsigned int ddr_clk, unsigned char pll_bypass_en)
{
	uint32_t ddr_pll_vco_ctrl=0;
	uint32_t ddr_pll_vco_m=0;
	uint32_t ddr_pll_vco_n=0;
	uint32_t ddr_pll_vco_ctrl_od=0;
	uint32_t ddr_pll_vco_ctrl_od1=0;
	ddr_pll_vco_n=1;
	if (pll_bypass_en == 0) {
		if ((ddr_clk >=4800/4)) {
			//datarate==vco should 3-4.8g
			ddr_pll_vco_ctrl_od=1;
			ddr_pll_vco_ctrl_od1=0x2; //0
			ddr_pll_vco_m=(ddr_clk*3)/24; //6
		}
		else if ((ddr_clk >4800/6)) {
			ddr_pll_vco_ctrl_od=2;
			ddr_pll_vco_ctrl_od1=0x2; //0
			ddr_pll_vco_m=(ddr_clk*4)/24; //8
		}
		else if ((ddr_clk > 4800/8)) {
			ddr_pll_vco_ctrl_od=3;
			ddr_pll_vco_ctrl_od1=0x2; //0
			ddr_pll_vco_m=(ddr_clk*6)/24; //12
		}
		else if ((ddr_clk > 4800/12)) {
			ddr_pll_vco_ctrl_od=4;
			ddr_pll_vco_ctrl_od1=0x2; //0
			ddr_pll_vco_m=(ddr_clk*8)/24; //16
		}
		else if ((ddr_clk > 360)) {
			ddr_pll_vco_ctrl_od=3;
			ddr_pll_vco_ctrl_od1=0x3; //0
			ddr_pll_vco_m=(ddr_clk*12)/24;
		}
		else {
			//32   should >200M
			ddr_pll_vco_ctrl_od=4;
			ddr_pll_vco_ctrl_od1=0x3;//0
			ddr_pll_vco_m=(ddr_clk*16)/24;
		}
	}
	if (pll_bypass_en == 1) {
		ddr_pll_vco_ctrl_od1=0x3;//0
		if ((ddr_clk >=800)) {
			//datarate==vco should 2.4-4.8g
			ddr_pll_vco_ctrl_od=0;
			ddr_pll_vco_m=(ddr_clk*4)/24;
		}
		else if ((ddr_clk < 4800/6)) {
			ddr_pll_vco_ctrl_od=1;
			ddr_pll_vco_m=(ddr_clk*2*3)/24;
		}
		else if ((ddr_clk < 4800/8)) {
			ddr_pll_vco_ctrl_od=2;
			ddr_pll_vco_m=(ddr_clk*2*4)/24;
		}
		else if ((ddr_clk < 4800/12)) {
			ddr_pll_vco_ctrl_od=3;
			ddr_pll_vco_m=(ddr_clk*2*6)/24;
		}
		else if ((ddr_clk < 4800/16)) {
			ddr_pll_vco_ctrl_od=4;
			ddr_pll_vco_m=(ddr_clk*2*8)/24;
		}
	}
	ddr_pll_vco_ctrl=ddr_pll_vco_m|(ddr_pll_vco_n<<10)|(ddr_pll_vco_ctrl_od<<16)|(ddr_pll_vco_ctrl_od1<<19);
	return ddr_pll_vco_ctrl;

	//return ddr_pll_vco_ctrl;
}
int pll_convert_to_ddr_clk(unsigned int ddr_pll)
{
	unsigned int ddr_clk=0;
	ddr_pll=ddr_pll&0xfffff;

#if ( CONFIG_DDR_PHY >= P_DDR_PHY_G12)
	//   printf("\ng12 ddr_pll== %08x \n", ddr_pll);
	ddr_clk=pll_convert_to_ddr_clk_g12a(  ddr_pll);
	return ddr_clk;
#endif
#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
	//unsigned int ddr_clk = 2*((((24 * ((ddr_pll>>4)&0x1ff))/((ddr_pll>>16)&0x1f))>>((((ddr_pll>>0)&0x3)==3)?(2):(((ddr_pll>>0)&0x3))))/(((ddr_pll>>2)&0x3)+1));
	if(((ddr_pll>>16)&0x1f))

		ddr_clk = 2*((((24 * ((ddr_pll>>4)&0x1ff))/((ddr_pll>>16)&0x1f))>>((((ddr_pll>>0)&0x3)==3)?(2):(((ddr_pll>>0)&0x3))))>>((((ddr_pll>>2)&0x3)==3)?(2):(((ddr_pll>>2)&0x3))));

#else
	if((ddr_pll>>9)&0x1f)
		ddr_clk = 2*(((24 * (ddr_pll&0x1ff))/((ddr_pll>>9)&0x1f))>>((ddr_pll>>16)&0x3));

#endif

#if (CONFIG_DDR_PHY == P_DDR_PHY_DEFAULT)
	if((ddr_pll>>9)&0x1f)
		ddr_clk = 2*((24 * (ddr_pll&0x1ff))/((ddr_pll>>9)&0x1f))>>((ddr_pll>>16)&0x3);
#endif

	return ddr_clk;
}

int ddr_clk_convert_to_pll(unsigned int ddr_clk)
{
	unsigned int ddr_pll=0x10221;

#if ( CONFIG_DDR_PHY >= P_DDR_PHY_G12)
	ddr_pll=ddr_clk_convert_to_pll_g12a(  ddr_clk,0);
	return ddr_pll;
#endif

	/* set ddr pll reg */
	if ((ddr_clk >= 40) && (ddr_clk < 750)) {
		//							OD			N					M
		ddr_pll= (2 << 16) | (1 << 9) | ((((ddr_clk/6)*6)/12) << 0);
	}
	else if((ddr_clk >= 750) && (ddr_clk < 2000)) {
		//							OD			N					M
		ddr_pll= (1 << 16) | (1 << 9) | ((((ddr_clk/12)*12)/24) << 0);
	}

#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
	ddr_pll=0x00104c5;
	/* set ddr pll reg */
	/*
	   if ((ddr_clk >= 40) && (ddr_clk < 750)) {
	//							OD			N					M
	ddr_pll= (2 << 2) | (1 << 16) | ((((ddr_clk/6)*6)/12) << 4);
	}
	else if((ddr_clk >= 750) && (ddr_clk < 2000)) {
	//							OD			N					M
	ddr_pll= (1 << 2) | (1 << 16) | ((((ddr_clk/12)*12)/24) << 4);
	}
	*/
	if ((ddr_clk < 200)) {
		//							OD1			OD			N					M
		ddr_pll= (2 << 0) | (3 << 2) | (1 << 16) | ((((ddr_clk*6)/6)/3) << 4);
	}
	else if ((ddr_clk>= 200) && (ddr_clk< 400)) {
		//							OD1			OD			N					M
		ddr_pll= (2 << 0) | (1 << 2) | (1 << 16) | ((((ddr_clk*6)/6)/6) << 4);
	}
	else if ((ddr_clk>= 400) && (ddr_clk < 800)) {
		//							OD1			OD			N					M
		ddr_pll= (1 << 0) | (1 << 2) | (1 << 16) | ((((ddr_clk*12)/12)/12) << 4);
	}
	else if ((ddr_clk >= 800) && (ddr_clk < 2000)) {
		//							OD1			OD			N					M
		ddr_pll= (0 << 0) | (1 << 2) | (1 << 16) | ((((ddr_clk*12)/12)/24) << 4);
	}
#endif

#if (CONFIG_DDR_PHY == P_DDR_PHY_DEFAULT)
	{


		if ((ddr_clk < 750)) {
			//		OD			N		M
			ddr_pll= (2 << 16) | (1 << 9) | (((ddr_clk/24)*2)<< 0) ;
		}
		else if ((ddr_clk >= 750)) {
			//		OD			N		M
			ddr_pll= (1 << 16) | (1 << 9) | ((ddr_clk/24)<< 0) ;
		}

	}
#endif

	return ddr_pll;
}


int do_ddr4_test_dram_clk(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	///*
	int i=0;
	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}
	char *endp;

#define TEST_DRAM_CLK_USE_ENV  1
	printf("\ntune ddr CLK use uboot env\n");

#define  DDR_CORSS_TALK_TEST_SIZE   0x20000
#define  DDR_TEST_MIN_FREQ_LIMITED  50
#define  DDR_TEST_MIN_FREQ  300
#define  DDR_TEST_MAX_FREQ  3000

	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;
	unsigned int start_freq=DDR_TEST_MIN_FREQ;
	unsigned int end_freq=DDR_TEST_MAX_FREQ;
	unsigned int test_loops=1;
	//printf("\n111tune ddr CLK use uboot env\n");
	if (argc == 1)
	{
		printf("\nplease read help\n");
		ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		start_freq=DDR_TEST_MIN_FREQ;
		end_freq=DDR_TEST_MAX_FREQ;

	}

	if (argc == 2)
	{
		ddr_test_size = simple_strtoull_ddr(argv[1], &endp, 0);
		start_freq=DDR_TEST_MIN_FREQ;
		end_freq=DDR_TEST_MAX_FREQ;
	}
	if (argc== 3)
	{
		ddr_test_size = simple_strtoull_ddr(argv[1], &endp, 0);
		start_freq= simple_strtoull_ddr(argv[2], &endp, 0);
		end_freq=DDR_TEST_MAX_FREQ;

	}
	if (argc== 4)
	{
		ddr_test_size = simple_strtoull_ddr(argv[1], &endp, 0);
		start_freq= simple_strtoull_ddr(argv[2], &endp, 0);
		end_freq=simple_strtoull_ddr(argv[3], &endp, 0);

	}
	if (argc> 4)
	{
		ddr_test_size = simple_strtoull_ddr(argv[1], &endp, 0);
		start_freq= simple_strtoull_ddr(argv[2], &endp, 0);
		end_freq=simple_strtoull_ddr(argv[3], &endp, 0);
		test_loops=simple_strtoull_ddr(argv[4], &endp, 0);
	}
	unsigned int temp_test_error=0x0;
	unsigned int ddr_pll=0;
	unsigned int ddr_clk_org=0;
	unsigned int ddr_clk_hope_test=0;
#if ( CONFIG_DDR_PHY >= P_DDR_PHY_G12)

	//#define AM_DDR_PLL_CNTL0     	       ( MMC_REG_BASE + ( 0x0	<< 2 ) )
	ddr_pll = rd_reg(G12_AM_DDR_PLL_CNTL0);
#else
	ddr_pll = rd_reg(AM_DDR_PLL_CNTL);
#endif
	//ddr_pll=ddr_pll_org;
	printf("\nddr_pll== %08x\n", ddr_pll);
#if  0 
#else
	unsigned int ddr_clk = pll_convert_to_ddr_clk(ddr_pll);
	ddr_clk_org=ddr_clk;
	printf("\nddr_clk== %dMHz\n", ddr_clk);
	printf("\nstart_freq== %dMHz\n", start_freq);
	printf("\nend_freq== %dMHz\n", end_freq);
	ddr_pll = ddr_clk_convert_to_pll(ddr_clk);
#endif

	//	{
	//	wr_reg(AM_DDR_PLL_CNTL, (((rd_reg(AM_DDR_PLL_CNTL))&(~(0xfffff)))|(ddr_pll)));
	//	ddr_udelay(2000);
	//}


	unsigned int freq_table_test_value[(DDR_TEST_MAX_FREQ)/12]; // step =0 init  ,1 test fail, ,2 test pass,3 test skip;
	//  char char_freq_name_table[30];
	//  const char *p_char_freq_table;

	const char *p_char_ddr_test_step;
	const char * p_char_freq_org;
	char char_freq_org[30];
	int  ddr_feq_test_step=0; // step =0 init ,1 going ,2 done;

	const char * p_char_freq_name_table;
	char char_freq_name_table[30];
	char char_cmd_table[100];
	char * p_char_store_boot;
	//  char char_freq_store_boot[200];

	//const char *p_freq_table_int;
	//char char_ddr_feq_test_step[]="ddr_feq_test_step";
	// const char *varname;
	// const char *varvalue;
	unsigned int temp_count=0;
	unsigned int temp_count_sub=0;


	//
	p_char_ddr_test_step= getenv("ddr_feq_test_step");
	if (p_char_ddr_test_step)
	{
		printf("%s",p_char_ddr_test_step);

		ddr_feq_test_step = simple_strtoull_ddr(p_char_ddr_test_step, &endp, 0);
		printf("ddr_feq_test_step=%d\n",ddr_feq_test_step);
	}
	if (ddr_feq_test_step) {
		p_char_freq_org= getenv("ddr_feq_org");
		if (p_char_freq_org)
		{
			printf("%s",p_char_freq_org);

			ddr_clk_org = simple_strtoull_ddr(p_char_freq_org, &endp, 10); //must use 10 ,freq  0792 maybe not read successful use 0 auto read
			printf("ddr_clk_org=%d\n",ddr_clk_org);
		}
	}
	if (ddr_feq_test_step == 0)
	{
		ddr_feq_test_step=1;
		ddr_clk_org=ddr_clk;
		sprintf(char_freq_org,"%04d",ddr_clk);
		printf("\nddr_org_freq=%s\n",char_freq_org);
		setenv("ddr_feq_org", char_freq_org);

		temp_count=(DDR_TEST_MIN_FREQ_LIMITED/12);
		while (temp_count<(DDR_TEST_MAX_FREQ/12)) {

			// sprintf(freq_table,"%s%04d %01d %01d  ",freq_table,(temp_count*12),0,0);
			sprintf(char_freq_name_table,"ddr_fre_%04d",(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12))));
			printf("\nchar_freq_name_table=%s\n",char_freq_name_table);
			setenv(char_freq_name_table, "0");
			setenv("ddr_feq_test_step", "1");
			temp_count++;
		}
		temp_count=(DDR_TEST_MIN_FREQ_LIMITED/12);
		while (temp_count<((start_freq)/12)) {

			// sprintf(freq_table,"%s%04d %01d %01d  ",freq_table,(temp_count*12),0,0);
			sprintf(char_freq_name_table,"ddr_fre_%04d",(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12))));
			printf("\nchar_freq_name_table=%s\n",char_freq_name_table);
			setenv(char_freq_name_table, "3");
			setenv("ddr_feq_test_step", "1");
			temp_count++;
		}
		while (temp_count>((end_freq)/12)) {

			// sprintf(freq_table,"%s%04d %01d %01d  ",freq_table,(temp_count*12),0,0);
			sprintf(char_freq_name_table,"ddr_fre_%04d",(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12))));
			printf("\nchar_freq_name_table=%s\n",char_freq_name_table);
			setenv(char_freq_name_table, "3");
			setenv("ddr_feq_test_step", "1");
			temp_count++;
		}

		p_char_store_boot= getenv("storeboot");
		if (p_char_store_boot)
			printf("storeboot   %s\n",p_char_store_boot);
		sprintf(char_cmd_table,"ddr_test_cmd 0x1c  0x%08x %d %d %d;%s;",ddr_test_size,start_freq,end_freq,test_loops,p_char_store_boot);
		setenv("storeboot", char_cmd_table);

		run_command("save",0);

	}

	if (ddr_feq_test_step == 1)
	{

		temp_count=(DDR_TEST_MIN_FREQ_LIMITED/12);
		while (temp_count<((DDR_TEST_MAX_FREQ)/12)) {

			sprintf(char_freq_name_table,"ddr_fre_%04d",(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12))));
			printf("\nchar_freq_name_table=%s\n",char_freq_name_table);

			p_char_freq_name_table= getenv(char_freq_name_table);
			if (p_char_freq_name_table)
			{
				printf("%s\n",p_char_freq_name_table);

				freq_table_test_value[temp_count] = simple_strtoull_ddr(p_char_freq_name_table, &endp, 0);
				printf("%s | %d\n",char_freq_name_table,freq_table_test_value[temp_count]);
			}
			temp_count++;
		}

		temp_count=(DDR_TEST_MIN_FREQ_LIMITED/12);
		while (temp_count<((DDR_TEST_MAX_FREQ)/12)) {
			ddr_clk_hope_test=(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12)));
			if (freq_table_test_value[temp_count] ==1)
			{
				temp_count_sub=temp_count+1;
				while ((pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count_sub*12))) ==
						(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12))))
				{temp_count_sub=temp_count_sub+1;
				}
				while (temp_count_sub<((DDR_TEST_MAX_FREQ)/12)) {
					sprintf(char_freq_name_table,"ddr_fre_%04d",(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count_sub*12))));
					printf("\nchar_freq_name_table=%s\n",char_freq_name_table);
					// freq_table_test_value[temp_count_sub] =1;
					setenv(char_freq_name_table, "3");
					temp_count_sub++;
				}
				{
					ddr_feq_test_step++;
					setenv("ddr_feq_test_step", "2");
					run_command("save",0);

				}
				{ddr_clk_hope_test=ddr_clk_org;
				}
				sprintf(char_cmd_table,"ddr_test_cmd 0x17 %d 0 0 0",ddr_clk_hope_test);
				printf("\nchar_cmd_table=%s\n",char_cmd_table);
				run_command(char_cmd_table,0);

			}
			if (freq_table_test_value[temp_count] ==0)
			{
				if ((ddr_clk_hope_test) != (ddr_clk))
				{
					sprintf(char_cmd_table,"ddr_test_cmd 0x17 %d 0 0 0",ddr_clk_hope_test);
					printf("\nchar_cmd_table=%s\n",char_cmd_table);
					run_command(char_cmd_table,0);
				}
				if ((ddr_clk_hope_test) == (ddr_clk))
				{

					sprintf(char_freq_name_table,"ddr_fre_%04d",(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12))));
					printf("\nchar_freq_name_table=%s\n",char_freq_name_table);
					freq_table_test_value[temp_count] =1;
					setenv(char_freq_name_table, "1");
					run_command("save",0);

					temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
					while (test_loops--) {
						temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
					}
					//temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);

					sprintf(char_freq_name_table,"ddr_fre_%04d",(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12))));
					printf("\nchar_freq_name_table=%s\n",char_freq_name_table);
					if (temp_test_error)
					{
						freq_table_test_value[temp_count] =1;
						setenv(char_freq_name_table, "1");
					}
					else
					{
						freq_table_test_value[temp_count] =2;
						setenv(char_freq_name_table, "2");
					}
					run_command("save",0);

					ddr_clk_hope_test=(temp_count*12)+12;
					while ((pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(ddr_clk_hope_test))) ==
							(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12))))
					{ddr_clk_hope_test=ddr_clk_hope_test+12;
					}
					if (temp_test_error)
					{ddr_clk_hope_test=ddr_clk_org;
					}
					sprintf(char_cmd_table,"ddr_test_cmd 0x17 %d 0 0 0",ddr_clk_hope_test);
					printf("\nchar_cmd_table=%s\n",char_cmd_table);
					run_command(char_cmd_table,0);
				}

			}
			temp_count++;
		}
		ddr_feq_test_step++;
		setenv("ddr_feq_test_step", "2");
		run_command("save",0);

	}

	if (ddr_feq_test_step >= 2)
	{
		printf("\nfinish test ddr_feq_test_step=%d\n",ddr_feq_test_step);
		temp_count=(DDR_TEST_MIN_FREQ_LIMITED/12);
		while (temp_count<((DDR_TEST_MAX_FREQ)/12)) {

			sprintf(char_freq_name_table,"ddr_fre_%04d",(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12))));
			printf("\nchar_freq_name_table=%s\n",char_freq_name_table);

			p_char_freq_name_table= getenv(char_freq_name_table);
			if (p_char_freq_name_table)
			{
				printf("%s\n",p_char_freq_name_table);

				freq_table_test_value[temp_count] = simple_strtoull_ddr(p_char_freq_name_table, &endp, 0);
				printf("%s | %d\n",char_freq_name_table,freq_table_test_value[temp_count]);
			}
			temp_count++;
		}

		printf("\nprint test ddr_feq_test_result!!!\n");
		temp_count=(DDR_TEST_MIN_FREQ_LIMITED/12);
		while (temp_count<((DDR_TEST_MAX_FREQ)/12)) {

			sprintf(char_freq_name_table,"ddr_fre_%04d",(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12))));
			p_char_freq_name_table= getenv(char_freq_name_table);
			if (p_char_freq_name_table)
			{
				//	printf("%s\n",p_char_freq_name_table);

				freq_table_test_value[temp_count] = simple_strtoull_ddr(p_char_freq_name_table, &endp, 0);
				//printf("%d\n",freq_table_test_value[temp_count]);
				if ( (freq_table_test_value[temp_count]) == 0) {
					printf("%04d  no init     %d \n",(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12))),freq_table_test_value[temp_count]);
				}
				if ( (freq_table_test_value[temp_count]) == 1) {
					printf("%04d  fail      %d\n",(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12))),freq_table_test_value[temp_count]);
				}
				if ( (freq_table_test_value[temp_count]) == 2) {
					printf("%04d  pass      %d\n",(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12))),freq_table_test_value[temp_count]);
				}
				if ( (freq_table_test_value[temp_count]) >= 3) {
					printf("%04d  skip test %d \n",(pll_convert_to_ddr_clk(ddr_clk_convert_to_pll(temp_count*12))),freq_table_test_value[temp_count]);
				}
				temp_count++;
			}
		}

	}
	//sprintf(str,"ddr_test_ac_bit_setup_hold_window  a 0  0x%08x  %d  0x%08x",ddr_test_size,test_ac_setup_hold,( lane_step));
	//	printf("\nstr=%s\n",str);




	//sprintf(str, "%lx", value);
	//  setenv("env_ddrtest", str);


	//run_command("save",0);

	//*/
	return 1;

}
int update_ddr_zq(unsigned int zq0pr)
{
	wr_reg( DDR0_PUB_ZQ0PR,zq0pr);
	wr_reg( DDR0_PUB_ZQCR,(rd_reg(DDR0_PUB_ZQCR))|(1<<2)|(1<<27));
	wr_reg( DDR0_PUB_ZQCR,(rd_reg(DDR0_PUB_ZQCR))&(~((1<<2)|(1<<27))));
	printf("\nupdate zq zq0pr=0x%08x,zq0dr=0x%08x,\n",rd_reg(DDR0_PUB_ZQ0PR),rd_reg(DDR0_PUB_ZQ0DR));
	return rd_reg(DDR0_PUB_ZQ0PR);
}

int do_ddr_test_ddr_max_freq(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter Test ddr max frequency  function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);

	//writel((0), 0xc8836c00);
	OPEN_CHANNEL_A_PHY_CLK();
	OPEN_CHANNEL_B_PHY_CLK();
	//writel((0), 0xc8836c00);

	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_loop=1;
	unsigned int   test_times=1;
	unsigned int   add_freq=1;
	unsigned int   sub_freq=1;
	unsigned int   max_freq=792;
	unsigned int   min_freq=792;
	unsigned int   loop_max_freq=792;
	unsigned int    loop_min_freq=792;

	unsigned int ddr_pll=0x10221;
	unsigned int ddr_clk_org=792;
	unsigned int ddr_pll_org = rd_reg(AM_DDR_PLL_CNTL);
	ddr_pll=ddr_pll_org;
	unsigned int ddr_clk = pll_convert_to_ddr_clk(ddr_pll);
	ddr_clk_org=ddr_clk;
	printf("\nddr_clk_org== %dMHz\n", ddr_clk_org);

	unsigned int zq0pr = rd_reg(DDR0_PUB_ZQ0PR);
	printf("\nddr_zq0pr== 0x%08x\n", zq0pr);

	ddr_pll = ddr_clk_convert_to_pll(ddr_clk);

	wr_reg(AM_DDR_PLL_CNTL, (((rd_reg(AM_DDR_PLL_CNTL))&(~(0xfffff)))|(ddr_pll)));
	ddr_udelay(2000);

	max_freq=ddr_clk_org;
	min_freq=ddr_clk_org;

#define  DDR_CORSS_TALK_TEST_SIZE   0x20000

	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;
	if (argc == 1)
	{
		ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		test_loop=1;
		add_freq=1;
		sub_freq=1;
	}

	if (argc == 2)
	{
		ddr_test_size = simple_strtoull_ddr(argv[1], &endp, 16);
		test_loop=1;
		add_freq=1;
		sub_freq=1;
	}
	if (argc== 3)
	{
		ddr_test_size = simple_strtoull_ddr(argv[1], &endp, 16);
		test_loop= simple_strtoull_ddr(argv[2], &endp, 16);
		add_freq=1;
		sub_freq=1;
	}
	if (argc >= 4)
	{
		ddr_test_size = simple_strtoull_ddr(argv[1], &endp, 16);
		test_loop= simple_strtoull_ddr(argv[2], &endp, 16);
		add_freq=1;
		sub_freq=1;
		if ((simple_strtoull_ddr(argv[3], &endp, 16)) == 1)
		{
			add_freq=1;
			sub_freq=0;
		}
		else if((simple_strtoull_ddr(argv[3], &endp, 16))==0)
		{
			add_freq=0;
			sub_freq=1;
		}
	}

	unsigned int  	temp_test_error=0;
	while (test_times<(test_loop+1))
	{
		printf("\ntest_times== %d times\n", test_times);

		if (add_freq)
		{

			while (ddr_clk<1500)
			{
				temp_test_error=0;
				ddr_clk=ddr_clk+12;
				ddr_pll = ddr_clk_convert_to_pll(ddr_clk);
				{

					wr_reg(AM_DDR_PLL_CNTL, (((rd_reg(AM_DDR_PLL_CNTL))&(~(0xfffff)))|(ddr_pll)));
					ddr_udelay(2000);
					printf("\ntesting_ddr_clk== %dMHz\n", ddr_clk);
				}

				temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
				temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
				if (temp_test_error)
				{
					max_freq=ddr_clk-12;
					printf("\nmax_ddr_clk== %dMHz\n", max_freq);
					temp_test_error=0;
					break;
				}

			}

			while (ddr_clk>ddr_clk_org)
			{
				ddr_clk=ddr_clk-12;
				ddr_pll = ddr_clk_convert_to_pll(ddr_clk);
				{

					wr_reg(AM_DDR_PLL_CNTL, (((rd_reg(AM_DDR_PLL_CNTL))&(~(0xfffff)))|(ddr_pll)));
					ddr_udelay(2000);
				}
			}
			printf("\nback to  org_ddr_clk== %dMHz\n", ddr_clk);


		}

		if (sub_freq)
		{

			while (ddr_clk>24)
			{
				temp_test_error=0;
				ddr_clk=ddr_clk-12;
				ddr_pll = ddr_clk_convert_to_pll(ddr_clk);
				{

					wr_reg(AM_DDR_PLL_CNTL, (((rd_reg(AM_DDR_PLL_CNTL))&(~(0xfffff)))|(ddr_pll)));
					ddr_udelay(2000);
					printf("\ntesting_ddr_clk== %dMHz\n", ddr_clk);
				}

				temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
				temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
				if (temp_test_error)
				{
					min_freq=ddr_clk+12;
					printf("\nmin_ddr_clk== %dMHz\n", min_freq);
					temp_test_error=0;
					break;
				}

			}

			while (ddr_clk<ddr_clk_org)
			{
				ddr_clk=ddr_clk+12;
				ddr_pll = ddr_clk_convert_to_pll(ddr_clk);
				{

					wr_reg(AM_DDR_PLL_CNTL, (((rd_reg(AM_DDR_PLL_CNTL))&(~(0xfffff)))|(ddr_pll)));
					ddr_udelay(2000);
				}
			}
			printf("\nback to  org_ddr_clk== %dMHz\n", ddr_clk);


		}

		if (test_times == 1)
		{

			loop_max_freq=max_freq;
			loop_min_freq=min_freq;
		}
		else
		{
			if (loop_max_freq>max_freq)
			{
				loop_max_freq=max_freq;
			}
			if (min_freq>loop_min_freq)
			{
				loop_min_freq=min_freq;
			}
		}
		test_times++;

	}

	printf("\nloop_min_freq== %dMHz,pll==0x%08x\n", loop_min_freq,ddr_clk_convert_to_pll(loop_min_freq));
	printf("\nloop_max_freq== %dMHz,pll==0x%08x\n", loop_max_freq,ddr_clk_convert_to_pll(loop_max_freq));

	return loop_max_freq;
}


int do_ddr_test_ddr_zq(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter Test ddr zq  function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);
	//writel((0), 0xc8836c00);
	OPEN_CHANNEL_A_PHY_CLK();
	OPEN_CHANNEL_B_PHY_CLK();
	//writel((0), 0xc8836c00);

	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_loop=1;
	unsigned int   test_times=1;
	unsigned int   add_freq=1;
	unsigned int   sub_freq=1;
	unsigned int   max_freq=792;
	unsigned int   min_freq=792;
	unsigned int   loop_max_freq=792;
	unsigned int    loop_min_freq=792;

	unsigned int ddr_pll=0x10221;
	unsigned int ddr_clk_org=792;
	unsigned int ddr_pll_org = rd_reg(AM_DDR_PLL_CNTL);
	ddr_pll=ddr_pll_org;
	unsigned int ddr_clk = pll_convert_to_ddr_clk(ddr_pll);
	ddr_clk_org=ddr_clk;
	printf("\nddr_clk_org== %dMHz\n", ddr_clk_org);

	unsigned int zq0pr_org = rd_reg(DDR0_PUB_ZQ0PR);
	//	unsigned int zq0pr_best;
	unsigned int zq0pr= rd_reg(DDR0_PUB_ZQ0PR);
	//	zq0pr_best=zq0pr_org;
	unsigned int zq0pr_drv_max;
	unsigned int zq0pr_drv_min;
	unsigned int zq0pr_odt_max;
	unsigned int zq0pr_odt_min;
	unsigned int zq0pr_drv_flag=1;
	unsigned int zq0pr_odt_flag=1;


	printf("\nzq0pr_org== 0x%08x\n", zq0pr_org);

	ddr_pll = ddr_clk_convert_to_pll(ddr_clk);


	{

		wr_reg(AM_DDR_PLL_CNTL, (((rd_reg(AM_DDR_PLL_CNTL))&(~(0xfffff)))|(ddr_pll)));
		ddr_udelay(2000);
	}






	max_freq=ddr_clk_org;
	min_freq=ddr_clk_org;





#define  DDR_CORSS_TALK_TEST_SIZE   0x20000
	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;




	if (argc == 1)
	{
		ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		test_loop=1;
		add_freq=1;
		sub_freq=1;
	}

	if (argc == 2)
	{
		ddr_test_size = simple_strtoull_ddr(argv[1], &endp, 16);
		test_loop=1;
		add_freq=1;
		sub_freq=1;
	}
	if (argc== 3)
	{
		ddr_test_size = simple_strtoull_ddr(argv[1], &endp, 16);
		test_loop= simple_strtoull_ddr(argv[2], &endp, 16);
		add_freq=1;
		sub_freq=1;
	}
	if (argc >= 4)
	{
		ddr_test_size = simple_strtoull_ddr(argv[1], &endp, 16);
		test_loop= simple_strtoull_ddr(argv[2], &endp, 16);
		add_freq=1;
		sub_freq=1;
		if ((simple_strtoull_ddr(argv[3], &endp, 16)) == 1)
		{
			add_freq=1;
			sub_freq=0;
		}
		else if((simple_strtoull_ddr(argv[3], &endp, 16))==0)
		{
			add_freq=0;
			sub_freq=1;
		}
	}

	if (argc>4)
	{
		if ((simple_strtoull_ddr(argv[4], &endp, 16)) == 1)
		{
			zq0pr_drv_flag=0;
			zq0pr_odt_flag=1;
		}
		else if((simple_strtoull_ddr(argv[4], &endp, 16))==0)
		{
			zq0pr_drv_flag=1;
			zq0pr_odt_flag=0;
		}

	}


	unsigned int  	temp_test_error=0;


	test_times=1;
	temp_test_error=0;
	while (test_times<(test_loop+1))
	{
		printf("\ntest_times== %d times\n", test_times);

		if (add_freq)
		{

			while (ddr_clk<1500)
			{
				temp_test_error=0;
				ddr_clk=ddr_clk+12;
				ddr_pll = ddr_clk_convert_to_pll(ddr_clk);
				{

					wr_reg(AM_DDR_PLL_CNTL, (((rd_reg(AM_DDR_PLL_CNTL))&(~(0xfffff)))|(ddr_pll)));
					ddr_udelay(2000);
					printf("\ntesting_ddr_clk== %dMHz\n", ddr_clk);
				}

				temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
				temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
				if (temp_test_error)
				{
					max_freq=ddr_clk-12;
					printf("\nmax_ddr_clk== %dMHz\n", max_freq);
					temp_test_error=0;
					break;
				}

			}

			while (ddr_clk>ddr_clk_org)
			{
				ddr_clk=ddr_clk-12;
				ddr_pll = ddr_clk_convert_to_pll(ddr_clk);
				{

					wr_reg(AM_DDR_PLL_CNTL, (((rd_reg(AM_DDR_PLL_CNTL))&(~(0xfffff)))|(ddr_pll)));
					ddr_udelay(2000);
				}
			}
			printf("\nback to  org_ddr_clk== %dMHz\n", ddr_clk);


		}

		if (sub_freq)
		{

			while (ddr_clk>24)
			{
				temp_test_error=0;
				ddr_clk=ddr_clk-12;
				ddr_pll = ddr_clk_convert_to_pll(ddr_clk);
				{

					wr_reg(AM_DDR_PLL_CNTL, (((rd_reg(AM_DDR_PLL_CNTL))&(~(0xfffff)))|(ddr_pll)));
					ddr_udelay(2000);
					printf("\ntesting_ddr_clk== %dMHz\n", ddr_clk);
				}

				temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
				temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
				if (temp_test_error)
				{
					min_freq=ddr_clk+12;
					printf("\nmin_ddr_clk== %dMHz\n", min_freq);
					temp_test_error=0;
					break;
				}

			}

			while (ddr_clk<ddr_clk_org)
			{
				ddr_clk=ddr_clk+12;
				ddr_pll = ddr_clk_convert_to_pll(ddr_clk);
				{

					wr_reg(AM_DDR_PLL_CNTL, (((rd_reg(AM_DDR_PLL_CNTL))&(~(0xfffff)))|(ddr_pll)));
					ddr_udelay(2000);
				}
			}
			printf("\nback to  org_ddr_clk== %dMHz\n", ddr_clk);


		}

		if (test_times == 1)
		{

			loop_max_freq=max_freq;
			loop_min_freq=min_freq;
		}
		else
		{
			if (loop_max_freq>max_freq)
			{
				loop_max_freq=max_freq;
			}
			if (min_freq>loop_min_freq)
			{
				loop_min_freq=min_freq;
			}
		}
		test_times++;

	}

	printf("\nloop_min_freq== %dMHz,pll==0x%08x\n", loop_min_freq,ddr_clk_convert_to_pll(loop_min_freq));
	printf("\nloop_max_freq== %dMHz,pll==0x%08x\n", loop_max_freq,ddr_clk_convert_to_pll(loop_max_freq));


	while (ddr_clk
			<loop_max_freq)
	{
		ddr_clk=ddr_clk+12;
		ddr_pll = ddr_clk_convert_to_pll(ddr_clk);
		{

			wr_reg(AM_DDR_PLL_CNTL, (((rd_reg(AM_DDR_PLL_CNTL))&(~(0xfffff)))|(ddr_pll)));
			ddr_udelay(2000);
		}
	}
	printf("\nset to  loop_max_freq== %dMHz\n", loop_max_freq);

	update_ddr_zq(zq0pr);

	zq0pr_drv_max=(zq0pr&0xf);
	zq0pr_drv_min=(zq0pr&0xf);
	zq0pr_odt_max=(zq0pr&0xf0);
	zq0pr_odt_min=(zq0pr&0xf0);

	if (zq0pr_drv_flag)
	{
		while ((zq0pr&0xf)<0xf)
		{
			zq0pr++;
			update_ddr_zq(zq0pr);
			temp_test_error=0;
			temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
			temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
			if (temp_test_error)
			{
				zq0pr--;
				update_ddr_zq(zq0pr);
				break;


			}
		}
		zq0pr_drv_max=(zq0pr&0xf);
		printf("\nzq0pr_drv_max== 0x%08x\n", zq0pr_drv_max);

		update_ddr_zq(zq0pr_org);

		while ((zq0pr&0xf)>0x0)
		{
			zq0pr--;
			update_ddr_zq(zq0pr);
			temp_test_error=0;
			temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
			temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
			if (temp_test_error)
			{
				zq0pr++;
				update_ddr_zq(zq0pr);
				break;


			}
		}


		zq0pr_drv_min=(zq0pr&0xf);
		printf("\nzq0pr_drv_max== 0x%08x\n", zq0pr_drv_min);
	}

	if (zq0pr_odt_flag)
	{
		while ((zq0pr&0xf0)<0xf0)
		{
			zq0pr=zq0pr+0x10;
			update_ddr_zq(zq0pr);
			temp_test_error=0;
			temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
			temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
			if (temp_test_error)
			{
				zq0pr=zq0pr-0x10;
				update_ddr_zq(zq0pr);
				break;


			}
		}
		zq0pr_odt_max=(zq0pr&0xf0);
		printf("\nzq0pr_odt_max== 0x%08x\n", zq0pr_odt_max);

		update_ddr_zq(zq0pr_org);


		while ((zq0pr&0xf0)>0x0)
		{
			zq0pr=zq0pr-0x10;
			update_ddr_zq(zq0pr);
			temp_test_error=0;
			temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
			temp_test_error=temp_test_error+ddr_test_s_add_cross_talk_pattern(ddr_test_size);
			if (temp_test_error)
			{
				zq0pr=zq0pr+0x10;
				update_ddr_zq(zq0pr);
				break;


			}
		}
		zq0pr_odt_min=(zq0pr&0xf0);
		printf("\nzq0pr_odt_min== 0x%08x\n", zq0pr_odt_min);
	}
	update_ddr_zq(zq0pr_org);

	printf("\nzq0pr_drv_max== 0x%08x\n", zq0pr_drv_max);
	printf("\nzq0pr_drv_min== 0x%08x\n", zq0pr_drv_min);
	printf("\nzq0pr_odt_max== 0x%08x\n", zq0pr_odt_max);
	printf("\nzq0pr_odt_min== 0x%08x\n", zq0pr_odt_min);

	return loop_max_freq;



}

int clear_ddr_band_monitor(unsigned int port,unsigned int port_id,unsigned int timer_counter)
{
	wr_reg(DMC_MON_CTRL3, timer_counter);
	wr_reg(DMC_MON_CTRL2, (port_id<<0)|(port<<16)|(0<<20)|(1<<30));
	ddr_udelay(1);
	if (((rd_reg(DMC_MON_CTRL2))>>30) == 1)
		return 1;
	else
		return 0;


}
int open_ddr_band_monitor(unsigned int port,unsigned int port_id,unsigned int timer_counter)
{
	wr_reg(DMC_MON_CTRL3, timer_counter);
	wr_reg(DMC_MON_CTRL2, ((rd_reg(DMC_MON_CTRL2))&(1<<30))|(port_id<<0)|(port<<16)|(0<<20)|(1<<31));

	return 1;
}

int finish_ddr_band_monitor(unsigned int port,unsigned int port_id,unsigned int timer_counter)
{
	//wr_reg(DMC_MON_CTRL3, timer_time);
	if (((rd_reg(DMC_MON_CTRL2))>>31) == 0)
	{
		printf("\nddr bandwidth timer finish count and print result\n");
		printf("\nDMC_MON_port	== 0x%08x port_id==0x%08x timer_time==0x%08x",port,port_id,timer_counter);
		printf("\nDMC_MON_ALL_REQ_CNT	== 0x%08x",(rd_reg(DMC_MON_ALL_REQ_CNT)));

		printf("\nDMC_MON_ALL_GRANT_CNT	== 0x%08x",(rd_reg(DMC_MON_ALL_GRANT_CNT)));
		printf("\nDMC_MON_ALL_GRANT_CNT_band	== 0x%08x kbyte,dec== %d Mbyte",((rd_reg(DMC_MON_ALL_GRANT_CNT))*(8))/1024,((rd_reg(DMC_MON_ALL_GRANT_CNT))*(8))/(1024*1024));
		printf("\nDMC_MON_ONE _GRANT_CNT for selected port and subids	== 0x%08x",(rd_reg(DMC_MON_ONE_GRANT_CNT)));
		printf("\nDMC_MON_ONE _GRANT_CNT_band for selected port and subids	== 0x%08x,dec== %dMbyte",((rd_reg(DMC_MON_ONE_GRANT_CNT))*(8))/1024,((rd_reg(DMC_MON_ONE_GRANT_CNT))*(8))/(1024*1024));
	}
	//wr_reg(DMC_MON_CTRL2, ((rd_reg(DMC_MON_CTRL2))&(1<<30))|(port_id<<0)|(port<<16)|(0<<20)|(1<<31));

	return 1;
}



int do_ddr_test_bandwidth(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter Test ddr bandwidth  function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	printf("\nargc== 0x%08x\n", argc);
	//writel((0), 0xc8836c00);
	OPEN_CHANNEL_A_PHY_CLK();
	OPEN_CHANNEL_B_PHY_CLK();
	//writel((0), 0xc8836c00);

	char *endp;
	//  unsigned int   *p_start_addr;
	unsigned int   test_loop=1;
	unsigned int   test_times=1;
	unsigned int timer_time_ms=1000;


	unsigned int ddr_pll=0x10221;
	unsigned int ddr_clk_org=792;
	unsigned int ddr_pll_org = rd_reg(AM_DDR_PLL_CNTL)&(~(1<<29));
	ddr_pll=ddr_pll_org;
	unsigned int ddr_clk = pll_convert_to_ddr_clk(ddr_pll);
	ddr_clk_org=ddr_clk;
	printf("\nddr_clk_org== %dMHz\n", ddr_clk_org);

	unsigned int zq0pr = rd_reg(DDR0_PUB_ZQ0PR);
	printf("\nddr_zq0pr== 0x%08x\n", zq0pr);

	ddr_pll = ddr_clk_convert_to_pll(ddr_clk);

#define  DDR_CORSS_TALK_TEST_SIZE   0x20000

	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;

	unsigned int test_port=0;
	unsigned int test_port_sub_id=1;


	if (argc == 1)
	{
		ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		test_loop=1;

	}

	if (argc == 2)
	{
		ddr_test_size = simple_strtoull_ddr(argv[1], &endp, 16);
		test_loop=1;

	}
	if (argc== 3)
	{
		ddr_test_size = simple_strtoull_ddr(argv[1], &endp, 16);
		test_loop= simple_strtoull_ddr(argv[2], &endp, 16);

	}
	if (argc >= 4)
	{
		ddr_test_size = simple_strtoull_ddr(argv[1], &endp, 16);
		test_loop= simple_strtoull_ddr(argv[2], &endp, 16);
		test_port= simple_strtoull_ddr(argv[3], &endp, 16);


	}
	if (argc >= 5)
	{
		ddr_test_size = simple_strtoull_ddr(argv[1], &endp, 16);
		test_loop= simple_strtoull_ddr(argv[2], &endp, 16);
		test_port= simple_strtoull_ddr(argv[3], &endp, 16);
		test_port_sub_id= simple_strtoull_ddr(argv[4], &endp, 16);

	}
	if (argc >5)
	{

		timer_time_ms= simple_strtoull_ddr(argv[5], &endp, 16);

	}

	//unsigned int  	temp_test_error=0;
	unsigned int timer_counter=0;
	timer_counter=(timer_time_ms*1000*ddr_clk/2);
	//while(test_times<(test_loop+1))
	{
		{
			clear_ddr_band_monitor( test_port, test_port_sub_id, timer_counter);
			open_ddr_band_monitor( test_port, test_port_sub_id, timer_counter);
			while (test_times<(test_loop+1))
			{
				printf("\ntest_times== %d times\n", test_times);
				ddr_test_s_cross_talk_pattern(ddr_test_size);
				test_times++;
			}
			finish_ddr_band_monitor( test_port, test_port_sub_id, timer_counter);
			printf("\ntimer_time_ms== %d ms\n", timer_time_ms);

			printf("\nddr_clk== %dMHz\n", ddr_clk);

		}
	}

	return 1;
}

int do_ddr_fine_tune_lcdlr_env(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter ddr_fine_tune_lcdlr_env  function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	int i=0;
	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}

	//writel((0), 0xc8836c00);
	OPEN_CHANNEL_A_PHY_CLK();

	OPEN_CHANNEL_B_PHY_CLK();
	//writel((0), 0xc8836c00);

	char *endp;
	//  unsigned int   *p_start_addr;

#define WR_RD_ADJ_USE_ENV  1
#define WR_RD_ADJ_USE_UART_INPUT 2
	unsigned int   wr_rd_adj_input_src=1;

	int wr_adj_per[12]={
		100	,
		1000	,
		100	,
		100	,
		100	,
		100	,
		100	,
		100	,
		100	,
		100	,
		100	,
		100	,

	};
	int rd_adj_per[12]={
		100	,
		100	,
		80	,
		80	,
		80	,
		80	,
		100	,
		100	,
		100	,
		100	,
		100	,
		100	,
	};
	if (argc == 1)
		printf("\nplease read help\n");

	if (argc >= 2)
	{
		wr_rd_adj_input_src = simple_strtoull_ddr(argv[1], &endp, 10);

		unsigned int i=0;
		if (wr_rd_adj_input_src == WR_RD_ADJ_USE_UART_INPUT)
		{
			printf("\ntune ddr lcdlr use uart input\n");
			if (argc>24+2)
			{argc=24+2;}
			{

				for (i = 2;i<argc;i++)
				{
					if (i<(2+12)) {
						wr_adj_per[i-2]=simple_strtoull_ddr(argv[i], &endp, 10);
					}
					else
					{
						rd_adj_per[i-14]=simple_strtoull_ddr(argv[i], &endp, 10);
					}
				}
			}

		}
		if (wr_rd_adj_input_src == WR_RD_ADJ_USE_ENV)
		{printf("\ntune ddr lcdlr use uboot env\n");
			{
				//char str[24];
				const char *s;

				// char *varname;
				int value=0;

				//*varname="env_ddrtest";
				s = getenv("env_wr_lcdlr_pr");
				if (s)
				{//i=0;
					//while(s_temp)
					{
						printf("%s",s);
						//sscanf(s,"d%,",wr_adj_per);
						//sprintf(str,"d%",s);
						//getc

					}
					value = simple_strtoull_ddr(s, &endp, 16);
					printf("%d",value);
				}
				s = getenv("env_rd_lcdlr_pr");

				if (s)
				{//i=0;
					//while(s_temp)
					{
						printf("%s",s);
						//sscanf(s,"d%,",rd_adj_per);

					}
					//value = simple_strtoull_ddr(s, &endp, 16);
				}

				//sprintf(str, "%lx", value);
				//  setenv("env_ddrtest", str);


				//run_command("save",0);
			}

			if (argc>24+2)
				argc=24+2;
			for (i = 2;i<argc;i++)
			{
				if (i<(2+12)) {
					wr_adj_per[i-2]=simple_strtoull_ddr(argv[i], &endp, 16);
				}
				else
				{
					rd_adj_per[i-14]=simple_strtoull_ddr(argv[i], &endp, 16);
				}
			}


		}
		printf(" int wr_adj_per[12]={\n");
		for (i = 0;i<12;i++)
		{
			printf("%04d ,\n",wr_adj_per[i]);
		}
		printf("};\n");
		printf(" int rd_adj_per[12]={\n");
		for (i = 0;i<12;i++)
		{
			printf("%04d ,\n",rd_adj_per[i]);
		}
		printf("};\n");


#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
			wr_reg(DDR0_PUB_PIR, (rd_reg(DDR0_PUB_PIR))|(1<<29));
			wr_reg(DDR0_PUB_PGCR6, (rd_reg(DDR0_PUB_PGCR6))|(1<<0));
			wr_reg(DDR1_PUB_PIR, (rd_reg(DDR1_PUB_PIR))|(1<<29));
			wr_reg(DDR1_PUB_PGCR6, (rd_reg(DDR1_PUB_PGCR6))|(1<<0));
#else
			wr_reg(DDR0_PUB_PIR, (rd_reg(DDR0_PUB_PIR))|(1<<29));
			wr_reg(DDR0_PUB_PGCR1, (rd_reg(DDR0_PUB_PGCR1))|(1<<26));
			wr_reg(DDR1_PUB_PIR, (rd_reg(DDR1_PUB_PIR))|(1<<29));
			wr_reg(DDR1_PUB_PGCR1, (rd_reg(DDR1_PUB_PGCR1))|(1<<26));
#endif

			int lcdlr_w=0,lcdlr_r=0;
			unsigned temp_reg=0;
			int temp_count=0;
			for ( temp_count=0;temp_count<2;temp_count++)
			{     temp_reg=(unsigned)(DDR0_PUB_ACLCDLR+(temp_count<<2));
				lcdlr_w=(int)((rd_reg((uint64_t)(temp_reg)))&ACLCDLR_MAX);
				lcdlr_w=lcdlr_w?lcdlr_w:1;
				lcdlr_w=(lcdlr_w*(wr_adj_per[temp_count]))/100;
				if (temp_count == 1)
					lcdlr_w=lcdlr_w&ACBDLR_MAX;
				wr_reg(((uint64_t)(temp_reg)),((lcdlr_w)&ACLCDLR_MAX));
			}
#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
			for ( temp_count=2;temp_count<6;temp_count++)
			{     temp_reg=(unsigned)(DDR0_PUB_DX0LCDLR1+(DDR0_PUB_DX1LCDLR1-DDR0_PUB_DX0LCDLR1)*(temp_count-2));
				lcdlr_w=(int)((rd_reg((uint64_t)(temp_reg)))&DQLCDLR_MAX);
				lcdlr_w=lcdlr_w?lcdlr_w:1;
				lcdlr_r=(int)(((rd_reg((uint64_t)(temp_reg+DDR0_PUB_DX0LCDLR3-DDR0_PUB_DX0LCDLR1))))&DQLCDLR_MAX);
				lcdlr_r=lcdlr_r?lcdlr_r:1;
				lcdlr_w=(lcdlr_w*(wr_adj_per[temp_count]))/100;
				lcdlr_r=(lcdlr_r*(rd_adj_per[temp_count]))/100;
				wr_reg(((uint64_t)(temp_reg)),(lcdlr_w));
				wr_reg(((uint64_t)(temp_reg+DDR0_PUB_DX0LCDLR3-DDR0_PUB_DX0LCDLR1)),(lcdlr_r));
				wr_reg(((uint64_t)(temp_reg+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR1)),(lcdlr_r));
			}
#else
			for ( temp_count=2;temp_count<6;temp_count++)
			{     temp_reg=(unsigned)(DDR0_PUB_DX0LCDLR1+(DDR0_PUB_DX1LCDLR1-DDR0_PUB_DX0LCDLR1)*(temp_count-2));
				lcdlr_w=(int)((rd_reg((uint64_t)(temp_reg)))&DQLCDLR_MAX);
				lcdlr_w=lcdlr_w?lcdlr_w:1;
				lcdlr_r=(int)(((rd_reg((uint64_t)(temp_reg)))>>8)&DQLCDLR_MAX);
				lcdlr_r=lcdlr_r?lcdlr_r:1;
				lcdlr_w=(lcdlr_w*(wr_adj_per[temp_count]))/100;
				lcdlr_r=(lcdlr_r*(rd_adj_per[temp_count]))/100;
				wr_reg(((uint64_t)(temp_reg)),(((lcdlr_r<<16)|(lcdlr_r<<8)|(lcdlr_w))));
			}
#endif
			for ( temp_count=6;temp_count<8;temp_count++)
			{     temp_reg=(unsigned)(DDR1_PUB_ACLCDLR+((temp_count-6)<<2));

				lcdlr_w=(int)((rd_reg((uint64_t)(temp_reg)))&ACLCDLR_MAX);
				lcdlr_w=lcdlr_w?lcdlr_w:1;
				lcdlr_w=(lcdlr_w*(wr_adj_per[temp_count]))/100;
				if (temp_count == 7)
					lcdlr_w=lcdlr_w&ACBDLR_MAX;
				wr_reg(((uint64_t)(temp_reg)),((lcdlr_w)&ACLCDLR_MAX));
			}
#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)
			for ( temp_count=8;temp_count<12;temp_count++)
			{     temp_reg=(unsigned)(DDR1_PUB_DX0LCDLR1+(DDR1_PUB_DX1LCDLR1-DDR1_PUB_DX0LCDLR1)*(temp_count-2));
				lcdlr_w=(int)((rd_reg((uint64_t)(temp_reg)))&DQLCDLR_MAX);
				lcdlr_w=lcdlr_w?lcdlr_w:1;
				lcdlr_r=(int)(((rd_reg((uint64_t)(temp_reg+DDR1_PUB_DX0LCDLR3-DDR1_PUB_DX0LCDLR1))))&DQLCDLR_MAX);
				lcdlr_r=lcdlr_r?lcdlr_r:1;
				lcdlr_w=(lcdlr_w*(wr_adj_per[temp_count]))/100;
				lcdlr_r=(lcdlr_r*(rd_adj_per[temp_count]))/100;
				wr_reg(((uint64_t)(temp_reg)),(lcdlr_w));
				wr_reg(((uint64_t)(temp_reg+DDR1_PUB_DX0LCDLR3-DDR1_PUB_DX0LCDLR1)),(lcdlr_r));
				wr_reg(((uint64_t)(temp_reg+DDR1_PUB_DX0LCDLR4-DDR1_PUB_DX0LCDLR1)),(lcdlr_r));
			}
#else
			for ( temp_count=8;temp_count<12;temp_count++)
			{     temp_reg=(unsigned)(DDR1_PUB_DX0LCDLR1+(DDR1_PUB_DX1LCDLR1-DDR1_PUB_DX0LCDLR1)*(temp_count-8));
				lcdlr_w=(int)((rd_reg((uint64_t)(temp_reg)))&0xff);
				lcdlr_w=lcdlr_w?lcdlr_w:1;
				lcdlr_r=(int)(((rd_reg((uint64_t)(temp_reg)))>>8)&0xff);
				lcdlr_r=lcdlr_r?lcdlr_r:1;
				lcdlr_w=(lcdlr_w*(wr_adj_per[temp_count]))/100;
				lcdlr_r=(lcdlr_r*(rd_adj_per[temp_count]))/100;
				wr_reg(((uint64_t)(temp_reg)),(((lcdlr_r<<16)|(lcdlr_r<<8)|(lcdlr_w))));
			}
#endif

#if (CONFIG_DDR_PHY ==  P_DDR_PHY_905X)


			wr_reg(DDR0_PUB_PGCR6, (rd_reg(DDR0_PUB_PGCR6))&(~(1<<0)));
			wr_reg(DDR0_PUB_PIR, (rd_reg(DDR0_PUB_PIR))&(~(1<<29)));

			wr_reg(DDR1_PUB_PGCR6, (rd_reg(DDR1_PUB_PGCR6))&(~(1<<0)));
			wr_reg(DDR1_PUB_PIR, (rd_reg(DDR1_PUB_PIR))&(~(1<<29)));


#else
			wr_reg(DDR0_PUB_PGCR1, (rd_reg(DDR0_PUB_PGCR1))&(~(1<<26)));
			wr_reg(DDR0_PUB_PIR, (rd_reg(DDR0_PUB_PIR))&(~(1<<29)));

			wr_reg(DDR1_PUB_PGCR1, (rd_reg(DDR1_PUB_PGCR1))&(~(1<<26)));
			wr_reg(DDR1_PUB_PIR, (rd_reg(DDR1_PUB_PIR))&(~(1<<29)));
#endif
			printf("\nend adjust lcdlr\n");

			CLOSE_CHANNEL_A_PHY_CLK();
			CLOSE_CHANNEL_B_PHY_CLK();
	}



	return 1;

}
//*/
int do_ddr_modify_reg_use_mask(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter ddr_modify_reg_use_mask  function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	int i=0;
	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
		printf("\nargv[%d]=%s\n",i,argv[i]);


	//writel((0), 0xc8836c00);
	OPEN_CHANNEL_A_PHY_CLK();

	OPEN_CHANNEL_B_PHY_CLK();
	//writel((0), 0xc8836c00);

	char *endp;
	//  unsigned int   *p_start_addr;

	unsigned int   reg_add=0;
	unsigned int   wr_reg_value=0;
	unsigned int   rd_reg_value=0;
	unsigned int   wr_reg_and_mask_1=0xffffffff;
	// unsigned int   wr_reg_or_mask_2=0x0;



		if (argc == 1)
		{  printf("\nplease read help\n");
			printf("\nexample only change 0xc8836800 0x8c010226 0x000fffff bit20-bit31,no change pll od oc \n");
			printf("\nddr_test_cmd 9 0xc8836800 0x8c010226 0x000fffff\n");
		}
		else {
			if (argc >= 2)
			{
				reg_add = simple_strtoull_ddr(argv[1], &endp, 10);
			}
			if (argc >= 3)
			{
				wr_reg_value = simple_strtoull_ddr(argv[2], &endp, 10);
			}
			if (argc >= 4)
			{
				wr_reg_and_mask_1 = simple_strtoull_ddr(argv[3], &endp, 10);

			}
			rd_reg_value= (rd_reg(reg_add));
			wr_reg(reg_add,(rd_reg_value&wr_reg_and_mask_1)|(wr_reg_value&(~wr_reg_and_mask_1)) );
			//rd_reg_value= (rd_reg(reg_add));
			//wr_reg(reg_add,(rd_reg_value&(~wr_reg_or_mask_2))|(wr_reg_value&(wr_reg_or_mask_2)) );

			printf("\nmodify ok read==0x%08x\n",(rd_reg(reg_add)));


			CLOSE_CHANNEL_A_PHY_CLK();
			CLOSE_CHANNEL_B_PHY_CLK();
		}

	return 1;

}
int do_ddr_set_zq(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter set ddr zq  function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	int i=0;
	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}


	//writel((0), 0xc8836c00);
	OPEN_CHANNEL_A_PHY_CLK();
	OPEN_CHANNEL_B_PHY_CLK();
	//writel((0), 0xc8836c00);

	char *endp;

	unsigned int zq0pr_org = rd_reg(DDR0_PUB_ZQ0PR);
	unsigned int zq1pr_org = rd_reg(DDR0_PUB_ZQ1PR);
	unsigned int zq2pr_org = rd_reg(DDR0_PUB_ZQ2PR);
	//	unsigned int zq0pr_best;
	unsigned int zq0pr0= rd_reg(DDR0_PUB_ZQ0PR);
	unsigned int zq1pr0= rd_reg(DDR0_PUB_ZQ1PR);
	unsigned int zq2pr0= rd_reg(DDR0_PUB_ZQ2PR);

	if (argc == 1)
	{  printf("\nplease read help\n");
		printf("\nexample only change zq \n");
		printf("\nddr_test_cmd 10 0x19\n");
	}
	else{
		if (argc >= 2)
		{
			// zq0pr0 = argv[1];
			zq0pr0= simple_strtoull_ddr(argv[1], &endp, 0);
		}

		if (argc >= 3)
		{
			// zq1pr0 = argv[2];
			zq1pr0= simple_strtoull_ddr(argv[2], &endp, 0);
		}

		if (argc >= 4)
		{
			// zq2pr0 =argv[3];
			zq2pr0= simple_strtoull_ddr(argv[3], &endp, 0);

		}}

	printf("\nzq0pr_org== 0x%08x\n", zq0pr_org);
	printf("\nzq1pr_org== 0x%08x\n", zq1pr_org);
	printf("\nzq2pr_org== 0x%08x\n", zq2pr_org);
	wr_reg( DDR0_PUB_ZQCR,(rd_reg(DDR0_PUB_ZQCR))|(1<<2)|(1<<27));
	printf("\norg channel 0 zq zq0pr=0x%08x,zq0dr=0x%08x,\n",rd_reg(DDR0_PUB_ZQ0PR),rd_reg(DDR0_PUB_ZQ0DR));
	printf("\norg channel 0 zq zq1pr=0x%08x,zq1dr=0x%08x,\n",rd_reg(DDR0_PUB_ZQ1PR),rd_reg(DDR0_PUB_ZQ1DR));
	printf("\norg channel 0 zq zq2pr=0x%08x,zq2dr=0x%08x,\n",rd_reg(DDR0_PUB_ZQ2PR),rd_reg(DDR0_PUB_ZQ2DR));

	wr_reg( DDR0_PUB_ZQ0PR,zq0pr0);
	wr_reg( DDR0_PUB_ZQ1PR,zq1pr0);
	wr_reg( DDR0_PUB_ZQ2PR,zq2pr0);
	wr_reg( DDR0_PUB_ZQCR,(rd_reg(DDR0_PUB_ZQCR))|(1<<2)|(1<<27));
	wr_reg( DDR0_PUB_ZQCR,(rd_reg(DDR0_PUB_ZQCR))&(~((1<<2)|(1<<27))));
	printf("\nupdate channel 0 zq zq0pr=0x%08x,zq0dr=0x%08x,\n",rd_reg(DDR0_PUB_ZQ0PR),rd_reg(DDR0_PUB_ZQ0DR));
	printf("\nupdate channel 0 zq zq1pr=0x%08x,zq1dr=0x%08x,\n",rd_reg(DDR0_PUB_ZQ1PR),rd_reg(DDR0_PUB_ZQ1DR));
	printf("\nupdate channel 0 zq zq2pr=0x%08x,zq2dr=0x%08x,\n",rd_reg(DDR0_PUB_ZQ2PR),rd_reg(DDR0_PUB_ZQ2DR));

	wr_reg( DDR0_PUB_ZQ0PR,zq0pr0);
	wr_reg( DDR0_PUB_ZQ1PR,zq1pr0);
	wr_reg( DDR0_PUB_ZQ2PR,zq2pr0);
	printf("\nupdate channel 0 zq zq0pr=0x%08x,zq0dr=0x%08x,\n",rd_reg(DDR0_PUB_ZQ0PR),rd_reg(DDR0_PUB_ZQ0DR));
	printf("\nupdate channel 0 zq zq1pr=0x%08x,zq1dr=0x%08x,\n",rd_reg(DDR0_PUB_ZQ1PR),rd_reg(DDR0_PUB_ZQ1DR));
	printf("\nupdate channel 0 zq zq2pr=0x%08x,zq2dr=0x%08x,\n",rd_reg(DDR0_PUB_ZQ2PR),rd_reg(DDR0_PUB_ZQ2DR));

	//wr_reg( DDR1_PUB_ZQCR,(rd_reg(DDR1_PUB_ZQCR))|(1<<2)|(1<<27));
	//wr_reg( DDR1_PUB_ZQCR,(rd_reg(DDR1_PUB_ZQCR))&(~((1<<2)|(1<<27))));
	CLOSE_CHANNEL_A_PHY_CLK();
	CLOSE_CHANNEL_B_PHY_CLK();
	return 1;

}


int ddr_ee_pwm_voltage_table[31][2] = {
	{ 0x1c0000,  860},
	{ 0x1b0001,  870},
	{ 0x1a0002,  880},
	{ 0x190003,  890},
	{ 0x180004,  900},
	{ 0x170005,  910},
	{ 0x160006,  920},
	{ 0x150007,  930},
	{ 0x140008,  940},
	{ 0x130009,  950},
	{ 0x12000a,  960},
	{ 0x11000b,  970},
	{ 0x10000c,  980},
	{ 0x0f000d,  990},
	{ 0x0e000e, 1000},
	{ 0x0d000f, 1010},
	{ 0x0c0010, 1020},
	{ 0x0b0011, 1030},
	{ 0x0a0012, 1040},
	{ 0x090013, 1050},
	{ 0x080014, 1060},
	{ 0x070015, 1070},
	{ 0x060016, 1080},
	{ 0x050017, 1090},
	{ 0x040018, 1100},
	{ 0x030019, 1110},
	{ 0x02001a, 1120},
	{ 0x01001b, 1130},
	{ 0x00001c, 1140}
};


void ddr_test_pwm_set_voltage(unsigned int id, unsigned int voltage)
{
	int to;

#define ARRAY_SIZE(x) (sizeof(x) / sizeof((x)[0]))

	enum pwm_id {
		pwm_a = 0,
		pwm_b,
		pwm_c,
		pwm_d,
		pwm_e,
		pwm_f,
	};

	//printf("test ddr init pwm  id %08d \n",id);

	unsigned  reg;
	/*
	 * TODO: support more pwm controllers, right now only support
	 * PWM_B, PWM_D
	 */
	switch (id) {
		case pwm_b:
			reg =* (P_PWM_MISC_REG_AB);
			reg &= ~(0x7f << 16);
			reg |=  ((1 << 23) | (1 << 1));
			*(P_PWM_MISC_REG_AB) = reg;
			/*
			 * default set to max voltage
			 */
			*(P_PWM_PWM_B) = ddr_ee_pwm_voltage_table[ARRAY_SIZE(ddr_ee_pwm_voltage_table) - 1][0];
			reg  = *(P_PIN_MUX_REG1);
			reg &= ~(1 << 10);
			*(P_PIN_MUX_REG1) = reg;

			reg  = *(P_PIN_MUX_REG2);
			reg &= ~(1 << 5);
			reg |=  (1 << 11);		// enable PWM_B
			*(P_PIN_MUX_REG2) = reg;
			break;

		case pwm_d:
			reg =*( P_PWM_MISC_REG_CD);
			reg &= ~(0x7f << 16);
			reg |=  ((1 << 23) | (1 << 1));
			*(P_PWM_MISC_REG_CD) = reg;
			/*
			 * default set to max voltage
			 */
			*(P_PWM_PWM_D )= ddr_ee_pwm_voltage_table[ARRAY_SIZE(ddr_ee_pwm_voltage_table) - 1][0];
			reg  =*( P_PIN_MUX_REG1);
			reg &= ~(1 << 9);
			reg &= ~(1 << 11);
			*(P_PIN_MUX_REG1) = reg;

			reg  = *(P_PIN_MUX_REG2);
			reg |=  (1 << 12);		// enable PWM_D
			*(P_PIN_MUX_REG2 )= reg;
			break;
		default:
			break;
	}

	ddr_udelay(200);

	//printf("test ddr set vddee to  %08d mv\n",voltage);

	for (to = 0; to < ARRAY_SIZE(ddr_ee_pwm_voltage_table); to++) {
		if (ddr_ee_pwm_voltage_table[to][1] >= voltage) {
			break;
		}
	}
	if (to >= ARRAY_SIZE(ddr_ee_pwm_voltage_table)) {
		to = ARRAY_SIZE(ddr_ee_pwm_voltage_table) - 1;
	}
	switch (id) {
		case pwm_b:
			*(P_PWM_PWM_B) = ddr_ee_pwm_voltage_table[to][0];
			break;

		case pwm_d:
			*(P_PWM_PWM_D) = ddr_ee_pwm_voltage_table[to][0];
			break;
		default:
			break;
	}
	ddr_udelay(200);
}

int do_ddr_test_pwm_cmd (cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter do_ddr_test_pwm_cmd function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	int i=0;
	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}

	//writel((0), 0xc8836c00);
	OPEN_CHANNEL_A_PHY_CLK();
	OPEN_CHANNEL_B_PHY_CLK();
	//writel((0), 0xc8836c00);

	char *endp;


	unsigned int id=0;
	//  unsigned int voltage=1000;
	unsigned int pwm_low=0x1f;
	unsigned int pwm_high=0;


	{



		if (argc == 1)
		{  printf("\nplease read help\n");

		}
		else{
			if (argc >= 2)
			{
				// zq0pr0 = argv[1];
				// zq1pr0 = argv[2];
				id= simple_strtoull_ddr(argv[1], &endp, 0);
				//voltage= simple_strtoull_ddr(argv[1], &endp, 0);
			}

			if (argc >= 3)
			{

				pwm_low= simple_strtoull_ddr(argv[2], &endp, 0);
			}
			if (argc >= 4)
			{

				pwm_high= simple_strtoull_ddr(argv[3], &endp, 0);
			}
			pwm_low=(pwm_low>0x1f)?(0x1f):(pwm_low);
			pwm_high=(pwm_high>0x1f)?(0x1f):(pwm_high);

			printf("\npwm_low== 0x%08d 0-1f\n", pwm_low);
			printf("\npwm_high== 0x%08d  0-1f\n", pwm_high);
			printf("\npwm_id== 0x%08d\n", id);
			printf("\npwm_id 0== pwm_a\n");
			printf("\npwm_id 1== pwm_b\n");
			printf("\npwm_id 2== pwm_c\n");
			printf("\npwm_id 3== pwm_d\n");
			printf("\npwm_id 4== pwm_e\n");
			printf("\npwm_id 5== pwm_f\n");
			//ddr_test_pwm_set_voltage(id,voltage);

			{




#define ARRAY_SIZE(x) (sizeof(x) / sizeof((x)[0]))






				enum pwm_id {
					pwm_a = 0,
					pwm_b,
					pwm_c,
					pwm_d,
					pwm_e,
					pwm_f,
				};


				//printf("test ddr init pwm  id %08d \n",id);

				unsigned int reg;

				/*
				 * TODO: support more pwm controllers, right now only support
				 * PWM_B, PWM_D
				 */

				switch (id) {
					case pwm_b:
						reg = *(P_PWM_MISC_REG_AB);
						reg &= ~(0x7f << 16);
						reg |=  ((1 << 23) | (1 << 1));
						*(P_PWM_MISC_REG_AB) = reg;
						/*
						 * default set to max voltage
						 */
						*(P_PWM_PWM_B) =0x00001f;//pwm_low|(pwm_high<<16);// ddr_ee_pwm_voltage_table[ARRAY_SIZE(ddr_ee_pwm_voltage_table) - 1][0];
						reg  = *(P_PIN_MUX_REG1);
						reg &= ~(1 << 10);
						*(P_PIN_MUX_REG1) = reg;

						reg  = *(P_PIN_MUX_REG2);
						reg &= ~(1 << 5);
						reg |=  (1 << 11);		// enable PWM_B
						*(P_PIN_MUX_REG2 )= reg;
						break;

					case pwm_d:
						reg = *(P_PWM_MISC_REG_CD);
						reg &= ~(0x7f << 16);
						reg |=  ((1 << 23) | (1 << 1));
						*(P_PWM_MISC_REG_CD) = reg;
						/*
						 * default set to max voltage
						 */
						*(P_PWM_PWM_D )= 0x00001f;//pwm_low|(pwm_high<<16);//ddr_ee_pwm_voltage_table[ARRAY_SIZE(ddr_ee_pwm_voltage_table) - 1][0];
						reg  =*( P_PIN_MUX_REG1);
						reg &= ~(1 << 9);
						reg &= ~(1 << 11);
						*(P_PIN_MUX_REG1) = reg;

						reg  = *(P_PIN_MUX_REG2);
						reg |=  (1 << 12);		// enable PWM_D
						*(P_PIN_MUX_REG2) = reg;
						break;
					default:
						break;
				}

				ddr_udelay(200);

				//printf("test ddr set vddee to  %08d mv\n",voltage);

				//for (to = 0; to < ARRAY_SIZE(ddr_ee_pwm_voltage_table); to++) {
				//	if (ddr_ee_pwm_voltage_table[to][1] >= voltage) {
				//		break;
				//	}
				//}
				//if (to >= ARRAY_SIZE(ddr_ee_pwm_voltage_table)) {
				//	to = ARRAY_SIZE(ddr_ee_pwm_voltage_table) - 1;
				//}

				switch (id) {
					case pwm_b:
						*(P_PWM_PWM_B) = pwm_low|(pwm_high<<16);//ddr_ee_pwm_voltage_table[to][0];
						break;

					case pwm_d:
						*(P_PWM_PWM_D) = pwm_low|(pwm_high<<16);//ddr_ee_pwm_voltage_table[to][0];
						break;
					default:
						break;
				}
				ddr_udelay(200);
			}

			unsigned int   ddl_100step_ps= 0;
			ddl_100step_ps=((100*1000*1000)/(2*global_ddr_clk))/((((readl(DDR0_PUB_ACMDLR0)))>>16)&0xff);
			printf("\nddl_100step_ps== %08d,0_5cycle_ps== %08d,0_5cycle==0x%08x\n", ddl_100step_ps,((1000*1000)/(2*global_ddr_clk)),
					((((readl(DDR0_PUB_ACMDLR0)))>>16)&0xff));

			CLOSE_CHANNEL_A_PHY_CLK();
			CLOSE_CHANNEL_B_PHY_CLK();


		}

	}
	return 1;

}
int do_ddr_test_pwm_ddl (cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter do_ddr_test_pwm_ddl function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	int i=0;
	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}


	//writel((0), 0xc8836c00);
	OPEN_CHANNEL_A_PHY_CLK();

	OPEN_CHANNEL_B_PHY_CLK();
	//writel((0), 0xc8836c00);

	char *endp;

	unsigned int id=0;
	unsigned int voltage=1000;
	unsigned int loop=0;
	int to;

	if (argc == 1)
	{  printf("\nplease read help\n");

	}
	else{
		if (argc >= 2)
		{
			// zq0pr0 = argv[1];
			voltage= simple_strtoull_ddr(argv[1], &endp, 0);
		}

		if (argc >= 3)
		{
			// zq1pr0 = argv[2];
			id= simple_strtoull_ddr(argv[2], &endp, 0);
		}
		if (argc >= 4)
		{
			// zq1pr0 = argv[2];
			loop= simple_strtoull_ddr(argv[3], &endp, 0);
		}

		printf("\nvoltage== %08d\n", voltage);
		printf("\npwm_id== %08d\n", id);
		printf("\npwm_id 0== pwm_a\n");
		printf("\npwm_id 1== pwm_b\n");
		printf("\npwm_id 2== pwm_c\n");
		printf("\npwm_id 3== pwm_d\n");
		printf("\npwm_id 4== pwm_e\n");
		printf("\npwm_id 5== pwm_f\n");
		ddr_test_pwm_set_voltage(id,voltage);
		unsigned int   ddl_100step_ps= 0;
		ddl_100step_ps=((100*1000*1000)/(2*global_ddr_clk))/((((readl(DDR0_PUB_ACMDLR0)))>>16)&0xff);
		printf("\nvoltage ==%08d,ddl_100step_ps== %08d,0_5cycle_ps== %08d,0_5cycle==0x%08x\n",voltage, ddl_100step_ps,((1000*1000)/(2*global_ddr_clk)),
				((((readl(DDR0_PUB_ACMDLR0)))>>16)&0xff));

		if (loop)
		{

			for (to = 0; to < ARRAY_SIZE(ddr_ee_pwm_voltage_table); to++) {

				ddr_test_pwm_set_voltage(id,(ddr_ee_pwm_voltage_table[to][1]));
				ddl_100step_ps=((100*1000*1000)/(2*global_ddr_clk))/((((readl(DDR0_PUB_ACMDLR0)))>>16)&0xff);
				printf("\nvoltage ==%08d,ddl_100step_ps== %08d,0_5cycle_ps== %08d,0_5cycle==0x%08x\n",
						(ddr_ee_pwm_voltage_table[to][1]),ddl_100step_ps,((1000*1000)/(2*global_ddr_clk)),
						((((readl(DDR0_PUB_ACMDLR0)))>>16)&0xff));
			}
		}


		CLOSE_CHANNEL_A_PHY_CLK();
		CLOSE_CHANNEL_B_PHY_CLK();


	}

	return 1;

}

int do_ddr_test_shift_ddr_clk(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter test shift ddr clk function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	int i=0;
	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}

	int test_app_pra[4] = {0,0,0,0};

	char *endp;


	if (argc == 1)
	{  printf("\nplease read help\n");

	}
	else{
		if (argc >= 2)
		{
			// zq0pr0 = argv[1];
			test_app_pra[0]= simple_strtoull_ddr(argv[1], &endp, 0);
		}

		if (argc >= 3)
		{
			// zq1pr0 = argv[2];
			test_app_pra[1]= simple_strtoull_ddr(argv[2], &endp, 0);
		}

		if (argc >= 4)
		{
			// zq2pr0 =argv[3];
			test_app_pra[2]= simple_strtoull_ddr(argv[3], &endp, 0);

		}
	}


	//shift ddr frequency test
	printf("test_app_pra[0]==0x%08x\n",test_app_pra[0] );
	printf("test_app_pra[1]==0x%08x\n",test_app_pra[1] );
	printf("test_app_pra[2]==0x%08x\n",test_app_pra[2] );
	unsigned int reg_value[4] = {0};
	unsigned int delay_ms_time=30;
	unsigned int test_times=0xffff;
	unsigned int test_count=0;
	unsigned int test_loop_flag=0;
	reg_value[0]=0xc4aae860 ;
	wr_reg( 0xc883601c,(reg_value[0]));
	//update_reg_debug_value(&(reg_value[0]),0xc883601c );
	reg_value[1]=0x000ea203  ;
	wr_reg( 0xc8837004,(reg_value[1]));
	//update_reg_debug_value(&(reg_value[1]),0xc8837004  );

	reg_value[3]=0x03e3b740  ;
	if ((test_app_pra[1]))
	{delay_ms_time=(test_app_pra[1]);
	}
	if ((test_app_pra[2]))
	{test_times=(test_app_pra[2]);
		if (test_times == 0xffffffff)
			test_loop_flag=1;
	}
	printf("delay_ms_time==%d\n",delay_ms_time );
	printf("test_times==%d\n",test_times );
	if (test_app_pra[0] ==0)
		reg_value[2]=0x03e3b750  ;
	if (test_app_pra[0] ==1)
		reg_value[2]=0x03e3b754  ;
	if (test_app_pra[0] ==2)
		reg_value[2]=0x03e3b758  ;
	if (test_app_pra[0] ==3)
		reg_value[2]=0x03e3b75c  ;

	if (test_app_pra[0] ==4)
	{
		reg_value[2]=0x03e3b750  ;
		reg_value[3]=0x03e3b754  ;
	}
	if (test_app_pra[0] ==5)
	{
		reg_value[2]=0x03e3b750  ;
		reg_value[3]=0x03e3b758  ;
	}
	if (test_app_pra[0] ==6)
	{
		reg_value[2]=0x03e3b750  ;
		reg_value[3]=0x03e3b75c  ;
	}
	if (test_app_pra[0] ==7)
	{
		reg_value[2]=0x03e3b754  ;
		reg_value[3]=0x03e3b758  ;
	}
	if (test_app_pra[0] ==8)
	{
		reg_value[2]=0x03e3b754  ;
		reg_value[3]=0x03e3b75c  ;
	}
	if (test_app_pra[0] ==9)
	{
		reg_value[2]=0x03e3b758  ;
		reg_value[3]=0x03e3b75c  ;
	}
	while (1) {test_count++;
		//	reg_value[2]=0x03e3b750  ;
		//update_reg_debug_value(&(reg_value[2]),0xc883700c  );

		wr_reg( 0xc8837010,(0x001c0101));
		ddr_udelay(delay_ms_time * 1000);
		wr_reg( 0xc883700c,(reg_value[2]));
		printf("\nupdate  reg 0xc883700c=0x%08x\n",rd_reg(0xc883700c));
		ddr_udelay(delay_ms_time * 1000);
		wr_reg( 0xc8837010,(0x000c0101));
		ddr_udelay(delay_ms_time * 1000);
		wr_reg( 0xc8837010,(0x001c0101));
		ddr_udelay(delay_ms_time * 1000);
		//usleep(1000 * 1000);
		//reg_value[3]=0x03e3b740  ;
		//update_reg_debug_value(&(reg_value[3]),0xc883700c   );
		wr_reg( 0xc883700c,(reg_value[3]));
		printf("\nupdate  reg 0xc883700c=0x%08x\n",rd_reg(0xc883700c));
		ddr_udelay(delay_ms_time * 1000);
		wr_reg( 0xc8837010,(0x000c0101));
		ddr_udelay(delay_ms_time * 1000);
		printf("\ntesting %d times\n",(test_count));
		if (!test_loop_flag)
		{
			if (test_count == test_times)
				break;
		}
	}

	return 1;

}

#if ( CONFIG_DDR_PHY >= P_DDR_PHY_G12)
#else
int do_ddr_test_shift_ddr_clk_txl(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnter test shift ddr clk function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	int i=0;
	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
		printf("\nargv[%d]=%s\n",i,argv[i]);

	int test_app_pra[4] = {0,0,0,0};

	char *endp;
	if (argc == 1)
	{  printf("\nplease read help\n");

	}
	else{
		if (argc >= 2)
		{
			// zq0pr0 = argv[1];
			test_app_pra[0]= simple_strtoull_ddr(argv[1], &endp, 0);
		}

		if (argc >= 3)
		{
			// zq1pr0 = argv[2];
			test_app_pra[1]= simple_strtoull_ddr(argv[2], &endp, 0);
		}

		if (argc >= 4)
		{
			// zq2pr0 =argv[3];
			test_app_pra[2]= simple_strtoull_ddr(argv[3], &endp, 0);

		}}
	if (argc >= 5)
	{
		// zq2pr0 =argv[3];
		test_app_pra[3]= simple_strtoull_ddr(argv[4], &endp, 0);

	}





	//shift ddr frequency test
	printf("test_app_pra[0]==0x%08x\n",test_app_pra[0] );
	printf("test_app_pra[1]==0x%08x\n",test_app_pra[1] );
	printf("test_app_pra[2]==0x%08x\n",test_app_pra[2] );
	printf("test_app_pra[3]==0x%08x\n",test_app_pra[3] );
	//   unsigned int reg_value[4] = {0};
	unsigned int delay_ms_time=30;
	unsigned int test_times=0xffff;
	unsigned int test_count=0;
	unsigned int test_loop_flag=0;
	//reg_value[0]=0 ;
	//	reg_value[1]=0x000ea202  ;
	//wr_reg( 0xc8837004,(reg_value[1]));
	//update_reg_debug_value(&(reg_value[1]),0xc8837004  );


	if ((test_app_pra[1]))
	{delay_ms_time=(test_app_pra[1]);
	}
	if ((test_app_pra[2]))
	{test_times=(test_app_pra[2]);
		if (test_times == 0xffffffff)
			test_loop_flag=1;
	}
	delay_ms_time=0;
	printf("delay_ms_time==%d\n",delay_ms_time );
	printf("test_times==%d\n",test_times );


	//	  printf("\ntesting reg_value[2] ==%08x; \n",(reg_value[2));


	while (1) {test_count++;
		//	reg_value[2]=0x03e3b750  ;
		//update_reg_debug_value(&(reg_value[2]),0xc883700c  );

		wr_reg( 0xff63700c,0x3e3b774);
		//	wr_reg( 0xff63700c,((rd_reg(0xff63700c))&(~(0x7<2)))|(reg_value[2]<<2)|(1<<4));
		printf("\nupdate  reg 0xff63700c=0x%08x\n",rd_reg(0xff63700c));
		ddr_udelay(delay_ms_time * 1000);
		wr_reg( 0xff63700c,0x3e3b764);
		//wr_reg( 0xff63700c,((rd_reg(0xff63700c))&(~(0x7<2)))|(reg_value[2]<<2)|(1<<4));
		printf("\n...update  reg 0xff63700c=0x%08x\n",rd_reg(0xff63700c));
		ddr_udelay(delay_ms_time * 1000);



		printf("\ntesting %d times\n",(test_count));
		if (!test_loop_flag)
		{
			if (test_count == test_times)
				break;
		}
	}

	return 1;
}
#endif

void ddr_memcpy(void *dst, const void *src, uint32_t len)
{
	//enable_mmu_el1_s();
	//printf("\nlen==%d,",len);
	//printf(len);
	//serial_puts("\n");
	//uint32_t ddr_test_start_time_us=get_us_time();  // check cost time
	//const char *s = src;
	//char *d = dst;
	len=(len>>3);
	const long long *s = src;
	long long *d = dst;
	#ifdef TEST_L1_CACHE
	void *bound=(void *)src+16*1024; //debug for test L1 cache ,if only read write small aread
	#endif
	while (len)
	{
		//ddr_pld_cache(s) ;
		///1 times   len==33554432   copy time==18192 us   1.2g  bandwidth 3688M/S
		// 4times   len==33554432   copy time==11844 us   1.2g  bandwidth 5666M/S
		// 8times   len==33554432   copy time==11844 us   1.2g  bandwidth 5666M/S
		*d++ = *s++;
		*d++ = *s++;
		*d++ = *s++;
		*d++ = *s++;
		len=len-4;
		#ifdef TEST_L1_CACHE
		if ((void *)s >=bound)
			{
			  s=src;
		         d=dst;
			 }
		#endif
	}
	//	uint32_t ddr_test_end_time_us=get_us_time();  // check cost time
	//	serial_puts("\ncopy time==");
	//	serial_put_dec(ddr_test_end_time_us-ddr_test_start_time_us);
	//	serial_puts("\n");
	//printf("\ncopy time==%d us,",(ddr_test_end_time_us-ddr_test_start_time_us));
}

#define PATTERN_MATRIX_X   (3+32+16+17)     //68*32==2176 ///2.2k -0x880-1 loop
#define PATTERN_MATRIX_Y  (32)
#define PATTERN_MATRIX_LOOP_SIZE   ((PATTERN_MATRIX_X)*(PATTERN_MATRIX_Y)*4)

unsigned int cpu_ddr_test_init_pattern_generater(unsigned int add_offset )
{	

	unsigned int pattern_select=0;
	unsigned int pattern_value=0;
	//test_size=(test_size>0x10000)?test_size:0x10000;
	//	uint32_t write_addr = start_add;
	uint32_t martix_x_select= 0;
	uint32_t martix_y_select= 0;
	unsigned int pattern_value_temp_16=0;
	{
		//	uint32_t test_end_add = start_add+test_size;
		//	for((write_addr=start_add);(write_addr<test_end_add);)
		{
			pattern_select=((add_offset)%((PATTERN_MATRIX_Y)*(PATTERN_MATRIX_X)));
			martix_x_select=pattern_select/(PATTERN_MATRIX_Y);
			martix_y_select=pattern_select%(PATTERN_MATRIX_Y);
			//write_addr_nibble_start=((((add_offset/PATTERN_MATRIX_Y)/PATTERN_MATRIX_X))*
			//	(((PATTERN_MATRIX_Y)*PATTERN_MATRIX_X)));
			//write_addr_nibble_start=(((add_offset)%PATTERN_MATRIX_Y)%PATTERN_MATRIX_X)
			{
				if(martix_x_select==0)
					pattern_value=0xaaaa5555;  //for 16 bit bus pattern

				if(martix_x_select==1)
					pattern_value=0x0000ffff; //for 16 bit bus pattern

				if(martix_x_select==2)
					pattern_value=0;

				if((martix_x_select>2)&&(martix_x_select<(3+32)))
				{
					pattern_value=1<<(martix_x_select-3);
				}
				if((martix_x_select>(2+32))&&(martix_x_select<(3+32+16)))   //for 16 bit bus pattern
				{
					pattern_value_temp_16=(1<<(martix_x_select-3-32));
					pattern_value=pattern_value_temp_16|((~pattern_value_temp_16)<<16);
				}
				if((martix_x_select>(2+32+16))&&(martix_x_select<(3+32+16+17)))   //for dbi bus pattern  17 group
				{
					pattern_value_temp_16=(0x0f0f+0xf0f*(martix_x_select-3-32-16));
					pattern_value=pattern_value_temp_16|((~pattern_value_temp_16)<<16);									
				}
			}
			if(martix_y_select%2)
			pattern_value=~pattern_value;
		}
	}
	//	serial_puts("\ncpu_test_ddr_debug4");
	return pattern_value;
}

void cpu_ddr_test_init_pattern_area(unsigned int test_init_start,unsigned int test_size,unsigned int parttern_frequency_setting )
{
	//	printf("\n 111");
	if(parttern_frequency_setting==0)
	parttern_frequency_setting=1;  //for different  frequency pattern
	test_size=(test_size>((PATTERN_MATRIX_LOOP_SIZE)*(parttern_frequency_setting)))?test_size:((PATTERN_MATRIX_LOOP_SIZE)*(parttern_frequency_setting));
	//unsigned int test_start=0x1080000;
	unsigned int write_add=test_init_start;
	unsigned int size_loop=0;
	unsigned int size_loop_max=0;
	//unsigned int count=0;
	for(;(size_loop<((PATTERN_MATRIX_LOOP_SIZE)*(parttern_frequency_setting)));)
	{
		//serial_puts("\ncpu_test_ddr_debug5");

		//	for(  count=0;count<(parttern_frequency_setting);)
		{
			write_add = (uint32_t)(size_loop + test_init_start);
			wr_reg((unsigned long)write_add, cpu_ddr_test_init_pattern_generater((size_loop>>2)/parttern_frequency_setting));
			size_loop=size_loop+4;
		}
		//	serial_puts("\ncpu_test_ddr_debug6");

		//	serial_puts(" ");
		#if 0
		serial_put_hex(size_loop,32);
		serial_puts(" ");
		serial_put_hex(cpu_ddr_test_init_pattern_generater(size_loop>>2),32);
		#endif
	}
	size_loop=1;
	size_loop_max=((test_size/(((PATTERN_MATRIX_LOOP_SIZE)*(parttern_frequency_setting))))+1);
	for(;(size_loop<size_loop_max);)
	{
		//	serial_puts("\ncpu_test_ddr_debug41");
		ddr_memcpy((void *)(uint64_t)(test_init_start+((PATTERN_MATRIX_LOOP_SIZE)*(parttern_frequency_setting))*(size_loop)), (void *)(uint64_t)test_init_start, ((PATTERN_MATRIX_LOOP_SIZE)*(parttern_frequency_setting)));
		//serial_puts("\ncpu_test_ddr_debug42");
		size_loop++;
	}
}

unsigned int cpu_ddr_test(unsigned test_init_start,unsigned int start_add, unsigned int test_size, unsigned int test_data_bit_enable,unsigned int parttern_frequency_setting)
{
	//printf("\n 1112");

	unsigned int src_add=test_init_start;
	unsigned int pattern_value=0;
	unsigned int size_loop=0;
	unsigned int ddr_test_error=0;
	unsigned int read_add=0;
	unsigned int read_value=0;
	test_size=(test_size>0x2000)?(test_size):(0x2000);
	//cpu_ddr_test_init_pattern_area(test_size);
	uint32_t ddr_test_start_time_us=get_us_time();  // check cost time
	ddr_memcpy((void *)(uint64_t)start_add, (void *)(uint64_t)src_add, test_size);
	uint32_t ddr_test_end_time_us=get_us_time();  // check cost time
	printf("\ncpu_ddr_test_test_copy_bandwidth==%d Mbyte/s\n",(1*test_size*2)/(ddr_test_end_time_us-ddr_test_start_time_us));

	for(;size_loop<(test_size);)
	{
		read_add = (uint32_t)(size_loop + start_add);
		read_value=(rd_reg((unsigned long)read_add));
		pattern_value=( cpu_ddr_test_init_pattern_generater((size_loop>>2)/parttern_frequency_setting));
		if(((test_data_bit_enable)&read_value)!=((test_data_bit_enable)&pattern_value))
		{
			#if 1
			printf("error data  enable %08x read_value %08x  pattern_value %08x",test_data_bit_enable,read_value,pattern_value);
			#if 0
			serial_puts("\nerror data ");
			serial_put_hex(test_data_bit_enable,32);
			serial_puts(" ");
			serial_put_hex(read_value,32);
			serial_puts(" ");
			serial_put_hex(pattern_value,32);
			serial_puts("\n");
			#endif
			#endif
			ddr_test_error++;
			return ddr_test_error;
		}
		size_loop=size_loop+(1<<2);// use big step will fast test ,but lose accuracy.
	}
	//printf("\n 1114");
	return ddr_test_error;
}

int do_cpu_ddr_test (cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	//ddr_cpu_test 0x1080000 0x10000000 0x2000000 0xffffffff 10  //size do not overlap
	int i=0;
	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}
	unsigned int init_start_add=0;
	unsigned int test_add=0;
	unsigned int test_size=0;
	unsigned int test_data_bit_enable=0;
	unsigned int test_loops=0;
	unsigned int test_loop=0;
	unsigned int test_errors=0;
	unsigned int parttern_frequency_setting =1;
	char *endp;
	if (argc == 1)
		printf("\nplease read help\n");
	else
	{
		if (argc >= 2)
		{
			// zq0pr0 = argv[1];
			init_start_add= simple_strtoull_ddr(argv[1], &endp, 0);
		}

		if (argc >= 3)
		{
			// zq1pr0 = argv[2];
			test_add= simple_strtoull_ddr(argv[2], &endp, 0);
		}
		if (argc >= 4)
		{
			// zq1pr0 = argv[2];
			test_size= simple_strtoull_ddr(argv[3], &endp, 0);
		}
		if (argc >= 5)
		{
			// zq1pr0 = argv[2];
			test_data_bit_enable= simple_strtoull_ddr(argv[4], &endp, 0);
		}
		if (argc >= 6)
		{
			// zq1pr0 = argv[2];
			test_loops= simple_strtoull_ddr(argv[5], &endp, 0);
			if(test_loops==0)
			test_loops=1;
		}
		if (argc >= 7)
		{
			// zq1pr0 = argv[2];
			parttern_frequency_setting= simple_strtoull_ddr(argv[6], &endp, 0);
			if(parttern_frequency_setting==0)
			parttern_frequency_setting=1;
		}
	}
	uint32_t ddr_test_start_time_us=get_us_time();  // check cost time
	cpu_ddr_test_init_pattern_area(init_start_add,test_size,parttern_frequency_setting);
	for(test_loop=0;test_loop<test_loops;)
	{
		test_errors=test_errors+cpu_ddr_test(init_start_add,test_add,test_size,test_data_bit_enable,parttern_frequency_setting);
		test_loop++;
		printf("\ncpu_ddr_test_test_times==%d  test_errors==%d",test_loop,test_errors);
	}
	uint32_t ddr_test_end_time_us=get_us_time();  // check cost time
	printf("\ncpu_ddr_test_test_and compare_bandwidth==%d Mbyte/s\n",(test_loops*test_size*2)/(ddr_test_end_time_us-ddr_test_start_time_us));
	return test_errors;
}
U_BOOT_CMD(
	ddr_cpu_test,	30,	1,	do_cpu_ddr_test,
	"ddr_test_cmd cmd arg1 arg2 arg3...",
	"ddr_test_cmd cmd arg1 arg2 arg3... \n dcache off ? \n"
	);

int do_ddr_test_write_read (cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	///*
	{
		printf("\nEnter do_ddr_test_ddr_write_read_current\n");
		//   if(!argc)
		//    goto DDR_TUNE_DQS_START;
		int i=0;
		printf("\nargc== 0x%08x\n", argc);
		for (i = 0;i<argc;i++)
		{
			printf("\nargv[%d]=%s\n",i,argv[i]);
		}

		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);

		char *endp;

		unsigned int pattern_id=1;
		unsigned int pattern[4] ={0};
		unsigned int write_read=0;
		unsigned int read_pattern[4]={0} ;
		unsigned int loop=1;
		unsigned int  start_addr = DDR_TEST_START_ADDR;
		unsigned int  test_size = DDR_TEST_SIZE;
		unsigned int  copy_offset= DDR_TEST_SIZE;
		unsigned int  no_show_info= 0;
		unsigned int  us_delay_counter= 0;


		if (argc == 1)
			printf("\nplease read help\n");
		else {
			if (argc >= 2)
			{
				// zq0pr0 = argv[1];
				write_read= simple_strtoull_ddr(argv[1], &endp, 0);
			}

			if (argc >= 3)
			{
				// zq1pr0 = argv[2];
				pattern_id= simple_strtoull_ddr(argv[2], &endp, 0);
			}
			if (argc >= 4)
			{
				// zq1pr0 = argv[2];
				loop= simple_strtoull_ddr(argv[3], &endp, 0);
			}
			if (argc >=5)
			{
				// zq1pr0 = argv[2];
				start_addr= simple_strtoull_ddr(argv[4], &endp, 0);
			}
			if (argc >=6)
			{
				// zq1pr0 = argv[2];
				test_size= simple_strtoull_ddr(argv[5], &endp, 0);
			}
			if (argc >=7)
			{
				// zq1pr0 = argv[2];
				no_show_info= simple_strtoull_ddr(argv[6], &endp, 0);
			}
			if (argc >=8)
			{
				// zq1pr0 = argv[2];
				us_delay_counter= simple_strtoull_ddr(argv[7], &endp, 0);
			}
		}
		printf("\nwrite_read== 0x%08d\n", write_read);
		printf("\npattern_id== 0x%08d\n", pattern_id);
		printf("\nloop== 0x%08d\n", loop);
		printf("\nstart_addr== 0x%08x\n", start_addr);
		printf("\ntest_size== 0x%08x\n", test_size);
		printf("\nus_delay_counter== %d\n", us_delay_counter);
		copy_offset=test_size;

		unsigned int  *p;
		unsigned int   j;


		p = (unsigned int  * )(int_convter_p(start_addr));

		if (pattern_id == 0)
		{
			pattern[0]=0;
			pattern[1]=0;
			pattern[2]=0;
			pattern[3]=0;
		}
		if (pattern_id == 1)
		{
			pattern[0]=0xffffffff;
			pattern[1]=0xffffffff;
			pattern[2]=0xffffffff;
			pattern[3]=0xffffffff;
		}


		do
		{
			if (write_read == 0)
			{ 
				if(!no_show_info)
					printf("\nloop:0x%08x:Start writing at 0x%08x - 0x%08x...", loop,start_addr, start_addr + test_size);
				for (j=0;j<test_size/4;)
				{
					*(p+j)=(pattern[0]);
					*(p+j+1)=(pattern[1]);
					*(p+j+2)=(pattern[2]);
					*(p+j+3)=(pattern[3]);
					j=j+4;
				}
			}
			if (write_read == 1)
			{  
				if(!no_show_info)
					printf("\nloop:0x%08x:Start reading at 0x%08x - 0x%08x...", loop,start_addr, start_addr + test_size);
				for (j=0;j<test_size/4;)
				{
					read_pattern[0]= *(p+j);
					read_pattern[1]= *(p+j+1);
					read_pattern[2]=*(p+j+2);
					read_pattern[3]= *(p+j+3);
					j=j+4;
				}
				if (loop == 1) {
					if(!no_show_info)
						printf(" \nloop:0x%08x:Start reading read_pattern[0] 0x%08x, pattern[1] 0x%08x,pattern[2] 0x%08x,pattern[3] 0x%08x",
								loop,read_pattern[0], read_pattern[1],read_pattern[2],read_pattern[3]
							  );  }
			}
			if (write_read == 2)
			{   
				if(!no_show_info)
					printf("\nloop:0x%08x:Start copying at 0x%08x - 0x%08x...", loop,start_addr, start_addr + test_size);
				for (j=0;j<test_size/4;)
				{
					*(p+j+copy_offset/4)= *(p+j);
					*(p+j+1+copy_offset/4)= *(p+j+1);
					*(p+j+2+copy_offset/4)= *(p+j+2);
					*(p+j+3+copy_offset/4)= *(p+j+3);
					j=j+4;
				}
			}
			if(us_delay_counter)
			{
				ddr_udelay(us_delay_counter);
			}
		}while(loop--);


		CLOSE_CHANNEL_A_PHY_CLK();
		CLOSE_CHANNEL_B_PHY_CLK();

		printf("\ntest end\n");

		return 1;
	}
	//*/
}

#if ( CONFIG_DDR_PHY >= P_DDR_PHY_G12)

#define TEST_MIN_DDR_EE_VOLTAGE  681
#define TEST_MAX_DDR_EE_VOLTAGE  962
#define    G12_AO_PWM_PWM_B                                       (0xff807000 + (0x001 << 2))
static int pwm_voltage_table_ee[][2] =
{
	{ 0x1c0000,  681},
	{ 0x1b0001,  691},
	{ 0x1a0002,  701},
	{ 0x190003,  711},
	{ 0x180004,  721},
	{ 0x170005,  731},
	{ 0x160006,  741},
	{ 0x150007,  751},
	{ 0x140008,  761},
	{ 0x130009,  772},
	{ 0x12000a,  782},
	{ 0x11000b,  792},
	{ 0x10000c,  802},
	{ 0x0f000d,  812},
	{ 0x0e000e,  822},
	{ 0x0d000f,  832},
	{ 0x0c0010,  842},
	{ 0x0b0011,  852},
	{ 0x0a0012,  862},
	{ 0x090013,  872},
	{ 0x080014,  882},
	{ 0x070015,  892},
	{ 0x060016,  902},
	{ 0x050017,  912},
	{ 0x040018,  922},
	{ 0x030019,  932},
	{ 0x02001a,  942},
	{ 0x01001b,  952},
	{ 0x00001c,  962}
};
uint32_t find_vddee_voltage_index(unsigned int target_voltage)
{
	unsigned int to;
	for (to = 0; to < ARRAY_SIZE(pwm_voltage_table_ee); to++) {
		if (pwm_voltage_table_ee[to][1] >= target_voltage) {
			break;
		}
	}
	if (to >= ARRAY_SIZE(pwm_voltage_table_ee)) {
		to = ARRAY_SIZE(pwm_voltage_table_ee) - 1;
	}
	return to;
}

void set_ee_voltage(uint32_t ee_over_ride_voltage)
{
	unsigned int to;
	for (to =  (ARRAY_SIZE(pwm_voltage_table_ee));( to >0); to--) {
		if ((pwm_voltage_table_ee[to-1][1]<ee_over_ride_voltage) && (pwm_voltage_table_ee[to][1] >= ee_over_ride_voltage)) {
			break;
		}
	}
	if (ee_over_ride_voltage) {
		writel(pwm_voltage_table_ee[to][0],G12_AO_PWM_PWM_B);
		printf ("\nDDR_override_EE_voltage ==%d mv /n",pwm_voltage_table_ee[to-1][1]);
	}
}

unsigned int read_ee_voltage(void)
{
	unsigned int to;
	unsigned int reg_value=0;
	reg_value=readl(G12_AO_PWM_PWM_B);
	to=reg_value&0xff;
	return pwm_voltage_table_ee[to][1];
}
uint32_t get_bdlr_100step(uint32_t ddr_frequency)
{
	uint32_t bdlr_100step=0;
	//uint32_t ps=0;
	//ps=(rd_reg(DMC_DRAM_FREQ_CTRL))&1;
	dwc_ddrphy_apb_wr(((((0<<20)|(2<<16)|(0<<12)|(0xe3)))),0xc00);
	bdlr_100step=(100000000/(2*ddr_frequency))/((dwc_ddrphy_apb_rd((((0<<20)|(2<<16)|(0<<12)|(0xe4)))))&0x3ff);
	return bdlr_100step;
}

int do_ddr_test_pwm_bdlr (cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	char *endp;
	printf("\nEnter g12 do_ddr_test_pwm_bdl function\n");
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	int i=0;
	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
	{
		printf("\nargv[%d]=%s\n",i,argv[i]);
	}

	//if (argc < 2)
	//	goto usage;


	unsigned int argc_count=1;
	unsigned int  para_meter[30]={0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0,};
	while(argc_count<argc)
	{para_meter[argc_count-1]= simple_strtoul(argv[argc_count], &endp, 0);
		if (*argv[argc_count] == 0 || *endp != 0) {
			para_meter[argc_count-1] = 0;
		}
		argc_count++;
	}

	//uint32_t id=para_meter[0];
	//uint32_t voltage=para_meter[1];
	uint32_t loop=para_meter[0];
	uint32_t voltage_min=para_meter[1];
	uint32_t voltage_max=para_meter[2];
	uint32_t show_count_message=para_meter[3];

	//#define PWM_ID_DEFAULT   0<<0
	//#define PWM_VOLTAGE_DEFAULT   800<<0
	#define PWM_LOOP_DEFAULT   10<<0
	#define PWM_VOLTAGE_MIN_DEFAULT   TEST_MIN_DDR_EE_VOLTAGE
	#define PWM_VOLTAGE_MAX_DEFAULT   TEST_MAX_DDR_EE_VOLTAGE


	//id=id?id:PWM_ID_DEFAULT;
	//voltage=voltage?voltage:PWM_VOLTAGE_DEFAULT;
	loop=loop?loop:PWM_LOOP_DEFAULT;
	voltage_min=(voltage_min<PWM_VOLTAGE_MIN_DEFAULT)?PWM_VOLTAGE_MIN_DEFAULT:voltage_min;
	voltage_max=(voltage_max>PWM_VOLTAGE_MAX_DEFAULT)?PWM_VOLTAGE_MAX_DEFAULT:voltage_max;
	voltage_max=(voltage_max<PWM_VOLTAGE_MIN_DEFAULT)?PWM_VOLTAGE_MAX_DEFAULT:voltage_max;

	//	  printf("\nvoltage_min=%d\n",voltage_min);
	//	  		  printf("\nvoltage_max=%d\n",voltage_max);
	uint16_t bdlr_100_min=0;
	uint16_t bdlr_100_average=0;
	uint16_t bdlr_100_max=0;
	uint16_t bdlr_100_cur=0;
	//uint16_t cur_ddr_frequency=0;
	uint32_t count=1;

	bdlr_100_cur=get_bdlr_100step(global_ddr_clk);
	bdlr_100_min=bdlr_100_cur;
	bdlr_100_max=bdlr_100_cur;
	bdlr_100_average=bdlr_100_cur;

	unsigned int to=0;
	unsigned int to_min=0;
	unsigned int to_max=(ARRAY_SIZE(pwm_voltage_table_ee))-1;
	//unsigned int temp_count=0;
	printf("\nread org_EE_voltage %d mv \n",read_ee_voltage());
	to_min=find_vddee_voltage_index(voltage_min);
	to_max=find_vddee_voltage_index(voltage_max);
	for (to =(to_max+1)  ;( to >to_min); to--) {
		//  printf("\nTO=%d\n",to);
		writel(pwm_voltage_table_ee[to-1][0],G12_AO_PWM_PWM_B);
		udelay(1000);
		bdlr_100_cur=get_bdlr_100step(global_ddr_clk);
		bdlr_100_min=bdlr_100_cur;
		bdlr_100_max=bdlr_100_cur;
		bdlr_100_average=bdlr_100_cur;
		count=1;

		//	printf("\nDDR_set EE_voltage %d  bdlr_100_average %d  bdlr_100_min %d bdlr_100_max %d count %d,bdlr_100_cur %d \n",pwm_voltage_table_ee[to-1][1],
		//bdlr_100_average,bdlr_100_min,bdlr_100_max,count,bdlr_100_cur);

		do {
			bdlr_100_cur=(100000000/(2*global_ddr_clk))/((dwc_ddrphy_apb_rd((((0<<20)|(2<<16)|(0<<12)|(0xe4)))))&0x3ff);
			bdlr_100_min=(bdlr_100_cur<bdlr_100_min)?bdlr_100_cur:bdlr_100_min;
			bdlr_100_max=(bdlr_100_cur>bdlr_100_max)?bdlr_100_cur:bdlr_100_max;
			bdlr_100_average=(bdlr_100_cur+bdlr_100_average*count)/(count+1);
			count++;
			if(show_count_message)
				printf("%d\n",bdlr_100_cur);

		}while(count<loop);
		printf("\nDDR_set EE_voltage %d  bdlr_100_average %d  bdlr_100_min %d bdlr_100_max %d count %d",pwm_voltage_table_ee[to-1][1],
				bdlr_100_average,bdlr_100_min,bdlr_100_max,count);


	}




	return 1;

}

typedef struct ddr_sha_s {
	unsigned char sha2[SHA256_SUM_LEN];
	ddr_set_t ddrs;
} ddr_sha_t;

ddr_sha_t ddr_sha = {{0}};
ddr_set_t *ddr_set_t_p_arrary = &ddr_sha.ddrs;
int do_ddr_display_g12_ddr_information(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{

	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	int i=0;
	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
		printf("\nargv[%d]=%s\n",i,argv[i]);

	ddr_set_t *ddr_set_t_p=NULL;
	ddr_set_t_p=(ddr_set_t *)(ddr_set_t_p_arrary);
	//ddr_set_t_p= (ddr_set_t *)G12_DMC_STICKY_0;
	//if (sizeof(ddr_set_t)<loop_max)
	printf("\nddr_set_t_p==0x%08x\n",(uint32_t)(uint64_t)(ddr_set_t_p));
	uint32_t loop=0; 
	uint32_t loop_max = (4+(0x3f<<2));//((DMC_STICKY_63-DMC_STICKY_0));
	//	loop_max=sizeof(ddr_set_t);
	for (loop = 0; loop <loop_max; loop+=4) {
		wr_reg(((uint64_t)(ddr_set_t_p) + loop), rd_reg(G12_DMC_STICKY_0 + loop));
	}
			
{
		uint16_t	dq_bit_delay[72];
		unsigned	char t_count=0;
		uint16_t  delay_org=0;
		uint16_t  delay_temp=0;
		uint32_t  add_offset=0;
		dwc_ddrphy_apb_wr(0xd0000,0x0);
		bdlr_100step=get_bdlr_100step(global_ddr_clk);
		ui_1_32_100step=(1000000*100/(global_ddr_clk*2*32));

		{
		//		dwc_ddrphy_apb_wr((0<<20)|(1<<16)|(0<<12)|(0x20),p_dev->p_ddrs->dfi_mrl);  //DFIMRL
		//dwc_ddrphy_apb_wr((0<<20)|(1<<16)|(1<<12)|(0x20),p_dev->p_ddrs->dfi_mrl);  //DFIMRL
		//dwc_ddrphy_apb_wr((0<<20)|(1<<16)|(2<<12)|(0x20),p_dev->p_ddrs->dfi_mrl);  //DFIMRL
		//dwc_ddrphy_apb_wr((0<<20)|(1<<16)|(3<<12)|(0x20),p_dev->p_ddrs->dfi_mrl);  //DFIMRL
		//dwc_ddrphy_apb_wr((0<<20)|(2<<16)|(0<<12)|(0x20),p_dev->p_ddrs->dfi_mrl);  //HwtMRL
		//ddr_set_t_p->dfi_mrl;
		//ddr_set_t_p->dfi_hwtmrl;
		ddr_set_t_p->ARdPtrInitVal=0;
		printf("\n ARdPtrInitVal");
		add_offset=((0<<20)|(0<<16)|(0<<12)|(0x2e));
		delay_org=dwc_ddrphy_apb_rd(add_offset);
		ddr_set_t_p->ARdPtrInitVal=delay_org;
		printf("\n t_count: %04d %04d  %08x %08x",0,delay_org,((((add_offset) << 1)+0xfe000000)),delay_org);
		
		printf("\n dfimrl0 dfimrl1 dfimrl2 dfimrl3 HwtMRL");
		add_offset=((0<<20)|(1<<16)|(0<<12)|(0x20));
		delay_org=dwc_ddrphy_apb_rd(add_offset);
		ddr_set_t_p->dfi_mrl=delay_org;
		printf("\n t_count: %04d %04d  %08x %08x",0,delay_org,((((add_offset) << 1)+0xfe000000)),delay_org);
		add_offset=((0<<20)|(1<<16)|(1<<12)|(0x20));
		delay_org=dwc_ddrphy_apb_rd(add_offset);
		printf("\n t_count: %04d %04d  %08x %08x",1,delay_org,((((add_offset) << 1)+0xfe000000)),delay_org);
		add_offset=((0<<20)|(1<<16)|(2<<12)|(0x20));
		delay_org=dwc_ddrphy_apb_rd(add_offset);
		printf("\n t_count: %04d %04d  %08x %08x",2,delay_org,((((add_offset) << 1)+0xfe000000)),delay_org);
		add_offset=((0<<20)|(1<<16)|(3<<12)|(0x20));
		delay_org=dwc_ddrphy_apb_rd(add_offset);
		printf("\n t_count: %04d %04d  %08x %08x",3,delay_org,((((add_offset) << 1)+0xfe000000)),delay_org);
		add_offset=((0<<20)|(2<<16)|(0<<12)|(0x20));
		delay_org=dwc_ddrphy_apb_rd(add_offset);

		ddr_set_t_p->dfi_hwtmrl=delay_org;
		printf("\n t_count: %04d %04d  %08x %08x",0,delay_org,((((add_offset) << 1)+0xfe000000)),delay_org);
		}
	{
		printf("\n count_index     delay_value     register_add     register_value \n ");
		printf("\n address delay * 1/32UIx100==%d ps bit0-4 fine tune  --step==1/32UI ,bit 6 is coarse  --step==1UI",ui_1_32_100step);
		for(t_count=0;t_count<10;t_count++)
		{
			add_offset=((0<<20)|(0<<16)|(t_count<<12)|(0x80));
			dq_bit_delay[t_count]=dwc_ddrphy_apb_rd(add_offset);
			delay_org=dq_bit_delay[t_count];
			delay_temp=(32*(((delay_org>>6)&0xf)+((delay_org>>5)&1))+(delay_org&0x1f));
			ddr_set_t_p->ac_trace_delay[t_count]=delay_temp;
			printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
		}
	}
	{
		printf("\n tdqs delay * 1/32UIx100==%d ps bit0-4 fine tune --step==1/32UI ,bit 6-9 is coarse  --step==1UI",ui_1_32_100step);
		for(t_count=0;t_count<16;t_count++)
		{
			add_offset=((0<<20)|(1<<16)|(((t_count%8)>>1)<<12)|(0xd0+(t_count/8)+((t_count%2)<<8)));
			dq_bit_delay[t_count]=dwc_ddrphy_apb_rd(add_offset);
			delay_org=dq_bit_delay[t_count];
			delay_temp=(32*(((delay_org>>6)&0xf)+((delay_org>>5)&1))+(delay_org&0x1f));
			
			ddr_set_t_p->write_dqs_delay[t_count]=delay_temp;
			
			printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
		}
	}
	{
		printf("\n rxdqs delay * 1/32UIx100==%d ps bit0-4 fine tune --step==1/32UI,no coarse",ui_1_32_100step);
		for(t_count=0;t_count<16;t_count++)
		{
			add_offset=((0<<20)|(1<<16)|(((t_count%8)>>1)<<12)|(0x8c+(t_count/8)+((t_count%2)<<8)));
			dq_bit_delay[t_count]=dwc_ddrphy_apb_rd(add_offset);
			delay_org=dq_bit_delay[t_count];
			delay_temp=(32*(((delay_org>>6)&0xf)+((delay_org>>5)&1))+(delay_org&0x1f));
			ddr_set_t_p->read_dqs_delay[t_count]=delay_temp;
			printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
		}
	}
	{
		printf("\n write dq_bit delay * 1/32UIx100==%d ps bit0-4 fine tune --step==1/32UI ,bit 6-8 is coarse  --step==1U",ui_1_32_100step);
			for(t_count=0;t_count<72;t_count++)
			{
				add_offset=((0<<20)|(1<<16)|(((t_count%36)/9)<<12)|(0xc0+((t_count%9)<<8)+(t_count/36)));
				dq_bit_delay[t_count]=dwc_ddrphy_apb_rd(add_offset);
				delay_org=dq_bit_delay[t_count];
				delay_temp=(32*(((delay_org>>6)&0xf)+((delay_org>>5)&1))+(delay_org&0x1f));

				ddr_set_t_p->write_dq_bit_delay[t_count]=delay_temp;
				printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
			}
	}
	{
		printf("\n read dq_bit delay * BDLRx100==%d ps bit0-4 fine tune --step==bdlr step size about 5ps,no coarse",bdlr_100step);
		for(t_count=0;t_count<72;t_count++)
		{
			add_offset=((0<<20)|(1<<16)|(((t_count%36)/9)<<12)|(0x68+((t_count%9)<<8)+(t_count/36)));
			dq_bit_delay[t_count]=dwc_ddrphy_apb_rd(add_offset);
			delay_org=dq_bit_delay[t_count];
			delay_temp=((delay_org&0x3f));
			
			ddr_set_t_p->read_dq_bit_delay[t_count]=delay_temp;
			printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
		}
	}
	{
		printf("\n read dqs gate delay * 1/32UIx100==%d ps bit0-4 fine tune ,bit 6-10 is coarse",ui_1_32_100step);
		for(t_count=0;t_count<16;t_count++)
		{
			add_offset=((0<<20)|(1<<16)|(((t_count%8)>>1)<<12)|(0x80+(t_count/8)+((t_count%2)<<8)));
			dq_bit_delay[t_count]=dwc_ddrphy_apb_rd(add_offset);
			delay_org=dq_bit_delay[t_count];
			delay_temp=(32*(((delay_org>>6)&0xf)+((delay_org>>5)&1))+(delay_org&0x1f));

			ddr_set_t_p->read_dqs_gate_delay[t_count]=delay_temp;
			printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
		}

		printf("\n soc vref : lpddr4-- VREF = VDDQ*(0.047 + VrefDAC0[6:0]*0.00367   DDR4 --VREF = VDDQ*(0.510 + VrefDAC0[6:0]*0.00345");
		//((0<<20)|(1<<16)|(((over_ride_sub_index%36)/9)<<12)|(((over_ride_sub_index%36)%9)<<8)|(0x40),over_ride_value)	
		uint32_t vref_t_count=0;
		for(t_count=0;t_count<72;t_count++)
		{
			add_offset=((0<<20)|(1<<16)|(((t_count%36)/9)<<12)|(((t_count%36)%9)<<8)|(0x40));
			dq_bit_delay[t_count]=dwc_ddrphy_apb_rd(add_offset);
			delay_org=dq_bit_delay[t_count];
			delay_temp=((delay_org));
			if(t_count<35)
			{
				vref_t_count=((((t_count%36)/9)*8)+(t_count%9));
				ddr_set_t_p->soc_bit_vref[vref_t_count]=delay_temp;
			}
			printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
		}
		printf("\n dram vref : lpddr4-- VREF = VDDQ*(0. + VrefDAC0[6:0]*0.   DDR4 --VREF = VDDQ*(0. + VrefDAC0[6:0]*0.");
		add_offset=((0<<20)|(1<<16)|(0<<12)|(0x082));
		delay_temp=dwc_ddrphy_apb_rd(add_offset);
		for(t_count=0;t_count<32;t_count++)
		{
			ddr_set_t_p->dram_bit_vref[t_count]=delay_temp;

			//	printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
		}
		printf("\n t_count: %04d %04d  %08x %08x",0,delay_temp,((((add_offset) << 1)+0xfe000000)),delay_temp);
	}

	//	if(over_ride_index ==DMC_TEST_WINDOW_INDEX_RETRAINING)
	{	//	if (read_write==REGISTER_READ)
		for(t_count=0;t_count<4;t_count++)
			{//p_dev->p_ddrs->tdqs2dq=lpddr4_tdqs2dq;
				//ddr_set_t_p->retraining[0]=dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(0<<12)|(0xaa));  //PptCtlStatic
				//ddr_set_t_p->retraining[1]=dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(0<<12)|(0xae));  //PptDqsCntInvTrnTg0  ps0 rank0
				//ddr_set_t_p->retraining[2]=dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(0<<12)|(0xaf));  //PptDqsCntInvTrnTg0  ps0 rank1
				ddr_set_t_p->retraining[4*t_count+0]=(dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(t_count<<12)|(0xaa)))&0xff;  //PptCtlStatic
				ddr_set_t_p->retraining[4*t_count+1]=(dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(t_count<<12)|(0xaa)))>>8;  //PptCtlStatic
				ddr_set_t_p->retraining[4*t_count+2]=dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(t_count<<12)|(0xae));  //PptDqsCntInvTrnTg0  ps0 rank0 lane 0-3
				ddr_set_t_p->retraining[4*t_count+3]=dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(t_count<<12)|(0xaf));  //PptDqsCntInvTrnTg0  ps0 rank1 lane 0-3
			}
	}
}

{
		uint32_t  count=0;
		uint32_t  reg_add_offset=0;
		uint16_t  reg_value=0;
		//ddr_log_serial_puts("\npctl timming:\n",p_dev->ddr_gloabl_message.stick_ddr_log_level);
		#define DMC_DRAM_TDPD                              ((0x001d  << 2) + 0xff638400)
		#define DMC_DRAM_TMRD                              ((0x0000  << 2) + 0xff638400)
		#define G12_DMC_STICKY_0                               ((0x0000  << 2) + 0xff638800)

		printf("\n PCTL timming: 0x");

		for (count=0;count<(DMC_DRAM_TDPD-DMC_DRAM_TMRD);) {
			reg_add_offset=(DMC_DRAM_TMRD+(count));
			//ddr_log_serial_puts("\n",p_dev->ddr_gloabl_message.stick_ddr_log_level);
			//ddr_log_serial_put_hex(reg_add_offset,32,p_dev->ddr_gloabl_message.stick_ddr_log_level); 
			//ddr_log_serial_puts(": ",p_dev->ddr_gloabl_message.stick_ddr_log_level);
			//ddr_log_serial_put_hex(readl(reg_add_offset),32,p_dev->ddr_gloabl_message.stick_ddr_log_level);   
			printf("\n reg_add_offset: %08x %08x %08x ",reg_add_offset,readl(reg_add_offset),reg_add_offset);
			count=count+4;
		}
		//ddr_log_serial_puts("\nmrs register: base (0x54000<<1)+fe000000,byte offset\n",p_dev->ddr_gloabl_message.stick_ddr_log_level);
		printf("\n mrs register: ");
		printf("\n mrs register: base (0x54000<<1)+fe000000,%08x  byte offset\n",(0x54000<<1)+0xfe000000);
		for (count=0;count<0x80;) {
			reg_add_offset=0x54000+count;//dwc_ddrphy_apb_wr(0x54008,0x1001);
			//ddr_log_serial_puts("\n",p_dev->ddr_gloabl_message.stick_ddr_log_level);
			//ddr_log_serial_put_hex(count,32,p_dev->ddr_gloabl_message.stick_ddr_log_level); 
			//ddr_log_serial_puts(": ",p_dev->ddr_gloabl_message.stick_ddr_log_level);
			reg_value= ((*(volatile uint16_t *)((uint64_t)(((0x54000+(count>>1))) << 1)+0xfe000000))>>(((count)%2)?8:0));//dwc_ddrphy_apb_rd(0x54000+add_offset+1);
			reg_value=reg_value&0xff;
			//ddr_log_serial_put_hex(reg_value,32,p_dev->ddr_gloabl_message.stick_ddr_log_level);   
			printf("\n reg_add_offset: %08x %08x %08x",reg_add_offset,reg_value,((((0x54000+(count>>1))) << 1)+0xfe000000));
			count=count+1;
		}
		//ddr_log_serial_puts("\ntimming.c:\n",p_dev->ddr_gloabl_message.stick_ddr_log_level);


		printf("\n sticky register: ");
		{
			uint32_t loop_max = 0;
			loop_max=64<<2;//sizeof(ddr_set_t);
			//uint32_t loop = 0;
			for (count = 0; count < loop_max; count+=4) {
				//	ddr_log_serial_puts("\n",p_dev->ddr_gloabl_message.stick_ddr_log_level);
				//	ddr_log_serial_put_hex(count,32,p_dev->ddr_gloabl_message.stick_ddr_log_level); 
				//	ddr_log_serial_puts(": ",p_dev->ddr_gloabl_message.stick_ddr_log_level);
				//	ddr_log_serial_put_hex(rd_reg((uint64_t)(p_dev->p_ddrs) + count),32,p_dev->ddr_gloabl_message.stick_ddr_log_level);   
				//	count=count+4;
				printf("\n reg_add_offset: %08x %08x %08x",count,rd_reg((uint64_t)(G12_DMC_STICKY_0) + count),((G12_DMC_STICKY_0) + count));
			}
		}

		{
			uint32_t loop_max = 0;
			loop_max=sizeof(ddr_set_t);
			uint32_t count = 0;
			for (count = 0; count < loop_max; ) {
				//	ddr_log_serial_puts("\n",p_dev->ddr_gloabl_message.stick_ddr_log_level);
				//	ddr_log_serial_put_hex(count,32,p_dev->ddr_gloabl_message.stick_ddr_log_level); 
				//	ddr_log_serial_puts(": ",p_dev->ddr_gloabl_message.stick_ddr_log_level);
				//	ddr_log_serial_put_hex(rd_reg((uint64_t)(p_dev->p_ddrs) + count),32,p_dev->ddr_gloabl_message.stick_ddr_log_level);   
				printf("\n%08x %08x",count,rd_reg((uint64_t)(ddr_set_t_p) + count));
				count=count+4;
				//printf("\n reg_add_offset: %08x %08x %08x",count,rd_reg((uint64_t)(G12_DMC_STICKY_0) + count),((G12_DMC_STICKY_0) + count));
			}
		}
		//	ddr_log_serial_puts("\n",p_dev->ddr_gloabl_message.stick_ddr_log_level);
}

	printf("\n ");


	//ddr_set_t *ddr_set_t_p;
	//ddr_set_t_p= (ddr_set_t *)G12_DMC_STICKY_0;
	//{
	//ddr_set_t_p->ddr_func;
	//system reserve,do not modify
	/* align8 */

	//unsigned	long	rsv_long0[2];
	/* v1 end */
	//	/*

	//	ddr_set_t_p->read_dqs_delay[16];
	//	ddr_set_t_p->read_dq_bit_delay[72];
	//	ddr_set_t_p->write_dqs_delay[16];
	//	*/
	//	ddr_set_t_p->write_dq_bit_delay[72];
	//	ddr_set_t_p->read_dqs_gate_delay[16];
	//	ddr_set_t_p->soc_bit_vref[32];
	//	ddr_set_t_p->dram_bit_vref[32];
	///*
	//	ddr_set_t_p->dq_dqs_delay_flag;//read_dqs  read_dq,write_dqs, write_dq
	//	ddr_set_t_p->dfi_mrl;
	//	ddr_set_t_p->dfi_hwtmrl;
	//	ddr_set_t_p->ARdPtrInitVal;
	//}
	uint32_t temp_count=0;
	{
		printf("\n.magic=0x%08x,// %d",ddr_set_t_p->magic,ddr_set_t_p->magic);
		for( temp_count=0;temp_count<4;temp_count++)
			printf("\n.fast_boot[%d]=0x%08x,// %d",temp_count,ddr_set_t_p->fast_boot[temp_count],ddr_set_t_p->fast_boot[temp_count]);
		//printf("\n.rsv_int0=0x%08x,// %d",ddr_set_t_p->rsv_int0,ddr_set_t_p->rsv_int0);
		printf("\n.board_id=0x%08x,// %d",ddr_set_t_p->board_id,ddr_set_t_p->board_id);
		printf("\n.version=0x%08x,// %d",ddr_set_t_p->version,ddr_set_t_p->version);
		printf("\n.DramType=0x%08x,// %d",ddr_set_t_p->DramType,ddr_set_t_p->DramType);
		printf("\n.DisabledDbyte=0x%08x,// %d",ddr_set_t_p->DisabledDbyte,ddr_set_t_p->DisabledDbyte);
		printf("\n.Is2Ttiming=0x%08x,// %d",ddr_set_t_p->Is2Ttiming,ddr_set_t_p->Is2Ttiming);
		printf("\n.HdtCtrl=0x%08x,// %d",ddr_set_t_p->HdtCtrl,ddr_set_t_p->HdtCtrl);
		printf("\n.dram_rank_config=0x%08x,// %d",ddr_set_t_p->dram_rank_config,ddr_set_t_p->dram_rank_config);
		printf("\n.diagnose=0x%08x,// %d",ddr_set_t_p->diagnose,ddr_set_t_p->diagnose);
		printf("\n.imem_load_addr=0x%08x,// %d",ddr_set_t_p->imem_load_addr,ddr_set_t_p->imem_load_addr);
		printf("\n.dmem_load_addr=0x%08x,// %d",ddr_set_t_p->dmem_load_addr,ddr_set_t_p->dmem_load_addr);
		printf("\n.imem_load_size=0x%08x,// %d",ddr_set_t_p->imem_load_size,ddr_set_t_p->imem_load_size);
		printf("\n.dmem_load_size=0x%08x,// %d",ddr_set_t_p->dmem_load_size,ddr_set_t_p->dmem_load_size);
		printf("\n.ddr_base_addr=0x%08x,// %d",ddr_set_t_p->ddr_base_addr,ddr_set_t_p->ddr_base_addr);
		printf("\n.ddr_start_offset=0x%08x,// %d",ddr_set_t_p->ddr_start_offset,ddr_set_t_p->ddr_start_offset);
		printf("\n.dram_cs0_size_MB=0x%08x,// %d",ddr_set_t_p->dram_cs0_size_MB,ddr_set_t_p->dram_cs0_size_MB);
		printf("\n.dram_cs1_size_MB=0x%08x,// %d",ddr_set_t_p->dram_cs1_size_MB,ddr_set_t_p->dram_cs1_size_MB);
		printf("\n.training_SequenceCtrl[0]=0x%08x,// %d",ddr_set_t_p->training_SequenceCtrl[0],ddr_set_t_p->training_SequenceCtrl[0]);
		printf("\n.training_SequenceCtrl[1]=0x%08x,// %d",ddr_set_t_p->training_SequenceCtrl[1],ddr_set_t_p->training_SequenceCtrl[1]);
		printf("\n.phy_odt_config_rank[0]=0x%08x,// %d",ddr_set_t_p->phy_odt_config_rank[0],ddr_set_t_p->phy_odt_config_rank[0]);
		printf("\n.phy_odt_config_rank[1]=0x%08x,// %d",ddr_set_t_p->phy_odt_config_rank[1],ddr_set_t_p->phy_odt_config_rank[1]);
		printf("\n.rever1=0x%08x,// %d",ddr_set_t_p->rever1,ddr_set_t_p->rever1);
		printf("\n.rever2=0x%08x,// %d",ddr_set_t_p->rever2,ddr_set_t_p->rever2);
		//	unsigned	char	phy_odt_config_rank[2];
		//	unsigned	char	 ddr_fast_boot_function;
		//	unsigned	char	 dqs_offset_value;
		printf("\n.dfi_odt_config=0x%08x,// %d",ddr_set_t_p->dfi_odt_config,ddr_set_t_p->dfi_odt_config);
		printf("\n.DRAMFreq[0]=0x%08x,// %d",ddr_set_t_p->DRAMFreq[0],ddr_set_t_p->DRAMFreq[0]);
		printf("\n.DRAMFreq[1]=0x%08x,// %d",ddr_set_t_p->DRAMFreq[1],ddr_set_t_p->DRAMFreq[1]);
		printf("\n.DRAMFreq[2]=0x%08x,// %d",ddr_set_t_p->DRAMFreq[2],ddr_set_t_p->DRAMFreq[2]);
		printf("\n.DRAMFreq[3]=0x%08x,// %d",ddr_set_t_p->DRAMFreq[3],ddr_set_t_p->DRAMFreq[3]);
		printf("\n.PllBypassEn=0x%08x,// %d",ddr_set_t_p->PllBypassEn,ddr_set_t_p->PllBypassEn);
		printf("\n.ddr_rdbi_wr_enable=0x%08x,// %d",ddr_set_t_p->ddr_rdbi_wr_enable,ddr_set_t_p->ddr_rdbi_wr_enable);
		printf("\n.ddr_rfc_type=0x%08x,// %d",ddr_set_t_p->ddr_rfc_type,ddr_set_t_p->ddr_rfc_type);
		printf("\n.enable_lpddr4x_mode=0x%08x,// %d",ddr_set_t_p->enable_lpddr4x_mode,ddr_set_t_p->enable_lpddr4x_mode);
		printf("\n.pll_ssc_mode=0x%08x,// %d",ddr_set_t_p->pll_ssc_mode,ddr_set_t_p->pll_ssc_mode);
		printf("\n.clk_drv_ohm=0x%08x,// %d",ddr_set_t_p->clk_drv_ohm,ddr_set_t_p->clk_drv_ohm);
		printf("\n.cs_drv_ohm=0x%08x,// %d",ddr_set_t_p->cs_drv_ohm,ddr_set_t_p->cs_drv_ohm);
		printf("\n.ac_drv_ohm=0x%08x,// %d",ddr_set_t_p->ac_drv_ohm,ddr_set_t_p->ac_drv_ohm);
		printf("\n.soc_data_drv_ohm_p=0x%08x,// %d",ddr_set_t_p->soc_data_drv_ohm_p,ddr_set_t_p->soc_data_drv_ohm_p);
		printf("\n.soc_data_drv_ohm_n=0x%08x,// %d",ddr_set_t_p->soc_data_drv_ohm_n,ddr_set_t_p->soc_data_drv_ohm_n);
		printf("\n.soc_data_odt_ohm_p=0x%08x,// %d",ddr_set_t_p->soc_data_odt_ohm_p,ddr_set_t_p->soc_data_odt_ohm_p);
		printf("\n.soc_data_odt_ohm_n=0x%08x,// %d",ddr_set_t_p->soc_data_odt_ohm_n,ddr_set_t_p->soc_data_odt_ohm_n);
		printf("\n.dram_data_drv_ohm=0x%08x,// %d",ddr_set_t_p->dram_data_drv_ohm,ddr_set_t_p->dram_data_drv_ohm);
		printf("\n.dram_data_odt_ohm=0x%08x,// %d",ddr_set_t_p->dram_data_odt_ohm,ddr_set_t_p->dram_data_odt_ohm);
		printf("\n.dram_ac_odt_ohm=0x%08x,// %d",ddr_set_t_p->dram_ac_odt_ohm,ddr_set_t_p->dram_ac_odt_ohm);
		printf("\n.soc_clk_slew_rate=0x%08x,// %d",ddr_set_t_p->soc_clk_slew_rate,ddr_set_t_p->soc_clk_slew_rate);
		printf("\n.soc_cs_slew_rate=0x%08x,// %d",ddr_set_t_p->soc_cs_slew_rate,ddr_set_t_p->soc_cs_slew_rate);
		printf("\n.soc_ac_slew_rate=0x%08x,// %d",ddr_set_t_p->soc_ac_slew_rate,ddr_set_t_p->soc_ac_slew_rate);
		printf("\n.soc_data_slew_rate=0x%08x,// %d",ddr_set_t_p->soc_data_slew_rate,ddr_set_t_p->soc_data_slew_rate);
		printf("\n.vref_output_permil =0x%08x,// %d",ddr_set_t_p->vref_output_permil ,ddr_set_t_p->vref_output_permil );
		printf("\n.vref_receiver_permil =0x%08x,// %d",ddr_set_t_p->vref_receiver_permil ,ddr_set_t_p->vref_receiver_permil );
		printf("\n.vref_dram_permil=0x%08x,// %d",ddr_set_t_p->vref_dram_permil,ddr_set_t_p->vref_dram_permil);
		printf("\n.max_core_timmming_frequency=0x%08x,// %d",ddr_set_t_p->max_core_timmming_frequency,ddr_set_t_p->max_core_timmming_frequency);
		printf("\n.ac_trace_delay[0]=0x%08x,// %d",ddr_set_t_p->ac_trace_delay[0],ddr_set_t_p->ac_trace_delay[0]);
		printf("\n.ac_trace_delay[1]=0x%08x,// %d",ddr_set_t_p->ac_trace_delay[1],ddr_set_t_p->ac_trace_delay[1]);
		printf("\n.ac_trace_delay[2]=0x%08x,// %d",ddr_set_t_p->ac_trace_delay[2],ddr_set_t_p->ac_trace_delay[2]);
		printf("\n.ac_trace_delay[3]=0x%08x,// %d",ddr_set_t_p->ac_trace_delay[3],ddr_set_t_p->ac_trace_delay[3]);
		printf("\n.ac_trace_delay[4]=0x%08x,// %d",ddr_set_t_p->ac_trace_delay[4],ddr_set_t_p->ac_trace_delay[4]);
		printf("\n.ac_trace_delay[5]=0x%08x,// %d",ddr_set_t_p->ac_trace_delay[5],ddr_set_t_p->ac_trace_delay[5]);
		printf("\n.ac_trace_delay[6]=0x%08x,// %d",ddr_set_t_p->ac_trace_delay[6],ddr_set_t_p->ac_trace_delay[6]);
		printf("\n.ac_trace_delay[7]=0x%08x,// %d",ddr_set_t_p->ac_trace_delay[7],ddr_set_t_p->ac_trace_delay[7]);
		printf("\n.ac_trace_delay[8]=0x%08x,// %d",ddr_set_t_p->ac_trace_delay[8],ddr_set_t_p->ac_trace_delay[8]);
		printf("\n.ac_trace_delay[9]=0x%08x,// %d",ddr_set_t_p->ac_trace_delay[9],ddr_set_t_p->ac_trace_delay[9]);
		printf("\n.lpddr4_dram_vout_voltage_1_3_2_5_setting=0x%08x,// %d",ddr_set_t_p->lpddr4_dram_vout_voltage_1_3_2_5_setting,ddr_set_t_p->lpddr4_dram_vout_voltage_1_3_2_5_setting);
		printf("\n.lpddr4_x8_mode=0x%08x,// %d",ddr_set_t_p->lpddr4_x8_mode,ddr_set_t_p->lpddr4_x8_mode);
		printf("\n.ac_pinmux[0]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[0],ddr_set_t_p->ac_pinmux[0]);
		printf("\n.ac_pinmux[1]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[1],ddr_set_t_p->ac_pinmux[1]);
		printf("\n.ac_pinmux[2]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[2],ddr_set_t_p->ac_pinmux[2]);
		printf("\n.ac_pinmux[3]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[3],ddr_set_t_p->ac_pinmux[3]);
		printf("\n.ac_pinmux[4]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[4],ddr_set_t_p->ac_pinmux[4]);
		printf("\n.ac_pinmux[5]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[5],ddr_set_t_p->ac_pinmux[5]);
		printf("\n.ac_pinmux[6]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[6],ddr_set_t_p->ac_pinmux[6]);
		printf("\n.ac_pinmux[7]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[7],ddr_set_t_p->ac_pinmux[7]);
		printf("\n.ac_pinmux[8]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[8],ddr_set_t_p->ac_pinmux[8]);
		printf("\n.ac_pinmux[9]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[9],ddr_set_t_p->ac_pinmux[9]);
		printf("\n.ac_pinmux[10]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[10],ddr_set_t_p->ac_pinmux[10]);
		printf("\n.ac_pinmux[11]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[11],ddr_set_t_p->ac_pinmux[11]);
		printf("\n.ac_pinmux[12]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[12],ddr_set_t_p->ac_pinmux[12]);
		printf("\n.ac_pinmux[13]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[13],ddr_set_t_p->ac_pinmux[13]);
		printf("\n.ac_pinmux[14]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[14],ddr_set_t_p->ac_pinmux[14]);
		printf("\n.ac_pinmux[15]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[15],ddr_set_t_p->ac_pinmux[15]);
		printf("\n.ac_pinmux[16]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[16],ddr_set_t_p->ac_pinmux[16]);
		printf("\n.ac_pinmux[17]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[17],ddr_set_t_p->ac_pinmux[17]);
		printf("\n.ac_pinmux[18]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[18],ddr_set_t_p->ac_pinmux[18]);
		printf("\n.ac_pinmux[19]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[19],ddr_set_t_p->ac_pinmux[19]);
		printf("\n.ac_pinmux[20]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[20],ddr_set_t_p->ac_pinmux[20]);
		printf("\n.ac_pinmux[21]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[21],ddr_set_t_p->ac_pinmux[21]);
		printf("\n.ac_pinmux[22]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[22],ddr_set_t_p->ac_pinmux[22]);
		printf("\n.ac_pinmux[23]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[23],ddr_set_t_p->ac_pinmux[23]);
		printf("\n.ac_pinmux[24]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[24],ddr_set_t_p->ac_pinmux[24]);
		printf("\n.ac_pinmux[25]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[25],ddr_set_t_p->ac_pinmux[25]);
		printf("\n.ac_pinmux[26]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[26],ddr_set_t_p->ac_pinmux[26]);
		printf("\n.ac_pinmux[27]=0x%08x,// %d",ddr_set_t_p->ac_pinmux[27],ddr_set_t_p->ac_pinmux[27]);
		printf("\n.dfi_pinmux[0]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[0],ddr_set_t_p->dfi_pinmux[0]);
		printf("\n.dfi_pinmux[1]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[1],ddr_set_t_p->dfi_pinmux[1]);
		printf("\n.dfi_pinmux[2]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[2],ddr_set_t_p->dfi_pinmux[2]);
		printf("\n.dfi_pinmux[3]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[3],ddr_set_t_p->dfi_pinmux[3]);
		printf("\n.dfi_pinmux[4]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[4],ddr_set_t_p->dfi_pinmux[4]);
		printf("\n.dfi_pinmux[5]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[5],ddr_set_t_p->dfi_pinmux[5]);
		printf("\n.dfi_pinmux[6]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[6],ddr_set_t_p->dfi_pinmux[6]);
		printf("\n.dfi_pinmux[7]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[7],ddr_set_t_p->dfi_pinmux[7]);
		printf("\n.dfi_pinmux[8]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[8],ddr_set_t_p->dfi_pinmux[8]);
		printf("\n.dfi_pinmux[9]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[9],ddr_set_t_p->dfi_pinmux[9]);
		printf("\n.dfi_pinmux[10]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[10],ddr_set_t_p->dfi_pinmux[10]);
		printf("\n.dfi_pinmux[11]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[11],ddr_set_t_p->dfi_pinmux[11]);
		printf("\n.dfi_pinmux[12]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[12],ddr_set_t_p->dfi_pinmux[12]);
		printf("\n.dfi_pinmux[13]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[13],ddr_set_t_p->dfi_pinmux[13]);
		printf("\n.dfi_pinmux[14]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[14],ddr_set_t_p->dfi_pinmux[14]);
		printf("\n.dfi_pinmux[15]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[15],ddr_set_t_p->dfi_pinmux[15]);
		printf("\n.dfi_pinmux[16]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[16],ddr_set_t_p->dfi_pinmux[16]);
		printf("\n.dfi_pinmux[17]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[17],ddr_set_t_p->dfi_pinmux[17]);
		printf("\n.dfi_pinmux[18]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[18],ddr_set_t_p->dfi_pinmux[18]);
		printf("\n.dfi_pinmux[19]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[19],ddr_set_t_p->dfi_pinmux[19]);
		printf("\n.dfi_pinmux[20]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[20],ddr_set_t_p->dfi_pinmux[20]);
		printf("\n.dfi_pinmux[21]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[21],ddr_set_t_p->dfi_pinmux[21]);
		printf("\n.dfi_pinmux[22]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[22],ddr_set_t_p->dfi_pinmux[22]);
		printf("\n.dfi_pinmux[23]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[23],ddr_set_t_p->dfi_pinmux[23]);
		printf("\n.dfi_pinmux[24]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[24],ddr_set_t_p->dfi_pinmux[24]);
		printf("\n.dfi_pinmux[25]=0x%08x,// %d",ddr_set_t_p->dfi_pinmux[25],ddr_set_t_p->dfi_pinmux[25]);
		printf("\n.slt_test_function[0]  =0x%08x,// %d",ddr_set_t_p->slt_test_function[0]  ,ddr_set_t_p->slt_test_function[0]  );
		printf("\n.slt_test_function[1]  =0x%08x,// %d",ddr_set_t_p->slt_test_function[1]  ,ddr_set_t_p->slt_test_function[1]  );
		printf("\n.tdqs2dq=0x%08x,// %d",ddr_set_t_p->tdqs2dq,ddr_set_t_p->tdqs2dq);
		printf("\n.dram_data_wr_odt_ohm=0x%08x,// %d",ddr_set_t_p->dram_data_wr_odt_ohm,ddr_set_t_p->dram_data_wr_odt_ohm);
		printf("\n.bitTimeControl_2d=0x%08x,// %d",ddr_set_t_p->bitTimeControl_2d,ddr_set_t_p->bitTimeControl_2d);
		printf("\n.ddr_dmc_remap[0]=0x%08x,// %d",ddr_set_t_p->ddr_dmc_remap[0],ddr_set_t_p->ddr_dmc_remap[0]);
		printf("\n.ddr_dmc_remap[1]=0x%08x,// %d",ddr_set_t_p->ddr_dmc_remap[1],ddr_set_t_p->ddr_dmc_remap[1]);
		printf("\n.ddr_dmc_remap[2]=0x%08x,// %d",ddr_set_t_p->ddr_dmc_remap[2],ddr_set_t_p->ddr_dmc_remap[2]);
		printf("\n.ddr_dmc_remap[3]=0x%08x,// %d",ddr_set_t_p->ddr_dmc_remap[3],ddr_set_t_p->ddr_dmc_remap[3]);
		printf("\n.ddr_dmc_remap[4]=0x%08x,// %d",ddr_set_t_p->ddr_dmc_remap[4],ddr_set_t_p->ddr_dmc_remap[4]);
		printf("\n.ddr_lpddr34_ca_remap[0]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_ca_remap[0],ddr_set_t_p->ddr_lpddr34_ca_remap[0]);
		printf("\n.ddr_lpddr34_ca_remap[1]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_ca_remap[1],ddr_set_t_p->ddr_lpddr34_ca_remap[1]);
		printf("\n.ddr_lpddr34_ca_remap[2]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_ca_remap[2],ddr_set_t_p->ddr_lpddr34_ca_remap[2]);
		printf("\n.ddr_lpddr34_ca_remap[3]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_ca_remap[3],ddr_set_t_p->ddr_lpddr34_ca_remap[3]);
		printf("\n.ddr_lpddr34_dq_remap[0]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[0],ddr_set_t_p->ddr_lpddr34_dq_remap[0]);
		printf("\n.ddr_lpddr34_dq_remap[1]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[1],ddr_set_t_p->ddr_lpddr34_dq_remap[1]);
		printf("\n.ddr_lpddr34_dq_remap[2]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[2],ddr_set_t_p->ddr_lpddr34_dq_remap[2]);
		printf("\n.ddr_lpddr34_dq_remap[3]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[3],ddr_set_t_p->ddr_lpddr34_dq_remap[3]);
		printf("\n.ddr_lpddr34_dq_remap[4]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[4],ddr_set_t_p->ddr_lpddr34_dq_remap[4]);
		printf("\n.ddr_lpddr34_dq_remap[5]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[5],ddr_set_t_p->ddr_lpddr34_dq_remap[5]);
		printf("\n.ddr_lpddr34_dq_remap[6]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[6],ddr_set_t_p->ddr_lpddr34_dq_remap[6]);
		printf("\n.ddr_lpddr34_dq_remap[7]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[7],ddr_set_t_p->ddr_lpddr34_dq_remap[7]);
		printf("\n.ddr_lpddr34_dq_remap[8]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[8],ddr_set_t_p->ddr_lpddr34_dq_remap[8]);
		printf("\n.ddr_lpddr34_dq_remap[9]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[9],ddr_set_t_p->ddr_lpddr34_dq_remap[9]);
		printf("\n.ddr_lpddr34_dq_remap[10]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[10],ddr_set_t_p->ddr_lpddr34_dq_remap[10]);
		printf("\n.ddr_lpddr34_dq_remap[11]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[11],ddr_set_t_p->ddr_lpddr34_dq_remap[11]);
		printf("\n.ddr_lpddr34_dq_remap[12]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[12],ddr_set_t_p->ddr_lpddr34_dq_remap[12]);
		printf("\n.ddr_lpddr34_dq_remap[13]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[13],ddr_set_t_p->ddr_lpddr34_dq_remap[13]);
		printf("\n.ddr_lpddr34_dq_remap[14]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[14],ddr_set_t_p->ddr_lpddr34_dq_remap[14]);
		printf("\n.ddr_lpddr34_dq_remap[15]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[15],ddr_set_t_p->ddr_lpddr34_dq_remap[15]);
		printf("\n.ddr_lpddr34_dq_remap[16]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[16],ddr_set_t_p->ddr_lpddr34_dq_remap[16]);
		printf("\n.ddr_lpddr34_dq_remap[17]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[17],ddr_set_t_p->ddr_lpddr34_dq_remap[17]);
		printf("\n.ddr_lpddr34_dq_remap[18]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[18],ddr_set_t_p->ddr_lpddr34_dq_remap[18]);
		printf("\n.ddr_lpddr34_dq_remap[19]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[19],ddr_set_t_p->ddr_lpddr34_dq_remap[19]);
		printf("\n.ddr_lpddr34_dq_remap[20]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[20],ddr_set_t_p->ddr_lpddr34_dq_remap[20]);
		printf("\n.ddr_lpddr34_dq_remap[21]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[21],ddr_set_t_p->ddr_lpddr34_dq_remap[21]);
		printf("\n.ddr_lpddr34_dq_remap[22]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[22],ddr_set_t_p->ddr_lpddr34_dq_remap[22]);
		printf("\n.ddr_lpddr34_dq_remap[23]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[23],ddr_set_t_p->ddr_lpddr34_dq_remap[23]);
		printf("\n.ddr_lpddr34_dq_remap[24]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[24],ddr_set_t_p->ddr_lpddr34_dq_remap[24]);
		printf("\n.ddr_lpddr34_dq_remap[25]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[25],ddr_set_t_p->ddr_lpddr34_dq_remap[25]);
		printf("\n.ddr_lpddr34_dq_remap[26]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[26],ddr_set_t_p->ddr_lpddr34_dq_remap[26]);
		printf("\n.ddr_lpddr34_dq_remap[27]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[27],ddr_set_t_p->ddr_lpddr34_dq_remap[27]);
		printf("\n.ddr_lpddr34_dq_remap[28]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[28],ddr_set_t_p->ddr_lpddr34_dq_remap[28]);
		printf("\n.ddr_lpddr34_dq_remap[29]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[29],ddr_set_t_p->ddr_lpddr34_dq_remap[29]);
		printf("\n.ddr_lpddr34_dq_remap[30]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[30],ddr_set_t_p->ddr_lpddr34_dq_remap[30]);
		printf("\n.ddr_lpddr34_dq_remap[31]=0x%08x,// %d",ddr_set_t_p->ddr_lpddr34_dq_remap[31],ddr_set_t_p->ddr_lpddr34_dq_remap[31]);
		printf("\n.dram_rtt_nom_wr_park[0]=0x%08x,// %d",ddr_set_t_p->dram_rtt_nom_wr_park[0],ddr_set_t_p->dram_rtt_nom_wr_park[0]);
		printf("\n.dram_rtt_nom_wr_park[1]=0x%08x,// %d",ddr_set_t_p->dram_rtt_nom_wr_park[1],ddr_set_t_p->dram_rtt_nom_wr_park[1]);
		printf("\n.ddr_func=0x%08x,// %d",ddr_set_t_p->ddr_func,ddr_set_t_p->ddr_func);

		/*
		printf("\n.read_dqs_delay[0]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[0],ddr_set_t_p->read_dqs_delay[0]);
		printf("\n.read_dqs_delay[1]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[1],ddr_set_t_p->read_dqs_delay[1]);
		printf("\n.read_dqs_delay[2]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[2],ddr_set_t_p->read_dqs_delay[2]);
		printf("\n.read_dqs_delay[3]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[3],ddr_set_t_p->read_dqs_delay[3]);
		printf("\n.read_dqs_delay[4]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[4],ddr_set_t_p->read_dqs_delay[4]);
		printf("\n.read_dqs_delay[5]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[5],ddr_set_t_p->read_dqs_delay[5]);
		printf("\n.read_dqs_delay[6]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[6],ddr_set_t_p->read_dqs_delay[6]);
		printf("\n.read_dqs_delay[7]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[7],ddr_set_t_p->read_dqs_delay[7]);
		printf("\n.read_dqs_delay[8]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[8],ddr_set_t_p->read_dqs_delay[8]);
		printf("\n.read_dqs_delay[9]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[9],ddr_set_t_p->read_dqs_delay[9]);
		printf("\n.read_dqs_delay[10]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[10],ddr_set_t_p->read_dqs_delay[10]);
		printf("\n.read_dqs_delay[11]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[11],ddr_set_t_p->read_dqs_delay[11]);
		printf("\n.read_dqs_delay[12]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[12],ddr_set_t_p->read_dqs_delay[12]);
		printf("\n.read_dqs_delay[13]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[13],ddr_set_t_p->read_dqs_delay[13]);
		printf("\n.read_dqs_delay[14]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[14],ddr_set_t_p->read_dqs_delay[14]);
		printf("\n.read_dqs_delay[15]=0x%08x,// %d",ddr_set_t_p->read_dqs_delay[15],ddr_set_t_p->read_dqs_delay[15]);
		printf("\n.read_dq_bit_delay[72]=0x%08x,// %d",ddr_set_t_p->read_dq_bit_delay[72],ddr_set_t_p->read_dq_bit_delay[72]);
		printf("\n.write_dqs_delay[16]=0x%08x,// %d",ddr_set_t_p->write_dqs_delay[16],ddr_set_t_p->write_dqs_delay[16]);
		printf("\n.write_dq_bit_delay[72]=0x%08x,// %d",ddr_set_t_p->write_dq_bit_delay[72],ddr_set_t_p->write_dq_bit_delay[72]);
		printf("\n.read_dqs_gate_delay[16]=0x%08x,// %d",ddr_set_t_p->read_dqs_gate_delay[16],ddr_set_t_p->read_dqs_gate_delay[16]);
		printf("\n.soc_bit_vref[32]=0x%08x,// %d",ddr_set_t_p->soc_bit_vref[32],ddr_set_t_p->soc_bit_vref[32]);
		printf("\n.dram_bit_vref[32]=0x%08x,// %d",ddr_set_t_p->dram_bit_vref[32],ddr_set_t_p->dram_bit_vref[32]);
		printf("\n.dq_dqs_delay_flag=0x%08x,// %d",ddr_set_t_p->dq_dqs_delay_flag,ddr_set_t_p->dq_dqs_delay_flag);
		printf("\n.dfi_mrl=0x%08x,// %d",ddr_set_t_p->dfi_mrl,ddr_set_t_p->dfi_mrl);
		printf("\n.dfi_hwtmrl=0x%08x,// %d",ddr_set_t_p->dfi_hwtmrl,ddr_set_t_p->dfi_hwtmrl);
		printf("\n.ARdPtrInitVal=0x%08x,// %d",ddr_set_t_p->ARdPtrInitVal,ddr_set_t_p->ARdPtrInitVal);
		*/

		//printf("\n.read_dq_bit_delay[72]=%d,",ddr_set_t_p->read_dq_bit_delay[72]);
		//printf("\n.write_dqs_delay[16]=%d,",ddr_set_t_p->write_dqs_delay[16]);
		//printf("\n.write_dq_bit_delay[72]=%d,",ddr_set_t_p->write_dq_bit_delay[72]);
		//printf("\n.read_dqs_gate_delay[16]=%d,",ddr_set_t_p->read_dqs_gate_delay[16]);
		//printf("\n.soc_bit_vref[32]=%d,",ddr_set_t_p->soc_bit_vref[32]);
		//printf("\n.dram_bit_vref[32]=%d,",ddr_set_t_p->dram_bit_vref[32]);
		//printf("\n.dq_dqs_delay_flag=%d,",ddr_set_t_p->dq_dqs_delay_flag);
		//printf("\n.dfi_mrl=%d,",ddr_set_t_p->dfi_mrl);
		//printf("\n.dfi_hwtmrl=%d,",ddr_set_t_p->dfi_hwtmrl);
		//printf("\n.ARdPtrInitVal=%d,",ddr_set_t_p->ARdPtrInitVal);

		for( temp_count=0;temp_count<16;temp_count++)
		printf("\n.read_dqs_delay[%d]=0x%08x,// %d",temp_count,ddr_set_t_p->read_dqs_delay[temp_count],ddr_set_t_p->read_dqs_delay[temp_count]);
		for( temp_count=0;temp_count<72;temp_count++)
		printf("\n.read_dq_bit_delay[%d]=0x%08x,// %d",temp_count,ddr_set_t_p->read_dq_bit_delay[temp_count],ddr_set_t_p->read_dq_bit_delay[temp_count]);
		for( temp_count=0;temp_count<16;temp_count++)
		//printf("\n.write_dqs_delay[%d]=%d,",temp_count,ddr_set_t_p->write_dqs_delay[temp_count]);
		printf("\n.write_dqs_delay[%d]=0x%08x,// %d",temp_count,ddr_set_t_p->write_dqs_delay[temp_count],ddr_set_t_p->write_dqs_delay[temp_count]);
		for( temp_count=0;temp_count<72;temp_count++)
		//printf("\n.write_dq_bit_delay[%d]=%d,",temp_count,ddr_set_t_p->write_dq_bit_delay[temp_count]);
		printf("\n.write_dq_bit_delay[%d]=0x%08x,// %d",temp_count,ddr_set_t_p->write_dq_bit_delay[temp_count],ddr_set_t_p->write_dq_bit_delay[temp_count]);
		for( temp_count=0;temp_count<16;temp_count++)
		//printf("\n.read_dqs_gate_delay[%d]=%d,",temp_count,ddr_set_t_p->read_dqs_gate_delay[temp_count]);
		printf("\n.read_dqs_gate_delay[%d]=0x%08x,// %d",temp_count,ddr_set_t_p->read_dqs_gate_delay[temp_count],ddr_set_t_p->read_dqs_gate_delay[temp_count]);
		for( temp_count=0;temp_count<32;temp_count++)
		//printf("\n.soc_bit_vref[%d]=%d,",temp_count,ddr_set_t_p->soc_bit_vref[temp_count]);
		printf("\n.soc_bit_vref[%d]=0x%08x,// %d",temp_count,ddr_set_t_p->soc_bit_vref[temp_count],ddr_set_t_p->soc_bit_vref[temp_count]);
		for( temp_count=0;temp_count<32;temp_count++)
		//printf("\n.dram_bit_vref[%d]=%d,",temp_count,ddr_set_t_p->dram_bit_vref[temp_count]);
		printf("\n.dram_bit_vref[%d]=0x%08x,// %d",temp_count,ddr_set_t_p->dram_bit_vref[temp_count],ddr_set_t_p->dram_bit_vref[temp_count]);

		//ddr_set_t_p->dq_dqs_delay_flag=0xff;
		printf("\n.rever3=0x%08x,// %d",ddr_set_t_p->rever3,ddr_set_t_p->rever3);
		printf("\n.dfi_mrl=0x%08x,// %d",ddr_set_t_p->dfi_mrl,ddr_set_t_p->dfi_mrl);
		printf("\n.dfi_hwtmrl=0x%08x,// %d",ddr_set_t_p->dfi_hwtmrl,ddr_set_t_p->dfi_hwtmrl);
		printf("\n.ARdPtrInitVal=0x%08x,// %d",ddr_set_t_p->ARdPtrInitVal,ddr_set_t_p->ARdPtrInitVal);

		for( temp_count=0;temp_count<16;temp_count++)
			//printf("\n.dram_bit_vref[%d]=%d,",temp_count,ddr_set_t_p->dram_bit_vref[temp_count]);
			printf("\n.retraining[%d]=0x%08x,// %d",temp_count,ddr_set_t_p->retraining[temp_count],ddr_set_t_p->retraining[temp_count]);

		printf("\n");
/*
		printf("\nddr_set_t_p->magic:%08x",ddr_set_t_p->magic);
		printf("\nddr_set_t_p->rsv_int0:%08x",ddr_set_t_p->rsv_int0);
		printf("\nddr_set_t_p->board_id:%08x",ddr_set_t_p->board_id);
		printf("\nddr_set_t_p->version:%08x",ddr_set_t_p->version);
		printf("\nddr_set_t_p->DramType:%08x",ddr_set_t_p->DramType);
		printf("\nddr_set_t_p->DisabledDbyte:%08x",ddr_set_t_p->DisabledDbyte);
		printf("\nddr_set_t_p->Is2Ttiming:%08x",ddr_set_t_p->Is2Ttiming);
		printf("\nddr_set_t_p->HdtCtrl:%08x",ddr_set_t_p->HdtCtrl);
		printf("\nddr_set_t_p->dram_rank_config:%08x",ddr_set_t_p->dram_rank_config);
		printf("\nddr_set_t_p->diagnose:%08x",ddr_set_t_p->diagnose);
		printf("\nddr_set_t_p->imem_load_addr:%08x",ddr_set_t_p->imem_load_addr);
		printf("\nddr_set_t_p->dmem_load_addr:%08x",ddr_set_t_p->dmem_load_addr);
		printf("\nddr_set_t_p->imem_load_size:%08x",ddr_set_t_p->imem_load_size);
		printf("\nddr_set_t_p->dmem_load_size:%08x",ddr_set_t_p->dmem_load_size);
		printf("\nddr_set_t_p->ddr_base_addr:%08x",ddr_set_t_p->ddr_base_addr);
		printf("\nddr_set_t_p->ddr_start_offset:%08x",ddr_set_t_p->ddr_start_offset);
		printf("\nddr_set_t_p->dram_cs0_size_MB:%08x",ddr_set_t_p->dram_cs0_size_MB);
		printf("\nddr_set_t_p->dram_cs1_size_MB:%08x",ddr_set_t_p->dram_cs1_size_MB);
		printf("\nddr_set_t_p->training_SequenceCtrl[0]:%08x",ddr_set_t_p->training_SequenceCtrl[0]);
		printf("\nddr_set_t_p->training_SequenceCtrl[1]:%08x",ddr_set_t_p->training_SequenceCtrl[1]);
		printf("\nddr_set_t_p->phy_odt_config_rank[0]:%08x",ddr_set_t_p->phy_odt_config_rank[0]);
		printf("\nddr_set_t_p->phy_odt_config_rank[1]:%08x",ddr_set_t_p->phy_odt_config_rank[1]);
		printf("\nddr_set_t_p->phy_odt_config_rank[2]:%08x",ddr_set_t_p->phy_odt_config_rank[2]);
		printf("\nddr_set_t_p->phy_odt_config_rank[3]:%08x",ddr_set_t_p->phy_odt_config_rank[3]);
		printf("\nddr_set_t_p->dfi_odt_config:%08x",ddr_set_t_p->dfi_odt_config);
		printf("\nddr_set_t_p->DRAMFreq[0]:%08x",ddr_set_t_p->DRAMFreq[0]);
		printf("\nddr_set_t_p->DRAMFreq[1]:%08x",ddr_set_t_p->DRAMFreq[1]);
		printf("\nddr_set_t_p->DRAMFreq[2]:%08x",ddr_set_t_p->DRAMFreq[2]);
		printf("\nddr_set_t_p->DRAMFreq[3]:%08x",ddr_set_t_p->DRAMFreq[3]);
		printf("\nddr_set_t_p->PllBypassEn:%08x",ddr_set_t_p->PllBypassEn);
		printf("\nddr_set_t_p->ddr_rdbi_wr_enable:%08x",ddr_set_t_p->ddr_rdbi_wr_enable);
		printf("\nddr_set_t_p->ddr_rfc_type:%08x",ddr_set_t_p->ddr_rfc_type);
		printf("\nddr_set_t_p->enable_lpddr4x_mode:%08x",ddr_set_t_p->enable_lpddr4x_mode);
		printf("\nddr_set_t_p->pll_ssc_mode:%08x",ddr_set_t_p->pll_ssc_mode);
		printf("\nddr_set_t_p->clk_drv_ohm:%08x",ddr_set_t_p->clk_drv_ohm);
		printf("\nddr_set_t_p->cs_drv_ohm:%08x",ddr_set_t_p->cs_drv_ohm);
		printf("\nddr_set_t_p->ac_drv_ohm:%08x",ddr_set_t_p->ac_drv_ohm);
		printf("\nddr_set_t_p->soc_data_drv_ohm_p:%08x",ddr_set_t_p->soc_data_drv_ohm_p);
		printf("\nddr_set_t_p->soc_data_drv_ohm_n:%08x",ddr_set_t_p->soc_data_drv_ohm_n);
		printf("\nddr_set_t_p->soc_data_odt_ohm_p:%08x",ddr_set_t_p->soc_data_odt_ohm_p);
		printf("\nddr_set_t_p->soc_data_odt_ohm_n:%08x",ddr_set_t_p->soc_data_odt_ohm_n);
		printf("\nddr_set_t_p->dram_data_drv_ohm:%08x",ddr_set_t_p->dram_data_drv_ohm);
		printf("\nddr_set_t_p->dram_data_odt_ohm:%08x",ddr_set_t_p->dram_data_odt_ohm);
		printf("\nddr_set_t_p->dram_ac_odt_ohm:%08x",ddr_set_t_p->dram_ac_odt_ohm);
		printf("\nddr_set_t_p->soc_clk_slew_rate:%08x",ddr_set_t_p->soc_clk_slew_rate);
		printf("\nddr_set_t_p->soc_cs_slew_rate:%08x",ddr_set_t_p->soc_cs_slew_rate);
		printf("\nddr_set_t_p->soc_ac_slew_rate:%08x",ddr_set_t_p->soc_ac_slew_rate);
		printf("\nddr_set_t_p->soc_data_slew_rate:%08x",ddr_set_t_p->soc_data_slew_rate);
		printf("\nddr_set_t_p->vref_output_permil:%08x",ddr_set_t_p->vref_output_permil);
		printf("\nddr_set_t_p->vref_receiver_permil:%08x",ddr_set_t_p->vref_receiver_permil);
		printf("\nddr_set_t_p->vref_dram_permil:%08x",ddr_set_t_p->vref_dram_permil);
        printf("\nddr_set_t_p->max_core_timmming_frequency:%08x",ddr_set_t_p->max_core_timmming_frequency);
		printf("\nddr_set_t_p->ac_trace_delay[0]:%08x",ddr_set_t_p->ac_trace_delay[0]);
		printf("\nddr_set_t_p->ac_trace_delay[1]:%08x",ddr_set_t_p->ac_trace_delay[1]);
		printf("\nddr_set_t_p->ac_trace_delay[2]:%08x",ddr_set_t_p->ac_trace_delay[2]);
		printf("\nddr_set_t_p->ac_trace_delay[3]:%08x",ddr_set_t_p->ac_trace_delay[3]);
		printf("\nddr_set_t_p->ac_trace_delay[4]:%08x",ddr_set_t_p->ac_trace_delay[4]);
		printf("\nddr_set_t_p->ac_trace_delay[5]:%08x",ddr_set_t_p->ac_trace_delay[5]);
		printf("\nddr_set_t_p->ac_trace_delay[6]:%08x",ddr_set_t_p->ac_trace_delay[6]);
		printf("\nddr_set_t_p->ac_trace_delay[7]:%08x",ddr_set_t_p->ac_trace_delay[7]);
		printf("\nddr_set_t_p->ac_trace_delay[8]:%08x",ddr_set_t_p->ac_trace_delay[8]);
		printf("\nddr_set_t_p->ac_trace_delay[9]:%08x",ddr_set_t_p->ac_trace_delay[9]);
        printf("\nddr_set_t_p->lpddr4_dram_vout_voltage_1_3_2_5_setting:%08x",ddr_set_t_p->lpddr4_dram_vout_voltage_1_3_2_5_setting);
        printf("\nddr_set_t_p->lpddr4_x8_mode:%08x",ddr_set_t_p->lpddr4_x8_mode);
		//printf("\nddr_set_t_p->ac_pinmux[26]:%08x",ddr_set_t_p->ac_pinmux[26]);
		//printf("\nddr_set_t_p->dfi_pinmux[28]:%08x",ddr_set_t_p->dfi_pinmux[28]);
		//printf("\nddr_set_t_p->slt_test_function[2]:%08x",ddr_set_t_p->slt_test_function[2]);
		printf("\nddr_set_t_p->dq_bdlr_org:%08x",ddr_set_t_p->dq_bdlr_org);
        printf("\nddr_set_t_p->dram_data_wr_odt_ohm:%08x",ddr_set_t_p->dram_data_wr_odt_ohm);
        printf("\nddr_set_t_p->bitTimeControl_2d:%08x",ddr_set_t_p->bitTimeControl_2d);
		printf("\nddr_set_t_p->ddr_dmc_remap[0]:%08x",ddr_set_t_p->ddr_dmc_remap[0]);
		printf("\nddr_set_t_p->ddr_dmc_remap[1]:%08x",ddr_set_t_p->ddr_dmc_remap[1]);
		printf("\nddr_set_t_p->ddr_dmc_remap[2]:%08x",ddr_set_t_p->ddr_dmc_remap[2]);
		printf("\nddr_set_t_p->ddr_dmc_remap[3]:%08x",ddr_set_t_p->ddr_dmc_remap[3]);
		printf("\nddr_set_t_p->ddr_dmc_remap[4]:%08x",ddr_set_t_p->ddr_dmc_remap[4]);
		printf("\nddr_set_t_p->ddr_lpddr34_ca_remap[0]:%08x",ddr_set_t_p->ddr_lpddr34_ca_remap[0]);
		printf("\nddr_set_t_p->ddr_lpddr34_ca_remap[1]:%08x",ddr_set_t_p->ddr_lpddr34_ca_remap[1]);
		printf("\nddr_set_t_p->ddr_lpddr34_ca_remap[2]:%08x",ddr_set_t_p->ddr_lpddr34_ca_remap[2]);
		printf("\nddr_set_t_p->ddr_lpddr34_ca_remap[3]:%08x",ddr_set_t_p->ddr_lpddr34_ca_remap[3]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[0]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[0]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[1]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[1]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[2]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[2]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[3]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[3]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[4]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[4]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[5]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[5]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[6]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[6]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[7]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[7]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[8]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[8]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[9]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[9]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[10]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[10]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[11]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[11]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[12]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[12]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[13]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[13]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[14]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[14]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[15]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[15]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[16]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[16]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[17]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[17]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[18]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[18]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[19]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[19]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[20]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[20]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[21]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[21]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[22]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[22]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[23]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[23]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[24]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[24]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[25]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[25]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[26]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[26]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[27]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[27]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[28]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[28]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[29]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[29]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[30]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[30]);
		printf("\nddr_set_t_p->ddr_lpddr34_dq_remap[31]:%08x",ddr_set_t_p->ddr_lpddr34_dq_remap[31]);
		printf("\nddr_set_t_p->dram_rtt_nom_wr_park[0]:%08x",ddr_set_t_p->dram_rtt_nom_wr_park[0]);
		printf("\nddr_set_t_p->dram_rtt_nom_wr_park[1]:%08x",ddr_set_t_p->dram_rtt_nom_wr_park[1]);
		printf("\nddr_set_t_p->ddr_func:%08x",ddr_set_t_p->ddr_func);
		//printf("\nddr_set_t_p->rsv_long0[2]:%08x",ddr_set_t_p->rsv_long0[2]);
		//printf("\nddr_set_t_p->dqs_adjust[16]:%08x",ddr_set_t_p->dqs_adjust[16]);
		//printf("\nddr_set_t_p->dq_bit_delay[72]:%08x",ddr_set_t_p->dq_bit_delay[72]);
*/
	}
	return 1;
}


int do_ddr_fastboot_config(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{

	int i=0;
	int count=0;
	char *endp;
	unsigned int enable_ddr_fast_boot=0;  // 0 pause 1,resume

	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
		printf("\nargv[%d]=%s\n",i,argv[i]);
	if (argc == 1)
		printf("\nplease read help\n");
	else if (argc > 1)
	{
		count=0;
		enable_ddr_fast_boot= simple_strtoull_ddr(argv[count+1], &endp, 0);
		if (*argv[count+1] == 0 || *endp != 0)
		{
			enable_ddr_fast_boot = 0;
		}
		//	count++;
	}
	if(!enable_ddr_fast_boot)
		return 1;

	ddr_set_t *ddr_set_t_p=NULL;
	ddr_set_t_p=(ddr_set_t *)(ddr_set_t_p_arrary);
	//ddr_set_t_p= (ddr_set_t *)G12_DMC_STICKY_0;
	//if (sizeof(ddr_set_t)<loop_max)
	uint32_t  ddr_set_add=0;
	uint32_t  ddr_set_size=0;
	ddr_set_add=(uint32_t)(uint64_t)(ddr_set_t_p);
	ddr_set_size=sizeof(ddr_set_t);
	printf("\nddr_set_t_p==0x%08x\n",ddr_set_add);
	uint32_t loop=0; 
	uint32_t loop_max = (4+(0x3f<<2));//((DMC_STICKY_63-DMC_STICKY_0));
	//	loop_max=sizeof(ddr_set_t);
	for (loop = 0; loop <loop_max; loop+=4) {
		wr_reg(((uint64_t)(ddr_set_t_p) + loop), rd_reg(G12_DMC_STICKY_0 + loop));
	}
			
{
	uint16_t	dq_bit_delay[72];
	unsigned	char t_count=0;
	uint16_t  delay_org=0;
	uint16_t  delay_temp=0;
	uint32_t  add_offset=0;
	dwc_ddrphy_apb_wr(0xd0000,0x0);

	char dmc_test_worst_window_rx=0;
	char dmc_test_worst_window_tx=0;

	{
	dwc_ddrphy_apb_wr((0<<20)|(0xd<<16)|(0<<12)|(0x0),0); // DWC_DDRPHYA_APBONLY0_MicroContMuxSel

	dmc_test_worst_window_tx=dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(0<<12)|(0x0c2));
	dmc_test_worst_window_rx=dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(0<<12)|(0x0c3));
	if(dmc_test_worst_window_tx>30)
	dmc_test_worst_window_tx=30;
	if(dmc_test_worst_window_rx>30)
	dmc_test_worst_window_rx=30;
//	dwc_ddrphy_apb_wr((0<<20)|(1<<16)|(0<<12)|(0x1c2),t4_write_worst_margin_rank1);
//	dwc_ddrphy_apb_wr((0<<20)|(1<<16)|(0<<12)|(0x1c3),t4_read_worst_margin_rank1);
	ddr_set_t_p->fast_boot[1]=(((dmc_test_worst_window_tx/2)<<4))|(((dmc_test_worst_window_rx/2)));
				}
	
	{
	//printf("\n ARdPtrInitVal");
	add_offset=((0<<20)|(0<<16)|(0<<12)|(0x2e));
	delay_org=dwc_ddrphy_apb_rd(add_offset);
	ddr_set_t_p->ARdPtrInitVal=delay_org;
	//printf("\n t_count: %04d %04d  %08x %08x",0,delay_org,((((add_offset) << 1)+0xfe000000)),delay_org);

	//printf("\n dfimrl0 dfimrl1 dfimrl2 dfimrl3 HwtMRL");
	add_offset=((0<<20)|(1<<16)|(0<<12)|(0x20));
	delay_org=dwc_ddrphy_apb_rd(add_offset);
	ddr_set_t_p->dfi_mrl=delay_org;
	//printf("\n t_count: %04d %04d  %08x %08x",0,delay_org,((((add_offset) << 1)+0xfe000000)),delay_org);
	add_offset=((0<<20)|(1<<16)|(1<<12)|(0x20));
	delay_org=dwc_ddrphy_apb_rd(add_offset);
	//printf("\n t_count: %04d %04d  %08x %08x",1,delay_org,((((add_offset) << 1)+0xfe000000)),delay_org);
	add_offset=((0<<20)|(1<<16)|(2<<12)|(0x20));
	delay_org=dwc_ddrphy_apb_rd(add_offset);
	//printf("\n t_count: %04d %04d  %08x %08x",2,delay_org,((((add_offset) << 1)+0xfe000000)),delay_org);
	add_offset=((0<<20)|(1<<16)|(3<<12)|(0x20));
	delay_org=dwc_ddrphy_apb_rd(add_offset);
	//printf("\n t_count: %04d %04d  %08x %08x",3,delay_org,((((add_offset) << 1)+0xfe000000)),delay_org);
	add_offset=((0<<20)|(2<<16)|(0<<12)|(0x20));
	delay_org=dwc_ddrphy_apb_rd(add_offset);

	ddr_set_t_p->dfi_hwtmrl=delay_org;
	//printf("\n t_count: %04d %04d  %08x %08x",0,delay_org,((((add_offset) << 1)+0xfe000000)),delay_org);
	}
	{
	//printf("\n count_index     delay_value     register_add     register_value \n ");
	//printf("\n address delay * 1/32UIx100==%d ps bit0-4 fine tune  --step==1/32UI ,bit 6 is coarse  --step==1UI",ui_1_32_100step);
	for(t_count=0;t_count<10;t_count++)
	{
		add_offset=((0<<20)|(0<<16)|(t_count<<12)|(0x80));
		dq_bit_delay[t_count]=dwc_ddrphy_apb_rd(add_offset);
		delay_org=dq_bit_delay[t_count];
		delay_temp=(32*(((delay_org>>6)&0xf)+((delay_org>>5)&1))+(delay_org&0x1f));
		ddr_set_t_p->ac_trace_delay[t_count]=delay_temp;
		//printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
	}
	}
	{
	//	printf("\n tdqs delay * 1/32UIx100==%d ps bit0-4 fine tune --step==1/32UI ,bit 6-9 is coarse  --step==1UI",ui_1_32_100step);
		for(t_count=0;t_count<16;t_count++)
		{
			add_offset=((0<<20)|(1<<16)|(((t_count%8)>>1)<<12)|(0xd0+(t_count/8)+((t_count%2)<<8)));
			dq_bit_delay[t_count]=dwc_ddrphy_apb_rd(add_offset);
			delay_org=dq_bit_delay[t_count];
			delay_temp=(32*(((delay_org>>6)&0xf)+((delay_org>>5)&1))+(delay_org&0x1f));
			
			ddr_set_t_p->write_dqs_delay[t_count]=delay_temp;
			
		//	printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
		}
	}
	{
	//	printf("\n rxdqs delay * 1/32UIx100==%d ps bit0-4 fine tune --step==1/32UI,no coarse",ui_1_32_100step);
		for(t_count=0;t_count<16;t_count++)
		{
			add_offset=((0<<20)|(1<<16)|(((t_count%8)>>1)<<12)|(0x8c+(t_count/8)+((t_count%2)<<8)));
			dq_bit_delay[t_count]=dwc_ddrphy_apb_rd(add_offset);
			delay_org=dq_bit_delay[t_count];
			delay_temp=(32*(((delay_org>>6)&0xf)+((delay_org>>5)&1))+(delay_org&0x1f));
			ddr_set_t_p->read_dqs_delay[t_count]=delay_temp;
	//		printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
		}
	}
	{
	//	printf("\n write dq_bit delay * 1/32UIx100==%d ps bit0-4 fine tune --step==1/32UI ,bit 6-8 is coarse  --step==1U",ui_1_32_100step);
			for(t_count=0;t_count<72;t_count++)
			{
				add_offset=((0<<20)|(1<<16)|(((t_count%36)/9)<<12)|(0xc0+((t_count%9)<<8)+(t_count/36)));
				dq_bit_delay[t_count]=dwc_ddrphy_apb_rd(add_offset);
				delay_org=dq_bit_delay[t_count];
				delay_temp=(32*(((delay_org>>6)&0xf)+((delay_org>>5)&1))+(delay_org&0x1f));

				ddr_set_t_p->write_dq_bit_delay[t_count]=delay_temp;

				
		//		printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
			}
	}
	{
	//	printf("\n read dq_bit delay * BDLRx100==%d ps bit0-4 fine tune --step==bdlr step size about 5ps,no coarse",bdlr_100step);
		for(t_count=0;t_count<72;t_count++)
		{
			add_offset=((0<<20)|(1<<16)|(((t_count%36)/9)<<12)|(0x68+((t_count%9)<<8)+(t_count/36)));
			dq_bit_delay[t_count]=dwc_ddrphy_apb_rd(add_offset);
			delay_org=dq_bit_delay[t_count];
			delay_temp=((delay_org&0x3f));
			
			ddr_set_t_p->read_dq_bit_delay[t_count]=delay_temp;
		//	printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
		}
	}
	{
	//	printf("\n read dqs gate delay * 1/32UIx100==%d ps bit0-4 fine tune ,bit 6-10 is coarse",ui_1_32_100step);
		for(t_count=0;t_count<16;t_count++)
		{
			add_offset=((0<<20)|(1<<16)|(((t_count%8)>>1)<<12)|(0x80+(t_count/8)+((t_count%2)<<8)));
			dq_bit_delay[t_count]=dwc_ddrphy_apb_rd(add_offset);
			delay_org=dq_bit_delay[t_count];
			delay_temp=(32*(((delay_org>>6)&0xf)+((delay_org>>5)&1))+(delay_org&0x1f));

			ddr_set_t_p->read_dqs_gate_delay[t_count]=delay_temp;

			
	//		printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
		}

	//	printf("\n soc vref : lpddr4-- VREF = VDDQ*(0.047 + VrefDAC0[6:0]*0.00367   DDR4 --VREF = VDDQ*(0.510 + VrefDAC0[6:0]*0.00345");
		//((0<<20)|(1<<16)|(((over_ride_sub_index%36)/9)<<12)|(((over_ride_sub_index%36)%9)<<8)|(0x40),over_ride_value)	
		uint32_t vref_t_count=0;
		for(t_count=0;t_count<72;t_count++)
		{
			add_offset=((0<<20)|(1<<16)|(((t_count%36)/9)<<12)|(((t_count%36)%9)<<8)|(0x40));
			dq_bit_delay[t_count]=dwc_ddrphy_apb_rd(add_offset);
			delay_org=dq_bit_delay[t_count];
			delay_temp=((delay_org));

			if(t_count<35)
			{
				vref_t_count=((((t_count%36)/9)*8)+(t_count%9));
				ddr_set_t_p->soc_bit_vref[vref_t_count]=delay_temp;
			}
			//		printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
		}
		//printf("\n dram vref : lpddr4-- VREF = VDDQ*(0. + VrefDAC0[6:0]*0.   DDR4 --VREF = VDDQ*(0. + VrefDAC0[6:0]*0.");
		add_offset=((0<<20)|(1<<16)|(0<<12)|(0x082));
		delay_temp=dwc_ddrphy_apb_rd(add_offset);
		for(t_count=0;t_count<32;t_count++)
		{
			ddr_set_t_p->dram_bit_vref[t_count]=delay_temp;
			//	printf("\n t_count: %04d %04d  %08x %08x",t_count,delay_temp,((((add_offset) << 1)+0xfe000000)),dq_bit_delay[t_count]);
		}
	//	printf("\n t_count: %04d %04d  %08x %08x",0,delay_temp,((((add_offset) << 1)+0xfe000000)),delay_temp);

		for(t_count=0;t_count<4;t_count++)
		{//p_dev->p_ddrs->tdqs2dq=lpddr4_tdqs2dq;
			//ddr_set_t_p->retraining[0]=dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(0<<12)|(0xaa));  //PptCtlStatic
			//ddr_set_t_p->retraining[1]=dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(0<<12)|(0xae));  //PptDqsCntInvTrnTg0  ps0 rank0
			//ddr_set_t_p->retraining[2]=dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(0<<12)|(0xaf));  //PptDqsCntInvTrnTg0  ps0 rank1
			ddr_set_t_p->retraining[4*t_count+0]=(dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(t_count<<12)|(0xaa)))&0xff;  //PptCtlStatic
			ddr_set_t_p->retraining[4*t_count+1]=(dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(t_count<<12)|(0xaa)))>>8;  //PptCtlStatic
			ddr_set_t_p->retraining[4*t_count+2]=dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(t_count<<12)|(0xae));  //PptDqsCntInvTrnTg0  ps0 rank0 lane 0-3
			ddr_set_t_p->retraining[4*t_count+3]=dwc_ddrphy_apb_rd((0<<20)|(1<<16)|(t_count<<12)|(0xaf));  //PptDqsCntInvTrnTg0  ps0 rank1 lane 0-3
		}
	}
}

	char str[1024]="";
	//store ddr_parameter write 0x77f81cf0 0x300
	//printf("\n ");

	if(enable_ddr_fast_boot==1)
		ddr_set_t_p->fast_boot[0]=0xff;

	if(enable_ddr_fast_boot==2)
		ddr_set_t_p->fast_boot[0]=0;

	{
		#if 1
		printf("&ddr_sha.ddrs : 0x%x\n", (uint32_t)(uint64_t)&ddr_sha.ddrs);
		printf("&ddr_sha.sha2 : 0x%x\n", (uint32_t)(uint64_t)&ddr_sha.sha2);
		printf("ddr_set_add : 0x%x\n", (uint32_t)(uint64_t)ddr_set_add);

		sha256_csum_wd((unsigned char *)(uint64_t)ddr_set_add, sizeof(ddr_set_t), ddr_sha.sha2, 0);
		//sha2((unsigned char *)(uint64_t)ddr_set_add, sizeof(ddr_set_t), ddr_sha.sha2, 0);
		printf("print sha\n");
		sprintf(str,"md %08x 0x100", (uint32_t)(uint64_t)(ddr_set_add-32));
		run_command(str,0);
		#endif
		#ifdef USE_FOR_UBOOT_2018
		sprintf(str,"store rsv write ddr-parameter 0x%08x 0x%08x ",ddr_set_add-SHA256_SUM_LEN,ddr_set_size+SHA256_SUM_LEN);
		#else
		sprintf(str,"store ddr_parameter write 0x%08x 0x%08x ",ddr_set_add-SHA256_SUM_LEN,ddr_set_size+SHA256_SUM_LEN);
		#endif
		//	sprintf(str,"store ddr_parameter write 0x%08x 0x%08x ",ddr_set_add,ddr_set_size);
		//	sprintf(str,"store rsv write ddr-parameter 0x%08x 0x%08x ",ddr_set_add,ddr_set_size);
		printf("\nstr=%s\n",str);
		run_command(str,0);
	}

	return 1;
}
#else
int do_ddr_display_ddr_information(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	int i=0;
	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
		printf("\nargv[%d]=%s\n",i,argv[i]);

	//writel((0), 0xc8836c00);
	OPEN_CHANNEL_A_PHY_CLK();
	OPEN_CHANNEL_B_PHY_CLK();
	//writel((0), 0xc8836c00);

	// char *endp;

	unsigned int zq0pr_org = rd_reg(DDR0_PUB_ZQ0PR);
	unsigned int zq1pr_org = rd_reg(DDR0_PUB_ZQ1PR);
	unsigned int zq2pr_org = rd_reg(DDR0_PUB_ZQ2PR);
	unsigned int soc_ac_drv3=0;
	unsigned int soc_ac_drv4_up=0;
	unsigned int soc_ac_drv4_down=0;
	unsigned int soc_ac_odt3=0;
	unsigned int soc_ac_odt4=0;
	unsigned int soc_data01_drv3=0;
	unsigned int soc_data01_drv4_up=0;
	unsigned int soc_data01_drv4_down=0;
	unsigned int soc_data01_odt3=0;
	unsigned int soc_data01_odt4=0;

	unsigned int soc_data23_drv3=0;
	unsigned int soc_data23_drv4_up=0;
	unsigned int soc_data23_drv4_down=0;
	unsigned int soc_data23_odt3=0;
	unsigned int soc_data23_odt4=0;
	unsigned int dram_drv=0;
	unsigned int dram_odt=0;
	unsigned int dram_ddr4_drv=0;
	unsigned int dram_ddr4_odt=0;
	//unsigned int soc_zq_odt_div=480;

	unsigned int pub_dcr= rd_reg(DDR0_PUB_DCR);
	unsigned int pub_mr1= rd_reg(DDR0_PUB_MR1);
	unsigned int reg_value=0;
	#define DDR_TYPE_LPDDR2  0
	#define DDR_TYPE_LPDDR3  1
	#define DDR_TYPE_DDR3  3
	#define DDR_TYPE_DDR4  4
	unsigned int ddr_type= pub_dcr&0x7; //0 -lpddr2  |  1- lpddr3  |   2- rev  |  3 -ddr3   | 4- ddr4

	{
		if (ddr_type==0)
			printf("\nddr_type==lpddr2\n");
		if (ddr_type==1)
			printf("\nddr_type==lpddr3\n");
		if (ddr_type==DDR_TYPE_DDR3)
			printf("\nddr_type==ddr3\n");
		if (ddr_type==DDR_TYPE_DDR4)
			printf("\nddr_type==ddr4\n");

		soc_ac_drv3=zq0pr_org&0xf;
		soc_ac_odt3=(zq0pr_org>>4)&0xf;
		soc_ac_drv4_up=(zq0pr_org>>8)&0xf;
		soc_ac_drv4_down=(zq0pr_org>>12)&0xf;
		soc_ac_odt4=(zq0pr_org>>16)&0xf;

		soc_data01_drv3=zq1pr_org&0xf;
		soc_data01_odt3=(zq1pr_org>>4)&0xf;
		soc_data01_drv4_up=(zq1pr_org>>8)&0xf;
		soc_data01_drv4_down=(zq1pr_org>>12)&0xf;
		soc_data01_odt4=(zq1pr_org>>16)&0xf;

		soc_data23_drv3=zq2pr_org&0xf;
		soc_data23_odt3=(zq2pr_org>>4)&0xf;
		soc_data23_drv4_up=(zq2pr_org>>8)&0xf;
		soc_data23_drv4_down=(zq2pr_org>>12)&0xf;
		soc_data23_odt4=(zq2pr_org>>16)&0xf;


		reg_value=pub_mr1;
		if((((reg_value>>5)&1)==0))
		{
			if(((reg_value>>1)&1)==0)
			{
				dram_drv=40;
				dram_ddr4_drv=34;
			}
			else
			{
				dram_drv=34;
				dram_ddr4_drv=48;
			}
		}

		if(((reg_value>>8)&7)==0)
		{
			dram_ddr4_odt=0;
		}
		if(((reg_value>>8)&7))
		{
			dram_ddr4_odt=240/(((reg_value>>10)&1)|(((reg_value>>9)&1)<<1)|(((reg_value>>8)&1)<<2));
		}
		reg_value=(((reg_value>>9)&1)<<2)|(((reg_value>>6)&1)<<1)|(((reg_value>>2)&1)<<0);
		if(reg_value==1)
		{
			dram_odt=60;
		}
		if(reg_value==2)
		{
			dram_odt=120;
		}
		if(reg_value==3)
		{
			dram_odt=40;
		}
		if(reg_value==4)
		{
			dram_odt=20;
		}
		if(reg_value==5)
		{
			dram_odt=30;
		}	

		printf("zq0pr_org==%x,zq1pr_org==%x,zq2pr_org==%x,\n",zq0pr_org,zq1pr_org,zq2pr_org);
		printf("soc_ac_drv3==%d,soc_ac_odt3==%d,\n",480/(soc_ac_drv3+1),360/(soc_ac_odt3+1));
		printf("soc_data01_drv3==%d,soc_data01_odt3==%d,\n",480/(soc_data01_drv3+1),360/(soc_data01_odt3+1));	
		printf("soc_data23_drv3==%d,soc_data23_odt3==%d,\n",480/(soc_data23_drv3+1),360/(soc_data23_odt3+1));	
		printf("dram_drv3==%d,dram_odt3==%d,\n\n\n",dram_drv,dram_odt);

		printf("soc_ac_drv4_up==%d,soc_ac_drv4_down==%d,soc_ac_odt4==%d,\n",480/(soc_ac_drv4_up+1),480/(soc_ac_drv4_down+1),480/(soc_ac_odt4+1));
		printf("soc_data01_drv4_up==%d,soc_data01_drv4_down==%d,soc_data01_odt4==%d,\n",480/(soc_data01_drv4_up+1),480/(soc_data01_drv4_down+1),480/(soc_data01_odt4+1));
		printf("soc_data23_drv4_up==%d,soc_data23_drv4_down==%d,soc_data23_odt4==%d,\n",480/(soc_data23_drv4_up+1),480/(soc_data23_drv4_down+1),480/(soc_data23_odt4+1));


		printf("dram_ddr4_drv==%d,dram_ddr4_odt==%d,\n",dram_ddr4_drv,dram_ddr4_odt);


	}
	unsigned int dtedr0[2][4];
	unsigned int dtedr1[2][4];
	//unsigned int vtdr[2][4];
	unsigned int lcdlr_w_setting[2][4];
	unsigned int lcdlr_r_setting[2][4];
	unsigned int delay_line_100step=0;
	if (1) {
#if (CONFIG_DDR_PHY > P_DDR_PHY_DEFAULT)
		/*
		   bl2_print("DDR0_PUB_ACLCDLR: 0x",rd_reg(DDR0_PUB_ACLCDLR), VALUE_HEX, "....\n");
		   bl2_print("DDR0_PUB_ACBDLR0: 0x", rd_reg(DDR0_PUB_ACBDLR0), VALUE_HEX, "....\n");
		   bl2_print("DDR0_MDLR: ", ((rd_reg(DDR0_PUB_ACMDLR0)>>16)&0X1FF), VALUE_DEC ,"....\n");
		   bl2_print("DDR0_CLK: ", p_ddr_set->ddr_clk, VALUE_DEC, "MHz\n");
		   bl2_print("delay_line_10step:", (1000*1000*10/(2*p_ddr_set->ddr_clk))/((rd_reg(DDR0_PUB_ACMDLR0)>>16)&0X1FF), VALUE_DEC, "....\n");
		   */
		//printf("DDR0_MDLR:%8d, CLK:%8dMhz, delay_line_10step:%8d ps\n", ((rd_reg(DDR0_PUB_ACMDLR0)>>16)&0X1FF),
		//p_ddr_set->ddr_clk ,(1000*1000/(2*p_ddr_set->ddr_clk))/((rd_reg(DDR0_PUB_ACMDLR0)>>16)&0X1FF));
		wr_reg(DDR0_PUB_RANKIDR, ((0<<0)|((0<<16))));
		///*
		unsigned int i=0;
		unsigned int rank=0;
		for(rank=0;rank<2;(rank++))
		{
			printf("DDR0_RANK0==%d,\n",rank);
			//bl2_print("DDR0_RANK0: 0x", rank, VALUE_HEX, "\n\n");
			wr_reg(DDR0_PUB_RANKIDR, ((rank<<0)|((rank<<16))));
			for(i=0;i<4;(i++))
			{
				//change dtcr0 lane reg map
				wr_reg(DDR0_PUB_DTCR0,(((rank<<24)|(i<<16)))|((rd_reg(DDR0_PUB_DTCR0))&(~((1<<11)|(0xf<<16)))));//

				printf("DDR0_LANE0: 0x %d\n", i);
				// bl2_print("DDR0_PUB_DTEDR0: 0x", rd_reg(DDR0_PUB_DTEDR0), VALUE_HEX, "\n")
				// bl2_print("DDR0_PUB_DTEDR1: 0x", rd_reg(DDR0_PUB_DTEDR1), VALUE_HEX, "\n")

				//   bl2_print("DDR0_PUB_DTEDR2: 0x", rd_reg(DDR0_PUB_DTEDR2), VALUE_HEX, "\n")
				dtedr0[rank][i]=(rd_reg(DDR0_PUB_DTEDR0));
				dtedr1[rank][i]=(rd_reg(DDR0_PUB_DTEDR1));
				//vtdr[rank][i]=(rd_reg(DDR0_PUB_VTDR));
				printf("DDR0_PUB_W_Min:%d \n", (rd_reg(DDR0_PUB_DTEDR0))&0x1ff);

				printf("DDR0_PUB_W_Max: %d\n", ((rd_reg(DDR0_PUB_DTEDR0))>>9)&0x1ff);

				//	 bl2_print("DDR0_PUB_W_Max: ", ((uint64_t)(DDR0_PUB_DX0LCDLR1+i*(DDR0_PUB_DX1LCDLR1-DDR0_PUB_DX0LCDLR1))), VALUE_DEC, "\n\n")
				lcdlr_w_setting[rank][i]=((rd_reg((uint64_t)(DDR0_PUB_DX0LCDLR1+i*(DDR0_PUB_DX1LCDLR1-DDR0_PUB_DX0LCDLR1)))));
				printf("DDR0_PUB_W_SETTING:%d \n", ((rd_reg((uint64_t)(DDR0_PUB_DX0LCDLR1+i*(DDR0_PUB_DX1LCDLR1-DDR0_PUB_DX0LCDLR1)))))&0x1ff);



				printf("DDR0_PUB_R_Min: %d\n", (rd_reg(DDR0_PUB_DTEDR1))&0x1ff);

				printf("DDR0_PUB_R_Max:%d\n", ((rd_reg(DDR0_PUB_DTEDR1))>>9)&0x1ff);

				printf("DDR0_PUB_R_SETTING: %d\n", ((rd_reg((uint64_t)(DDR0_PUB_DX0LCDLR3+i*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))))&0x1ff);
				lcdlr_r_setting[rank][i]=((rd_reg((uint64_t)(DDR0_PUB_DX0LCDLR3+i*(DDR0_PUB_DX1LCDLR3-DDR0_PUB_DX0LCDLR3)))));
				printf("DDR0_PUB_VTDR: 0x%x\n", (rd_reg(DDR0_PUB_VTDR)));	
			}
		}
		wr_reg(DDR0_PUB_RANKIDR, ((0<<0)|((0<<16))));

		unsigned int ddr_pll = rd_reg(AM_DDR_PLL_CNTL);
		unsigned int ddr_clk =pll_convert_to_ddr_clk(ddr_pll);
		///2*(((24 * (ddr_pll&0x1ff))/((ddr_pll>>9)&0x1f))>>((ddr_pll>>16)&0x3));

		printf("\nddr_clk== %dMHz\n", ddr_clk);
		global_ddr_clk=ddr_clk;
		printf("DDR0_PUB_ACBDLR0: 0x%x\n", (rd_reg(DDR0_PUB_ACBDLR0)));
		printf("DDR0_PUB_ACLCDLR: 0x%x\n", (rd_reg(DDR0_PUB_ACLCDLR)));

		//printf("DDR0_MDLR:%d \n", ((rd_reg(DDR0_PUB_ACMDLR0)>>16)&0X1FF));
		//printf("DDR0_CLK:%d MHz \n", p_ddr_set->ddr_clk");
		//printf("delay_line_10step:%d \n", (1000*1000*10/(2*p_ddr_set->ddr_clk))/((rd_reg(DDR0_PUB_ACMDLR0)>>16)&0X1FF)");

		printf("DDR0_MDLR:%8d, CLK:%8dMhz, delay_line_10step:%8d ps,delay_line_100step:%8d ps,\n", ((rd_reg(DDR0_PUB_ACMDLR0)>>16)&0X1FF),
				global_ddr_clk ,(10000*1000/(2*global_ddr_clk))/((rd_reg(DDR0_PUB_ACMDLR0)>>16)&0X1FF),
				(1000*100000/(2*global_ddr_clk))/((rd_reg(DDR0_PUB_ACMDLR0)>>16)&0X1FF));
		delay_line_100step=(1000*100000/(2*global_ddr_clk))/((rd_reg(DDR0_PUB_ACMDLR0)>>16)&0X1FF);
		for(rank=0;rank<2;(rank++))
		{
			printf("DDR0_RANK0==%d,\n",rank);

			for(i=0;i<4;(i++))
			{
				//dtedr0[rank][i]=(rd_reg(DDR0_PUB_DTEDR0));
				//dtedr1[rank][i]=(rd_reg(DDR0_PUB_DTEDR1));
				//vtdr[rank][i]=(rd_reg(DDR0_PUB_VTDR));
				printf("%4d ", ((((dtedr0[rank][i])>>9)&0x1ff)-lcdlr_w_setting[rank][i])*delay_line_100step/100
					  );
				printf("%4d ", ((lcdlr_w_setting[rank][i])-(((dtedr0[rank][i])>>0)&0x1ff))*delay_line_100step/100
					  );

				printf("%4d ", ((lcdlr_r_setting[rank][i])-(((dtedr1[rank][i])>>0)&0x1ff))*delay_line_100step/100
					  );
				printf("%4d      ", ((((dtedr1[rank][i])>>9)&0x1ff)-lcdlr_r_setting[rank][i])*delay_line_100step/100
					  );
			}
			printf("\n");			
		}
		printf("\nend==%d,\n",rank);
#endif
	}

	CLOSE_CHANNEL_A_PHY_CLK();
	CLOSE_CHANNEL_B_PHY_CLK();
	return 1;
}


int do_ddr_offset_ddr_lcdlr(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{

	//ddr_test_cmd 0x25 1 1  10 10 10 10 10 10 10 10 10 10
#if (CONFIG_DDR_PHY > P_DDR_PHY_DEFAULT) 
	//   if(!argc)
	//    goto DDR_TUNE_DQS_START;
	int i=0;
	char *endp;
	unsigned int resume_ddl=0;  // 0 pause 1,resume
	unsigned int offset_id=0;  // 0 left  1  right
	unsigned int count=0;
	unsigned int reg_add=0;
	unsigned int reg_value=0;
	unsigned int offset_value[10]={0,0,0,0,0,0,0,0,0,0} ; // ac w  clk w   lane 0 w r lane 1 w r lane2 w r lane3 w r  
	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
		printf("\nargv[%d]=%s\n",i,argv[i]);
	if (argc == 1)
		printf("\nplease read help\n");
	else if (argc > 1)
	{
			count=0;
			resume_ddl= simple_strtoull_ddr(argv[count+1], &endp, 0);
			if (*argv[count+1] == 0 || *endp != 0)
			{
				resume_ddl = 0;
			}
			//	count++;
		if  (argc > 2)
		{
			count=1;
			offset_id= simple_strtoull_ddr(argv[count+1], &endp, 0);
			if (*argv[count+1] == 0 || *endp != 0)
			{
				offset_id = 0;
			}
			//	count++;
		}

		if  (argc > 3)
		{		
			count=2;
			while(count<(argc-1))
			{
				offset_value[count-2]= simple_strtoull_ddr(argv[count+1], &endp, 0);
				if (*argv[count+1] == 0 || *endp != 0)
				{
					offset_value[count-2] = 0;
				}
				count++;
			}
		}

	}

	printf("resume_ddl=%d,\n",resume_ddl);
	if(offset_id)
		printf("offset right ++%d,\n",offset_id);
	else
		printf("offset left --%d,\n",offset_id);

	for (i = 0;i<10;i++)
	{
		printf("offset_value[%d]=%d\n",i,offset_value[i]);
	}

	{
		//writel((0), 0xc8836c00);
		OPEN_CHANNEL_A_PHY_CLK();
	}

	{
		OPEN_CHANNEL_B_PHY_CLK();
		//writel((0), 0xc8836c00);
	}


	printf("\nshould pause ddl pir== 0x%08x,if no pause ddl ,write lcdlr some time may occur error\n", readl(DDR0_PUB_REG_BASE+4));
	writel((readl(DDR0_PUB_REG_BASE+4))|(1<<29),(DDR0_PUB_REG_BASE+4));
	printf("\n pause ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));


	//if (vref_lcdlr_offset)
	for (i = 0;i<10;i++)	
	{
		if(i==0)
			reg_add = DDR0_PUB_ACLCDLR;
		if(i==1)
			reg_add = DDR0_PUB_ACBDLR0;
		if(i>1)
		{
			if(i%2){
				reg_add = DDR0_PUB_DX0LCDLR3 + ((DDR0_PUB_DX1LCDLR3 - DDR0_PUB_DX0LCDLR3)*((i-2)/2));}
			else{
				reg_add = DDR0_PUB_DX0LCDLR1 + ((DDR0_PUB_DX1LCDLR3 - DDR0_PUB_DX0LCDLR3)*((i-2)/2));}
		}

		printf("\n org reg_add 0x%08x== 0x%08x\n ",(reg_add),
				rd_reg(reg_add));
		if(offset_id)  //offset +
		{
			wr_reg(reg_add, ( rd_reg(reg_add)+offset_value[i]));
			if(i>1)
			{if(i%2){wr_reg((reg_add+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR3),
					( rd_reg((reg_add+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR3))+offset_value[i]));
					}
			}



		}
		else
		{
			reg_value=rd_reg(reg_add);
			reg_value=( reg_value>offset_value[i])?( reg_value-offset_value[i]):0;
			wr_reg(reg_add, reg_value);
			if(i>1)
			{if(i%2){wr_reg((reg_add+DDR0_PUB_DX0LCDLR4-DDR0_PUB_DX0LCDLR3),
					( reg_value));
					}
			}



		}

		printf("\n mod reg_add 0x%08x== 0x%08x\n ",(reg_add),
				rd_reg(reg_add));
		//	/*
		{



		}
		//*/
	}
	// printf("\n read reg==0x%08x\n ",(readl(reg_add)));
	printf("\nend pause ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
	if(resume_ddl){
		writel(((readl(DDR0_PUB_REG_BASE+4))&(~(1<<29))),(DDR0_PUB_REG_BASE+4));
		printf("\n resume ddl pir== 0x%08x\n", readl(DDR0_PUB_REG_BASE+4));
	}





#endif
	return 1;
}


#endif
int do_ddr_set_watchdog_value(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	char *endp;
	int i=0;
	printf("\nargc== 0x%08x\n", argc);
	for (i = 0;i<argc;i++)
		printf("\nargv[%d]=%s\n",i,argv[i]);

	if (argc == 1)
		printf("\nplease read help\n");

	else if  (argc > 1)
	{
		{
			watchdog_time_s = simple_strtoull_ddr(argv[1], &endp, 0);
			if (*argv[1] == 0 || *endp != 0)
				watchdog_time_s= 20;
		}
		printf("watchdog_time_s==%d\n",watchdog_time_s);
	}

	return 1;
}


#if ( CONFIG_DDR_PHY >= P_DDR_PHY_G12)
	#define  G12_DATA_READ_OFFSET_MAX   (0X3F)
	#define  G12_DATA_WRITE_OFFSET_MAX   (0X3F+7*32)

	#define DMC_TEST_WINDOW_INDEX_ATXDLY 1
	#define DMC_TEST_WINDOW_INDEX_TXDQSDLY 2
	#define DMC_TEST_WINDOW_INDEX_RXCLKDLY  3
	#define DMC_TEST_WINDOW_INDEX_TXDQDLY  4
	#define DMC_TEST_WINDOW_INDEX_RXPBDLY  5
	#define DMC_TEST_WINDOW_INDEX_RXENDLY  6

	#define DMC_TEST_WINDOW_INDEX_EE_VOLTAGE  0x11
	#define DMC_TEST_WINDOW_INDEX_SOC_VREF  0x12
	#define DMC_TEST_WINDOW_INDEX_DRAM_VREF    0x13

	typedef struct training_delay_information{
	uint16_t ac_delay[10];
	uint16_t txdqs_delay[16];
	uint16_t rxdqs_delay[16];
	uint16_t txdq_delay[72];
	uint16_t rxdq_delay[72];
	uint16_t gate_rxdq_delay[72];

	} training_delay_t;
	training_delay_t  training_delay_t_p;

	uint16_t  lcd_bdl_value[72][4]; //org min max status
	//  #define LCD_BDLR_ORG   0
	#define LCD_BDLR_MIN  0
	#define LCD_BDLR_MAX   1
	#define LCD_BDLR_STATUS  2

	//BYTE0-3
	#define  TEST_ARG_0_DMC_STICKY_MAGIC  0
	#define  TEST_ARG_1_CMD0  1
	#define  TEST_ARG_2_STEP  2   // 0 init   1 test ac  2 test tdqs_write
	#define  TEST_ARG_3_ALL_TIGHTER  3

	//BYTE4-7
	#define  TEST_ARG_FREQ_NIBBLE_L  4
	#define  TEST_ARG_FREQ_NIBBLE_H  5

	//BYTE8-11
	#define  TEST_ARG_BOOT_TIMES_L 6
	#define  TEST_ARG_BOOT_TIMES_H 7

	//BYTE12-15
	#define  TEST_ARG_ERROR_FLAG 8   //take 4 byte for kernel test flag
	//#define  TEST_ARG_ERROR_FLAG 63*4   //take 4 byte for kernel test flag

	//BYTE16-19
	//#define  TEST_ARG_16_LCDLR_TEMP_COUNT 16
	#define  TEST_ARG_CS0_TEST_START_INDEX  12   
	#define  TEST_ARG_CS0_TEST_SIZE_INDEX  16  
	#define  TEST_ARG_CS1_TEST_START_INDEX  20   
	#define  TEST_ARG_CS1_TEST_SIZE_INDEX  24  

	#define  TEST_ARG_WATCHDOG_TIME_SIZE_INDEX  28  
	#define  TEST_ARG_TEST_INDEX_ENALBE_INDEX  30 
	//#define  TEST_ARG_NIBBLE_MASK0_ENALBE_INDEX  32 

	#define  TEST_ARG_ERROR_FLAG_NULL 0
	#define  TEST_ARG_ERROR_FLAG_FAIL 1
	#define  TEST_ARG_ERROR_FLAG_PASS 2

	#define  TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE  32  // 32BYTE
	#define  TEST_ARG_NIBBLE_WIDTH_BYTE  3  //3///BYTE

int do_ddr_test_dqs_window_sticky(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnterddr_test_dqs_window function  ddr_test_cmd 0x27 0x1080000 0x800000  0x40000000 0x800000 15 0x6  0 0 0 0 0 0 1/config\n");
	printf("\nddr_test_cmd 0x27 cs0_test_start  cs0_test_size  cs1_test_start  cs1_test_size  ns test_index_enable  nibble_mask0 nibble_mask1 nibble_mask2 dram_type channel_mode  config_register all_together--- watchdog should >15s\n");
	printf("\n ac write_dqs read_dqs can test together test_index_enable can enable kernel test \n");
	//   unsigned int   channel_b_en = 0;
	// unsigned int   reg_add=0;
	// unsigned int   reg_base_adj=0;
	unsigned int   temp_test_error=0;
	unsigned int  nibble_save_offset= 0;
	unsigned int  nibble_step= 0;
	unsigned int  nibble_max= 16;
	unsigned int  test_index_enable= 0;
	unsigned int  test_index= 0;
	unsigned int  test_index_max= 6;
	unsigned int   reg_value= 0;
	unsigned int  dram_type= 0;
	unsigned int  channel_mode= 0;
	unsigned int  kernel_watchdog_s= 20;//240;
	//	  unsigned int  finish_clear_flag= 0;
	unsigned int  config_register= 0;
	unsigned int   all_tighter_enable=0;
	unsigned int   error_flag_reg_add=0;
	char *string_print_flag=   " uboot-window-loop \n";
	//int argc2;
	//char     *  argv2[30];
	char *endp;
	char *buf;
	buf="";

	unsigned int   cs0_test_start= 0x1080000;
	unsigned int   cs0_test_size= DDR_CORSS_TALK_TEST_SIZE;
	unsigned int   cs1_test_start= 0;
	unsigned int   cs1_test_size= 0;
	unsigned int   enable_kernel_test=0;
	if (argc >1) {
		cs0_test_start = simple_strtoull_ddr(argv[1], &endp, 16);
		if (*argv[1] == 0 || *endp != 0)
		{
			cs0_test_start = 0x1080000;
		}
	}

	if (argc >2) {
		cs0_test_size = simple_strtoull_ddr(argv[2], &endp, 16);
		if (*argv[2] == 0 || *endp != 0)
		{
			cs0_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}
	}

	if (argc >3) {
		cs1_test_start = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			cs1_test_start = 0;
		}
	}
	if (argc >4) {
		cs1_test_size = simple_strtoull_ddr(argv[4], &endp, 16);
		if (*argv[4] == 0 || *endp != 0)
		{
			cs1_test_size = 0;
		}
	}

	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;
	ddr_test_size = cs0_test_size;
	if (argc >5) {
		watchdog_time_s = simple_strtoull_ddr(argv[5], &endp, 0);
		if (*argv[5] == 0 || *endp != 0)
		{
			watchdog_time_s= 20;
		}
	}
	printf("watchdog_time_s==%d\n",watchdog_time_s);

	if (argc >6) {
		test_index_enable = simple_strtoull_ddr(argv[6], &endp, 0);
		if (*argv[5] == 0 || *endp != 0)
		{
			test_index_enable= 0;
		}
	}
	printf("test_index_enable==0x%08x\n",test_index_enable);
	enable_kernel_test=(test_index_enable>>7)&1;
	if(enable_kernel_test){
		printf("enable kernel window test\n");
	}

	unsigned int   nibble_mask[3]= {0,0,0};
	if (argc >7) {
		nibble_mask[0] = simple_strtoull_ddr(argv[7], &endp, 0);
		if (*argv[7] == 0 || *endp != 0)
		{
			nibble_mask[0]= 0;
		}
	}
	printf("nibble_mask[0]==0x%08x\n",nibble_mask[0]);
	if (argc >8) {
		nibble_mask[1] = simple_strtoull_ddr(argv[8], &endp, 0);
		if (*argv[8] == 0 || *endp != 0)
		{
			nibble_mask[1]= 0;
		}
	}
	printf("nibble_mask[1]==0x%08x\n",nibble_mask[1]);
	if (argc >9) {
		nibble_mask[2] = simple_strtoull_ddr(argv[9], &endp, 0);
		if (*argv[9] == 0 || *endp != 0)
		{
			nibble_mask[2]= 0;
		}
	}
	printf("nibble_mask[2]==0x%08x\n",nibble_mask[2]);

	if (argc >10) {
		dram_type = simple_strtoull_ddr(argv[10], &endp, 0);
		if (*argv[10] == 0 || *endp != 0)
		{
			dram_type= 0;
		}
	}
	if (argc >11) {
		channel_mode = simple_strtoull_ddr(argv[11], &endp, 0);
		if (*argv[11] == 0 || *endp != 0)
		{
			channel_mode= 0;
		}
	}
	///*
	if (argc >12) {
		config_register = simple_strtoull_ddr(argv[12], &endp, 0);
		if (*argv[12] == 0 || *endp != 0)
		{
			config_register= 0;
		}
	}//*/
	///*
	if (argc >13) {
		all_tighter_enable = simple_strtoull_ddr(argv[13], &endp, 0);
		if (*argv[13] == 0 || *endp != 0)
		{
			all_tighter_enable= 0;
		}
	}//*/
	printf("all_tighter_enable==0x%08x\n",all_tighter_enable);

	if (argc >14) {
		error_flag_reg_add = simple_strtoull_ddr(argv[14], &endp, 0);
		if (*argv[14] == 0 || *endp != 0)
		{
			error_flag_reg_add= 0;
		}
	}
	printf("error_flag_reg_add==0x%08x\n",error_flag_reg_add);
	printf("\ntest use uboot sticky register\n");

	//DMC_STICKY_0
	char str[1024]="";
	//char str_temp1[1024]="";
	//char str_temp2[1024]="";
	volatile uint16_t  *num_arry=NULL;
	//volatile uint16_t  *p_num_arry;
	int i;
	//unsigned int stick_base_add=0;
	//uint32_t ddr_wr_8_16bit_on_32reg(uint32_t base_addr,uint32_t size,uint32_t offset_index,uint32_t value)

	sticky_reg_base_add=(DDR0_PUB_REG_BASE&0xffff0000)+((DMC_STICKY_G12A_0)&0xffff);
	//num_arry = (uint16_t *)(uint64_t )(sticky_reg_base_add);
	//num_arry=p_num_arry;
	for (i = 0; i < 64*4; i++) {
		num_arry[i]=ddr_rd_8_16bit_on_32reg(sticky_reg_base_add,8,i);
		if((i==0)||(i==32)||(i==(32+10*3))||(i==(32+10*3+16*3))||(i==(32+10*3+16*3+16*3)))
		{
			printf("\n numarry[%d]" ,i);
		}
		printf(" %d ",num_arry[i]);
	}

	/*
	#define  TEST_ARG_1_CMD0  1
	//#define  TEST_ARG_1_CMD1  1
	#define  TEST_ARG_2_STEP  2
	#define  TEST_ARG_3_FREQ  3
	#define  TEST_ARG_4_STEP_STATUS  4
	#define  TEST_ARG_5_BOOT_TIMES  5
	#define  TEST_ARG_6_LCDLR_TEMP_COUNT 6
	#define  TEST_ARG_7_DMC_STICKY_MAGIC  7
	*/

	uint16_t test_left_max_init_value =32;  
	uint16_t test_right_max_init_value =32;  
	uint16_t test_boot_times =0;  
	uint16_t test_ddr_frequency =0;  
	//uint16_t temp_sub_value_a =0;  
	/*
	uint16_t test_arg_1_cmd0 =1;  //master cmd
	uint16_t test_arg_1_cmd1 =0;  //min cmd
	uint16_t test_arg_2_step =0; //step 0  init  -1 lane0 w min  -2 lane0 w max -3 lane0 r min    4 lane0 r max -----5 lane1 w min ...
	uint16_t test_arg_3_freq =0;
	uint16_t test_arg_4_step_status =0; //uboot test we should read error then done status.  0 no test 1 ongoing 2 this step done  fail or pass
	test_arg_0_cmd0=num_arry[0];
	test_arg_1_cmd1=num_arry[1];
	test_arg_2_step=num_arry[2];
	test_arg_3_freq=num_arry[3];
	test_arg_4_step_status=num_arry[4];
	//boot_times=num_arry[5];
	//lcdlr_temp_count=num_arry[6];
	*/
	printf("\nTEST_ARG_0_DMC_STICKY_MAGIC==0x%08x\n",num_arry[TEST_ARG_0_DMC_STICKY_MAGIC]);
	printf("\nTEST_ARG_1_CMD0==0x%08x\n",num_arry[TEST_ARG_1_CMD0]);
	printf("TEST_ARG_2_STEP==0x%08x\n",num_arry[TEST_ARG_2_STEP]);
	printf("TEST_ARG_3_ALL_TIGHTER==0x%08x\n",num_arry[TEST_ARG_3_ALL_TIGHTER]);
	printf("TEST_ARG_FREQ_NIBBLE_L==0x%08x\n",num_arry[TEST_ARG_FREQ_NIBBLE_L]);
	printf("TEST_ARG_FREQ_NIBBLE_H==0x%08x\n",num_arry[TEST_ARG_FREQ_NIBBLE_H]);
	printf("TEST_ARG_BOOT_TIMES_L==0x%08x\n",num_arry[TEST_ARG_BOOT_TIMES_L]);
	printf("TEST_ARG_BOOT_TIMES_H==0x%08x\n",num_arry[TEST_ARG_BOOT_TIMES_H]);
	printf("TEST_ARG_ERROR_FLAG==0x%08x\n",num_arry[TEST_ARG_ERROR_FLAG]);

	printf("TEST_ARG_FREQ==%dM\n",(num_arry[TEST_ARG_FREQ_NIBBLE_H]<<8)|(num_arry[TEST_ARG_FREQ_NIBBLE_L]<<0));
	printf("TEST_ARG_BOOT_TIMES==%d\n",(num_arry[TEST_ARG_BOOT_TIMES_H]<<8)|(num_arry[TEST_ARG_BOOT_TIMES_L]<<0));
	test_boot_times=(num_arry[TEST_ARG_BOOT_TIMES_H]<<8)|(num_arry[TEST_ARG_BOOT_TIMES_L]<<0);
	test_ddr_frequency=(num_arry[TEST_ARG_FREQ_NIBBLE_H]<<8)|(num_arry[TEST_ARG_FREQ_NIBBLE_L]<<0);
	if((num_arry[TEST_ARG_0_DMC_STICKY_MAGIC]==(DMC_STICKY_UBOOT_WINDOW_MAGIC_1&0xff))&&
	(num_arry[TEST_ARG_1_CMD0]==(DMC_STICKY_UBOOT_WINDOW_MAGIC_1&0xff)) ) //for check magic number make sume enter test command
	{
		//num_arry[TEST_ARG_5_BOOT_TIMES]++;
		test_boot_times++;
		num_arry[TEST_ARG_BOOT_TIMES_L]=test_boot_times&0xff;
		num_arry[TEST_ARG_BOOT_TIMES_H]=(test_boot_times>>8)&0xff;
		ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_BOOT_TIMES_L,num_arry[TEST_ARG_BOOT_TIMES_L]);
		ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_BOOT_TIMES_H,num_arry[TEST_ARG_BOOT_TIMES_H]);

		if( test_ddr_frequency!=global_ddr_clk)  //
		{
			printf("running ddr freq==%d,but test freq is%d,will reboot use d2pll \n",global_ddr_clk,test_ddr_frequency);
			sprintf(str,"d2pll  %d",test_ddr_frequency);
			printf("\nstr=%s\n",str);
			run_command(str,0);
			while(1);
		}
	}
	else
	{
		test_boot_times=0;
		num_arry[TEST_ARG_BOOT_TIMES_L]=test_boot_times&0xff;
		num_arry[TEST_ARG_BOOT_TIMES_H]=(test_boot_times>>8)&0xff;
		ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_BOOT_TIMES_L,num_arry[TEST_ARG_BOOT_TIMES_L]);
		ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_BOOT_TIMES_H,num_arry[TEST_ARG_BOOT_TIMES_H]);
		num_arry[TEST_ARG_2_STEP]=0;
		ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_2_STEP,num_arry[TEST_ARG_2_STEP]);
	}
	printf("test_sticky is not magic number,boot times==%d\n",test_boot_times);

	//if(config_register==1)
	{
		wr_reg((sticky_reg_base_add+TEST_ARG_CS0_TEST_START_INDEX), cs0_test_start);
		wr_reg((sticky_reg_base_add+TEST_ARG_CS0_TEST_SIZE_INDEX), cs0_test_size);
		wr_reg((sticky_reg_base_add+TEST_ARG_CS1_TEST_START_INDEX), cs1_test_start);
		wr_reg((sticky_reg_base_add+TEST_ARG_CS1_TEST_SIZE_INDEX), cs1_test_size);
		{
			num_arry[TEST_ARG_WATCHDOG_TIME_SIZE_INDEX]=watchdog_time_s&0xff;
			num_arry[TEST_ARG_WATCHDOG_TIME_SIZE_INDEX+1]=(watchdog_time_s>>8)&0xff;
			ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_WATCHDOG_TIME_SIZE_INDEX,num_arry[TEST_ARG_WATCHDOG_TIME_SIZE_INDEX]);
			ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,(TEST_ARG_WATCHDOG_TIME_SIZE_INDEX+1),num_arry[TEST_ARG_WATCHDOG_TIME_SIZE_INDEX+1]);
		}
		num_arry[TEST_ARG_TEST_INDEX_ENALBE_INDEX]=test_index_enable;
		ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_TEST_INDEX_ENALBE_INDEX,num_arry[TEST_ARG_TEST_INDEX_ENALBE_INDEX]);
		if (config_register == 1)
			{
		num_arry[TEST_ARG_2_STEP]=0;
		ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_2_STEP,num_arry[TEST_ARG_2_STEP]);
			}
		num_arry[TEST_ARG_3_ALL_TIGHTER]=all_tighter_enable;
		ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_3_ALL_TIGHTER,num_arry[TEST_ARG_3_ALL_TIGHTER]);
	}

	if(( num_arry[TEST_ARG_2_STEP])==0)
	{
		{
			num_arry[TEST_ARG_0_DMC_STICKY_MAGIC]=DMC_STICKY_UBOOT_WINDOW_MAGIC_1;
			ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_0_DMC_STICKY_MAGIC,num_arry[TEST_ARG_0_DMC_STICKY_MAGIC]);
			num_arry[TEST_ARG_1_CMD0]=DMC_STICKY_UBOOT_WINDOW_MAGIC_1;
			ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_1_CMD0,num_arry[TEST_ARG_1_CMD0]);
			num_arry[TEST_ARG_2_STEP]=1;
			ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_2_STEP,num_arry[TEST_ARG_2_STEP]);
			{
				test_boot_times=0;
				num_arry[TEST_ARG_BOOT_TIMES_L]=test_boot_times&0xff;
				num_arry[TEST_ARG_BOOT_TIMES_H]=(test_boot_times>>8)&0xff;
				ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_BOOT_TIMES_L,num_arry[TEST_ARG_BOOT_TIMES_L]);
				ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_BOOT_TIMES_H,num_arry[TEST_ARG_BOOT_TIMES_H]);
			}
			{
				test_ddr_frequency=global_ddr_clk;
				num_arry[TEST_ARG_FREQ_NIBBLE_L]=test_ddr_frequency&0xff;
				num_arry[TEST_ARG_FREQ_NIBBLE_H]=(test_ddr_frequency>>8)&0xff;
				ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_FREQ_NIBBLE_L,num_arry[TEST_ARG_FREQ_NIBBLE_L]);
				ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_FREQ_NIBBLE_H,num_arry[TEST_ARG_FREQ_NIBBLE_H]);
			}

			num_arry[TEST_ARG_ERROR_FLAG]=TEST_ARG_ERROR_FLAG_NULL;
			ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_ERROR_FLAG,num_arry[TEST_ARG_ERROR_FLAG]);
		}


		for (nibble_step = 0; nibble_step < 72; nibble_step++)
		{
			//if(lane_step%2)
			{
				//num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+(nibble_step*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_ORG]=0xffff;
				test_left_max_init_value=16;
				test_right_max_init_value=16;
				if(nibble_step<10)
				{
					test_left_max_init_value=32;
					test_right_max_init_value=32;
				}
					num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+(nibble_step*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN]=test_left_max_init_value;
					num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+(nibble_step*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX]=test_right_max_init_value;
					num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+(nibble_step*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS]=0;//0
					//ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,i,num_arry[i]);
			}

			{
				if (nibble_step<32)
				{
					if(((nibble_mask[0])>>nibble_step)&1)
						num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+nibble_step*TEST_ARG_NIBBLE_WIDTH_BYTE+LCD_BDLR_STATUS]=4;
				}
				else if (nibble_step<64)
				{
					if(((nibble_mask[1])>>(nibble_step-32))&1)
						num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+nibble_step*TEST_ARG_NIBBLE_WIDTH_BYTE+LCD_BDLR_STATUS]=4;
				}
				else if (nibble_step<96)
				{
					if(((nibble_mask[2])>>(nibble_step-64))&1)
						num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+nibble_step*TEST_ARG_NIBBLE_WIDTH_BYTE+LCD_BDLR_STATUS]=4;
				}
				if(all_tighter_enable)
				{
					if((nibble_step==0)||(nibble_step==10)||(nibble_step==(10+16)))
						num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+nibble_step*TEST_ARG_NIBBLE_WIDTH_BYTE+LCD_BDLR_STATUS]=0;
					else
						num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+nibble_step*TEST_ARG_NIBBLE_WIDTH_BYTE+LCD_BDLR_STATUS]=4;
				}
			}
		//num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+(nibble_step*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS]=0xffff;//0
		}

		{
			//printf("..num_arry[TEST_ARG_1_CMD0]=%d\n",num_arry[TEST_ARG_1_CMD0]);
			for (i = TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE; i < 72*TEST_ARG_NIBBLE_WIDTH_BYTE; i++) {
				//	num_arry[i]=0;
				ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,i,num_arry[i]);
				//	ddr_wr_16bit_on_32reg((sticky_reg_base_add+(i<<1)),num_arry[i]);
				//	printf("num_arry[0x%08x] ==0x%08x\n",i,num_arry[i]);
			}

			num_arry[TEST_ARG_2_STEP]=1;
			ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_2_STEP,	num_arry[TEST_ARG_2_STEP]);
		}

	}

if (all_tighter_enable)
{
	for (nibble_step = 0; nibble_step < 72; nibble_step++)
	{
		if ((nibble_step == 0) || (nibble_step == 10) || (nibble_step == (10+16)))
		{
			//num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+nibble_step*TEST_ARG_NIBBLE_WIDTH_BYTE+LCD_BDLR_STATUS]=0;
		}
		else
			num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+nibble_step*TEST_ARG_NIBBLE_WIDTH_BYTE+LCD_BDLR_STATUS]=4;
	}
}

if(config_register==1)
{
	num_arry[TEST_ARG_2_STEP]=0;
	ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_2_STEP,	num_arry[TEST_ARG_2_STEP]);
}

if(( num_arry[TEST_ARG_2_STEP]))
{
for(test_index=num_arry[TEST_ARG_2_STEP];test_index<test_index_max ;test_index++ )
{
	printf("\ntest_index=%d\n",test_index);
	if((((test_index_enable)>>(test_index-1))&1)==0)
	{
		num_arry[TEST_ARG_2_STEP]=((num_arry[TEST_ARG_2_STEP])+1);//why can not use ++
		ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_2_STEP,	num_arry[TEST_ARG_2_STEP]);
		continue;
	}
	{
		if(test_index==DMC_TEST_WINDOW_INDEX_ATXDLY)
		{
			nibble_save_offset=0;
			nibble_max=10;
			nibble_mask[0]= 0x30;
			if((dram_type==CONFIG_DDR_TYPE_LPDDR3))
			{
				nibble_mask[0]= 0x3e3;
			}
			if((dram_type==CONFIG_DDR_TYPE_LPDDR4))
			{
				nibble_mask[0]= 0x273;
				if((channel_mode==CONFIG_DDR0_32BIT_RANK01_CH0))
					nibble_mask[0]= 0x3f3;
			}
			test_left_max_init_value=64;
			test_right_max_init_value=64;
		}
		if(test_index==DMC_TEST_WINDOW_INDEX_TXDQSDLY)
		{
			nibble_save_offset=10;
			nibble_max=16;
			if((cs1_test_size==0))
			{
				nibble_mask[0]= 0xff00;
			}
			test_left_max_init_value=16;
			test_right_max_init_value=16;
		}
		if(test_index==DMC_TEST_WINDOW_INDEX_RXCLKDLY)
		{
			nibble_save_offset=(10)+(16);
			if((cs1_test_size==0))
			{
				nibble_mask[0]= 0xff00;
			}
			nibble_max=16;
			test_left_max_init_value=16;
			test_right_max_init_value=16;
		}
		if(test_index==DMC_TEST_WINDOW_INDEX_TXDQDLY)
		{
			nibble_save_offset=0;
			nibble_max=72;
			if((cs1_test_size==0))
			{
				nibble_mask[1]= 0xfffffff0;
				nibble_mask[2]= 0xffffffff;
			}
			test_left_max_init_value=16;
			test_right_max_init_value=16;
		}
		if(test_index==DMC_TEST_WINDOW_INDEX_RXPBDLY)
		{
			nibble_save_offset=0;
			nibble_max=72;
			if((cs1_test_size==0))
			{
				nibble_mask[1]= 0xfffffff0;
				nibble_mask[2]= 0xffffffff;
			}
		
		test_left_max_init_value=64;
		test_right_max_init_value=64;}
		//nibble_max=8;//	
		// if(nibble_max>30)  can not over sticky register size
		// 	nibble_max=30;
		for ((nibble_step=0);(nibble_step<nibble_max);(nibble_step++))
		{
			if (nibble_step<32)
			{
				if(((nibble_mask[0])>>nibble_step)&1)
					num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+(nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE+LCD_BDLR_STATUS]=4;
			}
			else if (nibble_step<64)
			{
				if(((nibble_mask[1])>>(nibble_step-32))&1)
					num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+(nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE+LCD_BDLR_STATUS]=4;
			}
			else if (nibble_step<96)
			{
				if(((nibble_mask[2])>>(nibble_step-64))&1)
					num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+(nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE+LCD_BDLR_STATUS]=4;
			}
			ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
			(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS),	
			num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]);
		}
	}

{
	for ((nibble_step=0);(nibble_step<nibble_max);(nibble_step++))
	{
		if(num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]==4)
			continue;
		printf("nibble_step ==%d\n",nibble_step);

		if(test_index==DMC_TEST_WINDOW_INDEX_TXDQSDLY)
		{
			if(nibble_step%2)
			{
				//nibble_save_offset
				//num_arry[TEST_ARG_2_STEP]=1;
				ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
				(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN),	
				num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step-1+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)]);
				ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
				(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX),	
				num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step-1+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)]);
				ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
				(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS),	
				num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step-1+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]);
				//nibble_step++;
				continue;
			}
		}
		test_start_addr=cs0_test_start;
		ddr_test_size=cs0_test_size;
		if(test_index==DMC_TEST_WINDOW_INDEX_ATXDLY)
		{
			test_start_addr=cs0_test_start;
			ddr_test_size=cs0_test_size;
		}

		if(test_index==DMC_TEST_WINDOW_INDEX_TXDQSDLY)
		{
			if(nibble_step>7)
			{
				test_start_addr=cs1_test_start;
				ddr_test_size=cs1_test_size;
			}
		}
		if(test_index==DMC_TEST_WINDOW_INDEX_RXCLKDLY)
		{
			if(nibble_step>7)
			{
				test_start_addr=cs1_test_start;
				ddr_test_size=cs1_test_size;
			}
		}
		if(test_index==DMC_TEST_WINDOW_INDEX_TXDQDLY)
		{
			if(nibble_step>35)
			{
				test_start_addr=cs1_test_start;
				ddr_test_size=cs1_test_size;
			}
		}
		if(test_index==DMC_TEST_WINDOW_INDEX_RXPBDLY)
		{
			if(nibble_step>35)
			{
				test_start_addr=cs1_test_start;
				ddr_test_size=cs1_test_size;
			}
		}
		{
			if (nibble_step<32)
			{
				nibble_mask[0]=((0xffffffff)&(~(1<<nibble_step)));
				nibble_mask[1]=((0xffffffff));
				nibble_mask[2]=((0xffffffff));
			}
			else if (nibble_step<64)
			{
				nibble_mask[0]=((0xffffffff));
				nibble_mask[1]=((0xffffffff)&(~(1<<(nibble_step-32))));
				nibble_mask[2]=((0xffffffff));
			}
			else if (nibble_step<96)
			{
				nibble_mask[0]=((0xffffffff));
				nibble_mask[1]=((0xffffffff));
				nibble_mask[2]=((0xffffffff)&(~(1<<(nibble_step-64))));
			}
		}
		if (all_tighter_enable)
		{
			if (test_index == DMC_TEST_WINDOW_INDEX_ATXDLY)
			{
				nibble_save_offset=0;
				nibble_max=10;
				nibble_mask[0]= 0x30;
				nibble_mask[1]= 0;
				nibble_mask[2]= 0;
				if ((dram_type == CONFIG_DDR_TYPE_LPDDR3))
				{
					nibble_mask[0]= 0x3e3;
				}
				if ((dram_type == CONFIG_DDR_TYPE_LPDDR4))
				{
					nibble_mask[0]= 0x273;
					if ((channel_mode == CONFIG_DDR0_32BIT_RANK01_CH0))
						nibble_mask[0]= 0x3f3;
				}
			}
			else
			{
				nibble_mask[0]= 0;
				nibble_mask[1]= 0;
				nibble_mask[2]= 0;
			}
		}

		ddr_test_watchdog_enable(watchdog_time_s); //s
		printf("\nenable %ds watchdog \n",watchdog_time_s);
		if((num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]==0xffff)
		||(num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]==0)
		||(num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]==1) )
		{
			printf("\nnibble_step  ==%d ", nibble_step);
			if((num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]==0xffff)
			||(num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]==0))
			{
				num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]=1;
				ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
				(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS),	
				num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]);

				if(num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)]==0)
				{
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]=2;
					ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
					(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS),	
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]);
					run_command("reset",0);
				}
				{
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)]=
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)]-1;
					ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
					(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN),	
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)]);
				}

				{
					num_arry[TEST_ARG_ERROR_FLAG]=TEST_ARG_ERROR_FLAG_FAIL;
					ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
					TEST_ARG_ERROR_FLAG,	
					num_arry[TEST_ARG_ERROR_FLAG]);
				}

				//if(all_tighter_enable)
				//	sprintf(str,"ddr_g12_offset_data  %d  0x%08x 0x%08x  0x%08x  %d %d",test_index,0,0,0,DDR_PARAMETER_LEFT,
				//	num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)]);
				//else
				sprintf(str,"ddr_g12_offset_data  %d  0x%08x 0x%08x  0x%08x  %d %d",test_index,nibble_mask[0],nibble_mask[1],nibble_mask[2],DDR_PARAMETER_LEFT,
				num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)]);
				printf("\nstr=%s\n",str);
				ddr_test_watchdog_clear();
				run_command(str,0);

				temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
				if (all_tighter_enable && cs1_test_size)
				{
					test_start_addr=cs1_test_start;
					ddr_test_size=cs1_test_size;
					temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
					test_start_addr=cs0_test_start;
					ddr_test_size=cs0_test_size;
					//temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
				}
				if(temp_test_error)
				{
					run_command("reset",0);
				}
				else
				{
					//	
					if(!enable_kernel_test)
					{
						num_arry[TEST_ARG_ERROR_FLAG]=TEST_ARG_ERROR_FLAG_PASS;
						ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
						TEST_ARG_ERROR_FLAG,	
						num_arry[TEST_ARG_ERROR_FLAG]);
						run_command("reset",0);
					}
					else
					{
						ddr_test_watchdog_enable(kernel_watchdog_s); //s
						printf("\nenable %ds watchdog \n",kernel_watchdog_s);
						run_command("run storeboot",0);
					}
					/*	
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]=2;
					ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
					(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS),	
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]);
					run_command("reset",0);
					*/
				}
			}
			else if (num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]==1)
			{//go on find left edge

				if(num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)]==0)
				{
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]=2;
					ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
					(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS),	
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]);
					run_command("reset",0);
				}

				if((num_arry[TEST_ARG_ERROR_FLAG])==TEST_ARG_ERROR_FLAG_PASS)
				{
					{
						num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]=2;
						ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
						(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS),	
						num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]);
					}
					{
						num_arry[TEST_ARG_ERROR_FLAG]=TEST_ARG_ERROR_FLAG_NULL;
						ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
						TEST_ARG_ERROR_FLAG,	
						num_arry[TEST_ARG_ERROR_FLAG]);
					}
					run_command("reset",0);
				}
				if((num_arry[TEST_ARG_ERROR_FLAG])==TEST_ARG_ERROR_FLAG_FAIL)
				{
					{
						num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)]=
						num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)]-1;
						ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
						(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN),	
						num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)]);
					}
					{
						num_arry[TEST_ARG_ERROR_FLAG]=TEST_ARG_ERROR_FLAG_FAIL;
						ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
						TEST_ARG_ERROR_FLAG,	
						num_arry[TEST_ARG_ERROR_FLAG]);
					}
					sprintf(buf, "0x%08x", ( num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)]));
					printf( "%s", buf);
				//	if(all_tighter_enable)
				//		sprintf(str,"ddr_g12_offset_data  %d  0x%08x 0x%08x  0x%08x  %d %d",test_index,0,0,0,DDR_PARAMETER_LEFT,
				//		( num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)]));
				//	else
					sprintf(str,"ddr_g12_offset_data  %d  0x%08x 0x%08x  0x%08x  %d %d",test_index,nibble_mask[0],nibble_mask[1],nibble_mask[2],DDR_PARAMETER_LEFT,
					( num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)]));
					printf("\nstr=%s\n",str);
					ddr_test_watchdog_clear();
					run_command(str,0);
					temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
					if (all_tighter_enable && cs1_test_size)
					{
						test_start_addr=cs1_test_start;
						ddr_test_size=cs1_test_size;
						temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
						test_start_addr=cs0_test_start;
						ddr_test_size=cs0_test_size;
						//temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
					}
					if(temp_test_error)
					{
						run_command("reset",0);
					}
					else
					{
						//	
						if(!enable_kernel_test)
						{
							num_arry[TEST_ARG_ERROR_FLAG]=TEST_ARG_ERROR_FLAG_PASS;
							ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
							TEST_ARG_ERROR_FLAG,	
							num_arry[TEST_ARG_ERROR_FLAG]);
							run_command("reset",0);
						}
						else
						{
							ddr_test_watchdog_enable(kernel_watchdog_s); //s
							printf("\nenable %ds watchdog \n",kernel_watchdog_s);
							run_command("run storeboot",0);
						}
						/*	
						num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]=2;
						ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
						(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS),	
						num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]);
						run_command("reset",0);
						*/
					}
				}
			}
			//	run_command("reset",0);
		}
		
		if((num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]==2)||
		(num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]==3))
		{
			printf("\nnibble_step  ==%d ", nibble_step);
			if((num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]==2)
			||(num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]==2))
			{
				num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]=3;
				ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
				(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS),	
				num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]);

				if(num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)]==0)
				{
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]=4;
					ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
					(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS),	
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]);
					run_command("reset",0);
				}
				{
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)]=
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)]-1;
					ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
					(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX),	
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)]);
				}

				{
					num_arry[TEST_ARG_ERROR_FLAG]=TEST_ARG_ERROR_FLAG_FAIL;
					ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
					TEST_ARG_ERROR_FLAG,	
					num_arry[TEST_ARG_ERROR_FLAG]);
				}
			//	if(all_tighter_enable)
			//	sprintf(str,"ddr_g12_offset_data  %d  0x%08x 0x%08x  0x%08x  %d %d",test_index,0,0,0,DDR_PARAMETER_RIGHT,
			//	num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)]);
			//	else
				sprintf(str,"ddr_g12_offset_data  %d  0x%08x 0x%08x  0x%08x  %d %d",test_index,nibble_mask[0],nibble_mask[1],nibble_mask[2],DDR_PARAMETER_RIGHT,
				num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)]);
				printf("\nstr=%s\n",str);
				ddr_test_watchdog_clear();
				run_command(str,0);
				temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
				if (all_tighter_enable && cs1_test_size)
				{
					test_start_addr=cs1_test_start;
					ddr_test_size=cs1_test_size;
					temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
					test_start_addr=cs0_test_start;
					ddr_test_size=cs0_test_size;
					//temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
				}
			//	temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
			//	temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
				if(temp_test_error)
				{
					run_command("reset",0);
				}
				else
				{
					//	
					if(!enable_kernel_test)
					{
						num_arry[TEST_ARG_ERROR_FLAG]=TEST_ARG_ERROR_FLAG_PASS;
						ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
						TEST_ARG_ERROR_FLAG,	
						num_arry[TEST_ARG_ERROR_FLAG]);
						run_command("reset",0);
					}
					else
					{
						ddr_test_watchdog_enable(kernel_watchdog_s); //s
						printf("\nenable %ds watchdog \n",kernel_watchdog_s);
						run_command("run storeboot",0);
					}
					/*	
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]=2;
					ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
					(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS),	
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]);
					run_command("reset",0);
					*/
				}
			}
			else if (num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]==3)
			{//go on find left edge
				if(num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)]==0)
				{
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]=4;
					ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
					(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS),	
					num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]);
					run_command("reset",0);
				}

				if((num_arry[TEST_ARG_ERROR_FLAG])==TEST_ARG_ERROR_FLAG_PASS)
				{
					{
						num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]=4;
						ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
						(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS),	
						num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]);
					}
					{
						num_arry[TEST_ARG_ERROR_FLAG]=TEST_ARG_ERROR_FLAG_NULL;
						ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
						TEST_ARG_ERROR_FLAG,	
						num_arry[TEST_ARG_ERROR_FLAG]);
					}
					run_command("reset",0);
				}
				if((num_arry[TEST_ARG_ERROR_FLAG])==TEST_ARG_ERROR_FLAG_FAIL)
				{
					{
						num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)]=
						num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)]-1;
						ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
						(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX),	
						num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)]);
					}
					{
						num_arry[TEST_ARG_ERROR_FLAG]=TEST_ARG_ERROR_FLAG_FAIL;
						ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
						TEST_ARG_ERROR_FLAG,	
						num_arry[TEST_ARG_ERROR_FLAG]);
					}
					sprintf(buf, "0x%08x", ( num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)]));
					printf( "%s", buf);
				//	if(all_tighter_enable)
				//	sprintf(str,"ddr_g12_offset_data  %d  0x%08x 0x%08x  0x%08x  %d %d",test_index,0,0,0,DDR_PARAMETER_RIGHT,
				//	( num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)]));
				//	else
					sprintf(str,"ddr_g12_offset_data  %d  0x%08x 0x%08x  0x%08x  %d %d",test_index,nibble_mask[0],nibble_mask[1],nibble_mask[2],DDR_PARAMETER_RIGHT,
					( num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)]));
					printf("\nstr=%s\n",str);
					ddr_test_watchdog_clear();
					run_command(str,0);
					temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
					if (all_tighter_enable && cs1_test_size)
					{
						test_start_addr=cs1_test_start;
						ddr_test_size=cs1_test_size;
						temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
						test_start_addr=cs0_test_start;
						ddr_test_size=cs0_test_size;
						//temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
					}
					//temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
					//temp_test_error=temp_test_error+ddr_test_s_cross_talk_pattern(ddr_test_size);
					if(temp_test_error)
					{
						run_command("reset",0);
					}
					else
					{
						if(!enable_kernel_test)
						{
							num_arry[TEST_ARG_ERROR_FLAG]=TEST_ARG_ERROR_FLAG_PASS;
							ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
							TEST_ARG_ERROR_FLAG,	
							num_arry[TEST_ARG_ERROR_FLAG]);
							run_command("reset",0);
						}
						else
						{
							ddr_test_watchdog_enable(kernel_watchdog_s); //s
							printf("\nenable %ds watchdog \n",kernel_watchdog_s);
							run_command("run storeboot",0);
						}

						/*	
						num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]=2;
						ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,
						(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS),	
						num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_STATUS)]);
						run_command("reset",0);
						*/
					}
				}
			}
			//	run_command("reset",0);
		}

		ddr_test_watchdog_disable(); //s
		{
			printf("close  watchdog\n");
		}
	}

	printf("11num_arry[TEST_ARG_2_STEP]==%d\n",num_arry[TEST_ARG_2_STEP]);
	num_arry[TEST_ARG_2_STEP]=(num_arry[TEST_ARG_2_STEP])+1;
	ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_2_STEP,	num_arry[TEST_ARG_2_STEP]);
	printf("22num_arry[TEST_ARG_2_STEP]==%d\n",num_arry[TEST_ARG_2_STEP]);
	//}

	ddr_test_watchdog_disable(); //s
	printf("close  watchdog\n");
	//}
	//for(test_index=1;test_index<test_index_max ;test_index++ )
	{
		unsigned int  ui_1_32_100step= 0;
		unsigned int  bdlr_100step= 0;
		ui_1_32_100step=(1000000*100/(global_ddr_clk*2*32));
		bdlr_100step=get_bdlr_100step(global_ddr_clk);
		//if((((test_index_enable)>>(test_index-1))&1)==0)

		printf("\nacmdlr=0x%08x-->dec %d,ddr clk==%d,bdlr_100step=%d ps,ui_1_32_100step=%d ps,\n",0,0,global_ddr_clk,
		bdlr_100step,ui_1_32_100step);

		printf("\n test result index==");
		printf("%08d",test_index);

		if (test_index == DMC_TEST_WINDOW_INDEX_ATXDLY) {
			printf(" ac window:");
			printf(" step_size ps==");
			printf("%08d",ui_1_32_100step);
			printf("/100 ps ");
		}
		if (test_index == DMC_TEST_WINDOW_INDEX_TXDQSDLY) {
			printf(" txdqs window:");
			printf(" step_size ps==");
			printf("%08d",ui_1_32_100step);
			printf("/100 ps ");
		}
		if (test_index == DMC_TEST_WINDOW_INDEX_RXCLKDLY) {
			printf(" rx_clk_window:");
			printf(" step_size ps==");
			printf("%08d",ui_1_32_100step);
			printf("/100 ps ");
		}
		if (test_index == DMC_TEST_WINDOW_INDEX_TXDQDLY) {
			printf(" tx_bit_dq_window:");
			printf(" step_size ps==");
			printf("%08d",ui_1_32_100step);
			printf("/100 ps ");
		}
		if (test_index == DMC_TEST_WINDOW_INDEX_RXPBDLY) {
			printf(" rx_bit_dq_window");
			printf(" step_size ps==");
			printf("%08d",bdlr_100step);//480ps
			printf("/100 ps ");
		}
		printf("ddr clk frequency : ");
		printf("%08d",(global_ddr_clk));
		printf("Mhz ");
		printf(string_print_flag);
		printf("index    org      min      max      left     right    dec vref_range vref_count");
		printf(string_print_flag);

		char delay_left_margin=0;
		char delay_right_margin=0;
		if (all_tighter_enable == 1)
		{
			nibble_max=1;
		}
		for ( nibble_step=0;nibble_step<nibble_max;nibble_step++)
		{
			//serial_put_dec_out_align(delay_martix[count].add_index,8);
			printf("%08d",nibble_step);
			printf(" ");
			printf("%08d",0);
			//serial_puts(" ");
			//if ((test_index == DMC_TEST_WINDOW_INDEX_TXDQSDLY) )
			{
				{
					printf(" ");
					printf("%08d",0//num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET+nibble_step*TEST_ARG_NIBBLE_WIDTH+LCD_BDLR_MIN]
						);
				}
			}
			{
				{
					printf(" ");
					printf("%08d",0//num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET+nibble_step*TEST_ARG_NIBBLE_WIDTH+LCD_BDLR_MAX]
						);
				}
			}
				
			//	delay_left_margin=((num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET+nibble_step*TEST_ARG_NIBBLE_WIDTH+LCD_BDLR_ORG]>num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET+nibble_step*TEST_ARG_NIBBLE_WIDTH+LCD_BDLR_MIN])?
			//		(num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET+nibble_step*TEST_ARG_NIBBLE_WIDTH+LCD_BDLR_ORG]-num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET+nibble_step*TEST_ARG_NIBBLE_WIDTH+LCD_BDLR_MIN]):0);
			//	delay_right_margin=((num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET+nibble_step*TEST_ARG_NIBBLE_WIDTH+LCD_BDLR_MAX]>num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET+nibble_step*TEST_ARG_NIBBLE_WIDTH+LCD_BDLR_ORG])?
			//		(num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET+nibble_step*TEST_ARG_NIBBLE_WIDTH+LCD_BDLR_MAX]-num_arry[TEST_ARG_NIBBLE_SAVE_OFFSET+nibble_step*TEST_ARG_NIBBLE_WIDTH+LCD_BDLR_ORG]):0);
			delay_left_margin=num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MIN)];
			delay_right_margin=num_arry[(TEST_ARG_NIBBLE_SAVE_OFFSET_BYTE+((nibble_step+nibble_save_offset)*TEST_ARG_NIBBLE_WIDTH_BYTE)+LCD_BDLR_MAX)];
			printf(" ");
			printf("%08d",delay_left_margin);

			//serial_put_dec_out_align((delay_martix[count].delay_org>delay_martix[count].delay_min)?(delay_martix[count].delay_org-delay_martix[count].delay_min):0,8);
			printf(" ");
			printf("%08d",delay_right_margin);
			//serial_put_dec_out_align((delay_martix[count].delay_max>delay_martix[count].delay_org)?(delay_martix[count].delay_max-delay_martix[count].delay_org):0,8);
			printf("     ");
			printf("%08d",0);
			printf("   ");
			printf("%08d",0);
			printf("   2d-eye"); //p_dev->cur_type
			printf(" dramtype ");
			printf("%08d",0);
			printf(" ");
			printf("%08d",(global_ddr_clk));
			printf(" M bdl ");
			printf("%08d",bdlr_100step);//480ps
			printf(" /100 ps ");
			printf("1/32step== ");
			printf("%08d",ui_1_32_100step);
			printf(" /100 ps ");
			//serial_puts("bit_init_value ");
			//serial_put_dec_out_align((p_dev->ddr_gloabl_message.stick_dmc_ddr_window_test_read_per_bit_init_value),4);
			//if (test_index == DMC_TEST_WINDOW_INDEX_TXDQSDLY){
			//serial_puts("txdqsdly_second_tune_min_value ");
			//serial_put_dec_out_align(txdqsdly_second_tune_value[count],4);
				//}
			printf(string_print_flag);
			//serial_puts("\n");
		}
	}
}
}
}

	if(config_register==1)
	{
		if(num_arry[TEST_ARG_2_STEP]==0)
		{
			num_arry[TEST_ARG_2_STEP]=1;
			ddr_wr_8_16bit_on_32reg(sticky_reg_base_add,8,TEST_ARG_2_STEP,	num_arry[TEST_ARG_2_STEP]);
		}
	}

		if ((enable_kernel_test) && (num_arry[TEST_ARG_2_STEP]>1))
		run_command("run storeboot",0);
	return reg_value;
}
#else
int do_ddr_test_dqs_window_sticky(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	printf("\nEnterddr_test_dqs_window function\n");
	printf("\nddr_test_cmd 0x27 a 0 0x80000 ns lane_disable add_test_size   --- watchdog should >15s\n");
	unsigned int   channel_a_en = 0;
	unsigned int   channel_b_en = 0;
	// unsigned int   reg_add=0;
	// unsigned int   reg_base_adj=0;

	unsigned int   lane_step= 0;
	unsigned int   reg_value= 0;
	//int argc2;
	//char     *  argv2[30];
	char *endp;
	char *buf;
	buf="";

	if (argc == 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0))

		{channel_a_en = 1;
		}
		else if   ((strcmp(argv[1], "b") == 0)||(strcmp(argv[1], "B") == 0))

		{channel_b_en = 1;
		}


	}
	if (argc > 2)
	{
		if ((strcmp(argv[1], "a") == 0) || (strcmp(argv[1], "A") == 0) || (strcmp(argv[2], "a") == 0) || (strcmp(argv[2], "A") == 0))

		{channel_a_en = 1;
		}
		if   ((strcmp(argv[1], "b") == 0) || (strcmp(argv[1], "B") == 0) || (strcmp(argv[2], "b") == 0) || (strcmp(argv[2], "B") == 0))

		{channel_b_en = 1;
		}
	}
	unsigned int   ddr_test_size= DDR_CORSS_TALK_TEST_SIZE;
	ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
	if (argc >3) {
		ddr_test_size = simple_strtoull_ddr(argv[3], &endp, 16);
		if (*argv[3] == 0 || *endp != 0)
		{
			ddr_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}
	}



	if (argc >4) {
		watchdog_time_s = simple_strtoull_ddr(argv[4], &endp, 0);
		if (*argv[4] == 0 || *endp != 0)
		{
			watchdog_time_s= 20;
		}
	}
	printf("watchdog_time_s==%d\n",watchdog_time_s);

	unsigned int   lane_disable= 0;

	if (argc >5) {
		lane_disable = simple_strtoull_ddr(argv[5], &endp, 0);
		if (*argv[5] == 0 || *endp != 0)
		{
			lane_disable= 0;
		}
	}
	printf("lane_disable==0x%08x\n",lane_disable);

	unsigned int  add_test_size= DDR_CORSS_TALK_TEST_SIZE;

	if (argc >6) {
		add_test_size = simple_strtoull_ddr(argv[6], &endp, 0);
		if (*argv[6] == 0 || *endp != 0)
		{
			add_test_size= ddr_test_size;
		}
	}
	printf("add_test_size==0x%08x\n",add_test_size);
	//argc2=5;
	//for(i = 1;i<(argc);i++)
	{
		//argv2[i-1]=argv[i];
	}

	//argv2[0]=argv[1];
	//argv2[1]=argv[2];
	//argv2[2]=argv[3];
	//#include <stdio.h>
	//   unsigned int   wr_adj_per[24] ;
	//if(1)

	printf("\ntest use uboot sticky register\n");

	//DMC_STICKY_0


	char str[1024]="";
	char str_temp1[1024]="";
	char str_temp2[1024]="";
	//const char *s;
	unsigned int str_to_numarry[48];
	//str_buf = (char *)malloc(sizeof(char)*1024);

	unsigned int *num_arry;
	//unsigned int *num_arry_temp;
	//unsigned int *num_arry_lane0=NULL;
	//unsigned int *num_arry_lane1=NULL;
	//unsigned int *num_arry_lane2=NULL;
	//unsigned int *num_arry_lane3=NULL;
	//char *name_lane0; 
	//char *name_lane1; 
	//char *name_lane2; 
	//char *name_lane3; 
	num_arry = (unsigned int *)(&str_to_numarry);
	int i;
	//char *varname;  char *env_lcdlr_temp_count;
	unsigned int lcdlr_temp_count=0;
	// const char *temp_s;const char *temp_s1;
	// int value=0;

	//#define DMC_STICKY_0                               ((0x0000  << 2) + 0xff639800)
	//#define DMC_STICKY_MAGIC_0                              0x12345678
	//#define DMC_STICKY_MAGIC_1                              0xabcdbead
	//unsigned int dmc_sticky[64];
	//unsigned int sticky_reg_base_add=0;
	//varname="env_ddrtest_data_lane";
	//name_lane0="ddr_test_data_lane0";
	//name_lane1="ddr_test_data_lane1";
	//name_lane2="ddr_test_data_lane2";
	//name_lane3="ddr_test_data_lane3";
	//env_lcdlr_temp_count="lcdlr_temp_count";


	{//i=0;
		//while(s_temp)
		{



			sticky_reg_base_add=(DDR0_PUB_REG_BASE&0xffff0000)+((DMC_STICKY_0)&0xffff);

			for (i = 0; i < 63; i++) {
				dmc_sticky[i]=rd_reg(sticky_reg_base_add+(i<<2));
				//printf("str_to_numarry[%d]==%d\n",i,num_arry[i]);
			}

			for (i = 0; i < 48; i++) {
				num_arry[i]=dmc_sticky[i];
				printf("str_to_numarry[%d]==%d\n",i,num_arry[i]);
			}

			//lcdlr_temp_count=num_arry[5];



		}
	}




	///*
	//if(1)

	unsigned int test_arg_0_cmd0 =0;  //master cmd
	unsigned int test_arg_1_cmd1 =0;  //min cmd
	unsigned int test_arg_2_step =0; //step 0  init  -1 lane0 w min  -2 lane0 w max -3 lane0 r min    4 lane0 r max -----5 lane1 w min ...
	unsigned int test_arg_3_freq =0;
	unsigned int test_arg_4_step_status =0; //uboot test we should read error then done status.  0 no test 1 ongoing 2 this step done  fail or pass
	//  unsigned int   lane_step= 0;
	//char str[24];
	unsigned int boot_times=0;

	test_arg_0_cmd0=num_arry[0];
	test_arg_1_cmd1=num_arry[1];
	test_arg_2_step=num_arry[2];
	test_arg_3_freq=num_arry[3];
	test_arg_4_step_status=num_arry[4];
	boot_times=num_arry[5];
	lcdlr_temp_count=num_arry[6];
	printf("test_arg_0_cmd0==%d\n",test_arg_0_cmd0);
	printf("test_arg_0_cmd1==%d\n",test_arg_1_cmd1);
	printf("test_arg_2_step==%d\n",test_arg_2_step);
	printf("test_arg_3_freq==%d\n",test_arg_3_freq);
	printf("test_arg_4_step_status==%d\n",test_arg_4_step_status);
	printf("test_arg_5 boottimes=%d\n",num_arry[5]);
	printf("test_arg_6 lcdlr_temp_count=%d\n",num_arry[6]);
	printf("test_arg_7=%d\n",num_arry[7]);

	if((num_arry[7]==DMC_STICKY_MAGIC_1)) //for check magic number make sume enter test command
	{boot_times++;

	}
	else
	{boot_times=0;
		printf("test_sticky is not magic number,boot times==%d\n",boot_times);
		// writel(DMC_STICKY_MAGIC_0,(sticky_reg_base_add+(6<<2)));
		writel(DMC_STICKY_MAGIC_1,(sticky_reg_base_add+(7<<2)));
		test_arg_2_step=0;
		num_arry[6]=0;
		lcdlr_temp_count=0;
		//return 1;
	}
	num_arry[5]=boot_times;

	writel(num_arry[5],(sticky_reg_base_add+(5<<2)));

	//if(test_arg_2_step)
	if(test_arg_2_step)
	{
		if(test_arg_3_freq!=global_ddr_clk)  //
		{
			printf("running ddr freq==%d,but test freq is%d,will reboot use d2pll \n",global_ddr_clk,test_arg_3_freq);
			sprintf(str,"d2pll  %d",test_arg_3_freq);
			printf("\nstr=%s\n",str);
			run_command(str,0);
			while(1);
		}
	}
	if(test_arg_2_step==0)
	{
		{
			test_arg_0_cmd0=0x22;
			test_arg_1_cmd1=0;
			test_arg_2_step=1;
			test_arg_3_freq=global_ddr_clk;
			test_arg_4_step_status=0;
			lcdlr_temp_count=0;
			num_arry[0]=test_arg_0_cmd0;
			num_arry[1]=test_arg_1_cmd1;
			num_arry[2]=test_arg_2_step;
			num_arry[3]=test_arg_3_freq;
			num_arry[4]=test_arg_4_step_status;
			num_arry[5]=boot_times;
			lcdlr_temp_count=num_arry[6];
			num_arry[6]=lcdlr_temp_count;
			num_arry[7]=DMC_STICKY_MAGIC_1;
			for (i = 8; i < 48; i++) {
				num_arry[i]=0;
			}

			for (lane_step = 0; lane_step < 4; lane_step++)
			{
				//if(lane_step%2)
				{
#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
					dq_lcd_bdl_value_wdq_org_a[lane_step]=((readl((lane_step)*(DDR0_PUB_DX1LCDLR1-
										DDR0_PUB_DX0LCDLR1)
									+DDR0_PUB_DX0LCDLR1))&0xff);
					dq_lcd_bdl_value_rdqs_org_a[lane_step]=(((readl((lane_step)*(DDR0_PUB_DX1LCDLR1-
											DDR0_PUB_DX0LCDLR1)
										+DDR0_PUB_DX0LCDLR1))>>8)&0xff);
#else
					dq_lcd_bdl_value_wdq_org_a[lane_step]=((readl((lane_step)*(DDR0_PUB_DX1LCDLR1-
										DDR0_PUB_DX0LCDLR1)
									+DDR0_PUB_DX0LCDLR1))&0x1ff);
					dq_lcd_bdl_value_rdqs_org_a[lane_step]=(((readl((lane_step)*(DDR0_PUB_DX1LCDLR3-
											DDR0_PUB_DX0LCDLR3)
										+DDR0_PUB_DX0LCDLR3))>>0)&0x1ff);

					printf("lcdlr1 %d  %08x,%08x,%08x\n", lane_step,((lane_step)*(DDR0_PUB_DX1LCDLR1-
									DDR0_PUB_DX0LCDLR1)
								+DDR0_PUB_DX0LCDLR1),
							((readl((lane_step)*(DDR0_PUB_DX1LCDLR1-
												 DDR0_PUB_DX0LCDLR1)
									+DDR0_PUB_DX0LCDLR1))&0x1ff),dq_lcd_bdl_value_wdq_org_a[lane_step]);
					printf("lcdlr3 %d  %08x,%08x,%08x\n", lane_step,((lane_step)*(DDR0_PUB_DX1LCDLR3-
									DDR0_PUB_DX0LCDLR3)
								+DDR0_PUB_DX0LCDLR3),
							(((readl((lane_step)*(DDR0_PUB_DX1LCDLR3-
												  DDR0_PUB_DX0LCDLR3)
									 +DDR0_PUB_DX0LCDLR3))>>0)&0x1ff),dq_lcd_bdl_value_rdqs_org_a[lane_step]);
#endif

					//printf("lcdlr1 %d  %08x\n", lane_step,((lane_step)*(DDR0_PUB_DX1LCDLR1-
					//DDR0_PUB_DX0LCDLR1)
					//+DDR0_PUB_DX0LCDLR1));
					//printf("lcdlr3 %d  %08x\n", lane_step,((lane_step)*(DDR0_PUB_DX1LCDLR3-
					//DDR0_PUB_DX0LCDLR3)
					//+DDR0_PUB_DX0LCDLR3));
					//dq_lcd_bdl_value_rdqs_org_a[lane_step]=0;
					dq_lcd_bdl_value_rdqs_min_a[lane_step]=0xffff;
					dq_lcd_bdl_value_rdqs_max_a[lane_step]=0xffff;
					dq_lcd_bdl_value_rdqs_status_a[lane_step]=0;
				}
				//else
				{
					//dq_lcd_bdl_value_wdq_org_a[lane_step]=0;
					dq_lcd_bdl_value_wdq_min_a[lane_step]=0xffff;
					dq_lcd_bdl_value_wdq_max_a[lane_step]=0xffff;
					dq_lcd_bdl_value_wdq_status_a[lane_step]=0;
				}
			}

			{
				dq_lcd_bdl_value_aclcdlr_org_a=((readl(DDR0_PUB_ACLCDLR))&ACLCDLR_MAX);
				dq_lcd_bdl_value_aclcdlr_min_a=0xffff;
				dq_lcd_bdl_value_aclcdlr_max_a=0xffff;
				dq_lcd_bdl_value_aclcdlr_status_a=0;
				dq_lcd_bdl_value_bdlr0_org_a=((readl(DDR0_PUB_ACBDLR0))&ACBDLR_MAX);
				dq_lcd_bdl_value_bdlr0_min_a=0xffff;
				dq_lcd_bdl_value_bdlr0_max_a=0xffff;
				dq_lcd_bdl_value_bdlr0_status_a=0;
			}



#if 1 //( CONFIG_DDR_PHY<P_DDR_PHY_905X)
			printf("DDR0_PUB_DX0GCR0==%x\n",(readl(DDR0_PUB_DX0GCR0)));
			printf("DDR0_PUB_DX1GCR0==%x\n",(readl(DDR0_PUB_DX1GCR0)));
			printf("DDR0_PUB_DX2GCR0==%x\n",(readl(DDR0_PUB_DX2GCR0)));
			printf("DDR0_PUB_DX3GCR0==%x\n",(readl(DDR0_PUB_DX3GCR0)));
			if(((readl(DDR0_PUB_DX0GCR0))&1)==0)
				lane_disable=   lane_disable|1;      
			if(((readl(DDR0_PUB_DX1GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<1);   
			if(((readl(DDR0_PUB_DX2GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<2);   
			if(((readl(DDR0_PUB_DX3GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<3);   

#endif
			if(lane_disable)
			{if(lane_disable&0x1){
									 dq_lcd_bdl_value_wdq_status_a[0]=4;
									 dq_lcd_bdl_value_rdqs_status_a[0]=4;
								 }
			if(lane_disable&0x2){
				dq_lcd_bdl_value_wdq_status_a[1]=4;
				dq_lcd_bdl_value_rdqs_status_a[1]=4;
			}
			if(lane_disable&0x4){
				dq_lcd_bdl_value_wdq_status_a[2]=4;
				dq_lcd_bdl_value_rdqs_status_a[2]=4;
			}
			if(lane_disable&0x8){
				dq_lcd_bdl_value_wdq_status_a[3]=4;
				dq_lcd_bdl_value_rdqs_status_a[3]=4;
			}
			printf("lane_disable==%x\n",lane_disable);
			if(lane_disable&0x10){
				dq_lcd_bdl_value_aclcdlr_status_a=4;
				printf("dq_lcd_bdl_value_aclcdlr_status_a==%x\n",dq_lcd_bdl_value_aclcdlr_status_a);
			}
			if(lane_disable&0x20){
				dq_lcd_bdl_value_bdlr0_status_a=4;
				printf("dq_lcd_bdl_value_bdlr0_status_a==%x\n",dq_lcd_bdl_value_bdlr0_status_a);

			}
			}

			{
				for (lane_step = 0; lane_step < 4; lane_step++)


				{
					num_arry[8+lane_step*4*2+0]=dq_lcd_bdl_value_wdq_org_a[lane_step];
					num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_wdq_min_a[lane_step];
					num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_wdq_max_a[lane_step];
					num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_wdq_status_a[lane_step];
					num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_rdqs_org_a[lane_step];
					num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
					num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
					num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
				}




				lane_step=4;
				{
					num_arry[8+lane_step*4*2+0]=dq_lcd_bdl_value_aclcdlr_org_a;
					num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_aclcdlr_min_a;
					num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_aclcdlr_max_a;
					num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_aclcdlr_status_a;
					num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_bdlr0_org_a;
					num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_bdlr0_min_a;
					num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_bdlr0_max_a;
					num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_bdlr0_status_a;
				}
			}



		}




		for (i = 0; i < 48; i++) {
			sprintf(str_temp1,"ddr_test_data_num_%04d",i);
			sprintf(str_temp2,"0x%08x",num_arry[i]);
			//setenv(str_temp1, str_temp2);
			//run_command("save",0);
			writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
		}



	}

	test_arg_2_step++;
	num_arry[2]=test_arg_2_step;
	sprintf(str, "0x%08x", num_arry[0]);
	printf("%d  %d\n", 0,num_arry[0]);
	for (i = 1; i < 48; i++) {
		//num_arry[i]=0;
		sprintf(str, "%s;0x%08x", str,num_arry[i]);
		printf("%d  %d\n", i,num_arry[i]);

	}
	//sprintf(str, "%lx", value);
	printf("%s", str);
	// setenv(varname, str);
	//run_command("save",0);

	for (i = 0; i < 48; i++) {

		writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
	}


	for (i = 8; i < 48; i++) {
		num_arry[i]=readl((sticky_reg_base_add+(i<<2)));
		printf("ddr_test_data_num_%04d==%d\n",i,num_arry[i]);
	}

	///*
	{
		for (lane_step = 0; lane_step < 4; lane_step++)
		{
			{
				dq_lcd_bdl_value_wdq_org_a[lane_step]=num_arry[8+lane_step*4*2+0];
				dq_lcd_bdl_value_wdq_min_a[lane_step]=num_arry[8+lane_step*4*2+1];
				dq_lcd_bdl_value_wdq_max_a[lane_step]=num_arry[8+lane_step*4*2+2];
				dq_lcd_bdl_value_wdq_status_a[lane_step]=num_arry[8+lane_step*4*2+3];
			}
			{
				dq_lcd_bdl_value_rdqs_org_a[lane_step]=num_arry[8+lane_step*4*2+4];
				dq_lcd_bdl_value_rdqs_min_a[lane_step]=num_arry[8+lane_step*4*2+5];
				dq_lcd_bdl_value_rdqs_max_a[lane_step]=num_arry[8+lane_step*4*2+6];
				dq_lcd_bdl_value_rdqs_status_a[lane_step]=num_arry[8+lane_step*4*2+7];
			}


		}
		lane_step=4;
		{
			dq_lcd_bdl_value_aclcdlr_org_a=num_arry[8+lane_step*4*2+0];
			dq_lcd_bdl_value_aclcdlr_min_a=num_arry[8+lane_step*4*2+1];
			dq_lcd_bdl_value_aclcdlr_max_a=num_arry[8+lane_step*4*2+2];
			dq_lcd_bdl_value_aclcdlr_status_a=num_arry[8+lane_step*4*2+3];
			dq_lcd_bdl_value_bdlr0_org_a=num_arry[8+lane_step*4*2+4];
			dq_lcd_bdl_value_bdlr0_min_a=num_arry[8+lane_step*4*2+5];
			dq_lcd_bdl_value_bdlr0_max_a=num_arry[8+lane_step*4*2+6];
			dq_lcd_bdl_value_bdlr0_status_a=num_arry[8+lane_step*4*2+7];
		}
	}
	//*/




	if (channel_a_en)
	{

		//*(char     *)(argv2[0])="a";
		//	run_command("ddr_test_cmd 11 a 0 0x80000  ",0);
		printf("\ntest dqs window lane a\n");
		for ((lane_step=0);(lane_step<4);(lane_step++))
		{
			ddr_test_watchdog_enable(watchdog_time_s); //s
			printf("\nenable %ds watchdog \n",watchdog_time_s);

			/*
			   {
			   lcdlr_temp_count=dq_lcd_bdl_temp_reg_value;
			   sprintf(buf, "0x%08x", lcdlr_temp_count);
			   printf( "%s", buf);
			   setenv(env_lcdlr_temp_count, buf);
			   run_command("save",0);
			   }
			   */
			if((dq_lcd_bdl_value_wdq_status_a[lane_step]==0xffff)
					||(dq_lcd_bdl_value_wdq_status_a[lane_step]==0)
					||(dq_lcd_bdl_value_wdq_status_a[lane_step]==1)
			  )
			{
				if((dq_lcd_bdl_value_wdq_status_a[lane_step]==0xffff)
						||(dq_lcd_bdl_value_wdq_status_a[lane_step]==0))
				{		dq_lcd_bdl_value_wdq_status_a[lane_step]=1;
					{
						{
							num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_wdq_status_a[lane_step];
							i=8+lane_step*8+3;
							sprintf(str_temp1,"ddr_test_data_num_%04d",i);
							sprintf(str_temp2,"0x%08x",num_arry[i]);
							// setenv(str_temp1, str_temp2);
							//run_command("save",0);
							writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
						}
						lcdlr_temp_count=0;
						sprintf(buf, "0x%08x", lcdlr_temp_count);
						printf( "%s", buf);
						//     setenv(env_lcdlr_temp_count, buf);
						//			run_command("save",0);
						writel(num_arry[6],(sticky_reg_base_add+(6<<2)));
					}

					sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d 1",ddr_test_size,( lane_step*2+0),2);
					printf("\nstr=%s\n",str);
					//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
					//printf("\nstr=%s\n",str);
					ddr_test_watchdog_clear();
					run_command(str,0);
					ddr_test_watchdog_clear();
					ddr_udelay(2000000);
					dq_lcd_bdl_value_wdq_status_a[lane_step]=2;

				}
				else if (dq_lcd_bdl_value_wdq_status_a[lane_step]==1)
				{
					//  temp_s= getenv(env_lcdlr_temp_count);
					//	 if(temp_s)
					//	 	{
					//	lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
					//
					//	 	}
					lcdlr_temp_count=readl((sticky_reg_base_add+(6<<2)));
					dq_lcd_bdl_value_wdq_min_a[lane_step]=lcdlr_temp_count;
					dq_lcd_bdl_value_wdq_status_a[lane_step]=2;
				}

				num_arry[8+lane_step*4*2+0]=dq_lcd_bdl_value_wdq_org_a[lane_step];
				num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_wdq_min_a[lane_step];
				//num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_wdq_max_a[lane_step];
				num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_wdq_status_a[lane_step];

				//ddr_udelay(1000000);
				//num_to_env(varname,num_arry);
				{
					i=8+lane_step*8+1;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					//	 setenv(str_temp1, str_temp2);
					//run_command("save",0);
					writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
					i=8+lane_step*8+3;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					//	 setenv(str_temp1, str_temp2);
					//      run_command("save",0);
					writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
				}


				run_command("reset",0);
			}

			if((dq_lcd_bdl_value_wdq_status_a[lane_step]==2)||
					(dq_lcd_bdl_value_wdq_status_a[lane_step]==3))
			{
				//	if((dq_lcd_bdl_value_wdq_min_a[lane_step])==0xffff)
				//		{dq_lcd_bdl_value_wdq_status_a[lane_step]=0;
				//		num_to_env(varname,num_arry);
				//             run_command("reset",0);
				//		}

				{
					if(dq_lcd_bdl_value_wdq_status_a[lane_step]==2)
					{		dq_lcd_bdl_value_wdq_status_a[lane_step]=3;
						{
							num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_wdq_status_a[lane_step];
							i=8+lane_step*8+3;
							sprintf(str_temp1,"ddr_test_data_num_%04d",i);
							sprintf(str_temp2,"0x%08x",num_arry[i]);
							// setenv(str_temp1, str_temp2);
							//run_command("save",0);
							writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
						}
						{
							lcdlr_temp_count=0;
							sprintf(buf, "0x%08x", lcdlr_temp_count);
							printf( "%s", buf);
							//        setenv(env_lcdlr_temp_count, buf);
							//			run_command("save",0);
							writel(num_arry[6],(sticky_reg_base_add+(6<<2)));
						}

						sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d 1",ddr_test_size,( lane_step*2+0),1);
						printf("\nstr=%s\n",str);
						//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
						//printf("\nstr=%s\n",str);
						ddr_test_watchdog_clear();
						run_command(str,0);
						ddr_test_watchdog_clear();
						ddr_udelay(2000000);
						dq_lcd_bdl_value_wdq_status_a[lane_step]=4;

					}
					else if (dq_lcd_bdl_value_wdq_status_a[lane_step]==3)
					{
						//   temp_s= getenv(env_lcdlr_temp_count);
						// if(temp_s)
						//	{
						//
						//	lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
						// 	}
						lcdlr_temp_count= readl((sticky_reg_base_add+(6<<2)));
						dq_lcd_bdl_value_wdq_max_a[lane_step]=lcdlr_temp_count;
						dq_lcd_bdl_value_wdq_status_a[lane_step]=4;
					}

					num_arry[8+lane_step*4*2+0]=dq_lcd_bdl_value_wdq_org_a[lane_step];
					//num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_wdq_min_a[lane_step];
					num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_wdq_max_a[lane_step];
					num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_wdq_status_a[lane_step];
					//ddr_udelay(1000000);
					//num_to_env(varname,num_arry);
					{
						i=8+lane_step*8+2;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						// setenv(str_temp1, str_temp2);
						//run_command("save",0);
						writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
						i=8+lane_step*8+3;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						// setenv(str_temp1, str_temp2);
						//  run_command("save",0);
						writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
					}

					run_command("reset",0);
				}

			}


			if((dq_lcd_bdl_value_rdqs_status_a[lane_step]==0xffff)
					||(dq_lcd_bdl_value_rdqs_status_a[lane_step]==0)
					||(dq_lcd_bdl_value_rdqs_status_a[lane_step]==1)
			  )
			{
				if((dq_lcd_bdl_value_rdqs_status_a[lane_step]==0xffff)
						||(dq_lcd_bdl_value_rdqs_status_a[lane_step]==0))
				{		dq_lcd_bdl_value_rdqs_status_a[lane_step]=1;
					{
						num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
						i=8+lane_step*8+7;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						//	 setenv(str_temp1, str_temp2);
						//run_command("save",0);
						writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
					}
					{
						lcdlr_temp_count=0;
						sprintf(buf, "0x%08x", lcdlr_temp_count);
						printf( "%s", buf);
						//  setenv(env_lcdlr_temp_count, buf);
						//	run_command("save",0);
						//i=6;
						writel(num_arry[6],(sticky_reg_base_add+(6<<2)));
					}

					sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d 1",ddr_test_size,( lane_step*2+1),2);
					printf("\nstr=%s\n",str);
					//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
					//printf("\nstr=%s\n",str);
					ddr_test_watchdog_clear();
					run_command(str,0);
					ddr_test_watchdog_clear();
					ddr_udelay(2000000);
					dq_lcd_bdl_value_rdqs_status_a[lane_step]=2;

				}
				else if (dq_lcd_bdl_value_rdqs_status_a[lane_step]==1)
				{
					//  temp_s= getenv(env_lcdlr_temp_count);
					// if(temp_s)
					// 	{
					//	lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
					// 	}
					lcdlr_temp_count= readl((sticky_reg_base_add+(6<<2))); 
					dq_lcd_bdl_value_rdqs_min_a[lane_step]=lcdlr_temp_count;
					dq_lcd_bdl_value_rdqs_status_a[lane_step]=2;
				}

				num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_rdqs_org_a[lane_step];
				num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
				//num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
				num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
				//ddr_udelay(1000000);
				//num_to_env(varname,num_arry);
				{
					i=8+lane_step*8+5;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					//	 setenv(str_temp1, str_temp2);
					//run_command("save",0);
					writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
					i=8+lane_step*8+7;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					//	 setenv(str_temp1, str_temp2);
					//        run_command("save",0);
					writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
				}

				run_command("reset",0);
			}

			if((dq_lcd_bdl_value_rdqs_status_a[lane_step]==2)||
					(dq_lcd_bdl_value_rdqs_status_a[lane_step]==3))
			{

				{
					if(dq_lcd_bdl_value_rdqs_status_a[lane_step]==2)
					{	

						dq_lcd_bdl_value_rdqs_status_a[lane_step]=3;
						{
							num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
							i=8+lane_step*8+7;
							sprintf(str_temp1,"ddr_test_data_num_%04d",i);
							sprintf(str_temp2,"0x%08x",num_arry[i]);
							//	 setenv(str_temp1, str_temp2);
							//run_command("save",0);
							writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
						}

						{
							lcdlr_temp_count=0;
							sprintf(buf, "0x%08x", lcdlr_temp_count);
							printf( "%s", buf);
							//       setenv(env_lcdlr_temp_count, buf);
							//		run_command("save",0);
							writel(num_arry[6],(sticky_reg_base_add+(6<<2)));
						}

						sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d 1",ddr_test_size,( lane_step*2+1),1);
						printf("\nstr=%s\n",str);
						//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
						//printf("\nstr=%s\n",str);
						ddr_test_watchdog_clear();
						run_command(str,0);
						ddr_test_watchdog_clear();
						ddr_udelay(2000000);
						dq_lcd_bdl_value_rdqs_status_a[lane_step]=4;

					}
					else if (dq_lcd_bdl_value_rdqs_status_a[lane_step]==3)
					{
						//  temp_s= getenv(env_lcdlr_temp_count);
						//	 if(temp_s)
						// 	{
						//	lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
						// 	}
						lcdlr_temp_count= readl((sticky_reg_base_add+(6<<2))); 
						dq_lcd_bdl_value_rdqs_max_a[lane_step]=lcdlr_temp_count;
						dq_lcd_bdl_value_rdqs_status_a[lane_step]=4;
					}

					num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_rdqs_org_a[lane_step];
					//num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
					num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
					num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
					//ddr_udelay(1000000);
					//	num_to_env(varname,num_arry);

					{
						i=8+lane_step*8+6;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						//	 setenv(str_temp1, str_temp2);
						//run_command("save",0);
						writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
						i=8+lane_step*8+7;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						// setenv(str_temp1, str_temp2);
						//  run_command("save",0);
						writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
					}
					run_command("reset",0);
				}

			}

			/*
			   if((dq_lcd_bdl_value_rdqs_status_a[lane_step]==0xffff)||
			   (dq_lcd_bdl_value_rdqs_status_a[lane_step]==0))
			   {dq_lcd_bdl_value_rdqs_status_a[lane_step]=0;
			   sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d",ddr_test_size,( lane_step*2+1),2);
			   printf("\nstr=%s\n",str);
			//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
			//printf("\nstr=%s\n",str);
			ddr_test_watchdog_clear();
			run_command(str,0);
			ddr_test_watchdog_clear();
			dq_lcd_bdl_value_rdqs_status_a[lane_step]=1;
			num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_rdqs_org_a[lane_step];
			num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
			//num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
			num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
			num_to_env(varname,num_arry);
			run_command("reset",0);
			}

			if((dq_lcd_bdl_value_rdqs_status_a[lane_step]==1)||
			(dq_lcd_bdl_value_rdqs_status_a[lane_step]==2))
			{dq_lcd_bdl_value_rdqs_status_a[lane_step]=2;
			sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d",ddr_test_size,( lane_step*2+1),1);
			printf("\nstr=%s\n",str);
			//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
			//printf("\nstr=%s\n",str);
			ddr_test_watchdog_clear();
			run_command(str,0);
			ddr_test_watchdog_clear();
			dq_lcd_bdl_value_rdqs_status_a[lane_step]=3;
			num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_rdqs_org_a[lane_step];
			//num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
			num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
			num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
			num_to_env(varname,num_arry);
			run_command("reset",0);
			}
			*/	


			ddr_test_watchdog_disable(); //s
			{printf("close  watchdog\n");
			}


		}



	}

	if (channel_a_en)
	{

		//*(char     *)(argv2[0])="a";
		//	run_command("ddr_test_cmd 11 a 0 0x80000  ",0);
		printf("\ntest lcdlr ac bdlr window lane a...\n");

		{
			ddr_test_watchdog_enable(watchdog_time_s); //s
			printf("\nenable %ds watchdog \n",watchdog_time_s);
			printf("\ndq_lcd_bdl_value_aclcdlr_status_a %d \n",dq_lcd_bdl_value_aclcdlr_status_a);
			lane_step=4;
			//env_lcdlr_temp_count="lcdlr_temp_count_a";
			if((dq_lcd_bdl_value_aclcdlr_status_a>=0xffff)
					||(dq_lcd_bdl_value_aclcdlr_status_a==0)
					||(dq_lcd_bdl_value_aclcdlr_status_a==1)
			  )
			{
				if((dq_lcd_bdl_value_aclcdlr_status_a>=0xffff)
						||(dq_lcd_bdl_value_aclcdlr_status_a==0))
				{		dq_lcd_bdl_value_aclcdlr_status_a=1;
					{
						{
							num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_aclcdlr_status_a;
							i=8+lane_step*8+3;
							printf("aclcdlr_status_a==0x%08x\n",num_arry[i]);
							sprintf(str_temp1,"ddr_test_data_num_%04d",i);
							sprintf(str_temp2,"0x%08x",num_arry[i]);
							//	 setenv(str_temp1, str_temp2);
							//run_command("save",0);
							writel(num_arry[i],(sticky_reg_base_add+(i<<2)));

						}
						printf("\n222test lcdlr ac bdlr window lane a...\n");
						lcdlr_temp_count=0;
						sprintf(buf, "0x%08x", lcdlr_temp_count);
						printf( "%s", buf);
						//     setenv(env_lcdlr_temp_count, buf);
						//		run_command("save",0);
						writel(num_arry[6],(sticky_reg_base_add+(6<<2)));
					}

					printf("\n333test lcdlr ac bdlr window lane a...\n");
					//ddr_tune_aclcdlr_step
					sprintf(str,"ddr_tune_aclcdlr_step  a 0 0x%08x %d %d 1",add_test_size,( 0),2);
					printf("\nstr=%s\n",str);
					printf("aclcdlr_status_a1==0x%08x\n",num_arry[i]);
					//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
					//printf("\nstr=%s\n",str);
					ddr_test_watchdog_clear();
					run_command(str,0);
					ddr_test_watchdog_clear();
					ddr_udelay(2000000);
					dq_lcd_bdl_value_aclcdlr_status_a=2;

				}
				else if (dq_lcd_bdl_value_aclcdlr_status_a==1)
				{
					//     temp_s= getenv(env_lcdlr_temp_count);
					// if(temp_s)
					// 	{
					//lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
					// 	}
					lcdlr_temp_count=readl((sticky_reg_base_add+(6<<2)));
					dq_lcd_bdl_value_aclcdlr_min_a=lcdlr_temp_count;
					dq_lcd_bdl_value_aclcdlr_status_a=2;
				}

				num_arry[8+lane_step*4*2+0]=dq_lcd_bdl_value_aclcdlr_org_a;
				num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_aclcdlr_min_a;
				//num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_wdq_max_a[lane_step];
				num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_aclcdlr_status_a;

				//ddr_udelay(1000000);
				//num_to_env(varname,num_arry);
				{
					i=8+lane_step*8+1;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					// setenv(str_temp1, str_temp2);
					//run_command("save",0);
					writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
					i=8+lane_step*8+3;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					// setenv(str_temp1, str_temp2);
					//  run_command("save",0);
					writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
				}


				run_command("reset",0);
			}

			if((dq_lcd_bdl_value_aclcdlr_status_a==2)||
					(dq_lcd_bdl_value_aclcdlr_status_a==3))
			{
				//	if((dq_lcd_bdl_value_wdq_min_a[lane_step])==0xffff)
				//		{dq_lcd_bdl_value_wdq_status_a[lane_step]=0;
				//		num_to_env(varname,num_arry);
				//             run_command("reset",0);
				//		}

				{
					if(dq_lcd_bdl_value_aclcdlr_status_a==2)
					{		dq_lcd_bdl_value_aclcdlr_status_a=3;
						{
							num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_aclcdlr_status_a;
							i=8+lane_step*8+3;
							sprintf(str_temp1,"ddr_test_data_num_%04d",i);
							sprintf(str_temp2,"0x%08x",num_arry[i]);
							// setenv(str_temp1, str_temp2);
							//run_command("save",0);
							writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
						}
						{
							lcdlr_temp_count=0;
							sprintf(buf, "0x%08x", lcdlr_temp_count);
							printf( "%s", buf);
							//       setenv(env_lcdlr_temp_count, buf);
							//			run_command("save",0);
							writel(num_arry[6],(sticky_reg_base_add+(6<<2)));
						}

						sprintf(str,"ddr_tune_aclcdlr_step  a 0 0x%08x %d %d 1",add_test_size,( 0),1);
						printf("\nstr=%s\n",str);
						//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
						//printf("\nstr=%s\n",str);
						ddr_test_watchdog_clear();
						run_command(str,0);
						ddr_test_watchdog_clear();
						ddr_udelay(2000000);
						dq_lcd_bdl_value_aclcdlr_status_a=4;

					}
					else if (dq_lcd_bdl_value_aclcdlr_status_a==3)
					{
						//   temp_s= getenv(env_lcdlr_temp_count);
						//	 if(temp_s)
						// 	{
						//	lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
						// 	}
						lcdlr_temp_count= readl((sticky_reg_base_add+(6<<2)));
						dq_lcd_bdl_value_aclcdlr_max_a=lcdlr_temp_count;
						dq_lcd_bdl_value_aclcdlr_status_a=4;
					}

					num_arry[8+lane_step*4*2+0]=dq_lcd_bdl_value_aclcdlr_org_a;
					//num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_wdq_min_a[lane_step];
					num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_aclcdlr_max_a;
					num_arry[8+lane_step*4*2+3]=dq_lcd_bdl_value_aclcdlr_status_a;
					//ddr_udelay(1000000);
					//num_to_env(varname,num_arry);
					{
						i=8+lane_step*8+2;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						//	 setenv(str_temp1, str_temp2);
						//run_command("save",0);
						writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
						i=8+lane_step*8+3;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						// setenv(str_temp1, str_temp2);
						//  run_command("save",0);
						writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
					}

					run_command("reset",0);
				}

			}


			if((dq_lcd_bdl_value_bdlr0_status_a==0xffff)
					||(dq_lcd_bdl_value_bdlr0_status_a==0)
					||(dq_lcd_bdl_value_bdlr0_status_a==1)
			  )
			{
				if((dq_lcd_bdl_value_bdlr0_status_a==0xffff)
						||(dq_lcd_bdl_value_bdlr0_status_a==0))
				{		dq_lcd_bdl_value_bdlr0_status_a=1;
					{
						num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_bdlr0_status_a;
						i=8+lane_step*8+7;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						// setenv(str_temp1, str_temp2);
						//run_command("save",0);
						writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
					}
					{
						lcdlr_temp_count=0;
						sprintf(buf, "0x%08x", lcdlr_temp_count);
						printf( "%s", buf);
						//    setenv(env_lcdlr_temp_count, buf);
						//		run_command("save",0);
						writel(num_arry[6],(sticky_reg_base_add+(6<<2)));
					}

					sprintf(str,"ddr_tune_aclcdlr_step  a 0 0x%08x %d %d 1",add_test_size,( 1),2);
					printf("\nstr=%s\n",str);
					//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
					//printf("\nstr=%s\n",str);
					ddr_test_watchdog_clear();
					run_command(str,0);
					ddr_test_watchdog_clear();
					ddr_udelay(2000000);
					dq_lcd_bdl_value_bdlr0_status_a=2;

				}
				else if (dq_lcd_bdl_value_bdlr0_status_a==1)
				{
					//  temp_s= getenv(env_lcdlr_temp_count);
					//	 if(temp_s)
					// 	{
					//	lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
					// 	}
					lcdlr_temp_count= readl((sticky_reg_base_add+(6<<2)));
					dq_lcd_bdl_value_bdlr0_min_a=lcdlr_temp_count;
					dq_lcd_bdl_value_bdlr0_status_a=2;
				}

				num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_bdlr0_org_a;
				num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_bdlr0_min_a;
				//num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
				num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_bdlr0_status_a;
				//ddr_udelay(1000000);
				//num_to_env(varname,num_arry);
				{
					i=8+lane_step*8+5;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					// setenv(str_temp1, str_temp2);
					//run_command("save",0);
					writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
					i=8+lane_step*8+7;
					sprintf(str_temp1,"ddr_test_data_num_%04d",i);
					sprintf(str_temp2,"0x%08x",num_arry[i]);
					// setenv(str_temp1, str_temp2);
					//    run_command("save",0);
					writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
				}

				run_command("reset",0);
			}

			if((dq_lcd_bdl_value_bdlr0_status_a==2)||
					(dq_lcd_bdl_value_bdlr0_status_a==3))
			{

				{
					if(dq_lcd_bdl_value_bdlr0_status_a==2)
					{	

						dq_lcd_bdl_value_bdlr0_status_a=3;
						{
							num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_bdlr0_status_a;
							i=8+lane_step*8+7;
							sprintf(str_temp1,"ddr_test_data_num_%04d",i);
							sprintf(str_temp2,"0x%08x",num_arry[i]);
							// setenv(str_temp1, str_temp2);
							//run_command("save",0);
							writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
						}

						{
							lcdlr_temp_count=0;
							sprintf(buf, "0x%08x", lcdlr_temp_count);
							printf( "%s", buf);
							//    setenv(env_lcdlr_temp_count, buf);
							//	run_command("save",0);
							writel(num_arry[6],(sticky_reg_base_add+(6<<2)));
						}

						sprintf(str,"ddr_tune_aclcdlr_step  a 0 0x%08x %d %d 1",add_test_size,( 1),1);
						printf("\nstr=%s\n",str);
						//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
						//printf("\nstr=%s\n",str);
						ddr_test_watchdog_clear();
						run_command(str,0);
						ddr_test_watchdog_clear();
						ddr_udelay(2000000);
						dq_lcd_bdl_value_bdlr0_status_a=4;

					}
					else if (dq_lcd_bdl_value_bdlr0_status_a==3)
					{
						//  temp_s= getenv(env_lcdlr_temp_count);
						// if(temp_s)
						// 	{
						//	lcdlr_temp_count= simple_strtoull_ddr(temp_s, &endp, 0);
						// 	}
						lcdlr_temp_count= readl((sticky_reg_base_add+(6<<2)));
						dq_lcd_bdl_value_bdlr0_max_a=lcdlr_temp_count;
						dq_lcd_bdl_value_bdlr0_status_a=4;
					}

					num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_bdlr0_org_a;
					//num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
					num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_bdlr0_max_a;
					num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_bdlr0_status_a;
					//ddr_udelay(1000000);
					//	num_to_env(varname,num_arry);

					{
						i=8+lane_step*8+6;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						//	 setenv(str_temp1, str_temp2);
						//run_command("save",0);
						writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
						i=8+lane_step*8+7;
						sprintf(str_temp1,"ddr_test_data_num_%04d",i);
						sprintf(str_temp2,"0x%08x",num_arry[i]);
						// setenv(str_temp1, str_temp2);
						//  run_command("save",0);
						writel(num_arry[i],(sticky_reg_base_add+(i<<2)));
					}
					run_command("reset",0);
				}

			}

			/*
			   if((dq_lcd_bdl_value_rdqs_status_a[lane_step]==0xffff)||
			   (dq_lcd_bdl_value_rdqs_status_a[lane_step]==0))
			   {dq_lcd_bdl_value_rdqs_status_a[lane_step]=0;
			   sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d",ddr_test_size,( lane_step*2+1),2);
			   printf("\nstr=%s\n",str);
			//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
			//printf("\nstr=%s\n",str);
			ddr_test_watchdog_clear();
			run_command(str,0);
			ddr_test_watchdog_clear();
			dq_lcd_bdl_value_rdqs_status_a[lane_step]=1;
			num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_rdqs_org_a[lane_step];
			num_arry[8+lane_step*4*2+5]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
			//num_arry[8+lane_step*4*2+2]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
			num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
			num_to_env(varname,num_arry);
			run_command("reset",0);
			}

			if((dq_lcd_bdl_value_rdqs_status_a[lane_step]==1)||
			(dq_lcd_bdl_value_rdqs_status_a[lane_step]==2))
			{dq_lcd_bdl_value_rdqs_status_a[lane_step]=2;
			sprintf(str,"ddr_tune_dqs_step  a 0 0x%08x %d %d",ddr_test_size,( lane_step*2+1),1);
			printf("\nstr=%s\n",str);
			//sprintf(str,"ddr_tune_dqs_step  b 0 0x80000 %d",( lane_step));
			//printf("\nstr=%s\n",str);
			ddr_test_watchdog_clear();
			run_command(str,0);
			ddr_test_watchdog_clear();
			dq_lcd_bdl_value_rdqs_status_a[lane_step]=3;
			num_arry[8+lane_step*4*2+4]=dq_lcd_bdl_value_rdqs_org_a[lane_step];
			//num_arry[8+lane_step*4*2+1]=dq_lcd_bdl_value_rdqs_min_a[lane_step];
			num_arry[8+lane_step*4*2+6]=dq_lcd_bdl_value_rdqs_max_a[lane_step];
			num_arry[8+lane_step*4*2+7]=dq_lcd_bdl_value_rdqs_status_a[lane_step];
			num_to_env(varname,num_arry);
			run_command("reset",0);
			}
			*/	


			ddr_test_watchdog_disable(); //s
			{printf("close  watchdog\n");
			}


		}



	}

	if (channel_b_en)
	{//*(char     *)(argv2[0])="b";
		//	run_command("ddr_test_cmd 11 a 0 0x80000  ",0);
		printf("\ntest dqs window lane b\n");
		for ((lane_step=0);(lane_step<8);(lane_step++))
		{
			//sprintf(str,"ddr_tune_dqs_step  a 0 0x80000 %d",( lane_step));
			//printf("\nstr=%s\n",str);
			sprintf(str,"ddr_tune_dqs_step  b 0 0x%08x %d 1",ddr_test_size,( lane_step));
			printf("\nstr=%s\n",str);
			run_command(str,0);

		}
	}

	unsigned int   acmdlr= 0;
	unsigned int  delay_step_x100= 0;
	if (channel_a_en)
	{
		acmdlr=((readl((DDR0_PUB_ACMDLR)))&ACLCDLR_MAX);
		delay_step_x100=100*1000000/(2*global_ddr_clk*acmdlr);
		printf("\nacmdlr=0x%08x-->dec %d,ddr clk==%d,step=%d ps,10step=%d ps,100step=%d ps,\n",acmdlr,acmdlr,global_ddr_clk,
				delay_step_x100/100,delay_step_x100/10,delay_step_x100);

		for ((lane_step=0);(lane_step<4);(lane_step++))
		{
			printf("\n a_lane_0x%08x|wdq_org 0x%08x  |wdq_min 0x%08x |wdq_max 0x%08x ::|rdqs_org  0x%08x  |rdqs_min 0x%08x |rdqs_max 0x%08x  \n",
					lane_step,
					dq_lcd_bdl_value_wdq_org_a[lane_step],
					dq_lcd_bdl_value_wdq_min_a[lane_step],dq_lcd_bdl_value_wdq_max_a[lane_step],
					dq_lcd_bdl_value_rdqs_org_a[lane_step],
					dq_lcd_bdl_value_rdqs_min_a[lane_step],dq_lcd_bdl_value_rdqs_max_a[lane_step]);
		}
		{
			printf("\nac_lane_0x%08x|lcd_org 0x%08x  |lcd_min 0x%08x |lcd_max 0x%08x ::|bdlr_org  0x%08x  |bdlr_min 0x%08x |bdlr_max 0x%08x  \n",
					4,
					dq_lcd_bdl_value_aclcdlr_org_a,
					dq_lcd_bdl_value_aclcdlr_min_a,dq_lcd_bdl_value_aclcdlr_max_a,
					dq_lcd_bdl_value_bdlr0_org_a,
					dq_lcd_bdl_value_bdlr0_min_a,dq_lcd_bdl_value_bdlr0_max_a);
		}
		printf("\n\n-----------------------------------------------------------------------------\n\n");
		{
			printf("\n ac_lane_0x0000000|  lcdlr_org  |lcdlr_set ps|lcdlr_hold ps:|\
					clk_setup  ps| clk_hold ps|adj_percent[100]\n");

			printf("\n ac_lane0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					4,
					dq_lcd_bdl_value_aclcdlr_org_a,
					(((dq_lcd_bdl_value_aclcdlr_max_a-dq_lcd_bdl_value_aclcdlr_org_a)*delay_step_x100
					 )/100),
					(((dq_lcd_bdl_value_aclcdlr_org_a-dq_lcd_bdl_value_aclcdlr_min_a)*delay_step_x100
					 )/100),

					0,
					0,
					100*(dq_lcd_bdl_value_aclcdlr_max_a+dq_lcd_bdl_value_aclcdlr_min_a)/(
						2*dq_lcd_bdl_value_aclcdlr_org_a));
			printf("\n ck_lane0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					4,
					dq_lcd_bdl_value_bdlr0_org_a,
					0,
					0,
					(((dq_lcd_bdl_value_bdlr0_org_a-dq_lcd_bdl_value_bdlr0_min_a)*delay_step_x100
					 )/100),
					(((dq_lcd_bdl_value_bdlr0_max_a-dq_lcd_bdl_value_bdlr0_org_a)*delay_step_x100
					 )/100),

					100*(dq_lcd_bdl_value_aclcdlr_max_a+dq_lcd_bdl_value_aclcdlr_min_a)/(
						2*dq_lcd_bdl_value_bdlr0_org_a));
		}
		printf("\n a_lane_0x00000000| wrdq_org 0x0|w_setup x ps|w_hold  x ps::|\
				rd_setup  ps|rd_hold x ps|adj_percent[100]\n");


		for ((lane_step=0);(lane_step<4);(lane_step++))
		{
			printf("\n a_lane_0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					lane_step,
					dq_lcd_bdl_value_wdq_org_a[lane_step],
					(((dq_lcd_bdl_value_wdq_max_a[lane_step]-dq_lcd_bdl_value_wdq_org_a[lane_step])*delay_step_x100
					 )/100),
					(((dq_lcd_bdl_value_wdq_org_a[lane_step]-dq_lcd_bdl_value_wdq_min_a[lane_step])*delay_step_x100
					 )/100),

					0,
					0,
					100*(dq_lcd_bdl_value_wdq_max_a[lane_step]+dq_lcd_bdl_value_wdq_min_a[lane_step])/(
						2*dq_lcd_bdl_value_wdq_org_a[lane_step]));

			printf("\n a_lane_0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					lane_step,
					dq_lcd_bdl_value_rdqs_org_a[lane_step],
					0,
					0,

					(((dq_lcd_bdl_value_rdqs_org_a[lane_step]-dq_lcd_bdl_value_rdqs_min_a[lane_step])*delay_step_x100
					 )/100),
					(((dq_lcd_bdl_value_rdqs_max_a[lane_step]-dq_lcd_bdl_value_rdqs_org_a[lane_step])*delay_step_x100
					 )/100),
					100*(dq_lcd_bdl_value_rdqs_max_a[lane_step]+dq_lcd_bdl_value_rdqs_min_a[lane_step])/(
						2*dq_lcd_bdl_value_rdqs_org_a[lane_step]));



		}
	}



	if (channel_b_en)
	{
		for ((lane_step=0);(lane_step<4);(lane_step++))
		{;
		}
	}

	return reg_value;
}


unsigned int do_ddr_uboot_window_init(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	char *endp;
	unsigned temp_count=0;
	for(;temp_count<argc;temp_count++)
	{
		printf("arg[%d]==%s;\n",argc,argv[temp_count]);
	}

	if (argc >1) {
		g_ddr_test_struct->ddr_data_source = simple_strtoull_ddr(argv[1], &endp, 16);
		if (*argv[1] == 0 || *endp != 0)
		{
			g_ddr_test_struct->ddr_data_source = DDR_PARAMETER_SOURCE_FROM_DMC_STICKY;
		}
	}
	if (argc >2) {
		g_ddr_test_struct->ddr_data_source = simple_strtoull_ddr(argv[2], &endp, 16);
		if (*argv[2] == 0 || *endp != 0)
		{
			g_ddr_test_struct->ddr_data_test_size = DDR_CORSS_TALK_TEST_SIZE;
		}
	}
	/*
	   g_ddr_test_struct->ddr_data_source	=
	   g_ddr_test_struct->ddr_data_test_size	=
	   g_ddr_test_struct->ddr_address_test_size	=
	   g_ddr_test_struct->ddr_test_watchdog_times_s	=
	   g_ddr_test_struct->ddr_test_lane_disable	=
	   g_ddr_test_struct->ddr_address_test_size	=
	   g_ddr_test_struct->ddr_address_test_size	=
	   */

	return 1;
}

unsigned int do_ddr_read_write_ddr_data_window_lcdlr(unsigned int rank_index,unsigned int data_index,unsigned int lcdlr_value,unsigned int read_write_flag )
{
	//char *endp;
	unsigned read_value=0;

	//return read_value;

#if 1
	unsigned reg_add=0;
	{
#if ( CONFIG_DDR_PHY<P_DDR_PHY_905X)
		{
			reg_add=((data_index>>1)*(DDR0_PUB_DX1LCDLR1-
						DDR0_PUB_DX0LCDLR1)
					+DDR0_PUB_DX0LCDLR1);
			if((data_index%2)==0)
			{
				if(read_write_flag==DDR_PARAMETER_READ)
				{
					lcdlr_value=((readl(reg_add))&0xff);
				}
				if(read_write_flag==DDR_PARAMETER_WRITE)
				{
					wr_reg(reg_add, ((readl(reg_add))&0xffffff00)|(lcdlr_value&0xff));
				}
			}
			if((data_index%2)==1)
			{
				if(read_write_flag==DDR_PARAMETER_READ)
				{
					lcdlr_value=(((readl(reg_add))>>8)&0xff);
				}
				if(read_write_flag==DDR_PARAMETER_WRITE)
				{
					wr_reg(reg_add, ((readl(reg_add))&0xffff00ff)|((lcdlr_value&0xff)<<8));
				}
			}
		}

#else

		if((data_index%2)==0)
		{
			reg_add=((data_index>>1)*(DDR0_PUB_DX1LCDLR1-
						DDR0_PUB_DX0LCDLR1)
					+DDR0_PUB_DX0LCDLR1);

		}
		if((data_index%2)==1)
		{
			reg_add=((data_index>>1)*(DDR0_PUB_DX1LCDLR1-
						DDR0_PUB_DX0LCDLR1)
					+DDR0_PUB_DX0LCDLR3);

		}
		if(read_write_flag==DDR_PARAMETER_READ)
		{
			lcdlr_value=(((readl(reg_add))>>0)&0x1ff);
		}
		if(read_write_flag==DDR_PARAMETER_WRITE)
		{
			wr_reg(reg_add, ((lcdlr_value&0x1ff)<<0));
		}

#endif
	}



	printf("lcdlr %d  %08x,%08x\n", data_index,reg_add,
			(readl(reg_add)));
	read_value=lcdlr_value;

	return read_value;

#endif 
}
unsigned int do_ddr_read_acmdlr(void )
{

	unsigned reg_value=0;
#if ( CONFIG_DDR_PHY<=P_DDR_PHY_905X)
	reg_value=(readl(DDR0_PUB_ACMDLR0));
	reg_value=(reg_value>>16)&0x1ff;
#endif
	return reg_value;
}
unsigned int do_ddr_read_write_ddr_add_window_lcdlr(unsigned int rank_index,unsigned int add_index,unsigned int lcdlr_value,unsigned int read_write_flag )
{
	unsigned reg_add=0;

	if(add_index==0)
		reg_add=(DDR0_PUB_ACLCDLR);
	if(add_index==1)
		reg_add=(DDR0_PUB_ACBDLR0);
	{
		if(read_write_flag==DDR_PARAMETER_READ)
		{
			lcdlr_value=(((readl(reg_add))>>0)&0x1ff);
		}
		if(read_write_flag==DDR_PARAMETER_WRITE)
		{
			wr_reg(reg_add, ((lcdlr_value&0x1ff)<<0));
		}

	}
	printf("lcdlr %d  %08x,%08x\n", add_index,reg_add,
			(readl(reg_add)));
	return lcdlr_value;
}

int do_ddr_uboot_window_use_source_quick_method(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{

	//setenv bootcmd "ddr_test_cmd 0x31 2 6  20 0 0x100000 0x4000000"
	printf("\nsetenv bootcmd ddr_test_cmd 0x32 2 6  20 0 0x100000 0x4000000 \n");
	printf("\nEnter do_ddr_uboot_window_use_source function\n");
	printf("\n--- watchdog should >15s\n");
#define DDR_TEST_NULL  0
#define DDR_TEST_PASS  1
#define DDR_TEST_FAIL 2

	char *endp;
	unsigned int   lane_disable= 0;
	unsigned int   data_source= 0;
	unsigned int  ddr_data_test_size=0x1000000;
	unsigned int  ddr_add_test_size=0x10000000;
	unsigned int  ddr_test_size=0x10000000;

	unsigned int  address_test_watchdog_time_s=15;
	unsigned int  test_watchdog_time_s=15;

	error_outof_count_flag =1;  //for quick out of error
	if (argc >1) {
		data_source = simple_strtoull_ddr(argv[1], &endp, 0);
		if (*argv[1] == 0 || *endp != 0)
		{
			data_source= DDR_PARAMETER_SOURCE_FROM_UBOOT_ENV;
		}
	}
	if (argc >2) {
		watchdog_time_s = simple_strtoull_ddr(argv[2], &endp, 0);
		if (*argv[2] == 0 || *endp != 0)
		{
			watchdog_time_s= 15;
		}
	}
	printf("watchdog_time_s==%d\n",watchdog_time_s);
	test_watchdog_time_s=watchdog_time_s;
	//test_watchdog_time_s=address_test_watchdog_time_s;
	if (argc >3) {
		address_test_watchdog_time_s = simple_strtoull_ddr(argv[3], &endp, 0);
		if (*argv[3] == 0 || *endp != 0)
		{
			address_test_watchdog_time_s= watchdog_time_s;
		}
	}
	printf("address_test_watchdog_time_s==%d\n",address_test_watchdog_time_s);
	//lane_disable=g_ddr_test_struct->ddr_test_lane_disable;
	if (argc >4) {
		lane_disable = simple_strtoull_ddr(argv[4], &endp, 0);
		if (*argv[4] == 0 || *endp != 0)
		{
			lane_disable= 0;
		}
	}
	printf("lane_disable==0x%08x\n",lane_disable);   

	if (argc >5) {
		ddr_data_test_size = simple_strtoull_ddr(argv[5], &endp, 0);
		if (*argv[5] == 0 || *endp != 0)
		{
			ddr_data_test_size= 0x100000;
		}
	}
	printf("ddr_data_test_size==0x%08x\n",ddr_data_test_size);
	if (argc >6) {
		ddr_add_test_size = simple_strtoull_ddr(argv[6], &endp, 0);
		if (*argv[6] == 0 || *endp != 0)
		{
			ddr_add_test_size= 0x10000000;
		}
	}
	printf("ddr_add_test_size==0x%08x\n",ddr_add_test_size);

	unsigned int rank_index=0;
	unsigned int temp_count=0;
	unsigned int ddr_test_data_array_max=100;
	unsigned int num_array[100];//8 flag 32_data add_8  32_data add_8

	unsigned int temp_test_error=0;
	unsigned int lcdlr_min=0;
	unsigned int lcdlr_max=0;
	memset(num_array, 0, sizeof(num_array));
	char str[1024]="";

	if(data_source==DDR_PARAMETER_SOURCE_FROM_DMC_STICKY)
		ddr_test_data_array_max=64;
	for (temp_count= 0;temp_count < ddr_test_data_array_max; temp_count++) 
	{
		num_array[temp_count]= read_write_window_test_parameter(data_source, 
				temp_count ,num_array[temp_count],DDR_PARAMETER_READ );
		printf("read numarry[%d]==%d\n",temp_count,num_array[temp_count]);
	}

	unsigned int test_arg_0_ab_best_lcdlr_value =0;  //best_lcdlr_value
	unsigned int test_arg_1_test_error_flag =0;  //min cmd
	unsigned int test_arg_2_step =0; //step 0  init  -1 lane0 w min  -2 lane0 w max -3 lane0 r min    4 lane0 r max -----5 lane1 w min ...
	unsigned int test_arg_3_freq =0;
	unsigned int test_arg_4_step_status =0; //uboot test we should read error then done status.  0 no test 1 ongoing 2 this step done  fail or pass
	unsigned int test_arg_5_ab_edge_lcdlr_value =0;
	unsigned int test_arg_6_lcdlr_temp_count =0;
	unsigned int test_arg_7_magic_number =0;
	unsigned int org_lcdlr_value_temp=0;
	unsigned int acmdlr=0;
	acmdlr=do_ddr_read_acmdlr();

	test_arg_0_ab_best_lcdlr_value=num_array[0];
	test_arg_1_test_error_flag=num_array[1];
	test_arg_2_step=num_array[2];
	test_arg_3_freq=num_array[3];
	test_arg_4_step_status=num_array[4];
	test_arg_5_ab_edge_lcdlr_value=num_array[5];
	test_arg_6_lcdlr_temp_count=num_array[6];
	test_arg_7_magic_number=num_array[7];
	printf("test_arg_0_ab_best_lcdlr_value==%d\n",test_arg_0_ab_best_lcdlr_value);
	printf("test_arg_1_test_error_flag==%d\n",test_arg_1_test_error_flag);
	printf("test_arg_2_step==%d\n",test_arg_2_step);
	printf("test_arg_3_freq==%d\n",test_arg_3_freq);
	printf("test_arg_4_step_status==%d\n",test_arg_4_step_status);
	printf("test_arg_5_ab_edge_lcdlr_value=%d\n",num_array[5]);
	printf("test_arg_6_lcdlr_temp_count=%d\n",num_array[6]);
	printf("test_arg_7_magic_number=%d\n",num_array[7]);



	if((test_arg_7_magic_number==DMC_STICKY_MAGIC_1)) //for check magic number make sume enter test command
	{
	}
	else
	{

		test_arg_0_ab_best_lcdlr_value=0;
		test_arg_5_ab_edge_lcdlr_value=0;
		test_arg_2_step=0;
		test_arg_6_lcdlr_temp_count=0;
		test_arg_7_magic_number=DMC_STICKY_MAGIC_1;
	}
	//printf("boot times==%d\n",test_arg_5_ab_edge_lcdlr_value);
	num_array[0]	=	test_arg_0_ab_best_lcdlr_value		;
	num_array[1]	=	test_arg_1_test_error_flag		;
	num_array[2]	=	test_arg_2_step		;
	num_array[3]	=	test_arg_3_freq		;
	num_array[4]	=	test_arg_4_step_status		;
	num_array[5]	=	test_arg_5_ab_edge_lcdlr_value		;
	num_array[6]	=	test_arg_6_lcdlr_temp_count		;
	num_array[7]	=	test_arg_7_magic_number		;

	for (temp_count= 0;temp_count < 8; temp_count++) 
	{
		read_write_window_test_parameter(data_source, 
				temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
	}



	if(test_arg_2_step)
	{
		if(test_arg_3_freq!=global_ddr_clk)  //
		{
			printf("running ddr freq==%d,but test freq is%d,will reboot use d2pll \n",global_ddr_clk,test_arg_3_freq);
			sprintf(str,"d2pll  %d",test_arg_3_freq);
			printf("\nstr=%s\n",str);
			run_command(str,0);
			while(1);
		}
	}
	if(test_arg_2_step==0)
	{
		{
			test_arg_0_ab_best_lcdlr_value=0;
			test_arg_1_test_error_flag=0;
			test_arg_2_step=1;
			test_arg_3_freq=global_ddr_clk;
			test_arg_4_step_status=0;
			test_arg_5_ab_edge_lcdlr_value=0;
			test_arg_6_lcdlr_temp_count=lcdlr_min;
			test_arg_7_magic_number=DMC_STICKY_MAGIC_1;
			num_array[0]	=	test_arg_0_ab_best_lcdlr_value		;
			num_array[1]	=	test_arg_1_test_error_flag		;
			num_array[2]	=	test_arg_2_step		;
			num_array[3]	=	test_arg_3_freq		;
			num_array[4]	=	test_arg_4_step_status		;
			num_array[5]	=	test_arg_5_ab_edge_lcdlr_value		;
			num_array[6]	=	test_arg_6_lcdlr_temp_count		;
			num_array[7]	=	test_arg_7_magic_number		;


			for (temp_count= 0;temp_count < 8; temp_count++) 
			{
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
			}


			//for (temp_count = 8; temp_count< 48;temp_count++) {
			//		num_array[temp_count]=0;
			//}

			for (temp_count = 8; temp_count < (32+8); temp_count++)   //data
			{
				//printf("1temp_count=%d\n",temp_count);

				if((temp_count%4)==0)  //org
				{
					if(((temp_count-8)/4)<8)  
					{
						lcdlr_min=0;
						lcdlr_max=(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//if(lane_step==9)
						//lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
					}
					else if(((temp_count-8)/4)<10)  
					{
						lcdlr_min=0;
						lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						if(((temp_count-8)/4)==9)
							lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
					}
					//printf("2temp_count=%d\n",temp_count);
					//num_array[temp_count]=0;
					//unsigned int do_ddr_read_write_ddr_data_window_lcdlr(unsigned int rank_index,unsigned int data_add_index,unsigned int lcdlr_value,unsigned int read_write_flag ))
					num_array[temp_count]=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,((temp_count-8)>>2),num_array[temp_count],DDR_PARAMETER_READ);
					num_array[temp_count+1]=lcdlr_min;
					num_array[temp_count+2]=lcdlr_max;//num_array[temp_count];
					num_array[temp_count+3]=0;
					//temp_count=temp_count+4;
				}



			}

			for (temp_count = 32+8; temp_count < (32+8+8); temp_count++)  //add
			{
				if((temp_count%4)==0)  //org
				{	
					if(((temp_count-8)/4)<8)  
					{
						lcdlr_min=0;
						lcdlr_max=(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//if(lane_step==9)
						//lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
					}
					else if(((temp_count-8)/4)<10)  
					{
						lcdlr_min=0;
						lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						if(((temp_count-8)/4)==9)
							lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
					}
					//num_array[temp_count]=0;
					//unsigned int do_ddr_read_write_ddr_data_window_lcdlr(unsigned int rank_index,unsigned int data_add_index,unsigned int lcdlr_value,unsigned int read_write_flag ))
					num_array[temp_count]=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,((temp_count-8-32)>>2),num_array[temp_count],DDR_PARAMETER_READ);
					num_array[temp_count+1]=lcdlr_min;
					num_array[temp_count+2]=lcdlr_max;//num_array[temp_count];
					num_array[temp_count+3]=0;
				}


			}




#if  (CONFIG_DDR_PHY<=P_DDR_PHY_905X)
			printf("DDR0_PUB_DX0GCR0==%x\n",(readl(DDR0_PUB_DX0GCR0)));
			printf("DDR0_PUB_DX1GCR0==%x\n",(readl(DDR0_PUB_DX1GCR0)));
			printf("DDR0_PUB_DX2GCR0==%x\n",(readl(DDR0_PUB_DX2GCR0)));
			printf("DDR0_PUB_DX3GCR0==%x\n",(readl(DDR0_PUB_DX3GCR0)));
			if(((readl(DDR0_PUB_DX0GCR0))&1)==0)
				lane_disable=   lane_disable|1;      
			if(((readl(DDR0_PUB_DX1GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<1);   
			if(((readl(DDR0_PUB_DX2GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<2);   
			if(((readl(DDR0_PUB_DX3GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<3);   

#endif
			if(lane_disable)
			{if(lane_disable&0x1){
									 num_array[8+3]=0xffff;
									 num_array[8+4+3]=0xffff;
								 }
			if(lane_disable&0x2){
				num_array[8+3+8]=0xffff;
				num_array[8+4+3+8]=0xffff;
			}
			if(lane_disable&0x4){
				num_array[8+3+8+8]=0xffff;
				num_array[8+4+3+8+8]=0xffff;
			}
			if(lane_disable&0x8){
				num_array[8+3+8+8+8]=0xffff;
				num_array[8+4+3+8+8+8]=0xffff;
			}
			printf("lane_disable==%x\n",lane_disable);
			if(lane_disable&0x10){
				num_array[8+3+8+8+8+8]=0xffff;
			}
			if(lane_disable&0x20){
				num_array[8+4+3+8+8+8+8]=0xffff;

			}
			}


		}




		for (temp_count= 0; temp_count< 48;temp_count++) {
			num_array[temp_count]= read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
		}
	}

	test_arg_2_step++;
	num_array[2]=test_arg_2_step;
	for (temp_count = 1; temp_count < 48; temp_count++) 
	{
		printf("%d  %d\n", temp_count,num_array[temp_count]);
	}
	temp_count=2;
	num_array[temp_count]= read_write_window_test_parameter(data_source, 
			temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
	//for (i = 0; i < 48; i++) {

	//	 writel(num_array[i],(sticky_reg_base_add+(i<<2)));
	//}


	//for (i = 8; i < 48; i++) {
	//num_array[i]=readl((sticky_reg_base_add+(i<<2)));
	//printf("ddr_test_data_num_%04d==%d\n",i,num_array[i]);
	//}

	///*
	unsigned int lane_step=0;

	printf("\nstart loop test\n");

	for ((lane_step=0);(lane_step<10);(lane_step++))   //find need test data step
	{
		if((num_array[(lane_step<<2)+3+8]<0x4))
		{break;
		}
	}
	printf("\nstart  test lane_step =%d\n",lane_step);
	if(lane_step<10)
	{
		if(lane_step<8)
		{
			test_watchdog_time_s=watchdog_time_s;
			ddr_test_size=ddr_data_test_size;
			//lcdlr_min=0;
			//lcdlr_max=(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);//do_ddr_read_acmdlr();
		}
		else
		{
			test_watchdog_time_s=address_test_watchdog_time_s;
			ddr_test_size=ddr_add_test_size;
			//lcdlr_min=0;
			//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
			//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
			//if(lane_step==9)
			//lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
		}

		if((num_array[8+(lane_step<<2)+3]==0))   //test left edge begin
		{
			/*
			   num_array[1]	=	test_arg_1_test_error_flag		;//1 pass 2 error
			   num_array[2]	=	test_arg_2_step		;
			   num_array[3]	=	test_arg_3_freq		;
			   num_array[4]	=	test_arg_4_step_status		;
			   num_array[5]	=	test_arg_5_ab_edge_lcdlr_value		;
			   num_array[6]	=	test_arg_6_lcdlr_temp_count		;
			   num_array[7]	=	test_arg_7_magic_number		;
			   */
			//         test_arg_0_ab_best_lcdlr_value=(num_array[8+(lane_step<<2)+0]);
			//	 num_array[0]=test_arg_0_ab_best_lcdlr_value;
			//	 temp_count=0;
			//	 read_write_window_test_parameter(data_source, 
			// 	 temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

			num_array[1]=DDR_TEST_NULL;  //1 //pass 2 error
			num_array[1]=DDR_TEST_FAIL;  //1 //pass 2 error
			temp_count=1;
			read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

			num_array[5]=(num_array[8+(lane_step<<2)+1]);  //edge lcdlr
			temp_count=5;
			read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

			(num_array[8+(lane_step<<2)+1])=(num_array[8+(lane_step<<2)+0]);  
			temp_count=8+(lane_step<<2)+1;
			read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);


			test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+0])>>1);
			num_array[6]=test_arg_6_lcdlr_temp_count;                       //temp_lcdlr
			temp_count=6;
			read_write_window_test_parameter(data_source,  //temp_lcdlr
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

			num_array[8+(lane_step<<2)+3]=1;
			temp_count=8+(lane_step<<2)+3;
			read_write_window_test_parameter(data_source, //lane status
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
			ddr_test_watchdog_enable(test_watchdog_time_s); //s
			printf("\nenable %ds watchdog \n",test_watchdog_time_s);
			ddr_test_watchdog_clear();
			if(lane_step<8)
				test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
			else if(lane_step<10)
				test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

			//here will dead
			temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

			if (temp_test_error)
			{
				run_command("reset",0);
				while(1);
			}
			else
			{
				ddr_test_watchdog_clear();
				org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
				if(lane_step<8)
					org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
				else if(lane_step<10)
					org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

				num_array[1]=DDR_TEST_PASS;  //pass 2 error 1
				temp_count=1;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
				run_command("reset",0);
				while(1);

			}
		}
		else if((num_array[8+(lane_step<<2)+3]==1))   //test left edge ongoing    -loop
		{

			if((num_array[5]+1)>=(num_array[6]))
			{
				if(num_array[1]==DDR_TEST_NULL)
				{printf("default value not stable ,or recovery sticky?\n");
				}


				num_array[8+(lane_step<<2)+3]=2;  //update status
				temp_count=8+(lane_step<<2)+3;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				num_array[5]=0;  //update edge lcdlr
				temp_count=5;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
				if(num_array[1]==DDR_TEST_FAIL)
					num_array[8+(lane_step<<2)+1]=num_array[6]+1;   //update B
				if(num_array[1]==DDR_TEST_PASS)
					num_array[8+(lane_step<<2)+1]=num_array[6];   //update B
				temp_count=8+(lane_step<<2)+1;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				test_arg_6_lcdlr_temp_count=0;  //curren_test +B  //(A+B)/2
				num_array[6]=test_arg_6_lcdlr_temp_count;                                          //--update curent
				temp_count=6;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
				num_array[1]=DDR_TEST_NULL;  //1 //pass 2 error
				temp_count=1;                                                                    //update test error flag
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				//  test_arg_0_ab_best_lcdlr_value=0;//(num_array[8+(lane_step<<2)+0]);
				// num_array[0]=test_arg_0_ab_best_lcdlr_value;
				// temp_count=0;
				// read_write_window_test_parameter(data_source, 
				// temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
				run_command("reset",0); 
				while(1);

			}
			else 
			{ 
				if(num_array[1]==DDR_TEST_NULL)
				{printf("default value not stable ,or recovery sticky?\n");
				}
				else  if(num_array[1]==DDR_TEST_FAIL)
				{



					{
						num_array[8+(lane_step<<2)+3]=1;  //update status
						temp_count=8+(lane_step<<2)+3;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);


						num_array[5]=num_array[6];  //update edge lcdlr
						temp_count=5;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

						test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+1])>>1);  //curren_test +B  //(A+B)/2
						num_array[6]=test_arg_6_lcdlr_temp_count;                                          //--update curent
						temp_count=6;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

						// num_array[8+(lane_step<<2)+1]=num_array[8+(lane_step<<2)+1];   //update B
						// temp_count=8+(lane_step<<2)+1;
						// read_write_window_test_parameter(data_source, 
						// temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
						num_array[1]=DDR_TEST_FAIL;  //1 //pass 2 error
						temp_count=1;                                                                    //update test error flag
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

						ddr_test_watchdog_enable(test_watchdog_time_s); //s
						printf("\nenable %ds watchdog \n",test_watchdog_time_s);
						ddr_test_watchdog_clear();
						if(lane_step<8)
							test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
						else if(lane_step<10)
							test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

						//here will dead
						temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

						if (temp_test_error)
						{
							run_command("reset",0);
							while(1);
						}
						else
						{
							ddr_test_watchdog_clear();
							org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
							if(lane_step<8)
								org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
							else if(lane_step<10)
								org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

							num_array[1]=DDR_TEST_PASS;  //pass 2 error 1
							temp_count=1;
							read_write_window_test_parameter(data_source, 
									temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
							run_command("reset",0);
							while(1);

						}
					}
				}

				else	  if(num_array[1]==DDR_TEST_PASS)
				{
					num_array[8+(lane_step<<2)+3]=1;  //update status
					temp_count=8+(lane_step<<2)+3;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

					num_array[8+(lane_step<<2)+1]=num_array[6];  //update min value
					temp_count=8+(lane_step<<2)+1;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

					test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+1])>>1);  //curren_test +B  //(A+B)/2
					num_array[6]=test_arg_6_lcdlr_temp_count;                                          // --update curent
					temp_count=6;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

					num_array[1]=DDR_TEST_FAIL;  //1 //pass 2 error
					temp_count=1;                                                                    //update test error flag
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

					ddr_test_watchdog_enable(test_watchdog_time_s); //s
					printf("\nenable %ds watchdog \n",test_watchdog_time_s);
					ddr_test_watchdog_clear();
					if(lane_step<8)
						test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
					else if(lane_step<10)
						test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

					//here will dead
					temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

					if (temp_test_error)
					{
						run_command("reset",0);
						while(1);
					}
					else
					{
						ddr_test_watchdog_clear();
						org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
						if(lane_step<8)
							org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
						else if(lane_step<10)
							org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

						num_array[1]=DDR_TEST_PASS;  //pass 2 error 1
						temp_count=1;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
						run_command("reset",0);
						while(1);

					}

				}
			}


		}

		else  if((num_array[8+(lane_step<<2)+3]==2))   //test right edge begin
		{
			/*
			   num_array[1]	=	test_arg_1_test_error_flag		;//1 pass 2 error
			   num_array[2]	=	test_arg_2_step		;
			   num_array[3]	=	test_arg_3_freq		;
			   num_array[4]	=	test_arg_4_step_status		;
			   num_array[5]	=	test_arg_5_ab_edge_lcdlr_value		;
			   num_array[6]	=	test_arg_6_lcdlr_temp_count		;
			   num_array[7]	=	test_arg_7_magic_number		;
			   */
			num_array[1]=DDR_TEST_NULL;  //1 //pass 2 error
			num_array[1]=DDR_TEST_FAIL;  //1 //pass 2 error
			temp_count=1;
			read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

			num_array[5]=num_array[8+(lane_step<<2)+2];//lcdlr_max;  //edge lcdlr
			temp_count=5;
			read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

			num_array[8+(lane_step<<2)+2]=num_array[8+(lane_step<<2)+0];//
			temp_count=8+(lane_step<<2)+2;
			read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

			test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+2])>>1);
			num_array[6]=test_arg_6_lcdlr_temp_count;                       //temp_lcdlr
			temp_count=6;
			read_write_window_test_parameter(data_source,  //temp_lcdlr
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

			num_array[8+(lane_step<<2)+3]=3;
			temp_count=8+(lane_step<<2)+3;
			read_write_window_test_parameter(data_source, //lane status
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
			ddr_test_watchdog_enable(test_watchdog_time_s); //s
			printf("\nenable %ds watchdog \n",test_watchdog_time_s);
			ddr_test_watchdog_clear();
			if(lane_step<8)
				test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
			else if(lane_step<10)
				test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

			//here will dead
			temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

			if (temp_test_error)
			{
				run_command("reset",0);
				while(1);
			}
			else
			{
				ddr_test_watchdog_clear();
				org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
				if(lane_step<8)
					org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
				else if(lane_step<10)
					org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

				num_array[1]=DDR_TEST_PASS;  //pass 2 error 1
				temp_count=1;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
				run_command("reset",0);
				while(1);

			}
		}
		else if((num_array[8+(lane_step<<2)+3]==3))   //test right edge ongoing    -loop
		{

			if((num_array[6]+1)>=(num_array[5]))
			{
				if(num_array[1]==DDR_TEST_NULL)
				{printf("default value not stable ,or recovery sticky?\n");
				}
				num_array[8+(lane_step<<2)+3]=4;  //update status
				temp_count=8+(lane_step<<2)+3;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				num_array[5]=0;  //update edge lcdlr
				temp_count=5;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
				if(num_array[1]==DDR_TEST_FAIL)
					num_array[8+(lane_step<<2)+2]=num_array[6]-1;   //update B
				if(num_array[1]==DDR_TEST_PASS)
					num_array[8+(lane_step<<2)+2]=num_array[6];   //update B
				temp_count=8+(lane_step<<2)+2;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				test_arg_6_lcdlr_temp_count=0;  //curren_test +B  //(A+B)/2
				num_array[6]=test_arg_6_lcdlr_temp_count;                                          //--update curent
				temp_count=6;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
				num_array[1]=DDR_TEST_NULL;  //1 //pass 2 error
				temp_count=1;                                                                    //update test error flag
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				run_command("reset",0); 
				while(1);
			}
			else 
			{ 
				if(num_array[1]==DDR_TEST_NULL)
				{printf("default value not stable ,or recovery sticky?\n");
				}
				else  if(num_array[1]==DDR_TEST_FAIL)
				{



					{
						num_array[8+(lane_step<<2)+3]=3;  //update status
						temp_count=8+(lane_step<<2)+3;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);


						num_array[5]=num_array[6];  //update edge lcdlr
						temp_count=5;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

						test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+2])>>1);  //curren_test +B  //(A+B)/2
						num_array[6]=test_arg_6_lcdlr_temp_count;                                          //--update curent
						temp_count=6;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

						// num_array[8+(lane_step<<2)+1]=num_array[8+(lane_step<<2)+1];   //update B
						// temp_count=8+(lane_step<<2)+1;
						// read_write_window_test_parameter(data_source, 
						// temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
						num_array[1]=DDR_TEST_FAIL;  //1 //pass 2 error
						temp_count=1;                                                                    //update test error flag
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

						ddr_test_watchdog_enable(test_watchdog_time_s); //s
						printf("\nenable %ds watchdog \n",test_watchdog_time_s);
						ddr_test_watchdog_clear();
						if(lane_step<8)
							test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
						else if(lane_step<10)
							test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

						//here will dead
						temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

						if (temp_test_error)
						{
							run_command("reset",0);
							while(1);
						}
						else
						{
							ddr_test_watchdog_clear();
							org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
							if(lane_step<8)
								org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
							else if(lane_step<10)
								org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

							num_array[1]=DDR_TEST_PASS;  //pass 2 error 1
							temp_count=1;
							read_write_window_test_parameter(data_source, 
									temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
							run_command("reset",0);
							while(1);

						}
					}
				}

				else	  if(num_array[1]==DDR_TEST_PASS)
				{
					num_array[8+(lane_step<<2)+3]=3;  //update status
					temp_count=8+(lane_step<<2)+3;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

					num_array[8+(lane_step<<2)+2]=num_array[6];  //update max value
					temp_count=8+(lane_step<<2)+2;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

					test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+2])>>1);  //curren_test +B  //(A+B)/2
					num_array[6]=test_arg_6_lcdlr_temp_count;                                          // --update curent
					temp_count=6;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

					num_array[1]=DDR_TEST_FAIL;  //1 //pass 2 error
					temp_count=1;                                                                    //update test error flag
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

					ddr_test_watchdog_enable(test_watchdog_time_s); //s
					printf("\nenable %ds watchdog \n",test_watchdog_time_s);
					ddr_test_watchdog_clear();
					if(lane_step<8)
						test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
					else if(lane_step<10)
						test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

					//here will dead
					temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

					if (temp_test_error)
					{
						run_command("reset",0);
						while(1);
					}
					else
					{
						ddr_test_watchdog_clear();
						org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
						if(lane_step<8)
							org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
						else if(lane_step<10)
							org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

						num_array[1]=DDR_TEST_PASS;  //pass 2 error 1
						temp_count=1;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
						run_command("reset",0);
						while(1);

					}

				}
			}


		}
	}

	if(lane_step>=10) //finish
	{
		ddr_test_watchdog_disable(); //s
		printf("close  watchdog\n");
	}

	// unsigned int   acmdlr= 0;
	unsigned int  delay_step_x100= 0;

	{
		//acmdlr=do_ddr_read_acmdlr();
		delay_step_x100=100*1000000/(2*global_ddr_clk*acmdlr);
		printf("\nacmdlr=0x%08x-->dec %d,ddr clk==%d,step=%d ps,10step=%d ps,100step=%d ps,\n",acmdlr,acmdlr,global_ddr_clk,
				delay_step_x100/100,delay_step_x100/10,delay_step_x100);

		for ((lane_step=0);(lane_step<4);(lane_step++))
		{
			printf("\n a_lane_0x%08x|wdq_org 0x%08x  |wdq_min 0x%08x |wdq_max 0x%08x ::|rdqs_org  0x%08x  |rdqs_min 0x%08x |rdqs_max 0x%08x  \n",
					lane_step,
					num_array[8+(lane_step)*8+0],num_array[8+(lane_step)*8+1],num_array[8+(lane_step)*8+2],
					num_array[8+(lane_step)*8+4],num_array[8+(lane_step)*8+5],num_array[8+(lane_step)*8+6]);
		}
		lane_step=4;
		{
			printf("\nac_lane_0x%08x|lcd_org 0x%08x  |lcd_min 0x%08x |lcd_max 0x%08x ::|bdlr_org  0x%08x  |bdlr_min 0x%08x |bdlr_max 0x%08x  \n",
					4,
					num_array[8+(lane_step)*8+0],num_array[8+(lane_step)*8+1],num_array[8+(lane_step)*8+2],
					num_array[8+(lane_step)*8+4],num_array[8+(lane_step)*8+5],num_array[8+(lane_step)*8+6]);
		}
		printf("\n\n-----------------------------------------------------------------------------\n\n");
		{
			printf("\n ac_lane_0x0000000|  lcdlr_org  |lcdlr_set ps|lcdlr_hold ps:|\
					clk_setup  ps| clk_hold ps|adj_percent[100]\n");

			printf("\n ac_lane0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					4,
					num_array[8+(lane_step)*8+0],
					(((num_array[8+(lane_step)*8+2]-num_array[8+(lane_step)*8+0])*delay_step_x100
					 )/100),
					(((num_array[8+(lane_step)*8+0]-num_array[8+(lane_step)*8+1])*delay_step_x100
					 )/100),

					0,
					0,
					100*(num_array[8+(lane_step)*8+2]+num_array[8+(lane_step)*8+1])/(
						2*num_array[8+(lane_step)*8+0]));
			printf("\n ck_lane0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					4,
					num_array[8+(lane_step)*8+4],
					0,
					0,
					(((num_array[8+(lane_step)*8+4]-num_array[8+(lane_step)*8+5])*delay_step_x100
					 )/100),
					(((num_array[8+(lane_step)*8+6]-num_array[8+(lane_step)*8+4])*delay_step_x100
					 )/100),

					100*(num_array[8+(lane_step)*8+6]+num_array[8+(lane_step)*8+5])/(
						2*num_array[8+(lane_step)*8+4]));
		}
		printf("\n a_lane_0x00000000| wrdq_org 0x0|w_setup x ps|w_hold  x ps::|\
				rd_setup  ps|rd_hold x ps|adj_percent[100]\n");


		for ((lane_step=0);(lane_step<4);(lane_step++))
		{
			printf("\n a_lane_0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					lane_step,
					num_array[8+(lane_step)*8+0],
					(((num_array[8+(lane_step)*8+2]-num_array[8+(lane_step)*8+0])*delay_step_x100
					 )/100),
					(((num_array[8+(lane_step)*8+0]-num_array[8+(lane_step)*8+1])*delay_step_x100
					 )/100),

					0,
					0,
					100*(num_array[8+(lane_step)*8+2]+num_array[8+(lane_step)*8+1])/(
						2*num_array[8+(lane_step)*8+0]));

			printf("\n a_lane_0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					lane_step,
					num_array[8+(lane_step)*8+4],
					0,
					0,

					(((num_array[8+(lane_step)*8+4]-num_array[8+(lane_step)*8+5])*delay_step_x100
					 )/100),
					(((num_array[8+(lane_step)*8+6]-num_array[8+(lane_step)*8+4])*delay_step_x100
					 )/100),
					100*(num_array[8+(lane_step)*8+6]+num_array[8+(lane_step)*8+5])/(
						2*num_array[8+(lane_step)*8+4]));



		}
	}

	test_arg_2_step=0x10000;
	num_array[2]=test_arg_2_step;



	temp_count=2;
	read_write_window_test_parameter(data_source, 
			temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

	return 1;
}

int do_ddr_uboot_window_use_source(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{

	//setenv bootcmd "ddr_test_cmd 0x31 2 6  20 0 0x100000 0x4000000"
	printf("\nsetenv bootcmd ddr_test_cmd 0x31 2 6  20 0 0x100000 0x4000000 \n");
	printf("\nEnter do_ddr_uboot_window_use_source function\n");
	printf("\n--- watchdog should >15s\n");

	char *endp;
	unsigned int   lane_disable= 0;
	unsigned int   data_source= 0;
	unsigned int  ddr_data_test_size=0x1000000;
	unsigned int  ddr_add_test_size=0x10000000;
	unsigned int  ddr_test_size=0x10000000;

	unsigned int  address_test_watchdog_time_s=15;
	unsigned int  test_watchdog_time_s=15;

	error_outof_count_flag =1;  //for quick out of error
	if (argc >1) {
		data_source = simple_strtoull_ddr(argv[1], &endp, 0);
		if (*argv[1] == 0 || *endp != 0)
		{
			data_source= DDR_PARAMETER_SOURCE_FROM_UBOOT_ENV;
		}
	}
	if (argc >2) {
		watchdog_time_s = simple_strtoull_ddr(argv[2], &endp, 0);
		if (*argv[2] == 0 || *endp != 0)
		{
			watchdog_time_s= 15;
		}
	}
	printf("watchdog_time_s==%d\n",watchdog_time_s);
	test_watchdog_time_s=watchdog_time_s;
	//test_watchdog_time_s=address_test_watchdog_time_s;
	if (argc >3) {
		address_test_watchdog_time_s = simple_strtoull_ddr(argv[3], &endp, 0);
		if (*argv[3] == 0 || *endp != 0)
		{
			address_test_watchdog_time_s= watchdog_time_s;
		}
	}
	printf("address_test_watchdog_time_s==%d\n",address_test_watchdog_time_s);
	//lane_disable=g_ddr_test_struct->ddr_test_lane_disable;
	if (argc >4) {
		lane_disable = simple_strtoull_ddr(argv[4], &endp, 0);
		if (*argv[4] == 0 || *endp != 0)
		{
			lane_disable= 0;
		}
	}
	printf("lane_disable==0x%08x\n",lane_disable);   

	if (argc >5) {
		ddr_data_test_size = simple_strtoull_ddr(argv[5], &endp, 0);
		if (*argv[5] == 0 || *endp != 0)
		{
			ddr_data_test_size= 0x100000;
		}
	}
	printf("ddr_data_test_size==0x%08x\n",ddr_data_test_size);
	if (argc >6) {
		ddr_add_test_size = simple_strtoull_ddr(argv[6], &endp, 0);
		if (*argv[6] == 0 || *endp != 0)
		{
			ddr_add_test_size= 0x10000000;
		}
	}
	printf("ddr_add_test_size==0x%08x\n",ddr_add_test_size);

	unsigned int rank_index=0;
	unsigned int temp_count=0;
	unsigned int ddr_test_data_array_max=100;
	unsigned int num_array[100];//8 flag 32_data add_8  32_data add_8

	unsigned int temp_test_error=0;
	unsigned int lcdlr_min=0;
	unsigned int lcdlr_max=0;
	memset(num_array, 0, sizeof(num_array));
	char str[1024]="";

	if(data_source==DDR_PARAMETER_SOURCE_FROM_DMC_STICKY)
		ddr_test_data_array_max=64;
	for (temp_count= 0;temp_count < ddr_test_data_array_max; temp_count++) 
	{
		num_array[temp_count]= read_write_window_test_parameter(data_source, 
				temp_count ,num_array[temp_count],DDR_PARAMETER_READ );
		printf("read numarry[%d]==%d\n",temp_count,num_array[temp_count]);
	}

	unsigned int test_arg_0_cmd0 =0;  //master cmd
	unsigned int test_arg_1_cmd1 =0;  //min cmd
	unsigned int test_arg_2_step =0; //step 0  init  -1 lane0 w min  -2 lane0 w max -3 lane0 r min    4 lane0 r max -----5 lane1 w min ...
	unsigned int test_arg_3_freq =0;
	unsigned int test_arg_4_step_status =0; //uboot test we should read error then done status.  0 no test 1 ongoing 2 this step done  fail or pass
	unsigned int test_arg_5_boottimes =0;
	unsigned int test_arg_6_lcdlr_temp_count =0;
	unsigned int test_arg_7_magic_number =0;
	unsigned int org_lcdlr_value_temp=0;
	unsigned int acmdlr=0;
	acmdlr=do_ddr_read_acmdlr();

	test_arg_0_cmd0=num_array[0];
	test_arg_1_cmd1=num_array[1];
	test_arg_2_step=num_array[2];
	test_arg_3_freq=num_array[3];
	test_arg_4_step_status=num_array[4];
	test_arg_5_boottimes=num_array[5];
	test_arg_6_lcdlr_temp_count=num_array[6];
	test_arg_7_magic_number=num_array[7];
	printf("test_arg_0_cmd0==%d\n",test_arg_0_cmd0);
	printf("test_arg_0_cmd1==%d\n",test_arg_1_cmd1);
	printf("test_arg_2_step==%d\n",test_arg_2_step);
	printf("test_arg_3_freq==%d\n",test_arg_3_freq);
	printf("test_arg_4_step_status==%d\n",test_arg_4_step_status);
	printf("test_arg_5_boottimes=%d\n",num_array[5]);
	printf("test_arg_6_lcdlr_temp_count=%d\n",num_array[6]);
	printf("test_arg_7_magic_number=%d\n",num_array[7]);



	if((test_arg_7_magic_number==DMC_STICKY_MAGIC_1)) //for check magic number make sume enter test command
	{test_arg_5_boottimes++;

	}
	else
	{test_arg_5_boottimes=0;
		test_arg_2_step=0;
		test_arg_6_lcdlr_temp_count=0;
		test_arg_7_magic_number=DMC_STICKY_MAGIC_1;
	}
	printf("boot times==%d\n",test_arg_5_boottimes);
	num_array[0]	=	test_arg_0_cmd0		;
	num_array[1]	=	test_arg_1_cmd1		;
	num_array[2]	=	test_arg_2_step		;
	num_array[3]	=	test_arg_3_freq		;
	num_array[4]	=	test_arg_4_step_status		;
	num_array[5]	=	test_arg_5_boottimes		;
	num_array[6]	=	test_arg_6_lcdlr_temp_count		;
	num_array[7]	=	test_arg_7_magic_number		;

	for (temp_count= 0;temp_count < 8; temp_count++) 
	{
		read_write_window_test_parameter(data_source, 
				temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
	}



	if(test_arg_2_step)
	{
		if(test_arg_3_freq!=global_ddr_clk)  //
		{
			printf("running ddr freq==%d,but test freq is%d,will reboot use d2pll \n",global_ddr_clk,test_arg_3_freq);
			sprintf(str,"d2pll  %d",test_arg_3_freq);
			printf("\nstr=%s\n",str);
			run_command(str,0);
			while(1);
		}
	}
	if(test_arg_2_step==0)
	{
		{
			test_arg_0_cmd0=0X31;//DDR_TEST_CMD__DDR_SET_UBOOT_KERNEL_WINDOW;
			test_arg_1_cmd1=0;
			test_arg_2_step=1;
			test_arg_3_freq=global_ddr_clk;
			test_arg_4_step_status=0;
			test_arg_6_lcdlr_temp_count=lcdlr_min;
			num_array[0]	=	test_arg_0_cmd0		;
			num_array[1]	=	test_arg_1_cmd1		;
			num_array[2]	=	test_arg_2_step		;
			num_array[3]	=	test_arg_3_freq		;
			num_array[4]	=	test_arg_4_step_status		;
			num_array[5]	=	test_arg_5_boottimes		;
			num_array[6]	=	test_arg_6_lcdlr_temp_count		;
			num_array[7]	=	test_arg_7_magic_number		;

			for (temp_count= 0;temp_count < 8; temp_count++) 
			{
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
			}


			//for (temp_count = 8; temp_count< 48;temp_count++) {
			//		num_array[temp_count]=0;
			//}

			for (temp_count = 8; temp_count < (32+8); temp_count++)   //data
			{
				//printf("1temp_count=%d\n",temp_count);
				if((temp_count%4)==0)  //org
				{
					//printf("2temp_count=%d\n",temp_count);
					//num_array[temp_count]=0;
					//unsigned int do_ddr_read_write_ddr_data_window_lcdlr(unsigned int rank_index,unsigned int data_add_index,unsigned int lcdlr_value,unsigned int read_write_flag ))
					num_array[temp_count]=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,((temp_count-8)>>2),num_array[temp_count],DDR_PARAMETER_READ);

				}
				if((temp_count%4)==1)  //min
				{	
					num_array[temp_count]=0;
				}
				if((temp_count%4)==2) //max
				{	
					num_array[temp_count]=acmdlr;
				}
				if((temp_count%4)==3) //status
				{	
					num_array[temp_count]=0;
				}


			}

			for (temp_count = 32+8; temp_count < (32+8+8); temp_count++)  //add
			{
				if((temp_count%4)==0)  //org
				{	
					//num_array[temp_count]=0;
					//unsigned int do_ddr_read_write_ddr_data_window_lcdlr(unsigned int rank_index,unsigned int data_add_index,unsigned int lcdlr_value,unsigned int read_write_flag ))
					num_array[temp_count]=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,((temp_count-8-32)>>2),num_array[temp_count],DDR_PARAMETER_READ);

				}
				if((temp_count%4)==1)  //min
				{	
					num_array[temp_count]=0;
				}
				if((temp_count%4)==2) //max
				{	
					num_array[temp_count]=acmdlr*3;
					if(temp_count==(32+8+4+2))
						num_array[temp_count]=0x3f;//bdlr0 max value
				}
				if((temp_count%4)==3) //status
				{	
					num_array[temp_count]=0;
				}


			}




#if  (CONFIG_DDR_PHY<=P_DDR_PHY_905X)
			printf("DDR0_PUB_DX0GCR0==%x\n",(readl(DDR0_PUB_DX0GCR0)));
			printf("DDR0_PUB_DX1GCR0==%x\n",(readl(DDR0_PUB_DX1GCR0)));
			printf("DDR0_PUB_DX2GCR0==%x\n",(readl(DDR0_PUB_DX2GCR0)));
			printf("DDR0_PUB_DX3GCR0==%x\n",(readl(DDR0_PUB_DX3GCR0)));
			if(((readl(DDR0_PUB_DX0GCR0))&1)==0)
				lane_disable=   lane_disable|1;      
			if(((readl(DDR0_PUB_DX1GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<1);   
			if(((readl(DDR0_PUB_DX2GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<2);   
			if(((readl(DDR0_PUB_DX3GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<3);   

#endif
			if(lane_disable)
			{if(lane_disable&0x1){
									 num_array[8+3]=0xffff;
									 num_array[8+4+3]=0xffff;
								 }
			if(lane_disable&0x2){
				num_array[8+3+8]=0xffff;
				num_array[8+4+3+8]=0xffff;
			}
			if(lane_disable&0x4){
				num_array[8+3+8+8]=0xffff;
				num_array[8+4+3+8+8]=0xffff;
			}
			if(lane_disable&0x8){
				num_array[8+3+8+8+8]=0xffff;
				num_array[8+4+3+8+8+8]=0xffff;
			}
			printf("lane_disable==%x\n",lane_disable);
			if(lane_disable&0x10){
				num_array[8+3+8+8+8+8]=0xffff;
			}
			if(lane_disable&0x20){
				num_array[8+4+3+8+8+8+8]=0xffff;

			}
			}


		}




		for (temp_count= 0; temp_count< 48;temp_count++) {
			num_array[temp_count]= read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
		}
	}

	test_arg_2_step++;
	num_array[2]=test_arg_2_step;
	for (temp_count = 1; temp_count < 48; temp_count++) 
	{
		printf("%d  %d\n", temp_count,num_array[temp_count]);
	}
	temp_count=2;
	num_array[temp_count]= read_write_window_test_parameter(data_source, 
			temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
	//for (i = 0; i < 48; i++) {

	//	 writel(num_array[i],(sticky_reg_base_add+(i<<2)));
	//}


	//for (i = 8; i < 48; i++) {
	//num_array[i]=readl((sticky_reg_base_add+(i<<2)));
	//printf("ddr_test_data_num_%04d==%d\n",i,num_array[i]);
	//}

	///*
	unsigned int lane_step=0;

	printf("\nstart loop test\n");

	for ((lane_step=0);(lane_step<10);(lane_step++))   //find need test data step
	{
		if((num_array[(lane_step<<2)+3+8]<0x4))
		{break;
		}
	}
	printf("\nstart  test lane_step =%d\n",lane_step);
	if(lane_step<10)
	{
		if(lane_step<8)
		{
			test_watchdog_time_s=watchdog_time_s;
			ddr_test_size=ddr_data_test_size;
			lcdlr_min=0;
			lcdlr_max=(num_array[(lane_step<<2)+2+8]);//do_ddr_read_acmdlr();
		}
		else
		{
			test_watchdog_time_s=address_test_watchdog_time_s;
			ddr_test_size=ddr_add_test_size;
			lcdlr_min=0;
			lcdlr_max=(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
		}

		if((num_array[8+(lane_step<<2)+3]==0))   //test left edge begin
		{
			num_array[8+(lane_step<<2)+3]=1;
			test_arg_6_lcdlr_temp_count=lcdlr_min;
			num_array[6]=test_arg_6_lcdlr_temp_count;

			temp_count=6;
			read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
			temp_count=8+(lane_step<<2)+3;
			read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
			ddr_test_watchdog_enable(test_watchdog_time_s); //s
			printf("\nenable %ds watchdog \n",test_watchdog_time_s);
			ddr_test_watchdog_clear();
			if(lane_step<8)
				test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
			else if(lane_step<10)
				test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

			//here will dead
			temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

			if (temp_test_error)
			{
				run_command("reset",0);
			}
			else
			{
				ddr_test_watchdog_clear();
				org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
				if(lane_step<8)
					org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
				else if(lane_step<10)
					org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);


				num_array[8+(lane_step<<2)+3]=2;  //left finish

				temp_count=8+(lane_step<<2)+3;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				temp_count=8+(lane_step<<2)+1;
				num_array[temp_count]=test_arg_6_lcdlr_temp_count;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				test_arg_6_lcdlr_temp_count=0;
				num_array[6]=test_arg_6_lcdlr_temp_count;

				temp_count=6;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
				run_command("reset",0);



			}
		}
		else if((num_array[8+(lane_step<<2)+3]==1))   //test left edge ongoing    -loop
		{
			num_array[8+(lane_step<<2)+3]=1;
			test_arg_6_lcdlr_temp_count++;
			num_array[6]=test_arg_6_lcdlr_temp_count;

			temp_count=6;
			read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
			temp_count=8+(lane_step<<2)+3;
			read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
			ddr_test_watchdog_enable(test_watchdog_time_s); //s
			printf("\nenable %ds watchdog \n",test_watchdog_time_s);
			ddr_test_watchdog_clear();
			if(lane_step<8)
				test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
			else if(lane_step<10)
				test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

			//here will dead
			temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

			if (temp_test_error)
			{
				run_command("reset",0);
			}
			else
			{
				ddr_test_watchdog_clear();
				org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
				if(lane_step<8)
					org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
				else if(lane_step<10)
					org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

				num_array[8+(lane_step<<2)+3]=2;  //left finish

				temp_count=8+(lane_step<<2)+3;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				temp_count=8+(lane_step<<2)+1;
				num_array[temp_count]=test_arg_6_lcdlr_temp_count;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				test_arg_6_lcdlr_temp_count=0;
				num_array[6]=test_arg_6_lcdlr_temp_count;

				temp_count=6;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
				run_command("reset",0);



			}
		}
		else if((num_array[8+(lane_step<<2)+3]==2))   //test right edge begin
		{
			num_array[8+(lane_step<<2)+3]=3;
			test_arg_6_lcdlr_temp_count=lcdlr_max;
			num_array[6]=test_arg_6_lcdlr_temp_count;

			temp_count=6;
			read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
			temp_count=8+(lane_step<<2)+3;
			read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
			ddr_test_watchdog_enable(test_watchdog_time_s); //s
			printf("\nenable %ds watchdog \n",test_watchdog_time_s);
			ddr_test_watchdog_clear();
			if(lane_step<8)
				test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
			else if(lane_step<10)
				test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

			//here will dead
			temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

			if (temp_test_error)
			{
				run_command("reset",0);
			}
			else
			{
				ddr_test_watchdog_clear();
				org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
				if(lane_step<8)
					org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
				else if(lane_step<10)
					org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

				num_array[8+(lane_step<<2)+3]=4;  //right finish

				temp_count=8+(lane_step<<2)+3;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				temp_count=8+(lane_step<<2)+2;
				num_array[temp_count]=test_arg_6_lcdlr_temp_count;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				test_arg_6_lcdlr_temp_count=0;
				num_array[6]=test_arg_6_lcdlr_temp_count;

				temp_count=6;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
				run_command("reset",0);



			}
		}
		else if((num_array[8+(lane_step<<2)+3]==3))   //test right edge ongoing    -loop
		{
			num_array[8+(lane_step<<2)+3]=3;
			test_arg_6_lcdlr_temp_count--;
			num_array[6]=test_arg_6_lcdlr_temp_count;

			temp_count=6;
			read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
			temp_count=8+(lane_step<<2)+3;
			read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
			ddr_test_watchdog_enable(test_watchdog_time_s); //s
			printf("\nenable %ds watchdog \n",test_watchdog_time_s);
			ddr_test_watchdog_clear();
			if(lane_step<8)
				test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
			else if(lane_step<10)
				test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

			//here will dead
			temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

			if (temp_test_error)
			{
				run_command("reset",0);
			}
			else
			{
				ddr_test_watchdog_clear();
				org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
				if(lane_step<8)
					org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
				else if(lane_step<10)
					org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

				num_array[8+(lane_step<<2)+3]=4;  //right finish

				temp_count=8+(lane_step<<2)+3;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				temp_count=8+(lane_step<<2)+2;
				num_array[temp_count]=test_arg_6_lcdlr_temp_count;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				test_arg_6_lcdlr_temp_count=0;
				num_array[6]=test_arg_6_lcdlr_temp_count;

				temp_count=6;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
				run_command("reset",0);



			}
		}
	}

	if(lane_step>=10) //finish
	{
		ddr_test_watchdog_disable(); //s
		printf("close  watchdog\n");
	}

	// unsigned int   acmdlr= 0;
	unsigned int  delay_step_x100= 0;

	{
		//acmdlr=do_ddr_read_acmdlr();
		delay_step_x100=100*1000000/(2*global_ddr_clk*acmdlr);
		printf("\nacmdlr=0x%08x-->dec %d,ddr clk==%d,step=%d ps,10step=%d ps,100step=%d ps,\n",acmdlr,acmdlr,global_ddr_clk,
				delay_step_x100/100,delay_step_x100/10,delay_step_x100);

		for ((lane_step=0);(lane_step<4);(lane_step++))
		{
			printf("\n a_lane_0x%08x|wdq_org 0x%08x  |wdq_min 0x%08x |wdq_max 0x%08x ::|rdqs_org  0x%08x  |rdqs_min 0x%08x |rdqs_max 0x%08x  \n",
					lane_step,
					num_array[8+(lane_step)*8+0],num_array[8+(lane_step)*8+1],num_array[8+(lane_step)*8+2],
					num_array[8+(lane_step)*8+4],num_array[8+(lane_step)*8+5],num_array[8+(lane_step)*8+6]);
		}
		lane_step=4;
		{
			printf("\nac_lane_0x%08x|lcd_org 0x%08x  |lcd_min 0x%08x |lcd_max 0x%08x ::|bdlr_org  0x%08x  |bdlr_min 0x%08x |bdlr_max 0x%08x  \n",
					4,
					num_array[8+(lane_step)*8+0],num_array[8+(lane_step)*8+1],num_array[8+(lane_step)*8+2],
					num_array[8+(lane_step)*8+4],num_array[8+(lane_step)*8+5],num_array[8+(lane_step)*8+6]);
		}
		printf("\n\n-----------------------------------------------------------------------------\n\n");
		{
			printf("\n ac_lane_0x0000000|  lcdlr_org  |lcdlr_set ps|lcdlr_hold ps:|\
					clk_setup  ps| clk_hold ps|adj_percent[100]\n");

			printf("\n ac_lane0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					4,
					num_array[8+(lane_step)*8+0],
					(((num_array[8+(lane_step)*8+2]-num_array[8+(lane_step)*8+0])*delay_step_x100
					 )/100),
					(((num_array[8+(lane_step)*8+0]-num_array[8+(lane_step)*8+1])*delay_step_x100
					 )/100),

					0,
					0,
					100*(num_array[8+(lane_step)*8+2]+num_array[8+(lane_step)*8+1])/(
						2*num_array[8+(lane_step)*8+0]));
			printf("\n ck_lane0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					4,
					num_array[8+(lane_step)*8+4],
					0,
					0,
					(((num_array[8+(lane_step)*8+4]-num_array[8+(lane_step)*8+5])*delay_step_x100
					 )/100),
					(((num_array[8+(lane_step)*8+6]-num_array[8+(lane_step)*8+4])*delay_step_x100
					 )/100),

					100*(num_array[8+(lane_step)*8+6]+num_array[8+(lane_step)*8+5])/(
						2*num_array[8+(lane_step)*8+4]));
		}
		printf("\n a_lane_0x00000000| wrdq_org 0x0|w_setup x ps|w_hold  x ps::|\
				rd_setup  ps|rd_hold x ps|adj_percent[100]\n");


		for ((lane_step=0);(lane_step<4);(lane_step++))
		{
			printf("\n a_lane_0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					lane_step,
					num_array[8+(lane_step)*8+0],
					(((num_array[8+(lane_step)*8+2]-num_array[8+(lane_step)*8+0])*delay_step_x100
					 )/100),
					(((num_array[8+(lane_step)*8+0]-num_array[8+(lane_step)*8+1])*delay_step_x100
					 )/100),

					0,
					0,
					100*(num_array[8+(lane_step)*8+2]+num_array[8+(lane_step)*8+1])/(
						2*num_array[8+(lane_step)*8+0]));

			printf("\n a_lane_0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					lane_step,
					num_array[8+(lane_step)*8+4],
					0,
					0,

					(((num_array[8+(lane_step)*8+4]-num_array[8+(lane_step)*8+5])*delay_step_x100
					 )/100),
					(((num_array[8+(lane_step)*8+6]-num_array[8+(lane_step)*8+4])*delay_step_x100
					 )/100),
					100*(num_array[8+(lane_step)*8+6]+num_array[8+(lane_step)*8+5])/(
						2*num_array[8+(lane_step)*8+4]));



		}
	}

	test_arg_2_step=0x10000;
	num_array[2]=test_arg_2_step;



	temp_count=2;
	read_write_window_test_parameter(data_source, 
			temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

	return 1;
}


int do_ddr_uboot_kernel_window_use_source_quick_method(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	//setenv storeboot "ddr_test_cmd 0x33 2 6  20 0 0x100000 0x4000000"
	printf("\nsetenv bootcmd ddr_test_cmd 0x33 2 6  20 0 0x100000 0x4000000 \n");
	printf("\nEnter do_ddr_uboot_window_use_source function\n");
	printf("\n--- watchdog should >15s\n");
#define DDR_TEST_NULL  0
#define DDR_TEST_PASS  1
#define DDR_TEST_FAIL 2

#define  DDR_TEST_STATUS_STEP_FLAG_ADD_ORG_STICKY_OFFSET   4  // PREG_STICKY_REG4
#define  DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET    5  //45// PREG_STICKY_REG4
	//PREG_STICKY_REG5


#define DDR_TEST_STATUS_UBOOT_ONGOING   1
#define DDR_TEST_STATUS_UBOOT_FINISH 2
#define DDR_TEST_STATUS_KERNEL_ONGING  3
#define DDR_TEST_STATUS_KERNEL_FINISH 4

#define DDR_TEST_METHOD_DIVIDER_2   1   //AB METHOD  A is failing B is passing value
#define DDR_TEST_METHOD_DECREASE   2

	char *endp;
	unsigned int   lane_disable= 0;
	unsigned int   data_source= 0;
	unsigned int  ddr_data_test_method=DDR_TEST_METHOD_DIVIDER_2;
	unsigned int  ddr_add_test_method=DDR_TEST_METHOD_DIVIDER_2;
	unsigned int  ddr_test_method=DDR_TEST_METHOD_DIVIDER_2;

	unsigned int  ddr_data_test_size=0x1000000;
	unsigned int  ddr_add_test_size=0x10000000;
	unsigned int  ddr_test_size=0x10000000;

	unsigned int  address_test_watchdog_time_s=15;
	unsigned int  test_watchdog_time_s=15;

	error_outof_count_flag =1;  //for quick out of error
	if (argc >1) {
		data_source = simple_strtoull_ddr(argv[1], &endp, 0);
		if (*argv[1] == 0 || *endp != 0)
		{
			data_source= DDR_PARAMETER_SOURCE_FROM_UBOOT_ENV;
		}
	}
	if (argc >2) {
		watchdog_time_s = simple_strtoull_ddr(argv[2], &endp, 0);
		if (*argv[2] == 0 || *endp != 0)
		{
			watchdog_time_s= 15;
		}
	}
	printf("watchdog_time_s==%d\n",watchdog_time_s);
	test_watchdog_time_s=watchdog_time_s;
	//test_watchdog_time_s=address_test_watchdog_time_s;
	if (argc >3) {
		address_test_watchdog_time_s = simple_strtoull_ddr(argv[3], &endp, 0);
		if (*argv[3] == 0 || *endp != 0)
		{
			address_test_watchdog_time_s= watchdog_time_s;
		}
	}
	printf("address_test_watchdog_time_s==%d\n",address_test_watchdog_time_s);
	//lane_disable=g_ddr_test_struct->ddr_test_lane_disable;
	if (argc >4) {
		lane_disable = simple_strtoull_ddr(argv[4], &endp, 0);
		if (*argv[4] == 0 || *endp != 0)
		{
			lane_disable= 0;
		}
	}
	printf("lane_disable==0x%08x\n",lane_disable);   

	if (argc >5) {
		ddr_data_test_size = simple_strtoull_ddr(argv[5], &endp, 0);
		if (*argv[5] == 0 || *endp != 0)
		{
			ddr_data_test_size= 0x100000;
		}
	}
	printf("ddr_data_test_size==0x%08x\n",ddr_data_test_size);
	if (argc >6) {
		ddr_add_test_size = simple_strtoull_ddr(argv[6], &endp, 0);
		if (*argv[6] == 0 || *endp != 0)
		{
			ddr_add_test_size= 0x10000000;
		}
	}
	printf("ddr_add_test_size==0x%08x\n",ddr_add_test_size);
	if (argc >7) {
		ddr_data_test_method = simple_strtoull_ddr(argv[7], &endp, 0);
		if (*argv[7] == 0 || *endp != 0)
		{
			ddr_data_test_method= DDR_TEST_METHOD_DIVIDER_2;
		}
	}
	printf("ddr_data_test_method==0x%08x\n",ddr_data_test_method);
	if (argc >8) {
		ddr_add_test_method = simple_strtoull_ddr(argv[8], &endp, 0);
		if (*argv[8] == 0 || *endp != 0)
		{
			ddr_add_test_method= DDR_TEST_METHOD_DIVIDER_2;
		}
	}
	printf("ddr_add_test_method==0x%08x\n",ddr_add_test_method);

	unsigned int rank_index=0;
	unsigned int temp_count=0;
	unsigned int ddr_test_data_array_max=100;
	unsigned int num_array[100];//8 flag 32_data add_8  32_data add_8

	unsigned int temp_test_error=0;
	unsigned int lcdlr_min=0;
	unsigned int lcdlr_max=0;
	memset(num_array, 0, sizeof(num_array));
	char str[1024]="";

	if(data_source==DDR_PARAMETER_SOURCE_FROM_DMC_STICKY)
		ddr_test_data_array_max=64;
	for (temp_count= 0;temp_count < ddr_test_data_array_max; temp_count++) 
	{
		num_array[temp_count]= read_write_window_test_parameter(data_source, 
				temp_count ,num_array[temp_count],DDR_PARAMETER_READ );
		printf("read numarry[%d]==%d\n",temp_count,num_array[temp_count]);
	}

	unsigned int test_arg_0_ab_best_lcdlr_value =0;  //best_lcdlr_value
	unsigned int test_arg_1_test_error_flag =0;  //min cmd
	unsigned int test_arg_2_step =0; //step 0  init  -1  UBOOT ONGOING  2 UBOOT FINISH  3 KERNEL ONGOING 4 KERNEL FINISH
	unsigned int test_arg_3_freq =0;
	unsigned int test_arg_4_step_status =0; //uboot test we should read error then done status.  0 no test 1 ongoing 2 this step done  fail or pass
	unsigned int test_arg_5_ab_edge_lcdlr_value =0;
	unsigned int test_arg_6_lcdlr_temp_count =0;
	unsigned int test_arg_7_magic_number =0;
	unsigned int org_lcdlr_value_temp=0;
	unsigned int acmdlr=0;
	acmdlr=do_ddr_read_acmdlr();

	test_arg_0_ab_best_lcdlr_value=num_array[0];
	test_arg_1_test_error_flag=num_array[1];
	test_arg_2_step=num_array[2];
	test_arg_3_freq=num_array[3];
	test_arg_4_step_status=num_array[4];
	test_arg_5_ab_edge_lcdlr_value=num_array[5];
	test_arg_6_lcdlr_temp_count=num_array[6];
	test_arg_7_magic_number=num_array[7];
	printf("test_arg_0_ab_best_lcdlr_value==%d\n",test_arg_0_ab_best_lcdlr_value);
	printf("test_arg_1_test_error_flag==%d\n",test_arg_1_test_error_flag);
	printf("test_arg_2_step==%d\n",test_arg_2_step);
	printf("test_arg_3_freq==%d\n",test_arg_3_freq);
	printf("test_arg_4_step_status==%d\n",test_arg_4_step_status);
	printf("test_arg_5_ab_edge_lcdlr_value=%d\n",num_array[5]);
	printf("test_arg_6_lcdlr_temp_count=%d\n",num_array[6]);
	printf("test_arg_7_magic_number=%d\n",num_array[7]);



	if((test_arg_7_magic_number==DMC_STICKY_MAGIC_1)) //for check magic number make sume enter test command
	{
	}
	else
	{

		test_arg_0_ab_best_lcdlr_value=0;
		test_arg_5_ab_edge_lcdlr_value=0;
		test_arg_2_step=0;
		test_arg_6_lcdlr_temp_count=0;
		test_arg_7_magic_number=DMC_STICKY_MAGIC_1;
	}
	//printf("boot times==%d\n",test_arg_5_ab_edge_lcdlr_value);
	num_array[0]	=	test_arg_0_ab_best_lcdlr_value		;
	num_array[1]	=	test_arg_1_test_error_flag		;
	num_array[2]	=	test_arg_2_step		;
	num_array[3]	=	test_arg_3_freq		;
	num_array[4]	=	test_arg_4_step_status		;
	num_array[5]	=	test_arg_5_ab_edge_lcdlr_value		;
	num_array[6]	=	test_arg_6_lcdlr_temp_count		;
	num_array[7]	=	test_arg_7_magic_number		;

	for (temp_count= 0;temp_count < 8; temp_count++) 
	{
		read_write_window_test_parameter(data_source, 
				temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
	}



	if(test_arg_2_step)
	{
		if(test_arg_3_freq!=global_ddr_clk)  //
		{
			printf("running ddr freq==%d,but test freq is%d,will reboot use d2pll \n",global_ddr_clk,test_arg_3_freq);
			sprintf(str,"d2pll  %d",test_arg_3_freq);
			printf("\nstr=%s\n",str);
			run_command(str,0);
			while(1);
		}
	}
	if(test_arg_2_step==0)
	{
		{



			test_arg_0_ab_best_lcdlr_value=0;
			test_arg_1_test_error_flag=0;
			test_arg_2_step=DDR_TEST_STATUS_UBOOT_ONGOING;
			test_arg_3_freq=global_ddr_clk;
			test_arg_4_step_status=0;
			test_arg_5_ab_edge_lcdlr_value=0;
			test_arg_6_lcdlr_temp_count=lcdlr_min;
			test_arg_7_magic_number=DMC_STICKY_MAGIC_1;
			num_array[0]	=	test_arg_0_ab_best_lcdlr_value		;
			num_array[1]	=	test_arg_1_test_error_flag		;
			num_array[2]	=	test_arg_2_step		;
			num_array[3]	=	test_arg_3_freq		;
			num_array[4]	=	test_arg_4_step_status		;
			num_array[5]	=	test_arg_5_ab_edge_lcdlr_value		;
			num_array[6]	=	test_arg_6_lcdlr_temp_count		;
			num_array[7]	=	test_arg_7_magic_number		;


			for (temp_count= 0;temp_count < 8; temp_count++) 
			{
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
			}

			// read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
			// 	 DDR_TEST_STATUS_STEP_FLAG_ADD_ORG_STICKY_OFFSET ,test_arg_2_step,DDR_PARAMETER_WRITE);
			//for (temp_count = 8; temp_count< 48;temp_count++) {
			//		num_array[temp_count]=0;
			//}

			for (temp_count = 8; temp_count < (32+8); temp_count++)   //data
			{
				//printf("1temp_count=%d\n",temp_count);

				if((temp_count%4)==0)  //org
				{
					if(((temp_count-8)/4)<8)  
					{
						lcdlr_min=0;
						lcdlr_max=(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//if(lane_step==9)
						//lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
					}
					else if(((temp_count-8)/4)<10)  
					{
						lcdlr_min=0;
						lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						if(((temp_count-8)/4)==9)
							lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
					}
					//printf("2temp_count=%d\n",temp_count);
					//num_array[temp_count]=0;
					//unsigned int do_ddr_read_write_ddr_data_window_lcdlr(unsigned int rank_index,unsigned int data_add_index,unsigned int lcdlr_value,unsigned int read_write_flag ))
					num_array[temp_count]=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,((temp_count-8)>>2),num_array[temp_count],DDR_PARAMETER_READ);
					num_array[temp_count+1]=lcdlr_min;
					num_array[temp_count+2]=lcdlr_max;//num_array[temp_count];
					num_array[temp_count+3]=0;
					//temp_count=temp_count+4;
				}



			}

			for (temp_count = 32+8; temp_count < (32+8+8); temp_count++)  //add
			{
				if((temp_count%4)==0)  //org
				{	
					if(((temp_count-8)/4)<8)  
					{
						lcdlr_min=0;
						lcdlr_max=(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//if(lane_step==9)
						//lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
					}
					else if(((temp_count-8)/4)<10)  
					{
						lcdlr_min=0;
						lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						if(((temp_count-8)/4)==9)
							lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
					}
					//num_array[temp_count]=0;
					//unsigned int do_ddr_read_write_ddr_data_window_lcdlr(unsigned int rank_index,unsigned int data_add_index,unsigned int lcdlr_value,unsigned int read_write_flag ))
					num_array[temp_count]=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,((temp_count-8-32)>>2),num_array[temp_count],DDR_PARAMETER_READ);
					num_array[temp_count+1]=lcdlr_min;
					num_array[temp_count+2]=lcdlr_max;//num_array[temp_count];
					num_array[temp_count+3]=0;
				}


			}




#if  (CONFIG_DDR_PHY<=P_DDR_PHY_905X)
			printf("DDR0_PUB_DX0GCR0==%x\n",(readl(DDR0_PUB_DX0GCR0)));
			printf("DDR0_PUB_DX1GCR0==%x\n",(readl(DDR0_PUB_DX1GCR0)));
			printf("DDR0_PUB_DX2GCR0==%x\n",(readl(DDR0_PUB_DX2GCR0)));
			printf("DDR0_PUB_DX3GCR0==%x\n",(readl(DDR0_PUB_DX3GCR0)));
			if(((readl(DDR0_PUB_DX0GCR0))&1)==0)
				lane_disable=   lane_disable|1;      
			if(((readl(DDR0_PUB_DX1GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<1);   
			if(((readl(DDR0_PUB_DX2GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<2);   
			if(((readl(DDR0_PUB_DX3GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<3);   

#endif
			if(lane_disable)
			{if(lane_disable&0x1){
									 num_array[8+3]=0xffff;
									 num_array[8+4+3]=0xffff;
								 }
			if(lane_disable&0x2){
				num_array[8+3+8]=0xffff;
				num_array[8+4+3+8]=0xffff;
			}
			if(lane_disable&0x4){
				num_array[8+3+8+8]=0xffff;
				num_array[8+4+3+8+8]=0xffff;
			}
			if(lane_disable&0x8){
				num_array[8+3+8+8+8]=0xffff;
				num_array[8+4+3+8+8+8]=0xffff;
			}
			printf("lane_disable==%x\n",lane_disable);
			if(lane_disable&0x10){
				num_array[8+3+8+8+8+8]=0xffff;
			}
			if(lane_disable&0x20){
				num_array[8+4+3+8+8+8+8]=0xffff;

			}
			}


		}




		for (temp_count= 0; temp_count< 48;temp_count++) {
			num_array[temp_count]= read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
		}
	}

	//test_arg_2_step++;
	num_array[2]=test_arg_2_step;
	for (temp_count = 1; temp_count < 48; temp_count++) 
	{
		printf("%d  %d\n", temp_count,num_array[temp_count]);
	}
	temp_count=2;
	num_array[temp_count]= read_write_window_test_parameter(data_source, 
			temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
	//	 read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
	// 	 DDR_TEST_STATUS_STEP_FLAG_ADD_ORG_STICKY_OFFSET ,test_arg_2_step,DDR_PARAMETER_WRITE);
	//for (i = 0; i < 48; i++) {

	//	 writel(num_array[i],(sticky_reg_base_add+(i<<2)));
	//}


	//for (i = 8; i < 48; i++) {
	//num_array[i]=readl((sticky_reg_base_add+(i<<2)));
	//printf("ddr_test_data_num_%04d==%d\n",i,num_array[i]);
	//}

	///*
	unsigned int lane_step=0;

	printf("\nstart loop test\n");

	for ((lane_step=0);(lane_step<10);(lane_step++))   //find need test data step
	{
		if(test_arg_2_step<DDR_TEST_STATUS_KERNEL_ONGING)
		{
			if((num_array[(lane_step<<2)+3+8]<(0x4)))
			{break;
			}
		}
	}

	if(test_arg_2_step==DDR_TEST_STATUS_UBOOT_ONGOING)
	{if(lane_step>9)
		{
			test_arg_2_step=DDR_TEST_STATUS_UBOOT_FINISH;
			printf("uboot test result: \n");
		}
	}

	if(test_arg_2_step>DDR_TEST_STATUS_UBOOT_FINISH)
	{
		for ((lane_step=0);(lane_step<10);(lane_step++))   //find need test data step
		{

			{
				if((num_array[(lane_step<<2)+3+8]<(0x4+4)))
				{break;
				}
			}
		}
	}

	if(test_arg_2_step==DDR_TEST_STATUS_UBOOT_FINISH)//||(test_arg_2_step==DDR_TEST_STATUS_KERNEL_FINISH)
	{
		//test_arg_2_step=DDR_TEST_STATUS_KERNEL_ONGING;
	}
	else
	{
		printf("\nstart  test lane_step =%d\n",lane_step);
		if(lane_step<10)
		{
			if(lane_step<8)
			{
				test_watchdog_time_s=watchdog_time_s;
				ddr_test_size=ddr_data_test_size;
				ddr_test_method=ddr_data_test_method;
				//lcdlr_min=0;
				//lcdlr_max=(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);//do_ddr_read_acmdlr();
			}
			else
			{
				test_watchdog_time_s=address_test_watchdog_time_s;
				ddr_test_size=ddr_add_test_size;
				ddr_test_method=ddr_add_test_method;
				//lcdlr_min=0;
				//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
				//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
				//if(lane_step==9)
				//lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
			}

			if(num_array[8+(lane_step<<2)+3]>4)  //from kernel 
			{
				num_array[1]= read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
						DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_READ);
				// read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
				// DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
			}

			if(((num_array[8+(lane_step<<2)+3]==0))||((num_array[8+(lane_step<<2)+3]==4)))   //test left edge begin
			{
				/*
				   num_array[1]	=	test_arg_1_test_error_flag		;//1 pass 2 error
				   num_array[2]	=	test_arg_2_step		;
				   num_array[3]	=	test_arg_3_freq		;
				   num_array[4]	=	test_arg_4_step_status		;
				   num_array[5]	=	test_arg_5_ab_edge_lcdlr_value		;
				   num_array[6]	=	test_arg_6_lcdlr_temp_count		;
				   num_array[7]	=	test_arg_7_magic_number		;
				   */
				//         test_arg_0_ab_best_lcdlr_value=(num_array[8+(lane_step<<2)+0]);
				//	 num_array[0]=test_arg_0_ab_best_lcdlr_value;
				//	 temp_count=0;
				//	 read_write_window_test_parameter(data_source, 
				// 	 temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				num_array[1]=DDR_TEST_NULL;  //1 //pass 2 error
				num_array[1]=DDR_TEST_FAIL;  //1 //pass 2 error
				temp_count=1;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				if(num_array[8+(lane_step<<2)+3]>4)
				{
					read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
							DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
				}

				read_write_window_test_flag(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				num_array[5]=(num_array[8+(lane_step<<2)+1]);  //edge lcdlr
				temp_count=5;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				(num_array[8+(lane_step<<2)+1])=(num_array[8+(lane_step<<2)+0]);  
				temp_count=8+(lane_step<<2)+1;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				if(ddr_test_method==DDR_TEST_METHOD_DIVIDER_2)
					test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+0])>>1);
				else if(ddr_test_method==DDR_TEST_METHOD_DECREASE)
					test_arg_6_lcdlr_temp_count=((num_array[5])+1);

				num_array[6]=test_arg_6_lcdlr_temp_count;                       //temp_lcdlr
				temp_count=6;
				read_write_window_test_parameter(data_source,  //temp_lcdlr
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				num_array[8+(lane_step<<2)+3]=(num_array[8+(lane_step<<2)+3]+1);
				temp_count=8+(lane_step<<2)+3;
				read_write_window_test_parameter(data_source, //lane status
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);


				{
					ddr_test_watchdog_enable(test_watchdog_time_s); //s
					printf("\nenable %ds watchdog \n",test_watchdog_time_s);
					ddr_test_watchdog_clear();
				}
				if(lane_step<8)
					test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
				else if(lane_step<10)
					test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

				//here will dead

				{
					temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
				}
				//if( num_array[8+(lane_step<<2)+3]>4)


				if (temp_test_error)
				{
					run_command("reset",0);
					while(1);
				}
				else
				{
					if( num_array[8+(lane_step<<2)+3]>4)
					{
						ddr_test_watchdog_disable(); //s
						run_command("run storeboot",0);
						while(1);
					}
					else
					{
						ddr_test_watchdog_clear();
						org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
						if(lane_step<8)
							org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
						else if(lane_step<10)
							org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

						num_array[1]=DDR_TEST_PASS;  //pass 2 error 1
						temp_count=1;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
						if(num_array[8+(lane_step<<2)+3]>4)
						{
							read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
									DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
						}

						run_command("reset",0);
						while(1);
					}
				}
			}
			else if((num_array[8+(lane_step<<2)+3]==1)||((num_array[8+(lane_step<<2)+3]==5)))   //test left edge begin)   //test left edge ongoing    -loop
			{

				if((num_array[6]+1)>=(num_array[8+(lane_step<<2)+1]))
				{
					if(num_array[1]==DDR_TEST_NULL)
					{printf("default value not stable ,or recovery sticky?\n");
					}


					num_array[8+(lane_step<<2)+3]= num_array[8+(lane_step<<2)+3]+1;  //update status
					temp_count=8+(lane_step<<2)+3;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

					num_array[5]=0;  //update edge lcdlr
					temp_count=5;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

					if(num_array[1]==DDR_TEST_FAIL)
						num_array[8+(lane_step<<2)+1]=num_array[6]+1;   //update B
					if(num_array[1]==DDR_TEST_PASS)
						num_array[8+(lane_step<<2)+1]=num_array[6];   //update B
					temp_count=8+(lane_step<<2)+1;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

					test_arg_6_lcdlr_temp_count=0;  //curren_test +B  //(A+B)/2
					num_array[6]=test_arg_6_lcdlr_temp_count;                                          //--update curent
					temp_count=6;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
					num_array[1]=DDR_TEST_NULL;  //1 //pass 2 error
					temp_count=1;                                                                    //update test error flag
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

					if(num_array[8+(lane_step<<2)+3]>4)
					{
						//	num_array[1]= read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
						// DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_READ);
						read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
								DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
					}

					//  test_arg_0_ab_best_lcdlr_value=0;//(num_array[8+(lane_step<<2)+0]);
					// num_array[0]=test_arg_0_ab_best_lcdlr_value;
					// temp_count=0;
					// read_write_window_test_parameter(data_source, 
					// temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
					run_command("reset",0); 
					while(1);

				}
				else 
				{ 
					if(num_array[1]==DDR_TEST_NULL)
					{printf("default value not stable ,or recovery sticky?\n");
					}
					else  if(num_array[1]==DDR_TEST_FAIL)
					{



						{
							//   num_array[8+(lane_step<<2)+3]=1;  //update status
							temp_count=8+(lane_step<<2)+3;
							read_write_window_test_parameter(data_source, 
									temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);


							num_array[5]=num_array[6];  //update edge lcdlr
							temp_count=5;
							read_write_window_test_parameter(data_source, 
									temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

							if(ddr_test_method==DDR_TEST_METHOD_DIVIDER_2)
								test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+1])>>1);
							else if(ddr_test_method==DDR_TEST_METHOD_DECREASE)
								test_arg_6_lcdlr_temp_count=((num_array[5])+1);
							//   test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+1])>>1);  //curren_test +B  //(A+B)/2
							num_array[6]=test_arg_6_lcdlr_temp_count;                                          //--update curent
							temp_count=6;
							read_write_window_test_parameter(data_source, 
									temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

							// num_array[8+(lane_step<<2)+1]=num_array[8+(lane_step<<2)+1];   //update B
							// temp_count=8+(lane_step<<2)+1;
							// read_write_window_test_parameter(data_source, 
							// temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
							num_array[1]=DDR_TEST_FAIL;  //1 //pass 2 error
							temp_count=1;                                                                    //update test error flag
							read_write_window_test_parameter(data_source, 
									temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

							if(num_array[8+(lane_step<<2)+3]>4)
							{
								read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
										DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
							}


							ddr_test_watchdog_enable(test_watchdog_time_s); //s
							printf("\nenable %ds watchdog \n",test_watchdog_time_s);
							ddr_test_watchdog_clear();
							if(lane_step<8)
								test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
							else if(lane_step<10)
								test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

							//here will dead
							temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

							if (temp_test_error)
							{
								run_command("reset",0);
								while(1);
							}
							else
							{
								if( num_array[8+(lane_step<<2)+3]>4)
								{
									ddr_test_watchdog_disable(); //s
									run_command("run storeboot",0);
									while(1);
								}
								else
								{

									ddr_test_watchdog_clear();
									org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
									if(lane_step<8)
										org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
									else if(lane_step<10)
										org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

									num_array[1]=DDR_TEST_PASS;  //pass 2 error 1
									temp_count=1;
									read_write_window_test_parameter(data_source, 
											temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

									if(num_array[8+(lane_step<<2)+3]>4)
									{
										read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
												DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
									}


									run_command("reset",0);
									while(1);
								}

							}
						}
					}

					else	  if(num_array[1]==DDR_TEST_PASS)
					{
						// num_array[8+(lane_step<<2)+3]=1;  //update status
						temp_count=8+(lane_step<<2)+3;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

						num_array[8+(lane_step<<2)+1]=num_array[6];  //update min value
						temp_count=8+(lane_step<<2)+1;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

						if(ddr_test_method==DDR_TEST_METHOD_DIVIDER_2)
							test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+1])>>1);
						else if(ddr_test_method==DDR_TEST_METHOD_DECREASE)
							test_arg_6_lcdlr_temp_count=((num_array[5])+1);
						//   test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+1])>>1);  //curren_test +B  //(A+B)/2
						num_array[6]=test_arg_6_lcdlr_temp_count;                                          // --update curent
						temp_count=6;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

						num_array[1]=DDR_TEST_FAIL;  //1 //pass 2 error
						temp_count=1;                                                                    //update test error flag
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

						if(num_array[8+(lane_step<<2)+3]>4)
						{
							read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
									DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
						}


						ddr_test_watchdog_enable(test_watchdog_time_s); //s
						printf("\nenable %ds watchdog \n",test_watchdog_time_s);
						ddr_test_watchdog_clear();
						if(lane_step<8)
							test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
						else if(lane_step<10)
							test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

						//here will dead
						temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

						if (temp_test_error)
						{
							run_command("reset",0);
							while(1);
						}
						else
						{
							if( num_array[8+(lane_step<<2)+3]>4)
							{
								ddr_test_watchdog_disable(); //s
								run_command("run storeboot",0);
								while(1);
							}
							else
							{
								ddr_test_watchdog_clear();
								org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
								if(lane_step<8)
									org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
								else if(lane_step<10)
									org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

								num_array[1]=DDR_TEST_PASS;  //pass 2 error 1
								temp_count=1;
								read_write_window_test_parameter(data_source, 
										temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

								if(num_array[8+(lane_step<<2)+3]>4)
								{
									read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
											DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
								}

								run_command("reset",0);
								while(1);
							}
						}

					}
				}


			}

			else  if((num_array[8+(lane_step<<2)+3]==2)||((num_array[8+(lane_step<<2)+3]==6)))   //test right edge begin
			{
				/*
				   num_array[1]	=	test_arg_1_test_error_flag		;//1 pass 2 error
				   num_array[2]	=	test_arg_2_step		;
				   num_array[3]	=	test_arg_3_freq		;
				   num_array[4]	=	test_arg_4_step_status		;
				   num_array[5]	=	test_arg_5_ab_edge_lcdlr_value		;
				   num_array[6]	=	test_arg_6_lcdlr_temp_count		;
				   num_array[7]	=	test_arg_7_magic_number		;
				   */
				num_array[1]=DDR_TEST_NULL;  //1 //pass 2 error
				num_array[1]=DDR_TEST_FAIL;  //1 //pass 2 error
				temp_count=1;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				if(num_array[8+(lane_step<<2)+3]>4)
				{
					read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
							DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
				}


				num_array[5]=num_array[8+(lane_step<<2)+2];//lcdlr_max;  //edge lcdlr
				temp_count=5;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				num_array[8+(lane_step<<2)+2]=num_array[8+(lane_step<<2)+0];//
				temp_count=8+(lane_step<<2)+2;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				if(ddr_test_method==DDR_TEST_METHOD_DIVIDER_2)
					test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+2])>>1);
				else if(ddr_test_method==DDR_TEST_METHOD_DECREASE)
					test_arg_6_lcdlr_temp_count=((num_array[5])-1);
				//test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+2])>>1);
				num_array[6]=test_arg_6_lcdlr_temp_count;                       //temp_lcdlr
				temp_count=6;
				read_write_window_test_parameter(data_source,  //temp_lcdlr
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				num_array[8+(lane_step<<2)+3]=num_array[8+(lane_step<<2)+3]+1;
				temp_count=8+(lane_step<<2)+3;
				read_write_window_test_parameter(data_source, //lane status
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
				ddr_test_watchdog_enable(test_watchdog_time_s); //s
				printf("\nenable %ds watchdog \n",test_watchdog_time_s);
				ddr_test_watchdog_clear();
				if(lane_step<8)
					test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
				else if(lane_step<10)
					test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

				//here will dead
				temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

				if (temp_test_error)
				{
					run_command("reset",0);
					while(1);
				}
				else
				{

					if( num_array[8+(lane_step<<2)+3]>4)
					{
						ddr_test_watchdog_disable(); //s
						run_command("run storeboot",0);
						while(1);
					}
					else
					{

						ddr_test_watchdog_clear();
						org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
						if(lane_step<8)
							org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
						else if(lane_step<10)
							org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

						num_array[1]=DDR_TEST_PASS;  //pass 2 error 1
						temp_count=1;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
						if(num_array[8+(lane_step<<2)+3]>4)
						{
							read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
									DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
						}

						run_command("reset",0);
						while(1);
					}

				}
			}
			else if((num_array[8+(lane_step<<2)+3]==3)||(num_array[8+(lane_step<<2)+3]==7))   //test right edge ongoing    -loop
			{

				if((num_array[8+(lane_step<<2)+2]+1)>=(num_array[6]))
				{
					if(num_array[1]==DDR_TEST_NULL)
					{printf("default value not stable ,or recovery sticky?\n");
					}
					num_array[8+(lane_step<<2)+3]= num_array[8+(lane_step<<2)+3]+1;  //update status
					temp_count=8+(lane_step<<2)+3;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

					num_array[5]=0;  //update edge lcdlr
					temp_count=5;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
					if(num_array[1]==DDR_TEST_FAIL)
						num_array[8+(lane_step<<2)+2]=num_array[6]-1;   //update B
					if(num_array[1]==DDR_TEST_PASS)
						num_array[8+(lane_step<<2)+2]=num_array[6];   //update B
					temp_count=8+(lane_step<<2)+2;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

					test_arg_6_lcdlr_temp_count=0;  //curren_test +B  //(A+B)/2
					num_array[6]=test_arg_6_lcdlr_temp_count;                                          //--update curent
					temp_count=6;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
					num_array[1]=DDR_TEST_NULL;  //1 //pass 2 error
					temp_count=1;                                                                    //update test error flag
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
					if(num_array[8+(lane_step<<2)+3]>4)
					{
						read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
								DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
					}


					run_command("reset",0); 
					while(1);
				}
				else 
				{ 
					if(num_array[1]==DDR_TEST_NULL)
					{printf("default value not stable ,or recovery sticky?\n");
					}
					else  if(num_array[1]==DDR_TEST_FAIL)
					{



						{
							// num_array[8+(lane_step<<2)+3]=3;  //update status
							temp_count=8+(lane_step<<2)+3;
							read_write_window_test_parameter(data_source, 
									temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);


							num_array[5]=num_array[6];  //update edge lcdlr
							temp_count=5;
							read_write_window_test_parameter(data_source, 
									temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

							if(ddr_test_method==DDR_TEST_METHOD_DIVIDER_2)
								test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+2])>>1);
							else if(ddr_test_method==DDR_TEST_METHOD_DECREASE)
								test_arg_6_lcdlr_temp_count=((num_array[5])-1);
							//  test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+2])>>1);  //curren_test +B  //(A+B)/2
							num_array[6]=test_arg_6_lcdlr_temp_count;                                          //--update curent
							temp_count=6;
							read_write_window_test_parameter(data_source, 
									temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

							// num_array[8+(lane_step<<2)+1]=num_array[8+(lane_step<<2)+1];   //update B
							// temp_count=8+(lane_step<<2)+1;
							// read_write_window_test_parameter(data_source, 
							// temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
							num_array[1]=DDR_TEST_FAIL;  //1 //pass 2 error
							temp_count=1;                                                                    //update test error flag
							read_write_window_test_parameter(data_source, 
									temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

							if(num_array[8+(lane_step<<2)+3]>4)
							{
								read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
										DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
							}


							ddr_test_watchdog_enable(test_watchdog_time_s); //s
							printf("\nenable %ds watchdog \n",test_watchdog_time_s);
							ddr_test_watchdog_clear();
							if(lane_step<8)
								test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
							else if(lane_step<10)
								test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

							//here will dead
							temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

							if (temp_test_error)
							{
								run_command("reset",0);
								while(1);
							}
							else
							{
								if( num_array[8+(lane_step<<2)+3]>4)
								{
									ddr_test_watchdog_disable(); //s
									run_command("run storeboot",0);
									while(1);
								}
								else
								{

									ddr_test_watchdog_clear();
									org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
									if(lane_step<8)
										org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
									else if(lane_step<10)
										org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

									num_array[1]=DDR_TEST_PASS;  //pass 2 error 1
									temp_count=1;
									read_write_window_test_parameter(data_source, 
											temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

									if(num_array[8+(lane_step<<2)+3]>4)
									{
										read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
												DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
									}

									run_command("reset",0);
									while(1);
								}

							}
						}
					}

					else	  if(num_array[1]==DDR_TEST_PASS)
					{
						// num_array[8+(lane_step<<2)+3]=3;  //update status
						temp_count=8+(lane_step<<2)+3;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

						num_array[8+(lane_step<<2)+2]=num_array[6];  //update max value
						temp_count=8+(lane_step<<2)+2;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

						if(ddr_test_method==DDR_TEST_METHOD_DIVIDER_2)
							test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+2])>>1);
						else if(ddr_test_method==DDR_TEST_METHOD_DECREASE)
							test_arg_6_lcdlr_temp_count=((num_array[5])-1);
						//    test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+2])>>1);  //curren_test +B  //(A+B)/2
						num_array[6]=test_arg_6_lcdlr_temp_count;                                          // --update curent
						temp_count=6;
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

						num_array[1]=DDR_TEST_FAIL;  //1 //pass 2 error
						temp_count=1;                                                                    //update test error flag
						read_write_window_test_parameter(data_source, 
								temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
						if(num_array[8+(lane_step<<2)+3]>4)
						{
							read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
									DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
						}


						ddr_test_watchdog_enable(test_watchdog_time_s); //s
						printf("\nenable %ds watchdog \n",test_watchdog_time_s);
						ddr_test_watchdog_clear();
						if(lane_step<8)
							test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
						else if(lane_step<10)
							test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);

						//here will dead
						temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);

						if (temp_test_error)
						{
							run_command("reset",0);
							while(1);
						}
						else
						{
							if( num_array[8+(lane_step<<2)+3]>4)
							{
								ddr_test_watchdog_disable(); //s
								run_command("run storeboot",0);
								while(1);
							}
							else
							{
								ddr_test_watchdog_clear();
								org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];
								if(lane_step<8)
									org_lcdlr_value_temp=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);
								else if(lane_step<10)
									org_lcdlr_value_temp=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,org_lcdlr_value_temp,DDR_PARAMETER_WRITE);

								num_array[1]=DDR_TEST_PASS;  //pass 2 error 1
								temp_count=1;
								read_write_window_test_parameter(data_source, 
										temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
								if(num_array[8+(lane_step<<2)+3]>4)
								{
									read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
											DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
								}

								run_command("reset",0);
								while(1);
							}

						}

					}
				}


			}
		}
	}
	if(lane_step>=10) //finish
	{
		ddr_test_watchdog_disable(); //s
		printf("close  watchdog\n");
	}

	// unsigned int   acmdlr= 0;
	unsigned int  delay_step_x100= 0;

	{
		//acmdlr=do_ddr_read_acmdlr();
		delay_step_x100=100*1000000/(2*global_ddr_clk*acmdlr);
		printf("\nacmdlr=0x%08x-->dec %d,ddr clk==%d,step=%d ps,10step=%d ps,100step=%d ps,\n",acmdlr,acmdlr,global_ddr_clk,
				delay_step_x100/100,delay_step_x100/10,delay_step_x100);

		for ((lane_step=0);(lane_step<4);(lane_step++))
		{
			printf("\n a_lane_0x%08x|wdq_org 0x%08x  |wdq_min 0x%08x |wdq_max 0x%08x ::|rdqs_org  0x%08x  |rdqs_min 0x%08x |rdqs_max 0x%08x  \n",
					lane_step,
					num_array[8+(lane_step)*8+0],num_array[8+(lane_step)*8+1],num_array[8+(lane_step)*8+2],
					num_array[8+(lane_step)*8+4],num_array[8+(lane_step)*8+5],num_array[8+(lane_step)*8+6]);
		}
		lane_step=4;
		{
			printf("\nac_lane_0x%08x|lcd_org 0x%08x  |lcd_min 0x%08x |lcd_max 0x%08x ::|bdlr_org  0x%08x  |bdlr_min 0x%08x |bdlr_max 0x%08x  \n",
					4,
					num_array[8+(lane_step)*8+0],num_array[8+(lane_step)*8+1],num_array[8+(lane_step)*8+2],
					num_array[8+(lane_step)*8+4],num_array[8+(lane_step)*8+5],num_array[8+(lane_step)*8+6]);
		}
		printf("\n\n-----------------------------------------------------------------------------\n\n");
		{
			printf("\n ac_lane_0x0000000|  lcdlr_org  |lcdlr_set ps|lcdlr_hold ps:|\
					clk_setup  ps| clk_hold ps|adj_percent[100]\n");

			printf("\n ac_lane0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					4,
					num_array[8+(lane_step)*8+0],
					(((num_array[8+(lane_step)*8+2]-num_array[8+(lane_step)*8+0])*delay_step_x100
					 )/100),
					(((num_array[8+(lane_step)*8+0]-num_array[8+(lane_step)*8+1])*delay_step_x100
					 )/100),

					0,
					0,
					100*(num_array[8+(lane_step)*8+2]+num_array[8+(lane_step)*8+1])/(
						2*num_array[8+(lane_step)*8+0]));
			printf("\n ck_lane0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					4,
					num_array[8+(lane_step)*8+4],
					0,
					0,
					(((num_array[8+(lane_step)*8+4]-num_array[8+(lane_step)*8+5])*delay_step_x100
					 )/100),
					(((num_array[8+(lane_step)*8+6]-num_array[8+(lane_step)*8+4])*delay_step_x100
					 )/100),

					100*(num_array[8+(lane_step)*8+6]+num_array[8+(lane_step)*8+5])/(
						2*num_array[8+(lane_step)*8+4]));
		}
		printf("\n a_lane_0x00000000| wrdq_org 0x0|w_setup x ps|w_hold  x ps::|\
				rd_setup  ps|rd_hold x ps|adj_percent[100]\n");


		for ((lane_step=0);(lane_step<4);(lane_step++))
		{
			printf("\n a_lane_0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					lane_step,
					num_array[8+(lane_step)*8+0],
					(((num_array[8+(lane_step)*8+2]-num_array[8+(lane_step)*8+0])*delay_step_x100
					 )/100),
					(((num_array[8+(lane_step)*8+0]-num_array[8+(lane_step)*8+1])*delay_step_x100
					 )/100),

					0,
					0,
					100*(num_array[8+(lane_step)*8+2]+num_array[8+(lane_step)*8+1])/(
						2*num_array[8+(lane_step)*8+0]));

			printf("\n a_lane_0x%08x| 0x%08x  |   %08d |   %08d ::|    %08d |   %08d |   %08d  \n",
					lane_step,
					num_array[8+(lane_step)*8+4],
					0,
					0,

					(((num_array[8+(lane_step)*8+4]-num_array[8+(lane_step)*8+5])*delay_step_x100
					 )/100),
					(((num_array[8+(lane_step)*8+6]-num_array[8+(lane_step)*8+4])*delay_step_x100
					 )/100),
					100*(num_array[8+(lane_step)*8+6]+num_array[8+(lane_step)*8+5])/(
						2*num_array[8+(lane_step)*8+4]));



		}
	}


	if(test_arg_2_step==DDR_TEST_STATUS_UBOOT_FINISH)//||(test_arg_2_step==DDR_TEST_STATUS_KERNEL_FINISH)
	{
		test_arg_2_step=DDR_TEST_STATUS_KERNEL_ONGING;
		num_array[2]=test_arg_2_step;
		temp_count=2;
		read_write_window_test_parameter(data_source, 
				temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
		run_command("reset",0);
		while(1);

	}

	if(test_arg_2_step==DDR_TEST_STATUS_KERNEL_ONGING)//||(test_arg_2_step==DDR_TEST_STATUS_KERNEL_FINISH)
	{
		test_arg_2_step=DDR_TEST_STATUS_KERNEL_FINISH;
		num_array[2]=test_arg_2_step;
		temp_count=2;
		read_write_window_test_parameter(data_source, 
				temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

		read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
				DDR_TEST_STATUS_STEP_FLAG_ADD_ORG_STICKY_OFFSET ,test_arg_2_step,DDR_PARAMETER_WRITE);
		num_array[1]=DDR_TEST_NULL;
		read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
				DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
		{
			ddr_test_watchdog_disable(); //s
			run_command("run storeboot",0);
			while(1);
		}
	}






	// if( num_array[8+(lane_step<<2)+3]>4)



	return 1;
}


int do_ddr_uboot_kernel_window_use_source_quick_methods(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	//setenv storeboot "ddr_test_cmd 0x34 2 6  20 0 0x100000 0x4000000"
	printf("\nsetenv bootcmd ddr_test_cmd 0x34 2 6  20 0 0x100000 0x4000000 \n");
	printf("\nEnter do_ddr_uboot_window_use_source function\n");
	printf("\n--- watchdog should >15s\n");
#define DDR_TEST_NULL  0
#define DDR_TEST_PASS  1
#define DDR_TEST_FAIL 2

#define  DDR_TEST_STATUS_STEP_FLAG_ADD_ORG_STICKY_OFFSET   4  // PREG_STICKY_REG4
#define  DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET    5  //45// PREG_STICKY_REG4
	//PREG_STICKY_REG5


#define DDR_TEST_STATUS_UBOOT_ONGOING   1
#define DDR_TEST_STATUS_UBOOT_FINISH 2
#define DDR_TEST_STATUS_KERNEL_ONGING  3
#define DDR_TEST_STATUS_KERNEL_FINISH 4

#define DDR_TEST_METHOD_DIVIDER_2   1   //AB METHOD  A is failing B is passing value
#define DDR_TEST_METHOD_DECREASE   2
#define DDR_TEST_METHOD_DECREASE_ALL_SAMETIME   3

	char *endp;
	unsigned int   lane_disable= 0;
	unsigned int   data_source= 0;
	unsigned int  ddr_data_test_method=DDR_TEST_METHOD_DIVIDER_2;
	unsigned int  ddr_add_test_method=DDR_TEST_METHOD_DIVIDER_2;
	unsigned int  ddr_test_method=DDR_TEST_METHOD_DIVIDER_2;

	unsigned int  ddr_enable_kernel_window_test_flag=0;

	unsigned int  ddr_data_test_size=0x1000000;
	unsigned int  ddr_add_test_size=0x10000000;
	unsigned int  ddr_test_size=0x10000000;
	unsigned int  ddr_lcdlr_test_offset=0;
	//unsigned int  ddr_lcdlr_test_org_save=0;
	unsigned int  ddr_lcdlr_test_temp_value=0;

	unsigned int  address_test_watchdog_time_s=15;
	unsigned int  test_watchdog_time_s=15;

	error_outof_count_flag =1;  //for quick out of error
	if (argc >1) {
		data_source = simple_strtoull_ddr(argv[1], &endp, 0);
		if (*argv[1] == 0 || *endp != 0)
		{
			data_source= DDR_PARAMETER_SOURCE_FROM_UBOOT_ENV;
		}
	}
	if (argc >2) {
		watchdog_time_s = simple_strtoull_ddr(argv[2], &endp, 0);
		if (*argv[2] == 0 || *endp != 0)
		{
			watchdog_time_s= 15;
		}
	}
	printf("watchdog_time_s==%d\n",watchdog_time_s);
	test_watchdog_time_s=watchdog_time_s;
	//test_watchdog_time_s=address_test_watchdog_time_s;
	if (argc >3) {
		address_test_watchdog_time_s = simple_strtoull_ddr(argv[3], &endp, 0);
		if (*argv[3] == 0 || *endp != 0)
		{
			address_test_watchdog_time_s= watchdog_time_s;
		}
	}
	printf("address_test_watchdog_time_s==%d\n",address_test_watchdog_time_s);
	//lane_disable=g_ddr_test_struct->ddr_test_lane_disable;
	if (argc >4) {
		lane_disable = simple_strtoull_ddr(argv[4], &endp, 0);
		if (*argv[4] == 0 || *endp != 0)
		{
			lane_disable= 0;
		}
	}
	printf("lane_disable==0x%08x\n",lane_disable);   

	if (argc >5) {
		ddr_data_test_size = simple_strtoull_ddr(argv[5], &endp, 0);
		if (*argv[5] == 0 || *endp != 0)
		{
			ddr_data_test_size= 0x100000;
		}
	}
	printf("ddr_data_test_size==0x%08x\n",ddr_data_test_size);
	if (argc >6) {
		ddr_add_test_size = simple_strtoull_ddr(argv[6], &endp, 0);
		if (*argv[6] == 0 || *endp != 0)
		{
			ddr_add_test_size= 0x10000000;
		}
	}
	printf("ddr_add_test_size==0x%08x\n",ddr_add_test_size);
	if (argc >7) {
		ddr_data_test_method = simple_strtoull_ddr(argv[7], &endp, 0);
		if (*argv[7] == 0 || *endp != 0)
		{
			ddr_data_test_method= DDR_TEST_METHOD_DIVIDER_2;
		}
	}
	printf("ddr_data_test_method==0x%08x\n",ddr_data_test_method);
	if (argc >8) {
		ddr_add_test_method = simple_strtoull_ddr(argv[8], &endp, 0);
		if (*argv[8] == 0 || *endp != 0)
		{
			ddr_add_test_method= DDR_TEST_METHOD_DIVIDER_2;
		}
	}
	printf("ddr_add_test_method==0x%08x\n",ddr_add_test_method);

	if (argc >9) {
		ddr_enable_kernel_window_test_flag = simple_strtoull_ddr(argv[9], &endp, 0);
		if (*argv[9] == 0 || *endp != 0)
		{
			ddr_enable_kernel_window_test_flag= 0;
		}
	}
	printf("ddr_enable_kernel_window_test_flag==0x%08x\n",ddr_enable_kernel_window_test_flag);

	unsigned int rank_index=0;
	unsigned int temp_count=0;
	unsigned int ddr_test_data_array_max=100;
	unsigned int num_array[100];//8 flag 32_data add_8  32_data add_8

	unsigned int temp_test_error=0;
	unsigned int lcdlr_min=0;
	unsigned int lcdlr_max=0;
	memset(num_array, 0, sizeof(num_array));
	char str[1024]="";

	if(data_source==DDR_PARAMETER_SOURCE_FROM_DMC_STICKY)
		ddr_test_data_array_max=64;
	for (temp_count= 0;temp_count < ddr_test_data_array_max; temp_count++) 
	{
		num_array[temp_count]= read_write_window_test_parameter(data_source, 
				temp_count ,num_array[temp_count],DDR_PARAMETER_READ );
		printf("read numarry[%d]==%d\n",temp_count,num_array[temp_count]);
	}

	unsigned int test_arg_0_orgt_store_lcdlr_value =0;  //best_lcdlr_value
	unsigned int test_arg_1_test_error_flag =0;  //min cmd
	unsigned int test_arg_2_step =0; //step 0  init  -1  UBOOT ONGOING  2 UBOOT FINISH  3 KERNEL ONGOING 4 KERNEL FINISH
	unsigned int test_arg_3_freq =0;
	unsigned int test_arg_4_step_status =0; //uboot test we should read error then done status.  0 no test 1 ongoing 2 this step done  fail or pass
	unsigned int test_arg_5_ab_edge_lcdlr_value =0;
	unsigned int test_arg_6_lcdlr_temp_count =0;
	unsigned int test_arg_7_magic_number =0;
	unsigned int org_lcdlr_value_temp=0;
	unsigned int acmdlr=0;
	acmdlr=do_ddr_read_acmdlr();

	test_arg_0_orgt_store_lcdlr_value=num_array[0];
	test_arg_1_test_error_flag=num_array[1];
	test_arg_2_step=num_array[2];
	test_arg_3_freq=num_array[3];
	test_arg_4_step_status=num_array[4];
	test_arg_5_ab_edge_lcdlr_value=num_array[5];
	test_arg_6_lcdlr_temp_count=num_array[6];
	test_arg_7_magic_number=num_array[7];
	printf("test_arg_0_orgt_store_lcdlr_value==%d\n",test_arg_0_orgt_store_lcdlr_value);
	printf("test_arg_1_test_error_flag==%d\n",test_arg_1_test_error_flag);
	printf("test_arg_2_step==%d\n",test_arg_2_step);
	printf("test_arg_3_freq==%d\n",test_arg_3_freq);
	printf("test_arg_4_step_status==%d\n",test_arg_4_step_status);
	printf("test_arg_5_ab_edge_lcdlr_value=%d\n",num_array[5]);
	printf("test_arg_6_lcdlr_temp_count=%d\n",num_array[6]);
	printf("test_arg_7_magic_number=%d\n",num_array[7]);



	if((test_arg_7_magic_number==DMC_STICKY_MAGIC_1)) //for check magic number make sume enter test command
	{
	}
	else
	{

		test_arg_0_orgt_store_lcdlr_value=0;
		test_arg_5_ab_edge_lcdlr_value=0;
		test_arg_2_step=0;
		test_arg_6_lcdlr_temp_count=0;
		test_arg_7_magic_number=DMC_STICKY_MAGIC_1;
	}
	//printf("boot times==%d\n",test_arg_5_ab_edge_lcdlr_value);
	num_array[0]	=	test_arg_0_orgt_store_lcdlr_value		;
	num_array[1]	=	test_arg_1_test_error_flag		;
	num_array[2]	=	test_arg_2_step		;
	num_array[3]	=	test_arg_3_freq		;
	num_array[4]	=	test_arg_4_step_status		;
	num_array[5]	=	test_arg_5_ab_edge_lcdlr_value		;
	num_array[6]	=	test_arg_6_lcdlr_temp_count		;
	num_array[7]	=	test_arg_7_magic_number		;

	for (temp_count= 0;temp_count < 8; temp_count++) 
	{
		read_write_window_test_parameter(data_source, 
				temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
	}



	if(test_arg_2_step)
	{
		if(test_arg_3_freq!=global_ddr_clk)  //
		{
			printf("running ddr freq==%d,but test freq is%d,will reboot use d2pll \n",global_ddr_clk,test_arg_3_freq);
			sprintf(str,"d2pll  %d",test_arg_3_freq);
			printf("\nstr=%s\n",str);
			run_command(str,0);
			while(1);
		}
	}
	if(test_arg_2_step==0)
	{
		{



			test_arg_0_orgt_store_lcdlr_value=0;
			test_arg_1_test_error_flag=0;
			test_arg_2_step=DDR_TEST_STATUS_UBOOT_ONGOING;
			test_arg_3_freq=global_ddr_clk;
			test_arg_4_step_status=0;
			test_arg_5_ab_edge_lcdlr_value=0;
			test_arg_6_lcdlr_temp_count=lcdlr_min;
			test_arg_7_magic_number=DMC_STICKY_MAGIC_1;
			num_array[0]	=	test_arg_0_orgt_store_lcdlr_value		;
			num_array[1]	=	test_arg_1_test_error_flag		;
			num_array[2]	=	test_arg_2_step		;
			num_array[3]	=	test_arg_3_freq		;
			num_array[4]	=	test_arg_4_step_status		;
			num_array[5]	=	test_arg_5_ab_edge_lcdlr_value		;
			num_array[6]	=	test_arg_6_lcdlr_temp_count		;
			num_array[7]	=	test_arg_7_magic_number		;


			for (temp_count= 0;temp_count < 8; temp_count++) 
			{
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
			}

			// read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
			// 	 DDR_TEST_STATUS_STEP_FLAG_ADD_ORG_STICKY_OFFSET ,test_arg_2_step,DDR_PARAMETER_WRITE);
			//for (temp_count = 8; temp_count< 48;temp_count++) {
			//		num_array[temp_count]=0;
			//}

			for (temp_count = 8; temp_count < (32+8); temp_count++)   //data
			{
				//printf("1temp_count=%d\n",temp_count);

				if((temp_count%4)==0)  //org
				{
					if(((temp_count-8)/4)<8)  
					{
						lcdlr_min=0;
						lcdlr_max=(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//if(lane_step==9)
						//lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
					}
					else if(((temp_count-8)/4)<10)  
					{
						lcdlr_min=0;
						lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						if(((temp_count-8)/4)==9)
							lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
					}
					//printf("2temp_count=%d\n",temp_count);
					//num_array[temp_count]=0;
					//unsigned int do_ddr_read_write_ddr_data_window_lcdlr(unsigned int rank_index,unsigned int data_add_index,unsigned int lcdlr_value,unsigned int read_write_flag ))
					num_array[temp_count]=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,((temp_count-8)>>2),num_array[temp_count],DDR_PARAMETER_READ);
					num_array[temp_count+1]=lcdlr_min;
					num_array[temp_count+2]=lcdlr_max;//num_array[temp_count];
					num_array[temp_count+3]=0;
					//temp_count=temp_count+4;
				}



			}

			for (temp_count = 32+8; temp_count < (32+8+8); temp_count++)  //add
			{
				if((temp_count%4)==0)  //org
				{	
					if(((temp_count-8)/4)<8)  
					{
						lcdlr_min=0;
						lcdlr_max=(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//if(lane_step==9)
						//lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
					}
					else if(((temp_count-8)/4)<10)  
					{
						lcdlr_min=0;
						lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
						if(((temp_count-8)/4)==9)
							lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
					}
					//num_array[temp_count]=0;
					//unsigned int do_ddr_read_write_ddr_data_window_lcdlr(unsigned int rank_index,unsigned int data_add_index,unsigned int lcdlr_value,unsigned int read_write_flag ))
					num_array[temp_count]=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,((temp_count-8-32)>>2),num_array[temp_count],DDR_PARAMETER_READ);
					num_array[temp_count+1]=lcdlr_min;
					num_array[temp_count+2]=lcdlr_max;//num_array[temp_count];
					num_array[temp_count+3]=0;
				}


			}




#if  (CONFIG_DDR_PHY<=P_DDR_PHY_905X)
			printf("DDR0_PUB_DX0GCR0==%x\n",(readl(DDR0_PUB_DX0GCR0)));
			printf("DDR0_PUB_DX1GCR0==%x\n",(readl(DDR0_PUB_DX1GCR0)));
			printf("DDR0_PUB_DX2GCR0==%x\n",(readl(DDR0_PUB_DX2GCR0)));
			printf("DDR0_PUB_DX3GCR0==%x\n",(readl(DDR0_PUB_DX3GCR0)));
			if(((readl(DDR0_PUB_DX0GCR0))&1)==0)
				lane_disable=   lane_disable|1;      
			if(((readl(DDR0_PUB_DX1GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<1);   
			if(((readl(DDR0_PUB_DX2GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<2);   
			if(((readl(DDR0_PUB_DX3GCR0))&1)==0)
				lane_disable=   lane_disable|(1<<3);   

#endif
			if(lane_disable)
			{if(lane_disable&0x1){
									 num_array[8+3]=0xffff;
									 num_array[8+4+3]=0xffff;
								 }
			if(lane_disable&0x2){
				num_array[8+3+8]=0xffff;
				num_array[8+4+3+8]=0xffff;
			}
			if(lane_disable&0x4){
				num_array[8+3+8+8]=0xffff;
				num_array[8+4+3+8+8]=0xffff;
			}
			if(lane_disable&0x8){
				num_array[8+3+8+8+8]=0xffff;
				num_array[8+4+3+8+8+8]=0xffff;
			}
			printf("lane_disable==%x\n",lane_disable);
			if(lane_disable&0x10){
				num_array[8+3+8+8+8+8]=0xffff;
			}
			if(lane_disable&0x20){
				num_array[8+4+3+8+8+8+8]=0xffff;

			}
			}


		}




		for (temp_count= 0; temp_count< 48;temp_count++) {
			num_array[temp_count]= read_write_window_test_parameter(data_source, 
					temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
		}
	}

	//test_arg_2_step++;
	num_array[2]=test_arg_2_step;
	for (temp_count = 1; temp_count < 48; temp_count++) 
	{
		printf("%d  %d\n", temp_count,num_array[temp_count]);
	}
	temp_count=2;
	num_array[temp_count]= read_write_window_test_parameter(data_source, 
			temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
	//	 read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
	// 	 DDR_TEST_STATUS_STEP_FLAG_ADD_ORG_STICKY_OFFSET ,test_arg_2_step,DDR_PARAMETER_WRITE);
	//for (i = 0; i < 48; i++) {

	//	 writel(num_array[i],(sticky_reg_base_add+(i<<2)));
	//}


	//for (i = 8; i < 48; i++) {
	//num_array[i]=readl((sticky_reg_base_add+(i<<2)));
	//printf("ddr_test_data_num_%04d==%d\n",i,num_array[i]);
	//}

	///*
	unsigned int lane_step=0;
	unsigned int lane_step_count=0;

	printf("\nstart loop test\n");

	for ((lane_step=0);(lane_step<10);(lane_step++))   //find need test data step
	{
		if(ddr_enable_kernel_window_test_flag==0)
		{
			if((num_array[(lane_step<<2)+3+8]<(0x4)))
			{break;
			}
		}
		else if(test_arg_2_step<DDR_TEST_STATUS_KERNEL_ONGING)
		{
			if((num_array[(lane_step<<2)+3+8]<(0x4)))
			{break;
			}
		}
	}

	if(test_arg_2_step==DDR_TEST_STATUS_UBOOT_ONGOING)
	{if(lane_step>9)
		{
			test_arg_2_step=DDR_TEST_STATUS_UBOOT_FINISH;
			printf("uboot test result: \n");
		}
	}


	if(ddr_enable_kernel_window_test_flag)
	{
		if(test_arg_2_step>DDR_TEST_STATUS_UBOOT_FINISH)
		{
			for ((lane_step=0);(lane_step<10);(lane_step++))   //find need test data step
			{

				{
					if((num_array[(lane_step<<2)+3+8]<(0x4+4)))
					{break;
					}
				}
			}
		}
	}

	if(test_arg_2_step==DDR_TEST_STATUS_UBOOT_FINISH)//||(test_arg_2_step==DDR_TEST_STATUS_KERNEL_FINISH)
	{
		//test_arg_2_step=DDR_TEST_STATUS_KERNEL_ONGING;
	}
	else
	{
		printf("\nstart  test lane_step =%d\n",lane_step);
		if(lane_step<10)
		{
			if(lane_step<8)
			{
				test_watchdog_time_s=watchdog_time_s;
				ddr_test_size=ddr_data_test_size;
				ddr_test_method=ddr_data_test_method;
				//lcdlr_min=0;
				//lcdlr_max=(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);//do_ddr_read_acmdlr();
			}
			else
			{
				test_watchdog_time_s=address_test_watchdog_time_s;
				ddr_test_size=ddr_add_test_size;
				ddr_test_method=ddr_add_test_method;
				//lcdlr_min=0;
				//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
				//lcdlr_max=4*(do_ddr_read_acmdlr());//(num_array[(lane_step<<2)+2+8]);////3*(do_ddr_read_acmdlr());
				//if(lane_step==9)
				//lcdlr_max=0x3f;////3*(do_ddr_read_acmdlr());
			}

			if(num_array[8+(lane_step<<2)+3]>4)  //from kernel 
			{
				num_array[1]= read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
						DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_READ);
				// read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
				// DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
			}

			if(((num_array[8+(lane_step<<2)+3]==0))||((num_array[8+(lane_step<<2)+3]==4)))   //test left edge begin
			{
				/*
				   num_array[1]	=	test_arg_1_test_error_flag		;//1 pass 2 error
				   num_array[2]	=	test_arg_2_step		;
				   num_array[3]	=	test_arg_3_freq		;
				   num_array[4]	=	test_arg_4_step_status		;
				   num_array[5]	=	test_arg_5_ab_edge_lcdlr_value		;
				   num_array[6]	=	test_arg_6_lcdlr_temp_count		;
				   num_array[7]	=	test_arg_7_magic_number		;
				   */
				//         test_arg_0_orgt_store_lcdlr_value=(num_array[8+(lane_step<<2)+0]);
				//	 num_array[0]=test_arg_0_orgt_store_lcdlr_value;
				//	 temp_count=0;
				//	 read_write_window_test_parameter(data_source, 
				// 	 temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);


				if(ddr_test_method==DDR_TEST_METHOD_DECREASE_ALL_SAMETIME)
				{
					test_arg_0_orgt_store_lcdlr_value=(num_array[8+(lane_step<<2)+1]);
					num_array[0]=test_arg_0_orgt_store_lcdlr_value;
					temp_count=0;
					read_write_window_test_parameter(data_source, 
							temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);
				}

				num_array[1]=DDR_TEST_NULL;  //1 //pass 2 error
				num_array[1]=DDR_TEST_FAIL;  //1 //pass 2 error
				temp_count=1;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				if(num_array[8+(lane_step<<2)+3]>4)
				{
					read_write_window_test_flag(DDR_PARAMETER_SOURCE_FROM_ORG_STICKY, 
							DDR_TEST_STATUS_PASS_FAIL_ADD_ORG_STICKY_OFFSET ,num_array[1],DDR_PARAMETER_WRITE);
				}

				read_write_window_test_flag(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				num_array[5]=(num_array[8+(lane_step<<2)+1]);  //edge lcdlr
				temp_count=5;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				(num_array[8+(lane_step<<2)+1])=(num_array[8+(lane_step<<2)+0]);  
				temp_count=8+(lane_step<<2)+1;
				read_write_window_test_parameter(data_source, 
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				if(ddr_test_method==DDR_TEST_METHOD_DIVIDER_2)
					test_arg_6_lcdlr_temp_count=((num_array[5]+num_array[8+(lane_step<<2)+0])>>1);
				else if(ddr_test_method==DDR_TEST_METHOD_DECREASE)
					test_arg_6_lcdlr_temp_count=((num_array[5])+1);
				else if(ddr_test_method==DDR_TEST_METHOD_DECREASE_ALL_SAMETIME)
					test_arg_6_lcdlr_temp_count=((num_array[5])+1);

				num_array[6]=test_arg_6_lcdlr_temp_count;                       //temp_lcdlr
				temp_count=6;
				read_write_window_test_parameter(data_source,  //temp_lcdlr
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);

				num_array[8+(lane_step<<2)+3]=(num_array[8+(lane_step<<2)+3]+1);
				temp_count=8+(lane_step<<2)+3;
				read_write_window_test_parameter(data_source, //lane status
						temp_count ,num_array[temp_count],DDR_PARAMETER_WRITE);


				{
					ddr_test_watchdog_enable(test_watchdog_time_s); //s
					printf("\nenable %ds watchdog \n",test_watchdog_time_s);
					ddr_test_watchdog_clear();
				}

				if(ddr_test_method==DDR_TEST_METHOD_DECREASE_ALL_SAMETIME)
				{
					ddr_lcdlr_test_offset=test_arg_6_lcdlr_temp_count-num_array[0];//test_arg_0_orgt_store_lcdlr_value;//num_array[8+(lane_step<<2)+1];
					do_ddr_read_write_ddr_data_window_lcdlr( rank_index,0,
							(num_array[0]+ddr_lcdlr_test_offset),DDR_PARAMETER_WRITE);
					for ((lane_step_count=1);(lane_step_count<8);(lane_step_count++))   
					{
						if(num_array[8+(lane_step_count<<2)+3]<9)
							do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step_count,
									(num_array[8+(lane_step_count<<2)+1]+ddr_lcdlr_test_offset),DDR_PARAMETER_WRITE);
					}
					for ((lane_step_count=8);(lane_step_count<10);(lane_step_count++))   
					{
						ddr_lcdlr_test_temp_value=(num_array[8+(lane_step_count<<2)+1]+ddr_lcdlr_test_offset);
						if(lane_step_count==9)
						{if (ddr_lcdlr_test_temp_value>0x3f)
							ddr_lcdlr_test_temp_value=0x3f;
						}
						if(num_array[8+(lane_step_count<<2)+3]<9)
							do_ddr_read_write_ddr_add_window_lcdlr( rank_index,(lane_step_count-8),
									ddr_lcdlr_test_temp_value,DDR_PARAMETER_WRITE);
					}
				}
				else
				{
					if(lane_step<8)
					{
						test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_data_window_lcdlr( rank_index,lane_step,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
					}
					else if(lane_step<10)
					{
						test_arg_6_lcdlr_temp_count=do_ddr_read_write_ddr_add_window_lcdlr( rank_index,lane_step-8,test_arg_6_lcdlr_temp_count,DDR_PARAMETER_WRITE);
					}
				}

				//here will dead

				{
					temp_test_error=ddr_test_s_cross_talk_pattern(ddr_test_size);
				}
				//if( num_array[8+(lane_step<<2)+3]>4)


				if (temp_test_error)
				{
					run_command("reset",0);
					while(1);
				}
				else
				{
					if( num_array[8+(lane_step<<2)+3]>4)
					{
						ddr_test_watchdog_disable(); //s
						run_command("run storeboot",0);
						while(1);
					}
					else
					{
						ddr_test_watchdog_clear();
						org_lcdlr_value_temp=num_array[8+(lane_step<<2)+0];

						if(ddr_test_method==DDR_TEST_METHOD_DECREASE_ALL_SAMETIME)
						{
							ddr_lcdlr_test_offset=0;//test_arg_6_lcdlr_temp_count-num_array[8+(lane_step<<2)+1];
							for ((lane_step_count=0);(lane_step_count<8);(lane_step_count++))   
						