/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rv_backend.h,v 1.1.1.1.2.1 2005/05/04 18:20:57 hubbe Exp $
 *
 * REALNETWORKS CONFIDENTIAL--NOT FOR DISTRIBUTION IN SOURCE CODE FORM
 * Portions Copyright (c) 1995-2005 RealNetworks, Inc.
 * All Rights Reserved.
 *
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the Real Format Source Code
 * Porting and Optimization License, available at
 * https://helixcommunity.org/2005/license/realformatsource (unless
 * RealNetworks otherwise expressly agrees in writing that you are
 * subject to a different license).  You may also obtain the license
 * terms directly from RealNetworks.  You may not use this file except
 * in compliance with the Real Format Source Code Porting and
 * Optimization License. There are no redistribution rights for the
 * source code of this file. Please see the Real Format Source Code
 * Porting and Optimization License for the rights, obligations and
 * limitations governing use of the contents of the file.
 *
 * RealNetworks is the developer of the Original Code and owns the
 * copyrights in the portions it created.
 *
 * This file, and the files included with this file, is distributed and
 * made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL
 * SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT
 * OR NON-INFRINGEMENT.
 *
 * Technology Compatibility Kit Test Suite(s) Location:
 * https://rarvcode-tck.helixcommunity.org
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef RV_BACKEND_H__
#define RV_BACKEND_H__

/* Unified RealVideo decoder backend interface */

#include "helix_types.h"
#include "helix_result.h"
#include "rv_format_info.h"
#include "rv_backend_types.h"

#ifdef __cplusplus
extern "C" {
#endif  /* #ifdef __cplusplus */

    /* rv decoder backend interface */

    typedef HX_RESULT(*rv_backend_init_fp)(void *prv10Init,
                                           void **global);
    typedef HX_RESULT(*rv_backend_decode_fp)(UCHAR *pRV10Packets,
            UCHAR *pDecodedFrameBuffer,
            void *pInputParams,
            void *pOutputParams,
            void *global);
    typedef HX_RESULT(*rv_backend_custom_message_fp)(UINT32 *msg_id,
            void *global);
    typedef HX_RESULT(*rv_backend_hive_message_fp)(UINT32 *msg,
            void *global);
    typedef HX_RESULT(*rv_backend_free_fp)(void* global);


    /* The rv_backend struct contains the RealVideo decoder backend
     * function pointers. */

    typedef struct rv_backend_struct {
        rv_backend_init_fp            fpInit;
        rv_backend_decode_fp          fpDecode;
        rv_backend_custom_message_fp  fpCustomMessage;
        rv_backend_hive_message_fp    fpHiveMessage;
        rv_backend_free_fp            fpFree;
    } rv_backend;


#ifdef __cplusplus
}
#endif

#endif /* RV_BACKEND_H__ */
