/*
 * Copyright (C) 2001 Free Software Foundation, Inc.
 * This file is part of the GNU LIBICONV Library.
 *
 * The GNU LIBICONV Library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The GNU LIBICONV Library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the GNU LIBICONV Library; see the file COPYING.LIB.
 * If not, write to the Free Software Foundation, Inc., 51 Franklin Street,
 * Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _FLUSHWC_H
#define _FLUSHWC_H

static int
normal_flushwc(conv_t conv, ucs4_t *pwc)
{
    ucs4_t last_wc = conv->istate;
    if (last_wc) {
        /* Output the buffered character. */
        conv->istate = 0;
        *pwc = (ucs4_t) last_wc;
        return 1;
    } else {
        return 0;
    }
}

#endif /* _FLUSHWC_H */
