// Copyright 2021 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Tagalog`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v14.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [
    0x00171F
  ],
  ranges: [
    [0x001700, 0x001715]
  ]
});
testPropertyEscapes(
  /^\p{Script=Tagalog}+$/u,
  matchSymbols,
  "\\p{Script=Tagalog}"
);
testPropertyEscapes(
  /^\p{Script=Tglg}+$/u,
  matchSymbols,
  "\\p{Script=Tglg}"
);
testPropertyEscapes(
  /^\p{sc=Tagalog}+$/u,
  matchSymbols,
  "\\p{sc=Tagalog}"
);
testPropertyEscapes(
  /^\p{sc=Tglg}+$/u,
  matchSymbols,
  "\\p{sc=Tglg}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x0016FF],
    [0x001716, 0x00171E],
    [0x001720, 0x00DBFF],
    [0x00E000, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Tagalog}+$/u,
  nonMatchSymbols,
  "\\P{Script=Tagalog}"
);
testPropertyEscapes(
  /^\P{Script=Tglg}+$/u,
  nonMatchSymbols,
  "\\P{Script=Tglg}"
);
testPropertyEscapes(
  /^\P{sc=Tagalog}+$/u,
  nonMatchSymbols,
  "\\P{sc=Tagalog}"
);
testPropertyEscapes(
  /^\P{sc=Tglg}+$/u,
  nonMatchSymbols,
  "\\P{sc=Tglg}"
);
