/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef _TAS5805M_H
#define _TAS5805M_H

#include <linux/regmap.h>
//#define TAS5805_REGISTER_COUNT 1879

static const int tas5805m_reset[][2] = {
//RESET
	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x03, 0x02 },
	{ 0xfe, 0x02 }, /* 2ms delay */
	{ 0x01, 0x11 }, /* Reset */
	{ 0xfe, 0x14 }, /* 20ms delay */
	{ 0x00, 0x00 },
	{ 0x00, 0x00 },
	{ 0x00, 0x00 },
	{ 0x00, 0x00 },
	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x03, 0x02 }, /* HiZ */
};

static const int tas5805m_init_sequence[][2] = {
	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x03, 0x00 }, /* Deep Sleep */

	{ 0xfe, 0x14 }, /* 20ms delay */

	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x03, 0x02 }, /* HiZ */

	{ 0x50, 0x04 }, /* Auto Mute Off */
	{ 0x53, 0x60 }, /* BW 175kHz */
	//{ 0x54, 0x12 }, /* AGAIN -9db */
	{ 0x5d, 0x98 }, /* Dither disable, DEM Enabled */
	{ 0x66, 0x07 }, /* DSP Bypass */
	{ 0x33, 0x03 }, /* 32 bit word */
};

static const int tas5805m_init_mono[][2] = {
	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x03, 0x03 },
	{ 0x78, 0x80 },
	{ 0x02, 0x04 },
	{ 0x33, 0x03 },
};

static const int tas5805m_init_rc_filter[][2] = {
	{ 0x7d, 0x11 },
	{ 0x7e, 0xff },
	{ 0x3a, 0xf9 },
	{ 0x3f, 0x0f },
	{ 0x00, 0x01 },
	{ 0x13, 0x20 },

	{ 0x00, 0x00 },
	{ 0x7f, 0x00 },
	{ 0x03, 0x03 }, //  Enter Play
	{ 0x78, 0x80 }, //  Clear fault bit
};

struct tas5805m_platform_data {
	int reset_pin;
	int spk_config;
	int power_pin;
	bool pbtl_mode;
};

#endif
