/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2021 Amlogic, Inc. All rights reserved.
 */

#include <linux/ioctl.h>

#define LLAMA_LOAD_KEY                    (0x820000c0)
#define LLAMA_SETUP_TRANSFER              (0x820000c1)
#define LLAMA_ENCRYPT_TRANSFER            (0x820000c2)
#define LLAMA_DERYPT_TRANSFER             (0x820000c3)
#define LLAMA_RELEASE_KEY                 (0x820000c4)

#define SECURE_MCP_IOC_MAGIC 'k'

struct secure_mcp_data {
	unsigned int source_address;
	unsigned int data_size;
	unsigned int target_address;
};

struct secure_mcp_key_data {
	unsigned int src_addr;
	unsigned int key_no;
};

struct key_process_info_t {
	unsigned int src_addr;
	unsigned int length;
	unsigned int dst_addr;
	unsigned int key_addr;
	unsigned int key[8];
	unsigned int iv[4];
	unsigned char en_de;
	unsigned char bcm;
	unsigned char key_type;
	unsigned char operate_type;
	unsigned char key_encryption_type;
	//        unsigned char key_slot;
};

#define SECURE_MCP_DECRYPT_DATA     _IOWR(SECURE_MCP_IOC_MAGIC, 1, struct secure_mcp_data)
#define SECURE_MCP_LOAD_KEY     _IOWR(SECURE_MCP_IOC_MAGIC, 2, struct secure_mcp_key_data)
#define SECURE_MCP_TRANSFER     _IOWR(SECURE_MCP_IOC_MAGIC, 3, struct secure_mcp_key_data)
#define SECURE_MCP_RELEASE_KEY  _IOWR(SECURE_MCP_IOC_MAGIC, 4, struct secure_mcp_key_data)

/* Debug */
#define SECURE_MCP_DEBUG_EN
#ifdef SECURE_MCP_DEBUG_EN
#define secure_mcp_debug(fmt, args...) pr_debug("[S-MCP] Debug, " fmt, ## args)
#else
#define secure_mcp_debug(fmt, args...)
#endif

#define secure_mcp_info(fmt, args...) pr_info("[S-MCP] " fmt, ## args)
#define secure_mcp_warning(fmt, args...) pr_err("[S-MCP] Warning, " fmt, ## args)
