/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef _TLV320ADC3101_H
#define _TLV320ADC3101_H

/* tlv320aic32x4 register space (in decimal to match datasheet) */

#define ADC3101_REG(page, reg)	(((page) * 128) + (reg))

#define ADC3101_PAGE1		128

#define	ADC3101_PSEL		ADC3101_REG(0, 0)
#define	ADC3101_RESET		ADC3101_REG(0, 1)
#define	ADC3101_CLKMUX		ADC3101_REG(0, 4)
#define	ADC3101_PLLPR		ADC3101_REG(0, 5)
#define	ADC3101_PLLJ		ADC3101_REG(0, 6)
#define	ADC3101_PLLDMSB		ADC3101_REG(0, 7)
#define	ADC3101_PLLDLSB		ADC3101_REG(0, 8)
#define	ADC3101_NDAC		ADC3101_REG(0, 11)
#define	ADC3101_MDAC		ADC3101_REG(0, 12)
#define ADC3101_DOSRMSB		ADC3101_REG(0, 13)
#define ADC3101_DOSRLSB		ADC3101_REG(0, 14)
#define	ADC3101_NADC		ADC3101_REG(0, 18)
#define	ADC3101_MADC		ADC3101_REG(0, 19)
#define ADC3101_AOSR		ADC3101_REG(0, 20)
#define ADC3101_CLKMUX2		ADC3101_REG(0, 25)
#define ADC3101_CLKOUTM		ADC3101_REG(0, 26)
#define ADC3101_IFACE1		ADC3101_REG(0, 27)
#define ADC3101_DATASLOTOFFSETCTL ADC3101_REG(0, 28)
#define ADC3101_IFACE3      ADC3101_REG(0, 29)
#define ADC3101_BCLKN       ADC3101_REG(0, 30)
#define ADC3101_IFACE4      ADC3101_REG(0, 31)
#define ADC3101_IFACE5      ADC3101_REG(0, 32)
#define ADC3101_IFACE6      ADC3101_REG(0, 33)
#define ADC3101_I2SSYNC     ADC3101_REG(0, 34)

#define ADC3101_ADCFLAG     ADC3101_REG(0, 36)
#define ADC3101_DATASLOTOFFSETCTL2 ADC3101_REG(0, 37)
#define ADC3101_TDMCTL      ADC3101_REG(0, 38)

#define ADC3101_INTRADCFLAG  ADC3101_REG(0, 42)
#define ADC3101_INTRADCFLAG2 ADC3101_REG(0, 43)

#define ADC3101_DMCLKCTL    ADC3101_REG(0, 51)
#define ADC3101_DMDINCTL    ADC3101_REG(0, 52)

#define ADC3101_DOUTCTL		ADC3101_REG(0, 53)
#define ADC3101_DINCTL		ADC3101_REG(0, 54)

#define ADC3101_DACSPB		ADC3101_REG(0, 60)
#define ADC3101_ADCSPB	    ADC3101_REG(0, 61)
#define ADC3101_DACSETUP    ADC3101_REG(0, 63)
#define ADC3101_DACMUTE	    ADC3101_REG(0, 64)
#define ADC3101_LDACVOL	    ADC3101_REG(0, 65)
#define ADC3101_RDACVOL	    ADC3101_REG(0, 66)
#define ADC3101_ADCSETUP    ADC3101_REG(0, 81)
#define	ADC3101_ADCFGA	    ADC3101_REG(0, 82)
#define ADC3101_LADCVOL	    ADC3101_REG(0, 83)
#define ADC3101_RADCVOL	    ADC3101_REG(0, 84)
#define ADC3101_LAGC1	    ADC3101_REG(0, 86)
#define ADC3101_LAGC2	    ADC3101_REG(0, 87)
#define ADC3101_LAGC3	    ADC3101_REG(0, 88)
#define ADC3101_LAGC4	    ADC3101_REG(0, 89)
#define ADC3101_LAGC5	    ADC3101_REG(0, 90)
#define ADC3101_LAGC6	    ADC3101_REG(0, 91)
#define ADC3101_LAGC7	    ADC3101_REG(0, 92)
#define ADC3101_RAGC1	    ADC3101_REG(0, 94)
#define ADC3101_RAGC2	    ADC3101_REG(0, 95)
#define ADC3101_RAGC3	    ADC3101_REG(0, 96)
#define ADC3101_RAGC4	    ADC3101_REG(0, 97)
#define ADC3101_RAGC5	    ADC3101_REG(0, 98)
#define ADC3101_RAGC6	    ADC3101_REG(0, 99)
#define ADC3101_RAGC7	    ADC3101_REG(0, 100)
#define ADC3101_PWRCFG		ADC3101_REG(1, 1)
#define ADC3101_LDOCTL		ADC3101_REG(1, 2)
#define ADC3101_OUTPWRCTL	ADC3101_REG(1, 9)
#define ADC3101_CMMODE		ADC3101_REG(1, 10)
#define ADC3101_HPLROUTE	ADC3101_REG(1, 12)
#define ADC3101_HPRROUTE	ADC3101_REG(1, 13)
#define ADC3101_LOLROUTE	ADC3101_REG(1, 14)
#define ADC3101_LORROUTE	ADC3101_REG(1, 15)
#define	ADC3101_HPLGAIN		ADC3101_REG(1, 16)
#define	ADC3101_HPRGAIN		ADC3101_REG(1, 17)
#define	ADC3101_LOLGAIN		ADC3101_REG(1, 18)
#define	ADC3101_LORGAIN		ADC3101_REG(1, 19)
#define ADC3101_HEADSTART	ADC3101_REG(1, 20)
#define ADC3101_MICBIAS		ADC3101_REG(1, 51)
#define ADC3101_LMICPGAPIN	ADC3101_REG(1, 52)
#define ADC3101_LMICPGANIN	ADC3101_REG(1, 54)
#define ADC3101_RMICPGAPIN	ADC3101_REG(1, 55)
#define ADC3101_RMICPGANIN	ADC3101_REG(1, 57)
#define ADC3101_FLOATINGINPUT	ADC3101_REG(1, 58)
#define ADC3101_LMICPGAVOL	ADC3101_REG(1, 59)
#define ADC3101_RMICPGAVOL	ADC3101_REG(1, 60)

#define ADC3101_FREQ_2048000  2048000
#define ADC3101_FREQ_4096000  4096000
#define ADC3101_FREQ_8192000  8192000
#define ADC3101_FREQ_11289600 11289600
#define ADC3101_FREQ_12288000 12288000
#define ADC3101_FREQ_12000000 12000000
#define ADC3101_FREQ_24000000 24000000
#define ADC3101_FREQ_44100000 44100000
#define ADC3101_FREQ_48000000 48000000
#define ADC3101_FREQ_96000000 96000000
#define ADC3101_FREQ_25000000 25000000

#define ADC3101_WORD_LEN_16BITS		0x00
#define ADC3101_WORD_LEN_20BITS		0x01
#define ADC3101_WORD_LEN_24BITS		0x02
#define ADC3101_WORD_LEN_32BITS		0x03

#define ADC3101_LADC_EN			BIT(7)
#define ADC3101_RADC_EN			BIT(6)

#define ADC3101_I2S_MODE		0x00
#define ADC3101_DSP_MODE		0x01
#define ADC3101_RIGHT_JUSTIFIED_MODE	0x02
#define ADC3101_LEFT_JUSTIFIED_MODE	0x03

#define ADC3101_AVDDWEAKDISABLE		0x08
#define ADC3101_LDOCTLEN		0x01

#define ADC3101_LDOIN_18_36		0x01
#define ADC3101_LDOIN2HP		0x02

#define ADC3101_DACSPBLOCK_MASK		0x1f
#define ADC3101_ADCSPBLOCK_MASK		0x1f

#define ADC3101_PLLJ_SHIFT		6
#define ADC3101_DOSRMSB_SHIFT		4

#define ADC3101_PLLCLKIN		0x03
#define ADC3101_BCLKIN		0x05
#define ADC3101_BCLKIN_PLLCLKIN		0x07

#define ADC3101_MICBIAS_LDOIN		0x08
#define ADC3101_MICBIAS_2075V		0x60

#define ADC3101_LMICPGANIN_IN2R_10K	0x10
#define ADC3101_LMICPGANIN_CM1L_10K	0x40
#define ADC3101_RMICPGANIN_IN1L_10K	0x10
#define ADC3101_RMICPGANIN_CM1R_10K	0x40

#define ADC3101_LMICPGAVOL_NOGAIN	0x80
#define ADC3101_RMICPGAVOL_NOGAIN	0x80

#define ADC3101_BCLKMASTER		0x08
#define ADC3101_WCLKMASTER		0x04
#define ADC3101_PLLEN			(0x01 << 7)
#define ADC3101_NDACEN			(0x01 << 7)
#define ADC3101_MDACEN			(0x01 << 7)
#define ADC3101_NADCEN			(0x01 << 7)
#define ADC3101_MADCEN			(0x01 << 7)
#define ADC3101_BCLKEN			(0x01 << 7)
#define ADC3101_DACEN			(0x03 << 6)
#define ADC3101_RDAC2LCHN		(0x02 << 2)
#define ADC3101_LDAC2RCHN		(0x02 << 4)
#define ADC3101_LDAC2LCHN		(0x01 << 4)
#define ADC3101_RDAC2RCHN		(0x01 << 2)
#define ADC3101_DAC_CHAN_MASK		0x3c

#define ADC3101_SSTEP2WCLK		0x01
#define ADC3101_MUTEON			0x0C
#define	ADC3101_DACMOD2BCLK		0x01

#endif /* _TLV320ADC3101_H */
