// Copyright 2017, the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Generated by tools/bigint-tester.py.

var data = [{
  a: -0x29f29fcc6a8beaec58ce604d72548de9b6b2ef4d08ff158112cff6b7ce3cddn,
  b: 0xbc1f3810ca925e50cd58891n,
  r: 0x2c100800ca9200108118001n
}, {
  a: 0x14bf4323f74a2cd8c9b7757152ac1006d3a30464506n,
  b: -0x5c7f11fd462a70356c972n,
  r: 0x14bf4323f74a2cd8c9b7752100ac0000d1830000406n
}, {
  a: -0x4ddn,
  b: -0x8n,
  r: -0x4e0n
}, {
  a: -0xf20dc167b3c9158dddn,
  b: 0x41c01eba44a2d42dce7de0d4f01e53ad0bdcc020f497765cee2d9a317fe1cn,
  r: 0x41c01eba44a2d42dce7de0d4f01e53ad0bdcc020f4905600e804822027200n
}, {
  a: 0x2faa76f9622dbe8de9520e5n,
  b: 0xf4431506405ccd3b02ad5133e0d2c32648e257f0ed3n,
  r: 0x12260d04224088041500c1n
}, {
  a: 0xff190f0071n,
  b: 0x1719de94c05a7e8a7504be1fcda42e45693ab0289ca64894a97785b427127baab6n,
  r: 0x27100b0030n
}, {
  a: -0x1b810d4522cef4e40c351cdea8e1843c35bd7ebb3a6n,
  b: 0x6n,
  r: 0x2n
}, {
  a: 0x3cea8fb44ae32638n,
  b: 0x5222dacc3031876e51d099d05d918a3db560c5811fa3424n,
  r: 0x18420c1000e22420n
}, {
  a: 0x72ecb526148752c1a796e4cd7bc3d0e5f766n,
  b: 0x6bd1ff8b5cn,
  r: 0x43d0e58344n
}, {
  a: -0xbe83b80e180958e5dc0a817c082a3e71238a3fdec6d4692dn,
  b: -0x14dc174d05904c31f80b53f87f1c5baf8cfa9d476769c16259b23a29n,
  r: -0x14dc174dbf93fc3ff80b5bfdff1edbff8cfabf7767ebfffedff67b2dn
}, {
  a: 0x9e631f753df5n,
  b: 0xf13ce3e128dc0673f92128871affda0dc1197e89n,
  r: 0x9a0101113c81n
}, {
  a: -0xe25afb850040c1fc13997432d37810dc71e60d64688c143b8d636c9n,
  b: 0x516db9e3ec0d426879481f2n,
  r: 0x9b083840142407008132n
}, {
  a: 0x88fed02f1bbf3ba8ad38c77fa05f564a1e2f1fba755ee5c86d4bc49dn,
  b: -0x47dd35756eebfb6794db54eaf1c430cn,
  r: 0x88fed02f1bbf3ba8ad38c77fa0020408080100080412408040438494n
}, {
  a: -0xcd7an,
  b: -0xbc49f621n,
  r: -0xbc49ff7an
}, {
  a: 0x4f12919f217f9b126eef68045afad3803a64b43e16ab2n,
  b: 0x19600c28599fe097f1302en,
  r: 0x1200c2801864003e12022n
}, {
  a: -0xdd086de0n,
  b: 0xc065b7ffde5a763910d1f45f417a188d629ff03n,
  r: 0xc065b7ffde5a763910d1f45f417a18802219200n
}, {
  a: 0x2f2a7fb21dfc8c0c10c794945951876n,
  b: -0xc4a119f301c6b2eedaac91fc107736e64a1fc5ce2c5688aen,
  r: 0x5226032188c8008100380141811052n
}, {
  a: 0x1a9a9368b460501df66110bc976f641n,
  b: 0x66191e7342ad0b92dec7e519a3549429647352dfcbf1536bafbeb801n,
  r: 0x100802000420001cb60110b8936b001n
}, {
  a: 0x81c2db18e3bab9f36bb003c60354b6e952db4693f2b6979bf240102c9bbcn,
  b: 0x824c4377c827c08b221ff892c428184n,
  r: 0x204013448270009201f20000008184n
}, {
  a: -0x64bbb685b38dc1de5c2a3640ca82dcb829634367f3104335f2n,
  b: 0x3a91c1649434ea4f4ea5a40711060cn,
  r: 0x89101640004c20c0c80040710020cn
}, {
  a: -0xc6a3d4n,
  b: -0xbb8f025ffbec83f79f21ebf8243278ac8ebde4f4bfd68128225e20n,
  r: -0xbb8f025ffbec83f79f21ebf8243278ac8ebde4f4bfd68128e6ffe0n
}, {
  a: -0xceb9dn,
  b: 0x24c9ac5c328c21faf1951c327e302481930e6f8fae8d1f03cbadb284n,
  r: 0x24c9ac5c328c21faf1951c327e302481930e6f8fae8d1f03cba11000n
}, {
  a: 0xd856b88193cb06f4161f9819bn,
  b: -0x92984bd5e5032dec2a96178be83a60b291f11d9329c6eb34461e2n,
  r: 0x9844280082480630140b9801an
}, {
  a: -0xc76a1defabn,
  b: -0x6a84a7020cd47c166482e92248431462b14n,
  r: -0x6a84a7020cd47c166482e9224c77b5fefbcn
}, {
  a: 0xda83e7cn,
  b: -0xabd6225fcd0c0ad014ad70b1d77864f8273936b334dbbf7a5c6a5106n,
  r: 0x1802e78n
}, {
  a: -0xebfb92feafd3d0ce53808144513cdd4fcff67e5bed8fd3f72bn,
  b: -0x5e9eb5010bf67029d513afd5e0893413f663e36d34800e528aen,
  r: -0x5ebfbd2febff7d2df53bafd5e59bfdd7feffe7edbed8ff7ffb0n
}, {
  a: -0x8618583481616546f3010095d57d54d7e6c8caf069b3f5823e8772088024263ee2n,
  b: 0xee4667e315fd226fa21ac835a9eba0e84141540d73518645dn,
  r: 0xce4666a2002822018212403120c0a0c80100540571118401cn
}, {
  a: -0xec3543bbbcbaaf313447n,
  b: -0xe4afcba553615cc02ebd8e02a3504e05fa2dd9bd52e355761b0f261bed202n,
  r: -0xe4afcba553615cc02ebd8e02a3504e05fa2dd9bd5ee3557fbbcfaefbff648n
}, {
  a: -0x6ae35c1d5cabdfd5626e1d1ec620d26e40ccc13n,
  b: -0x770976ca5e188d93eb970e0fd830617fn,
  r: -0x6ae35c1f7cbffff5e3eedd3eff70f2ffc3ced7fn
}, {
  a: 0xf747be3742ebe764e7df17f653aa7fea1729266549a62ebaf57n,
  b: -0xfd1c4869c90c4fa72a3cdbc25f9205e9d2281286909ce755f9c9f92n,
  r: 0xb70636330048c540241d006452022dc20529266108a20632046n
}, {
  a: 0xfdd52e1f0c36e7af75ca5n,
  b: -0x75d2e495e559fd86317dbc8a4939b91cdeff4443e86195985bef8537c2c6e45ff2c7n,
  r: 0x7841060c001281aa00c21n
}, {
  a: 0x8b6f11954f974d50cf676f4115n,
  b: -0x8e1a3bd5003cc3d072101534b549dee2811ca52864895fcn,
  r: 0x8824010001974c108d61274004n
}, {
  a: 0x24412f7875aa43776fc7f9n,
  b: -0x18ca87cea5368b3ceaee7en,
  r: 0x2401283050884043050180n
}, {
  a: -0xe967d654767ec2372b5b514300b78bf95b0cc5n,
  b: -0xc440a7fbfdn,
  r: -0xe967d654767ec2372b5b514300b7cff9fffffdn
}, {
  a: 0x35e950f915feb52ab4b177ff1c43ef3df51cfd99033cba8dn,
  b: 0xf3e333c6867107a15aa75d2bb5d6392ef8a8ede2468n,
  r: 0x38113c2022103015aa1442ab1d6110ed88021c2008n
}, {
  a: -0x547f8f78a98d071b0fac1b3479de28e4bf76d1f2b6007ccn,
  b: -0xf1359657b315a4860b8c2dc20a907n,
  r: -0x547f8f78a98d071b0ffd3fb67fff3de4bf7fddfff60afd0n
}, {
  a: 0xa72f6ce91df5aaae5a97c9b851f8a9d9b4n,
  b: 0xc734238b4c6c12b9e5ba3a284410a50n,
  r: 0xc604018b482800a9649a00080010810n
}, {
  a: -0x18f29bf448ad90d6107n,
  b: -0x67f7d596f5c5cde4295ca84d2a2592d86ef59an,
  r: -0x67f7d596f5c5cde4295daf6dbf659ad96ff5a0n
}, {
  a: -0xf2871007d38df25abd4d7c33cdf585a8c9n,
  b: -0x6667ca4599e7d0304bc3c45ceb86e206929da2en,
  r: -0x6667cf6df9e7fd38dfe7efdcffc7fedfdadfaeen
}, {
  a: 0xc187239bab7073489n,
  b: -0x4248a734n,
  r: 0xc187239bab5071088n
}, {
  a: 0xdbdcf7494b8150367c99463766dba176defb77165a8fe681a2e4en,
  b: -0xb55fd8158688229b82d9cc21576e1515727002aaa780208d7e316f9287en,
  r: 0xca587749400100325c88002262898174545877165281c68020602n
}, {
  a: 0x99a2n,
  b: -0xe85e54983026398b90df9a75d0d2f8674e3345122fcaae623e25fa2c12217afcn,
  r: 0x8100n
}, {
  a: -0x6a7389993971fce37daec82c1b90ece693f2293990570de8295ee297178ca2dn,
  b: -0xc99dd301e34c6dd94310d7a18n,
  r: -0x6a7389993971fce37daec82c1b90ece693f229f99dd70deb6d7ffbd717dfa40n
}, {
  a: -0x66f3499980836821754733d3d1dfb60a46dfd05a2104c7b2cbb012a130fdb081b5087n,
  b: -0x96ece5b53095c2f8c08eb3de79cdbd6909fc758d352c457n,
  r: -0x66f3499980836821754733d7fdffb73ad7dff8daafb7dffbcfbd7ba9fcfdbdb5bd4d7n
}, {
  a: -0xf95a8432276f9800ec630eaf85fn,
  b: -0x130ce3f51a2109d4a21d4fn,
  r: -0xf95a8532ef7fd9a2fcff4eafd5fn
}, {
  a: 0x82b9b91703cb40bd886a9cc29a2fc55a9f58836c921cb035cdaccc7b744n,
  b: -0xb62ab6695d7959e7ce97faeb5807defaab7084424a7f335afe77e7fc7n,
  r: 0x82099101028200a4082008001027c000055083689014800485008818000n
}, {
  a: -0x2e9040b31n,
  b: 0x982dd4b7680a28fadfbn,
  r: 0x982dd4b7680028ba4cbn
}, {
  a: -0xdaf9c00c6cbn,
  b: 0xbf170a3f6c6b30ef537bd30e997cf575d0319f5e7cfb34ad117ea9n,
  r: 0xbf170a3f6c6b30ef537bd30e997cf575d0319f5e7cf21021113821n
}, {
  a: -0xc767bc061298599012d66e1643ecb7026a6732c6902f5ad69e2dab3e411n,
  b: -0xf693743caf7e9b6bd7f9b0d5b6b68b2ba362a034b9a8489769b9n,
  r: -0xc767bc0f7bbf5bdaf7fffebf7fffbf5b6b6fb2feb62f5bdf9eadab7edb9n
}, {
  a: 0xdda7e9a40b58cef7abf8ad60f34e1205d4c9c4959b1c9a6082c66f93907e0146f44222n,
  b: -0x390e37n,
  r: 0xdda7e9a40b58cef7abf8ad60f34e1205d4c9c4959b1c9a6082c66f93907e0146c44000n
}, {
  a: 0x50b6cc817d15e9880cb739b5b35n,
  b: 0x2676592e3a1cbcn,
  r: 0x49221a1834n
}, {
  a: 0xcad9cb20273d51f086405e5e858374f6eb446c136eb2bb41822af1cc9a5b31n,
  b: -0xeeba1940401b82ae1711981d935df0cee345d01ff6c0fc4n,
  r: 0xcad9cb20273d51f004404a5a840354168a446c024a20b3018222f000925030n
}, {
  a: -0x85ed554867d624b6e511f97be969a0cff95ce12476f6de57651d9f9n,
  b: -0x6c46f6b0fcen,
  r: -0x85ed554867d624b6e511f97be969a0cff95ce12476f6fe57f7bdffen
}, {
  a: 0x6f89f28daa7db10f003c64a5467d736b13fbfd5733f20dcd548f04b1d10b47a9fbef3n,
  b: -0xe9941c53ed96f8c8b76057n,
  r: 0x6f89f28daa7db10f003c64a5467d736b13fbfd5733f20dc1448e00810000432089ea1n
}, {
  a: -0x3fdb67f36148bn,
  b: 0xab3f31517a3b53be953b1d04adfec9bac0cd9735d0bf735c73d058fn,
  r: 0xab3f31517a3b53be953b1d04adfec9bac0cd9735d08020180090105n
}, {
  a: -0x78668b69cd299c271df70532e46edcd3150651ee90b65a46131cd56db085n,
  b: 0x5e74cc5n,
  r: 0x824c41n
}, {
  a: -0x52d794bed19f43den,
  b: 0x5b0052579n,
  r: 0x120002420n
}, {
  a: 0x28900216b9fc91c710a898c9dd4c482df25b69cb9cc0n,
  b: -0xf1n,
  r: 0x28900216b9fc91c710a898c9dd4c482df25b69cb9c00n
}, {
  a: -0x9b0bb0742e1dc8n,
  b: 0x22ca573970d3c25e7afa6f81bc6abf3d73n,
  r: 0x22ca573970d3c25e7afa64800c0a912030n
}, {
  a: -0x86fb56d32aad0aaab0dd44n,
  b: 0xe3438dfn,
  r: 0x404209cn
}, {
  a: 0xf7f4ba921bbb9578a3629be0befn,
  b: 0xd1ee0e758f1e4fa1b67ebda846n,
  r: 0x514a08218b1847803628bc0846n
}, {
  a: 0x7f544782c05b310d72ac585c762ed4n,
  b: -0xf0887aa85d49b6a4f45e8565b8524an,
  r: 0xf5405028012010902a05818462c94n
}, {
  a: -0xd0dc207f99c517ed01c4174f06aead1fabc519en,
  b: 0x100793n,
  r: 0x602n
}, {
  a: 0x7c0d6ae646521254d7d2n,
  b: 0xe0006005fca5a0d93ca02d2e3n,
  r: 0xd4a4204120200d2c2n
}, {
  a: -0xcb31f5a4516b313n,
  b: -0x7cc5fb30d155f3ce68bfd5n,
  r: -0x7cc5fb3cf35ffbcf7ebfd7n
}, {
  a: 0x4a4c263cc2aa0cbaac94e5e8016cc03n,
  b: 0xf8443dn,
  r: 0x104401n
}, {
  a: 0xabbfef7c0ee1ac65121607cbd4e9c0580fa2b4cfea84cda77bf24n,
  b: 0x961a0e15332bfca9f5092ce3fb29f5ab76f983f450a9c7e3bc2n,
  r: 0x960a0c0421286400140108c0e900500b22b083e000898763b00n
}, {
  a: -0x4ee258a2c17dde031704409a1ea82f48c79cc91e013e1e4af8bb52e45ddec83n,
  b: 0xcdb19af4ec147b33ace5e5986f74a65030458647177a1feaen,
  r: 0xcca09ab464005310a4206110617480403005040513220122cn
}, {
  a: -0x7a3c508a7257ca2bb84898d2f2d387e28e08e8edb200c2e9a44c863n,
  b: 0x4ca3c81e56d04c295b6f29fcbe9d1ded3f2n,
  r: 0x4421080c50104021130209fc3c1419a1390n
}, {
  a: 0x85d9f93189c7add6adb46d5f9bcd30f53c1a20eaf2de3f4f92n,
  b: 0x4eb0fdacf721f30e1cd94dd8e4e2039401b122e4f0c86e9n,
  r: 0xe90188c7201620a04d14998c002038000002224e0c0680n
}, {
  a: -0xb57f5eb6246cb33d0a9f963821710aea589bc68beff4a48fa56f4833c5caa3d991e0an,
  b: -0xa93e2d8a8a63ef50f86e05791a279cn,
  r: -0xb57f5eb6246cb33d0a9f963821710aea589bc68bfff6fcafa77ffd3fc7eaf7d9b3f9cn
}, {
  a: 0xaa60e2ed0d5689c32f772an,
  b: -0xd8e51371n,
  r: 0xaa60e2ed0d5689030a640an
}, {
  a: 0x9c8678f8faf256b902a690ed5949303e3fbe30525e2c356a87684en,
  b: -0xad5e52f89b5f7134ed8e6dd660fd93a515906a8376c5de70d67938a32e2an,
  r: 0x4042088ca1250900086006c584820143c8830000e280442044046n
}, {
  a: 0x187a7d65bc0a408df3f6e5b70da899f8n,
  b: -0x61f0a4ac4c63d7488a580c5da837e8a5075eb9d87db259eefa6d82375e8n,
  r: 0x702d0014024004d260001105888818n
}, {
  a: -0xdac75b1f854043594b174c48c6fn,
  b: 0x283d278bf86fcd9d43a2dba77c06ae1d143a7f147eb60b94bbe1e73d5b939n,
  r: 0x283d278bf86fcd9d43a2dba77c06ae1d1420380460320b94a2a0e03113111n
}, {
  a: 0n,
  b: 0x10f6b0fa4c20ed31a35b15d1476cd5a889ee6c03c8f61260b00433an,
  r: 0n
}, {
  a: -0x1f2d4f1021026b78e6e53b004efd1e473454b0a4ea7e7ff5c665c860n,
  b: 0x5088c620b2c9dn,
  r: 0x10008200a2480n
}, {
  a: -0x7d1d7208aa1095f0e4eb54bd5596695d1b71dd7ab9a095fe0583fcffn,
  b: 0x5e451efaa447faa12535a0a8d86c79afb73b7424823f75db5043a3n,
  r: 0x42051650a4420a01042100a8480420a486220404022a01da500301n
}, {
  a: 0x90ebf6fcbd428530bec77b121ff9b717e21b3472a6513108e9362752an,
  b: -0xe33be701f8d794f21d99e5504fdb768bff1e17b780dda8ff9n,
  r: 0x90ebf6fc1c40003006006b0002601207a000007000412008692207002n
}, {
  a: 0xa87059aa0f1dc0bd1n,
  b: 0x7ca4fad7348de117ec36dc4a5ef81c6b9e07f0d92n,
  r: 0x870182a0e05c0990n
}, {
  a: -0x9n,
  b: -0x77959c1a7325c8ad86d84229600e1989da559d34ea1bb7af9n,
  r: -0x77959c1a7325c8ad86d84229600e1989da559d34ea1bb7af9n
}, {
  a: 0x723601043597fc320737ad76cc6bcedb9b0812627251ef0291e28230fen,
  b: -0xf0753631a6b4725d113709n,
  r: 0x723601043597fc320737ad76cc6bcedb9b0802024040490281a28200f6n
}, {
  a: 0x190ddc69d7988c64476bfce1f8d0bd5c9078n,
  b: 0xe91350af07694n,
  r: 0x901008501010n
}, {
  a: 0x2ddbc7bd1ad38c8f89cbc9387860b80857f66cbfn,
  b: 0x9c89b959886a7183cc5432f295131e13fb4fbb2b5997n,
  r: 0x2959802810838c0400c281101800b80813224897n
}, {
  a: 0xa33a0d813acce14e5ea96d264ba6d26fca3b168aaf0ba19472caf098c8f4b96553a4n,
  b: -0xa84476053d4d41b5207eaa1e8c6f47bf6ec110eb6ecf7fbb4a042n,
  r: 0xa33a0d813acce1445aa80d240b22c02dc8111602290b800012caf0080000004153a4n
}, {
  a: 0xd18n,
  b: -0x4fb6f48c82c34d3ad7c3242d3426180fe74f55910936677f22en,
  r: 0xd10n
}, {
  a: -0x19d746a7a3a91f0ff8ce567ace47bf78b38318bc4f526105n,
  b: -0x5ebc94c4fd7f26c73f521bb46ee276e0dd39ae864d3adc1c042f5e0n,
  r: -0x5ebc94c5fd7f6eff3fd3fbffeee777ecfd7bff8f7d3bdfdcf52f5e0n
}, {
  a: -0xd0c0e49fd1113668837663ac5eb98ebadf44f30f66d57e51e06f09ba9d2ffe3ed6a06n,
  b: 0n,
  r: 0n
}, {
  a: -0xf92eb46bb55fc503n,
  b: -0x7689n,
  r: -0xf92eb46bb55ff78bn
}, {
  a: 0xeb06cc04ae8da679a64033030a0febd2n,
  b: 0xc699a423970169e349932930e5f4487b036n,
  r: 0x8a020800068c2419220002030007a012n
}, {
  a: -0xa1e6fc16e27332574d8efed4e999a0c8b176435d23941f29cda8a4b0360030n,
  b: -0x24718e89d0709b33a212fd7a1967ffe05b538f1dc7eden,
  r: -0xa1e6fc16e27332574fcffefcfd9fa9fbbb776fdfa3967fffcdbdbcf1fe7f00n
}, {
  a: -0xa4bfbd3fc2fa659a2fa39a55b0bd1b0cef5cc44e1a344d621c291ad28bebf5bn,
  b: -0x32cf76b90n,
  r: -0xa4bfbd3fc2fa659a2fa39a55b0bd1b0cef5cc44e1a344d621c291af2cffffe0n
}, {
  a: 0xab4d09607fa70dceb0648b5362cf55n,
  b: 0xcfcd3c38633a0688cccf2d8413a63e487b1a0c997e02c371d8769545a01n,
  r: 0xa00501204987000c30048341404a01n
}, {
  a: -0xcb51n,
  b: -0xe352c465ce4080a8b172778674576a9ae928ad668fade2d605en,
  r: -0xe352c465ce4080a8b172778674576a9ae928ad668fade2deb5en
}, {
  a: -0xb5121be4a16ae9ca3241f3ec1862c6b521a4an,
  b: 0x2f95ad5a55d3b1374f09dn,
  r: 0xd940c12459131024e094n
}, {
  a: -0x8328609cfd847ab1caaac219ea1fb89927c4d1ccedcn,
  b: -0x75c527b5cfa1427f2920a46907c65cbf3d12057b50n,
  r: -0x877c72fffdfe7eb7fabaca5ffa7ffddbf7d5f1dffe0n
}, {
  a: -0x6b823bd7n,
  b: 0x121777d031506d04a65f7c33275dn,
  r: 0x121777d031506d04a65f14310409n
}, {
  a: -0x9d5bea37ecfbf6cdf3a0f8323n,
  b: -0xcd621f477c37190d0a6a8af6cf7c6a12n,
  r: -0xcd621f4ffdbfbb7fcfffeeffff7feb34n
}, {
  a: -0x7f338504e9ben,
  b: -0x6405e2a9862e7ff32n,
  r: -0x6405e7fbbe7e7ffben
}, {
  a: -0x39e483d03c661f39237c440b84930f2850e922859e432ff4ef123f6225n,
  b: 0x9be948901645cf4457n,
  r: 0x1a840001045c00453n
}, {
  a: -0x91e2fn,
  b: -0x5e4ec8baf63355feaac2e8914a0dbfb380a46be2101db657f1ea73d5ce969796d61c0bn,
  r: -0x5e4ec8baf63355feaac2e8914a0dbfb380a46be2101db657f1ea73d5ce969796df1e2fn
}, {
  a: -0xd71fde08n,
  b: 0xa6bc517027310574afa13b648a5437f2cb771n,
  r: 0xa6bc517027310574afa13b648a54328202170n
}, {
  a: -0x88393ae77a4c5f095b24c9fb741fe14b63362349n,
  b: 0x4449631e588b9d6028c27367n,
  r: 0x449220408801c2008c05027n
}, {
  a: -0xca6eef4cdcf964721c579db61efccn,
  b: -0x419fc43n,
  r: -0xca6eef4cdcf964721c579df79ffccn
}, {
  a: -0xcaec2d3n,
  b: -0x78155e7c72f470ced0a66a879d6e6245bf1cn,
  r: -0x78155e7c72f470ced0a66a879d6e6eefffdcn
}, {
  a: -0x8ff0206cdb85330227a0a6c2dfe7f8cn,
  b: -0x855b20f0bba1b7f12e3fe77497cc42536655caf34b3da5ee15n,
  r: -0x855b20f0bba1b7f12e3fff7697cdfa537677fafb6f3dffffa0n
}, {
  a: -0x54ad947f1f705b5e886aaae7d6b07b2080ac7e2f5926f092fa953n,
  b: 0x8af97c949f15771ff56c4353e9bc39925cd5356b8308fan,
  r: 0xa0878001711551180044041e1b43810084510628000a8n
}, {
  a: 0xf9849d16488021ede2n,
  b: -0x54021542660ad9337699245c7f276350814a2048cf99b688d86635n,
  r: 0xd984100648002189c2n
}, {
  a: 0x68b208fee8d32c676434b8dde3ac21d4f446n,
  b: 0x45a0621n,
  r: 0x500400n
}, {
  a: -0x4e5896d53f061cb982dn,
  b: -0xadcf3a1d94baan,
  r: -0x4e5896fdff3e1dbdbaen
}, {
  a: -0x7fa4cc58a41cdd941b06e1c6a9c156cdd2999f08205be42909n,
  b: -0xc40c8c1n,
  r: -0x7fa4cc58a41cdd941b06e1c6a9c156cdd2999f08205fe4e9c9n
}, {
  a: 0x74bacaa8d6c3b46f4bban,
  b: -0x233bb5ff22ef63ef4d31b8223n,
  r: 0x2008c008c00324644998n
}, {
  a: -0x17ae050658657a217441db5475acb6634431b8de6aace9n,
  b: -0xfc6f78319bd64ac73n,
  r: -0x17ae050658657a217441db5475acbfe7f7b3b9ff6eacfbn
}, {
  a: -0xc149c8e102f7b7c5f565410046f1212de120fdcb73c45n,
  b: 0x5f7e711d3e59aaee2691fd884n,
  r: 0x1e7e310c1e500ace02108c080n
}, {
  a: -0x36af11b86f2b069b59f04014n,
  b: 0x727bd9273900ae115a3aa42aeb791576841f4cn,
  r: 0x727bd9273900ae01502a0400c0790426041f4cn
}, {
  a: 0x2a2bb16a069cc35ffa00fdb2cfba00f91b2c8b80aa9a7eefd79b9805567c2en,
  b: 0xc6cc9n,
  r: 0x46c08n
}, {
  a: -0x9c488d71cbb6b6b922d905add45b74036f1da6a15131d3dd0n,
  b: -0xd27c47ea02d8cn,
  r: -0x9c488d71cbb6b6b922d905add45b74036f1df6fd57fbd3dd0n
}, {
  a: 0x103fb85f509d915e0f0125834af3448945f160a41c96a4d8an,
  b: 0xec4c6c1dc43c8953adba2cf8565f9782dn,
  r: 0xc0024014030000105b020a0141684808n
}, {
  a: 0x9cc1d156662d0d5c0f0262936b25n,
  b: -0x63fd26ca1dbdf2n,
  r: 0x9cc1d156662d0d1c020020824204n
}, {
  a: 0xe380b147734n,
  b: 0xbd991e880ae076553de5936677b5f8d025d052e8f74fb32283568c141an,
  r: 0x20002041410n
}, {
  a: 0x996f290d7943b5c64315b068fc93eb79b5df7ebd65ef41c23e165f959b5n,
  b: -0x8785fcb008644e41454edf4n,
  r: 0x996f290d7943b5c64315b068fc93eb79b5df7838014f418230161a91004n
}, {
  a: -0xf5n,
  b: -0x509c7dac3c531a09441n,
  r: -0x509c7dac3c531a094f5n
}, {
  a: -0x4ea28d9239b04c1d84fd0e8ca0844c266a81288a1de1e98322ef51ed0221d55fdd2an,
  b: 0xb00503e023ef5fbc2317n,
  r: 0x9000020021ce0aa02216n
}, {
  a: 0n,
  b: 0x36a05a8c842d9e36bbd65f4b8ed899bn,
  r: 0n
}, {
  a: -0x2b5b624cc761d794d57fa3456735c3e8fccc325a10a5271869274efn,
  b: -0xe4af2b33a72dcdaf31a5069921017e7d67e5bc2fb094cd842363063b1e1422bfan,
  r: -0xe4af2b33a72fdfef7de767dfb5d57fff67e7bdeff8fccdb67b73a73f1e7d28000n
}, {
  a: 0x69ee6fadn,
  b: 0x42974e7c7f7b33n,
  r: 0x686e6b21n
}, {
  a: -0x2fc9dd07f631305d8678bffef42b3n,
  b: -0xe997ec7cb1ec1683176280e3cbc6058234db7c646ae069ca5n,
  r: -0xe997ec7cb1ec16831762afebdfc7f7b334dffe7cfffefdeb7n
}, {
  a: 0xc124ce64160c4ab24b086c2089edeffcd3a9774d573290732933cd084d884c6758en,
  b: -0x84afff64c9f28bfafd733aa8d1de73c92n,
  r: 0xc124ce64160c4ab24b086c2089edeffcd32950001332007001028c004508000410en
}, {
  a: 0x31d49f9ef0b8f1e42f15fc1419b76cbb62c0a3bb7263044bc2ec0n,
  b: 0xe183e525df98b0bcfc33de0522c9ea04bc09320b195a774n,
  r: 0x8080a021c40810bc141196042240c000b80022000942640n
}, {
  a: 0x9ac95d010c83bbd9dacc5dfd929ae2625fc3346n,
  b: -0xb06ee85bf26d4ec798n,
  r: 0x9ac95d010c83bbd9dacc54f9101a40400b03040n
}, {
  a: 0xdbca72c9f533e870cef0b766edd54c2446590ddb4f2d4179ff4270bn,
  b: 0x22d6b2d71399dca8bcdb4d04d34de7776b8a5fbb0a0df5c246def162n,
  r: 0x94a20413111c800ccb0904424d4442400010990000d40206d42102n
}, {
  a: 0x8922562ad112bcb0862786719efabn,
  b: 0x4e38n,
  r: 0x4e28n
}, {
  a: -0x77f380e931742cd5eed70727ef2ca3394a9beb4657268886a02cec4e9a31e6153cf0an,
  b: -0xdc2eb229fdb168f0e0ad176b220427349b9ab7f02df14365en,
  r: -0x77f380e931742cd5eed7df2fff2dffb96afbebef576faa86a73cffdebff1eff57ff5en
}, {
  a: 0x52d7de77b92e089a0an,
  b: 0x40a56een,
  r: 0x408120an
}, {
  a: -0xb693de3803e850ce197273d4511n,
  b: 0n,
  r: 0n
}, {
  a: -0xdf329d5afdeb8c5b0df49c8fdn,
  b: 0xf046cd49fb6847a831bafd6e6206a72e0eb37377ac6006a1c9en,
  r: 0xf046cd49fb6847a831bafd6e6200852204021073a4600221402n
}, {
  a: 0x4c7d231b9644e4faabd0cb89645d09e08b05d3e80a24404d1e161n,
  b: -0x3b3a4672a1e20a6fe8ae4c03d9fa9fbe23ab2833390a6c4aefa1588fc4de5n,
  r: 0x4c1d21101640a0f822004001445401c0820593a0000400401a001n
}, {
  a: 0x8efn,
  b: 0x14ddfae746dfddc1e53c5f634e925464427fe10917f5f9311a4734a37d94b05n,
  r: 0x805n
}, {
  a: 0x2e5fd8b098455c72d834dn,
  b: -0x47de1bdd04429d9d918c00007c3a79c7576591be6b6741n,
  r: 0x2c584080880444104800dn
}, {
  a: 0xc8cd293501813d89af2n,
  b: -0x6e2a2337f6825e81be45fde0b00e8dc76861446f079n,
  r: 0x48c1203001803980a82n
}, {
  a: -0x1b884ce09b7705e18d606n,
  b: 0xac1552a847n,
  r: 0x8c01422842n
}, {
  a: -0xeb94d001e7d860b93289d18cn,
  b: 0x3d65cfa9314a02n,
  r: 0x25054689300a00n
}, {
  a: -0xc21238dbn,
  b: -0x912fc6eb93ddeef01136431c19a6c52dd603dbn,
  r: -0x912fc6eb93ddeef01136431c19a6c5efd63bdbn
}, {
  a: 0x557d63457b973ea6d48490f885ed10a604c3603baac5e512c8n,
  b: -0x43cf4613731555a678d12be9d70751f9fb926893814b29dda7n,
  r: 0x1430214408822a008404901000e80006044100282a84c40248n
}, {
  a: -0xe6640608ac0708e7d85555d0b8cf0efe2a642ae8ec618091d274989e4bn,
  b: -0x9baan,
  r: -0xe6640608ac0708e7d85555d0b8cf0efe2a642ae8ec618091d274989fecn
}, {
  a: 0x21db26f5d2f2a5917n,
  b: 0x9863a6b9892a3a0bn,
  r: 0x18222619092a1803n
}, {
  a: -0xc8033fa1e2b09e7c81b15505aa3fab29aebn,
  b: 0x400a465014470f707cn,
  r: 0x400a060014050d6014n
}, {
  a: -0x6694d4918b20db011ae65bdc2acdce7b666967709c5dbcn,
  b: -0x38ca0852848acea27ed8420n,
  r: -0x6694d4918b20db011ae65bdfaeedcf7b6eedef77fdddc0n
}, {
  a: -0xb8b80075764ab00418adaa3747c7e9d8383e84f9bad19fdcd3bn,
  b: -0x19dff1399a7859ee579dd431af671f2360723d3293d10793c4101e206193c42f92n,
  r: -0x19dff1399a7859efdf9dd777efef1f63eafabf76ffff9f93c7f85fbbed9bfdefbcn
}, {
  a: -0xb35d43802ecf13e8c0d3aad60e020a0a2d32n,
  b: -0x8d89c4100ff04926f350acf1c4c2679768d3n,
  r: -0xbfddc7902fff5beef3d3aef7cec26f9f6df4n
}, {
  a: -0x2abe60be6ee377b32a39d482a567n,
  b: -0xb9bc4e1745378n,
  r: -0x2abe60be6ee377bbbbfdf5f6f778n
}, {
  a: -0xc02f6df7dbcd2c698fn,
  b: 0x88d02b9c3n,
  r: 0x29041n
}, {
  a: 0x7cec4f90ae694b2e0594ecd932ddea945ee0n,
  b: -0xfa693006ea9b776288c95bdb10ea761ad418c330cb424db82bn,
  r: 0x1c640680246901080500e4180214a89046c0n
}, {
  a: 0xa01d01e270de01b1c59fcc63981fe4e8n,
  b: -0x1875e4906cc211n,
  r: 0xa01d01e270de01b1c5878803081324e8n
}, {
  a: 0x16995bdfe960n,
  b: 0x1a4305f66ed8cd7bb1b61dab04af9824b29n,
  r: 0x100859824920n
}, {
  a: -0xa543f7n,
  b: -0x8b1f25914e656caa1a4889ab22bdn,
  r: -0x8b1f25914e656caa1a4889af63ffn
}, {
  a: -0xd6660b787946ed682d41a345bea9b479a3b7e47678f8d3f0361588da34189en,
  b: 0xe2b530n,
  r: 0xc2a520n
}, {
  a: -0x4c74cc744142dba5d43568ebn,
  b: -0xbb2ff8023d8n,
  r: -0x4c74cc744142dbb7ffb56c00n
}, {
  a: -0x475dafc6533cf7d0280adda35b4371a7baed79625516b21f2a33028d318f54n,
  b: -0xc8c5f3870a9c72eb37303n,
  r: -0x475dafc6533cf7d0280adda35b4371a7baed79625d9eff3f7abbc7afb3ff54n
}, {
  a: -0x22n,
  b: -0xe39f4b8413bc78ec518a5f124eced32d2872e0bdd2cn,
  r: -0xe39f4b8413bc78ec518a5f124eced32d2872e0bdd2cn
}, {
  a: 0xdfbdb9d11c391c92dcd9c54fc55b6778d4a820c979n,
  b: 0xe231ad9ad3c7f950059966527836533680094bc3d1e3d43f6bf99ed4a11n,
  r: 0x59942101002110000090840d041943709488204811n
}, {
  a: 0x4e63c7a80cc799acb8dda4ded541137906ec2cf283cdc5ebn,
  b: 0x8e9a9f5c4b9fb6739e12a78907f879bfn,
  r: 0x8898845c410112710600248003c841abn
}, {
  a: -0xc7029fa7c6be9c5dc7f66399eab0082c62138ebb40e3b07255b52f6c64485adn,
  b: -0x3cfe7d123e3dce975c5af25a9f3ddfdn,
  r: -0xc7029fa7c6be9c5dc7f66399eab0082c7effffbb7efffef75dffff7eff7ddfdn
}, {
  a: -0xab5738an,
  b: 0xb61a0a3869a0c241211bc75df7c95c80n,
  r: 0xb61a0a3869a0c241211bc75df5480c00n
}, {
  a: 0xf409d90b44e6d923b4e33efd0d6d66n,
  b: 0x6n,
  r: 0x6n
}, {
  a: -0x98b108680ae3b7382feb1f69502b7d2410dn,
  b: -0x89e9c4a40n,
  r: -0x98b108680ae3b7382feb1f6950abfde4b40n
}, {
  a: 0x3n,
  b: -0x1c0320739f179e91ad55badedfd6520cf341b38b62a001230n,
  r: 0n
}, {
  a: -0x7ddb5322586847e213eca93e79853e3cb1d604345e87395cfd61fd65279c507n,
  b: 0xf7714749a478dc474dc33bcbd84c3d745127e1aeaa5a13e0de893b93a46bf5ae5n,
  r: 0xf7000408842094000dc01342c0043840410621aa8a0010c082001a02804861ae1n
}, {
  a: -0x1c54743b2be3d9f31e6a45f8b131bc43b63b64dba0a8ab2b3101n,
  b: -0xaf17408e0f78f9cdn,
  r: -0x1c54743b2be3d9f31e6a45f8b131bc43b63befdfe0aeaf7bf9cdn
}, {
  a: -0x32feccce8fdc3ad474051ea44521d980b1870n,
  b: 0xae8f48c73dfc0e5fd973c92919d0871e4f40f667faf2cf1acdan,
  r: 0xae8f48c73dfc0e4d0133012001c0030a4a405222da224f0a490n
}, {
  a: -0x562cfac19d88030c9f0f28e353ff6de61306dd74196b20bb7b4n,
  b: -0x17c5b5d112048f311c5a9c23353e8n,
  r: -0x562cfac19d88030c9f0f28f7d7fffdf6178ffd7c5bff23bf7f8n
}, {
  a: 0x91583cfc7bac82a2084f2aa0d94b0fade32c1fad9a5c3n,
  b: -0xb6f51dba9732e993685e6c643a6b7e5b0b161f4f640686c99cn,
  r: 0x500cd062880200080c0800184b0e8c03081f8592440n
}, {
  a: 0x7fc25b15e640f2443f3n,
  b: -0x93e664d50656576531dcbfn,
  r: 0x19820b108200a040341n
}, {
  a: 0x73c8fcd3d8de46615328n,
  b: -0x20375a8ed9d7128a554ae959a37e2d226bfa6c3951618a33b9a4ca5an,
  r: 0x13c0ac9250cc46411120n
}, {
  a: 0x167e75d4cd2b6e0084f95057ec5e6bed5002fdd483c384e3545449bc723n,
  b: -0x2ec45018c7f6987d45e49201b2b654e01e1f15002450a21ec056b6e172a4db573n,
  r: 0x6380144802a0a00844940030c4060e85002ad548103804114044924201n
}, {
  a: -0x2c4b104751n,
  b: -0x492f1811n,
  r: -0x2c4b3f5f51n
}, {
  a: -0xfa2137585d087fd743adaaec72f5dd7592n,
  b: -0x89n,
  r: -0xfa2137585d087fd743adaaec72f5dd759an
}, {
  a: 0xee64cdba60af0015f3e746baa60802a585d1b3n,
  b: -0x861b895c8381e118d6n,
  r: 0xee64cdba60af0015f3e740a02600002404c122n
}, {
  a: 0x1d596ec3e9f7bcd7cn,
  b: -0x765f37a865b77415b257bb8d2ea1600a06a9a52ad6524f6e9n,
  r: 0x19504ac129a5b0914n
}, {
  a: -0x7a628938b692b908765f1ecac9d73127a92302f0f61c50b5f6e05n,
  b: 0x443f21n,
  r: 0x1121n
}, {
  a: 0xad75b3bee9f2c8422f28822c0bdc8n,
  b: 0xbb551a19dd19e0241c0b09135264549e07d6bf9ba62f1693d45n,
  r: 0x15020148802c0020b20020403d40n
}, {
  a: 0x304a7777bc413f863cd9e9cad82a536ae381bfb9967b66dbee614dn,
  b: 0xef566ac3fec7b4de2bfa63cba23b8a32802ecn,
  r: 0xcd1608818285348e281a6389223208328004cn
}, {
  a: 0x7d9cdb27e7ee5013baa818fc67c625b68n,
  b: 0x74a9a3c89n,
  r: 0x648021808n
}, {
  a: 0x8ef7da29c83953dac0f1e45fdc32c5c8cc7bf9e25f94711f97ef567560n,
  b: 0xe81f674944ba1787253011f80bb7an,
  r: 0x480c470904201107013010f003160n
}, {
  a: -0x20f882ea6b0552a993506c5799c1e3f069d438a7d56b8ed981e1fbcf29dc543bee2fedn,
  b: 0xfaaaa38ce293e6aa3346n,
  r: 0x1a0020842283c4001002n
}, {
  a: 0xfcaffdn,
  b: 0xca56cb54f7n,
  r: 0xc804f5n
}, {
  a: 0xceb327516bdf7f6dde15946d510d4817e7cb812been,
  b: 0x37d5a4fe626ef74c1dfaffd055f392f79040969bf0384c318n,
  r: 0xc622275041df2f6d0415102d51040801a703800308n
}, {
  a: 0xf966da844643bc8ee97f8d4241n,
  b: -0xcd3136a813baf6317454c85482e403d8d6ec31aa1en,
  r: 0x892212804403bc0629138c4040n
}, {
  a: -0xd9n,
  b: 0xd64n,
  r: 0xd24n
}, {
  a: 0xc5ff69dddacf786ce52a9fbca228ed3c53d314c07f4741e3d74d46d9fc42ccn,
  b: -0xfe38ec54e0cfc324179c6b3e44a93f32c4bc03ba38e5fb4cd1fn,
  r: 0xc5ff69dddac018602020930080288438401314400c430023c44c40804802c0n
}, {
  a: 0xa1e13d9de4cbbb9bbd5cn,
  b: -0x78b362ddefbaf94e4f020fbaf9n,
  r: 0x20000504a080b9900504n
}, {
  a: 0x1a5fe830477806dce2d6b95d0ffd88d7873aaf46e7c653b9a70d91b2n,
  b: 0x73058196f002ee938ef9b9527f06cd8c6198n,
  r: 0x31050194800286128e40a1425300850c0190n
}, {
  a: -0x2780f41c3bdcce42282335c085ad890fd346d93dc68ebee8bn,
  b: -0x9978af014042edacd14fn,
  r: -0x2780f41c3bdcce42282335c085ad899fdbf6dd3deedefffcfn
}, {
  a: 0x86767af9336da36490ab661c6e587ab83d7a658d32711e069d13d27fn,
  b: 0xca4cdc1d6fdb2d8689bf5097a8dfeb253a165b49c0c4523an,
  r: 0x24c8004008b240408185090285a610532101a008000523an
}, {
  a: -0x209c10ebd0e0cn,
  b: 0xff32c9e72bfd28f5cb987cf44c028d64c8an,
  r: 0xff32c9e72bfd28f5cb987cd440020424080n
}, {
  a: -0x40c46d80f52f77b1f42746c0b156d2b655114c8b55e0b1b97e62315c613a724d0n,
  b: -0x34dbb6a3821e4fee9d53ef7a95834320ee1a6n,
  r: -0x40c46d80f52f77b1f42746c0b156f6fff7b3ce9f5feebdfbff7ab5df633afe5f0n
}, {
  a: 0xf8935a3d2fcac511b6bn,
  b: -0xf31c01b3e9c036e4n,
  r: 0xf8904a3d24c04110908n
}, {
  a: 0x97502c6n,
  b: 0xe95ceef498n,
  r: 0x8640080n
}, {
  a: -0xfe843fd5b6c40e4d79cde2c27a2d402246d16efd9db84f4f7a7de4n,
  b: -0x3a87072e0da8157257a73d36157c053ccn,
  r: -0xfe843fd5b6c40e4d79cde3ea7a7fe0fac7d76ffffffb6f5ffa7fecn
}, {
  a: 0x5c14378873bc160d7c2b5f21n,
  b: -0xd95fdc28e7b4a49cf613a5eacdadf2a0dcf34n,
  r: 0x141016802110040054221000n
}, {
  a: 0x574eb35aaaa1959280195e387d70n,
  b: 0x83b063a30d3ad0ff87d9n,
  r: 0x82a00182001850380550n
}, {
  a: -0xf459c18519545a445a054ed529efb1b91aen,
  b: 0x4aac55a5b2d6f1b37d1672c1c51f64ed629f787c62e090c6dn,
  r: 0x4aac55a5b2d6f103241672c0810520a562912854004000c40n
}, {
  a: 0n,
  b: 0xe3dca93eac24a01f1bd655b7741f7005b8e2en,
  r: 0n
}, {
  a: 0x69abaf04a8d5834927e812fbad909d2b01f025636f65b196n,
  b: -0xd95a9e0eef85be4a2d49c5da7690246a1929n,
  r: 0x69abaf04a8d5020121e0107a01909022002001634b05a096n
}, {
  a: -0xa28e12ebe4c4dcc5332e84662a4b62226145103b0c44a06092f9bcfn,
  b: 0x67925d76e8ba32n,
  r: 0x23905976c02030n
}, {
  a: -0x69de9375d61d1f9b8a5676d430aaa2dc47926e9a5c6fa47n,
  b: 0x9003dc779a9241c5c763a7b6631874e1ebf6n,
  r: 0x24452989200c5454223864110502101b0n
}, {
  a: 0xbed720839b03578f574b892bd94e88f10e02ed0en,
  b: -0x1b896b6b74ba2fd2dbeb7615b4fc7fe90a0694ec98b5bca8612b07b408525n,
  r: 0x9e8420000103578611020020114888410402680an
}, {
  a: 0x398e97d5369e9c392e0e9n,
  b: 0x4d5fa24e027513f7b8985a3d382d3016e7f18aef8afb40895519c4d0144bde7n,
  r: 0x39008155108490100a0e1n
}, {
  a: -0x1a5990b6cc0a0b6138fad77a2b256890e93f665an,
  b: -0x4831ea63155cb0fd2fd94572f695c461b188f1bacn,
  r: -0x49b5fb6b7ddcb0ff3fdfed77f6b7d6e9bf9bf7ffcn
}, {
  a: 0x8c10f1dn,
  b: 0x8f6c8d542e3f339cbf63b969abac85607bdcfe044bd9d6e23668b73404853ec514n,
  r: 0x514n
}, {
  a: 0x5d60bc706809b36f883fe5fee2f3a7f0df8d49d90fd1002364ba386b868c8cn,
  b: 0x1f0f85082a12c0420068e77bf9525a6ed5952c365d60n,
  r: 0x1f0584002202c0420048c10bd1000264901028060c00n
}, {
  a: -0x533fa0e36e870e5726084d0b8385fa8f5d3ea7801b224b00d026caa1bn,
  b: 0x66aba1edcade3d2455852722decf60cn,
  r: 0x620120a0c0583d2455842722d805404n
}, {
  a: -0xf724e9c9d67e0026f448c9c05a83944875874fa6n,
  b: -0xc2639a378537add7b062787f323bd172635669174383d07ef7df755a4d8066n,
  r: -0xc2639a378537add7b06278ff36fbd9f67f566ff74bcbd07ef7df7d7fcfcfe6n
}, {
  a: 0xf33fa7564f8668e645963d265139d137e6f57cd5bd17a659cn,
  b: 0xacf290n,
  r: 0x286090n
}, {
  a: 0xab7b527bca6c97d19e9bn,
  b: 0x6f71e4313eaf956f9ee43594eada1f3be5939bb7b3eb95a613342e0974an,
  r: 0x2b3a105a402002c0960an
}, {
  a: 0x9696629434cb12468e9bfee95106e36b17bn,
  b: 0xf9c1b71818c6e1348a603n,
  r: 0x40809318084000200a003n
}, {
  a: 0x1a2af51d75260137223aaadd45aca933aa8da216bc8e012fbcf12efn,
  b: 0xe63a507df0a231a7a12f4b516226210an,
  r: 0xc41a401130a01021210840106206000an
}, {
  a: -0x21adf669719e4n,
  b: 0x6dc01190f7044abn,
  r: 0x6dc010009604408n
}, {
  a: -0xc286502272034n,
  b: -0xd49ce7c6098f45aa71ab26293febdb7a5bn,
  r: -0xd49ce7c6098f45aa71ab2e297febff7a7cn
}, {
  a: -0xa2878a35d65e7c5cdc7c5933f4bb495de863b414713d7b7833e6fan,
  b: 0xe185c0579bdb6ff55a4f57b5dd1cc2ed6694fa1d91n,
  r: 0x8181000382c80b4412021794490882c00484c81900n
}, {
  a: 0xd96b27c4bda5a68699a500492424ba5bcc298581381458eda35bn,
  b: 0x60ac4ef16cd4428a7be8eeae10df63cb5ae2414fn,
  r: 0x208408a1004000003a48cc280081200058e0014bn
}, {
  a: -0x8a1045a5c3fc6a2d7172f8fn,
  b: 0x77c8f1e03an,
  r: 0x5508e0c030n
}, {
  a: 0xfbdc6bb6f496229f29b3ec7c023n,
  b: 0xe4fb2693e95879e29b880517n,
  r: 0xc4bb2601600870821a800003n
}, {
  a: 0x651db50192n,
  b: -0x9dd4cfe0143da267b0fbn,
  r: 0x401d900100n
}, {
  a: -0x34326254933e2767816bfa97499a0540d1ec5412fen,
  b: 0xe1d08f329b3fd6en,
  r: 0x418082201a3ed02n
}, {
  a: -0xbb58fd5b9a374930aac07f8a2f0602n,
  b: 0x65c4585a724d4803f6cd20n,
  r: 0x65c0104a500d0001d0c920n
}, {
  a: 0xc28ebdc0e8dba5192n,
  b: -0xda1n,
  r: 0xc28ebdc0e8dba5012n
}, {
  a: -0xfd97e5a686476004044c9ef52550276856d5a7784n,
  b: 0xa50bd485b48f36ff9317f8n,
  r: 0x24008480b4893292810078n
}, {
  a: 0x31bfbd96c803n,
  b: -0x1c5efc96ba7b32a87a00deac4bb79622dd962a40c07726d82532bbefb1b347n,
  r: 0x10410064801n
}, {
  a: 0x55ba24fb8883db4a782079117977f71c820544n,
  b: -0xf288dce674ec846ddddc92c2ccdf103c3602ab3f8af9e4e2c4b318fb0493dn,
  r: 0x513204f80883d148000061115134c610020440n
}, {
  a: -0x8ab277d87c61025967b02e76e5f3en,
  b: -0xef9985dn,
  r: -0x8ab277d87c61025967b02efffdf7en
}, {
  a: -0x21c943578ce29b61273ed70b150837a6f376c1bn,
  b: -0x8a68e26b91797ef5a9b5f243b6n,
  r: -0x21c943578ce29be7af3eff1f97ef7fbfff76fc0n
}, {
  a: -0x347e93e7e0c95333175ca32725e8c9275b986cd274cc60d3a5e26e037cn,
  b: 0x42a1e3c4c364d25b54a6988df323930563ea22f498c9e7154ecda904f198f3a12fddn,
  r: 0x42a1e3c4c34080481006108cc020830440ca0234988067110c892104201811812c84n
}, {
  a: -0x1ae4d87f87b71a544205de99294443a31b59f379f44b8f6f836c806e7en,
  b: 0x2429a5f8d83a541d73dcfefe11f34fcf451fdf3161cbb49a0an,
  r: 0x2008a5a8983a00045298bc5c00a20c86011450106083349002n
}, {
  a: -0x62f301n,
  b: 0xa931ffde5ab0e45d3c33651465ab17bd30f1e2aeen,
  r: 0xa931ffde5ab0e45d3c33651465ab17bd30f1c08een
}, {
  a: 0x1fd0c431d28840a9761f3176b3en,
  b: 0x404719ddfe26f73fefb06f201n,
  r: 0x404411d08800a1360f3066200n
}, {
  a: -0xc6935n,
  b: 0xcae054cn,
  r: 0xca20448n
}, {
  a: -0xdf3f44bb78f159a219f01da2cd90n,
  b: -0x1583a8565f7788ad7a794f3933c71n,
  r: -0x1df3fc5fffff9dbf7bff4ffb3fe00n
}, {
  a: -0x949492507250a39131932e245e1e02cfd7n,
  b: -0xb974e7573aeaca6n,
  r: -0x949492507250a391319bbf6e7f7faeeff8n
}, {
  a: 0xd73edda15c058e35de381n,
  b: 0xb7e2f21a04n,
  r: 0x10e2500200n
}, {
  a: -0xe39b1c4afea026e01e62ed9ee85bcn,
  b: 0x6f188n,
  r: 0x7000n
}, {
  a: 0x44c6d445157ba5dfad323228acac94a0b1a4fdfb8bf622b36c6db2b9an,
  b: -0x3d477cc13n,
  r: 0x44c6d445157ba5dfad323228acac94a0b1a4fdfb8bf622b3402882388n
}, {
  a: -0xa4c6af5b3bf9cce54a02f551b748ee5fd0n,
  b: -0xb19065521bfa884fdd215c5830730b01919efbdf8cd45d5030865102066b390422dcn,
  r: -0xb19065521bfa884fdd215c5830730b0191beffffdffffddcf5ce53f757ff79ee7fe0n
}, {
  a: -0x6cf2a1f669fad41c37b444c4eb273f1n,
  b: 0x112121fda470c3decfda41cce17e2ec0e1ac4c55b2ecc49d1155137b04358b9n,
  r: 0x112121fda470c3decfda41cce17e2ec0810c4c01920400810041133b0410809n
}, {
  a: 0xe425072de346264c76ced51fc13338910c12fd5770334fa071d10an,
  b: 0x7d1a11d4f2a4ea26n,
  r: 0x55101144a020c002n
}, {
  a: -0x28336d28a642c63fce1caacc082076c20f9a04fa62e266f3ce5ff038497en,
  b: 0x768f549b16ff5n,
  r: 0x420a009812680n
}, {
  a: 0xf36350b6dc19c3634938736332ca266170840987ca0ae888f49a68a26c3b9b6bn,
  b: 0x9c70677058e902429427275b1809e8debaec7039b9f3fd1d54e2c6d1n,
  r: 0x9c1043604828024210022641100008868a086008b092680044228241n
}, {
  a: -0x468d55n,
  b: -0xa373e08a5a8f9820ba9ca6c490605n,
  r: -0xa373e08a5a8f9820ba9ca6c4f8f55n
}, {
  a: -0x500d56556c424bfc309bbb0cb04df38b88372038bbf0cbcn,
  b: 0x5741059145679cd3ac1087e4a05cdd381003a8d8e84n,
  r: 0x100019104038c40041007a00054550810030008204n
}, {
  a: 0x9cec2a4090952349d5bcc90en,
  b: -0x1d731e89c641c4996bn,
  r: 0x9cec2a408081220994384004n
}, {
  a: -0xb58b17a9c8c668cc0f85ca8527ef21da27ffb3d2edf9df1n,
  b: -0xec9687b21n,
  r: -0xb58b17a9c8c668cc0f85ca8527ef21da27ffb3feffffff1n
}, {
  a: 0x1eebd319f0f0366b28c22fa856184188a25c1c23en,
  b: -0x1a6533acb3d3802c355f517ef7bdc12d7d6cbac972d4519e1ce384a62n,
  r: 0xaa08201004036420082052004080000a21c1801en
}, {
  a: -0xb1fdf55e685a87cbb1b461a5a1e748ba669d4b5f2631aebc0f6748n,
  b: 0xba2fb6f08ed445ec66fb0fcfb0aeff34584c7ce107962fcc3b6c36a11a35fn,
  r: 0xba2fb6f08000000862530344a0a8e5244008744106020a0c1864142108018n
}, {
  a: 0xc1344da94f934b5699den,
  b: 0x2bcd3951e7db087e56cf85f0fdf74f63dacad2fe9n,
  r: 0x41044d204611080409c8n
}, {
  a: 0x1eb7f153968e46be7d2e86b60c7abcn,
  b: 0xf6561dc421150dadd66an,
  r: 0x86461c442004040c5228n
}, {
  a: -0x4d50e34fe2ab9e720b15c7b0en,
  b: 0x4b193939235f50ba69aa3def47bfn,
  r: 0x4b19283103015002088a0ca304b2n
}, {
  a: -0x384664d0c257c8add89b76b7c78964104d194can,
  b: 0x1677f04caa3fb471a6acc167dee4975e4e364538f2949b4709fc7dcn,
  r: 0x1677f04caa3fb47186a881271ca017520624010830149b4700e4314n
}, {
  a: 0x272cb600n,
  b: -0xa72796769fb8017076n,
  r: 0x72c8600n
}, {
  a: -0x382e14052c4n,
  b: -0x151c467e242f31dfe0e4a723dd63578295n,
  r: -0x151c467e242f31dfe0e4a723dfe357d2d8n
}, {
  a: 0xee5df728efbbbbfb9fcn,
  b: 0x7420e12an,
  r: 0x3020a128n
}, {
  a: -0x260156897425c9d37b9f32e576n,
  b: 0xd3d89eeb674690d9a423e1d9ea5a9ean,
  r: 0xd3d89c8b62060099a022c040085088an
}, {
  a: 0x2dae1eecab7bb5c1c3b71f1f562405ceb66579089a7f95c5an,
  b: 0xec76dfbadcaac9e182acn,
  r: 0x4c624612908881e10008n
}, {
  a: 0xe37c4186e2f4ba2b8770b87cbfecbn,
  b: 0xb802c6e8e1e68266aa2a5f3469852e7482ab05bdf307n,
  r: 0x62200182429012230020b0589f203n
}, {
  a: 0x6a4c554bed0e8e797075d5a25564bn,
  b: -0x74n,
  r: 0x6a4c554bed0e8e797075d5a255608n
}, {
  a: 0xb2c716c8cc435406765e6a36e8b44276e07beb65a4n,
  b: 0xc6eb4f767n,
  r: 0x6aa06524n
}, {
  a: 0xe397201d695f3n,
  b: -0x7a78bf16afd0c95580cdf4efc14ba1709a62440a0e51c2cfe3e8en,
  r: 0xe186201008172n
}, {
  a: -0x8177837cc6c2a85e875fn,
  b: 0xedc03142a3c092635cdfae68795a1fecn,
  r: 0xedc03142a3c012005c832828510018a0n
}, {
  a: 0x7cba727961dc11b806000c093f8n,
  b: -0xbc88cn,
  r: 0x7cba727961dc11b806000c01370n
}, {
  a: -0x24273f269c8b7a104a75291a59f74af134c1ebb6ddacac33n,
  b: -0x62bb5b591ab48f2e6f3535b44daa11510d96b6256acfe735b881384aa535f9045n,
  r: -0x62bb5b591ab48f2e6f7777f66deab7f10db7f6b5efdff7bfbbcd3efbedfffbc77n
}, {
  a: 0xd476c9267f0fa74f664a4bfe5dd5c445d3b65920b85b58e77d2b4b5b3dffbn,
  b: 0xcad47657e391c97n,
  r: 0xc25422434311c93n
}, {
  a: 0xe6c883b589aef8402e263ac9980799407n,
  b: -0x8d0ee4f6d710c8a251a4040e1d778508cccd6n,
  r: 0x20800a5010ca8402a202288180711002n
}, {
  a: 0x3cb35fd3595a0634eeaebabn,
  b: 0x5d8771ed6677f55a21827f5dn,
  r: 0x18331ed2415a04200826b09n
}, {
  a: -0x913978e56487d1a7f4fa381df43f9dd0c8ff8a37108bn,
  b: 0xe2fe24e4dd5b29248cd76b657be38fc8n,
  r: 0x22580004c54209000007230071c08f40n
}, {
  a: -0x5134ad8d36c29b382ff0999046bdd04ca2dd2f094c26b08175074b1a1dfe19012df705n,
  b: 0xa5fbedf1509685310c806a0b6ef9ccbada8e0501d65f1acd254fn,
  r: 0x5626db1400681110080620348494c8ad884050000461ac0004bn
}, {
  a: -0x73baee5454ecc939da09e386f446040e794906e38abd363a4efca2dan,
  b: 0xd999e18b74ef4f5e8f42d818f72e18a73f1955c2ec46e2d0e2ff29ea2aa2cn,
  r: 0xd999e080500a0a1003404018610610a31f1910426c00c250209c090020824n
}, {
  a: 0xd23c40e8aa82e8f89cf73521638c2b497a9d52be5bb21a08f30d8en,
  b: 0xebccn,
  r: 0x98cn
}, {
  a: -0x802e31ff3343ffc90dfe5391n,
  b: -0x915039ffeec3667d9b36d84ed951f2e4abaa563a9e4db6f625n,
  r: -0x915039ffeec3667d9b36d84ed9d1fef5ffbb57ffdf4dfef7b5n
}, {
  a: 0x97053ac44780a1910b0b2597725105ff3cbea5ae061d11e8efd0e5n,
  b: 0x92c3892ba84995dff1ca9d7794c57ae3cbaf60937085f1f4d43bb933ea12ad268211n,
  r: 0x97010a8447808110030b2500125005f1349421a8020810a8268001n
}, {
  a: 0xf544ffe02c3c9a01f5c0d6cd3701ddb7b02f64f2656066c165f316e347dn,
  b: -0x2f57c86367en,
  r: 0xf544ffe02c3c9a01f5c0d6cd3701ddb7b02f64f2656066c140a01680000n
}, {
  a: 0xf4fn,
  b: 0xd92d43914d03fb908a490d06fb6e95c74cfb1bab81a40b4c90b7518ac8n,
  r: 0xa48n
}, {
  a: -0x7cb52eccn,
  b: -0x91a955214736b2926998e0bcc34fda2954fb343d26n,
  r: -0x91a955214736b2926998e0bcc34fda2954ffb53ff0n
}, {
  a: 0x80ad59ab76059fn,
  b: -0xab29a7f37f6c1d5f543f2e6d8e9474bf9934d4684f8dd809e3d70c64dc26e60adn,
  r: 0x80291029100513n
}, {
  a: -0xdff902406a8c07f9016cb0dad8d05f9e9913e89af9f5a7b0efc99ca16n,
  b: 0x11dbf61092f8ddfbe8f317n,
  r: 0x15250008080d103603102n
}, {
  a: 0x899e1514b452n,
  b: 0xaa0b552e70f80448a8fff6c5928d286f37c93f13f8276724963e13an,
  r: 0x120100a012n
}, {
  a: 0xcb1c7d42ce74edfa70603b9d73d50e73a9163df63a51b80dd9b7810n,
  b: 0xa6f420eb4f66c850df3fe2b803064fd99d0af9ce88703a2a5c5d867aa89c7n,
  r: 0xcb0c644040542de23000020d51950a71880030322a50180458a0800n
}, {
  a: -0xa2f20e4bb6dd15313381cb4c3ae467ec3n,
  b: -0x76abc9ba832ca93f511f2f8eff041082e8bn,
  r: -0x76abfbbecbbefd3f713fafcfff3ef4e7ecbn
}, {
  a: 0x791f2295c5e9158ea1de06f4915de793a7e94498dn,
  b: -0xae9dc4612c1475b9b141d226ee5a1n,
  r: 0x791f2295c5e91102219e02e08044469225c90080dn
}, {
  a: 0x272fe29299c4bd1aa0a47bb52fef44eff7d6bcc7106f942e02e74b6d9f5bebe02n,
  b: -0x7275ca805c0d485280a9d1b2f90d427df94ae33e8a858f3acefeb52bfe6n,
  r: 0x272fe28088043d02a0a42935062e4406f2948006100c802402604121014ac0002n
}, {
  a: 0x90af149c701a1n,
  b: 0x8a83n,
  r: 0x81n
}, {
  a: 0x9703378364n,
  b: -0x5c379fbfc3af30afb1837ed9f89eb4e8b67968e2d4fec9bf5c5642589024ea69n,
  r: 0x8703130104n
}, {
  a: 0xcc4026b2657edde47f8183db280526c8ef78739f2088bc43cfa834cden,
  b: -0xb396f1864e574212c4n,
  r: 0xcc4026b2657edde47f8183db280526c8ef7873940080a4030a8814c1cn
}, {
  a: 0x1c85a69d8907ca0a36c308c80c6ce97f59d44b82d83da74eba1e56264788390a1ac9n,
  b: -0x7dbcb2n,
  r: 0x1c85a69d8907ca0a36c308c80c6ce97f59d44b82d83da74eba1e5626478839020248n
}, {
  a: 0x1f1e58044507d96c4ed5cad4810506520487645feba401b8583a2n,
  b: 0x3ee16266906e0c23aa62d9329db85208b48ff66d84ad24a45n,
  r: 0x18004006906c0c018a40810004100000240fe22400a800200n
}, {
  a: 0x42b17e54d4665fa2cbn,
  b: -0xf6b6cefd029f7n,
  r: 0x42b1701490000f8209n
}, {
  a: -0xf4aa20b2d2803f1a1df2f8352184n,
  b: 0x3741325den,
  r: 0x10402045cn
}, {
  a: 0xe74e00582cc1cba6bdf9904575d2c4c70a7247ceefabfen,
  b: 0x6fb5dcn,
  r: 0x6fa1dcn
}, {
  a: -0x1fc2402c207f68fefc77aen,
  b: 0xea0c6013b3f6c2a2669b1b55bfc68110220a522c254fdn,
  r: 0xea0c6013b3f6c2a2669b1b5403c281102008500020050n
}, {
  a: 0x4e2bc761n,
  b: -0xa6c9952d2c03355ca2227b659b6704de2ab256202bcfbdfb2n,
  r: 0x42000040n
}, {
  a: -0x4a7ca4fb743d11ccad9da1d5380e503132490c9719n,
  b: -0x7769ff3411ef33138ee9ccn,
  r: -0x4a7ca4fb743d11ccad9df7fdff3e51ff335b8effdcn
}, {
  a: -0xb0c17908e710ae1d4n,
  b: 0xb1bf1c461c83f1a37515a640309b1cc84635cda10b89981a1f2be9abd53n,
  r: 0xb1bf1c461c83f1a37515a640309b1cc84635cda10b0918021708e901c00n
}, {
  a: 0n,
  b: 0xf9995e704af4b59916e6225e5de1142d0n,
  r: 0n
}, {
  a: -0x6ff21d1dfn,
  b: -0x890d5e6abcc21b12593c42c7b4ae20fe4a1ac4800b63576n,
  r: -0x890d5e6abcc21b12593c42c7b4ae20fe4a1ac4effb7f600n
}, {
  a: -0x4294b07206c3b048aed3cffdb70de7dcb37a11935e967d1f46n,
  b: -0x4b8b27099afa28cn,
  r: -0x4294b07206c3b048aed3cffdb70de7dcb37eb9b37e9fffbfd0n
}, {
  a: 0x71b0dd014b288e1ad142cab441n,
  b: 0x6d5268087765b8505df4e3935af478c2fa7a7edb83fdf2d4c0d711eaa75n,
  r: 0x21a0cd000b080c0801400aa041n
}, {
  a: 0x168272e76add117edf265a6251cn,
  b: 0x132e174a44f4a9aae4902eedefc2bfd1680eb87n,
  r: 0x8260802acd01429f004802104n
}, {
  a: -0x3bf08n,
  b: -0xbc470ef9a7a731c1187d91cn,
  r: -0xbc470ef9a7a731c1187ff20n
}, {
  a: 0xd1617f3929dfc4591469n,
  b: 0x4485an,
  r: 0x48n
}, {
  a: 0x1cf0eef87cfae7ba9dd7f0e06a8n,
  b: -0x14b75f79ebb6b509c9b8d61ba214a838e756793b183c994a95b1c5c5685c2709e3271n,
  r: 0x60a4684c3a229281d0f000488n
}, {
  a: 0xf323e5f396f4832c47563091382738den,
  b: -0xf34200cff48c06792650e0746d96f9252dcdd0cn,
  r: 0x2325900490812801061001282320d4n
}, {
  a: -0xc2f163ed3b1636f204e30b917cb88bb90d970c6dfabb4c3ffc4f41cede28bb269565n,
  b: -0x7d1c5bbcd30f1322c153563be0155b13f68f3f2fbc6caaeef3b9c398247ccce91c9an,
  r: -0xfffd7bfdfb1f37f2c5f35fbbfcbddbbbff9f3f6ffeffeeffffffc3defe7cffef9dfen
}, {
  a: -0xb2b0eababccdba9734777dbc894a34n,
  b: -0x3f71a770c8a1e4d99d0058f3ca1c3af564a4bfa1n,
  r: -0x3f71a770c8b3f4fbbfbcddfbdf3c7ffdfcadffb4n
}, {
  a: 0x5e10a44721858c0000e2fbc1cf5b39da594e915637e4782a063ec82f3n,
  b: 0x248397f35fcb5ca75fn,
  r: 0x2002078200434c8253n
}, {
  a: 0x1e759d6264d0946a4fb605e3ab6c76a89b74d4b889d21898c1b8c760fb2655bn,
  b: 0x2d85bcbcb9295681c89edf77817n,
  r: 0x480889018084080c000db26013n
}, {
  a: -0x44a84a276b979aca363a549368307322f4c011f9n,
  b: 0x216b05e1e1cd6d3146359d42a943ae0a8daa890a036a0610556892dd010bb725en,
  r: 0x216b05e1e1cd6d3146359d42a9012a088902800200080210416890cd0003b6206n
}, {
  a: 0xd081b2251de3b1881484078b492bb77fc74f8097abd0615d83cad58n,
  b: 0x1c96c45a33cf2767aaac37aab0abe97d7067700f7ca0dd67n,
  r: 0x1096001801480060a0803322b020e8097025000558208d40n
}, {
  a: -0x2d87bed43bn,
  b: -0x874e07e6e42c7307be368667d8111bee0312n,
  r: -0x874e07e6e42c7307be368667d83d9ffed73cn
}, {
  a: 0xe0359962f3bf270735e8eacc9692cf87a8ee9b04n,
  b: 0xa7c5abc8296fa3e1d75ff2d1a2en,
  r: 0x20410a8828492120d05a82c1a04n
}, {
  a: 0x817027399644c0863facb1f74a822911c4b16eb146ed96n,
  b: -0x6904100b590d2eba601ba3c99f687d8cf5c8c2a7c755e061cn,
  r: 0x807002290404408605802001480220014091028000e984n
}, {
  a: 0n,
  b: -0x513e5a80cc1c43ef50121fe954b9b5a060d6d0680144537c1f1e52e21b179f5n,
  r: 0n
}, {
  a: 0xf6d8467c4c77df7f2a63f082cd36709d1465a26339e99de4efn,
  b: -0x85a3eedfa23b8f5f7d664b05b9f1878n,
  r: 0xf6d8467c4c77df7f2a63a080000450050000200309a000e488n
}, {
  a: 0xdc9f223dc8e3d6n,
  b: -0xff4dn,
  r: 0xdc9f223dc80092n
}, {
  a: -0x51c84b19d698d5ef379d1259669b1ab3a8dd7b78cf7c54ec92b4c3acn,
  b: -0x305994b78de0d32e00e827e69f3d524dc75e40afa4112320ce0cd3107e5d1c641a024n,
  r: -0x305994b78de0d73e84f9bfef9f7ff37dd77fd6efb5bb3baddfbfdff7ff5fdd6f5e3acn
}, {
  a: 0x2fc6fd0817abdn,
  b: 0x962960e4e46n,
  r: 0x86290004a04n
}, {
  a: 0x3a99b59ab16d99f71804d3e8d008e9e7a36de986587746632276690761cn,
  b: 0x8482f651413d36304fcdc6be4085af5072baf421ae2580dc47ad0fd3ca2538e0en,
  r: 0x10013512304d89c6180081a85000a8e4212c2180584704030242210060cn
}, {
  a: 0xa43d7c23bf4972fbf227b5651dbfaed28444e14ae667957386857abd3dn,
  b: 0x719120an,
  r: 0x5181008n
}, {
  a: 0x5n,
  b: -0xb2930cfffa8c883bc293751aa4c8fd2424a1c7a0aa64cc6917decb8bb15e5fbdf5n,
  r: 0x1n
}, {
  a: 0n,
  b: 0xe5f0161c24a4459892e878f9048a1f077cfa331bd3ae8163a4c296b796d1115be40n,
  r: 0n
}, {
  a: 0xc86d76e55043d67eb1a48111b6a5n,
  b: -0x648d9d6945n,
  r: 0xc86d76e55043d67eb180000096a1n
}, {
  a: 0xe4ef5n,
  b: 0xd5ba3a3c8n,
  r: 0x202c0n
}, {
  a: 0x3987b8e5947a963f9cdfc8a7393087581d8e9a59636cfb0c4339648e44eb38ff2b40n,
  b: -0x225a5294fd1ee4ce0a980573351369719e1649590c4536ba569a607e5n,
  r: 0x3987b8e59478921a9490080131100658088c8a4960641a084229208c044a10592800n
}, {
  a: 0xac5dn,
  b: -0xf0bf61b394ecf69778809905ba775d62a27fb090ce4b988a327f7073b0333ccad973n,
  r: 0x240dn
}, {
  a: -0xe7e3e6e3454463efd37c44e7557e79d1dbb0d29870cn,
  b: -0x788bb8712d3c83886b2760de07aefc8356cb708edc897202362b4727fb71317n,
  r: -0x788bb8712d3c83886b27e7ffe7effdc777eff3fedcef777e7ffbdfb7fbf9720n
}, {
  a: 0x8eab3c990dad8588c64e1916c8a6c7405n,
  b: 0x7a28b13783cec4c0ad561ff5660e7adb3b1dbdd0f28853d200d98fb95d4e89b129334an,
  r: 0x8c0b28810d200588c2041000880283000n
}, {
  a: -0x44e97389ce0a6242f34e488d6dac42fffc1cda16211e51b6b846730dn,
  b: -0xe6ded0145867597816447f84bdd3ef85bc52n,
  r: -0x44e97389ce0a6242f34eeedffdbc5afffd7cde567f9efdf7ffc7ff5en
}, {
  a: 0xc092958de33fbbd3b1d2c4d0ffab1en,
  b: 0x3a570965c216f40b4b5385f652e3505938891dn,
  r: 0xc0129409431381d210c2405038891cn
}, {
  a: 0xc761f86642c0f11292965f01e863345471d2d47d512ea50e42173n,
  b: 0x5dcbdcadn,
  r: 0x50c00021n
}, {
  a: 0x5dca1cd4b2n,
  b: 0xf0e56c642ddd1a89218ef92e15e14ceedac0710cn,
  r: 0x4cca005000n
}, {
  a: 0xe10bf37b7cd2667665420d2cf2f91bdb821f9e3d483d412654cce5004433a9d8acn,
  b: 0xb0924f21b87869401ddd86d3b0df6n,
  r: 0xa09003001060484010040212908a4n
}, {
  a: 0x371dcbd47e72926dd7a6e8d3fbd12f97bf335c5eda3876f0f955d1d2fdn,
  b: -0xd349e5d43768d2dd1n,
  r: 0x371dcbd47e72926dd7a6e8d3fbd12f97bf335c5ed20860a0b80150d22dn
}, {
  a: -0x30f75a2bd2fbfff33084d3ab664f9c39ceb0d327740ce50746b8947f7cb26a0288856en,
  b: 0x73fb55d470bd77f9aede5dc7cfa02ad1932f1ee11397d6c970n,
  r: 0x20501190608431492cd809c30aa02841030002411195564810n
}, {
  a: -0x5f26b4aec274861aca940b4210c436663c8bcaaa37a9e5700d8921e9cbe519850e2n,
  b: -0x4a79d074ba0857a6eb7ac4555ce473e955f08d44d25ca1ce4d608b29c7n,
  r: -0x5f26b4aec6f79f1fcbb48f7a7ef7be677dcfcfbeb7ffedf44dadebfdeff719b79e8n
}, {
  a: 0x8d47f11a5ff22ed9b635473643d5b34f1n,
  b: -0x3631f9e0cn,
  r: 0x8d47f11a5ff22ed9b635473641c4020f0n
}, {
  a: -0x519a953dc5790ca2d3eadd0e5fbf87c57d0a6488695749d7c42f31b284ba7bn,
  b: 0xac09444aebad327b791n,
  r: 0x8800000808a41230581n
}, {
  a: -0xd4b32642e766aacdd5b4cdbaf29593db76126n,
  b: 0x8c990008n,
  r: 0x80080008n
}, {
  a: -0x24b4f301f30455c20dd76n,
  b: 0xe74b6e364b2ad50951844c3b580857f9743ab322ce12f24ae0064aae62a0n,
  r: 0xe74b6e364b2ad50951844c3b580857f9743ab3208410c240c002028e2280n
}, {
  a: -0xeee0a39d10a0n,
  b: -0x186bea7b4862c17a19c3066da90a706f9f19639be3f80956829f9n,
  r: -0x186bea7b4862c17a19c3066da90a706f9f19639beffe0b7fd3a00n
}, {
  a: -0xc005ca44babd74fbfc94aa9c44fa3b8d57ad7b0f0c73b620d7a2c4c5c249085572en,
  b: 0xaa17e9fbb4n,
  r: 0x8a0768a890n
}, {
  a: -0xc81f61af0e5f273451d35c5e4e2ca0783b33a11941c6508071f4d29f42d169d7305n,
  b: 0x56a862aa33ad14428aff546f7c0ad7bc25d23ddaa698ef39b7c15c6ae83875099950n,
  r: 0x522800a0030804008ae2402a180815b8244005ca22808a31b0c01042081061008850n
}, {
  a: 0x1dadea2900ce676d5b93f99463de30e19031n,
  b: -0xc26bb0a00cf6ea4ede99a23da609c6c87c33a56d9e783a9f1n,
  r: 0x190002210004076113103884210610601001n
}, {
  a: -0xe13c265c8296496d7dac3be132a6a56cc3bbe588d8e725c2c227042205e10435cbbcn,
  b: -0x13e4cfdbf6c1c2fdd866184c76e6ac596cf5edbd2an,
  r: -0xe13c265c8296496d7dac3be132b7e5efdbffe5cafdff67dace77e6ae5dedf5fdffbcn
}, {
  a: 0x13e2b6f4cf4efefd3007c8c7ce9c65277fb803e08ecd1a1d05c8d030052n,
  b: 0x6566eddb9f4e1af3fff717b3946ed0d038b85d6f441d609cd11b26bb51d1b6cb6n,
  r: 0x13820610c34ef615300448c0c01820056f0001608cc11a040140d030012n
}, {
  a: -0xb198fd664c35f84a652b97d29815f0n,
  b: -0x4f2ee0d67378868c93b14530e2c99d4528db82b0d46d5733dffb81d2953064e7ca1n,
  r: -0x4f2ee0d67378868c93b14530e2c99d4528db8bb9dfff77f3dfffa7d2bd7d6de7df0n
}, {
  a: -0xb61a8841e5d983bd848aa7ca94256n,
  b: 0x19565fcf7f70f8ff89fa523a2b167n,
  r: 0x944578e1a207842097050302b122n
}, {
  a: 0x8f5f2b3b47456b31dd802dc6e227e3891a59d96179a956753685491264bn,
  b: 0xbf1588f7766bd078df1b685cfc986e180cb38639199dc515305n,
  r: 0x705083154000040c20360081818480008a1063110854110201n
}, {
  a: 0x56161c61fac9n,
  b: -0x82859n,
  r: 0x56161c61d281n
}, {
  a: -0xe7a07bf2f60f85a459ac28cc2765b0409d52c0aa3eecedd7e75e061b666e59857240dn,
  b: -0x8168439039caadac6d9794b9160da2eca57da567901a06aae804b65e6cd9n,
  r: -0xe7a07bf2fe1f85bd5bbcaadee7fdf94b9d72daaefeffffd7ff5fa67beeee5be5f6cddn
}, {
  a: -0x74e9den,
  b: 0x70ee44b556f578793351e0d3b5b4674db76b1e74440fa9n,
  r: 0x70ee44b556f578793351e0d3b5b4674db76b1e74000620n
}, {
  a: -0x5960f9aea867d94b0a04966cf2a23ccb84eb216286ceab99baa682291c07ab9d6dn,
  b: 0xe2c52531dce6738838707aea631e378f1b755fcd9a2d5074n,
  r: 0xe24101015cc230081050186821142605197556c198044010n
}, {
  a: 0xeed2792dba8293e8e1c7dc59n,
  b: 0x5df1ceeb5e26c0f11an,
  r: 0xdb082834820c0d018n
}, {
  a: -0x9e11d8b86d1n,
  b: 0x5de238d7ef81e9b5097030de3cd4a245dc353051776e3ba3f6e5a5a87251d13f6639dcn,
  r: 0x5de238d7ef81e9b5097030de3cd4a245dc353051776e3ba3f6e5a5a87250102264390cn
}, {
  a: 0x2d8cbb130547d1fb29b50bb428798eb6350100ed4a9cc09aebf3ce8617988d1cfe18n,
  b: 0xece546489c37f5179ac5d7b010fe7e5f17976n,
  r: 0x604000089421c4018a8514a00078085107810n
}, {
  a: -0xcea97458e1b0c7207625d3b9a8111699daeee096b00eedee5976en,
  b: -0xbbcdff0eb9f09bac5862678e0614773c2e387d3e5e53dc6f12f69c26e2ca5707n,
  r: -0xbbcdff0eb9fcfbbf5dee7f8e7617777d3fbafd3f7fdffeef1bff9ceefeefd770n
}, {
  a: 0x562n,
  b: -0xd500a45c18c4dc4e7c84e32230en,
  r: 0x462n
}, {
  a: 0x7c1455c81e28n,
  b: -0x5bdc224665a3fbban,
  r: 0x5c1010480400n
}, {
  a: 0n,
  b: -0xa9efcn,
  r: 0n
}, {
  a: -0x6b52b2368ec6c8fe176ce2ae09da785be0e140de6n,
  b: -0x6ef9d090b0da5n,
  r: -0x6b52b2368ec6c8fe176ce2ae09da7efbf0f1f0de6n
}, {
  a: -0xa4e5287d49n,
  b: 0x6a1af04f185434b44744cc027n,
  r: 0x6a1af04f185434b4010448027n
}, {
  a: -0xa64b11cb775f925f0d5c89184729efecdn,
  b: -0xb42d10325c43580ba3ce238n,
  r: -0xa64b11cb77ffbf5f3f5ccb584fabeff00n
}, {
  a: 0x47696f897a15a2234fb3c69c2774aab6f17156f849ab8n,
  b: -0x22d3a82141e0f833503faeca6a9608f555a18f2ba3b1efa35e30dcb7eef49a3den,
  r: 0x412105097200a2024090440c0054a0862140100841820n
}, {
  a: -0x3f78dc0f31bca9f8da28en,
  b: -0x42bc43d6b60eaac707ff220043n,
  r: -0x42bc43f7bfcefbdfcfffafa2d0n
}, {
  a: 0x81d8e1d1038163d192e6842d175bf1502f29n,
  b: -0xf35e3ef1efb1bced379e2f3e68c72fcaeabc7061ca6e53574282624an,
  r: 0x80c0811000010141828604010408b1500d20n
}, {
  a: 0xaa1779a016def153cfaa31dbd58c29e737ae78abc6a88ec8ed70861n,
  b: -0xde4b33cf98176d1b5bdf1d58b1014686352cd559n,
  r: 0xaa1779a016def1520b08010254882842020e2820c6a88688ad30821n
}, {
  a: 0xd2252814560226c882f30ad11c3c637ad5bc3a8b8905b7934efb49f8an,
  b: -0x1d24693a6ed9260a1902ab39dfn,
  r: 0xd2252814560226c882f30ad11c3c637a05b82809000597124ed148600n
}, {
  a: -0x397453bbaf95dfa38af2e706a40d3c20c25ae5n,
  b: 0xd34878169792b9cbf901c08n,
  r: 0xc340500695922809f100408n
}, {
  a: 0x4f3b851d2f50f0f919579d1f51c65c104bdddbea616e6e7c8c7682e0bf896525d1n,
  b: 0xecdaa5fd02db5f1b6e8f7856c8ff7c2cdd00b4bebb597a81c378fa52f0cn,
  r: 0xc0d0050d00915911640c604000bd5c2c8400a4a68841680003789252500n
}, {
  a: 0xfbc136970ae72598263bc0e04db70178da6c4e920eaecf741320b5d88ac8a589n,
  b: -0x86ab6e1134f8e37a215b3fa51eb84b4767e86363395e16bd942261f1871c275n,
  r: 0xf381001608a02188042a40000c140148880048800c2a0e14022091c082882589n
}, {
  a: 0xfe79bdea76411399e52af015305fc2a4a876e04021bb7f84f097bn,
  b: -0x6432a641c5c095252ad77ca336d5a4de5b67e244n,
  r: 0xfe79bdea76411198c50ae001300d80008834c00021b21a0080938n
}, {
  a: -0xbba633144ffb0bb805a27ad7042af058348002bban,
  b: -0x78ab20f8bae68658f33499e7e0bbn,
  r: -0xbba633144ffb0fbab7affbff6c6fff7b7d9e7ebbcn
}, {
  a: -0x66069f313d226b0b5fc2635061d43dc7f0387afb7ca1e794317f51150n,
  b: -0x49071eb7202a22af92b45dbdb0c500dc12e48433741d5aa64d7f338bf9bn,
  r: -0x49671ebf313f22ef9bffdffff0e5d4fdd7f4bc7bff7dfbe7dd7f7fdbfe0n
}, {
  a: 0x9e3f17393849487af581df3daba60f692n,
  b: 0xf716b84c10483d5a5eeefb4fac993b48608d71b201153fb56a1c717f710272fc3c7c2n,
  r: 0x10320111380148187101510022a40c682n
}, {
  a: -0x8489fed88a3e1cc53e3a71d6650ea0909a0c362a1b0dc0aaa26n,
  b: 0x37e2601332ecfa3c993027587de29da3f1b5be8740fbb1n,
  r: 0x1262401232ac18188010271074e21d2091140e03405190n
}, {
  a: 0xfac71ae876095cb1e50f89f3038a03b9c8e7567130eb15df77c9d808c67n,
  b: -0xcc906f36cdbb4516e6c498befe4fa8636d3018dad688053f49n,
  r: 0xfac71ae872005800810409a201820230000304710028145252815808027n
}, {
  a: -0x7265330ebfbab0d0n,
  b: 0x38c25b42efdb6cacdbfc6383ac4631ff38a0ebd5ben,
  r: 0x38c25b42efdb6cacdbfc6383ac0410cc3000414530n
}, {
  a: 0x223af6f9n,
  b: 0x769942e6d426b63078fec42230adf2c194en,
  r: 0x2281048n
}, {
  a: 0x8254ebb28ca5cc8e4aa8ef07d5b20251d43e2d8ba3587e75e443466125f6115fn,
  b: 0x40ef0n,
  r: 0x40050n
}, {
  a: -0x17b47254e97da1eea089e5cb3055520en,
  b: -0x42c4e3456d1928e5ad56572n,
  r: -0x17b47254ed7deffef6d9f7cf7ad5777en
}, {
  a: 0xa64cc22ebf96c74b08b82c9e35c86c2e7d801a2363423n,
  b: -0x23bac148aaca2fe31b71a2267deda3ca935d48n,
  r: 0xa64cc22c8412c3410018008e00c04c082100020242020n
}, {
  a: 0x938eb58c7d74f24fe27eba4b6d55a637f3ea3c46e2cf6cf1c7c53a8469258613596397n,
  b: 0x7822n,
  r: 0x6002n
}, {
  a: -0x338cf4a3261c97e5ffb39e37063f4e30000a9eaecdbda3f9d801ba3ad03fba15en,
  b: -0xeba9d20b91668f449e7bec7bb17df85e31d9b6ada625549n,
  r: -0x338cf4a3261c97e5fffbbff70fbf6ebf449effeeffbdfff9de31fbbefdbfbf55en
}, {
  a: 0x3bca800b221ff0c5043e6750fc10bceb53e700f3c61eb93d3fd2d3715c5e4c87n,
  b: -0x31e7a6ae6c868701edb3a8a4c1e719dff237n,
  r: 0x3bca800b221ff0c5043e6750fc108c0851410071401e100c1752121044000c81n
}, {
  a: -0xfff8bf23829c864a251db7da58eef15512cf7c5a0d727e8a53adcn,
  b: 0xd6f4ae43b82b10a2bfd57765a5c5fc66d9daac0421n,
  r: 0x16900c022002102010c0264100005c20d812080420n
}, {
  a: 0x60663fb4fb99aca25393d7a1ff94630b72n,
  b: 0x8d8be54924n,
  r: 0x8d80610920n
}, {
  a: 0xb1aa8dn,
  b: 0x928b49a6be68822423d250d6468de399f45177dd60846fb1933n,
  r: 0xb10801n
}, {
  a: 0x2923ac2973b2be15b4a30a5d38c46cn,
  b: 0x6c9af981c219eef3c35e2341de3a8a56832daen,
  r: 0x1ac214312220194220a5400042cn
}, {
  a: -0xde6f15abb08e1f254eb123402ed416203913f5a8bde2a7047965cf0b0564cc5fcn,
  b: 0xb78bb0e07d6ba930349b214b1cb5be2e613915553bfff141d972450a2371n,
  r: 0xa500b0000d2b00200099000a1cb42e00213001550bb86101094201022200n
}, {
  a: -0xbf65bff531e9n,
  b: 0n,
  r: 0n
}, {
  a: -0x62272c74ad1a999n,
  b: 0x1ffd8910479f41c635bc30e75ad41n,
  r: 0x1ffd8910479f41841090004240441n
}, {
  a: 0x1e3532fe9975aa30fn,
  b: -0x6436f9c29818b8c3bc034c90bada0e7e9f61a72a6c253cb897e5c0c6a4ccdb76e7373n,
  r: 0x1e31123200010800dn
}, {
  a: 0xc74d2676636e4b3n,
  b: 0x1f71f21d9643236847a6c1864fn,
  r: 0x20404726008403n
}, {
  a: 0xdc83bfa945164953e4005912c77baf5f14n,
  b: -0x27509867e3c865c21e29308583ec37n,
  r: 0xdc8398a94510081380004112c77a2c1300n
}, {
  a: 0x1c1889b265722c833n,
  b: -0x894c6bn,
  r: 0x1c1889b2657228011n
}, {
  a: -0x3d5374367640a3434b83e6c0233816b76d0ccaa5fe93f8aabd414e85fd165cn,
  b: -0xaa4db39c18b25b31ce45d470529fea0cb00856afe66cba2b9817e453853d704f4n,
  r: -0xaa4ff7bf5bf77f3bfe75fc7e7e9ffb8dfb7ed6efee7ffb3f9abff457ed7ff16fcn
}, {
  a: -0xa743d562ff0b9938d1159229da6ed007e7b3d88abn,
  b: 0x9ea80647f06b3905c2fc76d84b8n,
  r: 0x86280245d0211105c0184400410n
}, {
  a: 0x4a46fca95af22b8dbe99d28e3a5802ba6cbfd92ed343fb665bdd1fe42n,
  b: -0xf68c59c5effdfn,
  r: 0x4a46fca95af22b8dbe99d28e3a5802ba6cbfd92ed3430962021810000n
}, {
  a: -0xeaa9120f6c6e657677981628c600n,
  b: 0xfc3c4bc07f381e1c1381b02501e015bde1a5190786de0ca2d8a2df44859c00n,
  r: 0xfc3c4bc07f381e1c1381b02501e015bde10510058092008288804740851800n
}, {
  a: -0xf187e4fbeb40859e084475fd144681n,
  b: 0x8808d79079fce5da66327fe0fb22da0fec39b9936ef22fn,
  r: 0x8808d79079fce5da06301b0010225a01e43988026ab02fn
}, {
  a: 0xcae48859a9c29ff811867494a874b4b57be819c84109466edcn,
  b: 0xef456485df317f65bd0a24c2n,
  r: 0x64042401c8114841090224c0n
}, {
  a: 0x2n,
  b: 0x27d00f1bb8d333c8afe4bfdn,
  r: 0n
}, {
  a: 0x8aa9bb8a8a71746a384c15ae1e90d0f7d0569f6c5447e93647cdn,
  b: 0xf93b72402e8a72bac0388320c68b51ec31ec152f176c7066fe21f6f8a28ab73952n,
  r: 0x8a80388200400040280004040e10407040560164500288360140n
}, {
  a: 0x100dea26627a37caad378d477edc7en,
  b: 0xef6a09bdb850a49a272ef261bbe35n,
  r: 0x4a00242000248a0328d061a9c34n
}, {
  a: 0xb4cb4f50d6dbbdd3024902b848068fad446db0fb1d17n,
  b: 0x4c9b9937dc67a610def76953a511b8f7e616n,
  r: 0x449b991300410210480609010401b0f30416n
}, {
  a: 0xa148a05571329bc0302dbb897e1df433c4a90970cd7ba444c7b01dn,
  b: -0x17n,
  r: 0xa148a05571329bc0302dbb897e1df433c4a90970cd7ba444c7b009n
}, {
  a: 0x7en,
  b: 0xbae9758848fd671n,
  r: 0x70n
}, {
  a: 0x6246af81ae7ee60cde2beda36dd783e10806c9c16fb5e635c822b5edea5n,
  b: -0x9d9ed4e6a1c9d600bfdc645258bcd5c0ec0b0aea6fc31701n,
  r: 0x6246af81ae7626009001e1220dd402210802400023b12605400001cc8a5n
}, {
  a: 0xac3d1a0d0e7dec205a43222bee4fa02bad159323669f8fed76d0fn,
  b: 0x79e45da87b1100e429e4c03a95ac6cf8041d550918bfa9446467794dfbcd15f5n,
  r: 0xc020c0c01a80042430001c440800ba814020266948fac50505n
}, {
  a: 0xfn,
  b: -0xac17bd2858f589a1dbe9571784d8a84933cn,
  r: 0x4n
}, {
  a: -0xd334dcf42f46fn,
  b: 0x6bfe5cf667b08432a9935df32129318e3559n,
  r: 0x6bfe5cf667b08432a9935df20020308c0111n
}, {
  a: -0x2d13839a60e7c812d3f8516251d3ab465eaca26n,
  b: 0x1a4efn,
  r: 0x124can
}, {
  a: 0x31c1bb93b00a991ddfe17439b74c752aedfe03a7an,
  b: -0xe534101ede71151daa264edb7f9bbb2df14108941a5efb92612ea8c0c1febbd874b3n,
  r: 0x412083a00298181040502915407120044200a48n
}, {
  a: -0x99508a37d28b6f05b1734c7n,
  b: 0x829df30dac26bd34e62c3fa98efd98ed2225537c403e900e7e33650091fd0e464225n,
  r: 0x829df30dac26bd34e62c3fa98efd98ed2225537c403e900a76100000010d04404221n
}, {
  a: 0x3494db78c4an,
  b: 0x65adf536960ee9edb99e29778cfee9e65075e8e6195e674bf5n,
  r: 0x2094c270840n
}, {
  a: 0xf6e80cc4bb59165dbd064a6071ddf5920b8388d52f13adbc031c332caf97ad0877n,
  b: 0x6a8e7e381d6974652a4b5dc9f26c082739f212a0d8e76e1n,
  r: 0x608606181d492020280950c132480021013202a058c0061n
}, {
  a: -0x7d9049190a43e09ea8da7b464951264n,
  b: -0x70e3e302b9d1e3977e0be0e05d454ac4a84n,
  r: -0x70e3ff92f9d9ebd7fe9fe8fa7f474bd5ae4n
}, {
  a: -0x4n,
  b: -0x91848n,
  r: -0x91848n
}, {
  a: -0x6ea01b054705c4888b3e081d91a176796577cfe9c1c08n,
  b: 0xda56a6cf8372282572aabfbd46308e56d7d2e3a6374281n,
  r: 0xd814a64f8302202572081f3c0620881041808300234280n
}, {
  a: -0xba915ef2fba930710a6e51b6ff183770b4e18aaa13n,
  b: 0x2en,
  r: 0x2cn
}, {
  a: -0x86af8a4n,
  b: -0x1260f8dc8a9e1887dn,
  r: -0x1260f8dc8a9ebf900n
}, {
  a: 0xae5f13967ecb419f25568c03391ec5n,
  b: -0x941856992bf7ce6d10n,
  r: 0xae5f13967ecb4187214684003112c0n
}, {
  a: -0xd21c3ed7b7c13ecfca1f4c1dd276932f8dcc72f0f6a82d015188b76den,
  b: 0xde28157dfe2a9d6cb1ba7n,
  r: 0x8c080155d22a8c6400922n
}, {
  a: 0x21b645f679a0dea893bf81854043bdb43986c0c097eeb5n,
  b: -0xd648ead0ed93n,
  r: 0x21b645f679a0dea893bf81854043bdb439008000070225n
}, {
  a: -0x4b1ca5ce01523de624f78fn,
  b: 0x8deb074da9ad99211df52d258c40dbfd38fb709b3210261f226336d5c2n,
  r: 0x8deb074da9ad99211df52d258c40dbfd38fb30831210260d0201120040n
}, {
  a: -0x5f450979fc21b6a3d544d049bdd705ab46595f59fn,
  b: -0xbe1ff9ba38992abfa4776be293ab79380622222cda08d303dn,
  r: -0xbe1ff9ba7fdd2bfffc77ffe3d7eff979bff727afde59df5bfn
}, {
  a: -0x52f973bf2a234c9eea00337b3d61e4f1a66fec7912a9n,
  b: -0x6eb04bd96fa4b3e19ee7be83e4c8bdn,
  r: -0x52f973bf2a234cfefa4bfb7fbdf3e5ffe7ffeffddabdn
}, {
  a: 0x588ccc5706d80e77f3ea9b05a8b9a5bd7cf00db168f437a0e25n,
  b: -0x329fd80bb01babdn,
  r: 0x588ccc5706d80e77f3ea9b05a8b9a5bd7cf00d2020f407a0401n
}, {
  a: 0xf9e5267a3ff9dd931e79b62233ee51ce23a94n,
  b: -0x5bc520dac0c8513bc45ee431feef4f49d7d7299686bae69c6c8b87a3e4n,
  r: 0xb8e0000a0b608081061194001228114601814n
}, {
  a: 0xbe2ad1df3300824bf84f5780041f19218eb280e3d481f35n,
  b: 0x50227c7bb44a4ea5426081b52e4e5d06e0e7a57ba90031n,
  r: 0x40201c73300804a50060000000401000e0200439080031n
}, {
  a: -0xd0fca8dec8af7531845f1f9217b26d4346a5n,
  b: 0x5685b10c16137968387348cbf18ac8b5cb5d5c0420501ec0fn,
  r: 0x5685b10c16137060307200410088c0b00a045c0400000a80bn
}, {
  a: -0x25def4016b17c562b3f4ffd61425778b26cn,
  b: 0xa5c7c536460eeeb766n,
  r: 0x808000160408860504n
}, {
  a: -0xaa48b0f1b5feb9e2f87be3d62cn,
  b: -0xa81b5c34325d0429db4c7844e626d808ed6950bef0b81295n,
  r: -0xa81b5c34325d0429db4c78eeeeb6f9bdfff9f2fefbfbd6c0n
}, {
  a: -0x1e45268n,
  b: 0xf31e218f66eb5n,
  r: 0xf31e218122c90n
}, {
  a: 0x8ccf4b5852578bd6n,
  b: -0x3c41dc415ca5f55aa6d0bbd1ed9ee0fe9aab19c7e5aef5n,
  r: 0x45404010120102n
}, {
  a: 0x85d7b5d934a2a7bba11aeccafn,
  b: -0x67498247b9e2c094607875730e9ad7687578ffbc8ba0ff28n,
  r: 0x8516108930a020002100e0088n
}, {
  a: -0x66b37bb49fef1e5519ac3d785e9c8c0f29ef633cc05a4aadbcen,
  b: 0x312a7e61be6f51fdb317e86c09n,
  r: 0x10223e0120094031b213402400n
}, {
  a: -0x9231063d98bd7a95ea4c2c86169ebbe67fdad3c36n,
  b: -0x6701881ab3dae9252d422d8366def63b2722a7dd7ca86fe71d65570c4ef0b0c2n,
  r: -0x6701881ab3dae9252d422d8b67def7fbaff7afdffceaefe77defff6ffffdbcf6n
}, {
  a: 0x741f8528c84c4c461n,
  b: 0xc36cc5261531n,
  r: 0x420c84040421n
}, {
  a: -0xcf0fn,
  b: -0xfe56d29464n,
  r: -0xfe56d2df70n
}, {
  a: -0x21e6f2b1616an,
  b: -0x2084baa657756cb88c8e6d87a7cfc170978bn,
  r: -0x2084baa657756cb88c8e6d87a7eff3f1f7ecn
}, {
  a: -0x63a6699c937c19a8c1dc4e5ca50ee54c5826deb876a85cn,
  b: -0xc8f1207n,
  r: -0x63a6699c937c19a8c1dc4e5ca50ee54c5826debcffba60n
}, {
  a: -0xe45af250d4e7d54cn,
  b: 0x666n,
  r: 0x224n
}, {
  a: 0xf81ead2fb71f57a02cn,
  b: -0xc161cfd049d175fce9ef9aa4a76b2240aa78664d863d70c3d68c04d566b98n,
  r: 0x281280073712018028n
}, {
  a: 0x3c5dce4ecb051d785bc9cf6b6cf1383966cbc044fn,
  b: -0x8909bb14e32188170f077n,
  r: 0x3c5dce4ecb051d785bc9466244e1181866c8c0409n
}, {
  a: -0x263bae7c9dd7n,
  b: 0xfa493n,
  r: 0x32001n
}, {
  a: -0xba5c4f2f6de8592c33c638ff94fb192055a3a32an,
  b: 0n,
  r: 0n
}, {
  a: -0xb02272a63715e7042b8f8fa54de3f7999024097b8de0caf8en,
  b: -0x8da44232ab53ed822d8e1bbn,
  r: -0xb02272a63715e7042b8f8fa54deff7dbb2af5bff8fedcefc0n
}, {
  a: -0x392edf8138fb5d7f542614ae609eaca80e6f1537n,
  b: 0xfcdc719996fe7affee9a2aa0eb7feb9a9a85ab915f66241bb5577n,
  r: 0xfcdc719996fe786d020228204a280a989a8509901524241904041n
}, {
  a: 0x97fc5b51fd0eeb88b2b3fa092575127911dce8n,
  b: -0x79d8859762c5b36de630bb1n,
  r: 0x97fc5b51fd0eeb882233a2090124002110d448n
}, {
  a: -0xd48f196n,
  b: 0xf2dac25378d6b88f1347d658df1b06266831e53n,
  r: 0xf2dac25378d6b88f1347d658df1b06262830e42n
}, {
  a: -0x77n,
  b: 0x58aee8529a28b777f730ba56093c290dcd45aceb54cb27n,
  r: 0x58aee8529a28b777f730ba56093c290dcd45aceb54cb01n
}, {
  a: 0x778c22929c0ae2bcaa629e052560a7ff9b8ceace0b89bf0bf9198n,
  b: 0xad189cb5ffdf6797f3cn,
  r: 0x8c088c01899f0391118n
}, {
  a: 0xe492dc35c53b51b3ca5a76b98cd2c4a85855f45052ab336620d7a84d14a3e9e088n,
  b: -0xdf72n,
  r: 0xe492dc35c53b51b3ca5a76b98cd2c4a85855f45052ab336620d7a84d14a3e92088n
}, {
  a: -0x261fe2178edb3d4f9f28b397ecbb5dd306efcfb1e79f4d09dd60107afn,
  b: 0xdb1c990f32ee2a2bcdb6ebd1dd183093358d0f1b17a85a1bf1f57eb5cfn,
  r: 0xd91c010e0202082b040460c0811000020581030001800a0b60217eb041n
}, {
  a: 0x66848a6c1f82ae0b49014666ba87e7e4b26d6e0bf66n,
  b: -0x8bd8d4aaad0085d75c68f2a5635c8b97f8cf237ddn,
  r: 0x660402281502ae0a080106041a84a36420052008822n
}, {
  a: -0x2db9818577f2369eabf351d84fe9d58473ca33a2150995192c2d91db7ee737f3n,
  b: 0x96a2565d07848cbb649fd5e496a3c738e81764df66c8fn,
  r: 0x82a25201028488834485d4a406a24538200240110480dn
}, {
  a: -0x852056e086f1n,
  b: -0x95aaf77dbf9d75e6ed0af1150cfebd7f9fdn,
  r: -0x95aaf77dbf9d75e6ed0af11d5effff7fffdn
}, {
  a: 0xa45eb37cc2f9904070n,
  b: 0x40019096a82281e0a03n,
  r: 0x1801688228100000n
}, {
  a: 0xcd5114cbd865fe037d3c3e305a73ce2950c59600d23a63n,
  b: 0xd1d4fb436b7c40652c1f427b7a063e374d3f0an,
  r: 0xd044fa03693c00200813422950041600403a02n
}, {
  a: -0xc0fn,
  b: 0xeeded41f88bb367349536ea45acf23ee9dn,
  r: 0xeeded41f88bb367349536ea45acf23e291n
}, {
  a: 0x784f332538n,
  b: 0x350f1bb0e519b6526b6c19c97d92c3943c7aff7d43050fn,
  r: 0x784d030508n
}, {
  a: 0x550dd71b08317765daa38f70dd6d36a5b96534041a981n,
  b: -0xe5cd8075a6n,
  r: 0x550dd71b08317765daa38f70dd6d36a5b961200418800n
}, {
  a: 0xe64ecd9e64e57eeee8a76n,
  b: 0x2f641e903f77dc1adca21f70bc23d93c6593n,
  r: 0xa44a019600c03c82c0012n
}, {
  a: 0xc49210de84bd612bn,
  b: -0x5bfn,
  r: 0xc49210de84bd6001n
}, {
  a: 0x88f6d8eee489e9001b7cfc56e746b35601388293a65776c0e15435d1e2326n,
  b: -0x654db5d4n,
  r: 0x88f6d8eee489e9001b7cfc56e746b35601388293a65776c0e154318120224n
}, {
  a: 0xd6f83d1251041c7e862749647f2e82e39d757d94ebed75ea1ac80b8e069c183485n,
  b: -0x5ae167a3d8880n,
  r: 0xd6f83d1251041c7e862749647f2e82e39d757d94ebed75ea1ac80a000084003480n
}, {
  a: 0x45b180a034c987aff6557bd31c67ea0041ec8e236ee7n,
  b: 0x5f464c497d9n,
  r: 0x1e4040006c1n
}, {
  a: 0x999ff56a01589e9cacb665bf23ac4n,
  b: -0x7fde9da3b0c56f83b3c3f299n,
  r: 0x999ff00200008490a806448300844n
}, {
  a: -0x5596d47cb8de8881e97aeb68en,
  b: -0x31b99df17860a185d72b3ee229bbd6ca5eed5ce243e685aed8cf540851ed1577d50an,
  r: -0x31b99df17860a185d72b3ee229bbd6ca5eed5ce243e7ddefdfcfdde8d9ff97fff78en
}, {
  a: -0xb027a635c13a7b2b4533d1c1b8bf2877f26f51d4dc739281d882n,
  b: 0xe60efeb236d5b9aebe50fdfeb837n,
  r: 0x4600d6800490a82a22006d7e2036n
}, {
  a: -0xa002d34fb010dae94e195ed5db6e618a7911n,
  b: 0x48d20n,
  r: 0x48420n
}, {
  a: -0x68d0a2d16e6dc50n,
  b: 0x14593f52n,
  r: 0x192310n
}, {
  a: 0x6361c775e7n,
  b: 0x793545e5b7e5379c805941a41dc1dd814190d9106b62a892ed53en,
  r: 0x2201065526n
}, {
  a: 0x59ad6e826548d5bcc3212d258764eaa4n,
  b: -0xd2757043918b068b3e2c1a9bafb1acf5c268786a8n,
  r: 0x410d0600050854040021202181606800n
}, {
  a: 0x2d19891e6ae315bf149d0a9f48ae32a96cc8fba71bab90796945an,
  b: -0x4e78a314ba1a456f2b05846fcbe57b9ba8a29639163dn,
  r: 0x2d19891e6a00158e141c0a89080e22a90040a8060121901868042n
}, {
  a: -0x592b47008f39779377212946b9793ddc23cb09c3dn,
  b: -0x45dc2n,
  r: -0x592b47008f39779377212946b9793ddc23cb4ddfen
}, {
  a: 0x64f566efa2db9e23cf2c344c8080n,
  b: 0xa69c01ca1354bca02d221be72b2ea8dfaed2efa76f1n,
  r: 0xd020ae22928a01ca2c24480080n
}, {
  a: 0x5095a71712cc3939a43c2324f4n,
  b: -0x1afa8ea93acafe7660bed8f7dn,
  r: 0x50100715004010188034022080n
}, {
  a: -0x68e637522f9b356b19709c082cf9d8fa5c75f19cd2e365f63d9f030d71d7cdn,
  b: 0x67de5ff3f8ce020a41c71d3a1bec04e23a051c4dec19cc7735569n,
  r: 0x64c094268c602080042101a18a004221001000c2409cc2020021n
}, {
  a: 0x5f0b0e55e8a3ad320d07d43967bec6021e3552eada4a5548n,
  b: 0x7b6d445659e52e00ac10416627n,
  r: 0x3965044600042400a810404400n
}, {
  a: 0x7625d36c1c968a7a30c981b562n,
  b: -0xd1775b2bb6c1635eca7ceb3c1c79ce242fdd70n,
  r: 0x142111001482820230c9802000n
}, {
  a: 0xa5144f5c5aa4bc0edc18a577d578513523fac2c8d3cfbcc442e5efc33dd2f7n,
  b: -0x4115efa0444ccdb5e9954d9f6d25756a66634bf5e9532a2326c128debn,
  r: 0xa5144b4c0004b80a1000a1668120012520a84088c340a0404045cd832d5215n
}, {
  a: -0x8f0cbf876cba646dc2a8b41ae475f8dn,
  b: -0x337dcff2b6f362f0d8b641d1840205f30335757c1bf8a82389fn,
  r: -0x337dcff2b6f362f0d8b6cfddbf876dfb677df7fcbffaec77f9fn
}, {
  a: 0xfccf18061c629f0ee686f49a4221f64c703ec92d8937b9a4bcdbe94n,
  b: -0x1e3153n,
  r: 0xfccf18061c629f0ee686f49a4221f64c703ec92d8937b9a4bc18e84n
}, {
  a: 0x195267d7db8cfead35fc022203a1436553f9a787e67435481b2f4cf83898n,
  b: 0xf6cb8b61306485n,
  r: 0x400b0b40302080n
}, {
  a: -0x18c869e09b09a14d54fe0e05b51db11591cd2cb2c5880n,
  b: -0x9f3c408566ff89664a73183c004159681d294e6740a95690de1aebff1488a24620bn,
  r: -0x9f3c408566ff89664a73183cc869f9fb1da94f77feaf57b5dfbbffffddacb2c7a80n
}, {
  a: 0xe96062n,
  b: 0x5e5935d87182564212416cbc884b22a193800b2a94225848cbd6ee0ed94670ddn,
  r: 0x406040n
}, {
  a: 0x7255228443d89da10b9ccc139589aa337a36993f522can,
  b: -0xc4b6df8141c753db8b5c8dca41673a3f948d4c3c03n,
  r: 0x7251208003c88180020448130109a8005806912b102c8n
}, {
  a: 0x97e4c372e41a7749bbdbea5a682532dd7ecn,
  b: -0xbb90a5e1dc2c39f4fab2efac3en,
  r: 0x97e4c372e4027501a2192840200410053c0n
}, {
  a: 0xf0153763f785e2be509e773fc6878e64a6272dcn,
  b: 0xa43604c638d0a5393ad186n,
  r: 0x2600c42850a408225084n
}, {
  a: 0x2367533f5b8c2n,
  b: 0xa1e2bf4fadc385897d9c74f3af246b4aen,
  r: 0x206303244b082n
}, {
  a: -0x9cec6ea2f1ee96b969defcf559a1e2fea113669b7bd7a47abd52774b0d052n,
  b: 0xec28323a5f431ae4ee21100a1ab8173674ae379d87ba0f7bb4e3347f5e66177114f88fn,
  r: 0xec28323a56011804c0211000082010302024219005aa0912004204385422100104288en
}, {
  a: 0x69c418d10506bbfbfe3c2a3e04e422a49939a42e7bf63e3b3f04cc027743a8bn,
  b: 0xee31947b66bd358fcen,
  r: 0xe23190484025340a8an
}, {
  a: 0x93f1345d44c7f68eeb64cb9c38015df0215576c4b8b88bafd130b1ce30260138n,
  b: 0xb88a781aff3b250ba3d2e7c6d653e4854e5ed424ef9b72e753n,
  r: 0x888a600a9c380109a0004546c410a0810e501020ce10220110n
}, {
  a: 0xbbfb6bf4a430797d0231f932a36b18d464f591n,
  b: 0x766647fb258202a461293de8fca8f2n,
  r: 0x2420417900000020212918c064a090n
}, {
  a: -0x68c93bb850300a3448fb81016e49c83b9da6928f9e33c7n,
  b: 0xf209914dba3193eac6a85c60f9d7edaa47ae93bn,
  r: 0x7208914cba3003eac008406040058482060c839n
}, {
  a: -0xb0413b4a90159b41bc34a206cbda92c5136add9d31a41b678453510n,
  b: -0x4174e0322866b3fe1956n,
  r: -0xb0413b4a90159b41bc34a206cbda92c5136edfdf33a69f6fbff3d60n
}, {
  a: 0xa05fe222cf7d36bbd7249c79e9b4506e4a6d64bdfdfdad8516b047n,
  b: 0x55684fef99ce471dffb9c9932b9cn,
  r: 0x14404e4a0944051dfda981122004n
}, {
  a: 0x7e1f0d820a2fa738n,
  b: -0x73bd3bcb4d977d1n,
  r: 0x78040c020a268028n
}, {
  a: 0x35c8ff0fa88171b9e5bdc2cb0f0e039bd1e5d28n,
  b: -0x505483b279c14fcc9b0e940f54743374960f9e188a0e70ed1bb8d742f1b00ffn,
  r: 0x2188cc0b288061a165b18202040600990045d00n
}, {
  a: 0xd4f6d582a6700a7cc389c1cfbe986b36n,
  b: 0xf6a67b666890n,
  r: 0xc0863a006810n
}, {
  a: 0xf35f1b6c76917c717c154f37f33ad5d40a6c52f56cn,
  b: -0xc1058f07787e17335b07380471ba55e72b813506e091b82deeed73b81fdbebn,
  r: 0xc35b0a442210547048110f26431211100844402404n
}, {
  a: -0xe1637aa59638ec76ca0d3fdd25n,
  b: -0x6e68ef74113270ee41eda3c08949b1d3183472c943a9d2a12cf6f455a91654n,
  r: -0x6e68ef74113270ee41eda3c08949b1d31834f3eb7badd6b9ecf6fe5dbfdf78n
}, {
  a: -0x83a2dc29b1076a8de6100bf38b3097dn,
  b: 0xb3827f7f1753f5c83n,
  r: 0x32006f740450c5483n
}, {
  a: -0x13fn,
  b: -0x888d8e80c9b703eb22922d9fd5edde2b97e0b700614c423e93n,
  r: -0x888d8e80c9b703eb22922d9fd5edde2b97e0b700614c423fbfn
}, {
  a: -0x66276b6c26887b7e5fdb48b299d338c07da01ce7b1cd5n,
  b: 0x79b7199127ae47914b92a5fb84986d62e58197cb8a86123669d85ed7aa54dan,
  r: 0x79b7199127ae47914990814904906840000003408202003268005e1180400an
}, {
  a: -0xf9e68e3fabbb7011a4ab9ef34065dfa25647168ca0478882cc970en,
  b: -0xedf884e88458a9d950bbd52fb609a98bb523can,
  r: -0xf9e68e3fabbb7011edfb9efbc47dfffb56ffd7afb64fa98bfdb7cen
}, {
  a: 0x4d646d3005f590feb6462649312be21e97428fe981e0e5b8953159357ff7dfn,
  b: -0x8fa0ede6d334d98c7f3d4c325042bfcbaf82b56e9966300099c17ede62n,
  r: 0x4d646010001100ca264200403109a21c00000069008064988531403401219en
}, {
  a: 0x7603f61672fcf9e12b2b0f0625c93n,
  b: -0xce742bb92860ad7575186a628db6fd5893a024c0n,
  r: 0x7400a0067058d120002a060425800n
}, {
  a: -0x7a05a064862n,
  b: -0xb49b95e0018898f6a77f592n,
  r: -0xb49b95e00188faf7a77fdf2n
}, {
  a: 0x5f04154d68f54030n,
  b: 0xb90c290e0832n,
  r: 0x110c28040030n
}, {
  a: -0xff57a66dd0cdc8fc8f0d1d6c5edbaf50392adn,
  b: 0xf8f1266fa6n,
  r: 0x4000246d02n
}, {
  a: 0x18fn,
  b: 0x9437796ba41afe6a4a076a96b7e54109fd7193c9f6n,
  r: 0x186n
}, {
  a: -0xa39bb6e9797678b9e0n,
  b: 0x14fe3n,
  r: 0x14620n
}, {
  a: 0xe15478d615cd8n,
  b: 0xf03cf37bba7868e974d85f1a449bffn,
  r: 0x41047084018d8n
}, {
  a: 0x9962043069ae73fad3de61febc9en,
  b: -0x8e9773122499ddbf4e6158a71a4fc5d7d0328b84b8d6936e48888c6c7ff6n,
  r: 0x94004304128609093566192800an
}, {
  a: 0xb7002n,
  b: -0x7b07ad148dfa513523245d971d47d96df86f923e17f1c3a29fcbbf13513bc3302830n,
  r: 0xb5000n
}, {
  a: 0x61fb120d457830356b16df6b80n,
  b: -0x4151157fe556fa0c883edcd46feaefe3ba28d0eb5150e65757a0n,
  r: 0x1101005452810242b10882800n
}, {
  a: -0xfb357c4ca62568n,
  b: 0x2fa0e1a6affcc3c35b94816bb6edn,
  r: 0x2fa0e1a6affcc3004a8081499288n
}, {
  a: 0x6e6466841969f61371da76722abf45a8d95d8e5ed25b78ed10aaf8574f038e77fb4n,
  b: 0xe49cd83cb7bb0d1a722e628ef6f99a444c595e379fn,
  r: 0xa094580c959805082026028002a980444018463794n
}, {
  a: 0x824b25bca61d86fdb3bab843dc2e53f96n,
  b: 0x3522e031n,
  r: 0x202010n
}, {
  a: -0xfb493342ddcb0adaf24d75cn,
  b: -0x216fe050a975b939ed611c7f9d6n,
  r: -0x216ffb59bb77fdfbeffbfe7ffe0n
}, {
  a: 0x6c40391ccd23e2a9c7c1437d72e731cc463c50b1n,
  b: 0x4654f9b8ed6da026a4a3b6n,
  r: 0x40407930e52180062400b0n
}, {
  a: -0x1a76b3cbee50c19efde5e2f97cf9fb33a93c2cb73df45dbe42e485ef81n,
  b: 0x589065f8b6b98ef1ad04951b84cf1bd265ed965646cd5b3n,
  r: 0x50800020a09008302004850804040800202412500681033n
}, {
  a: 0x9cbf571a4347880939cef4e6ad00f3560c8d2bf39049f453c8d0552126cc7d35n,
  b: -0x9de60db87d6a3a50c38fcn,
  r: 0x9cbf571a4347880939cef4e6ad00f3560c8d2bf3904020130050010002c04504n
}, {
  a: 0xc86497b4bdcd5a1d2c8ec7ae3e1e1ea4301e19fd079c7befcbc89fc3b92n,
  b: -0x1f2981f502c82e82e030679b813e421ff8e59a1474496n,
  r: 0xc86497b4bdcd5a00040e02ac36101c040018007c019c60070a408b83b02n
}, {
  a: -0x5cd7789cdb61383b2b3bfac2n,
  b: 0xa84bed7f95d36f884115n,
  r: 0x8043241e85c044800114n
}, {
  a: 0xbbcf24f9c2ba97bfb02fd193fc7adb47725f6n,
  b: 0x1b75e127fddc6cn,
  r: 0x1b45a124750464n
}, {
  a: -0xe9a0a9cbd7e8ac15d60ad4f17376139604579f7n,
  b: -0xeaa1af6848d1f8fe6b3297dd26e3afa3beb8cb8286a8cn,
  r: -0xeaa1afe9e8f9fbffebbe97df2ef7fff3febbdf86d7c00n
}, {
  a: -0x6c8b18e11a690db3220a32f2b9cb20a28d1cd82c26dfbdd51a07c5a121287b8f651916n,
  b: 0x7c0a0a47f5bebbf4c5e582520b7f4e589007f5850db3n,
  r: 0x340a0842e12693d000400240083a4e589004708004a2n
}, {
  a: -0x811a066a086abd51256fa9843b3dbf654cbd305490ben,
  b: -0xeb6c67dcce2fa05887bc24n,
  r: -0x811a066a086abd51256fa9ef7f7fffef6fbd78d7bcc0n
}, {
  a: 0x24bcc8b93afb13c60f34bdbc9a3c5c6e45b16c8345ab27ae8421b50eb621e9n,
  b: -0xd789b1cfb0de75bcd79ef428272a27c12883f36f3ded49cban,
  r: 0x24bcc8b93afb1286042004b01824100600b16c814583252680010400222140n
}, {
  a: -0xc020b8e4637f13feeda2f4e3cb553c0e9017f8f0880c9d1en,
  b: -0x400bacfd15509a261ade867e047e5n,
  r: -0xc020b8e4637f13feeda6f4fbcfd57d0fb277fdf8efecdffen
}, {
  a: 0n,
  b: 0xc6936f9a0a07e77a8326en,
  r: 0n
}, {
  a: 0x1b4a135c32160cfn,
  b: -0xf5d38f1a4c079fbca1adef31becb4f1355734ddea6e682n,
  r: 0xa080300101004en
}, {
  a: 0xdn,
  b: -0xccb9132a92328bead1n,
  r: 0xdn
}, {
  a: 0x2c66d4bf488e722f6fe53735bbf4e75c2f87e7986b0n,
  b: 0n,
  r: 0n
}, {
  a: -0x8e163d7e4b6c502f8736fdbe8a865d188be726b873aaa5063fa772cn,
  b: 0x410f6191b6244532bc8n,
  r: 0x41070011122040108c0n
}, {
  a: 0x856534c6f0b35aa7a42c544c660cf1acdefc015a297c862n,
  b: -0xf202ffcd4ad59e79c426048092e055n,
  r: 0x856534c6f0b35aa7a00c50002200a00842bc01122050822n
}, {
  a: 0xb962cd0c1576b56eb15f28bb6316cn,
  b: -0xf55e189bdfe0d3011a970c82db170202b6146b60fd3n,
  r: 0xb86048001524a06cb14928900302cn
}, {
  a: 0xcfn,
  b: -0xbcfff7f564cdd2422ef49db157760fn,
  r: 0xc1n
}, {
  a: 0x5cca77020790b2775a908c10ab3643909fc7n,
  b: 0x24d1f6b7e5bbfe8b2f3c4c5f4b45a9e631ff545895b15cf66e530ace26a0f59e0an,
  r: 0x440077000090b054520000008a2600909e02n
}, {
  a: 0xc44b8n,
  b: 0n,
  r: 0n
}, {
  a: 0x912803ecb139a7231dc700fca6d820364020b6b9dfd2a008266c3a9b9ccb9an,
  b: 0xcec4a52618aaede662n,
  r: 0x80002424188a8cc202n
}, {
  a: -0x761311599a037cf49604072652b206ef371n,
  b: -0x43fd358711c653c84d295c2b9d156ef98n,
  r: -0x7653fd7d9f13fef7de4d2f7e7bbf17efff8n
}, {
  a: 0x5f9d515b9186a5f8n,
  b: -0x97990cdb9dd5dc2eb04720314906aa88c97fb6a8862n,
  r: 0x1515514800842598n
}, {
  a: 0x1aa2c4357a48a979e61edb6543b09fe887f1363fn,
  b: -0xc502913022bc27536fb7fe3c68f1e96e2aed2e1f4da15n,
  r: 0x8a0c4350a48000004185061411011280601242bn
}, {
  a: -0xffe629e5fc5608946ef45e34e8d6ef1c5e9c180bdfef9f86aee89485dn,
  b: 0xdf3ca99eae560230a68af62cn,
  r: 0x163c2902000602100002b620n
}, {
  a: 0xadce536f9a96338481f22475f6bf812bc860ec1b375545282a9a3n,
  b: 0xa367c23055cd31baaec2c820759470ea01b0cf5dc1n,
  r: 0x232040100045112aa8028800048030600010820981n
}, {
  a: 0x7afb08757ac3e9efa64c1ef62189n,
  b: -0x53024135ae077b874a444970c790aca5n,
  r: 0x3aca00700040a1aba60c18660109n
}, {
  a: -0x49n,
  b: 0xc5264b99e5e1f412458876272ab34cc243402e15daf8d8ec221ecn,
  r: 0xc5264b99e5e1f412458876272ab34cc243402e15daf8d8ec221a4n
}, {
  a: -0x46140b3af3fcd5b325b3b6cf861e0911430bb14b4ce5abc7cf674an,
  b: 0xea8df522d1e88339130d8ebd4319fa47f4e1274c6222a64874afd824703n,
  r: 0xea8df1029148000012048ca4401102061460234c4022020024038000002n
}, {
  a: 0n,
  b: -0x8b1903e9f6ebf748c8b4244d0175155ed06709b2ce708cbd39ac247n,
  r: 0n
}, {
  a: 0x226f087baa234d61n,
  b: -0x697847a72e260f78f9abn,
  r: 0x20480059a0030441n
}, {
  a: 0xb6df203dc29a199an,
  b: -0x2f81ae74574d25309c77b4a6938d3a4d8623c301a71be20d3c09e8cf7bde7ff7e9e81cn,
  r: 0x3084200000121180n
}, {
  a: 0x2fedc894f69bd1d210caaa6cb33055b8ac9a9ecbf3ab39f29dn,
  b: -0xb3be5e414c84522ccf50169af4a02e19a2f706abb24222d7d7acb03c2a0c38d312a04an,
  r: 0x29650814d08251001040082c912000100c8294c3c328295294n
}, {
  a: 0x43b7c5639435055cn,
  b: 0x9ada031n,
  r: 0x250010n
}, {
  a: 0x6cc157cfa2cc45c65f61d8026cn,
  b: -0xa8ca10b3c8a31e0n,
  r: 0x6cc157cfa2c441465441500220n
}, {
  a: 0x3d6645707be019e2f83468n,
  b: -0x361a13f7cdn,
  r: 0x3d6645707be009e0e80020n
}, {
  a: -0x765d5afd62e80e22ee7115ebeb636272dd7053en,
  b: 0xa6836858b9a6bad46014f574a9cffe85fedbf5025db67c8db06390c304ff4n,
  r: 0xa6836858b9a6bad46014f500a085028516d1d5000ca214049001800204ac0n
}, {
  a: 0x145974f1c51933c03d14482fc9d68b1636e6e50ac4942f5f8ba1bbcn,
  b: -0xe406c6n,
  r: 0x145974f1c51933c03d14482fc9d68b1636e6e50ac4942f5f81a1938n
}, {
  a: -0xan,
  b: 0n,
  r: 0n
}, {
  a: 0xfc36611df4f7f5f0cbd8b79994ec252e3aa263e54cn,
  b: 0x47dc04e16671611653n,
  r: 0x4cc04202220610440n
}, {
  a: 0x613bc4ff96a96ca083c181a5707c71f7eae93ea35eb76d44ff0f5e0an,
  b: -0x1bb20a525f28ed7b24af7e0c76n,
  r: 0x613bc4ff96a96ca083c181a5707c71e448e12ca0561204405001520an
}, {
  a: -0x7b2d8775f83ca61a40ae34bd58aef6b5d12eeb411115f4fb029f7273952aa8d632ffn,
  b: 0x5c94b3ebab822f01fc3740c93851e061ccac2f1dd5fee93bc878fa6bn,
  r: 0x5884b3418b022701080200c11010e06008042d00858c68114028c801n
}, {
  a: -0x742f037b9e052146314a05be3can,
  b: -0xeb4110cdbn,
  r: -0x742f037b9e05214631eb45befdcn
}, {
  a: -0x220d84906n,
  b: 0x5c3d0f615d59964dn,
  r: 0x5c3d0f615d019648n
}, {
  a: -0xbd00cd19d228fe094d259n,
  b: 0x88e7bf75b5bb93c7eaa36ae961a62n,
  r: 0x88e7bf7500bb12c6288300e020822n
}, {
  a: -0x3de5e418129328900e687be2b71c8e0d67a5a1f6b9656a5af5e40c12b94632e88n,
  b: 0x8e884ecfcf482d7ab9b71701769f484c64n,
  r: 0x88004c08448295a10a11700540b084060n
}, {
  a: -0x867ba3edc0ccb85caf655a7356d238212839faca4c6an,
  b: 0xf04fac43b661b790b1fdd2511ec2450e1a5957b7bcee993336a8114e0b6c5eaf40n,
  r: 0xf04fac43b661b790b1fdd2510440000e1241031098a4882124801046020414a300n
}, {
  a: 0x16n,
  b: -0xe839cedef5f3de6c7d6cd3998cb88872d4c1a37aeecn,
  r: 0x14n
}, {
  a: -0x9a3af98e741b29af1310d9349fe8b92307ef99101f70e3en,
  b: 0xc62b4e7031329a0bef6c4d49a7a22de185c35a8b8718en,
  r: 0xc402400020121008ef24494007020ce000424a8087182n
}, {
  a: 0xb65bn,
  b: 0x1beb16da28f2a7a9en,
  r: 0x321an
}, {
  a: 0x192cb70666a7cde47a3aec14e5cfe9c9n,
  b: 0n,
  r: 0n
}, {
  a: 0x98191b02eaef64f9a2800n,
  b: -0x41fd6ec1270173d72c77f2b41781d44c7f7c0n,
  r: 0x90080902e86e20b180800n
}, {
  a: -0xa98d6ba6258767n,
  b: 0n,
  r: 0n
}, {
  a: -0x4n,
  b: 0xd1304937915548dd4a6c5a872ee1c5fd9n,
  r: 0xd1304937915548dd4a6c5a872ee1c5fd8n
}, {
  a: -0x9d0588caf69d903516n,
  b: 0xe98d6b5c050d3b866b24f401c6162b36bc304887dabac14302c49ee01n,
  r: 0xe98d6b5c050d3b866b24f401c6162b36bc3048860aa2414002049ca00n
}, {
  a: 0x4631aea1af30f83e9d19f3e892673b8a207010375e6f6c9fa5e26eca7033acb7n,
  b: 0xcc8796b87c289089242365ddb6dce6b3260c97f1bedc980ef159a9n,
  r: 0x801698182080802423000030102612260c97a1a24c88003108a1n
}, {
  a: 0x830a9a14dd49f4668645d3c05n,
  b: 0x7a031e25cdb2b8c9d2fef9edc84d3n,
  r: 0x20088109849d0668045c0401n
}, {
  a: 0x4076aebf75dc04bd419e5f7605078n,
  b: -0xa30a3a9c696b66e6fb08d32ecf94240e376fn,
  r: 0x600891104c008d01061d3604010n
}, {
  a: 0xf744853f5d0b7eea93a29120e6910296cfd32612248d1n,
  b: -0x6d1e39a7d0cd288f4aa5ae59b3f6ffe56d59121cf71e5fe4bc29e8966n,
  r: 0xd740851a51024c0800029020e48100808013021204090n
}, {
  a: -0x20ac4c14af260a67be3e54a107d5fe60afc4d09428f2a9a4debdf9e8d0452d8d16n,
  b: 0xd688e5163b4e301ac61392be77592019c680afa1772d82n,
  r: 0x8208e002010e101a0603920c5659200006002fa0522082n
}, {
  a: -0xdd4df70742a47a1f1f54b95cb9960afe615ffd2aeeeb4b9d44dc720b01cdfa5501c5n,
  b: 0x35c5191b86b7e34ce99e50548e2dd36n,
  r: 0x2541110b0623a208c90e40000a2dc32n
}, {
  a: -0xf2495310ef39d599b27d26909f660f12n,
  b: 0xf4d8f14499b67f2fdc543ccf55591e154dfed66dd0adefn,
  r: 0xf4d8f14499b67f0d94042c004408060500d8466090a0een
}, {
  a: -0xbb3e899514024671228n,
  b: 0x6418945d25f97c451b81d23b0b97a30541636a72645076a15da1c46aa95710n,
  r: 0x6418945d25f97c451b81d23b0b97a30541636a726450440144a0844a884510n
}, {
  a: 0xe7602accff340a82f4b231de038fb8508faa4d7f378fdb108d6ee7dda4637cn,
  b: -0x72an,
  r: 0xe7602accff340a82f4b231de038fb8508faa4d7f378fdb108d6ee7dda46054n
}, {
  a: -0x18n,
  b: 0x22fde507b982b60b27b9c1c1ac97ba6889baf8695c755034n,
  r: 0x22fde507b982b60b27b9c1c1ac97ba6889baf8695c755020n
}, {
  a: 0x8fcfd2ad575e46f87a0dace1f24fdcaf7a94ab5af1117a01326fc21a9d1a5n,
  b: 0n,
  r: 0n
}, {
  a: 0xcd979f0d141f5f2c0a525cef7af67c07aecae0n,
  b: 0x62b6d43a08ac5a2e1c58da2fcfc61b04de8608en,
  r: 0x905030000050220000000ec78603005a84080n
}, {
  a: 0xdb9cbef550d22b0940cca4e4bc99bfc9e3f1f168b433f0n,
  b: 0x1eb469a8264352450a141e61d4n,
  r: 0x4a428882641424100001421d0n
}, {
  a: 0x9e984560c54abaf426b75dd7ace3306785751a9a947737681bfaea26n,
  b: -0x1c7071b61942d5396de0c5fcb1ad739744a4e6762d18502488a21e2088029n,
  r: 0x84984140844820f0203445008483302180150a1a9437354819f26a06n
}, {
  a: 0xbbd5654e70e034acd2f13b66cce30a1664d887b21c50c32f2f904c2e3dd835n,
  b: -0xf672cd7n,
  r: 0xbbd5654e70e034acd2f13b66cce30a1664d887b21c50c32f2f904c2018d021n
}, {
  a: 0xd7fe230fffde5934b8a22ddca4cdf3n,
  b: 0x976c97209422fcc985038078e633df42c56c7626abd2202e4fad889cc1e017cbcbn,
  r: 0x56262302200e4924888001c004c9c3n
}, {
  a: 0xbd6961b797b820ef87b0d0fe0n,
  b: 0xf1ff0f715f1ce7f55b4da44cn,
  r: 0xd0960b715b0006f05b0d0440n
}, {
  a: -0xe104cf410464865e68438b555f0e21027e67edn,
  b: -0x2ben,
  r: -0xe104cf410464865e68438b555f0e21027e67fen
}, {
  a: 0x27f050f16e37cb25d21e47948f088a4ace817f8888145f19e3d8b4a1a04e78n,
  b: 0xe46842127c86n,
  r: 0xc02000004c00n
}, {
  a: -0x95906d5f6826420a4204483275a39023b66ed5616511e7ad19b147n,
  b: -0x47fe02a612b477c9ee3579d7ba6c78635c937befn,
  r: -0x95906d5f6826424ffe06ee32f5f7d9efb77fd7fb6d79e7fd9bfbefn
}, {
  a: 0xb710ae3a9f19badb2d03434fca06n,
  b: -0xd192bdc0361999ab1a897d17685320373d66f5e5590e744039e7dfe5459n,
  r: 0x840080208a09189b2c0102018a06n
}, {
  a: 0x5368f6dec6e58d95364f23da09fbe4ad93cc067307bbfaa07n,
  b: 0x6cc187204426961n,
  r: 0x4c0003000022801n
}, {
  a: 0n,
  b: -0x5cdde8583a2c618c9b0c9433661131abef3a90534f5ba84a585f222be99d489n,
  r: 0n
}, {
  a: 0x52aa9990744f268be4e7a2cea0e5546f2786cedbe126b0n,
  b: -0xbbbc7736f09b74b25f33c4075336e73b2n,
  r: 0x52aa9990744f2400208480c600a4500c03868ac8810400n
}, {
  a: 0xd6403c43n,
  b: 0xe4ba017f7c70478ee420c9fb431ede44469236994757b376f025be6n,
  r: 0x46001842n
}, {
  a: -0x614bn,
  b: -0xen,
  r: -0x6150n
}, {
  a: -0x7a87f7dddf04ea471b0ee9c4f2bd649cd5fd7fd0b413bed60702692b2n,
  b: 0xa58a26f17bc4fn,
  r: 0x10820f112c4en
}, {
  a: 0x1adcb5101c6232n,
  b: -0x26efe4n,
  r: 0x1adcb510180010n
}, {
  a: -0xa5n,
  b: -0x2a4873a8dbd0ba3aded1c7f2c25e8833c2fb17dfca3e2b359eb508989d6f2cdn,
  r: -0x2a4873a8dbd0ba3aded1c7f2c25e8833c2fb17dfca3e2b359eb508989d6f2edn
}, {
  a: -0x36632bc3305289334997n,
  b: -0xfaa289eef61901a7073e736e30242aa83f9cb84263051d9fa26208911dn,
  r: -0xfaa289eef61901a7073e736e30242aa83f9cb876632fdfbff2eb3bd99fn
}, {
  a: 0x67f845ba2451fb9b34389600d64590dd177ea22c44243d220n,
  b: 0xaf32c296de9f618d72dcbe90d77b159f66f8ec12f0746b8e1ace2392c22e3fe4n,
  r: 0x472841a80451b1193428860006050098012ca228042021220n
}, {
  a: 0xd91f37ade74n,
  b: 0x38e7af3efe3804cf5967cc56f0376856bb4d3a2f83343f2c9c7742a963061acc89a27n,
  r: 0x1a0489a24n
}, {
  a: 0x8de47a1ab105ca66n,
  b: 0xeb9ea4341c2n,
  r: 0xa18a0014042n
}, {
  a: -0xc42844b749f9c3b1d84f03abf84123e081c73676f07931de6f31225n,
  b: 0xa5528376aa7a3250a29864c9d31n,
  r: 0x8412023088080200820000c8d11n
}, {
  a: 0x6d934f93b4e1946b91907n,
  b: -0x92361507294b53743466c4b6847c5e7a082050b5d0fd70e457a6c382fde14594656n,
  r: 0x98049103400142a01902n
}, {
  a: -0xf3864f13de546n,
  b: 0x744de3cn,
  r: 0x6401a38n
}, {
  a: -0x5f1e858fb7554ef5c6fd28917d2046dd437788125n,
  b: 0x9b88ac4c2f8bfa8776947c34c72n,
  r: 0xa0800442e82da8122940834c52n
}, {
  a: -0x9df5eccd2013f90912dd1adn,
  b: -0x6ef9af4b9810d01b54d36cc140ffa398e6n,
  r: -0x6ef9af4b9819df5fdcd36dffd0ffafd9een
}, {
  a: 0x9f255ddf74cf60b6aabcf0170656dcad7dfc1d6d6f7726n,
  b: -0x1153478d4f9ebd2904c88ba8302e6cbef1efffb2e23275188663b267a75ff6866fd5n,
  r: 0x17055193400e0000081cc00206509c0d18580009691022n
}, {
  a: 0x16ca786011efc26aa39e766e51262n,
  b: 0x83fb7ce02c84d71c33713d7d518d8bd423f0e4731acfc46c8f916b03785c7n,
  r: 0x2c0606010cfc0688390620250042n
}, {
  a: -0x9a1de9c7ff754n,
  b: 0x31e718367065a349bfe89d13adbaa1de50n,
  r: 0x31e718367065a349bfe894122122800800n
}, {
  a: -0x4807daae2099n,
  b: -0xca359dfe1aaf8a0859d09dc80d0fe5277783191044e977d0e75eb2380a762fcn,
  r: -0xca359dfe1aaf8a0859d09dc80d0fe5277783191044e977d0e75eb27daaf62fcn
}, {
  a: -0xbd3429123f4ba67778444f36a06e65fe0fd8338ba3f30e40n,
  b: 0x8aa2ff99n,
  r: 0x800f180n
}, {
  a: -0x1845723b1b4n,
  b: 0xd34db50a9bb0ebc5787c103e4942b01b56769072e66998ebf1n,
  r: 0xd34db50a9bb0ebc5787c103e4942b01b567690726228984a40n
}, {
  a: -0x3d6can,
  b: 0xa99f1ab78053ebd672dcn,
  r: 0xa99f1ab78053ebd42014n
}, {
  a: 0x912182ce3d3514d75a1adf88c95ecaea17f2bf9abb7ed58f6de06f378716dn,
  b: -0x6a7b7n,
  r: 0x912182ce3d3514d75a1adf88c95ecaea17f2bf9abb7ed58f6de06f3785049n
}, {
  a: -0xe8ca9f2739da6a7925fa7a4ceca80n,
  b: -0xdad83d190a12d12f5d03e8c969ddbd4e44f325ccc2fe9a14306ddan,
  r: -0xdad83d190a12d12f5d03e8c96fddbdfe77ffa7efd2ffbfb4fef000n
}, {
  a: 0x8d0cd5da18952eeb9faded0f3ceaa2cb54c3108n,
  b: -0xc5ac8n,
  r: 0x8d0cd5da18952eeb9faded0f3ceaa2cb5402108n
}, {
  a: -0xfa72b5278d297c46d921dbf19c66c2795b14db921ebbe654n,
  b: -0x676b09bd4300f48d2850cn,
  r: -0xfa72b5278d297c46d921dbf19c66f6f9dbd4fb9f5efbe75cn
}, {
  a: -0xbe5d07585308150773b2a046ac63062c792n,
  b: -0x908ee33dae6628b8153f0ad6b6aecb9859e4d6cf84fb6d3b1ffe6a7a987ffdbe587n,
  r: -0x908ee33dae6628b8153f0ad6b6aecb98fffdd7dfd7fb7d3f7ffeea7ebc7fffbe798n
}, {
  a: 0xb4b4aefab01f1b068fb43aaa12c384acn,
  b: -0x9a5c81ec9870665503bad886f6cd2e62bn,
  r: 0x1034a03230191a068410328012010084n
}, {
  a: -0x6d5312497ad4fce7327acaa7eada3277348f3ff6f12aad85dbb62n,
  b: 0x281eace64c0d46b6baed04ae73an,
  r: 0x200c88c2400000069040002441an
}, {
  a: 0xdb96f06617707bcb30a402cc18c8f1ca748f53bbf9e828df0n,
  b: -0xfef8fffbn,
  r: 0xdb96f06617707bcb30a402cc18c8f1ca748f53bbf00020000n
}, {
  a: 0x54f74fbe11ac4ec6an,
  b: 0xa61f68bdd3c80ddf15n,
  r: 0x40f60b9c10804cc00n
}, {
  a: -0xa63dde518cf459bn,
  b: 0xf7918fc53948e00d83cf2a86ffb9a446c97a9603f1fad203508n,
  r: 0xf7918fc53948e00d83cf2a86ffb9a446c97a100221aa5203000n
}, {
  a: -0xd28a06dn,
  b: -0x58ed19ed389fd43d110bb44ea7e5b3a6d4232e6ca82071an,
  r: -0x58ed19ed389fd43d110bb44ea7e5b3a6d4232e6cfaaa77en
}, {
  a: -0x58db124afcd9n,
  b: -0xae25297d58da02c75128ce5d0277b169d24f74107656f09126e9a6f6597176caa25ffn,
  r: -0xae25297d58da02c75128ce5d0277b169d24f74107656f09126e9a6f65dfdf7eeafdffn
}, {
  a: -0x2b3d73f312d7e6cbe9an,
  b: 0xe30717a34fn,
  r: 0xc201130146n
}, {
  a: 0x1c55164b24472013n,
  b: -0xe8766e3019ca54481c8ed00cdbe1c7d35b92e3001dcc1n,
  r: 0x40064104462013n
}, {
  a: -0xe53997fad4516d52fc895d7e140b04a6a5083208c8f5an,
  b: 0xd57f20df928f2929163020f8c1f5ae6c70d7b4bdc309aadd537135bb578b61n,
  r: 0xd57f20df928f29291020208040b0a8285017202802090a951121349b530020n
}, {
  a: 0xeb4bfeff84f91f403db64eb2a78150594422307aen,
  b: -0x4f065017042f975992b063a1245c720b2n,
  r: 0xeb4bfeff80f90f40399048a22501105840220070en
}, {
  a: 0x70n,
  b: -0xe00c6d6f8db48491ce9c4a06cb3d47fa0ec6e3928d322n,
  r: 0x50n
}, {
  a: 0xadadb6bfb06d89bd229ab5677042a7a179a66179174n,
  b: 0x4d82fen,
  r: 0x58074n
}, {
  a: 0x3575fd38863ee99259141170n,
  b: -0x331d4fcd67290626fedcebd28784d20a765n,
  r: 0x251590100002c18210141010n
}, {
  a: 0x8dd17en,
  b: -0xea7aa069e6beaf7180329cd535b9bb449b87662f8b3edc8aead757411442n,
  r: 0x8cc13en
}, {
  a: -0x66d6b6352710c64368c11027a57cfbb45c16n,
  b: -0x61362d2d1aen,
  r: -0x66d6b6352710c64368c11027a77ffbf6ddben
}, {
  a: -0x60c7850889e6566f76df4ban,
  b: 0xc7a4565487b335e3effn,
  r: 0x42a4561081900120a46n
}, {
  a: -0xaac35e1fd4ca785n,
  b: -0x65994dd6n,
  r: -0xaac35e1fdddefd6n
}, {
  a: -0x163ea9e76e5afb9f8d8a7ban,
  b: 0x1d0ecc506ac0615e5e366e11e6b7306abaaf81586dfb5565fcd8fab1979686e4d12n,
  r: 0x1d0ecc506ac0615e5e366e11e6b7306abaaf81586dfb4141541890a104000264802n
}, {
  a: 0xfa36fd3ed4dfff685f79971228969fc7b8c30807b8e34e9ceeb8740f09can,
  b: 0x37d911f6e4e9df8n,
  r: 0x21c8018640e09c8n
}, {
  a: 0x8419826fe38f135bdcf89142f8dc19dc1d7fd06753bfb23fa354919n,
  b: 0x8b7554e6e279bf36e0fb232f0c3816e34997ef837adn,
  r: 0x35154e08040b81400d8012f002012a30017a300109n
}, {
  a: -0xdc1ad0199485c9acd17b7140119926134f6e2b7f108b3a5f287defdn,
  b: -0x3704363c06a69b586311e820f823222f63b3803806fe4d3b6c23n,
  r: -0xdc1bf05bf7c5ebedf5ff715e939fa6336ffe3b7f138b7ffffbffeffn
}, {
  a: -0xece542b90329d385c5d730f02e0a02n,
  b: 0x834ef8a3cdn,
  r: 0x830ed0a1ccn
}, {
  a: -0x25ccf9cec33b6f9db3b740a5986a2d4fda6c4a3ef3f32a7b3f8f78cn,
  b: 0x805cc057a3f1790de0b424c08433e58f65777c631675e8c02492fab52n,
  r: 0x8058000621304000600400800023858220251021000408c0048070850n
}, {
  a: 0x994cc763ba3d770b46a9afa8f9f0197b553b602c91d91f5n,
  b: -0x9410bc27317f2205b24c2e90dfa0d861dc9490118b720ebdbn,
  r: 0x8940c042801d720902812f2059201823412b602481d1025n
}, {
  a: -0x5c2c9f91aeaa3aa9b129e4b7767e5eaen,
  b: 0xe05dd0472d3afcb156d10b215cc42e023aed44e00e8cadbe1867b08a3c25a45d14dn,
  r: 0xe05dd0472d3afcb156d10b215cc42e023ae804200684051c1064a00034008018140n
}, {
  a: 0x5e5e8d6cc1ec0e8dd83357b2e9a4335d4c59837a7e908540dead3f937a27n,
  b: -0x3c8085381837d5ac827beec248ceb871735b6d5n,
  r: 0x5e5e8d6cc1ec0e8dd8335432e1a4325c0001035840108140142828824823n
}, {
  a: -0x584a8f572n,
  b: -0x9517e0a24596a89e5d2dad9bf3fad39an,
  r: -0x9517e0a24596a89e5d2dad9ff7faf7fan
}, {
  a: -0x81092dfa226fcedee76c90058d885079e76014n,
  b: -0xb8389da6b74f383cd07e91195f3f423f2790c755e007f832d86e106c3a0d750d9a213dn,
  r: -0xb8389da6b74f383cd07e91195f3f423fa799efffe26ffefeff6e906dbf8d757dff6140n
}, {
  a: 0x55a0203997f430ccf96cd31a86b45cbn,
  b: 0x91a032fbb463746df0d36n,
  r: 0x902000f924431004b0502n
}, {
  a: 0x1eee780b069174n,
  b: -0x55da21f928544189f903874dfc22108d03075b7e7a13cacedcf5741eac635330491f1n,
  r: 0x14284808020004n
}, {
  a: 0xa6c30ef91d8af3d0791df57daf6ef9d4423229bed7f941ea1295d6ebf290441bbac20n,
  b: 0x9dd169e61e77678dcdfcf201a39cc03d8b00780d990817a74d8cff6359n,
  r: 0x8d1101801e574284cd9c40012298c03d80002009190817210400bb2000n
}, {
  a: 0xe8ccc26a22f9d5b92c8a69047902f638bb00f388f961d68514f85bd76c19f9d262n,
  b: -0x61a986e66d94bde8b3ebcf78ed09cec14f03f6n,
  r: 0xe8ccc26a22f9d5b92c8a6904790296103900920840014404108012d62018b0d002n
}, {
  a: 0x3acca417ec40c4298dcbe11e2aae02df408f16acfd0bac5cn,
  b: 0xe45457b7e0fde3e7754a56b2bd0152f09b58db24326fcn,
  r: 0xc0405684004080c4340042a2a00150009148cb003245cn
}, {
  a: -0xcefc18d9a2b94306b122413a2767b63703227efabed7936a1418dd47adfb7df4ce6n,
  b: -0x8dac2e7n,
  r: -0xcefc18d9a2b94306b122413a2767b63703227efabed7936a1418dd47adfbfdfcee8n
}, {
  a: -0x583ada58f1356fb4c13496ad653fea95787052a96d0eddf5d103ddc94cd895bn,
  b: -0x8718n,
  r: -0x583ada58f1356fb4c13496ad653fea95787052a96d0eddf5d103ddc94cd8f60n
}, {
  a: -0xec753aen,
  b: -0xeeac70c912ccb4a23b2b3da34ac3002c146a389e9fb83b0n,
  r: -0xeeac70c912ccb4a23b2b3da34ac3002c146a389efffd3b0n
}, {
  a: 0xcn,
  b: -0xf04466e1aadff86f51293a11n,
  r: 0xcn
}, {
  a: -0x4f123bf048b20cb93960ef99137f4f3ee9f2a1304c82b3958c005ecfe9n,
  b: -0x8eac02fn,
  r: -0x4f123bf048b20cb93960ef99137f4f3ee9f2a1304c82b3958c08fecfefn
}, {
  a: 0x2d96940aff5ab9d552d2256bbdc11n,
  b: -0xed2d4ee80aa5dd63n,
  r: 0x2d96940aff5ab10502102541a0011n
}, {
  a: 0x1b17an,
  b: -0x2cf555ffdedffd6be157b65e41ffd72e72d575c6f8an,
  r: 0x19072n
}, {
  a: 0x452ca8828a53fedfab3e967a46c2e6277d23d7f50bb885ccb6055304d2bf215f9dn,
  b: 0x644830n,
  r: 0x204810n
}, {
  a: 0x33f66d4d67d773a4e607805e16978fd01d671ee975n,
  b: -0x81110f3d94e7c2b2bced7cdc784df496bcf2a6984n,
  r: 0x33e66d0c26910384c4010012101300901420148074n
}, {
  a: -0xd2799da7888e93f1689907589cc50n,
  b: 0xb1f4783b2f3n,
  r: 0x20f020232b0n
}, {
  a: -0x5b665215n,
  b: -0xc1b8b6e927ac06e77248af077cb21d0ean,
  r: -0xc1b8b6e927ac06e77248af077db67d2fen
}, {
  a: -0xf8094c457a26b3e8ea9bf546bbcc0a183fa1e816a3b068c52fa45an,
  b: -0x9f77a04cdaaa51bn,
  r: -0xf8094c457a26b3e8ea9bf546bbcc0a183fa1e81ff7fa6ccdafa55cn
}, {
  a: 0x282ff05961a4fde8n,
  b: -0x4a04d2558e9f49befcf65373730e9b6ffn,
  r: 0x200ac04841044900n
}, {
  a: -0x71729cec64451ff207b9c524070209f2a78bd5111fn,
  b: 0x560f9b435918577be0e7a7533bb4ed1ab3d6eca67b46b73381cd983756540fc0054n,
  r: 0x560f9b435918577be0e7a75338a0c4103192ac005b042321818d982054040280040n
}, {
  a: -0x2d62a4c53f0794d0819c4bn,
  b: 0xf4fe9ea33b8ad09d4a0d4358d7d4e1b25cb88b2n,
  r: 0xf4fe9ea33b8ad09d48094110840480b254a00b0n
}, {
  a: 0x9c7507c68472879aa950408d3bc803f4affcab746f9001f08eean,
  b: 0x676a562a0787415fdf52c951b5a1a4d75e1c3840cced315b3784c811e91a738f5ef1n,
  r: 0x9c500140842084920810000008c8015027848810691001800ee0n
}, {
  a: 0x36835edf150a4da713eb9a0c4945e1dfe6f6166495868e693fdc2bf1a7059a6983df1en,
  b: -0x255f31f452n,
  r: 0x36835edf150a4da713eb9a0c4945e1dfe6f6166495868e693fdc2bf1a7059a20820b0en
}, {
  a: 0x562898f0e3969b3a3261576dn,
  b: -0xe80ca0694c7b706b4a76ab88b781ea072347829n,
  r: 0x420890406086811a00410745n
}, {
  a: 0xa422b5e4eeb2a60f94a815fda66cfd0bd274513697bb052a58999b1n,
  b: -0x70be96c3d4fa4bn,
  r: 0xa422b5e4eeb2a60f94a815fda66cfd0bd274513690b0040240901b1n
}, {
  a: 0x5a1884cd646bb33cdb9884de9c20a0a5f6be903707a995a33f7adn,
  b: 0xc038e0c4e48996dd6aed21d7fa5307b6bef6f6757fe5676e15ab5fca7746d46debn,
  r: 0x481084c0046ba1305b08844e0400a00476a0103504a11421065a9n
}, {
  a: -0x56753ad29ebc1a778ea1f7c017n,
  b: -0xdfa678eeen,
  r: -0x56753ad29ebc1a778ffbf7cf00n
}, {
  a: -0x73ebaab1a9bc3ee46dfd810ee613736n,
  b: 0x1cc40590849209bb807127bba408a7b0n,
  r: 0x18c0051084000811802027ab00088080n
}, {
  a: 0x7db887631208c36ecee3253f4b57a6b8ee02a6f71bbdn,
  b: -0xfdb91fb4d796n,
  r: 0x7db887631208c36ecee3253f4b57a6b80202a0430828n
}, {
  a: -0x41c00d05e28303caf964419efc5ffa02b436f1f2n,
  b: -0x2686e72275e9c89c54af43d3n,
  r: -0x41c00d05e28303caffe6e7befdfffa9ef4bff3f4n
}, {
  a: 0xe636fn,
  b: -0xb1242f1659577d05efb9823b58dc6fc8f1ad377a3488df3152an,
  r: 0xc6246n
}, {
  a: 0xe7b54a8301a0d6556626084c4540d27b93780f223174022b50bn,
  b: -0xc7831e21d2d47928e6a2n,
  r: 0xe7b54a8301a0d6556626084c4540d27383480d221030002110an
}, {
  a: -0x8d5b0ccc430ce4954e54398n,
  b: 0n,
  r: 0n
}, {
  a: -0xccb8ff33b174d4e81c2fd5da695bf859614f1847ecn,
  b: -0xf44447be3de40c6b5113c1cdn,
  r: -0xccb8ff33b174d4e81cffd5dfff7ffc5d6b5f1bc7f0n
}, {
  a: 0xd21747616a91210n,
  b: 0xec289cdcc7be8ad4dcbf8n,
  r: 0xd00706004090210n
}, {
  a: -0xd54n,
  b: -0x13fccc9c64ec6024672b4d21c39fe5fa3a0623c9299c88f5b8eeabn,
  r: -0x13fccc9c64ec6024672b4d21c39fe5fa3a0623c9299c88f5b8effcn
}, {
  a: -0x76ad583003547a739540d011676e0dc97a96190d7n,
  b: -0xbc072bf1602dd3267ddfdn,
  r: -0x76ad583003547a739540fc176fff6dedfbb67ddffn
}, {
  a: -0xa2a75054848927e969465ef8n,
  b: 0x237f5f28afc10e039c712dd40524b8dcc6dd4dc385c0n,
  r: 0x237f5f28afc10e039c710d5005203854c01404818100n
}, {
  a: -0x5c066b715d941e94747b982725b18612ed94c37ed79a6151n,
  b: 0xa951ba89d16c51891n,
  r: 0x8100b288100451881n
}, {
  a: -0x4856913ad32185b03n,
  b: 0x65109a054c735a054743d4c6b33e69897n,
  r: 0x65109a054c735a05070144c4201e68095n
}, {
  a: 0xaabb4a9f45bedeb40c44632e583825285431400de2677135d1f9d042238162n,
  b: -0xaa3b6987e48459f5f4b34an,
  r: 0xaabb4a9f45bedeb40c44632e583825285431400d4044103011798002030022n
}, {
  a: -0x20901439f120424c09da85831d09d0a452591a5f7c3facb73ec16ab36f971f8n,
  b: 0x78fe840b555caceac5a6a7539b9864n,
  r: 0x586e00081404248801a00441028800n
}, {
  a: 0x2fe5915cf35822db5780a4a3ad4a9b503127e3c3fbce20n,
  b: 0xdcb3becf2efc10c4f0be2ff608d5c67a6466a9a0b51b4n,
  r: 0xdc1114cf24800084700a0a320081840200662820b4020n
}, {
  a: 0xaf878f01318cd6240e8dd37619550f887a1f06ebd04e0an,
  b: 0n,
  r: 0n
}, {
  a: -0x50e34eea063858cb20b95n,
  b: -0xd4bc1b3cc08719444d4baf4185f5fefb527f8d3f08cbc9d338ab1fa4253ef1n,
  r: -0xd4bc1b3cc08719444d4baf4185f5fefb527f8d3f0dcffdffb8eb9facb73ff5n
}, {
  a: -0x72442840ae0beccbc3f9c3ddc1d93c4ee15396800aebef547bd4395ca4ec59e4325n,
  b: -0x74480a4a60ed2a25607317d9da1c413380c82b0688064c158d54a44633dcn,
  r: -0x72442847ee8becefcffbe3dfc7f97ddfe1d797b80eebff7cfbf4f95cf5ee5de7400n
}, {
  a: 0xfdc95eb01f5358d4aaebae61fn,
  b: -0x145f4ed144d421af50c0fcff0a3d696ecd7b228f6c46c5758fca5dd4fc0073d57n,
  r: 0x91891a801011000002eb8c209n
}, {
  a: -0xd2c9a46a50b01b09ef4015b131deed1caccn,
  b: 0x152d2602b4n,
  r: 0x1260034n
}, {
  a: 0x8d438f12803e39debb31aa0n,
  b: -0x30352a1ecd9cdab05d79a4891d1dd24a82n,
  r: 0x408a000036280e2211020n
}, {
  a: 0x935b38796dda6f6baa9b6acd300d4303cd2bfeef498538e9fb9f6533fdb7n,
  b: 0x975d2ed7dc66d2d6b368cfa41ad0f489b2050140c6d4n,
  r: 0x82192ac5100442028128cea408803089b2050100c494n
}, {
  a: -0xdf76c52b3f431334662f7c64e73182812d6563a89625n,
  b: 0x1d40a453d70089d5526a9685fn,
  r: 0x800a000c700890100401685bn
}, {
  a: -0x9ec43dba0c2cc2f377658c258cdd34dbfef5adbn,
  b: -0x5dc6315e31672ff4601ec9fe6243dfd96a9650fe73ffn,
  r: -0x5dc639fe73ffaff6ec3ffffe7ac3dfddfbdfffff7bffn
}, {
  a: 0xe3c6fe801d8bade2415509n,
  b: -0x9e36661cccb5e1e6767c67ebdbab4n,
  r: 0x2304a08018882980404508n
}, {
  a: 0xcc8908d01082bd4f73b2bd6b31a4736497b3a5a70a4705879c751a433en,
  b: -0x2a3b7831578n,
  r: 0xcc8908d01082bd4f73b2bd6b31a4736497b3a5a70a4705851c40184208n
}, {
  a: -0xf56f0c96d07737a467e6216b147308c1949c25a25c72eaafb420bfecc014e9n,
  b: -0x8e90eaa7545d08c158b9aea2d516e6442fa11cbebfccfn,
  r: -0xf56f0c96d07737a46fef2feb7577d8cd959fbfea7d73eeeff6fabfefebfcefn
}, {
  a: -0x2e58e756214b39357cd52110b70f4710n,
  b: -0x2ed90246c55cf4011df306de15046ae84d407ef8982b7c68f29449a5c94e2f3177230n,
  r: -0x2ed90246c55cf4011df306de15046ae84d407efd9e7f7e7cf3975feddb5f2f71f7730n
}, {
  a: -0x704b13d4e5f092a61d40f3b4aa57902a78449a6d75265884e233c3068f2e6a520bcabn,
  b: 0x116e89f42075283ff8ec58d4ab43fdcd3ca918c70d9cae69eb2f5n,
  r: 0x2e08400020281580a840908a41a5491c8818c100908429e0255n
}, {
  a: 0x63ef0f040c92d10afc0db3529ed2d9b63f4d623d7c2bb633a2a63e24048n,
  b: 0xe1f11568ea5770c202eb4bdb9172f9cd1830cn,
  r: 0x40901048a217404200680b921122a00c00008n
}, {
  a: -0x4b9bfebd2c58aaf7ade4bc18fn,
  b: -0xe52d542eba23ba962fa77dbd3472160n,
  r: -0xe52d546fbbffbfbe7fafffbdf4fe1e0n
}, {
  a: 0xb56554f6b0ad36ae2fdc63e8902d93a1b413589746baeda2f9ec19c16791ffb058afn,
  b: -0x72401d6399n,
  r: 0xb56554f6b0ad36ae2fdc63e8902d93a1b413589746baeda2f9ec19c16781bfa01827n
}, {
  a: 0x5fdb1a4c643afd0a7a5cb7f377ab5ea156c30ce12adb70937ac5ce6770a62337n,
  b: 0x97286d78d7260978a31824ed86c0ab1cac579982903c9a5en,
  r: 0x1208257057220820020004e102c020102845880210240216n
}, {
  a: 0x7d907n,
  b: -0x74f966704f89ed090006n,
  r: 0x6d902n
}, {
  a: 0xa97588da45fb8b6b16c647d377ab32b4e0439c9cd5710707fen,
  b: 0x60bf1e78en,
  r: 0x40101078en
}, {
  a: 0xbe28f8745a60a6a874088c2a63fd9556e2949ddf187bed9n,
  b: -0x57569982n,
  r: 0xbe28f8745a60a6a874088c2a63fd9556e2949dda0812658n
}, {
  a: 0n,
  b: 0xc930439012370a05191943aac2d456185caffda0d99aa98n,
  r: 0n
}, {
  a: 0xc626e32ddf14e4017n,
  b: 0x7f3d61d792a9d3bc95f7a8ad1n,
  r: 0x8220c32c9514a0011n
}, {
  a: 0xb891128fded80n,
  b: 0xe46d07942f9540021n,
  r: 0x90028540000n
}, {
  a: 0xc42ef2b051den,
  b: 0x36b557ee0b268aa6a3fe1b7a9bb7859952f740ed659d83d64n,
  r: 0x40650901144n
}, {
  a: -0x23feadf21530e649d0094c083ba72f71a35189d1ca0b0ce2bddda4156c36n,
  b: -0x518ceba2e7f2bffe54c795c865b93f24fa9e4a0a2d2563f26n,
  r: -0x23feadf21535fecffa2f7f2bffe76f79ffd7dbd3fa4fade6bdfff6577f36n
}, {
  a: -0x3a1f610890c2102f6fde5bf4abbn,
  b: -0xe8d5675a58044n,
  r: -0x3a1f610890c210efffff5bfcafcn
}, {
  a: -0xcbd97d51236166c64c307cdc5db5bb735444f7cb87en,
  b: -0xa8a28ef73n,
  r: -0xcbd97d51236166c64c307cdc5db5bb7354ecf7cff80n
}, {
  a: 0n,
  b: 0x97aff060d7a0faf7n,
  r: 0n
}, {
  a: 0xaf9d11350a0bfae751b9034b498ac66ec22n,
  b: -0x328c6e72177c6n,
  r: 0xaf9d11350a0bfae751b9034941808468822n
}, {
  a: -0xc0d20dd6a193128a1c0220ba88f3522c80527dea30fa66f1b7cc3cd33cd23e15d98n,
  b: 0xb8e23c3945f0a2c27a3dbac10eb845152en,
  r: 0xb8c02018405080c0023c32c00298040028n
}, {
  a: 0x6fe9e21f5fd0723388aae49063f4d52cf691f8b2ed0en,
  b: -0xa2f2222984f7n,
  r: 0x6fe9e21f5fd0723388aae49063f4d52c5401d8926908n
}, {
  a: -0x32d988a32c1fca6390dn,
  b: -0xfa44cee24d0029994766b5b9354228n,
  r: -0xfa44cee24d032d99cf76f5fdb77b30n
}, {
  a: 0x16029ccdb89cf0d01f773be84d9c59036c4227ab7a7c9ed1f661d9b6f04c06a21571n,
  b: -0xaf7en,
  r: 0x16029ccdb89cf0d01f773be84d9c59036c4227ab7a7c9ed1f661d9b6f04c06a21000n
}, {
  a: 0x8e6ba70n,
  b: 0x2ad5e552beb7643a4bcc8ca80ac2ca6b0305een,
  r: 0x8020060n
}, {
  a: -0xbc3909ad0f3bebd8ebac1e7bn,
  b: -0x160c4cd313ac306204b9d8e0a3e997a1d3e14baec48887bdf7fee4091n,
  r: -0x160c4cd313ac306204b9d8e0a3e997a1dbe3dbbed4fbbfbdfffee5efbn
}, {
  a: 0xa3e78edn,
  b: 0xa5a08950da3e0a01962a481e066ca1b8105f59c3bc9ce521beb3dn,
  r: 0x21a682dn
}, {
  a: -0x73735bac08f39c69f6aa23075f4be76909705n,
  b: -0xf0b1f1d63680347f752feb49a41f119920ab2d192763d1a7fcb821n,
  r: -0xf0b1f1d63680347f773ffffbe49f39dfbfebaf3977f7fff7fcbf25n
}, {
  a: 0x80b00c92752bf484a144c461c32d9f2765f1d251c5fc29d9c982c791ecen,
  b: -0x54862a21f3ba1ec8e0ad1ecd0e66fca3f51960eb782b77ee4f000ed4897b44dfb6e4dbn,
  r: 0x100090240324008004c0204121082540811201c510214849820491a04n
}, {
  a: 0x8914a7cf7a140026an,
  b: 0x27af3n,
  r: 0x262n
}, {
  a: 0n,
  b: -0xd53dae1960b0b88n,
  r: 0n
}, {
  a: 0x8ede67abfb18b337cb73c8063a8074n,
  b: 0xf1e2bac1n,
  r: 0x228040n
}, {
  a: -0x29233943c79644864547e23f0598eeab42efdece06d68c0565057d6774n,
  b: -0xe4a7de73b5e2d79en,
  r: -0x29233943c79644864547e23f0598eeab42efdece06f6afdf77b5fff800n
}, {
  a: -0x3f45f322e49ce5n,
  b: 0xb279a871e17bac90e09bc1e7f70506c272fd261a335e7782821d6051a1b8n,
  r: 0xb279a871e17bac90e09bc1e7f70506c272fd261a335e7780820c40112118n
}, {
  a: 0x98f1ee80238cn,
  b: 0xf4aa77b7af496cb51a808ea22005826a5c8db04dc7b32fbd3ebed8e52d32fc0n,
  r: 0x888042802380n
}, {
  a: -0x5c0441ea6a55c684f56dba063e7094dab9d9387759ca6ce8823bba4bfcae10an,
  b: 0x51bb7aa57f11an,
  r: 0x4001300151012n
}, {
  a: 0x1a26d980fdf329978761fa4acf18b43111an,
  b: 0n,
  r: 0n
}, {
  a: 0x61b3642a54712a3683bfdd4107d37de1974b1bc1605dcc7fe1ac57c9216e81b1acn,
  b: -0xb23b614aac51992c756d6c286503d47d5651c995eb7d5747c8f451n,
  r: 0x61b3642a5471080482b5510006d3088093431ac02000882e2028148020280101acn
}, {
  a: -0x47n,
  b: 0x6b5b42c57dcbff0791844757b9972n,
  r: 0x6b5b42c57dcbff0791844757b9930n
}, {
  a: -0xe8538f79cd9c08a834a74226d3667945363412dde970f17dn,
  b: 0xb146285f18n,
  r: 0x2006080e00n
}, {
  a: 0xe01a9e6ba22n,
  b: 0x6f5700238474609b712a8229820a10484b68180b8106403c5b49e12be4f64a7n,
  r: 0xe00a8462022n
}, {
  a: -0x3add9d715959b695801c57b073e2ec51bf19cb1a61a40005fb68d585031ec6fn,
  b: 0xe878n,
  r: 0x10n
}, {
  a: -0x76cb53a7483ba958daf7c4n,
  b: 0x577510n,
  r: 0x50010n
}, {
  a: -0xf93c02c5f573ff75cc69fc0n,
  b: -0xc316719fe21f0b01ad50f2c7f4405e6c0564a831f51895eeafn,
  r: -0xc316719fe21f0b01ad50f2c7f44fdfec2d7fff3ff75cd7ffc0n
}, {
  a: -0xd79dd6bae6dn,
  b: -0x88eacf7f646ef6430516868dd1b0ebf157887c2e001c8aeaa45a9f4e745n,
  r: -0x88eacf7f646ef6430516868dd1b0ebf157887c2e001c8aeaf7dfdffef6dn
}, {
  a: 0x51cb93f2d9dd2b420de996f1908d251cf5n,
  b: 0x261200edfede89a3356d2bd8258d119e4af9ce3d02d06a4963f43c8a9n,
  r: 0x489110c08d0842002906a0900d0108a1n
}, {
  a: -0x9a5e7182ea86a0d93bcdcfad8494e81c722459112db4dbb6f6e5n,
  b: -0x95e6e9ea4b45ea7d054660de2a1e1bf0cb5e2706419e7n,
  r: -0x9a5e718bfeeebefdbfdfeffdd4f6edfef3e5ff1dbdf6fbf6ffe7n
}, {
  a: -0x7f9284385c894d5302250abe1a0f30035fc3b240303f3b02031d794n,
  b: -0xbb1d43e4c917c194aff3fc97ec9dbd3cc29ff5f8fe22c4c0eff1d570dcden,
  r: -0xbb1d47fde957c5dcbff7fcb7fcbffdbcf39ff5fcff26c7c3fff1f571dfe0n
}, {
  a: 0xd73f48f0c8ee146dc657da355d00727e02ea4646ed86d18c1090e4366e79868n,
  b: 0xfb6dn,
  r: 0x9868n
}, {
  a: -0x2d958e9eab24d95bedf69b7518f866715ce39187fa74327ec1f6783n,
  b: 0x3cb06n,
  r: 0x8804n
}, {
  a: -0x3d0n,
  b: -0x438749d111c26384fc6beb0473b11c1965b36f1n,
  r: -0x438749d111c26384fc6beb0473b11c1965b3800n
}, {
  a: -0x246948d240670bcbf32023345d1ec68en,
  b: -0x84205451e021fddf170de003ec4349f341511n,
  r: -0x84205657f4adfddf77bdff33ee734df3ed79en
}, {
  a: -0x407c27542817fcf030f3951b93d37f890ed1b69b41b88475855b4bd9n,
  b: 0x7c3c715b38e4465d0eb51n,
  r: 0x6414414030a006080a001n
}, {
  a: -0xf6b2b8501671c8b2c12eafa05e117d05515aaa5a2b40an,
  b: 0n,
  r: 0n
}, {
  a: -0xb472b45771d0b3f6b3bf545c824327968c3f9c0e75dn,
  b: -0xf0b938aa7073f409579a2n,
  r: -0xb472b45771d0b3f6b3bf54fcbb7baff6ffff9d5fffen
}, {
  a: -0x233792525ee371bb2804debe5342cc68676b95d32d5c2n,
  b: -0x811dd9fa96df501n,
  r: -0x233792525ee371bb2804debe5342cce97ffbffd7ff5c2n
}, {
  a: 0xdca94312e6d4257a4060bb2ad91f48a43c373dn,
  b: -0x7adb9f67eff71be2a0917cc38eec69n,
  r: 0xdca94312840420180000a008590e0024301315n
}, {
  a: 0x4726f55496471f45ed85f11886a16608f0e4990e5953d86b6db1e702e025f2c776n,
  b: -0x89b9ce46f475cc4e396ec4e0617bfcd045ec5bfea33n,
  r: 0x4726f55496471f45ed85f11004210200b0a0190c4913906968002202a020400544n
}, {
  a: -0x764f4a37948d03ca8908d8d8ce0d11c9b3dan,
  b: 0xee58en,
  r: 0x64406n
}, {
  a: -0xae62b93650e3d9b2f31098ae4cce9f41997861f22c84a31ba4b3e8d819aeed02n,
  b: -0xb96e1fecd7d07726ede0faa76e6e5eb11n,
  r: -0xae62b93650e3d9b2f31098ae4cce9f4b9ff9ffff7d87f37ffebfeafeffefef12n
}, {
  a: 0x946e73f0d7613b1f5d31aafd8f6506n,
  b: 0xb7e96en,
  r: 0x876106n
}, {
  a: 0x8f986f5b0eb47a67ece90dn,
  b: 0xafb5622afeefc6fb7dedd7bcefn,
  r: 0x2086e4b06b07865c4a80dn
}, {
  a: -0x4578a39eff376706b561aa16046ec280002c38491a35022a18n,
  b: -0x108a1ef9a044cd07d99588cdd50c70c001572cb5n,
  r: -0x4578a39eff37ef1efde1eedf07ffd788cdfd3c79da35572eb8n
}, {
  a: 0xcef736a469af1eb6ef7340a922a25a4n,
  b: -0xdd8fd1ddc0ad5c673cdd83eea1en,
  r: 0xcef7222028221e12a310402020005a0n
}, {
  a: 0xf8a7be4f76a7a4b9f3e9a99fn,
  b: -0x7651b01a14555d7027e0443d9443c4bd5708fdn,
  r: 0x88801e0b4223a43942a8a103n
}, {
  a: 0xffc8042en,
  b: 0x5eed4f85a58849b77d198e14cbb231aa3ee9c2883ec52a0ff4n,
  r: 0xc5080424n
}, {
  a: -0x33ef7177ee132c180an,
  b: 0x64aa2d07b80fbe5f31f023dn,
  r: 0x64aa2c010808801e0130234n
}, {
  a: 0xf192fea547163e7f46a7b18ad0acc6n,
  b: 0x45326fd8e3c4b1a1076ffb6cd36a90db3186503b955a6b7c7n,
  r: 0xf192cc24010432184403b10080a4c6n
}, {
  a: -0xc74dd702154e5ce7d69f23b29262c240f2e925n,
  b: 0xad4cb243ebfca7923e17bbda0295d28a8b073cc0295767bc2d7758e1a4bc925d2n,
  r: 0xad4cb243ebfca7923e17bbda029182028b0628002102060c045658c180b0904d2n
}, {
  a: 0xc61239b4ce6326d7f500a9e9n,
  b: -0xe6addcd5da3f2f9acc8ab7d97a26796e67cecf11aecccc5be7b3679a061b6a51fen,
  r: 0x21220104c0024d1e400a800n
}, {
  a: -0x50de0ac3cbfd704f0c16e80f26b6e0ffea4fba64f2bc0614d3485f1f9ec6n,
  b: 0x42dc51152bbdfeec214b093c5a2069958ab3b71bdaf6b2ffn,
  r: 0x290510103b0d848010001304000090188a3241380e0203an
}, {
  a: -0xf4f2e86e2c86f4638b432n,
  b: 0n,
  r: 0n
}, {
  a: 0xf78n,
  b: 0x4f04972d425c6c907f07d84ddn,
  r: 0x458n
}, {
  a: -0xf4d40acb7e078d5c76267ca9970e0b6bn,
  b: -0x106709444480366aaf39827555d2481faa4f36fae51an,
  r: -0x106709444480f6feaffbfe77ddde7e3ffeefb7feef7cn
}, {
  a: -0xe4e815fbc8211n,
  b: -0xd2c48d161f9f7466c0ae535995510c3b1baa3bn,
  r: -0xd2c48d161f9f7466c0ae53599f5f8d7fbfaa3bn
}, {
  a: 0xf22416294f40d8e17babf54814feabd7e710dea926en,
  b: 0xb2187eec64b2d7666b6c8a1c63d0968a06f5cafb6494b9a06de33f9fn,
  r: 0x722416080140180168a0654804b609438200de2120en
}, {
  a: 0x2f89918edc378974faa435b49103e9a71418309576c89c132d7cb66be95d2daec1n,
  b: 0xf4f324f65b69ean,
  r: 0xb46320540928c0n
}, {
  a: 0x421e7b22e98n,
  b: -0x1n,
  r: 0x421e7b22e98n
}, {
  a: -0xa151f49c812be5374391a4df083a62f965b221n,
  b: -0x42e325cd8715026fa41ae67f32e61b319n,
  r: -0xa151f4beb37ffd7753b7fedfae7ff3ff65b339n
}, {
  a: -0x5d8dd33e9ccn,
  b: -0x3848dd486a241fab89e8edf70272f57n,
  r: -0x3848dd486a241fab89e8fdffd37efe0n
}, {
  a: -0x9f718f3c23c24fa761473eb896add10bdb0c95443540da6a9d4f6n,
  b: 0xe73cbdaf1ac7n,
  r: 0xa33019060a02n
}, {
  a: 0xbb52df7a27876dd46c722853c29n,
  b: -0xe1a97fec4n,
  r: 0xbb52df7a27876dd46c120000028n
}, {
  a: -0x3f5a8ae6c2f9d2eb7ece2492e5f45a2b0f4c0b1n,
  b: -0x120756614d61f27922dce30074ab533ded8a0cb29af4a62fc2n,
  r: -0x120756614d63f7f9aefcef9d7ebfffffedae5ff7baf4f6eff2n
}, {
  a: 0x9c21eb225f66f6efn,
  b: -0xeabf1n,
  r: 0x9c21eb225f60540fn
}, {
  a: 0xf7f550220129d61946182eab64n,
  b: -0x7aff86ae1dc563914d02n,
  r: 0xf7f550000029500002182ea264n
}, {
  a: 0x2e0e92089cb3c927180fd455c24616226e6fff1dc0816aecben,
  b: 0x3e3f1337588ed3c67b01ac7cfd578fc624432a33962116ff9a49e233157e6ec436n,
  r: 0x2a0080089c13890600030011820016220a49e21100006ac436n
}, {
  a: 0x1b22901a440d401168860d6cd8d8n,
  b: -0x585e1cae655c747dad7a56aae32c8c3bc1d13218912b1b3f4897c1960c306121e3n,
  r: 0x32290004005401068820d0cd818n
}, {
  a: 0x944f59869f2fd8a2b991161b5e6c1n,
  b: 0xfe6df462749da77d6e52ceaa78faf3247996c064c824188fb861c10704989b116n,
  r: 0x80444804180f9820810104181a000n
}, {
  a: 0xc6b77ed83f50568f26643f3a866b1c2d6a8be6c5342ca74189c6d3n,
  b: -0x3bb263a7b553071370c3c7e647471a19e71c6f9cb5b504ddaf4f2en,
  r: 0xc4051c580a00508c0624381880280424088380410008a3000080d2n
}, {
  a: -0xc095f9cd621f52c411d95607eec4882ae65855b8625d9948f0dd126ec356f9e4ad6144n,
  b: -0x58c3b214de92bc173e358n,
  r: -0xc095f9cd621f52c411d95607eec4882ae65855b8625d9948f5dd3b6fcffffbe5ffe358n
}, {
  a: -0xabd5aa02b2c34fb66994504e1509eb20762ef2c877029e2fbc92b4f9cen,
  b: 0x5a4e2f484bc1555c3adfefb9cab98d478e129d55103aa4bb15a0e689e4n,
  r: 0x500a054849001048124bafb1cab0044788100d15003820900120420020n
}, {
  a: 0xd788a07cdf2ed04afc7b1c591adf4566ed77b2ed30b75f4dd0a4a05f94n,
  b: 0x32541efb6e238bb88ab5d44eb07c0ff188eb72a46n,
  r: 0x21004912c20022882310442007404d1084a00a04n
}, {
  a: 0xf84233e3db45127b2a317b6b0684ed01n,
  b: -0xf449da3f4d20c04f2dbebb89f57c77c9d03e50240ce112d3a3a92542938f91c6n,
  r: 0x284023c3d304002808105a2904006c00n
}, {
  a: 0x426710a41a04895af452f9210cb484b5a0e5d2n,
  b: 0x658ff5273cb0dd228eb4d35ec91ef7b013281n,
  r: 0x240100012000952204249210c908431002080n
}, {
  a: 0x32f857dd81e8aeb13876993fccd9722250ce75ac37a82f5a47199c76n,
  b: -0xaed1f1967b862144d130d64e0d0bde32d2355d1f069d07a64903e22dd74n,
  r: 0x20e0104581e8a2a03012192f40185200000e058427800b4a41190004n
}, {
  a: 0x7f787c4ae2dc674b0ad0fabb638890e1f609d08032an,
  b: -0xa728e910ebbe63733e19f5804ce2fc94e599d705307d75c64d61c969baf9n,
  r: 0x1e60244a20d0260102408aa86008808120014000102n
}, {
  a: -0x760968f80f6bedabf5c0ac40n,
  b: -0x9355b96d4cd788d5b56205648a65eaa338527f4faea236f2a02en,
  r: -0x9355b96d4cd788d5b56205648a65feab78fa7f6fefabf7f2ac40n
}, {
  a: -0xe452bcd5b969324e9268ef55f9c0een,
  b: -0x33a1939976aabcff6a3de31cc4a8e932b714d96n,
  r: -0x33a193997eefbfff7bbff33cedaeeff7ff9cdfen
}, {
  a: -0xe6dd98d77e0c33dbc16a527b10518n,
  b: -0xf674215844b3813f3n,
  r: -0xe6dd98d77e0cf7ffe17a56fb917f8n
}, {
  a: -0xd7993f67489c04f92505d54540d4399a924afe4548952daa0602b4569d46b51358n,
  b: 0x283c755d38d1bf12e0b545121c13cdf8e57886424f1a70843ebaac2514001n,
  r: 0x808741d3041af02a0a140100412c95001280600051a10843a92280404000n
}, {
  a: 0xf04eec73fb235aacdd1343030bc5137a11c0a06b49d4b6a485cbe28b3d7d8e89bb5cn,
  b: 0xfc11dca357e326ea309f8167d2cd89an,
  r: 0x4109c03424004aa20938140c089818n
}, {
  a: -0x204e9e85a2en,
  b: 0xbfcd6d3ef7c1b901f4c07a201f5593fn,
  r: 0xbfcd6d3ef7c1b901f4c05a200150112n
}, {
  a: -0xd6dd14a9641ed47df8c26ad811cn,
  b: -0x73b0b9891c3n,
  r: -0xd6dd14a9641ed47dfbf2fbd91dcn
}, {
  a: -0x1fa636f6a2ac0c00eeb3fb864can,
  b: 0x6779071a9a6aee50b5694866e38b3ccb8ad3d238fa72f5f20b9f6e6dbc91an,
  r: 0x6779071a9a6aee50b5694866e38b3ccb8ac05008085051f20b114c0438912n
}, {
  a: -0xebdb48d19aaaea73162412c7a0f53dbf7c6dn,
  b: 0xa7d89b7380c553a0385ffbbf6f3fb0ae43733e4323a734f9c932baf003cb21ff8de7fcn,
  r: 0xa7d89b7380c553a0385ffbbf6f3fb0ae431024032225141188209ae0004b00c2008390n
}, {
  a: -0x5b6c239f25461d9b35b89109431550a1fn,
  b: 0xd64cab691921b285839e5n,
  r: 0xc2448a410820b080831e1n
}, {
  a: -0xa928c7f9a0d31d95acb2544c0122b7c358b076513b407eaf8a5bf2e947ffce51b287b7n,
  b: 0x85b6746b9cfn,
  r: 0x1126443849n
}, {
  a: 0xd036c0e83dc15506d62be525ad5a10379017e640488a68ffccb11e4db256n,
  b: 0x4e0e43cbbn,
  r: 0x443012n
}, {
  a: 0x9390a04a187e3ffb1c2ec4d3ca7f4b4dd62a91a44fc387cafca58c6n,
  b: -0xcfa565645bbe77e4960397n,
  r: 0x9390a04a187e3ffb1c2ec4d3ca7f4b4dd20081a00a400080b485840n
}, {
  a: -0xc87cfb0e0fd27fa2832db234f06ed7d39d0687f02a3e53b8n,
  b: -0xa6c88n,
  r: -0xc87cfb0e0fd27fa2832db234f06ed7d39d0687f02a3e7fb8n
}, {
  a: -0x6902ccc5b416e2ab6f0cafdba9bdbn,
  b: -0xba69acf353018e4391bfd1e9273f866eb1f47530c403cea04d267419n,
  r: -0xba69acf353018e4391bfd1e9273f966efdff757eeeb7feeafdbeffdbn
}, {
  a: -0x34da09e003a49066c1f940cf6fc9c74c521aabb5daaacdacbn,
  b: 0xb43f274b223470b1f8552b60e7n,
  r: 0x3230b22145000a055032025n
}, {
  a: 0xca21869ccaa075d7bab70c6c719948b24a734b60e664n,
  b: 0xf2bf8d23b26c5676c21234f98de30058dbd2bn,
  r: 0xc0aa050132285046c210148904a300100a420n
}, {
  a: -0x5871a67db03e23bd2ea42c3848e1f1c33d4134a21590d7ec276e04b2bn,
  b: 0xc78b7a8af6d8bb7e336b054761b846fee6n,
  r: 0x43016082c408a83412220001218806b4c4n
}, {
  a: 0xdb0e5314d386de4a7a9f1b1n,
  b: -0xb4fdc59d140c3a2e4a781fd9f4d7928721a8d28de6c24b23700c293a4f1a4b7e9n,
  r: 0x19045004d386c4006094011n
}, {
  a: -0x468ca4e4cceffad186685n,
  b: -0x521d44469834b365633a4f4n,
  r: -0x525fcce6fcfcfffff3be6f8n
}, {
  a: 0x36bc6298e9075852d3e23becfa0f6ed1f0n,
  b: -0xf79b39ef00253n,
  r: 0x36bc6298e9075852d3e2308448010ed1a0n
}, {
  a: 0xfc1ef8315facf9d4n,
  b: -0x3fdcc9a60efd9ddc10dc19ba5006f7c9cf986360cb650857849001a9f0b400cfb28dabn,
  r: 0x540e4831100c7054n
}, {
  a: -0x8cb436f376713796472557b4c98704c303a96ee53deb982fe0cbb1an,
  b: -0xf8831bbc7eee7d7040ee8260969n,
  r: -0x8cb436f376713796472557b4c987fcc31bbd7eef7dfbd8efe2ebb7an
}, {
  a: -0xd08937cae9bc87cdcd2951cbd05489358a47c63ebacf5c8a34d50b0d78e6dd09d2da0dn,
  b: 0xa462f091ba09906e128n,
  r: 0xa442201192090042120n
}, {
  a: 0xf77c2024df8e6c5f88f3ede60d9af7468773dn,
  b: -0x25f90005ad0c5932afd39f7512n,
  r: 0xf77c2024df8c204f88a12d220c9002460022cn
}, {
  a: -0xda28d7104431f426e09276d88b26n,
  b: -0xdae0e36e45dadd8c4b0b2cf27679f4d65a29c51adfcc8320781n,
  r: -0xdae0e36e45dadd8c4b0b2cfff6fdf5d65b3fc77edfefefa8fa6n
}, {
  a: 0x98f8d45958ban,
  b: 0x4cad51n,
  r: 0x480810n
}, {
  a: 0x1ef8fcff320f26395b04d0b28f4f0n,
  b: 0x57834135e007e25269ea9508b6n,
  r: 0x7834120e0038010490a0000b0n
}, {
  a: 0x75cbn,
  b: -0xb074c1f9a0d69291a7fbcf9a22095n,
  r: 0x554bn
}, {
  a: -0xd661n,
  b: -0x474139a50f4ded3e641cf6b2c5080bb5f52854afbb050507b7n,
  r: -0x474139a50f4ded3e641cf6b2c5080bb5f52854afbb0505d7f7n
}, {
  a: -0x2b8f091ad30d1c28a159646e5a135dfe31d0n,
  b: -0x1ad2b182b76e7b32f3290579an,
  r: -0x2b8f091ad30dbd2bb97b76effb3f7ffe77e0n
}, {
  a: 0xecc126fn,
  b: -0x2e2054ed7506cf7a567905an,
  r: 0xa880226n
}, {
  a: -0x590n,
  b: 0xd29dd81a7b24131499f8cf28660647d8a2d91n,
  r: 0xd29dd81a7b24131499f8cf28660647d8a2810n
}, {
  a: -0x845e92fa2486636cd0dbfa914dfd96518376e78fd61a33f3d5644cab9e3n,
  b: -0x2f0db6ee130d269cacc10456dbf317c8e97133cb2efn,
  r: -0x845e92fa2486636cffdffeff5ffdb6ddaff7e7dfdffb37fbfd757febbefn
}, {
  a: -0xfe2cac898fd2e59486n,
  b: 0xc1f3510f9979bb40f98fce8841d78bn,
  r: 0xc1f3510f997901405106400800430an
}, {
  a: 0x634675f6215378ac71c13a0e7bbeff9359afcc8c6fc746dafcf76b071n,
  b: 0xc092db123ddb9cen,
  r: 0xc002da10354b040n
}, {
  a: -0xc20a2207300d0f9dd1cf62dffabcba826c5f499cad4737bb873efae54aeee5ddb3f7n,
  b: -0x9ef6b51af60dbdf5c7b76bfd3f24e2a11cf27d08e2d74dn,
  r: -0xc20a2207300d0f9dd1cf62dffebdbaf66dfffddfbf6fffbfa7fefbfdfaffedfff7ffn
}, {
  a: 0x293461d17272512f9520265f571674795ee7c52dfe1c7b3c0b7ec236ee8f4f9n,
  b: -0x8ef7f9244f747310437f6d1d146676ad9f3ed7e83d7109c0003827b639f6dn,
  r: 0x293000005230010c85200012420210095260c12816000a340b7ec2104886091n
}, {
  a: 0x1607a44d5ed6e86896dc3f46dbf4649c6074b7542374286b86d8f683n,
  b: 0x90e782df4318206e267ec4c3d03de7a8eec540dcf5c564061n,
  r: 0x90e5028601080064243e4441c005432042054084b04504001n
}, {
  a: 0xb8e774d4f23256fd0ae5453dc8n,
  b: -0x6c087e97ecfe3bf9accb9445291bn,
  r: 0xb08160100000065100610014c0n
}, {
  a: -0x235903383e01ec6bce2d8n,
  b: 0xd94acca25eb62c48aacb5bb30ab69259e256b10883916n,
  r: 0xd94acca25eb62c48aacb5bb308a69041c056110001900n
}, {
  a: 0n,
  b: -0x9c4bf1fcefdfc2966ecce1n,
  r: 0n
}, {
  a: 0x672191bcb02258d5f1724a7adba8dd941ca2facb6d3dbdc7d4fn,
  b: -0xa43fa10cabn,
  r: 0x672191bcb02258d5f1724a7adba8dd941ca2facb653c05c7145n
}, {
  a: -0xda5f81a9ddn,
  b: 0x7cc52eea7n,
  r: 0x580524623n
}, {
  a: 0x61934a901b4789a80e25e398bffa1a72c52479cf62a98a4n,
  b: -0x8f249634f67f028b064e3424e151276115804c7740f0e2b92n,
  r: 0x41014a00004500a80001c318aed81a624520088f0209024n
}, {
  a: 0x454a7db81bb98ce7c2b3d8b73d06n,
  b: 0x6ba506b2008c3bcn,
  r: 0x4a2402300000104n
}, {
  a: -0xe756e69fedb517e8f39a68101fe8a8fe148e630837118fbdf00ed3cba8n,
  b: 0x1c0ecbaf73513dd8a5269902806df490adb4e4f8fddb89be60f57n,
  r: 0x140000ae0150045824260100000cb4108d3484e00400891240450n
}, {
  a: -0x79224n,
  b: -0x55f32964ea90a1435969263541b4dc8n,
  r: -0x55f32964ea90a1435969263541fdfe8n
}, {
  a: 0x81f278f33c147e5091301c71096n,
  b: -0x6a3922d7436b0eb51563dd33f1dn,
  r: 0x81c258203c14704080100040082n
}, {
  a: -0xaea09d8b617672b3b89fbfe13eb84599cc3fd423a0b8fbe6ae07b69d353c1812ea72n,
  b: -0xc93dbb5f37d59162bce6b5a4cbn,
  r: -0xaea09d8b617672b3b89fbfe13eb84599cc3fd423a0f9ffffff37f79d77bcfeb7eefcn
}, {
  a: 0x75a24bb4c5f9e9484a48c8481308e914fd749f1e07ebf90212bc8fn,
  b: -0xbc3a00e3ba2e02ecn,
  r: 0x75a24bb4c5f9e9484a48c8481308e914fd749f0205eb180010bc04n
}, {
  a: -0xef15cdd1f36n,
  b: 0x8ac2bd2fc4a506919071491n,
  r: 0x8ac2bd2fc4a500801020080n
}, {
  a: 0xd58be15163942626c026f2ceb1bcdn,
  b: 0xdbc927d173ae2e25ee18n,
  r: 0x19402240022e2c210a08n
}, {
  a: -0xb9f346308c754b44dd5bbb984576d81266dcbc8f8c938e7c1e2n,
  b: -0x5353f1766f3109ea0eb4aed67c234f4ee6ccafbf905d00533b767df95dn,
  r: -0x5353f17fff356beacff4bedffdbbffcef7edafbffddfc8fbfb7efff9fen
}, {
  a: -0x18de81d53c9b09daed0e31ce90e53ff7477fn,
  b: -0x3c729f234846a1f94a0ab438b3659275fc5cdb2b57942611fn,
  r: -0x3c729f234846a1fdea1ff7f9b3fdbef5ff5cfb2f57ff7677fn
}, {
  a: 0x4aa7f11bf4d5edn,
  b: -0xca16ce72e460b27ec9f834c736c42fff61baen,
  r: 0x883b10000c440n
}, {
  a: 0x74436bda57731fc79e882c50abd17cn,
  b: 0x44904588n,
  r: 0x40804108n
}, {
  a: 0x422ec214c82eab28885c48744bc6435d95fn,
  b: 0x286785d4c568fab1765454f0e966e9bdabd830bcdde0n,
  r: 0x420e821440040b08804c08500982034d940n
}, {
  a: -0x906f22cad2dec223bf32c0e8f01cfc08b8cb0826d85ec43e0e801f17dee2a763d345n,
  b: -0x9ee115463561e279e679a9442c6n,
  r: -0x906f22cad2dec223bf32c0e8f01cfc08b8cb0826d9fed57e6fd61f37dee7bff7d3c6n
}, {
  a: 0xb6534n,
  b: -0xff66bd3767c3331b6206af6520cb2be6f1a63d60d69f9d6d22c61d78d47n,
  r: 0x86030n
}, {
  a: -0xff611fd5f152dea7ecd7b62936c3c8fb0a6e11529e9a1d20e859c760f3n,
  b: -0xc772c0e74c31b2d62fcd7dbe987dff02e8054f8b26dba989n,
  r: -0xff611fd5f1d7fee7efdfb7bbf6efcdffbefe7dff9efa1d6feb7fdfe9fbn
}, {
  a: 0x70d58a1a0f5522d7c682cc3c5fab6a73d5d128c75e823899963n,
  b: -0x6329dc03dc3c53ac91ee82e9576eb0bc75e9aa6ecfeca5n,
  r: 0x70d58808021502140280042017816a0114d0288144001001143n
}, {
  a: -0x75678166c8213d7e68d77f090f7b5428aca2a13f7edbaf41f57b3267261e209n,
  b: -0x7c20dd5eeb856c756652fe19cf15fcc1aa23n,
  r: -0x75678166c8213d7e68d77f090f7fd62dfdeeb97fffdfef6ff5fff37fee1ea2bn
}, {
  a: -0x41b7213f5088b84d1c8dn,
  b: 0x41642b40dce94db4f5abce036791f3a4e4f3781239353a861914397a87548c41fn,
  r: 0x41642b40dce94db4f5abce036791f3a4e4f3781239353a840904087204500c013n
}, {
  a: -0x74d9d3556bd421ce2f399a0n,
  b: 0x95496389c526e3d47d16d7ae3b9a1fa698bbd8a766bad4d92bf310537ab156b375n,
  r: 0x95496389c526e3d47d16d7ae3b9a1fa698bbd8a766b890400aa100116211042260n
}, {
  a: -0x1ce4c2abf285ed4c6b33f3n,
  b: 0xb4b95e34d79b35b8ab531a7e4c5f115319bff7bbaa0een,
  r: 0xb4b95e34d79b35b8ab531a7e0013114011a123390800cn
}, {
  a: 0x611610d2d518754ec433f5ab6b9498f14fd1b95c83c02eb28c15a007878544fdbcfan,
  b: 0x58041f0ddf44b759c732a48938b0edc69ae66330d0e35865f270ec8dcc3ab9e074n,
  r: 0x10001205184406400330a0091090e14690a04000c0221004102004858400b9a070n
}, {
  a: 0x33fdcb9bbf5cc36acc44d77549b249f259e70b3529cfe22671b412cec1e4c0d815d4cn,
  b: 0xa8e3936491090ae19659e82f21557d4ff549728368f635cd17en,
  r: 0xc31140900902418609202901402441b400428160c0100514cn
}, {
  a: 0x3229f13218864274d33a5e2f9n,
  b: 0x1c12cd34455010c9f9001f9bc72c04be2abbe00883e6350d9c927aa5e683n,
  r: 0x3200803200004040032a5e281n
}, {
  a: -0x7f43c4c21c4747ce11ba24f97093d309c59770n,
  b: 0xdc5795fbf4d29n,
  r: 0xd4428563a4800n
}, {
  a: -0xa358992acfb235665f3f12053cb227b59db7be245d1f6e92e567036bfedb07244276an,
  b: 0x304d660aec995b3da38ecb90da61c9b87291c657cn,
  r: 0x1048620840990220810c0a90d8000120709184014n
}, {
  a: 0x5deaen,
  b: -0x101bc27ae4326a3c3473dn,
  r: 0x49882n
}, {
  a: 0xc23918918b19ac214c2c452d3n,
  b: -0xa3b368ea105c28538521cb070e6ed18c0abe1d092149e45ea52n,
  r: 0x802810910100a400040801082n
}, {
  a: -0x246d69cfce18f6d87ad094f55ea2f76e81e92eda4cfa33761e5176n,
  b: 0x7fd9cf4cd0f54b7f3827d05b237602c6a58d61n,
  r: 0x5094b08805508113806d00123040080a18c00n
}, {
  a: -0x4n,
  b: 0xf800372ee797a7a6f059a777c6d72f20eb945c5dee7b7n,
  r: 0xf800372ee797a7a6f059a777c6d72f20eb945c5dee7b4n
}, {
  a: -0x3146dcc1cb254b5f5a8e79488d775c2c44dd91a4450d8fn,
  b: 0x9fc2f4d9824f2b731b6b9e5132878c4d0f03df25216a9a932aeb4e97327dn,
  r: 0x9fc2f4d9824f2b4219231e10128480050102972000229293226a4a923271n
}, {
  a: -0x73en,
  b: -0xd213d905ebba9700dc02cec4324a0b4cd829n,
  r: -0xd213d905ebba9700dc02cec4324a0b4cdf3en
}, {
  a: -0xb0057d8a1f685dd7862c8491b393f501f6n,
  b: 0x1690348299327c5c7b0d9a72395c2bfn,
  r: 0x14001822041c33048042000c20an
}, {
  a: 0x178e5n,
  b: -0x236b8aa73cfbc82dc79fccdfeebf193c632en,
  r: 0x118c0n
}, {
  a: 0xe5ed59n,
  b: 0x67a169842c10e9be51188825cc9fdee9ebab165b08e159n,
  r: 0xe159n
}, {
  a: 0xeb66f4f4d1a4badn,
  b: -0x6c9f39baff3173e160b028a29b64e566a6e757d39057n,
  r: 0xa90490808084ba9n
}, {
  a: 0x39ebdb8a8105e3fb19f73ee7edfbf8ff2031792045c268cdn,
  b: -0x96ea47202d7cece31432e205c6b24bn,
  r: 0x39ebdb8a8105e3fb196114a0cdd280130021490040004885n
}, {
  a: 0xec375cc6c914cbfcd57e2315ca80fbfe0d78db2496811733e082n,
  b: -0x9e952ddf558dd407n,
  r: 0xec375cc6c914cbfcd57e2315ca80fbfe0d784120920002322080n
}, {
  a: -0x8322872e3c6a934c4185567n,
  b: 0xa56ffe358121be701e6d5ed73cae6c813107733c25fe4cc3550d41bd4452ddn,
  r: 0xa56ffe358121be701e6d5ed73cae6c813107733405d60c0011044139440299n
}, {
  a: 0x6e878ef68709257249aadcf8c371d889be1c5e59167cab720f25107ac6c68b576ffn,
  b: 0xf354e78c190b15a7b5093550cc7b94bcc0d4dd34d111ab7241194ean,
  r: 0x2150418818080121900934104c59143c80500d241010824201114ean
}, {
  a: -0x7fbf866974ff5d5679fdbe4ba5f95eee327n,
  b: -0x57a3c2d31c5d616d9ecf119350bd76e60a97da693de8c5605a27df049fb3643ea290n,
  r: -0x57a3c2d31c5d616d9ecf119350bd76e60ffffa6fbfeff5f57fbfdfe4bffff5fee3b0n
}, {
  a: 0x574d564afn,
  b: 0x308e66781db0c9fefn,
  r: 0x1500404afn
}, {
  a: 0x686ada7d13526451fn,
  b: -0xdd926774ef68bd817506d00715fe4dae9f7547cbc939ed75bcadfen,
  r: 0x424861000024002n
}, {
  a: 0xd6823f05ba2103d587d14efc57f1af95aa877978ba95c0773n,
  b: 0xd04736a9b47fb5243b61233db4bbdc914b7d8eb74d71a5dbddd8fn,
  r: 0x16803405b0200341031104b854910b158a874970a091c0503n
}, {
  a: -0xaea9d80cf0484bf98573373b104699b794b268984c4455a2910n,
  b: 0x49bf3bdf59b83e4ecea2601n,
  r: 0x40082b4d1120320a8a00600n
}, {
  a: -0x6a59342a714c57b3f695da2769f1ace54fa737ed1a560cc8n,
  b: 0xd28ef3b68e471719695d27b85cn,
  r: 0xd08602120a001008004521b018n
}, {
  a: -0xda5c20f04493b95b08ea86db6f28e8805e85b257592dbc83391e94n,
  b: 0x5e71c117n,
  r: 0x5c40c104n
}, {
  a: -0x60a0c3421d1a8c57c32fca5850e6db15d982ab26692n,
  b: -0x1c4ca0a8a25f726336f9a03bn,
  r: -0x60a0c3421d1a8c57c32fceda5aeefff7ffb3efbe6bcn
}, {
  a: 0xfa5a1d5c7a0c74b116208bfcdd40c7n,
  b: -0xd73188n,
  r: 0xfa5a1d5c7a0c74b116208bfc084040n
}, {
  a: 0x9dd19cd5b9en,
  b: 0xfc02e35a60ad7fc8f8d1557074fc8c887ef9bcb21139e21b815666cd63e38cbcbf2an,
  r: 0x1c1088c1b0an
}, {
  a: -0xd40a8be01a1763f1b43cbc2594f17d6291538af8b8a156f7362n,
  b: -0x5b8897n,
  r: -0xd40a8be01a1763f1b43cbc2594f17d6291538af8b8a157ffbf8n
}, {
  a: 0x4bc3bbc1d16624a3ac4f258c0756fb8ffe971n,
  b: 0xbe2acbd349d3661e639105794a47a738n,
  r: 0xbc08024248124412408005690847a130n
}, {
  a: -0xd39ec3f03903802e36b3adcefc228afb325cd7c700588f450c402c749eb03n,
  b: -0xa325eb253be03f60e6df1972c916e2747009067826defdabf7ae7f1b950n,
  r: -0xd3bfe7fb3d3be03f76f7ffdffeeb9efb767cdfc7787edffdaff7ae7f9fb50n
}, {
  a: -0x87n,
  b: 0xadc085ba5e975768288n,
  r: 0xadc085ba5e975768208n
}, {
  a: 0x5d522c733bf120a158bf33441aa23d293f1abff143d23ca0474d1n,
  b: -0x6e7a9f129280a62a8f8162f48be902e00451f117b7eb9c39f4e991e008b4a39f04bn,
  r: 0x55502c110b7000a118bb220408001421060a166003d2080040491n
}, {
  a: -0x64aed750ffbf75e79234n,
  b: -0x53bcf0f50062e9468bbbc2e283dc6c9be6a85973n,
  r: -0x53bcf0f50062e9468bbbe6eed7dcffbff7efdb74n
}, {
  a: -0xf17b8b29a3b9dc5bacfcf13e29b4246d8786305d0bd237beda74a5f36cn,
  b: 0x32aa959be73c8f4e390643a5c9n,
  r: 0x30288582e42c88402102420480n
}, {
  a: -0xf1fd45f2dc51dcdb6913f8d72231cd3f78dd9dc8d766960fdaa8277bb56a82beaf02n,
  b: 0xbc8995af8a7635183420n,
  r: 0x240190840a1435001020n
}, {
  a: 0x9ae18c73309387807d796b354baaf10fa078a530n,
  b: 0x7797942da7681bb399118176d47eb705b7cc5f3449d2c6f94138n,
  r: 0x1aa1881100128400350123044b20410280780130n
}, {
  a: -0xe81fc8a90fbd996f72c3a429fn,
  b: -0xbfd9e3792fd01n,
  r: -0xe81fc8a90fbdbffff3fbaff9fn
}, {
  a: -0x8080c8c422n,
  b: 0xa14b6652b130fa5d535d52a1d56ed5a4ef59b3b72e3a442ae1f1acf25acae7c22886n,
  r: 0xa14b6652b130fa5d535d52a1d56ed5a4ef59b3b72e3a442ae1f1acf25a4a67022886n
}, {
  a: 0x60ece8b2e71dec296351584d8113356e5a0814df43f5dca1127404ba01n,
  b: -0xfa65b3d757ee0d0df02d15abaen,
  r: 0x60ece8b2e71dec296351584d8113356e000804080011d0a00250001000n
}, {
  a: 0x10470e7555e82cd326a7fb55465c65350f80fn,
  b: -0xd49dcff932806827a95n,
  r: 0x10470e7555e82cd326236210064c65150800bn
}, {
  a: 0x39f0n,
  b: -0xc6684403609c2eb5d03487276410a0183e2f8261636a4n,
  r: 0x950n
}, {
  a: 0x5d0baec0632982da3ca342fe78b38c41febae7fd103fdc13f74cd9f5cc7591n,
  b: 0xa6b7326ff0417e512381c23c5ec7dc099dd95b2f6d3c3a485155935d2076071ea5n,
  r: 0x100ba04062010280002042c658018c415a2a653c10085011934c0074041481n
}, {
  a: 0xb31dacdc16b9dccd363171d14ef5ac34ee6ab1dc1e7da5c16383f32c690fa2n,
  b: -0x72d3d2919ee029789d4cc6f356f411cafbb48d870dadc8476n,
  r: 0xb31dacdc16b9d8c0021060114c602420220080901e61004023038324210b82n
}, {
  a: -0x2aan,
  b: 0x377bca59b5b3e24f80eee7281fc191d9be8cb2n,
  r: 0x377bca59b5b3e24f80eee7281fc191d9be8c12n
}, {
  a: 0xb97d1ba6248a1cac0ee9f00293e9f102872e5cb7df4b9bbeccc3d49a7n,
  b: 0x724e240ef57a9ce2f08a1bc03e90f7a31f60baf3887f37685825abc547f909eed9n,
  r: 0x11290a2600801c00080970009209a10087225485824a98144c8094881n
}, {
  a: -0x9eed7afd4b7ac134n,
  b: 0xba29f20012a0c942ba68b5dc61e6e106f895eab840cac5a08647b341e32d10d9f6an,
  r: 0xba29f20012a0c942ba68b5dc61e6e106f895eab840cac5a08646110040290051e48n
}, {
  a: -0xb2fe2d974b3aa98f24ddf943e8307e7ed13dd9b52ccb03bec4d209df701f36f15cn,
  b: 0x15e9bc3e0bb14a76fdc0a13dn,
  r: 0x14e8003a09b00006e0c00024n
}, {
  a: 0xf59n,
  b: -0x7n,
  r: 0xf59n
}, {
  a: -0x6e835c9b751a05565264n,
  b: 0x30e11bec4fan,
  r: 0x20410a88498n
}, {
  a: 0x588018aa364af75c0bcn,
  b: -0x2c1c4e7960073216bf9c857c06487f54e6db5867c9821138106d02n,
  r: 0x48000022164876580bcn
}, {
  a: 0x1e464c1919cbac39943a62b8984da08acae4dce276fad2c0n,
  b: 0x49807938a966a0dn,
  r: 0x80048202924200n
}, {
  a: 0x6c07ea5ff12a9e960302bff4a94b17a9e4511fn,
  b: -0xf3138bb0f81d74ce8n,
  r: 0x6c07ea5ff12a9e960302b0c481401028201118n
}, {
  a: -0xf92bc0fd8108689941faf1121n,
  b: -0xff9ec387d04328dcn,
  r: -0xf92bc0fd8ff9ecb97dfef39fcn
}, {
  a: -0xc1113f4fc67ec53af1fa070bn,
  b: 0x3ba41861c27fe31e64f16bf646f8513106e4a29de0b7812322c2c068fbf440dn,
  r: 0x3ba41861c27fe31e64f16bf646f8513106e4a291e0a4010300028040e054005n
}, {
  a: -0x275f7bcdf129n,
  b: 0xa7662279n,
  r: 0x84220251n
}, {
  a: 0xe2433348735f171c4f59edb864ccc26fn,
  b: 0xfb362592270e3ae55c55dc97134n,
  r: 0x300625902104308458044c84024n
}, {
  a: -0xf00a28978833456b156bn,
  b: 0x586fc612affb5bb797a500bf0de1bf347e856933a1b723fb706bf048fac210ab8n,
  r: 0x586fc612affb5bb797a500bf0de1bf347e856933a1b720fb50628048ca8000a90n
}, {
  a: 0xf0aa2f08fd7adb5462n,
  b: -0xdc3eb704e48n,
  r: 0xf0aa2f003c108b1020n
}, {
  a: -0x364154b7031730b1f09a583cf6be3d374a72d0dec7695b8dc30bfba8n,
  b: -0xd0a584a89126f1b8772d48692e3c0c411239b68164en,
  r: -0x364154b703173dbbf8dad93effbfbf77def6d2ffc7ed5bafdb6bfff0n
}, {
  a: -0x73af75n,
  b: -0x96874c53ad012fb90fbf824b96c5ae7bfe0199fca644da7a831a8a55a0e4bn,
  r: -0x96874c53ad012fb90fbf824b96c5ae7bfe0199fca644da7a831a8a57baf7fn
}, {
  a: -0xe846870c90d5561f44e80b05102cda8d899e374daa0fcf1aa379248e22aaf5671faf1fn,
  b: -0x73c7a874e79dff68a0edf8a67ce3ecn,
  r: -0xe846870c90d5561f44e80b05102cda8d899e374dfbcfef7ee7fdffeea2effde77ff000n
}, {
  a: 0xb3fb2d70b1289211d8n,
  b: 0xac6ab8bccfd10ab03f67cec64f5f72681f68186b8a83aab4fn,
  r: 0x81f20100b028120148n
}, {
  a: -0x255afa7e3a037d8db8d5d4b6d6fb8af5fcf99e9a432n,
  b: 0xbabd2a21f42734f0671fcca28be54fcb324af31dce38c020027da6n,
  r: 0xbabd2a21f4252050401c4c80032442823002900540200020025986n
}, {
  a: -0x3e3d8330d358b0dc8856f783b75430334a5221be45153c546bece14ec83bc2c950824an,
  b: 0xf0187a0856ca69fa5c8a9a6bbe11e68b3f02da685be0b4ed09cc69b4dn,
  r: 0xf0107a0006c008b85c8a1a49a411a6883a0040204b003441014861904n
}, {
  a: 0xb811ca6dfba6c7666d41f9a83n,
  b: 0xa08dfb3373d204be6e9a5a9ce2c29ddc8532c5dd1n,
  r: 0x28104a0ce28285440500c1881n
}, {
  a: 0x4f6860b74b19a9248fn,
  b: -0x9d0ad87ef6e90c629aa8947245n,
  r: 0x9006095411129048bn
}, {
  a: 0xa3024a51209a619a0089bde47563135c900f31fee1c53fbc3284c38501a88ed3an,
  b: -0xda902f06bf06627221ddbe00311549ffa608f828b19101b3n,
  r: 0xa3024a51209a619a0000bd04140311589002201ee0c42b200084400500a08ec08n
}, {
  a: -0x1551n,
  b: 0xe9019953a49e9aac85195184d969602e93n,
  r: 0xe9019953a49e9aac85195184d969602a83n
}, {
  a: 0x59f9b77737df8bea568d7376ff10bf95409e10b07681bb9f6710f0836a55306303fden,
  b: 0x28921d62fba3a1add830e8966cn,
  r: 0x89014600b0020a5500020164cn
}, {
  a: 0x103b2189c9d83bf0b710d539b43636ed81356306dn,
  b: 0xcf642e1986fc91527cd7de7695661n,
  r: 0xb6026108438901234c5803401061n
}, {
  a: 0xec0c96a06f8a64bf61ad74a72f1b78b95adb9a34b478f31b68n,
  b: 0x79bdddfcb07ce7eb1d1b4171c15b30db6391ff42f8b47523935dfebfn,
  r: 0xec0014a06b080001618150200b0310b942d890342010511a28n
}, {
  a: -0x99e092fb40a56d70001c5433783802f986951a7483a027b20ca49066373919314n,
  b: -0x7352719e69124fb445cd5979114b5740026725c6333an,
  r: -0x99e092fb40a56d70001c57377f39e6f9a6ff5e7cd7b7b7b6bdf49066777d7b33cn
}, {
  a: 0x40d986b2b5e403e5931c6c8d56c3f57ed1b32860728b4b5aa3d3523n,
  b: -0xc16a5f770618dd8n,
  r: 0x40d986b2b5e403e5931c6c8d56c3f57ed1b3286032810008a1c3020n
}, {
  a: 0x1982n,
  b: -0x56cb6377533e06f15420342n,
  r: 0x1882n
}, {
  a: -0xb08de8f4479fn,
  b: 0x44706e99f2e47efbdd8b53e67f7adceeb62454b7331dccan,
  r: 0x44706e99f2e47efbdd8b53e67f7adceeb62454213019840n
}, {
  a: 0xe1b33206982b8f0012a89180d3d2347d035f7731983n,
  b: 0xc66252b9e6ba99ee1e302edb4bfe5efd4090de958220aa50dn,
  r: 0xa1a23200880a000012089000d140105c01022020101n
}, {
  a: -0x1ff2772b0ec15e1c2c570100n,
  b: 0x487ce97630f13d6n,
  r: 0x6808343081300n
}, {
  a: 0x90ba21c1a8598f4f88e6b61020c36eb8913b7d0605de40bf01c1578n,
  b: -0x3c83dc159ed54a1f8add9534ffdn,
  r: 0x90ba21c1a8598f4f88e6b61020c34238012a610205c0402200c1000n
}, {
  a: -0x3dc9d5fdbe8d783853d5bn,
  b: -0x22123babd686a56dbef046f8930bdcn,
  r: -0x22123babd7debd7ffff8d7fb973fdcn
}, {
  a: -0x95c6368e254406db86cf44933de7af200n,
  b: 0x2e983an,
  r: 0x40800n
}, {
  a: 0x2fa82a5f9cedafe037d22ecb9d1b06eecn,
  b: -0x738f101a0c89bb4df5e2fb685ba078466f945ece0b9dba690865f1acd65ba82062208n,
  r: 0x212020420484a78006522880151b04ce8n
}, {
  a: -0x453f116ebc572f4a9999b6n,
  b: -0xb44b3d1dddfce498b68704425d20716a34045979e0cd2n,
  r: -0xb44b3d1dddfce498b68704465ff177ebf576fdf9f9df6n
}, {
  a: -0xca75c8f86a4een,
  b: 0x58c22d319f249733c6b20143cac2de2ff71fdc1c79888db6ed21de10588ff1d8n,
  r: 0x58c22d319f249733c6b20143cac2de2ff71fdc1c79888db6ed21580050095110n
}, {
  a: 0xe7542feeec53a75855055010637a51f7571070n,
  b: -0x23babd9e47ffb81c94defa7ea4d84a27d3ddb0403e16dfa7n,
  r: 0x44236a2001815805055000224a11c1410050n
}, {
  a: 0xe4e4an,
  b: -0xdb40ae03b6e4162b9385252d3034c8f3n,
  r: 0xa0608n
}, {
  a: 0xe88f5000eeaabd0c3e39a28613e1b9a917349a252d963c0c5530n,
  b: 0x5d9ff3e89d605cde4287e53e2ef4f068n,
  r: 0x8613e099201414020525162c045020n
}, {
  a: -0x64391906d856bc493b48615b18ca4c204467cb00048497601a9727ea2c0a5n,
  b: -0x713719c2e5d1ce336f005c3533c94e75ace95df3fac111978af5be7dfac49c8941479n,
  r: -0x713719c2e5f9df37ff56fc7d3bc96f7fbceb5df3fee7db978ef5bf7dfad7bfeb6d4fdn
}, {
  a: 0x2988d412cbn,
  b: 0x5c5d735a7e00f01en,
  r: 0x80800100an
}, {
  a: -0x90122f807b108e79e9516cn,
  b: 0x10e0dfebbn,
  r: 0x10604ae90n
}, {
  a: -0x33960f9cbda197112d6acceda208cdfb5184bc3520e6ac16e942d3aa4c7fn,
  b: 0xf2a4fa0574b16393b25f07905002b2512e58af00c1bfen,
  r: 0xe02052012491630002470410000090100048820041380n
}, {
  a: -0xbn,
  b: -0xef77003bef618af66164f05cb5779db13b99ee6fn,
  r: -0xef77003bef618af66164f05cb5779db13b99ee6fn
}, {
  a: 0x81dff586375069e6c96cea3eb1051cc6en,
  b: 0xcf91c427daeca7feb9f86a52c97bd75bfc74ed8aeen,
  r: 0x80ca758217002124812c603e81041886en
}, {
  a: 0xb420dc7403f433d693e3c3bbcbe26c4c2aa6304b53d0f0ad34ebb53ac8acc2dcd537cn,
  b: -0xd7dc77396b98dan,
  r: 0xb420dc7403f433d693e3c3bbcbe26c4c2aa6304b53d0f0ad34ebb5328028804844324n
}, {
  a: 0xd7d35770a95d9656cb7cffae7e85b61e1d6c2b0a1fn,
  b: -0x5b6ec8900eeb4fa28d6dn,
  r: 0xd7d35770a95d9656cb7cffa4100526101420090213n
}, {
  a: -0xbb9a5fff2bd8c113525b25fc4bfa2c1be3439c577d8557a708758babebf7d4fn,
  b: 0xc302684eeb35a8b57dcn,
  r: 0x8000600a60140000290n
}, {
  a: -0x8e2956cc6aa01e612d0592308c2482bd02e0dn,
  b: -0xb3n,
  r: -0x8e2956cc6aa01e612d0592308c2482bd02ebfn
}, {
  a: 0xd8781860cb84b90d95317ef87e79170ebffc7b4b326a6c770dd838852d819n,
  b: 0x9d8846ac7b5bd5041aa7f35cc2c76041a44ee33ab0b04471cbfdbc8n,
  r: 0x8804a80911110418267114028760410002622830004030812d808n
}, {
  a: 0x2b2c7e89b499d4a4fafc556b47f3aab592bd748aadfc1145d94n,
  b: -0x9734a4c3a11ba95fe5a96a3n,
  r: 0x2b2c7e89b499d4a4fafc556b47f32881123c548004a01044914n
}, {
  a: 0xdb677409b614n,
  b: -0xa7n,
  r: 0xdb677409b610n
}, {
  a: -0xaf97n,
  b: -0xcf33b777fad0dadd506f5ca568e5b107beaf7c293cc8653ead50fdn,
  r: -0xcf33b777fad0dadd506f5ca568e5b107beaf7c293cc8653eadffffn
}, {
  a: 0xan,
  b: 0x78b3f30dn,
  r: 0x8n
}, {
  a: -0xe02d8d8f1d4b4aa042e4b5fd14544456f8eec605d06bfc4673a36n,
  b: 0x3cc9ce1545n,
  r: 0x9880540n
}, {
  a: 0xf33d2cb5c54n,
  b: -0xcbe6a5b1707bccd24cea3752259c053982321ed99e7591042f6e106f62cdbn,
  r: 0x912d0095004n
}, {
  a: -0x68eef9411f533685d5b441e09d2dbd25b0f0b57n,
  b: -0x169963ed3b84192c9a26e6202a383c3a5an,
  r: -0x68eef9699f7ff7bdd5b6c9e2ff6fbfa7b3f3b60n
}, {
  a: -0x57d202d29d76fd797f808a6f44aff4f2b657c0a8e542n,
  b: 0xb7b9e8bn,
  r: 0xb531a8an
}, {
  a: -0xf126f17c4f9c79700d3d1d9ba48dcf5b2e447fccba4n,
  b: -0x96eb132a83695b8982e2147n,
  r: -0xf126f17c4f9c79700d3d9ffbb7afcf7b7fcdffeebe8n
}, {
  a: 0xab04fb3b57d17fn,
  b: -0x99d826f91e928a0ceff5c401n,
  r: 0x2904f31002117fn
}, {
  a: 0xdd69daaa7aabc8e95cd62f8dcc458ffd36a3d38b0f7b5n,
  b: -0x9ad5098416aec378b9c9a457fb4n,
  r: 0xdd69daaa7aabc8e95c442a844841013c0602120b08004n
}, {
  a: 0x694e679af46ae5850893191cf71918a4ca286b7690446c35fcd09eba12n,
  b: -0x76564b061d6b313eacc08cd40fc04727c8n,
  r: 0x694e679af46ae5850893191c810910a0c2004a4010046021f010989810n
}, {
  a: -0x3f74e7a88b09252a5efaa112877719081456c2e6e86fd46490d802f9a6ffe13748b0n,
  b: -0xad86a82875b3eb416a36bba9b262b3b245ed9b83fa5e9fc745a23d488611841302fen,
  r: -0xbff6efa8ffbbef6b7efebbbbb777bbba55ffdbe7fa7fdfe7d5fa3ff9a6ffe5374b00n
}, {
  a: -0x5fc2ef0n,
  b: 0x578fc767d81ec82ade00n,
  r: 0x578fc767d81ec802d000n
}, {
  a: -0x5d57a491443a8c0a45e764f109978f8bce79f588e59d8f245715c0e879dn,
  b: -0x1ae479e8aa3cdc5415f238242d7a48338327f42cf8c38efab881ea37f78bd08f2ebbd3n,
  r: -0x1ae479e8aa3ddd7e5df67bacedfe5e77cf37fd7cf8ffeffff88ffbfff7cff1df2ebfdfn
}, {
  a: -0xf5fee3097d5ccb4c2c36a8bec097n,
  b: -0x71094c2e241f84b1ce05bbee88n,
  r: -0xf5ffeb4d7f7cdfccbdfeadbfee98n
}, {
  a: -0x48a0bfd5974a0ea45df1fbd59ecb1ef122fa2ccdc1c31n,
  b: -0xf0bf1a666dc7151775b2bbfc2ab8312ae43b52425f7ce3dd2651eb979fbc84n,
  r: -0xf0bf1a666dc7151775babbfd7bfcb1eae5ff5fff5ffcf3ff367febdfdfbcb4n
}, {
  a: 0x37d0a78dbb17c48f2842e8fb0ececf15c2an,
  b: -0x917cb936adca746a8a9e8960f3954530367ab32a516c2ede87cfa57332de81a819n,
  r: 0x3490048d1a010402000200a80cc20705422n
}, {
  a: -0xaa8791e475d59f8c2bf8c0dd9c83ae3829b5a236a354ba1c73ebb1901a52411n,
  b: 0x17618b08c763cc2f8239a973c58e93daa18d7db22c7590aade0aed7b4d79n,
  r: 0x661880086030c0002302033c50c1140a18c1582245410804402ec5a4969n
}, {
  a: -0x698ccf210030fa0b8204ce8cd5a9772e058b308fn,
  b: -0xe23c866d891dbaef54b89c487122555c71314893a508d8a2cf7cd4e2ed32n,
  r: -0xe23c866d891dbaef54b8fdccff23557cfb3bca97ef8cddabff7ed5ebfdc0n
}, {
  a: 0x5d6488987f55c0747f370126983309db6fe985c693dc881d0d738911413e0c1n,
  b: 0x92ccfa58d6087c123ea7bb643b030a8c04d1a7a4a299199baa4en,
  r: 0x10044250500068023085b2641800080c0081808420911013a040n
}, {
  a: 0x13e58f38ab138d3595955n,
  b: 0x331edf9e250f5482ec6en,
  r: 0x3218d38a210850004844n
}, {
  a: -0x38b6b740fn,
  b: -0xa54bab20bebcdc5b2eab8ae7e9a08e5b31985082a78f2da59n,
  r: -0xa54bab20bebcdc5b2eab8ae7e9a08e5b31985082bfbfbfe5fn
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var r = d.a & d.b;
  if (d.r !== r) {
    print("Input A:  " + d.a.toString(16));
    print("Input B:  " + d.b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: &");
    error_count++;
  }
}
if (error_count !== 0)
  throw new Error("Finished with " + error_count + " errors.")

