/*
 * Creative ZEN X-Fi3 setup
 *
 * Copyright (C) 2013 Marek Vasut <marex@denx.de>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <common.h>
#include <config.h>
#include <asm/io.h>
#include <asm/arch/iomux-mx23.h>
#include <asm/arch/imx-regs.h>
#include <asm/arch/sys_proto.h>

#define	MUX_CONFIG_EMI	(MXS_PAD_1V8 | MXS_PAD_12MA | MXS_PAD_PULLUP)
#define	MUX_CONFIG_SSP	(MXS_PAD_3V3 | MXS_PAD_8MA | MXS_PAD_PULLUP)
#define	MUX_CONFIG_LCD	(MXS_PAD_3V3 | MXS_PAD_4MA | MXS_PAD_NOPULL)

const iomux_cfg_t iomux_setup[] = {
	/* EMI */
	MX23_PAD_EMI_D00__EMI_D00 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D01__EMI_D01 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D02__EMI_D02 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D03__EMI_D03 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D04__EMI_D04 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D05__EMI_D05 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D06__EMI_D06 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D07__EMI_D07 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D08__EMI_D08 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D09__EMI_D09 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D10__EMI_D10 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D11__EMI_D11 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D12__EMI_D12 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D13__EMI_D13 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D14__EMI_D14 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_D15__EMI_D15 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_DQM0__EMI_DQM0 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_DQM1__EMI_DQM1 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_DQS0__EMI_DQS0 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_DQS1__EMI_DQS1 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_CLK__EMI_CLK | MUX_CONFIG_EMI,
	MX23_PAD_EMI_CLKN__EMI_CLKN | MUX_CONFIG_EMI,

	MX23_PAD_EMI_A00__EMI_A00 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_A01__EMI_A01 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_A02__EMI_A02 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_A03__EMI_A03 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_A04__EMI_A04 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_A05__EMI_A05 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_A06__EMI_A06 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_A07__EMI_A07 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_A08__EMI_A08 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_A09__EMI_A09 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_A10__EMI_A10 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_A11__EMI_A11 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_A12__EMI_A12 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_BA0__EMI_BA0 | MUX_CONFIG_EMI,
	MX23_PAD_EMI_BA1__EMI_BA1 | MUX_CONFIG_EMI,

	MX23_PAD_EMI_CASN__EMI_CASN | MUX_CONFIG_EMI,
	MX23_PAD_EMI_CE0N__EMI_CE0N | MUX_CONFIG_EMI,
	MX23_PAD_EMI_CE1N__EMI_CE1N | MUX_CONFIG_EMI,
	MX23_PAD_EMI_CKE__EMI_CKE | MUX_CONFIG_EMI,
	MX23_PAD_EMI_RASN__EMI_RASN | MUX_CONFIG_EMI,
	MX23_PAD_EMI_WEN__EMI_WEN | MUX_CONFIG_EMI,

	MX23_PAD_LCD_D00__LCD_D00 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D01__LCD_D01 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D02__LCD_D02 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D03__LCD_D03 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D04__LCD_D04 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D05__LCD_D05 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D06__LCD_D06 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D07__LCD_D07 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D08__LCD_D08 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D09__LCD_D09 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D10__LCD_D10 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D11__LCD_D11 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D12__LCD_D12 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D13__LCD_D13 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D14__LCD_D14 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D15__LCD_D15 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D16__LCD_D16 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_D17__LCD_D17 | MUX_CONFIG_LCD,
	MX23_PAD_LCD_RESET__LCD_RESET | MUX_CONFIG_LCD,
	MX23_PAD_LCD_RS__LCD_RS | MUX_CONFIG_LCD,
	MX23_PAD_LCD_WR__LCD_WR | MUX_CONFIG_LCD,
	MX23_PAD_LCD_CS__LCD_CS | MUX_CONFIG_LCD,
	MX23_PAD_LCD_ENABLE__LCD_ENABLE | MUX_CONFIG_LCD,
	MX23_PAD_LCD_VSYNC__LCD_VSYNC | MUX_CONFIG_LCD,

	MX23_PAD_SSP1_CMD__SSP1_CMD | MUX_CONFIG_SSP,
	MX23_PAD_SSP1_DETECT__GPIO_2_1 | MUX_CONFIG_SSP,
	MX23_PAD_SSP1_DATA0__SSP1_DATA0 | MUX_CONFIG_SSP,
	MX23_PAD_SSP1_DATA1__SSP1_DATA1 | MUX_CONFIG_SSP,
	MX23_PAD_SSP1_DATA2__SSP1_DATA2 | MUX_CONFIG_SSP,
	MX23_PAD_SSP1_DATA3__SSP1_DATA3 | MUX_CONFIG_SSP,
	MX23_PAD_SSP1_SCK__SSP1_SCK | MUX_CONFIG_SSP,
	MX23_PAD_GPMI_D07__GPIO_0_7 | MUX_CONFIG_SSP,

	MX23_PAD_GPMI_D00__SSP2_DATA0 | MUX_CONFIG_SSP,
	MX23_PAD_GPMI_D01__SSP2_DATA1 | MUX_CONFIG_SSP,
	MX23_PAD_GPMI_D02__SSP2_DATA2 | MUX_CONFIG_SSP,
	MX23_PAD_GPMI_D03__SSP2_DATA3 | MUX_CONFIG_SSP,
	MX23_PAD_GPMI_RDY1__SSP2_CMD | MUX_CONFIG_SSP,
	MX23_PAD_GPMI_WRN__SSP2_SCK | MUX_CONFIG_SSP,

	/* PWM -- FIXME */
	MX23_PAD_PWM2__GPIO_1_28 | MXS_PAD_3V3 | MXS_PAD_12MA | MXS_PAD_PULLUP,
};

void mxs_adjust_memory_params(uint32_t *dram_vals)
{
	/* mDDR configuration values */
	const uint32_t regs[] = {
		0x01010001, 0x00010000, 0x01000000, 0x00000001,
		0x00010101, 0x00000001, 0x00010000, 0x01000001,
		0x01010000, 0x00000001, 0x07000200, 0x04070203,
		0x02020002, 0x06070a02, 0x0d000201, 0x0305000d,
		0x02080800, 0x19330f0a, 0x1f1f1c00, 0x020a1313,
		0x03061323, 0x0000000a, 0x00080008, 0x00200020,
		0x00200020, 0x00200020, 0x000003f7, 0x00000000,
		0x00000000, 0x00000000, 0x00000020, 0x00000000,
		0x001023cd, 0x20410010, 0x00006665, 0x00000000,
		0x00000101, 0x00000001, 0x00000000, 0x00000000,
	};
	memcpy(dram_vals, regs, sizeof(regs));
}

void board_init_ll(const uint32_t arg, const uint32_t *resptr)
{
	mxs_common_spl_init(arg, resptr, iomux_setup, ARRAY_SIZE(iomux_setup));
}
