/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * arch/arm/include/asm/arch-axg/secure_apb.h
 *
 * Copyright (C) 2020 Amlogic, Inc. All rights reserved.
 *
 */

// ----------------------------------------------------------------------
// This file is automatically generated from script
//
// DO NOT EDIT!!!!!
// ----------------------------------------------------------------------
//

#include <asm/arch/regs.h>

#ifndef SECURE_APB_H
#define SECURE_APB_H

//
// Reading file:  ./secure_apb4_ee.h
//
// synopsys translate_off
// synopsys translate_on
//========================================================================
// MIPI_DSI_PHY
//========================================================================
//  APB4_DECODER_NON_SECURE_BASE     32'hFF640000
//  APB4_DECODER_SECURE_BASE         32'hFF640000
//`define MIPI_DSI_PHY_START      8'h00
//`define MIPI_DSI_PHY_END        16'hffff
#define     MIPI_DSI_PHY_CTRL                                  (0xff640000 + (0x000 << 2))
#define SEC_MIPI_DSI_PHY_CTRL                                  (0xff640000 + (0x000 << 2))
#define   P_MIPI_DSI_PHY_CTRL                                  (volatile uint32_t *)(0xff640000 + (0x000 << 2))
#define     MIPI_DSI_CHAN_CTRL                                 (0xff640000 + (0x001 << 2))
#define SEC_MIPI_DSI_CHAN_CTRL                                 (0xff640000 + (0x001 << 2))
#define   P_MIPI_DSI_CHAN_CTRL                                 (volatile uint32_t *)(0xff640000 + (0x001 << 2))
#define     MIPI_DSI_CHAN_STS                                  (0xff640000 + (0x002 << 2))
#define SEC_MIPI_DSI_CHAN_STS                                  (0xff640000 + (0x002 << 2))
#define   P_MIPI_DSI_CHAN_STS                                  (volatile uint32_t *)(0xff640000 + (0x002 << 2))
#define     MIPI_DSI_CLK_TIM                                   (0xff640000 + (0x003 << 2))
#define SEC_MIPI_DSI_CLK_TIM                                   (0xff640000 + (0x003 << 2))
#define   P_MIPI_DSI_CLK_TIM                                   (volatile uint32_t *)(0xff640000 + (0x003 << 2))
#define     MIPI_DSI_HS_TIM                                    (0xff640000 + (0x004 << 2))
#define SEC_MIPI_DSI_HS_TIM                                    (0xff640000 + (0x004 << 2))
#define   P_MIPI_DSI_HS_TIM                                    (volatile uint32_t *)(0xff640000 + (0x004 << 2))
#define     MIPI_DSI_LP_TIM                                    (0xff640000 + (0x005 << 2))
#define SEC_MIPI_DSI_LP_TIM                                    (0xff640000 + (0x005 << 2))
#define   P_MIPI_DSI_LP_TIM                                    (volatile uint32_t *)(0xff640000 + (0x005 << 2))
#define     MIPI_DSI_ANA_UP_TIM                                (0xff640000 + (0x006 << 2))
#define SEC_MIPI_DSI_ANA_UP_TIM                                (0xff640000 + (0x006 << 2))
#define   P_MIPI_DSI_ANA_UP_TIM                                (volatile uint32_t *)(0xff640000 + (0x006 << 2))
#define     MIPI_DSI_INIT_TIM                                  (0xff640000 + (0x007 << 2))
#define SEC_MIPI_DSI_INIT_TIM                                  (0xff640000 + (0x007 << 2))
#define   P_MIPI_DSI_INIT_TIM                                  (volatile uint32_t *)(0xff640000 + (0x007 << 2))
#define     MIPI_DSI_WAKEUP_TIM                                (0xff640000 + (0x008 << 2))
#define SEC_MIPI_DSI_WAKEUP_TIM                                (0xff640000 + (0x008 << 2))
#define   P_MIPI_DSI_WAKEUP_TIM                                (volatile uint32_t *)(0xff640000 + (0x008 << 2))
#define     MIPI_DSI_LPOK_TIM                                  (0xff640000 + (0x009 << 2))
#define SEC_MIPI_DSI_LPOK_TIM                                  (0xff640000 + (0x009 << 2))
#define   P_MIPI_DSI_LPOK_TIM                                  (volatile uint32_t *)(0xff640000 + (0x009 << 2))
#define     MIPI_DSI_LP_WCHDOG                                 (0xff640000 + (0x00a << 2))
#define SEC_MIPI_DSI_LP_WCHDOG                                 (0xff640000 + (0x00a << 2))
#define   P_MIPI_DSI_LP_WCHDOG                                 (volatile uint32_t *)(0xff640000 + (0x00a << 2))
#define     MIPI_DSI_ANA_CTRL                                  (0xff640000 + (0x00b << 2))
#define SEC_MIPI_DSI_ANA_CTRL                                  (0xff640000 + (0x00b << 2))
#define   P_MIPI_DSI_ANA_CTRL                                  (volatile uint32_t *)(0xff640000 + (0x00b << 2))
#define     MIPI_DSI_CLK_TIM1                                  (0xff640000 + (0x00c << 2))
#define SEC_MIPI_DSI_CLK_TIM1                                  (0xff640000 + (0x00c << 2))
#define   P_MIPI_DSI_CLK_TIM1                                  (volatile uint32_t *)(0xff640000 + (0x00c << 2))
#define     MIPI_DSI_TURN_WCHDOG                               (0xff640000 + (0x00d << 2))
#define SEC_MIPI_DSI_TURN_WCHDOG                               (0xff640000 + (0x00d << 2))
#define   P_MIPI_DSI_TURN_WCHDOG                               (volatile uint32_t *)(0xff640000 + (0x00d << 2))
#define     MIPI_DSI_ULPS_CHECK                                (0xff640000 + (0x00e << 2))
#define SEC_MIPI_DSI_ULPS_CHECK                                (0xff640000 + (0x00e << 2))
#define   P_MIPI_DSI_ULPS_CHECK                                (volatile uint32_t *)(0xff640000 + (0x00e << 2))
#define     MIPI_DSI_TEST_CTRL0                                (0xff640000 + (0x00f << 2))
#define SEC_MIPI_DSI_TEST_CTRL0                                (0xff640000 + (0x00f << 2))
#define   P_MIPI_DSI_TEST_CTRL0                                (volatile uint32_t *)(0xff640000 + (0x00f << 2))
#define     MIPI_DSI_TEST_CTRL1                                (0xff640000 + (0x010 << 2))
#define SEC_MIPI_DSI_TEST_CTRL1                                (0xff640000 + (0x010 << 2))
#define   P_MIPI_DSI_TEST_CTRL1                                (volatile uint32_t *)(0xff640000 + (0x010 << 2))
//========================================================================
//  RNG
//========================================================================
//  APB4_DECODER_NON_SECURE_BASE     32'hFF634000
//  APB4_DECODER_SECURE_BASE         32'hFF634000
#define     RNG_SEC_CONFIG_REG1                                (0xff634000 + (0x001 << 2))
#define SEC_RNG_SEC_CONFIG_REG1                                (0xff634000 + (0x001 << 2))
#define   P_RNG_SEC_CONFIG_REG1                                (volatile uint32_t *)(0xff634000 + (0x001 << 2))
#define     RNG_SEC_CONFIG_REG2                                (0xff634000 + (0x002 << 2))
#define SEC_RNG_SEC_CONFIG_REG2                                (0xff634000 + (0x002 << 2))
#define   P_RNG_SEC_CONFIG_REG2                                (volatile uint32_t *)(0xff634000 + (0x002 << 2))
#define     RNG_SEC_SCRATCH_REG                                (0xff634000 + (0x003 << 2))
#define SEC_RNG_SEC_SCRATCH_REG                                (0xff634000 + (0x003 << 2))
#define   P_RNG_SEC_SCRATCH_REG                                (volatile uint32_t *)(0xff634000 + (0x003 << 2))
#define     RNG_SEC_DATA                                       (0xff634000 + (0x004 << 2))
#define SEC_RNG_SEC_DATA                                       (0xff634000 + (0x004 << 2))
#define   P_RNG_SEC_DATA                                       (volatile uint32_t *)(0xff634000 + (0x004 << 2))
#define     RNG_SEC_STS                                        (0xff634000 + (0x005 << 2))
#define SEC_RNG_SEC_STS                                        (0xff634000 + (0x005 << 2))
#define   P_RNG_SEC_STS                                        (volatile uint32_t *)(0xff634000 + (0x005 << 2))
#define     RNG_USR_DATA                                       (0xff634000 + (0x006 << 2))
#define SEC_RNG_USR_DATA                                       (0xff634000 + (0x006 << 2))
#define   P_RNG_USR_DATA                                       (volatile uint32_t *)(0xff634000 + (0x006 << 2))
#define     RNG_USR_STS                                        (0xff634000 + (0x007 << 2))
#define SEC_RNG_USR_STS                                        (0xff634000 + (0x007 << 2))
#define   P_RNG_USR_STS                                        (volatile uint32_t *)(0xff634000 + (0x007 << 2))
//========================================================================
//  PERIPHS
//========================================================================
//  APB4_DECODER_NON_SECURE_BASE     32'hFF634400
//  APB4_DECODER_SECURE_BASE         32'hFF634400
// The following are handled by $periphs/rtl/periphs_reg.v
// ----------------------------
// Pre-defined GPIO addresses
// ----------------------------
#define     PREG_PAD_GPIO0_EN_N                                (0xff634400 + (0x00c << 2))
#define SEC_PREG_PAD_GPIO0_EN_N                                (0xff634400 + (0x00c << 2))
#define   P_PREG_PAD_GPIO0_EN_N                                (volatile uint32_t *)(0xff634400 + (0x00c << 2))
#define     PREG_PAD_GPIO0_O                                   (0xff634400 + (0x00d << 2))
#define SEC_PREG_PAD_GPIO0_O                                   (0xff634400 + (0x00d << 2))
#define   P_PREG_PAD_GPIO0_O                                   (volatile uint32_t *)(0xff634400 + (0x00d << 2))
#define     PREG_PAD_GPIO0_I                                   (0xff634400 + (0x00e << 2))
#define SEC_PREG_PAD_GPIO0_I                                   (0xff634400 + (0x00e << 2))
#define   P_PREG_PAD_GPIO0_I                                   (volatile uint32_t *)(0xff634400 + (0x00e << 2))
// ----------------------------
#define     PREG_PAD_GPIO1_EN_N                                (0xff634400 + (0x00f << 2))
#define SEC_PREG_PAD_GPIO1_EN_N                                (0xff634400 + (0x00f << 2))
#define   P_PREG_PAD_GPIO1_EN_N                                (volatile uint32_t *)(0xff634400 + (0x00f << 2))
#define     PREG_PAD_GPIO1_O                                   (0xff634400 + (0x010 << 2))
#define SEC_PREG_PAD_GPIO1_O                                   (0xff634400 + (0x010 << 2))
#define   P_PREG_PAD_GPIO1_O                                   (volatile uint32_t *)(0xff634400 + (0x010 << 2))
#define     PREG_PAD_GPIO1_I                                   (0xff634400 + (0x011 << 2))
#define SEC_PREG_PAD_GPIO1_I                                   (0xff634400 + (0x011 << 2))
#define   P_PREG_PAD_GPIO1_I                                   (volatile uint32_t *)(0xff634400 + (0x011 << 2))
// ----------------------------
#define     PREG_PAD_GPIO2_EN_N                                (0xff634400 + (0x012 << 2))
#define SEC_PREG_PAD_GPIO2_EN_N                                (0xff634400 + (0x012 << 2))
#define   P_PREG_PAD_GPIO2_EN_N                                (volatile uint32_t *)(0xff634400 + (0x012 << 2))
#define     PREG_PAD_GPIO2_O                                   (0xff634400 + (0x013 << 2))
#define SEC_PREG_PAD_GPIO2_O                                   (0xff634400 + (0x013 << 2))
#define   P_PREG_PAD_GPIO2_O                                   (volatile uint32_t *)(0xff634400 + (0x013 << 2))
#define     PREG_PAD_GPIO2_I                                   (0xff634400 + (0x014 << 2))
#define SEC_PREG_PAD_GPIO2_I                                   (0xff634400 + (0x014 << 2))
#define   P_PREG_PAD_GPIO2_I                                   (volatile uint32_t *)(0xff634400 + (0x014 << 2))
// ----------------------------
#define     PREG_PAD_GPIO3_EN_N                                (0xff634400 + (0x015 << 2))
#define SEC_PREG_PAD_GPIO3_EN_N                                (0xff634400 + (0x015 << 2))
#define   P_PREG_PAD_GPIO3_EN_N                                (volatile uint32_t *)(0xff634400 + (0x015 << 2))
#define     PREG_PAD_GPIO3_O                                   (0xff634400 + (0x016 << 2))
#define SEC_PREG_PAD_GPIO3_O                                   (0xff634400 + (0x016 << 2))
#define   P_PREG_PAD_GPIO3_O                                   (volatile uint32_t *)(0xff634400 + (0x016 << 2))
#define     PREG_PAD_GPIO3_I                                   (0xff634400 + (0x017 << 2))
#define SEC_PREG_PAD_GPIO3_I                                   (0xff634400 + (0x017 << 2))
#define   P_PREG_PAD_GPIO3_I                                   (volatile uint32_t *)(0xff634400 + (0x017 << 2))
// ----------------------------
#define     PREG_PAD_GPIO4_EN_N                                (0xff634400 + (0x018 << 2))
#define SEC_PREG_PAD_GPIO4_EN_N                                (0xff634400 + (0x018 << 2))
#define   P_PREG_PAD_GPIO4_EN_N                                (volatile uint32_t *)(0xff634400 + (0x018 << 2))
#define     PREG_PAD_GPIO4_O                                   (0xff634400 + (0x019 << 2))
#define SEC_PREG_PAD_GPIO4_O                                   (0xff634400 + (0x019 << 2))
#define   P_PREG_PAD_GPIO4_O                                   (volatile uint32_t *)(0xff634400 + (0x019 << 2))
#define     PREG_PAD_GPIO4_I                                   (0xff634400 + (0x01a << 2))
#define SEC_PREG_PAD_GPIO4_I                                   (0xff634400 + (0x01a << 2))
#define   P_PREG_PAD_GPIO4_I                                   (volatile uint32_t *)(0xff634400 + (0x01a << 2))
// ----------------------------
// ----------------------------
// Pin Mux  (9)
// ----------------------------
#define     PERIPHS_PIN_MUX_0                                  (0xff634400 + (0x020 << 2))
#define SEC_PERIPHS_PIN_MUX_0                                  (0xff634400 + (0x020 << 2))
#define   P_PERIPHS_PIN_MUX_0                                  (volatile uint32_t *)(0xff634400 + (0x020 << 2))
#define     PERIPHS_PIN_MUX_1                                  (0xff634400 + (0x021 << 2))
#define SEC_PERIPHS_PIN_MUX_1                                  (0xff634400 + (0x021 << 2))
#define   P_PERIPHS_PIN_MUX_1                                  (volatile uint32_t *)(0xff634400 + (0x021 << 2))
#define     PERIPHS_PIN_MUX_2                                  (0xff634400 + (0x022 << 2))
#define SEC_PERIPHS_PIN_MUX_2                                  (0xff634400 + (0x022 << 2))
#define   P_PERIPHS_PIN_MUX_2                                  (volatile uint32_t *)(0xff634400 + (0x022 << 2))
#define     PERIPHS_PIN_MUX_3                                  (0xff634400 + (0x023 << 2))
#define SEC_PERIPHS_PIN_MUX_3                                  (0xff634400 + (0x023 << 2))
#define   P_PERIPHS_PIN_MUX_3                                  (volatile uint32_t *)(0xff634400 + (0x023 << 2))
#define     PERIPHS_PIN_MUX_4                                  (0xff634400 + (0x024 << 2))
#define SEC_PERIPHS_PIN_MUX_4                                  (0xff634400 + (0x024 << 2))
#define   P_PERIPHS_PIN_MUX_4                                  (volatile uint32_t *)(0xff634400 + (0x024 << 2))
#define     PERIPHS_PIN_MUX_5                                  (0xff634400 + (0x025 << 2))
#define SEC_PERIPHS_PIN_MUX_5                                  (0xff634400 + (0x025 << 2))
#define   P_PERIPHS_PIN_MUX_5                                  (volatile uint32_t *)(0xff634400 + (0x025 << 2))
#define     PERIPHS_PIN_MUX_6                                  (0xff634400 + (0x026 << 2))
#define SEC_PERIPHS_PIN_MUX_6                                  (0xff634400 + (0x026 << 2))
#define   P_PERIPHS_PIN_MUX_6                                  (volatile uint32_t *)(0xff634400 + (0x026 << 2))
#define     PERIPHS_PIN_MUX_7                                  (0xff634400 + (0x027 << 2))
#define SEC_PERIPHS_PIN_MUX_7                                  (0xff634400 + (0x027 << 2))
#define   P_PERIPHS_PIN_MUX_7                                  (volatile uint32_t *)(0xff634400 + (0x027 << 2))
#define     PERIPHS_PIN_MUX_8                                  (0xff634400 + (0x028 << 2))
#define SEC_PERIPHS_PIN_MUX_8                                  (0xff634400 + (0x028 << 2))
#define   P_PERIPHS_PIN_MUX_8                                  (volatile uint32_t *)(0xff634400 + (0x028 << 2))
#define     PERIPHS_PIN_MUX_9                                  (0xff634400 + (0x029 << 2))
#define SEC_PERIPHS_PIN_MUX_9                                  (0xff634400 + (0x029 << 2))
#define   P_PERIPHS_PIN_MUX_9                                  (volatile uint32_t *)(0xff634400 + (0x029 << 2))
#define     PERIPHS_PIN_MUX_A                                  (0xff634400 + (0x02a << 2))
#define SEC_PERIPHS_PIN_MUX_A                                  (0xff634400 + (0x02a << 2))
#define   P_PERIPHS_PIN_MUX_A                                  (volatile uint32_t *)(0xff634400 + (0x02a << 2))
#define     PERIPHS_PIN_MUX_B                                  (0xff634400 + (0x02b << 2))
#define SEC_PERIPHS_PIN_MUX_B                                  (0xff634400 + (0x02b << 2))
#define   P_PERIPHS_PIN_MUX_B                                  (volatile uint32_t *)(0xff634400 + (0x02b << 2))
#define     PERIPHS_PIN_MUX_C                                  (0xff634400 + (0x02c << 2))
#define SEC_PERIPHS_PIN_MUX_C                                  (0xff634400 + (0x02c << 2))
#define   P_PERIPHS_PIN_MUX_C                                  (volatile uint32_t *)(0xff634400 + (0x02c << 2))
#define     PERIPHS_PIN_MUX_D                                  (0xff634400 + (0x02d << 2))
#define SEC_PERIPHS_PIN_MUX_D                                  (0xff634400 + (0x02d << 2))
#define   P_PERIPHS_PIN_MUX_D                                  (volatile uint32_t *)(0xff634400 + (0x02d << 2))
#define     PERIPHS_PIN_MUX_E                                  (0xff634400 + (0x02e << 2))
#define SEC_PERIPHS_PIN_MUX_E                                  (0xff634400 + (0x02e << 2))
#define   P_PERIPHS_PIN_MUX_E                                  (volatile uint32_t *)(0xff634400 + (0x02e << 2))
#define     PERIPHS_PIN_MUX_F                                  (0xff634400 + (0x02f << 2))
#define SEC_PERIPHS_PIN_MUX_F                                  (0xff634400 + (0x02f << 2))
#define   P_PERIPHS_PIN_MUX_F                                  (volatile uint32_t *)(0xff634400 + (0x02f << 2))
// ----------------------------
// Pad controls
// ----------------------------
#define     PAD_PULL_UP_REG0                                   (0xff634400 + (0x03a << 2))
#define SEC_PAD_PULL_UP_REG0                                   (0xff634400 + (0x03a << 2))
#define   P_PAD_PULL_UP_REG0                                   (volatile uint32_t *)(0xff634400 + (0x03a << 2))
#define     PAD_PULL_UP_REG1                                   (0xff634400 + (0x03b << 2))
#define SEC_PAD_PULL_UP_REG1                                   (0xff634400 + (0x03b << 2))
#define   P_PAD_PULL_UP_REG1                                   (volatile uint32_t *)(0xff634400 + (0x03b << 2))
#define     PAD_PULL_UP_REG2                                   (0xff634400 + (0x03c << 2))
#define SEC_PAD_PULL_UP_REG2                                   (0xff634400 + (0x03c << 2))
#define   P_PAD_PULL_UP_REG2                                   (volatile uint32_t *)(0xff634400 + (0x03c << 2))
#define     PAD_PULL_UP_REG3                                   (0xff634400 + (0x03d << 2))
#define SEC_PAD_PULL_UP_REG3                                   (0xff634400 + (0x03d << 2))
#define   P_PAD_PULL_UP_REG3                                   (volatile uint32_t *)(0xff634400 + (0x03d << 2))
#define     PAD_PULL_UP_REG4                                   (0xff634400 + (0x03e << 2))
#define SEC_PAD_PULL_UP_REG4                                   (0xff634400 + (0x03e << 2))
#define   P_PAD_PULL_UP_REG4                                   (volatile uint32_t *)(0xff634400 + (0x03e << 2))
// ----------------------------
// Random (2)
// ----------------------------
#define     RAND64_ADDR0                                       (0xff634400 + (0x040 << 2))
#define SEC_RAND64_ADDR0                                       (0xff634400 + (0x040 << 2))
#define   P_RAND64_ADDR0                                       (volatile uint32_t *)(0xff634400 + (0x040 << 2))
#define     RAND64_ADDR1                                       (0xff634400 + (0x041 << 2))
#define SEC_RAND64_ADDR1                                       (0xff634400 + (0x041 << 2))
#define   P_RAND64_ADDR1                                       (volatile uint32_t *)(0xff634400 + (0x041 << 2))
#define     PAD_PULL_UP_EN_REG0                                (0xff634400 + (0x048 << 2))
#define SEC_PAD_PULL_UP_EN_REG0                                (0xff634400 + (0x048 << 2))
#define   P_PAD_PULL_UP_EN_REG0                                (volatile uint32_t *)(0xff634400 + (0x048 << 2))
#define     PAD_PULL_UP_EN_REG1                                (0xff634400 + (0x049 << 2))
#define SEC_PAD_PULL_UP_EN_REG1                                (0xff634400 + (0x049 << 2))
#define   P_PAD_PULL_UP_EN_REG1                                (volatile uint32_t *)(0xff634400 + (0x049 << 2))
#define     PAD_PULL_UP_EN_REG2                                (0xff634400 + (0x04a << 2))
#define SEC_PAD_PULL_UP_EN_REG2                                (0xff634400 + (0x04a << 2))
#define   P_PAD_PULL_UP_EN_REG2                                (volatile uint32_t *)(0xff634400 + (0x04a << 2))
#define     PAD_PULL_UP_EN_REG3                                (0xff634400 + (0x04b << 2))
#define SEC_PAD_PULL_UP_EN_REG3                                (0xff634400 + (0x04b << 2))
#define   P_PAD_PULL_UP_EN_REG3                                (volatile uint32_t *)(0xff634400 + (0x04b << 2))
#define     PAD_PULL_UP_EN_REG4                                (0xff634400 + (0x04c << 2))
#define SEC_PAD_PULL_UP_EN_REG4                                (0xff634400 + (0x04c << 2))
#define   P_PAD_PULL_UP_EN_REG4                                (volatile uint32_t *)(0xff634400 + (0x04c << 2))
// ---------------------------
#define     PREG_ETH_REG0                                      (0xff634400 + (0x050 << 2))
#define SEC_PREG_ETH_REG0                                      (0xff634400 + (0x050 << 2))
#define   P_PREG_ETH_REG0                                      (volatile uint32_t *)(0xff634400 + (0x050 << 2))
#define     PREG_ETH_REG1                                      (0xff634400 + (0x051 << 2))
#define SEC_PREG_ETH_REG1                                      (0xff634400 + (0x051 << 2))
#define   P_PREG_ETH_REG1                                      (volatile uint32_t *)(0xff634400 + (0x051 << 2))
#define     PREG_NAND_CFG_KEY0                                 (0xff634400 + (0x052 << 2))
#define SEC_PREG_NAND_CFG_KEY0                                 (0xff634400 + (0x052 << 2))
#define   P_PREG_NAND_CFG_KEY0                                 (volatile uint32_t *)(0xff634400 + (0x052 << 2))
#define     PREG_NAND_CFG_KEY1                                 (0xff634400 + (0x053 << 2))
#define SEC_PREG_NAND_CFG_KEY1                                 (0xff634400 + (0x053 << 2))
#define   P_PREG_NAND_CFG_KEY1                                 (volatile uint32_t *)(0xff634400 + (0x053 << 2))
#define     PREG_VPU_SECURE0                                   (0xff634400 + (0x054 << 2))
#define SEC_PREG_VPU_SECURE0                                   (0xff634400 + (0x054 << 2))
#define   P_PREG_VPU_SECURE0                                   (volatile uint32_t *)(0xff634400 + (0x054 << 2))
#define     PREG_VPU_SECURE1                                   (0xff634400 + (0x055 << 2))
#define SEC_PREG_VPU_SECURE1                                   (0xff634400 + (0x055 << 2))
#define   P_PREG_VPU_SECURE1                                   (volatile uint32_t *)(0xff634400 + (0x055 << 2))
// ---------------------------
// Generic production test
// ----------------------------
#define     PROD_TEST_REG0                                     (0xff634400 + (0x060 << 2))
#define SEC_PROD_TEST_REG0                                     (0xff634400 + (0x060 << 2))
#define   P_PROD_TEST_REG0                                     (volatile uint32_t *)(0xff634400 + (0x060 << 2))
#define     PROD_TEST_REG1                                     (0xff634400 + (0x061 << 2))
#define SEC_PROD_TEST_REG1                                     (0xff634400 + (0x061 << 2))
#define   P_PROD_TEST_REG1                                     (volatile uint32_t *)(0xff634400 + (0x061 << 2))
#define     PROD_TEST_REG2                                     (0xff634400 + (0x062 << 2))
#define SEC_PROD_TEST_REG2                                     (0xff634400 + (0x062 << 2))
#define   P_PROD_TEST_REG2                                     (volatile uint32_t *)(0xff634400 + (0x062 << 2))
#define     PROD_TEST_REG3                                     (0xff634400 + (0x063 << 2))
#define SEC_PROD_TEST_REG3                                     (0xff634400 + (0x063 << 2))
#define   P_PROD_TEST_REG3                                     (volatile uint32_t *)(0xff634400 + (0x063 << 2))
// ---------------------------
// TS sensor
// ----------------------------
#define     TS_CFG_REG                                         (0xff634400 + (0x065 << 2))
#define SEC_TS_CFG_REG                                         (0xff634400 + (0x065 << 2))
#define   P_TS_CFG_REG                                         (volatile uint32_t *)(0xff634400 + (0x065 << 2))
#define     TS_YOUT                                            (0xff634400 + (0x066 << 2))
#define SEC_TS_YOUT                                            (0xff634400 + (0x066 << 2))
#define   P_TS_YOUT                                            (volatile uint32_t *)(0xff634400 + (0x066 << 2))
#define     TS_CFG_REG2                                        (0xff634400 + (0x067 << 2))
#define SEC_TS_CFG_REG2                                        (0xff634400 + (0x067 << 2))
#define   P_TS_CFG_REG2                                        (volatile uint32_t *)(0xff634400 + (0x067 << 2))
// ---------------------------
// Sticky regs
// ----------------------------
#define     PREG_STICKY_REG0                                   (0xff634400 + (0x070 << 2))
#define SEC_PREG_STICKY_REG0                                   (0xff634400 + (0x070 << 2))
#define   P_PREG_STICKY_REG0                                   (volatile uint32_t *)(0xff634400 + (0x070 << 2))
#define     PREG_STICKY_REG1                                   (0xff634400 + (0x071 << 2))
#define SEC_PREG_STICKY_REG1                                   (0xff634400 + (0x071 << 2))
#define   P_PREG_STICKY_REG1                                   (volatile uint32_t *)(0xff634400 + (0x071 << 2))
#define     PREG_STICKY_REG2                                   (0xff634400 + (0x072 << 2))
#define SEC_PREG_STICKY_REG2                                   (0xff634400 + (0x072 << 2))
#define   P_PREG_STICKY_REG2                                   (volatile uint32_t *)(0xff634400 + (0x072 << 2))
#define     PREG_STICKY_REG3                                   (0xff634400 + (0x073 << 2))
#define SEC_PREG_STICKY_REG3                                   (0xff634400 + (0x073 << 2))
#define   P_PREG_STICKY_REG3                                   (volatile uint32_t *)(0xff634400 + (0x073 << 2))
#define     PREG_STICKY_REG4                                   (0xff634400 + (0x074 << 2))
#define SEC_PREG_STICKY_REG4                                   (0xff634400 + (0x074 << 2))
#define   P_PREG_STICKY_REG4                                   (volatile uint32_t *)(0xff634400 + (0x074 << 2))
#define     PREG_STICKY_REG5                                   (0xff634400 + (0x075 << 2))
#define SEC_PREG_STICKY_REG5                                   (0xff634400 + (0x075 << 2))
#define   P_PREG_STICKY_REG5                                   (volatile uint32_t *)(0xff634400 + (0x075 << 2))
#define     PREG_STICKY_REG6                                   (0xff634400 + (0x076 << 2))
#define SEC_PREG_STICKY_REG6                                   (0xff634400 + (0x076 << 2))
#define   P_PREG_STICKY_REG6                                   (volatile uint32_t *)(0xff634400 + (0x076 << 2))
#define     PREG_STICKY_REG7                                   (0xff634400 + (0x077 << 2))
#define SEC_PREG_STICKY_REG7                                   (0xff634400 + (0x077 << 2))
#define   P_PREG_STICKY_REG7                                   (volatile uint32_t *)(0xff634400 + (0x077 << 2))
#define     PREG_STICKY_REG8                                   (0xff634400 + (0x078 << 2))
#define SEC_PREG_STICKY_REG8                                   (0xff634400 + (0x078 << 2))
#define   P_PREG_STICKY_REG8                                   (volatile uint32_t *)(0xff634400 + (0x078 << 2))
#define     PREG_STICKY_REG9                                   (0xff634400 + (0x079 << 2))
#define SEC_PREG_STICKY_REG9                                   (0xff634400 + (0x079 << 2))
#define   P_PREG_STICKY_REG9                                   (volatile uint32_t *)(0xff634400 + (0x079 << 2))
#define     PREG_WRITE_ONCE_REG                                (0xff634400 + (0x07e << 2))
#define SEC_PREG_WRITE_ONCE_REG                                (0xff634400 + (0x07e << 2))
#define   P_PREG_WRITE_ONCE_REG                                (volatile uint32_t *)(0xff634400 + (0x07e << 2))
// ---------------------------
// AM Ring Oscillator
// ----------------------------
#define     AM_RING_OSC_REG0                                   (0xff634400 + (0x07f << 2))
#define SEC_AM_RING_OSC_REG0                                   (0xff634400 + (0x07f << 2))
#define   P_AM_RING_OSC_REG0                                   (volatile uint32_t *)(0xff634400 + (0x07f << 2))
// ---------------------------
// Bus Monitoring
// ----------------------------
#define     BUS_MONITOR_CNTL                                   (0xff634400 + (0x081 << 2))
#define SEC_BUS_MONITOR_CNTL                                   (0xff634400 + (0x081 << 2))
#define   P_BUS_MONITOR_CNTL                                   (volatile uint32_t *)(0xff634400 + (0x081 << 2))
#define     BUS_MON0_ADDR                                      (0xff634400 + (0x082 << 2))
#define SEC_BUS_MON0_ADDR                                      (0xff634400 + (0x082 << 2))
#define   P_BUS_MON0_ADDR                                      (volatile uint32_t *)(0xff634400 + (0x082 << 2))
#define     BUS_MON0_DATA                                      (0xff634400 + (0x083 << 2))
#define SEC_BUS_MON0_DATA                                      (0xff634400 + (0x083 << 2))
#define   P_BUS_MON0_DATA                                      (volatile uint32_t *)(0xff634400 + (0x083 << 2))
#define     BUS_MON0_DATA_MSK                                  (0xff634400 + (0x084 << 2))
#define SEC_BUS_MON0_DATA_MSK                                  (0xff634400 + (0x084 << 2))
#define   P_BUS_MON0_DATA_MSK                                  (volatile uint32_t *)(0xff634400 + (0x084 << 2))
#define     BUS_MON1_ADDR                                      (0xff634400 + (0x085 << 2))
#define SEC_BUS_MON1_ADDR                                      (0xff634400 + (0x085 << 2))
#define   P_BUS_MON1_ADDR                                      (volatile uint32_t *)(0xff634400 + (0x085 << 2))
#define     BUS_MON1_DATA                                      (0xff634400 + (0x086 << 2))
#define SEC_BUS_MON1_DATA                                      (0xff634400 + (0x086 << 2))
#define   P_BUS_MON1_DATA                                      (volatile uint32_t *)(0xff634400 + (0x086 << 2))
#define     BUS_MON1_DATA_MSK                                  (0xff634400 + (0x087 << 2))
#define SEC_BUS_MON1_DATA_MSK                                  (0xff634400 + (0x087 << 2))
#define   P_BUS_MON1_DATA_MSK                                  (volatile uint32_t *)(0xff634400 + (0x087 << 2))
#define     SECE_TIMER_CTRL                                    (0xff634400 + (0x089 << 2))
#define SEC_SECE_TIMER_CTRL                                    (0xff634400 + (0x089 << 2))
#define   P_SECE_TIMER_CTRL                                    (volatile uint32_t *)(0xff634400 + (0x089 << 2))
#define     SECE_TIMER_LOW                                     (0xff634400 + (0x08a << 2))
#define SEC_SECE_TIMER_LOW                                     (0xff634400 + (0x08a << 2))
#define   P_SECE_TIMER_LOW                                     (volatile uint32_t *)(0xff634400 + (0x08a << 2))
#define     SECE_TIMER_HIG                                     (0xff634400 + (0x08b << 2))
#define SEC_SECE_TIMER_HIG                                     (0xff634400 + (0x08b << 2))
#define   P_SECE_TIMER_HIG                                     (volatile uint32_t *)(0xff634400 + (0x08b << 2))
// ---------------------------
// System CPU control registers
// ----------------------------
#define     SYS_CPU_POR_CFG0                                   (0xff634400 + (0x090 << 2))
#define SEC_SYS_CPU_POR_CFG0                                   (0xff634400 + (0x090 << 2))
#define   P_SYS_CPU_POR_CFG0                                   (volatile uint32_t *)(0xff634400 + (0x090 << 2))
#define     SYS_CPU_POR_CFG1                                   (0xff634400 + (0x091 << 2))
#define SEC_SYS_CPU_POR_CFG1                                   (0xff634400 + (0x091 << 2))
#define   P_SYS_CPU_POR_CFG1                                   (volatile uint32_t *)(0xff634400 + (0x091 << 2))
#define     SYS_CPU_CFG0                                       (0xff634400 + (0x092 << 2))
#define SEC_SYS_CPU_CFG0                                       (0xff634400 + (0x092 << 2))
#define   P_SYS_CPU_CFG0                                       (volatile uint32_t *)(0xff634400 + (0x092 << 2))
#define     SYS_CPU_CFG1                                       (0xff634400 + (0x093 << 2))
#define SEC_SYS_CPU_CFG1                                       (0xff634400 + (0x093 << 2))
#define   P_SYS_CPU_CFG1                                       (volatile uint32_t *)(0xff634400 + (0x093 << 2))
#define     SYS_CPU_CFG2                                       (0xff634400 + (0x094 << 2))
#define SEC_SYS_CPU_CFG2                                       (0xff634400 + (0x094 << 2))
#define   P_SYS_CPU_CFG2                                       (volatile uint32_t *)(0xff634400 + (0x094 << 2))
#define     SYS_CPU_CFG3                                       (0xff634400 + (0x095 << 2))
#define SEC_SYS_CPU_CFG3                                       (0xff634400 + (0x095 << 2))
#define   P_SYS_CPU_CFG3                                       (volatile uint32_t *)(0xff634400 + (0x095 << 2))
#define     SYS_CPU_CFG4                                       (0xff634400 + (0x096 << 2))
#define SEC_SYS_CPU_CFG4                                       (0xff634400 + (0x096 << 2))
#define   P_SYS_CPU_CFG4                                       (volatile uint32_t *)(0xff634400 + (0x096 << 2))
#define     SYS_CPU_CFG5                                       (0xff634400 + (0x097 << 2))
#define SEC_SYS_CPU_CFG5                                       (0xff634400 + (0x097 << 2))
#define   P_SYS_CPU_CFG5                                       (volatile uint32_t *)(0xff634400 + (0x097 << 2))
#define     SYS_CPU_CFG6                                       (0xff634400 + (0x098 << 2))
#define SEC_SYS_CPU_CFG6                                       (0xff634400 + (0x098 << 2))
#define   P_SYS_CPU_CFG6                                       (volatile uint32_t *)(0xff634400 + (0x098 << 2))
#define     SYS_CPU_CFG7                                       (0xff634400 + (0x099 << 2))
#define SEC_SYS_CPU_CFG7                                       (0xff634400 + (0x099 << 2))
#define   P_SYS_CPU_CFG7                                       (volatile uint32_t *)(0xff634400 + (0x099 << 2))
#define     SYS_CPU_CFG8                                       (0xff634400 + (0x09a << 2))
#define SEC_SYS_CPU_CFG8                                       (0xff634400 + (0x09a << 2))
#define   P_SYS_CPU_CFG8                                       (volatile uint32_t *)(0xff634400 + (0x09a << 2))
#define     SYS_CPU_CFG9                                       (0xff634400 + (0x09b << 2))
#define SEC_SYS_CPU_CFG9                                       (0xff634400 + (0x09b << 2))
#define   P_SYS_CPU_CFG9                                       (volatile uint32_t *)(0xff634400 + (0x09b << 2))
#define     SYS_CPU_CFG10                                      (0xff634400 + (0x09c << 2))
#define SEC_SYS_CPU_CFG10                                      (0xff634400 + (0x09c << 2))
#define   P_SYS_CPU_CFG10                                      (volatile uint32_t *)(0xff634400 + (0x09c << 2))
#define     SYS_CPU_STATUS0                                    (0xff634400 + (0x0a0 << 2))
#define SEC_SYS_CPU_STATUS0                                    (0xff634400 + (0x0a0 << 2))
#define   P_SYS_CPU_STATUS0                                    (volatile uint32_t *)(0xff634400 + (0x0a0 << 2))
#define     SYS_CPU_STATUS1                                    (0xff634400 + (0x0a1 << 2))
#define SEC_SYS_CPU_STATUS1                                    (0xff634400 + (0x0a1 << 2))
#define   P_SYS_CPU_STATUS1                                    (volatile uint32_t *)(0xff634400 + (0x0a1 << 2))
#define     SYS_CPU_STATUS2                                    (0xff634400 + (0x0a2 << 2))
#define SEC_SYS_CPU_STATUS2                                    (0xff634400 + (0x0a2 << 2))
#define   P_SYS_CPU_STATUS2                                    (volatile uint32_t *)(0xff634400 + (0x0a2 << 2))
#define     SYS_CPU_STATUS3                                    (0xff634400 + (0x0a3 << 2))
#define SEC_SYS_CPU_STATUS3                                    (0xff634400 + (0x0a3 << 2))
#define   P_SYS_CPU_STATUS3                                    (volatile uint32_t *)(0xff634400 + (0x0a3 << 2))
#define     SYS_CPU_STATUS4                                    (0xff634400 + (0x0a4 << 2))
#define SEC_SYS_CPU_STATUS4                                    (0xff634400 + (0x0a4 << 2))
#define   P_SYS_CPU_STATUS4                                    (volatile uint32_t *)(0xff634400 + (0x0a4 << 2))
#define     SYS_CPU_STATUS5                                    (0xff634400 + (0x0a5 << 2))
#define SEC_SYS_CPU_STATUS5                                    (0xff634400 + (0x0a5 << 2))
#define   P_SYS_CPU_STATUS5                                    (volatile uint32_t *)(0xff634400 + (0x0a5 << 2))
#define     SYS_CPU_MISC                                       (0xff634400 + (0x0a8 << 2))
#define SEC_SYS_CPU_MISC                                       (0xff634400 + (0x0a8 << 2))
#define   P_SYS_CPU_MISC                                       (volatile uint32_t *)(0xff634400 + (0x0a8 << 2))
//========================================================================
//  PCIEPHY - Registers
//========================================================================
// APB4_DECODER_NON_SECURE_BASE     32'hFF644000
// APB4_DECODER_SECURE_BASE         32'hFF644000
#define     EE_PCIE_PHY_CTRL                                   (0xff644000 + (0x000 << 2))
#define SEC_EE_PCIE_PHY_CTRL                                   (0xff644000 + (0x000 << 2))
#define   P_EE_PCIE_PHY_CTRL                                   (volatile uint32_t *)(0xff644000 + (0x000 << 2))
//========================================================================
//  PCIE_A - Registers
//========================================================================
// APB4_DECODER_NON_SECURE_BASE     32'hFF646000
// APB4_DECODER_SECURE_BASE         32'hFF646000
#define     EE_PCIE_A_CTRL                                     (0xff646000 + (0x000 << 2))
#define SEC_EE_PCIE_A_CTRL                                     (0xff646000 + (0x000 << 2))
#define   P_EE_PCIE_A_CTRL                                     (volatile uint32_t *)(0xff646000 + (0x000 << 2))
//========================================================================
//  PCIE_B - Registers
//========================================================================
// APB4_DECODER_NON_SECURE_BASE     32'hFF648000
// APB4_DECODER_SECURE_BASE         32'hFF648000
#define     EE_PCIE_B_CTRL                                     (0xff648000 + (0x000 << 2))
#define SEC_EE_PCIE_B_CTRL                                     (0xff648000 + (0x000 << 2))
#define   P_EE_PCIE_B_CTRL                                     (volatile uint32_t *)(0xff648000 + (0x000 << 2))
//========================================================================
//  DMA - Registers
//========================================================================
// APB4_DECODER_NON_SECURE_BASE     32'hFF63e000
// APB4_DECODER_SECURE_BASE         32'hFF63e000
#define     DMA_T0                                             (0xff63e000 + (0x000 << 2))
#define SEC_DMA_T0                                             (0xff63e000 + (0x000 << 2))
#define   P_DMA_T0                                             (volatile uint32_t *)(0xff63e000 + (0x000 << 2))
#define     DMA_T1                                             (0xff63e000 + (0x001 << 2))
#define SEC_DMA_T1                                             (0xff63e000 + (0x001 << 2))
#define   P_DMA_T1                                             (volatile uint32_t *)(0xff63e000 + (0x001 << 2))
#define     DMA_T2                                             (0xff63e000 + (0x002 << 2))
#define SEC_DMA_T2                                             (0xff63e000 + (0x002 << 2))
#define   P_DMA_T2                                             (volatile uint32_t *)(0xff63e000 + (0x002 << 2))
#define     DMA_T3                                             (0xff63e000 + (0x003 << 2))
#define SEC_DMA_T3                                             (0xff63e000 + (0x003 << 2))
#define   P_DMA_T3                                             (volatile uint32_t *)(0xff63e000 + (0x003 << 2))
#define     DMA_T4                                             (0xff63e000 + (0x004 << 2))
#define SEC_DMA_T4                                             (0xff63e000 + (0x004 << 2))
#define   P_DMA_T4                                             (volatile uint32_t *)(0xff63e000 + (0x004 << 2))
#define     DMA_T5                                             (0xff63e000 + (0x005 << 2))
#define SEC_DMA_T5                                             (0xff63e000 + (0x005 << 2))
#define   P_DMA_T5                                             (volatile uint32_t *)(0xff63e000 + (0x005 << 2))
#define     DMA_STS0                                           (0xff63e000 + (0x008 << 2))
#define SEC_DMA_STS0                                           (0xff63e000 + (0x008 << 2))
#define   P_DMA_STS0                                           (volatile uint32_t *)(0xff63e000 + (0x008 << 2))
#define     DMA_STS1                                           (0xff63e000 + (0x009 << 2))
#define SEC_DMA_STS1                                           (0xff63e000 + (0x009 << 2))
#define   P_DMA_STS1                                           (volatile uint32_t *)(0xff63e000 + (0x009 << 2))
#define     DMA_STS2                                           (0xff63e000 + (0x00a << 2))
#define SEC_DMA_STS2                                           (0xff63e000 + (0x00a << 2))
#define   P_DMA_STS2                                           (volatile uint32_t *)(0xff63e000 + (0x00a << 2))
#define     DMA_STS3                                           (0xff63e000 + (0x00b << 2))
#define SEC_DMA_STS3                                           (0xff63e000 + (0x00b << 2))
#define   P_DMA_STS3                                           (volatile uint32_t *)(0xff63e000 + (0x00b << 2))
#define     DMA_STS4                                           (0xff63e000 + (0x00c << 2))
#define SEC_DMA_STS4                                           (0xff63e000 + (0x00c << 2))
#define   P_DMA_STS4                                           (volatile uint32_t *)(0xff63e000 + (0x00c << 2))
#define     DMA_STS5                                           (0xff63e000 + (0x00d << 2))
#define SEC_DMA_STS5                                           (0xff63e000 + (0x00d << 2))
#define   P_DMA_STS5                                           (volatile uint32_t *)(0xff63e000 + (0x00d << 2))
#define     DMA_CFG                                            (0xff63e000 + (0x010 << 2))
#define SEC_DMA_CFG                                            (0xff63e000 + (0x010 << 2))
#define   P_DMA_CFG                                            (volatile uint32_t *)(0xff63e000 + (0x010 << 2))
#define     DMA_SEC                                            (0xff63e000 + (0x011 << 2))
#define SEC_DMA_SEC                                            (0xff63e000 + (0x011 << 2))
#define   P_DMA_SEC                                            (volatile uint32_t *)(0xff63e000 + (0x011 << 2))
//========================================================================
//  AUDIO locker - Registers
//========================================================================
// APB4_DECODER_NON_SECURE_BASE     32'hFF64a000
// APB4_DECODER_SECURE_BASE         32'hFF64a000
#define     AUD_LOCK_EN                                        (0xff64a000 + (0x000 << 2))
#define SEC_AUD_LOCK_EN                                        (0xff64a000 + (0x000 << 2))
#define   P_AUD_LOCK_EN                                        (volatile uint32_t *)(0xff64a000 + (0x000 << 2))
#define     AUD_LOCK_SW_RESET                                  (0xff64a000 + (0x001 << 2))
#define SEC_AUD_LOCK_SW_RESET                                  (0xff64a000 + (0x001 << 2))
#define   P_AUD_LOCK_SW_RESET                                  (volatile uint32_t *)(0xff64a000 + (0x001 << 2))
#define     AUD_LOCK_SW_LATCH                                  (0xff64a000 + (0x002 << 2))
#define SEC_AUD_LOCK_SW_LATCH                                  (0xff64a000 + (0x002 << 2))
#define   P_AUD_LOCK_SW_LATCH                                  (volatile uint32_t *)(0xff64a000 + (0x002 << 2))
#define     AUD_LOCK_HW_LATCH                                  (0xff64a000 + (0x003 << 2))
#define SEC_AUD_LOCK_HW_LATCH                                  (0xff64a000 + (0x003 << 2))
#define   P_AUD_LOCK_HW_LATCH                                  (volatile uint32_t *)(0xff64a000 + (0x003 << 2))
#define     AUD_LOCK_REFCLK_SRC                                (0xff64a000 + (0x004 << 2))
#define SEC_AUD_LOCK_REFCLK_SRC                                (0xff64a000 + (0x004 << 2))
#define   P_AUD_LOCK_REFCLK_SRC                                (volatile uint32_t *)(0xff64a000 + (0x004 << 2))
#define     AUD_LOCK_REFCLK_LAT_INT                            (0xff64a000 + (0x005 << 2))
#define SEC_AUD_LOCK_REFCLK_LAT_INT                            (0xff64a000 + (0x005 << 2))
#define   P_AUD_LOCK_REFCLK_LAT_INT                            (volatile uint32_t *)(0xff64a000 + (0x005 << 2))
#define     AUD_LOCK_IMCLK_LAT_INT                             (0xff64a000 + (0x006 << 2))
#define SEC_AUD_LOCK_IMCLK_LAT_INT                             (0xff64a000 + (0x006 << 2))
#define   P_AUD_LOCK_IMCLK_LAT_INT                             (volatile uint32_t *)(0xff64a000 + (0x006 << 2))
#define     AUD_LOCK_OMCLK_LAT_INT                             (0xff64a000 + (0x007 << 2))
#define SEC_AUD_LOCK_OMCLK_LAT_INT                             (0xff64a000 + (0x007 << 2))
#define   P_AUD_LOCK_OMCLK_LAT_INT                             (volatile uint32_t *)(0xff64a000 + (0x007 << 2))
#define     AUD_LOCK_REFCLK_DS_INT                             (0xff64a000 + (0x008 << 2))
#define SEC_AUD_LOCK_REFCLK_DS_INT                             (0xff64a000 + (0x008 << 2))
#define   P_AUD_LOCK_REFCLK_DS_INT                             (volatile uint32_t *)(0xff64a000 + (0x008 << 2))
#define     AUD_LOCK_IMCLK_DS_INT                              (0xff64a000 + (0x009 << 2))
#define SEC_AUD_LOCK_IMCLK_DS_INT                              (0xff64a000 + (0x009 << 2))
#define   P_AUD_LOCK_IMCLK_DS_INT                              (volatile uint32_t *)(0xff64a000 + (0x009 << 2))
#define     AUD_LOCK_OMCLK_DS_INT                              (0xff64a000 + (0x00a << 2))
#define SEC_AUD_LOCK_OMCLK_DS_INT                              (0xff64a000 + (0x00a << 2))
#define   P_AUD_LOCK_OMCLK_DS_INT                              (volatile uint32_t *)(0xff64a000 + (0x00a << 2))
#define     AUD_LOCK_INT_CLR                                   (0xff64a000 + (0x00b << 2))
#define SEC_AUD_LOCK_INT_CLR                                   (0xff64a000 + (0x00b << 2))
#define   P_AUD_LOCK_INT_CLR                                   (volatile uint32_t *)(0xff64a000 + (0x00b << 2))
#define     AUD_LOCK_GCLK_CTRL                                 (0xff64a000 + (0x00c << 2))
#define SEC_AUD_LOCK_GCLK_CTRL                                 (0xff64a000 + (0x00c << 2))
#define   P_AUD_LOCK_GCLK_CTRL                                 (volatile uint32_t *)(0xff64a000 + (0x00c << 2))
#define     AUD_LOCK_INT_CTRL                                  (0xff64a000 + (0x00d << 2))
#define SEC_AUD_LOCK_INT_CTRL                                  (0xff64a000 + (0x00d << 2))
#define   P_AUD_LOCK_INT_CTRL                                  (volatile uint32_t *)(0xff64a000 + (0x00d << 2))
#define     RO_REF2IMCLK_CNT_L                                 (0xff64a000 + (0x010 << 2))
#define SEC_RO_REF2IMCLK_CNT_L                                 (0xff64a000 + (0x010 << 2))
#define   P_RO_REF2IMCLK_CNT_L                                 (volatile uint32_t *)(0xff64a000 + (0x010 << 2))
#define     RO_REF2IMCLK_CNT_H                                 (0xff64a000 + (0x011 << 2))
#define SEC_RO_REF2IMCLK_CNT_H                                 (0xff64a000 + (0x011 << 2))
#define   P_RO_REF2IMCLK_CNT_H                                 (volatile uint32_t *)(0xff64a000 + (0x011 << 2))
#define     RO_REF2OMCLK_CNT_L                                 (0xff64a000 + (0x012 << 2))
#define SEC_RO_REF2OMCLK_CNT_L                                 (0xff64a000 + (0x012 << 2))
#define   P_RO_REF2OMCLK_CNT_L                                 (volatile uint32_t *)(0xff64a000 + (0x012 << 2))
#define     RO_REF2OMCLK_CNT_H                                 (0xff64a000 + (0x013 << 2))
#define SEC_RO_REF2OMCLK_CNT_H                                 (0xff64a000 + (0x013 << 2))
#define   P_RO_REF2OMCLK_CNT_H                                 (volatile uint32_t *)(0xff64a000 + (0x013 << 2))
#define     RO_IMCLK2REF_CNT_L                                 (0xff64a000 + (0x014 << 2))
#define SEC_RO_IMCLK2REF_CNT_L                                 (0xff64a000 + (0x014 << 2))
#define   P_RO_IMCLK2REF_CNT_L                                 (volatile uint32_t *)(0xff64a000 + (0x014 << 2))
#define     RO_IMCLK2REF_CNT_H                                 (0xff64a000 + (0x015 << 2))
#define SEC_RO_IMCLK2REF_CNT_H                                 (0xff64a000 + (0x015 << 2))
#define   P_RO_IMCLK2REF_CNT_H                                 (volatile uint32_t *)(0xff64a000 + (0x015 << 2))
#define     RO_OMCLK2REF_CNT_L                                 (0xff64a000 + (0x016 << 2))
#define SEC_RO_OMCLK2REF_CNT_L                                 (0xff64a000 + (0x016 << 2))
#define   P_RO_OMCLK2REF_CNT_L                                 (volatile uint32_t *)(0xff64a000 + (0x016 << 2))
#define     RO_OMCLK2REF_CNT_H                                 (0xff64a000 + (0x017 << 2))
#define SEC_RO_OMCLK2REF_CNT_H                                 (0xff64a000 + (0x017 << 2))
#define   P_RO_OMCLK2REF_CNT_H                                 (volatile uint32_t *)(0xff64a000 + (0x017 << 2))
#define     RO_REFCLK_PKG_CNT                                  (0xff64a000 + (0x018 << 2))
#define SEC_RO_REFCLK_PKG_CNT                                  (0xff64a000 + (0x018 << 2))
#define   P_RO_REFCLK_PKG_CNT                                  (volatile uint32_t *)(0xff64a000 + (0x018 << 2))
#define     RO_IMCLK_PKG_CNT                                   (0xff64a000 + (0x019 << 2))
#define SEC_RO_IMCLK_PKG_CNT                                   (0xff64a000 + (0x019 << 2))
#define   P_RO_IMCLK_PKG_CNT                                   (volatile uint32_t *)(0xff64a000 + (0x019 << 2))
#define     RO_OMCLK_PKG_CNT                                   (0xff64a000 + (0x01a << 2))
#define SEC_RO_OMCLK_PKG_CNT                                   (0xff64a000 + (0x01a << 2))
#define   P_RO_OMCLK_PKG_CNT                                   (volatile uint32_t *)(0xff64a000 + (0x01a << 2))
#define     RO_AUD_LOCK_INT_STATUS                             (0xff64a000 + (0x01b << 2))
#define SEC_RO_AUD_LOCK_INT_STATUS                             (0xff64a000 + (0x01b << 2))
#define   P_RO_AUD_LOCK_INT_STATUS                             (volatile uint32_t *)(0xff64a000 + (0x01b << 2))
//========================================================================
//  AUDIO - Registers
//========================================================================
// APB4_DECODER_NON_SECURE_BASE     32'hFF642000
// APB4_DECODER_SECURE_BASE         32'hFF642000
#define     EE_AUDIO_CLK_GATE_EN                               (0xff642000 + (0x000 << 2))
#define SEC_EE_AUDIO_CLK_GATE_EN                               (0xff642000 + (0x000 << 2))
#define   P_EE_AUDIO_CLK_GATE_EN                               (volatile uint32_t *)(0xff642000 + (0x000 << 2))
#define     EE_AUDIO_MCLK_A_CTRL                               (0xff642000 + (0x001 << 2))
#define SEC_EE_AUDIO_MCLK_A_CTRL                               (0xff642000 + (0x001 << 2))
#define   P_EE_AUDIO_MCLK_A_CTRL                               (volatile uint32_t *)(0xff642000 + (0x001 << 2))
#define     EE_AUDIO_MCLK_B_CTRL                               (0xff642000 + (0x002 << 2))
#define SEC_EE_AUDIO_MCLK_B_CTRL                               (0xff642000 + (0x002 << 2))
#define   P_EE_AUDIO_MCLK_B_CTRL                               (volatile uint32_t *)(0xff642000 + (0x002 << 2))
#define     EE_AUDIO_MCLK_C_CTRL                               (0xff642000 + (0x003 << 2))
#define SEC_EE_AUDIO_MCLK_C_CTRL                               (0xff642000 + (0x003 << 2))
#define   P_EE_AUDIO_MCLK_C_CTRL                               (volatile uint32_t *)(0xff642000 + (0x003 << 2))
#define     EE_AUDIO_MCLK_D_CTRL                               (0xff642000 + (0x004 << 2))
#define SEC_EE_AUDIO_MCLK_D_CTRL                               (0xff642000 + (0x004 << 2))
#define   P_EE_AUDIO_MCLK_D_CTRL                               (volatile uint32_t *)(0xff642000 + (0x004 << 2))
#define     EE_AUDIO_MCLK_E_CTRL                               (0xff642000 + (0x005 << 2))
#define SEC_EE_AUDIO_MCLK_E_CTRL                               (0xff642000 + (0x005 << 2))
#define   P_EE_AUDIO_MCLK_E_CTRL                               (volatile uint32_t *)(0xff642000 + (0x005 << 2))
#define     EE_AUDIO_MCLK_F_CTRL                               (0xff642000 + (0x006 << 2))
#define SEC_EE_AUDIO_MCLK_F_CTRL                               (0xff642000 + (0x006 << 2))
#define   P_EE_AUDIO_MCLK_F_CTRL                               (volatile uint32_t *)(0xff642000 + (0x006 << 2))
#define     EE_AUDIO_MST_A_SCLK_CTRL0                          (0xff642000 + (0x010 << 2))
#define SEC_EE_AUDIO_MST_A_SCLK_CTRL0                          (0xff642000 + (0x010 << 2))
#define   P_EE_AUDIO_MST_A_SCLK_CTRL0                          (volatile uint32_t *)(0xff642000 + (0x010 << 2))
#define     EE_AUDIO_MST_A_SCLK_CTRL1                          (0xff642000 + (0x011 << 2))
#define SEC_EE_AUDIO_MST_A_SCLK_CTRL1                          (0xff642000 + (0x011 << 2))
#define   P_EE_AUDIO_MST_A_SCLK_CTRL1                          (volatile uint32_t *)(0xff642000 + (0x011 << 2))
#define     EE_AUDIO_MST_B_SCLK_CTRL0                          (0xff642000 + (0x012 << 2))
#define SEC_EE_AUDIO_MST_B_SCLK_CTRL0                          (0xff642000 + (0x012 << 2))
#define   P_EE_AUDIO_MST_B_SCLK_CTRL0                          (volatile uint32_t *)(0xff642000 + (0x012 << 2))
#define     EE_AUDIO_MST_B_SCLK_CTRL1                          (0xff642000 + (0x013 << 2))
#define SEC_EE_AUDIO_MST_B_SCLK_CTRL1                          (0xff642000 + (0x013 << 2))
#define   P_EE_AUDIO_MST_B_SCLK_CTRL1                          (volatile uint32_t *)(0xff642000 + (0x013 << 2))
#define     EE_AUDIO_MST_C_SCLK_CTRL0                          (0xff642000 + (0x014 << 2))
#define SEC_EE_AUDIO_MST_C_SCLK_CTRL0                          (0xff642000 + (0x014 << 2))
#define   P_EE_AUDIO_MST_C_SCLK_CTRL0                          (volatile uint32_t *)(0xff642000 + (0x014 << 2))
#define     EE_AUDIO_MST_C_SCLK_CTRL1                          (0xff642000 + (0x015 << 2))
#define SEC_EE_AUDIO_MST_C_SCLK_CTRL1                          (0xff642000 + (0x015 << 2))
#define   P_EE_AUDIO_MST_C_SCLK_CTRL1                          (volatile uint32_t *)(0xff642000 + (0x015 << 2))
#define     EE_AUDIO_MST_D_SCLK_CTRL0                          (0xff642000 + (0x016 << 2))
#define SEC_EE_AUDIO_MST_D_SCLK_CTRL0                          (0xff642000 + (0x016 << 2))
#define   P_EE_AUDIO_MST_D_SCLK_CTRL0                          (volatile uint32_t *)(0xff642000 + (0x016 << 2))
#define     EE_AUDIO_MST_D_SCLK_CTRL1                          (0xff642000 + (0x017 << 2))
#define SEC_EE_AUDIO_MST_D_SCLK_CTRL1                          (0xff642000 + (0x017 << 2))
#define   P_EE_AUDIO_MST_D_SCLK_CTRL1                          (volatile uint32_t *)(0xff642000 + (0x017 << 2))
#define     EE_AUDIO_MST_E_SCLK_CTRL0                          (0xff642000 + (0x018 << 2))
#define SEC_EE_AUDIO_MST_E_SCLK_CTRL0                          (0xff642000 + (0x018 << 2))
#define   P_EE_AUDIO_MST_E_SCLK_CTRL0                          (volatile uint32_t *)(0xff642000 + (0x018 << 2))
#define     EE_AUDIO_MST_E_SCLK_CTRL1                          (0xff642000 + (0x019 << 2))
#define SEC_EE_AUDIO_MST_E_SCLK_CTRL1                          (0xff642000 + (0x019 << 2))
#define   P_EE_AUDIO_MST_E_SCLK_CTRL1                          (volatile uint32_t *)(0xff642000 + (0x019 << 2))
#define     EE_AUDIO_MST_F_SCLK_CTRL0                          (0xff642000 + (0x01a << 2))
#define SEC_EE_AUDIO_MST_F_SCLK_CTRL0                          (0xff642000 + (0x01a << 2))
#define   P_EE_AUDIO_MST_F_SCLK_CTRL0                          (volatile uint32_t *)(0xff642000 + (0x01a << 2))
#define     EE_AUDIO_MST_F_SCLK_CTRL1                          (0xff642000 + (0x01b << 2))
#define SEC_EE_AUDIO_MST_F_SCLK_CTRL1                          (0xff642000 + (0x01b << 2))
#define   P_EE_AUDIO_MST_F_SCLK_CTRL1                          (volatile uint32_t *)(0xff642000 + (0x01b << 2))
#define     EE_AUDIO_CLK_TDMIN_A_CTRL                          (0xff642000 + (0x020 << 2))
#define SEC_EE_AUDIO_CLK_TDMIN_A_CTRL                          (0xff642000 + (0x020 << 2))
#define   P_EE_AUDIO_CLK_TDMIN_A_CTRL                          (volatile uint32_t *)(0xff642000 + (0x020 << 2))
#define     EE_AUDIO_CLK_TDMIN_B_CTRL                          (0xff642000 + (0x021 << 2))
#define SEC_EE_AUDIO_CLK_TDMIN_B_CTRL                          (0xff642000 + (0x021 << 2))
#define   P_EE_AUDIO_CLK_TDMIN_B_CTRL                          (volatile uint32_t *)(0xff642000 + (0x021 << 2))
#define     EE_AUDIO_CLK_TDMIN_C_CTRL                          (0xff642000 + (0x022 << 2))
#define SEC_EE_AUDIO_CLK_TDMIN_C_CTRL                          (0xff642000 + (0x022 << 2))
#define   P_EE_AUDIO_CLK_TDMIN_C_CTRL                          (volatile uint32_t *)(0xff642000 + (0x022 << 2))
#define     EE_AUDIO_CLK_TDMIN_LB_CTRL                         (0xff642000 + (0x023 << 2))
#define SEC_EE_AUDIO_CLK_TDMIN_LB_CTRL                         (0xff642000 + (0x023 << 2))
#define   P_EE_AUDIO_CLK_TDMIN_LB_CTRL                         (volatile uint32_t *)(0xff642000 + (0x023 << 2))
#define     EE_AUDIO_CLK_TDMOUT_A_CTRL                         (0xff642000 + (0x024 << 2))
#define SEC_EE_AUDIO_CLK_TDMOUT_A_CTRL                         (0xff642000 + (0x024 << 2))
#define   P_EE_AUDIO_CLK_TDMOUT_A_CTRL                         (volatile uint32_t *)(0xff642000 + (0x024 << 2))
#define     EE_AUDIO_CLK_TDMOUT_B_CTRL                         (0xff642000 + (0x025 << 2))
#define SEC_EE_AUDIO_CLK_TDMOUT_B_CTRL                         (0xff642000 + (0x025 << 2))
#define   P_EE_AUDIO_CLK_TDMOUT_B_CTRL                         (volatile uint32_t *)(0xff642000 + (0x025 << 2))
#define     EE_AUDIO_CLK_TDMOUT_C_CTRL                         (0xff642000 + (0x026 << 2))
#define SEC_EE_AUDIO_CLK_TDMOUT_C_CTRL                         (0xff642000 + (0x026 << 2))
#define   P_EE_AUDIO_CLK_TDMOUT_C_CTRL                         (volatile uint32_t *)(0xff642000 + (0x026 << 2))
#define     EE_AUDIO_CLK_SPDIFIN_CTRL                          (0xff642000 + (0x027 << 2))
#define SEC_EE_AUDIO_CLK_SPDIFIN_CTRL                          (0xff642000 + (0x027 << 2))
#define   P_EE_AUDIO_CLK_SPDIFIN_CTRL                          (volatile uint32_t *)(0xff642000 + (0x027 << 2))
#define     EE_AUDIO_CLK_SPDIFOUT_CTRL                         (0xff642000 + (0x028 << 2))
#define SEC_EE_AUDIO_CLK_SPDIFOUT_CTRL                         (0xff642000 + (0x028 << 2))
#define   P_EE_AUDIO_CLK_SPDIFOUT_CTRL                         (volatile uint32_t *)(0xff642000 + (0x028 << 2))
#define     EE_AUDIO_CLK_RESAMPLE_CTRL                         (0xff642000 + (0x029 << 2))
#define SEC_EE_AUDIO_CLK_RESAMPLE_CTRL                         (0xff642000 + (0x029 << 2))
#define   P_EE_AUDIO_CLK_RESAMPLE_CTRL                         (volatile uint32_t *)(0xff642000 + (0x029 << 2))
#define     EE_AUDIO_CLK_LOCKER_CTRL                           (0xff642000 + (0x02a << 2))
#define SEC_EE_AUDIO_CLK_LOCKER_CTRL                           (0xff642000 + (0x02a << 2))
#define   P_EE_AUDIO_CLK_LOCKER_CTRL                           (volatile uint32_t *)(0xff642000 + (0x02a << 2))
#define     EE_AUDIO_CLK_PDMIN_CTRL0                           (0xff642000 + (0x02b << 2))
#define SEC_EE_AUDIO_CLK_PDMIN_CTRL0                           (0xff642000 + (0x02b << 2))
#define   P_EE_AUDIO_CLK_PDMIN_CTRL0                           (volatile uint32_t *)(0xff642000 + (0x02b << 2))
#define     EE_AUDIO_CLK_PDMIN_CTRL1                           (0xff642000 + (0x02c << 2))
#define SEC_EE_AUDIO_CLK_PDMIN_CTRL1                           (0xff642000 + (0x02c << 2))
#define   P_EE_AUDIO_CLK_PDMIN_CTRL1                           (volatile uint32_t *)(0xff642000 + (0x02c << 2))
#define     EE_AUDIO_TODDR_A_CTRL0                             (0xff642000 + (0x040 << 2))
#define SEC_EE_AUDIO_TODDR_A_CTRL0                             (0xff642000 + (0x040 << 2))
#define   P_EE_AUDIO_TODDR_A_CTRL0                             (volatile uint32_t *)(0xff642000 + (0x040 << 2))
#define     EE_AUDIO_TODDR_A_CTRL1                             (0xff642000 + (0x041 << 2))
#define SEC_EE_AUDIO_TODDR_A_CTRL1                             (0xff642000 + (0x041 << 2))
#define   P_EE_AUDIO_TODDR_A_CTRL1                             (volatile uint32_t *)(0xff642000 + (0x041 << 2))
#define     EE_AUDIO_TODDR_A_START_ADDR                        (0xff642000 + (0x042 << 2))
#define SEC_EE_AUDIO_TODDR_A_START_ADDR                        (0xff642000 + (0x042 << 2))
#define   P_EE_AUDIO_TODDR_A_START_ADDR                        (volatile uint32_t *)(0xff642000 + (0x042 << 2))
#define     EE_AUDIO_TODDR_A_FINISH_ADDR                       (0xff642000 + (0x043 << 2))
#define SEC_EE_AUDIO_TODDR_A_FINISH_ADDR                       (0xff642000 + (0x043 << 2))
#define   P_EE_AUDIO_TODDR_A_FINISH_ADDR                       (volatile uint32_t *)(0xff642000 + (0x043 << 2))
#define     EE_AUDIO_TODDR_A_INT_ADDR                          (0xff642000 + (0x044 << 2))
#define SEC_EE_AUDIO_TODDR_A_INT_ADDR                          (0xff642000 + (0x044 << 2))
#define   P_EE_AUDIO_TODDR_A_INT_ADDR                          (volatile uint32_t *)(0xff642000 + (0x044 << 2))
#define     EE_AUDIO_TODDR_A_STATUS1                           (0xff642000 + (0x045 << 2))
#define SEC_EE_AUDIO_TODDR_A_STATUS1                           (0xff642000 + (0x045 << 2))
#define   P_EE_AUDIO_TODDR_A_STATUS1                           (volatile uint32_t *)(0xff642000 + (0x045 << 2))
#define     EE_AUDIO_TODDR_A_STATUS2                           (0xff642000 + (0x046 << 2))
#define SEC_EE_AUDIO_TODDR_A_STATUS2                           (0xff642000 + (0x046 << 2))
#define   P_EE_AUDIO_TODDR_A_STATUS2                           (volatile uint32_t *)(0xff642000 + (0x046 << 2))
#define     EE_AUDIO_TODDR_A_START_ADDRB                       (0xff642000 + (0x047 << 2))
#define SEC_EE_AUDIO_TODDR_A_START_ADDRB                       (0xff642000 + (0x047 << 2))
#define   P_EE_AUDIO_TODDR_A_START_ADDRB                       (volatile uint32_t *)(0xff642000 + (0x047 << 2))
#define     EE_AUDIO_TODDR_A_FINISH_ADDRB                      (0xff642000 + (0x048 << 2))
#define SEC_EE_AUDIO_TODDR_A_FINISH_ADDRB                      (0xff642000 + (0x048 << 2))
#define   P_EE_AUDIO_TODDR_A_FINISH_ADDRB                      (volatile uint32_t *)(0xff642000 + (0x048 << 2))
#define     EE_AUDIO_TODDR_B_CTRL0                             (0xff642000 + (0x050 << 2))
#define SEC_EE_AUDIO_TODDR_B_CTRL0                             (0xff642000 + (0x050 << 2))
#define   P_EE_AUDIO_TODDR_B_CTRL0                             (volatile uint32_t *)(0xff642000 + (0x050 << 2))
#define     EE_AUDIO_TODDR_B_CTRL1                             (0xff642000 + (0x051 << 2))
#define SEC_EE_AUDIO_TODDR_B_CTRL1                             (0xff642000 + (0x051 << 2))
#define   P_EE_AUDIO_TODDR_B_CTRL1                             (volatile uint32_t *)(0xff642000 + (0x051 << 2))
#define     EE_AUDIO_TODDR_B_START_ADDR                        (0xff642000 + (0x052 << 2))
#define SEC_EE_AUDIO_TODDR_B_START_ADDR                        (0xff642000 + (0x052 << 2))
#define   P_EE_AUDIO_TODDR_B_START_ADDR                        (volatile uint32_t *)(0xff642000 + (0x052 << 2))
#define     EE_AUDIO_TODDR_B_FINISH_ADDR                       (0xff642000 + (0x053 << 2))
#define SEC_EE_AUDIO_TODDR_B_FINISH_ADDR                       (0xff642000 + (0x053 << 2))
#define   P_EE_AUDIO_TODDR_B_FINISH_ADDR                       (volatile uint32_t *)(0xff642000 + (0x053 << 2))
#define     EE_AUDIO_TODDR_B_INT_ADDR                          (0xff642000 + (0x054 << 2))
#define SEC_EE_AUDIO_TODDR_B_INT_ADDR                          (0xff642000 + (0x054 << 2))
#define   P_EE_AUDIO_TODDR_B_INT_ADDR                          (volatile uint32_t *)(0xff642000 + (0x054 << 2))
#define     EE_AUDIO_TODDR_B_STATUS1                           (0xff642000 + (0x055 << 2))
#define SEC_EE_AUDIO_TODDR_B_STATUS1                           (0xff642000 + (0x055 << 2))
#define   P_EE_AUDIO_TODDR_B_STATUS1                           (volatile uint32_t *)(0xff642000 + (0x055 << 2))
#define     EE_AUDIO_TODDR_B_STATUS2                           (0xff642000 + (0x056 << 2))
#define SEC_EE_AUDIO_TODDR_B_STATUS2                           (0xff642000 + (0x056 << 2))
#define   P_EE_AUDIO_TODDR_B_STATUS2                           (volatile uint32_t *)(0xff642000 + (0x056 << 2))
#define     EE_AUDIO_TODDR_B_START_ADDRB                       (0xff642000 + (0x057 << 2))
#define SEC_EE_AUDIO_TODDR_B_START_ADDRB                       (0xff642000 + (0x057 << 2))
#define   P_EE_AUDIO_TODDR_B_START_ADDRB                       (volatile uint32_t *)(0xff642000 + (0x057 << 2))
#define     EE_AUDIO_TODDR_B_FINISH_ADDRB                      (0xff642000 + (0x058 << 2))
#define SEC_EE_AUDIO_TODDR_B_FINISH_ADDRB                      (0xff642000 + (0x058 << 2))
#define   P_EE_AUDIO_TODDR_B_FINISH_ADDRB                      (volatile uint32_t *)(0xff642000 + (0x058 << 2))
#define     EE_AUDIO_TODDR_C_CTRL0                             (0xff642000 + (0x060 << 2))
#define SEC_EE_AUDIO_TODDR_C_CTRL0                             (0xff642000 + (0x060 << 2))
#define   P_EE_AUDIO_TODDR_C_CTRL0                             (volatile uint32_t *)(0xff642000 + (0x060 << 2))
#define     EE_AUDIO_TODDR_C_CTRL1                             (0xff642000 + (0x061 << 2))
#define SEC_EE_AUDIO_TODDR_C_CTRL1                             (0xff642000 + (0x061 << 2))
#define   P_EE_AUDIO_TODDR_C_CTRL1                             (volatile uint32_t *)(0xff642000 + (0x061 << 2))
#define     EE_AUDIO_TODDR_C_START_ADDR                        (0xff642000 + (0x062 << 2))
#define SEC_EE_AUDIO_TODDR_C_START_ADDR                        (0xff642000 + (0x062 << 2))
#define   P_EE_AUDIO_TODDR_C_START_ADDR                        (volatile uint32_t *)(0xff642000 + (0x062 << 2))
#define     EE_AUDIO_TODDR_C_FINISH_ADDR                       (0xff642000 + (0x063 << 2))
#define SEC_EE_AUDIO_TODDR_C_FINISH_ADDR                       (0xff642000 + (0x063 << 2))
#define   P_EE_AUDIO_TODDR_C_FINISH_ADDR                       (volatile uint32_t *)(0xff642000 + (0x063 << 2))
#define     EE_AUDIO_TODDR_C_INT_ADDR                          (0xff642000 + (0x064 << 2))
#define SEC_EE_AUDIO_TODDR_C_INT_ADDR                          (0xff642000 + (0x064 << 2))
#define   P_EE_AUDIO_TODDR_C_INT_ADDR                          (volatile uint32_t *)(0xff642000 + (0x064 << 2))
#define     EE_AUDIO_TODDR_C_STATUS1                           (0xff642000 + (0x065 << 2))
#define SEC_EE_AUDIO_TODDR_C_STATUS1                           (0xff642000 + (0x065 << 2))
#define   P_EE_AUDIO_TODDR_C_STATUS1                           (volatile uint32_t *)(0xff642000 + (0x065 << 2))
#define     EE_AUDIO_TODDR_C_STATUS2                           (0xff642000 + (0x066 << 2))
#define SEC_EE_AUDIO_TODDR_C_STATUS2                           (0xff642000 + (0x066 << 2))
#define   P_EE_AUDIO_TODDR_C_STATUS2                           (volatile uint32_t *)(0xff642000 + (0x066 << 2))
#define     EE_AUDIO_TODDR_C_START_ADDRB                       (0xff642000 + (0x067 << 2))
#define SEC_EE_AUDIO_TODDR_C_START_ADDRB                       (0xff642000 + (0x067 << 2))
#define   P_EE_AUDIO_TODDR_C_START_ADDRB                       (volatile uint32_t *)(0xff642000 + (0x067 << 2))
#define     EE_AUDIO_TODDR_C_FINISH_ADDRB                      (0xff642000 + (0x068 << 2))
#define SEC_EE_AUDIO_TODDR_C_FINISH_ADDRB                      (0xff642000 + (0x068 << 2))
#define   P_EE_AUDIO_TODDR_C_FINISH_ADDRB                      (volatile uint32_t *)(0xff642000 + (0x068 << 2))
#define     EE_AUDIO_FRDDR_A_CTRL0                             (0xff642000 + (0x070 << 2))
#define SEC_EE_AUDIO_FRDDR_A_CTRL0                             (0xff642000 + (0x070 << 2))
#define   P_EE_AUDIO_FRDDR_A_CTRL0                             (volatile uint32_t *)(0xff642000 + (0x070 << 2))
#define     EE_AUDIO_FRDDR_A_CTRL1                             (0xff642000 + (0x071 << 2))
#define SEC_EE_AUDIO_FRDDR_A_CTRL1                             (0xff642000 + (0x071 << 2))
#define   P_EE_AUDIO_FRDDR_A_CTRL1                             (volatile uint32_t *)(0xff642000 + (0x071 << 2))
#define     EE_AUDIO_FRDDR_A_START_ADDR                        (0xff642000 + (0x072 << 2))
#define SEC_EE_AUDIO_FRDDR_A_START_ADDR                        (0xff642000 + (0x072 << 2))
#define   P_EE_AUDIO_FRDDR_A_START_ADDR                        (volatile uint32_t *)(0xff642000 + (0x072 << 2))
#define     EE_AUDIO_FRDDR_A_FINISH_ADDR                       (0xff642000 + (0x073 << 2))
#define SEC_EE_AUDIO_FRDDR_A_FINISH_ADDR                       (0xff642000 + (0x073 << 2))
#define   P_EE_AUDIO_FRDDR_A_FINISH_ADDR                       (volatile uint32_t *)(0xff642000 + (0x073 << 2))
#define     EE_AUDIO_FRDDR_A_INT_ADDR                          (0xff642000 + (0x074 << 2))
#define SEC_EE_AUDIO_FRDDR_A_INT_ADDR                          (0xff642000 + (0x074 << 2))
#define   P_EE_AUDIO_FRDDR_A_INT_ADDR                          (volatile uint32_t *)(0xff642000 + (0x074 << 2))
#define     EE_AUDIO_FRDDR_A_STATUS1                           (0xff642000 + (0x075 << 2))
#define SEC_EE_AUDIO_FRDDR_A_STATUS1                           (0xff642000 + (0x075 << 2))
#define   P_EE_AUDIO_FRDDR_A_STATUS1                           (volatile uint32_t *)(0xff642000 + (0x075 << 2))
#define     EE_AUDIO_FRDDR_A_STATUS2                           (0xff642000 + (0x076 << 2))
#define SEC_EE_AUDIO_FRDDR_A_STATUS2                           (0xff642000 + (0x076 << 2))
#define   P_EE_AUDIO_FRDDR_A_STATUS2                           (volatile uint32_t *)(0xff642000 + (0x076 << 2))
#define     EE_AUDIO_FRDDR_A_START_ADDRB                       (0xff642000 + (0x077 << 2))
#define SEC_EE_AUDIO_FRDDR_A_START_ADDRB                       (0xff642000 + (0x077 << 2))
#define   P_EE_AUDIO_FRDDR_A_START_ADDRB                       (volatile uint32_t *)(0xff642000 + (0x077 << 2))
#define     EE_AUDIO_FRDDR_A_FINISH_ADDRB                      (0xff642000 + (0x078 << 2))
#define SEC_EE_AUDIO_FRDDR_A_FINISH_ADDRB                      (0xff642000 + (0x078 << 2))
#define   P_EE_AUDIO_FRDDR_A_FINISH_ADDRB                      (volatile uint32_t *)(0xff642000 + (0x078 << 2))
#define     EE_AUDIO_FRDDR_B_CTRL0                             (0xff642000 + (0x080 << 2))
#define SEC_EE_AUDIO_FRDDR_B_CTRL0                             (0xff642000 + (0x080 << 2))
#define   P_EE_AUDIO_FRDDR_B_CTRL0                             (volatile uint32_t *)(0xff642000 + (0x080 << 2))
#define     EE_AUDIO_FRDDR_B_CTRL1                             (0xff642000 + (0x081 << 2))
#define SEC_EE_AUDIO_FRDDR_B_CTRL1                             (0xff642000 + (0x081 << 2))
#define   P_EE_AUDIO_FRDDR_B_CTRL1                             (volatile uint32_t *)(0xff642000 + (0x081 << 2))
#define     EE_AUDIO_FRDDR_B_START_ADDR                        (0xff642000 + (0x082 << 2))
#define SEC_EE_AUDIO_FRDDR_B_START_ADDR                        (0xff642000 + (0x082 << 2))
#define   P_EE_AUDIO_FRDDR_B_START_ADDR                        (volatile uint32_t *)(0xff642000 + (0x082 << 2))
#define     EE_AUDIO_FRDDR_B_FINISH_ADDR                       (0xff642000 + (0x083 << 2))
#define SEC_EE_AUDIO_FRDDR_B_FINISH_ADDR                       (0xff642000 + (0x083 << 2))
#define   P_EE_AUDIO_FRDDR_B_FINISH_ADDR                       (volatile uint32_t *)(0xff642000 + (0x083 << 2))
#define     EE_AUDIO_FRDDR_B_INT_ADDR                          (0xff642000 + (0x084 << 2))
#define SEC_EE_AUDIO_FRDDR_B_INT_ADDR                          (0xff642000 + (0x084 << 2))
#define   P_EE_AUDIO_FRDDR_B_INT_ADDR                          (volatile uint32_t *)(0xff642000 + (0x084 << 2))
#define     EE_AUDIO_FRDDR_B_STATUS1                           (0xff642000 + (0x085 << 2))
#define SEC_EE_AUDIO_FRDDR_B_STATUS1                           (0xff642000 + (0x085 << 2))
#define   P_EE_AUDIO_FRDDR_B_STATUS1                           (volatile uint32_t *)(0xff642000 + (0x085 << 2))
#define     EE_AUDIO_FRDDR_B_STATUS2                           (0xff642000 + (0x086 << 2))
#define SEC_EE_AUDIO_FRDDR_B_STATUS2                           (0xff642000 + (0x086 << 2))
#define   P_EE_AUDIO_FRDDR_B_STATUS2                           (volatile uint32_t *)(0xff642000 + (0x086 << 2))
#define     EE_AUDIO_FRDDR_B_START_ADDRB                       (0xff642000 + (0x087 << 2))
#define SEC_EE_AUDIO_FRDDR_B_START_ADDRB                       (0xff642000 + (0x087 << 2))
#define   P_EE_AUDIO_FRDDR_B_START_ADDRB                       (volatile uint32_t *)(0xff642000 + (0x087 << 2))
#define     EE_AUDIO_FRDDR_B_FINISH_ADDRB                      (0xff642000 + (0x088 << 2))
#define SEC_EE_AUDIO_FRDDR_B_FINISH_ADDRB                      (0xff642000 + (0x088 << 2))
#define   P_EE_AUDIO_FRDDR_B_FINISH_ADDRB                      (volatile uint32_t *)(0xff642000 + (0x088 << 2))
#define     EE_AUDIO_FRDDR_C_CTRL0                             (0xff642000 + (0x090 << 2))
#define SEC_EE_AUDIO_FRDDR_C_CTRL0                             (0xff642000 + (0x090 << 2))
#define   P_EE_AUDIO_FRDDR_C_CTRL0                             (volatile uint32_t *)(0xff642000 + (0x090 << 2))
#define     EE_AUDIO_FRDDR_C_CTRL1                             (0xff642000 + (0x091 << 2))
#define SEC_EE_AUDIO_FRDDR_C_CTRL1                             (0xff642000 + (0x091 << 2))
#define   P_EE_AUDIO_FRDDR_C_CTRL1                             (volatile uint32_t *)(0xff642000 + (0x091 << 2))
#define     EE_AUDIO_FRDDR_C_START_ADDR                        (0xff642000 + (0x092 << 2))
#define SEC_EE_AUDIO_FRDDR_C_START_ADDR                        (0xff642000 + (0x092 << 2))
#define   P_EE_AUDIO_FRDDR_C_START_ADDR                        (volatile uint32_t *)(0xff642000 + (0x092 << 2))
#define     EE_AUDIO_FRDDR_C_FINISH_ADDR                       (0xff642000 + (0x093 << 2))
#define SEC_EE_AUDIO_FRDDR_C_FINISH_ADDR                       (0xff642000 + (0x093 << 2))
#define   P_EE_AUDIO_FRDDR_C_FINISH_ADDR                       (volatile uint32_t *)(0xff642000 + (0x093 << 2))
#define     EE_AUDIO_FRDDR_C_INT_ADDR                          (0xff642000 + (0x094 << 2))
#define SEC_EE_AUDIO_FRDDR_C_INT_ADDR                          (0xff642000 + (0x094 << 2))
#define   P_EE_AUDIO_FRDDR_C_INT_ADDR                          (volatile uint32_t *)(0xff642000 + (0x094 << 2))
#define     EE_AUDIO_FRDDR_C_STATUS1                           (0xff642000 + (0x095 << 2))
#define SEC_EE_AUDIO_FRDDR_C_STATUS1                           (0xff642000 + (0x095 << 2))
#define   P_EE_AUDIO_FRDDR_C_STATUS1                           (volatile uint32_t *)(0xff642000 + (0x095 << 2))
#define     EE_AUDIO_FRDDR_C_STATUS2                           (0xff642000 + (0x096 << 2))
#define SEC_EE_AUDIO_FRDDR_C_STATUS2                           (0xff642000 + (0x096 << 2))
#define   P_EE_AUDIO_FRDDR_C_STATUS2                           (volatile uint32_t *)(0xff642000 + (0x096 << 2))
#define     EE_AUDIO_FRDDR_C_START_ADDRB                       (0xff642000 + (0x097 << 2))
#define SEC_EE_AUDIO_FRDDR_C_START_ADDRB                       (0xff642000 + (0x097 << 2))
#define   P_EE_AUDIO_FRDDR_C_START_ADDRB                       (volatile uint32_t *)(0xff642000 + (0x097 << 2))
#define     EE_AUDIO_FRDDR_C_FINISH_ADDRB                      (0xff642000 + (0x098 << 2))
#define SEC_EE_AUDIO_FRDDR_C_FINISH_ADDRB                      (0xff642000 + (0x098 << 2))
#define   P_EE_AUDIO_FRDDR_C_FINISH_ADDRB                      (volatile uint32_t *)(0xff642000 + (0x098 << 2))
#define     EE_AUDIO_ARB_CTRL                                  (0xff642000 + (0x0a0 << 2))
#define SEC_EE_AUDIO_ARB_CTRL                                  (0xff642000 + (0x0a0 << 2))
#define   P_EE_AUDIO_ARB_CTRL                                  (volatile uint32_t *)(0xff642000 + (0x0a0 << 2))
#define     EE_AUDIO_LB_CTRL0                                  (0xff642000 + (0x0b0 << 2))
#define SEC_EE_AUDIO_LB_CTRL0                                  (0xff642000 + (0x0b0 << 2))
#define   P_EE_AUDIO_LB_CTRL0                                  (volatile uint32_t *)(0xff642000 + (0x0b0 << 2))
#define     EE_AUDIO_LB_CTRL1                                  (0xff642000 + (0x0b1 << 2))
#define SEC_EE_AUDIO_LB_CTRL1                                  (0xff642000 + (0x0b1 << 2))
#define   P_EE_AUDIO_LB_CTRL1                                  (volatile uint32_t *)(0xff642000 + (0x0b1 << 2))
#define     EE_AUDIO_TDMIN_A_CTRL                              (0xff642000 + (0x0c0 << 2))
#define SEC_EE_AUDIO_TDMIN_A_CTRL                              (0xff642000 + (0x0c0 << 2))
#define   P_EE_AUDIO_TDMIN_A_CTRL                              (volatile uint32_t *)(0xff642000 + (0x0c0 << 2))
#define     EE_AUDIO_TDMIN_A_SWAP                              (0xff642000 + (0x0c1 << 2))
#define SEC_EE_AUDIO_TDMIN_A_SWAP                              (0xff642000 + (0x0c1 << 2))
#define   P_EE_AUDIO_TDMIN_A_SWAP                              (volatile uint32_t *)(0xff642000 + (0x0c1 << 2))
#define     EE_AUDIO_TDMIN_A_MASK0                             (0xff642000 + (0x0c2 << 2))
#define SEC_EE_AUDIO_TDMIN_A_MASK0                             (0xff642000 + (0x0c2 << 2))
#define   P_EE_AUDIO_TDMIN_A_MASK0                             (volatile uint32_t *)(0xff642000 + (0x0c2 << 2))
#define     EE_AUDIO_TDMIN_A_MASK1                             (0xff642000 + (0x0c3 << 2))
#define SEC_EE_AUDIO_TDMIN_A_MASK1                             (0xff642000 + (0x0c3 << 2))
#define   P_EE_AUDIO_TDMIN_A_MASK1                             (volatile uint32_t *)(0xff642000 + (0x0c3 << 2))
#define     EE_AUDIO_TDMIN_A_MASK2                             (0xff642000 + (0x0c4 << 2))
#define SEC_EE_AUDIO_TDMIN_A_MASK2                             (0xff642000 + (0x0c4 << 2))
#define   P_EE_AUDIO_TDMIN_A_MASK2                             (volatile uint32_t *)(0xff642000 + (0x0c4 << 2))
#define     EE_AUDIO_TDMIN_A_MASK3                             (0xff642000 + (0x0c5 << 2))
#define SEC_EE_AUDIO_TDMIN_A_MASK3                             (0xff642000 + (0x0c5 << 2))
#define   P_EE_AUDIO_TDMIN_A_MASK3                             (volatile uint32_t *)(0xff642000 + (0x0c5 << 2))
#define     EE_AUDIO_TDMIN_A_STAT                              (0xff642000 + (0x0c6 << 2))
#define SEC_EE_AUDIO_TDMIN_A_STAT                              (0xff642000 + (0x0c6 << 2))
#define   P_EE_AUDIO_TDMIN_A_STAT                              (volatile uint32_t *)(0xff642000 + (0x0c6 << 2))
#define     EE_AUDIO_TDMIN_A_MUTE_VAL                          (0xff642000 + (0x0c7 << 2))
#define SEC_EE_AUDIO_TDMIN_A_MUTE_VAL                          (0xff642000 + (0x0c7 << 2))
#define   P_EE_AUDIO_TDMIN_A_MUTE_VAL                          (volatile uint32_t *)(0xff642000 + (0x0c7 << 2))
#define     EE_AUDIO_TDMIN_A_MUTE0                             (0xff642000 + (0x0c8 << 2))
#define SEC_EE_AUDIO_TDMIN_A_MUTE0                             (0xff642000 + (0x0c8 << 2))
#define   P_EE_AUDIO_TDMIN_A_MUTE0                             (volatile uint32_t *)(0xff642000 + (0x0c8 << 2))
#define     EE_AUDIO_TDMIN_A_MUTE1                             (0xff642000 + (0x0c9 << 2))
#define SEC_EE_AUDIO_TDMIN_A_MUTE1                             (0xff642000 + (0x0c9 << 2))
#define   P_EE_AUDIO_TDMIN_A_MUTE1                             (volatile uint32_t *)(0xff642000 + (0x0c9 << 2))
#define     EE_AUDIO_TDMIN_A_MUTE2                             (0xff642000 + (0x0ca << 2))
#define SEC_EE_AUDIO_TDMIN_A_MUTE2                             (0xff642000 + (0x0ca << 2))
#define   P_EE_AUDIO_TDMIN_A_MUTE2                             (volatile uint32_t *)(0xff642000 + (0x0ca << 2))
#define     EE_AUDIO_TDMIN_A_MUTE3                             (0xff642000 + (0x0cb << 2))
#define SEC_EE_AUDIO_TDMIN_A_MUTE3                             (0xff642000 + (0x0cb << 2))
#define   P_EE_AUDIO_TDMIN_A_MUTE3                             (volatile uint32_t *)(0xff642000 + (0x0cb << 2))
#define     EE_AUDIO_TDMIN_B_CTRL                              (0xff642000 + (0x0d0 << 2))
#define SEC_EE_AUDIO_TDMIN_B_CTRL                              (0xff642000 + (0x0d0 << 2))
#define   P_EE_AUDIO_TDMIN_B_CTRL                              (volatile uint32_t *)(0xff642000 + (0x0d0 << 2))
#define     EE_AUDIO_TDMIN_B_SWAP                              (0xff642000 + (0x0d1 << 2))
#define SEC_EE_AUDIO_TDMIN_B_SWAP                              (0xff642000 + (0x0d1 << 2))
#define   P_EE_AUDIO_TDMIN_B_SWAP                              (volatile uint32_t *)(0xff642000 + (0x0d1 << 2))
#define     EE_AUDIO_TDMIN_B_MASK0                             (0xff642000 + (0x0d2 << 2))
#define SEC_EE_AUDIO_TDMIN_B_MASK0                             (0xff642000 + (0x0d2 << 2))
#define   P_EE_AUDIO_TDMIN_B_MASK0                             (volatile uint32_t *)(0xff642000 + (0x0d2 << 2))
#define     EE_AUDIO_TDMIN_B_MASK1                             (0xff642000 + (0x0d3 << 2))
#define SEC_EE_AUDIO_TDMIN_B_MASK1                             (0xff642000 + (0x0d3 << 2))
#define   P_EE_AUDIO_TDMIN_B_MASK1                             (volatile uint32_t *)(0xff642000 + (0x0d3 << 2))
#define     EE_AUDIO_TDMIN_B_MASK2                             (0xff642000 + (0x0d4 << 2))
#define SEC_EE_AUDIO_TDMIN_B_MASK2                             (0xff642000 + (0x0d4 << 2))
#define   P_EE_AUDIO_TDMIN_B_MASK2                             (volatile uint32_t *)(0xff642000 + (0x0d4 << 2))
#define     EE_AUDIO_TDMIN_B_MASK3                             (0xff642000 + (0x0d5 << 2))
#define SEC_EE_AUDIO_TDMIN_B_MASK3                             (0xff642000 + (0x0d5 << 2))
#define   P_EE_AUDIO_TDMIN_B_MASK3                             (volatile uint32_t *)(0xff642000 + (0x0d5 << 2))
#define     EE_AUDIO_TDMIN_B_STAT                              (0xff642000 + (0x0d6 << 2))
#define SEC_EE_AUDIO_TDMIN_B_STAT                              (0xff642000 + (0x0d6 << 2))
#define   P_EE_AUDIO_TDMIN_B_STAT                              (volatile uint32_t *)(0xff642000 + (0x0d6 << 2))
#define     EE_AUDIO_TDMIN_B_MUTE_VAL                          (0xff642000 + (0x0d7 << 2))
#define SEC_EE_AUDIO_TDMIN_B_MUTE_VAL                          (0xff642000 + (0x0d7 << 2))
#define   P_EE_AUDIO_TDMIN_B_MUTE_VAL                          (volatile uint32_t *)(0xff642000 + (0x0d7 << 2))
#define     EE_AUDIO_TDMIN_B_MUTE0                             (0xff642000 + (0x0d8 << 2))
#define SEC_EE_AUDIO_TDMIN_B_MUTE0                             (0xff642000 + (0x0d8 << 2))
#define   P_EE_AUDIO_TDMIN_B_MUTE0                             (volatile uint32_t *)(0xff642000 + (0x0d8 << 2))
#define     EE_AUDIO_TDMIN_B_MUTE1                             (0xff642000 + (0x0d9 << 2))
#define SEC_EE_AUDIO_TDMIN_B_MUTE1                             (0xff642000 + (0x0d9 << 2))
#define   P_EE_AUDIO_TDMIN_B_MUTE1                             (volatile uint32_t *)(0xff642000 + (0x0d9 << 2))
#define     EE_AUDIO_TDMIN_B_MUTE2                             (0xff642000 + (0x0da << 2))
#define SEC_EE_AUDIO_TDMIN_B_MUTE2                             (0xff642000 + (0x0da << 2))
#define   P_EE_AUDIO_TDMIN_B_MUTE2                             (volatile uint32_t *)(0xff642000 + (0x0da << 2))
#define     EE_AUDIO_TDMIN_B_MUTE3                             (0xff642000 + (0x0db << 2))
#define SEC_EE_AUDIO_TDMIN_B_MUTE3                             (0xff642000 + (0x0db << 2))
#define   P_EE_AUDIO_TDMIN_B_MUTE3                             (volatile uint32_t *)(0xff642000 + (0x0db << 2))
#define     EE_AUDIO_TDMIN_C_CTRL                              (0xff642000 + (0x0e0 << 2))
#define SEC_EE_AUDIO_TDMIN_C_CTRL                              (0xff642000 + (0x0e0 << 2))
#define   P_EE_AUDIO_TDMIN_C_CTRL                              (volatile uint32_t *)(0xff642000 + (0x0e0 << 2))
#define     EE_AUDIO_TDMIN_C_SWAP                              (0xff642000 + (0x0e1 << 2))
#define SEC_EE_AUDIO_TDMIN_C_SWAP                              (0xff642000 + (0x0e1 << 2))
#define   P_EE_AUDIO_TDMIN_C_SWAP                              (volatile uint32_t *)(0xff642000 + (0x0e1 << 2))
#define     EE_AUDIO_TDMIN_C_MASK0                             (0xff642000 + (0x0e2 << 2))
#define SEC_EE_AUDIO_TDMIN_C_MASK0                             (0xff642000 + (0x0e2 << 2))
#define   P_EE_AUDIO_TDMIN_C_MASK0                             (volatile uint32_t *)(0xff642000 + (0x0e2 << 2))
#define     EE_AUDIO_TDMIN_C_MASK1                             (0xff642000 + (0x0e3 << 2))
#define SEC_EE_AUDIO_TDMIN_C_MASK1                             (0xff642000 + (0x0e3 << 2))
#define   P_EE_AUDIO_TDMIN_C_MASK1                             (volatile uint32_t *)(0xff642000 + (0x0e3 << 2))
#define     EE_AUDIO_TDMIN_C_MASK2                             (0xff642000 + (0x0e4 << 2))
#define SEC_EE_AUDIO_TDMIN_C_MASK2                             (0xff642000 + (0x0e4 << 2))
#define   P_EE_AUDIO_TDMIN_C_MASK2                             (volatile uint32_t *)(0xff642000 + (0x0e4 << 2))
#define     EE_AUDIO_TDMIN_C_MASK3                             (0xff642000 + (0x0e5 << 2))
#define SEC_EE_AUDIO_TDMIN_C_MASK3                             (0xff642000 + (0x0e5 << 2))
#define   P_EE_AUDIO_TDMIN_C_MASK3                             (volatile uint32_t *)(0xff642000 + (0x0e5 << 2))
#define     EE_AUDIO_TDMIN_C_STAT                              (0xff642000 + (0x0e6 << 2))
#define SEC_EE_AUDIO_TDMIN_C_STAT                              (0xff642000 + (0x0e6 << 2))
#define   P_EE_AUDIO_TDMIN_C_STAT                              (volatile uint32_t *)(0xff642000 + (0x0e6 << 2))
#define     EE_AUDIO_TDMIN_C_MUTE_VAL                          (0xff642000 + (0x0e7 << 2))
#define SEC_EE_AUDIO_TDMIN_C_MUTE_VAL                          (0xff642000 + (0x0e7 << 2))
#define   P_EE_AUDIO_TDMIN_C_MUTE_VAL                          (volatile uint32_t *)(0xff642000 + (0x0e7 << 2))
#define     EE_AUDIO_TDMIN_C_MUTE0                             (0xff642000 + (0x0e8 << 2))
#define SEC_EE_AUDIO_TDMIN_C_MUTE0                             (0xff642000 + (0x0e8 << 2))
#define   P_EE_AUDIO_TDMIN_C_MUTE0                             (volatile uint32_t *)(0xff642000 + (0x0e8 << 2))
#define     EE_AUDIO_TDMIN_C_MUTE1                             (0xff642000 + (0x0e9 << 2))
#define SEC_EE_AUDIO_TDMIN_C_MUTE1                             (0xff642000 + (0x0e9 << 2))
#define   P_EE_AUDIO_TDMIN_C_MUTE1                             (volatile uint32_t *)(0xff642000 + (0x0e9 << 2))
#define     EE_AUDIO_TDMIN_C_MUTE2                             (0xff642000 + (0x0ea << 2))
#define SEC_EE_AUDIO_TDMIN_C_MUTE2                             (0xff642000 + (0x0ea << 2))
#define   P_EE_AUDIO_TDMIN_C_MUTE2                             (volatile uint32_t *)(0xff642000 + (0x0ea << 2))
#define     EE_AUDIO_TDMIN_C_MUTE3                             (0xff642000 + (0x0eb << 2))
#define SEC_EE_AUDIO_TDMIN_C_MUTE3                             (0xff642000 + (0x0eb << 2))
#define   P_EE_AUDIO_TDMIN_C_MUTE3                             (volatile uint32_t *)(0xff642000 + (0x0eb << 2))
#define     EE_AUDIO_TDMIN_LB_CTRL                             (0xff642000 + (0x0f0 << 2))
#define SEC_EE_AUDIO_TDMIN_LB_CTRL                             (0xff642000 + (0x0f0 << 2))
#define   P_EE_AUDIO_TDMIN_LB_CTRL                             (volatile uint32_t *)(0xff642000 + (0x0f0 << 2))
#define     EE_AUDIO_TDMIN_LB_SWAP                             (0xff642000 + (0x0f1 << 2))
#define SEC_EE_AUDIO_TDMIN_LB_SWAP                             (0xff642000 + (0x0f1 << 2))
#define   P_EE_AUDIO_TDMIN_LB_SWAP                             (volatile uint32_t *)(0xff642000 + (0x0f1 << 2))
#define     EE_AUDIO_TDMIN_LB_MASK0                            (0xff642000 + (0x0f2 << 2))
#define SEC_EE_AUDIO_TDMIN_LB_MASK0                            (0xff642000 + (0x0f2 << 2))
#define   P_EE_AUDIO_TDMIN_LB_MASK0                            (volatile uint32_t *)(0xff642000 + (0x0f2 << 2))
#define     EE_AUDIO_TDMIN_LB_MASK1                            (0xff642000 + (0x0f3 << 2))
#define SEC_EE_AUDIO_TDMIN_LB_MASK1                            (0xff642000 + (0x0f3 << 2))
#define   P_EE_AUDIO_TDMIN_LB_MASK1                            (volatile uint32_t *)(0xff642000 + (0x0f3 << 2))
#define     EE_AUDIO_TDMIN_LB_MASK2                            (0xff642000 + (0x0f4 << 2))
#define SEC_EE_AUDIO_TDMIN_LB_MASK2                            (0xff642000 + (0x0f4 << 2))
#define   P_EE_AUDIO_TDMIN_LB_MASK2                            (volatile uint32_t *)(0xff642000 + (0x0f4 << 2))
#define     EE_AUDIO_TDMIN_LB_MASK3                            (0xff642000 + (0x0f5 << 2))
#define SEC_EE_AUDIO_TDMIN_LB_MASK3                            (0xff642000 + (0x0f5 << 2))
#define   P_EE_AUDIO_TDMIN_LB_MASK3                            (volatile uint32_t *)(0xff642000 + (0x0f5 << 2))
#define     EE_AUDIO_TDMIN_LB_STAT                             (0xff642000 + (0x0f6 << 2))
#define SEC_EE_AUDIO_TDMIN_LB_STAT                             (0xff642000 + (0x0f6 << 2))
#define   P_EE_AUDIO_TDMIN_LB_STAT                             (volatile uint32_t *)(0xff642000 + (0x0f6 << 2))
#define     EE_AUDIO_TDMIN_LB_MUTE_VAL                         (0xff642000 + (0x0f7 << 2))
#define SEC_EE_AUDIO_TDMIN_LB_MUTE_VAL                         (0xff642000 + (0x0f7 << 2))
#define   P_EE_AUDIO_TDMIN_LB_MUTE_VAL                         (volatile uint32_t *)(0xff642000 + (0x0f7 << 2))
#define     EE_AUDIO_TDMIN_LB_MUTE0                            (0xff642000 + (0x0f8 << 2))
#define SEC_EE_AUDIO_TDMIN_LB_MUTE0                            (0xff642000 + (0x0f8 << 2))
#define   P_EE_AUDIO_TDMIN_LB_MUTE0                            (volatile uint32_t *)(0xff642000 + (0x0f8 << 2))
#define     EE_AUDIO_TDMIN_LB_MUTE1                            (0xff642000 + (0x0f9 << 2))
#define SEC_EE_AUDIO_TDMIN_LB_MUTE1                            (0xff642000 + (0x0f9 << 2))
#define   P_EE_AUDIO_TDMIN_LB_MUTE1                            (volatile uint32_t *)(0xff642000 + (0x0f9 << 2))
#define     EE_AUDIO_TDMIN_LB_MUTE2                            (0xff642000 + (0x0fa << 2))
#define SEC_EE_AUDIO_TDMIN_LB_MUTE2                            (0xff642000 + (0x0fa << 2))
#define   P_EE_AUDIO_TDMIN_LB_MUTE2                            (volatile uint32_t *)(0xff642000 + (0x0fa << 2))
#define     EE_AUDIO_TDMIN_LB_MUTE3                            (0xff642000 + (0x0fb << 2))
#define SEC_EE_AUDIO_TDMIN_LB_MUTE3                            (0xff642000 + (0x0fb << 2))
#define   P_EE_AUDIO_TDMIN_LB_MUTE3                            (volatile uint32_t *)(0xff642000 + (0x0fb << 2))
#define     EE_AUDIO_SPDIFIN_CTRL0                             (0xff642000 + (0x100 << 2))
#define SEC_EE_AUDIO_SPDIFIN_CTRL0                             (0xff642000 + (0x100 << 2))
#define   P_EE_AUDIO_SPDIFIN_CTRL0                             (volatile uint32_t *)(0xff642000 + (0x100 << 2))
#define     EE_AUDIO_SPDIFIN_CTRL1                             (0xff642000 + (0x101 << 2))
#define SEC_EE_AUDIO_SPDIFIN_CTRL1                             (0xff642000 + (0x101 << 2))
#define   P_EE_AUDIO_SPDIFIN_CTRL1                             (volatile uint32_t *)(0xff642000 + (0x101 << 2))
#define     EE_AUDIO_SPDIFIN_CTRL2                             (0xff642000 + (0x102 << 2))
#define SEC_EE_AUDIO_SPDIFIN_CTRL2                             (0xff642000 + (0x102 << 2))
#define   P_EE_AUDIO_SPDIFIN_CTRL2                             (volatile uint32_t *)(0xff642000 + (0x102 << 2))
#define     EE_AUDIO_SPDIFIN_CTRL3                             (0xff642000 + (0x103 << 2))
#define SEC_EE_AUDIO_SPDIFIN_CTRL3                             (0xff642000 + (0x103 << 2))
#define   P_EE_AUDIO_SPDIFIN_CTRL3                             (volatile uint32_t *)(0xff642000 + (0x103 << 2))
#define     EE_AUDIO_SPDIFIN_CTRL4                             (0xff642000 + (0x104 << 2))
#define SEC_EE_AUDIO_SPDIFIN_CTRL4                             (0xff642000 + (0x104 << 2))
#define   P_EE_AUDIO_SPDIFIN_CTRL4                             (volatile uint32_t *)(0xff642000 + (0x104 << 2))
#define     EE_AUDIO_SPDIFIN_CTRL5                             (0xff642000 + (0x105 << 2))
#define SEC_EE_AUDIO_SPDIFIN_CTRL5                             (0xff642000 + (0x105 << 2))
#define   P_EE_AUDIO_SPDIFIN_CTRL5                             (volatile uint32_t *)(0xff642000 + (0x105 << 2))
#define     EE_AUDIO_SPDIFIN_CTRL6                             (0xff642000 + (0x106 << 2))
#define SEC_EE_AUDIO_SPDIFIN_CTRL6                             (0xff642000 + (0x106 << 2))
#define   P_EE_AUDIO_SPDIFIN_CTRL6                             (volatile uint32_t *)(0xff642000 + (0x106 << 2))
#define     EE_AUDIO_SPDIFIN_STAT0                             (0xff642000 + (0x107 << 2))
#define SEC_EE_AUDIO_SPDIFIN_STAT0                             (0xff642000 + (0x107 << 2))
#define   P_EE_AUDIO_SPDIFIN_STAT0                             (volatile uint32_t *)(0xff642000 + (0x107 << 2))
#define     EE_AUDIO_SPDIFIN_STAT1                             (0xff642000 + (0x108 << 2))
#define SEC_EE_AUDIO_SPDIFIN_STAT1                             (0xff642000 + (0x108 << 2))
#define   P_EE_AUDIO_SPDIFIN_STAT1                             (volatile uint32_t *)(0xff642000 + (0x108 << 2))
#define     EE_AUDIO_SPDIFIN_STAT2                             (0xff642000 + (0x109 << 2))
#define SEC_EE_AUDIO_SPDIFIN_STAT2                             (0xff642000 + (0x109 << 2))
#define   P_EE_AUDIO_SPDIFIN_STAT2                             (volatile uint32_t *)(0xff642000 + (0x109 << 2))
#define     EE_AUDIO_SPDIFIN_MUTE_VAL                          (0xff642000 + (0x10a << 2))
#define SEC_EE_AUDIO_SPDIFIN_MUTE_VAL                          (0xff642000 + (0x10a << 2))
#define   P_EE_AUDIO_SPDIFIN_MUTE_VAL                          (volatile uint32_t *)(0xff642000 + (0x10a << 2))
#define     EE_AUDIO_RESAMPLE_CTRL0                            (0xff642000 + (0x110 << 2))
#define SEC_EE_AUDIO_RESAMPLE_CTRL0                            (0xff642000 + (0x110 << 2))
#define   P_EE_AUDIO_RESAMPLE_CTRL0                            (volatile uint32_t *)(0xff642000 + (0x110 << 2))
#define     EE_AUDIO_RESAMPLE_CTRL1                            (0xff642000 + (0x111 << 2))
#define SEC_EE_AUDIO_RESAMPLE_CTRL1                            (0xff642000 + (0x111 << 2))
#define   P_EE_AUDIO_RESAMPLE_CTRL1                            (volatile uint32_t *)(0xff642000 + (0x111 << 2))
#define     EE_AUDIO_RESAMPLE_CTRL2                            (0xff642000 + (0x112 << 2))
#define SEC_EE_AUDIO_RESAMPLE_CTRL2                            (0xff642000 + (0x112 << 2))
#define   P_EE_AUDIO_RESAMPLE_CTRL2                            (volatile uint32_t *)(0xff642000 + (0x112 << 2))
#define     EE_AUDIO_RESAMPLE_CTRL3                            (0xff642000 + (0x113 << 2))
#define SEC_EE_AUDIO_RESAMPLE_CTRL3                            (0xff642000 + (0x113 << 2))
#define   P_EE_AUDIO_RESAMPLE_CTRL3                            (volatile uint32_t *)(0xff642000 + (0x113 << 2))
#define     EE_AUDIO_RESAMPLE_COEF0                            (0xff642000 + (0x114 << 2))
#define SEC_EE_AUDIO_RESAMPLE_COEF0                            (0xff642000 + (0x114 << 2))
#define   P_EE_AUDIO_RESAMPLE_COEF0                            (volatile uint32_t *)(0xff642000 + (0x114 << 2))
#define     EE_AUDIO_RESAMPLE_COEF1                            (0xff642000 + (0x115 << 2))
#define SEC_EE_AUDIO_RESAMPLE_COEF1                            (0xff642000 + (0x115 << 2))
#define   P_EE_AUDIO_RESAMPLE_COEF1                            (volatile uint32_t *)(0xff642000 + (0x115 << 2))
#define     EE_AUDIO_RESAMPLE_COEF2                            (0xff642000 + (0x116 << 2))
#define SEC_EE_AUDIO_RESAMPLE_COEF2                            (0xff642000 + (0x116 << 2))
#define   P_EE_AUDIO_RESAMPLE_COEF2                            (volatile uint32_t *)(0xff642000 + (0x116 << 2))
#define     EE_AUDIO_RESAMPLE_COEF3                            (0xff642000 + (0x117 << 2))
#define SEC_EE_AUDIO_RESAMPLE_COEF3                            (0xff642000 + (0x117 << 2))
#define   P_EE_AUDIO_RESAMPLE_COEF3                            (volatile uint32_t *)(0xff642000 + (0x117 << 2))
#define     EE_AUDIO_RESAMPLE_COEF4                            (0xff642000 + (0x118 << 2))
#define SEC_EE_AUDIO_RESAMPLE_COEF4                            (0xff642000 + (0x118 << 2))
#define   P_EE_AUDIO_RESAMPLE_COEF4                            (volatile uint32_t *)(0xff642000 + (0x118 << 2))
#define     EE_AUDIO_RESAMPLE_STATUS1                          (0xff642000 + (0x119 << 2))
#define SEC_EE_AUDIO_RESAMPLE_STATUS1                          (0xff642000 + (0x119 << 2))
#define   P_EE_AUDIO_RESAMPLE_STATUS1                          (volatile uint32_t *)(0xff642000 + (0x119 << 2))
#define     EE_AUDIO_SPDIFOUT_STAT                             (0xff642000 + (0x120 << 2))
#define SEC_EE_AUDIO_SPDIFOUT_STAT                             (0xff642000 + (0x120 << 2))
#define   P_EE_AUDIO_SPDIFOUT_STAT                             (volatile uint32_t *)(0xff642000 + (0x120 << 2))
#define     EE_AUDIO_SPDIFOUT_GAIN0                            (0xff642000 + (0x121 << 2))
#define SEC_EE_AUDIO_SPDIFOUT_GAIN0                            (0xff642000 + (0x121 << 2))
#define   P_EE_AUDIO_SPDIFOUT_GAIN0                            (volatile uint32_t *)(0xff642000 + (0x121 << 2))
#define     EE_AUDIO_SPDIFOUT_GAIN1                            (0xff642000 + (0x122 << 2))
#define SEC_EE_AUDIO_SPDIFOUT_GAIN1                            (0xff642000 + (0x122 << 2))
#define   P_EE_AUDIO_SPDIFOUT_GAIN1                            (volatile uint32_t *)(0xff642000 + (0x122 << 2))
#define     EE_AUDIO_SPDIFOUT_CTRL0                            (0xff642000 + (0x123 << 2))
#define SEC_EE_AUDIO_SPDIFOUT_CTRL0                            (0xff642000 + (0x123 << 2))
#define   P_EE_AUDIO_SPDIFOUT_CTRL0                            (volatile uint32_t *)(0xff642000 + (0x123 << 2))
#define     EE_AUDIO_SPDIFOUT_CTRL1                            (0xff642000 + (0x124 << 2))
#define SEC_EE_AUDIO_SPDIFOUT_CTRL1                            (0xff642000 + (0x124 << 2))
#define   P_EE_AUDIO_SPDIFOUT_CTRL1                            (volatile uint32_t *)(0xff642000 + (0x124 << 2))
#define     EE_AUDIO_SPDIFOUT_PREAMB                           (0xff642000 + (0x125 << 2))
#define SEC_EE_AUDIO_SPDIFOUT_PREAMB                           (0xff642000 + (0x125 << 2))
#define   P_EE_AUDIO_SPDIFOUT_PREAMB                           (volatile uint32_t *)(0xff642000 + (0x125 << 2))
#define     EE_AUDIO_SPDIFOUT_SWAP                             (0xff642000 + (0x126 << 2))
#define SEC_EE_AUDIO_SPDIFOUT_SWAP                             (0xff642000 + (0x126 << 2))
#define   P_EE_AUDIO_SPDIFOUT_SWAP                             (volatile uint32_t *)(0xff642000 + (0x126 << 2))
#define     EE_AUDIO_SPDIFOUT_CHSTS0                           (0xff642000 + (0x127 << 2))
#define SEC_EE_AUDIO_SPDIFOUT_CHSTS0                           (0xff642000 + (0x127 << 2))
#define   P_EE_AUDIO_SPDIFOUT_CHSTS0                           (volatile uint32_t *)(0xff642000 + (0x127 << 2))
#define     EE_AUDIO_SPDIFOUT_CHSTS1                           (0xff642000 + (0x128 << 2))
#define SEC_EE_AUDIO_SPDIFOUT_CHSTS1                           (0xff642000 + (0x128 << 2))
#define   P_EE_AUDIO_SPDIFOUT_CHSTS1                           (volatile uint32_t *)(0xff642000 + (0x128 << 2))
#define     EE_AUDIO_SPDIFOUT_CHSTS2                           (0xff642000 + (0x129 << 2))
#define SEC_EE_AUDIO_SPDIFOUT_CHSTS2                           (0xff642000 + (0x129 << 2))
#define   P_EE_AUDIO_SPDIFOUT_CHSTS2                           (volatile uint32_t *)(0xff642000 + (0x129 << 2))
#define     EE_AUDIO_SPDIFOUT_CHSTS3                           (0xff642000 + (0x12a << 2))
#define SEC_EE_AUDIO_SPDIFOUT_CHSTS3                           (0xff642000 + (0x12a << 2))
#define   P_EE_AUDIO_SPDIFOUT_CHSTS3                           (volatile uint32_t *)(0xff642000 + (0x12a << 2))
#define     EE_AUDIO_SPDIFOUT_CHSTS4                           (0xff642000 + (0x12b << 2))
#define SEC_EE_AUDIO_SPDIFOUT_CHSTS4                           (0xff642000 + (0x12b << 2))
#define   P_EE_AUDIO_SPDIFOUT_CHSTS4                           (volatile uint32_t *)(0xff642000 + (0x12b << 2))
#define     EE_AUDIO_SPDIFOUT_CHSTS5                           (0xff642000 + (0x12c << 2))
#define SEC_EE_AUDIO_SPDIFOUT_CHSTS5                           (0xff642000 + (0x12c << 2))
#define   P_EE_AUDIO_SPDIFOUT_CHSTS5                           (volatile uint32_t *)(0xff642000 + (0x12c << 2))
#define     EE_AUDIO_SPDIFOUT_CHSTS6                           (0xff642000 + (0x12d << 2))
#define SEC_EE_AUDIO_SPDIFOUT_CHSTS6                           (0xff642000 + (0x12d << 2))
#define   P_EE_AUDIO_SPDIFOUT_CHSTS6                           (volatile uint32_t *)(0xff642000 + (0x12d << 2))
#define     EE_AUDIO_SPDIFOUT_CHSTS7                           (0xff642000 + (0x12e << 2))
#define SEC_EE_AUDIO_SPDIFOUT_CHSTS7                           (0xff642000 + (0x12e << 2))
#define   P_EE_AUDIO_SPDIFOUT_CHSTS7                           (volatile uint32_t *)(0xff642000 + (0x12e << 2))
#define     EE_AUDIO_SPDIFOUT_CHSTS8                           (0xff642000 + (0x12f << 2))
#define SEC_EE_AUDIO_SPDIFOUT_CHSTS8                           (0xff642000 + (0x12f << 2))
#define   P_EE_AUDIO_SPDIFOUT_CHSTS8                           (volatile uint32_t *)(0xff642000 + (0x12f << 2))
#define     EE_AUDIO_SPDIFOUT_CHSTS9                           (0xff642000 + (0x130 << 2))
#define SEC_EE_AUDIO_SPDIFOUT_CHSTS9                           (0xff642000 + (0x130 << 2))
#define   P_EE_AUDIO_SPDIFOUT_CHSTS9                           (volatile uint32_t *)(0xff642000 + (0x130 << 2))
#define     EE_AUDIO_SPDIFOUT_CHSTSA                           (0xff642000 + (0x131 << 2))
#define SEC_EE_AUDIO_SPDIFOUT_CHSTSA                           (0xff642000 + (0x131 << 2))
#define   P_EE_AUDIO_SPDIFOUT_CHSTSA                           (volatile uint32_t *)(0xff642000 + (0x131 << 2))
#define     EE_AUDIO_SPDIFOUT_CHSTSB                           (0xff642000 + (0x132 << 2))
#define SEC_EE_AUDIO_SPDIFOUT_CHSTSB                           (0xff642000 + (0x132 << 2))
#define   P_EE_AUDIO_SPDIFOUT_CHSTSB                           (volatile uint32_t *)(0xff642000 + (0x132 << 2))
#define     EE_AUDIO_SPDIFOUT_MUTE_VAL                         (0xff642000 + (0x133 << 2))
#define SEC_EE_AUDIO_SPDIFOUT_MUTE_VAL                         (0xff642000 + (0x133 << 2))
#define   P_EE_AUDIO_SPDIFOUT_MUTE_VAL                         (volatile uint32_t *)(0xff642000 + (0x133 << 2))
#define     EE_AUDIO_TDMOUT_A_CTRL0                            (0xff642000 + (0x140 << 2))
#define SEC_EE_AUDIO_TDMOUT_A_CTRL0                            (0xff642000 + (0x140 << 2))
#define   P_EE_AUDIO_TDMOUT_A_CTRL0                            (volatile uint32_t *)(0xff642000 + (0x140 << 2))
#define     EE_AUDIO_TDMOUT_A_CTRL1                            (0xff642000 + (0x141 << 2))
#define SEC_EE_AUDIO_TDMOUT_A_CTRL1                            (0xff642000 + (0x141 << 2))
#define   P_EE_AUDIO_TDMOUT_A_CTRL1                            (volatile uint32_t *)(0xff642000 + (0x141 << 2))
#define     EE_AUDIO_TDMOUT_A_SWAP                             (0xff642000 + (0x142 << 2))
#define SEC_EE_AUDIO_TDMOUT_A_SWAP                             (0xff642000 + (0x142 << 2))
#define   P_EE_AUDIO_TDMOUT_A_SWAP                             (volatile uint32_t *)(0xff642000 + (0x142 << 2))
#define     EE_AUDIO_TDMOUT_A_MASK0                            (0xff642000 + (0x143 << 2))
#define SEC_EE_AUDIO_TDMOUT_A_MASK0                            (0xff642000 + (0x143 << 2))
#define   P_EE_AUDIO_TDMOUT_A_MASK0                            (volatile uint32_t *)(0xff642000 + (0x143 << 2))
#define     EE_AUDIO_TDMOUT_A_MASK1                            (0xff642000 + (0x144 << 2))
#define SEC_EE_AUDIO_TDMOUT_A_MASK1                            (0xff642000 + (0x144 << 2))
#define   P_EE_AUDIO_TDMOUT_A_MASK1                            (volatile uint32_t *)(0xff642000 + (0x144 << 2))
#define     EE_AUDIO_TDMOUT_A_MASK2                            (0xff642000 + (0x145 << 2))
#define SEC_EE_AUDIO_TDMOUT_A_MASK2                            (0xff642000 + (0x145 << 2))
#define   P_EE_AUDIO_TDMOUT_A_MASK2                            (volatile uint32_t *)(0xff642000 + (0x145 << 2))
#define     EE_AUDIO_TDMOUT_A_MASK3                            (0xff642000 + (0x146 << 2))
#define SEC_EE_AUDIO_TDMOUT_A_MASK3                            (0xff642000 + (0x146 << 2))
#define   P_EE_AUDIO_TDMOUT_A_MASK3                            (volatile uint32_t *)(0xff642000 + (0x146 << 2))
#define     EE_AUDIO_TDMOUT_A_STAT                             (0xff642000 + (0x147 << 2))
#define SEC_EE_AUDIO_TDMOUT_A_STAT                             (0xff642000 + (0x147 << 2))
#define   P_EE_AUDIO_TDMOUT_A_STAT                             (volatile uint32_t *)(0xff642000 + (0x147 << 2))
#define     EE_AUDIO_TDMOUT_A_GAIN0                            (0xff642000 + (0x148 << 2))
#define SEC_EE_AUDIO_TDMOUT_A_GAIN0                            (0xff642000 + (0x148 << 2))
#define   P_EE_AUDIO_TDMOUT_A_GAIN0                            (volatile uint32_t *)(0xff642000 + (0x148 << 2))
#define     EE_AUDIO_TDMOUT_A_GAIN1                            (0xff642000 + (0x149 << 2))
#define SEC_EE_AUDIO_TDMOUT_A_GAIN1                            (0xff642000 + (0x149 << 2))
#define   P_EE_AUDIO_TDMOUT_A_GAIN1                            (volatile uint32_t *)(0xff642000 + (0x149 << 2))
#define     EE_AUDIO_TDMOUT_A_MUTE_VAL                         (0xff642000 + (0x14a << 2))
#define SEC_EE_AUDIO_TDMOUT_A_MUTE_VAL                         (0xff642000 + (0x14a << 2))
#define   P_EE_AUDIO_TDMOUT_A_MUTE_VAL                         (volatile uint32_t *)(0xff642000 + (0x14a << 2))
#define     EE_AUDIO_TDMOUT_A_MUTE0                            (0xff642000 + (0x14b << 2))
#define SEC_EE_AUDIO_TDMOUT_A_MUTE0                            (0xff642000 + (0x14b << 2))
#define   P_EE_AUDIO_TDMOUT_A_MUTE0                            (volatile uint32_t *)(0xff642000 + (0x14b << 2))
#define     EE_AUDIO_TDMOUT_A_MUTE1                            (0xff642000 + (0x14c << 2))
#define SEC_EE_AUDIO_TDMOUT_A_MUTE1                            (0xff642000 + (0x14c << 2))
#define   P_EE_AUDIO_TDMOUT_A_MUTE1                            (volatile uint32_t *)(0xff642000 + (0x14c << 2))
#define     EE_AUDIO_TDMOUT_A_MUTE2                            (0xff642000 + (0x14d << 2))
#define SEC_EE_AUDIO_TDMOUT_A_MUTE2                            (0xff642000 + (0x14d << 2))
#define   P_EE_AUDIO_TDMOUT_A_MUTE2                            (volatile uint32_t *)(0xff642000 + (0x14d << 2))
#define     EE_AUDIO_TDMOUT_A_MUTE3                            (0xff642000 + (0x14e << 2))
#define SEC_EE_AUDIO_TDMOUT_A_MUTE3                            (0xff642000 + (0x14e << 2))
#define   P_EE_AUDIO_TDMOUT_A_MUTE3                            (volatile uint32_t *)(0xff642000 + (0x14e << 2))
#define     EE_AUDIO_TDMOUT_A_MASK_VAL                         (0xff642000 + (0x14f << 2))
#define SEC_EE_AUDIO_TDMOUT_A_MASK_VAL                         (0xff642000 + (0x14f << 2))
#define   P_EE_AUDIO_TDMOUT_A_MASK_VAL                         (volatile uint32_t *)(0xff642000 + (0x14f << 2))
#define     EE_AUDIO_TDMOUT_B_CTRL0                            (0xff642000 + (0x150 << 2))
#define SEC_EE_AUDIO_TDMOUT_B_CTRL0                            (0xff642000 + (0x150 << 2))
#define   P_EE_AUDIO_TDMOUT_B_CTRL0                            (volatile uint32_t *)(0xff642000 + (0x150 << 2))
#define     EE_AUDIO_TDMOUT_B_CTRL1                            (0xff642000 + (0x151 << 2))
#define SEC_EE_AUDIO_TDMOUT_B_CTRL1                            (0xff642000 + (0x151 << 2))
#define   P_EE_AUDIO_TDMOUT_B_CTRL1                            (volatile uint32_t *)(0xff642000 + (0x151 << 2))
#define     EE_AUDIO_TDMOUT_B_SWAP                             (0xff642000 + (0x152 << 2))
#define SEC_EE_AUDIO_TDMOUT_B_SWAP                             (0xff642000 + (0x152 << 2))
#define   P_EE_AUDIO_TDMOUT_B_SWAP                             (volatile uint32_t *)(0xff642000 + (0x152 << 2))
#define     EE_AUDIO_TDMOUT_B_MASK0                            (0xff642000 + (0x153 << 2))
#define SEC_EE_AUDIO_TDMOUT_B_MASK0                            (0xff642000 + (0x153 << 2))
#define   P_EE_AUDIO_TDMOUT_B_MASK0                            (volatile uint32_t *)(0xff642000 + (0x153 << 2))
#define     EE_AUDIO_TDMOUT_B_MASK1                            (0xff642000 + (0x154 << 2))
#define SEC_EE_AUDIO_TDMOUT_B_MASK1                            (0xff642000 + (0x154 << 2))
#define   P_EE_AUDIO_TDMOUT_B_MASK1                            (volatile uint32_t *)(0xff642000 + (0x154 << 2))
#define     EE_AUDIO_TDMOUT_B_MASK2                            (0xff642000 + (0x155 << 2))
#define SEC_EE_AUDIO_TDMOUT_B_MASK2                            (0xff642000 + (0x155 << 2))
#define   P_EE_AUDIO_TDMOUT_B_MASK2                            (volatile uint32_t *)(0xff642000 + (0x155 << 2))
#define     EE_AUDIO_TDMOUT_B_MASK3                            (0xff642000 + (0x156 << 2))
#define SEC_EE_AUDIO_TDMOUT_B_MASK3                            (0xff642000 + (0x156 << 2))
#define   P_EE_AUDIO_TDMOUT_B_MASK3                            (volatile uint32_t *)(0xff642000 + (0x156 << 2))
#define     EE_AUDIO_TDMOUT_B_STAT                             (0xff642000 + (0x157 << 2))
#define SEC_EE_AUDIO_TDMOUT_B_STAT                             (0xff642000 + (0x157 << 2))
#define   P_EE_AUDIO_TDMOUT_B_STAT                             (volatile uint32_t *)(0xff642000 + (0x157 << 2))
#define     EE_AUDIO_TDMOUT_B_GAIN0                            (0xff642000 + (0x158 << 2))
#define SEC_EE_AUDIO_TDMOUT_B_GAIN0                            (0xff642000 + (0x158 << 2))
#define   P_EE_AUDIO_TDMOUT_B_GAIN0                            (volatile uint32_t *)(0xff642000 + (0x158 << 2))
#define     EE_AUDIO_TDMOUT_B_GAIN1                            (0xff642000 + (0x159 << 2))
#define SEC_EE_AUDIO_TDMOUT_B_GAIN1                            (0xff642000 + (0x159 << 2))
#define   P_EE_AUDIO_TDMOUT_B_GAIN1                            (volatile uint32_t *)(0xff642000 + (0x159 << 2))
#define     EE_AUDIO_TDMOUT_B_MUTE_VAL                         (0xff642000 + (0x15a << 2))
#define SEC_EE_AUDIO_TDMOUT_B_MUTE_VAL                         (0xff642000 + (0x15a << 2))
#define   P_EE_AUDIO_TDMOUT_B_MUTE_VAL                         (volatile uint32_t *)(0xff642000 + (0x15a << 2))
#define     EE_AUDIO_TDMOUT_B_MUTE0                            (0xff642000 + (0x15b << 2))
#define SEC_EE_AUDIO_TDMOUT_B_MUTE0                            (0xff642000 + (0x15b << 2))
#define   P_EE_AUDIO_TDMOUT_B_MUTE0                            (volatile uint32_t *)(0xff642000 + (0x15b << 2))
#define     EE_AUDIO_TDMOUT_B_MUTE1                            (0xff642000 + (0x15c << 2))
#define SEC_EE_AUDIO_TDMOUT_B_MUTE1                            (0xff642000 + (0x15c << 2))
#define   P_EE_AUDIO_TDMOUT_B_MUTE1                            (volatile uint32_t *)(0xff642000 + (0x15c << 2))
#define     EE_AUDIO_TDMOUT_B_MUTE2                            (0xff642000 + (0x15d << 2))
#define SEC_EE_AUDIO_TDMOUT_B_MUTE2                            (0xff642000 + (0x15d << 2))
#define   P_EE_AUDIO_TDMOUT_B_MUTE2                            (volatile uint32_t *)(0xff642000 + (0x15d << 2))
#define     EE_AUDIO_TDMOUT_B_MUTE3                            (0xff642000 + (0x15e << 2))
#define SEC_EE_AUDIO_TDMOUT_B_MUTE3                            (0xff642000 + (0x15e << 2))
#define   P_EE_AUDIO_TDMOUT_B_MUTE3                            (volatile uint32_t *)(0xff642000 + (0x15e << 2))
#define     EE_AUDIO_TDMOUT_B_MASK_VAL                         (0xff642000 + (0x15f << 2))
#define SEC_EE_AUDIO_TDMOUT_B_MASK_VAL                         (0xff642000 + (0x15f << 2))
#define   P_EE_AUDIO_TDMOUT_B_MASK_VAL                         (volatile uint32_t *)(0xff642000 + (0x15f << 2))
#define     EE_AUDIO_TDMOUT_C_CTRL0                            (0xff642000 + (0x160 << 2))
#define SEC_EE_AUDIO_TDMOUT_C_CTRL0                            (0xff642000 + (0x160 << 2))
#define   P_EE_AUDIO_TDMOUT_C_CTRL0                            (volatile uint32_t *)(0xff642000 + (0x160 << 2))
#define     EE_AUDIO_TDMOUT_C_CTRL1                            (0xff642000 + (0x161 << 2))
#define SEC_EE_AUDIO_TDMOUT_C_CTRL1                            (0xff642000 + (0x161 << 2))
#define   P_EE_AUDIO_TDMOUT_C_CTRL1                            (volatile uint32_t *)(0xff642000 + (0x161 << 2))
#define     EE_AUDIO_TDMOUT_C_SWAP                             (0xff642000 + (0x162 << 2))
#define SEC_EE_AUDIO_TDMOUT_C_SWAP                             (0xff642000 + (0x162 << 2))
#define   P_EE_AUDIO_TDMOUT_C_SWAP                             (volatile uint32_t *)(0xff642000 + (0x162 << 2))
#define     EE_AUDIO_TDMOUT_C_MASK0                            (0xff642000 + (0x163 << 2))
#define SEC_EE_AUDIO_TDMOUT_C_MASK0                            (0xff642000 + (0x163 << 2))
#define   P_EE_AUDIO_TDMOUT_C_MASK0                            (volatile uint32_t *)(0xff642000 + (0x163 << 2))
#define     EE_AUDIO_TDMOUT_C_MASK1                            (0xff642000 + (0x164 << 2))
#define SEC_EE_AUDIO_TDMOUT_C_MASK1                            (0xff642000 + (0x164 << 2))
#define   P_EE_AUDIO_TDMOUT_C_MASK1                            (volatile uint32_t *)(0xff642000 + (0x164 << 2))
#define     EE_AUDIO_TDMOUT_C_MASK2                            (0xff642000 + (0x165 << 2))
#define SEC_EE_AUDIO_TDMOUT_C_MASK2                            (0xff642000 + (0x165 << 2))
#define   P_EE_AUDIO_TDMOUT_C_MASK2                            (volatile uint32_t *)(0xff642000 + (0x165 << 2))
#define     EE_AUDIO_TDMOUT_C_MASK3                            (0xff642000 + (0x166 << 2))
#define SEC_EE_AUDIO_TDMOUT_C_MASK3                            (0xff642000 + (0x166 << 2))
#define   P_EE_AUDIO_TDMOUT_C_MASK3                            (volatile uint32_t *)(0xff642000 + (0x166 << 2))
#define     EE_AUDIO_TDMOUT_C_STAT                             (0xff642000 + (0x167 << 2))
#define SEC_EE_AUDIO_TDMOUT_C_STAT                             (0xff642000 + (0x167 << 2))
#define   P_EE_AUDIO_TDMOUT_C_STAT                             (volatile uint32_t *)(0xff642000 + (0x167 << 2))
#define     EE_AUDIO_TDMOUT_C_GAIN0                            (0xff642000 + (0x168 << 2))
#define SEC_EE_AUDIO_TDMOUT_C_GAIN0                            (0xff642000 + (0x168 << 2))
#define   P_EE_AUDIO_TDMOUT_C_GAIN0                            (volatile uint32_t *)(0xff642000 + (0x168 << 2))
#define     EE_AUDIO_TDMOUT_C_GAIN1                            (0xff642000 + (0x169 << 2))
#define SEC_EE_AUDIO_TDMOUT_C_GAIN1                            (0xff642000 + (0x169 << 2))
#define   P_EE_AUDIO_TDMOUT_C_GAIN1                            (volatile uint32_t *)(0xff642000 + (0x169 << 2))
#define     EE_AUDIO_TDMOUT_C_MUTE_VAL                         (0xff642000 + (0x16a << 2))
#define SEC_EE_AUDIO_TDMOUT_C_MUTE_VAL                         (0xff642000 + (0x16a << 2))
#define   P_EE_AUDIO_TDMOUT_C_MUTE_VAL                         (volatile uint32_t *)(0xff642000 + (0x16a << 2))
#define     EE_AUDIO_TDMOUT_C_MUTE0                            (0xff642000 + (0x16b << 2))
#define SEC_EE_AUDIO_TDMOUT_C_MUTE0                            (0xff642000 + (0x16b << 2))
#define   P_EE_AUDIO_TDMOUT_C_MUTE0                            (volatile uint32_t *)(0xff642000 + (0x16b << 2))
#define     EE_AUDIO_TDMOUT_C_MUTE1                            (0xff642000 + (0x16c << 2))
#define SEC_EE_AUDIO_TDMOUT_C_MUTE1                            (0xff642000 + (0x16c << 2))
#define   P_EE_AUDIO_TDMOUT_C_MUTE1                            (volatile uint32_t *)(0xff642000 + (0x16c << 2))
#define     EE_AUDIO_TDMOUT_C_MUTE2                            (0xff642000 + (0x16d << 2))
#define SEC_EE_AUDIO_TDMOUT_C_MUTE2                            (0xff642000 + (0x16d << 2))
#define   P_EE_AUDIO_TDMOUT_C_MUTE2                            (volatile uint32_t *)(0xff642000 + (0x16d << 2))
#define     EE_AUDIO_TDMOUT_C_MUTE3                            (0xff642000 + (0x16e << 2))
#define SEC_EE_AUDIO_TDMOUT_C_MUTE3                            (0xff642000 + (0x16e << 2))
#define   P_EE_AUDIO_TDMOUT_C_MUTE3                            (volatile uint32_t *)(0xff642000 + (0x16e << 2))
#define     EE_AUDIO_TDMOUT_C_MASK_VAL                         (0xff642000 + (0x16f << 2))
#define SEC_EE_AUDIO_TDMOUT_C_MASK_VAL                         (0xff642000 + (0x16f << 2))
#define   P_EE_AUDIO_TDMOUT_C_MASK_VAL                         (volatile uint32_t *)(0xff642000 + (0x16f << 2))
#define     EE_AUDIO_POW_DET_CTRL0                             (0xff642000 + (0x180 << 2))
#define SEC_EE_AUDIO_POW_DET_CTRL0                             (0xff642000 + (0x180 << 2))
#define   P_EE_AUDIO_POW_DET_CTRL0                             (volatile uint32_t *)(0xff642000 + (0x180 << 2))
#define     EE_AUDIO_POW_DET_TH_HI                             (0xff642000 + (0x181 << 2))
#define SEC_EE_AUDIO_POW_DET_TH_HI                             (0xff642000 + (0x181 << 2))
#define   P_EE_AUDIO_POW_DET_TH_HI                             (volatile uint32_t *)(0xff642000 + (0x181 << 2))
#define     EE_AUDIO_POW_DET_TH_LO                             (0xff642000 + (0x182 << 2))
#define SEC_EE_AUDIO_POW_DET_TH_LO                             (0xff642000 + (0x182 << 2))
#define   P_EE_AUDIO_POW_DET_TH_LO                             (volatile uint32_t *)(0xff642000 + (0x182 << 2))
#define     EE_AUDIO_POW_DET_VALUE                             (0xff642000 + (0x183 << 2))
#define SEC_EE_AUDIO_POW_DET_VALUE                             (0xff642000 + (0x183 << 2))
#define   P_EE_AUDIO_POW_DET_VALUE                             (volatile uint32_t *)(0xff642000 + (0x183 << 2))
#define     EE_AUDIO_SECURITY_CTRL                             (0xff642000 + (0x193 << 2))
#define SEC_EE_AUDIO_SECURITY_CTRL                             (0xff642000 + (0x193 << 2))
#define   P_EE_AUDIO_SECURITY_CTRL                             (volatile uint32_t *)(0xff642000 + (0x193 << 2))
//========================================================================
//  HIU - Registers
//========================================================================
// APB4_DECODER_NON_SECURE_BASE     32'hFF63C000
// APB4_DECODER_SECURE_BASE         32'hFF63C000
#define     HHI_MIPI_CNTL0                                     (0xff63c000 + (0x000 << 2))
#define SEC_HHI_MIPI_CNTL0                                     (0xff63c000 + (0x000 << 2))
#define   P_HHI_MIPI_CNTL0                                     (volatile uint32_t *)(0xff63c000 + (0x000 << 2))
#define     HHI_MIPI_CNTL1                                     (0xff63c000 + (0x001 << 2))
#define SEC_HHI_MIPI_CNTL1                                     (0xff63c000 + (0x001 << 2))
#define   P_HHI_MIPI_CNTL1                                     (volatile uint32_t *)(0xff63c000 + (0x001 << 2))
#define     HHI_MIPI_CNTL2                                     (0xff63c000 + (0x002 << 2))
#define SEC_HHI_MIPI_CNTL2                                     (0xff63c000 + (0x002 << 2))
#define   P_HHI_MIPI_CNTL2                                     (volatile uint32_t *)(0xff63c000 + (0x002 << 2))
#define     HHI_GP0_PLL_CNTL                                   (0xff63c000 + (0x010 << 2))
#define SEC_HHI_GP0_PLL_CNTL                                   (0xff63c000 + (0x010 << 2))
#define   P_HHI_GP0_PLL_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x010 << 2))
#define     HHI_GP0_PLL_CNTL2                                  (0xff63c000 + (0x011 << 2))
#define SEC_HHI_GP0_PLL_CNTL2                                  (0xff63c000 + (0x011 << 2))
#define   P_HHI_GP0_PLL_CNTL2                                  (volatile uint32_t *)(0xff63c000 + (0x011 << 2))
#define     HHI_GP0_PLL_CNTL3                                  (0xff63c000 + (0x012 << 2))
#define SEC_HHI_GP0_PLL_CNTL3                                  (0xff63c000 + (0x012 << 2))
#define   P_HHI_GP0_PLL_CNTL3                                  (volatile uint32_t *)(0xff63c000 + (0x012 << 2))
#define     HHI_GP0_PLL_CNTL4                                  (0xff63c000 + (0x013 << 2))
#define SEC_HHI_GP0_PLL_CNTL4                                  (0xff63c000 + (0x013 << 2))
#define   P_HHI_GP0_PLL_CNTL4                                  (volatile uint32_t *)(0xff63c000 + (0x013 << 2))
#define     HHI_GP0_PLL_CNTL5                                  (0xff63c000 + (0x014 << 2))
#define SEC_HHI_GP0_PLL_CNTL5                                  (0xff63c000 + (0x014 << 2))
#define   P_HHI_GP0_PLL_CNTL5                                  (volatile uint32_t *)(0xff63c000 + (0x014 << 2))
#define     HHI_GP0_PLL_STS                                    (0xff63c000 + (0x015 << 2))
#define SEC_HHI_GP0_PLL_STS                                    (0xff63c000 + (0x015 << 2))
#define   P_HHI_GP0_PLL_STS                                    (volatile uint32_t *)(0xff63c000 + (0x015 << 2))
#define     HHI_GP0_PLL_CNTL1                                  (0xff63c000 + (0x016 << 2))
#define SEC_HHI_GP0_PLL_CNTL1                                  (0xff63c000 + (0x016 << 2))
#define   P_HHI_GP0_PLL_CNTL1                                  (volatile uint32_t *)(0xff63c000 + (0x016 << 2))
#define     HHI_HIFI_PLL_CNTL                                  (0xff63c000 + (0x020 << 2))
#define SEC_HHI_HIFI_PLL_CNTL                                  (0xff63c000 + (0x020 << 2))
#define   P_HHI_HIFI_PLL_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x020 << 2))
#define     HHI_HIFI_PLL_CNTL2                                 (0xff63c000 + (0x021 << 2))
#define SEC_HHI_HIFI_PLL_CNTL2                                 (0xff63c000 + (0x021 << 2))
#define   P_HHI_HIFI_PLL_CNTL2                                 (volatile uint32_t *)(0xff63c000 + (0x021 << 2))
#define     HHI_HIFI_PLL_CNTL3                                 (0xff63c000 + (0x022 << 2))
#define SEC_HHI_HIFI_PLL_CNTL3                                 (0xff63c000 + (0x022 << 2))
#define   P_HHI_HIFI_PLL_CNTL3                                 (volatile uint32_t *)(0xff63c000 + (0x022 << 2))
#define     HHI_HIFI_PLL_CNTL4                                 (0xff63c000 + (0x023 << 2))
#define SEC_HHI_HIFI_PLL_CNTL4                                 (0xff63c000 + (0x023 << 2))
#define   P_HHI_HIFI_PLL_CNTL4                                 (volatile uint32_t *)(0xff63c000 + (0x023 << 2))
#define     HHI_HIFI_PLL_CNTL5                                 (0xff63c000 + (0x024 << 2))
#define SEC_HHI_HIFI_PLL_CNTL5                                 (0xff63c000 + (0x024 << 2))
#define   P_HHI_HIFI_PLL_CNTL5                                 (volatile uint32_t *)(0xff63c000 + (0x024 << 2))
#define     HHI_HIFI_PLL_STS                                   (0xff63c000 + (0x025 << 2))
#define SEC_HHI_HIFI_PLL_STS                                   (0xff63c000 + (0x025 << 2))
#define   P_HHI_HIFI_PLL_STS                                   (volatile uint32_t *)(0xff63c000 + (0x025 << 2))
#define     HHI_HIFI_PLL_CNTL1                                 (0xff63c000 + (0x026 << 2))
#define SEC_HHI_HIFI_PLL_CNTL1                                 (0xff63c000 + (0x026 << 2))
#define   P_HHI_HIFI_PLL_CNTL1                                 (volatile uint32_t *)(0xff63c000 + (0x026 << 2))
#define     HHI_XTAL_DIVN_CNTL                                 (0xff63c000 + (0x02f << 2))
#define SEC_HHI_XTAL_DIVN_CNTL                                 (0xff63c000 + (0x02f << 2))
#define   P_HHI_XTAL_DIVN_CNTL                                 (volatile uint32_t *)(0xff63c000 + (0x02f << 2))
#define     HHI_GCLK2_MPEG0                                    (0xff63c000 + (0x030 << 2))
#define SEC_HHI_GCLK2_MPEG0                                    (0xff63c000 + (0x030 << 2))
#define   P_HHI_GCLK2_MPEG0                                    (volatile uint32_t *)(0xff63c000 + (0x030 << 2))
#define     HHI_GCLK2_MPEG1                                    (0xff63c000 + (0x031 << 2))
#define SEC_HHI_GCLK2_MPEG1                                    (0xff63c000 + (0x031 << 2))
#define   P_HHI_GCLK2_MPEG1                                    (volatile uint32_t *)(0xff63c000 + (0x031 << 2))
#define     HHI_GCLK2_MPEG2                                    (0xff63c000 + (0x032 << 2))
#define SEC_HHI_GCLK2_MPEG2                                    (0xff63c000 + (0x032 << 2))
#define   P_HHI_GCLK2_MPEG2                                    (volatile uint32_t *)(0xff63c000 + (0x032 << 2))
#define     HHI_GCLK2_OTHER                                    (0xff63c000 + (0x034 << 2))
#define SEC_HHI_GCLK2_OTHER                                    (0xff63c000 + (0x034 << 2))
#define   P_HHI_GCLK2_OTHER                                    (volatile uint32_t *)(0xff63c000 + (0x034 << 2))
#define     HHI_GCLK2_AO                                       (0xff63c000 + (0x035 << 2))
#define SEC_HHI_GCLK2_AO                                       (0xff63c000 + (0x035 << 2))
#define   P_HHI_GCLK2_AO                                       (volatile uint32_t *)(0xff63c000 + (0x035 << 2))
#define     HHI_PCIE_PLL_CNTL                                  (0xff63c000 + (0x036 << 2))
#define SEC_HHI_PCIE_PLL_CNTL                                  (0xff63c000 + (0x036 << 2))
#define   P_HHI_PCIE_PLL_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x036 << 2))
#define     HHI_PCIE_PLL_CNTL1                                 (0xff63c000 + (0x037 << 2))
#define SEC_HHI_PCIE_PLL_CNTL1                                 (0xff63c000 + (0x037 << 2))
#define   P_HHI_PCIE_PLL_CNTL1                                 (volatile uint32_t *)(0xff63c000 + (0x037 << 2))
#define     HHI_PCIE_PLL_CNTL2                                 (0xff63c000 + (0x038 << 2))
#define SEC_HHI_PCIE_PLL_CNTL2                                 (0xff63c000 + (0x038 << 2))
#define   P_HHI_PCIE_PLL_CNTL2                                 (volatile uint32_t *)(0xff63c000 + (0x038 << 2))
#define     HHI_PCIE_PLL_CNTL3                                 (0xff63c000 + (0x039 << 2))
#define SEC_HHI_PCIE_PLL_CNTL3                                 (0xff63c000 + (0x039 << 2))
#define   P_HHI_PCIE_PLL_CNTL3                                 (volatile uint32_t *)(0xff63c000 + (0x039 << 2))
#define     HHI_PCIE_PLL_CNTL4                                 (0xff63c000 + (0x03a << 2))
#define SEC_HHI_PCIE_PLL_CNTL4                                 (0xff63c000 + (0x03a << 2))
#define   P_HHI_PCIE_PLL_CNTL4                                 (volatile uint32_t *)(0xff63c000 + (0x03a << 2))
#define     HHI_PCIE_PLL_CNTL5                                 (0xff63c000 + (0x03b << 2))
#define SEC_HHI_PCIE_PLL_CNTL5                                 (0xff63c000 + (0x03b << 2))
#define   P_HHI_PCIE_PLL_CNTL5                                 (volatile uint32_t *)(0xff63c000 + (0x03b << 2))
#define     HHI_PCIE_PLL_CNTL6                                 (0xff63c000 + (0x03c << 2))
#define SEC_HHI_PCIE_PLL_CNTL6                                 (0xff63c000 + (0x03c << 2))
#define   P_HHI_PCIE_PLL_CNTL6                                 (volatile uint32_t *)(0xff63c000 + (0x03c << 2))
#define     HHI_PCIE_PLL_STS                                   (0xff63c000 + (0x03d << 2))
#define SEC_HHI_PCIE_PLL_STS                                   (0xff63c000 + (0x03d << 2))
#define   P_HHI_PCIE_PLL_STS                                   (volatile uint32_t *)(0xff63c000 + (0x03d << 2))
//`define HHI_TIMER90K          8'h3b // 90kHz timer divisor
#define     HHI_MEM_PD_REG0                                    (0xff63c000 + (0x040 << 2))
#define SEC_HHI_MEM_PD_REG0                                    (0xff63c000 + (0x040 << 2))
#define   P_HHI_MEM_PD_REG0                                    (volatile uint32_t *)(0xff63c000 + (0x040 << 2))
//VIU1
//bit 29:28 mem_pd_vi_sharp,  2'b00: Sharpness line buffer memory power on, 2'b11: power down
//bit 29:28 mem_pd_vi_dipost, 2'b00: Deinterlace - di_post memory power on, 2'b11: power down
//bit 27:26 mem_pd_vi_dipre,  2'b00: Deinterlace - di_pre memory power on, 2'b11: power down
//bit 25:24 mem_pd_vi_prot3,  2'b00: picture rotation3 memory power on, 2'b11: power down
//bit 23:22 mem_pd_vi_prot2,  2'b00: picture rotation2 memory power on, 2'b11: power down
//bit 21:20 mem_pd_vi_prot1,  2'b00: picture rotation1 memory power on, 2'b11: power down
//bit 19:18 mem_pd_vi_vdin1,  2'b00: vdin1 memory power on, 2'b11: power down
//bit 17:16 mem_pd_vi_vdin0,  2'b00: vdin0 memory power on, 2'b11: power down
//bit 15:14 mem_pd_vi_osd_sc, 2'b00: osd_scaler memory power on, 2'b11: power down
//bit 13:12 mem_pd_vi_scale,  2'b00: scaler memory power on, 2'b11: power down
//bit 11:10 mem_pd_vi_ofifo,  2'b00: vpp output fifo memory power on, 2'b11: power down
//bit 9:8   mem_pd_vi_chroma, 2'b00: color management module memory power on, 2'b11: power down
//bit 7:6   mem_pd_vi_vd2,    2'b00: vd2 memory power on, 2'b11: power down
//bit 5:4   mem_pd_vi_vd1,    2'b00: vd1 memory power on, 2'b11: power down
//bit 3:2   mem_pd_vi_osd2,   2'b00: osd2 memory power on, 2'b11: power down
//bit 1:0   mem_pd_vi_osd1,   2'b00: osd1 memory power on, 2'b11: power down
#define     HHI_VPU_MEM_PD_REG0                                (0xff63c000 + (0x041 << 2))
#define SEC_HHI_VPU_MEM_PD_REG0                                (0xff63c000 + (0x041 << 2))
#define   P_HHI_VPU_MEM_PD_REG0                                (volatile uint32_t *)(0xff63c000 + (0x041 << 2))
//bit 29:28 mem_pd_atv_dmd,   2'b00: ATV DMD memory power on, 2'b11: power down
//bit 29:28 mem_pd_cvd2,      2'b00: CVD2 memory power on, 2'b11: power down
//bit 27:26 mem_pd_isp,       2'b00: ISP memory power on, 2'b11: power down
//bit 25:24 mem_pd_venci_int, 2'b00: cvbs- enci interface memory power on, 2'b11: power down
//bit 23:22 mem_pd_venc_l_top,2'b00: panel - encl top memory power on, 2'b11: power down
//bit 21:20 mem_pd_vencp_int, 2'b00: hdmi - encp interface memory power on, 2'b11: power down
//bit 13:12 mem_pd_vi2_osd_sc,2'b00: viu2 OSD scaler memory power on, 2'b11: power down
//bit 11:10 mem_pd_vi2_scale, 2'b00: viu2 scaler memory power on, 2'b11: power down
//bit 9:8   mem_pd_vi2_ofifo, 2'b00: viu2 vpp output fifo memory power on, 2'b11: power down
//bit 7:6   mem_pd_vi2_chroma,2'b00: viu2 color management module memory power on, 2'b11: power down
//bit 5:4   mem_pd_vi2_vd1,   2'b00: viu2 vd1 memory power on, 2'b11: power down
//bit 3:2   mem_pd_vi2_osd2,  2'b00: viu2 osd2 memory power on, 2'b11: power down
//bit 1:0   mem_pd_vi2_osd1,  2'b00: viu2 osd1 memory power on, 2'b11: power down
//`define HHI_VPU_MEM_PD_REG1     8'h42
//`define HHI_DEMOD_MEM_PD_REG     8'h43
//`define HHI_AUD_DAC_CTRL          8'h44
// `define HHI_VIID_PLL_CNTL4      8'h46 // video PLL read back
// `define HHI_VIID_PLL_CNTL       8'h47 // Video PLL control, word 1
// `define HHI_VIID_PLL_CNTL2      8'h48 // Video PLL control, word 2
// `define HHI_VIID_PLL_CNTL3      8'h49 // Video PLL control, word 3
#define     HHI_VIID_CLK_DIV                                   (0xff63c000 + (0x04a << 2))
#define SEC_HHI_VIID_CLK_DIV                                   (0xff63c000 + (0x04a << 2))
#define   P_HHI_VIID_CLK_DIV                                   (volatile uint32_t *)(0xff63c000 + (0x04a << 2))
#define     HHI_VIID_CLK_CNTL                                  (0xff63c000 + (0x04b << 2))
#define SEC_HHI_VIID_CLK_CNTL                                  (0xff63c000 + (0x04b << 2))
#define   P_HHI_VIID_CLK_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x04b << 2))
//`define HHI_VIID_DIVIDER_CNTL   8'h4c
//bit 1:0   mem_pd_vi_wm,  2'b00: viu1 wm memory power on, 2'b11: power down
//`define HHI_VPU_MEM_PD_REG2     8'h4d
// Gated clock enables.  There are 64 enables for the MPEG clocks and 32 enables for other clock domains
#define     HHI_GCLK_MPEG0                                     (0xff63c000 + (0x050 << 2))
#define SEC_HHI_GCLK_MPEG0                                     (0xff63c000 + (0x050 << 2))
#define   P_HHI_GCLK_MPEG0                                     (volatile uint32_t *)(0xff63c000 + (0x050 << 2))
#define     HHI_GCLK_MPEG1                                     (0xff63c000 + (0x051 << 2))
#define SEC_HHI_GCLK_MPEG1                                     (0xff63c000 + (0x051 << 2))
#define   P_HHI_GCLK_MPEG1                                     (volatile uint32_t *)(0xff63c000 + (0x051 << 2))
#define     HHI_GCLK_MPEG2                                     (0xff63c000 + (0x052 << 2))
#define SEC_HHI_GCLK_MPEG2                                     (0xff63c000 + (0x052 << 2))
#define   P_HHI_GCLK_MPEG2                                     (volatile uint32_t *)(0xff63c000 + (0x052 << 2))
#define     HHI_GCLK_OTHER                                     (0xff63c000 + (0x054 << 2))
#define SEC_HHI_GCLK_OTHER                                     (0xff63c000 + (0x054 << 2))
#define   P_HHI_GCLK_OTHER                                     (volatile uint32_t *)(0xff63c000 + (0x054 << 2))
#define     HHI_GCLK_AO                                        (0xff63c000 + (0x055 << 2))
#define SEC_HHI_GCLK_AO                                        (0xff63c000 + (0x055 << 2))
#define   P_HHI_GCLK_AO                                        (volatile uint32_t *)(0xff63c000 + (0x055 << 2))
//`define HHI_SYS_OSCIN_CNTL      8'h56
#define     HHI_SYS_CPU_CLK_CNTL1                              (0xff63c000 + (0x057 << 2))
#define SEC_HHI_SYS_CPU_CLK_CNTL1                              (0xff63c000 + (0x057 << 2))
#define   P_HHI_SYS_CPU_CLK_CNTL1                              (volatile uint32_t *)(0xff63c000 + (0x057 << 2))
#define     HHI_SYS_CPU_RESET_CNTL                             (0xff63c000 + (0x058 << 2))
#define SEC_HHI_SYS_CPU_RESET_CNTL                             (0xff63c000 + (0x058 << 2))
#define   P_HHI_SYS_CPU_RESET_CNTL                             (volatile uint32_t *)(0xff63c000 + (0x058 << 2))
// PLL Controls
#define     HHI_VID_CLK_DIV                                    (0xff63c000 + (0x059 << 2))
#define SEC_HHI_VID_CLK_DIV                                    (0xff63c000 + (0x059 << 2))
#define   P_HHI_VID_CLK_DIV                                    (volatile uint32_t *)(0xff63c000 + (0x059 << 2))
#define     HHI_SPICC_HCLK_CNTL                                (0xff63c000 + (0x05a << 2))
#define SEC_HHI_SPICC_HCLK_CNTL                                (0xff63c000 + (0x05a << 2))
#define   P_HHI_SPICC_HCLK_CNTL                                (volatile uint32_t *)(0xff63c000 + (0x05a << 2))
//`define HHI_GE2D_CLK_CNTL       8'h5b // ge2d clock control
#define     HHI_MPEG_CLK_CNTL                                  (0xff63c000 + (0x05d << 2))
#define SEC_HHI_MPEG_CLK_CNTL                                  (0xff63c000 + (0x05d << 2))
#define   P_HHI_MPEG_CLK_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x05d << 2))
#define     HHI_VID_CLK_CNTL                                   (0xff63c000 + (0x05f << 2))
#define SEC_HHI_VID_CLK_CNTL                                   (0xff63c000 + (0x05f << 2))
#define   P_HHI_VID_CLK_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x05f << 2))
//`define HHI_AUD_CLK_CNTL        8'h60 // Audio clock control, word 1
//`define HHI_AUD_CLK_CNTL2       8'h61 // Audio clock control, word 2, for controlling clocks on the ADC part of Audio CODEC
//`define HHI_AUD_CLK_CNTL3       8'h62
//`define HHI_AUD_CLK_CNTL4       8'h63
#define     HHI_TS_CLK_CNTL                                    (0xff63c000 + (0x064 << 2))
#define SEC_HHI_TS_CLK_CNTL                                    (0xff63c000 + (0x064 << 2))
#define   P_HHI_TS_CLK_CNTL                                    (volatile uint32_t *)(0xff63c000 + (0x064 << 2))
#define     HHI_VID_CLK_CNTL2                                  (0xff63c000 + (0x065 << 2))
#define SEC_HHI_VID_CLK_CNTL2                                  (0xff63c000 + (0x065 << 2))
#define   P_HHI_VID_CLK_CNTL2                                  (volatile uint32_t *)(0xff63c000 + (0x065 << 2))
//`define HHI_VID_DIVIDER_CNTL    8'h66
#define     HHI_SYS_CPU_CLK_CNTL                               (0xff63c000 + (0x067 << 2))
#define SEC_HHI_SYS_CPU_CLK_CNTL                               (0xff63c000 + (0x067 << 2))
#define   P_HHI_SYS_CPU_CLK_CNTL                               (volatile uint32_t *)(0xff63c000 + (0x067 << 2))
#define     HHI_VID_PLL_CLK_DIV                                (0xff63c000 + (0x068 << 2))
#define SEC_HHI_VID_PLL_CLK_DIV                                (0xff63c000 + (0x068 << 2))
#define   P_HHI_VID_PLL_CLK_DIV                                (volatile uint32_t *)(0xff63c000 + (0x068 << 2))
//`define HHI_MIPI_PHY_CLK_CNTL   8'h6e
#define     HHI_VPU_CLK_CNTL                                   (0xff63c000 + (0x06f << 2))
#define SEC_HHI_VPU_CLK_CNTL                                   (0xff63c000 + (0x06f << 2))
#define   P_HHI_VPU_CLK_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x06f << 2))
//`define HHI_OTHER_PLL_CNTL      8'h70 // OTHER PLL control, word 1
//`define HHI_OTHER_PLL_CNTL2     8'h71 // OTHER PLL control, word 2
//`define HHI_OTHER_PLL_CNTL3     8'h72 // OTHER PLL control, word 3
//`define HHI_ETH_CLK_CNTL        8'h76 // Ethernet clock control
//`define HHI_CLK_DOUBLE_CNTL     8'h77 // Ethernet clock control
#define     HHI_VAPBCLK_CNTL                                   (0xff63c000 + (0x07d << 2))
#define SEC_HHI_VAPBCLK_CNTL                                   (0xff63c000 + (0x07d << 2))
#define   P_HHI_VAPBCLK_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x07d << 2))
//`define HHI_VPU_CLKB_CNTL       8'h83
//`define HHI_VID_PLL_MOD_CNTL0       8'h84
//`define HHI_VID_PLL_MOD_LOW_TCNT    8'h85
//`define HHI_VID_PLL_MOD_HIGH_TCNT   8'h86
//`define HHI_VID_PLL_MOD_NOM_TCNT    8'h87
//`define HHI_USB_CLK_CNTL            8'h88
// Removed `define HHI_DDR_CLK_CNTL            8'h88
//`define HHI_32K_CLK_CNTL            8'h89
#define     HHI_GEN_CLK_CNTL                                   (0xff63c000 + (0x08a << 2))
#define SEC_HHI_GEN_CLK_CNTL                                   (0xff63c000 + (0x08a << 2))
#define   P_HHI_GEN_CLK_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x08a << 2))
//`define HHI_GEN_CLK_CNTL2           8'h8b
//`define HHI_ALOCKER_CLK_CNTL        8'h8d
//`define HHI_JTAG_CONFIG             8'h8e
#define     HHI_VDIN_MEAS_CLK_CNTL                             (0xff63c000 + (0x094 << 2))
#define SEC_HHI_VDIN_MEAS_CLK_CNTL                             (0xff63c000 + (0x094 << 2))
#define   P_HHI_VDIN_MEAS_CLK_CNTL                             (volatile uint32_t *)(0xff63c000 + (0x094 << 2))
//`define HHI_PCMB_CLK_CNTL           8'h95
//`define HHI_PCM_CLK_CNTL            8'h96
#define     HHI_NAND_CLK_CNTL                                  (0xff63c000 + (0x097 << 2))
#define SEC_HHI_NAND_CLK_CNTL                                  (0xff63c000 + (0x097 << 2))
#define   P_HHI_NAND_CLK_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x097 << 2))
//`define HHI_ISP_LED_CLK_CNTL        8'h98
#define     HHI_SD_EMMC_CLK_CNTL                               (0xff63c000 + (0x099 << 2))
#define SEC_HHI_SD_EMMC_CLK_CNTL                               (0xff63c000 + (0x099 << 2))
#define   P_HHI_SD_EMMC_CLK_CNTL                               (volatile uint32_t *)(0xff63c000 + (0x099 << 2))
#define     HHI_MPLL_CNTL                                      (0xff63c000 + (0x0a0 << 2))
#define SEC_HHI_MPLL_CNTL                                      (0xff63c000 + (0x0a0 << 2))
#define   P_HHI_MPLL_CNTL                                      (volatile uint32_t *)(0xff63c000 + (0x0a0 << 2))
#define     HHI_MPLL_CNTL2                                     (0xff63c000 + (0x0a1 << 2))
#define SEC_HHI_MPLL_CNTL2                                     (0xff63c000 + (0x0a1 << 2))
#define   P_HHI_MPLL_CNTL2                                     (volatile uint32_t *)(0xff63c000 + (0x0a1 << 2))
#define     HHI_MPLL_CNTL3                                     (0xff63c000 + (0x0a2 << 2))
#define SEC_HHI_MPLL_CNTL3                                     (0xff63c000 + (0x0a2 << 2))
#define   P_HHI_MPLL_CNTL3                                     (volatile uint32_t *)(0xff63c000 + (0x0a2 << 2))
#define     HHI_MPLL_CNTL4                                     (0xff63c000 + (0x0a3 << 2))
#define SEC_HHI_MPLL_CNTL4                                     (0xff63c000 + (0x0a3 << 2))
#define   P_HHI_MPLL_CNTL4                                     (volatile uint32_t *)(0xff63c000 + (0x0a3 << 2))
#define     HHI_MPLL_CNTL5                                     (0xff63c000 + (0x0a4 << 2))
#define SEC_HHI_MPLL_CNTL5                                     (0xff63c000 + (0x0a4 << 2))
#define   P_HHI_MPLL_CNTL5                                     (volatile uint32_t *)(0xff63c000 + (0x0a4 << 2))
#define     HHI_MPLL_CNTL6                                     (0xff63c000 + (0x0a5 << 2))
#define SEC_HHI_MPLL_CNTL6                                     (0xff63c000 + (0x0a5 << 2))
#define   P_HHI_MPLL_CNTL6                                     (volatile uint32_t *)(0xff63c000 + (0x0a5 << 2))
#define     HHI_MPLL_CNTL7                                     (0xff63c000 + (0x0a6 << 2))
#define SEC_HHI_MPLL_CNTL7                                     (0xff63c000 + (0x0a6 << 2))
#define   P_HHI_MPLL_CNTL7                                     (volatile uint32_t *)(0xff63c000 + (0x0a6 << 2))
#define     HHI_MPLL_CNTL8                                     (0xff63c000 + (0x0a7 << 2))
#define SEC_HHI_MPLL_CNTL8                                     (0xff63c000 + (0x0a7 << 2))
#define   P_HHI_MPLL_CNTL8                                     (volatile uint32_t *)(0xff63c000 + (0x0a7 << 2))
#define     HHI_MPLL_CNTL9                                     (0xff63c000 + (0x0a8 << 2))
#define SEC_HHI_MPLL_CNTL9                                     (0xff63c000 + (0x0a8 << 2))
#define   P_HHI_MPLL_CNTL9                                     (volatile uint32_t *)(0xff63c000 + (0x0a8 << 2))
#define     HHI_MPLL_CNTL10                                    (0xff63c000 + (0x0a9 << 2))
#define SEC_HHI_MPLL_CNTL10                                    (0xff63c000 + (0x0a9 << 2))
#define   P_HHI_MPLL_CNTL10                                    (volatile uint32_t *)(0xff63c000 + (0x0a9 << 2))
//`define HHI_L2_DDR_CLK_CNTL         8'hb6
#define     HHI_MPLL3_CNTL0                                    (0xff63c000 + (0x0b8 << 2))
#define SEC_HHI_MPLL3_CNTL0                                    (0xff63c000 + (0x0b8 << 2))
#define   P_HHI_MPLL3_CNTL0                                    (volatile uint32_t *)(0xff63c000 + (0x0b8 << 2))
#define     HHI_MPLL3_CNTL1                                    (0xff63c000 + (0x0b9 << 2))
#define SEC_HHI_MPLL3_CNTL1                                    (0xff63c000 + (0x0b9 << 2))
#define   P_HHI_MPLL3_CNTL1                                    (volatile uint32_t *)(0xff63c000 + (0x0b9 << 2))
#define     HHI_PLL_TOP_MISC                                   (0xff63c000 + (0x0ba << 2))
#define SEC_HHI_PLL_TOP_MISC                                   (0xff63c000 + (0x0ba << 2))
#define   P_HHI_PLL_TOP_MISC                                   (volatile uint32_t *)(0xff63c000 + (0x0ba << 2))
#define     HHI_SYS_PLL_CNTL1                                  (0xff63c000 + (0x0bf << 2))
#define SEC_HHI_SYS_PLL_CNTL1                                  (0xff63c000 + (0x0bf << 2))
#define   P_HHI_SYS_PLL_CNTL1                                  (volatile uint32_t *)(0xff63c000 + (0x0bf << 2))
#define     HHI_SYS_PLL_CNTL                                   (0xff63c000 + (0x0c0 << 2))
#define SEC_HHI_SYS_PLL_CNTL                                   (0xff63c000 + (0x0c0 << 2))
#define   P_HHI_SYS_PLL_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x0c0 << 2))
#define     HHI_SYS_PLL_CNTL2                                  (0xff63c000 + (0x0c1 << 2))
#define SEC_HHI_SYS_PLL_CNTL2                                  (0xff63c000 + (0x0c1 << 2))
#define   P_HHI_SYS_PLL_CNTL2                                  (volatile uint32_t *)(0xff63c000 + (0x0c1 << 2))
#define     HHI_SYS_PLL_CNTL3                                  (0xff63c000 + (0x0c2 << 2))
#define SEC_HHI_SYS_PLL_CNTL3                                  (0xff63c000 + (0x0c2 << 2))
#define   P_HHI_SYS_PLL_CNTL3                                  (volatile uint32_t *)(0xff63c000 + (0x0c2 << 2))
#define     HHI_SYS_PLL_CNTL4                                  (0xff63c000 + (0x0c3 << 2))
#define SEC_HHI_SYS_PLL_CNTL4                                  (0xff63c000 + (0x0c3 << 2))
#define   P_HHI_SYS_PLL_CNTL4                                  (volatile uint32_t *)(0xff63c000 + (0x0c3 << 2))
#define     HHI_SYS_PLL_CNTL5                                  (0xff63c000 + (0x0c4 << 2))
#define SEC_HHI_SYS_PLL_CNTL5                                  (0xff63c000 + (0x0c4 << 2))
#define   P_HHI_SYS_PLL_CNTL5                                  (volatile uint32_t *)(0xff63c000 + (0x0c4 << 2))
#define     HHI_SYS_PLL_STS                                    (0xff63c000 + (0x0c5 << 2))
#define SEC_HHI_SYS_PLL_STS                                    (0xff63c000 + (0x0c5 << 2))
#define   P_HHI_SYS_PLL_STS                                    (volatile uint32_t *)(0xff63c000 + (0x0c5 << 2))
#define     HHI_DPLL_TOP_I                                     (0xff63c000 + (0x0c6 << 2))
#define SEC_HHI_DPLL_TOP_I                                     (0xff63c000 + (0x0c6 << 2))
#define   P_HHI_DPLL_TOP_I                                     (volatile uint32_t *)(0xff63c000 + (0x0c6 << 2))
#define     HHI_DPLL_TOP2_I                                    (0xff63c000 + (0x0c7 << 2))
#define SEC_HHI_DPLL_TOP2_I                                    (0xff63c000 + (0x0c7 << 2))
#define   P_HHI_DPLL_TOP2_I                                    (volatile uint32_t *)(0xff63c000 + (0x0c7 << 2))
//`define HHI_DSI_LVDS_EDP_CNTL0      8'hd1
//`define HHI_DSI_LVDS_EDP_CNTL1      8'hd2
//
//
//`define HHI_CSI_PHY_CNTL0           8'hd3
//`define HHI_CSI_PHY_CNTL1           8'hd4
//`define HHI_CSI_PHY_CNTL2           8'hd5
//`define HHI_CSI_PHY_CNTL3           8'hd6
//`define HHI_CSI_PHY_CNTL4           8'hd7
//`define HHI_DIF_CSI_PHY_CNTL0       8'hd8
//`define HHI_DIF_CSI_PHY_CNTL1       8'hd9
//`define HHI_DIF_CSI_PHY_CNTL2       8'hda
//`define HHI_DIF_CSI_PHY_CNTL3       8'hdb
//`define HHI_DIF_CSI_PHY_CNTL4       8'hdc
//`define HHI_DIF_CSI_PHY_CNTL5       8'hdd
//`define HHI_VID2_PLL_CNTL           8'he0
//`define HHI_VID2_PLL_CNTL2          8'he1
//`define HHI_VID2_PLL_CNTL3          8'he2
//`define HHI_VID2_PLL_CNTL4          8'he3
//`define HHI_VID2_PLL_CNTL5          8'he4
//`define HHI_VID2_PLL_CNTL_I         8'he5
//`define HHI_ADEC_SYS_CLK_CNTL       8'hf1
//`define HHI_VID_LOCK_CLK_CNTL       8'hf2
//`define HHI_ATV_DMD_SYS_CLK_CNTL    8'hf3
//`define HHI_EE_MISC_CNTL            8'hf4
//========================================================================
//  HIU - Mailbox
//========================================================================
// APB4_DECODER_NON_SECURE_BASE     32'hFF63C400
// APB4_DECODER_SECURE_BASE         32'hFF63C400
#define     HIU_MAILBOX_SET_0                                  (0xff63c400 + (0x001 << 2))
#define SEC_HIU_MAILBOX_SET_0                                  (0xff63c400 + (0x001 << 2))
#define   P_HIU_MAILBOX_SET_0                                  (volatile uint32_t *)(0xff63c400 + (0x001 << 2))
#define     HIU_MAILBOX_STAT_0                                 (0xff63c400 + (0x002 << 2))
#define SEC_HIU_MAILBOX_STAT_0                                 (0xff63c400 + (0x002 << 2))
#define   P_HIU_MAILBOX_STAT_0                                 (volatile uint32_t *)(0xff63c400 + (0x002 << 2))
#define     HIU_MAILBOX_CLR_0                                  (0xff63c400 + (0x003 << 2))
#define SEC_HIU_MAILBOX_CLR_0                                  (0xff63c400 + (0x003 << 2))
#define   P_HIU_MAILBOX_CLR_0                                  (volatile uint32_t *)(0xff63c400 + (0x003 << 2))
#define     HIU_MAILBOX_SET_1                                  (0xff63c400 + (0x004 << 2))
#define SEC_HIU_MAILBOX_SET_1                                  (0xff63c400 + (0x004 << 2))
#define   P_HIU_MAILBOX_SET_1                                  (volatile uint32_t *)(0xff63c400 + (0x004 << 2))
#define     HIU_MAILBOX_STAT_1                                 (0xff63c400 + (0x005 << 2))
#define SEC_HIU_MAILBOX_STAT_1                                 (0xff63c400 + (0x005 << 2))
#define   P_HIU_MAILBOX_STAT_1                                 (volatile uint32_t *)(0xff63c400 + (0x005 << 2))
#define     HIU_MAILBOX_CLR_1                                  (0xff63c400 + (0x006 << 2))
#define SEC_HIU_MAILBOX_CLR_1                                  (0xff63c400 + (0x006 << 2))
#define   P_HIU_MAILBOX_CLR_1                                  (volatile uint32_t *)(0xff63c400 + (0x006 << 2))
#define     HIU_MAILBOX_SET_2                                  (0xff63c400 + (0x007 << 2))
#define SEC_HIU_MAILBOX_SET_2                                  (0xff63c400 + (0x007 << 2))
#define   P_HIU_MAILBOX_SET_2                                  (volatile uint32_t *)(0xff63c400 + (0x007 << 2))
#define     HIU_MAILBOX_STAT_2                                 (0xff63c400 + (0x008 << 2))
#define SEC_HIU_MAILBOX_STAT_2                                 (0xff63c400 + (0x008 << 2))
#define   P_HIU_MAILBOX_STAT_2                                 (volatile uint32_t *)(0xff63c400 + (0x008 << 2))
#define     HIU_MAILBOX_CLR_2                                  (0xff63c400 + (0x009 << 2))
#define SEC_HIU_MAILBOX_CLR_2                                  (0xff63c400 + (0x009 << 2))
#define   P_HIU_MAILBOX_CLR_2                                  (volatile uint32_t *)(0xff63c400 + (0x009 << 2))
#define     HIU_MAILBOX_SET_3                                  (0xff63c400 + (0x00a << 2))
#define SEC_HIU_MAILBOX_SET_3                                  (0xff63c400 + (0x00a << 2))
#define   P_HIU_MAILBOX_SET_3                                  (volatile uint32_t *)(0xff63c400 + (0x00a << 2))
#define     HIU_MAILBOX_STAT_3                                 (0xff63c400 + (0x00b << 2))
#define SEC_HIU_MAILBOX_STAT_3                                 (0xff63c400 + (0x00b << 2))
#define   P_HIU_MAILBOX_STAT_3                                 (volatile uint32_t *)(0xff63c400 + (0x00b << 2))
#define     HIU_MAILBOX_CLR_3                                  (0xff63c400 + (0x00c << 2))
#define SEC_HIU_MAILBOX_CLR_3                                  (0xff63c400 + (0x00c << 2))
#define   P_HIU_MAILBOX_CLR_3                                  (volatile uint32_t *)(0xff63c400 + (0x00c << 2))
#define     HIU_MAILBOX_SET_4                                  (0xff63c400 + (0x00d << 2))
#define SEC_HIU_MAILBOX_SET_4                                  (0xff63c400 + (0x00d << 2))
#define   P_HIU_MAILBOX_SET_4                                  (volatile uint32_t *)(0xff63c400 + (0x00d << 2))
#define     HIU_MAILBOX_STAT_4                                 (0xff63c400 + (0x00e << 2))
#define SEC_HIU_MAILBOX_STAT_4                                 (0xff63c400 + (0x00e << 2))
#define   P_HIU_MAILBOX_STAT_4                                 (volatile uint32_t *)(0xff63c400 + (0x00e << 2))
#define     HIU_MAILBOX_CLR_4                                  (0xff63c400 + (0x00f << 2))
#define SEC_HIU_MAILBOX_CLR_4                                  (0xff63c400 + (0x00f << 2))
#define   P_HIU_MAILBOX_CLR_4                                  (volatile uint32_t *)(0xff63c400 + (0x00f << 2))
#define     HIU_MAILBOX_SET_5                                  (0xff63c400 + (0x010 << 2))
#define SEC_HIU_MAILBOX_SET_5                                  (0xff63c400 + (0x010 << 2))
#define   P_HIU_MAILBOX_SET_5                                  (volatile uint32_t *)(0xff63c400 + (0x010 << 2))
#define     HIU_MAILBOX_STAT_5                                 (0xff63c400 + (0x011 << 2))
#define SEC_HIU_MAILBOX_STAT_5                                 (0xff63c400 + (0x011 << 2))
#define   P_HIU_MAILBOX_STAT_5                                 (volatile uint32_t *)(0xff63c400 + (0x011 << 2))
#define     HIU_MAILBOX_CLR_5                                  (0xff63c400 + (0x012 << 2))
#define SEC_HIU_MAILBOX_CLR_5                                  (0xff63c400 + (0x012 << 2))
#define   P_HIU_MAILBOX_CLR_5                                  (volatile uint32_t *)(0xff63c400 + (0x012 << 2))
//========================================================================
//  EFUSE
//========================================================================
//  APB4_DECODER_NON_SECURE_BASE     32'hFF630000
//  APB4_DECODER_SECURE_BASE         32'hFF630000
#define     EFUSE_CLR                                          (0xff630000 + (0x000 << 2))
#define SEC_EFUSE_CLR                                          (0xff630000 + (0x000 << 2))
#define   P_EFUSE_CLR                                          (volatile uint32_t *)(0xff630000 + (0x000 << 2))
#define     EFUSE_START                                        (0xff630000 + (0x001 << 2))
#define SEC_EFUSE_START                                        (0xff630000 + (0x001 << 2))
#define   P_EFUSE_START                                        (volatile uint32_t *)(0xff630000 + (0x001 << 2))
#define     EFUSE_WDATA0                                       (0xff630000 + (0x004 << 2))
#define SEC_EFUSE_WDATA0                                       (0xff630000 + (0x004 << 2))
#define   P_EFUSE_WDATA0                                       (volatile uint32_t *)(0xff630000 + (0x004 << 2))
#define     EFUSE_WDATA1                                       (0xff630000 + (0x005 << 2))
#define SEC_EFUSE_WDATA1                                       (0xff630000 + (0x005 << 2))
#define   P_EFUSE_WDATA1                                       (volatile uint32_t *)(0xff630000 + (0x005 << 2))
#define     EFUSE_WDATA2                                       (0xff630000 + (0x006 << 2))
#define SEC_EFUSE_WDATA2                                       (0xff630000 + (0x006 << 2))
#define   P_EFUSE_WDATA2                                       (volatile uint32_t *)(0xff630000 + (0x006 << 2))
#define     EFUSE_WDATA3                                       (0xff630000 + (0x007 << 2))
#define SEC_EFUSE_WDATA3                                       (0xff630000 + (0x007 << 2))
#define   P_EFUSE_WDATA3                                       (volatile uint32_t *)(0xff630000 + (0x007 << 2))
#define     EFUSE_RDATA0                                       (0xff630000 + (0x008 << 2))
#define SEC_EFUSE_RDATA0                                       (0xff630000 + (0x008 << 2))
#define   P_EFUSE_RDATA0                                       (volatile uint32_t *)(0xff630000 + (0x008 << 2))
#define     EFUSE_RDATA1                                       (0xff630000 + (0x009 << 2))
#define SEC_EFUSE_RDATA1                                       (0xff630000 + (0x009 << 2))
#define   P_EFUSE_RDATA1                                       (volatile uint32_t *)(0xff630000 + (0x009 << 2))
#define     EFUSE_RDATA2                                       (0xff630000 + (0x00a << 2))
#define SEC_EFUSE_RDATA2                                       (0xff630000 + (0x00a << 2))
#define   P_EFUSE_RDATA2                                       (volatile uint32_t *)(0xff630000 + (0x00a << 2))
#define     EFUSE_RDATA3                                       (0xff630000 + (0x00b << 2))
#define SEC_EFUSE_RDATA3                                       (0xff630000 + (0x00b << 2))
#define   P_EFUSE_RDATA3                                       (volatile uint32_t *)(0xff630000 + (0x00b << 2))
#define     KL_START0                                          (0xff630000 + (0x020 << 2))
#define SEC_KL_START0                                          (0xff630000 + (0x020 << 2))
#define   P_KL_START0                                          (volatile uint32_t *)(0xff630000 + (0x020 << 2))
#define     KL_START1                                          (0xff630000 + (0x021 << 2))
#define SEC_KL_START1                                          (0xff630000 + (0x021 << 2))
#define   P_KL_START1                                          (volatile uint32_t *)(0xff630000 + (0x021 << 2))
#define     KL_RESP0_0                                         (0xff630000 + (0x024 << 2))
#define SEC_KL_RESP0_0                                         (0xff630000 + (0x024 << 2))
#define   P_KL_RESP0_0                                         (volatile uint32_t *)(0xff630000 + (0x024 << 2))
#define     KL_RESP0_1                                         (0xff630000 + (0x025 << 2))
#define SEC_KL_RESP0_1                                         (0xff630000 + (0x025 << 2))
#define   P_KL_RESP0_1                                         (volatile uint32_t *)(0xff630000 + (0x025 << 2))
#define     KL_RESP0_2                                         (0xff630000 + (0x026 << 2))
#define SEC_KL_RESP0_2                                         (0xff630000 + (0x026 << 2))
#define   P_KL_RESP0_2                                         (volatile uint32_t *)(0xff630000 + (0x026 << 2))
#define     KL_RESP0_3                                         (0xff630000 + (0x027 << 2))
#define SEC_KL_RESP0_3                                         (0xff630000 + (0x027 << 2))
#define   P_KL_RESP0_3                                         (volatile uint32_t *)(0xff630000 + (0x027 << 2))
#define     KL_RESP1_0                                         (0xff630000 + (0x028 << 2))
#define SEC_KL_RESP1_0                                         (0xff630000 + (0x028 << 2))
#define   P_KL_RESP1_0                                         (volatile uint32_t *)(0xff630000 + (0x028 << 2))
#define     KL_RESP1_1                                         (0xff630000 + (0x029 << 2))
#define SEC_KL_RESP1_1                                         (0xff630000 + (0x029 << 2))
#define   P_KL_RESP1_1                                         (volatile uint32_t *)(0xff630000 + (0x029 << 2))
#define     KL_RESP1_2                                         (0xff630000 + (0x02a << 2))
#define SEC_KL_RESP1_2                                         (0xff630000 + (0x02a << 2))
#define   P_KL_RESP1_2                                         (volatile uint32_t *)(0xff630000 + (0x02a << 2))
#define     KL_RESP1_3                                         (0xff630000 + (0x02b << 2))
#define SEC_KL_RESP1_3                                         (0xff630000 + (0x02b << 2))
#define   P_KL_RESP1_3                                         (volatile uint32_t *)(0xff630000 + (0x02b << 2))
#define     KL_RAM                                             (0xff630000 + (0x040 << 2))
#define SEC_KL_RAM                                             (0xff630000 + (0x040 << 2))
#define   P_KL_RAM                                             (volatile uint32_t *)(0xff630000 + (0x040 << 2))
//========================================================================
//  PDM
//========================================================================
//
// Reading file:  ../audio/rtl/pdm_reg.vh
//
//  APB4_DECODER_NON_SECURE_BASE     32'hFF632000
//  APB4_DECODER_SECURE_BASE         32'hFF632000
#define     PDM_CTRL                                           (0xff632000 + (0x000 << 2))
#define SEC_PDM_CTRL                                           (0xff632000 + (0x000 << 2))
#define   P_PDM_CTRL                                           (volatile uint32_t *)(0xff632000 + (0x000 << 2))
#define     PDM_HCIC_CTRL1                                     (0xff632000 + (0x001 << 2))
#define SEC_PDM_HCIC_CTRL1                                     (0xff632000 + (0x001 << 2))
#define   P_PDM_HCIC_CTRL1                                     (volatile uint32_t *)(0xff632000 + (0x001 << 2))
#define     PDM_HCIC_CTRL2                                     (0xff632000 + (0x002 << 2))
#define SEC_PDM_HCIC_CTRL2                                     (0xff632000 + (0x002 << 2))
#define   P_PDM_HCIC_CTRL2                                     (volatile uint32_t *)(0xff632000 + (0x002 << 2))
#define     PDM_F1_CTRL                                        (0xff632000 + (0x003 << 2))
#define SEC_PDM_F1_CTRL                                        (0xff632000 + (0x003 << 2))
#define   P_PDM_F1_CTRL                                        (volatile uint32_t *)(0xff632000 + (0x003 << 2))
#define     PDM_F2_CTRL                                        (0xff632000 + (0x004 << 2))
#define SEC_PDM_F2_CTRL                                        (0xff632000 + (0x004 << 2))
#define   P_PDM_F2_CTRL                                        (volatile uint32_t *)(0xff632000 + (0x004 << 2))
#define     PDM_F3_CTRL                                        (0xff632000 + (0x005 << 2))
#define SEC_PDM_F3_CTRL                                        (0xff632000 + (0x005 << 2))
#define   P_PDM_F3_CTRL                                        (volatile uint32_t *)(0xff632000 + (0x005 << 2))
#define     PDM_HPF_CTRL                                       (0xff632000 + (0x006 << 2))
#define SEC_PDM_HPF_CTRL                                       (0xff632000 + (0x006 << 2))
#define   P_PDM_HPF_CTRL                                       (volatile uint32_t *)(0xff632000 + (0x006 << 2))
#define     PDM_CHAN_CTRL                                      (0xff632000 + (0x007 << 2))
#define SEC_PDM_CHAN_CTRL                                      (0xff632000 + (0x007 << 2))
#define   P_PDM_CHAN_CTRL                                      (volatile uint32_t *)(0xff632000 + (0x007 << 2))
#define     PDM_CHAN_CTRL1                                     (0xff632000 + (0x008 << 2))
#define SEC_PDM_CHAN_CTRL1                                     (0xff632000 + (0x008 << 2))
#define   P_PDM_CHAN_CTRL1                                     (volatile uint32_t *)(0xff632000 + (0x008 << 2))
#define     PDM_COEFF_ADDR                                     (0xff632000 + (0x009 << 2))
#define SEC_PDM_COEFF_ADDR                                     (0xff632000 + (0x009 << 2))
#define   P_PDM_COEFF_ADDR                                     (volatile uint32_t *)(0xff632000 + (0x009 << 2))
#define     PDM_COEFF_DATA                                     (0xff632000 + (0x00a << 2))
#define SEC_PDM_COEFF_DATA                                     (0xff632000 + (0x00a << 2))
#define   P_PDM_COEFF_DATA                                     (volatile uint32_t *)(0xff632000 + (0x00a << 2))
#define     PDM_CLKG_CTRL                                      (0xff632000 + (0x00b << 2))
#define SEC_PDM_CLKG_CTRL                                      (0xff632000 + (0x00b << 2))
#define   P_PDM_CLKG_CTRL                                      (volatile uint32_t *)(0xff632000 + (0x00b << 2))
#define     PDM_STS                                            (0xff632000 + (0x00c << 2))
#define SEC_PDM_STS                                            (0xff632000 + (0x00c << 2))
#define   P_PDM_STS                                            (volatile uint32_t *)(0xff632000 + (0x00c << 2))
//bit 1  HPF filter output overflow.  means the PCLK is too slow.
//bit 0  HCIC filter output overflow. means the CTS_PDM_CLK is too slow. can't finished the filter function.
//
// Closing file:  ../audio/rtl/pdm_reg.vh
//
// synopsys translate_off
// synopsys translate_on
//
// Closing file:  ./secure_apb4_ee.h
//
//
// Reading file:  ./ao_rti_reg.h
//
//#define AO_RTI_REG_BASE 0x00
// APB4_DECODER_NON_SECURE_BASE     32'hFF800000
// APB4_DECODER_SECURE_BASE         32'hFF800000
// Registers not affected by the Watchdog timer
#define     AO_RTI_STATUS_REG0                                 (0xff800000 + (0x000 << 2))
#define SEC_AO_RTI_STATUS_REG0                                 (0xff800000 + (0x000 << 2))
#define   P_AO_RTI_STATUS_REG0                                 (volatile uint32_t *)(0xff800000 + (0x000 << 2))
#define     AO_RTI_STATUS_REG1                                 (0xff800000 + (0x001 << 2))
#define SEC_AO_RTI_STATUS_REG1                                 (0xff800000 + (0x001 << 2))
#define   P_AO_RTI_STATUS_REG1                                 (volatile uint32_t *)(0xff800000 + (0x001 << 2))
#define     AO_RTI_STATUS_REG2                                 (0xff800000 + (0x002 << 2))
#define SEC_AO_RTI_STATUS_REG2                                 (0xff800000 + (0x002 << 2))
#define   P_AO_RTI_STATUS_REG2                                 (volatile uint32_t *)(0xff800000 + (0x002 << 2))
#define     AO_RTI_PWR_CNTL_REG1                               (0xff800000 + (0x003 << 2))
#define SEC_AO_RTI_PWR_CNTL_REG1                               (0xff800000 + (0x003 << 2))
#define   P_AO_RTI_PWR_CNTL_REG1                               (volatile uint32_t *)(0xff800000 + (0x003 << 2))
#define     AO_RTI_PWR_CNTL_REG0                               (0xff800000 + (0x004 << 2))
#define SEC_AO_RTI_PWR_CNTL_REG0                               (0xff800000 + (0x004 << 2))
#define   P_AO_RTI_PWR_CNTL_REG0                               (volatile uint32_t *)(0xff800000 + (0x004 << 2))
#define     AO_RTI_PINMUX_REG0                                 (0xff800000 + (0x005 << 2))
#define SEC_AO_RTI_PINMUX_REG0                                 (0xff800000 + (0x005 << 2))
#define   P_AO_RTI_PINMUX_REG0                                 (volatile uint32_t *)(0xff800000 + (0x005 << 2))
#define     AO_RTI_PINMUX_REG1                                 (0xff800000 + (0x006 << 2))
#define SEC_AO_RTI_PINMUX_REG1                                 (0xff800000 + (0x006 << 2))
#define   P_AO_RTI_PINMUX_REG1                                 (volatile uint32_t *)(0xff800000 + (0x006 << 2))
#define     AO_RTI_STATUS_REG3                                 (0xff800000 + (0x007 << 2))
#define SEC_AO_RTI_STATUS_REG3                                 (0xff800000 + (0x007 << 2))
#define   P_AO_RTI_STATUS_REG3                                 (volatile uint32_t *)(0xff800000 + (0x007 << 2))
//`define AO_REMAP_REG0               8'h07 //TODO: DELETE. NOT USED
//`define AO_REMAP_REG1               8'h08
#define     AO_GPIO_O_EN_N                                     (0xff800000 + (0x009 << 2))
#define SEC_AO_GPIO_O_EN_N                                     (0xff800000 + (0x009 << 2))
#define   P_AO_GPIO_O_EN_N                                     (volatile uint32_t *)(0xff800000 + (0x009 << 2))
#define     AO_GPIO_I                                          (0xff800000 + (0x00a << 2))
#define SEC_AO_GPIO_I                                          (0xff800000 + (0x00a << 2))
#define   P_AO_GPIO_I                                          (volatile uint32_t *)(0xff800000 + (0x00a << 2))
#define     AO_RTI_PULL_UP_REG                                 (0xff800000 + (0x00b << 2))
#define SEC_AO_RTI_PULL_UP_REG                                 (0xff800000 + (0x00b << 2))
#define   P_AO_RTI_PULL_UP_REG                                 (volatile uint32_t *)(0xff800000 + (0x00b << 2))
//`define AO_RTI_JTAG_CONFIG_REG      8'h0C
//`define AO_RTI_WD_MARK              8'h0D
// sando add for AO CPU
#define     AO_CPU_CNTL                                        (0xff800000 + (0x00e << 2))
#define SEC_AO_CPU_CNTL                                        (0xff800000 + (0x00e << 2))
#define   P_AO_CPU_CNTL                                        (volatile uint32_t *)(0xff800000 + (0x00e << 2))
#define     AO_CPU_CNTL2                                       (0xff800000 + (0x00f << 2))
#define SEC_AO_CPU_CNTL2                                       (0xff800000 + (0x00f << 2))
#define   P_AO_CPU_CNTL2                                       (volatile uint32_t *)(0xff800000 + (0x00f << 2))
#define     AO_RTI_GEN_CNTL_REG0                               (0xff800000 + (0x010 << 2))
#define SEC_AO_RTI_GEN_CNTL_REG0                               (0xff800000 + (0x010 << 2))
#define   P_AO_RTI_GEN_CNTL_REG0                               (volatile uint32_t *)(0xff800000 + (0x010 << 2))
#define     AO_CPU_CNTL_NS                                     (0xff800000 + (0x011 << 2))
#define SEC_AO_CPU_CNTL_NS                                     (0xff800000 + (0x011 << 2))
#define   P_AO_CPU_CNTL_NS                                     (volatile uint32_t *)(0xff800000 + (0x011 << 2))
#define     AO_TIMER_REG                                       (0xff800000 + (0x013 << 2))
#define SEC_AO_TIMER_REG                                       (0xff800000 + (0x013 << 2))
#define   P_AO_TIMER_REG                                       (volatile uint32_t *)(0xff800000 + (0x013 << 2))
#define     AO_TIMERA_REG                                      (0xff800000 + (0x014 << 2))
#define SEC_AO_TIMERA_REG                                      (0xff800000 + (0x014 << 2))
#define   P_AO_TIMERA_REG                                      (volatile uint32_t *)(0xff800000 + (0x014 << 2))
#define     AO_TIMERE_REG                                      (0xff800000 + (0x015 << 2))
#define SEC_AO_TIMERE_REG                                      (0xff800000 + (0x015 << 2))
#define   P_AO_TIMERE_REG                                      (volatile uint32_t *)(0xff800000 + (0x015 << 2))
#define     AO_OSCIN_CNTL                                      (0xff800000 + (0x016 << 2))
#define SEC_AO_OSCIN_CNTL                                      (0xff800000 + (0x016 << 2))
#define   P_AO_OSCIN_CNTL                                      (volatile uint32_t *)(0xff800000 + (0x016 << 2))
#define     AO_AHB2DDR_CNTL                                    (0xff800000 + (0x018 << 2))
#define SEC_AO_AHB2DDR_CNTL                                    (0xff800000 + (0x018 << 2))
#define   P_AO_AHB2DDR_CNTL                                    (volatile uint32_t *)(0xff800000 + (0x018 << 2))
#define     AO_TIMEBASE_CNTL                                   (0xff800000 + (0x019 << 2))
#define SEC_AO_TIMEBASE_CNTL                                   (0xff800000 + (0x019 << 2))
#define   P_AO_TIMEBASE_CNTL                                   (volatile uint32_t *)(0xff800000 + (0x019 << 2))
//`define AO_CRT_CLK_CNTL1            8'h1a
#define     AO_GEN_CLK_CNTL                                    (0xff800000 + (0x01a << 2))
#define SEC_AO_GEN_CLK_CNTL                                    (0xff800000 + (0x01a << 2))
#define   P_AO_GEN_CLK_CNTL                                    (volatile uint32_t *)(0xff800000 + (0x01a << 2))
//`define AO_RTI_INTER_OSC_CTL0       8'h1b
//`define AO_RTI_INTER_OSC_CTL1       8'h1c
//`define AO_CEC_CLK_CNTL_REG0        8'h1d
//`define AO_CEC_CLK_CNTL_REG1        8'h1e
#define     AO_METAL_REVISION                                  (0xff800000 + (0x01f << 2))
#define SEC_AO_METAL_REVISION                                  (0xff800000 + (0x01f << 2))
#define   P_AO_METAL_REVISION                                  (volatile uint32_t *)(0xff800000 + (0x01f << 2))
//`define AO_IRQ_MASK_FIQ_SEL         8'h20
#define     AO_IRQ_GPIO_REG                                    (0xff800000 + (0x021 << 2))
#define SEC_AO_IRQ_GPIO_REG                                    (0xff800000 + (0x021 << 2))
#define   P_AO_IRQ_GPIO_REG                                    (volatile uint32_t *)(0xff800000 + (0x021 << 2))
//`define AO_IRQ_STAT                 8'h22
//`define AO_IRQ_STAT_CLR             8'h23
#define     AO_IR_BLASTER_ADDR3                                (0xff800000 + (0x023 << 2))
#define SEC_AO_IR_BLASTER_ADDR3                                (0xff800000 + (0x023 << 2))
#define   P_AO_IR_BLASTER_ADDR3                                (volatile uint32_t *)(0xff800000 + (0x023 << 2))
#define     AO_SAR_CLK                                         (0xff800000 + (0x024 << 2))
#define SEC_AO_SAR_CLK                                         (0xff800000 + (0x024 << 2))
#define   P_AO_SAR_CLK                                         (volatile uint32_t *)(0xff800000 + (0x024 << 2))
#define     AO_RTC_ALT_CLK_CNTL0                               (0xff800000 + (0x025 << 2))
#define SEC_AO_RTC_ALT_CLK_CNTL0                               (0xff800000 + (0x025 << 2))
#define   P_AO_RTC_ALT_CLK_CNTL0                               (volatile uint32_t *)(0xff800000 + (0x025 << 2))
#define     AO_RTC_ALT_CLK_CNTL1                               (0xff800000 + (0x026 << 2))
#define SEC_AO_RTC_ALT_CLK_CNTL1                               (0xff800000 + (0x026 << 2))
#define   P_AO_RTC_ALT_CLK_CNTL1                               (volatile uint32_t *)(0xff800000 + (0x026 << 2))
#define     AO_TIMESTAMP_CNTL2                                 (0xff800000 + (0x027 << 2))
#define SEC_AO_TIMESTAMP_CNTL2                                 (0xff800000 + (0x027 << 2))
#define   P_AO_TIMESTAMP_CNTL2                                 (volatile uint32_t *)(0xff800000 + (0x027 << 2))
#define     AO_DEBUG_REG0                                      (0xff800000 + (0x028 << 2))
#define SEC_AO_DEBUG_REG0                                      (0xff800000 + (0x028 << 2))
#define   P_AO_DEBUG_REG0                                      (volatile uint32_t *)(0xff800000 + (0x028 << 2))
#define     AO_DEBUG_REG1                                      (0xff800000 + (0x029 << 2))
#define SEC_AO_DEBUG_REG1                                      (0xff800000 + (0x029 << 2))
#define   P_AO_DEBUG_REG1                                      (volatile uint32_t *)(0xff800000 + (0x029 << 2))
#define     AO_DEBUG_REG2                                      (0xff800000 + (0x02a << 2))
#define SEC_AO_DEBUG_REG2                                      (0xff800000 + (0x02a << 2))
#define   P_AO_DEBUG_REG2                                      (volatile uint32_t *)(0xff800000 + (0x02a << 2))
#define     AO_DEBUG_REG3                                      (0xff800000 + (0x02b << 2))
#define SEC_AO_DEBUG_REG3                                      (0xff800000 + (0x02b << 2))
#define   P_AO_DEBUG_REG3                                      (volatile uint32_t *)(0xff800000 + (0x02b << 2))
#define     AO_TIMESTAMP_CNTL1                                 (0xff800000 + (0x02c << 2))
#define SEC_AO_TIMESTAMP_CNTL1                                 (0xff800000 + (0x02c << 2))
#define   P_AO_TIMESTAMP_CNTL1                                 (volatile uint32_t *)(0xff800000 + (0x02c << 2))
#define     AO_TIMESTAMP_CNTL                                  (0xff800000 + (0x02d << 2))
#define SEC_AO_TIMESTAMP_CNTL                                  (0xff800000 + (0x02d << 2))
#define   P_AO_TIMESTAMP_CNTL                                  (volatile uint32_t *)(0xff800000 + (0x02d << 2))
#define     AO_TIMESTAMP_RD0                                   (0xff800000 + (0x02e << 2))
#define SEC_AO_TIMESTAMP_RD0                                   (0xff800000 + (0x02e << 2))
#define   P_AO_TIMESTAMP_RD0                                   (volatile uint32_t *)(0xff800000 + (0x02e << 2))
#define     AO_TIMESTAMP_RD1                                   (0xff800000 + (0x02f << 2))
#define SEC_AO_TIMESTAMP_RD1                                   (0xff800000 + (0x02f << 2))
#define   P_AO_TIMESTAMP_RD1                                   (volatile uint32_t *)(0xff800000 + (0x02f << 2))
#define     AO_IR_BLASTER_ADDR0                                (0xff800000 + (0x030 << 2))
#define SEC_AO_IR_BLASTER_ADDR0                                (0xff800000 + (0x030 << 2))
#define   P_AO_IR_BLASTER_ADDR0                                (volatile uint32_t *)(0xff800000 + (0x030 << 2))
#define     AO_IR_BLASTER_ADDR1                                (0xff800000 + (0x031 << 2))
#define SEC_AO_IR_BLASTER_ADDR1                                (0xff800000 + (0x031 << 2))
#define   P_AO_IR_BLASTER_ADDR1                                (volatile uint32_t *)(0xff800000 + (0x031 << 2))
#define     AO_IR_BLASTER_ADDR2                                (0xff800000 + (0x032 << 2))
#define SEC_AO_IR_BLASTER_ADDR2                                (0xff800000 + (0x032 << 2))
#define   P_AO_IR_BLASTER_ADDR2                                (volatile uint32_t *)(0xff800000 + (0x032 << 2))
#define     AO_CPU_STAT1                                       (0xff800000 + (0x033 << 2))
#define SEC_AO_CPU_STAT1                                       (0xff800000 + (0x033 << 2))
#define   P_AO_CPU_STAT1                                       (volatile uint32_t *)(0xff800000 + (0x033 << 2))
#define     AO_CPU_STAT2                                       (0xff800000 + (0x034 << 2))
#define SEC_AO_CPU_STAT2                                       (0xff800000 + (0x034 << 2))
#define   P_AO_CPU_STAT2                                       (volatile uint32_t *)(0xff800000 + (0x034 << 2))
#define     AO_CPU_TIMESTAMP                                   (0xff800000 + (0x035 << 2))
#define SEC_AO_CPU_TIMESTAMP                                   (0xff800000 + (0x035 << 2))
#define   P_AO_CPU_TIMESTAMP                                   (volatile uint32_t *)(0xff800000 + (0x035 << 2))
#define     AO_CPU_TIMESTAMP2                                  (0xff800000 + (0x036 << 2))
#define SEC_AO_CPU_TIMESTAMP2                                  (0xff800000 + (0x036 << 2))
#define   P_AO_CPU_TIMESTAMP2                                  (volatile uint32_t *)(0xff800000 + (0x036 << 2))
#define     AO_CPU_CNTL3                                       (0xff800000 + (0x037 << 2))
#define SEC_AO_CPU_CNTL3                                       (0xff800000 + (0x037 << 2))
#define   P_AO_CPU_CNTL3                                       (volatile uint32_t *)(0xff800000 + (0x037 << 2))
// general Power control
#define     AO_RTI_PWR_SYS_CPU_CNTL0                           (0xff800000 + (0x038 << 2))
#define SEC_AO_RTI_PWR_SYS_CPU_CNTL0                           (0xff800000 + (0x038 << 2))
#define   P_AO_RTI_PWR_SYS_CPU_CNTL0                           (volatile uint32_t *)(0xff800000 + (0x038 << 2))
#define     AO_RTI_PWR_SYS_CPU_CNTL1                           (0xff800000 + (0x039 << 2))
#define SEC_AO_RTI_PWR_SYS_CPU_CNTL1                           (0xff800000 + (0x039 << 2))
#define   P_AO_RTI_PWR_SYS_CPU_CNTL1                           (volatile uint32_t *)(0xff800000 + (0x039 << 2))
#define     AO_RTI_GEN_PWR_SLEEP0                              (0xff800000 + (0x03a << 2))
#define SEC_AO_RTI_GEN_PWR_SLEEP0                              (0xff800000 + (0x03a << 2))
#define   P_AO_RTI_GEN_PWR_SLEEP0                              (volatile uint32_t *)(0xff800000 + (0x03a << 2))
#define     AO_RTI_GEN_PWR_ISO0                                (0xff800000 + (0x03b << 2))
#define SEC_AO_RTI_GEN_PWR_ISO0                                (0xff800000 + (0x03b << 2))
#define   P_AO_RTI_GEN_PWR_ISO0                                (volatile uint32_t *)(0xff800000 + (0x03b << 2))
#define     AO_RTI_GEN_PWR_ACK0                                (0xff800000 + (0x03c << 2))
#define SEC_AO_RTI_GEN_PWR_ACK0                                (0xff800000 + (0x03c << 2))
#define   P_AO_RTI_GEN_PWR_ACK0                                (volatile uint32_t *)(0xff800000 + (0x03c << 2))
#define     AO_RTI_PWR_SYS_CPU_MEM_PD0                         (0xff800000 + (0x03d << 2))
#define SEC_AO_RTI_PWR_SYS_CPU_MEM_PD0                         (0xff800000 + (0x03d << 2))
#define   P_AO_RTI_PWR_SYS_CPU_MEM_PD0                         (volatile uint32_t *)(0xff800000 + (0x03d << 2))
#define     AO_RTI_PWR_SYS_CPU_MEM_PD1                         (0xff800000 + (0x03e << 2))
#define SEC_AO_RTI_PWR_SYS_CPU_MEM_PD1                         (0xff800000 + (0x03e << 2))
#define   P_AO_RTI_PWR_SYS_CPU_MEM_PD1                         (volatile uint32_t *)(0xff800000 + (0x03e << 2))
#define     AO_CPU_CNTL4                                       (0xff800000 + (0x03f << 2))
#define SEC_AO_CPU_CNTL4                                       (0xff800000 + (0x03f << 2))
#define   P_AO_CPU_CNTL4                                       (volatile uint32_t *)(0xff800000 + (0x03f << 2))
//`define AO_CEC_GEN_CNTL             8'h40
//`define AO_CEC_RW_REG               8'h41
//`define AO_CEC_INTR_MASKN           8'h42
//`define AO_CEC_INTR_CLR             8'h43
//`define AO_CEC_INTR_STAT            8'h44
#define     AO_CPU_CNTL5                                       (0xff800000 + (0x045 << 2))
#define SEC_AO_CPU_CNTL5                                       (0xff800000 + (0x045 << 2))
#define   P_AO_CPU_CNTL5                                       (volatile uint32_t *)(0xff800000 + (0x045 << 2))
#define     AO_WATCHDOG_CNTL                                   (0xff800000 + (0x048 << 2))
#define SEC_AO_WATCHDOG_CNTL                                   (0xff800000 + (0x048 << 2))
#define   P_AO_WATCHDOG_CNTL                                   (volatile uint32_t *)(0xff800000 + (0x048 << 2))
#define     AO_WATCHDOG_CNTL1                                  (0xff800000 + (0x049 << 2))
#define SEC_AO_WATCHDOG_CNTL1                                  (0xff800000 + (0x049 << 2))
#define   P_AO_WATCHDOG_CNTL1                                  (volatile uint32_t *)(0xff800000 + (0x049 << 2))
#define     AO_WATCHDOG_TCNT                                   (0xff800000 + (0x04a << 2))
#define SEC_AO_WATCHDOG_TCNT                                   (0xff800000 + (0x04a << 2))
#define   P_AO_WATCHDOG_TCNT                                   (volatile uint32_t *)(0xff800000 + (0x04a << 2))
#define     AO_WATCHDOG_RESET                                  (0xff800000 + (0x04b << 2))
#define SEC_AO_WATCHDOG_RESET                                  (0xff800000 + (0x04b << 2))
#define   P_AO_WATCHDOG_RESET                                  (volatile uint32_t *)(0xff800000 + (0x04b << 2))
#define     AO_RTI_STICKY_REG0                                 (0xff800000 + (0x04c << 2))
#define SEC_AO_RTI_STICKY_REG0                                 (0xff800000 + (0x04c << 2))
#define   P_AO_RTI_STICKY_REG0                                 (volatile uint32_t *)(0xff800000 + (0x04c << 2))
#define     AO_RTI_STICKY_REG1                                 (0xff800000 + (0x04d << 2))
#define SEC_AO_RTI_STICKY_REG1                                 (0xff800000 + (0x04d << 2))
#define   P_AO_RTI_STICKY_REG1                                 (volatile uint32_t *)(0xff800000 + (0x04d << 2))
#define     AO_RTI_STICKY_REG2                                 (0xff800000 + (0x04e << 2))
#define SEC_AO_RTI_STICKY_REG2                                 (0xff800000 + (0x04e << 2))
#define   P_AO_RTI_STICKY_REG2                                 (volatile uint32_t *)(0xff800000 + (0x04e << 2))
#define     AO_RTI_STICKY_REG3                                 (0xff800000 + (0x04f << 2))
#define SEC_AO_RTI_STICKY_REG3                                 (0xff800000 + (0x04f << 2))
#define   P_AO_RTI_STICKY_REG3                                 (volatile uint32_t *)(0xff800000 + (0x04f << 2))
//
// Secure APB3 Slot 2 registers
//
#define     AO_SEC_REG0                                        (0xff800000 + (0x050 << 2))
#define SEC_AO_SEC_REG0                                        (0xff800000 + (0x050 << 2))
#define   P_AO_SEC_REG0                                        (volatile uint32_t *)(0xff800000 + (0x050 << 2))
#define     AO_SEC_REG1                                        (0xff800000 + (0x051 << 2))
#define SEC_AO_SEC_REG1                                        (0xff800000 + (0x051 << 2))
#define   P_AO_SEC_REG1                                        (volatile uint32_t *)(0xff800000 + (0x051 << 2))
#define     AO_SEC_REG2                                        (0xff800000 + (0x052 << 2))
#define SEC_AO_SEC_REG2                                        (0xff800000 + (0x052 << 2))
#define   P_AO_SEC_REG2                                        (volatile uint32_t *)(0xff800000 + (0x052 << 2))
#define     AO_SEC_TMODE_PWD0                                  (0xff800000 + (0x058 << 2))
#define SEC_AO_SEC_TMODE_PWD0                                  (0xff800000 + (0x058 << 2))
#define   P_AO_SEC_TMODE_PWD0                                  (volatile uint32_t *)(0xff800000 + (0x058 << 2))
#define     AO_SEC_TMODE_PWD1                                  (0xff800000 + (0x059 << 2))
#define SEC_AO_SEC_TMODE_PWD1                                  (0xff800000 + (0x059 << 2))
#define   P_AO_SEC_TMODE_PWD1                                  (volatile uint32_t *)(0xff800000 + (0x059 << 2))
#define     AO_SEC_TMODE_PWD2                                  (0xff800000 + (0x05a << 2))
#define SEC_AO_SEC_TMODE_PWD2                                  (0xff800000 + (0x05a << 2))
#define   P_AO_SEC_TMODE_PWD2                                  (volatile uint32_t *)(0xff800000 + (0x05a << 2))
#define     AO_SEC_TMODE_PWD3                                  (0xff800000 + (0x05b << 2))
#define SEC_AO_SEC_TMODE_PWD3                                  (0xff800000 + (0x05b << 2))
#define   P_AO_SEC_TMODE_PWD3                                  (volatile uint32_t *)(0xff800000 + (0x05b << 2))
#define     AO_SEC_SCRATCH                                     (0xff800000 + (0x05f << 2))
#define SEC_AO_SEC_SCRATCH                                     (0xff800000 + (0x05f << 2))
#define   P_AO_SEC_SCRATCH                                     (volatile uint32_t *)(0xff800000 + (0x05f << 2))
#define     AO_SEC_JTAG_PWD0                                   (0xff800000 + (0x060 << 2))
#define SEC_AO_SEC_JTAG_PWD0                                   (0xff800000 + (0x060 << 2))
#define   P_AO_SEC_JTAG_PWD0                                   (volatile uint32_t *)(0xff800000 + (0x060 << 2))
#define     AO_SEC_JTAG_PWD1                                   (0xff800000 + (0x061 << 2))
#define SEC_AO_SEC_JTAG_PWD1                                   (0xff800000 + (0x061 << 2))
#define   P_AO_SEC_JTAG_PWD1                                   (volatile uint32_t *)(0xff800000 + (0x061 << 2))
#define     AO_SEC_JTAG_PWD2                                   (0xff800000 + (0x062 << 2))
#define SEC_AO_SEC_JTAG_PWD2                                   (0xff800000 + (0x062 << 2))
#define   P_AO_SEC_JTAG_PWD2                                   (volatile uint32_t *)(0xff800000 + (0x062 << 2))
#define     AO_SEC_JTAG_PWD3                                   (0xff800000 + (0x063 << 2))
#define SEC_AO_SEC_JTAG_PWD3                                   (0xff800000 + (0x063 << 2))
#define   P_AO_SEC_JTAG_PWD3                                   (volatile uint32_t *)(0xff800000 + (0x063 << 2))
#define     AO_SEC_JTAG_SEC_CNTL                               (0xff800000 + (0x064 << 2))
#define SEC_AO_SEC_JTAG_SEC_CNTL                               (0xff800000 + (0x064 << 2))
#define   P_AO_SEC_JTAG_SEC_CNTL                               (volatile uint32_t *)(0xff800000 + (0x064 << 2))
#define     AO_SEC_JTAG_PWD_ADDR0                              (0xff800000 + (0x065 << 2))
#define SEC_AO_SEC_JTAG_PWD_ADDR0                              (0xff800000 + (0x065 << 2))
#define   P_AO_SEC_JTAG_PWD_ADDR0                              (volatile uint32_t *)(0xff800000 + (0x065 << 2))
#define     AO_SEC_JTAG_PWD_ADDR1                              (0xff800000 + (0x066 << 2))
#define SEC_AO_SEC_JTAG_PWD_ADDR1                              (0xff800000 + (0x066 << 2))
#define   P_AO_SEC_JTAG_PWD_ADDR1                              (volatile uint32_t *)(0xff800000 + (0x066 << 2))
#define     AO_SEC_JTAG_PWD_ADDR2                              (0xff800000 + (0x067 << 2))
#define SEC_AO_SEC_JTAG_PWD_ADDR2                              (0xff800000 + (0x067 << 2))
#define   P_AO_SEC_JTAG_PWD_ADDR2                              (volatile uint32_t *)(0xff800000 + (0x067 << 2))
#define     AO_SEC_JTAG_PWD_ADDR3                              (0xff800000 + (0x068 << 2))
#define SEC_AO_SEC_JTAG_PWD_ADDR3                              (0xff800000 + (0x068 << 2))
#define   P_AO_SEC_JTAG_PWD_ADDR3                              (volatile uint32_t *)(0xff800000 + (0x068 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG0_0                      (0xff800000 + (0x070 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG0_0                      (0xff800000 + (0x070 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG0_0                      (volatile uint32_t *)(0xff800000 + (0x070 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG0_1                      (0xff800000 + (0x071 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG0_1                      (0xff800000 + (0x071 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG0_1                      (volatile uint32_t *)(0xff800000 + (0x071 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG0_2                      (0xff800000 + (0x072 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG0_2                      (0xff800000 + (0x072 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG0_2                      (volatile uint32_t *)(0xff800000 + (0x072 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG1_0                      (0xff800000 + (0x073 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG1_0                      (0xff800000 + (0x073 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG1_0                      (volatile uint32_t *)(0xff800000 + (0x073 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG1_1                      (0xff800000 + (0x074 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG1_1                      (0xff800000 + (0x074 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG1_1                      (volatile uint32_t *)(0xff800000 + (0x074 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG1_2                      (0xff800000 + (0x075 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG1_2                      (0xff800000 + (0x075 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG1_2                      (volatile uint32_t *)(0xff800000 + (0x075 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG2_0                      (0xff800000 + (0x076 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG2_0                      (0xff800000 + (0x076 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG2_0                      (volatile uint32_t *)(0xff800000 + (0x076 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG2_1                      (0xff800000 + (0x077 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG2_1                      (0xff800000 + (0x077 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG2_1                      (volatile uint32_t *)(0xff800000 + (0x077 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG2_2                      (0xff800000 + (0x078 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG2_2                      (0xff800000 + (0x078 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG2_2                      (volatile uint32_t *)(0xff800000 + (0x078 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG3_0                      (0xff800000 + (0x079 << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG3_0                      (0xff800000 + (0x079 << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG3_0                      (volatile uint32_t *)(0xff800000 + (0x079 << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG3_1                      (0xff800000 + (0x07a << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG3_1                      (0xff800000 + (0x07a << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG3_1                      (volatile uint32_t *)(0xff800000 + (0x07a << 2))
#define     AO_SEC_SHARED_AHB_SRAM_REG3_2                      (0xff800000 + (0x07b << 2))
#define SEC_AO_SEC_SHARED_AHB_SRAM_REG3_2                      (0xff800000 + (0x07b << 2))
#define   P_AO_SEC_SHARED_AHB_SRAM_REG3_2                      (volatile uint32_t *)(0xff800000 + (0x07b << 2))
#define     AO_SEC_AO_AHB_SRAM_REG0_0                          (0xff800000 + (0x07c << 2))
#define SEC_AO_SEC_AO_AHB_SRAM_REG0_0                          (0xff800000 + (0x07c << 2))
#define   P_AO_SEC_AO_AHB_SRAM_REG0_0                          (volatile uint32_t *)(0xff800000 + (0x07c << 2))
#define     AO_SEC_AO_AHB_SRAM_REG0_1                          (0xff800000 + (0x07d << 2))
#define SEC_AO_SEC_AO_AHB_SRAM_REG0_1                          (0xff800000 + (0x07d << 2))
#define   P_AO_SEC_AO_AHB_SRAM_REG0_1                          (volatile uint32_t *)(0xff800000 + (0x07d << 2))
#define     AO_SEC_AO_AHB_SRAM_REG1_0                          (0xff800000 + (0x07e << 2))
#define SEC_AO_SEC_AO_AHB_SRAM_REG1_0                          (0xff800000 + (0x07e << 2))
#define   P_AO_SEC_AO_AHB_SRAM_REG1_0                          (volatile uint32_t *)(0xff800000 + (0x07e << 2))
#define     AO_SEC_AO_AHB_SRAM_REG1_1                          (0xff800000 + (0x07f << 2))
#define SEC_AO_SEC_AO_AHB_SRAM_REG1_1                          (0xff800000 + (0x07f << 2))
#define   P_AO_SEC_AO_AHB_SRAM_REG1_1                          (volatile uint32_t *)(0xff800000 + (0x07f << 2))
#define     AO_SEC_SD_CFG0                                     (0xff800000 + (0x080 << 2))
#define SEC_AO_SEC_SD_CFG0                                     (0xff800000 + (0x080 << 2))
#define   P_AO_SEC_SD_CFG0                                     (volatile uint32_t *)(0xff800000 + (0x080 << 2))
#define     AO_SEC_SD_CFG1                                     (0xff800000 + (0x081 << 2))
#define SEC_AO_SEC_SD_CFG1                                     (0xff800000 + (0x081 << 2))
#define   P_AO_SEC_SD_CFG1                                     (volatile uint32_t *)(0xff800000 + (0x081 << 2))
#define     AO_SEC_SD_CFG2                                     (0xff800000 + (0x082 << 2))
#define SEC_AO_SEC_SD_CFG2                                     (0xff800000 + (0x082 << 2))
#define   P_AO_SEC_SD_CFG2                                     (volatile uint32_t *)(0xff800000 + (0x082 << 2))
#define     AO_SEC_SD_CFG3                                     (0xff800000 + (0x083 << 2))
#define SEC_AO_SEC_SD_CFG3                                     (0xff800000 + (0x083 << 2))
#define   P_AO_SEC_SD_CFG3                                     (volatile uint32_t *)(0xff800000 + (0x083 << 2))
#define     AO_SEC_SD_CFG4                                     (0xff800000 + (0x084 << 2))
#define SEC_AO_SEC_SD_CFG4                                     (0xff800000 + (0x084 << 2))
#define   P_AO_SEC_SD_CFG4                                     (volatile uint32_t *)(0xff800000 + (0x084 << 2))
#define     AO_SEC_SD_CFG5                                     (0xff800000 + (0x085 << 2))
#define SEC_AO_SEC_SD_CFG5                                     (0xff800000 + (0x085 << 2))
#define   P_AO_SEC_SD_CFG5                                     (volatile uint32_t *)(0xff800000 + (0x085 << 2))
#define     AO_SEC_SD_CFG6                                     (0xff800000 + (0x086 << 2))
#define SEC_AO_SEC_SD_CFG6                                     (0xff800000 + (0x086 << 2))
#define   P_AO_SEC_SD_CFG6                                     (volatile uint32_t *)(0xff800000 + (0x086 << 2))
#define     AO_SEC_SD_CFG7                                     (0xff800000 + (0x087 << 2))
#define SEC_AO_SEC_SD_CFG7                                     (0xff800000 + (0x087 << 2))
#define   P_AO_SEC_SD_CFG7                                     (volatile uint32_t *)(0xff800000 + (0x087 << 2))
#define     AO_SEC_SD_CFG8                                     (0xff800000 + (0x088 << 2))
#define SEC_AO_SEC_SD_CFG8                                     (0xff800000 + (0x088 << 2))
#define   P_AO_SEC_SD_CFG8                                     (volatile uint32_t *)(0xff800000 + (0x088 << 2))
#define     AO_SEC_SD_CFG9                                     (0xff800000 + (0x089 << 2))
#define SEC_AO_SEC_SD_CFG9                                     (0xff800000 + (0x089 << 2))
#define   P_AO_SEC_SD_CFG9                                     (volatile uint32_t *)(0xff800000 + (0x089 << 2))
#define     AO_SEC_SD_CFG10                                    (0xff800000 + (0x08a << 2))
#define SEC_AO_SEC_SD_CFG10                                    (0xff800000 + (0x08a << 2))
#define   P_AO_SEC_SD_CFG10                                    (volatile uint32_t *)(0xff800000 + (0x08a << 2))
#define     AO_SEC_SD_CFG11                                    (0xff800000 + (0x08b << 2))
#define SEC_AO_SEC_SD_CFG11                                    (0xff800000 + (0x08b << 2))
#define   P_AO_SEC_SD_CFG11                                    (volatile uint32_t *)(0xff800000 + (0x08b << 2))
#define     AO_SEC_SD_CFG12                                    (0xff800000 + (0x08c << 2))
#define SEC_AO_SEC_SD_CFG12                                    (0xff800000 + (0x08c << 2))
#define   P_AO_SEC_SD_CFG12                                    (volatile uint32_t *)(0xff800000 + (0x08c << 2))
#define     AO_SEC_SD_CFG13                                    (0xff800000 + (0x08d << 2))
#define SEC_AO_SEC_SD_CFG13                                    (0xff800000 + (0x08d << 2))
#define   P_AO_SEC_SD_CFG13                                    (volatile uint32_t *)(0xff800000 + (0x08d << 2))
#define     AO_SEC_SD_CFG14                                    (0xff800000 + (0x08e << 2))
#define SEC_AO_SEC_SD_CFG14                                    (0xff800000 + (0x08e << 2))
#define   P_AO_SEC_SD_CFG14                                    (volatile uint32_t *)(0xff800000 + (0x08e << 2))
#define     AO_SEC_SD_CFG15                                    (0xff800000 + (0x08f << 2))
#define SEC_AO_SEC_SD_CFG15                                    (0xff800000 + (0x08f << 2))
#define   P_AO_SEC_SD_CFG15                                    (volatile uint32_t *)(0xff800000 + (0x08f << 2))
#define     AO_SEC_GP_CFG0                                     (0xff800000 + (0x090 << 2))
#define SEC_AO_SEC_GP_CFG0                                     (0xff800000 + (0x090 << 2))
#define   P_AO_SEC_GP_CFG0                                     (volatile uint32_t *)(0xff800000 + (0x090 << 2))
#define     AO_SEC_GP_CFG1                                     (0xff800000 + (0x091 << 2))
#define SEC_AO_SEC_GP_CFG1                                     (0xff800000 + (0x091 << 2))
#define   P_AO_SEC_GP_CFG1                                     (volatile uint32_t *)(0xff800000 + (0x091 << 2))
#define     AO_SEC_GP_CFG2                                     (0xff800000 + (0x092 << 2))
#define SEC_AO_SEC_GP_CFG2                                     (0xff800000 + (0x092 << 2))
#define   P_AO_SEC_GP_CFG2                                     (volatile uint32_t *)(0xff800000 + (0x092 << 2))
#define     AO_SEC_GP_CFG3                                     (0xff800000 + (0x093 << 2))
#define SEC_AO_SEC_GP_CFG3                                     (0xff800000 + (0x093 << 2))
#define   P_AO_SEC_GP_CFG3                                     (volatile uint32_t *)(0xff800000 + (0x093 << 2))
#define     AO_SEC_GP_CFG4                                     (0xff800000 + (0x094 << 2))
#define SEC_AO_SEC_GP_CFG4                                     (0xff800000 + (0x094 << 2))
#define   P_AO_SEC_GP_CFG4                                     (volatile uint32_t *)(0xff800000 + (0x094 << 2))
#define     AO_SEC_GP_CFG5                                     (0xff800000 + (0x095 << 2))
#define SEC_AO_SEC_GP_CFG5                                     (0xff800000 + (0x095 << 2))
#define   P_AO_SEC_GP_CFG5                                     (volatile uint32_t *)(0xff800000 + (0x095 << 2))
#define     AO_SEC_GP_CFG6                                     (0xff800000 + (0x096 << 2))
#define SEC_AO_SEC_GP_CFG6                                     (0xff800000 + (0x096 << 2))
#define   P_AO_SEC_GP_CFG6                                     (volatile uint32_t *)(0xff800000 + (0x096 << 2))
#define     AO_SEC_GP_CFG7                                     (0xff800000 + (0x097 << 2))
#define SEC_AO_SEC_GP_CFG7                                     (0xff800000 + (0x097 << 2))
#define   P_AO_SEC_GP_CFG7                                     (volatile uint32_t *)(0xff800000 + (0x097 << 2))
#define     AO_SEC_GP_CFG8                                     (0xff800000 + (0x098 << 2))
#define SEC_AO_SEC_GP_CFG8                                     (0xff800000 + (0x098 << 2))
#define   P_AO_SEC_GP_CFG8                                     (volatile uint32_t *)(0xff800000 + (0x098 << 2))
#define     AO_SEC_GP_CFG9                                     (0xff800000 + (0x099 << 2))
#define SEC_AO_SEC_GP_CFG9                                     (0xff800000 + (0x099 << 2))
#define   P_AO_SEC_GP_CFG9                                     (volatile uint32_t *)(0xff800000 + (0x099 << 2))
#define     AO_SEC_GP_CFG10                                    (0xff800000 + (0x09a << 2))
#define SEC_AO_SEC_GP_CFG10                                    (0xff800000 + (0x09a << 2))
#define   P_AO_SEC_GP_CFG10                                    (volatile uint32_t *)(0xff800000 + (0x09a << 2))
#define     AO_SEC_GP_CFG11                                    (0xff800000 + (0x09b << 2))
#define SEC_AO_SEC_GP_CFG11                                    (0xff800000 + (0x09b << 2))
#define   P_AO_SEC_GP_CFG11                                    (volatile uint32_t *)(0xff800000 + (0x09b << 2))
#define     AO_SEC_GP_CFG12                                    (0xff800000 + (0x09c << 2))
#define SEC_AO_SEC_GP_CFG12                                    (0xff800000 + (0x09c << 2))
#define   P_AO_SEC_GP_CFG12                                    (volatile uint32_t *)(0xff800000 + (0x09c << 2))
#define     AO_SEC_GP_CFG13                                    (0xff800000 + (0x09d << 2))
#define SEC_AO_SEC_GP_CFG13                                    (0xff800000 + (0x09d << 2))
#define   P_AO_SEC_GP_CFG13                                    (volatile uint32_t *)(0xff800000 + (0x09d << 2))
#define     AO_SEC_GP_CFG14                                    (0xff800000 + (0x09e << 2))
#define SEC_AO_SEC_GP_CFG14                                    (0xff800000 + (0x09e << 2))
#define   P_AO_SEC_GP_CFG14                                    (volatile uint32_t *)(0xff800000 + (0x09e << 2))
#define     AO_SEC_GP_CFG15                                    (0xff800000 + (0x09f << 2))
#define SEC_AO_SEC_GP_CFG15                                    (0xff800000 + (0x09f << 2))
#define   P_AO_SEC_GP_CFG15                                    (volatile uint32_t *)(0xff800000 + (0x09f << 2))
//`define AO_CECB_CLK_CNTL_REG0           8'ha0
//`define AO_CECB_CLK_CNTL_REG1           8'ha1
//`define AO_CECB_GEN_CNTL                8'ha2
//`define AO_CECB_RW_REG                  8'ha3
//`define AO_CECB_INTR_MASKN              8'ha4
//`define AO_CECB_INTR_CLR                8'ha5
//`define AO_CECB_INTR_STAT               8'ha6
//`define AO_RTC_ADDR0                    8'h70 //TODO: DEFINE IF WE'RE IMPLEMENTING AO_RTC
//`define AO_RTC_ADDR1                    8'h71 //TODO: DEFINE IF WE'RE IMPLEMENTING AO_RTC
//`define AO_RTC_ADDR2                    8'h72 //TODO: DEFINE IF WE'RE IMPLEMENTING AO_RTC
//`define AO_RTC_ADDR3                    8'h73 //TODO: DEFINE IF WE'RE IMPLEMENTING AO_RTC
//`define AO_RTC_ADDR4                    8'h74 //TODO: DEFINE IF WE'RE IMPLEMENTING AO_RTC
#define     AO_MSG_INDEX0                                      (0xff800000 + (0x0b0 << 2))
#define SEC_AO_MSG_INDEX0                                      (0xff800000 + (0x0b0 << 2))
#define   P_AO_MSG_INDEX0                                      (volatile uint32_t *)(0xff800000 + (0x0b0 << 2))
#define     AO_MSG_INDEX1                                      (0xff800000 + (0x0b1 << 2))
#define SEC_AO_MSG_INDEX1                                      (0xff800000 + (0x0b1 << 2))
#define   P_AO_MSG_INDEX1                                      (volatile uint32_t *)(0xff800000 + (0x0b1 << 2))
#define     AO_MSG_INDEX2                                      (0xff800000 + (0x0b2 << 2))
#define SEC_AO_MSG_INDEX2                                      (0xff800000 + (0x0b2 << 2))
#define   P_AO_MSG_INDEX2                                      (volatile uint32_t *)(0xff800000 + (0x0b2 << 2))
#define     AO_MSG_INDEX3                                      (0xff800000 + (0x0b3 << 2))
#define SEC_AO_MSG_INDEX3                                      (0xff800000 + (0x0b3 << 2))
#define   P_AO_MSG_INDEX3                                      (volatile uint32_t *)(0xff800000 + (0x0b3 << 2))
// ----------------------------
// PWM C-D
// ----------------------------
//#define AO_PWM_CD_REG_BASE 0x02
// APB4_DECODER_NON_SECURE_BASE     32'hFF802000
// APB4_DECODER_SECURE_BASE         32'hFF802000
#define     AO_PWM_PWM_C                                       (0xff802000 + (0x000 << 2))
#define SEC_AO_PWM_PWM_C                                       (0xff802000 + (0x000 << 2))
#define   P_AO_PWM_PWM_C                                       (volatile uint32_t *)(0xff802000 + (0x000 << 2))
#define     AO_PWM_PWM_D                                       (0xff802000 + (0x001 << 2))
#define SEC_AO_PWM_PWM_D                                       (0xff802000 + (0x001 << 2))
#define   P_AO_PWM_PWM_D                                       (volatile uint32_t *)(0xff802000 + (0x001 << 2))
#define     AO_PWM_MISC_REG_CD                                 (0xff802000 + (0x002 << 2))
#define SEC_AO_PWM_MISC_REG_CD                                 (0xff802000 + (0x002 << 2))
#define   P_AO_PWM_MISC_REG_CD                                 (volatile uint32_t *)(0xff802000 + (0x002 << 2))
#define     AO_PWM_DELTA_SIGMA_CD                              (0xff802000 + (0x003 << 2))
#define SEC_AO_PWM_DELTA_SIGMA_CD                              (0xff802000 + (0x003 << 2))
#define   P_AO_PWM_DELTA_SIGMA_CD                              (volatile uint32_t *)(0xff802000 + (0x003 << 2))
#define     AO_PWM_TIME_CD                                     (0xff802000 + (0x004 << 2))
#define SEC_AO_PWM_TIME_CD                                     (0xff802000 + (0x004 << 2))
#define   P_AO_PWM_TIME_CD                                     (volatile uint32_t *)(0xff802000 + (0x004 << 2))
#define     AO_PWM_C2                                          (0xff802000 + (0x005 << 2))
#define SEC_AO_PWM_C2                                          (0xff802000 + (0x005 << 2))
#define   P_AO_PWM_C2                                          (volatile uint32_t *)(0xff802000 + (0x005 << 2))
#define     AO_PWM_D2                                          (0xff802000 + (0x006 << 2))
#define SEC_AO_PWM_D2                                          (0xff802000 + (0x006 << 2))
#define   P_AO_PWM_D2                                          (volatile uint32_t *)(0xff802000 + (0x006 << 2))
#define     AO_PWM_BLINK_CD                                    (0xff802000 + (0x007 << 2))
#define SEC_AO_PWM_BLINK_CD                                    (0xff802000 + (0x007 << 2))
#define   P_AO_PWM_BLINK_CD                                    (volatile uint32_t *)(0xff802000 + (0x007 << 2))
// ----------------------------
// UART
// ----------------------------
//#define AO_UART_REG_BASE 0x03
// APB4_DECODER_NON_SECURE_BASE     32'hFF803000
// APB4_DECODER_SECURE_BASE         32'hFF803000
#define     AO_UART_WFIFO                                      (0xff803000 + (0x000 << 2))
#define SEC_AO_UART_WFIFO                                      (0xff803000 + (0x000 << 2))
#define   P_AO_UART_WFIFO                                      (volatile uint32_t *)(0xff803000 + (0x000 << 2))
#define     AO_UART_RFIFO                                      (0xff803000 + (0x001 << 2))
#define SEC_AO_UART_RFIFO                                      (0xff803000 + (0x001 << 2))
#define   P_AO_UART_RFIFO                                      (volatile uint32_t *)(0xff803000 + (0x001 << 2))
#define     AO_UART_CONTROL                                    (0xff803000 + (0x002 << 2))
#define SEC_AO_UART_CONTROL                                    (0xff803000 + (0x002 << 2))
#define   P_AO_UART_CONTROL                                    (volatile uint32_t *)(0xff803000 + (0x002 << 2))
#define     AO_UART_STATUS                                     (0xff803000 + (0x003 << 2))
#define SEC_AO_UART_STATUS                                     (0xff803000 + (0x003 << 2))
#define   P_AO_UART_STATUS                                     (volatile uint32_t *)(0xff803000 + (0x003 << 2))
#define     AO_UART_MISC                                       (0xff803000 + (0x004 << 2))
#define SEC_AO_UART_MISC                                       (0xff803000 + (0x004 << 2))
#define   P_AO_UART_MISC                                       (volatile uint32_t *)(0xff803000 + (0x004 << 2))
#define     AO_UART_REG5                                       (0xff803000 + (0x005 << 2))
#define SEC_AO_UART_REG5                                       (0xff803000 + (0x005 << 2))
#define   P_AO_UART_REG5                                       (volatile uint32_t *)(0xff803000 + (0x005 << 2))
// ----------------------------
// UART2
// ----------------------------
//#define AO_UART2_REG_BASE 0x04
// APB4_DECODER_NON_SECURE_BASE     32'hFF804000
// APB4_DECODER_SECURE_BASE         32'hFF804000
#define     AO_UART2_WFIFO                                     (0xff804000 + (0x000 << 2))
#define SEC_AO_UART2_WFIFO                                     (0xff804000 + (0x000 << 2))
#define   P_AO_UART2_WFIFO                                     (volatile uint32_t *)(0xff804000 + (0x000 << 2))
#define     AO_UART2_RFIFO                                     (0xff804000 + (0x001 << 2))
#define SEC_AO_UART2_RFIFO                                     (0xff804000 + (0x001 << 2))
#define   P_AO_UART2_RFIFO                                     (volatile uint32_t *)(0xff804000 + (0x001 << 2))
#define     AO_UART2_CONTROL                                   (0xff804000 + (0x002 << 2))
#define SEC_AO_UART2_CONTROL                                   (0xff804000 + (0x002 << 2))
#define   P_AO_UART2_CONTROL                                   (volatile uint32_t *)(0xff804000 + (0x002 << 2))
#define     AO_UART2_STATUS                                    (0xff804000 + (0x003 << 2))
#define SEC_AO_UART2_STATUS                                    (0xff804000 + (0x003 << 2))
#define   P_AO_UART2_STATUS                                    (volatile uint32_t *)(0xff804000 + (0x003 << 2))
#define     AO_UART2_MISC                                      (0xff804000 + (0x004 << 2))
#define SEC_AO_UART2_MISC                                      (0xff804000 + (0x004 << 2))
#define   P_AO_UART2_MISC                                      (volatile uint32_t *)(0xff804000 + (0x004 << 2))
#define     AO_UART2_REG5                                      (0xff804000 + (0x005 << 2))
#define SEC_AO_UART2_REG5                                      (0xff804000 + (0x005 << 2))
#define   P_AO_UART2_REG5                                      (volatile uint32_t *)(0xff804000 + (0x005 << 2))
// ----------------------------
// I2C Master (8)
// ----------------------------
//#define AO_I2C_M_REG_BASE 0x05
// APB4_DECODER_NON_SECURE_BASE     32'hFF805000
// APB4_DECODER_SECURE_BASE         32'hFF805000
#define     AO_I2C_M_0_CONTROL_REG                             (0xff805000 + (0x000 << 2))
#define SEC_AO_I2C_M_0_CONTROL_REG                             (0xff805000 + (0x000 << 2))
#define   P_AO_I2C_M_0_CONTROL_REG                             (volatile uint32_t *)(0xff805000 + (0x000 << 2))
#define     AO_I2C_M_0_SLAVE_ADDR                              (0xff805000 + (0x001 << 2))
#define SEC_AO_I2C_M_0_SLAVE_ADDR                              (0xff805000 + (0x001 << 2))
#define   P_AO_I2C_M_0_SLAVE_ADDR                              (volatile uint32_t *)(0xff805000 + (0x001 << 2))
#define     AO_I2C_M_0_TOKEN_LIST0                             (0xff805000 + (0x002 << 2))
#define SEC_AO_I2C_M_0_TOKEN_LIST0                             (0xff805000 + (0x002 << 2))
#define   P_AO_I2C_M_0_TOKEN_LIST0                             (volatile uint32_t *)(0xff805000 + (0x002 << 2))
#define     AO_I2C_M_0_TOKEN_LIST1                             (0xff805000 + (0x003 << 2))
#define SEC_AO_I2C_M_0_TOKEN_LIST1                             (0xff805000 + (0x003 << 2))
#define   P_AO_I2C_M_0_TOKEN_LIST1                             (volatile uint32_t *)(0xff805000 + (0x003 << 2))
#define     AO_I2C_M_0_WDATA_REG0                              (0xff805000 + (0x004 << 2))
#define SEC_AO_I2C_M_0_WDATA_REG0                              (0xff805000 + (0x004 << 2))
#define   P_AO_I2C_M_0_WDATA_REG0                              (volatile uint32_t *)(0xff805000 + (0x004 << 2))
#define     AO_I2C_M_0_WDATA_REG1                              (0xff805000 + (0x005 << 2))
#define SEC_AO_I2C_M_0_WDATA_REG1                              (0xff805000 + (0x005 << 2))
#define   P_AO_I2C_M_0_WDATA_REG1                              (volatile uint32_t *)(0xff805000 + (0x005 << 2))
#define     AO_I2C_M_0_RDATA_REG0                              (0xff805000 + (0x006 << 2))
#define SEC_AO_I2C_M_0_RDATA_REG0                              (0xff805000 + (0x006 << 2))
#define   P_AO_I2C_M_0_RDATA_REG0                              (volatile uint32_t *)(0xff805000 + (0x006 << 2))
#define     AO_I2C_M_0_RDATA_REG1                              (0xff805000 + (0x007 << 2))
#define SEC_AO_I2C_M_0_RDATA_REG1                              (0xff805000 + (0x007 << 2))
#define   P_AO_I2C_M_0_RDATA_REG1                              (volatile uint32_t *)(0xff805000 + (0x007 << 2))
#define     AO_I2C_M_0_TIMEOUT_TH                              (0xff805000 + (0x008 << 2))
#define SEC_AO_I2C_M_0_TIMEOUT_TH                              (0xff805000 + (0x008 << 2))
#define   P_AO_I2C_M_0_TIMEOUT_TH                              (volatile uint32_t *)(0xff805000 + (0x008 << 2))
// ----------------------------
// I2C Slave (3)
// ----------------------------
//#define AO_I2C_S_REG_BASE 0x06
// APB4_DECODER_NON_SECURE_BASE     32'hFF806000
// APB4_DECODER_SECURE_BASE         32'hFF806000
#define     AO_I2C_S_CONTROL_REG                               (0xff806000 + (0x000 << 2))
#define SEC_AO_I2C_S_CONTROL_REG                               (0xff806000 + (0x000 << 2))
#define   P_AO_I2C_S_CONTROL_REG                               (volatile uint32_t *)(0xff806000 + (0x000 << 2))
#define     AO_I2C_S_SEND_REG                                  (0xff806000 + (0x001 << 2))
#define SEC_AO_I2C_S_SEND_REG                                  (0xff806000 + (0x001 << 2))
#define   P_AO_I2C_S_SEND_REG                                  (volatile uint32_t *)(0xff806000 + (0x001 << 2))
#define     AO_I2C_S_RECV_REG                                  (0xff806000 + (0x002 << 2))
#define SEC_AO_I2C_S_RECV_REG                                  (0xff806000 + (0x002 << 2))
#define   P_AO_I2C_S_RECV_REG                                  (volatile uint32_t *)(0xff806000 + (0x002 << 2))
#define     AO_I2C_S_CNTL1_REG                                 (0xff806000 + (0x003 << 2))
#define SEC_AO_I2C_S_CNTL1_REG                                 (0xff806000 + (0x003 << 2))
#define   P_AO_I2C_S_CNTL1_REG                                 (volatile uint32_t *)(0xff806000 + (0x003 << 2))
// ----------------------------
// PWM A-B
// ----------------------------
//#define AO_PWM_AB_REG_BASE 0x07
// APB4_DECODER_NON_SECURE_BASE     32'hFF807000
// APB4_DECODER_SECURE_BASE         32'hFF807000
#define     AO_PWM_PWM_A                                       (0xff807000 + (0x000 << 2))
#define SEC_AO_PWM_PWM_A                                       (0xff807000 + (0x000 << 2))
#define   P_AO_PWM_PWM_A                                       (volatile uint32_t *)(0xff807000 + (0x000 << 2))
#define     AO_PWM_PWM_B                                       (0xff807000 + (0x001 << 2))
#define SEC_AO_PWM_PWM_B                                       (0xff807000 + (0x001 << 2))
#define   P_AO_PWM_PWM_B                                       (volatile uint32_t *)(0xff807000 + (0x001 << 2))
#define     AO_PWM_MISC_REG_AB                                 (0xff807000 + (0x002 << 2))
#define SEC_AO_PWM_MISC_REG_AB                                 (0xff807000 + (0x002 << 2))
#define   P_AO_PWM_MISC_REG_AB                                 (volatile uint32_t *)(0xff807000 + (0x002 << 2))
#define     AO_PWM_DELTA_SIGMA_AB                              (0xff807000 + (0x003 << 2))
#define SEC_AO_PWM_DELTA_SIGMA_AB                              (0xff807000 + (0x003 << 2))
#define   P_AO_PWM_DELTA_SIGMA_AB                              (volatile uint32_t *)(0xff807000 + (0x003 << 2))
#define     AO_PWM_TIME_AB                                     (0xff807000 + (0x004 << 2))
#define SEC_AO_PWM_TIME_AB                                     (0xff807000 + (0x004 << 2))
#define   P_AO_PWM_TIME_AB                                     (volatile uint32_t *)(0xff807000 + (0x004 << 2))
#define     AO_PWM_A2                                          (0xff807000 + (0x005 << 2))
#define SEC_AO_PWM_A2                                          (0xff807000 + (0x005 << 2))
#define   P_AO_PWM_A2                                          (volatile uint32_t *)(0xff807000 + (0x005 << 2))
#define     AO_PWM_B2                                          (0xff807000 + (0x006 << 2))
#define SEC_AO_PWM_B2                                          (0xff807000 + (0x006 << 2))
#define   P_AO_PWM_B2                                          (volatile uint32_t *)(0xff807000 + (0x006 << 2))
#define     AO_PWM_BLINK_AB                                    (0xff807000 + (0x007 << 2))
#define SEC_AO_PWM_BLINK_AB                                    (0xff807000 + (0x007 << 2))
#define   P_AO_PWM_BLINK_AB                                    (volatile uint32_t *)(0xff807000 + (0x007 << 2))
// ----------------------------
// Multiformat IR Remote
// ----------------------------
//#define AO_MF_IR_DEC_REG_BASE 0x08
// APB4_DECODER_NON_SECURE_BASE     32'hFF808000
// APB4_DECODER_SECURE_BASE         32'hFF808000
#define     AO_IR_DEC_LDR_ACTIVE                               (0xff808000 + (0x000 << 2))
#define SEC_AO_IR_DEC_LDR_ACTIVE                               (0xff808000 + (0x000 << 2))
#define   P_AO_IR_DEC_LDR_ACTIVE                               (volatile uint32_t *)(0xff808000 + (0x000 << 2))
#define     AO_IR_DEC_LDR_IDLE                                 (0xff808000 + (0x001 << 2))
#define SEC_AO_IR_DEC_LDR_IDLE                                 (0xff808000 + (0x001 << 2))
#define   P_AO_IR_DEC_LDR_IDLE                                 (volatile uint32_t *)(0xff808000 + (0x001 << 2))
#define     AO_IR_DEC_LDR_REPEAT                               (0xff808000 + (0x002 << 2))
#define SEC_AO_IR_DEC_LDR_REPEAT                               (0xff808000 + (0x002 << 2))
#define   P_AO_IR_DEC_LDR_REPEAT                               (volatile uint32_t *)(0xff808000 + (0x002 << 2))
#define     AO_IR_DEC_BIT_0                                    (0xff808000 + (0x003 << 2))
#define SEC_AO_IR_DEC_BIT_0                                    (0xff808000 + (0x003 << 2))
#define   P_AO_IR_DEC_BIT_0                                    (volatile uint32_t *)(0xff808000 + (0x003 << 2))
#define     AO_IR_DEC_REG0                                     (0xff808000 + (0x004 << 2))
#define SEC_AO_IR_DEC_REG0                                     (0xff808000 + (0x004 << 2))
#define   P_AO_IR_DEC_REG0                                     (volatile uint32_t *)(0xff808000 + (0x004 << 2))
#define     AO_IR_DEC_FRAME                                    (0xff808000 + (0x005 << 2))
#define SEC_AO_IR_DEC_FRAME                                    (0xff808000 + (0x005 << 2))
#define   P_AO_IR_DEC_FRAME                                    (volatile uint32_t *)(0xff808000 + (0x005 << 2))
#define     AO_IR_DEC_STATUS                                   (0xff808000 + (0x006 << 2))
#define SEC_AO_IR_DEC_STATUS                                   (0xff808000 + (0x006 << 2))
#define   P_AO_IR_DEC_STATUS                                   (volatile uint32_t *)(0xff808000 + (0x006 << 2))
#define     AO_IR_DEC_REG1                                     (0xff808000 + (0x007 << 2))
#define SEC_AO_IR_DEC_REG1                                     (0xff808000 + (0x007 << 2))
#define   P_AO_IR_DEC_REG1                                     (volatile uint32_t *)(0xff808000 + (0x007 << 2))
#define     AO_MF_IR_DEC_LDR_ACTIVE                            (0xff808000 + (0x010 << 2))
#define SEC_AO_MF_IR_DEC_LDR_ACTIVE                            (0xff808000 + (0x010 << 2))
#define   P_AO_MF_IR_DEC_LDR_ACTIVE                            (volatile uint32_t *)(0xff808000 + (0x010 << 2))
#define     AO_MF_IR_DEC_LDR_IDLE                              (0xff808000 + (0x011 << 2))
#define SEC_AO_MF_IR_DEC_LDR_IDLE                              (0xff808000 + (0x011 << 2))
#define   P_AO_MF_IR_DEC_LDR_IDLE                              (volatile uint32_t *)(0xff808000 + (0x011 << 2))
#define     AO_MF_IR_DEC_LDR_REPEAT                            (0xff808000 + (0x012 << 2))
#define SEC_AO_MF_IR_DEC_LDR_REPEAT                            (0xff808000 + (0x012 << 2))
#define   P_AO_MF_IR_DEC_LDR_REPEAT                            (volatile uint32_t *)(0xff808000 + (0x012 << 2))
#define     AO_MF_IR_DEC_BIT_0                                 (0xff808000 + (0x013 << 2))
#define SEC_AO_MF_IR_DEC_BIT_0                                 (0xff808000 + (0x013 << 2))
#define   P_AO_MF_IR_DEC_BIT_0                                 (volatile uint32_t *)(0xff808000 + (0x013 << 2))
#define     AO_MF_IR_DEC_REG0                                  (0xff808000 + (0x014 << 2))
#define SEC_AO_MF_IR_DEC_REG0                                  (0xff808000 + (0x014 << 2))
#define   P_AO_MF_IR_DEC_REG0                                  (volatile uint32_t *)(0xff808000 + (0x014 << 2))
#define     AO_MF_IR_DEC_FRAME                                 (0xff808000 + (0x015 << 2))
#define SEC_AO_MF_IR_DEC_FRAME                                 (0xff808000 + (0x015 << 2))
#define   P_AO_MF_IR_DEC_FRAME                                 (volatile uint32_t *)(0xff808000 + (0x015 << 2))
#define     AO_MF_IR_DEC_STATUS                                (0xff808000 + (0x016 << 2))
#define SEC_AO_MF_IR_DEC_STATUS                                (0xff808000 + (0x016 << 2))
#define   P_AO_MF_IR_DEC_STATUS                                (volatile uint32_t *)(0xff808000 + (0x016 << 2))
#define     AO_MF_IR_DEC_REG1                                  (0xff808000 + (0x017 << 2))
#define SEC_AO_MF_IR_DEC_REG1                                  (0xff808000 + (0x017 << 2))
#define   P_AO_MF_IR_DEC_REG1                                  (volatile uint32_t *)(0xff808000 + (0x017 << 2))
#define     AO_MF_IR_DEC_REG2                                  (0xff808000 + (0x018 << 2))
#define SEC_AO_MF_IR_DEC_REG2                                  (0xff808000 + (0x018 << 2))
#define   P_AO_MF_IR_DEC_REG2                                  (volatile uint32_t *)(0xff808000 + (0x018 << 2))
#define     AO_MF_IR_DEC_DURATN2                               (0xff808000 + (0x019 << 2))
#define SEC_AO_MF_IR_DEC_DURATN2                               (0xff808000 + (0x019 << 2))
#define   P_AO_MF_IR_DEC_DURATN2                               (volatile uint32_t *)(0xff808000 + (0x019 << 2))
#define     AO_MF_IR_DEC_DURATN3                               (0xff808000 + (0x01a << 2))
#define SEC_AO_MF_IR_DEC_DURATN3                               (0xff808000 + (0x01a << 2))
#define   P_AO_MF_IR_DEC_DURATN3                               (volatile uint32_t *)(0xff808000 + (0x01a << 2))
#define     AO_MF_IR_DEC_FRAME1                                (0xff808000 + (0x01b << 2))
#define SEC_AO_MF_IR_DEC_FRAME1                                (0xff808000 + (0x01b << 2))
#define   P_AO_MF_IR_DEC_FRAME1                                (volatile uint32_t *)(0xff808000 + (0x01b << 2))
#define     AO_MF_IR_DEC_STATUS1                               (0xff808000 + (0x01c << 2))
#define SEC_AO_MF_IR_DEC_STATUS1                               (0xff808000 + (0x01c << 2))
#define   P_AO_MF_IR_DEC_STATUS1                               (volatile uint32_t *)(0xff808000 + (0x01c << 2))
#define     AO_MF_IR_DEC_STATUS2                               (0xff808000 + (0x01d << 2))
#define SEC_AO_MF_IR_DEC_STATUS2                               (0xff808000 + (0x01d << 2))
#define   P_AO_MF_IR_DEC_STATUS2                               (volatile uint32_t *)(0xff808000 + (0x01d << 2))
#define     AO_MF_IR_DEC_REG3                                  (0xff808000 + (0x01e << 2))
#define SEC_AO_MF_IR_DEC_REG3                                  (0xff808000 + (0x01e << 2))
#define   P_AO_MF_IR_DEC_REG3                                  (volatile uint32_t *)(0xff808000 + (0x01e << 2))
#define     AO_MF_IR_DEC_FRAME_RSV0                            (0xff808000 + (0x01f << 2))
#define SEC_AO_MF_IR_DEC_FRAME_RSV0                            (0xff808000 + (0x01f << 2))
#define   P_AO_MF_IR_DEC_FRAME_RSV0                            (volatile uint32_t *)(0xff808000 + (0x01f << 2))
#define     AO_MF_IR_DEC_FRAME_RSV1                            (0xff808000 + (0x020 << 2))
#define SEC_AO_MF_IR_DEC_FRAME_RSV1                            (0xff808000 + (0x020 << 2))
#define   P_AO_MF_IR_DEC_FRAME_RSV1                            (volatile uint32_t *)(0xff808000 + (0x020 << 2))
#define     AO_MF_IR_DEC_FILTE                                 (0xff808000 + (0x021 << 2))
#define SEC_AO_MF_IR_DEC_FILTE                                 (0xff808000 + (0x021 << 2))
#define   P_AO_MF_IR_DEC_FILTE                                 (volatile uint32_t *)(0xff808000 + (0x021 << 2))
#define     AO_MF_IR_DEC_IRQ_CTL                               (0xff808000 + (0x022 << 2))
#define SEC_AO_MF_IR_DEC_IRQ_CTL                               (0xff808000 + (0x022 << 2))
#define   P_AO_MF_IR_DEC_IRQ_CTL                               (volatile uint32_t *)(0xff808000 + (0x022 << 2))
#define     AO_MF_IR_DEC_FIFO_CTL                              (0xff808000 + (0x023 << 2))
#define SEC_AO_MF_IR_DEC_FIFO_CTL                              (0xff808000 + (0x023 << 2))
#define   P_AO_MF_IR_DEC_FIFO_CTL                              (volatile uint32_t *)(0xff808000 + (0x023 << 2))
#define     AO_MF_IR_DEC_WIDTH_NEW                             (0xff808000 + (0x024 << 2))
#define SEC_AO_MF_IR_DEC_WIDTH_NEW                             (0xff808000 + (0x024 << 2))
#define   P_AO_MF_IR_DEC_WIDTH_NEW                             (volatile uint32_t *)(0xff808000 + (0x024 << 2))
#define     AO_MF_IR_DEC_REPEAT_DET                            (0xff808000 + (0x025 << 2))
#define SEC_AO_MF_IR_DEC_REPEAT_DET                            (0xff808000 + (0x025 << 2))
#define   P_AO_MF_IR_DEC_REPEAT_DET                            (volatile uint32_t *)(0xff808000 + (0x025 << 2))
// ---------------------------
// SAR ADC
// ---------------------------
//#define AO_SAR_ADC_REG_BASE 0x09
// APB4_DECODER_NON_SECURE_BASE     32'hFF809000
// APB4_DECODER_SECURE_BASE         32'hFF809000
#define     AO_SAR_ADC_REG0                                    (0xff809000 + (0x000 << 2))
#define SEC_AO_SAR_ADC_REG0                                    (0xff809000 + (0x000 << 2))
#define   P_AO_SAR_ADC_REG0                                    (volatile uint32_t *)(0xff809000 + (0x000 << 2))
#define     AO_SAR_ADC_CHAN_LIST                               (0xff809000 + (0x001 << 2))
#define SEC_AO_SAR_ADC_CHAN_LIST                               (0xff809000 + (0x001 << 2))
#define   P_AO_SAR_ADC_CHAN_LIST                               (volatile uint32_t *)(0xff809000 + (0x001 << 2))
#define     AO_SAR_ADC_AVG_CNTL                                (0xff809000 + (0x002 << 2))
#define SEC_AO_SAR_ADC_AVG_CNTL                                (0xff809000 + (0x002 << 2))
#define   P_AO_SAR_ADC_AVG_CNTL                                (volatile uint32_t *)(0xff809000 + (0x002 << 2))
#define     AO_SAR_ADC_REG3                                    (0xff809000 + (0x003 << 2))
#define SEC_AO_SAR_ADC_REG3                                    (0xff809000 + (0x003 << 2))
#define   P_AO_SAR_ADC_REG3                                    (volatile uint32_t *)(0xff809000 + (0x003 << 2))
#define     AO_SAR_ADC_DELAY                                   (0xff809000 + (0x004 << 2))
#define SEC_AO_SAR_ADC_DELAY                                   (0xff809000 + (0x004 << 2))
#define   P_AO_SAR_ADC_DELAY                                   (volatile uint32_t *)(0xff809000 + (0x004 << 2))
#define     AO_SAR_ADC_LAST_RD                                 (0xff809000 + (0x005 << 2))
#define SEC_AO_SAR_ADC_LAST_RD                                 (0xff809000 + (0x005 << 2))
#define   P_AO_SAR_ADC_LAST_RD                                 (volatile uint32_t *)(0xff809000 + (0x005 << 2))
#define     AO_SAR_ADC_FIFO_RD                                 (0xff809000 + (0x006 << 2))
#define SEC_AO_SAR_ADC_FIFO_RD                                 (0xff809000 + (0x006 << 2))
#define   P_AO_SAR_ADC_FIFO_RD                                 (volatile uint32_t *)(0xff809000 + (0x006 << 2))
#define     AO_SAR_ADC_AUX_SW                                  (0xff809000 + (0x007 << 2))
#define SEC_AO_SAR_ADC_AUX_SW                                  (0xff809000 + (0x007 << 2))
#define   P_AO_SAR_ADC_AUX_SW                                  (volatile uint32_t *)(0xff809000 + (0x007 << 2))
#define     AO_SAR_ADC_CHAN_10_SW                              (0xff809000 + (0x008 << 2))
#define SEC_AO_SAR_ADC_CHAN_10_SW                              (0xff809000 + (0x008 << 2))
#define   P_AO_SAR_ADC_CHAN_10_SW                              (volatile uint32_t *)(0xff809000 + (0x008 << 2))
#define     AO_SAR_ADC_DETECT_IDLE_SW                          (0xff809000 + (0x009 << 2))
#define SEC_AO_SAR_ADC_DETECT_IDLE_SW                          (0xff809000 + (0x009 << 2))
#define   P_AO_SAR_ADC_DETECT_IDLE_SW                          (volatile uint32_t *)(0xff809000 + (0x009 << 2))
#define     AO_SAR_ADC_DELTA_10                                (0xff809000 + (0x00a << 2))
#define SEC_AO_SAR_ADC_DELTA_10                                (0xff809000 + (0x00a << 2))
#define   P_AO_SAR_ADC_DELTA_10                                (volatile uint32_t *)(0xff809000 + (0x00a << 2))
#define     AO_SAR_ADC_REG11                                   (0xff809000 + (0x00b << 2))
#define SEC_AO_SAR_ADC_REG11                                   (0xff809000 + (0x00b << 2))
#define   P_AO_SAR_ADC_REG11                                   (volatile uint32_t *)(0xff809000 + (0x00b << 2))
#define     AO_SAR_ADC_REG12                                   (0xff809000 + (0x00c << 2))
#define SEC_AO_SAR_ADC_REG12                                   (0xff809000 + (0x00c << 2))
#define   P_AO_SAR_ADC_REG12                                   (volatile uint32_t *)(0xff809000 + (0x00c << 2))
#define     AO_SAR_ADC_REG13                                   (0xff809000 + (0x00d << 2))
#define SEC_AO_SAR_ADC_REG13                                   (0xff809000 + (0x00d << 2))
#define   P_AO_SAR_ADC_REG13                                   (volatile uint32_t *)(0xff809000 + (0x00d << 2))
// ---------------------------
// RTC (4)
// ---------------------------
// Moved to the secure APB3 bus
// `define AO_RTC_ADDR0                8'hd0
// `define AO_RTC_ADDR1                8'hd1
// `define AO_RTC_ADDR2                8'hd2
// `define AO_RTC_ADDR3                8'hd3
// `define AO_RTC_ADDR4                8'hd4
//
// Closing file:  ./ao_rti_reg.h
//

//dummy define
#define     HHI_GP1_PLL_CNTL                                   (0xff63c000 + (0x16 << 2))
#define SEC_HHI_GP1_PLL_CNTL                                   (0xff63c000 + (0x16 << 2))
#define   P_HHI_GP1_PLL_CNTL                                   (volatile uint32_t *)(0xff63c000 + (0x16 << 2))
#define     HHI_GP1_PLL_CNTL2                                  (0xff63c000 + (0x17 << 2))
#define SEC_HHI_GP1_PLL_CNTL2                                  (0xff63c000 + (0x17 << 2))
#define   P_HHI_GP1_PLL_CNTL2                                  (volatile uint32_t *)(0xff63c000 + (0x17 << 2))
#define     HHI_GP1_PLL_CNTL3                                  (0xff63c000 + (0x18 << 2))
#define SEC_HHI_GP1_PLL_CNTL3                                  (0xff63c000 + (0x18 << 2))
#define   P_HHI_GP1_PLL_CNTL3                                  (volatile uint32_t *)(0xff63c000 + (0x18 << 2))
#define     HHI_GP1_PLL_CNTL4                                  (0xff63c000 + (0x19 << 2))
#define SEC_HHI_GP1_PLL_CNTL4                                  (0xff63c000 + (0x19 << 2))
#define   P_HHI_GP1_PLL_CNTL4                                  (volatile uint32_t *)(0xff63c000 + (0x19 << 2))
#define     HHI_GP1_PLL_CNTL5                                  (0xff63c000 + (0x1a << 2))
#define SEC_HHI_GP1_PLL_CNTL5                                  (0xff63c000 + (0x1a << 2))
#define   P_HHI_GP1_PLL_CNTL5                                  (volatile uint32_t *)(0xff63c000 + (0x1a << 2))
#define     HHI_VPU_MEM_PD_REG1                                (0xff63c000 + (0x42 << 2))
#define SEC_HHI_VPU_MEM_PD_REG1                                (0xff63c000 + (0x42 << 2))
#define   P_HHI_VPU_MEM_PD_REG1                                (volatile uint32_t *)(0xff63c000 + (0x42 << 2))
#define     HHI_VPU_CLKB_CNTL                                  (0xff63c000 + (0x83 << 2))
#define SEC_HHI_VPU_CLKB_CNTL                                  (0xff63c000 + (0x83 << 2))
#define   P_HHI_VPU_CLKB_CNTL                                  (volatile uint32_t *)(0xff63c000 + (0x83 << 2))

#endif // SECURE_APB_H
